// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S10103C2_nt  {
  virtual  ~S10103C2_nt(); // _ZN11S10103C2_ntD1Ev
  virtual void  v6(); // _ZN11S10103C2_nt2v6Ev
  S10103C2_nt(); // tgen
};
//SIG(-1 S10103C2_nt) C1{ vd v1}


 S10103C2_nt ::~S10103C2_nt(){ note_dtor("S10103C2_nt", this);}
void  S10103C2_nt ::v6(){vfunc_called(this, "_ZN11S10103C2_nt2v6Ev");}
S10103C2_nt ::S10103C2_nt(){ note_ctor("S10103C2_nt", this);} // tgen

//skip512 S10103C2_nt

#else // __cplusplus

extern void _ZN11S10103C2_ntC1Ev();
extern void _ZN11S10103C2_ntD1Ev();
Name_Map name_map_S10103C2_nt[] = {
  NSPAIR(_ZN11S10103C2_ntC1Ev),
  NSPAIR(_ZN11S10103C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10103C2_nt[];
extern void _ZN11S10103C2_ntD1Ev();
extern void _ZN11S10103C2_ntD0Ev();
extern void _ZN11S10103C2_nt2v6Ev();
static  VTBL_ENTRY vtc_S10103C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10103C2_nt[0]),
  (VTBL_ENTRY)&_ZN11S10103C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10103C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10103C2_nt2v6Ev,
};
extern VTBL_ENTRY _ZTI11S10103C2_nt[];
VTBL_ENTRY *P__ZTI11S10103C2_nt = _ZTI11S10103C2_nt; 
extern  VTBL_ENTRY _ZTV11S10103C2_nt[];
Class_Descriptor cd_S10103C2_nt = {  "S10103C2_nt", // class name
  0,0,//no base classes
  &(vtc_S10103C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S10103C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10103C2_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C3_nt  {
  void *s10103c3f0;
  virtual  ~S10103C3_nt(); // _ZN11S10103C3_ntD1Ev
  virtual void  v7(); // _ZN11S10103C3_nt2v7Ev
  virtual void  v8(); // _ZN11S10103C3_nt2v8Ev
  virtual void  v9(); // _ZN11S10103C3_nt2v9Ev
  virtual void  v10(); // _ZN11S10103C3_nt3v10Ev
  virtual void  v11(); // _ZN11S10103C3_nt3v11Ev
  S10103C3_nt(); // tgen
};
//SIG(-1 S10103C3_nt) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10103C3_nt ::~S10103C3_nt(){ note_dtor("S10103C3_nt", this);}
void  S10103C3_nt ::v7(){vfunc_called(this, "_ZN11S10103C3_nt2v7Ev");}
void  S10103C3_nt ::v8(){vfunc_called(this, "_ZN11S10103C3_nt2v8Ev");}
void  S10103C3_nt ::v9(){vfunc_called(this, "_ZN11S10103C3_nt2v9Ev");}
void  S10103C3_nt ::v10(){vfunc_called(this, "_ZN11S10103C3_nt3v10Ev");}
void  S10103C3_nt ::v11(){vfunc_called(this, "_ZN11S10103C3_nt3v11Ev");}
S10103C3_nt ::S10103C3_nt(){ note_ctor("S10103C3_nt", this);} // tgen

//skip512 S10103C3_nt

#else // __cplusplus

extern void _ZN11S10103C3_ntC1Ev();
extern void _ZN11S10103C3_ntD1Ev();
Name_Map name_map_S10103C3_nt[] = {
  NSPAIR(_ZN11S10103C3_ntC1Ev),
  NSPAIR(_ZN11S10103C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10103C3_nt[];
extern void _ZN11S10103C3_ntD1Ev();
extern void _ZN11S10103C3_ntD0Ev();
extern void _ZN11S10103C3_nt2v7Ev();
extern void _ZN11S10103C3_nt2v8Ev();
extern void _ZN11S10103C3_nt2v9Ev();
extern void _ZN11S10103C3_nt3v10Ev();
extern void _ZN11S10103C3_nt3v11Ev();
static  VTBL_ENTRY vtc_S10103C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10103C3_nt[0]),
  (VTBL_ENTRY)&_ZN11S10103C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI11S10103C3_nt[];
VTBL_ENTRY *P__ZTI11S10103C3_nt = _ZTI11S10103C3_nt; 
extern  VTBL_ENTRY _ZTV11S10103C3_nt[];
Class_Descriptor cd_S10103C3_nt = {  "S10103C3_nt", // class name
  0,0,//no base classes
  &(vtc_S10103C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI11S10103C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10103C3_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C7_nt  {
  void  mf10103c7(); // _ZN11S10103C7_nt9mf10103c7Ev
};
//SIG(-1 S10103C7_nt) C1{ m}


void  S10103C7_nt ::mf10103c7(){}

//skip512 S10103C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C6_nt  {
  void *s10103c6f0;
  int s10103c6f1;
  ::S10103C7_nt s10103c6f2;
  ::S10103C7_nt s10103c6f3;
  void  mf10103c6(); // _ZN11S10103C6_nt9mf10103c6Ev
};
//SIG(-1 S10103C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S10103C6_nt ::mf10103c6(){}

//skip512 S10103C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C5_nt  {
  ::S10103C6_nt s10103c5f0;
  ::S10103C6_nt s10103c5f1;
  char s10103c5f2;
  void  mf10103c5(); // _ZN11S10103C5_nt9mf10103c5Ev
  virtual  ~S10103C5_nt(); // _ZN11S10103C5_ntD1Ev
  S10103C5_nt(); // tgen
};
//SIG(-1 S10103C5_nt) C1{ vd m FC2{ m Fp Fi FC3{ m} FC3} FC2 Fc}


void  S10103C5_nt ::mf10103c5(){}
 S10103C5_nt ::~S10103C5_nt(){ note_dtor("S10103C5_nt", this);}
S10103C5_nt ::S10103C5_nt(){ note_ctor("S10103C5_nt", this);} // tgen

//skip512 S10103C5_nt

#else // __cplusplus

extern void _ZN11S10103C5_ntC1Ev();
extern void _ZN11S10103C5_ntD1Ev();
Name_Map name_map_S10103C5_nt[] = {
  NSPAIR(_ZN11S10103C5_ntC1Ev),
  NSPAIR(_ZN11S10103C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern void _ZN11S10103C5_ntD1Ev();
extern void _ZN11S10103C5_ntD0Ev();
static  VTBL_ENTRY vtc_S10103C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10103C5_nt[0]),
  (VTBL_ENTRY)&_ZN11S10103C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10103C5_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
VTBL_ENTRY *P__ZTI11S10103C5_nt = _ZTI11S10103C5_nt; 
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
Class_Descriptor cd_S10103C5_nt = {  "S10103C5_nt", // class name
  0,0,//no base classes
  &(vtc_S10103C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI11S10103C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10103C5_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C15  {
  void  mf10103c15(); // _ZN9S10103C1510mf10103c15Ev
};
//SIG(-1 S10103C15) C1{ m}


void  S10103C15 ::mf10103c15(){}

static void Test_S10103C15()
{
  {
    init_simple_test("S10103C15");
    S10103C15 lv;
    check2(sizeof(lv), 1, "sizeof(S10103C15)");
    check2(__alignof__(lv), 1, "__alignof__(S10103C15)");
  }
}
static Arrange_To_Call_Me vS10103C15(Test_S10103C15, "S10103C15", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C14_nt  {
  void *s10103c14f0;
  int s10103c14f1;
  ::S10103C15 s10103c14f2;
  void  mf10103c14(); // _ZN12S10103C14_nt10mf10103c14Ev
};
//SIG(-1 S10103C14_nt) C1{ m Fp Fi FC2{ m}}


void  S10103C14_nt ::mf10103c14(){}

//skip512 S10103C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C13_nt  {
  ::S10103C14_nt s10103c13f0;
  int s10103c13f1;
  void  mf10103c13(); // _ZN12S10103C13_nt10mf10103c13Ev
};
//SIG(-1 S10103C13_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S10103C13_nt ::mf10103c13(){}

//skip512 S10103C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C16_nt  {
  int s10103c16f0[4];
  void *s10103c16f1;
  char s10103c16f2;
  int s10103c16f3[2];
  void *s10103c16f4[2];
  void  mf10103c16(); // _ZN12S10103C16_nt10mf10103c16Ev
};
//SIG(-1 S10103C16_nt) C1{ m Fi[4] Fp Fc Fi[2] Fp[2]}


void  S10103C16_nt ::mf10103c16(){}

//skip512 S10103C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C17  {
  char s10103c17f0;
  int s10103c17f1[2];
  void *s10103c17f2;
  void  mf10103c17(); // _ZN9S10103C1710mf10103c17Ev
};
//SIG(-1 S10103C17) C1{ m Fc Fi[2] Fp}


void  S10103C17 ::mf10103c17(){}

static void Test_S10103C17()
{
  {
    init_simple_test("S10103C17");
    S10103C17 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10103C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C17)");
    check_field_offset(lv, s10103c17f0, 0, "S10103C17.s10103c17f0");
    check_field_offset(lv, s10103c17f1, 4, "S10103C17.s10103c17f1");
    check_field_offset(lv, s10103c17f2, ABISELECT(16,12), "S10103C17.s10103c17f2");
  }
}
static Arrange_To_Call_Me vS10103C17(Test_S10103C17, "S10103C17", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C12  {
  void *s10103c12f0;
  ::S10103C13_nt s10103c12f1;
  ::S10103C16_nt s10103c12f2;
  ::S10103C17 s10103c12f3;
  virtual  ~S10103C12(); // _ZN9S10103C12D1Ev
  virtual void  v14(); // _ZN9S10103C123v14Ev
  virtual void  v15(); // _ZN9S10103C123v15Ev
  virtual void  v16(); // _ZN9S10103C123v16Ev
  virtual void  v17(); // _ZN9S10103C123v17Ev
  virtual void  v18(); // _ZN9S10103C123v18Ev
  virtual void  v19(); // _ZN9S10103C123v19Ev
  virtual void  v20(); // _ZN9S10103C123v20Ev
  virtual void  v21(); // _ZN9S10103C123v21Ev
  virtual void  v22(); // _ZN9S10103C123v22Ev
  virtual void  v23(); // _ZN9S10103C123v23Ev
  virtual void  v24(); // _ZN9S10103C123v24Ev
  virtual void  v25(); // _ZN9S10103C123v25Ev
  virtual void  v26(); // _ZN9S10103C123v26Ev
  virtual void  v27(); // _ZN9S10103C123v27Ev
  virtual void  v28(); // _ZN9S10103C123v28Ev
  virtual void  v29(); // _ZN9S10103C123v29Ev
  virtual void  v30(); // _ZN9S10103C123v30Ev
  virtual void  v31(); // _ZN9S10103C123v31Ev
  virtual void  v32(); // _ZN9S10103C123v32Ev
  virtual void  v33(); // _ZN9S10103C123v33Ev
  virtual void  v34(); // _ZN9S10103C123v34Ev
  virtual void  v35(); // _ZN9S10103C123v35Ev
  virtual void  v36(); // _ZN9S10103C123v36Ev
  virtual void  v37(); // _ZN9S10103C123v37Ev
  S10103C12(); // tgen
};
//SIG(-1 S10103C12) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC6{ m Fc Fi[2] Fp}}


 S10103C12 ::~S10103C12(){ note_dtor("S10103C12", this);}
void  S10103C12 ::v14(){vfunc_called(this, "_ZN9S10103C123v14Ev");}
void  S10103C12 ::v15(){vfunc_called(this, "_ZN9S10103C123v15Ev");}
void  S10103C12 ::v16(){vfunc_called(this, "_ZN9S10103C123v16Ev");}
void  S10103C12 ::v17(){vfunc_called(this, "_ZN9S10103C123v17Ev");}
void  S10103C12 ::v18(){vfunc_called(this, "_ZN9S10103C123v18Ev");}
void  S10103C12 ::v19(){vfunc_called(this, "_ZN9S10103C123v19Ev");}
void  S10103C12 ::v20(){vfunc_called(this, "_ZN9S10103C123v20Ev");}
void  S10103C12 ::v21(){vfunc_called(this, "_ZN9S10103C123v21Ev");}
void  S10103C12 ::v22(){vfunc_called(this, "_ZN9S10103C123v22Ev");}
void  S10103C12 ::v23(){vfunc_called(this, "_ZN9S10103C123v23Ev");}
void  S10103C12 ::v24(){vfunc_called(this, "_ZN9S10103C123v24Ev");}
void  S10103C12 ::v25(){vfunc_called(this, "_ZN9S10103C123v25Ev");}
void  S10103C12 ::v26(){vfunc_called(this, "_ZN9S10103C123v26Ev");}
void  S10103C12 ::v27(){vfunc_called(this, "_ZN9S10103C123v27Ev");}
void  S10103C12 ::v28(){vfunc_called(this, "_ZN9S10103C123v28Ev");}
void  S10103C12 ::v29(){vfunc_called(this, "_ZN9S10103C123v29Ev");}
void  S10103C12 ::v30(){vfunc_called(this, "_ZN9S10103C123v30Ev");}
void  S10103C12 ::v31(){vfunc_called(this, "_ZN9S10103C123v31Ev");}
void  S10103C12 ::v32(){vfunc_called(this, "_ZN9S10103C123v32Ev");}
void  S10103C12 ::v33(){vfunc_called(this, "_ZN9S10103C123v33Ev");}
void  S10103C12 ::v34(){vfunc_called(this, "_ZN9S10103C123v34Ev");}
void  S10103C12 ::v35(){vfunc_called(this, "_ZN9S10103C123v35Ev");}
void  S10103C12 ::v36(){vfunc_called(this, "_ZN9S10103C123v36Ev");}
void  S10103C12 ::v37(){vfunc_called(this, "_ZN9S10103C123v37Ev");}
S10103C12 ::S10103C12(){ note_ctor("S10103C12", this);} // tgen

static void Test_S10103C12()
{
  extern Class_Descriptor cd_S10103C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S10103C12, buf);
    S10103C12 *dp, &lv = *(dp=new (buf) S10103C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S10103C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C12)");
    check_field_offset(lv, s10103c12f0, ABISELECT(8,4), "S10103C12.s10103c12f0");
    check_field_offset(lv, s10103c12f1, ABISELECT(16,8), "S10103C12.s10103c12f1");
    check_field_offset(lv, s10103c12f2, ABISELECT(40,24), "S10103C12.s10103c12f2");
    check_field_offset(lv, s10103c12f3, ABISELECT(96,64), "S10103C12.s10103c12f3");
    test_class_info(&lv, &cd_S10103C12);
    dp->~S10103C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C12(Test_S10103C12, "S10103C12", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN9S10103C12C1Ev();
extern void _ZN9S10103C12D1Ev();
Name_Map name_map_S10103C12[] = {
  NSPAIR(_ZN9S10103C12C1Ev),
  NSPAIR(_ZN9S10103C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10103C12[];
extern void _ZN9S10103C12D1Ev();
extern void _ZN9S10103C12D0Ev();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C12[0]),
  (VTBL_ENTRY)&_ZN9S10103C12D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C12D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
Class_Descriptor cd_S10103C12 = {  "S10103C12", // class name
  0,0,//no base classes
  &(vtc_S10103C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI9S10103C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10103C12),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C18  {
  int s10103c18f0[11];
};
//SIG(-1 S10103C18) C1{ Fi[11]}



static void Test_S10103C18()
{
  {
    init_simple_test("S10103C18");
    S10103C18 lv;
    check2(sizeof(lv), 44, "sizeof(S10103C18)");
    check2(__alignof__(lv), 4, "__alignof__(S10103C18)");
    check_field_offset(lv, s10103c18f0, 0, "S10103C18.s10103c18f0");
  }
}
static Arrange_To_Call_Me vS10103C18(Test_S10103C18, "S10103C18", 44);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C20_nt  {
  void *s10103c20f0;
  int s10103c20f1[2];
  ::S10103C15 s10103c20f2;
  void  mf10103c20(); // _ZN12S10103C20_nt10mf10103c20Ev
};
//SIG(-1 S10103C20_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S10103C20_nt ::mf10103c20(){}

//skip512 S10103C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C23_nt  {
  __tsi64 s10103c23f0[4];
};
//SIG(-1 S10103C23_nt) C1{ FL[4]}



//skip512 S10103C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C22_nt  {
  ::S10103C23_nt s10103c22f0;
  void  mf10103c22(); // _ZN12S10103C22_nt10mf10103c22Ev
};
//SIG(-1 S10103C22_nt) C1{ m FC2{ FL[4]}}


void  S10103C22_nt ::mf10103c22(){}

//skip512 S10103C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C19  {
  int s10103c19f0;
  ::S10103C20_nt s10103c19f1;
  ::S10103C22_nt s10103c19f2;
  void  mf10103c19(); // _ZN9S10103C1910mf10103c19Ev
  virtual  ~S10103C19(); // _ZN9S10103C19D1Ev
  S10103C19(); // tgen
};
//SIG(-1 S10103C19) C1{ vd m Fi FC2{ m Fp Fi[2] FC3{ m}} FC4{ m FC5{ FL[4]}}}


void  S10103C19 ::mf10103c19(){}
 S10103C19 ::~S10103C19(){ note_dtor("S10103C19", this);}
S10103C19 ::S10103C19(){ note_ctor("S10103C19", this);} // tgen

static void Test_S10103C19()
{
  extern Class_Descriptor cd_S10103C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S10103C19, buf);
    S10103C19 *dp, &lv = *(dp=new (buf) S10103C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S10103C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C19)");
    check_field_offset(lv, s10103c19f0, ABISELECT(8,4), "S10103C19.s10103c19f0");
    check_field_offset(lv, s10103c19f1, ABISELECT(16,8), "S10103C19.s10103c19f1");
    check_field_offset(lv, s10103c19f2, ABISELECT(40,24), "S10103C19.s10103c19f2");
    test_class_info(&lv, &cd_S10103C19);
    dp->~S10103C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C19(Test_S10103C19, "S10103C19", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN9S10103C19C1Ev();
extern void _ZN9S10103C19D1Ev();
Name_Map name_map_S10103C19[] = {
  NSPAIR(_ZN9S10103C19C1Ev),
  NSPAIR(_ZN9S10103C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10103C19[];
extern void _ZN9S10103C19D1Ev();
extern void _ZN9S10103C19D0Ev();
static  VTBL_ENTRY vtc_S10103C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C19[0]),
  (VTBL_ENTRY)&_ZN9S10103C19D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C19D0Ev,
};
extern VTBL_ENTRY _ZTI9S10103C19[];
extern  VTBL_ENTRY _ZTV9S10103C19[];
Class_Descriptor cd_S10103C19 = {  "S10103C19", // class name
  0,0,//no base classes
  &(vtc_S10103C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI9S10103C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10103C19),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C4  : S10103C5_nt , S10103C12 {
  int s10103c4f0;
  void *s10103c4f1[8];
  int s10103c4f2[2];
  ::S10103C18 s10103c4f3;
  int s10103c4f4[4];
  char s10103c4f5;
  ::S10103C19 s10103c4f6;
  void *s10103c4f7;
  virtual  ~S10103C4(); // _ZN8S10103C4D1Ev
  virtual void  v12(); // _ZN8S10103C43v12Ev
  virtual void  v13(); // _ZN8S10103C43v13Ev
  S10103C4(); // tgen
};
//SIG(-1 S10103C4) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 Fi Fp[8] Fi[2] FC11{ Fi[11]} Fi[4] Fc FC12{ vd m Fi FC13{ m Fp Fi[2] FC8} FC14{ m FC15{ FL[4]}}} Fp}


 S10103C4 ::~S10103C4(){ note_dtor("S10103C4", this);}
void  S10103C4 ::v12(){vfunc_called(this, "_ZN8S10103C43v12Ev");}
void  S10103C4 ::v13(){vfunc_called(this, "_ZN8S10103C43v13Ev");}
S10103C4 ::S10103C4(){ note_ctor("S10103C4", this);} // tgen

static void Test_S10103C4()
{
  extern Class_Descriptor cd_S10103C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S10103C4, buf);
    S10103C4 *dp, &lv = *(dp=new (buf) S10103C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S10103C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C4)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C4");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C4");
    check_field_offset(lv, s10103c4f0, ABISELECT(168,112), "S10103C4.s10103c4f0");
    check_field_offset(lv, s10103c4f1, ABISELECT(176,116), "S10103C4.s10103c4f1");
    check_field_offset(lv, s10103c4f2, ABISELECT(240,148), "S10103C4.s10103c4f2");
    check_field_offset(lv, s10103c4f3, ABISELECT(248,156), "S10103C4.s10103c4f3");
    check_field_offset(lv, s10103c4f4, ABISELECT(292,200), "S10103C4.s10103c4f4");
    check_field_offset(lv, s10103c4f5, ABISELECT(308,216), "S10103C4.s10103c4f5");
    check_field_offset(lv, s10103c4f6, ABISELECT(312,220), "S10103C4.s10103c4f6");
    check_field_offset(lv, s10103c4f7, ABISELECT(384,276), "S10103C4.s10103c4f7");
    test_class_info(&lv, &cd_S10103C4);
    dp->~S10103C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C4(Test_S10103C4, "S10103C4", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN8S10103C4C1Ev();
extern void _ZN8S10103C4D1Ev();
Name_Map name_map_S10103C4[] = {
  NSPAIR(_ZN8S10103C4C1Ev),
  NSPAIR(_ZN8S10103C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10103C4[];
extern void _ZN8S10103C4D1Ev();
extern void _ZN8S10103C4D0Ev();
extern void _ZN8S10103C43v12Ev();
extern void _ZN8S10103C43v13Ev();
extern void ABISELECT(_ZThn48_N8S10103C4D1Ev,_ZThn32_N8S10103C4D1Ev)();
extern void ABISELECT(_ZThn48_N8S10103C4D0Ev,_ZThn32_N8S10103C4D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10103C4[0]),
  (VTBL_ENTRY)&_ZN8S10103C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10103C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10103C43v12Ev,
  (VTBL_ENTRY)&_ZN8S10103C43v13Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8S10103C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10103C4D1Ev,_ZThn32_N8S10103C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10103C4D0Ev,_ZThn32_N8S10103C4D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI8S10103C4[];
extern  VTBL_ENTRY _ZTV8S10103C4[];
Class_Descriptor cd_S10103C4 = {  "S10103C4", // class name
  bases_S10103C4, 2,
  &(vtc_S10103C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI8S10103C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10103C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C25_nt  {
  int s10103c25f0[4];
};
//SIG(1 S10103C25_nt) C1{ Fi[4]}



//skip512 S10103C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C24  : S10103C5_nt , S10103C12 {
  ::S10103C25_nt s10103c24f0[2];
  ::S10103C25_nt s10103c24f1[2];
  ::S10103C25_nt s10103c24f2[2];
  ::S10103C25_nt s10103c24f3[2];
  virtual  ~S10103C24(); // _ZN9S10103C24D1Ev
  virtual void  v38(); // _ZN9S10103C243v38Ev
  virtual void  v39(); // _ZN9S10103C243v39Ev
  S10103C24(); // tgen
};
//SIG(-1 S10103C24) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 FC11{ Fi[4]}[2] FC11[2] FC11[2] FC11[2]}


 S10103C24 ::~S10103C24(){ note_dtor("S10103C24", this);}
void  S10103C24 ::v38(){vfunc_called(this, "_ZN9S10103C243v38Ev");}
void  S10103C24 ::v39(){vfunc_called(this, "_ZN9S10103C243v39Ev");}
S10103C24 ::S10103C24(){ note_ctor("S10103C24", this);} // tgen

static void Test_S10103C24()
{
  extern Class_Descriptor cd_S10103C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,61)];
    init_test(&cd_S10103C24, buf);
    S10103C24 *dp, &lv = *(dp=new (buf) S10103C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,240), "sizeof(S10103C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C24)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C24");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C24");
    check_field_offset(lv, s10103c24f0, ABISELECT(168,112), "S10103C24.s10103c24f0");
    check_field_offset(lv, s10103c24f1, ABISELECT(200,144), "S10103C24.s10103c24f1");
    check_field_offset(lv, s10103c24f2, ABISELECT(232,176), "S10103C24.s10103c24f2");
    check_field_offset(lv, s10103c24f3, ABISELECT(264,208), "S10103C24.s10103c24f3");
    test_class_info(&lv, &cd_S10103C24);
    dp->~S10103C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C24(Test_S10103C24, "S10103C24", ABISELECT(296,240));

#else // __cplusplus

extern void _ZN9S10103C24C1Ev();
extern void _ZN9S10103C24D1Ev();
Name_Map name_map_S10103C24[] = {
  NSPAIR(_ZN9S10103C24C1Ev),
  NSPAIR(_ZN9S10103C24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C24[];
extern void _ZN9S10103C24D1Ev();
extern void _ZN9S10103C24D0Ev();
extern void _ZN9S10103C243v38Ev();
extern void _ZN9S10103C243v39Ev();
extern void ABISELECT(_ZThn48_N9S10103C24D1Ev,_ZThn32_N9S10103C24D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C24D0Ev,_ZThn32_N9S10103C24D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C24[0]),
  (VTBL_ENTRY)&_ZN9S10103C24D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C24D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C243v38Ev,
  (VTBL_ENTRY)&_ZN9S10103C243v39Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C24D1Ev,_ZThn32_N9S10103C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C24D0Ev,_ZThn32_N9S10103C24D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C24[];
extern  VTBL_ENTRY _ZTV9S10103C24[];
Class_Descriptor cd_S10103C24 = {  "S10103C24", // class name
  bases_S10103C24, 2,
  &(vtc_S10103C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,240), // object size
  NSPAIRA(_ZTI9S10103C24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C24),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C26  : S10103C5_nt , S10103C12 {
  void *s10103c26f0[2];
  char s10103c26f1;
  ::S10103C25_nt s10103c26f2[2];
  ::S10103C25_nt s10103c26f3[2];
  ::S10103C25_nt s10103c26f4[2];
  ::S10103C25_nt s10103c26f5[2];
  virtual  ~S10103C26(); // _ZN9S10103C26D1Ev
  virtual void  v40(); // _ZN9S10103C263v40Ev
  virtual void  v41(); // _ZN9S10103C263v41Ev
  virtual void  v42(); // _ZN9S10103C263v42Ev
  virtual void  v43(); // _ZN9S10103C263v43Ev
  S10103C26(); // tgen
};
//SIG(-1 S10103C26) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4 Fp[2] Fc FC11{ Fi[4]}[2] FC11[2] FC11[2] FC11[2]}


 S10103C26 ::~S10103C26(){ note_dtor("S10103C26", this);}
void  S10103C26 ::v40(){vfunc_called(this, "_ZN9S10103C263v40Ev");}
void  S10103C26 ::v41(){vfunc_called(this, "_ZN9S10103C263v41Ev");}
void  S10103C26 ::v42(){vfunc_called(this, "_ZN9S10103C263v42Ev");}
void  S10103C26 ::v43(){vfunc_called(this, "_ZN9S10103C263v43Ev");}
S10103C26 ::S10103C26(){ note_ctor("S10103C26", this);} // tgen

static void Test_S10103C26()
{
  extern Class_Descriptor cd_S10103C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,64)];
    init_test(&cd_S10103C26, buf);
    S10103C26 *dp, &lv = *(dp=new (buf) S10103C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,252), "sizeof(S10103C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C26)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C26");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C26");
    check_field_offset(lv, s10103c26f0, ABISELECT(168,112), "S10103C26.s10103c26f0");
    check_field_offset(lv, s10103c26f1, ABISELECT(184,120), "S10103C26.s10103c26f1");
    check_field_offset(lv, s10103c26f2, ABISELECT(188,124), "S10103C26.s10103c26f2");
    check_field_offset(lv, s10103c26f3, ABISELECT(220,156), "S10103C26.s10103c26f3");
    check_field_offset(lv, s10103c26f4, ABISELECT(252,188), "S10103C26.s10103c26f4");
    check_field_offset(lv, s10103c26f5, ABISELECT(284,220), "S10103C26.s10103c26f5");
    test_class_info(&lv, &cd_S10103C26);
    dp->~S10103C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C26(Test_S10103C26, "S10103C26", ABISELECT(320,252));

#else // __cplusplus

extern void _ZN9S10103C26C1Ev();
extern void _ZN9S10103C26D1Ev();
Name_Map name_map_S10103C26[] = {
  NSPAIR(_ZN9S10103C26C1Ev),
  NSPAIR(_ZN9S10103C26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C26[];
extern void _ZN9S10103C26D1Ev();
extern void _ZN9S10103C26D0Ev();
extern void _ZN9S10103C263v40Ev();
extern void _ZN9S10103C263v41Ev();
extern void _ZN9S10103C263v42Ev();
extern void _ZN9S10103C263v43Ev();
extern void ABISELECT(_ZThn48_N9S10103C26D1Ev,_ZThn32_N9S10103C26D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C26D0Ev,_ZThn32_N9S10103C26D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C26[0]),
  (VTBL_ENTRY)&_ZN9S10103C26D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C26D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C263v40Ev,
  (VTBL_ENTRY)&_ZN9S10103C263v41Ev,
  (VTBL_ENTRY)&_ZN9S10103C263v42Ev,
  (VTBL_ENTRY)&_ZN9S10103C263v43Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C26D1Ev,_ZThn32_N9S10103C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C26D0Ev,_ZThn32_N9S10103C26D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C26[];
extern  VTBL_ENTRY _ZTV9S10103C26[];
Class_Descriptor cd_S10103C26 = {  "S10103C26", // class name
  bases_S10103C26, 2,
  &(vtc_S10103C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,252), // object size
  NSPAIRA(_ZTI9S10103C26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C26),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C28  : S10103C5_nt , S10103C12 {
  virtual  ~S10103C28(); // _ZN9S10103C28D1Ev
  virtual void  v47(); // _ZN9S10103C283v47Ev
  virtual void  v48(); // _ZN9S10103C283v48Ev
  virtual void  v49(); // _ZN9S10103C283v49Ev
  virtual void  v50(); // _ZN9S10103C283v50Ev
  virtual void  v51(); // _ZN9S10103C283v51Ev
  virtual void  v52(); // _ZN9S10103C283v52Ev
  virtual void  v53(); // _ZN9S10103C283v53Ev
  virtual void  v54(); // _ZN9S10103C283v54Ev
  virtual void  v55(); // _ZN9S10103C283v55Ev
  S10103C28(); // tgen
};
//SIG(-1 S10103C28) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S10103C28 ::~S10103C28(){ note_dtor("S10103C28", this);}
void  S10103C28 ::v47(){vfunc_called(this, "_ZN9S10103C283v47Ev");}
void  S10103C28 ::v48(){vfunc_called(this, "_ZN9S10103C283v48Ev");}
void  S10103C28 ::v49(){vfunc_called(this, "_ZN9S10103C283v49Ev");}
void  S10103C28 ::v50(){vfunc_called(this, "_ZN9S10103C283v50Ev");}
void  S10103C28 ::v51(){vfunc_called(this, "_ZN9S10103C283v51Ev");}
void  S10103C28 ::v52(){vfunc_called(this, "_ZN9S10103C283v52Ev");}
void  S10103C28 ::v53(){vfunc_called(this, "_ZN9S10103C283v53Ev");}
void  S10103C28 ::v54(){vfunc_called(this, "_ZN9S10103C283v54Ev");}
void  S10103C28 ::v55(){vfunc_called(this, "_ZN9S10103C283v55Ev");}
S10103C28 ::S10103C28(){ note_ctor("S10103C28", this);} // tgen

static void Test_S10103C28()
{
  extern Class_Descriptor cd_S10103C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,29)];
    init_test(&cd_S10103C28, buf);
    S10103C28 *dp, &lv = *(dp=new (buf) S10103C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S10103C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C28)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C28");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C28");
    test_class_info(&lv, &cd_S10103C28);
    dp->~S10103C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C28(Test_S10103C28, "S10103C28", ABISELECT(168,112));

#else // __cplusplus

extern void _ZN9S10103C28C1Ev();
extern void _ZN9S10103C28D1Ev();
Name_Map name_map_S10103C28[] = {
  NSPAIR(_ZN9S10103C28C1Ev),
  NSPAIR(_ZN9S10103C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C28[];
extern void _ZN9S10103C28D1Ev();
extern void _ZN9S10103C28D0Ev();
extern void _ZN9S10103C283v47Ev();
extern void _ZN9S10103C283v48Ev();
extern void _ZN9S10103C283v49Ev();
extern void _ZN9S10103C283v50Ev();
extern void _ZN9S10103C283v51Ev();
extern void _ZN9S10103C283v52Ev();
extern void _ZN9S10103C283v53Ev();
extern void _ZN9S10103C283v54Ev();
extern void _ZN9S10103C283v55Ev();
extern void ABISELECT(_ZThn48_N9S10103C28D1Ev,_ZThn32_N9S10103C28D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C28D0Ev,_ZThn32_N9S10103C28D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C28[0]),
  (VTBL_ENTRY)&_ZN9S10103C28D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C28D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v47Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v48Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v49Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v50Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v51Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v52Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v53Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v54Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v55Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C28D1Ev,_ZThn32_N9S10103C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C28D0Ev,_ZThn32_N9S10103C28D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C28[];
extern  VTBL_ENTRY _ZTV9S10103C28[];
Class_Descriptor cd_S10103C28 = {  "S10103C28", // class name
  bases_S10103C28, 2,
  &(vtc_S10103C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,112), // object size
  NSPAIRA(_ZTI9S10103C28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C28),41, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C29  {
  int s10103c29f0;
  void *s10103c29f1;
  int s10103c29f2;
  void *s10103c29f3[2];
  int s10103c29f4;
  void  mf10103c29(); // _ZN9S10103C2910mf10103c29Ev
};
//SIG(-1 S10103C29) C1{ m Fi Fp Fi Fp[2] Fi}


void  S10103C29 ::mf10103c29(){}

static void Test_S10103C29()
{
  {
    init_simple_test("S10103C29");
    S10103C29 lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S10103C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C29)");
    check_field_offset(lv, s10103c29f0, 0, "S10103C29.s10103c29f0");
    check_field_offset(lv, s10103c29f1, ABISELECT(8,4), "S10103C29.s10103c29f1");
    check_field_offset(lv, s10103c29f2, ABISELECT(16,8), "S10103C29.s10103c29f2");
    check_field_offset(lv, s10103c29f3, ABISELECT(24,12), "S10103C29.s10103c29f3");
    check_field_offset(lv, s10103c29f4, ABISELECT(40,20), "S10103C29.s10103c29f4");
  }
}
static Arrange_To_Call_Me vS10103C29(Test_S10103C29, "S10103C29", ABISELECT(48,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C31_nt  {
  __tsi64 s10103c31f0;
  void  mf10103c31(); // _ZN12S10103C31_nt10mf10103c31Ev
};
//SIG(-1 S10103C31_nt) C1{ m FL}


void  S10103C31_nt ::mf10103c31(){}

//skip512 S10103C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C30_nt  {
  ::S10103C31_nt s10103c30f0;
  void  mf10103c30(); // _ZN12S10103C30_nt10mf10103c30Ev
};
//SIG(-1 S10103C30_nt) C1{ m FC2{ m FL}}


void  S10103C30_nt ::mf10103c30(){}

//skip512 S10103C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C27  : S10103C28 {
  int s10103c27f0[2];
  ::S10103C29 s10103c27f1;
  ::S10103C14_nt s10103c27f2;
  ::S10103C14_nt s10103c27f3;
  ::S10103C14_nt s10103c27f4;
  ::S10103C14_nt s10103c27f5;
  ::S10103C30_nt s10103c27f6;
  __tsi64 s10103c27f7;
  int s10103c27f8;
  void *s10103c27f9;
  int s10103c27f10;
  char s10103c27f11;
  virtual  ~S10103C27(); // _ZN9S10103C27D1Ev
  virtual void  v44(); // _ZN9S10103C273v44Ev
  virtual void  v45(); // _ZN9S10103C273v45Ev
  virtual void  v46(); // _ZN9S10103C273v46Ev
  S10103C27(); // tgen
};
//SIG(-1 S10103C27) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC11{ m Fc Fi[2] Fp}} vd v28 v29 v30 v31 v32 v33 v34 v35 v36} vd v1 v2 v3 Fi[2] FC12{ m Fi Fp Fi Fp[2] Fi} FC8 FC8 FC8 FC8 FC13{ m FC14{ m FL}} FL Fi Fp Fi Fc}


 S10103C27 ::~S10103C27(){ note_dtor("S10103C27", this);}
void  S10103C27 ::v44(){vfunc_called(this, "_ZN9S10103C273v44Ev");}
void  S10103C27 ::v45(){vfunc_called(this, "_ZN9S10103C273v45Ev");}
void  S10103C27 ::v46(){vfunc_called(this, "_ZN9S10103C273v46Ev");}
S10103C27 ::S10103C27(){ note_ctor("S10103C27", this);} // tgen

static void Test_S10103C27()
{
  extern Class_Descriptor cd_S10103C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,57)];
    init_test(&cd_S10103C27, buf);
    S10103C27 *dp, &lv = *(dp=new (buf) S10103C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,224), "sizeof(S10103C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C27)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C28*), 0, "S10103C27");
    check_base_class_offset(lv, (S10103C12*)(S10103C28*), ABISELECT(48,32), "S10103C27");
    check_base_class_offset(lv, (S10103C28*), 0, "S10103C27");
    check_field_offset(lv, s10103c27f0, ABISELECT(168,112), "S10103C27.s10103c27f0");
    check_field_offset(lv, s10103c27f1, ABISELECT(176,120), "S10103C27.s10103c27f1");
    check_field_offset(lv, s10103c27f2, ABISELECT(224,144), "S10103C27.s10103c27f2");
    check_field_offset(lv, s10103c27f3, ABISELECT(240,156), "S10103C27.s10103c27f3");
    check_field_offset(lv, s10103c27f4, ABISELECT(256,168), "S10103C27.s10103c27f4");
    check_field_offset(lv, s10103c27f5, ABISELECT(272,180), "S10103C27.s10103c27f5");
    check_field_offset(lv, s10103c27f6, ABISELECT(288,192), "S10103C27.s10103c27f6");
    check_field_offset(lv, s10103c27f7, ABISELECT(296,200), "S10103C27.s10103c27f7");
    check_field_offset(lv, s10103c27f8, ABISELECT(304,208), "S10103C27.s10103c27f8");
    check_field_offset(lv, s10103c27f9, ABISELECT(312,212), "S10103C27.s10103c27f9");
    check_field_offset(lv, s10103c27f10, ABISELECT(320,216), "S10103C27.s10103c27f10");
    check_field_offset(lv, s10103c27f11, ABISELECT(324,220), "S10103C27.s10103c27f11");
    test_class_info(&lv, &cd_S10103C27);
    dp->~S10103C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C27(Test_S10103C27, "S10103C27", ABISELECT(328,224));

#else // __cplusplus

extern void _ZN9S10103C27C1Ev();
extern void _ZN9S10103C27D1Ev();
Name_Map name_map_S10103C27[] = {
  NSPAIR(_ZN9S10103C27C1Ev),
  NSPAIR(_ZN9S10103C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
extern Class_Descriptor cd_S10103C28;
extern VTBL_ENTRY _ZTI9S10103C28[];
extern  VTBL_ENTRY _ZTV9S10103C28[];
static Base_Class bases_S10103C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C27[];
extern void _ZN9S10103C27D1Ev();
extern void _ZN9S10103C27D0Ev();
extern void _ZN9S10103C283v47Ev();
extern void _ZN9S10103C283v48Ev();
extern void _ZN9S10103C283v49Ev();
extern void _ZN9S10103C283v50Ev();
extern void _ZN9S10103C283v51Ev();
extern void _ZN9S10103C283v52Ev();
extern void _ZN9S10103C283v53Ev();
extern void _ZN9S10103C283v54Ev();
extern void _ZN9S10103C283v55Ev();
extern void _ZN9S10103C273v44Ev();
extern void _ZN9S10103C273v45Ev();
extern void _ZN9S10103C273v46Ev();
extern void ABISELECT(_ZThn48_N9S10103C27D1Ev,_ZThn32_N9S10103C27D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C27D0Ev,_ZThn32_N9S10103C27D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C27[0]),
  (VTBL_ENTRY)&_ZN9S10103C27D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C27D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v47Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v48Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v49Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v50Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v51Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v52Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v53Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v54Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v55Ev,
  (VTBL_ENTRY)&_ZN9S10103C273v44Ev,
  (VTBL_ENTRY)&_ZN9S10103C273v45Ev,
  (VTBL_ENTRY)&_ZN9S10103C273v46Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C27D1Ev,_ZThn32_N9S10103C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C27D0Ev,_ZThn32_N9S10103C27D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C27[];
extern  VTBL_ENTRY _ZTV9S10103C27[];
Class_Descriptor cd_S10103C27 = {  "S10103C27", // class name
  bases_S10103C27, 3,
  &(vtc_S10103C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,224), // object size
  NSPAIRA(_ZTI9S10103C27),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C27),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C32  : S10103C28 {
  ::S10103C29 s10103c32f0;
  ::S10103C14_nt s10103c32f1;
  ::S10103C14_nt s10103c32f2;
  void *s10103c32f3;
  int s10103c32f4;
  virtual  ~S10103C32(); // _ZN9S10103C32D1Ev
  virtual void  v56(); // _ZN9S10103C323v56Ev
  virtual void  v57(); // _ZN9S10103C323v57Ev
  virtual void  v58(); // _ZN9S10103C323v58Ev
  S10103C32(); // tgen
};
//SIG(-1 S10103C32) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC11{ m Fc Fi[2] Fp}} vd v28 v29 v30 v31 v32 v33 v34 v35 v36} vd v1 v2 v3 FC12{ m Fi Fp Fi Fp[2] Fi} FC8 FC8 Fp Fi}


 S10103C32 ::~S10103C32(){ note_dtor("S10103C32", this);}
void  S10103C32 ::v56(){vfunc_called(this, "_ZN9S10103C323v56Ev");}
void  S10103C32 ::v57(){vfunc_called(this, "_ZN9S10103C323v57Ev");}
void  S10103C32 ::v58(){vfunc_called(this, "_ZN9S10103C323v58Ev");}
S10103C32 ::S10103C32(){ note_ctor("S10103C32", this);} // tgen

static void Test_S10103C32()
{
  extern Class_Descriptor cd_S10103C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,43)];
    init_test(&cd_S10103C32, buf);
    S10103C32 *dp, &lv = *(dp=new (buf) S10103C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,168), "sizeof(S10103C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C32)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C28*), 0, "S10103C32");
    check_base_class_offset(lv, (S10103C12*)(S10103C28*), ABISELECT(48,32), "S10103C32");
    check_base_class_offset(lv, (S10103C28*), 0, "S10103C32");
    check_field_offset(lv, s10103c32f0, ABISELECT(168,112), "S10103C32.s10103c32f0");
    check_field_offset(lv, s10103c32f1, ABISELECT(216,136), "S10103C32.s10103c32f1");
    check_field_offset(lv, s10103c32f2, ABISELECT(232,148), "S10103C32.s10103c32f2");
    check_field_offset(lv, s10103c32f3, ABISELECT(248,160), "S10103C32.s10103c32f3");
    check_field_offset(lv, s10103c32f4, ABISELECT(256,164), "S10103C32.s10103c32f4");
    test_class_info(&lv, &cd_S10103C32);
    dp->~S10103C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C32(Test_S10103C32, "S10103C32", ABISELECT(264,168));

#else // __cplusplus

extern void _ZN9S10103C32C1Ev();
extern void _ZN9S10103C32D1Ev();
Name_Map name_map_S10103C32[] = {
  NSPAIR(_ZN9S10103C32C1Ev),
  NSPAIR(_ZN9S10103C32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
extern Class_Descriptor cd_S10103C28;
extern VTBL_ENTRY _ZTI9S10103C28[];
extern  VTBL_ENTRY _ZTV9S10103C28[];
static Base_Class bases_S10103C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C32[];
extern void _ZN9S10103C32D1Ev();
extern void _ZN9S10103C32D0Ev();
extern void _ZN9S10103C283v47Ev();
extern void _ZN9S10103C283v48Ev();
extern void _ZN9S10103C283v49Ev();
extern void _ZN9S10103C283v50Ev();
extern void _ZN9S10103C283v51Ev();
extern void _ZN9S10103C283v52Ev();
extern void _ZN9S10103C283v53Ev();
extern void _ZN9S10103C283v54Ev();
extern void _ZN9S10103C283v55Ev();
extern void _ZN9S10103C323v56Ev();
extern void _ZN9S10103C323v57Ev();
extern void _ZN9S10103C323v58Ev();
extern void ABISELECT(_ZThn48_N9S10103C32D1Ev,_ZThn32_N9S10103C32D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C32D0Ev,_ZThn32_N9S10103C32D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C32[0]),
  (VTBL_ENTRY)&_ZN9S10103C32D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C32D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v47Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v48Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v49Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v50Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v51Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v52Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v53Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v54Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v55Ev,
  (VTBL_ENTRY)&_ZN9S10103C323v56Ev,
  (VTBL_ENTRY)&_ZN9S10103C323v57Ev,
  (VTBL_ENTRY)&_ZN9S10103C323v58Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C32[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C32D1Ev,_ZThn32_N9S10103C32D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C32D0Ev,_ZThn32_N9S10103C32D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C32[];
extern  VTBL_ENTRY _ZTV9S10103C32[];
Class_Descriptor cd_S10103C32 = {  "S10103C32", // class name
  bases_S10103C32, 3,
  &(vtc_S10103C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,168), // object size
  NSPAIRA(_ZTI9S10103C32),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C32),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C33  : S10103C5_nt , S10103C12 {
  void *s10103c33f0;
  virtual  ~S10103C33(); // _ZN9S10103C33D1Ev
  virtual void  v59(); // _ZN9S10103C333v59Ev
  virtual void  v60(); // _ZN9S10103C333v60Ev
  virtual void  v61(); // _ZN9S10103C333v61Ev
  S10103C33(); // tgen
};
//SIG(-1 S10103C33) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 Fp}


 S10103C33 ::~S10103C33(){ note_dtor("S10103C33", this);}
void  S10103C33 ::v59(){vfunc_called(this, "_ZN9S10103C333v59Ev");}
void  S10103C33 ::v60(){vfunc_called(this, "_ZN9S10103C333v60Ev");}
void  S10103C33 ::v61(){vfunc_called(this, "_ZN9S10103C333v61Ev");}
S10103C33 ::S10103C33(){ note_ctor("S10103C33", this);} // tgen

static void Test_S10103C33()
{
  extern Class_Descriptor cd_S10103C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,30)];
    init_test(&cd_S10103C33, buf);
    S10103C33 *dp, &lv = *(dp=new (buf) S10103C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,116), "sizeof(S10103C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C33)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C33");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C33");
    check_field_offset(lv, s10103c33f0, ABISELECT(168,112), "S10103C33.s10103c33f0");
    test_class_info(&lv, &cd_S10103C33);
    dp->~S10103C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C33(Test_S10103C33, "S10103C33", ABISELECT(176,116));

#else // __cplusplus

extern void _ZN9S10103C33C1Ev();
extern void _ZN9S10103C33D1Ev();
Name_Map name_map_S10103C33[] = {
  NSPAIR(_ZN9S10103C33C1Ev),
  NSPAIR(_ZN9S10103C33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C33[];
extern void _ZN9S10103C33D1Ev();
extern void _ZN9S10103C33D0Ev();
extern void _ZN9S10103C333v59Ev();
extern void _ZN9S10103C333v60Ev();
extern void _ZN9S10103C333v61Ev();
extern void ABISELECT(_ZThn48_N9S10103C33D1Ev,_ZThn32_N9S10103C33D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C33D0Ev,_ZThn32_N9S10103C33D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C33[0]),
  (VTBL_ENTRY)&_ZN9S10103C33D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C33D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C333v59Ev,
  (VTBL_ENTRY)&_ZN9S10103C333v60Ev,
  (VTBL_ENTRY)&_ZN9S10103C333v61Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C33D1Ev,_ZThn32_N9S10103C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C33D0Ev,_ZThn32_N9S10103C33D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C33[];
extern  VTBL_ENTRY _ZTV9S10103C33[];
Class_Descriptor cd_S10103C33 = {  "S10103C33", // class name
  bases_S10103C33, 2,
  &(vtc_S10103C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,116), // object size
  NSPAIRA(_ZTI9S10103C33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C33),35, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C36  {
  void  mf10103c36(); // _ZN9S10103C3610mf10103c36Ev
};
//SIG(-1 S10103C36) C1{ m}


void  S10103C36 ::mf10103c36(){}

static void Test_S10103C36()
{
  {
    init_simple_test("S10103C36");
    S10103C36 lv;
    check2(sizeof(lv), 1, "sizeof(S10103C36)");
    check2(__alignof__(lv), 1, "__alignof__(S10103C36)");
  }
}
static Arrange_To_Call_Me vS10103C36(Test_S10103C36, "S10103C36", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C35  {
  void *s10103c35f0;
  int s10103c35f1;
  ::S10103C36 s10103c35f2;
  ::S10103C36 s10103c35f3;
  void  mf10103c35(); // _ZN9S10103C3510mf10103c35Ev
};
//SIG(-1 S10103C35) C1{ m Fp Fi FC2{ m} FC2}


void  S10103C35 ::mf10103c35(){}

static void Test_S10103C35()
{
  {
    init_simple_test("S10103C35");
    S10103C35 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10103C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C35)");
    check_field_offset(lv, s10103c35f0, 0, "S10103C35.s10103c35f0");
    check_field_offset(lv, s10103c35f1, ABISELECT(8,4), "S10103C35.s10103c35f1");
    check_field_offset(lv, s10103c35f2, ABISELECT(12,8), "S10103C35.s10103c35f2");
    check_field_offset(lv, s10103c35f3, ABISELECT(13,9), "S10103C35.s10103c35f3");
  }
}
static Arrange_To_Call_Me vS10103C35(Test_S10103C35, "S10103C35", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S10103C35 = {  "S10103C35", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C34  : S10103C5_nt , S10103C12 {
  void *s10103c34f0;
  ::S10103C35 s10103c34f1;
  ::S10103C14_nt s10103c34f2;
  ::S10103C14_nt s10103c34f3;
  int s10103c34f4[2];
  char s10103c34f5;
  int s10103c34f6[2];
  virtual  ~S10103C34(); // _ZN9S10103C34D1Ev
  virtual void  v62(); // _ZN9S10103C343v62Ev
  virtual void  v63(); // _ZN9S10103C343v63Ev
  S10103C34(); // tgen
};
//SIG(-1 S10103C34) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 Fp FC11{ m Fp Fi FC12{ m} FC12} FC7 FC7 Fi[2] Fc Fi[2]}


 S10103C34 ::~S10103C34(){ note_dtor("S10103C34", this);}
void  S10103C34 ::v62(){vfunc_called(this, "_ZN9S10103C343v62Ev");}
void  S10103C34 ::v63(){vfunc_called(this, "_ZN9S10103C343v63Ev");}
S10103C34 ::S10103C34(){ note_ctor("S10103C34", this);} // tgen

static void Test_S10103C34()
{
  extern Class_Descriptor cd_S10103C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,44)];
    init_test(&cd_S10103C34, buf);
    S10103C34 *dp, &lv = *(dp=new (buf) S10103C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,172), "sizeof(S10103C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C34)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C34");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C34");
    check_field_offset(lv, s10103c34f0, ABISELECT(168,112), "S10103C34.s10103c34f0");
    check_field_offset(lv, s10103c34f1, ABISELECT(176,116), "S10103C34.s10103c34f1");
    check_field_offset(lv, s10103c34f2, ABISELECT(192,128), "S10103C34.s10103c34f2");
    check_field_offset(lv, s10103c34f3, ABISELECT(208,140), "S10103C34.s10103c34f3");
    check_field_offset(lv, s10103c34f4, ABISELECT(224,152), "S10103C34.s10103c34f4");
    check_field_offset(lv, s10103c34f5, ABISELECT(232,160), "S10103C34.s10103c34f5");
    check_field_offset(lv, s10103c34f6, ABISELECT(236,164), "S10103C34.s10103c34f6");
    test_class_info(&lv, &cd_S10103C34);
    dp->~S10103C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C34(Test_S10103C34, "S10103C34", ABISELECT(248,172));

#else // __cplusplus

extern void _ZN9S10103C34C1Ev();
extern void _ZN9S10103C34D1Ev();
Name_Map name_map_S10103C34[] = {
  NSPAIR(_ZN9S10103C34C1Ev),
  NSPAIR(_ZN9S10103C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C34[];
extern void _ZN9S10103C34D1Ev();
extern void _ZN9S10103C34D0Ev();
extern void _ZN9S10103C343v62Ev();
extern void _ZN9S10103C343v63Ev();
extern void ABISELECT(_ZThn48_N9S10103C34D1Ev,_ZThn32_N9S10103C34D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C34D0Ev,_ZThn32_N9S10103C34D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C34[0]),
  (VTBL_ENTRY)&_ZN9S10103C34D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C34D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C343v62Ev,
  (VTBL_ENTRY)&_ZN9S10103C343v63Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C34[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C34D1Ev,_ZThn32_N9S10103C34D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C34D0Ev,_ZThn32_N9S10103C34D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C34[];
extern  VTBL_ENTRY _ZTV9S10103C34[];
Class_Descriptor cd_S10103C34 = {  "S10103C34", // class name
  bases_S10103C34, 2,
  &(vtc_S10103C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,172), // object size
  NSPAIRA(_ZTI9S10103C34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C34),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C38  : S10103C5_nt {
  char s10103c38f0;
  void *s10103c38f1[2];
  virtual  ~S10103C38(); // _ZN9S10103C38D1Ev
  S10103C38(); // tgen
};
//SIG(-1 S10103C38) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd Fc Fp[2]}


 S10103C38 ::~S10103C38(){ note_dtor("S10103C38", this);}
S10103C38 ::S10103C38(){ note_ctor("S10103C38", this);} // tgen

static void Test_S10103C38()
{
  extern Class_Descriptor cd_S10103C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S10103C38, buf);
    S10103C38 *dp, &lv = *(dp=new (buf) S10103C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S10103C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C38)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C38");
    check_field_offset(lv, s10103c38f0, ABISELECT(41,29), "S10103C38.s10103c38f0");
    check_field_offset(lv, s10103c38f1, ABISELECT(48,32), "S10103C38.s10103c38f1");
    test_class_info(&lv, &cd_S10103C38);
    dp->~S10103C38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C38(Test_S10103C38, "S10103C38", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN9S10103C38C1Ev();
extern void _ZN9S10103C38D1Ev();
Name_Map name_map_S10103C38[] = {
  NSPAIR(_ZN9S10103C38C1Ev),
  NSPAIR(_ZN9S10103C38D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10103C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C38[];
extern void _ZN9S10103C38D1Ev();
extern void _ZN9S10103C38D0Ev();
static  VTBL_ENTRY vtc_S10103C38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C38[0]),
  (VTBL_ENTRY)&_ZN9S10103C38D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C38D0Ev,
};
extern VTBL_ENTRY _ZTI9S10103C38[];
extern  VTBL_ENTRY _ZTV9S10103C38[];
Class_Descriptor cd_S10103C38 = {  "S10103C38", // class name
  bases_S10103C38, 1,
  &(vtc_S10103C38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI9S10103C38),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C38),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C39  : S10103C5_nt , S10103C12 {
  char s10103c39f0;
  virtual  ~S10103C39(); // _ZN9S10103C39D1Ev
  virtual void  v64(); // _ZN9S10103C393v64Ev
  virtual void  v65(); // _ZN9S10103C393v65Ev
  virtual void  v66(); // _ZN9S10103C393v66Ev
  virtual void  v67(); // _ZN9S10103C393v67Ev
  virtual void  v68(); // _ZN9S10103C393v68Ev
  S10103C39(); // tgen
};
//SIG(-1 S10103C39) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4 v5 Fc}


 S10103C39 ::~S10103C39(){ note_dtor("S10103C39", this);}
void  S10103C39 ::v64(){vfunc_called(this, "_ZN9S10103C393v64Ev");}
void  S10103C39 ::v65(){vfunc_called(this, "_ZN9S10103C393v65Ev");}
void  S10103C39 ::v66(){vfunc_called(this, "_ZN9S10103C393v66Ev");}
void  S10103C39 ::v67(){vfunc_called(this, "_ZN9S10103C393v67Ev");}
void  S10103C39 ::v68(){vfunc_called(this, "_ZN9S10103C393v68Ev");}
S10103C39 ::S10103C39(){ note_ctor("S10103C39", this);} // tgen

static void Test_S10103C39()
{
  extern Class_Descriptor cd_S10103C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,30)];
    init_test(&cd_S10103C39, buf);
    S10103C39 *dp, &lv = *(dp=new (buf) S10103C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,116), "sizeof(S10103C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C39)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C39");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C39");
    check_field_offset(lv, s10103c39f0, ABISELECT(168,112), "S10103C39.s10103c39f0");
    test_class_info(&lv, &cd_S10103C39);
    dp->~S10103C39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C39(Test_S10103C39, "S10103C39", ABISELECT(176,116));

#else // __cplusplus

extern void _ZN9S10103C39C1Ev();
extern void _ZN9S10103C39D1Ev();
Name_Map name_map_S10103C39[] = {
  NSPAIR(_ZN9S10103C39C1Ev),
  NSPAIR(_ZN9S10103C39D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C39[];
extern void _ZN9S10103C39D1Ev();
extern void _ZN9S10103C39D0Ev();
extern void _ZN9S10103C393v64Ev();
extern void _ZN9S10103C393v65Ev();
extern void _ZN9S10103C393v66Ev();
extern void _ZN9S10103C393v67Ev();
extern void _ZN9S10103C393v68Ev();
extern void ABISELECT(_ZThn48_N9S10103C39D1Ev,_ZThn32_N9S10103C39D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C39D0Ev,_ZThn32_N9S10103C39D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C39[0]),
  (VTBL_ENTRY)&_ZN9S10103C39D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C39D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C393v64Ev,
  (VTBL_ENTRY)&_ZN9S10103C393v65Ev,
  (VTBL_ENTRY)&_ZN9S10103C393v66Ev,
  (VTBL_ENTRY)&_ZN9S10103C393v67Ev,
  (VTBL_ENTRY)&_ZN9S10103C393v68Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C39D1Ev,_ZThn32_N9S10103C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C39D0Ev,_ZThn32_N9S10103C39D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C39[];
extern  VTBL_ENTRY _ZTV9S10103C39[];
Class_Descriptor cd_S10103C39 = {  "S10103C39", // class name
  bases_S10103C39, 2,
  &(vtc_S10103C39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,116), // object size
  NSPAIRA(_ZTI9S10103C39),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C39),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C42  {
  void *s10103c42f0;
  ::S10103C13_nt s10103c42f1;
  ::S10103C14_nt s10103c42f2;
  ::S10103C14_nt s10103c42f3;
  int s10103c42f4;
  void  mf10103c42(); // _ZN9S10103C4210mf10103c42Ev
};
//SIG(-1 S10103C42) C1{ m Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC3 FC3 Fi}


void  S10103C42 ::mf10103c42(){}

static void Test_S10103C42()
{
  {
    init_simple_test("S10103C42");
    S10103C42 lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S10103C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C42)");
    check_field_offset(lv, s10103c42f0, 0, "S10103C42.s10103c42f0");
    check_field_offset(lv, s10103c42f1, ABISELECT(8,4), "S10103C42.s10103c42f1");
    check_field_offset(lv, s10103c42f2, ABISELECT(32,20), "S10103C42.s10103c42f2");
    check_field_offset(lv, s10103c42f3, ABISELECT(48,32), "S10103C42.s10103c42f3");
    check_field_offset(lv, s10103c42f4, ABISELECT(64,44), "S10103C42.s10103c42f4");
  }
}
static Arrange_To_Call_Me vS10103C42(Test_S10103C42, "S10103C42", ABISELECT(72,48));

#else // __cplusplus

Class_Descriptor cd_S10103C42 = {  "S10103C42", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(72,48), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C41  : S10103C5_nt {
  ::S10103C42 s10103c41f0;
  void *s10103c41f1;
  char s10103c41f2;
  int s10103c41f3;
  virtual  ~S10103C41(); // _ZN9S10103C41D1Ev
  virtual void  v71(); // _ZN9S10103C413v71Ev
  virtual void  v72(); // _ZN9S10103C413v72Ev
  virtual void  v73(); // _ZN9S10103C413v73Ev
  virtual void  v74(); // _ZN9S10103C413v74Ev
  S10103C41(); // tgen
};
//SIG(-1 S10103C41) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd v1 v2 v3 v4 FC5{ m Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC7 FC7 Fi} Fp Fc Fi}


 S10103C41 ::~S10103C41(){ note_dtor("S10103C41", this);}
void  S10103C41 ::v71(){vfunc_called(this, "_ZN9S10103C413v71Ev");}
void  S10103C41 ::v72(){vfunc_called(this, "_ZN9S10103C413v72Ev");}
void  S10103C41 ::v73(){vfunc_called(this, "_ZN9S10103C413v73Ev");}
void  S10103C41 ::v74(){vfunc_called(this, "_ZN9S10103C413v74Ev");}
S10103C41 ::S10103C41(){ note_ctor("S10103C41", this);} // tgen

static void Test_S10103C41()
{
  extern Class_Descriptor cd_S10103C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10103C41, buf);
    S10103C41 *dp, &lv = *(dp=new (buf) S10103C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10103C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C41)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C41");
    check_field_offset(lv, s10103c41f0, ABISELECT(48,32), "S10103C41.s10103c41f0");
    check_field_offset(lv, s10103c41f1, ABISELECT(120,80), "S10103C41.s10103c41f1");
    check_field_offset(lv, s10103c41f2, ABISELECT(128,84), "S10103C41.s10103c41f2");
    check_field_offset(lv, s10103c41f3, ABISELECT(132,88), "S10103C41.s10103c41f3");
    test_class_info(&lv, &cd_S10103C41);
    dp->~S10103C41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C41(Test_S10103C41, "S10103C41", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10103C41C1Ev();
extern void _ZN9S10103C41D1Ev();
Name_Map name_map_S10103C41[] = {
  NSPAIR(_ZN9S10103C41C1Ev),
  NSPAIR(_ZN9S10103C41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10103C41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C41[];
extern void _ZN9S10103C41D1Ev();
extern void _ZN9S10103C41D0Ev();
extern void _ZN9S10103C413v71Ev();
extern void _ZN9S10103C413v72Ev();
extern void _ZN9S10103C413v73Ev();
extern void _ZN9S10103C413v74Ev();
static  VTBL_ENTRY vtc_S10103C41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C41[0]),
  (VTBL_ENTRY)&_ZN9S10103C41D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C41D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v74Ev,
};
extern VTBL_ENTRY _ZTI9S10103C41[];
extern  VTBL_ENTRY _ZTV9S10103C41[];
Class_Descriptor cd_S10103C41 = {  "S10103C41", // class name
  bases_S10103C41, 1,
  &(vtc_S10103C41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10103C41),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C41),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C40  : S10103C41 {
  virtual void  v69(); // _ZN9S10103C403v69Ev
  virtual void  v70(); // _ZN9S10103C403v70Ev
  ~S10103C40(); // tgen
  S10103C40(); // tgen
};
//SIG(-1 S10103C40) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v3 v4 v5 v6 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1 v2}


void  S10103C40 ::v69(){vfunc_called(this, "_ZN9S10103C403v69Ev");}
void  S10103C40 ::v70(){vfunc_called(this, "_ZN9S10103C403v70Ev");}
S10103C40 ::~S10103C40(){ note_dtor("S10103C40", this);} // tgen
S10103C40 ::S10103C40(){ note_ctor("S10103C40", this);} // tgen

static void Test_S10103C40()
{
  extern Class_Descriptor cd_S10103C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10103C40, buf);
    S10103C40 *dp, &lv = *(dp=new (buf) S10103C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10103C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C40)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C41*), 0, "S10103C40");
    check_base_class_offset(lv, (S10103C41*), 0, "S10103C40");
    test_class_info(&lv, &cd_S10103C40);
    dp->~S10103C40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C40(Test_S10103C40, "S10103C40", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10103C40C1Ev();
extern void _ZN9S10103C40D1Ev();
Name_Map name_map_S10103C40[] = {
  NSPAIR(_ZN9S10103C40C1Ev),
  NSPAIR(_ZN9S10103C40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C41;
extern VTBL_ENTRY _ZTI9S10103C41[];
extern  VTBL_ENTRY _ZTV9S10103C41[];
static Base_Class bases_S10103C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C40[];
extern void _ZN9S10103C40D1Ev();
extern void _ZN9S10103C40D0Ev();
extern void _ZN9S10103C413v71Ev();
extern void _ZN9S10103C413v72Ev();
extern void _ZN9S10103C413v73Ev();
extern void _ZN9S10103C413v74Ev();
extern void _ZN9S10103C403v69Ev();
extern void _ZN9S10103C403v70Ev();
static  VTBL_ENTRY vtc_S10103C40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C40[0]),
  (VTBL_ENTRY)&_ZN9S10103C40D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C40D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v74Ev,
  (VTBL_ENTRY)&_ZN9S10103C403v69Ev,
  (VTBL_ENTRY)&_ZN9S10103C403v70Ev,
};
extern VTBL_ENTRY _ZTI9S10103C40[];
extern  VTBL_ENTRY _ZTV9S10103C40[];
Class_Descriptor cd_S10103C40 = {  "S10103C40", // class name
  bases_S10103C40, 2,
  &(vtc_S10103C40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10103C40),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C40),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C45  : S10103C41 {
  ::S10103C14_nt s10103c45f0;
  virtual void  v75(); // _ZN9S10103C453v75Ev
  virtual void  v76(); // _ZN9S10103C453v76Ev
  ~S10103C45(); // tgen
  S10103C45(); // tgen
};
//SIG(-1 S10103C45) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v3 v4 v5 v6 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1 v2 FC8}


void  S10103C45 ::v75(){vfunc_called(this, "_ZN9S10103C453v75Ev");}
void  S10103C45 ::v76(){vfunc_called(this, "_ZN9S10103C453v76Ev");}
S10103C45 ::~S10103C45(){ note_dtor("S10103C45", this);} // tgen
S10103C45 ::S10103C45(){ note_ctor("S10103C45", this);} // tgen

static void Test_S10103C45()
{
  extern Class_Descriptor cd_S10103C45;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S10103C45, buf);
    S10103C45 *dp, &lv = *(dp=new (buf) S10103C45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S10103C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C45)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C41*), 0, "S10103C45");
    check_base_class_offset(lv, (S10103C41*), 0, "S10103C45");
    check_field_offset(lv, s10103c45f0, ABISELECT(136,92), "S10103C45.s10103c45f0");
    test_class_info(&lv, &cd_S10103C45);
    dp->~S10103C45();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C45(Test_S10103C45, "S10103C45", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN9S10103C45C1Ev();
extern void _ZN9S10103C45D1Ev();
Name_Map name_map_S10103C45[] = {
  NSPAIR(_ZN9S10103C45C1Ev),
  NSPAIR(_ZN9S10103C45D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C41;
extern VTBL_ENTRY _ZTI9S10103C41[];
extern  VTBL_ENTRY _ZTV9S10103C41[];
static Base_Class bases_S10103C45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C45[];
extern void _ZN9S10103C45D1Ev();
extern void _ZN9S10103C45D0Ev();
extern void _ZN9S10103C413v71Ev();
extern void _ZN9S10103C413v72Ev();
extern void _ZN9S10103C413v73Ev();
extern void _ZN9S10103C413v74Ev();
extern void _ZN9S10103C453v75Ev();
extern void _ZN9S10103C453v76Ev();
static  VTBL_ENTRY vtc_S10103C45[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C45[0]),
  (VTBL_ENTRY)&_ZN9S10103C45D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C45D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v74Ev,
  (VTBL_ENTRY)&_ZN9S10103C453v75Ev,
  (VTBL_ENTRY)&_ZN9S10103C453v76Ev,
};
extern VTBL_ENTRY _ZTI9S10103C45[];
extern  VTBL_ENTRY _ZTV9S10103C45[];
Class_Descriptor cd_S10103C45 = {  "S10103C45", // class name
  bases_S10103C45, 2,
  &(vtc_S10103C45[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI9S10103C45),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C45),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C47  : S10103C41 {
  virtual void  v79(); // _ZN9S10103C473v79Ev
  ~S10103C47(); // tgen
  S10103C47(); // tgen
};
//SIG(-1 S10103C47) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v2 v3 v4 v5 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1}


void  S10103C47 ::v79(){vfunc_called(this, "_ZN9S10103C473v79Ev");}
S10103C47 ::~S10103C47(){ note_dtor("S10103C47", this);} // tgen
S10103C47 ::S10103C47(){ note_ctor("S10103C47", this);} // tgen

static void Test_S10103C47()
{
  extern Class_Descriptor cd_S10103C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10103C47, buf);
    S10103C47 *dp, &lv = *(dp=new (buf) S10103C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10103C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C47)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C41*), 0, "S10103C47");
    check_base_class_offset(lv, (S10103C41*), 0, "S10103C47");
    test_class_info(&lv, &cd_S10103C47);
    dp->~S10103C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C47(Test_S10103C47, "S10103C47", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10103C47C1Ev();
extern void _ZN9S10103C47D1Ev();
Name_Map name_map_S10103C47[] = {
  NSPAIR(_ZN9S10103C47C1Ev),
  NSPAIR(_ZN9S10103C47D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C41;
extern VTBL_ENTRY _ZTI9S10103C41[];
extern  VTBL_ENTRY _ZTV9S10103C41[];
static Base_Class bases_S10103C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C47[];
extern void _ZN9S10103C47D1Ev();
extern void _ZN9S10103C47D0Ev();
extern void _ZN9S10103C413v71Ev();
extern void _ZN9S10103C413v72Ev();
extern void _ZN9S10103C413v73Ev();
extern void _ZN9S10103C413v74Ev();
extern void _ZN9S10103C473v79Ev();
static  VTBL_ENTRY vtc_S10103C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C47[0]),
  (VTBL_ENTRY)&_ZN9S10103C47D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C47D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v74Ev,
  (VTBL_ENTRY)&_ZN9S10103C473v79Ev,
};
extern VTBL_ENTRY _ZTI9S10103C47[];
extern  VTBL_ENTRY _ZTV9S10103C47[];
Class_Descriptor cd_S10103C47 = {  "S10103C47", // class name
  bases_S10103C47, 2,
  &(vtc_S10103C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10103C47),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C47),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C49  : S10103C41 {
  virtual void  v81(); // _ZN9S10103C493v81Ev
  virtual void  v82(); // _ZN9S10103C493v82Ev
  ~S10103C49(); // tgen
  S10103C49(); // tgen
};
//SIG(-1 S10103C49) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v3 v4 v5 v6 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1 v2}


void  S10103C49 ::v81(){vfunc_called(this, "_ZN9S10103C493v81Ev");}
void  S10103C49 ::v82(){vfunc_called(this, "_ZN9S10103C493v82Ev");}
S10103C49 ::~S10103C49(){ note_dtor("S10103C49", this);} // tgen
S10103C49 ::S10103C49(){ note_ctor("S10103C49", this);} // tgen

static void Test_S10103C49()
{
  extern Class_Descriptor cd_S10103C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10103C49, buf);
    S10103C49 *dp, &lv = *(dp=new (buf) S10103C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10103C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C49)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C41*), 0, "S10103C49");
    check_base_class_offset(lv, (S10103C41*), 0, "S10103C49");
    test_class_info(&lv, &cd_S10103C49);
    dp->~S10103C49();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C49(Test_S10103C49, "S10103C49", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10103C49C1Ev();
extern void _ZN9S10103C49D1Ev();
Name_Map name_map_S10103C49[] = {
  NSPAIR(_ZN9S10103C49C1Ev),
  NSPAIR(_ZN9S10103C49D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C41;
extern VTBL_ENTRY _ZTI9S10103C41[];
extern  VTBL_ENTRY _ZTV9S10103C41[];
static Base_Class bases_S10103C49[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C49[];
extern void _ZN9S10103C49D1Ev();
extern void _ZN9S10103C49D0Ev();
extern void _ZN9S10103C413v71Ev();
extern void _ZN9S10103C413v72Ev();
extern void _ZN9S10103C413v73Ev();
extern void _ZN9S10103C413v74Ev();
extern void _ZN9S10103C493v81Ev();
extern void _ZN9S10103C493v82Ev();
static  VTBL_ENTRY vtc_S10103C49[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C49[0]),
  (VTBL_ENTRY)&_ZN9S10103C49D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C49D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v74Ev,
  (VTBL_ENTRY)&_ZN9S10103C493v81Ev,
  (VTBL_ENTRY)&_ZN9S10103C493v82Ev,
};
extern VTBL_ENTRY _ZTI9S10103C49[];
extern  VTBL_ENTRY _ZTV9S10103C49[];
Class_Descriptor cd_S10103C49 = {  "S10103C49", // class name
  bases_S10103C49, 2,
  &(vtc_S10103C49[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10103C49),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C49),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C50  : S10103C5_nt {
  virtual  ~S10103C50(); // _ZN9S10103C50D1Ev
  S10103C50(); // tgen
};
//SIG(-1 S10103C50) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd}


 S10103C50 ::~S10103C50(){ note_dtor("S10103C50", this);}
S10103C50 ::S10103C50(){ note_ctor("S10103C50", this);} // tgen

static void Test_S10103C50()
{
  extern Class_Descriptor cd_S10103C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S10103C50, buf);
    S10103C50 *dp, &lv = *(dp=new (buf) S10103C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S10103C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C50)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C50");
    test_class_info(&lv, &cd_S10103C50);
    dp->~S10103C50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C50(Test_S10103C50, "S10103C50", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN9S10103C50C1Ev();
extern void _ZN9S10103C50D1Ev();
Name_Map name_map_S10103C50[] = {
  NSPAIR(_ZN9S10103C50C1Ev),
  NSPAIR(_ZN9S10103C50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10103C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C50[];
extern void _ZN9S10103C50D1Ev();
extern void _ZN9S10103C50D0Ev();
static  VTBL_ENTRY vtc_S10103C50[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C50[0]),
  (VTBL_ENTRY)&_ZN9S10103C50D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C50D0Ev,
};
extern VTBL_ENTRY _ZTI9S10103C50[];
extern  VTBL_ENTRY _ZTV9S10103C50[];
Class_Descriptor cd_S10103C50 = {  "S10103C50", // class name
  bases_S10103C50, 1,
  &(vtc_S10103C50[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI9S10103C50),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C50),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C51  : S10103C5_nt {
  void *s10103c51f0[4];
  virtual  ~S10103C51(); // _ZN9S10103C51D1Ev
  S10103C51(); // tgen
};
//SIG(-1 S10103C51) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd Fp[4]}


 S10103C51 ::~S10103C51(){ note_dtor("S10103C51", this);}
S10103C51 ::S10103C51(){ note_ctor("S10103C51", this);} // tgen

static void Test_S10103C51()
{
  extern Class_Descriptor cd_S10103C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S10103C51, buf);
    S10103C51 *dp, &lv = *(dp=new (buf) S10103C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S10103C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C51)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C51");
    check_field_offset(lv, s10103c51f0, ABISELECT(48,32), "S10103C51.s10103c51f0");
    test_class_info(&lv, &cd_S10103C51);
    dp->~S10103C51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C51(Test_S10103C51, "S10103C51", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN9S10103C51C1Ev();
extern void _ZN9S10103C51D1Ev();
Name_Map name_map_S10103C51[] = {
  NSPAIR(_ZN9S10103C51C1Ev),
  NSPAIR(_ZN9S10103C51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10103C51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C51[];
extern void _ZN9S10103C51D1Ev();
extern void _ZN9S10103C51D0Ev();
static  VTBL_ENTRY vtc_S10103C51[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C51[0]),
  (VTBL_ENTRY)&_ZN9S10103C51D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C51D0Ev,
};
extern VTBL_ENTRY _ZTI9S10103C51[];
extern  VTBL_ENTRY _ZTV9S10103C51[];
Class_Descriptor cd_S10103C51 = {  "S10103C51", // class name
  bases_S10103C51, 1,
  &(vtc_S10103C51[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI9S10103C51),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C51),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C52  : S10103C5_nt {
  void *s10103c52f0[2];
  int s10103c52f1[2];
  virtual  ~S10103C52(); // _ZN9S10103C52D1Ev
  virtual void  v83(); // _ZN9S10103C523v83Ev
  virtual void  v84(); // _ZN9S10103C523v84Ev
  S10103C52(); // tgen
};
//SIG(-1 S10103C52) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd v1 v2 Fp[2] Fi[2]}


 S10103C52 ::~S10103C52(){ note_dtor("S10103C52", this);}
void  S10103C52 ::v83(){vfunc_called(this, "_ZN9S10103C523v83Ev");}
void  S10103C52 ::v84(){vfunc_called(this, "_ZN9S10103C523v84Ev");}
S10103C52 ::S10103C52(){ note_ctor("S10103C52", this);} // tgen

static void Test_S10103C52()
{
  extern Class_Descriptor cd_S10103C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,13)];
    init_test(&cd_S10103C52, buf);
    S10103C52 *dp, &lv = *(dp=new (buf) S10103C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S10103C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C52)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C52");
    check_field_offset(lv, s10103c52f0, ABISELECT(48,32), "S10103C52.s10103c52f0");
    check_field_offset(lv, s10103c52f1, ABISELECT(64,40), "S10103C52.s10103c52f1");
    test_class_info(&lv, &cd_S10103C52);
    dp->~S10103C52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C52(Test_S10103C52, "S10103C52", ABISELECT(72,48));

#else // __cplusplus

extern void _ZN9S10103C52C1Ev();
extern void _ZN9S10103C52D1Ev();
Name_Map name_map_S10103C52[] = {
  NSPAIR(_ZN9S10103C52C1Ev),
  NSPAIR(_ZN9S10103C52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10103C52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C52[];
extern void _ZN9S10103C52D1Ev();
extern void _ZN9S10103C52D0Ev();
extern void _ZN9S10103C523v83Ev();
extern void _ZN9S10103C523v84Ev();
static  VTBL_ENTRY vtc_S10103C52[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C52[0]),
  (VTBL_ENTRY)&_ZN9S10103C52D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C52D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C523v83Ev,
  (VTBL_ENTRY)&_ZN9S10103C523v84Ev,
};
extern VTBL_ENTRY _ZTI9S10103C52[];
extern  VTBL_ENTRY _ZTV9S10103C52[];
Class_Descriptor cd_S10103C52 = {  "S10103C52", // class name
  bases_S10103C52, 1,
  &(vtc_S10103C52[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,48), // object size
  NSPAIRA(_ZTI9S10103C52),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C52),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C54_nt  {
  void *s10103c54f0;
  void  mf10103c54(); // _ZN12S10103C54_nt10mf10103c54Ev
};
//SIG(-1 S10103C54_nt) C1{ m Fp}


void  S10103C54_nt ::mf10103c54(){}

//skip512 S10103C54_nt

#else // __cplusplus

Class_Descriptor cd_S10103C54_nt = {  "S10103C54_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C53  {
  void *s10103c53f0;
  ::S10103C54_nt s10103c53f1;
  void *s10103c53f2;
  int s10103c53f3;
  void *s10103c53f4;
  void  mf10103c53(); // _ZN9S10103C5310mf10103c53Ev
  virtual  ~S10103C53(); // _ZN9S10103C53D1Ev
  S10103C53(); // tgen
};
//SIG(-1 S10103C53) C1{ vd m Fp FC2{ m Fp} Fp Fi Fp}


void  S10103C53 ::mf10103c53(){}
 S10103C53 ::~S10103C53(){ note_dtor("S10103C53", this);}
S10103C53 ::S10103C53(){ note_ctor("S10103C53", this);} // tgen

static void Test_S10103C53()
{
  extern Class_Descriptor cd_S10103C53;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_S10103C53, buf);
    S10103C53 *dp, &lv = *(dp=new (buf) S10103C53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S10103C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C53)");
    check_field_offset(lv, s10103c53f0, ABISELECT(8,4), "S10103C53.s10103c53f0");
    check_field_offset(lv, s10103c53f1, ABISELECT(16,8), "S10103C53.s10103c53f1");
    check_field_offset(lv, s10103c53f2, ABISELECT(24,12), "S10103C53.s10103c53f2");
    check_field_offset(lv, s10103c53f3, ABISELECT(32,16), "S10103C53.s10103c53f3");
    check_field_offset(lv, s10103c53f4, ABISELECT(40,20), "S10103C53.s10103c53f4");
    test_class_info(&lv, &cd_S10103C53);
    dp->~S10103C53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C53(Test_S10103C53, "S10103C53", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN9S10103C53C1Ev();
extern void _ZN9S10103C53D1Ev();
Name_Map name_map_S10103C53[] = {
  NSPAIR(_ZN9S10103C53C1Ev),
  NSPAIR(_ZN9S10103C53D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10103C53[];
extern void _ZN9S10103C53D1Ev();
extern void _ZN9S10103C53D0Ev();
static  VTBL_ENTRY vtc_S10103C53[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C53[0]),
  (VTBL_ENTRY)&_ZN9S10103C53D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C53D0Ev,
};
extern VTBL_ENTRY _ZTI9S10103C53[];
extern  VTBL_ENTRY _ZTV9S10103C53[];
Class_Descriptor cd_S10103C53 = {  "S10103C53", // class name
  0,0,//no base classes
  &(vtc_S10103C53[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI9S10103C53),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10103C53),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C56  : S10103C41 {
  virtual void  v90(); // _ZN9S10103C563v90Ev
  ~S10103C56(); // tgen
  S10103C56(); // tgen
};
//SIG(-1 S10103C56) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v2 v3 v4 v5 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1}


void  S10103C56 ::v90(){vfunc_called(this, "_ZN9S10103C563v90Ev");}
S10103C56 ::~S10103C56(){ note_dtor("S10103C56", this);} // tgen
S10103C56 ::S10103C56(){ note_ctor("S10103C56", this);} // tgen

static void Test_S10103C56()
{
  extern Class_Descriptor cd_S10103C56;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10103C56, buf);
    S10103C56 *dp, &lv = *(dp=new (buf) S10103C56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10103C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C56)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C41*), 0, "S10103C56");
    check_base_class_offset(lv, (S10103C41*), 0, "S10103C56");
    test_class_info(&lv, &cd_S10103C56);
    dp->~S10103C56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C56(Test_S10103C56, "S10103C56", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10103C56C1Ev();
extern void _ZN9S10103C56D1Ev();
Name_Map name_map_S10103C56[] = {
  NSPAIR(_ZN9S10103C56C1Ev),
  NSPAIR(_ZN9S10103C56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C41;
extern VTBL_ENTRY _ZTI9S10103C41[];
extern  VTBL_ENTRY _ZTV9S10103C41[];
static Base_Class bases_S10103C56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C56[];
extern void _ZN9S10103C56D1Ev();
extern void _ZN9S10103C56D0Ev();
extern void _ZN9S10103C413v71Ev();
extern void _ZN9S10103C413v72Ev();
extern void _ZN9S10103C413v73Ev();
extern void _ZN9S10103C413v74Ev();
extern void _ZN9S10103C563v90Ev();
static  VTBL_ENTRY vtc_S10103C56[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C56[0]),
  (VTBL_ENTRY)&_ZN9S10103C56D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C56D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v74Ev,
  (VTBL_ENTRY)&_ZN9S10103C563v90Ev,
};
extern VTBL_ENTRY _ZTI9S10103C56[];
extern  VTBL_ENTRY _ZTV9S10103C56[];
Class_Descriptor cd_S10103C56 = {  "S10103C56", // class name
  bases_S10103C56, 2,
  &(vtc_S10103C56[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10103C56),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C56),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C57  : S10103C41 {
  void *s10103c57f0;
  virtual void  v91(); // _ZN9S10103C573v91Ev
  virtual void  v92(); // _ZN9S10103C573v92Ev
  virtual void  v93(); // _ZN9S10103C573v93Ev
  ~S10103C57(); // tgen
  S10103C57(); // tgen
};
//SIG(-1 S10103C57) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v4 v5 v6 v7 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1 v2 v3 Fp}


void  S10103C57 ::v91(){vfunc_called(this, "_ZN9S10103C573v91Ev");}
void  S10103C57 ::v92(){vfunc_called(this, "_ZN9S10103C573v92Ev");}
void  S10103C57 ::v93(){vfunc_called(this, "_ZN9S10103C573v93Ev");}
S10103C57 ::~S10103C57(){ note_dtor("S10103C57", this);} // tgen
S10103C57 ::S10103C57(){ note_ctor("S10103C57", this);} // tgen

static void Test_S10103C57()
{
  extern Class_Descriptor cd_S10103C57;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,25)];
    init_test(&cd_S10103C57, buf);
    S10103C57 *dp, &lv = *(dp=new (buf) S10103C57());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S10103C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C57)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C41*), 0, "S10103C57");
    check_base_class_offset(lv, (S10103C41*), 0, "S10103C57");
    check_field_offset(lv, s10103c57f0, ABISELECT(136,92), "S10103C57.s10103c57f0");
    test_class_info(&lv, &cd_S10103C57);
    dp->~S10103C57();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C57(Test_S10103C57, "S10103C57", ABISELECT(144,96));

#else // __cplusplus

extern void _ZN9S10103C57C1Ev();
extern void _ZN9S10103C57D1Ev();
Name_Map name_map_S10103C57[] = {
  NSPAIR(_ZN9S10103C57C1Ev),
  NSPAIR(_ZN9S10103C57D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C41;
extern VTBL_ENTRY _ZTI9S10103C41[];
extern  VTBL_ENTRY _ZTV9S10103C41[];
static Base_Class bases_S10103C57[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C57[];
extern void _ZN9S10103C57D1Ev();
extern void _ZN9S10103C57D0Ev();
extern void _ZN9S10103C413v71Ev();
extern void _ZN9S10103C413v72Ev();
extern void _ZN9S10103C413v73Ev();
extern void _ZN9S10103C413v74Ev();
extern void _ZN9S10103C573v91Ev();
extern void _ZN9S10103C573v92Ev();
extern void _ZN9S10103C573v93Ev();
static  VTBL_ENTRY vtc_S10103C57[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C57[0]),
  (VTBL_ENTRY)&_ZN9S10103C57D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C57D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10103C413v74Ev,
  (VTBL_ENTRY)&_ZN9S10103C573v91Ev,
  (VTBL_ENTRY)&_ZN9S10103C573v92Ev,
  (VTBL_ENTRY)&_ZN9S10103C573v93Ev,
};
extern VTBL_ENTRY _ZTI9S10103C57[];
extern  VTBL_ENTRY _ZTV9S10103C57[];
Class_Descriptor cd_S10103C57 = {  "S10103C57", // class name
  bases_S10103C57, 2,
  &(vtc_S10103C57[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,96), // object size
  NSPAIRA(_ZTI9S10103C57),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C57),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C58_nt  {
  ::S10103C20_nt s10103c58f0;
  void *s10103c58f1[2];
  void  mf10103c58(); // _ZN12S10103C58_nt10mf10103c58Ev
};
//SIG(-1 S10103C58_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}} Fp[2]}


void  S10103C58_nt ::mf10103c58(){}

//skip512 S10103C58_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C55  : S10103C2_nt , S10103C3_nt {
  ::S10103C56 s10103c55f0;
  ::S10103C56 s10103c55f1;
  ::S10103C56 s10103c55f2;
  ::S10103C47 s10103c55f3;
  ::S10103C57 s10103c55f4;
  ::S10103C40 s10103c55f5;
  void *s10103c55f6[2];
  ::S10103C58_nt s10103c55f7;
  virtual  ~S10103C55(); // _ZN9S10103C55D1Ev
  virtual void  v85(); // _ZN9S10103C553v85Ev
  virtual void  v86(); // _ZN9S10103C553v86Ev
  virtual void  v87(); // _ZN9S10103C553v87Ev
  virtual void  v88(); // _ZN9S10103C553v88Ev
  virtual void  v89(); // _ZN9S10103C553v89Ev
  S10103C55(); // tgen
};
//SIG(-1 S10103C55) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} vd v1 v2 v3 v4 v5 FC4{ BC5{ BC6{ vd m FC7{ m Fp Fi FC8{ m} FC8} FC7 Fc} vd v13 v14 v15 v16 FC9{ m Fp FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} FC11 FC11 Fi} Fp Fc Fi} v12} FC4 FC4 FC13{ BC5 v17} FC14{ BC5 v18 v19 v20 Fp} FC15{ BC5 v21 v22} Fp[2] FC16{ m FC17{ m Fp Fi[2] FC12} Fp[2]}}


 S10103C55 ::~S10103C55(){ note_dtor("S10103C55", this);}
void  S10103C55 ::v85(){vfunc_called(this, "_ZN9S10103C553v85Ev");}
void  S10103C55 ::v86(){vfunc_called(this, "_ZN9S10103C553v86Ev");}
void  S10103C55 ::v87(){vfunc_called(this, "_ZN9S10103C553v87Ev");}
void  S10103C55 ::v88(){vfunc_called(this, "_ZN9S10103C553v88Ev");}
void  S10103C55 ::v89(){vfunc_called(this, "_ZN9S10103C553v89Ev");}
S10103C55 ::S10103C55(){ note_ctor("S10103C55", this);} // tgen

static void Test_S10103C55()
{
  extern Class_Descriptor cd_S10103C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(114,151)];
    init_test(&cd_S10103C55, buf);
    S10103C55 *dp, &lv = *(dp=new (buf) S10103C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(904,600), "sizeof(S10103C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C55)");
    check_base_class_offset(lv, (S10103C2_nt*), 0, "S10103C55");
    check_base_class_offset(lv, (S10103C3_nt*), ABISELECT(8,4), "S10103C55");
    check_field_offset(lv, s10103c55f0, ABISELECT(24,12), "S10103C55.s10103c55f0");
    check_field_offset(lv, s10103c55f1, ABISELECT(160,104), "S10103C55.s10103c55f1");
    check_field_offset(lv, s10103c55f2, ABISELECT(296,196), "S10103C55.s10103c55f2");
    check_field_offset(lv, s10103c55f3, ABISELECT(432,288), "S10103C55.s10103c55f3");
    check_field_offset(lv, s10103c55f4, ABISELECT(568,380), "S10103C55.s10103c55f4");
    check_field_offset(lv, s10103c55f5, ABISELECT(712,476), "S10103C55.s10103c55f5");
    check_field_offset(lv, s10103c55f6, ABISELECT(848,568), "S10103C55.s10103c55f6");
    check_field_offset(lv, s10103c55f7, ABISELECT(864,576), "S10103C55.s10103c55f7");
    test_class_info(&lv, &cd_S10103C55);
    dp->~S10103C55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C55(Test_S10103C55, "S10103C55", ABISELECT(904,600));

#else // __cplusplus

extern void _ZN9S10103C55C1Ev();
extern void _ZN9S10103C55D1Ev();
Name_Map name_map_S10103C55[] = {
  NSPAIR(_ZN9S10103C55C1Ev),
  NSPAIR(_ZN9S10103C55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C2_nt;
extern VTBL_ENTRY _ZTI11S10103C2_nt[];
extern  VTBL_ENTRY _ZTV11S10103C2_nt[];
extern Class_Descriptor cd_S10103C3_nt;
extern VTBL_ENTRY _ZTI11S10103C3_nt[];
extern  VTBL_ENTRY _ZTV11S10103C3_nt[];
static Base_Class bases_S10103C55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C3_nt,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C55[];
extern void _ZN9S10103C55D1Ev();
extern void _ZN9S10103C55D0Ev();
extern void _ZN11S10103C2_nt2v6Ev();
extern void _ZN9S10103C553v85Ev();
extern void _ZN9S10103C553v86Ev();
extern void _ZN9S10103C553v87Ev();
extern void _ZN9S10103C553v88Ev();
extern void _ZN9S10103C553v89Ev();
extern void ABISELECT(_ZThn8_N9S10103C55D1Ev,_ZThn4_N9S10103C55D1Ev)();
extern void ABISELECT(_ZThn8_N9S10103C55D0Ev,_ZThn4_N9S10103C55D0Ev)();
extern void _ZN11S10103C3_nt2v7Ev();
extern void _ZN11S10103C3_nt2v8Ev();
extern void _ZN11S10103C3_nt2v9Ev();
extern void _ZN11S10103C3_nt3v10Ev();
extern void _ZN11S10103C3_nt3v11Ev();
static  VTBL_ENTRY vtc_S10103C55[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C55[0]),
  (VTBL_ENTRY)&_ZN9S10103C55D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C55D0Ev,
  (VTBL_ENTRY)&_ZN11S10103C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S10103C553v85Ev,
  (VTBL_ENTRY)&_ZN9S10103C553v86Ev,
  (VTBL_ENTRY)&_ZN9S10103C553v87Ev,
  (VTBL_ENTRY)&_ZN9S10103C553v88Ev,
  (VTBL_ENTRY)&_ZN9S10103C553v89Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10103C55[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10103C55D1Ev,_ZThn4_N9S10103C55D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10103C55D0Ev,_ZThn4_N9S10103C55D0Ev),
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI9S10103C55[];
extern  VTBL_ENTRY _ZTV9S10103C55[];
Class_Descriptor cd_S10103C55 = {  "S10103C55", // class name
  bases_S10103C55, 2,
  &(vtc_S10103C55[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(904,600), // object size
  NSPAIRA(_ZTI9S10103C55),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C55),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C64  {
  void *s10103c64f0;
  void  mf10103c64(); // _ZN9S10103C6410mf10103c64Ev
};
//SIG(-1 S10103C64) C1{ m Fp}


void  S10103C64 ::mf10103c64(){}

static void Test_S10103C64()
{
  {
    init_simple_test("S10103C64");
    S10103C64 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10103C64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C64)");
    check_field_offset(lv, s10103c64f0, 0, "S10103C64.s10103c64f0");
  }
}
static Arrange_To_Call_Me vS10103C64(Test_S10103C64, "S10103C64", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C67_nt  {
  virtual  ~S10103C67_nt(); // _ZN12S10103C67_ntD1Ev
  virtual void  v112(); // _ZN12S10103C67_nt4v112Ev
  virtual void  v113(); // _ZN12S10103C67_nt4v113Ev
  S10103C67_nt(); // tgen
};
//SIG(-1 S10103C67_nt) C1{ vd v1 v2}


 S10103C67_nt ::~S10103C67_nt(){ note_dtor("S10103C67_nt", this);}
void  S10103C67_nt ::v112(){vfunc_called(this, "_ZN12S10103C67_nt4v112Ev");}
void  S10103C67_nt ::v113(){vfunc_called(this, "_ZN12S10103C67_nt4v113Ev");}
S10103C67_nt ::S10103C67_nt(){ note_ctor("S10103C67_nt", this);} // tgen

//skip512 S10103C67_nt

#else // __cplusplus

extern void _ZN12S10103C67_ntC1Ev();
extern void _ZN12S10103C67_ntD1Ev();
Name_Map name_map_S10103C67_nt[] = {
  NSPAIR(_ZN12S10103C67_ntC1Ev),
  NSPAIR(_ZN12S10103C67_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S10103C67_nt[];
extern void _ZN12S10103C67_ntD1Ev();
extern void _ZN12S10103C67_ntD0Ev();
extern void _ZN12S10103C67_nt4v112Ev();
extern void _ZN12S10103C67_nt4v113Ev();
static  VTBL_ENTRY vtc_S10103C67_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10103C67_nt[0]),
  (VTBL_ENTRY)&_ZN12S10103C67_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10103C67_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10103C67_nt4v112Ev,
  (VTBL_ENTRY)&_ZN12S10103C67_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI12S10103C67_nt[];
VTBL_ENTRY *P__ZTI12S10103C67_nt = _ZTI12S10103C67_nt; 
extern  VTBL_ENTRY _ZTV12S10103C67_nt[];
Class_Descriptor cd_S10103C67_nt = {  "S10103C67_nt", // class name
  0,0,//no base classes
  &(vtc_S10103C67_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S10103C67_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S10103C67_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C66  : S10103C67_nt {
  ::S10103C14_nt s10103c66f0;
  int s10103c66f1;
  __tsi64 s10103c66f2[2];
  int s10103c66f3;
  ~S10103C66(); // tgen
  S10103C66(); // tgen
};
//SIG(-1 S10103C66) C1{ BC2{ vd v1 v2} FC3{ m Fp Fi FC4{ m}} Fi FL[2] Fi}


S10103C66 ::~S10103C66(){ note_dtor("S10103C66", this);} // tgen
S10103C66 ::S10103C66(){ note_ctor("S10103C66", this);} // tgen

static void Test_S10103C66()
{
  extern Class_Descriptor cd_S10103C66;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_S10103C66, buf);
    S10103C66 *dp, &lv = *(dp=new (buf) S10103C66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(S10103C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C66)");
    check_base_class_offset(lv, (S10103C67_nt*), 0, "S10103C66");
    check_field_offset(lv, s10103c66f0, ABISELECT(8,4), "S10103C66.s10103c66f0");
    check_field_offset(lv, s10103c66f1, ABISELECT(24,16), "S10103C66.s10103c66f1");
    check_field_offset(lv, s10103c66f2, ABISELECT(32,20), "S10103C66.s10103c66f2");
    check_field_offset(lv, s10103c66f3, ABISELECT(48,36), "S10103C66.s10103c66f3");
    test_class_info(&lv, &cd_S10103C66);
    dp->~S10103C66();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C66(Test_S10103C66, "S10103C66", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN9S10103C66C1Ev();
extern void _ZN9S10103C66D1Ev();
Name_Map name_map_S10103C66[] = {
  NSPAIR(_ZN9S10103C66C1Ev),
  NSPAIR(_ZN9S10103C66D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C67_nt;
extern VTBL_ENTRY _ZTI12S10103C67_nt[];
extern  VTBL_ENTRY _ZTV12S10103C67_nt[];
static Base_Class bases_S10103C66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C67_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C66[];
extern void _ZN9S10103C66D1Ev();
extern void _ZN9S10103C66D0Ev();
extern void _ZN12S10103C67_nt4v112Ev();
extern void _ZN12S10103C67_nt4v113Ev();
static  VTBL_ENTRY vtc_S10103C66[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C66[0]),
  (VTBL_ENTRY)&_ZN9S10103C66D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C66D0Ev,
  (VTBL_ENTRY)&_ZN12S10103C67_nt4v112Ev,
  (VTBL_ENTRY)&_ZN12S10103C67_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI9S10103C66[];
extern  VTBL_ENTRY _ZTV9S10103C66[];
Class_Descriptor cd_S10103C66 = {  "S10103C66", // class name
  bases_S10103C66, 1,
  &(vtc_S10103C66[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI9S10103C66),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C66),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C71  {
  void  mf10103c71(); // _ZN9S10103C7110mf10103c71Ev
};
//SIG(-1 S10103C71) C1{ m}


void  S10103C71 ::mf10103c71(){}

static void Test_S10103C71()
{
  {
    init_simple_test("S10103C71");
    S10103C71 lv;
    check2(sizeof(lv), 1, "sizeof(S10103C71)");
    check2(__alignof__(lv), 1, "__alignof__(S10103C71)");
  }
}
static Arrange_To_Call_Me vS10103C71(Test_S10103C71, "S10103C71", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C70  {
  void *s10103c70f0;
  int s10103c70f1[2];
  ::S10103C71 s10103c70f2;
  void  mf10103c70(); // _ZN9S10103C7010mf10103c70Ev
};
//SIG(-1 S10103C70) C1{ m Fp Fi[2] FC2{ m}}


void  S10103C70 ::mf10103c70(){}

static void Test_S10103C70()
{
  {
    init_simple_test("S10103C70");
    S10103C70 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10103C70)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C70)");
    check_field_offset(lv, s10103c70f0, 0, "S10103C70.s10103c70f0");
    check_field_offset(lv, s10103c70f1, ABISELECT(8,4), "S10103C70.s10103c70f1");
    check_field_offset(lv, s10103c70f2, ABISELECT(16,12), "S10103C70.s10103c70f2");
  }
}
static Arrange_To_Call_Me vS10103C70(Test_S10103C70, "S10103C70", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C72_nt  {
  int s10103c72f0[4];
  void  mf10103c72(); // _ZN12S10103C72_nt10mf10103c72Ev
};
//SIG(1 S10103C72_nt) C1{ m Fi[4]}


void  S10103C72_nt ::mf10103c72(){}

//skip512 S10103C72_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C69_nt  {
  ::S10103C70 s10103c69f0;
  ::S10103C72_nt s10103c69f1[3];
  void *s10103c69f2[2];
  int s10103c69f3;
  char s10103c69f4;
  virtual  ~S10103C69_nt(); // _ZN12S10103C69_ntD1Ev
  virtual void  v114(); // _ZN12S10103C69_nt4v114Ev
  virtual void  v115(); // _ZN12S10103C69_nt4v115Ev
  S10103C69_nt(); // tgen
};
//SIG(-1 S10103C69_nt) C1{ vd v1 v2 FC2{ m Fp Fi[2] FC3{ m}} FC4{ m Fi[4]}[3] Fp[2] Fi Fc}


 S10103C69_nt ::~S10103C69_nt(){ note_dtor("S10103C69_nt", this);}
void  S10103C69_nt ::v114(){vfunc_called(this, "_ZN12S10103C69_nt4v114Ev");}
void  S10103C69_nt ::v115(){vfunc_called(this, "_ZN12S10103C69_nt4v115Ev");}
S10103C69_nt ::S10103C69_nt(){ note_ctor("S10103C69_nt", this);} // tgen

//skip512 S10103C69_nt

#else // __cplusplus

extern void _ZN12S10103C69_ntC1Ev();
extern void _ZN12S10103C69_ntD1Ev();
Name_Map name_map_S10103C69_nt[] = {
  NSPAIR(_ZN12S10103C69_ntC1Ev),
  NSPAIR(_ZN12S10103C69_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S10103C69_nt[];
extern void _ZN12S10103C69_ntD1Ev();
extern void _ZN12S10103C69_ntD0Ev();
extern void _ZN12S10103C69_nt4v114Ev();
extern void _ZN12S10103C69_nt4v115Ev();
static  VTBL_ENTRY vtc_S10103C69_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10103C69_nt[0]),
  (VTBL_ENTRY)&_ZN12S10103C69_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10103C69_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10103C69_nt4v114Ev,
  (VTBL_ENTRY)&_ZN12S10103C69_nt4v115Ev,
};
extern VTBL_ENTRY _ZTI12S10103C69_nt[];
VTBL_ENTRY *P__ZTI12S10103C69_nt = _ZTI12S10103C69_nt; 
extern  VTBL_ENTRY _ZTV12S10103C69_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C68  {
  void *s10103c68f0[2];
  ::S10103C69_nt s10103c68f1;
  void *s10103c68f2[2];
  void  mf10103c68(); // _ZN9S10103C6810mf10103c68Ev
};
//SIG(-1 S10103C68) C1{ m Fp[2] FC2{ vd v1 v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fi[4]}[3] Fp[2] Fi Fc} Fp[2]}


void  S10103C68 ::mf10103c68(){}

static void Test_S10103C68()
{
  {
    init_simple_test("S10103C68");
    S10103C68 lv;
    check2(sizeof(lv), ABISELECT(136,100), "sizeof(S10103C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C68)");
    check_field_offset(lv, s10103c68f0, 0, "S10103C68.s10103c68f0");
    check_field_offset(lv, s10103c68f1, ABISELECT(16,8), "S10103C68.s10103c68f1");
    check_field_offset(lv, s10103c68f2, ABISELECT(120,92), "S10103C68.s10103c68f2");
  }
}
static Arrange_To_Call_Me vS10103C68(Test_S10103C68, "S10103C68", ABISELECT(136,100));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C76  {
  void *s10103c76f0[2];
  ::S10103C13_nt s10103c76f1;
  void *s10103c76f2;
  virtual  ~S10103C76(); // _ZN9S10103C76D1Ev
  virtual void  v120(); // _ZN9S10103C764v120Ev
  virtual void  v121(); // _ZN9S10103C764v121Ev
  virtual void  v122(); // _ZN9S10103C764v122Ev
  virtual void  v123(); // _ZN9S10103C764v123Ev
  virtual void  v124(); // _ZN9S10103C764v124Ev
  virtual void  v125(); // _ZN9S10103C764v125Ev
  virtual void  v126(); // _ZN9S10103C764v126Ev
  virtual void  v127(); // _ZN9S10103C764v127Ev
  virtual void  v128(); // _ZN9S10103C764v128Ev
  virtual void  v129(); // _ZN9S10103C764v129Ev
  S10103C76(); // tgen
};
//SIG(-1 S10103C76) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S10103C76 ::~S10103C76(){ note_dtor("S10103C76", this);}
void  S10103C76 ::v120(){vfunc_called(this, "_ZN9S10103C764v120Ev");}
void  S10103C76 ::v121(){vfunc_called(this, "_ZN9S10103C764v121Ev");}
void  S10103C76 ::v122(){vfunc_called(this, "_ZN9S10103C764v122Ev");}
void  S10103C76 ::v123(){vfunc_called(this, "_ZN9S10103C764v123Ev");}
void  S10103C76 ::v124(){vfunc_called(this, "_ZN9S10103C764v124Ev");}
void  S10103C76 ::v125(){vfunc_called(this, "_ZN9S10103C764v125Ev");}
void  S10103C76 ::v126(){vfunc_called(this, "_ZN9S10103C764v126Ev");}
void  S10103C76 ::v127(){vfunc_called(this, "_ZN9S10103C764v127Ev");}
void  S10103C76 ::v128(){vfunc_called(this, "_ZN9S10103C764v128Ev");}
void  S10103C76 ::v129(){vfunc_called(this, "_ZN9S10103C764v129Ev");}
S10103C76 ::S10103C76(){ note_ctor("S10103C76", this);} // tgen

static void Test_S10103C76()
{
  extern Class_Descriptor cd_S10103C76;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S10103C76, buf);
    S10103C76 *dp, &lv = *(dp=new (buf) S10103C76());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S10103C76)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C76)");
    check_field_offset(lv, s10103c76f0, ABISELECT(8,4), "S10103C76.s10103c76f0");
    check_field_offset(lv, s10103c76f1, ABISELECT(24,12), "S10103C76.s10103c76f1");
    check_field_offset(lv, s10103c76f2, ABISELECT(48,28), "S10103C76.s10103c76f2");
    test_class_info(&lv, &cd_S10103C76);
    dp->~S10103C76();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C76(Test_S10103C76, "S10103C76", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN9S10103C76C1Ev();
extern void _ZN9S10103C76D1Ev();
Name_Map name_map_S10103C76[] = {
  NSPAIR(_ZN9S10103C76C1Ev),
  NSPAIR(_ZN9S10103C76D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10103C76[];
extern void _ZN9S10103C76D1Ev();
extern void _ZN9S10103C76D0Ev();
extern void _ZN9S10103C764v120Ev();
extern void _ZN9S10103C764v121Ev();
extern void _ZN9S10103C764v122Ev();
extern void _ZN9S10103C764v123Ev();
extern void _ZN9S10103C764v124Ev();
extern void _ZN9S10103C764v125Ev();
extern void _ZN9S10103C764v126Ev();
extern void _ZN9S10103C764v127Ev();
extern void _ZN9S10103C764v128Ev();
extern void _ZN9S10103C764v129Ev();
static  VTBL_ENTRY vtc_S10103C76[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C76[0]),
  (VTBL_ENTRY)&_ZN9S10103C76D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C76D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v120Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v121Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v122Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v123Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v124Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v125Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v126Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v127Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v128Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v129Ev,
};
extern VTBL_ENTRY _ZTI9S10103C76[];
extern  VTBL_ENTRY _ZTV9S10103C76[];
Class_Descriptor cd_S10103C76 = {  "S10103C76", // class name
  0,0,//no base classes
  &(vtc_S10103C76[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI9S10103C76),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10103C76),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C83_nt  {
  __tsi64 s10103c83f0[2];
  void  mf10103c83(); // _ZN12S10103C83_nt10mf10103c83Ev
};
//SIG(-1 S10103C83_nt) C1{ m FL[2]}


void  S10103C83_nt ::mf10103c83(){}

//skip512 S10103C83_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C82_nt  {
  ::S10103C83_nt s10103c82f0;
  void  mf10103c82(); // _ZN12S10103C82_nt10mf10103c82Ev
};
//SIG(-1 S10103C82_nt) C1{ m FC2{ m FL[2]}}


void  S10103C82_nt ::mf10103c82(){}

//skip512 S10103C82_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C75  : S10103C76 {
  ::S10103C35 s10103c75f0;
  ::S10103C70 s10103c75f1;
  ::S10103C82_nt s10103c75f2;
  ::S10103C13_nt s10103c75f3;
  virtual  ~S10103C75(); // _ZN9S10103C75D1Ev
  virtual void  v130(); // _ZN9S10103C754v130Ev
  virtual void  v131(); // _ZN9S10103C754v131Ev
  virtual void  v132(); // _ZN9S10103C754v132Ev
  virtual void  v133(); // _ZN9S10103C754v133Ev
  virtual void  v134(); // _ZN9S10103C754v134Ev
  virtual void  v135(); // _ZN9S10103C754v135Ev
  virtual void  v136(); // _ZN9S10103C754v136Ev
  virtual void  v137(); // _ZN9S10103C754v137Ev
  virtual void  v138(); // _ZN9S10103C754v138Ev
  virtual void  v139(); // _ZN9S10103C754v139Ev
  virtual void  v140(); // _ZN9S10103C754v140Ev
  virtual void  v141(); // _ZN9S10103C754v141Ev
  virtual void  v142(); // _ZN9S10103C754v142Ev
  virtual void  v143(); // _ZN9S10103C754v143Ev
  S10103C75(); // tgen
};
//SIG(-1 S10103C75) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC7} FC8{ m Fp Fi[2] FC9{ m}} FC10{ m FC11{ m FL[2]}} FC3}


 S10103C75 ::~S10103C75(){ note_dtor("S10103C75", this);}
void  S10103C75 ::v130(){vfunc_called(this, "_ZN9S10103C754v130Ev");}
void  S10103C75 ::v131(){vfunc_called(this, "_ZN9S10103C754v131Ev");}
void  S10103C75 ::v132(){vfunc_called(this, "_ZN9S10103C754v132Ev");}
void  S10103C75 ::v133(){vfunc_called(this, "_ZN9S10103C754v133Ev");}
void  S10103C75 ::v134(){vfunc_called(this, "_ZN9S10103C754v134Ev");}
void  S10103C75 ::v135(){vfunc_called(this, "_ZN9S10103C754v135Ev");}
void  S10103C75 ::v136(){vfunc_called(this, "_ZN9S10103C754v136Ev");}
void  S10103C75 ::v137(){vfunc_called(this, "_ZN9S10103C754v137Ev");}
void  S10103C75 ::v138(){vfunc_called(this, "_ZN9S10103C754v138Ev");}
void  S10103C75 ::v139(){vfunc_called(this, "_ZN9S10103C754v139Ev");}
void  S10103C75 ::v140(){vfunc_called(this, "_ZN9S10103C754v140Ev");}
void  S10103C75 ::v141(){vfunc_called(this, "_ZN9S10103C754v141Ev");}
void  S10103C75 ::v142(){vfunc_called(this, "_ZN9S10103C754v142Ev");}
void  S10103C75 ::v143(){vfunc_called(this, "_ZN9S10103C754v143Ev");}
S10103C75 ::S10103C75(){ note_ctor("S10103C75", this);} // tgen

static void Test_S10103C75()
{
  extern Class_Descriptor cd_S10103C75;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10103C75, buf);
    S10103C75 *dp, &lv = *(dp=new (buf) S10103C75());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10103C75)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C75)");
    check_base_class_offset(lv, (S10103C76*), 0, "S10103C75");
    check_field_offset(lv, s10103c75f0, ABISELECT(56,32), "S10103C75.s10103c75f0");
    check_field_offset(lv, s10103c75f1, ABISELECT(72,44), "S10103C75.s10103c75f1");
    check_field_offset(lv, s10103c75f2, ABISELECT(96,60), "S10103C75.s10103c75f2");
    check_field_offset(lv, s10103c75f3, ABISELECT(112,76), "S10103C75.s10103c75f3");
    test_class_info(&lv, &cd_S10103C75);
    dp->~S10103C75();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C75(Test_S10103C75, "S10103C75", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10103C75C1Ev();
extern void _ZN9S10103C75D1Ev();
Name_Map name_map_S10103C75[] = {
  NSPAIR(_ZN9S10103C75C1Ev),
  NSPAIR(_ZN9S10103C75D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C76;
extern VTBL_ENTRY _ZTI9S10103C76[];
extern  VTBL_ENTRY _ZTV9S10103C76[];
static Base_Class bases_S10103C75[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C76,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C75[];
extern void _ZN9S10103C75D1Ev();
extern void _ZN9S10103C75D0Ev();
extern void _ZN9S10103C764v120Ev();
extern void _ZN9S10103C764v121Ev();
extern void _ZN9S10103C764v122Ev();
extern void _ZN9S10103C764v123Ev();
extern void _ZN9S10103C764v124Ev();
extern void _ZN9S10103C764v125Ev();
extern void _ZN9S10103C764v126Ev();
extern void _ZN9S10103C764v127Ev();
extern void _ZN9S10103C764v128Ev();
extern void _ZN9S10103C764v129Ev();
extern void _ZN9S10103C754v130Ev();
extern void _ZN9S10103C754v131Ev();
extern void _ZN9S10103C754v132Ev();
extern void _ZN9S10103C754v133Ev();
extern void _ZN9S10103C754v134Ev();
extern void _ZN9S10103C754v135Ev();
extern void _ZN9S10103C754v136Ev();
extern void _ZN9S10103C754v137Ev();
extern void _ZN9S10103C754v138Ev();
extern void _ZN9S10103C754v139Ev();
extern void _ZN9S10103C754v140Ev();
extern void _ZN9S10103C754v141Ev();
extern void _ZN9S10103C754v142Ev();
extern void _ZN9S10103C754v143Ev();
static  VTBL_ENTRY vtc_S10103C75[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C75[0]),
  (VTBL_ENTRY)&_ZN9S10103C75D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C75D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v120Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v121Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v122Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v123Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v124Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v125Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v126Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v127Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v128Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v129Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v130Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v131Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v132Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v133Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v134Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v135Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v136Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v137Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v138Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v139Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v140Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v141Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v142Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v143Ev,
};
extern VTBL_ENTRY _ZTI9S10103C75[];
extern  VTBL_ENTRY _ZTV9S10103C75[];
Class_Descriptor cd_S10103C75 = {  "S10103C75", // class name
  bases_S10103C75, 1,
  &(vtc_S10103C75[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10103C75),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C75),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C88  {
  void  mf10103c88(); // _ZN9S10103C8810mf10103c88Ev
};
//SIG(-1 S10103C88) C1{ m}


void  S10103C88 ::mf10103c88(){}

static void Test_S10103C88()
{
  {
    init_simple_test("S10103C88");
    S10103C88 lv;
    check2(sizeof(lv), 1, "sizeof(S10103C88)");
    check2(__alignof__(lv), 1, "__alignof__(S10103C88)");
  }
}
static Arrange_To_Call_Me vS10103C88(Test_S10103C88, "S10103C88", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S10103C88[];
VTBL_ENTRY *P__ZTI9S10103C88 = _ZTI9S10103C88; 
Class_Descriptor cd_S10103C88 = {  "S10103C88", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S10103C88),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C86  {
  void *s10103c86f0;
  int s10103c86f1;
  ::S10103C71 s10103c86f2;
  ::S10103C88 s10103c86f3;
  void  mf10103c86(); // _ZN9S10103C8610mf10103c86Ev
};
//SIG(-1 S10103C86) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S10103C86 ::mf10103c86(){}

static void Test_S10103C86()
{
  {
    init_simple_test("S10103C86");
    S10103C86 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10103C86)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C86)");
    check_field_offset(lv, s10103c86f0, 0, "S10103C86.s10103c86f0");
    check_field_offset(lv, s10103c86f1, ABISELECT(8,4), "S10103C86.s10103c86f1");
    check_field_offset(lv, s10103c86f2, ABISELECT(12,8), "S10103C86.s10103c86f2");
    check_field_offset(lv, s10103c86f3, ABISELECT(13,9), "S10103C86.s10103c86f3");
  }
}
static Arrange_To_Call_Me vS10103C86(Test_S10103C86, "S10103C86", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C85  : S10103C76 {
  void *s10103c85f0;
  int s10103c85f1;
  ::S10103C86 s10103c85f2;
  ::S10103C82_nt s10103c85f3;
  int s10103c85f4;
  virtual  ~S10103C85(); // _ZN9S10103C85D1Ev
  virtual void  v152(); // _ZN9S10103C854v152Ev
  virtual void  v153(); // _ZN9S10103C854v153Ev
  virtual void  v154(); // _ZN9S10103C854v154Ev
  virtual void  v155(); // _ZN9S10103C854v155Ev
  virtual void  v156(); // _ZN9S10103C854v156Ev
  virtual void  v157(); // _ZN9S10103C854v157Ev
  S10103C85(); // tgen
};
//SIG(-1 S10103C85) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 Fp Fi FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m FC10{ m FL[2]}} Fi}


 S10103C85 ::~S10103C85(){ note_dtor("S10103C85", this);}
void  S10103C85 ::v152(){vfunc_called(this, "_ZN9S10103C854v152Ev");}
void  S10103C85 ::v153(){vfunc_called(this, "_ZN9S10103C854v153Ev");}
void  S10103C85 ::v154(){vfunc_called(this, "_ZN9S10103C854v154Ev");}
void  S10103C85 ::v155(){vfunc_called(this, "_ZN9S10103C854v155Ev");}
void  S10103C85 ::v156(){vfunc_called(this, "_ZN9S10103C854v156Ev");}
void  S10103C85 ::v157(){vfunc_called(this, "_ZN9S10103C854v157Ev");}
S10103C85 ::S10103C85(){ note_ctor("S10103C85", this);} // tgen

static void Test_S10103C85()
{
  extern Class_Descriptor cd_S10103C85;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S10103C85, buf);
    S10103C85 *dp, &lv = *(dp=new (buf) S10103C85());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S10103C85)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C85)");
    check_base_class_offset(lv, (S10103C76*), 0, "S10103C85");
    check_field_offset(lv, s10103c85f0, ABISELECT(56,32), "S10103C85.s10103c85f0");
    check_field_offset(lv, s10103c85f1, ABISELECT(64,36), "S10103C85.s10103c85f1");
    check_field_offset(lv, s10103c85f2, ABISELECT(72,40), "S10103C85.s10103c85f2");
    check_field_offset(lv, s10103c85f3, ABISELECT(88,52), "S10103C85.s10103c85f3");
    check_field_offset(lv, s10103c85f4, ABISELECT(104,68), "S10103C85.s10103c85f4");
    test_class_info(&lv, &cd_S10103C85);
    dp->~S10103C85();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C85(Test_S10103C85, "S10103C85", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN9S10103C85C1Ev();
extern void _ZN9S10103C85D1Ev();
Name_Map name_map_S10103C85[] = {
  NSPAIR(_ZN9S10103C85C1Ev),
  NSPAIR(_ZN9S10103C85D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C76;
extern VTBL_ENTRY _ZTI9S10103C76[];
extern  VTBL_ENTRY _ZTV9S10103C76[];
static Base_Class bases_S10103C85[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C76,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C85[];
extern void _ZN9S10103C85D1Ev();
extern void _ZN9S10103C85D0Ev();
extern void _ZN9S10103C764v120Ev();
extern void _ZN9S10103C764v121Ev();
extern void _ZN9S10103C764v122Ev();
extern void _ZN9S10103C764v123Ev();
extern void _ZN9S10103C764v124Ev();
extern void _ZN9S10103C764v125Ev();
extern void _ZN9S10103C764v126Ev();
extern void _ZN9S10103C764v127Ev();
extern void _ZN9S10103C764v128Ev();
extern void _ZN9S10103C764v129Ev();
extern void _ZN9S10103C854v152Ev();
extern void _ZN9S10103C854v153Ev();
extern void _ZN9S10103C854v154Ev();
extern void _ZN9S10103C854v155Ev();
extern void _ZN9S10103C854v156Ev();
extern void _ZN9S10103C854v157Ev();
static  VTBL_ENTRY vtc_S10103C85[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C85[0]),
  (VTBL_ENTRY)&_ZN9S10103C85D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C85D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v120Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v121Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v122Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v123Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v124Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v125Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v126Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v127Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v128Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v129Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v152Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v153Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v154Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v155Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v156Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v157Ev,
};
extern VTBL_ENTRY _ZTI9S10103C85[];
extern  VTBL_ENTRY _ZTV9S10103C85[];
Class_Descriptor cd_S10103C85 = {  "S10103C85", // class name
  bases_S10103C85, 1,
  &(vtc_S10103C85[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI9S10103C85),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C85),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C84  : S10103C85 {
  ::S10103C13_nt s10103c84f0[4];
  ::S10103C82_nt s10103c84f1;
  ::S10103C82_nt s10103c84f2;
  ::S10103C82_nt s10103c84f3;
  ::S10103C82_nt s10103c84f4;
  int s10103c84f5[6];
  virtual  ~S10103C84(); // _ZN9S10103C84D1Ev
  virtual void  v148(); // _ZN9S10103C844v148Ev
  virtual void  v149(); // _ZN9S10103C844v149Ev
  virtual void  v150(); // _ZN9S10103C844v150Ev
  virtual void  v151(); // _ZN9S10103C844v151Ev
  S10103C84(); // tgen
};
//SIG(-1 S10103C84) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 Fp Fi FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m FC11{ m FL[2]}} Fi} vd v1 v2 v3 v4 FC4[4] FC10 FC10 FC10 FC10 Fi[6]}


 S10103C84 ::~S10103C84(){ note_dtor("S10103C84", this);}
void  S10103C84 ::v148(){vfunc_called(this, "_ZN9S10103C844v148Ev");}
void  S10103C84 ::v149(){vfunc_called(this, "_ZN9S10103C844v149Ev");}
void  S10103C84 ::v150(){vfunc_called(this, "_ZN9S10103C844v150Ev");}
void  S10103C84 ::v151(){vfunc_called(this, "_ZN9S10103C844v151Ev");}
S10103C84 ::S10103C84(){ note_ctor("S10103C84", this);} // tgen

static void Test_S10103C84()
{
  extern Class_Descriptor cd_S10103C84;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,57)];
    init_test(&cd_S10103C84, buf);
    S10103C84 *dp, &lv = *(dp=new (buf) S10103C84());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,224), "sizeof(S10103C84)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C84)");
    check_base_class_offset(lv, (S10103C76*)(S10103C85*), 0, "S10103C84");
    check_base_class_offset(lv, (S10103C85*), 0, "S10103C84");
    check_field_offset(lv, s10103c84f0, ABISELECT(112,72), "S10103C84.s10103c84f0");
    check_field_offset(lv, s10103c84f1, ABISELECT(208,136), "S10103C84.s10103c84f1");
    check_field_offset(lv, s10103c84f2, ABISELECT(224,152), "S10103C84.s10103c84f2");
    check_field_offset(lv, s10103c84f3, ABISELECT(240,168), "S10103C84.s10103c84f3");
    check_field_offset(lv, s10103c84f4, ABISELECT(256,184), "S10103C84.s10103c84f4");
    check_field_offset(lv, s10103c84f5, ABISELECT(272,200), "S10103C84.s10103c84f5");
    test_class_info(&lv, &cd_S10103C84);
    dp->~S10103C84();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C84(Test_S10103C84, "S10103C84", ABISELECT(296,224));

#else // __cplusplus

extern void _ZN9S10103C84C1Ev();
extern void _ZN9S10103C84D1Ev();
Name_Map name_map_S10103C84[] = {
  NSPAIR(_ZN9S10103C84C1Ev),
  NSPAIR(_ZN9S10103C84D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C76;
extern VTBL_ENTRY _ZTI9S10103C76[];
extern  VTBL_ENTRY _ZTV9S10103C76[];
extern Class_Descriptor cd_S10103C85;
extern VTBL_ENTRY _ZTI9S10103C85[];
extern  VTBL_ENTRY _ZTV9S10103C85[];
static Base_Class bases_S10103C84[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C76,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C85,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C84[];
extern void _ZN9S10103C84D1Ev();
extern void _ZN9S10103C84D0Ev();
extern void _ZN9S10103C764v120Ev();
extern void _ZN9S10103C764v121Ev();
extern void _ZN9S10103C764v122Ev();
extern void _ZN9S10103C764v123Ev();
extern void _ZN9S10103C764v124Ev();
extern void _ZN9S10103C764v125Ev();
extern void _ZN9S10103C764v126Ev();
extern void _ZN9S10103C764v127Ev();
extern void _ZN9S10103C764v128Ev();
extern void _ZN9S10103C764v129Ev();
extern void _ZN9S10103C854v152Ev();
extern void _ZN9S10103C854v153Ev();
extern void _ZN9S10103C854v154Ev();
extern void _ZN9S10103C854v155Ev();
extern void _ZN9S10103C854v156Ev();
extern void _ZN9S10103C854v157Ev();
extern void _ZN9S10103C844v148Ev();
extern void _ZN9S10103C844v149Ev();
extern void _ZN9S10103C844v150Ev();
extern void _ZN9S10103C844v151Ev();
static  VTBL_ENTRY vtc_S10103C84[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C84[0]),
  (VTBL_ENTRY)&_ZN9S10103C84D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C84D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v120Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v121Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v122Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v123Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v124Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v125Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v126Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v127Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v128Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v129Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v152Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v153Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v154Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v155Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v156Ev,
  (VTBL_ENTRY)&_ZN9S10103C854v157Ev,
  (VTBL_ENTRY)&_ZN9S10103C844v148Ev,
  (VTBL_ENTRY)&_ZN9S10103C844v149Ev,
  (VTBL_ENTRY)&_ZN9S10103C844v150Ev,
  (VTBL_ENTRY)&_ZN9S10103C844v151Ev,
};
extern VTBL_ENTRY _ZTI9S10103C84[];
extern  VTBL_ENTRY _ZTV9S10103C84[];
Class_Descriptor cd_S10103C84 = {  "S10103C84", // class name
  bases_S10103C84, 2,
  &(vtc_S10103C84[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,224), // object size
  NSPAIRA(_ZTI9S10103C84),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C84),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C74  : S10103C75 {
  ::S10103C84 s10103c74f0;
  ::S10103C82_nt s10103c74f1;
  ::S10103C82_nt s10103c74f2;
  virtual void  v144(); // _ZN9S10103C744v144Ev
  virtual void  v145(); // _ZN9S10103C744v145Ev
  virtual void  v146(); // _ZN9S10103C744v146Ev
  virtual void  v147(); // _ZN9S10103C744v147Ev
  ~S10103C74(); // tgen
  S10103C74(); // tgen
};
//SIG(-1 S10103C74) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC8} FC9{ m Fp Fi[2] FC10{ m}} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 FC13{ BC14{ BC3 vd v33 v34 v35 v36 v37 v38 Fp Fi FC15{ m Fp Fi FC10 FC16{ m}} FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]} FC11 FC11}


void  S10103C74 ::v144(){vfunc_called(this, "_ZN9S10103C744v144Ev");}
void  S10103C74 ::v145(){vfunc_called(this, "_ZN9S10103C744v145Ev");}
void  S10103C74 ::v146(){vfunc_called(this, "_ZN9S10103C744v146Ev");}
void  S10103C74 ::v147(){vfunc_called(this, "_ZN9S10103C744v147Ev");}
S10103C74 ::~S10103C74(){ note_dtor("S10103C74", this);} // tgen
S10103C74 ::S10103C74(){ note_ctor("S10103C74", this);} // tgen

static void Test_S10103C74()
{
  extern Class_Descriptor cd_S10103C74;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,88)];
    init_test(&cd_S10103C74, buf);
    S10103C74 *dp, &lv = *(dp=new (buf) S10103C74());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,348), "sizeof(S10103C74)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C74)");
    check_base_class_offset(lv, (S10103C76*)(S10103C75*), 0, "S10103C74");
    check_base_class_offset(lv, (S10103C75*), 0, "S10103C74");
    check_field_offset(lv, s10103c74f0, ABISELECT(136,92), "S10103C74.s10103c74f0");
    check_field_offset(lv, s10103c74f1, ABISELECT(432,316), "S10103C74.s10103c74f1");
    check_field_offset(lv, s10103c74f2, ABISELECT(448,332), "S10103C74.s10103c74f2");
    test_class_info(&lv, &cd_S10103C74);
    dp->~S10103C74();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C74(Test_S10103C74, "S10103C74", ABISELECT(464,348));

#else // __cplusplus

extern void _ZN9S10103C74C1Ev();
extern void _ZN9S10103C74D1Ev();
Name_Map name_map_S10103C74[] = {
  NSPAIR(_ZN9S10103C74C1Ev),
  NSPAIR(_ZN9S10103C74D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C76;
extern VTBL_ENTRY _ZTI9S10103C76[];
extern  VTBL_ENTRY _ZTV9S10103C76[];
extern Class_Descriptor cd_S10103C75;
extern VTBL_ENTRY _ZTI9S10103C75[];
extern  VTBL_ENTRY _ZTV9S10103C75[];
static Base_Class bases_S10103C74[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C76,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C75,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C74[];
extern void _ZN9S10103C74D1Ev();
extern void _ZN9S10103C74D0Ev();
extern void _ZN9S10103C764v120Ev();
extern void _ZN9S10103C764v121Ev();
extern void _ZN9S10103C764v122Ev();
extern void _ZN9S10103C764v123Ev();
extern void _ZN9S10103C764v124Ev();
extern void _ZN9S10103C764v125Ev();
extern void _ZN9S10103C764v126Ev();
extern void _ZN9S10103C764v127Ev();
extern void _ZN9S10103C764v128Ev();
extern void _ZN9S10103C764v129Ev();
extern void _ZN9S10103C754v130Ev();
extern void _ZN9S10103C754v131Ev();
extern void _ZN9S10103C754v132Ev();
extern void _ZN9S10103C754v133Ev();
extern void _ZN9S10103C754v134Ev();
extern void _ZN9S10103C754v135Ev();
extern void _ZN9S10103C754v136Ev();
extern void _ZN9S10103C754v137Ev();
extern void _ZN9S10103C754v138Ev();
extern void _ZN9S10103C754v139Ev();
extern void _ZN9S10103C754v140Ev();
extern void _ZN9S10103C754v141Ev();
extern void _ZN9S10103C754v142Ev();
extern void _ZN9S10103C754v143Ev();
extern void _ZN9S10103C744v144Ev();
extern void _ZN9S10103C744v145Ev();
extern void _ZN9S10103C744v146Ev();
extern void _ZN9S10103C744v147Ev();
static  VTBL_ENTRY vtc_S10103C74[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C74[0]),
  (VTBL_ENTRY)&_ZN9S10103C74D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C74D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v120Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v121Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v122Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v123Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v124Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v125Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v126Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v127Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v128Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v129Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v130Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v131Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v132Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v133Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v134Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v135Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v136Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v137Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v138Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v139Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v140Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v141Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v142Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v143Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v144Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v145Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v146Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v147Ev,
};
extern VTBL_ENTRY _ZTI9S10103C74[];
extern  VTBL_ENTRY _ZTV9S10103C74[];
Class_Descriptor cd_S10103C74 = {  "S10103C74", // class name
  bases_S10103C74, 2,
  &(vtc_S10103C74[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,348), // object size
  NSPAIRA(_ZTI9S10103C74),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C74),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C73  : S10103C74 {
  ::S10103C30_nt s10103c73f0;
  ::S10103C82_nt s10103c73f1;
  virtual void  v116(); // _ZN9S10103C734v116Ev
  virtual void  v117(); // _ZN9S10103C734v117Ev
  virtual void  v118(); // _ZN9S10103C734v118Ev
  virtual void  v119(); // _ZN9S10103C734v119Ev
  ~S10103C73(); // tgen
  S10103C73(); // tgen
};
//SIG(-1 S10103C73) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC9} FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 FC14{ BC15{ BC4 vd v37 v38 v39 v40 v41 v42 Fp Fi FC16{ m Fp Fi FC11 FC17{ m}} FC12 Fi} vd v33 v34 v35 v36 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC12 FC12} v1 v2 v3 v4 FC18{ m FC19{ m FL}} FC12}


void  S10103C73 ::v116(){vfunc_called(this, "_ZN9S10103C734v116Ev");}
void  S10103C73 ::v117(){vfunc_called(this, "_ZN9S10103C734v117Ev");}
void  S10103C73 ::v118(){vfunc_called(this, "_ZN9S10103C734v118Ev");}
void  S10103C73 ::v119(){vfunc_called(this, "_ZN9S10103C734v119Ev");}
S10103C73 ::~S10103C73(){ note_dtor("S10103C73", this);} // tgen
S10103C73 ::S10103C73(){ note_ctor("S10103C73", this);} // tgen

static void Test_S10103C73()
{
  extern Class_Descriptor cd_S10103C73;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(62,94)];
    init_test(&cd_S10103C73, buf);
    S10103C73 *dp, &lv = *(dp=new (buf) S10103C73());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(488,372), "sizeof(S10103C73)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C73)");
    check_base_class_offset(lv, (S10103C76*)(S10103C75*)(S10103C74*), 0, "S10103C73");
    check_base_class_offset(lv, (S10103C75*)(S10103C74*), 0, "S10103C73");
    check_base_class_offset(lv, (S10103C74*), 0, "S10103C73");
    check_field_offset(lv, s10103c73f0, ABISELECT(464,348), "S10103C73.s10103c73f0");
    check_field_offset(lv, s10103c73f1, ABISELECT(472,356), "S10103C73.s10103c73f1");
    test_class_info(&lv, &cd_S10103C73);
    dp->~S10103C73();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C73(Test_S10103C73, "S10103C73", ABISELECT(488,372));

#else // __cplusplus

extern void _ZN9S10103C73C1Ev();
extern void _ZN9S10103C73D1Ev();
Name_Map name_map_S10103C73[] = {
  NSPAIR(_ZN9S10103C73C1Ev),
  NSPAIR(_ZN9S10103C73D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C76;
extern VTBL_ENTRY _ZTI9S10103C76[];
extern  VTBL_ENTRY _ZTV9S10103C76[];
extern Class_Descriptor cd_S10103C75;
extern VTBL_ENTRY _ZTI9S10103C75[];
extern  VTBL_ENTRY _ZTV9S10103C75[];
extern Class_Descriptor cd_S10103C74;
extern VTBL_ENTRY _ZTI9S10103C74[];
extern  VTBL_ENTRY _ZTV9S10103C74[];
static Base_Class bases_S10103C73[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C76,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10103C75,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C74,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C73[];
extern void _ZN9S10103C73D1Ev();
extern void _ZN9S10103C73D0Ev();
extern void _ZN9S10103C764v120Ev();
extern void _ZN9S10103C764v121Ev();
extern void _ZN9S10103C764v122Ev();
extern void _ZN9S10103C764v123Ev();
extern void _ZN9S10103C764v124Ev();
extern void _ZN9S10103C764v125Ev();
extern void _ZN9S10103C764v126Ev();
extern void _ZN9S10103C764v127Ev();
extern void _ZN9S10103C764v128Ev();
extern void _ZN9S10103C764v129Ev();
extern void _ZN9S10103C754v130Ev();
extern void _ZN9S10103C754v131Ev();
extern void _ZN9S10103C754v132Ev();
extern void _ZN9S10103C754v133Ev();
extern void _ZN9S10103C754v134Ev();
extern void _ZN9S10103C754v135Ev();
extern void _ZN9S10103C754v136Ev();
extern void _ZN9S10103C754v137Ev();
extern void _ZN9S10103C754v138Ev();
extern void _ZN9S10103C754v139Ev();
extern void _ZN9S10103C754v140Ev();
extern void _ZN9S10103C754v141Ev();
extern void _ZN9S10103C754v142Ev();
extern void _ZN9S10103C754v143Ev();
extern void _ZN9S10103C744v144Ev();
extern void _ZN9S10103C744v145Ev();
extern void _ZN9S10103C744v146Ev();
extern void _ZN9S10103C744v147Ev();
extern void _ZN9S10103C734v116Ev();
extern void _ZN9S10103C734v117Ev();
extern void _ZN9S10103C734v118Ev();
extern void _ZN9S10103C734v119Ev();
static  VTBL_ENTRY vtc_S10103C73[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C73[0]),
  (VTBL_ENTRY)&_ZN9S10103C73D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C73D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v120Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v121Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v122Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v123Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v124Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v125Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v126Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v127Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v128Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v129Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v130Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v131Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v132Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v133Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v134Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v135Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v136Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v137Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v138Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v139Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v140Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v141Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v142Ev,
  (VTBL_ENTRY)&_ZN9S10103C754v143Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v144Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v145Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v146Ev,
  (VTBL_ENTRY)&_ZN9S10103C744v147Ev,
  (VTBL_ENTRY)&_ZN9S10103C734v116Ev,
  (VTBL_ENTRY)&_ZN9S10103C734v117Ev,
  (VTBL_ENTRY)&_ZN9S10103C734v118Ev,
  (VTBL_ENTRY)&_ZN9S10103C734v119Ev,
};
extern VTBL_ENTRY _ZTI9S10103C73[];
extern  VTBL_ENTRY _ZTV9S10103C73[];
Class_Descriptor cd_S10103C73 = {  "S10103C73", // class name
  bases_S10103C73, 3,
  &(vtc_S10103C73[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(488,372), // object size
  NSPAIRA(_ZTI9S10103C73),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C73),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C91  : S10103C76 {
  void *s10103c91f0[2];
  ::S10103C82_nt s10103c91f1;
  ::S10103C82_nt s10103c91f2;
  ::S10103C82_nt s10103c91f3;
  int s10103c91f4[13];
  void *s10103c91f5[3];
  int s10103c91f6[3];
  virtual  ~S10103C91(); // _ZN9S10103C91D1Ev
  virtual void  v158(); // _ZN9S10103C914v158Ev
  virtual void  v159(); // _ZN9S10103C914v159Ev
  virtual void  v160(); // _ZN9S10103C914v160Ev
  virtual void  v161(); // _ZN9S10103C914v161Ev
  virtual void  v162(); // _ZN9S10103C914v162Ev
  virtual void  v163(); // _ZN9S10103C914v163Ev
  S10103C91(); // tgen
};
//SIG(-1 S10103C91) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 Fp[2] FC6{ m FC7{ m FL[2]}} FC6 FC6 Fi[13] Fp[3] Fi[3]}


 S10103C91 ::~S10103C91(){ note_dtor("S10103C91", this);}
void  S10103C91 ::v158(){vfunc_called(this, "_ZN9S10103C914v158Ev");}
void  S10103C91 ::v159(){vfunc_called(this, "_ZN9S10103C914v159Ev");}
void  S10103C91 ::v160(){vfunc_called(this, "_ZN9S10103C914v160Ev");}
void  S10103C91 ::v161(){vfunc_called(this, "_ZN9S10103C914v161Ev");}
void  S10103C91 ::v162(){vfunc_called(this, "_ZN9S10103C914v162Ev");}
void  S10103C91 ::v163(){vfunc_called(this, "_ZN9S10103C914v163Ev");}
S10103C91 ::S10103C91(){ note_ctor("S10103C91", this);} // tgen

static void Test_S10103C91()
{
  extern Class_Descriptor cd_S10103C91;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,42)];
    init_test(&cd_S10103C91, buf);
    S10103C91 *dp, &lv = *(dp=new (buf) S10103C91());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,164), "sizeof(S10103C91)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C91)");
    check_base_class_offset(lv, (S10103C76*), 0, "S10103C91");
    check_field_offset(lv, s10103c91f0, ABISELECT(56,32), "S10103C91.s10103c91f0");
    check_field_offset(lv, s10103c91f1, ABISELECT(72,40), "S10103C91.s10103c91f1");
    check_field_offset(lv, s10103c91f2, ABISELECT(88,56), "S10103C91.s10103c91f2");
    check_field_offset(lv, s10103c91f3, ABISELECT(104,72), "S10103C91.s10103c91f3");
    check_field_offset(lv, s10103c91f4, ABISELECT(120,88), "S10103C91.s10103c91f4");
    check_field_offset(lv, s10103c91f5, ABISELECT(176,140), "S10103C91.s10103c91f5");
    check_field_offset(lv, s10103c91f6, ABISELECT(200,152), "S10103C91.s10103c91f6");
    test_class_info(&lv, &cd_S10103C91);
    dp->~S10103C91();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C91(Test_S10103C91, "S10103C91", ABISELECT(216,164));

#else // __cplusplus

extern void _ZN9S10103C91C1Ev();
extern void _ZN9S10103C91D1Ev();
Name_Map name_map_S10103C91[] = {
  NSPAIR(_ZN9S10103C91C1Ev),
  NSPAIR(_ZN9S10103C91D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C76;
extern VTBL_ENTRY _ZTI9S10103C76[];
extern  VTBL_ENTRY _ZTV9S10103C76[];
static Base_Class bases_S10103C91[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C76,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C91[];
extern void _ZN9S10103C91D1Ev();
extern void _ZN9S10103C91D0Ev();
extern void _ZN9S10103C764v120Ev();
extern void _ZN9S10103C764v121Ev();
extern void _ZN9S10103C764v122Ev();
extern void _ZN9S10103C764v123Ev();
extern void _ZN9S10103C764v124Ev();
extern void _ZN9S10103C764v125Ev();
extern void _ZN9S10103C764v126Ev();
extern void _ZN9S10103C764v127Ev();
extern void _ZN9S10103C764v128Ev();
extern void _ZN9S10103C764v129Ev();
extern void _ZN9S10103C914v158Ev();
extern void _ZN9S10103C914v159Ev();
extern void _ZN9S10103C914v160Ev();
extern void _ZN9S10103C914v161Ev();
extern void _ZN9S10103C914v162Ev();
extern void _ZN9S10103C914v163Ev();
static  VTBL_ENTRY vtc_S10103C91[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C91[0]),
  (VTBL_ENTRY)&_ZN9S10103C91D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C91D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v120Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v121Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v122Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v123Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v124Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v125Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v126Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v127Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v128Ev,
  (VTBL_ENTRY)&_ZN9S10103C764v129Ev,
  (VTBL_ENTRY)&_ZN9S10103C914v158Ev,
  (VTBL_ENTRY)&_ZN9S10103C914v159Ev,
  (VTBL_ENTRY)&_ZN9S10103C914v160Ev,
  (VTBL_ENTRY)&_ZN9S10103C914v161Ev,
  (VTBL_ENTRY)&_ZN9S10103C914v162Ev,
  (VTBL_ENTRY)&_ZN9S10103C914v163Ev,
};
extern VTBL_ENTRY _ZTI9S10103C91[];
extern  VTBL_ENTRY _ZTV9S10103C91[];
Class_Descriptor cd_S10103C91 = {  "S10103C91", // class name
  bases_S10103C91, 1,
  &(vtc_S10103C91[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,164), // object size
  NSPAIRA(_ZTI9S10103C91),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C91),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C96  {
  __tsi64 s10103c96f0[2];
  int s10103c96f1;
  ::S10103C14_nt s10103c96f2;
  ::S10103C14_nt s10103c96f3;
  ::S10103C14_nt s10103c96f4;
  ::S10103C14_nt s10103c96f5;
  ::S10103C54_nt s10103c96f6;
  void  mf10103c96(); // _ZN9S10103C9610mf10103c96Ev
  virtual  ~S10103C96(); // _ZN9S10103C96D1Ev
  S10103C96(); // tgen
};
//SIG(-1 S10103C96) C1{ vd m FL[2] Fi FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC2 FC4{ m Fp}}


void  S10103C96 ::mf10103c96(){}
 S10103C96 ::~S10103C96(){ note_dtor("S10103C96", this);}
S10103C96 ::S10103C96(){ note_ctor("S10103C96", this);} // tgen

static void Test_S10103C96()
{
  extern Class_Descriptor cd_S10103C96;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,20)];
    init_test(&cd_S10103C96, buf);
    S10103C96 *dp, &lv = *(dp=new (buf) S10103C96());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,76), "sizeof(S10103C96)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C96)");
    check_field_offset(lv, s10103c96f0, ABISELECT(8,4), "S10103C96.s10103c96f0");
    check_field_offset(lv, s10103c96f1, ABISELECT(24,20), "S10103C96.s10103c96f1");
    check_field_offset(lv, s10103c96f2, ABISELECT(32,24), "S10103C96.s10103c96f2");
    check_field_offset(lv, s10103c96f3, ABISELECT(48,36), "S10103C96.s10103c96f3");
    check_field_offset(lv, s10103c96f4, ABISELECT(64,48), "S10103C96.s10103c96f4");
    check_field_offset(lv, s10103c96f5, ABISELECT(80,60), "S10103C96.s10103c96f5");
    check_field_offset(lv, s10103c96f6, ABISELECT(96,72), "S10103C96.s10103c96f6");
    test_class_info(&lv, &cd_S10103C96);
    dp->~S10103C96();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C96(Test_S10103C96, "S10103C96", ABISELECT(104,76));

#else // __cplusplus

extern void _ZN9S10103C96C1Ev();
extern void _ZN9S10103C96D1Ev();
Name_Map name_map_S10103C96[] = {
  NSPAIR(_ZN9S10103C96C1Ev),
  NSPAIR(_ZN9S10103C96D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10103C96[];
extern void _ZN9S10103C96D1Ev();
extern void _ZN9S10103C96D0Ev();
static  VTBL_ENTRY vtc_S10103C96[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C96[0]),
  (VTBL_ENTRY)&_ZN9S10103C96D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C96D0Ev,
};
extern VTBL_ENTRY _ZTI9S10103C96[];
extern  VTBL_ENTRY _ZTV9S10103C96[];
Class_Descriptor cd_S10103C96 = {  "S10103C96", // class name
  0,0,//no base classes
  &(vtc_S10103C96[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,76), // object size
  NSPAIRA(_ZTI9S10103C96),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10103C96),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C92  {
  void *s10103c92f0[2];
  ::S10103C86 s10103c92f1;
  ::S10103C96 s10103c92f2;
  void  mf10103c92(); // _ZN9S10103C9210mf10103c92Ev
  virtual  ~S10103C92(); // _ZN9S10103C92D1Ev
  S10103C92(); // tgen
};
//SIG(-1 S10103C92) C1{ vd m Fp[2] FC2{ m Fp Fi FC3{ m} FC4{ m}} FC5{ vd m FL[2] Fi FC6{ m Fp Fi FC7{ m}} FC6 FC6 FC6 FC8{ m Fp}}}


void  S10103C92 ::mf10103c92(){}
 S10103C92 ::~S10103C92(){ note_dtor("S10103C92", this);}
S10103C92 ::S10103C92(){ note_ctor("S10103C92", this);} // tgen

static void Test_S10103C92()
{
  extern Class_Descriptor cd_S10103C92;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,26)];
    init_test(&cd_S10103C92, buf);
    S10103C92 *dp, &lv = *(dp=new (buf) S10103C92());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,100), "sizeof(S10103C92)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C92)");
    check_field_offset(lv, s10103c92f0, ABISELECT(8,4), "S10103C92.s10103c92f0");
    check_field_offset(lv, s10103c92f1, ABISELECT(24,12), "S10103C92.s10103c92f1");
    check_field_offset(lv, s10103c92f2, ABISELECT(40,24), "S10103C92.s10103c92f2");
    test_class_info(&lv, &cd_S10103C92);
    dp->~S10103C92();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C92(Test_S10103C92, "S10103C92", ABISELECT(144,100));

#else // __cplusplus

extern void _ZN9S10103C92C1Ev();
extern void _ZN9S10103C92D1Ev();
Name_Map name_map_S10103C92[] = {
  NSPAIR(_ZN9S10103C92C1Ev),
  NSPAIR(_ZN9S10103C92D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10103C92[];
extern void _ZN9S10103C92D1Ev();
extern void _ZN9S10103C92D0Ev();
static  VTBL_ENTRY vtc_S10103C92[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C92[0]),
  (VTBL_ENTRY)&_ZN9S10103C92D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C92D0Ev,
};
extern VTBL_ENTRY _ZTI9S10103C92[];
extern  VTBL_ENTRY _ZTV9S10103C92[];
Class_Descriptor cd_S10103C92 = {  "S10103C92", // class name
  0,0,//no base classes
  &(vtc_S10103C92[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,100), // object size
  NSPAIRA(_ZTI9S10103C92),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10103C92),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C62  : S10103C5_nt , S10103C12 {
  ::S10103C54_nt s10103c62f0;
  ::S10103C64 s10103c62f1;
  ::S10103C64 s10103c62f2;
  int s10103c62f3[2];
  ::S10103C66 s10103c62f4;
  void *s10103c62f5;
  ::S10103C68 s10103c62f6;
  char s10103c62f7;
  ::S10103C73 s10103c62f8;
  ::S10103C91 s10103c62f9;
  ::S10103C25_nt s10103c62f10[2];
  ::S10103C25_nt s10103c62f11[2];
  ::S10103C82_nt s10103c62f12;
  ::S10103C92 s10103c62f13;
  ::S10103C13_nt s10103c62f14;
  void *s10103c62f15[2];
  ::S10103C13_nt s10103c62f16;
  void *s10103c62f17[3];
  char s10103c62f18;
  virtual  ~S10103C62(); // _ZN9S10103C62D1Ev
  virtual void  v99(); // _ZN9S10103C623v99Ev
  virtual void  v100(); // _ZN9S10103C624v100Ev
  virtual void  v101(); // _ZN9S10103C624v101Ev
  virtual void  v102(); // _ZN9S10103C624v102Ev
  virtual void  v103(); // _ZN9S10103C624v103Ev
  virtual void  v104(); // _ZN9S10103C624v104Ev
  virtual void  v105(); // _ZN9S10103C624v105Ev
  virtual void  v106(); // _ZN9S10103C624v106Ev
  virtual void  v107(); // _ZN9S10103C624v107Ev
  virtual void  v108(); // _ZN9S10103C624v108Ev
  virtual void  v109(); // _ZN9S10103C624v109Ev
  virtual void  v110(); // _ZN9S10103C624v110Ev
  virtual void  v111(); // _ZN9S10103C624v111Ev
  S10103C62(); // tgen
};
//SIG(-1 S10103C62) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 FC11{ m Fp} FC12{ m Fp} FC12 Fi[2] FC13{ BC14{ vd v38 v39} FC7 Fi FL[2] Fi} Fp FC15{ m Fp[2] FC16{ vd v40 v41 FC17{ m Fp Fi[2] FC18{ m}} FC19{ m Fi[4]}[3] Fp[2] Fi Fc} Fp[2]} Fc FC20{ BC21{ BC22{ BC23{ vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 Fp[2] FC6 Fp} vd v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC24{ m Fp Fi FC25{ m} FC25} FC17 FC26{ m FC27{ m FL[2]}} FC6} v70 v71 v72 v73 FC28{ BC29{ BC23 vd v78 v79 v80 v81 v82 v83 Fp Fi FC30{ m Fp Fi FC18 FC31{ m}} FC26 Fi} vd v74 v75 v76 v77 FC6[4] FC26 FC26 FC26 FC26 Fi[6]} FC26 FC26} v42 v43 v44 v45 FC32{ m FC33{ m FL}} FC26} FC34{ BC23 vd v84 v85 v86 v87 v88 v89 Fp[2] FC26 FC26 FC26 Fi[13] Fp[3] Fi[3]} FC35{ Fi[4]}[2] FC35[2] FC26 FC36{ vd m Fp[2] FC30 FC37{ vd m FL[2] Fi FC7 FC7 FC7 FC7 FC11}} FC6 Fp[2] FC6 Fp[3] Fc}


 S10103C62 ::~S10103C62(){ note_dtor("S10103C62", this);}
void  S10103C62 ::v99(){vfunc_called(this, "_ZN9S10103C623v99Ev");}
void  S10103C62 ::v100(){vfunc_called(this, "_ZN9S10103C624v100Ev");}
void  S10103C62 ::v101(){vfunc_called(this, "_ZN9S10103C624v101Ev");}
void  S10103C62 ::v102(){vfunc_called(this, "_ZN9S10103C624v102Ev");}
void  S10103C62 ::v103(){vfunc_called(this, "_ZN9S10103C624v103Ev");}
void  S10103C62 ::v104(){vfunc_called(this, "_ZN9S10103C624v104Ev");}
void  S10103C62 ::v105(){vfunc_called(this, "_ZN9S10103C624v105Ev");}
void  S10103C62 ::v106(){vfunc_called(this, "_ZN9S10103C624v106Ev");}
void  S10103C62 ::v107(){vfunc_called(this, "_ZN9S10103C624v107Ev");}
void  S10103C62 ::v108(){vfunc_called(this, "_ZN9S10103C624v108Ev");}
void  S10103C62 ::v109(){vfunc_called(this, "_ZN9S10103C624v109Ev");}
void  S10103C62 ::v110(){vfunc_called(this, "_ZN9S10103C624v110Ev");}
void  S10103C62 ::v111(){vfunc_called(this, "_ZN9S10103C624v111Ev");}
S10103C62 ::S10103C62(){ note_ctor("S10103C62", this);} // tgen

static void Test_S10103C62()
{
  extern Class_Descriptor cd_S10103C62;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(180,264)];
    init_test(&cd_S10103C62, buf);
    S10103C62 *dp, &lv = *(dp=new (buf) S10103C62());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1432,1052), "sizeof(S10103C62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C62)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C62");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C62");
    check_field_offset(lv, s10103c62f0, ABISELECT(168,112), "S10103C62.s10103c62f0");
    check_field_offset(lv, s10103c62f1, ABISELECT(176,116), "S10103C62.s10103c62f1");
    check_field_offset(lv, s10103c62f2, ABISELECT(184,120), "S10103C62.s10103c62f2");
    check_field_offset(lv, s10103c62f3, ABISELECT(192,124), "S10103C62.s10103c62f3");
    check_field_offset(lv, s10103c62f4, ABISELECT(200,132), "S10103C62.s10103c62f4");
    check_field_offset(lv, s10103c62f5, ABISELECT(256,172), "S10103C62.s10103c62f5");
    check_field_offset(lv, s10103c62f6, ABISELECT(264,176), "S10103C62.s10103c62f6");
    check_field_offset(lv, s10103c62f7, ABISELECT(400,276), "S10103C62.s10103c62f7");
    check_field_offset(lv, s10103c62f8, ABISELECT(408,280), "S10103C62.s10103c62f8");
    check_field_offset(lv, s10103c62f9, ABISELECT(896,652), "S10103C62.s10103c62f9");
    check_field_offset(lv, s10103c62f10, ABISELECT(1112,816), "S10103C62.s10103c62f10");
    check_field_offset(lv, s10103c62f11, ABISELECT(1144,848), "S10103C62.s10103c62f11");
    check_field_offset(lv, s10103c62f12, ABISELECT(1176,880), "S10103C62.s10103c62f12");
    check_field_offset(lv, s10103c62f13, ABISELECT(1192,896), "S10103C62.s10103c62f13");
    check_field_offset(lv, s10103c62f14, ABISELECT(1336,996), "S10103C62.s10103c62f14");
    check_field_offset(lv, s10103c62f15, ABISELECT(1360,1012), "S10103C62.s10103c62f15");
    check_field_offset(lv, s10103c62f16, ABISELECT(1376,1020), "S10103C62.s10103c62f16");
    check_field_offset(lv, s10103c62f17, ABISELECT(1400,1036), "S10103C62.s10103c62f17");
    check_field_offset(lv, s10103c62f18, ABISELECT(1424,1048), "S10103C62.s10103c62f18");
    test_class_info(&lv, &cd_S10103C62);
    dp->~S10103C62();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C62(Test_S10103C62, "S10103C62", ABISELECT(1432,1052));

#else // __cplusplus

extern void _ZN9S10103C62C1Ev();
extern void _ZN9S10103C62D1Ev();
Name_Map name_map_S10103C62[] = {
  NSPAIR(_ZN9S10103C62C1Ev),
  NSPAIR(_ZN9S10103C62D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C62[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C62[];
extern void _ZN9S10103C62D1Ev();
extern void _ZN9S10103C62D0Ev();
extern void _ZN9S10103C623v99Ev();
extern void _ZN9S10103C624v100Ev();
extern void _ZN9S10103C624v101Ev();
extern void _ZN9S10103C624v102Ev();
extern void _ZN9S10103C624v103Ev();
extern void _ZN9S10103C624v104Ev();
extern void _ZN9S10103C624v105Ev();
extern void _ZN9S10103C624v106Ev();
extern void _ZN9S10103C624v107Ev();
extern void _ZN9S10103C624v108Ev();
extern void _ZN9S10103C624v109Ev();
extern void _ZN9S10103C624v110Ev();
extern void _ZN9S10103C624v111Ev();
extern void ABISELECT(_ZThn48_N9S10103C62D1Ev,_ZThn32_N9S10103C62D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C62D0Ev,_ZThn32_N9S10103C62D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C62[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C62[0]),
  (VTBL_ENTRY)&_ZN9S10103C62D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C62D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C623v99Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v100Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v101Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v102Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v103Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v104Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v105Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v106Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v107Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v108Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v109Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v110Ev,
  (VTBL_ENTRY)&_ZN9S10103C624v111Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C62[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C62D1Ev,_ZThn32_N9S10103C62D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C62D0Ev,_ZThn32_N9S10103C62D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C62[];
extern  VTBL_ENTRY _ZTV9S10103C62[];
Class_Descriptor cd_S10103C62 = {  "S10103C62", // class name
  bases_S10103C62, 2,
  &(vtc_S10103C62[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1432,1052), // object size
  NSPAIRA(_ZTI9S10103C62),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C62),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C98  : S10103C5_nt , S10103C12 {
  ::S10103C96 s10103c98f0;
  __tsi64 s10103c98f1;
  int s10103c98f2;
  virtual  ~S10103C98(); // _ZN9S10103C98D1Ev
  virtual void  v167(); // _ZN9S10103C984v167Ev
  virtual void  v168(); // _ZN9S10103C984v168Ev
  virtual void  v169(); // _ZN9S10103C984v169Ev
  S10103C98(); // tgen
};
//SIG(-1 S10103C98) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 FC11{ vd m FL[2] Fi FC7 FC7 FC7 FC7 FC12{ m Fp}} FL Fi}


 S10103C98 ::~S10103C98(){ note_dtor("S10103C98", this);}
void  S10103C98 ::v167(){vfunc_called(this, "_ZN9S10103C984v167Ev");}
void  S10103C98 ::v168(){vfunc_called(this, "_ZN9S10103C984v168Ev");}
void  S10103C98 ::v169(){vfunc_called(this, "_ZN9S10103C984v169Ev");}
S10103C98 ::S10103C98(){ note_ctor("S10103C98", this);} // tgen

static void Test_S10103C98()
{
  extern Class_Descriptor cd_S10103C98;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,51)];
    init_test(&cd_S10103C98, buf);
    S10103C98 *dp, &lv = *(dp=new (buf) S10103C98());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,200), "sizeof(S10103C98)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C98)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C98");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C98");
    check_field_offset(lv, s10103c98f0, ABISELECT(168,112), "S10103C98.s10103c98f0");
    check_field_offset(lv, s10103c98f1, ABISELECT(272,188), "S10103C98.s10103c98f1");
    check_field_offset(lv, s10103c98f2, ABISELECT(280,196), "S10103C98.s10103c98f2");
    test_class_info(&lv, &cd_S10103C98);
    dp->~S10103C98();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C98(Test_S10103C98, "S10103C98", ABISELECT(288,200));

#else // __cplusplus

extern void _ZN9S10103C98C1Ev();
extern void _ZN9S10103C98D1Ev();
Name_Map name_map_S10103C98[] = {
  NSPAIR(_ZN9S10103C98C1Ev),
  NSPAIR(_ZN9S10103C98D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C98[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C98[];
extern void _ZN9S10103C98D1Ev();
extern void _ZN9S10103C98D0Ev();
extern void _ZN9S10103C984v167Ev();
extern void _ZN9S10103C984v168Ev();
extern void _ZN9S10103C984v169Ev();
extern void ABISELECT(_ZThn48_N9S10103C98D1Ev,_ZThn32_N9S10103C98D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C98D0Ev,_ZThn32_N9S10103C98D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C98[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C98[0]),
  (VTBL_ENTRY)&_ZN9S10103C98D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C98D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C984v167Ev,
  (VTBL_ENTRY)&_ZN9S10103C984v168Ev,
  (VTBL_ENTRY)&_ZN9S10103C984v169Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C98[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C98D1Ev,_ZThn32_N9S10103C98D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C98D0Ev,_ZThn32_N9S10103C98D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C98[];
extern  VTBL_ENTRY _ZTV9S10103C98[];
Class_Descriptor cd_S10103C98 = {  "S10103C98", // class name
  bases_S10103C98, 2,
  &(vtc_S10103C98[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,200), // object size
  NSPAIRA(_ZTI9S10103C98),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C98),35, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C97  : S10103C98 {
  virtual  ~S10103C97(); // _ZN9S10103C97D1Ev
  virtual void  v164(); // _ZN9S10103C974v164Ev
  virtual void  v165(); // _ZN9S10103C974v165Ev
  virtual void  v166(); // _ZN9S10103C974v166Ev
  S10103C97(); // tgen
};
//SIG(-1 S10103C97) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC11{ m Fc Fi[2] Fp}} vd v28 v29 v30 FC12{ vd m FL[2] Fi FC8 FC8 FC8 FC8 FC13{ m Fp}} FL Fi} vd v1 v2 v3}


 S10103C97 ::~S10103C97(){ note_dtor("S10103C97", this);}
void  S10103C97 ::v164(){vfunc_called(this, "_ZN9S10103C974v164Ev");}
void  S10103C97 ::v165(){vfunc_called(this, "_ZN9S10103C974v165Ev");}
void  S10103C97 ::v166(){vfunc_called(this, "_ZN9S10103C974v166Ev");}
S10103C97 ::S10103C97(){ note_ctor("S10103C97", this);} // tgen

static void Test_S10103C97()
{
  extern Class_Descriptor cd_S10103C97;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,51)];
    init_test(&cd_S10103C97, buf);
    S10103C97 *dp, &lv = *(dp=new (buf) S10103C97());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,200), "sizeof(S10103C97)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C97)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C98*), 0, "S10103C97");
    check_base_class_offset(lv, (S10103C12*)(S10103C98*), ABISELECT(48,32), "S10103C97");
    check_base_class_offset(lv, (S10103C98*), 0, "S10103C97");
    test_class_info(&lv, &cd_S10103C97);
    dp->~S10103C97();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C97(Test_S10103C97, "S10103C97", ABISELECT(288,200));

#else // __cplusplus

extern void _ZN9S10103C97C1Ev();
extern void _ZN9S10103C97D1Ev();
Name_Map name_map_S10103C97[] = {
  NSPAIR(_ZN9S10103C97C1Ev),
  NSPAIR(_ZN9S10103C97D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
extern Class_Descriptor cd_S10103C98;
extern VTBL_ENTRY _ZTI9S10103C98[];
extern  VTBL_ENTRY _ZTV9S10103C98[];
static Base_Class bases_S10103C97[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C98,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C97[];
extern void _ZN9S10103C97D1Ev();
extern void _ZN9S10103C97D0Ev();
extern void _ZN9S10103C984v167Ev();
extern void _ZN9S10103C984v168Ev();
extern void _ZN9S10103C984v169Ev();
extern void _ZN9S10103C974v164Ev();
extern void _ZN9S10103C974v165Ev();
extern void _ZN9S10103C974v166Ev();
extern void ABISELECT(_ZThn48_N9S10103C97D1Ev,_ZThn32_N9S10103C97D1Ev)();
extern void ABISELECT(_ZThn48_N9S10103C97D0Ev,_ZThn32_N9S10103C97D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C97[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C97[0]),
  (VTBL_ENTRY)&_ZN9S10103C97D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C97D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C984v167Ev,
  (VTBL_ENTRY)&_ZN9S10103C984v168Ev,
  (VTBL_ENTRY)&_ZN9S10103C984v169Ev,
  (VTBL_ENTRY)&_ZN9S10103C974v164Ev,
  (VTBL_ENTRY)&_ZN9S10103C974v165Ev,
  (VTBL_ENTRY)&_ZN9S10103C974v166Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10103C97[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C97D1Ev,_ZThn32_N9S10103C97D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10103C97D0Ev,_ZThn32_N9S10103C97D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10103C97[];
extern  VTBL_ENTRY _ZTV9S10103C97[];
Class_Descriptor cd_S10103C97 = {  "S10103C97", // class name
  bases_S10103C97, 3,
  &(vtc_S10103C97[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,200), // object size
  NSPAIRA(_ZTI9S10103C97),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10103C97),38, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C100  : S10103C5_nt , S10103C12 {
  ::S10103C68 s10103c100f0;
  ::S10103C54_nt s10103c100f1;
  void *s10103c100f2;
  virtual  ~S10103C100(); // _ZN10S10103C100D1Ev
  virtual void  v173(); // _ZN10S10103C1004v173Ev
  virtual void  v174(); // _ZN10S10103C1004v174Ev
  virtual void  v175(); // _ZN10S10103C1004v175Ev
  virtual void  v176(); // _ZN10S10103C1004v176Ev
  virtual void  v177(); // _ZN10S10103C1004v177Ev
  virtual void  v178(); // _ZN10S10103C1004v178Ev
  virtual void  v179(); // _ZN10S10103C1004v179Ev
  virtual void  v180(); // _ZN10S10103C1004v180Ev
  S10103C100(); // tgen
};
//SIG(-1 S10103C100) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4 v5 v6 v7 v8 FC11{ m Fp[2] FC12{ vd v33 v34 FC13{ m Fp Fi[2] FC14{ m}} FC15{ m Fi[4]}[3] Fp[2] Fi Fc} Fp[2]} FC16{ m Fp} Fp}


 S10103C100 ::~S10103C100(){ note_dtor("S10103C100", this);}
void  S10103C100 ::v173(){vfunc_called(this, "_ZN10S10103C1004v173Ev");}
void  S10103C100 ::v174(){vfunc_called(this, "_ZN10S10103C1004v174Ev");}
void  S10103C100 ::v175(){vfunc_called(this, "_ZN10S10103C1004v175Ev");}
void  S10103C100 ::v176(){vfunc_called(this, "_ZN10S10103C1004v176Ev");}
void  S10103C100 ::v177(){vfunc_called(this, "_ZN10S10103C1004v177Ev");}
void  S10103C100 ::v178(){vfunc_called(this, "_ZN10S10103C1004v178Ev");}
void  S10103C100 ::v179(){vfunc_called(this, "_ZN10S10103C1004v179Ev");}
void  S10103C100 ::v180(){vfunc_called(this, "_ZN10S10103C1004v180Ev");}
S10103C100 ::S10103C100(){ note_ctor("S10103C100", this);} // tgen

static void Test_S10103C100()
{
  extern Class_Descriptor cd_S10103C100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,56)];
    init_test(&cd_S10103C100, buf);
    S10103C100 *dp, &lv = *(dp=new (buf) S10103C100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,220), "sizeof(S10103C100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C100)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10103C100");
    check_base_class_offset(lv, (S10103C12*), ABISELECT(48,32), "S10103C100");
    check_field_offset(lv, s10103c100f0, ABISELECT(168,112), "S10103C100.s10103c100f0");
    check_field_offset(lv, s10103c100f1, ABISELECT(304,212), "S10103C100.s10103c100f1");
    check_field_offset(lv, s10103c100f2, ABISELECT(312,216), "S10103C100.s10103c100f2");
    test_class_info(&lv, &cd_S10103C100);
    dp->~S10103C100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C100(Test_S10103C100, "S10103C100", ABISELECT(320,220));

#else // __cplusplus

extern void _ZN10S10103C100C1Ev();
extern void _ZN10S10103C100D1Ev();
Name_Map name_map_S10103C100[] = {
  NSPAIR(_ZN10S10103C100C1Ev),
  NSPAIR(_ZN10S10103C100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10103C100[];
extern void _ZN10S10103C100D1Ev();
extern void _ZN10S10103C100D0Ev();
extern void _ZN10S10103C1004v173Ev();
extern void _ZN10S10103C1004v174Ev();
extern void _ZN10S10103C1004v175Ev();
extern void _ZN10S10103C1004v176Ev();
extern void _ZN10S10103C1004v177Ev();
extern void _ZN10S10103C1004v178Ev();
extern void _ZN10S10103C1004v179Ev();
extern void _ZN10S10103C1004v180Ev();
extern void ABISELECT(_ZThn48_N10S10103C100D1Ev,_ZThn32_N10S10103C100D1Ev)();
extern void ABISELECT(_ZThn48_N10S10103C100D0Ev,_ZThn32_N10S10103C100D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
static  VTBL_ENTRY vtc_S10103C100[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10103C100[0]),
  (VTBL_ENTRY)&_ZN10S10103C100D1Ev,
  (VTBL_ENTRY)&_ZN10S10103C100D0Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v173Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v174Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v175Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v176Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v177Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v178Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v179Ev,
  (VTBL_ENTRY)&_ZN10S10103C1004v180Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10103C100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10103C100D1Ev,_ZThn32_N10S10103C100D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10103C100D0Ev,_ZThn32_N10S10103C100D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
};
extern VTBL_ENTRY _ZTI10S10103C100[];
extern  VTBL_ENTRY _ZTV10S10103C100[];
Class_Descriptor cd_S10103C100 = {  "S10103C100", // class name
  bases_S10103C100, 2,
  &(vtc_S10103C100[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,220), // object size
  NSPAIRA(_ZTI10S10103C100),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S10103C100),40, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C101  : S10103C28 , S10103C2_nt {
  int s10103c101f0;
  void *s10103c101f1;
  int s10103c101f2;
  ::S10103C29 s10103c101f3;
  virtual  ~S10103C101(); // _ZN10S10103C101D1Ev
  virtual void  v181(); // _ZN10S10103C1014v181Ev
  virtual void  v182(); // _ZN10S10103C1014v182Ev
  virtual void  v183(); // _ZN10S10103C1014v183Ev
  virtual void  v184(); // _ZN10S10103C1014v184Ev
  virtual void  v185(); // _ZN10S10103C1014v185Ev
  virtual void  v186(); // _ZN10S10103C1014v186Ev
  S10103C101(); // tgen
};
//SIG(-1 S10103C101) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} BC6{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC11{ m Fc Fi[2] Fp}} vd v31 v32 v33 v34 v35 v36 v37 v38 v39} BC12{ vd v40} vd v1 v2 v3 v4 v5 v6 Fi Fp Fi FC13{ m Fi Fp Fi Fp[2] Fi}}


 S10103C101 ::~S10103C101(){ note_dtor("S10103C101", this);}
void  S10103C101 ::v181(){vfunc_called(this, "_ZN10S10103C1014v181Ev");}
void  S10103C101 ::v182(){vfunc_called(this, "_ZN10S10103C1014v182Ev");}
void  S10103C101 ::v183(){vfunc_called(this, "_ZN10S10103C1014v183Ev");}
void  S10103C101 ::v184(){vfunc_called(this, "_ZN10S10103C1014v184Ev");}
void  S10103C101 ::v185(){vfunc_called(this, "_ZN10S10103C1014v185Ev");}
void  S10103C101 ::v186(){vfunc_called(this, "_ZN10S10103C1014v186Ev");}
S10103C101 ::S10103C101(){ note_ctor("S10103C101", this);} // tgen

static void Test_S10103C101()
{
  extern Class_Descriptor cd_S10103C101;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,39)];
    init_test(&cd_S10103C101, buf);
    S10103C101 *dp, &lv = *(dp=new (buf) S10103C101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,152), "sizeof(S10103C101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C101)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10103C28*), 0, "S10103C101");
    check_base_class_offset(lv, (S10103C12*)(S10103C28*), ABISELECT(48,32), "S10103C101");
    check_base_class_offset(lv, (S10103C28*), 0, "S10103C101");
    check_base_class_offset(lv, (S10103C2_nt*), ABISELECT(168,112), "S10103C101");
    check_field_offset(lv, s10103c101f0, ABISELECT(176,116), "S10103C101.s10103c101f0");
    check_field_offset(lv, s10103c101f1, ABISELECT(184,120), "S10103C101.s10103c101f1");
    check_field_offset(lv, s10103c101f2, ABISELECT(192,124), "S10103C101.s10103c101f2");
    check_field_offset(lv, s10103c101f3, ABISELECT(200,128), "S10103C101.s10103c101f3");
    test_class_info(&lv, &cd_S10103C101);
    dp->~S10103C101();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C101(Test_S10103C101, "S10103C101", ABISELECT(248,152));

#else // __cplusplus

extern void _ZN10S10103C101C1Ev();
extern void _ZN10S10103C101D1Ev();
Name_Map name_map_S10103C101[] = {
  NSPAIR(_ZN10S10103C101C1Ev),
  NSPAIR(_ZN10S10103C101D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
extern Class_Descriptor cd_S10103C28;
extern VTBL_ENTRY _ZTI9S10103C28[];
extern  VTBL_ENTRY _ZTV9S10103C28[];
extern Class_Descriptor cd_S10103C2_nt;
extern VTBL_ENTRY _ZTI11S10103C2_nt[];
extern  VTBL_ENTRY _ZTV11S10103C2_nt[];
static Base_Class bases_S10103C101[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C12,    ABISELECT(48,32), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10103C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C2_nt,    ABISELECT(168,112), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10103C101[];
extern void _ZN10S10103C101D1Ev();
extern void _ZN10S10103C101D0Ev();
extern void _ZN9S10103C283v47Ev();
extern void _ZN9S10103C283v48Ev();
extern void _ZN9S10103C283v49Ev();
extern void _ZN9S10103C283v50Ev();
extern void _ZN9S10103C283v51Ev();
extern void _ZN9S10103C283v52Ev();
extern void _ZN9S10103C283v53Ev();
extern void _ZN9S10103C283v54Ev();
extern void _ZN9S10103C283v55Ev();
extern void _ZN10S10103C1014v181Ev();
extern void _ZN10S10103C1014v182Ev();
extern void _ZN10S10103C1014v183Ev();
extern void _ZN10S10103C1014v184Ev();
extern void _ZN10S10103C1014v185Ev();
extern void _ZN10S10103C1014v186Ev();
extern void ABISELECT(_ZThn48_N10S10103C101D1Ev,_ZThn32_N10S10103C101D1Ev)();
extern void ABISELECT(_ZThn48_N10S10103C101D0Ev,_ZThn32_N10S10103C101D0Ev)();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
extern void ABISELECT(_ZThn168_N10S10103C101D1Ev,_ZThn112_N10S10103C101D1Ev)();
extern void ABISELECT(_ZThn168_N10S10103C101D0Ev,_ZThn112_N10S10103C101D0Ev)();
extern void _ZN11S10103C2_nt2v6Ev();
static  VTBL_ENTRY vtc_S10103C101[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10103C101[0]),
  (VTBL_ENTRY)&_ZN10S10103C101D1Ev,
  (VTBL_ENTRY)&_ZN10S10103C101D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v47Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v48Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v49Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v50Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v51Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v52Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v53Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v54Ev,
  (VTBL_ENTRY)&_ZN9S10103C283v55Ev,
  (VTBL_ENTRY)&_ZN10S10103C1014v181Ev,
  (VTBL_ENTRY)&_ZN10S10103C1014v182Ev,
  (VTBL_ENTRY)&_ZN10S10103C1014v183Ev,
  (VTBL_ENTRY)&_ZN10S10103C1014v184Ev,
  (VTBL_ENTRY)&_ZN10S10103C1014v185Ev,
  (VTBL_ENTRY)&_ZN10S10103C1014v186Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10103C101[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10103C101D1Ev,_ZThn32_N10S10103C101D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10103C101D0Ev,_ZThn32_N10S10103C101D0Ev),
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
  ABISELECT(-168,-112),
  (VTBL_ENTRY)&(_ZTI10S10103C101[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N10S10103C101D1Ev,_ZThn112_N10S10103C101D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N10S10103C101D0Ev,_ZThn112_N10S10103C101D0Ev),
  (VTBL_ENTRY)&_ZN11S10103C2_nt2v6Ev,
};
extern VTBL_ENTRY _ZTI10S10103C101[];
extern  VTBL_ENTRY _ZTV10S10103C101[];
Class_Descriptor cd_S10103C101 = {  "S10103C101", // class name
  bases_S10103C101, 4,
  &(vtc_S10103C101[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,152), // object size
  NSPAIRA(_ZTI10S10103C101),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S10103C101),52, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C102  : S10103C12 {
  virtual  ~S10103C102(); // _ZN10S10103C102D1Ev
  virtual void  v187(); // _ZN10S10103C1024v187Ev
  virtual void  v188(); // _ZN10S10103C1024v188Ev
  virtual void  v189(); // _ZN10S10103C1024v189Ev
  virtual void  v190(); // _ZN10S10103C1024v190Ev
  S10103C102(); // tgen
};
//SIG(-1 S10103C102) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} FC6{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC7{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4}


 S10103C102 ::~S10103C102(){ note_dtor("S10103C102", this);}
void  S10103C102 ::v187(){vfunc_called(this, "_ZN10S10103C1024v187Ev");}
void  S10103C102 ::v188(){vfunc_called(this, "_ZN10S10103C1024v188Ev");}
void  S10103C102 ::v189(){vfunc_called(this, "_ZN10S10103C1024v189Ev");}
void  S10103C102 ::v190(){vfunc_called(this, "_ZN10S10103C1024v190Ev");}
S10103C102 ::S10103C102(){ note_ctor("S10103C102", this);} // tgen

static void Test_S10103C102()
{
  extern Class_Descriptor cd_S10103C102;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S10103C102, buf);
    S10103C102 *dp, &lv = *(dp=new (buf) S10103C102());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S10103C102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C102)");
    check_base_class_offset(lv, (S10103C12*), 0, "S10103C102");
    test_class_info(&lv, &cd_S10103C102);
    dp->~S10103C102();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C102(Test_S10103C102, "S10103C102", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN10S10103C102C1Ev();
extern void _ZN10S10103C102D1Ev();
Name_Map name_map_S10103C102[] = {
  NSPAIR(_ZN10S10103C102C1Ev),
  NSPAIR(_ZN10S10103C102D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C12;
extern VTBL_ENTRY _ZTI9S10103C12[];
extern  VTBL_ENTRY _ZTV9S10103C12[];
static Base_Class bases_S10103C102[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10103C102[];
extern void _ZN10S10103C102D1Ev();
extern void _ZN10S10103C102D0Ev();
extern void _ZN9S10103C123v14Ev();
extern void _ZN9S10103C123v15Ev();
extern void _ZN9S10103C123v16Ev();
extern void _ZN9S10103C123v17Ev();
extern void _ZN9S10103C123v18Ev();
extern void _ZN9S10103C123v19Ev();
extern void _ZN9S10103C123v20Ev();
extern void _ZN9S10103C123v21Ev();
extern void _ZN9S10103C123v22Ev();
extern void _ZN9S10103C123v23Ev();
extern void _ZN9S10103C123v24Ev();
extern void _ZN9S10103C123v25Ev();
extern void _ZN9S10103C123v26Ev();
extern void _ZN9S10103C123v27Ev();
extern void _ZN9S10103C123v28Ev();
extern void _ZN9S10103C123v29Ev();
extern void _ZN9S10103C123v30Ev();
extern void _ZN9S10103C123v31Ev();
extern void _ZN9S10103C123v32Ev();
extern void _ZN9S10103C123v33Ev();
extern void _ZN9S10103C123v34Ev();
extern void _ZN9S10103C123v35Ev();
extern void _ZN9S10103C123v36Ev();
extern void _ZN9S10103C123v37Ev();
extern void _ZN10S10103C1024v187Ev();
extern void _ZN10S10103C1024v188Ev();
extern void _ZN10S10103C1024v189Ev();
extern void _ZN10S10103C1024v190Ev();
static  VTBL_ENTRY vtc_S10103C102[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10103C102[0]),
  (VTBL_ENTRY)&_ZN10S10103C102D1Ev,
  (VTBL_ENTRY)&_ZN10S10103C102D0Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10103C123v37Ev,
  (VTBL_ENTRY)&_ZN10S10103C1024v187Ev,
  (VTBL_ENTRY)&_ZN10S10103C1024v188Ev,
  (VTBL_ENTRY)&_ZN10S10103C1024v189Ev,
  (VTBL_ENTRY)&_ZN10S10103C1024v190Ev,
};
extern VTBL_ENTRY _ZTI10S10103C102[];
extern  VTBL_ENTRY _ZTV10S10103C102[];
Class_Descriptor cd_S10103C102 = {  "S10103C102", // class name
  bases_S10103C102, 1,
  &(vtc_S10103C102[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI10S10103C102),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10103C102),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C61  : S10103C2_nt , S10103C3_nt {
  void *s10103c61f0;
  ::S10103C62 s10103c61f1;
  ::S10103C47 s10103c61f2;
  ::S10103C40 s10103c61f3;
  ::S10103C97 s10103c61f4;
  ::S10103C97 s10103c61f5;
  ::S10103C100 s10103c61f6;
  ::S10103C101 s10103c61f7;
  ::S10103C102 s10103c61f8;
  ::S10103C96 s10103c61f9;
  ::S10103C56 s10103c61f10;
  ::S10103C56 s10103c61f11;
  void *s10103c61f12;
  virtual  ~S10103C61(); // _ZN9S10103C61D1Ev
  virtual void  v94(); // _ZN9S10103C613v94Ev
  virtual void  v95(); // _ZN9S10103C613v95Ev
  virtual void  v96(); // _ZN9S10103C613v96Ev
  virtual void  v97(); // _ZN9S10103C613v97Ev
  virtual void  v98(); // _ZN9S10103C613v98Ev
  S10103C61(); // tgen
};
//SIG(-1 S10103C61) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} vd v1 v2 v3 v4 v5 Fp FC4{ BC5{ vd m FC6{ m Fp Fi FC7{ m} FC7} FC6 Fc} BC8{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 Fp FC9{ m FC10{ m Fp Fi FC11{ m}} Fi} FC12{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC13{ m Fc Fi[2] Fp}} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC14{ m Fp} FC15{ m Fp} FC15 Fi[2] FC16{ BC17{ vd v49 v50} FC10 Fi FL[2] Fi} Fp FC18{ m Fp[2] FC19{ vd v51 v52 FC20{ m Fp Fi[2] FC21{ m}} FC22{ m Fi[4]}[3] Fp[2] Fi Fc} Fp[2]} Fc FC23{ BC24{ BC25{ BC26{ vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fp[2] FC9 Fp} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 FC27{ m Fp Fi FC28{ m} FC28} FC20 FC29{ m FC30{ m FL[2]}} FC9} v81 v82 v83 v84 FC31{ BC32{ BC26 vd v89 v90 v91 v92 v93 v94 Fp Fi FC33{ m Fp Fi FC21 FC34{ m}} FC29 Fi} vd v85 v86 v87 v88 FC9[4] FC29 FC29 FC29 FC29 Fi[6]} FC29 FC29} v53 v54 v55 v56 FC35{ m FC36{ m FL}} FC29} FC37{ BC26 vd v95 v96 v97 v98 v99 v100 Fp[2] FC29 FC29 FC29 Fi[13] Fp[3] Fi[3]} FC38{ Fi[4]}[2] FC38[2] FC29 FC39{ vd m Fp[2] FC33 FC40{ vd m FL[2] Fi FC10 FC10 FC10 FC10 FC14}} FC9 Fp[2] FC9 Fp[3] Fc} FC41{ BC42{ BC5 vd v102 v103 v104 v105 FC43{ m Fp FC9 FC10 FC10 Fi} Fp Fc Fi} v101} FC44{ BC42 v106 v107} FC45{ BC46{ BC5 BC8 vd v111 v112 v113 FC40 FL Fi} vd v108 v109 v110} FC45 FC47{ BC5 BC8 vd v114 v115 v116 v117 v118 v119 v120 v121 FC18 FC14 Fp} FC48{ BC49{ BC5 BC8 vd v128 v129 v130 v131 v132 v133 v134 v135 v136} BC2 vd v122 v123 v124 v125 v126 v127 Fi Fp Fi FC50{ m Fi Fp Fi Fp[2] Fi}} FC51{ BC8 vd v137 v138 v139 v140} FC40 FC52{ BC42 v141} FC52 Fp}


 S10103C61 ::~S10103C61(){ note_dtor("S10103C61", this);}
void  S10103C61 ::v94(){vfunc_called(this, "_ZN9S10103C613v94Ev");}
void  S10103C61 ::v95(){vfunc_called(this, "_ZN9S10103C613v95Ev");}
void  S10103C61 ::v96(){vfunc_called(this, "_ZN9S10103C613v96Ev");}
void  S10103C61 ::v97(){vfunc_called(this, "_ZN9S10103C613v97Ev");}
void  S10103C61 ::v98(){vfunc_called(this, "_ZN9S10103C613v98Ev");}
S10103C61 ::S10103C61(){ note_ctor("S10103C61", this);} // tgen

static void Test_S10103C61()
{
  extern Class_Descriptor cd_S10103C61;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(424,593)];
    init_test(&cd_S10103C61, buf);
    S10103C61 *dp, &lv = *(dp=new (buf) S10103C61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3384,2368), "sizeof(S10103C61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C61)");
    check_base_class_offset(lv, (S10103C2_nt*), 0, "S10103C61");
    check_base_class_offset(lv, (S10103C3_nt*), ABISELECT(8,4), "S10103C61");
    check_field_offset(lv, s10103c61f0, ABISELECT(24,12), "S10103C61.s10103c61f0");
    check_field_offset(lv, s10103c61f1, ABISELECT(32,16), "S10103C61.s10103c61f1");
    check_field_offset(lv, s10103c61f2, ABISELECT(1464,1068), "S10103C61.s10103c61f2");
    check_field_offset(lv, s10103c61f3, ABISELECT(1600,1160), "S10103C61.s10103c61f3");
    check_field_offset(lv, s10103c61f4, ABISELECT(1736,1252), "S10103C61.s10103c61f4");
    check_field_offset(lv, s10103c61f5, ABISELECT(2024,1452), "S10103C61.s10103c61f5");
    check_field_offset(lv, s10103c61f6, ABISELECT(2312,1652), "S10103C61.s10103c61f6");
    check_field_offset(lv, s10103c61f7, ABISELECT(2632,1872), "S10103C61.s10103c61f7");
    check_field_offset(lv, s10103c61f8, ABISELECT(2880,2024), "S10103C61.s10103c61f8");
    check_field_offset(lv, s10103c61f9, ABISELECT(3000,2104), "S10103C61.s10103c61f9");
    check_field_offset(lv, s10103c61f10, ABISELECT(3104,2180), "S10103C61.s10103c61f10");
    check_field_offset(lv, s10103c61f11, ABISELECT(3240,2272), "S10103C61.s10103c61f11");
    check_field_offset(lv, s10103c61f12, ABISELECT(3376,2364), "S10103C61.s10103c61f12");
    test_class_info(&lv, &cd_S10103C61);
    dp->~S10103C61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C61(Test_S10103C61, "S10103C61", ABISELECT(3384,2368));

#else // __cplusplus

extern void _ZN9S10103C61C1Ev();
extern void _ZN9S10103C61D1Ev();
Name_Map name_map_S10103C61[] = {
  NSPAIR(_ZN9S10103C61C1Ev),
  NSPAIR(_ZN9S10103C61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C2_nt;
extern VTBL_ENTRY _ZTI11S10103C2_nt[];
extern  VTBL_ENTRY _ZTV11S10103C2_nt[];
extern Class_Descriptor cd_S10103C3_nt;
extern VTBL_ENTRY _ZTI11S10103C3_nt[];
extern  VTBL_ENTRY _ZTV11S10103C3_nt[];
static Base_Class bases_S10103C61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C3_nt,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10103C61[];
extern void _ZN9S10103C61D1Ev();
extern void _ZN9S10103C61D0Ev();
extern void _ZN11S10103C2_nt2v6Ev();
extern void _ZN9S10103C613v94Ev();
extern void _ZN9S10103C613v95Ev();
extern void _ZN9S10103C613v96Ev();
extern void _ZN9S10103C613v97Ev();
extern void _ZN9S10103C613v98Ev();
extern void ABISELECT(_ZThn8_N9S10103C61D1Ev,_ZThn4_N9S10103C61D1Ev)();
extern void ABISELECT(_ZThn8_N9S10103C61D0Ev,_ZThn4_N9S10103C61D0Ev)();
extern void _ZN11S10103C3_nt2v7Ev();
extern void _ZN11S10103C3_nt2v8Ev();
extern void _ZN11S10103C3_nt2v9Ev();
extern void _ZN11S10103C3_nt3v10Ev();
extern void _ZN11S10103C3_nt3v11Ev();
static  VTBL_ENTRY vtc_S10103C61[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10103C61[0]),
  (VTBL_ENTRY)&_ZN9S10103C61D1Ev,
  (VTBL_ENTRY)&_ZN9S10103C61D0Ev,
  (VTBL_ENTRY)&_ZN11S10103C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S10103C613v94Ev,
  (VTBL_ENTRY)&_ZN9S10103C613v95Ev,
  (VTBL_ENTRY)&_ZN9S10103C613v96Ev,
  (VTBL_ENTRY)&_ZN9S10103C613v97Ev,
  (VTBL_ENTRY)&_ZN9S10103C613v98Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10103C61[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10103C61D1Ev,_ZThn4_N9S10103C61D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10103C61D0Ev,_ZThn4_N9S10103C61D0Ev),
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI9S10103C61[];
extern  VTBL_ENTRY _ZTV9S10103C61[];
Class_Descriptor cd_S10103C61 = {  "S10103C61", // class name
  bases_S10103C61, 2,
  &(vtc_S10103C61[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3384,2368), // object size
  NSPAIRA(_ZTI9S10103C61),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10103C61),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C105  {
  void *s10103c105f0;
  void  mf10103c105(); // _ZN10S10103C10511mf10103c105Ev
};
//SIG(-1 S10103C105) C1{ m Fp}


void  S10103C105 ::mf10103c105(){}

static void Test_S10103C105()
{
  {
    init_simple_test("S10103C105");
    S10103C105 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10103C105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C105)");
    check_field_offset(lv, s10103c105f0, 0, "S10103C105.s10103c105f0");
  }
}
static Arrange_To_Call_Me vS10103C105(Test_S10103C105, "S10103C105", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C106  {
  void *s10103c106f0;
  int s10103c106f1[2];
  ::S10103C88 s10103c106f2;
  void  mf10103c106(); // _ZN10S10103C10611mf10103c106Ev
};
//SIG(-1 S10103C106) C1{ m Fp Fi[2] FC2{ m}}


void  S10103C106 ::mf10103c106(){}

static void Test_S10103C106()
{
  {
    init_simple_test("S10103C106");
    S10103C106 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10103C106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C106)");
    check_field_offset(lv, s10103c106f0, 0, "S10103C106.s10103c106f0");
    check_field_offset(lv, s10103c106f1, ABISELECT(8,4), "S10103C106.s10103c106f1");
    check_field_offset(lv, s10103c106f2, ABISELECT(16,12), "S10103C106.s10103c106f2");
  }
}
static Arrange_To_Call_Me vS10103C106(Test_S10103C106, "S10103C106", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C104  {
  char s10103c104f0;
  ::S10103C105 s10103c104f1;
  ::S10103C106 s10103c104f2;
  void  mf10103c104(); // _ZN10S10103C10411mf10103c104Ev
  virtual  ~S10103C104(); // _ZN10S10103C104D1Ev
  S10103C104(); // tgen
};
//SIG(-1 S10103C104) C1{ vd m Fc FC2{ m Fp} FC3{ m Fp Fi[2] FC4{ m}}}


void  S10103C104 ::mf10103c104(){}
 S10103C104 ::~S10103C104(){ note_dtor("S10103C104", this);}
S10103C104 ::S10103C104(){ note_ctor("S10103C104", this);} // tgen

static void Test_S10103C104()
{
  extern Class_Descriptor cd_S10103C104;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S10103C104, buf);
    S10103C104 *dp, &lv = *(dp=new (buf) S10103C104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S10103C104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C104)");
    check_field_offset(lv, s10103c104f0, ABISELECT(8,4), "S10103C104.s10103c104f0");
    check_field_offset(lv, s10103c104f1, ABISELECT(16,8), "S10103C104.s10103c104f1");
    check_field_offset(lv, s10103c104f2, ABISELECT(24,12), "S10103C104.s10103c104f2");
    test_class_info(&lv, &cd_S10103C104);
    dp->~S10103C104();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C104(Test_S10103C104, "S10103C104", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN10S10103C104C1Ev();
extern void _ZN10S10103C104D1Ev();
Name_Map name_map_S10103C104[] = {
  NSPAIR(_ZN10S10103C104C1Ev),
  NSPAIR(_ZN10S10103C104D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S10103C104[];
extern void _ZN10S10103C104D1Ev();
extern void _ZN10S10103C104D0Ev();
static  VTBL_ENTRY vtc_S10103C104[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10103C104[0]),
  (VTBL_ENTRY)&_ZN10S10103C104D1Ev,
  (VTBL_ENTRY)&_ZN10S10103C104D0Ev,
};
extern VTBL_ENTRY _ZTI10S10103C104[];
extern  VTBL_ENTRY _ZTV10S10103C104[];
Class_Descriptor cd_S10103C104 = {  "S10103C104", // class name
  0,0,//no base classes
  &(vtc_S10103C104[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI10S10103C104),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S10103C104),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C109_nt  {
};
//SIG(-1 S10103C109_nt) C1{}



//skip512 S10103C109_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI13S10103C109_nt[];
VTBL_ENTRY *P__ZTI13S10103C109_nt = _ZTI13S10103C109_nt; 
Class_Descriptor cd_S10103C109_nt = {  "S10103C109_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI13S10103C109_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C108  : S10103C109_nt {
  void *s10103c108f0[2];
  ::S10103C14_nt s10103c108f1;
  ::S10103C14_nt s10103c108f2;
  ::S10103C14_nt s10103c108f3;
  ::S10103C14_nt s10103c108f4;
  ::S10103C14_nt s10103c108f5;
  __tsi64 s10103c108f6;
  int s10103c108f7;
  ::S10103C30_nt s10103c108f8;
  ::S10103C30_nt s10103c108f9;
  int s10103c108f10[2];
  ::S10103C54_nt s10103c108f11;
  int s10103c108f12;
  char s10103c108f13;
  int s10103c108f14;
  unsigned char s10103c108f15:1;
  unsigned char s10103c108f16:1;
  unsigned char s10103c108f17:1;
  unsigned char s10103c108f18:1;
  unsigned char s10103c108f19:1;
  unsigned char s10103c108f20:1;
  unsigned char s10103c108f21:1;
  unsigned char s10103c108f22:1;
  unsigned char s10103c108f23:1;
  unsigned char s10103c108f24:1;
  unsigned char s10103c108f25:1;
  unsigned char s10103c108f26:1;
  unsigned char s10103c108f27:1;
  unsigned char s10103c108f28:1;
  unsigned char s10103c108f29:1;
  virtual  ~S10103C108(); // _ZN10S10103C108D1Ev
  S10103C108(); // tgen
};
//SIG(-1 S10103C108) C1{ BC2{} vd Fp[2] FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC3 FC3 FL Fi FC5{ m FC6{ m FL}} FC5 Fi[2] FC7{ m Fp} Fi Fc Fi Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1}


 S10103C108 ::~S10103C108(){ note_dtor("S10103C108", this);}
S10103C108 ::S10103C108(){ note_ctor("S10103C108", this);} // tgen

static void Test_S10103C108()
{
  extern Class_Descriptor cd_S10103C108;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,33)];
    init_test(&cd_S10103C108, buf);
    S10103C108 *dp, &lv = *(dp=new (buf) S10103C108());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,128), "sizeof(S10103C108)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C108)");
    check_base_class_offset(lv, (S10103C109_nt*), 0, "S10103C108");
    check_field_offset(lv, s10103c108f0, ABISELECT(8,4), "S10103C108.s10103c108f0");
    check_field_offset(lv, s10103c108f1, ABISELECT(24,12), "S10103C108.s10103c108f1");
    check_field_offset(lv, s10103c108f2, ABISELECT(40,24), "S10103C108.s10103c108f2");
    check_field_offset(lv, s10103c108f3, ABISELECT(56,36), "S10103C108.s10103c108f3");
    check_field_offset(lv, s10103c108f4, ABISELECT(72,48), "S10103C108.s10103c108f4");
    check_field_offset(lv, s10103c108f5, ABISELECT(88,60), "S10103C108.s10103c108f5");
    check_field_offset(lv, s10103c108f6, ABISELECT(104,72), "S10103C108.s10103c108f6");
    check_field_offset(lv, s10103c108f7, ABISELECT(112,80), "S10103C108.s10103c108f7");
    check_field_offset(lv, s10103c108f8, ABISELECT(120,84), "S10103C108.s10103c108f8");
    check_field_offset(lv, s10103c108f9, ABISELECT(128,92), "S10103C108.s10103c108f9");
    check_field_offset(lv, s10103c108f10, ABISELECT(136,100), "S10103C108.s10103c108f10");
    check_field_offset(lv, s10103c108f11, ABISELECT(144,108), "S10103C108.s10103c108f11");
    check_field_offset(lv, s10103c108f12, ABISELECT(152,112), "S10103C108.s10103c108f12");
    check_field_offset(lv, s10103c108f13, ABISELECT(156,116), "S10103C108.s10103c108f13");
    check_field_offset(lv, s10103c108f14, ABISELECT(160,120), "S10103C108.s10103c108f14");
    set_bf_and_test(lv, s10103c108f15, ABISELECT(164,124), 0, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f16, ABISELECT(164,124), 1, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f17, ABISELECT(164,124), 2, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f18, ABISELECT(164,124), 3, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f19, ABISELECT(164,124), 4, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f20, ABISELECT(164,124), 5, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f21, ABISELECT(164,124), 6, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f22, ABISELECT(164,124), 7, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f23, ABISELECT(165,125), 0, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f24, ABISELECT(165,125), 1, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f25, ABISELECT(165,125), 2, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f26, ABISELECT(165,125), 3, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f27, ABISELECT(165,125), 4, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f28, ABISELECT(165,125), 5, 1, 1, "S10103C108");
    set_bf_and_test(lv, s10103c108f29, ABISELECT(165,125), 6, 1, 1, "S10103C108");
    test_class_info(&lv, &cd_S10103C108);
    dp->~S10103C108();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C108(Test_S10103C108, "S10103C108", ABISELECT(168,128));

#else // __cplusplus

extern void _ZN10S10103C108C1Ev();
extern void _ZN10S10103C108D1Ev();
Name_Map name_map_S10103C108[] = {
  NSPAIR(_ZN10S10103C108C1Ev),
  NSPAIR(_ZN10S10103C108D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C109_nt;
extern VTBL_ENTRY _ZTI13S10103C109_nt[];
static Base_Class bases_S10103C108[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C109_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10103C108[];
extern void _ZN10S10103C108D1Ev();
extern void _ZN10S10103C108D0Ev();
static  VTBL_ENTRY vtc_S10103C108[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10103C108[0]),
  (VTBL_ENTRY)&_ZN10S10103C108D1Ev,
  (VTBL_ENTRY)&_ZN10S10103C108D0Ev,
};
extern VTBL_ENTRY _ZTI10S10103C108[];
extern  VTBL_ENTRY _ZTV10S10103C108[];
Class_Descriptor cd_S10103C108 = {  "S10103C108", // class name
  bases_S10103C108, 1,
  &(vtc_S10103C108[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,128), // object size
  NSPAIRA(_ZTI10S10103C108),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10103C108),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C110  : S10103C109_nt {
  ::S10103C14_nt s10103c110f0;
  ::S10103C14_nt s10103c110f1;
};
//SIG(-1 S10103C110) C1{ BC2{} FC3{ m Fp Fi FC4{ m}} FC3}



static void Test_S10103C110()
{
  extern Class_Descriptor cd_S10103C110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S10103C110, buf);
    S10103C110 &lv = *(new (buf) S10103C110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S10103C110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C110)");
    check_base_class_offset(lv, (S10103C109_nt*), 0, "S10103C110");
    check_field_offset(lv, s10103c110f0, 0, "S10103C110.s10103c110f0");
    check_field_offset(lv, s10103c110f1, ABISELECT(16,12), "S10103C110.s10103c110f1");
    test_class_info(&lv, &cd_S10103C110);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C110(Test_S10103C110, "S10103C110", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd_S10103C109_nt;
extern VTBL_ENTRY _ZTI13S10103C109_nt[];
static Base_Class bases_S10103C110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C109_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10103C110 = {  "S10103C110", // class name
  bases_S10103C110, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C111_nt  {
  void *s10103c111f0[2];
  void  mf10103c111(); // _ZN13S10103C111_nt11mf10103c111Ev
};
//SIG(-1 S10103C111_nt) C1{ m Fp[2]}


void  S10103C111_nt ::mf10103c111(){}

//skip512 S10103C111_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10103C1  : S10103C2_nt , S10103C3_nt {
  ::S10103C4 s10103c1f0;
  void *s10103c1f1[2];
  ::S10103C24 s10103c1f2;
  ::S10103C26 s10103c1f3;
  ::S10103C27 s10103c1f4;
  ::S10103C32 s10103c1f5;
  ::S10103C33 s10103c1f6;
  ::S10103C34 s10103c1f7;
  ::S10103C38 s10103c1f8;
  ::S10103C39 s10103c1f9;
  ::S10103C40 s10103c1f10;
  ::S10103C45 s10103c1f11;
  ::S10103C45 s10103c1f12;
  ::S10103C40 s10103c1f13;
  ::S10103C47 s10103c1f14;
  ::S10103C47 s10103c1f15;
  ::S10103C47 s10103c1f16;
  ::S10103C47 s10103c1f17;
  ::S10103C47 s10103c1f18;
  ::S10103C49 s10103c1f19;
  ::S10103C50 s10103c1f20;
  ::S10103C51 s10103c1f21;
  ::S10103C52 s10103c1f22;
  ::S10103C53 s10103c1f23;
  ::S10103C55 s10103c1f24;
  ::S10103C61 s10103c1f25;
  ::S10103C104 s10103c1f26;
  ::S10103C58_nt s10103c1f27;
  int s10103c1f28;
  char s10103c1f29[2];
  void *s10103c1f30;
  ::S10103C108 s10103c1f31;
  ::S10103C110 s10103c1f32;
  void *s10103c1f33[3];
  char s10103c1f34;
  ::S10103C111_nt s10103c1f35;
  void *s10103c1f36;
  virtual  ~S10103C1(); // _ZN8S10103C1D1Ev
  virtual void  v1(); // _ZN8S10103C12v1Ev
  virtual void  v2(); // _ZN8S10103C12v2Ev
  virtual void  v3(); // _ZN8S10103C12v3Ev
  virtual void  v4(); // _ZN8S10103C12v4Ev
  virtual void  v5(); // _ZN8S10103C12v5Ev
  S10103C1(); // tgen
};
//SIG(1 S10103C1) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} vd v1 v2 v3 v4 v5 FC4{ BC5{ vd m FC6{ m Fp Fi FC7{ m} FC7} FC6 Fc} BC8{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp FC9{ m FC10{ m Fp Fi FC11{ m}} Fi} FC12{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC13{ m Fc Fi[2] Fp}} vd v12 v13 Fi Fp[8] Fi[2] FC14{ Fi[11]} Fi[4] Fc FC15{ vd m Fi FC16{ m Fp Fi[2] FC11} FC17{ m FC18{ FL[4]}}} Fp} Fp[2] FC19{ BC5 BC8 vd v38 v39 FC20{ Fi[4]}[2] FC20[2] FC20[2] FC20[2]} FC21{ BC5 BC8 vd v40 v41 v42 v43 Fp[2] Fc FC20[2] FC20[2] FC20[2] FC20[2]} FC22{ BC23{ BC5 BC8 vd v47 v48 v49 v50 v51 v52 v53 v54 v55} vd v44 v45 v46 Fi[2] FC24{ m Fi Fp Fi Fp[2] Fi} FC10 FC10 FC10 FC10 FC25{ m FC26{ m FL}} FL Fi Fp Fi Fc} FC27{ BC23 vd v56 v57 v58 FC24 FC10 FC10 Fp Fi} FC28{ BC5 BC8 vd v59 v60 v61 Fp} FC29{ BC5 BC8 vd v62 v63 Fp FC30{ m Fp Fi FC31{ m} FC31} FC10 FC10 Fi[2] Fc Fi[2]} FC32{ BC5 vd Fc Fp[2]} FC33{ BC5 BC8 vd v64 v65 v66 v67 v68 Fc} FC34{ BC35{ BC5 vd v71 v72 v73 v74 FC36{ m Fp FC9 FC10 FC10 Fi} Fp Fc Fi} v69 v70} FC37{ BC35 v75 v76 FC10} FC37 FC34 FC38{ BC35 v77} FC38 FC38 FC38 FC38 FC39{ BC35 v78 v79} FC40{ BC5 vd} FC41{ BC5 vd Fp[4]} FC42{ BC5 vd v80 v81 Fp[2] Fi[2]} FC43{ vd m Fp FC44{ m Fp} Fp Fi Fp} FC45{ BC2 BC3 vd v82 v83 v84 v85 v86 FC46{ BC35 v87} FC46 FC46 FC38 FC47{ BC35 v88 v89 v90 Fp} FC34 Fp[2] FC48{ m FC16 Fp[2]}} FC49{ BC2 BC3 vd v91 v92 v93 v94 v95 Fp FC50{ BC5 BC8 vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 FC44 FC51{ m Fp} FC51 Fi[2] FC52{ BC53{ vd v109 v110} FC10 Fi FL[2] Fi} Fp FC54{ m Fp[2] FC55{ vd v111 v112 FC56{ m Fp Fi[2] FC57{ m}} FC58{ m Fi[4]}[3] Fp[2] Fi Fc} Fp[2]} Fc FC59{ BC60{ BC61{ BC62{ vd v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 Fp[2] FC9 Fp} vd v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 FC30 FC56 FC63{ m FC64{ m FL[2]}} FC9} v141 v142 v143 v144 FC65{ BC66{ BC62 vd v149 v150 v151 v152 v153 v154 Fp Fi FC67{ m Fp Fi FC57 FC68{ m}} FC63 Fi} vd v145 v146 v147 v148 FC9[4] FC63 FC63 FC63 FC63 Fi[6]} FC63 FC63} v113 v114 v115 v116 FC25 FC63} FC69{ BC62 vd v155 v156 v157 v158 v159 v160 Fp[2] FC63 FC63 FC63 Fi[13] Fp[3] Fi[3]} FC20[2] FC20[2] FC63 FC70{ vd m Fp[2] FC67 FC71{ vd m FL[2] Fi FC10 FC10 FC10 FC10 FC44}} FC9 Fp[2] FC9 Fp[3] Fc} FC38 FC34 FC72{ BC73{ BC5 BC8 vd v164 v165 v166 FC71 FL Fi} vd v161 v162 v163} FC72 FC74{ BC5 BC8 vd v167 v168 v169 v170 v171 v172 v173 v174 FC54 FC44 Fp} FC75{ BC23 BC2 vd v175 v176 v177 v178 v179 v180 Fi Fp Fi FC24} FC76{ BC8 vd v181 v182 v183 v184} FC71 FC46 FC46 Fp} FC77{ vd m Fc FC78{ m Fp} FC79{ m Fp Fi[2] FC68}} FC48 Fi Fc[2] Fp FC80{ BC81{} vd Fp[2] FC10 FC10 FC10 FC10 FC10 FL Fi FC25 FC25 Fi[2] FC44 Fi Fc Fi Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1} FC82{ BC81 FC10 FC10} Fp[3] Fc FC83{ m Fp[2]} Fp}


 S10103C1 ::~S10103C1(){ note_dtor("S10103C1", this);}
void  S10103C1 ::v1(){vfunc_called(this, "_ZN8S10103C12v1Ev");}
void  S10103C1 ::v2(){vfunc_called(this, "_ZN8S10103C12v2Ev");}
void  S10103C1 ::v3(){vfunc_called(this, "_ZN8S10103C12v3Ev");}
void  S10103C1 ::v4(){vfunc_called(this, "_ZN8S10103C12v4Ev");}
void  S10103C1 ::v5(){vfunc_called(this, "_ZN8S10103C12v5Ev");}
S10103C1 ::S10103C1(){ note_ctor("S10103C1", this);} // tgen

static void Test_S10103C1()
{
  extern Class_Descriptor cd_S10103C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1075,1485)];
    init_test(&cd_S10103C1, buf);
    S10103C1 *dp, &lv = *(dp=new (buf) S10103C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8592,5936), "sizeof(S10103C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10103C1)");
    check_base_class_offset(lv, (S10103C2_nt*), 0, "S10103C1");
    check_base_class_offset(lv, (S10103C3_nt*), ABISELECT(8,4), "S10103C1");
    check_field_offset(lv, s10103c1f0, ABISELECT(24,12), "S10103C1.s10103c1f0");
    check_field_offset(lv, s10103c1f1, ABISELECT(416,292), "S10103C1.s10103c1f1");
    check_field_offset(lv, s10103c1f2, ABISELECT(432,300), "S10103C1.s10103c1f2");
    check_field_offset(lv, s10103c1f3, ABISELECT(728,540), "S10103C1.s10103c1f3");
    check_field_offset(lv, s10103c1f4, ABISELECT(1048,792), "S10103C1.s10103c1f4");
    check_field_offset(lv, s10103c1f5, ABISELECT(1376,1016), "S10103C1.s10103c1f5");
    check_field_offset(lv, s10103c1f6, ABISELECT(1640,1184), "S10103C1.s10103c1f6");
    check_field_offset(lv, s10103c1f7, ABISELECT(1816,1300), "S10103C1.s10103c1f7");
    check_field_offset(lv, s10103c1f8, ABISELECT(2064,1472), "S10103C1.s10103c1f8");
    check_field_offset(lv, s10103c1f9, ABISELECT(2128,1512), "S10103C1.s10103c1f9");
    check_field_offset(lv, s10103c1f10, ABISELECT(2304,1628), "S10103C1.s10103c1f10");
    check_field_offset(lv, s10103c1f11, ABISELECT(2440,1720), "S10103C1.s10103c1f11");
    check_field_offset(lv, s10103c1f12, ABISELECT(2592,1824), "S10103C1.s10103c1f12");
    check_field_offset(lv, s10103c1f13, ABISELECT(2744,1928), "S10103C1.s10103c1f13");
    check_field_offset(lv, s10103c1f14, ABISELECT(2880,2020), "S10103C1.s10103c1f14");
    check_field_offset(lv, s10103c1f15, ABISELECT(3016,2112), "S10103C1.s10103c1f15");
    check_field_offset(lv, s10103c1f16, ABISELECT(3152,2204), "S10103C1.s10103c1f16");
    check_field_offset(lv, s10103c1f17, ABISELECT(3288,2296), "S10103C1.s10103c1f17");
    check_field_offset(lv, s10103c1f18, ABISELECT(3424,2388), "S10103C1.s10103c1f18");
    check_field_offset(lv, s10103c1f19, ABISELECT(3560,2480), "S10103C1.s10103c1f19");
    check_field_offset(lv, s10103c1f20, ABISELECT(3696,2572), "S10103C1.s10103c1f20");
    check_field_offset(lv, s10103c1f21, ABISELECT(3744,2604), "S10103C1.s10103c1f21");
    check_field_offset(lv, s10103c1f22, ABISELECT(3824,2652), "S10103C1.s10103c1f22");
    check_field_offset(lv, s10103c1f23, ABISELECT(3896,2700), "S10103C1.s10103c1f23");
    check_field_offset(lv, s10103c1f24, ABISELECT(3944,2724), "S10103C1.s10103c1f24");
    check_field_offset(lv, s10103c1f25, ABISELECT(4848,3324), "S10103C1.s10103c1f25");
    check_field_offset(lv, s10103c1f26, ABISELECT(8232,5692), "S10103C1.s10103c1f26");
    check_field_offset(lv, s10103c1f27, ABISELECT(8280,5720), "S10103C1.s10103c1f27");
    check_field_offset(lv, s10103c1f28, ABISELECT(8320,5744), "S10103C1.s10103c1f28");
    check_field_offset(lv, s10103c1f29, ABISELECT(8324,5748), "S10103C1.s10103c1f29");
    check_field_offset(lv, s10103c1f30, ABISELECT(8328,5752), "S10103C1.s10103c1f30");
    check_field_offset(lv, s10103c1f31, ABISELECT(8336,5756), "S10103C1.s10103c1f31");
    check_field_offset(lv, s10103c1f32, ABISELECT(8504,5884), "S10103C1.s10103c1f32");
    check_field_offset(lv, s10103c1f33, ABISELECT(8536,5908), "S10103C1.s10103c1f33");
    check_field_offset(lv, s10103c1f34, ABISELECT(8560,5920), "S10103C1.s10103c1f34");
    check_field_offset(lv, s10103c1f35, ABISELECT(8568,5924), "S10103C1.s10103c1f35");
    check_field_offset(lv, s10103c1f36, ABISELECT(8584,5932), "S10103C1.s10103c1f36");
    test_class_info(&lv, &cd_S10103C1);
    dp->~S10103C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10103C1(Test_S10103C1, "S10103C1", ABISELECT(8592,5936));

#else // __cplusplus

extern void _ZN8S10103C1C1Ev();
extern void _ZN8S10103C1D1Ev();
Name_Map name_map_S10103C1[] = {
  NSPAIR(_ZN8S10103C1C1Ev),
  NSPAIR(_ZN8S10103C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C2_nt;
extern VTBL_ENTRY _ZTI11S10103C2_nt[];
extern  VTBL_ENTRY _ZTV11S10103C2_nt[];
extern Class_Descriptor cd_S10103C3_nt;
extern VTBL_ENTRY _ZTI11S10103C3_nt[];
extern  VTBL_ENTRY _ZTV11S10103C3_nt[];
static Base_Class bases_S10103C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10103C3_nt,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10103C1[];
extern void _ZN8S10103C1D1Ev();
extern void _ZN8S10103C1D0Ev();
extern void _ZN11S10103C2_nt2v6Ev();
extern void _ZN8S10103C12v1Ev();
extern void _ZN8S10103C12v2Ev();
extern void _ZN8S10103C12v3Ev();
extern void _ZN8S10103C12v4Ev();
extern void _ZN8S10103C12v5Ev();
extern void ABISELECT(_ZThn8_N8S10103C1D1Ev,_ZThn4_N8S10103C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10103C1D0Ev,_ZThn4_N8S10103C1D0Ev)();
extern void _ZN11S10103C3_nt2v7Ev();
extern void _ZN11S10103C3_nt2v8Ev();
extern void _ZN11S10103C3_nt2v9Ev();
extern void _ZN11S10103C3_nt3v10Ev();
extern void _ZN11S10103C3_nt3v11Ev();
static  VTBL_ENTRY vtc_S10103C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10103C1[0]),
  (VTBL_ENTRY)&_ZN8S10103C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10103C1D0Ev,
  (VTBL_ENTRY)&_ZN11S10103C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S10103C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10103C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10103C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10103C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10103C12v5Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10103C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10103C1D1Ev,_ZThn4_N8S10103C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10103C1D0Ev,_ZThn4_N8S10103C1D0Ev),
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10103C3_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI8S10103C1[];
extern  VTBL_ENTRY _ZTV8S10103C1[];
Class_Descriptor cd_S10103C1 = {  "S10103C1", // class name
  bases_S10103C1, 2,
  &(vtc_S10103C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8592,5936), // object size
  NSPAIRA(_ZTI8S10103C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10103C1),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C2  {
  virtual  ~S10102C2(); // _ZN8S10102C2D1Ev
  virtual void  v6(); // _ZN8S10102C22v6Ev
  S10102C2(); // tgen
};
//SIG(-1 S10102C2) C1{ vd v1}


 S10102C2 ::~S10102C2(){ note_dtor("S10102C2", this);}
void  S10102C2 ::v6(){vfunc_called(this, "_ZN8S10102C22v6Ev");}
S10102C2 ::S10102C2(){ note_ctor("S10102C2", this);} // tgen

static void Test_S10102C2()
{
  extern Class_Descriptor cd_S10102C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10102C2, buf);
    S10102C2 *dp, &lv = *(dp=new (buf) S10102C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10102C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C2)");
    test_class_info(&lv, &cd_S10102C2);
    dp->~S10102C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C2(Test_S10102C2, "S10102C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10102C2C1Ev();
extern void _ZN8S10102C2D1Ev();
Name_Map name_map_S10102C2[] = {
  NSPAIR(_ZN8S10102C2C1Ev),
  NSPAIR(_ZN8S10102C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10102C2[];
extern void _ZN8S10102C2D1Ev();
extern void _ZN8S10102C2D0Ev();
extern void _ZN8S10102C22v6Ev();
static  VTBL_ENTRY vtc_S10102C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10102C2[0]),
  (VTBL_ENTRY)&_ZN8S10102C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10102C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10102C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S10102C2[];
extern  VTBL_ENTRY _ZTV8S10102C2[];
Class_Descriptor cd_S10102C2 = {  "S10102C2", // class name
  0,0,//no base classes
  &(vtc_S10102C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10102C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10102C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C3  {
  void *s10102c3f0;
  virtual  ~S10102C3(); // _ZN8S10102C3D1Ev
  virtual void  v7(); // _ZN8S10102C32v7Ev
  virtual void  v8(); // _ZN8S10102C32v8Ev
  virtual void  v9(); // _ZN8S10102C32v9Ev
  virtual void  v10(); // _ZN8S10102C33v10Ev
  virtual void  v11(); // _ZN8S10102C33v11Ev
  S10102C3(); // tgen
};
//SIG(-1 S10102C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10102C3 ::~S10102C3(){ note_dtor("S10102C3", this);}
void  S10102C3 ::v7(){vfunc_called(this, "_ZN8S10102C32v7Ev");}
void  S10102C3 ::v8(){vfunc_called(this, "_ZN8S10102C32v8Ev");}
void  S10102C3 ::v9(){vfunc_called(this, "_ZN8S10102C32v9Ev");}
void  S10102C3 ::v10(){vfunc_called(this, "_ZN8S10102C33v10Ev");}
void  S10102C3 ::v11(){vfunc_called(this, "_ZN8S10102C33v11Ev");}
S10102C3 ::S10102C3(){ note_ctor("S10102C3", this);} // tgen

static void Test_S10102C3()
{
  extern Class_Descriptor cd_S10102C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10102C3, buf);
    S10102C3 *dp, &lv = *(dp=new (buf) S10102C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10102C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C3)");
    check_field_offset(lv, s10102c3f0, ABISELECT(8,4), "S10102C3.s10102c3f0");
    test_class_info(&lv, &cd_S10102C3);
    dp->~S10102C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C3(Test_S10102C3, "S10102C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10102C3C1Ev();
extern void _ZN8S10102C3D1Ev();
Name_Map name_map_S10102C3[] = {
  NSPAIR(_ZN8S10102C3C1Ev),
  NSPAIR(_ZN8S10102C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10102C3[];
extern void _ZN8S10102C3D1Ev();
extern void _ZN8S10102C3D0Ev();
extern void _ZN8S10102C32v7Ev();
extern void _ZN8S10102C32v8Ev();
extern void _ZN8S10102C32v9Ev();
extern void _ZN8S10102C33v10Ev();
extern void _ZN8S10102C33v11Ev();
static  VTBL_ENTRY vtc_S10102C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10102C3[0]),
  (VTBL_ENTRY)&_ZN8S10102C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10102C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10102C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10102C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10102C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10102C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10102C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10102C3[];
extern  VTBL_ENTRY _ZTV8S10102C3[];
Class_Descriptor cd_S10102C3 = {  "S10102C3", // class name
  0,0,//no base classes
  &(vtc_S10102C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10102C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10102C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C12  {
  void *s10102c12f0;
  ::S10103C13_nt s10102c12f1;
  ::S10103C16_nt s10102c12f2;
  ::S10103C17 s10102c12f3;
  virtual  ~S10102C12(); // _ZN9S10102C12D1Ev
  virtual void  v14(); // _ZN9S10102C123v14Ev
  virtual void  v15(); // _ZN9S10102C123v15Ev
  virtual void  v16(); // _ZN9S10102C123v16Ev
  virtual void  v17(); // _ZN9S10102C123v17Ev
  virtual void  v18(); // _ZN9S10102C123v18Ev
  virtual void  v19(); // _ZN9S10102C123v19Ev
  virtual void  v20(); // _ZN9S10102C123v20Ev
  virtual void  v21(); // _ZN9S10102C123v21Ev
  virtual void  v22(); // _ZN9S10102C123v22Ev
  virtual void  v23(); // _ZN9S10102C123v23Ev
  virtual void  v24(); // _ZN9S10102C123v24Ev
  virtual void  v25(); // _ZN9S10102C123v25Ev
  virtual void  v26(); // _ZN9S10102C123v26Ev
  virtual void  v27(); // _ZN9S10102C123v27Ev
  virtual void  v28(); // _ZN9S10102C123v28Ev
  virtual void  v29(); // _ZN9S10102C123v29Ev
  virtual void  v30(); // _ZN9S10102C123v30Ev
  virtual void  v31(); // _ZN9S10102C123v31Ev
  virtual void  v32(); // _ZN9S10102C123v32Ev
  virtual void  v33(); // _ZN9S10102C123v33Ev
  virtual void  v34(); // _ZN9S10102C123v34Ev
  virtual void  v35(); // _ZN9S10102C123v35Ev
  virtual void  v36(); // _ZN9S10102C123v36Ev
  virtual void  v37(); // _ZN9S10102C123v37Ev
  S10102C12(); // tgen
};
//SIG(-1 S10102C12) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC6{ m Fc Fi[2] Fp}}


 S10102C12 ::~S10102C12(){ note_dtor("S10102C12", this);}
void  S10102C12 ::v14(){vfunc_called(this, "_ZN9S10102C123v14Ev");}
void  S10102C12 ::v15(){vfunc_called(this, "_ZN9S10102C123v15Ev");}
void  S10102C12 ::v16(){vfunc_called(this, "_ZN9S10102C123v16Ev");}
void  S10102C12 ::v17(){vfunc_called(this, "_ZN9S10102C123v17Ev");}
void  S10102C12 ::v18(){vfunc_called(this, "_ZN9S10102C123v18Ev");}
void  S10102C12 ::v19(){vfunc_called(this, "_ZN9S10102C123v19Ev");}
void  S10102C12 ::v20(){vfunc_called(this, "_ZN9S10102C123v20Ev");}
void  S10102C12 ::v21(){vfunc_called(this, "_ZN9S10102C123v21Ev");}
void  S10102C12 ::v22(){vfunc_called(this, "_ZN9S10102C123v22Ev");}
void  S10102C12 ::v23(){vfunc_called(this, "_ZN9S10102C123v23Ev");}
void  S10102C12 ::v24(){vfunc_called(this, "_ZN9S10102C123v24Ev");}
void  S10102C12 ::v25(){vfunc_called(this, "_ZN9S10102C123v25Ev");}
void  S10102C12 ::v26(){vfunc_called(this, "_ZN9S10102C123v26Ev");}
void  S10102C12 ::v27(){vfunc_called(this, "_ZN9S10102C123v27Ev");}
void  S10102C12 ::v28(){vfunc_called(this, "_ZN9S10102C123v28Ev");}
void  S10102C12 ::v29(){vfunc_called(this, "_ZN9S10102C123v29Ev");}
void  S10102C12 ::v30(){vfunc_called(this, "_ZN9S10102C123v30Ev");}
void  S10102C12 ::v31(){vfunc_called(this, "_ZN9S10102C123v31Ev");}
void  S10102C12 ::v32(){vfunc_called(this, "_ZN9S10102C123v32Ev");}
void  S10102C12 ::v33(){vfunc_called(this, "_ZN9S10102C123v33Ev");}
void  S10102C12 ::v34(){vfunc_called(this, "_ZN9S10102C123v34Ev");}
void  S10102C12 ::v35(){vfunc_called(this, "_ZN9S10102C123v35Ev");}
void  S10102C12 ::v36(){vfunc_called(this, "_ZN9S10102C123v36Ev");}
void  S10102C12 ::v37(){vfunc_called(this, "_ZN9S10102C123v37Ev");}
S10102C12 ::S10102C12(){ note_ctor("S10102C12", this);} // tgen

static void Test_S10102C12()
{
  extern Class_Descriptor cd_S10102C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S10102C12, buf);
    S10102C12 *dp, &lv = *(dp=new (buf) S10102C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S10102C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C12)");
    check_field_offset(lv, s10102c12f0, ABISELECT(8,4), "S10102C12.s10102c12f0");
    check_field_offset(lv, s10102c12f1, ABISELECT(16,8), "S10102C12.s10102c12f1");
    check_field_offset(lv, s10102c12f2, ABISELECT(40,24), "S10102C12.s10102c12f2");
    check_field_offset(lv, s10102c12f3, ABISELECT(96,64), "S10102C12.s10102c12f3");
    test_class_info(&lv, &cd_S10102C12);
    dp->~S10102C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C12(Test_S10102C12, "S10102C12", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN9S10102C12C1Ev();
extern void _ZN9S10102C12D1Ev();
Name_Map name_map_S10102C12[] = {
  NSPAIR(_ZN9S10102C12C1Ev),
  NSPAIR(_ZN9S10102C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10102C12[];
extern void _ZN9S10102C12D1Ev();
extern void _ZN9S10102C12D0Ev();
extern void _ZN9S10102C123v14Ev();
extern void _ZN9S10102C123v15Ev();
extern void _ZN9S10102C123v16Ev();
extern void _ZN9S10102C123v17Ev();
extern void _ZN9S10102C123v18Ev();
extern void _ZN9S10102C123v19Ev();
extern void _ZN9S10102C123v20Ev();
extern void _ZN9S10102C123v21Ev();
extern void _ZN9S10102C123v22Ev();
extern void _ZN9S10102C123v23Ev();
extern void _ZN9S10102C123v24Ev();
extern void _ZN9S10102C123v25Ev();
extern void _ZN9S10102C123v26Ev();
extern void _ZN9S10102C123v27Ev();
extern void _ZN9S10102C123v28Ev();
extern void _ZN9S10102C123v29Ev();
extern void _ZN9S10102C123v30Ev();
extern void _ZN9S10102C123v31Ev();
extern void _ZN9S10102C123v32Ev();
extern void _ZN9S10102C123v33Ev();
extern void _ZN9S10102C123v34Ev();
extern void _ZN9S10102C123v35Ev();
extern void _ZN9S10102C123v36Ev();
extern void _ZN9S10102C123v37Ev();
static  VTBL_ENTRY vtc_S10102C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10102C12[0]),
  (VTBL_ENTRY)&_ZN9S10102C12D1Ev,
  (VTBL_ENTRY)&_ZN9S10102C12D0Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10102C12[];
extern  VTBL_ENTRY _ZTV9S10102C12[];
Class_Descriptor cd_S10102C12 = {  "S10102C12", // class name
  0,0,//no base classes
  &(vtc_S10102C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI9S10102C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10102C12),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C23_nt  {
  long s10102c23f0[4];
};
//SIG(-1 S10102C23_nt) C1{ Fl[4]}



//skip512 S10102C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C22_nt  {
  ::S10102C23_nt s10102c22f0;
  void  mf10102c22(); // _ZN12S10102C22_nt10mf10102c22Ev
};
//SIG(-1 S10102C22_nt) C1{ m FC2{ Fl[4]}}


void  S10102C22_nt ::mf10102c22(){}

//skip512 S10102C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C19  {
  int s10102c19f0;
  ::S10103C106 s10102c19f1;
  ::S10102C22_nt s10102c19f2;
  void  mf10102c19(); // _ZN9S10102C1910mf10102c19Ev
  virtual  ~S10102C19(); // _ZN9S10102C19D1Ev
  S10102C19(); // tgen
};
//SIG(-1 S10102C19) C1{ vd m Fi FC2{ m Fp Fi[2] FC3{ m}} FC4{ m FC5{ Fl[4]}}}


void  S10102C19 ::mf10102c19(){}
 S10102C19 ::~S10102C19(){ note_dtor("S10102C19", this);}
S10102C19 ::S10102C19(){ note_ctor("S10102C19", this);} // tgen

static void Test_S10102C19()
{
  extern Class_Descriptor cd_S10102C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S10102C19, buf);
    S10102C19 *dp, &lv = *(dp=new (buf) S10102C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S10102C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C19)");
    check_field_offset(lv, s10102c19f0, ABISELECT(8,4), "S10102C19.s10102c19f0");
    check_field_offset(lv, s10102c19f1, ABISELECT(16,8), "S10102C19.s10102c19f1");
    check_field_offset(lv, s10102c19f2, ABISELECT(40,24), "S10102C19.s10102c19f2");
    test_class_info(&lv, &cd_S10102C19);
    dp->~S10102C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C19(Test_S10102C19, "S10102C19", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN9S10102C19C1Ev();
extern void _ZN9S10102C19D1Ev();
Name_Map name_map_S10102C19[] = {
  NSPAIR(_ZN9S10102C19C1Ev),
  NSPAIR(_ZN9S10102C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10102C19[];
extern void _ZN9S10102C19D1Ev();
extern void _ZN9S10102C19D0Ev();
static  VTBL_ENTRY vtc_S10102C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10102C19[0]),
  (VTBL_ENTRY)&_ZN9S10102C19D1Ev,
  (VTBL_ENTRY)&_ZN9S10102C19D0Ev,
};
extern VTBL_ENTRY _ZTI9S10102C19[];
extern  VTBL_ENTRY _ZTV9S10102C19[];
Class_Descriptor cd_S10102C19 = {  "S10102C19", // class name
  0,0,//no base classes
  &(vtc_S10102C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI9S10102C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10102C19),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C4  : S10103C5_nt , S10102C12 {
  int s10102c4f0;
  void *s10102c4f1[8];
  int s10102c4f2[2];
  ::S10103C18 s10102c4f3;
  int s10102c4f4[4];
  char s10102c4f5;
  ::S10102C19 s10102c4f6;
  void *s10102c4f7;
  virtual  ~S10102C4(); // _ZN8S10102C4D1Ev
  virtual void  v12(); // _ZN8S10102C43v12Ev
  virtual void  v13(); // _ZN8S10102C43v13Ev
  S10102C4(); // tgen
};
//SIG(-1 S10102C4) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 Fi Fp[8] Fi[2] FC11{ Fi[11]} Fi[4] Fc FC12{ vd m Fi FC13{ m Fp Fi[2] FC14{ m}} FC15{ m FC16{ Fl[4]}}} Fp}


 S10102C4 ::~S10102C4(){ note_dtor("S10102C4", this);}
void  S10102C4 ::v12(){vfunc_called(this, "_ZN8S10102C43v12Ev");}
void  S10102C4 ::v13(){vfunc_called(this, "_ZN8S10102C43v13Ev");}
S10102C4 ::S10102C4(){ note_ctor("S10102C4", this);} // tgen

static void Test_S10102C4()
{
  extern Class_Descriptor cd_S10102C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,67)];
    init_test(&cd_S10102C4, buf);
    S10102C4 *dp, &lv = *(dp=new (buf) S10102C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,264), "sizeof(S10102C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C4)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10102C4");
    check_base_class_offset(lv, (S10102C12*), ABISELECT(48,32), "S10102C4");
    check_field_offset(lv, s10102c4f0, ABISELECT(168,112), "S10102C4.s10102c4f0");
    check_field_offset(lv, s10102c4f1, ABISELECT(176,116), "S10102C4.s10102c4f1");
    check_field_offset(lv, s10102c4f2, ABISELECT(240,148), "S10102C4.s10102c4f2");
    check_field_offset(lv, s10102c4f3, ABISELECT(248,156), "S10102C4.s10102c4f3");
    check_field_offset(lv, s10102c4f4, ABISELECT(292,200), "S10102C4.s10102c4f4");
    check_field_offset(lv, s10102c4f5, ABISELECT(308,216), "S10102C4.s10102c4f5");
    check_field_offset(lv, s10102c4f6, ABISELECT(312,220), "S10102C4.s10102c4f6");
    check_field_offset(lv, s10102c4f7, ABISELECT(384,260), "S10102C4.s10102c4f7");
    test_class_info(&lv, &cd_S10102C4);
    dp->~S10102C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C4(Test_S10102C4, "S10102C4", ABISELECT(392,264));

#else // __cplusplus

extern void _ZN8S10102C4C1Ev();
extern void _ZN8S10102C4D1Ev();
Name_Map name_map_S10102C4[] = {
  NSPAIR(_ZN8S10102C4C1Ev),
  NSPAIR(_ZN8S10102C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10102C12;
extern VTBL_ENTRY _ZTI9S10102C12[];
extern  VTBL_ENTRY _ZTV9S10102C12[];
static Base_Class bases_S10102C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10102C12,    ABISELECT(48,32), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10102C4[];
extern void _ZN8S10102C4D1Ev();
extern void _ZN8S10102C4D0Ev();
extern void _ZN8S10102C43v12Ev();
extern void _ZN8S10102C43v13Ev();
extern void ABISELECT(_ZThn48_N8S10102C4D1Ev,_ZThn32_N8S10102C4D1Ev)();
extern void ABISELECT(_ZThn48_N8S10102C4D0Ev,_ZThn32_N8S10102C4D0Ev)();
extern void _ZN9S10102C123v14Ev();
extern void _ZN9S10102C123v15Ev();
extern void _ZN9S10102C123v16Ev();
extern void _ZN9S10102C123v17Ev();
extern void _ZN9S10102C123v18Ev();
extern void _ZN9S10102C123v19Ev();
extern void _ZN9S10102C123v20Ev();
extern void _ZN9S10102C123v21Ev();
extern void _ZN9S10102C123v22Ev();
extern void _ZN9S10102C123v23Ev();
extern void _ZN9S10102C123v24Ev();
extern void _ZN9S10102C123v25Ev();
extern void _ZN9S10102C123v26Ev();
extern void _ZN9S10102C123v27Ev();
extern void _ZN9S10102C123v28Ev();
extern void _ZN9S10102C123v29Ev();
extern void _ZN9S10102C123v30Ev();
extern void _ZN9S10102C123v31Ev();
extern void _ZN9S10102C123v32Ev();
extern void _ZN9S10102C123v33Ev();
extern void _ZN9S10102C123v34Ev();
extern void _ZN9S10102C123v35Ev();
extern void _ZN9S10102C123v36Ev();
extern void _ZN9S10102C123v37Ev();
static  VTBL_ENTRY vtc_S10102C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10102C4[0]),
  (VTBL_ENTRY)&_ZN8S10102C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10102C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10102C43v12Ev,
  (VTBL_ENTRY)&_ZN8S10102C43v13Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8S10102C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10102C4D1Ev,_ZThn32_N8S10102C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10102C4D0Ev,_ZThn32_N8S10102C4D0Ev),
  (VTBL_ENTRY)&_ZN9S10102C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10102C123v37Ev,
};
extern VTBL_ENTRY _ZTI8S10102C4[];
extern  VTBL_ENTRY _ZTV8S10102C4[];
Class_Descriptor cd_S10102C4 = {  "S10102C4", // class name
  bases_S10102C4, 2,
  &(vtc_S10102C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,264), // object size
  NSPAIRA(_ZTI8S10102C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10102C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C41  : S10103C5_nt {
  ::S10103C42 s10102c41f0;
  void *s10102c41f1;
  char s10102c41f2;
  int s10102c41f3;
  virtual  ~S10102C41(); // _ZN9S10102C41D1Ev
  virtual void  v71(); // _ZN9S10102C413v71Ev
  virtual void  v72(); // _ZN9S10102C413v72Ev
  virtual void  v73(); // _ZN9S10102C413v73Ev
  virtual void  v74(); // _ZN9S10102C413v74Ev
  S10102C41(); // tgen
};
//SIG(-1 S10102C41) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd v1 v2 v3 v4 FC5{ m Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC7 FC7 Fi} Fp Fc Fi}


 S10102C41 ::~S10102C41(){ note_dtor("S10102C41", this);}
void  S10102C41 ::v71(){vfunc_called(this, "_ZN9S10102C413v71Ev");}
void  S10102C41 ::v72(){vfunc_called(this, "_ZN9S10102C413v72Ev");}
void  S10102C41 ::v73(){vfunc_called(this, "_ZN9S10102C413v73Ev");}
void  S10102C41 ::v74(){vfunc_called(this, "_ZN9S10102C413v74Ev");}
S10102C41 ::S10102C41(){ note_ctor("S10102C41", this);} // tgen

static void Test_S10102C41()
{
  extern Class_Descriptor cd_S10102C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10102C41, buf);
    S10102C41 *dp, &lv = *(dp=new (buf) S10102C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10102C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C41)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10102C41");
    check_field_offset(lv, s10102c41f0, ABISELECT(48,32), "S10102C41.s10102c41f0");
    check_field_offset(lv, s10102c41f1, ABISELECT(120,80), "S10102C41.s10102c41f1");
    check_field_offset(lv, s10102c41f2, ABISELECT(128,84), "S10102C41.s10102c41f2");
    check_field_offset(lv, s10102c41f3, ABISELECT(132,88), "S10102C41.s10102c41f3");
    test_class_info(&lv, &cd_S10102C41);
    dp->~S10102C41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C41(Test_S10102C41, "S10102C41", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10102C41C1Ev();
extern void _ZN9S10102C41D1Ev();
Name_Map name_map_S10102C41[] = {
  NSPAIR(_ZN9S10102C41C1Ev),
  NSPAIR(_ZN9S10102C41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10102C41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10102C41[];
extern void _ZN9S10102C41D1Ev();
extern void _ZN9S10102C41D0Ev();
extern void _ZN9S10102C413v71Ev();
extern void _ZN9S10102C413v72Ev();
extern void _ZN9S10102C413v73Ev();
extern void _ZN9S10102C413v74Ev();
static  VTBL_ENTRY vtc_S10102C41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10102C41[0]),
  (VTBL_ENTRY)&_ZN9S10102C41D1Ev,
  (VTBL_ENTRY)&_ZN9S10102C41D0Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v74Ev,
};
extern VTBL_ENTRY _ZTI9S10102C41[];
extern  VTBL_ENTRY _ZTV9S10102C41[];
Class_Descriptor cd_S10102C41 = {  "S10102C41", // class name
  bases_S10102C41, 1,
  &(vtc_S10102C41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10102C41),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10102C41),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C49  : S10102C41 {
  virtual void  v81(); // _ZN9S10102C493v81Ev
  virtual void  v82(); // _ZN9S10102C493v82Ev
  ~S10102C49(); // tgen
  S10102C49(); // tgen
};
//SIG(-1 S10102C49) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v3 v4 v5 v6 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1 v2}


void  S10102C49 ::v81(){vfunc_called(this, "_ZN9S10102C493v81Ev");}
void  S10102C49 ::v82(){vfunc_called(this, "_ZN9S10102C493v82Ev");}
S10102C49 ::~S10102C49(){ note_dtor("S10102C49", this);} // tgen
S10102C49 ::S10102C49(){ note_ctor("S10102C49", this);} // tgen

static void Test_S10102C49()
{
  extern Class_Descriptor cd_S10102C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10102C49, buf);
    S10102C49 *dp, &lv = *(dp=new (buf) S10102C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10102C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C49)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10102C41*), 0, "S10102C49");
    check_base_class_offset(lv, (S10102C41*), 0, "S10102C49");
    test_class_info(&lv, &cd_S10102C49);
    dp->~S10102C49();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C49(Test_S10102C49, "S10102C49", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10102C49C1Ev();
extern void _ZN9S10102C49D1Ev();
Name_Map name_map_S10102C49[] = {
  NSPAIR(_ZN9S10102C49C1Ev),
  NSPAIR(_ZN9S10102C49D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10102C41;
extern VTBL_ENTRY _ZTI9S10102C41[];
extern  VTBL_ENTRY _ZTV9S10102C41[];
static Base_Class bases_S10102C49[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10102C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10102C49[];
extern void _ZN9S10102C49D1Ev();
extern void _ZN9S10102C49D0Ev();
extern void _ZN9S10102C413v71Ev();
extern void _ZN9S10102C413v72Ev();
extern void _ZN9S10102C413v73Ev();
extern void _ZN9S10102C413v74Ev();
extern void _ZN9S10102C493v81Ev();
extern void _ZN9S10102C493v82Ev();
static  VTBL_ENTRY vtc_S10102C49[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10102C49[0]),
  (VTBL_ENTRY)&_ZN9S10102C49D1Ev,
  (VTBL_ENTRY)&_ZN9S10102C49D0Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v71Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v72Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v73Ev,
  (VTBL_ENTRY)&_ZN9S10102C413v74Ev,
  (VTBL_ENTRY)&_ZN9S10102C493v81Ev,
  (VTBL_ENTRY)&_ZN9S10102C493v82Ev,
};
extern VTBL_ENTRY _ZTI9S10102C49[];
extern  VTBL_ENTRY _ZTV9S10102C49[];
Class_Descriptor cd_S10102C49 = {  "S10102C49", // class name
  bases_S10102C49, 2,
  &(vtc_S10102C49[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10102C49),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10102C49),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10102C1  : S10102C2 , S10102C3 {
  ::S10102C4 s10102c1f0;
  void *s10102c1f1[2];
  ::S10103C24 s10102c1f2;
  ::S10103C26 s10102c1f3;
  ::S10103C27 s10102c1f4;
  ::S10103C32 s10102c1f5;
  ::S10103C33 s10102c1f6;
  ::S10103C34 s10102c1f7;
  ::S10103C38 s10102c1f8;
  ::S10103C39 s10102c1f9;
  ::S10103C49 s10102c1f10;
  ::S10103C45 s10102c1f11;
  ::S10103C45 s10102c1f12;
  ::S10103C40 s10102c1f13;
  ::S10103C56 s10102c1f14;
  ::S10103C56 s10102c1f15;
  ::S10103C56 s10102c1f16;
  ::S10103C56 s10102c1f17;
  ::S10103C47 s10102c1f18;
  ::S10102C49 s10102c1f19;
  ::S10103C50 s10102c1f20;
  ::S10103C51 s10102c1f21;
  ::S10103C52 s10102c1f22;
  ::S10103C53 s10102c1f23;
  ::S10103C55 s10102c1f24;
  ::S10103C61 s10102c1f25;
  ::S10103C104 s10102c1f26;
  ::S10103C58_nt s10102c1f27;
  int s10102c1f28;
  char s10102c1f29[2];
  void *s10102c1f30;
  ::S10103C108 s10102c1f31;
  ::S10103C110 s10102c1f32;
  void *s10102c1f33[3];
  char s10102c1f34;
  ::S10103C111_nt s10102c1f35;
  void *s10102c1f36;
  virtual  ~S10102C1(); // _ZN8S10102C1D1Ev
  virtual void  v1(); // _ZN8S10102C12v1Ev
  virtual void  v2(); // _ZN8S10102C12v2Ev
  virtual void  v3(); // _ZN8S10102C12v3Ev
  virtual void  v4(); // _ZN8S10102C12v4Ev
  virtual void  v5(); // _ZN8S10102C12v5Ev
  S10102C1(); // tgen
};
//SIG(1 S10102C1) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} vd v1 v2 v3 v4 v5 FC4{ BC5{ vd m FC6{ m Fp Fi FC7{ m} FC7} FC6 Fc} BC8{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp FC9{ m FC10{ m Fp Fi FC11{ m}} Fi} FC12{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC13{ m Fc Fi[2] Fp}} vd v12 v13 Fi Fp[8] Fi[2] FC14{ Fi[11]} Fi[4] Fc FC15{ vd m Fi FC16{ m Fp Fi[2] FC17{ m}} FC18{ m FC19{ Fl[4]}}} Fp} Fp[2] FC20{ BC5 BC21{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 Fp FC9 FC12 FC13} vd v38 v39 FC22{ Fi[4]}[2] FC22[2] FC22[2] FC22[2]} FC23{ BC5 BC21 vd v64 v65 v66 v67 Fp[2] Fc FC22[2] FC22[2] FC22[2] FC22[2]} FC24{ BC25{ BC5 BC21 vd v71 v72 v73 v74 v75 v76 v77 v78 v79} vd v68 v69 v70 Fi[2] FC26{ m Fi Fp Fi Fp[2] Fi} FC10 FC10 FC10 FC10 FC27{ m FC28{ m FL}} FL Fi Fp Fi Fc} FC29{ BC25 vd v80 v81 v82 FC26 FC10 FC10 Fp Fi} FC30{ BC5 BC21 vd v83 v84 v85 Fp} FC31{ BC5 BC21 vd v86 v87 Fp FC32{ m Fp Fi FC33{ m} FC33} FC10 FC10 Fi[2] Fc Fi[2]} FC34{ BC5 vd Fc Fp[2]} FC35{ BC5 BC21 vd v88 v89 v90 v91 v92 Fc} FC36{ BC37{ BC5 vd v95 v96 v97 v98 FC38{ m Fp FC9 FC10 FC10 Fi} Fp Fc Fi} v93 v94} FC39{ BC37 v99 v100 FC10} FC39 FC40{ BC37 v101 v102} FC41{ BC37 v103} FC41 FC41 FC41 FC42{ BC37 v104} FC43{ BC44{ BC5 vd v107 v108 v109 v110 FC38 Fp Fc Fi} v105 v106} FC45{ BC5 vd} FC46{ BC5 vd Fp[4]} FC47{ BC5 vd v111 v112 Fp[2] Fi[2]} FC48{ vd m Fp FC49{ m Fp} Fp Fi Fp} FC50{ BC51{ vd v118} BC52{ vd v119 v120 v121 v122 v123 Fp} vd v113 v114 v115 v116 v117 FC41 FC41 FC41 FC42 FC53{ BC37 v124 v125 v126 Fp} FC40 Fp[2] FC54{ m FC55{ m Fp Fi[2] FC11} Fp[2]}} FC56{ BC51 BC52 vd v127 v128 v129 v130 v131 Fp FC57{ BC5 BC21 vd v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 FC49 FC58{ m Fp} FC58 Fi[2] FC59{ BC60{ vd v145 v146} FC10 Fi FL[2] Fi} Fp FC61{ m Fp[2] FC62{ vd v147 v148 FC63{ m Fp Fi[2] FC64{ m}} FC65{ m Fi[4]}[3] Fp[2] Fi Fc} Fp[2]} Fc FC66{ BC67{ BC68{ BC69{ vd v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 Fp[2] FC9 Fp} vd v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 FC32 FC63 FC70{ m FC71{ m FL[2]}} FC9} v177 v178 v179 v180 FC72{ BC73{ BC69 vd v185 v186 v187 v188 v189 v190 Fp Fi FC74{ m Fp Fi FC64 FC17} FC70 Fi} vd v181 v182 v183 v184 FC9[4] FC70 FC70 FC70 FC70 Fi[6]} FC70 FC70} v149 v150 v151 v152 FC27 FC70} FC75{ BC69 vd v191 v192 v193 v194 v195 v196 Fp[2] FC70 FC70 FC70 Fi[13] Fp[3] Fi[3]} FC22[2] FC22[2] FC70 FC76{ vd m Fp[2] FC74 FC77{ vd m FL[2] Fi FC10 FC10 FC10 FC10 FC49}} FC9 Fp[2] FC9 Fp[3] Fc} FC42 FC40 FC78{ BC79{ BC5 BC21 vd v200 v201 v202 FC77 FL Fi} vd v197 v198 v199} FC78 FC80{ BC5 BC21 vd v203 v204 v205 v206 v207 v208 v209 v210 FC61 FC49 Fp} FC81{ BC25 BC51 vd v211 v212 v213 v214 v215 v216 Fi Fp Fi FC26} FC82{ BC21 vd v217 v218 v219 v220} FC77 FC41 FC41 Fp} FC83{ vd m Fc FC84{ m Fp} FC16} FC54 Fi Fc[2] Fp FC85{ BC86{} vd Fp[2] FC10 FC10 FC10 FC10 FC10 FL Fi FC27 FC27 Fi[2] FC49 Fi Fc Fi Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1} FC87{ BC86 FC10 FC10} Fp[3] Fc FC88{ m Fp[2]} Fp}


 S10102C1 ::~S10102C1(){ note_dtor("S10102C1", this);}
void  S10102C1 ::v1(){vfunc_called(this, "_ZN8S10102C12v1Ev");}
void  S10102C1 ::v2(){vfunc_called(this, "_ZN8S10102C12v2Ev");}
void  S10102C1 ::v3(){vfunc_called(this, "_ZN8S10102C12v3Ev");}
void  S10102C1 ::v4(){vfunc_called(this, "_ZN8S10102C12v4Ev");}
void  S10102C1 ::v5(){vfunc_called(this, "_ZN8S10102C12v5Ev");}
S10102C1 ::S10102C1(){ note_ctor("S10102C1", this);} // tgen

static void Test_S10102C1()
{
  extern Class_Descriptor cd_S10102C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1075,1481)];
    init_test(&cd_S10102C1, buf);
    S10102C1 *dp, &lv = *(dp=new (buf) S10102C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8592,5920), "sizeof(S10102C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10102C1)");
    check_base_class_offset(lv, (S10102C2*), 0, "S10102C1");
    check_base_class_offset(lv, (S10102C3*), ABISELECT(8,4), "S10102C1");
    check_field_offset(lv, s10102c1f0, ABISELECT(24,12), "S10102C1.s10102c1f0");
    check_field_offset(lv, s10102c1f1, ABISELECT(416,276), "S10102C1.s10102c1f1");
    check_field_offset(lv, s10102c1f2, ABISELECT(432,284), "S10102C1.s10102c1f2");
    check_field_offset(lv, s10102c1f3, ABISELECT(728,524), "S10102C1.s10102c1f3");
    check_field_offset(lv, s10102c1f4, ABISELECT(1048,776), "S10102C1.s10102c1f4");
    check_field_offset(lv, s10102c1f5, ABISELECT(1376,1000), "S10102C1.s10102c1f5");
    check_field_offset(lv, s10102c1f6, ABISELECT(1640,1168), "S10102C1.s10102c1f6");
    check_field_offset(lv, s10102c1f7, ABISELECT(1816,1284), "S10102C1.s10102c1f7");
    check_field_offset(lv, s10102c1f8, ABISELECT(2064,1456), "S10102C1.s10102c1f8");
    check_field_offset(lv, s10102c1f9, ABISELECT(2128,1496), "S10102C1.s10102c1f9");
    check_field_offset(lv, s10102c1f10, ABISELECT(2304,1612), "S10102C1.s10102c1f10");
    check_field_offset(lv, s10102c1f11, ABISELECT(2440,1704), "S10102C1.s10102c1f11");
    check_field_offset(lv, s10102c1f12, ABISELECT(2592,1808), "S10102C1.s10102c1f12");
    check_field_offset(lv, s10102c1f13, ABISELECT(2744,1912), "S10102C1.s10102c1f13");
    check_field_offset(lv, s10102c1f14, ABISELECT(2880,2004), "S10102C1.s10102c1f14");
    check_field_offset(lv, s10102c1f15, ABISELECT(3016,2096), "S10102C1.s10102c1f15");
    check_field_offset(lv, s10102c1f16, ABISELECT(3152,2188), "S10102C1.s10102c1f16");
    check_field_offset(lv, s10102c1f17, ABISELECT(3288,2280), "S10102C1.s10102c1f17");
    check_field_offset(lv, s10102c1f18, ABISELECT(3424,2372), "S10102C1.s10102c1f18");
    check_field_offset(lv, s10102c1f19, ABISELECT(3560,2464), "S10102C1.s10102c1f19");
    check_field_offset(lv, s10102c1f20, ABISELECT(3696,2556), "S10102C1.s10102c1f20");
    check_field_offset(lv, s10102c1f21, ABISELECT(3744,2588), "S10102C1.s10102c1f21");
    check_field_offset(lv, s10102c1f22, ABISELECT(3824,2636), "S10102C1.s10102c1f22");
    check_field_offset(lv, s10102c1f23, ABISELECT(3896,2684), "S10102C1.s10102c1f23");
    check_field_offset(lv, s10102c1f24, ABISELECT(3944,2708), "S10102C1.s10102c1f24");
    check_field_offset(lv, s10102c1f25, ABISELECT(4848,3308), "S10102C1.s10102c1f25");
    check_field_offset(lv, s10102c1f26, ABISELECT(8232,5676), "S10102C1.s10102c1f26");
    check_field_offset(lv, s10102c1f27, ABISELECT(8280,5704), "S10102C1.s10102c1f27");
    check_field_offset(lv, s10102c1f28, ABISELECT(8320,5728), "S10102C1.s10102c1f28");
    check_field_offset(lv, s10102c1f29, ABISELECT(8324,5732), "S10102C1.s10102c1f29");
    check_field_offset(lv, s10102c1f30, ABISELECT(8328,5736), "S10102C1.s10102c1f30");
    check_field_offset(lv, s10102c1f31, ABISELECT(8336,5740), "S10102C1.s10102c1f31");
    check_field_offset(lv, s10102c1f32, ABISELECT(8504,5868), "S10102C1.s10102c1f32");
    check_field_offset(lv, s10102c1f33, ABISELECT(8536,5892), "S10102C1.s10102c1f33");
    check_field_offset(lv, s10102c1f34, ABISELECT(8560,5904), "S10102C1.s10102c1f34");
    check_field_offset(lv, s10102c1f35, ABISELECT(8568,5908), "S10102C1.s10102c1f35");
    check_field_offset(lv, s10102c1f36, ABISELECT(8584,5916), "S10102C1.s10102c1f36");
    test_class_info(&lv, &cd_S10102C1);
    dp->~S10102C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10102C1(Test_S10102C1, "S10102C1", ABISELECT(8592,5920));

#else // __cplusplus

extern void _ZN8S10102C1C1Ev();
extern void _ZN8S10102C1D1Ev();
Name_Map name_map_S10102C1[] = {
  NSPAIR(_ZN8S10102C1C1Ev),
  NSPAIR(_ZN8S10102C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10102C2;
extern VTBL_ENTRY _ZTI8S10102C2[];
extern  VTBL_ENTRY _ZTV8S10102C2[];
extern Class_Descriptor cd_S10102C3;
extern VTBL_ENTRY _ZTI8S10102C3[];
extern  VTBL_ENTRY _ZTV8S10102C3[];
static Base_Class bases_S10102C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10102C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10102C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10102C1[];
extern void _ZN8S10102C1D1Ev();
extern void _ZN8S10102C1D0Ev();
extern void _ZN8S10102C22v6Ev();
extern void _ZN8S10102C12v1Ev();
extern void _ZN8S10102C12v2Ev();
extern void _ZN8S10102C12v3Ev();
extern void _ZN8S10102C12v4Ev();
extern void _ZN8S10102C12v5Ev();
extern void ABISELECT(_ZThn8_N8S10102C1D1Ev,_ZThn4_N8S10102C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10102C1D0Ev,_ZThn4_N8S10102C1D0Ev)();
extern void _ZN8S10102C32v7Ev();
extern void _ZN8S10102C32v8Ev();
extern void _ZN8S10102C32v9Ev();
extern void _ZN8S10102C33v10Ev();
extern void _ZN8S10102C33v11Ev();
static  VTBL_ENTRY vtc_S10102C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10102C1[0]),
  (VTBL_ENTRY)&_ZN8S10102C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10102C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10102C22v6Ev,
  (VTBL_ENTRY)&_ZN8S10102C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10102C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10102C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10102C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10102C12v5Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10102C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10102C1D1Ev,_ZThn4_N8S10102C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10102C1D0Ev,_ZThn4_N8S10102C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10102C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10102C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10102C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10102C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10102C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10102C1[];
extern  VTBL_ENTRY _ZTV8S10102C1[];
Class_Descriptor cd_S10102C1 = {  "S10102C1", // class name
  bases_S10102C1, 2,
  &(vtc_S10102C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8592,5920), // object size
  NSPAIRA(_ZTI8S10102C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10102C1),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10104C2  {
  virtual  ~S10104C2(); // _ZN8S10104C2D1Ev
  virtual void  v6(); // _ZN8S10104C22v6Ev
  S10104C2(); // tgen
};
//SIG(-1 S10104C2) C1{ vd v1}


 S10104C2 ::~S10104C2(){ note_dtor("S10104C2", this);}
void  S10104C2 ::v6(){vfunc_called(this, "_ZN8S10104C22v6Ev");}
S10104C2 ::S10104C2(){ note_ctor("S10104C2", this);} // tgen

static void Test_S10104C2()
{
  extern Class_Descriptor cd_S10104C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10104C2, buf);
    S10104C2 *dp, &lv = *(dp=new (buf) S10104C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10104C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10104C2)");
    test_class_info(&lv, &cd_S10104C2);
    dp->~S10104C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10104C2(Test_S10104C2, "S10104C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10104C2C1Ev();
extern void _ZN8S10104C2D1Ev();
Name_Map name_map_S10104C2[] = {
  NSPAIR(_ZN8S10104C2C1Ev),
  NSPAIR(_ZN8S10104C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10104C2[];
extern void _ZN8S10104C2D1Ev();
extern void _ZN8S10104C2D0Ev();
extern void _ZN8S10104C22v6Ev();
static  VTBL_ENTRY vtc_S10104C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10104C2[0]),
  (VTBL_ENTRY)&_ZN8S10104C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10104C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10104C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S10104C2[];
extern  VTBL_ENTRY _ZTV8S10104C2[];
Class_Descriptor cd_S10104C2 = {  "S10104C2", // class name
  0,0,//no base classes
  &(vtc_S10104C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10104C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10104C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10104C3  {
  void *s10104c3f0;
  virtual  ~S10104C3(); // _ZN8S10104C3D1Ev
  virtual void  v7(); // _ZN8S10104C32v7Ev
  virtual void  v8(); // _ZN8S10104C32v8Ev
  virtual void  v9(); // _ZN8S10104C32v9Ev
  virtual void  v10(); // _ZN8S10104C33v10Ev
  virtual void  v11(); // _ZN8S10104C33v11Ev
  S10104C3(); // tgen
};
//SIG(-1 S10104C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10104C3 ::~S10104C3(){ note_dtor("S10104C3", this);}
void  S10104C3 ::v7(){vfunc_called(this, "_ZN8S10104C32v7Ev");}
void  S10104C3 ::v8(){vfunc_called(this, "_ZN8S10104C32v8Ev");}
void  S10104C3 ::v9(){vfunc_called(this, "_ZN8S10104C32v9Ev");}
void  S10104C3 ::v10(){vfunc_called(this, "_ZN8S10104C33v10Ev");}
void  S10104C3 ::v11(){vfunc_called(this, "_ZN8S10104C33v11Ev");}
S10104C3 ::S10104C3(){ note_ctor("S10104C3", this);} // tgen

static void Test_S10104C3()
{
  extern Class_Descriptor cd_S10104C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10104C3, buf);
    S10104C3 *dp, &lv = *(dp=new (buf) S10104C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10104C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10104C3)");
    check_field_offset(lv, s10104c3f0, ABISELECT(8,4), "S10104C3.s10104c3f0");
    test_class_info(&lv, &cd_S10104C3);
    dp->~S10104C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10104C3(Test_S10104C3, "S10104C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10104C3C1Ev();
extern void _ZN8S10104C3D1Ev();
Name_Map name_map_S10104C3[] = {
  NSPAIR(_ZN8S10104C3C1Ev),
  NSPAIR(_ZN8S10104C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10104C3[];
extern void _ZN8S10104C3D1Ev();
extern void _ZN8S10104C3D0Ev();
extern void _ZN8S10104C32v7Ev();
extern void _ZN8S10104C32v8Ev();
extern void _ZN8S10104C32v9Ev();
extern void _ZN8S10104C33v10Ev();
extern void _ZN8S10104C33v11Ev();
static  VTBL_ENTRY vtc_S10104C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10104C3[0]),
  (VTBL_ENTRY)&_ZN8S10104C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10104C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10104C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10104C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10104C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10104C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10104C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10104C3[];
extern  VTBL_ENTRY _ZTV8S10104C3[];
Class_Descriptor cd_S10104C3 = {  "S10104C3", // class name
  0,0,//no base classes
  &(vtc_S10104C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10104C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10104C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10104C12  {
  void *s10104c12f0;
  ::S10103C13_nt s10104c12f1;
  ::S10103C16_nt s10104c12f2;
  ::S10103C17 s10104c12f3;
  virtual  ~S10104C12(); // _ZN9S10104C12D1Ev
  virtual void  v14(); // _ZN9S10104C123v14Ev
  virtual void  v15(); // _ZN9S10104C123v15Ev
  virtual void  v16(); // _ZN9S10104C123v16Ev
  virtual void  v17(); // _ZN9S10104C123v17Ev
  virtual void  v18(); // _ZN9S10104C123v18Ev
  virtual void  v19(); // _ZN9S10104C123v19Ev
  virtual void  v20(); // _ZN9S10104C123v20Ev
  virtual void  v21(); // _ZN9S10104C123v21Ev
  virtual void  v22(); // _ZN9S10104C123v22Ev
  virtual void  v23(); // _ZN9S10104C123v23Ev
  virtual void  v24(); // _ZN9S10104C123v24Ev
  virtual void  v25(); // _ZN9S10104C123v25Ev
  virtual void  v26(); // _ZN9S10104C123v26Ev
  virtual void  v27(); // _ZN9S10104C123v27Ev
  virtual void  v28(); // _ZN9S10104C123v28Ev
  virtual void  v29(); // _ZN9S10104C123v29Ev
  virtual void  v30(); // _ZN9S10104C123v30Ev
  virtual void  v31(); // _ZN9S10104C123v31Ev
  virtual void  v32(); // _ZN9S10104C123v32Ev
  virtual void  v33(); // _ZN9S10104C123v33Ev
  virtual void  v34(); // _ZN9S10104C123v34Ev
  virtual void  v35(); // _ZN9S10104C123v35Ev
  virtual void  v36(); // _ZN9S10104C123v36Ev
  virtual void  v37(); // _ZN9S10104C123v37Ev
  S10104C12(); // tgen
};
//SIG(-1 S10104C12) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC6{ m Fc Fi[2] Fp}}


 S10104C12 ::~S10104C12(){ note_dtor("S10104C12", this);}
void  S10104C12 ::v14(){vfunc_called(this, "_ZN9S10104C123v14Ev");}
void  S10104C12 ::v15(){vfunc_called(this, "_ZN9S10104C123v15Ev");}
void  S10104C12 ::v16(){vfunc_called(this, "_ZN9S10104C123v16Ev");}
void  S10104C12 ::v17(){vfunc_called(this, "_ZN9S10104C123v17Ev");}
void  S10104C12 ::v18(){vfunc_called(this, "_ZN9S10104C123v18Ev");}
void  S10104C12 ::v19(){vfunc_called(this, "_ZN9S10104C123v19Ev");}
void  S10104C12 ::v20(){vfunc_called(this, "_ZN9S10104C123v20Ev");}
void  S10104C12 ::v21(){vfunc_called(this, "_ZN9S10104C123v21Ev");}
void  S10104C12 ::v22(){vfunc_called(this, "_ZN9S10104C123v22Ev");}
void  S10104C12 ::v23(){vfunc_called(this, "_ZN9S10104C123v23Ev");}
void  S10104C12 ::v24(){vfunc_called(this, "_ZN9S10104C123v24Ev");}
void  S10104C12 ::v25(){vfunc_called(this, "_ZN9S10104C123v25Ev");}
void  S10104C12 ::v26(){vfunc_called(this, "_ZN9S10104C123v26Ev");}
void  S10104C12 ::v27(){vfunc_called(this, "_ZN9S10104C123v27Ev");}
void  S10104C12 ::v28(){vfunc_called(this, "_ZN9S10104C123v28Ev");}
void  S10104C12 ::v29(){vfunc_called(this, "_ZN9S10104C123v29Ev");}
void  S10104C12 ::v30(){vfunc_called(this, "_ZN9S10104C123v30Ev");}
void  S10104C12 ::v31(){vfunc_called(this, "_ZN9S10104C123v31Ev");}
void  S10104C12 ::v32(){vfunc_called(this, "_ZN9S10104C123v32Ev");}
void  S10104C12 ::v33(){vfunc_called(this, "_ZN9S10104C123v33Ev");}
void  S10104C12 ::v34(){vfunc_called(this, "_ZN9S10104C123v34Ev");}
void  S10104C12 ::v35(){vfunc_called(this, "_ZN9S10104C123v35Ev");}
void  S10104C12 ::v36(){vfunc_called(this, "_ZN9S10104C123v36Ev");}
void  S10104C12 ::v37(){vfunc_called(this, "_ZN9S10104C123v37Ev");}
S10104C12 ::S10104C12(){ note_ctor("S10104C12", this);} // tgen

static void Test_S10104C12()
{
  extern Class_Descriptor cd_S10104C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S10104C12, buf);
    S10104C12 *dp, &lv = *(dp=new (buf) S10104C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S10104C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10104C12)");
    check_field_offset(lv, s10104c12f0, ABISELECT(8,4), "S10104C12.s10104c12f0");
    check_field_offset(lv, s10104c12f1, ABISELECT(16,8), "S10104C12.s10104c12f1");
    check_field_offset(lv, s10104c12f2, ABISELECT(40,24), "S10104C12.s10104c12f2");
    check_field_offset(lv, s10104c12f3, ABISELECT(96,64), "S10104C12.s10104c12f3");
    test_class_info(&lv, &cd_S10104C12);
    dp->~S10104C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10104C12(Test_S10104C12, "S10104C12", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN9S10104C12C1Ev();
extern void _ZN9S10104C12D1Ev();
Name_Map name_map_S10104C12[] = {
  NSPAIR(_ZN9S10104C12C1Ev),
  NSPAIR(_ZN9S10104C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10104C12[];
extern void _ZN9S10104C12D1Ev();
extern void _ZN9S10104C12D0Ev();
extern void _ZN9S10104C123v14Ev();
extern void _ZN9S10104C123v15Ev();
extern void _ZN9S10104C123v16Ev();
extern void _ZN9S10104C123v17Ev();
extern void _ZN9S10104C123v18Ev();
extern void _ZN9S10104C123v19Ev();
extern void _ZN9S10104C123v20Ev();
extern void _ZN9S10104C123v21Ev();
extern void _ZN9S10104C123v22Ev();
extern void _ZN9S10104C123v23Ev();
extern void _ZN9S10104C123v24Ev();
extern void _ZN9S10104C123v25Ev();
extern void _ZN9S10104C123v26Ev();
extern void _ZN9S10104C123v27Ev();
extern void _ZN9S10104C123v28Ev();
extern void _ZN9S10104C123v29Ev();
extern void _ZN9S10104C123v30Ev();
extern void _ZN9S10104C123v31Ev();
extern void _ZN9S10104C123v32Ev();
extern void _ZN9S10104C123v33Ev();
extern void _ZN9S10104C123v34Ev();
extern void _ZN9S10104C123v35Ev();
extern void _ZN9S10104C123v36Ev();
extern void _ZN9S10104C123v37Ev();
static  VTBL_ENTRY vtc_S10104C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10104C12[0]),
  (VTBL_ENTRY)&_ZN9S10104C12D1Ev,
  (VTBL_ENTRY)&_ZN9S10104C12D0Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v37Ev,
};
extern VTBL_ENTRY _ZTI9S10104C12[];
extern  VTBL_ENTRY _ZTV9S10104C12[];
Class_Descriptor cd_S10104C12 = {  "S10104C12", // class name
  0,0,//no base classes
  &(vtc_S10104C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI9S10104C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10104C12),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10104C22_nt  {
  __tsi64 s10104c22f0[4];
  void  mf10104c22(); // _ZN12S10104C22_nt10mf10104c22Ev
};
//SIG(-1 S10104C22_nt) C1{ m FL[4]}


void  S10104C22_nt ::mf10104c22(){}

//skip512 S10104C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10104C19  {
  int s10104c19f0;
  ::S10103C106 s10104c19f1;
  ::S10104C22_nt s10104c19f2;
  void  mf10104c19(); // _ZN9S10104C1910mf10104c19Ev
  virtual  ~S10104C19(); // _ZN9S10104C19D1Ev
  S10104C19(); // tgen
};
//SIG(-1 S10104C19) C1{ vd m Fi FC2{ m Fp Fi[2] FC3{ m}} FC4{ m FL[4]}}


void  S10104C19 ::mf10104c19(){}
 S10104C19 ::~S10104C19(){ note_dtor("S10104C19", this);}
S10104C19 ::S10104C19(){ note_ctor("S10104C19", this);} // tgen

static void Test_S10104C19()
{
  extern Class_Descriptor cd_S10104C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S10104C19, buf);
    S10104C19 *dp, &lv = *(dp=new (buf) S10104C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S10104C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10104C19)");
    check_field_offset(lv, s10104c19f0, ABISELECT(8,4), "S10104C19.s10104c19f0");
    check_field_offset(lv, s10104c19f1, ABISELECT(16,8), "S10104C19.s10104c19f1");
    check_field_offset(lv, s10104c19f2, ABISELECT(40,24), "S10104C19.s10104c19f2");
    test_class_info(&lv, &cd_S10104C19);
    dp->~S10104C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10104C19(Test_S10104C19, "S10104C19", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN9S10104C19C1Ev();
extern void _ZN9S10104C19D1Ev();
Name_Map name_map_S10104C19[] = {
  NSPAIR(_ZN9S10104C19C1Ev),
  NSPAIR(_ZN9S10104C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10104C19[];
extern void _ZN9S10104C19D1Ev();
extern void _ZN9S10104C19D0Ev();
static  VTBL_ENTRY vtc_S10104C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10104C19[0]),
  (VTBL_ENTRY)&_ZN9S10104C19D1Ev,
  (VTBL_ENTRY)&_ZN9S10104C19D0Ev,
};
extern VTBL_ENTRY _ZTI9S10104C19[];
extern  VTBL_ENTRY _ZTV9S10104C19[];
Class_Descriptor cd_S10104C19 = {  "S10104C19", // class name
  0,0,//no base classes
  &(vtc_S10104C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI9S10104C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10104C19),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10104C4  : S10103C5_nt , S10104C12 {
  int s10104c4f0;
  void *s10104c4f1[8];
  int s10104c4f2[2];
  ::S10103C18 s10104c4f3;
  int s10104c4f4[4];
  char s10104c4f5;
  ::S10104C19 s10104c4f6;
  void *s10104c4f7;
  virtual  ~S10104C4(); // _ZN8S10104C4D1Ev
  virtual void  v12(); // _ZN8S10104C43v12Ev
  virtual void  v13(); // _ZN8S10104C43v13Ev
  S10104C4(); // tgen
};
//SIG(-1 S10104C4) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 Fi Fp[8] Fi[2] FC11{ Fi[11]} Fi[4] Fc FC12{ vd m Fi FC13{ m Fp Fi[2] FC14{ m}} FC15{ m FL[4]}} Fp}


 S10104C4 ::~S10104C4(){ note_dtor("S10104C4", this);}
void  S10104C4 ::v12(){vfunc_called(this, "_ZN8S10104C43v12Ev");}
void  S10104C4 ::v13(){vfunc_called(this, "_ZN8S10104C43v13Ev");}
S10104C4 ::S10104C4(){ note_ctor("S10104C4", this);} // tgen

static void Test_S10104C4()
{
  extern Class_Descriptor cd_S10104C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S10104C4, buf);
    S10104C4 *dp, &lv = *(dp=new (buf) S10104C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S10104C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10104C4)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10104C4");
    check_base_class_offset(lv, (S10104C12*), ABISELECT(48,32), "S10104C4");
    check_field_offset(lv, s10104c4f0, ABISELECT(168,112), "S10104C4.s10104c4f0");
    check_field_offset(lv, s10104c4f1, ABISELECT(176,116), "S10104C4.s10104c4f1");
    check_field_offset(lv, s10104c4f2, ABISELECT(240,148), "S10104C4.s10104c4f2");
    check_field_offset(lv, s10104c4f3, ABISELECT(248,156), "S10104C4.s10104c4f3");
    check_field_offset(lv, s10104c4f4, ABISELECT(292,200), "S10104C4.s10104c4f4");
    check_field_offset(lv, s10104c4f5, ABISELECT(308,216), "S10104C4.s10104c4f5");
    check_field_offset(lv, s10104c4f6, ABISELECT(312,220), "S10104C4.s10104c4f6");
    check_field_offset(lv, s10104c4f7, ABISELECT(384,276), "S10104C4.s10104c4f7");
    test_class_info(&lv, &cd_S10104C4);
    dp->~S10104C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10104C4(Test_S10104C4, "S10104C4", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN8S10104C4C1Ev();
extern void _ZN8S10104C4D1Ev();
Name_Map name_map_S10104C4[] = {
  NSPAIR(_ZN8S10104C4C1Ev),
  NSPAIR(_ZN8S10104C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10104C12;
extern VTBL_ENTRY _ZTI9S10104C12[];
extern  VTBL_ENTRY _ZTV9S10104C12[];
static Base_Class bases_S10104C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10104C12,    ABISELECT(48,32), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10104C4[];
extern void _ZN8S10104C4D1Ev();
extern void _ZN8S10104C4D0Ev();
extern void _ZN8S10104C43v12Ev();
extern void _ZN8S10104C43v13Ev();
extern void ABISELECT(_ZThn48_N8S10104C4D1Ev,_ZThn32_N8S10104C4D1Ev)();
extern void ABISELECT(_ZThn48_N8S10104C4D0Ev,_ZThn32_N8S10104C4D0Ev)();
extern void _ZN9S10104C123v14Ev();
extern void _ZN9S10104C123v15Ev();
extern void _ZN9S10104C123v16Ev();
extern void _ZN9S10104C123v17Ev();
extern void _ZN9S10104C123v18Ev();
extern void _ZN9S10104C123v19Ev();
extern void _ZN9S10104C123v20Ev();
extern void _ZN9S10104C123v21Ev();
extern void _ZN9S10104C123v22Ev();
extern void _ZN9S10104C123v23Ev();
extern void _ZN9S10104C123v24Ev();
extern void _ZN9S10104C123v25Ev();
extern void _ZN9S10104C123v26Ev();
extern void _ZN9S10104C123v27Ev();
extern void _ZN9S10104C123v28Ev();
extern void _ZN9S10104C123v29Ev();
extern void _ZN9S10104C123v30Ev();
extern void _ZN9S10104C123v31Ev();
extern void _ZN9S10104C123v32Ev();
extern void _ZN9S10104C123v33Ev();
extern void _ZN9S10104C123v34Ev();
extern void _ZN9S10104C123v35Ev();
extern void _ZN9S10104C123v36Ev();
extern void _ZN9S10104C123v37Ev();
static  VTBL_ENTRY vtc_S10104C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10104C4[0]),
  (VTBL_ENTRY)&_ZN8S10104C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10104C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10104C43v12Ev,
  (VTBL_ENTRY)&_ZN8S10104C43v13Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8S10104C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10104C4D1Ev,_ZThn32_N8S10104C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10104C4D0Ev,_ZThn32_N8S10104C4D0Ev),
  (VTBL_ENTRY)&_ZN9S10104C123v14Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v15Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v16Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v17Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v18Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v19Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v20Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v21Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v22Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v23Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v24Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v25Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v26Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v27Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v28Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v29Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v30Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v31Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v32Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v33Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v34Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v35Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v36Ev,
  (VTBL_ENTRY)&_ZN9S10104C123v37Ev,
};
extern VTBL_ENTRY _ZTI8S10104C4[];
extern  VTBL_ENTRY _ZTV8S10104C4[];
Class_Descriptor cd_S10104C4 = {  "S10104C4", // class name
  bases_S10104C4, 2,
  &(vtc_S10104C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI8S10104C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10104C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10104C1  : S10104C2 , S10104C3 {
  ::S10104C4 s10104c1f0;
  void *s10104c1f1[2];
  ::S10103C24 s10104c1f2;
  ::S10103C26 s10104c1f3;
  ::S10103C27 s10104c1f4;
  ::S10103C32 s10104c1f5;
  ::S10103C33 s10104c1f6;
  ::S10103C34 s10104c1f7;
  ::S10103C38 s10104c1f8;
  ::S10103C39 s10104c1f9;
  ::S10103C49 s10104c1f10;
  ::S10103C45 s10104c1f11;
  ::S10103C45 s10104c1f12;
  ::S10103C40 s10104c1f13;
  ::S10103C56 s10104c1f14;
  ::S10103C56 s10104c1f15;
  ::S10103C56 s10104c1f16;
  ::S10103C56 s10104c1f17;
  ::S10103C47 s10104c1f18;
  ::S10102C49 s10104c1f19;
  ::S10103C50 s10104c1f20;
  ::S10103C51 s10104c1f21;
  ::S10103C52 s10104c1f22;
  ::S10103C53 s10104c1f23;
  ::S10103C55 s10104c1f24;
  ::S10103C61 s10104c1f25;
  ::S10103C104 s10104c1f26;
  ::S10103C58_nt s10104c1f27;
  int s10104c1f28;
  char s10104c1f29[2];
  void *s10104c1f30;
  ::S10103C108 s10104c1f31;
  ::S10103C110 s10104c1f32;
  void *s10104c1f33[3];
  char s10104c1f34;
  ::S10103C111_nt s10104c1f35;
  void *s10104c1f36;
  virtual  ~S10104C1(); // _ZN8S10104C1D1Ev
  virtual void  v1(); // _ZN8S10104C12v1Ev
  virtual void  v2(); // _ZN8S10104C12v2Ev
  virtual void  v3(); // _ZN8S10104C12v3Ev
  virtual void  v4(); // _ZN8S10104C12v4Ev
  virtual void  v5(); // _ZN8S10104C12v5Ev
  S10104C1(); // tgen
};
//SIG(1 S10104C1) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} vd v1 v2 v3 v4 v5 FC4{ BC5{ vd m FC6{ m Fp Fi FC7{ m} FC7} FC6 Fc} BC8{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp FC9{ m FC10{ m Fp Fi FC11{ m}} Fi} FC12{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC13{ m Fc Fi[2] Fp}} vd v12 v13 Fi Fp[8] Fi[2] FC14{ Fi[11]} Fi[4] Fc FC15{ vd m Fi FC16{ m Fp Fi[2] FC17{ m}} FC18{ m FL[4]}} Fp} Fp[2] FC19{ BC5 BC20{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 Fp FC9 FC12 FC13} vd v38 v39 FC21{ Fi[4]}[2] FC21[2] FC21[2] FC21[2]} FC22{ BC5 BC20 vd v64 v65 v66 v67 Fp[2] Fc FC21[2] FC21[2] FC21[2] FC21[2]} FC23{ BC24{ BC5 BC20 vd v71 v72 v73 v74 v75 v76 v77 v78 v79} vd v68 v69 v70 Fi[2] FC25{ m Fi Fp Fi Fp[2] Fi} FC10 FC10 FC10 FC10 FC26{ m FC27{ m FL}} FL Fi Fp Fi Fc} FC28{ BC24 vd v80 v81 v82 FC25 FC10 FC10 Fp Fi} FC29{ BC5 BC20 vd v83 v84 v85 Fp} FC30{ BC5 BC20 vd v86 v87 Fp FC31{ m Fp Fi FC32{ m} FC32} FC10 FC10 Fi[2] Fc Fi[2]} FC33{ BC5 vd Fc Fp[2]} FC34{ BC5 BC20 vd v88 v89 v90 v91 v92 Fc} FC35{ BC36{ BC5 vd v95 v96 v97 v98 FC37{ m Fp FC9 FC10 FC10 Fi} Fp Fc Fi} v93 v94} FC38{ BC36 v99 v100 FC10} FC38 FC39{ BC36 v101 v102} FC40{ BC36 v103} FC40 FC40 FC40 FC41{ BC36 v104} FC42{ BC43{ BC5 vd v107 v108 v109 v110 FC37 Fp Fc Fi} v105 v106} FC44{ BC5 vd} FC45{ BC5 vd Fp[4]} FC46{ BC5 vd v111 v112 Fp[2] Fi[2]} FC47{ vd m Fp FC48{ m Fp} Fp Fi Fp} FC49{ BC50{ vd v118} BC51{ vd v119 v120 v121 v122 v123 Fp} vd v113 v114 v115 v116 v117 FC40 FC40 FC40 FC41 FC52{ BC36 v124 v125 v126 Fp} FC39 Fp[2] FC53{ m FC54{ m Fp Fi[2] FC11} Fp[2]}} FC55{ BC50 BC51 vd v127 v128 v129 v130 v131 Fp FC56{ BC5 BC20 vd v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 FC48 FC57{ m Fp} FC57 Fi[2] FC58{ BC59{ vd v145 v146} FC10 Fi FL[2] Fi} Fp FC60{ m Fp[2] FC61{ vd v147 v148 FC62{ m Fp Fi[2] FC63{ m}} FC64{ m Fi[4]}[3] Fp[2] Fi Fc} Fp[2]} Fc FC65{ BC66{ BC67{ BC68{ vd v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 Fp[2] FC9 Fp} vd v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 FC31 FC62 FC69{ m FC70{ m FL[2]}} FC9} v177 v178 v179 v180 FC71{ BC72{ BC68 vd v185 v186 v187 v188 v189 v190 Fp Fi FC73{ m Fp Fi FC63 FC17} FC69 Fi} vd v181 v182 v183 v184 FC9[4] FC69 FC69 FC69 FC69 Fi[6]} FC69 FC69} v149 v150 v151 v152 FC26 FC69} FC74{ BC68 vd v191 v192 v193 v194 v195 v196 Fp[2] FC69 FC69 FC69 Fi[13] Fp[3] Fi[3]} FC21[2] FC21[2] FC69 FC75{ vd m Fp[2] FC73 FC76{ vd m FL[2] Fi FC10 FC10 FC10 FC10 FC48}} FC9 Fp[2] FC9 Fp[3] Fc} FC41 FC39 FC77{ BC78{ BC5 BC20 vd v200 v201 v202 FC76 FL Fi} vd v197 v198 v199} FC77 FC79{ BC5 BC20 vd v203 v204 v205 v206 v207 v208 v209 v210 FC60 FC48 Fp} FC80{ BC24 BC50 vd v211 v212 v213 v214 v215 v216 Fi Fp Fi FC25} FC81{ BC20 vd v217 v218 v219 v220} FC76 FC40 FC40 Fp} FC82{ vd m Fc FC83{ m Fp} FC16} FC53 Fi Fc[2] Fp FC84{ BC85{} vd Fp[2] FC10 FC10 FC10 FC10 FC10 FL Fi FC26 FC26 Fi[2] FC48 Fi Fc Fi Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1} FC86{ BC85 FC10 FC10} Fp[3] Fc FC87{ m Fp[2]} Fp}


 S10104C1 ::~S10104C1(){ note_dtor("S10104C1", this);}
void  S10104C1 ::v1(){vfunc_called(this, "_ZN8S10104C12v1Ev");}
void  S10104C1 ::v2(){vfunc_called(this, "_ZN8S10104C12v2Ev");}
void  S10104C1 ::v3(){vfunc_called(this, "_ZN8S10104C12v3Ev");}
void  S10104C1 ::v4(){vfunc_called(this, "_ZN8S10104C12v4Ev");}
void  S10104C1 ::v5(){vfunc_called(this, "_ZN8S10104C12v5Ev");}
S10104C1 ::S10104C1(){ note_ctor("S10104C1", this);} // tgen

static void Test_S10104C1()
{
  extern Class_Descriptor cd_S10104C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1075,1485)];
    init_test(&cd_S10104C1, buf);
    S10104C1 *dp, &lv = *(dp=new (buf) S10104C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8592,5936), "sizeof(S10104C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10104C1)");
    check_base_class_offset(lv, (S10104C2*), 0, "S10104C1");
    check_base_class_offset(lv, (S10104C3*), ABISELECT(8,4), "S10104C1");
    check_field_offset(lv, s10104c1f0, ABISELECT(24,12), "S10104C1.s10104c1f0");
    check_field_offset(lv, s10104c1f1, ABISELECT(416,292), "S10104C1.s10104c1f1");
    check_field_offset(lv, s10104c1f2, ABISELECT(432,300), "S10104C1.s10104c1f2");
    check_field_offset(lv, s10104c1f3, ABISELECT(728,540), "S10104C1.s10104c1f3");
    check_field_offset(lv, s10104c1f4, ABISELECT(1048,792), "S10104C1.s10104c1f4");
    check_field_offset(lv, s10104c1f5, ABISELECT(1376,1016), "S10104C1.s10104c1f5");
    check_field_offset(lv, s10104c1f6, ABISELECT(1640,1184), "S10104C1.s10104c1f6");
    check_field_offset(lv, s10104c1f7, ABISELECT(1816,1300), "S10104C1.s10104c1f7");
    check_field_offset(lv, s10104c1f8, ABISELECT(2064,1472), "S10104C1.s10104c1f8");
    check_field_offset(lv, s10104c1f9, ABISELECT(2128,1512), "S10104C1.s10104c1f9");
    check_field_offset(lv, s10104c1f10, ABISELECT(2304,1628), "S10104C1.s10104c1f10");
    check_field_offset(lv, s10104c1f11, ABISELECT(2440,1720), "S10104C1.s10104c1f11");
    check_field_offset(lv, s10104c1f12, ABISELECT(2592,1824), "S10104C1.s10104c1f12");
    check_field_offset(lv, s10104c1f13, ABISELECT(2744,1928), "S10104C1.s10104c1f13");
    check_field_offset(lv, s10104c1f14, ABISELECT(2880,2020), "S10104C1.s10104c1f14");
    check_field_offset(lv, s10104c1f15, ABISELECT(3016,2112), "S10104C1.s10104c1f15");
    check_field_offset(lv, s10104c1f16, ABISELECT(3152,2204), "S10104C1.s10104c1f16");
    check_field_offset(lv, s10104c1f17, ABISELECT(3288,2296), "S10104C1.s10104c1f17");
    check_field_offset(lv, s10104c1f18, ABISELECT(3424,2388), "S10104C1.s10104c1f18");
    check_field_offset(lv, s10104c1f19, ABISELECT(3560,2480), "S10104C1.s10104c1f19");
    check_field_offset(lv, s10104c1f20, ABISELECT(3696,2572), "S10104C1.s10104c1f20");
    check_field_offset(lv, s10104c1f21, ABISELECT(3744,2604), "S10104C1.s10104c1f21");
    check_field_offset(lv, s10104c1f22, ABISELECT(3824,2652), "S10104C1.s10104c1f22");
    check_field_offset(lv, s10104c1f23, ABISELECT(3896,2700), "S10104C1.s10104c1f23");
    check_field_offset(lv, s10104c1f24, ABISELECT(3944,2724), "S10104C1.s10104c1f24");
    check_field_offset(lv, s10104c1f25, ABISELECT(4848,3324), "S10104C1.s10104c1f25");
    check_field_offset(lv, s10104c1f26, ABISELECT(8232,5692), "S10104C1.s10104c1f26");
    check_field_offset(lv, s10104c1f27, ABISELECT(8280,5720), "S10104C1.s10104c1f27");
    check_field_offset(lv, s10104c1f28, ABISELECT(8320,5744), "S10104C1.s10104c1f28");
    check_field_offset(lv, s10104c1f29, ABISELECT(8324,5748), "S10104C1.s10104c1f29");
    check_field_offset(lv, s10104c1f30, ABISELECT(8328,5752), "S10104C1.s10104c1f30");
    check_field_offset(lv, s10104c1f31, ABISELECT(8336,5756), "S10104C1.s10104c1f31");
    check_field_offset(lv, s10104c1f32, ABISELECT(8504,5884), "S10104C1.s10104c1f32");
    check_field_offset(lv, s10104c1f33, ABISELECT(8536,5908), "S10104C1.s10104c1f33");
    check_field_offset(lv, s10104c1f34, ABISELECT(8560,5920), "S10104C1.s10104c1f34");
    check_field_offset(lv, s10104c1f35, ABISELECT(8568,5924), "S10104C1.s10104c1f35");
    check_field_offset(lv, s10104c1f36, ABISELECT(8584,5932), "S10104C1.s10104c1f36");
    test_class_info(&lv, &cd_S10104C1);
    dp->~S10104C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10104C1(Test_S10104C1, "S10104C1", ABISELECT(8592,5936));

#else // __cplusplus

extern void _ZN8S10104C1C1Ev();
extern void _ZN8S10104C1D1Ev();
Name_Map name_map_S10104C1[] = {
  NSPAIR(_ZN8S10104C1C1Ev),
  NSPAIR(_ZN8S10104C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10104C2;
extern VTBL_ENTRY _ZTI8S10104C2[];
extern  VTBL_ENTRY _ZTV8S10104C2[];
extern Class_Descriptor cd_S10104C3;
extern VTBL_ENTRY _ZTI8S10104C3[];
extern  VTBL_ENTRY _ZTV8S10104C3[];
static Base_Class bases_S10104C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10104C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10104C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10104C1[];
extern void _ZN8S10104C1D1Ev();
extern void _ZN8S10104C1D0Ev();
extern void _ZN8S10104C22v6Ev();
extern void _ZN8S10104C12v1Ev();
extern void _ZN8S10104C12v2Ev();
extern void _ZN8S10104C12v3Ev();
extern void _ZN8S10104C12v4Ev();
extern void _ZN8S10104C12v5Ev();
extern void ABISELECT(_ZThn8_N8S10104C1D1Ev,_ZThn4_N8S10104C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10104C1D0Ev,_ZThn4_N8S10104C1D0Ev)();
extern void _ZN8S10104C32v7Ev();
extern void _ZN8S10104C32v8Ev();
extern void _ZN8S10104C32v9Ev();
extern void _ZN8S10104C33v10Ev();
extern void _ZN8S10104C33v11Ev();
static  VTBL_ENTRY vtc_S10104C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10104C1[0]),
  (VTBL_ENTRY)&_ZN8S10104C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10104C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10104C22v6Ev,
  (VTBL_ENTRY)&_ZN8S10104C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10104C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10104C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10104C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10104C12v5Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10104C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10104C1D1Ev,_ZThn4_N8S10104C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10104C1D0Ev,_ZThn4_N8S10104C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10104C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10104C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10104C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10104C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10104C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10104C1[];
extern  VTBL_ENTRY _ZTV8S10104C1[];
Class_Descriptor cd_S10104C1 = {  "S10104C1", // class name
  bases_S10104C1, 2,
  &(vtc_S10104C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8592,5936), // object size
  NSPAIRA(_ZTI8S10104C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10104C1),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C2  {
  virtual  ~S10098C2(); // _ZN8S10098C2D1Ev
  virtual void  v6(); // _ZN8S10098C22v6Ev
  S10098C2(); // tgen
};
//SIG(-1 S10098C2) C1{ vd v1}


 S10098C2 ::~S10098C2(){ note_dtor("S10098C2", this);}
void  S10098C2 ::v6(){vfunc_called(this, "_ZN8S10098C22v6Ev");}
S10098C2 ::S10098C2(){ note_ctor("S10098C2", this);} // tgen

static void Test_S10098C2()
{
  extern Class_Descriptor cd_S10098C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10098C2, buf);
    S10098C2 *dp, &lv = *(dp=new (buf) S10098C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10098C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C2)");
    test_class_info(&lv, &cd_S10098C2);
    dp->~S10098C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C2(Test_S10098C2, "S10098C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10098C2C1Ev();
extern void _ZN8S10098C2D1Ev();
Name_Map name_map_S10098C2[] = {
  NSPAIR(_ZN8S10098C2C1Ev),
  NSPAIR(_ZN8S10098C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10098C2[];
extern void _ZN8S10098C2D1Ev();
extern void _ZN8S10098C2D0Ev();
extern void _ZN8S10098C22v6Ev();
static  VTBL_ENTRY vtc_S10098C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10098C2[0]),
  (VTBL_ENTRY)&_ZN8S10098C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10098C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10098C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S10098C2[];
extern  VTBL_ENTRY _ZTV8S10098C2[];
Class_Descriptor cd_S10098C2 = {  "S10098C2", // class name
  0,0,//no base classes
  &(vtc_S10098C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10098C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10098C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C3  {
  void *s10098c3f0;
  virtual  ~S10098C3(); // _ZN8S10098C3D1Ev
  virtual void  v7(); // _ZN8S10098C32v7Ev
  virtual void  v8(); // _ZN8S10098C32v8Ev
  virtual void  v9(); // _ZN8S10098C32v9Ev
  virtual void  v10(); // _ZN8S10098C33v10Ev
  virtual void  v11(); // _ZN8S10098C33v11Ev
  S10098C3(); // tgen
};
//SIG(-1 S10098C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10098C3 ::~S10098C3(){ note_dtor("S10098C3", this);}
void  S10098C3 ::v7(){vfunc_called(this, "_ZN8S10098C32v7Ev");}
void  S10098C3 ::v8(){vfunc_called(this, "_ZN8S10098C32v8Ev");}
void  S10098C3 ::v9(){vfunc_called(this, "_ZN8S10098C32v9Ev");}
void  S10098C3 ::v10(){vfunc_called(this, "_ZN8S10098C33v10Ev");}
void  S10098C3 ::v11(){vfunc_called(this, "_ZN8S10098C33v11Ev");}
S10098C3 ::S10098C3(){ note_ctor("S10098C3", this);} // tgen

static void Test_S10098C3()
{
  extern Class_Descriptor cd_S10098C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10098C3, buf);
    S10098C3 *dp, &lv = *(dp=new (buf) S10098C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10098C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C3)");
    check_field_offset(lv, s10098c3f0, ABISELECT(8,4), "S10098C3.s10098c3f0");
    test_class_info(&lv, &cd_S10098C3);
    dp->~S10098C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C3(Test_S10098C3, "S10098C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10098C3C1Ev();
extern void _ZN8S10098C3D1Ev();
Name_Map name_map_S10098C3[] = {
  NSPAIR(_ZN8S10098C3C1Ev),
  NSPAIR(_ZN8S10098C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10098C3[];
extern void _ZN8S10098C3D1Ev();
extern void _ZN8S10098C3D0Ev();
extern void _ZN8S10098C32v7Ev();
extern void _ZN8S10098C32v8Ev();
extern void _ZN8S10098C32v9Ev();
extern void _ZN8S10098C33v10Ev();
extern void _ZN8S10098C33v11Ev();
static  VTBL_ENTRY vtc_S10098C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10098C3[0]),
  (VTBL_ENTRY)&_ZN8S10098C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10098C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10098C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10098C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10098C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10098C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10098C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10098C3[];
extern  VTBL_ENTRY _ZTV8S10098C3[];
Class_Descriptor cd_S10098C3 = {  "S10098C3", // class name
  0,0,//no base classes
  &(vtc_S10098C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10098C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10098C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C4  {
  void *s10098c4f0[4];
  int s10098c4f1;
  void  mf10098c4(); // _ZN8S10098C49mf10098c4Ev
  virtual  ~S10098C4(); // _ZN8S10098C4D1Ev
  S10098C4(); // tgen
};
//SIG(-1 S10098C4) C1{ vd m Fp[4] Fi}


void  S10098C4 ::mf10098c4(){}
 S10098C4 ::~S10098C4(){ note_dtor("S10098C4", this);}
S10098C4 ::S10098C4(){ note_ctor("S10098C4", this);} // tgen

static void Test_S10098C4()
{
  extern Class_Descriptor cd_S10098C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_S10098C4, buf);
    S10098C4 *dp, &lv = *(dp=new (buf) S10098C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S10098C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C4)");
    check_field_offset(lv, s10098c4f0, ABISELECT(8,4), "S10098C4.s10098c4f0");
    check_field_offset(lv, s10098c4f1, ABISELECT(40,20), "S10098C4.s10098c4f1");
    test_class_info(&lv, &cd_S10098C4);
    dp->~S10098C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C4(Test_S10098C4, "S10098C4", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN8S10098C4C1Ev();
extern void _ZN8S10098C4D1Ev();
Name_Map name_map_S10098C4[] = {
  NSPAIR(_ZN8S10098C4C1Ev),
  NSPAIR(_ZN8S10098C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10098C4[];
extern void _ZN8S10098C4D1Ev();
extern void _ZN8S10098C4D0Ev();
static  VTBL_ENTRY vtc_S10098C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10098C4[0]),
  (VTBL_ENTRY)&_ZN8S10098C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10098C4D0Ev,
};
extern VTBL_ENTRY _ZTI8S10098C4[];
extern  VTBL_ENTRY _ZTV8S10098C4[];
Class_Descriptor cd_S10098C4 = {  "S10098C4", // class name
  0,0,//no base classes
  &(vtc_S10098C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI8S10098C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10098C4),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C22  {
  void *s10098c22f0;
  ::S10103C13_nt s10098c22f1;
  ::S10103C16_nt s10098c22f2;
  ::S10103C17 s10098c22f3;
  virtual  ~S10098C22(); // _ZN9S10098C22D1Ev
  virtual void  v20(); // _ZN9S10098C223v20Ev
  virtual void  v21(); // _ZN9S10098C223v21Ev
  virtual void  v22(); // _ZN9S10098C223v22Ev
  virtual void  v23(); // _ZN9S10098C223v23Ev
  virtual void  v24(); // _ZN9S10098C223v24Ev
  virtual void  v25(); // _ZN9S10098C223v25Ev
  virtual void  v26(); // _ZN9S10098C223v26Ev
  virtual void  v27(); // _ZN9S10098C223v27Ev
  virtual void  v28(); // _ZN9S10098C223v28Ev
  virtual void  v29(); // _ZN9S10098C223v29Ev
  virtual void  v30(); // _ZN9S10098C223v30Ev
  virtual void  v31(); // _ZN9S10098C223v31Ev
  virtual void  v32(); // _ZN9S10098C223v32Ev
  virtual void  v33(); // _ZN9S10098C223v33Ev
  virtual void  v34(); // _ZN9S10098C223v34Ev
  virtual void  v35(); // _ZN9S10098C223v35Ev
  virtual void  v36(); // _ZN9S10098C223v36Ev
  virtual void  v37(); // _ZN9S10098C223v37Ev
  virtual void  v38(); // _ZN9S10098C223v38Ev
  virtual void  v39(); // _ZN9S10098C223v39Ev
  virtual void  v40(); // _ZN9S10098C223v40Ev
  virtual void  v41(); // _ZN9S10098C223v41Ev
  virtual void  v42(); // _ZN9S10098C223v42Ev
  virtual void  v43(); // _ZN9S10098C223v43Ev
  S10098C22(); // tgen
};
//SIG(-1 S10098C22) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC6{ m Fc Fi[2] Fp}}


 S10098C22 ::~S10098C22(){ note_dtor("S10098C22", this);}
void  S10098C22 ::v20(){vfunc_called(this, "_ZN9S10098C223v20Ev");}
void  S10098C22 ::v21(){vfunc_called(this, "_ZN9S10098C223v21Ev");}
void  S10098C22 ::v22(){vfunc_called(this, "_ZN9S10098C223v22Ev");}
void  S10098C22 ::v23(){vfunc_called(this, "_ZN9S10098C223v23Ev");}
void  S10098C22 ::v24(){vfunc_called(this, "_ZN9S10098C223v24Ev");}
void  S10098C22 ::v25(){vfunc_called(this, "_ZN9S10098C223v25Ev");}
void  S10098C22 ::v26(){vfunc_called(this, "_ZN9S10098C223v26Ev");}
void  S10098C22 ::v27(){vfunc_called(this, "_ZN9S10098C223v27Ev");}
void  S10098C22 ::v28(){vfunc_called(this, "_ZN9S10098C223v28Ev");}
void  S10098C22 ::v29(){vfunc_called(this, "_ZN9S10098C223v29Ev");}
void  S10098C22 ::v30(){vfunc_called(this, "_ZN9S10098C223v30Ev");}
void  S10098C22 ::v31(){vfunc_called(this, "_ZN9S10098C223v31Ev");}
void  S10098C22 ::v32(){vfunc_called(this, "_ZN9S10098C223v32Ev");}
void  S10098C22 ::v33(){vfunc_called(this, "_ZN9S10098C223v33Ev");}
void  S10098C22 ::v34(){vfunc_called(this, "_ZN9S10098C223v34Ev");}
void  S10098C22 ::v35(){vfunc_called(this, "_ZN9S10098C223v35Ev");}
void  S10098C22 ::v36(){vfunc_called(this, "_ZN9S10098C223v36Ev");}
void  S10098C22 ::v37(){vfunc_called(this, "_ZN9S10098C223v37Ev");}
void  S10098C22 ::v38(){vfunc_called(this, "_ZN9S10098C223v38Ev");}
void  S10098C22 ::v39(){vfunc_called(this, "_ZN9S10098C223v39Ev");}
void  S10098C22 ::v40(){vfunc_called(this, "_ZN9S10098C223v40Ev");}
void  S10098C22 ::v41(){vfunc_called(this, "_ZN9S10098C223v41Ev");}
void  S10098C22 ::v42(){vfunc_called(this, "_ZN9S10098C223v42Ev");}
void  S10098C22 ::v43(){vfunc_called(this, "_ZN9S10098C223v43Ev");}
S10098C22 ::S10098C22(){ note_ctor("S10098C22", this);} // tgen

static void Test_S10098C22()
{
  extern Class_Descriptor cd_S10098C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S10098C22, buf);
    S10098C22 *dp, &lv = *(dp=new (buf) S10098C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S10098C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C22)");
    check_field_offset(lv, s10098c22f0, ABISELECT(8,4), "S10098C22.s10098c22f0");
    check_field_offset(lv, s10098c22f1, ABISELECT(16,8), "S10098C22.s10098c22f1");
    check_field_offset(lv, s10098c22f2, ABISELECT(40,24), "S10098C22.s10098c22f2");
    check_field_offset(lv, s10098c22f3, ABISELECT(96,64), "S10098C22.s10098c22f3");
    test_class_info(&lv, &cd_S10098C22);
    dp->~S10098C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C22(Test_S10098C22, "S10098C22", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN9S10098C22C1Ev();
extern void _ZN9S10098C22D1Ev();
Name_Map name_map_S10098C22[] = {
  NSPAIR(_ZN9S10098C22C1Ev),
  NSPAIR(_ZN9S10098C22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10098C22[];
extern void _ZN9S10098C22D1Ev();
extern void _ZN9S10098C22D0Ev();
extern void _ZN9S10098C223v20Ev();
extern void _ZN9S10098C223v21Ev();
extern void _ZN9S10098C223v22Ev();
extern void _ZN9S10098C223v23Ev();
extern void _ZN9S10098C223v24Ev();
extern void _ZN9S10098C223v25Ev();
extern void _ZN9S10098C223v26Ev();
extern void _ZN9S10098C223v27Ev();
extern void _ZN9S10098C223v28Ev();
extern void _ZN9S10098C223v29Ev();
extern void _ZN9S10098C223v30Ev();
extern void _ZN9S10098C223v31Ev();
extern void _ZN9S10098C223v32Ev();
extern void _ZN9S10098C223v33Ev();
extern void _ZN9S10098C223v34Ev();
extern void _ZN9S10098C223v35Ev();
extern void _ZN9S10098C223v36Ev();
extern void _ZN9S10098C223v37Ev();
extern void _ZN9S10098C223v38Ev();
extern void _ZN9S10098C223v39Ev();
extern void _ZN9S10098C223v40Ev();
extern void _ZN9S10098C223v41Ev();
extern void _ZN9S10098C223v42Ev();
extern void _ZN9S10098C223v43Ev();
static  VTBL_ENTRY vtc_S10098C22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C22[0]),
  (VTBL_ENTRY)&_ZN9S10098C22D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C22D0Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v20Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v21Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v22Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v23Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v24Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v25Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v26Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v27Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v28Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v29Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v30Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v31Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v32Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v33Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v34Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v35Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v36Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v37Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v38Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v39Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v40Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v41Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v42Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v43Ev,
};
extern VTBL_ENTRY _ZTI9S10098C22[];
extern  VTBL_ENTRY _ZTV9S10098C22[];
Class_Descriptor cd_S10098C22 = {  "S10098C22", // class name
  0,0,//no base classes
  &(vtc_S10098C22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI9S10098C22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10098C22),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C21  : S10103C5_nt , S10098C22 {
  virtual  ~S10098C21(); // _ZN9S10098C21D1Ev
  virtual void  v18(); // _ZN9S10098C213v18Ev
  virtual void  v19(); // _ZN9S10098C213v19Ev
  S10098C21(); // tgen
};
//SIG(-1 S10098C21) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2}


 S10098C21 ::~S10098C21(){ note_dtor("S10098C21", this);}
void  S10098C21 ::v18(){vfunc_called(this, "_ZN9S10098C213v18Ev");}
void  S10098C21 ::v19(){vfunc_called(this, "_ZN9S10098C213v19Ev");}
S10098C21 ::S10098C21(){ note_ctor("S10098C21", this);} // tgen

static void Test_S10098C21()
{
  extern Class_Descriptor cd_S10098C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,29)];
    init_test(&cd_S10098C21, buf);
    S10098C21 *dp, &lv = *(dp=new (buf) S10098C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S10098C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C21)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10098C21");
    check_base_class_offset(lv, (S10098C22*), ABISELECT(48,32), "S10098C21");
    test_class_info(&lv, &cd_S10098C21);
    dp->~S10098C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C21(Test_S10098C21, "S10098C21", ABISELECT(168,112));

#else // __cplusplus

extern void _ZN9S10098C21C1Ev();
extern void _ZN9S10098C21D1Ev();
Name_Map name_map_S10098C21[] = {
  NSPAIR(_ZN9S10098C21C1Ev),
  NSPAIR(_ZN9S10098C21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10098C22;
extern VTBL_ENTRY _ZTI9S10098C22[];
extern  VTBL_ENTRY _ZTV9S10098C22[];
static Base_Class bases_S10098C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10098C22,    ABISELECT(48,32), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10098C21[];
extern void _ZN9S10098C21D1Ev();
extern void _ZN9S10098C21D0Ev();
extern void _ZN9S10098C213v18Ev();
extern void _ZN9S10098C213v19Ev();
extern void ABISELECT(_ZThn48_N9S10098C21D1Ev,_ZThn32_N9S10098C21D1Ev)();
extern void ABISELECT(_ZThn48_N9S10098C21D0Ev,_ZThn32_N9S10098C21D0Ev)();
extern void _ZN9S10098C223v20Ev();
extern void _ZN9S10098C223v21Ev();
extern void _ZN9S10098C223v22Ev();
extern void _ZN9S10098C223v23Ev();
extern void _ZN9S10098C223v24Ev();
extern void _ZN9S10098C223v25Ev();
extern void _ZN9S10098C223v26Ev();
extern void _ZN9S10098C223v27Ev();
extern void _ZN9S10098C223v28Ev();
extern void _ZN9S10098C223v29Ev();
extern void _ZN9S10098C223v30Ev();
extern void _ZN9S10098C223v31Ev();
extern void _ZN9S10098C223v32Ev();
extern void _ZN9S10098C223v33Ev();
extern void _ZN9S10098C223v34Ev();
extern void _ZN9S10098C223v35Ev();
extern void _ZN9S10098C223v36Ev();
extern void _ZN9S10098C223v37Ev();
extern void _ZN9S10098C223v38Ev();
extern void _ZN9S10098C223v39Ev();
extern void _ZN9S10098C223v40Ev();
extern void _ZN9S10098C223v41Ev();
extern void _ZN9S10098C223v42Ev();
extern void _ZN9S10098C223v43Ev();
static  VTBL_ENTRY vtc_S10098C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C21[0]),
  (VTBL_ENTRY)&_ZN9S10098C21D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C21D0Ev,
  (VTBL_ENTRY)&_ZN9S10098C213v18Ev,
  (VTBL_ENTRY)&_ZN9S10098C213v19Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10098C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10098C21D1Ev,_ZThn32_N9S10098C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10098C21D0Ev,_ZThn32_N9S10098C21D0Ev),
  (VTBL_ENTRY)&_ZN9S10098C223v20Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v21Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v22Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v23Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v24Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v25Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v26Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v27Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v28Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v29Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v30Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v31Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v32Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v33Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v34Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v35Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v36Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v37Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v38Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v39Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v40Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v41Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v42Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v43Ev,
};
extern VTBL_ENTRY _ZTI9S10098C21[];
extern  VTBL_ENTRY _ZTV9S10098C21[];
Class_Descriptor cd_S10098C21 = {  "S10098C21", // class name
  bases_S10098C21, 2,
  &(vtc_S10098C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,112), // object size
  NSPAIRA(_ZTI9S10098C21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10098C21),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C25  : S10103C5_nt , S10098C22 {
  int s10098c25f0;
  virtual  ~S10098C25(); // _ZN9S10098C25D1Ev
  virtual void  v44(); // _ZN9S10098C253v44Ev
  virtual void  v45(); // _ZN9S10098C253v45Ev
  virtual void  v46(); // _ZN9S10098C253v46Ev
  virtual void  v47(); // _ZN9S10098C253v47Ev
  virtual void  v48(); // _ZN9S10098C253v48Ev
  S10098C25(); // tgen
};
//SIG(-1 S10098C25) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4 v5 Fi}


 S10098C25 ::~S10098C25(){ note_dtor("S10098C25", this);}
void  S10098C25 ::v44(){vfunc_called(this, "_ZN9S10098C253v44Ev");}
void  S10098C25 ::v45(){vfunc_called(this, "_ZN9S10098C253v45Ev");}
void  S10098C25 ::v46(){vfunc_called(this, "_ZN9S10098C253v46Ev");}
void  S10098C25 ::v47(){vfunc_called(this, "_ZN9S10098C253v47Ev");}
void  S10098C25 ::v48(){vfunc_called(this, "_ZN9S10098C253v48Ev");}
S10098C25 ::S10098C25(){ note_ctor("S10098C25", this);} // tgen

static void Test_S10098C25()
{
  extern Class_Descriptor cd_S10098C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,30)];
    init_test(&cd_S10098C25, buf);
    S10098C25 *dp, &lv = *(dp=new (buf) S10098C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,116), "sizeof(S10098C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C25)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10098C25");
    check_base_class_offset(lv, (S10098C22*), ABISELECT(48,32), "S10098C25");
    check_field_offset(lv, s10098c25f0, ABISELECT(168,112), "S10098C25.s10098c25f0");
    test_class_info(&lv, &cd_S10098C25);
    dp->~S10098C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C25(Test_S10098C25, "S10098C25", ABISELECT(176,116));

#else // __cplusplus

extern void _ZN9S10098C25C1Ev();
extern void _ZN9S10098C25D1Ev();
Name_Map name_map_S10098C25[] = {
  NSPAIR(_ZN9S10098C25C1Ev),
  NSPAIR(_ZN9S10098C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10098C22;
extern VTBL_ENTRY _ZTI9S10098C22[];
extern  VTBL_ENTRY _ZTV9S10098C22[];
static Base_Class bases_S10098C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10098C22,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10098C25[];
extern void _ZN9S10098C25D1Ev();
extern void _ZN9S10098C25D0Ev();
extern void _ZN9S10098C253v44Ev();
extern void _ZN9S10098C253v45Ev();
extern void _ZN9S10098C253v46Ev();
extern void _ZN9S10098C253v47Ev();
extern void _ZN9S10098C253v48Ev();
extern void ABISELECT(_ZThn48_N9S10098C25D1Ev,_ZThn32_N9S10098C25D1Ev)();
extern void ABISELECT(_ZThn48_N9S10098C25D0Ev,_ZThn32_N9S10098C25D0Ev)();
extern void _ZN9S10098C223v20Ev();
extern void _ZN9S10098C223v21Ev();
extern void _ZN9S10098C223v22Ev();
extern void _ZN9S10098C223v23Ev();
extern void _ZN9S10098C223v24Ev();
extern void _ZN9S10098C223v25Ev();
extern void _ZN9S10098C223v26Ev();
extern void _ZN9S10098C223v27Ev();
extern void _ZN9S10098C223v28Ev();
extern void _ZN9S10098C223v29Ev();
extern void _ZN9S10098C223v30Ev();
extern void _ZN9S10098C223v31Ev();
extern void _ZN9S10098C223v32Ev();
extern void _ZN9S10098C223v33Ev();
extern void _ZN9S10098C223v34Ev();
extern void _ZN9S10098C223v35Ev();
extern void _ZN9S10098C223v36Ev();
extern void _ZN9S10098C223v37Ev();
extern void _ZN9S10098C223v38Ev();
extern void _ZN9S10098C223v39Ev();
extern void _ZN9S10098C223v40Ev();
extern void _ZN9S10098C223v41Ev();
extern void _ZN9S10098C223v42Ev();
extern void _ZN9S10098C223v43Ev();
static  VTBL_ENTRY vtc_S10098C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C25[0]),
  (VTBL_ENTRY)&_ZN9S10098C25D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C25D0Ev,
  (VTBL_ENTRY)&_ZN9S10098C253v44Ev,
  (VTBL_ENTRY)&_ZN9S10098C253v45Ev,
  (VTBL_ENTRY)&_ZN9S10098C253v46Ev,
  (VTBL_ENTRY)&_ZN9S10098C253v47Ev,
  (VTBL_ENTRY)&_ZN9S10098C253v48Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10098C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10098C25D1Ev,_ZThn32_N9S10098C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10098C25D0Ev,_ZThn32_N9S10098C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10098C223v20Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v21Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v22Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v23Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v24Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v25Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v26Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v27Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v28Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v29Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v30Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v31Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v32Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v33Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v34Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v35Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v36Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v37Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v38Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v39Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v40Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v41Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v42Ev,
  (VTBL_ENTRY)&_ZN9S10098C223v43Ev,
};
extern VTBL_ENTRY _ZTI9S10098C25[];
extern  VTBL_ENTRY _ZTV9S10098C25[];
Class_Descriptor cd_S10098C25 = {  "S10098C25", // class name
  bases_S10098C25, 2,
  &(vtc_S10098C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,116), // object size
  NSPAIRA(_ZTI9S10098C25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10098C25),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C6  : S10103C5_nt {
  ::S10103C42 s10098c6f0;
  void *s10098c6f1;
  char s10098c6f2;
  int s10098c6f3;
  virtual  ~S10098C6(); // _ZN8S10098C6D1Ev
  virtual void  v13(); // _ZN8S10098C63v13Ev
  virtual void  v14(); // _ZN8S10098C63v14Ev
  virtual void  v15(); // _ZN8S10098C63v15Ev
  virtual void  v16(); // _ZN8S10098C63v16Ev
  S10098C6(); // tgen
};
//SIG(-1 S10098C6) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd v1 v2 v3 v4 FC5{ m Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC7 FC7 Fi} Fp Fc Fi}


 S10098C6 ::~S10098C6(){ note_dtor("S10098C6", this);}
void  S10098C6 ::v13(){vfunc_called(this, "_ZN8S10098C63v13Ev");}
void  S10098C6 ::v14(){vfunc_called(this, "_ZN8S10098C63v14Ev");}
void  S10098C6 ::v15(){vfunc_called(this, "_ZN8S10098C63v15Ev");}
void  S10098C6 ::v16(){vfunc_called(this, "_ZN8S10098C63v16Ev");}
S10098C6 ::S10098C6(){ note_ctor("S10098C6", this);} // tgen

static void Test_S10098C6()
{
  extern Class_Descriptor cd_S10098C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10098C6, buf);
    S10098C6 *dp, &lv = *(dp=new (buf) S10098C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10098C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C6)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10098C6");
    check_field_offset(lv, s10098c6f0, ABISELECT(48,32), "S10098C6.s10098c6f0");
    check_field_offset(lv, s10098c6f1, ABISELECT(120,80), "S10098C6.s10098c6f1");
    check_field_offset(lv, s10098c6f2, ABISELECT(128,84), "S10098C6.s10098c6f2");
    check_field_offset(lv, s10098c6f3, ABISELECT(132,88), "S10098C6.s10098c6f3");
    test_class_info(&lv, &cd_S10098C6);
    dp->~S10098C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C6(Test_S10098C6, "S10098C6", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN8S10098C6C1Ev();
extern void _ZN8S10098C6D1Ev();
Name_Map name_map_S10098C6[] = {
  NSPAIR(_ZN8S10098C6C1Ev),
  NSPAIR(_ZN8S10098C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10098C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10098C6[];
extern void _ZN8S10098C6D1Ev();
extern void _ZN8S10098C6D0Ev();
extern void _ZN8S10098C63v13Ev();
extern void _ZN8S10098C63v14Ev();
extern void _ZN8S10098C63v15Ev();
extern void _ZN8S10098C63v16Ev();
static  VTBL_ENTRY vtc_S10098C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10098C6[0]),
  (VTBL_ENTRY)&_ZN8S10098C6D1Ev,
  (VTBL_ENTRY)&_ZN8S10098C6D0Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v13Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v14Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v15Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v16Ev,
};
extern VTBL_ENTRY _ZTI8S10098C6[];
extern  VTBL_ENTRY _ZTV8S10098C6[];
Class_Descriptor cd_S10098C6 = {  "S10098C6", // class name
  bases_S10098C6, 1,
  &(vtc_S10098C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI8S10098C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S10098C6),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C27  : S10098C6 {
  virtual void  v51(); // _ZN9S10098C273v51Ev
  ~S10098C27(); // tgen
  S10098C27(); // tgen
};
//SIG(-1 S10098C27) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v2 v3 v4 v5 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1}


void  S10098C27 ::v51(){vfunc_called(this, "_ZN9S10098C273v51Ev");}
S10098C27 ::~S10098C27(){ note_dtor("S10098C27", this);} // tgen
S10098C27 ::S10098C27(){ note_ctor("S10098C27", this);} // tgen

static void Test_S10098C27()
{
  extern Class_Descriptor cd_S10098C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10098C27, buf);
    S10098C27 *dp, &lv = *(dp=new (buf) S10098C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10098C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C27)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10098C6*), 0, "S10098C27");
    check_base_class_offset(lv, (S10098C6*), 0, "S10098C27");
    test_class_info(&lv, &cd_S10098C27);
    dp->~S10098C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C27(Test_S10098C27, "S10098C27", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN9S10098C27C1Ev();
extern void _ZN9S10098C27D1Ev();
Name_Map name_map_S10098C27[] = {
  NSPAIR(_ZN9S10098C27C1Ev),
  NSPAIR(_ZN9S10098C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10098C6;
extern VTBL_ENTRY _ZTI8S10098C6[];
extern  VTBL_ENTRY _ZTV8S10098C6[];
static Base_Class bases_S10098C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10098C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10098C27[];
extern void _ZN9S10098C27D1Ev();
extern void _ZN9S10098C27D0Ev();
extern void _ZN8S10098C63v13Ev();
extern void _ZN8S10098C63v14Ev();
extern void _ZN8S10098C63v15Ev();
extern void _ZN8S10098C63v16Ev();
extern void _ZN9S10098C273v51Ev();
static  VTBL_ENTRY vtc_S10098C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C27[0]),
  (VTBL_ENTRY)&_ZN9S10098C27D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C27D0Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v13Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v14Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v15Ev,
  (VTBL_ENTRY)&_ZN8S10098C63v16Ev,
  (VTBL_ENTRY)&_ZN9S10098C273v51Ev,
};
extern VTBL_ENTRY _ZTI9S10098C27[];
extern  VTBL_ENTRY _ZTV9S10098C27[];
Class_Descriptor cd_S10098C27 = {  "S10098C27", // class name
  bases_S10098C27, 2,
  &(vtc_S10098C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI9S10098C27),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10098C27),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C33_nt  {
  int s10098c33f0;
  void  mf10098c33(); // _ZN12S10098C33_nt10mf10098c33Ev
  virtual  ~S10098C33_nt(); // _ZN12S10098C33_ntD1Ev
  S10098C33_nt(); // tgen
};
//SIG(-1 S10098C33_nt) C1{ vd m Fi}


void  S10098C33_nt ::mf10098c33(){}
 S10098C33_nt ::~S10098C33_nt(){ note_dtor("S10098C33_nt", this);}
S10098C33_nt ::S10098C33_nt(){ note_ctor("S10098C33_nt", this);} // tgen

//skip512 S10098C33_nt

#else // __cplusplus

extern void _ZN12S10098C33_ntC1Ev();
extern void _ZN12S10098C33_ntD1Ev();
Name_Map name_map_S10098C33_nt[] = {
  NSPAIR(_ZN12S10098C33_ntC1Ev),
  NSPAIR(_ZN12S10098C33_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S10098C33_nt[];
extern void _ZN12S10098C33_ntD1Ev();
extern void _ZN12S10098C33_ntD0Ev();
static  VTBL_ENTRY vtc_S10098C33_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10098C33_nt[0]),
  (VTBL_ENTRY)&_ZN12S10098C33_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10098C33_ntD0Ev,
};
extern VTBL_ENTRY _ZTI12S10098C33_nt[];
VTBL_ENTRY *P__ZTI12S10098C33_nt = _ZTI12S10098C33_nt; 
extern  VTBL_ENTRY _ZTV12S10098C33_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C32  {
  ::S10098C33_nt s10098c32f0;
  void  mf10098c32(); // _ZN9S10098C3210mf10098c32Ev
  virtual  ~S10098C32(); // _ZN9S10098C32D1Ev
  S10098C32(); // tgen
};
//SIG(-1 S10098C32) C1{ vd m FC2{ vd m Fi}}


void  S10098C32 ::mf10098c32(){}
 S10098C32 ::~S10098C32(){ note_dtor("S10098C32", this);}
S10098C32 ::S10098C32(){ note_ctor("S10098C32", this);} // tgen

static void Test_S10098C32()
{
  extern Class_Descriptor cd_S10098C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S10098C32, buf);
    S10098C32 *dp, &lv = *(dp=new (buf) S10098C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S10098C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C32)");
    check_field_offset(lv, s10098c32f0, ABISELECT(8,4), "S10098C32.s10098c32f0");
    test_class_info(&lv, &cd_S10098C32);
    dp->~S10098C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C32(Test_S10098C32, "S10098C32", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S10098C32C1Ev();
extern void _ZN9S10098C32D1Ev();
Name_Map name_map_S10098C32[] = {
  NSPAIR(_ZN9S10098C32C1Ev),
  NSPAIR(_ZN9S10098C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10098C32[];
extern void _ZN9S10098C32D1Ev();
extern void _ZN9S10098C32D0Ev();
static  VTBL_ENTRY vtc_S10098C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C32[0]),
  (VTBL_ENTRY)&_ZN9S10098C32D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C32D0Ev,
};
extern VTBL_ENTRY _ZTI9S10098C32[];
extern  VTBL_ENTRY _ZTV9S10098C32[];
Class_Descriptor cd_S10098C32 = {  "S10098C32", // class name
  0,0,//no base classes
  &(vtc_S10098C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S10098C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10098C32),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C31  : S10103C5_nt {
  ::S10098C32 s10098c31f0;
  virtual  ~S10098C31(); // _ZN9S10098C31D1Ev
  S10098C31(); // tgen
};
//SIG(-1 S10098C31) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd FC5{ vd m FC6{ vd m Fi}}}


 S10098C31 ::~S10098C31(){ note_dtor("S10098C31", this);}
S10098C31 ::S10098C31(){ note_ctor("S10098C31", this);} // tgen

static void Test_S10098C31()
{
  extern Class_Descriptor cd_S10098C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_S10098C31, buf);
    S10098C31 *dp, &lv = *(dp=new (buf) S10098C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(S10098C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C31)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10098C31");
    check_field_offset(lv, s10098c31f0, ABISELECT(48,32), "S10098C31.s10098c31f0");
    test_class_info(&lv, &cd_S10098C31);
    dp->~S10098C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C31(Test_S10098C31, "S10098C31", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN9S10098C31C1Ev();
extern void _ZN9S10098C31D1Ev();
Name_Map name_map_S10098C31[] = {
  NSPAIR(_ZN9S10098C31C1Ev),
  NSPAIR(_ZN9S10098C31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10098C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10098C31[];
extern void _ZN9S10098C31D1Ev();
extern void _ZN9S10098C31D0Ev();
static  VTBL_ENTRY vtc_S10098C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C31[0]),
  (VTBL_ENTRY)&_ZN9S10098C31D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C31D0Ev,
};
extern VTBL_ENTRY _ZTI9S10098C31[];
extern  VTBL_ENTRY _ZTV9S10098C31[];
Class_Descriptor cd_S10098C31 = {  "S10098C31", // class name
  bases_S10098C31, 1,
  &(vtc_S10098C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI9S10098C31),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10098C31),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C35  {
  ::S10103C106 s10098c35f0;
  ::S10103C106 s10098c35f1;
  void  mf10098c35(); // _ZN9S10098C3510mf10098c35Ev
  virtual  ~S10098C35(); // _ZN9S10098C35D1Ev
  S10098C35(); // tgen
};
//SIG(-1 S10098C35) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}} FC2}


void  S10098C35 ::mf10098c35(){}
 S10098C35 ::~S10098C35(){ note_dtor("S10098C35", this);}
S10098C35 ::S10098C35(){ note_ctor("S10098C35", this);} // tgen

static void Test_S10098C35()
{
  extern Class_Descriptor cd_S10098C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S10098C35, buf);
    S10098C35 *dp, &lv = *(dp=new (buf) S10098C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S10098C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C35)");
    check_field_offset(lv, s10098c35f0, ABISELECT(8,4), "S10098C35.s10098c35f0");
    check_field_offset(lv, s10098c35f1, ABISELECT(32,20), "S10098C35.s10098c35f1");
    test_class_info(&lv, &cd_S10098C35);
    dp->~S10098C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C35(Test_S10098C35, "S10098C35", ABISELECT(56,36));

#else // __cplusplus

extern void _ZN9S10098C35C1Ev();
extern void _ZN9S10098C35D1Ev();
Name_Map name_map_S10098C35[] = {
  NSPAIR(_ZN9S10098C35C1Ev),
  NSPAIR(_ZN9S10098C35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10098C35[];
extern void _ZN9S10098C35D1Ev();
extern void _ZN9S10098C35D0Ev();
static  VTBL_ENTRY vtc_S10098C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C35[0]),
  (VTBL_ENTRY)&_ZN9S10098C35D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C35D0Ev,
};
extern VTBL_ENTRY _ZTI9S10098C35[];
extern  VTBL_ENTRY _ZTV9S10098C35[];
Class_Descriptor cd_S10098C35 = {  "S10098C35", // class name
  0,0,//no base classes
  &(vtc_S10098C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,36), // object size
  NSPAIRA(_ZTI9S10098C35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10098C35),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C34  : S10098C35 {
  virtual  ~S10098C34(); // _ZN9S10098C34D1Ev
  S10098C34(); // tgen
};
//SIG(-1 S10098C34) C1{ BC2{ vd m FC3{ m Fp Fi[2] FC4{ m}} FC3} vd}


 S10098C34 ::~S10098C34(){ note_dtor("S10098C34", this);}
S10098C34 ::S10098C34(){ note_ctor("S10098C34", this);} // tgen

static void Test_S10098C34()
{
  extern Class_Descriptor cd_S10098C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S10098C34, buf);
    S10098C34 *dp, &lv = *(dp=new (buf) S10098C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S10098C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C34)");
    check_base_class_offset(lv, (S10098C35*), 0, "S10098C34");
    test_class_info(&lv, &cd_S10098C34);
    dp->~S10098C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C34(Test_S10098C34, "S10098C34", ABISELECT(56,36));

#else // __cplusplus

extern void _ZN9S10098C34C1Ev();
extern void _ZN9S10098C34D1Ev();
Name_Map name_map_S10098C34[] = {
  NSPAIR(_ZN9S10098C34C1Ev),
  NSPAIR(_ZN9S10098C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10098C35;
extern VTBL_ENTRY _ZTI9S10098C35[];
extern  VTBL_ENTRY _ZTV9S10098C35[];
static Base_Class bases_S10098C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10098C35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10098C34[];
extern void _ZN9S10098C34D1Ev();
extern void _ZN9S10098C34D0Ev();
static  VTBL_ENTRY vtc_S10098C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C34[0]),
  (VTBL_ENTRY)&_ZN9S10098C34D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C34D0Ev,
};
extern VTBL_ENTRY _ZTI9S10098C34[];
extern  VTBL_ENTRY _ZTV9S10098C34[];
Class_Descriptor cd_S10098C34 = {  "S10098C34", // class name
  bases_S10098C34, 1,
  &(vtc_S10098C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,36), // object size
  NSPAIRA(_ZTI9S10098C34),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10098C34),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C39  {
  char s10098c39f0;
  int s10098c39f1[3];
  __tsi64 s10098c39f2[6];
  char s10098c39f3[672];
};
//SIG(-1 S10098C39) C1{ Fc Fi[3] FL[6] Fc[672]}



static void Test_S10098C39()
{
  {
    init_simple_test("S10098C39");
    S10098C39 lv;
    check2(sizeof(lv), 736, "sizeof(S10098C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C39)");
    check_field_offset(lv, s10098c39f0, 0, "S10098C39.s10098c39f0");
    check_field_offset(lv, s10098c39f1, 4, "S10098C39.s10098c39f1");
    check_field_offset(lv, s10098c39f2, 16, "S10098C39.s10098c39f2");
    check_field_offset(lv, s10098c39f3, 64, "S10098C39.s10098c39f3");
  }
}
static Arrange_To_Call_Me vS10098C39(Test_S10098C39, "S10098C39", 736);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C38  {
  ::S10103C14_nt s10098c38f0;
  ::S10103C14_nt s10098c38f1;
  __tsi64 s10098c38f2;
  ::S10103C14_nt s10098c38f3;
  ::S10103C14_nt s10098c38f4;
  ::S10103C14_nt s10098c38f5;
  ::S10098C39 s10098c38f6;
  void  mf10098c38(); // _ZN9S10098C3810mf10098c38Ev
  virtual  ~S10098C38(); // _ZN9S10098C38D1Ev
  S10098C38(); // tgen
};
//SIG(-1 S10098C38) C1{ vd m FC2{ m Fp Fi FC3{ m}} FC2 FL FC2 FC2 FC2 FC4{ Fc Fi[3] FL[6] Fc[672]}}


void  S10098C38 ::mf10098c38(){}
 S10098C38 ::~S10098C38(){ note_dtor("S10098C38", this);}
S10098C38 ::S10098C38(){ note_ctor("S10098C38", this);} // tgen

static void Test_S10098C38()
{
  extern Class_Descriptor cd_S10098C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,203)];
    init_test(&cd_S10098C38, buf);
    S10098C38 *dp, &lv = *(dp=new (buf) S10098C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,808), "sizeof(S10098C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C38)");
    check_field_offset(lv, s10098c38f0, ABISELECT(8,4), "S10098C38.s10098c38f0");
    check_field_offset(lv, s10098c38f1, ABISELECT(24,16), "S10098C38.s10098c38f1");
    check_field_offset(lv, s10098c38f2, ABISELECT(40,28), "S10098C38.s10098c38f2");
    check_field_offset(lv, s10098c38f3, ABISELECT(48,36), "S10098C38.s10098c38f3");
    check_field_offset(lv, s10098c38f4, ABISELECT(64,48), "S10098C38.s10098c38f4");
    check_field_offset(lv, s10098c38f5, ABISELECT(80,60), "S10098C38.s10098c38f5");
    check_field_offset(lv, s10098c38f6, ABISELECT(96,72), "S10098C38.s10098c38f6");
    test_class_info(&lv, &cd_S10098C38);
    dp->~S10098C38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C38(Test_S10098C38, "S10098C38", ABISELECT(832,808));

#else // __cplusplus

extern void _ZN9S10098C38C1Ev();
extern void _ZN9S10098C38D1Ev();
Name_Map name_map_S10098C38[] = {
  NSPAIR(_ZN9S10098C38C1Ev),
  NSPAIR(_ZN9S10098C38D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10098C38[];
extern void _ZN9S10098C38D1Ev();
extern void _ZN9S10098C38D0Ev();
static  VTBL_ENTRY vtc_S10098C38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10098C38[0]),
  (VTBL_ENTRY)&_ZN9S10098C38D1Ev,
  (VTBL_ENTRY)&_ZN9S10098C38D0Ev,
};
extern VTBL_ENTRY _ZTI9S10098C38[];
extern  VTBL_ENTRY _ZTV9S10098C38[];
Class_Descriptor cd_S10098C38 = {  "S10098C38", // class name
  0,0,//no base classes
  &(vtc_S10098C38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,808), // object size
  NSPAIRA(_ZTI9S10098C38),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10098C38),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C18_nt  {
  void *s10098c18f0;
  int s10098c18f1;
  ::S10103C88 s10098c18f2;
  void  mf10098c18(); // _ZN12S10098C18_nt10mf10098c18Ev
};
//SIG(-1 S10098C18_nt) C1{ m Fp Fi FC2{ m}}


void  S10098C18_nt ::mf10098c18(){}

//skip512 S10098C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10098C1  : S10098C2 , S10098C3 , S10098C4 {
  ::S10103C56 s10098c1f0;
  ::S10103C47 s10098c1f1;
  ::S10098C21 s10098c1f2;
  ::S10098C25 s10098c1f3;
  ::S10103C49 s10098c1f4;
  ::S10098C27 s10098c1f5;
  ::S10098C27 s10098c1f6;
  ::S10098C27 s10098c1f7;
  ::S10103C40 s10098c1f8;
  ::S10102C49 s10098c1f9;
  ::S10098C31 s10098c1f10;
  ::S10098C34 s10098c1f11;
  ::S10098C38 s10098c1f12;
  ::S10098C18_nt s10098c1f13;
  int s10098c1f14;
  virtual  ~S10098C1(); // _ZN8S10098C1D1Ev
  virtual void  v1(); // _ZN8S10098C12v1Ev
  virtual void  v2(); // _ZN8S10098C12v2Ev
  virtual void  v3(); // _ZN8S10098C12v3Ev
  virtual void  v4(); // _ZN8S10098C12v4Ev
  virtual void  v5(); // _ZN8S10098C12v5Ev
  S10098C1(); // tgen
};
//SIG(1 S10098C1) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} BC4{ vd m Fp[4] Fi} vd v1 v2 v3 v4 v5 FC5{ BC6{ BC7{ vd m FC8{ m Fp Fi FC9{ m} FC9} FC8 Fc} vd v13 v14 v15 v16 FC10{ m Fp FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} FC12 FC12 Fi} Fp Fc Fi} v12} FC14{ BC6 v17} FC15{ BC7 BC16{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 Fp FC11 FC17{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC18{ m Fc Fi[2] Fp}} vd v18 v19} FC19{ BC7 BC16 vd v44 v45 v46 v47 v48 Fi} FC20{ BC6 v49 v50} FC21{ BC22{ BC7 vd v52 v53 v54 v55 FC10 Fp Fc Fi} v51} FC21 FC21 FC23{ BC6 v56 v57} FC24{ BC25{ BC7 vd v60 v61 v62 v63 FC10 Fp Fc Fi} v58 v59} FC26{ BC7 vd FC27{ vd m FC28{ vd m Fi}}} FC29{ BC30{ vd m FC31{ m Fp Fi[2] FC32{ m}} FC31} vd} FC33{ vd m FC12 FC12 FL FC12 FC12 FC12 FC34{ Fc Fi[3] FL[6] Fc[672]}} FC35{ m Fp Fi FC32} Fi}


 S10098C1 ::~S10098C1(){ note_dtor("S10098C1", this);}
void  S10098C1 ::v1(){vfunc_called(this, "_ZN8S10098C12v1Ev");}
void  S10098C1 ::v2(){vfunc_called(this, "_ZN8S10098C12v2Ev");}
void  S10098C1 ::v3(){vfunc_called(this, "_ZN8S10098C12v3Ev");}
void  S10098C1 ::v4(){vfunc_called(this, "_ZN8S10098C12v4Ev");}
void  S10098C1 ::v5(){vfunc_called(this, "_ZN8S10098C12v5Ev");}
S10098C1 ::S10098C1(){ note_ctor("S10098C1", this);} // tgen

static void Test_S10098C1()
{
  extern Class_Descriptor cd_S10098C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(312,477)];
    init_test(&cd_S10098C1, buf);
    S10098C1 *dp, &lv = *(dp=new (buf) S10098C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2488,1904), "sizeof(S10098C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10098C1)");
    check_base_class_offset(lv, (S10098C2*), 0, "S10098C1");
    check_base_class_offset(lv, (S10098C3*), ABISELECT(8,4), "S10098C1");
    check_base_class_offset(lv, (S10098C4*), ABISELECT(24,12), "S10098C1");
    check_field_offset(lv, s10098c1f0, ABISELECT(72,36), "S10098C1.s10098c1f0");
    check_field_offset(lv, s10098c1f1, ABISELECT(208,128), "S10098C1.s10098c1f1");
    check_field_offset(lv, s10098c1f2, ABISELECT(344,220), "S10098C1.s10098c1f2");
    check_field_offset(lv, s10098c1f3, ABISELECT(512,332), "S10098C1.s10098c1f3");
    check_field_offset(lv, s10098c1f4, ABISELECT(688,448), "S10098C1.s10098c1f4");
    check_field_offset(lv, s10098c1f5, ABISELECT(824,540), "S10098C1.s10098c1f5");
    check_field_offset(lv, s10098c1f6, ABISELECT(960,632), "S10098C1.s10098c1f6");
    check_field_offset(lv, s10098c1f7, ABISELECT(1096,724), "S10098C1.s10098c1f7");
    check_field_offset(lv, s10098c1f8, ABISELECT(1232,816), "S10098C1.s10098c1f8");
    check_field_offset(lv, s10098c1f9, ABISELECT(1368,908), "S10098C1.s10098c1f9");
    check_field_offset(lv, s10098c1f10, ABISELECT(1504,1000), "S10098C1.s10098c1f10");
    check_field_offset(lv, s10098c1f11, ABISELECT(1576,1044), "S10098C1.s10098c1f11");
    check_field_offset(lv, s10098c1f12, ABISELECT(1632,1080), "S10098C1.s10098c1f12");
    check_field_offset(lv, s10098c1f13, ABISELECT(2464,1888), "S10098C1.s10098c1f13");
    check_field_offset(lv, s10098c1f14, ABISELECT(2480,1900), "S10098C1.s10098c1f14");
    test_class_info(&lv, &cd_S10098C1);
    dp->~S10098C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10098C1(Test_S10098C1, "S10098C1", ABISELECT(2488,1904));

#else // __cplusplus

extern void _ZN8S10098C1C1Ev();
extern void _ZN8S10098C1D1Ev();
Name_Map name_map_S10098C1[] = {
  NSPAIR(_ZN8S10098C1C1Ev),
  NSPAIR(_ZN8S10098C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10098C2;
extern VTBL_ENTRY _ZTI8S10098C2[];
extern  VTBL_ENTRY _ZTV8S10098C2[];
extern Class_Descriptor cd_S10098C3;
extern VTBL_ENTRY _ZTI8S10098C3[];
extern  VTBL_ENTRY _ZTV8S10098C3[];
extern Class_Descriptor cd_S10098C4;
extern VTBL_ENTRY _ZTI8S10098C4[];
extern  VTBL_ENTRY _ZTV8S10098C4[];
static Base_Class bases_S10098C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10098C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10098C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10098C4,    ABISELECT(24,12), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10098C1[];
extern void _ZN8S10098C1D1Ev();
extern void _ZN8S10098C1D0Ev();
extern void _ZN8S10098C22v6Ev();
extern void _ZN8S10098C12v1Ev();
extern void _ZN8S10098C12v2Ev();
extern void _ZN8S10098C12v3Ev();
extern void _ZN8S10098C12v4Ev();
extern void _ZN8S10098C12v5Ev();
extern void ABISELECT(_ZThn8_N8S10098C1D1Ev,_ZThn4_N8S10098C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10098C1D0Ev,_ZThn4_N8S10098C1D0Ev)();
extern void _ZN8S10098C32v7Ev();
extern void _ZN8S10098C32v8Ev();
extern void _ZN8S10098C32v9Ev();
extern void _ZN8S10098C33v10Ev();
extern void _ZN8S10098C33v11Ev();
extern void ABISELECT(_ZThn24_N8S10098C1D1Ev,_ZThn12_N8S10098C1D1Ev)();
extern void ABISELECT(_ZThn24_N8S10098C1D0Ev,_ZThn12_N8S10098C1D0Ev)();
static  VTBL_ENTRY vtc_S10098C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10098C1[0]),
  (VTBL_ENTRY)&_ZN8S10098C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10098C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10098C22v6Ev,
  (VTBL_ENTRY)&_ZN8S10098C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10098C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10098C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10098C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10098C12v5Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10098C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10098C1D1Ev,_ZThn4_N8S10098C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10098C1D0Ev,_ZThn4_N8S10098C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10098C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10098C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10098C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10098C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10098C33v11Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S10098C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10098C1D1Ev,_ZThn12_N8S10098C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10098C1D0Ev,_ZThn12_N8S10098C1D0Ev),
};
extern VTBL_ENTRY _ZTI8S10098C1[];
extern  VTBL_ENTRY _ZTV8S10098C1[];
Class_Descriptor cd_S10098C1 = {  "S10098C1", // class name
  bases_S10098C1, 3,
  &(vtc_S10098C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2488,1904), // object size
  NSPAIRA(_ZTI8S10098C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S10098C1),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C2  {
  virtual  ~S10097C2(); // _ZN8S10097C2D1Ev
  virtual void  v6(); // _ZN8S10097C22v6Ev
  S10097C2(); // tgen
};
//SIG(-1 S10097C2) C1{ vd v1}


 S10097C2 ::~S10097C2(){ note_dtor("S10097C2", this);}
void  S10097C2 ::v6(){vfunc_called(this, "_ZN8S10097C22v6Ev");}
S10097C2 ::S10097C2(){ note_ctor("S10097C2", this);} // tgen

static void Test_S10097C2()
{
  extern Class_Descriptor cd_S10097C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10097C2, buf);
    S10097C2 *dp, &lv = *(dp=new (buf) S10097C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10097C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C2)");
    test_class_info(&lv, &cd_S10097C2);
    dp->~S10097C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C2(Test_S10097C2, "S10097C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10097C2C1Ev();
extern void _ZN8S10097C2D1Ev();
Name_Map name_map_S10097C2[] = {
  NSPAIR(_ZN8S10097C2C1Ev),
  NSPAIR(_ZN8S10097C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10097C2[];
extern void _ZN8S10097C2D1Ev();
extern void _ZN8S10097C2D0Ev();
extern void _ZN8S10097C22v6Ev();
static  VTBL_ENTRY vtc_S10097C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10097C2[0]),
  (VTBL_ENTRY)&_ZN8S10097C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10097C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10097C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S10097C2[];
extern  VTBL_ENTRY _ZTV8S10097C2[];
Class_Descriptor cd_S10097C2 = {  "S10097C2", // class name
  0,0,//no base classes
  &(vtc_S10097C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10097C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10097C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C3  {
  void *s10097c3f0;
  virtual  ~S10097C3(); // _ZN8S10097C3D1Ev
  virtual void  v7(); // _ZN8S10097C32v7Ev
  virtual void  v8(); // _ZN8S10097C32v8Ev
  virtual void  v9(); // _ZN8S10097C32v9Ev
  virtual void  v10(); // _ZN8S10097C33v10Ev
  virtual void  v11(); // _ZN8S10097C33v11Ev
  S10097C3(); // tgen
};
//SIG(-1 S10097C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10097C3 ::~S10097C3(){ note_dtor("S10097C3", this);}
void  S10097C3 ::v7(){vfunc_called(this, "_ZN8S10097C32v7Ev");}
void  S10097C3 ::v8(){vfunc_called(this, "_ZN8S10097C32v8Ev");}
void  S10097C3 ::v9(){vfunc_called(this, "_ZN8S10097C32v9Ev");}
void  S10097C3 ::v10(){vfunc_called(this, "_ZN8S10097C33v10Ev");}
void  S10097C3 ::v11(){vfunc_called(this, "_ZN8S10097C33v11Ev");}
S10097C3 ::S10097C3(){ note_ctor("S10097C3", this);} // tgen

static void Test_S10097C3()
{
  extern Class_Descriptor cd_S10097C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10097C3, buf);
    S10097C3 *dp, &lv = *(dp=new (buf) S10097C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10097C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C3)");
    check_field_offset(lv, s10097c3f0, ABISELECT(8,4), "S10097C3.s10097c3f0");
    test_class_info(&lv, &cd_S10097C3);
    dp->~S10097C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C3(Test_S10097C3, "S10097C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10097C3C1Ev();
extern void _ZN8S10097C3D1Ev();
Name_Map name_map_S10097C3[] = {
  NSPAIR(_ZN8S10097C3C1Ev),
  NSPAIR(_ZN8S10097C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10097C3[];
extern void _ZN8S10097C3D1Ev();
extern void _ZN8S10097C3D0Ev();
extern void _ZN8S10097C32v7Ev();
extern void _ZN8S10097C32v8Ev();
extern void _ZN8S10097C32v9Ev();
extern void _ZN8S10097C33v10Ev();
extern void _ZN8S10097C33v11Ev();
static  VTBL_ENTRY vtc_S10097C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10097C3[0]),
  (VTBL_ENTRY)&_ZN8S10097C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10097C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10097C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10097C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10097C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10097C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10097C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10097C3[];
extern  VTBL_ENTRY _ZTV8S10097C3[];
Class_Descriptor cd_S10097C3 = {  "S10097C3", // class name
  0,0,//no base classes
  &(vtc_S10097C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10097C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10097C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C6  : S10103C5_nt {
  ::S10103C42 s10097c6f0;
  void *s10097c6f1;
  char s10097c6f2;
  int s10097c6f3;
  virtual  ~S10097C6(); // _ZN8S10097C6D1Ev
  virtual void  v13(); // _ZN8S10097C63v13Ev
  virtual void  v14(); // _ZN8S10097C63v14Ev
  virtual void  v15(); // _ZN8S10097C63v15Ev
  virtual void  v16(); // _ZN8S10097C63v16Ev
  S10097C6(); // tgen
};
//SIG(-1 S10097C6) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} vd v1 v2 v3 v4 FC5{ m Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC7 FC7 Fi} Fp Fc Fi}


 S10097C6 ::~S10097C6(){ note_dtor("S10097C6", this);}
void  S10097C6 ::v13(){vfunc_called(this, "_ZN8S10097C63v13Ev");}
void  S10097C6 ::v14(){vfunc_called(this, "_ZN8S10097C63v14Ev");}
void  S10097C6 ::v15(){vfunc_called(this, "_ZN8S10097C63v15Ev");}
void  S10097C6 ::v16(){vfunc_called(this, "_ZN8S10097C63v16Ev");}
S10097C6 ::S10097C6(){ note_ctor("S10097C6", this);} // tgen

static void Test_S10097C6()
{
  extern Class_Descriptor cd_S10097C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10097C6, buf);
    S10097C6 *dp, &lv = *(dp=new (buf) S10097C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10097C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C6)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10097C6");
    check_field_offset(lv, s10097c6f0, ABISELECT(48,32), "S10097C6.s10097c6f0");
    check_field_offset(lv, s10097c6f1, ABISELECT(120,80), "S10097C6.s10097c6f1");
    check_field_offset(lv, s10097c6f2, ABISELECT(128,84), "S10097C6.s10097c6f2");
    check_field_offset(lv, s10097c6f3, ABISELECT(132,88), "S10097C6.s10097c6f3");
    test_class_info(&lv, &cd_S10097C6);
    dp->~S10097C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C6(Test_S10097C6, "S10097C6", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN8S10097C6C1Ev();
extern void _ZN8S10097C6D1Ev();
Name_Map name_map_S10097C6[] = {
  NSPAIR(_ZN8S10097C6C1Ev),
  NSPAIR(_ZN8S10097C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
static Base_Class bases_S10097C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10097C6[];
extern void _ZN8S10097C6D1Ev();
extern void _ZN8S10097C6D0Ev();
extern void _ZN8S10097C63v13Ev();
extern void _ZN8S10097C63v14Ev();
extern void _ZN8S10097C63v15Ev();
extern void _ZN8S10097C63v16Ev();
static  VTBL_ENTRY vtc_S10097C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10097C6[0]),
  (VTBL_ENTRY)&_ZN8S10097C6D1Ev,
  (VTBL_ENTRY)&_ZN8S10097C6D0Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v13Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v14Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v15Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v16Ev,
};
extern VTBL_ENTRY _ZTI8S10097C6[];
extern  VTBL_ENTRY _ZTV8S10097C6[];
Class_Descriptor cd_S10097C6 = {  "S10097C6", // class name
  bases_S10097C6, 1,
  &(vtc_S10097C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI8S10097C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S10097C6),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C22_nt  {
  void *s10097c22f0;
  ::S10103C82_nt s10097c22f1;
  ::S10103C82_nt s10097c22f2;
  int s10097c22f3[3];
  char s10097c22f4[2];
  int s10097c22f5;
  void *s10097c22f6;
  void  mf10097c22(); // _ZN12S10097C22_nt10mf10097c22Ev
};
//SIG(-1 S10097C22_nt) C1{ m Fp FC2{ m FC3{ m FL[2]}} FC2 Fi[3] Fc[2] Fi Fp}


void  S10097C22_nt ::mf10097c22(){}

//skip512 S10097C22_nt

#else // __cplusplus

Class_Descriptor cd_S10097C22_nt = {  "S10097C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(72,60), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C21  : S10097C22_nt {
  ::S10103C14_nt s10097c21f0;
  ::S10103C14_nt s10097c21f1;
  __tsi64 s10097c21f2;
};
//SIG(-1 S10097C21) C1{ BC2{ m Fp FC3{ m FC4{ m FL[2]}} FC3 Fi[3] Fc[2] Fi Fp} FC5{ m Fp Fi FC6{ m}} FC5 FL}



static void Test_S10097C21()
{
  extern Class_Descriptor cd_S10097C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,24)];
    init_test(&cd_S10097C21, buf);
    S10097C21 &lv = *(new (buf) S10097C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,92), "sizeof(S10097C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C21)");
    check_base_class_offset(lv, (S10097C22_nt*), 0, "S10097C21");
    check_field_offset(lv, s10097c21f0, ABISELECT(72,60), "S10097C21.s10097c21f0");
    check_field_offset(lv, s10097c21f1, ABISELECT(88,72), "S10097C21.s10097c21f1");
    check_field_offset(lv, s10097c21f2, ABISELECT(104,84), "S10097C21.s10097c21f2");
    test_class_info(&lv, &cd_S10097C21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C21(Test_S10097C21, "S10097C21", ABISELECT(112,92));

#else // __cplusplus

extern Class_Descriptor cd_S10097C22_nt;
static Base_Class bases_S10097C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10097C22_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10097C21 = {  "S10097C21", // class name
  bases_S10097C21, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(112,92), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C20  : S10097C6 {
  void *s10097c20f0;
  ::S10097C21 s10097c20f1;
  virtual void  v17(); // _ZN9S10097C203v17Ev
  virtual void  v18(); // _ZN9S10097C203v18Ev
  ~S10097C20(); // tgen
  S10097C20(); // tgen
};
//SIG(-1 S10097C20) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} vd v3 v4 v5 v6 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC8 FC8 Fi} Fp Fc Fi} v1 v2 Fp FC10{ BC11{ m Fp FC12{ m FC13{ m FL[2]}} FC12 Fi[3] Fc[2] Fi Fp} FC8 FC8 FL}}


void  S10097C20 ::v17(){vfunc_called(this, "_ZN9S10097C203v17Ev");}
void  S10097C20 ::v18(){vfunc_called(this, "_ZN9S10097C203v18Ev");}
S10097C20 ::~S10097C20(){ note_dtor("S10097C20", this);} // tgen
S10097C20 ::S10097C20(){ note_ctor("S10097C20", this);} // tgen

static void Test_S10097C20()
{
  extern Class_Descriptor cd_S10097C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,48)];
    init_test(&cd_S10097C20, buf);
    S10097C20 *dp, &lv = *(dp=new (buf) S10097C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,188), "sizeof(S10097C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C20)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10097C6*), 0, "S10097C20");
    check_base_class_offset(lv, (S10097C6*), 0, "S10097C20");
    check_field_offset(lv, s10097c20f0, ABISELECT(136,92), "S10097C20.s10097c20f0");
    check_field_offset(lv, s10097c20f1, ABISELECT(144,96), "S10097C20.s10097c20f1");
    test_class_info(&lv, &cd_S10097C20);
    dp->~S10097C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C20(Test_S10097C20, "S10097C20", ABISELECT(256,188));

#else // __cplusplus

extern void _ZN9S10097C20C1Ev();
extern void _ZN9S10097C20D1Ev();
Name_Map name_map_S10097C20[] = {
  NSPAIR(_ZN9S10097C20C1Ev),
  NSPAIR(_ZN9S10097C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10097C6;
extern VTBL_ENTRY _ZTI8S10097C6[];
extern  VTBL_ENTRY _ZTV8S10097C6[];
static Base_Class bases_S10097C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10097C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10097C20[];
extern void _ZN9S10097C20D1Ev();
extern void _ZN9S10097C20D0Ev();
extern void _ZN8S10097C63v13Ev();
extern void _ZN8S10097C63v14Ev();
extern void _ZN8S10097C63v15Ev();
extern void _ZN8S10097C63v16Ev();
extern void _ZN9S10097C203v17Ev();
extern void _ZN9S10097C203v18Ev();
static  VTBL_ENTRY vtc_S10097C20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10097C20[0]),
  (VTBL_ENTRY)&_ZN9S10097C20D1Ev,
  (VTBL_ENTRY)&_ZN9S10097C20D0Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v13Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v14Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v15Ev,
  (VTBL_ENTRY)&_ZN8S10097C63v16Ev,
  (VTBL_ENTRY)&_ZN9S10097C203v17Ev,
  (VTBL_ENTRY)&_ZN9S10097C203v18Ev,
};
extern VTBL_ENTRY _ZTI9S10097C20[];
extern  VTBL_ENTRY _ZTV9S10097C20[];
Class_Descriptor cd_S10097C20 = {  "S10097C20", // class name
  bases_S10097C20, 2,
  &(vtc_S10097C20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,188), // object size
  NSPAIRA(_ZTI9S10097C20),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10097C20),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C31  {
  ::S10098C18_nt s10097c31f0;
  ::S10098C18_nt s10097c31f1;
  ::S10098C18_nt s10097c31f2;
  ::S10098C18_nt s10097c31f3;
  ::S10098C18_nt s10097c31f4;
  __tsi64 s10097c31f5[2];
  int s10097c31f6[3];
  void  mf10097c31(); // _ZN9S10097C3110mf10097c31Ev
  virtual  ~S10097C31(); // _ZN9S10097C31D1Ev
  S10097C31(); // tgen
};
//SIG(-1 S10097C31) C1{ vd m FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC2 FC2 FL[2] Fi[3]}


void  S10097C31 ::mf10097c31(){}
 S10097C31 ::~S10097C31(){ note_dtor("S10097C31", this);}
S10097C31 ::S10097C31(){ note_ctor("S10097C31", this);} // tgen

static void Test_S10097C31()
{
  extern Class_Descriptor cd_S10097C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,24)];
    init_test(&cd_S10097C31, buf);
    S10097C31 *dp, &lv = *(dp=new (buf) S10097C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,92), "sizeof(S10097C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C31)");
    check_field_offset(lv, s10097c31f0, ABISELECT(8,4), "S10097C31.s10097c31f0");
    check_field_offset(lv, s10097c31f1, ABISELECT(24,16), "S10097C31.s10097c31f1");
    check_field_offset(lv, s10097c31f2, ABISELECT(40,28), "S10097C31.s10097c31f2");
    check_field_offset(lv, s10097c31f3, ABISELECT(56,40), "S10097C31.s10097c31f3");
    check_field_offset(lv, s10097c31f4, ABISELECT(72,52), "S10097C31.s10097c31f4");
    check_field_offset(lv, s10097c31f5, ABISELECT(88,64), "S10097C31.s10097c31f5");
    check_field_offset(lv, s10097c31f6, ABISELECT(104,80), "S10097C31.s10097c31f6");
    test_class_info(&lv, &cd_S10097C31);
    dp->~S10097C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C31(Test_S10097C31, "S10097C31", ABISELECT(120,92));

#else // __cplusplus

extern void _ZN9S10097C31C1Ev();
extern void _ZN9S10097C31D1Ev();
Name_Map name_map_S10097C31[] = {
  NSPAIR(_ZN9S10097C31C1Ev),
  NSPAIR(_ZN9S10097C31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10097C31[];
extern void _ZN9S10097C31D1Ev();
extern void _ZN9S10097C31D0Ev();
static  VTBL_ENTRY vtc_S10097C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10097C31[0]),
  (VTBL_ENTRY)&_ZN9S10097C31D1Ev,
  (VTBL_ENTRY)&_ZN9S10097C31D0Ev,
};
extern VTBL_ENTRY _ZTI9S10097C31[];
extern  VTBL_ENTRY _ZTV9S10097C31[];
Class_Descriptor cd_S10097C31 = {  "S10097C31", // class name
  0,0,//no base classes
  &(vtc_S10097C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,92), // object size
  NSPAIRA(_ZTI9S10097C31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10097C31),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C32  {
  __tsi64 s10097c32f0[2];
  int s10097c32f1[3];
  void  mf10097c32(); // _ZN9S10097C3210mf10097c32Ev
  virtual  ~S10097C32(); // _ZN9S10097C32D1Ev
  S10097C32(); // tgen
};
//SIG(-1 S10097C32) C1{ vd m FL[2] Fi[3]}


void  S10097C32 ::mf10097c32(){}
 S10097C32 ::~S10097C32(){ note_dtor("S10097C32", this);}
S10097C32 ::S10097C32(){ note_ctor("S10097C32", this);} // tgen

static void Test_S10097C32()
{
  extern Class_Descriptor cd_S10097C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_S10097C32, buf);
    S10097C32 *dp, &lv = *(dp=new (buf) S10097C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S10097C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C32)");
    check_field_offset(lv, s10097c32f0, ABISELECT(8,4), "S10097C32.s10097c32f0");
    check_field_offset(lv, s10097c32f1, ABISELECT(24,20), "S10097C32.s10097c32f1");
    test_class_info(&lv, &cd_S10097C32);
    dp->~S10097C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C32(Test_S10097C32, "S10097C32", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN9S10097C32C1Ev();
extern void _ZN9S10097C32D1Ev();
Name_Map name_map_S10097C32[] = {
  NSPAIR(_ZN9S10097C32C1Ev),
  NSPAIR(_ZN9S10097C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10097C32[];
extern void _ZN9S10097C32D1Ev();
extern void _ZN9S10097C32D0Ev();
static  VTBL_ENTRY vtc_S10097C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10097C32[0]),
  (VTBL_ENTRY)&_ZN9S10097C32D1Ev,
  (VTBL_ENTRY)&_ZN9S10097C32D0Ev,
};
extern VTBL_ENTRY _ZTI9S10097C32[];
extern  VTBL_ENTRY _ZTV9S10097C32[];
Class_Descriptor cd_S10097C32 = {  "S10097C32", // class name
  0,0,//no base classes
  &(vtc_S10097C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI9S10097C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10097C32),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C30  {
  ::S10097C31 s10097c30f0;
  ::S10103C14_nt s10097c30f1;
  ::S10097C32 s10097c30f2;
  int s10097c30f3;
  void  mf10097c30(); // _ZN9S10097C3010mf10097c30Ev
  virtual  ~S10097C30(); // _ZN9S10097C30D1Ev
  S10097C30(); // tgen
};
//SIG(-1 S10097C30) C1{ vd m FC2{ vd m FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC3 FC3 FL[2] Fi[3]} FC5{ m Fp Fi FC6{ m}} FC7{ vd m FL[2] Fi[3]} Fi}


void  S10097C30 ::mf10097c30(){}
 S10097C30 ::~S10097C30(){ note_dtor("S10097C30", this);}
S10097C30 ::S10097C30(){ note_ctor("S10097C30", this);} // tgen

static void Test_S10097C30()
{
  extern Class_Descriptor cd_S10097C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,37)];
    init_test(&cd_S10097C30, buf);
    S10097C30 *dp, &lv = *(dp=new (buf) S10097C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,144), "sizeof(S10097C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C30)");
    check_field_offset(lv, s10097c30f0, ABISELECT(8,4), "S10097C30.s10097c30f0");
    check_field_offset(lv, s10097c30f1, ABISELECT(128,96), "S10097C30.s10097c30f1");
    check_field_offset(lv, s10097c30f2, ABISELECT(144,108), "S10097C30.s10097c30f2");
    check_field_offset(lv, s10097c30f3, ABISELECT(184,140), "S10097C30.s10097c30f3");
    test_class_info(&lv, &cd_S10097C30);
    dp->~S10097C30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C30(Test_S10097C30, "S10097C30", ABISELECT(192,144));

#else // __cplusplus

extern void _ZN9S10097C30C1Ev();
extern void _ZN9S10097C30D1Ev();
Name_Map name_map_S10097C30[] = {
  NSPAIR(_ZN9S10097C30C1Ev),
  NSPAIR(_ZN9S10097C30D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10097C30[];
extern void _ZN9S10097C30D1Ev();
extern void _ZN9S10097C30D0Ev();
static  VTBL_ENTRY vtc_S10097C30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10097C30[0]),
  (VTBL_ENTRY)&_ZN9S10097C30D1Ev,
  (VTBL_ENTRY)&_ZN9S10097C30D0Ev,
};
extern VTBL_ENTRY _ZTI9S10097C30[];
extern  VTBL_ENTRY _ZTV9S10097C30[];
Class_Descriptor cd_S10097C30 = {  "S10097C30", // class name
  0,0,//no base classes
  &(vtc_S10097C30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,144), // object size
  NSPAIRA(_ZTI9S10097C30),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10097C30),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10097C1  : S10097C2 , S10097C3 , S10098C4 {
  ::S10103C56 s10097c1f0;
  ::S10097C20 s10097c1f1;
  ::S10103C49 s10097c1f2;
  ::S10098C21 s10097c1f3;
  void *s10097c1f4;
  int s10097c1f5;
  ::S10103C14_nt s10097c1f6;
  ::S10097C30 s10097c1f7;
  ::S10098C34 s10097c1f8;
  virtual  ~S10097C1(); // _ZN8S10097C1D1Ev
  virtual void  v1(); // _ZN8S10097C12v1Ev
  virtual void  v2(); // _ZN8S10097C12v2Ev
  virtual void  v3(); // _ZN8S10097C12v3Ev
  virtual void  v4(); // _ZN8S10097C12v4Ev
  virtual void  v5(); // _ZN8S10097C12v5Ev
  S10097C1(); // tgen
};
//SIG(1 S10097C1) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} BC4{ vd m Fp[4] Fi} vd v1 v2 v3 v4 v5 FC5{ BC6{ BC7{ vd m FC8{ m Fp Fi FC9{ m} FC9} FC8 Fc} vd v13 v14 v15 v16 FC10{ m Fp FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} FC12 FC12 Fi} Fp Fc Fi} v12} FC14{ BC15{ BC7 vd v19 v20 v21 v22 FC10 Fp Fc Fi} v17 v18 Fp FC16{ BC17{ m Fp FC18{ m FC19{ m FL[2]}} FC18 Fi[3] Fc[2] Fi Fp} FC12 FC12 FL}} FC20{ BC6 v23 v24} FC21{ BC7 BC22{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 Fp FC11 FC23{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC24{ m Fc Fi[2] Fp}} vd v25 v26} Fp Fi FC12 FC25{ vd m FC26{ vd m FC27{ m Fp Fi FC28{ m}} FC27 FC27 FC27 FC27 FL[2] Fi[3]} FC12 FC29{ vd m FL[2] Fi[3]} Fi} FC30{ BC31{ vd m FC32{ m Fp Fi[2] FC28} FC32} vd}}


 S10097C1 ::~S10097C1(){ note_dtor("S10097C1", this);}
void  S10097C1 ::v1(){vfunc_called(this, "_ZN8S10097C12v1Ev");}
void  S10097C1 ::v2(){vfunc_called(this, "_ZN8S10097C12v2Ev");}
void  S10097C1 ::v3(){vfunc_called(this, "_ZN8S10097C12v3Ev");}
void  S10097C1 ::v4(){vfunc_called(this, "_ZN8S10097C12v4Ev");}
void  S10097C1 ::v5(){vfunc_called(this, "_ZN8S10097C12v5Ev");}
S10097C1 ::S10097C1(){ note_ctor("S10097C1", this);} // tgen

static void Test_S10097C1()
{
  extern Class_Descriptor cd_S10097C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(132,181)];
    init_test(&cd_S10097C1, buf);
    S10097C1 *dp, &lv = *(dp=new (buf) S10097C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1048,720), "sizeof(S10097C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10097C1)");
    check_base_class_offset(lv, (S10097C2*), 0, "S10097C1");
    check_base_class_offset(lv, (S10097C3*), ABISELECT(8,4), "S10097C1");
    check_base_class_offset(lv, (S10098C4*), ABISELECT(24,12), "S10097C1");
    check_field_offset(lv, s10097c1f0, ABISELECT(72,36), "S10097C1.s10097c1f0");
    check_field_offset(lv, s10097c1f1, ABISELECT(208,128), "S10097C1.s10097c1f1");
    check_field_offset(lv, s10097c1f2, ABISELECT(464,316), "S10097C1.s10097c1f2");
    check_field_offset(lv, s10097c1f3, ABISELECT(600,408), "S10097C1.s10097c1f3");
    check_field_offset(lv, s10097c1f4, ABISELECT(768,520), "S10097C1.s10097c1f4");
    check_field_offset(lv, s10097c1f5, ABISELECT(776,524), "S10097C1.s10097c1f5");
    check_field_offset(lv, s10097c1f6, ABISELECT(784,528), "S10097C1.s10097c1f6");
    check_field_offset(lv, s10097c1f7, ABISELECT(800,540), "S10097C1.s10097c1f7");
    check_field_offset(lv, s10097c1f8, ABISELECT(992,684), "S10097C1.s10097c1f8");
    test_class_info(&lv, &cd_S10097C1);
    dp->~S10097C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10097C1(Test_S10097C1, "S10097C1", ABISELECT(1048,720));

#else // __cplusplus

extern void _ZN8S10097C1C1Ev();
extern void _ZN8S10097C1D1Ev();
Name_Map name_map_S10097C1[] = {
  NSPAIR(_ZN8S10097C1C1Ev),
  NSPAIR(_ZN8S10097C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10097C2;
extern VTBL_ENTRY _ZTI8S10097C2[];
extern  VTBL_ENTRY _ZTV8S10097C2[];
extern Class_Descriptor cd_S10097C3;
extern VTBL_ENTRY _ZTI8S10097C3[];
extern  VTBL_ENTRY _ZTV8S10097C3[];
extern Class_Descriptor cd_S10098C4;
extern VTBL_ENTRY _ZTI8S10098C4[];
extern  VTBL_ENTRY _ZTV8S10098C4[];
static Base_Class bases_S10097C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10097C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10097C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10098C4,    ABISELECT(24,12), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10097C1[];
extern void _ZN8S10097C1D1Ev();
extern void _ZN8S10097C1D0Ev();
extern void _ZN8S10097C22v6Ev();
extern void _ZN8S10097C12v1Ev();
extern void _ZN8S10097C12v2Ev();
extern void _ZN8S10097C12v3Ev();
extern void _ZN8S10097C12v4Ev();
extern void _ZN8S10097C12v5Ev();
extern void ABISELECT(_ZThn8_N8S10097C1D1Ev,_ZThn4_N8S10097C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10097C1D0Ev,_ZThn4_N8S10097C1D0Ev)();
extern void _ZN8S10097C32v7Ev();
extern void _ZN8S10097C32v8Ev();
extern void _ZN8S10097C32v9Ev();
extern void _ZN8S10097C33v10Ev();
extern void _ZN8S10097C33v11Ev();
extern void ABISELECT(_ZThn24_N8S10097C1D1Ev,_ZThn12_N8S10097C1D1Ev)();
extern void ABISELECT(_ZThn24_N8S10097C1D0Ev,_ZThn12_N8S10097C1D0Ev)();
static  VTBL_ENTRY vtc_S10097C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10097C1[0]),
  (VTBL_ENTRY)&_ZN8S10097C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10097C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10097C22v6Ev,
  (VTBL_ENTRY)&_ZN8S10097C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10097C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10097C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10097C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10097C12v5Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10097C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10097C1D1Ev,_ZThn4_N8S10097C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10097C1D0Ev,_ZThn4_N8S10097C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10097C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10097C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10097C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10097C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10097C33v11Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S10097C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10097C1D1Ev,_ZThn12_N8S10097C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10097C1D0Ev,_ZThn12_N8S10097C1D0Ev),
};
extern VTBL_ENTRY _ZTI8S10097C1[];
extern  VTBL_ENTRY _ZTV8S10097C1[];
Class_Descriptor cd_S10097C1 = {  "S10097C1", // class name
  bases_S10097C1, 3,
  &(vtc_S10097C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1048,720), // object size
  NSPAIRA(_ZTI8S10097C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S10097C1),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C5  {
  void *s679c5f0[2];
  ::S10103C13_nt s679c5f1;
  void *s679c5f2;
  virtual  ~S679C5(); // _ZN6S679C5D1Ev
  virtual void  v6(); // _ZN6S679C52v6Ev
  virtual void  v7(); // _ZN6S679C52v7Ev
  virtual void  v8(); // _ZN6S679C52v8Ev
  virtual void  v9(); // _ZN6S679C52v9Ev
  virtual void  v10(); // _ZN6S679C53v10Ev
  virtual void  v11(); // _ZN6S679C53v11Ev
  virtual void  v12(); // _ZN6S679C53v12Ev
  virtual void  v13(); // _ZN6S679C53v13Ev
  virtual void  v14(); // _ZN6S679C53v14Ev
  virtual void  v15(); // _ZN6S679C53v15Ev
  S679C5(); // tgen
};
//SIG(-1 S679C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S679C5 ::~S679C5(){ note_dtor("S679C5", this);}
void  S679C5 ::v6(){vfunc_called(this, "_ZN6S679C52v6Ev");}
void  S679C5 ::v7(){vfunc_called(this, "_ZN6S679C52v7Ev");}
void  S679C5 ::v8(){vfunc_called(this, "_ZN6S679C52v8Ev");}
void  S679C5 ::v9(){vfunc_called(this, "_ZN6S679C52v9Ev");}
void  S679C5 ::v10(){vfunc_called(this, "_ZN6S679C53v10Ev");}
void  S679C5 ::v11(){vfunc_called(this, "_ZN6S679C53v11Ev");}
void  S679C5 ::v12(){vfunc_called(this, "_ZN6S679C53v12Ev");}
void  S679C5 ::v13(){vfunc_called(this, "_ZN6S679C53v13Ev");}
void  S679C5 ::v14(){vfunc_called(this, "_ZN6S679C53v14Ev");}
void  S679C5 ::v15(){vfunc_called(this, "_ZN6S679C53v15Ev");}
S679C5 ::S679C5(){ note_ctor("S679C5", this);} // tgen

static void Test_S679C5()
{
  extern Class_Descriptor cd_S679C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S679C5, buf);
    S679C5 *dp, &lv = *(dp=new (buf) S679C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S679C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S679C5)");
    check_field_offset(lv, s679c5f0, ABISELECT(8,4), "S679C5.s679c5f0");
    check_field_offset(lv, s679c5f1, ABISELECT(24,12), "S679C5.s679c5f1");
    check_field_offset(lv, s679c5f2, ABISELECT(48,28), "S679C5.s679c5f2");
    test_class_info(&lv, &cd_S679C5);
    dp->~S679C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS679C5(Test_S679C5, "S679C5", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN6S679C5C1Ev();
extern void _ZN6S679C5D1Ev();
Name_Map name_map_S679C5[] = {
  NSPAIR(_ZN6S679C5C1Ev),
  NSPAIR(_ZN6S679C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S679C5[];
extern void _ZN6S679C5D1Ev();
extern void _ZN6S679C5D0Ev();
extern void _ZN6S679C52v6Ev();
extern void _ZN6S679C52v7Ev();
extern void _ZN6S679C52v8Ev();
extern void _ZN6S679C52v9Ev();
extern void _ZN6S679C53v10Ev();
extern void _ZN6S679C53v11Ev();
extern void _ZN6S679C53v12Ev();
extern void _ZN6S679C53v13Ev();
extern void _ZN6S679C53v14Ev();
extern void _ZN6S679C53v15Ev();
static  VTBL_ENTRY vtc_S679C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S679C5[0]),
  (VTBL_ENTRY)&_ZN6S679C5D1Ev,
  (VTBL_ENTRY)&_ZN6S679C5D0Ev,
  (VTBL_ENTRY)&_ZN6S679C52v6Ev,
  (VTBL_ENTRY)&_ZN6S679C52v7Ev,
  (VTBL_ENTRY)&_ZN6S679C52v8Ev,
  (VTBL_ENTRY)&_ZN6S679C52v9Ev,
  (VTBL_ENTRY)&_ZN6S679C53v10Ev,
  (VTBL_ENTRY)&_ZN6S679C53v11Ev,
  (VTBL_ENTRY)&_ZN6S679C53v12Ev,
  (VTBL_ENTRY)&_ZN6S679C53v13Ev,
  (VTBL_ENTRY)&_ZN6S679C53v14Ev,
  (VTBL_ENTRY)&_ZN6S679C53v15Ev,
};
extern VTBL_ENTRY _ZTI6S679C5[];
extern  VTBL_ENTRY _ZTV6S679C5[];
Class_Descriptor cd_S679C5 = {  "S679C5", // class name
  0,0,//no base classes
  &(vtc_S679C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI6S679C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S679C5),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C4  : S679C5 {
  ::S10103C86 s679c4f0;
  ::S10103C106 s679c4f1;
  ::S10103C82_nt s679c4f2;
  ::S10103C13_nt s679c4f3;
  virtual  ~S679C4(); // _ZN6S679C4D1Ev
  virtual void  v16(); // _ZN6S679C43v16Ev
  virtual void  v17(); // _ZN6S679C43v17Ev
  virtual void  v18(); // _ZN6S679C43v18Ev
  virtual void  v19(); // _ZN6S679C43v19Ev
  virtual void  v20(); // _ZN6S679C43v20Ev
  virtual void  v21(); // _ZN6S679C43v21Ev
  virtual void  v22(); // _ZN6S679C43v22Ev
  virtual void  v23(); // _ZN6S679C43v23Ev
  virtual void  v24(); // _ZN6S679C43v24Ev
  virtual void  v25(); // _ZN6S679C43v25Ev
  virtual void  v26(); // _ZN6S679C43v26Ev
  virtual void  v27(); // _ZN6S679C43v27Ev
  virtual void  v28(); // _ZN6S679C43v28Ev
  virtual void  v29(); // _ZN6S679C43v29Ev
  S679C4(); // tgen
};
//SIG(-1 S679C4) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S679C4 ::~S679C4(){ note_dtor("S679C4", this);}
void  S679C4 ::v16(){vfunc_called(this, "_ZN6S679C43v16Ev");}
void  S679C4 ::v17(){vfunc_called(this, "_ZN6S679C43v17Ev");}
void  S679C4 ::v18(){vfunc_called(this, "_ZN6S679C43v18Ev");}
void  S679C4 ::v19(){vfunc_called(this, "_ZN6S679C43v19Ev");}
void  S679C4 ::v20(){vfunc_called(this, "_ZN6S679C43v20Ev");}
void  S679C4 ::v21(){vfunc_called(this, "_ZN6S679C43v21Ev");}
void  S679C4 ::v22(){vfunc_called(this, "_ZN6S679C43v22Ev");}
void  S679C4 ::v23(){vfunc_called(this, "_ZN6S679C43v23Ev");}
void  S679C4 ::v24(){vfunc_called(this, "_ZN6S679C43v24Ev");}
void  S679C4 ::v25(){vfunc_called(this, "_ZN6S679C43v25Ev");}
void  S679C4 ::v26(){vfunc_called(this, "_ZN6S679C43v26Ev");}
void  S679C4 ::v27(){vfunc_called(this, "_ZN6S679C43v27Ev");}
void  S679C4 ::v28(){vfunc_called(this, "_ZN6S679C43v28Ev");}
void  S679C4 ::v29(){vfunc_called(this, "_ZN6S679C43v29Ev");}
S679C4 ::S679C4(){ note_ctor("S679C4", this);} // tgen

static void Test_S679C4()
{
  extern Class_Descriptor cd_S679C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S679C4, buf);
    S679C4 *dp, &lv = *(dp=new (buf) S679C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S679C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S679C4)");
    check_base_class_offset(lv, (S679C5*), 0, "S679C4");
    check_field_offset(lv, s679c4f0, ABISELECT(56,32), "S679C4.s679c4f0");
    check_field_offset(lv, s679c4f1, ABISELECT(72,44), "S679C4.s679c4f1");
    check_field_offset(lv, s679c4f2, ABISELECT(96,60), "S679C4.s679c4f2");
    check_field_offset(lv, s679c4f3, ABISELECT(112,76), "S679C4.s679c4f3");
    test_class_info(&lv, &cd_S679C4);
    dp->~S679C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS679C4(Test_S679C4, "S679C4", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN6S679C4C1Ev();
extern void _ZN6S679C4D1Ev();
Name_Map name_map_S679C4[] = {
  NSPAIR(_ZN6S679C4C1Ev),
  NSPAIR(_ZN6S679C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S679C5;
extern VTBL_ENTRY _ZTI6S679C5[];
extern  VTBL_ENTRY _ZTV6S679C5[];
static Base_Class bases_S679C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S679C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S679C4[];
extern void _ZN6S679C4D1Ev();
extern void _ZN6S679C4D0Ev();
extern void _ZN6S679C52v6Ev();
extern void _ZN6S679C52v7Ev();
extern void _ZN6S679C52v8Ev();
extern void _ZN6S679C52v9Ev();
extern void _ZN6S679C53v10Ev();
extern void _ZN6S679C53v11Ev();
extern void _ZN6S679C53v12Ev();
extern void _ZN6S679C53v13Ev();
extern void _ZN6S679C53v14Ev();
extern void _ZN6S679C53v15Ev();
extern void _ZN6S679C43v16Ev();
extern void _ZN6S679C43v17Ev();
extern void _ZN6S679C43v18Ev();
extern void _ZN6S679C43v19Ev();
extern void _ZN6S679C43v20Ev();
extern void _ZN6S679C43v21Ev();
extern void _ZN6S679C43v22Ev();
extern void _ZN6S679C43v23Ev();
extern void _ZN6S679C43v24Ev();
extern void _ZN6S679C43v25Ev();
extern void _ZN6S679C43v26Ev();
extern void _ZN6S679C43v27Ev();
extern void _ZN6S679C43v28Ev();
extern void _ZN6S679C43v29Ev();
static  VTBL_ENTRY vtc_S679C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S679C4[0]),
  (VTBL_ENTRY)&_ZN6S679C4D1Ev,
  (VTBL_ENTRY)&_ZN6S679C4D0Ev,
  (VTBL_ENTRY)&_ZN6S679C52v6Ev,
  (VTBL_ENTRY)&_ZN6S679C52v7Ev,
  (VTBL_ENTRY)&_ZN6S679C52v8Ev,
  (VTBL_ENTRY)&_ZN6S679C52v9Ev,
  (VTBL_ENTRY)&_ZN6S679C53v10Ev,
  (VTBL_ENTRY)&_ZN6S679C53v11Ev,
  (VTBL_ENTRY)&_ZN6S679C53v12Ev,
  (VTBL_ENTRY)&_ZN6S679C53v13Ev,
  (VTBL_ENTRY)&_ZN6S679C53v14Ev,
  (VTBL_ENTRY)&_ZN6S679C53v15Ev,
  (VTBL_ENTRY)&_ZN6S679C43v16Ev,
  (VTBL_ENTRY)&_ZN6S679C43v17Ev,
  (VTBL_ENTRY)&_ZN6S679C43v18Ev,
  (VTBL_ENTRY)&_ZN6S679C43v19Ev,
  (VTBL_ENTRY)&_ZN6S679C43v20Ev,
  (VTBL_ENTRY)&_ZN6S679C43v21Ev,
  (VTBL_ENTRY)&_ZN6S679C43v22Ev,
  (VTBL_ENTRY)&_ZN6S679C43v23Ev,
  (VTBL_ENTRY)&_ZN6S679C43v24Ev,
  (VTBL_ENTRY)&_ZN6S679C43v25Ev,
  (VTBL_ENTRY)&_ZN6S679C43v26Ev,
  (VTBL_ENTRY)&_ZN6S679C43v27Ev,
  (VTBL_ENTRY)&_ZN6S679C43v28Ev,
  (VTBL_ENTRY)&_ZN6S679C43v29Ev,
};
extern VTBL_ENTRY _ZTI6S679C4[];
extern  VTBL_ENTRY _ZTV6S679C4[];
Class_Descriptor cd_S679C4 = {  "S679C4", // class name
  bases_S679C4, 1,
  &(vtc_S679C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI6S679C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S679C4),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C3  : S679C4 {
  int s679c3f0;
  char s679c3f1[2];
  int s679c3f2;
  virtual void  v30(); // _ZN6S679C33v30Ev
  virtual void  v31(); // _ZN6S679C33v31Ev
  virtual void  v32(); // _ZN6S679C33v32Ev
  virtual void  v33(); // _ZN6S679C33v33Ev
  ~S679C3(); // tgen
  S679C3(); // tgen
};
//SIG(-1 S679C3) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 Fi Fc[2] Fi}


void  S679C3 ::v30(){vfunc_called(this, "_ZN6S679C33v30Ev");}
void  S679C3 ::v31(){vfunc_called(this, "_ZN6S679C33v31Ev");}
void  S679C3 ::v32(){vfunc_called(this, "_ZN6S679C33v32Ev");}
void  S679C3 ::v33(){vfunc_called(this, "_ZN6S679C33v33Ev");}
S679C3 ::~S679C3(){ note_dtor("S679C3", this);} // tgen
S679C3 ::S679C3(){ note_ctor("S679C3", this);} // tgen

static void Test_S679C3()
{
  extern Class_Descriptor cd_S679C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S679C3, buf);
    S679C3 *dp, &lv = *(dp=new (buf) S679C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S679C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S679C3)");
    check_base_class_offset(lv, (S679C5*)(S679C4*), 0, "S679C3");
    check_base_class_offset(lv, (S679C4*), 0, "S679C3");
    check_field_offset(lv, s679c3f0, ABISELECT(136,92), "S679C3.s679c3f0");
    check_field_offset(lv, s679c3f1, ABISELECT(140,96), "S679C3.s679c3f1");
    check_field_offset(lv, s679c3f2, ABISELECT(144,100), "S679C3.s679c3f2");
    test_class_info(&lv, &cd_S679C3);
    dp->~S679C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS679C3(Test_S679C3, "S679C3", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN6S679C3C1Ev();
extern void _ZN6S679C3D1Ev();
Name_Map name_map_S679C3[] = {
  NSPAIR(_ZN6S679C3C1Ev),
  NSPAIR(_ZN6S679C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S679C5;
extern VTBL_ENTRY _ZTI6S679C5[];
extern  VTBL_ENTRY _ZTV6S679C5[];
extern Class_Descriptor cd_S679C4;
extern VTBL_ENTRY _ZTI6S679C4[];
extern  VTBL_ENTRY _ZTV6S679C4[];
static Base_Class bases_S679C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S679C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S679C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S679C3[];
extern void _ZN6S679C3D1Ev();
extern void _ZN6S679C3D0Ev();
extern void _ZN6S679C52v6Ev();
extern void _ZN6S679C52v7Ev();
extern void _ZN6S679C52v8Ev();
extern void _ZN6S679C52v9Ev();
extern void _ZN6S679C53v10Ev();
extern void _ZN6S679C53v11Ev();
extern void _ZN6S679C53v12Ev();
extern void _ZN6S679C53v13Ev();
extern void _ZN6S679C53v14Ev();
extern void _ZN6S679C53v15Ev();
extern void _ZN6S679C43v16Ev();
extern void _ZN6S679C43v17Ev();
extern void _ZN6S679C43v18Ev();
extern void _ZN6S679C43v19Ev();
extern void _ZN6S679C43v20Ev();
extern void _ZN6S679C43v21Ev();
extern void _ZN6S679C43v22Ev();
extern void _ZN6S679C43v23Ev();
extern void _ZN6S679C43v24Ev();
extern void _ZN6S679C43v25Ev();
extern void _ZN6S679C43v26Ev();
extern void _ZN6S679C43v27Ev();
extern void _ZN6S679C43v28Ev();
extern void _ZN6S679C43v29Ev();
extern void _ZN6S679C33v30Ev();
extern void _ZN6S679C33v31Ev();
extern void _ZN6S679C33v32Ev();
extern void _ZN6S679C33v33Ev();
static  VTBL_ENTRY vtc_S679C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S679C3[0]),
  (VTBL_ENTRY)&_ZN6S679C3D1Ev,
  (VTBL_ENTRY)&_ZN6S679C3D0Ev,
  (VTBL_ENTRY)&_ZN6S679C52v6Ev,
  (VTBL_ENTRY)&_ZN6S679C52v7Ev,
  (VTBL_ENTRY)&_ZN6S679C52v8Ev,
  (VTBL_ENTRY)&_ZN6S679C52v9Ev,
  (VTBL_ENTRY)&_ZN6S679C53v10Ev,
  (VTBL_ENTRY)&_ZN6S679C53v11Ev,
  (VTBL_ENTRY)&_ZN6S679C53v12Ev,
  (VTBL_ENTRY)&_ZN6S679C53v13Ev,
  (VTBL_ENTRY)&_ZN6S679C53v14Ev,
  (VTBL_ENTRY)&_ZN6S679C53v15Ev,
  (VTBL_ENTRY)&_ZN6S679C43v16Ev,
  (VTBL_ENTRY)&_ZN6S679C43v17Ev,
  (VTBL_ENTRY)&_ZN6S679C43v18Ev,
  (VTBL_ENTRY)&_ZN6S679C43v19Ev,
  (VTBL_ENTRY)&_ZN6S679C43v20Ev,
  (VTBL_ENTRY)&_ZN6S679C43v21Ev,
  (VTBL_ENTRY)&_ZN6S679C43v22Ev,
  (VTBL_ENTRY)&_ZN6S679C43v23Ev,
  (VTBL_ENTRY)&_ZN6S679C43v24Ev,
  (VTBL_ENTRY)&_ZN6S679C43v25Ev,
  (VTBL_ENTRY)&_ZN6S679C43v26Ev,
  (VTBL_ENTRY)&_ZN6S679C43v27Ev,
  (VTBL_ENTRY)&_ZN6S679C43v28Ev,
  (VTBL_ENTRY)&_ZN6S679C43v29Ev,
  (VTBL_ENTRY)&_ZN6S679C33v30Ev,
  (VTBL_ENTRY)&_ZN6S679C33v31Ev,
  (VTBL_ENTRY)&_ZN6S679C33v32Ev,
  (VTBL_ENTRY)&_ZN6S679C33v33Ev,
};
extern VTBL_ENTRY _ZTI6S679C3[];
extern  VTBL_ENTRY _ZTV6S679C3[];
Class_Descriptor cd_S679C3 = {  "S679C3", // class name
  bases_S679C3, 2,
  &(vtc_S679C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI6S679C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S679C3),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C17  : S679C5 {
  void *s679c17f0;
  int s679c17f1;
  ::S10103C35 s679c17f2;
  ::S10103C82_nt s679c17f3;
  int s679c17f4;
  virtual  ~S679C17(); // _ZN7S679C17D1Ev
  virtual void  v42(); // _ZN7S679C173v42Ev
  virtual void  v43(); // _ZN7S679C173v43Ev
  virtual void  v44(); // _ZN7S679C173v44Ev
  virtual void  v45(); // _ZN7S679C173v45Ev
  virtual void  v46(); // _ZN7S679C173v46Ev
  virtual void  v47(); // _ZN7S679C173v47Ev
  S679C17(); // tgen
};
//SIG(-1 S679C17) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 Fp Fi FC6{ m Fp Fi FC7{ m} FC7} FC8{ m FC9{ m FL[2]}} Fi}


 S679C17 ::~S679C17(){ note_dtor("S679C17", this);}
void  S679C17 ::v42(){vfunc_called(this, "_ZN7S679C173v42Ev");}
void  S679C17 ::v43(){vfunc_called(this, "_ZN7S679C173v43Ev");}
void  S679C17 ::v44(){vfunc_called(this, "_ZN7S679C173v44Ev");}
void  S679C17 ::v45(){vfunc_called(this, "_ZN7S679C173v45Ev");}
void  S679C17 ::v46(){vfunc_called(this, "_ZN7S679C173v46Ev");}
void  S679C17 ::v47(){vfunc_called(this, "_ZN7S679C173v47Ev");}
S679C17 ::S679C17(){ note_ctor("S679C17", this);} // tgen

static void Test_S679C17()
{
  extern Class_Descriptor cd_S679C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S679C17, buf);
    S679C17 *dp, &lv = *(dp=new (buf) S679C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S679C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S679C17)");
    check_base_class_offset(lv, (S679C5*), 0, "S679C17");
    check_field_offset(lv, s679c17f0, ABISELECT(56,32), "S679C17.s679c17f0");
    check_field_offset(lv, s679c17f1, ABISELECT(64,36), "S679C17.s679c17f1");
    check_field_offset(lv, s679c17f2, ABISELECT(72,40), "S679C17.s679c17f2");
    check_field_offset(lv, s679c17f3, ABISELECT(88,52), "S679C17.s679c17f3");
    check_field_offset(lv, s679c17f4, ABISELECT(104,68), "S679C17.s679c17f4");
    test_class_info(&lv, &cd_S679C17);
    dp->~S679C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS679C17(Test_S679C17, "S679C17", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN7S679C17C1Ev();
extern void _ZN7S679C17D1Ev();
Name_Map name_map_S679C17[] = {
  NSPAIR(_ZN7S679C17C1Ev),
  NSPAIR(_ZN7S679C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S679C5;
extern VTBL_ENTRY _ZTI6S679C5[];
extern  VTBL_ENTRY _ZTV6S679C5[];
static Base_Class bases_S679C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S679C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S679C17[];
extern void _ZN7S679C17D1Ev();
extern void _ZN7S679C17D0Ev();
extern void _ZN6S679C52v6Ev();
extern void _ZN6S679C52v7Ev();
extern void _ZN6S679C52v8Ev();
extern void _ZN6S679C52v9Ev();
extern void _ZN6S679C53v10Ev();
extern void _ZN6S679C53v11Ev();
extern void _ZN6S679C53v12Ev();
extern void _ZN6S679C53v13Ev();
extern void _ZN6S679C53v14Ev();
extern void _ZN6S679C53v15Ev();
extern void _ZN7S679C173v42Ev();
extern void _ZN7S679C173v43Ev();
extern void _ZN7S679C173v44Ev();
extern void _ZN7S679C173v45Ev();
extern void _ZN7S679C173v46Ev();
extern void _ZN7S679C173v47Ev();
static  VTBL_ENTRY vtc_S679C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S679C17[0]),
  (VTBL_ENTRY)&_ZN7S679C17D1Ev,
  (VTBL_ENTRY)&_ZN7S679C17D0Ev,
  (VTBL_ENTRY)&_ZN6S679C52v6Ev,
  (VTBL_ENTRY)&_ZN6S679C52v7Ev,
  (VTBL_ENTRY)&_ZN6S679C52v8Ev,
  (VTBL_ENTRY)&_ZN6S679C52v9Ev,
  (VTBL_ENTRY)&_ZN6S679C53v10Ev,
  (VTBL_ENTRY)&_ZN6S679C53v11Ev,
  (VTBL_ENTRY)&_ZN6S679C53v12Ev,
  (VTBL_ENTRY)&_ZN6S679C53v13Ev,
  (VTBL_ENTRY)&_ZN6S679C53v14Ev,
  (VTBL_ENTRY)&_ZN6S679C53v15Ev,
  (VTBL_ENTRY)&_ZN7S679C173v42Ev,
  (VTBL_ENTRY)&_ZN7S679C173v43Ev,
  (VTBL_ENTRY)&_ZN7S679C173v44Ev,
  (VTBL_ENTRY)&_ZN7S679C173v45Ev,
  (VTBL_ENTRY)&_ZN7S679C173v46Ev,
  (VTBL_ENTRY)&_ZN7S679C173v47Ev,
};
extern VTBL_ENTRY _ZTI7S679C17[];
extern  VTBL_ENTRY _ZTV7S679C17[];
Class_Descriptor cd_S679C17 = {  "S679C17", // class name
  bases_S679C17, 1,
  &(vtc_S679C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI7S679C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S679C17),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C21_nt  {
  ::S10103C83_nt s679c21f0;
  void  mf679c21(); // _ZN10S679C21_nt8mf679c21Ev
};
//SIG(-1 S679C21_nt) C1{ m FC2{ m FL[2]}}


void  S679C21_nt ::mf679c21(){}

//skip512 S679C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C23  : S679C17 {
  ::S679C21_nt s679c23f0;
  ::S679C21_nt s679c23f1;
  int s679c23f2[6];
  ::S10103C30_nt s679c23f3;
  ::S10103C30_nt s679c23f4;
  char s679c23f5[7];
  int s679c23f6[2];
  ::S10103C82_nt s679c23f7;
  ::S10103C82_nt s679c23f8;
  ::S10103C82_nt s679c23f9;
  ::S10103C82_nt s679c23f10;
  ::S10103C82_nt s679c23f11;
  char s679c23f12[7];
  virtual  ~S679C23(); // _ZN7S679C23D1Ev
  virtual void  v48(); // _ZN7S679C233v48Ev
  virtual void  v49(); // _ZN7S679C233v49Ev
  virtual void  v50(); // _ZN7S679C233v50Ev
  virtual void  v51(); // _ZN7S679C233v51Ev
  S679C23(); // tgen
};
//SIG(-1 S679C23) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 Fp Fi FC7{ m Fp Fi FC8{ m} FC8} FC9{ m FC10{ m FL[2]}} Fi} vd v1 v2 v3 v4 FC11{ m FC10} FC11 Fi[6] FC12{ m FC13{ m FL}} FC12 Fc[7] Fi[2] FC9 FC9 FC9 FC9 FC9 Fc[7]}


 S679C23 ::~S679C23(){ note_dtor("S679C23", this);}
void  S679C23 ::v48(){vfunc_called(this, "_ZN7S679C233v48Ev");}
void  S679C23 ::v49(){vfunc_called(this, "_ZN7S679C233v49Ev");}
void  S679C23 ::v50(){vfunc_called(this, "_ZN7S679C233v50Ev");}
void  S679C23 ::v51(){vfunc_called(this, "_ZN7S679C233v51Ev");}
S679C23 ::S679C23(){ note_ctor("S679C23", this);} // tgen

static void Test_S679C23()
{
  extern Class_Descriptor cd_S679C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,63)];
    init_test(&cd_S679C23, buf);
    S679C23 *dp, &lv = *(dp=new (buf) S679C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,248), "sizeof(S679C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S679C23)");
    check_base_class_offset(lv, (S679C5*)(S679C17*), 0, "S679C23");
    check_base_class_offset(lv, (S679C17*), 0, "S679C23");
    check_field_offset(lv, s679c23f0, ABISELECT(112,72), "S679C23.s679c23f0");
    check_field_offset(lv, s679c23f1, ABISELECT(128,88), "S679C23.s679c23f1");
    check_field_offset(lv, s679c23f2, ABISELECT(144,104), "S679C23.s679c23f2");
    check_field_offset(lv, s679c23f3, ABISELECT(168,128), "S679C23.s679c23f3");
    check_field_offset(lv, s679c23f4, ABISELECT(176,136), "S679C23.s679c23f4");
    check_field_offset(lv, s679c23f5, ABISELECT(184,144), "S679C23.s679c23f5");
    check_field_offset(lv, s679c23f6, ABISELECT(192,152), "S679C23.s679c23f6");
    check_field_offset(lv, s679c23f7, ABISELECT(200,160), "S679C23.s679c23f7");
    check_field_offset(lv, s679c23f8, ABISELECT(216,176), "S679C23.s679c23f8");
    check_field_offset(lv, s679c23f9, ABISELECT(232,192), "S679C23.s679c23f9");
    check_field_offset(lv, s679c23f10, ABISELECT(248,208), "S679C23.s679c23f10");
    check_field_offset(lv, s679c23f11, ABISELECT(264,224), "S679C23.s679c23f11");
    check_field_offset(lv, s679c23f12, ABISELECT(280,240), "S679C23.s679c23f12");
    test_class_info(&lv, &cd_S679C23);
    dp->~S679C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS679C23(Test_S679C23, "S679C23", ABISELECT(288,248));

#else // __cplusplus

extern void _ZN7S679C23C1Ev();
extern void _ZN7S679C23D1Ev();
Name_Map name_map_S679C23[] = {
  NSPAIR(_ZN7S679C23C1Ev),
  NSPAIR(_ZN7S679C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S679C5;
extern VTBL_ENTRY _ZTI6S679C5[];
extern  VTBL_ENTRY _ZTV6S679C5[];
extern Class_Descriptor cd_S679C17;
extern VTBL_ENTRY _ZTI7S679C17[];
extern  VTBL_ENTRY _ZTV7S679C17[];
static Base_Class bases_S679C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S679C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S679C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S679C23[];
extern void _ZN7S679C23D1Ev();
extern void _ZN7S679C23D0Ev();
extern void _ZN6S679C52v6Ev();
extern void _ZN6S679C52v7Ev();
extern void _ZN6S679C52v8Ev();
extern void _ZN6S679C52v9Ev();
extern void _ZN6S679C53v10Ev();
extern void _ZN6S679C53v11Ev();
extern void _ZN6S679C53v12Ev();
extern void _ZN6S679C53v13Ev();
extern void _ZN6S679C53v14Ev();
extern void _ZN6S679C53v15Ev();
extern void _ZN7S679C173v42Ev();
extern void _ZN7S679C173v43Ev();
extern void _ZN7S679C173v44Ev();
extern void _ZN7S679C173v45Ev();
extern void _ZN7S679C173v46Ev();
extern void _ZN7S679C173v47Ev();
extern void _ZN7S679C233v48Ev();
extern void _ZN7S679C233v49Ev();
extern void _ZN7S679C233v50Ev();
extern void _ZN7S679C233v51Ev();
static  VTBL_ENTRY vtc_S679C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S679C23[0]),
  (VTBL_ENTRY)&_ZN7S679C23D1Ev,
  (VTBL_ENTRY)&_ZN7S679C23D0Ev,
  (VTBL_ENTRY)&_ZN6S679C52v6Ev,
  (VTBL_ENTRY)&_ZN6S679C52v7Ev,
  (VTBL_ENTRY)&_ZN6S679C52v8Ev,
  (VTBL_ENTRY)&_ZN6S679C52v9Ev,
  (VTBL_ENTRY)&_ZN6S679C53v10Ev,
  (VTBL_ENTRY)&_ZN6S679C53v11Ev,
  (VTBL_ENTRY)&_ZN6S679C53v12Ev,
  (VTBL_ENTRY)&_ZN6S679C53v13Ev,
  (VTBL_ENTRY)&_ZN6S679C53v14Ev,
  (VTBL_ENTRY)&_ZN6S679C53v15Ev,
  (VTBL_ENTRY)&_ZN7S679C173v42Ev,
  (VTBL_ENTRY)&_ZN7S679C173v43Ev,
  (VTBL_ENTRY)&_ZN7S679C173v44Ev,
  (VTBL_ENTRY)&_ZN7S679C173v45Ev,
  (VTBL_ENTRY)&_ZN7S679C173v46Ev,
  (VTBL_ENTRY)&_ZN7S679C173v47Ev,
  (VTBL_ENTRY)&_ZN7S679C233v48Ev,
  (VTBL_ENTRY)&_ZN7S679C233v49Ev,
  (VTBL_ENTRY)&_ZN7S679C233v50Ev,
  (VTBL_ENTRY)&_ZN7S679C233v51Ev,
};
extern VTBL_ENTRY _ZTI7S679C23[];
extern  VTBL_ENTRY _ZTV7S679C23[];
Class_Descriptor cd_S679C23 = {  "S679C23", // class name
  bases_S679C23, 2,
  &(vtc_S679C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,248), // object size
  NSPAIRA(_ZTI7S679C23),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S679C23),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C2  : S679C3 {
  ::S10103C84 s679c2f0;
  ::S679C23 s679c2f1;
  ::S10103C84 s679c2f2;
  ::S10103C84 s679c2f3;
  int s679c2f4;
  void *s679c2f5;
  int s679c2f6[2];
  virtual  ~S679C2(); // _ZN6S679C2D1Ev
  virtual void  v34(); // _ZN6S679C23v34Ev
  virtual void  v35(); // _ZN6S679C23v35Ev
  virtual void  v36(); // _ZN6S679C23v36Ev
  virtual void  v37(); // _ZN6S679C23v37Ev
  S679C2(); // tgen
};
//SIG(-1 S679C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 Fi Fc[2] Fi} vd v1 v2 v3 v4 FC14{ BC15{ BC16{ vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fp[2] FC5 Fp} vd v47 v48 v49 v50 v51 v52 Fp Fi FC8 FC12 Fi} vd v33 v34 v35 v36 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC17{ BC18{ BC4 vd v57 v58 v59 v60 v61 v62 Fp Fi FC19{ m Fp Fi FC20{ m} FC20} FC12 Fi} vd v53 v54 v55 v56 FC21{ m FC13} FC21 Fi[6] FC22{ m FC23{ m FL}} FC22 Fc[7] Fi[2] FC12 FC12 FC12 FC12 FC12 Fc[7]} FC14 FC14 Fi Fp Fi[2]}


 S679C2 ::~S679C2(){ note_dtor("S679C2", this);}
void  S679C2 ::v34(){vfunc_called(this, "_ZN6S679C23v34Ev");}
void  S679C2 ::v35(){vfunc_called(this, "_ZN6S679C23v35Ev");}
void  S679C2 ::v36(){vfunc_called(this, "_ZN6S679C23v36Ev");}
void  S679C2 ::v37(){vfunc_called(this, "_ZN6S679C23v37Ev");}
S679C2 ::S679C2(){ note_ctor("S679C2", this);} // tgen

static void Test_S679C2()
{
  extern Class_Descriptor cd_S679C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(170,261)];
    init_test(&cd_S679C2, buf);
    S679C2 *dp, &lv = *(dp=new (buf) S679C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1352,1040), "sizeof(S679C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S679C2)");
    check_base_class_offset(lv, (S679C5*)(S679C4*)(S679C3*), 0, "S679C2");
    check_base_class_offset(lv, (S679C4*)(S679C3*), 0, "S679C2");
    check_base_class_offset(lv, (S679C3*), 0, "S679C2");
    check_field_offset(lv, s679c2f0, ABISELECT(152,104), "S679C2.s679c2f0");
    check_field_offset(lv, s679c2f1, ABISELECT(448,328), "S679C2.s679c2f1");
    check_field_offset(lv, s679c2f2, ABISELECT(736,576), "S679C2.s679c2f2");
    check_field_offset(lv, s679c2f3, ABISELECT(1032,800), "S679C2.s679c2f3");
    check_field_offset(lv, s679c2f4, ABISELECT(1328,1024), "S679C2.s679c2f4");
    check_field_offset(lv, s679c2f5, ABISELECT(1336,1028), "S679C2.s679c2f5");
    check_field_offset(lv, s679c2f6, ABISELECT(1344,1032), "S679C2.s679c2f6");
    test_class_info(&lv, &cd_S679C2);
    dp->~S679C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS679C2(Test_S679C2, "S679C2", ABISELECT(1352,1040));

#else // __cplusplus

extern void _ZN6S679C2C1Ev();
extern void _ZN6S679C2D1Ev();
Name_Map name_map_S679C2[] = {
  NSPAIR(_ZN6S679C2C1Ev),
  NSPAIR(_ZN6S679C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S679C5;
extern VTBL_ENTRY _ZTI6S679C5[];
extern  VTBL_ENTRY _ZTV6S679C5[];
extern Class_Descriptor cd_S679C4;
extern VTBL_ENTRY _ZTI6S679C4[];
extern  VTBL_ENTRY _ZTV6S679C4[];
extern Class_Descriptor cd_S679C3;
extern VTBL_ENTRY _ZTI6S679C3[];
extern  VTBL_ENTRY _ZTV6S679C3[];
static Base_Class bases_S679C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S679C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S679C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S679C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S679C2[];
extern void _ZN6S679C2D1Ev();
extern void _ZN6S679C2D0Ev();
extern void _ZN6S679C52v6Ev();
extern void _ZN6S679C52v7Ev();
extern void _ZN6S679C52v8Ev();
extern void _ZN6S679C52v9Ev();
extern void _ZN6S679C53v10Ev();
extern void _ZN6S679C53v11Ev();
extern void _ZN6S679C53v12Ev();
extern void _ZN6S679C53v13Ev();
extern void _ZN6S679C53v14Ev();
extern void _ZN6S679C53v15Ev();
extern void _ZN6S679C43v16Ev();
extern void _ZN6S679C43v17Ev();
extern void _ZN6S679C43v18Ev();
extern void _ZN6S679C43v19Ev();
extern void _ZN6S679C43v20Ev();
extern void _ZN6S679C43v21Ev();
extern void _ZN6S679C43v22Ev();
extern void _ZN6S679C43v23Ev();
extern void _ZN6S679C43v24Ev();
extern void _ZN6S679C43v25Ev();
extern void _ZN6S679C43v26Ev();
extern void _ZN6S679C43v27Ev();
extern void _ZN6S679C43v28Ev();
extern void _ZN6S679C43v29Ev();
extern void _ZN6S679C33v30Ev();
extern void _ZN6S679C33v31Ev();
extern void _ZN6S679C33v32Ev();
extern void _ZN6S679C33v33Ev();
extern void _ZN6S679C23v34Ev();
extern void _ZN6S679C23v35Ev();
extern void _ZN6S679C23v36Ev();
extern void _ZN6S679C23v37Ev();
static  VTBL_ENTRY vtc_S679C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S679C2[0]),
  (VTBL_ENTRY)&_ZN6S679C2D1Ev,
  (VTBL_ENTRY)&_ZN6S679C2D0Ev,
  (VTBL_ENTRY)&_ZN6S679C52v6Ev,
  (VTBL_ENTRY)&_ZN6S679C52v7Ev,
  (VTBL_ENTRY)&_ZN6S679C52v8Ev,
  (VTBL_ENTRY)&_ZN6S679C52v9Ev,
  (VTBL_ENTRY)&_ZN6S679C53v10Ev,
  (VTBL_ENTRY)&_ZN6S679C53v11Ev,
  (VTBL_ENTRY)&_ZN6S679C53v12Ev,
  (VTBL_ENTRY)&_ZN6S679C53v13Ev,
  (VTBL_ENTRY)&_ZN6S679C53v14Ev,
  (VTBL_ENTRY)&_ZN6S679C53v15Ev,
  (VTBL_ENTRY)&_ZN6S679C43v16Ev,
  (VTBL_ENTRY)&_ZN6S679C43v17Ev,
  (VTBL_ENTRY)&_ZN6S679C43v18Ev,
  (VTBL_ENTRY)&_ZN6S679C43v19Ev,
  (VTBL_ENTRY)&_ZN6S679C43v20Ev,
  (VTBL_ENTRY)&_ZN6S679C43v21Ev,
  (VTBL_ENTRY)&_ZN6S679C43v22Ev,
  (VTBL_ENTRY)&_ZN6S679C43v23Ev,
  (VTBL_ENTRY)&_ZN6S679C43v24Ev,
  (VTBL_ENTRY)&_ZN6S679C43v25Ev,
  (VTBL_ENTRY)&_ZN6S679C43v26Ev,
  (VTBL_ENTRY)&_ZN6S679C43v27Ev,
  (VTBL_ENTRY)&_ZN6S679C43v28Ev,
  (VTBL_ENTRY)&_ZN6S679C43v29Ev,
  (VTBL_ENTRY)&_ZN6S679C33v30Ev,
  (VTBL_ENTRY)&_ZN6S679C33v31Ev,
  (VTBL_ENTRY)&_ZN6S679C33v32Ev,
  (VTBL_ENTRY)&_ZN6S679C33v33Ev,
  (VTBL_ENTRY)&_ZN6S679C23v34Ev,
  (VTBL_ENTRY)&_ZN6S679C23v35Ev,
  (VTBL_ENTRY)&_ZN6S679C23v36Ev,
  (VTBL_ENTRY)&_ZN6S679C23v37Ev,
};
extern VTBL_ENTRY _ZTI6S679C2[];
extern  VTBL_ENTRY _ZTV6S679C2[];
Class_Descriptor cd_S679C2 = {  "S679C2", // class name
  bases_S679C2, 3,
  &(vtc_S679C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1352,1040), // object size
  NSPAIRA(_ZTI6S679C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S679C2),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S679C1  : S679C2 {
  ::S10103C84 s679c1f0;
  ::S10103C84 s679c1f1;
  int s679c1f2[3];
  virtual  ~S679C1(); // _ZN6S679C1D1Ev
  virtual void  v1(); // _ZN6S679C12v1Ev
  virtual void  v2(); // _ZN6S679C12v2Ev
  virtual void  v3(); // _ZN6S679C12v3Ev
  virtual void  v4(); // _ZN6S679C12v4Ev
  virtual void  v5(); // _ZN6S679C12v5Ev
  S679C1(); // tgen
};
//SIG(1 S679C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp[2] FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fp} vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 FC9{ m Fp Fi FC10{ m} FC11{ m}} FC12{ m Fp Fi[2] FC11} FC13{ m FC14{ m FL[2]}} FC6} v30 v31 v32 v33 Fi Fc[2] Fi} vd v34 v35 v36 v37 FC15{ BC16{ BC17{ vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 Fp[2] FC6 Fp} vd v52 v53 v54 v55 v56 v57 Fp Fi FC9 FC13 Fi} vd v38 v39 v40 v41 FC6[4] FC13 FC13 FC13 FC13 Fi[6]} FC18{ BC19{ BC5 vd v62 v63 v64 v65 v66 v67 Fp Fi FC20{ m Fp Fi FC21{ m} FC21} FC13 Fi} vd v58 v59 v60 v61 FC22{ m FC14} FC22 Fi[6] FC23{ m FC24{ m FL}} FC23 Fc[7] Fi[2] FC13 FC13 FC13 FC13 FC13 Fc[7]} FC15 FC15 Fi Fp Fi[2]} vd v1 v2 v3 v4 v5 FC15 FC15 Fi[3]}


 S679C1 ::~S679C1(){ note_dtor("S679C1", this);}
void  S679C1 ::v1(){vfunc_called(this, "_ZN6S679C12v1Ev");}
void  S679C1 ::v2(){vfunc_called(this, "_ZN6S679C12v2Ev");}
void  S679C1 ::v3(){vfunc_called(this, "_ZN6S679C12v3Ev");}
void  S679C1 ::v4(){vfunc_called(this, "_ZN6S679C12v4Ev");}
void  S679C1 ::v5(){vfunc_called(this, "_ZN6S679C12v5Ev");}
S679C1 ::S679C1(){ note_ctor("S679C1", this);} // tgen

static void Test_S679C1()
{
  extern Class_Descriptor cd_S679C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(246,376)];
    init_test(&cd_S679C1, buf);
    S679C1 *dp, &lv = *(dp=new (buf) S679C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1960,1500), "sizeof(S679C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S679C1)");
    check_base_class_offset(lv, (S679C5*)(S679C4*)(S679C3*)(S679C2*), 0, "S679C1");
    check_base_class_offset(lv, (S679C4*)(S679C3*)(S679C2*), 0, "S679C1");
    check_base_class_offset(lv, (S679C3*)(S679C2*), 0, "S679C1");
    check_base_class_offset(lv, (S679C2*), 0, "S679C1");
    check_field_offset(lv, s679c1f0, ABISELECT(1352,1040), "S679C1.s679c1f0");
    check_field_offset(lv, s679c1f1, ABISELECT(1648,1264), "S679C1.s679c1f1");
    check_field_offset(lv, s679c1f2, ABISELECT(1944,1488), "S679C1.s679c1f2");
    test_class_info(&lv, &cd_S679C1);
    dp->~S679C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS679C1(Test_S679C1, "S679C1", ABISELECT(1960,1500));

#else // __cplusplus

extern void _ZN6S679C1C1Ev();
extern void _ZN6S679C1D1Ev();
Name_Map name_map_S679C1[] = {
  NSPAIR(_ZN6S679C1C1Ev),
  NSPAIR(_ZN6S679C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S679C5;
extern VTBL_ENTRY _ZTI6S679C5[];
extern  VTBL_ENTRY _ZTV6S679C5[];
extern Class_Descriptor cd_S679C4;
extern VTBL_ENTRY _ZTI6S679C4[];
extern  VTBL_ENTRY _ZTV6S679C4[];
extern Class_Descriptor cd_S679C3;
extern VTBL_ENTRY _ZTI6S679C3[];
extern  VTBL_ENTRY _ZTV6S679C3[];
extern Class_Descriptor cd_S679C2;
extern VTBL_ENTRY _ZTI6S679C2[];
extern  VTBL_ENTRY _ZTV6S679C2[];
static Base_Class bases_S679C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S679C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S679C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S679C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S679C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S679C1[];
extern void _ZN6S679C1D1Ev();
extern void _ZN6S679C1D0Ev();
extern void _ZN6S679C52v6Ev();
extern void _ZN6S679C52v7Ev();
extern void _ZN6S679C52v8Ev();
extern void _ZN6S679C52v9Ev();
extern void _ZN6S679C53v10Ev();
extern void _ZN6S679C53v11Ev();
extern void _ZN6S679C53v12Ev();
extern void _ZN6S679C53v13Ev();
extern void _ZN6S679C53v14Ev();
extern void _ZN6S679C53v15Ev();
extern void _ZN6S679C43v16Ev();
extern void _ZN6S679C43v17Ev();
extern void _ZN6S679C43v18Ev();
extern void _ZN6S679C43v19Ev();
extern void _ZN6S679C43v20Ev();
extern void _ZN6S679C43v21Ev();
extern void _ZN6S679C43v22Ev();
extern void _ZN6S679C43v23Ev();
extern void _ZN6S679C43v24Ev();
extern void _ZN6S679C43v25Ev();
extern void _ZN6S679C43v26Ev();
extern void _ZN6S679C43v27Ev();
extern void _ZN6S679C43v28Ev();
extern void _ZN6S679C43v29Ev();
extern void _ZN6S679C33v30Ev();
extern void _ZN6S679C33v31Ev();
extern void _ZN6S679C33v32Ev();
extern void _ZN6S679C33v33Ev();
extern void _ZN6S679C23v34Ev();
extern void _ZN6S679C23v35Ev();
extern void _ZN6S679C23v36Ev();
extern void _ZN6S679C23v37Ev();
extern void _ZN6S679C12v1Ev();
extern void _ZN6S679C12v2Ev();
extern void _ZN6S679C12v3Ev();
extern void _ZN6S679C12v4Ev();
extern void _ZN6S679C12v5Ev();
static  VTBL_ENTRY vtc_S679C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S679C1[0]),
  (VTBL_ENTRY)&_ZN6S679C1D1Ev,
  (VTBL_ENTRY)&_ZN6S679C1D0Ev,
  (VTBL_ENTRY)&_ZN6S679C52v6Ev,
  (VTBL_ENTRY)&_ZN6S679C52v7Ev,
  (VTBL_ENTRY)&_ZN6S679C52v8Ev,
  (VTBL_ENTRY)&_ZN6S679C52v9Ev,
  (VTBL_ENTRY)&_ZN6S679C53v10Ev,
  (VTBL_ENTRY)&_ZN6S679C53v11Ev,
  (VTBL_ENTRY)&_ZN6S679C53v12Ev,
  (VTBL_ENTRY)&_ZN6S679C53v13Ev,
  (VTBL_ENTRY)&_ZN6S679C53v14Ev,
  (VTBL_ENTRY)&_ZN6S679C53v15Ev,
  (VTBL_ENTRY)&_ZN6S679C43v16Ev,
  (VTBL_ENTRY)&_ZN6S679C43v17Ev,
  (VTBL_ENTRY)&_ZN6S679C43v18Ev,
  (VTBL_ENTRY)&_ZN6S679C43v19Ev,
  (VTBL_ENTRY)&_ZN6S679C43v20Ev,
  (VTBL_ENTRY)&_ZN6S679C43v21Ev,
  (VTBL_ENTRY)&_ZN6S679C43v22Ev,
  (VTBL_ENTRY)&_ZN6S679C43v23Ev,
  (VTBL_ENTRY)&_ZN6S679C43v24Ev,
  (VTBL_ENTRY)&_ZN6S679C43v25Ev,
  (VTBL_ENTRY)&_ZN6S679C43v26Ev,
  (VTBL_ENTRY)&_ZN6S679C43v27Ev,
  (VTBL_ENTRY)&_ZN6S679C43v28Ev,
  (VTBL_ENTRY)&_ZN6S679C43v29Ev,
  (VTBL_ENTRY)&_ZN6S679C33v30Ev,
  (VTBL_ENTRY)&_ZN6S679C33v31Ev,
  (VTBL_ENTRY)&_ZN6S679C33v32Ev,
  (VTBL_ENTRY)&_ZN6S679C33v33Ev,
  (VTBL_ENTRY)&_ZN6S679C23v34Ev,
  (VTBL_ENTRY)&_ZN6S679C23v35Ev,
  (VTBL_ENTRY)&_ZN6S679C23v36Ev,
  (VTBL_ENTRY)&_ZN6S679C23v37Ev,
  (VTBL_ENTRY)&_ZN6S679C12v1Ev,
  (VTBL_ENTRY)&_ZN6S679C12v2Ev,
  (VTBL_ENTRY)&_ZN6S679C12v3Ev,
  (VTBL_ENTRY)&_ZN6S679C12v4Ev,
  (VTBL_ENTRY)&_ZN6S679C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S679C1[];
extern  VTBL_ENTRY _ZTV6S679C1[];
Class_Descriptor cd_S679C1 = {  "S679C1", // class name
  bases_S679C1, 4,
  &(vtc_S679C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1960,1500), // object size
  NSPAIRA(_ZTI6S679C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S679C1),41, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S680C5  {
  void *s680c5f0[2];
  ::S10103C13_nt s680c5f1;
  void *s680c5f2;
  virtual  ~S680C5(); // _ZN6S680C5D1Ev
  virtual void  v6(); // _ZN6S680C52v6Ev
  virtual void  v7(); // _ZN6S680C52v7Ev
  virtual void  v8(); // _ZN6S680C52v8Ev
  virtual void  v9(); // _ZN6S680C52v9Ev
  virtual void  v10(); // _ZN6S680C53v10Ev
  virtual void  v11(); // _ZN6S680C53v11Ev
  virtual void  v12(); // _ZN6S680C53v12Ev
  virtual void  v13(); // _ZN6S680C53v13Ev
  virtual void  v14(); // _ZN6S680C53v14Ev
  virtual void  v15(); // _ZN6S680C53v15Ev
  S680C5(); // tgen
};
//SIG(-1 S680C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S680C5 ::~S680C5(){ note_dtor("S680C5", this);}
void  S680C5 ::v6(){vfunc_called(this, "_ZN6S680C52v6Ev");}
void  S680C5 ::v7(){vfunc_called(this, "_ZN6S680C52v7Ev");}
void  S680C5 ::v8(){vfunc_called(this, "_ZN6S680C52v8Ev");}
void  S680C5 ::v9(){vfunc_called(this, "_ZN6S680C52v9Ev");}
void  S680C5 ::v10(){vfunc_called(this, "_ZN6S680C53v10Ev");}
void  S680C5 ::v11(){vfunc_called(this, "_ZN6S680C53v11Ev");}
void  S680C5 ::v12(){vfunc_called(this, "_ZN6S680C53v12Ev");}
void  S680C5 ::v13(){vfunc_called(this, "_ZN6S680C53v13Ev");}
void  S680C5 ::v14(){vfunc_called(this, "_ZN6S680C53v14Ev");}
void  S680C5 ::v15(){vfunc_called(this, "_ZN6S680C53v15Ev");}
S680C5 ::S680C5(){ note_ctor("S680C5", this);} // tgen

static void Test_S680C5()
{
  extern Class_Descriptor cd_S680C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S680C5, buf);
    S680C5 *dp, &lv = *(dp=new (buf) S680C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S680C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S680C5)");
    check_field_offset(lv, s680c5f0, ABISELECT(8,4), "S680C5.s680c5f0");
    check_field_offset(lv, s680c5f1, ABISELECT(24,12), "S680C5.s680c5f1");
    check_field_offset(lv, s680c5f2, ABISELECT(48,28), "S680C5.s680c5f2");
    test_class_info(&lv, &cd_S680C5);
    dp->~S680C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS680C5(Test_S680C5, "S680C5", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN6S680C5C1Ev();
extern void _ZN6S680C5D1Ev();
Name_Map name_map_S680C5[] = {
  NSPAIR(_ZN6S680C5C1Ev),
  NSPAIR(_ZN6S680C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S680C5[];
extern void _ZN6S680C5D1Ev();
extern void _ZN6S680C5D0Ev();
extern void _ZN6S680C52v6Ev();
extern void _ZN6S680C52v7Ev();
extern void _ZN6S680C52v8Ev();
extern void _ZN6S680C52v9Ev();
extern void _ZN6S680C53v10Ev();
extern void _ZN6S680C53v11Ev();
extern void _ZN6S680C53v12Ev();
extern void _ZN6S680C53v13Ev();
extern void _ZN6S680C53v14Ev();
extern void _ZN6S680C53v15Ev();
static  VTBL_ENTRY vtc_S680C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S680C5[0]),
  (VTBL_ENTRY)&_ZN6S680C5D1Ev,
  (VTBL_ENTRY)&_ZN6S680C5D0Ev,
  (VTBL_ENTRY)&_ZN6S680C52v6Ev,
  (VTBL_ENTRY)&_ZN6S680C52v7Ev,
  (VTBL_ENTRY)&_ZN6S680C52v8Ev,
  (VTBL_ENTRY)&_ZN6S680C52v9Ev,
  (VTBL_ENTRY)&_ZN6S680C53v10Ev,
  (VTBL_ENTRY)&_ZN6S680C53v11Ev,
  (VTBL_ENTRY)&_ZN6S680C53v12Ev,
  (VTBL_ENTRY)&_ZN6S680C53v13Ev,
  (VTBL_ENTRY)&_ZN6S680C53v14Ev,
  (VTBL_ENTRY)&_ZN6S680C53v15Ev,
};
extern VTBL_ENTRY _ZTI6S680C5[];
extern  VTBL_ENTRY _ZTV6S680C5[];
Class_Descriptor cd_S680C5 = {  "S680C5", // class name
  0,0,//no base classes
  &(vtc_S680C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI6S680C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S680C5),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S680C4  : S680C5 {
  ::S10103C86 s680c4f0;
  ::S10103C106 s680c4f1;
  ::S10103C82_nt s680c4f2;
  ::S10103C13_nt s680c4f3;
  virtual  ~S680C4(); // _ZN6S680C4D1Ev
  virtual void  v16(); // _ZN6S680C43v16Ev
  virtual void  v17(); // _ZN6S680C43v17Ev
  virtual void  v18(); // _ZN6S680C43v18Ev
  virtual void  v19(); // _ZN6S680C43v19Ev
  virtual void  v20(); // _ZN6S680C43v20Ev
  virtual void  v21(); // _ZN6S680C43v21Ev
  virtual void  v22(); // _ZN6S680C43v22Ev
  virtual void  v23(); // _ZN6S680C43v23Ev
  virtual void  v24(); // _ZN6S680C43v24Ev
  virtual void  v25(); // _ZN6S680C43v25Ev
  virtual void  v26(); // _ZN6S680C43v26Ev
  virtual void  v27(); // _ZN6S680C43v27Ev
  virtual void  v28(); // _ZN6S680C43v28Ev
  virtual void  v29(); // _ZN6S680C43v29Ev
  S680C4(); // tgen
};
//SIG(-1 S680C4) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S680C4 ::~S680C4(){ note_dtor("S680C4", this);}
void  S680C4 ::v16(){vfunc_called(this, "_ZN6S680C43v16Ev");}
void  S680C4 ::v17(){vfunc_called(this, "_ZN6S680C43v17Ev");}
void  S680C4 ::v18(){vfunc_called(this, "_ZN6S680C43v18Ev");}
void  S680C4 ::v19(){vfunc_called(this, "_ZN6S680C43v19Ev");}
void  S680C4 ::v20(){vfunc_called(this, "_ZN6S680C43v20Ev");}
void  S680C4 ::v21(){vfunc_called(this, "_ZN6S680C43v21Ev");}
void  S680C4 ::v22(){vfunc_called(this, "_ZN6S680C43v22Ev");}
void  S680C4 ::v23(){vfunc_called(this, "_ZN6S680C43v23Ev");}
void  S680C4 ::v24(){vfunc_called(this, "_ZN6S680C43v24Ev");}
void  S680C4 ::v25(){vfunc_called(this, "_ZN6S680C43v25Ev");}
void  S680C4 ::v26(){vfunc_called(this, "_ZN6S680C43v26Ev");}
void  S680C4 ::v27(){vfunc_called(this, "_ZN6S680C43v27Ev");}
void  S680C4 ::v28(){vfunc_called(this, "_ZN6S680C43v28Ev");}
void  S680C4 ::v29(){vfunc_called(this, "_ZN6S680C43v29Ev");}
S680C4 ::S680C4(){ note_ctor("S680C4", this);} // tgen

static void Test_S680C4()
{
  extern Class_Descriptor cd_S680C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S680C4, buf);
    S680C4 *dp, &lv = *(dp=new (buf) S680C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S680C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S680C4)");
    check_base_class_offset(lv, (S680C5*), 0, "S680C4");
    check_field_offset(lv, s680c4f0, ABISELECT(56,32), "S680C4.s680c4f0");
    check_field_offset(lv, s680c4f1, ABISELECT(72,44), "S680C4.s680c4f1");
    check_field_offset(lv, s680c4f2, ABISELECT(96,60), "S680C4.s680c4f2");
    check_field_offset(lv, s680c4f3, ABISELECT(112,76), "S680C4.s680c4f3");
    test_class_info(&lv, &cd_S680C4);
    dp->~S680C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS680C4(Test_S680C4, "S680C4", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN6S680C4C1Ev();
extern void _ZN6S680C4D1Ev();
Name_Map name_map_S680C4[] = {
  NSPAIR(_ZN6S680C4C1Ev),
  NSPAIR(_ZN6S680C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S680C5;
extern VTBL_ENTRY _ZTI6S680C5[];
extern  VTBL_ENTRY _ZTV6S680C5[];
static Base_Class bases_S680C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S680C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S680C4[];
extern void _ZN6S680C4D1Ev();
extern void _ZN6S680C4D0Ev();
extern void _ZN6S680C52v6Ev();
extern void _ZN6S680C52v7Ev();
extern void _ZN6S680C52v8Ev();
extern void _ZN6S680C52v9Ev();
extern void _ZN6S680C53v10Ev();
extern void _ZN6S680C53v11Ev();
extern void _ZN6S680C53v12Ev();
extern void _ZN6S680C53v13Ev();
extern void _ZN6S680C53v14Ev();
extern void _ZN6S680C53v15Ev();
extern void _ZN6S680C43v16Ev();
extern void _ZN6S680C43v17Ev();
extern void _ZN6S680C43v18Ev();
extern void _ZN6S680C43v19Ev();
extern void _ZN6S680C43v20Ev();
extern void _ZN6S680C43v21Ev();
extern void _ZN6S680C43v22Ev();
extern void _ZN6S680C43v23Ev();
extern void _ZN6S680C43v24Ev();
extern void _ZN6S680C43v25Ev();
extern void _ZN6S680C43v26Ev();
extern void _ZN6S680C43v27Ev();
extern void _ZN6S680C43v28Ev();
extern void _ZN6S680C43v29Ev();
static  VTBL_ENTRY vtc_S680C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S680C4[0]),
  (VTBL_ENTRY)&_ZN6S680C4D1Ev,
  (VTBL_ENTRY)&_ZN6S680C4D0Ev,
  (VTBL_ENTRY)&_ZN6S680C52v6Ev,
  (VTBL_ENTRY)&_ZN6S680C52v7Ev,
  (VTBL_ENTRY)&_ZN6S680C52v8Ev,
  (VTBL_ENTRY)&_ZN6S680C52v9Ev,
  (VTBL_ENTRY)&_ZN6S680C53v10Ev,
  (VTBL_ENTRY)&_ZN6S680C53v11Ev,
  (VTBL_ENTRY)&_ZN6S680C53v12Ev,
  (VTBL_ENTRY)&_ZN6S680C53v13Ev,
  (VTBL_ENTRY)&_ZN6S680C53v14Ev,
  (VTBL_ENTRY)&_ZN6S680C53v15Ev,
  (VTBL_ENTRY)&_ZN6S680C43v16Ev,
  (VTBL_ENTRY)&_ZN6S680C43v17Ev,
  (VTBL_ENTRY)&_ZN6S680C43v18Ev,
  (VTBL_ENTRY)&_ZN6S680C43v19Ev,
  (VTBL_ENTRY)&_ZN6S680C43v20Ev,
  (VTBL_ENTRY)&_ZN6S680C43v21Ev,
  (VTBL_ENTRY)&_ZN6S680C43v22Ev,
  (VTBL_ENTRY)&_ZN6S680C43v23Ev,
  (VTBL_ENTRY)&_ZN6S680C43v24Ev,
  (VTBL_ENTRY)&_ZN6S680C43v25Ev,
  (VTBL_ENTRY)&_ZN6S680C43v26Ev,
  (VTBL_ENTRY)&_ZN6S680C43v27Ev,
  (VTBL_ENTRY)&_ZN6S680C43v28Ev,
  (VTBL_ENTRY)&_ZN6S680C43v29Ev,
};
extern VTBL_ENTRY _ZTI6S680C4[];
extern  VTBL_ENTRY _ZTV6S680C4[];
Class_Descriptor cd_S680C4 = {  "S680C4", // class name
  bases_S680C4, 1,
  &(vtc_S680C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI6S680C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S680C4),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S680C3  : S680C4 {
  int s680c3f0;
  char s680c3f1[2];
  int s680c3f2;
  virtual void  v30(); // _ZN6S680C33v30Ev
  virtual void  v31(); // _ZN6S680C33v31Ev
  virtual void  v32(); // _ZN6S680C33v32Ev
  virtual void  v33(); // _ZN6S680C33v33Ev
  ~S680C3(); // tgen
  S680C3(); // tgen
};
//SIG(-1 S680C3) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 Fi Fc[2] Fi}


void  S680C3 ::v30(){vfunc_called(this, "_ZN6S680C33v30Ev");}
void  S680C3 ::v31(){vfunc_called(this, "_ZN6S680C33v31Ev");}
void  S680C3 ::v32(){vfunc_called(this, "_ZN6S680C33v32Ev");}
void  S680C3 ::v33(){vfunc_called(this, "_ZN6S680C33v33Ev");}
S680C3 ::~S680C3(){ note_dtor("S680C3", this);} // tgen
S680C3 ::S680C3(){ note_ctor("S680C3", this);} // tgen

static void Test_S680C3()
{
  extern Class_Descriptor cd_S680C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S680C3, buf);
    S680C3 *dp, &lv = *(dp=new (buf) S680C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S680C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S680C3)");
    check_base_class_offset(lv, (S680C5*)(S680C4*), 0, "S680C3");
    check_base_class_offset(lv, (S680C4*), 0, "S680C3");
    check_field_offset(lv, s680c3f0, ABISELECT(136,92), "S680C3.s680c3f0");
    check_field_offset(lv, s680c3f1, ABISELECT(140,96), "S680C3.s680c3f1");
    check_field_offset(lv, s680c3f2, ABISELECT(144,100), "S680C3.s680c3f2");
    test_class_info(&lv, &cd_S680C3);
    dp->~S680C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS680C3(Test_S680C3, "S680C3", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN6S680C3C1Ev();
extern void _ZN6S680C3D1Ev();
Name_Map name_map_S680C3[] = {
  NSPAIR(_ZN6S680C3C1Ev),
  NSPAIR(_ZN6S680C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S680C5;
extern VTBL_ENTRY _ZTI6S680C5[];
extern  VTBL_ENTRY _ZTV6S680C5[];
extern Class_Descriptor cd_S680C4;
extern VTBL_ENTRY _ZTI6S680C4[];
extern  VTBL_ENTRY _ZTV6S680C4[];
static Base_Class bases_S680C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S680C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S680C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S680C3[];
extern void _ZN6S680C3D1Ev();
extern void _ZN6S680C3D0Ev();
extern void _ZN6S680C52v6Ev();
extern void _ZN6S680C52v7Ev();
extern void _ZN6S680C52v8Ev();
extern void _ZN6S680C52v9Ev();
extern void _ZN6S680C53v10Ev();
extern void _ZN6S680C53v11Ev();
extern void _ZN6S680C53v12Ev();
extern void _ZN6S680C53v13Ev();
extern void _ZN6S680C53v14Ev();
extern void _ZN6S680C53v15Ev();
extern void _ZN6S680C43v16Ev();
extern void _ZN6S680C43v17Ev();
extern void _ZN6S680C43v18Ev();
extern void _ZN6S680C43v19Ev();
extern void _ZN6S680C43v20Ev();
extern void _ZN6S680C43v21Ev();
extern void _ZN6S680C43v22Ev();
extern void _ZN6S680C43v23Ev();
extern void _ZN6S680C43v24Ev();
extern void _ZN6S680C43v25Ev();
extern void _ZN6S680C43v26Ev();
extern void _ZN6S680C43v27Ev();
extern void _ZN6S680C43v28Ev();
extern void _ZN6S680C43v29Ev();
extern void _ZN6S680C33v30Ev();
extern void _ZN6S680C33v31Ev();
extern void _ZN6S680C33v32Ev();
extern void _ZN6S680C33v33Ev();
static  VTBL_ENTRY vtc_S680C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S680C3[0]),
  (VTBL_ENTRY)&_ZN6S680C3D1Ev,
  (VTBL_ENTRY)&_ZN6S680C3D0Ev,
  (VTBL_ENTRY)&_ZN6S680C52v6Ev,
  (VTBL_ENTRY)&_ZN6S680C52v7Ev,
  (VTBL_ENTRY)&_ZN6S680C52v8Ev,
  (VTBL_ENTRY)&_ZN6S680C52v9Ev,
  (VTBL_ENTRY)&_ZN6S680C53v10Ev,
  (VTBL_ENTRY)&_ZN6S680C53v11Ev,
  (VTBL_ENTRY)&_ZN6S680C53v12Ev,
  (VTBL_ENTRY)&_ZN6S680C53v13Ev,
  (VTBL_ENTRY)&_ZN6S680C53v14Ev,
  (VTBL_ENTRY)&_ZN6S680C53v15Ev,
  (VTBL_ENTRY)&_ZN6S680C43v16Ev,
  (VTBL_ENTRY)&_ZN6S680C43v17Ev,
  (VTBL_ENTRY)&_ZN6S680C43v18Ev,
  (VTBL_ENTRY)&_ZN6S680C43v19Ev,
  (VTBL_ENTRY)&_ZN6S680C43v20Ev,
  (VTBL_ENTRY)&_ZN6S680C43v21Ev,
  (VTBL_ENTRY)&_ZN6S680C43v22Ev,
  (VTBL_ENTRY)&_ZN6S680C43v23Ev,
  (VTBL_ENTRY)&_ZN6S680C43v24Ev,
  (VTBL_ENTRY)&_ZN6S680C43v25Ev,
  (VTBL_ENTRY)&_ZN6S680C43v26Ev,
  (VTBL_ENTRY)&_ZN6S680C43v27Ev,
  (VTBL_ENTRY)&_ZN6S680C43v28Ev,
  (VTBL_ENTRY)&_ZN6S680C43v29Ev,
  (VTBL_ENTRY)&_ZN6S680C33v30Ev,
  (VTBL_ENTRY)&_ZN6S680C33v31Ev,
  (VTBL_ENTRY)&_ZN6S680C33v32Ev,
  (VTBL_ENTRY)&_ZN6S680C33v33Ev,
};
extern VTBL_ENTRY _ZTI6S680C3[];
extern  VTBL_ENTRY _ZTV6S680C3[];
Class_Descriptor cd_S680C3 = {  "S680C3", // class name
  bases_S680C3, 2,
  &(vtc_S680C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI6S680C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S680C3),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S680C2  : S680C3 {
  ::S10103C84 s680c2f0;
  ::S679C23 s680c2f1;
  ::S10103C84 s680c2f2;
  ::S10103C84 s680c2f3;
  int s680c2f4;
  void *s680c2f5;
  int s680c2f6[2];
  virtual  ~S680C2(); // _ZN6S680C2D1Ev
  virtual void  v34(); // _ZN6S680C23v34Ev
  virtual void  v35(); // _ZN6S680C23v35Ev
  virtual void  v36(); // _ZN6S680C23v36Ev
  virtual void  v37(); // _ZN6S680C23v37Ev
  S680C2(); // tgen
};
//SIG(-1 S680C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 Fi Fc[2] Fi} vd v1 v2 v3 v4 FC14{ BC15{ BC16{ vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fp[2] FC5 Fp} vd v47 v48 v49 v50 v51 v52 Fp Fi FC8 FC12 Fi} vd v33 v34 v35 v36 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC17{ BC18{ BC19{ vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fp[2] FC5 Fp} vd v67 v68 v69 v70 v71 v72 Fp Fi FC20{ m Fp Fi FC21{ m} FC21} FC12 Fi} vd v53 v54 v55 v56 FC22{ m FC13} FC22 Fi[6] FC23{ m FC24{ m FL}} FC23 Fc[7] Fi[2] FC12 FC12 FC12 FC12 FC12 Fc[7]} FC14 FC14 Fi Fp Fi[2]}


 S680C2 ::~S680C2(){ note_dtor("S680C2", this);}
void  S680C2 ::v34(){vfunc_called(this, "_ZN6S680C23v34Ev");}
void  S680C2 ::v35(){vfunc_called(this, "_ZN6S680C23v35Ev");}
void  S680C2 ::v36(){vfunc_called(this, "_ZN6S680C23v36Ev");}
void  S680C2 ::v37(){vfunc_called(this, "_ZN6S680C23v37Ev");}
S680C2 ::S680C2(){ note_ctor("S680C2", this);} // tgen

static void Test_S680C2()
{
  extern Class_Descriptor cd_S680C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(170,261)];
    init_test(&cd_S680C2, buf);
    S680C2 *dp, &lv = *(dp=new (buf) S680C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1352,1040), "sizeof(S680C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S680C2)");
    check_base_class_offset(lv, (S680C5*)(S680C4*)(S680C3*), 0, "S680C2");
    check_base_class_offset(lv, (S680C4*)(S680C3*), 0, "S680C2");
    check_base_class_offset(lv, (S680C3*), 0, "S680C2");
    check_field_offset(lv, s680c2f0, ABISELECT(152,104), "S680C2.s680c2f0");
    check_field_offset(lv, s680c2f1, ABISELECT(448,328), "S680C2.s680c2f1");
    check_field_offset(lv, s680c2f2, ABISELECT(736,576), "S680C2.s680c2f2");
    check_field_offset(lv, s680c2f3, ABISELECT(1032,800), "S680C2.s680c2f3");
    check_field_offset(lv, s680c2f4, ABISELECT(1328,1024), "S680C2.s680c2f4");
    check_field_offset(lv, s680c2f5, ABISELECT(1336,1028), "S680C2.s680c2f5");
    check_field_offset(lv, s680c2f6, ABISELECT(1344,1032), "S680C2.s680c2f6");
    test_class_info(&lv, &cd_S680C2);
    dp->~S680C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS680C2(Test_S680C2, "S680C2", ABISELECT(1352,1040));

#else // __cplusplus

extern void _ZN6S680C2C1Ev();
extern void _ZN6S680C2D1Ev();
Name_Map name_map_S680C2[] = {
  NSPAIR(_ZN6S680C2C1Ev),
  NSPAIR(_ZN6S680C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S680C5;
extern VTBL_ENTRY _ZTI6S680C5[];
extern  VTBL_ENTRY _ZTV6S680C5[];
extern Class_Descriptor cd_S680C4;
extern VTBL_ENTRY _ZTI6S680C4[];
extern  VTBL_ENTRY _ZTV6S680C4[];
extern Class_Descriptor cd_S680C3;
extern VTBL_ENTRY _ZTI6S680C3[];
extern  VTBL_ENTRY _ZTV6S680C3[];
static Base_Class bases_S680C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S680C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S680C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S680C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S680C2[];
extern void _ZN6S680C2D1Ev();
extern void _ZN6S680C2D0Ev();
extern void _ZN6S680C52v6Ev();
extern void _ZN6S680C52v7Ev();
extern void _ZN6S680C52v8Ev();
extern void _ZN6S680C52v9Ev();
extern void _ZN6S680C53v10Ev();
extern void _ZN6S680C53v11Ev();
extern void _ZN6S680C53v12Ev();
extern void _ZN6S680C53v13Ev();
extern void _ZN6S680C53v14Ev();
extern void _ZN6S680C53v15Ev();
extern void _ZN6S680C43v16Ev();
extern void _ZN6S680C43v17Ev();
extern void _ZN6S680C43v18Ev();
extern void _ZN6S680C43v19Ev();
extern void _ZN6S680C43v20Ev();
extern void _ZN6S680C43v21Ev();
extern void _ZN6S680C43v22Ev();
extern void _ZN6S680C43v23Ev();
extern void _ZN6S680C43v24Ev();
extern void _ZN6S680C43v25Ev();
extern void _ZN6S680C43v26Ev();
extern void _ZN6S680C43v27Ev();
extern void _ZN6S680C43v28Ev();
extern void _ZN6S680C43v29Ev();
extern void _ZN6S680C33v30Ev();
extern void _ZN6S680C33v31Ev();
extern void _ZN6S680C33v32Ev();
extern void _ZN6S680C33v33Ev();
extern void _ZN6S680C23v34Ev();
extern void _ZN6S680C23v35Ev();
extern void _ZN6S680C23v36Ev();
extern void _ZN6S680C23v37Ev();
static  VTBL_ENTRY vtc_S680C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S680C2[0]),
  (VTBL_ENTRY)&_ZN6S680C2D1Ev,
  (VTBL_ENTRY)&_ZN6S680C2D0Ev,
  (VTBL_ENTRY)&_ZN6S680C52v6Ev,
  (VTBL_ENTRY)&_ZN6S680C52v7Ev,
  (VTBL_ENTRY)&_ZN6S680C52v8Ev,
  (VTBL_ENTRY)&_ZN6S680C52v9Ev,
  (VTBL_ENTRY)&_ZN6S680C53v10Ev,
  (VTBL_ENTRY)&_ZN6S680C53v11Ev,
  (VTBL_ENTRY)&_ZN6S680C53v12Ev,
  (VTBL_ENTRY)&_ZN6S680C53v13Ev,
  (VTBL_ENTRY)&_ZN6S680C53v14Ev,
  (VTBL_ENTRY)&_ZN6S680C53v15Ev,
  (VTBL_ENTRY)&_ZN6S680C43v16Ev,
  (VTBL_ENTRY)&_ZN6S680C43v17Ev,
  (VTBL_ENTRY)&_ZN6S680C43v18Ev,
  (VTBL_ENTRY)&_ZN6S680C43v19Ev,
  (VTBL_ENTRY)&_ZN6S680C43v20Ev,
  (VTBL_ENTRY)&_ZN6S680C43v21Ev,
  (VTBL_ENTRY)&_ZN6S680C43v22Ev,
  (VTBL_ENTRY)&_ZN6S680C43v23Ev,
  (VTBL_ENTRY)&_ZN6S680C43v24Ev,
  (VTBL_ENTRY)&_ZN6S680C43v25Ev,
  (VTBL_ENTRY)&_ZN6S680C43v26Ev,
  (VTBL_ENTRY)&_ZN6S680C43v27Ev,
  (VTBL_ENTRY)&_ZN6S680C43v28Ev,
  (VTBL_ENTRY)&_ZN6S680C43v29Ev,
  (VTBL_ENTRY)&_ZN6S680C33v30Ev,
  (VTBL_ENTRY)&_ZN6S680C33v31Ev,
  (VTBL_ENTRY)&_ZN6S680C33v32Ev,
  (VTBL_ENTRY)&_ZN6S680C33v33Ev,
  (VTBL_ENTRY)&_ZN6S680C23v34Ev,
  (VTBL_ENTRY)&_ZN6S680C23v35Ev,
  (VTBL_ENTRY)&_ZN6S680C23v36Ev,
  (VTBL_ENTRY)&_ZN6S680C23v37Ev,
};
extern VTBL_ENTRY _ZTI6S680C2[];
extern  VTBL_ENTRY _ZTV6S680C2[];
Class_Descriptor cd_S680C2 = {  "S680C2", // class name
  bases_S680C2, 3,
  &(vtc_S680C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1352,1040), // object size
  NSPAIRA(_ZTI6S680C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S680C2),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S680C1  : S680C2 {
  ::S10103C84 s680c1f0;
  int s680c1f1;
  virtual  ~S680C1(); // _ZN6S680C1D1Ev
  virtual void  v1(); // _ZN6S680C12v1Ev
  virtual void  v2(); // _ZN6S680C12v2Ev
  virtual void  v3(); // _ZN6S680C12v3Ev
  virtual void  v4(); // _ZN6S680C12v4Ev
  virtual void  v5(); // _ZN6S680C12v5Ev
  S680C1(); // tgen
};
//SIG(1 S680C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp[2] FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fp} vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 FC9{ m Fp Fi FC10{ m} FC11{ m}} FC12{ m Fp Fi[2] FC11} FC13{ m FC14{ m FL[2]}} FC6} v30 v31 v32 v33 Fi Fc[2] Fi} vd v34 v35 v36 v37 FC15{ BC16{ BC17{ vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 Fp[2] FC6 Fp} vd v52 v53 v54 v55 v56 v57 Fp Fi FC9 FC13 Fi} vd v38 v39 v40 v41 FC6[4] FC13 FC13 FC13 FC13 Fi[6]} FC18{ BC19{ BC20{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fp[2] FC6 Fp} vd v72 v73 v74 v75 v76 v77 Fp Fi FC21{ m Fp Fi FC22{ m} FC22} FC13 Fi} vd v58 v59 v60 v61 FC23{ m FC14} FC23 Fi[6] FC24{ m FC25{ m FL}} FC24 Fc[7] Fi[2] FC13 FC13 FC13 FC13 FC13 Fc[7]} FC15 FC15 Fi Fp Fi[2]} vd v1 v2 v3 v4 v5 FC15 Fi}


 S680C1 ::~S680C1(){ note_dtor("S680C1", this);}
void  S680C1 ::v1(){vfunc_called(this, "_ZN6S680C12v1Ev");}
void  S680C1 ::v2(){vfunc_called(this, "_ZN6S680C12v2Ev");}
void  S680C1 ::v3(){vfunc_called(this, "_ZN6S680C12v3Ev");}
void  S680C1 ::v4(){vfunc_called(this, "_ZN6S680C12v4Ev");}
void  S680C1 ::v5(){vfunc_called(this, "_ZN6S680C12v5Ev");}
S680C1 ::S680C1(){ note_ctor("S680C1", this);} // tgen

static void Test_S680C1()
{
  extern Class_Descriptor cd_S680C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(208,318)];
    init_test(&cd_S680C1, buf);
    S680C1 *dp, &lv = *(dp=new (buf) S680C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1656,1268), "sizeof(S680C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S680C1)");
    check_base_class_offset(lv, (S680C5*)(S680C4*)(S680C3*)(S680C2*), 0, "S680C1");
    check_base_class_offset(lv, (S680C4*)(S680C3*)(S680C2*), 0, "S680C1");
    check_base_class_offset(lv, (S680C3*)(S680C2*), 0, "S680C1");
    check_base_class_offset(lv, (S680C2*), 0, "S680C1");
    check_field_offset(lv, s680c1f0, ABISELECT(1352,1040), "S680C1.s680c1f0");
    check_field_offset(lv, s680c1f1, ABISELECT(1648,1264), "S680C1.s680c1f1");
    test_class_info(&lv, &cd_S680C1);
    dp->~S680C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS680C1(Test_S680C1, "S680C1", ABISELECT(1656,1268));

#else // __cplusplus

extern void _ZN6S680C1C1Ev();
extern void _ZN6S680C1D1Ev();
Name_Map name_map_S680C1[] = {
  NSPAIR(_ZN6S680C1C1Ev),
  NSPAIR(_ZN6S680C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S680C5;
extern VTBL_ENTRY _ZTI6S680C5[];
extern  VTBL_ENTRY _ZTV6S680C5[];
extern Class_Descriptor cd_S680C4;
extern VTBL_ENTRY _ZTI6S680C4[];
extern  VTBL_ENTRY _ZTV6S680C4[];
extern Class_Descriptor cd_S680C3;
extern VTBL_ENTRY _ZTI6S680C3[];
extern  VTBL_ENTRY _ZTV6S680C3[];
extern Class_Descriptor cd_S680C2;
extern VTBL_ENTRY _ZTI6S680C2[];
extern  VTBL_ENTRY _ZTV6S680C2[];
static Base_Class bases_S680C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S680C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S680C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S680C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S680C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S680C1[];
extern void _ZN6S680C1D1Ev();
extern void _ZN6S680C1D0Ev();
extern void _ZN6S680C52v6Ev();
extern void _ZN6S680C52v7Ev();
extern void _ZN6S680C52v8Ev();
extern void _ZN6S680C52v9Ev();
extern void _ZN6S680C53v10Ev();
extern void _ZN6S680C53v11Ev();
extern void _ZN6S680C53v12Ev();
extern void _ZN6S680C53v13Ev();
extern void _ZN6S680C53v14Ev();
extern void _ZN6S680C53v15Ev();
extern void _ZN6S680C43v16Ev();
extern void _ZN6S680C43v17Ev();
extern void _ZN6S680C43v18Ev();
extern void _ZN6S680C43v19Ev();
extern void _ZN6S680C43v20Ev();
extern void _ZN6S680C43v21Ev();
extern void _ZN6S680C43v22Ev();
extern void _ZN6S680C43v23Ev();
extern void _ZN6S680C43v24Ev();
extern void _ZN6S680C43v25Ev();
extern void _ZN6S680C43v26Ev();
extern void _ZN6S680C43v27Ev();
extern void _ZN6S680C43v28Ev();
extern void _ZN6S680C43v29Ev();
extern void _ZN6S680C33v30Ev();
extern void _ZN6S680C33v31Ev();
extern void _ZN6S680C33v32Ev();
extern void _ZN6S680C33v33Ev();
extern void _ZN6S680C23v34Ev();
extern void _ZN6S680C23v35Ev();
extern void _ZN6S680C23v36Ev();
extern void _ZN6S680C23v37Ev();
extern void _ZN6S680C12v1Ev();
extern void _ZN6S680C12v2Ev();
extern void _ZN6S680C12v3Ev();
extern void _ZN6S680C12v4Ev();
extern void _ZN6S680C12v5Ev();
static  VTBL_ENTRY vtc_S680C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S680C1[0]),
  (VTBL_ENTRY)&_ZN6S680C1D1Ev,
  (VTBL_ENTRY)&_ZN6S680C1D0Ev,
  (VTBL_ENTRY)&_ZN6S680C52v6Ev,
  (VTBL_ENTRY)&_ZN6S680C52v7Ev,
  (VTBL_ENTRY)&_ZN6S680C52v8Ev,
  (VTBL_ENTRY)&_ZN6S680C52v9Ev,
  (VTBL_ENTRY)&_ZN6S680C53v10Ev,
  (VTBL_ENTRY)&_ZN6S680C53v11Ev,
  (VTBL_ENTRY)&_ZN6S680C53v12Ev,
  (VTBL_ENTRY)&_ZN6S680C53v13Ev,
  (VTBL_ENTRY)&_ZN6S680C53v14Ev,
  (VTBL_ENTRY)&_ZN6S680C53v15Ev,
  (VTBL_ENTRY)&_ZN6S680C43v16Ev,
  (VTBL_ENTRY)&_ZN6S680C43v17Ev,
  (VTBL_ENTRY)&_ZN6S680C43v18Ev,
  (VTBL_ENTRY)&_ZN6S680C43v19Ev,
  (VTBL_ENTRY)&_ZN6S680C43v20Ev,
  (VTBL_ENTRY)&_ZN6S680C43v21Ev,
  (VTBL_ENTRY)&_ZN6S680C43v22Ev,
  (VTBL_ENTRY)&_ZN6S680C43v23Ev,
  (VTBL_ENTRY)&_ZN6S680C43v24Ev,
  (VTBL_ENTRY)&_ZN6S680C43v25Ev,
  (VTBL_ENTRY)&_ZN6S680C43v26Ev,
  (VTBL_ENTRY)&_ZN6S680C43v27Ev,
  (VTBL_ENTRY)&_ZN6S680C43v28Ev,
  (VTBL_ENTRY)&_ZN6S680C43v29Ev,
  (VTBL_ENTRY)&_ZN6S680C33v30Ev,
  (VTBL_ENTRY)&_ZN6S680C33v31Ev,
  (VTBL_ENTRY)&_ZN6S680C33v32Ev,
  (VTBL_ENTRY)&_ZN6S680C33v33Ev,
  (VTBL_ENTRY)&_ZN6S680C23v34Ev,
  (VTBL_ENTRY)&_ZN6S680C23v35Ev,
  (VTBL_ENTRY)&_ZN6S680C23v36Ev,
  (VTBL_ENTRY)&_ZN6S680C23v37Ev,
  (VTBL_ENTRY)&_ZN6S680C12v1Ev,
  (VTBL_ENTRY)&_ZN6S680C12v2Ev,
  (VTBL_ENTRY)&_ZN6S680C12v3Ev,
  (VTBL_ENTRY)&_ZN6S680C12v4Ev,
  (VTBL_ENTRY)&_ZN6S680C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S680C1[];
extern  VTBL_ENTRY _ZTV6S680C1[];
Class_Descriptor cd_S680C1 = {  "S680C1", // class name
  bases_S680C1, 4,
  &(vtc_S680C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1656,1268), // object size
  NSPAIRA(_ZTI6S680C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S680C1),41, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S597C5  {
  void *s597c5f0[2];
  ::S10103C13_nt s597c5f1;
  void *s597c5f2;
  virtual  ~S597C5(); // _ZN6S597C5D1Ev
  virtual void  v4(); // _ZN6S597C52v4Ev
  virtual void  v5(); // _ZN6S597C52v5Ev
  virtual void  v6(); // _ZN6S597C52v6Ev
  virtual void  v7(); // _ZN6S597C52v7Ev
  virtual void  v8(); // _ZN6S597C52v8Ev
  virtual void  v9(); // _ZN6S597C52v9Ev
  virtual void  v10(); // _ZN6S597C53v10Ev
  virtual void  v11(); // _ZN6S597C53v11Ev
  virtual void  v12(); // _ZN6S597C53v12Ev
  virtual void  v13(); // _ZN6S597C53v13Ev
  S597C5(); // tgen
};
//SIG(-1 S597C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S597C5 ::~S597C5(){ note_dtor("S597C5", this);}
void  S597C5 ::v4(){vfunc_called(this, "_ZN6S597C52v4Ev");}
void  S597C5 ::v5(){vfunc_called(this, "_ZN6S597C52v5Ev");}
void  S597C5 ::v6(){vfunc_called(this, "_ZN6S597C52v6Ev");}
void  S597C5 ::v7(){vfunc_called(this, "_ZN6S597C52v7Ev");}
void  S597C5 ::v8(){vfunc_called(this, "_ZN6S597C52v8Ev");}
void  S597C5 ::v9(){vfunc_called(this, "_ZN6S597C52v9Ev");}
void  S597C5 ::v10(){vfunc_called(this, "_ZN6S597C53v10Ev");}
void  S597C5 ::v11(){vfunc_called(this, "_ZN6S597C53v11Ev");}
void  S597C5 ::v12(){vfunc_called(this, "_ZN6S597C53v12Ev");}
void  S597C5 ::v13(){vfunc_called(this, "_ZN6S597C53v13Ev");}
S597C5 ::S597C5(){ note_ctor("S597C5", this);} // tgen

static void Test_S597C5()
{
  extern Class_Descriptor cd_S597C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S597C5, buf);
    S597C5 *dp, &lv = *(dp=new (buf) S597C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S597C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S597C5)");
    check_field_offset(lv, s597c5f0, ABISELECT(8,4), "S597C5.s597c5f0");
    check_field_offset(lv, s597c5f1, ABISELECT(24,12), "S597C5.s597c5f1");
    check_field_offset(lv, s597c5f2, ABISELECT(48,28), "S597C5.s597c5f2");
    test_class_info(&lv, &cd_S597C5);
    dp->~S597C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS597C5(Test_S597C5, "S597C5", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN6S597C5C1Ev();
extern void _ZN6S597C5D1Ev();
Name_Map name_map_S597C5[] = {
  NSPAIR(_ZN6S597C5C1Ev),
  NSPAIR(_ZN6S597C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S597C5[];
extern void _ZN6S597C5D1Ev();
extern void _ZN6S597C5D0Ev();
extern void _ZN6S597C52v4Ev();
extern void _ZN6S597C52v5Ev();
extern void _ZN6S597C52v6Ev();
extern void _ZN6S597C52v7Ev();
extern void _ZN6S597C52v8Ev();
extern void _ZN6S597C52v9Ev();
extern void _ZN6S597C53v10Ev();
extern void _ZN6S597C53v11Ev();
extern void _ZN6S597C53v12Ev();
extern void _ZN6S597C53v13Ev();
static  VTBL_ENTRY vtc_S597C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S597C5[0]),
  (VTBL_ENTRY)&_ZN6S597C5D1Ev,
  (VTBL_ENTRY)&_ZN6S597C5D0Ev,
  (VTBL_ENTRY)&_ZN6S597C52v4Ev,
  (VTBL_ENTRY)&_ZN6S597C52v5Ev,
  (VTBL_ENTRY)&_ZN6S597C52v6Ev,
  (VTBL_ENTRY)&_ZN6S597C52v7Ev,
  (VTBL_ENTRY)&_ZN6S597C52v8Ev,
  (VTBL_ENTRY)&_ZN6S597C52v9Ev,
  (VTBL_ENTRY)&_ZN6S597C53v10Ev,
  (VTBL_ENTRY)&_ZN6S597C53v11Ev,
  (VTBL_ENTRY)&_ZN6S597C53v12Ev,
  (VTBL_ENTRY)&_ZN6S597C53v13Ev,
};
extern VTBL_ENTRY _ZTI6S597C5[];
extern  VTBL_ENTRY _ZTV6S597C5[];
Class_Descriptor cd_S597C5 = {  "S597C5", // class name
  0,0,//no base classes
  &(vtc_S597C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI6S597C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S597C5),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S597C4  : S597C5 {
  ::S10103C86 s597c4f0;
  ::S10103C106 s597c4f1;
  ::S10103C82_nt s597c4f2;
  ::S10103C13_nt s597c4f3;
  virtual  ~S597C4(); // _ZN6S597C4D1Ev
  virtual void  v14(); // _ZN6S597C43v14Ev
  virtual void  v15(); // _ZN6S597C43v15Ev
  virtual void  v16(); // _ZN6S597C43v16Ev
  virtual void  v17(); // _ZN6S597C43v17Ev
  virtual void  v18(); // _ZN6S597C43v18Ev
  virtual void  v19(); // _ZN6S597C43v19Ev
  virtual void  v20(); // _ZN6S597C43v20Ev
  virtual void  v21(); // _ZN6S597C43v21Ev
  virtual void  v22(); // _ZN6S597C43v22Ev
  virtual void  v23(); // _ZN6S597C43v23Ev
  virtual void  v24(); // _ZN6S597C43v24Ev
  virtual void  v25(); // _ZN6S597C43v25Ev
  virtual void  v26(); // _ZN6S597C43v26Ev
  virtual void  v27(); // _ZN6S597C43v27Ev
  S597C4(); // tgen
};
//SIG(-1 S597C4) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S597C4 ::~S597C4(){ note_dtor("S597C4", this);}
void  S597C4 ::v14(){vfunc_called(this, "_ZN6S597C43v14Ev");}
void  S597C4 ::v15(){vfunc_called(this, "_ZN6S597C43v15Ev");}
void  S597C4 ::v16(){vfunc_called(this, "_ZN6S597C43v16Ev");}
void  S597C4 ::v17(){vfunc_called(this, "_ZN6S597C43v17Ev");}
void  S597C4 ::v18(){vfunc_called(this, "_ZN6S597C43v18Ev");}
void  S597C4 ::v19(){vfunc_called(this, "_ZN6S597C43v19Ev");}
void  S597C4 ::v20(){vfunc_called(this, "_ZN6S597C43v20Ev");}
void  S597C4 ::v21(){vfunc_called(this, "_ZN6S597C43v21Ev");}
void  S597C4 ::v22(){vfunc_called(this, "_ZN6S597C43v22Ev");}
void  S597C4 ::v23(){vfunc_called(this, "_ZN6S597C43v23Ev");}
void  S597C4 ::v24(){vfunc_called(this, "_ZN6S597C43v24Ev");}
void  S597C4 ::v25(){vfunc_called(this, "_ZN6S597C43v25Ev");}
void  S597C4 ::v26(){vfunc_called(this, "_ZN6S597C43v26Ev");}
void  S597C4 ::v27(){vfunc_called(this, "_ZN6S597C43v27Ev");}
S597C4 ::S597C4(){ note_ctor("S597C4", this);} // tgen

static void Test_S597C4()
{
  extern Class_Descriptor cd_S597C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S597C4, buf);
    S597C4 *dp, &lv = *(dp=new (buf) S597C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S597C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S597C4)");
    check_base_class_offset(lv, (S597C5*), 0, "S597C4");
    check_field_offset(lv, s597c4f0, ABISELECT(56,32), "S597C4.s597c4f0");
    check_field_offset(lv, s597c4f1, ABISELECT(72,44), "S597C4.s597c4f1");
    check_field_offset(lv, s597c4f2, ABISELECT(96,60), "S597C4.s597c4f2");
    check_field_offset(lv, s597c4f3, ABISELECT(112,76), "S597C4.s597c4f3");
    test_class_info(&lv, &cd_S597C4);
    dp->~S597C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS597C4(Test_S597C4, "S597C4", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN6S597C4C1Ev();
extern void _ZN6S597C4D1Ev();
Name_Map name_map_S597C4[] = {
  NSPAIR(_ZN6S597C4C1Ev),
  NSPAIR(_ZN6S597C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S597C5;
extern VTBL_ENTRY _ZTI6S597C5[];
extern  VTBL_ENTRY _ZTV6S597C5[];
static Base_Class bases_S597C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S597C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S597C4[];
extern void _ZN6S597C4D1Ev();
extern void _ZN6S597C4D0Ev();
extern void _ZN6S597C52v4Ev();
extern void _ZN6S597C52v5Ev();
extern void _ZN6S597C52v6Ev();
extern void _ZN6S597C52v7Ev();
extern void _ZN6S597C52v8Ev();
extern void _ZN6S597C52v9Ev();
extern void _ZN6S597C53v10Ev();
extern void _ZN6S597C53v11Ev();
extern void _ZN6S597C53v12Ev();
extern void _ZN6S597C53v13Ev();
extern void _ZN6S597C43v14Ev();
extern void _ZN6S597C43v15Ev();
extern void _ZN6S597C43v16Ev();
extern void _ZN6S597C43v17Ev();
extern void _ZN6S597C43v18Ev();
extern void _ZN6S597C43v19Ev();
extern void _ZN6S597C43v20Ev();
extern void _ZN6S597C43v21Ev();
extern void _ZN6S597C43v22Ev();
extern void _ZN6S597C43v23Ev();
extern void _ZN6S597C43v24Ev();
extern void _ZN6S597C43v25Ev();
extern void _ZN6S597C43v26Ev();
extern void _ZN6S597C43v27Ev();
static  VTBL_ENTRY vtc_S597C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S597C4[0]),
  (VTBL_ENTRY)&_ZN6S597C4D1Ev,
  (VTBL_ENTRY)&_ZN6S597C4D0Ev,
  (VTBL_ENTRY)&_ZN6S597C52v4Ev,
  (VTBL_ENTRY)&_ZN6S597C52v5Ev,
  (VTBL_ENTRY)&_ZN6S597C52v6Ev,
  (VTBL_ENTRY)&_ZN6S597C52v7Ev,
  (VTBL_ENTRY)&_ZN6S597C52v8Ev,
  (VTBL_ENTRY)&_ZN6S597C52v9Ev,
  (VTBL_ENTRY)&_ZN6S597C53v10Ev,
  (VTBL_ENTRY)&_ZN6S597C53v11Ev,
  (VTBL_ENTRY)&_ZN6S597C53v12Ev,
  (VTBL_ENTRY)&_ZN6S597C53v13Ev,
  (VTBL_ENTRY)&_ZN6S597C43v14Ev,
  (VTBL_ENTRY)&_ZN6S597C43v15Ev,
  (VTBL_ENTRY)&_ZN6S597C43v16Ev,
  (VTBL_ENTRY)&_ZN6S597C43v17Ev,
  (VTBL_ENTRY)&_ZN6S597C43v18Ev,
  (VTBL_ENTRY)&_ZN6S597C43v19Ev,
  (VTBL_ENTRY)&_ZN6S597C43v20Ev,
  (VTBL_ENTRY)&_ZN6S597C43v21Ev,
  (VTBL_ENTRY)&_ZN6S597C43v22Ev,
  (VTBL_ENTRY)&_ZN6S597C43v23Ev,
  (VTBL_ENTRY)&_ZN6S597C43v24Ev,
  (VTBL_ENTRY)&_ZN6S597C43v25Ev,
  (VTBL_ENTRY)&_ZN6S597C43v26Ev,
  (VTBL_ENTRY)&_ZN6S597C43v27Ev,
};
extern VTBL_ENTRY _ZTI6S597C4[];
extern  VTBL_ENTRY _ZTV6S597C4[];
Class_Descriptor cd_S597C4 = {  "S597C4", // class name
  bases_S597C4, 1,
  &(vtc_S597C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI6S597C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S597C4),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S597C3  : S597C4 {
  int s597c3f0;
  char s597c3f1[2];
  int s597c3f2;
  virtual void  v28(); // _ZN6S597C33v28Ev
  virtual void  v29(); // _ZN6S597C33v29Ev
  virtual void  v30(); // _ZN6S597C33v30Ev
  virtual void  v31(); // _ZN6S597C33v31Ev
  ~S597C3(); // tgen
  S597C3(); // tgen
};
//SIG(-1 S597C3) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 Fi Fc[2] Fi}


void  S597C3 ::v28(){vfunc_called(this, "_ZN6S597C33v28Ev");}
void  S597C3 ::v29(){vfunc_called(this, "_ZN6S597C33v29Ev");}
void  S597C3 ::v30(){vfunc_called(this, "_ZN6S597C33v30Ev");}
void  S597C3 ::v31(){vfunc_called(this, "_ZN6S597C33v31Ev");}
S597C3 ::~S597C3(){ note_dtor("S597C3", this);} // tgen
S597C3 ::S597C3(){ note_ctor("S597C3", this);} // tgen

static void Test_S597C3()
{
  extern Class_Descriptor cd_S597C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S597C3, buf);
    S597C3 *dp, &lv = *(dp=new (buf) S597C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S597C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S597C3)");
    check_base_class_offset(lv, (S597C5*)(S597C4*), 0, "S597C3");
    check_base_class_offset(lv, (S597C4*), 0, "S597C3");
    check_field_offset(lv, s597c3f0, ABISELECT(136,92), "S597C3.s597c3f0");
    check_field_offset(lv, s597c3f1, ABISELECT(140,96), "S597C3.s597c3f1");
    check_field_offset(lv, s597c3f2, ABISELECT(144,100), "S597C3.s597c3f2");
    test_class_info(&lv, &cd_S597C3);
    dp->~S597C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS597C3(Test_S597C3, "S597C3", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN6S597C3C1Ev();
extern void _ZN6S597C3D1Ev();
Name_Map name_map_S597C3[] = {
  NSPAIR(_ZN6S597C3C1Ev),
  NSPAIR(_ZN6S597C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S597C5;
extern VTBL_ENTRY _ZTI6S597C5[];
extern  VTBL_ENTRY _ZTV6S597C5[];
extern Class_Descriptor cd_S597C4;
extern VTBL_ENTRY _ZTI6S597C4[];
extern  VTBL_ENTRY _ZTV6S597C4[];
static Base_Class bases_S597C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S597C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S597C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S597C3[];
extern void _ZN6S597C3D1Ev();
extern void _ZN6S597C3D0Ev();
extern void _ZN6S597C52v4Ev();
extern void _ZN6S597C52v5Ev();
extern void _ZN6S597C52v6Ev();
extern void _ZN6S597C52v7Ev();
extern void _ZN6S597C52v8Ev();
extern void _ZN6S597C52v9Ev();
extern void _ZN6S597C53v10Ev();
extern void _ZN6S597C53v11Ev();
extern void _ZN6S597C53v12Ev();
extern void _ZN6S597C53v13Ev();
extern void _ZN6S597C43v14Ev();
extern void _ZN6S597C43v15Ev();
extern void _ZN6S597C43v16Ev();
extern void _ZN6S597C43v17Ev();
extern void _ZN6S597C43v18Ev();
extern void _ZN6S597C43v19Ev();
extern void _ZN6S597C43v20Ev();
extern void _ZN6S597C43v21Ev();
extern void _ZN6S597C43v22Ev();
extern void _ZN6S597C43v23Ev();
extern void _ZN6S597C43v24Ev();
extern void _ZN6S597C43v25Ev();
extern void _ZN6S597C43v26Ev();
extern void _ZN6S597C43v27Ev();
extern void _ZN6S597C33v28Ev();
extern void _ZN6S597C33v29Ev();
extern void _ZN6S597C33v30Ev();
extern void _ZN6S597C33v31Ev();
static  VTBL_ENTRY vtc_S597C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S597C3[0]),
  (VTBL_ENTRY)&_ZN6S597C3D1Ev,
  (VTBL_ENTRY)&_ZN6S597C3D0Ev,
  (VTBL_ENTRY)&_ZN6S597C52v4Ev,
  (VTBL_ENTRY)&_ZN6S597C52v5Ev,
  (VTBL_ENTRY)&_ZN6S597C52v6Ev,
  (VTBL_ENTRY)&_ZN6S597C52v7Ev,
  (VTBL_ENTRY)&_ZN6S597C52v8Ev,
  (VTBL_ENTRY)&_ZN6S597C52v9Ev,
  (VTBL_ENTRY)&_ZN6S597C53v10Ev,
  (VTBL_ENTRY)&_ZN6S597C53v11Ev,
  (VTBL_ENTRY)&_ZN6S597C53v12Ev,
  (VTBL_ENTRY)&_ZN6S597C53v13Ev,
  (VTBL_ENTRY)&_ZN6S597C43v14Ev,
  (VTBL_ENTRY)&_ZN6S597C43v15Ev,
  (VTBL_ENTRY)&_ZN6S597C43v16Ev,
  (VTBL_ENTRY)&_ZN6S597C43v17Ev,
  (VTBL_ENTRY)&_ZN6S597C43v18Ev,
  (VTBL_ENTRY)&_ZN6S597C43v19Ev,
  (VTBL_ENTRY)&_ZN6S597C43v20Ev,
  (VTBL_ENTRY)&_ZN6S597C43v21Ev,
  (VTBL_ENTRY)&_ZN6S597C43v22Ev,
  (VTBL_ENTRY)&_ZN6S597C43v23Ev,
  (VTBL_ENTRY)&_ZN6S597C43v24Ev,
  (VTBL_ENTRY)&_ZN6S597C43v25Ev,
  (VTBL_ENTRY)&_ZN6S597C43v26Ev,
  (VTBL_ENTRY)&_ZN6S597C43v27Ev,
  (VTBL_ENTRY)&_ZN6S597C33v28Ev,
  (VTBL_ENTRY)&_ZN6S597C33v29Ev,
  (VTBL_ENTRY)&_ZN6S597C33v30Ev,
  (VTBL_ENTRY)&_ZN6S597C33v31Ev,
};
extern VTBL_ENTRY _ZTI6S597C3[];
extern  VTBL_ENTRY _ZTV6S597C3[];
Class_Descriptor cd_S597C3 = {  "S597C3", // class name
  bases_S597C3, 2,
  &(vtc_S597C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI6S597C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S597C3),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S597C2  : S597C3 {
  ::S10103C84 s597c2f0;
  ::S679C23 s597c2f1;
  ::S10103C84 s597c2f2;
  ::S10103C84 s597c2f3;
  int s597c2f4;
  void *s597c2f5;
  int s597c2f6[2];
  virtual  ~S597C2(); // _ZN6S597C2D1Ev
  virtual void  v32(); // _ZN6S597C23v32Ev
  virtual void  v33(); // _ZN6S597C23v33Ev
  virtual void  v34(); // _ZN6S597C23v34Ev
  virtual void  v35(); // _ZN6S597C23v35Ev
  S597C2(); // tgen
};
//SIG(-1 S597C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 Fi Fc[2] Fi} vd v1 v2 v3 v4 FC14{ BC15{ BC16{ vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fp[2] FC5 Fp} vd v47 v48 v49 v50 v51 v52 Fp Fi FC8 FC12 Fi} vd v33 v34 v35 v36 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC17{ BC18{ BC19{ vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fp[2] FC5 Fp} vd v67 v68 v69 v70 v71 v72 Fp Fi FC20{ m Fp Fi FC21{ m} FC21} FC12 Fi} vd v53 v54 v55 v56 FC22{ m FC13} FC22 Fi[6] FC23{ m FC24{ m FL}} FC23 Fc[7] Fi[2] FC12 FC12 FC12 FC12 FC12 Fc[7]} FC14 FC14 Fi Fp Fi[2]}


 S597C2 ::~S597C2(){ note_dtor("S597C2", this);}
void  S597C2 ::v32(){vfunc_called(this, "_ZN6S597C23v32Ev");}
void  S597C2 ::v33(){vfunc_called(this, "_ZN6S597C23v33Ev");}
void  S597C2 ::v34(){vfunc_called(this, "_ZN6S597C23v34Ev");}
void  S597C2 ::v35(){vfunc_called(this, "_ZN6S597C23v35Ev");}
S597C2 ::S597C2(){ note_ctor("S597C2", this);} // tgen

static void Test_S597C2()
{
  extern Class_Descriptor cd_S597C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(170,261)];
    init_test(&cd_S597C2, buf);
    S597C2 *dp, &lv = *(dp=new (buf) S597C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1352,1040), "sizeof(S597C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S597C2)");
    check_base_class_offset(lv, (S597C5*)(S597C4*)(S597C3*), 0, "S597C2");
    check_base_class_offset(lv, (S597C4*)(S597C3*), 0, "S597C2");
    check_base_class_offset(lv, (S597C3*), 0, "S597C2");
    check_field_offset(lv, s597c2f0, ABISELECT(152,104), "S597C2.s597c2f0");
    check_field_offset(lv, s597c2f1, ABISELECT(448,328), "S597C2.s597c2f1");
    check_field_offset(lv, s597c2f2, ABISELECT(736,576), "S597C2.s597c2f2");
    check_field_offset(lv, s597c2f3, ABISELECT(1032,800), "S597C2.s597c2f3");
    check_field_offset(lv, s597c2f4, ABISELECT(1328,1024), "S597C2.s597c2f4");
    check_field_offset(lv, s597c2f5, ABISELECT(1336,1028), "S597C2.s597c2f5");
    check_field_offset(lv, s597c2f6, ABISELECT(1344,1032), "S597C2.s597c2f6");
    test_class_info(&lv, &cd_S597C2);
    dp->~S597C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS597C2(Test_S597C2, "S597C2", ABISELECT(1352,1040));

#else // __cplusplus

extern void _ZN6S597C2C1Ev();
extern void _ZN6S597C2D1Ev();
Name_Map name_map_S597C2[] = {
  NSPAIR(_ZN6S597C2C1Ev),
  NSPAIR(_ZN6S597C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S597C5;
extern VTBL_ENTRY _ZTI6S597C5[];
extern  VTBL_ENTRY _ZTV6S597C5[];
extern Class_Descriptor cd_S597C4;
extern VTBL_ENTRY _ZTI6S597C4[];
extern  VTBL_ENTRY _ZTV6S597C4[];
extern Class_Descriptor cd_S597C3;
extern VTBL_ENTRY _ZTI6S597C3[];
extern  VTBL_ENTRY _ZTV6S597C3[];
static Base_Class bases_S597C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S597C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S597C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S597C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S597C2[];
extern void _ZN6S597C2D1Ev();
extern void _ZN6S597C2D0Ev();
extern void _ZN6S597C52v4Ev();
extern void _ZN6S597C52v5Ev();
extern void _ZN6S597C52v6Ev();
extern void _ZN6S597C52v7Ev();
extern void _ZN6S597C52v8Ev();
extern void _ZN6S597C52v9Ev();
extern void _ZN6S597C53v10Ev();
extern void _ZN6S597C53v11Ev();
extern void _ZN6S597C53v12Ev();
extern void _ZN6S597C53v13Ev();
extern void _ZN6S597C43v14Ev();
extern void _ZN6S597C43v15Ev();
extern void _ZN6S597C43v16Ev();
extern void _ZN6S597C43v17Ev();
extern void _ZN6S597C43v18Ev();
extern void _ZN6S597C43v19Ev();
extern void _ZN6S597C43v20Ev();
extern void _ZN6S597C43v21Ev();
extern void _ZN6S597C43v22Ev();
extern void _ZN6S597C43v23Ev();
extern void _ZN6S597C43v24Ev();
extern void _ZN6S597C43v25Ev();
extern void _ZN6S597C43v26Ev();
extern void _ZN6S597C43v27Ev();
extern void _ZN6S597C33v28Ev();
extern void _ZN6S597C33v29Ev();
extern void _ZN6S597C33v30Ev();
extern void _ZN6S597C33v31Ev();
extern void _ZN6S597C23v32Ev();
extern void _ZN6S597C23v33Ev();
extern void _ZN6S597C23v34Ev();
extern void _ZN6S597C23v35Ev();
static  VTBL_ENTRY vtc_S597C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S597C2[0]),
  (VTBL_ENTRY)&_ZN6S597C2D1Ev,
  (VTBL_ENTRY)&_ZN6S597C2D0Ev,
  (VTBL_ENTRY)&_ZN6S597C52v4Ev,
  (VTBL_ENTRY)&_ZN6S597C52v5Ev,
  (VTBL_ENTRY)&_ZN6S597C52v6Ev,
  (VTBL_ENTRY)&_ZN6S597C52v7Ev,
  (VTBL_ENTRY)&_ZN6S597C52v8Ev,
  (VTBL_ENTRY)&_ZN6S597C52v9Ev,
  (VTBL_ENTRY)&_ZN6S597C53v10Ev,
  (VTBL_ENTRY)&_ZN6S597C53v11Ev,
  (VTBL_ENTRY)&_ZN6S597C53v12Ev,
  (VTBL_ENTRY)&_ZN6S597C53v13Ev,
  (VTBL_ENTRY)&_ZN6S597C43v14Ev,
  (VTBL_ENTRY)&_ZN6S597C43v15Ev,
  (VTBL_ENTRY)&_ZN6S597C43v16Ev,
  (VTBL_ENTRY)&_ZN6S597C43v17Ev,
  (VTBL_ENTRY)&_ZN6S597C43v18Ev,
  (VTBL_ENTRY)&_ZN6S597C43v19Ev,
  (VTBL_ENTRY)&_ZN6S597C43v20Ev,
  (VTBL_ENTRY)&_ZN6S597C43v21Ev,
  (VTBL_ENTRY)&_ZN6S597C43v22Ev,
  (VTBL_ENTRY)&_ZN6S597C43v23Ev,
  (VTBL_ENTRY)&_ZN6S597C43v24Ev,
  (VTBL_ENTRY)&_ZN6S597C43v25Ev,
  (VTBL_ENTRY)&_ZN6S597C43v26Ev,
  (VTBL_ENTRY)&_ZN6S597C43v27Ev,
  (VTBL_ENTRY)&_ZN6S597C33v28Ev,
  (VTBL_ENTRY)&_ZN6S597C33v29Ev,
  (VTBL_ENTRY)&_ZN6S597C33v30Ev,
  (VTBL_ENTRY)&_ZN6S597C33v31Ev,
  (VTBL_ENTRY)&_ZN6S597C23v32Ev,
  (VTBL_ENTRY)&_ZN6S597C23v33Ev,
  (VTBL_ENTRY)&_ZN6S597C23v34Ev,
  (VTBL_ENTRY)&_ZN6S597C23v35Ev,
};
extern VTBL_ENTRY _ZTI6S597C2[];
extern  VTBL_ENTRY _ZTV6S597C2[];
Class_Descriptor cd_S597C2 = {  "S597C2", // class name
  bases_S597C2, 3,
  &(vtc_S597C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1352,1040), // object size
  NSPAIRA(_ZTI6S597C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S597C2),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S597C1  : S597C2 {
  ::S10103C84 s597c1f0;
  virtual  ~S597C1(); // _ZN6S597C1D1Ev
  virtual void  v1(); // _ZN6S597C12v1Ev
  virtual void  v2(); // _ZN6S597C12v2Ev
  virtual void  v3(); // _ZN6S597C12v3Ev
  S597C1(); // tgen
};
//SIG(1 S597C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp[2] FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fp} vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 FC9{ m Fp Fi FC10{ m} FC11{ m}} FC12{ m Fp Fi[2] FC11} FC13{ m FC14{ m FL[2]}} FC6} v28 v29 v30 v31 Fi Fc[2] Fi} vd v32 v33 v34 v35 FC15{ BC16{ BC17{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 Fp[2] FC6 Fp} vd v50 v51 v52 v53 v54 v55 Fp Fi FC9 FC13 Fi} vd v36 v37 v38 v39 FC6[4] FC13 FC13 FC13 FC13 Fi[6]} FC18{ BC19{ BC20{ vd v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fp[2] FC6 Fp} vd v70 v71 v72 v73 v74 v75 Fp Fi FC21{ m Fp Fi FC22{ m} FC22} FC13 Fi} vd v56 v57 v58 v59 FC23{ m FC14} FC23 Fi[6] FC24{ m FC25{ m FL}} FC24 Fc[7] Fi[2] FC13 FC13 FC13 FC13 FC13 Fc[7]} FC15 FC15 Fi Fp Fi[2]} vd v1 v2 v3 FC15}


 S597C1 ::~S597C1(){ note_dtor("S597C1", this);}
void  S597C1 ::v1(){vfunc_called(this, "_ZN6S597C12v1Ev");}
void  S597C1 ::v2(){vfunc_called(this, "_ZN6S597C12v2Ev");}
void  S597C1 ::v3(){vfunc_called(this, "_ZN6S597C12v3Ev");}
S597C1 ::S597C1(){ note_ctor("S597C1", this);} // tgen

static void Test_S597C1()
{
  extern Class_Descriptor cd_S597C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(207,317)];
    init_test(&cd_S597C1, buf);
    S597C1 *dp, &lv = *(dp=new (buf) S597C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1648,1264), "sizeof(S597C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S597C1)");
    check_base_class_offset(lv, (S597C5*)(S597C4*)(S597C3*)(S597C2*), 0, "S597C1");
    check_base_class_offset(lv, (S597C4*)(S597C3*)(S597C2*), 0, "S597C1");
    check_base_class_offset(lv, (S597C3*)(S597C2*), 0, "S597C1");
    check_base_class_offset(lv, (S597C2*), 0, "S597C1");
    check_field_offset(lv, s597c1f0, ABISELECT(1352,1040), "S597C1.s597c1f0");
    test_class_info(&lv, &cd_S597C1);
    dp->~S597C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS597C1(Test_S597C1, "S597C1", ABISELECT(1648,1264));

#else // __cplusplus

extern void _ZN6S597C1C1Ev();
extern void _ZN6S597C1D1Ev();
Name_Map name_map_S597C1[] = {
  NSPAIR(_ZN6S597C1C1Ev),
  NSPAIR(_ZN6S597C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S597C5;
extern VTBL_ENTRY _ZTI6S597C5[];
extern  VTBL_ENTRY _ZTV6S597C5[];
extern Class_Descriptor cd_S597C4;
extern VTBL_ENTRY _ZTI6S597C4[];
extern  VTBL_ENTRY _ZTV6S597C4[];
extern Class_Descriptor cd_S597C3;
extern VTBL_ENTRY _ZTI6S597C3[];
extern  VTBL_ENTRY _ZTV6S597C3[];
extern Class_Descriptor cd_S597C2;
extern VTBL_ENTRY _ZTI6S597C2[];
extern  VTBL_ENTRY _ZTV6S597C2[];
static Base_Class bases_S597C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S597C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S597C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S597C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S597C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S597C1[];
extern void _ZN6S597C1D1Ev();
extern void _ZN6S597C1D0Ev();
extern void _ZN6S597C52v4Ev();
extern void _ZN6S597C52v5Ev();
extern void _ZN6S597C52v6Ev();
extern void _ZN6S597C52v7Ev();
extern void _ZN6S597C52v8Ev();
extern void _ZN6S597C52v9Ev();
extern void _ZN6S597C53v10Ev();
extern void _ZN6S597C53v11Ev();
extern void _ZN6S597C53v12Ev();
extern void _ZN6S597C53v13Ev();
extern void _ZN6S597C43v14Ev();
extern void _ZN6S597C43v15Ev();
extern void _ZN6S597C43v16Ev();
extern void _ZN6S597C43v17Ev();
extern void _ZN6S597C43v18Ev();
extern void _ZN6S597C43v19Ev();
extern void _ZN6S597C43v20Ev();
extern void _ZN6S597C43v21Ev();
extern void _ZN6S597C43v22Ev();
extern void _ZN6S597C43v23Ev();
extern void _ZN6S597C43v24Ev();
extern void _ZN6S597C43v25Ev();
extern void _ZN6S597C43v26Ev();
extern void _ZN6S597C43v27Ev();
extern void _ZN6S597C33v28Ev();
extern void _ZN6S597C33v29Ev();
extern void _ZN6S597C33v30Ev();
extern void _ZN6S597C33v31Ev();
extern void _ZN6S597C23v32Ev();
extern void _ZN6S597C23v33Ev();
extern void _ZN6S597C23v34Ev();
extern void _ZN6S597C23v35Ev();
extern void _ZN6S597C12v1Ev();
extern void _ZN6S597C12v2Ev();
extern void _ZN6S597C12v3Ev();
static  VTBL_ENTRY vtc_S597C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S597C1[0]),
  (VTBL_ENTRY)&_ZN6S597C1D1Ev,
  (VTBL_ENTRY)&_ZN6S597C1D0Ev,
  (VTBL_ENTRY)&_ZN6S597C52v4Ev,
  (VTBL_ENTRY)&_ZN6S597C52v5Ev,
  (VTBL_ENTRY)&_ZN6S597C52v6Ev,
  (VTBL_ENTRY)&_ZN6S597C52v7Ev,
  (VTBL_ENTRY)&_ZN6S597C52v8Ev,
  (VTBL_ENTRY)&_ZN6S597C52v9Ev,
  (VTBL_ENTRY)&_ZN6S597C53v10Ev,
  (VTBL_ENTRY)&_ZN6S597C53v11Ev,
  (VTBL_ENTRY)&_ZN6S597C53v12Ev,
  (VTBL_ENTRY)&_ZN6S597C53v13Ev,
  (VTBL_ENTRY)&_ZN6S597C43v14Ev,
  (VTBL_ENTRY)&_ZN6S597C43v15Ev,
  (VTBL_ENTRY)&_ZN6S597C43v16Ev,
  (VTBL_ENTRY)&_ZN6S597C43v17Ev,
  (VTBL_ENTRY)&_ZN6S597C43v18Ev,
  (VTBL_ENTRY)&_ZN6S597C43v19Ev,
  (VTBL_ENTRY)&_ZN6S597C43v20Ev,
  (VTBL_ENTRY)&_ZN6S597C43v21Ev,
  (VTBL_ENTRY)&_ZN6S597C43v22Ev,
  (VTBL_ENTRY)&_ZN6S597C43v23Ev,
  (VTBL_ENTRY)&_ZN6S597C43v24Ev,
  (VTBL_ENTRY)&_ZN6S597C43v25Ev,
  (VTBL_ENTRY)&_ZN6S597C43v26Ev,
  (VTBL_ENTRY)&_ZN6S597C43v27Ev,
  (VTBL_ENTRY)&_ZN6S597C33v28Ev,
  (VTBL_ENTRY)&_ZN6S597C33v29Ev,
  (VTBL_ENTRY)&_ZN6S597C33v30Ev,
  (VTBL_ENTRY)&_ZN6S597C33v31Ev,
  (VTBL_ENTRY)&_ZN6S597C23v32Ev,
  (VTBL_ENTRY)&_ZN6S597C23v33Ev,
  (VTBL_ENTRY)&_ZN6S597C23v34Ev,
  (VTBL_ENTRY)&_ZN6S597C23v35Ev,
  (VTBL_ENTRY)&_ZN6S597C12v1Ev,
  (VTBL_ENTRY)&_ZN6S597C12v2Ev,
  (VTBL_ENTRY)&_ZN6S597C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S597C1[];
extern  VTBL_ENTRY _ZTV6S597C1[];
Class_Descriptor cd_S597C1 = {  "S597C1", // class name
  bases_S597C1, 4,
  &(vtc_S597C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1648,1264), // object size
  NSPAIRA(_ZTI6S597C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S597C1),39, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10099C2  {
  virtual  ~S10099C2(); // _ZN8S10099C2D1Ev
  virtual void  v6(); // _ZN8S10099C22v6Ev
  S10099C2(); // tgen
};
//SIG(-1 S10099C2) C1{ vd v1}


 S10099C2 ::~S10099C2(){ note_dtor("S10099C2", this);}
void  S10099C2 ::v6(){vfunc_called(this, "_ZN8S10099C22v6Ev");}
S10099C2 ::S10099C2(){ note_ctor("S10099C2", this);} // tgen

static void Test_S10099C2()
{
  extern Class_Descriptor cd_S10099C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10099C2, buf);
    S10099C2 *dp, &lv = *(dp=new (buf) S10099C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10099C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10099C2)");
    test_class_info(&lv, &cd_S10099C2);
    dp->~S10099C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10099C2(Test_S10099C2, "S10099C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10099C2C1Ev();
extern void _ZN8S10099C2D1Ev();
Name_Map name_map_S10099C2[] = {
  NSPAIR(_ZN8S10099C2C1Ev),
  NSPAIR(_ZN8S10099C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10099C2[];
extern void _ZN8S10099C2D1Ev();
extern void _ZN8S10099C2D0Ev();
extern void _ZN8S10099C22v6Ev();
static  VTBL_ENTRY vtc_S10099C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10099C2[0]),
  (VTBL_ENTRY)&_ZN8S10099C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10099C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10099C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S10099C2[];
extern  VTBL_ENTRY _ZTV8S10099C2[];
Class_Descriptor cd_S10099C2 = {  "S10099C2", // class name
  0,0,//no base classes
  &(vtc_S10099C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10099C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10099C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10099C3  {
  void *s10099c3f0;
  virtual  ~S10099C3(); // _ZN8S10099C3D1Ev
  virtual void  v7(); // _ZN8S10099C32v7Ev
  virtual void  v8(); // _ZN8S10099C32v8Ev
  virtual void  v9(); // _ZN8S10099C32v9Ev
  virtual void  v10(); // _ZN8S10099C33v10Ev
  virtual void  v11(); // _ZN8S10099C33v11Ev
  S10099C3(); // tgen
};
//SIG(-1 S10099C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10099C3 ::~S10099C3(){ note_dtor("S10099C3", this);}
void  S10099C3 ::v7(){vfunc_called(this, "_ZN8S10099C32v7Ev");}
void  S10099C3 ::v8(){vfunc_called(this, "_ZN8S10099C32v8Ev");}
void  S10099C3 ::v9(){vfunc_called(this, "_ZN8S10099C32v9Ev");}
void  S10099C3 ::v10(){vfunc_called(this, "_ZN8S10099C33v10Ev");}
void  S10099C3 ::v11(){vfunc_called(this, "_ZN8S10099C33v11Ev");}
S10099C3 ::S10099C3(){ note_ctor("S10099C3", this);} // tgen

static void Test_S10099C3()
{
  extern Class_Descriptor cd_S10099C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10099C3, buf);
    S10099C3 *dp, &lv = *(dp=new (buf) S10099C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10099C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10099C3)");
    check_field_offset(lv, s10099c3f0, ABISELECT(8,4), "S10099C3.s10099c3f0");
    test_class_info(&lv, &cd_S10099C3);
    dp->~S10099C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10099C3(Test_S10099C3, "S10099C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10099C3C1Ev();
extern void _ZN8S10099C3D1Ev();
Name_Map name_map_S10099C3[] = {
  NSPAIR(_ZN8S10099C3C1Ev),
  NSPAIR(_ZN8S10099C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10099C3[];
extern void _ZN8S10099C3D1Ev();
extern void _ZN8S10099C3D0Ev();
extern void _ZN8S10099C32v7Ev();
extern void _ZN8S10099C32v8Ev();
extern void _ZN8S10099C32v9Ev();
extern void _ZN8S10099C33v10Ev();
extern void _ZN8S10099C33v11Ev();
static  VTBL_ENTRY vtc_S10099C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10099C3[0]),
  (VTBL_ENTRY)&_ZN8S10099C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10099C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10099C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10099C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10099C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10099C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10099C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10099C3[];
extern  VTBL_ENTRY _ZTV8S10099C3[];
Class_Descriptor cd_S10099C3 = {  "S10099C3", // class name
  0,0,//no base classes
  &(vtc_S10099C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10099C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10099C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10099C13  {
  void *s10099c13f0;
  ::S10103C13_nt s10099c13f1;
  ::S10103C16_nt s10099c13f2;
  ::S10103C17 s10099c13f3;
  virtual  ~S10099C13(); // _ZN9S10099C13D1Ev
  virtual void  v16(); // _ZN9S10099C133v16Ev
  virtual void  v17(); // _ZN9S10099C133v17Ev
  virtual void  v18(); // _ZN9S10099C133v18Ev
  virtual void  v19(); // _ZN9S10099C133v19Ev
  virtual void  v20(); // _ZN9S10099C133v20Ev
  virtual void  v21(); // _ZN9S10099C133v21Ev
  virtual void  v22(); // _ZN9S10099C133v22Ev
  virtual void  v23(); // _ZN9S10099C133v23Ev
  virtual void  v24(); // _ZN9S10099C133v24Ev
  virtual void  v25(); // _ZN9S10099C133v25Ev
  virtual void  v26(); // _ZN9S10099C133v26Ev
  virtual void  v27(); // _ZN9S10099C133v27Ev
  virtual void  v28(); // _ZN9S10099C133v28Ev
  virtual void  v29(); // _ZN9S10099C133v29Ev
  virtual void  v30(); // _ZN9S10099C133v30Ev
  virtual void  v31(); // _ZN9S10099C133v31Ev
  virtual void  v32(); // _ZN9S10099C133v32Ev
  virtual void  v33(); // _ZN9S10099C133v33Ev
  virtual void  v34(); // _ZN9S10099C133v34Ev
  virtual void  v35(); // _ZN9S10099C133v35Ev
  virtual void  v36(); // _ZN9S10099C133v36Ev
  virtual void  v37(); // _ZN9S10099C133v37Ev
  virtual void  v38(); // _ZN9S10099C133v38Ev
  virtual void  v39(); // _ZN9S10099C133v39Ev
  S10099C13(); // tgen
};
//SIG(-1 S10099C13) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC6{ m Fc Fi[2] Fp}}


 S10099C13 ::~S10099C13(){ note_dtor("S10099C13", this);}
void  S10099C13 ::v16(){vfunc_called(this, "_ZN9S10099C133v16Ev");}
void  S10099C13 ::v17(){vfunc_called(this, "_ZN9S10099C133v17Ev");}
void  S10099C13 ::v18(){vfunc_called(this, "_ZN9S10099C133v18Ev");}
void  S10099C13 ::v19(){vfunc_called(this, "_ZN9S10099C133v19Ev");}
void  S10099C13 ::v20(){vfunc_called(this, "_ZN9S10099C133v20Ev");}
void  S10099C13 ::v21(){vfunc_called(this, "_ZN9S10099C133v21Ev");}
void  S10099C13 ::v22(){vfunc_called(this, "_ZN9S10099C133v22Ev");}
void  S10099C13 ::v23(){vfunc_called(this, "_ZN9S10099C133v23Ev");}
void  S10099C13 ::v24(){vfunc_called(this, "_ZN9S10099C133v24Ev");}
void  S10099C13 ::v25(){vfunc_called(this, "_ZN9S10099C133v25Ev");}
void  S10099C13 ::v26(){vfunc_called(this, "_ZN9S10099C133v26Ev");}
void  S10099C13 ::v27(){vfunc_called(this, "_ZN9S10099C133v27Ev");}
void  S10099C13 ::v28(){vfunc_called(this, "_ZN9S10099C133v28Ev");}
void  S10099C13 ::v29(){vfunc_called(this, "_ZN9S10099C133v29Ev");}
void  S10099C13 ::v30(){vfunc_called(this, "_ZN9S10099C133v30Ev");}
void  S10099C13 ::v31(){vfunc_called(this, "_ZN9S10099C133v31Ev");}
void  S10099C13 ::v32(){vfunc_called(this, "_ZN9S10099C133v32Ev");}
void  S10099C13 ::v33(){vfunc_called(this, "_ZN9S10099C133v33Ev");}
void  S10099C13 ::v34(){vfunc_called(this, "_ZN9S10099C133v34Ev");}
void  S10099C13 ::v35(){vfunc_called(this, "_ZN9S10099C133v35Ev");}
void  S10099C13 ::v36(){vfunc_called(this, "_ZN9S10099C133v36Ev");}
void  S10099C13 ::v37(){vfunc_called(this, "_ZN9S10099C133v37Ev");}
void  S10099C13 ::v38(){vfunc_called(this, "_ZN9S10099C133v38Ev");}
void  S10099C13 ::v39(){vfunc_called(this, "_ZN9S10099C133v39Ev");}
S10099C13 ::S10099C13(){ note_ctor("S10099C13", this);} // tgen

static void Test_S10099C13()
{
  extern Class_Descriptor cd_S10099C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S10099C13, buf);
    S10099C13 *dp, &lv = *(dp=new (buf) S10099C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S10099C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10099C13)");
    check_field_offset(lv, s10099c13f0, ABISELECT(8,4), "S10099C13.s10099c13f0");
    check_field_offset(lv, s10099c13f1, ABISELECT(16,8), "S10099C13.s10099c13f1");
    check_field_offset(lv, s10099c13f2, ABISELECT(40,24), "S10099C13.s10099c13f2");
    check_field_offset(lv, s10099c13f3, ABISELECT(96,64), "S10099C13.s10099c13f3");
    test_class_info(&lv, &cd_S10099C13);
    dp->~S10099C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10099C13(Test_S10099C13, "S10099C13", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN9S10099C13C1Ev();
extern void _ZN9S10099C13D1Ev();
Name_Map name_map_S10099C13[] = {
  NSPAIR(_ZN9S10099C13C1Ev),
  NSPAIR(_ZN9S10099C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10099C13[];
extern void _ZN9S10099C13D1Ev();
extern void _ZN9S10099C13D0Ev();
extern void _ZN9S10099C133v16Ev();
extern void _ZN9S10099C133v17Ev();
extern void _ZN9S10099C133v18Ev();
extern void _ZN9S10099C133v19Ev();
extern void _ZN9S10099C133v20Ev();
extern void _ZN9S10099C133v21Ev();
extern void _ZN9S10099C133v22Ev();
extern void _ZN9S10099C133v23Ev();
extern void _ZN9S10099C133v24Ev();
extern void _ZN9S10099C133v25Ev();
extern void _ZN9S10099C133v26Ev();
extern void _ZN9S10099C133v27Ev();
extern void _ZN9S10099C133v28Ev();
extern void _ZN9S10099C133v29Ev();
extern void _ZN9S10099C133v30Ev();
extern void _ZN9S10099C133v31Ev();
extern void _ZN9S10099C133v32Ev();
extern void _ZN9S10099C133v33Ev();
extern void _ZN9S10099C133v34Ev();
extern void _ZN9S10099C133v35Ev();
extern void _ZN9S10099C133v36Ev();
extern void _ZN9S10099C133v37Ev();
extern void _ZN9S10099C133v38Ev();
extern void _ZN9S10099C133v39Ev();
static  VTBL_ENTRY vtc_S10099C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10099C13[0]),
  (VTBL_ENTRY)&_ZN9S10099C13D1Ev,
  (VTBL_ENTRY)&_ZN9S10099C13D0Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v16Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v17Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v18Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v19Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v20Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v21Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v22Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v23Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v24Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v25Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v26Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v27Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v28Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v29Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v30Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v31Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v32Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v33Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v34Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v35Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v36Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v37Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v38Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v39Ev,
};
extern VTBL_ENTRY _ZTI9S10099C13[];
extern  VTBL_ENTRY _ZTV9S10099C13[];
Class_Descriptor cd_S10099C13 = {  "S10099C13", // class name
  0,0,//no base classes
  &(vtc_S10099C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI9S10099C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10099C13),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10099C5  : S10103C5_nt , S10099C13 {
  virtual  ~S10099C5(); // _ZN8S10099C5D1Ev
  virtual void  v40(); // _ZN8S10099C53v40Ev
  virtual void  v41(); // _ZN8S10099C53v41Ev
  virtual void  v42(); // _ZN8S10099C53v42Ev
  virtual void  v43(); // _ZN8S10099C53v43Ev
  virtual void  v44(); // _ZN8S10099C53v44Ev
  virtual void  v45(); // _ZN8S10099C53v45Ev
  virtual void  v46(); // _ZN8S10099C53v46Ev
  virtual void  v47(); // _ZN8S10099C53v47Ev
  virtual void  v48(); // _ZN8S10099C53v48Ev
  S10099C5(); // tgen
};
//SIG(-1 S10099C5) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S10099C5 ::~S10099C5(){ note_dtor("S10099C5", this);}
void  S10099C5 ::v40(){vfunc_called(this, "_ZN8S10099C53v40Ev");}
void  S10099C5 ::v41(){vfunc_called(this, "_ZN8S10099C53v41Ev");}
void  S10099C5 ::v42(){vfunc_called(this, "_ZN8S10099C53v42Ev");}
void  S10099C5 ::v43(){vfunc_called(this, "_ZN8S10099C53v43Ev");}
void  S10099C5 ::v44(){vfunc_called(this, "_ZN8S10099C53v44Ev");}
void  S10099C5 ::v45(){vfunc_called(this, "_ZN8S10099C53v45Ev");}
void  S10099C5 ::v46(){vfunc_called(this, "_ZN8S10099C53v46Ev");}
void  S10099C5 ::v47(){vfunc_called(this, "_ZN8S10099C53v47Ev");}
void  S10099C5 ::v48(){vfunc_called(this, "_ZN8S10099C53v48Ev");}
S10099C5 ::S10099C5(){ note_ctor("S10099C5", this);} // tgen

static void Test_S10099C5()
{
  extern Class_Descriptor cd_S10099C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,29)];
    init_test(&cd_S10099C5, buf);
    S10099C5 *dp, &lv = *(dp=new (buf) S10099C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S10099C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10099C5)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S10099C5");
    check_base_class_offset(lv, (S10099C13*), ABISELECT(48,32), "S10099C5");
    test_class_info(&lv, &cd_S10099C5);
    dp->~S10099C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10099C5(Test_S10099C5, "S10099C5", ABISELECT(168,112));

#else // __cplusplus

extern void _ZN8S10099C5C1Ev();
extern void _ZN8S10099C5D1Ev();
Name_Map name_map_S10099C5[] = {
  NSPAIR(_ZN8S10099C5C1Ev),
  NSPAIR(_ZN8S10099C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10099C13;
extern VTBL_ENTRY _ZTI9S10099C13[];
extern  VTBL_ENTRY _ZTV9S10099C13[];
static Base_Class bases_S10099C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10099C13,    ABISELECT(48,32), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10099C5[];
extern void _ZN8S10099C5D1Ev();
extern void _ZN8S10099C5D0Ev();
extern void _ZN8S10099C53v40Ev();
extern void _ZN8S10099C53v41Ev();
extern void _ZN8S10099C53v42Ev();
extern void _ZN8S10099C53v43Ev();
extern void _ZN8S10099C53v44Ev();
extern void _ZN8S10099C53v45Ev();
extern void _ZN8S10099C53v46Ev();
extern void _ZN8S10099C53v47Ev();
extern void _ZN8S10099C53v48Ev();
extern void ABISELECT(_ZThn48_N8S10099C5D1Ev,_ZThn32_N8S10099C5D1Ev)();
extern void ABISELECT(_ZThn48_N8S10099C5D0Ev,_ZThn32_N8S10099C5D0Ev)();
extern void _ZN9S10099C133v16Ev();
extern void _ZN9S10099C133v17Ev();
extern void _ZN9S10099C133v18Ev();
extern void _ZN9S10099C133v19Ev();
extern void _ZN9S10099C133v20Ev();
extern void _ZN9S10099C133v21Ev();
extern void _ZN9S10099C133v22Ev();
extern void _ZN9S10099C133v23Ev();
extern void _ZN9S10099C133v24Ev();
extern void _ZN9S10099C133v25Ev();
extern void _ZN9S10099C133v26Ev();
extern void _ZN9S10099C133v27Ev();
extern void _ZN9S10099C133v28Ev();
extern void _ZN9S10099C133v29Ev();
extern void _ZN9S10099C133v30Ev();
extern void _ZN9S10099C133v31Ev();
extern void _ZN9S10099C133v32Ev();
extern void _ZN9S10099C133v33Ev();
extern void _ZN9S10099C133v34Ev();
extern void _ZN9S10099C133v35Ev();
extern void _ZN9S10099C133v36Ev();
extern void _ZN9S10099C133v37Ev();
extern void _ZN9S10099C133v38Ev();
extern void _ZN9S10099C133v39Ev();
static  VTBL_ENTRY vtc_S10099C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10099C5[0]),
  (VTBL_ENTRY)&_ZN8S10099C5D1Ev,
  (VTBL_ENTRY)&_ZN8S10099C5D0Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v40Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v41Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v42Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v43Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v44Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v45Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v46Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v47Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v48Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8S10099C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10099C5D1Ev,_ZThn32_N8S10099C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10099C5D0Ev,_ZThn32_N8S10099C5D0Ev),
  (VTBL_ENTRY)&_ZN9S10099C133v16Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v17Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v18Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v19Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v20Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v21Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v22Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v23Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v24Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v25Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v26Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v27Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v28Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v29Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v30Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v31Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v32Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v33Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v34Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v35Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v36Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v37Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v38Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v39Ev,
};
extern VTBL_ENTRY _ZTI8S10099C5[];
extern  VTBL_ENTRY _ZTV8S10099C5[];
Class_Descriptor cd_S10099C5 = {  "S10099C5", // class name
  bases_S10099C5, 2,
  &(vtc_S10099C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,112), // object size
  NSPAIRA(_ZTI8S10099C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10099C5),41, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10099C4  : S10099C5 , S10099C2 {
  ::S10103C106 s10099c4f0;
  ::S10103C29 s10099c4f1;
  int s10099c4f2[2];
  virtual  ~S10099C4(); // _ZN8S10099C4D1Ev
  virtual void  v12(); // _ZN8S10099C43v12Ev
  virtual void  v13(); // _ZN8S10099C43v13Ev
  virtual void  v14(); // _ZN8S10099C43v14Ev
  virtual void  v15(); // _ZN8S10099C43v15Ev
  S10099C4(); // tgen
};
//SIG(-1 S10099C4) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC11{ m Fc Fi[2] Fp}} vd v29 v30 v31 v32 v33 v34 v35 v36 v37} BC12{ vd v38} vd v1 v2 v3 v4 FC13{ m Fp Fi[2] FC14{ m}} FC15{ m Fi Fp Fi Fp[2] Fi} Fi[2]}


 S10099C4 ::~S10099C4(){ note_dtor("S10099C4", this);}
void  S10099C4 ::v12(){vfunc_called(this, "_ZN8S10099C43v12Ev");}
void  S10099C4 ::v13(){vfunc_called(this, "_ZN8S10099C43v13Ev");}
void  S10099C4 ::v14(){vfunc_called(this, "_ZN8S10099C43v14Ev");}
void  S10099C4 ::v15(){vfunc_called(this, "_ZN8S10099C43v15Ev");}
S10099C4 ::S10099C4(){ note_ctor("S10099C4", this);} // tgen

static void Test_S10099C4()
{
  extern Class_Descriptor cd_S10099C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,42)];
    init_test(&cd_S10099C4, buf);
    S10099C4 *dp, &lv = *(dp=new (buf) S10099C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,164), "sizeof(S10099C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10099C4)");
    check_base_class_offset(lv, (S10103C5_nt*)(S10099C5*), 0, "S10099C4");
    check_base_class_offset(lv, (S10099C13*)(S10099C5*), ABISELECT(48,32), "S10099C4");
    check_base_class_offset(lv, (S10099C5*), 0, "S10099C4");
    check_base_class_offset(lv, (S10099C2*), ABISELECT(168,112), "S10099C4");
    check_field_offset(lv, s10099c4f0, ABISELECT(176,116), "S10099C4.s10099c4f0");
    check_field_offset(lv, s10099c4f1, ABISELECT(200,132), "S10099C4.s10099c4f1");
    check_field_offset(lv, s10099c4f2, ABISELECT(248,156), "S10099C4.s10099c4f2");
    test_class_info(&lv, &cd_S10099C4);
    dp->~S10099C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10099C4(Test_S10099C4, "S10099C4", ABISELECT(256,164));

#else // __cplusplus

extern void _ZN8S10099C4C1Ev();
extern void _ZN8S10099C4D1Ev();
Name_Map name_map_S10099C4[] = {
  NSPAIR(_ZN8S10099C4C1Ev),
  NSPAIR(_ZN8S10099C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S10099C13;
extern VTBL_ENTRY _ZTI9S10099C13[];
extern  VTBL_ENTRY _ZTV9S10099C13[];
extern Class_Descriptor cd_S10099C5;
extern VTBL_ENTRY _ZTI8S10099C5[];
extern  VTBL_ENTRY _ZTV8S10099C5[];
extern Class_Descriptor cd_S10099C2;
extern VTBL_ENTRY _ZTI8S10099C2[];
extern  VTBL_ENTRY _ZTV8S10099C2[];
static Base_Class bases_S10099C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10099C13,    ABISELECT(48,32), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10099C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10099C2,    ABISELECT(168,112), //bcp->offset
    45, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10099C4[];
extern void _ZN8S10099C4D1Ev();
extern void _ZN8S10099C4D0Ev();
extern void _ZN8S10099C53v40Ev();
extern void _ZN8S10099C53v41Ev();
extern void _ZN8S10099C53v42Ev();
extern void _ZN8S10099C53v43Ev();
extern void _ZN8S10099C53v44Ev();
extern void _ZN8S10099C53v45Ev();
extern void _ZN8S10099C53v46Ev();
extern void _ZN8S10099C53v47Ev();
extern void _ZN8S10099C53v48Ev();
extern void _ZN8S10099C43v12Ev();
extern void _ZN8S10099C43v13Ev();
extern void _ZN8S10099C43v14Ev();
extern void _ZN8S10099C43v15Ev();
extern void ABISELECT(_ZThn48_N8S10099C4D1Ev,_ZThn32_N8S10099C4D1Ev)();
extern void ABISELECT(_ZThn48_N8S10099C4D0Ev,_ZThn32_N8S10099C4D0Ev)();
extern void _ZN9S10099C133v16Ev();
extern void _ZN9S10099C133v17Ev();
extern void _ZN9S10099C133v18Ev();
extern void _ZN9S10099C133v19Ev();
extern void _ZN9S10099C133v20Ev();
extern void _ZN9S10099C133v21Ev();
extern void _ZN9S10099C133v22Ev();
extern void _ZN9S10099C133v23Ev();
extern void _ZN9S10099C133v24Ev();
extern void _ZN9S10099C133v25Ev();
extern void _ZN9S10099C133v26Ev();
extern void _ZN9S10099C133v27Ev();
extern void _ZN9S10099C133v28Ev();
extern void _ZN9S10099C133v29Ev();
extern void _ZN9S10099C133v30Ev();
extern void _ZN9S10099C133v31Ev();
extern void _ZN9S10099C133v32Ev();
extern void _ZN9S10099C133v33Ev();
extern void _ZN9S10099C133v34Ev();
extern void _ZN9S10099C133v35Ev();
extern void _ZN9S10099C133v36Ev();
extern void _ZN9S10099C133v37Ev();
extern void _ZN9S10099C133v38Ev();
extern void _ZN9S10099C133v39Ev();
extern void ABISELECT(_ZThn168_N8S10099C4D1Ev,_ZThn112_N8S10099C4D1Ev)();
extern void ABISELECT(_ZThn168_N8S10099C4D0Ev,_ZThn112_N8S10099C4D0Ev)();
extern void _ZN8S10099C22v6Ev();
static  VTBL_ENTRY vtc_S10099C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10099C4[0]),
  (VTBL_ENTRY)&_ZN8S10099C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10099C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v40Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v41Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v42Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v43Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v44Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v45Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v46Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v47Ev,
  (VTBL_ENTRY)&_ZN8S10099C53v48Ev,
  (VTBL_ENTRY)&_ZN8S10099C43v12Ev,
  (VTBL_ENTRY)&_ZN8S10099C43v13Ev,
  (VTBL_ENTRY)&_ZN8S10099C43v14Ev,
  (VTBL_ENTRY)&_ZN8S10099C43v15Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8S10099C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10099C4D1Ev,_ZThn32_N8S10099C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S10099C4D0Ev,_ZThn32_N8S10099C4D0Ev),
  (VTBL_ENTRY)&_ZN9S10099C133v16Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v17Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v18Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v19Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v20Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v21Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v22Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v23Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v24Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v25Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v26Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v27Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v28Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v29Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v30Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v31Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v32Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v33Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v34Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v35Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v36Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v37Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v38Ev,
  (VTBL_ENTRY)&_ZN9S10099C133v39Ev,
  ABISELECT(-168,-112),
  (VTBL_ENTRY)&(_ZTI8S10099C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N8S10099C4D1Ev,_ZThn112_N8S10099C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N8S10099C4D0Ev,_ZThn112_N8S10099C4D0Ev),
  (VTBL_ENTRY)&_ZN8S10099C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S10099C4[];
extern  VTBL_ENTRY _ZTV8S10099C4[];
Class_Descriptor cd_S10099C4 = {  "S10099C4", // class name
  bases_S10099C4, 4,
  &(vtc_S10099C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,164), // object size
  NSPAIRA(_ZTI8S10099C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10099C4),50, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10099C1  : S10099C2 , S10099C3 {
  ::S10099C4 s10099c1f0;
  ::S10103C49 s10099c1f1;
  ::S10103C105 s10099c1f2;
  int s10099c1f3;
  char s10099c1f4;
  ::S10103C14_nt s10099c1f5;
  void *s10099c1f6;
  virtual  ~S10099C1(); // _ZN8S10099C1D1Ev
  virtual void  v1(); // _ZN8S10099C12v1Ev
  virtual void  v2(); // _ZN8S10099C12v2Ev
  virtual void  v3(); // _ZN8S10099C12v3Ev
  virtual void  v4(); // _ZN8S10099C12v4Ev
  virtual void  v5(); // _ZN8S10099C12v5Ev
  S10099C1(); // tgen
};
//SIG(1 S10099C1) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} vd v1 v2 v3 v4 v5 FC4{ BC5{ BC6{ vd m FC7{ m Fp Fi FC8{ m} FC8} FC7 Fc} BC9{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} FC13{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC14{ m Fc Fi[2] Fp}} vd v40 v41 v42 v43 v44 v45 v46 v47 v48} BC2 vd v12 v13 v14 v15 FC15{ m Fp Fi[2] FC16{ m}} FC17{ m Fi Fp Fi Fp[2] Fi} Fi[2]} FC18{ BC19{ BC6 vd v51 v52 v53 v54 FC20{ m Fp FC10 FC11 FC11 Fi} Fp Fc Fi} v49 v50} FC21{ m Fp} Fi Fc FC11 Fp}


 S10099C1 ::~S10099C1(){ note_dtor("S10099C1", this);}
void  S10099C1 ::v1(){vfunc_called(this, "_ZN8S10099C12v1Ev");}
void  S10099C1 ::v2(){vfunc_called(this, "_ZN8S10099C12v2Ev");}
void  S10099C1 ::v3(){vfunc_called(this, "_ZN8S10099C12v3Ev");}
void  S10099C1 ::v4(){vfunc_called(this, "_ZN8S10099C12v4Ev");}
void  S10099C1 ::v5(){vfunc_called(this, "_ZN8S10099C12v5Ev");}
S10099C1 ::S10099C1(){ note_ctor("S10099C1", this);} // tgen

static void Test_S10099C1()
{
  extern Class_Descriptor cd_S10099C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(58,75)];
    init_test(&cd_S10099C1, buf);
    S10099C1 *dp, &lv = *(dp=new (buf) S10099C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(456,296), "sizeof(S10099C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10099C1)");
    check_base_class_offset(lv, (S10099C2*), 0, "S10099C1");
    check_base_class_offset(lv, (S10099C3*), ABISELECT(8,4), "S10099C1");
    check_field_offset(lv, s10099c1f0, ABISELECT(24,12), "S10099C1.s10099c1f0");
    check_field_offset(lv, s10099c1f1, ABISELECT(280,176), "S10099C1.s10099c1f1");
    check_field_offset(lv, s10099c1f2, ABISELECT(416,268), "S10099C1.s10099c1f2");
    check_field_offset(lv, s10099c1f3, ABISELECT(424,272), "S10099C1.s10099c1f3");
    check_field_offset(lv, s10099c1f4, ABISELECT(428,276), "S10099C1.s10099c1f4");
    check_field_offset(lv, s10099c1f5, ABISELECT(432,280), "S10099C1.s10099c1f5");
    check_field_offset(lv, s10099c1f6, ABISELECT(448,292), "S10099C1.s10099c1f6");
    test_class_info(&lv, &cd_S10099C1);
    dp->~S10099C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10099C1(Test_S10099C1, "S10099C1", ABISELECT(456,296));

#else // __cplusplus

extern void _ZN8S10099C1C1Ev();
extern void _ZN8S10099C1D1Ev();
Name_Map name_map_S10099C1[] = {
  NSPAIR(_ZN8S10099C1C1Ev),
  NSPAIR(_ZN8S10099C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10099C2;
extern VTBL_ENTRY _ZTI8S10099C2[];
extern  VTBL_ENTRY _ZTV8S10099C2[];
extern Class_Descriptor cd_S10099C3;
extern VTBL_ENTRY _ZTI8S10099C3[];
extern  VTBL_ENTRY _ZTV8S10099C3[];
static Base_Class bases_S10099C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10099C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10099C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10099C1[];
extern void _ZN8S10099C1D1Ev();
extern void _ZN8S10099C1D0Ev();
extern void _ZN8S10099C22v6Ev();
extern void _ZN8S10099C12v1Ev();
extern void _ZN8S10099C12v2Ev();
extern void _ZN8S10099C12v3Ev();
extern void _ZN8S10099C12v4Ev();
extern void _ZN8S10099C12v5Ev();
extern void ABISELECT(_ZThn8_N8S10099C1D1Ev,_ZThn4_N8S10099C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10099C1D0Ev,_ZThn4_N8S10099C1D0Ev)();
extern void _ZN8S10099C32v7Ev();
extern void _ZN8S10099C32v8Ev();
extern void _ZN8S10099C32v9Ev();
extern void _ZN8S10099C33v10Ev();
extern void _ZN8S10099C33v11Ev();
static  VTBL_ENTRY vtc_S10099C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10099C1[0]),
  (VTBL_ENTRY)&_ZN8S10099C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10099C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10099C22v6Ev,
  (VTBL_ENTRY)&_ZN8S10099C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10099C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10099C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10099C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10099C12v5Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10099C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10099C1D1Ev,_ZThn4_N8S10099C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10099C1D0Ev,_ZThn4_N8S10099C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10099C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10099C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10099C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10099C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10099C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10099C1[];
extern  VTBL_ENTRY _ZTV8S10099C1[];
Class_Descriptor cd_S10099C1 = {  "S10099C1", // class name
  bases_S10099C1, 2,
  &(vtc_S10099C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(456,296), // object size
  NSPAIRA(_ZTI8S10099C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10099C1),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1489C4  {
  void *s1489c4f0[2];
  ::S10103C13_nt s1489c4f1;
  void *s1489c4f2;
  virtual  ~S1489C4(); // _ZN7S1489C4D1Ev
  virtual void  v5(); // _ZN7S1489C42v5Ev
  virtual void  v6(); // _ZN7S1489C42v6Ev
  virtual void  v7(); // _ZN7S1489C42v7Ev
  virtual void  v8(); // _ZN7S1489C42v8Ev
  virtual void  v9(); // _ZN7S1489C42v9Ev
  virtual void  v10(); // _ZN7S1489C43v10Ev
  virtual void  v11(); // _ZN7S1489C43v11Ev
  virtual void  v12(); // _ZN7S1489C43v12Ev
  virtual void  v13(); // _ZN7S1489C43v13Ev
  virtual void  v14(); // _ZN7S1489C43v14Ev
  S1489C4(); // tgen
};
//SIG(-1 S1489C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1489C4 ::~S1489C4(){ note_dtor("S1489C4", this);}
void  S1489C4 ::v5(){vfunc_called(this, "_ZN7S1489C42v5Ev");}
void  S1489C4 ::v6(){vfunc_called(this, "_ZN7S1489C42v6Ev");}
void  S1489C4 ::v7(){vfunc_called(this, "_ZN7S1489C42v7Ev");}
void  S1489C4 ::v8(){vfunc_called(this, "_ZN7S1489C42v8Ev");}
void  S1489C4 ::v9(){vfunc_called(this, "_ZN7S1489C42v9Ev");}
void  S1489C4 ::v10(){vfunc_called(this, "_ZN7S1489C43v10Ev");}
void  S1489C4 ::v11(){vfunc_called(this, "_ZN7S1489C43v11Ev");}
void  S1489C4 ::v12(){vfunc_called(this, "_ZN7S1489C43v12Ev");}
void  S1489C4 ::v13(){vfunc_called(this, "_ZN7S1489C43v13Ev");}
void  S1489C4 ::v14(){vfunc_called(this, "_ZN7S1489C43v14Ev");}
S1489C4 ::S1489C4(){ note_ctor("S1489C4", this);} // tgen

static void Test_S1489C4()
{
  extern Class_Descriptor cd_S1489C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1489C4, buf);
    S1489C4 *dp, &lv = *(dp=new (buf) S1489C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1489C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1489C4)");
    check_field_offset(lv, s1489c4f0, ABISELECT(8,4), "S1489C4.s1489c4f0");
    check_field_offset(lv, s1489c4f1, ABISELECT(24,12), "S1489C4.s1489c4f1");
    check_field_offset(lv, s1489c4f2, ABISELECT(48,28), "S1489C4.s1489c4f2");
    test_class_info(&lv, &cd_S1489C4);
    dp->~S1489C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1489C4(Test_S1489C4, "S1489C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1489C4C1Ev();
extern void _ZN7S1489C4D1Ev();
Name_Map name_map_S1489C4[] = {
  NSPAIR(_ZN7S1489C4C1Ev),
  NSPAIR(_ZN7S1489C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1489C4[];
extern void _ZN7S1489C4D1Ev();
extern void _ZN7S1489C4D0Ev();
extern void _ZN7S1489C42v5Ev();
extern void _ZN7S1489C42v6Ev();
extern void _ZN7S1489C42v7Ev();
extern void _ZN7S1489C42v8Ev();
extern void _ZN7S1489C42v9Ev();
extern void _ZN7S1489C43v10Ev();
extern void _ZN7S1489C43v11Ev();
extern void _ZN7S1489C43v12Ev();
extern void _ZN7S1489C43v13Ev();
extern void _ZN7S1489C43v14Ev();
static  VTBL_ENTRY vtc_S1489C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1489C4[0]),
  (VTBL_ENTRY)&_ZN7S1489C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1489C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S1489C4[];
extern  VTBL_ENTRY _ZTV7S1489C4[];
Class_Descriptor cd_S1489C4 = {  "S1489C4", // class name
  0,0,//no base classes
  &(vtc_S1489C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1489C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1489C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1489C3  : S1489C4 {
  ::S10103C86 s1489c3f0;
  ::S10103C106 s1489c3f1;
  ::S10103C82_nt s1489c3f2;
  ::S10103C13_nt s1489c3f3;
  virtual  ~S1489C3(); // _ZN7S1489C3D1Ev
  virtual void  v15(); // _ZN7S1489C33v15Ev
  virtual void  v16(); // _ZN7S1489C33v16Ev
  virtual void  v17(); // _ZN7S1489C33v17Ev
  virtual void  v18(); // _ZN7S1489C33v18Ev
  virtual void  v19(); // _ZN7S1489C33v19Ev
  virtual void  v20(); // _ZN7S1489C33v20Ev
  virtual void  v21(); // _ZN7S1489C33v21Ev
  virtual void  v22(); // _ZN7S1489C33v22Ev
  virtual void  v23(); // _ZN7S1489C33v23Ev
  virtual void  v24(); // _ZN7S1489C33v24Ev
  virtual void  v25(); // _ZN7S1489C33v25Ev
  virtual void  v26(); // _ZN7S1489C33v26Ev
  virtual void  v27(); // _ZN7S1489C33v27Ev
  virtual void  v28(); // _ZN7S1489C33v28Ev
  S1489C3(); // tgen
};
//SIG(-1 S1489C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1489C3 ::~S1489C3(){ note_dtor("S1489C3", this);}
void  S1489C3 ::v15(){vfunc_called(this, "_ZN7S1489C33v15Ev");}
void  S1489C3 ::v16(){vfunc_called(this, "_ZN7S1489C33v16Ev");}
void  S1489C3 ::v17(){vfunc_called(this, "_ZN7S1489C33v17Ev");}
void  S1489C3 ::v18(){vfunc_called(this, "_ZN7S1489C33v18Ev");}
void  S1489C3 ::v19(){vfunc_called(this, "_ZN7S1489C33v19Ev");}
void  S1489C3 ::v20(){vfunc_called(this, "_ZN7S1489C33v20Ev");}
void  S1489C3 ::v21(){vfunc_called(this, "_ZN7S1489C33v21Ev");}
void  S1489C3 ::v22(){vfunc_called(this, "_ZN7S1489C33v22Ev");}
void  S1489C3 ::v23(){vfunc_called(this, "_ZN7S1489C33v23Ev");}
void  S1489C3 ::v24(){vfunc_called(this, "_ZN7S1489C33v24Ev");}
void  S1489C3 ::v25(){vfunc_called(this, "_ZN7S1489C33v25Ev");}
void  S1489C3 ::v26(){vfunc_called(this, "_ZN7S1489C33v26Ev");}
void  S1489C3 ::v27(){vfunc_called(this, "_ZN7S1489C33v27Ev");}
void  S1489C3 ::v28(){vfunc_called(this, "_ZN7S1489C33v28Ev");}
S1489C3 ::S1489C3(){ note_ctor("S1489C3", this);} // tgen

static void Test_S1489C3()
{
  extern Class_Descriptor cd_S1489C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1489C3, buf);
    S1489C3 *dp, &lv = *(dp=new (buf) S1489C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1489C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1489C3)");
    check_base_class_offset(lv, (S1489C4*), 0, "S1489C3");
    check_field_offset(lv, s1489c3f0, ABISELECT(56,32), "S1489C3.s1489c3f0");
    check_field_offset(lv, s1489c3f1, ABISELECT(72,44), "S1489C3.s1489c3f1");
    check_field_offset(lv, s1489c3f2, ABISELECT(96,60), "S1489C3.s1489c3f2");
    check_field_offset(lv, s1489c3f3, ABISELECT(112,76), "S1489C3.s1489c3f3");
    test_class_info(&lv, &cd_S1489C3);
    dp->~S1489C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1489C3(Test_S1489C3, "S1489C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1489C3C1Ev();
extern void _ZN7S1489C3D1Ev();
Name_Map name_map_S1489C3[] = {
  NSPAIR(_ZN7S1489C3C1Ev),
  NSPAIR(_ZN7S1489C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1489C4;
extern VTBL_ENTRY _ZTI7S1489C4[];
extern  VTBL_ENTRY _ZTV7S1489C4[];
static Base_Class bases_S1489C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1489C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1489C3[];
extern void _ZN7S1489C3D1Ev();
extern void _ZN7S1489C3D0Ev();
extern void _ZN7S1489C42v5Ev();
extern void _ZN7S1489C42v6Ev();
extern void _ZN7S1489C42v7Ev();
extern void _ZN7S1489C42v8Ev();
extern void _ZN7S1489C42v9Ev();
extern void _ZN7S1489C43v10Ev();
extern void _ZN7S1489C43v11Ev();
extern void _ZN7S1489C43v12Ev();
extern void _ZN7S1489C43v13Ev();
extern void _ZN7S1489C43v14Ev();
extern void _ZN7S1489C33v15Ev();
extern void _ZN7S1489C33v16Ev();
extern void _ZN7S1489C33v17Ev();
extern void _ZN7S1489C33v18Ev();
extern void _ZN7S1489C33v19Ev();
extern void _ZN7S1489C33v20Ev();
extern void _ZN7S1489C33v21Ev();
extern void _ZN7S1489C33v22Ev();
extern void _ZN7S1489C33v23Ev();
extern void _ZN7S1489C33v24Ev();
extern void _ZN7S1489C33v25Ev();
extern void _ZN7S1489C33v26Ev();
extern void _ZN7S1489C33v27Ev();
extern void _ZN7S1489C33v28Ev();
static  VTBL_ENTRY vtc_S1489C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1489C3[0]),
  (VTBL_ENTRY)&_ZN7S1489C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1489C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v28Ev,
};
extern VTBL_ENTRY _ZTI7S1489C3[];
extern  VTBL_ENTRY _ZTV7S1489C3[];
Class_Descriptor cd_S1489C3 = {  "S1489C3", // class name
  bases_S1489C3, 1,
  &(vtc_S1489C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1489C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1489C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1489C2  : S1489C3 {
  int s1489c2f0;
  char s1489c2f1[2];
  int s1489c2f2;
  virtual void  v29(); // _ZN7S1489C23v29Ev
  virtual void  v30(); // _ZN7S1489C23v30Ev
  virtual void  v31(); // _ZN7S1489C23v31Ev
  virtual void  v32(); // _ZN7S1489C23v32Ev
  ~S1489C2(); // tgen
  S1489C2(); // tgen
};
//SIG(-1 S1489C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 Fi Fc[2] Fi}


void  S1489C2 ::v29(){vfunc_called(this, "_ZN7S1489C23v29Ev");}
void  S1489C2 ::v30(){vfunc_called(this, "_ZN7S1489C23v30Ev");}
void  S1489C2 ::v31(){vfunc_called(this, "_ZN7S1489C23v31Ev");}
void  S1489C2 ::v32(){vfunc_called(this, "_ZN7S1489C23v32Ev");}
S1489C2 ::~S1489C2(){ note_dtor("S1489C2", this);} // tgen
S1489C2 ::S1489C2(){ note_ctor("S1489C2", this);} // tgen

static void Test_S1489C2()
{
  extern Class_Descriptor cd_S1489C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S1489C2, buf);
    S1489C2 *dp, &lv = *(dp=new (buf) S1489C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S1489C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1489C2)");
    check_base_class_offset(lv, (S1489C4*)(S1489C3*), 0, "S1489C2");
    check_base_class_offset(lv, (S1489C3*), 0, "S1489C2");
    check_field_offset(lv, s1489c2f0, ABISELECT(136,92), "S1489C2.s1489c2f0");
    check_field_offset(lv, s1489c2f1, ABISELECT(140,96), "S1489C2.s1489c2f1");
    check_field_offset(lv, s1489c2f2, ABISELECT(144,100), "S1489C2.s1489c2f2");
    test_class_info(&lv, &cd_S1489C2);
    dp->~S1489C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1489C2(Test_S1489C2, "S1489C2", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN7S1489C2C1Ev();
extern void _ZN7S1489C2D1Ev();
Name_Map name_map_S1489C2[] = {
  NSPAIR(_ZN7S1489C2C1Ev),
  NSPAIR(_ZN7S1489C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1489C4;
extern VTBL_ENTRY _ZTI7S1489C4[];
extern  VTBL_ENTRY _ZTV7S1489C4[];
extern Class_Descriptor cd_S1489C3;
extern VTBL_ENTRY _ZTI7S1489C3[];
extern  VTBL_ENTRY _ZTV7S1489C3[];
static Base_Class bases_S1489C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1489C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1489C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1489C2[];
extern void _ZN7S1489C2D1Ev();
extern void _ZN7S1489C2D0Ev();
extern void _ZN7S1489C42v5Ev();
extern void _ZN7S1489C42v6Ev();
extern void _ZN7S1489C42v7Ev();
extern void _ZN7S1489C42v8Ev();
extern void _ZN7S1489C42v9Ev();
extern void _ZN7S1489C43v10Ev();
extern void _ZN7S1489C43v11Ev();
extern void _ZN7S1489C43v12Ev();
extern void _ZN7S1489C43v13Ev();
extern void _ZN7S1489C43v14Ev();
extern void _ZN7S1489C33v15Ev();
extern void _ZN7S1489C33v16Ev();
extern void _ZN7S1489C33v17Ev();
extern void _ZN7S1489C33v18Ev();
extern void _ZN7S1489C33v19Ev();
extern void _ZN7S1489C33v20Ev();
extern void _ZN7S1489C33v21Ev();
extern void _ZN7S1489C33v22Ev();
extern void _ZN7S1489C33v23Ev();
extern void _ZN7S1489C33v24Ev();
extern void _ZN7S1489C33v25Ev();
extern void _ZN7S1489C33v26Ev();
extern void _ZN7S1489C33v27Ev();
extern void _ZN7S1489C33v28Ev();
extern void _ZN7S1489C23v29Ev();
extern void _ZN7S1489C23v30Ev();
extern void _ZN7S1489C23v31Ev();
extern void _ZN7S1489C23v32Ev();
static  VTBL_ENTRY vtc_S1489C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1489C2[0]),
  (VTBL_ENTRY)&_ZN7S1489C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1489C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v32Ev,
};
extern VTBL_ENTRY _ZTI7S1489C2[];
extern  VTBL_ENTRY _ZTV7S1489C2[];
Class_Descriptor cd_S1489C2 = {  "S1489C2", // class name
  bases_S1489C2, 2,
  &(vtc_S1489C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI7S1489C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1489C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1489C1  : S1489C2 {
  ::S10103C84 s1489c1f0;
  ::S679C23 s1489c1f1;
  ::S10103C84 s1489c1f2;
  ::S10103C84 s1489c1f3;
  void *s1489c1f4;
  int s1489c1f5[2];
  virtual  ~S1489C1(); // _ZN7S1489C1D1Ev
  virtual void  v1(); // _ZN7S1489C12v1Ev
  virtual void  v2(); // _ZN7S1489C12v2Ev
  virtual void  v3(); // _ZN7S1489C12v3Ev
  virtual void  v4(); // _ZN7S1489C12v4Ev
  S1489C1(); // tgen
};
//SIG(1 S1489C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 Fi Fc[2] Fi} vd v1 v2 v3 v4 FC14{ BC15{ BC16{ vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fp[2] FC5 Fp} vd v47 v48 v49 v50 v51 v52 Fp Fi FC8 FC12 Fi} vd v33 v34 v35 v36 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC17{ BC18{ BC19{ vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fp[2] FC5 Fp} vd v67 v68 v69 v70 v71 v72 Fp Fi FC20{ m Fp Fi FC21{ m} FC21} FC12 Fi} vd v53 v54 v55 v56 FC22{ m FC13} FC22 Fi[6] FC23{ m FC24{ m FL}} FC23 Fc[7] Fi[2] FC12 FC12 FC12 FC12 FC12 Fc[7]} FC14 FC14 Fp Fi[2]}


 S1489C1 ::~S1489C1(){ note_dtor("S1489C1", this);}
void  S1489C1 ::v1(){vfunc_called(this, "_ZN7S1489C12v1Ev");}
void  S1489C1 ::v2(){vfunc_called(this, "_ZN7S1489C12v2Ev");}
void  S1489C1 ::v3(){vfunc_called(this, "_ZN7S1489C12v3Ev");}
void  S1489C1 ::v4(){vfunc_called(this, "_ZN7S1489C12v4Ev");}
S1489C1 ::S1489C1(){ note_ctor("S1489C1", this);} // tgen

static void Test_S1489C1()
{
  extern Class_Descriptor cd_S1489C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(169,260)];
    init_test(&cd_S1489C1, buf);
    S1489C1 *dp, &lv = *(dp=new (buf) S1489C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1344,1036), "sizeof(S1489C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1489C1)");
    check_base_class_offset(lv, (S1489C4*)(S1489C3*)(S1489C2*), 0, "S1489C1");
    check_base_class_offset(lv, (S1489C3*)(S1489C2*), 0, "S1489C1");
    check_base_class_offset(lv, (S1489C2*), 0, "S1489C1");
    check_field_offset(lv, s1489c1f0, ABISELECT(152,104), "S1489C1.s1489c1f0");
    check_field_offset(lv, s1489c1f1, ABISELECT(448,328), "S1489C1.s1489c1f1");
    check_field_offset(lv, s1489c1f2, ABISELECT(736,576), "S1489C1.s1489c1f2");
    check_field_offset(lv, s1489c1f3, ABISELECT(1032,800), "S1489C1.s1489c1f3");
    check_field_offset(lv, s1489c1f4, ABISELECT(1328,1024), "S1489C1.s1489c1f4");
    check_field_offset(lv, s1489c1f5, ABISELECT(1336,1028), "S1489C1.s1489c1f5");
    test_class_info(&lv, &cd_S1489C1);
    dp->~S1489C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1489C1(Test_S1489C1, "S1489C1", ABISELECT(1344,1036));

#else // __cplusplus

extern void _ZN7S1489C1C1Ev();
extern void _ZN7S1489C1D1Ev();
Name_Map name_map_S1489C1[] = {
  NSPAIR(_ZN7S1489C1C1Ev),
  NSPAIR(_ZN7S1489C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1489C4;
extern VTBL_ENTRY _ZTI7S1489C4[];
extern  VTBL_ENTRY _ZTV7S1489C4[];
extern Class_Descriptor cd_S1489C3;
extern VTBL_ENTRY _ZTI7S1489C3[];
extern  VTBL_ENTRY _ZTV7S1489C3[];
extern Class_Descriptor cd_S1489C2;
extern VTBL_ENTRY _ZTI7S1489C2[];
extern  VTBL_ENTRY _ZTV7S1489C2[];
static Base_Class bases_S1489C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1489C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1489C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1489C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1489C1[];
extern void _ZN7S1489C1D1Ev();
extern void _ZN7S1489C1D0Ev();
extern void _ZN7S1489C42v5Ev();
extern void _ZN7S1489C42v6Ev();
extern void _ZN7S1489C42v7Ev();
extern void _ZN7S1489C42v8Ev();
extern void _ZN7S1489C42v9Ev();
extern void _ZN7S1489C43v10Ev();
extern void _ZN7S1489C43v11Ev();
extern void _ZN7S1489C43v12Ev();
extern void _ZN7S1489C43v13Ev();
extern void _ZN7S1489C43v14Ev();
extern void _ZN7S1489C33v15Ev();
extern void _ZN7S1489C33v16Ev();
extern void _ZN7S1489C33v17Ev();
extern void _ZN7S1489C33v18Ev();
extern void _ZN7S1489C33v19Ev();
extern void _ZN7S1489C33v20Ev();
extern void _ZN7S1489C33v21Ev();
extern void _ZN7S1489C33v22Ev();
extern void _ZN7S1489C33v23Ev();
extern void _ZN7S1489C33v24Ev();
extern void _ZN7S1489C33v25Ev();
extern void _ZN7S1489C33v26Ev();
extern void _ZN7S1489C33v27Ev();
extern void _ZN7S1489C33v28Ev();
extern void _ZN7S1489C23v29Ev();
extern void _ZN7S1489C23v30Ev();
extern void _ZN7S1489C23v31Ev();
extern void _ZN7S1489C23v32Ev();
extern void _ZN7S1489C12v1Ev();
extern void _ZN7S1489C12v2Ev();
extern void _ZN7S1489C12v3Ev();
extern void _ZN7S1489C12v4Ev();
static  VTBL_ENTRY vtc_S1489C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1489C1[0]),
  (VTBL_ENTRY)&_ZN7S1489C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1489C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1489C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1489C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1489C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1489C23v32Ev,
  (VTBL_ENTRY)&_ZN7S1489C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1489C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1489C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1489C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S1489C1[];
extern  VTBL_ENTRY _ZTV7S1489C1[];
Class_Descriptor cd_S1489C1 = {  "S1489C1", // class name
  bases_S1489C1, 3,
  &(vtc_S1489C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1344,1036), // object size
  NSPAIRA(_ZTI7S1489C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1489C1),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1388C4  {
  void *s1388c4f0[2];
  ::S10103C13_nt s1388c4f1;
  void *s1388c4f2;
  virtual  ~S1388C4(); // _ZN7S1388C4D1Ev
  virtual void  v3(); // _ZN7S1388C42v3Ev
  virtual void  v4(); // _ZN7S1388C42v4Ev
  virtual void  v5(); // _ZN7S1388C42v5Ev
  virtual void  v6(); // _ZN7S1388C42v6Ev
  virtual void  v7(); // _ZN7S1388C42v7Ev
  virtual void  v8(); // _ZN7S1388C42v8Ev
  virtual void  v9(); // _ZN7S1388C42v9Ev
  virtual void  v10(); // _ZN7S1388C43v10Ev
  virtual void  v11(); // _ZN7S1388C43v11Ev
  virtual void  v12(); // _ZN7S1388C43v12Ev
  S1388C4(); // tgen
};
//SIG(-1 S1388C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1388C4 ::~S1388C4(){ note_dtor("S1388C4", this);}
void  S1388C4 ::v3(){vfunc_called(this, "_ZN7S1388C42v3Ev");}
void  S1388C4 ::v4(){vfunc_called(this, "_ZN7S1388C42v4Ev");}
void  S1388C4 ::v5(){vfunc_called(this, "_ZN7S1388C42v5Ev");}
void  S1388C4 ::v6(){vfunc_called(this, "_ZN7S1388C42v6Ev");}
void  S1388C4 ::v7(){vfunc_called(this, "_ZN7S1388C42v7Ev");}
void  S1388C4 ::v8(){vfunc_called(this, "_ZN7S1388C42v8Ev");}
void  S1388C4 ::v9(){vfunc_called(this, "_ZN7S1388C42v9Ev");}
void  S1388C4 ::v10(){vfunc_called(this, "_ZN7S1388C43v10Ev");}
void  S1388C4 ::v11(){vfunc_called(this, "_ZN7S1388C43v11Ev");}
void  S1388C4 ::v12(){vfunc_called(this, "_ZN7S1388C43v12Ev");}
S1388C4 ::S1388C4(){ note_ctor("S1388C4", this);} // tgen

static void Test_S1388C4()
{
  extern Class_Descriptor cd_S1388C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1388C4, buf);
    S1388C4 *dp, &lv = *(dp=new (buf) S1388C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1388C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1388C4)");
    check_field_offset(lv, s1388c4f0, ABISELECT(8,4), "S1388C4.s1388c4f0");
    check_field_offset(lv, s1388c4f1, ABISELECT(24,12), "S1388C4.s1388c4f1");
    check_field_offset(lv, s1388c4f2, ABISELECT(48,28), "S1388C4.s1388c4f2");
    test_class_info(&lv, &cd_S1388C4);
    dp->~S1388C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1388C4(Test_S1388C4, "S1388C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1388C4C1Ev();
extern void _ZN7S1388C4D1Ev();
Name_Map name_map_S1388C4[] = {
  NSPAIR(_ZN7S1388C4C1Ev),
  NSPAIR(_ZN7S1388C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1388C4[];
extern void _ZN7S1388C4D1Ev();
extern void _ZN7S1388C4D0Ev();
extern void _ZN7S1388C42v3Ev();
extern void _ZN7S1388C42v4Ev();
extern void _ZN7S1388C42v5Ev();
extern void _ZN7S1388C42v6Ev();
extern void _ZN7S1388C42v7Ev();
extern void _ZN7S1388C42v8Ev();
extern void _ZN7S1388C42v9Ev();
extern void _ZN7S1388C43v10Ev();
extern void _ZN7S1388C43v11Ev();
extern void _ZN7S1388C43v12Ev();
static  VTBL_ENTRY vtc_S1388C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1388C4[0]),
  (VTBL_ENTRY)&_ZN7S1388C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1388C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S1388C4[];
extern  VTBL_ENTRY _ZTV7S1388C4[];
Class_Descriptor cd_S1388C4 = {  "S1388C4", // class name
  0,0,//no base classes
  &(vtc_S1388C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1388C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1388C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1388C3  : S1388C4 {
  ::S10103C86 s1388c3f0;
  ::S10103C106 s1388c3f1;
  ::S10103C82_nt s1388c3f2;
  ::S10103C13_nt s1388c3f3;
  virtual  ~S1388C3(); // _ZN7S1388C3D1Ev
  virtual void  v13(); // _ZN7S1388C33v13Ev
  virtual void  v14(); // _ZN7S1388C33v14Ev
  virtual void  v15(); // _ZN7S1388C33v15Ev
  virtual void  v16(); // _ZN7S1388C33v16Ev
  virtual void  v17(); // _ZN7S1388C33v17Ev
  virtual void  v18(); // _ZN7S1388C33v18Ev
  virtual void  v19(); // _ZN7S1388C33v19Ev
  virtual void  v20(); // _ZN7S1388C33v20Ev
  virtual void  v21(); // _ZN7S1388C33v21Ev
  virtual void  v22(); // _ZN7S1388C33v22Ev
  virtual void  v23(); // _ZN7S1388C33v23Ev
  virtual void  v24(); // _ZN7S1388C33v24Ev
  virtual void  v25(); // _ZN7S1388C33v25Ev
  virtual void  v26(); // _ZN7S1388C33v26Ev
  S1388C3(); // tgen
};
//SIG(-1 S1388C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1388C3 ::~S1388C3(){ note_dtor("S1388C3", this);}
void  S1388C3 ::v13(){vfunc_called(this, "_ZN7S1388C33v13Ev");}
void  S1388C3 ::v14(){vfunc_called(this, "_ZN7S1388C33v14Ev");}
void  S1388C3 ::v15(){vfunc_called(this, "_ZN7S1388C33v15Ev");}
void  S1388C3 ::v16(){vfunc_called(this, "_ZN7S1388C33v16Ev");}
void  S1388C3 ::v17(){vfunc_called(this, "_ZN7S1388C33v17Ev");}
void  S1388C3 ::v18(){vfunc_called(this, "_ZN7S1388C33v18Ev");}
void  S1388C3 ::v19(){vfunc_called(this, "_ZN7S1388C33v19Ev");}
void  S1388C3 ::v20(){vfunc_called(this, "_ZN7S1388C33v20Ev");}
void  S1388C3 ::v21(){vfunc_called(this, "_ZN7S1388C33v21Ev");}
void  S1388C3 ::v22(){vfunc_called(this, "_ZN7S1388C33v22Ev");}
void  S1388C3 ::v23(){vfunc_called(this, "_ZN7S1388C33v23Ev");}
void  S1388C3 ::v24(){vfunc_called(this, "_ZN7S1388C33v24Ev");}
void  S1388C3 ::v25(){vfunc_called(this, "_ZN7S1388C33v25Ev");}
void  S1388C3 ::v26(){vfunc_called(this, "_ZN7S1388C33v26Ev");}
S1388C3 ::S1388C3(){ note_ctor("S1388C3", this);} // tgen

static void Test_S1388C3()
{
  extern Class_Descriptor cd_S1388C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1388C3, buf);
    S1388C3 *dp, &lv = *(dp=new (buf) S1388C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1388C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1388C3)");
    check_base_class_offset(lv, (S1388C4*), 0, "S1388C3");
    check_field_offset(lv, s1388c3f0, ABISELECT(56,32), "S1388C3.s1388c3f0");
    check_field_offset(lv, s1388c3f1, ABISELECT(72,44), "S1388C3.s1388c3f1");
    check_field_offset(lv, s1388c3f2, ABISELECT(96,60), "S1388C3.s1388c3f2");
    check_field_offset(lv, s1388c3f3, ABISELECT(112,76), "S1388C3.s1388c3f3");
    test_class_info(&lv, &cd_S1388C3);
    dp->~S1388C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1388C3(Test_S1388C3, "S1388C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1388C3C1Ev();
extern void _ZN7S1388C3D1Ev();
Name_Map name_map_S1388C3[] = {
  NSPAIR(_ZN7S1388C3C1Ev),
  NSPAIR(_ZN7S1388C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1388C4;
extern VTBL_ENTRY _ZTI7S1388C4[];
extern  VTBL_ENTRY _ZTV7S1388C4[];
static Base_Class bases_S1388C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1388C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1388C3[];
extern void _ZN7S1388C3D1Ev();
extern void _ZN7S1388C3D0Ev();
extern void _ZN7S1388C42v3Ev();
extern void _ZN7S1388C42v4Ev();
extern void _ZN7S1388C42v5Ev();
extern void _ZN7S1388C42v6Ev();
extern void _ZN7S1388C42v7Ev();
extern void _ZN7S1388C42v8Ev();
extern void _ZN7S1388C42v9Ev();
extern void _ZN7S1388C43v10Ev();
extern void _ZN7S1388C43v11Ev();
extern void _ZN7S1388C43v12Ev();
extern void _ZN7S1388C33v13Ev();
extern void _ZN7S1388C33v14Ev();
extern void _ZN7S1388C33v15Ev();
extern void _ZN7S1388C33v16Ev();
extern void _ZN7S1388C33v17Ev();
extern void _ZN7S1388C33v18Ev();
extern void _ZN7S1388C33v19Ev();
extern void _ZN7S1388C33v20Ev();
extern void _ZN7S1388C33v21Ev();
extern void _ZN7S1388C33v22Ev();
extern void _ZN7S1388C33v23Ev();
extern void _ZN7S1388C33v24Ev();
extern void _ZN7S1388C33v25Ev();
extern void _ZN7S1388C33v26Ev();
static  VTBL_ENTRY vtc_S1388C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1388C3[0]),
  (VTBL_ENTRY)&_ZN7S1388C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1388C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v26Ev,
};
extern VTBL_ENTRY _ZTI7S1388C3[];
extern  VTBL_ENTRY _ZTV7S1388C3[];
Class_Descriptor cd_S1388C3 = {  "S1388C3", // class name
  bases_S1388C3, 1,
  &(vtc_S1388C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1388C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1388C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1388C2  : S1388C3 {
  ::S10103C84 s1388c2f0;
  ::S679C23 s1388c2f1;
  void *s1388c2f2;
  virtual  ~S1388C2(); // _ZN7S1388C2D1Ev
  virtual void  v27(); // _ZN7S1388C23v27Ev
  virtual void  v28(); // _ZN7S1388C23v28Ev
  virtual void  v29(); // _ZN7S1388C23v29Ev
  virtual void  v30(); // _ZN7S1388C23v30Ev
  S1388C2(); // tgen
};
//SIG(-1 S1388C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 v2 v3 v4 FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]} FC16{ BC17{ BC18{ vd v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 Fp[2] FC4 Fp} vd v63 v64 v65 v66 v67 v68 Fp Fi FC19{ m Fp Fi FC20{ m} FC20} FC11 Fi} vd v49 v50 v51 v52 FC21{ m FC12} FC21 Fi[6] FC22{ m FC23{ m FL}} FC22 Fc[7] Fi[2] FC11 FC11 FC11 FC11 FC11 Fc[7]} Fp}


 S1388C2 ::~S1388C2(){ note_dtor("S1388C2", this);}
void  S1388C2 ::v27(){vfunc_called(this, "_ZN7S1388C23v27Ev");}
void  S1388C2 ::v28(){vfunc_called(this, "_ZN7S1388C23v28Ev");}
void  S1388C2 ::v29(){vfunc_called(this, "_ZN7S1388C23v29Ev");}
void  S1388C2 ::v30(){vfunc_called(this, "_ZN7S1388C23v30Ev");}
S1388C2 ::S1388C2(){ note_ctor("S1388C2", this);} // tgen

static void Test_S1388C2()
{
  extern Class_Descriptor cd_S1388C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(92,143)];
    init_test(&cd_S1388C2, buf);
    S1388C2 *dp, &lv = *(dp=new (buf) S1388C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(728,568), "sizeof(S1388C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1388C2)");
    check_base_class_offset(lv, (S1388C4*)(S1388C3*), 0, "S1388C2");
    check_base_class_offset(lv, (S1388C3*), 0, "S1388C2");
    check_field_offset(lv, s1388c2f0, ABISELECT(136,92), "S1388C2.s1388c2f0");
    check_field_offset(lv, s1388c2f1, ABISELECT(432,316), "S1388C2.s1388c2f1");
    check_field_offset(lv, s1388c2f2, ABISELECT(720,564), "S1388C2.s1388c2f2");
    test_class_info(&lv, &cd_S1388C2);
    dp->~S1388C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1388C2(Test_S1388C2, "S1388C2", ABISELECT(728,568));

#else // __cplusplus

extern void _ZN7S1388C2C1Ev();
extern void _ZN7S1388C2D1Ev();
Name_Map name_map_S1388C2[] = {
  NSPAIR(_ZN7S1388C2C1Ev),
  NSPAIR(_ZN7S1388C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1388C4;
extern VTBL_ENTRY _ZTI7S1388C4[];
extern  VTBL_ENTRY _ZTV7S1388C4[];
extern Class_Descriptor cd_S1388C3;
extern VTBL_ENTRY _ZTI7S1388C3[];
extern  VTBL_ENTRY _ZTV7S1388C3[];
static Base_Class bases_S1388C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1388C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1388C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1388C2[];
extern void _ZN7S1388C2D1Ev();
extern void _ZN7S1388C2D0Ev();
extern void _ZN7S1388C42v3Ev();
extern void _ZN7S1388C42v4Ev();
extern void _ZN7S1388C42v5Ev();
extern void _ZN7S1388C42v6Ev();
extern void _ZN7S1388C42v7Ev();
extern void _ZN7S1388C42v8Ev();
extern void _ZN7S1388C42v9Ev();
extern void _ZN7S1388C43v10Ev();
extern void _ZN7S1388C43v11Ev();
extern void _ZN7S1388C43v12Ev();
extern void _ZN7S1388C33v13Ev();
extern void _ZN7S1388C33v14Ev();
extern void _ZN7S1388C33v15Ev();
extern void _ZN7S1388C33v16Ev();
extern void _ZN7S1388C33v17Ev();
extern void _ZN7S1388C33v18Ev();
extern void _ZN7S1388C33v19Ev();
extern void _ZN7S1388C33v20Ev();
extern void _ZN7S1388C33v21Ev();
extern void _ZN7S1388C33v22Ev();
extern void _ZN7S1388C33v23Ev();
extern void _ZN7S1388C33v24Ev();
extern void _ZN7S1388C33v25Ev();
extern void _ZN7S1388C33v26Ev();
extern void _ZN7S1388C23v27Ev();
extern void _ZN7S1388C23v28Ev();
extern void _ZN7S1388C23v29Ev();
extern void _ZN7S1388C23v30Ev();
static  VTBL_ENTRY vtc_S1388C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1388C2[0]),
  (VTBL_ENTRY)&_ZN7S1388C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1388C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v30Ev,
};
extern VTBL_ENTRY _ZTI7S1388C2[];
extern  VTBL_ENTRY _ZTV7S1388C2[];
Class_Descriptor cd_S1388C2 = {  "S1388C2", // class name
  bases_S1388C2, 2,
  &(vtc_S1388C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(728,568), // object size
  NSPAIRA(_ZTI7S1388C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1388C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1388C1  : S1388C2 {
  ::S10103C84 s1388c1f0;
  virtual  ~S1388C1(); // _ZN7S1388C1D1Ev
  virtual void  v1(); // _ZN7S1388C12v1Ev
  virtual void  v2(); // _ZN7S1388C12v2Ev
  S1388C1(); // tgen
};
//SIG(1 S1388C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} vd v27 v28 v29 v30 FC14{ BC15{ BC16{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp[2] FC5 Fp} vd v45 v46 v47 v48 v49 v50 Fp Fi FC8 FC12 Fi} vd v31 v32 v33 v34 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC17{ BC18{ BC19{ vd v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fp[2] FC5 Fp} vd v65 v66 v67 v68 v69 v70 Fp Fi FC20{ m Fp Fi FC21{ m} FC21} FC12 Fi} vd v51 v52 v53 v54 FC22{ m FC13} FC22 Fi[6] FC23{ m FC24{ m FL}} FC23 Fc[7] Fi[2] FC12 FC12 FC12 FC12 FC12 Fc[7]} Fp} vd v1 v2 FC14}


 S1388C1 ::~S1388C1(){ note_dtor("S1388C1", this);}
void  S1388C1 ::v1(){vfunc_called(this, "_ZN7S1388C12v1Ev");}
void  S1388C1 ::v2(){vfunc_called(this, "_ZN7S1388C12v2Ev");}
S1388C1 ::S1388C1(){ note_ctor("S1388C1", this);} // tgen

static void Test_S1388C1()
{
  extern Class_Descriptor cd_S1388C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(129,199)];
    init_test(&cd_S1388C1, buf);
    S1388C1 *dp, &lv = *(dp=new (buf) S1388C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1024,792), "sizeof(S1388C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1388C1)");
    check_base_class_offset(lv, (S1388C4*)(S1388C3*)(S1388C2*), 0, "S1388C1");
    check_base_class_offset(lv, (S1388C3*)(S1388C2*), 0, "S1388C1");
    check_base_class_offset(lv, (S1388C2*), 0, "S1388C1");
    check_field_offset(lv, s1388c1f0, ABISELECT(728,568), "S1388C1.s1388c1f0");
    test_class_info(&lv, &cd_S1388C1);
    dp->~S1388C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1388C1(Test_S1388C1, "S1388C1", ABISELECT(1024,792));

#else // __cplusplus

extern void _ZN7S1388C1C1Ev();
extern void _ZN7S1388C1D1Ev();
Name_Map name_map_S1388C1[] = {
  NSPAIR(_ZN7S1388C1C1Ev),
  NSPAIR(_ZN7S1388C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1388C4;
extern VTBL_ENTRY _ZTI7S1388C4[];
extern  VTBL_ENTRY _ZTV7S1388C4[];
extern Class_Descriptor cd_S1388C3;
extern VTBL_ENTRY _ZTI7S1388C3[];
extern  VTBL_ENTRY _ZTV7S1388C3[];
extern Class_Descriptor cd_S1388C2;
extern VTBL_ENTRY _ZTI7S1388C2[];
extern  VTBL_ENTRY _ZTV7S1388C2[];
static Base_Class bases_S1388C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1388C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1388C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1388C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1388C1[];
extern void _ZN7S1388C1D1Ev();
extern void _ZN7S1388C1D0Ev();
extern void _ZN7S1388C42v3Ev();
extern void _ZN7S1388C42v4Ev();
extern void _ZN7S1388C42v5Ev();
extern void _ZN7S1388C42v6Ev();
extern void _ZN7S1388C42v7Ev();
extern void _ZN7S1388C42v8Ev();
extern void _ZN7S1388C42v9Ev();
extern void _ZN7S1388C43v10Ev();
extern void _ZN7S1388C43v11Ev();
extern void _ZN7S1388C43v12Ev();
extern void _ZN7S1388C33v13Ev();
extern void _ZN7S1388C33v14Ev();
extern void _ZN7S1388C33v15Ev();
extern void _ZN7S1388C33v16Ev();
extern void _ZN7S1388C33v17Ev();
extern void _ZN7S1388C33v18Ev();
extern void _ZN7S1388C33v19Ev();
extern void _ZN7S1388C33v20Ev();
extern void _ZN7S1388C33v21Ev();
extern void _ZN7S1388C33v22Ev();
extern void _ZN7S1388C33v23Ev();
extern void _ZN7S1388C33v24Ev();
extern void _ZN7S1388C33v25Ev();
extern void _ZN7S1388C33v26Ev();
extern void _ZN7S1388C23v27Ev();
extern void _ZN7S1388C23v28Ev();
extern void _ZN7S1388C23v29Ev();
extern void _ZN7S1388C23v30Ev();
extern void _ZN7S1388C12v1Ev();
extern void _ZN7S1388C12v2Ev();
static  VTBL_ENTRY vtc_S1388C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1388C1[0]),
  (VTBL_ENTRY)&_ZN7S1388C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1388C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1388C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1388C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1388C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1388C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1388C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1388C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S1388C1[];
extern  VTBL_ENTRY _ZTV7S1388C1[];
Class_Descriptor cd_S1388C1 = {  "S1388C1", // class name
  bases_S1388C1, 3,
  &(vtc_S1388C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1024,792), // object size
  NSPAIRA(_ZTI7S1388C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1388C1),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1491C4  {
  void *s1491c4f0[2];
  ::S10103C13_nt s1491c4f1;
  void *s1491c4f2;
  virtual  ~S1491C4(); // _ZN7S1491C4D1Ev
  virtual void  v5(); // _ZN7S1491C42v5Ev
  virtual void  v6(); // _ZN7S1491C42v6Ev
  virtual void  v7(); // _ZN7S1491C42v7Ev
  virtual void  v8(); // _ZN7S1491C42v8Ev
  virtual void  v9(); // _ZN7S1491C42v9Ev
  virtual void  v10(); // _ZN7S1491C43v10Ev
  virtual void  v11(); // _ZN7S1491C43v11Ev
  virtual void  v12(); // _ZN7S1491C43v12Ev
  virtual void  v13(); // _ZN7S1491C43v13Ev
  virtual void  v14(); // _ZN7S1491C43v14Ev
  S1491C4(); // tgen
};
//SIG(-1 S1491C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1491C4 ::~S1491C4(){ note_dtor("S1491C4", this);}
void  S1491C4 ::v5(){vfunc_called(this, "_ZN7S1491C42v5Ev");}
void  S1491C4 ::v6(){vfunc_called(this, "_ZN7S1491C42v6Ev");}
void  S1491C4 ::v7(){vfunc_called(this, "_ZN7S1491C42v7Ev");}
void  S1491C4 ::v8(){vfunc_called(this, "_ZN7S1491C42v8Ev");}
void  S1491C4 ::v9(){vfunc_called(this, "_ZN7S1491C42v9Ev");}
void  S1491C4 ::v10(){vfunc_called(this, "_ZN7S1491C43v10Ev");}
void  S1491C4 ::v11(){vfunc_called(this, "_ZN7S1491C43v11Ev");}
void  S1491C4 ::v12(){vfunc_called(this, "_ZN7S1491C43v12Ev");}
void  S1491C4 ::v13(){vfunc_called(this, "_ZN7S1491C43v13Ev");}
void  S1491C4 ::v14(){vfunc_called(this, "_ZN7S1491C43v14Ev");}
S1491C4 ::S1491C4(){ note_ctor("S1491C4", this);} // tgen

static void Test_S1491C4()
{
  extern Class_Descriptor cd_S1491C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1491C4, buf);
    S1491C4 *dp, &lv = *(dp=new (buf) S1491C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1491C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1491C4)");
    check_field_offset(lv, s1491c4f0, ABISELECT(8,4), "S1491C4.s1491c4f0");
    check_field_offset(lv, s1491c4f1, ABISELECT(24,12), "S1491C4.s1491c4f1");
    check_field_offset(lv, s1491c4f2, ABISELECT(48,28), "S1491C4.s1491c4f2");
    test_class_info(&lv, &cd_S1491C4);
    dp->~S1491C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1491C4(Test_S1491C4, "S1491C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1491C4C1Ev();
extern void _ZN7S1491C4D1Ev();
Name_Map name_map_S1491C4[] = {
  NSPAIR(_ZN7S1491C4C1Ev),
  NSPAIR(_ZN7S1491C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1491C4[];
extern void _ZN7S1491C4D1Ev();
extern void _ZN7S1491C4D0Ev();
extern void _ZN7S1491C42v5Ev();
extern void _ZN7S1491C42v6Ev();
extern void _ZN7S1491C42v7Ev();
extern void _ZN7S1491C42v8Ev();
extern void _ZN7S1491C42v9Ev();
extern void _ZN7S1491C43v10Ev();
extern void _ZN7S1491C43v11Ev();
extern void _ZN7S1491C43v12Ev();
extern void _ZN7S1491C43v13Ev();
extern void _ZN7S1491C43v14Ev();
static  VTBL_ENTRY vtc_S1491C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1491C4[0]),
  (VTBL_ENTRY)&_ZN7S1491C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1491C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S1491C4[];
extern  VTBL_ENTRY _ZTV7S1491C4[];
Class_Descriptor cd_S1491C4 = {  "S1491C4", // class name
  0,0,//no base classes
  &(vtc_S1491C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1491C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1491C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1491C3  : S1491C4 {
  ::S10103C86 s1491c3f0;
  ::S10103C106 s1491c3f1;
  ::S10103C82_nt s1491c3f2;
  ::S10103C13_nt s1491c3f3;
  virtual  ~S1491C3(); // _ZN7S1491C3D1Ev
  virtual void  v15(); // _ZN7S1491C33v15Ev
  virtual void  v16(); // _ZN7S1491C33v16Ev
  virtual void  v17(); // _ZN7S1491C33v17Ev
  virtual void  v18(); // _ZN7S1491C33v18Ev
  virtual void  v19(); // _ZN7S1491C33v19Ev
  virtual void  v20(); // _ZN7S1491C33v20Ev
  virtual void  v21(); // _ZN7S1491C33v21Ev
  virtual void  v22(); // _ZN7S1491C33v22Ev
  virtual void  v23(); // _ZN7S1491C33v23Ev
  virtual void  v24(); // _ZN7S1491C33v24Ev
  virtual void  v25(); // _ZN7S1491C33v25Ev
  virtual void  v26(); // _ZN7S1491C33v26Ev
  virtual void  v27(); // _ZN7S1491C33v27Ev
  virtual void  v28(); // _ZN7S1491C33v28Ev
  S1491C3(); // tgen
};
//SIG(-1 S1491C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1491C3 ::~S1491C3(){ note_dtor("S1491C3", this);}
void  S1491C3 ::v15(){vfunc_called(this, "_ZN7S1491C33v15Ev");}
void  S1491C3 ::v16(){vfunc_called(this, "_ZN7S1491C33v16Ev");}
void  S1491C3 ::v17(){vfunc_called(this, "_ZN7S1491C33v17Ev");}
void  S1491C3 ::v18(){vfunc_called(this, "_ZN7S1491C33v18Ev");}
void  S1491C3 ::v19(){vfunc_called(this, "_ZN7S1491C33v19Ev");}
void  S1491C3 ::v20(){vfunc_called(this, "_ZN7S1491C33v20Ev");}
void  S1491C3 ::v21(){vfunc_called(this, "_ZN7S1491C33v21Ev");}
void  S1491C3 ::v22(){vfunc_called(this, "_ZN7S1491C33v22Ev");}
void  S1491C3 ::v23(){vfunc_called(this, "_ZN7S1491C33v23Ev");}
void  S1491C3 ::v24(){vfunc_called(this, "_ZN7S1491C33v24Ev");}
void  S1491C3 ::v25(){vfunc_called(this, "_ZN7S1491C33v25Ev");}
void  S1491C3 ::v26(){vfunc_called(this, "_ZN7S1491C33v26Ev");}
void  S1491C3 ::v27(){vfunc_called(this, "_ZN7S1491C33v27Ev");}
void  S1491C3 ::v28(){vfunc_called(this, "_ZN7S1491C33v28Ev");}
S1491C3 ::S1491C3(){ note_ctor("S1491C3", this);} // tgen

static void Test_S1491C3()
{
  extern Class_Descriptor cd_S1491C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1491C3, buf);
    S1491C3 *dp, &lv = *(dp=new (buf) S1491C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1491C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1491C3)");
    check_base_class_offset(lv, (S1491C4*), 0, "S1491C3");
    check_field_offset(lv, s1491c3f0, ABISELECT(56,32), "S1491C3.s1491c3f0");
    check_field_offset(lv, s1491c3f1, ABISELECT(72,44), "S1491C3.s1491c3f1");
    check_field_offset(lv, s1491c3f2, ABISELECT(96,60), "S1491C3.s1491c3f2");
    check_field_offset(lv, s1491c3f3, ABISELECT(112,76), "S1491C3.s1491c3f3");
    test_class_info(&lv, &cd_S1491C3);
    dp->~S1491C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1491C3(Test_S1491C3, "S1491C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1491C3C1Ev();
extern void _ZN7S1491C3D1Ev();
Name_Map name_map_S1491C3[] = {
  NSPAIR(_ZN7S1491C3C1Ev),
  NSPAIR(_ZN7S1491C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1491C4;
extern VTBL_ENTRY _ZTI7S1491C4[];
extern  VTBL_ENTRY _ZTV7S1491C4[];
static Base_Class bases_S1491C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1491C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1491C3[];
extern void _ZN7S1491C3D1Ev();
extern void _ZN7S1491C3D0Ev();
extern void _ZN7S1491C42v5Ev();
extern void _ZN7S1491C42v6Ev();
extern void _ZN7S1491C42v7Ev();
extern void _ZN7S1491C42v8Ev();
extern void _ZN7S1491C42v9Ev();
extern void _ZN7S1491C43v10Ev();
extern void _ZN7S1491C43v11Ev();
extern void _ZN7S1491C43v12Ev();
extern void _ZN7S1491C43v13Ev();
extern void _ZN7S1491C43v14Ev();
extern void _ZN7S1491C33v15Ev();
extern void _ZN7S1491C33v16Ev();
extern void _ZN7S1491C33v17Ev();
extern void _ZN7S1491C33v18Ev();
extern void _ZN7S1491C33v19Ev();
extern void _ZN7S1491C33v20Ev();
extern void _ZN7S1491C33v21Ev();
extern void _ZN7S1491C33v22Ev();
extern void _ZN7S1491C33v23Ev();
extern void _ZN7S1491C33v24Ev();
extern void _ZN7S1491C33v25Ev();
extern void _ZN7S1491C33v26Ev();
extern void _ZN7S1491C33v27Ev();
extern void _ZN7S1491C33v28Ev();
static  VTBL_ENTRY vtc_S1491C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1491C3[0]),
  (VTBL_ENTRY)&_ZN7S1491C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1491C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v28Ev,
};
extern VTBL_ENTRY _ZTI7S1491C3[];
extern  VTBL_ENTRY _ZTV7S1491C3[];
Class_Descriptor cd_S1491C3 = {  "S1491C3", // class name
  bases_S1491C3, 1,
  &(vtc_S1491C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1491C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1491C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1491C2  : S1491C3 {
  virtual  ~S1491C2(); // _ZN7S1491C2D1Ev
  virtual void  v29(); // _ZN7S1491C23v29Ev
  S1491C2(); // tgen
};
//SIG(-1 S1491C2) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1}


 S1491C2 ::~S1491C2(){ note_dtor("S1491C2", this);}
void  S1491C2 ::v29(){vfunc_called(this, "_ZN7S1491C23v29Ev");}
S1491C2 ::S1491C2(){ note_ctor("S1491C2", this);} // tgen

static void Test_S1491C2()
{
  extern Class_Descriptor cd_S1491C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1491C2, buf);
    S1491C2 *dp, &lv = *(dp=new (buf) S1491C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1491C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1491C2)");
    check_base_class_offset(lv, (S1491C4*)(S1491C3*), 0, "S1491C2");
    check_base_class_offset(lv, (S1491C3*), 0, "S1491C2");
    test_class_info(&lv, &cd_S1491C2);
    dp->~S1491C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1491C2(Test_S1491C2, "S1491C2", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1491C2C1Ev();
extern void _ZN7S1491C2D1Ev();
Name_Map name_map_S1491C2[] = {
  NSPAIR(_ZN7S1491C2C1Ev),
  NSPAIR(_ZN7S1491C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1491C4;
extern VTBL_ENTRY _ZTI7S1491C4[];
extern  VTBL_ENTRY _ZTV7S1491C4[];
extern Class_Descriptor cd_S1491C3;
extern VTBL_ENTRY _ZTI7S1491C3[];
extern  VTBL_ENTRY _ZTV7S1491C3[];
static Base_Class bases_S1491C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1491C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1491C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1491C2[];
extern void _ZN7S1491C2D1Ev();
extern void _ZN7S1491C2D0Ev();
extern void _ZN7S1491C42v5Ev();
extern void _ZN7S1491C42v6Ev();
extern void _ZN7S1491C42v7Ev();
extern void _ZN7S1491C42v8Ev();
extern void _ZN7S1491C42v9Ev();
extern void _ZN7S1491C43v10Ev();
extern void _ZN7S1491C43v11Ev();
extern void _ZN7S1491C43v12Ev();
extern void _ZN7S1491C43v13Ev();
extern void _ZN7S1491C43v14Ev();
extern void _ZN7S1491C33v15Ev();
extern void _ZN7S1491C33v16Ev();
extern void _ZN7S1491C33v17Ev();
extern void _ZN7S1491C33v18Ev();
extern void _ZN7S1491C33v19Ev();
extern void _ZN7S1491C33v20Ev();
extern void _ZN7S1491C33v21Ev();
extern void _ZN7S1491C33v22Ev();
extern void _ZN7S1491C33v23Ev();
extern void _ZN7S1491C33v24Ev();
extern void _ZN7S1491C33v25Ev();
extern void _ZN7S1491C33v26Ev();
extern void _ZN7S1491C33v27Ev();
extern void _ZN7S1491C33v28Ev();
extern void _ZN7S1491C23v29Ev();
static  VTBL_ENTRY vtc_S1491C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1491C2[0]),
  (VTBL_ENTRY)&_ZN7S1491C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1491C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1491C23v29Ev,
};
extern VTBL_ENTRY _ZTI7S1491C2[];
extern  VTBL_ENTRY _ZTV7S1491C2[];
Class_Descriptor cd_S1491C2 = {  "S1491C2", // class name
  bases_S1491C2, 2,
  &(vtc_S1491C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1491C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1491C2),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1491C1  : S1491C2 {
  ::S10103C84 s1491c1f0;
  ::S679C23 s1491c1f1;
  virtual  ~S1491C1(); // _ZN7S1491C1D1Ev
  virtual void  v1(); // _ZN7S1491C12v1Ev
  virtual void  v2(); // _ZN7S1491C12v2Ev
  virtual void  v3(); // _ZN7S1491C12v3Ev
  virtual void  v4(); // _ZN7S1491C12v4Ev
  S1491C1(); // tgen
};
//SIG(1 S1491C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} vd v29} vd v1 v2 v3 v4 FC14{ BC15{ BC16{ vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 Fp[2] FC5 Fp} vd v44 v45 v46 v47 v48 v49 Fp Fi FC8 FC12 Fi} vd v30 v31 v32 v33 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC17{ BC18{ BC19{ vd v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 Fp[2] FC5 Fp} vd v64 v65 v66 v67 v68 v69 Fp Fi FC20{ m Fp Fi FC21{ m} FC21} FC12 Fi} vd v50 v51 v52 v53 FC22{ m FC13} FC22 Fi[6] FC23{ m FC24{ m FL}} FC23 Fc[7] Fi[2] FC12 FC12 FC12 FC12 FC12 Fc[7]}}


 S1491C1 ::~S1491C1(){ note_dtor("S1491C1", this);}
void  S1491C1 ::v1(){vfunc_called(this, "_ZN7S1491C12v1Ev");}
void  S1491C1 ::v2(){vfunc_called(this, "_ZN7S1491C12v2Ev");}
void  S1491C1 ::v3(){vfunc_called(this, "_ZN7S1491C12v3Ev");}
void  S1491C1 ::v4(){vfunc_called(this, "_ZN7S1491C12v4Ev");}
S1491C1 ::S1491C1(){ note_ctor("S1491C1", this);} // tgen

static void Test_S1491C1()
{
  extern Class_Descriptor cd_S1491C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(91,142)];
    init_test(&cd_S1491C1, buf);
    S1491C1 *dp, &lv = *(dp=new (buf) S1491C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(720,564), "sizeof(S1491C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1491C1)");
    check_base_class_offset(lv, (S1491C4*)(S1491C3*)(S1491C2*), 0, "S1491C1");
    check_base_class_offset(lv, (S1491C3*)(S1491C2*), 0, "S1491C1");
    check_base_class_offset(lv, (S1491C2*), 0, "S1491C1");
    check_field_offset(lv, s1491c1f0, ABISELECT(136,92), "S1491C1.s1491c1f0");
    check_field_offset(lv, s1491c1f1, ABISELECT(432,316), "S1491C1.s1491c1f1");
    test_class_info(&lv, &cd_S1491C1);
    dp->~S1491C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1491C1(Test_S1491C1, "S1491C1", ABISELECT(720,564));

#else // __cplusplus

extern void _ZN7S1491C1C1Ev();
extern void _ZN7S1491C1D1Ev();
Name_Map name_map_S1491C1[] = {
  NSPAIR(_ZN7S1491C1C1Ev),
  NSPAIR(_ZN7S1491C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1491C4;
extern VTBL_ENTRY _ZTI7S1491C4[];
extern  VTBL_ENTRY _ZTV7S1491C4[];
extern Class_Descriptor cd_S1491C3;
extern VTBL_ENTRY _ZTI7S1491C3[];
extern  VTBL_ENTRY _ZTV7S1491C3[];
extern Class_Descriptor cd_S1491C2;
extern VTBL_ENTRY _ZTI7S1491C2[];
extern  VTBL_ENTRY _ZTV7S1491C2[];
static Base_Class bases_S1491C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1491C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1491C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1491C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1491C1[];
extern void _ZN7S1491C1D1Ev();
extern void _ZN7S1491C1D0Ev();
extern void _ZN7S1491C42v5Ev();
extern void _ZN7S1491C42v6Ev();
extern void _ZN7S1491C42v7Ev();
extern void _ZN7S1491C42v8Ev();
extern void _ZN7S1491C42v9Ev();
extern void _ZN7S1491C43v10Ev();
extern void _ZN7S1491C43v11Ev();
extern void _ZN7S1491C43v12Ev();
extern void _ZN7S1491C43v13Ev();
extern void _ZN7S1491C43v14Ev();
extern void _ZN7S1491C33v15Ev();
extern void _ZN7S1491C33v16Ev();
extern void _ZN7S1491C33v17Ev();
extern void _ZN7S1491C33v18Ev();
extern void _ZN7S1491C33v19Ev();
extern void _ZN7S1491C33v20Ev();
extern void _ZN7S1491C33v21Ev();
extern void _ZN7S1491C33v22Ev();
extern void _ZN7S1491C33v23Ev();
extern void _ZN7S1491C33v24Ev();
extern void _ZN7S1491C33v25Ev();
extern void _ZN7S1491C33v26Ev();
extern void _ZN7S1491C33v27Ev();
extern void _ZN7S1491C33v28Ev();
extern void _ZN7S1491C23v29Ev();
extern void _ZN7S1491C12v1Ev();
extern void _ZN7S1491C12v2Ev();
extern void _ZN7S1491C12v3Ev();
extern void _ZN7S1491C12v4Ev();
static  VTBL_ENTRY vtc_S1491C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1491C1[0]),
  (VTBL_ENTRY)&_ZN7S1491C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1491C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1491C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1491C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1491C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1491C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1491C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1491C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1491C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1491C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S1491C1[];
extern  VTBL_ENTRY _ZTV7S1491C1[];
Class_Descriptor cd_S1491C1 = {  "S1491C1", // class name
  bases_S1491C1, 3,
  &(vtc_S1491C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(720,564), // object size
  NSPAIRA(_ZTI7S1491C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1491C1),33, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3323C3  {
  void *s3323c3f0[2];
  ::S10103C13_nt s3323c3f1;
  void *s3323c3f2;
  virtual  ~S3323C3(); // _ZN7S3323C3D1Ev
  virtual void  v5(); // _ZN7S3323C32v5Ev
  virtual void  v6(); // _ZN7S3323C32v6Ev
  virtual void  v7(); // _ZN7S3323C32v7Ev
  virtual void  v8(); // _ZN7S3323C32v8Ev
  virtual void  v9(); // _ZN7S3323C32v9Ev
  virtual void  v10(); // _ZN7S3323C33v10Ev
  virtual void  v11(); // _ZN7S3323C33v11Ev
  virtual void  v12(); // _ZN7S3323C33v12Ev
  virtual void  v13(); // _ZN7S3323C33v13Ev
  virtual void  v14(); // _ZN7S3323C33v14Ev
  S3323C3(); // tgen
};
//SIG(-1 S3323C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S3323C3 ::~S3323C3(){ note_dtor("S3323C3", this);}
void  S3323C3 ::v5(){vfunc_called(this, "_ZN7S3323C32v5Ev");}
void  S3323C3 ::v6(){vfunc_called(this, "_ZN7S3323C32v6Ev");}
void  S3323C3 ::v7(){vfunc_called(this, "_ZN7S3323C32v7Ev");}
void  S3323C3 ::v8(){vfunc_called(this, "_ZN7S3323C32v8Ev");}
void  S3323C3 ::v9(){vfunc_called(this, "_ZN7S3323C32v9Ev");}
void  S3323C3 ::v10(){vfunc_called(this, "_ZN7S3323C33v10Ev");}
void  S3323C3 ::v11(){vfunc_called(this, "_ZN7S3323C33v11Ev");}
void  S3323C3 ::v12(){vfunc_called(this, "_ZN7S3323C33v12Ev");}
void  S3323C3 ::v13(){vfunc_called(this, "_ZN7S3323C33v13Ev");}
void  S3323C3 ::v14(){vfunc_called(this, "_ZN7S3323C33v14Ev");}
S3323C3 ::S3323C3(){ note_ctor("S3323C3", this);} // tgen

static void Test_S3323C3()
{
  extern Class_Descriptor cd_S3323C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S3323C3, buf);
    S3323C3 *dp, &lv = *(dp=new (buf) S3323C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S3323C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3323C3)");
    check_field_offset(lv, s3323c3f0, ABISELECT(8,4), "S3323C3.s3323c3f0");
    check_field_offset(lv, s3323c3f1, ABISELECT(24,12), "S3323C3.s3323c3f1");
    check_field_offset(lv, s3323c3f2, ABISELECT(48,28), "S3323C3.s3323c3f2");
    test_class_info(&lv, &cd_S3323C3);
    dp->~S3323C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3323C3(Test_S3323C3, "S3323C3", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S3323C3C1Ev();
extern void _ZN7S3323C3D1Ev();
Name_Map name_map_S3323C3[] = {
  NSPAIR(_ZN7S3323C3C1Ev),
  NSPAIR(_ZN7S3323C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3323C3[];
extern void _ZN7S3323C3D1Ev();
extern void _ZN7S3323C3D0Ev();
extern void _ZN7S3323C32v5Ev();
extern void _ZN7S3323C32v6Ev();
extern void _ZN7S3323C32v7Ev();
extern void _ZN7S3323C32v8Ev();
extern void _ZN7S3323C32v9Ev();
extern void _ZN7S3323C33v10Ev();
extern void _ZN7S3323C33v11Ev();
extern void _ZN7S3323C33v12Ev();
extern void _ZN7S3323C33v13Ev();
extern void _ZN7S3323C33v14Ev();
static  VTBL_ENTRY vtc_S3323C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3323C3[0]),
  (VTBL_ENTRY)&_ZN7S3323C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3323C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v14Ev,
};
extern VTBL_ENTRY _ZTI7S3323C3[];
extern  VTBL_ENTRY _ZTV7S3323C3[];
Class_Descriptor cd_S3323C3 = {  "S3323C3", // class name
  0,0,//no base classes
  &(vtc_S3323C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S3323C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3323C3),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3323C2  : S3323C3 {
  ::S10103C86 s3323c2f0;
  ::S10103C106 s3323c2f1;
  ::S10103C82_nt s3323c2f2;
  ::S10103C13_nt s3323c2f3;
  virtual  ~S3323C2(); // _ZN7S3323C2D1Ev
  virtual void  v15(); // _ZN7S3323C23v15Ev
  virtual void  v16(); // _ZN7S3323C23v16Ev
  virtual void  v17(); // _ZN7S3323C23v17Ev
  virtual void  v18(); // _ZN7S3323C23v18Ev
  virtual void  v19(); // _ZN7S3323C23v19Ev
  virtual void  v20(); // _ZN7S3323C23v20Ev
  virtual void  v21(); // _ZN7S3323C23v21Ev
  virtual void  v22(); // _ZN7S3323C23v22Ev
  virtual void  v23(); // _ZN7S3323C23v23Ev
  virtual void  v24(); // _ZN7S3323C23v24Ev
  virtual void  v25(); // _ZN7S3323C23v25Ev
  virtual void  v26(); // _ZN7S3323C23v26Ev
  virtual void  v27(); // _ZN7S3323C23v27Ev
  virtual void  v28(); // _ZN7S3323C23v28Ev
  S3323C2(); // tgen
};
//SIG(-1 S3323C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S3323C2 ::~S3323C2(){ note_dtor("S3323C2", this);}
void  S3323C2 ::v15(){vfunc_called(this, "_ZN7S3323C23v15Ev");}
void  S3323C2 ::v16(){vfunc_called(this, "_ZN7S3323C23v16Ev");}
void  S3323C2 ::v17(){vfunc_called(this, "_ZN7S3323C23v17Ev");}
void  S3323C2 ::v18(){vfunc_called(this, "_ZN7S3323C23v18Ev");}
void  S3323C2 ::v19(){vfunc_called(this, "_ZN7S3323C23v19Ev");}
void  S3323C2 ::v20(){vfunc_called(this, "_ZN7S3323C23v20Ev");}
void  S3323C2 ::v21(){vfunc_called(this, "_ZN7S3323C23v21Ev");}
void  S3323C2 ::v22(){vfunc_called(this, "_ZN7S3323C23v22Ev");}
void  S3323C2 ::v23(){vfunc_called(this, "_ZN7S3323C23v23Ev");}
void  S3323C2 ::v24(){vfunc_called(this, "_ZN7S3323C23v24Ev");}
void  S3323C2 ::v25(){vfunc_called(this, "_ZN7S3323C23v25Ev");}
void  S3323C2 ::v26(){vfunc_called(this, "_ZN7S3323C23v26Ev");}
void  S3323C2 ::v27(){vfunc_called(this, "_ZN7S3323C23v27Ev");}
void  S3323C2 ::v28(){vfunc_called(this, "_ZN7S3323C23v28Ev");}
S3323C2 ::S3323C2(){ note_ctor("S3323C2", this);} // tgen

static void Test_S3323C2()
{
  extern Class_Descriptor cd_S3323C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S3323C2, buf);
    S3323C2 *dp, &lv = *(dp=new (buf) S3323C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S3323C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3323C2)");
    check_base_class_offset(lv, (S3323C3*), 0, "S3323C2");
    check_field_offset(lv, s3323c2f0, ABISELECT(56,32), "S3323C2.s3323c2f0");
    check_field_offset(lv, s3323c2f1, ABISELECT(72,44), "S3323C2.s3323c2f1");
    check_field_offset(lv, s3323c2f2, ABISELECT(96,60), "S3323C2.s3323c2f2");
    check_field_offset(lv, s3323c2f3, ABISELECT(112,76), "S3323C2.s3323c2f3");
    test_class_info(&lv, &cd_S3323C2);
    dp->~S3323C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3323C2(Test_S3323C2, "S3323C2", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S3323C2C1Ev();
extern void _ZN7S3323C2D1Ev();
Name_Map name_map_S3323C2[] = {
  NSPAIR(_ZN7S3323C2C1Ev),
  NSPAIR(_ZN7S3323C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3323C3;
extern VTBL_ENTRY _ZTI7S3323C3[];
extern  VTBL_ENTRY _ZTV7S3323C3[];
static Base_Class bases_S3323C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3323C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3323C2[];
extern void _ZN7S3323C2D1Ev();
extern void _ZN7S3323C2D0Ev();
extern void _ZN7S3323C32v5Ev();
extern void _ZN7S3323C32v6Ev();
extern void _ZN7S3323C32v7Ev();
extern void _ZN7S3323C32v8Ev();
extern void _ZN7S3323C32v9Ev();
extern void _ZN7S3323C33v10Ev();
extern void _ZN7S3323C33v11Ev();
extern void _ZN7S3323C33v12Ev();
extern void _ZN7S3323C33v13Ev();
extern void _ZN7S3323C33v14Ev();
extern void _ZN7S3323C23v15Ev();
extern void _ZN7S3323C23v16Ev();
extern void _ZN7S3323C23v17Ev();
extern void _ZN7S3323C23v18Ev();
extern void _ZN7S3323C23v19Ev();
extern void _ZN7S3323C23v20Ev();
extern void _ZN7S3323C23v21Ev();
extern void _ZN7S3323C23v22Ev();
extern void _ZN7S3323C23v23Ev();
extern void _ZN7S3323C23v24Ev();
extern void _ZN7S3323C23v25Ev();
extern void _ZN7S3323C23v26Ev();
extern void _ZN7S3323C23v27Ev();
extern void _ZN7S3323C23v28Ev();
static  VTBL_ENTRY vtc_S3323C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3323C2[0]),
  (VTBL_ENTRY)&_ZN7S3323C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3323C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v28Ev,
};
extern VTBL_ENTRY _ZTI7S3323C2[];
extern  VTBL_ENTRY _ZTV7S3323C2[];
Class_Descriptor cd_S3323C2 = {  "S3323C2", // class name
  bases_S3323C2, 1,
  &(vtc_S3323C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S3323C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3323C2),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3323C1  : S3323C2 {
  ::S10103C84 s3323c1f0;
  ::S679C23 s3323c1f1;
  ::S10103C84 s3323c1f2;
  ::S10103C84 s3323c1f3;
  virtual  ~S3323C1(); // _ZN7S3323C1D1Ev
  virtual void  v1(); // _ZN7S3323C12v1Ev
  virtual void  v2(); // _ZN7S3323C12v2Ev
  virtual void  v3(); // _ZN7S3323C12v3Ev
  virtual void  v4(); // _ZN7S3323C12v4Ev
  S3323C1(); // tgen
};
//SIG(1 S3323C1) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 v2 v3 v4 FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]} FC16{ BC17{ BC18{ vd v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 Fp[2] FC4 Fp} vd v63 v64 v65 v66 v67 v68 Fp Fi FC19{ m Fp Fi FC20{ m} FC20} FC11 Fi} vd v49 v50 v51 v52 FC21{ m FC12} FC21 Fi[6] FC22{ m FC23{ m FL}} FC22 Fc[7] Fi[2] FC11 FC11 FC11 FC11 FC11 Fc[7]} FC13 FC13}


 S3323C1 ::~S3323C1(){ note_dtor("S3323C1", this);}
void  S3323C1 ::v1(){vfunc_called(this, "_ZN7S3323C12v1Ev");}
void  S3323C1 ::v2(){vfunc_called(this, "_ZN7S3323C12v2Ev");}
void  S3323C1 ::v3(){vfunc_called(this, "_ZN7S3323C12v3Ev");}
void  S3323C1 ::v4(){vfunc_called(this, "_ZN7S3323C12v4Ev");}
S3323C1 ::S3323C1(){ note_ctor("S3323C1", this);} // tgen

static void Test_S3323C1()
{
  extern Class_Descriptor cd_S3323C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(165,254)];
    init_test(&cd_S3323C1, buf);
    S3323C1 *dp, &lv = *(dp=new (buf) S3323C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1312,1012), "sizeof(S3323C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3323C1)");
    check_base_class_offset(lv, (S3323C3*)(S3323C2*), 0, "S3323C1");
    check_base_class_offset(lv, (S3323C2*), 0, "S3323C1");
    check_field_offset(lv, s3323c1f0, ABISELECT(136,92), "S3323C1.s3323c1f0");
    check_field_offset(lv, s3323c1f1, ABISELECT(432,316), "S3323C1.s3323c1f1");
    check_field_offset(lv, s3323c1f2, ABISELECT(720,564), "S3323C1.s3323c1f2");
    check_field_offset(lv, s3323c1f3, ABISELECT(1016,788), "S3323C1.s3323c1f3");
    test_class_info(&lv, &cd_S3323C1);
    dp->~S3323C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3323C1(Test_S3323C1, "S3323C1", ABISELECT(1312,1012));

#else // __cplusplus

extern void _ZN7S3323C1C1Ev();
extern void _ZN7S3323C1D1Ev();
Name_Map name_map_S3323C1[] = {
  NSPAIR(_ZN7S3323C1C1Ev),
  NSPAIR(_ZN7S3323C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3323C3;
extern VTBL_ENTRY _ZTI7S3323C3[];
extern  VTBL_ENTRY _ZTV7S3323C3[];
extern Class_Descriptor cd_S3323C2;
extern VTBL_ENTRY _ZTI7S3323C2[];
extern  VTBL_ENTRY _ZTV7S3323C2[];
static Base_Class bases_S3323C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3323C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3323C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3323C1[];
extern void _ZN7S3323C1D1Ev();
extern void _ZN7S3323C1D0Ev();
extern void _ZN7S3323C32v5Ev();
extern void _ZN7S3323C32v6Ev();
extern void _ZN7S3323C32v7Ev();
extern void _ZN7S3323C32v8Ev();
extern void _ZN7S3323C32v9Ev();
extern void _ZN7S3323C33v10Ev();
extern void _ZN7S3323C33v11Ev();
extern void _ZN7S3323C33v12Ev();
extern void _ZN7S3323C33v13Ev();
extern void _ZN7S3323C33v14Ev();
extern void _ZN7S3323C23v15Ev();
extern void _ZN7S3323C23v16Ev();
extern void _ZN7S3323C23v17Ev();
extern void _ZN7S3323C23v18Ev();
extern void _ZN7S3323C23v19Ev();
extern void _ZN7S3323C23v20Ev();
extern void _ZN7S3323C23v21Ev();
extern void _ZN7S3323C23v22Ev();
extern void _ZN7S3323C23v23Ev();
extern void _ZN7S3323C23v24Ev();
extern void _ZN7S3323C23v25Ev();
extern void _ZN7S3323C23v26Ev();
extern void _ZN7S3323C23v27Ev();
extern void _ZN7S3323C23v28Ev();
extern void _ZN7S3323C12v1Ev();
extern void _ZN7S3323C12v2Ev();
extern void _ZN7S3323C12v3Ev();
extern void _ZN7S3323C12v4Ev();
static  VTBL_ENTRY vtc_S3323C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3323C1[0]),
  (VTBL_ENTRY)&_ZN7S3323C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3323C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3323C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3323C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3323C23v28Ev,
  (VTBL_ENTRY)&_ZN7S3323C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3323C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3323C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3323C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S3323C1[];
extern  VTBL_ENTRY _ZTV7S3323C1[];
Class_Descriptor cd_S3323C1 = {  "S3323C1", // class name
  bases_S3323C1, 2,
  &(vtc_S3323C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1312,1012), // object size
  NSPAIRA(_ZTI7S3323C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3323C1),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1390C4  {
  void *s1390c4f0[2];
  ::S10103C13_nt s1390c4f1;
  void *s1390c4f2;
  virtual  ~S1390C4(); // _ZN7S1390C4D1Ev
  virtual void  v3(); // _ZN7S1390C42v3Ev
  virtual void  v4(); // _ZN7S1390C42v4Ev
  virtual void  v5(); // _ZN7S1390C42v5Ev
  virtual void  v6(); // _ZN7S1390C42v6Ev
  virtual void  v7(); // _ZN7S1390C42v7Ev
  virtual void  v8(); // _ZN7S1390C42v8Ev
  virtual void  v9(); // _ZN7S1390C42v9Ev
  virtual void  v10(); // _ZN7S1390C43v10Ev
  virtual void  v11(); // _ZN7S1390C43v11Ev
  virtual void  v12(); // _ZN7S1390C43v12Ev
  S1390C4(); // tgen
};
//SIG(-1 S1390C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1390C4 ::~S1390C4(){ note_dtor("S1390C4", this);}
void  S1390C4 ::v3(){vfunc_called(this, "_ZN7S1390C42v3Ev");}
void  S1390C4 ::v4(){vfunc_called(this, "_ZN7S1390C42v4Ev");}
void  S1390C4 ::v5(){vfunc_called(this, "_ZN7S1390C42v5Ev");}
void  S1390C4 ::v6(){vfunc_called(this, "_ZN7S1390C42v6Ev");}
void  S1390C4 ::v7(){vfunc_called(this, "_ZN7S1390C42v7Ev");}
void  S1390C4 ::v8(){vfunc_called(this, "_ZN7S1390C42v8Ev");}
void  S1390C4 ::v9(){vfunc_called(this, "_ZN7S1390C42v9Ev");}
void  S1390C4 ::v10(){vfunc_called(this, "_ZN7S1390C43v10Ev");}
void  S1390C4 ::v11(){vfunc_called(this, "_ZN7S1390C43v11Ev");}
void  S1390C4 ::v12(){vfunc_called(this, "_ZN7S1390C43v12Ev");}
S1390C4 ::S1390C4(){ note_ctor("S1390C4", this);} // tgen

static void Test_S1390C4()
{
  extern Class_Descriptor cd_S1390C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1390C4, buf);
    S1390C4 *dp, &lv = *(dp=new (buf) S1390C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1390C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1390C4)");
    check_field_offset(lv, s1390c4f0, ABISELECT(8,4), "S1390C4.s1390c4f0");
    check_field_offset(lv, s1390c4f1, ABISELECT(24,12), "S1390C4.s1390c4f1");
    check_field_offset(lv, s1390c4f2, ABISELECT(48,28), "S1390C4.s1390c4f2");
    test_class_info(&lv, &cd_S1390C4);
    dp->~S1390C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1390C4(Test_S1390C4, "S1390C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1390C4C1Ev();
extern void _ZN7S1390C4D1Ev();
Name_Map name_map_S1390C4[] = {
  NSPAIR(_ZN7S1390C4C1Ev),
  NSPAIR(_ZN7S1390C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1390C4[];
extern void _ZN7S1390C4D1Ev();
extern void _ZN7S1390C4D0Ev();
extern void _ZN7S1390C42v3Ev();
extern void _ZN7S1390C42v4Ev();
extern void _ZN7S1390C42v5Ev();
extern void _ZN7S1390C42v6Ev();
extern void _ZN7S1390C42v7Ev();
extern void _ZN7S1390C42v8Ev();
extern void _ZN7S1390C42v9Ev();
extern void _ZN7S1390C43v10Ev();
extern void _ZN7S1390C43v11Ev();
extern void _ZN7S1390C43v12Ev();
static  VTBL_ENTRY vtc_S1390C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1390C4[0]),
  (VTBL_ENTRY)&_ZN7S1390C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1390C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S1390C4[];
extern  VTBL_ENTRY _ZTV7S1390C4[];
Class_Descriptor cd_S1390C4 = {  "S1390C4", // class name
  0,0,//no base classes
  &(vtc_S1390C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1390C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1390C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1390C3  : S1390C4 {
  ::S10103C86 s1390c3f0;
  ::S10103C106 s1390c3f1;
  ::S10103C82_nt s1390c3f2;
  ::S10103C13_nt s1390c3f3;
  virtual  ~S1390C3(); // _ZN7S1390C3D1Ev
  virtual void  v13(); // _ZN7S1390C33v13Ev
  virtual void  v14(); // _ZN7S1390C33v14Ev
  virtual void  v15(); // _ZN7S1390C33v15Ev
  virtual void  v16(); // _ZN7S1390C33v16Ev
  virtual void  v17(); // _ZN7S1390C33v17Ev
  virtual void  v18(); // _ZN7S1390C33v18Ev
  virtual void  v19(); // _ZN7S1390C33v19Ev
  virtual void  v20(); // _ZN7S1390C33v20Ev
  virtual void  v21(); // _ZN7S1390C33v21Ev
  virtual void  v22(); // _ZN7S1390C33v22Ev
  virtual void  v23(); // _ZN7S1390C33v23Ev
  virtual void  v24(); // _ZN7S1390C33v24Ev
  virtual void  v25(); // _ZN7S1390C33v25Ev
  virtual void  v26(); // _ZN7S1390C33v26Ev
  S1390C3(); // tgen
};
//SIG(-1 S1390C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1390C3 ::~S1390C3(){ note_dtor("S1390C3", this);}
void  S1390C3 ::v13(){vfunc_called(this, "_ZN7S1390C33v13Ev");}
void  S1390C3 ::v14(){vfunc_called(this, "_ZN7S1390C33v14Ev");}
void  S1390C3 ::v15(){vfunc_called(this, "_ZN7S1390C33v15Ev");}
void  S1390C3 ::v16(){vfunc_called(this, "_ZN7S1390C33v16Ev");}
void  S1390C3 ::v17(){vfunc_called(this, "_ZN7S1390C33v17Ev");}
void  S1390C3 ::v18(){vfunc_called(this, "_ZN7S1390C33v18Ev");}
void  S1390C3 ::v19(){vfunc_called(this, "_ZN7S1390C33v19Ev");}
void  S1390C3 ::v20(){vfunc_called(this, "_ZN7S1390C33v20Ev");}
void  S1390C3 ::v21(){vfunc_called(this, "_ZN7S1390C33v21Ev");}
void  S1390C3 ::v22(){vfunc_called(this, "_ZN7S1390C33v22Ev");}
void  S1390C3 ::v23(){vfunc_called(this, "_ZN7S1390C33v23Ev");}
void  S1390C3 ::v24(){vfunc_called(this, "_ZN7S1390C33v24Ev");}
void  S1390C3 ::v25(){vfunc_called(this, "_ZN7S1390C33v25Ev");}
void  S1390C3 ::v26(){vfunc_called(this, "_ZN7S1390C33v26Ev");}
S1390C3 ::S1390C3(){ note_ctor("S1390C3", this);} // tgen

static void Test_S1390C3()
{
  extern Class_Descriptor cd_S1390C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1390C3, buf);
    S1390C3 *dp, &lv = *(dp=new (buf) S1390C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1390C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1390C3)");
    check_base_class_offset(lv, (S1390C4*), 0, "S1390C3");
    check_field_offset(lv, s1390c3f0, ABISELECT(56,32), "S1390C3.s1390c3f0");
    check_field_offset(lv, s1390c3f1, ABISELECT(72,44), "S1390C3.s1390c3f1");
    check_field_offset(lv, s1390c3f2, ABISELECT(96,60), "S1390C3.s1390c3f2");
    check_field_offset(lv, s1390c3f3, ABISELECT(112,76), "S1390C3.s1390c3f3");
    test_class_info(&lv, &cd_S1390C3);
    dp->~S1390C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1390C3(Test_S1390C3, "S1390C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1390C3C1Ev();
extern void _ZN7S1390C3D1Ev();
Name_Map name_map_S1390C3[] = {
  NSPAIR(_ZN7S1390C3C1Ev),
  NSPAIR(_ZN7S1390C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1390C4;
extern VTBL_ENTRY _ZTI7S1390C4[];
extern  VTBL_ENTRY _ZTV7S1390C4[];
static Base_Class bases_S1390C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1390C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1390C3[];
extern void _ZN7S1390C3D1Ev();
extern void _ZN7S1390C3D0Ev();
extern void _ZN7S1390C42v3Ev();
extern void _ZN7S1390C42v4Ev();
extern void _ZN7S1390C42v5Ev();
extern void _ZN7S1390C42v6Ev();
extern void _ZN7S1390C42v7Ev();
extern void _ZN7S1390C42v8Ev();
extern void _ZN7S1390C42v9Ev();
extern void _ZN7S1390C43v10Ev();
extern void _ZN7S1390C43v11Ev();
extern void _ZN7S1390C43v12Ev();
extern void _ZN7S1390C33v13Ev();
extern void _ZN7S1390C33v14Ev();
extern void _ZN7S1390C33v15Ev();
extern void _ZN7S1390C33v16Ev();
extern void _ZN7S1390C33v17Ev();
extern void _ZN7S1390C33v18Ev();
extern void _ZN7S1390C33v19Ev();
extern void _ZN7S1390C33v20Ev();
extern void _ZN7S1390C33v21Ev();
extern void _ZN7S1390C33v22Ev();
extern void _ZN7S1390C33v23Ev();
extern void _ZN7S1390C33v24Ev();
extern void _ZN7S1390C33v25Ev();
extern void _ZN7S1390C33v26Ev();
static  VTBL_ENTRY vtc_S1390C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1390C3[0]),
  (VTBL_ENTRY)&_ZN7S1390C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1390C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v26Ev,
};
extern VTBL_ENTRY _ZTI7S1390C3[];
extern  VTBL_ENTRY _ZTV7S1390C3[];
Class_Descriptor cd_S1390C3 = {  "S1390C3", // class name
  bases_S1390C3, 1,
  &(vtc_S1390C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1390C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1390C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1390C2  : S1390C3 {
  int s1390c2f0[3];
  ::S10103C30_nt s1390c2f1;
  ::S10103C30_nt s1390c2f2;
  ::S10103C84 s1390c2f3[4];
  ::S10103C84 s1390c2f4;
  ::S10103C84 s1390c2f5[2];
  virtual  ~S1390C2(); // _ZN7S1390C2D1Ev
  virtual void  v27(); // _ZN7S1390C23v27Ev
  virtual void  v28(); // _ZN7S1390C23v28Ev
  virtual void  v29(); // _ZN7S1390C23v29Ev
  virtual void  v30(); // _ZN7S1390C23v30Ev
  S1390C2(); // tgen
};
//SIG(-1 S1390C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 v2 v3 v4 Fi[3] FC13{ m FC14{ m FL}} FC13 FC15{ BC16{ BC17{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]}[4] FC15 FC15[2]}


 S1390C2 ::~S1390C2(){ note_dtor("S1390C2", this);}
void  S1390C2 ::v27(){vfunc_called(this, "_ZN7S1390C23v27Ev");}
void  S1390C2 ::v28(){vfunc_called(this, "_ZN7S1390C23v28Ev");}
void  S1390C2 ::v29(){vfunc_called(this, "_ZN7S1390C23v29Ev");}
void  S1390C2 ::v30(){vfunc_called(this, "_ZN7S1390C23v30Ev");}
S1390C2 ::S1390C2(){ note_ctor("S1390C2", this);} // tgen

static void Test_S1390C2()
{
  extern Class_Descriptor cd_S1390C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(281,423)];
    init_test(&cd_S1390C2, buf);
    S1390C2 *dp, &lv = *(dp=new (buf) S1390C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2240,1688), "sizeof(S1390C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1390C2)");
    check_base_class_offset(lv, (S1390C4*)(S1390C3*), 0, "S1390C2");
    check_base_class_offset(lv, (S1390C3*), 0, "S1390C2");
    check_field_offset(lv, s1390c2f0, ABISELECT(136,92), "S1390C2.s1390c2f0");
    check_field_offset(lv, s1390c2f1, ABISELECT(152,104), "S1390C2.s1390c2f1");
    check_field_offset(lv, s1390c2f2, ABISELECT(160,112), "S1390C2.s1390c2f2");
    check_field_offset(lv, s1390c2f3, ABISELECT(168,120), "S1390C2.s1390c2f3");
    check_field_offset(lv, s1390c2f4, ABISELECT(1352,1016), "S1390C2.s1390c2f4");
    check_field_offset(lv, s1390c2f5, ABISELECT(1648,1240), "S1390C2.s1390c2f5");
    test_class_info(&lv, &cd_S1390C2);
    dp->~S1390C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1390C2(Test_S1390C2, "S1390C2", ABISELECT(2240,1688));

#else // __cplusplus

extern void _ZN7S1390C2C1Ev();
extern void _ZN7S1390C2D1Ev();
Name_Map name_map_S1390C2[] = {
  NSPAIR(_ZN7S1390C2C1Ev),
  NSPAIR(_ZN7S1390C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1390C4;
extern VTBL_ENTRY _ZTI7S1390C4[];
extern  VTBL_ENTRY _ZTV7S1390C4[];
extern Class_Descriptor cd_S1390C3;
extern VTBL_ENTRY _ZTI7S1390C3[];
extern  VTBL_ENTRY _ZTV7S1390C3[];
static Base_Class bases_S1390C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1390C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1390C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1390C2[];
extern void _ZN7S1390C2D1Ev();
extern void _ZN7S1390C2D0Ev();
extern void _ZN7S1390C42v3Ev();
extern void _ZN7S1390C42v4Ev();
extern void _ZN7S1390C42v5Ev();
extern void _ZN7S1390C42v6Ev();
extern void _ZN7S1390C42v7Ev();
extern void _ZN7S1390C42v8Ev();
extern void _ZN7S1390C42v9Ev();
extern void _ZN7S1390C43v10Ev();
extern void _ZN7S1390C43v11Ev();
extern void _ZN7S1390C43v12Ev();
extern void _ZN7S1390C33v13Ev();
extern void _ZN7S1390C33v14Ev();
extern void _ZN7S1390C33v15Ev();
extern void _ZN7S1390C33v16Ev();
extern void _ZN7S1390C33v17Ev();
extern void _ZN7S1390C33v18Ev();
extern void _ZN7S1390C33v19Ev();
extern void _ZN7S1390C33v20Ev();
extern void _ZN7S1390C33v21Ev();
extern void _ZN7S1390C33v22Ev();
extern void _ZN7S1390C33v23Ev();
extern void _ZN7S1390C33v24Ev();
extern void _ZN7S1390C33v25Ev();
extern void _ZN7S1390C33v26Ev();
extern void _ZN7S1390C23v27Ev();
extern void _ZN7S1390C23v28Ev();
extern void _ZN7S1390C23v29Ev();
extern void _ZN7S1390C23v30Ev();
static  VTBL_ENTRY vtc_S1390C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1390C2[0]),
  (VTBL_ENTRY)&_ZN7S1390C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1390C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v30Ev,
};
extern VTBL_ENTRY _ZTI7S1390C2[];
extern  VTBL_ENTRY _ZTV7S1390C2[];
Class_Descriptor cd_S1390C2 = {  "S1390C2", // class name
  bases_S1390C2, 2,
  &(vtc_S1390C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2240,1688), // object size
  NSPAIRA(_ZTI7S1390C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1390C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1390C1  : S1390C2 {
  ::S10103C84 s1390c1f0[2];
  virtual  ~S1390C1(); // _ZN7S1390C1D1Ev
  virtual void  v1(); // _ZN7S1390C12v1Ev
  virtual void  v2(); // _ZN7S1390C12v2Ev
  S1390C1(); // tgen
};
//SIG(1 S1390C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} vd v27 v28 v29 v30 Fi[3] FC14{ m FC15{ m FL}} FC14 FC16{ BC17{ BC18{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp[2] FC5 Fp} vd v45 v46 v47 v48 v49 v50 Fp Fi FC8 FC12 Fi} vd v31 v32 v33 v34 FC5[4] FC12 FC12 FC12 FC12 Fi[6]}[4] FC16 FC16[2]} vd v1 v2 FC16[2]}


 S1390C1 ::~S1390C1(){ note_dtor("S1390C1", this);}
void  S1390C1 ::v1(){vfunc_called(this, "_ZN7S1390C12v1Ev");}
void  S1390C1 ::v2(){vfunc_called(this, "_ZN7S1390C12v2Ev");}
S1390C1 ::S1390C1(){ note_ctor("S1390C1", this);} // tgen

static void Test_S1390C1()
{
  extern Class_Descriptor cd_S1390C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(355,535)];
    init_test(&cd_S1390C1, buf);
    S1390C1 *dp, &lv = *(dp=new (buf) S1390C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2832,2136), "sizeof(S1390C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1390C1)");
    check_base_class_offset(lv, (S1390C4*)(S1390C3*)(S1390C2*), 0, "S1390C1");
    check_base_class_offset(lv, (S1390C3*)(S1390C2*), 0, "S1390C1");
    check_base_class_offset(lv, (S1390C2*), 0, "S1390C1");
    check_field_offset(lv, s1390c1f0, ABISELECT(2240,1688), "S1390C1.s1390c1f0");
    test_class_info(&lv, &cd_S1390C1);
    dp->~S1390C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1390C1(Test_S1390C1, "S1390C1", ABISELECT(2832,2136));

#else // __cplusplus

extern void _ZN7S1390C1C1Ev();
extern void _ZN7S1390C1D1Ev();
Name_Map name_map_S1390C1[] = {
  NSPAIR(_ZN7S1390C1C1Ev),
  NSPAIR(_ZN7S1390C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1390C4;
extern VTBL_ENTRY _ZTI7S1390C4[];
extern  VTBL_ENTRY _ZTV7S1390C4[];
extern Class_Descriptor cd_S1390C3;
extern VTBL_ENTRY _ZTI7S1390C3[];
extern  VTBL_ENTRY _ZTV7S1390C3[];
extern Class_Descriptor cd_S1390C2;
extern VTBL_ENTRY _ZTI7S1390C2[];
extern  VTBL_ENTRY _ZTV7S1390C2[];
static Base_Class bases_S1390C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1390C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1390C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1390C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1390C1[];
extern void _ZN7S1390C1D1Ev();
extern void _ZN7S1390C1D0Ev();
extern void _ZN7S1390C42v3Ev();
extern void _ZN7S1390C42v4Ev();
extern void _ZN7S1390C42v5Ev();
extern void _ZN7S1390C42v6Ev();
extern void _ZN7S1390C42v7Ev();
extern void _ZN7S1390C42v8Ev();
extern void _ZN7S1390C42v9Ev();
extern void _ZN7S1390C43v10Ev();
extern void _ZN7S1390C43v11Ev();
extern void _ZN7S1390C43v12Ev();
extern void _ZN7S1390C33v13Ev();
extern void _ZN7S1390C33v14Ev();
extern void _ZN7S1390C33v15Ev();
extern void _ZN7S1390C33v16Ev();
extern void _ZN7S1390C33v17Ev();
extern void _ZN7S1390C33v18Ev();
extern void _ZN7S1390C33v19Ev();
extern void _ZN7S1390C33v20Ev();
extern void _ZN7S1390C33v21Ev();
extern void _ZN7S1390C33v22Ev();
extern void _ZN7S1390C33v23Ev();
extern void _ZN7S1390C33v24Ev();
extern void _ZN7S1390C33v25Ev();
extern void _ZN7S1390C33v26Ev();
extern void _ZN7S1390C23v27Ev();
extern void _ZN7S1390C23v28Ev();
extern void _ZN7S1390C23v29Ev();
extern void _ZN7S1390C23v30Ev();
extern void _ZN7S1390C12v1Ev();
extern void _ZN7S1390C12v2Ev();
static  VTBL_ENTRY vtc_S1390C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1390C1[0]),
  (VTBL_ENTRY)&_ZN7S1390C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1390C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1390C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1390C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1390C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1390C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1390C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1390C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S1390C1[];
extern  VTBL_ENTRY _ZTV7S1390C1[];
Class_Descriptor cd_S1390C1 = {  "S1390C1", // class name
  bases_S1390C1, 3,
  &(vtc_S1390C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2832,2136), // object size
  NSPAIRA(_ZTI7S1390C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1390C1),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1486C4  {
  void *s1486c4f0[2];
  ::S10103C13_nt s1486c4f1;
  void *s1486c4f2;
  virtual  ~S1486C4(); // _ZN7S1486C4D1Ev
  virtual void  v5(); // _ZN7S1486C42v5Ev
  virtual void  v6(); // _ZN7S1486C42v6Ev
  virtual void  v7(); // _ZN7S1486C42v7Ev
  virtual void  v8(); // _ZN7S1486C42v8Ev
  virtual void  v9(); // _ZN7S1486C42v9Ev
  virtual void  v10(); // _ZN7S1486C43v10Ev
  virtual void  v11(); // _ZN7S1486C43v11Ev
  virtual void  v12(); // _ZN7S1486C43v12Ev
  virtual void  v13(); // _ZN7S1486C43v13Ev
  virtual void  v14(); // _ZN7S1486C43v14Ev
  S1486C4(); // tgen
};
//SIG(-1 S1486C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1486C4 ::~S1486C4(){ note_dtor("S1486C4", this);}
void  S1486C4 ::v5(){vfunc_called(this, "_ZN7S1486C42v5Ev");}
void  S1486C4 ::v6(){vfunc_called(this, "_ZN7S1486C42v6Ev");}
void  S1486C4 ::v7(){vfunc_called(this, "_ZN7S1486C42v7Ev");}
void  S1486C4 ::v8(){vfunc_called(this, "_ZN7S1486C42v8Ev");}
void  S1486C4 ::v9(){vfunc_called(this, "_ZN7S1486C42v9Ev");}
void  S1486C4 ::v10(){vfunc_called(this, "_ZN7S1486C43v10Ev");}
void  S1486C4 ::v11(){vfunc_called(this, "_ZN7S1486C43v11Ev");}
void  S1486C4 ::v12(){vfunc_called(this, "_ZN7S1486C43v12Ev");}
void  S1486C4 ::v13(){vfunc_called(this, "_ZN7S1486C43v13Ev");}
void  S1486C4 ::v14(){vfunc_called(this, "_ZN7S1486C43v14Ev");}
S1486C4 ::S1486C4(){ note_ctor("S1486C4", this);} // tgen

static void Test_S1486C4()
{
  extern Class_Descriptor cd_S1486C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1486C4, buf);
    S1486C4 *dp, &lv = *(dp=new (buf) S1486C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1486C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1486C4)");
    check_field_offset(lv, s1486c4f0, ABISELECT(8,4), "S1486C4.s1486c4f0");
    check_field_offset(lv, s1486c4f1, ABISELECT(24,12), "S1486C4.s1486c4f1");
    check_field_offset(lv, s1486c4f2, ABISELECT(48,28), "S1486C4.s1486c4f2");
    test_class_info(&lv, &cd_S1486C4);
    dp->~S1486C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1486C4(Test_S1486C4, "S1486C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1486C4C1Ev();
extern void _ZN7S1486C4D1Ev();
Name_Map name_map_S1486C4[] = {
  NSPAIR(_ZN7S1486C4C1Ev),
  NSPAIR(_ZN7S1486C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1486C4[];
extern void _ZN7S1486C4D1Ev();
extern void _ZN7S1486C4D0Ev();
extern void _ZN7S1486C42v5Ev();
extern void _ZN7S1486C42v6Ev();
extern void _ZN7S1486C42v7Ev();
extern void _ZN7S1486C42v8Ev();
extern void _ZN7S1486C42v9Ev();
extern void _ZN7S1486C43v10Ev();
extern void _ZN7S1486C43v11Ev();
extern void _ZN7S1486C43v12Ev();
extern void _ZN7S1486C43v13Ev();
extern void _ZN7S1486C43v14Ev();
static  VTBL_ENTRY vtc_S1486C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1486C4[0]),
  (VTBL_ENTRY)&_ZN7S1486C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1486C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S1486C4[];
extern  VTBL_ENTRY _ZTV7S1486C4[];
Class_Descriptor cd_S1486C4 = {  "S1486C4", // class name
  0,0,//no base classes
  &(vtc_S1486C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1486C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1486C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1486C3  : S1486C4 {
  ::S10103C86 s1486c3f0;
  ::S10103C106 s1486c3f1;
  ::S10103C82_nt s1486c3f2;
  ::S10103C13_nt s1486c3f3;
  virtual  ~S1486C3(); // _ZN7S1486C3D1Ev
  virtual void  v15(); // _ZN7S1486C33v15Ev
  virtual void  v16(); // _ZN7S1486C33v16Ev
  virtual void  v17(); // _ZN7S1486C33v17Ev
  virtual void  v18(); // _ZN7S1486C33v18Ev
  virtual void  v19(); // _ZN7S1486C33v19Ev
  virtual void  v20(); // _ZN7S1486C33v20Ev
  virtual void  v21(); // _ZN7S1486C33v21Ev
  virtual void  v22(); // _ZN7S1486C33v22Ev
  virtual void  v23(); // _ZN7S1486C33v23Ev
  virtual void  v24(); // _ZN7S1486C33v24Ev
  virtual void  v25(); // _ZN7S1486C33v25Ev
  virtual void  v26(); // _ZN7S1486C33v26Ev
  virtual void  v27(); // _ZN7S1486C33v27Ev
  virtual void  v28(); // _ZN7S1486C33v28Ev
  S1486C3(); // tgen
};
//SIG(-1 S1486C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1486C3 ::~S1486C3(){ note_dtor("S1486C3", this);}
void  S1486C3 ::v15(){vfunc_called(this, "_ZN7S1486C33v15Ev");}
void  S1486C3 ::v16(){vfunc_called(this, "_ZN7S1486C33v16Ev");}
void  S1486C3 ::v17(){vfunc_called(this, "_ZN7S1486C33v17Ev");}
void  S1486C3 ::v18(){vfunc_called(this, "_ZN7S1486C33v18Ev");}
void  S1486C3 ::v19(){vfunc_called(this, "_ZN7S1486C33v19Ev");}
void  S1486C3 ::v20(){vfunc_called(this, "_ZN7S1486C33v20Ev");}
void  S1486C3 ::v21(){vfunc_called(this, "_ZN7S1486C33v21Ev");}
void  S1486C3 ::v22(){vfunc_called(this, "_ZN7S1486C33v22Ev");}
void  S1486C3 ::v23(){vfunc_called(this, "_ZN7S1486C33v23Ev");}
void  S1486C3 ::v24(){vfunc_called(this, "_ZN7S1486C33v24Ev");}
void  S1486C3 ::v25(){vfunc_called(this, "_ZN7S1486C33v25Ev");}
void  S1486C3 ::v26(){vfunc_called(this, "_ZN7S1486C33v26Ev");}
void  S1486C3 ::v27(){vfunc_called(this, "_ZN7S1486C33v27Ev");}
void  S1486C3 ::v28(){vfunc_called(this, "_ZN7S1486C33v28Ev");}
S1486C3 ::S1486C3(){ note_ctor("S1486C3", this);} // tgen

static void Test_S1486C3()
{
  extern Class_Descriptor cd_S1486C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1486C3, buf);
    S1486C3 *dp, &lv = *(dp=new (buf) S1486C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1486C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1486C3)");
    check_base_class_offset(lv, (S1486C4*), 0, "S1486C3");
    check_field_offset(lv, s1486c3f0, ABISELECT(56,32), "S1486C3.s1486c3f0");
    check_field_offset(lv, s1486c3f1, ABISELECT(72,44), "S1486C3.s1486c3f1");
    check_field_offset(lv, s1486c3f2, ABISELECT(96,60), "S1486C3.s1486c3f2");
    check_field_offset(lv, s1486c3f3, ABISELECT(112,76), "S1486C3.s1486c3f3");
    test_class_info(&lv, &cd_S1486C3);
    dp->~S1486C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1486C3(Test_S1486C3, "S1486C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1486C3C1Ev();
extern void _ZN7S1486C3D1Ev();
Name_Map name_map_S1486C3[] = {
  NSPAIR(_ZN7S1486C3C1Ev),
  NSPAIR(_ZN7S1486C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1486C4;
extern VTBL_ENTRY _ZTI7S1486C4[];
extern  VTBL_ENTRY _ZTV7S1486C4[];
static Base_Class bases_S1486C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1486C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1486C3[];
extern void _ZN7S1486C3D1Ev();
extern void _ZN7S1486C3D0Ev();
extern void _ZN7S1486C42v5Ev();
extern void _ZN7S1486C42v6Ev();
extern void _ZN7S1486C42v7Ev();
extern void _ZN7S1486C42v8Ev();
extern void _ZN7S1486C42v9Ev();
extern void _ZN7S1486C43v10Ev();
extern void _ZN7S1486C43v11Ev();
extern void _ZN7S1486C43v12Ev();
extern void _ZN7S1486C43v13Ev();
extern void _ZN7S1486C43v14Ev();
extern void _ZN7S1486C33v15Ev();
extern void _ZN7S1486C33v16Ev();
extern void _ZN7S1486C33v17Ev();
extern void _ZN7S1486C33v18Ev();
extern void _ZN7S1486C33v19Ev();
extern void _ZN7S1486C33v20Ev();
extern void _ZN7S1486C33v21Ev();
extern void _ZN7S1486C33v22Ev();
extern void _ZN7S1486C33v23Ev();
extern void _ZN7S1486C33v24Ev();
extern void _ZN7S1486C33v25Ev();
extern void _ZN7S1486C33v26Ev();
extern void _ZN7S1486C33v27Ev();
extern void _ZN7S1486C33v28Ev();
static  VTBL_ENTRY vtc_S1486C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1486C3[0]),
  (VTBL_ENTRY)&_ZN7S1486C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1486C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v28Ev,
};
extern VTBL_ENTRY _ZTI7S1486C3[];
extern  VTBL_ENTRY _ZTV7S1486C3[];
Class_Descriptor cd_S1486C3 = {  "S1486C3", // class name
  bases_S1486C3, 1,
  &(vtc_S1486C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1486C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1486C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1486C2  : S1486C3 {
  ::S10103C84 s1486c2f0;
  ::S10103C82_nt s1486c2f1;
  ::S10103C82_nt s1486c2f2;
  virtual void  v29(); // _ZN7S1486C23v29Ev
  virtual void  v30(); // _ZN7S1486C23v30Ev
  virtual void  v31(); // _ZN7S1486C23v31Ev
  virtual void  v32(); // _ZN7S1486C23v32Ev
  ~S1486C2(); // tgen
  S1486C2(); // tgen
};
//SIG(-1 S1486C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]} FC11 FC11}


void  S1486C2 ::v29(){vfunc_called(this, "_ZN7S1486C23v29Ev");}
void  S1486C2 ::v30(){vfunc_called(this, "_ZN7S1486C23v30Ev");}
void  S1486C2 ::v31(){vfunc_called(this, "_ZN7S1486C23v31Ev");}
void  S1486C2 ::v32(){vfunc_called(this, "_ZN7S1486C23v32Ev");}
S1486C2 ::~S1486C2(){ note_dtor("S1486C2", this);} // tgen
S1486C2 ::S1486C2(){ note_ctor("S1486C2", this);} // tgen

static void Test_S1486C2()
{
  extern Class_Descriptor cd_S1486C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,88)];
    init_test(&cd_S1486C2, buf);
    S1486C2 *dp, &lv = *(dp=new (buf) S1486C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,348), "sizeof(S1486C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1486C2)");
    check_base_class_offset(lv, (S1486C4*)(S1486C3*), 0, "S1486C2");
    check_base_class_offset(lv, (S1486C3*), 0, "S1486C2");
    check_field_offset(lv, s1486c2f0, ABISELECT(136,92), "S1486C2.s1486c2f0");
    check_field_offset(lv, s1486c2f1, ABISELECT(432,316), "S1486C2.s1486c2f1");
    check_field_offset(lv, s1486c2f2, ABISELECT(448,332), "S1486C2.s1486c2f2");
    test_class_info(&lv, &cd_S1486C2);
    dp->~S1486C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1486C2(Test_S1486C2, "S1486C2", ABISELECT(464,348));

#else // __cplusplus

extern void _ZN7S1486C2C1Ev();
extern void _ZN7S1486C2D1Ev();
Name_Map name_map_S1486C2[] = {
  NSPAIR(_ZN7S1486C2C1Ev),
  NSPAIR(_ZN7S1486C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1486C4;
extern VTBL_ENTRY _ZTI7S1486C4[];
extern  VTBL_ENTRY _ZTV7S1486C4[];
extern Class_Descriptor cd_S1486C3;
extern VTBL_ENTRY _ZTI7S1486C3[];
extern  VTBL_ENTRY _ZTV7S1486C3[];
static Base_Class bases_S1486C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1486C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1486C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1486C2[];
extern void _ZN7S1486C2D1Ev();
extern void _ZN7S1486C2D0Ev();
extern void _ZN7S1486C42v5Ev();
extern void _ZN7S1486C42v6Ev();
extern void _ZN7S1486C42v7Ev();
extern void _ZN7S1486C42v8Ev();
extern void _ZN7S1486C42v9Ev();
extern void _ZN7S1486C43v10Ev();
extern void _ZN7S1486C43v11Ev();
extern void _ZN7S1486C43v12Ev();
extern void _ZN7S1486C43v13Ev();
extern void _ZN7S1486C43v14Ev();
extern void _ZN7S1486C33v15Ev();
extern void _ZN7S1486C33v16Ev();
extern void _ZN7S1486C33v17Ev();
extern void _ZN7S1486C33v18Ev();
extern void _ZN7S1486C33v19Ev();
extern void _ZN7S1486C33v20Ev();
extern void _ZN7S1486C33v21Ev();
extern void _ZN7S1486C33v22Ev();
extern void _ZN7S1486C33v23Ev();
extern void _ZN7S1486C33v24Ev();
extern void _ZN7S1486C33v25Ev();
extern void _ZN7S1486C33v26Ev();
extern void _ZN7S1486C33v27Ev();
extern void _ZN7S1486C33v28Ev();
extern void _ZN7S1486C23v29Ev();
extern void _ZN7S1486C23v30Ev();
extern void _ZN7S1486C23v31Ev();
extern void _ZN7S1486C23v32Ev();
static  VTBL_ENTRY vtc_S1486C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1486C2[0]),
  (VTBL_ENTRY)&_ZN7S1486C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1486C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v32Ev,
};
extern VTBL_ENTRY _ZTI7S1486C2[];
extern  VTBL_ENTRY _ZTV7S1486C2[];
Class_Descriptor cd_S1486C2 = {  "S1486C2", // class name
  bases_S1486C2, 2,
  &(vtc_S1486C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,348), // object size
  NSPAIRA(_ZTI7S1486C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1486C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1486C1  : S1486C2 {
  ::S10103C30_nt s1486c1f0;
  ::S10103C30_nt s1486c1f1;
  ::S10103C82_nt s1486c1f2;
  int s1486c1f3;
  virtual void  v1(); // _ZN7S1486C12v1Ev
  virtual void  v2(); // _ZN7S1486C12v2Ev
  virtual void  v3(); // _ZN7S1486C12v3Ev
  virtual void  v4(); // _ZN7S1486C12v4Ev
  ~S1486C1(); // tgen
  S1486C1(); // tgen
};
//SIG(1 S1486C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 FC14{ BC15{ BC16{ vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fp[2] FC5 Fp} vd v47 v48 v49 v50 v51 v52 Fp Fi FC8 FC12 Fi} vd v33 v34 v35 v36 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC12 FC12} v1 v2 v3 v4 FC17{ m FC18{ m FL}} FC17 FC12 Fi}


void  S1486C1 ::v1(){vfunc_called(this, "_ZN7S1486C12v1Ev");}
void  S1486C1 ::v2(){vfunc_called(this, "_ZN7S1486C12v2Ev");}
void  S1486C1 ::v3(){vfunc_called(this, "_ZN7S1486C12v3Ev");}
void  S1486C1 ::v4(){vfunc_called(this, "_ZN7S1486C12v4Ev");}
S1486C1 ::~S1486C1(){ note_dtor("S1486C1", this);} // tgen
S1486C1 ::S1486C1(){ note_ctor("S1486C1", this);} // tgen

static void Test_S1486C1()
{
  extern Class_Descriptor cd_S1486C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(64,97)];
    init_test(&cd_S1486C1, buf);
    S1486C1 *dp, &lv = *(dp=new (buf) S1486C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(504,384), "sizeof(S1486C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1486C1)");
    check_base_class_offset(lv, (S1486C4*)(S1486C3*)(S1486C2*), 0, "S1486C1");
    check_base_class_offset(lv, (S1486C3*)(S1486C2*), 0, "S1486C1");
    check_base_class_offset(lv, (S1486C2*), 0, "S1486C1");
    check_field_offset(lv, s1486c1f0, ABISELECT(464,348), "S1486C1.s1486c1f0");
    check_field_offset(lv, s1486c1f1, ABISELECT(472,356), "S1486C1.s1486c1f1");
    check_field_offset(lv, s1486c1f2, ABISELECT(480,364), "S1486C1.s1486c1f2");
    check_field_offset(lv, s1486c1f3, ABISELECT(496,380), "S1486C1.s1486c1f3");
    test_class_info(&lv, &cd_S1486C1);
    dp->~S1486C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1486C1(Test_S1486C1, "S1486C1", ABISELECT(504,384));

#else // __cplusplus

extern void _ZN7S1486C1C1Ev();
extern void _ZN7S1486C1D1Ev();
Name_Map name_map_S1486C1[] = {
  NSPAIR(_ZN7S1486C1C1Ev),
  NSPAIR(_ZN7S1486C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1486C4;
extern VTBL_ENTRY _ZTI7S1486C4[];
extern  VTBL_ENTRY _ZTV7S1486C4[];
extern Class_Descriptor cd_S1486C3;
extern VTBL_ENTRY _ZTI7S1486C3[];
extern  VTBL_ENTRY _ZTV7S1486C3[];
extern Class_Descriptor cd_S1486C2;
extern VTBL_ENTRY _ZTI7S1486C2[];
extern  VTBL_ENTRY _ZTV7S1486C2[];
static Base_Class bases_S1486C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1486C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1486C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1486C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1486C1[];
extern void _ZN7S1486C1D1Ev();
extern void _ZN7S1486C1D0Ev();
extern void _ZN7S1486C42v5Ev();
extern void _ZN7S1486C42v6Ev();
extern void _ZN7S1486C42v7Ev();
extern void _ZN7S1486C42v8Ev();
extern void _ZN7S1486C42v9Ev();
extern void _ZN7S1486C43v10Ev();
extern void _ZN7S1486C43v11Ev();
extern void _ZN7S1486C43v12Ev();
extern void _ZN7S1486C43v13Ev();
extern void _ZN7S1486C43v14Ev();
extern void _ZN7S1486C33v15Ev();
extern void _ZN7S1486C33v16Ev();
extern void _ZN7S1486C33v17Ev();
extern void _ZN7S1486C33v18Ev();
extern void _ZN7S1486C33v19Ev();
extern void _ZN7S1486C33v20Ev();
extern void _ZN7S1486C33v21Ev();
extern void _ZN7S1486C33v22Ev();
extern void _ZN7S1486C33v23Ev();
extern void _ZN7S1486C33v24Ev();
extern void _ZN7S1486C33v25Ev();
extern void _ZN7S1486C33v26Ev();
extern void _ZN7S1486C33v27Ev();
extern void _ZN7S1486C33v28Ev();
extern void _ZN7S1486C23v29Ev();
extern void _ZN7S1486C23v30Ev();
extern void _ZN7S1486C23v31Ev();
extern void _ZN7S1486C23v32Ev();
extern void _ZN7S1486C12v1Ev();
extern void _ZN7S1486C12v2Ev();
extern void _ZN7S1486C12v3Ev();
extern void _ZN7S1486C12v4Ev();
static  VTBL_ENTRY vtc_S1486C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1486C1[0]),
  (VTBL_ENTRY)&_ZN7S1486C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1486C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1486C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1486C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1486C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1486C23v32Ev,
  (VTBL_ENTRY)&_ZN7S1486C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1486C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1486C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1486C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S1486C1[];
extern  VTBL_ENTRY _ZTV7S1486C1[];
Class_Descriptor cd_S1486C1 = {  "S1486C1", // class name
  bases_S1486C1, 3,
  &(vtc_S1486C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(504,384), // object size
  NSPAIRA(_ZTI7S1486C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1486C1),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1487C4  {
  void *s1487c4f0[2];
  ::S10103C13_nt s1487c4f1;
  void *s1487c4f2;
  virtual  ~S1487C4(); // _ZN7S1487C4D1Ev
  virtual void  v5(); // _ZN7S1487C42v5Ev
  virtual void  v6(); // _ZN7S1487C42v6Ev
  virtual void  v7(); // _ZN7S1487C42v7Ev
  virtual void  v8(); // _ZN7S1487C42v8Ev
  virtual void  v9(); // _ZN7S1487C42v9Ev
  virtual void  v10(); // _ZN7S1487C43v10Ev
  virtual void  v11(); // _ZN7S1487C43v11Ev
  virtual void  v12(); // _ZN7S1487C43v12Ev
  virtual void  v13(); // _ZN7S1487C43v13Ev
  virtual void  v14(); // _ZN7S1487C43v14Ev
  S1487C4(); // tgen
};
//SIG(-1 S1487C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1487C4 ::~S1487C4(){ note_dtor("S1487C4", this);}
void  S1487C4 ::v5(){vfunc_called(this, "_ZN7S1487C42v5Ev");}
void  S1487C4 ::v6(){vfunc_called(this, "_ZN7S1487C42v6Ev");}
void  S1487C4 ::v7(){vfunc_called(this, "_ZN7S1487C42v7Ev");}
void  S1487C4 ::v8(){vfunc_called(this, "_ZN7S1487C42v8Ev");}
void  S1487C4 ::v9(){vfunc_called(this, "_ZN7S1487C42v9Ev");}
void  S1487C4 ::v10(){vfunc_called(this, "_ZN7S1487C43v10Ev");}
void  S1487C4 ::v11(){vfunc_called(this, "_ZN7S1487C43v11Ev");}
void  S1487C4 ::v12(){vfunc_called(this, "_ZN7S1487C43v12Ev");}
void  S1487C4 ::v13(){vfunc_called(this, "_ZN7S1487C43v13Ev");}
void  S1487C4 ::v14(){vfunc_called(this, "_ZN7S1487C43v14Ev");}
S1487C4 ::S1487C4(){ note_ctor("S1487C4", this);} // tgen

static void Test_S1487C4()
{
  extern Class_Descriptor cd_S1487C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1487C4, buf);
    S1487C4 *dp, &lv = *(dp=new (buf) S1487C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1487C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1487C4)");
    check_field_offset(lv, s1487c4f0, ABISELECT(8,4), "S1487C4.s1487c4f0");
    check_field_offset(lv, s1487c4f1, ABISELECT(24,12), "S1487C4.s1487c4f1");
    check_field_offset(lv, s1487c4f2, ABISELECT(48,28), "S1487C4.s1487c4f2");
    test_class_info(&lv, &cd_S1487C4);
    dp->~S1487C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1487C4(Test_S1487C4, "S1487C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1487C4C1Ev();
extern void _ZN7S1487C4D1Ev();
Name_Map name_map_S1487C4[] = {
  NSPAIR(_ZN7S1487C4C1Ev),
  NSPAIR(_ZN7S1487C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1487C4[];
extern void _ZN7S1487C4D1Ev();
extern void _ZN7S1487C4D0Ev();
extern void _ZN7S1487C42v5Ev();
extern void _ZN7S1487C42v6Ev();
extern void _ZN7S1487C42v7Ev();
extern void _ZN7S1487C42v8Ev();
extern void _ZN7S1487C42v9Ev();
extern void _ZN7S1487C43v10Ev();
extern void _ZN7S1487C43v11Ev();
extern void _ZN7S1487C43v12Ev();
extern void _ZN7S1487C43v13Ev();
extern void _ZN7S1487C43v14Ev();
static  VTBL_ENTRY vtc_S1487C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1487C4[0]),
  (VTBL_ENTRY)&_ZN7S1487C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1487C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S1487C4[];
extern  VTBL_ENTRY _ZTV7S1487C4[];
Class_Descriptor cd_S1487C4 = {  "S1487C4", // class name
  0,0,//no base classes
  &(vtc_S1487C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1487C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1487C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1487C3  : S1487C4 {
  ::S10103C86 s1487c3f0;
  ::S10103C106 s1487c3f1;
  ::S10103C82_nt s1487c3f2;
  ::S10103C13_nt s1487c3f3;
  virtual  ~S1487C3(); // _ZN7S1487C3D1Ev
  virtual void  v15(); // _ZN7S1487C33v15Ev
  virtual void  v16(); // _ZN7S1487C33v16Ev
  virtual void  v17(); // _ZN7S1487C33v17Ev
  virtual void  v18(); // _ZN7S1487C33v18Ev
  virtual void  v19(); // _ZN7S1487C33v19Ev
  virtual void  v20(); // _ZN7S1487C33v20Ev
  virtual void  v21(); // _ZN7S1487C33v21Ev
  virtual void  v22(); // _ZN7S1487C33v22Ev
  virtual void  v23(); // _ZN7S1487C33v23Ev
  virtual void  v24(); // _ZN7S1487C33v24Ev
  virtual void  v25(); // _ZN7S1487C33v25Ev
  virtual void  v26(); // _ZN7S1487C33v26Ev
  virtual void  v27(); // _ZN7S1487C33v27Ev
  virtual void  v28(); // _ZN7S1487C33v28Ev
  S1487C3(); // tgen
};
//SIG(-1 S1487C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1487C3 ::~S1487C3(){ note_dtor("S1487C3", this);}
void  S1487C3 ::v15(){vfunc_called(this, "_ZN7S1487C33v15Ev");}
void  S1487C3 ::v16(){vfunc_called(this, "_ZN7S1487C33v16Ev");}
void  S1487C3 ::v17(){vfunc_called(this, "_ZN7S1487C33v17Ev");}
void  S1487C3 ::v18(){vfunc_called(this, "_ZN7S1487C33v18Ev");}
void  S1487C3 ::v19(){vfunc_called(this, "_ZN7S1487C33v19Ev");}
void  S1487C3 ::v20(){vfunc_called(this, "_ZN7S1487C33v20Ev");}
void  S1487C3 ::v21(){vfunc_called(this, "_ZN7S1487C33v21Ev");}
void  S1487C3 ::v22(){vfunc_called(this, "_ZN7S1487C33v22Ev");}
void  S1487C3 ::v23(){vfunc_called(this, "_ZN7S1487C33v23Ev");}
void  S1487C3 ::v24(){vfunc_called(this, "_ZN7S1487C33v24Ev");}
void  S1487C3 ::v25(){vfunc_called(this, "_ZN7S1487C33v25Ev");}
void  S1487C3 ::v26(){vfunc_called(this, "_ZN7S1487C33v26Ev");}
void  S1487C3 ::v27(){vfunc_called(this, "_ZN7S1487C33v27Ev");}
void  S1487C3 ::v28(){vfunc_called(this, "_ZN7S1487C33v28Ev");}
S1487C3 ::S1487C3(){ note_ctor("S1487C3", this);} // tgen

static void Test_S1487C3()
{
  extern Class_Descriptor cd_S1487C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1487C3, buf);
    S1487C3 *dp, &lv = *(dp=new (buf) S1487C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1487C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1487C3)");
    check_base_class_offset(lv, (S1487C4*), 0, "S1487C3");
    check_field_offset(lv, s1487c3f0, ABISELECT(56,32), "S1487C3.s1487c3f0");
    check_field_offset(lv, s1487c3f1, ABISELECT(72,44), "S1487C3.s1487c3f1");
    check_field_offset(lv, s1487c3f2, ABISELECT(96,60), "S1487C3.s1487c3f2");
    check_field_offset(lv, s1487c3f3, ABISELECT(112,76), "S1487C3.s1487c3f3");
    test_class_info(&lv, &cd_S1487C3);
    dp->~S1487C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1487C3(Test_S1487C3, "S1487C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1487C3C1Ev();
extern void _ZN7S1487C3D1Ev();
Name_Map name_map_S1487C3[] = {
  NSPAIR(_ZN7S1487C3C1Ev),
  NSPAIR(_ZN7S1487C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1487C4;
extern VTBL_ENTRY _ZTI7S1487C4[];
extern  VTBL_ENTRY _ZTV7S1487C4[];
static Base_Class bases_S1487C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1487C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1487C3[];
extern void _ZN7S1487C3D1Ev();
extern void _ZN7S1487C3D0Ev();
extern void _ZN7S1487C42v5Ev();
extern void _ZN7S1487C42v6Ev();
extern void _ZN7S1487C42v7Ev();
extern void _ZN7S1487C42v8Ev();
extern void _ZN7S1487C42v9Ev();
extern void _ZN7S1487C43v10Ev();
extern void _ZN7S1487C43v11Ev();
extern void _ZN7S1487C43v12Ev();
extern void _ZN7S1487C43v13Ev();
extern void _ZN7S1487C43v14Ev();
extern void _ZN7S1487C33v15Ev();
extern void _ZN7S1487C33v16Ev();
extern void _ZN7S1487C33v17Ev();
extern void _ZN7S1487C33v18Ev();
extern void _ZN7S1487C33v19Ev();
extern void _ZN7S1487C33v20Ev();
extern void _ZN7S1487C33v21Ev();
extern void _ZN7S1487C33v22Ev();
extern void _ZN7S1487C33v23Ev();
extern void _ZN7S1487C33v24Ev();
extern void _ZN7S1487C33v25Ev();
extern void _ZN7S1487C33v26Ev();
extern void _ZN7S1487C33v27Ev();
extern void _ZN7S1487C33v28Ev();
static  VTBL_ENTRY vtc_S1487C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1487C3[0]),
  (VTBL_ENTRY)&_ZN7S1487C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1487C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v28Ev,
};
extern VTBL_ENTRY _ZTI7S1487C3[];
extern  VTBL_ENTRY _ZTV7S1487C3[];
Class_Descriptor cd_S1487C3 = {  "S1487C3", // class name
  bases_S1487C3, 1,
  &(vtc_S1487C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1487C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1487C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1487C2  : S1487C3 {
  int s1487c2f0;
  char s1487c2f1[2];
  int s1487c2f2;
  virtual void  v29(); // _ZN7S1487C23v29Ev
  virtual void  v30(); // _ZN7S1487C23v30Ev
  virtual void  v31(); // _ZN7S1487C23v31Ev
  virtual void  v32(); // _ZN7S1487C23v32Ev
  ~S1487C2(); // tgen
  S1487C2(); // tgen
};
//SIG(-1 S1487C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 Fi Fc[2] Fi}


void  S1487C2 ::v29(){vfunc_called(this, "_ZN7S1487C23v29Ev");}
void  S1487C2 ::v30(){vfunc_called(this, "_ZN7S1487C23v30Ev");}
void  S1487C2 ::v31(){vfunc_called(this, "_ZN7S1487C23v31Ev");}
void  S1487C2 ::v32(){vfunc_called(this, "_ZN7S1487C23v32Ev");}
S1487C2 ::~S1487C2(){ note_dtor("S1487C2", this);} // tgen
S1487C2 ::S1487C2(){ note_ctor("S1487C2", this);} // tgen

static void Test_S1487C2()
{
  extern Class_Descriptor cd_S1487C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S1487C2, buf);
    S1487C2 *dp, &lv = *(dp=new (buf) S1487C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S1487C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1487C2)");
    check_base_class_offset(lv, (S1487C4*)(S1487C3*), 0, "S1487C2");
    check_base_class_offset(lv, (S1487C3*), 0, "S1487C2");
    check_field_offset(lv, s1487c2f0, ABISELECT(136,92), "S1487C2.s1487c2f0");
    check_field_offset(lv, s1487c2f1, ABISELECT(140,96), "S1487C2.s1487c2f1");
    check_field_offset(lv, s1487c2f2, ABISELECT(144,100), "S1487C2.s1487c2f2");
    test_class_info(&lv, &cd_S1487C2);
    dp->~S1487C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1487C2(Test_S1487C2, "S1487C2", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN7S1487C2C1Ev();
extern void _ZN7S1487C2D1Ev();
Name_Map name_map_S1487C2[] = {
  NSPAIR(_ZN7S1487C2C1Ev),
  NSPAIR(_ZN7S1487C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1487C4;
extern VTBL_ENTRY _ZTI7S1487C4[];
extern  VTBL_ENTRY _ZTV7S1487C4[];
extern Class_Descriptor cd_S1487C3;
extern VTBL_ENTRY _ZTI7S1487C3[];
extern  VTBL_ENTRY _ZTV7S1487C3[];
static Base_Class bases_S1487C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1487C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1487C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1487C2[];
extern void _ZN7S1487C2D1Ev();
extern void _ZN7S1487C2D0Ev();
extern void _ZN7S1487C42v5Ev();
extern void _ZN7S1487C42v6Ev();
extern void _ZN7S1487C42v7Ev();
extern void _ZN7S1487C42v8Ev();
extern void _ZN7S1487C42v9Ev();
extern void _ZN7S1487C43v10Ev();
extern void _ZN7S1487C43v11Ev();
extern void _ZN7S1487C43v12Ev();
extern void _ZN7S1487C43v13Ev();
extern void _ZN7S1487C43v14Ev();
extern void _ZN7S1487C33v15Ev();
extern void _ZN7S1487C33v16Ev();
extern void _ZN7S1487C33v17Ev();
extern void _ZN7S1487C33v18Ev();
extern void _ZN7S1487C33v19Ev();
extern void _ZN7S1487C33v20Ev();
extern void _ZN7S1487C33v21Ev();
extern void _ZN7S1487C33v22Ev();
extern void _ZN7S1487C33v23Ev();
extern void _ZN7S1487C33v24Ev();
extern void _ZN7S1487C33v25Ev();
extern void _ZN7S1487C33v26Ev();
extern void _ZN7S1487C33v27Ev();
extern void _ZN7S1487C33v28Ev();
extern void _ZN7S1487C23v29Ev();
extern void _ZN7S1487C23v30Ev();
extern void _ZN7S1487C23v31Ev();
extern void _ZN7S1487C23v32Ev();
static  VTBL_ENTRY vtc_S1487C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1487C2[0]),
  (VTBL_ENTRY)&_ZN7S1487C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1487C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v32Ev,
};
extern VTBL_ENTRY _ZTI7S1487C2[];
extern  VTBL_ENTRY _ZTV7S1487C2[];
Class_Descriptor cd_S1487C2 = {  "S1487C2", // class name
  bases_S1487C2, 2,
  &(vtc_S1487C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI7S1487C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1487C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1487C1  : S1487C2 {
  ::S10103C84 s1487c1f0;
  ::S10103C84 s1487c1f1;
  int s1487c1f2;
  void *s1487c1f3;
  int s1487c1f4[2];
  virtual  ~S1487C1(); // _ZN7S1487C1D1Ev
  virtual void  v1(); // _ZN7S1487C12v1Ev
  virtual void  v2(); // _ZN7S1487C12v2Ev
  virtual void  v3(); // _ZN7S1487C12v3Ev
  virtual void  v4(); // _ZN7S1487C12v4Ev
  S1487C1(); // tgen
};
//SIG(1 S1487C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 Fi Fc[2] Fi} vd v1 v2 v3 v4 FC14{ BC15{ BC16{ vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fp[2] FC5 Fp} vd v47 v48 v49 v50 v51 v52 Fp Fi FC8 FC12 Fi} vd v33 v34 v35 v36 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC14 Fi Fp Fi[2]}


 S1487C1 ::~S1487C1(){ note_dtor("S1487C1", this);}
void  S1487C1 ::v1(){vfunc_called(this, "_ZN7S1487C12v1Ev");}
void  S1487C1 ::v2(){vfunc_called(this, "_ZN7S1487C12v2Ev");}
void  S1487C1 ::v3(){vfunc_called(this, "_ZN7S1487C12v3Ev");}
void  S1487C1 ::v4(){vfunc_called(this, "_ZN7S1487C12v4Ev");}
S1487C1 ::S1487C1(){ note_ctor("S1487C1", this);} // tgen

static void Test_S1487C1()
{
  extern Class_Descriptor cd_S1487C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(97,143)];
    init_test(&cd_S1487C1, buf);
    S1487C1 *dp, &lv = *(dp=new (buf) S1487C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(768,568), "sizeof(S1487C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1487C1)");
    check_base_class_offset(lv, (S1487C4*)(S1487C3*)(S1487C2*), 0, "S1487C1");
    check_base_class_offset(lv, (S1487C3*)(S1487C2*), 0, "S1487C1");
    check_base_class_offset(lv, (S1487C2*), 0, "S1487C1");
    check_field_offset(lv, s1487c1f0, ABISELECT(152,104), "S1487C1.s1487c1f0");
    check_field_offset(lv, s1487c1f1, ABISELECT(448,328), "S1487C1.s1487c1f1");
    check_field_offset(lv, s1487c1f2, ABISELECT(744,552), "S1487C1.s1487c1f2");
    check_field_offset(lv, s1487c1f3, ABISELECT(752,556), "S1487C1.s1487c1f3");
    check_field_offset(lv, s1487c1f4, ABISELECT(760,560), "S1487C1.s1487c1f4");
    test_class_info(&lv, &cd_S1487C1);
    dp->~S1487C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1487C1(Test_S1487C1, "S1487C1", ABISELECT(768,568));

#else // __cplusplus

extern void _ZN7S1487C1C1Ev();
extern void _ZN7S1487C1D1Ev();
Name_Map name_map_S1487C1[] = {
  NSPAIR(_ZN7S1487C1C1Ev),
  NSPAIR(_ZN7S1487C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1487C4;
extern VTBL_ENTRY _ZTI7S1487C4[];
extern  VTBL_ENTRY _ZTV7S1487C4[];
extern Class_Descriptor cd_S1487C3;
extern VTBL_ENTRY _ZTI7S1487C3[];
extern  VTBL_ENTRY _ZTV7S1487C3[];
extern Class_Descriptor cd_S1487C2;
extern VTBL_ENTRY _ZTI7S1487C2[];
extern  VTBL_ENTRY _ZTV7S1487C2[];
static Base_Class bases_S1487C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1487C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1487C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1487C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1487C1[];
extern void _ZN7S1487C1D1Ev();
extern void _ZN7S1487C1D0Ev();
extern void _ZN7S1487C42v5Ev();
extern void _ZN7S1487C42v6Ev();
extern void _ZN7S1487C42v7Ev();
extern void _ZN7S1487C42v8Ev();
extern void _ZN7S1487C42v9Ev();
extern void _ZN7S1487C43v10Ev();
extern void _ZN7S1487C43v11Ev();
extern void _ZN7S1487C43v12Ev();
extern void _ZN7S1487C43v13Ev();
extern void _ZN7S1487C43v14Ev();
extern void _ZN7S1487C33v15Ev();
extern void _ZN7S1487C33v16Ev();
extern void _ZN7S1487C33v17Ev();
extern void _ZN7S1487C33v18Ev();
extern void _ZN7S1487C33v19Ev();
extern void _ZN7S1487C33v20Ev();
extern void _ZN7S1487C33v21Ev();
extern void _ZN7S1487C33v22Ev();
extern void _ZN7S1487C33v23Ev();
extern void _ZN7S1487C33v24Ev();
extern void _ZN7S1487C33v25Ev();
extern void _ZN7S1487C33v26Ev();
extern void _ZN7S1487C33v27Ev();
extern void _ZN7S1487C33v28Ev();
extern void _ZN7S1487C23v29Ev();
extern void _ZN7S1487C23v30Ev();
extern void _ZN7S1487C23v31Ev();
extern void _ZN7S1487C23v32Ev();
extern void _ZN7S1487C12v1Ev();
extern void _ZN7S1487C12v2Ev();
extern void _ZN7S1487C12v3Ev();
extern void _ZN7S1487C12v4Ev();
static  VTBL_ENTRY vtc_S1487C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1487C1[0]),
  (VTBL_ENTRY)&_ZN7S1487C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1487C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1487C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1487C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1487C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1487C23v32Ev,
  (VTBL_ENTRY)&_ZN7S1487C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1487C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1487C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1487C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S1487C1[];
extern  VTBL_ENTRY _ZTV7S1487C1[];
Class_Descriptor cd_S1487C1 = {  "S1487C1", // class name
  bases_S1487C1, 3,
  &(vtc_S1487C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(768,568), // object size
  NSPAIRA(_ZTI7S1487C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1487C1),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1389C4  {
  void *s1389c4f0[2];
  ::S10103C13_nt s1389c4f1;
  void *s1389c4f2;
  virtual  ~S1389C4(); // _ZN7S1389C4D1Ev
  virtual void  v3(); // _ZN7S1389C42v3Ev
  virtual void  v4(); // _ZN7S1389C42v4Ev
  virtual void  v5(); // _ZN7S1389C42v5Ev
  virtual void  v6(); // _ZN7S1389C42v6Ev
  virtual void  v7(); // _ZN7S1389C42v7Ev
  virtual void  v8(); // _ZN7S1389C42v8Ev
  virtual void  v9(); // _ZN7S1389C42v9Ev
  virtual void  v10(); // _ZN7S1389C43v10Ev
  virtual void  v11(); // _ZN7S1389C43v11Ev
  virtual void  v12(); // _ZN7S1389C43v12Ev
  S1389C4(); // tgen
};
//SIG(-1 S1389C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1389C4 ::~S1389C4(){ note_dtor("S1389C4", this);}
void  S1389C4 ::v3(){vfunc_called(this, "_ZN7S1389C42v3Ev");}
void  S1389C4 ::v4(){vfunc_called(this, "_ZN7S1389C42v4Ev");}
void  S1389C4 ::v5(){vfunc_called(this, "_ZN7S1389C42v5Ev");}
void  S1389C4 ::v6(){vfunc_called(this, "_ZN7S1389C42v6Ev");}
void  S1389C4 ::v7(){vfunc_called(this, "_ZN7S1389C42v7Ev");}
void  S1389C4 ::v8(){vfunc_called(this, "_ZN7S1389C42v8Ev");}
void  S1389C4 ::v9(){vfunc_called(this, "_ZN7S1389C42v9Ev");}
void  S1389C4 ::v10(){vfunc_called(this, "_ZN7S1389C43v10Ev");}
void  S1389C4 ::v11(){vfunc_called(this, "_ZN7S1389C43v11Ev");}
void  S1389C4 ::v12(){vfunc_called(this, "_ZN7S1389C43v12Ev");}
S1389C4 ::S1389C4(){ note_ctor("S1389C4", this);} // tgen

static void Test_S1389C4()
{
  extern Class_Descriptor cd_S1389C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1389C4, buf);
    S1389C4 *dp, &lv = *(dp=new (buf) S1389C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1389C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1389C4)");
    check_field_offset(lv, s1389c4f0, ABISELECT(8,4), "S1389C4.s1389c4f0");
    check_field_offset(lv, s1389c4f1, ABISELECT(24,12), "S1389C4.s1389c4f1");
    check_field_offset(lv, s1389c4f2, ABISELECT(48,28), "S1389C4.s1389c4f2");
    test_class_info(&lv, &cd_S1389C4);
    dp->~S1389C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1389C4(Test_S1389C4, "S1389C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1389C4C1Ev();
extern void _ZN7S1389C4D1Ev();
Name_Map name_map_S1389C4[] = {
  NSPAIR(_ZN7S1389C4C1Ev),
  NSPAIR(_ZN7S1389C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1389C4[];
extern void _ZN7S1389C4D1Ev();
extern void _ZN7S1389C4D0Ev();
extern void _ZN7S1389C42v3Ev();
extern void _ZN7S1389C42v4Ev();
extern void _ZN7S1389C42v5Ev();
extern void _ZN7S1389C42v6Ev();
extern void _ZN7S1389C42v7Ev();
extern void _ZN7S1389C42v8Ev();
extern void _ZN7S1389C42v9Ev();
extern void _ZN7S1389C43v10Ev();
extern void _ZN7S1389C43v11Ev();
extern void _ZN7S1389C43v12Ev();
static  VTBL_ENTRY vtc_S1389C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1389C4[0]),
  (VTBL_ENTRY)&_ZN7S1389C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1389C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S1389C4[];
extern  VTBL_ENTRY _ZTV7S1389C4[];
Class_Descriptor cd_S1389C4 = {  "S1389C4", // class name
  0,0,//no base classes
  &(vtc_S1389C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1389C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1389C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1389C3  : S1389C4 {
  ::S10103C86 s1389c3f0;
  ::S10103C106 s1389c3f1;
  ::S10103C82_nt s1389c3f2;
  ::S10103C13_nt s1389c3f3;
  virtual  ~S1389C3(); // _ZN7S1389C3D1Ev
  virtual void  v13(); // _ZN7S1389C33v13Ev
  virtual void  v14(); // _ZN7S1389C33v14Ev
  virtual void  v15(); // _ZN7S1389C33v15Ev
  virtual void  v16(); // _ZN7S1389C33v16Ev
  virtual void  v17(); // _ZN7S1389C33v17Ev
  virtual void  v18(); // _ZN7S1389C33v18Ev
  virtual void  v19(); // _ZN7S1389C33v19Ev
  virtual void  v20(); // _ZN7S1389C33v20Ev
  virtual void  v21(); // _ZN7S1389C33v21Ev
  virtual void  v22(); // _ZN7S1389C33v22Ev
  virtual void  v23(); // _ZN7S1389C33v23Ev
  virtual void  v24(); // _ZN7S1389C33v24Ev
  virtual void  v25(); // _ZN7S1389C33v25Ev
  virtual void  v26(); // _ZN7S1389C33v26Ev
  S1389C3(); // tgen
};
//SIG(-1 S1389C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1389C3 ::~S1389C3(){ note_dtor("S1389C3", this);}
void  S1389C3 ::v13(){vfunc_called(this, "_ZN7S1389C33v13Ev");}
void  S1389C3 ::v14(){vfunc_called(this, "_ZN7S1389C33v14Ev");}
void  S1389C3 ::v15(){vfunc_called(this, "_ZN7S1389C33v15Ev");}
void  S1389C3 ::v16(){vfunc_called(this, "_ZN7S1389C33v16Ev");}
void  S1389C3 ::v17(){vfunc_called(this, "_ZN7S1389C33v17Ev");}
void  S1389C3 ::v18(){vfunc_called(this, "_ZN7S1389C33v18Ev");}
void  S1389C3 ::v19(){vfunc_called(this, "_ZN7S1389C33v19Ev");}
void  S1389C3 ::v20(){vfunc_called(this, "_ZN7S1389C33v20Ev");}
void  S1389C3 ::v21(){vfunc_called(this, "_ZN7S1389C33v21Ev");}
void  S1389C3 ::v22(){vfunc_called(this, "_ZN7S1389C33v22Ev");}
void  S1389C3 ::v23(){vfunc_called(this, "_ZN7S1389C33v23Ev");}
void  S1389C3 ::v24(){vfunc_called(this, "_ZN7S1389C33v24Ev");}
void  S1389C3 ::v25(){vfunc_called(this, "_ZN7S1389C33v25Ev");}
void  S1389C3 ::v26(){vfunc_called(this, "_ZN7S1389C33v26Ev");}
S1389C3 ::S1389C3(){ note_ctor("S1389C3", this);} // tgen

static void Test_S1389C3()
{
  extern Class_Descriptor cd_S1389C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1389C3, buf);
    S1389C3 *dp, &lv = *(dp=new (buf) S1389C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1389C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1389C3)");
    check_base_class_offset(lv, (S1389C4*), 0, "S1389C3");
    check_field_offset(lv, s1389c3f0, ABISELECT(56,32), "S1389C3.s1389c3f0");
    check_field_offset(lv, s1389c3f1, ABISELECT(72,44), "S1389C3.s1389c3f1");
    check_field_offset(lv, s1389c3f2, ABISELECT(96,60), "S1389C3.s1389c3f2");
    check_field_offset(lv, s1389c3f3, ABISELECT(112,76), "S1389C3.s1389c3f3");
    test_class_info(&lv, &cd_S1389C3);
    dp->~S1389C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1389C3(Test_S1389C3, "S1389C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1389C3C1Ev();
extern void _ZN7S1389C3D1Ev();
Name_Map name_map_S1389C3[] = {
  NSPAIR(_ZN7S1389C3C1Ev),
  NSPAIR(_ZN7S1389C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1389C4;
extern VTBL_ENTRY _ZTI7S1389C4[];
extern  VTBL_ENTRY _ZTV7S1389C4[];
static Base_Class bases_S1389C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1389C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1389C3[];
extern void _ZN7S1389C3D1Ev();
extern void _ZN7S1389C3D0Ev();
extern void _ZN7S1389C42v3Ev();
extern void _ZN7S1389C42v4Ev();
extern void _ZN7S1389C42v5Ev();
extern void _ZN7S1389C42v6Ev();
extern void _ZN7S1389C42v7Ev();
extern void _ZN7S1389C42v8Ev();
extern void _ZN7S1389C42v9Ev();
extern void _ZN7S1389C43v10Ev();
extern void _ZN7S1389C43v11Ev();
extern void _ZN7S1389C43v12Ev();
extern void _ZN7S1389C33v13Ev();
extern void _ZN7S1389C33v14Ev();
extern void _ZN7S1389C33v15Ev();
extern void _ZN7S1389C33v16Ev();
extern void _ZN7S1389C33v17Ev();
extern void _ZN7S1389C33v18Ev();
extern void _ZN7S1389C33v19Ev();
extern void _ZN7S1389C33v20Ev();
extern void _ZN7S1389C33v21Ev();
extern void _ZN7S1389C33v22Ev();
extern void _ZN7S1389C33v23Ev();
extern void _ZN7S1389C33v24Ev();
extern void _ZN7S1389C33v25Ev();
extern void _ZN7S1389C33v26Ev();
static  VTBL_ENTRY vtc_S1389C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1389C3[0]),
  (VTBL_ENTRY)&_ZN7S1389C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1389C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v26Ev,
};
extern VTBL_ENTRY _ZTI7S1389C3[];
extern  VTBL_ENTRY _ZTV7S1389C3[];
Class_Descriptor cd_S1389C3 = {  "S1389C3", // class name
  bases_S1389C3, 1,
  &(vtc_S1389C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1389C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1389C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1389C2  : S1389C3 {
  int s1389c2f0[3];
  ::S10103C84 s1389c2f1[4];
  virtual  ~S1389C2(); // _ZN7S1389C2D1Ev
  virtual void  v27(); // _ZN7S1389C23v27Ev
  virtual void  v28(); // _ZN7S1389C23v28Ev
  virtual void  v29(); // _ZN7S1389C23v29Ev
  virtual void  v30(); // _ZN7S1389C23v30Ev
  S1389C2(); // tgen
};
//SIG(-1 S1389C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 v2 v3 v4 Fi[3] FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]}[4]}


 S1389C2 ::~S1389C2(){ note_dtor("S1389C2", this);}
void  S1389C2 ::v27(){vfunc_called(this, "_ZN7S1389C23v27Ev");}
void  S1389C2 ::v28(){vfunc_called(this, "_ZN7S1389C23v28Ev");}
void  S1389C2 ::v29(){vfunc_called(this, "_ZN7S1389C23v29Ev");}
void  S1389C2 ::v30(){vfunc_called(this, "_ZN7S1389C23v30Ev");}
S1389C2 ::S1389C2(){ note_ctor("S1389C2", this);} // tgen

static void Test_S1389C2()
{
  extern Class_Descriptor cd_S1389C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(168,251)];
    init_test(&cd_S1389C2, buf);
    S1389C2 *dp, &lv = *(dp=new (buf) S1389C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1336,1000), "sizeof(S1389C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1389C2)");
    check_base_class_offset(lv, (S1389C4*)(S1389C3*), 0, "S1389C2");
    check_base_class_offset(lv, (S1389C3*), 0, "S1389C2");
    check_field_offset(lv, s1389c2f0, ABISELECT(136,92), "S1389C2.s1389c2f0");
    check_field_offset(lv, s1389c2f1, ABISELECT(152,104), "S1389C2.s1389c2f1");
    test_class_info(&lv, &cd_S1389C2);
    dp->~S1389C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1389C2(Test_S1389C2, "S1389C2", ABISELECT(1336,1000));

#else // __cplusplus

extern void _ZN7S1389C2C1Ev();
extern void _ZN7S1389C2D1Ev();
Name_Map name_map_S1389C2[] = {
  NSPAIR(_ZN7S1389C2C1Ev),
  NSPAIR(_ZN7S1389C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1389C4;
extern VTBL_ENTRY _ZTI7S1389C4[];
extern  VTBL_ENTRY _ZTV7S1389C4[];
extern Class_Descriptor cd_S1389C3;
extern VTBL_ENTRY _ZTI7S1389C3[];
extern  VTBL_ENTRY _ZTV7S1389C3[];
static Base_Class bases_S1389C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1389C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1389C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1389C2[];
extern void _ZN7S1389C2D1Ev();
extern void _ZN7S1389C2D0Ev();
extern void _ZN7S1389C42v3Ev();
extern void _ZN7S1389C42v4Ev();
extern void _ZN7S1389C42v5Ev();
extern void _ZN7S1389C42v6Ev();
extern void _ZN7S1389C42v7Ev();
extern void _ZN7S1389C42v8Ev();
extern void _ZN7S1389C42v9Ev();
extern void _ZN7S1389C43v10Ev();
extern void _ZN7S1389C43v11Ev();
extern void _ZN7S1389C43v12Ev();
extern void _ZN7S1389C33v13Ev();
extern void _ZN7S1389C33v14Ev();
extern void _ZN7S1389C33v15Ev();
extern void _ZN7S1389C33v16Ev();
extern void _ZN7S1389C33v17Ev();
extern void _ZN7S1389C33v18Ev();
extern void _ZN7S1389C33v19Ev();
extern void _ZN7S1389C33v20Ev();
extern void _ZN7S1389C33v21Ev();
extern void _ZN7S1389C33v22Ev();
extern void _ZN7S1389C33v23Ev();
extern void _ZN7S1389C33v24Ev();
extern void _ZN7S1389C33v25Ev();
extern void _ZN7S1389C33v26Ev();
extern void _ZN7S1389C23v27Ev();
extern void _ZN7S1389C23v28Ev();
extern void _ZN7S1389C23v29Ev();
extern void _ZN7S1389C23v30Ev();
static  VTBL_ENTRY vtc_S1389C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1389C2[0]),
  (VTBL_ENTRY)&_ZN7S1389C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1389C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v30Ev,
};
extern VTBL_ENTRY _ZTI7S1389C2[];
extern  VTBL_ENTRY _ZTV7S1389C2[];
Class_Descriptor cd_S1389C2 = {  "S1389C2", // class name
  bases_S1389C2, 2,
  &(vtc_S1389C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1336,1000), // object size
  NSPAIRA(_ZTI7S1389C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1389C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1389C1  : S1389C2 {
  ::S10103C84 s1389c1f0;
  virtual  ~S1389C1(); // _ZN7S1389C1D1Ev
  virtual void  v1(); // _ZN7S1389C12v1Ev
  virtual void  v2(); // _ZN7S1389C12v2Ev
  S1389C1(); // tgen
};
//SIG(1 S1389C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} vd v27 v28 v29 v30 Fi[3] FC14{ BC15{ BC16{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp[2] FC5 Fp} vd v45 v46 v47 v48 v49 v50 Fp Fi FC8 FC12 Fi} vd v31 v32 v33 v34 FC5[4] FC12 FC12 FC12 FC12 Fi[6]}[4]} vd v1 v2 FC14}


 S1389C1 ::~S1389C1(){ note_dtor("S1389C1", this);}
void  S1389C1 ::v1(){vfunc_called(this, "_ZN7S1389C12v1Ev");}
void  S1389C1 ::v2(){vfunc_called(this, "_ZN7S1389C12v2Ev");}
S1389C1 ::S1389C1(){ note_ctor("S1389C1", this);} // tgen

static void Test_S1389C1()
{
  extern Class_Descriptor cd_S1389C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(205,307)];
    init_test(&cd_S1389C1, buf);
    S1389C1 *dp, &lv = *(dp=new (buf) S1389C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1632,1224), "sizeof(S1389C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1389C1)");
    check_base_class_offset(lv, (S1389C4*)(S1389C3*)(S1389C2*), 0, "S1389C1");
    check_base_class_offset(lv, (S1389C3*)(S1389C2*), 0, "S1389C1");
    check_base_class_offset(lv, (S1389C2*), 0, "S1389C1");
    check_field_offset(lv, s1389c1f0, ABISELECT(1336,1000), "S1389C1.s1389c1f0");
    test_class_info(&lv, &cd_S1389C1);
    dp->~S1389C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1389C1(Test_S1389C1, "S1389C1", ABISELECT(1632,1224));

#else // __cplusplus

extern void _ZN7S1389C1C1Ev();
extern void _ZN7S1389C1D1Ev();
Name_Map name_map_S1389C1[] = {
  NSPAIR(_ZN7S1389C1C1Ev),
  NSPAIR(_ZN7S1389C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1389C4;
extern VTBL_ENTRY _ZTI7S1389C4[];
extern  VTBL_ENTRY _ZTV7S1389C4[];
extern Class_Descriptor cd_S1389C3;
extern VTBL_ENTRY _ZTI7S1389C3[];
extern  VTBL_ENTRY _ZTV7S1389C3[];
extern Class_Descriptor cd_S1389C2;
extern VTBL_ENTRY _ZTI7S1389C2[];
extern  VTBL_ENTRY _ZTV7S1389C2[];
static Base_Class bases_S1389C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1389C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1389C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1389C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1389C1[];
extern void _ZN7S1389C1D1Ev();
extern void _ZN7S1389C1D0Ev();
extern void _ZN7S1389C42v3Ev();
extern void _ZN7S1389C42v4Ev();
extern void _ZN7S1389C42v5Ev();
extern void _ZN7S1389C42v6Ev();
extern void _ZN7S1389C42v7Ev();
extern void _ZN7S1389C42v8Ev();
extern void _ZN7S1389C42v9Ev();
extern void _ZN7S1389C43v10Ev();
extern void _ZN7S1389C43v11Ev();
extern void _ZN7S1389C43v12Ev();
extern void _ZN7S1389C33v13Ev();
extern void _ZN7S1389C33v14Ev();
extern void _ZN7S1389C33v15Ev();
extern void _ZN7S1389C33v16Ev();
extern void _ZN7S1389C33v17Ev();
extern void _ZN7S1389C33v18Ev();
extern void _ZN7S1389C33v19Ev();
extern void _ZN7S1389C33v20Ev();
extern void _ZN7S1389C33v21Ev();
extern void _ZN7S1389C33v22Ev();
extern void _ZN7S1389C33v23Ev();
extern void _ZN7S1389C33v24Ev();
extern void _ZN7S1389C33v25Ev();
extern void _ZN7S1389C33v26Ev();
extern void _ZN7S1389C23v27Ev();
extern void _ZN7S1389C23v28Ev();
extern void _ZN7S1389C23v29Ev();
extern void _ZN7S1389C23v30Ev();
extern void _ZN7S1389C12v1Ev();
extern void _ZN7S1389C12v2Ev();
static  VTBL_ENTRY vtc_S1389C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1389C1[0]),
  (VTBL_ENTRY)&_ZN7S1389C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1389C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1389C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1389C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1389C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1389C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1389C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1389C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S1389C1[];
extern  VTBL_ENTRY _ZTV7S1389C1[];
Class_Descriptor cd_S1389C1 = {  "S1389C1", // class name
  bases_S1389C1, 3,
  &(vtc_S1389C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1632,1224), // object size
  NSPAIRA(_ZTI7S1389C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1389C1),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1345C4  {
  void *s1345c4f0[2];
  ::S10103C13_nt s1345c4f1;
  void *s1345c4f2;
  virtual  ~S1345C4(); // _ZN7S1345C4D1Ev
  virtual void  v2(); // _ZN7S1345C42v2Ev
  virtual void  v3(); // _ZN7S1345C42v3Ev
  virtual void  v4(); // _ZN7S1345C42v4Ev
  virtual void  v5(); // _ZN7S1345C42v5Ev
  virtual void  v6(); // _ZN7S1345C42v6Ev
  virtual void  v7(); // _ZN7S1345C42v7Ev
  virtual void  v8(); // _ZN7S1345C42v8Ev
  virtual void  v9(); // _ZN7S1345C42v9Ev
  virtual void  v10(); // _ZN7S1345C43v10Ev
  virtual void  v11(); // _ZN7S1345C43v11Ev
  S1345C4(); // tgen
};
//SIG(-1 S1345C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1345C4 ::~S1345C4(){ note_dtor("S1345C4", this);}
void  S1345C4 ::v2(){vfunc_called(this, "_ZN7S1345C42v2Ev");}
void  S1345C4 ::v3(){vfunc_called(this, "_ZN7S1345C42v3Ev");}
void  S1345C4 ::v4(){vfunc_called(this, "_ZN7S1345C42v4Ev");}
void  S1345C4 ::v5(){vfunc_called(this, "_ZN7S1345C42v5Ev");}
void  S1345C4 ::v6(){vfunc_called(this, "_ZN7S1345C42v6Ev");}
void  S1345C4 ::v7(){vfunc_called(this, "_ZN7S1345C42v7Ev");}
void  S1345C4 ::v8(){vfunc_called(this, "_ZN7S1345C42v8Ev");}
void  S1345C4 ::v9(){vfunc_called(this, "_ZN7S1345C42v9Ev");}
void  S1345C4 ::v10(){vfunc_called(this, "_ZN7S1345C43v10Ev");}
void  S1345C4 ::v11(){vfunc_called(this, "_ZN7S1345C43v11Ev");}
S1345C4 ::S1345C4(){ note_ctor("S1345C4", this);} // tgen

static void Test_S1345C4()
{
  extern Class_Descriptor cd_S1345C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1345C4, buf);
    S1345C4 *dp, &lv = *(dp=new (buf) S1345C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1345C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1345C4)");
    check_field_offset(lv, s1345c4f0, ABISELECT(8,4), "S1345C4.s1345c4f0");
    check_field_offset(lv, s1345c4f1, ABISELECT(24,12), "S1345C4.s1345c4f1");
    check_field_offset(lv, s1345c4f2, ABISELECT(48,28), "S1345C4.s1345c4f2");
    test_class_info(&lv, &cd_S1345C4);
    dp->~S1345C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1345C4(Test_S1345C4, "S1345C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1345C4C1Ev();
extern void _ZN7S1345C4D1Ev();
Name_Map name_map_S1345C4[] = {
  NSPAIR(_ZN7S1345C4C1Ev),
  NSPAIR(_ZN7S1345C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1345C4[];
extern void _ZN7S1345C4D1Ev();
extern void _ZN7S1345C4D0Ev();
extern void _ZN7S1345C42v2Ev();
extern void _ZN7S1345C42v3Ev();
extern void _ZN7S1345C42v4Ev();
extern void _ZN7S1345C42v5Ev();
extern void _ZN7S1345C42v6Ev();
extern void _ZN7S1345C42v7Ev();
extern void _ZN7S1345C42v8Ev();
extern void _ZN7S1345C42v9Ev();
extern void _ZN7S1345C43v10Ev();
extern void _ZN7S1345C43v11Ev();
static  VTBL_ENTRY vtc_S1345C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1345C4[0]),
  (VTBL_ENTRY)&_ZN7S1345C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1345C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v11Ev,
};
extern VTBL_ENTRY _ZTI7S1345C4[];
extern  VTBL_ENTRY _ZTV7S1345C4[];
Class_Descriptor cd_S1345C4 = {  "S1345C4", // class name
  0,0,//no base classes
  &(vtc_S1345C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1345C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1345C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1345C3  : S1345C4 {
  ::S10103C86 s1345c3f0;
  ::S10103C106 s1345c3f1;
  ::S10103C82_nt s1345c3f2;
  ::S10103C13_nt s1345c3f3;
  virtual  ~S1345C3(); // _ZN7S1345C3D1Ev
  virtual void  v12(); // _ZN7S1345C33v12Ev
  virtual void  v13(); // _ZN7S1345C33v13Ev
  virtual void  v14(); // _ZN7S1345C33v14Ev
  virtual void  v15(); // _ZN7S1345C33v15Ev
  virtual void  v16(); // _ZN7S1345C33v16Ev
  virtual void  v17(); // _ZN7S1345C33v17Ev
  virtual void  v18(); // _ZN7S1345C33v18Ev
  virtual void  v19(); // _ZN7S1345C33v19Ev
  virtual void  v20(); // _ZN7S1345C33v20Ev
  virtual void  v21(); // _ZN7S1345C33v21Ev
  virtual void  v22(); // _ZN7S1345C33v22Ev
  virtual void  v23(); // _ZN7S1345C33v23Ev
  virtual void  v24(); // _ZN7S1345C33v24Ev
  virtual void  v25(); // _ZN7S1345C33v25Ev
  S1345C3(); // tgen
};
//SIG(-1 S1345C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1345C3 ::~S1345C3(){ note_dtor("S1345C3", this);}
void  S1345C3 ::v12(){vfunc_called(this, "_ZN7S1345C33v12Ev");}
void  S1345C3 ::v13(){vfunc_called(this, "_ZN7S1345C33v13Ev");}
void  S1345C3 ::v14(){vfunc_called(this, "_ZN7S1345C33v14Ev");}
void  S1345C3 ::v15(){vfunc_called(this, "_ZN7S1345C33v15Ev");}
void  S1345C3 ::v16(){vfunc_called(this, "_ZN7S1345C33v16Ev");}
void  S1345C3 ::v17(){vfunc_called(this, "_ZN7S1345C33v17Ev");}
void  S1345C3 ::v18(){vfunc_called(this, "_ZN7S1345C33v18Ev");}
void  S1345C3 ::v19(){vfunc_called(this, "_ZN7S1345C33v19Ev");}
void  S1345C3 ::v20(){vfunc_called(this, "_ZN7S1345C33v20Ev");}
void  S1345C3 ::v21(){vfunc_called(this, "_ZN7S1345C33v21Ev");}
void  S1345C3 ::v22(){vfunc_called(this, "_ZN7S1345C33v22Ev");}
void  S1345C3 ::v23(){vfunc_called(this, "_ZN7S1345C33v23Ev");}
void  S1345C3 ::v24(){vfunc_called(this, "_ZN7S1345C33v24Ev");}
void  S1345C3 ::v25(){vfunc_called(this, "_ZN7S1345C33v25Ev");}
S1345C3 ::S1345C3(){ note_ctor("S1345C3", this);} // tgen

static void Test_S1345C3()
{
  extern Class_Descriptor cd_S1345C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1345C3, buf);
    S1345C3 *dp, &lv = *(dp=new (buf) S1345C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1345C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1345C3)");
    check_base_class_offset(lv, (S1345C4*), 0, "S1345C3");
    check_field_offset(lv, s1345c3f0, ABISELECT(56,32), "S1345C3.s1345c3f0");
    check_field_offset(lv, s1345c3f1, ABISELECT(72,44), "S1345C3.s1345c3f1");
    check_field_offset(lv, s1345c3f2, ABISELECT(96,60), "S1345C3.s1345c3f2");
    check_field_offset(lv, s1345c3f3, ABISELECT(112,76), "S1345C3.s1345c3f3");
    test_class_info(&lv, &cd_S1345C3);
    dp->~S1345C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1345C3(Test_S1345C3, "S1345C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1345C3C1Ev();
extern void _ZN7S1345C3D1Ev();
Name_Map name_map_S1345C3[] = {
  NSPAIR(_ZN7S1345C3C1Ev),
  NSPAIR(_ZN7S1345C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1345C4;
extern VTBL_ENTRY _ZTI7S1345C4[];
extern  VTBL_ENTRY _ZTV7S1345C4[];
static Base_Class bases_S1345C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1345C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1345C3[];
extern void _ZN7S1345C3D1Ev();
extern void _ZN7S1345C3D0Ev();
extern void _ZN7S1345C42v2Ev();
extern void _ZN7S1345C42v3Ev();
extern void _ZN7S1345C42v4Ev();
extern void _ZN7S1345C42v5Ev();
extern void _ZN7S1345C42v6Ev();
extern void _ZN7S1345C42v7Ev();
extern void _ZN7S1345C42v8Ev();
extern void _ZN7S1345C42v9Ev();
extern void _ZN7S1345C43v10Ev();
extern void _ZN7S1345C43v11Ev();
extern void _ZN7S1345C33v12Ev();
extern void _ZN7S1345C33v13Ev();
extern void _ZN7S1345C33v14Ev();
extern void _ZN7S1345C33v15Ev();
extern void _ZN7S1345C33v16Ev();
extern void _ZN7S1345C33v17Ev();
extern void _ZN7S1345C33v18Ev();
extern void _ZN7S1345C33v19Ev();
extern void _ZN7S1345C33v20Ev();
extern void _ZN7S1345C33v21Ev();
extern void _ZN7S1345C33v22Ev();
extern void _ZN7S1345C33v23Ev();
extern void _ZN7S1345C33v24Ev();
extern void _ZN7S1345C33v25Ev();
static  VTBL_ENTRY vtc_S1345C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1345C3[0]),
  (VTBL_ENTRY)&_ZN7S1345C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1345C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v12Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v25Ev,
};
extern VTBL_ENTRY _ZTI7S1345C3[];
extern  VTBL_ENTRY _ZTV7S1345C3[];
Class_Descriptor cd_S1345C3 = {  "S1345C3", // class name
  bases_S1345C3, 1,
  &(vtc_S1345C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1345C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1345C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1345C2  : S1345C3 {
  ::S10103C84 s1345c2f0;
  ::S10103C82_nt s1345c2f1;
  ::S10103C82_nt s1345c2f2;
  virtual void  v26(); // _ZN7S1345C23v26Ev
  virtual void  v27(); // _ZN7S1345C23v27Ev
  virtual void  v28(); // _ZN7S1345C23v28Ev
  virtual void  v29(); // _ZN7S1345C23v29Ev
  ~S1345C2(); // tgen
  S1345C2(); // tgen
};
//SIG(-1 S1345C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]} FC11 FC11}


void  S1345C2 ::v26(){vfunc_called(this, "_ZN7S1345C23v26Ev");}
void  S1345C2 ::v27(){vfunc_called(this, "_ZN7S1345C23v27Ev");}
void  S1345C2 ::v28(){vfunc_called(this, "_ZN7S1345C23v28Ev");}
void  S1345C2 ::v29(){vfunc_called(this, "_ZN7S1345C23v29Ev");}
S1345C2 ::~S1345C2(){ note_dtor("S1345C2", this);} // tgen
S1345C2 ::S1345C2(){ note_ctor("S1345C2", this);} // tgen

static void Test_S1345C2()
{
  extern Class_Descriptor cd_S1345C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,88)];
    init_test(&cd_S1345C2, buf);
    S1345C2 *dp, &lv = *(dp=new (buf) S1345C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,348), "sizeof(S1345C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1345C2)");
    check_base_class_offset(lv, (S1345C4*)(S1345C3*), 0, "S1345C2");
    check_base_class_offset(lv, (S1345C3*), 0, "S1345C2");
    check_field_offset(lv, s1345c2f0, ABISELECT(136,92), "S1345C2.s1345c2f0");
    check_field_offset(lv, s1345c2f1, ABISELECT(432,316), "S1345C2.s1345c2f1");
    check_field_offset(lv, s1345c2f2, ABISELECT(448,332), "S1345C2.s1345c2f2");
    test_class_info(&lv, &cd_S1345C2);
    dp->~S1345C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1345C2(Test_S1345C2, "S1345C2", ABISELECT(464,348));

#else // __cplusplus

extern void _ZN7S1345C2C1Ev();
extern void _ZN7S1345C2D1Ev();
Name_Map name_map_S1345C2[] = {
  NSPAIR(_ZN7S1345C2C1Ev),
  NSPAIR(_ZN7S1345C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1345C4;
extern VTBL_ENTRY _ZTI7S1345C4[];
extern  VTBL_ENTRY _ZTV7S1345C4[];
extern Class_Descriptor cd_S1345C3;
extern VTBL_ENTRY _ZTI7S1345C3[];
extern  VTBL_ENTRY _ZTV7S1345C3[];
static Base_Class bases_S1345C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1345C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1345C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1345C2[];
extern void _ZN7S1345C2D1Ev();
extern void _ZN7S1345C2D0Ev();
extern void _ZN7S1345C42v2Ev();
extern void _ZN7S1345C42v3Ev();
extern void _ZN7S1345C42v4Ev();
extern void _ZN7S1345C42v5Ev();
extern void _ZN7S1345C42v6Ev();
extern void _ZN7S1345C42v7Ev();
extern void _ZN7S1345C42v8Ev();
extern void _ZN7S1345C42v9Ev();
extern void _ZN7S1345C43v10Ev();
extern void _ZN7S1345C43v11Ev();
extern void _ZN7S1345C33v12Ev();
extern void _ZN7S1345C33v13Ev();
extern void _ZN7S1345C33v14Ev();
extern void _ZN7S1345C33v15Ev();
extern void _ZN7S1345C33v16Ev();
extern void _ZN7S1345C33v17Ev();
extern void _ZN7S1345C33v18Ev();
extern void _ZN7S1345C33v19Ev();
extern void _ZN7S1345C33v20Ev();
extern void _ZN7S1345C33v21Ev();
extern void _ZN7S1345C33v22Ev();
extern void _ZN7S1345C33v23Ev();
extern void _ZN7S1345C33v24Ev();
extern void _ZN7S1345C33v25Ev();
extern void _ZN7S1345C23v26Ev();
extern void _ZN7S1345C23v27Ev();
extern void _ZN7S1345C23v28Ev();
extern void _ZN7S1345C23v29Ev();
static  VTBL_ENTRY vtc_S1345C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1345C2[0]),
  (VTBL_ENTRY)&_ZN7S1345C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1345C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v12Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v26Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v29Ev,
};
extern VTBL_ENTRY _ZTI7S1345C2[];
extern  VTBL_ENTRY _ZTV7S1345C2[];
Class_Descriptor cd_S1345C2 = {  "S1345C2", // class name
  bases_S1345C2, 2,
  &(vtc_S1345C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,348), // object size
  NSPAIRA(_ZTI7S1345C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1345C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1345C1  : S1345C2 {
  virtual void  v1(); // _ZN7S1345C12v1Ev
  ~S1345C1(); // tgen
  S1345C1(); // tgen
};
//SIG(1 S1345C1) C1{ BC2{ BC3{ BC4{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v26 v27 v28 v29 FC14{ BC15{ BC16{ vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 Fp[2] FC5 Fp} vd v44 v45 v46 v47 v48 v49 Fp Fi FC8 FC12 Fi} vd v30 v31 v32 v33 FC5[4] FC12 FC12 FC12 FC12 Fi[6]} FC12 FC12} v1}


void  S1345C1 ::v1(){vfunc_called(this, "_ZN7S1345C12v1Ev");}
S1345C1 ::~S1345C1(){ note_dtor("S1345C1", this);} // tgen
S1345C1 ::S1345C1(){ note_ctor("S1345C1", this);} // tgen

static void Test_S1345C1()
{
  extern Class_Descriptor cd_S1345C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,88)];
    init_test(&cd_S1345C1, buf);
    S1345C1 *dp, &lv = *(dp=new (buf) S1345C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,348), "sizeof(S1345C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1345C1)");
    check_base_class_offset(lv, (S1345C4*)(S1345C3*)(S1345C2*), 0, "S1345C1");
    check_base_class_offset(lv, (S1345C3*)(S1345C2*), 0, "S1345C1");
    check_base_class_offset(lv, (S1345C2*), 0, "S1345C1");
    test_class_info(&lv, &cd_S1345C1);
    dp->~S1345C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1345C1(Test_S1345C1, "S1345C1", ABISELECT(464,348));

#else // __cplusplus

extern void _ZN7S1345C1C1Ev();
extern void _ZN7S1345C1D1Ev();
Name_Map name_map_S1345C1[] = {
  NSPAIR(_ZN7S1345C1C1Ev),
  NSPAIR(_ZN7S1345C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1345C4;
extern VTBL_ENTRY _ZTI7S1345C4[];
extern  VTBL_ENTRY _ZTV7S1345C4[];
extern Class_Descriptor cd_S1345C3;
extern VTBL_ENTRY _ZTI7S1345C3[];
extern  VTBL_ENTRY _ZTV7S1345C3[];
extern Class_Descriptor cd_S1345C2;
extern VTBL_ENTRY _ZTI7S1345C2[];
extern  VTBL_ENTRY _ZTV7S1345C2[];
static Base_Class bases_S1345C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1345C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1345C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1345C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1345C1[];
extern void _ZN7S1345C1D1Ev();
extern void _ZN7S1345C1D0Ev();
extern void _ZN7S1345C42v2Ev();
extern void _ZN7S1345C42v3Ev();
extern void _ZN7S1345C42v4Ev();
extern void _ZN7S1345C42v5Ev();
extern void _ZN7S1345C42v6Ev();
extern void _ZN7S1345C42v7Ev();
extern void _ZN7S1345C42v8Ev();
extern void _ZN7S1345C42v9Ev();
extern void _ZN7S1345C43v10Ev();
extern void _ZN7S1345C43v11Ev();
extern void _ZN7S1345C33v12Ev();
extern void _ZN7S1345C33v13Ev();
extern void _ZN7S1345C33v14Ev();
extern void _ZN7S1345C33v15Ev();
extern void _ZN7S1345C33v16Ev();
extern void _ZN7S1345C33v17Ev();
extern void _ZN7S1345C33v18Ev();
extern void _ZN7S1345C33v19Ev();
extern void _ZN7S1345C33v20Ev();
extern void _ZN7S1345C33v21Ev();
extern void _ZN7S1345C33v22Ev();
extern void _ZN7S1345C33v23Ev();
extern void _ZN7S1345C33v24Ev();
extern void _ZN7S1345C33v25Ev();
extern void _ZN7S1345C23v26Ev();
extern void _ZN7S1345C23v27Ev();
extern void _ZN7S1345C23v28Ev();
extern void _ZN7S1345C23v29Ev();
extern void _ZN7S1345C12v1Ev();
static  VTBL_ENTRY vtc_S1345C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1345C1[0]),
  (VTBL_ENTRY)&_ZN7S1345C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1345C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1345C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1345C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v12Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1345C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v26Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v28Ev,
  (VTBL_ENTRY)&_ZN7S1345C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1345C12v1Ev,
};
extern VTBL_ENTRY _ZTI7S1345C1[];
extern  VTBL_ENTRY _ZTV7S1345C1[];
Class_Descriptor cd_S1345C1 = {  "S1345C1", // class name
  bases_S1345C1, 3,
  &(vtc_S1345C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,348), // object size
  NSPAIRA(_ZTI7S1345C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1345C1),33, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1387C4  {
  void *s1387c4f0[2];
  ::S10103C13_nt s1387c4f1;
  void *s1387c4f2;
  virtual  ~S1387C4(); // _ZN7S1387C4D1Ev
  virtual void  v3(); // _ZN7S1387C42v3Ev
  virtual void  v4(); // _ZN7S1387C42v4Ev
  virtual void  v5(); // _ZN7S1387C42v5Ev
  virtual void  v6(); // _ZN7S1387C42v6Ev
  virtual void  v7(); // _ZN7S1387C42v7Ev
  virtual void  v8(); // _ZN7S1387C42v8Ev
  virtual void  v9(); // _ZN7S1387C42v9Ev
  virtual void  v10(); // _ZN7S1387C43v10Ev
  virtual void  v11(); // _ZN7S1387C43v11Ev
  virtual void  v12(); // _ZN7S1387C43v12Ev
  S1387C4(); // tgen
};
//SIG(-1 S1387C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1387C4 ::~S1387C4(){ note_dtor("S1387C4", this);}
void  S1387C4 ::v3(){vfunc_called(this, "_ZN7S1387C42v3Ev");}
void  S1387C4 ::v4(){vfunc_called(this, "_ZN7S1387C42v4Ev");}
void  S1387C4 ::v5(){vfunc_called(this, "_ZN7S1387C42v5Ev");}
void  S1387C4 ::v6(){vfunc_called(this, "_ZN7S1387C42v6Ev");}
void  S1387C4 ::v7(){vfunc_called(this, "_ZN7S1387C42v7Ev");}
void  S1387C4 ::v8(){vfunc_called(this, "_ZN7S1387C42v8Ev");}
void  S1387C4 ::v9(){vfunc_called(this, "_ZN7S1387C42v9Ev");}
void  S1387C4 ::v10(){vfunc_called(this, "_ZN7S1387C43v10Ev");}
void  S1387C4 ::v11(){vfunc_called(this, "_ZN7S1387C43v11Ev");}
void  S1387C4 ::v12(){vfunc_called(this, "_ZN7S1387C43v12Ev");}
S1387C4 ::S1387C4(){ note_ctor("S1387C4", this);} // tgen

static void Test_S1387C4()
{
  extern Class_Descriptor cd_S1387C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1387C4, buf);
    S1387C4 *dp, &lv = *(dp=new (buf) S1387C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1387C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1387C4)");
    check_field_offset(lv, s1387c4f0, ABISELECT(8,4), "S1387C4.s1387c4f0");
    check_field_offset(lv, s1387c4f1, ABISELECT(24,12), "S1387C4.s1387c4f1");
    check_field_offset(lv, s1387c4f2, ABISELECT(48,28), "S1387C4.s1387c4f2");
    test_class_info(&lv, &cd_S1387C4);
    dp->~S1387C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1387C4(Test_S1387C4, "S1387C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1387C4C1Ev();
extern void _ZN7S1387C4D1Ev();
Name_Map name_map_S1387C4[] = {
  NSPAIR(_ZN7S1387C4C1Ev),
  NSPAIR(_ZN7S1387C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1387C4[];
extern void _ZN7S1387C4D1Ev();
extern void _ZN7S1387C4D0Ev();
extern void _ZN7S1387C42v3Ev();
extern void _ZN7S1387C42v4Ev();
extern void _ZN7S1387C42v5Ev();
extern void _ZN7S1387C42v6Ev();
extern void _ZN7S1387C42v7Ev();
extern void _ZN7S1387C42v8Ev();
extern void _ZN7S1387C42v9Ev();
extern void _ZN7S1387C43v10Ev();
extern void _ZN7S1387C43v11Ev();
extern void _ZN7S1387C43v12Ev();
static  VTBL_ENTRY vtc_S1387C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1387C4[0]),
  (VTBL_ENTRY)&_ZN7S1387C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1387C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S1387C4[];
extern  VTBL_ENTRY _ZTV7S1387C4[];
Class_Descriptor cd_S1387C4 = {  "S1387C4", // class name
  0,0,//no base classes
  &(vtc_S1387C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1387C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1387C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1387C3  : S1387C4 {
  ::S10103C86 s1387c3f0;
  ::S10103C106 s1387c3f1;
  ::S10103C82_nt s1387c3f2;
  ::S10103C13_nt s1387c3f3;
  virtual  ~S1387C3(); // _ZN7S1387C3D1Ev
  virtual void  v13(); // _ZN7S1387C33v13Ev
  virtual void  v14(); // _ZN7S1387C33v14Ev
  virtual void  v15(); // _ZN7S1387C33v15Ev
  virtual void  v16(); // _ZN7S1387C33v16Ev
  virtual void  v17(); // _ZN7S1387C33v17Ev
  virtual void  v18(); // _ZN7S1387C33v18Ev
  virtual void  v19(); // _ZN7S1387C33v19Ev
  virtual void  v20(); // _ZN7S1387C33v20Ev
  virtual void  v21(); // _ZN7S1387C33v21Ev
  virtual void  v22(); // _ZN7S1387C33v22Ev
  virtual void  v23(); // _ZN7S1387C33v23Ev
  virtual void  v24(); // _ZN7S1387C33v24Ev
  virtual void  v25(); // _ZN7S1387C33v25Ev
  virtual void  v26(); // _ZN7S1387C33v26Ev
  S1387C3(); // tgen
};
//SIG(-1 S1387C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1387C3 ::~S1387C3(){ note_dtor("S1387C3", this);}
void  S1387C3 ::v13(){vfunc_called(this, "_ZN7S1387C33v13Ev");}
void  S1387C3 ::v14(){vfunc_called(this, "_ZN7S1387C33v14Ev");}
void  S1387C3 ::v15(){vfunc_called(this, "_ZN7S1387C33v15Ev");}
void  S1387C3 ::v16(){vfunc_called(this, "_ZN7S1387C33v16Ev");}
void  S1387C3 ::v17(){vfunc_called(this, "_ZN7S1387C33v17Ev");}
void  S1387C3 ::v18(){vfunc_called(this, "_ZN7S1387C33v18Ev");}
void  S1387C3 ::v19(){vfunc_called(this, "_ZN7S1387C33v19Ev");}
void  S1387C3 ::v20(){vfunc_called(this, "_ZN7S1387C33v20Ev");}
void  S1387C3 ::v21(){vfunc_called(this, "_ZN7S1387C33v21Ev");}
void  S1387C3 ::v22(){vfunc_called(this, "_ZN7S1387C33v22Ev");}
void  S1387C3 ::v23(){vfunc_called(this, "_ZN7S1387C33v23Ev");}
void  S1387C3 ::v24(){vfunc_called(this, "_ZN7S1387C33v24Ev");}
void  S1387C3 ::v25(){vfunc_called(this, "_ZN7S1387C33v25Ev");}
void  S1387C3 ::v26(){vfunc_called(this, "_ZN7S1387C33v26Ev");}
S1387C3 ::S1387C3(){ note_ctor("S1387C3", this);} // tgen

static void Test_S1387C3()
{
  extern Class_Descriptor cd_S1387C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1387C3, buf);
    S1387C3 *dp, &lv = *(dp=new (buf) S1387C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1387C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1387C3)");
    check_base_class_offset(lv, (S1387C4*), 0, "S1387C3");
    check_field_offset(lv, s1387c3f0, ABISELECT(56,32), "S1387C3.s1387c3f0");
    check_field_offset(lv, s1387c3f1, ABISELECT(72,44), "S1387C3.s1387c3f1");
    check_field_offset(lv, s1387c3f2, ABISELECT(96,60), "S1387C3.s1387c3f2");
    check_field_offset(lv, s1387c3f3, ABISELECT(112,76), "S1387C3.s1387c3f3");
    test_class_info(&lv, &cd_S1387C3);
    dp->~S1387C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1387C3(Test_S1387C3, "S1387C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1387C3C1Ev();
extern void _ZN7S1387C3D1Ev();
Name_Map name_map_S1387C3[] = {
  NSPAIR(_ZN7S1387C3C1Ev),
  NSPAIR(_ZN7S1387C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1387C4;
extern VTBL_ENTRY _ZTI7S1387C4[];
extern  VTBL_ENTRY _ZTV7S1387C4[];
static Base_Class bases_S1387C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1387C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1387C3[];
extern void _ZN7S1387C3D1Ev();
extern void _ZN7S1387C3D0Ev();
extern void _ZN7S1387C42v3Ev();
extern void _ZN7S1387C42v4Ev();
extern void _ZN7S1387C42v5Ev();
extern void _ZN7S1387C42v6Ev();
extern void _ZN7S1387C42v7Ev();
extern void _ZN7S1387C42v8Ev();
extern void _ZN7S1387C42v9Ev();
extern void _ZN7S1387C43v10Ev();
extern void _ZN7S1387C43v11Ev();
extern void _ZN7S1387C43v12Ev();
extern void _ZN7S1387C33v13Ev();
extern void _ZN7S1387C33v14Ev();
extern void _ZN7S1387C33v15Ev();
extern void _ZN7S1387C33v16Ev();
extern void _ZN7S1387C33v17Ev();
extern void _ZN7S1387C33v18Ev();
extern void _ZN7S1387C33v19Ev();
extern void _ZN7S1387C33v20Ev();
extern void _ZN7S1387C33v21Ev();
extern void _ZN7S1387C33v22Ev();
extern void _ZN7S1387C33v23Ev();
extern void _ZN7S1387C33v24Ev();
extern void _ZN7S1387C33v25Ev();
extern void _ZN7S1387C33v26Ev();
static  VTBL_ENTRY vtc_S1387C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1387C3[0]),
  (VTBL_ENTRY)&_ZN7S1387C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1387C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v26Ev,
};
extern VTBL_ENTRY _ZTI7S1387C3[];
extern  VTBL_ENTRY _ZTV7S1387C3[];
Class_Descriptor cd_S1387C3 = {  "S1387C3", // class name
  bases_S1387C3, 1,
  &(vtc_S1387C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1387C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1387C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1387C2  : S1387C3 {
  ::S10103C84 s1387c2f0;
  virtual  ~S1387C2(); // _ZN7S1387C2D1Ev
  virtual void  v27(); // _ZN7S1387C23v27Ev
  S1387C2(); // tgen
};
//SIG(-1 S1387C2) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 FC13{ BC14{ BC15{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp[2] FC4 Fp} vd v40 v41 v42 v43 v44 v45 Fp Fi FC7 FC11 Fi} vd v26 v27 v28 v29 FC4[4] FC11 FC11 FC11 FC11 Fi[6]}}


 S1387C2 ::~S1387C2(){ note_dtor("S1387C2", this);}
void  S1387C2 ::v27(){vfunc_called(this, "_ZN7S1387C23v27Ev");}
S1387C2 ::S1387C2(){ note_ctor("S1387C2", this);} // tgen

static void Test_S1387C2()
{
  extern Class_Descriptor cd_S1387C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,80)];
    init_test(&cd_S1387C2, buf);
    S1387C2 *dp, &lv = *(dp=new (buf) S1387C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,316), "sizeof(S1387C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1387C2)");
    check_base_class_offset(lv, (S1387C4*)(S1387C3*), 0, "S1387C2");
    check_base_class_offset(lv, (S1387C3*), 0, "S1387C2");
    check_field_offset(lv, s1387c2f0, ABISELECT(136,92), "S1387C2.s1387c2f0");
    test_class_info(&lv, &cd_S1387C2);
    dp->~S1387C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1387C2(Test_S1387C2, "S1387C2", ABISELECT(432,316));

#else // __cplusplus

extern void _ZN7S1387C2C1Ev();
extern void _ZN7S1387C2D1Ev();
Name_Map name_map_S1387C2[] = {
  NSPAIR(_ZN7S1387C2C1Ev),
  NSPAIR(_ZN7S1387C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1387C4;
extern VTBL_ENTRY _ZTI7S1387C4[];
extern  VTBL_ENTRY _ZTV7S1387C4[];
extern Class_Descriptor cd_S1387C3;
extern VTBL_ENTRY _ZTI7S1387C3[];
extern  VTBL_ENTRY _ZTV7S1387C3[];
static Base_Class bases_S1387C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1387C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1387C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1387C2[];
extern void _ZN7S1387C2D1Ev();
extern void _ZN7S1387C2D0Ev();
extern void _ZN7S1387C42v3Ev();
extern void _ZN7S1387C42v4Ev();
extern void _ZN7S1387C42v5Ev();
extern void _ZN7S1387C42v6Ev();
extern void _ZN7S1387C42v7Ev();
extern void _ZN7S1387C42v8Ev();
extern void _ZN7S1387C42v9Ev();
extern void _ZN7S1387C43v10Ev();
extern void _ZN7S1387C43v11Ev();
extern void _ZN7S1387C43v12Ev();
extern void _ZN7S1387C33v13Ev();
extern void _ZN7S1387C33v14Ev();
extern void _ZN7S1387C33v15Ev();
extern void _ZN7S1387C33v16Ev();
extern void _ZN7S1387C33v17Ev();
extern void _ZN7S1387C33v18Ev();
extern void _ZN7S1387C33v19Ev();
extern void _ZN7S1387C33v20Ev();
extern void _ZN7S1387C33v21Ev();
extern void _ZN7S1387C33v22Ev();
extern void _ZN7S1387C33v23Ev();
extern void _ZN7S1387C33v24Ev();
extern void _ZN7S1387C33v25Ev();
extern void _ZN7S1387C33v26Ev();
extern void _ZN7S1387C23v27Ev();
static  VTBL_ENTRY vtc_S1387C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1387C2[0]),
  (VTBL_ENTRY)&_ZN7S1387C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1387C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1387C23v27Ev,
};
extern VTBL_ENTRY _ZTI7S1387C2[];
extern  VTBL_ENTRY _ZTV7S1387C2[];
Class_Descriptor cd_S1387C2 = {  "S1387C2", // class name
  bases_S1387C2, 2,
  &(vtc_S1387C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,316), // object size
  NSPAIRA(_ZTI7S1387C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1387C2),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1387C1  : S1387C2 {
  ::S10103C84 s1387c1f0;
  ::S10103C84 s1387c1f1;
  virtual  ~S1387C1(); // _ZN7S1387C1D1Ev
  virtual void  v1(); // _ZN7S1387C12v1Ev
  virtual void  v2(); // _ZN7S1387C12v2Ev
  S1387C1(); // tgen
};
//SIG(1 S1387C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} vd v27 FC14{ BC15{ BC16{ vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[2] FC5 Fp} vd v42 v43 v44 v45 v46 v47 Fp Fi FC8 FC12 Fi} vd v28 v29 v30 v31 FC5[4] FC12 FC12 FC12 FC12 Fi[6]}} vd v1 v2 FC14 FC14}


 S1387C1 ::~S1387C1(){ note_dtor("S1387C1", this);}
void  S1387C1 ::v1(){vfunc_called(this, "_ZN7S1387C12v1Ev");}
void  S1387C1 ::v2(){vfunc_called(this, "_ZN7S1387C12v2Ev");}
S1387C1 ::S1387C1(){ note_ctor("S1387C1", this);} // tgen

static void Test_S1387C1()
{
  extern Class_Descriptor cd_S1387C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(129,192)];
    init_test(&cd_S1387C1, buf);
    S1387C1 *dp, &lv = *(dp=new (buf) S1387C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1024,764), "sizeof(S1387C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1387C1)");
    check_base_class_offset(lv, (S1387C4*)(S1387C3*)(S1387C2*), 0, "S1387C1");
    check_base_class_offset(lv, (S1387C3*)(S1387C2*), 0, "S1387C1");
    check_base_class_offset(lv, (S1387C2*), 0, "S1387C1");
    check_field_offset(lv, s1387c1f0, ABISELECT(432,316), "S1387C1.s1387c1f0");
    check_field_offset(lv, s1387c1f1, ABISELECT(728,540), "S1387C1.s1387c1f1");
    test_class_info(&lv, &cd_S1387C1);
    dp->~S1387C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1387C1(Test_S1387C1, "S1387C1", ABISELECT(1024,764));

#else // __cplusplus

extern void _ZN7S1387C1C1Ev();
extern void _ZN7S1387C1D1Ev();
Name_Map name_map_S1387C1[] = {
  NSPAIR(_ZN7S1387C1C1Ev),
  NSPAIR(_ZN7S1387C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1387C4;
extern VTBL_ENTRY _ZTI7S1387C4[];
extern  VTBL_ENTRY _ZTV7S1387C4[];
extern Class_Descriptor cd_S1387C3;
extern VTBL_ENTRY _ZTI7S1387C3[];
extern  VTBL_ENTRY _ZTV7S1387C3[];
extern Class_Descriptor cd_S1387C2;
extern VTBL_ENTRY _ZTI7S1387C2[];
extern  VTBL_ENTRY _ZTV7S1387C2[];
static Base_Class bases_S1387C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1387C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1387C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1387C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1387C1[];
extern void _ZN7S1387C1D1Ev();
extern void _ZN7S1387C1D0Ev();
extern void _ZN7S1387C42v3Ev();
extern void _ZN7S1387C42v4Ev();
extern void _ZN7S1387C42v5Ev();
extern void _ZN7S1387C42v6Ev();
extern void _ZN7S1387C42v7Ev();
extern void _ZN7S1387C42v8Ev();
extern void _ZN7S1387C42v9Ev();
extern void _ZN7S1387C43v10Ev();
extern void _ZN7S1387C43v11Ev();
extern void _ZN7S1387C43v12Ev();
extern void _ZN7S1387C33v13Ev();
extern void _ZN7S1387C33v14Ev();
extern void _ZN7S1387C33v15Ev();
extern void _ZN7S1387C33v16Ev();
extern void _ZN7S1387C33v17Ev();
extern void _ZN7S1387C33v18Ev();
extern void _ZN7S1387C33v19Ev();
extern void _ZN7S1387C33v20Ev();
extern void _ZN7S1387C33v21Ev();
extern void _ZN7S1387C33v22Ev();
extern void _ZN7S1387C33v23Ev();
extern void _ZN7S1387C33v24Ev();
extern void _ZN7S1387C33v25Ev();
extern void _ZN7S1387C33v26Ev();
extern void _ZN7S1387C23v27Ev();
extern void _ZN7S1387C12v1Ev();
extern void _ZN7S1387C12v2Ev();
static  VTBL_ENTRY vtc_S1387C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1387C1[0]),
  (VTBL_ENTRY)&_ZN7S1387C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1387C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1387C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1387C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1387C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1387C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1387C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1387C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S1387C1[];
extern  VTBL_ENTRY _ZTV7S1387C1[];
Class_Descriptor cd_S1387C1 = {  "S1387C1", // class name
  bases_S1387C1, 3,
  &(vtc_S1387C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1024,764), // object size
  NSPAIRA(_ZTI7S1387C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1387C1),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3327C3  {
  void *s3327c3f0[2];
  ::S10103C13_nt s3327c3f1;
  void *s3327c3f2;
  virtual  ~S3327C3(); // _ZN7S3327C3D1Ev
  virtual void  v5(); // _ZN7S3327C32v5Ev
  virtual void  v6(); // _ZN7S3327C32v6Ev
  virtual void  v7(); // _ZN7S3327C32v7Ev
  virtual void  v8(); // _ZN7S3327C32v8Ev
  virtual void  v9(); // _ZN7S3327C32v9Ev
  virtual void  v10(); // _ZN7S3327C33v10Ev
  virtual void  v11(); // _ZN7S3327C33v11Ev
  virtual void  v12(); // _ZN7S3327C33v12Ev
  virtual void  v13(); // _ZN7S3327C33v13Ev
  virtual void  v14(); // _ZN7S3327C33v14Ev
  S3327C3(); // tgen
};
//SIG(-1 S3327C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S3327C3 ::~S3327C3(){ note_dtor("S3327C3", this);}
void  S3327C3 ::v5(){vfunc_called(this, "_ZN7S3327C32v5Ev");}
void  S3327C3 ::v6(){vfunc_called(this, "_ZN7S3327C32v6Ev");}
void  S3327C3 ::v7(){vfunc_called(this, "_ZN7S3327C32v7Ev");}
void  S3327C3 ::v8(){vfunc_called(this, "_ZN7S3327C32v8Ev");}
void  S3327C3 ::v9(){vfunc_called(this, "_ZN7S3327C32v9Ev");}
void  S3327C3 ::v10(){vfunc_called(this, "_ZN7S3327C33v10Ev");}
void  S3327C3 ::v11(){vfunc_called(this, "_ZN7S3327C33v11Ev");}
void  S3327C3 ::v12(){vfunc_called(this, "_ZN7S3327C33v12Ev");}
void  S3327C3 ::v13(){vfunc_called(this, "_ZN7S3327C33v13Ev");}
void  S3327C3 ::v14(){vfunc_called(this, "_ZN7S3327C33v14Ev");}
S3327C3 ::S3327C3(){ note_ctor("S3327C3", this);} // tgen

static void Test_S3327C3()
{
  extern Class_Descriptor cd_S3327C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S3327C3, buf);
    S3327C3 *dp, &lv = *(dp=new (buf) S3327C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S3327C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3327C3)");
    check_field_offset(lv, s3327c3f0, ABISELECT(8,4), "S3327C3.s3327c3f0");
    check_field_offset(lv, s3327c3f1, ABISELECT(24,12), "S3327C3.s3327c3f1");
    check_field_offset(lv, s3327c3f2, ABISELECT(48,28), "S3327C3.s3327c3f2");
    test_class_info(&lv, &cd_S3327C3);
    dp->~S3327C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3327C3(Test_S3327C3, "S3327C3", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S3327C3C1Ev();
extern void _ZN7S3327C3D1Ev();
Name_Map name_map_S3327C3[] = {
  NSPAIR(_ZN7S3327C3C1Ev),
  NSPAIR(_ZN7S3327C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3327C3[];
extern void _ZN7S3327C3D1Ev();
extern void _ZN7S3327C3D0Ev();
extern void _ZN7S3327C32v5Ev();
extern void _ZN7S3327C32v6Ev();
extern void _ZN7S3327C32v7Ev();
extern void _ZN7S3327C32v8Ev();
extern void _ZN7S3327C32v9Ev();
extern void _ZN7S3327C33v10Ev();
extern void _ZN7S3327C33v11Ev();
extern void _ZN7S3327C33v12Ev();
extern void _ZN7S3327C33v13Ev();
extern void _ZN7S3327C33v14Ev();
static  VTBL_ENTRY vtc_S3327C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3327C3[0]),
  (VTBL_ENTRY)&_ZN7S3327C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3327C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v14Ev,
};
extern VTBL_ENTRY _ZTI7S3327C3[];
extern  VTBL_ENTRY _ZTV7S3327C3[];
Class_Descriptor cd_S3327C3 = {  "S3327C3", // class name
  0,0,//no base classes
  &(vtc_S3327C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S3327C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3327C3),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3327C2  : S3327C3 {
  ::S10103C86 s3327c2f0;
  ::S10103C106 s3327c2f1;
  ::S10103C82_nt s3327c2f2;
  ::S10103C13_nt s3327c2f3;
  virtual  ~S3327C2(); // _ZN7S3327C2D1Ev
  virtual void  v15(); // _ZN7S3327C23v15Ev
  virtual void  v16(); // _ZN7S3327C23v16Ev
  virtual void  v17(); // _ZN7S3327C23v17Ev
  virtual void  v18(); // _ZN7S3327C23v18Ev
  virtual void  v19(); // _ZN7S3327C23v19Ev
  virtual void  v20(); // _ZN7S3327C23v20Ev
  virtual void  v21(); // _ZN7S3327C23v21Ev
  virtual void  v22(); // _ZN7S3327C23v22Ev
  virtual void  v23(); // _ZN7S3327C23v23Ev
  virtual void  v24(); // _ZN7S3327C23v24Ev
  virtual void  v25(); // _ZN7S3327C23v25Ev
  virtual void  v26(); // _ZN7S3327C23v26Ev
  virtual void  v27(); // _ZN7S3327C23v27Ev
  virtual void  v28(); // _ZN7S3327C23v28Ev
  S3327C2(); // tgen
};
//SIG(-1 S3327C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S3327C2 ::~S3327C2(){ note_dtor("S3327C2", this);}
void  S3327C2 ::v15(){vfunc_called(this, "_ZN7S3327C23v15Ev");}
void  S3327C2 ::v16(){vfunc_called(this, "_ZN7S3327C23v16Ev");}
void  S3327C2 ::v17(){vfunc_called(this, "_ZN7S3327C23v17Ev");}
void  S3327C2 ::v18(){vfunc_called(this, "_ZN7S3327C23v18Ev");}
void  S3327C2 ::v19(){vfunc_called(this, "_ZN7S3327C23v19Ev");}
void  S3327C2 ::v20(){vfunc_called(this, "_ZN7S3327C23v20Ev");}
void  S3327C2 ::v21(){vfunc_called(this, "_ZN7S3327C23v21Ev");}
void  S3327C2 ::v22(){vfunc_called(this, "_ZN7S3327C23v22Ev");}
void  S3327C2 ::v23(){vfunc_called(this, "_ZN7S3327C23v23Ev");}
void  S3327C2 ::v24(){vfunc_called(this, "_ZN7S3327C23v24Ev");}
void  S3327C2 ::v25(){vfunc_called(this, "_ZN7S3327C23v25Ev");}
void  S3327C2 ::v26(){vfunc_called(this, "_ZN7S3327C23v26Ev");}
void  S3327C2 ::v27(){vfunc_called(this, "_ZN7S3327C23v27Ev");}
void  S3327C2 ::v28(){vfunc_called(this, "_ZN7S3327C23v28Ev");}
S3327C2 ::S3327C2(){ note_ctor("S3327C2", this);} // tgen

static void Test_S3327C2()
{
  extern Class_Descriptor cd_S3327C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S3327C2, buf);
    S3327C2 *dp, &lv = *(dp=new (buf) S3327C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S3327C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3327C2)");
    check_base_class_offset(lv, (S3327C3*), 0, "S3327C2");
    check_field_offset(lv, s3327c2f0, ABISELECT(56,32), "S3327C2.s3327c2f0");
    check_field_offset(lv, s3327c2f1, ABISELECT(72,44), "S3327C2.s3327c2f1");
    check_field_offset(lv, s3327c2f2, ABISELECT(96,60), "S3327C2.s3327c2f2");
    check_field_offset(lv, s3327c2f3, ABISELECT(112,76), "S3327C2.s3327c2f3");
    test_class_info(&lv, &cd_S3327C2);
    dp->~S3327C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3327C2(Test_S3327C2, "S3327C2", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S3327C2C1Ev();
extern void _ZN7S3327C2D1Ev();
Name_Map name_map_S3327C2[] = {
  NSPAIR(_ZN7S3327C2C1Ev),
  NSPAIR(_ZN7S3327C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3327C3;
extern VTBL_ENTRY _ZTI7S3327C3[];
extern  VTBL_ENTRY _ZTV7S3327C3[];
static Base_Class bases_S3327C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3327C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3327C2[];
extern void _ZN7S3327C2D1Ev();
extern void _ZN7S3327C2D0Ev();
extern void _ZN7S3327C32v5Ev();
extern void _ZN7S3327C32v6Ev();
extern void _ZN7S3327C32v7Ev();
extern void _ZN7S3327C32v8Ev();
extern void _ZN7S3327C32v9Ev();
extern void _ZN7S3327C33v10Ev();
extern void _ZN7S3327C33v11Ev();
extern void _ZN7S3327C33v12Ev();
extern void _ZN7S3327C33v13Ev();
extern void _ZN7S3327C33v14Ev();
extern void _ZN7S3327C23v15Ev();
extern void _ZN7S3327C23v16Ev();
extern void _ZN7S3327C23v17Ev();
extern void _ZN7S3327C23v18Ev();
extern void _ZN7S3327C23v19Ev();
extern void _ZN7S3327C23v20Ev();
extern void _ZN7S3327C23v21Ev();
extern void _ZN7S3327C23v22Ev();
extern void _ZN7S3327C23v23Ev();
extern void _ZN7S3327C23v24Ev();
extern void _ZN7S3327C23v25Ev();
extern void _ZN7S3327C23v26Ev();
extern void _ZN7S3327C23v27Ev();
extern void _ZN7S3327C23v28Ev();
static  VTBL_ENTRY vtc_S3327C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3327C2[0]),
  (VTBL_ENTRY)&_ZN7S3327C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3327C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v28Ev,
};
extern VTBL_ENTRY _ZTI7S3327C2[];
extern  VTBL_ENTRY _ZTV7S3327C2[];
Class_Descriptor cd_S3327C2 = {  "S3327C2", // class name
  bases_S3327C2, 1,
  &(vtc_S3327C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S3327C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3327C2),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3327C1  : S3327C2 {
  int s3327c1f0[2];
  ::S10103C84 s3327c1f1[4];
  virtual  ~S3327C1(); // _ZN7S3327C1D1Ev
  virtual void  v1(); // _ZN7S3327C12v1Ev
  virtual void  v2(); // _ZN7S3327C12v2Ev
  virtual void  v3(); // _ZN7S3327C12v3Ev
  virtual void  v4(); // _ZN7S3327C12v4Ev
  S3327C1(); // tgen
};
//SIG(1 S3327C1) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 v2 v3 v4 Fi[2] FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]}[4]}


 S3327C1 ::~S3327C1(){ note_dtor("S3327C1", this);}
void  S3327C1 ::v1(){vfunc_called(this, "_ZN7S3327C12v1Ev");}
void  S3327C1 ::v2(){vfunc_called(this, "_ZN7S3327C12v2Ev");}
void  S3327C1 ::v3(){vfunc_called(this, "_ZN7S3327C12v3Ev");}
void  S3327C1 ::v4(){vfunc_called(this, "_ZN7S3327C12v4Ev");}
S3327C1 ::S3327C1(){ note_ctor("S3327C1", this);} // tgen

static void Test_S3327C1()
{
  extern Class_Descriptor cd_S3327C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(167,250)];
    init_test(&cd_S3327C1, buf);
    S3327C1 *dp, &lv = *(dp=new (buf) S3327C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1328,996), "sizeof(S3327C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3327C1)");
    check_base_class_offset(lv, (S3327C3*)(S3327C2*), 0, "S3327C1");
    check_base_class_offset(lv, (S3327C2*), 0, "S3327C1");
    check_field_offset(lv, s3327c1f0, ABISELECT(136,92), "S3327C1.s3327c1f0");
    check_field_offset(lv, s3327c1f1, ABISELECT(144,100), "S3327C1.s3327c1f1");
    test_class_info(&lv, &cd_S3327C1);
    dp->~S3327C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3327C1(Test_S3327C1, "S3327C1", ABISELECT(1328,996));

#else // __cplusplus

extern void _ZN7S3327C1C1Ev();
extern void _ZN7S3327C1D1Ev();
Name_Map name_map_S3327C1[] = {
  NSPAIR(_ZN7S3327C1C1Ev),
  NSPAIR(_ZN7S3327C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3327C3;
extern VTBL_ENTRY _ZTI7S3327C3[];
extern  VTBL_ENTRY _ZTV7S3327C3[];
extern Class_Descriptor cd_S3327C2;
extern VTBL_ENTRY _ZTI7S3327C2[];
extern  VTBL_ENTRY _ZTV7S3327C2[];
static Base_Class bases_S3327C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3327C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3327C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3327C1[];
extern void _ZN7S3327C1D1Ev();
extern void _ZN7S3327C1D0Ev();
extern void _ZN7S3327C32v5Ev();
extern void _ZN7S3327C32v6Ev();
extern void _ZN7S3327C32v7Ev();
extern void _ZN7S3327C32v8Ev();
extern void _ZN7S3327C32v9Ev();
extern void _ZN7S3327C33v10Ev();
extern void _ZN7S3327C33v11Ev();
extern void _ZN7S3327C33v12Ev();
extern void _ZN7S3327C33v13Ev();
extern void _ZN7S3327C33v14Ev();
extern void _ZN7S3327C23v15Ev();
extern void _ZN7S3327C23v16Ev();
extern void _ZN7S3327C23v17Ev();
extern void _ZN7S3327C23v18Ev();
extern void _ZN7S3327C23v19Ev();
extern void _ZN7S3327C23v20Ev();
extern void _ZN7S3327C23v21Ev();
extern void _ZN7S3327C23v22Ev();
extern void _ZN7S3327C23v23Ev();
extern void _ZN7S3327C23v24Ev();
extern void _ZN7S3327C23v25Ev();
extern void _ZN7S3327C23v26Ev();
extern void _ZN7S3327C23v27Ev();
extern void _ZN7S3327C23v28Ev();
extern void _ZN7S3327C12v1Ev();
extern void _ZN7S3327C12v2Ev();
extern void _ZN7S3327C12v3Ev();
extern void _ZN7S3327C12v4Ev();
static  VTBL_ENTRY vtc_S3327C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3327C1[0]),
  (VTBL_ENTRY)&_ZN7S3327C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3327C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3327C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3327C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3327C23v28Ev,
  (VTBL_ENTRY)&_ZN7S3327C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3327C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3327C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3327C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S3327C1[];
extern  VTBL_ENTRY _ZTV7S3327C1[];
Class_Descriptor cd_S3327C1 = {  "S3327C1", // class name
  bases_S3327C1, 2,
  &(vtc_S3327C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1328,996), // object size
  NSPAIRA(_ZTI7S3327C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3327C1),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3326C3  {
  void *s3326c3f0[2];
  ::S10103C13_nt s3326c3f1;
  void *s3326c3f2;
  virtual  ~S3326C3(); // _ZN7S3326C3D1Ev
  virtual void  v5(); // _ZN7S3326C32v5Ev
  virtual void  v6(); // _ZN7S3326C32v6Ev
  virtual void  v7(); // _ZN7S3326C32v7Ev
  virtual void  v8(); // _ZN7S3326C32v8Ev
  virtual void  v9(); // _ZN7S3326C32v9Ev
  virtual void  v10(); // _ZN7S3326C33v10Ev
  virtual void  v11(); // _ZN7S3326C33v11Ev
  virtual void  v12(); // _ZN7S3326C33v12Ev
  virtual void  v13(); // _ZN7S3326C33v13Ev
  virtual void  v14(); // _ZN7S3326C33v14Ev
  S3326C3(); // tgen
};
//SIG(-1 S3326C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S3326C3 ::~S3326C3(){ note_dtor("S3326C3", this);}
void  S3326C3 ::v5(){vfunc_called(this, "_ZN7S3326C32v5Ev");}
void  S3326C3 ::v6(){vfunc_called(this, "_ZN7S3326C32v6Ev");}
void  S3326C3 ::v7(){vfunc_called(this, "_ZN7S3326C32v7Ev");}
void  S3326C3 ::v8(){vfunc_called(this, "_ZN7S3326C32v8Ev");}
void  S3326C3 ::v9(){vfunc_called(this, "_ZN7S3326C32v9Ev");}
void  S3326C3 ::v10(){vfunc_called(this, "_ZN7S3326C33v10Ev");}
void  S3326C3 ::v11(){vfunc_called(this, "_ZN7S3326C33v11Ev");}
void  S3326C3 ::v12(){vfunc_called(this, "_ZN7S3326C33v12Ev");}
void  S3326C3 ::v13(){vfunc_called(this, "_ZN7S3326C33v13Ev");}
void  S3326C3 ::v14(){vfunc_called(this, "_ZN7S3326C33v14Ev");}
S3326C3 ::S3326C3(){ note_ctor("S3326C3", this);} // tgen

static void Test_S3326C3()
{
  extern Class_Descriptor cd_S3326C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S3326C3, buf);
    S3326C3 *dp, &lv = *(dp=new (buf) S3326C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S3326C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3326C3)");
    check_field_offset(lv, s3326c3f0, ABISELECT(8,4), "S3326C3.s3326c3f0");
    check_field_offset(lv, s3326c3f1, ABISELECT(24,12), "S3326C3.s3326c3f1");
    check_field_offset(lv, s3326c3f2, ABISELECT(48,28), "S3326C3.s3326c3f2");
    test_class_info(&lv, &cd_S3326C3);
    dp->~S3326C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3326C3(Test_S3326C3, "S3326C3", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S3326C3C1Ev();
extern void _ZN7S3326C3D1Ev();
Name_Map name_map_S3326C3[] = {
  NSPAIR(_ZN7S3326C3C1Ev),
  NSPAIR(_ZN7S3326C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3326C3[];
extern void _ZN7S3326C3D1Ev();
extern void _ZN7S3326C3D0Ev();
extern void _ZN7S3326C32v5Ev();
extern void _ZN7S3326C32v6Ev();
extern void _ZN7S3326C32v7Ev();
extern void _ZN7S3326C32v8Ev();
extern void _ZN7S3326C32v9Ev();
extern void _ZN7S3326C33v10Ev();
extern void _ZN7S3326C33v11Ev();
extern void _ZN7S3326C33v12Ev();
extern void _ZN7S3326C33v13Ev();
extern void _ZN7S3326C33v14Ev();
static  VTBL_ENTRY vtc_S3326C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3326C3[0]),
  (VTBL_ENTRY)&_ZN7S3326C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3326C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v14Ev,
};
extern VTBL_ENTRY _ZTI7S3326C3[];
extern  VTBL_ENTRY _ZTV7S3326C3[];
Class_Descriptor cd_S3326C3 = {  "S3326C3", // class name
  0,0,//no base classes
  &(vtc_S3326C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S3326C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3326C3),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3326C2  : S3326C3 {
  ::S10103C86 s3326c2f0;
  ::S10103C106 s3326c2f1;
  ::S10103C82_nt s3326c2f2;
  ::S10103C13_nt s3326c2f3;
  virtual  ~S3326C2(); // _ZN7S3326C2D1Ev
  virtual void  v15(); // _ZN7S3326C23v15Ev
  virtual void  v16(); // _ZN7S3326C23v16Ev
  virtual void  v17(); // _ZN7S3326C23v17Ev
  virtual void  v18(); // _ZN7S3326C23v18Ev
  virtual void  v19(); // _ZN7S3326C23v19Ev
  virtual void  v20(); // _ZN7S3326C23v20Ev
  virtual void  v21(); // _ZN7S3326C23v21Ev
  virtual void  v22(); // _ZN7S3326C23v22Ev
  virtual void  v23(); // _ZN7S3326C23v23Ev
  virtual void  v24(); // _ZN7S3326C23v24Ev
  virtual void  v25(); // _ZN7S3326C23v25Ev
  virtual void  v26(); // _ZN7S3326C23v26Ev
  virtual void  v27(); // _ZN7S3326C23v27Ev
  virtual void  v28(); // _ZN7S3326C23v28Ev
  S3326C2(); // tgen
};
//SIG(-1 S3326C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S3326C2 ::~S3326C2(){ note_dtor("S3326C2", this);}
void  S3326C2 ::v15(){vfunc_called(this, "_ZN7S3326C23v15Ev");}
void  S3326C2 ::v16(){vfunc_called(this, "_ZN7S3326C23v16Ev");}
void  S3326C2 ::v17(){vfunc_called(this, "_ZN7S3326C23v17Ev");}
void  S3326C2 ::v18(){vfunc_called(this, "_ZN7S3326C23v18Ev");}
void  S3326C2 ::v19(){vfunc_called(this, "_ZN7S3326C23v19Ev");}
void  S3326C2 ::v20(){vfunc_called(this, "_ZN7S3326C23v20Ev");}
void  S3326C2 ::v21(){vfunc_called(this, "_ZN7S3326C23v21Ev");}
void  S3326C2 ::v22(){vfunc_called(this, "_ZN7S3326C23v22Ev");}
void  S3326C2 ::v23(){vfunc_called(this, "_ZN7S3326C23v23Ev");}
void  S3326C2 ::v24(){vfunc_called(this, "_ZN7S3326C23v24Ev");}
void  S3326C2 ::v25(){vfunc_called(this, "_ZN7S3326C23v25Ev");}
void  S3326C2 ::v26(){vfunc_called(this, "_ZN7S3326C23v26Ev");}
void  S3326C2 ::v27(){vfunc_called(this, "_ZN7S3326C23v27Ev");}
void  S3326C2 ::v28(){vfunc_called(this, "_ZN7S3326C23v28Ev");}
S3326C2 ::S3326C2(){ note_ctor("S3326C2", this);} // tgen

static void Test_S3326C2()
{
  extern Class_Descriptor cd_S3326C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S3326C2, buf);
    S3326C2 *dp, &lv = *(dp=new (buf) S3326C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S3326C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3326C2)");
    check_base_class_offset(lv, (S3326C3*), 0, "S3326C2");
    check_field_offset(lv, s3326c2f0, ABISELECT(56,32), "S3326C2.s3326c2f0");
    check_field_offset(lv, s3326c2f1, ABISELECT(72,44), "S3326C2.s3326c2f1");
    check_field_offset(lv, s3326c2f2, ABISELECT(96,60), "S3326C2.s3326c2f2");
    check_field_offset(lv, s3326c2f3, ABISELECT(112,76), "S3326C2.s3326c2f3");
    test_class_info(&lv, &cd_S3326C2);
    dp->~S3326C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3326C2(Test_S3326C2, "S3326C2", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S3326C2C1Ev();
extern void _ZN7S3326C2D1Ev();
Name_Map name_map_S3326C2[] = {
  NSPAIR(_ZN7S3326C2C1Ev),
  NSPAIR(_ZN7S3326C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3326C3;
extern VTBL_ENTRY _ZTI7S3326C3[];
extern  VTBL_ENTRY _ZTV7S3326C3[];
static Base_Class bases_S3326C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3326C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3326C2[];
extern void _ZN7S3326C2D1Ev();
extern void _ZN7S3326C2D0Ev();
extern void _ZN7S3326C32v5Ev();
extern void _ZN7S3326C32v6Ev();
extern void _ZN7S3326C32v7Ev();
extern void _ZN7S3326C32v8Ev();
extern void _ZN7S3326C32v9Ev();
extern void _ZN7S3326C33v10Ev();
extern void _ZN7S3326C33v11Ev();
extern void _ZN7S3326C33v12Ev();
extern void _ZN7S3326C33v13Ev();
extern void _ZN7S3326C33v14Ev();
extern void _ZN7S3326C23v15Ev();
extern void _ZN7S3326C23v16Ev();
extern void _ZN7S3326C23v17Ev();
extern void _ZN7S3326C23v18Ev();
extern void _ZN7S3326C23v19Ev();
extern void _ZN7S3326C23v20Ev();
extern void _ZN7S3326C23v21Ev();
extern void _ZN7S3326C23v22Ev();
extern void _ZN7S3326C23v23Ev();
extern void _ZN7S3326C23v24Ev();
extern void _ZN7S3326C23v25Ev();
extern void _ZN7S3326C23v26Ev();
extern void _ZN7S3326C23v27Ev();
extern void _ZN7S3326C23v28Ev();
static  VTBL_ENTRY vtc_S3326C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3326C2[0]),
  (VTBL_ENTRY)&_ZN7S3326C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3326C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v28Ev,
};
extern VTBL_ENTRY _ZTI7S3326C2[];
extern  VTBL_ENTRY _ZTV7S3326C2[];
Class_Descriptor cd_S3326C2 = {  "S3326C2", // class name
  bases_S3326C2, 1,
  &(vtc_S3326C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S3326C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3326C2),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3326C1  : S3326C2 {
  int s3326c1f0[2];
  ::S10103C84 s3326c1f1[2];
  virtual  ~S3326C1(); // _ZN7S3326C1D1Ev
  virtual void  v1(); // _ZN7S3326C12v1Ev
  virtual void  v2(); // _ZN7S3326C12v2Ev
  virtual void  v3(); // _ZN7S3326C12v3Ev
  virtual void  v4(); // _ZN7S3326C12v4Ev
  S3326C1(); // tgen
};
//SIG(1 S3326C1) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 v2 v3 v4 Fi[2] FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]}[2]}


 S3326C1 ::~S3326C1(){ note_dtor("S3326C1", this);}
void  S3326C1 ::v1(){vfunc_called(this, "_ZN7S3326C12v1Ev");}
void  S3326C1 ::v2(){vfunc_called(this, "_ZN7S3326C12v2Ev");}
void  S3326C1 ::v3(){vfunc_called(this, "_ZN7S3326C12v3Ev");}
void  S3326C1 ::v4(){vfunc_called(this, "_ZN7S3326C12v4Ev");}
S3326C1 ::S3326C1(){ note_ctor("S3326C1", this);} // tgen

static void Test_S3326C1()
{
  extern Class_Descriptor cd_S3326C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(93,138)];
    init_test(&cd_S3326C1, buf);
    S3326C1 *dp, &lv = *(dp=new (buf) S3326C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(736,548), "sizeof(S3326C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3326C1)");
    check_base_class_offset(lv, (S3326C3*)(S3326C2*), 0, "S3326C1");
    check_base_class_offset(lv, (S3326C2*), 0, "S3326C1");
    check_field_offset(lv, s3326c1f0, ABISELECT(136,92), "S3326C1.s3326c1f0");
    check_field_offset(lv, s3326c1f1, ABISELECT(144,100), "S3326C1.s3326c1f1");
    test_class_info(&lv, &cd_S3326C1);
    dp->~S3326C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3326C1(Test_S3326C1, "S3326C1", ABISELECT(736,548));

#else // __cplusplus

extern void _ZN7S3326C1C1Ev();
extern void _ZN7S3326C1D1Ev();
Name_Map name_map_S3326C1[] = {
  NSPAIR(_ZN7S3326C1C1Ev),
  NSPAIR(_ZN7S3326C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3326C3;
extern VTBL_ENTRY _ZTI7S3326C3[];
extern  VTBL_ENTRY _ZTV7S3326C3[];
extern Class_Descriptor cd_S3326C2;
extern VTBL_ENTRY _ZTI7S3326C2[];
extern  VTBL_ENTRY _ZTV7S3326C2[];
static Base_Class bases_S3326C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3326C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3326C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3326C1[];
extern void _ZN7S3326C1D1Ev();
extern void _ZN7S3326C1D0Ev();
extern void _ZN7S3326C32v5Ev();
extern void _ZN7S3326C32v6Ev();
extern void _ZN7S3326C32v7Ev();
extern void _ZN7S3326C32v8Ev();
extern void _ZN7S3326C32v9Ev();
extern void _ZN7S3326C33v10Ev();
extern void _ZN7S3326C33v11Ev();
extern void _ZN7S3326C33v12Ev();
extern void _ZN7S3326C33v13Ev();
extern void _ZN7S3326C33v14Ev();
extern void _ZN7S3326C23v15Ev();
extern void _ZN7S3326C23v16Ev();
extern void _ZN7S3326C23v17Ev();
extern void _ZN7S3326C23v18Ev();
extern void _ZN7S3326C23v19Ev();
extern void _ZN7S3326C23v20Ev();
extern void _ZN7S3326C23v21Ev();
extern void _ZN7S3326C23v22Ev();
extern void _ZN7S3326C23v23Ev();
extern void _ZN7S3326C23v24Ev();
extern void _ZN7S3326C23v25Ev();
extern void _ZN7S3326C23v26Ev();
extern void _ZN7S3326C23v27Ev();
extern void _ZN7S3326C23v28Ev();
extern void _ZN7S3326C12v1Ev();
extern void _ZN7S3326C12v2Ev();
extern void _ZN7S3326C12v3Ev();
extern void _ZN7S3326C12v4Ev();
static  VTBL_ENTRY vtc_S3326C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3326C1[0]),
  (VTBL_ENTRY)&_ZN7S3326C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3326C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3326C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3326C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3326C23v28Ev,
  (VTBL_ENTRY)&_ZN7S3326C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3326C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3326C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3326C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S3326C1[];
extern  VTBL_ENTRY _ZTV7S3326C1[];
Class_Descriptor cd_S3326C1 = {  "S3326C1", // class name
  bases_S3326C1, 2,
  &(vtc_S3326C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(736,548), // object size
  NSPAIRA(_ZTI7S3326C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3326C1),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3330C3  {
  void *s3330c3f0[2];
  ::S10103C13_nt s3330c3f1;
  void *s3330c3f2;
  virtual  ~S3330C3(); // _ZN7S3330C3D1Ev
  virtual void  v5(); // _ZN7S3330C32v5Ev
  virtual void  v6(); // _ZN7S3330C32v6Ev
  virtual void  v7(); // _ZN7S3330C32v7Ev
  virtual void  v8(); // _ZN7S3330C32v8Ev
  virtual void  v9(); // _ZN7S3330C32v9Ev
  virtual void  v10(); // _ZN7S3330C33v10Ev
  virtual void  v11(); // _ZN7S3330C33v11Ev
  virtual void  v12(); // _ZN7S3330C33v12Ev
  virtual void  v13(); // _ZN7S3330C33v13Ev
  virtual void  v14(); // _ZN7S3330C33v14Ev
  S3330C3(); // tgen
};
//SIG(-1 S3330C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S3330C3 ::~S3330C3(){ note_dtor("S3330C3", this);}
void  S3330C3 ::v5(){vfunc_called(this, "_ZN7S3330C32v5Ev");}
void  S3330C3 ::v6(){vfunc_called(this, "_ZN7S3330C32v6Ev");}
void  S3330C3 ::v7(){vfunc_called(this, "_ZN7S3330C32v7Ev");}
void  S3330C3 ::v8(){vfunc_called(this, "_ZN7S3330C32v8Ev");}
void  S3330C3 ::v9(){vfunc_called(this, "_ZN7S3330C32v9Ev");}
void  S3330C3 ::v10(){vfunc_called(this, "_ZN7S3330C33v10Ev");}
void  S3330C3 ::v11(){vfunc_called(this, "_ZN7S3330C33v11Ev");}
void  S3330C3 ::v12(){vfunc_called(this, "_ZN7S3330C33v12Ev");}
void  S3330C3 ::v13(){vfunc_called(this, "_ZN7S3330C33v13Ev");}
void  S3330C3 ::v14(){vfunc_called(this, "_ZN7S3330C33v14Ev");}
S3330C3 ::S3330C3(){ note_ctor("S3330C3", this);} // tgen

static void Test_S3330C3()
{
  extern Class_Descriptor cd_S3330C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S3330C3, buf);
    S3330C3 *dp, &lv = *(dp=new (buf) S3330C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S3330C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3330C3)");
    check_field_offset(lv, s3330c3f0, ABISELECT(8,4), "S3330C3.s3330c3f0");
    check_field_offset(lv, s3330c3f1, ABISELECT(24,12), "S3330C3.s3330c3f1");
    check_field_offset(lv, s3330c3f2, ABISELECT(48,28), "S3330C3.s3330c3f2");
    test_class_info(&lv, &cd_S3330C3);
    dp->~S3330C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3330C3(Test_S3330C3, "S3330C3", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S3330C3C1Ev();
extern void _ZN7S3330C3D1Ev();
Name_Map name_map_S3330C3[] = {
  NSPAIR(_ZN7S3330C3C1Ev),
  NSPAIR(_ZN7S3330C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3330C3[];
extern void _ZN7S3330C3D1Ev();
extern void _ZN7S3330C3D0Ev();
extern void _ZN7S3330C32v5Ev();
extern void _ZN7S3330C32v6Ev();
extern void _ZN7S3330C32v7Ev();
extern void _ZN7S3330C32v8Ev();
extern void _ZN7S3330C32v9Ev();
extern void _ZN7S3330C33v10Ev();
extern void _ZN7S3330C33v11Ev();
extern void _ZN7S3330C33v12Ev();
extern void _ZN7S3330C33v13Ev();
extern void _ZN7S3330C33v14Ev();
static  VTBL_ENTRY vtc_S3330C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3330C3[0]),
  (VTBL_ENTRY)&_ZN7S3330C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3330C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v14Ev,
};
extern VTBL_ENTRY _ZTI7S3330C3[];
extern  VTBL_ENTRY _ZTV7S3330C3[];
Class_Descriptor cd_S3330C3 = {  "S3330C3", // class name
  0,0,//no base classes
  &(vtc_S3330C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S3330C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3330C3),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3330C2  : S3330C3 {
  ::S10103C86 s3330c2f0;
  ::S10103C106 s3330c2f1;
  ::S10103C82_nt s3330c2f2;
  ::S10103C13_nt s3330c2f3;
  virtual  ~S3330C2(); // _ZN7S3330C2D1Ev
  virtual void  v15(); // _ZN7S3330C23v15Ev
  virtual void  v16(); // _ZN7S3330C23v16Ev
  virtual void  v17(); // _ZN7S3330C23v17Ev
  virtual void  v18(); // _ZN7S3330C23v18Ev
  virtual void  v19(); // _ZN7S3330C23v19Ev
  virtual void  v20(); // _ZN7S3330C23v20Ev
  virtual void  v21(); // _ZN7S3330C23v21Ev
  virtual void  v22(); // _ZN7S3330C23v22Ev
  virtual void  v23(); // _ZN7S3330C23v23Ev
  virtual void  v24(); // _ZN7S3330C23v24Ev
  virtual void  v25(); // _ZN7S3330C23v25Ev
  virtual void  v26(); // _ZN7S3330C23v26Ev
  virtual void  v27(); // _ZN7S3330C23v27Ev
  virtual void  v28(); // _ZN7S3330C23v28Ev
  S3330C2(); // tgen
};
//SIG(-1 S3330C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S3330C2 ::~S3330C2(){ note_dtor("S3330C2", this);}
void  S3330C2 ::v15(){vfunc_called(this, "_ZN7S3330C23v15Ev");}
void  S3330C2 ::v16(){vfunc_called(this, "_ZN7S3330C23v16Ev");}
void  S3330C2 ::v17(){vfunc_called(this, "_ZN7S3330C23v17Ev");}
void  S3330C2 ::v18(){vfunc_called(this, "_ZN7S3330C23v18Ev");}
void  S3330C2 ::v19(){vfunc_called(this, "_ZN7S3330C23v19Ev");}
void  S3330C2 ::v20(){vfunc_called(this, "_ZN7S3330C23v20Ev");}
void  S3330C2 ::v21(){vfunc_called(this, "_ZN7S3330C23v21Ev");}
void  S3330C2 ::v22(){vfunc_called(this, "_ZN7S3330C23v22Ev");}
void  S3330C2 ::v23(){vfunc_called(this, "_ZN7S3330C23v23Ev");}
void  S3330C2 ::v24(){vfunc_called(this, "_ZN7S3330C23v24Ev");}
void  S3330C2 ::v25(){vfunc_called(this, "_ZN7S3330C23v25Ev");}
void  S3330C2 ::v26(){vfunc_called(this, "_ZN7S3330C23v26Ev");}
void  S3330C2 ::v27(){vfunc_called(this, "_ZN7S3330C23v27Ev");}
void  S3330C2 ::v28(){vfunc_called(this, "_ZN7S3330C23v28Ev");}
S3330C2 ::S3330C2(){ note_ctor("S3330C2", this);} // tgen

static void Test_S3330C2()
{
  extern Class_Descriptor cd_S3330C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S3330C2, buf);
    S3330C2 *dp, &lv = *(dp=new (buf) S3330C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S3330C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3330C2)");
    check_base_class_offset(lv, (S3330C3*), 0, "S3330C2");
    check_field_offset(lv, s3330c2f0, ABISELECT(56,32), "S3330C2.s3330c2f0");
    check_field_offset(lv, s3330c2f1, ABISELECT(72,44), "S3330C2.s3330c2f1");
    check_field_offset(lv, s3330c2f2, ABISELECT(96,60), "S3330C2.s3330c2f2");
    check_field_offset(lv, s3330c2f3, ABISELECT(112,76), "S3330C2.s3330c2f3");
    test_class_info(&lv, &cd_S3330C2);
    dp->~S3330C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3330C2(Test_S3330C2, "S3330C2", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S3330C2C1Ev();
extern void _ZN7S3330C2D1Ev();
Name_Map name_map_S3330C2[] = {
  NSPAIR(_ZN7S3330C2C1Ev),
  NSPAIR(_ZN7S3330C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3330C3;
extern VTBL_ENTRY _ZTI7S3330C3[];
extern  VTBL_ENTRY _ZTV7S3330C3[];
static Base_Class bases_S3330C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3330C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3330C2[];
extern void _ZN7S3330C2D1Ev();
extern void _ZN7S3330C2D0Ev();
extern void _ZN7S3330C32v5Ev();
extern void _ZN7S3330C32v6Ev();
extern void _ZN7S3330C32v7Ev();
extern void _ZN7S3330C32v8Ev();
extern void _ZN7S3330C32v9Ev();
extern void _ZN7S3330C33v10Ev();
extern void _ZN7S3330C33v11Ev();
extern void _ZN7S3330C33v12Ev();
extern void _ZN7S3330C33v13Ev();
extern void _ZN7S3330C33v14Ev();
extern void _ZN7S3330C23v15Ev();
extern void _ZN7S3330C23v16Ev();
extern void _ZN7S3330C23v17Ev();
extern void _ZN7S3330C23v18Ev();
extern void _ZN7S3330C23v19Ev();
extern void _ZN7S3330C23v20Ev();
extern void _ZN7S3330C23v21Ev();
extern void _ZN7S3330C23v22Ev();
extern void _ZN7S3330C23v23Ev();
extern void _ZN7S3330C23v24Ev();
extern void _ZN7S3330C23v25Ev();
extern void _ZN7S3330C23v26Ev();
extern void _ZN7S3330C23v27Ev();
extern void _ZN7S3330C23v28Ev();
static  VTBL_ENTRY vtc_S3330C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3330C2[0]),
  (VTBL_ENTRY)&_ZN7S3330C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3330C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v28Ev,
};
extern VTBL_ENTRY _ZTI7S3330C2[];
extern  VTBL_ENTRY _ZTV7S3330C2[];
Class_Descriptor cd_S3330C2 = {  "S3330C2", // class name
  bases_S3330C2, 1,
  &(vtc_S3330C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S3330C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3330C2),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3330C1  : S3330C2 {
  int s3330c1f0[6];
  ::S10103C84 s3330c1f1[2];
  virtual  ~S3330C1(); // _ZN7S3330C1D1Ev
  virtual void  v1(); // _ZN7S3330C12v1Ev
  virtual void  v2(); // _ZN7S3330C12v2Ev
  virtual void  v3(); // _ZN7S3330C12v3Ev
  virtual void  v4(); // _ZN7S3330C12v4Ev
  S3330C1(); // tgen
};
//SIG(1 S3330C1) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 v2 v3 v4 Fi[6] FC13{ BC14{ BC15{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 Fp[2] FC4 Fp} vd v43 v44 v45 v46 v47 v48 Fp Fi FC7 FC11 Fi} vd v29 v30 v31 v32 FC4[4] FC11 FC11 FC11 FC11 Fi[6]}[2]}


 S3330C1 ::~S3330C1(){ note_dtor("S3330C1", this);}
void  S3330C1 ::v1(){vfunc_called(this, "_ZN7S3330C12v1Ev");}
void  S3330C1 ::v2(){vfunc_called(this, "_ZN7S3330C12v2Ev");}
void  S3330C1 ::v3(){vfunc_called(this, "_ZN7S3330C12v3Ev");}
void  S3330C1 ::v4(){vfunc_called(this, "_ZN7S3330C12v4Ev");}
S3330C1 ::S3330C1(){ note_ctor("S3330C1", this);} // tgen

static void Test_S3330C1()
{
  extern Class_Descriptor cd_S3330C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(95,142)];
    init_test(&cd_S3330C1, buf);
    S3330C1 *dp, &lv = *(dp=new (buf) S3330C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(752,564), "sizeof(S3330C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3330C1)");
    check_base_class_offset(lv, (S3330C3*)(S3330C2*), 0, "S3330C1");
    check_base_class_offset(lv, (S3330C2*), 0, "S3330C1");
    check_field_offset(lv, s3330c1f0, ABISELECT(136,92), "S3330C1.s3330c1f0");
    check_field_offset(lv, s3330c1f1, ABISELECT(160,116), "S3330C1.s3330c1f1");
    test_class_info(&lv, &cd_S3330C1);
    dp->~S3330C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3330C1(Test_S3330C1, "S3330C1", ABISELECT(752,564));

#else // __cplusplus

extern void _ZN7S3330C1C1Ev();
extern void _ZN7S3330C1D1Ev();
Name_Map name_map_S3330C1[] = {
  NSPAIR(_ZN7S3330C1C1Ev),
  NSPAIR(_ZN7S3330C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3330C3;
extern VTBL_ENTRY _ZTI7S3330C3[];
extern  VTBL_ENTRY _ZTV7S3330C3[];
extern Class_Descriptor cd_S3330C2;
extern VTBL_ENTRY _ZTI7S3330C2[];
extern  VTBL_ENTRY _ZTV7S3330C2[];
static Base_Class bases_S3330C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3330C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3330C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3330C1[];
extern void _ZN7S3330C1D1Ev();
extern void _ZN7S3330C1D0Ev();
extern void _ZN7S3330C32v5Ev();
extern void _ZN7S3330C32v6Ev();
extern void _ZN7S3330C32v7Ev();
extern void _ZN7S3330C32v8Ev();
extern void _ZN7S3330C32v9Ev();
extern void _ZN7S3330C33v10Ev();
extern void _ZN7S3330C33v11Ev();
extern void _ZN7S3330C33v12Ev();
extern void _ZN7S3330C33v13Ev();
extern void _ZN7S3330C33v14Ev();
extern void _ZN7S3330C23v15Ev();
extern void _ZN7S3330C23v16Ev();
extern void _ZN7S3330C23v17Ev();
extern void _ZN7S3330C23v18Ev();
extern void _ZN7S3330C23v19Ev();
extern void _ZN7S3330C23v20Ev();
extern void _ZN7S3330C23v21Ev();
extern void _ZN7S3330C23v22Ev();
extern void _ZN7S3330C23v23Ev();
extern void _ZN7S3330C23v24Ev();
extern void _ZN7S3330C23v25Ev();
extern void _ZN7S3330C23v26Ev();
extern void _ZN7S3330C23v27Ev();
extern void _ZN7S3330C23v28Ev();
extern void _ZN7S3330C12v1Ev();
extern void _ZN7S3330C12v2Ev();
extern void _ZN7S3330C12v3Ev();
extern void _ZN7S3330C12v4Ev();
static  VTBL_ENTRY vtc_S3330C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3330C1[0]),
  (VTBL_ENTRY)&_ZN7S3330C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3330C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v5Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v6Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v7Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v8Ev,
  (VTBL_ENTRY)&_ZN7S3330C32v9Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3330C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v25Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v27Ev,
  (VTBL_ENTRY)&_ZN7S3330C23v28Ev,
  (VTBL_ENTRY)&_ZN7S3330C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3330C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3330C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3330C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S3330C1[];
extern  VTBL_ENTRY _ZTV7S3330C1[];
Class_Descriptor cd_S3330C1 = {  "S3330C1", // class name
  bases_S3330C1, 2,
  &(vtc_S3330C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(752,564), // object size
  NSPAIRA(_ZTI7S3330C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3330C1),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1386C4  {
  void *s1386c4f0[2];
  ::S10103C13_nt s1386c4f1;
  void *s1386c4f2;
  virtual  ~S1386C4(); // _ZN7S1386C4D1Ev
  virtual void  v3(); // _ZN7S1386C42v3Ev
  virtual void  v4(); // _ZN7S1386C42v4Ev
  virtual void  v5(); // _ZN7S1386C42v5Ev
  virtual void  v6(); // _ZN7S1386C42v6Ev
  virtual void  v7(); // _ZN7S1386C42v7Ev
  virtual void  v8(); // _ZN7S1386C42v8Ev
  virtual void  v9(); // _ZN7S1386C42v9Ev
  virtual void  v10(); // _ZN7S1386C43v10Ev
  virtual void  v11(); // _ZN7S1386C43v11Ev
  virtual void  v12(); // _ZN7S1386C43v12Ev
  S1386C4(); // tgen
};
//SIG(-1 S1386C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1386C4 ::~S1386C4(){ note_dtor("S1386C4", this);}
void  S1386C4 ::v3(){vfunc_called(this, "_ZN7S1386C42v3Ev");}
void  S1386C4 ::v4(){vfunc_called(this, "_ZN7S1386C42v4Ev");}
void  S1386C4 ::v5(){vfunc_called(this, "_ZN7S1386C42v5Ev");}
void  S1386C4 ::v6(){vfunc_called(this, "_ZN7S1386C42v6Ev");}
void  S1386C4 ::v7(){vfunc_called(this, "_ZN7S1386C42v7Ev");}
void  S1386C4 ::v8(){vfunc_called(this, "_ZN7S1386C42v8Ev");}
void  S1386C4 ::v9(){vfunc_called(this, "_ZN7S1386C42v9Ev");}
void  S1386C4 ::v10(){vfunc_called(this, "_ZN7S1386C43v10Ev");}
void  S1386C4 ::v11(){vfunc_called(this, "_ZN7S1386C43v11Ev");}
void  S1386C4 ::v12(){vfunc_called(this, "_ZN7S1386C43v12Ev");}
S1386C4 ::S1386C4(){ note_ctor("S1386C4", this);} // tgen

static void Test_S1386C4()
{
  extern Class_Descriptor cd_S1386C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1386C4, buf);
    S1386C4 *dp, &lv = *(dp=new (buf) S1386C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1386C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1386C4)");
    check_field_offset(lv, s1386c4f0, ABISELECT(8,4), "S1386C4.s1386c4f0");
    check_field_offset(lv, s1386c4f1, ABISELECT(24,12), "S1386C4.s1386c4f1");
    check_field_offset(lv, s1386c4f2, ABISELECT(48,28), "S1386C4.s1386c4f2");
    test_class_info(&lv, &cd_S1386C4);
    dp->~S1386C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1386C4(Test_S1386C4, "S1386C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1386C4C1Ev();
extern void _ZN7S1386C4D1Ev();
Name_Map name_map_S1386C4[] = {
  NSPAIR(_ZN7S1386C4C1Ev),
  NSPAIR(_ZN7S1386C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1386C4[];
extern void _ZN7S1386C4D1Ev();
extern void _ZN7S1386C4D0Ev();
extern void _ZN7S1386C42v3Ev();
extern void _ZN7S1386C42v4Ev();
extern void _ZN7S1386C42v5Ev();
extern void _ZN7S1386C42v6Ev();
extern void _ZN7S1386C42v7Ev();
extern void _ZN7S1386C42v8Ev();
extern void _ZN7S1386C42v9Ev();
extern void _ZN7S1386C43v10Ev();
extern void _ZN7S1386C43v11Ev();
extern void _ZN7S1386C43v12Ev();
static  VTBL_ENTRY vtc_S1386C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1386C4[0]),
  (VTBL_ENTRY)&_ZN7S1386C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1386C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S1386C4[];
extern  VTBL_ENTRY _ZTV7S1386C4[];
Class_Descriptor cd_S1386C4 = {  "S1386C4", // class name
  0,0,//no base classes
  &(vtc_S1386C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1386C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1386C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1386C3  : S1386C4 {
  ::S10103C86 s1386c3f0;
  ::S10103C106 s1386c3f1;
  ::S10103C82_nt s1386c3f2;
  ::S10103C13_nt s1386c3f3;
  virtual  ~S1386C3(); // _ZN7S1386C3D1Ev
  virtual void  v13(); // _ZN7S1386C33v13Ev
  virtual void  v14(); // _ZN7S1386C33v14Ev
  virtual void  v15(); // _ZN7S1386C33v15Ev
  virtual void  v16(); // _ZN7S1386C33v16Ev
  virtual void  v17(); // _ZN7S1386C33v17Ev
  virtual void  v18(); // _ZN7S1386C33v18Ev
  virtual void  v19(); // _ZN7S1386C33v19Ev
  virtual void  v20(); // _ZN7S1386C33v20Ev
  virtual void  v21(); // _ZN7S1386C33v21Ev
  virtual void  v22(); // _ZN7S1386C33v22Ev
  virtual void  v23(); // _ZN7S1386C33v23Ev
  virtual void  v24(); // _ZN7S1386C33v24Ev
  virtual void  v25(); // _ZN7S1386C33v25Ev
  virtual void  v26(); // _ZN7S1386C33v26Ev
  S1386C3(); // tgen
};
//SIG(-1 S1386C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1386C3 ::~S1386C3(){ note_dtor("S1386C3", this);}
void  S1386C3 ::v13(){vfunc_called(this, "_ZN7S1386C33v13Ev");}
void  S1386C3 ::v14(){vfunc_called(this, "_ZN7S1386C33v14Ev");}
void  S1386C3 ::v15(){vfunc_called(this, "_ZN7S1386C33v15Ev");}
void  S1386C3 ::v16(){vfunc_called(this, "_ZN7S1386C33v16Ev");}
void  S1386C3 ::v17(){vfunc_called(this, "_ZN7S1386C33v17Ev");}
void  S1386C3 ::v18(){vfunc_called(this, "_ZN7S1386C33v18Ev");}
void  S1386C3 ::v19(){vfunc_called(this, "_ZN7S1386C33v19Ev");}
void  S1386C3 ::v20(){vfunc_called(this, "_ZN7S1386C33v20Ev");}
void  S1386C3 ::v21(){vfunc_called(this, "_ZN7S1386C33v21Ev");}
void  S1386C3 ::v22(){vfunc_called(this, "_ZN7S1386C33v22Ev");}
void  S1386C3 ::v23(){vfunc_called(this, "_ZN7S1386C33v23Ev");}
void  S1386C3 ::v24(){vfunc_called(this, "_ZN7S1386C33v24Ev");}
void  S1386C3 ::v25(){vfunc_called(this, "_ZN7S1386C33v25Ev");}
void  S1386C3 ::v26(){vfunc_called(this, "_ZN7S1386C33v26Ev");}
S1386C3 ::S1386C3(){ note_ctor("S1386C3", this);} // tgen

static void Test_S1386C3()
{
  extern Class_Descriptor cd_S1386C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1386C3, buf);
    S1386C3 *dp, &lv = *(dp=new (buf) S1386C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1386C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1386C3)");
    check_base_class_offset(lv, (S1386C4*), 0, "S1386C3");
    check_field_offset(lv, s1386c3f0, ABISELECT(56,32), "S1386C3.s1386c3f0");
    check_field_offset(lv, s1386c3f1, ABISELECT(72,44), "S1386C3.s1386c3f1");
    check_field_offset(lv, s1386c3f2, ABISELECT(96,60), "S1386C3.s1386c3f2");
    check_field_offset(lv, s1386c3f3, ABISELECT(112,76), "S1386C3.s1386c3f3");
    test_class_info(&lv, &cd_S1386C3);
    dp->~S1386C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1386C3(Test_S1386C3, "S1386C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1386C3C1Ev();
extern void _ZN7S1386C3D1Ev();
Name_Map name_map_S1386C3[] = {
  NSPAIR(_ZN7S1386C3C1Ev),
  NSPAIR(_ZN7S1386C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1386C4;
extern VTBL_ENTRY _ZTI7S1386C4[];
extern  VTBL_ENTRY _ZTV7S1386C4[];
static Base_Class bases_S1386C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1386C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1386C3[];
extern void _ZN7S1386C3D1Ev();
extern void _ZN7S1386C3D0Ev();
extern void _ZN7S1386C42v3Ev();
extern void _ZN7S1386C42v4Ev();
extern void _ZN7S1386C42v5Ev();
extern void _ZN7S1386C42v6Ev();
extern void _ZN7S1386C42v7Ev();
extern void _ZN7S1386C42v8Ev();
extern void _ZN7S1386C42v9Ev();
extern void _ZN7S1386C43v10Ev();
extern void _ZN7S1386C43v11Ev();
extern void _ZN7S1386C43v12Ev();
extern void _ZN7S1386C33v13Ev();
extern void _ZN7S1386C33v14Ev();
extern void _ZN7S1386C33v15Ev();
extern void _ZN7S1386C33v16Ev();
extern void _ZN7S1386C33v17Ev();
extern void _ZN7S1386C33v18Ev();
extern void _ZN7S1386C33v19Ev();
extern void _ZN7S1386C33v20Ev();
extern void _ZN7S1386C33v21Ev();
extern void _ZN7S1386C33v22Ev();
extern void _ZN7S1386C33v23Ev();
extern void _ZN7S1386C33v24Ev();
extern void _ZN7S1386C33v25Ev();
extern void _ZN7S1386C33v26Ev();
static  VTBL_ENTRY vtc_S1386C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1386C3[0]),
  (VTBL_ENTRY)&_ZN7S1386C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1386C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v26Ev,
};
extern VTBL_ENTRY _ZTI7S1386C3[];
extern  VTBL_ENTRY _ZTV7S1386C3[];
Class_Descriptor cd_S1386C3 = {  "S1386C3", // class name
  bases_S1386C3, 1,
  &(vtc_S1386C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1386C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1386C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1386C2  : S1386C3 {
  ::S10103C84 s1386c2f0;
  virtual  ~S1386C2(); // _ZN7S1386C2D1Ev
  virtual void  v27(); // _ZN7S1386C23v27Ev
  S1386C2(); // tgen
};
//SIG(-1 S1386C2) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} vd v1 FC13{ BC14{ BC15{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp[2] FC4 Fp} vd v40 v41 v42 v43 v44 v45 Fp Fi FC7 FC11 Fi} vd v26 v27 v28 v29 FC4[4] FC11 FC11 FC11 FC11 Fi[6]}}


 S1386C2 ::~S1386C2(){ note_dtor("S1386C2", this);}
void  S1386C2 ::v27(){vfunc_called(this, "_ZN7S1386C23v27Ev");}
S1386C2 ::S1386C2(){ note_ctor("S1386C2", this);} // tgen

static void Test_S1386C2()
{
  extern Class_Descriptor cd_S1386C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,80)];
    init_test(&cd_S1386C2, buf);
    S1386C2 *dp, &lv = *(dp=new (buf) S1386C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,316), "sizeof(S1386C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1386C2)");
    check_base_class_offset(lv, (S1386C4*)(S1386C3*), 0, "S1386C2");
    check_base_class_offset(lv, (S1386C3*), 0, "S1386C2");
    check_field_offset(lv, s1386c2f0, ABISELECT(136,92), "S1386C2.s1386c2f0");
    test_class_info(&lv, &cd_S1386C2);
    dp->~S1386C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1386C2(Test_S1386C2, "S1386C2", ABISELECT(432,316));

#else // __cplusplus

extern void _ZN7S1386C2C1Ev();
extern void _ZN7S1386C2D1Ev();
Name_Map name_map_S1386C2[] = {
  NSPAIR(_ZN7S1386C2C1Ev),
  NSPAIR(_ZN7S1386C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1386C4;
extern VTBL_ENTRY _ZTI7S1386C4[];
extern  VTBL_ENTRY _ZTV7S1386C4[];
extern Class_Descriptor cd_S1386C3;
extern VTBL_ENTRY _ZTI7S1386C3[];
extern  VTBL_ENTRY _ZTV7S1386C3[];
static Base_Class bases_S1386C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1386C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1386C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1386C2[];
extern void _ZN7S1386C2D1Ev();
extern void _ZN7S1386C2D0Ev();
extern void _ZN7S1386C42v3Ev();
extern void _ZN7S1386C42v4Ev();
extern void _ZN7S1386C42v5Ev();
extern void _ZN7S1386C42v6Ev();
extern void _ZN7S1386C42v7Ev();
extern void _ZN7S1386C42v8Ev();
extern void _ZN7S1386C42v9Ev();
extern void _ZN7S1386C43v10Ev();
extern void _ZN7S1386C43v11Ev();
extern void _ZN7S1386C43v12Ev();
extern void _ZN7S1386C33v13Ev();
extern void _ZN7S1386C33v14Ev();
extern void _ZN7S1386C33v15Ev();
extern void _ZN7S1386C33v16Ev();
extern void _ZN7S1386C33v17Ev();
extern void _ZN7S1386C33v18Ev();
extern void _ZN7S1386C33v19Ev();
extern void _ZN7S1386C33v20Ev();
extern void _ZN7S1386C33v21Ev();
extern void _ZN7S1386C33v22Ev();
extern void _ZN7S1386C33v23Ev();
extern void _ZN7S1386C33v24Ev();
extern void _ZN7S1386C33v25Ev();
extern void _ZN7S1386C33v26Ev();
extern void _ZN7S1386C23v27Ev();
static  VTBL_ENTRY vtc_S1386C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1386C2[0]),
  (VTBL_ENTRY)&_ZN7S1386C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1386C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1386C23v27Ev,
};
extern VTBL_ENTRY _ZTI7S1386C2[];
extern  VTBL_ENTRY _ZTV7S1386C2[];
Class_Descriptor cd_S1386C2 = {  "S1386C2", // class name
  bases_S1386C2, 2,
  &(vtc_S1386C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,316), // object size
  NSPAIRA(_ZTI7S1386C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1386C2),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1386C1  : S1386C2 {
  ::S10103C84 s1386c1f0;
  virtual void  v1(); // _ZN7S1386C12v1Ev
  virtual void  v2(); // _ZN7S1386C12v2Ev
  ~S1386C1(); // tgen
  S1386C1(); // tgen
};
//SIG(1 S1386C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} vd v27 FC14{ BC15{ BC16{ vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[2] FC5 Fp} vd v42 v43 v44 v45 v46 v47 Fp Fi FC8 FC12 Fi} vd v28 v29 v30 v31 FC5[4] FC12 FC12 FC12 FC12 Fi[6]}} v1 v2 FC14}


void  S1386C1 ::v1(){vfunc_called(this, "_ZN7S1386C12v1Ev");}
void  S1386C1 ::v2(){vfunc_called(this, "_ZN7S1386C12v2Ev");}
S1386C1 ::~S1386C1(){ note_dtor("S1386C1", this);} // tgen
S1386C1 ::S1386C1(){ note_ctor("S1386C1", this);} // tgen

static void Test_S1386C1()
{
  extern Class_Descriptor cd_S1386C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(92,136)];
    init_test(&cd_S1386C1, buf);
    S1386C1 *dp, &lv = *(dp=new (buf) S1386C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(728,540), "sizeof(S1386C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1386C1)");
    check_base_class_offset(lv, (S1386C4*)(S1386C3*)(S1386C2*), 0, "S1386C1");
    check_base_class_offset(lv, (S1386C3*)(S1386C2*), 0, "S1386C1");
    check_base_class_offset(lv, (S1386C2*), 0, "S1386C1");
    check_field_offset(lv, s1386c1f0, ABISELECT(432,316), "S1386C1.s1386c1f0");
    test_class_info(&lv, &cd_S1386C1);
    dp->~S1386C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1386C1(Test_S1386C1, "S1386C1", ABISELECT(728,540));

#else // __cplusplus

extern void _ZN7S1386C1C1Ev();
extern void _ZN7S1386C1D1Ev();
Name_Map name_map_S1386C1[] = {
  NSPAIR(_ZN7S1386C1C1Ev),
  NSPAIR(_ZN7S1386C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1386C4;
extern VTBL_ENTRY _ZTI7S1386C4[];
extern  VTBL_ENTRY _ZTV7S1386C4[];
extern Class_Descriptor cd_S1386C3;
extern VTBL_ENTRY _ZTI7S1386C3[];
extern  VTBL_ENTRY _ZTV7S1386C3[];
extern Class_Descriptor cd_S1386C2;
extern VTBL_ENTRY _ZTI7S1386C2[];
extern  VTBL_ENTRY _ZTV7S1386C2[];
static Base_Class bases_S1386C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1386C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1386C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1386C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1386C1[];
extern void _ZN7S1386C1D1Ev();
extern void _ZN7S1386C1D0Ev();
extern void _ZN7S1386C42v3Ev();
extern void _ZN7S1386C42v4Ev();
extern void _ZN7S1386C42v5Ev();
extern void _ZN7S1386C42v6Ev();
extern void _ZN7S1386C42v7Ev();
extern void _ZN7S1386C42v8Ev();
extern void _ZN7S1386C42v9Ev();
extern void _ZN7S1386C43v10Ev();
extern void _ZN7S1386C43v11Ev();
extern void _ZN7S1386C43v12Ev();
extern void _ZN7S1386C33v13Ev();
extern void _ZN7S1386C33v14Ev();
extern void _ZN7S1386C33v15Ev();
extern void _ZN7S1386C33v16Ev();
extern void _ZN7S1386C33v17Ev();
extern void _ZN7S1386C33v18Ev();
extern void _ZN7S1386C33v19Ev();
extern void _ZN7S1386C33v20Ev();
extern void _ZN7S1386C33v21Ev();
extern void _ZN7S1386C33v22Ev();
extern void _ZN7S1386C33v23Ev();
extern void _ZN7S1386C33v24Ev();
extern void _ZN7S1386C33v25Ev();
extern void _ZN7S1386C33v26Ev();
extern void _ZN7S1386C23v27Ev();
extern void _ZN7S1386C12v1Ev();
extern void _ZN7S1386C12v2Ev();
static  VTBL_ENTRY vtc_S1386C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1386C1[0]),
  (VTBL_ENTRY)&_ZN7S1386C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1386C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1386C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1386C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v13Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v14Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1386C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1386C23v27Ev,
  (VTBL_ENTRY)&_ZN7S1386C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1386C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S1386C1[];
extern  VTBL_ENTRY _ZTV7S1386C1[];
Class_Descriptor cd_S1386C1 = {  "S1386C1", // class name
  bases_S1386C1, 3,
  &(vtc_S1386C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(728,540), // object size
  NSPAIRA(_ZTI7S1386C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1386C1),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3610C10  {
  void *s3610c10f0;
  ::S10103C13_nt s3610c10f1;
  ::S10103C16_nt s3610c10f2;
  ::S10103C17 s3610c10f3;
  virtual  ~S3610C10(); // _ZN8S3610C10D1Ev
  virtual void  v6(); // _ZN8S3610C102v6Ev
  virtual void  v7(); // _ZN8S3610C102v7Ev
  virtual void  v8(); // _ZN8S3610C102v8Ev
  virtual void  v9(); // _ZN8S3610C102v9Ev
  virtual void  v10(); // _ZN8S3610C103v10Ev
  virtual void  v11(); // _ZN8S3610C103v11Ev
  virtual void  v12(); // _ZN8S3610C103v12Ev
  virtual void  v13(); // _ZN8S3610C103v13Ev
  virtual void  v14(); // _ZN8S3610C103v14Ev
  virtual void  v15(); // _ZN8S3610C103v15Ev
  virtual void  v16(); // _ZN8S3610C103v16Ev
  virtual void  v17(); // _ZN8S3610C103v17Ev
  virtual void  v18(); // _ZN8S3610C103v18Ev
  virtual void  v19(); // _ZN8S3610C103v19Ev
  virtual void  v20(); // _ZN8S3610C103v20Ev
  virtual void  v21(); // _ZN8S3610C103v21Ev
  virtual void  v22(); // _ZN8S3610C103v22Ev
  virtual void  v23(); // _ZN8S3610C103v23Ev
  virtual void  v24(); // _ZN8S3610C103v24Ev
  virtual void  v25(); // _ZN8S3610C103v25Ev
  virtual void  v26(); // _ZN8S3610C103v26Ev
  virtual void  v27(); // _ZN8S3610C103v27Ev
  virtual void  v28(); // _ZN8S3610C103v28Ev
  virtual void  v29(); // _ZN8S3610C103v29Ev
  S3610C10(); // tgen
};
//SIG(-1 S3610C10) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC6{ m Fc Fi[2] Fp}}


 S3610C10 ::~S3610C10(){ note_dtor("S3610C10", this);}
void  S3610C10 ::v6(){vfunc_called(this, "_ZN8S3610C102v6Ev");}
void  S3610C10 ::v7(){vfunc_called(this, "_ZN8S3610C102v7Ev");}
void  S3610C10 ::v8(){vfunc_called(this, "_ZN8S3610C102v8Ev");}
void  S3610C10 ::v9(){vfunc_called(this, "_ZN8S3610C102v9Ev");}
void  S3610C10 ::v10(){vfunc_called(this, "_ZN8S3610C103v10Ev");}
void  S3610C10 ::v11(){vfunc_called(this, "_ZN8S3610C103v11Ev");}
void  S3610C10 ::v12(){vfunc_called(this, "_ZN8S3610C103v12Ev");}
void  S3610C10 ::v13(){vfunc_called(this, "_ZN8S3610C103v13Ev");}
void  S3610C10 ::v14(){vfunc_called(this, "_ZN8S3610C103v14Ev");}
void  S3610C10 ::v15(){vfunc_called(this, "_ZN8S3610C103v15Ev");}
void  S3610C10 ::v16(){vfunc_called(this, "_ZN8S3610C103v16Ev");}
void  S3610C10 ::v17(){vfunc_called(this, "_ZN8S3610C103v17Ev");}
void  S3610C10 ::v18(){vfunc_called(this, "_ZN8S3610C103v18Ev");}
void  S3610C10 ::v19(){vfunc_called(this, "_ZN8S3610C103v19Ev");}
void  S3610C10 ::v20(){vfunc_called(this, "_ZN8S3610C103v20Ev");}
void  S3610C10 ::v21(){vfunc_called(this, "_ZN8S3610C103v21Ev");}
void  S3610C10 ::v22(){vfunc_called(this, "_ZN8S3610C103v22Ev");}
void  S3610C10 ::v23(){vfunc_called(this, "_ZN8S3610C103v23Ev");}
void  S3610C10 ::v24(){vfunc_called(this, "_ZN8S3610C103v24Ev");}
void  S3610C10 ::v25(){vfunc_called(this, "_ZN8S3610C103v25Ev");}
void  S3610C10 ::v26(){vfunc_called(this, "_ZN8S3610C103v26Ev");}
void  S3610C10 ::v27(){vfunc_called(this, "_ZN8S3610C103v27Ev");}
void  S3610C10 ::v28(){vfunc_called(this, "_ZN8S3610C103v28Ev");}
void  S3610C10 ::v29(){vfunc_called(this, "_ZN8S3610C103v29Ev");}
S3610C10 ::S3610C10(){ note_ctor("S3610C10", this);} // tgen

static void Test_S3610C10()
{
  extern Class_Descriptor cd_S3610C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S3610C10, buf);
    S3610C10 *dp, &lv = *(dp=new (buf) S3610C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S3610C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3610C10)");
    check_field_offset(lv, s3610c10f0, ABISELECT(8,4), "S3610C10.s3610c10f0");
    check_field_offset(lv, s3610c10f1, ABISELECT(16,8), "S3610C10.s3610c10f1");
    check_field_offset(lv, s3610c10f2, ABISELECT(40,24), "S3610C10.s3610c10f2");
    check_field_offset(lv, s3610c10f3, ABISELECT(96,64), "S3610C10.s3610c10f3");
    test_class_info(&lv, &cd_S3610C10);
    dp->~S3610C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3610C10(Test_S3610C10, "S3610C10", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN8S3610C10C1Ev();
extern void _ZN8S3610C10D1Ev();
Name_Map name_map_S3610C10[] = {
  NSPAIR(_ZN8S3610C10C1Ev),
  NSPAIR(_ZN8S3610C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S3610C10[];
extern void _ZN8S3610C10D1Ev();
extern void _ZN8S3610C10D0Ev();
extern void _ZN8S3610C102v6Ev();
extern void _ZN8S3610C102v7Ev();
extern void _ZN8S3610C102v8Ev();
extern void _ZN8S3610C102v9Ev();
extern void _ZN8S3610C103v10Ev();
extern void _ZN8S3610C103v11Ev();
extern void _ZN8S3610C103v12Ev();
extern void _ZN8S3610C103v13Ev();
extern void _ZN8S3610C103v14Ev();
extern void _ZN8S3610C103v15Ev();
extern void _ZN8S3610C103v16Ev();
extern void _ZN8S3610C103v17Ev();
extern void _ZN8S3610C103v18Ev();
extern void _ZN8S3610C103v19Ev();
extern void _ZN8S3610C103v20Ev();
extern void _ZN8S3610C103v21Ev();
extern void _ZN8S3610C103v22Ev();
extern void _ZN8S3610C103v23Ev();
extern void _ZN8S3610C103v24Ev();
extern void _ZN8S3610C103v25Ev();
extern void _ZN8S3610C103v26Ev();
extern void _ZN8S3610C103v27Ev();
extern void _ZN8S3610C103v28Ev();
extern void _ZN8S3610C103v29Ev();
static  VTBL_ENTRY vtc_S3610C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3610C10[0]),
  (VTBL_ENTRY)&_ZN8S3610C10D1Ev,
  (VTBL_ENTRY)&_ZN8S3610C10D0Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v6Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v7Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v8Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v9Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v10Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v11Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v12Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v13Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v14Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v15Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v16Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v17Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v18Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v19Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v20Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v21Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v22Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v23Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v24Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v25Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v26Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v27Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v28Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v29Ev,
};
extern VTBL_ENTRY _ZTI8S3610C10[];
extern  VTBL_ENTRY _ZTV8S3610C10[];
Class_Descriptor cd_S3610C10 = {  "S3610C10", // class name
  0,0,//no base classes
  &(vtc_S3610C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI8S3610C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S3610C10),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3610C2  : S10103C5_nt , S3610C10 {
  int s3610c2f0;
  ::S10103C13_nt s3610c2f1;
  int s3610c2f2;
  ::S10103C105 s3610c2f3;
  ::S10103C105 s3610c2f4;
  ::S10103C25_nt s3610c2f5[2];
  ::S10103C25_nt s3610c2f6[2];
  ::S10103C14_nt s3610c2f7;
  virtual  ~S3610C2(); // _ZN7S3610C2D1Ev
  virtual void  v30(); // _ZN7S3610C23v30Ev
  S3610C2(); // tgen
};
//SIG(-1 S3610C2) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 Fi FC6 Fi FC11{ m Fp} FC11 FC12{ Fi[4]}[2] FC12[2] FC7}


 S3610C2 ::~S3610C2(){ note_dtor("S3610C2", this);}
void  S3610C2 ::v30(){vfunc_called(this, "_ZN7S3610C23v30Ev");}
S3610C2 ::S3610C2(){ note_ctor("S3610C2", this);} // tgen

static void Test_S3610C2()
{
  extern Class_Descriptor cd_S3610C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,56)];
    init_test(&cd_S3610C2, buf);
    S3610C2 *dp, &lv = *(dp=new (buf) S3610C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,220), "sizeof(S3610C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3610C2)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S3610C2");
    check_base_class_offset(lv, (S3610C10*), ABISELECT(48,32), "S3610C2");
    check_field_offset(lv, s3610c2f0, ABISELECT(168,112), "S3610C2.s3610c2f0");
    check_field_offset(lv, s3610c2f1, ABISELECT(176,116), "S3610C2.s3610c2f1");
    check_field_offset(lv, s3610c2f2, ABISELECT(200,132), "S3610C2.s3610c2f2");
    check_field_offset(lv, s3610c2f3, ABISELECT(208,136), "S3610C2.s3610c2f3");
    check_field_offset(lv, s3610c2f4, ABISELECT(216,140), "S3610C2.s3610c2f4");
    check_field_offset(lv, s3610c2f5, ABISELECT(224,144), "S3610C2.s3610c2f5");
    check_field_offset(lv, s3610c2f6, ABISELECT(256,176), "S3610C2.s3610c2f6");
    check_field_offset(lv, s3610c2f7, ABISELECT(288,208), "S3610C2.s3610c2f7");
    test_class_info(&lv, &cd_S3610C2);
    dp->~S3610C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3610C2(Test_S3610C2, "S3610C2", ABISELECT(304,220));

#else // __cplusplus

extern void _ZN7S3610C2C1Ev();
extern void _ZN7S3610C2D1Ev();
Name_Map name_map_S3610C2[] = {
  NSPAIR(_ZN7S3610C2C1Ev),
  NSPAIR(_ZN7S3610C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S3610C10;
extern VTBL_ENTRY _ZTI8S3610C10[];
extern  VTBL_ENTRY _ZTV8S3610C10[];
static Base_Class bases_S3610C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3610C10,    ABISELECT(48,32), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3610C2[];
extern void _ZN7S3610C2D1Ev();
extern void _ZN7S3610C2D0Ev();
extern void _ZN7S3610C23v30Ev();
extern void ABISELECT(_ZThn48_N7S3610C2D1Ev,_ZThn32_N7S3610C2D1Ev)();
extern void ABISELECT(_ZThn48_N7S3610C2D0Ev,_ZThn32_N7S3610C2D0Ev)();
extern void _ZN8S3610C102v6Ev();
extern void _ZN8S3610C102v7Ev();
extern void _ZN8S3610C102v8Ev();
extern void _ZN8S3610C102v9Ev();
extern void _ZN8S3610C103v10Ev();
extern void _ZN8S3610C103v11Ev();
extern void _ZN8S3610C103v12Ev();
extern void _ZN8S3610C103v13Ev();
extern void _ZN8S3610C103v14Ev();
extern void _ZN8S3610C103v15Ev();
extern void _ZN8S3610C103v16Ev();
extern void _ZN8S3610C103v17Ev();
extern void _ZN8S3610C103v18Ev();
extern void _ZN8S3610C103v19Ev();
extern void _ZN8S3610C103v20Ev();
extern void _ZN8S3610C103v21Ev();
extern void _ZN8S3610C103v22Ev();
extern void _ZN8S3610C103v23Ev();
extern void _ZN8S3610C103v24Ev();
extern void _ZN8S3610C103v25Ev();
extern void _ZN8S3610C103v26Ev();
extern void _ZN8S3610C103v27Ev();
extern void _ZN8S3610C103v28Ev();
extern void _ZN8S3610C103v29Ev();
static  VTBL_ENTRY vtc_S3610C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3610C2[0]),
  (VTBL_ENTRY)&_ZN7S3610C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3610C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3610C23v30Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S3610C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3610C2D1Ev,_ZThn32_N7S3610C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3610C2D0Ev,_ZThn32_N7S3610C2D0Ev),
  (VTBL_ENTRY)&_ZN8S3610C102v6Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v7Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v8Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v9Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v10Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v11Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v12Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v13Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v14Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v15Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v16Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v17Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v18Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v19Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v20Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v21Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v22Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v23Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v24Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v25Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v26Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v27Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v28Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v29Ev,
};
extern VTBL_ENTRY _ZTI7S3610C2[];
extern  VTBL_ENTRY _ZTV7S3610C2[];
Class_Descriptor cd_S3610C2 = {  "S3610C2", // class name
  bases_S3610C2, 2,
  &(vtc_S3610C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,220), // object size
  NSPAIRA(_ZTI7S3610C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3610C2),33, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3610C1  : S3610C2 {
  void *s3610c1f0[2];
  ::S10103C13_nt s3610c1f1;
  ::S10103C13_nt s3610c1f2;
  int s3610c1f3[2];
  virtual  ~S3610C1(); // _ZN7S3610C1D1Ev
  virtual void  v1(); // _ZN7S3610C12v1Ev
  virtual void  v2(); // _ZN7S3610C12v2Ev
  virtual void  v3(); // _ZN7S3610C12v3Ev
  virtual void  v4(); // _ZN7S3610C12v4Ev
  virtual void  v5(); // _ZN7S3610C12v5Ev
  S3610C1(); // tgen
};
//SIG(1 S3610C1) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC11{ m Fc Fi[2] Fp}} vd v30 Fi FC7 Fi FC12{ m Fp} FC12 FC13{ Fi[4]}[2] FC13[2] FC8} vd v1 v2 v3 v4 v5 Fp[2] FC7 FC7 Fi[2]}


 S3610C1 ::~S3610C1(){ note_dtor("S3610C1", this);}
void  S3610C1 ::v1(){vfunc_called(this, "_ZN7S3610C12v1Ev");}
void  S3610C1 ::v2(){vfunc_called(this, "_ZN7S3610C12v2Ev");}
void  S3610C1 ::v3(){vfunc_called(this, "_ZN7S3610C12v3Ev");}
void  S3610C1 ::v4(){vfunc_called(this, "_ZN7S3610C12v4Ev");}
void  S3610C1 ::v5(){vfunc_called(this, "_ZN7S3610C12v5Ev");}
S3610C1 ::S3610C1(){ note_ctor("S3610C1", this);} // tgen

static void Test_S3610C1()
{
  extern Class_Descriptor cd_S3610C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,68)];
    init_test(&cd_S3610C1, buf);
    S3610C1 *dp, &lv = *(dp=new (buf) S3610C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,268), "sizeof(S3610C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3610C1)");
    check_base_class_offset(lv, (S10103C5_nt*)(S3610C2*), 0, "S3610C1");
    check_base_class_offset(lv, (S3610C10*)(S3610C2*), ABISELECT(48,32), "S3610C1");
    check_base_class_offset(lv, (S3610C2*), 0, "S3610C1");
    check_field_offset(lv, s3610c1f0, ABISELECT(304,220), "S3610C1.s3610c1f0");
    check_field_offset(lv, s3610c1f1, ABISELECT(320,228), "S3610C1.s3610c1f1");
    check_field_offset(lv, s3610c1f2, ABISELECT(344,244), "S3610C1.s3610c1f2");
    check_field_offset(lv, s3610c1f3, ABISELECT(368,260), "S3610C1.s3610c1f3");
    test_class_info(&lv, &cd_S3610C1);
    dp->~S3610C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3610C1(Test_S3610C1, "S3610C1", ABISELECT(376,268));

#else // __cplusplus

extern void _ZN7S3610C1C1Ev();
extern void _ZN7S3610C1D1Ev();
Name_Map name_map_S3610C1[] = {
  NSPAIR(_ZN7S3610C1C1Ev),
  NSPAIR(_ZN7S3610C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S3610C10;
extern VTBL_ENTRY _ZTI8S3610C10[];
extern  VTBL_ENTRY _ZTV8S3610C10[];
extern Class_Descriptor cd_S3610C2;
extern VTBL_ENTRY _ZTI7S3610C2[];
extern  VTBL_ENTRY _ZTV7S3610C2[];
static Base_Class bases_S3610C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3610C10,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3610C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3610C1[];
extern void _ZN7S3610C1D1Ev();
extern void _ZN7S3610C1D0Ev();
extern void _ZN7S3610C23v30Ev();
extern void _ZN7S3610C12v1Ev();
extern void _ZN7S3610C12v2Ev();
extern void _ZN7S3610C12v3Ev();
extern void _ZN7S3610C12v4Ev();
extern void _ZN7S3610C12v5Ev();
extern void ABISELECT(_ZThn48_N7S3610C1D1Ev,_ZThn32_N7S3610C1D1Ev)();
extern void ABISELECT(_ZThn48_N7S3610C1D0Ev,_ZThn32_N7S3610C1D0Ev)();
extern void _ZN8S3610C102v6Ev();
extern void _ZN8S3610C102v7Ev();
extern void _ZN8S3610C102v8Ev();
extern void _ZN8S3610C102v9Ev();
extern void _ZN8S3610C103v10Ev();
extern void _ZN8S3610C103v11Ev();
extern void _ZN8S3610C103v12Ev();
extern void _ZN8S3610C103v13Ev();
extern void _ZN8S3610C103v14Ev();
extern void _ZN8S3610C103v15Ev();
extern void _ZN8S3610C103v16Ev();
extern void _ZN8S3610C103v17Ev();
extern void _ZN8S3610C103v18Ev();
extern void _ZN8S3610C103v19Ev();
extern void _ZN8S3610C103v20Ev();
extern void _ZN8S3610C103v21Ev();
extern void _ZN8S3610C103v22Ev();
extern void _ZN8S3610C103v23Ev();
extern void _ZN8S3610C103v24Ev();
extern void _ZN8S3610C103v25Ev();
extern void _ZN8S3610C103v26Ev();
extern void _ZN8S3610C103v27Ev();
extern void _ZN8S3610C103v28Ev();
extern void _ZN8S3610C103v29Ev();
static  VTBL_ENTRY vtc_S3610C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3610C1[0]),
  (VTBL_ENTRY)&_ZN7S3610C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3610C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3610C23v30Ev,
  (VTBL_ENTRY)&_ZN7S3610C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3610C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3610C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3610C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3610C12v5Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S3610C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3610C1D1Ev,_ZThn32_N7S3610C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3610C1D0Ev,_ZThn32_N7S3610C1D0Ev),
  (VTBL_ENTRY)&_ZN8S3610C102v6Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v7Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v8Ev,
  (VTBL_ENTRY)&_ZN8S3610C102v9Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v10Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v11Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v12Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v13Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v14Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v15Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v16Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v17Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v18Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v19Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v20Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v21Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v22Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v23Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v24Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v25Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v26Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v27Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v28Ev,
  (VTBL_ENTRY)&_ZN8S3610C103v29Ev,
};
extern VTBL_ENTRY _ZTI7S3610C1[];
extern  VTBL_ENTRY _ZTV7S3610C1[];
Class_Descriptor cd_S3610C1 = {  "S3610C1", // class name
  bases_S3610C1, 3,
  &(vtc_S3610C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,268), // object size
  NSPAIRA(_ZTI7S3610C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3610C1),38, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10101C2  {
  virtual  ~S10101C2(); // _ZN8S10101C2D1Ev
  virtual void  v6(); // _ZN8S10101C22v6Ev
  S10101C2(); // tgen
};
//SIG(-1 S10101C2) C1{ vd v1}


 S10101C2 ::~S10101C2(){ note_dtor("S10101C2", this);}
void  S10101C2 ::v6(){vfunc_called(this, "_ZN8S10101C22v6Ev");}
S10101C2 ::S10101C2(){ note_ctor("S10101C2", this);} // tgen

static void Test_S10101C2()
{
  extern Class_Descriptor cd_S10101C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10101C2, buf);
    S10101C2 *dp, &lv = *(dp=new (buf) S10101C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10101C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10101C2)");
    test_class_info(&lv, &cd_S10101C2);
    dp->~S10101C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10101C2(Test_S10101C2, "S10101C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10101C2C1Ev();
extern void _ZN8S10101C2D1Ev();
Name_Map name_map_S10101C2[] = {
  NSPAIR(_ZN8S10101C2C1Ev),
  NSPAIR(_ZN8S10101C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10101C2[];
extern void _ZN8S10101C2D1Ev();
extern void _ZN8S10101C2D0Ev();
extern void _ZN8S10101C22v6Ev();
static  VTBL_ENTRY vtc_S10101C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10101C2[0]),
  (VTBL_ENTRY)&_ZN8S10101C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10101C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10101C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S10101C2[];
extern  VTBL_ENTRY _ZTV8S10101C2[];
Class_Descriptor cd_S10101C2 = {  "S10101C2", // class name
  0,0,//no base classes
  &(vtc_S10101C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10101C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10101C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10101C3  {
  void *s10101c3f0;
  virtual  ~S10101C3(); // _ZN8S10101C3D1Ev
  virtual void  v7(); // _ZN8S10101C32v7Ev
  virtual void  v8(); // _ZN8S10101C32v8Ev
  virtual void  v9(); // _ZN8S10101C32v9Ev
  virtual void  v10(); // _ZN8S10101C33v10Ev
  virtual void  v11(); // _ZN8S10101C33v11Ev
  S10101C3(); // tgen
};
//SIG(-1 S10101C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10101C3 ::~S10101C3(){ note_dtor("S10101C3", this);}
void  S10101C3 ::v7(){vfunc_called(this, "_ZN8S10101C32v7Ev");}
void  S10101C3 ::v8(){vfunc_called(this, "_ZN8S10101C32v8Ev");}
void  S10101C3 ::v9(){vfunc_called(this, "_ZN8S10101C32v9Ev");}
void  S10101C3 ::v10(){vfunc_called(this, "_ZN8S10101C33v10Ev");}
void  S10101C3 ::v11(){vfunc_called(this, "_ZN8S10101C33v11Ev");}
S10101C3 ::S10101C3(){ note_ctor("S10101C3", this);} // tgen

static void Test_S10101C3()
{
  extern Class_Descriptor cd_S10101C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10101C3, buf);
    S10101C3 *dp, &lv = *(dp=new (buf) S10101C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10101C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10101C3)");
    check_field_offset(lv, s10101c3f0, ABISELECT(8,4), "S10101C3.s10101c3f0");
    test_class_info(&lv, &cd_S10101C3);
    dp->~S10101C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10101C3(Test_S10101C3, "S10101C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10101C3C1Ev();
extern void _ZN8S10101C3D1Ev();
Name_Map name_map_S10101C3[] = {
  NSPAIR(_ZN8S10101C3C1Ev),
  NSPAIR(_ZN8S10101C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10101C3[];
extern void _ZN8S10101C3D1Ev();
extern void _ZN8S10101C3D0Ev();
extern void _ZN8S10101C32v7Ev();
extern void _ZN8S10101C32v8Ev();
extern void _ZN8S10101C32v9Ev();
extern void _ZN8S10101C33v10Ev();
extern void _ZN8S10101C33v11Ev();
static  VTBL_ENTRY vtc_S10101C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10101C3[0]),
  (VTBL_ENTRY)&_ZN8S10101C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10101C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10101C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10101C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10101C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10101C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10101C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10101C3[];
extern  VTBL_ENTRY _ZTV8S10101C3[];
Class_Descriptor cd_S10101C3 = {  "S10101C3", // class name
  0,0,//no base classes
  &(vtc_S10101C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10101C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10101C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10101C1  : S10101C2 , S10101C3 {
  ::S10103C49 s10101c1f0;
  ::S10103C56 s10101c1f1;
  ::S10103C47 s10101c1f2;
  ::S10103C57 s10101c1f3;
  ::S10103C50 s10101c1f4;
  ::S10098C34 s10101c1f5;
  void *s10101c1f6[5];
  virtual  ~S10101C1(); // _ZN8S10101C1D1Ev
  virtual void  v1(); // _ZN8S10101C12v1Ev
  virtual void  v2(); // _ZN8S10101C12v2Ev
  virtual void  v3(); // _ZN8S10101C12v3Ev
  virtual void  v4(); // _ZN8S10101C12v4Ev
  virtual void  v5(); // _ZN8S10101C12v5Ev
  S10101C1(); // tgen
};
//SIG(1 S10101C1) C1{ BC2{ vd v6} BC3{ vd v7 v8 v9 v10 v11 Fp} vd v1 v2 v3 v4 v5 FC4{ BC5{ BC6{ vd m FC7{ m Fp Fi FC8{ m} FC8} FC7 Fc} vd v14 v15 v16 v17 FC9{ m Fp FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} FC11 FC11 Fi} Fp Fc Fi} v12 v13} FC13{ BC5 v18} FC14{ BC5 v19} FC15{ BC5 v20 v21 v22 Fp} FC16{ BC6 vd} FC17{ BC18{ vd m FC19{ m Fp Fi[2] FC20{ m}} FC19} vd} Fp[5]}


 S10101C1 ::~S10101C1(){ note_dtor("S10101C1", this);}
void  S10101C1 ::v1(){vfunc_called(this, "_ZN8S10101C12v1Ev");}
void  S10101C1 ::v2(){vfunc_called(this, "_ZN8S10101C12v2Ev");}
void  S10101C1 ::v3(){vfunc_called(this, "_ZN8S10101C12v3Ev");}
void  S10101C1 ::v4(){vfunc_called(this, "_ZN8S10101C12v4Ev");}
void  S10101C1 ::v5(){vfunc_called(this, "_ZN8S10101C12v5Ev");}
S10101C1 ::S10101C1(){ note_ctor("S10101C1", this);} // tgen

static void Test_S10101C1()
{
  extern Class_Descriptor cd_S10101C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(91,119)];
    init_test(&cd_S10101C1, buf);
    S10101C1 *dp, &lv = *(dp=new (buf) S10101C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(720,472), "sizeof(S10101C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10101C1)");
    check_base_class_offset(lv, (S10101C2*), 0, "S10101C1");
    check_base_class_offset(lv, (S10101C3*), ABISELECT(8,4), "S10101C1");
    check_field_offset(lv, s10101c1f0, ABISELECT(24,12), "S10101C1.s10101c1f0");
    check_field_offset(lv, s10101c1f1, ABISELECT(160,104), "S10101C1.s10101c1f1");
    check_field_offset(lv, s10101c1f2, ABISELECT(296,196), "S10101C1.s10101c1f2");
    check_field_offset(lv, s10101c1f3, ABISELECT(432,288), "S10101C1.s10101c1f3");
    check_field_offset(lv, s10101c1f4, ABISELECT(576,384), "S10101C1.s10101c1f4");
    check_field_offset(lv, s10101c1f5, ABISELECT(624,416), "S10101C1.s10101c1f5");
    check_field_offset(lv, s10101c1f6, ABISELECT(680,452), "S10101C1.s10101c1f6");
    test_class_info(&lv, &cd_S10101C1);
    dp->~S10101C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10101C1(Test_S10101C1, "S10101C1", ABISELECT(720,472));

#else // __cplusplus

extern void _ZN8S10101C1C1Ev();
extern void _ZN8S10101C1D1Ev();
Name_Map name_map_S10101C1[] = {
  NSPAIR(_ZN8S10101C1C1Ev),
  NSPAIR(_ZN8S10101C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10101C2;
extern VTBL_ENTRY _ZTI8S10101C2[];
extern  VTBL_ENTRY _ZTV8S10101C2[];
extern Class_Descriptor cd_S10101C3;
extern VTBL_ENTRY _ZTI8S10101C3[];
extern  VTBL_ENTRY _ZTV8S10101C3[];
static Base_Class bases_S10101C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10101C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10101C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10101C1[];
extern void _ZN8S10101C1D1Ev();
extern void _ZN8S10101C1D0Ev();
extern void _ZN8S10101C22v6Ev();
extern void _ZN8S10101C12v1Ev();
extern void _ZN8S10101C12v2Ev();
extern void _ZN8S10101C12v3Ev();
extern void _ZN8S10101C12v4Ev();
extern void _ZN8S10101C12v5Ev();
extern void ABISELECT(_ZThn8_N8S10101C1D1Ev,_ZThn4_N8S10101C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10101C1D0Ev,_ZThn4_N8S10101C1D0Ev)();
extern void _ZN8S10101C32v7Ev();
extern void _ZN8S10101C32v8Ev();
extern void _ZN8S10101C32v9Ev();
extern void _ZN8S10101C33v10Ev();
extern void _ZN8S10101C33v11Ev();
static  VTBL_ENTRY vtc_S10101C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10101C1[0]),
  (VTBL_ENTRY)&_ZN8S10101C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10101C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10101C22v6Ev,
  (VTBL_ENTRY)&_ZN8S10101C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10101C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10101C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10101C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10101C12v5Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10101C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10101C1D1Ev,_ZThn4_N8S10101C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10101C1D0Ev,_ZThn4_N8S10101C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10101C32v7Ev,
  (VTBL_ENTRY)&_ZN8S10101C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10101C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10101C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10101C33v11Ev,
};
extern VTBL_ENTRY _ZTI8S10101C1[];
extern  VTBL_ENTRY _ZTV8S10101C1[];
Class_Descriptor cd_S10101C1 = {  "S10101C1", // class name
  bases_S10101C1, 2,
  &(vtc_S10101C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(720,472), // object size
  NSPAIRA(_ZTI8S10101C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10101C1),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3595C10  {
  void *s3595c10f0;
  ::S10103C13_nt s3595c10f1;
  ::S10103C16_nt s3595c10f2;
  ::S10103C17 s3595c10f3;
  virtual  ~S3595C10(); // _ZN8S3595C10D1Ev
  virtual void  v2(); // _ZN8S3595C102v2Ev
  virtual void  v3(); // _ZN8S3595C102v3Ev
  virtual void  v4(); // _ZN8S3595C102v4Ev
  virtual void  v5(); // _ZN8S3595C102v5Ev
  virtual void  v6(); // _ZN8S3595C102v6Ev
  virtual void  v7(); // _ZN8S3595C102v7Ev
  virtual void  v8(); // _ZN8S3595C102v8Ev
  virtual void  v9(); // _ZN8S3595C102v9Ev
  virtual void  v10(); // _ZN8S3595C103v10Ev
  virtual void  v11(); // _ZN8S3595C103v11Ev
  virtual void  v12(); // _ZN8S3595C103v12Ev
  virtual void  v13(); // _ZN8S3595C103v13Ev
  virtual void  v14(); // _ZN8S3595C103v14Ev
  virtual void  v15(); // _ZN8S3595C103v15Ev
  virtual void  v16(); // _ZN8S3595C103v16Ev
  virtual void  v17(); // _ZN8S3595C103v17Ev
  virtual void  v18(); // _ZN8S3595C103v18Ev
  virtual void  v19(); // _ZN8S3595C103v19Ev
  virtual void  v20(); // _ZN8S3595C103v20Ev
  virtual void  v21(); // _ZN8S3595C103v21Ev
  virtual void  v22(); // _ZN8S3595C103v22Ev
  virtual void  v23(); // _ZN8S3595C103v23Ev
  virtual void  v24(); // _ZN8S3595C103v24Ev
  virtual void  v25(); // _ZN8S3595C103v25Ev
  S3595C10(); // tgen
};
//SIG(-1 S3595C10) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC6{ m Fc Fi[2] Fp}}


 S3595C10 ::~S3595C10(){ note_dtor("S3595C10", this);}
void  S3595C10 ::v2(){vfunc_called(this, "_ZN8S3595C102v2Ev");}
void  S3595C10 ::v3(){vfunc_called(this, "_ZN8S3595C102v3Ev");}
void  S3595C10 ::v4(){vfunc_called(this, "_ZN8S3595C102v4Ev");}
void  S3595C10 ::v5(){vfunc_called(this, "_ZN8S3595C102v5Ev");}
void  S3595C10 ::v6(){vfunc_called(this, "_ZN8S3595C102v6Ev");}
void  S3595C10 ::v7(){vfunc_called(this, "_ZN8S3595C102v7Ev");}
void  S3595C10 ::v8(){vfunc_called(this, "_ZN8S3595C102v8Ev");}
void  S3595C10 ::v9(){vfunc_called(this, "_ZN8S3595C102v9Ev");}
void  S3595C10 ::v10(){vfunc_called(this, "_ZN8S3595C103v10Ev");}
void  S3595C10 ::v11(){vfunc_called(this, "_ZN8S3595C103v11Ev");}
void  S3595C10 ::v12(){vfunc_called(this, "_ZN8S3595C103v12Ev");}
void  S3595C10 ::v13(){vfunc_called(this, "_ZN8S3595C103v13Ev");}
void  S3595C10 ::v14(){vfunc_called(this, "_ZN8S3595C103v14Ev");}
void  S3595C10 ::v15(){vfunc_called(this, "_ZN8S3595C103v15Ev");}
void  S3595C10 ::v16(){vfunc_called(this, "_ZN8S3595C103v16Ev");}
void  S3595C10 ::v17(){vfunc_called(this, "_ZN8S3595C103v17Ev");}
void  S3595C10 ::v18(){vfunc_called(this, "_ZN8S3595C103v18Ev");}
void  S3595C10 ::v19(){vfunc_called(this, "_ZN8S3595C103v19Ev");}
void  S3595C10 ::v20(){vfunc_called(this, "_ZN8S3595C103v20Ev");}
void  S3595C10 ::v21(){vfunc_called(this, "_ZN8S3595C103v21Ev");}
void  S3595C10 ::v22(){vfunc_called(this, "_ZN8S3595C103v22Ev");}
void  S3595C10 ::v23(){vfunc_called(this, "_ZN8S3595C103v23Ev");}
void  S3595C10 ::v24(){vfunc_called(this, "_ZN8S3595C103v24Ev");}
void  S3595C10 ::v25(){vfunc_called(this, "_ZN8S3595C103v25Ev");}
S3595C10 ::S3595C10(){ note_ctor("S3595C10", this);} // tgen

static void Test_S3595C10()
{
  extern Class_Descriptor cd_S3595C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,21)];
    init_test(&cd_S3595C10, buf);
    S3595C10 *dp, &lv = *(dp=new (buf) S3595C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,80), "sizeof(S3595C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3595C10)");
    check_field_offset(lv, s3595c10f0, ABISELECT(8,4), "S3595C10.s3595c10f0");
    check_field_offset(lv, s3595c10f1, ABISELECT(16,8), "S3595C10.s3595c10f1");
    check_field_offset(lv, s3595c10f2, ABISELECT(40,24), "S3595C10.s3595c10f2");
    check_field_offset(lv, s3595c10f3, ABISELECT(96,64), "S3595C10.s3595c10f3");
    test_class_info(&lv, &cd_S3595C10);
    dp->~S3595C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3595C10(Test_S3595C10, "S3595C10", ABISELECT(120,80));

#else // __cplusplus

extern void _ZN8S3595C10C1Ev();
extern void _ZN8S3595C10D1Ev();
Name_Map name_map_S3595C10[] = {
  NSPAIR(_ZN8S3595C10C1Ev),
  NSPAIR(_ZN8S3595C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S3595C10[];
extern void _ZN8S3595C10D1Ev();
extern void _ZN8S3595C10D0Ev();
extern void _ZN8S3595C102v2Ev();
extern void _ZN8S3595C102v3Ev();
extern void _ZN8S3595C102v4Ev();
extern void _ZN8S3595C102v5Ev();
extern void _ZN8S3595C102v6Ev();
extern void _ZN8S3595C102v7Ev();
extern void _ZN8S3595C102v8Ev();
extern void _ZN8S3595C102v9Ev();
extern void _ZN8S3595C103v10Ev();
extern void _ZN8S3595C103v11Ev();
extern void _ZN8S3595C103v12Ev();
extern void _ZN8S3595C103v13Ev();
extern void _ZN8S3595C103v14Ev();
extern void _ZN8S3595C103v15Ev();
extern void _ZN8S3595C103v16Ev();
extern void _ZN8S3595C103v17Ev();
extern void _ZN8S3595C103v18Ev();
extern void _ZN8S3595C103v19Ev();
extern void _ZN8S3595C103v20Ev();
extern void _ZN8S3595C103v21Ev();
extern void _ZN8S3595C103v22Ev();
extern void _ZN8S3595C103v23Ev();
extern void _ZN8S3595C103v24Ev();
extern void _ZN8S3595C103v25Ev();
static  VTBL_ENTRY vtc_S3595C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3595C10[0]),
  (VTBL_ENTRY)&_ZN8S3595C10D1Ev,
  (VTBL_ENTRY)&_ZN8S3595C10D0Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v2Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v3Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v4Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v5Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v6Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v7Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v8Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v9Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v10Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v11Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v12Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v13Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v14Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v15Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v16Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v17Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v18Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v19Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v20Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v21Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v22Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v23Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v24Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v25Ev,
};
extern VTBL_ENTRY _ZTI8S3595C10[];
extern  VTBL_ENTRY _ZTV8S3595C10[];
Class_Descriptor cd_S3595C10 = {  "S3595C10", // class name
  0,0,//no base classes
  &(vtc_S3595C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,80), // object size
  NSPAIRA(_ZTI8S3595C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S3595C10),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3595C2  : S10103C5_nt , S3595C10 {
  int s3595c2f0;
  ::S10103C13_nt s3595c2f1;
  int s3595c2f2;
  ::S10103C105 s3595c2f3;
  ::S10103C105 s3595c2f4;
  ::S10103C25_nt s3595c2f5[2];
  ::S10103C25_nt s3595c2f6[2];
  ::S10103C14_nt s3595c2f7;
  virtual  ~S3595C2(); // _ZN7S3595C2D1Ev
  virtual void  v26(); // _ZN7S3595C23v26Ev
  S3595C2(); // tgen
};
//SIG(-1 S3595C2) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC4} FC3 Fc} BC5{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC10{ m Fc Fi[2] Fp}} vd v1 Fi FC6 Fi FC11{ m Fp} FC11 FC12{ Fi[4]}[2] FC12[2] FC7}


 S3595C2 ::~S3595C2(){ note_dtor("S3595C2", this);}
void  S3595C2 ::v26(){vfunc_called(this, "_ZN7S3595C23v26Ev");}
S3595C2 ::S3595C2(){ note_ctor("S3595C2", this);} // tgen

static void Test_S3595C2()
{
  extern Class_Descriptor cd_S3595C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,56)];
    init_test(&cd_S3595C2, buf);
    S3595C2 *dp, &lv = *(dp=new (buf) S3595C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,220), "sizeof(S3595C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3595C2)");
    check_base_class_offset(lv, (S10103C5_nt*), 0, "S3595C2");
    check_base_class_offset(lv, (S3595C10*), ABISELECT(48,32), "S3595C2");
    check_field_offset(lv, s3595c2f0, ABISELECT(168,112), "S3595C2.s3595c2f0");
    check_field_offset(lv, s3595c2f1, ABISELECT(176,116), "S3595C2.s3595c2f1");
    check_field_offset(lv, s3595c2f2, ABISELECT(200,132), "S3595C2.s3595c2f2");
    check_field_offset(lv, s3595c2f3, ABISELECT(208,136), "S3595C2.s3595c2f3");
    check_field_offset(lv, s3595c2f4, ABISELECT(216,140), "S3595C2.s3595c2f4");
    check_field_offset(lv, s3595c2f5, ABISELECT(224,144), "S3595C2.s3595c2f5");
    check_field_offset(lv, s3595c2f6, ABISELECT(256,176), "S3595C2.s3595c2f6");
    check_field_offset(lv, s3595c2f7, ABISELECT(288,208), "S3595C2.s3595c2f7");
    test_class_info(&lv, &cd_S3595C2);
    dp->~S3595C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3595C2(Test_S3595C2, "S3595C2", ABISELECT(304,220));

#else // __cplusplus

extern void _ZN7S3595C2C1Ev();
extern void _ZN7S3595C2D1Ev();
Name_Map name_map_S3595C2[] = {
  NSPAIR(_ZN7S3595C2C1Ev),
  NSPAIR(_ZN7S3595C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S3595C10;
extern VTBL_ENTRY _ZTI8S3595C10[];
extern  VTBL_ENTRY _ZTV8S3595C10[];
static Base_Class bases_S3595C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3595C10,    ABISELECT(48,32), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3595C2[];
extern void _ZN7S3595C2D1Ev();
extern void _ZN7S3595C2D0Ev();
extern void _ZN7S3595C23v26Ev();
extern void ABISELECT(_ZThn48_N7S3595C2D1Ev,_ZThn32_N7S3595C2D1Ev)();
extern void ABISELECT(_ZThn48_N7S3595C2D0Ev,_ZThn32_N7S3595C2D0Ev)();
extern void _ZN8S3595C102v2Ev();
extern void _ZN8S3595C102v3Ev();
extern void _ZN8S3595C102v4Ev();
extern void _ZN8S3595C102v5Ev();
extern void _ZN8S3595C102v6Ev();
extern void _ZN8S3595C102v7Ev();
extern void _ZN8S3595C102v8Ev();
extern void _ZN8S3595C102v9Ev();
extern void _ZN8S3595C103v10Ev();
extern void _ZN8S3595C103v11Ev();
extern void _ZN8S3595C103v12Ev();
extern void _ZN8S3595C103v13Ev();
extern void _ZN8S3595C103v14Ev();
extern void _ZN8S3595C103v15Ev();
extern void _ZN8S3595C103v16Ev();
extern void _ZN8S3595C103v17Ev();
extern void _ZN8S3595C103v18Ev();
extern void _ZN8S3595C103v19Ev();
extern void _ZN8S3595C103v20Ev();
extern void _ZN8S3595C103v21Ev();
extern void _ZN8S3595C103v22Ev();
extern void _ZN8S3595C103v23Ev();
extern void _ZN8S3595C103v24Ev();
extern void _ZN8S3595C103v25Ev();
static  VTBL_ENTRY vtc_S3595C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3595C2[0]),
  (VTBL_ENTRY)&_ZN7S3595C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3595C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3595C23v26Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S3595C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3595C2D1Ev,_ZThn32_N7S3595C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3595C2D0Ev,_ZThn32_N7S3595C2D0Ev),
  (VTBL_ENTRY)&_ZN8S3595C102v2Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v3Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v4Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v5Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v6Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v7Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v8Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v9Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v10Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v11Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v12Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v13Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v14Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v15Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v16Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v17Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v18Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v19Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v20Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v21Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v22Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v23Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v24Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v25Ev,
};
extern VTBL_ENTRY _ZTI7S3595C2[];
extern  VTBL_ENTRY _ZTV7S3595C2[];
Class_Descriptor cd_S3595C2 = {  "S3595C2", // class name
  bases_S3595C2, 2,
  &(vtc_S3595C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,220), // object size
  NSPAIRA(_ZTI7S3595C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3595C2),33, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3595C1  : S3595C2 {
  void *s3595c1f0;
  int s3595c1f1;
  virtual  ~S3595C1(); // _ZN7S3595C1D1Ev
  virtual void  v1(); // _ZN7S3595C12v1Ev
  S3595C1(); // tgen
};
//SIG(1 S3595C1) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC5} FC4 Fc} BC6{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]} FC11{ m Fc Fi[2] Fp}} vd v26 Fi FC7 Fi FC12{ m Fp} FC12 FC13{ Fi[4]}[2] FC13[2] FC8} vd v1 Fp Fi}


 S3595C1 ::~S3595C1(){ note_dtor("S3595C1", this);}
void  S3595C1 ::v1(){vfunc_called(this, "_ZN7S3595C12v1Ev");}
S3595C1 ::S3595C1(){ note_ctor("S3595C1", this);} // tgen

static void Test_S3595C1()
{
  extern Class_Descriptor cd_S3595C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,58)];
    init_test(&cd_S3595C1, buf);
    S3595C1 *dp, &lv = *(dp=new (buf) S3595C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,228), "sizeof(S3595C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3595C1)");
    check_base_class_offset(lv, (S10103C5_nt*)(S3595C2*), 0, "S3595C1");
    check_base_class_offset(lv, (S3595C10*)(S3595C2*), ABISELECT(48,32), "S3595C1");
    check_base_class_offset(lv, (S3595C2*), 0, "S3595C1");
    check_field_offset(lv, s3595c1f0, ABISELECT(304,220), "S3595C1.s3595c1f0");
    check_field_offset(lv, s3595c1f1, ABISELECT(312,224), "S3595C1.s3595c1f1");
    test_class_info(&lv, &cd_S3595C1);
    dp->~S3595C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3595C1(Test_S3595C1, "S3595C1", ABISELECT(320,228));

#else // __cplusplus

extern void _ZN7S3595C1C1Ev();
extern void _ZN7S3595C1D1Ev();
Name_Map name_map_S3595C1[] = {
  NSPAIR(_ZN7S3595C1C1Ev),
  NSPAIR(_ZN7S3595C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10103C5_nt;
extern VTBL_ENTRY _ZTI11S10103C5_nt[];
extern  VTBL_ENTRY _ZTV11S10103C5_nt[];
extern Class_Descriptor cd_S3595C10;
extern VTBL_ENTRY _ZTI8S3595C10[];
extern  VTBL_ENTRY _ZTV8S3595C10[];
extern Class_Descriptor cd_S3595C2;
extern VTBL_ENTRY _ZTI7S3595C2[];
extern  VTBL_ENTRY _ZTV7S3595C2[];
static Base_Class bases_S3595C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3595C10,    ABISELECT(48,32), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3595C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3595C1[];
extern void _ZN7S3595C1D1Ev();
extern void _ZN7S3595C1D0Ev();
extern void _ZN7S3595C23v26Ev();
extern void _ZN7S3595C12v1Ev();
extern void ABISELECT(_ZThn48_N7S3595C1D1Ev,_ZThn32_N7S3595C1D1Ev)();
extern void ABISELECT(_ZThn48_N7S3595C1D0Ev,_ZThn32_N7S3595C1D0Ev)();
extern void _ZN8S3595C102v2Ev();
extern void _ZN8S3595C102v3Ev();
extern void _ZN8S3595C102v4Ev();
extern void _ZN8S3595C102v5Ev();
extern void _ZN8S3595C102v6Ev();
extern void _ZN8S3595C102v7Ev();
extern void _ZN8S3595C102v8Ev();
extern void _ZN8S3595C102v9Ev();
extern void _ZN8S3595C103v10Ev();
extern void _ZN8S3595C103v11Ev();
extern void _ZN8S3595C103v12Ev();
extern void _ZN8S3595C103v13Ev();
extern void _ZN8S3595C103v14Ev();
extern void _ZN8S3595C103v15Ev();
extern void _ZN8S3595C103v16Ev();
extern void _ZN8S3595C103v17Ev();
extern void _ZN8S3595C103v18Ev();
extern void _ZN8S3595C103v19Ev();
extern void _ZN8S3595C103v20Ev();
extern void _ZN8S3595C103v21Ev();
extern void _ZN8S3595C103v22Ev();
extern void _ZN8S3595C103v23Ev();
extern void _ZN8S3595C103v24Ev();
extern void _ZN8S3595C103v25Ev();
static  VTBL_ENTRY vtc_S3595C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3595C1[0]),
  (VTBL_ENTRY)&_ZN7S3595C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3595C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3595C23v26Ev,
  (VTBL_ENTRY)&_ZN7S3595C12v1Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S3595C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3595C1D1Ev,_ZThn32_N7S3595C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3595C1D0Ev,_ZThn32_N7S3595C1D0Ev),
  (VTBL_ENTRY)&_ZN8S3595C102v2Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v3Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v4Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v5Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v6Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v7Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v8Ev,
  (VTBL_ENTRY)&_ZN8S3595C102v9Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v10Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v11Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v12Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v13Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v14Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v15Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v16Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v17Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v18Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v19Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v20Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v21Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v22Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v23Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v24Ev,
  (VTBL_ENTRY)&_ZN8S3595C103v25Ev,
};
extern VTBL_ENTRY _ZTI7S3595C1[];
extern  VTBL_ENTRY _ZTV7S3595C1[];
Class_Descriptor cd_S3595C1 = {  "S3595C1", // class name
  bases_S3595C1, 3,
  &(vtc_S3595C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,228), // object size
  NSPAIRA(_ZTI7S3595C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3595C1),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S644C5  {
  void *s644c5f0[2];
  ::S10103C13_nt s644c5f1;
  void *s644c5f2;
  virtual  ~S644C5(); // _ZN6S644C5D1Ev
  virtual void  v5(); // _ZN6S644C52v5Ev
  virtual void  v6(); // _ZN6S644C52v6Ev
  virtual void  v7(); // _ZN6S644C52v7Ev
  virtual void  v8(); // _ZN6S644C52v8Ev
  virtual void  v9(); // _ZN6S644C52v9Ev
  virtual void  v10(); // _ZN6S644C53v10Ev
  virtual void  v11(); // _ZN6S644C53v11Ev
  virtual void  v12(); // _ZN6S644C53v12Ev
  virtual void  v13(); // _ZN6S644C53v13Ev
  virtual void  v14(); // _ZN6S644C53v14Ev
  S644C5(); // tgen
};
//SIG(-1 S644C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S644C5 ::~S644C5(){ note_dtor("S644C5", this);}
void  S644C5 ::v5(){vfunc_called(this, "_ZN6S644C52v5Ev");}
void  S644C5 ::v6(){vfunc_called(this, "_ZN6S644C52v6Ev");}
void  S644C5 ::v7(){vfunc_called(this, "_ZN6S644C52v7Ev");}
void  S644C5 ::v8(){vfunc_called(this, "_ZN6S644C52v8Ev");}
void  S644C5 ::v9(){vfunc_called(this, "_ZN6S644C52v9Ev");}
void  S644C5 ::v10(){vfunc_called(this, "_ZN6S644C53v10Ev");}
void  S644C5 ::v11(){vfunc_called(this, "_ZN6S644C53v11Ev");}
void  S644C5 ::v12(){vfunc_called(this, "_ZN6S644C53v12Ev");}
void  S644C5 ::v13(){vfunc_called(this, "_ZN6S644C53v13Ev");}
void  S644C5 ::v14(){vfunc_called(this, "_ZN6S644C53v14Ev");}
S644C5 ::S644C5(){ note_ctor("S644C5", this);} // tgen

static void Test_S644C5()
{
  extern Class_Descriptor cd_S644C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S644C5, buf);
    S644C5 *dp, &lv = *(dp=new (buf) S644C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S644C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S644C5)");
    check_field_offset(lv, s644c5f0, ABISELECT(8,4), "S644C5.s644c5f0");
    check_field_offset(lv, s644c5f1, ABISELECT(24,12), "S644C5.s644c5f1");
    check_field_offset(lv, s644c5f2, ABISELECT(48,28), "S644C5.s644c5f2");
    test_class_info(&lv, &cd_S644C5);
    dp->~S644C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS644C5(Test_S644C5, "S644C5", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN6S644C5C1Ev();
extern void _ZN6S644C5D1Ev();
Name_Map name_map_S644C5[] = {
  NSPAIR(_ZN6S644C5C1Ev),
  NSPAIR(_ZN6S644C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S644C5[];
extern void _ZN6S644C5D1Ev();
extern void _ZN6S644C5D0Ev();
extern void _ZN6S644C52v5Ev();
extern void _ZN6S644C52v6Ev();
extern void _ZN6S644C52v7Ev();
extern void _ZN6S644C52v8Ev();
extern void _ZN6S644C52v9Ev();
extern void _ZN6S644C53v10Ev();
extern void _ZN6S644C53v11Ev();
extern void _ZN6S644C53v12Ev();
extern void _ZN6S644C53v13Ev();
extern void _ZN6S644C53v14Ev();
static  VTBL_ENTRY vtc_S644C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S644C5[0]),
  (VTBL_ENTRY)&_ZN6S644C5D1Ev,
  (VTBL_ENTRY)&_ZN6S644C5D0Ev,
  (VTBL_ENTRY)&_ZN6S644C52v5Ev,
  (VTBL_ENTRY)&_ZN6S644C52v6Ev,
  (VTBL_ENTRY)&_ZN6S644C52v7Ev,
  (VTBL_ENTRY)&_ZN6S644C52v8Ev,
  (VTBL_ENTRY)&_ZN6S644C52v9Ev,
  (VTBL_ENTRY)&_ZN6S644C53v10Ev,
  (VTBL_ENTRY)&_ZN6S644C53v11Ev,
  (VTBL_ENTRY)&_ZN6S644C53v12Ev,
  (VTBL_ENTRY)&_ZN6S644C53v13Ev,
  (VTBL_ENTRY)&_ZN6S644C53v14Ev,
};
extern VTBL_ENTRY _ZTI6S644C5[];
extern  VTBL_ENTRY _ZTV6S644C5[];
Class_Descriptor cd_S644C5 = {  "S644C5", // class name
  0,0,//no base classes
  &(vtc_S644C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI6S644C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S644C5),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S644C4  : S644C5 {
  void *s644c4f0;
  ::S10103C13_nt s644c4f1;
  ::S10103C13_nt s644c4f2;
  ::S10103C13_nt s644c4f3;
  ::S10103C86 s644c4f4;
  ::S10103C86 s644c4f5;
  ::S10103C86 s644c4f6;
  virtual  ~S644C4(); // _ZN6S644C4D1Ev
  virtual void  v15(); // _ZN6S644C43v15Ev
  virtual void  v16(); // _ZN6S644C43v16Ev
  virtual void  v17(); // _ZN6S644C43v17Ev
  virtual void  v18(); // _ZN6S644C43v18Ev
  virtual void  v19(); // _ZN6S644C43v19Ev
  S644C4(); // tgen
};
//SIG(-1 S644C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 Fp FC3 FC3 FC3 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC6 FC6}


 S644C4 ::~S644C4(){ note_dtor("S644C4", this);}
void  S644C4 ::v15(){vfunc_called(this, "_ZN6S644C43v15Ev");}
void  S644C4 ::v16(){vfunc_called(this, "_ZN6S644C43v16Ev");}
void  S644C4 ::v17(){vfunc_called(this, "_ZN6S644C43v17Ev");}
void  S644C4 ::v18(){vfunc_called(this, "_ZN6S644C43v18Ev");}
void  S644C4 ::v19(){vfunc_called(this, "_ZN6S644C43v19Ev");}
S644C4 ::S644C4(){ note_ctor("S644C4", this);} // tgen

static void Test_S644C4()
{
  extern Class_Descriptor cd_S644C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S644C4, buf);
    S644C4 *dp, &lv = *(dp=new (buf) S644C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S644C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S644C4)");
    check_base_class_offset(lv, (S644C5*), 0, "S644C4");
    check_field_offset(lv, s644c4f0, ABISELECT(56,32), "S644C4.s644c4f0");
    check_field_offset(lv, s644c4f1, ABISELECT(64,36), "S644C4.s644c4f1");
    check_field_offset(lv, s644c4f2, ABISELECT(88,52), "S644C4.s644c4f2");
    check_field_offset(lv, s644c4f3, ABISELECT(112,68), "S644C4.s644c4f3");
    check_field_offset(lv, s644c4f4, ABISELECT(136,84), "S644C4.s644c4f4");
    check_field_offset(lv, s644c4f5, ABISELECT(152,96), "S644C4.s644c4f5");
    check_field_offset(lv, s644c4f6, ABISELECT(168,108), "S644C4.s644c4f6");
    test_class_info(&lv, &cd_S644C4);
    dp->~S644C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS644C4(Test_S644C4, "S644C4", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN6S644C4C1Ev();
extern void _ZN6S644C4D1Ev();
Name_Map name_map_S644C4[] = {
  NSPAIR(_ZN6S644C4C1Ev),
  NSPAIR(_ZN6S644C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S644C5;
extern VTBL_ENTRY _ZTI6S644C5[];
extern  VTBL_ENTRY _ZTV6S644C5[];
static Base_Class bases_S644C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S644C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S644C4[];
extern void _ZN6S644C4D1Ev();
extern void _ZN6S644C4D0Ev();
extern void _ZN6S644C52v5Ev();
extern void _ZN6S644C52v6Ev();
extern void _ZN6S644C52v7Ev();
extern void _ZN6S644C52v8Ev();
extern void _ZN6S644C52v9Ev();
extern void _ZN6S644C53v10Ev();
extern void _ZN6S644C53v11Ev();
extern void _ZN6S644C53v12Ev();
extern void _ZN6S644C53v13Ev();
extern void _ZN6S644C53v14Ev();
extern void _ZN6S644C43v15Ev();
extern void _ZN6S644C43v16Ev();
extern void _ZN6S644C43v17Ev();
extern void _ZN6S644C43v18Ev();
extern void _ZN6S644C43v19Ev();
static  VTBL_ENTRY vtc_S644C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S644C4[0]),
  (VTBL_ENTRY)&_ZN6S644C4D1Ev,
  (VTBL_ENTRY)&_ZN6S644C4D0Ev,
  (VTBL_ENTRY)&_ZN6S644C52v5Ev,
  (VTBL_ENTRY)&_ZN6S644C52v6Ev,
  (VTBL_ENTRY)&_ZN6S644C52v7Ev,
  (VTBL_ENTRY)&_ZN6S644C52v8Ev,
  (VTBL_ENTRY)&_ZN6S644C52v9Ev,
  (VTBL_ENTRY)&_ZN6S644C53v10Ev,
  (VTBL_ENTRY)&_ZN6S644C53v11Ev,
  (VTBL_ENTRY)&_ZN6S644C53v12Ev,
  (VTBL_ENTRY)&_ZN6S644C53v13Ev,
  (VTBL_ENTRY)&_ZN6S644C53v14Ev,
  (VTBL_ENTRY)&_ZN6S644C43v15Ev,
  (VTBL_ENTRY)&_ZN6S644C43v16Ev,
  (VTBL_ENTRY)&_ZN6S644C43v17Ev,
  (VTBL_ENTRY)&_ZN6S644C43v18Ev,
  (VTBL_ENTRY)&_ZN6S644C43v19Ev,
};
extern VTBL_ENTRY _ZTI6S644C4[];
extern  VTBL_ENTRY _ZTV6S644C4[];
Class_Descriptor cd_S644C4 = {  "S644C4", // class name
  bases_S644C4, 1,
  &(vtc_S644C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,120), // object size
  NSPAIRA(_ZTI6S644C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S644C4),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S644C3  : S644C4 {
  char s644c3f0;
  virtual void  v20(); // _ZN6S644C33v20Ev
  virtual void  v21(); // _ZN6S644C33v21Ev
  virtual void  v22(); // _ZN6S644C33v22Ev
  virtual void  v23(); // _ZN6S644C33v23Ev
  ~S644C3(); // tgen
  S644C3(); // tgen
};
//SIG(-1 S644C3) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 Fp FC4 FC4 FC4 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC7 FC7} v1 v2 v3 v4 Fc}


void  S644C3 ::v20(){vfunc_called(this, "_ZN6S644C33v20Ev");}
void  S644C3 ::v21(){vfunc_called(this, "_ZN6S644C33v21Ev");}
void  S644C3 ::v22(){vfunc_called(this, "_ZN6S644C33v22Ev");}
void  S644C3 ::v23(){vfunc_called(this, "_ZN6S644C33v23Ev");}
S644C3 ::~S644C3(){ note_dtor("S644C3", this);} // tgen
S644C3 ::S644C3(){ note_ctor("S644C3", this);} // tgen

static void Test_S644C3()
{
  extern Class_Descriptor cd_S644C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,32)];
    init_test(&cd_S644C3, buf);
    S644C3 *dp, &lv = *(dp=new (buf) S644C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,124), "sizeof(S644C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S644C3)");
    check_base_class_offset(lv, (S644C5*)(S644C4*), 0, "S644C3");
    check_base_class_offset(lv, (S644C4*), 0, "S644C3");
    check_field_offset(lv, s644c3f0, ABISELECT(184,120), "S644C3.s644c3f0");
    test_class_info(&lv, &cd_S644C3);
    dp->~S644C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS644C3(Test_S644C3, "S644C3", ABISELECT(192,124));

#else // __cplusplus

extern void _ZN6S644C3C1Ev();
extern void _ZN6S644C3D1Ev();
Name_Map name_map_S644C3[] = {
  NSPAIR(_ZN6S644C3C1Ev),
  NSPAIR(_ZN6S644C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S644C5;
extern VTBL_ENTRY _ZTI6S644C5[];
extern  VTBL_ENTRY _ZTV6S644C5[];
extern Class_Descriptor cd_S644C4;
extern VTBL_ENTRY _ZTI6S644C4[];
extern  VTBL_ENTRY _ZTV6S644C4[];
static Base_Class bases_S644C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S644C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S644C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S644C3[];
extern void _ZN6S644C3D1Ev();
extern void _ZN6S644C3D0Ev();
extern void _ZN6S644C52v5Ev();
extern void _ZN6S644C52v6Ev();
extern void _ZN6S644C52v7Ev();
extern void _ZN6S644C52v8Ev();
extern void _ZN6S644C52v9Ev();
extern void _ZN6S644C53v10Ev();
extern void _ZN6S644C53v11Ev();
extern void _ZN6S644C53v12Ev();
extern void _ZN6S644C53v13Ev();
extern void _ZN6S644C53v14Ev();
extern void _ZN6S644C43v15Ev();
extern void _ZN6S644C43v16Ev();
extern void _ZN6S644C43v17Ev();
extern void _ZN6S644C43v18Ev();
extern void _ZN6S644C43v19Ev();
extern void _ZN6S644C33v20Ev();
extern void _ZN6S644C33v21Ev();
extern void _ZN6S644C33v22Ev();
extern void _ZN6S644C33v23Ev();
static  VTBL_ENTRY vtc_S644C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S644C3[0]),
  (VTBL_ENTRY)&_ZN6S644C3D1Ev,
  (VTBL_ENTRY)&_ZN6S644C3D0Ev,
  (VTBL_ENTRY)&_ZN6S644C52v5Ev,
  (VTBL_ENTRY)&_ZN6S644C52v6Ev,
  (VTBL_ENTRY)&_ZN6S644C52v7Ev,
  (VTBL_ENTRY)&_ZN6S644C52v8Ev,
  (VTBL_ENTRY)&_ZN6S644C52v9Ev,
  (VTBL_ENTRY)&_ZN6S644C53v10Ev,
  (VTBL_ENTRY)&_ZN6S644C53v11Ev,
  (VTBL_ENTRY)&_ZN6S644C53v12Ev,
  (VTBL_ENTRY)&_ZN6S644C53v13Ev,
  (VTBL_ENTRY)&_ZN6S644C53v14Ev,
  (VTBL_ENTRY)&_ZN6S644C43v15Ev,
  (VTBL_ENTRY)&_ZN6S644C43v16Ev,
  (VTBL_ENTRY)&_ZN6S644C43v17Ev,
  (VTBL_ENTRY)&_ZN6S644C43v18Ev,
  (VTBL_ENTRY)&_ZN6S644C43v19Ev,
  (VTBL_ENTRY)&_ZN6S644C33v20Ev,
  (VTBL_ENTRY)&_ZN6S644C33v21Ev,
  (VTBL_ENTRY)&_ZN6S644C33v22Ev,
  (VTBL_ENTRY)&_ZN6S644C33v23Ev,
};
extern VTBL_ENTRY _ZTI6S644C3[];
extern  VTBL_ENTRY _ZTV6S644C3[];
Class_Descriptor cd_S644C3 = {  "S644C3", // class name
  bases_S644C3, 2,
  &(vtc_S644C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,124), // object size
  NSPAIRA(_ZTI6S644C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S644C3),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S644C2  : S644C3 {
  char s644c2f0;
  int s644c2f1;
  virtual void  v24(); // _ZN6S644C23v24Ev
  virtual void  v25(); // _ZN6S644C23v25Ev
  virtual void  v26(); // _ZN6S644C23v26Ev
  virtual void  v27(); // _ZN6S644C23v27Ev
  ~S644C2(); // tgen
  S644C2(); // tgen
};
//SIG(-1 S644C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 Fp FC5 FC5 FC5 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC8 FC8} v20 v21 v22 v23 Fc} v1 v2 v3 v4 Fc Fi}


void  S644C2 ::v24(){vfunc_called(this, "_ZN6S644C23v24Ev");}
void  S644C2 ::v25(){vfunc_called(this, "_ZN6S644C23v25Ev");}
void  S644C2 ::v26(){vfunc_called(this, "_ZN6S644C23v26Ev");}
void  S644C2 ::v27(){vfunc_called(this, "_ZN6S644C23v27Ev");}
S644C2 ::~S644C2(){ note_dtor("S644C2", this);} // tgen
S644C2 ::S644C2(){ note_ctor("S644C2", this);} // tgen

static void Test_S644C2()
{
  extern Class_Descriptor cd_S644C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,33)];
    init_test(&cd_S644C2, buf);
    S644C2 *dp, &lv = *(dp=new (buf) S644C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,128), "sizeof(S644C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S644C2)");
    check_base_class_offset(lv, (S644C5*)(S644C4*)(S644C3*), 0, "S644C2");
    check_base_class_offset(lv, (S644C4*)(S644C3*), 0, "S644C2");
    check_base_class_offset(lv, (S644C3*), 0, "S644C2");
    check_field_offset(lv, s644c2f0, ABISELECT(185,121), "S644C2.s644c2f0");
    check_field_offset(lv, s644c2f1, ABISELECT(188,124), "S644C2.s644c2f1");
    test_class_info(&lv, &cd_S644C2);
    dp->~S644C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS644C2(Test_S644C2, "S644C2", ABISELECT(192,128));

#else // __cplusplus

extern void _ZN6S644C2C1Ev();
extern void _ZN6S644C2D1Ev();
Name_Map name_map_S644C2[] = {
  NSPAIR(_ZN6S644C2C1Ev),
  NSPAIR(_ZN6S644C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S644C5;
extern VTBL_ENTRY _ZTI6S644C5[];
extern  VTBL_ENTRY _ZTV6S644C5[];
extern Class_Descriptor cd_S644C4;
extern VTBL_ENTRY _ZTI6S644C4[];
extern  VTBL_ENTRY _ZTV6S644C4[];
extern Class_Descriptor cd_S644C3;
extern VTBL_ENTRY _ZTI6S644C3[];
extern  VTBL_ENTRY _ZTV6S644C3[];
static Base_Class bases_S644C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S644C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S644C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S644C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S644C2[];
extern void _ZN6S644C2D1Ev();
extern void _ZN6S644C2D0Ev();
extern void _ZN6S644C52v5Ev();
extern void _ZN6S644C52v6Ev();
extern void _ZN6S644C52v7Ev();
extern void _ZN6S644C52v8Ev();
extern void _ZN6S644C52v9Ev();
extern void _ZN6S644C53v10Ev();
extern void _ZN6S644C53v11Ev();
extern void _ZN6S644C53v12Ev();
extern void _ZN6S644C53v13Ev();
extern void _ZN6S644C53v14Ev();
extern void _ZN6S644C43v15Ev();
extern void _ZN6S644C43v16Ev();
extern void _ZN6S644C43v17Ev();
extern void _ZN6S644C43v18Ev();
extern void _ZN6S644C43v19Ev();
extern void _ZN6S644C33v20Ev();
extern void _ZN6S644C33v21Ev();
extern void _ZN6S644C33v22Ev();
extern void _ZN6S644C33v23Ev();
extern void _ZN6S644C23v24Ev();
extern void _ZN6S644C23v25Ev();
extern void _ZN6S644C23v26Ev();
extern void _ZN6S644C23v27Ev();
static  VTBL_ENTRY vtc_S644C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S644C2[0]),
  (VTBL_ENTRY)&_ZN6S644C2D1Ev,
  (VTBL_ENTRY)&_ZN6S644C2D0Ev,
  (VTBL_ENTRY)&_ZN6S644C52v5Ev,
  (VTBL_ENTRY)&_ZN6S644C52v6Ev,
  (VTBL_ENTRY)&_ZN6S644C52v7Ev,
  (VTBL_ENTRY)&_ZN6S644C52v8Ev,
  (VTBL_ENTRY)&_ZN6S644C52v9Ev,
  (VTBL_ENTRY)&_ZN6S644C53v10Ev,
  (VTBL_ENTRY)&_ZN6S644C53v11Ev,
  (VTBL_ENTRY)&_ZN6S644C53v12Ev,
  (VTBL_ENTRY)&_ZN6S644C53v13Ev,
  (VTBL_ENTRY)&_ZN6S644C53v14Ev,
  (VTBL_ENTRY)&_ZN6S644C43v15Ev,
  (VTBL_ENTRY)&_ZN6S644C43v16Ev,
  (VTBL_ENTRY)&_ZN6S644C43v17Ev,
  (VTBL_ENTRY)&_ZN6S644C43v18Ev,
  (VTBL_ENTRY)&_ZN6S644C43v19Ev,
  (VTBL_ENTRY)&_ZN6S644C33v20Ev,
  (VTBL_ENTRY)&_ZN6S644C33v21Ev,
  (VTBL_ENTRY)&_ZN6S644C33v22Ev,
  (VTBL_ENTRY)&_ZN6S644C33v23Ev,
  (VTBL_ENTRY)&_ZN6S644C23v24Ev,
  (VTBL_ENTRY)&_ZN6S644C23v25Ev,
  (VTBL_ENTRY)&_ZN6S644C23v26Ev,
  (VTBL_ENTRY)&_ZN6S644C23v27Ev,
};
extern VTBL_ENTRY _ZTI6S644C2[];
extern  VTBL_ENTRY _ZTV6S644C2[];
Class_Descriptor cd_S644C2 = {  "S644C2", // class name
  bases_S644C2, 3,
  &(vtc_S644C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,128), // object size
  NSPAIRA(_ZTI6S644C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S644C2),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S644C1  : S644C2 {
  ::S10103C82_nt s644c1f0;
  ::S10103C82_nt s644c1f1;
  ::S10103C82_nt s644c1f2;
  ::S10103C82_nt s644c1f3;
  ::S10103C82_nt s644c1f4;
  int s644c1f5;
  ::S10103C82_nt s644c1f6;
  ::S10103C82_nt s644c1f7;
  int s644c1f8[2];
  virtual  ~S644C1(); // _ZN6S644C1D1Ev
  virtual void  v1(); // _ZN6S644C12v1Ev
  virtual void  v2(); // _ZN6S644C12v2Ev
  virtual void  v3(); // _ZN6S644C12v3Ev
  virtual void  v4(); // _ZN6S644C12v4Ev
  S644C1(); // tgen
};
//SIG(1 S644C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 Fp FC6 FC6 FC6 FC9{ m Fp Fi FC10{ m} FC11{ m}} FC9 FC9} v20 v21 v22 v23 Fc} v24 v25 v26 v27 Fc Fi} vd v1 v2 v3 v4 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC12 FC12 Fi FC12 FC12 Fi[2]}


 S644C1 ::~S644C1(){ note_dtor("S644C1", this);}
void  S644C1 ::v1(){vfunc_called(this, "_ZN6S644C12v1Ev");}
void  S644C1 ::v2(){vfunc_called(this, "_ZN6S644C12v2Ev");}
void  S644C1 ::v3(){vfunc_called(this, "_ZN6S644C12v3Ev");}
void  S644C1 ::v4(){vfunc_called(this, "_ZN6S644C12v4Ev");}
S644C1 ::S644C1(){ note_ctor("S644C1", this);} // tgen

static void Test_S644C1()
{
  extern Class_Descriptor cd_S644C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,64)];
    init_test(&cd_S644C1, buf);
    S644C1 *dp, &lv = *(dp=new (buf) S644C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,252), "sizeof(S644C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S644C1)");
    check_base_class_offset(lv, (S644C5*)(S644C4*)(S644C3*)(S644C2*), 0, "S644C1");
    check_base_class_offset(lv, (S644C4*)(S644C3*)(S644C2*), 0, "S644C1");
    check_base_class_offset(lv, (S644C3*)(S644C2*), 0, "S644C1");
    check_base_class_offset(lv, (S644C2*), 0, "S644C1");
    check_field_offset(lv, s644c1f0, ABISELECT(192,128), "S644C1.s644c1f0");
    check_field_offset(lv, s644c1f1, ABISELECT(208,144), "S644C1.s644c1f1");
    check_field_offset(lv, s644c1f2, ABISELECT(224,160), "S644C1.s644c1f2");
    check_field_offset(lv, s644c1f3, ABISELECT(240,176), "S644C1.s644c1f3");
    check_field_offset(lv, s644c1f4, ABISELECT(256,192), "S644C1.s644c1f4");
    check_field_offset(lv, s644c1f5, ABISELECT(272,208), "S644C1.s644c1f5");
    check_field_offset(lv, s644c1f6, ABISELECT(280,212), "S644C1.s644c1f6");
    check_field_offset(lv, s644c1f7, ABISELECT(296,228), "S644C1.s644c1f7");
    check_field_offset(lv, s644c1f8, ABISELECT(312,244), "S644C1.s644c1f8");
    test_class_info(&lv, &cd_S644C1);
    dp->~S644C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS644C1(Test_S644C1, "S644C1", ABISELECT(320,252));

#else // __cplusplus

extern void _ZN6S644C1C1Ev();
extern void _ZN6S644C1D1Ev();
Name_Map name_map_S644C1[] = {
  NSPAIR(_ZN6S644C1C1Ev),
  NSPAIR(_ZN6S644C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S644C5;
extern VTBL_ENTRY _ZTI6S644C5[];
extern  VTBL_ENTRY _ZTV6S644C5[];
extern Class_Descriptor cd_S644C4;
extern VTBL_ENTRY _ZTI6S644C4[];
extern  VTBL_ENTRY _ZTV6S644C4[];
extern Class_Descriptor cd_S644C3;
extern VTBL_ENTRY _ZTI6S644C3[];
extern  VTBL_ENTRY _ZTV6S644C3[];
extern Class_Descriptor cd_S644C2;
extern VTBL_ENTRY _ZTI6S644C2[];
extern  VTBL_ENTRY _ZTV6S644C2[];
static Base_Class bases_S644C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S644C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S644C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S644C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S644C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S644C1[];
extern void _ZN6S644C1D1Ev();
extern void _ZN6S644C1D0Ev();
extern void _ZN6S644C52v5Ev();
extern void _ZN6S644C52v6Ev();
extern void _ZN6S644C52v7Ev();
extern void _ZN6S644C52v8Ev();
extern void _ZN6S644C52v9Ev();
extern void _ZN6S644C53v10Ev();
extern void _ZN6S644C53v11Ev();
extern void _ZN6S644C53v12Ev();
extern void _ZN6S644C53v13Ev();
extern void _ZN6S644C53v14Ev();
extern void _ZN6S644C43v15Ev();
extern void _ZN6S644C43v16Ev();
extern void _ZN6S644C43v17Ev();
extern void _ZN6S644C43v18Ev();
extern void _ZN6S644C43v19Ev();
extern void _ZN6S644C33v20Ev();
extern void _ZN6S644C33v21Ev();
extern void _ZN6S644C33v22Ev();
extern void _ZN6S644C33v23Ev();
extern void _ZN6S644C23v24Ev();
extern void _ZN6S644C23v25Ev();
extern void _ZN6S644C23v26Ev();
extern void _ZN6S644C23v27Ev();
extern void _ZN6S644C12v1Ev();
extern void _ZN6S644C12v2Ev();
extern void _ZN6S644C12v3Ev();
extern void _ZN6S644C12v4Ev();
static  VTBL_ENTRY vtc_S644C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S644C1[0]),
  (VTBL_ENTRY)&_ZN6S644C1D1Ev,
  (VTBL_ENTRY)&_ZN6S644C1D0Ev,
  (VTBL_ENTRY)&_ZN6S644C52v5Ev,
  (VTBL_ENTRY)&_ZN6S644C52v6Ev,
  (VTBL_ENTRY)&_ZN6S644C52v7Ev,
  (VTBL_ENTRY)&_ZN6S644C52v8Ev,
  (VTBL_ENTRY)&_ZN6S644C52v9Ev,
  (VTBL_ENTRY)&_ZN6S644C53v10Ev,
  (VTBL_ENTRY)&_ZN6S644C53v11Ev,
  (VTBL_ENTRY)&_ZN6S644C53v12Ev,
  (VTBL_ENTRY)&_ZN6S644C53v13Ev,
  (VTBL_ENTRY)&_ZN6S644C53v14Ev,
  (VTBL_ENTRY)&_ZN6S644C43v15Ev,
  (VTBL_ENTRY)&_ZN6S644C43v16Ev,
  (VTBL_ENTRY)&_ZN6S644C43v17Ev,
  (VTBL_ENTRY)&_ZN6S644C43v18Ev,
  (VTBL_ENTRY)&_ZN6S644C43v19Ev,
  (VTBL_ENTRY)&_ZN6S644C33v20Ev,
  (VTBL_ENTRY)&_ZN6S644C33v21Ev,
  (VTBL_ENTRY)&_ZN6S644C33v22Ev,
  (VTBL_ENTRY)&_ZN6S644C33v23Ev,
  (VTBL_ENTRY)&_ZN6S644C23v24Ev,
  (VTBL_ENTRY)&_ZN6S644C23v25Ev,
  (VTBL_ENTRY)&_ZN6S644C23v26Ev,
  (VTBL_ENTRY)&_ZN6S644C23v27Ev,
  (VTBL_ENTRY)&_ZN6S644C12v1Ev,
  (VTBL_ENTRY)&_ZN6S644C12v2Ev,
  (VTBL_ENTRY)&_ZN6S644C12v3Ev,
  (VTBL_ENTRY)&_ZN6S644C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S644C1[];
extern  VTBL_ENTRY _ZTV6S644C1[];
Class_Descriptor cd_S644C1 = {  "S644C1", // class name
  bases_S644C1, 4,
  &(vtc_S644C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,252), // object size
  NSPAIRA(_ZTI6S644C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S644C1),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1490C4  {
  void *s1490c4f0[2];
  ::S10103C13_nt s1490c4f1;
  void *s1490c4f2;
  virtual  ~S1490C4(); // _ZN7S1490C4D1Ev
  virtual void  v5(); // _ZN7S1490C42v5Ev
  virtual void  v6(); // _ZN7S1490C42v6Ev
  virtual void  v7(); // _ZN7S1490C42v7Ev
  virtual void  v8(); // _ZN7S1490C42v8Ev
  virtual void  v9(); // _ZN7S1490C42v9Ev
  virtual void  v10(); // _ZN7S1490C43v10Ev
  virtual void  v11(); // _ZN7S1490C43v11Ev
  virtual void  v12(); // _ZN7S1490C43v12Ev
  virtual void  v13(); // _ZN7S1490C43v13Ev
  virtual void  v14(); // _ZN7S1490C43v14Ev
  S1490C4(); // tgen
};
//SIG(-1 S1490C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1490C4 ::~S1490C4(){ note_dtor("S1490C4", this);}
void  S1490C4 ::v5(){vfunc_called(this, "_ZN7S1490C42v5Ev");}
void  S1490C4 ::v6(){vfunc_called(this, "_ZN7S1490C42v6Ev");}
void  S1490C4 ::v7(){vfunc_called(this, "_ZN7S1490C42v7Ev");}
void  S1490C4 ::v8(){vfunc_called(this, "_ZN7S1490C42v8Ev");}
void  S1490C4 ::v9(){vfunc_called(this, "_ZN7S1490C42v9Ev");}
void  S1490C4 ::v10(){vfunc_called(this, "_ZN7S1490C43v10Ev");}
void  S1490C4 ::v11(){vfunc_called(this, "_ZN7S1490C43v11Ev");}
void  S1490C4 ::v12(){vfunc_called(this, "_ZN7S1490C43v12Ev");}
void  S1490C4 ::v13(){vfunc_called(this, "_ZN7S1490C43v13Ev");}
void  S1490C4 ::v14(){vfunc_called(this, "_ZN7S1490C43v14Ev");}
S1490C4 ::S1490C4(){ note_ctor("S1490C4", this);} // tgen

static void Test_S1490C4()
{
  extern Class_Descriptor cd_S1490C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1490C4, buf);
    S1490C4 *dp, &lv = *(dp=new (buf) S1490C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1490C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1490C4)");
    check_field_offset(lv, s1490c4f0, ABISELECT(8,4), "S1490C4.s1490c4f0");
    check_field_offset(lv, s1490c4f1, ABISELECT(24,12), "S1490C4.s1490c4f1");
    check_field_offset(lv, s1490c4f2, ABISELECT(48,28), "S1490C4.s1490c4f2");
    test_class_info(&lv, &cd_S1490C4);
    dp->~S1490C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1490C4(Test_S1490C4, "S1490C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1490C4C1Ev();
extern void _ZN7S1490C4D1Ev();
Name_Map name_map_S1490C4[] = {
  NSPAIR(_ZN7S1490C4C1Ev),
  NSPAIR(_ZN7S1490C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1490C4[];
extern void _ZN7S1490C4D1Ev();
extern void _ZN7S1490C4D0Ev();
extern void _ZN7S1490C42v5Ev();
extern void _ZN7S1490C42v6Ev();
extern void _ZN7S1490C42v7Ev();
extern void _ZN7S1490C42v8Ev();
extern void _ZN7S1490C42v9Ev();
extern void _ZN7S1490C43v10Ev();
extern void _ZN7S1490C43v11Ev();
extern void _ZN7S1490C43v12Ev();
extern void _ZN7S1490C43v13Ev();
extern void _ZN7S1490C43v14Ev();
static  VTBL_ENTRY vtc_S1490C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1490C4[0]),
  (VTBL_ENTRY)&_ZN7S1490C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1490C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S1490C4[];
extern  VTBL_ENTRY _ZTV7S1490C4[];
Class_Descriptor cd_S1490C4 = {  "S1490C4", // class name
  0,0,//no base classes
  &(vtc_S1490C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1490C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1490C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1490C3  : S1490C4 {
  ::S10103C86 s1490c3f0;
  ::S10103C106 s1490c3f1;
  ::S10103C82_nt s1490c3f2;
  ::S10103C13_nt s1490c3f3;
  virtual  ~S1490C3(); // _ZN7S1490C3D1Ev
  virtual void  v15(); // _ZN7S1490C33v15Ev
  virtual void  v16(); // _ZN7S1490C33v16Ev
  virtual void  v17(); // _ZN7S1490C33v17Ev
  virtual void  v18(); // _ZN7S1490C33v18Ev
  virtual void  v19(); // _ZN7S1490C33v19Ev
  virtual void  v20(); // _ZN7S1490C33v20Ev
  virtual void  v21(); // _ZN7S1490C33v21Ev
  virtual void  v22(); // _ZN7S1490C33v22Ev
  virtual void  v23(); // _ZN7S1490C33v23Ev
  virtual void  v24(); // _ZN7S1490C33v24Ev
  virtual void  v25(); // _ZN7S1490C33v25Ev
  virtual void  v26(); // _ZN7S1490C33v26Ev
  virtual void  v27(); // _ZN7S1490C33v27Ev
  virtual void  v28(); // _ZN7S1490C33v28Ev
  S1490C3(); // tgen
};
//SIG(-1 S1490C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC9{ m Fp Fi[2] FC8} FC10{ m FC11{ m FL[2]}} FC3}


 S1490C3 ::~S1490C3(){ note_dtor("S1490C3", this);}
void  S1490C3 ::v15(){vfunc_called(this, "_ZN7S1490C33v15Ev");}
void  S1490C3 ::v16(){vfunc_called(this, "_ZN7S1490C33v16Ev");}
void  S1490C3 ::v17(){vfunc_called(this, "_ZN7S1490C33v17Ev");}
void  S1490C3 ::v18(){vfunc_called(this, "_ZN7S1490C33v18Ev");}
void  S1490C3 ::v19(){vfunc_called(this, "_ZN7S1490C33v19Ev");}
void  S1490C3 ::v20(){vfunc_called(this, "_ZN7S1490C33v20Ev");}
void  S1490C3 ::v21(){vfunc_called(this, "_ZN7S1490C33v21Ev");}
void  S1490C3 ::v22(){vfunc_called(this, "_ZN7S1490C33v22Ev");}
void  S1490C3 ::v23(){vfunc_called(this, "_ZN7S1490C33v23Ev");}
void  S1490C3 ::v24(){vfunc_called(this, "_ZN7S1490C33v24Ev");}
void  S1490C3 ::v25(){vfunc_called(this, "_ZN7S1490C33v25Ev");}
void  S1490C3 ::v26(){vfunc_called(this, "_ZN7S1490C33v26Ev");}
void  S1490C3 ::v27(){vfunc_called(this, "_ZN7S1490C33v27Ev");}
void  S1490C3 ::v28(){vfunc_called(this, "_ZN7S1490C33v28Ev");}
S1490C3 ::S1490C3(){ note_ctor("S1490C3", this);} // tgen

static void Test_S1490C3()
{
  extern Class_Descriptor cd_S1490C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S1490C3, buf);
    S1490C3 *dp, &lv = *(dp=new (buf) S1490C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S1490C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1490C3)");
    check_base_class_offset(lv, (S1490C4*), 0, "S1490C3");
    check_field_offset(lv, s1490c3f0, ABISELECT(56,32), "S1490C3.s1490c3f0");
    check_field_offset(lv, s1490c3f1, ABISELECT(72,44), "S1490C3.s1490c3f1");
    check_field_offset(lv, s1490c3f2, ABISELECT(96,60), "S1490C3.s1490c3f2");
    check_field_offset(lv, s1490c3f3, ABISELECT(112,76), "S1490C3.s1490c3f3");
    test_class_info(&lv, &cd_S1490C3);
    dp->~S1490C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1490C3(Test_S1490C3, "S1490C3", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN7S1490C3C1Ev();
extern void _ZN7S1490C3D1Ev();
Name_Map name_map_S1490C3[] = {
  NSPAIR(_ZN7S1490C3C1Ev),
  NSPAIR(_ZN7S1490C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1490C4;
extern VTBL_ENTRY _ZTI7S1490C4[];
extern  VTBL_ENTRY _ZTV7S1490C4[];
static Base_Class bases_S1490C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1490C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1490C3[];
extern void _ZN7S1490C3D1Ev();
extern void _ZN7S1490C3D0Ev();
extern void _ZN7S1490C42v5Ev();
extern void _ZN7S1490C42v6Ev();
extern void _ZN7S1490C42v7Ev();
extern void _ZN7S1490C42v8Ev();
extern void _ZN7S1490C42v9Ev();
extern void _ZN7S1490C43v10Ev();
extern void _ZN7S1490C43v11Ev();
extern void _ZN7S1490C43v12Ev();
extern void _ZN7S1490C43v13Ev();
extern void _ZN7S1490C43v14Ev();
extern void _ZN7S1490C33v15Ev();
extern void _ZN7S1490C33v16Ev();
extern void _ZN7S1490C33v17Ev();
extern void _ZN7S1490C33v18Ev();
extern void _ZN7S1490C33v19Ev();
extern void _ZN7S1490C33v20Ev();
extern void _ZN7S1490C33v21Ev();
extern void _ZN7S1490C33v22Ev();
extern void _ZN7S1490C33v23Ev();
extern void _ZN7S1490C33v24Ev();
extern void _ZN7S1490C33v25Ev();
extern void _ZN7S1490C33v26Ev();
extern void _ZN7S1490C33v27Ev();
extern void _ZN7S1490C33v28Ev();
static  VTBL_ENTRY vtc_S1490C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1490C3[0]),
  (VTBL_ENTRY)&_ZN7S1490C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1490C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v28Ev,
};
extern VTBL_ENTRY _ZTI7S1490C3[];
extern  VTBL_ENTRY _ZTV7S1490C3[];
Class_Descriptor cd_S1490C3 = {  "S1490C3", // class name
  bases_S1490C3, 1,
  &(vtc_S1490C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI7S1490C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1490C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1490C2  : S1490C3 {
  int s1490c2f0;
  char s1490c2f1[2];
  int s1490c2f2;
  virtual void  v29(); // _ZN7S1490C23v29Ev
  virtual void  v30(); // _ZN7S1490C23v30Ev
  virtual void  v31(); // _ZN7S1490C23v31Ev
  virtual void  v32(); // _ZN7S1490C23v32Ev
  ~S1490C2(); // tgen
  S1490C2(); // tgen
};
//SIG(-1 S1490C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC10{ m Fp Fi[2] FC9} FC11{ m FC12{ m FL[2]}} FC4} v1 v2 v3 v4 Fi Fc[2] Fi}


void  S1490C2 ::v29(){vfunc_called(this, "_ZN7S1490C23v29Ev");}
void  S1490C2 ::v30(){vfunc_called(this, "_ZN7S1490C23v30Ev");}
void  S1490C2 ::v31(){vfunc_called(this, "_ZN7S1490C23v31Ev");}
void  S1490C2 ::v32(){vfunc_called(this, "_ZN7S1490C23v32Ev");}
S1490C2 ::~S1490C2(){ note_dtor("S1490C2", this);} // tgen
S1490C2 ::S1490C2(){ note_ctor("S1490C2", this);} // tgen

static void Test_S1490C2()
{
  extern Class_Descriptor cd_S1490C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S1490C2, buf);
    S1490C2 *dp, &lv = *(dp=new (buf) S1490C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S1490C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1490C2)");
    check_base_class_offset(lv, (S1490C4*)(S1490C3*), 0, "S1490C2");
    check_base_class_offset(lv, (S1490C3*), 0, "S1490C2");
    check_field_offset(lv, s1490c2f0, ABISELECT(136,92), "S1490C2.s1490c2f0");
    check_field_offset(lv, s1490c2f1, ABISELECT(140,96), "S1490C2.s1490c2f1");
    check_field_offset(lv, s1490c2f2, ABISELECT(144,100), "S1490C2.s1490c2f2");
    test_class_info(&lv, &cd_S1490C2);
    dp->~S1490C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1490C2(Test_S1490C2, "S1490C2", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN7S1490C2C1Ev();
extern void _ZN7S1490C2D1Ev();
Name_Map name_map_S1490C2[] = {
  NSPAIR(_ZN7S1490C2C1Ev),
  NSPAIR(_ZN7S1490C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1490C4;
extern VTBL_ENTRY _ZTI7S1490C4[];
extern  VTBL_ENTRY _ZTV7S1490C4[];
extern Class_Descriptor cd_S1490C3;
extern VTBL_ENTRY _ZTI7S1490C3[];
extern  VTBL_ENTRY _ZTV7S1490C3[];
static Base_Class bases_S1490C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1490C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1490C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1490C2[];
extern void _ZN7S1490C2D1Ev();
extern void _ZN7S1490C2D0Ev();
extern void _ZN7S1490C42v5Ev();
extern void _ZN7S1490C42v6Ev();
extern void _ZN7S1490C42v7Ev();
extern void _ZN7S1490C42v8Ev();
extern void _ZN7S1490C42v9Ev();
extern void _ZN7S1490C43v10Ev();
extern void _ZN7S1490C43v11Ev();
extern void _ZN7S1490C43v12Ev();
extern void _ZN7S1490C43v13Ev();
extern void _ZN7S1490C43v14Ev();
extern void _ZN7S1490C33v15Ev();
extern void _ZN7S1490C33v16Ev();
extern void _ZN7S1490C33v17Ev();
extern void _ZN7S1490C33v18Ev();
extern void _ZN7S1490C33v19Ev();
extern void _ZN7S1490C33v20Ev();
extern void _ZN7S1490C33v21Ev();
extern void _ZN7S1490C33v22Ev();
extern void _ZN7S1490C33v23Ev();
extern void _ZN7S1490C33v24Ev();
extern void _ZN7S1490C33v25Ev();
extern void _ZN7S1490C33v26Ev();
extern void _ZN7S1490C33v27Ev();
extern void _ZN7S1490C33v28Ev();
extern void _ZN7S1490C23v29Ev();
extern void _ZN7S1490C23v30Ev();
extern void _ZN7S1490C23v31Ev();
extern void _ZN7S1490C23v32Ev();
static  VTBL_ENTRY vtc_S1490C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1490C2[0]),
  (VTBL_ENTRY)&_ZN7S1490C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1490C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v32Ev,
};
extern VTBL_ENTRY _ZTI7S1490C2[];
extern  VTBL_ENTRY _ZTV7S1490C2[];
Class_Descriptor cd_S1490C2 = {  "S1490C2", // class name
  bases_S1490C2, 2,
  &(vtc_S1490C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI7S1490C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1490C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1490C1  : S1490C2 {
  int s1490c1f0[2];
  virtual  ~S1490C1(); // _ZN7S1490C1D1Ev
  virtual void  v1(); // _ZN7S1490C12v1Ev
  virtual void  v2(); // _ZN7S1490C12v2Ev
  virtual void  v3(); // _ZN7S1490C12v3Ev
  virtual void  v4(); // _ZN7S1490C12v4Ev
  S1490C1(); // tgen
};
//SIG(1 S1490C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC11{ m Fp Fi[2] FC10} FC12{ m FC13{ m FL[2]}} FC5} v29 v30 v31 v32 Fi Fc[2] Fi} vd v1 v2 v3 v4 Fi[2]}


 S1490C1 ::~S1490C1(){ note_dtor("S1490C1", this);}
void  S1490C1 ::v1(){vfunc_called(this, "_ZN7S1490C12v1Ev");}
void  S1490C1 ::v2(){vfunc_called(this, "_ZN7S1490C12v2Ev");}
void  S1490C1 ::v3(){vfunc_called(this, "_ZN7S1490C12v3Ev");}
void  S1490C1 ::v4(){vfunc_called(this, "_ZN7S1490C12v4Ev");}
S1490C1 ::S1490C1(){ note_ctor("S1490C1", this);} // tgen

static void Test_S1490C1()
{
  extern Class_Descriptor cd_S1490C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,29)];
    init_test(&cd_S1490C1, buf);
    S1490C1 *dp, &lv = *(dp=new (buf) S1490C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,112), "sizeof(S1490C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1490C1)");
    check_base_class_offset(lv, (S1490C4*)(S1490C3*)(S1490C2*), 0, "S1490C1");
    check_base_class_offset(lv, (S1490C3*)(S1490C2*), 0, "S1490C1");
    check_base_class_offset(lv, (S1490C2*), 0, "S1490C1");
    check_field_offset(lv, s1490c1f0, ABISELECT(148,104), "S1490C1.s1490c1f0");
    test_class_info(&lv, &cd_S1490C1);
    dp->~S1490C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1490C1(Test_S1490C1, "S1490C1", ABISELECT(160,112));

#else // __cplusplus

extern void _ZN7S1490C1C1Ev();
extern void _ZN7S1490C1D1Ev();
Name_Map name_map_S1490C1[] = {
  NSPAIR(_ZN7S1490C1C1Ev),
  NSPAIR(_ZN7S1490C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1490C4;
extern VTBL_ENTRY _ZTI7S1490C4[];
extern  VTBL_ENTRY _ZTV7S1490C4[];
extern Class_Descriptor cd_S1490C3;
extern VTBL_ENTRY _ZTI7S1490C3[];
extern  VTBL_ENTRY _ZTV7S1490C3[];
extern Class_Descriptor cd_S1490C2;
extern VTBL_ENTRY _ZTI7S1490C2[];
extern  VTBL_ENTRY _ZTV7S1490C2[];
static Base_Class bases_S1490C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1490C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1490C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1490C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1490C1[];
extern void _ZN7S1490C1D1Ev();
extern void _ZN7S1490C1D0Ev();
extern void _ZN7S1490C42v5Ev();
extern void _ZN7S1490C42v6Ev();
extern void _ZN7S1490C42v7Ev();
extern void _ZN7S1490C42v8Ev();
extern void _ZN7S1490C42v9Ev();
extern void _ZN7S1490C43v10Ev();
extern void _ZN7S1490C43v11Ev();
extern void _ZN7S1490C43v12Ev();
extern void _ZN7S1490C43v13Ev();
extern void _ZN7S1490C43v14Ev();
extern void _ZN7S1490C33v15Ev();
extern void _ZN7S1490C33v16Ev();
extern void _ZN7S1490C33v17Ev();
extern void _ZN7S1490C33v18Ev();
extern void _ZN7S1490C33v19Ev();
extern void _ZN7S1490C33v20Ev();
extern void _ZN7S1490C33v21Ev();
extern void _ZN7S1490C33v22Ev();
extern void _ZN7S1490C33v23Ev();
extern void _ZN7S1490C33v24Ev();
extern void _ZN7S1490C33v25Ev();
extern void _ZN7S1490C33v26Ev();
extern void _ZN7S1490C33v27Ev();
extern void _ZN7S1490C33v28Ev();
extern void _ZN7S1490C23v29Ev();
extern void _ZN7S1490C23v30Ev();
extern void _ZN7S1490C23v31Ev();
extern void _ZN7S1490C23v32Ev();
extern void _ZN7S1490C12v1Ev();
extern void _ZN7S1490C12v2Ev();
extern void _ZN7S1490C12v3Ev();
extern void _ZN7S1490C12v4Ev();
static  VTBL_ENTRY vtc_S1490C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1490C1[0]),
  (VTBL_ENTRY)&_ZN7S1490C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1490C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1490C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1490C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v20Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v21Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1490C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v29Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v30Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v31Ev,
  (VTBL_ENTRY)&_ZN7S1490C23v32Ev,
  (VTBL_ENTRY)&_ZN7S1490C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1490C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1490C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1490C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S1490C1[];
extern  VTBL_ENTRY _ZTV7S1490C1[];
Class_Descriptor cd_S1490C1 = {  "S1490C1", // class name
  bases_S1490C1, 3,
  &(vtc_S1490C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,112), // object size
  NSPAIRA(_ZTI7S1490C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1490C1),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1482C4  {
  void *s1482c4f0[2];
  ::S10103C13_nt s1482c4f1;
  void *s1482c4f2;
  virtual  ~S1482C4(); // _ZN7S1482C4D1Ev
  virtual void  v5(); // _ZN7S1482C42v5Ev
  virtual void  v6(); // _ZN7S1482C42v6Ev
  virtual void  v7(); // _ZN7S1482C42v7Ev
  virtual void  v8(); // _ZN7S1482C42v8Ev
  virtual void  v9(); // _ZN7S1482C42v9Ev
  virtual void  v10(); // _ZN7S1482C43v10Ev
  virtual void  v11(); // _ZN7S1482C43v11Ev
  virtual void  v12(); // _ZN7S1482C43v12Ev
  virtual void  v13(); // _ZN7S1482C43v13Ev
  virtual void  v14(); // _ZN7S1482C43v14Ev
  S1482C4(); // tgen
};
//SIG(-1 S1482C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S1482C4 ::~S1482C4(){ note_dtor("S1482C4", this);}
void  S1482C4 ::v5(){vfunc_called(this, "_ZN7S1482C42v5Ev");}
void  S1482C4 ::v6(){vfunc_called(this, "_ZN7S1482C42v6Ev");}
void  S1482C4 ::v7(){vfunc_called(this, "_ZN7S1482C42v7Ev");}
void  S1482C4 ::v8(){vfunc_called(this, "_ZN7S1482C42v8Ev");}
void  S1482C4 ::v9(){vfunc_called(this, "_ZN7S1482C42v9Ev");}
void  S1482C4 ::v10(){vfunc_called(this, "_ZN7S1482C43v10Ev");}
void  S1482C4 ::v11(){vfunc_called(this, "_ZN7S1482C43v11Ev");}
void  S1482C4 ::v12(){vfunc_called(this, "_ZN7S1482C43v12Ev");}
void  S1482C4 ::v13(){vfunc_called(this, "_ZN7S1482C43v13Ev");}
void  S1482C4 ::v14(){vfunc_called(this, "_ZN7S1482C43v14Ev");}
S1482C4 ::S1482C4(){ note_ctor("S1482C4", this);} // tgen

static void Test_S1482C4()
{
  extern Class_Descriptor cd_S1482C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S1482C4, buf);
    S1482C4 *dp, &lv = *(dp=new (buf) S1482C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S1482C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1482C4)");
    check_field_offset(lv, s1482c4f0, ABISELECT(8,4), "S1482C4.s1482c4f0");
    check_field_offset(lv, s1482c4f1, ABISELECT(24,12), "S1482C4.s1482c4f1");
    check_field_offset(lv, s1482c4f2, ABISELECT(48,28), "S1482C4.s1482c4f2");
    test_class_info(&lv, &cd_S1482C4);
    dp->~S1482C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1482C4(Test_S1482C4, "S1482C4", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S1482C4C1Ev();
extern void _ZN7S1482C4D1Ev();
Name_Map name_map_S1482C4[] = {
  NSPAIR(_ZN7S1482C4C1Ev),
  NSPAIR(_ZN7S1482C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1482C4[];
extern void _ZN7S1482C4D1Ev();
extern void _ZN7S1482C4D0Ev();
extern void _ZN7S1482C42v5Ev();
extern void _ZN7S1482C42v6Ev();
extern void _ZN7S1482C42v7Ev();
extern void _ZN7S1482C42v8Ev();
extern void _ZN7S1482C42v9Ev();
extern void _ZN7S1482C43v10Ev();
extern void _ZN7S1482C43v11Ev();
extern void _ZN7S1482C43v12Ev();
extern void _ZN7S1482C43v13Ev();
extern void _ZN7S1482C43v14Ev();
static  VTBL_ENTRY vtc_S1482C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1482C4[0]),
  (VTBL_ENTRY)&_ZN7S1482C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1482C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S1482C4[];
extern  VTBL_ENTRY _ZTV7S1482C4[];
Class_Descriptor cd_S1482C4 = {  "S1482C4", // class name
  0,0,//no base classes
  &(vtc_S1482C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S1482C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1482C4),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1482C3  : S1482C4 {
  void *s1482c3f0;
  ::S10103C13_nt s1482c3f1;
  ::S10103C13_nt s1482c3f2;
  ::S10103C13_nt s1482c3f3;
  ::S10103C86 s1482c3f4;
  ::S10103C86 s1482c3f5;
  ::S10103C86 s1482c3f6;
  virtual  ~S1482C3(); // _ZN7S1482C3D1Ev
  virtual void  v15(); // _ZN7S1482C33v15Ev
  virtual void  v16(); // _ZN7S1482C33v16Ev
  virtual void  v17(); // _ZN7S1482C33v17Ev
  virtual void  v18(); // _ZN7S1482C33v18Ev
  virtual void  v19(); // _ZN7S1482C33v19Ev
  S1482C3(); // tgen
};
//SIG(-1 S1482C3) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 Fp FC3 FC3 FC3 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC6 FC6}


 S1482C3 ::~S1482C3(){ note_dtor("S1482C3", this);}
void  S1482C3 ::v15(){vfunc_called(this, "_ZN7S1482C33v15Ev");}
void  S1482C3 ::v16(){vfunc_called(this, "_ZN7S1482C33v16Ev");}
void  S1482C3 ::v17(){vfunc_called(this, "_ZN7S1482C33v17Ev");}
void  S1482C3 ::v18(){vfunc_called(this, "_ZN7S1482C33v18Ev");}
void  S1482C3 ::v19(){vfunc_called(this, "_ZN7S1482C33v19Ev");}
S1482C3 ::S1482C3(){ note_ctor("S1482C3", this);} // tgen

static void Test_S1482C3()
{
  extern Class_Descriptor cd_S1482C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S1482C3, buf);
    S1482C3 *dp, &lv = *(dp=new (buf) S1482C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S1482C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1482C3)");
    check_base_class_offset(lv, (S1482C4*), 0, "S1482C3");
    check_field_offset(lv, s1482c3f0, ABISELECT(56,32), "S1482C3.s1482c3f0");
    check_field_offset(lv, s1482c3f1, ABISELECT(64,36), "S1482C3.s1482c3f1");
    check_field_offset(lv, s1482c3f2, ABISELECT(88,52), "S1482C3.s1482c3f2");
    check_field_offset(lv, s1482c3f3, ABISELECT(112,68), "S1482C3.s1482c3f3");
    check_field_offset(lv, s1482c3f4, ABISELECT(136,84), "S1482C3.s1482c3f4");
    check_field_offset(lv, s1482c3f5, ABISELECT(152,96), "S1482C3.s1482c3f5");
    check_field_offset(lv, s1482c3f6, ABISELECT(168,108), "S1482C3.s1482c3f6");
    test_class_info(&lv, &cd_S1482C3);
    dp->~S1482C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1482C3(Test_S1482C3, "S1482C3", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN7S1482C3C1Ev();
extern void _ZN7S1482C3D1Ev();
Name_Map name_map_S1482C3[] = {
  NSPAIR(_ZN7S1482C3C1Ev),
  NSPAIR(_ZN7S1482C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1482C4;
extern VTBL_ENTRY _ZTI7S1482C4[];
extern  VTBL_ENTRY _ZTV7S1482C4[];
static Base_Class bases_S1482C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1482C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1482C3[];
extern void _ZN7S1482C3D1Ev();
extern void _ZN7S1482C3D0Ev();
extern void _ZN7S1482C42v5Ev();
extern void _ZN7S1482C42v6Ev();
extern void _ZN7S1482C42v7Ev();
extern void _ZN7S1482C42v8Ev();
extern void _ZN7S1482C42v9Ev();
extern void _ZN7S1482C43v10Ev();
extern void _ZN7S1482C43v11Ev();
extern void _ZN7S1482C43v12Ev();
extern void _ZN7S1482C43v13Ev();
extern void _ZN7S1482C43v14Ev();
extern void _ZN7S1482C33v15Ev();
extern void _ZN7S1482C33v16Ev();
extern void _ZN7S1482C33v17Ev();
extern void _ZN7S1482C33v18Ev();
extern void _ZN7S1482C33v19Ev();
static  VTBL_ENTRY vtc_S1482C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1482C3[0]),
  (VTBL_ENTRY)&_ZN7S1482C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1482C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v19Ev,
};
extern VTBL_ENTRY _ZTI7S1482C3[];
extern  VTBL_ENTRY _ZTV7S1482C3[];
Class_Descriptor cd_S1482C3 = {  "S1482C3", // class name
  bases_S1482C3, 1,
  &(vtc_S1482C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,120), // object size
  NSPAIRA(_ZTI7S1482C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1482C3),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1482C2  : S1482C3 {
  char s1482c2f0;
  int s1482c2f1[4];
  ::S10103C13_nt s1482c2f2;
  ::S10103C13_nt s1482c2f3;
  char s1482c2f4;
  ::S10103C13_nt s1482c2f5;
  char s1482c2f6;
  virtual  ~S1482C2(); // _ZN7S1482C2D1Ev
  virtual void  v20(); // _ZN7S1482C23v20Ev
  virtual void  v21(); // _ZN7S1482C23v21Ev
  virtual void  v22(); // _ZN7S1482C23v22Ev
  virtual void  v23(); // _ZN7S1482C23v23Ev
  S1482C2(); // tgen
};
//SIG(-1 S1482C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 Fp FC4 FC4 FC4 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC7 FC7} vd v1 v2 v3 v4 Fc Fi[4] FC4 FC4 Fc FC4 Fc}


 S1482C2 ::~S1482C2(){ note_dtor("S1482C2", this);}
void  S1482C2 ::v20(){vfunc_called(this, "_ZN7S1482C23v20Ev");}
void  S1482C2 ::v21(){vfunc_called(this, "_ZN7S1482C23v21Ev");}
void  S1482C2 ::v22(){vfunc_called(this, "_ZN7S1482C23v22Ev");}
void  S1482C2 ::v23(){vfunc_called(this, "_ZN7S1482C23v23Ev");}
S1482C2 ::S1482C2(){ note_ctor("S1482C2", this);} // tgen

static void Test_S1482C2()
{
  extern Class_Descriptor cd_S1482C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,50)];
    init_test(&cd_S1482C2, buf);
    S1482C2 *dp, &lv = *(dp=new (buf) S1482C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,196), "sizeof(S1482C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1482C2)");
    check_base_class_offset(lv, (S1482C4*)(S1482C3*), 0, "S1482C2");
    check_base_class_offset(lv, (S1482C3*), 0, "S1482C2");
    check_field_offset(lv, s1482c2f0, ABISELECT(184,120), "S1482C2.s1482c2f0");
    check_field_offset(lv, s1482c2f1, ABISELECT(188,124), "S1482C2.s1482c2f1");
    check_field_offset(lv, s1482c2f2, ABISELECT(208,140), "S1482C2.s1482c2f2");
    check_field_offset(lv, s1482c2f3, ABISELECT(232,156), "S1482C2.s1482c2f3");
    check_field_offset(lv, s1482c2f4, ABISELECT(256,172), "S1482C2.s1482c2f4");
    check_field_offset(lv, s1482c2f5, ABISELECT(264,176), "S1482C2.s1482c2f5");
    check_field_offset(lv, s1482c2f6, ABISELECT(288,192), "S1482C2.s1482c2f6");
    test_class_info(&lv, &cd_S1482C2);
    dp->~S1482C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1482C2(Test_S1482C2, "S1482C2", ABISELECT(296,196));

#else // __cplusplus

extern void _ZN7S1482C2C1Ev();
extern void _ZN7S1482C2D1Ev();
Name_Map name_map_S1482C2[] = {
  NSPAIR(_ZN7S1482C2C1Ev),
  NSPAIR(_ZN7S1482C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1482C4;
extern VTBL_ENTRY _ZTI7S1482C4[];
extern  VTBL_ENTRY _ZTV7S1482C4[];
extern Class_Descriptor cd_S1482C3;
extern VTBL_ENTRY _ZTI7S1482C3[];
extern  VTBL_ENTRY _ZTV7S1482C3[];
static Base_Class bases_S1482C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1482C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1482C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1482C2[];
extern void _ZN7S1482C2D1Ev();
extern void _ZN7S1482C2D0Ev();
extern void _ZN7S1482C42v5Ev();
extern void _ZN7S1482C42v6Ev();
extern void _ZN7S1482C42v7Ev();
extern void _ZN7S1482C42v8Ev();
extern void _ZN7S1482C42v9Ev();
extern void _ZN7S1482C43v10Ev();
extern void _ZN7S1482C43v11Ev();
extern void _ZN7S1482C43v12Ev();
extern void _ZN7S1482C43v13Ev();
extern void _ZN7S1482C43v14Ev();
extern void _ZN7S1482C33v15Ev();
extern void _ZN7S1482C33v16Ev();
extern void _ZN7S1482C33v17Ev();
extern void _ZN7S1482C33v18Ev();
extern void _ZN7S1482C33v19Ev();
extern void _ZN7S1482C23v20Ev();
extern void _ZN7S1482C23v21Ev();
extern void _ZN7S1482C23v22Ev();
extern void _ZN7S1482C23v23Ev();
static  VTBL_ENTRY vtc_S1482C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1482C2[0]),
  (VTBL_ENTRY)&_ZN7S1482C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1482C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v20Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v21Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v22Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v23Ev,
};
extern VTBL_ENTRY _ZTI7S1482C2[];
extern  VTBL_ENTRY _ZTV7S1482C2[];
Class_Descriptor cd_S1482C2 = {  "S1482C2", // class name
  bases_S1482C2, 2,
  &(vtc_S1482C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,196), // object size
  NSPAIRA(_ZTI7S1482C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1482C2),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1482C11_nt  {
  int s1482c11f0;
  char s1482c11f1;
  int s1482c11f2[3];
  void *s1482c11f3;
  void  mf1482c11(); // _ZN11S1482C11_nt9mf1482c11Ev
  virtual  ~S1482C11_nt(); // _ZN11S1482C11_ntD1Ev
  S1482C11_nt(); // tgen
};
//SIG(-1 S1482C11_nt) C1{ vd m Fi Fc Fi[3] Fp}


void  S1482C11_nt ::mf1482c11(){}
 S1482C11_nt ::~S1482C11_nt(){ note_dtor("S1482C11_nt", this);}
S1482C11_nt ::S1482C11_nt(){ note_ctor("S1482C11_nt", this);} // tgen

//skip512 S1482C11_nt

#else // __cplusplus

extern void _ZN11S1482C11_ntC1Ev();
extern void _ZN11S1482C11_ntD1Ev();
Name_Map name_map_S1482C11_nt[] = {
  NSPAIR(_ZN11S1482C11_ntC1Ev),
  NSPAIR(_ZN11S1482C11_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S1482C11_nt[];
extern void _ZN11S1482C11_ntD1Ev();
extern void _ZN11S1482C11_ntD0Ev();
static  VTBL_ENTRY vtc_S1482C11_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S1482C11_nt[0]),
  (VTBL_ENTRY)&_ZN11S1482C11_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S1482C11_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S1482C11_nt[];
VTBL_ENTRY *P__ZTI11S1482C11_nt = _ZTI11S1482C11_nt; 
extern  VTBL_ENTRY _ZTV11S1482C11_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1482C1  : S1482C2 {
  int s1482c1f0;
  char s1482c1f1[4];
  ::S1482C11_nt s1482c1f2;
  ::S10103C13_nt s1482c1f3;
  ::S10103C13_nt s1482c1f4;
  virtual  ~S1482C1(); // _ZN7S1482C1D1Ev
  virtual void  v1(); // _ZN7S1482C12v1Ev
  virtual void  v2(); // _ZN7S1482C12v2Ev
  virtual void  v3(); // _ZN7S1482C12v3Ev
  virtual void  v4(); // _ZN7S1482C12v4Ev
  S1482C1(); // tgen
};
//SIG(1 S1482C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fp} vd v15 v16 v17 v18 v19 Fp FC5 FC5 FC5 FC8{ m Fp Fi FC9{ m} FC10{ m}} FC8 FC8} vd v20 v21 v22 v23 Fc Fi[4] FC5 FC5 Fc FC5 Fc} vd v1 v2 v3 v4 Fi Fc[4] FC11{ vd m Fi Fc Fi[3] Fp} FC5 FC5}


 S1482C1 ::~S1482C1(){ note_dtor("S1482C1", this);}
void  S1482C1 ::v1(){vfunc_called(this, "_ZN7S1482C12v1Ev");}
void  S1482C1 ::v2(){vfunc_called(this, "_ZN7S1482C12v2Ev");}
void  S1482C1 ::v3(){vfunc_called(this, "_ZN7S1482C12v3Ev");}
void  S1482C1 ::v4(){vfunc_called(this, "_ZN7S1482C12v4Ev");}
S1482C1 ::S1482C1(){ note_ctor("S1482C1", this);} // tgen

static void Test_S1482C1()
{
  extern Class_Descriptor cd_S1482C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,67)];
    init_test(&cd_S1482C1, buf);
    S1482C1 *dp, &lv = *(dp=new (buf) S1482C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,264), "sizeof(S1482C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1482C1)");
    check_base_class_offset(lv, (S1482C4*)(S1482C3*)(S1482C2*), 0, "S1482C1");
    check_base_class_offset(lv, (S1482C3*)(S1482C2*), 0, "S1482C1");
    check_base_class_offset(lv, (S1482C2*), 0, "S1482C1");
    check_field_offset(lv, s1482c1f0, ABISELECT(292,196), "S1482C1.s1482c1f0");
    check_field_offset(lv, s1482c1f1, ABISELECT(296,200), "S1482C1.s1482c1f1");
    check_field_offset(lv, s1482c1f2, ABISELECT(304,204), "S1482C1.s1482c1f2");
    check_field_offset(lv, s1482c1f3, ABISELECT(344,232), "S1482C1.s1482c1f3");
    check_field_offset(lv, s1482c1f4, ABISELECT(368,248), "S1482C1.s1482c1f4");
    test_class_info(&lv, &cd_S1482C1);
    dp->~S1482C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1482C1(Test_S1482C1, "S1482C1", ABISELECT(392,264));

#else // __cplusplus

extern void _ZN7S1482C1C1Ev();
extern void _ZN7S1482C1D1Ev();
Name_Map name_map_S1482C1[] = {
  NSPAIR(_ZN7S1482C1C1Ev),
  NSPAIR(_ZN7S1482C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1482C4;
extern VTBL_ENTRY _ZTI7S1482C4[];
extern  VTBL_ENTRY _ZTV7S1482C4[];
extern Class_Descriptor cd_S1482C3;
extern VTBL_ENTRY _ZTI7S1482C3[];
extern  VTBL_ENTRY _ZTV7S1482C3[];
extern Class_Descriptor cd_S1482C2;
extern VTBL_ENTRY _ZTI7S1482C2[];
extern  VTBL_ENTRY _ZTV7S1482C2[];
static Base_Class bases_S1482C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1482C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1482C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1482C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1482C1[];
extern void _ZN7S1482C1D1Ev();
extern void _ZN7S1482C1D0Ev();
extern void _ZN7S1482C42v5Ev();
extern void _ZN7S1482C42v6Ev();
extern void _ZN7S1482C42v7Ev();
extern void _ZN7S1482C42v8Ev();
extern void _ZN7S1482C42v9Ev();
extern void _ZN7S1482C43v10Ev();
extern void _ZN7S1482C43v11Ev();
extern void _ZN7S1482C43v12Ev();
extern void _ZN7S1482C43v13Ev();
extern void _ZN7S1482C43v14Ev();
extern void _ZN7S1482C33v15Ev();
extern void _ZN7S1482C33v16Ev();
extern void _ZN7S1482C33v17Ev();
extern void _ZN7S1482C33v18Ev();
extern void _ZN7S1482C33v19Ev();
extern void _ZN7S1482C23v20Ev();
extern void _ZN7S1482C23v21Ev();
extern void _ZN7S1482C23v22Ev();
extern void _ZN7S1482C23v23Ev();
extern void _ZN7S1482C12v1Ev();
extern void _ZN7S1482C12v2Ev();
extern void _ZN7S1482C12v3Ev();
extern void _ZN7S1482C12v4Ev();
static  VTBL_ENTRY vtc_S1482C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1482C1[0]),
  (VTBL_ENTRY)&_ZN7S1482C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1482C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1482C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1482C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v15Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v16Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v17Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v18Ev,
  (VTBL_ENTRY)&_ZN7S1482C33v19Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v20Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v21Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v22Ev,
  (VTBL_ENTRY)&_ZN7S1482C23v23Ev,
  (VTBL_ENTRY)&_ZN7S1482C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1482C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1482C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1482C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S1482C1[];
extern  VTBL_ENTRY _ZTV7S1482C1[];
Class_Descriptor cd_S1482C1 = {  "S1482C1", // class name
  bases_S1482C1, 3,
  &(vtc_S1482C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,264), // object size
  NSPAIRA(_ZTI7S1482C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1482C1),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C3_nt  {
  int s2718c3f0;
  void  mf2718c3(); // _ZN10S2718C3_nt8mf2718c3Ev
};
//SIG(-1 S2718C3_nt) C1{ m Fi}


void  S2718C3_nt ::mf2718c3(){}

//skip512 S2718C3_nt

#else // __cplusplus

Class_Descriptor cd_S2718C3_nt = {  "S2718C3_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C2_nt  : S2718C3_nt {
};
//SIG(-1 S2718C2_nt) C1{ BC2{ m Fi}}



//skip512 S2718C2_nt

#else // __cplusplus

extern Class_Descriptor cd_S2718C3_nt;
static Base_Class bases_S2718C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2718C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2718C2_nt = {  "S2718C2_nt", // class name
  bases_S2718C2_nt, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C4_nt  {
  char s2718c4f0[3];
  void  mf2718c4(); // _ZN10S2718C4_nt8mf2718c4Ev
};
//SIG(-1 S2718C4_nt) C1{ m Fc[3]}


void  S2718C4_nt ::mf2718c4(){}

//skip512 S2718C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C10_nt  {
  ::S10103C64 s2718c10f0;
  void  mf2718c10(); // _ZN11S2718C10_nt9mf2718c10Ev
};
//SIG(-1 S2718C10_nt) C1{ m FC2{ m Fp}}


void  S2718C10_nt ::mf2718c10(){}

//skip512 S2718C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C9_nt  {
  ::S2718C10_nt s2718c9f0;
  void  mf2718c9(); // _ZN10S2718C9_nt8mf2718c9Ev
};
//SIG(-1 S2718C9_nt) C1{ m FC2{ m FC3{ m Fp}}}


void  S2718C9_nt ::mf2718c9(){}

//skip512 S2718C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C12_nt  : S10103C54_nt {
};
//SIG(-1 S2718C12_nt) C1{ BC2{ m Fp}}



//skip512 S2718C12_nt

#else // __cplusplus

extern Class_Descriptor cd_S10103C54_nt;
static Base_Class bases_S2718C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10103C54_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C8  {
  ::S2718C9_nt s2718c8f0;
  ::S2718C12_nt s2718c8f1;
  void  mf2718c8(); // _ZN7S2718C88mf2718c8Ev
};
//SIG(-1 S2718C8) C1{ m FC2{ m FC3{ m FC4{ m Fp}}} FC5{ BC6{ m Fp}}}


void  S2718C8 ::mf2718c8(){}

static void Test_S2718C8()
{
  {
    init_simple_test("S2718C8");
    S2718C8 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S2718C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2718C8)");
    check_field_offset(lv, s2718c8f0, 0, "S2718C8.s2718c8f0");
    check_field_offset(lv, s2718c8f1, ABISELECT(8,4), "S2718C8.s2718c8f1");
  }
}
static Arrange_To_Call_Me vS2718C8(Test_S2718C8, "S2718C8", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C14_nt  {
  void *s2718c14f0;
  void  mf2718c14(); // _ZN11S2718C14_nt9mf2718c14Ev
};
//SIG(-1 S2718C14_nt) C1{ m Fp}


void  S2718C14_nt ::mf2718c14(){}

//skip512 S2718C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C7  {
  ::S2718C8 s2718c7f0;
  ::S2718C14_nt s2718c7f1;
  int s2718c7f2[2];
  unsigned int s2718c7f3:1;
  unsigned int s2718c7f4:1;
  int s2718c7f5:2;
  unsigned int s2718c7f6:1;
  unsigned int s2718c7f7:1;
  unsigned int s2718c7f8:1;
  int s2718c7f9:8;
  int s2718c7f10:3;
  unsigned int s2718c7f11:1;
  unsigned int s2718c7f12:1;
  int s2718c7f13:2;
  int s2718c7f14:2;
  int s2718c7f15:2;
  int s2718c7f16:2;
  int s2718c7f17:4;
  int s2718c7f18:2;
  int s2718c7f19:2;
  unsigned int s2718c7f20:1;
  int s2718c7f21;
  void  mf2718c7(); // _ZN7S2718C78mf2718c7Ev
};
//SIG(-1 S2718C7) C1{ m FC2{ m FC3{ m FC4{ m FC5{ m Fp}}} FC6{ BC7{ m Fp}}} FC8{ m Fp} Fi[2] Fi:1 Fi:1 Fi:2 Fi:1 Fi:1 Fi:1 Fi:8 Fi:3 Fi:1 Fi:1 Fi:2 Fi:2 Fi:2 Fi:2 Fi:4 Fi:2 Fi:2 Fi:1 Fi}


void  S2718C7 ::mf2718c7(){}

static void Test_S2718C7()
{
  {
    init_simple_test("S2718C7");
    static S2718C7 lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S2718C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2718C7)");
    check_field_offset(lv, s2718c7f0, 0, "S2718C7.s2718c7f0");
    check_field_offset(lv, s2718c7f1, ABISELECT(16,8), "S2718C7.s2718c7f1");
    check_field_offset(lv, s2718c7f2, ABISELECT(24,12), "S2718C7.s2718c7f2");
    set_bf_and_test(lv, s2718c7f3, ABISELECT(32,20), 0, 1, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f4, ABISELECT(32,20), 1, 1, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f5, ABISELECT(32,20), 2, 2, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f5, ABISELECT(32,20), 2, 2, hide_sll(1LL<<1), "S2718C7");
    set_bf_and_test(lv, s2718c7f6, ABISELECT(32,20), 4, 1, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f7, ABISELECT(32,20), 5, 1, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f8, ABISELECT(32,20), 6, 1, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f9, ABISELECT(32,20), 7, 8, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f9, ABISELECT(32,20), 7, 8, hide_sll(1LL<<7), "S2718C7");
    set_bf_and_test(lv, s2718c7f10, ABISELECT(33,21), 7, 3, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f10, ABISELECT(33,21), 7, 3, hide_sll(1LL<<2), "S2718C7");
    set_bf_and_test(lv, s2718c7f11, ABISELECT(34,22), 2, 1, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f12, ABISELECT(34,22), 3, 1, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f13, ABISELECT(34,22), 4, 2, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f13, ABISELECT(34,22), 4, 2, hide_sll(1LL<<1), "S2718C7");
    set_bf_and_test(lv, s2718c7f14, ABISELECT(34,22), 6, 2, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f14, ABISELECT(34,22), 6, 2, hide_sll(1LL<<1), "S2718C7");
    set_bf_and_test(lv, s2718c7f15, ABISELECT(35,23), 0, 2, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f15, ABISELECT(35,23), 0, 2, hide_sll(1LL<<1), "S2718C7");
    set_bf_and_test(lv, s2718c7f16, ABISELECT(35,23), 2, 2, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f16, ABISELECT(35,23), 2, 2, hide_sll(1LL<<1), "S2718C7");
    set_bf_and_test(lv, s2718c7f17, ABISELECT(35,23), 4, 4, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f17, ABISELECT(35,23), 4, 4, hide_sll(1LL<<3), "S2718C7");
    set_bf_and_test(lv, s2718c7f18, ABISELECT(36,24), 0, 2, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f18, ABISELECT(36,24), 0, 2, hide_sll(1LL<<1), "S2718C7");
    set_bf_and_test(lv, s2718c7f19, ABISELECT(36,24), 2, 2, 1, "S2718C7");
    set_bf_and_test(lv, s2718c7f19, ABISELECT(36,24), 2, 2, hide_sll(1LL<<1), "S2718C7");
    set_bf_and_test(lv, s2718c7f20, ABISELECT(36,24), 4, 1, 1, "S2718C7");
    check_field_offset(lv, s2718c7f21, ABISELECT(40,28), "S2718C7.s2718c7f21");
  }
}
static Arrange_To_Call_Me vS2718C7(Test_S2718C7, "S2718C7", ABISELECT(48,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C6  {
  ::S2718C7 s2718c6f0;
  ::S2718C14_nt s2718c6f1;
  short s2718c6f2[2];
  char s2718c6f3[2];
  void  mf2718c6(); // _ZN7S2718C68mf2718c6Ev
};
//SIG(-1 S2718C6) C1{ m FC2{ m FC3{ m FC4{ m FC5{ m FC6{ m Fp}}} FC7{ BC8{ m Fp}}} FC9{ m Fp} Fi[2] Fi:1 Fi:1 Fi:2 Fi:1 Fi:1 Fi:1 Fi:8 Fi:3 Fi:1 Fi:1 Fi:2 Fi:2 Fi:2 Fi:2 Fi:4 Fi:2 Fi:2 Fi:1 Fi} FC9 Fs[2] Fc[2]}


void  S2718C6 ::mf2718c6(){}

static void Test_S2718C6()
{
  {
    init_simple_test("S2718C6");
    static S2718C6 lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2718C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2718C6)");
    check_field_offset(lv, s2718c6f0, 0, "S2718C6.s2718c6f0");
    check_field_offset(lv, s2718c6f1, ABISELECT(48,32), "S2718C6.s2718c6f1");
    check_field_offset(lv, s2718c6f2, ABISELECT(56,36), "S2718C6.s2718c6f2");
    check_field_offset(lv, s2718c6f3, ABISELECT(60,40), "S2718C6.s2718c6f3");
  }
}
static Arrange_To_Call_Me vS2718C6(Test_S2718C6, "S2718C6", ABISELECT(64,44));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C16_nt  {
  int s2718c16f0;
  char s2718c16f1;
  void  mf2718c16(); // _ZN11S2718C16_nt9mf2718c16Ev
};
//SIG(-1 S2718C16_nt) C1{ m Fi Fc}


void  S2718C16_nt ::mf2718c16(){}

//skip512 S2718C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2718C1  : S2718C2_nt {
  short s2718c1f0[2];
  ::S2718C4_nt s2718c1f1;
  ::S10103C105 s2718c1f2;
  ::S2718C6 s2718c1f3;
  ::S2718C16_nt s2718c1f4;
  ::S2718C16_nt s2718c1f5;
};
//SIG(1 S2718C1) C1{ BC2{ BC3{ m Fi}} Fs[2] FC4{ m Fc[3]} FC5{ m Fp} FC6{ m FC7{ m FC8{ m FC9{ m FC10{ m FC11{ m Fp}}} FC12{ BC13{ m Fp}}} FC14{ m Fp} Fi[2] Fi:1 Fi:1 Fi:2 Fi:1 Fi:1 Fi:1 Fi:8 Fi:3 Fi:1 Fi:1 Fi:2 Fi:2 Fi:2 Fi:2 Fi:4 Fi:2 Fi:2 Fi:1 Fi} FC14 Fs[2] Fc[2]} FC15{ m Fi Fc} FC15}



static void Test_S2718C1()
{
  extern Class_Descriptor cd_S2718C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,20)];
    init_test(&cd_S2718C1, buf);
    S2718C1 &lv = *(new (buf) S2718C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,76), "sizeof(S2718C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2718C1)");
    check_base_class_offset(lv, (S2718C3_nt*)(S2718C2_nt*), 0, "S2718C1");
    check_base_class_offset(lv, (S2718C2_nt*), 0, "S2718C1");
    check_field_offset(lv, s2718c1f0, 4, "S2718C1.s2718c1f0");
    check_field_offset(lv, s2718c1f1, 8, "S2718C1.s2718c1f1");
    check_field_offset(lv, s2718c1f2, ABISELECT(16,12), "S2718C1.s2718c1f2");
    check_field_offset(lv, s2718c1f3, ABISELECT(24,16), "S2718C1.s2718c1f3");
    check_field_offset(lv, s2718c1f4, ABISELECT(88,60), "S2718C1.s2718c1f4");
    check_field_offset(lv, s2718c1f5, ABISELECT(96,68), "S2718C1.s2718c1f5");
    test_class_info(&lv, &cd_S2718C1);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2718C1(Test_S2718C1, "S2718C1", ABISELECT(104,76));

#else // __cplusplus

extern Class_Descriptor cd_S2718C3_nt;
extern Class_Descriptor cd_S2718C2_nt;
static Base_Class bases_S2718C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2718C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2718C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2718C1 = {  "S2718C1", // class name
  bases_S2718C1, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(104,76), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S645C5  {
  void *s645c5f0[2];
  ::S10103C13_nt s645c5f1;
  void *s645c5f2;
  virtual  ~S645C5(); // _ZN6S645C5D1Ev
  virtual void  v5(); // _ZN6S645C52v5Ev
  virtual void  v6(); // _ZN6S645C52v6Ev
  virtual void  v7(); // _ZN6S645C52v7Ev
  virtual void  v8(); // _ZN6S645C52v8Ev
  virtual void  v9(); // _ZN6S645C52v9Ev
  virtual void  v10(); // _ZN6S645C53v10Ev
  virtual void  v11(); // _ZN6S645C53v11Ev
  virtual void  v12(); // _ZN6S645C53v12Ev
  virtual void  v13(); // _ZN6S645C53v13Ev
  virtual void  v14(); // _ZN6S645C53v14Ev
  S645C5(); // tgen
};
//SIG(-1 S645C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[2] FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp}


 S645C5 ::~S645C5(){ note_dtor("S645C5", this);}
void  S645C5 ::v5(){vfunc_called(this, "_ZN6S645C52v5Ev");}
void  S645C5 ::v6(){vfunc_called(this, "_ZN6S645C52v6Ev");}
void  S645C5 ::v7(){vfunc_called(this, "_ZN6S645C52v7Ev");}
void  S645C5 ::v8(){vfunc_called(this, "_ZN6S645C52v8Ev");}
void  S645C5 ::v9(){vfunc_called(this, "_ZN6S645C52v9Ev");}
void  S645C5 ::v10(){vfunc_called(this, "_ZN6S645C53v10Ev");}
void  S645C5 ::v11(){vfunc_called(this, "_ZN6S645C53v11Ev");}
void  S645C5 ::v12(){vfunc_called(this, "_ZN6S645C53v12Ev");}
void  S645C5 ::v13(){vfunc_called(this, "_ZN6S645C53v13Ev");}
void  S645C5 ::v14(){vfunc_called(this, "_ZN6S645C53v14Ev");}
S645C5 ::S645C5(){ note_ctor("S645C5", this);} // tgen

static void Test_S645C5()
{
  extern Class_Descriptor cd_S645C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S645C5, buf);
    S645C5 *dp, &lv = *(dp=new (buf) S645C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S645C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S645C5)");
    check_field_offset(lv, s645c5f0, ABISELECT(8,4), "S645C5.s645c5f0");
    check_field_offset(lv, s645c5f1, ABISELECT(24,12), "S645C5.s645c5f1");
    check_field_offset(lv, s645c5f2, ABISELECT(48,28), "S645C5.s645c5f2");
    test_class_info(&lv, &cd_S645C5);
    dp->~S645C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS645C5(Test_S645C5, "S645C5", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN6S645C5C1Ev();
extern void _ZN6S645C5D1Ev();
Name_Map name_map_S645C5[] = {
  NSPAIR(_ZN6S645C5C1Ev),
  NSPAIR(_ZN6S645C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S645C5[];
extern void _ZN6S645C5D1Ev();
extern void _ZN6S645C5D0Ev();
extern void _ZN6S645C52v5Ev();
extern void _ZN6S645C52v6Ev();
extern void _ZN6S645C52v7Ev();
extern void _ZN6S645C52v8Ev();
extern void _ZN6S645C52v9Ev();
extern void _ZN6S645C53v10Ev();
extern void _ZN6S645C53v11Ev();
extern void _ZN6S645C53v12Ev();
extern void _ZN6S645C53v13Ev();
extern void _ZN6S645C53v14Ev();
static  VTBL_ENTRY vtc_S645C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S645C5[0]),
  (VTBL_ENTRY)&_ZN6S645C5D1Ev,
  (VTBL_ENTRY)&_ZN6S645C5D0Ev,
  (VTBL_ENTRY)&_ZN6S645C52v5Ev,
  (VTBL_ENTRY)&_ZN6S645C52v6Ev,
  (VTBL_ENTRY)&_ZN6S645C52v7Ev,
  (VTBL_ENTRY)&_ZN6S645C52v8Ev,
  (VTBL_ENTRY)&_ZN6S645C52v9Ev,
  (VTBL_ENTRY)&_ZN6S645C53v10Ev,
  (VTBL_ENTRY)&_ZN6S645C53v11Ev,
  (VTBL_ENTRY)&_ZN6S645C53v12Ev,
  (VTBL_ENTRY)&_ZN6S645C53v13Ev,
  (VTBL_ENTRY)&_ZN6S645C53v14Ev,
};
extern VTBL_ENTRY _ZTI6S645C5[];
extern  VTBL_ENTRY _ZTV6S645C5[];
Class_Descriptor cd_S645C5 = {  "S645C5", // class name
  0,0,//no base classes
  &(vtc_S645C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI6S645C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S645C5),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S645C4  : S645C5 {
  void *s645c4f0;
  ::S10103C13_nt s645c4f1;
  ::S10103C13_nt s645c4f2;
  ::S10103C13_nt s645c4f3;
  ::S10103C86 s645c4f4;
  ::S10103C86 s645c4f5;
  ::S10103C86 s645c4f6;
  virtual  ~S645C4(); // _ZN6S645C4D1Ev
  virtual void  v15(); // _ZN6S645C43v15Ev
  virtual void  v16(); // _ZN6S645C43v16Ev
  virtual void  v17(); // _ZN6S645C43v17Ev
  virtual void  v18(); // _ZN6S645C43v18Ev
  virtual void  v19(); // _ZN6S645C43v19Ev
  S645C4(); // tgen
};
//SIG(-1 S645C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp[2] FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fp} vd v1 v2 v3 v4 v5 Fp FC3 FC3 FC3 FC6{ m Fp Fi FC7{ m} FC8{ m}} FC6 FC6}


 S645C4 ::~S645C4(){ note_dtor("S645C4", this);}
void  S645C4 ::v15(){vfunc_called(this, "_ZN6S645C43v15Ev");}
void  S645C4 ::v16(){vfunc_called(this, "_ZN6S645C43v16Ev");}
void  S645C4 ::v17(){vfunc_called(this, "_ZN6S645C43v17Ev");}
void  S645C4 ::v18(){vfunc_called(this, "_ZN6S645C43v18Ev");}
void  S645C4 ::v19(){vfunc_called(this, "_ZN6S645C43v19Ev");}
S645C4 ::S645C4(){ note_ctor("S645C4", this);} // tgen

static void Test_S645C4()
{
  extern Class_Descriptor cd_S645C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S645C4, buf);
    S645C4 *dp, &lv = *(dp=new (buf) S645C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S645C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S645C4)");
    check_base_class_offset(lv, (S645C5*), 0, "S645C4");
    check_field_offset(lv, s645c4f0, ABISELECT(56,32), "S645C4.s645c4f0");
    check_field_offset(lv, s645c4f1, ABISELECT(64,36), "S645C4.s645c4f1");
    check_field_offset(lv, s645c4f2, ABISELECT(88,52), "S645C4.s645c4f2");
    check_field_offset(lv, s645c4f3, ABISELECT(112,68), "S645C4.s645c4f3");
    check_field_offset(lv, s645c4f4, ABISELECT(136,84), "S645C4.s645c4f4");
    check_field_offset(lv, s645c4f5, ABISELECT(152,96), "S645C4.s645c4f5");
    check_field_offset(lv, s645c4f6, ABISELECT(168,108), "S645C4.s645c4f6");
    test_class_info(&lv, &cd_S645C4);
    dp->~S645C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS645C4(Test_S645C4, "S645C4", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN6S645C4C1Ev();
extern void _ZN6S645C4D1Ev();
Name_Map name_map_S645C4[] = {
  NSPAIR(_ZN6S645C4C1Ev),
  NSPAIR(_ZN6S645C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S645C5;
extern VTBL_ENTRY _ZTI6S645C5[];
extern 