// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S604C6_nt  {
  int s604c6f0[2];
  void  mf604c6(); // _ZN9S604C6_nt7mf604c6Ev
};
//SIG(-1 S604C6_nt) C1{ m Fi[2]}


void  S604C6_nt ::mf604c6(){}

//skip512 S604C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C5_nt  {
  int s604c5f0;
  __tsi64 s604c5f1;
  void *s604c5f2[4];
  int s604c5f3[2];
  void *s604c5f4;
  ::S604C6_nt s604c5f5;
  void *s604c5f6[2];
  virtual  ~S604C5_nt(); // _ZN9S604C5_ntD1Ev
  virtual void  v5(); // _ZN9S604C5_nt2v5Ev
  virtual void  v6(); // _ZN9S604C5_nt2v6Ev
  virtual void  v7(); // _ZN9S604C5_nt2v7Ev
  virtual void  v8(); // _ZN9S604C5_nt2v8Ev
  virtual void  v9(); // _ZN9S604C5_nt2v9Ev
  virtual void  v10(); // _ZN9S604C5_nt3v10Ev
  virtual void  v11(); // _ZN9S604C5_nt3v11Ev
  virtual void  v12(); // _ZN9S604C5_nt3v12Ev
  virtual void  v13(); // _ZN9S604C5_nt3v13Ev
  virtual void  v14(); // _ZN9S604C5_nt3v14Ev
  virtual void  v15(); // _ZN9S604C5_nt3v15Ev
  virtual void  v16(); // _ZN9S604C5_nt3v16Ev
  virtual void  v17(); // _ZN9S604C5_nt3v17Ev
  virtual void  v18(); // _ZN9S604C5_nt3v18Ev
  virtual void  v19(); // _ZN9S604C5_nt3v19Ev
  virtual void  v20(); // _ZN9S604C5_nt3v20Ev
  virtual void  v21(); // _ZN9S604C5_nt3v21Ev
  virtual void  v22(); // _ZN9S604C5_nt3v22Ev
  virtual void  v23(); // _ZN9S604C5_nt3v23Ev
  virtual void  v24(); // _ZN9S604C5_nt3v24Ev
  virtual void  v25(); // _ZN9S604C5_nt3v25Ev
  virtual void  v26(); // _ZN9S604C5_nt3v26Ev
  virtual void  v27(); // _ZN9S604C5_nt3v27Ev
  virtual void  v28(); // _ZN9S604C5_nt3v28Ev
  virtual void  v29(); // _ZN9S604C5_nt3v29Ev
  virtual void  v30(); // _ZN9S604C5_nt3v30Ev
  virtual void  v31(); // _ZN9S604C5_nt3v31Ev
  virtual void  v32(); // _ZN9S604C5_nt3v32Ev
  virtual void  v33(); // _ZN9S604C5_nt3v33Ev
  virtual void  v34(); // _ZN9S604C5_nt3v34Ev
  virtual void  v35(); // _ZN9S604C5_nt3v35Ev
  virtual void  v36(); // _ZN9S604C5_nt3v36Ev
  virtual void  v37(); // _ZN9S604C5_nt3v37Ev
  virtual void  v38(); // _ZN9S604C5_nt3v38Ev
  virtual void  v39(); // _ZN9S604C5_nt3v39Ev
  virtual void  v40(); // _ZN9S604C5_nt3v40Ev
  virtual void  v41(); // _ZN9S604C5_nt3v41Ev
  virtual void  v42(); // _ZN9S604C5_nt3v42Ev
  virtual void  v43(); // _ZN9S604C5_nt3v43Ev
  virtual void  v44(); // _ZN9S604C5_nt3v44Ev
  virtual void  v45(); // _ZN9S604C5_nt3v45Ev
  virtual void  v46(); // _ZN9S604C5_nt3v46Ev
  virtual void  v47(); // _ZN9S604C5_nt3v47Ev
  virtual void  v48(); // _ZN9S604C5_nt3v48Ev
  virtual void  v49(); // _ZN9S604C5_nt3v49Ev
  virtual void  v50(); // _ZN9S604C5_nt3v50Ev
  virtual void  v51(); // _ZN9S604C5_nt3v51Ev
  virtual void  v52(); // _ZN9S604C5_nt3v52Ev
  virtual void  v53(); // _ZN9S604C5_nt3v53Ev
  virtual void  v54(); // _ZN9S604C5_nt3v54Ev
  virtual void  v55(); // _ZN9S604C5_nt3v55Ev
  virtual void  v56(); // _ZN9S604C5_nt3v56Ev
  virtual void  v57(); // _ZN9S604C5_nt3v57Ev
  virtual void  v58(); // _ZN9S604C5_nt3v58Ev
  virtual void  v59(); // _ZN9S604C5_nt3v59Ev
  virtual void  v60(); // _ZN9S604C5_nt3v60Ev
  virtual void  v61(); // _ZN9S604C5_nt3v61Ev
  virtual void  v62(); // _ZN9S604C5_nt3v62Ev
  virtual void  v63(); // _ZN9S604C5_nt3v63Ev
  virtual void  v64(); // _ZN9S604C5_nt3v64Ev
  virtual void  v65(); // _ZN9S604C5_nt3v65Ev
  virtual void  v66(); // _ZN9S604C5_nt3v66Ev
  virtual void  v67(); // _ZN9S604C5_nt3v67Ev
  virtual void  v68(); // _ZN9S604C5_nt3v68Ev
  S604C5_nt(); // tgen
};
//SIG(-1 S604C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S604C5_nt ::~S604C5_nt(){ note_dtor("S604C5_nt", this);}
void  S604C5_nt ::v5(){vfunc_called(this, "_ZN9S604C5_nt2v5Ev");}
void  S604C5_nt ::v6(){vfunc_called(this, "_ZN9S604C5_nt2v6Ev");}
void  S604C5_nt ::v7(){vfunc_called(this, "_ZN9S604C5_nt2v7Ev");}
void  S604C5_nt ::v8(){vfunc_called(this, "_ZN9S604C5_nt2v8Ev");}
void  S604C5_nt ::v9(){vfunc_called(this, "_ZN9S604C5_nt2v9Ev");}
void  S604C5_nt ::v10(){vfunc_called(this, "_ZN9S604C5_nt3v10Ev");}
void  S604C5_nt ::v11(){vfunc_called(this, "_ZN9S604C5_nt3v11Ev");}
void  S604C5_nt ::v12(){vfunc_called(this, "_ZN9S604C5_nt3v12Ev");}
void  S604C5_nt ::v13(){vfunc_called(this, "_ZN9S604C5_nt3v13Ev");}
void  S604C5_nt ::v14(){vfunc_called(this, "_ZN9S604C5_nt3v14Ev");}
void  S604C5_nt ::v15(){vfunc_called(this, "_ZN9S604C5_nt3v15Ev");}
void  S604C5_nt ::v16(){vfunc_called(this, "_ZN9S604C5_nt3v16Ev");}
void  S604C5_nt ::v17(){vfunc_called(this, "_ZN9S604C5_nt3v17Ev");}
void  S604C5_nt ::v18(){vfunc_called(this, "_ZN9S604C5_nt3v18Ev");}
void  S604C5_nt ::v19(){vfunc_called(this, "_ZN9S604C5_nt3v19Ev");}
void  S604C5_nt ::v20(){vfunc_called(this, "_ZN9S604C5_nt3v20Ev");}
void  S604C5_nt ::v21(){vfunc_called(this, "_ZN9S604C5_nt3v21Ev");}
void  S604C5_nt ::v22(){vfunc_called(this, "_ZN9S604C5_nt3v22Ev");}
void  S604C5_nt ::v23(){vfunc_called(this, "_ZN9S604C5_nt3v23Ev");}
void  S604C5_nt ::v24(){vfunc_called(this, "_ZN9S604C5_nt3v24Ev");}
void  S604C5_nt ::v25(){vfunc_called(this, "_ZN9S604C5_nt3v25Ev");}
void  S604C5_nt ::v26(){vfunc_called(this, "_ZN9S604C5_nt3v26Ev");}
void  S604C5_nt ::v27(){vfunc_called(this, "_ZN9S604C5_nt3v27Ev");}
void  S604C5_nt ::v28(){vfunc_called(this, "_ZN9S604C5_nt3v28Ev");}
void  S604C5_nt ::v29(){vfunc_called(this, "_ZN9S604C5_nt3v29Ev");}
void  S604C5_nt ::v30(){vfunc_called(this, "_ZN9S604C5_nt3v30Ev");}
void  S604C5_nt ::v31(){vfunc_called(this, "_ZN9S604C5_nt3v31Ev");}
void  S604C5_nt ::v32(){vfunc_called(this, "_ZN9S604C5_nt3v32Ev");}
void  S604C5_nt ::v33(){vfunc_called(this, "_ZN9S604C5_nt3v33Ev");}
void  S604C5_nt ::v34(){vfunc_called(this, "_ZN9S604C5_nt3v34Ev");}
void  S604C5_nt ::v35(){vfunc_called(this, "_ZN9S604C5_nt3v35Ev");}
void  S604C5_nt ::v36(){vfunc_called(this, "_ZN9S604C5_nt3v36Ev");}
void  S604C5_nt ::v37(){vfunc_called(this, "_ZN9S604C5_nt3v37Ev");}
void  S604C5_nt ::v38(){vfunc_called(this, "_ZN9S604C5_nt3v38Ev");}
void  S604C5_nt ::v39(){vfunc_called(this, "_ZN9S604C5_nt3v39Ev");}
void  S604C5_nt ::v40(){vfunc_called(this, "_ZN9S604C5_nt3v40Ev");}
void  S604C5_nt ::v41(){vfunc_called(this, "_ZN9S604C5_nt3v41Ev");}
void  S604C5_nt ::v42(){vfunc_called(this, "_ZN9S604C5_nt3v42Ev");}
void  S604C5_nt ::v43(){vfunc_called(this, "_ZN9S604C5_nt3v43Ev");}
void  S604C5_nt ::v44(){vfunc_called(this, "_ZN9S604C5_nt3v44Ev");}
void  S604C5_nt ::v45(){vfunc_called(this, "_ZN9S604C5_nt3v45Ev");}
void  S604C5_nt ::v46(){vfunc_called(this, "_ZN9S604C5_nt3v46Ev");}
void  S604C5_nt ::v47(){vfunc_called(this, "_ZN9S604C5_nt3v47Ev");}
void  S604C5_nt ::v48(){vfunc_called(this, "_ZN9S604C5_nt3v48Ev");}
void  S604C5_nt ::v49(){vfunc_called(this, "_ZN9S604C5_nt3v49Ev");}
void  S604C5_nt ::v50(){vfunc_called(this, "_ZN9S604C5_nt3v50Ev");}
void  S604C5_nt ::v51(){vfunc_called(this, "_ZN9S604C5_nt3v51Ev");}
void  S604C5_nt ::v52(){vfunc_called(this, "_ZN9S604C5_nt3v52Ev");}
void  S604C5_nt ::v53(){vfunc_called(this, "_ZN9S604C5_nt3v53Ev");}
void  S604C5_nt ::v54(){vfunc_called(this, "_ZN9S604C5_nt3v54Ev");}
void  S604C5_nt ::v55(){vfunc_called(this, "_ZN9S604C5_nt3v55Ev");}
void  S604C5_nt ::v56(){vfunc_called(this, "_ZN9S604C5_nt3v56Ev");}
void  S604C5_nt ::v57(){vfunc_called(this, "_ZN9S604C5_nt3v57Ev");}
void  S604C5_nt ::v58(){vfunc_called(this, "_ZN9S604C5_nt3v58Ev");}
void  S604C5_nt ::v59(){vfunc_called(this, "_ZN9S604C5_nt3v59Ev");}
void  S604C5_nt ::v60(){vfunc_called(this, "_ZN9S604C5_nt3v60Ev");}
void  S604C5_nt ::v61(){vfunc_called(this, "_ZN9S604C5_nt3v61Ev");}
void  S604C5_nt ::v62(){vfunc_called(this, "_ZN9S604C5_nt3v62Ev");}
void  S604C5_nt ::v63(){vfunc_called(this, "_ZN9S604C5_nt3v63Ev");}
void  S604C5_nt ::v64(){vfunc_called(this, "_ZN9S604C5_nt3v64Ev");}
void  S604C5_nt ::v65(){vfunc_called(this, "_ZN9S604C5_nt3v65Ev");}
void  S604C5_nt ::v66(){vfunc_called(this, "_ZN9S604C5_nt3v66Ev");}
void  S604C5_nt ::v67(){vfunc_called(this, "_ZN9S604C5_nt3v67Ev");}
void  S604C5_nt ::v68(){vfunc_called(this, "_ZN9S604C5_nt3v68Ev");}
S604C5_nt ::S604C5_nt(){ note_ctor("S604C5_nt", this);} // tgen

//skip512 S604C5_nt

#else // __cplusplus

extern void _ZN9S604C5_ntC1Ev();
extern void _ZN9S604C5_ntD1Ev();
Name_Map name_map_S604C5_nt[] = {
  NSPAIR(_ZN9S604C5_ntC1Ev),
  NSPAIR(_ZN9S604C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S604C5_nt[];
extern void _ZN9S604C5_ntD1Ev();
extern void _ZN9S604C5_ntD0Ev();
extern void _ZN9S604C5_nt2v5Ev();
extern void _ZN9S604C5_nt2v6Ev();
extern void _ZN9S604C5_nt2v7Ev();
extern void _ZN9S604C5_nt2v8Ev();
extern void _ZN9S604C5_nt2v9Ev();
extern void _ZN9S604C5_nt3v10Ev();
extern void _ZN9S604C5_nt3v11Ev();
extern void _ZN9S604C5_nt3v12Ev();
extern void _ZN9S604C5_nt3v13Ev();
extern void _ZN9S604C5_nt3v14Ev();
extern void _ZN9S604C5_nt3v15Ev();
extern void _ZN9S604C5_nt3v16Ev();
extern void _ZN9S604C5_nt3v17Ev();
extern void _ZN9S604C5_nt3v18Ev();
extern void _ZN9S604C5_nt3v19Ev();
extern void _ZN9S604C5_nt3v20Ev();
extern void _ZN9S604C5_nt3v21Ev();
extern void _ZN9S604C5_nt3v22Ev();
extern void _ZN9S604C5_nt3v23Ev();
extern void _ZN9S604C5_nt3v24Ev();
extern void _ZN9S604C5_nt3v25Ev();
extern void _ZN9S604C5_nt3v26Ev();
extern void _ZN9S604C5_nt3v27Ev();
extern void _ZN9S604C5_nt3v28Ev();
extern void _ZN9S604C5_nt3v29Ev();
extern void _ZN9S604C5_nt3v30Ev();
extern void _ZN9S604C5_nt3v31Ev();
extern void _ZN9S604C5_nt3v32Ev();
extern void _ZN9S604C5_nt3v33Ev();
extern void _ZN9S604C5_nt3v34Ev();
extern void _ZN9S604C5_nt3v35Ev();
extern void _ZN9S604C5_nt3v36Ev();
extern void _ZN9S604C5_nt3v37Ev();
extern void _ZN9S604C5_nt3v38Ev();
extern void _ZN9S604C5_nt3v39Ev();
extern void _ZN9S604C5_nt3v40Ev();
extern void _ZN9S604C5_nt3v41Ev();
extern void _ZN9S604C5_nt3v42Ev();
extern void _ZN9S604C5_nt3v43Ev();
extern void _ZN9S604C5_nt3v44Ev();
extern void _ZN9S604C5_nt3v45Ev();
extern void _ZN9S604C5_nt3v46Ev();
extern void _ZN9S604C5_nt3v47Ev();
extern void _ZN9S604C5_nt3v48Ev();
extern void _ZN9S604C5_nt3v49Ev();
extern void _ZN9S604C5_nt3v50Ev();
extern void _ZN9S604C5_nt3v51Ev();
extern void _ZN9S604C5_nt3v52Ev();
extern void _ZN9S604C5_nt3v53Ev();
extern void _ZN9S604C5_nt3v54Ev();
extern void _ZN9S604C5_nt3v55Ev();
extern void _ZN9S604C5_nt3v56Ev();
extern void _ZN9S604C5_nt3v57Ev();
extern void _ZN9S604C5_nt3v58Ev();
extern void _ZN9S604C5_nt3v59Ev();
extern void _ZN9S604C5_nt3v60Ev();
extern void _ZN9S604C5_nt3v61Ev();
extern void _ZN9S604C5_nt3v62Ev();
extern void _ZN9S604C5_nt3v63Ev();
extern void _ZN9S604C5_nt3v64Ev();
extern void _ZN9S604C5_nt3v65Ev();
extern void _ZN9S604C5_nt3v66Ev();
extern void _ZN9S604C5_nt3v67Ev();
extern void _ZN9S604C5_nt3v68Ev();
static  VTBL_ENTRY vtc_S604C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S604C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S604C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S604C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI9S604C5_nt[];
VTBL_ENTRY *P__ZTI9S604C5_nt = _ZTI9S604C5_nt; 
extern  VTBL_ENTRY _ZTV9S604C5_nt[];
Class_Descriptor cd_S604C5_nt = {  "S604C5_nt", // class name
  0,0,//no base classes
  &(vtc_S604C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S604C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S604C5_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C9_nt  {
  void *s604c9f0;
  int s604c9f1[2];
  void  mf604c9(); // _ZN9S604C9_nt7mf604c9Ev
};
//SIG(-1 S604C9_nt) C1{ m Fp Fi[2]}


void  S604C9_nt ::mf604c9(){}

//skip512 S604C9_nt

#else // __cplusplus

Class_Descriptor cd_S604C9_nt = {  "S604C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C8_nt  : S604C9_nt {
};
//SIG(-1 S604C8_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S604C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
static Base_Class bases_S604C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C8_nt = {  "S604C8_nt", // class name
  bases_S604C8_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C7_nt  : S604C8_nt {
};
//SIG(-1 S604C7_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S604C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
extern Class_Descriptor cd_S604C8_nt;
static Base_Class bases_S604C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C10_nt  {
  int s604c10f0;
  void  mf604c10(); // _ZN10S604C10_nt8mf604c10Ev
};
//SIG(-1 S604C10_nt) C1{ m Fi}


void  S604C10_nt ::mf604c10(){}

//skip512 S604C10_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S604C10_nt[];
VTBL_ENTRY *P__ZTI10S604C10_nt = _ZTI10S604C10_nt; 
Class_Descriptor cd_S604C10_nt = {  "S604C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S604C10_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C14  : S604C9_nt {
};
//SIG(-1 S604C14) C1{ BC2{ m Fp Fi[2]}}



static void Test_S604C14()
{
  extern Class_Descriptor cd_S604C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C14, buf);
    S604C14 &lv = *(new (buf) S604C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C14)");
    check_base_class_offset(lv, (S604C9_nt*), 0, "S604C14");
    test_class_info(&lv, &cd_S604C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C14(Test_S604C14, "S604C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
static Base_Class bases_S604C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C14 = {  "S604C14", // class name
  bases_S604C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C13  : S604C14 {
};
//SIG(-1 S604C13) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S604C13()
{
  extern Class_Descriptor cd_S604C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C13, buf);
    S604C13 &lv = *(new (buf) S604C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C13)");
    check_base_class_offset(lv, (S604C9_nt*)(S604C14*), 0, "S604C13");
    check_base_class_offset(lv, (S604C14*), 0, "S604C13");
    test_class_info(&lv, &cd_S604C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C13(Test_S604C13, "S604C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
extern Class_Descriptor cd_S604C14;
static Base_Class bases_S604C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C13 = {  "S604C13", // class name
  bases_S604C13, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C15_nt  {
  int s604c15f0[3];
  void  mf604c15(); // _ZN10S604C15_nt8mf604c15Ev
};
//SIG(-1 S604C15_nt) C1{ m Fi[3]}


void  S604C15_nt ::mf604c15(){}

//skip512 S604C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C20  : S604C9_nt {
};
//SIG(-1 S604C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S604C20()
{
  extern Class_Descriptor cd_S604C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C20, buf);
    S604C20 &lv = *(new (buf) S604C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C20)");
    check_base_class_offset(lv, (S604C9_nt*), 0, "S604C20");
    test_class_info(&lv, &cd_S604C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C20(Test_S604C20, "S604C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
static Base_Class bases_S604C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C20 = {  "S604C20", // class name
  bases_S604C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C19  : S604C20 {
};
//SIG(-1 S604C19) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S604C19()
{
  extern Class_Descriptor cd_S604C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C19, buf);
    S604C19 &lv = *(new (buf) S604C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C19)");
    check_base_class_offset(lv, (S604C9_nt*)(S604C20*), 0, "S604C19");
    check_base_class_offset(lv, (S604C20*), 0, "S604C19");
    test_class_info(&lv, &cd_S604C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C19(Test_S604C19, "S604C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
extern Class_Descriptor cd_S604C20;
static Base_Class bases_S604C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C19 = {  "S604C19", // class name
  bases_S604C19, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C4_nt  : S604C5_nt {
  ::S604C7_nt s604c4f0;
  ::S604C7_nt s604c4f1;
  ::S604C10_nt s604c4f2;
  int s604c4f3;
  char s604c4f4[4];
  void *s604c4f5[2];
  ::S604C7_nt s604c4f6;
  unsigned int s604c4f7:1;
  unsigned int s604c4f8:1;
  unsigned int s604c4f9:1;
  unsigned int s604c4f10:1;
  unsigned int s604c4f11:1;
  unsigned int s604c4f12:1;
  unsigned int s604c4f13:1;
  unsigned int s604c4f14:1;
  unsigned int s604c4f15:1;
  unsigned int s604c4f16:1;
  unsigned int s604c4f17:1;
  unsigned int s604c4f18:1;
  unsigned int s604c4f19:1;
  unsigned int s604c4f20:1;
  unsigned int s604c4f21:1;
  unsigned int s604c4f22:1;
  unsigned int s604c4f23:1;
  unsigned int s604c4f24:1;
  unsigned int s604c4f25:1;
  unsigned int s604c4f26:1;
  unsigned int s604c4f27:1;
  unsigned int s604c4f28:1;
  unsigned int s604c4f29:1;
  unsigned int s604c4f30:1;
  unsigned int s604c4f31:1;
  unsigned int s604c4f32:1;
  unsigned int s604c4f33:1;
  unsigned int s604c4f34:1;
  unsigned int s604c4f35:1;
  unsigned int s604c4f36:1;
  unsigned int s604c4f37:1;
  unsigned int s604c4f38:1;
  unsigned int s604c4f39:1;
  unsigned int s604c4f40:1;
  unsigned int s604c4f41:1;
  unsigned int s604c4f42:1;
  unsigned int s604c4f43:1;
  unsigned int s604c4f44:1;
  unsigned int s604c4f45:1;
  unsigned int s604c4f46:1;
  unsigned int s604c4f47:1;
  unsigned int s604c4f48:1;
  unsigned int s604c4f49:1;
  unsigned int s604c4f50:1;
  unsigned int s604c4f51:1;
  unsigned int s604c4f52:1;
  unsigned int s604c4f53:1;
  unsigned int s604c4f54:1;
  unsigned int s604c4f55:1;
  unsigned int s604c4f56:1;
  unsigned int s604c4f57:1;
  unsigned int s604c4f58:1;
  unsigned int s604c4f59:1;
  unsigned int s604c4f60:1;
  unsigned int s604c4f61:1;
  unsigned int s604c4f62:1;
  unsigned int s604c4f63:1;
  unsigned int s604c4f64:1;
  unsigned int s604c4f65:1;
  unsigned int s604c4f66:1;
  unsigned int s604c4f67:1;
  unsigned int s604c4f68:1;
  unsigned int s604c4f69:1;
  unsigned int s604c4f70:1;
  unsigned int s604c4f71:1;
  unsigned int s604c4f72:1;
  unsigned int s604c4f73:1;
  unsigned int s604c4f74:1;
  unsigned int s604c4f75:1;
  unsigned int s604c4f76:1;
  unsigned int s604c4f77:1;
  unsigned int s604c4f78:1;
  unsigned int s604c4f79:1;
  unsigned int s604c4f80:1;
  unsigned int s604c4f81:1;
  unsigned int s604c4f82:1;
  unsigned int s604c4f83:1;
  int s604c4f84[5];
  void *s604c4f85[2];
  int s604c4f86[3];
  ::S604C6_nt s604c4f87;
  ::S604C6_nt s604c4f88;
  ::S604C6_nt s604c4f89;
  ::S604C13 s604c4f90;
  ::S604C13 s604c4f91;
  int s604c4f92;
  void *s604c4f93[2];
  ::S604C15_nt s604c4f94;
  ::S604C15_nt s604c4f95;
  ::S604C15_nt s604c4f96;
  ::S604C15_nt s604c4f97;
  void *s604c4f98;
  ::S604C6_nt s604c4f99;
  ::S604C13 s604c4f100;
  ::S604C15_nt s604c4f101;
  ::S604C15_nt s604c4f102;
  int s604c4f103;
  ::S604C15_nt s604c4f104;
  ::S604C15_nt s604c4f105;
  void *s604c4f106;
  int s604c4f107;
  char s604c4f108;
  ::S604C15_nt s604c4f109;
  ::S604C15_nt s604c4f110;
  void *s604c4f111;
  int s604c4f112;
  void *s604c4f113;
  ::S604C13 s604c4f114;
  ::S604C19 s604c4f115;
  ::S604C19 s604c4f116;
  virtual  ~S604C4_nt(); // _ZN9S604C4_ntD1Ev
  virtual void  v69(); // _ZN9S604C4_nt3v69Ev
  virtual void  v70(); // _ZN9S604C4_nt3v70Ev
  virtual void  v71(); // _ZN9S604C4_nt3v71Ev
  virtual void  v72(); // _ZN9S604C4_nt3v72Ev
  virtual void  v73(); // _ZN9S604C4_nt3v73Ev
  virtual void  v74(); // _ZN9S604C4_nt3v74Ev
  virtual void  v75(); // _ZN9S604C4_nt3v75Ev
  virtual void  v76(); // _ZN9S604C4_nt3v76Ev
  virtual void  v77(); // _ZN9S604C4_nt3v77Ev
  virtual void  v78(); // _ZN9S604C4_nt3v78Ev
  virtual void  v79(); // _ZN9S604C4_nt3v79Ev
  virtual void  v80(); // _ZN9S604C4_nt3v80Ev
  virtual void  v81(); // _ZN9S604C4_nt3v81Ev
  virtual void  v82(); // _ZN9S604C4_nt3v82Ev
  virtual void  v83(); // _ZN9S604C4_nt3v83Ev
  virtual void  v84(); // _ZN9S604C4_nt3v84Ev
  virtual void  v85(); // _ZN9S604C4_nt3v85Ev
  virtual void  v86(); // _ZN9S604C4_nt3v86Ev
  virtual void  v87(); // _ZN9S604C4_nt3v87Ev
  virtual void  v88(); // _ZN9S604C4_nt3v88Ev
  virtual void  v89(); // _ZN9S604C4_nt3v89Ev
  virtual void  v90(); // _ZN9S604C4_nt3v90Ev
  virtual void  v91(); // _ZN9S604C4_nt3v91Ev
  virtual void  v92(); // _ZN9S604C4_nt3v92Ev
  virtual void  v93(); // _ZN9S604C4_nt3v93Ev
  virtual void  v94(); // _ZN9S604C4_nt3v94Ev
  virtual void  v95(); // _ZN9S604C4_nt3v95Ev
  virtual void  v96(); // _ZN9S604C4_nt3v96Ev
  virtual void  v97(); // _ZN9S604C4_nt3v97Ev
  virtual void  v98(); // _ZN9S604C4_nt3v98Ev
  virtual void  v99(); // _ZN9S604C4_nt3v99Ev
  virtual void  v100(); // _ZN9S604C4_nt4v100Ev
  virtual void  v101(); // _ZN9S604C4_nt4v101Ev
  virtual void  v102(); // _ZN9S604C4_nt4v102Ev
  virtual void  v103(); // _ZN9S604C4_nt4v103Ev
  virtual void  v104(); // _ZN9S604C4_nt4v104Ev
  virtual void  v105(); // _ZN9S604C4_nt4v105Ev
  virtual void  v106(); // _ZN9S604C4_nt4v106Ev
  virtual void  v107(); // _ZN9S604C4_nt4v107Ev
  virtual void  v108(); // _ZN9S604C4_nt4v108Ev
  virtual void  v109(); // _ZN9S604C4_nt4v109Ev
  virtual void  v110(); // _ZN9S604C4_nt4v110Ev
  virtual void  v111(); // _ZN9S604C4_nt4v111Ev
  virtual void  v112(); // _ZN9S604C4_nt4v112Ev
  virtual void  v113(); // _ZN9S604C4_nt4v113Ev
  virtual void  v114(); // _ZN9S604C4_nt4v114Ev
  virtual void  v115(); // _ZN9S604C4_nt4v115Ev
  virtual void  v116(); // _ZN9S604C4_nt4v116Ev
  virtual void  v117(); // _ZN9S604C4_nt4v117Ev
  virtual void  v118(); // _ZN9S604C4_nt4v118Ev
  virtual void  v119(); // _ZN9S604C4_nt4v119Ev
  virtual void  v120(); // _ZN9S604C4_nt4v120Ev
  virtual void  v121(); // _ZN9S604C4_nt4v121Ev
  virtual void  v122(); // _ZN9S604C4_nt4v122Ev
  virtual void  v123(); // _ZN9S604C4_nt4v123Ev
  virtual void  v124(); // _ZN9S604C4_nt4v124Ev
  virtual void  v125(); // _ZN9S604C4_nt4v125Ev
  virtual void  v126(); // _ZN9S604C4_nt4v126Ev
  virtual void  v127(); // _ZN9S604C4_nt4v127Ev
  virtual void  v128(); // _ZN9S604C4_nt4v128Ev
  virtual void  v129(); // _ZN9S604C4_nt4v129Ev
  virtual void  v130(); // _ZN9S604C4_nt4v130Ev
  virtual void  v131(); // _ZN9S604C4_nt4v131Ev
  virtual void  v132(); // _ZN9S604C4_nt4v132Ev
  virtual void  v133(); // _ZN9S604C4_nt4v133Ev
  virtual void  v134(); // _ZN9S604C4_nt4v134Ev
  virtual void  v135(); // _ZN9S604C4_nt4v135Ev
  virtual void  v136(); // _ZN9S604C4_nt4v136Ev
  virtual void  v137(); // _ZN9S604C4_nt4v137Ev
  virtual void  v138(); // _ZN9S604C4_nt4v138Ev
  virtual void  v139(); // _ZN9S604C4_nt4v139Ev
  virtual void  v140(); // _ZN9S604C4_nt4v140Ev
  virtual void  v141(); // _ZN9S604C4_nt4v141Ev
  virtual void  v142(); // _ZN9S604C4_nt4v142Ev
  virtual void  v143(); // _ZN9S604C4_nt4v143Ev
  virtual void  v144(); // _ZN9S604C4_nt4v144Ev
  virtual void  v145(); // _ZN9S604C4_nt4v145Ev
  virtual void  v146(); // _ZN9S604C4_nt4v146Ev
  virtual void  v147(); // _ZN9S604C4_nt4v147Ev
  virtual void  v148(); // _ZN9S604C4_nt4v148Ev
  virtual void  v149(); // _ZN9S604C4_nt4v149Ev
  virtual void  v150(); // _ZN9S604C4_nt4v150Ev
  virtual void  v151(); // _ZN9S604C4_nt4v151Ev
  virtual void  v152(); // _ZN9S604C4_nt4v152Ev
  virtual void  v153(); // _ZN9S604C4_nt4v153Ev
  virtual void  v154(); // _ZN9S604C4_nt4v154Ev
  virtual void  v155(); // _ZN9S604C4_nt4v155Ev
  virtual void  v156(); // _ZN9S604C4_nt4v156Ev
  virtual void  v157(); // _ZN9S604C4_nt4v157Ev
  virtual void  v158(); // _ZN9S604C4_nt4v158Ev
  virtual void  v159(); // _ZN9S604C4_nt4v159Ev
  virtual void  v160(); // _ZN9S604C4_nt4v160Ev
  virtual void  v161(); // _ZN9S604C4_nt4v161Ev
  virtual void  v162(); // _ZN9S604C4_nt4v162Ev
  virtual void  v163(); // _ZN9S604C4_nt4v163Ev
  virtual void  v164(); // _ZN9S604C4_nt4v164Ev
  virtual void  v165(); // _ZN9S604C4_nt4v165Ev
  virtual void  v166(); // _ZN9S604C4_nt4v166Ev
  virtual void  v167(); // _ZN9S604C4_nt4v167Ev
  virtual void  v168(); // _ZN9S604C4_nt4v168Ev
  virtual void  v169(); // _ZN9S604C4_nt4v169Ev
  virtual void  v170(); // _ZN9S604C4_nt4v170Ev
  virtual void  v171(); // _ZN9S604C4_nt4v171Ev
  virtual void  v172(); // _ZN9S604C4_nt4v172Ev
  virtual void  v173(); // _ZN9S604C4_nt4v173Ev
  virtual void  v174(); // _ZN9S604C4_nt4v174Ev
  virtual void  v175(); // _ZN9S604C4_nt4v175Ev
  virtual void  v176(); // _ZN9S604C4_nt4v176Ev
  virtual void  v177(); // _ZN9S604C4_nt4v177Ev
  virtual void  v178(); // _ZN9S604C4_nt4v178Ev
  virtual void  v179(); // _ZN9S604C4_nt4v179Ev
  virtual void  v180(); // _ZN9S604C4_nt4v180Ev
  virtual void  v181(); // _ZN9S604C4_nt4v181Ev
  virtual void  v182(); // _ZN9S604C4_nt4v182Ev
  virtual void  v183(); // _ZN9S604C4_nt4v183Ev
  virtual void  v184(); // _ZN9S604C4_nt4v184Ev
  virtual void  v185(); // _ZN9S604C4_nt4v185Ev
  virtual void  v186(); // _ZN9S604C4_nt4v186Ev
  virtual void  v187(); // _ZN9S604C4_nt4v187Ev
  virtual void  v188(); // _ZN9S604C4_nt4v188Ev
  virtual void  v189(); // _ZN9S604C4_nt4v189Ev
  virtual void  v190(); // _ZN9S604C4_nt4v190Ev
  virtual void  v191(); // _ZN9S604C4_nt4v191Ev
  virtual void  v192(); // _ZN9S604C4_nt4v192Ev
  virtual void  v193(); // _ZN9S604C4_nt4v193Ev
  virtual void  v194(); // _ZN9S604C4_nt4v194Ev
  virtual void  v195(); // _ZN9S604C4_nt4v195Ev
  virtual void  v196(); // _ZN9S604C4_nt4v196Ev
  virtual void  v197(); // _ZN9S604C4_nt4v197Ev
  virtual void  v198(); // _ZN9S604C4_nt4v198Ev
  virtual void  v199(); // _ZN9S604C4_nt4v199Ev
  virtual void  v200(); // _ZN9S604C4_nt4v200Ev
  virtual void  v201(); // _ZN9S604C4_nt4v201Ev
  virtual void  v202(); // _ZN9S604C4_nt4v202Ev
  virtual void  v203(); // _ZN9S604C4_nt4v203Ev
  virtual void  v204(); // _ZN9S604C4_nt4v204Ev
  virtual void  v205(); // _ZN9S604C4_nt4v205Ev
  virtual void  v206(); // _ZN9S604C4_nt4v206Ev
  virtual void  v207(); // _ZN9S604C4_nt4v207Ev
  virtual void  v208(); // _ZN9S604C4_nt4v208Ev
  virtual void  v209(); // _ZN9S604C4_nt4v209Ev
  virtual void  v210(); // _ZN9S604C4_nt4v210Ev
  virtual void  v211(); // _ZN9S604C4_nt4v211Ev
  S604C4_nt(); // tgen
};
//SIG(-1 S604C4_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S604C4_nt ::~S604C4_nt(){ note_dtor("S604C4_nt", this);}
void  S604C4_nt ::v69(){vfunc_called(this, "_ZN9S604C4_nt3v69Ev");}
void  S604C4_nt ::v70(){vfunc_called(this, "_ZN9S604C4_nt3v70Ev");}
void  S604C4_nt ::v71(){vfunc_called(this, "_ZN9S604C4_nt3v71Ev");}
void  S604C4_nt ::v72(){vfunc_called(this, "_ZN9S604C4_nt3v72Ev");}
void  S604C4_nt ::v73(){vfunc_called(this, "_ZN9S604C4_nt3v73Ev");}
void  S604C4_nt ::v74(){vfunc_called(this, "_ZN9S604C4_nt3v74Ev");}
void  S604C4_nt ::v75(){vfunc_called(this, "_ZN9S604C4_nt3v75Ev");}
void  S604C4_nt ::v76(){vfunc_called(this, "_ZN9S604C4_nt3v76Ev");}
void  S604C4_nt ::v77(){vfunc_called(this, "_ZN9S604C4_nt3v77Ev");}
void  S604C4_nt ::v78(){vfunc_called(this, "_ZN9S604C4_nt3v78Ev");}
void  S604C4_nt ::v79(){vfunc_called(this, "_ZN9S604C4_nt3v79Ev");}
void  S604C4_nt ::v80(){vfunc_called(this, "_ZN9S604C4_nt3v80Ev");}
void  S604C4_nt ::v81(){vfunc_called(this, "_ZN9S604C4_nt3v81Ev");}
void  S604C4_nt ::v82(){vfunc_called(this, "_ZN9S604C4_nt3v82Ev");}
void  S604C4_nt ::v83(){vfunc_called(this, "_ZN9S604C4_nt3v83Ev");}
void  S604C4_nt ::v84(){vfunc_called(this, "_ZN9S604C4_nt3v84Ev");}
void  S604C4_nt ::v85(){vfunc_called(this, "_ZN9S604C4_nt3v85Ev");}
void  S604C4_nt ::v86(){vfunc_called(this, "_ZN9S604C4_nt3v86Ev");}
void  S604C4_nt ::v87(){vfunc_called(this, "_ZN9S604C4_nt3v87Ev");}
void  S604C4_nt ::v88(){vfunc_called(this, "_ZN9S604C4_nt3v88Ev");}
void  S604C4_nt ::v89(){vfunc_called(this, "_ZN9S604C4_nt3v89Ev");}
void  S604C4_nt ::v90(){vfunc_called(this, "_ZN9S604C4_nt3v90Ev");}
void  S604C4_nt ::v91(){vfunc_called(this, "_ZN9S604C4_nt3v91Ev");}
void  S604C4_nt ::v92(){vfunc_called(this, "_ZN9S604C4_nt3v92Ev");}
void  S604C4_nt ::v93(){vfunc_called(this, "_ZN9S604C4_nt3v93Ev");}
void  S604C4_nt ::v94(){vfunc_called(this, "_ZN9S604C4_nt3v94Ev");}
void  S604C4_nt ::v95(){vfunc_called(this, "_ZN9S604C4_nt3v95Ev");}
void  S604C4_nt ::v96(){vfunc_called(this, "_ZN9S604C4_nt3v96Ev");}
void  S604C4_nt ::v97(){vfunc_called(this, "_ZN9S604C4_nt3v97Ev");}
void  S604C4_nt ::v98(){vfunc_called(this, "_ZN9S604C4_nt3v98Ev");}
void  S604C4_nt ::v99(){vfunc_called(this, "_ZN9S604C4_nt3v99Ev");}
void  S604C4_nt ::v100(){vfunc_called(this, "_ZN9S604C4_nt4v100Ev");}
void  S604C4_nt ::v101(){vfunc_called(this, "_ZN9S604C4_nt4v101Ev");}
void  S604C4_nt ::v102(){vfunc_called(this, "_ZN9S604C4_nt4v102Ev");}
void  S604C4_nt ::v103(){vfunc_called(this, "_ZN9S604C4_nt4v103Ev");}
void  S604C4_nt ::v104(){vfunc_called(this, "_ZN9S604C4_nt4v104Ev");}
void  S604C4_nt ::v105(){vfunc_called(this, "_ZN9S604C4_nt4v105Ev");}
void  S604C4_nt ::v106(){vfunc_called(this, "_ZN9S604C4_nt4v106Ev");}
void  S604C4_nt ::v107(){vfunc_called(this, "_ZN9S604C4_nt4v107Ev");}
void  S604C4_nt ::v108(){vfunc_called(this, "_ZN9S604C4_nt4v108Ev");}
void  S604C4_nt ::v109(){vfunc_called(this, "_ZN9S604C4_nt4v109Ev");}
void  S604C4_nt ::v110(){vfunc_called(this, "_ZN9S604C4_nt4v110Ev");}
void  S604C4_nt ::v111(){vfunc_called(this, "_ZN9S604C4_nt4v111Ev");}
void  S604C4_nt ::v112(){vfunc_called(this, "_ZN9S604C4_nt4v112Ev");}
void  S604C4_nt ::v113(){vfunc_called(this, "_ZN9S604C4_nt4v113Ev");}
void  S604C4_nt ::v114(){vfunc_called(this, "_ZN9S604C4_nt4v114Ev");}
void  S604C4_nt ::v115(){vfunc_called(this, "_ZN9S604C4_nt4v115Ev");}
void  S604C4_nt ::v116(){vfunc_called(this, "_ZN9S604C4_nt4v116Ev");}
void  S604C4_nt ::v117(){vfunc_called(this, "_ZN9S604C4_nt4v117Ev");}
void  S604C4_nt ::v118(){vfunc_called(this, "_ZN9S604C4_nt4v118Ev");}
void  S604C4_nt ::v119(){vfunc_called(this, "_ZN9S604C4_nt4v119Ev");}
void  S604C4_nt ::v120(){vfunc_called(this, "_ZN9S604C4_nt4v120Ev");}
void  S604C4_nt ::v121(){vfunc_called(this, "_ZN9S604C4_nt4v121Ev");}
void  S604C4_nt ::v122(){vfunc_called(this, "_ZN9S604C4_nt4v122Ev");}
void  S604C4_nt ::v123(){vfunc_called(this, "_ZN9S604C4_nt4v123Ev");}
void  S604C4_nt ::v124(){vfunc_called(this, "_ZN9S604C4_nt4v124Ev");}
void  S604C4_nt ::v125(){vfunc_called(this, "_ZN9S604C4_nt4v125Ev");}
void  S604C4_nt ::v126(){vfunc_called(this, "_ZN9S604C4_nt4v126Ev");}
void  S604C4_nt ::v127(){vfunc_called(this, "_ZN9S604C4_nt4v127Ev");}
void  S604C4_nt ::v128(){vfunc_called(this, "_ZN9S604C4_nt4v128Ev");}
void  S604C4_nt ::v129(){vfunc_called(this, "_ZN9S604C4_nt4v129Ev");}
void  S604C4_nt ::v130(){vfunc_called(this, "_ZN9S604C4_nt4v130Ev");}
void  S604C4_nt ::v131(){vfunc_called(this, "_ZN9S604C4_nt4v131Ev");}
void  S604C4_nt ::v132(){vfunc_called(this, "_ZN9S604C4_nt4v132Ev");}
void  S604C4_nt ::v133(){vfunc_called(this, "_ZN9S604C4_nt4v133Ev");}
void  S604C4_nt ::v134(){vfunc_called(this, "_ZN9S604C4_nt4v134Ev");}
void  S604C4_nt ::v135(){vfunc_called(this, "_ZN9S604C4_nt4v135Ev");}
void  S604C4_nt ::v136(){vfunc_called(this, "_ZN9S604C4_nt4v136Ev");}
void  S604C4_nt ::v137(){vfunc_called(this, "_ZN9S604C4_nt4v137Ev");}
void  S604C4_nt ::v138(){vfunc_called(this, "_ZN9S604C4_nt4v138Ev");}
void  S604C4_nt ::v139(){vfunc_called(this, "_ZN9S604C4_nt4v139Ev");}
void  S604C4_nt ::v140(){vfunc_called(this, "_ZN9S604C4_nt4v140Ev");}
void  S604C4_nt ::v141(){vfunc_called(this, "_ZN9S604C4_nt4v141Ev");}
void  S604C4_nt ::v142(){vfunc_called(this, "_ZN9S604C4_nt4v142Ev");}
void  S604C4_nt ::v143(){vfunc_called(this, "_ZN9S604C4_nt4v143Ev");}
void  S604C4_nt ::v144(){vfunc_called(this, "_ZN9S604C4_nt4v144Ev");}
void  S604C4_nt ::v145(){vfunc_called(this, "_ZN9S604C4_nt4v145Ev");}
void  S604C4_nt ::v146(){vfunc_called(this, "_ZN9S604C4_nt4v146Ev");}
void  S604C4_nt ::v147(){vfunc_called(this, "_ZN9S604C4_nt4v147Ev");}
void  S604C4_nt ::v148(){vfunc_called(this, "_ZN9S604C4_nt4v148Ev");}
void  S604C4_nt ::v149(){vfunc_called(this, "_ZN9S604C4_nt4v149Ev");}
void  S604C4_nt ::v150(){vfunc_called(this, "_ZN9S604C4_nt4v150Ev");}
void  S604C4_nt ::v151(){vfunc_called(this, "_ZN9S604C4_nt4v151Ev");}
void  S604C4_nt ::v152(){vfunc_called(this, "_ZN9S604C4_nt4v152Ev");}
void  S604C4_nt ::v153(){vfunc_called(this, "_ZN9S604C4_nt4v153Ev");}
void  S604C4_nt ::v154(){vfunc_called(this, "_ZN9S604C4_nt4v154Ev");}
void  S604C4_nt ::v155(){vfunc_called(this, "_ZN9S604C4_nt4v155Ev");}
void  S604C4_nt ::v156(){vfunc_called(this, "_ZN9S604C4_nt4v156Ev");}
void  S604C4_nt ::v157(){vfunc_called(this, "_ZN9S604C4_nt4v157Ev");}
void  S604C4_nt ::v158(){vfunc_called(this, "_ZN9S604C4_nt4v158Ev");}
void  S604C4_nt ::v159(){vfunc_called(this, "_ZN9S604C4_nt4v159Ev");}
void  S604C4_nt ::v160(){vfunc_called(this, "_ZN9S604C4_nt4v160Ev");}
void  S604C4_nt ::v161(){vfunc_called(this, "_ZN9S604C4_nt4v161Ev");}
void  S604C4_nt ::v162(){vfunc_called(this, "_ZN9S604C4_nt4v162Ev");}
void  S604C4_nt ::v163(){vfunc_called(this, "_ZN9S604C4_nt4v163Ev");}
void  S604C4_nt ::v164(){vfunc_called(this, "_ZN9S604C4_nt4v164Ev");}
void  S604C4_nt ::v165(){vfunc_called(this, "_ZN9S604C4_nt4v165Ev");}
void  S604C4_nt ::v166(){vfunc_called(this, "_ZN9S604C4_nt4v166Ev");}
void  S604C4_nt ::v167(){vfunc_called(this, "_ZN9S604C4_nt4v167Ev");}
void  S604C4_nt ::v168(){vfunc_called(this, "_ZN9S604C4_nt4v168Ev");}
void  S604C4_nt ::v169(){vfunc_called(this, "_ZN9S604C4_nt4v169Ev");}
void  S604C4_nt ::v170(){vfunc_called(this, "_ZN9S604C4_nt4v170Ev");}
void  S604C4_nt ::v171(){vfunc_called(this, "_ZN9S604C4_nt4v171Ev");}
void  S604C4_nt ::v172(){vfunc_called(this, "_ZN9S604C4_nt4v172Ev");}
void  S604C4_nt ::v173(){vfunc_called(this, "_ZN9S604C4_nt4v173Ev");}
void  S604C4_nt ::v174(){vfunc_called(this, "_ZN9S604C4_nt4v174Ev");}
void  S604C4_nt ::v175(){vfunc_called(this, "_ZN9S604C4_nt4v175Ev");}
void  S604C4_nt ::v176(){vfunc_called(this, "_ZN9S604C4_nt4v176Ev");}
void  S604C4_nt ::v177(){vfunc_called(this, "_ZN9S604C4_nt4v177Ev");}
void  S604C4_nt ::v178(){vfunc_called(this, "_ZN9S604C4_nt4v178Ev");}
void  S604C4_nt ::v179(){vfunc_called(this, "_ZN9S604C4_nt4v179Ev");}
void  S604C4_nt ::v180(){vfunc_called(this, "_ZN9S604C4_nt4v180Ev");}
void  S604C4_nt ::v181(){vfunc_called(this, "_ZN9S604C4_nt4v181Ev");}
void  S604C4_nt ::v182(){vfunc_called(this, "_ZN9S604C4_nt4v182Ev");}
void  S604C4_nt ::v183(){vfunc_called(this, "_ZN9S604C4_nt4v183Ev");}
void  S604C4_nt ::v184(){vfunc_called(this, "_ZN9S604C4_nt4v184Ev");}
void  S604C4_nt ::v185(){vfunc_called(this, "_ZN9S604C4_nt4v185Ev");}
void  S604C4_nt ::v186(){vfunc_called(this, "_ZN9S604C4_nt4v186Ev");}
void  S604C4_nt ::v187(){vfunc_called(this, "_ZN9S604C4_nt4v187Ev");}
void  S604C4_nt ::v188(){vfunc_called(this, "_ZN9S604C4_nt4v188Ev");}
void  S604C4_nt ::v189(){vfunc_called(this, "_ZN9S604C4_nt4v189Ev");}
void  S604C4_nt ::v190(){vfunc_called(this, "_ZN9S604C4_nt4v190Ev");}
void  S604C4_nt ::v191(){vfunc_called(this, "_ZN9S604C4_nt4v191Ev");}
void  S604C4_nt ::v192(){vfunc_called(this, "_ZN9S604C4_nt4v192Ev");}
void  S604C4_nt ::v193(){vfunc_called(this, "_ZN9S604C4_nt4v193Ev");}
void  S604C4_nt ::v194(){vfunc_called(this, "_ZN9S604C4_nt4v194Ev");}
void  S604C4_nt ::v195(){vfunc_called(this, "_ZN9S604C4_nt4v195Ev");}
void  S604C4_nt ::v196(){vfunc_called(this, "_ZN9S604C4_nt4v196Ev");}
void  S604C4_nt ::v197(){vfunc_called(this, "_ZN9S604C4_nt4v197Ev");}
void  S604C4_nt ::v198(){vfunc_called(this, "_ZN9S604C4_nt4v198Ev");}
void  S604C4_nt ::v199(){vfunc_called(this, "_ZN9S604C4_nt4v199Ev");}
void  S604C4_nt ::v200(){vfunc_called(this, "_ZN9S604C4_nt4v200Ev");}
void  S604C4_nt ::v201(){vfunc_called(this, "_ZN9S604C4_nt4v201Ev");}
void  S604C4_nt ::v202(){vfunc_called(this, "_ZN9S604C4_nt4v202Ev");}
void  S604C4_nt ::v203(){vfunc_called(this, "_ZN9S604C4_nt4v203Ev");}
void  S604C4_nt ::v204(){vfunc_called(this, "_ZN9S604C4_nt4v204Ev");}
void  S604C4_nt ::v205(){vfunc_called(this, "_ZN9S604C4_nt4v205Ev");}
void  S604C4_nt ::v206(){vfunc_called(this, "_ZN9S604C4_nt4v206Ev");}
void  S604C4_nt ::v207(){vfunc_called(this, "_ZN9S604C4_nt4v207Ev");}
void  S604C4_nt ::v208(){vfunc_called(this, "_ZN9S604C4_nt4v208Ev");}
void  S604C4_nt ::v209(){vfunc_called(this, "_ZN9S604C4_nt4v209Ev");}
void  S604C4_nt ::v210(){vfunc_called(this, "_ZN9S604C4_nt4v210Ev");}
void  S604C4_nt ::v211(){vfunc_called(this, "_ZN9S604C4_nt4v211Ev");}
S604C4_nt ::S604C4_nt(){ note_ctor("S604C4_nt", this);} // tgen

//skip512 S604C4_nt

#else // __cplusplus

extern void _ZN9S604C4_ntC1Ev();
extern void _ZN9S604C4_ntD1Ev();
Name_Map name_map_S604C4_nt[] = {
  NSPAIR(_ZN9S604C4_ntC1Ev),
  NSPAIR(_ZN9S604C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S604C5_nt;
extern VTBL_ENTRY _ZTI9S604C5_nt[];
extern  VTBL_ENTRY _ZTV9S604C5_nt[];
static Base_Class bases_S604C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S604C4_nt[];
extern void _ZN9S604C4_ntD1Ev();
extern void _ZN9S604C4_ntD0Ev();
extern void _ZN9S604C5_nt2v5Ev();
extern void _ZN9S604C5_nt2v6Ev();
extern void _ZN9S604C5_nt2v7Ev();
extern void _ZN9S604C5_nt2v8Ev();
extern void _ZN9S604C5_nt2v9Ev();
extern void _ZN9S604C5_nt3v10Ev();
extern void _ZN9S604C5_nt3v11Ev();
extern void _ZN9S604C5_nt3v12Ev();
extern void _ZN9S604C5_nt3v13Ev();
extern void _ZN9S604C5_nt3v14Ev();
extern void _ZN9S604C5_nt3v15Ev();
extern void _ZN9S604C5_nt3v16Ev();
extern void _ZN9S604C5_nt3v17Ev();
extern void _ZN9S604C5_nt3v18Ev();
extern void _ZN9S604C5_nt3v19Ev();
extern void _ZN9S604C5_nt3v20Ev();
extern void _ZN9S604C5_nt3v21Ev();
extern void _ZN9S604C5_nt3v22Ev();
extern void _ZN9S604C5_nt3v23Ev();
extern void _ZN9S604C5_nt3v24Ev();
extern void _ZN9S604C5_nt3v25Ev();
extern void _ZN9S604C5_nt3v26Ev();
extern void _ZN9S604C5_nt3v27Ev();
extern void _ZN9S604C5_nt3v28Ev();
extern void _ZN9S604C5_nt3v29Ev();
extern void _ZN9S604C5_nt3v30Ev();
extern void _ZN9S604C5_nt3v31Ev();
extern void _ZN9S604C5_nt3v32Ev();
extern void _ZN9S604C5_nt3v33Ev();
extern void _ZN9S604C5_nt3v34Ev();
extern void _ZN9S604C5_nt3v35Ev();
extern void _ZN9S604C5_nt3v36Ev();
extern void _ZN9S604C5_nt3v37Ev();
extern void _ZN9S604C5_nt3v38Ev();
extern void _ZN9S604C5_nt3v39Ev();
extern void _ZN9S604C5_nt3v40Ev();
extern void _ZN9S604C5_nt3v41Ev();
extern void _ZN9S604C5_nt3v42Ev();
extern void _ZN9S604C5_nt3v43Ev();
extern void _ZN9S604C5_nt3v44Ev();
extern void _ZN9S604C5_nt3v45Ev();
extern void _ZN9S604C5_nt3v46Ev();
extern void _ZN9S604C5_nt3v47Ev();
extern void _ZN9S604C5_nt3v48Ev();
extern void _ZN9S604C5_nt3v49Ev();
extern void _ZN9S604C5_nt3v50Ev();
extern void _ZN9S604C5_nt3v51Ev();
extern void _ZN9S604C5_nt3v52Ev();
extern void _ZN9S604C5_nt3v53Ev();
extern void _ZN9S604C5_nt3v54Ev();
extern void _ZN9S604C5_nt3v55Ev();
extern void _ZN9S604C5_nt3v56Ev();
extern void _ZN9S604C5_nt3v57Ev();
extern void _ZN9S604C5_nt3v58Ev();
extern void _ZN9S604C5_nt3v59Ev();
extern void _ZN9S604C5_nt3v60Ev();
extern void _ZN9S604C5_nt3v61Ev();
extern void _ZN9S604C5_nt3v62Ev();
extern void _ZN9S604C5_nt3v63Ev();
extern void _ZN9S604C5_nt3v64Ev();
extern void _ZN9S604C5_nt3v65Ev();
extern void _ZN9S604C5_nt3v66Ev();
extern void _ZN9S604C5_nt3v67Ev();
extern void _ZN9S604C5_nt3v68Ev();
extern void _ZN9S604C4_nt3v69Ev();
extern void _ZN9S604C4_nt3v70Ev();
extern void _ZN9S604C4_nt3v71Ev();
extern void _ZN9S604C4_nt3v72Ev();
extern void _ZN9S604C4_nt3v73Ev();
extern void _ZN9S604C4_nt3v74Ev();
extern void _ZN9S604C4_nt3v75Ev();
extern void _ZN9S604C4_nt3v76Ev();
extern void _ZN9S604C4_nt3v77Ev();
extern void _ZN9S604C4_nt3v78Ev();
extern void _ZN9S604C4_nt3v79Ev();
extern void _ZN9S604C4_nt3v80Ev();
extern void _ZN9S604C4_nt3v81Ev();
extern void _ZN9S604C4_nt3v82Ev();
extern void _ZN9S604C4_nt3v83Ev();
extern void _ZN9S604C4_nt3v84Ev();
extern void _ZN9S604C4_nt3v85Ev();
extern void _ZN9S604C4_nt3v86Ev();
extern void _ZN9S604C4_nt3v87Ev();
extern void _ZN9S604C4_nt3v88Ev();
extern void _ZN9S604C4_nt3v89Ev();
extern void _ZN9S604C4_nt3v90Ev();
extern void _ZN9S604C4_nt3v91Ev();
extern void _ZN9S604C4_nt3v92Ev();
extern void _ZN9S604C4_nt3v93Ev();
extern void _ZN9S604C4_nt3v94Ev();
extern void _ZN9S604C4_nt3v95Ev();
extern void _ZN9S604C4_nt3v96Ev();
extern void _ZN9S604C4_nt3v97Ev();
extern void _ZN9S604C4_nt3v98Ev();
extern void _ZN9S604C4_nt3v99Ev();
extern void _ZN9S604C4_nt4v100Ev();
extern void _ZN9S604C4_nt4v101Ev();
extern void _ZN9S604C4_nt4v102Ev();
extern void _ZN9S604C4_nt4v103Ev();
extern void _ZN9S604C4_nt4v104Ev();
extern void _ZN9S604C4_nt4v105Ev();
extern void _ZN9S604C4_nt4v106Ev();
extern void _ZN9S604C4_nt4v107Ev();
extern void _ZN9S604C4_nt4v108Ev();
extern void _ZN9S604C4_nt4v109Ev();
extern void _ZN9S604C4_nt4v110Ev();
extern void _ZN9S604C4_nt4v111Ev();
extern void _ZN9S604C4_nt4v112Ev();
extern void _ZN9S604C4_nt4v113Ev();
extern void _ZN9S604C4_nt4v114Ev();
extern void _ZN9S604C4_nt4v115Ev();
extern void _ZN9S604C4_nt4v116Ev();
extern void _ZN9S604C4_nt4v117Ev();
extern void _ZN9S604C4_nt4v118Ev();
extern void _ZN9S604C4_nt4v119Ev();
extern void _ZN9S604C4_nt4v120Ev();
extern void _ZN9S604C4_nt4v121Ev();
extern void _ZN9S604C4_nt4v122Ev();
extern void _ZN9S604C4_nt4v123Ev();
extern void _ZN9S604C4_nt4v124Ev();
extern void _ZN9S604C4_nt4v125Ev();
extern void _ZN9S604C4_nt4v126Ev();
extern void _ZN9S604C4_nt4v127Ev();
extern void _ZN9S604C4_nt4v128Ev();
extern void _ZN9S604C4_nt4v129Ev();
extern void _ZN9S604C4_nt4v130Ev();
extern void _ZN9S604C4_nt4v131Ev();
extern void _ZN9S604C4_nt4v132Ev();
extern void _ZN9S604C4_nt4v133Ev();
extern void _ZN9S604C4_nt4v134Ev();
extern void _ZN9S604C4_nt4v135Ev();
extern void _ZN9S604C4_nt4v136Ev();
extern void _ZN9S604C4_nt4v137Ev();
extern void _ZN9S604C4_nt4v138Ev();
extern void _ZN9S604C4_nt4v139Ev();
extern void _ZN9S604C4_nt4v140Ev();
extern void _ZN9S604C4_nt4v141Ev();
extern void _ZN9S604C4_nt4v142Ev();
extern void _ZN9S604C4_nt4v143Ev();
extern void _ZN9S604C4_nt4v144Ev();
extern void _ZN9S604C4_nt4v145Ev();
extern void _ZN9S604C4_nt4v146Ev();
extern void _ZN9S604C4_nt4v147Ev();
extern void _ZN9S604C4_nt4v148Ev();
extern void _ZN9S604C4_nt4v149Ev();
extern void _ZN9S604C4_nt4v150Ev();
extern void _ZN9S604C4_nt4v151Ev();
extern void _ZN9S604C4_nt4v152Ev();
extern void _ZN9S604C4_nt4v153Ev();
extern void _ZN9S604C4_nt4v154Ev();
extern void _ZN9S604C4_nt4v155Ev();
extern void _ZN9S604C4_nt4v156Ev();
extern void _ZN9S604C4_nt4v157Ev();
extern void _ZN9S604C4_nt4v158Ev();
extern void _ZN9S604C4_nt4v159Ev();
extern void _ZN9S604C4_nt4v160Ev();
extern void _ZN9S604C4_nt4v161Ev();
extern void _ZN9S604C4_nt4v162Ev();
extern void _ZN9S604C4_nt4v163Ev();
extern void _ZN9S604C4_nt4v164Ev();
extern void _ZN9S604C4_nt4v165Ev();
extern void _ZN9S604C4_nt4v166Ev();
extern void _ZN9S604C4_nt4v167Ev();
extern void _ZN9S604C4_nt4v168Ev();
extern void _ZN9S604C4_nt4v169Ev();
extern void _ZN9S604C4_nt4v170Ev();
extern void _ZN9S604C4_nt4v171Ev();
extern void _ZN9S604C4_nt4v172Ev();
extern void _ZN9S604C4_nt4v173Ev();
extern void _ZN9S604C4_nt4v174Ev();
extern void _ZN9S604C4_nt4v175Ev();
extern void _ZN9S604C4_nt4v176Ev();
extern void _ZN9S604C4_nt4v177Ev();
extern void _ZN9S604C4_nt4v178Ev();
extern void _ZN9S604C4_nt4v179Ev();
extern void _ZN9S604C4_nt4v180Ev();
extern void _ZN9S604C4_nt4v181Ev();
extern void _ZN9S604C4_nt4v182Ev();
extern void _ZN9S604C4_nt4v183Ev();
extern void _ZN9S604C4_nt4v184Ev();
extern void _ZN9S604C4_nt4v185Ev();
extern void _ZN9S604C4_nt4v186Ev();
extern void _ZN9S604C4_nt4v187Ev();
extern void _ZN9S604C4_nt4v188Ev();
extern void _ZN9S604C4_nt4v189Ev();
extern void _ZN9S604C4_nt4v190Ev();
extern void _ZN9S604C4_nt4v191Ev();
extern void _ZN9S604C4_nt4v192Ev();
extern void _ZN9S604C4_nt4v193Ev();
extern void _ZN9S604C4_nt4v194Ev();
extern void _ZN9S604C4_nt4v195Ev();
extern void _ZN9S604C4_nt4v196Ev();
extern void _ZN9S604C4_nt4v197Ev();
extern void _ZN9S604C4_nt4v198Ev();
extern void _ZN9S604C4_nt4v199Ev();
extern void _ZN9S604C4_nt4v200Ev();
extern void _ZN9S604C4_nt4v201Ev();
extern void _ZN9S604C4_nt4v202Ev();
extern void _ZN9S604C4_nt4v203Ev();
extern void _ZN9S604C4_nt4v204Ev();
extern void _ZN9S604C4_nt4v205Ev();
extern void _ZN9S604C4_nt4v206Ev();
extern void _ZN9S604C4_nt4v207Ev();
extern void _ZN9S604C4_nt4v208Ev();
extern void _ZN9S604C4_nt4v209Ev();
extern void _ZN9S604C4_nt4v210Ev();
extern void _ZN9S604C4_nt4v211Ev();
static  VTBL_ENTRY vtc_S604C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S604C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S604C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S604C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v211Ev,
};
extern VTBL_ENTRY _ZTI9S604C4_nt[];
VTBL_ENTRY *P__ZTI9S604C4_nt = _ZTI9S604C4_nt; 
extern  VTBL_ENTRY _ZTV9S604C4_nt[];
Class_Descriptor cd_S604C4_nt = {  "S604C4_nt", // class name
  bases_S604C4_nt, 1,
  &(vtc_S604C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI9S604C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S604C4_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C25  : S604C9_nt {
};
//SIG(-1 S604C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S604C25()
{
  extern Class_Descriptor cd_S604C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C25, buf);
    S604C25 &lv = *(new (buf) S604C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C25)");
    check_base_class_offset(lv, (S604C9_nt*), 0, "S604C25");
    test_class_info(&lv, &cd_S604C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C25(Test_S604C25, "S604C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
static Base_Class bases_S604C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C25 = {  "S604C25", // class name
  bases_S604C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C24  : S604C25 {
};
//SIG(-1 S604C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S604C24()
{
  extern Class_Descriptor cd_S604C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C24, buf);
    S604C24 &lv = *(new (buf) S604C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C24)");
    check_base_class_offset(lv, (S604C9_nt*)(S604C25*), 0, "S604C24");
    check_base_class_offset(lv, (S604C25*), 0, "S604C24");
    test_class_info(&lv, &cd_S604C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C24(Test_S604C24, "S604C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
extern Class_Descriptor cd_S604C25;
static Base_Class bases_S604C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C24 = {  "S604C24", // class name
  bases_S604C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C23_nt  : S604C24 {
};
//SIG(-1 S604C23_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S604C23_nt

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
extern Class_Descriptor cd_S604C25;
extern Class_Descriptor cd_S604C24;
static Base_Class bases_S604C23_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S604C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C3_nt  : S604C4_nt {
  int s604c3f0[3];
  void *s604c3f1[2];
  int s604c3f2;
  void *s604c3f3[2];
  unsigned int s604c3f4:1;
  unsigned int s604c3f5:1;
  unsigned int s604c3f6:1;
  unsigned int s604c3f7:1;
  unsigned int s604c3f8:1;
  unsigned int s604c3f9:1;
  unsigned int s604c3f10:1;
  unsigned int s604c3f11:1;
  unsigned int s604c3f12:1;
  unsigned int s604c3f13:1;
  unsigned int s604c3f14:1;
  unsigned int s604c3f15:1;
  unsigned int s604c3f16:1;
  unsigned int s604c3f17:1;
  unsigned int s604c3f18:1;
  unsigned int s604c3f19:1;
  unsigned int s604c3f20:1;
  unsigned int s604c3f21:1;
  unsigned int s604c3f22:1;
  unsigned int s604c3f23:1;
  unsigned int s604c3f24:1;
  unsigned int s604c3f25:1;
  unsigned int s604c3f26:1;
  unsigned int s604c3f27:1;
  unsigned int s604c3f28:1;
  unsigned int s604c3f29:1;
  unsigned int s604c3f30:1;
  unsigned int s604c3f31:1;
  unsigned int s604c3f32:1;
  unsigned int s604c3f33:1;
  unsigned int s604c3f34:1;
  unsigned int s604c3f35:1;
  unsigned int s604c3f36:1;
  unsigned int s604c3f37:1;
  unsigned int s604c3f38:1;
  unsigned int s604c3f39:1;
  unsigned int s604c3f40:1;
  unsigned int s604c3f41:1;
  unsigned int s604c3f42:1;
  unsigned int s604c3f43:1;
  unsigned int s604c3f44:1;
  unsigned int s604c3f45:1;
  unsigned int s604c3f46:1;
  unsigned int s604c3f47:1;
  unsigned int s604c3f48:1;
  unsigned int s604c3f49:1;
  unsigned int s604c3f50:1;
  unsigned int s604c3f51:1;
  unsigned int s604c3f52:1;
  unsigned int s604c3f53:1;
  int s604c3f54[5];
  char s604c3f55[4];
  int s604c3f56[10];
  void *s604c3f57[2];
  int s604c3f58[4];
  ::S604C15_nt s604c3f59;
  int s604c3f60[19];
  ::S604C15_nt s604c3f61;
  int s604c3f62[2];
  void *s604c3f63;
  int s604c3f64[5];
  ::S604C15_nt s604c3f65;
  ::S604C15_nt s604c3f66;
  int s604c3f67;
  void *s604c3f68;
  int s604c3f69;
  ::S604C15_nt s604c3f70;
  int s604c3f71;
  void *s604c3f72;
  int s604c3f73[3];
  ::S604C23_nt s604c3f74;
  void *s604c3f75[3];
  ::S604C6_nt s604c3f76;
  ::S604C6_nt s604c3f77;
  void *s604c3f78;
  int s604c3f79;
  ::S604C15_nt s604c3f80;
  void *s604c3f81;
  ::S604C15_nt s604c3f82;
  void *s604c3f83[2];
  int s604c3f84[2];
  void *s604c3f85;
  int s604c3f86[2];
  void *s604c3f87;
  int s604c3f88[3];
  void *s604c3f89[3];
  ::S604C15_nt s604c3f90;
  ::S604C15_nt s604c3f91;
  int s604c3f92;
  void *s604c3f93[2];
  int s604c3f94;
  virtual  ~S604C3_nt(); // _ZN9S604C3_ntD1Ev
  virtual void  v212(); // _ZN9S604C3_nt4v212Ev
  virtual void  v213(); // _ZN9S604C3_nt4v213Ev
  virtual void  v214(); // _ZN9S604C3_nt4v214Ev
  virtual void  v215(); // _ZN9S604C3_nt4v215Ev
  virtual void  v216(); // _ZN9S604C3_nt4v216Ev
  virtual void  v217(); // _ZN9S604C3_nt4v217Ev
  virtual void  v218(); // _ZN9S604C3_nt4v218Ev
  virtual void  v219(); // _ZN9S604C3_nt4v219Ev
  virtual void  v220(); // _ZN9S604C3_nt4v220Ev
  virtual void  v221(); // _ZN9S604C3_nt4v221Ev
  virtual void  v222(); // _ZN9S604C3_nt4v222Ev
  virtual void  v223(); // _ZN9S604C3_nt4v223Ev
  virtual void  v224(); // _ZN9S604C3_nt4v224Ev
  virtual void  v225(); // _ZN9S604C3_nt4v225Ev
  virtual void  v226(); // _ZN9S604C3_nt4v226Ev
  virtual void  v227(); // _ZN9S604C3_nt4v227Ev
  virtual void  v228(); // _ZN9S604C3_nt4v228Ev
  virtual void  v229(); // _ZN9S604C3_nt4v229Ev
  virtual void  v230(); // _ZN9S604C3_nt4v230Ev
  virtual void  v231(); // _ZN9S604C3_nt4v231Ev
  virtual void  v232(); // _ZN9S604C3_nt4v232Ev
  virtual void  v233(); // _ZN9S604C3_nt4v233Ev
  virtual void  v234(); // _ZN9S604C3_nt4v234Ev
  virtual void  v235(); // _ZN9S604C3_nt4v235Ev
  virtual void  v236(); // _ZN9S604C3_nt4v236Ev
  virtual void  v237(); // _ZN9S604C3_nt4v237Ev
  virtual void  v238(); // _ZN9S604C3_nt4v238Ev
  virtual void  v239(); // _ZN9S604C3_nt4v239Ev
  virtual void  v240(); // _ZN9S604C3_nt4v240Ev
  virtual void  v241(); // _ZN9S604C3_nt4v241Ev
  virtual void  v242(); // _ZN9S604C3_nt4v242Ev
  virtual void  v243(); // _ZN9S604C3_nt4v243Ev
  virtual void  v244(); // _ZN9S604C3_nt4v244Ev
  virtual void  v245(); // _ZN9S604C3_nt4v245Ev
  virtual void  v246(); // _ZN9S604C3_nt4v246Ev
  virtual void  v247(); // _ZN9S604C3_nt4v247Ev
  virtual void  v248(); // _ZN9S604C3_nt4v248Ev
  virtual void  v249(); // _ZN9S604C3_nt4v249Ev
  virtual void  v250(); // _ZN9S604C3_nt4v250Ev
  virtual void  v251(); // _ZN9S604C3_nt4v251Ev
  virtual void  v252(); // _ZN9S604C3_nt4v252Ev
  virtual void  v253(); // _ZN9S604C3_nt4v253Ev
  virtual void  v254(); // _ZN9S604C3_nt4v254Ev
  virtual void  v255(); // _ZN9S604C3_nt4v255Ev
  virtual void  v256(); // _ZN9S604C3_nt4v256Ev
  virtual void  v257(); // _ZN9S604C3_nt4v257Ev
  virtual void  v258(); // _ZN9S604C3_nt4v258Ev
  virtual void  v259(); // _ZN9S604C3_nt4v259Ev
  virtual void  v260(); // _ZN9S604C3_nt4v260Ev
  virtual void  v261(); // _ZN9S604C3_nt4v261Ev
  virtual void  v262(); // _ZN9S604C3_nt4v262Ev
  virtual void  v263(); // _ZN9S604C3_nt4v263Ev
  virtual void  v264(); // _ZN9S604C3_nt4v264Ev
  virtual void  v265(); // _ZN9S604C3_nt4v265Ev
  virtual void  v266(); // _ZN9S604C3_nt4v266Ev
  virtual void  v267(); // _ZN9S604C3_nt4v267Ev
  virtual void  v268(); // _ZN9S604C3_nt4v268Ev
  virtual void  v269(); // _ZN9S604C3_nt4v269Ev
  virtual void  v270(); // _ZN9S604C3_nt4v270Ev
  virtual void  v271(); // _ZN9S604C3_nt4v271Ev
  virtual void  v272(); // _ZN9S604C3_nt4v272Ev
  virtual void  v273(); // _ZN9S604C3_nt4v273Ev
  virtual void  v274(); // _ZN9S604C3_nt4v274Ev
  virtual void  v275(); // _ZN9S604C3_nt4v275Ev
  virtual void  v276(); // _ZN9S604C3_nt4v276Ev
  virtual void  v277(); // _ZN9S604C3_nt4v277Ev
  virtual void  v278(); // _ZN9S604C3_nt4v278Ev
  virtual void  v279(); // _ZN9S604C3_nt4v279Ev
  virtual void  v280(); // _ZN9S604C3_nt4v280Ev
  virtual void  v281(); // _ZN9S604C3_nt4v281Ev
  virtual void  v282(); // _ZN9S604C3_nt4v282Ev
  virtual void  v283(); // _ZN9S604C3_nt4v283Ev
  virtual void  v284(); // _ZN9S604C3_nt4v284Ev
  virtual void  v285(); // _ZN9S604C3_nt4v285Ev
  virtual void  v286(); // _ZN9S604C3_nt4v286Ev
  virtual void  v287(); // _ZN9S604C3_nt4v287Ev
  virtual void  v288(); // _ZN9S604C3_nt4v288Ev
  virtual void  v289(); // _ZN9S604C3_nt4v289Ev
  virtual void  v290(); // _ZN9S604C3_nt4v290Ev
  virtual void  v291(); // _ZN9S604C3_nt4v291Ev
  virtual void  v292(); // _ZN9S604C3_nt4v292Ev
  virtual void  v293(); // _ZN9S604C3_nt4v293Ev
  virtual void  v294(); // _ZN9S604C3_nt4v294Ev
  virtual void  v295(); // _ZN9S604C3_nt4v295Ev
  virtual void  v296(); // _ZN9S604C3_nt4v296Ev
  virtual void  v297(); // _ZN9S604C3_nt4v297Ev
  virtual void  v298(); // _ZN9S604C3_nt4v298Ev
  virtual void  v299(); // _ZN9S604C3_nt4v299Ev
  virtual void  v300(); // _ZN9S604C3_nt4v300Ev
  virtual void  v301(); // _ZN9S604C3_nt4v301Ev
  virtual void  v302(); // _ZN9S604C3_nt4v302Ev
  virtual void  v303(); // _ZN9S604C3_nt4v303Ev
  virtual void  v304(); // _ZN9S604C3_nt4v304Ev
  virtual void  v305(); // _ZN9S604C3_nt4v305Ev
  virtual void  v306(); // _ZN9S604C3_nt4v306Ev
  virtual void  v307(); // _ZN9S604C3_nt4v307Ev
  virtual void  v308(); // _ZN9S604C3_nt4v308Ev
  virtual void  v309(); // _ZN9S604C3_nt4v309Ev
  S604C3_nt(); // tgen
};
//SIG(-1 S604C3_nt) C1{ BC2{ BC3{ vd v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC11 Fi[19] FC11 Fi[2] Fp Fi[5] FC11 FC11 Fi Fp Fi FC11 Fi Fp Fi[3] FC14{ BC15{ BC16{ BC7}}} Fp[3] FC4 FC4 Fp Fi FC11 Fp FC11 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC11 FC11 Fi Fp[2] Fi}


 S604C3_nt ::~S604C3_nt(){ note_dtor("S604C3_nt", this);}
void  S604C3_nt ::v212(){vfunc_called(this, "_ZN9S604C3_nt4v212Ev");}
void  S604C3_nt ::v213(){vfunc_called(this, "_ZN9S604C3_nt4v213Ev");}
void  S604C3_nt ::v214(){vfunc_called(this, "_ZN9S604C3_nt4v214Ev");}
void  S604C3_nt ::v215(){vfunc_called(this, "_ZN9S604C3_nt4v215Ev");}
void  S604C3_nt ::v216(){vfunc_called(this, "_ZN9S604C3_nt4v216Ev");}
void  S604C3_nt ::v217(){vfunc_called(this, "_ZN9S604C3_nt4v217Ev");}
void  S604C3_nt ::v218(){vfunc_called(this, "_ZN9S604C3_nt4v218Ev");}
void  S604C3_nt ::v219(){vfunc_called(this, "_ZN9S604C3_nt4v219Ev");}
void  S604C3_nt ::v220(){vfunc_called(this, "_ZN9S604C3_nt4v220Ev");}
void  S604C3_nt ::v221(){vfunc_called(this, "_ZN9S604C3_nt4v221Ev");}
void  S604C3_nt ::v222(){vfunc_called(this, "_ZN9S604C3_nt4v222Ev");}
void  S604C3_nt ::v223(){vfunc_called(this, "_ZN9S604C3_nt4v223Ev");}
void  S604C3_nt ::v224(){vfunc_called(this, "_ZN9S604C3_nt4v224Ev");}
void  S604C3_nt ::v225(){vfunc_called(this, "_ZN9S604C3_nt4v225Ev");}
void  S604C3_nt ::v226(){vfunc_called(this, "_ZN9S604C3_nt4v226Ev");}
void  S604C3_nt ::v227(){vfunc_called(this, "_ZN9S604C3_nt4v227Ev");}
void  S604C3_nt ::v228(){vfunc_called(this, "_ZN9S604C3_nt4v228Ev");}
void  S604C3_nt ::v229(){vfunc_called(this, "_ZN9S604C3_nt4v229Ev");}
void  S604C3_nt ::v230(){vfunc_called(this, "_ZN9S604C3_nt4v230Ev");}
void  S604C3_nt ::v231(){vfunc_called(this, "_ZN9S604C3_nt4v231Ev");}
void  S604C3_nt ::v232(){vfunc_called(this, "_ZN9S604C3_nt4v232Ev");}
void  S604C3_nt ::v233(){vfunc_called(this, "_ZN9S604C3_nt4v233Ev");}
void  S604C3_nt ::v234(){vfunc_called(this, "_ZN9S604C3_nt4v234Ev");}
void  S604C3_nt ::v235(){vfunc_called(this, "_ZN9S604C3_nt4v235Ev");}
void  S604C3_nt ::v236(){vfunc_called(this, "_ZN9S604C3_nt4v236Ev");}
void  S604C3_nt ::v237(){vfunc_called(this, "_ZN9S604C3_nt4v237Ev");}
void  S604C3_nt ::v238(){vfunc_called(this, "_ZN9S604C3_nt4v238Ev");}
void  S604C3_nt ::v239(){vfunc_called(this, "_ZN9S604C3_nt4v239Ev");}
void  S604C3_nt ::v240(){vfunc_called(this, "_ZN9S604C3_nt4v240Ev");}
void  S604C3_nt ::v241(){vfunc_called(this, "_ZN9S604C3_nt4v241Ev");}
void  S604C3_nt ::v242(){vfunc_called(this, "_ZN9S604C3_nt4v242Ev");}
void  S604C3_nt ::v243(){vfunc_called(this, "_ZN9S604C3_nt4v243Ev");}
void  S604C3_nt ::v244(){vfunc_called(this, "_ZN9S604C3_nt4v244Ev");}
void  S604C3_nt ::v245(){vfunc_called(this, "_ZN9S604C3_nt4v245Ev");}
void  S604C3_nt ::v246(){vfunc_called(this, "_ZN9S604C3_nt4v246Ev");}
void  S604C3_nt ::v247(){vfunc_called(this, "_ZN9S604C3_nt4v247Ev");}
void  S604C3_nt ::v248(){vfunc_called(this, "_ZN9S604C3_nt4v248Ev");}
void  S604C3_nt ::v249(){vfunc_called(this, "_ZN9S604C3_nt4v249Ev");}
void  S604C3_nt ::v250(){vfunc_called(this, "_ZN9S604C3_nt4v250Ev");}
void  S604C3_nt ::v251(){vfunc_called(this, "_ZN9S604C3_nt4v251Ev");}
void  S604C3_nt ::v252(){vfunc_called(this, "_ZN9S604C3_nt4v252Ev");}
void  S604C3_nt ::v253(){vfunc_called(this, "_ZN9S604C3_nt4v253Ev");}
void  S604C3_nt ::v254(){vfunc_called(this, "_ZN9S604C3_nt4v254Ev");}
void  S604C3_nt ::v255(){vfunc_called(this, "_ZN9S604C3_nt4v255Ev");}
void  S604C3_nt ::v256(){vfunc_called(this, "_ZN9S604C3_nt4v256Ev");}
void  S604C3_nt ::v257(){vfunc_called(this, "_ZN9S604C3_nt4v257Ev");}
void  S604C3_nt ::v258(){vfunc_called(this, "_ZN9S604C3_nt4v258Ev");}
void  S604C3_nt ::v259(){vfunc_called(this, "_ZN9S604C3_nt4v259Ev");}
void  S604C3_nt ::v260(){vfunc_called(this, "_ZN9S604C3_nt4v260Ev");}
void  S604C3_nt ::v261(){vfunc_called(this, "_ZN9S604C3_nt4v261Ev");}
void  S604C3_nt ::v262(){vfunc_called(this, "_ZN9S604C3_nt4v262Ev");}
void  S604C3_nt ::v263(){vfunc_called(this, "_ZN9S604C3_nt4v263Ev");}
void  S604C3_nt ::v264(){vfunc_called(this, "_ZN9S604C3_nt4v264Ev");}
void  S604C3_nt ::v265(){vfunc_called(this, "_ZN9S604C3_nt4v265Ev");}
void  S604C3_nt ::v266(){vfunc_called(this, "_ZN9S604C3_nt4v266Ev");}
void  S604C3_nt ::v267(){vfunc_called(this, "_ZN9S604C3_nt4v267Ev");}
void  S604C3_nt ::v268(){vfunc_called(this, "_ZN9S604C3_nt4v268Ev");}
void  S604C3_nt ::v269(){vfunc_called(this, "_ZN9S604C3_nt4v269Ev");}
void  S604C3_nt ::v270(){vfunc_called(this, "_ZN9S604C3_nt4v270Ev");}
void  S604C3_nt ::v271(){vfunc_called(this, "_ZN9S604C3_nt4v271Ev");}
void  S604C3_nt ::v272(){vfunc_called(this, "_ZN9S604C3_nt4v272Ev");}
void  S604C3_nt ::v273(){vfunc_called(this, "_ZN9S604C3_nt4v273Ev");}
void  S604C3_nt ::v274(){vfunc_called(this, "_ZN9S604C3_nt4v274Ev");}
void  S604C3_nt ::v275(){vfunc_called(this, "_ZN9S604C3_nt4v275Ev");}
void  S604C3_nt ::v276(){vfunc_called(this, "_ZN9S604C3_nt4v276Ev");}
void  S604C3_nt ::v277(){vfunc_called(this, "_ZN9S604C3_nt4v277Ev");}
void  S604C3_nt ::v278(){vfunc_called(this, "_ZN9S604C3_nt4v278Ev");}
void  S604C3_nt ::v279(){vfunc_called(this, "_ZN9S604C3_nt4v279Ev");}
void  S604C3_nt ::v280(){vfunc_called(this, "_ZN9S604C3_nt4v280Ev");}
void  S604C3_nt ::v281(){vfunc_called(this, "_ZN9S604C3_nt4v281Ev");}
void  S604C3_nt ::v282(){vfunc_called(this, "_ZN9S604C3_nt4v282Ev");}
void  S604C3_nt ::v283(){vfunc_called(this, "_ZN9S604C3_nt4v283Ev");}
void  S604C3_nt ::v284(){vfunc_called(this, "_ZN9S604C3_nt4v284Ev");}
void  S604C3_nt ::v285(){vfunc_called(this, "_ZN9S604C3_nt4v285Ev");}
void  S604C3_nt ::v286(){vfunc_called(this, "_ZN9S604C3_nt4v286Ev");}
void  S604C3_nt ::v287(){vfunc_called(this, "_ZN9S604C3_nt4v287Ev");}
void  S604C3_nt ::v288(){vfunc_called(this, "_ZN9S604C3_nt4v288Ev");}
void  S604C3_nt ::v289(){vfunc_called(this, "_ZN9S604C3_nt4v289Ev");}
void  S604C3_nt ::v290(){vfunc_called(this, "_ZN9S604C3_nt4v290Ev");}
void  S604C3_nt ::v291(){vfunc_called(this, "_ZN9S604C3_nt4v291Ev");}
void  S604C3_nt ::v292(){vfunc_called(this, "_ZN9S604C3_nt4v292Ev");}
void  S604C3_nt ::v293(){vfunc_called(this, "_ZN9S604C3_nt4v293Ev");}
void  S604C3_nt ::v294(){vfunc_called(this, "_ZN9S604C3_nt4v294Ev");}
void  S604C3_nt ::v295(){vfunc_called(this, "_ZN9S604C3_nt4v295Ev");}
void  S604C3_nt ::v296(){vfunc_called(this, "_ZN9S604C3_nt4v296Ev");}
void  S604C3_nt ::v297(){vfunc_called(this, "_ZN9S604C3_nt4v297Ev");}
void  S604C3_nt ::v298(){vfunc_called(this, "_ZN9S604C3_nt4v298Ev");}
void  S604C3_nt ::v299(){vfunc_called(this, "_ZN9S604C3_nt4v299Ev");}
void  S604C3_nt ::v300(){vfunc_called(this, "_ZN9S604C3_nt4v300Ev");}
void  S604C3_nt ::v301(){vfunc_called(this, "_ZN9S604C3_nt4v301Ev");}
void  S604C3_nt ::v302(){vfunc_called(this, "_ZN9S604C3_nt4v302Ev");}
void  S604C3_nt ::v303(){vfunc_called(this, "_ZN9S604C3_nt4v303Ev");}
void  S604C3_nt ::v304(){vfunc_called(this, "_ZN9S604C3_nt4v304Ev");}
void  S604C3_nt ::v305(){vfunc_called(this, "_ZN9S604C3_nt4v305Ev");}
void  S604C3_nt ::v306(){vfunc_called(this, "_ZN9S604C3_nt4v306Ev");}
void  S604C3_nt ::v307(){vfunc_called(this, "_ZN9S604C3_nt4v307Ev");}
void  S604C3_nt ::v308(){vfunc_called(this, "_ZN9S604C3_nt4v308Ev");}
void  S604C3_nt ::v309(){vfunc_called(this, "_ZN9S604C3_nt4v309Ev");}
S604C3_nt ::S604C3_nt(){ note_ctor("S604C3_nt", this);} // tgen

//skip512 S604C3_nt

#else // __cplusplus

extern void _ZN9S604C3_ntC1Ev();
extern void _ZN9S604C3_ntD1Ev();
Name_Map name_map_S604C3_nt[] = {
  NSPAIR(_ZN9S604C3_ntC1Ev),
  NSPAIR(_ZN9S604C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S604C5_nt;
extern VTBL_ENTRY _ZTI9S604C5_nt[];
extern  VTBL_ENTRY _ZTV9S604C5_nt[];
extern Class_Descriptor cd_S604C4_nt;
extern VTBL_ENTRY _ZTI9S604C4_nt[];
extern  VTBL_ENTRY _ZTV9S604C4_nt[];
static Base_Class bases_S604C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S604C3_nt[];
extern void _ZN9S604C3_ntD1Ev();
extern void _ZN9S604C3_ntD0Ev();
extern void _ZN9S604C5_nt2v5Ev();
extern void _ZN9S604C5_nt2v6Ev();
extern void _ZN9S604C5_nt2v7Ev();
extern void _ZN9S604C5_nt2v8Ev();
extern void _ZN9S604C5_nt2v9Ev();
extern void _ZN9S604C5_nt3v10Ev();
extern void _ZN9S604C5_nt3v11Ev();
extern void _ZN9S604C5_nt3v12Ev();
extern void _ZN9S604C5_nt3v13Ev();
extern void _ZN9S604C5_nt3v14Ev();
extern void _ZN9S604C5_nt3v15Ev();
extern void _ZN9S604C5_nt3v16Ev();
extern void _ZN9S604C5_nt3v17Ev();
extern void _ZN9S604C5_nt3v18Ev();
extern void _ZN9S604C5_nt3v19Ev();
extern void _ZN9S604C5_nt3v20Ev();
extern void _ZN9S604C5_nt3v21Ev();
extern void _ZN9S604C5_nt3v22Ev();
extern void _ZN9S604C5_nt3v23Ev();
extern void _ZN9S604C5_nt3v24Ev();
extern void _ZN9S604C5_nt3v25Ev();
extern void _ZN9S604C5_nt3v26Ev();
extern void _ZN9S604C5_nt3v27Ev();
extern void _ZN9S604C5_nt3v28Ev();
extern void _ZN9S604C5_nt3v29Ev();
extern void _ZN9S604C5_nt3v30Ev();
extern void _ZN9S604C5_nt3v31Ev();
extern void _ZN9S604C5_nt3v32Ev();
extern void _ZN9S604C5_nt3v33Ev();
extern void _ZN9S604C5_nt3v34Ev();
extern void _ZN9S604C5_nt3v35Ev();
extern void _ZN9S604C5_nt3v36Ev();
extern void _ZN9S604C5_nt3v37Ev();
extern void _ZN9S604C5_nt3v38Ev();
extern void _ZN9S604C5_nt3v39Ev();
extern void _ZN9S604C5_nt3v40Ev();
extern void _ZN9S604C5_nt3v41Ev();
extern void _ZN9S604C5_nt3v42Ev();
extern void _ZN9S604C5_nt3v43Ev();
extern void _ZN9S604C5_nt3v44Ev();
extern void _ZN9S604C5_nt3v45Ev();
extern void _ZN9S604C5_nt3v46Ev();
extern void _ZN9S604C5_nt3v47Ev();
extern void _ZN9S604C5_nt3v48Ev();
extern void _ZN9S604C5_nt3v49Ev();
extern void _ZN9S604C5_nt3v50Ev();
extern void _ZN9S604C5_nt3v51Ev();
extern void _ZN9S604C5_nt3v52Ev();
extern void _ZN9S604C5_nt3v53Ev();
extern void _ZN9S604C5_nt3v54Ev();
extern void _ZN9S604C5_nt3v55Ev();
extern void _ZN9S604C5_nt3v56Ev();
extern void _ZN9S604C5_nt3v57Ev();
extern void _ZN9S604C5_nt3v58Ev();
extern void _ZN9S604C5_nt3v59Ev();
extern void _ZN9S604C5_nt3v60Ev();
extern void _ZN9S604C5_nt3v61Ev();
extern void _ZN9S604C5_nt3v62Ev();
extern void _ZN9S604C5_nt3v63Ev();
extern void _ZN9S604C5_nt3v64Ev();
extern void _ZN9S604C5_nt3v65Ev();
extern void _ZN9S604C5_nt3v66Ev();
extern void _ZN9S604C5_nt3v67Ev();
extern void _ZN9S604C5_nt3v68Ev();
extern void _ZN9S604C4_nt3v69Ev();
extern void _ZN9S604C4_nt3v70Ev();
extern void _ZN9S604C4_nt3v71Ev();
extern void _ZN9S604C4_nt3v72Ev();
extern void _ZN9S604C4_nt3v73Ev();
extern void _ZN9S604C4_nt3v74Ev();
extern void _ZN9S604C4_nt3v75Ev();
extern void _ZN9S604C4_nt3v76Ev();
extern void _ZN9S604C4_nt3v77Ev();
extern void _ZN9S604C4_nt3v78Ev();
extern void _ZN9S604C4_nt3v79Ev();
extern void _ZN9S604C4_nt3v80Ev();
extern void _ZN9S604C4_nt3v81Ev();
extern void _ZN9S604C4_nt3v82Ev();
extern void _ZN9S604C4_nt3v83Ev();
extern void _ZN9S604C4_nt3v84Ev();
extern void _ZN9S604C4_nt3v85Ev();
extern void _ZN9S604C4_nt3v86Ev();
extern void _ZN9S604C4_nt3v87Ev();
extern void _ZN9S604C4_nt3v88Ev();
extern void _ZN9S604C4_nt3v89Ev();
extern void _ZN9S604C4_nt3v90Ev();
extern void _ZN9S604C4_nt3v91Ev();
extern void _ZN9S604C4_nt3v92Ev();
extern void _ZN9S604C4_nt3v93Ev();
extern void _ZN9S604C4_nt3v94Ev();
extern void _ZN9S604C4_nt3v95Ev();
extern void _ZN9S604C4_nt3v96Ev();
extern void _ZN9S604C4_nt3v97Ev();
extern void _ZN9S604C4_nt3v98Ev();
extern void _ZN9S604C4_nt3v99Ev();
extern void _ZN9S604C4_nt4v100Ev();
extern void _ZN9S604C4_nt4v101Ev();
extern void _ZN9S604C4_nt4v102Ev();
extern void _ZN9S604C4_nt4v103Ev();
extern void _ZN9S604C4_nt4v104Ev();
extern void _ZN9S604C4_nt4v105Ev();
extern void _ZN9S604C4_nt4v106Ev();
extern void _ZN9S604C4_nt4v107Ev();
extern void _ZN9S604C4_nt4v108Ev();
extern void _ZN9S604C4_nt4v109Ev();
extern void _ZN9S604C4_nt4v110Ev();
extern void _ZN9S604C4_nt4v111Ev();
extern void _ZN9S604C4_nt4v112Ev();
extern void _ZN9S604C4_nt4v113Ev();
extern void _ZN9S604C4_nt4v114Ev();
extern void _ZN9S604C4_nt4v115Ev();
extern void _ZN9S604C4_nt4v116Ev();
extern void _ZN9S604C4_nt4v117Ev();
extern void _ZN9S604C4_nt4v118Ev();
extern void _ZN9S604C4_nt4v119Ev();
extern void _ZN9S604C4_nt4v120Ev();
extern void _ZN9S604C4_nt4v121Ev();
extern void _ZN9S604C4_nt4v122Ev();
extern void _ZN9S604C4_nt4v123Ev();
extern void _ZN9S604C4_nt4v124Ev();
extern void _ZN9S604C4_nt4v125Ev();
extern void _ZN9S604C4_nt4v126Ev();
extern void _ZN9S604C4_nt4v127Ev();
extern void _ZN9S604C4_nt4v128Ev();
extern void _ZN9S604C4_nt4v129Ev();
extern void _ZN9S604C4_nt4v130Ev();
extern void _ZN9S604C4_nt4v131Ev();
extern void _ZN9S604C4_nt4v132Ev();
extern void _ZN9S604C4_nt4v133Ev();
extern void _ZN9S604C4_nt4v134Ev();
extern void _ZN9S604C4_nt4v135Ev();
extern void _ZN9S604C4_nt4v136Ev();
extern void _ZN9S604C4_nt4v137Ev();
extern void _ZN9S604C4_nt4v138Ev();
extern void _ZN9S604C4_nt4v139Ev();
extern void _ZN9S604C4_nt4v140Ev();
extern void _ZN9S604C4_nt4v141Ev();
extern void _ZN9S604C4_nt4v142Ev();
extern void _ZN9S604C4_nt4v143Ev();
extern void _ZN9S604C4_nt4v144Ev();
extern void _ZN9S604C4_nt4v145Ev();
extern void _ZN9S604C4_nt4v146Ev();
extern void _ZN9S604C4_nt4v147Ev();
extern void _ZN9S604C4_nt4v148Ev();
extern void _ZN9S604C4_nt4v149Ev();
extern void _ZN9S604C4_nt4v150Ev();
extern void _ZN9S604C4_nt4v151Ev();
extern void _ZN9S604C4_nt4v152Ev();
extern void _ZN9S604C4_nt4v153Ev();
extern void _ZN9S604C4_nt4v154Ev();
extern void _ZN9S604C4_nt4v155Ev();
extern void _ZN9S604C4_nt4v156Ev();
extern void _ZN9S604C4_nt4v157Ev();
extern void _ZN9S604C4_nt4v158Ev();
extern void _ZN9S604C4_nt4v159Ev();
extern void _ZN9S604C4_nt4v160Ev();
extern void _ZN9S604C4_nt4v161Ev();
extern void _ZN9S604C4_nt4v162Ev();
extern void _ZN9S604C4_nt4v163Ev();
extern void _ZN9S604C4_nt4v164Ev();
extern void _ZN9S604C4_nt4v165Ev();
extern void _ZN9S604C4_nt4v166Ev();
extern void _ZN9S604C4_nt4v167Ev();
extern void _ZN9S604C4_nt4v168Ev();
extern void _ZN9S604C4_nt4v169Ev();
extern void _ZN9S604C4_nt4v170Ev();
extern void _ZN9S604C4_nt4v171Ev();
extern void _ZN9S604C4_nt4v172Ev();
extern void _ZN9S604C4_nt4v173Ev();
extern void _ZN9S604C4_nt4v174Ev();
extern void _ZN9S604C4_nt4v175Ev();
extern void _ZN9S604C4_nt4v176Ev();
extern void _ZN9S604C4_nt4v177Ev();
extern void _ZN9S604C4_nt4v178Ev();
extern void _ZN9S604C4_nt4v179Ev();
extern void _ZN9S604C4_nt4v180Ev();
extern void _ZN9S604C4_nt4v181Ev();
extern void _ZN9S604C4_nt4v182Ev();
extern void _ZN9S604C4_nt4v183Ev();
extern void _ZN9S604C4_nt4v184Ev();
extern void _ZN9S604C4_nt4v185Ev();
extern void _ZN9S604C4_nt4v186Ev();
extern void _ZN9S604C4_nt4v187Ev();
extern void _ZN9S604C4_nt4v188Ev();
extern void _ZN9S604C4_nt4v189Ev();
extern void _ZN9S604C4_nt4v190Ev();
extern void _ZN9S604C4_nt4v191Ev();
extern void _ZN9S604C4_nt4v192Ev();
extern void _ZN9S604C4_nt4v193Ev();
extern void _ZN9S604C4_nt4v194Ev();
extern void _ZN9S604C4_nt4v195Ev();
extern void _ZN9S604C4_nt4v196Ev();
extern void _ZN9S604C4_nt4v197Ev();
extern void _ZN9S604C4_nt4v198Ev();
extern void _ZN9S604C4_nt4v199Ev();
extern void _ZN9S604C4_nt4v200Ev();
extern void _ZN9S604C4_nt4v201Ev();
extern void _ZN9S604C4_nt4v202Ev();
extern void _ZN9S604C4_nt4v203Ev();
extern void _ZN9S604C4_nt4v204Ev();
extern void _ZN9S604C4_nt4v205Ev();
extern void _ZN9S604C4_nt4v206Ev();
extern void _ZN9S604C4_nt4v207Ev();
extern void _ZN9S604C4_nt4v208Ev();
extern void _ZN9S604C4_nt4v209Ev();
extern void _ZN9S604C4_nt4v210Ev();
extern void _ZN9S604C4_nt4v211Ev();
extern void _ZN9S604C3_nt4v212Ev();
extern void _ZN9S604C3_nt4v213Ev();
extern void _ZN9S604C3_nt4v214Ev();
extern void _ZN9S604C3_nt4v215Ev();
extern void _ZN9S604C3_nt4v216Ev();
extern void _ZN9S604C3_nt4v217Ev();
extern void _ZN9S604C3_nt4v218Ev();
extern void _ZN9S604C3_nt4v219Ev();
extern void _ZN9S604C3_nt4v220Ev();
extern void _ZN9S604C3_nt4v221Ev();
extern void _ZN9S604C3_nt4v222Ev();
extern void _ZN9S604C3_nt4v223Ev();
extern void _ZN9S604C3_nt4v224Ev();
extern void _ZN9S604C3_nt4v225Ev();
extern void _ZN9S604C3_nt4v226Ev();
extern void _ZN9S604C3_nt4v227Ev();
extern void _ZN9S604C3_nt4v228Ev();
extern void _ZN9S604C3_nt4v229Ev();
extern void _ZN9S604C3_nt4v230Ev();
extern void _ZN9S604C3_nt4v231Ev();
extern void _ZN9S604C3_nt4v232Ev();
extern void _ZN9S604C3_nt4v233Ev();
extern void _ZN9S604C3_nt4v234Ev();
extern void _ZN9S604C3_nt4v235Ev();
extern void _ZN9S604C3_nt4v236Ev();
extern void _ZN9S604C3_nt4v237Ev();
extern void _ZN9S604C3_nt4v238Ev();
extern void _ZN9S604C3_nt4v239Ev();
extern void _ZN9S604C3_nt4v240Ev();
extern void _ZN9S604C3_nt4v241Ev();
extern void _ZN9S604C3_nt4v242Ev();
extern void _ZN9S604C3_nt4v243Ev();
extern void _ZN9S604C3_nt4v244Ev();
extern void _ZN9S604C3_nt4v245Ev();
extern void _ZN9S604C3_nt4v246Ev();
extern void _ZN9S604C3_nt4v247Ev();
extern void _ZN9S604C3_nt4v248Ev();
extern void _ZN9S604C3_nt4v249Ev();
extern void _ZN9S604C3_nt4v250Ev();
extern void _ZN9S604C3_nt4v251Ev();
extern void _ZN9S604C3_nt4v252Ev();
extern void _ZN9S604C3_nt4v253Ev();
extern void _ZN9S604C3_nt4v254Ev();
extern void _ZN9S604C3_nt4v255Ev();
extern void _ZN9S604C3_nt4v256Ev();
extern void _ZN9S604C3_nt4v257Ev();
extern void _ZN9S604C3_nt4v258Ev();
extern void _ZN9S604C3_nt4v259Ev();
extern void _ZN9S604C3_nt4v260Ev();
extern void _ZN9S604C3_nt4v261Ev();
extern void _ZN9S604C3_nt4v262Ev();
extern void _ZN9S604C3_nt4v263Ev();
extern void _ZN9S604C3_nt4v264Ev();
extern void _ZN9S604C3_nt4v265Ev();
extern void _ZN9S604C3_nt4v266Ev();
extern void _ZN9S604C3_nt4v267Ev();
extern void _ZN9S604C3_nt4v268Ev();
extern void _ZN9S604C3_nt4v269Ev();
extern void _ZN9S604C3_nt4v270Ev();
extern void _ZN9S604C3_nt4v271Ev();
extern void _ZN9S604C3_nt4v272Ev();
extern void _ZN9S604C3_nt4v273Ev();
extern void _ZN9S604C3_nt4v274Ev();
extern void _ZN9S604C3_nt4v275Ev();
extern void _ZN9S604C3_nt4v276Ev();
extern void _ZN9S604C3_nt4v277Ev();
extern void _ZN9S604C3_nt4v278Ev();
extern void _ZN9S604C3_nt4v279Ev();
extern void _ZN9S604C3_nt4v280Ev();
extern void _ZN9S604C3_nt4v281Ev();
extern void _ZN9S604C3_nt4v282Ev();
extern void _ZN9S604C3_nt4v283Ev();
extern void _ZN9S604C3_nt4v284Ev();
extern void _ZN9S604C3_nt4v285Ev();
extern void _ZN9S604C3_nt4v286Ev();
extern void _ZN9S604C3_nt4v287Ev();
extern void _ZN9S604C3_nt4v288Ev();
extern void _ZN9S604C3_nt4v289Ev();
extern void _ZN9S604C3_nt4v290Ev();
extern void _ZN9S604C3_nt4v291Ev();
extern void _ZN9S604C3_nt4v292Ev();
extern void _ZN9S604C3_nt4v293Ev();
extern void _ZN9S604C3_nt4v294Ev();
extern void _ZN9S604C3_nt4v295Ev();
extern void _ZN9S604C3_nt4v296Ev();
extern void _ZN9S604C3_nt4v297Ev();
extern void _ZN9S604C3_nt4v298Ev();
extern void _ZN9S604C3_nt4v299Ev();
extern void _ZN9S604C3_nt4v300Ev();
extern void _ZN9S604C3_nt4v301Ev();
extern void _ZN9S604C3_nt4v302Ev();
extern void _ZN9S604C3_nt4v303Ev();
extern void _ZN9S604C3_nt4v304Ev();
extern void _ZN9S604C3_nt4v305Ev();
extern void _ZN9S604C3_nt4v306Ev();
extern void _ZN9S604C3_nt4v307Ev();
extern void _ZN9S604C3_nt4v308Ev();
extern void _ZN9S604C3_nt4v309Ev();
static  VTBL_ENTRY vtc_S604C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S604C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S604C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S604C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v220Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v221Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v222Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v223Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v224Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v225Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v226Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v227Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v228Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v229Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v230Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v231Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v232Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v233Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v234Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v235Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v236Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v237Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v238Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v239Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v240Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v241Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v242Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v243Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v244Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v245Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v246Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v247Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v248Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v249Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v250Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v251Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v252Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v253Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v254Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v255Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v256Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v257Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v258Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v259Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v260Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v261Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v262Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v263Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v264Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v265Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v266Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v267Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v268Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v269Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v270Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v271Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v272Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v273Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v274Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v275Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v276Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v277Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v278Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v279Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v280Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v281Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v282Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v283Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v284Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v285Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v286Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v287Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v288Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v289Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v290Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v291Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v292Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v293Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v294Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v295Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v296Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v297Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v298Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v299Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v300Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v301Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v302Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v303Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v304Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v305Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v306Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v307Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v308Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v309Ev,
};
extern VTBL_ENTRY _ZTI9S604C3_nt[];
VTBL_ENTRY *P__ZTI9S604C3_nt = _ZTI9S604C3_nt; 
extern  VTBL_ENTRY _ZTV9S604C3_nt[];
Class_Descriptor cd_S604C3_nt = {  "S604C3_nt", // class name
  bases_S604C3_nt, 2,
  &(vtc_S604C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1200,936), // object size
  NSPAIRA(_ZTI9S604C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S604C3_nt),309, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C27  : S604C9_nt {
};
//SIG(-1 S604C27) C1{ BC2{ m Fp Fi[2]}}



static void Test_S604C27()
{
  extern Class_Descriptor cd_S604C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C27, buf);
    S604C27 &lv = *(new (buf) S604C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C27)");
    check_base_class_offset(lv, (S604C9_nt*), 0, "S604C27");
    test_class_info(&lv, &cd_S604C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C27(Test_S604C27, "S604C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
static Base_Class bases_S604C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C27 = {  "S604C27", // class name
  bases_S604C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C26  : S604C27 {
};
//SIG(-1 S604C26) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S604C26()
{
  extern Class_Descriptor cd_S604C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S604C26, buf);
    S604C26 &lv = *(new (buf) S604C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S604C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C26)");
    check_base_class_offset(lv, (S604C9_nt*)(S604C27*), 0, "S604C26");
    check_base_class_offset(lv, (S604C27*), 0, "S604C26");
    test_class_info(&lv, &cd_S604C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C26(Test_S604C26, "S604C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S604C9_nt;
extern Class_Descriptor cd_S604C27;
static Base_Class bases_S604C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S604C26 = {  "S604C26", // class name
  bases_S604C26, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C2_nt  : S604C3_nt {
  void *s604c2f0;
  unsigned int s604c2f1:1;
  unsigned int s604c2f2:1;
  unsigned int s604c2f3:1;
  unsigned int s604c2f4:1;
  unsigned int s604c2f5:1;
  unsigned int s604c2f6:1;
  unsigned int s604c2f7:1;
  unsigned int s604c2f8:1;
  unsigned int s604c2f9:1;
  unsigned int s604c2f10:1;
  unsigned int s604c2f11:1;
  unsigned int s604c2f12:1;
  ::S604C26 s604c2f13;
  int s604c2f14;
  ::S604C15_nt s604c2f15;
  int s604c2f16[3];
  ::S604C15_nt s604c2f17;
  int s604c2f18[2];
  void *s604c2f19;
  int s604c2f20[2];
  char s604c2f21;
  int s604c2f22[8];
  virtual  ~S604C2_nt(); // _ZN9S604C2_ntD1Ev
  virtual void  v310(); // _ZN9S604C2_nt4v310Ev
  virtual void  v311(); // _ZN9S604C2_nt4v311Ev
  virtual void  v312(); // _ZN9S604C2_nt4v312Ev
  virtual void  v313(); // _ZN9S604C2_nt4v313Ev
  virtual void  v314(); // _ZN9S604C2_nt4v314Ev
  virtual void  v315(); // _ZN9S604C2_nt4v315Ev
  virtual void  v316(); // _ZN9S604C2_nt4v316Ev
  virtual void  v317(); // _ZN9S604C2_nt4v317Ev
  virtual void  v318(); // _ZN9S604C2_nt4v318Ev
  virtual void  v319(); // _ZN9S604C2_nt4v319Ev
  virtual void  v320(); // _ZN9S604C2_nt4v320Ev
  virtual void  v321(); // _ZN9S604C2_nt4v321Ev
  virtual void  v322(); // _ZN9S604C2_nt4v322Ev
  virtual void  v323(); // _ZN9S604C2_nt4v323Ev
  virtual void  v324(); // _ZN9S604C2_nt4v324Ev
  virtual void  v325(); // _ZN9S604C2_nt4v325Ev
  virtual void  v326(); // _ZN9S604C2_nt4v326Ev
  virtual void  v327(); // _ZN9S604C2_nt4v327Ev
  virtual void  v328(); // _ZN9S604C2_nt4v328Ev
  virtual void  v329(); // _ZN9S604C2_nt4v329Ev
  virtual void  v330(); // _ZN9S604C2_nt4v330Ev
  virtual void  v331(); // _ZN9S604C2_nt4v331Ev
  S604C2_nt(); // tgen
};
//SIG(-1 S604C2_nt) C1{ BC2{ BC3{ BC4{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC12 Fi[19] FC12 Fi[2] Fp Fi[5] FC12 FC12 Fi Fp Fi FC12 Fi Fp Fi[3] FC15{ BC16{ BC17{ BC8}}} Fp[3] FC5 FC5 Fp Fi FC12 Fp FC12 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC12 FC12 Fi Fp[2] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC18{ BC19{ BC8}} Fi FC12 Fi[3] FC12 Fi[2] Fp Fi[2] Fc Fi[8]}


 S604C2_nt ::~S604C2_nt(){ note_dtor("S604C2_nt", this);}
void  S604C2_nt ::v310(){vfunc_called(this, "_ZN9S604C2_nt4v310Ev");}
void  S604C2_nt ::v311(){vfunc_called(this, "_ZN9S604C2_nt4v311Ev");}
void  S604C2_nt ::v312(){vfunc_called(this, "_ZN9S604C2_nt4v312Ev");}
void  S604C2_nt ::v313(){vfunc_called(this, "_ZN9S604C2_nt4v313Ev");}
void  S604C2_nt ::v314(){vfunc_called(this, "_ZN9S604C2_nt4v314Ev");}
void  S604C2_nt ::v315(){vfunc_called(this, "_ZN9S604C2_nt4v315Ev");}
void  S604C2_nt ::v316(){vfunc_called(this, "_ZN9S604C2_nt4v316Ev");}
void  S604C2_nt ::v317(){vfunc_called(this, "_ZN9S604C2_nt4v317Ev");}
void  S604C2_nt ::v318(){vfunc_called(this, "_ZN9S604C2_nt4v318Ev");}
void  S604C2_nt ::v319(){vfunc_called(this, "_ZN9S604C2_nt4v319Ev");}
void  S604C2_nt ::v320(){vfunc_called(this, "_ZN9S604C2_nt4v320Ev");}
void  S604C2_nt ::v321(){vfunc_called(this, "_ZN9S604C2_nt4v321Ev");}
void  S604C2_nt ::v322(){vfunc_called(this, "_ZN9S604C2_nt4v322Ev");}
void  S604C2_nt ::v323(){vfunc_called(this, "_ZN9S604C2_nt4v323Ev");}
void  S604C2_nt ::v324(){vfunc_called(this, "_ZN9S604C2_nt4v324Ev");}
void  S604C2_nt ::v325(){vfunc_called(this, "_ZN9S604C2_nt4v325Ev");}
void  S604C2_nt ::v326(){vfunc_called(this, "_ZN9S604C2_nt4v326Ev");}
void  S604C2_nt ::v327(){vfunc_called(this, "_ZN9S604C2_nt4v327Ev");}
void  S604C2_nt ::v328(){vfunc_called(this, "_ZN9S604C2_nt4v328Ev");}
void  S604C2_nt ::v329(){vfunc_called(this, "_ZN9S604C2_nt4v329Ev");}
void  S604C2_nt ::v330(){vfunc_called(this, "_ZN9S604C2_nt4v330Ev");}
void  S604C2_nt ::v331(){vfunc_called(this, "_ZN9S604C2_nt4v331Ev");}
S604C2_nt ::S604C2_nt(){ note_ctor("S604C2_nt", this);} // tgen

//skip512 S604C2_nt

#else // __cplusplus

extern void _ZN9S604C2_ntC1Ev();
extern void _ZN9S604C2_ntD1Ev();
Name_Map name_map_S604C2_nt[] = {
  NSPAIR(_ZN9S604C2_ntC1Ev),
  NSPAIR(_ZN9S604C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S604C5_nt;
extern VTBL_ENTRY _ZTI9S604C5_nt[];
extern  VTBL_ENTRY _ZTV9S604C5_nt[];
extern Class_Descriptor cd_S604C4_nt;
extern VTBL_ENTRY _ZTI9S604C4_nt[];
extern  VTBL_ENTRY _ZTV9S604C4_nt[];
extern Class_Descriptor cd_S604C3_nt;
extern VTBL_ENTRY _ZTI9S604C3_nt[];
extern  VTBL_ENTRY _ZTV9S604C3_nt[];
static Base_Class bases_S604C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S604C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S604C2_nt[];
extern void _ZN9S604C2_ntD1Ev();
extern void _ZN9S604C2_ntD0Ev();
extern void _ZN9S604C5_nt2v5Ev();
extern void _ZN9S604C5_nt2v6Ev();
extern void _ZN9S604C5_nt2v7Ev();
extern void _ZN9S604C5_nt2v8Ev();
extern void _ZN9S604C5_nt2v9Ev();
extern void _ZN9S604C5_nt3v10Ev();
extern void _ZN9S604C5_nt3v11Ev();
extern void _ZN9S604C5_nt3v12Ev();
extern void _ZN9S604C5_nt3v13Ev();
extern void _ZN9S604C5_nt3v14Ev();
extern void _ZN9S604C5_nt3v15Ev();
extern void _ZN9S604C5_nt3v16Ev();
extern void _ZN9S604C5_nt3v17Ev();
extern void _ZN9S604C5_nt3v18Ev();
extern void _ZN9S604C5_nt3v19Ev();
extern void _ZN9S604C5_nt3v20Ev();
extern void _ZN9S604C5_nt3v21Ev();
extern void _ZN9S604C5_nt3v22Ev();
extern void _ZN9S604C5_nt3v23Ev();
extern void _ZN9S604C5_nt3v24Ev();
extern void _ZN9S604C5_nt3v25Ev();
extern void _ZN9S604C5_nt3v26Ev();
extern void _ZN9S604C5_nt3v27Ev();
extern void _ZN9S604C5_nt3v28Ev();
extern void _ZN9S604C5_nt3v29Ev();
extern void _ZN9S604C5_nt3v30Ev();
extern void _ZN9S604C5_nt3v31Ev();
extern void _ZN9S604C5_nt3v32Ev();
extern void _ZN9S604C5_nt3v33Ev();
extern void _ZN9S604C5_nt3v34Ev();
extern void _ZN9S604C5_nt3v35Ev();
extern void _ZN9S604C5_nt3v36Ev();
extern void _ZN9S604C5_nt3v37Ev();
extern void _ZN9S604C5_nt3v38Ev();
extern void _ZN9S604C5_nt3v39Ev();
extern void _ZN9S604C5_nt3v40Ev();
extern void _ZN9S604C5_nt3v41Ev();
extern void _ZN9S604C5_nt3v42Ev();
extern void _ZN9S604C5_nt3v43Ev();
extern void _ZN9S604C5_nt3v44Ev();
extern void _ZN9S604C5_nt3v45Ev();
extern void _ZN9S604C5_nt3v46Ev();
extern void _ZN9S604C5_nt3v47Ev();
extern void _ZN9S604C5_nt3v48Ev();
extern void _ZN9S604C5_nt3v49Ev();
extern void _ZN9S604C5_nt3v50Ev();
extern void _ZN9S604C5_nt3v51Ev();
extern void _ZN9S604C5_nt3v52Ev();
extern void _ZN9S604C5_nt3v53Ev();
extern void _ZN9S604C5_nt3v54Ev();
extern void _ZN9S604C5_nt3v55Ev();
extern void _ZN9S604C5_nt3v56Ev();
extern void _ZN9S604C5_nt3v57Ev();
extern void _ZN9S604C5_nt3v58Ev();
extern void _ZN9S604C5_nt3v59Ev();
extern void _ZN9S604C5_nt3v60Ev();
extern void _ZN9S604C5_nt3v61Ev();
extern void _ZN9S604C5_nt3v62Ev();
extern void _ZN9S604C5_nt3v63Ev();
extern void _ZN9S604C5_nt3v64Ev();
extern void _ZN9S604C5_nt3v65Ev();
extern void _ZN9S604C5_nt3v66Ev();
extern void _ZN9S604C5_nt3v67Ev();
extern void _ZN9S604C5_nt3v68Ev();
extern void _ZN9S604C4_nt3v69Ev();
extern void _ZN9S604C4_nt3v70Ev();
extern void _ZN9S604C4_nt3v71Ev();
extern void _ZN9S604C4_nt3v72Ev();
extern void _ZN9S604C4_nt3v73Ev();
extern void _ZN9S604C4_nt3v74Ev();
extern void _ZN9S604C4_nt3v75Ev();
extern void _ZN9S604C4_nt3v76Ev();
extern void _ZN9S604C4_nt3v77Ev();
extern void _ZN9S604C4_nt3v78Ev();
extern void _ZN9S604C4_nt3v79Ev();
extern void _ZN9S604C4_nt3v80Ev();
extern void _ZN9S604C4_nt3v81Ev();
extern void _ZN9S604C4_nt3v82Ev();
extern void _ZN9S604C4_nt3v83Ev();
extern void _ZN9S604C4_nt3v84Ev();
extern void _ZN9S604C4_nt3v85Ev();
extern void _ZN9S604C4_nt3v86Ev();
extern void _ZN9S604C4_nt3v87Ev();
extern void _ZN9S604C4_nt3v88Ev();
extern void _ZN9S604C4_nt3v89Ev();
extern void _ZN9S604C4_nt3v90Ev();
extern void _ZN9S604C4_nt3v91Ev();
extern void _ZN9S604C4_nt3v92Ev();
extern void _ZN9S604C4_nt3v93Ev();
extern void _ZN9S604C4_nt3v94Ev();
extern void _ZN9S604C4_nt3v95Ev();
extern void _ZN9S604C4_nt3v96Ev();
extern void _ZN9S604C4_nt3v97Ev();
extern void _ZN9S604C4_nt3v98Ev();
extern void _ZN9S604C4_nt3v99Ev();
extern void _ZN9S604C4_nt4v100Ev();
extern void _ZN9S604C4_nt4v101Ev();
extern void _ZN9S604C4_nt4v102Ev();
extern void _ZN9S604C4_nt4v103Ev();
extern void _ZN9S604C4_nt4v104Ev();
extern void _ZN9S604C4_nt4v105Ev();
extern void _ZN9S604C4_nt4v106Ev();
extern void _ZN9S604C4_nt4v107Ev();
extern void _ZN9S604C4_nt4v108Ev();
extern void _ZN9S604C4_nt4v109Ev();
extern void _ZN9S604C4_nt4v110Ev();
extern void _ZN9S604C4_nt4v111Ev();
extern void _ZN9S604C4_nt4v112Ev();
extern void _ZN9S604C4_nt4v113Ev();
extern void _ZN9S604C4_nt4v114Ev();
extern void _ZN9S604C4_nt4v115Ev();
extern void _ZN9S604C4_nt4v116Ev();
extern void _ZN9S604C4_nt4v117Ev();
extern void _ZN9S604C4_nt4v118Ev();
extern void _ZN9S604C4_nt4v119Ev();
extern void _ZN9S604C4_nt4v120Ev();
extern void _ZN9S604C4_nt4v121Ev();
extern void _ZN9S604C4_nt4v122Ev();
extern void _ZN9S604C4_nt4v123Ev();
extern void _ZN9S604C4_nt4v124Ev();
extern void _ZN9S604C4_nt4v125Ev();
extern void _ZN9S604C4_nt4v126Ev();
extern void _ZN9S604C4_nt4v127Ev();
extern void _ZN9S604C4_nt4v128Ev();
extern void _ZN9S604C4_nt4v129Ev();
extern void _ZN9S604C4_nt4v130Ev();
extern void _ZN9S604C4_nt4v131Ev();
extern void _ZN9S604C4_nt4v132Ev();
extern void _ZN9S604C4_nt4v133Ev();
extern void _ZN9S604C4_nt4v134Ev();
extern void _ZN9S604C4_nt4v135Ev();
extern void _ZN9S604C4_nt4v136Ev();
extern void _ZN9S604C4_nt4v137Ev();
extern void _ZN9S604C4_nt4v138Ev();
extern void _ZN9S604C4_nt4v139Ev();
extern void _ZN9S604C4_nt4v140Ev();
extern void _ZN9S604C4_nt4v141Ev();
extern void _ZN9S604C4_nt4v142Ev();
extern void _ZN9S604C4_nt4v143Ev();
extern void _ZN9S604C4_nt4v144Ev();
extern void _ZN9S604C4_nt4v145Ev();
extern void _ZN9S604C4_nt4v146Ev();
extern void _ZN9S604C4_nt4v147Ev();
extern void _ZN9S604C4_nt4v148Ev();
extern void _ZN9S604C4_nt4v149Ev();
extern void _ZN9S604C4_nt4v150Ev();
extern void _ZN9S604C4_nt4v151Ev();
extern void _ZN9S604C4_nt4v152Ev();
extern void _ZN9S604C4_nt4v153Ev();
extern void _ZN9S604C4_nt4v154Ev();
extern void _ZN9S604C4_nt4v155Ev();
extern void _ZN9S604C4_nt4v156Ev();
extern void _ZN9S604C4_nt4v157Ev();
extern void _ZN9S604C4_nt4v158Ev();
extern void _ZN9S604C4_nt4v159Ev();
extern void _ZN9S604C4_nt4v160Ev();
extern void _ZN9S604C4_nt4v161Ev();
extern void _ZN9S604C4_nt4v162Ev();
extern void _ZN9S604C4_nt4v163Ev();
extern void _ZN9S604C4_nt4v164Ev();
extern void _ZN9S604C4_nt4v165Ev();
extern void _ZN9S604C4_nt4v166Ev();
extern void _ZN9S604C4_nt4v167Ev();
extern void _ZN9S604C4_nt4v168Ev();
extern void _ZN9S604C4_nt4v169Ev();
extern void _ZN9S604C4_nt4v170Ev();
extern void _ZN9S604C4_nt4v171Ev();
extern void _ZN9S604C4_nt4v172Ev();
extern void _ZN9S604C4_nt4v173Ev();
extern void _ZN9S604C4_nt4v174Ev();
extern void _ZN9S604C4_nt4v175Ev();
extern void _ZN9S604C4_nt4v176Ev();
extern void _ZN9S604C4_nt4v177Ev();
extern void _ZN9S604C4_nt4v178Ev();
extern void _ZN9S604C4_nt4v179Ev();
extern void _ZN9S604C4_nt4v180Ev();
extern void _ZN9S604C4_nt4v181Ev();
extern void _ZN9S604C4_nt4v182Ev();
extern void _ZN9S604C4_nt4v183Ev();
extern void _ZN9S604C4_nt4v184Ev();
extern void _ZN9S604C4_nt4v185Ev();
extern void _ZN9S604C4_nt4v186Ev();
extern void _ZN9S604C4_nt4v187Ev();
extern void _ZN9S604C4_nt4v188Ev();
extern void _ZN9S604C4_nt4v189Ev();
extern void _ZN9S604C4_nt4v190Ev();
extern void _ZN9S604C4_nt4v191Ev();
extern void _ZN9S604C4_nt4v192Ev();
extern void _ZN9S604C4_nt4v193Ev();
extern void _ZN9S604C4_nt4v194Ev();
extern void _ZN9S604C4_nt4v195Ev();
extern void _ZN9S604C4_nt4v196Ev();
extern void _ZN9S604C4_nt4v197Ev();
extern void _ZN9S604C4_nt4v198Ev();
extern void _ZN9S604C4_nt4v199Ev();
extern void _ZN9S604C4_nt4v200Ev();
extern void _ZN9S604C4_nt4v201Ev();
extern void _ZN9S604C4_nt4v202Ev();
extern void _ZN9S604C4_nt4v203Ev();
extern void _ZN9S604C4_nt4v204Ev();
extern void _ZN9S604C4_nt4v205Ev();
extern void _ZN9S604C4_nt4v206Ev();
extern void _ZN9S604C4_nt4v207Ev();
extern void _ZN9S604C4_nt4v208Ev();
extern void _ZN9S604C4_nt4v209Ev();
extern void _ZN9S604C4_nt4v210Ev();
extern void _ZN9S604C4_nt4v211Ev();
extern void _ZN9S604C3_nt4v212Ev();
extern void _ZN9S604C3_nt4v213Ev();
extern void _ZN9S604C3_nt4v214Ev();
extern void _ZN9S604C3_nt4v215Ev();
extern void _ZN9S604C3_nt4v216Ev();
extern void _ZN9S604C3_nt4v217Ev();
extern void _ZN9S604C3_nt4v218Ev();
extern void _ZN9S604C3_nt4v219Ev();
extern void _ZN9S604C3_nt4v220Ev();
extern void _ZN9S604C3_nt4v221Ev();
extern void _ZN9S604C3_nt4v222Ev();
extern void _ZN9S604C3_nt4v223Ev();
extern void _ZN9S604C3_nt4v224Ev();
extern void _ZN9S604C3_nt4v225Ev();
extern void _ZN9S604C3_nt4v226Ev();
extern void _ZN9S604C3_nt4v227Ev();
extern void _ZN9S604C3_nt4v228Ev();
extern void _ZN9S604C3_nt4v229Ev();
extern void _ZN9S604C3_nt4v230Ev();
extern void _ZN9S604C3_nt4v231Ev();
extern void _ZN9S604C3_nt4v232Ev();
extern void _ZN9S604C3_nt4v233Ev();
extern void _ZN9S604C3_nt4v234Ev();
extern void _ZN9S604C3_nt4v235Ev();
extern void _ZN9S604C3_nt4v236Ev();
extern void _ZN9S604C3_nt4v237Ev();
extern void _ZN9S604C3_nt4v238Ev();
extern void _ZN9S604C3_nt4v239Ev();
extern void _ZN9S604C3_nt4v240Ev();
extern void _ZN9S604C3_nt4v241Ev();
extern void _ZN9S604C3_nt4v242Ev();
extern void _ZN9S604C3_nt4v243Ev();
extern void _ZN9S604C3_nt4v244Ev();
extern void _ZN9S604C3_nt4v245Ev();
extern void _ZN9S604C3_nt4v246Ev();
extern void _ZN9S604C3_nt4v247Ev();
extern void _ZN9S604C3_nt4v248Ev();
extern void _ZN9S604C3_nt4v249Ev();
extern void _ZN9S604C3_nt4v250Ev();
extern void _ZN9S604C3_nt4v251Ev();
extern void _ZN9S604C3_nt4v252Ev();
extern void _ZN9S604C3_nt4v253Ev();
extern void _ZN9S604C3_nt4v254Ev();
extern void _ZN9S604C3_nt4v255Ev();
extern void _ZN9S604C3_nt4v256Ev();
extern void _ZN9S604C3_nt4v257Ev();
extern void _ZN9S604C3_nt4v258Ev();
extern void _ZN9S604C3_nt4v259Ev();
extern void _ZN9S604C3_nt4v260Ev();
extern void _ZN9S604C3_nt4v261Ev();
extern void _ZN9S604C3_nt4v262Ev();
extern void _ZN9S604C3_nt4v263Ev();
extern void _ZN9S604C3_nt4v264Ev();
extern void _ZN9S604C3_nt4v265Ev();
extern void _ZN9S604C3_nt4v266Ev();
extern void _ZN9S604C3_nt4v267Ev();
extern void _ZN9S604C3_nt4v268Ev();
extern void _ZN9S604C3_nt4v269Ev();
extern void _ZN9S604C3_nt4v270Ev();
extern void _ZN9S604C3_nt4v271Ev();
extern void _ZN9S604C3_nt4v272Ev();
extern void _ZN9S604C3_nt4v273Ev();
extern void _ZN9S604C3_nt4v274Ev();
extern void _ZN9S604C3_nt4v275Ev();
extern void _ZN9S604C3_nt4v276Ev();
extern void _ZN9S604C3_nt4v277Ev();
extern void _ZN9S604C3_nt4v278Ev();
extern void _ZN9S604C3_nt4v279Ev();
extern void _ZN9S604C3_nt4v280Ev();
extern void _ZN9S604C3_nt4v281Ev();
extern void _ZN9S604C3_nt4v282Ev();
extern void _ZN9S604C3_nt4v283Ev();
extern void _ZN9S604C3_nt4v284Ev();
extern void _ZN9S604C3_nt4v285Ev();
extern void _ZN9S604C3_nt4v286Ev();
extern void _ZN9S604C3_nt4v287Ev();
extern void _ZN9S604C3_nt4v288Ev();
extern void _ZN9S604C3_nt4v289Ev();
extern void _ZN9S604C3_nt4v290Ev();
extern void _ZN9S604C3_nt4v291Ev();
extern void _ZN9S604C3_nt4v292Ev();
extern void _ZN9S604C3_nt4v293Ev();
extern void _ZN9S604C3_nt4v294Ev();
extern void _ZN9S604C3_nt4v295Ev();
extern void _ZN9S604C3_nt4v296Ev();
extern void _ZN9S604C3_nt4v297Ev();
extern void _ZN9S604C3_nt4v298Ev();
extern void _ZN9S604C3_nt4v299Ev();
extern void _ZN9S604C3_nt4v300Ev();
extern void _ZN9S604C3_nt4v301Ev();
extern void _ZN9S604C3_nt4v302Ev();
extern void _ZN9S604C3_nt4v303Ev();
extern void _ZN9S604C3_nt4v304Ev();
extern void _ZN9S604C3_nt4v305Ev();
extern void _ZN9S604C3_nt4v306Ev();
extern void _ZN9S604C3_nt4v307Ev();
extern void _ZN9S604C3_nt4v308Ev();
extern void _ZN9S604C3_nt4v309Ev();
extern void _ZN9S604C2_nt4v310Ev();
extern void _ZN9S604C2_nt4v311Ev();
extern void _ZN9S604C2_nt4v312Ev();
extern void _ZN9S604C2_nt4v313Ev();
extern void _ZN9S604C2_nt4v314Ev();
extern void _ZN9S604C2_nt4v315Ev();
extern void _ZN9S604C2_nt4v316Ev();
extern void _ZN9S604C2_nt4v317Ev();
extern void _ZN9S604C2_nt4v318Ev();
extern void _ZN9S604C2_nt4v319Ev();
extern void _ZN9S604C2_nt4v320Ev();
extern void _ZN9S604C2_nt4v321Ev();
extern void _ZN9S604C2_nt4v322Ev();
extern void _ZN9S604C2_nt4v323Ev();
extern void _ZN9S604C2_nt4v324Ev();
extern void _ZN9S604C2_nt4v325Ev();
extern void _ZN9S604C2_nt4v326Ev();
extern void _ZN9S604C2_nt4v327Ev();
extern void _ZN9S604C2_nt4v328Ev();
extern void _ZN9S604C2_nt4v329Ev();
extern void _ZN9S604C2_nt4v330Ev();
extern void _ZN9S604C2_nt4v331Ev();
static  VTBL_ENTRY vtc_S604C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S604C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S604C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S604C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v220Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v221Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v222Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v223Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v224Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v225Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v226Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v227Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v228Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v229Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v230Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v231Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v232Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v233Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v234Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v235Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v236Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v237Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v238Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v239Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v240Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v241Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v242Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v243Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v244Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v245Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v246Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v247Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v248Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v249Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v250Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v251Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v252Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v253Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v254Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v255Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v256Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v257Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v258Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v259Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v260Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v261Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v262Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v263Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v264Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v265Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v266Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v267Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v268Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v269Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v270Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v271Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v272Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v273Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v274Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v275Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v276Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v277Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v278Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v279Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v280Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v281Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v282Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v283Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v284Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v285Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v286Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v287Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v288Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v289Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v290Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v291Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v292Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v293Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v294Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v295Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v296Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v297Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v298Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v299Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v300Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v301Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v302Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v303Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v304Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v305Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v306Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v307Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v308Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v309Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v310Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v311Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v312Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v313Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v314Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v315Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v316Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v317Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v318Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v319Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v320Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v321Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v322Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v323Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v324Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v325Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v326Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v327Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v328Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v329Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v330Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v331Ev,
};
extern VTBL_ENTRY _ZTI9S604C2_nt[];
VTBL_ENTRY *P__ZTI9S604C2_nt = _ZTI9S604C2_nt; 
extern  VTBL_ENTRY _ZTV9S604C2_nt[];
Class_Descriptor cd_S604C2_nt = {  "S604C2_nt", // class name
  bases_S604C2_nt, 3,
  &(vtc_S604C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1336,1052), // object size
  NSPAIRA(_ZTI9S604C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S604C2_nt),331, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S604C1  : S604C2_nt {
  void *s604c1f0;
  int s604c1f1[2];
  unsigned int s604c1f2:1;
  unsigned int s604c1f3:1;
  void *s604c1f4[4];
  ::S604C26 s604c1f5;
  void *s604c1f6;
  virtual  ~S604C1(); // _ZN6S604C1D1Ev
  virtual void  v1(); // _ZN6S604C12v1Ev
  virtual void  v2(); // _ZN6S604C12v2Ev
  virtual void  v3(); // _ZN6S604C12v3Ev
  virtual void  v4(); // _ZN6S604C12v4Ev
  S604C1(); // tgen
};
//SIG(1 S604C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 FC10{ m Fi} Fi Fc[4] Fp[2] FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC6 FC6 FC6 FC11{ BC12{ BC9}} FC11 Fi Fp[2] FC13{ m Fi[3]} FC13 FC13 FC13 Fp FC6 FC11 FC13 FC13 Fi FC13 FC13 Fp Fi Fc FC13 FC13 Fp Fi Fp FC11 FC14{ BC15{ BC9}} FC14} vd v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC13 Fi[19] FC13 Fi[2] Fp Fi[5] FC13 FC13 Fi Fp Fi FC13 Fi Fp Fi[3] FC16{ BC17{ BC18{ BC9}}} Fp[3] FC6 FC6 Fp Fi FC13 Fp FC13 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC13 FC13 Fi Fp[2] Fi} vd v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 v328 v329 v330 v331 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC19{ BC20{ BC9}} Fi FC13 Fi[3] FC13 Fi[2] Fp Fi[2] Fc Fi[8]} vd v1 v2 v3 v4 Fp Fi[2] Fi:1 Fi:1 Fp[4] FC19 Fp}


 S604C1 ::~S604C1(){ note_dtor("S604C1", this);}
void  S604C1 ::v1(){vfunc_called(this, "_ZN6S604C12v1Ev");}
void  S604C1 ::v2(){vfunc_called(this, "_ZN6S604C12v2Ev");}
void  S604C1 ::v3(){vfunc_called(this, "_ZN6S604C12v3Ev");}
void  S604C1 ::v4(){vfunc_called(this, "_ZN6S604C12v4Ev");}
S604C1 ::S604C1(){ note_ctor("S604C1", this);} // tgen

static void Test_S604C1()
{
  extern Class_Descriptor cd_S604C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(178,276)];
    init_test(&cd_S604C1, buf);
    S604C1 *dp, &lv = *(dp=new (buf) S604C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1416,1100), "sizeof(S604C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S604C1)");
    check_base_class_offset(lv, (S604C5_nt*)(S604C4_nt*)(S604C3_nt*)(S604C2_nt*), 0, "S604C1");
    check_base_class_offset(lv, (S604C4_nt*)(S604C3_nt*)(S604C2_nt*), 0, "S604C1");
    check_base_class_offset(lv, (S604C3_nt*)(S604C2_nt*), 0, "S604C1");
    check_base_class_offset(lv, (S604C2_nt*), 0, "S604C1");
    check_field_offset(lv, s604c1f0, ABISELECT(1336,1052), "S604C1.s604c1f0");
    check_field_offset(lv, s604c1f1, ABISELECT(1344,1056), "S604C1.s604c1f1");
    set_bf_and_test(lv, s604c1f2, ABISELECT(1352,1064), 0, 1, 1, "S604C1");
    set_bf_and_test(lv, s604c1f3, ABISELECT(1352,1064), 1, 1, 1, "S604C1");
    check_field_offset(lv, s604c1f4, ABISELECT(1360,1068), "S604C1.s604c1f4");
    check_field_offset(lv, s604c1f5, ABISELECT(1392,1084), "S604C1.s604c1f5");
    check_field_offset(lv, s604c1f6, ABISELECT(1408,1096), "S604C1.s604c1f6");
    test_class_info(&lv, &cd_S604C1);
    dp->~S604C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS604C1(Test_S604C1, "S604C1", ABISELECT(1416,1100));

#else // __cplusplus

extern void _ZN6S604C1C1Ev();
extern void _ZN6S604C1D1Ev();
Name_Map name_map_S604C1[] = {
  NSPAIR(_ZN6S604C1C1Ev),
  NSPAIR(_ZN6S604C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S604C5_nt;
extern VTBL_ENTRY _ZTI9S604C5_nt[];
extern  VTBL_ENTRY _ZTV9S604C5_nt[];
extern Class_Descriptor cd_S604C4_nt;
extern VTBL_ENTRY _ZTI9S604C4_nt[];
extern  VTBL_ENTRY _ZTV9S604C4_nt[];
extern Class_Descriptor cd_S604C3_nt;
extern VTBL_ENTRY _ZTI9S604C3_nt[];
extern  VTBL_ENTRY _ZTV9S604C3_nt[];
extern Class_Descriptor cd_S604C2_nt;
extern VTBL_ENTRY _ZTI9S604C2_nt[];
extern  VTBL_ENTRY _ZTV9S604C2_nt[];
static Base_Class bases_S604C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S604C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S604C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S604C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S604C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S604C1[];
extern void _ZN6S604C1D1Ev();
extern void _ZN6S604C1D0Ev();
extern void _ZN9S604C5_nt2v5Ev();
extern void _ZN9S604C5_nt2v6Ev();
extern void _ZN9S604C5_nt2v7Ev();
extern void _ZN9S604C5_nt2v8Ev();
extern void _ZN9S604C5_nt2v9Ev();
extern void _ZN9S604C5_nt3v10Ev();
extern void _ZN9S604C5_nt3v11Ev();
extern void _ZN9S604C5_nt3v12Ev();
extern void _ZN9S604C5_nt3v13Ev();
extern void _ZN9S604C5_nt3v14Ev();
extern void _ZN9S604C5_nt3v15Ev();
extern void _ZN9S604C5_nt3v16Ev();
extern void _ZN9S604C5_nt3v17Ev();
extern void _ZN9S604C5_nt3v18Ev();
extern void _ZN9S604C5_nt3v19Ev();
extern void _ZN9S604C5_nt3v20Ev();
extern void _ZN9S604C5_nt3v21Ev();
extern void _ZN9S604C5_nt3v22Ev();
extern void _ZN9S604C5_nt3v23Ev();
extern void _ZN9S604C5_nt3v24Ev();
extern void _ZN9S604C5_nt3v25Ev();
extern void _ZN9S604C5_nt3v26Ev();
extern void _ZN9S604C5_nt3v27Ev();
extern void _ZN9S604C5_nt3v28Ev();
extern void _ZN9S604C5_nt3v29Ev();
extern void _ZN9S604C5_nt3v30Ev();
extern void _ZN9S604C5_nt3v31Ev();
extern void _ZN9S604C5_nt3v32Ev();
extern void _ZN9S604C5_nt3v33Ev();
extern void _ZN9S604C5_nt3v34Ev();
extern void _ZN9S604C5_nt3v35Ev();
extern void _ZN9S604C5_nt3v36Ev();
extern void _ZN9S604C5_nt3v37Ev();
extern void _ZN9S604C5_nt3v38Ev();
extern void _ZN9S604C5_nt3v39Ev();
extern void _ZN9S604C5_nt3v40Ev();
extern void _ZN9S604C5_nt3v41Ev();
extern void _ZN9S604C5_nt3v42Ev();
extern void _ZN9S604C5_nt3v43Ev();
extern void _ZN9S604C5_nt3v44Ev();
extern void _ZN9S604C5_nt3v45Ev();
extern void _ZN9S604C5_nt3v46Ev();
extern void _ZN9S604C5_nt3v47Ev();
extern void _ZN9S604C5_nt3v48Ev();
extern void _ZN9S604C5_nt3v49Ev();
extern void _ZN9S604C5_nt3v50Ev();
extern void _ZN9S604C5_nt3v51Ev();
extern void _ZN9S604C5_nt3v52Ev();
extern void _ZN9S604C5_nt3v53Ev();
extern void _ZN9S604C5_nt3v54Ev();
extern void _ZN9S604C5_nt3v55Ev();
extern void _ZN9S604C5_nt3v56Ev();
extern void _ZN9S604C5_nt3v57Ev();
extern void _ZN9S604C5_nt3v58Ev();
extern void _ZN9S604C5_nt3v59Ev();
extern void _ZN9S604C5_nt3v60Ev();
extern void _ZN9S604C5_nt3v61Ev();
extern void _ZN9S604C5_nt3v62Ev();
extern void _ZN9S604C5_nt3v63Ev();
extern void _ZN9S604C5_nt3v64Ev();
extern void _ZN9S604C5_nt3v65Ev();
extern void _ZN9S604C5_nt3v66Ev();
extern void _ZN9S604C5_nt3v67Ev();
extern void _ZN9S604C5_nt3v68Ev();
extern void _ZN9S604C4_nt3v69Ev();
extern void _ZN9S604C4_nt3v70Ev();
extern void _ZN9S604C4_nt3v71Ev();
extern void _ZN9S604C4_nt3v72Ev();
extern void _ZN9S604C4_nt3v73Ev();
extern void _ZN9S604C4_nt3v74Ev();
extern void _ZN9S604C4_nt3v75Ev();
extern void _ZN9S604C4_nt3v76Ev();
extern void _ZN9S604C4_nt3v77Ev();
extern void _ZN9S604C4_nt3v78Ev();
extern void _ZN9S604C4_nt3v79Ev();
extern void _ZN9S604C4_nt3v80Ev();
extern void _ZN9S604C4_nt3v81Ev();
extern void _ZN9S604C4_nt3v82Ev();
extern void _ZN9S604C4_nt3v83Ev();
extern void _ZN9S604C4_nt3v84Ev();
extern void _ZN9S604C4_nt3v85Ev();
extern void _ZN9S604C4_nt3v86Ev();
extern void _ZN9S604C4_nt3v87Ev();
extern void _ZN9S604C4_nt3v88Ev();
extern void _ZN9S604C4_nt3v89Ev();
extern void _ZN9S604C4_nt3v90Ev();
extern void _ZN9S604C4_nt3v91Ev();
extern void _ZN9S604C4_nt3v92Ev();
extern void _ZN9S604C4_nt3v93Ev();
extern void _ZN9S604C4_nt3v94Ev();
extern void _ZN9S604C4_nt3v95Ev();
extern void _ZN9S604C4_nt3v96Ev();
extern void _ZN9S604C4_nt3v97Ev();
extern void _ZN9S604C4_nt3v98Ev();
extern void _ZN9S604C4_nt3v99Ev();
extern void _ZN9S604C4_nt4v100Ev();
extern void _ZN9S604C4_nt4v101Ev();
extern void _ZN9S604C4_nt4v102Ev();
extern void _ZN9S604C4_nt4v103Ev();
extern void _ZN9S604C4_nt4v104Ev();
extern void _ZN9S604C4_nt4v105Ev();
extern void _ZN9S604C4_nt4v106Ev();
extern void _ZN9S604C4_nt4v107Ev();
extern void _ZN9S604C4_nt4v108Ev();
extern void _ZN9S604C4_nt4v109Ev();
extern void _ZN9S604C4_nt4v110Ev();
extern void _ZN9S604C4_nt4v111Ev();
extern void _ZN9S604C4_nt4v112Ev();
extern void _ZN9S604C4_nt4v113Ev();
extern void _ZN9S604C4_nt4v114Ev();
extern void _ZN9S604C4_nt4v115Ev();
extern void _ZN9S604C4_nt4v116Ev();
extern void _ZN9S604C4_nt4v117Ev();
extern void _ZN9S604C4_nt4v118Ev();
extern void _ZN9S604C4_nt4v119Ev();
extern void _ZN9S604C4_nt4v120Ev();
extern void _ZN9S604C4_nt4v121Ev();
extern void _ZN9S604C4_nt4v122Ev();
extern void _ZN9S604C4_nt4v123Ev();
extern void _ZN9S604C4_nt4v124Ev();
extern void _ZN9S604C4_nt4v125Ev();
extern void _ZN9S604C4_nt4v126Ev();
extern void _ZN9S604C4_nt4v127Ev();
extern void _ZN9S604C4_nt4v128Ev();
extern void _ZN9S604C4_nt4v129Ev();
extern void _ZN9S604C4_nt4v130Ev();
extern void _ZN9S604C4_nt4v131Ev();
extern void _ZN9S604C4_nt4v132Ev();
extern void _ZN9S604C4_nt4v133Ev();
extern void _ZN9S604C4_nt4v134Ev();
extern void _ZN9S604C4_nt4v135Ev();
extern void _ZN9S604C4_nt4v136Ev();
extern void _ZN9S604C4_nt4v137Ev();
extern void _ZN9S604C4_nt4v138Ev();
extern void _ZN9S604C4_nt4v139Ev();
extern void _ZN9S604C4_nt4v140Ev();
extern void _ZN9S604C4_nt4v141Ev();
extern void _ZN9S604C4_nt4v142Ev();
extern void _ZN9S604C4_nt4v143Ev();
extern void _ZN9S604C4_nt4v144Ev();
extern void _ZN9S604C4_nt4v145Ev();
extern void _ZN9S604C4_nt4v146Ev();
extern void _ZN9S604C4_nt4v147Ev();
extern void _ZN9S604C4_nt4v148Ev();
extern void _ZN9S604C4_nt4v149Ev();
extern void _ZN9S604C4_nt4v150Ev();
extern void _ZN9S604C4_nt4v151Ev();
extern void _ZN9S604C4_nt4v152Ev();
extern void _ZN9S604C4_nt4v153Ev();
extern void _ZN9S604C4_nt4v154Ev();
extern void _ZN9S604C4_nt4v155Ev();
extern void _ZN9S604C4_nt4v156Ev();
extern void _ZN9S604C4_nt4v157Ev();
extern void _ZN9S604C4_nt4v158Ev();
extern void _ZN9S604C4_nt4v159Ev();
extern void _ZN9S604C4_nt4v160Ev();
extern void _ZN9S604C4_nt4v161Ev();
extern void _ZN9S604C4_nt4v162Ev();
extern void _ZN9S604C4_nt4v163Ev();
extern void _ZN9S604C4_nt4v164Ev();
extern void _ZN9S604C4_nt4v165Ev();
extern void _ZN9S604C4_nt4v166Ev();
extern void _ZN9S604C4_nt4v167Ev();
extern void _ZN9S604C4_nt4v168Ev();
extern void _ZN9S604C4_nt4v169Ev();
extern void _ZN9S604C4_nt4v170Ev();
extern void _ZN9S604C4_nt4v171Ev();
extern void _ZN9S604C4_nt4v172Ev();
extern void _ZN9S604C4_nt4v173Ev();
extern void _ZN9S604C4_nt4v174Ev();
extern void _ZN9S604C4_nt4v175Ev();
extern void _ZN9S604C4_nt4v176Ev();
extern void _ZN9S604C4_nt4v177Ev();
extern void _ZN9S604C4_nt4v178Ev();
extern void _ZN9S604C4_nt4v179Ev();
extern void _ZN9S604C4_nt4v180Ev();
extern void _ZN9S604C4_nt4v181Ev();
extern void _ZN9S604C4_nt4v182Ev();
extern void _ZN9S604C4_nt4v183Ev();
extern void _ZN9S604C4_nt4v184Ev();
extern void _ZN9S604C4_nt4v185Ev();
extern void _ZN9S604C4_nt4v186Ev();
extern void _ZN9S604C4_nt4v187Ev();
extern void _ZN9S604C4_nt4v188Ev();
extern void _ZN9S604C4_nt4v189Ev();
extern void _ZN9S604C4_nt4v190Ev();
extern void _ZN9S604C4_nt4v191Ev();
extern void _ZN9S604C4_nt4v192Ev();
extern void _ZN9S604C4_nt4v193Ev();
extern void _ZN9S604C4_nt4v194Ev();
extern void _ZN9S604C4_nt4v195Ev();
extern void _ZN9S604C4_nt4v196Ev();
extern void _ZN9S604C4_nt4v197Ev();
extern void _ZN9S604C4_nt4v198Ev();
extern void _ZN9S604C4_nt4v199Ev();
extern void _ZN9S604C4_nt4v200Ev();
extern void _ZN9S604C4_nt4v201Ev();
extern void _ZN9S604C4_nt4v202Ev();
extern void _ZN9S604C4_nt4v203Ev();
extern void _ZN9S604C4_nt4v204Ev();
extern void _ZN9S604C4_nt4v205Ev();
extern void _ZN9S604C4_nt4v206Ev();
extern void _ZN9S604C4_nt4v207Ev();
extern void _ZN9S604C4_nt4v208Ev();
extern void _ZN9S604C4_nt4v209Ev();
extern void _ZN9S604C4_nt4v210Ev();
extern void _ZN9S604C4_nt4v211Ev();
extern void _ZN9S604C3_nt4v212Ev();
extern void _ZN9S604C3_nt4v213Ev();
extern void _ZN9S604C3_nt4v214Ev();
extern void _ZN9S604C3_nt4v215Ev();
extern void _ZN9S604C3_nt4v216Ev();
extern void _ZN9S604C3_nt4v217Ev();
extern void _ZN9S604C3_nt4v218Ev();
extern void _ZN9S604C3_nt4v219Ev();
extern void _ZN9S604C3_nt4v220Ev();
extern void _ZN9S604C3_nt4v221Ev();
extern void _ZN9S604C3_nt4v222Ev();
extern void _ZN9S604C3_nt4v223Ev();
extern void _ZN9S604C3_nt4v224Ev();
extern void _ZN9S604C3_nt4v225Ev();
extern void _ZN9S604C3_nt4v226Ev();
extern void _ZN9S604C3_nt4v227Ev();
extern void _ZN9S604C3_nt4v228Ev();
extern void _ZN9S604C3_nt4v229Ev();
extern void _ZN9S604C3_nt4v230Ev();
extern void _ZN9S604C3_nt4v231Ev();
extern void _ZN9S604C3_nt4v232Ev();
extern void _ZN9S604C3_nt4v233Ev();
extern void _ZN9S604C3_nt4v234Ev();
extern void _ZN9S604C3_nt4v235Ev();
extern void _ZN9S604C3_nt4v236Ev();
extern void _ZN9S604C3_nt4v237Ev();
extern void _ZN9S604C3_nt4v238Ev();
extern void _ZN9S604C3_nt4v239Ev();
extern void _ZN9S604C3_nt4v240Ev();
extern void _ZN9S604C3_nt4v241Ev();
extern void _ZN9S604C3_nt4v242Ev();
extern void _ZN9S604C3_nt4v243Ev();
extern void _ZN9S604C3_nt4v244Ev();
extern void _ZN9S604C3_nt4v245Ev();
extern void _ZN9S604C3_nt4v246Ev();
extern void _ZN9S604C3_nt4v247Ev();
extern void _ZN9S604C3_nt4v248Ev();
extern void _ZN9S604C3_nt4v249Ev();
extern void _ZN9S604C3_nt4v250Ev();
extern void _ZN9S604C3_nt4v251Ev();
extern void _ZN9S604C3_nt4v252Ev();
extern void _ZN9S604C3_nt4v253Ev();
extern void _ZN9S604C3_nt4v254Ev();
extern void _ZN9S604C3_nt4v255Ev();
extern void _ZN9S604C3_nt4v256Ev();
extern void _ZN9S604C3_nt4v257Ev();
extern void _ZN9S604C3_nt4v258Ev();
extern void _ZN9S604C3_nt4v259Ev();
extern void _ZN9S604C3_nt4v260Ev();
extern void _ZN9S604C3_nt4v261Ev();
extern void _ZN9S604C3_nt4v262Ev();
extern void _ZN9S604C3_nt4v263Ev();
extern void _ZN9S604C3_nt4v264Ev();
extern void _ZN9S604C3_nt4v265Ev();
extern void _ZN9S604C3_nt4v266Ev();
extern void _ZN9S604C3_nt4v267Ev();
extern void _ZN9S604C3_nt4v268Ev();
extern void _ZN9S604C3_nt4v269Ev();
extern void _ZN9S604C3_nt4v270Ev();
extern void _ZN9S604C3_nt4v271Ev();
extern void _ZN9S604C3_nt4v272Ev();
extern void _ZN9S604C3_nt4v273Ev();
extern void _ZN9S604C3_nt4v274Ev();
extern void _ZN9S604C3_nt4v275Ev();
extern void _ZN9S604C3_nt4v276Ev();
extern void _ZN9S604C3_nt4v277Ev();
extern void _ZN9S604C3_nt4v278Ev();
extern void _ZN9S604C3_nt4v279Ev();
extern void _ZN9S604C3_nt4v280Ev();
extern void _ZN9S604C3_nt4v281Ev();
extern void _ZN9S604C3_nt4v282Ev();
extern void _ZN9S604C3_nt4v283Ev();
extern void _ZN9S604C3_nt4v284Ev();
extern void _ZN9S604C3_nt4v285Ev();
extern void _ZN9S604C3_nt4v286Ev();
extern void _ZN9S604C3_nt4v287Ev();
extern void _ZN9S604C3_nt4v288Ev();
extern void _ZN9S604C3_nt4v289Ev();
extern void _ZN9S604C3_nt4v290Ev();
extern void _ZN9S604C3_nt4v291Ev();
extern void _ZN9S604C3_nt4v292Ev();
extern void _ZN9S604C3_nt4v293Ev();
extern void _ZN9S604C3_nt4v294Ev();
extern void _ZN9S604C3_nt4v295Ev();
extern void _ZN9S604C3_nt4v296Ev();
extern void _ZN9S604C3_nt4v297Ev();
extern void _ZN9S604C3_nt4v298Ev();
extern void _ZN9S604C3_nt4v299Ev();
extern void _ZN9S604C3_nt4v300Ev();
extern void _ZN9S604C3_nt4v301Ev();
extern void _ZN9S604C3_nt4v302Ev();
extern void _ZN9S604C3_nt4v303Ev();
extern void _ZN9S604C3_nt4v304Ev();
extern void _ZN9S604C3_nt4v305Ev();
extern void _ZN9S604C3_nt4v306Ev();
extern void _ZN9S604C3_nt4v307Ev();
extern void _ZN9S604C3_nt4v308Ev();
extern void _ZN9S604C3_nt4v309Ev();
extern void _ZN9S604C2_nt4v310Ev();
extern void _ZN9S604C2_nt4v311Ev();
extern void _ZN9S604C2_nt4v312Ev();
extern void _ZN9S604C2_nt4v313Ev();
extern void _ZN9S604C2_nt4v314Ev();
extern void _ZN9S604C2_nt4v315Ev();
extern void _ZN9S604C2_nt4v316Ev();
extern void _ZN9S604C2_nt4v317Ev();
extern void _ZN9S604C2_nt4v318Ev();
extern void _ZN9S604C2_nt4v319Ev();
extern void _ZN9S604C2_nt4v320Ev();
extern void _ZN9S604C2_nt4v321Ev();
extern void _ZN9S604C2_nt4v322Ev();
extern void _ZN9S604C2_nt4v323Ev();
extern void _ZN9S604C2_nt4v324Ev();
extern void _ZN9S604C2_nt4v325Ev();
extern void _ZN9S604C2_nt4v326Ev();
extern void _ZN9S604C2_nt4v327Ev();
extern void _ZN9S604C2_nt4v328Ev();
extern void _ZN9S604C2_nt4v329Ev();
extern void _ZN9S604C2_nt4v330Ev();
extern void _ZN9S604C2_nt4v331Ev();
extern void _ZN6S604C12v1Ev();
extern void _ZN6S604C12v2Ev();
extern void _ZN6S604C12v3Ev();
extern void _ZN6S604C12v4Ev();
static  VTBL_ENTRY vtc_S604C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S604C1[0]),
  (VTBL_ENTRY)&_ZN6S604C1D1Ev,
  (VTBL_ENTRY)&_ZN6S604C1D0Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S604C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S604C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v220Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v221Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v222Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v223Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v224Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v225Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v226Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v227Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v228Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v229Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v230Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v231Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v232Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v233Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v234Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v235Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v236Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v237Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v238Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v239Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v240Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v241Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v242Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v243Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v244Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v245Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v246Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v247Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v248Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v249Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v250Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v251Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v252Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v253Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v254Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v255Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v256Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v257Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v258Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v259Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v260Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v261Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v262Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v263Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v264Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v265Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v266Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v267Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v268Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v269Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v270Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v271Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v272Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v273Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v274Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v275Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v276Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v277Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v278Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v279Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v280Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v281Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v282Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v283Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v284Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v285Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v286Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v287Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v288Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v289Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v290Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v291Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v292Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v293Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v294Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v295Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v296Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v297Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v298Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v299Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v300Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v301Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v302Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v303Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v304Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v305Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v306Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v307Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v308Ev,
  (VTBL_ENTRY)&_ZN9S604C3_nt4v309Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v310Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v311Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v312Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v313Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v314Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v315Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v316Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v317Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v318Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v319Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v320Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v321Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v322Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v323Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v324Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v325Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v326Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v327Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v328Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v329Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v330Ev,
  (VTBL_ENTRY)&_ZN9S604C2_nt4v331Ev,
  (VTBL_ENTRY)&_ZN6S604C12v1Ev,
  (VTBL_ENTRY)&_ZN6S604C12v2Ev,
  (VTBL_ENTRY)&_ZN6S604C12v3Ev,
  (VTBL_ENTRY)&_ZN6S604C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S604C1[];
extern  VTBL_ENTRY _ZTV6S604C1[];
Class_Descriptor cd_S604C1 = {  "S604C1", // class name
  bases_S604C1, 4,
  &(vtc_S604C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1416,1100), // object size
  NSPAIRA(_ZTI6S604C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S604C1),335, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C2_nt  {
  short s6087c2f0;
  int s6087c2f1[2];
  long s6087c2f2[8];
  int s6087c2f3;
  short s6087c2f4;
  void  mf6087c2(); // _ZN10S6087C2_nt8mf6087c2Ev
};
//SIG(-1 S6087C2_nt) C1{ m Fs Fi[2] Fl[8] Fi Fs}


void  S6087C2_nt ::mf6087c2(){}

//skip512 S6087C2_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S6087C2_nt[];
VTBL_ENTRY *P__ZTI10S6087C2_nt = _ZTI10S6087C2_nt; 
Class_Descriptor cd_S6087C2_nt = {  "S6087C2_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(88,52), // object size
  NSPAIRA(_ZTI10S6087C2_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C7  : S6087C2_nt {
  int s6087c7f0[3];
  long s6087c7f1;
  void *s6087c7f2[5];
  __tsi64 s6087c7f3:13;
  long s6087c7f4;
  __tsi64 s6087c7f5;
  virtual  ~S6087C7(); // _ZN7S6087C7D1Ev
  S6087C7(); // tgen
};
//SIG(-1 S6087C7) C1{ BC2{ m Fs Fi[2] Fl[8] Fi Fs} vd Fi[3] Fl Fp[5] FL:13 Fl FL}


 S6087C7 ::~S6087C7(){ note_dtor("S6087C7", this);}
S6087C7 ::S6087C7(){ note_ctor("S6087C7", this);} // tgen

static void Test_S6087C7()
{
  extern Class_Descriptor cd_S6087C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,28)];
    init_test(&cd_S6087C7, buf);
    S6087C7 *dp, &lv = *(dp=new (buf) S6087C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,108), "sizeof(S6087C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6087C7)");
    check_base_class_offset(lv, (S6087C2_nt*), ABISELECT(8,4), "S6087C7");
    check_field_offset(lv, s6087c7f0, ABISELECT(96,56), "S6087C7.s6087c7f0");
    check_field_offset(lv, s6087c7f1, ABISELECT(112,68), "S6087C7.s6087c7f1");
    check_field_offset(lv, s6087c7f2, ABISELECT(120,72), "S6087C7.s6087c7f2");
    set_bf_and_test(lv, s6087c7f3, ABISELECT(160,92), 0, 13, 1, "S6087C7");
    set_bf_and_test(lv, s6087c7f3, ABISELECT(160,92), 0, 13, hide_sll(1LL<<12), "S6087C7");
    check_field_offset(lv, s6087c7f4, ABISELECT(168,96), "S6087C7.s6087c7f4");
    check_field_offset(lv, s6087c7f5, ABISELECT(176,100), "S6087C7.s6087c7f5");
    test_class_info(&lv, &cd_S6087C7);
    dp->~S6087C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C7(Test_S6087C7, "S6087C7", ABISELECT(184,108));

#else // __cplusplus

extern void _ZN7S6087C7C1Ev();
extern void _ZN7S6087C7D1Ev();
Name_Map name_map_S6087C7[] = {
  NSPAIR(_ZN7S6087C7C1Ev),
  NSPAIR(_ZN7S6087C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
static Base_Class bases_S6087C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C2_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S6087C7[];
extern void _ZN7S6087C7D1Ev();
extern void _ZN7S6087C7D0Ev();
static  VTBL_ENTRY vtc_S6087C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C7[0]),
  (VTBL_ENTRY)&_ZN7S6087C7D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C7D0Ev,
};
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
Class_Descriptor cd_S6087C7 = {  "S6087C7", // class name
  bases_S6087C7, 1,
  &(vtc_S6087C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,108), // object size
  NSPAIRA(_ZTI7S6087C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S6087C7),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S6087C8  {
  __tsi64 s6087c8f0[7];
  char s6087c8f1;
  __tsi64 s6087c8f2;
  void *s6087c8f3;
  __tsi64 s6087c8f4;
  char s6087c8f5;
  long s6087c8f6;
  char s6087c8f7;
  int s6087c8f8;
  long s6087c8f9;
  int s6087c8f10;
  void *s6087c8f11;
  long s6087c8f12[7];
  void  mf6087c8(); // _ZN7S6087C88mf6087c8Ev
};
//SIG(1 S6087C8) U1{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}

#endif // __cplusplus
#ifdef __cplusplus

struct  S6087C6  {
  void *s6087c6f0;
  long double s6087c6f1;
  int s6087c6f2;
  ::S6087C2_nt s6087c6f3;
  short s6087c6f4[6];
  char s6087c6f5;
  ::S6087C7 s6087c6f6;
  int s6087c6f7;
  ::S6087C8 s6087c6f8;
  virtual void  v2(); // _ZN7S6087C62v2Ev
  virtual void  v3(); // _ZN7S6087C62v3Ev
  ~S6087C6(); // tgen
  S6087C6(); // tgen
};
//SIG(-1 S6087C6) C1{ v1 v2 Fp FD Fi FC2{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC3{ BC2 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU4{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}}


void  S6087C6 ::v2(){vfunc_called(this, "_ZN7S6087C62v2Ev");}
void  S6087C6 ::v3(){vfunc_called(this, "_ZN7S6087C62v3Ev");}
S6087C6 ::~S6087C6(){ note_dtor("S6087C6", this);} // tgen
S6087C6 ::S6087C6(){ note_ctor("S6087C6", this);} // tgen

static void Test_S6087C6()
{
  extern Class_Descriptor cd_S6087C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(26,66)];
    init_test(&cd_S6087C6, buf);
    S6087C6 *dp, &lv = *(dp=new (buf) S6087C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,260), "sizeof(S6087C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C6)");
    check_field_offset(lv, s6087c6f0, ABISELECT(8,4), "S6087C6.s6087c6f0");
    check_field_offset(lv, s6087c6f1, ABISELECT(16,8), "S6087C6.s6087c6f1");
    check_field_offset(lv, s6087c6f2, ABISELECT(32,20), "S6087C6.s6087c6f2");
    check_field_offset(lv, s6087c6f3, ABISELECT(40,24), "S6087C6.s6087c6f3");
    check_field_offset(lv, s6087c6f4, ABISELECT(128,76), "S6087C6.s6087c6f4");
    check_field_offset(lv, s6087c6f5, ABISELECT(140,88), "S6087C6.s6087c6f5");
    check_field_offset(lv, s6087c6f6, ABISELECT(144,92), "S6087C6.s6087c6f6");
    check_field_offset(lv, s6087c6f7, ABISELECT(328,200), "S6087C6.s6087c6f7");
    check_field_offset(lv, s6087c6f8, ABISELECT(336,204), "S6087C6.s6087c6f8");
    test_class_info(&lv, &cd_S6087C6);
    dp->~S6087C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C6(Test_S6087C6, "S6087C6", ABISELECT(400,260));

#else // __cplusplus

extern void _ZN7S6087C6C1Ev();
extern void _ZN7S6087C6D1Ev();
Name_Map name_map_S6087C6[] = {
  NSPAIR(_ZN7S6087C6C1Ev),
  NSPAIR(_ZN7S6087C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S6087C6[];
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY vtc_S6087C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C6[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
Class_Descriptor cd_S6087C6 = {  "S6087C6", // class name
  0,0,//no base classes
  &(vtc_S6087C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,260), // object size
  NSPAIRA(_ZTI7S6087C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S6087C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C10  {
  int s6087c10f0:30;
  void *s6087c10f1;
  int s6087c10f2;
  int s6087c10f3[8];
  __tsi64 s6087c10f4;
  int s6087c10f5;
  long double s6087c10f6;
  char s6087c10f7:3;
  void *s6087c10f8;
  long s6087c10f9;
  long s6087c10f10;
  virtual void  v4(); // _ZN8S6087C102v4Ev
  ~S6087C10(); // tgen
  S6087C10(); // tgen
};
//SIG(-1 S6087C10) C1{ v1 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]}


void  S6087C10 ::v4(){vfunc_called(this, "_ZN8S6087C102v4Ev");}
S6087C10 ::~S6087C10(){ note_dtor("S6087C10", this);} // tgen
S6087C10 ::S6087C10(){ note_ctor("S6087C10", this);} // tgen

static void Test_S6087C10()
{
  extern Class_Descriptor cd_S6087C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,23)];
    init_test(&cd_S6087C10, buf);
    S6087C10 *dp, &lv = *(dp=new (buf) S6087C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,88), "sizeof(S6087C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C10)");
    set_bf_and_test(lv, s6087c10f0, ABISELECT(8,4), 0, 30, 1, "S6087C10");
    set_bf_and_test(lv, s6087c10f0, ABISELECT(8,4), 0, 30, hide_sll(1LL<<29), "S6087C10");
    check_field_offset(lv, s6087c10f1, ABISELECT(16,8), "S6087C10.s6087c10f1");
    check_field_offset(lv, s6087c10f2, ABISELECT(24,12), "S6087C10.s6087c10f2");
    check_field_offset(lv, s6087c10f3, ABISELECT(28,16), "S6087C10.s6087c10f3");
    check_field_offset(lv, s6087c10f4, ABISELECT(64,48), "S6087C10.s6087c10f4");
    check_field_offset(lv, s6087c10f5, ABISELECT(72,56), "S6087C10.s6087c10f5");
    check_field_offset(lv, s6087c10f6, ABISELECT(80,60), "S6087C10.s6087c10f6");
    set_bf_and_test(lv, s6087c10f7, ABISELECT(96,72), 0, 3, 1, "S6087C10");
    set_bf_and_test(lv, s6087c10f7, ABISELECT(96,72), 0, 3, hide_sll(1LL<<2), "S6087C10");
    check_field_offset(lv, s6087c10f8, ABISELECT(104,76), "S6087C10.s6087c10f8");
    check_field_offset(lv, s6087c10f9, ABISELECT(112,80), "S6087C10.s6087c10f9");
    check_field_offset(lv, s6087c10f10, ABISELECT(120,84), "S6087C10.s6087c10f10");
    test_class_info(&lv, &cd_S6087C10);
    dp->~S6087C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C10(Test_S6087C10, "S6087C10", ABISELECT(128,88));

#else // __cplusplus

extern void _ZN8S6087C10C1Ev();
extern void _ZN8S6087C10D1Ev();
Name_Map name_map_S6087C10[] = {
  NSPAIR(_ZN8S6087C10C1Ev),
  NSPAIR(_ZN8S6087C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S6087C10[];
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C10[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
Class_Descriptor cd_S6087C10 = {  "S6087C10", // class name
  0,0,//no base classes
  &(vtc_S6087C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,88), // object size
  NSPAIRA(_ZTI8S6087C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S6087C10),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C9  : S6087C10 , virtual S6087C6 {
  int s6087c9f0;
  ::S6087C7 s6087c9f1;
  int s6087c9f2;
  ::S6087C7 s6087c9f3;
  virtual void  v5(); // _ZN7S6087C92v5Ev
  virtual void  v6(); // _ZN7S6087C92v6Ev
  ~S6087C9(); // tgen
  S6087C9(); // tgen
};
//SIG(-1 S6087C9) C1{ BC2{ v3 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} VBC3{ v4 v5 Fp FD Fi FC4{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC5{ BC4 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU6{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v1 v2 Fi FC5 Fi FC5}


void  S6087C9 ::v5(){vfunc_called(this, "_ZN7S6087C92v5Ev");}
void  S6087C9 ::v6(){vfunc_called(this, "_ZN7S6087C92v6Ev");}
S6087C9 ::~S6087C9(){ note_dtor("S6087C9", this);} // tgen
S6087C9 ::S6087C9(){ note_ctor("S6087C9", this);} // tgen

static void Test_S6087C9()
{
  extern Class_Descriptor cd_S6087C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(58,144)];
    init_test(&cd_S6087C9, buf);
    S6087C9 *dp, &lv = *(dp=new (buf) S6087C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(912,572), "sizeof(S6087C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C9)");
    check_base_class_offset(lv, (S6087C10*), 0, "S6087C9");
    check_base_class_offset(lv, (S6087C6*), ABISELECT(512,312), "S6087C9");
    check_field_offset(lv, s6087c9f0, ABISELECT(128,88), "S6087C9.s6087c9f0");
    check_field_offset(lv, s6087c9f1, ABISELECT(136,92), "S6087C9.s6087c9f1");
    check_field_offset(lv, s6087c9f2, ABISELECT(320,200), "S6087C9.s6087c9f2");
    check_field_offset(lv, s6087c9f3, ABISELECT(328,204), "S6087C9.s6087c9f3");
    test_class_info(&lv, &cd_S6087C9);
    dp->~S6087C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C9(Test_S6087C9, "S6087C9", ABISELECT(912,572));

#else // __cplusplus

extern void _ZN7S6087C9C1Ev();
extern void _ZN7S6087C9D1Ev();
Name_Map name_map_S6087C9[] = {
  NSPAIR(_ZN7S6087C9C1Ev),
  NSPAIR(_ZN7S6087C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
static Base_Class bases_S6087C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C6,    ABISELECT(512,312), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S6087C9[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY vtc_S6087C9[] = {
  ABISELECT(512,312),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  0,
  0,
  ABISELECT(-512,-312),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern VTBL_ENTRY _ZTV7S6087C9[];
static  VTT_ENTRY vtt_S6087C9[] = {
  {&(_ZTV7S6087C9[3]),  3,12},
  {&(_ZTV7S6087C9[10]),  10,12},
};
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
Class_Descriptor cd_S6087C9 = {  "S6087C9", // class name
  bases_S6087C9, 2,
  &(vtc_S6087C9[0]), // expected_vtbl_contents
  &(vtt_S6087C9[0]), // expected_vtt_contents
  ABISELECT(912,572), // object size
  NSPAIRA(_ZTI7S6087C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S6087C9),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S6087C9),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C11  {
  void *s6087c11f0;
  ::S6087C10 s6087c11f1;
  int s6087c11f2;
  void *s6087c11f3;
  long double s6087c11f4;
  void *s6087c11f5;
  __tsi64 s6087c11f6;
  char s6087c11f7[6];
  virtual void  v7(); // _ZN8S6087C112v7Ev
  virtual void  v8(); // _ZN8S6087C112v8Ev
  ~S6087C11(); // tgen
  S6087C11(); // tgen
};
//SIG(-1 S6087C11) C1{ v1 v2 Fp FC2{ v3 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} Fi Fp FD Fp FL Fc[6]}


void  S6087C11 ::v7(){vfunc_called(this, "_ZN8S6087C112v7Ev");}
void  S6087C11 ::v8(){vfunc_called(this, "_ZN8S6087C112v8Ev");}
S6087C11 ::~S6087C11(){ note_dtor("S6087C11", this);} // tgen
S6087C11 ::S6087C11(){ note_ctor("S6087C11", this);} // tgen

static void Test_S6087C11()
{
  extern Class_Descriptor cd_S6087C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,35)];
    init_test(&cd_S6087C11, buf);
    S6087C11 *dp, &lv = *(dp=new (buf) S6087C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,136), "sizeof(S6087C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C11)");
    check_field_offset(lv, s6087c11f0, ABISELECT(8,4), "S6087C11.s6087c11f0");
    check_field_offset(lv, s6087c11f1, ABISELECT(16,8), "S6087C11.s6087c11f1");
    check_field_offset(lv, s6087c11f2, ABISELECT(144,96), "S6087C11.s6087c11f2");
    check_field_offset(lv, s6087c11f3, ABISELECT(152,100), "S6087C11.s6087c11f3");
    check_field_offset(lv, s6087c11f4, ABISELECT(160,104), "S6087C11.s6087c11f4");
    check_field_offset(lv, s6087c11f5, ABISELECT(176,116), "S6087C11.s6087c11f5");
    check_field_offset(lv, s6087c11f6, ABISELECT(184,120), "S6087C11.s6087c11f6");
    check_field_offset(lv, s6087c11f7, ABISELECT(192,128), "S6087C11.s6087c11f7");
    test_class_info(&lv, &cd_S6087C11);
    dp->~S6087C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C11(Test_S6087C11, "S6087C11", ABISELECT(208,136));

#else // __cplusplus

extern void _ZN8S6087C11C1Ev();
extern void _ZN8S6087C11D1Ev();
Name_Map name_map_S6087C11[] = {
  NSPAIR(_ZN8S6087C11C1Ev),
  NSPAIR(_ZN8S6087C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S6087C11[];
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY vtc_S6087C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C11[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
Class_Descriptor cd_S6087C11 = {  "S6087C11", // class name
  0,0,//no base classes
  &(vtc_S6087C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,136), // object size
  NSPAIRA(_ZTI8S6087C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S6087C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C5  : virtual S6087C6 , virtual S6087C9 , S6087C11 , virtual S6087C7 {
  long s6087c5f0;
  long s6087c5f1;
  char s6087c5f2;
  char s6087c5f3:3;
  ~S6087C5(); // tgen
  S6087C5(); // tgen
};
//SIG(-1 S6087C5) C1{ VBC2{ v1 v2 Fp FD Fi FC3{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC4{ BC3 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU5{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC6{ BC7{ v3 Fi:30 Fp Fi Fi[8] FL Fi FD Fc:3 Fp Fl Fl} VBC2 v4 v5 Fi FC4 Fi FC4} BC8{ v6 v7 Fp FC7 Fi Fp FD Fp FL Fc[6]} VBC4 Fl Fl Fc Fc:3}


S6087C5 ::~S6087C5(){ note_dtor("S6087C5", this);} // tgen
S6087C5 ::S6087C5(){ note_ctor("S6087C5", this);} // tgen

static void Test_S6087C5()
{
  extern Class_Descriptor cd_S6087C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(84,208)];
    init_test(&cd_S6087C5, buf);
    S6087C5 *dp, &lv = *(dp=new (buf) S6087C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1328,828), "sizeof(S6087C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C5)");
    check_base_class_offset(lv, (S6087C6*), ABISELECT(224,148), "S6087C5");
    check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(224,148), "S6087C5");
    check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(624,408), "S6087C5");
    check_base_class_offset(lv, (S6087C9*), ABISELECT(624,408), "S6087C5");
    check_base_class_offset(lv, (S6087C11*), 0, "S6087C5");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(1144,724), "S6087C5");
    check_base_class_offset(lv, (S6087C7*), ABISELECT(1136,720), "S6087C5");
    check_field_offset(lv, s6087c5f0, ABISELECT(200,136), "S6087C5.s6087c5f0");
    check_field_offset(lv, s6087c5f1, ABISELECT(208,140), "S6087C5.s6087c5f1");
    check_field_offset(lv, s6087c5f2, ABISELECT(216,144), "S6087C5.s6087c5f2");
    set_bf_and_test(lv, s6087c5f3, ABISELECT(217,145), 0, 3, 1, "S6087C5");
    set_bf_and_test(lv, s6087c5f3, ABISELECT(217,145), 0, 3, hide_sll(1LL<<2), "S6087C5");
    test_class_info(&lv, &cd_S6087C5);
    dp->~S6087C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C5(Test_S6087C5, "S6087C5", ABISELECT(1328,828));

#else // __cplusplus

extern void _ZN7S6087C5C1Ev();
extern void _ZN7S6087C5D1Ev();
Name_Map name_map_S6087C5[] = {
  NSPAIR(_ZN7S6087C5C1Ev),
  NSPAIR(_ZN7S6087C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
static Base_Class bases_S6087C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C6,    ABISELECT(224,148), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    ABISELECT(624,408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(624,408), //bcp->offset
    15, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C2_nt,    ABISELECT(1144,724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(1136,720), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S6087C5[];
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn1136_N7S6087C5D1Ev,_ZThn720_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn1136_N7S6087C5D0Ev,_ZThn720_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S6087C5[] = {
  ABISELECT(1136,720),
  ABISELECT(624,408),
  ABISELECT(224,148),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
  0,
  0,
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-624,-408),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-1136,-720),
  ABISELECT(-1136,-720),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern VTBL_ENTRY _ZTV7S6087C5[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5[] = {
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__7S6087C5[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
static  VTT_ENTRY vtt_S6087C5[] = {
  {&(_ZTV7S6087C5[5]),  5,29},
  {&(_ZTV7S6087C5[13]),  13,29},
  {&(_ZTV7S6087C5[21]),  21,29},
  {&(_ZTV7S6087C5[27]),  27,29},
  {&(_tg__ZTV7S6087C9__7S6087C5[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__7S6087C5[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S6087C5D0Ev,_ZThn720_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S6087C5D1Ev,_ZThn720_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C5 = {  "S6087C5", // class name
  bases_S6087C5, 6,
  &(vtc_S6087C5[0]), // expected_vtbl_contents
  &(vtt_S6087C5[0]), // expected_vtt_contents
  ABISELECT(1328,828), // object size
  NSPAIRA(_ZTI7S6087C5),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S6087C5),29, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S6087C5),6, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C4  : S6087C5 {
  long s6087c4f0;
  int s6087c4f1;
  void *s6087c4f2;
  long double s6087c4f3;
  int s6087c4f4;
  int s6087c4f5;
  ~S6087C4(); // tgen
  S6087C4(); // tgen
};
//SIG(-1 S6087C4) C1{ BC2{ VBC3{ v1 v2 Fp FD Fi FC4{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC5{ BC4 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU6{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC7{ BC8{ v3 Fi:30 Fp Fi Fi[8] FL Fi FD Fc:3 Fp Fl Fl} VBC3 v4 v5 Fi FC5 Fi FC5} BC9{ v6 v7 Fp FC8 Fi Fp FD Fp FL Fc[6]} VBC5 Fl Fl Fc Fc:3} Fl Fi Fp FD Fi Fi}


S6087C4 ::~S6087C4(){ note_dtor("S6087C4", this);} // tgen
S6087C4 ::S6087C4(){ note_ctor("S6087C4", this);} // tgen

static void Test_S6087C4()
{
  extern Class_Descriptor cd_S6087C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(88,216)];
    init_test(&cd_S6087C4, buf);
    S6087C4 *dp, &lv = *(dp=new (buf) S6087C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1392,860), "sizeof(S6087C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C4)");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(288,180), "S6087C4");
    check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(288,180), "S6087C4");
    check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(688,440), "S6087C4");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(688,440), "S6087C4");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*), 0, "S6087C4");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(1208,756), "S6087C4");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(1200,752), "S6087C4");
    check_base_class_offset(lv, (S6087C5*), 0, "S6087C4");
    check_field_offset(lv, s6087c4f0, ABISELECT(224,148), "S6087C4.s6087c4f0");
    check_field_offset(lv, s6087c4f1, ABISELECT(232,152), "S6087C4.s6087c4f1");
    check_field_offset(lv, s6087c4f2, ABISELECT(240,156), "S6087C4.s6087c4f2");
    check_field_offset(lv, s6087c4f3, ABISELECT(256,160), "S6087C4.s6087c4f3");
    check_field_offset(lv, s6087c4f4, ABISELECT(272,172), "S6087C4.s6087c4f4");
    check_field_offset(lv, s6087c4f5, ABISELECT(276,176), "S6087C4.s6087c4f5");
    test_class_info(&lv, &cd_S6087C4);
    dp->~S6087C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C4(Test_S6087C4, "S6087C4", ABISELECT(1392,860));

#else // __cplusplus

extern void _ZN7S6087C4C1Ev();
extern void _ZN7S6087C4D1Ev();
Name_Map name_map_S6087C4[] = {
  NSPAIR(_ZN7S6087C4C1Ev),
  NSPAIR(_ZN7S6087C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
static Base_Class bases_S6087C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C6,    ABISELECT(288,180), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S6087C10,    ABISELECT(688,440), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(688,440), //bcp->offset
    15, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S6087C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(1208,756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(1200,752), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S6087C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S6087C4[];
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C4D1Ev,_ZThn752_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C4D0Ev,_ZThn752_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S6087C4[] = {
  ABISELECT(1200,752),
  ABISELECT(688,440),
  ABISELECT(288,180),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
  0,
  0,
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-688,-440),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-1200,-752),
  ABISELECT(-1200,-752),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern VTBL_ENTRY _ZTV7S6087C4[];
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__7S6087C4[] = {
  ABISELECT(1200,752),
  ABISELECT(688,440),
  ABISELECT(288,180),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__7S6087C4[] = {
  0,
  0,
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__7S6087C4[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-688,-440),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C5D1Ev,_ZThn752_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C5D0Ev,_ZThn752_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__7S6087C4[] = {
  ABISELECT(-1200,-752),
  ABISELECT(-1200,-752),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4[] = {
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__7S6087C4[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
static  VTT_ENTRY vtt_S6087C4[] = {
  {&(_ZTV7S6087C4[5]),  5,29},
  {&(_tg__ZTV7S6087C5__7S6087C4[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__7S6087C4[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__7S6087C4[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__7S6087C4[3]),  3,5},
  {&(_ZTV7S6087C4[13]),  13,29},
  {&(_ZTV7S6087C4[21]),  21,29},
  {&(_ZTV7S6087C4[27]),  27,29},
  {&(_tg__ZTV7S6087C9__7S6087C4[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__7S6087C4[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C5D0Ev,_ZThn752_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C5D1Ev,_ZThn752_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C4D0Ev,_ZThn752_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C4D1Ev,_ZThn752_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C4 = {  "S6087C4", // class name
  bases_S6087C4, 7,
  &(vtc_S6087C4[0]), // expected_vtbl_contents
  &(vtt_S6087C4[0]), // expected_vtt_contents
  ABISELECT(1392,860), // object size
  NSPAIRA(_ZTI7S6087C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S6087C4),29, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S6087C4),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C13  : S6087C10 , S6087C9 , virtual S6087C5 {
  virtual void  v9(); // _ZN8S6087C132v9Ev
  ~S6087C13(); // tgen
  S6087C13(); // tgen
};
//SIG(-1 S6087C13) C1{ BC2{ v2 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} BC3{ BC2 VBC4{ v3 v4 Fp FD Fi FC5{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC6{ BC5 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU7{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v5 v6 Fi FC6 Fi FC6} VBC8{ VBC4 VBC3 BC9{ v7 v8 Fp FC2 Fi Fp FD Fp FL Fc[6]} VBC6 Fl Fl Fc Fc:3} v1}


void  S6087C13 ::v9(){vfunc_called(this, "_ZN8S6087C132v9Ev");}
S6087C13 ::~S6087C13(){ note_dtor("S6087C13", this);} // tgen
S6087C13 ::S6087C13(){ note_ctor("S6087C13", this);} // tgen

static void Test_S6087C13()
{
  extern Class_Descriptor cd_S6087C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(124,308)];
    init_test(&cd_S6087C13, buf);
    S6087C13 *dp, &lv = *(dp=new (buf) S6087C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1968,1228), "sizeof(S6087C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C13)");
    /*is_ambiguous_... S6087C13::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*), 0, "S6087C13");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(128,88), "S6087C13");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(640,400), "S6087C13");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(640,400), "S6087C13");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(640,400), "S6087C13");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*), ABISELECT(128,88), "S6087C13");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(1264,808), "S6087C13");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(1264,808), "S6087C13");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(1040,660), "S6087C13");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(1784,1124), "S6087C13");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(1776,1120), "S6087C13");
    check_base_class_offset(lv, (S6087C5*), ABISELECT(1040,660), "S6087C13");
    test_class_info(&lv, &cd_S6087C13);
    dp->~S6087C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C13(Test_S6087C13, "S6087C13", ABISELECT(1968,1228));

#else // __cplusplus

extern void _ZN8S6087C13C1Ev();
extern void _ZN8S6087C13D1Ev();
Name_Map name_map_S6087C13[] = {
  NSPAIR(_ZN8S6087C13C1Ev),
  NSPAIR(_ZN8S6087C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
static Base_Class bases_S6087C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(640,400), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(128,88), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(1264,808), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(1264,808), //bcp->offset
    34, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(1040,660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(1784,1124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(1776,1120), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(1040,660), //bcp->offset
    22, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C13[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S6087C13[] = {
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
  ABISELECT(512,312),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  0,
  0,
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-1040,-660),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-1040,-660),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-1264,-808),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-1776,-1120),
  ABISELECT(-1776,-1120),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern VTBL_ENTRY _ZTV8S6087C13[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13[] = {
  ABISELECT(512,312),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A__8S6087C13[] = {
  0,
  0,
  ABISELECT(-512,-312),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C13[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C13[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C13[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13[] = {
  ABISELECT(-624,-408),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C13[] = {
  0,
  0,
  ABISELECT(624,408),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
static  VTT_ENTRY vtt_S6087C13[] = {
  {&(_ZTV8S6087C13[6]),  6,48},
  {&(_tg__ZTV7S6087C9__A__8S6087C13[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A__8S6087C13[4]),  4,6},
  {&(_ZTV8S6087C13[13]),  13,48},
  {&(_ZTV8S6087C13[20]),  20,48},
  {&(_ZTV8S6087C13[30]),  30,48},
  {&(_ZTV8S6087C13[40]),  40,48},
  {&(_ZTV8S6087C13[46]),  46,48},
  {&(_tg__ZTV7S6087C5__8S6087C13[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C13[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C13[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C13[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C13[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C13 = {  "S6087C13", // class name
  bases_S6087C13, 10,
  &(vtc_S6087C13[0]), // expected_vtbl_contents
  &(vtt_S6087C13[0]), // expected_vtt_contents
  ABISELECT(1968,1228), // object size
  NSPAIRA(_ZTI8S6087C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S6087C13),48, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C13),14, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C12  : virtual S6087C13 , S6087C4 {
  int s6087c12f0;
  ::S6087C7 s6087c12f1;
  virtual  ~S6087C12(); // _ZN8S6087C12D2Ev
  virtual void  v10(); // _ZN8S6087C123v10Ev
  S6087C12(); // tgen
};
//SIG(-1 S6087C12) C1{ VBC2{ BC3{ v2 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} BC4{ BC3 VBC5{ v3 v4 Fp FD Fi FC6{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC7{ BC6 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU8{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v5 v6 Fi FC7 Fi FC7} VBC9{ VBC5 VBC4 BC10{ v7 v8 Fp FC3 Fi Fp FD Fp FL Fc[6]} VBC7 Fl Fl Fc Fc:3} v9} BC11{ BC9 Fl Fi Fp FD Fi Fi} vd v1 Fi FC7}


 S6087C12 ::~S6087C12(){ note_dtor("S6087C12", this);}
void  S6087C12 ::v10(){vfunc_called(this, "_ZN8S6087C123v10Ev");}
S6087C12 ::S6087C12(){ note_ctor("S6087C12", this);} // tgen

static void Test_S6087C12()
{
  extern Class_Descriptor cd_S6087C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(154,381)];
    init_test(&cd_S6087C12, buf);
    S6087C12 *dp, &lv = *(dp=new (buf) S6087C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2448,1520), "sizeof(S6087C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C12)");
    /*is_ambiguous_... S6087C13::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(480,292), "S6087C12");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(608,380), "S6087C12");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(1120,692), "S6087C12");
    /*is_ambiguous_... S6087C12::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(1120,692), "S6087C12");
    /*is_ambiguous_... S6087C12::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(1120,692), "S6087C12");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(1120,692), "S6087C12");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(608,380), "S6087C12");
    /*is_ambiguous_... S6087C12::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(1744,1100), "S6087C12");
    /*is_ambiguous_... S6087C12::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(1744,1100), "S6087C12");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(1744,1100), "S6087C12");
    /*is_ambiguous_... S6087C12::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(1520,952), "S6087C12");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(2264,1416), "S6087C12");
    /*is_ambiguous_... S6087C12::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(2256,1412), "S6087C12");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(2256,1412), "S6087C12");
    check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(1520,952), "S6087C12");
    check_base_class_offset(lv, (S6087C13*), ABISELECT(480,292), "S6087C12");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), 0, "S6087C12");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*), 0, "S6087C12");
    check_base_class_offset(lv, (S6087C4*), 0, "S6087C12");
    check_field_offset(lv, s6087c12f0, ABISELECT(280,180), "S6087C12.s6087c12f0");
    check_field_offset(lv, s6087c12f1, ABISELECT(288,184), "S6087C12.s6087c12f1");
    test_class_info(&lv, &cd_S6087C12);
    dp->~S6087C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C12(Test_S6087C12, "S6087C12", ABISELECT(2448,1520));

#else // __cplusplus

extern void _ZN8S6087C12C1Ev();
extern void _ZN8S6087C12D2Ev();
Name_Map name_map_S6087C12[] = {
  NSPAIR(_ZN8S6087C12C1Ev),
  NSPAIR(_ZN8S6087C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
static Base_Class bases_S6087C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    ABISELECT(480,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(608,380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(1120,692), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(608,380), //bcp->offset
    27, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(1744,1100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(1744,1100), //bcp->offset
    51, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(1520,952), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(2264,1416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(2256,1412), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(1520,952), //bcp->offset
    39, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S6087C13,    ABISELECT(480,292), //bcp->offset
    12, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C12[];
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn480_N8S6087C12D1Ev,_ZThn292_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn480_N8S6087C12D0Ev,_ZThn292_N8S6087C12D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn1520_N8S6087C12D1Ev,_ZThn952_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn1520_N8S6087C12D0Ev,_ZThn952_N8S6087C12D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn2256_N8S6087C12D1Ev,_ZThn1412_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn2256_N8S6087C12D0Ev,_ZThn1412_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S6087C12[] = {
  ABISELECT(1520,952),
  ABISELECT(480,292),
  ABISELECT(2256,1412),
  ABISELECT(1744,1100),
  ABISELECT(1120,692),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-480,-292),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-480,-292),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
  ABISELECT(512,312),
  ABISELECT(-608,-380),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  0,
  0,
  ABISELECT(-1120,-692),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-1520,-952),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-1520,-952),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-1744,-1100),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-2256,-1412),
  ABISELECT(-2256,-1412),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern VTBL_ENTRY _ZTV8S6087C12[];
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C12[] = {
  ABISELECT(2256,1412),
  ABISELECT(1744,1100),
  ABISELECT(1120,692),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__A1__8S6087C12[] = {
  ABISELECT(2256,1412),
  ABISELECT(1744,1100),
  ABISELECT(1120,692),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C12[] = {
  0,
  0,
  ABISELECT(-1120,-692),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C12[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-1744,-1100),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn2256_N7S6087C5D1Ev,_ZThn1412_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn2256_N7S6087C5D0Ev,_ZThn1412_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C12[] = {
  ABISELECT(-2256,-1412),
  ABISELECT(-2256,-1412),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__8S6087C12[] = {
  0,
  0,
  ABISELECT(-1120,-692),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__8S6087C12[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-1744,-1100),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn2256_N7S6087C4D1Ev,_ZThn1412_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn2256_N7S6087C4D0Ev,_ZThn1412_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__8S6087C12[] = {
  ABISELECT(-2256,-1412),
  ABISELECT(-2256,-1412),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C12[] = {
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C12[] = {
  ABISELECT(512,312),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C12[] = {
  0,
  0,
  ABISELECT(-512,-312),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__8S6087C12[] = {
  ABISELECT(512,312),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__8S6087C12[] = {
  0,
  0,
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__8S6087C12[] = {
  ABISELECT(-1040,-660),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-1040,-660),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__8S6087C12[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-1264,-808),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__8S6087C12[] = {
  ABISELECT(-1776,-1120),
  ABISELECT(-1776,-1120),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C12[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C12[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C12[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C12[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C12[] = {
  ABISELECT(-624,-408),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C12[] = {
  0,
  0,
  ABISELECT(624,408),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
static  VTT_ENTRY vtt_S6087C12[] = {
  {&(_ZTV8S6087C12[7]),  7,65},
  {&(_tg__ZTV7S6087C4__8S6087C12[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__A1__8S6087C12[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C12[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C12[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C12[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__8S6087C12[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__8S6087C12[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__8S6087C12[3]),  3,5},
  {&(_ZTV8S6087C12[23]),  23,65},
  {&(_ZTV8S6087C12[30]),  30,65},
  {&(_ZTV8S6087C12[37]),  37,65},
  {&(_ZTV8S6087C12[47]),  47,65},
  {&(_ZTV8S6087C12[57]),  57,65},
  {&(_ZTV8S6087C12[63]),  63,65},
  {&(_tg__ZTV8S6087C13__8S6087C12[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C12[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C12[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__8S6087C12[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__8S6087C12[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__8S6087C12[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__8S6087C12[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__8S6087C12[3]),  3,5},
  {&(_tg__ZTV7S6087C5__8S6087C12[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C12[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C12[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C12[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C12[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C12[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2256_N7S6087C4D0Ev,_ZThn1412_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2256_N7S6087C4D1Ev,_ZThn1412_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2256_N7S6087C5D0Ev,_ZThn1412_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2256_N7S6087C5D1Ev,_ZThn1412_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2256_N8S6087C12D0Ev,_ZThn1412_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2256_N8S6087C12D1Ev,_ZThn1412_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1520_N8S6087C12D0Ev,_ZThn952_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1520_N8S6087C12D1Ev,_ZThn952_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S6087C12D0Ev,_ZThn292_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S6087C12D1Ev,_ZThn292_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C12 = {  "S6087C12", // class name
  bases_S6087C12, 14,
  &(vtc_S6087C12[0]), // expected_vtbl_contents
  &(vtt_S6087C12[0]), // expected_vtt_contents
  ABISELECT(2448,1520), // object size
  NSPAIRA(_ZTI8S6087C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S6087C12),65, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C12),29, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S6087C15  {
  long s6087c15f0;
  long s6087c15f1;
  long s6087c15f2;
  long s6087c15f3;
  int s6087c15f4;
  long double s6087c15f5;
  long s6087c15f6;
  __tsi64 s6087c15f7;
  unsigned short s6087c15f8:1;
  void  mf6087c15(); // _ZN8S6087C159mf6087c15Ev
};
//SIG(1 S6087C15) U1{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1}

#endif // __cplusplus
#ifdef __cplusplus

struct  S6087C16  : virtual S6087C7 , S6087C9 , S6087C10 , virtual S6087C11 {
  void *s6087c16f0;
  void *s6087c16f1;
  int s6087c16f2;
  long s6087c16f3[2];
  void *s6087c16f4[3];
  void *s6087c16f5;
  ~S6087C16(); // tgen
  S6087C16(); // tgen
};
//SIG(-1 S6087C16) C1{ VBC2{ BC3{ m Fs Fi[2] Fl[8] Fi Fs} vd Fi[3] Fl Fp[5] FL:13 Fl FL} BC4{ BC5{ v1 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} VBC6{ v2 v3 Fp FD Fi FC3 Fs[6] Fc FC2 Fi FU7{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v4 v5 Fi FC2 Fi FC2} BC5 VBC8{ v6 v7 Fp FC5 Fi Fp FD Fp FL Fc[6]} Fp Fp Fi Fl[2] Fp[3] Fp}


S6087C16 ::~S6087C16(){ note_dtor("S6087C16", this);} // tgen
S6087C16 ::S6087C16(){ note_ctor("S6087C16", this);} // tgen

static void Test_S6087C16()
{
  extern Class_Descriptor cd_S6087C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(95,236)];
    init_test(&cd_S6087C16, buf);
    S6087C16 *dp, &lv = *(dp=new (buf) S6087C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1504,940), "sizeof(S6087C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C16)");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(720,440), "S6087C16");
    check_base_class_offset(lv, (S6087C7*), ABISELECT(712,436), "S6087C16");
    check_base_class_offset(lv, (S6087C10*)(S6087C9*), 0, "S6087C16");
    check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(896,544), "S6087C16");
    check_base_class_offset(lv, (S6087C9*), 0, "S6087C16");
    /*is_ambiguous_... S6087C16::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*), ABISELECT(512,312), "S6087C16");
    check_base_class_offset(lv, (S6087C11*), ABISELECT(1296,804), "S6087C16");
    check_field_offset(lv, s6087c16f0, ABISELECT(640,400), "S6087C16.s6087c16f0");
    check_field_offset(lv, s6087c16f1, ABISELECT(648,404), "S6087C16.s6087c16f1");
    check_field_offset(lv, s6087c16f2, ABISELECT(656,408), "S6087C16.s6087c16f2");
    check_field_offset(lv, s6087c16f3, ABISELECT(664,412), "S6087C16.s6087c16f3");
    check_field_offset(lv, s6087c16f4, ABISELECT(680,420), "S6087C16.s6087c16f4");
    check_field_offset(lv, s6087c16f5, ABISELECT(704,432), "S6087C16.s6087c16f5");
    test_class_info(&lv, &cd_S6087C16);
    dp->~S6087C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C16(Test_S6087C16, "S6087C16", ABISELECT(1504,940));

#else // __cplusplus

extern void _ZN8S6087C16C1Ev();
extern void _ZN8S6087C16D1Ev();
Name_Map name_map_S6087C16[] = {
  NSPAIR(_ZN8S6087C16C1Ev),
  NSPAIR(_ZN8S6087C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
static Base_Class bases_S6087C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C2_nt,    ABISELECT(720,440), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(712,436), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(896,544), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S6087C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(512,312), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C11,    ABISELECT(1296,804), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C16[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C16D1Ev();
extern void _ZN8S6087C16D0Ev();
extern void _ZN8S6087C102v4Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev)();
extern void ABISELECT(_ZThn712_N8S6087C16D1Ev,_ZThn436_N8S6087C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev)();
extern void ABISELECT(_ZThn712_N8S6087C16D0Ev,_ZThn436_N8S6087C16D0Ev)() __attribute__((weak));
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY vtc_S6087C16[] = {
  ABISELECT(1296,804),
  ABISELECT(712,436),
  ABISELECT(896,544),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D0Ev,
  ABISELECT(-512,-312),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(-712,-436),
  ABISELECT(-712,-436),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev),
  0,
  0,
  ABISELECT(-896,-544),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  0,
  ABISELECT(-1296,-804),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
extern VTBL_ENTRY _ZTV8S6087C16[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__8S6087C16[] = {
  ABISELECT(896,544),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__8S6087C16[] = {
  0,
  0,
  ABISELECT(-896,-544),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
static  VTT_ENTRY vtt_S6087C16[] = {
  {&(_ZTV8S6087C16[5]),  5,30},
  {&(_tg__ZTV7S6087C9__8S6087C16[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__8S6087C16[4]),  4,6},
  {&(_ZTV8S6087C16[16]),  16,30},
  {&(_ZTV8S6087C16[22]),  22,30},
  {&(_ZTV8S6087C16[28]),  28,30},
};
extern VTBL_ENTRY _ZTI8S6087C16[];
extern  VTBL_ENTRY _ZTV8S6087C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C16[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn712_N8S6087C16D0Ev,_ZThn436_N8S6087C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn712_N8S6087C16D1Ev,_ZThn436_N8S6087C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C16 = {  "S6087C16", // class name
  bases_S6087C16, 7,
  &(vtc_S6087C16[0]), // expected_vtbl_contents
  &(vtt_S6087C16[0]), // expected_vtt_contents
  ABISELECT(1504,940), // object size
  NSPAIRA(_ZTI8S6087C16),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S6087C16),30, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C16),6, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C14  : S6087C13 , S6087C7 {
  ::S6087C8 s6087c14f0;
  int s6087c14f1;
  __tsi64 s6087c14f2[10];
  long s6087c14f3;
  ::S6087C15 s6087c14f4[9];
  int s6087c14f5;
  long s6087c14f6;
  char s6087c14f7;
  ::S6087C16 s6087c14f8;
  virtual void  v11(); // _ZN8S6087C143v11Ev
  ~S6087C14(); // tgen
  S6087C14(); // tgen
};
//SIG(-1 S6087C14) C1{ BC2{ BC3{ v2 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} BC4{ BC3 VBC5{ v3 v4 Fp FD Fi FC6{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC7{ BC6 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU8{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v5 v6 Fi FC7 Fi FC7} VBC9{ VBC5 VBC4 BC10{ v7 v8 Fp FC3 Fi Fp FD Fp FL Fc[6]} VBC7 Fl Fl Fc Fc:3} v9} BC7 v1 FU8 Fi FL[10] Fl FU11{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1}[9] Fi Fl Fc FC12{ VBC7 BC4 BC3 VBC10 Fp Fp Fi Fl[2] Fp[3] Fp}}


void  S6087C14 ::v11(){vfunc_called(this, "_ZN8S6087C143v11Ev");}
S6087C14 ::~S6087C14(){ note_dtor("S6087C14", this);} // tgen
S6087C14 ::S6087C14(){ note_ctor("S6087C14", this);} // tgen

static void Test_S6087C14()
{
  extern Class_Descriptor cd_S6087C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(250,636)];
    init_test(&cd_S6087C14, buf);
    S6087C14 *dp, &lv = *(dp=new (buf) S6087C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3984,2540), "sizeof(S6087C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C14)");
    /*is_ambiguous_... S6087C13::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), 0, "S6087C14");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(128,88), "S6087C14");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(2656,1712), "S6087C14");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(2656,1712), "S6087C14");
    /*is_ambiguous_... S6087C14::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(2656,1712), "S6087C14");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(128,88), "S6087C14");
    /*is_ambiguous_... S6087C14::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(3280,2120), "S6087C14");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(3280,2120), "S6087C14");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(3056,1972), "S6087C14");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(3800,2436), "S6087C14");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(3792,2432), "S6087C14");
    check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(3056,1972), "S6087C14");
    check_base_class_offset(lv, (S6087C13*), 0, "S6087C14");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(648,404), "S6087C14");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*), ABISELECT(640,400), "S6087C14");
    check_field_offset(lv, s6087c14f0, ABISELECT(824,508), "S6087C14.s6087c14f0");
    check_field_offset(lv, s6087c14f1, ABISELECT(880,564), "S6087C14.s6087c14f1");
    check_field_offset(lv, s6087c14f2, ABISELECT(888,568), "S6087C14.s6087c14f2");
    check_field_offset(lv, s6087c14f3, ABISELECT(968,648), "S6087C14.s6087c14f3");
    check_field_offset(lv, s6087c14f4, ABISELECT(976,652), "S6087C14.s6087c14f4");
    check_field_offset(lv, s6087c14f5, ABISELECT(1120,760), "S6087C14.s6087c14f5");
    check_field_offset(lv, s6087c14f6, ABISELECT(1128,764), "S6087C14.s6087c14f6");
    check_field_offset(lv, s6087c14f7, ABISELECT(1136,768), "S6087C14.s6087c14f7");
    check_field_offset(lv, s6087c14f8, ABISELECT(1152,772), "S6087C14.s6087c14f8");
    test_class_info(&lv, &cd_S6087C14);
    dp->~S6087C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C14(Test_S6087C14, "S6087C14", ABISELECT(3984,2540));

#else // __cplusplus

extern void _ZN8S6087C14C1Ev();
extern void _ZN8S6087C14D1Ev();
Name_Map name_map_S6087C14[] = {
  NSPAIR(_ZN8S6087C14C1Ev),
  NSPAIR(_ZN8S6087C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
static Base_Class bases_S6087C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(2656,1712), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(128,88), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(3280,2120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(3280,2120), //bcp->offset
    39, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(3056,1972), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(3800,2436), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(3792,2432), //bcp->offset
    48, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(3056,1972), //bcp->offset
    27, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S6087C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C2_nt,    ABISELECT(648,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(640,400), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C14[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C14D1Ev();
extern void _ZN8S6087C14D0Ev();
extern void _ZN8S6087C143v11Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn640_N8S6087C14D1Ev,_ZThn400_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C14D0Ev,_ZThn400_N8S6087C14D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn3056_N8S6087C14D1Ev,_ZThn1972_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn3056_N8S6087C14D0Ev,_ZThn1972_N8S6087C14D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn3792_N8S6087C14D1Ev,_ZThn2432_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn3792_N8S6087C14D0Ev,_ZThn2432_N8S6087C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S6087C14[] = {
  ABISELECT(3792,2432),
  ABISELECT(3280,2120),
  ABISELECT(3056,1972),
  ABISELECT(2656,1712),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
  ABISELECT(2528,1624),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C14D1Ev,_ZThn400_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C14D0Ev,_ZThn400_N8S6087C14D0Ev),
  0,
  0,
  ABISELECT(-2656,-1712),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-3056,-1972),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-3056,-1972),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-3280,-2120),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-3792,-2432),
  ABISELECT(-3792,-2432),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev),
};
extern VTBL_ENTRY _ZTV8S6087C14[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C14[] = {
  ABISELECT(3792,2432),
  ABISELECT(3280,2120),
  ABISELECT(3056,1972),
  ABISELECT(2656,1712),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C14[] = {
  ABISELECT(2528,1624),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C14[] = {
  0,
  0,
  ABISELECT(-2528,-1624),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__8S6087C14[] = {
  ABISELECT(2528,1624),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__8S6087C14[] = {
  0,
  0,
  ABISELECT(-2656,-1712),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn3056_N8S6087C13D1Ev,_ZThn1972_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn3056_N8S6087C13D0Ev,_ZThn1972_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__8S6087C14[] = {
  ABISELECT(-3056,-1972),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-3056,-1972),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__8S6087C14[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-3280,-2120),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn3792_N8S6087C13D1Ev,_ZThn2432_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn3792_N8S6087C13D0Ev,_ZThn2432_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__8S6087C14[] = {
  ABISELECT(-3792,-2432),
  ABISELECT(-3792,-2432),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C14[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C14[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C14[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C14[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C14[] = {
  ABISELECT(-624,-408),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C14[] = {
  0,
  0,
  ABISELECT(624,408),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
static  VTT_ENTRY vtt_S6087C14[] = {
  {&(_ZTV8S6087C14[6]),  6,53},
  {&(_tg__ZTV8S6087C13__8S6087C14[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C14[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C14[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__8S6087C14[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__8S6087C14[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__8S6087C14[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__8S6087C14[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__8S6087C14[3]),  3,5},
  {&(_ZTV8S6087C14[14]),  14,53},
  {&(_ZTV8S6087C14[25]),  25,53},
  {&(_ZTV8S6087C14[35]),  35,53},
  {&(_ZTV8S6087C14[45]),  45,53},
  {&(_ZTV8S6087C14[51]),  51,53},
  {&(_tg__ZTV7S6087C5__8S6087C14[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C14[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C14[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C14[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C14[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C14[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S6087C14[];
extern  VTBL_ENTRY _ZTV8S6087C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C14[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3792_N8S6087C13D0Ev,_ZThn2432_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3792_N8S6087C13D1Ev,_ZThn2432_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S6087C13D0Ev,_ZThn1972_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S6087C13D1Ev,_ZThn1972_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3792_N8S6087C14D0Ev,_ZThn2432_N8S6087C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3792_N8S6087C14D1Ev,_ZThn2432_N8S6087C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S6087C14D0Ev,_ZThn1972_N8S6087C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S6087C14D1Ev,_ZThn1972_N8S6087C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C14 = {  "S6087C14", // class name
  bases_S6087C14, 13,
  &(vtc_S6087C14[0]), // expected_vtbl_contents
  &(vtt_S6087C14[0]), // expected_vtt_contents
  ABISELECT(3984,2540), // object size
  NSPAIRA(_ZTI8S6087C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S6087C14),53, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C14),20, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C18  : S6087C13 , S6087C12 , virtual S6087C4 , virtual S6087C10 {
  void *s6087c18f0;
  long s6087c18f1;
  int s6087c18f2;
  char s6087c18f3;
  long s6087c18f4;
  int s6087c18f5;
  long s6087c18f6[10];
  int s6087c18f7;
  ::S6087C9 s6087c18f8;
  void *s6087c18f9;
  ::S6087C10 s6087c18f10;
  int s6087c18f11;
  void *s6087c18f12;
  virtual void  v12(); // _ZN8S6087C183v12Ev
  ~S6087C18(); // tgen
  S6087C18(); // tgen
};
//SIG(-1 S6087C18) C1{ BC2{ BC3{ v2 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} BC4{ BC3 VBC5{ v3 v4 Fp FD Fi FC6{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC7{ BC6 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU8{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v5 v6 Fi FC7 Fi FC7} VBC9{ VBC5 VBC4 BC10{ v7 v8 Fp FC3 Fi Fp FD Fp FL Fc[6]} VBC7 Fl Fl Fc Fc:3} v9} BC11{ VBC2 BC12{ BC9 Fl Fi Fp FD Fi Fi} vd v10 Fi FC7} VBC12 VBC3 v1 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC4 Fp FC3 Fi Fp}


void  S6087C18 ::v12(){vfunc_called(this, "_ZN8S6087C183v12Ev");}
S6087C18 ::~S6087C18(){ note_dtor("S6087C18", this);} // tgen
S6087C18 ::S6087C18(){ note_ctor("S6087C18", this);} // tgen

static void Test_S6087C18()
{
  extern Class_Descriptor cd_S6087C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(295,733)];
    init_test(&cd_S6087C18, buf);
    S6087C18 *dp, &lv = *(dp=new (buf) S6087C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4704,2928), "sizeof(S6087C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C18)");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), 0, "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(128,88), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(2320,1432), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(2320,1432), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(2320,1432), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(2320,1432), "S6087C18");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(2320,1432), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(2320,1432), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(128,88), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(2944,1840), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(2944,1840), "S6087C18");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(2944,1840), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(2944,1840), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(2720,1692), "S6087C18");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(3464,2156), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(3456,2152), "S6087C18");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(3456,2152), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(3456,2152), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(2720,1692), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(2720,1692), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*), 0, "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(3648,2260), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(3776,2348), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(3776,2348), "S6087C18");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*), ABISELECT(3648,2260), "S6087C18");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(640,400), "S6087C18");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(640,400), "S6087C18");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*), ABISELECT(640,400), "S6087C18");
    check_base_class_offset(lv, (S6087C12*), ABISELECT(640,400), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(4288,2660), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(4288,2660), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*), ABISELECT(4288,2660), "S6087C18");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*), ABISELECT(4576,2840), "S6087C18");
    check_field_offset(lv, s6087c18f0, ABISELECT(1112,692), "S6087C18.s6087c18f0");
    check_field_offset(lv, s6087c18f1, ABISELECT(1120,696), "S6087C18.s6087c18f1");
    check_field_offset(lv, s6087c18f2, ABISELECT(1128,700), "S6087C18.s6087c18f2");
    check_field_offset(lv, s6087c18f3, ABISELECT(1132,704), "S6087C18.s6087c18f3");
    check_field_offset(lv, s6087c18f4, ABISELECT(1136,708), "S6087C18.s6087c18f4");
    check_field_offset(lv, s6087c18f5, ABISELECT(1144,712), "S6087C18.s6087c18f5");
    check_field_offset(lv, s6087c18f6, ABISELECT(1152,716), "S6087C18.s6087c18f6");
    check_field_offset(lv, s6087c18f7, ABISELECT(1232,756), "S6087C18.s6087c18f7");
    check_field_offset(lv, s6087c18f8, ABISELECT(1248,760), "S6087C18.s6087c18f8");
    check_field_offset(lv, s6087c18f9, ABISELECT(2160,1332), "S6087C18.s6087c18f9");
    check_field_offset(lv, s6087c18f10, ABISELECT(2176,1336), "S6087C18.s6087c18f10");
    check_field_offset(lv, s6087c18f11, ABISELECT(2304,1424), "S6087C18.s6087c18f11");
    check_field_offset(lv, s6087c18f12, ABISELECT(2312,1428), "S6087C18.s6087c18f12");
    test_class_info(&lv, &cd_S6087C18);
    dp->~S6087C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C18(Test_S6087C18, "S6087C18", ABISELECT(4704,2928));

#else // __cplusplus

extern void _ZN8S6087C18C1Ev();
extern void _ZN8S6087C18D1Ev();
Name_Map name_map_S6087C18[] = {
  NSPAIR(_ZN8S6087C18C1Ev),
  NSPAIR(_ZN8S6087C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
static Base_Class bases_S6087C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(2320,1432), //bcp->offset
    32, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(128,88), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(2944,1840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(2944,1840), //bcp->offset
    50, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(2720,1692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(3464,2156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(3456,2152), //bcp->offset
    59, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(2720,1692), //bcp->offset
    38, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S6087C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(3648,2260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(3776,2348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(3776,2348), //bcp->offset
    79, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(3648,2260), //bcp->offset
    64, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(640,400), //bcp->offset
    20, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C11,    ABISELECT(4288,2660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(4288,2660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(4288,2660), //bcp->offset
    85, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    ABISELECT(4576,2840), //bcp->offset
    97, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C18[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn2720_N8S6087C18D1Ev,_ZThn1692_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn2720_N8S6087C18D0Ev,_ZThn1692_N8S6087C18D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn3456_N8S6087C18D1Ev,_ZThn2152_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn3456_N8S6087C18D0Ev,_ZThn2152_N8S6087C18D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn3648_N8S6087C18D1Ev,_ZThn2260_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn3648_N8S6087C18D0Ev,_ZThn2260_N8S6087C18D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn4288_N8S6087C18D1Ev,_ZThn2660_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn4288_N8S6087C18D0Ev,_ZThn2660_N8S6087C18D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C18[] = {
  ABISELECT(4576,2840),
  ABISELECT(4288,2660),
  ABISELECT(3648,2260),
  ABISELECT(3456,2152),
  ABISELECT(2944,1840),
  ABISELECT(2720,1692),
  ABISELECT(2320,1432),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  ABISELECT(2192,1344),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(2080,1292),
  ABISELECT(3008,1860),
  ABISELECT(2816,1752),
  ABISELECT(2304,1440),
  ABISELECT(1680,1032),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  0,
  0,
  ABISELECT(-2320,-1432),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-2720,-1692),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-2720,-1692),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-2944,-1840),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-3456,-2152),
  ABISELECT(-3456,-2152),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-3648,-2260),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-928,-568),
  ABISELECT(-1328,-828),
  ABISELECT(-3648,-2260),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
  ABISELECT(-1456,-916),
  ABISELECT(-3776,-2348),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-4288,-2660),
  0,
  0,
  ABISELECT(-832,-508),
  ABISELECT(-1344,-820),
  ABISELECT(-1968,-1228),
  ABISELECT(-4288,-2660),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
  0,
  ABISELECT(-4576,-2840),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTV8S6087C18[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__A__8S6087C18[] = {
  ABISELECT(3456,2152),
  ABISELECT(2944,1840),
  ABISELECT(2720,1692),
  ABISELECT(2320,1432),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C18[] = {
  ABISELECT(2192,1344),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C18[] = {
  0,
  0,
  ABISELECT(-2192,-1344),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__A__8S6087C18[] = {
  ABISELECT(2192,1344),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__A__8S6087C18[] = {
  0,
  0,
  ABISELECT(-2320,-1432),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn2720_N8S6087C13D1Ev,_ZThn1692_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn2720_N8S6087C13D0Ev,_ZThn1692_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__A__8S6087C18[] = {
  ABISELECT(-2720,-1692),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-2720,-1692),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__A__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-2944,-1840),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn3456_N8S6087C13D1Ev,_ZThn2152_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn3456_N8S6087C13D0Ev,_ZThn2152_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__A__8S6087C18[] = {
  ABISELECT(-3456,-2152),
  ABISELECT(-3456,-2152),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C18[] = {
  ABISELECT(2080,1292),
  ABISELECT(3008,1860),
  ABISELECT(2816,1752),
  ABISELECT(2304,1440),
  ABISELECT(1680,1032),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C12__8S6087C18[] = {
  ABISELECT(2816,1752),
  ABISELECT(2304,1440),
  ABISELECT(1680,1032),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C12__A1__8S6087C18[] = {
  ABISELECT(2816,1752),
  ABISELECT(2304,1440),
  ABISELECT(1680,1032),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C12__A1__8S6087C18[] = {
  0,
  0,
  ABISELECT(-1680,-1032),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C12__A1__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-2304,-1440),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn2816_N7S6087C5D1Ev,_ZThn1752_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn2816_N7S6087C5D0Ev,_ZThn1752_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C12__A1__8S6087C18[] = {
  ABISELECT(-2816,-1752),
  ABISELECT(-2816,-1752),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C12__8S6087C18[] = {
  0,
  0,
  ABISELECT(-1680,-1032),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C12__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-2304,-1440),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn2816_N7S6087C4D1Ev,_ZThn1752_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn2816_N7S6087C4D0Ev,_ZThn1752_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C12__8S6087C18[] = {
  ABISELECT(-2816,-1752),
  ABISELECT(-2816,-1752),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn3008_N8S6087C12D1Ev,_ZThn1860_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn3008_N8S6087C12D0Ev,_ZThn1860_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C12__8S6087C18[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-3008,-1860),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-928,-568),
  ABISELECT(-1328,-828),
  ABISELECT(-3008,-1860),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C12__8S6087C18[] = {
  ABISELECT(-1456,-916),
  ABISELECT(-3136,-1948),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C12__8S6087C18[] = {
  0,
  0,
  ABISELECT(-1680,-1032),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn2080_N8S6087C12D1Ev,_ZThn1292_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn2080_N8S6087C12D0Ev,_ZThn1292_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C12__8S6087C18[] = {
  ABISELECT(-2080,-1292),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-2080,-1292),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C12__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-2304,-1440),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn2816_N8S6087C12D1Ev,_ZThn1752_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn2816_N8S6087C12D0Ev,_ZThn1752_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C12__8S6087C18[] = {
  ABISELECT(-2816,-1752),
  ABISELECT(-2816,-1752),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C18[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C18[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C18[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C18[] = {
  ABISELECT(-624,-408),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C18[] = {
  0,
  0,
  ABISELECT(624,408),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C18[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-928,-568),
  ABISELECT(-1328,-828),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C18[] = {
  ABISELECT(-1456,-916),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__A2__8S6087C18[] = {
  0,
  0,
  ABISELECT(1456,916),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__A1__8S6087C18[] = {
  ABISELECT(-1456,-916),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__A1__8S6087C18[] = {
  0,
  0,
  ABISELECT(1328,828),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__A1__8S6087C18[] = {
  ABISELECT(928,568),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(928,568),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__A1__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__A1__8S6087C18[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C18[] = {
  ABISELECT(-832,-508),
  ABISELECT(-1344,-820),
  ABISELECT(-1968,-1228),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__A2__8S6087C18[] = {
  ABISELECT(-832,-508),
  ABISELECT(-1344,-820),
  ABISELECT(-1968,-1228),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__A2__8S6087C18[] = {
  0,
  0,
  ABISELECT(1968,1228),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__A2__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(1344,820),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__A2__8S6087C18[] = {
  ABISELECT(832,508),
  ABISELECT(832,508),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__A1__8S6087C18[] = {
  0,
  0,
  ABISELECT(1968,1228),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__A1__8S6087C18[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(1344,820),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__A1__8S6087C18[] = {
  ABISELECT(832,508),
  ABISELECT(832,508),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
static  VTT_ENTRY vtt_S6087C18[] = {
  {&(_ZTV8S6087C18[9]),  9,101},
  {&(_tg__ZTV8S6087C13__A__8S6087C18[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C18[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__A__8S6087C18[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__A__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__A__8S6087C18[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__A__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__A__8S6087C18[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C18[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C12__8S6087C18[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C12__A1__8S6087C18[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C12__A1__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C12__A1__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C12__A1__8S6087C18[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C12__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C12__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C12__8S6087C18[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C12__8S6087C18[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C12__8S6087C18[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C12__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C12__8S6087C18[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C12__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C12__8S6087C18[3]),  3,5},
  {&(_ZTV8S6087C18[17]),  17,101},
  {&(_ZTV8S6087C18[36]),  36,101},
  {&(_ZTV8S6087C18[46]),  46,101},
  {&(_ZTV8S6087C18[56]),  56,101},
  {&(_ZTV8S6087C18[62]),  62,101},
  {&(_ZTV8S6087C18[27]),  27,101},
  {&(_ZTV8S6087C18[75]),  75,101},
  {&(_ZTV8S6087C18[82]),  82,101},
  {&(_ZTV8S6087C18[93]),  93,101},
  {&(_ZTV8S6087C18[100]),  100,101},
  {&(_tg__ZTV7S6087C5__8S6087C18[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C18[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C18[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C18[4]),  4,6},
  {&(_tg__ZTV8S6087C13__A1__8S6087C18[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C18[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__A2__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__A1__8S6087C18[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__A1__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__A1__8S6087C18[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__A1__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__A1__8S6087C18[3]),  3,5},
  {&(_tg__ZTV7S6087C4__A1__8S6087C18[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__A2__8S6087C18[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__A2__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__A2__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__A2__8S6087C18[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__A1__8S6087C18[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__A1__8S6087C18[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__A1__8S6087C18[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2816_N8S6087C12D0Ev,_ZThn1752_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2816_N8S6087C12D1Ev,_ZThn1752_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2080_N8S6087C12D0Ev,_ZThn1292_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2080_N8S6087C12D1Ev,_ZThn1292_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3008_N8S6087C12D0Ev,_ZThn1860_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3008_N8S6087C12D1Ev,_ZThn1860_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2816_N7S6087C4D0Ev,_ZThn1752_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2816_N7S6087C4D1Ev,_ZThn1752_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2816_N7S6087C5D0Ev,_ZThn1752_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2816_N7S6087C5D1Ev,_ZThn1752_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S6087C13D0Ev,_ZThn2152_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S6087C13D1Ev,_ZThn2152_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N8S6087C13D0Ev,_ZThn1692_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N8S6087C13D1Ev,_ZThn1692_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3648_N8S6087C18D0Ev,_ZThn2260_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3648_N8S6087C18D1Ev,_ZThn2260_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S6087C18D0Ev,_ZThn2152_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S6087C18D1Ev,_ZThn2152_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4288_N8S6087C18D0Ev,_ZThn2660_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N8S6087C18D0Ev,_ZThn1692_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4288_N8S6087C18D1Ev,_ZThn2660_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N8S6087C18D1Ev,_ZThn1692_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C18 = {  "S6087C18", // class name
  bases_S6087C18, 23,
  &(vtc_S6087C18[0]), // expected_vtbl_contents
  &(vtt_S6087C18[0]), // expected_vtt_contents
  ABISELECT(4704,2928), // object size
  NSPAIRA(_ZTI8S6087C18),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S6087C18),101, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C18),56, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C20  {
  void *s6087c20f0;
  void *s6087c20f1[10];
  ::S6087C5 s6087c20f2;
  int s6087c20f3;
  void  mf6087c20(); // _ZN8S6087C209mf6087c20Ev
};
//SIG(-1 S6087C20) C1{ m Fp[11] FC2{ VBC3{ v1 v2 Fp FD Fi FC4{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC5{ BC4 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU6{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC7{ BC8{ v3 Fi:30 Fp Fi Fi[8] FL Fi FD Fc:3 Fp Fl Fl} VBC3 v4 v5 Fi FC5 Fi FC5} BC9{ v6 v7 Fp FC8 Fi Fp FD Fp FL Fc[6]} VBC5 Fl Fl Fc Fc:3} Fi}


void  S6087C20 ::mf6087c20(){}

static void Test_S6087C20()
{
  {
    init_simple_test("S6087C20");
    static S6087C20 lv;
    check2(sizeof(lv), ABISELECT(1440,876), "sizeof(S6087C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C20)");
    check_field_offset(lv, s6087c20f0, 0, "S6087C20.s6087c20f0");
    check_field_offset(lv, s6087c20f1, ABISELECT(8,4), "S6087C20.s6087c20f1");
    check_field_offset(lv, s6087c20f2, ABISELECT(96,44), "S6087C20.s6087c20f2");
    check_field_offset(lv, s6087c20f3, ABISELECT(1424,872), "S6087C20.s6087c20f3");
  }
}
static Arrange_To_Call_Me vS6087C20(Test_S6087C20, "S6087C20", ABISELECT(1440,876));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S6087C20[];
VTBL_ENTRY *P__ZTI8S6087C20 = _ZTI8S6087C20; 
Class_Descriptor cd_S6087C20 = {  "S6087C20", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(1440,876), // object size
  NSPAIRA(_ZTI8S6087C20),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C19  {
  char s6087c19f0;
  ::S6087C20 s6087c19f1;
  ::S6087C13 s6087c19f2;
  long s6087c19f3;
  short s6087c19f4;
  ::S6087C11 s6087c19f5;
  ::S6087C13 s6087c19f6;
  long s6087c19f7;
  ::S6087C11 s6087c19f8;
  ::S6087C15 s6087c19f9;
  void *s6087c19f10;
  long s6087c19f11;
  int s6087c19f12;
  void *s6087c19f13;
  __tsi64 s6087c19f14:3;
  void  mf6087c19(); // _ZN8S6087C199mf6087c19Ev
};
//SIG(-1 S6087C19) C1{ m Fc FC2{ m Fp[11] FC3{ VBC4{ v1 v2 Fp FD Fi FC5{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC6{ BC5 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU7{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC8{ BC9{ v3 Fi:30 Fp Fi Fi[8] FL Fi FD Fc:3 Fp Fl Fl} VBC4 v4 v5 Fi FC6 Fi FC6} BC10{ v6 v7 Fp FC9 Fi Fp FD Fp FL Fc[6]} VBC6 Fl Fl Fc Fc:3} Fi} FC11{ BC9 BC8 VBC3 v8} Fl Fs FC10 FC11 Fl FC10 FU12{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1} Fp Fl Fi Fp FL:3}


void  S6087C19 ::mf6087c19(){}

static void Test_S6087C19()
{
  {
    init_simple_test("S6087C19");
    static S6087C19 lv;
    check2(sizeof(lv), ABISELECT(5904,3652), "sizeof(S6087C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C19)");
    check_field_offset(lv, s6087c19f0, 0, "S6087C19.s6087c19f0");
    check_field_offset(lv, s6087c19f1, ABISELECT(16,4), "S6087C19.s6087c19f1");
    check_field_offset(lv, s6087c19f2, ABISELECT(1456,880), "S6087C19.s6087c19f2");
    check_field_offset(lv, s6087c19f3, ABISELECT(3424,2108), "S6087C19.s6087c19f3");
    check_field_offset(lv, s6087c19f4, ABISELECT(3432,2112), "S6087C19.s6087c19f4");
    check_field_offset(lv, s6087c19f5, ABISELECT(3440,2116), "S6087C19.s6087c19f5");
    check_field_offset(lv, s6087c19f6, ABISELECT(3648,2252), "S6087C19.s6087c19f6");
    check_field_offset(lv, s6087c19f7, ABISELECT(5616,3480), "S6087C19.s6087c19f7");
    check_field_offset(lv, s6087c19f8, ABISELECT(5632,3484), "S6087C19.s6087c19f8");
    check_field_offset(lv, s6087c19f9, ABISELECT(5840,3620), "S6087C19.s6087c19f9");
    check_field_offset(lv, s6087c19f10, ABISELECT(5856,3632), "S6087C19.s6087c19f10");
    check_field_offset(lv, s6087c19f11, ABISELECT(5864,3636), "S6087C19.s6087c19f11");
    check_field_offset(lv, s6087c19f12, ABISELECT(5872,3640), "S6087C19.s6087c19f12");
    check_field_offset(lv, s6087c19f13, ABISELECT(5880,3644), "S6087C19.s6087c19f13");
    set_bf_and_test(lv, s6087c19f14, ABISELECT(5888,3648), 0, 3, 1, "S6087C19");
    set_bf_and_test(lv, s6087c19f14, ABISELECT(5888,3648), 0, 3, hide_sll(1LL<<2), "S6087C19");
  }
}
static Arrange_To_Call_Me vS6087C19(Test_S6087C19, "S6087C19", ABISELECT(5904,3652));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S6087C19[];
VTBL_ENTRY *P__ZTI8S6087C19 = _ZTI8S6087C19; 
Class_Descriptor cd_S6087C19 = {  "S6087C19", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(5904,3652), // object size
  NSPAIRA(_ZTI8S6087C19),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C17  : virtual S6087C13 , virtual S6087C4 , S6087C18 , S6087C7 , S6087C6 {
  int s6087c17f0;
  ::S6087C19 s6087c17f1;
  long s6087c17f2;
  void *s6087c17f3[6];
  ::S6087C9 s6087c17f4;
  int s6087c17f5;
  int s6087c17f6;
  virtual  ~S6087C17(); // _ZN8S6087C17D2Ev
  virtual void  v13(); // _ZN8S6087C173v13Ev
  S6087C17(); // tgen
};
//SIG(-1 S6087C17) C1{ VBC2{ BC3{ v2 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} BC4{ BC3 VBC5{ v3 v4 Fp FD Fi FC6{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC7{ BC6 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU8{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v5 v6 Fi FC7 Fi FC7} VBC9{ VBC5 VBC4 BC10{ v7 v8 Fp FC3 Fi Fp FD Fp FL Fc[6]} VBC7 Fl Fl Fc Fc:3} v9} VBC11{ BC9 Fl Fi Fp FD Fi Fi} BC12{ BC2 BC13{ VBC2 BC11 vd v10 Fi FC7} VBC11 VBC3 v11 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC4 Fp FC3 Fi Fp} BC7 BC5 vd v1 Fi FC14{ m Fc FC15{ m Fp Fp[10] FC9 Fi} FC2 Fl Fs FC10 FC2 Fl FC10 FU16{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1} Fp Fl Fi Fp FL:3} Fl Fp[6] FC4 Fi Fi}


 S6087C17 ::~S6087C17(){ note_dtor("S6087C17", this);}
void  S6087C17 ::v13(){vfunc_called(this, "_ZN8S6087C173v13Ev");}
S6087C17 ::S6087C17(){ note_ctor("S6087C17", this);} // tgen

static void Test_S6087C17()
{
  extern Class_Descriptor cd_S6087C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(763,1891)];
    init_test(&cd_S6087C17, buf);
    S6087C17 *dp, &lv = *(dp=new (buf) S6087C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12192,7560), "sizeof(S6087C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C17)");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(9808,6064), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(9936,6152), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(10448,6464), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(10448,6464), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(10448,6464), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(10448,6464), "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*), ABISELECT(10448,6464), "S6087C17");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(10448,6464), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(9936,6152), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(11072,6872), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(11072,6872), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(11072,6872), "S6087C17");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(11072,6872), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(10848,6724), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(11592,7188), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(11584,7184), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(11584,7184), "S6087C17");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(11584,7184), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(10848,6724), "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*), ABISELECT(10848,6724), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*), ABISELECT(9808,6064), "S6087C17");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*), ABISELECT(9808,6064), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(11776,7292), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(11776,7292), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*), ABISELECT(11776,7292), "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*), ABISELECT(11776,7292), "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*), 0, "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*), ABISELECT(128,88), "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*), ABISELECT(128,88), "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*), 0, "S6087C17");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(640,400), "S6087C17");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(640,400), "S6087C17");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(640,400), "S6087C17");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*), ABISELECT(640,400), "S6087C17");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*), ABISELECT(12064,7472), "S6087C17");
    check_base_class_offset(lv, (S6087C18*), 0, "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(2328,1436), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*), ABISELECT(2320,1432), "S6087C17");
    /*is_ambiguous_... S6087C17::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*), ABISELECT(2512,1540), "S6087C17");
    check_field_offset(lv, s6087c17f0, ABISELECT(2904,1800), "S6087C17.s6087c17f0");
    check_field_offset(lv, s6087c17f1, ABISELECT(2912,1804), "S6087C17.s6087c17f1");
    check_field_offset(lv, s6087c17f2, ABISELECT(8816,5456), "S6087C17.s6087c17f2");
    check_field_offset(lv, s6087c17f3, ABISELECT(8824,5460), "S6087C17.s6087c17f3");
    check_field_offset(lv, s6087c17f4, ABISELECT(8880,5484), "S6087C17.s6087c17f4");
    check_field_offset(lv, s6087c17f5, ABISELECT(9792,6056), "S6087C17.s6087c17f5");
    check_field_offset(lv, s6087c17f6, ABISELECT(9796,6060), "S6087C17.s6087c17f6");
    test_class_info(&lv, &cd_S6087C17);
    dp->~S6087C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C17(Test_S6087C17, "S6087C17", ABISELECT(12192,7560));

#else // __cplusplus

extern void _ZN8S6087C17C1Ev();
extern void _ZN8S6087C17D2Ev();
Name_Map name_map_S6087C17[] = {
  NSPAIR(_ZN8S6087C17C1Ev),
  NSPAIR(_ZN8S6087C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
static Base_Class bases_S6087C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    ABISELECT(9808,6064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(9936,6152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(10448,6464), //bcp->offset
    62, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(9936,6152), //bcp->offset
    56, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(11072,6872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(11072,6872), //bcp->offset
    80, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(10848,6724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(11592,7188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(11584,7184), //bcp->offset
    89, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(10848,6724), //bcp->offset
    68, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S6087C13,    ABISELECT(9808,6064), //bcp->offset
    41, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C11,    ABISELECT(11776,7292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(11776,7292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(11776,7292), //bcp->offset
    94, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(128,88), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(640,400), //bcp->offset
    21, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(12064,7472), //bcp->offset
    106, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S6087C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C2_nt,    ABISELECT(2328,1436), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(2320,1432), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C6,    ABISELECT(2512,1540), //bcp->offset
    37, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C17[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C17D1Ev();
extern void _ZN8S6087C17D0Ev();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void ABISELECT(_ZThn2320_N8S6087C17D1Ev,_ZThn1432_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn2320_N8S6087C17D0Ev,_ZThn1432_N8S6087C17D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C17D1Ev,_ZThn6064_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C17D0Ev,_ZThn6064_N8S6087C17D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C17D1Ev,_ZThn6724_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C17D0Ev,_ZThn6724_N8S6087C17D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C17D1Ev,_ZThn7184_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C17D0Ev,_ZThn7184_N8S6087C17D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C17D1Ev,_ZThn7292_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C17D0Ev,_ZThn7292_N8S6087C17D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C17[] = {
  ABISELECT(12064,7472),
  ABISELECT(11776,7292),
  ABISELECT(9808,6064),
  ABISELECT(11584,7184),
  ABISELECT(11072,6872),
  ABISELECT(10848,6724),
  ABISELECT(10448,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
  ABISELECT(10320,6376),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(10208,6324),
  ABISELECT(9168,5664),
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-2320,-1432),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2320_N8S6087C17D1Ev,_ZThn1432_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2320_N8S6087C17D0Ev,_ZThn1432_N8S6087C17D0Ev),
  ABISELECT(-2512,-1540),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-9808,-6064),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev),
  ABISELECT(512,312),
  ABISELECT(-9936,-6152),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  0,
  0,
  ABISELECT(-10448,-6464),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-10848,-6724),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10848,-6724),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-11072,-6872),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-11584,-7184),
  ABISELECT(-11584,-7184),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev),
  ABISELECT(-11776,-7292),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  ABISELECT(-11776,-7292),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
  0,
  ABISELECT(-12064,-7472),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTV8S6087C17[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C18__8S6087C17[] = {
  ABISELECT(12064,7472),
  ABISELECT(11776,7292),
  ABISELECT(9808,6064),
  ABISELECT(11584,7184),
  ABISELECT(11072,6872),
  ABISELECT(10848,6724),
  ABISELECT(10448,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C18__A1__8S6087C17[] = {
  ABISELECT(11584,7184),
  ABISELECT(11072,6872),
  ABISELECT(10848,6724),
  ABISELECT(10448,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17[] = {
  ABISELECT(10320,6376),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C18__A2__8S6087C17[] = {
  0,
  0,
  ABISELECT(-10320,-6376),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C18__A1__8S6087C17[] = {
  ABISELECT(10320,6376),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C18__A1__8S6087C17[] = {
  0,
  0,
  ABISELECT(-10448,-6464),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C13D1Ev,_ZThn6724_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C13D0Ev,_ZThn6724_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C18__A1__8S6087C17[] = {
  ABISELECT(-10848,-6724),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10848,-6724),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C18__A1__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-11072,-6872),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C13D1Ev,_ZThn7184_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C13D0Ev,_ZThn7184_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C18__A1__8S6087C17[] = {
  ABISELECT(-11584,-7184),
  ABISELECT(-11584,-7184),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C17[] = {
  ABISELECT(10208,6324),
  ABISELECT(9168,5664),
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C18__A1__8S6087C17[] = {
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[] = {
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[] = {
  0,
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10432,-6472),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C5D1Ev,_ZThn6784_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C5D0Ev,_ZThn6784_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[] = {
  ABISELECT(-10944,-6784),
  ABISELECT(-10944,-6784),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C18__A1__8S6087C17[] = {
  0,
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C18__A1__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10432,-6472),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C4D1Ev,_ZThn6784_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C4D0Ev,_ZThn6784_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C18__A1__8S6087C17[] = {
  ABISELECT(-10944,-6784),
  ABISELECT(-10944,-6784),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn9168_N8S6087C12D1Ev,_ZThn5664_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn9168_N8S6087C12D0Ev,_ZThn5664_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C18__8S6087C17[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-9168,-5664),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-9168,-5664),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C18__8S6087C17[] = {
  ABISELECT(512,312),
  ABISELECT(-9296,-5752),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C18__8S6087C17[] = {
  0,
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn10208_N8S6087C12D1Ev,_ZThn6324_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn10208_N8S6087C12D0Ev,_ZThn6324_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C18__8S6087C17[] = {
  ABISELECT(-10208,-6324),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10208,-6324),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C18__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10432,-6472),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn10944_N8S6087C12D1Ev,_ZThn6784_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn10944_N8S6087C12D0Ev,_ZThn6784_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C18__8S6087C17[] = {
  ABISELECT(-10944,-6784),
  ABISELECT(-10944,-6784),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C18__8S6087C17[] = {
  ABISELECT(10320,6376),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C18__8S6087C17[] = {
  0,
  0,
  ABISELECT(-10448,-6464),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C18D1Ev,_ZThn6724_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C18D0Ev,_ZThn6724_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C18__8S6087C17[] = {
  ABISELECT(-10848,-6724),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10848,-6724),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C18__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-11072,-6872),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C18D1Ev,_ZThn7184_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C18D0Ev,_ZThn7184_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C18__8S6087C17[] = {
  ABISELECT(-11584,-7184),
  ABISELECT(-11584,-7184),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C18__8S6087C17[] = {
  ABISELECT(10208,6324),
  ABISELECT(9168,5664),
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C18D1Ev,_ZThn6064_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C18D0Ev,_ZThn6064_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C18__8S6087C17[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-9808,-6064),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C18__8S6087C17[] = {
  ABISELECT(512,312),
  ABISELECT(-9936,-6152),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C18D1Ev,_ZThn7292_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C18D0Ev,_ZThn7292_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C18__8S6087C17[] = {
  ABISELECT(-11776,-7292),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  ABISELECT(-11776,-7292),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C18__8S6087C17[] = {
  0,
  ABISELECT(-12064,-7472),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C17[] = {
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C17[] = {
  ABISELECT(512,312),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C17[] = {
  0,
  0,
  ABISELECT(-512,-312),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__8S6087C17[] = {
  ABISELECT(512,312),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__8S6087C17[] = {
  0,
  0,
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__8S6087C17[] = {
  ABISELECT(-1040,-660),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-1040,-660),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-1264,-808),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__8S6087C17[] = {
  ABISELECT(-1776,-1120),
  ABISELECT(-1776,-1120),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C17[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C17[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C17[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C17[] = {
  ABISELECT(-624,-408),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C17[] = {
  0,
  0,
  ABISELECT(624,408),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C17[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__A1__8S6087C17[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C17[] = {
  0,
  0,
  ABISELECT(1328,828),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C17[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__8S6087C17[] = {
  0,
  0,
  ABISELECT(1328,828),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__8S6087C17[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__8S6087C17[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
static  VTT_ENTRY vtt_S6087C17[] = {
  {&(_ZTV8S6087C17[9]),  9,110},
  {&(_tg__ZTV8S6087C18__8S6087C17[9]),  9,14},
  {&(_tg__ZTV8S6087C138S6087C18__A1__8S6087C17[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C18__A2__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C18__A1__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C18__A1__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C18__A1__8S6087C17[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C18__A1__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C18__A1__8S6087C17[3]),  3,5},
  {&(_tg__ZTV8S6087C128S6087C18__8S6087C17[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C128S6087C18__A1__8S6087C17[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C18__A2__8S6087C17[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C128S6087C18__A1__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C128S6087C18__A1__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C128S6087C18__A1__8S6087C17[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C128S6087C18__8S6087C17[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C128S6087C18__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C128S6087C18__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C128S6087C18__8S6087C17[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C128S6087C18__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C128S6087C18__8S6087C17[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C18__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C18__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C18__8S6087C17[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C18__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C18__8S6087C17[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C18__8S6087C17[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C18__8S6087C17[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C18__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C18__8S6087C17[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C18__8S6087C17[3]),  3,4},
  {&(_ZTV8S6087C17[52]),  52,110},
  {&(_ZTV8S6087C17[59]),  59,110},
  {&(_ZTV8S6087C17[66]),  66,110},
  {&(_ZTV8S6087C17[76]),  76,110},
  {&(_ZTV8S6087C17[86]),  86,110},
  {&(_ZTV8S6087C17[92]),  92,110},
  {&(_ZTV8S6087C17[102]),  102,110},
  {&(_ZTV8S6087C17[18]),  18,110},
  {&(_ZTV8S6087C17[28]),  28,110},
  {&(_ZTV8S6087C17[109]),  109,110},
  {&(_tg__ZTV8S6087C13__8S6087C17[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__8S6087C17[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__8S6087C17[3]),  3,5},
  {&(_tg__ZTV7S6087C5__8S6087C17[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C17[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C17[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C4__8S6087C17[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__A1__8S6087C17[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C17[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__8S6087C17[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__8S6087C17[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__8S6087C17[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S6087C17[];
extern  VTBL_ENTRY _ZTV8S6087C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C17[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C18D0Ev,_ZThn6064_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C18D1Ev,_ZThn6064_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C18D0Ev,_ZThn7184_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C18D1Ev,_ZThn7184_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C18D0Ev,_ZThn7292_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C18D0Ev,_ZThn6724_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C18D1Ev,_ZThn7292_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C18D1Ev,_ZThn6724_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N8S6087C12D0Ev,_ZThn6784_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N8S6087C12D1Ev,_ZThn6784_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10208_N8S6087C12D0Ev,_ZThn6324_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10208_N8S6087C12D1Ev,_ZThn6324_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9168_N8S6087C12D0Ev,_ZThn5664_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9168_N8S6087C12D1Ev,_ZThn5664_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C4D0Ev,_ZThn6784_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C4D1Ev,_ZThn6784_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C5D0Ev,_ZThn6784_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C5D1Ev,_ZThn6784_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C13D0Ev,_ZThn7184_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C13D1Ev,_ZThn7184_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C13D0Ev,_ZThn6724_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C13D1Ev,_ZThn6724_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C17D0Ev,_ZThn7184_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C17D1Ev,_ZThn7184_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C17D0Ev,_ZThn7292_N8S6087C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C17D0Ev,_ZThn6724_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C17D1Ev,_ZThn7292_N8S6087C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C17D1Ev,_ZThn6724_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C17D0Ev,_ZThn6064_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C17D1Ev,_ZThn6064_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C17 = {  "S6087C17", // class name
  bases_S6087C17, 27,
  &(vtc_S6087C17[0]), // expected_vtbl_contents
  &(vtt_S6087C17[0]), // expected_vtt_contents
  ABISELECT(12192,7560), // object size
  NSPAIRA(_ZTI8S6087C17),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S6087C17),110, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C17),67, //virtual table table var
  25, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C21_nt  {
};
//SIG(-1 S6087C21_nt) C1{}



//skip512 S6087C21_nt

#else // __cplusplus

Class_Descriptor cd_S6087C21_nt = {  "S6087C21_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C3  : virtual S6087C4 , virtual S6087C12 , S6087C14 , virtual S6087C11 , virtual S6087C17 {
  void *s6087c3f0;
  char s6087c3f1;
  ::S6087C4 s6087c3f2;
  int  :0;
  int s6087c3f4;
  int s6087c3f5;
  void *s6087c3f6;
  int s6087c3f7;
  void *s6087c3f8;
  int s6087c3f9;
  ::S6087C21_nt s6087c3f10;
  virtual void  v14(); // _ZN7S6087C33v14Ev
  virtual void  v15(); // _ZN7S6087C33v15Ev
  ~S6087C3(); // tgen
  S6087C3(); // tgen
};
//SIG(-1 S6087C3) C1{ VBC2{ BC3{ VBC4{ v3 v4 Fp FD Fi FC5{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC6{ BC5 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU7{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC8{ BC9{ v5 Fi:30 Fp Fi Fi[8] FL Fi FD Fc:3 Fp Fl Fl} VBC4 v6 v7 Fi FC6 Fi FC6} BC10{ v8 v9 Fp FC9 Fi Fp FD Fp FL Fc[6]} VBC6 Fl Fl Fc Fc:3} Fl Fi Fp FD Fi Fi} VBC11{ VBC12{ BC9 BC8 VBC3 v10} BC2 vd v11 Fi FC6} BC13{ BC12 BC6 v12 FU7 Fi FL[10] Fl FU14{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1}[9] Fi Fl Fc FC15{ VBC6 BC8 BC9 VBC10 Fp Fp Fi Fl[2] Fp[3] Fp}} VBC10 VBC16{ VBC12 VBC2 BC17{ BC12 BC11 VBC2 VBC9 v13 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC8 Fp FC9 Fi Fp} BC6 BC4 vd v14 Fi FC18{ m Fc FC19{ m Fp Fp[10] FC3 Fi} FC12 Fl Fs FC10 FC12 Fl FC10 FU14 Fp Fl Fi Fp FL:3} Fl Fp[6] FC8 Fi Fi} v1 v2 Fp Fc FC2 Fi:0 Fi Fi Fp Fi Fp Fi FC20{}}


void  S6087C3 ::v14(){vfunc_called(this, "_ZN7S6087C33v14Ev");}
void  S6087C3 ::v15(){vfunc_called(this, "_ZN7S6087C33v15Ev");}
S6087C3 ::~S6087C3(){ note_dtor("S6087C3", this);} // tgen
S6087C3 ::S6087C3(){ note_ctor("S6087C3", this);} // tgen

static void Test_S6087C3()
{
  extern Class_Descriptor cd_S6087C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1063,2650)];
    init_test(&cd_S6087C3, buf);
    S6087C3 *dp, &lv = *(dp=new (buf) S6087C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16992,10596), "sizeof(S6087C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C3)");
    /*is_ambiguous_... S6087C3::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(4400,2788), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(4400,2788), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(4400,2788), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(4400,2788), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(4400,2788), "S6087C3");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(4400,2788), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(4400,2788), "S6087C3");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(4400,2788), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(4800,3048), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(4800,3048), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(4800,3048), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(4800,3048), "S6087C3");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(4800,3048), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(4112,2608), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(5320,3364), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(5312,3360), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(5312,3360), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(5312,3360), "S6087C3");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(5312,3360), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(4112,2608), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*), ABISELECT(4112,2608), "S6087C3");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C17*), ABISELECT(4112,2608), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*)(S6087C17*), ABISELECT(4112,2608), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(5984,3760), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(6112,3848), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(6112,3848), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(6624,4160), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(6624,4160), "S6087C3");
    check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C14*), ABISELECT(6624,4160), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(6624,4160), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C12*), ABISELECT(5984,3760), "S6087C3");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C17*), ABISELECT(5984,3760), "S6087C3");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(5984,3760), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(5504,3468), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*), ABISELECT(5504,3468), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C12*), ABISELECT(5504,3468), "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C12 */ AMB_check_base_class_offset(lv, (S6087C12*), ABISELECT(5504,3468), "S6087C3");
    /*is_ambiguous_... S6087C13::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C14*), 0, "S6087C3");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(128,88), "S6087C3");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(128,88), "S6087C3");
    check_base_class_offset(lv, (S6087C13*)(S6087C14*), 0, "S6087C3");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C14*), ABISELECT(648,404), "S6087C3");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C14*), ABISELECT(640,400), "S6087C3");
    check_base_class_offset(lv, (S6087C14*), 0, "S6087C3");
    /*is_ambiguous_... S6087C3::S6087C11 */ AMB_check_base_class_offset(lv, (S6087C11*), ABISELECT(6848,4308), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(7056,4444), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(7184,4532), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(7184,4532), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(7056,4444), "S6087C3");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(7696,4844), "S6087C3");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(7696,4844), "S6087C3");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(7696,4844), "S6087C3");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(7696,4844), "S6087C3");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*)(S6087C17*), ABISELECT(16864,10508), "S6087C3");
    check_base_class_offset(lv, (S6087C18*)(S6087C17*), ABISELECT(7056,4444), "S6087C3");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C17*), ABISELECT(9384,5880), "S6087C3");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C17*), ABISELECT(9376,5876), "S6087C3");
    /*is_ambiguous_... S6087C17::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C17*), ABISELECT(9568,5984), "S6087C3");
    check_base_class_offset(lv, (S6087C17*), ABISELECT(7056,4444), "S6087C3");
    check_field_offset(lv, s6087c3f0, ABISELECT(2656,1712), "S6087C3.s6087c3f0");
    check_field_offset(lv, s6087c3f1, ABISELECT(2664,1716), "S6087C3.s6087c3f1");
    check_field_offset(lv, s6087c3f2, ABISELECT(2672,1720), "S6087C3.s6087c3f2");
    check_field_offset(lv, s6087c3f4, ABISELECT(4064,2580), "S6087C3.s6087c3f4");
    check_field_offset(lv, s6087c3f5, ABISELECT(4068,2584), "S6087C3.s6087c3f5");
    check_field_offset(lv, s6087c3f6, ABISELECT(4072,2588), "S6087C3.s6087c3f6");
    check_field_offset(lv, s6087c3f7, ABISELECT(4080,2592), "S6087C3.s6087c3f7");
    check_field_offset(lv, s6087c3f8, ABISELECT(4088,2596), "S6087C3.s6087c3f8");
    check_field_offset(lv, s6087c3f9, ABISELECT(4096,2600), "S6087C3.s6087c3f9");
    check_field_offset(lv, s6087c3f10, ABISELECT(4100,2604), "S6087C3.s6087c3f10");
    test_class_info(&lv, &cd_S6087C3);
    dp->~S6087C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C3(Test_S6087C3, "S6087C3", ABISELECT(16992,10596));

#else // __cplusplus

extern void _ZN7S6087C3C1Ev();
extern void _ZN7S6087C3D1Ev();
Name_Map name_map_S6087C3[] = {
  NSPAIR(_ZN7S6087C3C1Ev),
  NSPAIR(_ZN7S6087C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C14;
extern VTBL_ENTRY _ZTI8S6087C14[];
extern  VTBL_ENTRY _ZTV8S6087C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C14[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C17;
extern VTBL_ENTRY _ZTI8S6087C17[];
extern  VTBL_ENTRY _ZTV8S6087C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C17[];
static Base_Class bases_S6087C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C6,    ABISELECT(4400,2788), //bcp->offset
    41, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S6087C10,    ABISELECT(4800,3048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(4800,3048), //bcp->offset
    47, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(4112,2608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(5320,3364), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(5312,3360), //bcp->offset
    56, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(4112,2608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(4112,2608), //bcp->offset
    29, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    ABISELECT(5984,3760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(6112,3848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(6112,3848), //bcp->offset
    92, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(6624,4160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(6624,4160), //bcp->offset
    98, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S6087C13,    ABISELECT(5984,3760), //bcp->offset
    77, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(5504,3468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(5504,3468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(5504,3468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(5504,3468), //bcp->offset
    61, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(128,88), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(648,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(640,400), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S6087C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C11,    ABISELECT(6848,4308), //bcp->offset
    110, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    ABISELECT(7056,4444), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(7184,4532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(7184,4532), //bcp->offset
    143, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(7056,4444), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(7696,4844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(7696,4844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(7696,4844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(7696,4844), //bcp->offset
    149, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    79, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(16864,10508), //bcp->offset
    169, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    35, //immediately_derived
  0, 1},
  {&cd_S6087C18,    ABISELECT(7056,4444), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(9384,5880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(9376,5876), //bcp->offset
    161, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(9568,5984), //bcp->offset
    165, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S6087C17,    ABISELECT(7056,4444), //bcp->offset
    116, //bcp->virtual_function_table_offset
    21, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    69, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S6087C3[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN7S6087C3D1Ev();
extern void _ZN7S6087C3D0Ev();
extern void _ZN8S6087C143v11Ev();
extern void _ZN7S6087C33v14Ev();
extern void _ZN7S6087C33v15Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn640_N7S6087C3D1Ev,_ZThn400_N7S6087C3D1Ev)();
extern void ABISELECT(_ZThn640_N7S6087C3D0Ev,_ZThn400_N7S6087C3D0Ev)();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N7S6087C3D1Ev,_ZTv0_n32_N7S6087C3D1Ev)();
extern void ABISELECT(_ZThn4112_N7S6087C3D1Ev,_ZThn2608_N7S6087C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S6087C3D0Ev,_ZTv0_n32_N7S6087C3D0Ev)();
extern void ABISELECT(_ZThn4112_N7S6087C3D0Ev,_ZThn2608_N7S6087C3D0Ev)() __attribute__((weak));
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N7S6087C3D1Ev,_ZTv0_n12_N7S6087C3D1Ev)();
extern void ABISELECT(_ZThn5312_N7S6087C3D1Ev,_ZThn3360_N7S6087C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C3D0Ev,_ZTv0_n12_N7S6087C3D0Ev)();
extern void ABISELECT(_ZThn5312_N7S6087C3D0Ev,_ZThn3360_N7S6087C3D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n80_N7S6087C3D1Ev,_ZTv0_n40_N7S6087C3D1Ev)();
extern void ABISELECT(_ZThn5504_N7S6087C3D1Ev,_ZThn3468_N7S6087C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N7S6087C3D0Ev,_ZTv0_n40_N7S6087C3D0Ev)();
extern void ABISELECT(_ZThn5504_N7S6087C3D0Ev,_ZThn3468_N7S6087C3D0Ev)() __attribute__((weak));
extern void _ZN8S6087C123v10Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N7S6087C3D1Ev,_ZTv0_n36_N7S6087C3D1Ev)();
extern void ABISELECT(_ZThn5984_N7S6087C3D1Ev,_ZThn3760_N7S6087C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S6087C3D0Ev,_ZTv0_n36_N7S6087C3D0Ev)();
extern void ABISELECT(_ZThn5984_N7S6087C3D0Ev,_ZThn3760_N7S6087C3D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N7S6087C3D1Ev,_ZTv0_n32_N7S6087C3D1Ev)();
extern void ABISELECT(_ZThn6624_N7S6087C3D1Ev,_ZThn4160_N7S6087C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S6087C3D0Ev,_ZTv0_n32_N7S6087C3D0Ev)();
extern void ABISELECT(_ZThn6624_N7S6087C3D0Ev,_ZThn4160_N7S6087C3D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n96_N7S6087C3D1Ev,_ZTv0_n48_N7S6087C3D1Ev)();
extern void ABISELECT(_ZThn7056_N7S6087C3D1Ev,_ZThn4444_N7S6087C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N7S6087C3D0Ev,_ZTv0_n48_N7S6087C3D0Ev)();
extern void ABISELECT(_ZThn7056_N7S6087C3D0Ev,_ZThn4444_N7S6087C3D0Ev)() __attribute__((weak));
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTvn640_n96_N7S6087C3D1Ev,_ZTvn400_n48_N7S6087C3D1Ev)();
extern void ABISELECT(_ZTvn640_n96_N7S6087C3D0Ev,_ZTvn400_n48_N7S6087C3D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void ABISELECT(_ZTvn2320_n96_N7S6087C3D1Ev,_ZTvn1432_n48_N7S6087C3D1Ev)();
extern void ABISELECT(_ZTvn2320_n96_N7S6087C3D0Ev,_ZTvn1432_n48_N7S6087C3D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C3[] = {
  ABISELECT(16864,10508),
  ABISELECT(7056,4444),
  ABISELECT(6848,4308),
  ABISELECT(5984,3760),
  ABISELECT(5504,3468),
  ABISELECT(4112,2608),
  ABISELECT(5312,3360),
  ABISELECT(4800,3048),
  ABISELECT(6624,4160),
  ABISELECT(4400,2788),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN7S6087C3D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C3D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
  (VTBL_ENTRY)&_ZN7S6087C33v14Ev,
  (VTBL_ENTRY)&_ZN7S6087C33v15Ev,
  ABISELECT(4272,2700),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N7S6087C3D1Ev,_ZThn400_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N7S6087C3D0Ev,_ZThn400_N7S6087C3D0Ev),
  ABISELECT(-4112,-2608),
  0,
  0,
  ABISELECT(1200,752),
  ABISELECT(688,440),
  ABISELECT(288,180),
  ABISELECT(-4112,-2608),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S6087C3D1Ev,_ZTv0_n32_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S6087C3D0Ev,_ZTv0_n32_N7S6087C3D0Ev),
  0,
  0,
  ABISELECT(-4400,-2788),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-4800,-3048),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-5312,-3360),
  ABISELECT(-5312,-3360),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C3D1Ev,_ZTv0_n12_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C3D0Ev,_ZTv0_n12_N7S6087C3D0Ev),
  0,
  ABISELECT(-5504,-3468),
  0,
  0,
  ABISELECT(1120,692),
  ABISELECT(480,292),
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1104,-680),
  ABISELECT(-5504,-3468),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N7S6087C3D1Ev,_ZTv0_n40_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N7S6087C3D0Ev,_ZTv0_n40_N7S6087C3D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-5984,-3760),
  0,
  0,
  ABISELECT(-672,-400),
  ABISELECT(-1184,-712),
  ABISELECT(640,400),
  ABISELECT(-1584,-972),
  ABISELECT(-5984,-3760),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S6087C3D1Ev,_ZTv0_n36_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S6087C3D0Ev,_ZTv0_n36_N7S6087C3D0Ev),
  ABISELECT(-1712,-1060),
  ABISELECT(-6112,-3848),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-6624,-4160),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(-6624,-4160),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S6087C3D1Ev,_ZTv0_n32_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S6087C3D0Ev,_ZTv0_n32_N7S6087C3D0Ev),
  0,
  0,
  ABISELECT(-6848,-4308),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  ABISELECT(2512,1540),
  ABISELECT(2512,1540),
  0,
  ABISELECT(640,400),
  ABISELECT(640,400),
  ABISELECT(640,400),
  0,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-7056,-4444),
  0,
  0,
  ABISELECT(9808,6064),
  ABISELECT(-2944,-1836),
  ABISELECT(-1072,-684),
  ABISELECT(-1744,-1084),
  ABISELECT(-2256,-1396),
  ABISELECT(-432,-284),
  ABISELECT(-2656,-1656),
  ABISELECT(-7056,-4444),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N7S6087C3D1Ev,_ZTv0_n48_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N7S6087C3D0Ev,_ZTv0_n48_N7S6087C3D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
  ABISELECT(-2784,-1744),
  ABISELECT(-7184,-4532),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-1072,-684),
  ABISELECT(-1712,-1084),
  ABISELECT(-2384,-1484),
  ABISELECT(-2896,-1796),
  ABISELECT(-3296,-2056),
  ABISELECT(-7696,-4844),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn640_n96_N7S6087C3D1Ev,_ZTvn400_n48_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn640_n96_N7S6087C3D0Ev,_ZTvn400_n48_N7S6087C3D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-9376,-5876),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2320_n96_N7S6087C3D1Ev,_ZTvn1432_n48_N7S6087C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2320_n96_N7S6087C3D0Ev,_ZTvn1432_n48_N7S6087C3D0Ev),
  ABISELECT(-9568,-5984),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  ABISELECT(-16864,-10508),
  (VTBL_ENTRY)&(_ZTI7S6087C3[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTV7S6087C3[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C14D1Ev();
extern void _ZN8S6087C14D0Ev();
extern void _ZN8S6087C143v11Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C14__7S6087C3[] = {
  ABISELECT(5312,3360),
  ABISELECT(4800,3048),
  ABISELECT(6624,4160),
  ABISELECT(4400,2788),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C14__A1__7S6087C3[] = {
  ABISELECT(5312,3360),
  ABISELECT(4800,3048),
  ABISELECT(6624,4160),
  ABISELECT(4400,2788),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C14__A2__7S6087C3[] = {
  ABISELECT(4272,2700),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C14__A2__7S6087C3[] = {
  0,
  0,
  ABISELECT(-4272,-2700),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C14__A1__7S6087C3[] = {
  ABISELECT(4272,2700),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C14__A1__7S6087C3[] = {
  0,
  0,
  ABISELECT(-4400,-2788),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn6624_N8S6087C13D1Ev,_ZThn4160_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn6624_N8S6087C13D0Ev,_ZThn4160_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C14__A1__7S6087C3[] = {
  ABISELECT(-6624,-4160),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(-6624,-4160),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C14__A1__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-4800,-3048),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn5312_N8S6087C13D1Ev,_ZThn3360_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn5312_N8S6087C13D0Ev,_ZThn3360_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C14__A1__7S6087C3[] = {
  ABISELECT(-5312,-3360),
  ABISELECT(-5312,-3360),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C14__7S6087C3[] = {
  ABISELECT(4272,2700),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C14__7S6087C3[] = {
  0,
  0,
  ABISELECT(-4400,-2788),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn6624_N8S6087C14D1Ev,_ZThn4160_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn6624_N8S6087C14D0Ev,_ZThn4160_N8S6087C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C14__7S6087C3[] = {
  ABISELECT(-6624,-4160),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(-6624,-4160),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C14__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-4800,-3048),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn5312_N8S6087C14D1Ev,_ZThn3360_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn5312_N8S6087C14D0Ev,_ZThn3360_N8S6087C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C14__7S6087C3[] = {
  ABISELECT(-5312,-3360),
  ABISELECT(-5312,-3360),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__7S6087C3[] = {
  ABISELECT(1200,752),
  ABISELECT(688,440),
  ABISELECT(288,180),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__7S6087C3[] = {
  ABISELECT(1200,752),
  ABISELECT(688,440),
  ABISELECT(288,180),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__7S6087C3[] = {
  0,
  0,
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-688,-440),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C5D1Ev,_ZThn752_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C5D0Ev,_ZThn752_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__7S6087C3[] = {
  ABISELECT(-1200,-752),
  ABISELECT(-1200,-752),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__7S6087C3[] = {
  0,
  0,
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(-688,-440),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C4D1Ev,_ZThn752_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn1200_N7S6087C4D0Ev,_ZThn752_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__7S6087C3[] = {
  ABISELECT(-1200,-752),
  ABISELECT(-1200,-752),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C3[] = {
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__7S6087C3[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__7S6087C3[] = {
  ABISELECT(1120,692),
  ABISELECT(480,292),
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1104,-680),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C12__A1__7S6087C3[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1104,-680),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C12__A2__7S6087C3[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1104,-680),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C12__A2__7S6087C3[] = {
  0,
  0,
  ABISELECT(1104,680),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C12__A2__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C12__A2__7S6087C3[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C12__A1__7S6087C3[] = {
  0,
  0,
  ABISELECT(1104,680),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C12__A1__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C12__A1__7S6087C3[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn480_N8S6087C12D1Ev,_ZThn292_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn480_N8S6087C12D0Ev,_ZThn292_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C12__7S6087C3[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-480,-292),
  0,
  0,
  ABISELECT(-672,-400),
  ABISELECT(-1184,-712),
  ABISELECT(640,400),
  ABISELECT(-1584,-972),
  ABISELECT(-480,-292),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C12__7S6087C3[] = {
  ABISELECT(-1712,-1060),
  ABISELECT(-608,-380),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C12__7S6087C3[] = {
  0,
  0,
  ABISELECT(1104,680),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn1120_N8S6087C12D1Ev,_ZThn692_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn1120_N8S6087C12D0Ev,_ZThn692_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C12__7S6087C3[] = {
  ABISELECT(-1120,-692),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(-1120,-692),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C12__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C12__7S6087C3[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__7S6087C3[] = {
  ABISELECT(-672,-400),
  ABISELECT(-1184,-712),
  ABISELECT(640,400),
  ABISELECT(-1584,-972),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A1__7S6087C3[] = {
  ABISELECT(-1712,-1060),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__A1__7S6087C3[] = {
  0,
  0,
  ABISELECT(1712,1060),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__7S6087C3[] = {
  ABISELECT(-1712,-1060),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__7S6087C3[] = {
  0,
  0,
  ABISELECT(1584,972),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C13D1Ev,_ZThn400_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn640_N8S6087C13D0Ev,_ZThn400_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__7S6087C3[] = {
  ABISELECT(-640,-400),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(1184,712),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__7S6087C3[] = {
  ABISELECT(672,400),
  ABISELECT(672,400),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__A1__7S6087C3[] = {
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__A1__7S6087C3[] = {
  0,
  0,
  ABISELECT(2224,1372),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__A1__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(1824,1112),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__A1__7S6087C3[] = {
  ABISELECT(1312,800),
  ABISELECT(1312,800),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C17D1Ev();
extern void _ZN8S6087C17D0Ev();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C17__7S6087C3[] = {
  ABISELECT(9808,6064),
  ABISELECT(-2944,-1836),
  ABISELECT(-1072,-684),
  ABISELECT(-1744,-1084),
  ABISELECT(-2256,-1396),
  ABISELECT(-432,-284),
  ABISELECT(-2656,-1656),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(9808,6064),
  ABISELECT(-2944,-1836),
  ABISELECT(-1072,-684),
  ABISELECT(-1744,-1084),
  ABISELECT(-2256,-1396),
  ABISELECT(-432,-284),
  ABISELECT(-2656,-1656),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C188S6087C17__A2__7S6087C3[] = {
  ABISELECT(-1744,-1084),
  ABISELECT(-2256,-1396),
  ABISELECT(-432,-284),
  ABISELECT(-2656,-1656),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A3__7S6087C3[] = {
  ABISELECT(-2784,-1744),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C17__A3__7S6087C3[] = {
  0,
  0,
  ABISELECT(2784,1744),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C17__A2__7S6087C3[] = {
  ABISELECT(-2784,-1744),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C188S6087C17__A2__7S6087C3[] = {
  0,
  0,
  ABISELECT(2656,1656),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C188S6087C17__A2__7S6087C3[] = {
  ABISELECT(432,284),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(432,284),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C17__A2__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(2256,1396),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C188S6087C17__A2__7S6087C3[] = {
  ABISELECT(1744,1084),
  ABISELECT(1744,1084),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C17__A1__7S6087C3[] = {
  ABISELECT(-1072,-684),
  ABISELECT(-1712,-1084),
  ABISELECT(-2384,-1484),
  ABISELECT(-2896,-1796),
  ABISELECT(-3296,-2056),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[] = {
  ABISELECT(-2384,-1484),
  ABISELECT(-2896,-1796),
  ABISELECT(-3296,-2056),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[] = {
  ABISELECT(-2384,-1484),
  ABISELECT(-2896,-1796),
  ABISELECT(-3296,-2056),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[] = {
  0,
  0,
  ABISELECT(3296,2056),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(2896,1796),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[] = {
  ABISELECT(2384,1484),
  ABISELECT(2384,1484),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[] = {
  0,
  0,
  ABISELECT(3296,2056),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(2896,1796),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[] = {
  ABISELECT(2384,1484),
  ABISELECT(2384,1484),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C188S6087C17__A1__7S6087C3[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(1712,1084),
  0,
  0,
  ABISELECT(-672,-400),
  ABISELECT(-1184,-712),
  ABISELECT(640,400),
  ABISELECT(-1584,-972),
  ABISELECT(1712,1084),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C17__A1__7S6087C3[] = {
  ABISELECT(-1712,-1060),
  ABISELECT(1584,996),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C188S6087C17__A1__7S6087C3[] = {
  0,
  0,
  ABISELECT(3296,2056),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C188S6087C17__A1__7S6087C3[] = {
  ABISELECT(1072,684),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(1072,684),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C17__A1__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(2896,1796),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C188S6087C17__A1__7S6087C3[] = {
  ABISELECT(2384,1484),
  ABISELECT(2384,1484),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(-2784,-1744),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C188S6087C17__7S6087C3[] = {
  0,
  0,
  ABISELECT(2656,1656),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(432,284),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(432,284),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C188S6087C17__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(2256,1396),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(1744,1084),
  ABISELECT(1744,1084),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(-1072,-684),
  ABISELECT(-1712,-1084),
  ABISELECT(-2384,-1484),
  ABISELECT(-2896,-1796),
  ABISELECT(-3296,-2056),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(1072,684),
  0,
  0,
  ABISELECT(-672,-400),
  ABISELECT(-1184,-712),
  ABISELECT(640,400),
  ABISELECT(-1584,-972),
  ABISELECT(1072,684),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(-1712,-1060),
  ABISELECT(944,596),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C188S6087C17__7S6087C3[] = {
  ABISELECT(2944,1836),
  0,
  0,
  ABISELECT(1200,752),
  ABISELECT(688,440),
  ABISELECT(288,180),
  ABISELECT(2944,1836),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C188S6087C17__7S6087C3[] = {
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev)();
extern void ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C17__7S6087C3[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(1072,684),
  0,
  0,
  ABISELECT(-672,-400),
  ABISELECT(-1184,-712),
  ABISELECT(640,400),
  ABISELECT(-1584,-972),
  ABISELECT(1072,684),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C17__7S6087C3[] = {
  ABISELECT(-1712,-1060),
  ABISELECT(944,596),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C17__7S6087C3[] = {
  0,
  0,
  ABISELECT(2656,1656),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C17__7S6087C3[] = {
  ABISELECT(432,284),
  0,
  0,
  ABISELECT(-1312,-800),
  ABISELECT(-1824,-1112),
  ABISELECT(-2224,-1372),
  ABISELECT(432,284),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C17__7S6087C3[] = {
  0,
  0,
  0,
  ABISELECT(-400,-260),
  ABISELECT(2256,1396),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C17__7S6087C3[] = {
  ABISELECT(1744,1084),
  ABISELECT(1744,1084),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C17__7S6087C3[] = {
  ABISELECT(2944,1836),
  0,
  0,
  ABISELECT(1200,752),
  ABISELECT(688,440),
  ABISELECT(288,180),
  ABISELECT(2944,1836),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17__7S6087C3[] = {
  ABISELECT(-2784,-1744),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C17__7S6087C3[] = {
  ABISELECT(-1072,-684),
  ABISELECT(-1712,-1084),
  ABISELECT(-2384,-1484),
  ABISELECT(-2896,-1796),
  ABISELECT(-3296,-2056),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C17__7S6087C3[] = {
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
static  VTT_ENTRY vtt_S6087C3[] = {
  {&(_ZTV7S6087C3[12]),  12,173},
  {&(_tg__ZTV8S6087C14__7S6087C3[6]),  6,11},
  {&(_tg__ZTV8S6087C138S6087C14__A1__7S6087C3[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C14__A2__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C14__A2__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C14__A1__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C14__A1__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C14__A1__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C14__A1__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C14__A1__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C14__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C14__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C14__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C14__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C14__7S6087C3[3]),  3,5},
  {&(_ZTV7S6087C3[37]),  37,173},
  {&(_ZTV7S6087C3[45]),  45,173},
  {&(_ZTV7S6087C3[53]),  53,173},
  {&(_ZTV7S6087C3[59]),  59,173},
  {&(_ZTV7S6087C3[72]),  72,173},
  {&(_ZTV7S6087C3[88]),  88,173},
  {&(_ZTV7S6087C3[95]),  95,173},
  {&(_ZTV7S6087C3[106]),  106,173},
  {&(_ZTV7S6087C3[22]),  22,173},
  {&(_ZTV7S6087C3[114]),  114,173},
  {&(_ZTV7S6087C3[137]),  137,173},
  {&(_ZTV7S6087C3[146]),  146,173},
  {&(_ZTV7S6087C3[156]),  156,173},
  {&(_ZTV7S6087C3[172]),  172,173},
  {&(_ZTV7S6087C3[163]),  163,173},
  {&(_ZTV7S6087C3[167]),  167,173},
  {&(_tg__ZTV7S6087C4__7S6087C3[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__7S6087C3[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C9__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__7S6087C3[4]),  4,6},
  {&(_tg__ZTV8S6087C12__7S6087C3[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C12__A1__7S6087C3[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C12__A2__7S6087C3[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C12__A2__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C12__A2__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C12__A2__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C12__A1__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C12__A1__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C12__A1__7S6087C3[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C12__7S6087C3[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C12__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C12__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C12__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C12__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C12__7S6087C3[3]),  3,5},
  {&(_tg__ZTV8S6087C13__7S6087C3[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__A1__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__A1__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C5__A1__7S6087C3[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__A1__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__A1__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__A1__7S6087C3[3]),  3,5},
  {&(_tg__ZTV8S6087C17__7S6087C3[9]),  9,15},
  {&(_tg__ZTV8S6087C188S6087C17__7S6087C3[9]),  9,14},
  {&(_tg__ZTV8S6087C138S6087C188S6087C17__A2__7S6087C3[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A3__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C17__A3__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C17__A2__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C188S6087C17__A2__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C188S6087C17__A2__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C17__A2__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C188S6087C17__A2__7S6087C3[3]),  3,5},
  {&(_tg__ZTV8S6087C128S6087C188S6087C17__A1__7S6087C3[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C17__A3__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C17__A2__7S6087C3[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C128S6087C188S6087C17__A1__7S6087C3[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C17__A1__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C128S6087C188S6087C17__A1__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C128S6087C188S6087C17__A1__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C17__A1__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C128S6087C188S6087C17__A1__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C188S6087C17__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C188S6087C17__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C188S6087C17__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C188S6087C17__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C188S6087C17__7S6087C3[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C188S6087C17__7S6087C3[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C188S6087C17__7S6087C3[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C17__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C188S6087C17__7S6087C3[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C188S6087C17__7S6087C3[3]),  3,4},
  {&(_tg__ZTV8S6087C13__8S6087C17__7S6087C3[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C17__7S6087C3[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C17__7S6087C3[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C17__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C17__7S6087C3[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C17__7S6087C3[3]),  3,5},
  {&(_tg__ZTV7S6087C4__8S6087C17__7S6087C3[8]),  8,12},
  {&(_tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17__7S6087C3[3]),  3,6},
  {&(_tg__ZTV8S6087C128S6087C18__8S6087C17__7S6087C3[7]),  7,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C17__7S6087C3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S6087C3[];
extern  VTBL_ENTRY _ZTV7S6087C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C3[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S6087C12D0Ev,_ZThn692_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S6087C12D1Ev,_ZThn692_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S6087C12D0Ev,_ZThn292_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S6087C12D1Ev,_ZThn292_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C4D0Ev,_ZThn752_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C4D1Ev,_ZThn752_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C5D0Ev,_ZThn752_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N7S6087C5D1Ev,_ZThn752_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5312_N8S6087C14D0Ev,_ZThn3360_N8S6087C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5312_N8S6087C14D1Ev,_ZThn3360_N8S6087C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6624_N8S6087C14D0Ev,_ZThn4160_N8S6087C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6624_N8S6087C14D1Ev,_ZThn4160_N8S6087C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5312_N8S6087C13D0Ev,_ZThn3360_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5312_N8S6087C13D1Ev,_ZThn3360_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N8S6087C13D0Ev,_ZThn400_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6624_N8S6087C13D0Ev,_ZThn4160_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N8S6087C13D1Ev,_ZThn400_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6624_N8S6087C13D1Ev,_ZThn4160_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N7S6087C3D0Ev,_ZTv0_n48_N7S6087C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N7S6087C3D0Ev,_ZThn4444_N7S6087C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N7S6087C3D1Ev,_ZTv0_n48_N7S6087C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N7S6087C3D1Ev,_ZThn4444_N7S6087C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S6087C3D0Ev,_ZTv0_n36_N7S6087C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5984_N7S6087C3D0Ev,_ZThn3760_N7S6087C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S6087C3D1Ev,_ZTv0_n36_N7S6087C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5984_N7S6087C3D1Ev,_ZThn3760_N7S6087C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N7S6087C3D0Ev,_ZTv0_n40_N7S6087C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5504_N7S6087C3D0Ev,_ZThn3468_N7S6087C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N7S6087C3D1Ev,_ZTv0_n40_N7S6087C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5504_N7S6087C3D1Ev,_ZThn3468_N7S6087C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C3D0Ev,_ZTv0_n12_N7S6087C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5312_N7S6087C3D0Ev,_ZThn3360_N7S6087C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C3D1Ev,_ZTv0_n12_N7S6087C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5312_N7S6087C3D1Ev,_ZThn3360_N7S6087C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S6087C3D0Ev,_ZTv0_n32_N7S6087C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6624_N7S6087C3D0Ev,_ZThn4160_N7S6087C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4112_N7S6087C3D0Ev,_ZThn2608_N7S6087C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S6087C3D1Ev,_ZTv0_n32_N7S6087C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6624_N7S6087C3D1Ev,_ZThn4160_N7S6087C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4112_N7S6087C3D1Ev,_ZThn2608_N7S6087C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C3 = {  "S6087C3", // class name
  bases_S6087C3, 40,
  &(vtc_S6087C3[0]), // expected_vtbl_contents
  &(vtt_S6087C3[0]), // expected_vtt_contents
  ABISELECT(16992,10596), // object size
  NSPAIRA(_ZTI7S6087C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S6087C3),173, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S6087C3),113, //virtual table table var
  37, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C23  : virtual S6087C11 , S6087C20 {
  char s6087c23f0:4;
  int s6087c23f1;
  int s6087c23f2[6];
  int s6087c23f3[10];
  void *s6087c23f4;
  virtual  ~S6087C23(); // _ZN8S6087C23D2Ev
  S6087C23(); // tgen
};
//SIG(-1 S6087C23) C1{ VBC2{ v1 v2 Fp FC3{ v5 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} Fi Fp FD Fp FL Fc[6]} BC4{ m Fp[11] FC5{ VBC6{ v3 v4 Fp FD Fi FC7{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC8{ BC7 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU9{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC10{ BC3 VBC6 v6 v7 Fi FC8 Fi FC8} BC2 VBC8 Fl Fl Fc Fc:3} Fi} vd Fc:4 Fi Fi[6] Fi[10] Fp}


 S6087C23 ::~S6087C23(){ note_dtor("S6087C23", this);}
S6087C23 ::S6087C23(){ note_ctor("S6087C23", this);} // tgen

static void Test_S6087C23()
{
  extern Class_Descriptor cd_S6087C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(110,274)];
    init_test(&cd_S6087C23, buf);
    S6087C23 *dp, &lv = *(dp=new (buf) S6087C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1744,1092), "sizeof(S6087C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C23)");
    check_base_class_offset(lv, (S6087C11*), ABISELECT(1536,956), "S6087C23");
    check_base_class_offset(lv, (S6087C20*), ABISELECT(16,4), "S6087C23");
    set_bf_and_test(lv, s6087c23f0, ABISELECT(1444,880), 0, 4, 1, "S6087C23");
    set_bf_and_test(lv, s6087c23f0, ABISELECT(1444,880), 0, 4, hide_sll(1LL<<3), "S6087C23");
    check_field_offset(lv, s6087c23f1, ABISELECT(1448,884), "S6087C23.s6087c23f1");
    check_field_offset(lv, s6087c23f2, ABISELECT(1452,888), "S6087C23.s6087c23f2");
    check_field_offset(lv, s6087c23f3, ABISELECT(1476,912), "S6087C23.s6087c23f3");
    check_field_offset(lv, s6087c23f4, ABISELECT(1520,952), "S6087C23.s6087c23f4");
    test_class_info(&lv, &cd_S6087C23);
    dp->~S6087C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C23(Test_S6087C23, "S6087C23", ABISELECT(1744,1092));

#else // __cplusplus

extern void _ZN8S6087C23C1Ev();
extern void _ZN8S6087C23D2Ev();
Name_Map name_map_S6087C23[] = {
  NSPAIR(_ZN8S6087C23C1Ev),
  NSPAIR(_ZN8S6087C23D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C20;
extern VTBL_ENTRY _ZTI8S6087C20[];
static Base_Class bases_S6087C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C11,    ABISELECT(1536,956), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C20,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C23[];
extern void _ZN8S6087C23D1Ev();
extern void _ZN8S6087C23D0Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY vtc_S6087C23[] = {
  ABISELECT(1536,956),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C23[0]),
  (VTBL_ENTRY)&_ZN8S6087C23D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C23D0Ev,
  0,
  0,
  ABISELECT(-1536,-956),
  (VTBL_ENTRY)&(_ZTI8S6087C23[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
extern VTBL_ENTRY _ZTV8S6087C23[];
static  VTT_ENTRY vtt_S6087C23[] = {
  {&(_ZTV8S6087C23[3]),  3,11},
  {&(_ZTV8S6087C23[9]),  9,11},
};
extern VTBL_ENTRY _ZTI8S6087C23[];
extern  VTBL_ENTRY _ZTV8S6087C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C23[];
Class_Descriptor cd_S6087C23 = {  "S6087C23", // class name
  bases_S6087C23, 2,
  &(vtc_S6087C23[0]), // expected_vtbl_contents
  &(vtt_S6087C23[0]), // expected_vtt_contents
  ABISELECT(1744,1092), // object size
  NSPAIRA(_ZTI8S6087C23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S6087C23),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C23),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C24  : S6087C16 , S6087C9 , S6087C19 , S6087C18 , S6087C10 {
  long s6087c24f0;
  int s6087c24f1;
  virtual  ~S6087C24(); // _ZN8S6087C24D2Ev
  S6087C24(); // tgen
};
//SIG(-1 S6087C24) C1{ BC2{ VBC3{ BC4{ m Fs Fi[2] Fl[8] Fi Fs} vd Fi[3] Fl Fp[5] FL:13 Fl FL} BC5{ BC6{ v1 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} VBC7{ v2 v3 Fp FD Fi FC4 Fs[6] Fc FC3 Fi FU8{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v4 v5 Fi FC3 Fi FC3} BC6 VBC9{ v6 v7 Fp FC6 Fi Fp FD Fp FL Fc[6]} Fp Fp Fi Fl[2] Fp[3] Fp} BC5 BC10{ m Fc FC11{ m Fp Fp[10] FC12{ VBC7 VBC5 BC9 VBC3 Fl Fl Fc Fc:3} Fi} FC13{ BC6 BC5 VBC12 v8} Fl Fs FC9 FC13 Fl FC9 FU14{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1} Fp Fl Fi Fp FL:3} BC15{ BC13 BC16{ VBC13 BC17{ BC12 Fl Fi Fp FD Fi Fi} vd v9 Fi FC3} VBC17 VBC6 v10 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC5 Fp FC6 Fi Fp} BC6 vd Fl Fi}


 S6087C24 ::~S6087C24(){ note_dtor("S6087C24", this);}
S6087C24 ::S6087C24(){ note_ctor("S6087C24", this);} // tgen

static void Test_S6087C24()
{
  extern Class_Descriptor cd_S6087C24;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(763,1891)];
    init_test(&cd_S6087C24, buf);
    S6087C24 *dp, &lv = *(dp=new (buf) S6087C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12192,7560), "sizeof(S6087C24)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C24)");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(9608,5932), "S6087C24");
    check_base_class_offset(lv, (S6087C7*)(S6087C16*), ABISELECT(9600,5928), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(9600,5928), "S6087C24");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(9600,5928), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(9600,5928), "S6087C24");
    check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C16*), 0, "S6087C24");
    check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C16*), ABISELECT(9792,6036), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(9792,6036), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*), ABISELECT(9792,6036), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(9792,6036), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(9792,6036), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(9792,6036), "S6087C24");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(9792,6036), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(9792,6036), "S6087C24");
    check_base_class_offset(lv, (S6087C9*)(S6087C16*), 0, "S6087C24");
    /*is_ambiguous_... S6087C16::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C16*), ABISELECT(512,312), "S6087C24");
    check_base_class_offset(lv, (S6087C11*)(S6087C16*), ABISELECT(10192,6296), "S6087C24");
    check_base_class_offset(lv, (S6087C16*), 0, "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(720,436), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*), ABISELECT(720,436), "S6087C24");
    check_base_class_offset(lv, (S6087C19*), ABISELECT(1232,748), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*), ABISELECT(7136,4400), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*), ABISELECT(7264,4488), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*), ABISELECT(7264,4488), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(10624,6580), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(10624,6580), "S6087C24");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(10624,6580), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(10624,6580), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(10400,6432), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*), ABISELECT(10400,6432), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(10400,6432), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*), ABISELECT(7136,4400), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(11136,6892), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(11264,6980), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(11264,6980), "S6087C24");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*), ABISELECT(11136,6892), "S6087C24");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(7776,4800), "S6087C24");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(7776,4800), "S6087C24");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*), ABISELECT(7776,4800), "S6087C24");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*), ABISELECT(7776,4800), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(11776,7292), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(11776,7292), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*), ABISELECT(11776,7292), "S6087C24");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*), ABISELECT(12064,7472), "S6087C24");
    check_base_class_offset(lv, (S6087C18*), ABISELECT(7136,4400), "S6087C24");
    /*is_ambiguous_... S6087C24::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*), ABISELECT(9456,5832), "S6087C24");
    check_field_offset(lv, s6087c24f0, ABISELECT(9584,5920), "S6087C24.s6087c24f0");
    check_field_offset(lv, s6087c24f1, ABISELECT(9592,5924), "S6087C24.s6087c24f1");
    test_class_info(&lv, &cd_S6087C24);
    dp->~S6087C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C24(Test_S6087C24, "S6087C24", ABISELECT(12192,7560));

#else // __cplusplus

extern void _ZN8S6087C24C1Ev();
extern void _ZN8S6087C24D2Ev();
Name_Map name_map_S6087C24[] = {
  NSPAIR(_ZN8S6087C24C1Ev),
  NSPAIR(_ZN8S6087C24D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C16;
extern VTBL_ENTRY _ZTI8S6087C16[];
extern  VTBL_ENTRY _ZTV8S6087C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C16[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C19;
extern VTBL_ENTRY _ZTI8S6087C19[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
static Base_Class bases_S6087C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C2_nt,    ABISELECT(9608,5932), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(9600,5928), //bcp->offset
    59, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(9792,6036), //bcp->offset
    64, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S6087C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(512,312), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(10192,6296), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S6087C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(720,436), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(720,436), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C19,    ABISELECT(1232,748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(7136,4400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(7264,4488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(7264,4488), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(10624,6580), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(10624,6580), //bcp->offset
    88, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(10400,6432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(10400,6432), //bcp->offset
    76, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S6087C13,    ABISELECT(7136,4400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(11136,6892), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(11264,6980), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(11264,6980), //bcp->offset
    112, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(11136,6892), //bcp->offset
    97, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(7776,4800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(7776,4800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(7776,4800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(7776,4800), //bcp->offset
    44, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(11776,7292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(11776,7292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(11776,7292), //bcp->offset
    118, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S6087C10,    ABISELECT(12064,7472), //bcp->offset
    130, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    56, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S6087C18,    ABISELECT(7136,4400), //bcp->offset
    24, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(9456,5832), //bcp->offset
    56, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C24[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C24D1Ev();
extern void _ZN8S6087C24D0Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn7136_N8S6087C24D1Ev,_ZThn4400_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn7136_N8S6087C24D0Ev,_ZThn4400_N8S6087C24D0Ev)();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn7776_N8S6087C24D1Ev,_ZThn4800_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn7776_N8S6087C24D0Ev,_ZThn4800_N8S6087C24D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void _ZN8S6087C102v4Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C24D1Ev,_ZTv0_n12_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn9600_N8S6087C24D1Ev,_ZThn5928_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C24D0Ev,_ZTv0_n12_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn9600_N8S6087C24D0Ev,_ZThn5928_N8S6087C24D0Ev)() __attribute__((weak));
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn10400_N8S6087C24D1Ev,_ZThn6432_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn10400_N8S6087C24D0Ev,_ZThn6432_N8S6087C24D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C24D1Ev,_ZTv0_n36_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn11136_N8S6087C24D1Ev,_ZThn6892_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C24D0Ev,_ZTv0_n36_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn11136_N8S6087C24D0Ev,_ZThn6892_N8S6087C24D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C24D1Ev,_ZThn7292_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C24D0Ev,_ZThn7292_N8S6087C24D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C24[] = {
  ABISELECT(12064,7472),
  ABISELECT(11776,7292),
  ABISELECT(11136,6892),
  ABISELECT(10624,6580),
  ABISELECT(10400,6432),
  ABISELECT(10192,6296),
  ABISELECT(9600,5928),
  ABISELECT(9792,6036),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&_ZN8S6087C24D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C24D0Ev,
  ABISELECT(-512,-312),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(9072,5600),
  ABISELECT(-720,-436),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(4928,3072),
  ABISELECT(4640,2892),
  ABISELECT(4000,2492),
  ABISELECT(2464,1528),
  ABISELECT(3488,2180),
  ABISELECT(3264,2032),
  ABISELECT(2656,1636),
  ABISELECT(-7136,-4400),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn7136_N8S6087C24D1Ev,_ZThn4400_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7136_N8S6087C24D0Ev,_ZThn4400_N8S6087C24D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  ABISELECT(2528,1548),
  ABISELECT(-7264,-4488),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(2624,1632),
  ABISELECT(3360,2092),
  ABISELECT(1824,1128),
  ABISELECT(2848,1780),
  ABISELECT(2016,1236),
  ABISELECT(-7776,-4800),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn7776_N8S6087C24D1Ev,_ZThn4800_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7776_N8S6087C24D0Ev,_ZThn4800_N8S6087C24D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-9456,-5832),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(-9600,-5928),
  ABISELECT(-9600,-5928),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C24D1Ev,_ZTv0_n12_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C24D0Ev,_ZTv0_n12_N8S6087C24D0Ev),
  0,
  0,
  ABISELECT(-9792,-6036),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  0,
  ABISELECT(-10192,-6296),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  ABISELECT(-10400,-6432),
  0,
  0,
  ABISELECT(-800,-504),
  ABISELECT(224,148),
  ABISELECT(-608,-396),
  ABISELECT(-10400,-6432),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev),
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(-10624,-6580),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-11136,-6892),
  0,
  0,
  ABISELECT(-1536,-964),
  ABISELECT(-512,-312),
  ABISELECT(-736,-460),
  ABISELECT(-1344,-856),
  ABISELECT(-11136,-6892),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C24D1Ev,_ZTv0_n36_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C24D0Ev,_ZTv0_n36_N8S6087C24D0Ev),
  ABISELECT(-1472,-944),
  ABISELECT(-11264,-6980),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-11776,-7292),
  0,
  0,
  ABISELECT(-2176,-1364),
  ABISELECT(-1152,-712),
  ABISELECT(-1984,-1256),
  ABISELECT(-11776,-7292),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev),
  0,
  ABISELECT(-12064,-7472),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTV8S6087C24[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C16D1Ev();
extern void _ZN8S6087C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C16__8S6087C24[] = {
  ABISELECT(10192,6296),
  ABISELECT(9600,5928),
  ABISELECT(9792,6036),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C16__8S6087C24[] = {
  ABISELECT(9792,6036),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C16__8S6087C24[] = {
  0,
  0,
  ABISELECT(-9792,-6036),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev)();
extern void ABISELECT(_ZThn9600_N8S6087C16D1Ev,_ZThn5928_N8S6087C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev)();
extern void ABISELECT(_ZThn9600_N8S6087C16D0Ev,_ZThn5928_N8S6087C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C16__8S6087C24[] = {
  ABISELECT(-9600,-5928),
  ABISELECT(-9600,-5928),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C16__8S6087C24[] = {
  0,
  0,
  ABISELECT(-9792,-6036),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C11__8S6087C16__8S6087C24[] = {
  0,
  0,
  ABISELECT(-10192,-6296),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C24[] = {
  ABISELECT(9072,5600),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A__8S6087C24[] = {
  0,
  0,
  ABISELECT(-9072,-5600),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C18__8S6087C24[] = {
  ABISELECT(4928,3072),
  ABISELECT(4640,2892),
  ABISELECT(4000,2492),
  ABISELECT(2464,1528),
  ABISELECT(3488,2180),
  ABISELECT(3264,2032),
  ABISELECT(2656,1636),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C18__8S6087C24[] = {
  ABISELECT(2464,1528),
  ABISELECT(3488,2180),
  ABISELECT(3264,2032),
  ABISELECT(2656,1636),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C24[] = {
  ABISELECT(2528,1548),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C18__A2__8S6087C24[] = {
  0,
  0,
  ABISELECT(-2528,-1548),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C18__8S6087C24[] = {
  ABISELECT(2528,1548),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C18__8S6087C24[] = {
  0,
  0,
  ABISELECT(-2656,-1636),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn3264_N8S6087C13D1Ev,_ZThn2032_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn3264_N8S6087C13D0Ev,_ZThn2032_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C18__8S6087C24[] = {
  ABISELECT(-3264,-2032),
  0,
  0,
  ABISELECT(-800,-504),
  ABISELECT(224,148),
  ABISELECT(-608,-396),
  ABISELECT(-3264,-2032),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C18__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(-3488,-2180),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn2464_N8S6087C13D1Ev,_ZThn1528_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn2464_N8S6087C13D0Ev,_ZThn1528_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C18__8S6087C24[] = {
  ABISELECT(-2464,-1528),
  ABISELECT(-2464,-1528),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C24[] = {
  ABISELECT(2624,1632),
  ABISELECT(3360,2092),
  ABISELECT(1824,1128),
  ABISELECT(2848,1780),
  ABISELECT(2016,1236),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C18__8S6087C24[] = {
  ABISELECT(1824,1128),
  ABISELECT(2848,1780),
  ABISELECT(2016,1236),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[] = {
  ABISELECT(1824,1128),
  ABISELECT(2848,1780),
  ABISELECT(2016,1236),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[] = {
  0,
  0,
  ABISELECT(-2016,-1236),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(-2848,-1780),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn1824_N7S6087C5D1Ev,_ZThn1128_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn1824_N7S6087C5D0Ev,_ZThn1128_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[] = {
  ABISELECT(-1824,-1128),
  ABISELECT(-1824,-1128),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C18__8S6087C24[] = {
  0,
  0,
  ABISELECT(-2016,-1236),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C18__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(-2848,-1780),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn1824_N7S6087C4D1Ev,_ZThn1128_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn1824_N7S6087C4D0Ev,_ZThn1128_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C18__8S6087C24[] = {
  ABISELECT(-1824,-1128),
  ABISELECT(-1824,-1128),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn3360_N8S6087C12D1Ev,_ZThn2092_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn3360_N8S6087C12D0Ev,_ZThn2092_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C18__8S6087C24[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-3360,-2092),
  0,
  0,
  ABISELECT(-1536,-964),
  ABISELECT(-512,-312),
  ABISELECT(-736,-460),
  ABISELECT(-1344,-856),
  ABISELECT(-3360,-2092),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C18__8S6087C24[] = {
  ABISELECT(-1472,-944),
  ABISELECT(-3488,-2180),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C18__8S6087C24[] = {
  0,
  0,
  ABISELECT(-2016,-1236),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn2624_N8S6087C12D1Ev,_ZThn1632_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn2624_N8S6087C12D0Ev,_ZThn1632_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C18__8S6087C24[] = {
  ABISELECT(-2624,-1632),
  0,
  0,
  ABISELECT(-800,-504),
  ABISELECT(224,148),
  ABISELECT(-608,-396),
  ABISELECT(-2624,-1632),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C18__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(-2848,-1780),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn1824_N8S6087C12D1Ev,_ZThn1128_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn1824_N8S6087C12D0Ev,_ZThn1128_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C18__8S6087C24[] = {
  ABISELECT(-1824,-1128),
  ABISELECT(-1824,-1128),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C18__8S6087C24[] = {
  ABISELECT(2528,1548),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C18__8S6087C24[] = {
  0,
  0,
  ABISELECT(-2656,-1636),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn3264_N8S6087C18D1Ev,_ZThn2032_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn3264_N8S6087C18D0Ev,_ZThn2032_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C18__8S6087C24[] = {
  ABISELECT(-3264,-2032),
  0,
  0,
  ABISELECT(-800,-504),
  ABISELECT(224,148),
  ABISELECT(-608,-396),
  ABISELECT(-3264,-2032),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C18__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(-3488,-2180),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn2464_N8S6087C18D1Ev,_ZThn1528_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn2464_N8S6087C18D0Ev,_ZThn1528_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C18__8S6087C24[] = {
  ABISELECT(-2464,-1528),
  ABISELECT(-2464,-1528),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C18__8S6087C24[] = {
  ABISELECT(2624,1632),
  ABISELECT(3360,2092),
  ABISELECT(1824,1128),
  ABISELECT(2848,1780),
  ABISELECT(2016,1236),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn4000_N8S6087C18D1Ev,_ZThn2492_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn4000_N8S6087C18D0Ev,_ZThn2492_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C18__8S6087C24[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-4000,-2492),
  0,
  0,
  ABISELECT(-1536,-964),
  ABISELECT(-512,-312),
  ABISELECT(-736,-460),
  ABISELECT(-1344,-856),
  ABISELECT(-4000,-2492),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C18__8S6087C24[] = {
  ABISELECT(-1472,-944),
  ABISELECT(-4128,-2580),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn4640_N8S6087C18D1Ev,_ZThn2892_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn4640_N8S6087C18D0Ev,_ZThn2892_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C18__8S6087C24[] = {
  ABISELECT(-4640,-2892),
  0,
  0,
  ABISELECT(-2176,-1364),
  ABISELECT(-1152,-712),
  ABISELECT(-1984,-1256),
  ABISELECT(-4640,-2892),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C18__8S6087C24[] = {
  0,
  ABISELECT(-4928,-3072),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C24[] = {
  ABISELECT(-800,-504),
  ABISELECT(224,148),
  ABISELECT(-608,-396),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C24[] = {
  0,
  0,
  ABISELECT(608,396),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C24[] = {
  ABISELECT(800,504),
  ABISELECT(800,504),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A3__8S6087C24[] = {
  ABISELECT(-832,-544),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A3__8S6087C24[] = {
  0,
  0,
  ABISELECT(832,544),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C24[] = {
  ABISELECT(-1536,-964),
  ABISELECT(-512,-312),
  ABISELECT(-736,-460),
  ABISELECT(-1344,-856),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A4__8S6087C24[] = {
  ABISELECT(-1472,-944),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__A4__8S6087C24[] = {
  0,
  0,
  ABISELECT(1472,944),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__A1__8S6087C24[] = {
  ABISELECT(-1472,-944),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__A1__8S6087C24[] = {
  0,
  0,
  ABISELECT(1344,856),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__A1__8S6087C24[] = {
  ABISELECT(736,460),
  0,
  0,
  ABISELECT(-800,-504),
  ABISELECT(224,148),
  ABISELECT(-608,-396),
  ABISELECT(736,460),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__A1__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(512,312),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__A1__8S6087C24[] = {
  ABISELECT(1536,964),
  ABISELECT(1536,964),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C24[] = {
  ABISELECT(-2176,-1364),
  ABISELECT(-1152,-712),
  ABISELECT(-1984,-1256),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__A2__8S6087C24[] = {
  ABISELECT(-2176,-1364),
  ABISELECT(-1152,-712),
  ABISELECT(-1984,-1256),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__A2__8S6087C24[] = {
  0,
  0,
  ABISELECT(1984,1256),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__A2__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(1152,712),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__A2__8S6087C24[] = {
  ABISELECT(2176,1364),
  ABISELECT(2176,1364),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__A1__8S6087C24[] = {
  0,
  0,
  ABISELECT(1984,1256),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__A1__8S6087C24[] = {
  0,
  0,
  0,
  ABISELECT(-832,-544),
  ABISELECT(1152,712),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__A1__8S6087C24[] = {
  ABISELECT(2176,1364),
  ABISELECT(2176,1364),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
static  VTT_ENTRY vtt_S6087C24[] = {
  {&(_ZTV8S6087C24[10]),  10,134},
  {&(_tg__ZTV8S6087C16__8S6087C24[5]),  5,10},
  {&(_tg__ZTV7S6087C98S6087C16__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C16__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C7__8S6087C16__8S6087C24[3]),  3,5},
  {&(_tg__ZTV7S6087C6__8S6087C16__8S6087C24[4]),  4,6},
  {&(_tg__ZTV8S6087C11__8S6087C16__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A__8S6087C24[4]),  4,6},
  {&(_tg__ZTV8S6087C18__8S6087C24[9]),  9,14},
  {&(_tg__ZTV8S6087C138S6087C18__8S6087C24[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C18__A2__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C18__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C18__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C18__8S6087C24[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C18__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C18__8S6087C24[3]),  3,5},
  {&(_tg__ZTV8S6087C128S6087C18__8S6087C24[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C128S6087C18__8S6087C24[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C18__A1__8S6087C24[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C128S6087C18__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C128S6087C18__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C128S6087C18__8S6087C24[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C128S6087C18__8S6087C24[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C128S6087C18__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C128S6087C18__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C128S6087C18__8S6087C24[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C128S6087C18__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C128S6087C18__8S6087C24[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C18__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C18__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C18__8S6087C24[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C18__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C18__8S6087C24[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C18__8S6087C24[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C18__8S6087C24[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C18__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C18__8S6087C24[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C18__8S6087C24[3]),  3,4},
  {&(_ZTV8S6087C24[62]),  62,134},
  {&(_ZTV8S6087C24[68]),  68,134},
  {&(_ZTV8S6087C24[74]),  74,134},
  {&(_ZTV8S6087C24[21]),  21,134},
  {&(_ZTV8S6087C24[33]),  33,134},
  {&(_ZTV8S6087C24[41]),  41,134},
  {&(_ZTV8S6087C24[84]),  84,134},
  {&(_ZTV8S6087C24[94]),  94,134},
  {&(_ZTV8S6087C24[51]),  51,134},
  {&(_ZTV8S6087C24[108]),  108,134},
  {&(_ZTV8S6087C24[115]),  115,134},
  {&(_ZTV8S6087C24[126]),  126,134},
  {&(_ZTV8S6087C24[133]),  133,134},
  {&(_tg__ZTV7S6087C5__8S6087C24[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C24[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A3__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A3__8S6087C24[4]),  4,6},
  {&(_tg__ZTV8S6087C13__A1__8S6087C24[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__A4__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__A4__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__A1__8S6087C24[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__A1__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__A1__8S6087C24[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__A1__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__A1__8S6087C24[3]),  3,5},
  {&(_tg__ZTV7S6087C4__A1__8S6087C24[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__A2__8S6087C24[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__A2__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__A2__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__A2__8S6087C24[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__A1__8S6087C24[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__A1__8S6087C24[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__A1__8S6087C24[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S6087C24[];
extern  VTBL_ENTRY _ZTV8S6087C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C24[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4000_N8S6087C18D0Ev,_ZThn2492_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4000_N8S6087C18D1Ev,_ZThn2492_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2464_N8S6087C18D0Ev,_ZThn1528_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2464_N8S6087C18D1Ev,_ZThn1528_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4640_N8S6087C18D0Ev,_ZThn2892_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3264_N8S6087C18D0Ev,_ZThn2032_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4640_N8S6087C18D1Ev,_ZThn2892_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3264_N8S6087C18D1Ev,_ZThn2032_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1824_N8S6087C12D0Ev,_ZThn1128_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1824_N8S6087C12D1Ev,_ZThn1128_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2624_N8S6087C12D0Ev,_ZThn1632_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2624_N8S6087C12D1Ev,_ZThn1632_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S6087C12D0Ev,_ZThn2092_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S6087C12D1Ev,_ZThn2092_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1824_N7S6087C4D0Ev,_ZThn1128_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1824_N7S6087C4D1Ev,_ZThn1128_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1824_N7S6087C5D0Ev,_ZThn1128_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1824_N7S6087C5D1Ev,_ZThn1128_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2464_N8S6087C13D0Ev,_ZThn1528_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2464_N8S6087C13D1Ev,_ZThn1528_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3264_N8S6087C13D0Ev,_ZThn2032_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3264_N8S6087C13D1Ev,_ZThn2032_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9600_N8S6087C16D0Ev,_ZThn5928_N8S6087C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9600_N8S6087C16D1Ev,_ZThn5928_N8S6087C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C24D0Ev,_ZTv0_n36_N8S6087C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11136_N8S6087C24D0Ev,_ZThn6892_N8S6087C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C24D1Ev,_ZTv0_n36_N8S6087C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11136_N8S6087C24D1Ev,_ZThn6892_N8S6087C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C24D0Ev,_ZThn7292_N8S6087C24D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10400_N8S6087C24D0Ev,_ZThn6432_N8S6087C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C24D1Ev,_ZThn7292_N8S6087C24D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10400_N8S6087C24D1Ev,_ZThn6432_N8S6087C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C24D0Ev,_ZTv0_n12_N8S6087C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9600_N8S6087C24D0Ev,_ZThn5928_N8S6087C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C24D1Ev,_ZTv0_n12_N8S6087C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9600_N8S6087C24D1Ev,_ZThn5928_N8S6087C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C24 = {  "S6087C24", // class name
  bases_S6087C24, 33,
  &(vtc_S6087C24[0]), // expected_vtbl_contents
  &(vtt_S6087C24[0]), // expected_vtt_contents
  ABISELECT(12192,7560), // object size
  NSPAIRA(_ZTI8S6087C24),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S6087C24),134, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C24),78, //virtual table table var
  31, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C22  : virtual S6087C23 , S6087C10 , virtual S6087C17 , S6087C19 , S6087C24 {
  int s6087c22f0;
  ::S6087C2_nt s6087c22f1;
  int s6087c22f2;
  char s6087c22f3;
  int s6087c22f4[7];
  int s6087c22f5;
  long double s6087c22f6;
  int s6087c22f7[9];
  int s6087c22f8;
  virtual  ~S6087C22(); // _ZN8S6087C22D2Ev
  virtual void  v16(); // _ZN8S6087C223v16Ev
  S6087C22(); // tgen
};
//SIG(-1 S6087C22) C1{ VBC2{ VBC3{ v2 v3 Fp FC4{ v4 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} Fi Fp FD Fp FL Fc[6]} BC5{ m Fp[11] FC6{ VBC7{ v5 v6 Fp FD Fi FC8{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC9{ BC8 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU10{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC11{ BC4 VBC7 v7 v8 Fi FC9 Fi FC9} BC3 VBC9 Fl Fl Fc Fc:3} Fi} vd Fc:4 Fi Fi[6] Fi[10] Fp} BC4 VBC12{ VBC13{ BC4 BC11 VBC6 v9} VBC14{ BC6 Fl Fi Fp FD Fi Fi} BC15{ BC13 BC16{ VBC13 BC14 vd v10 Fi FC9} VBC14 VBC4 v11 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC11 Fp FC4 Fi Fp} BC9 BC7 vd v12 Fi FC17{ m Fc FC5 FC13 Fl Fs FC3 FC13 Fl FC3 FU18{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1} Fp Fl Fi Fp FL:3} Fl Fp[6] FC11 Fi Fi} BC17 BC19{ BC20{ VBC9 BC11 BC4 VBC3 Fp Fp Fi Fl[2] Fp[3] Fp} BC11 BC17 BC15 BC4 vd Fl Fi} vd v1 Fi FC8 Fi Fc Fi[7] Fi FD Fi[9] Fi}


 S6087C22 ::~S6087C22(){ note_dtor("S6087C22", this);}
void  S6087C22 ::v16(){vfunc_called(this, "_ZN8S6087C223v16Ev");}
S6087C22 ::S6087C22(){ note_ctor("S6087C22", this);} // tgen

static void Test_S6087C22()
{
  extern Class_Descriptor cd_S6087C22;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1861,4618)];
    init_test(&cd_S6087C22, buf);
    S6087C22 *dp, &lv = *(dp=new (buf) S6087C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(29760,18468), "sizeof(S6087C22)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C22)");
    check_base_class_offset(lv, (S6087C11*)(S6087C23*), ABISELECT(17360,10772), "S6087C22");
    check_base_class_offset(lv, (S6087C11*)(S6087C16*)(S6087C24*), ABISELECT(17360,10772), "S6087C22");
    check_base_class_offset(lv, (S6087C20*)(S6087C23*), ABISELECT(15840,9820), "S6087C22");
    check_base_class_offset(lv, (S6087C23*), ABISELECT(15824,9816), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*), 0, "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(27376,16972), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(27504,17060), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(28016,17372), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(28016,17372), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(28016,17372), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(28016,17372), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(28016,17372), "S6087C22");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(28016,17372), "S6087C22");
    check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C16*)(S6087C24*), ABISELECT(28016,17372), "S6087C22");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C24*), ABISELECT(28016,17372), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C24*), ABISELECT(28016,17372), "S6087C22");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(28016,17372), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(27504,17060), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(28640,17780), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(28640,17780), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(28640,17780), "S6087C22");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(28640,17780), "S6087C22");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(28640,17780), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(28416,17632), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(29160,18096), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(29152,18092), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(29152,18092), "S6087C22");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(29152,18092), "S6087C22");
    check_base_class_offset(lv, (S6087C7*)(S6087C16*)(S6087C24*), ABISELECT(29152,18092), "S6087C22");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(29152,18092), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(28416,17632), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(28416,17632), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*)(S6087C24*), ABISELECT(28416,17632), "S6087C22");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C17*), ABISELECT(27376,16972), "S6087C22");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(27376,16972), "S6087C22");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(27376,16972), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(29344,18200), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(29344,18200), "S6087C22");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C17*), ABISELECT(29344,18200), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*)(S6087C17*), ABISELECT(29344,18200), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*)(S6087C24*), ABISELECT(29344,18200), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(17568,10908), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(17696,10996), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(17696,10996), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(17568,10908), "S6087C22");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(18208,11308), "S6087C22");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(18208,11308), "S6087C22");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(18208,11308), "S6087C22");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(18208,11308), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*)(S6087C17*), ABISELECT(29632,18380), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*)(S6087C24*), ABISELECT(29632,18380), "S6087C22");
    check_base_class_offset(lv, (S6087C18*)(S6087C17*), ABISELECT(17568,10908), "S6087C22");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C17*), ABISELECT(19896,12344), "S6087C22");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C17*), ABISELECT(19888,12340), "S6087C22");
    /*is_ambiguous_... S6087C17::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C17*), ABISELECT(20080,12448), "S6087C22");
    check_base_class_offset(lv, (S6087C17*), ABISELECT(17568,10908), "S6087C22");
    /*is_ambiguous_... S6087C22::S6087C19 */ AMB_check_base_class_offset(lv, (S6087C19*), ABISELECT(128,88), "S6087C22");
    check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C16*)(S6087C24*), ABISELECT(6032,3740), "S6087C22");
    check_base_class_offset(lv, (S6087C9*)(S6087C16*)(S6087C24*), ABISELECT(6032,3740), "S6087C22");
    /*is_ambiguous_... S6087C16::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C16*)(S6087C24*), ABISELECT(6544,4052), "S6087C22");
    check_base_class_offset(lv, (S6087C16*)(S6087C24*), ABISELECT(6032,3740), "S6087C22");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C24*), ABISELECT(6752,4176), "S6087C22");
    /*is_ambiguous_... S6087C24::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C24*), ABISELECT(6752,4176), "S6087C22");
    check_base_class_offset(lv, (S6087C19*)(S6087C24*), ABISELECT(7264,4488), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*)(S6087C24*), ABISELECT(13168,8140), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C24*), ABISELECT(13296,8228), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*)(S6087C24*), ABISELECT(13296,8228), "S6087C22");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*)(S6087C24*), ABISELECT(13168,8140), "S6087C22");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(13808,8540), "S6087C22");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(13808,8540), "S6087C22");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(13808,8540), "S6087C22");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*)(S6087C24*), ABISELECT(13808,8540), "S6087C22");
    check_base_class_offset(lv, (S6087C18*)(S6087C24*), ABISELECT(13168,8140), "S6087C22");
    /*is_ambiguous_... S6087C24::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C24*), ABISELECT(15488,9572), "S6087C22");
    check_base_class_offset(lv, (S6087C24*), ABISELECT(6032,3740), "S6087C22");
    check_field_offset(lv, s6087c22f0, ABISELECT(15628,9668), "S6087C22.s6087c22f0");
    check_field_offset(lv, s6087c22f1, ABISELECT(15632,9672), "S6087C22.s6087c22f1");
    check_field_offset(lv, s6087c22f2, ABISELECT(15720,9724), "S6087C22.s6087c22f2");
    check_field_offset(lv, s6087c22f3, ABISELECT(15724,9728), "S6087C22.s6087c22f3");
    check_field_offset(lv, s6087c22f4, ABISELECT(15728,9732), "S6087C22.s6087c22f4");
    check_field_offset(lv, s6087c22f5, ABISELECT(15756,9760), "S6087C22.s6087c22f5");
    check_field_offset(lv, s6087c22f6, ABISELECT(15760,9764), "S6087C22.s6087c22f6");
    check_field_offset(lv, s6087c22f7, ABISELECT(15776,9776), "S6087C22.s6087c22f7");
    check_field_offset(lv, s6087c22f8, ABISELECT(15812,9812), "S6087C22.s6087c22f8");
    test_class_info(&lv, &cd_S6087C22);
    dp->~S6087C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C22(Test_S6087C22, "S6087C22", ABISELECT(29760,18468));

#else // __cplusplus

extern void _ZN8S6087C22C1Ev();
extern void _ZN8S6087C22D2Ev();
Name_Map name_map_S6087C22[] = {
  NSPAIR(_ZN8S6087C22C1Ev),
  NSPAIR(_ZN8S6087C22D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C20;
extern VTBL_ENTRY _ZTI8S6087C20[];
extern Class_Descriptor cd_S6087C23;
extern VTBL_ENTRY _ZTI8S6087C23[];
extern  VTBL_ENTRY _ZTV8S6087C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C23[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C17;
extern VTBL_ENTRY _ZTI8S6087C17[];
extern  VTBL_ENTRY _ZTV8S6087C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C17[];
extern Class_Descriptor cd_S6087C19;
extern VTBL_ENTRY _ZTI8S6087C19[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C16;
extern VTBL_ENTRY _ZTI8S6087C16[];
extern  VTBL_ENTRY _ZTV8S6087C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C16[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C19;
extern VTBL_ENTRY _ZTI8S6087C19[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C24;
extern VTBL_ENTRY _ZTI8S6087C24[];
extern  VTBL_ENTRY _ZTV8S6087C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C24[];
static Base_Class bases_S6087C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C11,    ABISELECT(17360,10772), //bcp->offset
    81, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    59, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S6087C20,    ABISELECT(15840,9820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S6087C23,    ABISELECT(15824,9816), //bcp->offset
    75, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    58, //bcp->index_in_construction_vtbl_array
    78, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(27376,16972), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(27504,17060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(28016,17372), //bcp->offset
    161, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    63, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(27504,17060), //bcp->offset
    155, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    62, //bcp->index_in_construction_vtbl_array
    126, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(28640,17780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(28640,17780), //bcp->offset
    179, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    65, //bcp->index_in_construction_vtbl_array
    137, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(28416,17632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(29160,18096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(29152,18092), //bcp->offset
    188, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    66, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(28416,17632), //bcp->offset
    167, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    64, //bcp->index_in_construction_vtbl_array
    133, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S6087C13,    ABISELECT(27376,16972), //bcp->offset
    140, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    61, //bcp->index_in_construction_vtbl_array
    125, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(29344,18200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(29344,18200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    140, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(29344,18200), //bcp->offset
    193, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    67, //bcp->index_in_construction_vtbl_array
    139, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S6087C10,    ABISELECT(17568,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(17696,10996), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(17696,10996), //bcp->offset
    114, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    68, //bcp->index_in_construction_vtbl_array
    83, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(17568,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    82, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(18208,11308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(18208,11308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    92, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(18208,11308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    91, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(18208,11308), //bcp->offset
    120, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    69, //bcp->index_in_construction_vtbl_array
    90, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(29632,18380), //bcp->offset
    205, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    70, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S6087C18,    ABISELECT(17568,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(19896,12344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(19888,12340), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    71, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(20080,12448), //bcp->offset
    136, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    72, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S6087C17,    ABISELECT(17568,10908), //bcp->offset
    87, //bcp->virtual_function_table_offset
    21, //num_negative_vtable_entries(t, bcp)
    60, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C19,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(6032,3740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(6032,3740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(6544,4052), //bcp->offset
    31, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S6087C16,    ABISELECT(6032,3740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(6752,4176), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(6752,4176), //bcp->offset
    34, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    74, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S6087C19,    ABISELECT(7264,4488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(13168,8140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(13296,8228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(13296,8228), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    76, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(13168,8140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(13808,8540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(13808,8540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(13808,8540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(13808,8540), //bcp->offset
    60, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    77, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S6087C18,    ABISELECT(13168,8140), //bcp->offset
    40, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    75, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(15488,9572), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S6087C24,    ABISELECT(6032,3740), //bcp->offset
    16, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    73, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C22[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C22D1Ev();
extern void _ZN8S6087C22D0Ev();
extern void _ZN8S6087C223v16Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn6032_N8S6087C22D1Ev,_ZThn3740_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn6032_N8S6087C22D0Ev,_ZThn3740_N8S6087C22D0Ev)();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn13168_N8S6087C22D1Ev,_ZThn8140_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn13168_N8S6087C22D0Ev,_ZThn8140_N8S6087C22D0Ev)();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn13808_N8S6087C22D1Ev,_ZThn8540_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn13808_N8S6087C22D0Ev,_ZThn8540_N8S6087C22D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void _ZN8S6087C102v4Ev();
extern void ABISELECT(_ZTv0_n32_N8S6087C22D1Ev,_ZTv0_n16_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn15824_N8S6087C22D1Ev,_ZThn9816_N8S6087C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S6087C22D0Ev,_ZTv0_n16_N8S6087C22D0Ev)();
extern void ABISELECT(_ZThn15824_N8S6087C22D0Ev,_ZThn9816_N8S6087C22D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n96_N8S6087C22D1Ev,_ZTv0_n48_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn17568_N8S6087C22D1Ev,_ZThn10908_N8S6087C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S6087C22D0Ev,_ZTv0_n48_N8S6087C22D0Ev)();
extern void ABISELECT(_ZThn17568_N8S6087C22D0Ev,_ZThn10908_N8S6087C22D0Ev)() __attribute__((weak));
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTvn640_n96_N8S6087C22D1Ev,_ZTvn400_n48_N8S6087C22D1Ev)();
extern void ABISELECT(_ZTvn640_n96_N8S6087C22D0Ev,_ZTvn400_n48_N8S6087C22D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void ABISELECT(_ZTvn2320_n96_N8S6087C22D1Ev,_ZTvn1432_n48_N8S6087C22D1Ev)();
extern void ABISELECT(_ZTvn2320_n96_N8S6087C22D0Ev,_ZTvn1432_n48_N8S6087C22D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C22D1Ev,_ZTv0_n36_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn27376_N8S6087C22D1Ev,_ZThn16972_N8S6087C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C22D0Ev,_ZTv0_n36_N8S6087C22D0Ev)();
extern void ABISELECT(_ZThn27376_N8S6087C22D0Ev,_ZThn16972_N8S6087C22D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C22D1Ev,_ZTv0_n32_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn28416_N8S6087C22D1Ev,_ZThn17632_N8S6087C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C22D0Ev,_ZTv0_n32_N8S6087C22D0Ev)();
extern void ABISELECT(_ZThn28416_N8S6087C22D0Ev,_ZThn17632_N8S6087C22D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C22D1Ev,_ZTv0_n12_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn29152_N8S6087C22D1Ev,_ZThn18092_N8S6087C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C22D0Ev,_ZTv0_n12_N8S6087C22D0Ev)();
extern void ABISELECT(_ZThn29152_N8S6087C22D0Ev,_ZThn18092_N8S6087C22D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C22D1Ev,_ZTv0_n32_N8S6087C22D1Ev)();
extern void ABISELECT(_ZThn29344_N8S6087C22D1Ev,_ZThn18200_N8S6087C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C22D0Ev,_ZTv0_n32_N8S6087C22D0Ev)();
extern void ABISELECT(_ZThn29344_N8S6087C22D0Ev,_ZThn18200_N8S6087C22D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C22[] = {
  ABISELECT(29632,18380),
  ABISELECT(29344,18200),
  ABISELECT(29152,18092),
  ABISELECT(28640,17780),
  ABISELECT(28416,17632),
  ABISELECT(28016,17372),
  ABISELECT(27376,16972),
  ABISELECT(17568,10908),
  ABISELECT(17360,10772),
  ABISELECT(15824,9816),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C22D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C22D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C223v16Ev,
  ABISELECT(23600,14640),
  ABISELECT(23312,14460),
  ABISELECT(21344,13232),
  ABISELECT(22608,14040),
  ABISELECT(22384,13892),
  ABISELECT(11328,7032),
  ABISELECT(23120,14352),
  ABISELECT(21984,13632),
  ABISELECT(-6032,-3740),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn6032_N8S6087C22D1Ev,_ZThn3740_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6032_N8S6087C22D0Ev,_ZThn3740_N8S6087C22D0Ev),
  ABISELECT(-6544,-4052),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(21264,13196),
  ABISELECT(-6752,-4176),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(16464,10240),
  ABISELECT(16176,10060),
  ABISELECT(14208,8832),
  ABISELECT(15984,9952),
  ABISELECT(15472,9640),
  ABISELECT(15248,9492),
  ABISELECT(14848,9232),
  ABISELECT(-13168,-8140),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn13168_N8S6087C22D1Ev,_ZThn8140_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn13168_N8S6087C22D0Ev,_ZThn8140_N8S6087C22D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  ABISELECT(14720,9144),
  ABISELECT(-13296,-8228),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(14608,9092),
  ABISELECT(13568,8432),
  ABISELECT(15344,9552),
  ABISELECT(14832,9240),
  ABISELECT(14208,8832),
  ABISELECT(-13808,-8540),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn13808_N8S6087C22D1Ev,_ZThn8540_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn13808_N8S6087C22D0Ev,_ZThn8540_N8S6087C22D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-15488,-9572),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(-15824,-9816),
  ABISELECT(1536,956),
  ABISELECT(-15824,-9816),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S6087C22D1Ev,_ZTv0_n16_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S6087C22D0Ev,_ZTv0_n16_N8S6087C22D0Ev),
  0,
  0,
  ABISELECT(-17360,-10772),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  ABISELECT(2512,1540),
  ABISELECT(2512,1540),
  0,
  ABISELECT(640,400),
  ABISELECT(640,400),
  ABISELECT(640,400),
  0,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-17568,-10908),
  0,
  0,
  ABISELECT(12064,7472),
  ABISELECT(11776,7292),
  ABISELECT(9808,6064),
  ABISELECT(11584,7184),
  ABISELECT(11072,6872),
  ABISELECT(10848,6724),
  ABISELECT(10448,6464),
  ABISELECT(-17568,-10908),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S6087C22D1Ev,_ZTv0_n48_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S6087C22D0Ev,_ZTv0_n48_N8S6087C22D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
  ABISELECT(10320,6376),
  ABISELECT(-17696,-10996),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(10208,6324),
  ABISELECT(9168,5664),
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  ABISELECT(-18208,-11308),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn640_n96_N8S6087C22D1Ev,_ZTvn400_n48_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn640_n96_N8S6087C22D0Ev,_ZTvn400_n48_N8S6087C22D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-19888,-12340),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2320_n96_N8S6087C22D1Ev,_ZTvn1432_n48_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2320_n96_N8S6087C22D0Ev,_ZTvn1432_n48_N8S6087C22D0Ev),
  ABISELECT(-20080,-12448),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-27376,-16972),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-27376,-16972),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C22D1Ev,_ZTv0_n36_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C22D0Ev,_ZTv0_n36_N8S6087C22D0Ev),
  ABISELECT(512,312),
  ABISELECT(-27504,-17060),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  0,
  0,
  ABISELECT(-28016,-17372),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-28416,-17632),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-28416,-17632),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C22D1Ev,_ZTv0_n32_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C22D0Ev,_ZTv0_n32_N8S6087C22D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-28640,-17780),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-29152,-18092),
  ABISELECT(-29152,-18092),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C22D1Ev,_ZTv0_n12_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C22D0Ev,_ZTv0_n12_N8S6087C22D0Ev),
  ABISELECT(-29344,-18200),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  ABISELECT(-29344,-18200),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C22D1Ev,_ZTv0_n32_N8S6087C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C22D0Ev,_ZTv0_n32_N8S6087C22D0Ev),
  0,
  ABISELECT(-29632,-18380),
  (VTBL_ENTRY)&(_ZTI8S6087C22[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTV8S6087C22[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C24D1Ev();
extern void _ZN8S6087C24D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C24__8S6087C22[] = {
  ABISELECT(23600,14640),
  ABISELECT(23312,14460),
  ABISELECT(21344,13232),
  ABISELECT(22608,14040),
  ABISELECT(22384,13892),
  ABISELECT(11328,7032),
  ABISELECT(23120,14352),
  ABISELECT(21984,13632),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&_ZN8S6087C24D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C24D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C16D1Ev();
extern void _ZN8S6087C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C168S6087C24__8S6087C22[] = {
  ABISELECT(11328,7032),
  ABISELECT(23120,14352),
  ABISELECT(21984,13632),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C168S6087C24__A3__8S6087C22[] = {
  ABISELECT(21984,13632),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C168S6087C24__A3__8S6087C22[] = {
  0,
  0,
  ABISELECT(-21984,-13632),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev)();
extern void ABISELECT(_ZThn23120_N8S6087C16D1Ev,_ZThn14352_N8S6087C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev)();
extern void ABISELECT(_ZThn23120_N8S6087C16D0Ev,_ZThn14352_N8S6087C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C168S6087C24__8S6087C22[] = {
  ABISELECT(-23120,-14352),
  ABISELECT(-23120,-14352),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C168S6087C24__8S6087C22[] = {
  0,
  0,
  ABISELECT(-21984,-13632),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C11__8S6087C168S6087C24__8S6087C22[] = {
  0,
  0,
  ABISELECT(-11328,-7032),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C24__A4__8S6087C22[] = {
  ABISELECT(21264,13196),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C24__A4__8S6087C22[] = {
  0,
  0,
  ABISELECT(-21264,-13196),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(16464,10240),
  ABISELECT(16176,10060),
  ABISELECT(14208,8832),
  ABISELECT(15984,9952),
  ABISELECT(15472,9640),
  ABISELECT(15248,9492),
  ABISELECT(14848,9232),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C188S6087C24__A2__8S6087C22[] = {
  ABISELECT(15984,9952),
  ABISELECT(15472,9640),
  ABISELECT(15248,9492),
  ABISELECT(14848,9232),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C24__A5__8S6087C22[] = {
  ABISELECT(14720,9144),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C24__A5__8S6087C22[] = {
  0,
  0,
  ABISELECT(-14720,-9144),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C24__A2__8S6087C22[] = {
  ABISELECT(14720,9144),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C188S6087C24__A2__8S6087C22[] = {
  0,
  0,
  ABISELECT(-14848,-9232),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn15248_N8S6087C13D1Ev,_ZThn9492_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn15248_N8S6087C13D0Ev,_ZThn9492_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C188S6087C24__A2__8S6087C22[] = {
  ABISELECT(-15248,-9492),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-15248,-9492),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C24__A2__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-15472,-9640),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn15984_N8S6087C13D1Ev,_ZThn9952_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn15984_N8S6087C13D0Ev,_ZThn9952_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C188S6087C24__A2__8S6087C22[] = {
  ABISELECT(-15984,-9952),
  ABISELECT(-15984,-9952),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(14608,9092),
  ABISELECT(13568,8432),
  ABISELECT(15344,9552),
  ABISELECT(14832,9240),
  ABISELECT(14208,8832),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[] = {
  ABISELECT(15344,9552),
  ABISELECT(14832,9240),
  ABISELECT(14208,8832),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[] = {
  ABISELECT(15344,9552),
  ABISELECT(14832,9240),
  ABISELECT(14208,8832),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[] = {
  0,
  0,
  ABISELECT(-14208,-8832),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-14832,-9240),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn15344_N7S6087C5D1Ev,_ZThn9552_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn15344_N7S6087C5D0Ev,_ZThn9552_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[] = {
  ABISELECT(-15344,-9552),
  ABISELECT(-15344,-9552),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[] = {
  0,
  0,
  ABISELECT(-14208,-8832),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-14832,-9240),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn15344_N7S6087C4D1Ev,_ZThn9552_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn15344_N7S6087C4D0Ev,_ZThn9552_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[] = {
  ABISELECT(-15344,-9552),
  ABISELECT(-15344,-9552),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn13568_N8S6087C12D1Ev,_ZThn8432_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn13568_N8S6087C12D0Ev,_ZThn8432_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-13568,-8432),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-13568,-8432),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(512,312),
  ABISELECT(-13696,-8520),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C188S6087C24__A1__8S6087C22[] = {
  0,
  0,
  ABISELECT(-14208,-8832),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn14608_N8S6087C12D1Ev,_ZThn9092_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn14608_N8S6087C12D0Ev,_ZThn9092_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(-14608,-9092),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-14608,-9092),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C24__A1__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-14832,-9240),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn15344_N8S6087C12D1Ev,_ZThn9552_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn15344_N8S6087C12D0Ev,_ZThn9552_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(-15344,-9552),
  ABISELECT(-15344,-9552),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(14720,9144),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C188S6087C24__A1__8S6087C22[] = {
  0,
  0,
  ABISELECT(-14848,-9232),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn15248_N8S6087C18D1Ev,_ZThn9492_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn15248_N8S6087C18D0Ev,_ZThn9492_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(-15248,-9492),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-15248,-9492),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C188S6087C24__A1__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-15472,-9640),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn15984_N8S6087C18D1Ev,_ZThn9952_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn15984_N8S6087C18D0Ev,_ZThn9952_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(-15984,-9952),
  ABISELECT(-15984,-9952),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(14608,9092),
  ABISELECT(13568,8432),
  ABISELECT(15344,9552),
  ABISELECT(14832,9240),
  ABISELECT(14208,8832),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn14208_N8S6087C18D1Ev,_ZThn8832_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn14208_N8S6087C18D0Ev,_ZThn8832_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-14208,-8832),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-14208,-8832),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(512,312),
  ABISELECT(-14336,-8920),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn16176_N8S6087C18D1Ev,_ZThn10060_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn16176_N8S6087C18D0Ev,_ZThn10060_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C188S6087C24__A1__8S6087C22[] = {
  ABISELECT(-16176,-10060),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  ABISELECT(-16176,-10060),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C188S6087C24__A1__8S6087C22[] = {
  0,
  ABISELECT(-16464,-10240),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C24D1Ev,_ZTv0_n12_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn23120_N8S6087C24D1Ev,_ZThn14352_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C24D0Ev,_ZTv0_n12_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn23120_N8S6087C24D0Ev,_ZThn14352_N8S6087C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C24__8S6087C22[] = {
  ABISELECT(-23120,-14352),
  ABISELECT(-23120,-14352),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C24D1Ev,_ZTv0_n12_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C24D0Ev,_ZTv0_n12_N8S6087C24D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C24__8S6087C22[] = {
  0,
  0,
  ABISELECT(-21984,-13632),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C11__8S6087C24__8S6087C22[] = {
  0,
  0,
  ABISELECT(-11328,-7032),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C24__8S6087C22[] = {
  ABISELECT(21264,13196),
  ABISELECT(-720,-436),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn7136_N8S6087C24D1Ev,_ZThn4400_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn7136_N8S6087C24D0Ev,_ZThn4400_N8S6087C24D0Ev)();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C18__8S6087C24__8S6087C22[] = {
  ABISELECT(16464,10240),
  ABISELECT(16176,10060),
  ABISELECT(14208,8832),
  ABISELECT(15984,9952),
  ABISELECT(15472,9640),
  ABISELECT(15248,9492),
  ABISELECT(14848,9232),
  ABISELECT(-7136,-4400),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn7136_N8S6087C24D1Ev,_ZThn4400_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7136_N8S6087C24D0Ev,_ZThn4400_N8S6087C24D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C24__8S6087C22[] = {
  ABISELECT(14720,9144),
  ABISELECT(-7264,-4488),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn22384_N8S6087C24D1Ev,_ZThn13892_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn22384_N8S6087C24D0Ev,_ZThn13892_N8S6087C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C24__8S6087C22[] = {
  ABISELECT(-22384,-13892),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-22384,-13892),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A3__8S6087C24__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-22608,-14040),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn7776_N8S6087C24D1Ev,_ZThn4800_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn7776_N8S6087C24D0Ev,_ZThn4800_N8S6087C24D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C24__8S6087C22[] = {
  ABISELECT(14608,9092),
  ABISELECT(13568,8432),
  ABISELECT(15344,9552),
  ABISELECT(14832,9240),
  ABISELECT(14208,8832),
  ABISELECT(-7776,-4800),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn7776_N8S6087C24D1Ev,_ZThn4800_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7776_N8S6087C24D0Ev,_ZThn4800_N8S6087C24D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C24D1Ev,_ZTv0_n36_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn21344_N8S6087C24D1Ev,_ZThn13232_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C24D0Ev,_ZTv0_n36_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn21344_N8S6087C24D0Ev,_ZThn13232_N8S6087C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C24__8S6087C22[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-21344,-13232),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-21344,-13232),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C24D1Ev,_ZTv0_n36_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C24D0Ev,_ZTv0_n36_N8S6087C24D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A4__8S6087C24__8S6087C22[] = {
  ABISELECT(512,312),
  ABISELECT(-21472,-13320),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev)();
extern void ABISELECT(_ZThn23312_N8S6087C24D1Ev,_ZThn14460_N8S6087C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev)();
extern void ABISELECT(_ZThn23312_N8S6087C24D0Ev,_ZThn14460_N8S6087C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C24__8S6087C22[] = {
  ABISELECT(-23312,-14460),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  ABISELECT(-23312,-14460),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A8__8S6087C24__8S6087C22[] = {
  0,
  ABISELECT(-23600,-14640),
  (VTBL_ENTRY)&(_ZTI8S6087C24[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C23D1Ev();
extern void _ZN8S6087C23D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C23__8S6087C22[] = {
  ABISELECT(1536,956),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C23[0]),
  (VTBL_ENTRY)&_ZN8S6087C23D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C23D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C11__8S6087C23__8S6087C22[] = {
  0,
  0,
  ABISELECT(-1536,-956),
  (VTBL_ENTRY)&(_ZTI8S6087C23[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C17D1Ev();
extern void _ZN8S6087C17D0Ev();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C17__8S6087C22[] = {
  ABISELECT(12064,7472),
  ABISELECT(11776,7292),
  ABISELECT(9808,6064),
  ABISELECT(11584,7184),
  ABISELECT(11072,6872),
  ABISELECT(10848,6724),
  ABISELECT(10448,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(12064,7472),
  ABISELECT(11776,7292),
  ABISELECT(9808,6064),
  ABISELECT(11584,7184),
  ABISELECT(11072,6872),
  ABISELECT(10848,6724),
  ABISELECT(10448,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C188S6087C17__A1__8S6087C22[] = {
  ABISELECT(11584,7184),
  ABISELECT(11072,6872),
  ABISELECT(10848,6724),
  ABISELECT(10448,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C22[] = {
  ABISELECT(10320,6376),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C22[] = {
  0,
  0,
  ABISELECT(-10320,-6376),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C17__A1__8S6087C22[] = {
  ABISELECT(10320,6376),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C188S6087C17__A1__8S6087C22[] = {
  0,
  0,
  ABISELECT(-10448,-6464),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C13D1Ev,_ZThn6724_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C13D0Ev,_ZThn6724_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C188S6087C17__A1__8S6087C22[] = {
  ABISELECT(-10848,-6724),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10848,-6724),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C17__A1__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-11072,-6872),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C13D1Ev,_ZThn7184_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C13D0Ev,_ZThn7184_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C188S6087C17__A1__8S6087C22[] = {
  ABISELECT(-11584,-7184),
  ABISELECT(-11584,-7184),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(10208,6324),
  ABISELECT(9168,5664),
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[] = {
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[] = {
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[] = {
  0,
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10432,-6472),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C5D1Ev,_ZThn6784_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C5D0Ev,_ZThn6784_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[] = {
  ABISELECT(-10944,-6784),
  ABISELECT(-10944,-6784),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[] = {
  0,
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10432,-6472),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C4D1Ev,_ZThn6784_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn10944_N7S6087C4D0Ev,_ZThn6784_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[] = {
  ABISELECT(-10944,-6784),
  ABISELECT(-10944,-6784),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn9168_N8S6087C12D1Ev,_ZThn5664_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn9168_N8S6087C12D0Ev,_ZThn5664_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-9168,-5664),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-9168,-5664),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(512,312),
  ABISELECT(-9296,-5752),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C188S6087C17__8S6087C22[] = {
  0,
  0,
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn10208_N8S6087C12D1Ev,_ZThn6324_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn10208_N8S6087C12D0Ev,_ZThn6324_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(-10208,-6324),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10208,-6324),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C17__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10432,-6472),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn10944_N8S6087C12D1Ev,_ZThn6784_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn10944_N8S6087C12D0Ev,_ZThn6784_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(-10944,-6784),
  ABISELECT(-10944,-6784),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(10320,6376),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C188S6087C17__8S6087C22[] = {
  0,
  0,
  ABISELECT(-10448,-6464),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C18D1Ev,_ZThn6724_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C18D0Ev,_ZThn6724_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(-10848,-6724),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10848,-6724),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C188S6087C17__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-11072,-6872),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C18D1Ev,_ZThn7184_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C18D0Ev,_ZThn7184_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(-11584,-7184),
  ABISELECT(-11584,-7184),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(10208,6324),
  ABISELECT(9168,5664),
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C18D1Ev,_ZThn6064_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C18D0Ev,_ZThn6064_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-9808,-6064),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(512,312),
  ABISELECT(-9936,-6152),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C18D1Ev,_ZThn7292_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C18D0Ev,_ZThn7292_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C188S6087C17__8S6087C22[] = {
  ABISELECT(-11776,-7292),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  ABISELECT(-11776,-7292),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C188S6087C17__8S6087C22[] = {
  0,
  ABISELECT(-12064,-7472),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C17D1Ev,_ZThn6064_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn9808_N8S6087C17D0Ev,_ZThn6064_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C17__8S6087C22[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-9808,-6064),
  0,
  0,
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  ABISELECT(-9808,-6064),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C17__8S6087C22[] = {
  ABISELECT(512,312),
  ABISELECT(-9936,-6152),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C17__8S6087C22[] = {
  0,
  0,
  ABISELECT(-10448,-6464),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C17D1Ev,_ZThn6724_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn10848_N8S6087C17D0Ev,_ZThn6724_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C17__8S6087C22[] = {
  ABISELECT(-10848,-6724),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10848,-6724),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C17__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-11072,-6872),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C17D1Ev,_ZThn7184_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn11584_N8S6087C17D0Ev,_ZThn7184_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C17__8S6087C22[] = {
  ABISELECT(-11584,-7184),
  ABISELECT(-11584,-7184),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C17D1Ev,_ZThn7292_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn11776_N8S6087C17D0Ev,_ZThn7292_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C17__8S6087C22[] = {
  ABISELECT(-11776,-7292),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  ABISELECT(-11776,-7292),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17__8S6087C22[] = {
  ABISELECT(10320,6376),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C17__8S6087C22[] = {
  ABISELECT(10208,6324),
  ABISELECT(9168,5664),
  ABISELECT(10944,6784),
  ABISELECT(10432,6472),
  ABISELECT(9808,6064),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C17__8S6087C22[] = {
  0,
  ABISELECT(-12064,-7472),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C22[] = {
  ABISELECT(1776,1120),
  ABISELECT(1264,808),
  ABISELECT(1040,660),
  ABISELECT(640,400),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C22[] = {
  ABISELECT(512,312),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C22[] = {
  0,
  0,
  ABISELECT(-512,-312),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__8S6087C22[] = {
  ABISELECT(512,312),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__8S6087C22[] = {
  0,
  0,
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__8S6087C22[] = {
  ABISELECT(-1040,-660),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-1040,-660),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-1264,-808),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__8S6087C22[] = {
  ABISELECT(-1776,-1120),
  ABISELECT(-1776,-1120),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C22[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C22[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C22[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C22[] = {
  ABISELECT(-624,-408),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C22[] = {
  0,
  0,
  ABISELECT(624,408),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C22[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__A1__8S6087C22[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1328,-828),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C22[] = {
  0,
  0,
  ABISELECT(1328,828),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C22[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__8S6087C22[] = {
  0,
  0,
  ABISELECT(1328,828),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__8S6087C22[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__8S6087C22[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
static  VTT_ENTRY vtt_S6087C22[] = {
  {&(_ZTV8S6087C22[12]),  12,209},
  {&(_tg__ZTV8S6087C24__8S6087C22[10]),  10,15},
  {&(_tg__ZTV8S6087C168S6087C24__8S6087C22[5]),  5,10},
  {&(_tg__ZTV7S6087C98S6087C168S6087C24__A3__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C168S6087C24__A3__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C7__8S6087C168S6087C24__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C6__8S6087C168S6087C24__8S6087C22[4]),  4,6},
  {&(_tg__ZTV8S6087C11__8S6087C168S6087C24__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C98S6087C24__A4__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C24__A4__8S6087C22[4]),  4,6},
  {&(_tg__ZTV8S6087C188S6087C24__A1__8S6087C22[9]),  9,14},
  {&(_tg__ZTV8S6087C138S6087C188S6087C24__A2__8S6087C22[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C188S6087C24__A5__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C24__A5__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C24__A2__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C188S6087C24__A2__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C188S6087C24__A2__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C24__A2__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C188S6087C24__A2__8S6087C22[3]),  3,5},
  {&(_tg__ZTV8S6087C128S6087C188S6087C24__A1__8S6087C22[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C24__A3__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C24__A2__8S6087C22[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C128S6087C188S6087C24__A1__8S6087C22[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C24__A1__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C128S6087C188S6087C24__A1__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C128S6087C188S6087C24__A1__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C24__A1__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C128S6087C188S6087C24__A1__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C188S6087C24__A1__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C188S6087C24__A1__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C188S6087C24__A1__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C188S6087C24__A1__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C188S6087C24__A1__8S6087C22[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C188S6087C24__A1__8S6087C22[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C188S6087C24__A1__8S6087C22[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C24__A1__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C188S6087C24__A1__8S6087C22[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C188S6087C24__A1__8S6087C22[3]),  3,4},
  {&(_tg__ZTV7S6087C7__8S6087C24__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C6__8S6087C24__8S6087C22[4]),  4,6},
  {&(_tg__ZTV8S6087C11__8S6087C24__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C24__8S6087C22[3]),  3,6},
  {&(_tg__ZTV8S6087C18__8S6087C24__8S6087C22[9]),  9,14},
  {&(_tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C24__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C5__8S6087C24__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A3__8S6087C24__8S6087C22[6]),  6,9},
  {&(_tg__ZTV8S6087C128S6087C18__8S6087C24__8S6087C22[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C24__8S6087C22[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A4__8S6087C24__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C24__8S6087C22[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A8__8S6087C24__8S6087C22[3]),  3,4},
  {&(_ZTV8S6087C22[79]),  79,209},
  {&(_ZTV8S6087C22[85]),  85,209},
  {&(_ZTV8S6087C22[108]),  108,209},
  {&(_ZTV8S6087C22[151]),  151,209},
  {&(_ZTV8S6087C22[158]),  158,209},
  {&(_ZTV8S6087C22[165]),  165,209},
  {&(_ZTV8S6087C22[175]),  175,209},
  {&(_ZTV8S6087C22[185]),  185,209},
  {&(_ZTV8S6087C22[191]),  191,209},
  {&(_ZTV8S6087C22[201]),  201,209},
  {&(_ZTV8S6087C22[117]),  117,209},
  {&(_ZTV8S6087C22[127]),  127,209},
  {&(_ZTV8S6087C22[208]),  208,209},
  {&(_ZTV8S6087C22[134]),  134,209},
  {&(_ZTV8S6087C22[138]),  138,209},
  {&(_ZTV8S6087C22[26]),  26,209},
  {&(_ZTV8S6087C22[37]),  37,209},
  {&(_ZTV8S6087C22[49]),  49,209},
  {&(_ZTV8S6087C22[57]),  57,209},
  {&(_ZTV8S6087C22[67]),  67,209},
  {&(_tg__ZTV8S6087C23__8S6087C22[3]),  3,5},
  {&(_tg__ZTV8S6087C11__8S6087C23__8S6087C22[4]),  4,6},
  {&(_tg__ZTV8S6087C17__8S6087C22[9]),  9,15},
  {&(_tg__ZTV8S6087C188S6087C17__8S6087C22[9]),  9,14},
  {&(_tg__ZTV8S6087C138S6087C188S6087C17__A1__8S6087C22[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C17__A1__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C188S6087C17__A1__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C188S6087C17__A1__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C17__A1__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C188S6087C17__A1__8S6087C22[3]),  3,5},
  {&(_tg__ZTV8S6087C128S6087C188S6087C17__8S6087C22[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C22[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C128S6087C188S6087C17__8S6087C22[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C17__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C128S6087C188S6087C17__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C128S6087C188S6087C17__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C17__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C128S6087C188S6087C17__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C188S6087C17__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C188S6087C17__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C188S6087C17__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C188S6087C17__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C188S6087C17__8S6087C22[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C188S6087C17__8S6087C22[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C188S6087C17__8S6087C22[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C17__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C188S6087C17__8S6087C22[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C188S6087C17__8S6087C22[3]),  3,4},
  {&(_tg__ZTV8S6087C13__8S6087C17__8S6087C22[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C17__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C17__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C17__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C17__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C17__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C4__8S6087C17__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17__8S6087C22[3]),  3,6},
  {&(_tg__ZTV8S6087C128S6087C18__8S6087C17__8S6087C22[7]),  7,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C17__8S6087C22[3]),  3,4},
  {&(_tg__ZTV8S6087C13__8S6087C22[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__8S6087C22[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C5__8S6087C22[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C22[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C4__8S6087C22[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__A1__8S6087C22[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C22[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__8S6087C22[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__8S6087C22[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__8S6087C22[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S6087C22[];
extern  VTBL_ENTRY _ZTV8S6087C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C22[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C17D0Ev,_ZThn7184_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C17D1Ev,_ZThn7184_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C17D0Ev,_ZThn7292_N8S6087C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C17D0Ev,_ZThn6724_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C17D1Ev,_ZThn7292_N8S6087C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C17D1Ev,_ZThn6724_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C17D0Ev,_ZThn6064_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C17D1Ev,_ZThn6064_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C24D0Ev,_ZTv0_n36_N8S6087C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21344_N8S6087C24D0Ev,_ZThn13232_N8S6087C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C24D1Ev,_ZTv0_n36_N8S6087C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21344_N8S6087C24D1Ev,_ZThn13232_N8S6087C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C24D0Ev,_ZTv0_n32_N8S6087C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23312_N8S6087C24D0Ev,_ZThn14460_N8S6087C24D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22384_N8S6087C24D0Ev,_ZThn13892_N8S6087C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C24D1Ev,_ZTv0_n32_N8S6087C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23312_N8S6087C24D1Ev,_ZThn14460_N8S6087C24D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22384_N8S6087C24D1Ev,_ZThn13892_N8S6087C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C24D0Ev,_ZTv0_n12_N8S6087C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23120_N8S6087C24D0Ev,_ZThn14352_N8S6087C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C24D1Ev,_ZTv0_n12_N8S6087C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23120_N8S6087C24D1Ev,_ZThn14352_N8S6087C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C18D0Ev,_ZThn6064_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14208_N8S6087C18D0Ev,_ZThn8832_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9808_N8S6087C18D1Ev,_ZThn6064_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14208_N8S6087C18D1Ev,_ZThn8832_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C18D0Ev,_ZThn7184_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15984_N8S6087C18D0Ev,_ZThn9952_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C18D1Ev,_ZThn7184_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15984_N8S6087C18D1Ev,_ZThn9952_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C18D0Ev,_ZThn7292_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C18D0Ev,_ZThn6724_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16176_N8S6087C18D0Ev,_ZThn10060_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15248_N8S6087C18D0Ev,_ZThn9492_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S6087C18D1Ev,_ZThn7292_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C18D1Ev,_ZThn6724_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16176_N8S6087C18D1Ev,_ZThn10060_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15248_N8S6087C18D1Ev,_ZThn9492_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N8S6087C12D0Ev,_ZThn6784_N8S6087C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15344_N8S6087C12D0Ev,_ZThn9552_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N8S6087C12D1Ev,_ZThn6784_N8S6087C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15344_N8S6087C12D1Ev,_ZThn9552_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10208_N8S6087C12D0Ev,_ZThn6324_N8S6087C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14608_N8S6087C12D0Ev,_ZThn9092_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10208_N8S6087C12D1Ev,_ZThn6324_N8S6087C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14608_N8S6087C12D1Ev,_ZThn9092_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9168_N8S6087C12D0Ev,_ZThn5664_N8S6087C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn13568_N8S6087C12D0Ev,_ZThn8432_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9168_N8S6087C12D1Ev,_ZThn5664_N8S6087C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn13568_N8S6087C12D1Ev,_ZThn8432_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C4D0Ev,_ZThn6784_N7S6087C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15344_N7S6087C4D0Ev,_ZThn9552_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C4D1Ev,_ZThn6784_N7S6087C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15344_N7S6087C4D1Ev,_ZThn9552_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C5D0Ev,_ZThn6784_N7S6087C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15344_N7S6087C5D0Ev,_ZThn9552_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10944_N7S6087C5D1Ev,_ZThn6784_N7S6087C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15344_N7S6087C5D1Ev,_ZThn9552_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D0Ev,_ZThn1120_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C13D0Ev,_ZThn7184_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15984_N8S6087C13D0Ev,_ZThn9952_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1776_N8S6087C13D1Ev,_ZThn1120_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11584_N8S6087C13D1Ev,_ZThn7184_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15984_N8S6087C13D1Ev,_ZThn9952_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D0Ev,_ZThn660_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C13D0Ev,_ZThn6724_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15248_N8S6087C13D0Ev,_ZThn9492_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S6087C13D1Ev,_ZThn660_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10848_N8S6087C13D1Ev,_ZThn6724_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15248_N8S6087C13D1Ev,_ZThn9492_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23120_N8S6087C16D0Ev,_ZThn14352_N8S6087C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23120_N8S6087C16D1Ev,_ZThn14352_N8S6087C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C22D0Ev,_ZTv0_n12_N8S6087C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn29152_N8S6087C22D0Ev,_ZThn18092_N8S6087C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C22D1Ev,_ZTv0_n12_N8S6087C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn29152_N8S6087C22D1Ev,_ZThn18092_N8S6087C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C22D0Ev,_ZTv0_n32_N8S6087C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn29344_N8S6087C22D0Ev,_ZThn18200_N8S6087C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn28416_N8S6087C22D0Ev,_ZThn17632_N8S6087C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C22D1Ev,_ZTv0_n32_N8S6087C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn29344_N8S6087C22D1Ev,_ZThn18200_N8S6087C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn28416_N8S6087C22D1Ev,_ZThn17632_N8S6087C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C22D0Ev,_ZTv0_n36_N8S6087C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn27376_N8S6087C22D0Ev,_ZThn16972_N8S6087C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C22D1Ev,_ZTv0_n36_N8S6087C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn27376_N8S6087C22D1Ev,_ZThn16972_N8S6087C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S6087C22D0Ev,_ZTv0_n48_N8S6087C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17568_N8S6087C22D0Ev,_ZThn10908_N8S6087C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S6087C22D1Ev,_ZTv0_n48_N8S6087C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17568_N8S6087C22D1Ev,_ZThn10908_N8S6087C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S6087C22D0Ev,_ZTv0_n16_N8S6087C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15824_N8S6087C22D0Ev,_ZThn9816_N8S6087C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S6087C22D1Ev,_ZTv0_n16_N8S6087C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15824_N8S6087C22D1Ev,_ZThn9816_N8S6087C22D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C22 = {  "S6087C22", // class name
  bases_S6087C22, 51,
  &(vtc_S6087C22[0]), // expected_vtbl_contents
  &(vtt_S6087C22[0]), // expected_vtt_contents
  ABISELECT(29760,18468), // object size
  NSPAIRA(_ZTI8S6087C22),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S6087C22),209, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C22),146, //virtual table table var
  46, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C27  : S6087C2_nt , virtual S6087C19 {
  int s6087c27f0;
  long s6087c27f1[2];
  int s6087c27f2;
  long s6087c27f3;
  void *s6087c27f4;
  char s6087c27f5;
  ~S6087C27(); // tgen
  S6087C27(); // tgen
};
//SIG(-1 S6087C27) C1{ BC2{ m Fs Fi[2] Fl[8] Fi Fs} VBC3{ m Fc FC4{ m Fp[11] FC5{ VBC6{ v1 v2 Fp FD Fi FC2 Fs[6] Fc FC7{ BC2 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU8{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC9{ BC10{ v3 Fi:30 Fp Fi Fi[8] FL Fi FD Fc:3 Fp Fl Fl} VBC6 v4 v5 Fi FC7 Fi FC7} BC11{ v6 v7 Fp FC10 Fi Fp FD Fp FL Fc[6]} VBC7 Fl Fl Fc Fc:3} Fi} FC12{ BC10 BC9 VBC5 v8} Fl Fs FC11 FC12 Fl FC11 FU13{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1} Fp Fl Fi Fp FL:3} Fi Fl[2] Fi Fl Fp Fc}


S6087C27 ::~S6087C27(){ note_dtor("S6087C27", this);} // tgen
S6087C27 ::S6087C27(){ note_ctor("S6087C27", this);} // tgen

static void Test_S6087C27()
{
  extern Class_Descriptor cd_S6087C27;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(380,935)];
    init_test(&cd_S6087C27, buf);
    S6087C27 *dp, &lv = *(dp=new (buf) S6087C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6064,3736), "sizeof(S6087C27)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C27)");
    check_base_class_offset(lv, (S6087C2_nt*), ABISELECT(8,4), "S6087C27");
    check_base_class_offset(lv, (S6087C19*), ABISELECT(160,84), "S6087C27");
    check_field_offset(lv, s6087c27f0, ABISELECT(96,56), "S6087C27.s6087c27f0");
    check_field_offset(lv, s6087c27f1, ABISELECT(104,60), "S6087C27.s6087c27f1");
    check_field_offset(lv, s6087c27f2, ABISELECT(120,68), "S6087C27.s6087c27f2");
    check_field_offset(lv, s6087c27f3, ABISELECT(128,72), "S6087C27.s6087c27f3");
    check_field_offset(lv, s6087c27f4, ABISELECT(136,76), "S6087C27.s6087c27f4");
    check_field_offset(lv, s6087c27f5, ABISELECT(144,80), "S6087C27.s6087c27f5");
    test_class_info(&lv, &cd_S6087C27);
    dp->~S6087C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C27(Test_S6087C27, "S6087C27", ABISELECT(6064,3736));

#else // __cplusplus

extern void _ZN8S6087C27C1Ev();
extern void _ZN8S6087C27D1Ev();
Name_Map name_map_S6087C27[] = {
  NSPAIR(_ZN8S6087C27C1Ev),
  NSPAIR(_ZN8S6087C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C19;
extern VTBL_ENTRY _ZTI8S6087C19[];
static Base_Class bases_S6087C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C2_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C19,    ABISELECT(160,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C27[];
static  VTBL_ENTRY vtc_S6087C27[] = {
  ABISELECT(160,84),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C27[0]),
};
extern VTBL_ENTRY _ZTV8S6087C27[];
static  VTT_ENTRY vtt_S6087C27[] = {
  {&(_ZTV8S6087C27[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S6087C27[];
extern  VTBL_ENTRY _ZTV8S6087C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C27[];
Class_Descriptor cd_S6087C27 = {  "S6087C27", // class name
  bases_S6087C27, 2,
  &(vtc_S6087C27[0]), // expected_vtbl_contents
  &(vtt_S6087C27[0]), // expected_vtt_contents
  ABISELECT(6064,3736), // object size
  NSPAIRA(_ZTI8S6087C27),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S6087C27),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C27),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C28  : S6087C27 , virtual S6087C6 , S6087C17 , virtual S6087C2_nt {
  char s6087c28f0;
  long s6087c28f1[3];
  int s6087c28f2;
  virtual  ~S6087C28(); // _ZN8S6087C28D2Ev
  virtual void  v17(); // _ZN8S6087C283v17Ev
  S6087C28(); // tgen
};
//SIG(-1 S6087C28) C1{ BC2{ BC3{ m Fs Fi[2] Fl[8] Fi Fs} VBC4{ m Fc FC5{ m Fp[11] FC6{ VBC7{ v2 v3 Fp FD Fi FC3 Fs[6] Fc FC8{ BC3 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU9{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} VBC10{ BC11{ v4 Fi:30 Fp Fi Fi[8] FL Fi FD Fc:3 Fp Fl Fl} VBC7 v5 v6 Fi FC8 Fi FC8} BC12{ v7 v8 Fp FC11 Fi Fp FD Fp FL Fc[6]} VBC8 Fl Fl Fc Fc:3} Fi} FC13{ BC11 BC10 VBC6 v9} Fl Fs FC12 FC13 Fl FC12 FU14{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1} Fp Fl Fi Fp FL:3} Fi Fl[2] Fi Fl Fp Fc} VBC7 BC15{ VBC13 VBC16{ BC6 Fl Fi Fp FD Fi Fi} BC17{ BC13 BC18{ VBC13 BC16 vd v10 Fi FC8} VBC16 VBC11 v11 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC10 Fp FC11 Fi Fp} BC8 BC7 vd v12 Fi FC4 Fl Fp[6] FC10 Fi Fi} VBC3 vd v1 Fc Fl[3] Fi}


 S6087C28 ::~S6087C28(){ note_dtor("S6087C28", this);}
void  S6087C28 ::v17(){vfunc_called(this, "_ZN8S6087C283v17Ev");}
S6087C28 ::S6087C28(){ note_ctor("S6087C28", this);} // tgen

static void Test_S6087C28()
{
  extern Class_Descriptor cd_S6087C28;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1150,2843)];
    init_test(&cd_S6087C28, buf);
    S6087C28 *dp, &lv = *(dp=new (buf) S6087C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(18384,11368), "sizeof(S6087C28)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C28)");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C27*), ABISELECT(8,4), "S6087C28");
    check_base_class_offset(lv, (S6087C19*)(S6087C27*), ABISELECT(10000,6168), "S6087C28");
    check_base_class_offset(lv, (S6087C27*), 0, "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*), ABISELECT(15904,9820), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(15904,9820), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(15904,9820), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(15904,9820), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(15904,9820), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(15904,9820), "S6087C28");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(15904,9820), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(16304,10080), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(16432,10168), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(16432,10168), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(17168,10628), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(17168,10628), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(17168,10628), "S6087C28");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(17168,10628), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(16944,10480), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(17688,10944), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(17680,10940), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(17680,10940), "S6087C28");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(17680,10940), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(16944,10480), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(16944,10480), "S6087C28");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C17*), ABISELECT(16304,10080), "S6087C28");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(16304,10080), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(17872,11048), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(17872,11048), "S6087C28");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C17*), ABISELECT(17872,11048), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*)(S6087C17*), ABISELECT(17872,11048), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(160,84), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(288,172), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(288,172), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*)(S6087C17*), ABISELECT(160,84), "S6087C28");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(800,484), "S6087C28");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(800,484), "S6087C28");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(800,484), "S6087C28");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*)(S6087C17*), ABISELECT(800,484), "S6087C28");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*)(S6087C17*), ABISELECT(18160,11228), "S6087C28");
    check_base_class_offset(lv, (S6087C18*)(S6087C17*), ABISELECT(160,84), "S6087C28");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C17*), ABISELECT(2488,1520), "S6087C28");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C17*), ABISELECT(2480,1516), "S6087C28");
    /*is_ambiguous_... S6087C17::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C17*), ABISELECT(2672,1624), "S6087C28");
    check_base_class_offset(lv, (S6087C17*), ABISELECT(160,84), "S6087C28");
    /*is_ambiguous_... S6087C28::S6087C2_nt */ AMB_check_base_class_offset(lv, (S6087C2_nt*), ABISELECT(18288,11316), "S6087C28");
    check_field_offset(lv, s6087c28f0, ABISELECT(9960,6148), "S6087C28.s6087c28f0");
    check_field_offset(lv, s6087c28f1, ABISELECT(9968,6152), "S6087C28.s6087c28f1");
    check_field_offset(lv, s6087c28f2, ABISELECT(9992,6164), "S6087C28.s6087c28f2");
    test_class_info(&lv, &cd_S6087C28);
    dp->~S6087C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C28(Test_S6087C28, "S6087C28", ABISELECT(18384,11368));

#else // __cplusplus

extern void _ZN8S6087C28C1Ev();
extern void _ZN8S6087C28D2Ev();
Name_Map name_map_S6087C28[] = {
  NSPAIR(_ZN8S6087C28C1Ev),
  NSPAIR(_ZN8S6087C28D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C19;
extern VTBL_ENTRY _ZTI8S6087C19[];
extern Class_Descriptor cd_S6087C27;
extern VTBL_ENTRY _ZTI8S6087C27[];
extern  VTBL_ENTRY _ZTV8S6087C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C27[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C17;
extern VTBL_ENTRY _ZTI8S6087C17[];
extern  VTBL_ENTRY _ZTV8S6087C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C17[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
static Base_Class bases_S6087C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C2_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S6087C19,    ABISELECT(10000,6168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S6087C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C6,    ABISELECT(15904,9820), //bcp->offset
    55, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    ABISELECT(16304,10080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(16432,10168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(16432,10168), //bcp->offset
    76, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(17168,10628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(17168,10628), //bcp->offset
    94, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(16944,10480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(17688,10944), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(17680,10940), //bcp->offset
    103, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(16944,10480), //bcp->offset
    82, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S6087C13,    ABISELECT(16304,10080), //bcp->offset
    61, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(17872,11048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(17872,11048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    74, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(17872,11048), //bcp->offset
    108, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S6087C10,    ABISELECT(160,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(288,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(288,172), //bcp->offset
    29, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    56, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(160,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(800,484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(800,484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(800,484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(800,484), //bcp->offset
    35, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    57, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(18160,11228), //bcp->offset
    120, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    58, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S6087C18,    ABISELECT(160,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(2488,1520), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(2480,1516), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(2672,1624), //bcp->offset
    51, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S6087C17,    ABISELECT(160,84), //bcp->offset
    14, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C2_nt,    ABISELECT(18288,11316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C28[];
extern void _ZN8S6087C28D1Ev();
extern void _ZN8S6087C28D0Ev();
extern void _ZN8S6087C283v17Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn160_N8S6087C28D1Ev,_ZThn84_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn160_N8S6087C28D0Ev,_ZThn84_N8S6087C28D0Ev)();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn800_N8S6087C28D1Ev,_ZThn484_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn800_N8S6087C28D0Ev,_ZThn484_N8S6087C28D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void ABISELECT(_ZThn2480_N8S6087C28D1Ev,_ZThn1516_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn2480_N8S6087C28D0Ev,_ZThn1516_N8S6087C28D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn16304_N8S6087C28D1Ev,_ZThn10080_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn16304_N8S6087C28D0Ev,_ZThn10080_N8S6087C28D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn16944_N8S6087C28D1Ev,_ZThn10480_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn16944_N8S6087C28D0Ev,_ZThn10480_N8S6087C28D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn17680_N8S6087C28D1Ev,_ZThn10940_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn17680_N8S6087C28D0Ev,_ZThn10940_N8S6087C28D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn17872_N8S6087C28D1Ev,_ZThn11048_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn17872_N8S6087C28D0Ev,_ZThn11048_N8S6087C28D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C28[] = {
  ABISELECT(18288,11316),
  ABISELECT(18160,11228),
  ABISELECT(17872,11048),
  ABISELECT(17680,10940),
  ABISELECT(17168,10628),
  ABISELECT(16944,10480),
  ABISELECT(16304,10080),
  ABISELECT(15904,9820),
  ABISELECT(10000,6168),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C28D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C28D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C283v17Ev,
  ABISELECT(18000,11144),
  ABISELECT(17712,10964),
  ABISELECT(16144,9996),
  ABISELECT(17520,10856),
  ABISELECT(17008,10544),
  ABISELECT(16784,10396),
  ABISELECT(15744,9736),
  ABISELECT(-160,-84),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S6087C28D1Ev,_ZThn84_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S6087C28D0Ev,_ZThn84_N8S6087C28D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
  ABISELECT(15616,9648),
  ABISELECT(-288,-172),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(16144,9996),
  ABISELECT(15504,9596),
  ABISELECT(16880,10456),
  ABISELECT(16368,10144),
  ABISELECT(15104,9336),
  ABISELECT(-800,-484),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N8S6087C28D1Ev,_ZThn484_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N8S6087C28D0Ev,_ZThn484_N8S6087C28D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-2480,-1516),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2480_N8S6087C28D1Ev,_ZThn1516_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2480_N8S6087C28D0Ev,_ZThn1516_N8S6087C28D0Ev),
  ABISELECT(-2672,-1624),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  0,
  ABISELECT(-15904,-9820),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-16304,-10080),
  0,
  0,
  ABISELECT(1376,860),
  ABISELECT(864,548),
  ABISELECT(640,400),
  ABISELECT(-400,-260),
  ABISELECT(-16304,-10080),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev),
  ABISELECT(-528,-348),
  ABISELECT(-16432,-10168),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-16944,-10480),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-1040,-660),
  ABISELECT(-16944,-10480),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev),
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-17168,-10628),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-17680,-10940),
  ABISELECT(-17680,-10940),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev),
  ABISELECT(-17872,-11048),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1968,-1228),
  ABISELECT(-17872,-11048),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev),
  0,
  ABISELECT(-18160,-11228),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTV8S6087C28[];
static  VTBL_ENTRY _tg__ZTV8S6087C27__8S6087C28[] = {
  ABISELECT(10000,6168),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C27[0]),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C17D1Ev();
extern void _ZN8S6087C17D0Ev();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C17__8S6087C28[] = {
  ABISELECT(18000,11144),
  ABISELECT(17712,10964),
  ABISELECT(16144,9996),
  ABISELECT(17520,10856),
  ABISELECT(17008,10544),
  ABISELECT(16784,10396),
  ABISELECT(15744,9736),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(18000,11144),
  ABISELECT(17712,10964),
  ABISELECT(16144,9996),
  ABISELECT(17520,10856),
  ABISELECT(17008,10544),
  ABISELECT(16784,10396),
  ABISELECT(15744,9736),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C188S6087C17__A1__8S6087C28[] = {
  ABISELECT(17520,10856),
  ABISELECT(17008,10544),
  ABISELECT(16784,10396),
  ABISELECT(15744,9736),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C28[] = {
  ABISELECT(15616,9648),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C28[] = {
  0,
  0,
  ABISELECT(-15616,-9648),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C17__A1__8S6087C28[] = {
  ABISELECT(15616,9648),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C188S6087C17__A1__8S6087C28[] = {
  0,
  0,
  ABISELECT(-15744,-9736),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn16784_N8S6087C13D1Ev,_ZThn10396_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn16784_N8S6087C13D0Ev,_ZThn10396_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C188S6087C17__A1__8S6087C28[] = {
  ABISELECT(-16784,-10396),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-1040,-660),
  ABISELECT(-16784,-10396),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C17__A1__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-17008,-10544),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn17520_N8S6087C13D1Ev,_ZThn10856_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn17520_N8S6087C13D0Ev,_ZThn10856_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C188S6087C17__A1__8S6087C28[] = {
  ABISELECT(-17520,-10856),
  ABISELECT(-17520,-10856),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(16144,9996),
  ABISELECT(15504,9596),
  ABISELECT(16880,10456),
  ABISELECT(16368,10144),
  ABISELECT(15104,9336),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[] = {
  ABISELECT(16880,10456),
  ABISELECT(16368,10144),
  ABISELECT(15104,9336),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[] = {
  ABISELECT(16880,10456),
  ABISELECT(16368,10144),
  ABISELECT(15104,9336),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[] = {
  0,
  0,
  ABISELECT(-15104,-9336),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-16368,-10144),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn16880_N7S6087C5D1Ev,_ZThn10456_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn16880_N7S6087C5D0Ev,_ZThn10456_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[] = {
  ABISELECT(-16880,-10456),
  ABISELECT(-16880,-10456),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[] = {
  0,
  0,
  ABISELECT(-15104,-9336),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-16368,-10144),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn16880_N7S6087C4D1Ev,_ZThn10456_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn16880_N7S6087C4D0Ev,_ZThn10456_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[] = {
  ABISELECT(-16880,-10456),
  ABISELECT(-16880,-10456),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn15504_N8S6087C12D1Ev,_ZThn9596_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn15504_N8S6087C12D0Ev,_ZThn9596_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-15504,-9596),
  0,
  0,
  ABISELECT(1376,860),
  ABISELECT(864,548),
  ABISELECT(640,400),
  ABISELECT(-400,-260),
  ABISELECT(-15504,-9596),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(-528,-348),
  ABISELECT(-15632,-9684),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C188S6087C17__8S6087C28[] = {
  0,
  0,
  ABISELECT(-15104,-9336),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn16144_N8S6087C12D1Ev,_ZThn9996_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn16144_N8S6087C12D0Ev,_ZThn9996_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(-16144,-9996),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-1040,-660),
  ABISELECT(-16144,-9996),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C17__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-16368,-10144),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn16880_N8S6087C12D1Ev,_ZThn10456_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn16880_N8S6087C12D0Ev,_ZThn10456_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(-16880,-10456),
  ABISELECT(-16880,-10456),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(15616,9648),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C188S6087C17__8S6087C28[] = {
  0,
  0,
  ABISELECT(-15744,-9736),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn16784_N8S6087C18D1Ev,_ZThn10396_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn16784_N8S6087C18D0Ev,_ZThn10396_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(-16784,-10396),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-1040,-660),
  ABISELECT(-16784,-10396),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C188S6087C17__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-17008,-10544),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn17520_N8S6087C18D1Ev,_ZThn10856_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn17520_N8S6087C18D0Ev,_ZThn10856_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(-17520,-10856),
  ABISELECT(-17520,-10856),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(16144,9996),
  ABISELECT(15504,9596),
  ABISELECT(16880,10456),
  ABISELECT(16368,10144),
  ABISELECT(15104,9336),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn16144_N8S6087C18D1Ev,_ZThn9996_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn16144_N8S6087C18D0Ev,_ZThn9996_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-16144,-9996),
  0,
  0,
  ABISELECT(1376,860),
  ABISELECT(864,548),
  ABISELECT(640,400),
  ABISELECT(-400,-260),
  ABISELECT(-16144,-9996),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(-528,-348),
  ABISELECT(-16272,-10084),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn17712_N8S6087C18D1Ev,_ZThn10964_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn17712_N8S6087C18D0Ev,_ZThn10964_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C188S6087C17__8S6087C28[] = {
  ABISELECT(-17712,-10964),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1968,-1228),
  ABISELECT(-17712,-10964),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C188S6087C17__8S6087C28[] = {
  0,
  ABISELECT(-18000,-11144),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn16144_N8S6087C17D1Ev,_ZThn9996_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn16144_N8S6087C17D0Ev,_ZThn9996_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C17__8S6087C28[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-16144,-9996),
  0,
  0,
  ABISELECT(1376,860),
  ABISELECT(864,548),
  ABISELECT(640,400),
  ABISELECT(-400,-260),
  ABISELECT(-16144,-9996),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C17__8S6087C28[] = {
  ABISELECT(-528,-348),
  ABISELECT(-16272,-10084),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C17__8S6087C28[] = {
  0,
  0,
  ABISELECT(-15744,-9736),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn16784_N8S6087C17D1Ev,_ZThn10396_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn16784_N8S6087C17D0Ev,_ZThn10396_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C17__8S6087C28[] = {
  ABISELECT(-16784,-10396),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-1040,-660),
  ABISELECT(-16784,-10396),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C17__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-17008,-10544),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn17520_N8S6087C17D1Ev,_ZThn10856_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn17520_N8S6087C17D0Ev,_ZThn10856_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C17__8S6087C28[] = {
  ABISELECT(-17520,-10856),
  ABISELECT(-17520,-10856),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn17712_N8S6087C17D1Ev,_ZThn10964_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn17712_N8S6087C17D0Ev,_ZThn10964_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C17__8S6087C28[] = {
  ABISELECT(-17712,-10964),
  0,
  0,
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1968,-1228),
  ABISELECT(-17712,-10964),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17__8S6087C28[] = {
  ABISELECT(15616,9648),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C17__8S6087C28[] = {
  ABISELECT(16144,9996),
  ABISELECT(15504,9596),
  ABISELECT(16880,10456),
  ABISELECT(16368,10144),
  ABISELECT(15104,9336),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C17__8S6087C28[] = {
  0,
  ABISELECT(-18000,-11144),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C28[] = {
  ABISELECT(1376,860),
  ABISELECT(864,548),
  ABISELECT(640,400),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C28[] = {
  ABISELECT(-528,-348),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C28[] = {
  0,
  0,
  ABISELECT(528,348),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__8S6087C28[] = {
  ABISELECT(-528,-348),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__8S6087C28[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C13D1Ev,_ZThn400_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn640_N8S6087C13D0Ev,_ZThn400_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__8S6087C28[] = {
  ABISELECT(-640,-400),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-1040,-660),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-864,-548),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn1376_N8S6087C13D1Ev,_ZThn860_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn1376_N8S6087C13D0Ev,_ZThn860_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__8S6087C28[] = {
  ABISELECT(-1376,-860),
  ABISELECT(-1376,-860),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C28[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-1040,-660),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C28[] = {
  0,
  0,
  ABISELECT(1040,660),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C28[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C28[] = {
  ABISELECT(-1264,-808),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C28[] = {
  0,
  0,
  ABISELECT(1264,808),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C28[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1968,-1228),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__A1__8S6087C28[] = {
  ABISELECT(-192,-108),
  ABISELECT(-704,-420),
  ABISELECT(-1968,-1228),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C28[] = {
  0,
  0,
  ABISELECT(1968,1228),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C28[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__8S6087C28[] = {
  0,
  0,
  ABISELECT(1968,1228),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__8S6087C28[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-808),
  ABISELECT(704,420),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__8S6087C28[] = {
  ABISELECT(192,108),
  ABISELECT(192,108),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
static  VTT_ENTRY vtt_S6087C28[] = {
  {&(_ZTV8S6087C28[11]),  11,124},
  {&(_tg__ZTV8S6087C27__8S6087C28[3]),  3,3},
  {&(_tg__ZTV8S6087C17__8S6087C28[9]),  9,15},
  {&(_tg__ZTV8S6087C188S6087C17__8S6087C28[9]),  9,14},
  {&(_tg__ZTV8S6087C138S6087C188S6087C17__A1__8S6087C28[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C17__A1__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C188S6087C17__A1__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C188S6087C17__A1__8S6087C28[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C17__A1__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C188S6087C17__A1__8S6087C28[3]),  3,5},
  {&(_tg__ZTV8S6087C128S6087C188S6087C17__8S6087C28[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C17__A2__8S6087C28[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C17__A1__8S6087C28[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C128S6087C188S6087C17__8S6087C28[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C17__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C128S6087C188S6087C17__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C128S6087C188S6087C17__8S6087C28[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C17__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C128S6087C188S6087C17__8S6087C28[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C188S6087C17__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C188S6087C17__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C188S6087C17__8S6087C28[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C188S6087C17__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C188S6087C17__8S6087C28[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C188S6087C17__8S6087C28[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C188S6087C17__8S6087C28[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C17__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C188S6087C17__8S6087C28[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C188S6087C17__8S6087C28[3]),  3,4},
  {&(_tg__ZTV8S6087C13__8S6087C17__8S6087C28[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C17__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C17__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C17__8S6087C28[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C17__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C17__8S6087C28[3]),  3,5},
  {&(_tg__ZTV7S6087C4__8S6087C17__8S6087C28[8]),  8,12},
  {&(_tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C17__8S6087C28[3]),  3,6},
  {&(_tg__ZTV8S6087C128S6087C18__8S6087C17__8S6087C28[7]),  7,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C17__8S6087C28[3]),  3,4},
  {&(_ZTV8S6087C28[59]),  59,124},
  {&(_ZTV8S6087C28[23]),  23,124},
  {&(_ZTV8S6087C28[72]),  72,124},
  {&(_ZTV8S6087C28[79]),  79,124},
  {&(_ZTV8S6087C28[90]),  90,124},
  {&(_ZTV8S6087C28[100]),  100,124},
  {&(_ZTV8S6087C28[106]),  106,124},
  {&(_ZTV8S6087C28[116]),  116,124},
  {&(_ZTV8S6087C28[32]),  32,124},
  {&(_ZTV8S6087C28[42]),  42,124},
  {&(_ZTV8S6087C28[123]),  123,124},
  {&(_tg__ZTV8S6087C13__8S6087C28[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__8S6087C28[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__8S6087C28[3]),  3,5},
  {&(_tg__ZTV7S6087C5__8S6087C28[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C28[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C28[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C4__8S6087C28[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__A1__8S6087C28[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C28[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__8S6087C28[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__8S6087C28[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__8S6087C28[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S6087C28[];
extern  VTBL_ENTRY _ZTV8S6087C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C28[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17520_N8S6087C17D0Ev,_ZThn10856_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17520_N8S6087C17D1Ev,_ZThn10856_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17712_N8S6087C17D0Ev,_ZThn10964_N8S6087C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16784_N8S6087C17D0Ev,_ZThn10396_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17712_N8S6087C17D1Ev,_ZThn10964_N8S6087C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16784_N8S6087C17D1Ev,_ZThn10396_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16144_N8S6087C17D0Ev,_ZThn9996_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16144_N8S6087C17D1Ev,_ZThn9996_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16144_N8S6087C18D0Ev,_ZThn9996_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16144_N8S6087C18D1Ev,_ZThn9996_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17520_N8S6087C18D0Ev,_ZThn10856_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17520_N8S6087C18D1Ev,_ZThn10856_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17712_N8S6087C18D0Ev,_ZThn10964_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16784_N8S6087C18D0Ev,_ZThn10396_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17712_N8S6087C18D1Ev,_ZThn10964_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16784_N8S6087C18D1Ev,_ZThn10396_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16880_N8S6087C12D0Ev,_ZThn10456_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16880_N8S6087C12D1Ev,_ZThn10456_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16144_N8S6087C12D0Ev,_ZThn9996_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16144_N8S6087C12D1Ev,_ZThn9996_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15504_N8S6087C12D0Ev,_ZThn9596_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15504_N8S6087C12D1Ev,_ZThn9596_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16880_N7S6087C4D0Ev,_ZThn10456_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16880_N7S6087C4D1Ev,_ZThn10456_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16880_N7S6087C5D0Ev,_ZThn10456_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16880_N7S6087C5D1Ev,_ZThn10456_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1376_N8S6087C13D0Ev,_ZThn860_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn17520_N8S6087C13D0Ev,_ZThn10856_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1376_N8S6087C13D1Ev,_ZThn860_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn17520_N8S6087C13D1Ev,_ZThn10856_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N8S6087C13D0Ev,_ZThn400_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16784_N8S6087C13D0Ev,_ZThn10396_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N8S6087C13D1Ev,_ZThn400_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16784_N8S6087C13D1Ev,_ZThn10396_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17680_N8S6087C28D0Ev,_ZThn10940_N8S6087C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17680_N8S6087C28D1Ev,_ZThn10940_N8S6087C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17872_N8S6087C28D0Ev,_ZThn11048_N8S6087C28D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16944_N8S6087C28D0Ev,_ZThn10480_N8S6087C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17872_N8S6087C28D1Ev,_ZThn11048_N8S6087C28D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16944_N8S6087C28D1Ev,_ZThn10480_N8S6087C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16304_N8S6087C28D0Ev,_ZThn10080_N8S6087C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16304_N8S6087C28D1Ev,_ZThn10080_N8S6087C28D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C28 = {  "S6087C28", // class name
  bases_S6087C28, 32,
  &(vtc_S6087C28[0]), // expected_vtbl_contents
  &(vtt_S6087C28[0]), // expected_vtt_contents
  ABISELECT(18384,11368), // object size
  NSPAIRA(_ZTI8S6087C28),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S6087C28),124, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C28),80, //virtual table table var
  27, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C26  : S6087C14 , S6087C16 , S6087C27 , S6087C28 {
  long s6087c26f0;
  void *s6087c26f1;
  ~S6087C26(); // tgen
  S6087C26(); // tgen
};
//SIG(-1 S6087C26) C1{ BC2{ BC3{ BC4{ v1 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} BC5{ BC4 VBC6{ v2 v3 Fp FD Fi FC7{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC8{ BC7 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU9{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v4 v5 Fi FC8 Fi FC8} VBC10{ VBC6 VBC5 BC11{ v6 v7 Fp FC4 Fi Fp FD Fp FL Fc[6]} VBC8 Fl Fl Fc Fc:3} v8} BC8 v9 FU9 Fi FL[10] Fl FU12{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1}[9] Fi Fl Fc FC13{ VBC8 BC5 BC4 VBC11 Fp Fp Fi Fl[2] Fp[3] Fp}} BC13 BC14{ BC7 VBC15{ m Fc FC16{ m Fp Fp[10] FC10 Fi} FC3 Fl Fs FC11 FC3 Fl FC11 FU12 Fp Fl Fi Fp FL:3} Fi Fl[2] Fi Fl Fp Fc} BC17{ BC14 VBC6 BC18{ VBC3 VBC19{ BC10 Fl Fi Fp FD Fi Fi} BC20{ BC3 BC21{ VBC3 BC19 vd v10 Fi FC8} VBC19 VBC4 v11 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC5 Fp FC4 Fi Fp} BC8 BC6 vd v12 Fi FC15 Fl Fp[6] FC5 Fi Fi} VBC7 vd v13 Fc Fl[3] Fi} Fl Fp}


S6087C26 ::~S6087C26(){ note_dtor("S6087C26", this);} // tgen
S6087C26 ::S6087C26(){ note_ctor("S6087C26", this);} // tgen

static void Test_S6087C26()
{
  extern Class_Descriptor cd_S6087C26;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1384,3437)];
    init_test(&cd_S6087C26, buf);
    S6087C26 *dp, &lv = *(dp=new (buf) S6087C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(22128,13744), "sizeof(S6087C26)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C26)");
    /*is_ambiguous_... S6087C13::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C14*), 0, "S6087C26");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(128,88), "S6087C26");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(13536,8408), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(13536,8408), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(13536,8408), "S6087C26");
    check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C16*), ABISELECT(13536,8408), "S6087C26");
    /*is_ambiguous_... S6087C28::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C28*), ABISELECT(13536,8408), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(13536,8408), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(13536,8408), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(13536,8408), "S6087C26");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(13536,8408), "S6087C26");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(128,88), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(14160,8816), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(14160,8816), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(14160,8816), "S6087C26");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(14160,8816), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(13936,8668), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(14680,9132), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(14672,9128), "S6087C26");
    check_base_class_offset(lv, (S6087C7*)(S6087C16*), ABISELECT(14672,9128), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(14672,9128), "S6087C26");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(14672,9128), "S6087C26");
    check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C14*), ABISELECT(13936,8668), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(13936,8668), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(13936,8668), "S6087C26");
    check_base_class_offset(lv, (S6087C13*)(S6087C14*), 0, "S6087C26");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C14*), ABISELECT(648,404), "S6087C26");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C14*), ABISELECT(640,400), "S6087C26");
    check_base_class_offset(lv, (S6087C14*), 0, "S6087C26");
    check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C16*), ABISELECT(2656,1712), "S6087C26");
    check_base_class_offset(lv, (S6087C9*)(S6087C16*), ABISELECT(2656,1712), "S6087C26");
    /*is_ambiguous_... S6087C16::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C16*), ABISELECT(3168,2024), "S6087C26");
    check_base_class_offset(lv, (S6087C11*)(S6087C16*), ABISELECT(14864,9236), "S6087C26");
    check_base_class_offset(lv, (S6087C16*), ABISELECT(2656,1712), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C27 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C27*), ABISELECT(3376,2152), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C27 */ AMB_check_base_class_offset(lv, (S6087C19*)(S6087C27*), ABISELECT(15072,9372), "S6087C26");
    check_base_class_offset(lv, (S6087C19*)(S6087C27*)(S6087C28*), ABISELECT(15072,9372), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C27 */ AMB_check_base_class_offset(lv, (S6087C27*), ABISELECT(3368,2148), "S6087C26");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C27*)(S6087C28*), ABISELECT(3528,2236), "S6087C26");
    check_base_class_offset(lv, (S6087C27*)(S6087C28*), ABISELECT(3520,2232), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(20976,13024), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(21104,13112), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(21104,13112), "S6087C26");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C17*)(S6087C28*), ABISELECT(20976,13024), "S6087C26");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(20976,13024), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(21616,13424), "S6087C26");
    /*is_ambiguous_... S6087C26::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(21616,13424), "S6087C26");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C17*)(S6087C28*), ABISELECT(21616,13424), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(21616,13424), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(3680,2316), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(3808,2404), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(3808,2404), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(3680,2316), "S6087C26");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(4320,2716), "S6087C26");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(4320,2716), "S6087C26");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(4320,2716), "S6087C26");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(4320,2716), "S6087C26");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(21904,13604), "S6087C26");
    check_base_class_offset(lv, (S6087C18*)(S6087C17*)(S6087C28*), ABISELECT(3680,2316), "S6087C26");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C17*)(S6087C28*), ABISELECT(6008,3752), "S6087C26");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C17*)(S6087C28*), ABISELECT(6000,3748), "S6087C26");
    /*is_ambiguous_... S6087C17::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C17*)(S6087C28*), ABISELECT(6192,3856), "S6087C26");
    check_base_class_offset(lv, (S6087C17*)(S6087C28*), ABISELECT(3680,2316), "S6087C26");
    /*is_ambiguous_... S6087C28::S6087C2_nt */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C28*), ABISELECT(22032,13692), "S6087C26");
    check_base_class_offset(lv, (S6087C28*), ABISELECT(3520,2232), "S6087C26");
    check_field_offset(lv, s6087c26f0, ABISELECT(13520,8400), "S6087C26.s6087c26f0");
    check_field_offset(lv, s6087c26f1, ABISELECT(13528,8404), "S6087C26.s6087c26f1");
    test_class_info(&lv, &cd_S6087C26);
    dp->~S6087C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C26(Test_S6087C26, "S6087C26", ABISELECT(22128,13744));

#else // __cplusplus

extern void _ZN8S6087C26C1Ev();
extern void _ZN8S6087C26D1Ev();
Name_Map name_map_S6087C26[] = {
  NSPAIR(_ZN8S6087C26C1Ev),
  NSPAIR(_ZN8S6087C26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C14;
extern VTBL_ENTRY _ZTI8S6087C14[];
extern  VTBL_ENTRY _ZTV8S6087C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C14[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C16;
extern VTBL_ENTRY _ZTI8S6087C16[];
extern  VTBL_ENTRY _ZTV8S6087C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C16[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C19;
extern VTBL_ENTRY _ZTI8S6087C19[];
extern Class_Descriptor cd_S6087C27;
extern VTBL_ENTRY _ZTI8S6087C27[];
extern  VTBL_ENTRY _ZTV8S6087C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C27[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C27;
extern VTBL_ENTRY _ZTI8S6087C27[];
extern  VTBL_ENTRY _ZTV8S6087C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C27[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C17;
extern VTBL_ENTRY _ZTI8S6087C17[];
extern  VTBL_ENTRY _ZTV8S6087C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C17[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C28;
extern VTBL_ENTRY _ZTI8S6087C28[];
extern  VTBL_ENTRY _ZTV8S6087C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C28[];
static Base_Class bases_S6087C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(13536,8408), //bcp->offset
    98, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    82, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(128,88), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    81, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(14160,8816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(14160,8816), //bcp->offset
    116, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    84, //bcp->index_in_construction_vtbl_array
    101, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(13936,8668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(14680,9132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(14672,9128), //bcp->offset
    125, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    85, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(13936,8668), //bcp->offset
    104, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    83, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S6087C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(648,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(640,400), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(2656,1712), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(2656,1712), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(3168,2024), //bcp->offset
    37, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(14864,9236), //bcp->offset
    130, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    87, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S6087C16,    ABISELECT(2656,1712), //bcp->offset
    27, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    86, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C2_nt,    ABISELECT(3376,2152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C19,    ABISELECT(15072,9372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S6087C27,    ABISELECT(3368,2148), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    88, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C2_nt,    ABISELECT(3528,2236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S6087C27,    ABISELECT(3520,2232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(20976,13024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(21104,13112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(21104,13112), //bcp->offset
    151, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    92, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(20976,13024), //bcp->offset
    136, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    91, //bcp->index_in_construction_vtbl_array
    103, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    38, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(21616,13424), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(21616,13424), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    112, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(21616,13424), //bcp->offset
    157, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    93, //bcp->index_in_construction_vtbl_array
    111, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S6087C10,    ABISELECT(3680,2316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(3808,2404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(3808,2404), //bcp->offset
    72, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    94, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(3680,2316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(4320,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(4320,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(4320,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(4320,2716), //bcp->offset
    78, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    95, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(21904,13604), //bcp->offset
    169, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    96, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S6087C18,    ABISELECT(3680,2316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(6008,3752), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(6000,3748), //bcp->offset
    90, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(6192,3856), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S6087C17,    ABISELECT(3680,2316), //bcp->offset
    57, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    90, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(22032,13692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 1},
  {&cd_S6087C28,    ABISELECT(3520,2232), //bcp->offset
    43, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    89, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C26[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C26D1Ev();
extern void _ZN8S6087C26D0Ev();
extern void _ZN8S6087C143v11Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn640_N8S6087C26D1Ev,_ZThn400_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C26D0Ev,_ZThn400_N8S6087C26D0Ev)();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn2656_N8S6087C26D1Ev,_ZThn1712_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn2656_N8S6087C26D0Ev,_ZThn1712_N8S6087C26D0Ev)();
extern void _ZN8S6087C102v4Ev();
extern void ABISELECT(_ZThn3520_N8S6087C26D1Ev,_ZThn2232_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn3520_N8S6087C26D0Ev,_ZThn2232_N8S6087C26D0Ev)();
extern void _ZN8S6087C283v17Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn3680_N8S6087C26D1Ev,_ZThn2316_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn3680_N8S6087C26D0Ev,_ZThn2316_N8S6087C26D0Ev)();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn4320_N8S6087C26D1Ev,_ZThn2716_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn4320_N8S6087C26D0Ev,_ZThn2716_N8S6087C26D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void ABISELECT(_ZThn6000_N8S6087C26D1Ev,_ZThn3748_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn6000_N8S6087C26D0Ev,_ZThn3748_N8S6087C26D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C26D1Ev,_ZTv0_n32_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn13936_N8S6087C26D1Ev,_ZThn8668_N8S6087C26D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C26D0Ev,_ZTv0_n32_N8S6087C26D0Ev)();
extern void ABISELECT(_ZThn13936_N8S6087C26D0Ev,_ZThn8668_N8S6087C26D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C26D1Ev,_ZTv0_n12_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn14672_N8S6087C26D1Ev,_ZThn9128_N8S6087C26D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C26D0Ev,_ZTv0_n12_N8S6087C26D0Ev)();
extern void ABISELECT(_ZThn14672_N8S6087C26D0Ev,_ZThn9128_N8S6087C26D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C26D1Ev,_ZTv0_n36_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn20976_N8S6087C26D1Ev,_ZThn13024_N8S6087C26D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C26D0Ev,_ZTv0_n36_N8S6087C26D0Ev)();
extern void ABISELECT(_ZThn20976_N8S6087C26D0Ev,_ZThn13024_N8S6087C26D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C26D1Ev,_ZTv0_n32_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn21616_N8S6087C26D1Ev,_ZThn13424_N8S6087C26D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C26D0Ev,_ZTv0_n32_N8S6087C26D0Ev)();
extern void ABISELECT(_ZThn21616_N8S6087C26D0Ev,_ZThn13424_N8S6087C26D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY vtc_S6087C26[] = {
  ABISELECT(22032,13692),
  ABISELECT(21904,13604),
  ABISELECT(21616,13424),
  ABISELECT(20976,13024),
  ABISELECT(15072,9372),
  ABISELECT(14864,9236),
  ABISELECT(14672,9128),
  ABISELECT(14160,8816),
  ABISELECT(13936,8668),
  ABISELECT(13536,8408),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C26D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C26D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
  ABISELECT(13408,8320),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C26D1Ev,_ZThn400_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C26D0Ev,_ZThn400_N8S6087C26D0Ev),
  ABISELECT(12208,7524),
  ABISELECT(12016,7416),
  ABISELECT(10880,6696),
  ABISELECT(-2656,-1712),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2656_N8S6087C26D1Ev,_ZThn1712_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2656_N8S6087C26D0Ev,_ZThn1712_N8S6087C26D0Ev),
  ABISELECT(-3168,-2024),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(11704,7224),
  ABISELECT(-3368,-2148),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  ABISELECT(18512,11460),
  ABISELECT(18384,11372),
  ABISELECT(18096,11192),
  ABISELECT(11152,6896),
  ABISELECT(10640,6584),
  ABISELECT(10416,6436),
  ABISELECT(17456,10792),
  ABISELECT(10016,6176),
  ABISELECT(11552,7140),
  ABISELECT(-3520,-2232),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3520_N8S6087C26D1Ev,_ZThn2232_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3520_N8S6087C26D0Ev,_ZThn2232_N8S6087C26D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C283v17Ev,
  ABISELECT(18224,11288),
  ABISELECT(17936,11108),
  ABISELECT(17296,10708),
  ABISELECT(10992,6812),
  ABISELECT(10480,6500),
  ABISELECT(10256,6352),
  ABISELECT(9856,6092),
  ABISELECT(-3680,-2316),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3680_N8S6087C26D1Ev,_ZThn2316_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3680_N8S6087C26D0Ev,_ZThn2316_N8S6087C26D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
  ABISELECT(9728,6004),
  ABISELECT(-3808,-2404),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(9616,5952),
  ABISELECT(16656,10308),
  ABISELECT(10352,6412),
  ABISELECT(9840,6100),
  ABISELECT(9216,5692),
  ABISELECT(-4320,-2716),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4320_N8S6087C26D1Ev,_ZThn2716_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4320_N8S6087C26D0Ev,_ZThn2716_N8S6087C26D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-6000,-3748),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6000_N8S6087C26D1Ev,_ZThn3748_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6000_N8S6087C26D0Ev,_ZThn3748_N8S6087C26D0Ev),
  ABISELECT(-6192,-3856),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  0,
  ABISELECT(-13536,-8408),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-13936,-8668),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-13936,-8668),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C26D1Ev,_ZTv0_n32_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C26D0Ev,_ZTv0_n32_N8S6087C26D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-14160,-8816),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-14672,-9128),
  ABISELECT(-14672,-9128),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C26D1Ev,_ZTv0_n12_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C26D0Ev,_ZTv0_n12_N8S6087C26D0Ev),
  0,
  0,
  ABISELECT(-14864,-9236),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-20976,-13024),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-20976,-13024),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C26D1Ev,_ZTv0_n36_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C26D0Ev,_ZTv0_n36_N8S6087C26D0Ev),
  ABISELECT(-7568,-4704),
  ABISELECT(-21104,-13112),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-21616,-13424),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-21616,-13424),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C26D1Ev,_ZTv0_n32_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C26D0Ev,_ZTv0_n32_N8S6087C26D0Ev),
  0,
  ABISELECT(-21904,-13604),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern VTBL_ENTRY _ZTV8S6087C26[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C14D1Ev();
extern void _ZN8S6087C14D0Ev();
extern void _ZN8S6087C143v11Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C14__8S6087C26[] = {
  ABISELECT(14672,9128),
  ABISELECT(14160,8816),
  ABISELECT(13936,8668),
  ABISELECT(13536,8408),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C14__8S6087C26[] = {
  ABISELECT(14672,9128),
  ABISELECT(14160,8816),
  ABISELECT(13936,8668),
  ABISELECT(13536,8408),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C14__8S6087C26[] = {
  ABISELECT(13408,8320),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C14__8S6087C26[] = {
  0,
  0,
  ABISELECT(-13408,-8320),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C14__8S6087C26[] = {
  ABISELECT(13408,8320),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C14__8S6087C26[] = {
  0,
  0,
  ABISELECT(-13536,-8408),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn13936_N8S6087C13D1Ev,_ZThn8668_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn13936_N8S6087C13D0Ev,_ZThn8668_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C14__8S6087C26[] = {
  ABISELECT(-13936,-8668),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-13936,-8668),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C14__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-14160,-8816),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn14672_N8S6087C13D1Ev,_ZThn9128_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn14672_N8S6087C13D0Ev,_ZThn9128_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C14__8S6087C26[] = {
  ABISELECT(-14672,-9128),
  ABISELECT(-14672,-9128),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C14__8S6087C26[] = {
  ABISELECT(13408,8320),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C14__8S6087C26[] = {
  0,
  0,
  ABISELECT(-13536,-8408),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn13936_N8S6087C14D1Ev,_ZThn8668_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn13936_N8S6087C14D0Ev,_ZThn8668_N8S6087C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C14__8S6087C26[] = {
  ABISELECT(-13936,-8668),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-13936,-8668),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C14__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-14160,-8816),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn14672_N8S6087C14D1Ev,_ZThn9128_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn14672_N8S6087C14D0Ev,_ZThn9128_N8S6087C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C14__8S6087C26[] = {
  ABISELECT(-14672,-9128),
  ABISELECT(-14672,-9128),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C16D1Ev();
extern void _ZN8S6087C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C16__8S6087C26[] = {
  ABISELECT(12208,7524),
  ABISELECT(12016,7416),
  ABISELECT(10880,6696),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C16__A2__8S6087C26[] = {
  ABISELECT(10880,6696),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C16__A2__8S6087C26[] = {
  0,
  0,
  ABISELECT(-10880,-6696),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev)();
extern void ABISELECT(_ZThn12016_N8S6087C16D1Ev,_ZThn7416_N8S6087C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev)();
extern void ABISELECT(_ZThn12016_N8S6087C16D0Ev,_ZThn7416_N8S6087C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C16__8S6087C26[] = {
  ABISELECT(-12016,-7416),
  ABISELECT(-12016,-7416),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C16__8S6087C26[] = {
  0,
  0,
  ABISELECT(-10880,-6696),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C11__8S6087C16__8S6087C26[] = {
  0,
  0,
  ABISELECT(-12208,-7524),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
static  VTBL_ENTRY _tg__ZTV8S6087C27__8S6087C26[] = {
  ABISELECT(11704,7224),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C27[0]),
};
extern void _ZN8S6087C28D1Ev();
extern void _ZN8S6087C28D0Ev();
extern void _ZN8S6087C283v17Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C28__8S6087C26[] = {
  ABISELECT(18512,11460),
  ABISELECT(18384,11372),
  ABISELECT(18096,11192),
  ABISELECT(11152,6896),
  ABISELECT(10640,6584),
  ABISELECT(10416,6436),
  ABISELECT(17456,10792),
  ABISELECT(10016,6176),
  ABISELECT(11552,7140),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C28D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C28D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C283v17Ev,
};
static  VTBL_ENTRY _tg__ZTV8S6087C278S6087C28__A1__8S6087C26[] = {
  ABISELECT(11552,7140),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C27[0]),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C17D1Ev();
extern void _ZN8S6087C17D0Ev();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(18224,11288),
  ABISELECT(17936,11108),
  ABISELECT(17296,10708),
  ABISELECT(10992,6812),
  ABISELECT(10480,6500),
  ABISELECT(10256,6352),
  ABISELECT(9856,6092),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(18224,11288),
  ABISELECT(17936,11108),
  ABISELECT(17296,10708),
  ABISELECT(10992,6812),
  ABISELECT(10480,6500),
  ABISELECT(10256,6352),
  ABISELECT(9856,6092),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  ABISELECT(10992,6812),
  ABISELECT(10480,6500),
  ABISELECT(10256,6352),
  ABISELECT(9856,6092),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C178S6087C28__A4__8S6087C26[] = {
  ABISELECT(9728,6004),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C178S6087C28__A4__8S6087C26[] = {
  0,
  0,
  ABISELECT(-9728,-6004),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  ABISELECT(9728,6004),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  0,
  0,
  ABISELECT(-9856,-6092),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn10256_N8S6087C13D1Ev,_ZThn6352_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn10256_N8S6087C13D0Ev,_ZThn6352_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  ABISELECT(-10256,-6352),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10256,-6352),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10480,-6500),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn10992_N8S6087C13D1Ev,_ZThn6812_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn10992_N8S6087C13D0Ev,_ZThn6812_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  ABISELECT(-10992,-6812),
  ABISELECT(-10992,-6812),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(9616,5952),
  ABISELECT(16656,10308),
  ABISELECT(10352,6412),
  ABISELECT(9840,6100),
  ABISELECT(9216,5692),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[] = {
  ABISELECT(10352,6412),
  ABISELECT(9840,6100),
  ABISELECT(9216,5692),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  ABISELECT(10352,6412),
  ABISELECT(9840,6100),
  ABISELECT(9216,5692),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  0,
  0,
  ABISELECT(-9216,-5692),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-9840,-6100),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn10352_N7S6087C5D1Ev,_ZThn6412_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn10352_N7S6087C5D0Ev,_ZThn6412_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[] = {
  ABISELECT(-10352,-6412),
  ABISELECT(-10352,-6412),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[] = {
  0,
  0,
  ABISELECT(-9216,-5692),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-9840,-6100),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn10352_N7S6087C4D1Ev,_ZThn6412_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn10352_N7S6087C4D0Ev,_ZThn6412_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[] = {
  ABISELECT(-10352,-6412),
  ABISELECT(-10352,-6412),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn16656_N8S6087C12D1Ev,_ZThn10308_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn16656_N8S6087C12D0Ev,_ZThn10308_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-16656,-10308),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-16656,-10308),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-16784,-10396),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[] = {
  0,
  0,
  ABISELECT(-9216,-5692),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn9616_N8S6087C12D1Ev,_ZThn5952_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn9616_N8S6087C12D0Ev,_ZThn5952_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-9616,-5952),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-9616,-5952),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-9840,-6100),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn10352_N8S6087C12D1Ev,_ZThn6412_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn10352_N8S6087C12D0Ev,_ZThn6412_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-10352,-6412),
  ABISELECT(-10352,-6412),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(9728,6004),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  0,
  0,
  ABISELECT(-9856,-6092),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn10256_N8S6087C18D1Ev,_ZThn6352_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn10256_N8S6087C18D0Ev,_ZThn6352_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-10256,-6352),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10256,-6352),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10480,-6500),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn10992_N8S6087C18D1Ev,_ZThn6812_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn10992_N8S6087C18D0Ev,_ZThn6812_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-10992,-6812),
  ABISELECT(-10992,-6812),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(9616,5952),
  ABISELECT(16656,10308),
  ABISELECT(10352,6412),
  ABISELECT(9840,6100),
  ABISELECT(9216,5692),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn17296_N8S6087C18D1Ev,_ZThn10708_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn17296_N8S6087C18D0Ev,_ZThn10708_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-17296,-10708),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-17296,-10708),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-17424,-10796),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn17936_N8S6087C18D1Ev,_ZThn11108_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn17936_N8S6087C18D0Ev,_ZThn11108_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-17936,-11108),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-17936,-11108),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C188S6087C178S6087C28__8S6087C26[] = {
  0,
  ABISELECT(-18224,-11288),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn17296_N8S6087C17D1Ev,_ZThn10708_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn17296_N8S6087C17D0Ev,_ZThn10708_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-17296,-10708),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-17296,-10708),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-17424,-10796),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C178S6087C28__8S6087C26[] = {
  0,
  0,
  ABISELECT(-9856,-6092),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn10256_N8S6087C17D1Ev,_ZThn6352_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn10256_N8S6087C17D0Ev,_ZThn6352_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-10256,-6352),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10256,-6352),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C178S6087C28__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10480,-6500),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn10992_N8S6087C17D1Ev,_ZThn6812_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn10992_N8S6087C17D0Ev,_ZThn6812_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-10992,-6812),
  ABISELECT(-10992,-6812),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn17936_N8S6087C17D1Ev,_ZThn11108_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn17936_N8S6087C17D0Ev,_ZThn11108_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(-17936,-11108),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-17936,-11108),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(9728,6004),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C178S6087C28__8S6087C26[] = {
  ABISELECT(9616,5952),
  ABISELECT(16656,10308),
  ABISELECT(10352,6412),
  ABISELECT(9840,6100),
  ABISELECT(9216,5692),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C178S6087C28__8S6087C26[] = {
  0,
  ABISELECT(-18224,-11288),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C28__8S6087C26[] = {
  0,
  0,
  ABISELECT(-10016,-6176),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn160_N8S6087C28D1Ev,_ZThn84_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn160_N8S6087C28D0Ev,_ZThn84_N8S6087C28D0Ev)();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C17__8S6087C28__8S6087C26[] = {
  ABISELECT(18224,11288),
  ABISELECT(17936,11108),
  ABISELECT(17296,10708),
  ABISELECT(10992,6812),
  ABISELECT(10480,6500),
  ABISELECT(10256,6352),
  ABISELECT(9856,6092),
  ABISELECT(-160,-84),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S6087C28D1Ev,_ZThn84_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S6087C28D0Ev,_ZThn84_N8S6087C28D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn17456_N8S6087C28D1Ev,_ZThn10792_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn17456_N8S6087C28D0Ev,_ZThn10792_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C28__8S6087C26[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-17456,-10792),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-17456,-10792),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C28__8S6087C26[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-17584,-10880),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn10416_N8S6087C28D1Ev,_ZThn6436_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn10416_N8S6087C28D0Ev,_ZThn6436_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C28__8S6087C26[] = {
  ABISELECT(-10416,-6436),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-10416,-6436),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C28__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-10640,-6584),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn11152_N8S6087C28D1Ev,_ZThn6896_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn11152_N8S6087C28D0Ev,_ZThn6896_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C28__8S6087C26[] = {
  ABISELECT(-11152,-6896),
  ABISELECT(-11152,-6896),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn18096_N8S6087C28D1Ev,_ZThn11192_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn18096_N8S6087C28D0Ev,_ZThn11192_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C28__8S6087C26[] = {
  ABISELECT(-18096,-11192),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-18096,-11192),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C28__8S6087C26[] = {
  ABISELECT(9728,6004),
  ABISELECT(-288,-172),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn800_N8S6087C28D1Ev,_ZThn484_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn800_N8S6087C28D0Ev,_ZThn484_N8S6087C28D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C17__8S6087C28__8S6087C26[] = {
  ABISELECT(9616,5952),
  ABISELECT(16656,10308),
  ABISELECT(10352,6412),
  ABISELECT(9840,6100),
  ABISELECT(9216,5692),
  ABISELECT(-800,-484),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N8S6087C28D1Ev,_ZThn484_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N8S6087C28D0Ev,_ZThn484_N8S6087C28D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C28__8S6087C26[] = {
  0,
  ABISELECT(-18384,-11372),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C26[] = {
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C5__8S6087C26[] = {
  0,
  0,
  ABISELECT(400,260),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C5__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C5__8S6087C26[] = {
  ABISELECT(-736,-460),
  ABISELECT(-736,-460),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C26[] = {
  ABISELECT(-624,-408),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C9__A1__8S6087C26[] = {
  0,
  0,
  ABISELECT(624,408),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C26[] = {
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A3__8S6087C26[] = {
  ABISELECT(-7568,-4704),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__A3__8S6087C26[] = {
  0,
  0,
  ABISELECT(7568,4704),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__A1__8S6087C26[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__A1__8S6087C26[] = {
  0,
  0,
  ABISELECT(7440,4616),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__A1__8S6087C26[] = {
  ABISELECT(7040,4356),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(7040,4356),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__A1__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(6816,4208),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__A1__8S6087C26[] = {
  ABISELECT(6304,3896),
  ABISELECT(6304,3896),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C26[] = {
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C4__A1__8S6087C26[] = {
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C26[] = {
  0,
  0,
  ABISELECT(8080,5016),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(7456,4608),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C26[] = {
  ABISELECT(6944,4296),
  ABISELECT(6944,4296),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C4__8S6087C26[] = {
  0,
  0,
  ABISELECT(8080,5016),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C4__8S6087C26[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(7456,4608),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C4__8S6087C26[] = {
  ABISELECT(6944,4296),
  ABISELECT(6944,4296),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
static  VTT_ENTRY vtt_S6087C26[] = {
  {&(_ZTV8S6087C26[12]),  12,173},
  {&(_tg__ZTV8S6087C14__8S6087C26[6]),  6,11},
  {&(_tg__ZTV8S6087C138S6087C14__8S6087C26[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C14__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C14__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C14__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C14__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C14__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C14__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C14__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C14__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C14__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C14__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C14__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C14__8S6087C26[3]),  3,5},
  {&(_tg__ZTV8S6087C16__8S6087C26[5]),  5,10},
  {&(_tg__ZTV7S6087C98S6087C16__A2__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C16__A2__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C7__8S6087C16__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C6__8S6087C16__8S6087C26[4]),  4,6},
  {&(_tg__ZTV8S6087C11__8S6087C16__8S6087C26[4]),  4,6},
  {&(_tg__ZTV8S6087C27__8S6087C26[3]),  3,3},
  {&(_tg__ZTV8S6087C28__8S6087C26[11]),  11,14},
  {&(_tg__ZTV8S6087C278S6087C28__A1__8S6087C26[3]),  3,3},
  {&(_tg__ZTV8S6087C178S6087C28__8S6087C26[9]),  9,15},
  {&(_tg__ZTV8S6087C188S6087C178S6087C28__8S6087C26[9]),  9,14},
  {&(_tg__ZTV8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C138S6087C188S6087C178S6087C28__A4__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C178S6087C28__A4__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C138S6087C188S6087C178S6087C28__A2__8S6087C26[3]),  3,5},
  {&(_tg__ZTV8S6087C128S6087C188S6087C178S6087C28__8S6087C26[7]),  7,12},
  {&(_tg__ZTV7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C28__A2__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C178S6087C28__A1__8S6087C26[3]),  3,5},
  {&(_tg__ZTV8S6087C13__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C128S6087C188S6087C178S6087C28__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C188S6087C178S6087C28__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C188S6087C178S6087C28__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C188S6087C178S6087C28__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C188S6087C178S6087C28__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C188S6087C178S6087C28__8S6087C26[3]),  3,5},
  {&(_tg__ZTV8S6087C12__8S6087C188S6087C178S6087C28__8S6087C26[7]),  7,12},
  {&(_tg__ZTV8S6087C13__A1__8S6087C188S6087C178S6087C28__8S6087C26[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C178S6087C28__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C4__A1__8S6087C188S6087C178S6087C28__8S6087C26[8]),  8,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C188S6087C178S6087C28__8S6087C26[3]),  3,4},
  {&(_tg__ZTV8S6087C13__8S6087C178S6087C28__8S6087C26[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C178S6087C28__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C178S6087C28__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C178S6087C28__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C178S6087C28__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C178S6087C28__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C4__8S6087C178S6087C28__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C178S6087C28__8S6087C26[3]),  3,6},
  {&(_tg__ZTV8S6087C128S6087C18__8S6087C178S6087C28__8S6087C26[7]),  7,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C178S6087C28__8S6087C26[3]),  3,4},
  {&(_tg__ZTV7S6087C6__8S6087C28__8S6087C26[4]),  4,6},
  {&(_tg__ZTV8S6087C17__8S6087C28__8S6087C26[9]),  9,15},
  {&(_tg__ZTV8S6087C13__8S6087C28__8S6087C26[11]),  11,15},
  {&(_tg__ZTV7S6087C98S6087C13__8S6087C28__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C5__8S6087C28__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C28__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C28__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C4__8S6087C28__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C28__8S6087C26[3]),  3,6},
  {&(_tg__ZTV8S6087C128S6087C188S6087C17__8S6087C28__8S6087C26[7]),  7,12},
  {&(_tg__ZTV8S6087C10__A5__8S6087C28__8S6087C26[3]),  3,4},
  {&(_ZTV8S6087C26[20]),  20,173},
  {&(_ZTV8S6087C26[102]),  102,173},
  {&(_ZTV8S6087C26[112]),  112,173},
  {&(_ZTV8S6087C26[122]),  122,173},
  {&(_ZTV8S6087C26[128]),  128,173},
  {&(_ZTV8S6087C26[32]),  32,173},
  {&(_ZTV8S6087C26[134]),  134,173},
  {&(_ZTV8S6087C26[43]),  43,173},
  {&(_ZTV8S6087C26[54]),  54,173},
  {&(_ZTV8S6087C26[66]),  66,173},
  {&(_ZTV8S6087C26[147]),  147,173},
  {&(_ZTV8S6087C26[154]),  154,173},
  {&(_ZTV8S6087C26[165]),  165,173},
  {&(_ZTV8S6087C26[75]),  75,173},
  {&(_ZTV8S6087C26[85]),  85,173},
  {&(_ZTV8S6087C26[172]),  172,173},
  {&(_tg__ZTV7S6087C5__8S6087C26[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C5__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C5__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C5__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C9__A1__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C9__A1__8S6087C26[4]),  4,6},
  {&(_tg__ZTV8S6087C13__A1__8S6087C26[6]),  6,10},
  {&(_tg__ZTV7S6087C98S6087C13__A3__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__7S6087C98S6087C13__A3__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__A__8S6087C13__A1__8S6087C26[3]),  3,6},
  {&(_tg__ZTV7S6087C6__8S6087C13__A1__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C5__8S6087C13__A1__8S6087C26[8]),  8,12},
  {&(_tg__ZTV7S6087C9__A1__8S6087C13__A1__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__8S6087C13__A1__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C4__8S6087C26[5]),  5,9},
  {&(_tg__ZTV7S6087C57S6087C4__A1__8S6087C26[5]),  5,9},
  {&(_tg__ZTV7S6087C6__7S6087C57S6087C4__A1__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C57S6087C4__A1__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C57S6087C4__A1__8S6087C26[3]),  3,5},
  {&(_tg__ZTV7S6087C6__7S6087C4__8S6087C26[4]),  4,6},
  {&(_tg__ZTV7S6087C9__7S6087C4__8S6087C26[6]),  6,9},
  {&(_tg__ZTV7S6087C7__7S6087C4__8S6087C26[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S6087C26[];
extern  VTBL_ENTRY _ZTV8S6087C26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C26[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11152_N8S6087C28D0Ev,_ZThn6896_N8S6087C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11152_N8S6087C28D1Ev,_ZThn6896_N8S6087C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18096_N8S6087C28D0Ev,_ZThn11192_N8S6087C28D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10416_N8S6087C28D0Ev,_ZThn6436_N8S6087C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18096_N8S6087C28D1Ev,_ZThn11192_N8S6087C28D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10416_N8S6087C28D1Ev,_ZThn6436_N8S6087C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17456_N8S6087C28D0Ev,_ZThn10792_N8S6087C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17456_N8S6087C28D1Ev,_ZThn10792_N8S6087C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N8S6087C17D0Ev,_ZThn6812_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N8S6087C17D1Ev,_ZThn6812_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17936_N8S6087C17D0Ev,_ZThn11108_N8S6087C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10256_N8S6087C17D0Ev,_ZThn6352_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17936_N8S6087C17D1Ev,_ZThn11108_N8S6087C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10256_N8S6087C17D1Ev,_ZThn6352_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17296_N8S6087C17D0Ev,_ZThn10708_N8S6087C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17296_N8S6087C17D1Ev,_ZThn10708_N8S6087C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17296_N8S6087C18D0Ev,_ZThn10708_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17296_N8S6087C18D1Ev,_ZThn10708_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N8S6087C18D0Ev,_ZThn6812_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N8S6087C18D1Ev,_ZThn6812_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17936_N8S6087C18D0Ev,_ZThn11108_N8S6087C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10256_N8S6087C18D0Ev,_ZThn6352_N8S6087C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17936_N8S6087C18D1Ev,_ZThn11108_N8S6087C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10256_N8S6087C18D1Ev,_ZThn6352_N8S6087C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10352_N8S6087C12D0Ev,_ZThn6412_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10352_N8S6087C12D1Ev,_ZThn6412_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9616_N8S6087C12D0Ev,_ZThn5952_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9616_N8S6087C12D1Ev,_ZThn5952_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16656_N8S6087C12D0Ev,_ZThn10308_N8S6087C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16656_N8S6087C12D1Ev,_ZThn10308_N8S6087C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10352_N7S6087C4D0Ev,_ZThn6412_N7S6087C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10352_N7S6087C4D1Ev,_ZThn6412_N7S6087C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D0Ev,_ZThn460_N7S6087C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10352_N7S6087C5D0Ev,_ZThn6412_N7S6087C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N7S6087C5D1Ev,_ZThn460_N7S6087C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10352_N7S6087C5D1Ev,_ZThn6412_N7S6087C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12016_N8S6087C16D0Ev,_ZThn7416_N8S6087C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12016_N8S6087C16D1Ev,_ZThn7416_N8S6087C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14672_N8S6087C14D0Ev,_ZThn9128_N8S6087C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14672_N8S6087C14D1Ev,_ZThn9128_N8S6087C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13936_N8S6087C14D0Ev,_ZThn8668_N8S6087C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13936_N8S6087C14D1Ev,_ZThn8668_N8S6087C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N8S6087C13D0Ev,_ZThn6812_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14672_N8S6087C13D0Ev,_ZThn9128_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N8S6087C13D1Ev,_ZThn6812_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14672_N8S6087C13D1Ev,_ZThn9128_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10256_N8S6087C13D0Ev,_ZThn6352_N8S6087C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn13936_N8S6087C13D0Ev,_ZThn8668_N8S6087C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10256_N8S6087C13D1Ev,_ZThn6352_N8S6087C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn13936_N8S6087C13D1Ev,_ZThn8668_N8S6087C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C26D0Ev,_ZTv0_n36_N8S6087C26D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20976_N8S6087C26D0Ev,_ZThn13024_N8S6087C26D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S6087C26D1Ev,_ZTv0_n36_N8S6087C26D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20976_N8S6087C26D1Ev,_ZThn13024_N8S6087C26D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C26D0Ev,_ZTv0_n12_N8S6087C26D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14672_N8S6087C26D0Ev,_ZThn9128_N8S6087C26D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S6087C26D1Ev,_ZTv0_n12_N8S6087C26D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14672_N8S6087C26D1Ev,_ZThn9128_N8S6087C26D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C26D0Ev,_ZTv0_n32_N8S6087C26D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21616_N8S6087C26D0Ev,_ZThn13424_N8S6087C26D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn13936_N8S6087C26D0Ev,_ZThn8668_N8S6087C26D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S6087C26D1Ev,_ZTv0_n32_N8S6087C26D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21616_N8S6087C26D1Ev,_ZThn13424_N8S6087C26D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn13936_N8S6087C26D1Ev,_ZThn8668_N8S6087C26D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S6087C26 = {  "S6087C26", // class name
  bases_S6087C26, 47,
  &(vtc_S6087C26[0]), // expected_vtbl_contents
  &(vtt_S6087C26[0]), // expected_vtt_contents
  ABISELECT(22128,13744), // object size
  NSPAIRA(_ZTI8S6087C26),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S6087C26),173, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S6087C26),118, //virtual table table var
  40, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6087C25  : virtual S6087C14 , S6087C13 , S6087C26 , virtual S6087C23 {
  int s6087c25f0;
  void *s6087c25f1;
  virtual  ~S6087C25(); // _ZN8S6087C25D2Ev
  virtual void  v18(); // _ZN8S6087C253v18Ev
  virtual void  v19(); // _ZN8S6087C253v19Ev
  S6087C25(); // tgen
};
//SIG(-1 S6087C25) C1{ VBC2{ BC3{ BC4{ v3 Fi:30 Fp Fi[9] FL Fi FD Fc:3 Fp Fl[2]} BC5{ BC4 VBC6{ v4 v5 Fp FD Fi FC7{ m Fs Fi[2] Fl[8] Fi Fs} Fs[6] Fc FC8{ BC7 vd Fi[3] Fl Fp[5] FL:13 Fl FL} Fi FU9{ m FL[7] Fc FL Fp FL Fc Fl Fc Fi Fl Fi Fp Fl[7]}} v6 v7 Fi FC8 Fi FC8} VBC10{ VBC6 VBC5 BC11{ v8 v9 Fp FC4 Fi Fp FD Fp FL Fc[6]} VBC8 Fl Fl Fc Fc:3} v10} BC8 v11 FU9 Fi FL[10] Fl FU12{ m Fl Fl Fl Fl Fi FD Fl FL Fs:1}[9] Fi Fl Fc FC13{ VBC8 BC5 BC4 VBC11 Fp Fp Fi Fl[2] Fp[3] Fp}} BC3 BC14{ BC2 BC13 BC15{ BC7 VBC16{ m Fc FC17{ m Fp Fp[10] FC10 Fi} FC3 Fl Fs FC11 FC3 Fl FC11 FU12 Fp Fl Fi Fp FL:3} Fi Fl[2] Fi Fl Fp Fc} BC18{ BC15 VBC6 BC19{ VBC3 VBC20{ BC10 Fl Fi Fp FD Fi Fi} BC21{ BC3 BC22{ VBC3 BC20 vd v12 Fi FC8} VBC20 VBC4 v13 Fp Fl Fi Fc Fl Fi Fl[10] Fi FC5 Fp FC4 Fi Fp} BC8 BC6 vd v14 Fi FC16 Fl Fp[6] FC5 Fi Fi} VBC7 vd v15 Fc Fl[3] Fi} Fl Fp} VBC23{ VBC11 BC17 vd Fc:4 Fi Fi[6] Fi[10] Fp} vd v1 v2 Fi Fp}


 S6087C25 ::~S6087C25(){ note_dtor("S6087C25", this);}
void  S6087C25 ::v18(){vfunc_called(this, "_ZN8S6087C253v18Ev");}
void  S6087C25 ::v19(){vfunc_called(this, "_ZN8S6087C253v19Ev");}
S6087C25 ::S6087C25(){ note_ctor("S6087C25", this);} // tgen

static void Test_S6087C25()
{
  extern Class_Descriptor cd_S6087C25;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1687,4206)];
    init_test(&cd_S6087C25, buf);
    S6087C25 *dp, &lv = *(dp=new (buf) S6087C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(26976,16820), "sizeof(S6087C25)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S6087C25)");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C14*), ABISELECT(14192,8816), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(14320,8904), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C14*)(S6087C26*), ABISELECT(16848,10528), "S6087C25");
    check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C16*)(S6087C26*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C28::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C28*)(S6087C26*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(16848,10528), "S6087C25");
    check_base_class_offset(lv, (S6087C6*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(16848,10528), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C14*), ABISELECT(14320,8904), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*), ABISELECT(17472,10936), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*), ABISELECT(17472,10936), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*), ABISELECT(17472,10936), "S6087C25");
    check_base_class_offset(lv, (S6087C9*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(17472,10936), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*), ABISELECT(17248,10788), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*), ABISELECT(17992,11252), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C5 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*), ABISELECT(17984,11248), "S6087C25");
    check_base_class_offset(lv, (S6087C7*)(S6087C16*)(S6087C26*), ABISELECT(17984,11248), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*), ABISELECT(17984,11248), "S6087C25");
    check_base_class_offset(lv, (S6087C7*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(17984,11248), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C14*), ABISELECT(17248,10788), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(17248,10788), "S6087C25");
    check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C14*)(S6087C26*), ABISELECT(17248,10788), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*), ABISELECT(17248,10788), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(17248,10788), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C14*), ABISELECT(14192,8816), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C14*), ABISELECT(14840,9220), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C14*), ABISELECT(14832,9216), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C14 */ AMB_check_base_class_offset(lv, (S6087C14*), ABISELECT(14192,8816), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), 0, "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(128,88), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(128,88), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*), 0, "S6087C25");
    /*is_ambiguous_... S6087C13::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C14*)(S6087C26*), ABISELECT(640,400), "S6087C25");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C14*)(S6087C26*), ABISELECT(768,488), "S6087C25");
    /*is_ambiguous_... S6087C13::S6087C9 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C14*)(S6087C26*), ABISELECT(768,488), "S6087C25");
    check_base_class_offset(lv, (S6087C13*)(S6087C14*)(S6087C26*), ABISELECT(640,400), "S6087C25");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C14*)(S6087C26*), ABISELECT(1288,804), "S6087C25");
    /*is_ambiguous_... S6087C14::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C14*)(S6087C26*), ABISELECT(1280,800), "S6087C25");
    check_base_class_offset(lv, (S6087C14*)(S6087C26*), ABISELECT(640,400), "S6087C25");
    check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C16*)(S6087C26*), ABISELECT(3296,2112), "S6087C25");
    check_base_class_offset(lv, (S6087C9*)(S6087C16*)(S6087C26*), ABISELECT(3296,2112), "S6087C25");
    /*is_ambiguous_... S6087C16::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C16*)(S6087C26*), ABISELECT(3808,2424), "S6087C25");
    check_base_class_offset(lv, (S6087C11*)(S6087C16*)(S6087C26*), ABISELECT(18176,11356), "S6087C25");
    check_base_class_offset(lv, (S6087C11*)(S6087C23*), ABISELECT(18176,11356), "S6087C25");
    check_base_class_offset(lv, (S6087C16*)(S6087C26*), ABISELECT(3296,2112), "S6087C25");
    /*is_ambiguous_... S6087C26::S6087C27 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C27*)(S6087C26*), ABISELECT(4016,2552), "S6087C25");
    /*is_ambiguous_... S6087C26::S6087C27 */ AMB_check_base_class_offset(lv, (S6087C19*)(S6087C27*)(S6087C26*), ABISELECT(18384,11492), "S6087C25");
    check_base_class_offset(lv, (S6087C19*)(S6087C27*)(S6087C28*)(S6087C26*), ABISELECT(18384,11492), "S6087C25");
    /*is_ambiguous_... S6087C26::S6087C27 */ AMB_check_base_class_offset(lv, (S6087C27*)(S6087C26*), ABISELECT(4008,2548), "S6087C25");
    check_base_class_offset(lv, (S6087C2_nt*)(S6087C27*)(S6087C28*)(S6087C26*), ABISELECT(4168,2636), "S6087C25");
    check_base_class_offset(lv, (S6087C27*)(S6087C28*)(S6087C26*), ABISELECT(4160,2632), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*), ABISELECT(24288,15144), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*), ABISELECT(24416,15232), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*), ABISELECT(24416,15232), "S6087C25");
    /*is_ambiguous_... S6087C17::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(24288,15144), "S6087C25");
    check_base_class_offset(lv, (S6087C13*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(24288,15144), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*), ABISELECT(24928,15544), "S6087C25");
    /*is_ambiguous_... S6087C25::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C5*)(S6087C4*), ABISELECT(24928,15544), "S6087C25");
    /*is_ambiguous_... S6087C17::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(24928,15544), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C4 */ AMB_check_base_class_offset(lv, (S6087C4*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(24928,15544), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4320,2716), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4448,2804), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C9*)(S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4448,2804), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C13 */ AMB_check_base_class_offset(lv, (S6087C13*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4320,2716), "S6087C25");
    check_base_class_offset(lv, (S6087C11*)(S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4960,3116), "S6087C25");
    check_base_class_offset(lv, (S6087C5*)(S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4960,3116), "S6087C25");
    check_base_class_offset(lv, (S6087C4*)(S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4960,3116), "S6087C25");
    check_base_class_offset(lv, (S6087C12*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4960,3116), "S6087C25");
    /*is_ambiguous_... S6087C18::S6087C10 */ AMB_check_base_class_offset(lv, (S6087C10*)(S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(25216,15724), "S6087C25");
    check_base_class_offset(lv, (S6087C18*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4320,2716), "S6087C25");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C7*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(6648,4152), "S6087C25");
    /*is_ambiguous_... S6087C17::S6087C7 */ AMB_check_base_class_offset(lv, (S6087C7*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(6640,4148), "S6087C25");
    /*is_ambiguous_... S6087C17::S6087C6 */ AMB_check_base_class_offset(lv, (S6087C6*)(S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(6832,4256), "S6087C25");
    check_base_class_offset(lv, (S6087C17*)(S6087C28*)(S6087C26*), ABISELECT(4320,2716), "S6087C25");
    /*is_ambiguous_... S6087C28::S6087C2_nt */ AMB_check_base_class_offset(lv, (S6087C2_nt*)(S6087C28*)(S6087C26*), ABISELECT(25344,15812), "S6087C25");
    check_base_class_offset(lv, (S6087C28*)(S6087C26*), ABISELECT(4160,2632), "S6087C25");
    check_base_class_offset(lv, (S6087C26*), ABISELECT(640,400), "S6087C25");
    check_base_class_offset(lv, (S6087C20*)(S6087C23*), ABISELECT(25456,15868), "S6087C25");
    check_base_class_offset(lv, (S6087C23*), ABISELECT(25440,15864), "S6087C25");
    check_field_offset(lv, s6087c25f0, ABISELECT(14176,8808), "S6087C25.s6087c25f0");
    check_field_offset(lv, s6087c25f1, ABISELECT(14184,8812), "S6087C25.s6087c25f1");
    test_class_info(&lv, &cd_S6087C25);
    dp->~S6087C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6087C25(Test_S6087C25, "S6087C25", ABISELECT(26976,16820));

#else // __cplusplus

extern void _ZN8S6087C25C1Ev();
extern void _ZN8S6087C25D2Ev();
Name_Map name_map_S6087C25[] = {
  NSPAIR(_ZN8S6087C25C1Ev),
  NSPAIR(_ZN8S6087C25D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C14;
extern VTBL_ENTRY _ZTI8S6087C14[];
extern  VTBL_ENTRY _ZTV8S6087C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C14[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C14;
extern VTBL_ENTRY _ZTI8S6087C14[];
extern  VTBL_ENTRY _ZTV8S6087C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C14[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C16;
extern VTBL_ENTRY _ZTI8S6087C16[];
extern  VTBL_ENTRY _ZTV8S6087C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C16[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C19;
extern VTBL_ENTRY _ZTI8S6087C19[];
extern Class_Descriptor cd_S6087C27;
extern VTBL_ENTRY _ZTI8S6087C27[];
extern  VTBL_ENTRY _ZTV8S6087C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C27[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C27;
extern VTBL_ENTRY _ZTI8S6087C27[];
extern  VTBL_ENTRY _ZTV8S6087C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C27[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C9;
extern VTBL_ENTRY _ZTI7S6087C9[];
extern  VTBL_ENTRY _ZTV7S6087C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C9[];
extern Class_Descriptor cd_S6087C13;
extern VTBL_ENTRY _ZTI8S6087C13[];
extern  VTBL_ENTRY _ZTV8S6087C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C13[];
extern Class_Descriptor cd_S6087C11;
extern VTBL_ENTRY _ZTI8S6087C11[];
extern  VTBL_ENTRY _ZTV8S6087C11[];
extern Class_Descriptor cd_S6087C5;
extern VTBL_ENTRY _ZTI7S6087C5[];
extern  VTBL_ENTRY _ZTV7S6087C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C5[];
extern Class_Descriptor cd_S6087C4;
extern VTBL_ENTRY _ZTI7S6087C4[];
extern  VTBL_ENTRY _ZTV7S6087C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S6087C4[];
extern Class_Descriptor cd_S6087C12;
extern VTBL_ENTRY _ZTI8S6087C12[];
extern  VTBL_ENTRY _ZTV8S6087C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C12[];
extern Class_Descriptor cd_S6087C10;
extern VTBL_ENTRY _ZTI8S6087C10[];
extern  VTBL_ENTRY _ZTV8S6087C10[];
extern Class_Descriptor cd_S6087C18;
extern VTBL_ENTRY _ZTI8S6087C18[];
extern  VTBL_ENTRY _ZTV8S6087C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C18[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C7;
extern VTBL_ENTRY _ZTI7S6087C7[];
extern  VTBL_ENTRY _ZTV7S6087C7[];
extern Class_Descriptor cd_S6087C6;
extern VTBL_ENTRY _ZTI7S6087C6[];
extern  VTBL_ENTRY _ZTV7S6087C6[];
extern Class_Descriptor cd_S6087C17;
extern VTBL_ENTRY _ZTI8S6087C17[];
extern  VTBL_ENTRY _ZTV8S6087C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C17[];
extern Class_Descriptor cd_S6087C2_nt;
extern VTBL_ENTRY _ZTI10S6087C2_nt[];
extern Class_Descriptor cd_S6087C28;
extern VTBL_ENTRY _ZTI8S6087C28[];
extern  VTBL_ENTRY _ZTV8S6087C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C28[];
extern Class_Descriptor cd_S6087C26;
extern VTBL_ENTRY _ZTI8S6087C26[];
extern  VTBL_ENTRY _ZTV8S6087C26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C26[];
extern Class_Descriptor cd_S6087C20;
extern VTBL_ENTRY _ZTI8S6087C20[];
extern Class_Descriptor cd_S6087C23;
extern VTBL_ENTRY _ZTI8S6087C23[];
extern  VTBL_ENTRY _ZTV8S6087C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S6087C23[];
static Base_Class bases_S6087C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6087C10,    ABISELECT(14192,8816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(14320,8904), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(16848,10528), //bcp->offset
    151, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    108, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S6087C9,    ABISELECT(14320,8904), //bcp->offset
    141, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    107, //bcp->index_in_construction_vtbl_array
    130, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(17472,10936), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(17472,10936), //bcp->offset
    169, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    110, //bcp->index_in_construction_vtbl_array
    146, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(17248,10788), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(17992,11252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(17984,11248), //bcp->offset
    178, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    111, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S6087C5,    ABISELECT(17248,10788), //bcp->offset
    157, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    109, //bcp->index_in_construction_vtbl_array
    142, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S6087C13,    ABISELECT(14192,8816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    129, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(14840,9220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(14832,9216), //bcp->offset
    147, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    112, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S6087C14,    ABISELECT(14192,8816), //bcp->offset
    124, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    106, //bcp->index_in_construction_vtbl_array
    128, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S6087C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(128,88), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    113, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S6087C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C10,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(768,488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(768,488), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    115, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(1288,804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(1280,800), //bcp->offset
    49, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S6087C14,    ABISELECT(640,400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(3296,2112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(3296,2112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(3808,2424), //bcp->offset
    63, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(18176,11356), //bcp->offset
    183, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    117, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S6087C16,    ABISELECT(3296,2112), //bcp->offset
    53, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    116, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(4016,2552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S6087C19,    ABISELECT(18384,11492), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S6087C27,    ABISELECT(4008,2548), //bcp->offset
    66, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    118, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(4168,2636), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S6087C27,    ABISELECT(4160,2632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(24288,15144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(24416,15232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(24416,15232), //bcp->offset
    204, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    122, //bcp->index_in_construction_vtbl_array
    149, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(24288,15144), //bcp->offset
    189, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    121, //bcp->index_in_construction_vtbl_array
    148, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    49, //immediately_derived
  0, 1},
  {&cd_S6087C11,    ABISELECT(24928,15544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(24928,15544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    157, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(24928,15544), //bcp->offset
    210, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    123, //bcp->index_in_construction_vtbl_array
    156, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    51, //immediately_derived
  0, 1},
  {&cd_S6087C10,    ABISELECT(4320,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(4448,2804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S6087C9,    ABISELECT(4448,2804), //bcp->offset
    98, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    124, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S6087C13,    ABISELECT(4320,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S6087C11,    ABISELECT(4960,3116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S6087C5,    ABISELECT(4960,3116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S6087C4,    ABISELECT(4960,3116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S6087C12,    ABISELECT(4960,3116), //bcp->offset
    104, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    125, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S6087C10,    ABISELECT(25216,15724), //bcp->offset
    222, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    126, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    51, //immediately_derived
  0, 1},
  {&cd_S6087C18,    ABISELECT(4320,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(6648,4152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S6087C7,    ABISELECT(6640,4148), //bcp->offset
    116, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S6087C6,    ABISELECT(6832,4256), //bcp->offset
    120, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S6087C17,    ABISELECT(4320,2716), //bcp->offset
    83, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    120, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S6087C2_nt,    ABISELECT(25344,15812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    57, //immediately_derived
  0, 1},
  {&cd_S6087C28,    ABISELECT(4160,2632), //bcp->offset
    69, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    119, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S6087C26,    ABISELECT(640,400), //bcp->offset
    26, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    114, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6087C20,    ABISELECT(25456,15868), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S6087C23,    ABISELECT(25440,15864), //bcp->offset
    226, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    127, //bcp->index_in_construction_vtbl_array
    164, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S6087C25[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C25D1Ev();
extern void _ZN8S6087C25D0Ev();
extern void _ZN8S6087C253v18Ev();
extern void _ZN8S6087C253v19Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn640_N8S6087C25D1Ev,_ZThn400_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C25D0Ev,_ZThn400_N8S6087C25D0Ev)();
extern void _ZN8S6087C143v11Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn1280_N8S6087C25D1Ev,_ZThn800_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn1280_N8S6087C25D0Ev,_ZThn800_N8S6087C25D0Ev)();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn3296_N8S6087C25D1Ev,_ZThn2112_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn3296_N8S6087C25D0Ev,_ZThn2112_N8S6087C25D0Ev)();
extern void _ZN8S6087C102v4Ev();
extern void ABISELECT(_ZThn4160_N8S6087C25D1Ev,_ZThn2632_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn4160_N8S6087C25D0Ev,_ZThn2632_N8S6087C25D0Ev)();
extern void _ZN8S6087C283v17Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn4320_N8S6087C25D1Ev,_ZThn2716_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn4320_N8S6087C25D0Ev,_ZThn2716_N8S6087C25D0Ev)();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn4960_N8S6087C25D1Ev,_ZThn3116_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn4960_N8S6087C25D0Ev,_ZThn3116_N8S6087C25D0Ev)();
extern void _ZN8S6087C123v10Ev();
extern void ABISELECT(_ZThn6640_N8S6087C25D1Ev,_ZThn4148_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn6640_N8S6087C25D0Ev,_ZThn4148_N8S6087C25D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C25D1Ev,_ZTv0_n36_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn14192_N8S6087C25D1Ev,_ZThn8816_N8S6087C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C25D0Ev,_ZTv0_n36_N8S6087C25D0Ev)();
extern void ABISELECT(_ZThn14192_N8S6087C25D0Ev,_ZThn8816_N8S6087C25D0Ev)() __attribute__((weak));
extern void _ZN8S6087C143v11Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTvn640_n72_N8S6087C25D1Ev,_ZTvn400_n36_N8S6087C25D1Ev)();
extern void ABISELECT(_ZTvn640_n72_N8S6087C25D0Ev,_ZTvn400_n36_N8S6087C25D0Ev)();
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C25D1Ev,_ZTv0_n32_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn17248_N8S6087C25D1Ev,_ZThn10788_N8S6087C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C25D0Ev,_ZTv0_n32_N8S6087C25D0Ev)();
extern void ABISELECT(_ZThn17248_N8S6087C25D0Ev,_ZThn10788_N8S6087C25D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S6087C25D1Ev,_ZTv0_n12_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn17984_N8S6087C25D1Ev,_ZThn11248_N8S6087C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C25D0Ev,_ZTv0_n12_N8S6087C25D0Ev)();
extern void ABISELECT(_ZThn17984_N8S6087C25D0Ev,_ZThn11248_N8S6087C25D0Ev)() __attribute__((weak));
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C25D1Ev,_ZTv0_n36_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn24288_N8S6087C25D1Ev,_ZThn15144_N8S6087C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C25D0Ev,_ZTv0_n36_N8S6087C25D0Ev)();
extern void ABISELECT(_ZThn24288_N8S6087C25D0Ev,_ZThn15144_N8S6087C25D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C25D1Ev,_ZTv0_n32_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn24928_N8S6087C25D1Ev,_ZThn15544_N8S6087C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C25D0Ev,_ZTv0_n32_N8S6087C25D0Ev)();
extern void ABISELECT(_ZThn24928_N8S6087C25D0Ev,_ZThn15544_N8S6087C25D0Ev)() __attribute__((weak));
extern void _ZN8S6087C102v4Ev();
extern void ABISELECT(_ZTv0_n32_N8S6087C25D1Ev,_ZTv0_n16_N8S6087C25D1Ev)();
extern void ABISELECT(_ZThn25440_N8S6087C25D1Ev,_ZThn15864_N8S6087C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S6087C25D0Ev,_ZTv0_n16_N8S6087C25D0Ev)();
extern void ABISELECT(_ZThn25440_N8S6087C25D0Ev,_ZThn15864_N8S6087C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S6087C25[] = {
  ABISELECT(25440,15864),
  ABISELECT(25344,15812),
  ABISELECT(25216,15724),
  ABISELECT(24928,15544),
  ABISELECT(24288,15144),
  ABISELECT(18384,11492),
  ABISELECT(18176,11356),
  ABISELECT(14192,8816),
  ABISELECT(17984,11248),
  ABISELECT(17472,10936),
  ABISELECT(17248,10788),
  ABISELECT(16848,10528),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C25D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C25D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C253v18Ev,
  (VTBL_ENTRY)&_ZN8S6087C253v19Ev,
  ABISELECT(16720,10440),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(24704,15412),
  ABISELECT(24576,15324),
  ABISELECT(24288,15144),
  ABISELECT(23648,14744),
  ABISELECT(17744,11092),
  ABISELECT(17536,10956),
  ABISELECT(17344,10848),
  ABISELECT(16832,10536),
  ABISELECT(16608,10388),
  ABISELECT(16208,10128),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C25D1Ev,_ZThn400_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C25D0Ev,_ZThn400_N8S6087C25D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
  ABISELECT(16080,10040),
  ABISELECT(-768,-488),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-1280,-800),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1280_N8S6087C25D1Ev,_ZThn800_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1280_N8S6087C25D0Ev,_ZThn800_N8S6087C25D0Ev),
  ABISELECT(14880,9244),
  ABISELECT(14688,9136),
  ABISELECT(13552,8416),
  ABISELECT(-3296,-2112),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S6087C25D1Ev,_ZThn2112_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S6087C25D0Ev,_ZThn2112_N8S6087C25D0Ev),
  ABISELECT(-3808,-2424),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(14376,8944),
  ABISELECT(-4008,-2548),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  ABISELECT(21184,13180),
  ABISELECT(21056,13092),
  ABISELECT(20768,12912),
  ABISELECT(13824,8616),
  ABISELECT(13312,8304),
  ABISELECT(13088,8156),
  ABISELECT(20128,12512),
  ABISELECT(12688,7896),
  ABISELECT(14224,8860),
  ABISELECT(-4160,-2632),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn4160_N8S6087C25D1Ev,_ZThn2632_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4160_N8S6087C25D0Ev,_ZThn2632_N8S6087C25D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C283v17Ev,
  ABISELECT(20896,13008),
  ABISELECT(20608,12828),
  ABISELECT(19968,12428),
  ABISELECT(13664,8532),
  ABISELECT(13152,8220),
  ABISELECT(12928,8072),
  ABISELECT(12528,7812),
  ABISELECT(-4320,-2716),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4320_N8S6087C25D1Ev,_ZThn2716_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4320_N8S6087C25D0Ev,_ZThn2716_N8S6087C25D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
  ABISELECT(12400,7724),
  ABISELECT(-4448,-2804),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(12288,7672),
  ABISELECT(19328,12028),
  ABISELECT(13024,8132),
  ABISELECT(12512,7820),
  ABISELECT(11888,7412),
  ABISELECT(-4960,-3116),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4960_N8S6087C25D1Ev,_ZThn3116_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4960_N8S6087C25D0Ev,_ZThn3116_N8S6087C25D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
  ABISELECT(-6640,-4148),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6640_N8S6087C25D1Ev,_ZThn4148_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6640_N8S6087C25D0Ev,_ZThn4148_N8S6087C25D0Ev),
  ABISELECT(-6832,-4256),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  0,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-14192,-8816),
  0,
  0,
  ABISELECT(3792,2432),
  ABISELECT(3280,2120),
  ABISELECT(3056,1972),
  ABISELECT(2656,1712),
  ABISELECT(-14192,-8816),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C25D1Ev,_ZTv0_n36_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C25D0Ev,_ZTv0_n36_N8S6087C25D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
  ABISELECT(2528,1624),
  ABISELECT(-14320,-8904),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-14832,-9216),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn640_n72_N8S6087C25D1Ev,_ZTvn400_n36_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn640_n72_N8S6087C25D0Ev,_ZTvn400_n36_N8S6087C25D0Ev),
  0,
  0,
  ABISELECT(-16848,-10528),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
  ABISELECT(-17248,-10788),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-17248,-10788),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C25D1Ev,_ZTv0_n32_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C25D0Ev,_ZTv0_n32_N8S6087C25D0Ev),
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-17472,-10936),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-17984,-11248),
  ABISELECT(-17984,-11248),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C25D1Ev,_ZTv0_n12_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C25D0Ev,_ZTv0_n12_N8S6087C25D0Ev),
  0,
  0,
  ABISELECT(-18176,-11356),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-24288,-15144),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-24288,-15144),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C25D1Ev,_ZTv0_n36_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C25D0Ev,_ZTv0_n36_N8S6087C25D0Ev),
  ABISELECT(-7568,-4704),
  ABISELECT(-24416,-15232),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  ABISELECT(-24928,-15544),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-24928,-15544),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C25D1Ev,_ZTv0_n32_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C25D0Ev,_ZTv0_n32_N8S6087C25D0Ev),
  0,
  ABISELECT(-25216,-15724),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  ABISELECT(-25440,-15864),
  ABISELECT(-7264,-4508),
  ABISELECT(-25440,-15864),
  (VTBL_ENTRY)&(_ZTI8S6087C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S6087C25D1Ev,_ZTv0_n16_N8S6087C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S6087C25D0Ev,_ZTv0_n16_N8S6087C25D0Ev),
};
extern VTBL_ENTRY _ZTV8S6087C25[];
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C13__A__8S6087C25[] = {
  ABISELECT(17984,11248),
  ABISELECT(17472,10936),
  ABISELECT(17248,10788),
  ABISELECT(16848,10528),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C25[] = {
  ABISELECT(16720,10440),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C13__A2__8S6087C25[] = {
  0,
  0,
  ABISELECT(-16720,-10440),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C13__A__8S6087C25[] = {
  ABISELECT(16720,10440),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C13__A__8S6087C25[] = {
  0,
  0,
  ABISELECT(-16848,-10528),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn17248_N8S6087C13D1Ev,_ZThn10788_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn17248_N8S6087C13D0Ev,_ZThn10788_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C13__A__8S6087C25[] = {
  ABISELECT(-17248,-10788),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-17248,-10788),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C13__A__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-17472,-10936),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn17984_N8S6087C13D1Ev,_ZThn11248_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn17984_N8S6087C13D0Ev,_ZThn11248_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C13__A__8S6087C25[] = {
  ABISELECT(-17984,-11248),
  ABISELECT(-17984,-11248),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C26D1Ev();
extern void _ZN8S6087C26D0Ev();
extern void _ZN8S6087C143v11Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C26__8S6087C25[] = {
  ABISELECT(24704,15412),
  ABISELECT(24576,15324),
  ABISELECT(24288,15144),
  ABISELECT(23648,14744),
  ABISELECT(17744,11092),
  ABISELECT(17536,10956),
  ABISELECT(17344,10848),
  ABISELECT(16832,10536),
  ABISELECT(16608,10388),
  ABISELECT(16208,10128),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C26D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C26D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C14D1Ev();
extern void _ZN8S6087C14D0Ev();
extern void _ZN8S6087C143v11Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C148S6087C26__A1__8S6087C25[] = {
  ABISELECT(17344,10848),
  ABISELECT(16832,10536),
  ABISELECT(16608,10388),
  ABISELECT(16208,10128),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C14D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C143v11Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C148S6087C26__A2__8S6087C25[] = {
  ABISELECT(17344,10848),
  ABISELECT(16832,10536),
  ABISELECT(16608,10388),
  ABISELECT(16208,10128),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C148S6087C26__A3__8S6087C25[] = {
  ABISELECT(16080,10040),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C148S6087C26__A3__8S6087C25[] = {
  0,
  0,
  ABISELECT(-16080,-10040),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C148S6087C26__A2__8S6087C25[] = {
  ABISELECT(16080,10040),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C148S6087C26__A2__8S6087C25[] = {
  0,
  0,
  ABISELECT(-16208,-10128),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn16608_N8S6087C13D1Ev,_ZThn10388_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn16608_N8S6087C13D0Ev,_ZThn10388_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C148S6087C26__A2__8S6087C25[] = {
  ABISELECT(-16608,-10388),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-16608,-10388),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C148S6087C26__A2__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-16832,-10536),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn17344_N8S6087C13D1Ev,_ZThn10848_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn17344_N8S6087C13D0Ev,_ZThn10848_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C148S6087C26__A2__8S6087C25[] = {
  ABISELECT(-17344,-10848),
  ABISELECT(-17344,-10848),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C148S6087C26__A1__8S6087C25[] = {
  ABISELECT(16080,10040),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C148S6087C26__A1__8S6087C25[] = {
  0,
  0,
  ABISELECT(-16208,-10128),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn16608_N8S6087C14D1Ev,_ZThn10388_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn16608_N8S6087C14D0Ev,_ZThn10388_N8S6087C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C148S6087C26__A1__8S6087C25[] = {
  ABISELECT(-16608,-10388),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-16608,-10388),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D1Ev,_ZTv0_n32_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C14D0Ev,_ZTv0_n32_N8S6087C14D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C148S6087C26__A1__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-16832,-10536),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev)();
extern void ABISELECT(_ZThn17344_N8S6087C14D1Ev,_ZThn10848_N8S6087C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev)();
extern void ABISELECT(_ZThn17344_N8S6087C14D0Ev,_ZThn10848_N8S6087C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C148S6087C26__A1__8S6087C25[] = {
  ABISELECT(-17344,-10848),
  ABISELECT(-17344,-10848),
  (VTBL_ENTRY)&(_ZTI8S6087C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D1Ev,_ZTv0_n12_N8S6087C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C14D0Ev,_ZTv0_n12_N8S6087C14D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void _ZN8S6087C16D1Ev();
extern void _ZN8S6087C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C168S6087C26__8S6087C25[] = {
  ABISELECT(14880,9244),
  ABISELECT(14688,9136),
  ABISELECT(13552,8416),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C16D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C168S6087C26__A4__8S6087C25[] = {
  ABISELECT(13552,8416),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C168S6087C26__A4__8S6087C25[] = {
  0,
  0,
  ABISELECT(-13552,-8416),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev)();
extern void ABISELECT(_ZThn14688_N8S6087C16D1Ev,_ZThn9136_N8S6087C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev)();
extern void ABISELECT(_ZThn14688_N8S6087C16D0Ev,_ZThn9136_N8S6087C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C168S6087C26__8S6087C25[] = {
  ABISELECT(-14688,-9136),
  ABISELECT(-14688,-9136),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D1Ev,_ZTv0_n12_N8S6087C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C16D0Ev,_ZTv0_n12_N8S6087C16D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C168S6087C26__8S6087C25[] = {
  0,
  0,
  ABISELECT(-13552,-8416),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C11__8S6087C168S6087C26__8S6087C25[] = {
  0,
  0,
  ABISELECT(-14880,-9244),
  (VTBL_ENTRY)&(_ZTI8S6087C16[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
};
static  VTBL_ENTRY _tg__ZTV8S6087C278S6087C26__8S6087C25[] = {
  ABISELECT(14376,8944),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C27[0]),
};
extern void _ZN8S6087C28D1Ev();
extern void _ZN8S6087C28D0Ev();
extern void _ZN8S6087C283v17Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(21184,13180),
  ABISELECT(21056,13092),
  ABISELECT(20768,12912),
  ABISELECT(13824,8616),
  ABISELECT(13312,8304),
  ABISELECT(13088,8156),
  ABISELECT(20128,12512),
  ABISELECT(12688,7896),
  ABISELECT(14224,8860),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C28D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C28D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C283v17Ev,
};
static  VTBL_ENTRY _tg__ZTV8S6087C278S6087C288S6087C26__A1__8S6087C25[] = {
  ABISELECT(14224,8860),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C27[0]),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C17D1Ev();
extern void _ZN8S6087C17D0Ev();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(20896,13008),
  ABISELECT(20608,12828),
  ABISELECT(19968,12428),
  ABISELECT(13664,8532),
  ABISELECT(13152,8220),
  ABISELECT(12928,8072),
  ABISELECT(12528,7812),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C17D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C18D1Ev();
extern void _ZN8S6087C18D0Ev();
extern void _ZN8S6087C183v12Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(20896,13008),
  ABISELECT(20608,12828),
  ABISELECT(19968,12428),
  ABISELECT(13664,8532),
  ABISELECT(13152,8220),
  ABISELECT(12928,8072),
  ABISELECT(12528,7812),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C18D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void _ZN8S6087C13D1Ev();
extern void _ZN8S6087C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C138S6087C188S6087C178S6087C288S6087C26__A4__8S6087C25[] = {
  ABISELECT(13664,8532),
  ABISELECT(13152,8220),
  ABISELECT(12928,8072),
  ABISELECT(12528,7812),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C13D0Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C178S6087C288S6087C26__A6__8S6087C25[] = {
  ABISELECT(12400,7724),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C98S6087C138S6087C188S6087C178S6087C288S6087C26__A6__8S6087C25[] = {
  0,
  0,
  ABISELECT(-12400,-7724),
  (VTBL_ENTRY)&(_ZTI7S6087C9[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A__8S6087C138S6087C188S6087C178S6087C288S6087C26__A4__8S6087C25[] = {
  ABISELECT(12400,7724),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C138S6087C188S6087C178S6087C288S6087C26__A4__8S6087C25[] = {
  0,
  0,
  ABISELECT(-12528,-7812),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn12928_N8S6087C13D1Ev,_ZThn8072_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn12928_N8S6087C13D0Ev,_ZThn8072_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C138S6087C188S6087C178S6087C288S6087C26__A4__8S6087C25[] = {
  ABISELECT(-12928,-8072),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-12928,-8072),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D1Ev,_ZTv0_n32_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C13D0Ev,_ZTv0_n32_N8S6087C13D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C138S6087C188S6087C178S6087C288S6087C26__A4__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-13152,-8220),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev)();
extern void ABISELECT(_ZThn13664_N8S6087C13D1Ev,_ZThn8532_N8S6087C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev)();
extern void ABISELECT(_ZThn13664_N8S6087C13D0Ev,_ZThn8532_N8S6087C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C138S6087C188S6087C178S6087C288S6087C26__A4__8S6087C25[] = {
  ABISELECT(-13664,-8532),
  ABISELECT(-13664,-8532),
  (VTBL_ENTRY)&(_ZTI8S6087C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D1Ev,_ZTv0_n12_N8S6087C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C13D0Ev,_ZTv0_n12_N8S6087C13D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN8S6087C12D1Ev();
extern void _ZN8S6087C12D0Ev();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(12288,7672),
  ABISELECT(19328,12028),
  ABISELECT(13024,8132),
  ABISELECT(12512,7820),
  ABISELECT(11888,7412),
  0,
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D1Ev,
  (VTBL_ENTRY)&_ZN8S6087C12D0Ev,
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C4D1Ev();
extern void _ZN7S6087C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A1__8S6087C25[] = {
  ABISELECT(13024,8132),
  ABISELECT(12512,7820),
  ABISELECT(11888,7412),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C4D0Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void _ZN7S6087C5D1Ev();
extern void _ZN7S6087C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A2__8S6087C25[] = {
  ABISELECT(13024,8132),
  ABISELECT(12512,7820),
  ABISELECT(11888,7412),
  0,
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D1Ev,
  (VTBL_ENTRY)&_ZN7S6087C5D0Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A2__8S6087C25[] = {
  0,
  0,
  ABISELECT(-11888,-7412),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A2__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-12512,-7820),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev)();
extern void ABISELECT(_ZThn13024_N7S6087C5D1Ev,_ZThn8132_N7S6087C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev)();
extern void ABISELECT(_ZThn13024_N7S6087C5D0Ev,_ZThn8132_N7S6087C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C57S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A2__8S6087C25[] = {
  ABISELECT(-13024,-8132),
  ABISELECT(-13024,-8132),
  (VTBL_ENTRY)&(_ZTI7S6087C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D1Ev,_ZTv0_n12_N7S6087C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C5D0Ev,_ZTv0_n12_N7S6087C5D0Ev),
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__7S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A1__8S6087C25[] = {
  0,
  0,
  ABISELECT(-11888,-7412),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__7S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A1__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-12512,-7820),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev)();
extern void ABISELECT(_ZThn13024_N7S6087C4D1Ev,_ZThn8132_N7S6087C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev)();
extern void ABISELECT(_ZThn13024_N7S6087C4D0Ev,_ZThn8132_N7S6087C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__7S6087C48S6087C128S6087C188S6087C178S6087C288S6087C26__A1__8S6087C25[] = {
  ABISELECT(-13024,-8132),
  ABISELECT(-13024,-8132),
  (VTBL_ENTRY)&(_ZTI7S6087C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D1Ev,_ZTv0_n12_N7S6087C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S6087C4D0Ev,_ZTv0_n12_N7S6087C4D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn19328_N8S6087C12D1Ev,_ZThn12028_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn19328_N8S6087C12D0Ev,_ZThn12028_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C128S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-19328,-12028),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-19328,-12028),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D1Ev,_ZTv0_n36_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C12D0Ev,_ZTv0_n36_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C128S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-19456,-12116),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C128S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  ABISELECT(-11888,-7412),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn12288_N8S6087C12D1Ev,_ZThn7672_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn12288_N8S6087C12D0Ev,_ZThn7672_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C128S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-12288,-7672),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-12288,-7672),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D1Ev,_ZTv0_n32_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C12D0Ev,_ZTv0_n32_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C128S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-12512,-7820),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev)();
extern void ABISELECT(_ZThn13024_N8S6087C12D1Ev,_ZThn8132_N8S6087C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev)();
extern void ABISELECT(_ZThn13024_N8S6087C12D0Ev,_ZThn8132_N8S6087C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C128S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-13024,-8132),
  ABISELECT(-13024,-8132),
  (VTBL_ENTRY)&(_ZTI8S6087C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D1Ev,_ZTv0_n12_N8S6087C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C12D0Ev,_ZTv0_n12_N8S6087C12D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(12400,7724),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  ABISELECT(-12528,-7812),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn12928_N8S6087C18D1Ev,_ZThn8072_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn12928_N8S6087C18D0Ev,_ZThn8072_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-12928,-8072),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-12928,-8072),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-13152,-8220),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn13664_N8S6087C18D1Ev,_ZThn8532_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn13664_N8S6087C18D0Ev,_ZThn8532_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-13664,-8532),
  ABISELECT(-13664,-8532),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D1Ev,_ZTv0_n12_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C18D0Ev,_ZTv0_n12_N8S6087C18D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C12__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(12288,7672),
  ABISELECT(19328,12028),
  ABISELECT(13024,8132),
  ABISELECT(12512,7820),
  ABISELECT(11888,7412),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D1Ev,_ZThn400_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C18D0Ev,_ZThn400_N8S6087C18D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn19968_N8S6087C18D1Ev,_ZThn12428_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn19968_N8S6087C18D0Ev,_ZThn12428_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__A1__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-19968,-12428),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-19968,-12428),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D1Ev,_ZTv0_n36_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C18D0Ev,_ZTv0_n36_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__A2__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-20096,-12516),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev)();
extern void ABISELECT(_ZThn20608_N8S6087C18D1Ev,_ZThn12828_N8S6087C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev)();
extern void ABISELECT(_ZThn20608_N8S6087C18D0Ev,_ZThn12828_N8S6087C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__A1__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-20608,-12828),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-20608,-12828),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D1Ev,_ZTv0_n32_N8S6087C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C18D0Ev,_ZTv0_n32_N8S6087C18D0Ev),
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C188S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  ABISELECT(-20896,-13008),
  (VTBL_ENTRY)&(_ZTI8S6087C18[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn19968_N8S6087C17D1Ev,_ZThn12428_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn19968_N8S6087C17D0Ev,_ZThn12428_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-19968,-12428),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-19968,-12428),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D1Ev,_ZTv0_n36_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C17D0Ev,_ZTv0_n36_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-20096,-12516),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  ABISELECT(-12528,-7812),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn12928_N8S6087C17D1Ev,_ZThn8072_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn12928_N8S6087C17D0Ev,_ZThn8072_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-12928,-8072),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-12928,-8072),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-13152,-8220),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn13664_N8S6087C17D1Ev,_ZThn8532_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn13664_N8S6087C17D0Ev,_ZThn8532_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-13664,-8532),
  ABISELECT(-13664,-8532),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D1Ev,_ZTv0_n12_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C17D0Ev,_ZTv0_n12_N8S6087C17D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn20608_N8S6087C17D1Ev,_ZThn12828_N8S6087C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev)();
extern void ABISELECT(_ZThn20608_N8S6087C17D0Ev,_ZThn12828_N8S6087C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-20608,-12828),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-20608,-12828),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D1Ev,_ZTv0_n32_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C17D0Ev,_ZTv0_n32_N8S6087C17D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C18__A2__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(12400,7724),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev)();
extern void ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C18__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(12288,7672),
  ABISELECT(19328,12028),
  ABISELECT(13024,8132),
  ABISELECT(12512,7820),
  ABISELECT(11888,7412),
  ABISELECT(-640,-400),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D1Ev,_ZThn400_N8S6087C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N8S6087C17D0Ev,_ZThn400_N8S6087C17D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C178S6087C288S6087C26__8S6087C25[] = {
  0,
  ABISELECT(-20896,-13008),
  (VTBL_ENTRY)&(_ZTI8S6087C17[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  ABISELECT(-12688,-7896),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZThn160_N8S6087C28D1Ev,_ZThn84_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn160_N8S6087C28D0Ev,_ZThn84_N8S6087C28D0Ev)();
extern void _ZN8S6087C183v12Ev();
extern void _ZN8S6087C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C17__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(20896,13008),
  ABISELECT(20608,12828),
  ABISELECT(19968,12428),
  ABISELECT(13664,8532),
  ABISELECT(13152,8220),
  ABISELECT(12928,8072),
  ABISELECT(12528,7812),
  ABISELECT(-160,-84),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S6087C28D1Ev,_ZThn84_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S6087C28D0Ev,_ZThn84_N8S6087C28D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C183v12Ev,
  (VTBL_ENTRY)&_ZN8S6087C173v13Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN8S6087C132v9Ev();
extern void ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn20128_N8S6087C28D1Ev,_ZThn12512_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn20128_N8S6087C28D0Ev,_ZThn12512_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S6087C13__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(128,88),
  ABISELECT(128,88),
  ABISELECT(-20128,-12512),
  0,
  0,
  ABISELECT(-6304,-3896),
  ABISELECT(-6816,-4208),
  ABISELECT(-7040,-4356),
  ABISELECT(-7440,-4616),
  ABISELECT(-20128,-12512),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN8S6087C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C28D1Ev,_ZTv0_n36_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S6087C28D0Ev,_ZTv0_n36_N8S6087C28D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C13__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-7568,-4704),
  ABISELECT(-20256,-12600),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn13088_N8S6087C28D1Ev,_ZThn8156_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn13088_N8S6087C28D0Ev,_ZThn8156_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-13088,-8156),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-13088,-8156),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C288S6087C26__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-13312,-8304),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn13824_N8S6087C28D1Ev,_ZThn8616_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn13824_N8S6087C28D0Ev,_ZThn8616_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-13824,-8616),
  ABISELECT(-13824,-8616),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C28D1Ev,_ZTv0_n12_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C28D0Ev,_ZTv0_n12_N8S6087C28D0Ev),
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn20768_N8S6087C28D1Ev,_ZThn12912_N8S6087C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev)();
extern void ABISELECT(_ZThn20768_N8S6087C28D0Ev,_ZThn12912_N8S6087C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C4__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(-20768,-12912),
  0,
  0,
  ABISELECT(-6944,-4296),
  ABISELECT(-7456,-4608),
  ABISELECT(-8080,-5016),
  ABISELECT(-20768,-12912),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D1Ev,_ZTv0_n32_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C28D0Ev,_ZTv0_n32_N8S6087C28D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C188S6087C17__A2__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(12400,7724),
  ABISELECT(-288,-172),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZThn800_N8S6087C28D1Ev,_ZThn484_N8S6087C28D1Ev)();
extern void ABISELECT(_ZThn800_N8S6087C28D0Ev,_ZThn484_N8S6087C28D0Ev)();
extern void _ZN8S6087C123v10Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C128S6087C188S6087C17__8S6087C288S6087C26__8S6087C25[] = {
  ABISELECT(12288,7672),
  ABISELECT(19328,12028),
  ABISELECT(13024,8132),
  ABISELECT(12512,7820),
  ABISELECT(11888,7412),
  ABISELECT(-800,-484),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N8S6087C28D1Ev,_ZThn484_N8S6087C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N8S6087C28D0Ev,_ZThn484_N8S6087C28D0Ev),
  (VTBL_ENTRY)&_ZN8S6087C123v10Ev,
};
extern void _ZN8S6087C102v4Ev();
static  VTBL_ENTRY _tg__ZTV8S6087C10__A5__8S6087C288S6087C26__8S6087C25[] = {
  0,
  ABISELECT(-21056,-13092),
  (VTBL_ENTRY)&(_ZTI8S6087C28[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C98S6087C138S6087C14__8S6087C26__8S6087C25[] = {
  ABISELECT(16080,10040),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void _ZN7S6087C62v2Ev();
extern void _ZN7S6087C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C6__8S6087C26__8S6087C25[] = {
  0,
  0,
  ABISELECT(-16208,-10128),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN7S6087C62v2Ev,
  (VTBL_ENTRY)&_ZN7S6087C62v3Ev,
};
extern void _ZN8S6087C112v7Ev();
extern void _ZN8S6087C112v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S6087C26D1Ev,_ZTv0_n32_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn16608_N8S6087C26D1Ev,_ZThn10388_N8S6087C26D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S6087C26D0Ev,_ZTv0_n32_N8S6087C26D0Ev)();
extern void ABISELECT(_ZThn16608_N8S6087C26D0Ev,_ZThn10388_N8S6087C26D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C5__8S6087C26__8S6087C25[] = {
  ABISELECT(-16608,-10388),
  0,
  0,
  ABISELECT(736,460),
  ABISELECT(224,148),
  ABISELECT(-400,-260),
  ABISELECT(-16608,-10388),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C112v7Ev,
  (VTBL_ENTRY)&_ZN8S6087C112v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C26D1Ev,_ZTv0_n32_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S6087C26D0Ev,_ZTv0_n32_N8S6087C26D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
static  VTBL_ENTRY _tg__ZTV7S6087C9__A1__8S6087C26__8S6087C25[] = {
  0,
  0,
  0,
  ABISELECT(-624,-408),
  ABISELECT(-16832,-10536),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S6087C26D1Ev,_ZTv0_n12_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn17344_N8S6087C26D1Ev,_ZThn10848_N8S6087C26D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S6087C26D0Ev,_ZTv0_n12_N8S6087C26D0Ev)();
extern void ABISELECT(_ZThn17344_N8S6087C26D0Ev,_ZThn10848_N8S6087C26D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S6087C7__8S6087C26__8S6087C25[] = {
  ABISELECT(-17344,-10848),
  ABISELECT(-17344,-10848),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C26D1Ev,_ZTv0_n12_N8S6087C26D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S6087C26D0Ev,_ZTv0_n12_N8S6087C26D0Ev),
};
extern void _ZN8S6087C102v4Ev();
extern void _ZN7S6087C92v5Ev();
extern void _ZN7S6087C92v6Ev();
extern void ABISELECT(_ZThn2656_N8S6087C26D1Ev,_ZThn1712_N8S6087C26D1Ev)();
extern void ABISELECT(_ZThn2656_N8S6087C26D0Ev,_ZThn1712_N8S6087C26D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S6087C16__8S6087C26__8S6087C25[] = {
  ABISELECT(14880,9244),
  ABISELECT(14688,9136),
  ABISELECT(13552,8416),
  ABISELECT(-2656,-1712),
  (VTBL_ENTRY)&(_ZTI8S6087C26[0]),
  (VTBL_ENTRY)&_ZN8S6087C102v4Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v5Ev,
  (VTBL_ENTRY)&_ZN7S6087C92v6Ev,
  (VTBL_ENTRY)&ABIS