// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S17070C2_nt  {
  void *s17070c2f0[2];
  void  mf17070c2(); // _ZN11S17070C2_nt9mf17070c2Ev
};
//SIG(-1 S17070C2_nt) C1{ m Fp[2]}


void  S17070C2_nt ::mf17070c2(){}

//skip512 S17070C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C4  {
  void *s17070c4f0[2];
  void  mf17070c4(); // _ZN8S17070C49mf17070c4Ev
};
//SIG(-1 S17070C4) C1{ m Fp[2]}


void  S17070C4 ::mf17070c4(){}

static void Test_S17070C4()
{
  {
    init_simple_test("S17070C4");
    S17070C4 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C4)");
    check_field_offset(lv, s17070c4f0, 0, "S17070C4.s17070c4f0");
  }
}
static Arrange_To_Call_Me vS17070C4(Test_S17070C4, "S17070C4", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C7_nt  {
  int s17070c7f0[2];
  void  mf17070c7(); // _ZN11S17070C7_nt9mf17070c7Ev
};
//SIG(-1 S17070C7_nt) C1{ m Fi[2]}


void  S17070C7_nt ::mf17070c7(){}

//skip512 S17070C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C6  {
  int s17070c6f0;
  ::S17070C7_nt s17070c6f1;
  ::S17070C4 s17070c6f2;
  ::S17070C4 s17070c6f3;
  void  mf17070c6(); // _ZN8S17070C69mf17070c6Ev
};
//SIG(1 S17070C6) C1{ m Fi FC2{ m Fi[2]} FC3{ m Fp[2]} FC3}


void  S17070C6 ::mf17070c6(){}

static void Test_S17070C6()
{
  {
    init_simple_test("S17070C6");
    S17070C6 lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S17070C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C6)");
    check_field_offset(lv, s17070c6f0, 0, "S17070C6.s17070c6f0");
    check_field_offset(lv, s17070c6f1, 4, "S17070C6.s17070c6f1");
    check_field_offset(lv, s17070c6f2, ABISELECT(16,12), "S17070C6.s17070c6f2");
    check_field_offset(lv, s17070c6f3, ABISELECT(32,20), "S17070C6.s17070c6f3");
  }
}
static Arrange_To_Call_Me vS17070C6(Test_S17070C6, "S17070C6", ABISELECT(48,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C5  {
  ::S17070C6 s17070c5f0[3];
  void *s17070c5f1;
  void  mf17070c5(); // _ZN8S17070C59mf17070c5Ev
};
//SIG(-1 S17070C5) C1{ m FC2{ m Fi FC3{ m Fi[2]} FC4{ m Fp[2]} FC4}[3] Fp}


void  S17070C5 ::mf17070c5(){}

static void Test_S17070C5()
{
  {
    init_simple_test("S17070C5");
    S17070C5 lv;
    check2(sizeof(lv), ABISELECT(152,88), "sizeof(S17070C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C5)");
    check_field_offset(lv, s17070c5f0, 0, "S17070C5.s17070c5f0");
    check_field_offset(lv, s17070c5f1, ABISELECT(144,84), "S17070C5.s17070c5f1");
  }
}
static Arrange_To_Call_Me vS17070C5(Test_S17070C5, "S17070C5", ABISELECT(152,88));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C12_nt  {
  void *s17070c12f0[4];
  void  mf17070c12(); // _ZN12S17070C12_nt10mf17070c12Ev
};
//SIG(-1 S17070C12_nt) C1{ m Fp[4]}


void  S17070C12_nt ::mf17070c12(){}

//skip512 S17070C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C11_nt  {
  ::S17070C12_nt s17070c11f0;
  virtual  ~S17070C11_nt(); // _ZN12S17070C11_ntD1Ev
  virtual void  v7(); // _ZN12S17070C11_nt2v7Ev
  virtual void  v8(); // _ZN12S17070C11_nt2v8Ev
  virtual void  v9(); // _ZN12S17070C11_nt2v9Ev
  virtual void  v10(); // _ZN12S17070C11_nt3v10Ev
  virtual void  v11(); // _ZN12S17070C11_nt3v11Ev
  virtual void  v12(); // _ZN12S17070C11_nt3v12Ev
  S17070C11_nt(); // tgen
};
//SIG(-1 S17070C11_nt) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S17070C11_nt ::~S17070C11_nt(){ note_dtor("S17070C11_nt", this);}
void  S17070C11_nt ::v7(){vfunc_called(this, "_ZN12S17070C11_nt2v7Ev");}
void  S17070C11_nt ::v8(){vfunc_called(this, "_ZN12S17070C11_nt2v8Ev");}
void  S17070C11_nt ::v9(){vfunc_called(this, "_ZN12S17070C11_nt2v9Ev");}
void  S17070C11_nt ::v10(){vfunc_called(this, "_ZN12S17070C11_nt3v10Ev");}
void  S17070C11_nt ::v11(){vfunc_called(this, "_ZN12S17070C11_nt3v11Ev");}
void  S17070C11_nt ::v12(){vfunc_called(this, "_ZN12S17070C11_nt3v12Ev");}
S17070C11_nt ::S17070C11_nt(){ note_ctor("S17070C11_nt", this);} // tgen

//skip512 S17070C11_nt

#else // __cplusplus

extern void _ZN12S17070C11_ntC1Ev();
extern void _ZN12S17070C11_ntD1Ev();
Name_Map name_map_S17070C11_nt[] = {
  NSPAIR(_ZN12S17070C11_ntC1Ev),
  NSPAIR(_ZN12S17070C11_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern void _ZN12S17070C11_ntD1Ev();
extern void _ZN12S17070C11_ntD0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
static  VTBL_ENTRY vtc_S17070C11_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S17070C11_nt[0]),
  (VTBL_ENTRY)&_ZN12S17070C11_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
};
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
VTBL_ENTRY *P__ZTI12S17070C11_nt = _ZTI12S17070C11_nt; 
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
Class_Descriptor cd_S17070C11_nt = {  "S17070C11_nt", // class name
  0,0,//no base classes
  &(vtc_S17070C11_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI12S17070C11_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S17070C11_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C13_nt  {
};
//SIG(-1 S17070C13_nt) C1{}



//skip512 S17070C13_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S17070C13_nt[];
VTBL_ENTRY *P__ZTI12S17070C13_nt = _ZTI12S17070C13_nt; 
Class_Descriptor cd_S17070C13_nt = {  "S17070C13_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI12S17070C13_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C15_nt  {
  void *s17070c15f0;
  int s17070c15f1;
  void *s17070c15f2;
  int s17070c15f3[2];
  void  mf17070c15(); // _ZN12S17070C15_nt10mf17070c15Ev
};
//SIG(-1 S17070C15_nt) C1{ m Fp Fi Fp Fi[2]}


void  S17070C15_nt ::mf17070c15(){}

//skip512 S17070C15_nt

#else // __cplusplus

Class_Descriptor cd_S17070C15_nt = {  "S17070C15_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C18_nt  {
  __tsi64 s17070c18f0[2];
  void  mf17070c18(); // _ZN12S17070C18_nt10mf17070c18Ev
};
//SIG(-1 S17070C18_nt) C1{ m FL[2]}


void  S17070C18_nt ::mf17070c18(){}

//skip512 S17070C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C17_nt  {
  ::S17070C18_nt s17070c17f0;
  void  mf17070c17(); // _ZN12S17070C17_nt10mf17070c17Ev
};
//SIG(-1 S17070C17_nt) C1{ m FC2{ m FL[2]}}


void  S17070C17_nt ::mf17070c17(){}

//skip512 S17070C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C16_nt  {
  ::S17070C17_nt s17070c16f0;
  ::S17070C17_nt s17070c16f1;
  ::S17070C17_nt s17070c16f2;
  ::S17070C17_nt s17070c16f3;
  void  mf17070c16(); // _ZN12S17070C16_nt10mf17070c16Ev
};
//SIG(-1 S17070C16_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S17070C16_nt ::mf17070c16(){}

//skip512 S17070C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C14_nt  : S17070C15_nt {
  ::S17070C16_nt s17070c14f0;
};
//SIG(-1 S17070C14_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FC5{ m FL[2]}} FC4 FC4 FC4}}



//skip512 S17070C14_nt

#else // __cplusplus

extern Class_Descriptor cd_S17070C15_nt;
static Base_Class bases_S17070C14_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C21_nt  {
  void *s17070c21f0;
  void  mf17070c21(); // _ZN12S17070C21_nt10mf17070c21Ev
};
//SIG(-1 S17070C21_nt) C1{ m Fp}


void  S17070C21_nt ::mf17070c21(){}

//skip512 S17070C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C20_nt  {
  ::S17070C4 s17070c20f0;
  ::S17070C21_nt s17070c20f1;
  void  mf17070c20(); // _ZN12S17070C20_nt10mf17070c20Ev
};
//SIG(-1 S17070C20_nt) C1{ m FC2{ m Fp[2]} FC3{ m Fp}}


void  S17070C20_nt ::mf17070c20(){}

//skip512 S17070C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C19_nt  : S17070C15_nt {
  ::S17070C20_nt s17070c19f0;
};
//SIG(-1 S17070C19_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m Fp[2]} FC5{ m Fp}}}



//skip512 S17070C19_nt

#else // __cplusplus

extern Class_Descriptor cd_S17070C15_nt;
static Base_Class bases_S17070C19_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C24_nt  {
  __tsi64 s17070c24f0;
  void  mf17070c24(); // _ZN12S17070C24_nt10mf17070c24Ev
};
//SIG(-1 S17070C24_nt) C1{ m FL}


void  S17070C24_nt ::mf17070c24(){}

//skip512 S17070C24_nt

#else // __cplusplus

Class_Descriptor cd_S17070C24_nt = {  "S17070C24_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C23_nt  {
  ::S17070C24_nt s17070c23f0;
  void  mf17070c23(); // _ZN12S17070C23_nt10mf17070c23Ev
};
//SIG(-1 S17070C23_nt) C1{ m FC2{ m FL}}


void  S17070C23_nt ::mf17070c23(){}

//skip512 S17070C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C22_nt  : S17070C15_nt {
  ::S17070C23_nt s17070c22f0;
};
//SIG(-1 S17070C22_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL}}}



//skip512 S17070C22_nt

#else // __cplusplus

extern Class_Descriptor cd_S17070C15_nt;
static Base_Class bases_S17070C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C25_nt  : S17070C15_nt {
  int s17070c25f0;
};
//SIG(-1 S17070C25_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} Fi}



//skip512 S17070C25_nt

#else // __cplusplus

extern Class_Descriptor cd_S17070C15_nt;
static Base_Class bases_S17070C25_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C10  : S17070C11_nt , S17070C13_nt {
  ::S17070C14_nt s17070c10f0;
  ::S17070C14_nt s17070c10f1;
  ::S17070C19_nt s17070c10f2;
  ::S17070C22_nt s17070c10f3;
  ::S17070C25_nt s17070c10f4;
  virtual void  v1(); // _ZN9S17070C102v1Ev
  virtual void  v2(); // _ZN9S17070C102v2Ev
  virtual void  v3(); // _ZN9S17070C102v3Ev
  virtual void  v4(); // _ZN9S17070C102v4Ev
  virtual void  v5(); // _ZN9S17070C102v5Ev
  virtual void  v6(); // _ZN9S17070C102v6Ev
  ~S17070C10(); // tgen
  S17070C10(); // tgen
};
//SIG(-1 S17070C10) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC5 FC10{ BC6 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}} FC14{ BC6 FC15{ m FC16{ m FL}}} FC17{ BC6 Fi}}


void  S17070C10 ::v1(){vfunc_called(this, "_ZN9S17070C102v1Ev");}
void  S17070C10 ::v2(){vfunc_called(this, "_ZN9S17070C102v2Ev");}
void  S17070C10 ::v3(){vfunc_called(this, "_ZN9S17070C102v3Ev");}
void  S17070C10 ::v4(){vfunc_called(this, "_ZN9S17070C102v4Ev");}
void  S17070C10 ::v5(){vfunc_called(this, "_ZN9S17070C102v5Ev");}
void  S17070C10 ::v6(){vfunc_called(this, "_ZN9S17070C102v6Ev");}
S17070C10 ::~S17070C10(){ note_dtor("S17070C10", this);} // tgen
S17070C10 ::S17070C10(){ note_ctor("S17070C10", this);} // tgen

static void Test_S17070C10()
{
  extern Class_Descriptor cd_S17070C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S17070C10, buf);
    S17070C10 *dp, &lv = *(dp=new (buf) S17070C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S17070C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C10)");
    check_base_class_offset(lv, (S17070C11_nt*), 0, "S17070C10");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S17070C10");
    check_field_offset(lv, s17070c10f0, ABISELECT(40,20), "S17070C10.s17070c10f0");
    check_field_offset(lv, s17070c10f1, ABISELECT(136,104), "S17070C10.s17070c10f1");
    check_field_offset(lv, s17070c10f2, ABISELECT(232,188), "S17070C10.s17070c10f2");
    check_field_offset(lv, s17070c10f3, ABISELECT(288,220), "S17070C10.s17070c10f3");
    check_field_offset(lv, s17070c10f4, ABISELECT(328,248), "S17070C10.s17070c10f4");
    test_class_info(&lv, &cd_S17070C10);
    dp->~S17070C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C10(Test_S17070C10, "S17070C10", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN9S17070C10C1Ev();
extern void _ZN9S17070C10D1Ev();
Name_Map name_map_S17070C10[] = {
  NSPAIR(_ZN9S17070C10C1Ev),
  NSPAIR(_ZN9S17070C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C11_nt;
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S17070C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C10[];
extern void _ZN9S17070C10D1Ev();
extern void _ZN9S17070C10D0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
extern void _ZN9S17070C102v1Ev();
extern void _ZN9S17070C102v2Ev();
extern void _ZN9S17070C102v3Ev();
extern void _ZN9S17070C102v4Ev();
extern void _ZN9S17070C102v5Ev();
extern void _ZN9S17070C102v6Ev();
static  VTBL_ENTRY vtc_S17070C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C10[0]),
  (VTBL_ENTRY)&_ZN9S17070C10D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C10D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S17070C102v1Ev,
  (VTBL_ENTRY)&_ZN9S17070C102v2Ev,
  (VTBL_ENTRY)&_ZN9S17070C102v3Ev,
  (VTBL_ENTRY)&_ZN9S17070C102v4Ev,
  (VTBL_ENTRY)&_ZN9S17070C102v5Ev,
  (VTBL_ENTRY)&_ZN9S17070C102v6Ev,
};
extern VTBL_ENTRY _ZTI9S17070C10[];
extern  VTBL_ENTRY _ZTV9S17070C10[];
Class_Descriptor cd_S17070C10 = {  "S17070C10", // class name
  bases_S17070C10, 2,
  &(vtc_S17070C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI9S17070C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C10),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C28_nt  {
  virtual  ~S17070C28_nt(); // _ZN12S17070C28_ntD1Ev
  virtual void  v13(); // _ZN12S17070C28_nt3v13Ev
  S17070C28_nt(); // tgen
};
//SIG(-1 S17070C28_nt) C1{ vd v1}


 S17070C28_nt ::~S17070C28_nt(){ note_dtor("S17070C28_nt", this);}
void  S17070C28_nt ::v13(){vfunc_called(this, "_ZN12S17070C28_nt3v13Ev");}
S17070C28_nt ::S17070C28_nt(){ note_ctor("S17070C28_nt", this);} // tgen

//skip512 S17070C28_nt

#else // __cplusplus

extern void _ZN12S17070C28_ntC1Ev();
extern void _ZN12S17070C28_ntD1Ev();
Name_Map name_map_S17070C28_nt[] = {
  NSPAIR(_ZN12S17070C28_ntC1Ev),
  NSPAIR(_ZN12S17070C28_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S17070C28_nt[];
extern void _ZN12S17070C28_ntD1Ev();
extern void _ZN12S17070C28_ntD0Ev();
extern void _ZN12S17070C28_nt3v13Ev();
static  VTBL_ENTRY vtc_S17070C28_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S17070C28_nt[0]),
  (VTBL_ENTRY)&_ZN12S17070C28_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S17070C28_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S17070C28_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI12S17070C28_nt[];
VTBL_ENTRY *P__ZTI12S17070C28_nt = _ZTI12S17070C28_nt; 
extern  VTBL_ENTRY _ZTV12S17070C28_nt[];
Class_Descriptor cd_S17070C28_nt = {  "S17070C28_nt", // class name
  0,0,//no base classes
  &(vtc_S17070C28_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S17070C28_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S17070C28_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C31_nt  {
  void  mf17070c31(); // _ZN12S17070C31_nt10mf17070c31Ev
};
//SIG(-1 S17070C31_nt) C1{ m}


void  S17070C31_nt ::mf17070c31(){}

//skip512 S17070C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C30_nt  {
  void *s17070c30f0;
  int s17070c30f1[2];
  ::S17070C31_nt s17070c30f2;
  void  mf17070c30(); // _ZN12S17070C30_nt10mf17070c30Ev
};
//SIG(-1 S17070C30_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S17070C30_nt ::mf17070c30(){}

//skip512 S17070C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C29_nt  {
  ::S17070C30_nt s17070c29f0;
  void  mf17070c29(); // _ZN12S17070C29_nt10mf17070c29Ev
};
//SIG(-1 S17070C29_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}}}


void  S17070C29_nt ::mf17070c29(){}

//skip512 S17070C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C32  {
  void *s17070c32f0[2];
  void  mf17070c32(); // _ZN9S17070C3210mf17070c32Ev
};
//SIG(-1 S17070C32) C1{ m Fp[2]}


void  S17070C32 ::mf17070c32(){}

static void Test_S17070C32()
{
  {
    init_simple_test("S17070C32");
    S17070C32 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C32)");
    check_field_offset(lv, s17070c32f0, 0, "S17070C32.s17070c32f0");
  }
}
static Arrange_To_Call_Me vS17070C32(Test_S17070C32, "S17070C32", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C27_nt  : S17070C28_nt {
  void *s17070c27f0[2];
  ::S17070C29_nt s17070c27f1;
  ::S17070C32 s17070c27f2;
  virtual  ~S17070C27_nt(); // _ZN12S17070C27_ntD1Ev
  virtual void  v14(); // _ZN12S17070C27_nt3v14Ev
  S17070C27_nt(); // tgen
};
//SIG(-1 S17070C27_nt) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S17070C27_nt ::~S17070C27_nt(){ note_dtor("S17070C27_nt", this);}
void  S17070C27_nt ::v14(){vfunc_called(this, "_ZN12S17070C27_nt3v14Ev");}
S17070C27_nt ::S17070C27_nt(){ note_ctor("S17070C27_nt", this);} // tgen

//skip512 S17070C27_nt

#else // __cplusplus

extern void _ZN12S17070C27_ntC1Ev();
extern void _ZN12S17070C27_ntD1Ev();
Name_Map name_map_S17070C27_nt[] = {
  NSPAIR(_ZN12S17070C27_ntC1Ev),
  NSPAIR(_ZN12S17070C27_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C28_nt;
extern VTBL_ENTRY _ZTI12S17070C28_nt[];
extern  VTBL_ENTRY _ZTV12S17070C28_nt[];
static Base_Class bases_S17070C27_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S17070C27_nt[];
extern void _ZN12S17070C27_ntD1Ev();
extern void _ZN12S17070C27_ntD0Ev();
extern void _ZN12S17070C28_nt3v13Ev();
extern void _ZN12S17070C27_nt3v14Ev();
static  VTBL_ENTRY vtc_S17070C27_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S17070C27_nt[0]),
  (VTBL_ENTRY)&_ZN12S17070C27_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S17070C27_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S17070C28_nt3v13Ev,
  (VTBL_ENTRY)&_ZN12S17070C27_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI12S17070C27_nt[];
VTBL_ENTRY *P__ZTI12S17070C27_nt = _ZTI12S17070C27_nt; 
extern  VTBL_ENTRY _ZTV12S17070C27_nt[];
Class_Descriptor cd_S17070C27_nt = {  "S17070C27_nt", // class name
  bases_S17070C27_nt, 1,
  &(vtc_S17070C27_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI12S17070C27_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV12S17070C27_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C34_nt  {
  short s17070c34f0[2];
  char s17070c34f1[2];
  short s17070c34f2;
};
//SIG(1 S17070C34_nt) C1{ Fs[2] Fc[2] Fs}



//skip512 S17070C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C35_nt  {
  short s17070c35f0[2];
};
//SIG(1 S17070C35_nt) C1{ Fs[2]}



//skip512 S17070C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C33_nt  {
  ::S17070C34_nt s17070c33f0[12];
  int s17070c33f1;
  ::S17070C35_nt s17070c33f2[4];
  int s17070c33f3;
  ::S17070C32 s17070c33f4;
  void  mf17070c33(); // _ZN12S17070C33_nt10mf17070c33Ev
};
//SIG(-1 S17070C33_nt) C1{ m FC2{ Fs[2] Fc[2] Fs}[12] Fi FC3{ Fs[2]}[4] Fi FC4{ m Fp[2]}}


void  S17070C33_nt ::mf17070c33(){}

//skip512 S17070C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C26_nt  : S17070C27_nt {
  ::S17070C33_nt s17070c26f0;
  virtual  ~S17070C26_nt(); // _ZN12S17070C26_ntD1Ev
  S17070C26_nt(); // tgen
};
//SIG(-1 S17070C26_nt) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m FC9{ Fs[2] Fc[2] Fs}[12] Fi FC10{ Fs[2]}[4] Fi FC7}}


 S17070C26_nt ::~S17070C26_nt(){ note_dtor("S17070C26_nt", this);}
S17070C26_nt ::S17070C26_nt(){ note_ctor("S17070C26_nt", this);} // tgen

//skip512 S17070C26_nt

#else // __cplusplus

extern void _ZN12S17070C26_ntC1Ev();
extern void _ZN12S17070C26_ntD1Ev();
Name_Map name_map_S17070C26_nt[] = {
  NSPAIR(_ZN12S17070C26_ntC1Ev),
  NSPAIR(_ZN12S17070C26_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C28_nt;
extern VTBL_ENTRY _ZTI12S17070C28_nt[];
extern  VTBL_ENTRY _ZTV12S17070C28_nt[];
extern Class_Descriptor cd_S17070C27_nt;
extern VTBL_ENTRY _ZTI12S17070C27_nt[];
extern  VTBL_ENTRY _ZTV12S17070C27_nt[];
static Base_Class bases_S17070C26_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C27_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S17070C26_nt[];
extern void _ZN12S17070C26_ntD1Ev();
extern void _ZN12S17070C26_ntD0Ev();
extern void _ZN12S17070C28_nt3v13Ev();
extern void _ZN12S17070C27_nt3v14Ev();
static  VTBL_ENTRY vtc_S17070C26_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S17070C26_nt[0]),
  (VTBL_ENTRY)&_ZN12S17070C26_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S17070C26_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S17070C28_nt3v13Ev,
  (VTBL_ENTRY)&_ZN12S17070C27_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI12S17070C26_nt[];
VTBL_ENTRY *P__ZTI12S17070C26_nt = _ZTI12S17070C26_nt; 
extern  VTBL_ENTRY _ZTV12S17070C26_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C9  {
  ::S17070C10 s17070c9f0;
  ::S17070C26_nt s17070c9f1;
  void  mf17070c9(); // _ZN8S17070C99mf17070c9Ev
};
//SIG(-1 S17070C9) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC6 FC11{ BC7 FC12{ m FC13{ m Fp[2]} FC14{ m Fp}}} FC15{ BC7 FC16{ m FC17{ m FL}}} FC18{ BC7 Fi}} FC19{ BC20{ BC21{ vd v13} vd v14 Fp[2] FC22{ m FC23{ m Fp Fi[2] FC24{ m}}} FC25{ m Fp[2]}} vd FC26{ m FC27{ Fs[2] Fc[2] Fs}[12] Fi FC28{ Fs[2]}[4] Fi FC25}}}


void  S17070C9 ::mf17070c9(){}

static void Test_S17070C9()
{
  {
    init_simple_test("S17070C9");
    S17070C9 lv;
    check2(sizeof(lv), ABISELECT(568,436), "sizeof(S17070C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C9)");
    check_field_offset(lv, s17070c9f0, 0, "S17070C9.s17070c9f0");
    check_field_offset(lv, s17070c9f1, ABISELECT(368,272), "S17070C9.s17070c9f1");
  }
}
static Arrange_To_Call_Me vS17070C9(Test_S17070C9, "S17070C9", ABISELECT(568,436));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C38  : S17070C11_nt , S17070C13_nt {
  ::S17070C19_nt s17070c38f0;
  virtual void  v15(); // _ZN9S17070C383v15Ev
  virtual void  v16(); // _ZN9S17070C383v16Ev
  virtual void  v17(); // _ZN9S17070C383v17Ev
  virtual void  v18(); // _ZN9S17070C383v18Ev
  virtual void  v19(); // _ZN9S17070C383v19Ev
  virtual void  v20(); // _ZN9S17070C383v20Ev
  ~S17070C38(); // tgen
  S17070C38(); // tgen
};
//SIG(-1 S17070C38) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}}}


void  S17070C38 ::v15(){vfunc_called(this, "_ZN9S17070C383v15Ev");}
void  S17070C38 ::v16(){vfunc_called(this, "_ZN9S17070C383v16Ev");}
void  S17070C38 ::v17(){vfunc_called(this, "_ZN9S17070C383v17Ev");}
void  S17070C38 ::v18(){vfunc_called(this, "_ZN9S17070C383v18Ev");}
void  S17070C38 ::v19(){vfunc_called(this, "_ZN9S17070C383v19Ev");}
void  S17070C38 ::v20(){vfunc_called(this, "_ZN9S17070C383v20Ev");}
S17070C38 ::~S17070C38(){ note_dtor("S17070C38", this);} // tgen
S17070C38 ::S17070C38(){ note_ctor("S17070C38", this);} // tgen

static void Test_S17070C38()
{
  extern Class_Descriptor cd_S17070C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,14)];
    init_test(&cd_S17070C38, buf);
    S17070C38 *dp, &lv = *(dp=new (buf) S17070C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,52), "sizeof(S17070C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C38)");
    check_base_class_offset(lv, (S17070C11_nt*), 0, "S17070C38");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S17070C38");
    check_field_offset(lv, s17070c38f0, ABISELECT(40,20), "S17070C38.s17070c38f0");
    test_class_info(&lv, &cd_S17070C38);
    dp->~S17070C38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C38(Test_S17070C38, "S17070C38", ABISELECT(96,52));

#else // __cplusplus

extern void _ZN9S17070C38C1Ev();
extern void _ZN9S17070C38D1Ev();
Name_Map name_map_S17070C38[] = {
  NSPAIR(_ZN9S17070C38C1Ev),
  NSPAIR(_ZN9S17070C38D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C11_nt;
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S17070C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C38[];
extern void _ZN9S17070C38D1Ev();
extern void _ZN9S17070C38D0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
extern void _ZN9S17070C383v15Ev();
extern void _ZN9S17070C383v16Ev();
extern void _ZN9S17070C383v17Ev();
extern void _ZN9S17070C383v18Ev();
extern void _ZN9S17070C383v19Ev();
extern void _ZN9S17070C383v20Ev();
static  VTBL_ENTRY vtc_S17070C38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C38[0]),
  (VTBL_ENTRY)&_ZN9S17070C38D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C38D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S17070C383v15Ev,
  (VTBL_ENTRY)&_ZN9S17070C383v16Ev,
  (VTBL_ENTRY)&_ZN9S17070C383v17Ev,
  (VTBL_ENTRY)&_ZN9S17070C383v18Ev,
  (VTBL_ENTRY)&_ZN9S17070C383v19Ev,
  (VTBL_ENTRY)&_ZN9S17070C383v20Ev,
};
extern VTBL_ENTRY _ZTI9S17070C38[];
extern  VTBL_ENTRY _ZTV9S17070C38[];
Class_Descriptor cd_S17070C38 = {  "S17070C38", // class name
  bases_S17070C38, 2,
  &(vtc_S17070C38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,52), // object size
  NSPAIRA(_ZTI9S17070C38),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C38),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C44  {
  void *s17070c44f0[2];
  void  mf17070c44(); // _ZN9S17070C4410mf17070c44Ev
};
//SIG(-1 S17070C44) C1{ m Fp[2]}


void  S17070C44 ::mf17070c44(){}

static void Test_S17070C44()
{
  {
    init_simple_test("S17070C44");
    S17070C44 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C44)");
    check_field_offset(lv, s17070c44f0, 0, "S17070C44.s17070c44f0");
  }
}
static Arrange_To_Call_Me vS17070C44(Test_S17070C44, "S17070C44", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C40  : S17070C28_nt {
  void *s17070c40f0[2];
  ::S17070C29_nt s17070c40f1;
  ::S17070C44 s17070c40f2;
  virtual  ~S17070C40(); // _ZN9S17070C40D1Ev
  virtual void  v21(); // _ZN9S17070C403v21Ev
  S17070C40(); // tgen
};
//SIG(-1 S17070C40) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S17070C40 ::~S17070C40(){ note_dtor("S17070C40", this);}
void  S17070C40 ::v21(){vfunc_called(this, "_ZN9S17070C403v21Ev");}
S17070C40 ::S17070C40(){ note_ctor("S17070C40", this);} // tgen

static void Test_S17070C40()
{
  extern Class_Descriptor cd_S17070C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S17070C40, buf);
    S17070C40 *dp, &lv = *(dp=new (buf) S17070C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S17070C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C40)");
    check_base_class_offset(lv, (S17070C28_nt*), 0, "S17070C40");
    check_field_offset(lv, s17070c40f0, ABISELECT(8,4), "S17070C40.s17070c40f0");
    check_field_offset(lv, s17070c40f1, ABISELECT(24,12), "S17070C40.s17070c40f1");
    check_field_offset(lv, s17070c40f2, ABISELECT(48,28), "S17070C40.s17070c40f2");
    test_class_info(&lv, &cd_S17070C40);
    dp->~S17070C40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C40(Test_S17070C40, "S17070C40", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN9S17070C40C1Ev();
extern void _ZN9S17070C40D1Ev();
Name_Map name_map_S17070C40[] = {
  NSPAIR(_ZN9S17070C40C1Ev),
  NSPAIR(_ZN9S17070C40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C28_nt;
extern VTBL_ENTRY _ZTI12S17070C28_nt[];
extern  VTBL_ENTRY _ZTV12S17070C28_nt[];
static Base_Class bases_S17070C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C40[];
extern void _ZN9S17070C40D1Ev();
extern void _ZN9S17070C40D0Ev();
extern void _ZN12S17070C28_nt3v13Ev();
extern void _ZN9S17070C403v21Ev();
static  VTBL_ENTRY vtc_S17070C40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C40[0]),
  (VTBL_ENTRY)&_ZN9S17070C40D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C40D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C28_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S17070C403v21Ev,
};
extern VTBL_ENTRY _ZTI9S17070C40[];
extern  VTBL_ENTRY _ZTV9S17070C40[];
Class_Descriptor cd_S17070C40 = {  "S17070C40", // class name
  bases_S17070C40, 1,
  &(vtc_S17070C40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI9S17070C40),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17070C40),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C46_nt  {
  char s17070c46f0;
  char s17070c46f1:4;
  char s17070c46f2:4;
  char s17070c46f3:4;
  char s17070c46f4:4;
  char s17070c46f5:4;
  char s17070c46f6:4;
};
//SIG(-1 S17070C46_nt) C1{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4}



//skip512 S17070C46_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C45_nt  {
  void *s17070c45f0;
  int s17070c45f1;
  ::S17070C46_nt s17070c45f2;
  int s17070c45f3;
  ::S17070C32 s17070c45f4;
  void  mf17070c45(); // _ZN12S17070C45_nt10mf17070c45Ev
};
//SIG(-1 S17070C45_nt) C1{ m Fp Fi FC2{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC3{ m Fp[2]}}


void  S17070C45_nt ::mf17070c45(){}

//skip512 S17070C45_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C39_nt  : S17070C40 {
  ::S17070C45_nt s17070c39f0;
  virtual  ~S17070C39_nt(); // _ZN12S17070C39_ntD1Ev
  S17070C39_nt(); // tgen
};
//SIG(-1 S17070C39_nt) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m Fp Fi FC9{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC10{ m Fp[2]}}}


 S17070C39_nt ::~S17070C39_nt(){ note_dtor("S17070C39_nt", this);}
S17070C39_nt ::S17070C39_nt(){ note_ctor("S17070C39_nt", this);} // tgen

//skip512 S17070C39_nt

#else // __cplusplus

extern void _ZN12S17070C39_ntC1Ev();
extern void _ZN12S17070C39_ntD1Ev();
Name_Map name_map_S17070C39_nt[] = {
  NSPAIR(_ZN12S17070C39_ntC1Ev),
  NSPAIR(_ZN12S17070C39_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C28_nt;
extern VTBL_ENTRY _ZTI12S17070C28_nt[];
extern  VTBL_ENTRY _ZTV12S17070C28_nt[];
extern Class_Descriptor cd_S17070C40;
extern VTBL_ENTRY _ZTI9S17070C40[];
extern  VTBL_ENTRY _ZTV9S17070C40[];
static Base_Class bases_S17070C39_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S17070C39_nt[];
extern void _ZN12S17070C39_ntD1Ev();
extern void _ZN12S17070C39_ntD0Ev();
extern void _ZN12S17070C28_nt3v13Ev();
extern void _ZN9S17070C403v21Ev();
static  VTBL_ENTRY vtc_S17070C39_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S17070C39_nt[0]),
  (VTBL_ENTRY)&_ZN12S17070C39_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S17070C39_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S17070C28_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S17070C403v21Ev,
};
extern VTBL_ENTRY _ZTI12S17070C39_nt[];
VTBL_ENTRY *P__ZTI12S17070C39_nt = _ZTI12S17070C39_nt; 
extern  VTBL_ENTRY _ZTV12S17070C39_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C37  {
  ::S17070C38 s17070c37f0;
  ::S17070C39_nt s17070c37f1;
  void  mf17070c37(); // _ZN9S17070C3710mf17070c37Ev
};
//SIG(-1 S17070C37) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}}} FC11{ BC12{ BC13{ vd v13} vd v14 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC17{ m Fp[2]}} vd FC18{ m Fp Fi FC19{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20{ m Fp[2]}}}}


void  S17070C37 ::mf17070c37(){}

static void Test_S17070C37()
{
  {
    init_simple_test("S17070C37");
    static S17070C37 lv;
    check2(sizeof(lv), ABISELECT(200,112), "sizeof(S17070C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C37)");
    check_field_offset(lv, s17070c37f0, 0, "S17070C37.s17070c37f0");
    check_field_offset(lv, s17070c37f1, ABISELECT(96,52), "S17070C37.s17070c37f1");
  }
}
static Arrange_To_Call_Me vS17070C37(Test_S17070C37, "S17070C37", ABISELECT(200,112));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C48  : S17070C11_nt , S17070C13_nt {
  ::S17070C14_nt s17070c48f0;
  virtual void  v22(); // _ZN9S17070C483v22Ev
  virtual void  v23(); // _ZN9S17070C483v23Ev
  virtual void  v24(); // _ZN9S17070C483v24Ev
  virtual void  v25(); // _ZN9S17070C483v25Ev
  virtual void  v26(); // _ZN9S17070C483v26Ev
  virtual void  v27(); // _ZN9S17070C483v27Ev
  ~S17070C48(); // tgen
  S17070C48(); // tgen
};
//SIG(-1 S17070C48) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}}}


void  S17070C48 ::v22(){vfunc_called(this, "_ZN9S17070C483v22Ev");}
void  S17070C48 ::v23(){vfunc_called(this, "_ZN9S17070C483v23Ev");}
void  S17070C48 ::v24(){vfunc_called(this, "_ZN9S17070C483v24Ev");}
void  S17070C48 ::v25(){vfunc_called(this, "_ZN9S17070C483v25Ev");}
void  S17070C48 ::v26(){vfunc_called(this, "_ZN9S17070C483v26Ev");}
void  S17070C48 ::v27(){vfunc_called(this, "_ZN9S17070C483v27Ev");}
S17070C48 ::~S17070C48(){ note_dtor("S17070C48", this);} // tgen
S17070C48 ::S17070C48(){ note_ctor("S17070C48", this);} // tgen

static void Test_S17070C48()
{
  extern Class_Descriptor cd_S17070C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,27)];
    init_test(&cd_S17070C48, buf);
    S17070C48 *dp, &lv = *(dp=new (buf) S17070C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,104), "sizeof(S17070C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C48)");
    check_base_class_offset(lv, (S17070C11_nt*), 0, "S17070C48");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S17070C48");
    check_field_offset(lv, s17070c48f0, ABISELECT(40,20), "S17070C48.s17070c48f0");
    test_class_info(&lv, &cd_S17070C48);
    dp->~S17070C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C48(Test_S17070C48, "S17070C48", ABISELECT(136,104));

#else // __cplusplus

extern void _ZN9S17070C48C1Ev();
extern void _ZN9S17070C48D1Ev();
Name_Map name_map_S17070C48[] = {
  NSPAIR(_ZN9S17070C48C1Ev),
  NSPAIR(_ZN9S17070C48D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C11_nt;
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S17070C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C48[];
extern void _ZN9S17070C48D1Ev();
extern void _ZN9S17070C48D0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
extern void _ZN9S17070C483v22Ev();
extern void _ZN9S17070C483v23Ev();
extern void _ZN9S17070C483v24Ev();
extern void _ZN9S17070C483v25Ev();
extern void _ZN9S17070C483v26Ev();
extern void _ZN9S17070C483v27Ev();
static  VTBL_ENTRY vtc_S17070C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C48[0]),
  (VTBL_ENTRY)&_ZN9S17070C48D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C48D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S17070C483v22Ev,
  (VTBL_ENTRY)&_ZN9S17070C483v23Ev,
  (VTBL_ENTRY)&_ZN9S17070C483v24Ev,
  (VTBL_ENTRY)&_ZN9S17070C483v25Ev,
  (VTBL_ENTRY)&_ZN9S17070C483v26Ev,
  (VTBL_ENTRY)&_ZN9S17070C483v27Ev,
};
extern VTBL_ENTRY _ZTI9S17070C48[];
extern  VTBL_ENTRY _ZTV9S17070C48[];
Class_Descriptor cd_S17070C48 = {  "S17070C48", // class name
  bases_S17070C48, 2,
  &(vtc_S17070C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,104), // object size
  NSPAIRA(_ZTI9S17070C48),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C48),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C47  {
  ::S17070C48 s17070c47f0;
  ::S17070C26_nt s17070c47f1;
  void  mf17070c47(); // _ZN9S17070C4710mf17070c47Ev
};
//SIG(-1 S17070C47) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}}} FC11{ BC12{ BC13{ vd v13} vd v14 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC17{ m Fp[2]}} vd FC18{ m FC19{ Fs[2] Fc[2] Fs}[12] Fi FC20{ Fs[2]}[4] Fi FC17}}}


void  S17070C47 ::mf17070c47(){}

static void Test_S17070C47()
{
  {
    init_simple_test("S17070C47");
    S17070C47 lv;
    check2(sizeof(lv), ABISELECT(336,268), "sizeof(S17070C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C47)");
    check_field_offset(lv, s17070c47f0, 0, "S17070C47.s17070c47f0");
    check_field_offset(lv, s17070c47f1, ABISELECT(136,104), "S17070C47.s17070c47f1");
  }
}
static Arrange_To_Call_Me vS17070C47(Test_S17070C47, "S17070C47", ABISELECT(336,268));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C51_nt  : S17070C15_nt {
  ::S17070C17_nt s17070c51f0;
};
//SIG(-1 S17070C51_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL[2]}}}



//skip512 S17070C51_nt

#else // __cplusplus

extern Class_Descriptor cd_S17070C15_nt;
static Base_Class bases_S17070C51_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C50  : S17070C11_nt , S17070C13_nt {
  ::S17070C19_nt s17070c50f0;
  ::S17070C25_nt s17070c50f1;
  ::S17070C22_nt s17070c50f2;
  ::S17070C51_nt s17070c50f3;
  ::S17070C51_nt s17070c50f4;
  ::S17070C14_nt s17070c50f5;
  ::S17070C51_nt s17070c50f6;
  virtual void  v28(); // _ZN9S17070C503v28Ev
  virtual void  v29(); // _ZN9S17070C503v29Ev
  virtual void  v30(); // _ZN9S17070C503v30Ev
  virtual void  v31(); // _ZN9S17070C503v31Ev
  virtual void  v32(); // _ZN9S17070C503v32Ev
  virtual void  v33(); // _ZN9S17070C503v33Ev
  ~S17070C50(); // tgen
  S17070C50(); // tgen
};
//SIG(-1 S17070C50) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 Fi} FC11{ BC6 FC12{ m FC13{ m FL}}} FC14{ BC6 FC15{ m FC16{ m FL[2]}}} FC14 FC17{ BC6 FC18{ m FC15 FC15 FC15 FC15}} FC14}


void  S17070C50 ::v28(){vfunc_called(this, "_ZN9S17070C503v28Ev");}
void  S17070C50 ::v29(){vfunc_called(this, "_ZN9S17070C503v29Ev");}
void  S17070C50 ::v30(){vfunc_called(this, "_ZN9S17070C503v30Ev");}
void  S17070C50 ::v31(){vfunc_called(this, "_ZN9S17070C503v31Ev");}
void  S17070C50 ::v32(){vfunc_called(this, "_ZN9S17070C503v32Ev");}
void  S17070C50 ::v33(){vfunc_called(this, "_ZN9S17070C503v33Ev");}
S17070C50 ::~S17070C50(){ note_dtor("S17070C50", this);} // tgen
S17070C50 ::S17070C50(){ note_ctor("S17070C50", this);} // tgen

static void Test_S17070C50()
{
  extern Class_Descriptor cd_S17070C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(53,75)];
    init_test(&cd_S17070C50, buf);
    S17070C50 *dp, &lv = *(dp=new (buf) S17070C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,296), "sizeof(S17070C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C50)");
    check_base_class_offset(lv, (S17070C11_nt*), 0, "S17070C50");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S17070C50");
    check_field_offset(lv, s17070c50f0, ABISELECT(40,20), "S17070C50.s17070c50f0");
    check_field_offset(lv, s17070c50f1, ABISELECT(96,52), "S17070C50.s17070c50f1");
    check_field_offset(lv, s17070c50f2, ABISELECT(136,76), "S17070C50.s17070c50f2");
    check_field_offset(lv, s17070c50f3, ABISELECT(176,104), "S17070C50.s17070c50f3");
    check_field_offset(lv, s17070c50f4, ABISELECT(224,140), "S17070C50.s17070c50f4");
    check_field_offset(lv, s17070c50f5, ABISELECT(272,176), "S17070C50.s17070c50f5");
    check_field_offset(lv, s17070c50f6, ABISELECT(368,260), "S17070C50.s17070c50f6");
    test_class_info(&lv, &cd_S17070C50);
    dp->~S17070C50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C50(Test_S17070C50, "S17070C50", ABISELECT(416,296));

#else // __cplusplus

extern void _ZN9S17070C50C1Ev();
extern void _ZN9S17070C50D1Ev();
Name_Map name_map_S17070C50[] = {
  NSPAIR(_ZN9S17070C50C1Ev),
  NSPAIR(_ZN9S17070C50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C11_nt;
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S17070C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C50[];
extern void _ZN9S17070C50D1Ev();
extern void _ZN9S17070C50D0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
extern void _ZN9S17070C503v28Ev();
extern void _ZN9S17070C503v29Ev();
extern void _ZN9S17070C503v30Ev();
extern void _ZN9S17070C503v31Ev();
extern void _ZN9S17070C503v32Ev();
extern void _ZN9S17070C503v33Ev();
static  VTBL_ENTRY vtc_S17070C50[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C50[0]),
  (VTBL_ENTRY)&_ZN9S17070C50D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C50D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S17070C503v28Ev,
  (VTBL_ENTRY)&_ZN9S17070C503v29Ev,
  (VTBL_ENTRY)&_ZN9S17070C503v30Ev,
  (VTBL_ENTRY)&_ZN9S17070C503v31Ev,
  (VTBL_ENTRY)&_ZN9S17070C503v32Ev,
  (VTBL_ENTRY)&_ZN9S17070C503v33Ev,
};
extern VTBL_ENTRY _ZTI9S17070C50[];
extern  VTBL_ENTRY _ZTV9S17070C50[];
Class_Descriptor cd_S17070C50 = {  "S17070C50", // class name
  bases_S17070C50, 2,
  &(vtc_S17070C50[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(416,296), // object size
  NSPAIRA(_ZTI9S17070C50),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C50),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C49  {
  ::S17070C50 s17070c49f0;
  ::S17070C39_nt s17070c49f1;
  void  mf17070c49(); // _ZN9S17070C4910mf17070c49Ev
};
//SIG(-1 S17070C49) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 Fi} FC12{ BC7 FC13{ m FC14{ m FL}}} FC15{ BC7 FC16{ m FC17{ m FL[2]}}} FC15 FC18{ BC7 FC19{ m FC16 FC16 FC16 FC16}} FC15} FC20{ BC21{ BC22{ vd v13} vd v14 Fp[2] FC23{ m FC24{ m Fp Fi[2] FC25{ m}}} FC26{ m Fp[2]}} vd FC27{ m Fp Fi FC28{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC29{ m Fp[2]}}}}


void  S17070C49 ::mf17070c49(){}

static void Test_S17070C49()
{
  {
    init_simple_test("S17070C49");
    static S17070C49 lv;
    check2(sizeof(lv), ABISELECT(520,356), "sizeof(S17070C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C49)");
    check_field_offset(lv, s17070c49f0, 0, "S17070C49.s17070c49f0");
    check_field_offset(lv, s17070c49f1, ABISELECT(416,296), "S17070C49.s17070c49f1");
  }
}
static Arrange_To_Call_Me vS17070C49(Test_S17070C49, "S17070C49", ABISELECT(520,356));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C56  : S17070C11_nt , S17070C13_nt {
  ::S17070C14_nt s17070c56f0;
  ::S17070C19_nt s17070c56f1;
  ::S17070C19_nt s17070c56f2;
  ::S17070C22_nt s17070c56f3;
  ::S17070C51_nt s17070c56f4;
  ::S17070C14_nt s17070c56f5;
  ::S17070C14_nt s17070c56f6;
  ::S17070C14_nt s17070c56f7;
  ::S17070C51_nt s17070c56f8;
  ::S17070C51_nt s17070c56f9;
  ::S17070C14_nt s17070c56f10;
  ::S17070C22_nt s17070c56f11;
  virtual void  v34(); // _ZN9S17070C563v34Ev
  virtual void  v35(); // _ZN9S17070C563v35Ev
  virtual void  v36(); // _ZN9S17070C563v36Ev
  virtual void  v37(); // _ZN9S17070C563v37Ev
  virtual void  v38(); // _ZN9S17070C563v38Ev
  virtual void  v39(); // _ZN9S17070C563v39Ev
  ~S17070C56(); // tgen
  S17070C56(); // tgen
};
//SIG(-1 S17070C56) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}} FC10 FC14{ BC6 FC15{ m FC16{ m FL}}} FC17{ BC6 FC8} FC5 FC5 FC5 FC17 FC17 FC5 FC14}


void  S17070C56 ::v34(){vfunc_called(this, "_ZN9S17070C563v34Ev");}
void  S17070C56 ::v35(){vfunc_called(this, "_ZN9S17070C563v35Ev");}
void  S17070C56 ::v36(){vfunc_called(this, "_ZN9S17070C563v36Ev");}
void  S17070C56 ::v37(){vfunc_called(this, "_ZN9S17070C563v37Ev");}
void  S17070C56 ::v38(){vfunc_called(this, "_ZN9S17070C563v38Ev");}
void  S17070C56 ::v39(){vfunc_called(this, "_ZN9S17070C563v39Ev");}
S17070C56 ::~S17070C56(){ note_dtor("S17070C56", this);} // tgen
S17070C56 ::S17070C56(){ note_ctor("S17070C56", this);} // tgen

static void Test_S17070C56()
{
  extern Class_Descriptor cd_S17070C56;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(108,168)];
    init_test(&cd_S17070C56, buf);
    S17070C56 *dp, &lv = *(dp=new (buf) S17070C56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(856,668), "sizeof(S17070C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C56)");
    check_base_class_offset(lv, (S17070C11_nt*), 0, "S17070C56");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S17070C56");
    check_field_offset(lv, s17070c56f0, ABISELECT(40,20), "S17070C56.s17070c56f0");
    check_field_offset(lv, s17070c56f1, ABISELECT(136,104), "S17070C56.s17070c56f1");
    check_field_offset(lv, s17070c56f2, ABISELECT(192,136), "S17070C56.s17070c56f2");
    check_field_offset(lv, s17070c56f3, ABISELECT(248,168), "S17070C56.s17070c56f3");
    check_field_offset(lv, s17070c56f4, ABISELECT(288,196), "S17070C56.s17070c56f4");
    check_field_offset(lv, s17070c56f5, ABISELECT(336,232), "S17070C56.s17070c56f5");
    check_field_offset(lv, s17070c56f6, ABISELECT(432,316), "S17070C56.s17070c56f6");
    check_field_offset(lv, s17070c56f7, ABISELECT(528,400), "S17070C56.s17070c56f7");
    check_field_offset(lv, s17070c56f8, ABISELECT(624,484), "S17070C56.s17070c56f8");
    check_field_offset(lv, s17070c56f9, ABISELECT(672,520), "S17070C56.s17070c56f9");
    check_field_offset(lv, s17070c56f10, ABISELECT(720,556), "S17070C56.s17070c56f10");
    check_field_offset(lv, s17070c56f11, ABISELECT(816,640), "S17070C56.s17070c56f11");
    test_class_info(&lv, &cd_S17070C56);
    dp->~S17070C56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C56(Test_S17070C56, "S17070C56", ABISELECT(856,668));

#else // __cplusplus

extern void _ZN9S17070C56C1Ev();
extern void _ZN9S17070C56D1Ev();
Name_Map name_map_S17070C56[] = {
  NSPAIR(_ZN9S17070C56C1Ev),
  NSPAIR(_ZN9S17070C56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C11_nt;
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S17070C56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C56[];
extern void _ZN9S17070C56D1Ev();
extern void _ZN9S17070C56D0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
extern void _ZN9S17070C563v34Ev();
extern void _ZN9S17070C563v35Ev();
extern void _ZN9S17070C563v36Ev();
extern void _ZN9S17070C563v37Ev();
extern void _ZN9S17070C563v38Ev();
extern void _ZN9S17070C563v39Ev();
static  VTBL_ENTRY vtc_S17070C56[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C56[0]),
  (VTBL_ENTRY)&_ZN9S17070C56D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C56D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S17070C563v34Ev,
  (VTBL_ENTRY)&_ZN9S17070C563v35Ev,
  (VTBL_ENTRY)&_ZN9S17070C563v36Ev,
  (VTBL_ENTRY)&_ZN9S17070C563v37Ev,
  (VTBL_ENTRY)&_ZN9S17070C563v38Ev,
  (VTBL_ENTRY)&_ZN9S17070C563v39Ev,
};
extern VTBL_ENTRY _ZTI9S17070C56[];
extern  VTBL_ENTRY _ZTV9S17070C56[];
Class_Descriptor cd_S17070C56 = {  "S17070C56", // class name
  bases_S17070C56, 2,
  &(vtc_S17070C56[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(856,668), // object size
  NSPAIRA(_ZTI9S17070C56),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C56),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C55  {
  ::S17070C56 s17070c55f0;
  ::S17070C39_nt s17070c55f1;
  void  mf17070c55(); // _ZN9S17070C5510mf17070c55Ev
};
//SIG(-1 S17070C55) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m Fp[2]} FC14{ m Fp}}} FC11 FC15{ BC7 FC16{ m FC17{ m FL}}} FC18{ BC7 FC9} FC6 FC6 FC6 FC18 FC18 FC6 FC15} FC19{ BC20{ BC21{ vd v13} vd v14 Fp[2] FC22{ m FC23{ m Fp Fi[2] FC24{ m}}} FC25{ m Fp[2]}} vd FC26{ m Fp Fi FC27{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC28{ m Fp[2]}}}}


void  S17070C55 ::mf17070c55(){}

static void Test_S17070C55()
{
  {
    init_simple_test("S17070C55");
    static S17070C55 lv;
    check2(sizeof(lv), ABISELECT(960,728), "sizeof(S17070C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C55)");
    check_field_offset(lv, s17070c55f0, 0, "S17070C55.s17070c55f0");
    check_field_offset(lv, s17070c55f1, ABISELECT(856,668), "S17070C55.s17070c55f1");
  }
}
static Arrange_To_Call_Me vS17070C55(Test_S17070C55, "S17070C55", ABISELECT(960,728));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C57  {
  ::S17070C44 s17070c57f0;
  void  mf17070c57(); // _ZN9S17070C5710mf17070c57Ev
};
//SIG(-1 S17070C57) C1{ m FC2{ m Fp[2]}}


void  S17070C57 ::mf17070c57(){}

static void Test_S17070C57()
{
  {
    init_simple_test("S17070C57");
    S17070C57 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C57)");
    check_field_offset(lv, s17070c57f0, 0, "S17070C57.s17070c57f0");
  }
}
static Arrange_To_Call_Me vS17070C57(Test_S17070C57, "S17070C57", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C62  {
  void *s17070c62f0[2];
  void  mf17070c62(); // _ZN9S17070C6210mf17070c62Ev
};
//SIG(-1 S17070C62) C1{ m Fp[2]}


void  S17070C62 ::mf17070c62(){}

static void Test_S17070C62()
{
  {
    init_simple_test("S17070C62");
    S17070C62 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C62)");
    check_field_offset(lv, s17070c62f0, 0, "S17070C62.s17070c62f0");
  }
}
static Arrange_To_Call_Me vS17070C62(Test_S17070C62, "S17070C62", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C61  {
  ::S17070C62 s17070c61f0;
  int s17070c61f1;
  void  mf17070c61(); // _ZN9S17070C6110mf17070c61Ev
};
//SIG(-1 S17070C61) C1{ m FC2{ m Fp[2]} Fi}


void  S17070C61 ::mf17070c61(){}

static void Test_S17070C61()
{
  {
    init_simple_test("S17070C61");
    S17070C61 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17070C61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C61)");
    check_field_offset(lv, s17070c61f0, 0, "S17070C61.s17070c61f0");
    check_field_offset(lv, s17070c61f1, ABISELECT(16,8), "S17070C61.s17070c61f1");
  }
}
static Arrange_To_Call_Me vS17070C61(Test_S17070C61, "S17070C61", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C65  {
  void *s17070c65f0[2];
  void  mf17070c65(); // _ZN9S17070C6510mf17070c65Ev
};
//SIG(-1 S17070C65) C1{ m Fp[2]}


void  S17070C65 ::mf17070c65(){}

static void Test_S17070C65()
{
  {
    init_simple_test("S17070C65");
    S17070C65 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C65)");
    check_field_offset(lv, s17070c65f0, 0, "S17070C65.s17070c65f0");
  }
}
static Arrange_To_Call_Me vS17070C65(Test_S17070C65, "S17070C65", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C63  {
  ::S17070C62 s17070c63f0;
  ::S17070C65 s17070c63f1;
  void  mf17070c63(); // _ZN9S17070C6310mf17070c63Ev
};
//SIG(-1 S17070C63) C1{ m FC2{ m Fp[2]} FC3{ m Fp[2]}}


void  S17070C63 ::mf17070c63(){}

static void Test_S17070C63()
{
  {
    init_simple_test("S17070C63");
    S17070C63 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17070C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C63)");
    check_field_offset(lv, s17070c63f0, 0, "S17070C63.s17070c63f0");
    check_field_offset(lv, s17070c63f1, ABISELECT(16,8), "S17070C63.s17070c63f1");
  }
}
static Arrange_To_Call_Me vS17070C63(Test_S17070C63, "S17070C63", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C60  {
  int s17070c60f0;
  ::S17070C7_nt s17070c60f1;
  int s17070c60f2;
  ::S17070C61 s17070c60f3;
  int s17070c60f4[2];
  ::S17070C63 s17070c60f5;
  ::S17070C61 s17070c60f6;
  void  mf17070c60(); // _ZN9S17070C6010mf17070c60Ev
};
//SIG(-1 S17070C60) C1{ m Fi FC2{ m Fi[2]} Fi FC3{ m FC4{ m Fp[2]} Fi} Fi[2] FC5{ m FC4 FC6{ m Fp[2]}} FC3}


void  S17070C60 ::mf17070c60(){}

static void Test_S17070C60()
{
  {
    init_simple_test("S17070C60");
    S17070C60 lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S17070C60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C60)");
    check_field_offset(lv, s17070c60f0, 0, "S17070C60.s17070c60f0");
    check_field_offset(lv, s17070c60f1, 4, "S17070C60.s17070c60f1");
    check_field_offset(lv, s17070c60f2, 12, "S17070C60.s17070c60f2");
    check_field_offset(lv, s17070c60f3, 16, "S17070C60.s17070c60f3");
    check_field_offset(lv, s17070c60f4, ABISELECT(40,28), "S17070C60.s17070c60f4");
    check_field_offset(lv, s17070c60f5, ABISELECT(48,36), "S17070C60.s17070c60f5");
    check_field_offset(lv, s17070c60f6, ABISELECT(80,52), "S17070C60.s17070c60f6");
  }
}
static Arrange_To_Call_Me vS17070C60(Test_S17070C60, "S17070C60", ABISELECT(104,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C67  : S17070C11_nt , S17070C13_nt {
  ::S17070C14_nt s17070c67f0;
  ::S17070C14_nt s17070c67f1;
  ::S17070C25_nt s17070c67f2;
  ::S17070C51_nt s17070c67f3;
  ::S17070C51_nt s17070c67f4;
  ::S17070C51_nt s17070c67f5;
  ::S17070C51_nt s17070c67f6;
  ::S17070C51_nt s17070c67f7;
  ::S17070C25_nt s17070c67f8;
  ::S17070C25_nt s17070c67f9;
  ::S17070C51_nt s17070c67f10;
  ::S17070C51_nt s17070c67f11;
  ::S17070C22_nt s17070c67f12;
  ::S17070C19_nt s17070c67f13;
  ::S17070C51_nt s17070c67f14;
  ::S17070C14_nt s17070c67f15;
  virtual void  v40(); // _ZN9S17070C673v40Ev
  virtual void  v41(); // _ZN9S17070C673v41Ev
  virtual void  v42(); // _ZN9S17070C673v42Ev
  virtual void  v43(); // _ZN9S17070C673v43Ev
  virtual void  v44(); // _ZN9S17070C673v44Ev
  virtual void  v45(); // _ZN9S17070C673v45Ev
  ~S17070C67(); // tgen
  S17070C67(); // tgen
};
//SIG(-1 S17070C67) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC5 FC10{ BC6 Fi} FC11{ BC6 FC8} FC11 FC11 FC11 FC11 FC10 FC10 FC11 FC11 FC12{ BC6 FC13{ m FC14{ m FL}}} FC15{ BC6 FC16{ m FC17{ m Fp[2]} FC18{ m Fp}}} FC11 FC5}


void  S17070C67 ::v40(){vfunc_called(this, "_ZN9S17070C673v40Ev");}
void  S17070C67 ::v41(){vfunc_called(this, "_ZN9S17070C673v41Ev");}
void  S17070C67 ::v42(){vfunc_called(this, "_ZN9S17070C673v42Ev");}
void  S17070C67 ::v43(){vfunc_called(this, "_ZN9S17070C673v43Ev");}
void  S17070C67 ::v44(){vfunc_called(this, "_ZN9S17070C673v44Ev");}
void  S17070C67 ::v45(){vfunc_called(this, "_ZN9S17070C673v45Ev");}
S17070C67 ::~S17070C67(){ note_dtor("S17070C67", this);} // tgen
S17070C67 ::S17070C67(){ note_ctor("S17070C67", this);} // tgen

static void Test_S17070C67()
{
  extern Class_Descriptor cd_S17070C67;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(117,174)];
    init_test(&cd_S17070C67, buf);
    S17070C67 *dp, &lv = *(dp=new (buf) S17070C67());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,692), "sizeof(S17070C67)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C67)");
    check_base_class_offset(lv, (S17070C11_nt*), 0, "S17070C67");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S17070C67");
    check_field_offset(lv, s17070c67f0, ABISELECT(40,20), "S17070C67.s17070c67f0");
    check_field_offset(lv, s17070c67f1, ABISELECT(136,104), "S17070C67.s17070c67f1");
    check_field_offset(lv, s17070c67f2, ABISELECT(232,188), "S17070C67.s17070c67f2");
    check_field_offset(lv, s17070c67f3, ABISELECT(272,212), "S17070C67.s17070c67f3");
    check_field_offset(lv, s17070c67f4, ABISELECT(320,248), "S17070C67.s17070c67f4");
    check_field_offset(lv, s17070c67f5, ABISELECT(368,284), "S17070C67.s17070c67f5");
    check_field_offset(lv, s17070c67f6, ABISELECT(416,320), "S17070C67.s17070c67f6");
    check_field_offset(lv, s17070c67f7, ABISELECT(464,356), "S17070C67.s17070c67f7");
    check_field_offset(lv, s17070c67f8, ABISELECT(512,392), "S17070C67.s17070c67f8");
    check_field_offset(lv, s17070c67f9, ABISELECT(552,416), "S17070C67.s17070c67f9");
    check_field_offset(lv, s17070c67f10, ABISELECT(592,440), "S17070C67.s17070c67f10");
    check_field_offset(lv, s17070c67f11, ABISELECT(640,476), "S17070C67.s17070c67f11");
    check_field_offset(lv, s17070c67f12, ABISELECT(688,512), "S17070C67.s17070c67f12");
    check_field_offset(lv, s17070c67f13, ABISELECT(728,540), "S17070C67.s17070c67f13");
    check_field_offset(lv, s17070c67f14, ABISELECT(784,572), "S17070C67.s17070c67f14");
    check_field_offset(lv, s17070c67f15, ABISELECT(832,608), "S17070C67.s17070c67f15");
    test_class_info(&lv, &cd_S17070C67);
    dp->~S17070C67();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C67(Test_S17070C67, "S17070C67", ABISELECT(928,692));

#else // __cplusplus

extern void _ZN9S17070C67C1Ev();
extern void _ZN9S17070C67D1Ev();
Name_Map name_map_S17070C67[] = {
  NSPAIR(_ZN9S17070C67C1Ev),
  NSPAIR(_ZN9S17070C67D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C11_nt;
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S17070C67[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C67[];
extern void _ZN9S17070C67D1Ev();
extern void _ZN9S17070C67D0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
extern void _ZN9S17070C673v40Ev();
extern void _ZN9S17070C673v41Ev();
extern void _ZN9S17070C673v42Ev();
extern void _ZN9S17070C673v43Ev();
extern void _ZN9S17070C673v44Ev();
extern void _ZN9S17070C673v45Ev();
static  VTBL_ENTRY vtc_S17070C67[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C67[0]),
  (VTBL_ENTRY)&_ZN9S17070C67D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C67D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S17070C673v40Ev,
  (VTBL_ENTRY)&_ZN9S17070C673v41Ev,
  (VTBL_ENTRY)&_ZN9S17070C673v42Ev,
  (VTBL_ENTRY)&_ZN9S17070C673v43Ev,
  (VTBL_ENTRY)&_ZN9S17070C673v44Ev,
  (VTBL_ENTRY)&_ZN9S17070C673v45Ev,
};
extern VTBL_ENTRY _ZTI9S17070C67[];
extern  VTBL_ENTRY _ZTV9S17070C67[];
Class_Descriptor cd_S17070C67 = {  "S17070C67", // class name
  bases_S17070C67, 2,
  &(vtc_S17070C67[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(928,692), // object size
  NSPAIRA(_ZTI9S17070C67),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C67),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C66  {
  ::S17070C67 s17070c66f0;
  ::S17070C26_nt s17070c66f1;
  void  mf17070c66(); // _ZN9S17070C6610mf17070c66Ev
};
//SIG(-1 S17070C66) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC6 FC11{ BC7 Fi} FC12{ BC7 FC9} FC12 FC12 FC12 FC12 FC11 FC11 FC12 FC12 FC13{ BC7 FC14{ m FC15{ m FL}}} FC16{ BC7 FC17{ m FC18{ m Fp[2]} FC19{ m Fp}}} FC12 FC6} FC20{ BC21{ BC22{ vd v13} vd v14 Fp[2] FC23{ m FC24{ m Fp Fi[2] FC25{ m}}} FC26{ m Fp[2]}} vd FC27{ m FC28{ Fs[2] Fc[2] Fs}[12] Fi FC29{ Fs[2]}[4] Fi FC26}}}


void  S17070C66 ::mf17070c66(){}

static void Test_S17070C66()
{
  {
    init_simple_test("S17070C66");
    S17070C66 lv;
    check2(sizeof(lv), ABISELECT(1128,856), "sizeof(S17070C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C66)");
    check_field_offset(lv, s17070c66f0, 0, "S17070C66.s17070c66f0");
    check_field_offset(lv, s17070c66f1, ABISELECT(928,692), "S17070C66.s17070c66f1");
  }
}
static Arrange_To_Call_Me vS17070C66(Test_S17070C66, "S17070C66", ABISELECT(1128,856));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C69  : S17070C11_nt , S17070C13_nt {
  virtual void  v46(); // _ZN9S17070C693v46Ev
  virtual void  v47(); // _ZN9S17070C693v47Ev
  virtual void  v48(); // _ZN9S17070C693v48Ev
  virtual void  v49(); // _ZN9S17070C693v49Ev
  virtual void  v50(); // _ZN9S17070C693v50Ev
  virtual void  v51(); // _ZN9S17070C693v51Ev
  ~S17070C69(); // tgen
  S17070C69(); // tgen
};
//SIG(-1 S17070C69) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6}


void  S17070C69 ::v46(){vfunc_called(this, "_ZN9S17070C693v46Ev");}
void  S17070C69 ::v47(){vfunc_called(this, "_ZN9S17070C693v47Ev");}
void  S17070C69 ::v48(){vfunc_called(this, "_ZN9S17070C693v48Ev");}
void  S17070C69 ::v49(){vfunc_called(this, "_ZN9S17070C693v49Ev");}
void  S17070C69 ::v50(){vfunc_called(this, "_ZN9S17070C693v50Ev");}
void  S17070C69 ::v51(){vfunc_called(this, "_ZN9S17070C693v51Ev");}
S17070C69 ::~S17070C69(){ note_dtor("S17070C69", this);} // tgen
S17070C69 ::S17070C69(){ note_ctor("S17070C69", this);} // tgen

static void Test_S17070C69()
{
  extern Class_Descriptor cd_S17070C69;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S17070C69, buf);
    S17070C69 *dp, &lv = *(dp=new (buf) S17070C69());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S17070C69)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C69)");
    check_base_class_offset(lv, (S17070C11_nt*), 0, "S17070C69");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S17070C69");
    test_class_info(&lv, &cd_S17070C69);
    dp->~S17070C69();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C69(Test_S17070C69, "S17070C69", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S17070C69C1Ev();
extern void _ZN9S17070C69D1Ev();
Name_Map name_map_S17070C69[] = {
  NSPAIR(_ZN9S17070C69C1Ev),
  NSPAIR(_ZN9S17070C69D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C11_nt;
extern VTBL_ENTRY _ZTI12S17070C11_nt[];
extern  VTBL_ENTRY _ZTV12S17070C11_nt[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S17070C69[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C69[];
extern void _ZN9S17070C69D1Ev();
extern void _ZN9S17070C69D0Ev();
extern void _ZN12S17070C11_nt2v7Ev();
extern void _ZN12S17070C11_nt2v8Ev();
extern void _ZN12S17070C11_nt2v9Ev();
extern void _ZN12S17070C11_nt3v10Ev();
extern void _ZN12S17070C11_nt3v11Ev();
extern void _ZN12S17070C11_nt3v12Ev();
extern void _ZN9S17070C693v46Ev();
extern void _ZN9S17070C693v47Ev();
extern void _ZN9S17070C693v48Ev();
extern void _ZN9S17070C693v49Ev();
extern void _ZN9S17070C693v50Ev();
extern void _ZN9S17070C693v51Ev();
static  VTBL_ENTRY vtc_S17070C69[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C69[0]),
  (VTBL_ENTRY)&_ZN9S17070C69D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C69D0Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S17070C11_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S17070C693v46Ev,
  (VTBL_ENTRY)&_ZN9S17070C693v47Ev,
  (VTBL_ENTRY)&_ZN9S17070C693v48Ev,
  (VTBL_ENTRY)&_ZN9S17070C693v49Ev,
  (VTBL_ENTRY)&_ZN9S17070C693v50Ev,
  (VTBL_ENTRY)&_ZN9S17070C693v51Ev,
};
extern VTBL_ENTRY _ZTI9S17070C69[];
extern  VTBL_ENTRY _ZTV9S17070C69[];
Class_Descriptor cd_S17070C69 = {  "S17070C69", // class name
  bases_S17070C69, 2,
  &(vtc_S17070C69[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S17070C69),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C69),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C68  {
  ::S17070C69 s17070c68f0;
  ::S17070C39_nt s17070c68f1;
  void  mf17070c68(); // _ZN9S17070C6810mf17070c68Ev
};
//SIG(-1 S17070C68) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6} FC6{ BC7{ BC8{ vd v13} vd v14 Fp[2] FC9{ m FC10{ m Fp Fi[2] FC11{ m}}} FC12{ m Fp[2]}} vd FC13{ m Fp Fi FC14{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC15{ m Fp[2]}}}}


void  S17070C68 ::mf17070c68(){}

static void Test_S17070C68()
{
  {
    init_simple_test("S17070C68");
    static S17070C68 lv;
    check2(sizeof(lv), ABISELECT(144,80), "sizeof(S17070C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C68)");
    check_field_offset(lv, s17070c68f0, 0, "S17070C68.s17070c68f0");
    check_field_offset(lv, s17070c68f1, ABISELECT(40,20), "S17070C68.s17070c68f1");
  }
}
static Arrange_To_Call_Me vS17070C68(Test_S17070C68, "S17070C68", ABISELECT(144,80));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C59  {
  ::S17070C60 s17070c59f0;
  ::S17070C66 s17070c59f1;
  ::S17070C68 s17070c59f2;
  char s17070c59f3;
  ::S17070C4 s17070c59f4;
  ::S17070C65 s17070c59f5;
  char s17070c59f6;
  void  mf17070c59(); // _ZN9S17070C5910mf17070c59Ev
};
//SIG(-1 S17070C59) C1{ m FC2{ m Fi FC3{ m Fi[2]} Fi FC4{ m FC5{ m Fp[2]} Fi} Fi[2] FC6{ m FC5 FC7{ m Fp[2]}} FC4} FC8{ m FC9{ BC10{ vd v7 v8 v9 v10 v11 v12 FC11{ m Fp[4]}} BC12{} v1 v2 v3 v4 v5 v6 FC13{ BC14{ m Fp Fi Fp Fi[2]} FC15{ m FC16{ m FC17{ m FL[2]}} FC16 FC16 FC16}} FC13 FC18{ BC14 Fi} FC19{ BC14 FC16} FC19 FC19 FC19 FC19 FC18 FC18 FC19 FC19 FC20{ BC14 FC21{ m FC22{ m FL}}} FC23{ BC14 FC24{ m FC25{ m Fp[2]} FC26{ m Fp}}} FC19 FC13} FC27{ BC28{ BC29{ vd v13} vd v14 Fp[2] FC30{ m FC31{ m Fp Fi[2] FC32{ m}}} FC33{ m Fp[2]}} vd FC34{ m FC35{ Fs[2] Fc[2] Fs}[12] Fi FC36{ Fs[2]}[4] Fi FC33}}} FC37{ m FC38{ BC10 BC12 v15 v16 v17 v18 v19 v20} FC39{ BC40{ BC29 vd v21 Fp[2] FC30 FC41{ m Fp[2]}} vd FC42{ m Fp Fi FC43{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC33}}} Fc FC25 FC7 Fc}


void  S17070C59 ::mf17070c59(){}

static void Test_S17070C59()
{
  {
    init_simple_test("S17070C59");
    static S17070C59 lv;
    check2(sizeof(lv), ABISELECT(1424,1024), "sizeof(S17070C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C59)");
    check_field_offset(lv, s17070c59f0, 0, "S17070C59.s17070c59f0");
    check_field_offset(lv, s17070c59f1, ABISELECT(104,64), "S17070C59.s17070c59f1");
    check_field_offset(lv, s17070c59f2, ABISELECT(1232,920), "S17070C59.s17070c59f2");
    check_field_offset(lv, s17070c59f3, ABISELECT(1376,1000), "S17070C59.s17070c59f3");
    check_field_offset(lv, s17070c59f4, ABISELECT(1384,1004), "S17070C59.s17070c59f4");
    check_field_offset(lv, s17070c59f5, ABISELECT(1400,1012), "S17070C59.s17070c59f5");
    check_field_offset(lv, s17070c59f6, ABISELECT(1416,1020), "S17070C59.s17070c59f6");
  }
}
static Arrange_To_Call_Me vS17070C59(Test_S17070C59, "S17070C59", ABISELECT(1424,1024));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C74_nt  {
  void *s17070c74f0;
  int s17070c74f1;
  ::S17070C31_nt s17070c74f2;
  void  mf17070c74(); // _ZN12S17070C74_nt10mf17070c74Ev
};
//SIG(-1 S17070C74_nt) C1{ m Fp Fi FC2{ m}}


void  S17070C74_nt ::mf17070c74(){}

//skip512 S17070C74_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C78  {
  void  mf17070c78(); // _ZN9S17070C7810mf17070c78Ev
};
//SIG(-1 S17070C78) C1{ m}


void  S17070C78 ::mf17070c78(){}

static void Test_S17070C78()
{
  {
    init_simple_test("S17070C78");
    S17070C78 lv;
    check2(sizeof(lv), 1, "sizeof(S17070C78)");
    check2(__alignof__(lv), 1, "__alignof__(S17070C78)");
  }
}
static Arrange_To_Call_Me vS17070C78(Test_S17070C78, "S17070C78", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S17070C78[];
VTBL_ENTRY *P__ZTI9S17070C78 = _ZTI9S17070C78; 
Class_Descriptor cd_S17070C78 = {  "S17070C78", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S17070C78),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C77_nt  {
  void *s17070c77f0;
  int s17070c77f1;
  ::S17070C78 s17070c77f2;
  ::S17070C78 s17070c77f3;
  void  mf17070c77(); // _ZN12S17070C77_nt10mf17070c77Ev
};
//SIG(-1 S17070C77_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S17070C77_nt ::mf17070c77(){}

//skip512 S17070C77_nt

#else // __cplusplus

Class_Descriptor cd_S17070C77_nt = {  "S17070C77_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C76_nt  : S17070C77_nt {
};
//SIG(-1 S17070C76_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S17070C76_nt

#else // __cplusplus

extern Class_Descriptor cd_S17070C77_nt;
static Base_Class bases_S17070C76_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C77_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C71  {
  ::S17070C57 s17070c71f0;
  ::S17070C74_nt s17070c71f1;
  ::S17070C76_nt s17070c71f2;
  ::S17070C74_nt s17070c71f3;
  ::S17070C74_nt s17070c71f4;
  char s17070c71f5[2];
  int s17070c71f6;
  void  mf17070c71(); // _ZN9S17070C7110mf17070c71Ev
};
//SIG(-1 S17070C71) C1{ m FC2{ m FC3{ m Fp[2]}} FC4{ m Fp Fi FC5{ m}} FC6{ BC7{ m Fp Fi FC8{ m} FC8}} FC4 FC4 Fc[2] Fi}


void  S17070C71 ::mf17070c71(){}

static void Test_S17070C71()
{
  {
    init_simple_test("S17070C71");
    S17070C71 lv;
    check2(sizeof(lv), ABISELECT(88,64), "sizeof(S17070C71)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C71)");
    check_field_offset(lv, s17070c71f0, 0, "S17070C71.s17070c71f0");
    check_field_offset(lv, s17070c71f1, ABISELECT(16,8), "S17070C71.s17070c71f1");
    check_field_offset(lv, s17070c71f2, ABISELECT(32,20), "S17070C71.s17070c71f2");
    check_field_offset(lv, s17070c71f3, ABISELECT(48,32), "S17070C71.s17070c71f3");
    check_field_offset(lv, s17070c71f4, ABISELECT(64,44), "S17070C71.s17070c71f4");
    check_field_offset(lv, s17070c71f5, ABISELECT(80,56), "S17070C71.s17070c71f5");
    check_field_offset(lv, s17070c71f6, ABISELECT(84,60), "S17070C71.s17070c71f6");
  }
}
static Arrange_To_Call_Me vS17070C71(Test_S17070C71, "S17070C71", ABISELECT(88,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C73  {
  void *s17070c73f0[2];
  void  mf17070c73(); // _ZN9S17070C7310mf17070c73Ev
};
//SIG(-1 S17070C73) C1{ m Fp[2]}


void  S17070C73 ::mf17070c73(){}

static void Test_S17070C73()
{
  {
    init_simple_test("S17070C73");
    S17070C73 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C73)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C73)");
    check_field_offset(lv, s17070c73f0, 0, "S17070C73.s17070c73f0");
  }
}
static Arrange_To_Call_Me vS17070C73(Test_S17070C73, "S17070C73", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S17070C73[];
VTBL_ENTRY *P__ZTI9S17070C73 = _ZTI9S17070C73; 
Class_Descriptor cd_S17070C73 = {  "S17070C73", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S17070C73),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C82  : S17070C73 {
  ::S17070C76_nt s17070c82f0;
  ::S17070C74_nt s17070c82f1;
  ::S17070C74_nt s17070c82f2;
  ::S17070C74_nt s17070c82f3;
  ::S17070C74_nt s17070c82f4;
  virtual  ~S17070C82(); // _ZN9S17070C82D1Ev
  virtual void  v58(); // _ZN9S17070C823v58Ev
  virtual void  v59(); // _ZN9S17070C823v59Ev
  virtual void  v60(); // _ZN9S17070C823v60Ev
  virtual void  v61(); // _ZN9S17070C823v61Ev
  virtual void  v62(); // _ZN9S17070C823v62Ev
  virtual void  v63(); // _ZN9S17070C823v63Ev
  S17070C82(); // tgen
};
//SIG(-1 S17070C82) C1{ BC2{ m Fp[2]} vd v1 v2 v3 v4 v5 v6 FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ m Fp Fi FC7{ m}} FC6 FC6 FC6}


 S17070C82 ::~S17070C82(){ note_dtor("S17070C82", this);}
void  S17070C82 ::v58(){vfunc_called(this, "_ZN9S17070C823v58Ev");}
void  S17070C82 ::v59(){vfunc_called(this, "_ZN9S17070C823v59Ev");}
void  S17070C82 ::v60(){vfunc_called(this, "_ZN9S17070C823v60Ev");}
void  S17070C82 ::v61(){vfunc_called(this, "_ZN9S17070C823v61Ev");}
void  S17070C82 ::v62(){vfunc_called(this, "_ZN9S17070C823v62Ev");}
void  S17070C82 ::v63(){vfunc_called(this, "_ZN9S17070C823v63Ev");}
S17070C82 ::S17070C82(){ note_ctor("S17070C82", this);} // tgen

static void Test_S17070C82()
{
  extern Class_Descriptor cd_S17070C82;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,19)];
    init_test(&cd_S17070C82, buf);
    S17070C82 *dp, &lv = *(dp=new (buf) S17070C82());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,72), "sizeof(S17070C82)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C82)");
    check_base_class_offset(lv, (S17070C73*), ABISELECT(8,4), "S17070C82");
    check_field_offset(lv, s17070c82f0, ABISELECT(24,12), "S17070C82.s17070c82f0");
    check_field_offset(lv, s17070c82f1, ABISELECT(40,24), "S17070C82.s17070c82f1");
    check_field_offset(lv, s17070c82f2, ABISELECT(56,36), "S17070C82.s17070c82f2");
    check_field_offset(lv, s17070c82f3, ABISELECT(72,48), "S17070C82.s17070c82f3");
    check_field_offset(lv, s17070c82f4, ABISELECT(88,60), "S17070C82.s17070c82f4");
    test_class_info(&lv, &cd_S17070C82);
    dp->~S17070C82();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C82(Test_S17070C82, "S17070C82", ABISELECT(104,72));

#else // __cplusplus

extern void _ZN9S17070C82C1Ev();
extern void _ZN9S17070C82D1Ev();
Name_Map name_map_S17070C82[] = {
  NSPAIR(_ZN9S17070C82C1Ev),
  NSPAIR(_ZN9S17070C82D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
static Base_Class bases_S17070C82[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C82[];
extern void _ZN9S17070C82D1Ev();
extern void _ZN9S17070C82D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
static  VTBL_ENTRY vtc_S17070C82[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C82[0]),
  (VTBL_ENTRY)&_ZN9S17070C82D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C82D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
};
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
Class_Descriptor cd_S17070C82 = {  "S17070C82", // class name
  bases_S17070C82, 1,
  &(vtc_S17070C82[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,72), // object size
  NSPAIRA(_ZTI9S17070C82),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S17070C82),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C92_nt  {
  int s17070c92f0[3];
  void  mf17070c92(); // _ZN12S17070C92_nt10mf17070c92Ev
};
//SIG(-1 S17070C92_nt) C1{ m Fi[3]}


void  S17070C92_nt ::mf17070c92(){}

//skip512 S17070C92_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C91  {
  char s17070c91f0;
  ::S17070C92_nt s17070c91f1;
  int s17070c91f2[2];
  void  mf17070c91(); // _ZN9S17070C9110mf17070c91Ev
};
//SIG(-1 S17070C91) C1{ m Fc FC2{ m Fi[3]} Fi[2]}


void  S17070C91 ::mf17070c91(){}

static void Test_S17070C91()
{
  {
    init_simple_test("S17070C91");
    S17070C91 lv;
    check2(sizeof(lv), 24, "sizeof(S17070C91)");
    check2(__alignof__(lv), 4, "__alignof__(S17070C91)");
    check_field_offset(lv, s17070c91f0, 0, "S17070C91.s17070c91f0");
    check_field_offset(lv, s17070c91f1, 4, "S17070C91.s17070c91f1");
    check_field_offset(lv, s17070c91f2, 16, "S17070C91.s17070c91f2");
  }
}
static Arrange_To_Call_Me vS17070C91(Test_S17070C91, "S17070C91", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C88  {
  ::S17070C30_nt s17070c88f0;
  ::S17070C91 s17070c88f1;
  ::S17070C74_nt s17070c88f2;
  virtual  ~S17070C88(); // _ZN9S17070C88D1Ev
  virtual void  v65(); // _ZN9S17070C883v65Ev
  S17070C88(); // tgen
};
//SIG(-1 S17070C88) C1{ vd v1 FC2{ m Fp Fi[2] FC3{ m}} FC4{ m Fc FC5{ m Fi[3]} Fi[2]} FC6{ m Fp Fi FC3}}


 S17070C88 ::~S17070C88(){ note_dtor("S17070C88", this);}
void  S17070C88 ::v65(){vfunc_called(this, "_ZN9S17070C883v65Ev");}
S17070C88 ::S17070C88(){ note_ctor("S17070C88", this);} // tgen

static void Test_S17070C88()
{
  extern Class_Descriptor cd_S17070C88;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S17070C88, buf);
    S17070C88 *dp, &lv = *(dp=new (buf) S17070C88());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S17070C88)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C88)");
    check_field_offset(lv, s17070c88f0, ABISELECT(8,4), "S17070C88.s17070c88f0");
    check_field_offset(lv, s17070c88f1, ABISELECT(32,20), "S17070C88.s17070c88f1");
    check_field_offset(lv, s17070c88f2, ABISELECT(56,44), "S17070C88.s17070c88f2");
    test_class_info(&lv, &cd_S17070C88);
    dp->~S17070C88();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C88(Test_S17070C88, "S17070C88", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN9S17070C88C1Ev();
extern void _ZN9S17070C88D1Ev();
Name_Map name_map_S17070C88[] = {
  NSPAIR(_ZN9S17070C88C1Ev),
  NSPAIR(_ZN9S17070C88D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S17070C88[];
extern void _ZN9S17070C88D1Ev();
extern void _ZN9S17070C88D0Ev();
extern void _ZN9S17070C883v65Ev();
static  VTBL_ENTRY vtc_S17070C88[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C88[0]),
  (VTBL_ENTRY)&_ZN9S17070C88D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C88D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
};
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
Class_Descriptor cd_S17070C88 = {  "S17070C88", // class name
  0,0,//no base classes
  &(vtc_S17070C88[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI9S17070C88),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S17070C88),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C93  {
  void *s17070c93f0[2];
  void  mf17070c93(); // _ZN9S17070C9310mf17070c93Ev
};
//SIG(-1 S17070C93) C1{ m Fp[2]}


void  S17070C93 ::mf17070c93(){}

static void Test_S17070C93()
{
  {
    init_simple_test("S17070C93");
    S17070C93 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C93)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C93)");
    check_field_offset(lv, s17070c93f0, 0, "S17070C93.s17070c93f0");
  }
}
static Arrange_To_Call_Me vS17070C93(Test_S17070C93, "S17070C93", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S17070C93[];
VTBL_ENTRY *P__ZTI9S17070C93 = _ZTI9S17070C93; 
Class_Descriptor cd_S17070C93 = {  "S17070C93", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S17070C93),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C96  {
  virtual  ~S17070C96(); // _ZN9S17070C96D1Ev
  virtual void  v73(); // _ZN9S17070C963v73Ev
  virtual void  v74(); // _ZN9S17070C963v74Ev
  virtual void  v75(); // _ZN9S17070C963v75Ev
  virtual void  v76(); // _ZN9S17070C963v76Ev
  virtual void  v77(); // _ZN9S17070C963v77Ev
  virtual void  v78(); // _ZN9S17070C963v78Ev
  virtual void  v79(); // _ZN9S17070C963v79Ev
  S17070C96(); // tgen
};
//SIG(-1 S17070C96) C1{ vd v1 v2 v3 v4 v5 v6 v7}


 S17070C96 ::~S17070C96(){ note_dtor("S17070C96", this);}
void  S17070C96 ::v73(){vfunc_called(this, "_ZN9S17070C963v73Ev");}
void  S17070C96 ::v74(){vfunc_called(this, "_ZN9S17070C963v74Ev");}
void  S17070C96 ::v75(){vfunc_called(this, "_ZN9S17070C963v75Ev");}
void  S17070C96 ::v76(){vfunc_called(this, "_ZN9S17070C963v76Ev");}
void  S17070C96 ::v77(){vfunc_called(this, "_ZN9S17070C963v77Ev");}
void  S17070C96 ::v78(){vfunc_called(this, "_ZN9S17070C963v78Ev");}
void  S17070C96 ::v79(){vfunc_called(this, "_ZN9S17070C963v79Ev");}
S17070C96 ::S17070C96(){ note_ctor("S17070C96", this);} // tgen

static void Test_S17070C96()
{
  extern Class_Descriptor cd_S17070C96;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S17070C96, buf);
    S17070C96 *dp, &lv = *(dp=new (buf) S17070C96());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17070C96)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C96)");
    test_class_info(&lv, &cd_S17070C96);
    dp->~S17070C96();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C96(Test_S17070C96, "S17070C96", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S17070C96C1Ev();
extern void _ZN9S17070C96D1Ev();
Name_Map name_map_S17070C96[] = {
  NSPAIR(_ZN9S17070C96C1Ev),
  NSPAIR(_ZN9S17070C96D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S17070C96[];
extern void _ZN9S17070C96D1Ev();
extern void _ZN9S17070C96D0Ev();
extern void _ZN9S17070C963v73Ev();
extern void _ZN9S17070C963v74Ev();
extern void _ZN9S17070C963v75Ev();
extern void _ZN9S17070C963v76Ev();
extern void _ZN9S17070C963v77Ev();
extern void _ZN9S17070C963v78Ev();
extern void _ZN9S17070C963v79Ev();
static  VTBL_ENTRY vtc_S17070C96[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C96[0]),
  (VTBL_ENTRY)&_ZN9S17070C96D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C96D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v73Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v74Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v75Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v76Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v77Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v78Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v79Ev,
};
extern VTBL_ENTRY _ZTI9S17070C96[];
extern  VTBL_ENTRY _ZTV9S17070C96[];
Class_Descriptor cd_S17070C96 = {  "S17070C96", // class name
  0,0,//no base classes
  &(vtc_S17070C96[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S17070C96),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S17070C96),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C95  : S17070C96 {
  ::S17070C17_nt s17070c95f0;
  void *s17070c95f1;
  virtual  ~S17070C95(); // _ZN9S17070C95D1Ev
  virtual void  v66(); // _ZN9S17070C953v66Ev
  virtual void  v67(); // _ZN9S17070C953v67Ev
  virtual void  v68(); // _ZN9S17070C953v68Ev
  virtual void  v69(); // _ZN9S17070C953v69Ev
  virtual void  v70(); // _ZN9S17070C953v70Ev
  virtual void  v71(); // _ZN9S17070C953v71Ev
  virtual void  v72(); // _ZN9S17070C953v72Ev
  S17070C95(); // tgen
};
//SIG(-1 S17070C95) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m FC4{ m FL[2]}} Fp}


 S17070C95 ::~S17070C95(){ note_dtor("S17070C95", this);}
void  S17070C95 ::v66(){vfunc_called(this, "_ZN9S17070C953v66Ev");}
void  S17070C95 ::v67(){vfunc_called(this, "_ZN9S17070C953v67Ev");}
void  S17070C95 ::v68(){vfunc_called(this, "_ZN9S17070C953v68Ev");}
void  S17070C95 ::v69(){vfunc_called(this, "_ZN9S17070C953v69Ev");}
void  S17070C95 ::v70(){vfunc_called(this, "_ZN9S17070C953v70Ev");}
void  S17070C95 ::v71(){vfunc_called(this, "_ZN9S17070C953v71Ev");}
void  S17070C95 ::v72(){vfunc_called(this, "_ZN9S17070C953v72Ev");}
S17070C95 ::S17070C95(){ note_ctor("S17070C95", this);} // tgen

static void Test_S17070C95()
{
  extern Class_Descriptor cd_S17070C95;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S17070C95, buf);
    S17070C95 *dp, &lv = *(dp=new (buf) S17070C95());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S17070C95)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C95)");
    check_base_class_offset(lv, (S17070C96*), 0, "S17070C95");
    check_field_offset(lv, s17070c95f0, ABISELECT(8,4), "S17070C95.s17070c95f0");
    check_field_offset(lv, s17070c95f1, ABISELECT(24,20), "S17070C95.s17070c95f1");
    test_class_info(&lv, &cd_S17070C95);
    dp->~S17070C95();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C95(Test_S17070C95, "S17070C95", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN9S17070C95C1Ev();
extern void _ZN9S17070C95D1Ev();
Name_Map name_map_S17070C95[] = {
  NSPAIR(_ZN9S17070C95C1Ev),
  NSPAIR(_ZN9S17070C95D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C96;
extern VTBL_ENTRY _ZTI9S17070C96[];
extern  VTBL_ENTRY _ZTV9S17070C96[];
static Base_Class bases_S17070C95[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C95[];
extern void _ZN9S17070C95D1Ev();
extern void _ZN9S17070C95D0Ev();
extern void _ZN9S17070C963v73Ev();
extern void _ZN9S17070C963v74Ev();
extern void _ZN9S17070C963v75Ev();
extern void _ZN9S17070C963v76Ev();
extern void _ZN9S17070C963v77Ev();
extern void _ZN9S17070C963v78Ev();
extern void _ZN9S17070C963v79Ev();
extern void _ZN9S17070C953v66Ev();
extern void _ZN9S17070C953v67Ev();
extern void _ZN9S17070C953v68Ev();
extern void _ZN9S17070C953v69Ev();
extern void _ZN9S17070C953v70Ev();
extern void _ZN9S17070C953v71Ev();
extern void _ZN9S17070C953v72Ev();
static  VTBL_ENTRY vtc_S17070C95[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C95[0]),
  (VTBL_ENTRY)&_ZN9S17070C95D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C95D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v73Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v74Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v75Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v76Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v77Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v78Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v79Ev,
  (VTBL_ENTRY)&_ZN9S17070C953v66Ev,
  (VTBL_ENTRY)&_ZN9S17070C953v67Ev,
  (VTBL_ENTRY)&_ZN9S17070C953v68Ev,
  (VTBL_ENTRY)&_ZN9S17070C953v69Ev,
  (VTBL_ENTRY)&_ZN9S17070C953v70Ev,
  (VTBL_ENTRY)&_ZN9S17070C953v71Ev,
  (VTBL_ENTRY)&_ZN9S17070C953v72Ev,
};
extern VTBL_ENTRY _ZTI9S17070C95[];
extern  VTBL_ENTRY _ZTV9S17070C95[];
Class_Descriptor cd_S17070C95 = {  "S17070C95", // class name
  bases_S17070C95, 1,
  &(vtc_S17070C95[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI9S17070C95),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17070C95),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C97  : S17070C96 {
  int s17070c97f0;
  void *s17070c97f1;
  virtual  ~S17070C97(); // _ZN9S17070C97D1Ev
  virtual void  v80(); // _ZN9S17070C973v80Ev
  virtual void  v81(); // _ZN9S17070C973v81Ev
  virtual void  v82(); // _ZN9S17070C973v82Ev
  virtual void  v83(); // _ZN9S17070C973v83Ev
  virtual void  v84(); // _ZN9S17070C973v84Ev
  virtual void  v85(); // _ZN9S17070C973v85Ev
  virtual void  v86(); // _ZN9S17070C973v86Ev
  S17070C97(); // tgen
};
//SIG(-1 S17070C97) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp}


 S17070C97 ::~S17070C97(){ note_dtor("S17070C97", this);}
void  S17070C97 ::v80(){vfunc_called(this, "_ZN9S17070C973v80Ev");}
void  S17070C97 ::v81(){vfunc_called(this, "_ZN9S17070C973v81Ev");}
void  S17070C97 ::v82(){vfunc_called(this, "_ZN9S17070C973v82Ev");}
void  S17070C97 ::v83(){vfunc_called(this, "_ZN9S17070C973v83Ev");}
void  S17070C97 ::v84(){vfunc_called(this, "_ZN9S17070C973v84Ev");}
void  S17070C97 ::v85(){vfunc_called(this, "_ZN9S17070C973v85Ev");}
void  S17070C97 ::v86(){vfunc_called(this, "_ZN9S17070C973v86Ev");}
S17070C97 ::S17070C97(){ note_ctor("S17070C97", this);} // tgen

static void Test_S17070C97()
{
  extern Class_Descriptor cd_S17070C97;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S17070C97, buf);
    S17070C97 *dp, &lv = *(dp=new (buf) S17070C97());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17070C97)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C97)");
    check_base_class_offset(lv, (S17070C96*), 0, "S17070C97");
    check_field_offset(lv, s17070c97f0, ABISELECT(8,4), "S17070C97.s17070c97f0");
    check_field_offset(lv, s17070c97f1, ABISELECT(16,8), "S17070C97.s17070c97f1");
    test_class_info(&lv, &cd_S17070C97);
    dp->~S17070C97();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C97(Test_S17070C97, "S17070C97", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S17070C97C1Ev();
extern void _ZN9S17070C97D1Ev();
Name_Map name_map_S17070C97[] = {
  NSPAIR(_ZN9S17070C97C1Ev),
  NSPAIR(_ZN9S17070C97D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C96;
extern VTBL_ENTRY _ZTI9S17070C96[];
extern  VTBL_ENTRY _ZTV9S17070C96[];
static Base_Class bases_S17070C97[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C97[];
extern void _ZN9S17070C97D1Ev();
extern void _ZN9S17070C97D0Ev();
extern void _ZN9S17070C963v73Ev();
extern void _ZN9S17070C963v74Ev();
extern void _ZN9S17070C963v75Ev();
extern void _ZN9S17070C963v76Ev();
extern void _ZN9S17070C963v77Ev();
extern void _ZN9S17070C963v78Ev();
extern void _ZN9S17070C963v79Ev();
extern void _ZN9S17070C973v80Ev();
extern void _ZN9S17070C973v81Ev();
extern void _ZN9S17070C973v82Ev();
extern void _ZN9S17070C973v83Ev();
extern void _ZN9S17070C973v84Ev();
extern void _ZN9S17070C973v85Ev();
extern void _ZN9S17070C973v86Ev();
static  VTBL_ENTRY vtc_S17070C97[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C97[0]),
  (VTBL_ENTRY)&_ZN9S17070C97D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C97D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v73Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v74Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v75Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v76Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v77Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v78Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v79Ev,
  (VTBL_ENTRY)&_ZN9S17070C973v80Ev,
  (VTBL_ENTRY)&_ZN9S17070C973v81Ev,
  (VTBL_ENTRY)&_ZN9S17070C973v82Ev,
  (VTBL_ENTRY)&_ZN9S17070C973v83Ev,
  (VTBL_ENTRY)&_ZN9S17070C973v84Ev,
  (VTBL_ENTRY)&_ZN9S17070C973v85Ev,
  (VTBL_ENTRY)&_ZN9S17070C973v86Ev,
};
extern VTBL_ENTRY _ZTI9S17070C97[];
extern  VTBL_ENTRY _ZTV9S17070C97[];
Class_Descriptor cd_S17070C97 = {  "S17070C97", // class name
  bases_S17070C97, 1,
  &(vtc_S17070C97[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S17070C97),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17070C97),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C94  {
  ::S17070C95 s17070c94f0;
  ::S17070C97 s17070c94f1;
  ::S17070C97 s17070c94f2;
  ::S17070C97 s17070c94f3;
  ::S17070C97 s17070c94f4;
  ::S17070C97 s17070c94f5;
  ::S17070C97 s17070c94f6;
  ::S17070C97 s17070c94f7;
  ::S17070C97 s17070c94f8;
  ::S17070C97 s17070c94f9;
  void  mf17070c94(); // _ZN9S17070C9410mf17070c94Ev
};
//SIG(-1 S17070C94) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC4{ m FC5{ m FL[2]}} Fp} FC6{ BC3 vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6}


void  S17070C94 ::mf17070c94(){}

static void Test_S17070C94()
{
  {
    init_simple_test("S17070C94");
    S17070C94 lv;
    check2(sizeof(lv), ABISELECT(248,132), "sizeof(S17070C94)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C94)");
    check_field_offset(lv, s17070c94f0, 0, "S17070C94.s17070c94f0");
    check_field_offset(lv, s17070c94f1, ABISELECT(32,24), "S17070C94.s17070c94f1");
    check_field_offset(lv, s17070c94f2, ABISELECT(56,36), "S17070C94.s17070c94f2");
    check_field_offset(lv, s17070c94f3, ABISELECT(80,48), "S17070C94.s17070c94f3");
    check_field_offset(lv, s17070c94f4, ABISELECT(104,60), "S17070C94.s17070c94f4");
    check_field_offset(lv, s17070c94f5, ABISELECT(128,72), "S17070C94.s17070c94f5");
    check_field_offset(lv, s17070c94f6, ABISELECT(152,84), "S17070C94.s17070c94f6");
    check_field_offset(lv, s17070c94f7, ABISELECT(176,96), "S17070C94.s17070c94f7");
    check_field_offset(lv, s17070c94f8, ABISELECT(200,108), "S17070C94.s17070c94f8");
    check_field_offset(lv, s17070c94f9, ABISELECT(224,120), "S17070C94.s17070c94f9");
  }
}
static Arrange_To_Call_Me vS17070C94(Test_S17070C94, "S17070C94", ABISELECT(248,132));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C87  : S17070C88 , S17070C93 {
  ::S17070C94 s17070c87f0;
  virtual void  v64(); // _ZN9S17070C873v64Ev
  ~S17070C87(); // tgen
  S17070C87(); // tgen
};
//SIG(-1 S17070C87) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 FC12{ m FC13{ m FL[2]}} Fp} FC14{ BC11 vd v17 v18 v19 v20 v21 v22 v23 Fi Fp} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}}


void  S17070C87 ::v64(){vfunc_called(this, "_ZN9S17070C873v64Ev");}
S17070C87 ::~S17070C87(){ note_dtor("S17070C87", this);} // tgen
S17070C87 ::S17070C87(){ note_ctor("S17070C87", this);} // tgen

static void Test_S17070C87()
{
  extern Class_Descriptor cd_S17070C87;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,50)];
    init_test(&cd_S17070C87, buf);
    S17070C87 *dp, &lv = *(dp=new (buf) S17070C87());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,196), "sizeof(S17070C87)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C87)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C87");
    check_base_class_offset(lv, (S17070C93*), ABISELECT(72,56), "S17070C87");
    check_field_offset(lv, s17070c87f0, ABISELECT(88,64), "S17070C87.s17070c87f0");
    test_class_info(&lv, &cd_S17070C87);
    dp->~S17070C87();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C87(Test_S17070C87, "S17070C87", ABISELECT(336,196));

#else // __cplusplus

extern void _ZN9S17070C87C1Ev();
extern void _ZN9S17070C87D1Ev();
Name_Map name_map_S17070C87[] = {
  NSPAIR(_ZN9S17070C87C1Ev),
  NSPAIR(_ZN9S17070C87D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C93;
extern VTBL_ENTRY _ZTI9S17070C93[];
static Base_Class bases_S17070C87[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C93,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C87[];
extern void _ZN9S17070C87D1Ev();
extern void _ZN9S17070C87D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN9S17070C873v64Ev();
static  VTBL_ENTRY vtc_S17070C87[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C87[0]),
  (VTBL_ENTRY)&_ZN9S17070C87D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C87D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN9S17070C873v64Ev,
};
extern VTBL_ENTRY _ZTI9S17070C87[];
extern  VTBL_ENTRY _ZTV9S17070C87[];
Class_Descriptor cd_S17070C87 = {  "S17070C87", // class name
  bases_S17070C87, 2,
  &(vtc_S17070C87[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,196), // object size
  NSPAIRA(_ZTI9S17070C87),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17070C87),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C98  {
  ::S17070C93 s17070c98f0;
  void  mf17070c98(); // _ZN9S17070C9810mf17070c98Ev
};
//SIG(-1 S17070C98) C1{ m FC2{ m Fp[2]}}


void  S17070C98 ::mf17070c98(){}

static void Test_S17070C98()
{
  {
    init_simple_test("S17070C98");
    S17070C98 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C98)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C98)");
    check_field_offset(lv, s17070c98f0, 0, "S17070C98.s17070c98f0");
  }
}
static Arrange_To_Call_Me vS17070C98(Test_S17070C98, "S17070C98", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C81  : S17070C82 {
  ::S17070C87 s17070c81f0;
  ::S17070C98 s17070c81f1;
  virtual void  v52(); // _ZN9S17070C813v52Ev
  virtual void  v53(); // _ZN9S17070C813v53Ev
  virtual void  v54(); // _ZN9S17070C813v54Ev
  virtual void  v55(); // _ZN9S17070C813v55Ev
  virtual void  v56(); // _ZN9S17070C813v56Ev
  virtual void  v57(); // _ZN9S17070C813v57Ev
  ~S17070C81(); // tgen
  S17070C81(); // tgen
};
//SIG(-1 S17070C81) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC18{ m FC19{ m FL[2]}} Fp} FC20{ BC17 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20}} FC21{ m FC14}}


void  S17070C81 ::v52(){vfunc_called(this, "_ZN9S17070C813v52Ev");}
void  S17070C81 ::v53(){vfunc_called(this, "_ZN9S17070C813v53Ev");}
void  S17070C81 ::v54(){vfunc_called(this, "_ZN9S17070C813v54Ev");}
void  S17070C81 ::v55(){vfunc_called(this, "_ZN9S17070C813v55Ev");}
void  S17070C81 ::v56(){vfunc_called(this, "_ZN9S17070C813v56Ev");}
void  S17070C81 ::v57(){vfunc_called(this, "_ZN9S17070C813v57Ev");}
S17070C81 ::~S17070C81(){ note_dtor("S17070C81", this);} // tgen
S17070C81 ::S17070C81(){ note_ctor("S17070C81", this);} // tgen

static void Test_S17070C81()
{
  extern Class_Descriptor cd_S17070C81;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(58,70)];
    init_test(&cd_S17070C81, buf);
    S17070C81 *dp, &lv = *(dp=new (buf) S17070C81());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(456,276), "sizeof(S17070C81)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C81)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C81");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C81");
    check_field_offset(lv, s17070c81f0, ABISELECT(104,72), "S17070C81.s17070c81f0");
    check_field_offset(lv, s17070c81f1, ABISELECT(440,268), "S17070C81.s17070c81f1");
    test_class_info(&lv, &cd_S17070C81);
    dp->~S17070C81();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C81(Test_S17070C81, "S17070C81", ABISELECT(456,276));

#else // __cplusplus

extern void _ZN9S17070C81C1Ev();
extern void _ZN9S17070C81D1Ev();
Name_Map name_map_S17070C81[] = {
  NSPAIR(_ZN9S17070C81C1Ev),
  NSPAIR(_ZN9S17070C81D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C81[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17070C81[];
extern void _ZN9S17070C81D1Ev();
extern void _ZN9S17070C81D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN9S17070C813v52Ev();
extern void _ZN9S17070C813v53Ev();
extern void _ZN9S17070C813v54Ev();
extern void _ZN9S17070C813v55Ev();
extern void _ZN9S17070C813v56Ev();
extern void _ZN9S17070C813v57Ev();
static  VTBL_ENTRY vtc_S17070C81[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17070C81[0]),
  (VTBL_ENTRY)&_ZN9S17070C81D1Ev,
  (VTBL_ENTRY)&_ZN9S17070C81D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN9S17070C813v52Ev,
  (VTBL_ENTRY)&_ZN9S17070C813v53Ev,
  (VTBL_ENTRY)&_ZN9S17070C813v54Ev,
  (VTBL_ENTRY)&_ZN9S17070C813v55Ev,
  (VTBL_ENTRY)&_ZN9S17070C813v56Ev,
  (VTBL_ENTRY)&_ZN9S17070C813v57Ev,
};
extern VTBL_ENTRY _ZTI9S17070C81[];
extern  VTBL_ENTRY _ZTV9S17070C81[];
Class_Descriptor cd_S17070C81 = {  "S17070C81", // class name
  bases_S17070C81, 2,
  &(vtc_S17070C81[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(456,276), // object size
  NSPAIRA(_ZTI9S17070C81),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17070C81),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C80  {
  ::S17070C81 s17070c80f0;
  ::S17070C87 s17070c80f1;
  void  mf17070c80(); // _ZN9S17070C8010mf17070c80Ev
};
//SIG(-1 S17070C80) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC19{ m FC20{ m FL[2]}} Fp} FC21{ BC18 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21}} FC22{ m FC15}} FC10}


void  S17070C80 ::mf17070c80(){}

static void Test_S17070C80()
{
  {
    init_simple_test("S17070C80");
    S17070C80 lv;
    check2(sizeof(lv), ABISELECT(792,472), "sizeof(S17070C80)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C80)");
    check_field_offset(lv, s17070c80f0, 0, "S17070C80.s17070c80f0");
    check_field_offset(lv, s17070c80f1, ABISELECT(456,276), "S17070C80.s17070c80f1");
  }
}
static Arrange_To_Call_Me vS17070C80(Test_S17070C80, "S17070C80", ABISELECT(792,472));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C102  {
  void *s17070c102f0[2];
  void  mf17070c102(); // _ZN10S17070C10211mf17070c102Ev
};
//SIG(-1 S17070C102) C1{ m Fp[2]}


void  S17070C102 ::mf17070c102(){}

static void Test_S17070C102()
{
  {
    init_simple_test("S17070C102");
    S17070C102 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C102)");
    check_field_offset(lv, s17070c102f0, 0, "S17070C102.s17070c102f0");
  }
}
static Arrange_To_Call_Me vS17070C102(Test_S17070C102, "S17070C102", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C102[];
VTBL_ENTRY *P__ZTI10S17070C102 = _ZTI10S17070C102; 
Class_Descriptor cd_S17070C102 = {  "S17070C102", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C102),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C104  : S17070C96 {
  ::S17070C23_nt s17070c104f0;
  void *s17070c104f1;
  virtual  ~S17070C104(); // _ZN10S17070C104D1Ev
  virtual void  v94(); // _ZN10S17070C1043v94Ev
  virtual void  v95(); // _ZN10S17070C1043v95Ev
  virtual void  v96(); // _ZN10S17070C1043v96Ev
  virtual void  v97(); // _ZN10S17070C1043v97Ev
  virtual void  v98(); // _ZN10S17070C1043v98Ev
  virtual void  v99(); // _ZN10S17070C1043v99Ev
  virtual void  v100(); // _ZN10S17070C1044v100Ev
  S17070C104(); // tgen
};
//SIG(-1 S17070C104) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m FC4{ m FL}} Fp}


 S17070C104 ::~S17070C104(){ note_dtor("S17070C104", this);}
void  S17070C104 ::v94(){vfunc_called(this, "_ZN10S17070C1043v94Ev");}
void  S17070C104 ::v95(){vfunc_called(this, "_ZN10S17070C1043v95Ev");}
void  S17070C104 ::v96(){vfunc_called(this, "_ZN10S17070C1043v96Ev");}
void  S17070C104 ::v97(){vfunc_called(this, "_ZN10S17070C1043v97Ev");}
void  S17070C104 ::v98(){vfunc_called(this, "_ZN10S17070C1043v98Ev");}
void  S17070C104 ::v99(){vfunc_called(this, "_ZN10S17070C1043v99Ev");}
void  S17070C104 ::v100(){vfunc_called(this, "_ZN10S17070C1044v100Ev");}
S17070C104 ::S17070C104(){ note_ctor("S17070C104", this);} // tgen

static void Test_S17070C104()
{
  extern Class_Descriptor cd_S17070C104;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S17070C104, buf);
    S17070C104 *dp, &lv = *(dp=new (buf) S17070C104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S17070C104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C104)");
    check_base_class_offset(lv, (S17070C96*), 0, "S17070C104");
    check_field_offset(lv, s17070c104f0, ABISELECT(8,4), "S17070C104.s17070c104f0");
    check_field_offset(lv, s17070c104f1, ABISELECT(16,12), "S17070C104.s17070c104f1");
    test_class_info(&lv, &cd_S17070C104);
    dp->~S17070C104();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C104(Test_S17070C104, "S17070C104", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN10S17070C104C1Ev();
extern void _ZN10S17070C104D1Ev();
Name_Map name_map_S17070C104[] = {
  NSPAIR(_ZN10S17070C104C1Ev),
  NSPAIR(_ZN10S17070C104D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C96;
extern VTBL_ENTRY _ZTI9S17070C96[];
extern  VTBL_ENTRY _ZTV9S17070C96[];
static Base_Class bases_S17070C104[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C104[];
extern void _ZN10S17070C104D1Ev();
extern void _ZN10S17070C104D0Ev();
extern void _ZN9S17070C963v73Ev();
extern void _ZN9S17070C963v74Ev();
extern void _ZN9S17070C963v75Ev();
extern void _ZN9S17070C963v76Ev();
extern void _ZN9S17070C963v77Ev();
extern void _ZN9S17070C963v78Ev();
extern void _ZN9S17070C963v79Ev();
extern void _ZN10S17070C1043v94Ev();
extern void _ZN10S17070C1043v95Ev();
extern void _ZN10S17070C1043v96Ev();
extern void _ZN10S17070C1043v97Ev();
extern void _ZN10S17070C1043v98Ev();
extern void _ZN10S17070C1043v99Ev();
extern void _ZN10S17070C1044v100Ev();
static  VTBL_ENTRY vtc_S17070C104[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C104[0]),
  (VTBL_ENTRY)&_ZN10S17070C104D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C104D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v73Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v74Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v75Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v76Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v77Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v78Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v79Ev,
  (VTBL_ENTRY)&_ZN10S17070C1043v94Ev,
  (VTBL_ENTRY)&_ZN10S17070C1043v95Ev,
  (VTBL_ENTRY)&_ZN10S17070C1043v96Ev,
  (VTBL_ENTRY)&_ZN10S17070C1043v97Ev,
  (VTBL_ENTRY)&_ZN10S17070C1043v98Ev,
  (VTBL_ENTRY)&_ZN10S17070C1043v99Ev,
  (VTBL_ENTRY)&_ZN10S17070C1044v100Ev,
};
extern VTBL_ENTRY _ZTI10S17070C104[];
extern  VTBL_ENTRY _ZTV10S17070C104[];
Class_Descriptor cd_S17070C104 = {  "S17070C104", // class name
  bases_S17070C104, 1,
  &(vtc_S17070C104[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI10S17070C104),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C104),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C103  {
  ::S17070C104 s17070c103f0;
  ::S17070C97 s17070c103f1;
  ::S17070C95 s17070c103f2;
  ::S17070C95 s17070c103f3;
  ::S17070C95 s17070c103f4;
  ::S17070C97 s17070c103f5;
  void  mf17070c103(); // _ZN10S17070C10311mf17070c103Ev
};
//SIG(-1 S17070C103) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC4{ m FC5{ m FL}} Fp} FC6{ BC3 vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC7{ BC3 vd v22 v23 v24 v25 v26 v27 v28 FC8{ m FC9{ m FL[2]}} Fp} FC7 FC7 FC6}


void  S17070C103 ::mf17070c103(){}

static void Test_S17070C103()
{
  {
    init_simple_test("S17070C103");
    S17070C103 lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S17070C103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C103)");
    check_field_offset(lv, s17070c103f0, 0, "S17070C103.s17070c103f0");
    check_field_offset(lv, s17070c103f1, ABISELECT(24,16), "S17070C103.s17070c103f1");
    check_field_offset(lv, s17070c103f2, ABISELECT(48,28), "S17070C103.s17070c103f2");
    check_field_offset(lv, s17070c103f3, ABISELECT(80,52), "S17070C103.s17070c103f3");
    check_field_offset(lv, s17070c103f4, ABISELECT(112,76), "S17070C103.s17070c103f4");
    check_field_offset(lv, s17070c103f5, ABISELECT(144,100), "S17070C103.s17070c103f5");
  }
}
static Arrange_To_Call_Me vS17070C103(Test_S17070C103, "S17070C103", ABISELECT(168,112));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C101  : S17070C88 , S17070C102 {
  ::S17070C103 s17070c101f0;
  virtual void  v93(); // _ZN10S17070C1013v93Ev
  ~S17070C101(); // tgen
  S17070C101(); // tgen
};
//SIG(-1 S17070C101) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 FC12{ m FC13{ m FL}} Fp} FC14{ BC11 vd v17 v18 v19 v20 v21 v22 v23 Fi Fp} FC15{ BC11 vd v24 v25 v26 v27 v28 v29 v30 FC16{ m FC17{ m FL[2]}} Fp} FC15 FC15 FC14}}


void  S17070C101 ::v93(){vfunc_called(this, "_ZN10S17070C1013v93Ev");}
S17070C101 ::~S17070C101(){ note_dtor("S17070C101", this);} // tgen
S17070C101 ::S17070C101(){ note_ctor("S17070C101", this);} // tgen

static void Test_S17070C101()
{
  extern Class_Descriptor cd_S17070C101;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,45)];
    init_test(&cd_S17070C101, buf);
    S17070C101 *dp, &lv = *(dp=new (buf) S17070C101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,176), "sizeof(S17070C101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C101)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C101");
    check_base_class_offset(lv, (S17070C102*), ABISELECT(72,56), "S17070C101");
    check_field_offset(lv, s17070c101f0, ABISELECT(88,64), "S17070C101.s17070c101f0");
    test_class_info(&lv, &cd_S17070C101);
    dp->~S17070C101();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C101(Test_S17070C101, "S17070C101", ABISELECT(256,176));

#else // __cplusplus

extern void _ZN10S17070C101C1Ev();
extern void _ZN10S17070C101D1Ev();
Name_Map name_map_S17070C101[] = {
  NSPAIR(_ZN10S17070C101C1Ev),
  NSPAIR(_ZN10S17070C101D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C102;
extern VTBL_ENTRY _ZTI10S17070C102[];
static Base_Class bases_S17070C101[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C102,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C101[];
extern void _ZN10S17070C101D1Ev();
extern void _ZN10S17070C101D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN10S17070C1013v93Ev();
static  VTBL_ENTRY vtc_S17070C101[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C101[0]),
  (VTBL_ENTRY)&_ZN10S17070C101D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C101D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN10S17070C1013v93Ev,
};
extern VTBL_ENTRY _ZTI10S17070C101[];
extern  VTBL_ENTRY _ZTV10S17070C101[];
Class_Descriptor cd_S17070C101 = {  "S17070C101", // class name
  bases_S17070C101, 2,
  &(vtc_S17070C101[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,176), // object size
  NSPAIRA(_ZTI10S17070C101),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17070C101),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C100  : S17070C82 {
  ::S17070C101 s17070c100f0;
  ::S17070C98 s17070c100f1;
  virtual void  v87(); // _ZN10S17070C1003v87Ev
  virtual void  v88(); // _ZN10S17070C1003v88Ev
  virtual void  v89(); // _ZN10S17070C1003v89Ev
  virtual void  v90(); // _ZN10S17070C1003v90Ev
  virtual void  v91(); // _ZN10S17070C1003v91Ev
  virtual void  v92(); // _ZN10S17070C1003v92Ev
  ~S17070C100(); // tgen
  S17070C100(); // tgen
};
//SIG(-1 S17070C100) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC18{ m FC19{ m FL}} Fp} FC20{ BC17 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC21{ BC17 vd v36 v37 v38 v39 v40 v41 v42 FC22{ m FC23{ m FL[2]}} Fp} FC21 FC21 FC20}} FC24{ m FC25{ m Fp[2]}}}


void  S17070C100 ::v87(){vfunc_called(this, "_ZN10S17070C1003v87Ev");}
void  S17070C100 ::v88(){vfunc_called(this, "_ZN10S17070C1003v88Ev");}
void  S17070C100 ::v89(){vfunc_called(this, "_ZN10S17070C1003v89Ev");}
void  S17070C100 ::v90(){vfunc_called(this, "_ZN10S17070C1003v90Ev");}
void  S17070C100 ::v91(){vfunc_called(this, "_ZN10S17070C1003v91Ev");}
void  S17070C100 ::v92(){vfunc_called(this, "_ZN10S17070C1003v92Ev");}
S17070C100 ::~S17070C100(){ note_dtor("S17070C100", this);} // tgen
S17070C100 ::S17070C100(){ note_ctor("S17070C100", this);} // tgen

static void Test_S17070C100()
{
  extern Class_Descriptor cd_S17070C100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,65)];
    init_test(&cd_S17070C100, buf);
    S17070C100 *dp, &lv = *(dp=new (buf) S17070C100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,256), "sizeof(S17070C100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C100)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C100");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C100");
    check_field_offset(lv, s17070c100f0, ABISELECT(104,72), "S17070C100.s17070c100f0");
    check_field_offset(lv, s17070c100f1, ABISELECT(360,248), "S17070C100.s17070c100f1");
    test_class_info(&lv, &cd_S17070C100);
    dp->~S17070C100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C100(Test_S17070C100, "S17070C100", ABISELECT(376,256));

#else // __cplusplus

extern void _ZN10S17070C100C1Ev();
extern void _ZN10S17070C100D1Ev();
Name_Map name_map_S17070C100[] = {
  NSPAIR(_ZN10S17070C100C1Ev),
  NSPAIR(_ZN10S17070C100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C100[];
extern void _ZN10S17070C100D1Ev();
extern void _ZN10S17070C100D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN10S17070C1003v87Ev();
extern void _ZN10S17070C1003v88Ev();
extern void _ZN10S17070C1003v89Ev();
extern void _ZN10S17070C1003v90Ev();
extern void _ZN10S17070C1003v91Ev();
extern void _ZN10S17070C1003v92Ev();
static  VTBL_ENTRY vtc_S17070C100[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C100[0]),
  (VTBL_ENTRY)&_ZN10S17070C100D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C100D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN10S17070C1003v87Ev,
  (VTBL_ENTRY)&_ZN10S17070C1003v88Ev,
  (VTBL_ENTRY)&_ZN10S17070C1003v89Ev,
  (VTBL_ENTRY)&_ZN10S17070C1003v90Ev,
  (VTBL_ENTRY)&_ZN10S17070C1003v91Ev,
  (VTBL_ENTRY)&_ZN10S17070C1003v92Ev,
};
extern VTBL_ENTRY _ZTI10S17070C100[];
extern  VTBL_ENTRY _ZTV10S17070C100[];
Class_Descriptor cd_S17070C100 = {  "S17070C100", // class name
  bases_S17070C100, 2,
  &(vtc_S17070C100[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,256), // object size
  NSPAIRA(_ZTI10S17070C100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C100),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C99  {
  ::S17070C100 s17070c99f0;
  ::S17070C101 s17070c99f1;
  void  mf17070c99(); // _ZN9S17070C9910mf17070c99Ev
};
//SIG(-1 S17070C99) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC19{ m FC20{ m FL}} Fp} FC21{ BC18 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC22{ BC18 vd v36 v37 v38 v39 v40 v41 v42 FC23{ m FC24{ m FL[2]}} Fp} FC22 FC22 FC21}} FC25{ m FC26{ m Fp[2]}}} FC10}


void  S17070C99 ::mf17070c99(){}

static void Test_S17070C99()
{
  {
    init_simple_test("S17070C99");
    S17070C99 lv;
    check2(sizeof(lv), ABISELECT(632,432), "sizeof(S17070C99)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C99)");
    check_field_offset(lv, s17070c99f0, 0, "S17070C99.s17070c99f0");
    check_field_offset(lv, s17070c99f1, ABISELECT(376,256), "S17070C99.s17070c99f1");
  }
}
static Arrange_To_Call_Me vS17070C99(Test_S17070C99, "S17070C99", ABISELECT(632,432));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C110  {
  void *s17070c110f0[2];
  void  mf17070c110(); // _ZN10S17070C11011mf17070c110Ev
};
//SIG(-1 S17070C110) C1{ m Fp[2]}


void  S17070C110 ::mf17070c110(){}

static void Test_S17070C110()
{
  {
    init_simple_test("S17070C110");
    S17070C110 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C110)");
    check_field_offset(lv, s17070c110f0, 0, "S17070C110.s17070c110f0");
  }
}
static Arrange_To_Call_Me vS17070C110(Test_S17070C110, "S17070C110", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C110[];
VTBL_ENTRY *P__ZTI10S17070C110 = _ZTI10S17070C110; 
Class_Descriptor cd_S17070C110 = {  "S17070C110", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C110),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C111  {
  ::S17070C95 s17070c111f0;
  ::S17070C95 s17070c111f1;
  ::S17070C95 s17070c111f2;
  ::S17070C97 s17070c111f3;
  ::S17070C97 s17070c111f4;
  void  mf17070c111(); // _ZN10S17070C11111mf17070c111Ev
};
//SIG(-1 S17070C111) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC4{ m FC5{ m FL[2]}} Fp} FC2 FC2 FC6{ BC3 vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC6}


void  S17070C111 ::mf17070c111(){}

static void Test_S17070C111()
{
  {
    init_simple_test("S17070C111");
    S17070C111 lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S17070C111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C111)");
    check_field_offset(lv, s17070c111f0, 0, "S17070C111.s17070c111f0");
    check_field_offset(lv, s17070c111f1, ABISELECT(32,24), "S17070C111.s17070c111f1");
    check_field_offset(lv, s17070c111f2, ABISELECT(64,48), "S17070C111.s17070c111f2");
    check_field_offset(lv, s17070c111f3, ABISELECT(96,72), "S17070C111.s17070c111f3");
    check_field_offset(lv, s17070c111f4, ABISELECT(120,84), "S17070C111.s17070c111f4");
  }
}
static Arrange_To_Call_Me vS17070C111(Test_S17070C111, "S17070C111", ABISELECT(144,96));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C109  : S17070C88 , S17070C110 {
  ::S17070C111 s17070c109f0;
  virtual void  v114(); // _ZN10S17070C1094v114Ev
  ~S17070C109(); // tgen
  S17070C109(); // tgen
};
//SIG(-1 S17070C109) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 FC12{ m FC13{ m FL[2]}} Fp} FC10 FC10 FC14{ BC11 vd v17 v18 v19 v20 v21 v22 v23 Fi Fp} FC14}}


void  S17070C109 ::v114(){vfunc_called(this, "_ZN10S17070C1094v114Ev");}
S17070C109 ::~S17070C109(){ note_dtor("S17070C109", this);} // tgen
S17070C109 ::S17070C109(){ note_ctor("S17070C109", this);} // tgen

static void Test_S17070C109()
{
  extern Class_Descriptor cd_S17070C109;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,41)];
    init_test(&cd_S17070C109, buf);
    S17070C109 *dp, &lv = *(dp=new (buf) S17070C109());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,160), "sizeof(S17070C109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C109)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C109");
    check_base_class_offset(lv, (S17070C110*), ABISELECT(72,56), "S17070C109");
    check_field_offset(lv, s17070c109f0, ABISELECT(88,64), "S17070C109.s17070c109f0");
    test_class_info(&lv, &cd_S17070C109);
    dp->~S17070C109();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C109(Test_S17070C109, "S17070C109", ABISELECT(232,160));

#else // __cplusplus

extern void _ZN10S17070C109C1Ev();
extern void _ZN10S17070C109D1Ev();
Name_Map name_map_S17070C109[] = {
  NSPAIR(_ZN10S17070C109C1Ev),
  NSPAIR(_ZN10S17070C109D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C110;
extern VTBL_ENTRY _ZTI10S17070C110[];
static Base_Class bases_S17070C109[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C110,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C109[];
extern void _ZN10S17070C109D1Ev();
extern void _ZN10S17070C109D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN10S17070C1094v114Ev();
static  VTBL_ENTRY vtc_S17070C109[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C109[0]),
  (VTBL_ENTRY)&_ZN10S17070C109D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C109D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN10S17070C1094v114Ev,
};
extern VTBL_ENTRY _ZTI10S17070C109[];
extern  VTBL_ENTRY _ZTV10S17070C109[];
Class_Descriptor cd_S17070C109 = {  "S17070C109", // class name
  bases_S17070C109, 2,
  &(vtc_S17070C109[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,160), // object size
  NSPAIRA(_ZTI10S17070C109),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17070C109),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C112  {
  ::S17070C110 s17070c112f0;
  void  mf17070c112(); // _ZN10S17070C11211mf17070c112Ev
};
//SIG(-1 S17070C112) C1{ m FC2{ m Fp[2]}}


void  S17070C112 ::mf17070c112(){}

static void Test_S17070C112()
{
  {
    init_simple_test("S17070C112");
    S17070C112 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C112)");
    check_field_offset(lv, s17070c112f0, 0, "S17070C112.s17070c112f0");
  }
}
static Arrange_To_Call_Me vS17070C112(Test_S17070C112, "S17070C112", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C108  : S17070C82 {
  ::S17070C109 s17070c108f0;
  ::S17070C112 s17070c108f1;
  virtual void  v108(); // _ZN10S17070C1084v108Ev
  virtual void  v109(); // _ZN10S17070C1084v109Ev
  virtual void  v110(); // _ZN10S17070C1084v110Ev
  virtual void  v111(); // _ZN10S17070C1084v111Ev
  virtual void  v112(); // _ZN10S17070C1084v112Ev
  virtual void  v113(); // _ZN10S17070C1084v113Ev
  ~S17070C108(); // tgen
  S17070C108(); // tgen
};
//SIG(-1 S17070C108) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC18{ m FC19{ m FL[2]}} Fp} FC16 FC16 FC20{ BC17 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC20}} FC21{ m FC14}}


void  S17070C108 ::v108(){vfunc_called(this, "_ZN10S17070C1084v108Ev");}
void  S17070C108 ::v109(){vfunc_called(this, "_ZN10S17070C1084v109Ev");}
void  S17070C108 ::v110(){vfunc_called(this, "_ZN10S17070C1084v110Ev");}
void  S17070C108 ::v111(){vfunc_called(this, "_ZN10S17070C1084v111Ev");}
void  S17070C108 ::v112(){vfunc_called(this, "_ZN10S17070C1084v112Ev");}
void  S17070C108 ::v113(){vfunc_called(this, "_ZN10S17070C1084v113Ev");}
S17070C108 ::~S17070C108(){ note_dtor("S17070C108", this);} // tgen
S17070C108 ::S17070C108(){ note_ctor("S17070C108", this);} // tgen

static void Test_S17070C108()
{
  extern Class_Descriptor cd_S17070C108;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,61)];
    init_test(&cd_S17070C108, buf);
    S17070C108 *dp, &lv = *(dp=new (buf) S17070C108());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,240), "sizeof(S17070C108)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C108)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C108");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C108");
    check_field_offset(lv, s17070c108f0, ABISELECT(104,72), "S17070C108.s17070c108f0");
    check_field_offset(lv, s17070c108f1, ABISELECT(336,232), "S17070C108.s17070c108f1");
    test_class_info(&lv, &cd_S17070C108);
    dp->~S17070C108();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C108(Test_S17070C108, "S17070C108", ABISELECT(352,240));

#else // __cplusplus

extern void _ZN10S17070C108C1Ev();
extern void _ZN10S17070C108D1Ev();
Name_Map name_map_S17070C108[] = {
  NSPAIR(_ZN10S17070C108C1Ev),
  NSPAIR(_ZN10S17070C108D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C108[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C108[];
extern void _ZN10S17070C108D1Ev();
extern void _ZN10S17070C108D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN10S17070C1084v108Ev();
extern void _ZN10S17070C1084v109Ev();
extern void _ZN10S17070C1084v110Ev();
extern void _ZN10S17070C1084v111Ev();
extern void _ZN10S17070C1084v112Ev();
extern void _ZN10S17070C1084v113Ev();
static  VTBL_ENTRY vtc_S17070C108[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C108[0]),
  (VTBL_ENTRY)&_ZN10S17070C108D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C108D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN10S17070C1084v108Ev,
  (VTBL_ENTRY)&_ZN10S17070C1084v109Ev,
  (VTBL_ENTRY)&_ZN10S17070C1084v110Ev,
  (VTBL_ENTRY)&_ZN10S17070C1084v111Ev,
  (VTBL_ENTRY)&_ZN10S17070C1084v112Ev,
  (VTBL_ENTRY)&_ZN10S17070C1084v113Ev,
};
extern VTBL_ENTRY _ZTI10S17070C108[];
extern  VTBL_ENTRY _ZTV10S17070C108[];
Class_Descriptor cd_S17070C108 = {  "S17070C108", // class name
  bases_S17070C108, 2,
  &(vtc_S17070C108[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,240), // object size
  NSPAIRA(_ZTI10S17070C108),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C108),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C107  {
  ::S17070C108 s17070c107f0;
  ::S17070C109 s17070c107f1;
  void  mf17070c107(); // _ZN10S17070C10711mf17070c107Ev
};
//SIG(-1 S17070C107) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC19{ m FC20{ m FL[2]}} Fp} FC17 FC17 FC21{ BC18 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC21}} FC22{ m FC15}} FC10}


void  S17070C107 ::mf17070c107(){}

static void Test_S17070C107()
{
  {
    init_simple_test("S17070C107");
    S17070C107 lv;
    check2(sizeof(lv), ABISELECT(584,400), "sizeof(S17070C107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C107)");
    check_field_offset(lv, s17070c107f0, 0, "S17070C107.s17070c107f0");
    check_field_offset(lv, s17070c107f1, ABISELECT(352,240), "S17070C107.s17070c107f1");
  }
}
static Arrange_To_Call_Me vS17070C107(Test_S17070C107, "S17070C107", ABISELECT(584,400));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C116  {
  void *s17070c116f0[2];
  void  mf17070c116(); // _ZN10S17070C11611mf17070c116Ev
};
//SIG(-1 S17070C116) C1{ m Fp[2]}


void  S17070C116 ::mf17070c116(){}

static void Test_S17070C116()
{
  {
    init_simple_test("S17070C116");
    S17070C116 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C116)");
    check_field_offset(lv, s17070c116f0, 0, "S17070C116.s17070c116f0");
  }
}
static Arrange_To_Call_Me vS17070C116(Test_S17070C116, "S17070C116", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C116[];
VTBL_ENTRY *P__ZTI10S17070C116 = _ZTI10S17070C116; 
Class_Descriptor cd_S17070C116 = {  "S17070C116", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C116),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C117  {
  ::S17070C104 s17070c117f0;
  ::S17070C97 s17070c117f1;
  ::S17070C95 s17070c117f2;
  ::S17070C97 s17070c117f3;
  ::S17070C97 s17070c117f4;
  ::S17070C95 s17070c117f5;
  ::S17070C95 s17070c117f6;
  ::S17070C97 s17070c117f7;
  ::S17070C97 s17070c117f8;
  ::S17070C97 s17070c117f9;
  ::S17070C97 s17070c117f10;
  ::S17070C97 s17070c117f11;
  ::S17070C97 s17070c117f12;
  ::S17070C97 s17070c117f13;
  ::S17070C97 s17070c117f14;
  ::S17070C97 s17070c117f15;
  ::S17070C97 s17070c117f16;
  ::S17070C97 s17070c117f17;
  ::S17070C97 s17070c117f18;
  void  mf17070c117(); // _ZN10S17070C11711mf17070c117Ev
};
//SIG(-1 S17070C117) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC4{ m FC5{ m FL}} Fp} FC6{ BC3 vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC7{ BC3 vd v22 v23 v24 v25 v26 v27 v28 FC8{ m FC9{ m FL[2]}} Fp} FC6 FC6 FC7 FC7 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6}


void  S17070C117 ::mf17070c117(){}

static void Test_S17070C117()
{
  {
    init_simple_test("S17070C117");
    S17070C117 lv;
    check2(sizeof(lv), ABISELECT(480,268), "sizeof(S17070C117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C117)");
    check_field_offset(lv, s17070c117f0, 0, "S17070C117.s17070c117f0");
    check_field_offset(lv, s17070c117f1, ABISELECT(24,16), "S17070C117.s17070c117f1");
    check_field_offset(lv, s17070c117f2, ABISELECT(48,28), "S17070C117.s17070c117f2");
    check_field_offset(lv, s17070c117f3, ABISELECT(80,52), "S17070C117.s17070c117f3");
    check_field_offset(lv, s17070c117f4, ABISELECT(104,64), "S17070C117.s17070c117f4");
    check_field_offset(lv, s17070c117f5, ABISELECT(128,76), "S17070C117.s17070c117f5");
    check_field_offset(lv, s17070c117f6, ABISELECT(160,100), "S17070C117.s17070c117f6");
    check_field_offset(lv, s17070c117f7, ABISELECT(192,124), "S17070C117.s17070c117f7");
    check_field_offset(lv, s17070c117f8, ABISELECT(216,136), "S17070C117.s17070c117f8");
    check_field_offset(lv, s17070c117f9, ABISELECT(240,148), "S17070C117.s17070c117f9");
    check_field_offset(lv, s17070c117f10, ABISELECT(264,160), "S17070C117.s17070c117f10");
    check_field_offset(lv, s17070c117f11, ABISELECT(288,172), "S17070C117.s17070c117f11");
    check_field_offset(lv, s17070c117f12, ABISELECT(312,184), "S17070C117.s17070c117f12");
    check_field_offset(lv, s17070c117f13, ABISELECT(336,196), "S17070C117.s17070c117f13");
    check_field_offset(lv, s17070c117f14, ABISELECT(360,208), "S17070C117.s17070c117f14");
    check_field_offset(lv, s17070c117f15, ABISELECT(384,220), "S17070C117.s17070c117f15");
    check_field_offset(lv, s17070c117f16, ABISELECT(408,232), "S17070C117.s17070c117f16");
    check_field_offset(lv, s17070c117f17, ABISELECT(432,244), "S17070C117.s17070c117f17");
    check_field_offset(lv, s17070c117f18, ABISELECT(456,256), "S17070C117.s17070c117f18");
  }
}
static Arrange_To_Call_Me vS17070C117(Test_S17070C117, "S17070C117", ABISELECT(480,268));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C115  : S17070C88 , S17070C116 {
  ::S17070C117 s17070c115f0;
  virtual void  v121(); // _ZN10S17070C1154v121Ev
  ~S17070C115(); // tgen
  S17070C115(); // tgen
};
//SIG(-1 S17070C115) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 FC12{ m FC13{ m FL}} Fp} FC14{ BC11 vd v17 v18 v19 v20 v21 v22 v23 Fi Fp} FC15{ BC11 vd v24 v25 v26 v27 v28 v29 v30 FC16{ m FC17{ m FL[2]}} Fp} FC14 FC14 FC15 FC15 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}}


void  S17070C115 ::v121(){vfunc_called(this, "_ZN10S17070C1154v121Ev");}
S17070C115 ::~S17070C115(){ note_dtor("S17070C115", this);} // tgen
S17070C115 ::S17070C115(){ note_ctor("S17070C115", this);} // tgen

static void Test_S17070C115()
{
  extern Class_Descriptor cd_S17070C115;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(72,84)];
    init_test(&cd_S17070C115, buf);
    S17070C115 *dp, &lv = *(dp=new (buf) S17070C115());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(568,332), "sizeof(S17070C115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C115)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C115");
    check_base_class_offset(lv, (S17070C116*), ABISELECT(72,56), "S17070C115");
    check_field_offset(lv, s17070c115f0, ABISELECT(88,64), "S17070C115.s17070c115f0");
    test_class_info(&lv, &cd_S17070C115);
    dp->~S17070C115();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C115(Test_S17070C115, "S17070C115", ABISELECT(568,332));

#else // __cplusplus

extern void _ZN10S17070C115C1Ev();
extern void _ZN10S17070C115D1Ev();
Name_Map name_map_S17070C115[] = {
  NSPAIR(_ZN10S17070C115C1Ev),
  NSPAIR(_ZN10S17070C115D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C116;
extern VTBL_ENTRY _ZTI10S17070C116[];
static Base_Class bases_S17070C115[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C116,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C115[];
extern void _ZN10S17070C115D1Ev();
extern void _ZN10S17070C115D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN10S17070C1154v121Ev();
static  VTBL_ENTRY vtc_S17070C115[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C115[0]),
  (VTBL_ENTRY)&_ZN10S17070C115D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C115D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN10S17070C1154v121Ev,
};
extern VTBL_ENTRY _ZTI10S17070C115[];
extern  VTBL_ENTRY _ZTV10S17070C115[];
Class_Descriptor cd_S17070C115 = {  "S17070C115", // class name
  bases_S17070C115, 2,
  &(vtc_S17070C115[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,332), // object size
  NSPAIRA(_ZTI10S17070C115),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17070C115),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C114  : S17070C82 {
  ::S17070C115 s17070c114f0;
  ::S17070C112 s17070c114f1;
  virtual void  v115(); // _ZN10S17070C1144v115Ev
  virtual void  v116(); // _ZN10S17070C1144v116Ev
  virtual void  v117(); // _ZN10S17070C1144v117Ev
  virtual void  v118(); // _ZN10S17070C1144v118Ev
  virtual void  v119(); // _ZN10S17070C1144v119Ev
  virtual void  v120(); // _ZN10S17070C1144v120Ev
  ~S17070C114(); // tgen
  S17070C114(); // tgen
};
//SIG(-1 S17070C114) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC18{ m FC19{ m FL}} Fp} FC20{ BC17 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC21{ BC17 vd v36 v37 v38 v39 v40 v41 v42 FC22{ m FC23{ m FL[2]}} Fp} FC20 FC20 FC21 FC21 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20}} FC24{ m FC25{ m Fp[2]}}}


void  S17070C114 ::v115(){vfunc_called(this, "_ZN10S17070C1144v115Ev");}
void  S17070C114 ::v116(){vfunc_called(this, "_ZN10S17070C1144v116Ev");}
void  S17070C114 ::v117(){vfunc_called(this, "_ZN10S17070C1144v117Ev");}
void  S17070C114 ::v118(){vfunc_called(this, "_ZN10S17070C1144v118Ev");}
void  S17070C114 ::v119(){vfunc_called(this, "_ZN10S17070C1144v119Ev");}
void  S17070C114 ::v120(){vfunc_called(this, "_ZN10S17070C1144v120Ev");}
S17070C114 ::~S17070C114(){ note_dtor("S17070C114", this);} // tgen
S17070C114 ::S17070C114(){ note_ctor("S17070C114", this);} // tgen

static void Test_S17070C114()
{
  extern Class_Descriptor cd_S17070C114;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(87,104)];
    init_test(&cd_S17070C114, buf);
    S17070C114 *dp, &lv = *(dp=new (buf) S17070C114());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(688,412), "sizeof(S17070C114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C114)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C114");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C114");
    check_field_offset(lv, s17070c114f0, ABISELECT(104,72), "S17070C114.s17070c114f0");
    check_field_offset(lv, s17070c114f1, ABISELECT(672,404), "S17070C114.s17070c114f1");
    test_class_info(&lv, &cd_S17070C114);
    dp->~S17070C114();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C114(Test_S17070C114, "S17070C114", ABISELECT(688,412));

#else // __cplusplus

extern void _ZN10S17070C114C1Ev();
extern void _ZN10S17070C114D1Ev();
Name_Map name_map_S17070C114[] = {
  NSPAIR(_ZN10S17070C114C1Ev),
  NSPAIR(_ZN10S17070C114D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C114[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C114[];
extern void _ZN10S17070C114D1Ev();
extern void _ZN10S17070C114D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN10S17070C1144v115Ev();
extern void _ZN10S17070C1144v116Ev();
extern void _ZN10S17070C1144v117Ev();
extern void _ZN10S17070C1144v118Ev();
extern void _ZN10S17070C1144v119Ev();
extern void _ZN10S17070C1144v120Ev();
static  VTBL_ENTRY vtc_S17070C114[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C114[0]),
  (VTBL_ENTRY)&_ZN10S17070C114D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C114D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN10S17070C1144v115Ev,
  (VTBL_ENTRY)&_ZN10S17070C1144v116Ev,
  (VTBL_ENTRY)&_ZN10S17070C1144v117Ev,
  (VTBL_ENTRY)&_ZN10S17070C1144v118Ev,
  (VTBL_ENTRY)&_ZN10S17070C1144v119Ev,
  (VTBL_ENTRY)&_ZN10S17070C1144v120Ev,
};
extern VTBL_ENTRY _ZTI10S17070C114[];
extern  VTBL_ENTRY _ZTV10S17070C114[];
Class_Descriptor cd_S17070C114 = {  "S17070C114", // class name
  bases_S17070C114, 2,
  &(vtc_S17070C114[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(688,412), // object size
  NSPAIRA(_ZTI10S17070C114),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C114),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C113  {
  ::S17070C114 s17070c113f0;
  ::S17070C115 s17070c113f1;
  void  mf17070c113(); // _ZN10S17070C11311mf17070c113Ev
};
//SIG(-1 S17070C113) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC19{ m FC20{ m FL}} Fp} FC21{ BC18 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC22{ BC18 vd v36 v37 v38 v39 v40 v41 v42 FC23{ m FC24{ m FL[2]}} Fp} FC21 FC21 FC22 FC22 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21}} FC25{ m FC26{ m Fp[2]}}} FC10}


void  S17070C113 ::mf17070c113(){}

static void Test_S17070C113()
{
  {
    init_simple_test("S17070C113");
    S17070C113 lv;
    check2(sizeof(lv), ABISELECT(1256,744), "sizeof(S17070C113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C113)");
    check_field_offset(lv, s17070c113f0, 0, "S17070C113.s17070c113f0");
    check_field_offset(lv, s17070c113f1, ABISELECT(688,412), "S17070C113.s17070c113f1");
  }
}
static Arrange_To_Call_Me vS17070C113(Test_S17070C113, "S17070C113", ABISELECT(1256,744));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C122  {
  void *s17070c122f0[2];
  void  mf17070c122(); // _ZN10S17070C12211mf17070c122Ev
};
//SIG(-1 S17070C122) C1{ m Fp[2]}


void  S17070C122 ::mf17070c122(){}

static void Test_S17070C122()
{
  {
    init_simple_test("S17070C122");
    S17070C122 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C122)");
    check_field_offset(lv, s17070c122f0, 0, "S17070C122.s17070c122f0");
  }
}
static Arrange_To_Call_Me vS17070C122(Test_S17070C122, "S17070C122", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C122[];
VTBL_ENTRY *P__ZTI10S17070C122 = _ZTI10S17070C122; 
Class_Descriptor cd_S17070C122 = {  "S17070C122", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C122),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C123  {
  ::S17070C97 s17070c123f0;
  ::S17070C97 s17070c123f1;
  ::S17070C97 s17070c123f2;
  ::S17070C97 s17070c123f3;
  ::S17070C97 s17070c123f4;
  ::S17070C97 s17070c123f5;
  ::S17070C97 s17070c123f6;
  void  mf17070c123(); // _ZN10S17070C12311mf17070c123Ev
};
//SIG(-1 S17070C123) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC2 FC2 FC2 FC2 FC2 FC2}


void  S17070C123 ::mf17070c123(){}

static void Test_S17070C123()
{
  {
    init_simple_test("S17070C123");
    S17070C123 lv;
    check2(sizeof(lv), ABISELECT(168,84), "sizeof(S17070C123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C123)");
    check_field_offset(lv, s17070c123f0, 0, "S17070C123.s17070c123f0");
    check_field_offset(lv, s17070c123f1, ABISELECT(24,12), "S17070C123.s17070c123f1");
    check_field_offset(lv, s17070c123f2, ABISELECT(48,24), "S17070C123.s17070c123f2");
    check_field_offset(lv, s17070c123f3, ABISELECT(72,36), "S17070C123.s17070c123f3");
    check_field_offset(lv, s17070c123f4, ABISELECT(96,48), "S17070C123.s17070c123f4");
    check_field_offset(lv, s17070c123f5, ABISELECT(120,60), "S17070C123.s17070c123f5");
    check_field_offset(lv, s17070c123f6, ABISELECT(144,72), "S17070C123.s17070c123f6");
  }
}
static Arrange_To_Call_Me vS17070C123(Test_S17070C123, "S17070C123", ABISELECT(168,84));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C121  : S17070C88 , S17070C122 {
  ::S17070C123 s17070c121f0;
  virtual void  v128(); // _ZN10S17070C1214v128Ev
  ~S17070C121(); // tgen
  S17070C121(); // tgen
};
//SIG(-1 S17070C121) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC10 FC10 FC10 FC10 FC10 FC10}}


void  S17070C121 ::v128(){vfunc_called(this, "_ZN10S17070C1214v128Ev");}
S17070C121 ::~S17070C121(){ note_dtor("S17070C121", this);} // tgen
S17070C121 ::S17070C121(){ note_ctor("S17070C121", this);} // tgen

static void Test_S17070C121()
{
  extern Class_Descriptor cd_S17070C121;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,38)];
    init_test(&cd_S17070C121, buf);
    S17070C121 *dp, &lv = *(dp=new (buf) S17070C121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,148), "sizeof(S17070C121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C121)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C121");
    check_base_class_offset(lv, (S17070C122*), ABISELECT(72,56), "S17070C121");
    check_field_offset(lv, s17070c121f0, ABISELECT(88,64), "S17070C121.s17070c121f0");
    test_class_info(&lv, &cd_S17070C121);
    dp->~S17070C121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C121(Test_S17070C121, "S17070C121", ABISELECT(256,148));

#else // __cplusplus

extern void _ZN10S17070C121C1Ev();
extern void _ZN10S17070C121D1Ev();
Name_Map name_map_S17070C121[] = {
  NSPAIR(_ZN10S17070C121C1Ev),
  NSPAIR(_ZN10S17070C121D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C122;
extern VTBL_ENTRY _ZTI10S17070C122[];
static Base_Class bases_S17070C121[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C122,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C121[];
extern void _ZN10S17070C121D1Ev();
extern void _ZN10S17070C121D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN10S17070C1214v128Ev();
static  VTBL_ENTRY vtc_S17070C121[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C121[0]),
  (VTBL_ENTRY)&_ZN10S17070C121D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C121D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN10S17070C1214v128Ev,
};
extern VTBL_ENTRY _ZTI10S17070C121[];
extern  VTBL_ENTRY _ZTV10S17070C121[];
Class_Descriptor cd_S17070C121 = {  "S17070C121", // class name
  bases_S17070C121, 2,
  &(vtc_S17070C121[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,148), // object size
  NSPAIRA(_ZTI10S17070C121),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17070C121),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C124  {
  ::S17070C122 s17070c124f0;
  void  mf17070c124(); // _ZN10S17070C12411mf17070c124Ev
};
//SIG(-1 S17070C124) C1{ m FC2{ m Fp[2]}}


void  S17070C124 ::mf17070c124(){}

static void Test_S17070C124()
{
  {
    init_simple_test("S17070C124");
    S17070C124 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C124)");
    check_field_offset(lv, s17070c124f0, 0, "S17070C124.s17070c124f0");
  }
}
static Arrange_To_Call_Me vS17070C124(Test_S17070C124, "S17070C124", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C120  : S17070C82 {
  ::S17070C121 s17070c120f0;
  ::S17070C124 s17070c120f1;
  virtual void  v122(); // _ZN10S17070C1204v122Ev
  virtual void  v123(); // _ZN10S17070C1204v123Ev
  virtual void  v124(); // _ZN10S17070C1204v124Ev
  virtual void  v125(); // _ZN10S17070C1204v125Ev
  virtual void  v126(); // _ZN10S17070C1204v126Ev
  virtual void  v127(); // _ZN10S17070C1204v127Ev
  ~S17070C120(); // tgen
  S17070C120(); // tgen
};
//SIG(-1 S17070C120) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC16 FC16 FC16 FC16 FC16 FC16}} FC18{ m FC14}}


void  S17070C120 ::v122(){vfunc_called(this, "_ZN10S17070C1204v122Ev");}
void  S17070C120 ::v123(){vfunc_called(this, "_ZN10S17070C1204v123Ev");}
void  S17070C120 ::v124(){vfunc_called(this, "_ZN10S17070C1204v124Ev");}
void  S17070C120 ::v125(){vfunc_called(this, "_ZN10S17070C1204v125Ev");}
void  S17070C120 ::v126(){vfunc_called(this, "_ZN10S17070C1204v126Ev");}
void  S17070C120 ::v127(){vfunc_called(this, "_ZN10S17070C1204v127Ev");}
S17070C120 ::~S17070C120(){ note_dtor("S17070C120", this);} // tgen
S17070C120 ::S17070C120(){ note_ctor("S17070C120", this);} // tgen

static void Test_S17070C120()
{
  extern Class_Descriptor cd_S17070C120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,58)];
    init_test(&cd_S17070C120, buf);
    S17070C120 *dp, &lv = *(dp=new (buf) S17070C120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,228), "sizeof(S17070C120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C120)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C120");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C120");
    check_field_offset(lv, s17070c120f0, ABISELECT(104,72), "S17070C120.s17070c120f0");
    check_field_offset(lv, s17070c120f1, ABISELECT(360,220), "S17070C120.s17070c120f1");
    test_class_info(&lv, &cd_S17070C120);
    dp->~S17070C120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C120(Test_S17070C120, "S17070C120", ABISELECT(376,228));

#else // __cplusplus

extern void _ZN10S17070C120C1Ev();
extern void _ZN10S17070C120D1Ev();
Name_Map name_map_S17070C120[] = {
  NSPAIR(_ZN10S17070C120C1Ev),
  NSPAIR(_ZN10S17070C120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C120[];
extern void _ZN10S17070C120D1Ev();
extern void _ZN10S17070C120D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN10S17070C1204v122Ev();
extern void _ZN10S17070C1204v123Ev();
extern void _ZN10S17070C1204v124Ev();
extern void _ZN10S17070C1204v125Ev();
extern void _ZN10S17070C1204v126Ev();
extern void _ZN10S17070C1204v127Ev();
static  VTBL_ENTRY vtc_S17070C120[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C120[0]),
  (VTBL_ENTRY)&_ZN10S17070C120D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C120D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN10S17070C1204v122Ev,
  (VTBL_ENTRY)&_ZN10S17070C1204v123Ev,
  (VTBL_ENTRY)&_ZN10S17070C1204v124Ev,
  (VTBL_ENTRY)&_ZN10S17070C1204v125Ev,
  (VTBL_ENTRY)&_ZN10S17070C1204v126Ev,
  (VTBL_ENTRY)&_ZN10S17070C1204v127Ev,
};
extern VTBL_ENTRY _ZTI10S17070C120[];
extern  VTBL_ENTRY _ZTV10S17070C120[];
Class_Descriptor cd_S17070C120 = {  "S17070C120", // class name
  bases_S17070C120, 2,
  &(vtc_S17070C120[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,228), // object size
  NSPAIRA(_ZTI10S17070C120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C120),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C119  {
  ::S17070C120 s17070c119f0;
  ::S17070C121 s17070c119f1;
  void  mf17070c119(); // _ZN10S17070C11911mf17070c119Ev
};
//SIG(-1 S17070C119) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC17 FC17 FC17 FC17 FC17 FC17}} FC19{ m FC15}} FC10}


void  S17070C119 ::mf17070c119(){}

static void Test_S17070C119()
{
  {
    init_simple_test("S17070C119");
    S17070C119 lv;
    check2(sizeof(lv), ABISELECT(632,376), "sizeof(S17070C119)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C119)");
    check_field_offset(lv, s17070c119f0, 0, "S17070C119.s17070c119f0");
    check_field_offset(lv, s17070c119f1, ABISELECT(376,228), "S17070C119.s17070c119f1");
  }
}
static Arrange_To_Call_Me vS17070C119(Test_S17070C119, "S17070C119", ABISELECT(632,376));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C128  {
  void *s17070c128f0[2];
  void  mf17070c128(); // _ZN10S17070C12811mf17070c128Ev
};
//SIG(-1 S17070C128) C1{ m Fp[2]}


void  S17070C128 ::mf17070c128(){}

static void Test_S17070C128()
{
  {
    init_simple_test("S17070C128");
    S17070C128 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C128)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C128)");
    check_field_offset(lv, s17070c128f0, 0, "S17070C128.s17070c128f0");
  }
}
static Arrange_To_Call_Me vS17070C128(Test_S17070C128, "S17070C128", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C128[];
VTBL_ENTRY *P__ZTI10S17070C128 = _ZTI10S17070C128; 
Class_Descriptor cd_S17070C128 = {  "S17070C128", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C128),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C131_nt  {
  ::S17070C17_nt s17070c131f0;
  void  mf17070c131(); // _ZN13S17070C131_nt11mf17070c131Ev
};
//SIG(-1 S17070C131_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S17070C131_nt ::mf17070c131(){}

//skip512 S17070C131_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C130  : S17070C96 {
  ::S17070C131_nt s17070c130f0;
  void *s17070c130f1;
  virtual  ~S17070C130(); // _ZN10S17070C130D1Ev
  virtual void  v136(); // _ZN10S17070C1304v136Ev
  virtual void  v137(); // _ZN10S17070C1304v137Ev
  virtual void  v138(); // _ZN10S17070C1304v138Ev
  virtual void  v139(); // _ZN10S17070C1304v139Ev
  virtual void  v140(); // _ZN10S17070C1304v140Ev
  virtual void  v141(); // _ZN10S17070C1304v141Ev
  virtual void  v142(); // _ZN10S17070C1304v142Ev
  S17070C130(); // tgen
};
//SIG(-1 S17070C130) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m FC4{ m FC5{ m FL[2]}}} Fp}


 S17070C130 ::~S17070C130(){ note_dtor("S17070C130", this);}
void  S17070C130 ::v136(){vfunc_called(this, "_ZN10S17070C1304v136Ev");}
void  S17070C130 ::v137(){vfunc_called(this, "_ZN10S17070C1304v137Ev");}
void  S17070C130 ::v138(){vfunc_called(this, "_ZN10S17070C1304v138Ev");}
void  S17070C130 ::v139(){vfunc_called(this, "_ZN10S17070C1304v139Ev");}
void  S17070C130 ::v140(){vfunc_called(this, "_ZN10S17070C1304v140Ev");}
void  S17070C130 ::v141(){vfunc_called(this, "_ZN10S17070C1304v141Ev");}
void  S17070C130 ::v142(){vfunc_called(this, "_ZN10S17070C1304v142Ev");}
S17070C130 ::S17070C130(){ note_ctor("S17070C130", this);} // tgen

static void Test_S17070C130()
{
  extern Class_Descriptor cd_S17070C130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S17070C130, buf);
    S17070C130 *dp, &lv = *(dp=new (buf) S17070C130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S17070C130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C130)");
    check_base_class_offset(lv, (S17070C96*), 0, "S17070C130");
    check_field_offset(lv, s17070c130f0, ABISELECT(8,4), "S17070C130.s17070c130f0");
    check_field_offset(lv, s17070c130f1, ABISELECT(24,20), "S17070C130.s17070c130f1");
    test_class_info(&lv, &cd_S17070C130);
    dp->~S17070C130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C130(Test_S17070C130, "S17070C130", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN10S17070C130C1Ev();
extern void _ZN10S17070C130D1Ev();
Name_Map name_map_S17070C130[] = {
  NSPAIR(_ZN10S17070C130C1Ev),
  NSPAIR(_ZN10S17070C130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C96;
extern VTBL_ENTRY _ZTI9S17070C96[];
extern  VTBL_ENTRY _ZTV9S17070C96[];
static Base_Class bases_S17070C130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C130[];
extern void _ZN10S17070C130D1Ev();
extern void _ZN10S17070C130D0Ev();
extern void _ZN9S17070C963v73Ev();
extern void _ZN9S17070C963v74Ev();
extern void _ZN9S17070C963v75Ev();
extern void _ZN9S17070C963v76Ev();
extern void _ZN9S17070C963v77Ev();
extern void _ZN9S17070C963v78Ev();
extern void _ZN9S17070C963v79Ev();
extern void _ZN10S17070C1304v136Ev();
extern void _ZN10S17070C1304v137Ev();
extern void _ZN10S17070C1304v138Ev();
extern void _ZN10S17070C1304v139Ev();
extern void _ZN10S17070C1304v140Ev();
extern void _ZN10S17070C1304v141Ev();
extern void _ZN10S17070C1304v142Ev();
static  VTBL_ENTRY vtc_S17070C130[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C130[0]),
  (VTBL_ENTRY)&_ZN10S17070C130D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C130D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v73Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v74Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v75Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v76Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v77Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v78Ev,
  (VTBL_ENTRY)&_ZN9S17070C963v79Ev,
  (VTBL_ENTRY)&_ZN10S17070C1304v136Ev,
  (VTBL_ENTRY)&_ZN10S17070C1304v137Ev,
  (VTBL_ENTRY)&_ZN10S17070C1304v138Ev,
  (VTBL_ENTRY)&_ZN10S17070C1304v139Ev,
  (VTBL_ENTRY)&_ZN10S17070C1304v140Ev,
  (VTBL_ENTRY)&_ZN10S17070C1304v141Ev,
  (VTBL_ENTRY)&_ZN10S17070C1304v142Ev,
};
extern VTBL_ENTRY _ZTI10S17070C130[];
extern  VTBL_ENTRY _ZTV10S17070C130[];
Class_Descriptor cd_S17070C130 = {  "S17070C130", // class name
  bases_S17070C130, 1,
  &(vtc_S17070C130[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI10S17070C130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C130),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C129  {
  ::S17070C97 s17070c129f0;
  ::S17070C95 s17070c129f1;
  ::S17070C130 s17070c129f2;
  ::S17070C95 s17070c129f3;
  ::S17070C97 s17070c129f4;
  ::S17070C97 s17070c129f5;
  ::S17070C97 s17070c129f6;
  ::S17070C95 s17070c129f7;
  ::S17070C97 s17070c129f8;
  ::S17070C95 s17070c129f9;
  ::S17070C97 s17070c129f10;
  ::S17070C95 s17070c129f11;
  ::S17070C95 s17070c129f12;
  ::S17070C97 s17070c129f13;
  ::S17070C97 s17070c129f14;
  void  mf17070c129(); // _ZN10S17070C12911mf17070c129Ev
};
//SIG(-1 S17070C129) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC4{ BC3 vd v15 v16 v17 v18 v19 v20 v21 FC5{ m FC6{ m FL[2]}} Fp} FC7{ BC3 vd v22 v23 v24 v25 v26 v27 v28 FC8{ m FC5} Fp} FC4 FC2 FC2 FC2 FC4 FC2 FC4 FC2 FC4 FC4 FC2 FC2}


void  S17070C129 ::mf17070c129(){}

static void Test_S17070C129()
{
  {
    init_simple_test("S17070C129");
    S17070C129 lv;
    check2(sizeof(lv), ABISELECT(416,264), "sizeof(S17070C129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C129)");
    check_field_offset(lv, s17070c129f0, 0, "S17070C129.s17070c129f0");
    check_field_offset(lv, s17070c129f1, ABISELECT(24,12), "S17070C129.s17070c129f1");
    check_field_offset(lv, s17070c129f2, ABISELECT(56,36), "S17070C129.s17070c129f2");
    check_field_offset(lv, s17070c129f3, ABISELECT(88,60), "S17070C129.s17070c129f3");
    check_field_offset(lv, s17070c129f4, ABISELECT(120,84), "S17070C129.s17070c129f4");
    check_field_offset(lv, s17070c129f5, ABISELECT(144,96), "S17070C129.s17070c129f5");
    check_field_offset(lv, s17070c129f6, ABISELECT(168,108), "S17070C129.s17070c129f6");
    check_field_offset(lv, s17070c129f7, ABISELECT(192,120), "S17070C129.s17070c129f7");
    check_field_offset(lv, s17070c129f8, ABISELECT(224,144), "S17070C129.s17070c129f8");
    check_field_offset(lv, s17070c129f9, ABISELECT(248,156), "S17070C129.s17070c129f9");
    check_field_offset(lv, s17070c129f10, ABISELECT(280,180), "S17070C129.s17070c129f10");
    check_field_offset(lv, s17070c129f11, ABISELECT(304,192), "S17070C129.s17070c129f11");
    check_field_offset(lv, s17070c129f12, ABISELECT(336,216), "S17070C129.s17070c129f12");
    check_field_offset(lv, s17070c129f13, ABISELECT(368,240), "S17070C129.s17070c129f13");
    check_field_offset(lv, s17070c129f14, ABISELECT(392,252), "S17070C129.s17070c129f14");
  }
}
static Arrange_To_Call_Me vS17070C129(Test_S17070C129, "S17070C129", ABISELECT(416,264));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C127  : S17070C88 , S17070C128 {
  ::S17070C129 s17070c127f0;
  virtual void  v135(); // _ZN10S17070C1274v135Ev
  ~S17070C127(); // tgen
  S17070C127(); // tgen
};
//SIG(-1 S17070C127) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC12{ BC11 vd v17 v18 v19 v20 v21 v22 v23 FC13{ m FC14{ m FL[2]}} Fp} FC15{ BC11 vd v24 v25 v26 v27 v28 v29 v30 FC16{ m FC13} Fp} FC12 FC10 FC10 FC10 FC12 FC10 FC12 FC10 FC12 FC12 FC10 FC10}}


void  S17070C127 ::v135(){vfunc_called(this, "_ZN10S17070C1274v135Ev");}
S17070C127 ::~S17070C127(){ note_dtor("S17070C127", this);} // tgen
S17070C127 ::S17070C127(){ note_ctor("S17070C127", this);} // tgen

static void Test_S17070C127()
{
  extern Class_Descriptor cd_S17070C127;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(64,83)];
    init_test(&cd_S17070C127, buf);
    S17070C127 *dp, &lv = *(dp=new (buf) S17070C127());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(504,328), "sizeof(S17070C127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C127)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C127");
    check_base_class_offset(lv, (S17070C128*), ABISELECT(72,56), "S17070C127");
    check_field_offset(lv, s17070c127f0, ABISELECT(88,64), "S17070C127.s17070c127f0");
    test_class_info(&lv, &cd_S17070C127);
    dp->~S17070C127();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C127(Test_S17070C127, "S17070C127", ABISELECT(504,328));

#else // __cplusplus

extern void _ZN10S17070C127C1Ev();
extern void _ZN10S17070C127D1Ev();
Name_Map name_map_S17070C127[] = {
  NSPAIR(_ZN10S17070C127C1Ev),
  NSPAIR(_ZN10S17070C127D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C128;
extern VTBL_ENTRY _ZTI10S17070C128[];
static Base_Class bases_S17070C127[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C128,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C127[];
extern void _ZN10S17070C127D1Ev();
extern void _ZN10S17070C127D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN10S17070C1274v135Ev();
static  VTBL_ENTRY vtc_S17070C127[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C127[0]),
  (VTBL_ENTRY)&_ZN10S17070C127D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C127D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN10S17070C1274v135Ev,
};
extern VTBL_ENTRY _ZTI10S17070C127[];
extern  VTBL_ENTRY _ZTV10S17070C127[];
Class_Descriptor cd_S17070C127 = {  "S17070C127", // class name
  bases_S17070C127, 2,
  &(vtc_S17070C127[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(504,328), // object size
  NSPAIRA(_ZTI10S17070C127),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17070C127),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C126  : S17070C82 {
  ::S17070C127 s17070c126f0;
  ::S17070C124 s17070c126f1;
  virtual void  v129(); // _ZN10S17070C1264v129Ev
  virtual void  v130(); // _ZN10S17070C1264v130Ev
  virtual void  v131(); // _ZN10S17070C1264v131Ev
  virtual void  v132(); // _ZN10S17070C1264v132Ev
  virtual void  v133(); // _ZN10S17070C1264v133Ev
  virtual void  v134(); // _ZN10S17070C1264v134Ev
  ~S17070C126(); // tgen
  S17070C126(); // tgen
};
//SIG(-1 S17070C126) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC18{ BC17 vd v29 v30 v31 v32 v33 v34 v35 FC19{ m FC20{ m FL[2]}} Fp} FC21{ BC17 vd v36 v37 v38 v39 v40 v41 v42 FC22{ m FC19} Fp} FC18 FC16 FC16 FC16 FC18 FC16 FC18 FC16 FC18 FC18 FC16 FC16}} FC23{ m FC24{ m Fp[2]}}}


void  S17070C126 ::v129(){vfunc_called(this, "_ZN10S17070C1264v129Ev");}
void  S17070C126 ::v130(){vfunc_called(this, "_ZN10S17070C1264v130Ev");}
void  S17070C126 ::v131(){vfunc_called(this, "_ZN10S17070C1264v131Ev");}
void  S17070C126 ::v132(){vfunc_called(this, "_ZN10S17070C1264v132Ev");}
void  S17070C126 ::v133(){vfunc_called(this, "_ZN10S17070C1264v133Ev");}
void  S17070C126 ::v134(){vfunc_called(this, "_ZN10S17070C1264v134Ev");}
S17070C126 ::~S17070C126(){ note_dtor("S17070C126", this);} // tgen
S17070C126 ::S17070C126(){ note_ctor("S17070C126", this);} // tgen

static void Test_S17070C126()
{
  extern Class_Descriptor cd_S17070C126;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(79,103)];
    init_test(&cd_S17070C126, buf);
    S17070C126 *dp, &lv = *(dp=new (buf) S17070C126());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(624,408), "sizeof(S17070C126)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C126)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C126");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C126");
    check_field_offset(lv, s17070c126f0, ABISELECT(104,72), "S17070C126.s17070c126f0");
    check_field_offset(lv, s17070c126f1, ABISELECT(608,400), "S17070C126.s17070c126f1");
    test_class_info(&lv, &cd_S17070C126);
    dp->~S17070C126();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C126(Test_S17070C126, "S17070C126", ABISELECT(624,408));

#else // __cplusplus

extern void _ZN10S17070C126C1Ev();
extern void _ZN10S17070C126D1Ev();
Name_Map name_map_S17070C126[] = {
  NSPAIR(_ZN10S17070C126C1Ev),
  NSPAIR(_ZN10S17070C126D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C126[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C126[];
extern void _ZN10S17070C126D1Ev();
extern void _ZN10S17070C126D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN10S17070C1264v129Ev();
extern void _ZN10S17070C1264v130Ev();
extern void _ZN10S17070C1264v131Ev();
extern void _ZN10S17070C1264v132Ev();
extern void _ZN10S17070C1264v133Ev();
extern void _ZN10S17070C1264v134Ev();
static  VTBL_ENTRY vtc_S17070C126[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C126[0]),
  (VTBL_ENTRY)&_ZN10S17070C126D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C126D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN10S17070C1264v129Ev,
  (VTBL_ENTRY)&_ZN10S17070C1264v130Ev,
  (VTBL_ENTRY)&_ZN10S17070C1264v131Ev,
  (VTBL_ENTRY)&_ZN10S17070C1264v132Ev,
  (VTBL_ENTRY)&_ZN10S17070C1264v133Ev,
  (VTBL_ENTRY)&_ZN10S17070C1264v134Ev,
};
extern VTBL_ENTRY _ZTI10S17070C126[];
extern  VTBL_ENTRY _ZTV10S17070C126[];
Class_Descriptor cd_S17070C126 = {  "S17070C126", // class name
  bases_S17070C126, 2,
  &(vtc_S17070C126[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(624,408), // object size
  NSPAIRA(_ZTI10S17070C126),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C126),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C125  {
  ::S17070C126 s17070c125f0;
  ::S17070C127 s17070c125f1;
  void  mf17070c125(); // _ZN10S17070C12511mf17070c125Ev
};
//SIG(-1 S17070C125) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC19{ BC18 vd v29 v30 v31 v32 v33 v34 v35 FC20{ m FC21{ m FL[2]}} Fp} FC22{ BC18 vd v36 v37 v38 v39 v40 v41 v42 FC23{ m FC20} Fp} FC19 FC17 FC17 FC17 FC19 FC17 FC19 FC17 FC19 FC19 FC17 FC17}} FC24{ m FC25{ m Fp[2]}}} FC10}


void  S17070C125 ::mf17070c125(){}

static void Test_S17070C125()
{
  {
    init_simple_test("S17070C125");
    S17070C125 lv;
    check2(sizeof(lv), ABISELECT(1128,736), "sizeof(S17070C125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C125)");
    check_field_offset(lv, s17070c125f0, 0, "S17070C125.s17070c125f0");
    check_field_offset(lv, s17070c125f1, ABISELECT(624,408), "S17070C125.s17070c125f1");
  }
}
static Arrange_To_Call_Me vS17070C125(Test_S17070C125, "S17070C125", ABISELECT(1128,736));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C136  {
  void *s17070c136f0[2];
  void  mf17070c136(); // _ZN10S17070C13611mf17070c136Ev
};
//SIG(-1 S17070C136) C1{ m Fp[2]}


void  S17070C136 ::mf17070c136(){}

static void Test_S17070C136()
{
  {
    init_simple_test("S17070C136");
    S17070C136 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C136)");
    check_field_offset(lv, s17070c136f0, 0, "S17070C136.s17070c136f0");
  }
}
static Arrange_To_Call_Me vS17070C136(Test_S17070C136, "S17070C136", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C136[];
VTBL_ENTRY *P__ZTI10S17070C136 = _ZTI10S17070C136; 
Class_Descriptor cd_S17070C136 = {  "S17070C136", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C136),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C137  {
  ::S17070C104 s17070c137f0;
  ::S17070C97 s17070c137f1;
  ::S17070C97 s17070c137f2;
  ::S17070C97 s17070c137f3;
  ::S17070C97 s17070c137f4;
  ::S17070C97 s17070c137f5;
  ::S17070C97 s17070c137f6;
  ::S17070C97 s17070c137f7;
  ::S17070C97 s17070c137f8;
  void  mf17070c137(); // _ZN10S17070C13711mf17070c137Ev
};
//SIG(-1 S17070C137) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC4{ m FC5{ m FL}} Fp} FC6{ BC3 vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC6 FC6 FC6 FC6 FC6 FC6 FC6}


void  S17070C137 ::mf17070c137(){}

static void Test_S17070C137()
{
  {
    init_simple_test("S17070C137");
    S17070C137 lv;
    check2(sizeof(lv), ABISELECT(216,112), "sizeof(S17070C137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C137)");
    check_field_offset(lv, s17070c137f0, 0, "S17070C137.s17070c137f0");
    check_field_offset(lv, s17070c137f1, ABISELECT(24,16), "S17070C137.s17070c137f1");
    check_field_offset(lv, s17070c137f2, ABISELECT(48,28), "S17070C137.s17070c137f2");
    check_field_offset(lv, s17070c137f3, ABISELECT(72,40), "S17070C137.s17070c137f3");
    check_field_offset(lv, s17070c137f4, ABISELECT(96,52), "S17070C137.s17070c137f4");
    check_field_offset(lv, s17070c137f5, ABISELECT(120,64), "S17070C137.s17070c137f5");
    check_field_offset(lv, s17070c137f6, ABISELECT(144,76), "S17070C137.s17070c137f6");
    check_field_offset(lv, s17070c137f7, ABISELECT(168,88), "S17070C137.s17070c137f7");
    check_field_offset(lv, s17070c137f8, ABISELECT(192,100), "S17070C137.s17070c137f8");
  }
}
static Arrange_To_Call_Me vS17070C137(Test_S17070C137, "S17070C137", ABISELECT(216,112));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C135  : S17070C88 , S17070C136 {
  ::S17070C137 s17070c135f0;
  virtual void  v149(); // _ZN10S17070C1354v149Ev
  ~S17070C135(); // tgen
  S17070C135(); // tgen
};
//SIG(-1 S17070C135) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 FC12{ m FC13{ m FL}} Fp} FC14{ BC11 vd v17 v18 v19 v20 v21 v22 v23 Fi Fp} FC14 FC14 FC14 FC14 FC14 FC14 FC14}}


void  S17070C135 ::v149(){vfunc_called(this, "_ZN10S17070C1354v149Ev");}
S17070C135 ::~S17070C135(){ note_dtor("S17070C135", this);} // tgen
S17070C135 ::S17070C135(){ note_ctor("S17070C135", this);} // tgen

static void Test_S17070C135()
{
  extern Class_Descriptor cd_S17070C135;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,45)];
    init_test(&cd_S17070C135, buf);
    S17070C135 *dp, &lv = *(dp=new (buf) S17070C135());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,176), "sizeof(S17070C135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C135)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C135");
    check_base_class_offset(lv, (S17070C136*), ABISELECT(72,56), "S17070C135");
    check_field_offset(lv, s17070c135f0, ABISELECT(88,64), "S17070C135.s17070c135f0");
    test_class_info(&lv, &cd_S17070C135);
    dp->~S17070C135();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C135(Test_S17070C135, "S17070C135", ABISELECT(304,176));

#else // __cplusplus

extern void _ZN10S17070C135C1Ev();
extern void _ZN10S17070C135D1Ev();
Name_Map name_map_S17070C135[] = {
  NSPAIR(_ZN10S17070C135C1Ev),
  NSPAIR(_ZN10S17070C135D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C136;
extern VTBL_ENTRY _ZTI10S17070C136[];
static Base_Class bases_S17070C135[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C136,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C135[];
extern void _ZN10S17070C135D1Ev();
extern void _ZN10S17070C135D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN10S17070C1354v149Ev();
static  VTBL_ENTRY vtc_S17070C135[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C135[0]),
  (VTBL_ENTRY)&_ZN10S17070C135D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C135D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN10S17070C1354v149Ev,
};
extern VTBL_ENTRY _ZTI10S17070C135[];
extern  VTBL_ENTRY _ZTV10S17070C135[];
Class_Descriptor cd_S17070C135 = {  "S17070C135", // class name
  bases_S17070C135, 2,
  &(vtc_S17070C135[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,176), // object size
  NSPAIRA(_ZTI10S17070C135),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17070C135),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C138  {
  ::S17070C136 s17070c138f0;
  void  mf17070c138(); // _ZN10S17070C13811mf17070c138Ev
};
//SIG(-1 S17070C138) C1{ m FC2{ m Fp[2]}}


void  S17070C138 ::mf17070c138(){}

static void Test_S17070C138()
{
  {
    init_simple_test("S17070C138");
    S17070C138 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C138)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C138)");
    check_field_offset(lv, s17070c138f0, 0, "S17070C138.s17070c138f0");
  }
}
static Arrange_To_Call_Me vS17070C138(Test_S17070C138, "S17070C138", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C134  : S17070C82 {
  ::S17070C135 s17070c134f0;
  ::S17070C138 s17070c134f1;
  virtual void  v143(); // _ZN10S17070C1344v143Ev
  virtual void  v144(); // _ZN10S17070C1344v144Ev
  virtual void  v145(); // _ZN10S17070C1344v145Ev
  virtual void  v146(); // _ZN10S17070C1344v146Ev
  virtual void  v147(); // _ZN10S17070C1344v147Ev
  virtual void  v148(); // _ZN10S17070C1344v148Ev
  ~S17070C134(); // tgen
  S17070C134(); // tgen
};
//SIG(-1 S17070C134) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC18{ m FC19{ m FL}} Fp} FC20{ BC17 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC20 FC20 FC20 FC20 FC20 FC20 FC20}} FC21{ m FC14}}


void  S17070C134 ::v143(){vfunc_called(this, "_ZN10S17070C1344v143Ev");}
void  S17070C134 ::v144(){vfunc_called(this, "_ZN10S17070C1344v144Ev");}
void  S17070C134 ::v145(){vfunc_called(this, "_ZN10S17070C1344v145Ev");}
void  S17070C134 ::v146(){vfunc_called(this, "_ZN10S17070C1344v146Ev");}
void  S17070C134 ::v147(){vfunc_called(this, "_ZN10S17070C1344v147Ev");}
void  S17070C134 ::v148(){vfunc_called(this, "_ZN10S17070C1344v148Ev");}
S17070C134 ::~S17070C134(){ note_dtor("S17070C134", this);} // tgen
S17070C134 ::S17070C134(){ note_ctor("S17070C134", this);} // tgen

static void Test_S17070C134()
{
  extern Class_Descriptor cd_S17070C134;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(54,65)];
    init_test(&cd_S17070C134, buf);
    S17070C134 *dp, &lv = *(dp=new (buf) S17070C134());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(424,256), "sizeof(S17070C134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C134)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C134");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C134");
    check_field_offset(lv, s17070c134f0, ABISELECT(104,72), "S17070C134.s17070c134f0");
    check_field_offset(lv, s17070c134f1, ABISELECT(408,248), "S17070C134.s17070c134f1");
    test_class_info(&lv, &cd_S17070C134);
    dp->~S17070C134();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C134(Test_S17070C134, "S17070C134", ABISELECT(424,256));

#else // __cplusplus

extern void _ZN10S17070C134C1Ev();
extern void _ZN10S17070C134D1Ev();
Name_Map name_map_S17070C134[] = {
  NSPAIR(_ZN10S17070C134C1Ev),
  NSPAIR(_ZN10S17070C134D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C134[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C134[];
extern void _ZN10S17070C134D1Ev();
extern void _ZN10S17070C134D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN10S17070C1344v143Ev();
extern void _ZN10S17070C1344v144Ev();
extern void _ZN10S17070C1344v145Ev();
extern void _ZN10S17070C1344v146Ev();
extern void _ZN10S17070C1344v147Ev();
extern void _ZN10S17070C1344v148Ev();
static  VTBL_ENTRY vtc_S17070C134[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C134[0]),
  (VTBL_ENTRY)&_ZN10S17070C134D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C134D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN10S17070C1344v143Ev,
  (VTBL_ENTRY)&_ZN10S17070C1344v144Ev,
  (VTBL_ENTRY)&_ZN10S17070C1344v145Ev,
  (VTBL_ENTRY)&_ZN10S17070C1344v146Ev,
  (VTBL_ENTRY)&_ZN10S17070C1344v147Ev,
  (VTBL_ENTRY)&_ZN10S17070C1344v148Ev,
};
extern VTBL_ENTRY _ZTI10S17070C134[];
extern  VTBL_ENTRY _ZTV10S17070C134[];
Class_Descriptor cd_S17070C134 = {  "S17070C134", // class name
  bases_S17070C134, 2,
  &(vtc_S17070C134[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(424,256), // object size
  NSPAIRA(_ZTI10S17070C134),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C134),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C133  {
  ::S17070C134 s17070c133f0;
  ::S17070C135 s17070c133f1;
  void  mf17070c133(); // _ZN10S17070C13311mf17070c133Ev
};
//SIG(-1 S17070C133) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC19{ m FC20{ m FL}} Fp} FC21{ BC18 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC21 FC21 FC21 FC21 FC21 FC21 FC21}} FC22{ m FC15}} FC10}


void  S17070C133 ::mf17070c133(){}

static void Test_S17070C133()
{
  {
    init_simple_test("S17070C133");
    S17070C133 lv;
    check2(sizeof(lv), ABISELECT(728,432), "sizeof(S17070C133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C133)");
    check_field_offset(lv, s17070c133f0, 0, "S17070C133.s17070c133f0");
    check_field_offset(lv, s17070c133f1, ABISELECT(424,256), "S17070C133.s17070c133f1");
  }
}
static Arrange_To_Call_Me vS17070C133(Test_S17070C133, "S17070C133", ABISELECT(728,432));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C142  {
  void *s17070c142f0[2];
  void  mf17070c142(); // _ZN10S17070C14211mf17070c142Ev
};
//SIG(-1 S17070C142) C1{ m Fp[2]}


void  S17070C142 ::mf17070c142(){}

static void Test_S17070C142()
{
  {
    init_simple_test("S17070C142");
    S17070C142 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C142)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C142)");
    check_field_offset(lv, s17070c142f0, 0, "S17070C142.s17070c142f0");
  }
}
static Arrange_To_Call_Me vS17070C142(Test_S17070C142, "S17070C142", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C142[];
VTBL_ENTRY *P__ZTI10S17070C142 = _ZTI10S17070C142; 
Class_Descriptor cd_S17070C142 = {  "S17070C142", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C142),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C143  {
  ::S17070C97 s17070c143f0;
  ::S17070C97 s17070c143f1;
  ::S17070C97 s17070c143f2;
  void  mf17070c143(); // _ZN10S17070C14311mf17070c143Ev
};
//SIG(-1 S17070C143) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC2 FC2}


void  S17070C143 ::mf17070c143(){}

static void Test_S17070C143()
{
  {
    init_simple_test("S17070C143");
    S17070C143 lv;
    check2(sizeof(lv), ABISELECT(72,36), "sizeof(S17070C143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C143)");
    check_field_offset(lv, s17070c143f0, 0, "S17070C143.s17070c143f0");
    check_field_offset(lv, s17070c143f1, ABISELECT(24,12), "S17070C143.s17070c143f1");
    check_field_offset(lv, s17070c143f2, ABISELECT(48,24), "S17070C143.s17070c143f2");
  }
}
static Arrange_To_Call_Me vS17070C143(Test_S17070C143, "S17070C143", ABISELECT(72,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C141  : S17070C88 , S17070C142 {
  ::S17070C143 s17070c141f0;
  virtual void  v156(); // _ZN10S17070C1414v156Ev
  ~S17070C141(); // tgen
  S17070C141(); // tgen
};
//SIG(-1 S17070C141) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC10 FC10}}


void  S17070C141 ::v156(){vfunc_called(this, "_ZN10S17070C1414v156Ev");}
S17070C141 ::~S17070C141(){ note_dtor("S17070C141", this);} // tgen
S17070C141 ::S17070C141(){ note_ctor("S17070C141", this);} // tgen

static void Test_S17070C141()
{
  extern Class_Descriptor cd_S17070C141;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,26)];
    init_test(&cd_S17070C141, buf);
    S17070C141 *dp, &lv = *(dp=new (buf) S17070C141());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,100), "sizeof(S17070C141)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C141)");
    check_base_class_offset(lv, (S17070C88*), 0, "S17070C141");
    check_base_class_offset(lv, (S17070C142*), ABISELECT(72,56), "S17070C141");
    check_field_offset(lv, s17070c141f0, ABISELECT(88,64), "S17070C141.s17070c141f0");
    test_class_info(&lv, &cd_S17070C141);
    dp->~S17070C141();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C141(Test_S17070C141, "S17070C141", ABISELECT(160,100));

#else // __cplusplus

extern void _ZN10S17070C141C1Ev();
extern void _ZN10S17070C141D1Ev();
Name_Map name_map_S17070C141[] = {
  NSPAIR(_ZN10S17070C141C1Ev),
  NSPAIR(_ZN10S17070C141D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C88;
extern VTBL_ENTRY _ZTI9S17070C88[];
extern  VTBL_ENTRY _ZTV9S17070C88[];
extern Class_Descriptor cd_S17070C142;
extern VTBL_ENTRY _ZTI10S17070C142[];
static Base_Class bases_S17070C141[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C88,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C142,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C141[];
extern void _ZN10S17070C141D1Ev();
extern void _ZN10S17070C141D0Ev();
extern void _ZN9S17070C883v65Ev();
extern void _ZN10S17070C1414v156Ev();
static  VTBL_ENTRY vtc_S17070C141[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C141[0]),
  (VTBL_ENTRY)&_ZN10S17070C141D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C141D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C883v65Ev,
  (VTBL_ENTRY)&_ZN10S17070C1414v156Ev,
};
extern VTBL_ENTRY _ZTI10S17070C141[];
extern  VTBL_ENTRY _ZTV10S17070C141[];
Class_Descriptor cd_S17070C141 = {  "S17070C141", // class name
  bases_S17070C141, 2,
  &(vtc_S17070C141[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,100), // object size
  NSPAIRA(_ZTI10S17070C141),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17070C141),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C140  : S17070C82 {
  ::S17070C141 s17070c140f0;
  ::S17070C138 s17070c140f1;
  virtual void  v150(); // _ZN10S17070C1404v150Ev
  virtual void  v151(); // _ZN10S17070C1404v151Ev
  virtual void  v152(); // _ZN10S17070C1404v152Ev
  virtual void  v153(); // _ZN10S17070C1404v153Ev
  virtual void  v154(); // _ZN10S17070C1404v154Ev
  virtual void  v155(); // _ZN10S17070C1404v155Ev
  ~S17070C140(); // tgen
  S17070C140(); // tgen
};
//SIG(-1 S17070C140) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC16 FC16}} FC18{ m FC19{ m Fp[2]}}}


void  S17070C140 ::v150(){vfunc_called(this, "_ZN10S17070C1404v150Ev");}
void  S17070C140 ::v151(){vfunc_called(this, "_ZN10S17070C1404v151Ev");}
void  S17070C140 ::v152(){vfunc_called(this, "_ZN10S17070C1404v152Ev");}
void  S17070C140 ::v153(){vfunc_called(this, "_ZN10S17070C1404v153Ev");}
void  S17070C140 ::v154(){vfunc_called(this, "_ZN10S17070C1404v154Ev");}
void  S17070C140 ::v155(){vfunc_called(this, "_ZN10S17070C1404v155Ev");}
S17070C140 ::~S17070C140(){ note_dtor("S17070C140", this);} // tgen
S17070C140 ::S17070C140(){ note_ctor("S17070C140", this);} // tgen

static void Test_S17070C140()
{
  extern Class_Descriptor cd_S17070C140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,46)];
    init_test(&cd_S17070C140, buf);
    S17070C140 *dp, &lv = *(dp=new (buf) S17070C140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,180), "sizeof(S17070C140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C140)");
    check_base_class_offset(lv, (S17070C73*)(S17070C82*), ABISELECT(8,4), "S17070C140");
    check_base_class_offset(lv, (S17070C82*), 0, "S17070C140");
    check_field_offset(lv, s17070c140f0, ABISELECT(104,72), "S17070C140.s17070c140f0");
    check_field_offset(lv, s17070c140f1, ABISELECT(264,172), "S17070C140.s17070c140f1");
    test_class_info(&lv, &cd_S17070C140);
    dp->~S17070C140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17070C140(Test_S17070C140, "S17070C140", ABISELECT(280,180));

#else // __cplusplus

extern void _ZN10S17070C140C1Ev();
extern void _ZN10S17070C140D1Ev();
Name_Map name_map_S17070C140[] = {
  NSPAIR(_ZN10S17070C140C1Ev),
  NSPAIR(_ZN10S17070C140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C73;
extern VTBL_ENTRY _ZTI9S17070C73[];
extern Class_Descriptor cd_S17070C82;
extern VTBL_ENTRY _ZTI9S17070C82[];
extern  VTBL_ENTRY _ZTV9S17070C82[];
static Base_Class bases_S17070C140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C73,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17070C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17070C140[];
extern void _ZN10S17070C140D1Ev();
extern void _ZN10S17070C140D0Ev();
extern void _ZN9S17070C823v58Ev();
extern void _ZN9S17070C823v59Ev();
extern void _ZN9S17070C823v60Ev();
extern void _ZN9S17070C823v61Ev();
extern void _ZN9S17070C823v62Ev();
extern void _ZN9S17070C823v63Ev();
extern void _ZN10S17070C1404v150Ev();
extern void _ZN10S17070C1404v151Ev();
extern void _ZN10S17070C1404v152Ev();
extern void _ZN10S17070C1404v153Ev();
extern void _ZN10S17070C1404v154Ev();
extern void _ZN10S17070C1404v155Ev();
static  VTBL_ENTRY vtc_S17070C140[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17070C140[0]),
  (VTBL_ENTRY)&_ZN10S17070C140D1Ev,
  (VTBL_ENTRY)&_ZN10S17070C140D0Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v58Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v59Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v60Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v61Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v62Ev,
  (VTBL_ENTRY)&_ZN9S17070C823v63Ev,
  (VTBL_ENTRY)&_ZN10S17070C1404v150Ev,
  (VTBL_ENTRY)&_ZN10S17070C1404v151Ev,
  (VTBL_ENTRY)&_ZN10S17070C1404v152Ev,
  (VTBL_ENTRY)&_ZN10S17070C1404v153Ev,
  (VTBL_ENTRY)&_ZN10S17070C1404v154Ev,
  (VTBL_ENTRY)&_ZN10S17070C1404v155Ev,
};
extern VTBL_ENTRY _ZTI10S17070C140[];
extern  VTBL_ENTRY _ZTV10S17070C140[];
Class_Descriptor cd_S17070C140 = {  "S17070C140", // class name
  bases_S17070C140, 2,
  &(vtc_S17070C140[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,180), // object size
  NSPAIRA(_ZTI10S17070C140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17070C140),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C139  {
  ::S17070C140 s17070c139f0;
  ::S17070C141 s17070c139f1;
  void  mf17070c139(); // _ZN10S17070C13911mf17070c139Ev
};
//SIG(-1 S17070C139) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC17 FC17}} FC19{ m FC20{ m Fp[2]}}} FC10}


void  S17070C139 ::mf17070c139(){}

static void Test_S17070C139()
{
  {
    init_simple_test("S17070C139");
    S17070C139 lv;
    check2(sizeof(lv), ABISELECT(440,280), "sizeof(S17070C139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C139)");
    check_field_offset(lv, s17070c139f0, 0, "S17070C139.s17070c139f0");
    check_field_offset(lv, s17070c139f1, ABISELECT(280,180), "S17070C139.s17070c139f1");
  }
}
static Arrange_To_Call_Me vS17070C139(Test_S17070C139, "S17070C139", ABISELECT(440,280));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C145  {
  void *s17070c145f0[2];
  void  mf17070c145(); // _ZN10S17070C14511mf17070c145Ev
};
//SIG(-1 S17070C145) C1{ m Fp[2]}


void  S17070C145 ::mf17070c145(){}

static void Test_S17070C145()
{
  {
    init_simple_test("S17070C145");
    S17070C145 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17070C145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C145)");
    check_field_offset(lv, s17070c145f0, 0, "S17070C145.s17070c145f0");
  }
}
static Arrange_To_Call_Me vS17070C145(Test_S17070C145, "S17070C145", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17070C145[];
VTBL_ENTRY *P__ZTI10S17070C145 = _ZTI10S17070C145; 
Class_Descriptor cd_S17070C145 = {  "S17070C145", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S17070C145),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C147  {
  ::S17070C4 s17070c147f0;
  int s17070c147f1[2];
  void  mf17070c147(); // _ZN10S17070C14711mf17070c147Ev
};
//SIG(-1 S17070C147) C1{ m FC2{ m Fp[2]} Fi[2]}


void  S17070C147 ::mf17070c147(){}

static void Test_S17070C147()
{
  {
    init_simple_test("S17070C147");
    S17070C147 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S17070C147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C147)");
    check_field_offset(lv, s17070c147f0, 0, "S17070C147.s17070c147f0");
    check_field_offset(lv, s17070c147f1, ABISELECT(16,8), "S17070C147.s17070c147f1");
  }
}
static Arrange_To_Call_Me vS17070C147(Test_S17070C147, "S17070C147", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17070C1  {
  int s17070c1f0[2];
  char s17070c1f1[6];
  int s17070c1f2;
  char s17070c1f3;
  int s17070c1f4;
  ::S17070C2_nt s17070c1f5;
  ::S17070C2_nt s17070c1f6;
  int s17070c1f7;
  char s17070c1f8;
  ::S17070C4 s17070c1f9;
  ::S17070C5 s17070c1f10;
  ::S17070C9 s17070c1f11;
  ::S17070C37 s17070c1f12;
  ::S17070C5 s17070c1f13;
  ::S17070C47 s17070c1f14;
  ::S17070C49 s17070c1f15;
  ::S17070C5 s17070c1f16;
  ::S17070C55 s17070c1f17;
  ::S17070C57 s17070c1f18;
  ::S17070C59 s17070c1f19;
  ::S17070C71 s17070c1f20;
  ::S17070C80 s17070c1f21;
  ::S17070C99 s17070c1f22;
  ::S17070C107 s17070c1f23;
  ::S17070C107 s17070c1f24;
  ::S17070C113 s17070c1f25;
  ::S17070C119 s17070c1f26;
  ::S17070C125 s17070c1f27;
  ::S17070C133 s17070c1f28;
  ::S17070C71 s17070c1f29;
  ::S17070C139 s17070c1f30;
  ::S17070C145 s17070c1f31;
  ::S17070C65 s17070c1f32;
  ::S17070C145 s17070c1f33;
  ::S17070C147 s17070c1f34;
  int s17070c1f35[2];
  ::S17070C21_nt s17070c1f36;
  ::S17070C21_nt s17070c1f37;
  char s17070c1f38;
  int s17070c1f39;
  char s17070c1f40;
  int s17070c1f41[2];
  void  mf17070c1(); // _ZN8S17070C19mf17070c1Ev
};
//SIG(1 S17070C1) C1{ m Fi[2] Fc[6] Fi Fc Fi FC2{ m Fp[2]} FC2 Fi Fc FC3{ m Fp[2]} FC4{ m FC5{ m Fi FC6{ m Fi[2]} FC3 FC3}[3] Fp} FC7{ m FC8{ BC9{ vd v7 v8 v9 v10 v11 v12 FC10{ m Fp[4]}} BC11{} v1 v2 v3 v4 v5 v6 FC12{ BC13{ m Fp Fi Fp Fi[2]} FC14{ m FC15{ m FC16{ m FL[2]}} FC15 FC15 FC15}} FC12 FC17{ BC13 FC18{ m FC3 FC19{ m Fp}}} FC20{ BC13 FC21{ m FC22{ m FL}}} FC23{ BC13 Fi}} FC24{ BC25{ BC26{ vd v13} vd v14 Fp[2] FC27{ m FC28{ m Fp Fi[2] FC29{ m}}} FC30{ m Fp[2]}} vd FC31{ m FC32{ Fs[2] Fc[2] Fs}[12] Fi FC33{ Fs[2]}[4] Fi FC30}}} FC34{ m FC35{ BC9 BC11 v15 v16 v17 v18 v19 v20 FC17} FC36{ BC37{ BC26 vd v21 Fp[2] FC27 FC38{ m Fp[2]}} vd FC39{ m Fp Fi FC40{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC30}}} FC4 FC41{ m FC42{ BC9 BC11 v22 v23 v24 v25 v26 v27 FC12} FC24} FC43{ m FC44{ BC9 BC11 v28 v29 v30 v31 v32 v33 FC17 FC23 FC20 FC45{ BC13 FC15} FC45 FC12 FC45} FC36} FC4 FC46{ m FC47{ BC9 BC11 v34 v35 v36 v37 v38 v39 FC12 FC17 FC17 FC20 FC45 FC12 FC12 FC12 FC45 FC45 FC12 FC20} FC36} FC48{ m FC38} FC49{ m FC50{ m Fi FC6 Fi FC51{ m FC52{ m Fp[2]} Fi} Fi[2] FC53{ m FC52 FC54{ m Fp[2]}} FC51} FC55{ m FC56{ BC9 BC11 v40 v41 v42 v43 v44 v45 FC12 FC12 FC23 FC45 FC45 FC45 FC45 FC45 FC23 FC23 FC45 FC45 FC20 FC17 FC45 FC12} FC24} FC57{ m FC58{ BC9 BC11 v46 v47 v48 v49 v50 v51} FC36} Fc FC3 FC54 Fc} FC59{ m FC48 FC60{ m Fp Fi FC29} FC61{ BC62{ m Fp Fi FC63{ m} FC63}} FC60 FC60 Fc[2] Fi} FC64{ m FC65{ BC66{ BC67{ m Fp[2]} vd v58 v59 v60 v61 v62 v63 FC61 FC60 FC60 FC60 FC60} v52 v53 v54 v55 v56 v57 FC68{ BC69{ vd v65 FC28 FC70{ m Fc FC71{ m Fi[3]} Fi[2]} FC60} BC72{ m Fp[2]} v64 FC73{ m FC74{ BC75{ vd v73 v74 v75 v76 v77 v78 v79} vd v66 v67 v68 v69 v70 v71 v72 FC15 Fp} FC76{ BC75 vd v80 v81 v82 v83 v84 v85 v86 Fi Fp} FC76 FC76 FC76 FC76 FC76 FC76 FC76 FC76}} FC77{ m FC72}} FC68} FC78{ m FC79{ BC66 v87 v88 v89 v90 v91 v92 FC80{ BC69 BC81{ m Fp[2]} v93 FC82{ m FC83{ BC75 vd v94 v95 v96 v97 v98 v99 v100 FC21 Fp} FC76 FC74 FC74 FC74 FC76}} FC77} FC80} FC84{ m FC85{ BC66 v101 v102 v103 v104 v105 v106 FC86{ BC69 BC87{ m Fp[2]} v107 FC88{ m FC74 FC74 FC74 FC76 FC76}} FC89{ m FC87}} FC86} FC84 FC90{ m FC91{ BC66 v108 v109 v110 v111 v112 v113 FC92{ BC69 BC93{ m Fp[2]} v114 FC94{ m FC83 FC76 FC74 FC76 FC76 FC74 FC74 FC76 FC76 FC76 FC76 FC76 FC76 FC76 FC76 FC76 FC76 FC76 FC76}} FC89} FC92} FC95{ m FC96{ BC66 v115 v116 v117 v118 v119 v120 FC97{ BC69 BC98{ m Fp[2]} v121 FC99{ m FC76 FC76 FC76 FC76 FC76 FC76 FC76}} FC100{ m FC98}} FC97} FC101{ m FC102{ BC66 v122 v123 v124 v125 v126 v127 FC103{ BC69 BC104{ m Fp[2]} v128 FC105{ m FC76 FC74 FC106{ BC75 vd v129 v130 v131 v132 v133 v134 v135 FC107{ m FC15} Fp} FC74 FC76 FC76 FC76 FC74 FC76 FC74 FC76 FC74 FC74 FC76 FC76}} FC100} FC103} FC108{ m FC109{ BC66 v136 v137 v138 v139 v140 v141 FC110{ BC69 BC111{ m Fp[2]} v142 FC112{ m FC83 FC76 FC76 FC76 FC76 FC76 FC76 FC76 FC76}} FC113{ m FC111}} FC110} FC59 FC114{ m FC115{ BC66 v143 v144 v145 v146 v147 v148 FC116{ BC69 BC117{ m Fp[2]} v149 FC118{ m FC76 FC76 FC76}} FC113} FC116} FC119{ m Fp[2]} FC54 FC119 FC120{ m FC3 Fi[2]} Fi[2] FC19 FC19 Fc Fi Fc Fi[2]}


void  S17070C1 ::mf17070c1(){}

static void Test_S17070C1()
{
  {
    init_simple_test("S17070C1");
    static S17070C1 lv;
    check2(sizeof(lv), ABISELECT(11640,7732), "sizeof(S17070C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17070C1)");
    check_field_offset(lv, s17070c1f0, 0, "S17070C1.s17070c1f0");
    check_field_offset(lv, s17070c1f1, 8, "S17070C1.s17070c1f1");
    check_field_offset(lv, s17070c1f2, 16, "S17070C1.s17070c1f2");
    check_field_offset(lv, s17070c1f3, 20, "S17070C1.s17070c1f3");
    check_field_offset(lv, s17070c1f4, 24, "S17070C1.s17070c1f4");
    check_field_offset(lv, s17070c1f5, ABISELECT(32,28), "S17070C1.s17070c1f5");
    check_field_offset(lv, s17070c1f6, ABISELECT(48,36), "S17070C1.s17070c1f6");
    check_field_offset(lv, s17070c1f7, ABISELECT(64,44), "S17070C1.s17070c1f7");
    check_field_offset(lv, s17070c1f8, ABISELECT(68,48), "S17070C1.s17070c1f8");
    check_field_offset(lv, s17070c1f9, ABISELECT(72,52), "S17070C1.s17070c1f9");
    check_field_offset(lv, s17070c1f10, ABISELECT(88,60), "S17070C1.s17070c1f10");
    check_field_offset(lv, s17070c1f11, ABISELECT(240,148), "S17070C1.s17070c1f11");
    check_field_offset(lv, s17070c1f12, ABISELECT(808,584), "S17070C1.s17070c1f12");
    check_field_offset(lv, s17070c1f13, ABISELECT(1008,696), "S17070C1.s17070c1f13");
    check_field_offset(lv, s17070c1f14, ABISELECT(1160,784), "S17070C1.s17070c1f14");
    check_field_offset(lv, s17070c1f15, ABISELECT(1496,1052), "S17070C1.s17070c1f15");
    check_field_offset(lv, s17070c1f16, ABISELECT(2016,1408), "S17070C1.s17070c1f16");
    check_field_offset(lv, s17070c1f17, ABISELECT(2168,1496), "S17070C1.s17070c1f17");
    check_field_offset(lv, s17070c1f18, ABISELECT(3128,2224), "S17070C1.s17070c1f18");
    check_field_offset(lv, s17070c1f19, ABISELECT(3144,2232), "S17070C1.s17070c1f19");
    check_field_offset(lv, s17070c1f20, ABISELECT(4568,3256), "S17070C1.s17070c1f20");
    check_field_offset(lv, s17070c1f21, ABISELECT(4656,3320), "S17070C1.s17070c1f21");
    check_field_offset(lv, s17070c1f22, ABISELECT(5448,3792), "S17070C1.s17070c1f22");
    check_field_offset(lv, s17070c1f23, ABISELECT(6080,4224), "S17070C1.s17070c1f23");
    check_field_offset(lv, s17070c1f24, ABISELECT(6664,4624), "S17070C1.s17070c1f24");
    check_field_offset(lv, s17070c1f25, ABISELECT(7248,5024), "S17070C1.s17070c1f25");
    check_field_offset(lv, s17070c1f26, ABISELECT(8504,5768), "S17070C1.s17070c1f26");
    check_field_offset(lv, s17070c1f27, ABISELECT(9136,6144), "S17070C1.s17070c1f27");
    check_field_offset(lv, s17070c1f28, ABISELECT(10264,6880), "S17070C1.s17070c1f28");
    check_field_offset(lv, s17070c1f29, ABISELECT(10992,7312), "S17070C1.s17070c1f29");
    check_field_offset(lv, s17070c1f30, ABISELECT(11080,7376), "S17070C1.s17070c1f30");
    check_field_offset(lv, s17070c1f31, ABISELECT(11520,7656), "S17070C1.s17070c1f31");
    check_field_offset(lv, s17070c1f32, ABISELECT(11536,7664), "S17070C1.s17070c1f32");
    check_field_offset(lv, s17070c1f33, ABISELECT(11552,7672), "S17070C1.s17070c1f33");
    check_field_offset(lv, s17070c1f34, ABISELECT(11568,7680), "S17070C1.s17070c1f34");
    check_field_offset(lv, s17070c1f35, ABISELECT(11592,7696), "S17070C1.s17070c1f35");
    check_field_offset(lv, s17070c1f36, ABISELECT(11600,7704), "S17070C1.s17070c1f36");
    check_field_offset(lv, s17070c1f37, ABISELECT(11608,7708), "S17070C1.s17070c1f37");
    check_field_offset(lv, s17070c1f38, ABISELECT(11616,7712), "S17070C1.s17070c1f38");
    check_field_offset(lv, s17070c1f39, ABISELECT(11620,7716), "S17070C1.s17070c1f39");
    check_field_offset(lv, s17070c1f40, ABISELECT(11624,7720), "S17070C1.s17070c1f40");
    check_field_offset(lv, s17070c1f41, ABISELECT(11628,7724), "S17070C1.s17070c1f41");
  }
}
static Arrange_To_Call_Me vS17070C1(Test_S17070C1, "S17070C1", ABISELECT(11640,7732));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C4  {
  ::S17070C12_nt s15653c4f0;
  virtual  ~S15653C4(); // _ZN8S15653C4D1Ev
  virtual void  v24(); // _ZN8S15653C43v24Ev
  virtual void  v25(); // _ZN8S15653C43v25Ev
  virtual void  v26(); // _ZN8S15653C43v26Ev
  virtual void  v27(); // _ZN8S15653C43v27Ev
  virtual void  v28(); // _ZN8S15653C43v28Ev
  virtual void  v29(); // _ZN8S15653C43v29Ev
  S15653C4(); // tgen
};
//SIG(-1 S15653C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15653C4 ::~S15653C4(){ note_dtor("S15653C4", this);}
void  S15653C4 ::v24(){vfunc_called(this, "_ZN8S15653C43v24Ev");}
void  S15653C4 ::v25(){vfunc_called(this, "_ZN8S15653C43v25Ev");}
void  S15653C4 ::v26(){vfunc_called(this, "_ZN8S15653C43v26Ev");}
void  S15653C4 ::v27(){vfunc_called(this, "_ZN8S15653C43v27Ev");}
void  S15653C4 ::v28(){vfunc_called(this, "_ZN8S15653C43v28Ev");}
void  S15653C4 ::v29(){vfunc_called(this, "_ZN8S15653C43v29Ev");}
S15653C4 ::S15653C4(){ note_ctor("S15653C4", this);} // tgen

static void Test_S15653C4()
{
  extern Class_Descriptor cd_S15653C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15653C4, buf);
    S15653C4 *dp, &lv = *(dp=new (buf) S15653C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15653C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C4)");
    check_field_offset(lv, s15653c4f0, ABISELECT(8,4), "S15653C4.s15653c4f0");
    test_class_info(&lv, &cd_S15653C4);
    dp->~S15653C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C4(Test_S15653C4, "S15653C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15653C4C1Ev();
extern void _ZN8S15653C4D1Ev();
Name_Map name_map_S15653C4[] = {
  NSPAIR(_ZN8S15653C4C1Ev),
  NSPAIR(_ZN8S15653C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15653C4[];
extern void _ZN8S15653C4D1Ev();
extern void _ZN8S15653C4D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
static  VTBL_ENTRY vtc_S15653C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15653C4[0]),
  (VTBL_ENTRY)&_ZN8S15653C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15653C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
};
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
Class_Descriptor cd_S15653C4 = {  "S15653C4", // class name
  0,0,//no base classes
  &(vtc_S15653C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15653C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15653C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C6  {
  virtual  ~S15653C6(); // _ZN8S15653C6D1Ev
  virtual void  v30(); // _ZN8S15653C63v30Ev
  virtual void  v31(); // _ZN8S15653C63v31Ev
  virtual void  v32(); // _ZN8S15653C63v32Ev
  virtual void  v33(); // _ZN8S15653C63v33Ev
  virtual void  v34(); // _ZN8S15653C63v34Ev
  virtual void  v35(); // _ZN8S15653C63v35Ev
  virtual void  v36(); // _ZN8S15653C63v36Ev
  virtual void  v37(); // _ZN8S15653C63v37Ev
  virtual void  v38(); // _ZN8S15653C63v38Ev
  virtual void  v39(); // _ZN8S15653C63v39Ev
  virtual void  v40(); // _ZN8S15653C63v40Ev
  virtual void  v41(); // _ZN8S15653C63v41Ev
  virtual void  v42(); // _ZN8S15653C63v42Ev
  virtual void  v43(); // _ZN8S15653C63v43Ev
  virtual void  v44(); // _ZN8S15653C63v44Ev
  virtual void  v45(); // _ZN8S15653C63v45Ev
  virtual void  v46(); // _ZN8S15653C63v46Ev
  S15653C6(); // tgen
};
//SIG(-1 S15653C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17}


 S15653C6 ::~S15653C6(){ note_dtor("S15653C6", this);}
void  S15653C6 ::v30(){vfunc_called(this, "_ZN8S15653C63v30Ev");}
void  S15653C6 ::v31(){vfunc_called(this, "_ZN8S15653C63v31Ev");}
void  S15653C6 ::v32(){vfunc_called(this, "_ZN8S15653C63v32Ev");}
void  S15653C6 ::v33(){vfunc_called(this, "_ZN8S15653C63v33Ev");}
void  S15653C6 ::v34(){vfunc_called(this, "_ZN8S15653C63v34Ev");}
void  S15653C6 ::v35(){vfunc_called(this, "_ZN8S15653C63v35Ev");}
void  S15653C6 ::v36(){vfunc_called(this, "_ZN8S15653C63v36Ev");}
void  S15653C6 ::v37(){vfunc_called(this, "_ZN8S15653C63v37Ev");}
void  S15653C6 ::v38(){vfunc_called(this, "_ZN8S15653C63v38Ev");}
void  S15653C6 ::v39(){vfunc_called(this, "_ZN8S15653C63v39Ev");}
void  S15653C6 ::v40(){vfunc_called(this, "_ZN8S15653C63v40Ev");}
void  S15653C6 ::v41(){vfunc_called(this, "_ZN8S15653C63v41Ev");}
void  S15653C6 ::v42(){vfunc_called(this, "_ZN8S15653C63v42Ev");}
void  S15653C6 ::v43(){vfunc_called(this, "_ZN8S15653C63v43Ev");}
void  S15653C6 ::v44(){vfunc_called(this, "_ZN8S15653C63v44Ev");}
void  S15653C6 ::v45(){vfunc_called(this, "_ZN8S15653C63v45Ev");}
void  S15653C6 ::v46(){vfunc_called(this, "_ZN8S15653C63v46Ev");}
S15653C6 ::S15653C6(){ note_ctor("S15653C6", this);} // tgen

static void Test_S15653C6()
{
  extern Class_Descriptor cd_S15653C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S15653C6, buf);
    S15653C6 *dp, &lv = *(dp=new (buf) S15653C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S15653C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C6)");
    test_class_info(&lv, &cd_S15653C6);
    dp->~S15653C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C6(Test_S15653C6, "S15653C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S15653C6C1Ev();
extern void _ZN8S15653C6D1Ev();
Name_Map name_map_S15653C6[] = {
  NSPAIR(_ZN8S15653C6C1Ev),
  NSPAIR(_ZN8S15653C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15653C6[];
extern void _ZN8S15653C6D1Ev();
extern void _ZN8S15653C6D0Ev();
extern void _ZN8S15653C63v30Ev();
extern void _ZN8S15653C63v31Ev();
extern void _ZN8S15653C63v32Ev();
extern void _ZN8S15653C63v33Ev();
extern void _ZN8S15653C63v34Ev();
extern void _ZN8S15653C63v35Ev();
extern void _ZN8S15653C63v36Ev();
extern void _ZN8S15653C63v37Ev();
extern void _ZN8S15653C63v38Ev();
extern void _ZN8S15653C63v39Ev();
extern void _ZN8S15653C63v40Ev();
extern void _ZN8S15653C63v41Ev();
extern void _ZN8S15653C63v42Ev();
extern void _ZN8S15653C63v43Ev();
extern void _ZN8S15653C63v44Ev();
extern void _ZN8S15653C63v45Ev();
extern void _ZN8S15653C63v46Ev();
static  VTBL_ENTRY vtc_S15653C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15653C6[0]),
  (VTBL_ENTRY)&_ZN8S15653C6D1Ev,
  (VTBL_ENTRY)&_ZN8S15653C6D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v30Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v31Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v32Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v33Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v34Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v35Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v36Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v37Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v38Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v39Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v40Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v41Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v42Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v43Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v44Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v45Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v46Ev,
};
extern VTBL_ENTRY _ZTI8S15653C6[];
extern  VTBL_ENTRY _ZTV8S15653C6[];
Class_Descriptor cd_S15653C6 = {  "S15653C6", // class name
  0,0,//no base classes
  &(vtc_S15653C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S15653C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15653C6),21, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C3  : S15653C4 , S15653C6 {
  ::S17070C14_nt s15653c3f0;
  ::S17070C22_nt s15653c3f1;
  ::S17070C51_nt s15653c3f2;
  ::S17070C51_nt s15653c3f3;
  ::S17070C51_nt s15653c3f4;
  ::S17070C51_nt s15653c3f5;
  ::S17070C25_nt s15653c3f6;
  ::S17070C51_nt s15653c3f7;
  ::S17070C51_nt s15653c3f8;
  ::S17070C51_nt s15653c3f9;
  ::S17070C19_nt s15653c3f10;
  ::S17070C22_nt s15653c3f11;
  virtual void  v1(); // _ZN8S15653C32v1Ev
  virtual void  v2(); // _ZN8S15653C32v2Ev
  virtual void  v3(); // _ZN8S15653C32v3Ev
  virtual void  v4(); // _ZN8S15653C32v4Ev
  virtual void  v5(); // _ZN8S15653C32v5Ev
  virtual void  v6(); // _ZN8S15653C32v6Ev
  virtual void  v7(); // _ZN8S15653C32v7Ev
  virtual void  v8(); // _ZN8S15653C32v8Ev
  virtual void  v9(); // _ZN8S15653C32v9Ev
  virtual void  v10(); // _ZN8S15653C33v10Ev
  virtual void  v11(); // _ZN8S15653C33v11Ev
  virtual void  v12(); // _ZN8S15653C33v12Ev
  virtual void  v13(); // _ZN8S15653C33v13Ev
  virtual void  v14(); // _ZN8S15653C33v14Ev
  virtual void  v15(); // _ZN8S15653C33v15Ev
  virtual void  v16(); // _ZN8S15653C33v16Ev
  virtual void  v17(); // _ZN8S15653C33v17Ev
  virtual void  v18(); // _ZN8S15653C33v18Ev
  virtual void  v19(); // _ZN8S15653C33v19Ev
  virtual void  v20(); // _ZN8S15653C33v20Ev
  virtual void  v21(); // _ZN8S15653C33v21Ev
  virtual void  v22(); // _ZN8S15653C33v22Ev
  virtual void  v23(); // _ZN8S15653C33v23Ev
  ~S15653C3(); // tgen
  S15653C3(); // tgen
};
//SIG(-1 S15653C3) C1{ BC2{ vd v24 v25 v26 v27 v28 v29 FC3{ m Fp[4]}} BC4{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC13{ BC6 FC8} FC13 FC13 FC13 FC14{ BC6 Fi} FC13 FC13 FC13 FC15{ BC6 FC16{ m FC17{ m Fp[2]} FC18{ m Fp}}} FC10}


void  S15653C3 ::v1(){vfunc_called(this, "_ZN8S15653C32v1Ev");}
void  S15653C3 ::v2(){vfunc_called(this, "_ZN8S15653C32v2Ev");}
void  S15653C3 ::v3(){vfunc_called(this, "_ZN8S15653C32v3Ev");}
void  S15653C3 ::v4(){vfunc_called(this, "_ZN8S15653C32v4Ev");}
void  S15653C3 ::v5(){vfunc_called(this, "_ZN8S15653C32v5Ev");}
void  S15653C3 ::v6(){vfunc_called(this, "_ZN8S15653C32v6Ev");}
void  S15653C3 ::v7(){vfunc_called(this, "_ZN8S15653C32v7Ev");}
void  S15653C3 ::v8(){vfunc_called(this, "_ZN8S15653C32v8Ev");}
void  S15653C3 ::v9(){vfunc_called(this, "_ZN8S15653C32v9Ev");}
void  S15653C3 ::v10(){vfunc_called(this, "_ZN8S15653C33v10Ev");}
void  S15653C3 ::v11(){vfunc_called(this, "_ZN8S15653C33v11Ev");}
void  S15653C3 ::v12(){vfunc_called(this, "_ZN8S15653C33v12Ev");}
void  S15653C3 ::v13(){vfunc_called(this, "_ZN8S15653C33v13Ev");}
void  S15653C3 ::v14(){vfunc_called(this, "_ZN8S15653C33v14Ev");}
void  S15653C3 ::v15(){vfunc_called(this, "_ZN8S15653C33v15Ev");}
void  S15653C3 ::v16(){vfunc_called(this, "_ZN8S15653C33v16Ev");}
void  S15653C3 ::v17(){vfunc_called(this, "_ZN8S15653C33v17Ev");}
void  S15653C3 ::v18(){vfunc_called(this, "_ZN8S15653C33v18Ev");}
void  S15653C3 ::v19(){vfunc_called(this, "_ZN8S15653C33v19Ev");}
void  S15653C3 ::v20(){vfunc_called(this, "_ZN8S15653C33v20Ev");}
void  S15653C3 ::v21(){vfunc_called(this, "_ZN8S15653C33v21Ev");}
void  S15653C3 ::v22(){vfunc_called(this, "_ZN8S15653C33v22Ev");}
void  S15653C3 ::v23(){vfunc_called(this, "_ZN8S15653C33v23Ev");}
S15653C3 ::~S15653C3(){ note_dtor("S15653C3", this);} // tgen
S15653C3 ::S15653C3(){ note_ctor("S15653C3", this);} // tgen

static void Test_S15653C3()
{
  extern Class_Descriptor cd_S15653C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(83,119)];
    init_test(&cd_S15653C3, buf);
    S15653C3 *dp, &lv = *(dp=new (buf) S15653C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(656,472), "sizeof(S15653C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C3)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C3");
    check_base_class_offset(lv, (S15653C6*), ABISELECT(40,20), "S15653C3");
    check_field_offset(lv, s15653c3f0, ABISELECT(48,24), "S15653C3.s15653c3f0");
    check_field_offset(lv, s15653c3f1, ABISELECT(144,108), "S15653C3.s15653c3f1");
    check_field_offset(lv, s15653c3f2, ABISELECT(184,136), "S15653C3.s15653c3f2");
    check_field_offset(lv, s15653c3f3, ABISELECT(232,172), "S15653C3.s15653c3f3");
    check_field_offset(lv, s15653c3f4, ABISELECT(280,208), "S15653C3.s15653c3f4");
    check_field_offset(lv, s15653c3f5, ABISELECT(328,244), "S15653C3.s15653c3f5");
    check_field_offset(lv, s15653c3f6, ABISELECT(376,280), "S15653C3.s15653c3f6");
    check_field_offset(lv, s15653c3f7, ABISELECT(416,304), "S15653C3.s15653c3f7");
    check_field_offset(lv, s15653c3f8, ABISELECT(464,340), "S15653C3.s15653c3f8");
    check_field_offset(lv, s15653c3f9, ABISELECT(512,376), "S15653C3.s15653c3f9");
    check_field_offset(lv, s15653c3f10, ABISELECT(560,412), "S15653C3.s15653c3f10");
    check_field_offset(lv, s15653c3f11, ABISELECT(616,444), "S15653C3.s15653c3f11");
    test_class_info(&lv, &cd_S15653C3);
    dp->~S15653C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C3(Test_S15653C3, "S15653C3", ABISELECT(656,472));

#else // __cplusplus

extern void _ZN8S15653C3C1Ev();
extern void _ZN8S15653C3D1Ev();
Name_Map name_map_S15653C3[] = {
  NSPAIR(_ZN8S15653C3C1Ev),
  NSPAIR(_ZN8S15653C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C6;
extern VTBL_ENTRY _ZTI8S15653C6[];
extern  VTBL_ENTRY _ZTV8S15653C6[];
static Base_Class bases_S15653C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C6,    ABISELECT(40,20), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S15653C3[];
extern void _ZN8S15653C3D1Ev();
extern void _ZN8S15653C3D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN8S15653C32v1Ev();
extern void _ZN8S15653C32v2Ev();
extern void _ZN8S15653C32v3Ev();
extern void _ZN8S15653C32v4Ev();
extern void _ZN8S15653C32v5Ev();
extern void _ZN8S15653C32v6Ev();
extern void _ZN8S15653C32v7Ev();
extern void _ZN8S15653C32v8Ev();
extern void _ZN8S15653C32v9Ev();
extern void _ZN8S15653C33v10Ev();
extern void _ZN8S15653C33v11Ev();
extern void _ZN8S15653C33v12Ev();
extern void _ZN8S15653C33v13Ev();
extern void _ZN8S15653C33v14Ev();
extern void _ZN8S15653C33v15Ev();
extern void _ZN8S15653C33v16Ev();
extern void _ZN8S15653C33v17Ev();
extern void _ZN8S15653C33v18Ev();
extern void _ZN8S15653C33v19Ev();
extern void _ZN8S15653C33v20Ev();
extern void _ZN8S15653C33v21Ev();
extern void _ZN8S15653C33v22Ev();
extern void _ZN8S15653C33v23Ev();
extern void ABISELECT(_ZThn40_N8S15653C3D1Ev,_ZThn20_N8S15653C3D1Ev)();
extern void ABISELECT(_ZThn40_N8S15653C3D0Ev,_ZThn20_N8S15653C3D0Ev)();
extern void _ZN8S15653C63v30Ev();
extern void _ZN8S15653C63v31Ev();
extern void _ZN8S15653C63v32Ev();
extern void _ZN8S15653C63v33Ev();
extern void _ZN8S15653C63v34Ev();
extern void _ZN8S15653C63v35Ev();
extern void _ZN8S15653C63v36Ev();
extern void _ZN8S15653C63v37Ev();
extern void _ZN8S15653C63v38Ev();
extern void _ZN8S15653C63v39Ev();
extern void _ZN8S15653C63v40Ev();
extern void _ZN8S15653C63v41Ev();
extern void _ZN8S15653C63v42Ev();
extern void _ZN8S15653C63v43Ev();
extern void _ZN8S15653C63v44Ev();
extern void _ZN8S15653C63v45Ev();
extern void _ZN8S15653C63v46Ev();
static  VTBL_ENTRY vtc_S15653C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15653C3[0]),
  (VTBL_ENTRY)&_ZN8S15653C3D1Ev,
  (VTBL_ENTRY)&_ZN8S15653C3D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v1Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v2Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v3Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v4Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v5Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v6Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v7Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v8Ev,
  (VTBL_ENTRY)&_ZN8S15653C32v9Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v10Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v11Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v12Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v13Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v14Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v15Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v16Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v17Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v18Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v19Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v20Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v21Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v22Ev,
  (VTBL_ENTRY)&_ZN8S15653C33v23Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S15653C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S15653C3D1Ev,_ZThn20_N8S15653C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S15653C3D0Ev,_ZThn20_N8S15653C3D0Ev),
  (VTBL_ENTRY)&_ZN8S15653C63v30Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v31Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v32Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v33Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v34Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v35Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v36Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v37Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v38Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v39Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v40Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v41Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v42Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v43Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v44Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v45Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v46Ev,
};
extern VTBL_ENTRY _ZTI8S15653C3[];
extern  VTBL_ENTRY _ZTV8S15653C3[];
Class_Descriptor cd_S15653C3 = {  "S15653C3", // class name
  bases_S15653C3, 2,
  &(vtc_S15653C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(656,472), // object size
  NSPAIRA(_ZTI8S15653C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S15653C3),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C2  {
  ::S15653C3 s15653c2f0;
  ::S17070C26_nt s15653c2f1;
  void  mf15653c2(); // _ZN8S15653C29mf15653c2Ev
};
//SIG(-1 S15653C2) C1{ m FC2{ BC3{ vd v24 v25 v26 v27 v28 v29 FC4{ m Fp[4]}} BC5{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC14{ BC7 FC9} FC14 FC14 FC14 FC15{ BC7 Fi} FC14 FC14 FC14 FC16{ BC7 FC17{ m FC18{ m Fp[2]} FC19{ m Fp}}} FC11} FC20{ BC21{ BC22{ vd v47} vd v48 Fp[2] FC23{ m FC24{ m Fp Fi[2] FC25{ m}}} FC26{ m Fp[2]}} vd FC27{ m FC28{ Fs[2] Fc[2] Fs}[12] Fi FC29{ Fs[2]}[4] Fi FC26}}}


void  S15653C2 ::mf15653c2(){}

static void Test_S15653C2()
{
  {
    init_simple_test("S15653C2");
    S15653C2 lv;
    check2(sizeof(lv), ABISELECT(856,636), "sizeof(S15653C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C2)");
    check_field_offset(lv, s15653c2f0, 0, "S15653C2.s15653c2f0");
    check_field_offset(lv, s15653c2f1, ABISELECT(656,472), "S15653C2.s15653c2f1");
  }
}
static Arrange_To_Call_Me vS15653C2(Test_S15653C2, "S15653C2", ABISELECT(856,636));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C34  {
  virtual  ~S15653C34(); // _ZN9S15653C34D1Ev
  virtual void  v75(); // _ZN9S15653C343v75Ev
  virtual void  v76(); // _ZN9S15653C343v76Ev
  virtual void  v77(); // _ZN9S15653C343v77Ev
  virtual void  v78(); // _ZN9S15653C343v78Ev
  virtual void  v79(); // _ZN9S15653C343v79Ev
  virtual void  v80(); // _ZN9S15653C343v80Ev
  virtual void  v81(); // _ZN9S15653C343v81Ev
  virtual void  v82(); // _ZN9S15653C343v82Ev
  virtual void  v83(); // _ZN9S15653C343v83Ev
  virtual void  v84(); // _ZN9S15653C343v84Ev
  virtual void  v85(); // _ZN9S15653C343v85Ev
  virtual void  v86(); // _ZN9S15653C343v86Ev
  virtual void  v87(); // _ZN9S15653C343v87Ev
  virtual void  v88(); // _ZN9S15653C343v88Ev
  virtual void  v89(); // _ZN9S15653C343v89Ev
  virtual void  v90(); // _ZN9S15653C343v90Ev
  virtual void  v91(); // _ZN9S15653C343v91Ev
  virtual void  v92(); // _ZN9S15653C343v92Ev
  virtual void  v93(); // _ZN9S15653C343v93Ev
  virtual void  v94(); // _ZN9S15653C343v94Ev
  S15653C34(); // tgen
};
//SIG(-1 S15653C34) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20}


 S15653C34 ::~S15653C34(){ note_dtor("S15653C34", this);}
void  S15653C34 ::v75(){vfunc_called(this, "_ZN9S15653C343v75Ev");}
void  S15653C34 ::v76(){vfunc_called(this, "_ZN9S15653C343v76Ev");}
void  S15653C34 ::v77(){vfunc_called(this, "_ZN9S15653C343v77Ev");}
void  S15653C34 ::v78(){vfunc_called(this, "_ZN9S15653C343v78Ev");}
void  S15653C34 ::v79(){vfunc_called(this, "_ZN9S15653C343v79Ev");}
void  S15653C34 ::v80(){vfunc_called(this, "_ZN9S15653C343v80Ev");}
void  S15653C34 ::v81(){vfunc_called(this, "_ZN9S15653C343v81Ev");}
void  S15653C34 ::v82(){vfunc_called(this, "_ZN9S15653C343v82Ev");}
void  S15653C34 ::v83(){vfunc_called(this, "_ZN9S15653C343v83Ev");}
void  S15653C34 ::v84(){vfunc_called(this, "_ZN9S15653C343v84Ev");}
void  S15653C34 ::v85(){vfunc_called(this, "_ZN9S15653C343v85Ev");}
void  S15653C34 ::v86(){vfunc_called(this, "_ZN9S15653C343v86Ev");}
void  S15653C34 ::v87(){vfunc_called(this, "_ZN9S15653C343v87Ev");}
void  S15653C34 ::v88(){vfunc_called(this, "_ZN9S15653C343v88Ev");}
void  S15653C34 ::v89(){vfunc_called(this, "_ZN9S15653C343v89Ev");}
void  S15653C34 ::v90(){vfunc_called(this, "_ZN9S15653C343v90Ev");}
void  S15653C34 ::v91(){vfunc_called(this, "_ZN9S15653C343v91Ev");}
void  S15653C34 ::v92(){vfunc_called(this, "_ZN9S15653C343v92Ev");}
void  S15653C34 ::v93(){vfunc_called(this, "_ZN9S15653C343v93Ev");}
void  S15653C34 ::v94(){vfunc_called(this, "_ZN9S15653C343v94Ev");}
S15653C34 ::S15653C34(){ note_ctor("S15653C34", this);} // tgen

static void Test_S15653C34()
{
  extern Class_Descriptor cd_S15653C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S15653C34, buf);
    S15653C34 *dp, &lv = *(dp=new (buf) S15653C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S15653C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C34)");
    test_class_info(&lv, &cd_S15653C34);
    dp->~S15653C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C34(Test_S15653C34, "S15653C34", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S15653C34C1Ev();
extern void _ZN9S15653C34D1Ev();
Name_Map name_map_S15653C34[] = {
  NSPAIR(_ZN9S15653C34C1Ev),
  NSPAIR(_ZN9S15653C34D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S15653C34[];
extern void _ZN9S15653C34D1Ev();
extern void _ZN9S15653C34D0Ev();
extern void _ZN9S15653C343v75Ev();
extern void _ZN9S15653C343v76Ev();
extern void _ZN9S15653C343v77Ev();
extern void _ZN9S15653C343v78Ev();
extern void _ZN9S15653C343v79Ev();
extern void _ZN9S15653C343v80Ev();
extern void _ZN9S15653C343v81Ev();
extern void _ZN9S15653C343v82Ev();
extern void _ZN9S15653C343v83Ev();
extern void _ZN9S15653C343v84Ev();
extern void _ZN9S15653C343v85Ev();
extern void _ZN9S15653C343v86Ev();
extern void _ZN9S15653C343v87Ev();
extern void _ZN9S15653C343v88Ev();
extern void _ZN9S15653C343v89Ev();
extern void _ZN9S15653C343v90Ev();
extern void _ZN9S15653C343v91Ev();
extern void _ZN9S15653C343v92Ev();
extern void _ZN9S15653C343v93Ev();
extern void _ZN9S15653C343v94Ev();
static  VTBL_ENTRY vtc_S15653C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C34[0]),
  (VTBL_ENTRY)&_ZN9S15653C34D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C34D0Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v75Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v76Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v77Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v78Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v79Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v80Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v81Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v82Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v83Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v84Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v85Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v86Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v87Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v88Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v89Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v90Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v91Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v92Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v93Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v94Ev,
};
extern VTBL_ENTRY _ZTI9S15653C34[];
extern  VTBL_ENTRY _ZTV9S15653C34[];
Class_Descriptor cd_S15653C34 = {  "S15653C34", // class name
  0,0,//no base classes
  &(vtc_S15653C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S15653C34),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S15653C34),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C33  : S15653C4 , S15653C34 {
  ::S17070C19_nt s15653c33f0;
  ::S17070C51_nt s15653c33f1;
  ::S17070C19_nt s15653c33f2;
  ::S17070C22_nt s15653c33f3;
  virtual void  v49(); // _ZN9S15653C333v49Ev
  virtual void  v50(); // _ZN9S15653C333v50Ev
  virtual void  v51(); // _ZN9S15653C333v51Ev
  virtual void  v52(); // _ZN9S15653C333v52Ev
  virtual void  v53(); // _ZN9S15653C333v53Ev
  virtual void  v54(); // _ZN9S15653C333v54Ev
  virtual void  v55(); // _ZN9S15653C333v55Ev
  virtual void  v56(); // _ZN9S15653C333v56Ev
  virtual void  v57(); // _ZN9S15653C333v57Ev
  virtual void  v58(); // _ZN9S15653C333v58Ev
  virtual void  v59(); // _ZN9S15653C333v59Ev
  virtual void  v60(); // _ZN9S15653C333v60Ev
  virtual void  v61(); // _ZN9S15653C333v61Ev
  virtual void  v62(); // _ZN9S15653C333v62Ev
  virtual void  v63(); // _ZN9S15653C333v63Ev
  virtual void  v64(); // _ZN9S15653C333v64Ev
  virtual void  v65(); // _ZN9S15653C333v65Ev
  virtual void  v66(); // _ZN9S15653C333v66Ev
  virtual void  v67(); // _ZN9S15653C333v67Ev
  virtual void  v68(); // _ZN9S15653C333v68Ev
  virtual void  v69(); // _ZN9S15653C333v69Ev
  virtual void  v70(); // _ZN9S15653C333v70Ev
  virtual void  v71(); // _ZN9S15653C333v71Ev
  virtual void  v72(); // _ZN9S15653C333v72Ev
  virtual void  v73(); // _ZN9S15653C333v73Ev
  virtual void  v74(); // _ZN9S15653C333v74Ev
  ~S15653C33(); // tgen
  S15653C33(); // tgen
};
//SIG(-1 S15653C33) C1{ BC2{ vd v27 v28 v29 v30 v31 v32 FC3{ m Fp[4]}} BC4{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL[2]}}} FC5 FC13{ BC6 FC14{ m FC15{ m FL}}}}


void  S15653C33 ::v49(){vfunc_called(this, "_ZN9S15653C333v49Ev");}
void  S15653C33 ::v50(){vfunc_called(this, "_ZN9S15653C333v50Ev");}
void  S15653C33 ::v51(){vfunc_called(this, "_ZN9S15653C333v51Ev");}
void  S15653C33 ::v52(){vfunc_called(this, "_ZN9S15653C333v52Ev");}
void  S15653C33 ::v53(){vfunc_called(this, "_ZN9S15653C333v53Ev");}
void  S15653C33 ::v54(){vfunc_called(this, "_ZN9S15653C333v54Ev");}
void  S15653C33 ::v55(){vfunc_called(this, "_ZN9S15653C333v55Ev");}
void  S15653C33 ::v56(){vfunc_called(this, "_ZN9S15653C333v56Ev");}
void  S15653C33 ::v57(){vfunc_called(this, "_ZN9S15653C333v57Ev");}
void  S15653C33 ::v58(){vfunc_called(this, "_ZN9S15653C333v58Ev");}
void  S15653C33 ::v59(){vfunc_called(this, "_ZN9S15653C333v59Ev");}
void  S15653C33 ::v60(){vfunc_called(this, "_ZN9S15653C333v60Ev");}
void  S15653C33 ::v61(){vfunc_called(this, "_ZN9S15653C333v61Ev");}
void  S15653C33 ::v62(){vfunc_called(this, "_ZN9S15653C333v62Ev");}
void  S15653C33 ::v63(){vfunc_called(this, "_ZN9S15653C333v63Ev");}
void  S15653C33 ::v64(){vfunc_called(this, "_ZN9S15653C333v64Ev");}
void  S15653C33 ::v65(){vfunc_called(this, "_ZN9S15653C333v65Ev");}
void  S15653C33 ::v66(){vfunc_called(this, "_ZN9S15653C333v66Ev");}
void  S15653C33 ::v67(){vfunc_called(this, "_ZN9S15653C333v67Ev");}
void  S15653C33 ::v68(){vfunc_called(this, "_ZN9S15653C333v68Ev");}
void  S15653C33 ::v69(){vfunc_called(this, "_ZN9S15653C333v69Ev");}
void  S15653C33 ::v70(){vfunc_called(this, "_ZN9S15653C333v70Ev");}
void  S15653C33 ::v71(){vfunc_called(this, "_ZN9S15653C333v71Ev");}
void  S15653C33 ::v72(){vfunc_called(this, "_ZN9S15653C333v72Ev");}
void  S15653C33 ::v73(){vfunc_called(this, "_ZN9S15653C333v73Ev");}
void  S15653C33 ::v74(){vfunc_called(this, "_ZN9S15653C333v74Ev");}
S15653C33 ::~S15653C33(){ note_dtor("S15653C33", this);} // tgen
S15653C33 ::S15653C33(){ note_ctor("S15653C33", this);} // tgen

static void Test_S15653C33()
{
  extern Class_Descriptor cd_S15653C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,39)];
    init_test(&cd_S15653C33, buf);
    S15653C33 *dp, &lv = *(dp=new (buf) S15653C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,152), "sizeof(S15653C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C33)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C33");
    check_base_class_offset(lv, (S15653C34*), ABISELECT(40,20), "S15653C33");
    check_field_offset(lv, s15653c33f0, ABISELECT(48,24), "S15653C33.s15653c33f0");
    check_field_offset(lv, s15653c33f1, ABISELECT(104,56), "S15653C33.s15653c33f1");
    check_field_offset(lv, s15653c33f2, ABISELECT(152,92), "S15653C33.s15653c33f2");
    check_field_offset(lv, s15653c33f3, ABISELECT(208,124), "S15653C33.s15653c33f3");
    test_class_info(&lv, &cd_S15653C33);
    dp->~S15653C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C33(Test_S15653C33, "S15653C33", ABISELECT(248,152));

#else // __cplusplus

extern void _ZN9S15653C33C1Ev();
extern void _ZN9S15653C33D1Ev();
Name_Map name_map_S15653C33[] = {
  NSPAIR(_ZN9S15653C33C1Ev),
  NSPAIR(_ZN9S15653C33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C34;
extern VTBL_ENTRY _ZTI9S15653C34[];
extern  VTBL_ENTRY _ZTV9S15653C34[];
static Base_Class bases_S15653C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C34,    ABISELECT(40,20), //bcp->offset
    36, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C33[];
extern void _ZN9S15653C33D1Ev();
extern void _ZN9S15653C33D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C333v49Ev();
extern void _ZN9S15653C333v50Ev();
extern void _ZN9S15653C333v51Ev();
extern void _ZN9S15653C333v52Ev();
extern void _ZN9S15653C333v53Ev();
extern void _ZN9S15653C333v54Ev();
extern void _ZN9S15653C333v55Ev();
extern void _ZN9S15653C333v56Ev();
extern void _ZN9S15653C333v57Ev();
extern void _ZN9S15653C333v58Ev();
extern void _ZN9S15653C333v59Ev();
extern void _ZN9S15653C333v60Ev();
extern void _ZN9S15653C333v61Ev();
extern void _ZN9S15653C333v62Ev();
extern void _ZN9S15653C333v63Ev();
extern void _ZN9S15653C333v64Ev();
extern void _ZN9S15653C333v65Ev();
extern void _ZN9S15653C333v66Ev();
extern void _ZN9S15653C333v67Ev();
extern void _ZN9S15653C333v68Ev();
extern void _ZN9S15653C333v69Ev();
extern void _ZN9S15653C333v70Ev();
extern void _ZN9S15653C333v71Ev();
extern void _ZN9S15653C333v72Ev();
extern void _ZN9S15653C333v73Ev();
extern void _ZN9S15653C333v74Ev();
extern void ABISELECT(_ZThn40_N9S15653C33D1Ev,_ZThn20_N9S15653C33D1Ev)();
extern void ABISELECT(_ZThn40_N9S15653C33D0Ev,_ZThn20_N9S15653C33D0Ev)();
extern void _ZN9S15653C343v75Ev();
extern void _ZN9S15653C343v76Ev();
extern void _ZN9S15653C343v77Ev();
extern void _ZN9S15653C343v78Ev();
extern void _ZN9S15653C343v79Ev();
extern void _ZN9S15653C343v80Ev();
extern void _ZN9S15653C343v81Ev();
extern void _ZN9S15653C343v82Ev();
extern void _ZN9S15653C343v83Ev();
extern void _ZN9S15653C343v84Ev();
extern void _ZN9S15653C343v85Ev();
extern void _ZN9S15653C343v86Ev();
extern void _ZN9S15653C343v87Ev();
extern void _ZN9S15653C343v88Ev();
extern void _ZN9S15653C343v89Ev();
extern void _ZN9S15653C343v90Ev();
extern void _ZN9S15653C343v91Ev();
extern void _ZN9S15653C343v92Ev();
extern void _ZN9S15653C343v93Ev();
extern void _ZN9S15653C343v94Ev();
static  VTBL_ENTRY vtc_S15653C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C33[0]),
  (VTBL_ENTRY)&_ZN9S15653C33D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C33D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v49Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v50Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v51Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v52Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v53Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v54Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v55Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v56Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v57Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v58Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v59Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v60Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v61Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v62Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v63Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v64Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v65Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v66Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v67Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v68Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v69Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v70Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v71Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v72Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v73Ev,
  (VTBL_ENTRY)&_ZN9S15653C333v74Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S15653C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C33D1Ev,_ZThn20_N9S15653C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C33D0Ev,_ZThn20_N9S15653C33D0Ev),
  (VTBL_ENTRY)&_ZN9S15653C343v75Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v76Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v77Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v78Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v79Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v80Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v81Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v82Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v83Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v84Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v85Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v86Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v87Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v88Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v89Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v90Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v91Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v92Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v93Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v94Ev,
};
extern VTBL_ENTRY _ZTI9S15653C33[];
extern  VTBL_ENTRY _ZTV9S15653C33[];
Class_Descriptor cd_S15653C33 = {  "S15653C33", // class name
  bases_S15653C33, 2,
  &(vtc_S15653C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,152), // object size
  NSPAIRA(_ZTI9S15653C33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C33),60, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C32  {
  ::S15653C33 s15653c32f0;
  ::S17070C39_nt s15653c32f1;
  void  mf15653c32(); // _ZN9S15653C3210mf15653c32Ev
};
//SIG(-1 S15653C32) C1{ m FC2{ BC3{ vd v27 v28 v29 v30 v31 v32 FC4{ m Fp[4]}} BC5{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}} FC6 FC14{ BC7 FC15{ m FC16{ m FL}}}} FC17{ BC18{ BC19{ vd v53} vd v54 Fp[2] FC20{ m FC21{ m Fp Fi[2] FC22{ m}}} FC23{ m Fp[2]}} vd FC24{ m Fp Fi FC25{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC26{ m Fp[2]}}}}


void  S15653C32 ::mf15653c32(){}

static void Test_S15653C32()
{
  {
    init_simple_test("S15653C32");
    static S15653C32 lv;
    check2(sizeof(lv), ABISELECT(352,212), "sizeof(S15653C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C32)");
    check_field_offset(lv, s15653c32f0, 0, "S15653C32.s15653c32f0");
    check_field_offset(lv, s15653c32f1, ABISELECT(248,152), "S15653C32.s15653c32f1");
  }
}
static Arrange_To_Call_Me vS15653C32(Test_S15653C32, "S15653C32", ABISELECT(352,212));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C44  : S15653C4 , S15653C6 {
  ::S17070C14_nt s15653c44f0;
  ::S17070C22_nt s15653c44f1;
  ::S17070C51_nt s15653c44f2;
  ::S17070C51_nt s15653c44f3;
  ::S17070C51_nt s15653c44f4;
  ::S17070C51_nt s15653c44f5;
  ::S17070C25_nt s15653c44f6;
  ::S17070C51_nt s15653c44f7;
  ::S17070C51_nt s15653c44f8;
  ::S17070C51_nt s15653c44f9;
  virtual void  v96(); // _ZN9S15653C443v96Ev
  virtual void  v97(); // _ZN9S15653C443v97Ev
  virtual void  v98(); // _ZN9S15653C443v98Ev
  virtual void  v99(); // _ZN9S15653C443v99Ev
  virtual void  v100(); // _ZN9S15653C444v100Ev
  virtual void  v101(); // _ZN9S15653C444v101Ev
  virtual void  v102(); // _ZN9S15653C444v102Ev
  virtual void  v103(); // _ZN9S15653C444v103Ev
  virtual void  v104(); // _ZN9S15653C444v104Ev
  virtual void  v105(); // _ZN9S15653C444v105Ev
  virtual void  v106(); // _ZN9S15653C444v106Ev
  virtual void  v107(); // _ZN9S15653C444v107Ev
  virtual void  v108(); // _ZN9S15653C444v108Ev
  virtual void  v109(); // _ZN9S15653C444v109Ev
  virtual void  v110(); // _ZN9S15653C444v110Ev
  virtual void  v111(); // _ZN9S15653C444v111Ev
  virtual void  v112(); // _ZN9S15653C444v112Ev
  virtual void  v113(); // _ZN9S15653C444v113Ev
  virtual void  v114(); // _ZN9S15653C444v114Ev
  virtual void  v115(); // _ZN9S15653C444v115Ev
  virtual void  v116(); // _ZN9S15653C444v116Ev
  virtual void  v117(); // _ZN9S15653C444v117Ev
  virtual void  v118(); // _ZN9S15653C444v118Ev
  ~S15653C44(); // tgen
  S15653C44(); // tgen
};
//SIG(-1 S15653C44) C1{ BC2{ vd v24 v25 v26 v27 v28 v29 FC3{ m Fp[4]}} BC4{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC13{ BC6 FC8} FC13 FC13 FC13 FC14{ BC6 Fi} FC13 FC13 FC13}


void  S15653C44 ::v96(){vfunc_called(this, "_ZN9S15653C443v96Ev");}
void  S15653C44 ::v97(){vfunc_called(this, "_ZN9S15653C443v97Ev");}
void  S15653C44 ::v98(){vfunc_called(this, "_ZN9S15653C443v98Ev");}
void  S15653C44 ::v99(){vfunc_called(this, "_ZN9S15653C443v99Ev");}
void  S15653C44 ::v100(){vfunc_called(this, "_ZN9S15653C444v100Ev");}
void  S15653C44 ::v101(){vfunc_called(this, "_ZN9S15653C444v101Ev");}
void  S15653C44 ::v102(){vfunc_called(this, "_ZN9S15653C444v102Ev");}
void  S15653C44 ::v103(){vfunc_called(this, "_ZN9S15653C444v103Ev");}
void  S15653C44 ::v104(){vfunc_called(this, "_ZN9S15653C444v104Ev");}
void  S15653C44 ::v105(){vfunc_called(this, "_ZN9S15653C444v105Ev");}
void  S15653C44 ::v106(){vfunc_called(this, "_ZN9S15653C444v106Ev");}
void  S15653C44 ::v107(){vfunc_called(this, "_ZN9S15653C444v107Ev");}
void  S15653C44 ::v108(){vfunc_called(this, "_ZN9S15653C444v108Ev");}
void  S15653C44 ::v109(){vfunc_called(this, "_ZN9S15653C444v109Ev");}
void  S15653C44 ::v110(){vfunc_called(this, "_ZN9S15653C444v110Ev");}
void  S15653C44 ::v111(){vfunc_called(this, "_ZN9S15653C444v111Ev");}
void  S15653C44 ::v112(){vfunc_called(this, "_ZN9S15653C444v112Ev");}
void  S15653C44 ::v113(){vfunc_called(this, "_ZN9S15653C444v113Ev");}
void  S15653C44 ::v114(){vfunc_called(this, "_ZN9S15653C444v114Ev");}
void  S15653C44 ::v115(){vfunc_called(this, "_ZN9S15653C444v115Ev");}
void  S15653C44 ::v116(){vfunc_called(this, "_ZN9S15653C444v116Ev");}
void  S15653C44 ::v117(){vfunc_called(this, "_ZN9S15653C444v117Ev");}
void  S15653C44 ::v118(){vfunc_called(this, "_ZN9S15653C444v118Ev");}
S15653C44 ::~S15653C44(){ note_dtor("S15653C44", this);} // tgen
S15653C44 ::S15653C44(){ note_ctor("S15653C44", this);} // tgen

static void Test_S15653C44()
{
  extern Class_Descriptor cd_S15653C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(71,104)];
    init_test(&cd_S15653C44, buf);
    S15653C44 *dp, &lv = *(dp=new (buf) S15653C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(560,412), "sizeof(S15653C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C44)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C44");
    check_base_class_offset(lv, (S15653C6*), ABISELECT(40,20), "S15653C44");
    check_field_offset(lv, s15653c44f0, ABISELECT(48,24), "S15653C44.s15653c44f0");
    check_field_offset(lv, s15653c44f1, ABISELECT(144,108), "S15653C44.s15653c44f1");
    check_field_offset(lv, s15653c44f2, ABISELECT(184,136), "S15653C44.s15653c44f2");
    check_field_offset(lv, s15653c44f3, ABISELECT(232,172), "S15653C44.s15653c44f3");
    check_field_offset(lv, s15653c44f4, ABISELECT(280,208), "S15653C44.s15653c44f4");
    check_field_offset(lv, s15653c44f5, ABISELECT(328,244), "S15653C44.s15653c44f5");
    check_field_offset(lv, s15653c44f6, ABISELECT(376,280), "S15653C44.s15653c44f6");
    check_field_offset(lv, s15653c44f7, ABISELECT(416,304), "S15653C44.s15653c44f7");
    check_field_offset(lv, s15653c44f8, ABISELECT(464,340), "S15653C44.s15653c44f8");
    check_field_offset(lv, s15653c44f9, ABISELECT(512,376), "S15653C44.s15653c44f9");
    test_class_info(&lv, &cd_S15653C44);
    dp->~S15653C44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C44(Test_S15653C44, "S15653C44", ABISELECT(560,412));

#else // __cplusplus

extern void _ZN9S15653C44C1Ev();
extern void _ZN9S15653C44D1Ev();
Name_Map name_map_S15653C44[] = {
  NSPAIR(_ZN9S15653C44C1Ev),
  NSPAIR(_ZN9S15653C44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C6;
extern VTBL_ENTRY _ZTI8S15653C6[];
extern  VTBL_ENTRY _ZTV8S15653C6[];
static Base_Class bases_S15653C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C6,    ABISELECT(40,20), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C44[];
extern void _ZN9S15653C44D1Ev();
extern void _ZN9S15653C44D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C443v96Ev();
extern void _ZN9S15653C443v97Ev();
extern void _ZN9S15653C443v98Ev();
extern void _ZN9S15653C443v99Ev();
extern void _ZN9S15653C444v100Ev();
extern void _ZN9S15653C444v101Ev();
extern void _ZN9S15653C444v102Ev();
extern void _ZN9S15653C444v103Ev();
extern void _ZN9S15653C444v104Ev();
extern void _ZN9S15653C444v105Ev();
extern void _ZN9S15653C444v106Ev();
extern void _ZN9S15653C444v107Ev();
extern void _ZN9S15653C444v108Ev();
extern void _ZN9S15653C444v109Ev();
extern void _ZN9S15653C444v110Ev();
extern void _ZN9S15653C444v111Ev();
extern void _ZN9S15653C444v112Ev();
extern void _ZN9S15653C444v113Ev();
extern void _ZN9S15653C444v114Ev();
extern void _ZN9S15653C444v115Ev();
extern void _ZN9S15653C444v116Ev();
extern void _ZN9S15653C444v117Ev();
extern void _ZN9S15653C444v118Ev();
extern void ABISELECT(_ZThn40_N9S15653C44D1Ev,_ZThn20_N9S15653C44D1Ev)();
extern void ABISELECT(_ZThn40_N9S15653C44D0Ev,_ZThn20_N9S15653C44D0Ev)();
extern void _ZN8S15653C63v30Ev();
extern void _ZN8S15653C63v31Ev();
extern void _ZN8S15653C63v32Ev();
extern void _ZN8S15653C63v33Ev();
extern void _ZN8S15653C63v34Ev();
extern void _ZN8S15653C63v35Ev();
extern void _ZN8S15653C63v36Ev();
extern void _ZN8S15653C63v37Ev();
extern void _ZN8S15653C63v38Ev();
extern void _ZN8S15653C63v39Ev();
extern void _ZN8S15653C63v40Ev();
extern void _ZN8S15653C63v41Ev();
extern void _ZN8S15653C63v42Ev();
extern void _ZN8S15653C63v43Ev();
extern void _ZN8S15653C63v44Ev();
extern void _ZN8S15653C63v45Ev();
extern void _ZN8S15653C63v46Ev();
static  VTBL_ENTRY vtc_S15653C44[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C44[0]),
  (VTBL_ENTRY)&_ZN9S15653C44D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C44D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C443v96Ev,
  (VTBL_ENTRY)&_ZN9S15653C443v97Ev,
  (VTBL_ENTRY)&_ZN9S15653C443v98Ev,
  (VTBL_ENTRY)&_ZN9S15653C443v99Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v100Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v101Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v102Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v103Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v104Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v105Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v106Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v107Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v108Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v109Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v110Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v111Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v112Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v113Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v114Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v115Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v116Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v117Ev,
  (VTBL_ENTRY)&_ZN9S15653C444v118Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S15653C44[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C44D1Ev,_ZThn20_N9S15653C44D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C44D0Ev,_ZThn20_N9S15653C44D0Ev),
  (VTBL_ENTRY)&_ZN8S15653C63v30Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v31Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v32Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v33Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v34Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v35Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v36Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v37Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v38Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v39Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v40Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v41Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v42Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v43Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v44Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v45Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v46Ev,
};
extern VTBL_ENTRY _ZTI9S15653C44[];
extern  VTBL_ENTRY _ZTV9S15653C44[];
Class_Descriptor cd_S15653C44 = {  "S15653C44", // class name
  bases_S15653C44, 2,
  &(vtc_S15653C44[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(560,412), // object size
  NSPAIRA(_ZTI9S15653C44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C44),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C43  {
  ::S15653C44 s15653c43f0;
  ::S17070C26_nt s15653c43f1;
  void  mf15653c43(); // _ZN9S15653C4310mf15653c43Ev
};
//SIG(-1 S15653C43) C1{ m FC2{ BC3{ vd v24 v25 v26 v27 v28 v29 FC4{ m Fp[4]}} BC5{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC14{ BC7 FC9} FC14 FC14 FC14 FC15{ BC7 Fi} FC14 FC14 FC14} FC16{ BC17{ BC18{ vd v47} vd v48 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC22}}}


void  S15653C43 ::mf15653c43(){}

static void Test_S15653C43()
{
  {
    init_simple_test("S15653C43");
    S15653C43 lv;
    check2(sizeof(lv), ABISELECT(760,576), "sizeof(S15653C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C43)");
    check_field_offset(lv, s15653c43f0, 0, "S15653C43.s15653c43f0");
    check_field_offset(lv, s15653c43f1, ABISELECT(560,412), "S15653C43.s15653c43f1");
  }
}
static Arrange_To_Call_Me vS15653C43(Test_S15653C43, "S15653C43", ABISELECT(760,576));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C46  : S15653C4 , S15653C34 {
  ::S17070C51_nt s15653c46f0;
  ::S17070C19_nt s15653c46f1;
  ::S17070C25_nt s15653c46f2;
  ::S17070C51_nt s15653c46f3;
  ::S17070C51_nt s15653c46f4;
  ::S17070C19_nt s15653c46f5;
  ::S17070C22_nt s15653c46f6;
  virtual void  v119(); // _ZN9S15653C464v119Ev
  virtual void  v120(); // _ZN9S15653C464v120Ev
  virtual void  v121(); // _ZN9S15653C464v121Ev
  virtual void  v122(); // _ZN9S15653C464v122Ev
  virtual void  v123(); // _ZN9S15653C464v123Ev
  virtual void  v124(); // _ZN9S15653C464v124Ev
  virtual void  v125(); // _ZN9S15653C464v125Ev
  virtual void  v126(); // _ZN9S15653C464v126Ev
  virtual void  v127(); // _ZN9S15653C464v127Ev
  virtual void  v128(); // _ZN9S15653C464v128Ev
  virtual void  v129(); // _ZN9S15653C464v129Ev
  virtual void  v130(); // _ZN9S15653C464v130Ev
  virtual void  v131(); // _ZN9S15653C464v131Ev
  virtual void  v132(); // _ZN9S15653C464v132Ev
  virtual void  v133(); // _ZN9S15653C464v133Ev
  virtual void  v134(); // _ZN9S15653C464v134Ev
  virtual void  v135(); // _ZN9S15653C464v135Ev
  virtual void  v136(); // _ZN9S15653C464v136Ev
  virtual void  v137(); // _ZN9S15653C464v137Ev
  virtual void  v138(); // _ZN9S15653C464v138Ev
  virtual void  v139(); // _ZN9S15653C464v139Ev
  virtual void  v140(); // _ZN9S15653C464v140Ev
  virtual void  v141(); // _ZN9S15653C464v141Ev
  virtual void  v142(); // _ZN9S15653C464v142Ev
  virtual void  v143(); // _ZN9S15653C464v143Ev
  virtual void  v144(); // _ZN9S15653C464v144Ev
  ~S15653C46(); // tgen
  S15653C46(); // tgen
};
//SIG(-1 S15653C46) C1{ BC2{ vd v27 v28 v29 v30 v31 v32 FC3{ m Fp[4]}} BC4{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FL[2]}}} FC9{ BC6 FC10{ m FC11{ m Fp[2]} FC12{ m Fp}}} FC13{ BC6 Fi} FC5 FC5 FC9 FC14{ BC6 FC15{ m FC16{ m FL}}}}


void  S15653C46 ::v119(){vfunc_called(this, "_ZN9S15653C464v119Ev");}
void  S15653C46 ::v120(){vfunc_called(this, "_ZN9S15653C464v120Ev");}
void  S15653C46 ::v121(){vfunc_called(this, "_ZN9S15653C464v121Ev");}
void  S15653C46 ::v122(){vfunc_called(this, "_ZN9S15653C464v122Ev");}
void  S15653C46 ::v123(){vfunc_called(this, "_ZN9S15653C464v123Ev");}
void  S15653C46 ::v124(){vfunc_called(this, "_ZN9S15653C464v124Ev");}
void  S15653C46 ::v125(){vfunc_called(this, "_ZN9S15653C464v125Ev");}
void  S15653C46 ::v126(){vfunc_called(this, "_ZN9S15653C464v126Ev");}
void  S15653C46 ::v127(){vfunc_called(this, "_ZN9S15653C464v127Ev");}
void  S15653C46 ::v128(){vfunc_called(this, "_ZN9S15653C464v128Ev");}
void  S15653C46 ::v129(){vfunc_called(this, "_ZN9S15653C464v129Ev");}
void  S15653C46 ::v130(){vfunc_called(this, "_ZN9S15653C464v130Ev");}
void  S15653C46 ::v131(){vfunc_called(this, "_ZN9S15653C464v131Ev");}
void  S15653C46 ::v132(){vfunc_called(this, "_ZN9S15653C464v132Ev");}
void  S15653C46 ::v133(){vfunc_called(this, "_ZN9S15653C464v133Ev");}
void  S15653C46 ::v134(){vfunc_called(this, "_ZN9S15653C464v134Ev");}
void  S15653C46 ::v135(){vfunc_called(this, "_ZN9S15653C464v135Ev");}
void  S15653C46 ::v136(){vfunc_called(this, "_ZN9S15653C464v136Ev");}
void  S15653C46 ::v137(){vfunc_called(this, "_ZN9S15653C464v137Ev");}
void  S15653C46 ::v138(){vfunc_called(this, "_ZN9S15653C464v138Ev");}
void  S15653C46 ::v139(){vfunc_called(this, "_ZN9S15653C464v139Ev");}
void  S15653C46 ::v140(){vfunc_called(this, "_ZN9S15653C464v140Ev");}
void  S15653C46 ::v141(){vfunc_called(this, "_ZN9S15653C464v141Ev");}
void  S15653C46 ::v142(){vfunc_called(this, "_ZN9S15653C464v142Ev");}
void  S15653C46 ::v143(){vfunc_called(this, "_ZN9S15653C464v143Ev");}
void  S15653C46 ::v144(){vfunc_called(this, "_ZN9S15653C464v144Ev");}
S15653C46 ::~S15653C46(){ note_dtor("S15653C46", this);} // tgen
S15653C46 ::S15653C46(){ note_ctor("S15653C46", this);} // tgen

static void Test_S15653C46()
{
  extern Class_Descriptor cd_S15653C46;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,63)];
    init_test(&cd_S15653C46, buf);
    S15653C46 *dp, &lv = *(dp=new (buf) S15653C46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,248), "sizeof(S15653C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C46)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C46");
    check_base_class_offset(lv, (S15653C34*), ABISELECT(40,20), "S15653C46");
    check_field_offset(lv, s15653c46f0, ABISELECT(48,24), "S15653C46.s15653c46f0");
    check_field_offset(lv, s15653c46f1, ABISELECT(96,60), "S15653C46.s15653c46f1");
    check_field_offset(lv, s15653c46f2, ABISELECT(152,92), "S15653C46.s15653c46f2");
    check_field_offset(lv, s15653c46f3, ABISELECT(192,116), "S15653C46.s15653c46f3");
    check_field_offset(lv, s15653c46f4, ABISELECT(240,152), "S15653C46.s15653c46f4");
    check_field_offset(lv, s15653c46f5, ABISELECT(288,188), "S15653C46.s15653c46f5");
    check_field_offset(lv, s15653c46f6, ABISELECT(344,220), "S15653C46.s15653c46f6");
    test_class_info(&lv, &cd_S15653C46);
    dp->~S15653C46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C46(Test_S15653C46, "S15653C46", ABISELECT(384,248));

#else // __cplusplus

extern void _ZN9S15653C46C1Ev();
extern void _ZN9S15653C46D1Ev();
Name_Map name_map_S15653C46[] = {
  NSPAIR(_ZN9S15653C46C1Ev),
  NSPAIR(_ZN9S15653C46D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C34;
extern VTBL_ENTRY _ZTI9S15653C34[];
extern  VTBL_ENTRY _ZTV9S15653C34[];
static Base_Class bases_S15653C46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C34,    ABISELECT(40,20), //bcp->offset
    36, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C46[];
extern void _ZN9S15653C46D1Ev();
extern void _ZN9S15653C46D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C464v119Ev();
extern void _ZN9S15653C464v120Ev();
extern void _ZN9S15653C464v121Ev();
extern void _ZN9S15653C464v122Ev();
extern void _ZN9S15653C464v123Ev();
extern void _ZN9S15653C464v124Ev();
extern void _ZN9S15653C464v125Ev();
extern void _ZN9S15653C464v126Ev();
extern void _ZN9S15653C464v127Ev();
extern void _ZN9S15653C464v128Ev();
extern void _ZN9S15653C464v129Ev();
extern void _ZN9S15653C464v130Ev();
extern void _ZN9S15653C464v131Ev();
extern void _ZN9S15653C464v132Ev();
extern void _ZN9S15653C464v133Ev();
extern void _ZN9S15653C464v134Ev();
extern void _ZN9S15653C464v135Ev();
extern void _ZN9S15653C464v136Ev();
extern void _ZN9S15653C464v137Ev();
extern void _ZN9S15653C464v138Ev();
extern void _ZN9S15653C464v139Ev();
extern void _ZN9S15653C464v140Ev();
extern void _ZN9S15653C464v141Ev();
extern void _ZN9S15653C464v142Ev();
extern void _ZN9S15653C464v143Ev();
extern void _ZN9S15653C464v144Ev();
extern void ABISELECT(_ZThn40_N9S15653C46D1Ev,_ZThn20_N9S15653C46D1Ev)();
extern void ABISELECT(_ZThn40_N9S15653C46D0Ev,_ZThn20_N9S15653C46D0Ev)();
extern void _ZN9S15653C343v75Ev();
extern void _ZN9S15653C343v76Ev();
extern void _ZN9S15653C343v77Ev();
extern void _ZN9S15653C343v78Ev();
extern void _ZN9S15653C343v79Ev();
extern void _ZN9S15653C343v80Ev();
extern void _ZN9S15653C343v81Ev();
extern void _ZN9S15653C343v82Ev();
extern void _ZN9S15653C343v83Ev();
extern void _ZN9S15653C343v84Ev();
extern void _ZN9S15653C343v85Ev();
extern void _ZN9S15653C343v86Ev();
extern void _ZN9S15653C343v87Ev();
extern void _ZN9S15653C343v88Ev();
extern void _ZN9S15653C343v89Ev();
extern void _ZN9S15653C343v90Ev();
extern void _ZN9S15653C343v91Ev();
extern void _ZN9S15653C343v92Ev();
extern void _ZN9S15653C343v93Ev();
extern void _ZN9S15653C343v94Ev();
static  VTBL_ENTRY vtc_S15653C46[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C46[0]),
  (VTBL_ENTRY)&_ZN9S15653C46D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C46D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v119Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v120Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v121Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v122Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v123Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v124Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v125Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v126Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v127Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v128Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v129Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v130Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v131Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v132Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v133Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v134Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v135Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v136Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v137Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v138Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v139Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v140Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v141Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v142Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v143Ev,
  (VTBL_ENTRY)&_ZN9S15653C464v144Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S15653C46[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C46D1Ev,_ZThn20_N9S15653C46D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C46D0Ev,_ZThn20_N9S15653C46D0Ev),
  (VTBL_ENTRY)&_ZN9S15653C343v75Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v76Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v77Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v78Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v79Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v80Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v81Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v82Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v83Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v84Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v85Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v86Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v87Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v88Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v89Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v90Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v91Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v92Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v93Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v94Ev,
};
extern VTBL_ENTRY _ZTI9S15653C46[];
extern  VTBL_ENTRY _ZTV9S15653C46[];
Class_Descriptor cd_S15653C46 = {  "S15653C46", // class name
  bases_S15653C46, 2,
  &(vtc_S15653C46[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,248), // object size
  NSPAIRA(_ZTI9S15653C46),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C46),60, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C45  {
  ::S15653C46 s15653c45f0;
  ::S17070C39_nt s15653c45f1;
  void  mf15653c45(); // _ZN9S15653C4510mf15653c45Ev
};
//SIG(-1 S15653C45) C1{ m FC2{ BC3{ vd v27 v28 v29 v30 v31 v32 FC4{ m Fp[4]}} BC5{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FL[2]}}} FC10{ BC7 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}} FC14{ BC7 Fi} FC6 FC6 FC10 FC15{ BC7 FC16{ m FC17{ m FL}}}} FC18{ BC19{ BC20{ vd v53} vd v54 Fp[2] FC21{ m FC22{ m Fp Fi[2] FC23{ m}}} FC24{ m Fp[2]}} vd FC25{ m Fp Fi FC26{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC27{ m Fp[2]}}}}


void  S15653C45 ::mf15653c45(){}

static void Test_S15653C45()
{
  {
    init_simple_test("S15653C45");
    static S15653C45 lv;
    check2(sizeof(lv), ABISELECT(488,308), "sizeof(S15653C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C45)");
    check_field_offset(lv, s15653c45f0, 0, "S15653C45.s15653c45f0");
    check_field_offset(lv, s15653c45f1, ABISELECT(384,248), "S15653C45.s15653c45f1");
  }
}
static Arrange_To_Call_Me vS15653C45(Test_S15653C45, "S15653C45", ABISELECT(488,308));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C48  : S15653C4 , S15653C6 {
  ::S17070C14_nt s15653c48f0;
  ::S17070C14_nt s15653c48f1;
  ::S17070C22_nt s15653c48f2;
  ::S17070C51_nt s15653c48f3;
  ::S17070C51_nt s15653c48f4;
  ::S17070C51_nt s15653c48f5;
  ::S17070C51_nt s15653c48f6;
  ::S17070C25_nt s15653c48f7;
  ::S17070C51_nt s15653c48f8;
  ::S17070C14_nt s15653c48f9;
  ::S17070C14_nt s15653c48f10;
  ::S17070C14_nt s15653c48f11;
  ::S17070C51_nt s15653c48f12;
  ::S17070C51_nt s15653c48f13;
  virtual void  v145(); // _ZN9S15653C484v145Ev
  virtual void  v146(); // _ZN9S15653C484v146Ev
  virtual void  v147(); // _ZN9S15653C484v147Ev
  virtual void  v148(); // _ZN9S15653C484v148Ev
  virtual void  v149(); // _ZN9S15653C484v149Ev
  virtual void  v150(); // _ZN9S15653C484v150Ev
  virtual void  v151(); // _ZN9S15653C484v151Ev
  virtual void  v152(); // _ZN9S15653C484v152Ev
  virtual void  v153(); // _ZN9S15653C484v153Ev
  virtual void  v154(); // _ZN9S15653C484v154Ev
  virtual void  v155(); // _ZN9S15653C484v155Ev
  virtual void  v156(); // _ZN9S15653C484v156Ev
  virtual void  v157(); // _ZN9S15653C484v157Ev
  virtual void  v158(); // _ZN9S15653C484v158Ev
  virtual void  v159(); // _ZN9S15653C484v159Ev
  virtual void  v160(); // _ZN9S15653C484v160Ev
  virtual void  v161(); // _ZN9S15653C484v161Ev
  virtual void  v162(); // _ZN9S15653C484v162Ev
  virtual void  v163(); // _ZN9S15653C484v163Ev
  virtual void  v164(); // _ZN9S15653C484v164Ev
  virtual void  v165(); // _ZN9S15653C484v165Ev
  virtual void  v166(); // _ZN9S15653C484v166Ev
  virtual void  v167(); // _ZN9S15653C484v167Ev
  ~S15653C48(); // tgen
  S15653C48(); // tgen
};
//SIG(-1 S15653C48) C1{ BC2{ vd v24 v25 v26 v27 v28 v29 FC3{ m Fp[4]}} BC4{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC5 FC10{ BC6 FC11{ m FC12{ m FL}}} FC13{ BC6 FC8} FC13 FC13 FC13 FC14{ BC6 Fi} FC13 FC5 FC5 FC5 FC13 FC13}


void  S15653C48 ::v145(){vfunc_called(this, "_ZN9S15653C484v145Ev");}
void  S15653C48 ::v146(){vfunc_called(this, "_ZN9S15653C484v146Ev");}
void  S15653C48 ::v147(){vfunc_called(this, "_ZN9S15653C484v147Ev");}
void  S15653C48 ::v148(){vfunc_called(this, "_ZN9S15653C484v148Ev");}
void  S15653C48 ::v149(){vfunc_called(this, "_ZN9S15653C484v149Ev");}
void  S15653C48 ::v150(){vfunc_called(this, "_ZN9S15653C484v150Ev");}
void  S15653C48 ::v151(){vfunc_called(this, "_ZN9S15653C484v151Ev");}
void  S15653C48 ::v152(){vfunc_called(this, "_ZN9S15653C484v152Ev");}
void  S15653C48 ::v153(){vfunc_called(this, "_ZN9S15653C484v153Ev");}
void  S15653C48 ::v154(){vfunc_called(this, "_ZN9S15653C484v154Ev");}
void  S15653C48 ::v155(){vfunc_called(this, "_ZN9S15653C484v155Ev");}
void  S15653C48 ::v156(){vfunc_called(this, "_ZN9S15653C484v156Ev");}
void  S15653C48 ::v157(){vfunc_called(this, "_ZN9S15653C484v157Ev");}
void  S15653C48 ::v158(){vfunc_called(this, "_ZN9S15653C484v158Ev");}
void  S15653C48 ::v159(){vfunc_called(this, "_ZN9S15653C484v159Ev");}
void  S15653C48 ::v160(){vfunc_called(this, "_ZN9S15653C484v160Ev");}
void  S15653C48 ::v161(){vfunc_called(this, "_ZN9S15653C484v161Ev");}
void  S15653C48 ::v162(){vfunc_called(this, "_ZN9S15653C484v162Ev");}
void  S15653C48 ::v163(){vfunc_called(this, "_ZN9S15653C484v163Ev");}
void  S15653C48 ::v164(){vfunc_called(this, "_ZN9S15653C484v164Ev");}
void  S15653C48 ::v165(){vfunc_called(this, "_ZN9S15653C484v165Ev");}
void  S15653C48 ::v166(){vfunc_called(this, "_ZN9S15653C484v166Ev");}
void  S15653C48 ::v167(){vfunc_called(this, "_ZN9S15653C484v167Ev");}
S15653C48 ::~S15653C48(){ note_dtor("S15653C48", this);} // tgen
S15653C48 ::S15653C48(){ note_ctor("S15653C48", this);} // tgen

static void Test_S15653C48()
{
  extern Class_Descriptor cd_S15653C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(119,188)];
    init_test(&cd_S15653C48, buf);
    S15653C48 *dp, &lv = *(dp=new (buf) S15653C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(944,748), "sizeof(S15653C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C48)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C48");
    check_base_class_offset(lv, (S15653C6*), ABISELECT(40,20), "S15653C48");
    check_field_offset(lv, s15653c48f0, ABISELECT(48,24), "S15653C48.s15653c48f0");
    check_field_offset(lv, s15653c48f1, ABISELECT(144,108), "S15653C48.s15653c48f1");
    check_field_offset(lv, s15653c48f2, ABISELECT(240,192), "S15653C48.s15653c48f2");
    check_field_offset(lv, s15653c48f3, ABISELECT(280,220), "S15653C48.s15653c48f3");
    check_field_offset(lv, s15653c48f4, ABISELECT(328,256), "S15653C48.s15653c48f4");
    check_field_offset(lv, s15653c48f5, ABISELECT(376,292), "S15653C48.s15653c48f5");
    check_field_offset(lv, s15653c48f6, ABISELECT(424,328), "S15653C48.s15653c48f6");
    check_field_offset(lv, s15653c48f7, ABISELECT(472,364), "S15653C48.s15653c48f7");
    check_field_offset(lv, s15653c48f8, ABISELECT(512,388), "S15653C48.s15653c48f8");
    check_field_offset(lv, s15653c48f9, ABISELECT(560,424), "S15653C48.s15653c48f9");
    check_field_offset(lv, s15653c48f10, ABISELECT(656,508), "S15653C48.s15653c48f10");
    check_field_offset(lv, s15653c48f11, ABISELECT(752,592), "S15653C48.s15653c48f11");
    check_field_offset(lv, s15653c48f12, ABISELECT(848,676), "S15653C48.s15653c48f12");
    check_field_offset(lv, s15653c48f13, ABISELECT(896,712), "S15653C48.s15653c48f13");
    test_class_info(&lv, &cd_S15653C48);
    dp->~S15653C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C48(Test_S15653C48, "S15653C48", ABISELECT(944,748));

#else // __cplusplus

extern void _ZN9S15653C48C1Ev();
extern void _ZN9S15653C48D1Ev();
Name_Map name_map_S15653C48[] = {
  NSPAIR(_ZN9S15653C48C1Ev),
  NSPAIR(_ZN9S15653C48D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C6;
extern VTBL_ENTRY _ZTI8S15653C6[];
extern  VTBL_ENTRY _ZTV8S15653C6[];
static Base_Class bases_S15653C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C6,    ABISELECT(40,20), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C48[];
extern void _ZN9S15653C48D1Ev();
extern void _ZN9S15653C48D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C484v145Ev();
extern void _ZN9S15653C484v146Ev();
extern void _ZN9S15653C484v147Ev();
extern void _ZN9S15653C484v148Ev();
extern void _ZN9S15653C484v149Ev();
extern void _ZN9S15653C484v150Ev();
extern void _ZN9S15653C484v151Ev();
extern void _ZN9S15653C484v152Ev();
extern void _ZN9S15653C484v153Ev();
extern void _ZN9S15653C484v154Ev();
extern void _ZN9S15653C484v155Ev();
extern void _ZN9S15653C484v156Ev();
extern void _ZN9S15653C484v157Ev();
extern void _ZN9S15653C484v158Ev();
extern void _ZN9S15653C484v159Ev();
extern void _ZN9S15653C484v160Ev();
extern void _ZN9S15653C484v161Ev();
extern void _ZN9S15653C484v162Ev();
extern void _ZN9S15653C484v163Ev();
extern void _ZN9S15653C484v164Ev();
extern void _ZN9S15653C484v165Ev();
extern void _ZN9S15653C484v166Ev();
extern void _ZN9S15653C484v167Ev();
extern void ABISELECT(_ZThn40_N9S15653C48D1Ev,_ZThn20_N9S15653C48D1Ev)();
extern void ABISELECT(_ZThn40_N9S15653C48D0Ev,_ZThn20_N9S15653C48D0Ev)();
extern void _ZN8S15653C63v30Ev();
extern void _ZN8S15653C63v31Ev();
extern void _ZN8S15653C63v32Ev();
extern void _ZN8S15653C63v33Ev();
extern void _ZN8S15653C63v34Ev();
extern void _ZN8S15653C63v35Ev();
extern void _ZN8S15653C63v36Ev();
extern void _ZN8S15653C63v37Ev();
extern void _ZN8S15653C63v38Ev();
extern void _ZN8S15653C63v39Ev();
extern void _ZN8S15653C63v40Ev();
extern void _ZN8S15653C63v41Ev();
extern void _ZN8S15653C63v42Ev();
extern void _ZN8S15653C63v43Ev();
extern void _ZN8S15653C63v44Ev();
extern void _ZN8S15653C63v45Ev();
extern void _ZN8S15653C63v46Ev();
static  VTBL_ENTRY vtc_S15653C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C48[0]),
  (VTBL_ENTRY)&_ZN9S15653C48D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C48D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v145Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v146Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v147Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v148Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v149Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v150Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v151Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v152Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v153Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v154Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v155Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v156Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v157Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v158Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v159Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v160Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v161Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v162Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v163Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v164Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v165Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v166Ev,
  (VTBL_ENTRY)&_ZN9S15653C484v167Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S15653C48[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C48D1Ev,_ZThn20_N9S15653C48D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C48D0Ev,_ZThn20_N9S15653C48D0Ev),
  (VTBL_ENTRY)&_ZN8S15653C63v30Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v31Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v32Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v33Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v34Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v35Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v36Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v37Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v38Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v39Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v40Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v41Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v42Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v43Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v44Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v45Ev,
  (VTBL_ENTRY)&_ZN8S15653C63v46Ev,
};
extern VTBL_ENTRY _ZTI9S15653C48[];
extern  VTBL_ENTRY _ZTV9S15653C48[];
Class_Descriptor cd_S15653C48 = {  "S15653C48", // class name
  bases_S15653C48, 2,
  &(vtc_S15653C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(944,748), // object size
  NSPAIRA(_ZTI9S15653C48),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C48),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C47  {
  ::S15653C48 s15653c47f0;
  ::S17070C26_nt s15653c47f1;
  void  mf15653c47(); // _ZN9S15653C4710mf15653c47Ev
};
//SIG(-1 S15653C47) C1{ m FC2{ BC3{ vd v24 v25 v26 v27 v28 v29 FC4{ m Fp[4]}} BC5{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC6 FC11{ BC7 FC12{ m FC13{ m FL}}} FC14{ BC7 FC9} FC14 FC14 FC14 FC15{ BC7 Fi} FC14 FC6 FC6 FC6 FC14 FC14} FC16{ BC17{ BC18{ vd v47} vd v48 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC22}}}


void  S15653C47 ::mf15653c47(){}

static void Test_S15653C47()
{
  {
    init_simple_test("S15653C47");
    S15653C47 lv;
    check2(sizeof(lv), ABISELECT(1144,912), "sizeof(S15653C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C47)");
    check_field_offset(lv, s15653c47f0, 0, "S15653C47.s15653c47f0");
    check_field_offset(lv, s15653c47f1, ABISELECT(944,748), "S15653C47.s15653c47f1");
  }
}
static Arrange_To_Call_Me vS15653C47(Test_S15653C47, "S15653C47", ABISELECT(1144,912));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C50  : S15653C4 , S15653C34 {
  ::S17070C14_nt s15653c50f0;
  ::S17070C14_nt s15653c50f1;
  ::S17070C19_nt s15653c50f2;
  ::S17070C51_nt s15653c50f3;
  ::S17070C19_nt s15653c50f4;
  ::S17070C25_nt s15653c50f5;
  virtual void  v168(); // _ZN9S15653C504v168Ev
  virtual void  v169(); // _ZN9S15653C504v169Ev
  virtual void  v170(); // _ZN9S15653C504v170Ev
  virtual void  v171(); // _ZN9S15653C504v171Ev
  virtual void  v172(); // _ZN9S15653C504v172Ev
  virtual void  v173(); // _ZN9S15653C504v173Ev
  virtual void  v174(); // _ZN9S15653C504v174Ev
  virtual void  v175(); // _ZN9S15653C504v175Ev
  virtual void  v176(); // _ZN9S15653C504v176Ev
  virtual void  v177(); // _ZN9S15653C504v177Ev
  virtual void  v178(); // _ZN9S15653C504v178Ev
  virtual void  v179(); // _ZN9S15653C504v179Ev
  virtual void  v180(); // _ZN9S15653C504v180Ev
  virtual void  v181(); // _ZN9S15653C504v181Ev
  virtual void  v182(); // _ZN9S15653C504v182Ev
  virtual void  v183(); // _ZN9S15653C504v183Ev
  virtual void  v184(); // _ZN9S15653C504v184Ev
  virtual void  v185(); // _ZN9S15653C504v185Ev
  virtual void  v186(); // _ZN9S15653C504v186Ev
  virtual void  v187(); // _ZN9S15653C504v187Ev
  virtual void  v188(); // _ZN9S15653C504v188Ev
  virtual void  v189(); // _ZN9S15653C504v189Ev
  virtual void  v190(); // _ZN9S15653C504v190Ev
  virtual void  v191(); // _ZN9S15653C504v191Ev
  virtual void  v192(); // _ZN9S15653C504v192Ev
  virtual void  v193(); // _ZN9S15653C504v193Ev
  ~S15653C50(); // tgen
  S15653C50(); // tgen
};
//SIG(-1 S15653C50) C1{ BC2{ vd v27 v28 v29 v30 v31 v32 FC3{ m Fp[4]}} BC4{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC5 FC10{ BC6 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}} FC14{ BC6 FC8} FC10 FC15{ BC6 Fi}}


void  S15653C50 ::v168(){vfunc_called(this, "_ZN9S15653C504v168Ev");}
void  S15653C50 ::v169(){vfunc_called(this, "_ZN9S15653C504v169Ev");}
void  S15653C50 ::v170(){vfunc_called(this, "_ZN9S15653C504v170Ev");}
void  S15653C50 ::v171(){vfunc_called(this, "_ZN9S15653C504v171Ev");}
void  S15653C50 ::v172(){vfunc_called(this, "_ZN9S15653C504v172Ev");}
void  S15653C50 ::v173(){vfunc_called(this, "_ZN9S15653C504v173Ev");}
void  S15653C50 ::v174(){vfunc_called(this, "_ZN9S15653C504v174Ev");}
void  S15653C50 ::v175(){vfunc_called(this, "_ZN9S15653C504v175Ev");}
void  S15653C50 ::v176(){vfunc_called(this, "_ZN9S15653C504v176Ev");}
void  S15653C50 ::v177(){vfunc_called(this, "_ZN9S15653C504v177Ev");}
void  S15653C50 ::v178(){vfunc_called(this, "_ZN9S15653C504v178Ev");}
void  S15653C50 ::v179(){vfunc_called(this, "_ZN9S15653C504v179Ev");}
void  S15653C50 ::v180(){vfunc_called(this, "_ZN9S15653C504v180Ev");}
void  S15653C50 ::v181(){vfunc_called(this, "_ZN9S15653C504v181Ev");}
void  S15653C50 ::v182(){vfunc_called(this, "_ZN9S15653C504v182Ev");}
void  S15653C50 ::v183(){vfunc_called(this, "_ZN9S15653C504v183Ev");}
void  S15653C50 ::v184(){vfunc_called(this, "_ZN9S15653C504v184Ev");}
void  S15653C50 ::v185(){vfunc_called(this, "_ZN9S15653C504v185Ev");}
void  S15653C50 ::v186(){vfunc_called(this, "_ZN9S15653C504v186Ev");}
void  S15653C50 ::v187(){vfunc_called(this, "_ZN9S15653C504v187Ev");}
void  S15653C50 ::v188(){vfunc_called(this, "_ZN9S15653C504v188Ev");}
void  S15653C50 ::v189(){vfunc_called(this, "_ZN9S15653C504v189Ev");}
void  S15653C50 ::v190(){vfunc_called(this, "_ZN9S15653C504v190Ev");}
void  S15653C50 ::v191(){vfunc_called(this, "_ZN9S15653C504v191Ev");}
void  S15653C50 ::v192(){vfunc_called(this, "_ZN9S15653C504v192Ev");}
void  S15653C50 ::v193(){vfunc_called(this, "_ZN9S15653C504v193Ev");}
S15653C50 ::~S15653C50(){ note_dtor("S15653C50", this);} // tgen
S15653C50 ::S15653C50(){ note_ctor("S15653C50", this);} // tgen

static void Test_S15653C50()
{
  extern Class_Descriptor cd_S15653C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(56,80)];
    init_test(&cd_S15653C50, buf);
    S15653C50 *dp, &lv = *(dp=new (buf) S15653C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(440,316), "sizeof(S15653C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C50)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C50");
    check_base_class_offset(lv, (S15653C34*), ABISELECT(40,20), "S15653C50");
    check_field_offset(lv, s15653c50f0, ABISELECT(48,24), "S15653C50.s15653c50f0");
    check_field_offset(lv, s15653c50f1, ABISELECT(144,108), "S15653C50.s15653c50f1");
    check_field_offset(lv, s15653c50f2, ABISELECT(240,192), "S15653C50.s15653c50f2");
    check_field_offset(lv, s15653c50f3, ABISELECT(296,224), "S15653C50.s15653c50f3");
    check_field_offset(lv, s15653c50f4, ABISELECT(344,260), "S15653C50.s15653c50f4");
    check_field_offset(lv, s15653c50f5, ABISELECT(400,292), "S15653C50.s15653c50f5");
    test_class_info(&lv, &cd_S15653C50);
    dp->~S15653C50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C50(Test_S15653C50, "S15653C50", ABISELECT(440,316));

#else // __cplusplus

extern void _ZN9S15653C50C1Ev();
extern void _ZN9S15653C50D1Ev();
Name_Map name_map_S15653C50[] = {
  NSPAIR(_ZN9S15653C50C1Ev),
  NSPAIR(_ZN9S15653C50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C34;
extern VTBL_ENTRY _ZTI9S15653C34[];
extern  VTBL_ENTRY _ZTV9S15653C34[];
static Base_Class bases_S15653C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C34,    ABISELECT(40,20), //bcp->offset
    36, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C50[];
extern void _ZN9S15653C50D1Ev();
extern void _ZN9S15653C50D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C504v168Ev();
extern void _ZN9S15653C504v169Ev();
extern void _ZN9S15653C504v170Ev();
extern void _ZN9S15653C504v171Ev();
extern void _ZN9S15653C504v172Ev();
extern void _ZN9S15653C504v173Ev();
extern void _ZN9S15653C504v174Ev();
extern void _ZN9S15653C504v175Ev();
extern void _ZN9S15653C504v176Ev();
extern void _ZN9S15653C504v177Ev();
extern void _ZN9S15653C504v178Ev();
extern void _ZN9S15653C504v179Ev();
extern void _ZN9S15653C504v180Ev();
extern void _ZN9S15653C504v181Ev();
extern void _ZN9S15653C504v182Ev();
extern void _ZN9S15653C504v183Ev();
extern void _ZN9S15653C504v184Ev();
extern void _ZN9S15653C504v185Ev();
extern void _ZN9S15653C504v186Ev();
extern void _ZN9S15653C504v187Ev();
extern void _ZN9S15653C504v188Ev();
extern void _ZN9S15653C504v189Ev();
extern void _ZN9S15653C504v190Ev();
extern void _ZN9S15653C504v191Ev();
extern void _ZN9S15653C504v192Ev();
extern void _ZN9S15653C504v193Ev();
extern void ABISELECT(_ZThn40_N9S15653C50D1Ev,_ZThn20_N9S15653C50D1Ev)();
extern void ABISELECT(_ZThn40_N9S15653C50D0Ev,_ZThn20_N9S15653C50D0Ev)();
extern void _ZN9S15653C343v75Ev();
extern void _ZN9S15653C343v76Ev();
extern void _ZN9S15653C343v77Ev();
extern void _ZN9S15653C343v78Ev();
extern void _ZN9S15653C343v79Ev();
extern void _ZN9S15653C343v80Ev();
extern void _ZN9S15653C343v81Ev();
extern void _ZN9S15653C343v82Ev();
extern void _ZN9S15653C343v83Ev();
extern void _ZN9S15653C343v84Ev();
extern void _ZN9S15653C343v85Ev();
extern void _ZN9S15653C343v86Ev();
extern void _ZN9S15653C343v87Ev();
extern void _ZN9S15653C343v88Ev();
extern void _ZN9S15653C343v89Ev();
extern void _ZN9S15653C343v90Ev();
extern void _ZN9S15653C343v91Ev();
extern void _ZN9S15653C343v92Ev();
extern void _ZN9S15653C343v93Ev();
extern void _ZN9S15653C343v94Ev();
static  VTBL_ENTRY vtc_S15653C50[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C50[0]),
  (VTBL_ENTRY)&_ZN9S15653C50D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C50D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v168Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v169Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v170Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v171Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v172Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v173Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v174Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v175Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v176Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v177Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v178Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v179Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v180Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v181Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v182Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v183Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v184Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v185Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v186Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v187Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v188Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v189Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v190Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v191Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v192Ev,
  (VTBL_ENTRY)&_ZN9S15653C504v193Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S15653C50[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C50D1Ev,_ZThn20_N9S15653C50D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C50D0Ev,_ZThn20_N9S15653C50D0Ev),
  (VTBL_ENTRY)&_ZN9S15653C343v75Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v76Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v77Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v78Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v79Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v80Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v81Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v82Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v83Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v84Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v85Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v86Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v87Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v88Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v89Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v90Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v91Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v92Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v93Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v94Ev,
};
extern VTBL_ENTRY _ZTI9S15653C50[];
extern  VTBL_ENTRY _ZTV9S15653C50[];
Class_Descriptor cd_S15653C50 = {  "S15653C50", // class name
  bases_S15653C50, 2,
  &(vtc_S15653C50[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(440,316), // object size
  NSPAIRA(_ZTI9S15653C50),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C50),60, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C49  {
  ::S15653C50 s15653c49f0;
  ::S17070C39_nt s15653c49f1;
  void  mf15653c49(); // _ZN9S15653C4910mf15653c49Ev
};
//SIG(-1 S15653C49) C1{ m FC2{ BC3{ vd v27 v28 v29 v30 v31 v32 FC4{ m Fp[4]}} BC5{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC6 FC11{ BC7 FC12{ m FC13{ m Fp[2]} FC14{ m Fp}}} FC15{ BC7 FC9} FC11 FC16{ BC7 Fi}} FC17{ BC18{ BC19{ vd v53} vd v54 Fp[2] FC20{ m FC21{ m Fp Fi[2] FC22{ m}}} FC23{ m Fp[2]}} vd FC24{ m Fp Fi FC25{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC26{ m Fp[2]}}}}


void  S15653C49 ::mf15653c49(){}

static void Test_S15653C49()
{
  {
    init_simple_test("S15653C49");
    static S15653C49 lv;
    check2(sizeof(lv), ABISELECT(544,376), "sizeof(S15653C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C49)");
    check_field_offset(lv, s15653c49f0, 0, "S15653C49.s15653c49f0");
    check_field_offset(lv, s15653c49f1, ABISELECT(440,316), "S15653C49.s15653c49f1");
  }
}
static Arrange_To_Call_Me vS15653C49(Test_S15653C49, "S15653C49", ABISELECT(544,376));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C54  : S15653C4 , S15653C34 {
  ::S17070C19_nt s15653c54f0;
  virtual void  v217(); // _ZN9S15653C544v217Ev
  virtual void  v218(); // _ZN9S15653C544v218Ev
  virtual void  v219(); // _ZN9S15653C544v219Ev
  virtual void  v220(); // _ZN9S15653C544v220Ev
  virtual void  v221(); // _ZN9S15653C544v221Ev
  virtual void  v222(); // _ZN9S15653C544v222Ev
  virtual void  v223(); // _ZN9S15653C544v223Ev
  virtual void  v224(); // _ZN9S15653C544v224Ev
  virtual void  v225(); // _ZN9S15653C544v225Ev
  virtual void  v226(); // _ZN9S15653C544v226Ev
  virtual void  v227(); // _ZN9S15653C544v227Ev
  virtual void  v228(); // _ZN9S15653C544v228Ev
  virtual void  v229(); // _ZN9S15653C544v229Ev
  virtual void  v230(); // _ZN9S15653C544v230Ev
  virtual void  v231(); // _ZN9S15653C544v231Ev
  virtual void  v232(); // _ZN9S15653C544v232Ev
  virtual void  v233(); // _ZN9S15653C544v233Ev
  virtual void  v234(); // _ZN9S15653C544v234Ev
  virtual void  v235(); // _ZN9S15653C544v235Ev
  virtual void  v236(); // _ZN9S15653C544v236Ev
  virtual void  v237(); // _ZN9S15653C544v237Ev
  virtual void  v238(); // _ZN9S15653C544v238Ev
  virtual void  v239(); // _ZN9S15653C544v239Ev
  virtual void  v240(); // _ZN9S15653C544v240Ev
  virtual void  v241(); // _ZN9S15653C544v241Ev
  virtual void  v242(); // _ZN9S15653C544v242Ev
  ~S15653C54(); // tgen
  S15653C54(); // tgen
};
//SIG(-1 S15653C54) C1{ BC2{ vd v27 v28 v29 v30 v31 v32 FC3{ m Fp[4]}} BC4{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}}}


void  S15653C54 ::v217(){vfunc_called(this, "_ZN9S15653C544v217Ev");}
void  S15653C54 ::v218(){vfunc_called(this, "_ZN9S15653C544v218Ev");}
void  S15653C54 ::v219(){vfunc_called(this, "_ZN9S15653C544v219Ev");}
void  S15653C54 ::v220(){vfunc_called(this, "_ZN9S15653C544v220Ev");}
void  S15653C54 ::v221(){vfunc_called(this, "_ZN9S15653C544v221Ev");}
void  S15653C54 ::v222(){vfunc_called(this, "_ZN9S15653C544v222Ev");}
void  S15653C54 ::v223(){vfunc_called(this, "_ZN9S15653C544v223Ev");}
void  S15653C54 ::v224(){vfunc_called(this, "_ZN9S15653C544v224Ev");}
void  S15653C54 ::v225(){vfunc_called(this, "_ZN9S15653C544v225Ev");}
void  S15653C54 ::v226(){vfunc_called(this, "_ZN9S15653C544v226Ev");}
void  S15653C54 ::v227(){vfunc_called(this, "_ZN9S15653C544v227Ev");}
void  S15653C54 ::v228(){vfunc_called(this, "_ZN9S15653C544v228Ev");}
void  S15653C54 ::v229(){vfunc_called(this, "_ZN9S15653C544v229Ev");}
void  S15653C54 ::v230(){vfunc_called(this, "_ZN9S15653C544v230Ev");}
void  S15653C54 ::v231(){vfunc_called(this, "_ZN9S15653C544v231Ev");}
void  S15653C54 ::v232(){vfunc_called(this, "_ZN9S15653C544v232Ev");}
void  S15653C54 ::v233(){vfunc_called(this, "_ZN9S15653C544v233Ev");}
void  S15653C54 ::v234(){vfunc_called(this, "_ZN9S15653C544v234Ev");}
void  S15653C54 ::v235(){vfunc_called(this, "_ZN9S15653C544v235Ev");}
void  S15653C54 ::v236(){vfunc_called(this, "_ZN9S15653C544v236Ev");}
void  S15653C54 ::v237(){vfunc_called(this, "_ZN9S15653C544v237Ev");}
void  S15653C54 ::v238(){vfunc_called(this, "_ZN9S15653C544v238Ev");}
void  S15653C54 ::v239(){vfunc_called(this, "_ZN9S15653C544v239Ev");}
void  S15653C54 ::v240(){vfunc_called(this, "_ZN9S15653C544v240Ev");}
void  S15653C54 ::v241(){vfunc_called(this, "_ZN9S15653C544v241Ev");}
void  S15653C54 ::v242(){vfunc_called(this, "_ZN9S15653C544v242Ev");}
S15653C54 ::~S15653C54(){ note_dtor("S15653C54", this);} // tgen
S15653C54 ::S15653C54(){ note_ctor("S15653C54", this);} // tgen

static void Test_S15653C54()
{
  extern Class_Descriptor cd_S15653C54;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,15)];
    init_test(&cd_S15653C54, buf);
    S15653C54 *dp, &lv = *(dp=new (buf) S15653C54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,56), "sizeof(S15653C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C54)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C54");
    check_base_class_offset(lv, (S15653C34*), ABISELECT(40,20), "S15653C54");
    check_field_offset(lv, s15653c54f0, ABISELECT(48,24), "S15653C54.s15653c54f0");
    test_class_info(&lv, &cd_S15653C54);
    dp->~S15653C54();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C54(Test_S15653C54, "S15653C54", ABISELECT(104,56));

#else // __cplusplus

extern void _ZN9S15653C54C1Ev();
extern void _ZN9S15653C54D1Ev();
Name_Map name_map_S15653C54[] = {
  NSPAIR(_ZN9S15653C54C1Ev),
  NSPAIR(_ZN9S15653C54D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C34;
extern VTBL_ENTRY _ZTI9S15653C34[];
extern  VTBL_ENTRY _ZTV9S15653C34[];
static Base_Class bases_S15653C54[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C34,    ABISELECT(40,20), //bcp->offset
    36, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C54[];
extern void _ZN9S15653C54D1Ev();
extern void _ZN9S15653C54D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C544v217Ev();
extern void _ZN9S15653C544v218Ev();
extern void _ZN9S15653C544v219Ev();
extern void _ZN9S15653C544v220Ev();
extern void _ZN9S15653C544v221Ev();
extern void _ZN9S15653C544v222Ev();
extern void _ZN9S15653C544v223Ev();
extern void _ZN9S15653C544v224Ev();
extern void _ZN9S15653C544v225Ev();
extern void _ZN9S15653C544v226Ev();
extern void _ZN9S15653C544v227Ev();
extern void _ZN9S15653C544v228Ev();
extern void _ZN9S15653C544v229Ev();
extern void _ZN9S15653C544v230Ev();
extern void _ZN9S15653C544v231Ev();
extern void _ZN9S15653C544v232Ev();
extern void _ZN9S15653C544v233Ev();
extern void _ZN9S15653C544v234Ev();
extern void _ZN9S15653C544v235Ev();
extern void _ZN9S15653C544v236Ev();
extern void _ZN9S15653C544v237Ev();
extern void _ZN9S15653C544v238Ev();
extern void _ZN9S15653C544v239Ev();
extern void _ZN9S15653C544v240Ev();
extern void _ZN9S15653C544v241Ev();
extern void _ZN9S15653C544v242Ev();
extern void ABISELECT(_ZThn40_N9S15653C54D1Ev,_ZThn20_N9S15653C54D1Ev)();
extern void ABISELECT(_ZThn40_N9S15653C54D0Ev,_ZThn20_N9S15653C54D0Ev)();
extern void _ZN9S15653C343v75Ev();
extern void _ZN9S15653C343v76Ev();
extern void _ZN9S15653C343v77Ev();
extern void _ZN9S15653C343v78Ev();
extern void _ZN9S15653C343v79Ev();
extern void _ZN9S15653C343v80Ev();
extern void _ZN9S15653C343v81Ev();
extern void _ZN9S15653C343v82Ev();
extern void _ZN9S15653C343v83Ev();
extern void _ZN9S15653C343v84Ev();
extern void _ZN9S15653C343v85Ev();
extern void _ZN9S15653C343v86Ev();
extern void _ZN9S15653C343v87Ev();
extern void _ZN9S15653C343v88Ev();
extern void _ZN9S15653C343v89Ev();
extern void _ZN9S15653C343v90Ev();
extern void _ZN9S15653C343v91Ev();
extern void _ZN9S15653C343v92Ev();
extern void _ZN9S15653C343v93Ev();
extern void _ZN9S15653C343v94Ev();
static  VTBL_ENTRY vtc_S15653C54[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C54[0]),
  (VTBL_ENTRY)&_ZN9S15653C54D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C54D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v217Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v218Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v219Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v220Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v221Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v222Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v223Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v224Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v225Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v226Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v227Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v228Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v229Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v230Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v231Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v232Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v233Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v234Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v235Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v236Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v237Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v238Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v239Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v240Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v241Ev,
  (VTBL_ENTRY)&_ZN9S15653C544v242Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S15653C54[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C54D1Ev,_ZThn20_N9S15653C54D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C54D0Ev,_ZThn20_N9S15653C54D0Ev),
  (VTBL_ENTRY)&_ZN9S15653C343v75Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v76Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v77Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v78Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v79Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v80Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v81Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v82Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v83Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v84Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v85Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v86Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v87Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v88Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v89Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v90Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v91Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v92Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v93Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v94Ev,
};
extern VTBL_ENTRY _ZTI9S15653C54[];
extern  VTBL_ENTRY _ZTV9S15653C54[];
Class_Descriptor cd_S15653C54 = {  "S15653C54", // class name
  bases_S15653C54, 2,
  &(vtc_S15653C54[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,56), // object size
  NSPAIRA(_ZTI9S15653C54),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C54),60, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C53  {
  ::S15653C54 s15653c53f0;
  ::S17070C39_nt s15653c53f1;
  void  mf15653c53(); // _ZN9S15653C5310mf15653c53Ev
};
//SIG(-1 S15653C53) C1{ m FC2{ BC3{ vd v27 v28 v29 v30 v31 v32 FC4{ m Fp[4]}} BC5{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}}} FC11{ BC12{ BC13{ vd v53} vd v54 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC17{ m Fp[2]}} vd FC18{ m Fp Fi FC19{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20{ m Fp[2]}}}}


void  S15653C53 ::mf15653c53(){}

static void Test_S15653C53()
{
  {
    init_simple_test("S15653C53");
    static S15653C53 lv;
    check2(sizeof(lv), ABISELECT(208,116), "sizeof(S15653C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C53)");
    check_field_offset(lv, s15653c53f0, 0, "S15653C53.s15653c53f0");
    check_field_offset(lv, s15653c53f1, ABISELECT(104,56), "S15653C53.s15653c53f1");
  }
}
static Arrange_To_Call_Me vS15653C53(Test_S15653C53, "S15653C53", ABISELECT(208,116));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C58  : S15653C4 , S15653C34 {
  ::S17070C14_nt s15653c58f0;
  ::S17070C14_nt s15653c58f1;
  ::S17070C19_nt s15653c58f2;
  ::S17070C25_nt s15653c58f3;
  virtual void  v266(); // _ZN9S15653C584v266Ev
  virtual void  v267(); // _ZN9S15653C584v267Ev
  virtual void  v268(); // _ZN9S15653C584v268Ev
  virtual void  v269(); // _ZN9S15653C584v269Ev
  virtual void  v270(); // _ZN9S15653C584v270Ev
  virtual void  v271(); // _ZN9S15653C584v271Ev
  virtual void  v272(); // _ZN9S15653C584v272Ev
  virtual void  v273(); // _ZN9S15653C584v273Ev
  virtual void  v274(); // _ZN9S15653C584v274Ev
  virtual void  v275(); // _ZN9S15653C584v275Ev
  virtual void  v276(); // _ZN9S15653C584v276Ev
  virtual void  v277(); // _ZN9S15653C584v277Ev
  virtual void  v278(); // _ZN9S15653C584v278Ev
  virtual void  v279(); // _ZN9S15653C584v279Ev
  virtual void  v280(); // _ZN9S15653C584v280Ev
  virtual void  v281(); // _ZN9S15653C584v281Ev
  virtual void  v282(); // _ZN9S15653C584v282Ev
  virtual void  v283(); // _ZN9S15653C584v283Ev
  virtual void  v284(); // _ZN9S15653C584v284Ev
  virtual void  v285(); // _ZN9S15653C584v285Ev
  virtual void  v286(); // _ZN9S15653C584v286Ev
  virtual void  v287(); // _ZN9S15653C584v287Ev
  virtual void  v288(); // _ZN9S15653C584v288Ev
  virtual void  v289(); // _ZN9S15653C584v289Ev
  virtual void  v290(); // _ZN9S15653C584v290Ev
  virtual void  v291(); // _ZN9S15653C584v291Ev
  ~S15653C58(); // tgen
  S15653C58(); // tgen
};
//SIG(-1 S15653C58) C1{ BC2{ vd v27 v28 v29 v30 v31 v32 FC3{ m Fp[4]}} BC4{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC5 FC10{ BC6 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}} FC14{ BC6 Fi}}


void  S15653C58 ::v266(){vfunc_called(this, "_ZN9S15653C584v266Ev");}
void  S15653C58 ::v267(){vfunc_called(this, "_ZN9S15653C584v267Ev");}
void  S15653C58 ::v268(){vfunc_called(this, "_ZN9S15653C584v268Ev");}
void  S15653C58 ::v269(){vfunc_called(this, "_ZN9S15653C584v269Ev");}
void  S15653C58 ::v270(){vfunc_called(this, "_ZN9S15653C584v270Ev");}
void  S15653C58 ::v271(){vfunc_called(this, "_ZN9S15653C584v271Ev");}
void  S15653C58 ::v272(){vfunc_called(this, "_ZN9S15653C584v272Ev");}
void  S15653C58 ::v273(){vfunc_called(this, "_ZN9S15653C584v273Ev");}
void  S15653C58 ::v274(){vfunc_called(this, "_ZN9S15653C584v274Ev");}
void  S15653C58 ::v275(){vfunc_called(this, "_ZN9S15653C584v275Ev");}
void  S15653C58 ::v276(){vfunc_called(this, "_ZN9S15653C584v276Ev");}
void  S15653C58 ::v277(){vfunc_called(this, "_ZN9S15653C584v277Ev");}
void  S15653C58 ::v278(){vfunc_called(this, "_ZN9S15653C584v278Ev");}
void  S15653C58 ::v279(){vfunc_called(this, "_ZN9S15653C584v279Ev");}
void  S15653C58 ::v280(){vfunc_called(this, "_ZN9S15653C584v280Ev");}
void  S15653C58 ::v281(){vfunc_called(this, "_ZN9S15653C584v281Ev");}
void  S15653C58 ::v282(){vfunc_called(this, "_ZN9S15653C584v282Ev");}
void  S15653C58 ::v283(){vfunc_called(this, "_ZN9S15653C584v283Ev");}
void  S15653C58 ::v284(){vfunc_called(this, "_ZN9S15653C584v284Ev");}
void  S15653C58 ::v285(){vfunc_called(this, "_ZN9S15653C584v285Ev");}
void  S15653C58 ::v286(){vfunc_called(this, "_ZN9S15653C584v286Ev");}
void  S15653C58 ::v287(){vfunc_called(this, "_ZN9S15653C584v287Ev");}
void  S15653C58 ::v288(){vfunc_called(this, "_ZN9S15653C584v288Ev");}
void  S15653C58 ::v289(){vfunc_called(this, "_ZN9S15653C584v289Ev");}
void  S15653C58 ::v290(){vfunc_called(this, "_ZN9S15653C584v290Ev");}
void  S15653C58 ::v291(){vfunc_called(this, "_ZN9S15653C584v291Ev");}
S15653C58 ::~S15653C58(){ note_dtor("S15653C58", this);} // tgen
S15653C58 ::S15653C58(){ note_ctor("S15653C58", this);} // tgen

static void Test_S15653C58()
{
  extern Class_Descriptor cd_S15653C58;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,63)];
    init_test(&cd_S15653C58, buf);
    S15653C58 *dp, &lv = *(dp=new (buf) S15653C58());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,248), "sizeof(S15653C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C58)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C58");
    check_base_class_offset(lv, (S15653C34*), ABISELECT(40,20), "S15653C58");
    check_field_offset(lv, s15653c58f0, ABISELECT(48,24), "S15653C58.s15653c58f0");
    check_field_offset(lv, s15653c58f1, ABISELECT(144,108), "S15653C58.s15653c58f1");
    check_field_offset(lv, s15653c58f2, ABISELECT(240,192), "S15653C58.s15653c58f2");
    check_field_offset(lv, s15653c58f3, ABISELECT(296,224), "S15653C58.s15653c58f3");
    test_class_info(&lv, &cd_S15653C58);
    dp->~S15653C58();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C58(Test_S15653C58, "S15653C58", ABISELECT(336,248));

#else // __cplusplus

extern void _ZN9S15653C58C1Ev();
extern void _ZN9S15653C58D1Ev();
Name_Map name_map_S15653C58[] = {
  NSPAIR(_ZN9S15653C58C1Ev),
  NSPAIR(_ZN9S15653C58D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S15653C34;
extern VTBL_ENTRY _ZTI9S15653C34[];
extern  VTBL_ENTRY _ZTV9S15653C34[];
static Base_Class bases_S15653C58[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15653C34,    ABISELECT(40,20), //bcp->offset
    36, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C58[];
extern void _ZN9S15653C58D1Ev();
extern void _ZN9S15653C58D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C584v266Ev();
extern void _ZN9S15653C584v267Ev();
extern void _ZN9S15653C584v268Ev();
extern void _ZN9S15653C584v269Ev();
extern void _ZN9S15653C584v270Ev();
extern void _ZN9S15653C584v271Ev();
extern void _ZN9S15653C584v272Ev();
extern void _ZN9S15653C584v273Ev();
extern void _ZN9S15653C584v274Ev();
extern void _ZN9S15653C584v275Ev();
extern void _ZN9S15653C584v276Ev();
extern void _ZN9S15653C584v277Ev();
extern void _ZN9S15653C584v278Ev();
extern void _ZN9S15653C584v279Ev();
extern void _ZN9S15653C584v280Ev();
extern void _ZN9S15653C584v281Ev();
extern void _ZN9S15653C584v282Ev();
extern void _ZN9S15653C584v283Ev();
extern void _ZN9S15653C584v284Ev();
extern void _ZN9S15653C584v285Ev();
extern void _ZN9S15653C584v286Ev();
extern void _ZN9S15653C584v287Ev();
extern void _ZN9S15653C584v288Ev();
extern void _ZN9S15653C584v289Ev();
extern void _ZN9S15653C584v290Ev();
extern void _ZN9S15653C584v291Ev();
extern void ABISELECT(_ZThn40_N9S15653C58D1Ev,_ZThn20_N9S15653C58D1Ev)();
extern void ABISELECT(_ZThn40_N9S15653C58D0Ev,_ZThn20_N9S15653C58D0Ev)();
extern void _ZN9S15653C343v75Ev();
extern void _ZN9S15653C343v76Ev();
extern void _ZN9S15653C343v77Ev();
extern void _ZN9S15653C343v78Ev();
extern void _ZN9S15653C343v79Ev();
extern void _ZN9S15653C343v80Ev();
extern void _ZN9S15653C343v81Ev();
extern void _ZN9S15653C343v82Ev();
extern void _ZN9S15653C343v83Ev();
extern void _ZN9S15653C343v84Ev();
extern void _ZN9S15653C343v85Ev();
extern void _ZN9S15653C343v86Ev();
extern void _ZN9S15653C343v87Ev();
extern void _ZN9S15653C343v88Ev();
extern void _ZN9S15653C343v89Ev();
extern void _ZN9S15653C343v90Ev();
extern void _ZN9S15653C343v91Ev();
extern void _ZN9S15653C343v92Ev();
extern void _ZN9S15653C343v93Ev();
extern void _ZN9S15653C343v94Ev();
static  VTBL_ENTRY vtc_S15653C58[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C58[0]),
  (VTBL_ENTRY)&_ZN9S15653C58D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C58D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v266Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v267Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v268Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v269Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v270Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v271Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v272Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v273Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v274Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v275Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v276Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v277Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v278Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v279Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v280Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v281Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v282Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v283Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v284Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v285Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v286Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v287Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v288Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v289Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v290Ev,
  (VTBL_ENTRY)&_ZN9S15653C584v291Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S15653C58[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C58D1Ev,_ZThn20_N9S15653C58D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S15653C58D0Ev,_ZThn20_N9S15653C58D0Ev),
  (VTBL_ENTRY)&_ZN9S15653C343v75Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v76Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v77Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v78Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v79Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v80Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v81Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v82Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v83Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v84Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v85Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v86Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v87Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v88Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v89Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v90Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v91Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v92Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v93Ev,
  (VTBL_ENTRY)&_ZN9S15653C343v94Ev,
};
extern VTBL_ENTRY _ZTI9S15653C58[];
extern  VTBL_ENTRY _ZTV9S15653C58[];
Class_Descriptor cd_S15653C58 = {  "S15653C58", // class name
  bases_S15653C58, 2,
  &(vtc_S15653C58[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,248), // object size
  NSPAIRA(_ZTI9S15653C58),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C58),60, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C57  {
  ::S15653C58 s15653c57f0;
  ::S17070C39_nt s15653c57f1;
  void  mf15653c57(); // _ZN9S15653C5710mf15653c57Ev
};
//SIG(-1 S15653C57) C1{ m FC2{ BC3{ vd v27 v28 v29 v30 v31 v32 FC4{ m Fp[4]}} BC5{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC6 FC11{ BC7 FC12{ m FC13{ m Fp[2]} FC14{ m Fp}}} FC15{ BC7 Fi}} FC16{ BC17{ BC18{ vd v53} vd v54 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m Fp Fi FC24{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC25{ m Fp[2]}}}}


void  S15653C57 ::mf15653c57(){}

static void Test_S15653C57()
{
  {
    init_simple_test("S15653C57");
    static S15653C57 lv;
    check2(sizeof(lv), ABISELECT(440,308), "sizeof(S15653C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C57)");
    check_field_offset(lv, s15653c57f0, 0, "S15653C57.s15653c57f0");
    check_field_offset(lv, s15653c57f1, ABISELECT(336,248), "S15653C57.s15653c57f1");
  }
}
static Arrange_To_Call_Me vS15653C57(Test_S15653C57, "S15653C57", ABISELECT(440,308));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C59  {
  ::S17070C63 s15653c59f0;
  ::S17070C63 s15653c59f1;
  void  mf15653c59(); // _ZN9S15653C5910mf15653c59Ev
};
//SIG(-1 S15653C59) C1{ m FC2{ m FC3{ m Fp[2]} FC4{ m Fp[2]}} FC2}


void  S15653C59 ::mf15653c59(){}

static void Test_S15653C59()
{
  {
    init_simple_test("S15653C59");
    S15653C59 lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(S15653C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C59)");
    check_field_offset(lv, s15653c59f0, 0, "S15653C59.s15653c59f0");
    check_field_offset(lv, s15653c59f1, ABISELECT(32,16), "S15653C59.s15653c59f1");
  }
}
static Arrange_To_Call_Me vS15653C59(Test_S15653C59, "S15653C59", ABISELECT(64,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C63  {
  int s15653c63f0[3];
  ::S17070C63 s15653c63f1;
  int s15653c63f2[3];
  char s15653c63f3;
  void *s15653c63f4;
  ::S17070C74_nt s15653c63f5;
  char s15653c63f6;
  ::S17070C61 s15653c63f7;
  void  mf15653c63(); // _ZN9S15653C6310mf15653c63Ev
};
//SIG(-1 S15653C63) C1{ m Fi[3] FC2{ m FC3{ m Fp[2]} FC4{ m Fp[2]}} Fi[3] Fc Fp FC5{ m Fp Fi FC6{ m}} Fc FC7{ m FC3 Fi}}


void  S15653C63 ::mf15653c63(){}

static void Test_S15653C63()
{
  {
    init_simple_test("S15653C63");
    S15653C63 lv;
    check2(sizeof(lv), ABISELECT(120,76), "sizeof(S15653C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C63)");
    check_field_offset(lv, s15653c63f0, 0, "S15653C63.s15653c63f0");
    check_field_offset(lv, s15653c63f1, ABISELECT(16,12), "S15653C63.s15653c63f1");
    check_field_offset(lv, s15653c63f2, ABISELECT(48,28), "S15653C63.s15653c63f2");
    check_field_offset(lv, s15653c63f3, ABISELECT(60,40), "S15653C63.s15653c63f3");
    check_field_offset(lv, s15653c63f4, ABISELECT(64,44), "S15653C63.s15653c63f4");
    check_field_offset(lv, s15653c63f5, ABISELECT(72,48), "S15653C63.s15653c63f5");
    check_field_offset(lv, s15653c63f6, ABISELECT(88,60), "S15653C63.s15653c63f6");
    check_field_offset(lv, s15653c63f7, ABISELECT(96,64), "S15653C63.s15653c63f7");
  }
}
static Arrange_To_Call_Me vS15653C63(Test_S15653C63, "S15653C63", ABISELECT(120,76));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C69  : S15653C4 , S17070C13_nt {
  ::S17070C14_nt s15653c69f0;
  ::S17070C51_nt s15653c69f1;
  virtual void  v292(); // _ZN9S15653C694v292Ev
  virtual void  v293(); // _ZN9S15653C694v293Ev
  virtual void  v294(); // _ZN9S15653C694v294Ev
  virtual void  v295(); // _ZN9S15653C694v295Ev
  virtual void  v296(); // _ZN9S15653C694v296Ev
  virtual void  v297(); // _ZN9S15653C694v297Ev
  ~S15653C69(); // tgen
  S15653C69(); // tgen
};
//SIG(-1 S15653C69) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC8}}


void  S15653C69 ::v292(){vfunc_called(this, "_ZN9S15653C694v292Ev");}
void  S15653C69 ::v293(){vfunc_called(this, "_ZN9S15653C694v293Ev");}
void  S15653C69 ::v294(){vfunc_called(this, "_ZN9S15653C694v294Ev");}
void  S15653C69 ::v295(){vfunc_called(this, "_ZN9S15653C694v295Ev");}
void  S15653C69 ::v296(){vfunc_called(this, "_ZN9S15653C694v296Ev");}
void  S15653C69 ::v297(){vfunc_called(this, "_ZN9S15653C694v297Ev");}
S15653C69 ::~S15653C69(){ note_dtor("S15653C69", this);} // tgen
S15653C69 ::S15653C69(){ note_ctor("S15653C69", this);} // tgen

static void Test_S15653C69()
{
  extern Class_Descriptor cd_S15653C69;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,36)];
    init_test(&cd_S15653C69, buf);
    S15653C69 *dp, &lv = *(dp=new (buf) S15653C69());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,140), "sizeof(S15653C69)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C69)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C69");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S15653C69");
    check_field_offset(lv, s15653c69f0, ABISELECT(40,20), "S15653C69.s15653c69f0");
    check_field_offset(lv, s15653c69f1, ABISELECT(136,104), "S15653C69.s15653c69f1");
    test_class_info(&lv, &cd_S15653C69);
    dp->~S15653C69();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C69(Test_S15653C69, "S15653C69", ABISELECT(184,140));

#else // __cplusplus

extern void _ZN9S15653C69C1Ev();
extern void _ZN9S15653C69D1Ev();
Name_Map name_map_S15653C69[] = {
  NSPAIR(_ZN9S15653C69C1Ev),
  NSPAIR(_ZN9S15653C69D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S15653C69[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C69[];
extern void _ZN9S15653C69D1Ev();
extern void _ZN9S15653C69D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C694v292Ev();
extern void _ZN9S15653C694v293Ev();
extern void _ZN9S15653C694v294Ev();
extern void _ZN9S15653C694v295Ev();
extern void _ZN9S15653C694v296Ev();
extern void _ZN9S15653C694v297Ev();
static  VTBL_ENTRY vtc_S15653C69[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C69[0]),
  (VTBL_ENTRY)&_ZN9S15653C69D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C69D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C694v292Ev,
  (VTBL_ENTRY)&_ZN9S15653C694v293Ev,
  (VTBL_ENTRY)&_ZN9S15653C694v294Ev,
  (VTBL_ENTRY)&_ZN9S15653C694v295Ev,
  (VTBL_ENTRY)&_ZN9S15653C694v296Ev,
  (VTBL_ENTRY)&_ZN9S15653C694v297Ev,
};
extern VTBL_ENTRY _ZTI9S15653C69[];
extern  VTBL_ENTRY _ZTV9S15653C69[];
Class_Descriptor cd_S15653C69 = {  "S15653C69", // class name
  bases_S15653C69, 2,
  &(vtc_S15653C69[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,140), // object size
  NSPAIRA(_ZTI9S15653C69),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C69),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C68  {
  ::S15653C69 s15653c68f0;
  ::S17070C26_nt s15653c68f1;
  void  mf15653c68(); // _ZN9S15653C6810mf15653c68Ev
};
//SIG(-1 S15653C68) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC9}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC18}}}


void  S15653C68 ::mf15653c68(){}

static void Test_S15653C68()
{
  {
    init_simple_test("S15653C68");
    S15653C68 lv;
    check2(sizeof(lv), ABISELECT(384,304), "sizeof(S15653C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C68)");
    check_field_offset(lv, s15653c68f0, 0, "S15653C68.s15653c68f0");
    check_field_offset(lv, s15653c68f1, ABISELECT(184,140), "S15653C68.s15653c68f1");
  }
}
static Arrange_To_Call_Me vS15653C68(Test_S15653C68, "S15653C68", ABISELECT(384,304));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C74  : S15653C4 , S17070C13_nt {
  ::S17070C19_nt s15653c74f0;
  ::S17070C51_nt s15653c74f1;
  ::S17070C25_nt s15653c74f2;
  ::S17070C51_nt s15653c74f3;
  virtual void  v304(); // _ZN9S15653C744v304Ev
  virtual void  v305(); // _ZN9S15653C744v305Ev
  virtual void  v306(); // _ZN9S15653C744v306Ev
  virtual void  v307(); // _ZN9S15653C744v307Ev
  virtual void  v308(); // _ZN9S15653C744v308Ev
  virtual void  v309(); // _ZN9S15653C744v309Ev
  ~S15653C74(); // tgen
  S15653C74(); // tgen
};
//SIG(-1 S15653C74) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL[2]}}} FC13{ BC6 Fi} FC10}


void  S15653C74 ::v304(){vfunc_called(this, "_ZN9S15653C744v304Ev");}
void  S15653C74 ::v305(){vfunc_called(this, "_ZN9S15653C744v305Ev");}
void  S15653C74 ::v306(){vfunc_called(this, "_ZN9S15653C744v306Ev");}
void  S15653C74 ::v307(){vfunc_called(this, "_ZN9S15653C744v307Ev");}
void  S15653C74 ::v308(){vfunc_called(this, "_ZN9S15653C744v308Ev");}
void  S15653C74 ::v309(){vfunc_called(this, "_ZN9S15653C744v309Ev");}
S15653C74 ::~S15653C74(){ note_dtor("S15653C74", this);} // tgen
S15653C74 ::S15653C74(){ note_ctor("S15653C74", this);} // tgen

static void Test_S15653C74()
{
  extern Class_Descriptor cd_S15653C74;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,38)];
    init_test(&cd_S15653C74, buf);
    S15653C74 *dp, &lv = *(dp=new (buf) S15653C74());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,148), "sizeof(S15653C74)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C74)");
    check_base_class_offset(lv, (S15653C4*), 0, "S15653C74");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S15653C74");
    check_field_offset(lv, s15653c74f0, ABISELECT(40,20), "S15653C74.s15653c74f0");
    check_field_offset(lv, s15653c74f1, ABISELECT(96,52), "S15653C74.s15653c74f1");
    check_field_offset(lv, s15653c74f2, ABISELECT(144,88), "S15653C74.s15653c74f2");
    check_field_offset(lv, s15653c74f3, ABISELECT(184,112), "S15653C74.s15653c74f3");
    test_class_info(&lv, &cd_S15653C74);
    dp->~S15653C74();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15653C74(Test_S15653C74, "S15653C74", ABISELECT(232,148));

#else // __cplusplus

extern void _ZN9S15653C74C1Ev();
extern void _ZN9S15653C74D1Ev();
Name_Map name_map_S15653C74[] = {
  NSPAIR(_ZN9S15653C74C1Ev),
  NSPAIR(_ZN9S15653C74D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15653C4;
extern VTBL_ENTRY _ZTI8S15653C4[];
extern  VTBL_ENTRY _ZTV8S15653C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S15653C74[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15653C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15653C74[];
extern void _ZN9S15653C74D1Ev();
extern void _ZN9S15653C74D0Ev();
extern void _ZN8S15653C43v24Ev();
extern void _ZN8S15653C43v25Ev();
extern void _ZN8S15653C43v26Ev();
extern void _ZN8S15653C43v27Ev();
extern void _ZN8S15653C43v28Ev();
extern void _ZN8S15653C43v29Ev();
extern void _ZN9S15653C744v304Ev();
extern void _ZN9S15653C744v305Ev();
extern void _ZN9S15653C744v306Ev();
extern void _ZN9S15653C744v307Ev();
extern void _ZN9S15653C744v308Ev();
extern void _ZN9S15653C744v309Ev();
static  VTBL_ENTRY vtc_S15653C74[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15653C74[0]),
  (VTBL_ENTRY)&_ZN9S15653C74D1Ev,
  (VTBL_ENTRY)&_ZN9S15653C74D0Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v24Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v25Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v26Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v27Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v28Ev,
  (VTBL_ENTRY)&_ZN8S15653C43v29Ev,
  (VTBL_ENTRY)&_ZN9S15653C744v304Ev,
  (VTBL_ENTRY)&_ZN9S15653C744v305Ev,
  (VTBL_ENTRY)&_ZN9S15653C744v306Ev,
  (VTBL_ENTRY)&_ZN9S15653C744v307Ev,
  (VTBL_ENTRY)&_ZN9S15653C744v308Ev,
  (VTBL_ENTRY)&_ZN9S15653C744v309Ev,
};
extern VTBL_ENTRY _ZTI9S15653C74[];
extern  VTBL_ENTRY _ZTV9S15653C74[];
Class_Descriptor cd_S15653C74 = {  "S15653C74", // class name
  bases_S15653C74, 2,
  &(vtc_S15653C74[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,148), // object size
  NSPAIRA(_ZTI9S15653C74),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15653C74),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C73  {
  ::S15653C74 s15653c73f0;
  ::S17070C39_nt s15653c73f1;
  void  mf15653c73(); // _ZN9S15653C7310mf15653c73Ev
};
//SIG(-1 S15653C73) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}} FC14{ BC7 Fi} FC11} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m Fp Fi FC23{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24{ m Fp[2]}}}}


void  S15653C73 ::mf15653c73(){}

static void Test_S15653C73()
{
  {
    init_simple_test("S15653C73");
    static S15653C73 lv;
    check2(sizeof(lv), ABISELECT(336,208), "sizeof(S15653C73)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C73)");
    check_field_offset(lv, s15653c73f0, 0, "S15653C73.s15653c73f0");
    check_field_offset(lv, s15653c73f1, ABISELECT(232,148), "S15653C73.s15653c73f1");
  }
}
static Arrange_To_Call_Me vS15653C73(Test_S15653C73, "S15653C73", ABISELECT(336,208));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15653C1  {
  ::S15653C2 s15653c1f0;
  ::S15653C32 s15653c1f1;
  ::S15653C43 s15653c1f2;
  ::S15653C45 s15653c1f3;
  ::S15653C47 s15653c1f4;
  ::S15653C49 s15653c1f5;
  ::S15653C2 s15653c1f6;
  ::S15653C53 s15653c1f7;
  ::S15653C47 s15653c1f8;
  ::S15653C57 s15653c1f9;
  ::S15653C59 s15653c1f10;
  ::S15653C59 s15653c1f11;
  ::S15653C63 s15653c1f12;
  ::S15653C68 s15653c1f13;
  ::S17070C37 s15653c1f14;
  ::S15653C73 s15653c1f15;
  void  mf15653c1(); // _ZN8S15653C19mf15653c1Ev
};
//SIG(1 S15653C1) C1{ m FC2{ m FC3{ BC4{ vd v24 v25 v26 v27 v28 v29 FC5{ m Fp[4]}} BC6{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC14{ m FL}}} FC15{ BC8 FC10} FC15 FC15 FC15 FC16{ BC8 Fi} FC15 FC15 FC15 FC17{ BC8 FC18{ m FC19{ m Fp[2]} FC20{ m Fp}}} FC12} FC21{ BC22{ BC23{ vd v47} vd v48 Fp[2] FC24{ m FC25{ m Fp Fi[2] FC26{ m}}} FC27{ m Fp[2]}} vd FC28{ m FC29{ Fs[2] Fc[2] Fs}[12] Fi FC30{ Fs[2]}[4] Fi FC27}}} FC31{ m FC32{ BC4 BC33{ vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94} v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 FC17 FC15 FC17 FC12} FC34{ BC35{ BC23 vd v95 Fp[2] FC24 FC36{ m Fp[2]}} vd FC37{ m Fp Fi FC38{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC27}}} FC39{ m FC40{ BC4 BC6 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 FC7 FC12 FC15 FC15 FC15 FC15 FC16 FC15 FC15 FC15} FC21} FC41{ m FC42{ BC4 BC33 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 FC15 FC17 FC16 FC15 FC15 FC17 FC12} FC34} FC43{ m FC44{ BC4 BC6 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 FC7 FC7 FC12 FC15 FC15 FC15 FC15 FC16 FC15 FC7 FC7 FC7 FC15 FC15} FC21} FC45{ m FC46{ BC4 BC33 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 FC7 FC7 FC17 FC15 FC17 FC16} FC34} FC2 FC47{ m FC48{ BC4 BC33 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 FC17} FC34} FC43 FC49{ m FC50{ BC4 BC33 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 FC7 FC7 FC17 FC16} FC34} FC51{ m FC52{ m FC53{ m Fp[2]} FC54{ m Fp[2]}} FC52} FC51 FC55{ m Fi[3] FC52 Fi[3] Fc Fp FC56{ m Fp Fi FC26} Fc FC57{ m FC53 Fi}} FC58{ m FC59{ BC4 BC60{} v246 v247 v248 v249 v250 v251 FC7 FC15} FC21} FC61{ m FC62{ BC63{ vd v258 v259 v260 v261 v262 v263 FC5} BC60 v252 v253 v254 v255 v256 v257 FC17} FC34} FC64{ m FC65{ BC4 BC60 v264 v265 v266 v267 v268 v269 FC17 FC15 FC16 FC15} FC34}}


void  S15653C1 ::mf15653c1(){}

static void Test_S15653C1()
{
  {
    init_simple_test("S15653C1");
    static S15653C1 lv;
    check2(sizeof(lv), ABISELECT(7960,5756), "sizeof(S15653C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15653C1)");
    check_field_offset(lv, s15653c1f0, 0, "S15653C1.s15653c1f0");
    check_field_offset(lv, s15653c1f1, ABISELECT(856,636), "S15653C1.s15653c1f1");
    check_field_offset(lv, s15653c1f2, ABISELECT(1208,848), "S15653C1.s15653c1f2");
    check_field_offset(lv, s15653c1f3, ABISELECT(1968,1424), "S15653C1.s15653c1f3");
    check_field_offset(lv, s15653c1f4, ABISELECT(2456,1732), "S15653C1.s15653c1f4");
    check_field_offset(lv, s15653c1f5, ABISELECT(3600,2644), "S15653C1.s15653c1f5");
    check_field_offset(lv, s15653c1f6, ABISELECT(4144,3020), "S15653C1.s15653c1f6");
    check_field_offset(lv, s15653c1f7, ABISELECT(5000,3656), "S15653C1.s15653c1f7");
    check_field_offset(lv, s15653c1f8, ABISELECT(5208,3772), "S15653C1.s15653c1f8");
    check_field_offset(lv, s15653c1f9, ABISELECT(6352,4684), "S15653C1.s15653c1f9");
    check_field_offset(lv, s15653c1f10, ABISELECT(6792,4992), "S15653C1.s15653c1f10");
    check_field_offset(lv, s15653c1f11, ABISELECT(6856,5024), "S15653C1.s15653c1f11");
    check_field_offset(lv, s15653c1f12, ABISELECT(6920,5056), "S15653C1.s15653c1f12");
    check_field_offset(lv, s15653c1f13, ABISELECT(7040,5132), "S15653C1.s15653c1f13");
    check_field_offset(lv, s15653c1f14, ABISELECT(7424,5436), "S15653C1.s15653c1f14");
    check_field_offset(lv, s15653c1f15, ABISELECT(7624,5548), "S15653C1.s15653c1f15");
  }
}
static Arrange_To_Call_Me vS15653C1(Test_S15653C1, "S15653C1", ABISELECT(7960,5756));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C4  {
  ::S17070C12_nt s11971c4f0;
  virtual  ~S11971C4(); // _ZN8S11971C4D1Ev
  virtual void  v7(); // _ZN8S11971C42v7Ev
  virtual void  v8(); // _ZN8S11971C42v8Ev
  virtual void  v9(); // _ZN8S11971C42v9Ev
  virtual void  v10(); // _ZN8S11971C43v10Ev
  virtual void  v11(); // _ZN8S11971C43v11Ev
  virtual void  v12(); // _ZN8S11971C43v12Ev
  S11971C4(); // tgen
};
//SIG(-1 S11971C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S11971C4 ::~S11971C4(){ note_dtor("S11971C4", this);}
void  S11971C4 ::v7(){vfunc_called(this, "_ZN8S11971C42v7Ev");}
void  S11971C4 ::v8(){vfunc_called(this, "_ZN8S11971C42v8Ev");}
void  S11971C4 ::v9(){vfunc_called(this, "_ZN8S11971C42v9Ev");}
void  S11971C4 ::v10(){vfunc_called(this, "_ZN8S11971C43v10Ev");}
void  S11971C4 ::v11(){vfunc_called(this, "_ZN8S11971C43v11Ev");}
void  S11971C4 ::v12(){vfunc_called(this, "_ZN8S11971C43v12Ev");}
S11971C4 ::S11971C4(){ note_ctor("S11971C4", this);} // tgen

static void Test_S11971C4()
{
  extern Class_Descriptor cd_S11971C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S11971C4, buf);
    S11971C4 *dp, &lv = *(dp=new (buf) S11971C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S11971C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C4)");
    check_field_offset(lv, s11971c4f0, ABISELECT(8,4), "S11971C4.s11971c4f0");
    test_class_info(&lv, &cd_S11971C4);
    dp->~S11971C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C4(Test_S11971C4, "S11971C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S11971C4C1Ev();
extern void _ZN8S11971C4D1Ev();
Name_Map name_map_S11971C4[] = {
  NSPAIR(_ZN8S11971C4C1Ev),
  NSPAIR(_ZN8S11971C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S11971C4[];
extern void _ZN8S11971C4D1Ev();
extern void _ZN8S11971C4D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
static  VTBL_ENTRY vtc_S11971C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S11971C4[0]),
  (VTBL_ENTRY)&_ZN8S11971C4D1Ev,
  (VTBL_ENTRY)&_ZN8S11971C4D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
Class_Descriptor cd_S11971C4 = {  "S11971C4", // class name
  0,0,//no base classes
  &(vtc_S11971C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S11971C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S11971C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C3  : S11971C4 , S17070C13_nt {
  ::S17070C51_nt s11971c3f0;
  virtual void  v1(); // _ZN8S11971C32v1Ev
  virtual void  v2(); // _ZN8S11971C32v2Ev
  virtual void  v3(); // _ZN8S11971C32v3Ev
  virtual void  v4(); // _ZN8S11971C32v4Ev
  virtual void  v5(); // _ZN8S11971C32v5Ev
  virtual void  v6(); // _ZN8S11971C32v6Ev
  ~S11971C3(); // tgen
  S11971C3(); // tgen
};
//SIG(-1 S11971C3) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FL[2]}}}}


void  S11971C3 ::v1(){vfunc_called(this, "_ZN8S11971C32v1Ev");}
void  S11971C3 ::v2(){vfunc_called(this, "_ZN8S11971C32v2Ev");}
void  S11971C3 ::v3(){vfunc_called(this, "_ZN8S11971C32v3Ev");}
void  S11971C3 ::v4(){vfunc_called(this, "_ZN8S11971C32v4Ev");}
void  S11971C3 ::v5(){vfunc_called(this, "_ZN8S11971C32v5Ev");}
void  S11971C3 ::v6(){vfunc_called(this, "_ZN8S11971C32v6Ev");}
S11971C3 ::~S11971C3(){ note_dtor("S11971C3", this);} // tgen
S11971C3 ::S11971C3(){ note_ctor("S11971C3", this);} // tgen

static void Test_S11971C3()
{
  extern Class_Descriptor cd_S11971C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,15)];
    init_test(&cd_S11971C3, buf);
    S11971C3 *dp, &lv = *(dp=new (buf) S11971C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,56), "sizeof(S11971C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C3)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C3");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S11971C3");
    check_field_offset(lv, s11971c3f0, ABISELECT(40,20), "S11971C3.s11971c3f0");
    test_class_info(&lv, &cd_S11971C3);
    dp->~S11971C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C3(Test_S11971C3, "S11971C3", ABISELECT(88,56));

#else // __cplusplus

extern void _ZN8S11971C3C1Ev();
extern void _ZN8S11971C3D1Ev();
Name_Map name_map_S11971C3[] = {
  NSPAIR(_ZN8S11971C3C1Ev),
  NSPAIR(_ZN8S11971C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S11971C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S11971C3[];
extern void _ZN8S11971C3D1Ev();
extern void _ZN8S11971C3D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN8S11971C32v1Ev();
extern void _ZN8S11971C32v2Ev();
extern void _ZN8S11971C32v3Ev();
extern void _ZN8S11971C32v4Ev();
extern void _ZN8S11971C32v5Ev();
extern void _ZN8S11971C32v6Ev();
static  VTBL_ENTRY vtc_S11971C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S11971C3[0]),
  (VTBL_ENTRY)&_ZN8S11971C3D1Ev,
  (VTBL_ENTRY)&_ZN8S11971C3D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN8S11971C32v1Ev,
  (VTBL_ENTRY)&_ZN8S11971C32v2Ev,
  (VTBL_ENTRY)&_ZN8S11971C32v3Ev,
  (VTBL_ENTRY)&_ZN8S11971C32v4Ev,
  (VTBL_ENTRY)&_ZN8S11971C32v5Ev,
  (VTBL_ENTRY)&_ZN8S11971C32v6Ev,
};
extern VTBL_ENTRY _ZTI8S11971C3[];
extern  VTBL_ENTRY _ZTV8S11971C3[];
Class_Descriptor cd_S11971C3 = {  "S11971C3", // class name
  bases_S11971C3, 2,
  &(vtc_S11971C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,56), // object size
  NSPAIRA(_ZTI8S11971C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S11971C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C2  {
  ::S11971C3 s11971c2f0;
  ::S17070C39_nt s11971c2f1;
  void  mf11971c2(); // _ZN8S11971C29mf11971c2Ev
};
//SIG(-1 S11971C2) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FL[2]}}}} FC10{ BC11{ BC12{ vd v13} vd v14 Fp[2] FC13{ m FC14{ m Fp Fi[2] FC15{ m}}} FC16{ m Fp[2]}} vd FC17{ m Fp Fi FC18{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC19{ m Fp[2]}}}}


void  S11971C2 ::mf11971c2(){}

static void Test_S11971C2()
{
  {
    init_simple_test("S11971C2");
    static S11971C2 lv;
    check2(sizeof(lv), ABISELECT(192,116), "sizeof(S11971C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C2)");
    check_field_offset(lv, s11971c2f0, 0, "S11971C2.s11971c2f0");
    check_field_offset(lv, s11971c2f1, ABISELECT(88,56), "S11971C2.s11971c2f1");
  }
}
static Arrange_To_Call_Me vS11971C2(Test_S11971C2, "S11971C2", ABISELECT(192,116));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C22  : S11971C4 , S17070C13_nt {
  ::S17070C19_nt s11971c22f0;
  ::S17070C19_nt s11971c22f1;
  ::S17070C51_nt s11971c22f2;
  virtual void  v15(); // _ZN9S11971C223v15Ev
  virtual void  v16(); // _ZN9S11971C223v16Ev
  virtual void  v17(); // _ZN9S11971C223v17Ev
  virtual void  v18(); // _ZN9S11971C223v18Ev
  virtual void  v19(); // _ZN9S11971C223v19Ev
  virtual void  v20(); // _ZN9S11971C223v20Ev
  ~S11971C22(); // tgen
  S11971C22(); // tgen
};
//SIG(-1 S11971C22) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC5 FC10{ BC6 FC11{ m FC12{ m FL[2]}}}}


void  S11971C22 ::v15(){vfunc_called(this, "_ZN9S11971C223v15Ev");}
void  S11971C22 ::v16(){vfunc_called(this, "_ZN9S11971C223v16Ev");}
void  S11971C22 ::v17(){vfunc_called(this, "_ZN9S11971C223v17Ev");}
void  S11971C22 ::v18(){vfunc_called(this, "_ZN9S11971C223v18Ev");}
void  S11971C22 ::v19(){vfunc_called(this, "_ZN9S11971C223v19Ev");}
void  S11971C22 ::v20(){vfunc_called(this, "_ZN9S11971C223v20Ev");}
S11971C22 ::~S11971C22(){ note_dtor("S11971C22", this);} // tgen
S11971C22 ::S11971C22(){ note_ctor("S11971C22", this);} // tgen

static void Test_S11971C22()
{
  extern Class_Descriptor cd_S11971C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,31)];
    init_test(&cd_S11971C22, buf);
    S11971C22 *dp, &lv = *(dp=new (buf) S11971C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,120), "sizeof(S11971C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C22)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C22");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S11971C22");
    check_field_offset(lv, s11971c22f0, ABISELECT(40,20), "S11971C22.s11971c22f0");
    check_field_offset(lv, s11971c22f1, ABISELECT(96,52), "S11971C22.s11971c22f1");
    check_field_offset(lv, s11971c22f2, ABISELECT(152,84), "S11971C22.s11971c22f2");
    test_class_info(&lv, &cd_S11971C22);
    dp->~S11971C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C22(Test_S11971C22, "S11971C22", ABISELECT(200,120));

#else // __cplusplus

extern void _ZN9S11971C22C1Ev();
extern void _ZN9S11971C22D1Ev();
Name_Map name_map_S11971C22[] = {
  NSPAIR(_ZN9S11971C22C1Ev),
  NSPAIR(_ZN9S11971C22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S11971C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C22[];
extern void _ZN9S11971C22D1Ev();
extern void _ZN9S11971C22D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C223v15Ev();
extern void _ZN9S11971C223v16Ev();
extern void _ZN9S11971C223v17Ev();
extern void _ZN9S11971C223v18Ev();
extern void _ZN9S11971C223v19Ev();
extern void _ZN9S11971C223v20Ev();
static  VTBL_ENTRY vtc_S11971C22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C22[0]),
  (VTBL_ENTRY)&_ZN9S11971C22D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C22D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C223v15Ev,
  (VTBL_ENTRY)&_ZN9S11971C223v16Ev,
  (VTBL_ENTRY)&_ZN9S11971C223v17Ev,
  (VTBL_ENTRY)&_ZN9S11971C223v18Ev,
  (VTBL_ENTRY)&_ZN9S11971C223v19Ev,
  (VTBL_ENTRY)&_ZN9S11971C223v20Ev,
};
extern VTBL_ENTRY _ZTI9S11971C22[];
extern  VTBL_ENTRY _ZTV9S11971C22[];
Class_Descriptor cd_S11971C22 = {  "S11971C22", // class name
  bases_S11971C22, 2,
  &(vtc_S11971C22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,120), // object size
  NSPAIRA(_ZTI9S11971C22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C22),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C21  {
  ::S11971C22 s11971c21f0;
  ::S17070C39_nt s11971c21f1;
  void  mf11971c21(); // _ZN9S11971C2110mf11971c21Ev
};
//SIG(-1 S11971C21) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC6 FC11{ BC7 FC12{ m FC13{ m FL[2]}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C21 ::mf11971c21(){}

static void Test_S11971C21()
{
  {
    init_simple_test("S11971C21");
    static S11971C21 lv;
    check2(sizeof(lv), ABISELECT(304,180), "sizeof(S11971C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C21)");
    check_field_offset(lv, s11971c21f0, 0, "S11971C21.s11971c21f0");
    check_field_offset(lv, s11971c21f1, ABISELECT(200,120), "S11971C21.s11971c21f1");
  }
}
static Arrange_To_Call_Me vS11971C21(Test_S11971C21, "S11971C21", ABISELECT(304,180));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C28  : S11971C4 , S17070C13_nt {
  ::S17070C19_nt s11971c28f0;
  ::S17070C51_nt s11971c28f1;
  virtual void  v21(); // _ZN9S11971C283v21Ev
  virtual void  v22(); // _ZN9S11971C283v22Ev
  virtual void  v23(); // _ZN9S11971C283v23Ev
  virtual void  v24(); // _ZN9S11971C283v24Ev
  virtual void  v25(); // _ZN9S11971C283v25Ev
  virtual void  v26(); // _ZN9S11971C283v26Ev
  ~S11971C28(); // tgen
  S11971C28(); // tgen
};
//SIG(-1 S11971C28) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL[2]}}}}


void  S11971C28 ::v21(){vfunc_called(this, "_ZN9S11971C283v21Ev");}
void  S11971C28 ::v22(){vfunc_called(this, "_ZN9S11971C283v22Ev");}
void  S11971C28 ::v23(){vfunc_called(this, "_ZN9S11971C283v23Ev");}
void  S11971C28 ::v24(){vfunc_called(this, "_ZN9S11971C283v24Ev");}
void  S11971C28 ::v25(){vfunc_called(this, "_ZN9S11971C283v25Ev");}
void  S11971C28 ::v26(){vfunc_called(this, "_ZN9S11971C283v26Ev");}
S11971C28 ::~S11971C28(){ note_dtor("S11971C28", this);} // tgen
S11971C28 ::S11971C28(){ note_ctor("S11971C28", this);} // tgen

static void Test_S11971C28()
{
  extern Class_Descriptor cd_S11971C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S11971C28, buf);
    S11971C28 *dp, &lv = *(dp=new (buf) S11971C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S11971C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C28)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C28");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S11971C28");
    check_field_offset(lv, s11971c28f0, ABISELECT(40,20), "S11971C28.s11971c28f0");
    check_field_offset(lv, s11971c28f1, ABISELECT(96,52), "S11971C28.s11971c28f1");
    test_class_info(&lv, &cd_S11971C28);
    dp->~S11971C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C28(Test_S11971C28, "S11971C28", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN9S11971C28C1Ev();
extern void _ZN9S11971C28D1Ev();
Name_Map name_map_S11971C28[] = {
  NSPAIR(_ZN9S11971C28C1Ev),
  NSPAIR(_ZN9S11971C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S11971C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C28[];
extern void _ZN9S11971C28D1Ev();
extern void _ZN9S11971C28D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C283v21Ev();
extern void _ZN9S11971C283v22Ev();
extern void _ZN9S11971C283v23Ev();
extern void _ZN9S11971C283v24Ev();
extern void _ZN9S11971C283v25Ev();
extern void _ZN9S11971C283v26Ev();
static  VTBL_ENTRY vtc_S11971C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C28[0]),
  (VTBL_ENTRY)&_ZN9S11971C28D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C28D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C283v21Ev,
  (VTBL_ENTRY)&_ZN9S11971C283v22Ev,
  (VTBL_ENTRY)&_ZN9S11971C283v23Ev,
  (VTBL_ENTRY)&_ZN9S11971C283v24Ev,
  (VTBL_ENTRY)&_ZN9S11971C283v25Ev,
  (VTBL_ENTRY)&_ZN9S11971C283v26Ev,
};
extern VTBL_ENTRY _ZTI9S11971C28[];
extern  VTBL_ENTRY _ZTV9S11971C28[];
Class_Descriptor cd_S11971C28 = {  "S11971C28", // class name
  bases_S11971C28, 2,
  &(vtc_S11971C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI9S11971C28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C28),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C27  {
  ::S11971C28 s11971c27f0;
  ::S17070C39_nt s11971c27f1;
  void  mf11971c27(); // _ZN9S11971C2710mf11971c27Ev
};
//SIG(-1 S11971C27) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C27 ::mf11971c27(){}

static void Test_S11971C27()
{
  {
    init_simple_test("S11971C27");
    static S11971C27 lv;
    check2(sizeof(lv), ABISELECT(248,148), "sizeof(S11971C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C27)");
    check_field_offset(lv, s11971c27f0, 0, "S11971C27.s11971c27f0");
    check_field_offset(lv, s11971c27f1, ABISELECT(144,88), "S11971C27.s11971c27f1");
  }
}
static Arrange_To_Call_Me vS11971C27(Test_S11971C27, "S11971C27", ABISELECT(248,148));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C32  : S11971C4 , S17070C13_nt {
  ::S17070C19_nt s11971c32f0;
  ::S17070C25_nt s11971c32f1;
  virtual void  v33(); // _ZN9S11971C323v33Ev
  virtual void  v34(); // _ZN9S11971C323v34Ev
  virtual void  v35(); // _ZN9S11971C323v35Ev
  virtual void  v36(); // _ZN9S11971C323v36Ev
  virtual void  v37(); // _ZN9S11971C323v37Ev
  virtual void  v38(); // _ZN9S11971C323v38Ev
  ~S11971C32(); // tgen
  S11971C32(); // tgen
};
//SIG(-1 S11971C32) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 Fi}}


void  S11971C32 ::v33(){vfunc_called(this, "_ZN9S11971C323v33Ev");}
void  S11971C32 ::v34(){vfunc_called(this, "_ZN9S11971C323v34Ev");}
void  S11971C32 ::v35(){vfunc_called(this, "_ZN9S11971C323v35Ev");}
void  S11971C32 ::v36(){vfunc_called(this, "_ZN9S11971C323v36Ev");}
void  S11971C32 ::v37(){vfunc_called(this, "_ZN9S11971C323v37Ev");}
void  S11971C32 ::v38(){vfunc_called(this, "_ZN9S11971C323v38Ev");}
S11971C32 ::~S11971C32(){ note_dtor("S11971C32", this);} // tgen
S11971C32 ::S11971C32(){ note_ctor("S11971C32", this);} // tgen

static void Test_S11971C32()
{
  extern Class_Descriptor cd_S11971C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,20)];
    init_test(&cd_S11971C32, buf);
    S11971C32 *dp, &lv = *(dp=new (buf) S11971C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,76), "sizeof(S11971C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C32)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C32");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S11971C32");
    check_field_offset(lv, s11971c32f0, ABISELECT(40,20), "S11971C32.s11971c32f0");
    check_field_offset(lv, s11971c32f1, ABISELECT(96,52), "S11971C32.s11971c32f1");
    test_class_info(&lv, &cd_S11971C32);
    dp->~S11971C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C32(Test_S11971C32, "S11971C32", ABISELECT(136,76));

#else // __cplusplus

extern void _ZN9S11971C32C1Ev();
extern void _ZN9S11971C32D1Ev();
Name_Map name_map_S11971C32[] = {
  NSPAIR(_ZN9S11971C32C1Ev),
  NSPAIR(_ZN9S11971C32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S11971C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C32[];
extern void _ZN9S11971C32D1Ev();
extern void _ZN9S11971C32D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C323v33Ev();
extern void _ZN9S11971C323v34Ev();
extern void _ZN9S11971C323v35Ev();
extern void _ZN9S11971C323v36Ev();
extern void _ZN9S11971C323v37Ev();
extern void _ZN9S11971C323v38Ev();
static  VTBL_ENTRY vtc_S11971C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C32[0]),
  (VTBL_ENTRY)&_ZN9S11971C32D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C32D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C323v33Ev,
  (VTBL_ENTRY)&_ZN9S11971C323v34Ev,
  (VTBL_ENTRY)&_ZN9S11971C323v35Ev,
  (VTBL_ENTRY)&_ZN9S11971C323v36Ev,
  (VTBL_ENTRY)&_ZN9S11971C323v37Ev,
  (VTBL_ENTRY)&_ZN9S11971C323v38Ev,
};
extern VTBL_ENTRY _ZTI9S11971C32[];
extern  VTBL_ENTRY _ZTV9S11971C32[];
Class_Descriptor cd_S11971C32 = {  "S11971C32", // class name
  bases_S11971C32, 2,
  &(vtc_S11971C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,76), // object size
  NSPAIRA(_ZTI9S11971C32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C32),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C31  {
  ::S11971C32 s11971c31f0;
  ::S17070C39_nt s11971c31f1;
  void  mf11971c31(); // _ZN9S11971C3110mf11971c31Ev
};
//SIG(-1 S11971C31) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 Fi}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m Fp Fi FC20{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC21{ m Fp[2]}}}}


void  S11971C31 ::mf11971c31(){}

static void Test_S11971C31()
{
  {
    init_simple_test("S11971C31");
    static S11971C31 lv;
    check2(sizeof(lv), ABISELECT(240,136), "sizeof(S11971C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C31)");
    check_field_offset(lv, s11971c31f0, 0, "S11971C31.s11971c31f0");
    check_field_offset(lv, s11971c31f1, ABISELECT(136,76), "S11971C31.s11971c31f1");
  }
}
static Arrange_To_Call_Me vS11971C31(Test_S11971C31, "S11971C31", ABISELECT(240,136));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C34  {
  ::S17070C38 s11971c34f0;
  ::S17070C39_nt s11971c34f1;
  void  mf11971c34(); // _ZN9S11971C3410mf11971c34Ev
};
//SIG(-1 S11971C34) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}}} FC11{ BC12{ BC13{ vd v13} vd v14 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC17{ m Fp[2]}} vd FC18{ m Fp Fi FC19{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20{ m Fp[2]}}}}


void  S11971C34 ::mf11971c34(){}

static void Test_S11971C34()
{
  {
    init_simple_test("S11971C34");
    static S11971C34 lv;
    check2(sizeof(lv), ABISELECT(200,112), "sizeof(S11971C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C34)");
    check_field_offset(lv, s11971c34f0, 0, "S11971C34.s11971c34f0");
    check_field_offset(lv, s11971c34f1, ABISELECT(96,52), "S11971C34.s11971c34f1");
  }
}
static Arrange_To_Call_Me vS11971C34(Test_S11971C34, "S11971C34", ABISELECT(200,112));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C38  {
  ::S11971C28 s11971c38f0;
  ::S17070C39_nt s11971c38f1;
  void  mf11971c38(); // _ZN9S11971C3810mf11971c38Ev
};
//SIG(-1 S11971C38) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C38 ::mf11971c38(){}

static void Test_S11971C38()
{
  {
    init_simple_test("S11971C38");
    static S11971C38 lv;
    check2(sizeof(lv), ABISELECT(248,148), "sizeof(S11971C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C38)");
    check_field_offset(lv, s11971c38f0, 0, "S11971C38.s11971c38f0");
    check_field_offset(lv, s11971c38f1, ABISELECT(144,88), "S11971C38.s11971c38f1");
  }
}
static Arrange_To_Call_Me vS11971C38(Test_S11971C38, "S11971C38", ABISELECT(248,148));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C41  : S11971C4 , S17070C13_nt {
  ::S17070C19_nt s11971c41f0;
  ::S17070C22_nt s11971c41f1;
  ::S17070C22_nt s11971c41f2;
  ::S17070C22_nt s11971c41f3;
  ::S17070C22_nt s11971c41f4;
  ::S17070C19_nt s11971c41f5;
  ::S17070C22_nt s11971c41f6;
  virtual void  v57(); // _ZN9S11971C413v57Ev
  virtual void  v58(); // _ZN9S11971C413v58Ev
  virtual void  v59(); // _ZN9S11971C413v59Ev
  virtual void  v60(); // _ZN9S11971C413v60Ev
  virtual void  v61(); // _ZN9S11971C413v61Ev
  virtual void  v62(); // _ZN9S11971C413v62Ev
  ~S11971C41(); // tgen
  S11971C41(); // tgen
};
//SIG(-1 S11971C41) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC10 FC10 FC10 FC5 FC10}


void  S11971C41 ::v57(){vfunc_called(this, "_ZN9S11971C413v57Ev");}
void  S11971C41 ::v58(){vfunc_called(this, "_ZN9S11971C413v58Ev");}
void  S11971C41 ::v59(){vfunc_called(this, "_ZN9S11971C413v59Ev");}
void  S11971C41 ::v60(){vfunc_called(this, "_ZN9S11971C413v60Ev");}
void  S11971C41 ::v61(){vfunc_called(this, "_ZN9S11971C413v61Ev");}
void  S11971C41 ::v62(){vfunc_called(this, "_ZN9S11971C413v62Ev");}
S11971C41 ::~S11971C41(){ note_dtor("S11971C41", this);} // tgen
S11971C41 ::S11971C41(){ note_ctor("S11971C41", this);} // tgen

static void Test_S11971C41()
{
  extern Class_Descriptor cd_S11971C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,57)];
    init_test(&cd_S11971C41, buf);
    S11971C41 *dp, &lv = *(dp=new (buf) S11971C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,224), "sizeof(S11971C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C41)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C41");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S11971C41");
    check_field_offset(lv, s11971c41f0, ABISELECT(40,20), "S11971C41.s11971c41f0");
    check_field_offset(lv, s11971c41f1, ABISELECT(96,52), "S11971C41.s11971c41f1");
    check_field_offset(lv, s11971c41f2, ABISELECT(136,80), "S11971C41.s11971c41f2");
    check_field_offset(lv, s11971c41f3, ABISELECT(176,108), "S11971C41.s11971c41f3");
    check_field_offset(lv, s11971c41f4, ABISELECT(216,136), "S11971C41.s11971c41f4");
    check_field_offset(lv, s11971c41f5, ABISELECT(256,164), "S11971C41.s11971c41f5");
    check_field_offset(lv, s11971c41f6, ABISELECT(312,196), "S11971C41.s11971c41f6");
    test_class_info(&lv, &cd_S11971C41);
    dp->~S11971C41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C41(Test_S11971C41, "S11971C41", ABISELECT(352,224));

#else // __cplusplus

extern void _ZN9S11971C41C1Ev();
extern void _ZN9S11971C41D1Ev();
Name_Map name_map_S11971C41[] = {
  NSPAIR(_ZN9S11971C41C1Ev),
  NSPAIR(_ZN9S11971C41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S11971C41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C41[];
extern void _ZN9S11971C41D1Ev();
extern void _ZN9S11971C41D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C413v57Ev();
extern void _ZN9S11971C413v58Ev();
extern void _ZN9S11971C413v59Ev();
extern void _ZN9S11971C413v60Ev();
extern void _ZN9S11971C413v61Ev();
extern void _ZN9S11971C413v62Ev();
static  VTBL_ENTRY vtc_S11971C41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C41[0]),
  (VTBL_ENTRY)&_ZN9S11971C41D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C41D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C413v57Ev,
  (VTBL_ENTRY)&_ZN9S11971C413v58Ev,
  (VTBL_ENTRY)&_ZN9S11971C413v59Ev,
  (VTBL_ENTRY)&_ZN9S11971C413v60Ev,
  (VTBL_ENTRY)&_ZN9S11971C413v61Ev,
  (VTBL_ENTRY)&_ZN9S11971C413v62Ev,
};
extern VTBL_ENTRY _ZTI9S11971C41[];
extern  VTBL_ENTRY _ZTV9S11971C41[];
Class_Descriptor cd_S11971C41 = {  "S11971C41", // class name
  bases_S11971C41, 2,
  &(vtc_S11971C41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,224), // object size
  NSPAIRA(_ZTI9S11971C41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C41),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C40  {
  ::S11971C41 s11971c40f0;
  ::S17070C39_nt s11971c40f1;
  void  mf11971c40(); // _ZN9S11971C4010mf11971c40Ev
};
//SIG(-1 S11971C40) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC11 FC11 FC11 FC6 FC11} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C40 ::mf11971c40(){}

static void Test_S11971C40()
{
  {
    init_simple_test("S11971C40");
    static S11971C40 lv;
    check2(sizeof(lv), ABISELECT(456,284), "sizeof(S11971C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C40)");
    check_field_offset(lv, s11971c40f0, 0, "S11971C40.s11971c40f0");
    check_field_offset(lv, s11971c40f1, ABISELECT(352,224), "S11971C40.s11971c40f1");
  }
}
static Arrange_To_Call_Me vS11971C40(Test_S11971C40, "S11971C40", ABISELECT(456,284));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C46  : S11971C4 , S17070C13_nt {
  ::S17070C19_nt s11971c46f0;
  ::S17070C22_nt s11971c46f1;
  ::S17070C22_nt s11971c46f2;
  ::S17070C22_nt s11971c46f3;
  ::S17070C19_nt s11971c46f4;
  ::S17070C22_nt s11971c46f5;
  virtual void  v63(); // _ZN9S11971C463v63Ev
  virtual void  v64(); // _ZN9S11971C463v64Ev
  virtual void  v65(); // _ZN9S11971C463v65Ev
  virtual void  v66(); // _ZN9S11971C463v66Ev
  virtual void  v67(); // _ZN9S11971C463v67Ev
  virtual void  v68(); // _ZN9S11971C463v68Ev
  ~S11971C46(); // tgen
  S11971C46(); // tgen
};
//SIG(-1 S11971C46) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC10 FC10 FC5 FC10}


void  S11971C46 ::v63(){vfunc_called(this, "_ZN9S11971C463v63Ev");}
void  S11971C46 ::v64(){vfunc_called(this, "_ZN9S11971C463v64Ev");}
void  S11971C46 ::v65(){vfunc_called(this, "_ZN9S11971C463v65Ev");}
void  S11971C46 ::v66(){vfunc_called(this, "_ZN9S11971C463v66Ev");}
void  S11971C46 ::v67(){vfunc_called(this, "_ZN9S11971C463v67Ev");}
void  S11971C46 ::v68(){vfunc_called(this, "_ZN9S11971C463v68Ev");}
S11971C46 ::~S11971C46(){ note_dtor("S11971C46", this);} // tgen
S11971C46 ::S11971C46(){ note_ctor("S11971C46", this);} // tgen

static void Test_S11971C46()
{
  extern Class_Descriptor cd_S11971C46;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,50)];
    init_test(&cd_S11971C46, buf);
    S11971C46 *dp, &lv = *(dp=new (buf) S11971C46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,196), "sizeof(S11971C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C46)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C46");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S11971C46");
    check_field_offset(lv, s11971c46f0, ABISELECT(40,20), "S11971C46.s11971c46f0");
    check_field_offset(lv, s11971c46f1, ABISELECT(96,52), "S11971C46.s11971c46f1");
    check_field_offset(lv, s11971c46f2, ABISELECT(136,80), "S11971C46.s11971c46f2");
    check_field_offset(lv, s11971c46f3, ABISELECT(176,108), "S11971C46.s11971c46f3");
    check_field_offset(lv, s11971c46f4, ABISELECT(216,136), "S11971C46.s11971c46f4");
    check_field_offset(lv, s11971c46f5, ABISELECT(272,168), "S11971C46.s11971c46f5");
    test_class_info(&lv, &cd_S11971C46);
    dp->~S11971C46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C46(Test_S11971C46, "S11971C46", ABISELECT(312,196));

#else // __cplusplus

extern void _ZN9S11971C46C1Ev();
extern void _ZN9S11971C46D1Ev();
Name_Map name_map_S11971C46[] = {
  NSPAIR(_ZN9S11971C46C1Ev),
  NSPAIR(_ZN9S11971C46D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S11971C46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C46[];
extern void _ZN9S11971C46D1Ev();
extern void _ZN9S11971C46D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C463v63Ev();
extern void _ZN9S11971C463v64Ev();
extern void _ZN9S11971C463v65Ev();
extern void _ZN9S11971C463v66Ev();
extern void _ZN9S11971C463v67Ev();
extern void _ZN9S11971C463v68Ev();
static  VTBL_ENTRY vtc_S11971C46[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C46[0]),
  (VTBL_ENTRY)&_ZN9S11971C46D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C46D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C463v63Ev,
  (VTBL_ENTRY)&_ZN9S11971C463v64Ev,
  (VTBL_ENTRY)&_ZN9S11971C463v65Ev,
  (VTBL_ENTRY)&_ZN9S11971C463v66Ev,
  (VTBL_ENTRY)&_ZN9S11971C463v67Ev,
  (VTBL_ENTRY)&_ZN9S11971C463v68Ev,
};
extern VTBL_ENTRY _ZTI9S11971C46[];
extern  VTBL_ENTRY _ZTV9S11971C46[];
Class_Descriptor cd_S11971C46 = {  "S11971C46", // class name
  bases_S11971C46, 2,
  &(vtc_S11971C46[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,196), // object size
  NSPAIRA(_ZTI9S11971C46),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C46),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C45  {
  ::S11971C46 s11971c45f0;
  ::S17070C39_nt s11971c45f1;
  void  mf11971c45(); // _ZN9S11971C4510mf11971c45Ev
};
//SIG(-1 S11971C45) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC11 FC11 FC6 FC11} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C45 ::mf11971c45(){}

static void Test_S11971C45()
{
  {
    init_simple_test("S11971C45");
    static S11971C45 lv;
    check2(sizeof(lv), ABISELECT(416,256), "sizeof(S11971C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C45)");
    check_field_offset(lv, s11971c45f0, 0, "S11971C45.s11971c45f0");
    check_field_offset(lv, s11971c45f1, ABISELECT(312,196), "S11971C45.s11971c45f1");
  }
}
static Arrange_To_Call_Me vS11971C45(Test_S11971C45, "S11971C45", ABISELECT(416,256));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C49_nt  {
  virtual  ~S11971C49_nt(); // _ZN12S11971C49_ntD1Ev
  virtual void  v78(); // _ZN12S11971C49_nt3v78Ev
  virtual void  v79(); // _ZN12S11971C49_nt3v79Ev
  virtual void  v80(); // _ZN12S11971C49_nt3v80Ev
  S11971C49_nt(); // tgen
};
//SIG(-1 S11971C49_nt) C1{ vd v1 v2 v3}


 S11971C49_nt ::~S11971C49_nt(){ note_dtor("S11971C49_nt", this);}
void  S11971C49_nt ::v78(){vfunc_called(this, "_ZN12S11971C49_nt3v78Ev");}
void  S11971C49_nt ::v79(){vfunc_called(this, "_ZN12S11971C49_nt3v79Ev");}
void  S11971C49_nt ::v80(){vfunc_called(this, "_ZN12S11971C49_nt3v80Ev");}
S11971C49_nt ::S11971C49_nt(){ note_ctor("S11971C49_nt", this);} // tgen

//skip512 S11971C49_nt

#else // __cplusplus

extern void _ZN12S11971C49_ntC1Ev();
extern void _ZN12S11971C49_ntD1Ev();
Name_Map name_map_S11971C49_nt[] = {
  NSPAIR(_ZN12S11971C49_ntC1Ev),
  NSPAIR(_ZN12S11971C49_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S11971C49_nt[];
extern void _ZN12S11971C49_ntD1Ev();
extern void _ZN12S11971C49_ntD0Ev();
extern void _ZN12S11971C49_nt3v78Ev();
extern void _ZN12S11971C49_nt3v79Ev();
extern void _ZN12S11971C49_nt3v80Ev();
static  VTBL_ENTRY vtc_S11971C49_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S11971C49_nt[0]),
  (VTBL_ENTRY)&_ZN12S11971C49_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v78Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v79Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v80Ev,
};
extern VTBL_ENTRY _ZTI12S11971C49_nt[];
VTBL_ENTRY *P__ZTI12S11971C49_nt = _ZTI12S11971C49_nt; 
extern  VTBL_ENTRY _ZTV12S11971C49_nt[];
Class_Descriptor cd_S11971C49_nt = {  "S11971C49_nt", // class name
  0,0,//no base classes
  &(vtc_S11971C49_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S11971C49_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S11971C49_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C48  : S11971C4 , S11971C49_nt {
  ::S17070C19_nt s11971c48f0;
  ::S17070C22_nt s11971c48f1;
  ::S17070C25_nt s11971c48f2;
  virtual void  v69(); // _ZN9S11971C483v69Ev
  virtual void  v70(); // _ZN9S11971C483v70Ev
  virtual void  v71(); // _ZN9S11971C483v71Ev
  virtual void  v72(); // _ZN9S11971C483v72Ev
  virtual void  v73(); // _ZN9S11971C483v73Ev
  virtual void  v74(); // _ZN9S11971C483v74Ev
  virtual void  v75(); // _ZN9S11971C483v75Ev
  virtual void  v76(); // _ZN9S11971C483v76Ev
  virtual void  v77(); // _ZN9S11971C483v77Ev
  ~S11971C48(); // tgen
  S11971C48(); // tgen
};
//SIG(-1 S11971C48) C1{ BC2{ vd v10 v11 v12 v13 v14 v15 FC3{ m Fp[4]}} BC4{ vd v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC13{ BC6 Fi}}


void  S11971C48 ::v69(){vfunc_called(this, "_ZN9S11971C483v69Ev");}
void  S11971C48 ::v70(){vfunc_called(this, "_ZN9S11971C483v70Ev");}
void  S11971C48 ::v71(){vfunc_called(this, "_ZN9S11971C483v71Ev");}
void  S11971C48 ::v72(){vfunc_called(this, "_ZN9S11971C483v72Ev");}
void  S11971C48 ::v73(){vfunc_called(this, "_ZN9S11971C483v73Ev");}
void  S11971C48 ::v74(){vfunc_called(this, "_ZN9S11971C483v74Ev");}
void  S11971C48 ::v75(){vfunc_called(this, "_ZN9S11971C483v75Ev");}
void  S11971C48 ::v76(){vfunc_called(this, "_ZN9S11971C483v76Ev");}
void  S11971C48 ::v77(){vfunc_called(this, "_ZN9S11971C483v77Ev");}
S11971C48 ::~S11971C48(){ note_dtor("S11971C48", this);} // tgen
S11971C48 ::S11971C48(){ note_ctor("S11971C48", this);} // tgen

static void Test_S11971C48()
{
  extern Class_Descriptor cd_S11971C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,28)];
    init_test(&cd_S11971C48, buf);
    S11971C48 *dp, &lv = *(dp=new (buf) S11971C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,108), "sizeof(S11971C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C48)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C48");
    check_base_class_offset(lv, (S11971C49_nt*), ABISELECT(40,20), "S11971C48");
    check_field_offset(lv, s11971c48f0, ABISELECT(48,24), "S11971C48.s11971c48f0");
    check_field_offset(lv, s11971c48f1, ABISELECT(104,56), "S11971C48.s11971c48f1");
    check_field_offset(lv, s11971c48f2, ABISELECT(144,84), "S11971C48.s11971c48f2");
    test_class_info(&lv, &cd_S11971C48);
    dp->~S11971C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C48(Test_S11971C48, "S11971C48", ABISELECT(184,108));

#else // __cplusplus

extern void _ZN9S11971C48C1Ev();
extern void _ZN9S11971C48D1Ev();
Name_Map name_map_S11971C48[] = {
  NSPAIR(_ZN9S11971C48C1Ev),
  NSPAIR(_ZN9S11971C48D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S11971C49_nt;
extern VTBL_ENTRY _ZTI12S11971C49_nt[];
extern  VTBL_ENTRY _ZTV12S11971C49_nt[];
static Base_Class bases_S11971C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S11971C49_nt,    ABISELECT(40,20), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C48[];
extern void _ZN9S11971C48D1Ev();
extern void _ZN9S11971C48D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C483v69Ev();
extern void _ZN9S11971C483v70Ev();
extern void _ZN9S11971C483v71Ev();
extern void _ZN9S11971C483v72Ev();
extern void _ZN9S11971C483v73Ev();
extern void _ZN9S11971C483v74Ev();
extern void _ZN9S11971C483v75Ev();
extern void _ZN9S11971C483v76Ev();
extern void _ZN9S11971C483v77Ev();
extern void ABISELECT(_ZThn40_N9S11971C48D1Ev,_ZThn20_N9S11971C48D1Ev)();
extern void ABISELECT(_ZThn40_N9S11971C48D0Ev,_ZThn20_N9S11971C48D0Ev)();
extern void _ZN12S11971C49_nt3v78Ev();
extern void _ZN12S11971C49_nt3v79Ev();
extern void _ZN12S11971C49_nt3v80Ev();
static  VTBL_ENTRY vtc_S11971C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C48[0]),
  (VTBL_ENTRY)&_ZN9S11971C48D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C48D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v69Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v70Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v71Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v72Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v73Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v74Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v75Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v76Ev,
  (VTBL_ENTRY)&_ZN9S11971C483v77Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S11971C48[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C48D1Ev,_ZThn20_N9S11971C48D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C48D0Ev,_ZThn20_N9S11971C48D0Ev),
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v78Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v79Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v80Ev,
};
extern VTBL_ENTRY _ZTI9S11971C48[];
extern  VTBL_ENTRY _ZTV9S11971C48[];
Class_Descriptor cd_S11971C48 = {  "S11971C48", // class name
  bases_S11971C48, 2,
  &(vtc_S11971C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,108), // object size
  NSPAIRA(_ZTI9S11971C48),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C48),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C47  {
  ::S11971C48 s11971c47f0;
  ::S17070C39_nt s11971c47f1;
  void  mf11971c47(); // _ZN9S11971C4710mf11971c47Ev
};
//SIG(-1 S11971C47) C1{ m FC2{ BC3{ vd v10 v11 v12 v13 v14 v15 FC4{ m Fp[4]}} BC5{ vd v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC14{ BC7 Fi}} FC15{ BC16{ BC17{ vd v19} vd v20 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m Fp Fi FC23{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24{ m Fp[2]}}}}


void  S11971C47 ::mf11971c47(){}

static void Test_S11971C47()
{
  {
    init_simple_test("S11971C47");
    static S11971C47 lv;
    check2(sizeof(lv), ABISELECT(288,168), "sizeof(S11971C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C47)");
    check_field_offset(lv, s11971c47f0, 0, "S11971C47.s11971c47f0");
    check_field_offset(lv, s11971c47f1, ABISELECT(184,108), "S11971C47.s11971c47f1");
  }
}
static Arrange_To_Call_Me vS11971C47(Test_S11971C47, "S11971C47", ABISELECT(288,168));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C51  : S11971C4 , S11971C49_nt {
  ::S17070C19_nt s11971c51f0;
  ::S17070C22_nt s11971c51f1;
  virtual void  v81(); // _ZN9S11971C513v81Ev
  virtual void  v82(); // _ZN9S11971C513v82Ev
  virtual void  v83(); // _ZN9S11971C513v83Ev
  virtual void  v84(); // _ZN9S11971C513v84Ev
  virtual void  v85(); // _ZN9S11971C513v85Ev
  virtual void  v86(); // _ZN9S11971C513v86Ev
  virtual void  v87(); // _ZN9S11971C513v87Ev
  virtual void  v88(); // _ZN9S11971C513v88Ev
  virtual void  v89(); // _ZN9S11971C513v89Ev
  ~S11971C51(); // tgen
  S11971C51(); // tgen
};
//SIG(-1 S11971C51) C1{ BC2{ vd v10 v11 v12 v13 v14 v15 FC3{ m Fp[4]}} BC4{ vd v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}}}


void  S11971C51 ::v81(){vfunc_called(this, "_ZN9S11971C513v81Ev");}
void  S11971C51 ::v82(){vfunc_called(this, "_ZN9S11971C513v82Ev");}
void  S11971C51 ::v83(){vfunc_called(this, "_ZN9S11971C513v83Ev");}
void  S11971C51 ::v84(){vfunc_called(this, "_ZN9S11971C513v84Ev");}
void  S11971C51 ::v85(){vfunc_called(this, "_ZN9S11971C513v85Ev");}
void  S11971C51 ::v86(){vfunc_called(this, "_ZN9S11971C513v86Ev");}
void  S11971C51 ::v87(){vfunc_called(this, "_ZN9S11971C513v87Ev");}
void  S11971C51 ::v88(){vfunc_called(this, "_ZN9S11971C513v88Ev");}
void  S11971C51 ::v89(){vfunc_called(this, "_ZN9S11971C513v89Ev");}
S11971C51 ::~S11971C51(){ note_dtor("S11971C51", this);} // tgen
S11971C51 ::S11971C51(){ note_ctor("S11971C51", this);} // tgen

static void Test_S11971C51()
{
  extern Class_Descriptor cd_S11971C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,22)];
    init_test(&cd_S11971C51, buf);
    S11971C51 *dp, &lv = *(dp=new (buf) S11971C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,84), "sizeof(S11971C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C51)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C51");
    check_base_class_offset(lv, (S11971C49_nt*), ABISELECT(40,20), "S11971C51");
    check_field_offset(lv, s11971c51f0, ABISELECT(48,24), "S11971C51.s11971c51f0");
    check_field_offset(lv, s11971c51f1, ABISELECT(104,56), "S11971C51.s11971c51f1");
    test_class_info(&lv, &cd_S11971C51);
    dp->~S11971C51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C51(Test_S11971C51, "S11971C51", ABISELECT(144,84));

#else // __cplusplus

extern void _ZN9S11971C51C1Ev();
extern void _ZN9S11971C51D1Ev();
Name_Map name_map_S11971C51[] = {
  NSPAIR(_ZN9S11971C51C1Ev),
  NSPAIR(_ZN9S11971C51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S11971C49_nt;
extern VTBL_ENTRY _ZTI12S11971C49_nt[];
extern  VTBL_ENTRY _ZTV12S11971C49_nt[];
static Base_Class bases_S11971C51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S11971C49_nt,    ABISELECT(40,20), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C51[];
extern void _ZN9S11971C51D1Ev();
extern void _ZN9S11971C51D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C513v81Ev();
extern void _ZN9S11971C513v82Ev();
extern void _ZN9S11971C513v83Ev();
extern void _ZN9S11971C513v84Ev();
extern void _ZN9S11971C513v85Ev();
extern void _ZN9S11971C513v86Ev();
extern void _ZN9S11971C513v87Ev();
extern void _ZN9S11971C513v88Ev();
extern void _ZN9S11971C513v89Ev();
extern void ABISELECT(_ZThn40_N9S11971C51D1Ev,_ZThn20_N9S11971C51D1Ev)();
extern void ABISELECT(_ZThn40_N9S11971C51D0Ev,_ZThn20_N9S11971C51D0Ev)();
extern void _ZN12S11971C49_nt3v78Ev();
extern void _ZN12S11971C49_nt3v79Ev();
extern void _ZN12S11971C49_nt3v80Ev();
static  VTBL_ENTRY vtc_S11971C51[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C51[0]),
  (VTBL_ENTRY)&_ZN9S11971C51D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C51D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v81Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v82Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v83Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v84Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v85Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v86Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v87Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v88Ev,
  (VTBL_ENTRY)&_ZN9S11971C513v89Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S11971C51[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C51D1Ev,_ZThn20_N9S11971C51D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C51D0Ev,_ZThn20_N9S11971C51D0Ev),
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v78Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v79Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v80Ev,
};
extern VTBL_ENTRY _ZTI9S11971C51[];
extern  VTBL_ENTRY _ZTV9S11971C51[];
Class_Descriptor cd_S11971C51 = {  "S11971C51", // class name
  bases_S11971C51, 2,
  &(vtc_S11971C51[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,84), // object size
  NSPAIRA(_ZTI9S11971C51),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C51),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C50  {
  ::S11971C51 s11971c50f0;
  ::S17070C39_nt s11971c50f1;
  void  mf11971c50(); // _ZN9S11971C5010mf11971c50Ev
};
//SIG(-1 S11971C50) C1{ m FC2{ BC3{ vd v10 v11 v12 v13 v14 v15 FC4{ m Fp[4]}} BC5{ vd v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v19} vd v20 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C50 ::mf11971c50(){}

static void Test_S11971C50()
{
  {
    init_simple_test("S11971C50");
    static S11971C50 lv;
    check2(sizeof(lv), ABISELECT(248,144), "sizeof(S11971C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C50)");
    check_field_offset(lv, s11971c50f0, 0, "S11971C50.s11971c50f0");
    check_field_offset(lv, s11971c50f1, ABISELECT(144,84), "S11971C50.s11971c50f1");
  }
}
static Arrange_To_Call_Me vS11971C50(Test_S11971C50, "S11971C50", ABISELECT(248,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C54  {
  ::S11971C51 s11971c54f0;
  ::S17070C39_nt s11971c54f1;
  void  mf11971c54(); // _ZN9S11971C5410mf11971c54Ev
};
//SIG(-1 S11971C54) C1{ m FC2{ BC3{ vd v10 v11 v12 v13 v14 v15 FC4{ m Fp[4]}} BC5{ vd v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v19} vd v20 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C54 ::mf11971c54(){}

static void Test_S11971C54()
{
  {
    init_simple_test("S11971C54");
    static S11971C54 lv;
    check2(sizeof(lv), ABISELECT(248,144), "sizeof(S11971C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C54)");
    check_field_offset(lv, s11971c54f0, 0, "S11971C54.s11971c54f0");
    check_field_offset(lv, s11971c54f1, ABISELECT(144,84), "S11971C54.s11971c54f1");
  }
}
static Arrange_To_Call_Me vS11971C54(Test_S11971C54, "S11971C54", ABISELECT(248,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C59  : S11971C4 , S11971C49_nt {
  ::S17070C19_nt s11971c59f0;
  ::S17070C22_nt s11971c59f1;
  virtual void  v117(); // _ZN9S11971C594v117Ev
  virtual void  v118(); // _ZN9S11971C594v118Ev
  virtual void  v119(); // _ZN9S11971C594v119Ev
  virtual void  v120(); // _ZN9S11971C594v120Ev
  virtual void  v121(); // _ZN9S11971C594v121Ev
  virtual void  v122(); // _ZN9S11971C594v122Ev
  virtual void  v123(); // _ZN9S11971C594v123Ev
  virtual void  v124(); // _ZN9S11971C594v124Ev
  virtual void  v125(); // _ZN9S11971C594v125Ev
  ~S11971C59(); // tgen
  S11971C59(); // tgen
};
//SIG(-1 S11971C59) C1{ BC2{ vd v10 v11 v12 v13 v14 v15 FC3{ m Fp[4]}} BC4{ vd v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}}}


void  S11971C59 ::v117(){vfunc_called(this, "_ZN9S11971C594v117Ev");}
void  S11971C59 ::v118(){vfunc_called(this, "_ZN9S11971C594v118Ev");}
void  S11971C59 ::v119(){vfunc_called(this, "_ZN9S11971C594v119Ev");}
void  S11971C59 ::v120(){vfunc_called(this, "_ZN9S11971C594v120Ev");}
void  S11971C59 ::v121(){vfunc_called(this, "_ZN9S11971C594v121Ev");}
void  S11971C59 ::v122(){vfunc_called(this, "_ZN9S11971C594v122Ev");}
void  S11971C59 ::v123(){vfunc_called(this, "_ZN9S11971C594v123Ev");}
void  S11971C59 ::v124(){vfunc_called(this, "_ZN9S11971C594v124Ev");}
void  S11971C59 ::v125(){vfunc_called(this, "_ZN9S11971C594v125Ev");}
S11971C59 ::~S11971C59(){ note_dtor("S11971C59", this);} // tgen
S11971C59 ::S11971C59(){ note_ctor("S11971C59", this);} // tgen

static void Test_S11971C59()
{
  extern Class_Descriptor cd_S11971C59;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,22)];
    init_test(&cd_S11971C59, buf);
    S11971C59 *dp, &lv = *(dp=new (buf) S11971C59());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,84), "sizeof(S11971C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C59)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C59");
    check_base_class_offset(lv, (S11971C49_nt*), ABISELECT(40,20), "S11971C59");
    check_field_offset(lv, s11971c59f0, ABISELECT(48,24), "S11971C59.s11971c59f0");
    check_field_offset(lv, s11971c59f1, ABISELECT(104,56), "S11971C59.s11971c59f1");
    test_class_info(&lv, &cd_S11971C59);
    dp->~S11971C59();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C59(Test_S11971C59, "S11971C59", ABISELECT(144,84));

#else // __cplusplus

extern void _ZN9S11971C59C1Ev();
extern void _ZN9S11971C59D1Ev();
Name_Map name_map_S11971C59[] = {
  NSPAIR(_ZN9S11971C59C1Ev),
  NSPAIR(_ZN9S11971C59D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S11971C49_nt;
extern VTBL_ENTRY _ZTI12S11971C49_nt[];
extern  VTBL_ENTRY _ZTV12S11971C49_nt[];
static Base_Class bases_S11971C59[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S11971C49_nt,    ABISELECT(40,20), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C59[];
extern void _ZN9S11971C59D1Ev();
extern void _ZN9S11971C59D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C594v117Ev();
extern void _ZN9S11971C594v118Ev();
extern void _ZN9S11971C594v119Ev();
extern void _ZN9S11971C594v120Ev();
extern void _ZN9S11971C594v121Ev();
extern void _ZN9S11971C594v122Ev();
extern void _ZN9S11971C594v123Ev();
extern void _ZN9S11971C594v124Ev();
extern void _ZN9S11971C594v125Ev();
extern void ABISELECT(_ZThn40_N9S11971C59D1Ev,_ZThn20_N9S11971C59D1Ev)();
extern void ABISELECT(_ZThn40_N9S11971C59D0Ev,_ZThn20_N9S11971C59D0Ev)();
extern void _ZN12S11971C49_nt3v78Ev();
extern void _ZN12S11971C49_nt3v79Ev();
extern void _ZN12S11971C49_nt3v80Ev();
static  VTBL_ENTRY vtc_S11971C59[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C59[0]),
  (VTBL_ENTRY)&_ZN9S11971C59D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C59D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v117Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v118Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v119Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v120Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v121Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v122Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v123Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v124Ev,
  (VTBL_ENTRY)&_ZN9S11971C594v125Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S11971C59[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C59D1Ev,_ZThn20_N9S11971C59D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C59D0Ev,_ZThn20_N9S11971C59D0Ev),
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v78Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v79Ev,
  (VTBL_ENTRY)&_ZN12S11971C49_nt3v80Ev,
};
extern VTBL_ENTRY _ZTI9S11971C59[];
extern  VTBL_ENTRY _ZTV9S11971C59[];
Class_Descriptor cd_S11971C59 = {  "S11971C59", // class name
  bases_S11971C59, 2,
  &(vtc_S11971C59[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,84), // object size
  NSPAIRA(_ZTI9S11971C59),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C59),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C58  {
  ::S11971C59 s11971c58f0;
  ::S17070C39_nt s11971c58f1;
  void  mf11971c58(); // _ZN9S11971C5810mf11971c58Ev
};
//SIG(-1 S11971C58) C1{ m FC2{ BC3{ vd v10 v11 v12 v13 v14 v15 FC4{ m Fp[4]}} BC5{ vd v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v19} vd v20 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C58 ::mf11971c58(){}

static void Test_S11971C58()
{
  {
    init_simple_test("S11971C58");
    static S11971C58 lv;
    check2(sizeof(lv), ABISELECT(248,144), "sizeof(S11971C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C58)");
    check_field_offset(lv, s11971c58f0, 0, "S11971C58.s11971c58f0");
    check_field_offset(lv, s11971c58f1, ABISELECT(144,84), "S11971C58.s11971c58f1");
  }
}
static Arrange_To_Call_Me vS11971C58(Test_S11971C58, "S11971C58", ABISELECT(248,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C62_nt  {
  virtual  ~S11971C62_nt(); // _ZN12S11971C62_ntD1Ev
  virtual void  v137(); // _ZN12S11971C62_nt4v137Ev
  virtual void  v138(); // _ZN12S11971C62_nt4v138Ev
  virtual void  v139(); // _ZN12S11971C62_nt4v139Ev
  virtual void  v140(); // _ZN12S11971C62_nt4v140Ev
  virtual void  v141(); // _ZN12S11971C62_nt4v141Ev
  S11971C62_nt(); // tgen
};
//SIG(-1 S11971C62_nt) C1{ vd v1 v2 v3 v4 v5}


 S11971C62_nt ::~S11971C62_nt(){ note_dtor("S11971C62_nt", this);}
void  S11971C62_nt ::v137(){vfunc_called(this, "_ZN12S11971C62_nt4v137Ev");}
void  S11971C62_nt ::v138(){vfunc_called(this, "_ZN12S11971C62_nt4v138Ev");}
void  S11971C62_nt ::v139(){vfunc_called(this, "_ZN12S11971C62_nt4v139Ev");}
void  S11971C62_nt ::v140(){vfunc_called(this, "_ZN12S11971C62_nt4v140Ev");}
void  S11971C62_nt ::v141(){vfunc_called(this, "_ZN12S11971C62_nt4v141Ev");}
S11971C62_nt ::S11971C62_nt(){ note_ctor("S11971C62_nt", this);} // tgen

//skip512 S11971C62_nt

#else // __cplusplus

extern void _ZN12S11971C62_ntC1Ev();
extern void _ZN12S11971C62_ntD1Ev();
Name_Map name_map_S11971C62_nt[] = {
  NSPAIR(_ZN12S11971C62_ntC1Ev),
  NSPAIR(_ZN12S11971C62_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S11971C62_nt[];
extern void _ZN12S11971C62_ntD1Ev();
extern void _ZN12S11971C62_ntD0Ev();
extern void _ZN12S11971C62_nt4v137Ev();
extern void _ZN12S11971C62_nt4v138Ev();
extern void _ZN12S11971C62_nt4v139Ev();
extern void _ZN12S11971C62_nt4v140Ev();
extern void _ZN12S11971C62_nt4v141Ev();
static  VTBL_ENTRY vtc_S11971C62_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S11971C62_nt[0]),
  (VTBL_ENTRY)&_ZN12S11971C62_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v137Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v138Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v139Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v140Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v141Ev,
};
extern VTBL_ENTRY _ZTI12S11971C62_nt[];
VTBL_ENTRY *P__ZTI12S11971C62_nt = _ZTI12S11971C62_nt; 
extern  VTBL_ENTRY _ZTV12S11971C62_nt[];
Class_Descriptor cd_S11971C62_nt = {  "S11971C62_nt", // class name
  0,0,//no base classes
  &(vtc_S11971C62_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S11971C62_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S11971C62_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C61  : S11971C4 , S11971C62_nt {
  ::S17070C19_nt s11971c61f0;
  ::S17070C22_nt s11971c61f1;
  ::S17070C25_nt s11971c61f2;
  virtual void  v126(); // _ZN9S11971C614v126Ev
  virtual void  v127(); // _ZN9S11971C614v127Ev
  virtual void  v128(); // _ZN9S11971C614v128Ev
  virtual void  v129(); // _ZN9S11971C614v129Ev
  virtual void  v130(); // _ZN9S11971C614v130Ev
  virtual void  v131(); // _ZN9S11971C614v131Ev
  virtual void  v132(); // _ZN9S11971C614v132Ev
  virtual void  v133(); // _ZN9S11971C614v133Ev
  virtual void  v134(); // _ZN9S11971C614v134Ev
  virtual void  v135(); // _ZN9S11971C614v135Ev
  virtual void  v136(); // _ZN9S11971C614v136Ev
  ~S11971C61(); // tgen
  S11971C61(); // tgen
};
//SIG(-1 S11971C61) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 FC3{ m Fp[4]}} BC4{ vd v18 v19 v20 v21 v22} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC13{ BC6 Fi}}


void  S11971C61 ::v126(){vfunc_called(this, "_ZN9S11971C614v126Ev");}
void  S11971C61 ::v127(){vfunc_called(this, "_ZN9S11971C614v127Ev");}
void  S11971C61 ::v128(){vfunc_called(this, "_ZN9S11971C614v128Ev");}
void  S11971C61 ::v129(){vfunc_called(this, "_ZN9S11971C614v129Ev");}
void  S11971C61 ::v130(){vfunc_called(this, "_ZN9S11971C614v130Ev");}
void  S11971C61 ::v131(){vfunc_called(this, "_ZN9S11971C614v131Ev");}
void  S11971C61 ::v132(){vfunc_called(this, "_ZN9S11971C614v132Ev");}
void  S11971C61 ::v133(){vfunc_called(this, "_ZN9S11971C614v133Ev");}
void  S11971C61 ::v134(){vfunc_called(this, "_ZN9S11971C614v134Ev");}
void  S11971C61 ::v135(){vfunc_called(this, "_ZN9S11971C614v135Ev");}
void  S11971C61 ::v136(){vfunc_called(this, "_ZN9S11971C614v136Ev");}
S11971C61 ::~S11971C61(){ note_dtor("S11971C61", this);} // tgen
S11971C61 ::S11971C61(){ note_ctor("S11971C61", this);} // tgen

static void Test_S11971C61()
{
  extern Class_Descriptor cd_S11971C61;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,28)];
    init_test(&cd_S11971C61, buf);
    S11971C61 *dp, &lv = *(dp=new (buf) S11971C61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,108), "sizeof(S11971C61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C61)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C61");
    check_base_class_offset(lv, (S11971C62_nt*), ABISELECT(40,20), "S11971C61");
    check_field_offset(lv, s11971c61f0, ABISELECT(48,24), "S11971C61.s11971c61f0");
    check_field_offset(lv, s11971c61f1, ABISELECT(104,56), "S11971C61.s11971c61f1");
    check_field_offset(lv, s11971c61f2, ABISELECT(144,84), "S11971C61.s11971c61f2");
    test_class_info(&lv, &cd_S11971C61);
    dp->~S11971C61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C61(Test_S11971C61, "S11971C61", ABISELECT(184,108));

#else // __cplusplus

extern void _ZN9S11971C61C1Ev();
extern void _ZN9S11971C61D1Ev();
Name_Map name_map_S11971C61[] = {
  NSPAIR(_ZN9S11971C61C1Ev),
  NSPAIR(_ZN9S11971C61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S11971C62_nt;
extern VTBL_ENTRY _ZTI12S11971C62_nt[];
extern  VTBL_ENTRY _ZTV12S11971C62_nt[];
static Base_Class bases_S11971C61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S11971C62_nt,    ABISELECT(40,20), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C61[];
extern void _ZN9S11971C61D1Ev();
extern void _ZN9S11971C61D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C614v126Ev();
extern void _ZN9S11971C614v127Ev();
extern void _ZN9S11971C614v128Ev();
extern void _ZN9S11971C614v129Ev();
extern void _ZN9S11971C614v130Ev();
extern void _ZN9S11971C614v131Ev();
extern void _ZN9S11971C614v132Ev();
extern void _ZN9S11971C614v133Ev();
extern void _ZN9S11971C614v134Ev();
extern void _ZN9S11971C614v135Ev();
extern void _ZN9S11971C614v136Ev();
extern void ABISELECT(_ZThn40_N9S11971C61D1Ev,_ZThn20_N9S11971C61D1Ev)();
extern void ABISELECT(_ZThn40_N9S11971C61D0Ev,_ZThn20_N9S11971C61D0Ev)();
extern void _ZN12S11971C62_nt4v137Ev();
extern void _ZN12S11971C62_nt4v138Ev();
extern void _ZN12S11971C62_nt4v139Ev();
extern void _ZN12S11971C62_nt4v140Ev();
extern void _ZN12S11971C62_nt4v141Ev();
static  VTBL_ENTRY vtc_S11971C61[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C61[0]),
  (VTBL_ENTRY)&_ZN9S11971C61D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C61D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v126Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v127Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v128Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v129Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v130Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v131Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v132Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v133Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v134Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v135Ev,
  (VTBL_ENTRY)&_ZN9S11971C614v136Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S11971C61[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C61D1Ev,_ZThn20_N9S11971C61D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C61D0Ev,_ZThn20_N9S11971C61D0Ev),
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v137Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v138Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v139Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v140Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v141Ev,
};
extern VTBL_ENTRY _ZTI9S11971C61[];
extern  VTBL_ENTRY _ZTV9S11971C61[];
Class_Descriptor cd_S11971C61 = {  "S11971C61", // class name
  bases_S11971C61, 2,
  &(vtc_S11971C61[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,108), // object size
  NSPAIRA(_ZTI9S11971C61),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C61),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C60  {
  ::S11971C61 s11971c60f0;
  ::S17070C39_nt s11971c60f1;
  void  mf11971c60(); // _ZN9S11971C6010mf11971c60Ev
};
//SIG(-1 S11971C60) C1{ m FC2{ BC3{ vd v12 v13 v14 v15 v16 v17 FC4{ m Fp[4]}} BC5{ vd v18 v19 v20 v21 v22} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC14{ BC7 Fi}} FC15{ BC16{ BC17{ vd v23} vd v24 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m Fp Fi FC23{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24{ m Fp[2]}}}}


void  S11971C60 ::mf11971c60(){}

static void Test_S11971C60()
{
  {
    init_simple_test("S11971C60");
    static S11971C60 lv;
    check2(sizeof(lv), ABISELECT(288,168), "sizeof(S11971C60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C60)");
    check_field_offset(lv, s11971c60f0, 0, "S11971C60.s11971c60f0");
    check_field_offset(lv, s11971c60f1, ABISELECT(184,108), "S11971C60.s11971c60f1");
  }
}
static Arrange_To_Call_Me vS11971C60(Test_S11971C60, "S11971C60", ABISELECT(288,168));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C64  : S11971C4 , S11971C62_nt {
  ::S17070C19_nt s11971c64f0;
  ::S17070C22_nt s11971c64f1;
  virtual void  v142(); // _ZN9S11971C644v142Ev
  virtual void  v143(); // _ZN9S11971C644v143Ev
  virtual void  v144(); // _ZN9S11971C644v144Ev
  virtual void  v145(); // _ZN9S11971C644v145Ev
  virtual void  v146(); // _ZN9S11971C644v146Ev
  virtual void  v147(); // _ZN9S11971C644v147Ev
  virtual void  v148(); // _ZN9S11971C644v148Ev
  virtual void  v149(); // _ZN9S11971C644v149Ev
  virtual void  v150(); // _ZN9S11971C644v150Ev
  virtual void  v151(); // _ZN9S11971C644v151Ev
  virtual void  v152(); // _ZN9S11971C644v152Ev
  ~S11971C64(); // tgen
  S11971C64(); // tgen
};
//SIG(-1 S11971C64) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 FC3{ m Fp[4]}} BC4{ vd v18 v19 v20 v21 v22} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}}}


void  S11971C64 ::v142(){vfunc_called(this, "_ZN9S11971C644v142Ev");}
void  S11971C64 ::v143(){vfunc_called(this, "_ZN9S11971C644v143Ev");}
void  S11971C64 ::v144(){vfunc_called(this, "_ZN9S11971C644v144Ev");}
void  S11971C64 ::v145(){vfunc_called(this, "_ZN9S11971C644v145Ev");}
void  S11971C64 ::v146(){vfunc_called(this, "_ZN9S11971C644v146Ev");}
void  S11971C64 ::v147(){vfunc_called(this, "_ZN9S11971C644v147Ev");}
void  S11971C64 ::v148(){vfunc_called(this, "_ZN9S11971C644v148Ev");}
void  S11971C64 ::v149(){vfunc_called(this, "_ZN9S11971C644v149Ev");}
void  S11971C64 ::v150(){vfunc_called(this, "_ZN9S11971C644v150Ev");}
void  S11971C64 ::v151(){vfunc_called(this, "_ZN9S11971C644v151Ev");}
void  S11971C64 ::v152(){vfunc_called(this, "_ZN9S11971C644v152Ev");}
S11971C64 ::~S11971C64(){ note_dtor("S11971C64", this);} // tgen
S11971C64 ::S11971C64(){ note_ctor("S11971C64", this);} // tgen

static void Test_S11971C64()
{
  extern Class_Descriptor cd_S11971C64;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,22)];
    init_test(&cd_S11971C64, buf);
    S11971C64 *dp, &lv = *(dp=new (buf) S11971C64());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,84), "sizeof(S11971C64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C64)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C64");
    check_base_class_offset(lv, (S11971C62_nt*), ABISELECT(40,20), "S11971C64");
    check_field_offset(lv, s11971c64f0, ABISELECT(48,24), "S11971C64.s11971c64f0");
    check_field_offset(lv, s11971c64f1, ABISELECT(104,56), "S11971C64.s11971c64f1");
    test_class_info(&lv, &cd_S11971C64);
    dp->~S11971C64();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C64(Test_S11971C64, "S11971C64", ABISELECT(144,84));

#else // __cplusplus

extern void _ZN9S11971C64C1Ev();
extern void _ZN9S11971C64D1Ev();
Name_Map name_map_S11971C64[] = {
  NSPAIR(_ZN9S11971C64C1Ev),
  NSPAIR(_ZN9S11971C64D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S11971C62_nt;
extern VTBL_ENTRY _ZTI12S11971C62_nt[];
extern  VTBL_ENTRY _ZTV12S11971C62_nt[];
static Base_Class bases_S11971C64[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S11971C62_nt,    ABISELECT(40,20), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C64[];
extern void _ZN9S11971C64D1Ev();
extern void _ZN9S11971C64D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C644v142Ev();
extern void _ZN9S11971C644v143Ev();
extern void _ZN9S11971C644v144Ev();
extern void _ZN9S11971C644v145Ev();
extern void _ZN9S11971C644v146Ev();
extern void _ZN9S11971C644v147Ev();
extern void _ZN9S11971C644v148Ev();
extern void _ZN9S11971C644v149Ev();
extern void _ZN9S11971C644v150Ev();
extern void _ZN9S11971C644v151Ev();
extern void _ZN9S11971C644v152Ev();
extern void ABISELECT(_ZThn40_N9S11971C64D1Ev,_ZThn20_N9S11971C64D1Ev)();
extern void ABISELECT(_ZThn40_N9S11971C64D0Ev,_ZThn20_N9S11971C64D0Ev)();
extern void _ZN12S11971C62_nt4v137Ev();
extern void _ZN12S11971C62_nt4v138Ev();
extern void _ZN12S11971C62_nt4v139Ev();
extern void _ZN12S11971C62_nt4v140Ev();
extern void _ZN12S11971C62_nt4v141Ev();
static  VTBL_ENTRY vtc_S11971C64[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C64[0]),
  (VTBL_ENTRY)&_ZN9S11971C64D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C64D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v142Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v143Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v144Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v145Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v146Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v147Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v148Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v149Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v150Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v151Ev,
  (VTBL_ENTRY)&_ZN9S11971C644v152Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S11971C64[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C64D1Ev,_ZThn20_N9S11971C64D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C64D0Ev,_ZThn20_N9S11971C64D0Ev),
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v137Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v138Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v139Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v140Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v141Ev,
};
extern VTBL_ENTRY _ZTI9S11971C64[];
extern  VTBL_ENTRY _ZTV9S11971C64[];
Class_Descriptor cd_S11971C64 = {  "S11971C64", // class name
  bases_S11971C64, 2,
  &(vtc_S11971C64[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,84), // object size
  NSPAIRA(_ZTI9S11971C64),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C64),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C63  {
  ::S11971C64 s11971c63f0;
  ::S17070C39_nt s11971c63f1;
  void  mf11971c63(); // _ZN9S11971C6310mf11971c63Ev
};
//SIG(-1 S11971C63) C1{ m FC2{ BC3{ vd v12 v13 v14 v15 v16 v17 FC4{ m Fp[4]}} BC5{ vd v18 v19 v20 v21 v22} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v23} vd v24 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C63 ::mf11971c63(){}

static void Test_S11971C63()
{
  {
    init_simple_test("S11971C63");
    static S11971C63 lv;
    check2(sizeof(lv), ABISELECT(248,144), "sizeof(S11971C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C63)");
    check_field_offset(lv, s11971c63f0, 0, "S11971C63.s11971c63f0");
    check_field_offset(lv, s11971c63f1, ABISELECT(144,84), "S11971C63.s11971c63f1");
  }
}
static Arrange_To_Call_Me vS11971C63(Test_S11971C63, "S11971C63", ABISELECT(248,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C67  {
  ::S11971C64 s11971c67f0;
  ::S17070C39_nt s11971c67f1;
  void  mf11971c67(); // _ZN9S11971C6710mf11971c67Ev
};
//SIG(-1 S11971C67) C1{ m FC2{ BC3{ vd v12 v13 v14 v15 v16 v17 FC4{ m Fp[4]}} BC5{ vd v18 v19 v20 v21 v22} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v23} vd v24 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C67 ::mf11971c67(){}

static void Test_S11971C67()
{
  {
    init_simple_test("S11971C67");
    static S11971C67 lv;
    check2(sizeof(lv), ABISELECT(248,144), "sizeof(S11971C67)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C67)");
    check_field_offset(lv, s11971c67f0, 0, "S11971C67.s11971c67f0");
    check_field_offset(lv, s11971c67f1, ABISELECT(144,84), "S11971C67.s11971c67f1");
  }
}
static Arrange_To_Call_Me vS11971C67(Test_S11971C67, "S11971C67", ABISELECT(248,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C72  : S11971C4 , S11971C62_nt {
  ::S17070C19_nt s11971c72f0;
  ::S17070C22_nt s11971c72f1;
  virtual void  v186(); // _ZN9S11971C724v186Ev
  virtual void  v187(); // _ZN9S11971C724v187Ev
  virtual void  v188(); // _ZN9S11971C724v188Ev
  virtual void  v189(); // _ZN9S11971C724v189Ev
  virtual void  v190(); // _ZN9S11971C724v190Ev
  virtual void  v191(); // _ZN9S11971C724v191Ev
  virtual void  v192(); // _ZN9S11971C724v192Ev
  virtual void  v193(); // _ZN9S11971C724v193Ev
  virtual void  v194(); // _ZN9S11971C724v194Ev
  virtual void  v195(); // _ZN9S11971C724v195Ev
  virtual void  v196(); // _ZN9S11971C724v196Ev
  ~S11971C72(); // tgen
  S11971C72(); // tgen
};
//SIG(-1 S11971C72) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 FC3{ m Fp[4]}} BC4{ vd v18 v19 v20 v21 v22} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}}}


void  S11971C72 ::v186(){vfunc_called(this, "_ZN9S11971C724v186Ev");}
void  S11971C72 ::v187(){vfunc_called(this, "_ZN9S11971C724v187Ev");}
void  S11971C72 ::v188(){vfunc_called(this, "_ZN9S11971C724v188Ev");}
void  S11971C72 ::v189(){vfunc_called(this, "_ZN9S11971C724v189Ev");}
void  S11971C72 ::v190(){vfunc_called(this, "_ZN9S11971C724v190Ev");}
void  S11971C72 ::v191(){vfunc_called(this, "_ZN9S11971C724v191Ev");}
void  S11971C72 ::v192(){vfunc_called(this, "_ZN9S11971C724v192Ev");}
void  S11971C72 ::v193(){vfunc_called(this, "_ZN9S11971C724v193Ev");}
void  S11971C72 ::v194(){vfunc_called(this, "_ZN9S11971C724v194Ev");}
void  S11971C72 ::v195(){vfunc_called(this, "_ZN9S11971C724v195Ev");}
void  S11971C72 ::v196(){vfunc_called(this, "_ZN9S11971C724v196Ev");}
S11971C72 ::~S11971C72(){ note_dtor("S11971C72", this);} // tgen
S11971C72 ::S11971C72(){ note_ctor("S11971C72", this);} // tgen

static void Test_S11971C72()
{
  extern Class_Descriptor cd_S11971C72;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,22)];
    init_test(&cd_S11971C72, buf);
    S11971C72 *dp, &lv = *(dp=new (buf) S11971C72());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,84), "sizeof(S11971C72)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C72)");
    check_base_class_offset(lv, (S11971C4*), 0, "S11971C72");
    check_base_class_offset(lv, (S11971C62_nt*), ABISELECT(40,20), "S11971C72");
    check_field_offset(lv, s11971c72f0, ABISELECT(48,24), "S11971C72.s11971c72f0");
    check_field_offset(lv, s11971c72f1, ABISELECT(104,56), "S11971C72.s11971c72f1");
    test_class_info(&lv, &cd_S11971C72);
    dp->~S11971C72();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS11971C72(Test_S11971C72, "S11971C72", ABISELECT(144,84));

#else // __cplusplus

extern void _ZN9S11971C72C1Ev();
extern void _ZN9S11971C72D1Ev();
Name_Map name_map_S11971C72[] = {
  NSPAIR(_ZN9S11971C72C1Ev),
  NSPAIR(_ZN9S11971C72D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S11971C4;
extern VTBL_ENTRY _ZTI8S11971C4[];
extern  VTBL_ENTRY _ZTV8S11971C4[];
extern Class_Descriptor cd_S11971C62_nt;
extern VTBL_ENTRY _ZTI12S11971C62_nt[];
extern  VTBL_ENTRY _ZTV12S11971C62_nt[];
static Base_Class bases_S11971C72[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S11971C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S11971C62_nt,    ABISELECT(40,20), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S11971C72[];
extern void _ZN9S11971C72D1Ev();
extern void _ZN9S11971C72D0Ev();
extern void _ZN8S11971C42v7Ev();
extern void _ZN8S11971C42v8Ev();
extern void _ZN8S11971C42v9Ev();
extern void _ZN8S11971C43v10Ev();
extern void _ZN8S11971C43v11Ev();
extern void _ZN8S11971C43v12Ev();
extern void _ZN9S11971C724v186Ev();
extern void _ZN9S11971C724v187Ev();
extern void _ZN9S11971C724v188Ev();
extern void _ZN9S11971C724v189Ev();
extern void _ZN9S11971C724v190Ev();
extern void _ZN9S11971C724v191Ev();
extern void _ZN9S11971C724v192Ev();
extern void _ZN9S11971C724v193Ev();
extern void _ZN9S11971C724v194Ev();
extern void _ZN9S11971C724v195Ev();
extern void _ZN9S11971C724v196Ev();
extern void ABISELECT(_ZThn40_N9S11971C72D1Ev,_ZThn20_N9S11971C72D1Ev)();
extern void ABISELECT(_ZThn40_N9S11971C72D0Ev,_ZThn20_N9S11971C72D0Ev)();
extern void _ZN12S11971C62_nt4v137Ev();
extern void _ZN12S11971C62_nt4v138Ev();
extern void _ZN12S11971C62_nt4v139Ev();
extern void _ZN12S11971C62_nt4v140Ev();
extern void _ZN12S11971C62_nt4v141Ev();
static  VTBL_ENTRY vtc_S11971C72[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S11971C72[0]),
  (VTBL_ENTRY)&_ZN9S11971C72D1Ev,
  (VTBL_ENTRY)&_ZN9S11971C72D0Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v7Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v8Ev,
  (VTBL_ENTRY)&_ZN8S11971C42v9Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v10Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v11Ev,
  (VTBL_ENTRY)&_ZN8S11971C43v12Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v186Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v187Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v188Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v189Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v190Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v191Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v192Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v193Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v194Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v195Ev,
  (VTBL_ENTRY)&_ZN9S11971C724v196Ev,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S11971C72[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C72D1Ev,_ZThn20_N9S11971C72D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S11971C72D0Ev,_ZThn20_N9S11971C72D0Ev),
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v137Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v138Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v139Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v140Ev,
  (VTBL_ENTRY)&_ZN12S11971C62_nt4v141Ev,
};
extern VTBL_ENTRY _ZTI9S11971C72[];
extern  VTBL_ENTRY _ZTV9S11971C72[];
Class_Descriptor cd_S11971C72 = {  "S11971C72", // class name
  bases_S11971C72, 2,
  &(vtc_S11971C72[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,84), // object size
  NSPAIRA(_ZTI9S11971C72),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S11971C72),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C71  {
  ::S11971C72 s11971c71f0;
  ::S17070C39_nt s11971c71f1;
  void  mf11971c71(); // _ZN9S11971C7110mf11971c71Ev
};
//SIG(-1 S11971C71) C1{ m FC2{ BC3{ vd v12 v13 v14 v15 v16 v17 FC4{ m Fp[4]}} BC5{ vd v18 v19 v20 v21 v22} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v23} vd v24 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23{ m Fp[2]}}}}


void  S11971C71 ::mf11971c71(){}

static void Test_S11971C71()
{
  {
    init_simple_test("S11971C71");
    static S11971C71 lv;
    check2(sizeof(lv), ABISELECT(248,144), "sizeof(S11971C71)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C71)");
    check_field_offset(lv, s11971c71f0, 0, "S11971C71.s11971c71f0");
    check_field_offset(lv, s11971c71f1, ABISELECT(144,84), "S11971C71.s11971c71f1");
  }
}
static Arrange_To_Call_Me vS11971C71(Test_S11971C71, "S11971C71", ABISELECT(248,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11971C1  {
  ::S11971C2 s11971c1f0;
  ::S11971C21 s11971c1f1;
  ::S11971C27 s11971c1f2;
  ::S17070C37 s11971c1f3;
  ::S11971C31 s11971c1f4;
  ::S11971C34 s11971c1f5;
  ::S11971C27 s11971c1f6;
  ::S11971C38 s11971c1f7;
  ::S11971C40 s11971c1f8;
  ::S11971C45 s11971c1f9;
  ::S11971C47 s11971c1f10;
  ::S11971C50 s11971c1f11;
  ::S11971C50 s11971c1f12;
  ::S11971C54 s11971c1f13;
  ::S11971C54 s11971c1f14;
  ::S11971C58 s11971c1f15;
  ::S11971C60 s11971c1f16;
  ::S11971C63 s11971c1f17;
  ::S11971C63 s11971c1f18;
  ::S11971C67 s11971c1f19;
  ::S11971C67 s11971c1f20;
  ::S11971C71 s11971c1f21;
};
//SIG(1 S11971C1) C1{ FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FL[2]}}}} FC11{ BC12{ BC13{ vd v13} vd v14 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC17{ m Fp[2]}} vd FC18{ m Fp Fi FC19{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20{ m Fp[2]}}}} FC21{ m FC22{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC23{ BC8 FC24{ m FC25{ m Fp[2]} FC26{ m Fp}}} FC23 FC7} FC11} FC27{ m FC28{ BC4 BC6 v21 v22 v23 v24 v25 v26 FC23 FC7} FC11} FC29{ m FC30{ BC31{ vd v33 v34 v35 v36 v37 v38 FC5} BC6 v27 v28 v29 v30 v31 v32 FC23} FC11} FC32{ m FC33{ BC4 BC6 v39 v40 v41 v42 v43 v44 FC23 FC34{ BC8 Fi}} FC11} FC35{ m FC30 FC11} FC27 FC36{ m FC28 FC11} FC37{ m FC38{ BC4 BC6 v45 v46 v47 v48 v49 v50 FC23 FC39{ BC8 FC40{ m FC41{ m FL}}} FC39 FC39 FC39 FC23 FC39} FC11} FC42{ m FC43{ BC4 BC6 v51 v52 v53 v54 v55 v56 FC23 FC39 FC39 FC39 FC23 FC39} FC11} FC44{ m FC45{ BC4 BC46{ vd v66 v67 v68} v57 v58 v59 v60 v61 v62 v63 v64 v65 FC23 FC39 FC34} FC11} FC47{ m FC48{ BC4 BC46 v69 v70 v71 v72 v73 v74 v75 v76 v77 FC23 FC39} FC11} FC47 FC49{ m FC48 FC11} FC49 FC50{ m FC51{ BC4 BC46 v78 v79 v80 v81 v82 v83 v84 v85 v86 FC23 FC39} FC11} FC52{ m FC53{ BC4 BC54{ vd v98 v99 v100 v101 v102} v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 FC23 FC39 FC34} FC11} FC55{ m FC56{ BC4 BC54 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 FC23 FC39} FC11} FC55 FC57{ m FC56 FC11} FC57 FC58{ m FC59{ BC4 BC54 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 FC23 FC39} FC11}}



static void Test_S11971C1()
{
  {
    init_simple_test("S11971C1");
    static S11971C1 lv;
    check2(sizeof(lv), ABISELECT(5808,3416), "sizeof(S11971C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S11971C1)");
    check_field_offset(lv, s11971c1f0, 0, "S11971C1.s11971c1f0");
    check_field_offset(lv, s11971c1f1, ABISELECT(192,116), "S11971C1.s11971c1f1");
    check_field_offset(lv, s11971c1f2, ABISELECT(496,296), "S11971C1.s11971c1f2");
    check_field_offset(lv, s11971c1f3, ABISELECT(744,444), "S11971C1.s11971c1f3");
    check_field_offset(lv, s11971c1f4, ABISELECT(944,556), "S11971C1.s11971c1f4");
    check_field_offset(lv, s11971c1f5, ABISELECT(1184,692), "S11971C1.s11971c1f5");
    check_field_offset(lv, s11971c1f6, ABISELECT(1384,804), "S11971C1.s11971c1f6");
    check_field_offset(lv, s11971c1f7, ABISELECT(1632,952), "S11971C1.s11971c1f7");
    check_field_offset(lv, s11971c1f8, ABISELECT(1880,1100), "S11971C1.s11971c1f8");
    check_field_offset(lv, s11971c1f9, ABISELECT(2336,1384), "S11971C1.s11971c1f9");
    check_field_offset(lv, s11971c1f10, ABISELECT(2752,1640), "S11971C1.s11971c1f10");
    check_field_offset(lv, s11971c1f11, ABISELECT(3040,1808), "S11971C1.s11971c1f11");
    check_field_offset(lv, s11971c1f12, ABISELECT(3288,1952), "S11971C1.s11971c1f12");
    check_field_offset(lv, s11971c1f13, ABISELECT(3536,2096), "S11971C1.s11971c1f13");
    check_field_offset(lv, s11971c1f14, ABISELECT(3784,2240), "S11971C1.s11971c1f14");
    check_field_offset(lv, s11971c1f15, ABISELECT(4032,2384), "S11971C1.s11971c1f15");
    check_field_offset(lv, s11971c1f16, ABISELECT(4280,2528), "S11971C1.s11971c1f16");
    check_field_offset(lv, s11971c1f17, ABISELECT(4568,2696), "S11971C1.s11971c1f17");
    check_field_offset(lv, s11971c1f18, ABISELECT(4816,2840), "S11971C1.s11971c1f18");
    check_field_offset(lv, s11971c1f19, ABISELECT(5064,2984), "S11971C1.s11971c1f19");
    check_field_offset(lv, s11971c1f20, ABISELECT(5312,3128), "S11971C1.s11971c1f20");
    check_field_offset(lv, s11971c1f21, ABISELECT(5560,3272), "S11971C1.s11971c1f21");
  }
}
static Arrange_To_Call_Me vS11971C1(Test_S11971C1, "S11971C1", ABISELECT(5808,3416));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C3  {
  ::S17070C7_nt s15755c3f0;
  int s15755c3f1[2];
  void  mf15755c3(); // _ZN8S15755C39mf15755c3Ev
};
//SIG(-1 S15755C3) C1{ m FC2{ m Fi[2]} Fi[2]}


void  S15755C3 ::mf15755c3(){}

static void Test_S15755C3()
{
  {
    init_simple_test("S15755C3");
    S15755C3 lv;
    check2(sizeof(lv), 16, "sizeof(S15755C3)");
    check2(__alignof__(lv), 4, "__alignof__(S15755C3)");
    check_field_offset(lv, s15755c3f0, 0, "S15755C3.s15755c3f0");
    check_field_offset(lv, s15755c3f1, 8, "S15755C3.s15755c3f1");
  }
}
static Arrange_To_Call_Me vS15755C3(Test_S15755C3, "S15755C3", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C8  {
  void *s15755c8f0;
  ::S17070C7_nt s15755c8f1;
  int s15755c8f2;
  ::S17070C7_nt s15755c8f3;
  void  mf15755c8(); // _ZN8S15755C89mf15755c8Ev
};
//SIG(-1 S15755C8) C1{ m Fp FC2{ m Fi[2]} Fi FC2}


void  S15755C8 ::mf15755c8(){}

static void Test_S15755C8()
{
  {
    init_simple_test("S15755C8");
    S15755C8 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S15755C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C8)");
    check_field_offset(lv, s15755c8f0, 0, "S15755C8.s15755c8f0");
    check_field_offset(lv, s15755c8f1, ABISELECT(8,4), "S15755C8.s15755c8f1");
    check_field_offset(lv, s15755c8f2, ABISELECT(16,12), "S15755C8.s15755c8f2");
    check_field_offset(lv, s15755c8f3, ABISELECT(20,16), "S15755C8.s15755c8f3");
  }
}
static Arrange_To_Call_Me vS15755C8(Test_S15755C8, "S15755C8", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C9  {
  int s15755c9f0[8];
  void  mf15755c9(); // _ZN8S15755C99mf15755c9Ev
};
//SIG(-1 S15755C9) C1{ m Fi[8]}


void  S15755C9 ::mf15755c9(){}

static void Test_S15755C9()
{
  {
    init_simple_test("S15755C9");
    S15755C9 lv;
    check2(sizeof(lv), 32, "sizeof(S15755C9)");
    check2(__alignof__(lv), 4, "__alignof__(S15755C9)");
    check_field_offset(lv, s15755c9f0, 0, "S15755C9.s15755c9f0");
  }
}
static Arrange_To_Call_Me vS15755C9(Test_S15755C9, "S15755C9", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C12_nt  {
  void *s15755c12f0;
  int s15755c12f1[2];
  ::S17070C78 s15755c12f2;
  void  mf15755c12(); // _ZN12S15755C12_nt10mf15755c12Ev
};
//SIG(-1 S15755C12_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S15755C12_nt ::mf15755c12(){}

//skip512 S15755C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C2  {
  ::S15755C3 s15755c2f0;
  ::S17070C145 s15755c2f1;
  ::S17070C7_nt s15755c2f2;
  ::S17070C30_nt s15755c2f3;
  ::S15755C8 s15755c2f4;
  ::S15755C9 s15755c2f5;
  int s15755c2f6;
  ::S17070C74_nt s15755c2f7;
  ::S17070C30_nt s15755c2f8;
  ::S17070C30_nt s15755c2f9;
  ::S17070C30_nt s15755c2f10;
  ::S17070C30_nt s15755c2f11;
  ::S15755C12_nt s15755c2f12;
  ::S15755C12_nt s15755c2f13;
  void  mf15755c2(); // _ZN8S15755C29mf15755c2Ev
};
//SIG(-1 S15755C2) C1{ m FC2{ m FC3{ m Fi[2]} Fi[2]} FC4{ m Fp[2]} FC3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m Fp FC3 Fi FC3} FC8{ m Fi[8]} Fi FC9{ m Fp Fi FC6} FC5 FC5 FC5 FC5 FC10{ m Fp Fi[2] FC11{ m}} FC10}


void  S15755C2 ::mf15755c2(){}

static void Test_S15755C2()
{
  {
    init_simple_test("S15755C2");
    S15755C2 lv;
    check2(sizeof(lv), ABISELECT(296,216), "sizeof(S15755C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C2)");
    check_field_offset(lv, s15755c2f0, 0, "S15755C2.s15755c2f0");
    check_field_offset(lv, s15755c2f1, 16, "S15755C2.s15755c2f1");
    check_field_offset(lv, s15755c2f2, ABISELECT(32,24), "S15755C2.s15755c2f2");
    check_field_offset(lv, s15755c2f3, ABISELECT(40,32), "S15755C2.s15755c2f3");
    check_field_offset(lv, s15755c2f4, ABISELECT(64,48), "S15755C2.s15755c2f4");
    check_field_offset(lv, s15755c2f5, ABISELECT(96,72), "S15755C2.s15755c2f5");
    check_field_offset(lv, s15755c2f6, ABISELECT(128,104), "S15755C2.s15755c2f6");
    check_field_offset(lv, s15755c2f7, ABISELECT(136,108), "S15755C2.s15755c2f7");
    check_field_offset(lv, s15755c2f8, ABISELECT(152,120), "S15755C2.s15755c2f8");
    check_field_offset(lv, s15755c2f9, ABISELECT(176,136), "S15755C2.s15755c2f9");
    check_field_offset(lv, s15755c2f10, ABISELECT(200,152), "S15755C2.s15755c2f10");
    check_field_offset(lv, s15755c2f11, ABISELECT(224,168), "S15755C2.s15755c2f11");
    check_field_offset(lv, s15755c2f12, ABISELECT(248,184), "S15755C2.s15755c2f12");
    check_field_offset(lv, s15755c2f13, ABISELECT(272,200), "S15755C2.s15755c2f13");
  }
}
static Arrange_To_Call_Me vS15755C2(Test_S15755C2, "S15755C2", ABISELECT(296,216));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C18  {
  ::S17070C12_nt s15755c18f0;
  virtual  ~S15755C18(); // _ZN9S15755C18D1Ev
  virtual void  v7(); // _ZN9S15755C182v7Ev
  virtual void  v8(); // _ZN9S15755C182v8Ev
  virtual void  v9(); // _ZN9S15755C182v9Ev
  virtual void  v10(); // _ZN9S15755C183v10Ev
  virtual void  v11(); // _ZN9S15755C183v11Ev
  virtual void  v12(); // _ZN9S15755C183v12Ev
  S15755C18(); // tgen
};
//SIG(-1 S15755C18) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15755C18 ::~S15755C18(){ note_dtor("S15755C18", this);}
void  S15755C18 ::v7(){vfunc_called(this, "_ZN9S15755C182v7Ev");}
void  S15755C18 ::v8(){vfunc_called(this, "_ZN9S15755C182v8Ev");}
void  S15755C18 ::v9(){vfunc_called(this, "_ZN9S15755C182v9Ev");}
void  S15755C18 ::v10(){vfunc_called(this, "_ZN9S15755C183v10Ev");}
void  S15755C18 ::v11(){vfunc_called(this, "_ZN9S15755C183v11Ev");}
void  S15755C18 ::v12(){vfunc_called(this, "_ZN9S15755C183v12Ev");}
S15755C18 ::S15755C18(){ note_ctor("S15755C18", this);} // tgen

static void Test_S15755C18()
{
  extern Class_Descriptor cd_S15755C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15755C18, buf);
    S15755C18 *dp, &lv = *(dp=new (buf) S15755C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15755C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C18)");
    check_field_offset(lv, s15755c18f0, ABISELECT(8,4), "S15755C18.s15755c18f0");
    test_class_info(&lv, &cd_S15755C18);
    dp->~S15755C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15755C18(Test_S15755C18, "S15755C18", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S15755C18C1Ev();
extern void _ZN9S15755C18D1Ev();
Name_Map name_map_S15755C18[] = {
  NSPAIR(_ZN9S15755C18C1Ev),
  NSPAIR(_ZN9S15755C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S15755C18[];
extern void _ZN9S15755C18D1Ev();
extern void _ZN9S15755C18D0Ev();
extern void _ZN9S15755C182v7Ev();
extern void _ZN9S15755C182v8Ev();
extern void _ZN9S15755C182v9Ev();
extern void _ZN9S15755C183v10Ev();
extern void _ZN9S15755C183v11Ev();
extern void _ZN9S15755C183v12Ev();
static  VTBL_ENTRY vtc_S15755C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15755C18[0]),
  (VTBL_ENTRY)&_ZN9S15755C18D1Ev,
  (VTBL_ENTRY)&_ZN9S15755C18D0Ev,
  (VTBL_ENTRY)&_ZN9S15755C182v7Ev,
  (VTBL_ENTRY)&_ZN9S15755C182v8Ev,
  (VTBL_ENTRY)&_ZN9S15755C182v9Ev,
  (VTBL_ENTRY)&_ZN9S15755C183v10Ev,
  (VTBL_ENTRY)&_ZN9S15755C183v11Ev,
  (VTBL_ENTRY)&_ZN9S15755C183v12Ev,
};
extern VTBL_ENTRY _ZTI9S15755C18[];
extern  VTBL_ENTRY _ZTV9S15755C18[];
Class_Descriptor cd_S15755C18 = {  "S15755C18", // class name
  0,0,//no base classes
  &(vtc_S15755C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S15755C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S15755C18),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C17  : S15755C18 , S17070C13_nt {
  ::S17070C14_nt s15755c17f0;
  ::S17070C19_nt s15755c17f1;
  ::S17070C22_nt s15755c17f2;
  ::S17070C25_nt s15755c17f3;
  ::S17070C25_nt s15755c17f4;
  ::S17070C25_nt s15755c17f5;
  ::S17070C22_nt s15755c17f6;
  ::S17070C14_nt s15755c17f7;
  ::S17070C25_nt s15755c17f8;
  ::S17070C51_nt s15755c17f9;
  ::S17070C51_nt s15755c17f10;
  ::S17070C14_nt s15755c17f11;
  ::S17070C14_nt s15755c17f12;
  ::S17070C51_nt s15755c17f13;
  virtual void  v1(); // _ZN9S15755C172v1Ev
  virtual void  v2(); // _ZN9S15755C172v2Ev
  virtual void  v3(); // _ZN9S15755C172v3Ev
  virtual void  v4(); // _ZN9S15755C172v4Ev
  virtual void  v5(); // _ZN9S15755C172v5Ev
  virtual void  v6(); // _ZN9S15755C172v6Ev
  ~S15755C17(); // tgen
  S15755C17(); // tgen
};
//SIG(-1 S15755C17) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}} FC14{ BC6 FC15{ m FC16{ m FL}}} FC17{ BC6 Fi} FC17 FC17 FC14 FC5 FC17 FC18{ BC6 FC8} FC18 FC5 FC5 FC18}


void  S15755C17 ::v1(){vfunc_called(this, "_ZN9S15755C172v1Ev");}
void  S15755C17 ::v2(){vfunc_called(this, "_ZN9S15755C172v2Ev");}
void  S15755C17 ::v3(){vfunc_called(this, "_ZN9S15755C172v3Ev");}
void  S15755C17 ::v4(){vfunc_called(this, "_ZN9S15755C172v4Ev");}
void  S15755C17 ::v5(){vfunc_called(this, "_ZN9S15755C172v5Ev");}
void  S15755C17 ::v6(){vfunc_called(this, "_ZN9S15755C172v6Ev");}
S15755C17 ::~S15755C17(){ note_dtor("S15755C17", this);} // tgen
S15755C17 ::S15755C17(){ note_ctor("S15755C17", this);} // tgen

static void Test_S15755C17()
{
  extern Class_Descriptor cd_S15755C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,163)];
    init_test(&cd_S15755C17, buf);
    S15755C17 *dp, &lv = *(dp=new (buf) S15755C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,648), "sizeof(S15755C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C17)");
    check_base_class_offset(lv, (S15755C18*), 0, "S15755C17");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S15755C17");
    check_field_offset(lv, s15755c17f0, ABISELECT(40,20), "S15755C17.s15755c17f0");
    check_field_offset(lv, s15755c17f1, ABISELECT(136,104), "S15755C17.s15755c17f1");
    check_field_offset(lv, s15755c17f2, ABISELECT(192,136), "S15755C17.s15755c17f2");
    check_field_offset(lv, s15755c17f3, ABISELECT(232,164), "S15755C17.s15755c17f3");
    check_field_offset(lv, s15755c17f4, ABISELECT(272,188), "S15755C17.s15755c17f4");
    check_field_offset(lv, s15755c17f5, ABISELECT(312,212), "S15755C17.s15755c17f5");
    check_field_offset(lv, s15755c17f6, ABISELECT(352,236), "S15755C17.s15755c17f6");
    check_field_offset(lv, s15755c17f7, ABISELECT(392,264), "S15755C17.s15755c17f7");
    check_field_offset(lv, s15755c17f8, ABISELECT(488,348), "S15755C17.s15755c17f8");
    check_field_offset(lv, s15755c17f9, ABISELECT(528,372), "S15755C17.s15755c17f9");
    check_field_offset(lv, s15755c17f10, ABISELECT(576,408), "S15755C17.s15755c17f10");
    check_field_offset(lv, s15755c17f11, ABISELECT(624,444), "S15755C17.s15755c17f11");
    check_field_offset(lv, s15755c17f12, ABISELECT(720,528), "S15755C17.s15755c17f12");
    check_field_offset(lv, s15755c17f13, ABISELECT(816,612), "S15755C17.s15755c17f13");
    test_class_info(&lv, &cd_S15755C17);
    dp->~S15755C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15755C17(Test_S15755C17, "S15755C17", ABISELECT(864,648));

#else // __cplusplus

extern void _ZN9S15755C17C1Ev();
extern void _ZN9S15755C17D1Ev();
Name_Map name_map_S15755C17[] = {
  NSPAIR(_ZN9S15755C17C1Ev),
  NSPAIR(_ZN9S15755C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15755C18;
extern VTBL_ENTRY _ZTI9S15755C18[];
extern  VTBL_ENTRY _ZTV9S15755C18[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S15755C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15755C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15755C17[];
extern void _ZN9S15755C17D1Ev();
extern void _ZN9S15755C17D0Ev();
extern void _ZN9S15755C182v7Ev();
extern void _ZN9S15755C182v8Ev();
extern void _ZN9S15755C182v9Ev();
extern void _ZN9S15755C183v10Ev();
extern void _ZN9S15755C183v11Ev();
extern void _ZN9S15755C183v12Ev();
extern void _ZN9S15755C172v1Ev();
extern void _ZN9S15755C172v2Ev();
extern void _ZN9S15755C172v3Ev();
extern void _ZN9S15755C172v4Ev();
extern void _ZN9S15755C172v5Ev();
extern void _ZN9S15755C172v6Ev();
static  VTBL_ENTRY vtc_S15755C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15755C17[0]),
  (VTBL_ENTRY)&_ZN9S15755C17D1Ev,
  (VTBL_ENTRY)&_ZN9S15755C17D0Ev,
  (VTBL_ENTRY)&_ZN9S15755C182v7Ev,
  (VTBL_ENTRY)&_ZN9S15755C182v8Ev,
  (VTBL_ENTRY)&_ZN9S15755C182v9Ev,
  (VTBL_ENTRY)&_ZN9S15755C183v10Ev,
  (VTBL_ENTRY)&_ZN9S15755C183v11Ev,
  (VTBL_ENTRY)&_ZN9S15755C183v12Ev,
  (VTBL_ENTRY)&_ZN9S15755C172v1Ev,
  (VTBL_ENTRY)&_ZN9S15755C172v2Ev,
  (VTBL_ENTRY)&_ZN9S15755C172v3Ev,
  (VTBL_ENTRY)&_ZN9S15755C172v4Ev,
  (VTBL_ENTRY)&_ZN9S15755C172v5Ev,
  (VTBL_ENTRY)&_ZN9S15755C172v6Ev,
};
extern VTBL_ENTRY _ZTI9S15755C17[];
extern  VTBL_ENTRY _ZTV9S15755C17[];
Class_Descriptor cd_S15755C17 = {  "S15755C17", // class name
  bases_S15755C17, 2,
  &(vtc_S15755C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,648), // object size
  NSPAIRA(_ZTI9S15755C17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15755C17),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C16  {
  ::S15755C17 s15755c16f0;
  ::S17070C26_nt s15755c16f1;
  void  mf15755c16(); // _ZN9S15755C1610mf15755c16Ev
};
//SIG(-1 S15755C16) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m Fp[2]} FC14{ m Fp}}} FC15{ BC7 FC16{ m FC17{ m FL}}} FC18{ BC7 Fi} FC18 FC18 FC15 FC6 FC18 FC19{ BC7 FC9} FC19 FC6 FC6 FC19} FC20{ BC21{ BC22{ vd v13} vd v14 Fp[2] FC23{ m FC24{ m Fp Fi[2] FC25{ m}}} FC26{ m Fp[2]}} vd FC27{ m FC28{ Fs[2] Fc[2] Fs}[12] Fi FC29{ Fs[2]}[4] Fi FC26}}}


void  S15755C16 ::mf15755c16(){}

static void Test_S15755C16()
{
  {
    init_simple_test("S15755C16");
    S15755C16 lv;
    check2(sizeof(lv), ABISELECT(1064,812), "sizeof(S15755C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C16)");
    check_field_offset(lv, s15755c16f0, 0, "S15755C16.s15755c16f0");
    check_field_offset(lv, s15755c16f1, ABISELECT(864,648), "S15755C16.s15755c16f1");
  }
}
static Arrange_To_Call_Me vS15755C16(Test_S15755C16, "S15755C16", ABISELECT(1064,812));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C76  : S17070C110 {
  ::S17070C76_nt s15755c76f0;
  ::S17070C74_nt s15755c76f1;
  ::S17070C74_nt s15755c76f2;
  ::S17070C74_nt s15755c76f3;
  ::S17070C74_nt s15755c76f4;
  virtual  ~S15755C76(); // _ZN9S15755C76D1Ev
  virtual void  v28(); // _ZN9S15755C763v28Ev
  virtual void  v29(); // _ZN9S15755C763v29Ev
  virtual void  v30(); // _ZN9S15755C763v30Ev
  virtual void  v31(); // _ZN9S15755C763v31Ev
  virtual void  v32(); // _ZN9S15755C763v32Ev
  virtual void  v33(); // _ZN9S15755C763v33Ev
  S15755C76(); // tgen
};
//SIG(-1 S15755C76) C1{ BC2{ m Fp[2]} vd v1 v2 v3 v4 v5 v6 FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ m Fp Fi FC7{ m}} FC6 FC6 FC6}


 S15755C76 ::~S15755C76(){ note_dtor("S15755C76", this);}
void  S15755C76 ::v28(){vfunc_called(this, "_ZN9S15755C763v28Ev");}
void  S15755C76 ::v29(){vfunc_called(this, "_ZN9S15755C763v29Ev");}
void  S15755C76 ::v30(){vfunc_called(this, "_ZN9S15755C763v30Ev");}
void  S15755C76 ::v31(){vfunc_called(this, "_ZN9S15755C763v31Ev");}
void  S15755C76 ::v32(){vfunc_called(this, "_ZN9S15755C763v32Ev");}
void  S15755C76 ::v33(){vfunc_called(this, "_ZN9S15755C763v33Ev");}
S15755C76 ::S15755C76(){ note_ctor("S15755C76", this);} // tgen

static void Test_S15755C76()
{
  extern Class_Descriptor cd_S15755C76;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,19)];
    init_test(&cd_S15755C76, buf);
    S15755C76 *dp, &lv = *(dp=new (buf) S15755C76());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,72), "sizeof(S15755C76)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C76)");
    check_base_class_offset(lv, (S17070C110*), ABISELECT(8,4), "S15755C76");
    check_field_offset(lv, s15755c76f0, ABISELECT(24,12), "S15755C76.s15755c76f0");
    check_field_offset(lv, s15755c76f1, ABISELECT(40,24), "S15755C76.s15755c76f1");
    check_field_offset(lv, s15755c76f2, ABISELECT(56,36), "S15755C76.s15755c76f2");
    check_field_offset(lv, s15755c76f3, ABISELECT(72,48), "S15755C76.s15755c76f3");
    check_field_offset(lv, s15755c76f4, ABISELECT(88,60), "S15755C76.s15755c76f4");
    test_class_info(&lv, &cd_S15755C76);
    dp->~S15755C76();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15755C76(Test_S15755C76, "S15755C76", ABISELECT(104,72));

#else // __cplusplus

extern void _ZN9S15755C76C1Ev();
extern void _ZN9S15755C76D1Ev();
Name_Map name_map_S15755C76[] = {
  NSPAIR(_ZN9S15755C76C1Ev),
  NSPAIR(_ZN9S15755C76D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C110;
extern VTBL_ENTRY _ZTI10S17070C110[];
static Base_Class bases_S15755C76[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C110,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15755C76[];
extern void _ZN9S15755C76D1Ev();
extern void _ZN9S15755C76D0Ev();
extern void _ZN9S15755C763v28Ev();
extern void _ZN9S15755C763v29Ev();
extern void _ZN9S15755C763v30Ev();
extern void _ZN9S15755C763v31Ev();
extern void _ZN9S15755C763v32Ev();
extern void _ZN9S15755C763v33Ev();
static  VTBL_ENTRY vtc_S15755C76[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15755C76[0]),
  (VTBL_ENTRY)&_ZN9S15755C76D1Ev,
  (VTBL_ENTRY)&_ZN9S15755C76D0Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v28Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v29Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v30Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v31Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v32Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v33Ev,
};
extern VTBL_ENTRY _ZTI9S15755C76[];
extern  VTBL_ENTRY _ZTV9S15755C76[];
Class_Descriptor cd_S15755C76 = {  "S15755C76", // class name
  bases_S15755C76, 1,
  &(vtc_S15755C76[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,72), // object size
  NSPAIRA(_ZTI9S15755C76),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S15755C76),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C83  {
  void *s15755c83f0;
  int s15755c83f1[2];
  ::S17070C31_nt s15755c83f2;
  void  mf15755c83(); // _ZN9S15755C8310mf15755c83Ev
};
//SIG(-1 S15755C83) C1{ m Fp Fi[2] FC2{ m}}


void  S15755C83 ::mf15755c83(){}

static void Test_S15755C83()
{
  {
    init_simple_test("S15755C83");
    S15755C83 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S15755C83)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C83)");
    check_field_offset(lv, s15755c83f0, 0, "S15755C83.s15755c83f0");
    check_field_offset(lv, s15755c83f1, ABISELECT(8,4), "S15755C83.s15755c83f1");
    check_field_offset(lv, s15755c83f2, ABISELECT(16,12), "S15755C83.s15755c83f2");
  }
}
static Arrange_To_Call_Me vS15755C83(Test_S15755C83, "S15755C83", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C82  {
  ::S15755C83 s15755c82f0;
  ::S17070C91 s15755c82f1;
  ::S17070C74_nt s15755c82f2;
  virtual  ~S15755C82(); // _ZN9S15755C82D1Ev
  virtual void  v35(); // _ZN9S15755C823v35Ev
  S15755C82(); // tgen
};
//SIG(-1 S15755C82) C1{ vd v1 FC2{ m Fp Fi[2] FC3{ m}} FC4{ m Fc FC5{ m Fi[3]} Fi[2]} FC6{ m Fp Fi FC3}}


 S15755C82 ::~S15755C82(){ note_dtor("S15755C82", this);}
void  S15755C82 ::v35(){vfunc_called(this, "_ZN9S15755C823v35Ev");}
S15755C82 ::S15755C82(){ note_ctor("S15755C82", this);} // tgen

static void Test_S15755C82()
{
  extern Class_Descriptor cd_S15755C82;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S15755C82, buf);
    S15755C82 *dp, &lv = *(dp=new (buf) S15755C82());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S15755C82)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C82)");
    check_field_offset(lv, s15755c82f0, ABISELECT(8,4), "S15755C82.s15755c82f0");
    check_field_offset(lv, s15755c82f1, ABISELECT(32,20), "S15755C82.s15755c82f1");
    check_field_offset(lv, s15755c82f2, ABISELECT(56,44), "S15755C82.s15755c82f2");
    test_class_info(&lv, &cd_S15755C82);
    dp->~S15755C82();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15755C82(Test_S15755C82, "S15755C82", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN9S15755C82C1Ev();
extern void _ZN9S15755C82D1Ev();
Name_Map name_map_S15755C82[] = {
  NSPAIR(_ZN9S15755C82C1Ev),
  NSPAIR(_ZN9S15755C82D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S15755C82[];
extern void _ZN9S15755C82D1Ev();
extern void _ZN9S15755C82D0Ev();
extern void _ZN9S15755C823v35Ev();
static  VTBL_ENTRY vtc_S15755C82[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15755C82[0]),
  (VTBL_ENTRY)&_ZN9S15755C82D1Ev,
  (VTBL_ENTRY)&_ZN9S15755C82D0Ev,
  (VTBL_ENTRY)&_ZN9S15755C823v35Ev,
};
extern VTBL_ENTRY _ZTI9S15755C82[];
extern  VTBL_ENTRY _ZTV9S15755C82[];
Class_Descriptor cd_S15755C82 = {  "S15755C82", // class name
  0,0,//no base classes
  &(vtc_S15755C82[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI9S15755C82),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S15755C82),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C97  {
  ::S17070C97 s15755c97f0;
  ::S17070C97 s15755c97f1;
  ::S17070C97 s15755c97f2;
  ::S17070C97 s15755c97f3;
  ::S17070C97 s15755c97f4;
  void  mf15755c97(); // _ZN9S15755C9710mf15755c97Ev
};
//SIG(-1 S15755C97) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC2 FC2 FC2 FC2}


void  S15755C97 ::mf15755c97(){}

static void Test_S15755C97()
{
  {
    init_simple_test("S15755C97");
    S15755C97 lv;
    check2(sizeof(lv), ABISELECT(120,60), "sizeof(S15755C97)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C97)");
    check_field_offset(lv, s15755c97f0, 0, "S15755C97.s15755c97f0");
    check_field_offset(lv, s15755c97f1, ABISELECT(24,12), "S15755C97.s15755c97f1");
    check_field_offset(lv, s15755c97f2, ABISELECT(48,24), "S15755C97.s15755c97f2");
    check_field_offset(lv, s15755c97f3, ABISELECT(72,36), "S15755C97.s15755c97f3");
    check_field_offset(lv, s15755c97f4, ABISELECT(96,48), "S15755C97.s15755c97f4");
  }
}
static Arrange_To_Call_Me vS15755C97(Test_S15755C97, "S15755C97", ABISELECT(120,60));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C95  : S15755C82 , S17070C102 {
  ::S15755C97 s15755c95f0;
  virtual void  v63(); // _ZN9S15755C953v63Ev
  ~S15755C95(); // tgen
  S15755C95(); // tgen
};
//SIG(-1 S15755C95) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC10 FC10 FC10 FC10}}


void  S15755C95 ::v63(){vfunc_called(this, "_ZN9S15755C953v63Ev");}
S15755C95 ::~S15755C95(){ note_dtor("S15755C95", this);} // tgen
S15755C95 ::S15755C95(){ note_ctor("S15755C95", this);} // tgen

static void Test_S15755C95()
{
  extern Class_Descriptor cd_S15755C95;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,32)];
    init_test(&cd_S15755C95, buf);
    S15755C95 *dp, &lv = *(dp=new (buf) S15755C95());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,124), "sizeof(S15755C95)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C95)");
    check_base_class_offset(lv, (S15755C82*), 0, "S15755C95");
    check_base_class_offset(lv, (S17070C102*), ABISELECT(72,56), "S15755C95");
    check_field_offset(lv, s15755c95f0, ABISELECT(88,64), "S15755C95.s15755c95f0");
    test_class_info(&lv, &cd_S15755C95);
    dp->~S15755C95();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15755C95(Test_S15755C95, "S15755C95", ABISELECT(208,124));

#else // __cplusplus

extern void _ZN9S15755C95C1Ev();
extern void _ZN9S15755C95D1Ev();
Name_Map name_map_S15755C95[] = {
  NSPAIR(_ZN9S15755C95C1Ev),
  NSPAIR(_ZN9S15755C95D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15755C82;
extern VTBL_ENTRY _ZTI9S15755C82[];
extern  VTBL_ENTRY _ZTV9S15755C82[];
extern Class_Descriptor cd_S17070C102;
extern VTBL_ENTRY _ZTI10S17070C102[];
static Base_Class bases_S15755C95[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15755C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C102,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15755C95[];
extern void _ZN9S15755C95D1Ev();
extern void _ZN9S15755C95D0Ev();
extern void _ZN9S15755C823v35Ev();
extern void _ZN9S15755C953v63Ev();
static  VTBL_ENTRY vtc_S15755C95[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15755C95[0]),
  (VTBL_ENTRY)&_ZN9S15755C95D1Ev,
  (VTBL_ENTRY)&_ZN9S15755C95D0Ev,
  (VTBL_ENTRY)&_ZN9S15755C823v35Ev,
  (VTBL_ENTRY)&_ZN9S15755C953v63Ev,
};
extern VTBL_ENTRY _ZTI9S15755C95[];
extern  VTBL_ENTRY _ZTV9S15755C95[];
Class_Descriptor cd_S15755C95 = {  "S15755C95", // class name
  bases_S15755C95, 2,
  &(vtc_S15755C95[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,124), // object size
  NSPAIRA(_ZTI9S15755C95),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15755C95),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C94  : S15755C76 {
  ::S15755C95 s15755c94f0;
  ::S17070C138 s15755c94f1;
  virtual void  v57(); // _ZN9S15755C943v57Ev
  virtual void  v58(); // _ZN9S15755C943v58Ev
  virtual void  v59(); // _ZN9S15755C943v59Ev
  virtual void  v60(); // _ZN9S15755C943v60Ev
  virtual void  v61(); // _ZN9S15755C943v61Ev
  virtual void  v62(); // _ZN9S15755C943v62Ev
  ~S15755C94(); // tgen
  S15755C94(); // tgen
};
//SIG(-1 S15755C94) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC16 FC16 FC16 FC16}} FC18{ m FC19{ m Fp[2]}}}


void  S15755C94 ::v57(){vfunc_called(this, "_ZN9S15755C943v57Ev");}
void  S15755C94 ::v58(){vfunc_called(this, "_ZN9S15755C943v58Ev");}
void  S15755C94 ::v59(){vfunc_called(this, "_ZN9S15755C943v59Ev");}
void  S15755C94 ::v60(){vfunc_called(this, "_ZN9S15755C943v60Ev");}
void  S15755C94 ::v61(){vfunc_called(this, "_ZN9S15755C943v61Ev");}
void  S15755C94 ::v62(){vfunc_called(this, "_ZN9S15755C943v62Ev");}
S15755C94 ::~S15755C94(){ note_dtor("S15755C94", this);} // tgen
S15755C94 ::S15755C94(){ note_ctor("S15755C94", this);} // tgen

static void Test_S15755C94()
{
  extern Class_Descriptor cd_S15755C94;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,52)];
    init_test(&cd_S15755C94, buf);
    S15755C94 *dp, &lv = *(dp=new (buf) S15755C94());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,204), "sizeof(S15755C94)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C94)");
    check_base_class_offset(lv, (S17070C110*)(S15755C76*), ABISELECT(8,4), "S15755C94");
    check_base_class_offset(lv, (S15755C76*), 0, "S15755C94");
    check_field_offset(lv, s15755c94f0, ABISELECT(104,72), "S15755C94.s15755c94f0");
    check_field_offset(lv, s15755c94f1, ABISELECT(312,196), "S15755C94.s15755c94f1");
    test_class_info(&lv, &cd_S15755C94);
    dp->~S15755C94();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15755C94(Test_S15755C94, "S15755C94", ABISELECT(328,204));

#else // __cplusplus

extern void _ZN9S15755C94C1Ev();
extern void _ZN9S15755C94D1Ev();
Name_Map name_map_S15755C94[] = {
  NSPAIR(_ZN9S15755C94C1Ev),
  NSPAIR(_ZN9S15755C94D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C110;
extern VTBL_ENTRY _ZTI10S17070C110[];
extern Class_Descriptor cd_S15755C76;
extern VTBL_ENTRY _ZTI9S15755C76[];
extern  VTBL_ENTRY _ZTV9S15755C76[];
static Base_Class bases_S15755C94[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C110,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15755C76,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15755C94[];
extern void _ZN9S15755C94D1Ev();
extern void _ZN9S15755C94D0Ev();
extern void _ZN9S15755C763v28Ev();
extern void _ZN9S15755C763v29Ev();
extern void _ZN9S15755C763v30Ev();
extern void _ZN9S15755C763v31Ev();
extern void _ZN9S15755C763v32Ev();
extern void _ZN9S15755C763v33Ev();
extern void _ZN9S15755C943v57Ev();
extern void _ZN9S15755C943v58Ev();
extern void _ZN9S15755C943v59Ev();
extern void _ZN9S15755C943v60Ev();
extern void _ZN9S15755C943v61Ev();
extern void _ZN9S15755C943v62Ev();
static  VTBL_ENTRY vtc_S15755C94[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15755C94[0]),
  (VTBL_ENTRY)&_ZN9S15755C94D1Ev,
  (VTBL_ENTRY)&_ZN9S15755C94D0Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v28Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v29Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v30Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v31Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v32Ev,
  (VTBL_ENTRY)&_ZN9S15755C763v33Ev,
  (VTBL_ENTRY)&_ZN9S15755C943v57Ev,
  (VTBL_ENTRY)&_ZN9S15755C943v58Ev,
  (VTBL_ENTRY)&_ZN9S15755C943v59Ev,
  (VTBL_ENTRY)&_ZN9S15755C943v60Ev,
  (VTBL_ENTRY)&_ZN9S15755C943v61Ev,
  (VTBL_ENTRY)&_ZN9S15755C943v62Ev,
};
extern VTBL_ENTRY _ZTI9S15755C94[];
extern  VTBL_ENTRY _ZTV9S15755C94[];
Class_Descriptor cd_S15755C94 = {  "S15755C94", // class name
  bases_S15755C94, 2,
  &(vtc_S15755C94[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,204), // object size
  NSPAIRA(_ZTI9S15755C94),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S15755C94),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C93  {
  ::S15755C94 s15755c93f0;
  ::S15755C95 s15755c93f1;
  void  mf15755c93(); // _ZN9S15755C9310mf15755c93Ev
};
//SIG(-1 S15755C93) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC17 FC17 FC17 FC17}} FC19{ m FC20{ m Fp[2]}}} FC10}


void  S15755C93 ::mf15755c93(){}

static void Test_S15755C93()
{
  {
    init_simple_test("S15755C93");
    S15755C93 lv;
    check2(sizeof(lv), ABISELECT(536,328), "sizeof(S15755C93)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C93)");
    check_field_offset(lv, s15755c93f0, 0, "S15755C93.s15755c93f0");
    check_field_offset(lv, s15755c93f1, ABISELECT(328,204), "S15755C93.s15755c93f1");
  }
}
static Arrange_To_Call_Me vS15755C93(Test_S15755C93, "S15755C93", ABISELECT(536,328));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C100  {
  ::S17070C23_nt s15755c100f0;
  ::S17070C23_nt s15755c100f1;
  void  mf15755c100(); // _ZN10S15755C10011mf15755c100Ev
};
//SIG(-1 S15755C100) C1{ m FC2{ m FC3{ m FL}} FC2}


void  S15755C100 ::mf15755c100(){}

static void Test_S15755C100()
{
  {
    init_simple_test("S15755C100");
    S15755C100 lv;
    check2(sizeof(lv), 16, "sizeof(S15755C100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C100)");
    check_field_offset(lv, s15755c100f0, 0, "S15755C100.s15755c100f0");
    check_field_offset(lv, s15755c100f1, 8, "S15755C100.s15755c100f1");
  }
}
static Arrange_To_Call_Me vS15755C100(Test_S15755C100, "S15755C100", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C99  {
  ::S15755C100 s15755c99f0;
  ::S15755C100 s15755c99f1;
  void  mf15755c99(); // _ZN9S15755C9910mf15755c99Ev
};
//SIG(-1 S15755C99) C1{ m FC2{ m FC3{ m FC4{ m FL}} FC3} FC2}


void  S15755C99 ::mf15755c99(){}

static void Test_S15755C99()
{
  {
    init_simple_test("S15755C99");
    S15755C99 lv;
    check2(sizeof(lv), 32, "sizeof(S15755C99)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C99)");
    check_field_offset(lv, s15755c99f0, 0, "S15755C99.s15755c99f0");
    check_field_offset(lv, s15755c99f1, 16, "S15755C99.s15755c99f1");
  }
}
static Arrange_To_Call_Me vS15755C99(Test_S15755C99, "S15755C99", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15755C1  {
  ::S15755C2 s15755c1f0;
  ::S15755C16 s15755c1f1;
  ::S17070C37 s15755c1f2;
  ::S17070C145 s15755c1f3;
  ::S17070C60 s15755c1f4;
  ::S17070C142 s15755c1f5;
  ::S17070C136 s15755c1f6;
  ::S17070C128 s15755c1f7;
  ::S17070C122 s15755c1f8;
  ::S17070C116 s15755c1f9;
  int s15755c1f10;
  char s15755c1f11;
  int s15755c1f12[4];
  char s15755c1f13[2];
  int s15755c1f14;
  ::S17070C21_nt s15755c1f15;
  ::S17070C71 s15755c1f16;
  ::S17070C16_nt s15755c1f17;
  ::S17070C16_nt s15755c1f18;
  ::S17070C80 s15755c1f19;
  ::S15755C93 s15755c1f20;
  ::S17070C145 s15755c1f21;
  ::S15755C99 s15755c1f22;
  void  mf15755c1(); // _ZN8S15755C19mf15755c1Ev
};
//SIG(1 S15755C1) C1{ m FC2{ m FC3{ m FC4{ m Fi[2]} Fi[2]} FC5{ m Fp[2]} FC4 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m Fp FC4 Fi FC4} FC9{ m Fi[8]} Fi FC10{ m Fp Fi FC7} FC6 FC6 FC6 FC6 FC11{ m Fp Fi[2] FC12{ m}} FC11} FC13{ m FC14{ BC15{ vd v7 v8 v9 v10 v11 v12 FC16{ m Fp[4]}} BC17{} v1 v2 v3 v4 v5 v6 FC18{ BC19{ m Fp Fi Fp Fi[2]} FC20{ m FC21{ m FC22{ m FL[2]}} FC21 FC21 FC21}} FC23{ BC19 FC24{ m FC25{ m Fp[2]} FC26{ m Fp}}} FC27{ BC19 FC28{ m FC29{ m FL}}} FC30{ BC19 Fi} FC30 FC30 FC27 FC18 FC30 FC31{ BC19 FC21} FC31 FC18 FC18 FC31} FC32{ BC33{ BC34{ vd v13} vd v14 Fp[2] FC35{ m FC6} FC36{ m Fp[2]}} vd FC37{ m FC38{ Fs[2] Fc[2] Fs}[12] Fi FC39{ Fs[2]}[4] Fi FC36}}} FC40{ m FC41{ BC42{ vd v21 v22 v23 v24 v25 v26 FC16} BC17 v15 v16 v17 v18 v19 v20 FC23} FC43{ BC44{ BC34 vd v27 Fp[2] FC35 FC45{ m Fp[2]}} vd FC46{ m Fp Fi FC47{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC36}}} FC5 FC48{ m Fi FC4 Fi FC49{ m FC50{ m Fp[2]} Fi} Fi[2] FC51{ m FC50 FC52{ m Fp[2]}} FC49} FC53{ m Fp[2]} FC54{ m Fp[2]} FC55{ m Fp[2]} FC56{ m Fp[2]} FC57{ m Fp[2]} Fi Fc Fi[4] Fc[2] Fi FC26 FC58{ m FC59{ m FC45} FC10 FC60{ BC61{ m Fp Fi FC12 FC12}} FC10 FC10 Fc[2] Fi} FC20 FC20 FC62{ m FC63{ BC64{ BC65{ m Fp[2]} vd v34 v35 v36 v37 v38 v39 FC60 FC10 FC10 FC10 FC10} v28 v29 v30 v31 v32 v33 FC66{ BC67{ vd v41 FC6 FC68{ m Fc FC69{ m Fi[3]} Fi[2]} FC10} BC70{ m Fp[2]} v40 FC71{ m FC72{ BC73{ vd v49 v50 v51 v52 v53 v54 v55} vd v42 v43 v44 v45 v46 v47 v48 FC21 Fp} FC74{ BC73 vd v56 v57 v58 v59 v60 v61 v62 Fi Fp} FC74 FC74 FC74 FC74 FC74 FC74 FC74 FC74}} FC75{ m FC70}} FC66} FC76{ m FC77{ BC78{ BC79{ m Fp[2]} vd v69 v70 v71 v72 v73 v74 FC60 FC10 FC10 FC10 FC10} v63 v64 v65 v66 v67 v68 FC80{ BC81{ vd v76 FC82{ m Fp Fi[2] FC7} FC68 FC10} BC83{ m Fp[2]} v75 FC84{ m FC74 FC74 FC74 FC74 FC74}} FC85{ m FC54}} FC80} FC5 FC86{ m FC87{ m FC28 FC28} FC87}}


void  S15755C1 ::mf15755c1(){}

static void Test_S15755C1()
{
  {
    init_simple_test("S15755C1");
    static S15755C1 lv;
    check2(sizeof(lv), ABISELECT(3392,2320), "sizeof(S15755C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15755C1)");
    check_field_offset(lv, s15755c1f0, 0, "S15755C1.s15755c1f0");
    check_field_offset(lv, s15755c1f1, ABISELECT(296,216), "S15755C1.s15755c1f1");
    check_field_offset(lv, s15755c1f2, ABISELECT(1360,1028), "S15755C1.s15755c1f2");
    check_field_offset(lv, s15755c1f3, ABISELECT(1560,1140), "S15755C1.s15755c1f3");
    check_field_offset(lv, s15755c1f4, ABISELECT(1576,1148), "S15755C1.s15755c1f4");
    check_field_offset(lv, s15755c1f5, ABISELECT(1680,1212), "S15755C1.s15755c1f5");
    check_field_offset(lv, s15755c1f6, ABISELECT(1696,1220), "S15755C1.s15755c1f6");
    check_field_offset(lv, s15755c1f7, ABISELECT(1712,1228), "S15755C1.s15755c1f7");
    check_field_offset(lv, s15755c1f8, ABISELECT(1728,1236), "S15755C1.s15755c1f8");
    check_field_offset(lv, s15755c1f9, ABISELECT(1744,1244), "S15755C1.s15755c1f9");
    check_field_offset(lv, s15755c1f10, ABISELECT(1760,1252), "S15755C1.s15755c1f10");
    check_field_offset(lv, s15755c1f11, ABISELECT(1764,1256), "S15755C1.s15755c1f11");
    check_field_offset(lv, s15755c1f12, ABISELECT(1768,1260), "S15755C1.s15755c1f12");
    check_field_offset(lv, s15755c1f13, ABISELECT(1784,1276), "S15755C1.s15755c1f13");
    check_field_offset(lv, s15755c1f14, ABISELECT(1788,1280), "S15755C1.s15755c1f14");
    check_field_offset(lv, s15755c1f15, ABISELECT(1792,1284), "S15755C1.s15755c1f15");
    check_field_offset(lv, s15755c1f16, ABISELECT(1800,1288), "S15755C1.s15755c1f16");
    check_field_offset(lv, s15755c1f17, ABISELECT(1888,1352), "S15755C1.s15755c1f17");
    check_field_offset(lv, s15755c1f18, ABISELECT(1952,1416), "S15755C1.s15755c1f18");
    check_field_offset(lv, s15755c1f19, ABISELECT(2016,1480), "S15755C1.s15755c1f19");
    check_field_offset(lv, s15755c1f20, ABISELECT(2808,1952), "S15755C1.s15755c1f20");
    check_field_offset(lv, s15755c1f21, ABISELECT(3344,2280), "S15755C1.s15755c1f21");
    check_field_offset(lv, s15755c1f22, ABISELECT(3360,2288), "S15755C1.s15755c1f22");
  }
}
static Arrange_To_Call_Me vS15755C1(Test_S15755C1, "S15755C1", ABISELECT(3392,2320));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C2  {
  ::S17070C145 s17572c2f0;
  ::S17070C60 s17572c2f1[4];
  ::S17070C60 s17572c2f2[4];
  ::S17070C60 s17572c2f3;
  void  mf17572c2(); // _ZN8S17572C29mf17572c2Ev
};
//SIG(-1 S17572C2) C1{ m FC2{ m Fp[2]} FC3{ m Fi FC4{ m Fi[2]} Fi FC5{ m FC6{ m Fp[2]} Fi} Fi[2] FC7{ m FC6 FC8{ m Fp[2]}} FC5}[4] FC3[4] FC3}


void  S17572C2 ::mf17572c2(){}

static void Test_S17572C2()
{
  {
    init_simple_test("S17572C2");
    S17572C2 lv;
    check2(sizeof(lv), ABISELECT(952,584), "sizeof(S17572C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C2)");
    check_field_offset(lv, s17572c2f0, 0, "S17572C2.s17572c2f0");
    check_field_offset(lv, s17572c2f1, ABISELECT(16,8), "S17572C2.s17572c2f1");
    check_field_offset(lv, s17572c2f2, ABISELECT(432,264), "S17572C2.s17572c2f2");
    check_field_offset(lv, s17572c2f3, ABISELECT(848,520), "S17572C2.s17572c2f3");
  }
}
static Arrange_To_Call_Me vS17572C2(Test_S17572C2, "S17572C2", ABISELECT(952,584));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C11_nt  {
  void *s17572c11f0;
  int s17572c11f1[2];
  void  mf17572c11(); // _ZN12S17572C11_nt10mf17572c11Ev
};
//SIG(-1 S17572C11_nt) C1{ m Fp Fi[2]}


void  S17572C11_nt ::mf17572c11(){}

//skip512 S17572C11_nt

#else // __cplusplus

Class_Descriptor cd_S17572C11_nt = {  "S17572C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C14  {
  int s17572c14f0;
  ::S17070C7_nt s17572c14f1;
  int s17572c14f2;
  ::S17070C61 s17572c14f3;
  int s17572c14f4[2];
  ::S17070C63 s17572c14f5;
  ::S17070C61 s17572c14f6;
  void  mf17572c14(); // _ZN9S17572C1410mf17572c14Ev
};
//SIG(-1 S17572C14) C1{ m Fi FC2{ m Fi[2]} Fi FC3{ m FC4{ m Fp[2]} Fi} Fi[2] FC5{ m FC4 FC6{ m Fp[2]}} FC3}


void  S17572C14 ::mf17572c14(){}

static void Test_S17572C14()
{
  {
    init_simple_test("S17572C14");
    S17572C14 lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S17572C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C14)");
    check_field_offset(lv, s17572c14f0, 0, "S17572C14.s17572c14f0");
    check_field_offset(lv, s17572c14f1, 4, "S17572C14.s17572c14f1");
    check_field_offset(lv, s17572c14f2, 12, "S17572C14.s17572c14f2");
    check_field_offset(lv, s17572c14f3, 16, "S17572C14.s17572c14f3");
    check_field_offset(lv, s17572c14f4, ABISELECT(40,28), "S17572C14.s17572c14f4");
    check_field_offset(lv, s17572c14f5, ABISELECT(48,36), "S17572C14.s17572c14f5");
    check_field_offset(lv, s17572c14f6, ABISELECT(80,52), "S17572C14.s17572c14f6");
  }
}
static Arrange_To_Call_Me vS17572C14(Test_S17572C14, "S17572C14", ABISELECT(104,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C13  {
  ::S17572C14 s17572c13f0;
  int s17572c13f1[2];
  ::S17070C30_nt s17572c13f2;
  void  mf17572c13(); // _ZN9S17572C1310mf17572c13Ev
};
//SIG(-1 S17572C13) C1{ m FC2{ m Fi FC3{ m Fi[2]} Fi FC4{ m FC5{ m Fp[2]} Fi} Fi[2] FC6{ m FC5 FC7{ m Fp[2]}} FC4} Fi[2] FC8{ m Fp Fi[2] FC9{ m}}}


void  S17572C13 ::mf17572c13(){}

static void Test_S17572C13()
{
  {
    init_simple_test("S17572C13");
    S17572C13 lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S17572C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C13)");
    check_field_offset(lv, s17572c13f0, 0, "S17572C13.s17572c13f0");
    check_field_offset(lv, s17572c13f1, ABISELECT(104,64), "S17572C13.s17572c13f1");
    check_field_offset(lv, s17572c13f2, ABISELECT(112,72), "S17572C13.s17572c13f2");
  }
}
static Arrange_To_Call_Me vS17572C13(Test_S17572C13, "S17572C13", ABISELECT(136,88));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C12  {
  ::S17572C13 s17572c12f0;
  void  mf17572c12(); // _ZN9S17572C1210mf17572c12Ev
};
//SIG(-1 S17572C12) C1{ m FC2{ m FC3{ m Fi FC4{ m Fi[2]} Fi FC5{ m FC6{ m Fp[2]} Fi} Fi[2] FC7{ m FC6 FC8{ m Fp[2]}} FC5} Fi[2] FC9{ m Fp Fi[2] FC10{ m}}}}


void  S17572C12 ::mf17572c12(){}

static void Test_S17572C12()
{
  {
    init_simple_test("S17572C12");
    S17572C12 lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S17572C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C12)");
    check_field_offset(lv, s17572c12f0, 0, "S17572C12.s17572c12f0");
  }
}
static Arrange_To_Call_Me vS17572C12(Test_S17572C12, "S17572C12", ABISELECT(136,88));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C10  : S17572C11_nt {
  ::S17572C12 s17572c10f0;
};
//SIG(-1 S17572C10) C1{ BC2{ m Fp Fi[2]} FC3{ m FC4{ m FC5{ m Fi FC6{ m Fi[2]} Fi FC7{ m FC8{ m Fp[2]} Fi} Fi[2] FC9{ m FC8 FC10{ m Fp[2]}} FC7} Fi[2] FC11{ m Fp Fi[2] FC12{ m}}}}}



static void Test_S17572C10()
{
  extern Class_Descriptor cd_S17572C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,26)];
    init_test(&cd_S17572C10, buf);
    S17572C10 &lv = *(new (buf) S17572C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,100), "sizeof(S17572C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C10)");
    check_base_class_offset(lv, (S17572C11_nt*), 0, "S17572C10");
    check_field_offset(lv, s17572c10f0, ABISELECT(16,12), "S17572C10.s17572c10f0");
    test_class_info(&lv, &cd_S17572C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17572C10(Test_S17572C10, "S17572C10", ABISELECT(152,100));

#else // __cplusplus

extern Class_Descriptor cd_S17572C11_nt;
static Base_Class bases_S17572C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17572C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17572C10 = {  "S17572C10", // class name
  bases_S17572C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(152,100), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C28  : S17070C142 {
  ::S17070C76_nt s17572c28f0;
  ::S17070C74_nt s17572c28f1;
  ::S17070C74_nt s17572c28f2;
  ::S17070C74_nt s17572c28f3;
  ::S17070C74_nt s17572c28f4;
  virtual  ~S17572C28(); // _ZN9S17572C28D1Ev
  virtual void  v7(); // _ZN9S17572C282v7Ev
  virtual void  v8(); // _ZN9S17572C282v8Ev
  virtual void  v9(); // _ZN9S17572C282v9Ev
  virtual void  v10(); // _ZN9S17572C283v10Ev
  virtual void  v11(); // _ZN9S17572C283v11Ev
  virtual void  v12(); // _ZN9S17572C283v12Ev
  S17572C28(); // tgen
};
//SIG(-1 S17572C28) C1{ BC2{ m Fp[2]} vd v1 v2 v3 v4 v5 v6 FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ m Fp Fi FC7{ m}} FC6 FC6 FC6}


 S17572C28 ::~S17572C28(){ note_dtor("S17572C28", this);}
void  S17572C28 ::v7(){vfunc_called(this, "_ZN9S17572C282v7Ev");}
void  S17572C28 ::v8(){vfunc_called(this, "_ZN9S17572C282v8Ev");}
void  S17572C28 ::v9(){vfunc_called(this, "_ZN9S17572C282v9Ev");}
void  S17572C28 ::v10(){vfunc_called(this, "_ZN9S17572C283v10Ev");}
void  S17572C28 ::v11(){vfunc_called(this, "_ZN9S17572C283v11Ev");}
void  S17572C28 ::v12(){vfunc_called(this, "_ZN9S17572C283v12Ev");}
S17572C28 ::S17572C28(){ note_ctor("S17572C28", this);} // tgen

static void Test_S17572C28()
{
  extern Class_Descriptor cd_S17572C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,19)];
    init_test(&cd_S17572C28, buf);
    S17572C28 *dp, &lv = *(dp=new (buf) S17572C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,72), "sizeof(S17572C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C28)");
    check_base_class_offset(lv, (S17070C142*), ABISELECT(8,4), "S17572C28");
    check_field_offset(lv, s17572c28f0, ABISELECT(24,12), "S17572C28.s17572c28f0");
    check_field_offset(lv, s17572c28f1, ABISELECT(40,24), "S17572C28.s17572c28f1");
    check_field_offset(lv, s17572c28f2, ABISELECT(56,36), "S17572C28.s17572c28f2");
    check_field_offset(lv, s17572c28f3, ABISELECT(72,48), "S17572C28.s17572c28f3");
    check_field_offset(lv, s17572c28f4, ABISELECT(88,60), "S17572C28.s17572c28f4");
    test_class_info(&lv, &cd_S17572C28);
    dp->~S17572C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17572C28(Test_S17572C28, "S17572C28", ABISELECT(104,72));

#else // __cplusplus

extern void _ZN9S17572C28C1Ev();
extern void _ZN9S17572C28D1Ev();
Name_Map name_map_S17572C28[] = {
  NSPAIR(_ZN9S17572C28C1Ev),
  NSPAIR(_ZN9S17572C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C142;
extern VTBL_ENTRY _ZTI10S17070C142[];
static Base_Class bases_S17572C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C142,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17572C28[];
extern void _ZN9S17572C28D1Ev();
extern void _ZN9S17572C28D0Ev();
extern void _ZN9S17572C282v7Ev();
extern void _ZN9S17572C282v8Ev();
extern void _ZN9S17572C282v9Ev();
extern void _ZN9S17572C283v10Ev();
extern void _ZN9S17572C283v11Ev();
extern void _ZN9S17572C283v12Ev();
static  VTBL_ENTRY vtc_S17572C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17572C28[0]),
  (VTBL_ENTRY)&_ZN9S17572C28D1Ev,
  (VTBL_ENTRY)&_ZN9S17572C28D0Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v7Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v8Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v9Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v10Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v11Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v12Ev,
};
extern VTBL_ENTRY _ZTI9S17572C28[];
extern  VTBL_ENTRY _ZTV9S17572C28[];
Class_Descriptor cd_S17572C28 = {  "S17572C28", // class name
  bases_S17572C28, 1,
  &(vtc_S17572C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,72), // object size
  NSPAIRA(_ZTI9S17572C28),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S17572C28),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C34  {
  ::S15755C83 s17572c34f0;
  ::S17070C91 s17572c34f1;
  ::S17070C74_nt s17572c34f2;
  virtual  ~S17572C34(); // _ZN9S17572C34D1Ev
  virtual void  v14(); // _ZN9S17572C343v14Ev
  S17572C34(); // tgen
};
//SIG(-1 S17572C34) C1{ vd v1 FC2{ m Fp Fi[2] FC3{ m}} FC4{ m Fc FC5{ m Fi[3]} Fi[2]} FC6{ m Fp Fi FC3}}


 S17572C34 ::~S17572C34(){ note_dtor("S17572C34", this);}
void  S17572C34 ::v14(){vfunc_called(this, "_ZN9S17572C343v14Ev");}
S17572C34 ::S17572C34(){ note_ctor("S17572C34", this);} // tgen

static void Test_S17572C34()
{
  extern Class_Descriptor cd_S17572C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S17572C34, buf);
    S17572C34 *dp, &lv = *(dp=new (buf) S17572C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S17572C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C34)");
    check_field_offset(lv, s17572c34f0, ABISELECT(8,4), "S17572C34.s17572c34f0");
    check_field_offset(lv, s17572c34f1, ABISELECT(32,20), "S17572C34.s17572c34f1");
    check_field_offset(lv, s17572c34f2, ABISELECT(56,44), "S17572C34.s17572c34f2");
    test_class_info(&lv, &cd_S17572C34);
    dp->~S17572C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17572C34(Test_S17572C34, "S17572C34", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN9S17572C34C1Ev();
extern void _ZN9S17572C34D1Ev();
Name_Map name_map_S17572C34[] = {
  NSPAIR(_ZN9S17572C34C1Ev),
  NSPAIR(_ZN9S17572C34D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S17572C34[];
extern void _ZN9S17572C34D1Ev();
extern void _ZN9S17572C34D0Ev();
extern void _ZN9S17572C343v14Ev();
static  VTBL_ENTRY vtc_S17572C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17572C34[0]),
  (VTBL_ENTRY)&_ZN9S17572C34D1Ev,
  (VTBL_ENTRY)&_ZN9S17572C34D0Ev,
  (VTBL_ENTRY)&_ZN9S17572C343v14Ev,
};
extern VTBL_ENTRY _ZTI9S17572C34[];
extern  VTBL_ENTRY _ZTV9S17572C34[];
Class_Descriptor cd_S17572C34 = {  "S17572C34", // class name
  0,0,//no base classes
  &(vtc_S17572C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI9S17572C34),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S17572C34),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C63  {
  ::S17070C97 s17572c63f0;
  ::S17070C97 s17572c63f1;
  ::S17070C97 s17572c63f2;
  ::S17070C97 s17572c63f3;
  void  mf17572c63(); // _ZN9S17572C6310mf17572c63Ev
};
//SIG(-1 S17572C63) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC2 FC2 FC2}


void  S17572C63 ::mf17572c63(){}

static void Test_S17572C63()
{
  {
    init_simple_test("S17572C63");
    S17572C63 lv;
    check2(sizeof(lv), ABISELECT(96,48), "sizeof(S17572C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C63)");
    check_field_offset(lv, s17572c63f0, 0, "S17572C63.s17572c63f0");
    check_field_offset(lv, s17572c63f1, ABISELECT(24,12), "S17572C63.s17572c63f1");
    check_field_offset(lv, s17572c63f2, ABISELECT(48,24), "S17572C63.s17572c63f2");
    check_field_offset(lv, s17572c63f3, ABISELECT(72,36), "S17572C63.s17572c63f3");
  }
}
static Arrange_To_Call_Me vS17572C63(Test_S17572C63, "S17572C63", ABISELECT(96,48));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C61  : S17572C34 , S17070C136 {
  ::S17572C63 s17572c61f0;
  virtual void  v63(); // _ZN9S17572C613v63Ev
  ~S17572C61(); // tgen
  S17572C61(); // tgen
};
//SIG(-1 S17572C61) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC10 FC10 FC10}}


void  S17572C61 ::v63(){vfunc_called(this, "_ZN9S17572C613v63Ev");}
S17572C61 ::~S17572C61(){ note_dtor("S17572C61", this);} // tgen
S17572C61 ::S17572C61(){ note_ctor("S17572C61", this);} // tgen

static void Test_S17572C61()
{
  extern Class_Descriptor cd_S17572C61;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,29)];
    init_test(&cd_S17572C61, buf);
    S17572C61 *dp, &lv = *(dp=new (buf) S17572C61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,112), "sizeof(S17572C61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C61)");
    check_base_class_offset(lv, (S17572C34*), 0, "S17572C61");
    check_base_class_offset(lv, (S17070C136*), ABISELECT(72,56), "S17572C61");
    check_field_offset(lv, s17572c61f0, ABISELECT(88,64), "S17572C61.s17572c61f0");
    test_class_info(&lv, &cd_S17572C61);
    dp->~S17572C61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17572C61(Test_S17572C61, "S17572C61", ABISELECT(184,112));

#else // __cplusplus

extern void _ZN9S17572C61C1Ev();
extern void _ZN9S17572C61D1Ev();
Name_Map name_map_S17572C61[] = {
  NSPAIR(_ZN9S17572C61C1Ev),
  NSPAIR(_ZN9S17572C61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17572C34;
extern VTBL_ENTRY _ZTI9S17572C34[];
extern  VTBL_ENTRY _ZTV9S17572C34[];
extern Class_Descriptor cd_S17070C136;
extern VTBL_ENTRY _ZTI10S17070C136[];
static Base_Class bases_S17572C61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17572C34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C136,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17572C61[];
extern void _ZN9S17572C61D1Ev();
extern void _ZN9S17572C61D0Ev();
extern void _ZN9S17572C343v14Ev();
extern void _ZN9S17572C613v63Ev();
static  VTBL_ENTRY vtc_S17572C61[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17572C61[0]),
  (VTBL_ENTRY)&_ZN9S17572C61D1Ev,
  (VTBL_ENTRY)&_ZN9S17572C61D0Ev,
  (VTBL_ENTRY)&_ZN9S17572C343v14Ev,
  (VTBL_ENTRY)&_ZN9S17572C613v63Ev,
};
extern VTBL_ENTRY _ZTI9S17572C61[];
extern  VTBL_ENTRY _ZTV9S17572C61[];
Class_Descriptor cd_S17572C61 = {  "S17572C61", // class name
  bases_S17572C61, 2,
  &(vtc_S17572C61[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,112), // object size
  NSPAIRA(_ZTI9S17572C61),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17572C61),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C60  : S17572C28 {
  ::S17572C61 s17572c60f0;
  ::S17070C138 s17572c60f1;
  virtual void  v57(); // _ZN9S17572C603v57Ev
  virtual void  v58(); // _ZN9S17572C603v58Ev
  virtual void  v59(); // _ZN9S17572C603v59Ev
  virtual void  v60(); // _ZN9S17572C603v60Ev
  virtual void  v61(); // _ZN9S17572C603v61Ev
  virtual void  v62(); // _ZN9S17572C603v62Ev
  ~S17572C60(); // tgen
  S17572C60(); // tgen
};
//SIG(-1 S17572C60) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC16 FC16 FC16}} FC18{ m FC14}}


void  S17572C60 ::v57(){vfunc_called(this, "_ZN9S17572C603v57Ev");}
void  S17572C60 ::v58(){vfunc_called(this, "_ZN9S17572C603v58Ev");}
void  S17572C60 ::v59(){vfunc_called(this, "_ZN9S17572C603v59Ev");}
void  S17572C60 ::v60(){vfunc_called(this, "_ZN9S17572C603v60Ev");}
void  S17572C60 ::v61(){vfunc_called(this, "_ZN9S17572C603v61Ev");}
void  S17572C60 ::v62(){vfunc_called(this, "_ZN9S17572C603v62Ev");}
S17572C60 ::~S17572C60(){ note_dtor("S17572C60", this);} // tgen
S17572C60 ::S17572C60(){ note_ctor("S17572C60", this);} // tgen

static void Test_S17572C60()
{
  extern Class_Descriptor cd_S17572C60;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,49)];
    init_test(&cd_S17572C60, buf);
    S17572C60 *dp, &lv = *(dp=new (buf) S17572C60());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,192), "sizeof(S17572C60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C60)");
    check_base_class_offset(lv, (S17070C142*)(S17572C28*), ABISELECT(8,4), "S17572C60");
    check_base_class_offset(lv, (S17572C28*), 0, "S17572C60");
    check_field_offset(lv, s17572c60f0, ABISELECT(104,72), "S17572C60.s17572c60f0");
    check_field_offset(lv, s17572c60f1, ABISELECT(288,184), "S17572C60.s17572c60f1");
    test_class_info(&lv, &cd_S17572C60);
    dp->~S17572C60();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17572C60(Test_S17572C60, "S17572C60", ABISELECT(304,192));

#else // __cplusplus

extern void _ZN9S17572C60C1Ev();
extern void _ZN9S17572C60D1Ev();
Name_Map name_map_S17572C60[] = {
  NSPAIR(_ZN9S17572C60C1Ev),
  NSPAIR(_ZN9S17572C60D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C142;
extern VTBL_ENTRY _ZTI10S17070C142[];
extern Class_Descriptor cd_S17572C28;
extern VTBL_ENTRY _ZTI9S17572C28[];
extern  VTBL_ENTRY _ZTV9S17572C28[];
static Base_Class bases_S17572C60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C142,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17572C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17572C60[];
extern void _ZN9S17572C60D1Ev();
extern void _ZN9S17572C60D0Ev();
extern void _ZN9S17572C282v7Ev();
extern void _ZN9S17572C282v8Ev();
extern void _ZN9S17572C282v9Ev();
extern void _ZN9S17572C283v10Ev();
extern void _ZN9S17572C283v11Ev();
extern void _ZN9S17572C283v12Ev();
extern void _ZN9S17572C603v57Ev();
extern void _ZN9S17572C603v58Ev();
extern void _ZN9S17572C603v59Ev();
extern void _ZN9S17572C603v60Ev();
extern void _ZN9S17572C603v61Ev();
extern void _ZN9S17572C603v62Ev();
static  VTBL_ENTRY vtc_S17572C60[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17572C60[0]),
  (VTBL_ENTRY)&_ZN9S17572C60D1Ev,
  (VTBL_ENTRY)&_ZN9S17572C60D0Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v7Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v8Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v9Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v10Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v11Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v12Ev,
  (VTBL_ENTRY)&_ZN9S17572C603v57Ev,
  (VTBL_ENTRY)&_ZN9S17572C603v58Ev,
  (VTBL_ENTRY)&_ZN9S17572C603v59Ev,
  (VTBL_ENTRY)&_ZN9S17572C603v60Ev,
  (VTBL_ENTRY)&_ZN9S17572C603v61Ev,
  (VTBL_ENTRY)&_ZN9S17572C603v62Ev,
};
extern VTBL_ENTRY _ZTI9S17572C60[];
extern  VTBL_ENTRY _ZTV9S17572C60[];
Class_Descriptor cd_S17572C60 = {  "S17572C60", // class name
  bases_S17572C60, 2,
  &(vtc_S17572C60[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,192), // object size
  NSPAIRA(_ZTI9S17572C60),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17572C60),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C59  {
  ::S17572C60 s17572c59f0;
  ::S17572C61 s17572c59f1;
  void  mf17572c59(); // _ZN9S17572C5910mf17572c59Ev
};
//SIG(-1 S17572C59) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC17 FC17 FC17}} FC19{ m FC15}} FC10}


void  S17572C59 ::mf17572c59(){}

static void Test_S17572C59()
{
  {
    init_simple_test("S17572C59");
    S17572C59 lv;
    check2(sizeof(lv), ABISELECT(488,304), "sizeof(S17572C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C59)");
    check_field_offset(lv, s17572c59f0, 0, "S17572C59.s17572c59f0");
    check_field_offset(lv, s17572c59f1, ABISELECT(304,192), "S17572C59.s17572c59f1");
  }
}
static Arrange_To_Call_Me vS17572C59(Test_S17572C59, "S17572C59", ABISELECT(488,304));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C69  {
  ::S17070C97 s17572c69f0;
  ::S17070C97 s17572c69f1;
  ::S17070C97 s17572c69f2;
  ::S17070C97 s17572c69f3;
  ::S17070C95 s17572c69f4;
  ::S17070C97 s17572c69f5;
  ::S17070C97 s17572c69f6;
  ::S17070C97 s17572c69f7;
  ::S17070C97 s17572c69f8;
  ::S17070C97 s17572c69f9;
  void  mf17572c69(); // _ZN9S17572C6910mf17572c69Ev
};
//SIG(-1 S17572C69) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC2 FC2 FC2 FC4{ BC3 vd v15 v16 v17 v18 v19 v20 v21 FC5{ m FC6{ m FL[2]}} Fp} FC2 FC2 FC2 FC2 FC2}


void  S17572C69 ::mf17572c69(){}

static void Test_S17572C69()
{
  {
    init_simple_test("S17572C69");
    S17572C69 lv;
    check2(sizeof(lv), ABISELECT(248,132), "sizeof(S17572C69)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C69)");
    check_field_offset(lv, s17572c69f0, 0, "S17572C69.s17572c69f0");
    check_field_offset(lv, s17572c69f1, ABISELECT(24,12), "S17572C69.s17572c69f1");
    check_field_offset(lv, s17572c69f2, ABISELECT(48,24), "S17572C69.s17572c69f2");
    check_field_offset(lv, s17572c69f3, ABISELECT(72,36), "S17572C69.s17572c69f3");
    check_field_offset(lv, s17572c69f4, ABISELECT(96,48), "S17572C69.s17572c69f4");
    check_field_offset(lv, s17572c69f5, ABISELECT(128,72), "S17572C69.s17572c69f5");
    check_field_offset(lv, s17572c69f6, ABISELECT(152,84), "S17572C69.s17572c69f6");
    check_field_offset(lv, s17572c69f7, ABISELECT(176,96), "S17572C69.s17572c69f7");
    check_field_offset(lv, s17572c69f8, ABISELECT(200,108), "S17572C69.s17572c69f8");
    check_field_offset(lv, s17572c69f9, ABISELECT(224,120), "S17572C69.s17572c69f9");
  }
}
static Arrange_To_Call_Me vS17572C69(Test_S17572C69, "S17572C69", ABISELECT(248,132));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C67  : S17572C34 , S17070C128 {
  ::S17572C69 s17572c67f0;
  virtual void  v70(); // _ZN9S17572C673v70Ev
  ~S17572C67(); // tgen
  S17572C67(); // tgen
};
//SIG(-1 S17572C67) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC10 FC10 FC10 FC12{ BC11 vd v17 v18 v19 v20 v21 v22 v23 FC13{ m FC14{ m FL[2]}} Fp} FC10 FC10 FC10 FC10 FC10}}


void  S17572C67 ::v70(){vfunc_called(this, "_ZN9S17572C673v70Ev");}
S17572C67 ::~S17572C67(){ note_dtor("S17572C67", this);} // tgen
S17572C67 ::S17572C67(){ note_ctor("S17572C67", this);} // tgen

static void Test_S17572C67()
{
  extern Class_Descriptor cd_S17572C67;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,50)];
    init_test(&cd_S17572C67, buf);
    S17572C67 *dp, &lv = *(dp=new (buf) S17572C67());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,196), "sizeof(S17572C67)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C67)");
    check_base_class_offset(lv, (S17572C34*), 0, "S17572C67");
    check_base_class_offset(lv, (S17070C128*), ABISELECT(72,56), "S17572C67");
    check_field_offset(lv, s17572c67f0, ABISELECT(88,64), "S17572C67.s17572c67f0");
    test_class_info(&lv, &cd_S17572C67);
    dp->~S17572C67();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17572C67(Test_S17572C67, "S17572C67", ABISELECT(336,196));

#else // __cplusplus

extern void _ZN9S17572C67C1Ev();
extern void _ZN9S17572C67D1Ev();
Name_Map name_map_S17572C67[] = {
  NSPAIR(_ZN9S17572C67C1Ev),
  NSPAIR(_ZN9S17572C67D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17572C34;
extern VTBL_ENTRY _ZTI9S17572C34[];
extern  VTBL_ENTRY _ZTV9S17572C34[];
extern Class_Descriptor cd_S17070C128;
extern VTBL_ENTRY _ZTI10S17070C128[];
static Base_Class bases_S17572C67[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17572C34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C128,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17572C67[];
extern void _ZN9S17572C67D1Ev();
extern void _ZN9S17572C67D0Ev();
extern void _ZN9S17572C343v14Ev();
extern void _ZN9S17572C673v70Ev();
static  VTBL_ENTRY vtc_S17572C67[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17572C67[0]),
  (VTBL_ENTRY)&_ZN9S17572C67D1Ev,
  (VTBL_ENTRY)&_ZN9S17572C67D0Ev,
  (VTBL_ENTRY)&_ZN9S17572C343v14Ev,
  (VTBL_ENTRY)&_ZN9S17572C673v70Ev,
};
extern VTBL_ENTRY _ZTI9S17572C67[];
extern  VTBL_ENTRY _ZTV9S17572C67[];
Class_Descriptor cd_S17572C67 = {  "S17572C67", // class name
  bases_S17572C67, 2,
  &(vtc_S17572C67[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,196), // object size
  NSPAIRA(_ZTI9S17572C67),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17572C67),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C66  : S17572C28 {
  ::S17572C67 s17572c66f0;
  ::S17070C124 s17572c66f1;
  virtual void  v64(); // _ZN9S17572C663v64Ev
  virtual void  v65(); // _ZN9S17572C663v65Ev
  virtual void  v66(); // _ZN9S17572C663v66Ev
  virtual void  v67(); // _ZN9S17572C663v67Ev
  virtual void  v68(); // _ZN9S17572C663v68Ev
  virtual void  v69(); // _ZN9S17572C663v69Ev
  ~S17572C66(); // tgen
  S17572C66(); // tgen
};
//SIG(-1 S17572C66) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC16 FC16 FC16 FC18{ BC17 vd v29 v30 v31 v32 v33 v34 v35 FC19{ m FC20{ m FL[2]}} Fp} FC16 FC16 FC16 FC16 FC16}} FC21{ m FC22{ m Fp[2]}}}


void  S17572C66 ::v64(){vfunc_called(this, "_ZN9S17572C663v64Ev");}
void  S17572C66 ::v65(){vfunc_called(this, "_ZN9S17572C663v65Ev");}
void  S17572C66 ::v66(){vfunc_called(this, "_ZN9S17572C663v66Ev");}
void  S17572C66 ::v67(){vfunc_called(this, "_ZN9S17572C663v67Ev");}
void  S17572C66 ::v68(){vfunc_called(this, "_ZN9S17572C663v68Ev");}
void  S17572C66 ::v69(){vfunc_called(this, "_ZN9S17572C663v69Ev");}
S17572C66 ::~S17572C66(){ note_dtor("S17572C66", this);} // tgen
S17572C66 ::S17572C66(){ note_ctor("S17572C66", this);} // tgen

static void Test_S17572C66()
{
  extern Class_Descriptor cd_S17572C66;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(58,70)];
    init_test(&cd_S17572C66, buf);
    S17572C66 *dp, &lv = *(dp=new (buf) S17572C66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(456,276), "sizeof(S17572C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C66)");
    check_base_class_offset(lv, (S17070C142*)(S17572C28*), ABISELECT(8,4), "S17572C66");
    check_base_class_offset(lv, (S17572C28*), 0, "S17572C66");
    check_field_offset(lv, s17572c66f0, ABISELECT(104,72), "S17572C66.s17572c66f0");
    check_field_offset(lv, s17572c66f1, ABISELECT(440,268), "S17572C66.s17572c66f1");
    test_class_info(&lv, &cd_S17572C66);
    dp->~S17572C66();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17572C66(Test_S17572C66, "S17572C66", ABISELECT(456,276));

#else // __cplusplus

extern void _ZN9S17572C66C1Ev();
extern void _ZN9S17572C66D1Ev();
Name_Map name_map_S17572C66[] = {
  NSPAIR(_ZN9S17572C66C1Ev),
  NSPAIR(_ZN9S17572C66D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C142;
extern VTBL_ENTRY _ZTI10S17070C142[];
extern Class_Descriptor cd_S17572C28;
extern VTBL_ENTRY _ZTI9S17572C28[];
extern  VTBL_ENTRY _ZTV9S17572C28[];
static Base_Class bases_S17572C66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C142,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17572C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17572C66[];
extern void _ZN9S17572C66D1Ev();
extern void _ZN9S17572C66D0Ev();
extern void _ZN9S17572C282v7Ev();
extern void _ZN9S17572C282v8Ev();
extern void _ZN9S17572C282v9Ev();
extern void _ZN9S17572C283v10Ev();
extern void _ZN9S17572C283v11Ev();
extern void _ZN9S17572C283v12Ev();
extern void _ZN9S17572C663v64Ev();
extern void _ZN9S17572C663v65Ev();
extern void _ZN9S17572C663v66Ev();
extern void _ZN9S17572C663v67Ev();
extern void _ZN9S17572C663v68Ev();
extern void _ZN9S17572C663v69Ev();
static  VTBL_ENTRY vtc_S17572C66[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17572C66[0]),
  (VTBL_ENTRY)&_ZN9S17572C66D1Ev,
  (VTBL_ENTRY)&_ZN9S17572C66D0Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v7Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v8Ev,
  (VTBL_ENTRY)&_ZN9S17572C282v9Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v10Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v11Ev,
  (VTBL_ENTRY)&_ZN9S17572C283v12Ev,
  (VTBL_ENTRY)&_ZN9S17572C663v64Ev,
  (VTBL_ENTRY)&_ZN9S17572C663v65Ev,
  (VTBL_ENTRY)&_ZN9S17572C663v66Ev,
  (VTBL_ENTRY)&_ZN9S17572C663v67Ev,
  (VTBL_ENTRY)&_ZN9S17572C663v68Ev,
  (VTBL_ENTRY)&_ZN9S17572C663v69Ev,
};
extern VTBL_ENTRY _ZTI9S17572C66[];
extern  VTBL_ENTRY _ZTV9S17572C66[];
Class_Descriptor cd_S17572C66 = {  "S17572C66", // class name
  bases_S17572C66, 2,
  &(vtc_S17572C66[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(456,276), // object size
  NSPAIRA(_ZTI9S17572C66),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17572C66),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C65  {
  ::S17572C66 s17572c65f0;
  ::S17572C67 s17572c65f1;
  void  mf17572c65(); // _ZN9S17572C6510mf17572c65Ev
};
//SIG(-1 S17572C65) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC17 FC17 FC17 FC19{ BC18 vd v29 v30 v31 v32 v33 v34 v35 FC20{ m FC21{ m FL[2]}} Fp} FC17 FC17 FC17 FC17 FC17}} FC22{ m FC23{ m Fp[2]}}} FC10}


void  S17572C65 ::mf17572c65(){}

static void Test_S17572C65()
{
  {
    init_simple_test("S17572C65");
    S17572C65 lv;
    check2(sizeof(lv), ABISELECT(792,472), "sizeof(S17572C65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C65)");
    check_field_offset(lv, s17572c65f0, 0, "S17572C65.s17572c65f0");
    check_field_offset(lv, s17572c65f1, ABISELECT(456,276), "S17572C65.s17572c65f1");
  }
}
static Arrange_To_Call_Me vS17572C65(Test_S17572C65, "S17572C65", ABISELECT(792,472));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17572C1  {
  void *s17572c1f0;
  ::S17572C2 s17572c1f1;
  ::S17572C10 s17572c1f2;
  int s17572c1f3;
  void *s17572c1f4;
  ::S17070C71 s17572c1f5;
  ::S17070C71 s17572c1f6;
  ::S17070C80 s17572c1f7;
  ::S17070C99 s17572c1f8;
  ::S17070C80 s17572c1f9;
  ::S17070C80 s17572c1f10;
  ::S17070C99 s17572c1f11;
  ::S17572C59 s17572c1f12;
  ::S17572C65 s17572c1f13;
  ::S17070C80 s17572c1f14;
  ::S17070C99 s17572c1f15;
  ::S17070C122 s17572c1f16;
  ::S17070C116 s17572c1f17;
  ::S17070C116 s17572c1f18;
  ::S17070C110 s17572c1f19;
  int s17572c1f20;
  ::S17070C23_nt s17572c1f21;
  char s17572c1f22[3];
  int s17572c1f23;
  ::S17070C102 s17572c1f24;
  ::S17070C20_nt s17572c1f25;
  ::S17070C21_nt s17572c1f26;
  ::S17070C21_nt s17572c1f27;
  ::S17070C21_nt s17572c1f28;
  ::S17070C21_nt s17572c1f29;
  void  mf17572c1(); // _ZN8S17572C19mf17572c1Ev
};
//SIG(1 S17572C1) C1{ m Fp FC2{ m FC3{ m Fp[2]} FC4{ m Fi FC5{ m Fi[2]} Fi FC6{ m FC7{ m Fp[2]} Fi} Fi[2] FC8{ m FC7 FC9{ m Fp[2]}} FC6}[4] FC4[4] FC4} FC10{ BC11{ m Fp Fi[2]} FC12{ m FC13{ m FC14{ m Fi FC5 Fi FC6 Fi[2] FC8 FC6} Fi[2] FC15{ m Fp Fi[2] FC16{ m}}}}} Fi Fp FC17{ m FC18{ m FC19{ m Fp[2]}} FC20{ m Fp Fi FC16} FC21{ BC22{ m Fp Fi FC23{ m} FC23}} FC20 FC20 Fc[2] Fi} FC17 FC24{ m FC25{ BC26{ BC27{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC21 FC20 FC20 FC20 FC20} v1 v2 v3 v4 v5 v6 FC28{ BC29{ vd v14 FC15 FC30{ m Fc FC31{ m Fi[3]} Fi[2]} FC20} BC32{ m Fp[2]} v13 FC33{ m FC34{ BC35{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC36{ m FC37{ m FL[2]}} Fp} FC38{ BC35 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC38 FC38 FC38 FC38 FC38 FC38 FC38 FC38}} FC39{ m FC32}} FC28} FC40{ m FC41{ BC26 v36 v37 v38 v39 v40 v41 FC42{ BC29 BC43{ m Fp[2]} v42 FC44{ m FC45{ BC35 vd v43 v44 v45 v46 v47 v48 v49 FC46{ m FC47{ m FL}} Fp} FC38 FC34 FC34 FC34 FC38}} FC39} FC42} FC24 FC24 FC40 FC48{ m FC49{ BC50{ BC51{ m Fp[2]} vd v56 v57 v58 v59 v60 v61 FC21 FC20 FC20 FC20 FC20} v50 v51 v52 v53 v54 v55 FC52{ BC53{ vd v63 FC54{ m Fp Fi[2] FC16} FC30 FC20} BC55{ m Fp[2]} v62 FC56{ m FC38 FC38 FC38 FC38}} FC57{ m FC55}} FC52} FC58{ m FC59{ BC50 v64 v65 v66 v67 v68 v69 FC60{ BC53 BC61{ m Fp[2]} v70 FC62{ m FC38 FC38 FC38 FC38 FC34 FC38 FC38 FC38 FC38 FC38}} FC63{ m FC64{ m Fp[2]}}} FC60} FC24 FC40 FC64 FC65{ m Fp[2]} FC65 FC66{ m Fp[2]} Fi FC46 Fc[3] Fi FC43 FC67{ m FC68{ m Fp[2]} FC69{ m Fp}} FC69 FC69 FC69 FC69}


void  S17572C1 ::mf17572c1(){}

static void Test_S17572C1()
{
  {
    init_simple_test("S17572C1");
    S17572C1 lv;
    check2(sizeof(lv), ABISELECT(7808,4872), "sizeof(S17572C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17572C1)");
    check_field_offset(lv, s17572c1f0, 0, "S17572C1.s17572c1f0");
    check_field_offset(lv, s17572c1f1, ABISELECT(8,4), "S17572C1.s17572c1f1");
    check_field_offset(lv, s17572c1f2, ABISELECT(960,588), "S17572C1.s17572c1f2");
    check_field_offset(lv, s17572c1f3, ABISELECT(1112,688), "S17572C1.s17572c1f3");
    check_field_offset(lv, s17572c1f4, ABISELECT(1120,692), "S17572C1.s17572c1f4");
    check_field_offset(lv, s17572c1f5, ABISELECT(1128,696), "S17572C1.s17572c1f5");
    check_field_offset(lv, s17572c1f6, ABISELECT(1216,760), "S17572C1.s17572c1f6");
    check_field_offset(lv, s17572c1f7, ABISELECT(1304,824), "S17572C1.s17572c1f7");
    check_field_offset(lv, s17572c1f8, ABISELECT(2096,1296), "S17572C1.s17572c1f8");
    check_field_offset(lv, s17572c1f9, ABISELECT(2728,1728), "S17572C1.s17572c1f9");
    check_field_offset(lv, s17572c1f10, ABISELECT(3520,2200), "S17572C1.s17572c1f10");
    check_field_offset(lv, s17572c1f11, ABISELECT(4312,2672), "S17572C1.s17572c1f11");
    check_field_offset(lv, s17572c1f12, ABISELECT(4944,3104), "S17572C1.s17572c1f12");
    check_field_offset(lv, s17572c1f13, ABISELECT(5432,3408), "S17572C1.s17572c1f13");
    check_field_offset(lv, s17572c1f14, ABISELECT(6224,3880), "S17572C1.s17572c1f14");
    check_field_offset(lv, s17572c1f15, ABISELECT(7016,4352), "S17572C1.s17572c1f15");
    check_field_offset(lv, s17572c1f16, ABISELECT(7648,4784), "S17572C1.s17572c1f16");
    check_field_offset(lv, s17572c1f17, ABISELECT(7664,4792), "S17572C1.s17572c1f17");
    check_field_offset(lv, s17572c1f18, ABISELECT(7680,4800), "S17572C1.s17572c1f18");
    check_field_offset(lv, s17572c1f19, ABISELECT(7696,4808), "S17572C1.s17572c1f19");
    check_field_offset(lv, s17572c1f20, ABISELECT(7712,4816), "S17572C1.s17572c1f20");
    check_field_offset(lv, s17572c1f21, ABISELECT(7720,4820), "S17572C1.s17572c1f21");
    check_field_offset(lv, s17572c1f22, ABISELECT(7728,4828), "S17572C1.s17572c1f22");
    check_field_offset(lv, s17572c1f23, ABISELECT(7732,4832), "S17572C1.s17572c1f23");
    check_field_offset(lv, s17572c1f24, ABISELECT(7736,4836), "S17572C1.s17572c1f24");
    check_field_offset(lv, s17572c1f25, ABISELECT(7752,4844), "S17572C1.s17572c1f25");
    check_field_offset(lv, s17572c1f26, ABISELECT(7776,4856), "S17572C1.s17572c1f26");
    check_field_offset(lv, s17572c1f27, ABISELECT(7784,4860), "S17572C1.s17572c1f27");
    check_field_offset(lv, s17572c1f28, ABISELECT(7792,4864), "S17572C1.s17572c1f28");
    check_field_offset(lv, s17572c1f29, ABISELECT(7800,4868), "S17572C1.s17572c1f29");
  }
}
static Arrange_To_Call_Me vS17572C1(Test_S17572C1, "S17572C1", ABISELECT(7808,4872));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C25  : S17070C116 {
  ::S17070C76_nt s22005c25f0;
  ::S17070C74_nt s22005c25f1;
  ::S17070C74_nt s22005c25f2;
  ::S17070C74_nt s22005c25f3;
  ::S17070C74_nt s22005c25f4;
  virtual  ~S22005C25(); // _ZN9S22005C25D1Ev
  virtual void  v11(); // _ZN9S22005C253v11Ev
  virtual void  v12(); // _ZN9S22005C253v12Ev
  virtual void  v13(); // _ZN9S22005C253v13Ev
  virtual void  v14(); // _ZN9S22005C253v14Ev
  virtual void  v15(); // _ZN9S22005C253v15Ev
  virtual void  v16(); // _ZN9S22005C253v16Ev
  S22005C25(); // tgen
};
//SIG(-1 S22005C25) C1{ BC2{ m Fp[2]} vd v1 v2 v3 v4 v5 v6 FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ m Fp Fi FC7{ m}} FC6 FC6 FC6}


 S22005C25 ::~S22005C25(){ note_dtor("S22005C25", this);}
void  S22005C25 ::v11(){vfunc_called(this, "_ZN9S22005C253v11Ev");}
void  S22005C25 ::v12(){vfunc_called(this, "_ZN9S22005C253v12Ev");}
void  S22005C25 ::v13(){vfunc_called(this, "_ZN9S22005C253v13Ev");}
void  S22005C25 ::v14(){vfunc_called(this, "_ZN9S22005C253v14Ev");}
void  S22005C25 ::v15(){vfunc_called(this, "_ZN9S22005C253v15Ev");}
void  S22005C25 ::v16(){vfunc_called(this, "_ZN9S22005C253v16Ev");}
S22005C25 ::S22005C25(){ note_ctor("S22005C25", this);} // tgen

static void Test_S22005C25()
{
  extern Class_Descriptor cd_S22005C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,19)];
    init_test(&cd_S22005C25, buf);
    S22005C25 *dp, &lv = *(dp=new (buf) S22005C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,72), "sizeof(S22005C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C25)");
    check_base_class_offset(lv, (S17070C116*), ABISELECT(8,4), "S22005C25");
    check_field_offset(lv, s22005c25f0, ABISELECT(24,12), "S22005C25.s22005c25f0");
    check_field_offset(lv, s22005c25f1, ABISELECT(40,24), "S22005C25.s22005c25f1");
    check_field_offset(lv, s22005c25f2, ABISELECT(56,36), "S22005C25.s22005c25f2");
    check_field_offset(lv, s22005c25f3, ABISELECT(72,48), "S22005C25.s22005c25f3");
    check_field_offset(lv, s22005c25f4, ABISELECT(88,60), "S22005C25.s22005c25f4");
    test_class_info(&lv, &cd_S22005C25);
    dp->~S22005C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS22005C25(Test_S22005C25, "S22005C25", ABISELECT(104,72));

#else // __cplusplus

extern void _ZN9S22005C25C1Ev();
extern void _ZN9S22005C25D1Ev();
Name_Map name_map_S22005C25[] = {
  NSPAIR(_ZN9S22005C25C1Ev),
  NSPAIR(_ZN9S22005C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C116;
extern VTBL_ENTRY _ZTI10S17070C116[];
static Base_Class bases_S22005C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C116,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S22005C25[];
extern void _ZN9S22005C25D1Ev();
extern void _ZN9S22005C25D0Ev();
extern void _ZN9S22005C253v11Ev();
extern void _ZN9S22005C253v12Ev();
extern void _ZN9S22005C253v13Ev();
extern void _ZN9S22005C253v14Ev();
extern void _ZN9S22005C253v15Ev();
extern void _ZN9S22005C253v16Ev();
static  VTBL_ENTRY vtc_S22005C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S22005C25[0]),
  (VTBL_ENTRY)&_ZN9S22005C25D1Ev,
  (VTBL_ENTRY)&_ZN9S22005C25D0Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v11Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v12Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v13Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v14Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v15Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v16Ev,
};
extern VTBL_ENTRY _ZTI9S22005C25[];
extern  VTBL_ENTRY _ZTV9S22005C25[];
Class_Descriptor cd_S22005C25 = {  "S22005C25", // class name
  bases_S22005C25, 1,
  &(vtc_S22005C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,72), // object size
  NSPAIRA(_ZTI9S22005C25),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S22005C25),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C31  {
  ::S17070C30_nt s22005c31f0;
  ::S17070C91 s22005c31f1;
  ::S17070C74_nt s22005c31f2;
  virtual  ~S22005C31(); // _ZN9S22005C31D1Ev
  virtual void  v18(); // _ZN9S22005C313v18Ev
  S22005C31(); // tgen
};
//SIG(-1 S22005C31) C1{ vd v1 FC2{ m Fp Fi[2] FC3{ m}} FC4{ m Fc FC5{ m Fi[3]} Fi[2]} FC6{ m Fp Fi FC3}}


 S22005C31 ::~S22005C31(){ note_dtor("S22005C31", this);}
void  S22005C31 ::v18(){vfunc_called(this, "_ZN9S22005C313v18Ev");}
S22005C31 ::S22005C31(){ note_ctor("S22005C31", this);} // tgen

static void Test_S22005C31()
{
  extern Class_Descriptor cd_S22005C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S22005C31, buf);
    S22005C31 *dp, &lv = *(dp=new (buf) S22005C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S22005C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C31)");
    check_field_offset(lv, s22005c31f0, ABISELECT(8,4), "S22005C31.s22005c31f0");
    check_field_offset(lv, s22005c31f1, ABISELECT(32,20), "S22005C31.s22005c31f1");
    check_field_offset(lv, s22005c31f2, ABISELECT(56,44), "S22005C31.s22005c31f2");
    test_class_info(&lv, &cd_S22005C31);
    dp->~S22005C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS22005C31(Test_S22005C31, "S22005C31", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN9S22005C31C1Ev();
extern void _ZN9S22005C31D1Ev();
Name_Map name_map_S22005C31[] = {
  NSPAIR(_ZN9S22005C31C1Ev),
  NSPAIR(_ZN9S22005C31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S22005C31[];
extern void _ZN9S22005C31D1Ev();
extern void _ZN9S22005C31D0Ev();
extern void _ZN9S22005C313v18Ev();
static  VTBL_ENTRY vtc_S22005C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S22005C31[0]),
  (VTBL_ENTRY)&_ZN9S22005C31D1Ev,
  (VTBL_ENTRY)&_ZN9S22005C31D0Ev,
  (VTBL_ENTRY)&_ZN9S22005C313v18Ev,
};
extern VTBL_ENTRY _ZTI9S22005C31[];
extern  VTBL_ENTRY _ZTV9S22005C31[];
Class_Descriptor cd_S22005C31 = {  "S22005C31", // class name
  0,0,//no base classes
  &(vtc_S22005C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI9S22005C31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S22005C31),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C60  {
  ::S17070C97 s22005c60f0;
  ::S17070C97 s22005c60f1;
  ::S17070C97 s22005c60f2;
  ::S17070C97 s22005c60f3;
  ::S17070C97 s22005c60f4;
  ::S17070C95 s22005c60f5;
  ::S17070C130 s22005c60f6;
  ::S17070C97 s22005c60f7;
  ::S17070C97 s22005c60f8;
  ::S17070C97 s22005c60f9;
  ::S17070C97 s22005c60f10;
  ::S17070C97 s22005c60f11;
  ::S17070C97 s22005c60f12;
  ::S17070C97 s22005c60f13;
  ::S17070C97 s22005c60f14;
  ::S17070C97 s22005c60f15;
  ::S17070C97 s22005c60f16;
  ::S17070C97 s22005c60f17;
  ::S17070C97 s22005c60f18;
  ::S17070C97 s22005c60f19;
  ::S17070C97 s22005c60f20;
  void  mf22005c60(); // _ZN9S22005C6010mf22005c60Ev
};
//SIG(-1 S22005C60) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC2 FC2 FC2 FC2 FC4{ BC3 vd v15 v16 v17 v18 v19 v20 v21 FC5{ m FC6{ m FL[2]}} Fp} FC7{ BC3 vd v22 v23 v24 v25 v26 v27 v28 FC8{ m FC5} Fp} FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2}


void  S22005C60 ::mf22005c60(){}

static void Test_S22005C60()
{
  {
    init_simple_test("S22005C60");
    S22005C60 lv;
    check2(sizeof(lv), ABISELECT(520,276), "sizeof(S22005C60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C60)");
    check_field_offset(lv, s22005c60f0, 0, "S22005C60.s22005c60f0");
    check_field_offset(lv, s22005c60f1, ABISELECT(24,12), "S22005C60.s22005c60f1");
    check_field_offset(lv, s22005c60f2, ABISELECT(48,24), "S22005C60.s22005c60f2");
    check_field_offset(lv, s22005c60f3, ABISELECT(72,36), "S22005C60.s22005c60f3");
    check_field_offset(lv, s22005c60f4, ABISELECT(96,48), "S22005C60.s22005c60f4");
    check_field_offset(lv, s22005c60f5, ABISELECT(120,60), "S22005C60.s22005c60f5");
    check_field_offset(lv, s22005c60f6, ABISELECT(152,84), "S22005C60.s22005c60f6");
    check_field_offset(lv, s22005c60f7, ABISELECT(184,108), "S22005C60.s22005c60f7");
    check_field_offset(lv, s22005c60f8, ABISELECT(208,120), "S22005C60.s22005c60f8");
    check_field_offset(lv, s22005c60f9, ABISELECT(232,132), "S22005C60.s22005c60f9");
    check_field_offset(lv, s22005c60f10, ABISELECT(256,144), "S22005C60.s22005c60f10");
    check_field_offset(lv, s22005c60f11, ABISELECT(280,156), "S22005C60.s22005c60f11");
    check_field_offset(lv, s22005c60f12, ABISELECT(304,168), "S22005C60.s22005c60f12");
    check_field_offset(lv, s22005c60f13, ABISELECT(328,180), "S22005C60.s22005c60f13");
    check_field_offset(lv, s22005c60f14, ABISELECT(352,192), "S22005C60.s22005c60f14");
    check_field_offset(lv, s22005c60f15, ABISELECT(376,204), "S22005C60.s22005c60f15");
    check_field_offset(lv, s22005c60f16, ABISELECT(400,216), "S22005C60.s22005c60f16");
    check_field_offset(lv, s22005c60f17, ABISELECT(424,228), "S22005C60.s22005c60f17");
    check_field_offset(lv, s22005c60f18, ABISELECT(448,240), "S22005C60.s22005c60f18");
    check_field_offset(lv, s22005c60f19, ABISELECT(472,252), "S22005C60.s22005c60f19");
    check_field_offset(lv, s22005c60f20, ABISELECT(496,264), "S22005C60.s22005c60f20");
  }
}
static Arrange_To_Call_Me vS22005C60(Test_S22005C60, "S22005C60", ABISELECT(520,276));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C58  : S22005C31 , S17070C110 {
  ::S22005C60 s22005c58f0;
  virtual void  v67(); // _ZN9S22005C583v67Ev
  ~S22005C58(); // tgen
  S22005C58(); // tgen
};
//SIG(-1 S22005C58) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC10 FC10 FC10 FC10 FC12{ BC11 vd v17 v18 v19 v20 v21 v22 v23 FC13{ m FC14{ m FL[2]}} Fp} FC15{ BC11 vd v24 v25 v26 v27 v28 v29 v30 FC16{ m FC13} Fp} FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10}}


void  S22005C58 ::v67(){vfunc_called(this, "_ZN9S22005C583v67Ev");}
S22005C58 ::~S22005C58(){ note_dtor("S22005C58", this);} // tgen
S22005C58 ::S22005C58(){ note_ctor("S22005C58", this);} // tgen

static void Test_S22005C58()
{
  extern Class_Descriptor cd_S22005C58;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(77,86)];
    init_test(&cd_S22005C58, buf);
    S22005C58 *dp, &lv = *(dp=new (buf) S22005C58());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,340), "sizeof(S22005C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C58)");
    check_base_class_offset(lv, (S22005C31*), 0, "S22005C58");
    check_base_class_offset(lv, (S17070C110*), ABISELECT(72,56), "S22005C58");
    check_field_offset(lv, s22005c58f0, ABISELECT(88,64), "S22005C58.s22005c58f0");
    test_class_info(&lv, &cd_S22005C58);
    dp->~S22005C58();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS22005C58(Test_S22005C58, "S22005C58", ABISELECT(608,340));

#else // __cplusplus

extern void _ZN9S22005C58C1Ev();
extern void _ZN9S22005C58D1Ev();
Name_Map name_map_S22005C58[] = {
  NSPAIR(_ZN9S22005C58C1Ev),
  NSPAIR(_ZN9S22005C58D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S22005C31;
extern VTBL_ENTRY _ZTI9S22005C31[];
extern  VTBL_ENTRY _ZTV9S22005C31[];
extern Class_Descriptor cd_S17070C110;
extern VTBL_ENTRY _ZTI10S17070C110[];
static Base_Class bases_S22005C58[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S22005C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C110,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S22005C58[];
extern void _ZN9S22005C58D1Ev();
extern void _ZN9S22005C58D0Ev();
extern void _ZN9S22005C313v18Ev();
extern void _ZN9S22005C583v67Ev();
static  VTBL_ENTRY vtc_S22005C58[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S22005C58[0]),
  (VTBL_ENTRY)&_ZN9S22005C58D1Ev,
  (VTBL_ENTRY)&_ZN9S22005C58D0Ev,
  (VTBL_ENTRY)&_ZN9S22005C313v18Ev,
  (VTBL_ENTRY)&_ZN9S22005C583v67Ev,
};
extern VTBL_ENTRY _ZTI9S22005C58[];
extern  VTBL_ENTRY _ZTV9S22005C58[];
Class_Descriptor cd_S22005C58 = {  "S22005C58", // class name
  bases_S22005C58, 2,
  &(vtc_S22005C58[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,340), // object size
  NSPAIRA(_ZTI9S22005C58),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S22005C58),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C57  : S22005C25 {
  ::S22005C58 s22005c57f0;
  ::S17070C138 s22005c57f1;
  virtual void  v61(); // _ZN9S22005C573v61Ev
  virtual void  v62(); // _ZN9S22005C573v62Ev
  virtual void  v63(); // _ZN9S22005C573v63Ev
  virtual void  v64(); // _ZN9S22005C573v64Ev
  virtual void  v65(); // _ZN9S22005C573v65Ev
  virtual void  v66(); // _ZN9S22005C573v66Ev
  ~S22005C57(); // tgen
  S22005C57(); // tgen
};
//SIG(-1 S22005C57) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC16 FC16 FC16 FC16 FC18{ BC17 vd v29 v30 v31 v32 v33 v34 v35 FC19{ m FC20{ m FL[2]}} Fp} FC21{ BC17 vd v36 v37 v38 v39 v40 v41 v42 FC22{ m FC19} Fp} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16}} FC23{ m FC24{ m Fp[2]}}}


void  S22005C57 ::v61(){vfunc_called(this, "_ZN9S22005C573v61Ev");}
void  S22005C57 ::v62(){vfunc_called(this, "_ZN9S22005C573v62Ev");}
void  S22005C57 ::v63(){vfunc_called(this, "_ZN9S22005C573v63Ev");}
void  S22005C57 ::v64(){vfunc_called(this, "_ZN9S22005C573v64Ev");}
void  S22005C57 ::v65(){vfunc_called(this, "_ZN9S22005C573v65Ev");}
void  S22005C57 ::v66(){vfunc_called(this, "_ZN9S22005C573v66Ev");}
S22005C57 ::~S22005C57(){ note_dtor("S22005C57", this);} // tgen
S22005C57 ::S22005C57(){ note_ctor("S22005C57", this);} // tgen

static void Test_S22005C57()
{
  extern Class_Descriptor cd_S22005C57;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(92,106)];
    init_test(&cd_S22005C57, buf);
    S22005C57 *dp, &lv = *(dp=new (buf) S22005C57());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(728,420), "sizeof(S22005C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C57)");
    check_base_class_offset(lv, (S17070C116*)(S22005C25*), ABISELECT(8,4), "S22005C57");
    check_base_class_offset(lv, (S22005C25*), 0, "S22005C57");
    check_field_offset(lv, s22005c57f0, ABISELECT(104,72), "S22005C57.s22005c57f0");
    check_field_offset(lv, s22005c57f1, ABISELECT(712,412), "S22005C57.s22005c57f1");
    test_class_info(&lv, &cd_S22005C57);
    dp->~S22005C57();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS22005C57(Test_S22005C57, "S22005C57", ABISELECT(728,420));

#else // __cplusplus

extern void _ZN9S22005C57C1Ev();
extern void _ZN9S22005C57D1Ev();
Name_Map name_map_S22005C57[] = {
  NSPAIR(_ZN9S22005C57C1Ev),
  NSPAIR(_ZN9S22005C57D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C116;
extern VTBL_ENTRY _ZTI10S17070C116[];
extern Class_Descriptor cd_S22005C25;
extern VTBL_ENTRY _ZTI9S22005C25[];
extern  VTBL_ENTRY _ZTV9S22005C25[];
static Base_Class bases_S22005C57[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C116,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S22005C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S22005C57[];
extern void _ZN9S22005C57D1Ev();
extern void _ZN9S22005C57D0Ev();
extern void _ZN9S22005C253v11Ev();
extern void _ZN9S22005C253v12Ev();
extern void _ZN9S22005C253v13Ev();
extern void _ZN9S22005C253v14Ev();
extern void _ZN9S22005C253v15Ev();
extern void _ZN9S22005C253v16Ev();
extern void _ZN9S22005C573v61Ev();
extern void _ZN9S22005C573v62Ev();
extern void _ZN9S22005C573v63Ev();
extern void _ZN9S22005C573v64Ev();
extern void _ZN9S22005C573v65Ev();
extern void _ZN9S22005C573v66Ev();
static  VTBL_ENTRY vtc_S22005C57[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S22005C57[0]),
  (VTBL_ENTRY)&_ZN9S22005C57D1Ev,
  (VTBL_ENTRY)&_ZN9S22005C57D0Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v11Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v12Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v13Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v14Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v15Ev,
  (VTBL_ENTRY)&_ZN9S22005C253v16Ev,
  (VTBL_ENTRY)&_ZN9S22005C573v61Ev,
  (VTBL_ENTRY)&_ZN9S22005C573v62Ev,
  (VTBL_ENTRY)&_ZN9S22005C573v63Ev,
  (VTBL_ENTRY)&_ZN9S22005C573v64Ev,
  (VTBL_ENTRY)&_ZN9S22005C573v65Ev,
  (VTBL_ENTRY)&_ZN9S22005C573v66Ev,
};
extern VTBL_ENTRY _ZTI9S22005C57[];
extern  VTBL_ENTRY _ZTV9S22005C57[];
Class_Descriptor cd_S22005C57 = {  "S22005C57", // class name
  bases_S22005C57, 2,
  &(vtc_S22005C57[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(728,420), // object size
  NSPAIRA(_ZTI9S22005C57),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S22005C57),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C56  {
  ::S22005C57 s22005c56f0;
  ::S22005C58 s22005c56f1;
  void  mf22005c56(); // _ZN9S22005C5610mf22005c56Ev
};
//SIG(-1 S22005C56) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC17 FC17 FC17 FC17 FC19{ BC18 vd v29 v30 v31 v32 v33 v34 v35 FC20{ m FC21{ m FL[2]}} Fp} FC22{ BC18 vd v36 v37 v38 v39 v40 v41 v42 FC23{ m FC20} Fp} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17}} FC24{ m FC25{ m Fp[2]}}} FC10}


void  S22005C56 ::mf22005c56(){}

static void Test_S22005C56()
{
  {
    init_simple_test("S22005C56");
    S22005C56 lv;
    check2(sizeof(lv), ABISELECT(1336,760), "sizeof(S22005C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C56)");
    check_field_offset(lv, s22005c56f0, 0, "S22005C56.s22005c56f0");
    check_field_offset(lv, s22005c56f1, ABISELECT(728,420), "S22005C56.s22005c56f1");
  }
}
static Arrange_To_Call_Me vS22005C56(Test_S22005C56, "S22005C56", ABISELECT(1336,760));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C64  {
  ::S17070C17_nt s22005c64f0;
  ::S17070C17_nt s22005c64f1;
  ::S17070C17_nt s22005c64f2;
  char s22005c64f3;
  ::S17070C131_nt s22005c64f4;
  void  mf22005c64(); // _ZN9S22005C6410mf22005c64Ev
};
//SIG(-1 S22005C64) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 Fc FC4{ m FC2}}


void  S22005C64 ::mf22005c64(){}

static void Test_S22005C64()
{
  {
    init_simple_test("S22005C64");
    S22005C64 lv;
    check2(sizeof(lv), ABISELECT(72,68), "sizeof(S22005C64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C64)");
    check_field_offset(lv, s22005c64f0, 0, "S22005C64.s22005c64f0");
    check_field_offset(lv, s22005c64f1, 16, "S22005C64.s22005c64f1");
    check_field_offset(lv, s22005c64f2, 32, "S22005C64.s22005c64f2");
    check_field_offset(lv, s22005c64f3, 48, "S22005C64.s22005c64f3");
    check_field_offset(lv, s22005c64f4, ABISELECT(56,52), "S22005C64.s22005c64f4");
  }
}
static Arrange_To_Call_Me vS22005C64(Test_S22005C64, "S22005C64", ABISELECT(72,68));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C66  {
  ::S17070C17_nt s22005c66f0;
  ::S17070C131_nt s22005c66f1;
  void  mf22005c66(); // _ZN9S22005C6610mf22005c66Ev
};
//SIG(-1 S22005C66) C1{ m FC2{ m FC3{ m FL[2]}} FC4{ m FC2}}


void  S22005C66 ::mf22005c66(){}

static void Test_S22005C66()
{
  {
    init_simple_test("S22005C66");
    S22005C66 lv;
    check2(sizeof(lv), 32, "sizeof(S22005C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C66)");
    check_field_offset(lv, s22005c66f0, 0, "S22005C66.s22005c66f0");
    check_field_offset(lv, s22005c66f1, 16, "S22005C66.s22005c66f1");
  }
}
static Arrange_To_Call_Me vS22005C66(Test_S22005C66, "S22005C66", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C65  {
  ::S22005C66 s22005c65f0;
  ::S17070C16_nt s22005c65f1;
  ::S17070C16_nt s22005c65f2;
  void  mf22005c65(); // _ZN9S22005C6510mf22005c65Ev
};
//SIG(-1 S22005C65) C1{ m FC2{ m FC3{ m FC4{ m FL[2]}} FC5{ m FC3}} FC6{ m FC3 FC3 FC3 FC3} FC6}


void  S22005C65 ::mf22005c65(){}

static void Test_S22005C65()
{
  {
    init_simple_test("S22005C65");
    S22005C65 lv;
    check2(sizeof(lv), 160, "sizeof(S22005C65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C65)");
    check_field_offset(lv, s22005c65f0, 0, "S22005C65.s22005c65f0");
    check_field_offset(lv, s22005c65f1, 32, "S22005C65.s22005c65f1");
    check_field_offset(lv, s22005c65f2, 96, "S22005C65.s22005c65f2");
  }
}
static Arrange_To_Call_Me vS22005C65(Test_S22005C65, "S22005C65", 160);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S22005C1  {
  void *s22005c1f0;
  ::S17070C145 s22005c1f1;
  ::S17070C142 s22005c1f2;
  ::S17070C136 s22005c1f3;
  ::S17070C128 s22005c1f4;
  ::S17070C122 s22005c1f5;
  ::S17070C122 s22005c1f6;
  ::S17572C14 s22005c1f7;
  char s22005c1f8[2];
  int s22005c1f9[2];
  char s22005c1f10[3];
  int s22005c1f11;
  ::S17070C71 s22005c1f12;
  ::S17070C80 s22005c1f13;
  ::S17070C99 s22005c1f14;
  ::S22005C56 s22005c1f15;
  int s22005c1f16;
  ::S17070C131_nt s22005c1f17;
  ::S17070C131_nt s22005c1f18;
  ::S17070C131_nt s22005c1f19;
  ::S17070C131_nt s22005c1f20;
  ::S22005C64 s22005c1f21;
  int s22005c1f22;
  ::S22005C65 s22005c1f23;
  ::S17070C21_nt s22005c1f24;
  virtual  ~S22005C1(); // _ZN8S22005C1D1Ev
  virtual void  v1(); // _ZN8S22005C12v1Ev
  virtual void  v2(); // _ZN8S22005C12v2Ev
  virtual void  v3(); // _ZN8S22005C12v3Ev
  virtual void  v4(); // _ZN8S22005C12v4Ev
  S22005C1(); // tgen
};
//SIG(1 S22005C1) C1{ vd v1 v2 v3 v4 Fp FC2{ m Fp[2]} FC3{ m Fp[2]} FC4{ m Fp[2]} FC5{ m Fp[2]} FC6{ m Fp[2]} FC6 FC7{ m Fi FC8{ m Fi[2]} Fi FC9{ m FC10{ m Fp[2]} Fi} Fi[2] FC11{ m FC10 FC12{ m Fp[2]}} FC9} Fc[2] Fi[2] Fc[3] Fi FC13{ m FC14{ m FC15{ m Fp[2]}} FC16{ m Fp Fi FC17{ m}} FC18{ BC19{ m Fp Fi FC20{ m} FC20}} FC16 FC16 Fc[2] Fi} FC21{ m FC22{ BC23{ BC24{ m Fp[2]} vd v11 v12 v13 v14 v15 v16 FC18 FC16 FC16 FC16 FC16} v5 v6 v7 v8 v9 v10 FC25{ BC26{ vd v18 FC27{ m Fp Fi[2] FC17} FC28{ m Fc FC29{ m Fi[3]} Fi[2]} FC16} BC30{ m Fp[2]} v17 FC31{ m FC32{ BC33{ vd v26 v27 v28 v29 v30 v31 v32} vd v19 v20 v21 v22 v23 v24 v25 FC34{ m FC35{ m FL[2]}} Fp} FC36{ BC33 vd v33 v34 v35 v36 v37 v38 v39 Fi Fp} FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36}} FC37{ m FC30}} FC25} FC38{ m FC39{ BC23 v40 v41 v42 v43 v44 v45 FC40{ BC26 BC41{ m Fp[2]} v46 FC42{ m FC43{ BC33 vd v47 v48 v49 v50 v51 v52 v53 FC44{ m FC45{ m FL}} Fp} FC36 FC32 FC32 FC32 FC36}} FC37} FC40} FC46{ m FC47{ BC48{ BC49{ m Fp[2]} vd v60 v61 v62 v63 v64 v65 FC18 FC16 FC16 FC16 FC16} v54 v55 v56 v57 v58 v59 FC50{ BC51{ vd v67 FC27 FC28 FC16} BC52{ m Fp[2]} v66 FC53{ m FC36 FC36 FC36 FC36 FC36 FC32 FC54{ BC33 vd v68 v69 v70 v71 v72 v73 v74 FC55{ m FC34} Fp} FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36 FC36}} FC56{ m FC4}} FC50} Fi FC55 FC55 FC55 FC55 FC57{ m FC34 FC34 FC34 Fc FC55} Fi FC58{ m FC59{ m FC34 FC55} FC60{ m FC34 FC34 FC34 FC34} FC60} FC61{ m Fp}}


 S22005C1 ::~S22005C1(){ note_dtor("S22005C1", this);}
void  S22005C1 ::v1(){vfunc_called(this, "_ZN8S22005C12v1Ev");}
void  S22005C1 ::v2(){vfunc_called(this, "_ZN8S22005C12v2Ev");}
void  S22005C1 ::v3(){vfunc_called(this, "_ZN8S22005C12v3Ev");}
void  S22005C1 ::v4(){vfunc_called(this, "_ZN8S22005C12v4Ev");}
S22005C1 ::S22005C1(){ note_ctor("S22005C1", this);} // tgen

static void Test_S22005C1()
{
  extern Class_Descriptor cd_S22005C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(427,544)];
    init_test(&cd_S22005C1, buf);
    S22005C1 *dp, &lv = *(dp=new (buf) S22005C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3408,2172), "sizeof(S22005C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S22005C1)");
    check_field_offset(lv, s22005c1f0, ABISELECT(8,4), "S22005C1.s22005c1f0");
    check_field_offset(lv, s22005c1f1, ABISELECT(16,8), "S22005C1.s22005c1f1");
    check_field_offset(lv, s22005c1f2, ABISELECT(32,16), "S22005C1.s22005c1f2");
    check_field_offset(lv, s22005c1f3, ABISELECT(48,24), "S22005C1.s22005c1f3");
    check_field_offset(lv, s22005c1f4, ABISELECT(64,32), "S22005C1.s22005c1f4");
    check_field_offset(lv, s22005c1f5, ABISELECT(80,40), "S22005C1.s22005c1f5");
    check_field_offset(lv, s22005c1f6, ABISELECT(96,48), "S22005C1.s22005c1f6");
    check_field_offset(lv, s22005c1f7, ABISELECT(112,56), "S22005C1.s22005c1f7");
    check_field_offset(lv, s22005c1f8, ABISELECT(216,120), "S22005C1.s22005c1f8");
    check_field_offset(lv, s22005c1f9, ABISELECT(220,124), "S22005C1.s22005c1f9");
    check_field_offset(lv, s22005c1f10, ABISELECT(228,132), "S22005C1.s22005c1f10");
    check_field_offset(lv, s22005c1f11, ABISELECT(232,136), "S22005C1.s22005c1f11");
    check_field_offset(lv, s22005c1f12, ABISELECT(240,140), "S22005C1.s22005c1f12");
    check_field_offset(lv, s22005c1f13, ABISELECT(328,204), "S22005C1.s22005c1f13");
    check_field_offset(lv, s22005c1f14, ABISELECT(1120,676), "S22005C1.s22005c1f14");
    check_field_offset(lv, s22005c1f15, ABISELECT(1752,1108), "S22005C1.s22005c1f15");
    check_field_offset(lv, s22005c1f16, ABISELECT(3088,1868), "S22005C1.s22005c1f16");
    check_field_offset(lv, s22005c1f17, ABISELECT(3096,1872), "S22005C1.s22005c1f17");
    check_field_offset(lv, s22005c1f18, ABISELECT(3112,1888), "S22005C1.s22005c1f18");
    check_field_offset(lv, s22005c1f19, ABISELECT(3128,1904), "S22005C1.s22005c1f19");
    check_field_offset(lv, s22005c1f20, ABISELECT(3144,1920), "S22005C1.s22005c1f20");
    check_field_offset(lv, s22005c1f21, ABISELECT(3160,1936), "S22005C1.s22005c1f21");
    check_field_offset(lv, s22005c1f22, ABISELECT(3232,2004), "S22005C1.s22005c1f22");
    check_field_offset(lv, s22005c1f23, ABISELECT(3240,2008), "S22005C1.s22005c1f23");
    check_field_offset(lv, s22005c1f24, ABISELECT(3400,2168), "S22005C1.s22005c1f24");
    test_class_info(&lv, &cd_S22005C1);
    dp->~S22005C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS22005C1(Test_S22005C1, "S22005C1", ABISELECT(3408,2172));

#else // __cplusplus

extern void _ZN8S22005C1C1Ev();
extern void _ZN8S22005C1D1Ev();
Name_Map name_map_S22005C1[] = {
  NSPAIR(_ZN8S22005C1C1Ev),
  NSPAIR(_ZN8S22005C1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S22005C1[];
extern void _ZN8S22005C1D1Ev();
extern void _ZN8S22005C1D0Ev();
extern void _ZN8S22005C12v1Ev();
extern void _ZN8S22005C12v2Ev();
extern void _ZN8S22005C12v3Ev();
extern void _ZN8S22005C12v4Ev();
static  VTBL_ENTRY vtc_S22005C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S22005C1[0]),
  (VTBL_ENTRY)&_ZN8S22005C1D1Ev,
  (VTBL_ENTRY)&_ZN8S22005C1D0Ev,
  (VTBL_ENTRY)&_ZN8S22005C12v1Ev,
  (VTBL_ENTRY)&_ZN8S22005C12v2Ev,
  (VTBL_ENTRY)&_ZN8S22005C12v3Ev,
  (VTBL_ENTRY)&_ZN8S22005C12v4Ev,
};
extern VTBL_ENTRY _ZTI8S22005C1[];
extern  VTBL_ENTRY _ZTV8S22005C1[];
Class_Descriptor cd_S22005C1 = {  "S22005C1", // class name
  0,0,//no base classes
  &(vtc_S22005C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3408,2172), // object size
  NSPAIRA(_ZTI8S22005C1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S22005C1),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C15  : S17070C145 {
  ::S17070C76_nt s17472c15f0;
  ::S17070C74_nt s17472c15f1;
  ::S17070C74_nt s17472c15f2;
  ::S17070C74_nt s17472c15f3;
  ::S17070C74_nt s17472c15f4;
  virtual  ~S17472C15(); // _ZN9S17472C15D1Ev
  virtual void  v7(); // _ZN9S17472C152v7Ev
  virtual void  v8(); // _ZN9S17472C152v8Ev
  virtual void  v9(); // _ZN9S17472C152v9Ev
  virtual void  v10(); // _ZN9S17472C153v10Ev
  virtual void  v11(); // _ZN9S17472C153v11Ev
  virtual void  v12(); // _ZN9S17472C153v12Ev
  S17472C15(); // tgen
};
//SIG(-1 S17472C15) C1{ BC2{ m Fp[2]} vd v1 v2 v3 v4 v5 v6 FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ m Fp Fi FC7{ m}} FC6 FC6 FC6}


 S17472C15 ::~S17472C15(){ note_dtor("S17472C15", this);}
void  S17472C15 ::v7(){vfunc_called(this, "_ZN9S17472C152v7Ev");}
void  S17472C15 ::v8(){vfunc_called(this, "_ZN9S17472C152v8Ev");}
void  S17472C15 ::v9(){vfunc_called(this, "_ZN9S17472C152v9Ev");}
void  S17472C15 ::v10(){vfunc_called(this, "_ZN9S17472C153v10Ev");}
void  S17472C15 ::v11(){vfunc_called(this, "_ZN9S17472C153v11Ev");}
void  S17472C15 ::v12(){vfunc_called(this, "_ZN9S17472C153v12Ev");}
S17472C15 ::S17472C15(){ note_ctor("S17472C15", this);} // tgen

static void Test_S17472C15()
{
  extern Class_Descriptor cd_S17472C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,19)];
    init_test(&cd_S17472C15, buf);
    S17472C15 *dp, &lv = *(dp=new (buf) S17472C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,72), "sizeof(S17472C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C15)");
    check_base_class_offset(lv, (S17070C145*), ABISELECT(8,4), "S17472C15");
    check_field_offset(lv, s17472c15f0, ABISELECT(24,12), "S17472C15.s17472c15f0");
    check_field_offset(lv, s17472c15f1, ABISELECT(40,24), "S17472C15.s17472c15f1");
    check_field_offset(lv, s17472c15f2, ABISELECT(56,36), "S17472C15.s17472c15f2");
    check_field_offset(lv, s17472c15f3, ABISELECT(72,48), "S17472C15.s17472c15f3");
    check_field_offset(lv, s17472c15f4, ABISELECT(88,60), "S17472C15.s17472c15f4");
    test_class_info(&lv, &cd_S17472C15);
    dp->~S17472C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17472C15(Test_S17472C15, "S17472C15", ABISELECT(104,72));

#else // __cplusplus

extern void _ZN9S17472C15C1Ev();
extern void _ZN9S17472C15D1Ev();
Name_Map name_map_S17472C15[] = {
  NSPAIR(_ZN9S17472C15C1Ev),
  NSPAIR(_ZN9S17472C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C145;
extern VTBL_ENTRY _ZTI10S17070C145[];
static Base_Class bases_S17472C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C145,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17472C15[];
extern void _ZN9S17472C15D1Ev();
extern void _ZN9S17472C15D0Ev();
extern void _ZN9S17472C152v7Ev();
extern void _ZN9S17472C152v8Ev();
extern void _ZN9S17472C152v9Ev();
extern void _ZN9S17472C153v10Ev();
extern void _ZN9S17472C153v11Ev();
extern void _ZN9S17472C153v12Ev();
static  VTBL_ENTRY vtc_S17472C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17472C15[0]),
  (VTBL_ENTRY)&_ZN9S17472C15D1Ev,
  (VTBL_ENTRY)&_ZN9S17472C15D0Ev,
  (VTBL_ENTRY)&_ZN9S17472C152v7Ev,
  (VTBL_ENTRY)&_ZN9S17472C152v8Ev,
  (VTBL_ENTRY)&_ZN9S17472C152v9Ev,
  (VTBL_ENTRY)&_ZN9S17472C153v10Ev,
  (VTBL_ENTRY)&_ZN9S17472C153v11Ev,
  (VTBL_ENTRY)&_ZN9S17472C153v12Ev,
};
extern VTBL_ENTRY _ZTI9S17472C15[];
extern  VTBL_ENTRY _ZTV9S17472C15[];
Class_Descriptor cd_S17472C15 = {  "S17472C15", // class name
  bases_S17472C15, 1,
  &(vtc_S17472C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,72), // object size
  NSPAIRA(_ZTI9S17472C15),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S17472C15),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C21  {
  ::S17070C30_nt s17472c21f0;
  ::S17070C91 s17472c21f1;
  ::S17070C74_nt s17472c21f2;
  virtual  ~S17472C21(); // _ZN9S17472C21D1Ev
  virtual void  v14(); // _ZN9S17472C213v14Ev
  S17472C21(); // tgen
};
//SIG(-1 S17472C21) C1{ vd v1 FC2{ m Fp Fi[2] FC3{ m}} FC4{ m Fc FC5{ m Fi[3]} Fi[2]} FC6{ m Fp Fi FC3}}


 S17472C21 ::~S17472C21(){ note_dtor("S17472C21", this);}
void  S17472C21 ::v14(){vfunc_called(this, "_ZN9S17472C213v14Ev");}
S17472C21 ::S17472C21(){ note_ctor("S17472C21", this);} // tgen

static void Test_S17472C21()
{
  extern Class_Descriptor cd_S17472C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S17472C21, buf);
    S17472C21 *dp, &lv = *(dp=new (buf) S17472C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S17472C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C21)");
    check_field_offset(lv, s17472c21f0, ABISELECT(8,4), "S17472C21.s17472c21f0");
    check_field_offset(lv, s17472c21f1, ABISELECT(32,20), "S17472C21.s17472c21f1");
    check_field_offset(lv, s17472c21f2, ABISELECT(56,44), "S17472C21.s17472c21f2");
    test_class_info(&lv, &cd_S17472C21);
    dp->~S17472C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17472C21(Test_S17472C21, "S17472C21", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN9S17472C21C1Ev();
extern void _ZN9S17472C21D1Ev();
Name_Map name_map_S17472C21[] = {
  NSPAIR(_ZN9S17472C21C1Ev),
  NSPAIR(_ZN9S17472C21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S17472C21[];
extern void _ZN9S17472C21D1Ev();
extern void _ZN9S17472C21D0Ev();
extern void _ZN9S17472C213v14Ev();
static  VTBL_ENTRY vtc_S17472C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17472C21[0]),
  (VTBL_ENTRY)&_ZN9S17472C21D1Ev,
  (VTBL_ENTRY)&_ZN9S17472C21D0Ev,
  (VTBL_ENTRY)&_ZN9S17472C213v14Ev,
};
extern VTBL_ENTRY _ZTI9S17472C21[];
extern  VTBL_ENTRY _ZTV9S17472C21[];
Class_Descriptor cd_S17472C21 = {  "S17472C21", // class name
  0,0,//no base classes
  &(vtc_S17472C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI9S17472C21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S17472C21),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C29  {
  virtual  ~S17472C29(); // _ZN9S17472C29D1Ev
  virtual void  v22(); // _ZN9S17472C293v22Ev
  virtual void  v23(); // _ZN9S17472C293v23Ev
  virtual void  v24(); // _ZN9S17472C293v24Ev
  virtual void  v25(); // _ZN9S17472C293v25Ev
  virtual void  v26(); // _ZN9S17472C293v26Ev
  virtual void  v27(); // _ZN9S17472C293v27Ev
  virtual void  v28(); // _ZN9S17472C293v28Ev
  S17472C29(); // tgen
};
//SIG(-1 S17472C29) C1{ vd v1 v2 v3 v4 v5 v6 v7}


 S17472C29 ::~S17472C29(){ note_dtor("S17472C29", this);}
void  S17472C29 ::v22(){vfunc_called(this, "_ZN9S17472C293v22Ev");}
void  S17472C29 ::v23(){vfunc_called(this, "_ZN9S17472C293v23Ev");}
void  S17472C29 ::v24(){vfunc_called(this, "_ZN9S17472C293v24Ev");}
void  S17472C29 ::v25(){vfunc_called(this, "_ZN9S17472C293v25Ev");}
void  S17472C29 ::v26(){vfunc_called(this, "_ZN9S17472C293v26Ev");}
void  S17472C29 ::v27(){vfunc_called(this, "_ZN9S17472C293v27Ev");}
void  S17472C29 ::v28(){vfunc_called(this, "_ZN9S17472C293v28Ev");}
S17472C29 ::S17472C29(){ note_ctor("S17472C29", this);} // tgen

static void Test_S17472C29()
{
  extern Class_Descriptor cd_S17472C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S17472C29, buf);
    S17472C29 *dp, &lv = *(dp=new (buf) S17472C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17472C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C29)");
    test_class_info(&lv, &cd_S17472C29);
    dp->~S17472C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17472C29(Test_S17472C29, "S17472C29", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S17472C29C1Ev();
extern void _ZN9S17472C29D1Ev();
Name_Map name_map_S17472C29[] = {
  NSPAIR(_ZN9S17472C29C1Ev),
  NSPAIR(_ZN9S17472C29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S17472C29[];
extern void _ZN9S17472C29D1Ev();
extern void _ZN9S17472C29D0Ev();
extern void _ZN9S17472C293v22Ev();
extern void _ZN9S17472C293v23Ev();
extern void _ZN9S17472C293v24Ev();
extern void _ZN9S17472C293v25Ev();
extern void _ZN9S17472C293v26Ev();
extern void _ZN9S17472C293v27Ev();
extern void _ZN9S17472C293v28Ev();
static  VTBL_ENTRY vtc_S17472C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17472C29[0]),
  (VTBL_ENTRY)&_ZN9S17472C29D1Ev,
  (VTBL_ENTRY)&_ZN9S17472C29D0Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v22Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v23Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v24Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v25Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v26Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v27Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v28Ev,
};
extern VTBL_ENTRY _ZTI9S17472C29[];
extern  VTBL_ENTRY _ZTV9S17472C29[];
Class_Descriptor cd_S17472C29 = {  "S17472C29", // class name
  0,0,//no base classes
  &(vtc_S17472C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S17472C29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S17472C29),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C28_nt  : S17472C29 {
  ::S17070C17_nt s17472c28f0;
  void *s17472c28f1;
  virtual  ~S17472C28_nt(); // _ZN12S17472C28_ntD1Ev
  virtual void  v15(); // _ZN12S17472C28_nt3v15Ev
  virtual void  v16(); // _ZN12S17472C28_nt3v16Ev
  virtual void  v17(); // _ZN12S17472C28_nt3v17Ev
  virtual void  v18(); // _ZN12S17472C28_nt3v18Ev
  virtual void  v19(); // _ZN12S17472C28_nt3v19Ev
  virtual void  v20(); // _ZN12S17472C28_nt3v20Ev
  virtual void  v21(); // _ZN12S17472C28_nt3v21Ev
  S17472C28_nt(); // tgen
};
//SIG(-1 S17472C28_nt) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m FC4{ m FL[2]}} Fp}


 S17472C28_nt ::~S17472C28_nt(){ note_dtor("S17472C28_nt", this);}
void  S17472C28_nt ::v15(){vfunc_called(this, "_ZN12S17472C28_nt3v15Ev");}
void  S17472C28_nt ::v16(){vfunc_called(this, "_ZN12S17472C28_nt3v16Ev");}
void  S17472C28_nt ::v17(){vfunc_called(this, "_ZN12S17472C28_nt3v17Ev");}
void  S17472C28_nt ::v18(){vfunc_called(this, "_ZN12S17472C28_nt3v18Ev");}
void  S17472C28_nt ::v19(){vfunc_called(this, "_ZN12S17472C28_nt3v19Ev");}
void  S17472C28_nt ::v20(){vfunc_called(this, "_ZN12S17472C28_nt3v20Ev");}
void  S17472C28_nt ::v21(){vfunc_called(this, "_ZN12S17472C28_nt3v21Ev");}
S17472C28_nt ::S17472C28_nt(){ note_ctor("S17472C28_nt", this);} // tgen

//skip512 S17472C28_nt

#else // __cplusplus

extern void _ZN12S17472C28_ntC1Ev();
extern void _ZN12S17472C28_ntD1Ev();
Name_Map name_map_S17472C28_nt[] = {
  NSPAIR(_ZN12S17472C28_ntC1Ev),
  NSPAIR(_ZN12S17472C28_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17472C29;
extern VTBL_ENTRY _ZTI9S17472C29[];
extern  VTBL_ENTRY _ZTV9S17472C29[];
static Base_Class bases_S17472C28_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17472C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S17472C28_nt[];
extern void _ZN12S17472C28_ntD1Ev();
extern void _ZN12S17472C28_ntD0Ev();
extern void _ZN9S17472C293v22Ev();
extern void _ZN9S17472C293v23Ev();
extern void _ZN9S17472C293v24Ev();
extern void _ZN9S17472C293v25Ev();
extern void _ZN9S17472C293v26Ev();
extern void _ZN9S17472C293v27Ev();
extern void _ZN9S17472C293v28Ev();
extern void _ZN12S17472C28_nt3v15Ev();
extern void _ZN12S17472C28_nt3v16Ev();
extern void _ZN12S17472C28_nt3v17Ev();
extern void _ZN12S17472C28_nt3v18Ev();
extern void _ZN12S17472C28_nt3v19Ev();
extern void _ZN12S17472C28_nt3v20Ev();
extern void _ZN12S17472C28_nt3v21Ev();
static  VTBL_ENTRY vtc_S17472C28_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S17472C28_nt[0]),
  (VTBL_ENTRY)&_ZN12S17472C28_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v22Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v23Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v24Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v25Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v26Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v27Ev,
  (VTBL_ENTRY)&_ZN9S17472C293v28Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_nt3v15Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_nt3v16Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_nt3v17Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_nt3v18Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_nt3v19Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_nt3v20Ev,
  (VTBL_ENTRY)&_ZN12S17472C28_nt3v21Ev,
};
extern VTBL_ENTRY _ZTI12S17472C28_nt[];
VTBL_ENTRY *P__ZTI12S17472C28_nt = _ZTI12S17472C28_nt; 
extern  VTBL_ENTRY _ZTV12S17472C28_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C50  {
  ::S17070C97 s17472c50f0;
  ::S17070C97 s17472c50f1;
  ::S17070C97 s17472c50f2;
  ::S17070C97 s17472c50f3;
  ::S17070C97 s17472c50f4;
  ::S17070C97 s17472c50f5;
  ::S17070C97 s17472c50f6;
  ::S17070C97 s17472c50f7;
  ::S17070C97 s17472c50f8;
  ::S17070C97 s17472c50f9;
  ::S17070C97 s17472c50f10;
  ::S17070C95 s17472c50f11;
  ::S17070C95 s17472c50f12;
  ::S17070C97 s17472c50f13;
  ::S17070C97 s17472c50f14;
  ::S17472C28_nt s17472c50f15;
  void  mf17472c50(); // _ZN9S17472C5010mf17472c50Ev
};
//SIG(-1 S17472C50) C1{ m FC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fi Fp} FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC4{ BC3 vd v15 v16 v17 v18 v19 v20 v21 FC5{ m FC6{ m FL[2]}} Fp} FC4 FC2 FC2 FC7{ BC8{ vd v29 v30 v31 v32 v33 v34 v35} vd v22 v23 v24 v25 v26 v27 v28 FC5 Fp}}


void  S17472C50 ::mf17472c50(){}

static void Test_S17472C50()
{
  {
    init_simple_test("S17472C50");
    S17472C50 lv;
    check2(sizeof(lv), ABISELECT(408,228), "sizeof(S17472C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C50)");
    check_field_offset(lv, s17472c50f0, 0, "S17472C50.s17472c50f0");
    check_field_offset(lv, s17472c50f1, ABISELECT(24,12), "S17472C50.s17472c50f1");
    check_field_offset(lv, s17472c50f2, ABISELECT(48,24), "S17472C50.s17472c50f2");
    check_field_offset(lv, s17472c50f3, ABISELECT(72,36), "S17472C50.s17472c50f3");
    check_field_offset(lv, s17472c50f4, ABISELECT(96,48), "S17472C50.s17472c50f4");
    check_field_offset(lv, s17472c50f5, ABISELECT(120,60), "S17472C50.s17472c50f5");
    check_field_offset(lv, s17472c50f6, ABISELECT(144,72), "S17472C50.s17472c50f6");
    check_field_offset(lv, s17472c50f7, ABISELECT(168,84), "S17472C50.s17472c50f7");
    check_field_offset(lv, s17472c50f8, ABISELECT(192,96), "S17472C50.s17472c50f8");
    check_field_offset(lv, s17472c50f9, ABISELECT(216,108), "S17472C50.s17472c50f9");
    check_field_offset(lv, s17472c50f10, ABISELECT(240,120), "S17472C50.s17472c50f10");
    check_field_offset(lv, s17472c50f11, ABISELECT(264,132), "S17472C50.s17472c50f11");
    check_field_offset(lv, s17472c50f12, ABISELECT(296,156), "S17472C50.s17472c50f12");
    check_field_offset(lv, s17472c50f13, ABISELECT(328,180), "S17472C50.s17472c50f13");
    check_field_offset(lv, s17472c50f14, ABISELECT(352,192), "S17472C50.s17472c50f14");
    check_field_offset(lv, s17472c50f15, ABISELECT(376,204), "S17472C50.s17472c50f15");
  }
}
static Arrange_To_Call_Me vS17472C50(Test_S17472C50, "S17472C50", ABISELECT(408,228));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C48  : S17472C21 , S17070C142 {
  ::S17472C50 s17472c48f0;
  virtual void  v63(); // _ZN9S17472C483v63Ev
  ~S17472C48(); // tgen
  S17472C48(); // tgen
};
//SIG(-1 S17472C48) C1{ BC2{ vd v2 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m Fc FC6{ m Fi[3]} Fi[2]} FC7{ m Fp Fi FC4}} BC8{ m Fp[2]} v1 FC9{ m FC10{ BC11{ vd v10 v11 v12 v13 v14 v15 v16} vd v3 v4 v5 v6 v7 v8 v9 Fi Fp} FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC10 FC12{ BC11 vd v17 v18 v19 v20 v21 v22 v23 FC13{ m FC14{ m FL[2]}} Fp} FC12 FC10 FC10 FC15{ BC16{ vd v31 v32 v33 v34 v35 v36 v37} vd v24 v25 v26 v27 v28 v29 v30 FC13 Fp}}}


void  S17472C48 ::v63(){vfunc_called(this, "_ZN9S17472C483v63Ev");}
S17472C48 ::~S17472C48(){ note_dtor("S17472C48", this);} // tgen
S17472C48 ::S17472C48(){ note_ctor("S17472C48", this);} // tgen

static void Test_S17472C48()
{
  extern Class_Descriptor cd_S17472C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(63,74)];
    init_test(&cd_S17472C48, buf);
    S17472C48 *dp, &lv = *(dp=new (buf) S17472C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(496,292), "sizeof(S17472C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C48)");
    check_base_class_offset(lv, (S17472C21*), 0, "S17472C48");
    check_base_class_offset(lv, (S17070C142*), ABISELECT(72,56), "S17472C48");
    check_field_offset(lv, s17472c48f0, ABISELECT(88,64), "S17472C48.s17472c48f0");
    test_class_info(&lv, &cd_S17472C48);
    dp->~S17472C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17472C48(Test_S17472C48, "S17472C48", ABISELECT(496,292));

#else // __cplusplus

extern void _ZN9S17472C48C1Ev();
extern void _ZN9S17472C48D1Ev();
Name_Map name_map_S17472C48[] = {
  NSPAIR(_ZN9S17472C48C1Ev),
  NSPAIR(_ZN9S17472C48D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17472C21;
extern VTBL_ENTRY _ZTI9S17472C21[];
extern  VTBL_ENTRY _ZTV9S17472C21[];
extern Class_Descriptor cd_S17070C142;
extern VTBL_ENTRY _ZTI10S17070C142[];
static Base_Class bases_S17472C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17472C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C142,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17472C48[];
extern void _ZN9S17472C48D1Ev();
extern void _ZN9S17472C48D0Ev();
extern void _ZN9S17472C213v14Ev();
extern void _ZN9S17472C483v63Ev();
static  VTBL_ENTRY vtc_S17472C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17472C48[0]),
  (VTBL_ENTRY)&_ZN9S17472C48D1Ev,
  (VTBL_ENTRY)&_ZN9S17472C48D0Ev,
  (VTBL_ENTRY)&_ZN9S17472C213v14Ev,
  (VTBL_ENTRY)&_ZN9S17472C483v63Ev,
};
extern VTBL_ENTRY _ZTI9S17472C48[];
extern  VTBL_ENTRY _ZTV9S17472C48[];
Class_Descriptor cd_S17472C48 = {  "S17472C48", // class name
  bases_S17472C48, 2,
  &(vtc_S17472C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(496,292), // object size
  NSPAIRA(_ZTI9S17472C48),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S17472C48),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C47  : S17472C15 {
  ::S17472C48 s17472c47f0;
  ::S17070C138 s17472c47f1;
  virtual void  v57(); // _ZN9S17472C473v57Ev
  virtual void  v58(); // _ZN9S17472C473v58Ev
  virtual void  v59(); // _ZN9S17472C473v59Ev
  virtual void  v60(); // _ZN9S17472C473v60Ev
  virtual void  v61(); // _ZN9S17472C473v61Ev
  virtual void  v62(); // _ZN9S17472C473v62Ev
  ~S17472C47(); // tgen
  S17472C47(); // tgen
};
//SIG(-1 S17472C47) C1{ BC2{ BC3{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m}} FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC9{ BC10{ vd v14 FC11{ m Fp Fi[2] FC8} FC12{ m Fc FC13{ m Fi[3]} Fi[2]} FC7} BC14{ m Fp[2]} v13 FC15{ m FC16{ BC17{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC18{ BC17 vd v29 v30 v31 v32 v33 v34 v35 FC19{ m FC20{ m FL[2]}} Fp} FC18 FC16 FC16 FC21{ BC22{ vd v43 v44 v45 v46 v47 v48 v49} vd v36 v37 v38 v39 v40 v41 v42 FC19 Fp}}} FC23{ m FC24{ m Fp[2]}}}


void  S17472C47 ::v57(){vfunc_called(this, "_ZN9S17472C473v57Ev");}
void  S17472C47 ::v58(){vfunc_called(this, "_ZN9S17472C473v58Ev");}
void  S17472C47 ::v59(){vfunc_called(this, "_ZN9S17472C473v59Ev");}
void  S17472C47 ::v60(){vfunc_called(this, "_ZN9S17472C473v60Ev");}
void  S17472C47 ::v61(){vfunc_called(this, "_ZN9S17472C473v61Ev");}
void  S17472C47 ::v62(){vfunc_called(this, "_ZN9S17472C473v62Ev");}
S17472C47 ::~S17472C47(){ note_dtor("S17472C47", this);} // tgen
S17472C47 ::S17472C47(){ note_ctor("S17472C47", this);} // tgen

static void Test_S17472C47()
{
  extern Class_Descriptor cd_S17472C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(78,94)];
    init_test(&cd_S17472C47, buf);
    S17472C47 *dp, &lv = *(dp=new (buf) S17472C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(616,372), "sizeof(S17472C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C47)");
    check_base_class_offset(lv, (S17070C145*)(S17472C15*), ABISELECT(8,4), "S17472C47");
    check_base_class_offset(lv, (S17472C15*), 0, "S17472C47");
    check_field_offset(lv, s17472c47f0, ABISELECT(104,72), "S17472C47.s17472c47f0");
    check_field_offset(lv, s17472c47f1, ABISELECT(600,364), "S17472C47.s17472c47f1");
    test_class_info(&lv, &cd_S17472C47);
    dp->~S17472C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17472C47(Test_S17472C47, "S17472C47", ABISELECT(616,372));

#else // __cplusplus

extern void _ZN9S17472C47C1Ev();
extern void _ZN9S17472C47D1Ev();
Name_Map name_map_S17472C47[] = {
  NSPAIR(_ZN9S17472C47C1Ev),
  NSPAIR(_ZN9S17472C47D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17070C145;
extern VTBL_ENTRY _ZTI10S17070C145[];
extern Class_Descriptor cd_S17472C15;
extern VTBL_ENTRY _ZTI9S17472C15[];
extern  VTBL_ENTRY _ZTV9S17472C15[];
static Base_Class bases_S17472C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C145,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17472C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17472C47[];
extern void _ZN9S17472C47D1Ev();
extern void _ZN9S17472C47D0Ev();
extern void _ZN9S17472C152v7Ev();
extern void _ZN9S17472C152v8Ev();
extern void _ZN9S17472C152v9Ev();
extern void _ZN9S17472C153v10Ev();
extern void _ZN9S17472C153v11Ev();
extern void _ZN9S17472C153v12Ev();
extern void _ZN9S17472C473v57Ev();
extern void _ZN9S17472C473v58Ev();
extern void _ZN9S17472C473v59Ev();
extern void _ZN9S17472C473v60Ev();
extern void _ZN9S17472C473v61Ev();
extern void _ZN9S17472C473v62Ev();
static  VTBL_ENTRY vtc_S17472C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17472C47[0]),
  (VTBL_ENTRY)&_ZN9S17472C47D1Ev,
  (VTBL_ENTRY)&_ZN9S17472C47D0Ev,
  (VTBL_ENTRY)&_ZN9S17472C152v7Ev,
  (VTBL_ENTRY)&_ZN9S17472C152v8Ev,
  (VTBL_ENTRY)&_ZN9S17472C152v9Ev,
  (VTBL_ENTRY)&_ZN9S17472C153v10Ev,
  (VTBL_ENTRY)&_ZN9S17472C153v11Ev,
  (VTBL_ENTRY)&_ZN9S17472C153v12Ev,
  (VTBL_ENTRY)&_ZN9S17472C473v57Ev,
  (VTBL_ENTRY)&_ZN9S17472C473v58Ev,
  (VTBL_ENTRY)&_ZN9S17472C473v59Ev,
  (VTBL_ENTRY)&_ZN9S17472C473v60Ev,
  (VTBL_ENTRY)&_ZN9S17472C473v61Ev,
  (VTBL_ENTRY)&_ZN9S17472C473v62Ev,
};
extern VTBL_ENTRY _ZTI9S17472C47[];
extern  VTBL_ENTRY _ZTV9S17472C47[];
Class_Descriptor cd_S17472C47 = {  "S17472C47", // class name
  bases_S17472C47, 2,
  &(vtc_S17472C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(616,372), // object size
  NSPAIRA(_ZTI9S17472C47),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17472C47),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C46  {
  ::S17472C47 s17472c46f0;
  ::S17472C48 s17472c46f1;
  void  mf17472c46(); // _ZN9S17472C4610mf17472c46Ev
};
//SIG(-1 S17472C46) C1{ m FC2{ BC3{ BC4{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m}} FC8 FC8 FC8} v1 v2 v3 v4 v5 v6 FC10{ BC11{ vd v14 FC12{ m Fp Fi[2] FC9} FC13{ m Fc FC14{ m Fi[3]} Fi[2]} FC8} BC15{ m Fp[2]} v13 FC16{ m FC17{ BC18{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 Fi Fp} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC19{ BC18 vd v29 v30 v31 v32 v33 v34 v35 FC20{ m FC21{ m FL[2]}} Fp} FC19 FC17 FC17 FC22{ BC23{ vd v43 v44 v45 v46 v47 v48 v49} vd v36 v37 v38 v39 v40 v41 v42 FC20 Fp}}} FC24{ m FC25{ m Fp[2]}}} FC10}


void  S17472C46 ::mf17472c46(){}

static void Test_S17472C46()
{
  {
    init_simple_test("S17472C46");
    S17472C46 lv;
    check2(sizeof(lv), ABISELECT(1112,664), "sizeof(S17472C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C46)");
    check_field_offset(lv, s17472c46f0, 0, "S17472C46.s17472c46f0");
    check_field_offset(lv, s17472c46f1, ABISELECT(616,372), "S17472C46.s17472c46f1");
  }
}
static Arrange_To_Call_Me vS17472C46(Test_S17472C46, "S17472C46", ABISELECT(1112,664));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17472C1  {
  void *s17472c1f0;
  char s17472c1f1[6];
  ::S17070C61 s17472c1f2;
  ::S17070C71 s17472c1f3;
  int s17472c1f4;
  ::S17070C80 s17472c1f5;
  ::S17070C99 s17472c1f6;
  ::S17070C99 s17472c1f7;
  ::S17472C46 s17472c1f8;
  ::S17070C87 s17472c1f9;
  ::S17070C20_nt s17472c1f10;
  ::S17572C14 s17472c1f11;
  ::S17070C20_nt s17472c1f12;
  ::S17070C20_nt s17472c1f13;
  void *s17472c1f14;
  void  mf17472c1(); // _ZN8S17472C19mf17472c1Ev
};
//SIG(1 S17472C1) C1{ m Fp Fc[6] FC2{ m FC3{ m Fp[2]} Fi} FC4{ m FC5{ m FC6{ m Fp[2]}} FC7{ m Fp Fi FC8{ m}} FC9{ BC10{ m Fp Fi FC11{ m} FC11}} FC7 FC7 Fc[2] Fi} Fi FC12{ m FC13{ BC14{ BC15{ m Fp[2]} vd v7 v8 v9 v10 v11 v12 FC9 FC7 FC7 FC7 FC7} v1 v2 v3 v4 v5 v6 FC16{ BC17{ vd v14 FC18{ m Fp Fi[2] FC8} FC19{ m Fc FC20{ m Fi[3]} Fi[2]} FC7} BC21{ m Fp[2]} v13 FC22{ m FC23{ BC24{ vd v22 v23 v24 v25 v26 v27 v28} vd v15 v16 v17 v18 v19 v20 v21 FC25{ m FC26{ m FL[2]}} Fp} FC27{ BC24 vd v29 v30 v31 v32 v33 v34 v35 Fi Fp} FC27 FC27 FC27 FC27 FC27 FC27 FC27 FC27}} FC28{ m FC21}} FC16} FC29{ m FC30{ BC14 v36 v37 v38 v39 v40 v41 FC31{ BC17 BC32{ m Fp[2]} v42 FC33{ m FC34{ BC24 vd v43 v44 v45 v46 v47 v48 v49 FC35{ m FC36{ m FL}} Fp} FC27 FC23 FC23 FC23 FC27}} FC28} FC31} FC29 FC37{ m FC38{ BC39{ BC40{ m Fp[2]} vd v56 v57 v58 v59 v60 v61 FC9 FC7 FC7 FC7 FC7} v50 v51 v52 v53 v54 v55 FC41{ BC42{ vd v63 FC18 FC19 FC7} BC43{ m Fp[2]} v62 FC44{ m FC27 FC27 FC27 FC27 FC27 FC27 FC27 FC27 FC27 FC27 FC27 FC23 FC23 FC27 FC27 FC45{ BC46{ vd v71 v72 v73 v74 v75 v76 v77} vd v64 v65 v66 v67 v68 v69 v70 FC25 Fp}}} FC47{ m FC48{ m Fp[2]}}} FC41} FC16 FC49{ m FC50{ m Fp[2]} FC51{ m Fp}} FC52{ m Fi FC53{ m Fi[2]} Fi FC2 Fi[2] FC54{ m FC3 FC55{ m Fp[2]}} FC2} FC49 FC49 Fp}


void  S17472C1 ::mf17472c1(){}

static void Test_S17472C1()
{
  {
    init_simple_test("S17472C1");
    S17472C1 lv;
    check2(sizeof(lv), ABISELECT(3824,2392), "sizeof(S17472C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17472C1)");
    check_field_offset(lv, s17472c1f0, 0, "S17472C1.s17472c1f0");
    check_field_offset(lv, s17472c1f1, ABISELECT(8,4), "S17472C1.s17472c1f1");
    check_field_offset(lv, s17472c1f2, ABISELECT(16,12), "S17472C1.s17472c1f2");
    check_field_offset(lv, s17472c1f3, ABISELECT(40,24), "S17472C1.s17472c1f3");
    check_field_offset(lv, s17472c1f4, ABISELECT(128,88), "S17472C1.s17472c1f4");
    check_field_offset(lv, s17472c1f5, ABISELECT(136,92), "S17472C1.s17472c1f5");
    check_field_offset(lv, s17472c1f6, ABISELECT(928,564), "S17472C1.s17472c1f6");
    check_field_offset(lv, s17472c1f7, ABISELECT(1560,996), "S17472C1.s17472c1f7");
    check_field_offset(lv, s17472c1f8, ABISELECT(2192,1428), "S17472C1.s17472c1f8");
    check_field_offset(lv, s17472c1f9, ABISELECT(3304,2092), "S17472C1.s17472c1f9");
    check_field_offset(lv, s17472c1f10, ABISELECT(3640,2288), "S17472C1.s17472c1f10");
    check_field_offset(lv, s17472c1f11, ABISELECT(3664,2300), "S17472C1.s17472c1f11");
    check_field_offset(lv, s17472c1f12, ABISELECT(3768,2364), "S17472C1.s17472c1f12");
    check_field_offset(lv, s17472c1f13, ABISELECT(3792,2376), "S17472C1.s17472c1f13");
    check_field_offset(lv, s17472c1f14, ABISELECT(3816,2388), "S17472C1.s17472c1f14");
  }
}
static Arrange_To_Call_Me vS17472C1(Test_S17472C1, "S17472C1", ABISELECT(3824,2392));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15670C4  {
  ::S17070C12_nt s15670c4f0;
  virtual  ~S15670C4(); // _ZN8S15670C4D1Ev
  virtual void  v7(); // _ZN8S15670C42v7Ev
  virtual void  v8(); // _ZN8S15670C42v8Ev
  virtual void  v9(); // _ZN8S15670C42v9Ev
  virtual void  v10(); // _ZN8S15670C43v10Ev
  virtual void  v11(); // _ZN8S15670C43v11Ev
  virtual void  v12(); // _ZN8S15670C43v12Ev
  S15670C4(); // tgen
};
//SIG(-1 S15670C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15670C4 ::~S15670C4(){ note_dtor("S15670C4", this);}
void  S15670C4 ::v7(){vfunc_called(this, "_ZN8S15670C42v7Ev");}
void  S15670C4 ::v8(){vfunc_called(this, "_ZN8S15670C42v8Ev");}
void  S15670C4 ::v9(){vfunc_called(this, "_ZN8S15670C42v9Ev");}
void  S15670C4 ::v10(){vfunc_called(this, "_ZN8S15670C43v10Ev");}
void  S15670C4 ::v11(){vfunc_called(this, "_ZN8S15670C43v11Ev");}
void  S15670C4 ::v12(){vfunc_called(this, "_ZN8S15670C43v12Ev");}
S15670C4 ::S15670C4(){ note_ctor("S15670C4", this);} // tgen

static void Test_S15670C4()
{
  extern Class_Descriptor cd_S15670C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15670C4, buf);
    S15670C4 *dp, &lv = *(dp=new (buf) S15670C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15670C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15670C4)");
    check_field_offset(lv, s15670c4f0, ABISELECT(8,4), "S15670C4.s15670c4f0");
    test_class_info(&lv, &cd_S15670C4);
    dp->~S15670C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15670C4(Test_S15670C4, "S15670C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15670C4C1Ev();
extern void _ZN8S15670C4D1Ev();
Name_Map name_map_S15670C4[] = {
  NSPAIR(_ZN8S15670C4C1Ev),
  NSPAIR(_ZN8S15670C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15670C4[];
extern void _ZN8S15670C4D1Ev();
extern void _ZN8S15670C4D0Ev();
extern void _ZN8S15670C42v7Ev();
extern void _ZN8S15670C42v8Ev();
extern void _ZN8S15670C42v9Ev();
extern void _ZN8S15670C43v10Ev();
extern void _ZN8S15670C43v11Ev();
extern void _ZN8S15670C43v12Ev();
static  VTBL_ENTRY vtc_S15670C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15670C4[0]),
  (VTBL_ENTRY)&_ZN8S15670C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15670C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15670C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15670C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15670C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15670C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15670C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15670C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15670C4[];
extern  VTBL_ENTRY _ZTV8S15670C4[];
Class_Descriptor cd_S15670C4 = {  "S15670C4", // class name
  0,0,//no base classes
  &(vtc_S15670C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15670C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15670C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15670C32_nt  : S17070C15_nt {
  ::S17070C29_nt s15670c32f0;
};
//SIG(-1 S15670C32_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m Fp Fi[2] FC5{ m}}}}



//skip512 S15670C32_nt

#else // __cplusplus

extern Class_Descriptor cd_S17070C15_nt;
static Base_Class bases_S15670C32_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15670C24  : S15670C4 , S17070C13_nt {
  ::S17070C19_nt s15670c24f0;
  ::S17070C22_nt s15670c24f1;
  ::S15670C32_nt s15670c24f2;
  virtual void  v15(); // _ZN9S15670C243v15Ev
  virtual void  v16(); // _ZN9S15670C243v16Ev
  virtual void  v17(); // _ZN9S15670C243v17Ev
  virtual void  v18(); // _ZN9S15670C243v18Ev
  virtual void  v19(); // _ZN9S15670C243v19Ev
  virtual void  v20(); // _ZN9S15670C243v20Ev
  ~S15670C24(); // tgen
  S15670C24(); // tgen
};
//SIG(-1 S15670C24) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC13{ BC6 FC14{ m FC15{ m Fp Fi[2] FC16{ m}}}}}


void  S15670C24 ::v15(){vfunc_called(this, "_ZN9S15670C243v15Ev");}
void  S15670C24 ::v16(){vfunc_called(this, "_ZN9S15670C243v16Ev");}
void  S15670C24 ::v17(){vfunc_called(this, "_ZN9S15670C243v17Ev");}
void  S15670C24 ::v18(){vfunc_called(this, "_ZN9S15670C243v18Ev");}
void  S15670C24 ::v19(){vfunc_called(this, "_ZN9S15670C243v19Ev");}
void  S15670C24 ::v20(){vfunc_called(this, "_ZN9S15670C243v20Ev");}
S15670C24 ::~S15670C24(){ note_dtor("S15670C24", this);} // tgen
S15670C24 ::S15670C24(){ note_ctor("S15670C24", this);} // tgen

static void Test_S15670C24()
{
  extern Class_Descriptor cd_S15670C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,30)];
    init_test(&cd_S15670C24, buf);
    S15670C24 *dp, &lv = *(dp=new (buf) S15670C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,116), "sizeof(S15670C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15670C24)");
    check_base_class_offset(lv, (S15670C4*), 0, "S15670C24");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S15670C24");
    check_field_offset(lv, s15670c24f0, ABISELECT(40,20), "S15670C24.s15670c24f0");
    check_field_offset(lv, s15670c24f1, ABISELECT(96,52), "S15670C24.s15670c24f1");
    check_field_offset(lv, s15670c24f2, ABISELECT(136,80), "S15670C24.s15670c24f2");
    test_class_info(&lv, &cd_S15670C24);
    dp->~S15670C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15670C24(Test_S15670C24, "S15670C24", ABISELECT(192,116));

#else // __cplusplus

extern void _ZN9S15670C24C1Ev();
extern void _ZN9S15670C24D1Ev();
Name_Map name_map_S15670C24[] = {
  NSPAIR(_ZN9S15670C24C1Ev),
  NSPAIR(_ZN9S15670C24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15670C4;
extern VTBL_ENTRY _ZTI8S15670C4[];
extern  VTBL_ENTRY _ZTV8S15670C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S15670C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15670C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15670C24[];
extern void _ZN9S15670C24D1Ev();
extern void _ZN9S15670C24D0Ev();
extern void _ZN8S15670C42v7Ev();
extern void _ZN8S15670C42v8Ev();
extern void _ZN8S15670C42v9Ev();
extern void _ZN8S15670C43v10Ev();
extern void _ZN8S15670C43v11Ev();
extern void _ZN8S15670C43v12Ev();
extern void _ZN9S15670C243v15Ev();
extern void _ZN9S15670C243v16Ev();
extern void _ZN9S15670C243v17Ev();
extern void _ZN9S15670C243v18Ev();
extern void _ZN9S15670C243v19Ev();
extern void _ZN9S15670C243v20Ev();
static  VTBL_ENTRY vtc_S15670C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15670C24[0]),
  (VTBL_ENTRY)&_ZN9S15670C24D1Ev,
  (VTBL_ENTRY)&_ZN9S15670C24D0Ev,
  (VTBL_ENTRY)&_ZN8S15670C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15670C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15670C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15670C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15670C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15670C43v12Ev,
  (VTBL_ENTRY)&_ZN9S15670C243v15Ev,
  (VTBL_ENTRY)&_ZN9S15670C243v16Ev,
  (VTBL_ENTRY)&_ZN9S15670C243v17Ev,
  (VTBL_ENTRY)&_ZN9S15670C243v18Ev,
  (VTBL_ENTRY)&_ZN9S15670C243v19Ev,
  (VTBL_ENTRY)&_ZN9S15670C243v20Ev,
};
extern VTBL_ENTRY _ZTI9S15670C24[];
extern  VTBL_ENTRY _ZTV9S15670C24[];
Class_Descriptor cd_S15670C24 = {  "S15670C24", // class name
  bases_S15670C24, 2,
  &(vtc_S15670C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,116), // object size
  NSPAIRA(_ZTI9S15670C24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15670C24),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15670C23  {
  ::S15670C24 s15670c23f0;
  ::S17070C39_nt s15670c23f1;
  void  mf15670c23(); // _ZN9S15670C2310mf15670c23Ev
};
//SIG(-1 S15670C23) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC14{ BC7 FC15{ m FC16{ m Fp Fi[2] FC17{ m}}}}} FC18{ BC19{ BC20{ vd v13} vd v14 Fp[2] FC15 FC21{ m Fp[2]}} vd FC22{ m Fp Fi FC23{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24{ m Fp[2]}}}}


void  S15670C23 ::mf15670c23(){}

static void Test_S15670C23()
{
  {
    init_simple_test("S15670C23");
    static S15670C23 lv;
    check2(sizeof(lv), ABISELECT(296,176), "sizeof(S15670C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15670C23)");
    check_field_offset(lv, s15670c23f0, 0, "S15670C23.s15670c23f0");
    check_field_offset(lv, s15670c23f1, ABISELECT(192,116), "S15670C23.s15670c23f1");
  }
}
static Arrange_To_Call_Me vS15670C23(Test_S15670C23, "S15670C23", ABISELECT(296,176));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15670C1  {
  ::S17070C47 s15670c1f0;
  ::S15670C23 s15670c1f1;
  void  mf15670c1(); // _ZN8S15670C19mf15670c1Ev
};
//SIG(1 S15670C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC18}}} FC22{ m FC23{ BC24{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC25{ BC8 FC26{ m FC27{ m Fp[2]} FC28{ m Fp}}} FC29{ BC8 FC30{ m FC31{ m FL}}} FC32{ BC8 FC15}} FC33{ BC34{ BC14 vd v27 Fp[2] FC15 FC35{ m Fp[2]}} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC18}}}}


void  S15670C1 ::mf15670c1(){}

static void Test_S15670C1()
{
  {
    init_simple_test("S15670C1");
    static S15670C1 lv;
    check2(sizeof(lv), ABISELECT(632,444), "sizeof(S15670C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15670C1)");
    check_field_offset(lv, s15670c1f0, 0, "S15670C1.s15670c1f0");
    check_field_offset(lv, s15670c1f1, ABISELECT(336,268), "S15670C1.s15670c1f1");
  }
}
static Arrange_To_Call_Me vS15670C1(Test_S15670C1, "S15670C1", ABISELECT(632,444));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15656C4  {
  ::S17070C12_nt s15656c4f0;
  virtual  ~S15656C4(); // _ZN8S15656C4D1Ev
  virtual void  v7(); // _ZN8S15656C42v7Ev
  virtual void  v8(); // _ZN8S15656C42v8Ev
  virtual void  v9(); // _ZN8S15656C42v9Ev
  virtual void  v10(); // _ZN8S15656C43v10Ev
  virtual void  v11(); // _ZN8S15656C43v11Ev
  virtual void  v12(); // _ZN8S15656C43v12Ev
  S15656C4(); // tgen
};
//SIG(-1 S15656C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15656C4 ::~S15656C4(){ note_dtor("S15656C4", this);}
void  S15656C4 ::v7(){vfunc_called(this, "_ZN8S15656C42v7Ev");}
void  S15656C4 ::v8(){vfunc_called(this, "_ZN8S15656C42v8Ev");}
void  S15656C4 ::v9(){vfunc_called(this, "_ZN8S15656C42v9Ev");}
void  S15656C4 ::v10(){vfunc_called(this, "_ZN8S15656C43v10Ev");}
void  S15656C4 ::v11(){vfunc_called(this, "_ZN8S15656C43v11Ev");}
void  S15656C4 ::v12(){vfunc_called(this, "_ZN8S15656C43v12Ev");}
S15656C4 ::S15656C4(){ note_ctor("S15656C4", this);} // tgen

static void Test_S15656C4()
{
  extern Class_Descriptor cd_S15656C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15656C4, buf);
    S15656C4 *dp, &lv = *(dp=new (buf) S15656C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15656C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15656C4)");
    check_field_offset(lv, s15656c4f0, ABISELECT(8,4), "S15656C4.s15656c4f0");
    test_class_info(&lv, &cd_S15656C4);
    dp->~S15656C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15656C4(Test_S15656C4, "S15656C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15656C4C1Ev();
extern void _ZN8S15656C4D1Ev();
Name_Map name_map_S15656C4[] = {
  NSPAIR(_ZN8S15656C4C1Ev),
  NSPAIR(_ZN8S15656C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15656C4[];
extern void _ZN8S15656C4D1Ev();
extern void _ZN8S15656C4D0Ev();
extern void _ZN8S15656C42v7Ev();
extern void _ZN8S15656C42v8Ev();
extern void _ZN8S15656C42v9Ev();
extern void _ZN8S15656C43v10Ev();
extern void _ZN8S15656C43v11Ev();
extern void _ZN8S15656C43v12Ev();
static  VTBL_ENTRY vtc_S15656C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15656C4[0]),
  (VTBL_ENTRY)&_ZN8S15656C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15656C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15656C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15656C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15656C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15656C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15656C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15656C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15656C4[];
extern  VTBL_ENTRY _ZTV8S15656C4[];
Class_Descriptor cd_S15656C4 = {  "S15656C4", // class name
  0,0,//no base classes
  &(vtc_S15656C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15656C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15656C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15656C3  : S15656C4 , S17070C13_nt {
  ::S17070C14_nt s15656c3f0;
  ::S17070C51_nt s15656c3f1;
  ::S17070C22_nt s15656c3f2;
  ::S17070C22_nt s15656c3f3;
  ::S17070C22_nt s15656c3f4;
  ::S17070C22_nt s15656c3f5;
  ::S17070C22_nt s15656c3f6;
  virtual void  v1(); // _ZN8S15656C32v1Ev
  virtual void  v2(); // _ZN8S15656C32v2Ev
  virtual void  v3(); // _ZN8S15656C32v3Ev
  virtual void  v4(); // _ZN8S15656C32v4Ev
  virtual void  v5(); // _ZN8S15656C32v5Ev
  virtual void  v6(); // _ZN8S15656C32v6Ev
  ~S15656C3(); // tgen
  S15656C3(); // tgen
};
//SIG(-1 S15656C3) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC8} FC11{ BC6 FC12{ m FC13{ m FL}}} FC11 FC11 FC11 FC11}


void  S15656C3 ::v1(){vfunc_called(this, "_ZN8S15656C32v1Ev");}
void  S15656C3 ::v2(){vfunc_called(this, "_ZN8S15656C32v2Ev");}
void  S15656C3 ::v3(){vfunc_called(this, "_ZN8S15656C32v3Ev");}
void  S15656C3 ::v4(){vfunc_called(this, "_ZN8S15656C32v4Ev");}
void  S15656C3 ::v5(){vfunc_called(this, "_ZN8S15656C32v5Ev");}
void  S15656C3 ::v6(){vfunc_called(this, "_ZN8S15656C32v6Ev");}
S15656C3 ::~S15656C3(){ note_dtor("S15656C3", this);} // tgen
S15656C3 ::S15656C3(){ note_ctor("S15656C3", this);} // tgen

static void Test_S15656C3()
{
  extern Class_Descriptor cd_S15656C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,71)];
    init_test(&cd_S15656C3, buf);
    S15656C3 *dp, &lv = *(dp=new (buf) S15656C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,280), "sizeof(S15656C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15656C3)");
    check_base_class_offset(lv, (S15656C4*), 0, "S15656C3");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S15656C3");
    check_field_offset(lv, s15656c3f0, ABISELECT(40,20), "S15656C3.s15656c3f0");
    check_field_offset(lv, s15656c3f1, ABISELECT(136,104), "S15656C3.s15656c3f1");
    check_field_offset(lv, s15656c3f2, ABISELECT(184,140), "S15656C3.s15656c3f2");
    check_field_offset(lv, s15656c3f3, ABISELECT(224,168), "S15656C3.s15656c3f3");
    check_field_offset(lv, s15656c3f4, ABISELECT(264,196), "S15656C3.s15656c3f4");
    check_field_offset(lv, s15656c3f5, ABISELECT(304,224), "S15656C3.s15656c3f5");
    check_field_offset(lv, s15656c3f6, ABISELECT(344,252), "S15656C3.s15656c3f6");
    test_class_info(&lv, &cd_S15656C3);
    dp->~S15656C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15656C3(Test_S15656C3, "S15656C3", ABISELECT(384,280));

#else // __cplusplus

extern void _ZN8S15656C3C1Ev();
extern void _ZN8S15656C3D1Ev();
Name_Map name_map_S15656C3[] = {
  NSPAIR(_ZN8S15656C3C1Ev),
  NSPAIR(_ZN8S15656C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15656C4;
extern VTBL_ENTRY _ZTI8S15656C4[];
extern  VTBL_ENTRY _ZTV8S15656C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S15656C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15656C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S15656C3[];
extern void _ZN8S15656C3D1Ev();
extern void _ZN8S15656C3D0Ev();
extern void _ZN8S15656C42v7Ev();
extern void _ZN8S15656C42v8Ev();
extern void _ZN8S15656C42v9Ev();
extern void _ZN8S15656C43v10Ev();
extern void _ZN8S15656C43v11Ev();
extern void _ZN8S15656C43v12Ev();
extern void _ZN8S15656C32v1Ev();
extern void _ZN8S15656C32v2Ev();
extern void _ZN8S15656C32v3Ev();
extern void _ZN8S15656C32v4Ev();
extern void _ZN8S15656C32v5Ev();
extern void _ZN8S15656C32v6Ev();
static  VTBL_ENTRY vtc_S15656C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15656C3[0]),
  (VTBL_ENTRY)&_ZN8S15656C3D1Ev,
  (VTBL_ENTRY)&_ZN8S15656C3D0Ev,
  (VTBL_ENTRY)&_ZN8S15656C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15656C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15656C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15656C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15656C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15656C43v12Ev,
  (VTBL_ENTRY)&_ZN8S15656C32v1Ev,
  (VTBL_ENTRY)&_ZN8S15656C32v2Ev,
  (VTBL_ENTRY)&_ZN8S15656C32v3Ev,
  (VTBL_ENTRY)&_ZN8S15656C32v4Ev,
  (VTBL_ENTRY)&_ZN8S15656C32v5Ev,
  (VTBL_ENTRY)&_ZN8S15656C32v6Ev,
};
extern VTBL_ENTRY _ZTI8S15656C3[];
extern  VTBL_ENTRY _ZTV8S15656C3[];
Class_Descriptor cd_S15656C3 = {  "S15656C3", // class name
  bases_S15656C3, 2,
  &(vtc_S15656C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,280), // object size
  NSPAIRA(_ZTI8S15656C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S15656C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15656C2  {
  ::S15656C3 s15656c2f0;
  ::S17070C26_nt s15656c2f1;
  void  mf15656c2(); // _ZN8S15656C29mf15656c2Ev
};
//SIG(-1 S15656C2) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC9} FC12{ BC7 FC13{ m FC14{ m FL}}} FC12 FC12 FC12 FC12} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC21}}}


void  S15656C2 ::mf15656c2(){}

static void Test_S15656C2()
{
  {
    init_simple_test("S15656C2");
    S15656C2 lv;
    check2(sizeof(lv), ABISELECT(584,444), "sizeof(S15656C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15656C2)");
    check_field_offset(lv, s15656c2f0, 0, "S15656C2.s15656c2f0");
    check_field_offset(lv, s15656c2f1, ABISELECT(384,280), "S15656C2.s15656c2f1");
  }
}
static Arrange_To_Call_Me vS15656C2(Test_S15656C2, "S15656C2", ABISELECT(584,444));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15656C1  {
  ::S15656C2 s15656c1f0;
  ::S11971C38 s15656c1f1;
  void  mf15656c1(); // _ZN8S15656C19mf15656c1Ev
};
//SIG(1 S15656C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC10} FC13{ BC8 FC14{ m FC15{ m FL}}} FC13 FC13 FC13 FC13} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC22}}} FC26{ m FC27{ BC28{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC29{ BC8 FC30{ m FC31{ m Fp[2]} FC32{ m Fp}}} FC12} FC33{ BC34{ BC18 vd v27 Fp[2] FC19 FC35{ m Fp[2]}} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC22}}}}


void  S15656C1 ::mf15656c1(){}

static void Test_S15656C1()
{
  {
    init_simple_test("S15656C1");
    static S15656C1 lv;
    check2(sizeof(lv), ABISELECT(832,592), "sizeof(S15656C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15656C1)");
    check_field_offset(lv, s15656c1f0, 0, "S15656C1.s15656c1f0");
    check_field_offset(lv, s15656c1f1, ABISELECT(584,444), "S15656C1.s15656c1f1");
  }
}
static Arrange_To_Call_Me vS15656C1(Test_S15656C1, "S15656C1", ABISELECT(832,592));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15655C4  {
  ::S17070C12_nt s15655c4f0;
  virtual  ~S15655C4(); // _ZN8S15655C4D1Ev
  virtual void  v7(); // _ZN8S15655C42v7Ev
  virtual void  v8(); // _ZN8S15655C42v8Ev
  virtual void  v9(); // _ZN8S15655C42v9Ev
  virtual void  v10(); // _ZN8S15655C43v10Ev
  virtual void  v11(); // _ZN8S15655C43v11Ev
  virtual void  v12(); // _ZN8S15655C43v12Ev
  S15655C4(); // tgen
};
//SIG(-1 S15655C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15655C4 ::~S15655C4(){ note_dtor("S15655C4", this);}
void  S15655C4 ::v7(){vfunc_called(this, "_ZN8S15655C42v7Ev");}
void  S15655C4 ::v8(){vfunc_called(this, "_ZN8S15655C42v8Ev");}
void  S15655C4 ::v9(){vfunc_called(this, "_ZN8S15655C42v9Ev");}
void  S15655C4 ::v10(){vfunc_called(this, "_ZN8S15655C43v10Ev");}
void  S15655C4 ::v11(){vfunc_called(this, "_ZN8S15655C43v11Ev");}
void  S15655C4 ::v12(){vfunc_called(this, "_ZN8S15655C43v12Ev");}
S15655C4 ::S15655C4(){ note_ctor("S15655C4", this);} // tgen

static void Test_S15655C4()
{
  extern Class_Descriptor cd_S15655C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15655C4, buf);
    S15655C4 *dp, &lv = *(dp=new (buf) S15655C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15655C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15655C4)");
    check_field_offset(lv, s15655c4f0, ABISELECT(8,4), "S15655C4.s15655c4f0");
    test_class_info(&lv, &cd_S15655C4);
    dp->~S15655C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15655C4(Test_S15655C4, "S15655C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15655C4C1Ev();
extern void _ZN8S15655C4D1Ev();
Name_Map name_map_S15655C4[] = {
  NSPAIR(_ZN8S15655C4C1Ev),
  NSPAIR(_ZN8S15655C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15655C4[];
extern void _ZN8S15655C4D1Ev();
extern void _ZN8S15655C4D0Ev();
extern void _ZN8S15655C42v7Ev();
extern void _ZN8S15655C42v8Ev();
extern void _ZN8S15655C42v9Ev();
extern void _ZN8S15655C43v10Ev();
extern void _ZN8S15655C43v11Ev();
extern void _ZN8S15655C43v12Ev();
static  VTBL_ENTRY vtc_S15655C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15655C4[0]),
  (VTBL_ENTRY)&_ZN8S15655C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15655C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15655C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15655C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15655C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15655C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15655C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15655C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15655C4[];
extern  VTBL_ENTRY _ZTV8S15655C4[];
Class_Descriptor cd_S15655C4 = {  "S15655C4", // class name
  0,0,//no base classes
  &(vtc_S15655C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15655C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15655C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15655C3  : S15655C4 , S17070C13_nt {
  ::S17070C14_nt s15655c3f0;
  ::S17070C51_nt s15655c3f1;
  ::S17070C22_nt s15655c3f2;
  ::S17070C51_nt s15655c3f3;
  ::S17070C22_nt s15655c3f4;
  virtual void  v1(); // _ZN8S15655C32v1Ev
  virtual void  v2(); // _ZN8S15655C32v2Ev
  virtual void  v3(); // _ZN8S15655C32v3Ev
  virtual void  v4(); // _ZN8S15655C32v4Ev
  virtual void  v5(); // _ZN8S15655C32v5Ev
  virtual void  v6(); // _ZN8S15655C32v6Ev
  ~S15655C3(); // tgen
  S15655C3(); // tgen
};
//SIG(-1 S15655C3) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC8} FC11{ BC6 FC12{ m FC13{ m FL}}} FC10 FC11}


void  S15655C3 ::v1(){vfunc_called(this, "_ZN8S15655C32v1Ev");}
void  S15655C3 ::v2(){vfunc_called(this, "_ZN8S15655C32v2Ev");}
void  S15655C3 ::v3(){vfunc_called(this, "_ZN8S15655C32v3Ev");}
void  S15655C3 ::v4(){vfunc_called(this, "_ZN8S15655C32v4Ev");}
void  S15655C3 ::v5(){vfunc_called(this, "_ZN8S15655C32v5Ev");}
void  S15655C3 ::v6(){vfunc_called(this, "_ZN8S15655C32v6Ev");}
S15655C3 ::~S15655C3(){ note_dtor("S15655C3", this);} // tgen
S15655C3 ::S15655C3(){ note_ctor("S15655C3", this);} // tgen

static void Test_S15655C3()
{
  extern Class_Descriptor cd_S15655C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,59)];
    init_test(&cd_S15655C3, buf);
    S15655C3 *dp, &lv = *(dp=new (buf) S15655C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,232), "sizeof(S15655C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15655C3)");
    check_base_class_offset(lv, (S15655C4*), 0, "S15655C3");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S15655C3");
    check_field_offset(lv, s15655c3f0, ABISELECT(40,20), "S15655C3.s15655c3f0");
    check_field_offset(lv, s15655c3f1, ABISELECT(136,104), "S15655C3.s15655c3f1");
    check_field_offset(lv, s15655c3f2, ABISELECT(184,140), "S15655C3.s15655c3f2");
    check_field_offset(lv, s15655c3f3, ABISELECT(224,168), "S15655C3.s15655c3f3");
    check_field_offset(lv, s15655c3f4, ABISELECT(272,204), "S15655C3.s15655c3f4");
    test_class_info(&lv, &cd_S15655C3);
    dp->~S15655C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15655C3(Test_S15655C3, "S15655C3", ABISELECT(312,232));

#else // __cplusplus

extern void _ZN8S15655C3C1Ev();
extern void _ZN8S15655C3D1Ev();
Name_Map name_map_S15655C3[] = {
  NSPAIR(_ZN8S15655C3C1Ev),
  NSPAIR(_ZN8S15655C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15655C4;
extern VTBL_ENTRY _ZTI8S15655C4[];
extern  VTBL_ENTRY _ZTV8S15655C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S15655C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15655C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S15655C3[];
extern void _ZN8S15655C3D1Ev();
extern void _ZN8S15655C3D0Ev();
extern void _ZN8S15655C42v7Ev();
extern void _ZN8S15655C42v8Ev();
extern void _ZN8S15655C42v9Ev();
extern void _ZN8S15655C43v10Ev();
extern void _ZN8S15655C43v11Ev();
extern void _ZN8S15655C43v12Ev();
extern void _ZN8S15655C32v1Ev();
extern void _ZN8S15655C32v2Ev();
extern void _ZN8S15655C32v3Ev();
extern void _ZN8S15655C32v4Ev();
extern void _ZN8S15655C32v5Ev();
extern void _ZN8S15655C32v6Ev();
static  VTBL_ENTRY vtc_S15655C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15655C3[0]),
  (VTBL_ENTRY)&_ZN8S15655C3D1Ev,
  (VTBL_ENTRY)&_ZN8S15655C3D0Ev,
  (VTBL_ENTRY)&_ZN8S15655C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15655C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15655C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15655C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15655C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15655C43v12Ev,
  (VTBL_ENTRY)&_ZN8S15655C32v1Ev,
  (VTBL_ENTRY)&_ZN8S15655C32v2Ev,
  (VTBL_ENTRY)&_ZN8S15655C32v3Ev,
  (VTBL_ENTRY)&_ZN8S15655C32v4Ev,
  (VTBL_ENTRY)&_ZN8S15655C32v5Ev,
  (VTBL_ENTRY)&_ZN8S15655C32v6Ev,
};
extern VTBL_ENTRY _ZTI8S15655C3[];
extern  VTBL_ENTRY _ZTV8S15655C3[];
Class_Descriptor cd_S15655C3 = {  "S15655C3", // class name
  bases_S15655C3, 2,
  &(vtc_S15655C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,232), // object size
  NSPAIRA(_ZTI8S15655C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S15655C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15655C2  {
  ::S15655C3 s15655c2f0;
  ::S17070C26_nt s15655c2f1;
  void  mf15655c2(); // _ZN8S15655C29mf15655c2Ev
};
//SIG(-1 S15655C2) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC9} FC12{ BC7 FC13{ m FC14{ m FL}}} FC11 FC12} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC21}}}


void  S15655C2 ::mf15655c2(){}

static void Test_S15655C2()
{
  {
    init_simple_test("S15655C2");
    S15655C2 lv;
    check2(sizeof(lv), ABISELECT(512,396), "sizeof(S15655C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15655C2)");
    check_field_offset(lv, s15655c2f0, 0, "S15655C2.s15655c2f0");
    check_field_offset(lv, s15655c2f1, ABISELECT(312,232), "S15655C2.s15655c2f1");
  }
}
static Arrange_To_Call_Me vS15655C2(Test_S15655C2, "S15655C2", ABISELECT(512,396));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15655C1  {
  ::S15655C2 s15655c1f0;
  ::S11971C21 s15655c1f1;
  void  mf15655c1(); // _ZN8S15655C19mf15655c1Ev
};
//SIG(1 S15655C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC10} FC13{ BC8 FC14{ m FC15{ m FL}}} FC12 FC13} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC22}}} FC26{ m FC27{ BC28{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC29{ BC8 FC30{ m FC31{ m Fp[2]} FC32{ m Fp}}} FC29 FC12} FC33{ BC34{ BC18 vd v27 Fp[2] FC19 FC35{ m Fp[2]}} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC22}}}}


void  S15655C1 ::mf15655c1(){}

static void Test_S15655C1()
{
  {
    init_simple_test("S15655C1");
    static S15655C1 lv;
    check2(sizeof(lv), ABISELECT(816,576), "sizeof(S15655C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15655C1)");
    check_field_offset(lv, s15655c1f0, 0, "S15655C1.s15655c1f0");
    check_field_offset(lv, s15655c1f1, ABISELECT(512,396), "S15655C1.s15655c1f1");
  }
}
static Arrange_To_Call_Me vS15655C1(Test_S15655C1, "S15655C1", ABISELECT(816,576));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15665C4  {
  ::S17070C12_nt s15665c4f0;
  virtual  ~S15665C4(); // _ZN8S15665C4D1Ev
  virtual void  v7(); // _ZN8S15665C42v7Ev
  virtual void  v8(); // _ZN8S15665C42v8Ev
  virtual void  v9(); // _ZN8S15665C42v9Ev
  virtual void  v10(); // _ZN8S15665C43v10Ev
  virtual void  v11(); // _ZN8S15665C43v11Ev
  virtual void  v12(); // _ZN8S15665C43v12Ev
  S15665C4(); // tgen
};
//SIG(-1 S15665C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15665C4 ::~S15665C4(){ note_dtor("S15665C4", this);}
void  S15665C4 ::v7(){vfunc_called(this, "_ZN8S15665C42v7Ev");}
void  S15665C4 ::v8(){vfunc_called(this, "_ZN8S15665C42v8Ev");}
void  S15665C4 ::v9(){vfunc_called(this, "_ZN8S15665C42v9Ev");}
void  S15665C4 ::v10(){vfunc_called(this, "_ZN8S15665C43v10Ev");}
void  S15665C4 ::v11(){vfunc_called(this, "_ZN8S15665C43v11Ev");}
void  S15665C4 ::v12(){vfunc_called(this, "_ZN8S15665C43v12Ev");}
S15665C4 ::S15665C4(){ note_ctor("S15665C4", this);} // tgen

static void Test_S15665C4()
{
  extern Class_Descriptor cd_S15665C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15665C4, buf);
    S15665C4 *dp, &lv = *(dp=new (buf) S15665C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15665C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15665C4)");
    check_field_offset(lv, s15665c4f0, ABISELECT(8,4), "S15665C4.s15665c4f0");
    test_class_info(&lv, &cd_S15665C4);
    dp->~S15665C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15665C4(Test_S15665C4, "S15665C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15665C4C1Ev();
extern void _ZN8S15665C4D1Ev();
Name_Map name_map_S15665C4[] = {
  NSPAIR(_ZN8S15665C4C1Ev),
  NSPAIR(_ZN8S15665C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15665C4[];
extern void _ZN8S15665C4D1Ev();
extern void _ZN8S15665C4D0Ev();
extern void _ZN8S15665C42v7Ev();
extern void _ZN8S15665C42v8Ev();
extern void _ZN8S15665C42v9Ev();
extern void _ZN8S15665C43v10Ev();
extern void _ZN8S15665C43v11Ev();
extern void _ZN8S15665C43v12Ev();
static  VTBL_ENTRY vtc_S15665C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15665C4[0]),
  (VTBL_ENTRY)&_ZN8S15665C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15665C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15665C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15665C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15665C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15665C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15665C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15665C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15665C4[];
extern  VTBL_ENTRY _ZTV8S15665C4[];
Class_Descriptor cd_S15665C4 = {  "S15665C4", // class name
  0,0,//no base classes
  &(vtc_S15665C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15665C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15665C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15665C3  : S15665C4 , S17070C13_nt {
  ::S17070C14_nt s15665c3f0;
  ::S17070C22_nt s15665c3f1;
  virtual void  v1(); // _ZN8S15665C32v1Ev
  virtual void  v2(); // _ZN8S15665C32v2Ev
  virtual void  v3(); // _ZN8S15665C32v3Ev
  virtual void  v4(); // _ZN8S15665C32v4Ev
  virtual void  v5(); // _ZN8S15665C32v5Ev
  virtual void  v6(); // _ZN8S15665C32v6Ev
  ~S15665C3(); // tgen
  S15665C3(); // tgen
};
//SIG(-1 S15665C3) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m FL}}}}


void  S15665C3 ::v1(){vfunc_called(this, "_ZN8S15665C32v1Ev");}
void  S15665C3 ::v2(){vfunc_called(this, "_ZN8S15665C32v2Ev");}
void  S15665C3 ::v3(){vfunc_called(this, "_ZN8S15665C32v3Ev");}
void  S15665C3 ::v4(){vfunc_called(this, "_ZN8S15665C32v4Ev");}
void  S15665C3 ::v5(){vfunc_called(this, "_ZN8S15665C32v5Ev");}
void  S15665C3 ::v6(){vfunc_called(this, "_ZN8S15665C32v6Ev");}
S15665C3 ::~S15665C3(){ note_dtor("S15665C3", this);} // tgen
S15665C3 ::S15665C3(){ note_ctor("S15665C3", this);} // tgen

static void Test_S15665C3()
{
  extern Class_Descriptor cd_S15665C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,34)];
    init_test(&cd_S15665C3, buf);
    S15665C3 *dp, &lv = *(dp=new (buf) S15665C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,132), "sizeof(S15665C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15665C3)");
    check_base_class_offset(lv, (S15665C4*), 0, "S15665C3");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S15665C3");
    check_field_offset(lv, s15665c3f0, ABISELECT(40,20), "S15665C3.s15665c3f0");
    check_field_offset(lv, s15665c3f1, ABISELECT(136,104), "S15665C3.s15665c3f1");
    test_class_info(&lv, &cd_S15665C3);
    dp->~S15665C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15665C3(Test_S15665C3, "S15665C3", ABISELECT(176,132));

#else // __cplusplus

extern void _ZN8S15665C3C1Ev();
extern void _ZN8S15665C3D1Ev();
Name_Map name_map_S15665C3[] = {
  NSPAIR(_ZN8S15665C3C1Ev),
  NSPAIR(_ZN8S15665C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15665C4;
extern VTBL_ENTRY _ZTI8S15665C4[];
extern  VTBL_ENTRY _ZTV8S15665C4[];
extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S15665C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15665C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S15665C3[];
extern void _ZN8S15665C3D1Ev();
extern void _ZN8S15665C3D0Ev();
extern void _ZN8S15665C42v7Ev();
extern void _ZN8S15665C42v8Ev();
extern void _ZN8S15665C42v9Ev();
extern void _ZN8S15665C43v10Ev();
extern void _ZN8S15665C43v11Ev();
extern void _ZN8S15665C43v12Ev();
extern void _ZN8S15665C32v1Ev();
extern void _ZN8S15665C32v2Ev();
extern void _ZN8S15665C32v3Ev();
extern void _ZN8S15665C32v4Ev();
extern void _ZN8S15665C32v5Ev();
extern void _ZN8S15665C32v6Ev();
static  VTBL_ENTRY vtc_S15665C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15665C3[0]),
  (VTBL_ENTRY)&_ZN8S15665C3D1Ev,
  (VTBL_ENTRY)&_ZN8S15665C3D0Ev,
  (VTBL_ENTRY)&_ZN8S15665C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15665C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15665C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15665C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15665C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15665C43v12Ev,
  (VTBL_ENTRY)&_ZN8S15665C32v1Ev,
  (VTBL_ENTRY)&_ZN8S15665C32v2Ev,
  (VTBL_ENTRY)&_ZN8S15665C32v3Ev,
  (VTBL_ENTRY)&_ZN8S15665C32v4Ev,
  (VTBL_ENTRY)&_ZN8S15665C32v5Ev,
  (VTBL_ENTRY)&_ZN8S15665C32v6Ev,
};
extern VTBL_ENTRY _ZTI8S15665C3[];
extern  VTBL_ENTRY _ZTV8S15665C3[];
Class_Descriptor cd_S15665C3 = {  "S15665C3", // class name
  bases_S15665C3, 2,
  &(vtc_S15665C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,132), // object size
  NSPAIRA(_ZTI8S15665C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S15665C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15665C2  {
  ::S15665C3 s15665c2f0;
  ::S17070C26_nt s15665c2f1;
  void  mf15665c2(); // _ZN8S15665C29mf15665c2Ev
};
//SIG(-1 S15665C2) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m FC22{ Fs[2] Fc[2] Fs}[12] Fi FC23{ Fs[2]}[4] Fi FC20}}}


void  S15665C2 ::mf15665c2(){}

static void Test_S15665C2()
{
  {
    init_simple_test("S15665C2");
    S15665C2 lv;
    check2(sizeof(lv), ABISELECT(376,296), "sizeof(S15665C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15665C2)");
    check_field_offset(lv, s15665c2f0, 0, "S15665C2.s15665c2f0");
    check_field_offset(lv, s15665c2f1, ABISELECT(176,132), "S15665C2.s15665c2f1");
  }
}
static Arrange_To_Call_Me vS15665C2(Test_S15665C2, "S15665C2", ABISELECT(376,296));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15665C1  {
  ::S15665C2 s15665c1f0;
  ::S11971C38 s15665c1f1;
  void  mf15665c1(); // _ZN8S15665C19mf15665c1Ev
};
//SIG(1 S15665C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC14{ m FL}}}} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC21}}} FC25{ m FC26{ BC27{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC28{ BC8 FC29{ m FC30{ m Fp[2]} FC31{ m Fp}}} FC32{ BC8 FC10}} FC33{ BC34{ BC17 vd v27 Fp[2] FC18 FC35{ m Fp[2]}} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC21}}}}


void  S15665C1 ::mf15665c1(){}

static void Test_S15665C1()
{
  {
    init_simple_test("S15665C1");
    static S15665C1 lv;
    check2(sizeof(lv), ABISELECT(624,444), "sizeof(S15665C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15665C1)");
    check_field_offset(lv, s15665c1f0, 0, "S15665C1.s15665c1f0");
    check_field_offset(lv, s15665c1f1, ABISELECT(376,296), "S15665C1.s15665c1f1");
  }
}
static Arrange_To_Call_Me vS15665C1(Test_S15665C1, "S15665C1", ABISELECT(624,444));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15669C1  {
  ::S17070C47 s15669c1f0;
  ::S11971C38 s15669c1f1;
  void  mf15669c1(); // _ZN8S15669C19mf15669c1Ev
};
//SIG(1 S15669C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC18}}} FC22{ m FC23{ BC24{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC25{ BC8 FC26{ m FC27{ m Fp[2]} FC28{ m Fp}}} FC29{ BC8 FC10}} FC30{ BC31{ BC14 vd v27 Fp[2] FC15 FC32{ m Fp[2]}} vd FC33{ m Fp Fi FC34{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC18}}}}


void  S15669C1 ::mf15669c1(){}

static void Test_S15669C1()
{
  {
    init_simple_test("S15669C1");
    static S15669C1 lv;
    check2(sizeof(lv), ABISELECT(584,416), "sizeof(S15669C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15669C1)");
    check_field_offset(lv, s15669c1f0, 0, "S15669C1.s15669c1f0");
    check_field_offset(lv, s15669c1f1, ABISELECT(336,268), "S15669C1.s15669c1f1");
  }
}
static Arrange_To_Call_Me vS15669C1(Test_S15669C1, "S15669C1", ABISELECT(584,416));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15672C1  {
  ::S17070C47 s15672c1f0;
  ::S17070C37 s15672c1f1;
  void  mf15672c1(); // _ZN8S15672C19mf15672c1Ev
};
//SIG(1 S15672C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC18}}} FC22{ m FC23{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC24{ BC8 FC25{ m FC26{ m Fp[2]} FC27{ m Fp}}}} FC28{ BC29{ BC14 vd v21 Fp[2] FC15 FC30{ m Fp[2]}} vd FC31{ m Fp Fi FC32{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC18}}}}


void  S15672C1 ::mf15672c1(){}

static void Test_S15672C1()
{
  {
    init_simple_test("S15672C1");
    static S15672C1 lv;
    check2(sizeof(lv), ABISELECT(536,380), "sizeof(S15672C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15672C1)");
    check_field_offset(lv, s15672c1f0, 0, "S15672C1.s15672c1f0");
    check_field_offset(lv, s15672c1f1, ABISELECT(336,268), "S15672C1.s15672c1f1");
  }
}
static Arrange_To_Call_Me vS15672C1(Test_S15672C1, "S15672C1", ABISELECT(536,380));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15668C1  {
  ::S17070C47 s15668c1f0;
  ::S11971C2 s15668c1f1;
  void  mf15668c1(); // _ZN8S15668C19mf15668c1Ev
};
//SIG(1 S15668C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC18}}} FC22{ m FC23{ BC24{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC25{ BC8 FC10}} FC26{ BC27{ BC14 vd v27 Fp[2] FC15 FC28{ m Fp[2]}} vd FC29{ m Fp Fi FC30{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC18}}}}


void  S15668C1 ::mf15668c1(){}

static void Test_S15668C1()
{
  {
    init_simple_test("S15668C1");
    static S15668C1 lv;
    check2(sizeof(lv), ABISELECT(528,384), "sizeof(S15668C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15668C1)");
    check_field_offset(lv, s15668c1f0, 0, "S15668C1.s15668c1f0");
    check_field_offset(lv, s15668c1f1, ABISELECT(336,268), "S15668C1.s15668c1f1");
  }
}
static Arrange_To_Call_Me vS15668C1(Test_S15668C1, "S15668C1", ABISELECT(528,384));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6957C2_nt  {
  int s6957c2f0;
  __tsi64 s6957c2f1;
  void *s6957c2f2[4];
  int s6957c2f3[2];
  void *s6957c2f4;
  ::S17070C7_nt s6957c2f5;
  void *s6957c2f6[2];
  virtual  ~S6957C2_nt(); // _ZN10S6957C2_ntD1Ev
  virtual void  v5(); // _ZN10S6957C2_nt2v5Ev
  virtual void  v6(); // _ZN10S6957C2_nt2v6Ev
  virtual void  v7(); // _ZN10S6957C2_nt2v7Ev
  virtual void  v8(); // _ZN10S6957C2_nt2v8Ev
  virtual void  v9(); // _ZN10S6957C2_nt2v9Ev
  virtual void  v10(); // _ZN10S6957C2_nt3v10Ev
  virtual void  v11(); // _ZN10S6957C2_nt3v11Ev
  virtual void  v12(); // _ZN10S6957C2_nt3v12Ev
  virtual void  v13(); // _ZN10S6957C2_nt3v13Ev
  virtual void  v14(); // _ZN10S6957C2_nt3v14Ev
  virtual void  v15(); // _ZN10S6957C2_nt3v15Ev
  virtual void  v16(); // _ZN10S6957C2_nt3v16Ev
  virtual void  v17(); // _ZN10S6957C2_nt3v17Ev
  virtual void  v18(); // _ZN10S6957C2_nt3v18Ev
  virtual void  v19(); // _ZN10S6957C2_nt3v19Ev
  virtual void  v20(); // _ZN10S6957C2_nt3v20Ev
  virtual void  v21(); // _ZN10S6957C2_nt3v21Ev
  virtual void  v22(); // _ZN10S6957C2_nt3v22Ev
  virtual void  v23(); // _ZN10S6957C2_nt3v23Ev
  virtual void  v24(); // _ZN10S6957C2_nt3v24Ev
  virtual void  v25(); // _ZN10S6957C2_nt3v25Ev
  virtual void  v26(); // _ZN10S6957C2_nt3v26Ev
  virtual void  v27(); // _ZN10S6957C2_nt3v27Ev
  virtual void  v28(); // _ZN10S6957C2_nt3v28Ev
  virtual void  v29(); // _ZN10S6957C2_nt3v29Ev
  virtual void  v30(); // _ZN10S6957C2_nt3v30Ev
  virtual void  v31(); // _ZN10S6957C2_nt3v31Ev
  virtual void  v32(); // _ZN10S6957C2_nt3v32Ev
  virtual void  v33(); // _ZN10S6957C2_nt3v33Ev
  virtual void  v34(); // _ZN10S6957C2_nt3v34Ev
  virtual void  v35(); // _ZN10S6957C2_nt3v35Ev
  virtual void  v36(); // _ZN10S6957C2_nt3v36Ev
  virtual void  v37(); // _ZN10S6957C2_nt3v37Ev
  virtual void  v38(); // _ZN10S6957C2_nt3v38Ev
  virtual void  v39(); // _ZN10S6957C2_nt3v39Ev
  virtual void  v40(); // _ZN10S6957C2_nt3v40Ev
  virtual void  v41(); // _ZN10S6957C2_nt3v41Ev
  virtual void  v42(); // _ZN10S6957C2_nt3v42Ev
  virtual void  v43(); // _ZN10S6957C2_nt3v43Ev
  virtual void  v44(); // _ZN10S6957C2_nt3v44Ev
  virtual void  v45(); // _ZN10S6957C2_nt3v45Ev
  virtual void  v46(); // _ZN10S6957C2_nt3v46Ev
  virtual void  v47(); // _ZN10S6957C2_nt3v47Ev
  virtual void  v48(); // _ZN10S6957C2_nt3v48Ev
  virtual void  v49(); // _ZN10S6957C2_nt3v49Ev
  virtual void  v50(); // _ZN10S6957C2_nt3v50Ev
  virtual void  v51(); // _ZN10S6957C2_nt3v51Ev
  virtual void  v52(); // _ZN10S6957C2_nt3v52Ev
  virtual void  v53(); // _ZN10S6957C2_nt3v53Ev
  virtual void  v54(); // _ZN10S6957C2_nt3v54Ev
  virtual void  v55(); // _ZN10S6957C2_nt3v55Ev
  virtual void  v56(); // _ZN10S6957C2_nt3v56Ev
  virtual void  v57(); // _ZN10S6957C2_nt3v57Ev
  virtual void  v58(); // _ZN10S6957C2_nt3v58Ev
  virtual void  v59(); // _ZN10S6957C2_nt3v59Ev
  virtual void  v60(); // _ZN10S6957C2_nt3v60Ev
  virtual void  v61(); // _ZN10S6957C2_nt3v61Ev
  virtual void  v62(); // _ZN10S6957C2_nt3v62Ev
  virtual void  v63(); // _ZN10S6957C2_nt3v63Ev
  virtual void  v64(); // _ZN10S6957C2_nt3v64Ev
  virtual void  v65(); // _ZN10S6957C2_nt3v65Ev
  virtual void  v66(); // _ZN10S6957C2_nt3v66Ev
  virtual void  v67(); // _ZN10S6957C2_nt3v67Ev
  virtual void  v68(); // _ZN10S6957C2_nt3v68Ev
  S6957C2_nt(); // tgen
};
//SIG(-1 S6957C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S6957C2_nt ::~S6957C2_nt(){ note_dtor("S6957C2_nt", this);}
void  S6957C2_nt ::v5(){vfunc_called(this, "_ZN10S6957C2_nt2v5Ev");}
void  S6957C2_nt ::v6(){vfunc_called(this, "_ZN10S6957C2_nt2v6Ev");}
void  S6957C2_nt ::v7(){vfunc_called(this, "_ZN10S6957C2_nt2v7Ev");}
void  S6957C2_nt ::v8(){vfunc_called(this, "_ZN10S6957C2_nt2v8Ev");}
void  S6957C2_nt ::v9(){vfunc_called(this, "_ZN10S6957C2_nt2v9Ev");}
void  S6957C2_nt ::v10(){vfunc_called(this, "_ZN10S6957C2_nt3v10Ev");}
void  S6957C2_nt ::v11(){vfunc_called(this, "_ZN10S6957C2_nt3v11Ev");}
void  S6957C2_nt ::v12(){vfunc_called(this, "_ZN10S6957C2_nt3v12Ev");}
void  S6957C2_nt ::v13(){vfunc_called(this, "_ZN10S6957C2_nt3v13Ev");}
void  S6957C2_nt ::v14(){vfunc_called(this, "_ZN10S6957C2_nt3v14Ev");}
void  S6957C2_nt ::v15(){vfunc_called(this, "_ZN10S6957C2_nt3v15Ev");}
void  S6957C2_nt ::v16(){vfunc_called(this, "_ZN10S6957C2_nt3v16Ev");}
void  S6957C2_nt ::v17(){vfunc_called(this, "_ZN10S6957C2_nt3v17Ev");}
void  S6957C2_nt ::v18(){vfunc_called(this, "_ZN10S6957C2_nt3v18Ev");}
void  S6957C2_nt ::v19(){vfunc_called(this, "_ZN10S6957C2_nt3v19Ev");}
void  S6957C2_nt ::v20(){vfunc_called(this, "_ZN10S6957C2_nt3v20Ev");}
void  S6957C2_nt ::v21(){vfunc_called(this, "_ZN10S6957C2_nt3v21Ev");}
void  S6957C2_nt ::v22(){vfunc_called(this, "_ZN10S6957C2_nt3v22Ev");}
void  S6957C2_nt ::v23(){vfunc_called(this, "_ZN10S6957C2_nt3v23Ev");}
void  S6957C2_nt ::v24(){vfunc_called(this, "_ZN10S6957C2_nt3v24Ev");}
void  S6957C2_nt ::v25(){vfunc_called(this, "_ZN10S6957C2_nt3v25Ev");}
void  S6957C2_nt ::v26(){vfunc_called(this, "_ZN10S6957C2_nt3v26Ev");}
void  S6957C2_nt ::v27(){vfunc_called(this, "_ZN10S6957C2_nt3v27Ev");}
void  S6957C2_nt ::v28(){vfunc_called(this, "_ZN10S6957C2_nt3v28Ev");}
void  S6957C2_nt ::v29(){vfunc_called(this, "_ZN10S6957C2_nt3v29Ev");}
void  S6957C2_nt ::v30(){vfunc_called(this, "_ZN10S6957C2_nt3v30Ev");}
void  S6957C2_nt ::v31(){vfunc_called(this, "_ZN10S6957C2_nt3v31Ev");}
void  S6957C2_nt ::v32(){vfunc_called(this, "_ZN10S6957C2_nt3v32Ev");}
void  S6957C2_nt ::v33(){vfunc_called(this, "_ZN10S6957C2_nt3v33Ev");}
void  S6957C2_nt ::v34(){vfunc_called(this, "_ZN10S6957C2_nt3v34Ev");}
void  S6957C2_nt ::v35(){vfunc_called(this, "_ZN10S6957C2_nt3v35Ev");}
void  S6957C2_nt ::v36(){vfunc_called(this, "_ZN10S6957C2_nt3v36Ev");}
void  S6957C2_nt ::v37(){vfunc_called(this, "_ZN10S6957C2_nt3v37Ev");}
void  S6957C2_nt ::v38(){vfunc_called(this, "_ZN10S6957C2_nt3v38Ev");}
void  S6957C2_nt ::v39(){vfunc_called(this, "_ZN10S6957C2_nt3v39Ev");}
void  S6957C2_nt ::v40(){vfunc_called(this, "_ZN10S6957C2_nt3v40Ev");}
void  S6957C2_nt ::v41(){vfunc_called(this, "_ZN10S6957C2_nt3v41Ev");}
void  S6957C2_nt ::v42(){vfunc_called(this, "_ZN10S6957C2_nt3v42Ev");}
void  S6957C2_nt ::v43(){vfunc_called(this, "_ZN10S6957C2_nt3v43Ev");}
void  S6957C2_nt ::v44(){vfunc_called(this, "_ZN10S6957C2_nt3v44Ev");}
void  S6957C2_nt ::v45(){vfunc_called(this, "_ZN10S6957C2_nt3v45Ev");}
void  S6957C2_nt ::v46(){vfunc_called(this, "_ZN10S6957C2_nt3v46Ev");}
void  S6957C2_nt ::v47(){vfunc_called(this, "_ZN10S6957C2_nt3v47Ev");}
void  S6957C2_nt ::v48(){vfunc_called(this, "_ZN10S6957C2_nt3v48Ev");}
void  S6957C2_nt ::v49(){vfunc_called(this, "_ZN10S6957C2_nt3v49Ev");}
void  S6957C2_nt ::v50(){vfunc_called(this, "_ZN10S6957C2_nt3v50Ev");}
void  S6957C2_nt ::v51(){vfunc_called(this, "_ZN10S6957C2_nt3v51Ev");}
void  S6957C2_nt ::v52(){vfunc_called(this, "_ZN10S6957C2_nt3v52Ev");}
void  S6957C2_nt ::v53(){vfunc_called(this, "_ZN10S6957C2_nt3v53Ev");}
void  S6957C2_nt ::v54(){vfunc_called(this, "_ZN10S6957C2_nt3v54Ev");}
void  S6957C2_nt ::v55(){vfunc_called(this, "_ZN10S6957C2_nt3v55Ev");}
void  S6957C2_nt ::v56(){vfunc_called(this, "_ZN10S6957C2_nt3v56Ev");}
void  S6957C2_nt ::v57(){vfunc_called(this, "_ZN10S6957C2_nt3v57Ev");}
void  S6957C2_nt ::v58(){vfunc_called(this, "_ZN10S6957C2_nt3v58Ev");}
void  S6957C2_nt ::v59(){vfunc_called(this, "_ZN10S6957C2_nt3v59Ev");}
void  S6957C2_nt ::v60(){vfunc_called(this, "_ZN10S6957C2_nt3v60Ev");}
void  S6957C2_nt ::v61(){vfunc_called(this, "_ZN10S6957C2_nt3v61Ev");}
void  S6957C2_nt ::v62(){vfunc_called(this, "_ZN10S6957C2_nt3v62Ev");}
void  S6957C2_nt ::v63(){vfunc_called(this, "_ZN10S6957C2_nt3v63Ev");}
void  S6957C2_nt ::v64(){vfunc_called(this, "_ZN10S6957C2_nt3v64Ev");}
void  S6957C2_nt ::v65(){vfunc_called(this, "_ZN10S6957C2_nt3v65Ev");}
void  S6957C2_nt ::v66(){vfunc_called(this, "_ZN10S6957C2_nt3v66Ev");}
void  S6957C2_nt ::v67(){vfunc_called(this, "_ZN10S6957C2_nt3v67Ev");}
void  S6957C2_nt ::v68(){vfunc_called(this, "_ZN10S6957C2_nt3v68Ev");}
S6957C2_nt ::S6957C2_nt(){ note_ctor("S6957C2_nt", this);} // tgen

//skip512 S6957C2_nt

#else // __cplusplus

extern void _ZN10S6957C2_ntC1Ev();
extern void _ZN10S6957C2_ntD1Ev();
Name_Map name_map_S6957C2_nt[] = {
  NSPAIR(_ZN10S6957C2_ntC1Ev),
  NSPAIR(_ZN10S6957C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S6957C2_nt[];
extern void _ZN10S6957C2_ntD1Ev();
extern void _ZN10S6957C2_ntD0Ev();
extern void _ZN10S6957C2_nt2v5Ev();
extern void _ZN10S6957C2_nt2v6Ev();
extern void _ZN10S6957C2_nt2v7Ev();
extern void _ZN10S6957C2_nt2v8Ev();
extern void _ZN10S6957C2_nt2v9Ev();
extern void _ZN10S6957C2_nt3v10Ev();
extern void _ZN10S6957C2_nt3v11Ev();
extern void _ZN10S6957C2_nt3v12Ev();
extern void _ZN10S6957C2_nt3v13Ev();
extern void _ZN10S6957C2_nt3v14Ev();
extern void _ZN10S6957C2_nt3v15Ev();
extern void _ZN10S6957C2_nt3v16Ev();
extern void _ZN10S6957C2_nt3v17Ev();
extern void _ZN10S6957C2_nt3v18Ev();
extern void _ZN10S6957C2_nt3v19Ev();
extern void _ZN10S6957C2_nt3v20Ev();
extern void _ZN10S6957C2_nt3v21Ev();
extern void _ZN10S6957C2_nt3v22Ev();
extern void _ZN10S6957C2_nt3v23Ev();
extern void _ZN10S6957C2_nt3v24Ev();
extern void _ZN10S6957C2_nt3v25Ev();
extern void _ZN10S6957C2_nt3v26Ev();
extern void _ZN10S6957C2_nt3v27Ev();
extern void _ZN10S6957C2_nt3v28Ev();
extern void _ZN10S6957C2_nt3v29Ev();
extern void _ZN10S6957C2_nt3v30Ev();
extern void _ZN10S6957C2_nt3v31Ev();
extern void _ZN10S6957C2_nt3v32Ev();
extern void _ZN10S6957C2_nt3v33Ev();
extern void _ZN10S6957C2_nt3v34Ev();
extern void _ZN10S6957C2_nt3v35Ev();
extern void _ZN10S6957C2_nt3v36Ev();
extern void _ZN10S6957C2_nt3v37Ev();
extern void _ZN10S6957C2_nt3v38Ev();
extern void _ZN10S6957C2_nt3v39Ev();
extern void _ZN10S6957C2_nt3v40Ev();
extern void _ZN10S6957C2_nt3v41Ev();
extern void _ZN10S6957C2_nt3v42Ev();
extern void _ZN10S6957C2_nt3v43Ev();
extern void _ZN10S6957C2_nt3v44Ev();
extern void _ZN10S6957C2_nt3v45Ev();
extern void _ZN10S6957C2_nt3v46Ev();
extern void _ZN10S6957C2_nt3v47Ev();
extern void _ZN10S6957C2_nt3v48Ev();
extern void _ZN10S6957C2_nt3v49Ev();
extern void _ZN10S6957C2_nt3v50Ev();
extern void _ZN10S6957C2_nt3v51Ev();
extern void _ZN10S6957C2_nt3v52Ev();
extern void _ZN10S6957C2_nt3v53Ev();
extern void _ZN10S6957C2_nt3v54Ev();
extern void _ZN10S6957C2_nt3v55Ev();
extern void _ZN10S6957C2_nt3v56Ev();
extern void _ZN10S6957C2_nt3v57Ev();
extern void _ZN10S6957C2_nt3v58Ev();
extern void _ZN10S6957C2_nt3v59Ev();
extern void _ZN10S6957C2_nt3v60Ev();
extern void _ZN10S6957C2_nt3v61Ev();
extern void _ZN10S6957C2_nt3v62Ev();
extern void _ZN10S6957C2_nt3v63Ev();
extern void _ZN10S6957C2_nt3v64Ev();
extern void _ZN10S6957C2_nt3v65Ev();
extern void _ZN10S6957C2_nt3v66Ev();
extern void _ZN10S6957C2_nt3v67Ev();
extern void _ZN10S6957C2_nt3v68Ev();
static  VTBL_ENTRY vtc_S6957C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S6957C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S6957C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI10S6957C2_nt[];
VTBL_ENTRY *P__ZTI10S6957C2_nt = _ZTI10S6957C2_nt; 
extern  VTBL_ENTRY _ZTV10S6957C2_nt[];
Class_Descriptor cd_S6957C2_nt = {  "S6957C2_nt", // class name
  0,0,//no base classes
  &(vtc_S6957C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S6957C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S6957C2_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6957C1  : S6957C2_nt {
  unsigned int s6957c1f0:1;
  unsigned int s6957c1f1:1;
  unsigned int s6957c1f2:1;
  virtual  ~S6957C1(); // _ZN7S6957C1D1Ev
  virtual void  v1(); // _ZN7S6957C12v1Ev
  virtual void  v2(); // _ZN7S6957C12v2Ev
  virtual void  v3(); // _ZN7S6957C12v3Ev
  virtual void  v4(); // _ZN7S6957C12v4Ev
  S6957C1(); // tgen
};
//SIG(1 S6957C1) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 Fi:1 Fi:1 Fi:1}


 S6957C1 ::~S6957C1(){ note_dtor("S6957C1", this);}
void  S6957C1 ::v1(){vfunc_called(this, "_ZN7S6957C12v1Ev");}
void  S6957C1 ::v2(){vfunc_called(this, "_ZN7S6957C12v2Ev");}
void  S6957C1 ::v3(){vfunc_called(this, "_ZN7S6957C12v3Ev");}
void  S6957C1 ::v4(){vfunc_called(this, "_ZN7S6957C12v4Ev");}
S6957C1 ::S6957C1(){ note_ctor("S6957C1", this);} // tgen

static void Test_S6957C1()
{
  extern Class_Descriptor cd_S6957C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S6957C1, buf);
    S6957C1 *dp, &lv = *(dp=new (buf) S6957C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S6957C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6957C1)");
    check_base_class_offset(lv, (S6957C2_nt*), 0, "S6957C1");
    set_bf_and_test(lv, s6957c1f0, ABISELECT(96,60), 0, 1, 1, "S6957C1");
    set_bf_and_test(lv, s6957c1f1, ABISELECT(96,60), 1, 1, 1, "S6957C1");
    set_bf_and_test(lv, s6957c1f2, ABISELECT(96,60), 2, 1, 1, "S6957C1");
    test_class_info(&lv, &cd_S6957C1);
    dp->~S6957C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6957C1(Test_S6957C1, "S6957C1", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S6957C1C1Ev();
extern void _ZN7S6957C1D1Ev();
Name_Map name_map_S6957C1[] = {
  NSPAIR(_ZN7S6957C1C1Ev),
  NSPAIR(_ZN7S6957C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6957C2_nt;
extern VTBL_ENTRY _ZTI10S6957C2_nt[];
extern  VTBL_ENTRY _ZTV10S6957C2_nt[];
static Base_Class bases_S6957C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6957C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S6957C1[];
extern void _ZN7S6957C1D1Ev();
extern void _ZN7S6957C1D0Ev();
extern void _ZN10S6957C2_nt2v5Ev();
extern void _ZN10S6957C2_nt2v6Ev();
extern void _ZN10S6957C2_nt2v7Ev();
extern void _ZN10S6957C2_nt2v8Ev();
extern void _ZN10S6957C2_nt2v9Ev();
extern void _ZN10S6957C2_nt3v10Ev();
extern void _ZN10S6957C2_nt3v11Ev();
extern void _ZN10S6957C2_nt3v12Ev();
extern void _ZN10S6957C2_nt3v13Ev();
extern void _ZN10S6957C2_nt3v14Ev();
extern void _ZN10S6957C2_nt3v15Ev();
extern void _ZN10S6957C2_nt3v16Ev();
extern void _ZN10S6957C2_nt3v17Ev();
extern void _ZN10S6957C2_nt3v18Ev();
extern void _ZN10S6957C2_nt3v19Ev();
extern void _ZN10S6957C2_nt3v20Ev();
extern void _ZN10S6957C2_nt3v21Ev();
extern void _ZN10S6957C2_nt3v22Ev();
extern void _ZN10S6957C2_nt3v23Ev();
extern void _ZN10S6957C2_nt3v24Ev();
extern void _ZN10S6957C2_nt3v25Ev();
extern void _ZN10S6957C2_nt3v26Ev();
extern void _ZN10S6957C2_nt3v27Ev();
extern void _ZN10S6957C2_nt3v28Ev();
extern void _ZN10S6957C2_nt3v29Ev();
extern void _ZN10S6957C2_nt3v30Ev();
extern void _ZN10S6957C2_nt3v31Ev();
extern void _ZN10S6957C2_nt3v32Ev();
extern void _ZN10S6957C2_nt3v33Ev();
extern void _ZN10S6957C2_nt3v34Ev();
extern void _ZN10S6957C2_nt3v35Ev();
extern void _ZN10S6957C2_nt3v36Ev();
extern void _ZN10S6957C2_nt3v37Ev();
extern void _ZN10S6957C2_nt3v38Ev();
extern void _ZN10S6957C2_nt3v39Ev();
extern void _ZN10S6957C2_nt3v40Ev();
extern void _ZN10S6957C2_nt3v41Ev();
extern void _ZN10S6957C2_nt3v42Ev();
extern void _ZN10S6957C2_nt3v43Ev();
extern void _ZN10S6957C2_nt3v44Ev();
extern void _ZN10S6957C2_nt3v45Ev();
extern void _ZN10S6957C2_nt3v46Ev();
extern void _ZN10S6957C2_nt3v47Ev();
extern void _ZN10S6957C2_nt3v48Ev();
extern void _ZN10S6957C2_nt3v49Ev();
extern void _ZN10S6957C2_nt3v50Ev();
extern void _ZN10S6957C2_nt3v51Ev();
extern void _ZN10S6957C2_nt3v52Ev();
extern void _ZN10S6957C2_nt3v53Ev();
extern void _ZN10S6957C2_nt3v54Ev();
extern void _ZN10S6957C2_nt3v55Ev();
extern void _ZN10S6957C2_nt3v56Ev();
extern void _ZN10S6957C2_nt3v57Ev();
extern void _ZN10S6957C2_nt3v58Ev();
extern void _ZN10S6957C2_nt3v59Ev();
extern void _ZN10S6957C2_nt3v60Ev();
extern void _ZN10S6957C2_nt3v61Ev();
extern void _ZN10S6957C2_nt3v62Ev();
extern void _ZN10S6957C2_nt3v63Ev();
extern void _ZN10S6957C2_nt3v64Ev();
extern void _ZN10S6957C2_nt3v65Ev();
extern void _ZN10S6957C2_nt3v66Ev();
extern void _ZN10S6957C2_nt3v67Ev();
extern void _ZN10S6957C2_nt3v68Ev();
extern void _ZN7S6957C12v1Ev();
extern void _ZN7S6957C12v2Ev();
extern void _ZN7S6957C12v3Ev();
extern void _ZN7S6957C12v4Ev();
static  VTBL_ENTRY vtc_S6957C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6957C1[0]),
  (VTBL_ENTRY)&_ZN7S6957C1D1Ev,
  (VTBL_ENTRY)&_ZN7S6957C1D0Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S6957C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN7S6957C12v1Ev,
  (VTBL_ENTRY)&_ZN7S6957C12v2Ev,
  (VTBL_ENTRY)&_ZN7S6957C12v3Ev,
  (VTBL_ENTRY)&_ZN7S6957C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S6957C1[];
extern  VTBL_ENTRY _ZTV7S6957C1[];
Class_Descriptor cd_S6957C1 = {  "S6957C1", // class name
  bases_S6957C1, 1,
  &(vtc_S6957C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S6957C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S6957C1),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4279C3_nt  {
  virtual  ~S4279C3_nt(); // _ZN10S4279C3_ntD1Ev
  virtual void  v15(); // _ZN10S4279C3_nt3v15Ev
  virtual void  v16(); // _ZN10S4279C3_nt3v16Ev
  virtual void  v17(); // _ZN10S4279C3_nt3v17Ev
  virtual void  v18(); // _ZN10S4279C3_nt3v18Ev
  virtual void  v19(); // _ZN10S4279C3_nt3v19Ev
  virtual void  v20(); // _ZN10S4279C3_nt3v20Ev
  virtual void  v21(); // _ZN10S4279C3_nt3v21Ev
  virtual void  v22(); // _ZN10S4279C3_nt3v22Ev
  virtual void  v23(); // _ZN10S4279C3_nt3v23Ev
  virtual void  v24(); // _ZN10S4279C3_nt3v24Ev
  virtual void  v25(); // _ZN10S4279C3_nt3v25Ev
  virtual void  v26(); // _ZN10S4279C3_nt3v26Ev
  virtual void  v27(); // _ZN10S4279C3_nt3v27Ev
  virtual void  v28(); // _ZN10S4279C3_nt3v28Ev
  virtual void  v29(); // _ZN10S4279C3_nt3v29Ev
  virtual void  v30(); // _ZN10S4279C3_nt3v30Ev
  virtual void  v31(); // _ZN10S4279C3_nt3v31Ev
  virtual void  v32(); // _ZN10S4279C3_nt3v32Ev
  virtual void  v33(); // _ZN10S4279C3_nt3v33Ev
  virtual void  v34(); // _ZN10S4279C3_nt3v34Ev
  virtual void  v35(); // _ZN10S4279C3_nt3v35Ev
  virtual void  v36(); // _ZN10S4279C3_nt3v36Ev
  virtual void  v37(); // _ZN10S4279C3_nt3v37Ev
  virtual void  v38(); // _ZN10S4279C3_nt3v38Ev
  virtual void  v39(); // _ZN10S4279C3_nt3v39Ev
  virtual void  v40(); // _ZN10S4279C3_nt3v40Ev
  S4279C3_nt(); // tgen
};
//SIG(-1 S4279C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S4279C3_nt ::~S4279C3_nt(){ note_dtor("S4279C3_nt", this);}
void  S4279C3_nt ::v15(){vfunc_called(this, "_ZN10S4279C3_nt3v15Ev");}
void  S4279C3_nt ::v16(){vfunc_called(this, "_ZN10S4279C3_nt3v16Ev");}
void  S4279C3_nt ::v17(){vfunc_called(this, "_ZN10S4279C3_nt3v17Ev");}
void  S4279C3_nt ::v18(){vfunc_called(this, "_ZN10S4279C3_nt3v18Ev");}
void  S4279C3_nt ::v19(){vfunc_called(this, "_ZN10S4279C3_nt3v19Ev");}
void  S4279C3_nt ::v20(){vfunc_called(this, "_ZN10S4279C3_nt3v20Ev");}
void  S4279C3_nt ::v21(){vfunc_called(this, "_ZN10S4279C3_nt3v21Ev");}
void  S4279C3_nt ::v22(){vfunc_called(this, "_ZN10S4279C3_nt3v22Ev");}
void  S4279C3_nt ::v23(){vfunc_called(this, "_ZN10S4279C3_nt3v23Ev");}
void  S4279C3_nt ::v24(){vfunc_called(this, "_ZN10S4279C3_nt3v24Ev");}
void  S4279C3_nt ::v25(){vfunc_called(this, "_ZN10S4279C3_nt3v25Ev");}
void  S4279C3_nt ::v26(){vfunc_called(this, "_ZN10S4279C3_nt3v26Ev");}
void  S4279C3_nt ::v27(){vfunc_called(this, "_ZN10S4279C3_nt3v27Ev");}
void  S4279C3_nt ::v28(){vfunc_called(this, "_ZN10S4279C3_nt3v28Ev");}
void  S4279C3_nt ::v29(){vfunc_called(this, "_ZN10S4279C3_nt3v29Ev");}
void  S4279C3_nt ::v30(){vfunc_called(this, "_ZN10S4279C3_nt3v30Ev");}
void  S4279C3_nt ::v31(){vfunc_called(this, "_ZN10S4279C3_nt3v31Ev");}
void  S4279C3_nt ::v32(){vfunc_called(this, "_ZN10S4279C3_nt3v32Ev");}
void  S4279C3_nt ::v33(){vfunc_called(this, "_ZN10S4279C3_nt3v33Ev");}
void  S4279C3_nt ::v34(){vfunc_called(this, "_ZN10S4279C3_nt3v34Ev");}
void  S4279C3_nt ::v35(){vfunc_called(this, "_ZN10S4279C3_nt3v35Ev");}
void  S4279C3_nt ::v36(){vfunc_called(this, "_ZN10S4279C3_nt3v36Ev");}
void  S4279C3_nt ::v37(){vfunc_called(this, "_ZN10S4279C3_nt3v37Ev");}
void  S4279C3_nt ::v38(){vfunc_called(this, "_ZN10S4279C3_nt3v38Ev");}
void  S4279C3_nt ::v39(){vfunc_called(this, "_ZN10S4279C3_nt3v39Ev");}
void  S4279C3_nt ::v40(){vfunc_called(this, "_ZN10S4279C3_nt3v40Ev");}
S4279C3_nt ::S4279C3_nt(){ note_ctor("S4279C3_nt", this);} // tgen

//skip512 S4279C3_nt

#else // __cplusplus

extern void _ZN10S4279C3_ntC1Ev();
extern void _ZN10S4279C3_ntD1Ev();
Name_Map name_map_S4279C3_nt[] = {
  NSPAIR(_ZN10S4279C3_ntC1Ev),
  NSPAIR(_ZN10S4279C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S4279C3_nt[];
extern void _ZN10S4279C3_ntD1Ev();
extern void _ZN10S4279C3_ntD0Ev();
extern void _ZN10S4279C3_nt3v15Ev();
extern void _ZN10S4279C3_nt3v16Ev();
extern void _ZN10S4279C3_nt3v17Ev();
extern void _ZN10S4279C3_nt3v18Ev();
extern void _ZN10S4279C3_nt3v19Ev();
extern void _ZN10S4279C3_nt3v20Ev();
extern void _ZN10S4279C3_nt3v21Ev();
extern void _ZN10S4279C3_nt3v22Ev();
extern void _ZN10S4279C3_nt3v23Ev();
extern void _ZN10S4279C3_nt3v24Ev();
extern void _ZN10S4279C3_nt3v25Ev();
extern void _ZN10S4279C3_nt3v26Ev();
extern void _ZN10S4279C3_nt3v27Ev();
extern void _ZN10S4279C3_nt3v28Ev();
extern void _ZN10S4279C3_nt3v29Ev();
extern void _ZN10S4279C3_nt3v30Ev();
extern void _ZN10S4279C3_nt3v31Ev();
extern void _ZN10S4279C3_nt3v32Ev();
extern void _ZN10S4279C3_nt3v33Ev();
extern void _ZN10S4279C3_nt3v34Ev();
extern void _ZN10S4279C3_nt3v35Ev();
extern void _ZN10S4279C3_nt3v36Ev();
extern void _ZN10S4279C3_nt3v37Ev();
extern void _ZN10S4279C3_nt3v38Ev();
extern void _ZN10S4279C3_nt3v39Ev();
extern void _ZN10S4279C3_nt3v40Ev();
static  VTBL_ENTRY vtc_S4279C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4279C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S4279C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v40Ev,
};
extern VTBL_ENTRY _ZTI10S4279C3_nt[];
VTBL_ENTRY *P__ZTI10S4279C3_nt = _ZTI10S4279C3_nt; 
extern  VTBL_ENTRY _ZTV10S4279C3_nt[];
Class_Descriptor cd_S4279C3_nt = {  "S4279C3_nt", // class name
  0,0,//no base classes
  &(vtc_S4279C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S4279C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S4279C3_nt),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4279C4_nt  {
  int s4279c4f0[2];
};
//SIG(-1 S4279C4_nt) C1{ Fi[2]}



//skip512 S4279C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4279C2_nt  : S4279C3_nt {
  void *s4279c2f0[2];
  int s4279c2f1[4];
  ::S4279C4_nt s4279c2f2;
  void *s4279c2f3;
  char s4279c2f4;
  void *s4279c2f5;
  virtual  ~S4279C2_nt(); // _ZN10S4279C2_ntD1Ev
  virtual void  v41(); // _ZN10S4279C2_nt3v41Ev
  virtual void  v42(); // _ZN10S4279C2_nt3v42Ev
  virtual void  v43(); // _ZN10S4279C2_nt3v43Ev
  virtual void  v44(); // _ZN10S4279C2_nt3v44Ev
  virtual void  v45(); // _ZN10S4279C2_nt3v45Ev
  virtual void  v46(); // _ZN10S4279C2_nt3v46Ev
  virtual void  v47(); // _ZN10S4279C2_nt3v47Ev
  virtual void  v48(); // _ZN10S4279C2_nt3v48Ev
  virtual void  v49(); // _ZN10S4279C2_nt3v49Ev
  virtual void  v50(); // _ZN10S4279C2_nt3v50Ev
  virtual void  v51(); // _ZN10S4279C2_nt3v51Ev
  virtual void  v52(); // _ZN10S4279C2_nt3v52Ev
  virtual void  v53(); // _ZN10S4279C2_nt3v53Ev
  virtual void  v54(); // _ZN10S4279C2_nt3v54Ev
  S4279C2_nt(); // tgen
};
//SIG(-1 S4279C2_nt) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] FC3{ Fi[2]} Fp Fc Fp}


 S4279C2_nt ::~S4279C2_nt(){ note_dtor("S4279C2_nt", this);}
void  S4279C2_nt ::v41(){vfunc_called(this, "_ZN10S4279C2_nt3v41Ev");}
void  S4279C2_nt ::v42(){vfunc_called(this, "_ZN10S4279C2_nt3v42Ev");}
void  S4279C2_nt ::v43(){vfunc_called(this, "_ZN10S4279C2_nt3v43Ev");}
void  S4279C2_nt ::v44(){vfunc_called(this, "_ZN10S4279C2_nt3v44Ev");}
void  S4279C2_nt ::v45(){vfunc_called(this, "_ZN10S4279C2_nt3v45Ev");}
void  S4279C2_nt ::v46(){vfunc_called(this, "_ZN10S4279C2_nt3v46Ev");}
void  S4279C2_nt ::v47(){vfunc_called(this, "_ZN10S4279C2_nt3v47Ev");}
void  S4279C2_nt ::v48(){vfunc_called(this, "_ZN10S4279C2_nt3v48Ev");}
void  S4279C2_nt ::v49(){vfunc_called(this, "_ZN10S4279C2_nt3v49Ev");}
void  S4279C2_nt ::v50(){vfunc_called(this, "_ZN10S4279C2_nt3v50Ev");}
void  S4279C2_nt ::v51(){vfunc_called(this, "_ZN10S4279C2_nt3v51Ev");}
void  S4279C2_nt ::v52(){vfunc_called(this, "_ZN10S4279C2_nt3v52Ev");}
void  S4279C2_nt ::v53(){vfunc_called(this, "_ZN10S4279C2_nt3v53Ev");}
void  S4279C2_nt ::v54(){vfunc_called(this, "_ZN10S4279C2_nt3v54Ev");}
S4279C2_nt ::S4279C2_nt(){ note_ctor("S4279C2_nt", this);} // tgen

//skip512 S4279C2_nt

#else // __cplusplus

extern void _ZN10S4279C2_ntC1Ev();
extern void _ZN10S4279C2_ntD1Ev();
Name_Map name_map_S4279C2_nt[] = {
  NSPAIR(_ZN10S4279C2_ntC1Ev),
  NSPAIR(_ZN10S4279C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4279C3_nt;
extern VTBL_ENTRY _ZTI10S4279C3_nt[];
extern  VTBL_ENTRY _ZTV10S4279C3_nt[];
static Base_Class bases_S4279C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4279C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S4279C2_nt[];
extern void _ZN10S4279C2_ntD1Ev();
extern void _ZN10S4279C2_ntD0Ev();
extern void _ZN10S4279C3_nt3v15Ev();
extern void _ZN10S4279C3_nt3v16Ev();
extern void _ZN10S4279C3_nt3v17Ev();
extern void _ZN10S4279C3_nt3v18Ev();
extern void _ZN10S4279C3_nt3v19Ev();
extern void _ZN10S4279C3_nt3v20Ev();
extern void _ZN10S4279C3_nt3v21Ev();
extern void _ZN10S4279C3_nt3v22Ev();
extern void _ZN10S4279C3_nt3v23Ev();
extern void _ZN10S4279C3_nt3v24Ev();
extern void _ZN10S4279C3_nt3v25Ev();
extern void _ZN10S4279C3_nt3v26Ev();
extern void _ZN10S4279C3_nt3v27Ev();
extern void _ZN10S4279C3_nt3v28Ev();
extern void _ZN10S4279C3_nt3v29Ev();
extern void _ZN10S4279C3_nt3v30Ev();
extern void _ZN10S4279C3_nt3v31Ev();
extern void _ZN10S4279C3_nt3v32Ev();
extern void _ZN10S4279C3_nt3v33Ev();
extern void _ZN10S4279C3_nt3v34Ev();
extern void _ZN10S4279C3_nt3v35Ev();
extern void _ZN10S4279C3_nt3v36Ev();
extern void _ZN10S4279C3_nt3v37Ev();
extern void _ZN10S4279C3_nt3v38Ev();
extern void _ZN10S4279C3_nt3v39Ev();
extern void _ZN10S4279C3_nt3v40Ev();
extern void _ZN10S4279C2_nt3v41Ev();
extern void _ZN10S4279C2_nt3v42Ev();
extern void _ZN10S4279C2_nt3v43Ev();
extern void _ZN10S4279C2_nt3v44Ev();
extern void _ZN10S4279C2_nt3v45Ev();
extern void _ZN10S4279C2_nt3v46Ev();
extern void _ZN10S4279C2_nt3v47Ev();
extern void _ZN10S4279C2_nt3v48Ev();
extern void _ZN10S4279C2_nt3v49Ev();
extern void _ZN10S4279C2_nt3v50Ev();
extern void _ZN10S4279C2_nt3v51Ev();
extern void _ZN10S4279C2_nt3v52Ev();
extern void _ZN10S4279C2_nt3v53Ev();
extern void _ZN10S4279C2_nt3v54Ev();
static  VTBL_ENTRY vtc_S4279C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4279C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S4279C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v54Ev,
};
extern VTBL_ENTRY _ZTI10S4279C2_nt[];
VTBL_ENTRY *P__ZTI10S4279C2_nt = _ZTI10S4279C2_nt; 
extern  VTBL_ENTRY _ZTV10S4279C2_nt[];
Class_Descriptor cd_S4279C2_nt = {  "S4279C2_nt", // class name
  bases_S4279C2_nt, 1,
  &(vtc_S4279C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,48), // object size
  NSPAIRA(_ZTI10S4279C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S4279C2_nt),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4279C5_nt  {
  void *s4279c5f0;
  char s4279c5f1[32];
  int s4279c5f2[6];
  char s4279c5f3;
  int s4279c5f4[2];
  virtual  ~S4279C5_nt(); // _ZN10S4279C5_ntD1Ev
  virtual void  v55(); // _ZN10S4279C5_nt3v55Ev
  virtual void  v56(); // _ZN10S4279C5_nt3v56Ev
  S4279C5_nt(); // tgen
};
//SIG(-1 S4279C5_nt) C1{ vd v1 v2 Fp Fc[32] Fi[6] Fc Fi[2]}


 S4279C5_nt ::~S4279C5_nt(){ note_dtor("S4279C5_nt", this);}
void  S4279C5_nt ::v55(){vfunc_called(this, "_ZN10S4279C5_nt3v55Ev");}
void  S4279C5_nt ::v56(){vfunc_called(this, "_ZN10S4279C5_nt3v56Ev");}
S4279C5_nt ::S4279C5_nt(){ note_ctor("S4279C5_nt", this);} // tgen

//skip512 S4279C5_nt

#else // __cplusplus

extern void _ZN10S4279C5_ntC1Ev();
extern void _ZN10S4279C5_ntD1Ev();
Name_Map name_map_S4279C5_nt[] = {
  NSPAIR(_ZN10S4279C5_ntC1Ev),
  NSPAIR(_ZN10S4279C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S4279C5_nt[];
extern void _ZN10S4279C5_ntD1Ev();
extern void _ZN10S4279C5_ntD0Ev();
extern void _ZN10S4279C5_nt3v55Ev();
extern void _ZN10S4279C5_nt3v56Ev();
static  VTBL_ENTRY vtc_S4279C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4279C5_nt[0]),
  (VTBL_ENTRY)&_ZN10S4279C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4279C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4279C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S4279C5_nt3v56Ev,
};
extern VTBL_ENTRY _ZTI10S4279C5_nt[];
VTBL_ENTRY *P__ZTI10S4279C5_nt = _ZTI10S4279C5_nt; 
extern  VTBL_ENTRY _ZTV10S4279C5_nt[];
Class_Descriptor cd_S4279C5_nt = {  "S4279C5_nt", // class name
  0,0,//no base classes
  &(vtc_S4279C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,76), // object size
  NSPAIRA(_ZTI10S4279C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S4279C5_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4279C1  : S4279C2_nt , S4279C5_nt {
  void *s4279c1f0[2];
  int s4279c1f1[4];
  __tsi64 s4279c1f2;
  void *s4279c1f3[2];
  virtual  ~S4279C1(); // _ZN7S4279C1D1Ev
  virtual void  v1(); // _ZN7S4279C12v1Ev
  virtual void  v2(); // _ZN7S4279C12v2Ev
  virtual void  v3(); // _ZN7S4279C12v3Ev
  virtual void  v4(); // _ZN7S4279C12v4Ev
  virtual void  v5(); // _ZN7S4279C12v5Ev
  virtual void  v6(); // _ZN7S4279C12v6Ev
  virtual void  v7(); // _ZN7S4279C12v7Ev
  virtual void  v8(); // _ZN7S4279C12v8Ev
  virtual void  v9(); // _ZN7S4279C12v9Ev
  virtual void  v10(); // _ZN7S4279C13v10Ev
  virtual void  v11(); // _ZN7S4279C13v11Ev
  virtual void  v12(); // _ZN7S4279C13v12Ev
  virtual void  v13(); // _ZN7S4279C13v13Ev
  virtual void  v14(); // _ZN7S4279C13v14Ev
  S4279C1(); // tgen
};
//SIG(1 S4279C1) C1{ BC2{ BC3{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40} vd v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fp[2] Fi[4] FC4{ Fi[2]} Fp Fc Fp} BC5{ vd v55 v56 Fp Fc[32] Fi[6] Fc Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] FL Fp[2]}


 S4279C1 ::~S4279C1(){ note_dtor("S4279C1", this);}
void  S4279C1 ::v1(){vfunc_called(this, "_ZN7S4279C12v1Ev");}
void  S4279C1 ::v2(){vfunc_called(this, "_ZN7S4279C12v2Ev");}
void  S4279C1 ::v3(){vfunc_called(this, "_ZN7S4279C12v3Ev");}
void  S4279C1 ::v4(){vfunc_called(this, "_ZN7S4279C12v4Ev");}
void  S4279C1 ::v5(){vfunc_called(this, "_ZN7S4279C12v5Ev");}
void  S4279C1 ::v6(){vfunc_called(this, "_ZN7S4279C12v6Ev");}
void  S4279C1 ::v7(){vfunc_called(this, "_ZN7S4279C12v7Ev");}
void  S4279C1 ::v8(){vfunc_called(this, "_ZN7S4279C12v8Ev");}
void  S4279C1 ::v9(){vfunc_called(this, "_ZN7S4279C12v9Ev");}
void  S4279C1 ::v10(){vfunc_called(this, "_ZN7S4279C13v10Ev");}
void  S4279C1 ::v11(){vfunc_called(this, "_ZN7S4279C13v11Ev");}
void  S4279C1 ::v12(){vfunc_called(this, "_ZN7S4279C13v12Ev");}
void  S4279C1 ::v13(){vfunc_called(this, "_ZN7S4279C13v13Ev");}
void  S4279C1 ::v14(){vfunc_called(this, "_ZN7S4279C13v14Ev");}
S4279C1 ::S4279C1(){ note_ctor("S4279C1", this);} // tgen

static void Test_S4279C1()
{
  extern Class_Descriptor cd_S4279C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,42)];
    init_test(&cd_S4279C1, buf);
    S4279C1 *dp, &lv = *(dp=new (buf) S4279C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,164), "sizeof(S4279C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4279C1)");
    check_base_class_offset(lv, (S4279C3_nt*)(S4279C2_nt*), 0, "S4279C1");
    check_base_class_offset(lv, (S4279C2_nt*), 0, "S4279C1");
    check_base_class_offset(lv, (S4279C5_nt*), ABISELECT(72,48), "S4279C1");
    check_field_offset(lv, s4279c1f0, ABISELECT(160,124), "S4279C1.s4279c1f0");
    check_field_offset(lv, s4279c1f1, ABISELECT(176,132), "S4279C1.s4279c1f1");
    check_field_offset(lv, s4279c1f2, ABISELECT(192,148), "S4279C1.s4279c1f2");
    check_field_offset(lv, s4279c1f3, ABISELECT(200,156), "S4279C1.s4279c1f3");
    test_class_info(&lv, &cd_S4279C1);
    dp->~S4279C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4279C1(Test_S4279C1, "S4279C1", ABISELECT(216,164));

#else // __cplusplus

extern void _ZN7S4279C1C1Ev();
extern void _ZN7S4279C1D1Ev();
Name_Map name_map_S4279C1[] = {
  NSPAIR(_ZN7S4279C1C1Ev),
  NSPAIR(_ZN7S4279C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4279C3_nt;
extern VTBL_ENTRY _ZTI10S4279C3_nt[];
extern  VTBL_ENTRY _ZTV10S4279C3_nt[];
extern Class_Descriptor cd_S4279C2_nt;
extern VTBL_ENTRY _ZTI10S4279C2_nt[];
extern  VTBL_ENTRY _ZTV10S4279C2_nt[];
extern Class_Descriptor cd_S4279C5_nt;
extern VTBL_ENTRY _ZTI10S4279C5_nt[];
extern  VTBL_ENTRY _ZTV10S4279C5_nt[];
static Base_Class bases_S4279C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4279C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4279C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4279C5_nt,    ABISELECT(72,48), //bcp->offset
    58, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4279C1[];
extern void _ZN7S4279C1D1Ev();
extern void _ZN7S4279C1D0Ev();
extern void _ZN10S4279C3_nt3v15Ev();
extern void _ZN10S4279C3_nt3v16Ev();
extern void _ZN10S4279C3_nt3v17Ev();
extern void _ZN10S4279C3_nt3v18Ev();
extern void _ZN10S4279C3_nt3v19Ev();
extern void _ZN10S4279C3_nt3v20Ev();
extern void _ZN10S4279C3_nt3v21Ev();
extern void _ZN10S4279C3_nt3v22Ev();
extern void _ZN10S4279C3_nt3v23Ev();
extern void _ZN10S4279C3_nt3v24Ev();
extern void _ZN10S4279C3_nt3v25Ev();
extern void _ZN10S4279C3_nt3v26Ev();
extern void _ZN10S4279C3_nt3v27Ev();
extern void _ZN10S4279C3_nt3v28Ev();
extern void _ZN10S4279C3_nt3v29Ev();
extern void _ZN10S4279C3_nt3v30Ev();
extern void _ZN10S4279C3_nt3v31Ev();
extern void _ZN10S4279C3_nt3v32Ev();
extern void _ZN10S4279C3_nt3v33Ev();
extern void _ZN10S4279C3_nt3v34Ev();
extern void _ZN10S4279C3_nt3v35Ev();
extern void _ZN10S4279C3_nt3v36Ev();
extern void _ZN10S4279C3_nt3v37Ev();
extern void _ZN10S4279C3_nt3v38Ev();
extern void _ZN10S4279C3_nt3v39Ev();
extern void _ZN10S4279C3_nt3v40Ev();
extern void _ZN10S4279C2_nt3v41Ev();
extern void _ZN10S4279C2_nt3v42Ev();
extern void _ZN10S4279C2_nt3v43Ev();
extern void _ZN10S4279C2_nt3v44Ev();
extern void _ZN10S4279C2_nt3v45Ev();
extern void _ZN10S4279C2_nt3v46Ev();
extern void _ZN10S4279C2_nt3v47Ev();
extern void _ZN10S4279C2_nt3v48Ev();
extern void _ZN10S4279C2_nt3v49Ev();
extern void _ZN10S4279C2_nt3v50Ev();
extern void _ZN10S4279C2_nt3v51Ev();
extern void _ZN10S4279C2_nt3v52Ev();
extern void _ZN10S4279C2_nt3v53Ev();
extern void _ZN10S4279C2_nt3v54Ev();
extern void _ZN7S4279C12v1Ev();
extern void _ZN7S4279C12v2Ev();
extern void _ZN7S4279C12v3Ev();
extern void _ZN7S4279C12v4Ev();
extern void _ZN7S4279C12v5Ev();
extern void _ZN7S4279C12v6Ev();
extern void _ZN7S4279C12v7Ev();
extern void _ZN7S4279C12v8Ev();
extern void _ZN7S4279C12v9Ev();
extern void _ZN7S4279C13v10Ev();
extern void _ZN7S4279C13v11Ev();
extern void _ZN7S4279C13v12Ev();
extern void _ZN7S4279C13v13Ev();
extern void _ZN7S4279C13v14Ev();
extern void ABISELECT(_ZThn72_N7S4279C1D1Ev,_ZThn48_N7S4279C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S4279C1D0Ev,_ZThn48_N7S4279C1D0Ev)();
extern void _ZN10S4279C5_nt3v55Ev();
extern void _ZN10S4279C5_nt3v56Ev();
static  VTBL_ENTRY vtc_S4279C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4279C1[0]),
  (VTBL_ENTRY)&_ZN7S4279C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4279C1D0Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4279C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S4279C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4279C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4279C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4279C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4279C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4279C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4279C13v14Ev,
  ABISELECT(-72,-48),
  (VTBL_ENTRY)&(_ZTI7S4279C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4279C1D1Ev,_ZThn48_N7S4279C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4279C1D0Ev,_ZThn48_N7S4279C1D0Ev),
  (VTBL_ENTRY)&_ZN10S4279C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S4279C5_nt3v56Ev,
};
extern VTBL_ENTRY _ZTI7S4279C1[];
extern  VTBL_ENTRY _ZTV7S4279C1[];
Class_Descriptor cd_S4279C1 = {  "S4279C1", // class name
  bases_S4279C1, 3,
  &(vtc_S4279C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,164), // object size
  NSPAIRA(_ZTI7S4279C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S4279C1),64, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C4  : S17070C13_nt {
  void *s10371c4f0[2];
};
//SIG(-1 S10371C4) C1{ BC2{} Fp[2]}



static void Test_S10371C4()
{
  extern Class_Descriptor cd_S10371C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10371C4, buf);
    S10371C4 &lv = *(new (buf) S10371C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10371C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10371C4)");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S10371C4");
    check_field_offset(lv, s10371c4f0, 0, "S10371C4.s10371c4f0");
    test_class_info(&lv, &cd_S10371C4);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10371C4(Test_S10371C4, "S10371C4", ABISELECT(16,8));

#else // __cplusplus

extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S10371C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10371C4 = {  "S10371C4", // class name
  bases_S10371C4, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C3  : S10371C4 {
};
//SIG(-1 S10371C3) C1{ BC2{ BC3{} Fp[2]}}



static void Test_S10371C3()
{
  extern Class_Descriptor cd_S10371C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10371C3, buf);
    S10371C3 &lv = *(new (buf) S10371C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10371C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10371C3)");
    check_base_class_offset(lv, (S17070C13_nt*)(S10371C4*), 0, "S10371C3");
    check_base_class_offset(lv, (S10371C4*), 0, "S10371C3");
    test_class_info(&lv, &cd_S10371C3);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10371C3(Test_S10371C3, "S10371C3", ABISELECT(16,8));

#else // __cplusplus

extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
extern Class_Descriptor cd_S10371C4;
static Base_Class bases_S10371C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10371C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10371C3 = {  "S10371C3", // class name
  bases_S10371C3, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C7  {
  int s10371c7f0:4;
  int s10371c7f1:4;
  int s10371c7f2:2;
  unsigned int s10371c7f3:1;
  unsigned int s10371c7f4:1;
  int s10371c7f5:2;
  int s10371c7f6:3;
  unsigned int s10371c7f7:1;
  unsigned int s10371c7f8:1;
  unsigned int s10371c7f9:1;
  int s10371c7f10:3;
  int s10371c7f11:3;
  unsigned int s10371c7f12:1;
  int s10371c7f13:5;
};
//SIG(-1 S10371C7) C1{ Fi:4 Fi:4 Fi:2 Fi:1 Fi:1 Fi:2 Fi:3 Fi:1 Fi:1 Fi:1 Fi:3 Fi:3 Fi:1 Fi:5}



static void Test_S10371C7()
{
  {
    init_simple_test("S10371C7");
    static S10371C7 lv;
    check2(sizeof(lv), 4, "sizeof(S10371C7)");
    check2(__alignof__(lv), 4, "__alignof__(S10371C7)");
    set_bf_and_test(lv, s10371c7f0, 0, 0, 4, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f0, 0, 0, 4, hide_sll(1LL<<3), "S10371C7");
    set_bf_and_test(lv, s10371c7f1, 0, 4, 4, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f1, 0, 4, 4, hide_sll(1LL<<3), "S10371C7");
    set_bf_and_test(lv, s10371c7f2, 1, 0, 2, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f2, 1, 0, 2, hide_sll(1LL<<1), "S10371C7");
    set_bf_and_test(lv, s10371c7f3, 1, 2, 1, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f4, 1, 3, 1, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f5, 1, 4, 2, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f5, 1, 4, 2, hide_sll(1LL<<1), "S10371C7");
    set_bf_and_test(lv, s10371c7f6, 1, 6, 3, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f6, 1, 6, 3, hide_sll(1LL<<2), "S10371C7");
    set_bf_and_test(lv, s10371c7f7, 2, 1, 1, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f8, 2, 2, 1, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f9, 2, 3, 1, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f10, 2, 4, 3, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f10, 2, 4, 3, hide_sll(1LL<<2), "S10371C7");
    set_bf_and_test(lv, s10371c7f11, 2, 7, 3, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f11, 2, 7, 3, hide_sll(1LL<<2), "S10371C7");
    set_bf_and_test(lv, s10371c7f12, 3, 2, 1, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f13, 3, 3, 5, 1, "S10371C7");
    set_bf_and_test(lv, s10371c7f13, 3, 3, 5, hide_sll(1LL<<4), "S10371C7");
  }
}
static Arrange_To_Call_Me vS10371C7(Test_S10371C7, "S10371C7", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C6  {
  char s10371c6f0;
  ::S10371C7 s10371c6f1;
  char s10371c6f2[66];
};
//SIG(1 S10371C6) C1{ Fc FC2{ Fi:4 Fi:4 Fi:2 Fi:1 Fi:1 Fi:2 Fi:3 Fi:1 Fi:1 Fi:1 Fi:3 Fi:3 Fi:1 Fi:5} Fc[66]}



static void Test_S10371C6()
{
  {
    init_simple_test("S10371C6");
    static S10371C6 lv;
    check2(sizeof(lv), 76, "sizeof(S10371C6)");
    check2(__alignof__(lv), 4, "__alignof__(S10371C6)");
    check_field_offset(lv, s10371c6f0, 0, "S10371C6.s10371c6f0");
    check_field_offset(lv, s10371c6f1, 4, "S10371C6.s10371c6f1");
    check_field_offset(lv, s10371c6f2, 8, "S10371C6.s10371c6f2");
  }
}
static Arrange_To_Call_Me vS10371C6(Test_S10371C6, "S10371C6", 76);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C5  {
  ::S10371C6 s10371c5f0[32];
  void  mf10371c5(); // _ZN8S10371C59mf10371c5Ev
};
//SIG(-1 S10371C5) C1{ m FC2{ Fc FC3{ Fi:4 Fi:4 Fi:2 Fi:1 Fi:1 Fi:2 Fi:3 Fi:1 Fi:1 Fi:1 Fi:3 Fi:3 Fi:1 Fi:5} Fc[66]}[32]}


void  S10371C5 ::mf10371c5(){}

static void Test_S10371C5()
{
  {
    init_simple_test("S10371C5");
    static S10371C5 lv;
    check2(sizeof(lv), 2432, "sizeof(S10371C5)");
    check2(__alignof__(lv), 4, "__alignof__(S10371C5)");
    check_field_offset(lv, s10371c5f0, 0, "S10371C5.s10371c5f0");
  }
}
static Arrange_To_Call_Me vS10371C5(Test_S10371C5, "S10371C5", 2432);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C9_nt  {
  __tsi64 s10371c9f0[4];
};
//SIG(-1 S10371C9_nt) C1{ FL[4]}



//skip512 S10371C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C8_nt  {
  ::S10371C9_nt s10371c8f0;
  void  mf10371c8(); // _ZN11S10371C8_nt9mf10371c8Ev
};
//SIG(-1 S10371C8_nt) C1{ m FC2{ FL[4]}}


void  S10371C8_nt ::mf10371c8(){}

//skip512 S10371C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C11_nt  {
  int s10371c11f0[4];
};
//SIG(-1 S10371C11_nt) C1{ Fi[4]}



//skip512 S10371C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C10_nt  {
  void *s10371c10f0;
  ::S10371C11_nt s10371c10f1;
  void  mf10371c10(); // _ZN12S10371C10_nt10mf10371c10Ev
};
//SIG(-1 S10371C10_nt) C1{ m Fp FC2{ Fi[4]}}


void  S10371C10_nt ::mf10371c10(){}

//skip512 S10371C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C14  {
  int s10371c14f0;
  __tsi64 s10371c14f1[5];
  short s10371c14f2[2];
  int s10371c14f3[2];
  void  mf10371c14(); // _ZN9S10371C1410mf10371c14Ev
};
//SIG(-1 S10371C14) C1{ m Fi FL[5] Fs[2] Fi[2]}


void  S10371C14 ::mf10371c14(){}

static void Test_S10371C14()
{
  {
    init_simple_test("S10371C14");
    S10371C14 lv;
    check2(sizeof(lv), ABISELECT(64,56), "sizeof(S10371C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10371C14)");
    check_field_offset(lv, s10371c14f0, 0, "S10371C14.s10371c14f0");
    check_field_offset(lv, s10371c14f1, ABISELECT(8,4), "S10371C14.s10371c14f1");
    check_field_offset(lv, s10371c14f2, ABISELECT(48,44), "S10371C14.s10371c14f2");
    check_field_offset(lv, s10371c14f3, ABISELECT(52,48), "S10371C14.s10371c14f3");
  }
}
static Arrange_To_Call_Me vS10371C14(Test_S10371C14, "S10371C14", ABISELECT(64,56));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C16  {
  int s10371c16f0[2];
  char s10371c16f1[48];
};
//SIG(1 S10371C16) C1{ Fi[2] Fc[48]}



static void Test_S10371C16()
{
  {
    init_simple_test("S10371C16");
    S10371C16 lv;
    check2(sizeof(lv), 56, "sizeof(S10371C16)");
    check2(__alignof__(lv), 4, "__alignof__(S10371C16)");
    check_field_offset(lv, s10371c16f0, 0, "S10371C16.s10371c16f0");
    check_field_offset(lv, s10371c16f1, 8, "S10371C16.s10371c16f1");
  }
}
static Arrange_To_Call_Me vS10371C16(Test_S10371C16, "S10371C16", 56);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C15  {
  ::S10371C16 s10371c15f0[32];
};
//SIG(-1 S10371C15) C1{ FC2{ Fi[2] Fc[48]}[32]}



static void Test_S10371C15()
{
  {
    init_simple_test("S10371C15");
    S10371C15 lv;
    check2(sizeof(lv), 1792, "sizeof(S10371C15)");
    check2(__alignof__(lv), 4, "__alignof__(S10371C15)");
    check_field_offset(lv, s10371c15f0, 0, "S10371C15.s10371c15f0");
  }
}
static Arrange_To_Call_Me vS10371C15(Test_S10371C15, "S10371C15", 1792);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10371C1  : S17070C13_nt {
  void *s10371c1f0;
  ::S10371C3 s10371c1f1;
  ::S10371C5 s10371c1f2;
  ::S10371C8_nt s10371c1f3;
  ::S10371C10_nt s10371c1f4;
  ::S10371C8_nt s10371c1f5;
  ::S10371C8_nt s10371c1f6;
  ::S10371C8_nt s10371c1f7;
  ::S10371C8_nt s10371c1f8;
  int s10371c1f9;
  char s10371c1f10;
  ::S17070C145 s10371c1f11[16];
  int s10371c1f12;
  char s10371c1f13[2];
  void *s10371c1f14[3];
  int s10371c1f15[4];
  char s10371c1f16;
  ::S10371C14 s10371c1f17;
  char s10371c1f18[3];
  void *s10371c1f19[32];
  int s10371c1f20;
  ::S10371C15 s10371c1f21;
};
//SIG(1 S10371C1) C1{ BC2{} Fp FC3{ BC4{ BC2 Fp[2]}} FC5{ m FC6{ Fc FC7{ Fi:4 Fi:4 Fi:2 Fi:1 Fi:1 Fi:2 Fi:3 Fi:1 Fi:1 Fi:1 Fi:3 Fi:3 Fi:1 Fi:5} Fc[66]}[32]} FC8{ m FC9{ FL[4]}} FC10{ m Fp FC11{ Fi[4]}} FC8 FC8 FC8 FC8 Fi Fc FC12{ m Fp[2]}[16] Fi Fc[2] Fp[3] Fi[4] Fc FC13{ m Fi FL[5] Fs[2] Fi[2]} Fc[3] Fp[32] Fi FC14{ FC15{ Fi[2] Fc[48]}[32]}}



static void Test_S10371C1()
{
  extern Class_Descriptor cd_S10371C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(637,1197)];
    init_test(&cd_S10371C1, buf);
    S10371C1 &lv = *(new (buf) S10371C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5088,4784), "sizeof(S10371C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10371C1)");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S10371C1");
    check_field_offset(lv, s10371c1f0, 0, "S10371C1.s10371c1f0");
    check_field_offset(lv, s10371c1f1, ABISELECT(8,4), "S10371C1.s10371c1f1");
    check_field_offset(lv, s10371c1f2, ABISELECT(24,12), "S10371C1.s10371c1f2");
    check_field_offset(lv, s10371c1f3, ABISELECT(2456,2444), "S10371C1.s10371c1f3");
    check_field_offset(lv, s10371c1f4, ABISELECT(2488,2476), "S10371C1.s10371c1f4");
    check_field_offset(lv, s10371c1f5, ABISELECT(2512,2496), "S10371C1.s10371c1f5");
    check_field_offset(lv, s10371c1f6, ABISELECT(2544,2528), "S10371C1.s10371c1f6");
    check_field_offset(lv, s10371c1f7, ABISELECT(2576,2560), "S10371C1.s10371c1f7");
    check_field_offset(lv, s10371c1f8, ABISELECT(2608,2592), "S10371C1.s10371c1f8");
    check_field_offset(lv, s10371c1f9, ABISELECT(2640,2624), "S10371C1.s10371c1f9");
    check_field_offset(lv, s10371c1f10, ABISELECT(2644,2628), "S10371C1.s10371c1f10");
    check_field_offset(lv, s10371c1f11, ABISELECT(2648,2632), "S10371C1.s10371c1f11");
    check_field_offset(lv, s10371c1f12, ABISELECT(2904,2760), "S10371C1.s10371c1f12");
    check_field_offset(lv, s10371c1f13, ABISELECT(2908,2764), "S10371C1.s10371c1f13");
    check_field_offset(lv, s10371c1f14, ABISELECT(2912,2768), "S10371C1.s10371c1f14");
    check_field_offset(lv, s10371c1f15, ABISELECT(2936,2780), "S10371C1.s10371c1f15");
    check_field_offset(lv, s10371c1f16, ABISELECT(2952,2796), "S10371C1.s10371c1f16");
    check_field_offset(lv, s10371c1f17, ABISELECT(2960,2800), "S10371C1.s10371c1f17");
    check_field_offset(lv, s10371c1f18, ABISELECT(3024,2856), "S10371C1.s10371c1f18");
    check_field_offset(lv, s10371c1f19, ABISELECT(3032,2860), "S10371C1.s10371c1f19");
    check_field_offset(lv, s10371c1f20, ABISELECT(3288,2988), "S10371C1.s10371c1f20");
    check_field_offset(lv, s10371c1f21, ABISELECT(3292,2992), "S10371C1.s10371c1f21");
    test_class_info(&lv, &cd_S10371C1);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10371C1(Test_S10371C1, "S10371C1", ABISELECT(5088,4784));

#else // __cplusplus

extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S10371C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10371C1 = {  "S10371C1", // class name
  bases_S10371C1, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(5088,4784), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10370C9_nt  {
  long s10370c9f0[4];
};
//SIG(-1 S10370C9_nt) C1{ Fl[4]}



//skip512 S10370C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10370C8_nt  {
  ::S10370C9_nt s10370c8f0;
  void  mf10370c8(); // _ZN11S10370C8_nt9mf10370c8Ev
};
//SIG(-1 S10370C8_nt) C1{ m FC2{ Fl[4]}}


void  S10370C8_nt ::mf10370c8(){}

//skip512 S10370C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10370C1  : S17070C13_nt {
  void *s10370c1f0;
  ::S10371C3 s10370c1f1;
  ::S10371C5 s10370c1f2;
  ::S10370C8_nt s10370c1f3;
  ::S10371C10_nt s10370c1f4;
  ::S10370C8_nt s10370c1f5;
  ::S10370C8_nt s10370c1f6;
  ::S10370C8_nt s10370c1f7;
  ::S10370C8_nt s10370c1f8;
  int s10370c1f9;
  char s10370c1f10;
  ::S17070C145 s10370c1f11[16];
  int s10370c1f12;
  char s10370c1f13[2];
  void *s10370c1f14[3];
  int s10370c1f15[4];
  char s10370c1f16;
  ::S10371C14 s10370c1f17;
  char s10370c1f18[3];
  void *s10370c1f19[32];
  int s10370c1f20;
  ::S10371C15 s10370c1f21;
};
//SIG(1 S10370C1) C1{ BC2{} Fp FC3{ BC4{ BC2 Fp[2]}} FC5{ m FC6{ Fc FC7{ Fi:4 Fi:4 Fi:2 Fi:1 Fi:1 Fi:2 Fi:3 Fi:1 Fi:1 Fi:1 Fi:3 Fi:3 Fi:1 Fi:5} Fc[66]}[32]} FC8{ m FC9{ Fl[4]}} FC10{ m Fp FC11{ Fi[4]}} FC8 FC8 FC8 FC8 Fi Fc FC12{ m Fp[2]}[16] Fi Fc[2] Fp[3] Fi[4] Fc FC13{ m Fi FL[5] Fs[2] Fi[2]} Fc[3] Fp[32] Fi FC14{ FC15{ Fi[2] Fc[48]}[32]}}



static void Test_S10370C1()
{
  extern Class_Descriptor cd_S10370C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(637,1177)];
    init_test(&cd_S10370C1, buf);
    S10370C1 &lv = *(new (buf) S10370C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5088,4704), "sizeof(S10370C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10370C1)");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S10370C1");
    check_field_offset(lv, s10370c1f0, 0, "S10370C1.s10370c1f0");
    check_field_offset(lv, s10370c1f1, ABISELECT(8,4), "S10370C1.s10370c1f1");
    check_field_offset(lv, s10370c1f2, ABISELECT(24,12), "S10370C1.s10370c1f2");
    check_field_offset(lv, s10370c1f3, ABISELECT(2456,2444), "S10370C1.s10370c1f3");
    check_field_offset(lv, s10370c1f4, ABISELECT(2488,2460), "S10370C1.s10370c1f4");
    check_field_offset(lv, s10370c1f5, ABISELECT(2512,2480), "S10370C1.s10370c1f5");
    check_field_offset(lv, s10370c1f6, ABISELECT(2544,2496), "S10370C1.s10370c1f6");
    check_field_offset(lv, s10370c1f7, ABISELECT(2576,2512), "S10370C1.s10370c1f7");
    check_field_offset(lv, s10370c1f8, ABISELECT(2608,2528), "S10370C1.s10370c1f8");
    check_field_offset(lv, s10370c1f9, ABISELECT(2640,2544), "S10370C1.s10370c1f9");
    check_field_offset(lv, s10370c1f10, ABISELECT(2644,2548), "S10370C1.s10370c1f10");
    check_field_offset(lv, s10370c1f11, ABISELECT(2648,2552), "S10370C1.s10370c1f11");
    check_field_offset(lv, s10370c1f12, ABISELECT(2904,2680), "S10370C1.s10370c1f12");
    check_field_offset(lv, s10370c1f13, ABISELECT(2908,2684), "S10370C1.s10370c1f13");
    check_field_offset(lv, s10370c1f14, ABISELECT(2912,2688), "S10370C1.s10370c1f14");
    check_field_offset(lv, s10370c1f15, ABISELECT(2936,2700), "S10370C1.s10370c1f15");
    check_field_offset(lv, s10370c1f16, ABISELECT(2952,2716), "S10370C1.s10370c1f16");
    check_field_offset(lv, s10370c1f17, ABISELECT(2960,2720), "S10370C1.s10370c1f17");
    check_field_offset(lv, s10370c1f18, ABISELECT(3024,2776), "S10370C1.s10370c1f18");
    check_field_offset(lv, s10370c1f19, ABISELECT(3032,2780), "S10370C1.s10370c1f19");
    check_field_offset(lv, s10370c1f20, ABISELECT(3288,2908), "S10370C1.s10370c1f20");
    check_field_offset(lv, s10370c1f21, ABISELECT(3292,2912), "S10370C1.s10370c1f21");
    test_class_info(&lv, &cd_S10370C1);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10370C1(Test_S10370C1, "S10370C1", ABISELECT(5088,4704));

#else // __cplusplus

extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S10370C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10370C1 = {  "S10370C1", // class name
  bases_S10370C1, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(5088,4704), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10372C8_nt  {
  __tsi64 s10372c8f0[4];
  void  mf10372c8(); // _ZN11S10372C8_nt9mf10372c8Ev
};
//SIG(-1 S10372C8_nt) C1{ m FL[4]}


void  S10372C8_nt ::mf10372c8(){}

//skip512 S10372C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10372C1  : S17070C13_nt {
  void *s10372c1f0;
  ::S10371C3 s10372c1f1;
  ::S10371C5 s10372c1f2;
  ::S10372C8_nt s10372c1f3;
  ::S10371C10_nt s10372c1f4;
  ::S10372C8_nt s10372c1f5;
  ::S10372C8_nt s10372c1f6;
  ::S10372C8_nt s10372c1f7;
  ::S10372C8_nt s10372c1f8;
  int s10372c1f9;
  char s10372c1f10;
  ::S17070C145 s10372c1f11[16];
  int s10372c1f12;
  char s10372c1f13[2];
  void *s10372c1f14[3];
  int s10372c1f15[4];
  char s10372c1f16;
  ::S10371C14 s10372c1f17;
  char s10372c1f18[3];
  void *s10372c1f19[32];
  int s10372c1f20;
  ::S10371C15 s10372c1f21;
};
//SIG(1 S10372C1) C1{ BC2{} Fp FC3{ BC4{ BC2 Fp[2]}} FC5{ m FC6{ Fc FC7{ Fi:4 Fi:4 Fi:2 Fi:1 Fi:1 Fi:2 Fi:3 Fi:1 Fi:1 Fi:1 Fi:3 Fi:3 Fi:1 Fi:5} Fc[66]}[32]} FC8{ m FL[4]} FC9{ m Fp FC10{ Fi[4]}} FC8 FC8 FC8 FC8 Fi Fc FC11{ m Fp[2]}[16] Fi Fc[2] Fp[3] Fi[4] Fc FC12{ m Fi FL[5] Fs[2] Fi[2]} Fc[3] Fp[32] Fi FC13{ FC14{ Fi[2] Fc[48]}[32]}}



static void Test_S10372C1()
{
  extern Class_Descriptor cd_S10372C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(637,1197)];
    init_test(&cd_S10372C1, buf);
    S10372C1 &lv = *(new (buf) S10372C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5088,4784), "sizeof(S10372C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10372C1)");
    check_base_class_offset(lv, (S17070C13_nt*), 0, "S10372C1");
    check_field_offset(lv, s10372c1f0, 0, "S10372C1.s10372c1f0");
    check_field_offset(lv, s10372c1f1, ABISELECT(8,4), "S10372C1.s10372c1f1");
    check_field_offset(lv, s10372c1f2, ABISELECT(24,12), "S10372C1.s10372c1f2");
    check_field_offset(lv, s10372c1f3, ABISELECT(2456,2444), "S10372C1.s10372c1f3");
    check_field_offset(lv, s10372c1f4, ABISELECT(2488,2476), "S10372C1.s10372c1f4");
    check_field_offset(lv, s10372c1f5, ABISELECT(2512,2496), "S10372C1.s10372c1f5");
    check_field_offset(lv, s10372c1f6, ABISELECT(2544,2528), "S10372C1.s10372c1f6");
    check_field_offset(lv, s10372c1f7, ABISELECT(2576,2560), "S10372C1.s10372c1f7");
    check_field_offset(lv, s10372c1f8, ABISELECT(2608,2592), "S10372C1.s10372c1f8");
    check_field_offset(lv, s10372c1f9, ABISELECT(2640,2624), "S10372C1.s10372c1f9");
    check_field_offset(lv, s10372c1f10, ABISELECT(2644,2628), "S10372C1.s10372c1f10");
    check_field_offset(lv, s10372c1f11, ABISELECT(2648,2632), "S10372C1.s10372c1f11");
    check_field_offset(lv, s10372c1f12, ABISELECT(2904,2760), "S10372C1.s10372c1f12");
    check_field_offset(lv, s10372c1f13, ABISELECT(2908,2764), "S10372C1.s10372c1f13");
    check_field_offset(lv, s10372c1f14, ABISELECT(2912,2768), "S10372C1.s10372c1f14");
    check_field_offset(lv, s10372c1f15, ABISELECT(2936,2780), "S10372C1.s10372c1f15");
    check_field_offset(lv, s10372c1f16, ABISELECT(2952,2796), "S10372C1.s10372c1f16");
    check_field_offset(lv, s10372c1f17, ABISELECT(2960,2800), "S10372C1.s10372c1f17");
    check_field_offset(lv, s10372c1f18, ABISELECT(3024,2856), "S10372C1.s10372c1f18");
    check_field_offset(lv, s10372c1f19, ABISELECT(3032,2860), "S10372C1.s10372c1f19");
    check_field_offset(lv, s10372c1f20, ABISELECT(3288,2988), "S10372C1.s10372c1f20");
    check_field_offset(lv, s10372c1f21, ABISELECT(3292,2992), "S10372C1.s10372c1f21");
    test_class_info(&lv, &cd_S10372C1);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10372C1(Test_S10372C1, "S10372C1", ABISELECT(5088,4784));

#else // __cplusplus

extern Class_Descriptor cd_S17070C13_nt;
extern VTBL_ENTRY _ZTI12S17070C13_nt[];
static Base_Class bases_S10372C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17070C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10372C1 = {  "S10372C1", // class name
  bases_S10372C1, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(5088,4784), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1709C4_nt  {
  int s1709c4f0;
  void  mf1709c4(); // _ZN10S1709C4_nt8mf1709c4Ev
  virtual  ~S1709C4_nt(); // _ZN10S1709C4_ntD1Ev
  S1709C4_nt(); // tgen
};
//SIG(-1 S1709C4_nt) C1{ vd m Fi}


void  S1709C4_nt ::mf1709c4(){}
 S1709C4_nt ::~S1709C4_nt(){ note_dtor("S1709C4_nt", this);}
S1709C4_nt ::S1709C4_nt(){ note_ctor("S1709C4_nt", this);} // tgen

//skip512 S1709C4_nt

#else // __cplusplus

extern void _ZN10S1709C4_ntC1Ev();
extern void _ZN10S1709C4_ntD1Ev();
Name_Map name_map_S1709C4_nt[] = {
  NSPAIR(_ZN10S1709C4_ntC1Ev),
  NSPAIR(_ZN10S1709C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1709C4_nt[];
extern void _ZN10S1709C4_ntD1Ev();
extern void _ZN10S1709C4_ntD0Ev();
static  VTBL_ENTRY vtc_S1709C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1709C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1709C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1709C4_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S1709C4_nt[];
VTBL_ENTRY *P__ZTI10S1709C4_nt = _ZTI10S1709C4_nt; 
extern  VTBL_ENTRY _ZTV10S1709C4_nt[];
Class_Descriptor cd_S1709C4_nt = {  "S1709C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1709C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S1709C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1709C4_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1709C3_nt  : S1709C4_nt {
  virtual void  v7(); // _ZN10S1709C3_nt2v7Ev
  virtual void  v8(); // _ZN10S1709C3_nt2v8Ev
  virtual void  v9(); // _ZN10S1709C3_nt2v9Ev
  virtual void  v10(); // _ZN10S1709C3_nt3v10Ev
  virtual void  v11(); // _ZN10S1709C3_nt3v11Ev
  ~S1709C3_nt(); // tgen
  S1709C3_nt(); // tgen
};
//SIG(-1 S1709C3_nt) C1{ BC2{ vd m Fi} v1 v2 v3 v4 v5}


void  S1709C3_nt ::v7(){vfunc_called(this, "_ZN10S1709C3_nt2v7Ev");}
void  S1709C3_nt ::v8(){vfunc_called(this, "_ZN10S1709C3_nt2v8Ev");}
void  S1709C3_nt ::v9(){vfunc_called(this, "_ZN10S1709C3_nt2v9Ev");}
void  S1709C3_nt ::v10(){vfunc_called(this, "_ZN10S1709C3_nt3v10Ev");}
void  S1709C3_nt ::v11(){vfunc_called(this, "_ZN10S1709C3_nt3v11Ev");}
S1709C3_nt ::~S1709C3_nt(){ note_dtor("S1709C3_nt", this);} // tgen
S1709C3_nt ::S1709C3_nt(){ note_ctor("S1709C3_nt", this);} // tgen

//skip512 S1709C3_nt

#else // __cplusplus

extern void _ZN10S1709C3_ntC1Ev();
extern void _ZN10S1709C3_ntD1Ev();
Name_Map name_map_S1709C3_nt[] = {
  NSPAIR(_ZN10S1709C3_ntC1Ev),
  NSPAIR(_ZN10S1709C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1709C4_nt;
extern VTBL_ENTRY _ZTI10S1709C4_nt[];
extern  VTBL_ENTRY _ZTV10S1709C4_nt[];
static Base_Class bases_S1709C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1709C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1709C3_nt[];
extern void _ZN10S1709C3_ntD1Ev();
extern void _ZN10S1709C3_ntD0Ev();
extern void _ZN10S1709C3_nt2v7Ev();
extern void _ZN10S1709C3_nt2v8Ev();
extern void _ZN10S1709C3_nt2v9Ev();
extern void _ZN10S1709C3_nt3v10Ev();
extern void _ZN10S1709C3_nt3v11Ev();
static  VTBL_ENTRY vtc_S1709C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1709C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1709C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI10S1709C3_nt[];
VTBL_ENTRY *P__ZTI10S1709C3_nt = _ZTI10S1709C3_nt; 
extern  VTBL_ENTRY _ZTV10S1709C3_nt[];
Class_Descriptor cd_S1709C3_nt = {  "S1709C3_nt", // class name
  bases_S1709C3_nt, 1,
  &(vtc_S1709C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S1709C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1709C3_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1709C5_nt  {
  ::S17070C30_nt s1709c5f0;
  void *s1709c5f1[2];
  void  mf1709c5(); // _ZN10S1709C5_nt8mf1709c5Ev
};
//SIG(-1 S1709C5_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}} Fp[2]}


void  S1709C5_nt ::mf1709c5(){}

//skip512 S1709C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1709C2_nt  : S1709C3_nt {
  void *s1709c2f0[3];
  ::S1709C5_nt s1709c2f1;
  virtual void  v12(); // _ZN10S1709C2_nt3v12Ev
  virtual void  v13(); // _ZN10S1709C2_nt3v13Ev
  virtual void  v14(); // _ZN10S1709C2_nt3v14Ev
  virtual void  v15(); // _ZN10S1709C2_nt3v15Ev
  virtual void  v16(); // _ZN10S1709C2_nt3v16Ev
  virtual void  v17(); // _ZN10S1709C2_nt3v17Ev
  virtual void  v18(); // _ZN10S1709C2_nt3v18Ev
  virtual void  v19(); // _ZN10S1709C2_nt3v19Ev
  virtual void  v20(); // _ZN10S1709C2_nt3v20Ev
  virtual void  v21(); // _ZN10S1709C2_nt3v21Ev
  virtual void  v22(); // _ZN10S1709C2_nt3v22Ev
  ~S1709C2_nt(); // tgen
  S1709C2_nt(); // tgen
};
//SIG(-1 S1709C2_nt) C1{ BC2{ BC3{ vd m Fi} v12 v13 v14 v15 v16} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[3] FC4{ m FC5{ m Fp Fi[2] FC6{ m}} Fp[2]}}


void  S1709C2_nt ::v12(){vfunc_called(this, "_ZN10S1709C2_nt3v12Ev");}
void  S1709C2_nt ::v13(){vfunc_called(this, "_ZN10S1709C2_nt3v13Ev");}
void  S1709C2_nt ::v14(){vfunc_called(this, "_ZN10S1709C2_nt3v14Ev");}
void  S1709C2_nt ::v15(){vfunc_called(this, "_ZN10S1709C2_nt3v15Ev");}
void  S1709C2_nt ::v16(){vfunc_called(this, "_ZN10S1709C2_nt3v16Ev");}
void  S1709C2_nt ::v17(){vfunc_called(this, "_ZN10S1709C2_nt3v17Ev");}
void  S1709C2_nt ::v18(){vfunc_called(this, "_ZN10S1709C2_nt3v18Ev");}
void  S1709C2_nt ::v19(){vfunc_called(this, "_ZN10S1709C2_nt3v19Ev");}
void  S1709C2_nt ::v20(){vfunc_called(this, "_ZN10S1709C2_nt3v20Ev");}
void  S1709C2_nt ::v21(){vfunc_called(this, "_ZN10S1709C2_nt3v21Ev");}
void  S1709C2_nt ::v22(){vfunc_called(this, "_ZN10S1709C2_nt3v22Ev");}
S1709C2_nt ::~S1709C2_nt(){ note_dtor("S1709C2_nt", this);} // tgen
S1709C2_nt ::S1709C2_nt(){ note_ctor("S1709C2_nt", this);} // tgen

//skip512 S1709C2_nt

#else // __cplusplus

extern void _ZN10S1709C2_ntC1Ev();
extern void _ZN10S1709C2_ntD1Ev();
Name_Map name_map_S1709C2_nt[] = {
  NSPAIR(_ZN10S1709C2_ntC1Ev),
  NSPAIR(_ZN10S1709C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1709C4_nt;
extern VTBL_ENTRY _ZTI10S1709C4_nt[];
extern  VTBL_ENTRY _ZTV10S1709C4_nt[];
extern Class_Descriptor cd_S1709C3_nt;
extern VTBL_ENTRY _ZTI10S1709C3_nt[];
extern  VTBL_ENTRY _ZTV10S1709C3_nt[];
static Base_Class bases_S1709C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1709C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1709C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1709C2_nt[];
extern void _ZN10S1709C2_ntD1Ev();
extern void _ZN10S1709C2_ntD0Ev();
extern void _ZN10S1709C3_nt2v7Ev();
extern void _ZN10S1709C3_nt2v8Ev();
extern void _ZN10S1709C3_nt2v9Ev();
extern void _ZN10S1709C3_nt3v10Ev();
extern void _ZN10S1709C3_nt3v11Ev();
extern void _ZN10S1709C2_nt3v12Ev();
extern void _ZN10S1709C2_nt3v13Ev();
extern void _ZN10S1709C2_nt3v14Ev();
extern void _ZN10S1709C2_nt3v15Ev();
extern void _ZN10S1709C2_nt3v16Ev();
extern void _ZN10S1709C2_nt3v17Ev();
extern void _ZN10S1709C2_nt3v18Ev();
extern void _ZN10S1709C2_nt3v19Ev();
extern void _ZN10S1709C2_nt3v20Ev();
extern void _ZN10S1709C2_nt3v21Ev();
extern void _ZN10S1709C2_nt3v22Ev();
static  VTBL_ENTRY vtc_S1709C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1709C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1709C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v22Ev,
};
extern VTBL_ENTRY _ZTI10S1709C2_nt[];
VTBL_ENTRY *P__ZTI10S1709C2_nt = _ZTI10S1709C2_nt; 
extern  VTBL_ENTRY _ZTV10S1709C2_nt[];
Class_Descriptor cd_S1709C2_nt = {  "S1709C2_nt", // class name
  bases_S1709C2_nt, 2,
  &(vtc_S1709C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,44), // object size
  NSPAIRA(_ZTI10S1709C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1709C2_nt),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1709C13  {
  char s1709c13f0[1280];
  ::S17070C74_nt s1709c13f1;
  ::S17070C74_nt s1709c13f2;
  __tsi64 s1709c13f3;
  char s1709c13f4[4];
  int s1709c13f5;
};
//SIG(-1 S1709C13) C1{ Fc[1280] FC2{ m Fp Fi FC3{ m}} FC2 FL Fc[4] Fi}



static void Test_S1709C13()
{
  {
    init_simple_test("S1709C13");
    S1709C13 lv;
    check2(sizeof(lv), ABISELECT(1328,1320), "sizeof(S1709C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1709C13)");
    check_field_offset(lv, s1709c13f0, 0, "S1709C13.s1709c13f0");
    check_field_offset(lv, s1709c13f1, 1280, "S1709C13.s1709c13f1");
    check_field_offset(lv, s1709c13f2, ABISELECT(1296,1292), "S1709C13.s1709c13f2");
    check_field_offset(lv, s1709c13f3, ABISELECT(1312,1304), "S1709C13.s1709c13f3");
    check_field_offset(lv, s1709c13f4, ABISELECT(1320,1312), "S1709C13.s1709c13f4");
    check_field_offset(lv, s1709c13f5, ABISELECT(1324,1316), "S1709C13.s1709c13f5");
  }
}
static Arrange_To_Call_Me vS1709C13(Test_S1709C13, "S1709C13", ABISELECT(1328,1320));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1709C1  : S1709C2_nt {
  ::S17070C23_nt s1709c1f0;
  int s1709c1f1;
  ::S17070C21_nt s1709c1f2;
  ::S17070C74_nt s1709c1f3;
  ::S17070C74_nt s1709c1f4;
  ::S17070C74_nt s1709c1f5;
  ::S17070C74_nt s1709c1f6;
  void *s1709c1f7[2];
  ::S1709C5_nt s1709c1f8;
  ::S1709C13 s1709c1f9;
  ::S15755C83 s1709c1f10;
  void *s1709c1f11;
  char s1709c1f12[5];
  virtual void  v1(); // _ZN7S1709C12v1Ev
  virtual void  v2(); // _ZN7S1709C12v2Ev
  virtual void  v3(); // _ZN7S1709C12v3Ev
  virtual void  v4(); // _ZN7S1709C12v4Ev
  virtual void  v5(); // _ZN7S1709C12v5Ev
  virtual void  v6(); // _ZN7S1709C12v6Ev
  ~S1709C1(); // tgen
  S1709C1(); // tgen
};
//SIG(1 S1709C1) C1{ BC2{ BC3{ BC4{ vd m Fi} v7 v8 v9 v10 v11} v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[3] FC5{ m FC6{ m Fp Fi[2] FC7{ m}} Fp[2]}} v1 v2 v3 v4 v5 v6 FC8{ m FC9{ m FL}} Fi FC10{ m Fp} FC11{ m Fp Fi FC7} FC11 FC11 FC11 Fp[2] FC5 FC12{ Fc[1280] FC11 FC11 FL Fc[4] Fi} FC13{ m Fp Fi[2] FC7} Fp Fc[5]}


void  S1709C1 ::v1(){vfunc_called(this, "_ZN7S1709C12v1Ev");}
void  S1709C1 ::v2(){vfunc_called(this, "_ZN7S1709C12v2Ev");}
void  S1709C1 ::v3(){vfunc_called(this, "_ZN7S1709C12v3Ev");}
void  S1709C1 ::v4(){vfunc_called(this, "_ZN7S1709C12v4Ev");}
void  S1709C1 ::v5(){vfunc_called(this, "_ZN7S1709C12v5Ev");}
void  S1709C1 ::v6(){vfunc_called(this, "_ZN7S1709C12v6Ev");}
S1709C1 ::~S1709C1(){ note_dtor("S1709C1", this);} // tgen
S1709C1 ::S1709C1(){ note_ctor("S1709C1", this);} // tgen

static void Test_S1709C1()
{
  extern Class_Descriptor cd_S1709C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(200,373)];
    init_test(&cd_S1709C1, buf);
    S1709C1 *dp, &lv = *(dp=new (buf) S1709C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1592,1488), "sizeof(S1709C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1709C1)");
    check_base_class_offset(lv, (S1709C4_nt*)(S1709C3_nt*)(S1709C2_nt*), 0, "S1709C1");
    check_base_class_offset(lv, (S1709C3_nt*)(S1709C2_nt*), 0, "S1709C1");
    check_base_class_offset(lv, (S1709C2_nt*), 0, "S1709C1");
    check_field_offset(lv, s1709c1f0, ABISELECT(80,44), "S1709C1.s1709c1f0");
    check_field_offset(lv, s1709c1f1, ABISELECT(88,52), "S1709C1.s1709c1f1");
    check_field_offset(lv, s1709c1f2, ABISELECT(96,56), "S1709C1.s1709c1f2");
    check_field_offset(lv, s1709c1f3, ABISELECT(104,60), "S1709C1.s1709c1f3");
    check_field_offset(lv, s1709c1f4, ABISELECT(120,72), "S1709C1.s1709c1f4");
    check_field_offset(lv, s1709c1f5, ABISELECT(136,84), "S1709C1.s1709c1f5");
    check_field_offset(lv, s1709c1f6, ABISELECT(152,96), "S1709C1.s1709c1f6");
    check_field_offset(lv, s1709c1f7, ABISELECT(168,108), "S1709C1.s1709c1f7");
    check_field_offset(lv, s1709c1f8, ABISELECT(184,116), "S1709C1.s1709c1f8");
    check_field_offset(lv, s1709c1f9, ABISELECT(224,140), "S1709C1.s1709c1f9");
    check_field_offset(lv, s1709c1f10, ABISELECT(1552,1460), "S1709C1.s1709c1f10");
    check_field_offset(lv, s1709c1f11, ABISELECT(1576,1476), "S1709C1.s1709c1f11");
    check_field_offset(lv, s1709c1f12, ABISELECT(1584,1480), "S1709C1.s1709c1f12");
    test_class_info(&lv, &cd_S1709C1);
    dp->~S1709C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1709C1(Test_S1709C1, "S1709C1", ABISELECT(1592,1488));

#else // __cplusplus

extern void _ZN7S1709C1C1Ev();
extern void _ZN7S1709C1D1Ev();
Name_Map name_map_S1709C1[] = {
  NSPAIR(_ZN7S1709C1C1Ev),
  NSPAIR(_ZN7S1709C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1709C4_nt;
extern VTBL_ENTRY _ZTI10S1709C4_nt[];
extern  VTBL_ENTRY _ZTV10S1709C4_nt[];
extern Class_Descriptor cd_S1709C3_nt;
extern VTBL_ENTRY _ZTI10S1709C3_nt[];
extern  VTBL_ENTRY _ZTV10S1709C3_nt[];
extern Class_Descriptor cd_S1709C2_nt;
extern VTBL_ENTRY _ZTI10S1709C2_nt[];
extern  VTBL_ENTRY _ZTV10S1709C2_nt[];
static Base_Class bases_S1709C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1709C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1709C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1709C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1709C1[];
extern void _ZN7S1709C1D1Ev();
extern void _ZN7S1709C1D0Ev();
extern void _ZN10S1709C3_nt2v7Ev();
extern void _ZN10S1709C3_nt2v8Ev();
extern void _ZN10S1709C3_nt2v9Ev();
extern void _ZN10S1709C3_nt3v10Ev();
extern void _ZN10S1709C3_nt3v11Ev();
extern void _ZN10S1709C2_nt3v12Ev();
extern void _ZN10S1709C2_nt3v13Ev();
extern void _ZN10S1709C2_nt3v14Ev();
extern void _ZN10S1709C2_nt3v15Ev();
extern void _ZN10S1709C2_nt3v16Ev();
extern void _ZN10S1709C2_nt3v17Ev();
extern void _ZN10S1709C2_nt3v18Ev();
extern void _ZN10S1709C2_nt3v19Ev();
extern void _ZN10S1709C2_nt3v20Ev();
extern void _ZN10S1709C2_nt3v21Ev();
extern void _ZN10S1709C2_nt3v22Ev();
extern void _ZN7S1709C12v1Ev();
extern void _ZN7S1709C12v2Ev();
extern void _ZN7S1709C12v3Ev();
extern void _ZN7S1709C12v4Ev();
extern void _ZN7S1709C12v5Ev();
extern void _ZN7S1709C12v6Ev();
static  VTBL_ENTRY vtc_S1709C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1709C1[0]),
  (VTBL_ENTRY)&_ZN7S1709C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1709C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1709C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1709C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN7S1709C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1709C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1709C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1709C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1709C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1709C12v6Ev,
};
extern VTBL_ENTRY _ZTI7S1709C1[];
extern  VTBL_ENTRY _ZTV7S1709C1[];
Class_Descriptor cd_S1709C1 = {  "S1709C1", // class name
  bases_S1709C1, 3,
  &(vtc_S1709C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1592,1488), // object size
  NSPAIRA(_ZTI7S1709C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1709C1),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2071C4_nt  {
  ::S17070C74_nt s2071c4f0;
  int s2071c4f1[2];
  char s2071c4f2;
  virtual  ~S2071C4_nt(); // _ZN10S2071C4_ntD1Ev
  virtual void  v2(); // _ZN10S2071C4_nt2v2Ev
  virtual void  v3(); // _ZN10S2071C4_nt2v3Ev
  virtual void  v4(); // _ZN10S2071C4_nt2v4Ev
  S2071C4_nt(); // tgen
};
//SIG(-1 S2071C4_nt) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2071C4_nt ::~S2071C4_nt(){ note_dtor("S2071C4_nt", this);}
void  S2071C4_nt ::v2(){vfunc_called(this, "_ZN10S2071C4_nt2v2Ev");}
void  S2071C4_nt ::v3(){vfunc_called(this, "_ZN10S2071C4_nt2v3Ev");}
void  S2071C4_nt ::v4(){vfunc_called(this, "_ZN10S2071C4_nt2v4Ev");}
S2071C4_nt ::S2071C4_nt(){ note_ctor("S2071C4_nt", this);} // tgen

//skip512 S2071C4_nt

#else // __cplusplus

extern void _ZN10S2071C4_ntC1Ev();
extern void _ZN10S2071C4_ntD1Ev();
Name_Map name_map_S2071C4_nt[] = {
  NSPAIR(_ZN10S2071C4_ntC1Ev),
  NSPAIR(_ZN10S2071C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2071C4_nt[];
extern void _ZN10S2071C4_ntD1Ev();
extern void _ZN10S2071C4_ntD0Ev();
extern void _ZN10S2071C4_nt2v2Ev();
extern void _ZN10S2071C4_nt2v3Ev();
extern void _ZN10S2071C4_nt2v4Ev();
static  VTBL_ENTRY vtc_S2071C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2071C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2071C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v4Ev,
};
extern VTBL_ENTRY _ZTI10S2071C4_nt[];
VTBL_ENTRY *P__ZTI10S2071C4_nt = _ZTI10S2071C4_nt; 
extern  VTBL_ENTRY _ZTV10S2071C4_nt[];
Class_Descriptor cd_S2071C4_nt = {  "S2071C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2071C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI10S2071C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2071C4_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2071C3_nt  : S2071C4_nt {
  void *s2071c3f0;
  virtual void  v5(); // _ZN10S2071C3_nt2v5Ev
  virtual void  v6(); // _ZN10S2071C3_nt2v6Ev
  ~S2071C3_nt(); // tgen
  S2071C3_nt(); // tgen
};
//SIG(-1 S2071C3_nt) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S2071C3_nt ::v5(){vfunc_called(this, "_ZN10S2071C3_nt2v5Ev");}
void  S2071C3_nt ::v6(){vfunc_called(this, "_ZN10S2071C3_nt2v6Ev");}
S2071C3_nt ::~S2071C3_nt(){ note_dtor("S2071C3_nt", this);} // tgen
S2071C3_nt ::S2071C3_nt(){ note_ctor("S2071C3_nt", this);} // tgen

//skip512 S2071C3_nt

#else // __cplusplus

extern void _ZN10S2071C3_ntC1Ev();
extern void _ZN10S2071C3_ntD1Ev();
Name_Map name_map_S2071C3_nt[] = {
  NSPAIR(_ZN10S2071C3_ntC1Ev),
  NSPAIR(_ZN10S2071C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2071C4_nt;
extern VTBL_ENTRY _ZTI10S2071C4_nt[];
extern  VTBL_ENTRY _ZTV10S2071C4_nt[];
static Base_Class bases_S2071C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2071C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2071C3_nt[];
extern void _ZN10S2071C3_ntD1Ev();
extern void _ZN10S2071C3_ntD0Ev();
extern void _ZN10S2071C4_nt2v2Ev();
extern void _ZN10S2071C4_nt2v3Ev();
extern void _ZN10S2071C4_nt2v4Ev();
extern void _ZN10S2071C3_nt2v5Ev();
extern void _ZN10S2071C3_nt2v6Ev();
static  VTBL_ENTRY vtc_S2071C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2071C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2071C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2071C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2071C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2071C3_nt2v6Ev,
};
extern VTBL_ENTRY _ZTI10S2071C3_nt[];
VTBL_ENTRY *P__ZTI10S2071C3_nt = _ZTI10S2071C3_nt; 
extern  VTBL_ENTRY _ZTV10S2071C3_nt[];
Class_Descriptor cd_S2071C3_nt = {  "S2071C3_nt", // class name
  bases_S2071C3_nt, 1,
  &(vtc_S2071C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI10S2071C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2071C3_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2071C8_nt  {
  void *s2071c8f0;
  int s2071c8f1;
  ::S17070C78 s2071c8f2;
  void  mf2071c8(); // _ZN10S2071C8_nt8mf2071c8Ev
};
//SIG(-1 S2071C8_nt) C1{ m Fp Fi FC2{ m}}


void  S2071C8_nt ::mf2071c8(){}

//skip512 S2071C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2071C7  {
  int s2071c7f0;
  void *s2071c7f1;
  ::S2071C8_nt s2071c7f2;
  void *s2071c7f3;
  int s2071c7f4;
  void  mf2071c7(); // _ZN7S2071C78mf2071c7Ev
  virtual  ~S2071C7(); // _ZN7S2071C7D1Ev
  S2071C7(); // tgen
};
//SIG(-1 S2071C7) C1{ vd m Fi Fp FC2{ m Fp Fi FC3{ m}} Fp Fi}


void  S2071C7 ::mf2071c7(){}
 S2071C7 ::~S2071C7(){ note_dtor("S2071C7", this);}
S2071C7 ::S2071C7(){ note_ctor("S2071C7", this);} // tgen

static void Test_S2071C7()
{
  extern Class_Descriptor cd_S2071C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S2071C7, buf);
    S2071C7 *dp, &lv = *(dp=new (buf) S2071C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S2071C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2071C7)");
    check_field_offset(lv, s2071c7f0, ABISELECT(8,4), "S2071C7.s2071c7f0");
    check_field_offset(lv, s2071c7f1, ABISELECT(16,8), "S2071C7.s2071c7f1");
    check_field_offset(lv, s2071c7f2, ABISELECT(24,12), "S2071C7.s2071c7f2");
    check_field_offset(lv, s2071c7f3, ABISELECT(40,24), "S2071C7.s2071c7f3");
    check_field_offset(lv, s2071c7f4, ABISELECT(48,28), "S2071C7.s2071c7f4");
    test_class_info(&lv, &cd_S2071C7);
    dp->~S2071C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2071C7(Test_S2071C7, "S2071C7", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S2071C7C1Ev();
extern void _ZN7S2071C7D1Ev();
Name_Map name_map_S2071C7[] = {
  NSPAIR(_ZN7S2071C7C1Ev),
  NSPAIR(_ZN7S2071C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2071C7[];
extern void _ZN7S2071C7D1Ev();
extern void _ZN7S2071C7D0Ev();
static  VTBL_ENTRY vtc_S2071C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2071C7[0]),
  (VTBL_ENTRY)&_ZN7S2071C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2071C7D0Ev,
};
extern VTBL_ENTRY _ZTI7S2071C7[];
extern  VTBL_ENTRY _ZTV7S2071C7[];
Class_Descriptor cd_S2071C7 = {  "S2071C7", // class name
  0,0,//no base classes
  &(vtc_S2071C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S2071C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2071C7),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2071C2  : S2071C3_nt , S2071C7 {
  virtual  ~S2071C2(); // _ZN7S2071C2D1Ev
  virtual void  v7(); // _ZN7S2071C22v7Ev
  virtual void  v8(); // _ZN7S2071C22v8Ev
  S2071C2(); // tgen
};
//SIG(-1 S2071C2) C1{ BC2{ BC3{ vd v3 v4 v5 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v6 v7 Fp} BC6{ vd m Fi Fp FC7{ m Fp Fi FC8{ m}} Fp Fi} vd v1 v2}


 S2071C2 ::~S2071C2(){ note_dtor("S2071C2", this);}
void  S2071C2 ::v7(){vfunc_called(this, "_ZN7S2071C22v7Ev");}
void  S2071C2 ::v8(){vfunc_called(this, "_ZN7S2071C22v8Ev");}
S2071C2 ::S2071C2(){ note_ctor("S2071C2", this);} // tgen

static void Test_S2071C2()
{
  extern Class_Descriptor cd_S2071C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S2071C2, buf);
    S2071C2 *dp, &lv = *(dp=new (buf) S2071C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S2071C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2071C2)");
    check_base_class_offset(lv, (S2071C4_nt*)(S2071C3_nt*), 0, "S2071C2");
    check_base_class_offset(lv, (S2071C3_nt*), 0, "S2071C2");
    check_base_class_offset(lv, (S2071C7*), ABISELECT(48,32), "S2071C2");
    test_class_info(&lv, &cd_S2071C2);
    dp->~S2071C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2071C2(Test_S2071C2, "S2071C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S2071C2C1Ev();
extern void _ZN7S2071C2D1Ev();
Name_Map name_map_S2071C2[] = {
  NSPAIR(_ZN7S2071C2C1Ev),
  NSPAIR(_ZN7S2071C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2071C4_nt;
extern VTBL_ENTRY _ZTI10S2071C4_nt[];
extern  VTBL_ENTRY _ZTV10S2071C4_nt[];
extern Class_Descriptor cd_S2071C3_nt;
extern VTBL_ENTRY _ZTI10S2071C3_nt[];
extern  VTBL_ENTRY _ZTV10S2071C3_nt[];
extern Class_Descriptor cd_S2071C7;
extern VTBL_ENTRY _ZTI7S2071C7[];
extern  VTBL_ENTRY _ZTV7S2071C7[];
static Base_Class bases_S2071C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2071C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2071C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2071C7,    ABISELECT(48,32), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2071C2[];
extern void _ZN7S2071C2D1Ev();
extern void _ZN7S2071C2D0Ev();
extern void _ZN10S2071C4_nt2v2Ev();
extern void _ZN10S2071C4_nt2v3Ev();
extern void _ZN10S2071C4_nt2v4Ev();
extern void _ZN10S2071C3_nt2v5Ev();
extern void _ZN10S2071C3_nt2v6Ev();
extern void _ZN7S2071C22v7Ev();
extern void _ZN7S2071C22v8Ev();
extern void ABISELECT(_ZThn48_N7S2071C2D1Ev,_ZThn32_N7S2071C2D1Ev)();
extern void ABISELECT(_ZThn48_N7S2071C2D0Ev,_ZThn32_N7S2071C2D0Ev)();
static  VTBL_ENTRY vtc_S2071C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2071C2[0]),
  (VTBL_ENTRY)&_ZN7S2071C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2071C2D0Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2071C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2071C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN7S2071C22v7Ev,
  (VTBL_ENTRY)&_ZN7S2071C22v8Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S2071C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2071C2D1Ev,_ZThn32_N7S2071C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2071C2D0Ev,_ZThn32_N7S2071C2D0Ev),
};
extern VTBL_ENTRY _ZTI7S2071C2[];
extern  VTBL_ENTRY _ZTV7S2071C2[];
Class_Descriptor cd_S2071C2 = {  "S2071C2", // class name
  bases_S2071C2, 3,
  &(vtc_S2071C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S2071C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2071C2),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2071C10_nt  {
  int s2071c10f0;
  ::S17070C74_nt s2071c10f1;
  ::S17070C30_nt s2071c10f2;
  ::S17070C30_nt s2071c10f3;
  ::S17070C30_nt s2071c10f4;
  ::S17070C74_nt s2071c10f5;
  ::S17070C74_nt s2071c10f6;
  int s2071c10f7[2];
  ::S15755C83 s2071c10f8;
  ::S17070C77_nt s2071c10f9;
  ::S15755C12_nt s2071c10f10;
  int s2071c10f11;
  char s2071c10f12;
  ::S17070C74_nt s2071c10f13;
  ::S17070C74_nt s2071c10f14;
  char s2071c10f15;
  void  mf2071c10(); // _ZN11S2071C10_nt9mf2071c10Ev
};
//SIG(-1 S2071C10_nt) C1{ m Fi FC2{ m Fp Fi FC3{ m}} FC4{ m Fp Fi[2] FC3} FC4 FC4 FC2 FC2 Fi[2] FC5{ m Fp Fi[2] FC3} FC6{ m Fp Fi FC7{ m} FC7} FC8{ m Fp Fi[2] FC7} Fi Fc FC2 FC2 Fc}


void  S2071C10_nt ::mf2071c10(){}

//skip512 S2071C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2071C1  : S2071C2 {
  int s2071c1f0[3];
  ::S2071C10_nt s2071c1f1;
  virtual  ~S2071C1(); // _ZN7S2071C1D1Ev
  virtual void  v1(); // _ZN7S2071C12v1Ev
  S2071C1(); // tgen
};
//SIG(1 S2071C1) C1{ BC2{ BC3{ BC4{ vd v2 v3 v4 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v5 v6 Fp} BC7{ vd m Fi Fp FC8{ m Fp Fi FC9{ m}} Fp Fi} vd v7 v8} vd v1 Fi[3] FC10{ m Fi FC5 FC11{ m Fp Fi[2] FC6} FC11 FC11 FC5 FC5 Fi[2] FC12{ m Fp Fi[2] FC6} FC13{ m Fp Fi FC9 FC9} FC14{ m Fp Fi[2] FC9} Fi Fc FC5 FC5 Fc}}


 S2071C1 ::~S2071C1(){ note_dtor("S2071C1", this);}
void  S2071C1 ::v1(){vfunc_called(this, "_ZN7S2071C12v1Ev");}
S2071C1 ::S2071C1(){ note_ctor("S2071C1", this);} // tgen

static void Test_S2071C1()
{
  extern Class_Descriptor cd_S2071C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,64)];
    init_test(&cd_S2071C1, buf);
    S2071C1 *dp, &lv = *(dp=new (buf) S2071C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,252), "sizeof(S2071C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2071C1)");
    check_base_class_offset(lv, (S2071C4_nt*)(S2071C3_nt*)(S2071C2*), 0, "S2071C1");
    check_base_class_offset(lv, (S2071C3_nt*)(S2071C2*), 0, "S2071C1");
    check_base_class_offset(lv, (S2071C7*)(S2071C2*), ABISELECT(48,32), "S2071C1");
    check_base_class_offset(lv, (S2071C2*), 0, "S2071C1");
    check_field_offset(lv, s2071c1f0, ABISELECT(100,64), "S2071C1.s2071c1f0");
    check_field_offset(lv, s2071c1f1, ABISELECT(112,76), "S2071C1.s2071c1f1");
    test_class_info(&lv, &cd_S2071C1);
    dp->~S2071C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2071C1(Test_S2071C1, "S2071C1", ABISELECT(360,252));

#else // __cplusplus

extern void _ZN7S2071C1C1Ev();
extern void _ZN7S2071C1D1Ev();
Name_Map name_map_S2071C1[] = {
  NSPAIR(_ZN7S2071C1C1Ev),
  NSPAIR(_ZN7S2071C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2071C4_nt;
extern VTBL_ENTRY _ZTI10S2071C4_nt[];
extern  VTBL_ENTRY _ZTV10S2071C4_nt[];
extern Class_Descriptor cd_S2071C3_nt;
extern VTBL_ENTRY _ZTI10S2071C3_nt[];
extern  VTBL_ENTRY _ZTV10S2071C3_nt[];
extern Class_Descriptor cd_S2071C7;
extern VTBL_ENTRY _ZTI7S2071C7[];
extern  VTBL_ENTRY _ZTV7S2071C7[];
extern Class_Descriptor cd_S2071C2;
extern VTBL_ENTRY _ZTI7S2071C2[];
extern  VTBL_ENTRY _ZTV7S2071C2[];
static Base_Class bases_S2071C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2071C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2071C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2071C7,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2071C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2071C1[];
extern void _ZN7S2071C1D1Ev();
extern void _ZN7S2071C1D0Ev();
extern void _ZN10S2071C4_nt2v2Ev();
extern void _ZN10S2071C4_nt2v3Ev();
extern void _ZN10S2071C4_nt2v4Ev();
extern void _ZN10S2071C3_nt2v5Ev();
extern void _ZN10S2071C3_nt2v6Ev();
extern void _ZN7S2071C22v7Ev();
extern void _ZN7S2071C22v8Ev();
extern void _ZN7S2071C12v1Ev();
extern void ABISELECT(_ZThn48_N7S2071C1D1Ev,_ZThn32_N7S2071C1D1Ev)();
extern void ABISELECT(_ZThn48_N7S2071C1D0Ev,_ZThn32_N7S2071C1D0Ev)();
static  VTBL_ENTRY vtc_S2071C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2071C1[0]),
  (VTBL_ENTRY)&_ZN7S2071C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2071C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2071C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2071C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2071C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN7S2071C22v7Ev,
  (VTBL_ENTRY)&_ZN7S2071C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2071C12v1Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S2071C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2071C1D1Ev,_ZThn32_N7S2071C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2071C1D0Ev,_ZThn32_N7S2071C1D0Ev),
};
extern VTBL_ENTRY _ZTI7S2071C1[];
extern  VTBL_ENTRY _ZTV7S2071C1[];
Class_Descriptor cd_S2071C1 = {  "S2071C1", // class name
  bases_S2071C1, 4,
  &(vtc_S2071C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,252), // object size
  NSPAIRA(_ZTI7S2071C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2071C1),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8191C10_nt  {
  int s8191c10f0;
  void  mf8191c10(); // _ZN11S8191C10_nt9mf8191c10Ev
};
//SIG(-1 S8191C10_nt) C1{ m Fi}


void  S8191C10_nt ::mf8191c10(){}

//skip512 S8191C10_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S8191C10_nt[];
VTBL_ENTRY *P__ZTI11S8191C10_nt = _ZTI11S8191C10_nt; 
Class_Descriptor cd_S8191C10_nt = {  "S8191C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI11S8191C10_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8191C3  {
  int s8191c3f0;
  void *s8191c3f1;
  int s8191c3f2;
  ::S17070C74_nt s8191c3f3;
  int s8191c3f4[2];
  ::S17070C30_nt s8191c3f5;
  ::S15755C83 s8191c3f6;
  void *s8191c3f7[4];
  ::S8191C10_nt s8191c3f8;
  ::S17070C17_nt s8191c3f9;
  int s8191c3f10[4];
  ::S17070C17_nt s8191c3f11;
  ::S17070C17_nt s8191c3f12;
  int s8191c3f13[4];
  void *s8191c3f14;
  int s8191c3f15[6];
  char s8191c3f16[4];
  int s8191c3f17[2];
  ::S15755C12_nt s8191c3f18;
  void *s8191c3f19;
  void  mf8191c3(); // _ZN7S8191C38mf8191c3Ev
};
//SIG(-1 S8191C3) C1{ m Fi Fp Fi FC2{ m Fp Fi FC3{ m}} Fi[2] FC4{ m Fp Fi[2] FC3} FC5{ m Fp Fi[2] FC3} Fp[4] FC6{ m Fi} FC7{ m FC8{ m FL[2]}} Fi[4] FC7 FC7 Fi[4] Fp Fi[6] Fc[4] Fi[2] FC9{ m Fp Fi[2] FC10{ m}} Fp}


void  S8191C3 ::mf8191c3(){}

static void Test_S8191C3()
{
  {
    init_simple_test("S8191C3");
    S8191C3 lv;
    check2(sizeof(lv), ABISELECT(296,224), "sizeof(S8191C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8191C3)");
    check_field_offset(lv, s8191c3f0, 0, "S8191C3.s8191c3f0");
    check_field_offset(lv, s8191c3f1, ABISELECT(8,4), "S8191C3.s8191c3f1");
    check_field_offset(lv, s8191c3f2, ABISELECT(16,8), "S8191C3.s8191c3f2");
    check_field_offset(lv, s8191c3f3, ABISELECT(24,12), "S8191C3.s8191c3f3");
    check_field_offset(lv, s8191c3f4, ABISELECT(40,24), "S8191C3.s8191c3f4");
    check_field_offset(lv, s8191c3f5, ABISELECT(48,32), "S8191C3.s8191c3f5");
    check_field_offset(lv, s8191c3f6, ABISELECT(72,48), "S8191C3.s8191c3f6");
    check_field_offset(lv, s8191c3f7, ABISELECT(96,64), "S8191C3.s8191c3f7");
    check_field_offset(lv, s8191c3f8, ABISELECT(128,80), "S8191C3.s8191c3f8");
    check_field_offset(lv, s8191c3f9, ABISELECT(136,84), "S8191C3.s8191c3f9");
    check_field_offset(lv, s8191c3f10, ABISELECT(152,100), "S8191C3.s8191c3f10");
    check_field_offset(lv, s8191c3f11, ABISELECT(168,116), "S8191C3.s8191c3f11");
    check_field_offset(lv, s8191c3f12, ABISELECT(184,132), "S8191C3.s8191c3f12");
    check_field_offset(lv, s8191c3f13, ABISELECT(200,148), "S8191C3.s8191c3f13");
    check_field_offset(lv, s8191c3f14, ABISELECT(216,164), "S8191C3.s8191c3f14");
    check_field_offset(lv, s8191c3f15, ABISELECT(224,168), "S8191C3.s8191c3f15");
    check_field_offset(lv, s8191c3f16, ABISELECT(248,192), "S8191C3.s8191c3f16");
    check_field_offset(lv, s8191c3f17, ABISELECT(252,196), "S8191C3.s8191c3f17");
    check_field_offset(lv, s8191c3f18, ABISELECT(264,204), "S8191C3.s8191c3f18");
    check_field_offset(lv, s8191c3f19, ABISELECT(288,220), "S8191C3.s8191c3f19");
  }
}
static Arrange_To_Call_Me vS8191C3(Test_S8191C3, "S8191C3", ABISELECT(296,224));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8191C15_nt  {
  void *s8191c15f0;
  int s8191c15f1[2];
  ::S17070C78 s8191c15f2;
  void  mf8191c15(); // _ZN11S8191C15_nt9mf8191c15Ev
};
//SIG(-1 S8191C15_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S8191C15_nt ::mf8191c15(){}

//skip512 S8191C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8191C2  {
  void *s8191c2f0[2];
  ::S8191C3 s8191c2f1;
  void *s8191c2f2[2];
  ::S8191C15_nt s8191c2f3;
  void  mf8191c2(); // _ZN7S8191C28mf8191c2Ev
  virtual  ~S8191C2(); // _ZN7S8191C2D1Ev
  S8191C2(); // tgen
};
//SIG(-1 S8191C2) C1{ vd m Fp[2] FC2{ m Fi Fp Fi FC3{ m Fp Fi FC4{ m}} Fi[2] FC5{ m Fp Fi[2] FC4} FC6{ m Fp Fi[2] FC4} Fp[4] FC7{ m Fi} FC8{ m FC9{ m FL[2]}} Fi[4] FC8 FC8 Fi[4] Fp Fi[6] Fc[4] Fi[2] FC10{ m Fp Fi[2] FC11{ m}} Fp} Fp[2] FC12{ m Fp Fi[2] FC11}}


void  S8191C2 ::mf8191c2(){}
 S8191C2 ::~S8191C2(){ note_dtor("S8191C2", this);}
S8191C2 ::S8191C2(){ note_ctor("S8191C2", this);} // tgen

static void Test_S8191C2()
{
  extern Class_Descriptor cd_S8191C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,66)];
    init_test(&cd_S8191C2, buf);
    S8191C2 *dp, &lv = *(dp=new (buf) S8191C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,260), "sizeof(S8191C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8191C2)");
    check_field_offset(lv, s8191c2f0, ABISELECT(8,4), "S8191C2.s8191c2f0");
    check_field_offset(lv, s8191c2f1, ABISELECT(24,12), "S8191C2.s8191c2f1");
    check_field_offset(lv, s8191c2f2, ABISELECT(320,236), "S8191C2.s8191c2f2");
    check_field_offset(lv, s8191c2f3, ABISELECT(336,244), "S8191C2.s8191c2f3");
    test_class_info(&lv, &cd_S8191C2);
    dp->~S8191C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8191C2(Test_S8191C2, "S8191C2", ABISELECT(360,260));

#else // __cplusplus

extern void _ZN7S8191C2C1Ev();
extern void _ZN7S8191C2D1Ev();
Name_Map name_map_S8191C2[] = {
  NSPAIR(_ZN7S8191C2C1Ev),
  NSPAIR(_ZN7S8191C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S8191C2[];
extern void _ZN7S8191C2D1Ev();
extern void _ZN7S8191C2D0Ev();
static  VTBL_ENTRY vtc_S8191C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8191C2[0]),
  (VTBL_ENTRY)&_ZN7S8191C2D1Ev,
  (VTBL_ENTRY)&_ZN7S8191C2D0Ev,
};
extern VTBL_ENTRY _ZTI7S8191C2[];
extern  VTBL_ENTRY _ZTV7S8191C2[];
Class_Descriptor cd_S8191C2 = {  "S8191C2", // class name
  0,0,//no base classes
  &(vtc_S8191C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,260), // object size
  NSPAIRA(_ZTI7S8191C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S8191C2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8191C17  {
  void *s8191c17f0;
  ::S2071C8_nt s8191c17f1;
  ::S2071C8_nt s8191c17f2;
  void *s8191c17f3;
};
//SIG(-1 S8191C17) C1{ Fp FC2{ m Fp Fi FC3{ m}} FC2 Fp}



static void Test_S8191C17()
{
  {
    init_simple_test("S8191C17");
    S8191C17 lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S8191C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8191C17)");
    check_field_offset(lv, s8191c17f0, 0, "S8191C17.s8191c17f0");
    check_field_offset(lv, s8191c17f1, ABISELECT(8,4), "S8191C17.s8191c17f1");
    check_field_offset(lv, s8191c17f2, ABISELECT(24,16), "S8191C17.s8191c17f2");
    check_field_offset(lv, s8191c17f3, ABISELECT(40,28), "S8191C17.s8191c17f3");
  }
}
static Arrange_To_Call_Me vS8191C17(Test_S8191C17, "S8191C17", ABISELECT(48,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8191C1  : S8191C2 {
  ::S8191C17 s8191c1f0;
  ~S8191C1(); // tgen
  S8191C1(); // tgen
};
//SIG(1 S8191C1) C1{ BC2{ vd m Fp[2] FC3{ m Fi Fp Fi FC4{ m Fp Fi FC5{ m}} Fi[2] FC6{ m Fp Fi[2] FC5} FC7{ m Fp Fi[2] FC5} Fp[4] FC8{ m Fi} FC9{ m FC10{ m FL[2]}} Fi[4] FC9 FC9 Fi[4] Fp Fi[6] Fc[4] Fi[2] FC11{ m Fp Fi[2] FC12{ m}} Fp} Fp[2] FC13{ m Fp Fi[2] FC12}} FC14{ Fp FC15{ m Fp Fi FC12} FC15 Fp}}


S8191C1 ::~S8191C1(){ note_dtor("S8191C1", this);} // tgen
S8191C1 ::S8191C1(){ note_ctor("S8191C1", this);} // tgen

static void Test_S8191C1()
{
  extern Class_Descriptor cd_S8191C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(52,74)];
    init_test(&cd_S8191C1, buf);
    S8191C1 *dp, &lv = *(dp=new (buf) S8191C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(408,292), "sizeof(S8191C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8191C1)");
    check_base_class_offset(lv, (S8191C2*), 0, "S8191C1");
    check_field_offset(lv, s8191c1f0, ABISELECT(360,260), "S8191C1.s8191c1f0");
    test_class_info(&lv, &cd_S8191C1);
    dp->~S8191C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8191C1(Test_S8191C1, "S8191C1", ABISELECT(408,292));

#else // __cplusplus

extern void _ZN7S8191C1C1Ev();
extern void _ZN7S8191C1D1Ev();
Name_Map name_map_S8191C1[] = {
  NSPAIR(_ZN7S8191C1C1Ev),
  NSPAIR(_ZN7S8191C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8191C2;
extern VTBL_ENTRY _ZTI7S8191C2[];
extern  VTBL_ENTRY _ZTV7S8191C2[];
static Base_Class bases_S8191C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8191C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8191C1[];
extern void _ZN7S8191C1D1Ev();
extern void _ZN7S8191C1D0Ev();
static  VTBL_ENTRY vtc_S8191C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8191C1[0]),
  (VTBL_ENTRY)&_ZN7S8191C1D1Ev,
  (VTBL_ENTRY)&_ZN7S8191C1D0Ev,
};
extern VTBL_ENTRY _ZTI7S8191C1[];
extern  VTBL_ENTRY _ZTV7S8191C1[];
Class_Descriptor cd_S8191C1 = {  "S8191C1", // class name
  bases_S8191C1, 1,
  &(vtc_S8191C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(408,292), // object size
  NSPAIRA(_ZTI7S8191C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8191C1),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2165C4  {
  ::S17070C74_nt s2165c4f0;
  int s2165c4f1[2];
  char s2165c4f2;
  virtual  ~S2165C4(); // _ZN7S2165C4D1Ev
  virtual void  v3(); // _ZN7S2165C42v3Ev
  virtual void  v4(); // _ZN7S2165C42v4Ev
  virtual void  v5(); // _ZN7S2165C42v5Ev
  S2165C4(); // tgen
};
//SIG(-1 S2165C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2165C4 ::~S2165C4(){ note_dtor("S2165C4", this);}
void  S2165C4 ::v3(){vfunc_called(this, "_ZN7S2165C42v3Ev");}
void  S2165C4 ::v4(){vfunc_called(this, "_ZN7S2165C42v4Ev");}
void  S2165C4 ::v5(){vfunc_called(this, "_ZN7S2165C42v5Ev");}
S2165C4 ::S2165C4(){ note_ctor("S2165C4", this);} // tgen

static void Test_S2165C4()
{
  extern Class_Descriptor cd_S2165C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2165C4, buf);
    S2165C4 *dp, &lv = *(dp=new (buf) S2165C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2165C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2165C4)");
    check_field_offset(lv, s2165c4f0, ABISELECT(8,4), "S2165C4.s2165c4f0");
    check_field_offset(lv, s2165c4f1, ABISELECT(24,16), "S2165C4.s2165c4f1");
    check_field_offset(lv, s2165c4f2, ABISELECT(32,24), "S2165C4.s2165c4f2");
    test_class_info(&lv, &cd_S2165C4);
    dp->~S2165C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2165C4(Test_S2165C4, "S2165C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2165C4C1Ev();
extern void _ZN7S2165C4D1Ev();
Name_Map name_map_S2165C4[] = {
  NSPAIR(_ZN7S2165C4C1Ev),
  NSPAIR(_ZN7S2165C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2165C4[];
extern void _ZN7S2165C4D1Ev();
extern void _ZN7S2165C4D0Ev();
extern void _ZN7S2165C42v3Ev();
extern void _ZN7S2165C42v4Ev();
extern void _ZN7S2165C42v5Ev();
static  VTBL_ENTRY vtc_S2165C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2165C4[0]),
  (VTBL_ENTRY)&_ZN7S2165C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2165C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v5Ev,
};
extern VTBL_ENTRY _ZTI7S2165C4[];
extern  VTBL_ENTRY _ZTV7S2165C4[];
Class_Descriptor cd_S2165C4 = {  "S2165C4", // class name
  0,0,//no base classes
  &(vtc_S2165C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2165C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2165C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2165C3  : S2165C4 {
  void *s2165c3f0;
  virtual void  v6(); // _ZN7S2165C32v6Ev
  virtual void  v7(); // _ZN7S2165C32v7Ev
  ~S2165C3(); // tgen
  S2165C3(); // tgen
};
//SIG(-1 S2165C3) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S2165C3 ::v6(){vfunc_called(this, "_ZN7S2165C32v6Ev");}
void  S2165C3 ::v7(){vfunc_called(this, "_ZN7S2165C32v7Ev");}
S2165C3 ::~S2165C3(){ note_dtor("S2165C3", this);} // tgen
S2165C3 ::S2165C3(){ note_ctor("S2165C3", this);} // tgen

static void Test_S2165C3()
{
  extern Class_Descriptor cd_S2165C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S2165C3, buf);
    S2165C3 *dp, &lv = *(dp=new (buf) S2165C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S2165C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2165C3)");
    check_base_class_offset(lv, (S2165C4*), 0, "S2165C3");
    check_field_offset(lv, s2165c3f0, ABISELECT(40,28), "S2165C3.s2165c3f0");
    test_class_info(&lv, &cd_S2165C3);
    dp->~S2165C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2165C3(Test_S2165C3, "S2165C3", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S2165C3C1Ev();
extern void _ZN7S2165C3D1Ev();
Name_Map name_map_S2165C3[] = {
  NSPAIR(_ZN7S2165C3C1Ev),
  NSPAIR(_ZN7S2165C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2165C4;
extern VTBL_ENTRY _ZTI7S2165C4[];
extern  VTBL_ENTRY _ZTV7S2165C4[];
static Base_Class bases_S2165C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2165C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2165C3[];
extern void _ZN7S2165C3D1Ev();
extern void _ZN7S2165C3D0Ev();
extern void _ZN7S2165C42v3Ev();
extern void _ZN7S2165C42v4Ev();
extern void _ZN7S2165C42v5Ev();
extern void _ZN7S2165C32v6Ev();
extern void _ZN7S2165C32v7Ev();
static  VTBL_ENTRY vtc_S2165C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2165C3[0]),
  (VTBL_ENTRY)&_ZN7S2165C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2165C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2165C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2165C32v7Ev,
};
extern VTBL_ENTRY _ZTI7S2165C3[];
extern  VTBL_ENTRY _ZTV7S2165C3[];
Class_Descriptor cd_S2165C3 = {  "S2165C3", // class name
  bases_S2165C3, 1,
  &(vtc_S2165C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S2165C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2165C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2165C10_nt  {
  int s2165c10f0[2];
  void  mf2165c10(); // _ZN11S2165C10_nt9mf2165c10Ev
};
//SIG(-1 S2165C10_nt) C1{ m Fi[2]}


void  S2165C10_nt ::mf2165c10(){}

//skip512 S2165C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2165C8_nt  {
  ::S17070C7_nt s2165c8f0;
  ::S2165C10_nt s2165c8f1;
  void  mf2165c8(); // _ZN10S2165C8_nt8mf2165c8Ev
};
//SIG(-1 S2165C8_nt) C1{ m FC2{ m Fi[2]} FC3{ m Fi[2]}}


void  S2165C8_nt ::mf2165c8(){}

//skip512 S2165C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2165C7_nt  {
  void *s2165c7f0[2];
  int s2165c7f1[2];
  void *s2165c7f2;
  __tsi64 s2165c7f3;
  void *s2165c7f4[9];
  short s2165c7f5;
  void *s2165c7f6[2];
  ::S2165C8_nt s2165c7f7;
  ::S2165C10_nt s2165c7f8;
  char s2165c7f9;
  int s2165c7f10[3];
  char s2165c7f11;
  int s2165c7f12[6];
  char s2165c7f13;
  void  mf2165c7(); // _ZN10S2165C7_nt8mf2165c7Ev
};
//SIG(-1 S2165C7_nt) C1{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC2{ m FC3{ m Fi[2]} FC4{ m Fi[2]}} FC4 Fc Fi[3] Fc Fi[6] Fc}


void  S2165C7_nt ::mf2165c7(){}

//skip512 S2165C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2165C2  : S2165C3 {
  void *s2165c2f0;
  ::S2165C7_nt s2165c2f1;
  void *s2165c2f2;
  int s2165c2f3;
  ::S17070C21_nt s2165c2f4;
  ::S17070C21_nt s2165c2f5;
  int s2165c2f6[2];
  virtual  ~S2165C2(); // _ZN7S2165C2D1Ev
  virtual void  v8(); // _ZN7S2165C22v8Ev
  S2165C2(); // tgen
};
//SIG(-1 S2165C2) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S2165C2 ::~S2165C2(){ note_dtor("S2165C2", this);}
void  S2165C2 ::v8(){vfunc_called(this, "_ZN7S2165C22v8Ev");}
S2165C2 ::S2165C2(){ note_ctor("S2165C2", this);} // tgen

static void Test_S2165C2()
{
  extern Class_Descriptor cd_S2165C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S2165C2, buf);
    S2165C2 *dp, &lv = *(dp=new (buf) S2165C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S2165C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2165C2)");
    check_base_class_offset(lv, (S2165C4*)(S2165C3*), 0, "S2165C2");
    check_base_class_offset(lv, (S2165C3*), 0, "S2165C2");
    check_field_offset(lv, s2165c2f0, ABISELECT(48,32), "S2165C2.s2165c2f0");
    check_field_offset(lv, s2165c2f1, ABISELECT(56,36), "S2165C2.s2165c2f1");
    check_field_offset(lv, s2165c2f2, ABISELECT(264,184), "S2165C2.s2165c2f2");
    check_field_offset(lv, s2165c2f3, ABISELECT(272,188), "S2165C2.s2165c2f3");
    check_field_offset(lv, s2165c2f4, ABISELECT(280,192), "S2165C2.s2165c2f4");
    check_field_offset(lv, s2165c2f5, ABISELECT(288,196), "S2165C2.s2165c2f5");
    check_field_offset(lv, s2165c2f6, ABISELECT(296,200), "S2165C2.s2165c2f6");
    test_class_info(&lv, &cd_S2165C2);
    dp->~S2165C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2165C2(Test_S2165C2, "S2165C2", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN7S2165C2C1Ev();
extern void _ZN7S2165C2D1Ev();
Name_Map name_map_S2165C2[] = {
  NSPAIR(_ZN7S2165C2C1Ev),
  NSPAIR(_ZN7S2165C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2165C4;
extern VTBL_ENTRY _ZTI7S2165C4[];
extern  VTBL_ENTRY _ZTV7S2165C4[];
extern Class_Descriptor cd_S2165C3;
extern VTBL_ENTRY _ZTI7S2165C3[];
extern  VTBL_ENTRY _ZTV7S2165C3[];
static Base_Class bases_S2165C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2165C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2165C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2165C2[];
extern void _ZN7S2165C2D1Ev();
extern void _ZN7S2165C2D0Ev();
extern void _ZN7S2165C42v3Ev();
extern void _ZN7S2165C42v4Ev();
extern void _ZN7S2165C42v5Ev();
extern void _ZN7S2165C32v6Ev();
extern void _ZN7S2165C32v7Ev();
extern void _ZN7S2165C22v8Ev();
static  VTBL_ENTRY vtc_S2165C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2165C2[0]),
  (VTBL_ENTRY)&_ZN7S2165C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2165C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2165C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2165C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2165C22v8Ev,
};
extern VTBL_ENTRY _ZTI7S2165C2[];
extern  VTBL_ENTRY _ZTV7S2165C2[];
Class_Descriptor cd_S2165C2 = {  "S2165C2", // class name
  bases_S2165C2, 2,
  &(vtc_S2165C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI7S2165C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2165C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2165C1  : S2165C2 {
  __tsi64 s2165c1f0;
  int s2165c1f1;
  __tsi64 s2165c1f2;
  ::S10371C8_nt s2165c1f3;
  void *s2165c1f4[2];
  int s2165c1f5[2];
  ::S17070C17_nt s2165c1f6;
  virtual  ~S2165C1(); // _ZN7S2165C1D1Ev
  virtual void  v1(); // _ZN7S2165C12v1Ev
  virtual void  v2(); // _ZN7S2165C12v2Ev
  S2165C1(); // tgen
};
//SIG(1 S2165C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v6 v7 Fp} vd v8 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} vd v1 v2 FL Fi FL FC12{ m FC13{ FL[4]}} Fp[2] Fi[2] FC14{ m FC15{ m FL[2]}}}


 S2165C1 ::~S2165C1(){ note_dtor("S2165C1", this);}
void  S2165C1 ::v1(){vfunc_called(this, "_ZN7S2165C12v1Ev");}
void  S2165C1 ::v2(){vfunc_called(this, "_ZN7S2165C12v2Ev");}
S2165C1 ::S2165C1(){ note_ctor("S2165C1", this);} // tgen

static void Test_S2165C1()
{
  extern Class_Descriptor cd_S2165C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,74)];
    init_test(&cd_S2165C1, buf);
    S2165C1 *dp, &lv = *(dp=new (buf) S2165C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,292), "sizeof(S2165C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2165C1)");
    check_base_class_offset(lv, (S2165C4*)(S2165C3*)(S2165C2*), 0, "S2165C1");
    check_base_class_offset(lv, (S2165C3*)(S2165C2*), 0, "S2165C1");
    check_base_class_offset(lv, (S2165C2*), 0, "S2165C1");
    check_field_offset(lv, s2165c1f0, ABISELECT(304,208), "S2165C1.s2165c1f0");
    check_field_offset(lv, s2165c1f1, ABISELECT(312,216), "S2165C1.s2165c1f1");
    check_field_offset(lv, s2165c1f2, ABISELECT(320,220), "S2165C1.s2165c1f2");
    check_field_offset(lv, s2165c1f3, ABISELECT(328,228), "S2165C1.s2165c1f3");
    check_field_offset(lv, s2165c1f4, ABISELECT(360,260), "S2165C1.s2165c1f4");
    check_field_offset(lv, s2165c1f5, ABISELECT(376,268), "S2165C1.s2165c1f5");
    check_field_offset(lv, s2165c1f6, ABISELECT(384,276), "S2165C1.s2165c1f6");
    test_class_info(&lv, &cd_S2165C1);
    dp->~S2165C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2165C1(Test_S2165C1, "S2165C1", ABISELECT(400,292));

#else // __cplusplus

extern void _ZN7S2165C1C1Ev();
extern void _ZN7S2165C1D1Ev();
Name_Map name_map_S2165C1[] = {
  NSPAIR(_ZN7S2165C1C1Ev),
  NSPAIR(_ZN7S2165C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2165C4;
extern VTBL_ENTRY _ZTI7S2165C4[];
extern  VTBL_ENTRY _ZTV7S2165C4[];
extern Class_Descriptor cd_S2165C3;
extern VTBL_ENTRY _ZTI7S2165C3[];
extern  VTBL_ENTRY _ZTV7S2165C3[];
extern Class_Descriptor cd_S2165C2;
extern VTBL_ENTRY _ZTI7S2165C2[];
extern  VTBL_ENTRY _ZTV7S2165C2[];
static Base_Class bases_S2165C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2165C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2165C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2165C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2165C1[];
extern void _ZN7S2165C1D1Ev();
extern void _ZN7S2165C1D0Ev();
extern void _ZN7S2165C42v3Ev();
extern void _ZN7S2165C42v4Ev();
extern void _ZN7S2165C42v5Ev();
extern void _ZN7S2165C32v6Ev();
extern void _ZN7S2165C32v7Ev();
extern void _ZN7S2165C22v8Ev();
extern void _ZN7S2165C12v1Ev();
extern void _ZN7S2165C12v2Ev();
static  VTBL_ENTRY vtc_S2165C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2165C1[0]),
  (VTBL_ENTRY)&_ZN7S2165C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2165C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2165C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2165C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2165C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2165C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2165C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2165C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2165C1[];
extern  VTBL_ENTRY _ZTV7S2165C1[];
Class_Descriptor cd_S2165C1 = {  "S2165C1", // class name
  bases_S2165C1, 3,
  &(vtc_S2165C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,292), // object size
  NSPAIRA(_ZTI7S2165C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2165C1),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2164C4  {
  ::S17070C74_nt s2164c4f0;
  int s2164c4f1[2];
  char s2164c4f2;
  virtual  ~S2164C4(); // _ZN7S2164C4D1Ev
  virtual void  v3(); // _ZN7S2164C42v3Ev
  virtual void  v4(); // _ZN7S2164C42v4Ev
  virtual void  v5(); // _ZN7S2164C42v5Ev
  S2164C4(); // tgen
};
//SIG(-1 S2164C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2164C4 ::~S2164C4(){ note_dtor("S2164C4", this);}
void  S2164C4 ::v3(){vfunc_called(this, "_ZN7S2164C42v3Ev");}
void  S2164C4 ::v4(){vfunc_called(this, "_ZN7S2164C42v4Ev");}
void  S2164C4 ::v5(){vfunc_called(this, "_ZN7S2164C42v5Ev");}
S2164C4 ::S2164C4(){ note_ctor("S2164C4", this);} // tgen

static void Test_S2164C4()
{
  extern Class_Descriptor cd_S2164C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2164C4, buf);
    S2164C4 *dp, &lv = *(dp=new (buf) S2164C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2164C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2164C4)");
    check_field_offset(lv, s2164c4f0, ABISELECT(8,4), "S2164C4.s2164c4f0");
    check_field_offset(lv, s2164c4f1, ABISELECT(24,16), "S2164C4.s2164c4f1");
    check_field_offset(lv, s2164c4f2, ABISELECT(32,24), "S2164C4.s2164c4f2");
    test_class_info(&lv, &cd_S2164C4);
    dp->~S2164C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2164C4(Test_S2164C4, "S2164C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2164C4C1Ev();
extern void _ZN7S2164C4D1Ev();
Name_Map name_map_S2164C4[] = {
  NSPAIR(_ZN7S2164C4C1Ev),
  NSPAIR(_ZN7S2164C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2164C4[];
extern void _ZN7S2164C4D1Ev();
extern void _ZN7S2164C4D0Ev();
extern void _ZN7S2164C42v3Ev();
extern void _ZN7S2164C42v4Ev();
extern void _ZN7S2164C42v5Ev();
static  VTBL_ENTRY vtc_S2164C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2164C4[0]),
  (VTBL_ENTRY)&_ZN7S2164C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2164C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v5Ev,
};
extern VTBL_ENTRY _ZTI7S2164C4[];
extern  VTBL_ENTRY _ZTV7S2164C4[];
Class_Descriptor cd_S2164C4 = {  "S2164C4", // class name
  0,0,//no base classes
  &(vtc_S2164C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2164C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2164C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2164C3  : S2164C4 {
  void *s2164c3f0;
  virtual void  v6(); // _ZN7S2164C32v6Ev
  virtual void  v7(); // _ZN7S2164C32v7Ev
  ~S2164C3(); // tgen
  S2164C3(); // tgen
};
//SIG(-1 S2164C3) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S2164C3 ::v6(){vfunc_called(this, "_ZN7S2164C32v6Ev");}
void  S2164C3 ::v7(){vfunc_called(this, "_ZN7S2164C32v7Ev");}
S2164C3 ::~S2164C3(){ note_dtor("S2164C3", this);} // tgen
S2164C3 ::S2164C3(){ note_ctor("S2164C3", this);} // tgen

static void Test_S2164C3()
{
  extern Class_Descriptor cd_S2164C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S2164C3, buf);
    S2164C3 *dp, &lv = *(dp=new (buf) S2164C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S2164C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2164C3)");
    check_base_class_offset(lv, (S2164C4*), 0, "S2164C3");
    check_field_offset(lv, s2164c3f0, ABISELECT(40,28), "S2164C3.s2164c3f0");
    test_class_info(&lv, &cd_S2164C3);
    dp->~S2164C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2164C3(Test_S2164C3, "S2164C3", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S2164C3C1Ev();
extern void _ZN7S2164C3D1Ev();
Name_Map name_map_S2164C3[] = {
  NSPAIR(_ZN7S2164C3C1Ev),
  NSPAIR(_ZN7S2164C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2164C4;
extern VTBL_ENTRY _ZTI7S2164C4[];
extern  VTBL_ENTRY _ZTV7S2164C4[];
static Base_Class bases_S2164C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2164C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2164C3[];
extern void _ZN7S2164C3D1Ev();
extern void _ZN7S2164C3D0Ev();
extern void _ZN7S2164C42v3Ev();
extern void _ZN7S2164C42v4Ev();
extern void _ZN7S2164C42v5Ev();
extern void _ZN7S2164C32v6Ev();
extern void _ZN7S2164C32v7Ev();
static  VTBL_ENTRY vtc_S2164C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2164C3[0]),
  (VTBL_ENTRY)&_ZN7S2164C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2164C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2164C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2164C32v7Ev,
};
extern VTBL_ENTRY _ZTI7S2164C3[];
extern  VTBL_ENTRY _ZTV7S2164C3[];
Class_Descriptor cd_S2164C3 = {  "S2164C3", // class name
  bases_S2164C3, 1,
  &(vtc_S2164C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S2164C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2164C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2164C2  : S2164C3 {
  void *s2164c2f0;
  ::S2165C7_nt s2164c2f1;
  void *s2164c2f2;
  int s2164c2f3;
  ::S17070C21_nt s2164c2f4;
  ::S17070C21_nt s2164c2f5;
  int s2164c2f6[2];
  virtual  ~S2164C2(); // _ZN7S2164C2D1Ev
  virtual void  v8(); // _ZN7S2164C22v8Ev
  S2164C2(); // tgen
};
//SIG(-1 S2164C2) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S2164C2 ::~S2164C2(){ note_dtor("S2164C2", this);}
void  S2164C2 ::v8(){vfunc_called(this, "_ZN7S2164C22v8Ev");}
S2164C2 ::S2164C2(){ note_ctor("S2164C2", this);} // tgen

static void Test_S2164C2()
{
  extern Class_Descriptor cd_S2164C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S2164C2, buf);
    S2164C2 *dp, &lv = *(dp=new (buf) S2164C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S2164C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2164C2)");
    check_base_class_offset(lv, (S2164C4*)(S2164C3*), 0, "S2164C2");
    check_base_class_offset(lv, (S2164C3*), 0, "S2164C2");
    check_field_offset(lv, s2164c2f0, ABISELECT(48,32), "S2164C2.s2164c2f0");
    check_field_offset(lv, s2164c2f1, ABISELECT(56,36), "S2164C2.s2164c2f1");
    check_field_offset(lv, s2164c2f2, ABISELECT(264,184), "S2164C2.s2164c2f2");
    check_field_offset(lv, s2164c2f3, ABISELECT(272,188), "S2164C2.s2164c2f3");
    check_field_offset(lv, s2164c2f4, ABISELECT(280,192), "S2164C2.s2164c2f4");
    check_field_offset(lv, s2164c2f5, ABISELECT(288,196), "S2164C2.s2164c2f5");
    check_field_offset(lv, s2164c2f6, ABISELECT(296,200), "S2164C2.s2164c2f6");
    test_class_info(&lv, &cd_S2164C2);
    dp->~S2164C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2164C2(Test_S2164C2, "S2164C2", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN7S2164C2C1Ev();
extern void _ZN7S2164C2D1Ev();
Name_Map name_map_S2164C2[] = {
  NSPAIR(_ZN7S2164C2C1Ev),
  NSPAIR(_ZN7S2164C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2164C4;
extern VTBL_ENTRY _ZTI7S2164C4[];
extern  VTBL_ENTRY _ZTV7S2164C4[];
extern Class_Descriptor cd_S2164C3;
extern VTBL_ENTRY _ZTI7S2164C3[];
extern  VTBL_ENTRY _ZTV7S2164C3[];
static Base_Class bases_S2164C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2164C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2164C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2164C2[];
extern void _ZN7S2164C2D1Ev();
extern void _ZN7S2164C2D0Ev();
extern void _ZN7S2164C42v3Ev();
extern void _ZN7S2164C42v4Ev();
extern void _ZN7S2164C42v5Ev();
extern void _ZN7S2164C32v6Ev();
extern void _ZN7S2164C32v7Ev();
extern void _ZN7S2164C22v8Ev();
static  VTBL_ENTRY vtc_S2164C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2164C2[0]),
  (VTBL_ENTRY)&_ZN7S2164C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2164C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2164C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2164C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2164C22v8Ev,
};
extern VTBL_ENTRY _ZTI7S2164C2[];
extern  VTBL_ENTRY _ZTV7S2164C2[];
Class_Descriptor cd_S2164C2 = {  "S2164C2", // class name
  bases_S2164C2, 2,
  &(vtc_S2164C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI7S2164C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2164C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2164C1  : S2164C2 {
  __tsi64 s2164c1f0;
  int s2164c1f1;
  __tsi64 s2164c1f2;
  ::S10370C8_nt s2164c1f3;
  void *s2164c1f4[2];
  int s2164c1f5[2];
  ::S17070C17_nt s2164c1f6;
  virtual  ~S2164C1(); // _ZN7S2164C1D1Ev
  virtual void  v1(); // _ZN7S2164C12v1Ev
  virtual void  v2(); // _ZN7S2164C12v2Ev
  S2164C1(); // tgen
};
//SIG(1 S2164C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v6 v7 Fp} vd v8 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} vd v1 v2 FL Fi FL FC12{ m FC13{ Fl[4]}} Fp[2] Fi[2] FC14{ m FC15{ m FL[2]}}}


 S2164C1 ::~S2164C1(){ note_dtor("S2164C1", this);}
void  S2164C1 ::v1(){vfunc_called(this, "_ZN7S2164C12v1Ev");}
void  S2164C1 ::v2(){vfunc_called(this, "_ZN7S2164C12v2Ev");}
S2164C1 ::S2164C1(){ note_ctor("S2164C1", this);} // tgen

static void Test_S2164C1()
{
  extern Class_Descriptor cd_S2164C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,70)];
    init_test(&cd_S2164C1, buf);
    S2164C1 *dp, &lv = *(dp=new (buf) S2164C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,276), "sizeof(S2164C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2164C1)");
    check_base_class_offset(lv, (S2164C4*)(S2164C3*)(S2164C2*), 0, "S2164C1");
    check_base_class_offset(lv, (S2164C3*)(S2164C2*), 0, "S2164C1");
    check_base_class_offset(lv, (S2164C2*), 0, "S2164C1");
    check_field_offset(lv, s2164c1f0, ABISELECT(304,208), "S2164C1.s2164c1f0");
    check_field_offset(lv, s2164c1f1, ABISELECT(312,216), "S2164C1.s2164c1f1");
    check_field_offset(lv, s2164c1f2, ABISELECT(320,220), "S2164C1.s2164c1f2");
    check_field_offset(lv, s2164c1f3, ABISELECT(328,228), "S2164C1.s2164c1f3");
    check_field_offset(lv, s2164c1f4, ABISELECT(360,244), "S2164C1.s2164c1f4");
    check_field_offset(lv, s2164c1f5, ABISELECT(376,252), "S2164C1.s2164c1f5");
    check_field_offset(lv, s2164c1f6, ABISELECT(384,260), "S2164C1.s2164c1f6");
    test_class_info(&lv, &cd_S2164C1);
    dp->~S2164C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2164C1(Test_S2164C1, "S2164C1", ABISELECT(400,276));

#else // __cplusplus

extern void _ZN7S2164C1C1Ev();
extern void _ZN7S2164C1D1Ev();
Name_Map name_map_S2164C1[] = {
  NSPAIR(_ZN7S2164C1C1Ev),
  NSPAIR(_ZN7S2164C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2164C4;
extern VTBL_ENTRY _ZTI7S2164C4[];
extern  VTBL_ENTRY _ZTV7S2164C4[];
extern Class_Descriptor cd_S2164C3;
extern VTBL_ENTRY _ZTI7S2164C3[];
extern  VTBL_ENTRY _ZTV7S2164C3[];
extern Class_Descriptor cd_S2164C2;
extern VTBL_ENTRY _ZTI7S2164C2[];
extern  VTBL_ENTRY _ZTV7S2164C2[];
static Base_Class bases_S2164C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2164C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2164C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2164C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2164C1[];
extern void _ZN7S2164C1D1Ev();
extern void _ZN7S2164C1D0Ev();
extern void _ZN7S2164C42v3Ev();
extern void _ZN7S2164C42v4Ev();
extern void _ZN7S2164C42v5Ev();
extern void _ZN7S2164C32v6Ev();
extern void _ZN7S2164C32v7Ev();
extern void _ZN7S2164C22v8Ev();
extern void _ZN7S2164C12v1Ev();
extern void _ZN7S2164C12v2Ev();
static  VTBL_ENTRY vtc_S2164C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2164C1[0]),
  (VTBL_ENTRY)&_ZN7S2164C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2164C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2164C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2164C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2164C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2164C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2164C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2164C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2164C1[];
extern  VTBL_ENTRY _ZTV7S2164C1[];
Class_Descriptor cd_S2164C1 = {  "S2164C1", // class name
  bases_S2164C1, 3,
  &(vtc_S2164C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,276), // object size
  NSPAIRA(_ZTI7S2164C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2164C1),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C5  {
  ::S17070C74_nt s909c5f0;
  int s909c5f1[2];
  char s909c5f2;
  virtual  ~S909C5(); // _ZN6S909C5D1Ev
  virtual void  v4(); // _ZN6S909C52v4Ev
  virtual void  v5(); // _ZN6S909C52v5Ev
  virtual void  v6(); // _ZN6S909C52v6Ev
  S909C5(); // tgen
};
//SIG(-1 S909C5) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S909C5 ::~S909C5(){ note_dtor("S909C5", this);}
void  S909C5 ::v4(){vfunc_called(this, "_ZN6S909C52v4Ev");}
void  S909C5 ::v5(){vfunc_called(this, "_ZN6S909C52v5Ev");}
void  S909C5 ::v6(){vfunc_called(this, "_ZN6S909C52v6Ev");}
S909C5 ::S909C5(){ note_ctor("S909C5", this);} // tgen

static void Test_S909C5()
{
  extern Class_Descriptor cd_S909C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S909C5, buf);
    S909C5 *dp, &lv = *(dp=new (buf) S909C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S909C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S909C5)");
    check_field_offset(lv, s909c5f0, ABISELECT(8,4), "S909C5.s909c5f0");
    check_field_offset(lv, s909c5f1, ABISELECT(24,16), "S909C5.s909c5f1");
    check_field_offset(lv, s909c5f2, ABISELECT(32,24), "S909C5.s909c5f2");
    test_class_info(&lv, &cd_S909C5);
    dp->~S909C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS909C5(Test_S909C5, "S909C5", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6S909C5C1Ev();
extern void _ZN6S909C5D1Ev();
Name_Map name_map_S909C5[] = {
  NSPAIR(_ZN6S909C5C1Ev),
  NSPAIR(_ZN6S909C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S909C5[];
extern void _ZN6S909C5D1Ev();
extern void _ZN6S909C5D0Ev();
extern void _ZN6S909C52v4Ev();
extern void _ZN6S909C52v5Ev();
extern void _ZN6S909C52v6Ev();
static  VTBL_ENTRY vtc_S909C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S909C5[0]),
  (VTBL_ENTRY)&_ZN6S909C5D1Ev,
  (VTBL_ENTRY)&_ZN6S909C5D0Ev,
  (VTBL_ENTRY)&_ZN6S909C52v4Ev,
  (VTBL_ENTRY)&_ZN6S909C52v5Ev,
  (VTBL_ENTRY)&_ZN6S909C52v6Ev,
};
extern VTBL_ENTRY _ZTI6S909C5[];
extern  VTBL_ENTRY _ZTV6S909C5[];
Class_Descriptor cd_S909C5 = {  "S909C5", // class name
  0,0,//no base classes
  &(vtc_S909C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6S909C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S909C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C4  : S909C5 {
  void *s909c4f0;
  virtual void  v7(); // _ZN6S909C42v7Ev
  virtual void  v8(); // _ZN6S909C42v8Ev
  ~S909C4(); // tgen
  S909C4(); // tgen
};
//SIG(-1 S909C4) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S909C4 ::v7(){vfunc_called(this, "_ZN6S909C42v7Ev");}
void  S909C4 ::v8(){vfunc_called(this, "_ZN6S909C42v8Ev");}
S909C4 ::~S909C4(){ note_dtor("S909C4", this);} // tgen
S909C4 ::S909C4(){ note_ctor("S909C4", this);} // tgen

static void Test_S909C4()
{
  extern Class_Descriptor cd_S909C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S909C4, buf);
    S909C4 *dp, &lv = *(dp=new (buf) S909C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S909C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S909C4)");
    check_base_class_offset(lv, (S909C5*), 0, "S909C4");
    check_field_offset(lv, s909c4f0, ABISELECT(40,28), "S909C4.s909c4f0");
    test_class_info(&lv, &cd_S909C4);
    dp->~S909C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS909C4(Test_S909C4, "S909C4", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S909C4C1Ev();
extern void _ZN6S909C4D1Ev();
Name_Map name_map_S909C4[] = {
  NSPAIR(_ZN6S909C4C1Ev),
  NSPAIR(_ZN6S909C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S909C5;
extern VTBL_ENTRY _ZTI6S909C5[];
extern  VTBL_ENTRY _ZTV6S909C5[];
static Base_Class bases_S909C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S909C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S909C4[];
extern void _ZN6S909C4D1Ev();
extern void _ZN6S909C4D0Ev();
extern void _ZN6S909C52v4Ev();
extern void _ZN6S909C52v5Ev();
extern void _ZN6S909C52v6Ev();
extern void _ZN6S909C42v7Ev();
extern void _ZN6S909C42v8Ev();
static  VTBL_ENTRY vtc_S909C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S909C4[0]),
  (VTBL_ENTRY)&_ZN6S909C4D1Ev,
  (VTBL_ENTRY)&_ZN6S909C4D0Ev,
  (VTBL_ENTRY)&_ZN6S909C52v4Ev,
  (VTBL_ENTRY)&_ZN6S909C52v5Ev,
  (VTBL_ENTRY)&_ZN6S909C52v6Ev,
  (VTBL_ENTRY)&_ZN6S909C42v7Ev,
  (VTBL_ENTRY)&_ZN6S909C42v8Ev,
};
extern VTBL_ENTRY _ZTI6S909C4[];
extern  VTBL_ENTRY _ZTV6S909C4[];
Class_Descriptor cd_S909C4 = {  "S909C4", // class name
  bases_S909C4, 1,
  &(vtc_S909C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S909C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S909C4),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C3  : S909C4 {
  void *s909c3f0;
  ::S2165C7_nt s909c3f1;
  void *s909c3f2;
  int s909c3f3;
  ::S17070C21_nt s909c3f4;
  ::S17070C21_nt s909c3f5;
  int s909c3f6[2];
  virtual  ~S909C3(); // _ZN6S909C3D1Ev
  virtual void  v9(); // _ZN6S909C32v9Ev
  S909C3(); // tgen
};
//SIG(-1 S909C3) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S909C3 ::~S909C3(){ note_dtor("S909C3", this);}
void  S909C3 ::v9(){vfunc_called(this, "_ZN6S909C32v9Ev");}
S909C3 ::S909C3(){ note_ctor("S909C3", this);} // tgen

static void Test_S909C3()
{
  extern Class_Descriptor cd_S909C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S909C3, buf);
    S909C3 *dp, &lv = *(dp=new (buf) S909C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S909C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S909C3)");
    check_base_class_offset(lv, (S909C5*)(S909C4*), 0, "S909C3");
    check_base_class_offset(lv, (S909C4*), 0, "S909C3");
    check_field_offset(lv, s909c3f0, ABISELECT(48,32), "S909C3.s909c3f0");
    check_field_offset(lv, s909c3f1, ABISELECT(56,36), "S909C3.s909c3f1");
    check_field_offset(lv, s909c3f2, ABISELECT(264,184), "S909C3.s909c3f2");
    check_field_offset(lv, s909c3f3, ABISELECT(272,188), "S909C3.s909c3f3");
    check_field_offset(lv, s909c3f4, ABISELECT(280,192), "S909C3.s909c3f4");
    check_field_offset(lv, s909c3f5, ABISELECT(288,196), "S909C3.s909c3f5");
    check_field_offset(lv, s909c3f6, ABISELECT(296,200), "S909C3.s909c3f6");
    test_class_info(&lv, &cd_S909C3);
    dp->~S909C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS909C3(Test_S909C3, "S909C3", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN6S909C3C1Ev();
extern void _ZN6S909C3D1Ev();
Name_Map name_map_S909C3[] = {
  NSPAIR(_ZN6S909C3C1Ev),
  NSPAIR(_ZN6S909C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S909C5;
extern VTBL_ENTRY _ZTI6S909C5[];
extern  VTBL_ENTRY _ZTV6S909C5[];
extern Class_Descriptor cd_S909C4;
extern VTBL_ENTRY _ZTI6S909C4[];
extern  VTBL_ENTRY _ZTV6S909C4[];
static Base_Class bases_S909C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S909C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S909C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S909C3[];
extern void _ZN6S909C3D1Ev();
extern void _ZN6S909C3D0Ev();
extern void _ZN6S909C52v4Ev();
extern void _ZN6S909C52v5Ev();
extern void _ZN6S909C52v6Ev();
extern void _ZN6S909C42v7Ev();
extern void _ZN6S909C42v8Ev();
extern void _ZN6S909C32v9Ev();
static  VTBL_ENTRY vtc_S909C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S909C3[0]),
  (VTBL_ENTRY)&_ZN6S909C3D1Ev,
  (VTBL_ENTRY)&_ZN6S909C3D0Ev,
  (VTBL_ENTRY)&_ZN6S909C52v4Ev,
  (VTBL_ENTRY)&_ZN6S909C52v5Ev,
  (VTBL_ENTRY)&_ZN6S909C52v6Ev,
  (VTBL_ENTRY)&_ZN6S909C42v7Ev,
  (VTBL_ENTRY)&_ZN6S909C42v8Ev,
  (VTBL_ENTRY)&_ZN6S909C32v9Ev,
};
extern VTBL_ENTRY _ZTI6S909C3[];
extern  VTBL_ENTRY _ZTV6S909C3[];
Class_Descriptor cd_S909C3 = {  "S909C3", // class name
  bases_S909C3, 2,
  &(vtc_S909C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI6S909C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S909C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C13_nt  {
  void *s909c13f0;
  void  mf909c13(); // _ZN10S909C13_nt8mf909c13Ev
};
//SIG(-1 S909C13_nt) C1{ m Fp}


void  S909C13_nt ::mf909c13(){}

//skip512 S909C13_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S909C13_nt[];
VTBL_ENTRY *P__ZTI10S909C13_nt = _ZTI10S909C13_nt; 
Class_Descriptor cd_S909C13_nt = {  "S909C13_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S909C13_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C2  : S909C3 {
  ::S909C13_nt s909c2f0;
  virtual void  v10(); // _ZN6S909C23v10Ev
  virtual void  v11(); // _ZN6S909C23v11Ev
  ~S909C2(); // tgen
  S909C2(); // tgen
};
//SIG(-1 S909C2) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v6 v7 Fp} vd v8 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} v1 v2 FC12{ m Fp}}


void  S909C2 ::v10(){vfunc_called(this, "_ZN6S909C23v10Ev");}
void  S909C2 ::v11(){vfunc_called(this, "_ZN6S909C23v11Ev");}
S909C2 ::~S909C2(){ note_dtor("S909C2", this);} // tgen
S909C2 ::S909C2(){ note_ctor("S909C2", this);} // tgen

static void Test_S909C2()
{
  extern Class_Descriptor cd_S909C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,54)];
    init_test(&cd_S909C2, buf);
    S909C2 *dp, &lv = *(dp=new (buf) S909C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,212), "sizeof(S909C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S909C2)");
    check_base_class_offset(lv, (S909C5*)(S909C4*)(S909C3*), 0, "S909C2");
    check_base_class_offset(lv, (S909C4*)(S909C3*), 0, "S909C2");
    check_base_class_offset(lv, (S909C3*), 0, "S909C2");
    check_field_offset(lv, s909c2f0, ABISELECT(304,208), "S909C2.s909c2f0");
    test_class_info(&lv, &cd_S909C2);
    dp->~S909C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS909C2(Test_S909C2, "S909C2", ABISELECT(312,212));

#else // __cplusplus

extern void _ZN6S909C2C1Ev();
extern void _ZN6S909C2D1Ev();
Name_Map name_map_S909C2[] = {
  NSPAIR(_ZN6S909C2C1Ev),
  NSPAIR(_ZN6S909C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S909C5;
extern VTBL_ENTRY _ZTI6S909C5[];
extern  VTBL_ENTRY _ZTV6S909C5[];
extern Class_Descriptor cd_S909C4;
extern VTBL_ENTRY _ZTI6S909C4[];
extern  VTBL_ENTRY _ZTV6S909C4[];
extern Class_Descriptor cd_S909C3;
extern VTBL_ENTRY _ZTI6S909C3[];
extern  VTBL_ENTRY _ZTV6S909C3[];
static Base_Class bases_S909C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S909C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S909C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S909C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S909C2[];
extern void _ZN6S909C2D1Ev();
extern void _ZN6S909C2D0Ev();
extern void _ZN6S909C52v4Ev();
extern void _ZN6S909C52v5Ev();
extern void _ZN6S909C52v6Ev();
extern void _ZN6S909C42v7Ev();
extern void _ZN6S909C42v8Ev();
extern void _ZN6S909C32v9Ev();
extern void _ZN6S909C23v10Ev();
extern void _ZN6S909C23v11Ev();
static  VTBL_ENTRY vtc_S909C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S909C2[0]),
  (VTBL_ENTRY)&_ZN6S909C2D1Ev,
  (VTBL_ENTRY)&_ZN6S909C2D0Ev,
  (VTBL_ENTRY)&_ZN6S909C52v4Ev,
  (VTBL_ENTRY)&_ZN6S909C52v5Ev,
  (VTBL_ENTRY)&_ZN6S909C52v6Ev,
  (VTBL_ENTRY)&_ZN6S909C42v7Ev,
  (VTBL_ENTRY)&_ZN6S909C42v8Ev,
  (VTBL_ENTRY)&_ZN6S909C32v9Ev,
  (VTBL_ENTRY)&_ZN6S909C23v10Ev,
  (VTBL_ENTRY)&_ZN6S909C23v11Ev,
};
extern VTBL_ENTRY _ZTI6S909C2[];
extern  VTBL_ENTRY _ZTV6S909C2[];
Class_Descriptor cd_S909C2 = {  "S909C2", // class name
  bases_S909C2, 3,
  &(vtc_S909C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,212), // object size
  NSPAIRA(_ZTI6S909C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S909C2),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C15_nt  {
  int s909c15f0[4];
  void  mf909c15(); // _ZN10S909C15_nt8mf909c15Ev
};
//SIG(-1 S909C15_nt) C1{ m Fi[4]}


void  S909C15_nt ::mf909c15(){}

//skip512 S909C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C14  {
  __tsi64 s909c14f0;
  ::S909C15_nt s909c14f1;
  void  mf909c14(); // _ZN7S909C148mf909c14Ev
};
//SIG(-1 S909C14) C1{ m FL FC2{ m Fi[4]}}


void  S909C14 ::mf909c14(){}

static void Test_S909C14()
{
  {
    init_simple_test("S909C14");
    S909C14 lv;
    check2(sizeof(lv), 24, "sizeof(S909C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S909C14)");
    check_field_offset(lv, s909c14f0, 0, "S909C14.s909c14f0");
    check_field_offset(lv, s909c14f1, 8, "S909C14.s909c14f1");
  }
}
static Arrange_To_Call_Me vS909C14(Test_S909C14, "S909C14", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S909C1  : S909C2 {
  ::S909C14 s909c1f0;
  void *s909c1f1;
  int s909c1f2;
  virtual  ~S909C1(); // _ZN6S909C1D1Ev
  virtual void  v1(); // _ZN6S909C12v1Ev
  virtual void  v2(); // _ZN6S909C12v2Ev
  virtual void  v3(); // _ZN6S909C12v3Ev
  S909C1(); // tgen
};
//SIG(1 S909C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 FC6{ m Fp Fi FC7{ m}} Fi[2] Fc} v7 v8 Fp} vd v9 Fp FC8{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC9{ m FC10{ m Fi[2]} FC11{ m Fi[2]}} FC11 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC12{ m Fp} FC12 Fi[2]} v10 v11 FC13{ m Fp}} vd v1 v2 v3 FC14{ m FL FC15{ m Fi[4]}} Fp Fi}


 S909C1 ::~S909C1(){ note_dtor("S909C1", this);}
void  S909C1 ::v1(){vfunc_called(this, "_ZN6S909C12v1Ev");}
void  S909C1 ::v2(){vfunc_called(this, "_ZN6S909C12v2Ev");}
void  S909C1 ::v3(){vfunc_called(this, "_ZN6S909C12v3Ev");}
S909C1 ::S909C1(){ note_ctor("S909C1", this);} // tgen

static void Test_S909C1()
{
  extern Class_Descriptor cd_S909C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,62)];
    init_test(&cd_S909C1, buf);
    S909C1 *dp, &lv = *(dp=new (buf) S909C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,244), "sizeof(S909C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S909C1)");
    check_base_class_offset(lv, (S909C5*)(S909C4*)(S909C3*)(S909C2*), 0, "S909C1");
    check_base_class_offset(lv, (S909C4*)(S909C3*)(S909C2*), 0, "S909C1");
    check_base_class_offset(lv, (S909C3*)(S909C2*), 0, "S909C1");
    check_base_class_offset(lv, (S909C2*), 0, "S909C1");
    check_field_offset(lv, s909c1f0, ABISELECT(312,212), "S909C1.s909c1f0");
    check_field_offset(lv, s909c1f1, ABISELECT(336,236), "S909C1.s909c1f1");
    check_field_offset(lv, s909c1f2, ABISELECT(344,240), "S909C1.s909c1f2");
    test_class_info(&lv, &cd_S909C1);
    dp->~S909C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS909C1(Test_S909C1, "S909C1", ABISELECT(352,244));

#else // __cplusplus

extern void _ZN6S909C1C1Ev();
extern void _ZN6S909C1D1Ev();
Name_Map name_map_S909C1[] = {
  NSPAIR(_ZN6S909C1C1Ev),
  NSPAIR(_ZN6S909C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S909C5;
extern VTBL_ENTRY _ZTI6S909C5[];
extern  VTBL_ENTRY _ZTV6S909C5[];
extern Class_Descriptor cd_S909C4;
extern VTBL_ENTRY _ZTI6S909C4[];
extern  VTBL_ENTRY _ZTV6S909C4[];
extern Class_Descriptor cd_S909C3;
extern VTBL_ENTRY _ZTI6S909C3[];
extern  VTBL_ENTRY _ZTV6S909C3[];
extern Class_Descriptor cd_S909C2;
extern VTBL_ENTRY _ZTI6S909C2[];
extern  VTBL_ENTRY _ZTV6S909C2[];
static Base_Class bases_S909C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S909C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S909C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S909C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S909C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S909C1[];
extern void _ZN6S909C1D1Ev();
extern void _ZN6S909C1D0Ev();
extern void _ZN6S909C52v4Ev();
extern void _ZN6S909C52v5Ev();
extern void _ZN6S909C52v6Ev();
extern void _ZN6S909C42v7Ev();
extern void _ZN6S909C42v8Ev();
extern void _ZN6S909C32v9Ev();
extern void _ZN6S909C23v10Ev();
extern void _ZN6S909C23v11Ev();
extern void _ZN6S909C12v1Ev();
extern void _ZN6S909C12v2Ev();
extern void _ZN6S909C12v3Ev();
static  VTBL_ENTRY vtc_S909C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S909C1[0]),
  (VTBL_ENTRY)&_ZN6S909C1D1Ev,
  (VTBL_ENTRY)&_ZN6S909C1D0Ev,
  (VTBL_ENTRY)&_ZN6S909C52v4Ev,
  (VTBL_ENTRY)&_ZN6S909C52v5Ev,
  (VTBL_ENTRY)&_ZN6S909C52v6Ev,
  (VTBL_ENTRY)&_ZN6S909C42v7Ev,
  (VTBL_ENTRY)&_ZN6S909C42v8Ev,
  (VTBL_ENTRY)&_ZN6S909C32v9Ev,
  (VTBL_ENTRY)&_ZN6S909C23v10Ev,
  (VTBL_ENTRY)&_ZN6S909C23v11Ev,
  (VTBL_ENTRY)&_ZN6S909C12v1Ev,
  (VTBL_ENTRY)&_ZN6S909C12v2Ev,
  (VTBL_ENTRY)&_ZN6S909C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S909C1[];
extern  VTBL_ENTRY _ZTV6S909C1[];
Class_Descriptor cd_S909C1 = {  "S909C1", // class name
  bases_S909C1, 4,
  &(vtc_S909C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,244), // object size
  NSPAIRA(_ZTI6S909C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S909C1),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2166C4  {
  ::S17070C74_nt s2166c4f0;
  int s2166c4f1[2];
  char s2166c4f2;
  virtual  ~S2166C4(); // _ZN7S2166C4D1Ev
  virtual void  v3(); // _ZN7S2166C42v3Ev
  virtual void  v4(); // _ZN7S2166C42v4Ev
  virtual void  v5(); // _ZN7S2166C42v5Ev
  S2166C4(); // tgen
};
//SIG(-1 S2166C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2166C4 ::~S2166C4(){ note_dtor("S2166C4", this);}
void  S2166C4 ::v3(){vfunc_called(this, "_ZN7S2166C42v3Ev");}
void  S2166C4 ::v4(){vfunc_called(this, "_ZN7S2166C42v4Ev");}
void  S2166C4 ::v5(){vfunc_called(this, "_ZN7S2166C42v5Ev");}
S2166C4 ::S2166C4(){ note_ctor("S2166C4", this);} // tgen

static void Test_S2166C4()
{
  extern Class_Descriptor cd_S2166C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2166C4, buf);
    S2166C4 *dp, &lv = *(dp=new (buf) S2166C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2166C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2166C4)");
    check_field_offset(lv, s2166c4f0, ABISELECT(8,4), "S2166C4.s2166c4f0");
    check_field_offset(lv, s2166c4f1, ABISELECT(24,16), "S2166C4.s2166c4f1");
    check_field_offset(lv, s2166c4f2, ABISELECT(32,24), "S2166C4.s2166c4f2");
    test_class_info(&lv, &cd_S2166C4);
    dp->~S2166C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2166C4(Test_S2166C4, "S2166C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2166C4C1Ev();
extern void _ZN7S2166C4D1Ev();
Name_Map name_map_S2166C4[] = {
  NSPAIR(_ZN7S2166C4C1Ev),
  NSPAIR(_ZN7S2166C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2166C4[];
extern void _ZN7S2166C4D1Ev();
extern void _ZN7S2166C4D0Ev();
extern void _ZN7S2166C42v3Ev();
extern void _ZN7S2166C42v4Ev();
extern void _ZN7S2166C42v5Ev();
static  VTBL_ENTRY vtc_S2166C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2166C4[0]),
  (VTBL_ENTRY)&_ZN7S2166C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2166C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v5Ev,
};
extern VTBL_ENTRY _ZTI7S2166C4[];
extern  VTBL_ENTRY _ZTV7S2166C4[];
Class_Descriptor cd_S2166C4 = {  "S2166C4", // class name
  0,0,//no base classes
  &(vtc_S2166C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2166C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2166C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2166C3  : S2166C4 {
  void *s2166c3f0;
  virtual void  v6(); // _ZN7S2166C32v6Ev
  virtual void  v7(); // _ZN7S2166C32v7Ev
  ~S2166C3(); // tgen
  S2166C3(); // tgen
};
//SIG(-1 S2166C3) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S2166C3 ::v6(){vfunc_called(this, "_ZN7S2166C32v6Ev");}
void  S2166C3 ::v7(){vfunc_called(this, "_ZN7S2166C32v7Ev");}
S2166C3 ::~S2166C3(){ note_dtor("S2166C3", this);} // tgen
S2166C3 ::S2166C3(){ note_ctor("S2166C3", this);} // tgen

static void Test_S2166C3()
{
  extern Class_Descriptor cd_S2166C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S2166C3, buf);
    S2166C3 *dp, &lv = *(dp=new (buf) S2166C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S2166C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2166C3)");
    check_base_class_offset(lv, (S2166C4*), 0, "S2166C3");
    check_field_offset(lv, s2166c3f0, ABISELECT(40,28), "S2166C3.s2166c3f0");
    test_class_info(&lv, &cd_S2166C3);
    dp->~S2166C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2166C3(Test_S2166C3, "S2166C3", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S2166C3C1Ev();
extern void _ZN7S2166C3D1Ev();
Name_Map name_map_S2166C3[] = {
  NSPAIR(_ZN7S2166C3C1Ev),
  NSPAIR(_ZN7S2166C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2166C4;
extern VTBL_ENTRY _ZTI7S2166C4[];
extern  VTBL_ENTRY _ZTV7S2166C4[];
static Base_Class bases_S2166C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2166C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2166C3[];
extern void _ZN7S2166C3D1Ev();
extern void _ZN7S2166C3D0Ev();
extern void _ZN7S2166C42v3Ev();
extern void _ZN7S2166C42v4Ev();
extern void _ZN7S2166C42v5Ev();
extern void _ZN7S2166C32v6Ev();
extern void _ZN7S2166C32v7Ev();
static  VTBL_ENTRY vtc_S2166C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2166C3[0]),
  (VTBL_ENTRY)&_ZN7S2166C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2166C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2166C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2166C32v7Ev,
};
extern VTBL_ENTRY _ZTI7S2166C3[];
extern  VTBL_ENTRY _ZTV7S2166C3[];
Class_Descriptor cd_S2166C3 = {  "S2166C3", // class name
  bases_S2166C3, 1,
  &(vtc_S2166C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S2166C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2166C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2166C2  : S2166C3 {
  void *s2166c2f0;
  ::S2165C7_nt s2166c2f1;
  void *s2166c2f2;
  int s2166c2f3;
  ::S17070C21_nt s2166c2f4;
  ::S17070C21_nt s2166c2f5;
  int s2166c2f6[2];
  virtual  ~S2166C2(); // _ZN7S2166C2D1Ev
  virtual void  v8(); // _ZN7S2166C22v8Ev
  S2166C2(); // tgen
};
//SIG(-1 S2166C2) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S2166C2 ::~S2166C2(){ note_dtor("S2166C2", this);}
void  S2166C2 ::v8(){vfunc_called(this, "_ZN7S2166C22v8Ev");}
S2166C2 ::S2166C2(){ note_ctor("S2166C2", this);} // tgen

static void Test_S2166C2()
{
  extern Class_Descriptor cd_S2166C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S2166C2, buf);
    S2166C2 *dp, &lv = *(dp=new (buf) S2166C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S2166C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2166C2)");
    check_base_class_offset(lv, (S2166C4*)(S2166C3*), 0, "S2166C2");
    check_base_class_offset(lv, (S2166C3*), 0, "S2166C2");
    check_field_offset(lv, s2166c2f0, ABISELECT(48,32), "S2166C2.s2166c2f0");
    check_field_offset(lv, s2166c2f1, ABISELECT(56,36), "S2166C2.s2166c2f1");
    check_field_offset(lv, s2166c2f2, ABISELECT(264,184), "S2166C2.s2166c2f2");
    check_field_offset(lv, s2166c2f3, ABISELECT(272,188), "S2166C2.s2166c2f3");
    check_field_offset(lv, s2166c2f4, ABISELECT(280,192), "S2166C2.s2166c2f4");
    check_field_offset(lv, s2166c2f5, ABISELECT(288,196), "S2166C2.s2166c2f5");
    check_field_offset(lv, s2166c2f6, ABISELECT(296,200), "S2166C2.s2166c2f6");
    test_class_info(&lv, &cd_S2166C2);
    dp->~S2166C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2166C2(Test_S2166C2, "S2166C2", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN7S2166C2C1Ev();
extern void _ZN7S2166C2D1Ev();
Name_Map name_map_S2166C2[] = {
  NSPAIR(_ZN7S2166C2C1Ev),
  NSPAIR(_ZN7S2166C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2166C4;
extern VTBL_ENTRY _ZTI7S2166C4[];
extern  VTBL_ENTRY _ZTV7S2166C4[];
extern Class_Descriptor cd_S2166C3;
extern VTBL_ENTRY _ZTI7S2166C3[];
extern  VTBL_ENTRY _ZTV7S2166C3[];
static Base_Class bases_S2166C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2166C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2166C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2166C2[];
extern void _ZN7S2166C2D1Ev();
extern void _ZN7S2166C2D0Ev();
extern void _ZN7S2166C42v3Ev();
extern void _ZN7S2166C42v4Ev();
extern void _ZN7S2166C42v5Ev();
extern void _ZN7S2166C32v6Ev();
extern void _ZN7S2166C32v7Ev();
extern void _ZN7S2166C22v8Ev();
static  VTBL_ENTRY vtc_S2166C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2166C2[0]),
  (VTBL_ENTRY)&_ZN7S2166C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2166C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2166C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2166C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2166C22v8Ev,
};
extern VTBL_ENTRY _ZTI7S2166C2[];
extern  VTBL_ENTRY _ZTV7S2166C2[];
Class_Descriptor cd_S2166C2 = {  "S2166C2", // class name
  bases_S2166C2, 2,
  &(vtc_S2166C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI7S2166C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2166C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2166C1  : S2166C2 {
  __tsi64 s2166c1f0;
  int s2166c1f1;
  __tsi64 s2166c1f2;
  ::S10372C8_nt s2166c1f3;
  void *s2166c1f4[2];
  int s2166c1f5[2];
  ::S17070C17_nt s2166c1f6;
  virtual  ~S2166C1(); // _ZN7S2166C1D1Ev
  virtual void  v1(); // _ZN7S2166C12v1Ev
  virtual void  v2(); // _ZN7S2166C12v2Ev
  S2166C1(); // tgen
};
//SIG(1 S2166C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v6 v7 Fp} vd v8 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} vd v1 v2 FL Fi FL FC12{ m FL[4]} Fp[2] Fi[2] FC13{ m FC14{ m FL[2]}}}


 S2166C1 ::~S2166C1(){ note_dtor("S2166C1", this);}
void  S2166C1 ::v1(){vfunc_called(this, "_ZN7S2166C12v1Ev");}
void  S2166C1 ::v2(){vfunc_called(this, "_ZN7S2166C12v2Ev");}
S2166C1 ::S2166C1(){ note_ctor("S2166C1", this);} // tgen

static void Test_S2166C1()
{
  extern Class_Descriptor cd_S2166C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,74)];
    init_test(&cd_S2166C1, buf);
    S2166C1 *dp, &lv = *(dp=new (buf) S2166C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,292), "sizeof(S2166C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2166C1)");
    check_base_class_offset(lv, (S2166C4*)(S2166C3*)(S2166C2*), 0, "S2166C1");
    check_base_class_offset(lv, (S2166C3*)(S2166C2*), 0, "S2166C1");
    check_base_class_offset(lv, (S2166C2*), 0, "S2166C1");
    check_field_offset(lv, s2166c1f0, ABISELECT(304,208), "S2166C1.s2166c1f0");
    check_field_offset(lv, s2166c1f1, ABISELECT(312,216), "S2166C1.s2166c1f1");
    check_field_offset(lv, s2166c1f2, ABISELECT(320,220), "S2166C1.s2166c1f2");
    check_field_offset(lv, s2166c1f3, ABISELECT(328,228), "S2166C1.s2166c1f3");
    check_field_offset(lv, s2166c1f4, ABISELECT(360,260), "S2166C1.s2166c1f4");
    check_field_offset(lv, s2166c1f5, ABISELECT(376,268), "S2166C1.s2166c1f5");
    check_field_offset(lv, s2166c1f6, ABISELECT(384,276), "S2166C1.s2166c1f6");
    test_class_info(&lv, &cd_S2166C1);
    dp->~S2166C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2166C1(Test_S2166C1, "S2166C1", ABISELECT(400,292));

#else // __cplusplus

extern void _ZN7S2166C1C1Ev();
extern void _ZN7S2166C1D1Ev();
Name_Map name_map_S2166C1[] = {
  NSPAIR(_ZN7S2166C1C1Ev),
  NSPAIR(_ZN7S2166C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2166C4;
extern VTBL_ENTRY _ZTI7S2166C4[];
extern  VTBL_ENTRY _ZTV7S2166C4[];
extern Class_Descriptor cd_S2166C3;
extern VTBL_ENTRY _ZTI7S2166C3[];
extern  VTBL_ENTRY _ZTV7S2166C3[];
extern Class_Descriptor cd_S2166C2;
extern VTBL_ENTRY _ZTI7S2166C2[];
extern  VTBL_ENTRY _ZTV7S2166C2[];
static Base_Class bases_S2166C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2166C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2166C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2166C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2166C1[];
extern void _ZN7S2166C1D1Ev();
extern void _ZN7S2166C1D0Ev();
extern void _ZN7S2166C42v3Ev();
extern void _ZN7S2166C42v4Ev();
extern void _ZN7S2166C42v5Ev();
extern void _ZN7S2166C32v6Ev();
extern void _ZN7S2166C32v7Ev();
extern void _ZN7S2166C22v8Ev();
extern void _ZN7S2166C12v1Ev();
extern void _ZN7S2166C12v2Ev();
static  VTBL_ENTRY vtc_S2166C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2166C1[0]),
  (VTBL_ENTRY)&_ZN7S2166C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2166C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2166C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2166C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2166C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2166C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2166C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2166C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2166C1[];
extern  VTBL_ENTRY _ZTV7S2166C1[];
Class_Descriptor cd_S2166C1 = {  "S2166C1", // class name
  bases_S2166C1, 3,
  &(vtc_S2166C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,292), // object size
  NSPAIRA(_ZTI7S2166C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2166C1),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8192C17_nt  {
  void *s8192c17f0[4];
};
//SIG(-1 S8192C17_nt) C1{ Fp[4]}



//skip512 S8192C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8192C1  : S8191C2 {
  ::S8192C17_nt s8192c1f0;
  ~S8192C1(); // tgen
  S8192C1(); // tgen
};
//SIG(1 S8192C1) C1{ BC2{ vd m Fp[2] FC3{ m Fi Fp Fi FC4{ m Fp Fi FC5{ m}} Fi[2] FC6{ m Fp Fi[2] FC5} FC7{ m Fp Fi[2] FC5} Fp[4] FC8{ m Fi} FC9{ m FC10{ m FL[2]}} Fi[4] FC9 FC9 Fi[4] Fp Fi[6] Fc[4] Fi[2] FC11{ m Fp Fi[2] FC12{ m}} Fp} Fp[2] FC13{ m Fp Fi[2] FC12}} FC14{ Fp[4]}}


S8192C1 ::~S8192C1(){ note_dtor("S8192C1", this);} // tgen
S8192C1 ::S8192C1(){ note_ctor("S8192C1", this);} // tgen

static void Test_S8192C1()
{
  extern Class_Descriptor cd_S8192C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,70)];
    init_test(&cd_S8192C1, buf);
    S8192C1 *dp, &lv = *(dp=new (buf) S8192C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,276), "sizeof(S8192C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8192C1)");
    check_base_class_offset(lv, (S8191C2*), 0, "S8192C1");
    check_field_offset(lv, s8192c1f0, ABISELECT(360,260), "S8192C1.s8192c1f0");
    test_class_info(&lv, &cd_S8192C1);
    dp->~S8192C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8192C1(Test_S8192C1, "S8192C1", ABISELECT(392,276));

#else // __cplusplus

extern void _ZN7S8192C1C1Ev();
extern void _ZN7S8192C1D1Ev();
Name_Map name_map_S8192C1[] = {
  NSPAIR(_ZN7S8192C1C1Ev),
  NSPAIR(_ZN7S8192C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8191C2;
extern VTBL_ENTRY _ZTI7S8191C2[];
extern  VTBL_ENTRY _ZTV7S8191C2[];
static Base_Class bases_S8192C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8191C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8192C1[];
extern void _ZN7S8192C1D1Ev();
extern void _ZN7S8192C1D0Ev();
static  VTBL_ENTRY vtc_S8192C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8192C1[0]),
  (VTBL_ENTRY)&_ZN7S8192C1D1Ev,
  (VTBL_ENTRY)&_ZN7S8192C1D0Ev,
};
extern VTBL_ENTRY _ZTI7S8192C1[];
extern  VTBL_ENTRY _ZTV7S8192C1[];
Class_Descriptor cd_S8192C1 = {  "S8192C1", // class name
  bases_S8192C1, 1,
  &(vtc_S8192C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,276), // object size
  NSPAIRA(_ZTI7S8192C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8192C1),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2236C4  {
  ::S17070C74_nt s2236c4f0;
  int s2236c4f1[2];
  char s2236c4f2;
  virtual  ~S2236C4(); // _ZN7S2236C4D1Ev
  virtual void  v4(); // _ZN7S2236C42v4Ev
  virtual void  v5(); // _ZN7S2236C42v5Ev
  virtual void  v6(); // _ZN7S2236C42v6Ev
  S2236C4(); // tgen
};
//SIG(-1 S2236C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2236C4 ::~S2236C4(){ note_dtor("S2236C4", this);}
void  S2236C4 ::v4(){vfunc_called(this, "_ZN7S2236C42v4Ev");}
void  S2236C4 ::v5(){vfunc_called(this, "_ZN7S2236C42v5Ev");}
void  S2236C4 ::v6(){vfunc_called(this, "_ZN7S2236C42v6Ev");}
S2236C4 ::S2236C4(){ note_ctor("S2236C4", this);} // tgen

static void Test_S2236C4()
{
  extern Class_Descriptor cd_S2236C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2236C4, buf);
    S2236C4 *dp, &lv = *(dp=new (buf) S2236C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2236C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2236C4)");
    check_field_offset(lv, s2236c4f0, ABISELECT(8,4), "S2236C4.s2236c4f0");
    check_field_offset(lv, s2236c4f1, ABISELECT(24,16), "S2236C4.s2236c4f1");
    check_field_offset(lv, s2236c4f2, ABISELECT(32,24), "S2236C4.s2236c4f2");
    test_class_info(&lv, &cd_S2236C4);
    dp->~S2236C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2236C4(Test_S2236C4, "S2236C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2236C4C1Ev();
extern void _ZN7S2236C4D1Ev();
Name_Map name_map_S2236C4[] = {
  NSPAIR(_ZN7S2236C4C1Ev),
  NSPAIR(_ZN7S2236C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2236C4[];
extern void _ZN7S2236C4D1Ev();
extern void _ZN7S2236C4D0Ev();
extern void _ZN7S2236C42v4Ev();
extern void _ZN7S2236C42v5Ev();
extern void _ZN7S2236C42v6Ev();
static  VTBL_ENTRY vtc_S2236C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2236C4[0]),
  (VTBL_ENTRY)&_ZN7S2236C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2236C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v6Ev,
};
extern VTBL_ENTRY _ZTI7S2236C4[];
extern  VTBL_ENTRY _ZTV7S2236C4[];
Class_Descriptor cd_S2236C4 = {  "S2236C4", // class name
  0,0,//no base classes
  &(vtc_S2236C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2236C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2236C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2236C3  : S2236C4 {
  void *s2236c3f0;
  virtual void  v7(); // _ZN7S2236C32v7Ev
  virtual void  v8(); // _ZN7S2236C32v8Ev
  ~S2236C3(); // tgen
  S2236C3(); // tgen
};
//SIG(-1 S2236C3) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S2236C3 ::v7(){vfunc_called(this, "_ZN7S2236C32v7Ev");}
void  S2236C3 ::v8(){vfunc_called(this, "_ZN7S2236C32v8Ev");}
S2236C3 ::~S2236C3(){ note_dtor("S2236C3", this);} // tgen
S2236C3 ::S2236C3(){ note_ctor("S2236C3", this);} // tgen

static void Test_S2236C3()
{
  extern Class_Descriptor cd_S2236C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S2236C3, buf);
    S2236C3 *dp, &lv = *(dp=new (buf) S2236C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S2236C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2236C3)");
    check_base_class_offset(lv, (S2236C4*), 0, "S2236C3");
    check_field_offset(lv, s2236c3f0, ABISELECT(40,28), "S2236C3.s2236c3f0");
    test_class_info(&lv, &cd_S2236C3);
    dp->~S2236C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2236C3(Test_S2236C3, "S2236C3", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S2236C3C1Ev();
extern void _ZN7S2236C3D1Ev();
Name_Map name_map_S2236C3[] = {
  NSPAIR(_ZN7S2236C3C1Ev),
  NSPAIR(_ZN7S2236C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2236C4;
extern VTBL_ENTRY _ZTI7S2236C4[];
extern  VTBL_ENTRY _ZTV7S2236C4[];
static Base_Class bases_S2236C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2236C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2236C3[];
extern void _ZN7S2236C3D1Ev();
extern void _ZN7S2236C3D0Ev();
extern void _ZN7S2236C42v4Ev();
extern void _ZN7S2236C42v5Ev();
extern void _ZN7S2236C42v6Ev();
extern void _ZN7S2236C32v7Ev();
extern void _ZN7S2236C32v8Ev();
static  VTBL_ENTRY vtc_S2236C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2236C3[0]),
  (VTBL_ENTRY)&_ZN7S2236C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2236C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2236C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2236C32v8Ev,
};
extern VTBL_ENTRY _ZTI7S2236C3[];
extern  VTBL_ENTRY _ZTV7S2236C3[];
Class_Descriptor cd_S2236C3 = {  "S2236C3", // class name
  bases_S2236C3, 1,
  &(vtc_S2236C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S2236C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2236C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2236C2  : S2236C3 , S2071C7 {
  virtual  ~S2236C2(); // _ZN7S2236C2D1Ev
  virtual void  v9(); // _ZN7S2236C22v9Ev
  virtual void  v10(); // _ZN7S2236C23v10Ev
  S2236C2(); // tgen
};
//SIG(-1 S2236C2) C1{ BC2{ BC3{ vd v3 v4 v5 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v6 v7 Fp} BC6{ vd m Fi Fp FC7{ m Fp Fi FC8{ m}} Fp Fi} vd v1 v2}


 S2236C2 ::~S2236C2(){ note_dtor("S2236C2", this);}
void  S2236C2 ::v9(){vfunc_called(this, "_ZN7S2236C22v9Ev");}
void  S2236C2 ::v10(){vfunc_called(this, "_ZN7S2236C23v10Ev");}
S2236C2 ::S2236C2(){ note_ctor("S2236C2", this);} // tgen

static void Test_S2236C2()
{
  extern Class_Descriptor cd_S2236C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S2236C2, buf);
    S2236C2 *dp, &lv = *(dp=new (buf) S2236C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S2236C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2236C2)");
    check_base_class_offset(lv, (S2236C4*)(S2236C3*), 0, "S2236C2");
    check_base_class_offset(lv, (S2236C3*), 0, "S2236C2");
    check_base_class_offset(lv, (S2071C7*), ABISELECT(48,32), "S2236C2");
    test_class_info(&lv, &cd_S2236C2);
    dp->~S2236C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2236C2(Test_S2236C2, "S2236C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S2236C2C1Ev();
extern void _ZN7S2236C2D1Ev();
Name_Map name_map_S2236C2[] = {
  NSPAIR(_ZN7S2236C2C1Ev),
  NSPAIR(_ZN7S2236C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2236C4;
extern VTBL_ENTRY _ZTI7S2236C4[];
extern  VTBL_ENTRY _ZTV7S2236C4[];
extern Class_Descriptor cd_S2236C3;
extern VTBL_ENTRY _ZTI7S2236C3[];
extern  VTBL_ENTRY _ZTV7S2236C3[];
extern Class_Descriptor cd_S2071C7;
extern VTBL_ENTRY _ZTI7S2071C7[];
extern  VTBL_ENTRY _ZTV7S2071C7[];
static Base_Class bases_S2236C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2236C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2236C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2071C7,    ABISELECT(48,32), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2236C2[];
extern void _ZN7S2236C2D1Ev();
extern void _ZN7S2236C2D0Ev();
extern void _ZN7S2236C42v4Ev();
extern void _ZN7S2236C42v5Ev();
extern void _ZN7S2236C42v6Ev();
extern void _ZN7S2236C32v7Ev();
extern void _ZN7S2236C32v8Ev();
extern void _ZN7S2236C22v9Ev();
extern void _ZN7S2236C23v10Ev();
extern void ABISELECT(_ZThn48_N7S2236C2D1Ev,_ZThn32_N7S2236C2D1Ev)();
extern void ABISELECT(_ZThn48_N7S2236C2D0Ev,_ZThn32_N7S2236C2D0Ev)();
static  VTBL_ENTRY vtc_S2236C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2236C2[0]),
  (VTBL_ENTRY)&_ZN7S2236C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2236C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2236C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2236C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2236C22v9Ev,
  (VTBL_ENTRY)&_ZN7S2236C23v10Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S2236C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2236C2D1Ev,_ZThn32_N7S2236C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2236C2D0Ev,_ZThn32_N7S2236C2D0Ev),
};
extern VTBL_ENTRY _ZTI7S2236C2[];
extern  VTBL_ENTRY _ZTV7S2236C2[];
Class_Descriptor cd_S2236C2 = {  "S2236C2", // class name
  bases_S2236C2, 3,
  &(vtc_S2236C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S2236C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2236C2),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2236C10  {
  ::S17070C74_nt s2236c10f0;
  ::S17070C74_nt s2236c10f1;
  ::S17070C74_nt s2236c10f2;
  ::S17070C74_nt s2236c10f3;
  ::S17070C74_nt s2236c10f4;
  ::S17070C30_nt s2236c10f5;
  int s2236c10f6;
  ::S15755C83 s2236c10f7;
  int s2236c10f8[2];
  void  mf2236c10(); // _ZN8S2236C109mf2236c10Ev
  virtual  ~S2236C10(); // _ZN8S2236C10D1Ev
  S2236C10(); // tgen
};
//SIG(-1 S2236C10) C1{ vd m FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC2 FC2 FC4{ m Fp Fi[2] FC3} Fi FC5{ m Fp Fi[2] FC3} Fi[2]}


void  S2236C10 ::mf2236c10(){}
 S2236C10 ::~S2236C10(){ note_dtor("S2236C10", this);}
S2236C10 ::S2236C10(){ note_ctor("S2236C10", this);} // tgen

static void Test_S2236C10()
{
  extern Class_Descriptor cd_S2236C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,28)];
    init_test(&cd_S2236C10, buf);
    S2236C10 *dp, &lv = *(dp=new (buf) S2236C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,108), "sizeof(S2236C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2236C10)");
    check_field_offset(lv, s2236c10f0, ABISELECT(8,4), "S2236C10.s2236c10f0");
    check_field_offset(lv, s2236c10f1, ABISELECT(24,16), "S2236C10.s2236c10f1");
    check_field_offset(lv, s2236c10f2, ABISELECT(40,28), "S2236C10.s2236c10f2");
    check_field_offset(lv, s2236c10f3, ABISELECT(56,40), "S2236C10.s2236c10f3");
    check_field_offset(lv, s2236c10f4, ABISELECT(72,52), "S2236C10.s2236c10f4");
    check_field_offset(lv, s2236c10f5, ABISELECT(88,64), "S2236C10.s2236c10f5");
    check_field_offset(lv, s2236c10f6, ABISELECT(112,80), "S2236C10.s2236c10f6");
    check_field_offset(lv, s2236c10f7, ABISELECT(120,84), "S2236C10.s2236c10f7");
    check_field_offset(lv, s2236c10f8, ABISELECT(144,100), "S2236C10.s2236c10f8");
    test_class_info(&lv, &cd_S2236C10);
    dp->~S2236C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2236C10(Test_S2236C10, "S2236C10", ABISELECT(152,108));

#else // __cplusplus

extern void _ZN8S2236C10C1Ev();
extern void _ZN8S2236C10D1Ev();
Name_Map name_map_S2236C10[] = {
  NSPAIR(_ZN8S2236C10C1Ev),
  NSPAIR(_ZN8S2236C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2236C10[];
extern void _ZN8S2236C10D1Ev();
extern void _ZN8S2236C10D0Ev();
static  VTBL_ENTRY vtc_S2236C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2236C10[0]),
  (VTBL_ENTRY)&_ZN8S2236C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2236C10D0Ev,
};
extern VTBL_ENTRY _ZTI8S2236C10[];
extern  VTBL_ENTRY _ZTV8S2236C10[];
Class_Descriptor cd_S2236C10 = {  "S2236C10", // class name
  0,0,//no base classes
  &(vtc_S2236C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,108), // object size
  NSPAIRA(_ZTI8S2236C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2236C10),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2236C15_nt  {
  int s2236c15f0[4];
  void  mf2236c15(); // _ZN11S2236C15_nt9mf2236c15Ev
  virtual  ~S2236C15_nt(); // _ZN11S2236C15_ntD1Ev
  S2236C15_nt(); // tgen
};
//SIG(-1 S2236C15_nt) C1{ vd m Fi[4]}


void  S2236C15_nt ::mf2236c15(){}
 S2236C15_nt ::~S2236C15_nt(){ note_dtor("S2236C15_nt", this);}
S2236C15_nt ::S2236C15_nt(){ note_ctor("S2236C15_nt", this);} // tgen

//skip512 S2236C15_nt

#else // __cplusplus

extern void _ZN11S2236C15_ntC1Ev();
extern void _ZN11S2236C15_ntD1Ev();
Name_Map name_map_S2236C15_nt[] = {
  NSPAIR(_ZN11S2236C15_ntC1Ev),
  NSPAIR(_ZN11S2236C15_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S2236C15_nt[];
extern void _ZN11S2236C15_ntD1Ev();
extern void _ZN11S2236C15_ntD0Ev();
static  VTBL_ENTRY vtc_S2236C15_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S2236C15_nt[0]),
  (VTBL_ENTRY)&_ZN11S2236C15_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S2236C15_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S2236C15_nt[];
VTBL_ENTRY *P__ZTI11S2236C15_nt = _ZTI11S2236C15_nt; 
extern  VTBL_ENTRY _ZTV11S2236C15_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2236C1  : S2236C2 {
  int s2236c1f0[2];
  ::S2236C10 s2236c1f1;
  int s2236c1f2;
  ::S2236C15_nt s2236c1f3;
  ::S17070C74_nt s2236c1f4;
  ::S17070C74_nt s2236c1f5;
  ::S17070C74_nt s2236c1f6;
  virtual  ~S2236C1(); // _ZN7S2236C1D1Ev
  virtual void  v1(); // _ZN7S2236C12v1Ev
  virtual void  v2(); // _ZN7S2236C12v2Ev
  virtual void  v3(); // _ZN7S2236C12v3Ev
  S2236C1(); // tgen
};
//SIG(1 S2236C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v7 v8 Fp} BC7{ vd m Fi Fp FC8{ m Fp Fi FC9{ m}} Fp Fi} vd v9 v10} vd v1 v2 v3 Fi[2] FC10{ vd m FC5 FC5 FC5 FC5 FC5 FC11{ m Fp Fi[2] FC6} Fi FC12{ m Fp Fi[2] FC6} Fi[2]} Fi FC13{ vd m Fi[4]} FC5 FC5 FC5}


 S2236C1 ::~S2236C1(){ note_dtor("S2236C1", this);}
void  S2236C1 ::v1(){vfunc_called(this, "_ZN7S2236C12v1Ev");}
void  S2236C1 ::v2(){vfunc_called(this, "_ZN7S2236C12v2Ev");}
void  S2236C1 ::v3(){vfunc_called(this, "_ZN7S2236C12v3Ev");}
S2236C1 ::S2236C1(){ note_ctor("S2236C1", this);} // tgen

static void Test_S2236C1()
{
  extern Class_Descriptor cd_S2236C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,61)];
    init_test(&cd_S2236C1, buf);
    S2236C1 *dp, &lv = *(dp=new (buf) S2236C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,240), "sizeof(S2236C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2236C1)");
    check_base_class_offset(lv, (S2236C4*)(S2236C3*)(S2236C2*), 0, "S2236C1");
    check_base_class_offset(lv, (S2236C3*)(S2236C2*), 0, "S2236C1");
    check_base_class_offset(lv, (S2071C7*)(S2236C2*), ABISELECT(48,32), "S2236C1");
    check_base_class_offset(lv, (S2236C2*), 0, "S2236C1");
    check_field_offset(lv, s2236c1f0, ABISELECT(100,64), "S2236C1.s2236c1f0");
    check_field_offset(lv, s2236c1f1, ABISELECT(112,72), "S2236C1.s2236c1f1");
    check_field_offset(lv, s2236c1f2, ABISELECT(264,180), "S2236C1.s2236c1f2");
    check_field_offset(lv, s2236c1f3, ABISELECT(272,184), "S2236C1.s2236c1f3");
    check_field_offset(lv, s2236c1f4, ABISELECT(296,204), "S2236C1.s2236c1f4");
    check_field_offset(lv, s2236c1f5, ABISELECT(312,216), "S2236C1.s2236c1f5");
    check_field_offset(lv, s2236c1f6, ABISELECT(328,228), "S2236C1.s2236c1f6");
    test_class_info(&lv, &cd_S2236C1);
    dp->~S2236C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2236C1(Test_S2236C1, "S2236C1", ABISELECT(344,240));

#else // __cplusplus

extern void _ZN7S2236C1C1Ev();
extern void _ZN7S2236C1D1Ev();
Name_Map name_map_S2236C1[] = {
  NSPAIR(_ZN7S2236C1C1Ev),
  NSPAIR(_ZN7S2236C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2236C4;
extern VTBL_ENTRY _ZTI7S2236C4[];
extern  VTBL_ENTRY _ZTV7S2236C4[];
extern Class_Descriptor cd_S2236C3;
extern VTBL_ENTRY _ZTI7S2236C3[];
extern  VTBL_ENTRY _ZTV7S2236C3[];
extern Class_Descriptor cd_S2071C7;
extern VTBL_ENTRY _ZTI7S2071C7[];
extern  VTBL_ENTRY _ZTV7S2071C7[];
extern Class_Descriptor cd_S2236C2;
extern VTBL_ENTRY _ZTI7S2236C2[];
extern  VTBL_ENTRY _ZTV7S2236C2[];
static Base_Class bases_S2236C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2236C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2236C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2071C7,    ABISELECT(48,32), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2236C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2236C1[];
extern void _ZN7S2236C1D1Ev();
extern void _ZN7S2236C1D0Ev();
extern void _ZN7S2236C42v4Ev();
extern void _ZN7S2236C42v5Ev();
extern void _ZN7S2236C42v6Ev();
extern void _ZN7S2236C32v7Ev();
extern void _ZN7S2236C32v8Ev();
extern void _ZN7S2236C22v9Ev();
extern void _ZN7S2236C23v10Ev();
extern void _ZN7S2236C12v1Ev();
extern void _ZN7S2236C12v2Ev();
extern void _ZN7S2236C12v3Ev();
extern void ABISELECT(_ZThn48_N7S2236C1D1Ev,_ZThn32_N7S2236C1D1Ev)();
extern void ABISELECT(_ZThn48_N7S2236C1D0Ev,_ZThn32_N7S2236C1D0Ev)();
static  VTBL_ENTRY vtc_S2236C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2236C1[0]),
  (VTBL_ENTRY)&_ZN7S2236C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2236C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2236C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2236C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2236C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2236C22v9Ev,
  (VTBL_ENTRY)&_ZN7S2236C23v10Ev,
  (VTBL_ENTRY)&_ZN7S2236C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2236C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2236C12v3Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S2236C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2236C1D1Ev,_ZThn32_N7S2236C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2236C1D0Ev,_ZThn32_N7S2236C1D0Ev),
};
extern VTBL_ENTRY _ZTI7S2236C1[];
extern  VTBL_ENTRY _ZTV7S2236C1[];
Class_Descriptor cd_S2236C1 = {  "S2236C1", // class name
  bases_S2236C1, 4,
  &(vtc_S2236C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(344,240), // object size
  NSPAIRA(_ZTI7S2236C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2236C1),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S868C5  {
  ::S17070C74_nt s868c5f0;
  int s868c5f1[2];
  char s868c5f2;
  virtual  ~S868C5(); // _ZN6S868C5D1Ev
  virtual void  v2(); // _ZN6S868C52v2Ev
  virtual void  v3(); // _ZN6S868C52v3Ev
  virtual void  v4(); // _ZN6S868C52v4Ev
  S868C5(); // tgen
};
//SIG(-1 S868C5) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S868C5 ::~S868C5(){ note_dtor("S868C5", this);}
void  S868C5 ::v2(){vfunc_called(this, "_ZN6S868C52v2Ev");}
void  S868C5 ::v3(){vfunc_called(this, "_ZN6S868C52v3Ev");}
void  S868C5 ::v4(){vfunc_called(this, "_ZN6S868C52v4Ev");}
S868C5 ::S868C5(){ note_ctor("S868C5", this);} // tgen

static void Test_S868C5()
{
  extern Class_Descriptor cd_S868C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S868C5, buf);
    S868C5 *dp, &lv = *(dp=new (buf) S868C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S868C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S868C5)");
    check_field_offset(lv, s868c5f0, ABISELECT(8,4), "S868C5.s868c5f0");
    check_field_offset(lv, s868c5f1, ABISELECT(24,16), "S868C5.s868c5f1");
    check_field_offset(lv, s868c5f2, ABISELECT(32,24), "S868C5.s868c5f2");
    test_class_info(&lv, &cd_S868C5);
    dp->~S868C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS868C5(Test_S868C5, "S868C5", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6S868C5C1Ev();
extern void _ZN6S868C5D1Ev();
Name_Map name_map_S868C5[] = {
  NSPAIR(_ZN6S868C5C1Ev),
  NSPAIR(_ZN6S868C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S868C5[];
extern void _ZN6S868C5D1Ev();
extern void _ZN6S868C5D0Ev();
extern void _ZN6S868C52v2Ev();
extern void _ZN6S868C52v3Ev();
extern void _ZN6S868C52v4Ev();
static  VTBL_ENTRY vtc_S868C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S868C5[0]),
  (VTBL_ENTRY)&_ZN6S868C5D1Ev,
  (VTBL_ENTRY)&_ZN6S868C5D0Ev,
  (VTBL_ENTRY)&_ZN6S868C52v2Ev,
  (VTBL_ENTRY)&_ZN6S868C52v3Ev,
  (VTBL_ENTRY)&_ZN6S868C52v4Ev,
};
extern VTBL_ENTRY _ZTI6S868C5[];
extern  VTBL_ENTRY _ZTV6S868C5[];
Class_Descriptor cd_S868C5 = {  "S868C5", // class name
  0,0,//no base classes
  &(vtc_S868C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6S868C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S868C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S868C4  : S868C5 {
  void *s868c4f0;
  virtual void  v5(); // _ZN6S868C42v5Ev
  virtual void  v6(); // _ZN6S868C42v6Ev
  ~S868C4(); // tgen
  S868C4(); // tgen
};
//SIG(-1 S868C4) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S868C4 ::v5(){vfunc_called(this, "_ZN6S868C42v5Ev");}
void  S868C4 ::v6(){vfunc_called(this, "_ZN6S868C42v6Ev");}
S868C4 ::~S868C4(){ note_dtor("S868C4", this);} // tgen
S868C4 ::S868C4(){ note_ctor("S868C4", this);} // tgen

static void Test_S868C4()
{
  extern Class_Descriptor cd_S868C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S868C4, buf);
    S868C4 *dp, &lv = *(dp=new (buf) S868C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S868C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S868C4)");
    check_base_class_offset(lv, (S868C5*), 0, "S868C4");
    check_field_offset(lv, s868c4f0, ABISELECT(40,28), "S868C4.s868c4f0");
    test_class_info(&lv, &cd_S868C4);
    dp->~S868C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS868C4(Test_S868C4, "S868C4", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S868C4C1Ev();
extern void _ZN6S868C4D1Ev();
Name_Map name_map_S868C4[] = {
  NSPAIR(_ZN6S868C4C1Ev),
  NSPAIR(_ZN6S868C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S868C5;
extern VTBL_ENTRY _ZTI6S868C5[];
extern  VTBL_ENTRY _ZTV6S868C5[];
static Base_Class bases_S868C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S868C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S868C4[];
extern void _ZN6S868C4D1Ev();
extern void _ZN6S868C4D0Ev();
extern void _ZN6S868C52v2Ev();
extern void _ZN6S868C52v3Ev();
extern void _ZN6S868C52v4Ev();
extern void _ZN6S868C42v5Ev();
extern void _ZN6S868C42v6Ev();
static  VTBL_ENTRY vtc_S868C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S868C4[0]),
  (VTBL_ENTRY)&_ZN6S868C4D1Ev,
  (VTBL_ENTRY)&_ZN6S868C4D0Ev,
  (VTBL_ENTRY)&_ZN6S868C52v2Ev,
  (VTBL_ENTRY)&_ZN6S868C52v3Ev,
  (VTBL_ENTRY)&_ZN6S868C52v4Ev,
  (VTBL_ENTRY)&_ZN6S868C42v5Ev,
  (VTBL_ENTRY)&_ZN6S868C42v6Ev,
};
extern VTBL_ENTRY _ZTI6S868C4[];
extern  VTBL_ENTRY _ZTV6S868C4[];
Class_Descriptor cd_S868C4 = {  "S868C4", // class name
  bases_S868C4, 1,
  &(vtc_S868C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S868C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S868C4),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S868C3  : S868C4 {
  void *s868c3f0;
  ::S2165C7_nt s868c3f1;
  void *s868c3f2;
  int s868c3f3;
  ::S17070C21_nt s868c3f4;
  ::S17070C21_nt s868c3f5;
  int s868c3f6[2];
  virtual  ~S868C3(); // _ZN6S868C3D1Ev
  virtual void  v7(); // _ZN6S868C32v7Ev
  S868C3(); // tgen
};
//SIG(-1 S868C3) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S868C3 ::~S868C3(){ note_dtor("S868C3", this);}
void  S868C3 ::v7(){vfunc_called(this, "_ZN6S868C32v7Ev");}
S868C3 ::S868C3(){ note_ctor("S868C3", this);} // tgen

static void Test_S868C3()
{
  extern Class_Descriptor cd_S868C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S868C3, buf);
    S868C3 *dp, &lv = *(dp=new (buf) S868C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S868C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S868C3)");
    check_base_class_offset(lv, (S868C5*)(S868C4*), 0, "S868C3");
    check_base_class_offset(lv, (S868C4*), 0, "S868C3");
    check_field_offset(lv, s868c3f0, ABISELECT(48,32), "S868C3.s868c3f0");
    check_field_offset(lv, s868c3f1, ABISELECT(56,36), "S868C3.s868c3f1");
    check_field_offset(lv, s868c3f2, ABISELECT(264,184), "S868C3.s868c3f2");
    check_field_offset(lv, s868c3f3, ABISELECT(272,188), "S868C3.s868c3f3");
    check_field_offset(lv, s868c3f4, ABISELECT(280,192), "S868C3.s868c3f4");
    check_field_offset(lv, s868c3f5, ABISELECT(288,196), "S868C3.s868c3f5");
    check_field_offset(lv, s868c3f6, ABISELECT(296,200), "S868C3.s868c3f6");
    test_class_info(&lv, &cd_S868C3);
    dp->~S868C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS868C3(Test_S868C3, "S868C3", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN6S868C3C1Ev();
extern void _ZN6S868C3D1Ev();
Name_Map name_map_S868C3[] = {
  NSPAIR(_ZN6S868C3C1Ev),
  NSPAIR(_ZN6S868C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S868C5;
extern VTBL_ENTRY _ZTI6S868C5[];
extern  VTBL_ENTRY _ZTV6S868C5[];
extern Class_Descriptor cd_S868C4;
extern VTBL_ENTRY _ZTI6S868C4[];
extern  VTBL_ENTRY _ZTV6S868C4[];
static Base_Class bases_S868C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S868C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S868C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S868C3[];
extern void _ZN6S868C3D1Ev();
extern void _ZN6S868C3D0Ev();
extern void _ZN6S868C52v2Ev();
extern void _ZN6S868C52v3Ev();
extern void _ZN6S868C52v4Ev();
extern void _ZN6S868C42v5Ev();
extern void _ZN6S868C42v6Ev();
extern void _ZN6S868C32v7Ev();
static  VTBL_ENTRY vtc_S868C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S868C3[0]),
  (VTBL_ENTRY)&_ZN6S868C3D1Ev,
  (VTBL_ENTRY)&_ZN6S868C3D0Ev,
  (VTBL_ENTRY)&_ZN6S868C52v2Ev,
  (VTBL_ENTRY)&_ZN6S868C52v3Ev,
  (VTBL_ENTRY)&_ZN6S868C52v4Ev,
  (VTBL_ENTRY)&_ZN6S868C42v5Ev,
  (VTBL_ENTRY)&_ZN6S868C42v6Ev,
  (VTBL_ENTRY)&_ZN6S868C32v7Ev,
};
extern VTBL_ENTRY _ZTI6S868C3[];
extern  VTBL_ENTRY _ZTV6S868C3[];
Class_Descriptor cd_S868C3 = {  "S868C3", // class name
  bases_S868C3, 2,
  &(vtc_S868C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI6S868C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S868C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S868C2  : S868C3 {
  ::S909C13_nt s868c2f0;
  virtual void  v8(); // _ZN6S868C22v8Ev
  virtual void  v9(); // _ZN6S868C22v9Ev
  ~S868C2(); // tgen
  S868C2(); // tgen
};
//SIG(-1 S868C2) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v6 v7 Fp} vd v8 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} v1 v2 FC12{ m Fp}}


void  S868C2 ::v8(){vfunc_called(this, "_ZN6S868C22v8Ev");}
void  S868C2 ::v9(){vfunc_called(this, "_ZN6S868C22v9Ev");}
S868C2 ::~S868C2(){ note_dtor("S868C2", this);} // tgen
S868C2 ::S868C2(){ note_ctor("S868C2", this);} // tgen

static void Test_S868C2()
{
  extern Class_Descriptor cd_S868C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,54)];
    init_test(&cd_S868C2, buf);
    S868C2 *dp, &lv = *(dp=new (buf) S868C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,212), "sizeof(S868C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S868C2)");
    check_base_class_offset(lv, (S868C5*)(S868C4*)(S868C3*), 0, "S868C2");
    check_base_class_offset(lv, (S868C4*)(S868C3*), 0, "S868C2");
    check_base_class_offset(lv, (S868C3*), 0, "S868C2");
    check_field_offset(lv, s868c2f0, ABISELECT(304,208), "S868C2.s868c2f0");
    test_class_info(&lv, &cd_S868C2);
    dp->~S868C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS868C2(Test_S868C2, "S868C2", ABISELECT(312,212));

#else // __cplusplus

extern void _ZN6S868C2C1Ev();
extern void _ZN6S868C2D1Ev();
Name_Map name_map_S868C2[] = {
  NSPAIR(_ZN6S868C2C1Ev),
  NSPAIR(_ZN6S868C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S868C5;
extern VTBL_ENTRY _ZTI6S868C5[];
extern  VTBL_ENTRY _ZTV6S868C5[];
extern Class_Descriptor cd_S868C4;
extern VTBL_ENTRY _ZTI6S868C4[];
extern  VTBL_ENTRY _ZTV6S868C4[];
extern Class_Descriptor cd_S868C3;
extern VTBL_ENTRY _ZTI6S868C3[];
extern  VTBL_ENTRY _ZTV6S868C3[];
static Base_Class bases_S868C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S868C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S868C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S868C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S868C2[];
extern void _ZN6S868C2D1Ev();
extern void _ZN6S868C2D0Ev();
extern void _ZN6S868C52v2Ev();
extern void _ZN6S868C52v3Ev();
extern void _ZN6S868C52v4Ev();
extern void _ZN6S868C42v5Ev();
extern void _ZN6S868C42v6Ev();
extern void _ZN6S868C32v7Ev();
extern void _ZN6S868C22v8Ev();
extern void _ZN6S868C22v9Ev();
static  VTBL_ENTRY vtc_S868C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S868C2[0]),
  (VTBL_ENTRY)&_ZN6S868C2D1Ev,
  (VTBL_ENTRY)&_ZN6S868C2D0Ev,
  (VTBL_ENTRY)&_ZN6S868C52v2Ev,
  (VTBL_ENTRY)&_ZN6S868C52v3Ev,
  (VTBL_ENTRY)&_ZN6S868C52v4Ev,
  (VTBL_ENTRY)&_ZN6S868C42v5Ev,
  (VTBL_ENTRY)&_ZN6S868C42v6Ev,
  (VTBL_ENTRY)&_ZN6S868C32v7Ev,
  (VTBL_ENTRY)&_ZN6S868C22v8Ev,
  (VTBL_ENTRY)&_ZN6S868C22v9Ev,
};
extern VTBL_ENTRY _ZTI6S868C2[];
extern  VTBL_ENTRY _ZTV6S868C2[];
Class_Descriptor cd_S868C2 = {  "S868C2", // class name
  bases_S868C2, 3,
  &(vtc_S868C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,212), // object size
  NSPAIRA(_ZTI6S868C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S868C2),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S868C1  : S868C2 {
  ::S17070C23_nt s868c1f0;
  virtual void  v1(); // _ZN6S868C12v1Ev
  ~S868C1(); // tgen
  S868C1(); // tgen
};
//SIG(1 S868C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v2 v3 v4 FC6{ m Fp Fi FC7{ m}} Fi[2] Fc} v5 v6 Fp} vd v7 Fp FC8{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC9{ m FC10{ m Fi[2]} FC11{ m Fi[2]}} FC11 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC12{ m Fp} FC12 Fi[2]} v8 v9 FC13{ m Fp}} v1 FC14{ m FC15{ m FL}}}


void  S868C1 ::v1(){vfunc_called(this, "_ZN6S868C12v1Ev");}
S868C1 ::~S868C1(){ note_dtor("S868C1", this);} // tgen
S868C1 ::S868C1(){ note_ctor("S868C1", this);} // tgen

static void Test_S868C1()
{
  extern Class_Descriptor cd_S868C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,56)];
    init_test(&cd_S868C1, buf);
    S868C1 *dp, &lv = *(dp=new (buf) S868C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,220), "sizeof(S868C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S868C1)");
    check_base_class_offset(lv, (S868C5*)(S868C4*)(S868C3*)(S868C2*), 0, "S868C1");
    check_base_class_offset(lv, (S868C4*)(S868C3*)(S868C2*), 0, "S868C1");
    check_base_class_offset(lv, (S868C3*)(S868C2*), 0, "S868C1");
    check_base_class_offset(lv, (S868C2*), 0, "S868C1");
    check_field_offset(lv, s868c1f0, ABISELECT(312,212), "S868C1.s868c1f0");
    test_class_info(&lv, &cd_S868C1);
    dp->~S868C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS868C1(Test_S868C1, "S868C1", ABISELECT(320,220));

#else // __cplusplus

extern void _ZN6S868C1C1Ev();
extern void _ZN6S868C1D1Ev();
Name_Map name_map_S868C1[] = {
  NSPAIR(_ZN6S868C1C1Ev),
  NSPAIR(_ZN6S868C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S868C5;
extern VTBL_ENTRY _ZTI6S868C5[];
extern  VTBL_ENTRY _ZTV6S868C5[];
extern Class_Descriptor cd_S868C4;
extern VTBL_ENTRY _ZTI6S868C4[];
extern  VTBL_ENTRY _ZTV6S868C4[];
extern Class_Descriptor cd_S868C3;
extern VTBL_ENTRY _ZTI6S868C3[];
extern  VTBL_ENTRY _ZTV6S868C3[];
extern Class_Descriptor cd_S868C2;
extern VTBL_ENTRY _ZTI6S868C2[];
extern  VTBL_ENTRY _ZTV6S868C2[];
static Base_Class bases_S868C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S868C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S868C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S868C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S868C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S868C1[];
extern void _ZN6S868C1D1Ev();
extern void _ZN6S868C1D0Ev();
extern void _ZN6S868C52v2Ev();
extern void _ZN6S868C52v3Ev();
extern void _ZN6S868C52v4Ev();
extern void _ZN6S868C42v5Ev();
extern void _ZN6S868C42v6Ev();
extern void _ZN6S868C32v7Ev();
extern void _ZN6S868C22v8Ev();
extern void _ZN6S868C22v9Ev();
extern void _ZN6S868C12v1Ev();
static  VTBL_ENTRY vtc_S868C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S868C1[0]),
  (VTBL_ENTRY)&_ZN6S868C1D1Ev,
  (VTBL_ENTRY)&_ZN6S868C1D0Ev,
  (VTBL_ENTRY)&_ZN6S868C52v2Ev,
  (VTBL_ENTRY)&_ZN6S868C52v3Ev,
  (VTBL_ENTRY)&_ZN6S868C52v4Ev,
  (VTBL_ENTRY)&_ZN6S868C42v5Ev,
  (VTBL_ENTRY)&_ZN6S868C42v6Ev,
  (VTBL_ENTRY)&_ZN6S868C32v7Ev,
  (VTBL_ENTRY)&_ZN6S868C22v8Ev,
  (VTBL_ENTRY)&_ZN6S868C22v9Ev,
  (VTBL_ENTRY)&_ZN6S868C12v1Ev,
};
extern VTBL_ENTRY _ZTI6S868C1[];
extern  VTBL_ENTRY _ZTV6S868C1[];
Class_Descriptor cd_S868C1 = {  "S868C1", // class name
  bases_S868C1, 4,
  &(vtc_S868C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,220), // object size
  NSPAIRA(_ZTI6S868C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S868C1),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8193C1  : S8191C2 {
  ~S8193C1(); // tgen
  S8193C1(); // tgen
};
//SIG(1 S8193C1) C1{ BC2{ vd m Fp[2] FC3{ m Fi Fp Fi FC4{ m Fp Fi FC5{ m}} Fi[2] FC6{ m Fp Fi[2] FC5} FC7{ m Fp Fi[2] FC5} Fp[4] FC8{ m Fi} FC9{ m FC10{ m FL[2]}} Fi[4] FC9 FC9 Fi[4] Fp Fi[6] Fc[4] Fi[2] FC11{ m Fp Fi[2] FC12{ m}} Fp} Fp[2] FC13{ m Fp Fi[2] FC12}}}


S8193C1 ::~S8193C1(){ note_dtor("S8193C1", this);} // tgen
S8193C1 ::S8193C1(){ note_ctor("S8193C1", this);} // tgen

static void Test_S8193C1()
{
  extern Class_Descriptor cd_S8193C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,66)];
    init_test(&cd_S8193C1, buf);
    S8193C1 *dp, &lv = *(dp=new (buf) S8193C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,260), "sizeof(S8193C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8193C1)");
    check_base_class_offset(lv, (S8191C2*), 0, "S8193C1");
    test_class_info(&lv, &cd_S8193C1);
    dp->~S8193C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8193C1(Test_S8193C1, "S8193C1", ABISELECT(360,260));

#else // __cplusplus

extern void _ZN7S8193C1C1Ev();
extern void _ZN7S8193C1D1Ev();
Name_Map name_map_S8193C1[] = {
  NSPAIR(_ZN7S8193C1C1Ev),
  NSPAIR(_ZN7S8193C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8191C2;
extern VTBL_ENTRY _ZTI7S8191C2[];
extern  VTBL_ENTRY _ZTV7S8191C2[];
static Base_Class bases_S8193C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8191C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8193C1[];
extern void _ZN7S8193C1D1Ev();
extern void _ZN7S8193C1D0Ev();
static  VTBL_ENTRY vtc_S8193C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8193C1[0]),
  (VTBL_ENTRY)&_ZN7S8193C1D1Ev,
  (VTBL_ENTRY)&_ZN7S8193C1D0Ev,
};
extern VTBL_ENTRY _ZTI7S8193C1[];
extern  VTBL_ENTRY _ZTV7S8193C1[];
Class_Descriptor cd_S8193C1 = {  "S8193C1", // class name
  bases_S8193C1, 1,
  &(vtc_S8193C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,260), // object size
  NSPAIRA(_ZTI7S8193C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8193C1),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S346C6  {
  ::S17070C74_nt s346c6f0;
  int s346c6f1[2];
  char s346c6f2;
  virtual  ~S346C6(); // _ZN6S346C6D1Ev
  virtual void  v2(); // _ZN6S346C62v2Ev
  virtual void  v3(); // _ZN6S346C62v3Ev
  virtual void  v4(); // _ZN6S346C62v4Ev
  S346C6(); // tgen
};
//SIG(-1 S346C6) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S346C6 ::~S346C6(){ note_dtor("S346C6", this);}
void  S346C6 ::v2(){vfunc_called(this, "_ZN6S346C62v2Ev");}
void  S346C6 ::v3(){vfunc_called(this, "_ZN6S346C62v3Ev");}
void  S346C6 ::v4(){vfunc_called(this, "_ZN6S346C62v4Ev");}
S346C6 ::S346C6(){ note_ctor("S346C6", this);} // tgen

static void Test_S346C6()
{
  extern Class_Descriptor cd_S346C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S346C6, buf);
    S346C6 *dp, &lv = *(dp=new (buf) S346C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S346C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S346C6)");
    check_field_offset(lv, s346c6f0, ABISELECT(8,4), "S346C6.s346c6f0");
    check_field_offset(lv, s346c6f1, ABISELECT(24,16), "S346C6.s346c6f1");
    check_field_offset(lv, s346c6f2, ABISELECT(32,24), "S346C6.s346c6f2");
    test_class_info(&lv, &cd_S346C6);
    dp->~S346C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS346C6(Test_S346C6, "S346C6", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6S346C6C1Ev();
extern void _ZN6S346C6D1Ev();
Name_Map name_map_S346C6[] = {
  NSPAIR(_ZN6S346C6C1Ev),
  NSPAIR(_ZN6S346C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S346C6[];
extern void _ZN6S346C6D1Ev();
extern void _ZN6S346C6D0Ev();
extern void _ZN6S346C62v2Ev();
extern void _ZN6S346C62v3Ev();
extern void _ZN6S346C62v4Ev();
static  VTBL_ENTRY vtc_S346C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S346C6[0]),
  (VTBL_ENTRY)&_ZN6S346C6D1Ev,
  (VTBL_ENTRY)&_ZN6S346C6D0Ev,
  (VTBL_ENTRY)&_ZN6S346C62v2Ev,
  (VTBL_ENTRY)&_ZN6S346C62v3Ev,
  (VTBL_ENTRY)&_ZN6S346C62v4Ev,
};
extern VTBL_ENTRY _ZTI6S346C6[];
extern  VTBL_ENTRY _ZTV6S346C6[];
Class_Descriptor cd_S346C6 = {  "S346C6", // class name
  0,0,//no base classes
  &(vtc_S346C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6S346C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S346C6),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S346C5  : S346C6 {
  void *s346c5f0;
  virtual void  v5(); // _ZN6S346C52v5Ev
  virtual void  v6(); // _ZN6S346C52v6Ev
  ~S346C5(); // tgen
  S346C5(); // tgen
};
//SIG(-1 S346C5) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S346C5 ::v5(){vfunc_called(this, "_ZN6S346C52v5Ev");}
void  S346C5 ::v6(){vfunc_called(this, "_ZN6S346C52v6Ev");}
S346C5 ::~S346C5(){ note_dtor("S346C5", this);} // tgen
S346C5 ::S346C5(){ note_ctor("S346C5", this);} // tgen

static void Test_S346C5()
{
  extern Class_Descriptor cd_S346C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S346C5, buf);
    S346C5 *dp, &lv = *(dp=new (buf) S346C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S346C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S346C5)");
    check_base_class_offset(lv, (S346C6*), 0, "S346C5");
    check_field_offset(lv, s346c5f0, ABISELECT(40,28), "S346C5.s346c5f0");
    test_class_info(&lv, &cd_S346C5);
    dp->~S346C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS346C5(Test_S346C5, "S346C5", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S346C5C1Ev();
extern void _ZN6S346C5D1Ev();
Name_Map name_map_S346C5[] = {
  NSPAIR(_ZN6S346C5C1Ev),
  NSPAIR(_ZN6S346C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S346C6;
extern VTBL_ENTRY _ZTI6S346C6[];
extern  VTBL_ENTRY _ZTV6S346C6[];
static Base_Class bases_S346C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S346C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S346C5[];
extern void _ZN6S346C5D1Ev();
extern void _ZN6S346C5D0Ev();
extern void _ZN6S346C62v2Ev();
extern void _ZN6S346C62v3Ev();
extern void _ZN6S346C62v4Ev();
extern void _ZN6S346C52v5Ev();
extern void _ZN6S346C52v6Ev();
static  VTBL_ENTRY vtc_S346C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S346C5[0]),
  (VTBL_ENTRY)&_ZN6S346C5D1Ev,
  (VTBL_ENTRY)&_ZN6S346C5D0Ev,
  (VTBL_ENTRY)&_ZN6S346C62v2Ev,
  (VTBL_ENTRY)&_ZN6S346C62v3Ev,
  (VTBL_ENTRY)&_ZN6S346C62v4Ev,
  (VTBL_ENTRY)&_ZN6S346C52v5Ev,
  (VTBL_ENTRY)&_ZN6S346C52v6Ev,
};
extern VTBL_ENTRY _ZTI6S346C5[];
extern  VTBL_ENTRY _ZTV6S346C5[];
Class_Descriptor cd_S346C5 = {  "S346C5", // class name
  bases_S346C5, 1,
  &(vtc_S346C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S346C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S346C5),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S346C4  : S346C5 {
  void *s346c4f0;
  ::S2165C7_nt s346c4f1;
  void *s346c4f2;
  int s346c4f3;
  ::S17070C21_nt s346c4f4;
  ::S17070C21_nt s346c4f5;
  int s346c4f6[2];
  virtual  ~S346C4(); // _ZN6S346C4D1Ev
  virtual void  v7(); // _ZN6S346C42v7Ev
  S346C4(); // tgen
};
//SIG(-1 S346C4) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S346C4 ::~S346C4(){ note_dtor("S346C4", this);}
void  S346C4 ::v7(){vfunc_called(this, "_ZN6S346C42v7Ev");}
S346C4 ::S346C4(){ note_ctor("S346C4", this);} // tgen

static void Test_S346C4()
{
  extern Class_Descriptor cd_S346C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S346C4, buf);
    S346C4 *dp, &lv = *(dp=new (buf) S346C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S346C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S346C4)");
    check_base_class_offset(lv, (S346C6*)(S346C5*), 0, "S346C4");
    check_base_class_offset(lv, (S346C5*), 0, "S346C4");
    check_field_offset(lv, s346c4f0, ABISELECT(48,32), "S346C4.s346c4f0");
    check_field_offset(lv, s346c4f1, ABISELECT(56,36), "S346C4.s346c4f1");
    check_field_offset(lv, s346c4f2, ABISELECT(264,184), "S346C4.s346c4f2");
    check_field_offset(lv, s346c4f3, ABISELECT(272,188), "S346C4.s346c4f3");
    check_field_offset(lv, s346c4f4, ABISELECT(280,192), "S346C4.s346c4f4");
    check_field_offset(lv, s346c4f5, ABISELECT(288,196), "S346C4.s346c4f5");
    check_field_offset(lv, s346c4f6, ABISELECT(296,200), "S346C4.s346c4f6");
    test_class_info(&lv, &cd_S346C4);
    dp->~S346C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS346C4(Test_S346C4, "S346C4", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN6S346C4C1Ev();
extern void _ZN6S346C4D1Ev();
Name_Map name_map_S346C4[] = {
  NSPAIR(_ZN6S346C4C1Ev),
  NSPAIR(_ZN6S346C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S346C6;
extern VTBL_ENTRY _ZTI6S346C6[];
extern  VTBL_ENTRY _ZTV6S346C6[];
extern Class_Descriptor cd_S346C5;
extern VTBL_ENTRY _ZTI6S346C5[];
extern  VTBL_ENTRY _ZTV6S346C5[];
static Base_Class bases_S346C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S346C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S346C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S346C4[];
extern void _ZN6S346C4D1Ev();
extern void _ZN6S346C4D0Ev();
extern void _ZN6S346C62v2Ev();
extern void _ZN6S346C62v3Ev();
extern void _ZN6S346C62v4Ev();
extern void _ZN6S346C52v5Ev();
extern void _ZN6S346C52v6Ev();
extern void _ZN6S346C42v7Ev();
static  VTBL_ENTRY vtc_S346C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S346C4[0]),
  (VTBL_ENTRY)&_ZN6S346C4D1Ev,
  (VTBL_ENTRY)&_ZN6S346C4D0Ev,
  (VTBL_ENTRY)&_ZN6S346C62v2Ev,
  (VTBL_ENTRY)&_ZN6S346C62v3Ev,
  (VTBL_ENTRY)&_ZN6S346C62v4Ev,
  (VTBL_ENTRY)&_ZN6S346C52v5Ev,
  (VTBL_ENTRY)&_ZN6S346C52v6Ev,
  (VTBL_ENTRY)&_ZN6S346C42v7Ev,
};
extern VTBL_ENTRY _ZTI6S346C4[];
extern  VTBL_ENTRY _ZTV6S346C4[];
Class_Descriptor cd_S346C4 = {  "S346C4", // class name
  bases_S346C4, 2,
  &(vtc_S346C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI6S346C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S346C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S346C3  : S346C4 {
  __tsi64 s346c3f0;
  int s346c3f1[7];
  virtual void  v8(); // _ZN6S346C32v8Ev
  virtual void  v9(); // _ZN6S346C32v9Ev
  virtual void  v10(); // _ZN6S346C33v10Ev
  ~S346C3(); // tgen
  S346C3(); // tgen
};
//SIG(-1 S346C3) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v7 v8 Fp} vd v9 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} v1 v2 v3 FL Fi[7]}


void  S346C3 ::v8(){vfunc_called(this, "_ZN6S346C32v8Ev");}
void  S346C3 ::v9(){vfunc_called(this, "_ZN6S346C32v9Ev");}
void  S346C3 ::v10(){vfunc_called(this, "_ZN6S346C33v10Ev");}
S346C3 ::~S346C3(){ note_dtor("S346C3", this);} // tgen
S346C3 ::S346C3(){ note_ctor("S346C3", this);} // tgen

static void Test_S346C3()
{
  extern Class_Descriptor cd_S346C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,62)];
    init_test(&cd_S346C3, buf);
    S346C3 *dp, &lv = *(dp=new (buf) S346C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,244), "sizeof(S346C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S346C3)");
    check_base_class_offset(lv, (S346C6*)(S346C5*)(S346C4*), 0, "S346C3");
    check_base_class_offset(lv, (S346C5*)(S346C4*), 0, "S346C3");
    check_base_class_offset(lv, (S346C4*), 0, "S346C3");
    check_field_offset(lv, s346c3f0, ABISELECT(304,208), "S346C3.s346c3f0");
    check_field_offset(lv, s346c3f1, ABISELECT(312,216), "S346C3.s346c3f1");
    test_class_info(&lv, &cd_S346C3);
    dp->~S346C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS346C3(Test_S346C3, "S346C3", ABISELECT(344,244));

#else // __cplusplus

extern void _ZN6S346C3C1Ev();
extern void _ZN6S346C3D1Ev();
Name_Map name_map_S346C3[] = {
  NSPAIR(_ZN6S346C3C1Ev),
  NSPAIR(_ZN6S346C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S346C6;
extern VTBL_ENTRY _ZTI6S346C6[];
extern  VTBL_ENTRY _ZTV6S346C6[];
extern Class_Descriptor cd_S346C5;
extern VTBL_ENTRY _ZTI6S346C5[];
extern  VTBL_ENTRY _ZTV6S346C5[];
extern Class_Descriptor cd_S346C4;
extern VTBL_ENTRY _ZTI6S346C4[];
extern  VTBL_ENTRY _ZTV6S346C4[];
static Base_Class bases_S346C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S346C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S346C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S346C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S346C3[];
extern void _ZN6S346C3D1Ev();
extern void _ZN6S346C3D0Ev();
extern void _ZN6S346C62v2Ev();
extern void _ZN6S346C62v3Ev();
extern void _ZN6S346C62v4Ev();
extern void _ZN6S346C52v5Ev();
extern void _ZN6S346C52v6Ev();
extern void _ZN6S346C42v7Ev();
extern void _ZN6S346C32v8Ev();
extern void _ZN6S346C32v9Ev();
extern void _ZN6S346C33v10Ev();
static  VTBL_ENTRY vtc_S346C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S346C3[0]),
  (VTBL_ENTRY)&_ZN6S346C3D1Ev,
  (VTBL_ENTRY)&_ZN6S346C3D0Ev,
  (VTBL_ENTRY)&_ZN6S346C62v2Ev,
  (VTBL_ENTRY)&_ZN6S346C62v3Ev,
  (VTBL_ENTRY)&_ZN6S346C62v4Ev,
  (VTBL_ENTRY)&_ZN6S346C52v5Ev,
  (VTBL_ENTRY)&_ZN6S346C52v6Ev,
  (VTBL_ENTRY)&_ZN6S346C42v7Ev,
  (VTBL_ENTRY)&_ZN6S346C32v8Ev,
  (VTBL_ENTRY)&_ZN6S346C32v9Ev,
  (VTBL_ENTRY)&_ZN6S346C33v10Ev,
};
extern VTBL_ENTRY _ZTI6S346C3[];
extern  VTBL_ENTRY _ZTV6S346C3[];
Class_Descriptor cd_S346C3 = {  "S346C3", // class name
  bases_S346C3, 3,
  &(vtc_S346C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(344,244), // object size
  NSPAIRA(_ZTI6S346C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S346C3),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S346C2  : S346C3 {
  virtual void  v11(); // _ZN6S346C23v11Ev
  ~S346C2(); // tgen
  S346C2(); // tgen
};
//SIG(-1 S346C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v2 v3 v4 FC6{ m Fp Fi FC7{ m}} Fi[2] Fc} v5 v6 Fp} vd v7 Fp FC8{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC9{ m FC10{ m Fi[2]} FC11{ m Fi[2]}} FC11 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC12{ m Fp} FC12 Fi[2]} v8 v9 v10 FL Fi[7]} v1}


void  S346C2 ::v11(){vfunc_called(this, "_ZN6S346C23v11Ev");}
S346C2 ::~S346C2(){ note_dtor("S346C2", this);} // tgen
S346C2 ::S346C2(){ note_ctor("S346C2", this);} // tgen

static void Test_S346C2()
{
  extern Class_Descriptor cd_S346C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,62)];
    init_test(&cd_S346C2, buf);
    S346C2 *dp, &lv = *(dp=new (buf) S346C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,244), "sizeof(S346C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S346C2)");
    check_base_class_offset(lv, (S346C6*)(S346C5*)(S346C4*)(S346C3*), 0, "S346C2");
    check_base_class_offset(lv, (S346C5*)(S346C4*)(S346C3*), 0, "S346C2");
    check_base_class_offset(lv, (S346C4*)(S346C3*), 0, "S346C2");
    check_base_class_offset(lv, (S346C3*), 0, "S346C2");
    test_class_info(&lv, &cd_S346C2);
    dp->~S346C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS346C2(Test_S346C2, "S346C2", ABISELECT(344,244));

#else // __cplusplus

extern void _ZN6S346C2C1Ev();
extern void _ZN6S346C2D1Ev();
Name_Map name_map_S346C2[] = {
  NSPAIR(_ZN6S346C2C1Ev),
  NSPAIR(_ZN6S346C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S346C6;
extern VTBL_ENTRY _ZTI6S346C6[];
extern  VTBL_ENTRY _ZTV6S346C6[];
extern Class_Descriptor cd_S346C5;
extern VTBL_ENTRY _ZTI6S346C5[];
extern  VTBL_ENTRY _ZTV6S346C5[];
extern Class_Descriptor cd_S346C4;
extern VTBL_ENTRY _ZTI6S346C4[];
extern  VTBL_ENTRY _ZTV6S346C4[];
extern Class_Descriptor cd_S346C3;
extern VTBL_ENTRY _ZTI6S346C3[];
extern  VTBL_ENTRY _ZTV6S346C3[];
static Base_Class bases_S346C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S346C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S346C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S346C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S346C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S346C2[];
extern void _ZN6S346C2D1Ev();
extern void _ZN6S346C2D0Ev();
extern void _ZN6S346C62v2Ev();
extern void _ZN6S346C62v3Ev();
extern void _ZN6S346C62v4Ev();
extern void _ZN6S346C52v5Ev();
extern void _ZN6S346C52v6Ev();
extern void _ZN6S346C42v7Ev();
extern void _ZN6S346C32v8Ev();
extern void _ZN6S346C32v9Ev();
extern void _ZN6S346C33v10Ev();
extern void _ZN6S346C23v11Ev();
static  VTBL_ENTRY vtc_S346C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S346C2[0]),
  (VTBL_ENTRY)&_ZN6S346C2D1Ev,
  (VTBL_ENTRY)&_ZN6S346C2D0Ev,
  (VTBL_ENTRY)&_ZN6S346C62v2Ev,
  (VTBL_ENTRY)&_ZN6S346C62v3Ev,
  (VTBL_ENTRY)&_ZN6S346C62v4Ev,
  (VTBL_ENTRY)&_ZN6S346C52v5Ev,
  (VTBL_ENTRY)&_ZN6S346C52v6Ev,
  (VTBL_ENTRY)&_ZN6S346C42v7Ev,
  (VTBL_ENTRY)&_ZN6S346C32v8Ev,
  (VTBL_ENTRY)&_ZN6S346C32v9Ev,
  (VTBL_ENTRY)&_ZN6S346C33v10Ev,
  (VTBL_ENTRY)&_ZN6S346C23v11Ev,
};
extern VTBL_ENTRY _ZTI6S346C2[];
extern  VTBL_ENTRY _ZTV6S346C2[];
Class_Descriptor cd_S346C2 = {  "S346C2", // class name
  bases_S346C2, 4,
  &(vtc_S346C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(344,244), // object size
  NSPAIRA(_ZTI6S346C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S346C2),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S346C1  : S346C2 {
  void *s346c1f0;
  virtual void  v1(); // _ZN6S346C12v1Ev
  ~S346C1(); // tgen
  S346C1(); // tgen
};
//SIG(1 S346C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v2 v3 v4 FC7{ m Fp Fi FC8{ m}} Fi[2] Fc} v5 v6 Fp} vd v7 Fp FC9{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC10{ m FC11{ m Fi[2]} FC12{ m Fi[2]}} FC12 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC13{ m Fp} FC13 Fi[2]} v8 v9 v10 FL Fi[7]} v11} v1 Fp}


void  S346C1 ::v1(){vfunc_called(this, "_ZN6S346C12v1Ev");}
S346C1 ::~S346C1(){ note_dtor("S346C1", this);} // tgen
S346C1 ::S346C1(){ note_ctor("S346C1", this);} // tgen

static void Test_S346C1()
{
  extern Class_Descriptor cd_S346C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,63)];
    init_test(&cd_S346C1, buf);
    S346C1 *dp, &lv = *(dp=new (buf) S346C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,248), "sizeof(S346C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S346C1)");
    check_base_class_offset(lv, (S346C6*)(S346C5*)(S346C4*)(S346C3*)(S346C2*), 0, "S346C1");
    check_base_class_offset(lv, (S346C5*)(S346C4*)(S346C3*)(S346C2*), 0, "S346C1");
    check_base_class_offset(lv, (S346C4*)(S346C3*)(S346C2*), 0, "S346C1");
    check_base_class_offset(lv, (S346C3*)(S346C2*), 0, "S346C1");
    check_base_class_offset(lv, (S346C2*), 0, "S346C1");
    check_field_offset(lv, s346c1f0, ABISELECT(344,244), "S346C1.s346c1f0");
    test_class_info(&lv, &cd_S346C1);
    dp->~S346C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS346C1(Test_S346C1, "S346C1", ABISELECT(352,248));

#else // __cplusplus

extern void _ZN6S346C1C1Ev();
extern void _ZN6S346C1D1Ev();
Name_Map name_map_S346C1[] = {
  NSPAIR(_ZN6S346C1C1Ev),
  NSPAIR(_ZN6S346C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S346C6;
extern VTBL_ENTRY _ZTI6S346C6[];
extern  VTBL_ENTRY _ZTV6S346C6[];
extern Class_Descriptor cd_S346C5;
extern VTBL_ENTRY _ZTI6S346C5[];
extern  VTBL_ENTRY _ZTV6S346C5[];
extern Class_Descriptor cd_S346C4;
extern VTBL_ENTRY _ZTI6S346C4[];
extern  VTBL_ENTRY _ZTV6S346C4[];
extern Class_Descriptor cd_S346C3;
extern VTBL_ENTRY _ZTI6S346C3[];
extern  VTBL_ENTRY _ZTV6S346C3[];
extern Class_Descriptor cd_S346C2;
extern VTBL_ENTRY _ZTI6S346C2[];
extern  VTBL_ENTRY _ZTV6S346C2[];
static Base_Class bases_S346C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S346C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S346C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S346C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S346C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S346C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S346C1[];
extern void _ZN6S346C1D1Ev();
extern void _ZN6S346C1D0Ev();
extern void _ZN6S346C62v2Ev();
extern void _ZN6S346C62v3Ev();
extern void _ZN6S346C62v4Ev();
extern void _ZN6S346C52v5Ev();
extern void _ZN6S346C52v6Ev();
extern void _ZN6S346C42v7Ev();
extern void _ZN6S346C32v8Ev();
extern void _ZN6S346C32v9Ev();
extern void _ZN6S346C33v10Ev();
extern void _ZN6S346C23v11Ev();
extern void _ZN6S346C12v1Ev();
static  VTBL_ENTRY vtc_S346C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S346C1[0]),
  (VTBL_ENTRY)&_ZN6S346C1D1Ev,
  (VTBL_ENTRY)&_ZN6S346C1D0Ev,
  (VTBL_ENTRY)&_ZN6S346C62v2Ev,
  (VTBL_ENTRY)&_ZN6S346C62v3Ev,
  (VTBL_ENTRY)&_ZN6S346C62v4Ev,
  (VTBL_ENTRY)&_ZN6S346C52v5Ev,
  (VTBL_ENTRY)&_ZN6S346C52v6Ev,
  (VTBL_ENTRY)&_ZN6S346C42v7Ev,
  (VTBL_ENTRY)&_ZN6S346C32v8Ev,
  (VTBL_ENTRY)&_ZN6S346C32v9Ev,
  (VTBL_ENTRY)&_ZN6S346C33v10Ev,
  (VTBL_ENTRY)&_ZN6S346C23v11Ev,
  (VTBL_ENTRY)&_ZN6S346C12v1Ev,
};
extern VTBL_ENTRY _ZTI6S346C1[];
extern  VTBL_ENTRY _ZTV6S346C1[];
Class_Descriptor cd_S346C1 = {  "S346C1", // class name
  bases_S346C1, 5,
  &(vtc_S346C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,248), // object size
  NSPAIRA(_ZTI6S346C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S346C1),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2162C4  {
  ::S17070C74_nt s2162c4f0;
  int s2162c4f1[2];
  char s2162c4f2;
  virtual  ~S2162C4(); // _ZN7S2162C4D1Ev
  virtual void  v3(); // _ZN7S2162C42v3Ev
  virtual void  v4(); // _ZN7S2162C42v4Ev
  virtual void  v5(); // _ZN7S2162C42v5Ev
  S2162C4(); // tgen
};
//SIG(-1 S2162C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2162C4 ::~S2162C4(){ note_dtor("S2162C4", this);}
void  S2162C4 ::v3(){vfunc_called(this, "_ZN7S2162C42v3Ev");}
void  S2162C4 ::v4(){vfunc_called(this, "_ZN7S2162C42v4Ev");}
void  S2162C4 ::v5(){vfunc_called(this, "_ZN7S2162C42v5Ev");}
S2162C4 ::S2162C4(){ note_ctor("S2162C4", this);} // tgen

static void Test_S2162C4()
{
  extern Class_Descriptor cd_S2162C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2162C4, buf);
    S2162C4 *dp, &lv = *(dp=new (buf) S2162C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2162C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2162C4)");
    check_field_offset(lv, s2162c4f0, ABISELECT(8,4), "S2162C4.s2162c4f0");
    check_field_offset(lv, s2162c4f1, ABISELECT(24,16), "S2162C4.s2162c4f1");
    check_field_offset(lv, s2162c4f2, ABISELECT(32,24), "S2162C4.s2162c4f2");
    test_class_info(&lv, &cd_S2162C4);
    dp->~S2162C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2162C4(Test_S2162C4, "S2162C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2162C4C1Ev();
extern void _ZN7S2162C4D1Ev();
Name_Map name_map_S2162C4[] = {
  NSPAIR(_ZN7S2162C4C1Ev),
  NSPAIR(_ZN7S2162C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2162C4[];
extern void _ZN7S2162C4D1Ev();
extern void _ZN7S2162C4D0Ev();
extern void _ZN7S2162C42v3Ev();
extern void _ZN7S2162C42v4Ev();
extern void _ZN7S2162C42v5Ev();
static  VTBL_ENTRY vtc_S2162C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2162C4[0]),
  (VTBL_ENTRY)&_ZN7S2162C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2162C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v5Ev,
};
extern VTBL_ENTRY _ZTI7S2162C4[];
extern  VTBL_ENTRY _ZTV7S2162C4[];
Class_Descriptor cd_S2162C4 = {  "S2162C4", // class name
  0,0,//no base classes
  &(vtc_S2162C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2162C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2162C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2162C3  : S2162C4 {
  void *s2162c3f0;
  virtual void  v6(); // _ZN7S2162C32v6Ev
  virtual void  v7(); // _ZN7S2162C32v7Ev
  ~S2162C3(); // tgen
  S2162C3(); // tgen
};
//SIG(-1 S2162C3) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S2162C3 ::v6(){vfunc_called(this, "_ZN7S2162C32v6Ev");}
void  S2162C3 ::v7(){vfunc_called(this, "_ZN7S2162C32v7Ev");}
S2162C3 ::~S2162C3(){ note_dtor("S2162C3", this);} // tgen
S2162C3 ::S2162C3(){ note_ctor("S2162C3", this);} // tgen

static void Test_S2162C3()
{
  extern Class_Descriptor cd_S2162C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S2162C3, buf);
    S2162C3 *dp, &lv = *(dp=new (buf) S2162C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S2162C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2162C3)");
    check_base_class_offset(lv, (S2162C4*), 0, "S2162C3");
    check_field_offset(lv, s2162c3f0, ABISELECT(40,28), "S2162C3.s2162c3f0");
    test_class_info(&lv, &cd_S2162C3);
    dp->~S2162C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2162C3(Test_S2162C3, "S2162C3", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S2162C3C1Ev();
extern void _ZN7S2162C3D1Ev();
Name_Map name_map_S2162C3[] = {
  NSPAIR(_ZN7S2162C3C1Ev),
  NSPAIR(_ZN7S2162C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2162C4;
extern VTBL_ENTRY _ZTI7S2162C4[];
extern  VTBL_ENTRY _ZTV7S2162C4[];
static Base_Class bases_S2162C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2162C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2162C3[];
extern void _ZN7S2162C3D1Ev();
extern void _ZN7S2162C3D0Ev();
extern void _ZN7S2162C42v3Ev();
extern void _ZN7S2162C42v4Ev();
extern void _ZN7S2162C42v5Ev();
extern void _ZN7S2162C32v6Ev();
extern void _ZN7S2162C32v7Ev();
static  VTBL_ENTRY vtc_S2162C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2162C3[0]),
  (VTBL_ENTRY)&_ZN7S2162C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2162C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2162C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2162C32v7Ev,
};
extern VTBL_ENTRY _ZTI7S2162C3[];
extern  VTBL_ENTRY _ZTV7S2162C3[];
Class_Descriptor cd_S2162C3 = {  "S2162C3", // class name
  bases_S2162C3, 1,
  &(vtc_S2162C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S2162C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2162C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2162C2  : S2162C3 {
  void *s2162c2f0;
  ::S2165C7_nt s2162c2f1;
  void *s2162c2f2;
  int s2162c2f3;
  ::S17070C21_nt s2162c2f4;
  ::S17070C21_nt s2162c2f5;
  int s2162c2f6[2];
  virtual  ~S2162C2(); // _ZN7S2162C2D1Ev
  virtual void  v8(); // _ZN7S2162C22v8Ev
  S2162C2(); // tgen
};
//SIG(-1 S2162C2) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S2162C2 ::~S2162C2(){ note_dtor("S2162C2", this);}
void  S2162C2 ::v8(){vfunc_called(this, "_ZN7S2162C22v8Ev");}
S2162C2 ::S2162C2(){ note_ctor("S2162C2", this);} // tgen

static void Test_S2162C2()
{
  extern Class_Descriptor cd_S2162C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S2162C2, buf);
    S2162C2 *dp, &lv = *(dp=new (buf) S2162C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S2162C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2162C2)");
    check_base_class_offset(lv, (S2162C4*)(S2162C3*), 0, "S2162C2");
    check_base_class_offset(lv, (S2162C3*), 0, "S2162C2");
    check_field_offset(lv, s2162c2f0, ABISELECT(48,32), "S2162C2.s2162c2f0");
    check_field_offset(lv, s2162c2f1, ABISELECT(56,36), "S2162C2.s2162c2f1");
    check_field_offset(lv, s2162c2f2, ABISELECT(264,184), "S2162C2.s2162c2f2");
    check_field_offset(lv, s2162c2f3, ABISELECT(272,188), "S2162C2.s2162c2f3");
    check_field_offset(lv, s2162c2f4, ABISELECT(280,192), "S2162C2.s2162c2f4");
    check_field_offset(lv, s2162c2f5, ABISELECT(288,196), "S2162C2.s2162c2f5");
    check_field_offset(lv, s2162c2f6, ABISELECT(296,200), "S2162C2.s2162c2f6");
    test_class_info(&lv, &cd_S2162C2);
    dp->~S2162C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2162C2(Test_S2162C2, "S2162C2", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN7S2162C2C1Ev();
extern void _ZN7S2162C2D1Ev();
Name_Map name_map_S2162C2[] = {
  NSPAIR(_ZN7S2162C2C1Ev),
  NSPAIR(_ZN7S2162C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2162C4;
extern VTBL_ENTRY _ZTI7S2162C4[];
extern  VTBL_ENTRY _ZTV7S2162C4[];
extern Class_Descriptor cd_S2162C3;
extern VTBL_ENTRY _ZTI7S2162C3[];
extern  VTBL_ENTRY _ZTV7S2162C3[];
static Base_Class bases_S2162C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2162C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2162C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2162C2[];
extern void _ZN7S2162C2D1Ev();
extern void _ZN7S2162C2D0Ev();
extern void _ZN7S2162C42v3Ev();
extern void _ZN7S2162C42v4Ev();
extern void _ZN7S2162C42v5Ev();
extern void _ZN7S2162C32v6Ev();
extern void _ZN7S2162C32v7Ev();
extern void _ZN7S2162C22v8Ev();
static  VTBL_ENTRY vtc_S2162C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2162C2[0]),
  (VTBL_ENTRY)&_ZN7S2162C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2162C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2162C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2162C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2162C22v8Ev,
};
extern VTBL_ENTRY _ZTI7S2162C2[];
extern  VTBL_ENTRY _ZTV7S2162C2[];
Class_Descriptor cd_S2162C2 = {  "S2162C2", // class name
  bases_S2162C2, 2,
  &(vtc_S2162C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI7S2162C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2162C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2162C1  : S2162C2 {
  ::S909C13_nt s2162c1f0;
  ::S17070C17_nt s2162c1f1;
  virtual void  v1(); // _ZN7S2162C12v1Ev
  virtual void  v2(); // _ZN7S2162C12v2Ev
  ~S2162C1(); // tgen
  S2162C1(); // tgen
};
//SIG(1 S2162C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v6 v7 Fp} vd v8 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} v1 v2 FC12{ m Fp} FC13{ m FC14{ m FL[2]}}}


void  S2162C1 ::v1(){vfunc_called(this, "_ZN7S2162C12v1Ev");}
void  S2162C1 ::v2(){vfunc_called(this, "_ZN7S2162C12v2Ev");}
S2162C1 ::~S2162C1(){ note_dtor("S2162C1", this);} // tgen
S2162C1 ::S2162C1(){ note_ctor("S2162C1", this);} // tgen

static void Test_S2162C1()
{
  extern Class_Descriptor cd_S2162C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,58)];
    init_test(&cd_S2162C1, buf);
    S2162C1 *dp, &lv = *(dp=new (buf) S2162C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,228), "sizeof(S2162C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2162C1)");
    check_base_class_offset(lv, (S2162C4*)(S2162C3*)(S2162C2*), 0, "S2162C1");
    check_base_class_offset(lv, (S2162C3*)(S2162C2*), 0, "S2162C1");
    check_base_class_offset(lv, (S2162C2*), 0, "S2162C1");
    check_field_offset(lv, s2162c1f0, ABISELECT(304,208), "S2162C1.s2162c1f0");
    check_field_offset(lv, s2162c1f1, ABISELECT(312,212), "S2162C1.s2162c1f1");
    test_class_info(&lv, &cd_S2162C1);
    dp->~S2162C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2162C1(Test_S2162C1, "S2162C1", ABISELECT(328,228));

#else // __cplusplus

extern void _ZN7S2162C1C1Ev();
extern void _ZN7S2162C1D1Ev();
Name_Map name_map_S2162C1[] = {
  NSPAIR(_ZN7S2162C1C1Ev),
  NSPAIR(_ZN7S2162C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2162C4;
extern VTBL_ENTRY _ZTI7S2162C4[];
extern  VTBL_ENTRY _ZTV7S2162C4[];
extern Class_Descriptor cd_S2162C3;
extern VTBL_ENTRY _ZTI7S2162C3[];
extern  VTBL_ENTRY _ZTV7S2162C3[];
extern Class_Descriptor cd_S2162C2;
extern VTBL_ENTRY _ZTI7S2162C2[];
extern  VTBL_ENTRY _ZTV7S2162C2[];
static Base_Class bases_S2162C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2162C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2162C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2162C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2162C1[];
extern void _ZN7S2162C1D1Ev();
extern void _ZN7S2162C1D0Ev();
extern void _ZN7S2162C42v3Ev();
extern void _ZN7S2162C42v4Ev();
extern void _ZN7S2162C42v5Ev();
extern void _ZN7S2162C32v6Ev();
extern void _ZN7S2162C32v7Ev();
extern void _ZN7S2162C22v8Ev();
extern void _ZN7S2162C12v1Ev();
extern void _ZN7S2162C12v2Ev();
static  VTBL_ENTRY vtc_S2162C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2162C1[0]),
  (VTBL_ENTRY)&_ZN7S2162C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2162C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2162C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2162C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2162C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2162C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2162C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2162C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2162C1[];
extern  VTBL_ENTRY _ZTV7S2162C1[];
Class_Descriptor cd_S2162C1 = {  "S2162C1", // class name
  bases_S2162C1, 3,
  &(vtc_S2162C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,228), // object size
  NSPAIRA(_ZTI7S2162C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2162C1),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2067C4  {
  ::S17070C74_nt s2067c4f0;
  int s2067c4f1[2];
  char s2067c4f2;
  virtual  ~S2067C4(); // _ZN7S2067C4D1Ev
  virtual void  v2(); // _ZN7S2067C42v2Ev
  virtual void  v3(); // _ZN7S2067C42v3Ev
  virtual void  v4(); // _ZN7S2067C42v4Ev
  S2067C4(); // tgen
};
//SIG(-1 S2067C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2067C4 ::~S2067C4(){ note_dtor("S2067C4", this);}
void  S2067C4 ::v2(){vfunc_called(this, "_ZN7S2067C42v2Ev");}
void  S2067C4 ::v3(){vfunc_called(this, "_ZN7S2067C42v3Ev");}
void  S2067C4 ::v4(){vfunc_called(this, "_ZN7S2067C42v4Ev");}
S2067C4 ::S2067C4(){ note_ctor("S2067C4", this);} // tgen

static void Test_S2067C4()
{
  extern Class_Descriptor cd_S2067C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2067C4, buf);
    S2067C4 *dp, &lv = *(dp=new (buf) S2067C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2067C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2067C4)");
    check_field_offset(lv, s2067c4f0, ABISELECT(8,4), "S2067C4.s2067c4f0");
    check_field_offset(lv, s2067c4f1, ABISELECT(24,16), "S2067C4.s2067c4f1");
    check_field_offset(lv, s2067c4f2, ABISELECT(32,24), "S2067C4.s2067c4f2");
    test_class_info(&lv, &cd_S2067C4);
    dp->~S2067C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2067C4(Test_S2067C4, "S2067C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2067C4C1Ev();
extern void _ZN7S2067C4D1Ev();
Name_Map name_map_S2067C4[] = {
  NSPAIR(_ZN7S2067C4C1Ev),
  NSPAIR(_ZN7S2067C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2067C4[];
extern void _ZN7S2067C4D1Ev();
extern void _ZN7S2067C4D0Ev();
extern void _ZN7S2067C42v2Ev();
extern void _ZN7S2067C42v3Ev();
extern void _ZN7S2067C42v4Ev();
static  VTBL_ENTRY vtc_S2067C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2067C4[0]),
  (VTBL_ENTRY)&_ZN7S2067C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2067C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v2Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v4Ev,
};
extern VTBL_ENTRY _ZTI7S2067C4[];
extern  VTBL_ENTRY _ZTV7S2067C4[];
Class_Descriptor cd_S2067C4 = {  "S2067C4", // class name
  0,0,//no base classes
  &(vtc_S2067C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2067C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2067C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2067C3  : S2067C4 {
  void *s2067c3f0;
  virtual void  v5(); // _ZN7S2067C32v5Ev
  virtual void  v6(); // _ZN7S2067C32v6Ev
  ~S2067C3(); // tgen
  S2067C3(); // tgen
};
//SIG(-1 S2067C3) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S2067C3 ::v5(){vfunc_called(this, "_ZN7S2067C32v5Ev");}
void  S2067C3 ::v6(){vfunc_called(this, "_ZN7S2067C32v6Ev");}
S2067C3 ::~S2067C3(){ note_dtor("S2067C3", this);} // tgen
S2067C3 ::S2067C3(){ note_ctor("S2067C3", this);} // tgen

static void Test_S2067C3()
{
  extern Class_Descriptor cd_S2067C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S2067C3, buf);
    S2067C3 *dp, &lv = *(dp=new (buf) S2067C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S2067C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2067C3)");
    check_base_class_offset(lv, (S2067C4*), 0, "S2067C3");
    check_field_offset(lv, s2067c3f0, ABISELECT(40,28), "S2067C3.s2067c3f0");
    test_class_info(&lv, &cd_S2067C3);
    dp->~S2067C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2067C3(Test_S2067C3, "S2067C3", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S2067C3C1Ev();
extern void _ZN7S2067C3D1Ev();
Name_Map name_map_S2067C3[] = {
  NSPAIR(_ZN7S2067C3C1Ev),
  NSPAIR(_ZN7S2067C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2067C4;
extern VTBL_ENTRY _ZTI7S2067C4[];
extern  VTBL_ENTRY _ZTV7S2067C4[];
static Base_Class bases_S2067C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2067C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2067C3[];
extern void _ZN7S2067C3D1Ev();
extern void _ZN7S2067C3D0Ev();
extern void _ZN7S2067C42v2Ev();
extern void _ZN7S2067C42v3Ev();
extern void _ZN7S2067C42v4Ev();
extern void _ZN7S2067C32v5Ev();
extern void _ZN7S2067C32v6Ev();
static  VTBL_ENTRY vtc_S2067C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2067C3[0]),
  (VTBL_ENTRY)&_ZN7S2067C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2067C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v2Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2067C32v5Ev,
  (VTBL_ENTRY)&_ZN7S2067C32v6Ev,
};
extern VTBL_ENTRY _ZTI7S2067C3[];
extern  VTBL_ENTRY _ZTV7S2067C3[];
Class_Descriptor cd_S2067C3 = {  "S2067C3", // class name
  bases_S2067C3, 1,
  &(vtc_S2067C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S2067C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2067C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2067C2  : S2067C3 , S2071C7 {
  virtual  ~S2067C2(); // _ZN7S2067C2D1Ev
  virtual void  v7(); // _ZN7S2067C22v7Ev
  virtual void  v8(); // _ZN7S2067C22v8Ev
  S2067C2(); // tgen
};
//SIG(-1 S2067C2) C1{ BC2{ BC3{ vd v3 v4 v5 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v6 v7 Fp} BC6{ vd m Fi Fp FC7{ m Fp Fi FC8{ m}} Fp Fi} vd v1 v2}


 S2067C2 ::~S2067C2(){ note_dtor("S2067C2", this);}
void  S2067C2 ::v7(){vfunc_called(this, "_ZN7S2067C22v7Ev");}
void  S2067C2 ::v8(){vfunc_called(this, "_ZN7S2067C22v8Ev");}
S2067C2 ::S2067C2(){ note_ctor("S2067C2", this);} // tgen

static void Test_S2067C2()
{
  extern Class_Descriptor cd_S2067C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S2067C2, buf);
    S2067C2 *dp, &lv = *(dp=new (buf) S2067C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S2067C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2067C2)");
    check_base_class_offset(lv, (S2067C4*)(S2067C3*), 0, "S2067C2");
    check_base_class_offset(lv, (S2067C3*), 0, "S2067C2");
    check_base_class_offset(lv, (S2071C7*), ABISELECT(48,32), "S2067C2");
    test_class_info(&lv, &cd_S2067C2);
    dp->~S2067C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2067C2(Test_S2067C2, "S2067C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S2067C2C1Ev();
extern void _ZN7S2067C2D1Ev();
Name_Map name_map_S2067C2[] = {
  NSPAIR(_ZN7S2067C2C1Ev),
  NSPAIR(_ZN7S2067C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2067C4;
extern VTBL_ENTRY _ZTI7S2067C4[];
extern  VTBL_ENTRY _ZTV7S2067C4[];
extern Class_Descriptor cd_S2067C3;
extern VTBL_ENTRY _ZTI7S2067C3[];
extern  VTBL_ENTRY _ZTV7S2067C3[];
extern Class_Descriptor cd_S2071C7;
extern VTBL_ENTRY _ZTI7S2071C7[];
extern  VTBL_ENTRY _ZTV7S2071C7[];
static Base_Class bases_S2067C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2067C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2067C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2071C7,    ABISELECT(48,32), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2067C2[];
extern void _ZN7S2067C2D1Ev();
extern void _ZN7S2067C2D0Ev();
extern void _ZN7S2067C42v2Ev();
extern void _ZN7S2067C42v3Ev();
extern void _ZN7S2067C42v4Ev();
extern void _ZN7S2067C32v5Ev();
extern void _ZN7S2067C32v6Ev();
extern void _ZN7S2067C22v7Ev();
extern void _ZN7S2067C22v8Ev();
extern void ABISELECT(_ZThn48_N7S2067C2D1Ev,_ZThn32_N7S2067C2D1Ev)();
extern void ABISELECT(_ZThn48_N7S2067C2D0Ev,_ZThn32_N7S2067C2D0Ev)();
static  VTBL_ENTRY vtc_S2067C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2067C2[0]),
  (VTBL_ENTRY)&_ZN7S2067C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2067C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v2Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2067C32v5Ev,
  (VTBL_ENTRY)&_ZN7S2067C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2067C22v7Ev,
  (VTBL_ENTRY)&_ZN7S2067C22v8Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S2067C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2067C2D1Ev,_ZThn32_N7S2067C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2067C2D0Ev,_ZThn32_N7S2067C2D0Ev),
};
extern VTBL_ENTRY _ZTI7S2067C2[];
extern  VTBL_ENTRY _ZTV7S2067C2[];
Class_Descriptor cd_S2067C2 = {  "S2067C2", // class name
  bases_S2067C2, 3,
  &(vtc_S2067C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S2067C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2067C2),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2067C10  {
  int s2067c10f0[3];
  ::S17070C74_nt s2067c10f1;
  ::S17070C74_nt s2067c10f2;
  ::S17070C74_nt s2067c10f3;
  ::S17070C74_nt s2067c10f4;
  ::S17070C74_nt s2067c10f5;
  ::S17070C74_nt s2067c10f6;
  int s2067c10f7[7];
  ::S17070C74_nt s2067c10f8;
  void  mf2067c10(); // _ZN8S2067C109mf2067c10Ev
  virtual  ~S2067C10(); // _ZN8S2067C10D1Ev
  S2067C10(); // tgen
};
//SIG(-1 S2067C10) C1{ vd m Fi[3] FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC2 FC2 FC2 Fi[7] FC2}


void  S2067C10 ::mf2067c10(){}
 S2067C10 ::~S2067C10(){ note_dtor("S2067C10", this);}
S2067C10 ::S2067C10(){ note_ctor("S2067C10", this);} // tgen

static void Test_S2067C10()
{
  extern Class_Descriptor cd_S2067C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,33)];
    init_test(&cd_S2067C10, buf);
    S2067C10 *dp, &lv = *(dp=new (buf) S2067C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,128), "sizeof(S2067C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2067C10)");
    check_field_offset(lv, s2067c10f0, ABISELECT(8,4), "S2067C10.s2067c10f0");
    check_field_offset(lv, s2067c10f1, ABISELECT(24,16), "S2067C10.s2067c10f1");
    check_field_offset(lv, s2067c10f2, ABISELECT(40,28), "S2067C10.s2067c10f2");
    check_field_offset(lv, s2067c10f3, ABISELECT(56,40), "S2067C10.s2067c10f3");
    check_field_offset(lv, s2067c10f4, ABISELECT(72,52), "S2067C10.s2067c10f4");
    check_field_offset(lv, s2067c10f5, ABISELECT(88,64), "S2067C10.s2067c10f5");
    check_field_offset(lv, s2067c10f6, ABISELECT(104,76), "S2067C10.s2067c10f6");
    check_field_offset(lv, s2067c10f7, ABISELECT(120,88), "S2067C10.s2067c10f7");
    check_field_offset(lv, s2067c10f8, ABISELECT(152,116), "S2067C10.s2067c10f8");
    test_class_info(&lv, &cd_S2067C10);
    dp->~S2067C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2067C10(Test_S2067C10, "S2067C10", ABISELECT(168,128));

#else // __cplusplus

extern void _ZN8S2067C10C1Ev();
extern void _ZN8S2067C10D1Ev();
Name_Map name_map_S2067C10[] = {
  NSPAIR(_ZN8S2067C10C1Ev),
  NSPAIR(_ZN8S2067C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2067C10[];
extern void _ZN8S2067C10D1Ev();
extern void _ZN8S2067C10D0Ev();
static  VTBL_ENTRY vtc_S2067C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2067C10[0]),
  (VTBL_ENTRY)&_ZN8S2067C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2067C10D0Ev,
};
extern VTBL_ENTRY _ZTI8S2067C10[];
extern  VTBL_ENTRY _ZTV8S2067C10[];
Class_Descriptor cd_S2067C10 = {  "S2067C10", // class name
  0,0,//no base classes
  &(vtc_S2067C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,128), // object size
  NSPAIRA(_ZTI8S2067C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2067C10),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2067C11  {
  int s2067c11f0;
  ::S17070C74_nt s2067c11f1;
  ::S17070C74_nt s2067c11f2;
  ::S17070C74_nt s2067c11f3;
  int s2067c11f4[3];
  void  mf2067c11(); // _ZN8S2067C119mf2067c11Ev
  virtual  ~S2067C11(); // _ZN8S2067C11D1Ev
  S2067C11(); // tgen
};
//SIG(-1 S2067C11) C1{ vd m Fi FC2{ m Fp Fi FC3{ m}} FC2 FC2 Fi[3]}


void  S2067C11 ::mf2067c11(){}
 S2067C11 ::~S2067C11(){ note_dtor("S2067C11", this);}
S2067C11 ::S2067C11(){ note_ctor("S2067C11", this);} // tgen

static void Test_S2067C11()
{
  extern Class_Descriptor cd_S2067C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,15)];
    init_test(&cd_S2067C11, buf);
    S2067C11 *dp, &lv = *(dp=new (buf) S2067C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,56), "sizeof(S2067C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2067C11)");
    check_field_offset(lv, s2067c11f0, ABISELECT(8,4), "S2067C11.s2067c11f0");
    check_field_offset(lv, s2067c11f1, ABISELECT(16,8), "S2067C11.s2067c11f1");
    check_field_offset(lv, s2067c11f2, ABISELECT(32,20), "S2067C11.s2067c11f2");
    check_field_offset(lv, s2067c11f3, ABISELECT(48,32), "S2067C11.s2067c11f3");
    check_field_offset(lv, s2067c11f4, ABISELECT(64,44), "S2067C11.s2067c11f4");
    test_class_info(&lv, &cd_S2067C11);
    dp->~S2067C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2067C11(Test_S2067C11, "S2067C11", ABISELECT(80,56));

#else // __cplusplus

extern void _ZN8S2067C11C1Ev();
extern void _ZN8S2067C11D1Ev();
Name_Map name_map_S2067C11[] = {
  NSPAIR(_ZN8S2067C11C1Ev),
  NSPAIR(_ZN8S2067C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2067C11[];
extern void _ZN8S2067C11D1Ev();
extern void _ZN8S2067C11D0Ev();
static  VTBL_ENTRY vtc_S2067C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2067C11[0]),
  (VTBL_ENTRY)&_ZN8S2067C11D1Ev,
  (VTBL_ENTRY)&_ZN8S2067C11D0Ev,
};
extern VTBL_ENTRY _ZTI8S2067C11[];
extern  VTBL_ENTRY _ZTV8S2067C11[];
Class_Descriptor cd_S2067C11 = {  "S2067C11", // class name
  0,0,//no base classes
  &(vtc_S2067C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,56), // object size
  NSPAIRA(_ZTI8S2067C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2067C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2067C1  : S2067C2 {
  int s2067c1f0[2];
  ::S2067C10 s2067c1f1;
  ::S2067C11 s2067c1f2;
  ::S17070C30_nt s2067c1f3;
  virtual  ~S2067C1(); // _ZN7S2067C1D1Ev
  virtual void  v1(); // _ZN7S2067C12v1Ev
  S2067C1(); // tgen
};
//SIG(1 S2067C1) C1{ BC2{ BC3{ BC4{ vd v2 v3 v4 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v5 v6 Fp} BC7{ vd m Fi Fp FC8{ m Fp Fi FC9{ m}} Fp Fi} vd v7 v8} vd v1 Fi[2] FC10{ vd m Fi[3] FC5 FC5 FC5 FC5 FC5 FC5 Fi[7] FC5} FC11{ vd m Fi FC5 FC5 FC5 Fi[3]} FC12{ m Fp Fi[2] FC6}}


 S2067C1 ::~S2067C1(){ note_dtor("S2067C1", this);}
void  S2067C1 ::v1(){vfunc_called(this, "_ZN7S2067C12v1Ev");}
S2067C1 ::S2067C1(){ note_ctor("S2067C1", this);} // tgen

static void Test_S2067C1()
{
  extern Class_Descriptor cd_S2067C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,69)];
    init_test(&cd_S2067C1, buf);
    S2067C1 *dp, &lv = *(dp=new (buf) S2067C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,272), "sizeof(S2067C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2067C1)");
    check_base_class_offset(lv, (S2067C4*)(S2067C3*)(S2067C2*), 0, "S2067C1");
    check_base_class_offset(lv, (S2067C3*)(S2067C2*), 0, "S2067C1");
    check_base_class_offset(lv, (S2071C7*)(S2067C2*), ABISELECT(48,32), "S2067C1");
    check_base_class_offset(lv, (S2067C2*), 0, "S2067C1");
    check_field_offset(lv, s2067c1f0, ABISELECT(100,64), "S2067C1.s2067c1f0");
    check_field_offset(lv, s2067c1f1, ABISELECT(112,72), "S2067C1.s2067c1f1");
    check_field_offset(lv, s2067c1f2, ABISELECT(280,200), "S2067C1.s2067c1f2");
    check_field_offset(lv, s2067c1f3, ABISELECT(360,256), "S2067C1.s2067c1f3");
    test_class_info(&lv, &cd_S2067C1);
    dp->~S2067C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2067C1(Test_S2067C1, "S2067C1", ABISELECT(384,272));

#else // __cplusplus

extern void _ZN7S2067C1C1Ev();
extern void _ZN7S2067C1D1Ev();
Name_Map name_map_S2067C1[] = {
  NSPAIR(_ZN7S2067C1C1Ev),
  NSPAIR(_ZN7S2067C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2067C4;
extern VTBL_ENTRY _ZTI7S2067C4[];
extern  VTBL_ENTRY _ZTV7S2067C4[];
extern Class_Descriptor cd_S2067C3;
extern VTBL_ENTRY _ZTI7S2067C3[];
extern  VTBL_ENTRY _ZTV7S2067C3[];
extern Class_Descriptor cd_S2071C7;
extern VTBL_ENTRY _ZTI7S2071C7[];
extern  VTBL_ENTRY _ZTV7S2071C7[];
extern Class_Descriptor cd_S2067C2;
extern VTBL_ENTRY _ZTI7S2067C2[];
extern  VTBL_ENTRY _ZTV7S2067C2[];
static Base_Class bases_S2067C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2067C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2067C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2071C7,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2067C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2067C1[];
extern void _ZN7S2067C1D1Ev();
extern void _ZN7S2067C1D0Ev();
extern void _ZN7S2067C42v2Ev();
extern void _ZN7S2067C42v3Ev();
extern void _ZN7S2067C42v4Ev();
extern void _ZN7S2067C32v5Ev();
extern void _ZN7S2067C32v6Ev();
extern void _ZN7S2067C22v7Ev();
extern void _ZN7S2067C22v8Ev();
extern void _ZN7S2067C12v1Ev();
extern void ABISELECT(_ZThn48_N7S2067C1D1Ev,_ZThn32_N7S2067C1D1Ev)();
extern void ABISELECT(_ZThn48_N7S2067C1D0Ev,_ZThn32_N7S2067C1D0Ev)();
static  VTBL_ENTRY vtc_S2067C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2067C1[0]),
  (VTBL_ENTRY)&_ZN7S2067C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2067C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v2Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2067C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2067C32v5Ev,
  (VTBL_ENTRY)&_ZN7S2067C32v6Ev,
  (VTBL_ENTRY)&_ZN7S2067C22v7Ev,
  (VTBL_ENTRY)&_ZN7S2067C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2067C12v1Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S2067C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2067C1D1Ev,_ZThn32_N7S2067C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S2067C1D0Ev,_ZThn32_N7S2067C1D0Ev),
};
extern VTBL_ENTRY _ZTI7S2067C1[];
extern  VTBL_ENTRY _ZTV7S2067C1[];
Class_Descriptor cd_S2067C1 = {  "S2067C1", // class name
  bases_S2067C1, 4,
  &(vtc_S2067C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,272), // object size
  NSPAIRA(_ZTI7S2067C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2067C1),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S869C5  {
  ::S17070C74_nt s869c5f0;
  int s869c5f1[2];
  char s869c5f2;
  virtual  ~S869C5(); // _ZN6S869C5D1Ev
  virtual void  v2(); // _ZN6S869C52v2Ev
  virtual void  v3(); // _ZN6S869C52v3Ev
  virtual void  v4(); // _ZN6S869C52v4Ev
  S869C5(); // tgen
};
//SIG(-1 S869C5) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S869C5 ::~S869C5(){ note_dtor("S869C5", this);}
void  S869C5 ::v2(){vfunc_called(this, "_ZN6S869C52v2Ev");}
void  S869C5 ::v3(){vfunc_called(this, "_ZN6S869C52v3Ev");}
void  S869C5 ::v4(){vfunc_called(this, "_ZN6S869C52v4Ev");}
S869C5 ::S869C5(){ note_ctor("S869C5", this);} // tgen

static void Test_S869C5()
{
  extern Class_Descriptor cd_S869C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S869C5, buf);
    S869C5 *dp, &lv = *(dp=new (buf) S869C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S869C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S869C5)");
    check_field_offset(lv, s869c5f0, ABISELECT(8,4), "S869C5.s869c5f0");
    check_field_offset(lv, s869c5f1, ABISELECT(24,16), "S869C5.s869c5f1");
    check_field_offset(lv, s869c5f2, ABISELECT(32,24), "S869C5.s869c5f2");
    test_class_info(&lv, &cd_S869C5);
    dp->~S869C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS869C5(Test_S869C5, "S869C5", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6S869C5C1Ev();
extern void _ZN6S869C5D1Ev();
Name_Map name_map_S869C5[] = {
  NSPAIR(_ZN6S869C5C1Ev),
  NSPAIR(_ZN6S869C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S869C5[];
extern void _ZN6S869C5D1Ev();
extern void _ZN6S869C5D0Ev();
extern void _ZN6S869C52v2Ev();
extern void _ZN6S869C52v3Ev();
extern void _ZN6S869C52v4Ev();
static  VTBL_ENTRY vtc_S869C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S869C5[0]),
  (VTBL_ENTRY)&_ZN6S869C5D1Ev,
  (VTBL_ENTRY)&_ZN6S869C5D0Ev,
  (VTBL_ENTRY)&_ZN6S869C52v2Ev,
  (VTBL_ENTRY)&_ZN6S869C52v3Ev,
  (VTBL_ENTRY)&_ZN6S869C52v4Ev,
};
extern VTBL_ENTRY _ZTI6S869C5[];
extern  VTBL_ENTRY _ZTV6S869C5[];
Class_Descriptor cd_S869C5 = {  "S869C5", // class name
  0,0,//no base classes
  &(vtc_S869C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6S869C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S869C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S869C4  : S869C5 {
  void *s869c4f0;
  virtual void  v5(); // _ZN6S869C42v5Ev
  virtual void  v6(); // _ZN6S869C42v6Ev
  ~S869C4(); // tgen
  S869C4(); // tgen
};
//SIG(-1 S869C4) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S869C4 ::v5(){vfunc_called(this, "_ZN6S869C42v5Ev");}
void  S869C4 ::v6(){vfunc_called(this, "_ZN6S869C42v6Ev");}
S869C4 ::~S869C4(){ note_dtor("S869C4", this);} // tgen
S869C4 ::S869C4(){ note_ctor("S869C4", this);} // tgen

static void Test_S869C4()
{
  extern Class_Descriptor cd_S869C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S869C4, buf);
    S869C4 *dp, &lv = *(dp=new (buf) S869C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S869C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S869C4)");
    check_base_class_offset(lv, (S869C5*), 0, "S869C4");
    check_field_offset(lv, s869c4f0, ABISELECT(40,28), "S869C4.s869c4f0");
    test_class_info(&lv, &cd_S869C4);
    dp->~S869C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS869C4(Test_S869C4, "S869C4", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S869C4C1Ev();
extern void _ZN6S869C4D1Ev();
Name_Map name_map_S869C4[] = {
  NSPAIR(_ZN6S869C4C1Ev),
  NSPAIR(_ZN6S869C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S869C5;
extern VTBL_ENTRY _ZTI6S869C5[];
extern  VTBL_ENTRY _ZTV6S869C5[];
static Base_Class bases_S869C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S869C4[];
extern void _ZN6S869C4D1Ev();
extern void _ZN6S869C4D0Ev();
extern void _ZN6S869C52v2Ev();
extern void _ZN6S869C52v3Ev();
extern void _ZN6S869C52v4Ev();
extern void _ZN6S869C42v5Ev();
extern void _ZN6S869C42v6Ev();
static  VTBL_ENTRY vtc_S869C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S869C4[0]),
  (VTBL_ENTRY)&_ZN6S869C4D1Ev,
  (VTBL_ENTRY)&_ZN6S869C4D0Ev,
  (VTBL_ENTRY)&_ZN6S869C52v2Ev,
  (VTBL_ENTRY)&_ZN6S869C52v3Ev,
  (VTBL_ENTRY)&_ZN6S869C52v4Ev,
  (VTBL_ENTRY)&_ZN6S869C42v5Ev,
  (VTBL_ENTRY)&_ZN6S869C42v6Ev,
};
extern VTBL_ENTRY _ZTI6S869C4[];
extern  VTBL_ENTRY _ZTV6S869C4[];
Class_Descriptor cd_S869C4 = {  "S869C4", // class name
  bases_S869C4, 1,
  &(vtc_S869C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S869C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S869C4),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S869C3  : S869C4 {
  void *s869c3f0;
  ::S2165C7_nt s869c3f1;
  void *s869c3f2;
  int s869c3f3;
  ::S17070C21_nt s869c3f4;
  ::S17070C21_nt s869c3f5;
  int s869c3f6[2];
  virtual  ~S869C3(); // _ZN6S869C3D1Ev
  virtual void  v7(); // _ZN6S869C32v7Ev
  S869C3(); // tgen
};
//SIG(-1 S869C3) C1{ BC2{ BC3{ vd v2 v3 v4 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v5 v6 Fp} vd v1 Fp FC6{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC7{ m FC8{ m Fi[2]} FC9{ m Fi[2]}} FC9 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC10{ m Fp} FC10 Fi[2]}


 S869C3 ::~S869C3(){ note_dtor("S869C3", this);}
void  S869C3 ::v7(){vfunc_called(this, "_ZN6S869C32v7Ev");}
S869C3 ::S869C3(){ note_ctor("S869C3", this);} // tgen

static void Test_S869C3()
{
  extern Class_Descriptor cd_S869C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,53)];
    init_test(&cd_S869C3, buf);
    S869C3 *dp, &lv = *(dp=new (buf) S869C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S869C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S869C3)");
    check_base_class_offset(lv, (S869C5*)(S869C4*), 0, "S869C3");
    check_base_class_offset(lv, (S869C4*), 0, "S869C3");
    check_field_offset(lv, s869c3f0, ABISELECT(48,32), "S869C3.s869c3f0");
    check_field_offset(lv, s869c3f1, ABISELECT(56,36), "S869C3.s869c3f1");
    check_field_offset(lv, s869c3f2, ABISELECT(264,184), "S869C3.s869c3f2");
    check_field_offset(lv, s869c3f3, ABISELECT(272,188), "S869C3.s869c3f3");
    check_field_offset(lv, s869c3f4, ABISELECT(280,192), "S869C3.s869c3f4");
    check_field_offset(lv, s869c3f5, ABISELECT(288,196), "S869C3.s869c3f5");
    check_field_offset(lv, s869c3f6, ABISELECT(296,200), "S869C3.s869c3f6");
    test_class_info(&lv, &cd_S869C3);
    dp->~S869C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS869C3(Test_S869C3, "S869C3", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN6S869C3C1Ev();
extern void _ZN6S869C3D1Ev();
Name_Map name_map_S869C3[] = {
  NSPAIR(_ZN6S869C3C1Ev),
  NSPAIR(_ZN6S869C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S869C5;
extern VTBL_ENTRY _ZTI6S869C5[];
extern  VTBL_ENTRY _ZTV6S869C5[];
extern Class_Descriptor cd_S869C4;
extern VTBL_ENTRY _ZTI6S869C4[];
extern  VTBL_ENTRY _ZTV6S869C4[];
static Base_Class bases_S869C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S869C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S869C3[];
extern void _ZN6S869C3D1Ev();
extern void _ZN6S869C3D0Ev();
extern void _ZN6S869C52v2Ev();
extern void _ZN6S869C52v3Ev();
extern void _ZN6S869C52v4Ev();
extern void _ZN6S869C42v5Ev();
extern void _ZN6S869C42v6Ev();
extern void _ZN6S869C32v7Ev();
static  VTBL_ENTRY vtc_S869C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S869C3[0]),
  (VTBL_ENTRY)&_ZN6S869C3D1Ev,
  (VTBL_ENTRY)&_ZN6S869C3D0Ev,
  (VTBL_ENTRY)&_ZN6S869C52v2Ev,
  (VTBL_ENTRY)&_ZN6S869C52v3Ev,
  (VTBL_ENTRY)&_ZN6S869C52v4Ev,
  (VTBL_ENTRY)&_ZN6S869C42v5Ev,
  (VTBL_ENTRY)&_ZN6S869C42v6Ev,
  (VTBL_ENTRY)&_ZN6S869C32v7Ev,
};
extern VTBL_ENTRY _ZTI6S869C3[];
extern  VTBL_ENTRY _ZTV6S869C3[];
Class_Descriptor cd_S869C3 = {  "S869C3", // class name
  bases_S869C3, 2,
  &(vtc_S869C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI6S869C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S869C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S869C2  : S869C3 {
  __tsi64 s869c2f0;
  int s869c2f1[7];
  virtual void  v8(); // _ZN6S869C22v8Ev
  virtual void  v9(); // _ZN6S869C22v9Ev
  virtual void  v10(); // _ZN6S869C23v10Ev
  ~S869C2(); // tgen
  S869C2(); // tgen
};
//SIG(-1 S869C2) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} v7 v8 Fp} vd v9 Fp FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC11{ m Fp} FC11 Fi[2]} v1 v2 v3 FL Fi[7]}


void  S869C2 ::v8(){vfunc_called(this, "_ZN6S869C22v8Ev");}
void  S869C2 ::v9(){vfunc_called(this, "_ZN6S869C22v9Ev");}
void  S869C2 ::v10(){vfunc_called(this, "_ZN6S869C23v10Ev");}
S869C2 ::~S869C2(){ note_dtor("S869C2", this);} // tgen
S869C2 ::S869C2(){ note_ctor("S869C2", this);} // tgen

static void Test_S869C2()
{
  extern Class_Descriptor cd_S869C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,62)];
    init_test(&cd_S869C2, buf);
    S869C2 *dp, &lv = *(dp=new (buf) S869C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,244), "sizeof(S869C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S869C2)");
    check_base_class_offset(lv, (S869C5*)(S869C4*)(S869C3*), 0, "S869C2");
    check_base_class_offset(lv, (S869C4*)(S869C3*), 0, "S869C2");
    check_base_class_offset(lv, (S869C3*), 0, "S869C2");
    check_field_offset(lv, s869c2f0, ABISELECT(304,208), "S869C2.s869c2f0");
    check_field_offset(lv, s869c2f1, ABISELECT(312,216), "S869C2.s869c2f1");
    test_class_info(&lv, &cd_S869C2);
    dp->~S869C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS869C2(Test_S869C2, "S869C2", ABISELECT(344,244));

#else // __cplusplus

extern void _ZN6S869C2C1Ev();
extern void _ZN6S869C2D1Ev();
Name_Map name_map_S869C2[] = {
  NSPAIR(_ZN6S869C2C1Ev),
  NSPAIR(_ZN6S869C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S869C5;
extern VTBL_ENTRY _ZTI6S869C5[];
extern  VTBL_ENTRY _ZTV6S869C5[];
extern Class_Descriptor cd_S869C4;
extern VTBL_ENTRY _ZTI6S869C4[];
extern  VTBL_ENTRY _ZTV6S869C4[];
extern Class_Descriptor cd_S869C3;
extern VTBL_ENTRY _ZTI6S869C3[];
extern  VTBL_ENTRY _ZTV6S869C3[];
static Base_Class bases_S869C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S869C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S869C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S869C2[];
extern void _ZN6S869C2D1Ev();
extern void _ZN6S869C2D0Ev();
extern void _ZN6S869C52v2Ev();
extern void _ZN6S869C52v3Ev();
extern void _ZN6S869C52v4Ev();
extern void _ZN6S869C42v5Ev();
extern void _ZN6S869C42v6Ev();
extern void _ZN6S869C32v7Ev();
extern void _ZN6S869C22v8Ev();
extern void _ZN6S869C22v9Ev();
extern void _ZN6S869C23v10Ev();
static  VTBL_ENTRY vtc_S869C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S869C2[0]),
  (VTBL_ENTRY)&_ZN6S869C2D1Ev,
  (VTBL_ENTRY)&_ZN6S869C2D0Ev,
  (VTBL_ENTRY)&_ZN6S869C52v2Ev,
  (VTBL_ENTRY)&_ZN6S869C52v3Ev,
  (VTBL_ENTRY)&_ZN6S869C52v4Ev,
  (VTBL_ENTRY)&_ZN6S869C42v5Ev,
  (VTBL_ENTRY)&_ZN6S869C42v6Ev,
  (VTBL_ENTRY)&_ZN6S869C32v7Ev,
  (VTBL_ENTRY)&_ZN6S869C22v8Ev,
  (VTBL_ENTRY)&_ZN6S869C22v9Ev,
  (VTBL_ENTRY)&_ZN6S869C23v10Ev,
};
extern VTBL_ENTRY _ZTI6S869C2[];
extern  VTBL_ENTRY _ZTV6S869C2[];
Class_Descriptor cd_S869C2 = {  "S869C2", // class name
  bases_S869C2, 3,
  &(vtc_S869C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(344,244), // object size
  NSPAIRA(_ZTI6S869C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S869C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S869C1  : S869C2 {
  void *s869c1f0;
  virtual void  v1(); // _ZN6S869C12v1Ev
  ~S869C1(); // tgen
  S869C1(); // tgen
};
//SIG(1 S869C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v2 v3 v4 FC6{ m Fp Fi FC7{ m}} Fi[2] Fc} v5 v6 Fp} vd v7 Fp FC8{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC9{ m FC10{ m Fi[2]} FC11{ m Fi[2]}} FC11 Fc Fi[3] Fc Fi[6] Fc} Fp Fi FC12{ m Fp} FC12 Fi[2]} v8 v9 v10 FL Fi[7]} v1 Fp}


void  S869C1 ::v1(){vfunc_called(this, "_ZN6S869C12v1Ev");}
S869C1 ::~S869C1(){ note_dtor("S869C1", this);} // tgen
S869C1 ::S869C1(){ note_ctor("S869C1", this);} // tgen

static void Test_S869C1()
{
  extern Class_Descriptor cd_S869C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,63)];
    init_test(&cd_S869C1, buf);
    S869C1 *dp, &lv = *(dp=new (buf) S869C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,248), "sizeof(S869C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S869C1)");
    check_base_class_offset(lv, (S869C5*)(S869C4*)(S869C3*)(S869C2*), 0, "S869C1");
    check_base_class_offset(lv, (S869C4*)(S869C3*)(S869C2*), 0, "S869C1");
    check_base_class_offset(lv, (S869C3*)(S869C2*), 0, "S869C1");
    check_base_class_offset(lv, (S869C2*), 0, "S869C1");
    check_field_offset(lv, s869c1f0, ABISELECT(344,244), "S869C1.s869c1f0");
    test_class_info(&lv, &cd_S869C1);
    dp->~S869C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS869C1(Test_S869C1, "S869C1", ABISELECT(352,248));

#else // __cplusplus

extern void _ZN6S869C1C1Ev();
extern void _ZN6S869C1D1Ev();
Name_Map name_map_S869C1[] = {
  NSPAIR(_ZN6S869C1C1Ev),
  NSPAIR(_ZN6S869C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S869C5;
extern VTBL_ENTRY _ZTI6S869C5[];
extern  VTBL_ENTRY _ZTV6S869C5[];
extern Class_Descriptor cd_S869C4;
extern VTBL_ENTRY _ZTI6S869C4[];
extern  VTBL_ENTRY _ZTV6S869C4[];
extern Class_Descriptor cd_S869C3;
extern VTBL_ENTRY _ZTI6S869C3[];
extern  VTBL_ENTRY _ZTV6S869C3[];
extern Class_Descriptor cd_S869C2;
extern VTBL_ENTRY _ZTI6S869C2[];
extern  VTBL_ENTRY _ZTV6S869C2[];
static Base_Class bases_S869C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S869C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S869C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S869C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S869C1[];
extern void _ZN6S869C1D1Ev();
extern void _ZN6S869C1D0Ev();
extern void _ZN6S869C52v2Ev();
extern void _ZN6S869C52v3Ev();
extern void _ZN6S869C52v4Ev();
extern void _ZN6S869C42v5Ev();
extern void _ZN6S869C42v6Ev();
extern void _ZN6S869C32v7Ev();
extern void _ZN6S869C22v8Ev();
extern void _ZN6S869C22v9Ev();
extern void _ZN6S869C23v10Ev();
extern void _ZN6S869C12v1Ev();
static  VTBL_ENTRY vtc_S869C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S869C1[0]),
  (VTBL_ENTRY)&_ZN6S869C1D1Ev,
  (VTBL_ENTRY)&_ZN6S869C1D0Ev,
  (VTBL_ENTRY)&_ZN6S869C52v2Ev,
  (VTBL_ENTRY)&_ZN6S869C52v3Ev,
  (VTBL_ENTRY)&_ZN6S869C52v4Ev,
  (VTBL_ENTRY)&_ZN6S869C42v5Ev,
  (VTBL_ENTRY)&_ZN6S869C42v6Ev,
  (VTBL_ENTRY)&_ZN6S869C32v7Ev,
  (VTBL_ENTRY)&_ZN6S869C22v8Ev,
  (VTBL_ENTRY)&_ZN6S869C22v9Ev,
  (VTBL_ENTRY)&_ZN6S869C23v10Ev,
  (VTBL_ENTRY)&_ZN6S869C12v1Ev,
};
extern VTBL_ENTRY _ZTI6S869C1[];
extern  VTBL_ENTRY _ZTV6S869C1[];
Class_Descriptor cd_S869C1 = {  "S869C1", // class name
  bases_S869C1, 4,
  &(vtc_S869C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,248), // object size
  NSPAIRA(_ZTI6S869C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S869C1),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4738C3  {
  ::S17070C74_nt s4738c3f0;
  int s4738c3f1[2];
  char s4738c3f2;
  virtual  ~S4738C3(); // _ZN7S4738C3D1Ev
  virtual void  v3(); // _ZN7S4738C32v3Ev
  virtual void  v4(); // _ZN7S4738C32v4Ev
  virtual void  v5(); // _ZN7S4738C32v5Ev
  S4738C3(); // tgen
};
//SIG(-1 S4738C3) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S4738C3 ::~S4738C3(){ note_dtor("S4738C3", this);}
void  S4738C3 ::v3(){vfunc_called(this, "_ZN7S4738C32v3Ev");}
void  S4738C3 ::v4(){vfunc_called(this, "_ZN7S4738C32v4Ev");}
void  S4738C3 ::v5(){vfunc_called(this, "_ZN7S4738C32v5Ev");}
S4738C3 ::S4738C3(){ note_ctor("S4738C3", this);} // tgen

static void Test_S4738C3()
{
  extern Class_Descriptor cd_S4738C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S4738C3, buf);
    S4738C3 *dp, &lv = *(dp=new (buf) S4738C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S4738C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4738C3)");
    check_field_offset(lv, s4738c3f0, ABISELECT(8,4), "S4738C3.s4738c3f0");
    check_field_offset(lv, s4738c3f1, ABISELECT(24,16), "S4738C3.s4738c3f1");
    check_field_offset(lv, s4738c3f2, ABISELECT(32,24), "S4738C3.s4738c3f2");
    test_class_info(&lv, &cd_S4738C3);
    dp->~S4738C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4738C3(Test_S4738C3, "S4738C3", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S4738C3C1Ev();
extern void _ZN7S4738C3D1Ev();
Name_Map name_map_S4738C3[] = {
  NSPAIR(_ZN7S4738C3C1Ev),
  NSPAIR(_ZN7S4738C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4738C3[];
extern void _ZN7S4738C3D1Ev();
extern void _ZN7S4738C3D0Ev();
extern void _ZN7S4738C32v3Ev();
extern void _ZN7S4738C32v4Ev();
extern void _ZN7S4738C32v5Ev();
static  VTBL_ENTRY vtc_S4738C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4738C3[0]),
  (VTBL_ENTRY)&_ZN7S4738C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4738C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v3Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v4Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v5Ev,
};
extern VTBL_ENTRY _ZTI7S4738C3[];
extern  VTBL_ENTRY _ZTV7S4738C3[];
Class_Descriptor cd_S4738C3 = {  "S4738C3", // class name
  0,0,//no base classes
  &(vtc_S4738C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S4738C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4738C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4738C2  : S4738C3 {
  void *s4738c2f0;
  virtual void  v6(); // _ZN7S4738C22v6Ev
  virtual void  v7(); // _ZN7S4738C22v7Ev
  ~S4738C2(); // tgen
  S4738C2(); // tgen
};
//SIG(-1 S4738C2) C1{ BC2{ vd v3 v4 v5 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} v1 v2 Fp}


void  S4738C2 ::v6(){vfunc_called(this, "_ZN7S4738C22v6Ev");}
void  S4738C2 ::v7(){vfunc_called(this, "_ZN7S4738C22v7Ev");}
S4738C2 ::~S4738C2(){ note_dtor("S4738C2", this);} // tgen
S4738C2 ::S4738C2(){ note_ctor("S4738C2", this);} // tgen

static void Test_S4738C2()
{
  extern Class_Descriptor cd_S4738C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S4738C2, buf);
    S4738C2 *dp, &lv = *(dp=new (buf) S4738C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S4738C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4738C2)");
    check_base_class_offset(lv, (S4738C3*), 0, "S4738C2");
    check_field_offset(lv, s4738c2f0, ABISELECT(40,28), "S4738C2.s4738c2f0");
    test_class_info(&lv, &cd_S4738C2);
    dp->~S4738C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4738C2(Test_S4738C2, "S4738C2", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S4738C2C1Ev();
extern void _ZN7S4738C2D1Ev();
Name_Map name_map_S4738C2[] = {
  NSPAIR(_ZN7S4738C2C1Ev),
  NSPAIR(_ZN7S4738C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4738C3;
extern VTBL_ENTRY _ZTI7S4738C3[];
extern  VTBL_ENTRY _ZTV7S4738C3[];
static Base_Class bases_S4738C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4738C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4738C2[];
extern void _ZN7S4738C2D1Ev();
extern void _ZN7S4738C2D0Ev();
extern void _ZN7S4738C32v3Ev();
extern void _ZN7S4738C32v4Ev();
extern void _ZN7S4738C32v5Ev();
extern void _ZN7S4738C22v6Ev();
extern void _ZN7S4738C22v7Ev();
static  VTBL_ENTRY vtc_S4738C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4738C2[0]),
  (VTBL_ENTRY)&_ZN7S4738C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4738C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v3Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v4Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v5Ev,
  (VTBL_ENTRY)&_ZN7S4738C22v6Ev,
  (VTBL_ENTRY)&_ZN7S4738C22v7Ev,
};
extern VTBL_ENTRY _ZTI7S4738C2[];
extern  VTBL_ENTRY _ZTV7S4738C2[];
Class_Descriptor cd_S4738C2 = {  "S4738C2", // class name
  bases_S4738C2, 1,
  &(vtc_S4738C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S4738C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4738C2),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4738C1  : S4738C2 {
  ::S17070C21_nt s4738c1f0;
  void *s4738c1f1[3];
  ::S2165C7_nt s4738c1f2;
  int s4738c1f3;
  ::S17070C17_nt s4738c1f4;
  ::S909C13_nt s4738c1f5;
  ::S909C13_nt s4738c1f6;
  __tsi64 s4738c1f7;
  void *s4738c1f8;
  int s4738c1f9;
  virtual void  v1(); // _ZN7S4738C12v1Ev
  virtual void  v2(); // _ZN7S4738C12v2Ev
  ~S4738C1(); // tgen
  S4738C1(); // tgen
};
//SIG(1 S4738C1) C1{ BC2{ BC3{ vd v3 v4 v5 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} v6 v7 Fp} v1 v2 FC6{ m Fp} Fp[3] FC7{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC8{ m FC9{ m Fi[2]} FC10{ m Fi[2]}} FC10 Fc Fi[3] Fc Fi[6] Fc} Fi FC11{ m FC12{ m FL[2]}} FC13{ m Fp} FC13 FL Fp Fi}


void  S4738C1 ::v1(){vfunc_called(this, "_ZN7S4738C12v1Ev");}
void  S4738C1 ::v2(){vfunc_called(this, "_ZN7S4738C12v2Ev");}
S4738C1 ::~S4738C1(){ note_dtor("S4738C1", this);} // tgen
S4738C1 ::S4738C1(){ note_ctor("S4738C1", this);} // tgen

static void Test_S4738C1()
{
  extern Class_Descriptor cd_S4738C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,61)];
    init_test(&cd_S4738C1, buf);
    S4738C1 *dp, &lv = *(dp=new (buf) S4738C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,240), "sizeof(S4738C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4738C1)");
    check_base_class_offset(lv, (S4738C3*)(S4738C2*), 0, "S4738C1");
    check_base_class_offset(lv, (S4738C2*), 0, "S4738C1");
    check_field_offset(lv, s4738c1f0, ABISELECT(48,32), "S4738C1.s4738c1f0");
    check_field_offset(lv, s4738c1f1, ABISELECT(56,36), "S4738C1.s4738c1f1");
    check_field_offset(lv, s4738c1f2, ABISELECT(80,48), "S4738C1.s4738c1f2");
    check_field_offset(lv, s4738c1f3, ABISELECT(288,196), "S4738C1.s4738c1f3");
    check_field_offset(lv, s4738c1f4, ABISELECT(296,200), "S4738C1.s4738c1f4");
    check_field_offset(lv, s4738c1f5, ABISELECT(312,216), "S4738C1.s4738c1f5");
    check_field_offset(lv, s4738c1f6, ABISELECT(320,220), "S4738C1.s4738c1f6");
    check_field_offset(lv, s4738c1f7, ABISELECT(328,224), "S4738C1.s4738c1f7");
    check_field_offset(lv, s4738c1f8, ABISELECT(336,232), "S4738C1.s4738c1f8");
    check_field_offset(lv, s4738c1f9, ABISELECT(344,236), "S4738C1.s4738c1f9");
    test_class_info(&lv, &cd_S4738C1);
    dp->~S4738C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4738C1(Test_S4738C1, "S4738C1", ABISELECT(352,240));

#else // __cplusplus

extern void _ZN7S4738C1C1Ev();
extern void _ZN7S4738C1D1Ev();
Name_Map name_map_S4738C1[] = {
  NSPAIR(_ZN7S4738C1C1Ev),
  NSPAIR(_ZN7S4738C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4738C3;
extern VTBL_ENTRY _ZTI7S4738C3[];
extern  VTBL_ENTRY _ZTV7S4738C3[];
extern Class_Descriptor cd_S4738C2;
extern VTBL_ENTRY _ZTI7S4738C2[];
extern  VTBL_ENTRY _ZTV7S4738C2[];
static Base_Class bases_S4738C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4738C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4738C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4738C1[];
extern void _ZN7S4738C1D1Ev();
extern void _ZN7S4738C1D0Ev();
extern void _ZN7S4738C32v3Ev();
extern void _ZN7S4738C32v4Ev();
extern void _ZN7S4738C32v5Ev();
extern void _ZN7S4738C22v6Ev();
extern void _ZN7S4738C22v7Ev();
extern void _ZN7S4738C12v1Ev();
extern void _ZN7S4738C12v2Ev();
static  VTBL_ENTRY vtc_S4738C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4738C1[0]),
  (VTBL_ENTRY)&_ZN7S4738C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4738C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v3Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v4Ev,
  (VTBL_ENTRY)&_ZN7S4738C32v5Ev,
  (VTBL_ENTRY)&_ZN7S4738C22v6Ev,
  (VTBL_ENTRY)&_ZN7S4738C22v7Ev,
  (VTBL_ENTRY)&_ZN7S4738C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4738C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S4738C1[];
extern  VTBL_ENTRY _ZTV7S4738C1[];
Class_Descriptor cd_S4738C1 = {  "S4738C1", // class name
  bases_S4738C1, 2,
  &(vtc_S4738C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,240), // object size
  NSPAIRA(_ZTI7S4738C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4738C1),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4755C3  {
  ::S17070C74_nt s4755c3f0;
  int s4755c3f1[2];
  char s4755c3f2;
  virtual  ~S4755C3(); // _ZN7S4755C3D1Ev
  virtual void  v3(); // _ZN7S4755C32v3Ev
  virtual void  v4(); // _ZN7S4755C32v4Ev
  virtual void  v5(); // _ZN7S4755C32v5Ev
  S4755C3(); // tgen
};
//SIG(-1 S4755C3) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S4755C3 ::~S4755C3(){ note_dtor("S4755C3", this);}
void  S4755C3 ::v3(){vfunc_called(this, "_ZN7S4755C32v3Ev");}
void  S4755C3 ::v4(){vfunc_called(this, "_ZN7S4755C32v4Ev");}
void  S4755C3 ::v5(){vfunc_called(this, "_ZN7S4755C32v5Ev");}
S4755C3 ::S4755C3(){ note_ctor("S4755C3", this);} // tgen

static void Test_S4755C3()
{
  extern Class_Descriptor cd_S4755C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S4755C3, buf);
    S4755C3 *dp, &lv = *(dp=new (buf) S4755C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S4755C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4755C3)");
    check_field_offset(lv, s4755c3f0, ABISELECT(8,4), "S4755C3.s4755c3f0");
    check_field_offset(lv, s4755c3f1, ABISELECT(24,16), "S4755C3.s4755c3f1");
    check_field_offset(lv, s4755c3f2, ABISELECT(32,24), "S4755C3.s4755c3f2");
    test_class_info(&lv, &cd_S4755C3);
    dp->~S4755C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4755C3(Test_S4755C3, "S4755C3", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S4755C3C1Ev();
extern void _ZN7S4755C3D1Ev();
Name_Map name_map_S4755C3[] = {
  NSPAIR(_ZN7S4755C3C1Ev),
  NSPAIR(_ZN7S4755C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4755C3[];
extern void _ZN7S4755C3D1Ev();
extern void _ZN7S4755C3D0Ev();
extern void _ZN7S4755C32v3Ev();
extern void _ZN7S4755C32v4Ev();
extern void _ZN7S4755C32v5Ev();
static  VTBL_ENTRY vtc_S4755C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4755C3[0]),
  (VTBL_ENTRY)&_ZN7S4755C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4755C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4755C32v3Ev,
  (VTBL_ENTRY)&_ZN7S4755C32v4Ev,
  (VTBL_ENTRY)&_ZN7S4755C32v5Ev,
};
extern VTBL_ENTRY _ZTI7S4755C3[];
extern  VTBL_ENTRY _ZTV7S4755C3[];
Class_Descriptor cd_S4755C3 = {  "S4755C3", // class name
  0,0,//no base classes
  &(vtc_S4755C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S4755C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4755C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // al