// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S17044C4  {
  virtual  ~S17044C4(); // _ZN8S17044C4D1Ev
  virtual void  v8(); // _ZN8S17044C42v8Ev
  virtual void  v9(); // _ZN8S17044C42v9Ev
  virtual void  v10(); // _ZN8S17044C43v10Ev
  virtual void  v11(); // _ZN8S17044C43v11Ev
  virtual void  v12(); // _ZN8S17044C43v12Ev
  S17044C4(); // tgen
};
//SIG(-1 S17044C4) C1{ vd v1 v2 v3 v4 v5}


 S17044C4 ::~S17044C4(){ note_dtor("S17044C4", this);}
void  S17044C4 ::v8(){vfunc_called(this, "_ZN8S17044C42v8Ev");}
void  S17044C4 ::v9(){vfunc_called(this, "_ZN8S17044C42v9Ev");}
void  S17044C4 ::v10(){vfunc_called(this, "_ZN8S17044C43v10Ev");}
void  S17044C4 ::v11(){vfunc_called(this, "_ZN8S17044C43v11Ev");}
void  S17044C4 ::v12(){vfunc_called(this, "_ZN8S17044C43v12Ev");}
S17044C4 ::S17044C4(){ note_ctor("S17044C4", this);} // tgen

static void Test_S17044C4()
{
  extern Class_Descriptor cd_S17044C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S17044C4, buf);
    S17044C4 *dp, &lv = *(dp=new (buf) S17044C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17044C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C4)");
    test_class_info(&lv, &cd_S17044C4);
    dp->~S17044C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C4(Test_S17044C4, "S17044C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S17044C4C1Ev();
extern void _ZN8S17044C4D1Ev();
Name_Map name_map_S17044C4[] = {
  NSPAIR(_ZN8S17044C4C1Ev),
  NSPAIR(_ZN8S17044C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S17044C4[];
extern void _ZN8S17044C4D1Ev();
extern void _ZN8S17044C4D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
static  VTBL_ENTRY vtc_S17044C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S17044C4[0]),
  (VTBL_ENTRY)&_ZN8S17044C4D1Ev,
  (VTBL_ENTRY)&_ZN8S17044C4D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
Class_Descriptor cd_S17044C4 = {  "S17044C4", // class name
  0,0,//no base classes
  &(vtc_S17044C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S17044C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S17044C4),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C7_nt  {
};
//SIG(-1 S17044C7_nt) C1{}



//skip512 S17044C7_nt

#else // __cplusplus

Class_Descriptor cd_S17044C7_nt = {  "S17044C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C9  {
};
//SIG(-1 S17044C9) C1{}



static void Test_S17044C9()
{
  {
    init_simple_test("S17044C9");
    S17044C9 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C9)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C9)");
  }
}
static Arrange_To_Call_Me vS17044C9(Test_S17044C9, "S17044C9", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C9 = {  "S17044C9", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C8  : S17044C9 {
};
//SIG(-1 S17044C8) C1{ BC2{}}



static void Test_S17044C8()
{
  extern Class_Descriptor cd_S17044C8;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C8, buf);
    S17044C8 &lv = *(new (buf) S17044C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C8)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C8)");
    check_base_class_offset(lv, (S17044C9*), 0, "S17044C8");
    test_class_info(&lv, &cd_S17044C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C8(Test_S17044C8, "S17044C8", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C9;
static Base_Class bases_S17044C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C8 = {  "S17044C8", // class name
  bases_S17044C8, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C6  : S17044C7_nt {
  ::S17044C8 s17044c6f0;
};
//SIG(-1 S17044C6) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C6()
{
  extern Class_Descriptor cd_S17044C6;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C6, buf);
    S17044C6 &lv = *(new (buf) S17044C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C6)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C6)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C6");
    check_field_offset(lv, s17044c6f0, 0, "S17044C6.s17044c6f0");
    test_class_info(&lv, &cd_S17044C6);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C6(Test_S17044C6, "S17044C6", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C6 = {  "S17044C6", // class name
  bases_S17044C6, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C5  : S17044C6 {
  void *s17044c5f0[3];
};
//SIG(-1 S17044C5) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S17044C5()
{
  extern Class_Descriptor cd_S17044C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S17044C5, buf);
    S17044C5 &lv = *(new (buf) S17044C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17044C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C5)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C6*), 0, "S17044C5");
    check_base_class_offset(lv, (S17044C6*), 0, "S17044C5");
    check_field_offset(lv, s17044c5f0, ABISELECT(8,4), "S17044C5.s17044c5f0");
    test_class_info(&lv, &cd_S17044C5);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C5(Test_S17044C5, "S17044C5", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C6;
static Base_Class bases_S17044C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C5 = {  "S17044C5", // class name
  bases_S17044C5, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C16  : S17044C7_nt {
  ::S17044C8 s17044c16f0;
};
//SIG(-1 S17044C16) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C16()
{
  extern Class_Descriptor cd_S17044C16;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C16, buf);
    S17044C16 &lv = *(new (buf) S17044C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C16)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C16)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C16");
    check_field_offset(lv, s17044c16f0, 0, "S17044C16.s17044c16f0");
    test_class_info(&lv, &cd_S17044C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C16(Test_S17044C16, "S17044C16", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C16 = {  "S17044C16", // class name
  bases_S17044C16, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C20  {
};
//SIG(-1 S17044C20) C1{}



static void Test_S17044C20()
{
  {
    init_simple_test("S17044C20");
    S17044C20 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C20)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C20)");
  }
}
static Arrange_To_Call_Me vS17044C20(Test_S17044C20, "S17044C20", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C20 = {  "S17044C20", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C19  : S17044C20 {
};
//SIG(-1 S17044C19) C1{ BC2{}}



static void Test_S17044C19()
{
  extern Class_Descriptor cd_S17044C19;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C19, buf);
    S17044C19 &lv = *(new (buf) S17044C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C19)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C19)");
    check_base_class_offset(lv, (S17044C20*), 0, "S17044C19");
    test_class_info(&lv, &cd_S17044C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C19(Test_S17044C19, "S17044C19", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C20;
static Base_Class bases_S17044C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C19 = {  "S17044C19", // class name
  bases_S17044C19, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C15  : S17044C16 {
  ::S17044C19 s17044c15f0;
};
//SIG(-1 S17044C15) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S17044C15()
{
  extern Class_Descriptor cd_S17044C15;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S17044C15, buf);
    S17044C15 &lv = *(new (buf) S17044C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S17044C15)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C15)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C16*), 0, "S17044C15");
    check_base_class_offset(lv, (S17044C16*), 0, "S17044C15");
    check_field_offset(lv, s17044c15f0, 1, "S17044C15.s17044c15f0");
    test_class_info(&lv, &cd_S17044C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C15(Test_S17044C15, "S17044C15", 2);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C16;
static Base_Class bases_S17044C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C15 = {  "S17044C15", // class name
  bases_S17044C15, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C14  : S17044C15 {
  ::S17044C19 s17044c14f0;
};
//SIG(-1 S17044C14) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC7}



static void Test_S17044C14()
{
  extern Class_Descriptor cd_S17044C14;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S17044C14, buf);
    S17044C14 &lv = *(new (buf) S17044C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S17044C14)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C14)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C16*)(S17044C15*), 0, "S17044C14");
    check_base_class_offset(lv, (S17044C16*)(S17044C15*), 0, "S17044C14");
    check_base_class_offset(lv, (S17044C15*), 0, "S17044C14");
    check_field_offset(lv, s17044c14f0, 2, "S17044C14.s17044c14f0");
    test_class_info(&lv, &cd_S17044C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C14(Test_S17044C14, "S17044C14", 3);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C16;
extern Class_Descriptor cd_S17044C15;
static Base_Class bases_S17044C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C14 = {  "S17044C14", // class name
  bases_S17044C14, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C24  {
};
//SIG(-1 S17044C24) C1{}



static void Test_S17044C24()
{
  {
    init_simple_test("S17044C24");
    S17044C24 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C24)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C24)");
  }
}
static Arrange_To_Call_Me vS17044C24(Test_S17044C24, "S17044C24", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C24 = {  "S17044C24", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C23  : S17044C24 {
};
//SIG(-1 S17044C23) C1{ BC2{}}



static void Test_S17044C23()
{
  extern Class_Descriptor cd_S17044C23;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C23, buf);
    S17044C23 &lv = *(new (buf) S17044C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C23)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C23)");
    check_base_class_offset(lv, (S17044C24*), 0, "S17044C23");
    test_class_info(&lv, &cd_S17044C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C23(Test_S17044C23, "S17044C23", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C24;
static Base_Class bases_S17044C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C23 = {  "S17044C23", // class name
  bases_S17044C23, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C13  : S17044C14 {
  ::S17044C23 s17044c13f0;
};
//SIG(-1 S17044C13) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC8} FC10{ BC11{}}}



static void Test_S17044C13()
{
  extern Class_Descriptor cd_S17044C13;
  void *lvp;
  {
    char buf[4];
    init_test(&cd_S17044C13, buf);
    S17044C13 &lv = *(new (buf) S17044C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S17044C13)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C13)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C16*)(S17044C15*)(S17044C14*), 0, "S17044C13");
    check_base_class_offset(lv, (S17044C16*)(S17044C15*)(S17044C14*), 0, "S17044C13");
    check_base_class_offset(lv, (S17044C15*)(S17044C14*), 0, "S17044C13");
    check_base_class_offset(lv, (S17044C14*), 0, "S17044C13");
    check_field_offset(lv, s17044c13f0, 3, "S17044C13.s17044c13f0");
    test_class_info(&lv, &cd_S17044C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C13(Test_S17044C13, "S17044C13", 4);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C16;
extern Class_Descriptor cd_S17044C15;
extern Class_Descriptor cd_S17044C14;
static Base_Class bases_S17044C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C13 = {  "S17044C13", // class name
  bases_S17044C13, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C12  : S17044C13 {
  void *s17044c12f0;
  int s17044c12f1;
};
//SIG(-1 S17044C12) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC9{ BC10{}}} FC9} FC11{ BC12{}}} Fp Fi}



static void Test_S17044C12()
{
  extern Class_Descriptor cd_S17044C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S17044C12, buf);
    S17044C12 &lv = *(new (buf) S17044C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17044C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C12)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C16*)(S17044C15*)(S17044C14*)(S17044C13*), 0, "S17044C12");
    check_base_class_offset(lv, (S17044C16*)(S17044C15*)(S17044C14*)(S17044C13*), 0, "S17044C12");
    check_base_class_offset(lv, (S17044C15*)(S17044C14*)(S17044C13*), 0, "S17044C12");
    check_base_class_offset(lv, (S17044C14*)(S17044C13*), 0, "S17044C12");
    check_base_class_offset(lv, (S17044C13*), 0, "S17044C12");
    check_field_offset(lv, s17044c12f0, ABISELECT(8,4), "S17044C12.s17044c12f0");
    check_field_offset(lv, s17044c12f1, ABISELECT(16,8), "S17044C12.s17044c12f1");
    test_class_info(&lv, &cd_S17044C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C12(Test_S17044C12, "S17044C12", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C16;
extern Class_Descriptor cd_S17044C15;
extern Class_Descriptor cd_S17044C14;
extern Class_Descriptor cd_S17044C13;
static Base_Class bases_S17044C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S17044C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C12 = {  "S17044C12", // class name
  bases_S17044C12, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C11  : S17044C12 {
};
//SIG(-1 S17044C11) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC10{ BC11{}}} FC10} FC12{ BC13{}}} Fp Fi}}



static void Test_S17044C11()
{
  extern Class_Descriptor cd_S17044C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S17044C11, buf);
    S17044C11 &lv = *(new (buf) S17044C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17044C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C11)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C16*)(S17044C15*)(S17044C14*)(S17044C13*)(S17044C12*), 0, "S17044C11");
    check_base_class_offset(lv, (S17044C16*)(S17044C15*)(S17044C14*)(S17044C13*)(S17044C12*), 0, "S17044C11");
    check_base_class_offset(lv, (S17044C15*)(S17044C14*)(S17044C13*)(S17044C12*), 0, "S17044C11");
    check_base_class_offset(lv, (S17044C14*)(S17044C13*)(S17044C12*), 0, "S17044C11");
    check_base_class_offset(lv, (S17044C13*)(S17044C12*), 0, "S17044C11");
    check_base_class_offset(lv, (S17044C12*), 0, "S17044C11");
    test_class_info(&lv, &cd_S17044C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C11(Test_S17044C11, "S17044C11", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C16;
extern Class_Descriptor cd_S17044C15;
extern Class_Descriptor cd_S17044C14;
extern Class_Descriptor cd_S17044C13;
extern Class_Descriptor cd_S17044C12;
static Base_Class bases_S17044C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S17044C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S17044C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C11 = {  "S17044C11", // class name
  bases_S17044C11, 6,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C29  : S17044C7_nt {
  ::S17044C23 s17044c29f0;
};
//SIG(-1 S17044C29) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C29()
{
  extern Class_Descriptor cd_S17044C29;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C29, buf);
    S17044C29 &lv = *(new (buf) S17044C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C29)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C29)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C29");
    check_field_offset(lv, s17044c29f0, 0, "S17044C29.s17044c29f0");
    test_class_info(&lv, &cd_S17044C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C29(Test_S17044C29, "S17044C29", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C29 = {  "S17044C29", // class name
  bases_S17044C29, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C33  {
};
//SIG(-1 S17044C33) C1{}



static void Test_S17044C33()
{
  {
    init_simple_test("S17044C33");
    S17044C33 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C33)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C33)");
  }
}
static Arrange_To_Call_Me vS17044C33(Test_S17044C33, "S17044C33", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C33 = {  "S17044C33", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C32  : S17044C33 {
};
//SIG(-1 S17044C32) C1{ BC2{}}



static void Test_S17044C32()
{
  extern Class_Descriptor cd_S17044C32;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C32, buf);
    S17044C32 &lv = *(new (buf) S17044C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C32)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C32)");
    check_base_class_offset(lv, (S17044C33*), 0, "S17044C32");
    test_class_info(&lv, &cd_S17044C32);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C32(Test_S17044C32, "S17044C32", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C33;
static Base_Class bases_S17044C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C32 = {  "S17044C32", // class name
  bases_S17044C32, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C28  : S17044C29 {
  ::S17044C32 s17044c28f0;
};
//SIG(-1 S17044C28) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S17044C28()
{
  extern Class_Descriptor cd_S17044C28;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S17044C28, buf);
    S17044C28 &lv = *(new (buf) S17044C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S17044C28)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C28)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C29*), 0, "S17044C28");
    check_base_class_offset(lv, (S17044C29*), 0, "S17044C28");
    check_field_offset(lv, s17044c28f0, 1, "S17044C28.s17044c28f0");
    test_class_info(&lv, &cd_S17044C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C28(Test_S17044C28, "S17044C28", 2);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C29;
static Base_Class bases_S17044C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C28 = {  "S17044C28", // class name
  bases_S17044C28, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C27  : S17044C28 {
  ::S17044C32 s17044c27f0;
};
//SIG(-1 S17044C27) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC7}



static void Test_S17044C27()
{
  extern Class_Descriptor cd_S17044C27;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S17044C27, buf);
    S17044C27 &lv = *(new (buf) S17044C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S17044C27)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C27)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C29*)(S17044C28*), 0, "S17044C27");
    check_base_class_offset(lv, (S17044C29*)(S17044C28*), 0, "S17044C27");
    check_base_class_offset(lv, (S17044C28*), 0, "S17044C27");
    check_field_offset(lv, s17044c27f0, 2, "S17044C27.s17044c27f0");
    test_class_info(&lv, &cd_S17044C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C27(Test_S17044C27, "S17044C27", 3);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C29;
extern Class_Descriptor cd_S17044C28;
static Base_Class bases_S17044C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C27 = {  "S17044C27", // class name
  bases_S17044C27, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C26  : S17044C27 {
  void *s17044c26f0;
  int s17044c26f1;
};
//SIG(-1 S17044C26) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC8} Fp Fi}



static void Test_S17044C26()
{
  extern Class_Descriptor cd_S17044C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S17044C26, buf);
    S17044C26 &lv = *(new (buf) S17044C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17044C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C26)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C29*)(S17044C28*)(S17044C27*), 0, "S17044C26");
    check_base_class_offset(lv, (S17044C29*)(S17044C28*)(S17044C27*), 0, "S17044C26");
    check_base_class_offset(lv, (S17044C28*)(S17044C27*), 0, "S17044C26");
    check_base_class_offset(lv, (S17044C27*), 0, "S17044C26");
    check_field_offset(lv, s17044c26f0, ABISELECT(8,4), "S17044C26.s17044c26f0");
    check_field_offset(lv, s17044c26f1, ABISELECT(16,8), "S17044C26.s17044c26f1");
    test_class_info(&lv, &cd_S17044C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C26(Test_S17044C26, "S17044C26", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C29;
extern Class_Descriptor cd_S17044C28;
extern Class_Descriptor cd_S17044C27;
static Base_Class bases_S17044C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C26 = {  "S17044C26", // class name
  bases_S17044C26, 4,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C25  {
  ::S17044C26 s17044c25f0;
  ::S17044C26 s17044c25f1;
  void  mf17044c25(); // _ZN9S17044C2510mf17044c25Ev
};
//SIG(-1 S17044C25) C1{ m FC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC9{ BC10{}}} FC9} Fp Fi} FC2}


void  S17044C25 ::mf17044c25(){}

static void Test_S17044C25()
{
  {
    init_simple_test("S17044C25");
    S17044C25 lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S17044C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C25)");
    check_field_offset(lv, s17044c25f0, 0, "S17044C25.s17044c25f0");
    check_field_offset(lv, s17044c25f1, ABISELECT(24,12), "S17044C25.s17044c25f1");
  }
}
static Arrange_To_Call_Me vS17044C25(Test_S17044C25, "S17044C25", ABISELECT(48,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C10  {
  void *s17044c10f0;
  ::S17044C11 s17044c10f1;
  ::S17044C25 s17044c10f2;
  void  mf17044c10(); // _ZN9S17044C1010mf17044c10Ev
};
//SIG(-1 S17044C10) C1{ m Fp FC2{ BC3{ BC4{ BC5{ BC6{ BC7{ BC8{} FC9{ BC10{}}} FC11{ BC12{}}} FC11} FC13{ BC14{}}} Fp Fi}} FC15{ m FC16{ BC17{ BC18{ BC19{ BC8 FC13} FC20{ BC21{}}} FC20} Fp Fi} FC16}}


void  S17044C10 ::mf17044c10(){}

static void Test_S17044C10()
{
  {
    init_simple_test("S17044C10");
    S17044C10 lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(S17044C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C10)");
    check_field_offset(lv, s17044c10f0, 0, "S17044C10.s17044c10f0");
    check_field_offset(lv, s17044c10f1, ABISELECT(8,4), "S17044C10.s17044c10f1");
    check_field_offset(lv, s17044c10f2, ABISELECT(32,16), "S17044C10.s17044c10f2");
  }
}
static Arrange_To_Call_Me vS17044C10(Test_S17044C10, "S17044C10", ABISELECT(80,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C3  : S17044C4 {
  char s17044c3f0;
  ::S17044C5 s17044c3f1;
  ::S17044C5 s17044c3f2;
  int s17044c3f3[6];
  char s17044c3f4;
  void *s17044c3f5;
  ::S17044C10 s17044c3f6;
  int s17044c3f7;
  virtual  ~S17044C3(); // _ZN8S17044C3D1Ev
  virtual void  v13(); // _ZN8S17044C33v13Ev
  virtual void  v14(); // _ZN8S17044C33v14Ev
  virtual void  v15(); // _ZN8S17044C33v15Ev
  virtual void  v16(); // _ZN8S17044C33v16Ev
  virtual void  v17(); // _ZN8S17044C33v17Ev
  virtual void  v18(); // _ZN8S17044C33v18Ev
  virtual void  v19(); // _ZN8S17044C33v19Ev
  virtual void  v20(); // _ZN8S17044C33v20Ev
  virtual void  v21(); // _ZN8S17044C33v21Ev
  virtual void  v22(); // _ZN8S17044C33v22Ev
  virtual void  v23(); // _ZN8S17044C33v23Ev
  virtual void  v24(); // _ZN8S17044C33v24Ev
  virtual void  v25(); // _ZN8S17044C33v25Ev
  virtual void  v26(); // _ZN8S17044C33v26Ev
  virtual void  v27(); // _ZN8S17044C33v27Ev
  virtual void  v28(); // _ZN8S17044C33v28Ev
  S17044C3(); // tgen
};
//SIG(-1 S17044C3) C1{ BC2{ vd v17 v18 v19 v20 v21} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fc FC3{ BC4{ BC5{} FC6{ BC7{}}} Fp[3]} FC3 Fi[6] Fc Fp FC8{ m Fp FC9{ BC10{ BC11{ BC12{ BC13{ BC14{ BC5 FC6} FC15{ BC16{}}} FC15} FC17{ BC18{}}} Fp Fi}} FC19{ m FC20{ BC21{ BC22{ BC23{ BC5 FC17} FC24{ BC25{}}} FC24} Fp Fi} FC20}} Fi}


 S17044C3 ::~S17044C3(){ note_dtor("S17044C3", this);}
void  S17044C3 ::v13(){vfunc_called(this, "_ZN8S17044C33v13Ev");}
void  S17044C3 ::v14(){vfunc_called(this, "_ZN8S17044C33v14Ev");}
void  S17044C3 ::v15(){vfunc_called(this, "_ZN8S17044C33v15Ev");}
void  S17044C3 ::v16(){vfunc_called(this, "_ZN8S17044C33v16Ev");}
void  S17044C3 ::v17(){vfunc_called(this, "_ZN8S17044C33v17Ev");}
void  S17044C3 ::v18(){vfunc_called(this, "_ZN8S17044C33v18Ev");}
void  S17044C3 ::v19(){vfunc_called(this, "_ZN8S17044C33v19Ev");}
void  S17044C3 ::v20(){vfunc_called(this, "_ZN8S17044C33v20Ev");}
void  S17044C3 ::v21(){vfunc_called(this, "_ZN8S17044C33v21Ev");}
void  S17044C3 ::v22(){vfunc_called(this, "_ZN8S17044C33v22Ev");}
void  S17044C3 ::v23(){vfunc_called(this, "_ZN8S17044C33v23Ev");}
void  S17044C3 ::v24(){vfunc_called(this, "_ZN8S17044C33v24Ev");}
void  S17044C3 ::v25(){vfunc_called(this, "_ZN8S17044C33v25Ev");}
void  S17044C3 ::v26(){vfunc_called(this, "_ZN8S17044C33v26Ev");}
void  S17044C3 ::v27(){vfunc_called(this, "_ZN8S17044C33v27Ev");}
void  S17044C3 ::v28(){vfunc_called(this, "_ZN8S17044C33v28Ev");}
S17044C3 ::S17044C3(){ note_ctor("S17044C3", this);} // tgen

static void Test_S17044C3()
{
  extern Class_Descriptor cd_S17044C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,30)];
    init_test(&cd_S17044C3, buf);
    S17044C3 *dp, &lv = *(dp=new (buf) S17044C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,116), "sizeof(S17044C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C3)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C3");
    check_field_offset(lv, s17044c3f0, ABISELECT(8,4), "S17044C3.s17044c3f0");
    check_field_offset(lv, s17044c3f1, ABISELECT(16,8), "S17044C3.s17044c3f1");
    check_field_offset(lv, s17044c3f2, ABISELECT(48,24), "S17044C3.s17044c3f2");
    check_field_offset(lv, s17044c3f3, ABISELECT(80,40), "S17044C3.s17044c3f3");
    check_field_offset(lv, s17044c3f4, ABISELECT(104,64), "S17044C3.s17044c3f4");
    check_field_offset(lv, s17044c3f5, ABISELECT(112,68), "S17044C3.s17044c3f5");
    check_field_offset(lv, s17044c3f6, ABISELECT(120,72), "S17044C3.s17044c3f6");
    check_field_offset(lv, s17044c3f7, ABISELECT(200,112), "S17044C3.s17044c3f7");
    test_class_info(&lv, &cd_S17044C3);
    dp->~S17044C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C3(Test_S17044C3, "S17044C3", ABISELECT(208,116));

#else // __cplusplus

extern void _ZN8S17044C3C1Ev();
extern void _ZN8S17044C3D1Ev();
Name_Map name_map_S17044C3[] = {
  NSPAIR(_ZN8S17044C3C1Ev),
  NSPAIR(_ZN8S17044C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S17044C3[];
extern void _ZN8S17044C3D1Ev();
extern void _ZN8S17044C3D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN8S17044C33v13Ev();
extern void _ZN8S17044C33v14Ev();
extern void _ZN8S17044C33v15Ev();
extern void _ZN8S17044C33v16Ev();
extern void _ZN8S17044C33v17Ev();
extern void _ZN8S17044C33v18Ev();
extern void _ZN8S17044C33v19Ev();
extern void _ZN8S17044C33v20Ev();
extern void _ZN8S17044C33v21Ev();
extern void _ZN8S17044C33v22Ev();
extern void _ZN8S17044C33v23Ev();
extern void _ZN8S17044C33v24Ev();
extern void _ZN8S17044C33v25Ev();
extern void _ZN8S17044C33v26Ev();
extern void _ZN8S17044C33v27Ev();
extern void _ZN8S17044C33v28Ev();
static  VTBL_ENTRY vtc_S17044C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S17044C3[0]),
  (VTBL_ENTRY)&_ZN8S17044C3D1Ev,
  (VTBL_ENTRY)&_ZN8S17044C3D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v13Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v14Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v15Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v16Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v17Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v18Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v19Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v20Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v21Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v22Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v23Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v24Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v25Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v26Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v27Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v28Ev,
};
extern VTBL_ENTRY _ZTI8S17044C3[];
extern  VTBL_ENTRY _ZTV8S17044C3[];
Class_Descriptor cd_S17044C3 = {  "S17044C3", // class name
  bases_S17044C3, 1,
  &(vtc_S17044C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,116), // object size
  NSPAIRA(_ZTI8S17044C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S17044C3),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C2  : S17044C3 {
  char s17044c2f0;
  int s17044c2f1;
  char s17044c2f2[2];
  virtual  ~S17044C2(); // _ZN8S17044C2D1Ev
  virtual void  v1(); // _ZN8S17044C22v1Ev
  virtual void  v2(); // _ZN8S17044C22v2Ev
  virtual void  v3(); // _ZN8S17044C22v3Ev
  virtual void  v4(); // _ZN8S17044C22v4Ev
  virtual void  v5(); // _ZN8S17044C22v5Ev
  virtual void  v6(); // _ZN8S17044C22v6Ev
  virtual void  v7(); // _ZN8S17044C22v7Ev
  S17044C2(); // tgen
};
//SIG(-1 S17044C2) C1{ BC2{ BC3{ vd v8 v9 v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fc FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 Fi[6] Fc Fp FC9{ m Fp FC10{ BC11{ BC12{ BC13{ BC14{ BC15{ BC6 FC7} FC16{ BC17{}}} FC16} FC18{ BC19{}}} Fp Fi}} FC20{ m FC21{ BC22{ BC23{ BC24{ BC6 FC18} FC25{ BC26{}}} FC25} Fp Fi} FC21}} Fi} vd v1 v2 v3 v4 v5 v6 v7 Fc Fi Fc[2]}


 S17044C2 ::~S17044C2(){ note_dtor("S17044C2", this);}
void  S17044C2 ::v1(){vfunc_called(this, "_ZN8S17044C22v1Ev");}
void  S17044C2 ::v2(){vfunc_called(this, "_ZN8S17044C22v2Ev");}
void  S17044C2 ::v3(){vfunc_called(this, "_ZN8S17044C22v3Ev");}
void  S17044C2 ::v4(){vfunc_called(this, "_ZN8S17044C22v4Ev");}
void  S17044C2 ::v5(){vfunc_called(this, "_ZN8S17044C22v5Ev");}
void  S17044C2 ::v6(){vfunc_called(this, "_ZN8S17044C22v6Ev");}
void  S17044C2 ::v7(){vfunc_called(this, "_ZN8S17044C22v7Ev");}
S17044C2 ::S17044C2(){ note_ctor("S17044C2", this);} // tgen

static void Test_S17044C2()
{
  extern Class_Descriptor cd_S17044C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,33)];
    init_test(&cd_S17044C2, buf);
    S17044C2 *dp, &lv = *(dp=new (buf) S17044C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,128), "sizeof(S17044C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C2)");
    check_base_class_offset(lv, (S17044C4*)(S17044C3*), 0, "S17044C2");
    check_base_class_offset(lv, (S17044C3*), 0, "S17044C2");
    check_field_offset(lv, s17044c2f0, ABISELECT(204,116), "S17044C2.s17044c2f0");
    check_field_offset(lv, s17044c2f1, ABISELECT(208,120), "S17044C2.s17044c2f1");
    check_field_offset(lv, s17044c2f2, ABISELECT(212,124), "S17044C2.s17044c2f2");
    test_class_info(&lv, &cd_S17044C2);
    dp->~S17044C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C2(Test_S17044C2, "S17044C2", ABISELECT(216,128));

#else // __cplusplus

extern void _ZN8S17044C2C1Ev();
extern void _ZN8S17044C2D1Ev();
Name_Map name_map_S17044C2[] = {
  NSPAIR(_ZN8S17044C2C1Ev),
  NSPAIR(_ZN8S17044C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C3;
extern VTBL_ENTRY _ZTI8S17044C3[];
extern  VTBL_ENTRY _ZTV8S17044C3[];
static Base_Class bases_S17044C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S17044C2[];
extern void _ZN8S17044C2D1Ev();
extern void _ZN8S17044C2D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN8S17044C33v13Ev();
extern void _ZN8S17044C33v14Ev();
extern void _ZN8S17044C33v15Ev();
extern void _ZN8S17044C33v16Ev();
extern void _ZN8S17044C33v17Ev();
extern void _ZN8S17044C33v18Ev();
extern void _ZN8S17044C33v19Ev();
extern void _ZN8S17044C33v20Ev();
extern void _ZN8S17044C33v21Ev();
extern void _ZN8S17044C33v22Ev();
extern void _ZN8S17044C33v23Ev();
extern void _ZN8S17044C33v24Ev();
extern void _ZN8S17044C33v25Ev();
extern void _ZN8S17044C33v26Ev();
extern void _ZN8S17044C33v27Ev();
extern void _ZN8S17044C33v28Ev();
extern void _ZN8S17044C22v1Ev();
extern void _ZN8S17044C22v2Ev();
extern void _ZN8S17044C22v3Ev();
extern void _ZN8S17044C22v4Ev();
extern void _ZN8S17044C22v5Ev();
extern void _ZN8S17044C22v6Ev();
extern void _ZN8S17044C22v7Ev();
static  VTBL_ENTRY vtc_S17044C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S17044C2[0]),
  (VTBL_ENTRY)&_ZN8S17044C2D1Ev,
  (VTBL_ENTRY)&_ZN8S17044C2D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v13Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v14Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v15Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v16Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v17Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v18Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v19Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v20Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v21Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v22Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v23Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v24Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v25Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v26Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v27Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v28Ev,
  (VTBL_ENTRY)&_ZN8S17044C22v1Ev,
  (VTBL_ENTRY)&_ZN8S17044C22v2Ev,
  (VTBL_ENTRY)&_ZN8S17044C22v3Ev,
  (VTBL_ENTRY)&_ZN8S17044C22v4Ev,
  (VTBL_ENTRY)&_ZN8S17044C22v5Ev,
  (VTBL_ENTRY)&_ZN8S17044C22v6Ev,
  (VTBL_ENTRY)&_ZN8S17044C22v7Ev,
};
extern VTBL_ENTRY _ZTI8S17044C2[];
extern  VTBL_ENTRY _ZTV8S17044C2[];
Class_Descriptor cd_S17044C2 = {  "S17044C2", // class name
  bases_S17044C2, 2,
  &(vtc_S17044C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,128), // object size
  NSPAIRA(_ZTI8S17044C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S17044C2),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C46_nt  {
  void *s17044c46f0;
  void  mf17044c46(); // _ZN12S17044C46_nt10mf17044c46Ev
};
//SIG(-1 S17044C46_nt) C1{ m Fp}


void  S17044C46_nt ::mf17044c46(){}

//skip512 S17044C46_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C48  {
  void *s17044c48f0;
  virtual  ~S17044C48(); // _ZN9S17044C48D1Ev
  virtual void  v33(); // _ZN9S17044C483v33Ev
  virtual void  v34(); // _ZN9S17044C483v34Ev
  virtual void  v35(); // _ZN9S17044C483v35Ev
  S17044C48(); // tgen
};
//SIG(-1 S17044C48) C1{ vd v1 v2 v3 Fp}


 S17044C48 ::~S17044C48(){ note_dtor("S17044C48", this);}
void  S17044C48 ::v33(){vfunc_called(this, "_ZN9S17044C483v33Ev");}
void  S17044C48 ::v34(){vfunc_called(this, "_ZN9S17044C483v34Ev");}
void  S17044C48 ::v35(){vfunc_called(this, "_ZN9S17044C483v35Ev");}
S17044C48 ::S17044C48(){ note_ctor("S17044C48", this);} // tgen

static void Test_S17044C48()
{
  extern Class_Descriptor cd_S17044C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S17044C48, buf);
    S17044C48 *dp, &lv = *(dp=new (buf) S17044C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17044C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C48)");
    check_field_offset(lv, s17044c48f0, ABISELECT(8,4), "S17044C48.s17044c48f0");
    test_class_info(&lv, &cd_S17044C48);
    dp->~S17044C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C48(Test_S17044C48, "S17044C48", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN9S17044C48C1Ev();
extern void _ZN9S17044C48D1Ev();
Name_Map name_map_S17044C48[] = {
  NSPAIR(_ZN9S17044C48C1Ev),
  NSPAIR(_ZN9S17044C48D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S17044C48[];
extern void _ZN9S17044C48D1Ev();
extern void _ZN9S17044C48D0Ev();
extern void _ZN9S17044C483v33Ev();
extern void _ZN9S17044C483v34Ev();
extern void _ZN9S17044C483v35Ev();
static  VTBL_ENTRY vtc_S17044C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C48[0]),
  (VTBL_ENTRY)&_ZN9S17044C48D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C48D0Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v35Ev,
};
extern VTBL_ENTRY _ZTI9S17044C48[];
extern  VTBL_ENTRY _ZTV9S17044C48[];
Class_Descriptor cd_S17044C48 = {  "S17044C48", // class name
  0,0,//no base classes
  &(vtc_S17044C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S17044C48),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S17044C48),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C47  : S17044C48 {
  void *s17044c47f0;
  char s17044c47f1;
  int s17044c47f2[2];
  virtual  ~S17044C47(); // _ZN9S17044C47D1Ev
  virtual void  v29(); // _ZN9S17044C473v29Ev
  virtual void  v30(); // _ZN9S17044C473v30Ev
  virtual void  v31(); // _ZN9S17044C473v31Ev
  virtual void  v32(); // _ZN9S17044C473v32Ev
  S17044C47(); // tgen
};
//SIG(-1 S17044C47) C1{ BC2{ vd v5 v6 v7 Fp} vd v1 v2 v3 v4 Fp Fc Fi[2]}


 S17044C47 ::~S17044C47(){ note_dtor("S17044C47", this);}
void  S17044C47 ::v29(){vfunc_called(this, "_ZN9S17044C473v29Ev");}
void  S17044C47 ::v30(){vfunc_called(this, "_ZN9S17044C473v30Ev");}
void  S17044C47 ::v31(){vfunc_called(this, "_ZN9S17044C473v31Ev");}
void  S17044C47 ::v32(){vfunc_called(this, "_ZN9S17044C473v32Ev");}
S17044C47 ::S17044C47(){ note_ctor("S17044C47", this);} // tgen

static void Test_S17044C47()
{
  extern Class_Descriptor cd_S17044C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S17044C47, buf);
    S17044C47 *dp, &lv = *(dp=new (buf) S17044C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S17044C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C47)");
    check_base_class_offset(lv, (S17044C48*), 0, "S17044C47");
    check_field_offset(lv, s17044c47f0, ABISELECT(16,8), "S17044C47.s17044c47f0");
    check_field_offset(lv, s17044c47f1, ABISELECT(24,12), "S17044C47.s17044c47f1");
    check_field_offset(lv, s17044c47f2, ABISELECT(28,16), "S17044C47.s17044c47f2");
    test_class_info(&lv, &cd_S17044C47);
    dp->~S17044C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C47(Test_S17044C47, "S17044C47", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN9S17044C47C1Ev();
extern void _ZN9S17044C47D1Ev();
Name_Map name_map_S17044C47[] = {
  NSPAIR(_ZN9S17044C47C1Ev),
  NSPAIR(_ZN9S17044C47D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C48;
extern VTBL_ENTRY _ZTI9S17044C48[];
extern  VTBL_ENTRY _ZTV9S17044C48[];
static Base_Class bases_S17044C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C47[];
extern void _ZN9S17044C47D1Ev();
extern void _ZN9S17044C47D0Ev();
extern void _ZN9S17044C483v33Ev();
extern void _ZN9S17044C483v34Ev();
extern void _ZN9S17044C483v35Ev();
extern void _ZN9S17044C473v29Ev();
extern void _ZN9S17044C473v30Ev();
extern void _ZN9S17044C473v31Ev();
extern void _ZN9S17044C473v32Ev();
static  VTBL_ENTRY vtc_S17044C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C47[0]),
  (VTBL_ENTRY)&_ZN9S17044C47D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C47D0Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v35Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v29Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v30Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v31Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v32Ev,
};
extern VTBL_ENTRY _ZTI9S17044C47[];
extern  VTBL_ENTRY _ZTV9S17044C47[];
Class_Descriptor cd_S17044C47 = {  "S17044C47", // class name
  bases_S17044C47, 1,
  &(vtc_S17044C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI9S17044C47),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C47),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C49  : S17044C47 {
  virtual  ~S17044C49(); // _ZN9S17044C49D1Ev
  virtual void  v36(); // _ZN9S17044C493v36Ev
  S17044C49(); // tgen
};
//SIG(-1 S17044C49) C1{ BC2{ BC3{ vd v2 v3 v4 Fp} vd v5 v6 v7 v8 Fp Fc Fi[2]} vd v1}


 S17044C49 ::~S17044C49(){ note_dtor("S17044C49", this);}
void  S17044C49 ::v36(){vfunc_called(this, "_ZN9S17044C493v36Ev");}
S17044C49 ::S17044C49(){ note_ctor("S17044C49", this);} // tgen

static void Test_S17044C49()
{
  extern Class_Descriptor cd_S17044C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S17044C49, buf);
    S17044C49 *dp, &lv = *(dp=new (buf) S17044C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S17044C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C49)");
    check_base_class_offset(lv, (S17044C48*)(S17044C47*), 0, "S17044C49");
    check_base_class_offset(lv, (S17044C47*), 0, "S17044C49");
    test_class_info(&lv, &cd_S17044C49);
    dp->~S17044C49();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C49(Test_S17044C49, "S17044C49", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN9S17044C49C1Ev();
extern void _ZN9S17044C49D1Ev();
Name_Map name_map_S17044C49[] = {
  NSPAIR(_ZN9S17044C49C1Ev),
  NSPAIR(_ZN9S17044C49D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C48;
extern VTBL_ENTRY _ZTI9S17044C48[];
extern  VTBL_ENTRY _ZTV9S17044C48[];
extern Class_Descriptor cd_S17044C47;
extern VTBL_ENTRY _ZTI9S17044C47[];
extern  VTBL_ENTRY _ZTV9S17044C47[];
static Base_Class bases_S17044C49[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C47,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C49[];
extern void _ZN9S17044C49D1Ev();
extern void _ZN9S17044C49D0Ev();
extern void _ZN9S17044C483v33Ev();
extern void _ZN9S17044C483v34Ev();
extern void _ZN9S17044C483v35Ev();
extern void _ZN9S17044C473v29Ev();
extern void _ZN9S17044C473v30Ev();
extern void _ZN9S17044C473v31Ev();
extern void _ZN9S17044C473v32Ev();
extern void _ZN9S17044C493v36Ev();
static  VTBL_ENTRY vtc_S17044C49[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C49[0]),
  (VTBL_ENTRY)&_ZN9S17044C49D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C49D0Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v35Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v29Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v30Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v31Ev,
  (VTBL_ENTRY)&_ZN9S17044C473v32Ev,
  (VTBL_ENTRY)&_ZN9S17044C493v36Ev,
};
extern VTBL_ENTRY _ZTI9S17044C49[];
extern  VTBL_ENTRY _ZTV9S17044C49[];
Class_Descriptor cd_S17044C49 = {  "S17044C49", // class name
  bases_S17044C49, 2,
  &(vtc_S17044C49[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI9S17044C49),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C49),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C50  : S17044C3 {
  char s17044c50f0;
  int s17044c50f1;
  char s17044c50f2;
  virtual  ~S17044C50(); // _ZN9S17044C50D1Ev
  virtual void  v37(); // _ZN9S17044C503v37Ev
  virtual void  v38(); // _ZN9S17044C503v38Ev
  virtual void  v39(); // _ZN9S17044C503v39Ev
  virtual void  v40(); // _ZN9S17044C503v40Ev
  virtual void  v41(); // _ZN9S17044C503v41Ev
  virtual void  v42(); // _ZN9S17044C503v42Ev
  virtual void  v43(); // _ZN9S17044C503v43Ev
  S17044C50(); // tgen
};
//SIG(-1 S17044C50) C1{ BC2{ BC3{ vd v8 v9 v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fc FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 Fi[6] Fc Fp FC9{ m Fp FC10{ BC11{ BC12{ BC13{ BC14{ BC15{ BC6 FC7} FC16{ BC17{}}} FC16} FC18{ BC19{}}} Fp Fi}} FC20{ m FC21{ BC22{ BC23{ BC24{ BC6 FC18} FC25{ BC26{}}} FC25} Fp Fi} FC21}} Fi} vd v1 v2 v3 v4 v5 v6 v7 Fc Fi Fc}


 S17044C50 ::~S17044C50(){ note_dtor("S17044C50", this);}
void  S17044C50 ::v37(){vfunc_called(this, "_ZN9S17044C503v37Ev");}
void  S17044C50 ::v38(){vfunc_called(this, "_ZN9S17044C503v38Ev");}
void  S17044C50 ::v39(){vfunc_called(this, "_ZN9S17044C503v39Ev");}
void  S17044C50 ::v40(){vfunc_called(this, "_ZN9S17044C503v40Ev");}
void  S17044C50 ::v41(){vfunc_called(this, "_ZN9S17044C503v41Ev");}
void  S17044C50 ::v42(){vfunc_called(this, "_ZN9S17044C503v42Ev");}
void  S17044C50 ::v43(){vfunc_called(this, "_ZN9S17044C503v43Ev");}
S17044C50 ::S17044C50(){ note_ctor("S17044C50", this);} // tgen

static void Test_S17044C50()
{
  extern Class_Descriptor cd_S17044C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,33)];
    init_test(&cd_S17044C50, buf);
    S17044C50 *dp, &lv = *(dp=new (buf) S17044C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,128), "sizeof(S17044C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C50)");
    check_base_class_offset(lv, (S17044C4*)(S17044C3*), 0, "S17044C50");
    check_base_class_offset(lv, (S17044C3*), 0, "S17044C50");
    check_field_offset(lv, s17044c50f0, ABISELECT(204,116), "S17044C50.s17044c50f0");
    check_field_offset(lv, s17044c50f1, ABISELECT(208,120), "S17044C50.s17044c50f1");
    check_field_offset(lv, s17044c50f2, ABISELECT(212,124), "S17044C50.s17044c50f2");
    test_class_info(&lv, &cd_S17044C50);
    dp->~S17044C50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C50(Test_S17044C50, "S17044C50", ABISELECT(216,128));

#else // __cplusplus

extern void _ZN9S17044C50C1Ev();
extern void _ZN9S17044C50D1Ev();
Name_Map name_map_S17044C50[] = {
  NSPAIR(_ZN9S17044C50C1Ev),
  NSPAIR(_ZN9S17044C50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C3;
extern VTBL_ENTRY _ZTI8S17044C3[];
extern  VTBL_ENTRY _ZTV8S17044C3[];
static Base_Class bases_S17044C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C50[];
extern void _ZN9S17044C50D1Ev();
extern void _ZN9S17044C50D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN8S17044C33v13Ev();
extern void _ZN8S17044C33v14Ev();
extern void _ZN8S17044C33v15Ev();
extern void _ZN8S17044C33v16Ev();
extern void _ZN8S17044C33v17Ev();
extern void _ZN8S17044C33v18Ev();
extern void _ZN8S17044C33v19Ev();
extern void _ZN8S17044C33v20Ev();
extern void _ZN8S17044C33v21Ev();
extern void _ZN8S17044C33v22Ev();
extern void _ZN8S17044C33v23Ev();
extern void _ZN8S17044C33v24Ev();
extern void _ZN8S17044C33v25Ev();
extern void _ZN8S17044C33v26Ev();
extern void _ZN8S17044C33v27Ev();
extern void _ZN8S17044C33v28Ev();
extern void _ZN9S17044C503v37Ev();
extern void _ZN9S17044C503v38Ev();
extern void _ZN9S17044C503v39Ev();
extern void _ZN9S17044C503v40Ev();
extern void _ZN9S17044C503v41Ev();
extern void _ZN9S17044C503v42Ev();
extern void _ZN9S17044C503v43Ev();
static  VTBL_ENTRY vtc_S17044C50[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C50[0]),
  (VTBL_ENTRY)&_ZN9S17044C50D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C50D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v13Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v14Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v15Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v16Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v17Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v18Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v19Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v20Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v21Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v22Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v23Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v24Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v25Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v26Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v27Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v28Ev,
  (VTBL_ENTRY)&_ZN9S17044C503v37Ev,
  (VTBL_ENTRY)&_ZN9S17044C503v38Ev,
  (VTBL_ENTRY)&_ZN9S17044C503v39Ev,
  (VTBL_ENTRY)&_ZN9S17044C503v40Ev,
  (VTBL_ENTRY)&_ZN9S17044C503v41Ev,
  (VTBL_ENTRY)&_ZN9S17044C503v42Ev,
  (VTBL_ENTRY)&_ZN9S17044C503v43Ev,
};
extern VTBL_ENTRY _ZTI9S17044C50[];
extern  VTBL_ENTRY _ZTV9S17044C50[];
Class_Descriptor cd_S17044C50 = {  "S17044C50", // class name
  bases_S17044C50, 2,
  &(vtc_S17044C50[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,128), // object size
  NSPAIRA(_ZTI9S17044C50),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C50),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C52_nt  {
  int s17044c52f0[2];
  void  mf17044c52(); // _ZN12S17044C52_nt10mf17044c52Ev
};
//SIG(-1 S17044C52_nt) C1{ m Fi[2]}


void  S17044C52_nt ::mf17044c52(){}

//skip512 S17044C52_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C51  : S17044C4 {
  int s17044c51f0[2];
  ::S17044C52_nt s17044c51f1;
  ::S17044C5 s17044c51f2;
  ::S17044C5 s17044c51f3;
  ::S17044C5 s17044c51f4;
  ::S17044C5 s17044c51f5;
  ::S17044C5 s17044c51f6;
  ::S17044C5 s17044c51f7;
  ::S17044C5 s17044c51f8;
  ::S17044C5 s17044c51f9;
  ::S17044C11 s17044c51f10;
  int s17044c51f11[3];
  char s17044c51f12[3];
  int s17044c51f13;
  char s17044c51f14[512];
  int s17044c51f15[3];
  char s17044c51f16[2];
  virtual  ~S17044C51(); // _ZN9S17044C51D1Ev
  virtual void  v44(); // _ZN9S17044C513v44Ev
  virtual void  v45(); // _ZN9S17044C513v45Ev
  virtual void  v46(); // _ZN9S17044C513v46Ev
  virtual void  v47(); // _ZN9S17044C513v47Ev
  S17044C51(); // tgen
};
//SIG(-1 S17044C51) C1{ BC2{ vd v5 v6 v7 v8 v9} vd v1 v2 v3 v4 Fi[2] FC3{ m Fi[2]} FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC9{ BC10{ BC11{ BC12{ BC13{ BC14{ BC6 FC7} FC15{ BC16{}}} FC15} FC17{ BC18{}}} Fp Fi}} Fi[3] Fc[3] Fi Fc[512] Fi[3] Fc[2]}


 S17044C51 ::~S17044C51(){ note_dtor("S17044C51", this);}
void  S17044C51 ::v44(){vfunc_called(this, "_ZN9S17044C513v44Ev");}
void  S17044C51 ::v45(){vfunc_called(this, "_ZN9S17044C513v45Ev");}
void  S17044C51 ::v46(){vfunc_called(this, "_ZN9S17044C513v46Ev");}
void  S17044C51 ::v47(){vfunc_called(this, "_ZN9S17044C513v47Ev");}
S17044C51 ::S17044C51(){ note_ctor("S17044C51", this);} // tgen

static void Test_S17044C51()
{
  extern Class_Descriptor cd_S17044C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(108,178)];
    init_test(&cd_S17044C51, buf);
    S17044C51 *dp, &lv = *(dp=new (buf) S17044C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(856,708), "sizeof(S17044C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C51)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C51");
    check_field_offset(lv, s17044c51f0, ABISELECT(8,4), "S17044C51.s17044c51f0");
    check_field_offset(lv, s17044c51f1, ABISELECT(16,12), "S17044C51.s17044c51f1");
    check_field_offset(lv, s17044c51f2, ABISELECT(24,20), "S17044C51.s17044c51f2");
    check_field_offset(lv, s17044c51f3, ABISELECT(56,36), "S17044C51.s17044c51f3");
    check_field_offset(lv, s17044c51f4, ABISELECT(88,52), "S17044C51.s17044c51f4");
    check_field_offset(lv, s17044c51f5, ABISELECT(120,68), "S17044C51.s17044c51f5");
    check_field_offset(lv, s17044c51f6, ABISELECT(152,84), "S17044C51.s17044c51f6");
    check_field_offset(lv, s17044c51f7, ABISELECT(184,100), "S17044C51.s17044c51f7");
    check_field_offset(lv, s17044c51f8, ABISELECT(216,116), "S17044C51.s17044c51f8");
    check_field_offset(lv, s17044c51f9, ABISELECT(248,132), "S17044C51.s17044c51f9");
    check_field_offset(lv, s17044c51f10, ABISELECT(280,148), "S17044C51.s17044c51f10");
    check_field_offset(lv, s17044c51f11, ABISELECT(304,160), "S17044C51.s17044c51f11");
    check_field_offset(lv, s17044c51f12, ABISELECT(316,172), "S17044C51.s17044c51f12");
    check_field_offset(lv, s17044c51f13, ABISELECT(320,176), "S17044C51.s17044c51f13");
    check_field_offset(lv, s17044c51f14, ABISELECT(324,180), "S17044C51.s17044c51f14");
    check_field_offset(lv, s17044c51f15, ABISELECT(836,692), "S17044C51.s17044c51f15");
    check_field_offset(lv, s17044c51f16, ABISELECT(848,704), "S17044C51.s17044c51f16");
    test_class_info(&lv, &cd_S17044C51);
    dp->~S17044C51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C51(Test_S17044C51, "S17044C51", ABISELECT(856,708));

#else // __cplusplus

extern void _ZN9S17044C51C1Ev();
extern void _ZN9S17044C51D1Ev();
Name_Map name_map_S17044C51[] = {
  NSPAIR(_ZN9S17044C51C1Ev),
  NSPAIR(_ZN9S17044C51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C51[];
extern void _ZN9S17044C51D1Ev();
extern void _ZN9S17044C51D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C513v44Ev();
extern void _ZN9S17044C513v45Ev();
extern void _ZN9S17044C513v46Ev();
extern void _ZN9S17044C513v47Ev();
static  VTBL_ENTRY vtc_S17044C51[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C51[0]),
  (VTBL_ENTRY)&_ZN9S17044C51D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C51D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C513v44Ev,
  (VTBL_ENTRY)&_ZN9S17044C513v45Ev,
  (VTBL_ENTRY)&_ZN9S17044C513v46Ev,
  (VTBL_ENTRY)&_ZN9S17044C513v47Ev,
};
extern VTBL_ENTRY _ZTI9S17044C51[];
extern  VTBL_ENTRY _ZTV9S17044C51[];
Class_Descriptor cd_S17044C51 = {  "S17044C51", // class name
  bases_S17044C51, 1,
  &(vtc_S17044C51[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(856,708), // object size
  NSPAIRA(_ZTI9S17044C51),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C51),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C75  : S17044C7_nt {
};
//SIG(-1 S17044C75) C1{ BC2{}}



static void Test_S17044C75()
{
  extern Class_Descriptor cd_S17044C75;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C75, buf);
    S17044C75 &lv = *(new (buf) S17044C75());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C75)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C75)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C75");
    test_class_info(&lv, &cd_S17044C75);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C75(Test_S17044C75, "S17044C75", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C75[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C75 = {  "S17044C75", // class name
  bases_S17044C75, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C77  {
};
//SIG(-1 S17044C77) C1{}



static void Test_S17044C77()
{
  {
    init_simple_test("S17044C77");
    S17044C77 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C77)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C77)");
  }
}
static Arrange_To_Call_Me vS17044C77(Test_S17044C77, "S17044C77", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C77 = {  "S17044C77", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C76  : S17044C77 {
};
//SIG(-1 S17044C76) C1{ BC2{}}



static void Test_S17044C76()
{
  extern Class_Descriptor cd_S17044C76;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C76, buf);
    S17044C76 &lv = *(new (buf) S17044C76());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C76)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C76)");
    check_base_class_offset(lv, (S17044C77*), 0, "S17044C76");
    test_class_info(&lv, &cd_S17044C76);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C76(Test_S17044C76, "S17044C76", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C77;
static Base_Class bases_S17044C76[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C77,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C76 = {  "S17044C76", // class name
  bases_S17044C76, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C74  : S17044C75 {
  ::S17044C76 s17044c74f0;
};
//SIG(-1 S17044C74) C1{ BC2{ BC3{}} FC4{ BC5{}}}



static void Test_S17044C74()
{
  extern Class_Descriptor cd_S17044C74;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C74, buf);
    S17044C74 &lv = *(new (buf) S17044C74());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C74)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C74)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C75*), 0, "S17044C74");
    check_base_class_offset(lv, (S17044C75*), 0, "S17044C74");
    check_field_offset(lv, s17044c74f0, 0, "S17044C74.s17044c74f0");
    test_class_info(&lv, &cd_S17044C74);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C74(Test_S17044C74, "S17044C74", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C75;
static Base_Class bases_S17044C74[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C75,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C74 = {  "S17044C74", // class name
  bases_S17044C74, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S17044C78  {
  char s17044c78f0[16];
  void *s17044c78f1;
};
//SIG(1 S17044C78) U1{ Fc[16] Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S17044C73  : S17044C74 {
  ::S17044C78 s17044c73f0;
  int s17044c73f1;
  int s17044c73f2;
};
//SIG(-1 S17044C73) C1{ BC2{ BC3{ BC4{}} FC5{ BC6{}}} FU7{ Fc[16] Fp} Fi Fi}



static void Test_S17044C73()
{
  extern Class_Descriptor cd_S17044C73;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,8)];
    init_test(&cd_S17044C73, buf);
    S17044C73 &lv = *(new (buf) S17044C73());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(S17044C73)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C73)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C75*)(S17044C74*), 0, "S17044C73");
    check_base_class_offset(lv, (S17044C75*)(S17044C74*), 0, "S17044C73");
    check_base_class_offset(lv, (S17044C74*), 0, "S17044C73");
    check_field_offset(lv, s17044c73f0, ABISELECT(8,4), "S17044C73.s17044c73f0");
    check_field_offset(lv, s17044c73f1, ABISELECT(24,20), "S17044C73.s17044c73f1");
    check_field_offset(lv, s17044c73f2, ABISELECT(28,24), "S17044C73.s17044c73f2");
    test_class_info(&lv, &cd_S17044C73);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C73(Test_S17044C73, "S17044C73", ABISELECT(32,28));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C75;
extern Class_Descriptor cd_S17044C74;
static Base_Class bases_S17044C73[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C75,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C74,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C73 = {  "S17044C73", // class name
  bases_S17044C73, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C72  : S17044C4 {
  ::S17044C5 s17044c72f0;
  ::S17044C5 s17044c72f1;
  ::S17044C73 s17044c72f2;
  ::S17044C73 s17044c72f3;
  ::S17044C73 s17044c72f4;
  void *s17044c72f5;
  char s17044c72f6;
  char s17044c72f7;
  char s17044c72f8;
  char s17044c72f9;
  char s17044c72f10;
  int s17044c72f11;
  virtual  ~S17044C72(); // _ZN9S17044C72D1Ev
  virtual void  v55(); // _ZN9S17044C723v55Ev
  virtual void  v56(); // _ZN9S17044C723v56Ev
  virtual void  v57(); // _ZN9S17044C723v57Ev
  virtual void  v58(); // _ZN9S17044C723v58Ev
  virtual void  v59(); // _ZN9S17044C723v59Ev
  virtual void  v60(); // _ZN9S17044C723v60Ev
  virtual void  v61(); // _ZN9S17044C723v61Ev
  virtual void  v62(); // _ZN9S17044C723v62Ev
  virtual void  v63(); // _ZN9S17044C723v63Ev
  virtual void  v64(); // _ZN9S17044C723v64Ev
  virtual void  v65(); // _ZN9S17044C723v65Ev
  virtual void  v66(); // _ZN9S17044C723v66Ev
  virtual void  v67(); // _ZN9S17044C723v67Ev
  virtual void  v68(); // _ZN9S17044C723v68Ev
  virtual void  v69(); // _ZN9S17044C723v69Ev
  S17044C72(); // tgen
};
//SIG(-1 S17044C72) C1{ BC2{ vd v16 v17 v18 v19 v20} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC3{ BC4{ BC5{} FC6{ BC7{}}} Fp[3]} FC3 FC8{ BC9{ BC10{ BC5} FC11{ BC12{}}} FU13{ Fc[16] Fp} Fi Fi} FC8 FC8 Fp Fc Fc Fc Fc Fc Fi}


 S17044C72 ::~S17044C72(){ note_dtor("S17044C72", this);}
void  S17044C72 ::v55(){vfunc_called(this, "_ZN9S17044C723v55Ev");}
void  S17044C72 ::v56(){vfunc_called(this, "_ZN9S17044C723v56Ev");}
void  S17044C72 ::v57(){vfunc_called(this, "_ZN9S17044C723v57Ev");}
void  S17044C72 ::v58(){vfunc_called(this, "_ZN9S17044C723v58Ev");}
void  S17044C72 ::v59(){vfunc_called(this, "_ZN9S17044C723v59Ev");}
void  S17044C72 ::v60(){vfunc_called(this, "_ZN9S17044C723v60Ev");}
void  S17044C72 ::v61(){vfunc_called(this, "_ZN9S17044C723v61Ev");}
void  S17044C72 ::v62(){vfunc_called(this, "_ZN9S17044C723v62Ev");}
void  S17044C72 ::v63(){vfunc_called(this, "_ZN9S17044C723v63Ev");}
void  S17044C72 ::v64(){vfunc_called(this, "_ZN9S17044C723v64Ev");}
void  S17044C72 ::v65(){vfunc_called(this, "_ZN9S17044C723v65Ev");}
void  S17044C72 ::v66(){vfunc_called(this, "_ZN9S17044C723v66Ev");}
void  S17044C72 ::v67(){vfunc_called(this, "_ZN9S17044C723v67Ev");}
void  S17044C72 ::v68(){vfunc_called(this, "_ZN9S17044C723v68Ev");}
void  S17044C72 ::v69(){vfunc_called(this, "_ZN9S17044C723v69Ev");}
S17044C72 ::S17044C72(){ note_ctor("S17044C72", this);} // tgen

static void Test_S17044C72()
{
  extern Class_Descriptor cd_S17044C72;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17044C72, buf);
    S17044C72 *dp, &lv = *(dp=new (buf) S17044C72());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17044C72)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C72)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C72");
    check_field_offset(lv, s17044c72f0, ABISELECT(8,4), "S17044C72.s17044c72f0");
    check_field_offset(lv, s17044c72f1, ABISELECT(40,20), "S17044C72.s17044c72f1");
    check_field_offset(lv, s17044c72f2, ABISELECT(72,36), "S17044C72.s17044c72f2");
    check_field_offset(lv, s17044c72f3, ABISELECT(104,64), "S17044C72.s17044c72f3");
    check_field_offset(lv, s17044c72f4, ABISELECT(136,92), "S17044C72.s17044c72f4");
    check_field_offset(lv, s17044c72f5, ABISELECT(168,120), "S17044C72.s17044c72f5");
    check_field_offset(lv, s17044c72f6, ABISELECT(176,124), "S17044C72.s17044c72f6");
    check_field_offset(lv, s17044c72f7, ABISELECT(177,125), "S17044C72.s17044c72f7");
    check_field_offset(lv, s17044c72f8, ABISELECT(178,126), "S17044C72.s17044c72f8");
    check_field_offset(lv, s17044c72f9, ABISELECT(179,127), "S17044C72.s17044c72f9");
    check_field_offset(lv, s17044c72f10, ABISELECT(180,128), "S17044C72.s17044c72f10");
    check_field_offset(lv, s17044c72f11, ABISELECT(184,132), "S17044C72.s17044c72f11");
    test_class_info(&lv, &cd_S17044C72);
    dp->~S17044C72();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C72(Test_S17044C72, "S17044C72", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN9S17044C72C1Ev();
extern void _ZN9S17044C72D1Ev();
Name_Map name_map_S17044C72[] = {
  NSPAIR(_ZN9S17044C72C1Ev),
  NSPAIR(_ZN9S17044C72D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C72[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C72[];
extern void _ZN9S17044C72D1Ev();
extern void _ZN9S17044C72D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
static  VTBL_ENTRY vtc_S17044C72[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C72[0]),
  (VTBL_ENTRY)&_ZN9S17044C72D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C72D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
};
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
Class_Descriptor cd_S17044C72 = {  "S17044C72", // class name
  bases_S17044C72, 1,
  &(vtc_S17044C72[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI9S17044C72),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C72),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C71  : S17044C72 {
  virtual  ~S17044C71(); // _ZN9S17044C71D1Ev
  virtual void  v48(); // _ZN9S17044C713v48Ev
  virtual void  v49(); // _ZN9S17044C713v49Ev
  virtual void  v50(); // _ZN9S17044C713v50Ev
  virtual void  v51(); // _ZN9S17044C713v51Ev
  virtual void  v52(); // _ZN9S17044C713v52Ev
  virtual void  v53(); // _ZN9S17044C713v53Ev
  virtual void  v54(); // _ZN9S17044C713v54Ev
  S17044C71(); // tgen
};
//SIG(-1 S17044C71) C1{ BC2{ BC3{ vd v8 v9 v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} vd v1 v2 v3 v4 v5 v6 v7}


 S17044C71 ::~S17044C71(){ note_dtor("S17044C71", this);}
void  S17044C71 ::v48(){vfunc_called(this, "_ZN9S17044C713v48Ev");}
void  S17044C71 ::v49(){vfunc_called(this, "_ZN9S17044C713v49Ev");}
void  S17044C71 ::v50(){vfunc_called(this, "_ZN9S17044C713v50Ev");}
void  S17044C71 ::v51(){vfunc_called(this, "_ZN9S17044C713v51Ev");}
void  S17044C71 ::v52(){vfunc_called(this, "_ZN9S17044C713v52Ev");}
void  S17044C71 ::v53(){vfunc_called(this, "_ZN9S17044C713v53Ev");}
void  S17044C71 ::v54(){vfunc_called(this, "_ZN9S17044C713v54Ev");}
S17044C71 ::S17044C71(){ note_ctor("S17044C71", this);} // tgen

static void Test_S17044C71()
{
  extern Class_Descriptor cd_S17044C71;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17044C71, buf);
    S17044C71 *dp, &lv = *(dp=new (buf) S17044C71());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17044C71)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C71)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C71");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C71");
    test_class_info(&lv, &cd_S17044C71);
    dp->~S17044C71();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C71(Test_S17044C71, "S17044C71", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN9S17044C71C1Ev();
extern void _ZN9S17044C71D1Ev();
Name_Map name_map_S17044C71[] = {
  NSPAIR(_ZN9S17044C71C1Ev),
  NSPAIR(_ZN9S17044C71D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C71[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C71[];
extern void _ZN9S17044C71D1Ev();
extern void _ZN9S17044C71D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C713v48Ev();
extern void _ZN9S17044C713v49Ev();
extern void _ZN9S17044C713v50Ev();
extern void _ZN9S17044C713v51Ev();
extern void _ZN9S17044C713v52Ev();
extern void _ZN9S17044C713v53Ev();
extern void _ZN9S17044C713v54Ev();
static  VTBL_ENTRY vtc_S17044C71[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C71[0]),
  (VTBL_ENTRY)&_ZN9S17044C71D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C71D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C713v48Ev,
  (VTBL_ENTRY)&_ZN9S17044C713v49Ev,
  (VTBL_ENTRY)&_ZN9S17044C713v50Ev,
  (VTBL_ENTRY)&_ZN9S17044C713v51Ev,
  (VTBL_ENTRY)&_ZN9S17044C713v52Ev,
  (VTBL_ENTRY)&_ZN9S17044C713v53Ev,
  (VTBL_ENTRY)&_ZN9S17044C713v54Ev,
};
extern VTBL_ENTRY _ZTI9S17044C71[];
extern  VTBL_ENTRY _ZTV9S17044C71[];
Class_Descriptor cd_S17044C71 = {  "S17044C71", // class name
  bases_S17044C71, 2,
  &(vtc_S17044C71[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI9S17044C71),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C71),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C79  : S17044C72 {
  int s17044c79f0;
  virtual void  v70(); // _ZN9S17044C793v70Ev
  virtual void  v71(); // _ZN9S17044C793v71Ev
  virtual void  v72(); // _ZN9S17044C793v72Ev
  virtual void  v73(); // _ZN9S17044C793v73Ev
  ~S17044C79(); // tgen
  S17044C79(); // tgen
};
//SIG(-1 S17044C79) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4 Fi}


void  S17044C79 ::v70(){vfunc_called(this, "_ZN9S17044C793v70Ev");}
void  S17044C79 ::v71(){vfunc_called(this, "_ZN9S17044C793v71Ev");}
void  S17044C79 ::v72(){vfunc_called(this, "_ZN9S17044C793v72Ev");}
void  S17044C79 ::v73(){vfunc_called(this, "_ZN9S17044C793v73Ev");}
S17044C79 ::~S17044C79(){ note_dtor("S17044C79", this);} // tgen
S17044C79 ::S17044C79(){ note_ctor("S17044C79", this);} // tgen

static void Test_S17044C79()
{
  extern Class_Descriptor cd_S17044C79;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,36)];
    init_test(&cd_S17044C79, buf);
    S17044C79 *dp, &lv = *(dp=new (buf) S17044C79());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,140), "sizeof(S17044C79)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C79)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C79");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C79");
    check_field_offset(lv, s17044c79f0, ABISELECT(188,136), "S17044C79.s17044c79f0");
    test_class_info(&lv, &cd_S17044C79);
    dp->~S17044C79();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C79(Test_S17044C79, "S17044C79", ABISELECT(192,140));

#else // __cplusplus

extern void _ZN9S17044C79C1Ev();
extern void _ZN9S17044C79D1Ev();
Name_Map name_map_S17044C79[] = {
  NSPAIR(_ZN9S17044C79C1Ev),
  NSPAIR(_ZN9S17044C79D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C79[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C79[];
extern void _ZN9S17044C79D1Ev();
extern void _ZN9S17044C79D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C793v70Ev();
extern void _ZN9S17044C793v71Ev();
extern void _ZN9S17044C793v72Ev();
extern void _ZN9S17044C793v73Ev();
static  VTBL_ENTRY vtc_S17044C79[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C79[0]),
  (VTBL_ENTRY)&_ZN9S17044C79D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C79D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C793v70Ev,
  (VTBL_ENTRY)&_ZN9S17044C793v71Ev,
  (VTBL_ENTRY)&_ZN9S17044C793v72Ev,
  (VTBL_ENTRY)&_ZN9S17044C793v73Ev,
};
extern VTBL_ENTRY _ZTI9S17044C79[];
extern  VTBL_ENTRY _ZTV9S17044C79[];
Class_Descriptor cd_S17044C79 = {  "S17044C79", // class name
  bases_S17044C79, 2,
  &(vtc_S17044C79[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,140), // object size
  NSPAIRA(_ZTI9S17044C79),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C79),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C81  : S17044C72 {
  virtual void  v78(); // _ZN9S17044C813v78Ev
  virtual void  v79(); // _ZN9S17044C813v79Ev
  virtual void  v80(); // _ZN9S17044C813v80Ev
  virtual void  v81(); // _ZN9S17044C813v81Ev
  ~S17044C81(); // tgen
  S17044C81(); // tgen
};
//SIG(-1 S17044C81) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4}


void  S17044C81 ::v78(){vfunc_called(this, "_ZN9S17044C813v78Ev");}
void  S17044C81 ::v79(){vfunc_called(this, "_ZN9S17044C813v79Ev");}
void  S17044C81 ::v80(){vfunc_called(this, "_ZN9S17044C813v80Ev");}
void  S17044C81 ::v81(){vfunc_called(this, "_ZN9S17044C813v81Ev");}
S17044C81 ::~S17044C81(){ note_dtor("S17044C81", this);} // tgen
S17044C81 ::S17044C81(){ note_ctor("S17044C81", this);} // tgen

static void Test_S17044C81()
{
  extern Class_Descriptor cd_S17044C81;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17044C81, buf);
    S17044C81 *dp, &lv = *(dp=new (buf) S17044C81());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17044C81)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C81)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C81");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C81");
    test_class_info(&lv, &cd_S17044C81);
    dp->~S17044C81();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C81(Test_S17044C81, "S17044C81", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN9S17044C81C1Ev();
extern void _ZN9S17044C81D1Ev();
Name_Map name_map_S17044C81[] = {
  NSPAIR(_ZN9S17044C81C1Ev),
  NSPAIR(_ZN9S17044C81D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C81[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C81[];
extern void _ZN9S17044C81D1Ev();
extern void _ZN9S17044C81D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C813v78Ev();
extern void _ZN9S17044C813v79Ev();
extern void _ZN9S17044C813v80Ev();
extern void _ZN9S17044C813v81Ev();
static  VTBL_ENTRY vtc_S17044C81[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C81[0]),
  (VTBL_ENTRY)&_ZN9S17044C81D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C81D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C813v78Ev,
  (VTBL_ENTRY)&_ZN9S17044C813v79Ev,
  (VTBL_ENTRY)&_ZN9S17044C813v80Ev,
  (VTBL_ENTRY)&_ZN9S17044C813v81Ev,
};
extern VTBL_ENTRY _ZTI9S17044C81[];
extern  VTBL_ENTRY _ZTV9S17044C81[];
Class_Descriptor cd_S17044C81 = {  "S17044C81", // class name
  bases_S17044C81, 2,
  &(vtc_S17044C81[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI9S17044C81),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C81),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C82  : S17044C72 {
  void *s17044c82f0;
  int s17044c82f1;
  virtual  ~S17044C82(); // _ZN9S17044C82D1Ev
  virtual void  v82(); // _ZN9S17044C823v82Ev
  virtual void  v83(); // _ZN9S17044C823v83Ev
  virtual void  v84(); // _ZN9S17044C823v84Ev
  virtual void  v85(); // _ZN9S17044C823v85Ev
  virtual void  v86(); // _ZN9S17044C823v86Ev
  S17044C82(); // tgen
};
//SIG(-1 S17044C82) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} vd v1 v2 v3 v4 v5 Fp Fi}


 S17044C82 ::~S17044C82(){ note_dtor("S17044C82", this);}
void  S17044C82 ::v82(){vfunc_called(this, "_ZN9S17044C823v82Ev");}
void  S17044C82 ::v83(){vfunc_called(this, "_ZN9S17044C823v83Ev");}
void  S17044C82 ::v84(){vfunc_called(this, "_ZN9S17044C823v84Ev");}
void  S17044C82 ::v85(){vfunc_called(this, "_ZN9S17044C823v85Ev");}
void  S17044C82 ::v86(){vfunc_called(this, "_ZN9S17044C823v86Ev");}
S17044C82 ::S17044C82(){ note_ctor("S17044C82", this);} // tgen

static void Test_S17044C82()
{
  extern Class_Descriptor cd_S17044C82;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,37)];
    init_test(&cd_S17044C82, buf);
    S17044C82 *dp, &lv = *(dp=new (buf) S17044C82());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,144), "sizeof(S17044C82)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C82)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C82");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C82");
    check_field_offset(lv, s17044c82f0, ABISELECT(192,136), "S17044C82.s17044c82f0");
    check_field_offset(lv, s17044c82f1, ABISELECT(200,140), "S17044C82.s17044c82f1");
    test_class_info(&lv, &cd_S17044C82);
    dp->~S17044C82();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C82(Test_S17044C82, "S17044C82", ABISELECT(208,144));

#else // __cplusplus

extern void _ZN9S17044C82C1Ev();
extern void _ZN9S17044C82D1Ev();
Name_Map name_map_S17044C82[] = {
  NSPAIR(_ZN9S17044C82C1Ev),
  NSPAIR(_ZN9S17044C82D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C82[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C82[];
extern void _ZN9S17044C82D1Ev();
extern void _ZN9S17044C82D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C823v82Ev();
extern void _ZN9S17044C823v83Ev();
extern void _ZN9S17044C823v84Ev();
extern void _ZN9S17044C823v85Ev();
extern void _ZN9S17044C823v86Ev();
static  VTBL_ENTRY vtc_S17044C82[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C82[0]),
  (VTBL_ENTRY)&_ZN9S17044C82D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C82D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C823v82Ev,
  (VTBL_ENTRY)&_ZN9S17044C823v83Ev,
  (VTBL_ENTRY)&_ZN9S17044C823v84Ev,
  (VTBL_ENTRY)&_ZN9S17044C823v85Ev,
  (VTBL_ENTRY)&_ZN9S17044C823v86Ev,
};
extern VTBL_ENTRY _ZTI9S17044C82[];
extern  VTBL_ENTRY _ZTV9S17044C82[];
Class_Descriptor cd_S17044C82 = {  "S17044C82", // class name
  bases_S17044C82, 2,
  &(vtc_S17044C82[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,144), // object size
  NSPAIRA(_ZTI9S17044C82),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C82),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C84  {
  char s17044c84f0;
  int s17044c84f1;
  char s17044c84f2;
  char s17044c84f3[1024];
  int s17044c84f4;
  int s17044c84f5;
  void *s17044c84f6;
  void  mf17044c84(); // _ZN9S17044C8410mf17044c84Ev
};
//SIG(-1 S17044C84) C1{ m Fc Fi Fc[1025] Fi[2] Fp}


void  S17044C84 ::mf17044c84(){}

static void Test_S17044C84()
{
  {
    init_simple_test("S17044C84");
    S17044C84 lv;
    check2(sizeof(lv), ABISELECT(1056,1048), "sizeof(S17044C84)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C84)");
    check_field_offset(lv, s17044c84f0, 0, "S17044C84.s17044c84f0");
    check_field_offset(lv, s17044c84f1, 4, "S17044C84.s17044c84f1");
    check_field_offset(lv, s17044c84f2, 8, "S17044C84.s17044c84f2");
    check_field_offset(lv, s17044c84f3, 9, "S17044C84.s17044c84f3");
    check_field_offset(lv, s17044c84f4, 1036, "S17044C84.s17044c84f4");
    check_field_offset(lv, s17044c84f5, 1040, "S17044C84.s17044c84f5");
    check_field_offset(lv, s17044c84f6, ABISELECT(1048,1044), "S17044C84.s17044c84f6");
  }
}
static Arrange_To_Call_Me vS17044C84(Test_S17044C84, "S17044C84", ABISELECT(1056,1048));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C83  : S17044C72 {
  char s17044c83f0;
  ::S17044C84 s17044c83f1;
  ::S17044C84 s17044c83f2;
  virtual void  v87(); // _ZN9S17044C833v87Ev
  virtual void  v88(); // _ZN9S17044C833v88Ev
  virtual void  v89(); // _ZN9S17044C833v89Ev
  virtual void  v90(); // _ZN9S17044C833v90Ev
  virtual void  v91(); // _ZN9S17044C833v91Ev
  ~S17044C83(); // tgen
  S17044C83(); // tgen
};
//SIG(-1 S17044C83) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4 v5 Fc FC15{ m Fc Fi Fc Fc[1024] Fi Fi Fp} FC15}


void  S17044C83 ::v87(){vfunc_called(this, "_ZN9S17044C833v87Ev");}
void  S17044C83 ::v88(){vfunc_called(this, "_ZN9S17044C833v88Ev");}
void  S17044C83 ::v89(){vfunc_called(this, "_ZN9S17044C833v89Ev");}
void  S17044C83 ::v90(){vfunc_called(this, "_ZN9S17044C833v90Ev");}
void  S17044C83 ::v91(){vfunc_called(this, "_ZN9S17044C833v91Ev");}
S17044C83 ::~S17044C83(){ note_dtor("S17044C83", this);} // tgen
S17044C83 ::S17044C83(){ note_ctor("S17044C83", this);} // tgen

static void Test_S17044C83()
{
  extern Class_Descriptor cd_S17044C83;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(289,560)];
    init_test(&cd_S17044C83, buf);
    S17044C83 *dp, &lv = *(dp=new (buf) S17044C83());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2304,2236), "sizeof(S17044C83)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C83)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C83");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C83");
    check_field_offset(lv, s17044c83f0, ABISELECT(188,136), "S17044C83.s17044c83f0");
    check_field_offset(lv, s17044c83f1, ABISELECT(192,140), "S17044C83.s17044c83f1");
    check_field_offset(lv, s17044c83f2, ABISELECT(1248,1188), "S17044C83.s17044c83f2");
    test_class_info(&lv, &cd_S17044C83);
    dp->~S17044C83();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C83(Test_S17044C83, "S17044C83", ABISELECT(2304,2236));

#else // __cplusplus

extern void _ZN9S17044C83C1Ev();
extern void _ZN9S17044C83D1Ev();
Name_Map name_map_S17044C83[] = {
  NSPAIR(_ZN9S17044C83C1Ev),
  NSPAIR(_ZN9S17044C83D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C83[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C83[];
extern void _ZN9S17044C83D1Ev();
extern void _ZN9S17044C83D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C833v87Ev();
extern void _ZN9S17044C833v88Ev();
extern void _ZN9S17044C833v89Ev();
extern void _ZN9S17044C833v90Ev();
extern void _ZN9S17044C833v91Ev();
static  VTBL_ENTRY vtc_S17044C83[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C83[0]),
  (VTBL_ENTRY)&_ZN9S17044C83D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C83D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C833v87Ev,
  (VTBL_ENTRY)&_ZN9S17044C833v88Ev,
  (VTBL_ENTRY)&_ZN9S17044C833v89Ev,
  (VTBL_ENTRY)&_ZN9S17044C833v90Ev,
  (VTBL_ENTRY)&_ZN9S17044C833v91Ev,
};
extern VTBL_ENTRY _ZTI9S17044C83[];
extern  VTBL_ENTRY _ZTV9S17044C83[];
Class_Descriptor cd_S17044C83 = {  "S17044C83", // class name
  bases_S17044C83, 2,
  &(vtc_S17044C83[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2304,2236), // object size
  NSPAIRA(_ZTI9S17044C83),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C83),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C86  {
  int s17044c86f0;
  char s17044c86f1;
  void  mf17044c86(); // _ZN9S17044C8610mf17044c86Ev
};
//SIG(-1 S17044C86) C1{ m Fi Fc}


void  S17044C86 ::mf17044c86(){}

static void Test_S17044C86()
{
  {
    init_simple_test("S17044C86");
    S17044C86 lv;
    check2(sizeof(lv), 8, "sizeof(S17044C86)");
    check2(__alignof__(lv), 4, "__alignof__(S17044C86)");
    check_field_offset(lv, s17044c86f0, 0, "S17044C86.s17044c86f0");
    check_field_offset(lv, s17044c86f1, 4, "S17044C86.s17044c86f1");
  }
}
static Arrange_To_Call_Me vS17044C86(Test_S17044C86, "S17044C86", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C85  : S17044C72 {
  ::S17044C86 s17044c85f0;
  ::S17044C84 s17044c85f1;
  virtual  ~S17044C85(); // _ZN9S17044C85D1Ev
  virtual void  v92(); // _ZN9S17044C853v92Ev
  virtual void  v93(); // _ZN9S17044C853v93Ev
  virtual void  v94(); // _ZN9S17044C853v94Ev
  virtual void  v95(); // _ZN9S17044C853v95Ev
  S17044C85(); // tgen
};
//SIG(-1 S17044C85) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} vd v1 v2 v3 v4 FC15{ m Fi Fc} FC16{ m Fc Fi Fc Fc[1024] Fi Fi Fp}}


 S17044C85 ::~S17044C85(){ note_dtor("S17044C85", this);}
void  S17044C85 ::v92(){vfunc_called(this, "_ZN9S17044C853v92Ev");}
void  S17044C85 ::v93(){vfunc_called(this, "_ZN9S17044C853v93Ev");}
void  S17044C85 ::v94(){vfunc_called(this, "_ZN9S17044C853v94Ev");}
void  S17044C85 ::v95(){vfunc_called(this, "_ZN9S17044C853v95Ev");}
S17044C85 ::S17044C85(){ note_ctor("S17044C85", this);} // tgen

static void Test_S17044C85()
{
  extern Class_Descriptor cd_S17044C85;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(158,299)];
    init_test(&cd_S17044C85, buf);
    S17044C85 *dp, &lv = *(dp=new (buf) S17044C85());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1256,1192), "sizeof(S17044C85)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C85)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C85");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C85");
    check_field_offset(lv, s17044c85f0, ABISELECT(188,136), "S17044C85.s17044c85f0");
    check_field_offset(lv, s17044c85f1, ABISELECT(200,144), "S17044C85.s17044c85f1");
    test_class_info(&lv, &cd_S17044C85);
    dp->~S17044C85();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C85(Test_S17044C85, "S17044C85", ABISELECT(1256,1192));

#else // __cplusplus

extern void _ZN9S17044C85C1Ev();
extern void _ZN9S17044C85D1Ev();
Name_Map name_map_S17044C85[] = {
  NSPAIR(_ZN9S17044C85C1Ev),
  NSPAIR(_ZN9S17044C85D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C85[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C85[];
extern void _ZN9S17044C85D1Ev();
extern void _ZN9S17044C85D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C853v92Ev();
extern void _ZN9S17044C853v93Ev();
extern void _ZN9S17044C853v94Ev();
extern void _ZN9S17044C853v95Ev();
static  VTBL_ENTRY vtc_S17044C85[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C85[0]),
  (VTBL_ENTRY)&_ZN9S17044C85D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C85D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C853v92Ev,
  (VTBL_ENTRY)&_ZN9S17044C853v93Ev,
  (VTBL_ENTRY)&_ZN9S17044C853v94Ev,
  (VTBL_ENTRY)&_ZN9S17044C853v95Ev,
};
extern VTBL_ENTRY _ZTI9S17044C85[];
extern  VTBL_ENTRY _ZTV9S17044C85[];
Class_Descriptor cd_S17044C85 = {  "S17044C85", // class name
  bases_S17044C85, 2,
  &(vtc_S17044C85[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1256,1192), // object size
  NSPAIRA(_ZTI9S17044C85),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C85),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C87  : S17044C72 {
  char s17044c87f0;
  virtual  ~S17044C87(); // _ZN9S17044C87D1Ev
  virtual void  v96(); // _ZN9S17044C873v96Ev
  virtual void  v97(); // _ZN9S17044C873v97Ev
  virtual void  v98(); // _ZN9S17044C873v98Ev
  virtual void  v99(); // _ZN9S17044C873v99Ev
  S17044C87(); // tgen
};
//SIG(-1 S17044C87) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} vd v1 v2 v3 v4 Fc}


 S17044C87 ::~S17044C87(){ note_dtor("S17044C87", this);}
void  S17044C87 ::v96(){vfunc_called(this, "_ZN9S17044C873v96Ev");}
void  S17044C87 ::v97(){vfunc_called(this, "_ZN9S17044C873v97Ev");}
void  S17044C87 ::v98(){vfunc_called(this, "_ZN9S17044C873v98Ev");}
void  S17044C87 ::v99(){vfunc_called(this, "_ZN9S17044C873v99Ev");}
S17044C87 ::S17044C87(){ note_ctor("S17044C87", this);} // tgen

static void Test_S17044C87()
{
  extern Class_Descriptor cd_S17044C87;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,36)];
    init_test(&cd_S17044C87, buf);
    S17044C87 *dp, &lv = *(dp=new (buf) S17044C87());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,140), "sizeof(S17044C87)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C87)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C87");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C87");
    check_field_offset(lv, s17044c87f0, ABISELECT(188,136), "S17044C87.s17044c87f0");
    test_class_info(&lv, &cd_S17044C87);
    dp->~S17044C87();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C87(Test_S17044C87, "S17044C87", ABISELECT(192,140));

#else // __cplusplus

extern void _ZN9S17044C87C1Ev();
extern void _ZN9S17044C87D1Ev();
Name_Map name_map_S17044C87[] = {
  NSPAIR(_ZN9S17044C87C1Ev),
  NSPAIR(_ZN9S17044C87D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C87[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C87[];
extern void _ZN9S17044C87D1Ev();
extern void _ZN9S17044C87D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C873v96Ev();
extern void _ZN9S17044C873v97Ev();
extern void _ZN9S17044C873v98Ev();
extern void _ZN9S17044C873v99Ev();
static  VTBL_ENTRY vtc_S17044C87[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C87[0]),
  (VTBL_ENTRY)&_ZN9S17044C87D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C87D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C873v96Ev,
  (VTBL_ENTRY)&_ZN9S17044C873v97Ev,
  (VTBL_ENTRY)&_ZN9S17044C873v98Ev,
  (VTBL_ENTRY)&_ZN9S17044C873v99Ev,
};
extern VTBL_ENTRY _ZTI9S17044C87[];
extern  VTBL_ENTRY _ZTV9S17044C87[];
Class_Descriptor cd_S17044C87 = {  "S17044C87", // class name
  bases_S17044C87, 2,
  &(vtc_S17044C87[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,140), // object size
  NSPAIRA(_ZTI9S17044C87),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C87),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C88  : S17044C72 {
  ::S17044C86 s17044c88f0;
  ::S17044C84 s17044c88f1;
  ::S17044C73 s17044c88f2;
  virtual  ~S17044C88(); // _ZN9S17044C88D1Ev
  virtual void  v100(); // _ZN9S17044C884v100Ev
  virtual void  v101(); // _ZN9S17044C884v101Ev
  virtual void  v102(); // _ZN9S17044C884v102Ev
  virtual void  v103(); // _ZN9S17044C884v103Ev
  S17044C88(); // tgen
};
//SIG(-1 S17044C88) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} vd v1 v2 v3 v4 FC15{ m Fi Fc} FC16{ m Fc Fi Fc Fc[1024] Fi Fi Fp} FC9}


 S17044C88 ::~S17044C88(){ note_dtor("S17044C88", this);}
void  S17044C88 ::v100(){vfunc_called(this, "_ZN9S17044C884v100Ev");}
void  S17044C88 ::v101(){vfunc_called(this, "_ZN9S17044C884v101Ev");}
void  S17044C88 ::v102(){vfunc_called(this, "_ZN9S17044C884v102Ev");}
void  S17044C88 ::v103(){vfunc_called(this, "_ZN9S17044C884v103Ev");}
S17044C88 ::S17044C88(){ note_ctor("S17044C88", this);} // tgen

static void Test_S17044C88()
{
  extern Class_Descriptor cd_S17044C88;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(162,306)];
    init_test(&cd_S17044C88, buf);
    S17044C88 *dp, &lv = *(dp=new (buf) S17044C88());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1288,1220), "sizeof(S17044C88)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C88)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C88");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C88");
    check_field_offset(lv, s17044c88f0, ABISELECT(188,136), "S17044C88.s17044c88f0");
    check_field_offset(lv, s17044c88f1, ABISELECT(200,144), "S17044C88.s17044c88f1");
    check_field_offset(lv, s17044c88f2, ABISELECT(1256,1192), "S17044C88.s17044c88f2");
    test_class_info(&lv, &cd_S17044C88);
    dp->~S17044C88();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C88(Test_S17044C88, "S17044C88", ABISELECT(1288,1220));

#else // __cplusplus

extern void _ZN9S17044C88C1Ev();
extern void _ZN9S17044C88D1Ev();
Name_Map name_map_S17044C88[] = {
  NSPAIR(_ZN9S17044C88C1Ev),
  NSPAIR(_ZN9S17044C88D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C88[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C88[];
extern void _ZN9S17044C88D1Ev();
extern void _ZN9S17044C88D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C884v100Ev();
extern void _ZN9S17044C884v101Ev();
extern void _ZN9S17044C884v102Ev();
extern void _ZN9S17044C884v103Ev();
static  VTBL_ENTRY vtc_S17044C88[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C88[0]),
  (VTBL_ENTRY)&_ZN9S17044C88D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C88D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C884v100Ev,
  (VTBL_ENTRY)&_ZN9S17044C884v101Ev,
  (VTBL_ENTRY)&_ZN9S17044C884v102Ev,
  (VTBL_ENTRY)&_ZN9S17044C884v103Ev,
};
extern VTBL_ENTRY _ZTI9S17044C88[];
extern  VTBL_ENTRY _ZTV9S17044C88[];
Class_Descriptor cd_S17044C88 = {  "S17044C88", // class name
  bases_S17044C88, 2,
  &(vtc_S17044C88[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1288,1220), // object size
  NSPAIRA(_ZTI9S17044C88),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C88),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C90  {
  int s17044c90f0;
  int s17044c90f1;
  int s17044c90f2;
  char s17044c90f3;
  void  mf17044c90(); // _ZN9S17044C9010mf17044c90Ev
};
//SIG(-1 S17044C90) C1{ m Fi[3] Fc}


void  S17044C90 ::mf17044c90(){}

static void Test_S17044C90()
{
  {
    init_simple_test("S17044C90");
    S17044C90 lv;
    check2(sizeof(lv), 16, "sizeof(S17044C90)");
    check2(__alignof__(lv), 4, "__alignof__(S17044C90)");
    check_field_offset(lv, s17044c90f0, 0, "S17044C90.s17044c90f0");
    check_field_offset(lv, s17044c90f1, 4, "S17044C90.s17044c90f1");
    check_field_offset(lv, s17044c90f2, 8, "S17044C90.s17044c90f2");
    check_field_offset(lv, s17044c90f3, 12, "S17044C90.s17044c90f3");
  }
}
static Arrange_To_Call_Me vS17044C90(Test_S17044C90, "S17044C90", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C96  : S17044C7_nt {
  ::S17044C8 s17044c96f0;
};
//SIG(-1 S17044C96) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C96()
{
  extern Class_Descriptor cd_S17044C96;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C96, buf);
    S17044C96 &lv = *(new (buf) S17044C96());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C96)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C96)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C96");
    check_field_offset(lv, s17044c96f0, 0, "S17044C96.s17044c96f0");
    test_class_info(&lv, &cd_S17044C96);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C96(Test_S17044C96, "S17044C96", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C96[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C96 = {  "S17044C96", // class name
  bases_S17044C96, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C95  : S17044C96 {
  ::S17044C76 s17044c95f0;
};
//SIG(-1 S17044C95) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S17044C95()
{
  extern Class_Descriptor cd_S17044C95;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S17044C95, buf);
    S17044C95 &lv = *(new (buf) S17044C95());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S17044C95)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C95)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C96*), 0, "S17044C95");
    check_base_class_offset(lv, (S17044C96*), 0, "S17044C95");
    check_field_offset(lv, s17044c95f0, 1, "S17044C95.s17044c95f0");
    test_class_info(&lv, &cd_S17044C95);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C95(Test_S17044C95, "S17044C95", 2);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C96;
static Base_Class bases_S17044C95[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C95 = {  "S17044C95", // class name
  bases_S17044C95, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C100  {
};
//SIG(-1 S17044C100) C1{}



static void Test_S17044C100()
{
  {
    init_simple_test("S17044C100");
    S17044C100 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C100)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C100)");
  }
}
static Arrange_To_Call_Me vS17044C100(Test_S17044C100, "S17044C100", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C100 = {  "S17044C100", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C99  : S17044C100 {
};
//SIG(-1 S17044C99) C1{ BC2{}}



static void Test_S17044C99()
{
  extern Class_Descriptor cd_S17044C99;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C99, buf);
    S17044C99 &lv = *(new (buf) S17044C99());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C99)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C99)");
    check_base_class_offset(lv, (S17044C100*), 0, "S17044C99");
    test_class_info(&lv, &cd_S17044C99);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C99(Test_S17044C99, "S17044C99", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C100;
static Base_Class bases_S17044C99[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C99 = {  "S17044C99", // class name
  bases_S17044C99, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C94  : S17044C95 {
  ::S17044C99 s17044c94f0;
};
//SIG(-1 S17044C94) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC9{ BC10{}}}



static void Test_S17044C94()
{
  extern Class_Descriptor cd_S17044C94;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S17044C94, buf);
    S17044C94 &lv = *(new (buf) S17044C94());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S17044C94)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C94)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C96*)(S17044C95*), 0, "S17044C94");
    check_base_class_offset(lv, (S17044C96*)(S17044C95*), 0, "S17044C94");
    check_base_class_offset(lv, (S17044C95*), 0, "S17044C94");
    check_field_offset(lv, s17044c94f0, 2, "S17044C94.s17044c94f0");
    test_class_info(&lv, &cd_S17044C94);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C94(Test_S17044C94, "S17044C94", 3);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C96;
extern Class_Descriptor cd_S17044C95;
static Base_Class bases_S17044C94[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C95,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C94 = {  "S17044C94", // class name
  bases_S17044C94, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C93  : S17044C94 {
  ::S17044C99 s17044c93f0;
};
//SIG(-1 S17044C93) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC10{ BC11{}}} FC10}



static void Test_S17044C93()
{
  extern Class_Descriptor cd_S17044C93;
  void *lvp;
  {
    char buf[4];
    init_test(&cd_S17044C93, buf);
    S17044C93 &lv = *(new (buf) S17044C93());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S17044C93)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C93)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C96*)(S17044C95*)(S17044C94*), 0, "S17044C93");
    check_base_class_offset(lv, (S17044C96*)(S17044C95*)(S17044C94*), 0, "S17044C93");
    check_base_class_offset(lv, (S17044C95*)(S17044C94*), 0, "S17044C93");
    check_base_class_offset(lv, (S17044C94*), 0, "S17044C93");
    check_field_offset(lv, s17044c93f0, 3, "S17044C93.s17044c93f0");
    test_class_info(&lv, &cd_S17044C93);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C93(Test_S17044C93, "S17044C93", 4);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C96;
extern Class_Descriptor cd_S17044C95;
extern Class_Descriptor cd_S17044C94;
static Base_Class bases_S17044C93[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C95,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C94,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C93 = {  "S17044C93", // class name
  bases_S17044C93, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C92  : S17044C93 {
  void *s17044c92f0;
  int s17044c92f1;
};
//SIG(-1 S17044C92) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC9{ BC10{}}} FC11{ BC12{}}} FC11} Fp Fi}



static void Test_S17044C92()
{
  extern Class_Descriptor cd_S17044C92;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S17044C92, buf);
    S17044C92 &lv = *(new (buf) S17044C92());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17044C92)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C92)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C96*)(S17044C95*)(S17044C94*)(S17044C93*), 0, "S17044C92");
    check_base_class_offset(lv, (S17044C96*)(S17044C95*)(S17044C94*)(S17044C93*), 0, "S17044C92");
    check_base_class_offset(lv, (S17044C95*)(S17044C94*)(S17044C93*), 0, "S17044C92");
    check_base_class_offset(lv, (S17044C94*)(S17044C93*), 0, "S17044C92");
    check_base_class_offset(lv, (S17044C93*), 0, "S17044C92");
    check_field_offset(lv, s17044c92f0, ABISELECT(8,4), "S17044C92.s17044c92f0");
    check_field_offset(lv, s17044c92f1, ABISELECT(16,8), "S17044C92.s17044c92f1");
    test_class_info(&lv, &cd_S17044C92);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C92(Test_S17044C92, "S17044C92", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C96;
extern Class_Descriptor cd_S17044C95;
extern Class_Descriptor cd_S17044C94;
extern Class_Descriptor cd_S17044C93;
static Base_Class bases_S17044C92[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C95,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C94,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S17044C93,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C92 = {  "S17044C92", // class name
  bases_S17044C92, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C91  : S17044C92 {
};
//SIG(-1 S17044C91) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC10{ BC11{}}} FC12{ BC13{}}} FC12} Fp Fi}}



static void Test_S17044C91()
{
  extern Class_Descriptor cd_S17044C91;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S17044C91, buf);
    S17044C91 &lv = *(new (buf) S17044C91());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17044C91)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C91)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C96*)(S17044C95*)(S17044C94*)(S17044C93*)(S17044C92*), 0, "S17044C91");
    check_base_class_offset(lv, (S17044C96*)(S17044C95*)(S17044C94*)(S17044C93*)(S17044C92*), 0, "S17044C91");
    check_base_class_offset(lv, (S17044C95*)(S17044C94*)(S17044C93*)(S17044C92*), 0, "S17044C91");
    check_base_class_offset(lv, (S17044C94*)(S17044C93*)(S17044C92*), 0, "S17044C91");
    check_base_class_offset(lv, (S17044C93*)(S17044C92*), 0, "S17044C91");
    check_base_class_offset(lv, (S17044C92*), 0, "S17044C91");
    test_class_info(&lv, &cd_S17044C91);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C91(Test_S17044C91, "S17044C91", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C96;
extern Class_Descriptor cd_S17044C95;
extern Class_Descriptor cd_S17044C94;
extern Class_Descriptor cd_S17044C93;
extern Class_Descriptor cd_S17044C92;
static Base_Class bases_S17044C91[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C96,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C95,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C94,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S17044C93,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S17044C92,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C91 = {  "S17044C91", // class name
  bases_S17044C91, 6,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C89  : S17044C72 {
  int s17044c89f0;
  int s17044c89f1;
  ::S17044C90 s17044c89f2;
  ::S17044C90 s17044c89f3;
  ::S17044C91 s17044c89f4;
  int s17044c89f5;
  virtual void  v104(); // _ZN9S17044C894v104Ev
  virtual void  v105(); // _ZN9S17044C894v105Ev
  virtual void  v106(); // _ZN9S17044C894v106Ev
  virtual void  v107(); // _ZN9S17044C894v107Ev
  ~S17044C89(); // tgen
  S17044C89(); // tgen
};
//SIG(-1 S17044C89) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4 Fi Fi FC15{ m Fi Fi Fi Fc} FC15 FC16{ BC17{ BC18{ BC19{ BC20{ BC21{ BC6 FC7} FC12} FC22{ BC23{}}} FC22} Fp Fi}} Fi}


void  S17044C89 ::v104(){vfunc_called(this, "_ZN9S17044C894v104Ev");}
void  S17044C89 ::v105(){vfunc_called(this, "_ZN9S17044C894v105Ev");}
void  S17044C89 ::v106(){vfunc_called(this, "_ZN9S17044C894v106Ev");}
void  S17044C89 ::v107(){vfunc_called(this, "_ZN9S17044C894v107Ev");}
S17044C89 ::~S17044C89(){ note_dtor("S17044C89", this);} // tgen
S17044C89 ::S17044C89(){ note_ctor("S17044C89", this);} // tgen

static void Test_S17044C89()
{
  extern Class_Descriptor cd_S17044C89;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,49)];
    init_test(&cd_S17044C89, buf);
    S17044C89 *dp, &lv = *(dp=new (buf) S17044C89());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,192), "sizeof(S17044C89)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C89)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C89");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C89");
    check_field_offset(lv, s17044c89f0, ABISELECT(188,136), "S17044C89.s17044c89f0");
    check_field_offset(lv, s17044c89f1, ABISELECT(192,140), "S17044C89.s17044c89f1");
    check_field_offset(lv, s17044c89f2, ABISELECT(196,144), "S17044C89.s17044c89f2");
    check_field_offset(lv, s17044c89f3, ABISELECT(212,160), "S17044C89.s17044c89f3");
    check_field_offset(lv, s17044c89f4, ABISELECT(232,176), "S17044C89.s17044c89f4");
    check_field_offset(lv, s17044c89f5, ABISELECT(256,188), "S17044C89.s17044c89f5");
    test_class_info(&lv, &cd_S17044C89);
    dp->~S17044C89();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C89(Test_S17044C89, "S17044C89", ABISELECT(264,192));

#else // __cplusplus

extern void _ZN9S17044C89C1Ev();
extern void _ZN9S17044C89D1Ev();
Name_Map name_map_S17044C89[] = {
  NSPAIR(_ZN9S17044C89C1Ev),
  NSPAIR(_ZN9S17044C89D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C89[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17044C89[];
extern void _ZN9S17044C89D1Ev();
extern void _ZN9S17044C89D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN9S17044C894v104Ev();
extern void _ZN9S17044C894v105Ev();
extern void _ZN9S17044C894v106Ev();
extern void _ZN9S17044C894v107Ev();
static  VTBL_ENTRY vtc_S17044C89[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17044C89[0]),
  (VTBL_ENTRY)&_ZN9S17044C89D1Ev,
  (VTBL_ENTRY)&_ZN9S17044C89D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17044C894v104Ev,
  (VTBL_ENTRY)&_ZN9S17044C894v105Ev,
  (VTBL_ENTRY)&_ZN9S17044C894v106Ev,
  (VTBL_ENTRY)&_ZN9S17044C894v107Ev,
};
extern VTBL_ENTRY _ZTI9S17044C89[];
extern  VTBL_ENTRY _ZTV9S17044C89[];
Class_Descriptor cd_S17044C89 = {  "S17044C89", // class name
  bases_S17044C89, 2,
  &(vtc_S17044C89[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,192), // object size
  NSPAIRA(_ZTI9S17044C89),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17044C89),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C103  : S17044C72 {
  int s17044c103f0;
  int s17044c103f1;
  virtual  ~S17044C103(); // _ZN10S17044C103D1Ev
  virtual void  v108(); // _ZN10S17044C1034v108Ev
  virtual void  v109(); // _ZN10S17044C1034v109Ev
  virtual void  v110(); // _ZN10S17044C1034v110Ev
  virtual void  v111(); // _ZN10S17044C1034v111Ev
  S17044C103(); // tgen
};
//SIG(-1 S17044C103) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} vd v1 v2 v3 v4 Fi Fi}


 S17044C103 ::~S17044C103(){ note_dtor("S17044C103", this);}
void  S17044C103 ::v108(){vfunc_called(this, "_ZN10S17044C1034v108Ev");}
void  S17044C103 ::v109(){vfunc_called(this, "_ZN10S17044C1034v109Ev");}
void  S17044C103 ::v110(){vfunc_called(this, "_ZN10S17044C1034v110Ev");}
void  S17044C103 ::v111(){vfunc_called(this, "_ZN10S17044C1034v111Ev");}
S17044C103 ::S17044C103(){ note_ctor("S17044C103", this);} // tgen

static void Test_S17044C103()
{
  extern Class_Descriptor cd_S17044C103;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,37)];
    init_test(&cd_S17044C103, buf);
    S17044C103 *dp, &lv = *(dp=new (buf) S17044C103());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,144), "sizeof(S17044C103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C103)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C103");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C103");
    check_field_offset(lv, s17044c103f0, ABISELECT(188,136), "S17044C103.s17044c103f0");
    check_field_offset(lv, s17044c103f1, ABISELECT(192,140), "S17044C103.s17044c103f1");
    test_class_info(&lv, &cd_S17044C103);
    dp->~S17044C103();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C103(Test_S17044C103, "S17044C103", ABISELECT(200,144));

#else // __cplusplus

extern void _ZN10S17044C103C1Ev();
extern void _ZN10S17044C103D1Ev();
Name_Map name_map_S17044C103[] = {
  NSPAIR(_ZN10S17044C103C1Ev),
  NSPAIR(_ZN10S17044C103D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C103[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C103[];
extern void _ZN10S17044C103D1Ev();
extern void _ZN10S17044C103D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN10S17044C1034v108Ev();
extern void _ZN10S17044C1034v109Ev();
extern void _ZN10S17044C1034v110Ev();
extern void _ZN10S17044C1034v111Ev();
static  VTBL_ENTRY vtc_S17044C103[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C103[0]),
  (VTBL_ENTRY)&_ZN10S17044C103D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C103D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17044C1034v108Ev,
  (VTBL_ENTRY)&_ZN10S17044C1034v109Ev,
  (VTBL_ENTRY)&_ZN10S17044C1034v110Ev,
  (VTBL_ENTRY)&_ZN10S17044C1034v111Ev,
};
extern VTBL_ENTRY _ZTI10S17044C103[];
extern  VTBL_ENTRY _ZTV10S17044C103[];
Class_Descriptor cd_S17044C103 = {  "S17044C103", // class name
  bases_S17044C103, 2,
  &(vtc_S17044C103[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,144), // object size
  NSPAIRA(_ZTI10S17044C103),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C103),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C104  : S17044C72 {
  char s17044c104f0;
  int s17044c104f1;
  char s17044c104f2;
  virtual void  v112(); // _ZN10S17044C1044v112Ev
  virtual void  v113(); // _ZN10S17044C1044v113Ev
  virtual void  v114(); // _ZN10S17044C1044v114Ev
  virtual void  v115(); // _ZN10S17044C1044v115Ev
  virtual void  v116(); // _ZN10S17044C1044v116Ev
  ~S17044C104(); // tgen
  S17044C104(); // tgen
};
//SIG(-1 S17044C104) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4 v5 Fc Fi Fc}


void  S17044C104 ::v112(){vfunc_called(this, "_ZN10S17044C1044v112Ev");}
void  S17044C104 ::v113(){vfunc_called(this, "_ZN10S17044C1044v113Ev");}
void  S17044C104 ::v114(){vfunc_called(this, "_ZN10S17044C1044v114Ev");}
void  S17044C104 ::v115(){vfunc_called(this, "_ZN10S17044C1044v115Ev");}
void  S17044C104 ::v116(){vfunc_called(this, "_ZN10S17044C1044v116Ev");}
S17044C104 ::~S17044C104(){ note_dtor("S17044C104", this);} // tgen
S17044C104 ::S17044C104(){ note_ctor("S17044C104", this);} // tgen

static void Test_S17044C104()
{
  extern Class_Descriptor cd_S17044C104;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,38)];
    init_test(&cd_S17044C104, buf);
    S17044C104 *dp, &lv = *(dp=new (buf) S17044C104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,148), "sizeof(S17044C104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C104)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C104");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C104");
    check_field_offset(lv, s17044c104f0, ABISELECT(188,136), "S17044C104.s17044c104f0");
    check_field_offset(lv, s17044c104f1, ABISELECT(192,140), "S17044C104.s17044c104f1");
    check_field_offset(lv, s17044c104f2, ABISELECT(196,144), "S17044C104.s17044c104f2");
    test_class_info(&lv, &cd_S17044C104);
    dp->~S17044C104();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C104(Test_S17044C104, "S17044C104", ABISELECT(200,148));

#else // __cplusplus

extern void _ZN10S17044C104C1Ev();
extern void _ZN10S17044C104D1Ev();
Name_Map name_map_S17044C104[] = {
  NSPAIR(_ZN10S17044C104C1Ev),
  NSPAIR(_ZN10S17044C104D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C104[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C104[];
extern void _ZN10S17044C104D1Ev();
extern void _ZN10S17044C104D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN10S17044C1044v112Ev();
extern void _ZN10S17044C1044v113Ev();
extern void _ZN10S17044C1044v114Ev();
extern void _ZN10S17044C1044v115Ev();
extern void _ZN10S17044C1044v116Ev();
static  VTBL_ENTRY vtc_S17044C104[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C104[0]),
  (VTBL_ENTRY)&_ZN10S17044C104D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C104D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17044C1044v112Ev,
  (VTBL_ENTRY)&_ZN10S17044C1044v113Ev,
  (VTBL_ENTRY)&_ZN10S17044C1044v114Ev,
  (VTBL_ENTRY)&_ZN10S17044C1044v115Ev,
  (VTBL_ENTRY)&_ZN10S17044C1044v116Ev,
};
extern VTBL_ENTRY _ZTI10S17044C104[];
extern  VTBL_ENTRY _ZTV10S17044C104[];
Class_Descriptor cd_S17044C104 = {  "S17044C104", // class name
  bases_S17044C104, 2,
  &(vtc_S17044C104[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,148), // object size
  NSPAIRA(_ZTI10S17044C104),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C104),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C106  : S17044C72 {
  virtual void  v121(); // _ZN10S17044C1064v121Ev
  virtual void  v122(); // _ZN10S17044C1064v122Ev
  ~S17044C106(); // tgen
  S17044C106(); // tgen
};
//SIG(-1 S17044C106) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2}


void  S17044C106 ::v121(){vfunc_called(this, "_ZN10S17044C1064v121Ev");}
void  S17044C106 ::v122(){vfunc_called(this, "_ZN10S17044C1064v122Ev");}
S17044C106 ::~S17044C106(){ note_dtor("S17044C106", this);} // tgen
S17044C106 ::S17044C106(){ note_ctor("S17044C106", this);} // tgen

static void Test_S17044C106()
{
  extern Class_Descriptor cd_S17044C106;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17044C106, buf);
    S17044C106 *dp, &lv = *(dp=new (buf) S17044C106());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17044C106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C106)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C106");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C106");
    test_class_info(&lv, &cd_S17044C106);
    dp->~S17044C106();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C106(Test_S17044C106, "S17044C106", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN10S17044C106C1Ev();
extern void _ZN10S17044C106D1Ev();
Name_Map name_map_S17044C106[] = {
  NSPAIR(_ZN10S17044C106C1Ev),
  NSPAIR(_ZN10S17044C106D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C106[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C106[];
extern void _ZN10S17044C106D1Ev();
extern void _ZN10S17044C106D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN10S17044C1064v121Ev();
extern void _ZN10S17044C1064v122Ev();
static  VTBL_ENTRY vtc_S17044C106[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C106[0]),
  (VTBL_ENTRY)&_ZN10S17044C106D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C106D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17044C1064v121Ev,
  (VTBL_ENTRY)&_ZN10S17044C1064v122Ev,
};
extern VTBL_ENTRY _ZTI10S17044C106[];
extern  VTBL_ENTRY _ZTV10S17044C106[];
Class_Descriptor cd_S17044C106 = {  "S17044C106", // class name
  bases_S17044C106, 2,
  &(vtc_S17044C106[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI10S17044C106),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C106),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C108  : S17044C72 {
  virtual void  v125(); // _ZN10S17044C1084v125Ev
  virtual void  v126(); // _ZN10S17044C1084v126Ev
  virtual void  v127(); // _ZN10S17044C1084v127Ev
  virtual void  v128(); // _ZN10S17044C1084v128Ev
  ~S17044C108(); // tgen
  S17044C108(); // tgen
};
//SIG(-1 S17044C108) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4}


void  S17044C108 ::v125(){vfunc_called(this, "_ZN10S17044C1084v125Ev");}
void  S17044C108 ::v126(){vfunc_called(this, "_ZN10S17044C1084v126Ev");}
void  S17044C108 ::v127(){vfunc_called(this, "_ZN10S17044C1084v127Ev");}
void  S17044C108 ::v128(){vfunc_called(this, "_ZN10S17044C1084v128Ev");}
S17044C108 ::~S17044C108(){ note_dtor("S17044C108", this);} // tgen
S17044C108 ::S17044C108(){ note_ctor("S17044C108", this);} // tgen

static void Test_S17044C108()
{
  extern Class_Descriptor cd_S17044C108;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17044C108, buf);
    S17044C108 *dp, &lv = *(dp=new (buf) S17044C108());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17044C108)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C108)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C108");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C108");
    test_class_info(&lv, &cd_S17044C108);
    dp->~S17044C108();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C108(Test_S17044C108, "S17044C108", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN10S17044C108C1Ev();
extern void _ZN10S17044C108D1Ev();
Name_Map name_map_S17044C108[] = {
  NSPAIR(_ZN10S17044C108C1Ev),
  NSPAIR(_ZN10S17044C108D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C108[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C108[];
extern void _ZN10S17044C108D1Ev();
extern void _ZN10S17044C108D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN10S17044C1084v125Ev();
extern void _ZN10S17044C1084v126Ev();
extern void _ZN10S17044C1084v127Ev();
extern void _ZN10S17044C1084v128Ev();
static  VTBL_ENTRY vtc_S17044C108[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C108[0]),
  (VTBL_ENTRY)&_ZN10S17044C108D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C108D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17044C1084v125Ev,
  (VTBL_ENTRY)&_ZN10S17044C1084v126Ev,
  (VTBL_ENTRY)&_ZN10S17044C1084v127Ev,
  (VTBL_ENTRY)&_ZN10S17044C1084v128Ev,
};
extern VTBL_ENTRY _ZTI10S17044C108[];
extern  VTBL_ENTRY _ZTV10S17044C108[];
Class_Descriptor cd_S17044C108 = {  "S17044C108", // class name
  bases_S17044C108, 2,
  &(vtc_S17044C108[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI10S17044C108),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C108),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C110  : S17044C72 {
  virtual void  v133(); // _ZN10S17044C1104v133Ev
  virtual void  v134(); // _ZN10S17044C1104v134Ev
  ~S17044C110(); // tgen
  S17044C110(); // tgen
};
//SIG(-1 S17044C110) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2}


void  S17044C110 ::v133(){vfunc_called(this, "_ZN10S17044C1104v133Ev");}
void  S17044C110 ::v134(){vfunc_called(this, "_ZN10S17044C1104v134Ev");}
S17044C110 ::~S17044C110(){ note_dtor("S17044C110", this);} // tgen
S17044C110 ::S17044C110(){ note_ctor("S17044C110", this);} // tgen

static void Test_S17044C110()
{
  extern Class_Descriptor cd_S17044C110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17044C110, buf);
    S17044C110 *dp, &lv = *(dp=new (buf) S17044C110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17044C110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C110)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C110");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C110");
    test_class_info(&lv, &cd_S17044C110);
    dp->~S17044C110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C110(Test_S17044C110, "S17044C110", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN10S17044C110C1Ev();
extern void _ZN10S17044C110D1Ev();
Name_Map name_map_S17044C110[] = {
  NSPAIR(_ZN10S17044C110C1Ev),
  NSPAIR(_ZN10S17044C110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C110[];
extern void _ZN10S17044C110D1Ev();
extern void _ZN10S17044C110D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN10S17044C1104v133Ev();
extern void _ZN10S17044C1104v134Ev();
static  VTBL_ENTRY vtc_S17044C110[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C110[0]),
  (VTBL_ENTRY)&_ZN10S17044C110D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C110D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17044C1104v133Ev,
  (VTBL_ENTRY)&_ZN10S17044C1104v134Ev,
};
extern VTBL_ENTRY _ZTI10S17044C110[];
extern  VTBL_ENTRY _ZTV10S17044C110[];
Class_Descriptor cd_S17044C110 = {  "S17044C110", // class name
  bases_S17044C110, 2,
  &(vtc_S17044C110[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI10S17044C110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C110),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C111  : S17044C72 {
  virtual void  v135(); // _ZN10S17044C1114v135Ev
  virtual void  v136(); // _ZN10S17044C1114v136Ev
  virtual void  v137(); // _ZN10S17044C1114v137Ev
  virtual void  v138(); // _ZN10S17044C1114v138Ev
  ~S17044C111(); // tgen
  S17044C111(); // tgen
};
//SIG(-1 S17044C111) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4}


void  S17044C111 ::v135(){vfunc_called(this, "_ZN10S17044C1114v135Ev");}
void  S17044C111 ::v136(){vfunc_called(this, "_ZN10S17044C1114v136Ev");}
void  S17044C111 ::v137(){vfunc_called(this, "_ZN10S17044C1114v137Ev");}
void  S17044C111 ::v138(){vfunc_called(this, "_ZN10S17044C1114v138Ev");}
S17044C111 ::~S17044C111(){ note_dtor("S17044C111", this);} // tgen
S17044C111 ::S17044C111(){ note_ctor("S17044C111", this);} // tgen

static void Test_S17044C111()
{
  extern Class_Descriptor cd_S17044C111;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17044C111, buf);
    S17044C111 *dp, &lv = *(dp=new (buf) S17044C111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17044C111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C111)");
    check_base_class_offset(lv, (S17044C4*)(S17044C72*), 0, "S17044C111");
    check_base_class_offset(lv, (S17044C72*), 0, "S17044C111");
    test_class_info(&lv, &cd_S17044C111);
    dp->~S17044C111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C111(Test_S17044C111, "S17044C111", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN10S17044C111C1Ev();
extern void _ZN10S17044C111D1Ev();
Name_Map name_map_S17044C111[] = {
  NSPAIR(_ZN10S17044C111C1Ev),
  NSPAIR(_ZN10S17044C111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C72;
extern VTBL_ENTRY _ZTI9S17044C72[];
extern  VTBL_ENTRY _ZTV9S17044C72[];
static Base_Class bases_S17044C111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C111[];
extern void _ZN10S17044C111D1Ev();
extern void _ZN10S17044C111D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN9S17044C723v55Ev();
extern void _ZN9S17044C723v56Ev();
extern void _ZN9S17044C723v57Ev();
extern void _ZN9S17044C723v58Ev();
extern void _ZN9S17044C723v59Ev();
extern void _ZN9S17044C723v60Ev();
extern void _ZN9S17044C723v61Ev();
extern void _ZN9S17044C723v62Ev();
extern void _ZN9S17044C723v63Ev();
extern void _ZN9S17044C723v64Ev();
extern void _ZN9S17044C723v65Ev();
extern void _ZN9S17044C723v66Ev();
extern void _ZN9S17044C723v67Ev();
extern void _ZN9S17044C723v68Ev();
extern void _ZN9S17044C723v69Ev();
extern void _ZN10S17044C1114v135Ev();
extern void _ZN10S17044C1114v136Ev();
extern void _ZN10S17044C1114v137Ev();
extern void _ZN10S17044C1114v138Ev();
static  VTBL_ENTRY vtc_S17044C111[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C111[0]),
  (VTBL_ENTRY)&_ZN10S17044C111D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C111D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17044C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17044C1114v135Ev,
  (VTBL_ENTRY)&_ZN10S17044C1114v136Ev,
  (VTBL_ENTRY)&_ZN10S17044C1114v137Ev,
  (VTBL_ENTRY)&_ZN10S17044C1114v138Ev,
};
extern VTBL_ENTRY _ZTI10S17044C111[];
extern  VTBL_ENTRY _ZTV10S17044C111[];
Class_Descriptor cd_S17044C111 = {  "S17044C111", // class name
  bases_S17044C111, 2,
  &(vtc_S17044C111[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI10S17044C111),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C111),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C116  {
};
//SIG(-1 S17044C116) C1{}



static void Test_S17044C116()
{
  {
    init_simple_test("S17044C116");
    S17044C116 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C116)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C116)");
  }
}
static Arrange_To_Call_Me vS17044C116(Test_S17044C116, "S17044C116", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C116 = {  "S17044C116", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C115  : S17044C116 {
};
//SIG(-1 S17044C115) C1{ BC2{}}



static void Test_S17044C115()
{
  extern Class_Descriptor cd_S17044C115;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C115, buf);
    S17044C115 &lv = *(new (buf) S17044C115());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C115)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C115)");
    check_base_class_offset(lv, (S17044C116*), 0, "S17044C115");
    test_class_info(&lv, &cd_S17044C115);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C115(Test_S17044C115, "S17044C115", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C116;
static Base_Class bases_S17044C115[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C116,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C115 = {  "S17044C115", // class name
  bases_S17044C115, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C114  : S17044C7_nt {
  ::S17044C115 s17044c114f0;
};
//SIG(-1 S17044C114) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C114()
{
  extern Class_Descriptor cd_S17044C114;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C114, buf);
    S17044C114 &lv = *(new (buf) S17044C114());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C114)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C114)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C114");
    check_field_offset(lv, s17044c114f0, 0, "S17044C114.s17044c114f0");
    test_class_info(&lv, &cd_S17044C114);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C114(Test_S17044C114, "S17044C114", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C114[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C114 = {  "S17044C114", // class name
  bases_S17044C114, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C113  : S17044C114 {
  void *s17044c113f0;
  void *s17044c113f1;
  void *s17044c113f2;
};
//SIG(-1 S17044C113) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S17044C113()
{
  extern Class_Descriptor cd_S17044C113;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S17044C113, buf);
    S17044C113 &lv = *(new (buf) S17044C113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17044C113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C113)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C114*), 0, "S17044C113");
    check_base_class_offset(lv, (S17044C114*), 0, "S17044C113");
    check_field_offset(lv, s17044c113f0, ABISELECT(8,4), "S17044C113.s17044c113f0");
    check_field_offset(lv, s17044c113f1, ABISELECT(16,8), "S17044C113.s17044c113f1");
    check_field_offset(lv, s17044c113f2, ABISELECT(24,12), "S17044C113.s17044c113f2");
    test_class_info(&lv, &cd_S17044C113);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C113(Test_S17044C113, "S17044C113", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C114;
static Base_Class bases_S17044C113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C114,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C113 = {  "S17044C113", // class name
  bases_S17044C113, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C122  {
  void *s17044c122f0;
  void  mf17044c122(); // _ZN10S17044C12211mf17044c122Ev
};
//SIG(-1 S17044C122) C1{ m Fp}


void  S17044C122 ::mf17044c122(){}

static void Test_S17044C122()
{
  {
    init_simple_test("S17044C122");
    S17044C122 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17044C122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C122)");
    check_field_offset(lv, s17044c122f0, 0, "S17044C122.s17044c122f0");
  }
}
static Arrange_To_Call_Me vS17044C122(Test_S17044C122, "S17044C122", ABISELECT(8,4));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S17044C122[];
VTBL_ENTRY *P__ZTI10S17044C122 = _ZTI10S17044C122; 
Class_Descriptor cd_S17044C122 = {  "S17044C122", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S17044C122),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C121  : S17044C122 {
};
//SIG(-1 S17044C121) C1{ BC2{ m Fp}}



static void Test_S17044C121()
{
  extern Class_Descriptor cd_S17044C121;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S17044C121, buf);
    S17044C121 &lv = *(new (buf) S17044C121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17044C121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C121)");
    check_base_class_offset(lv, (S17044C122*), 0, "S17044C121");
    test_class_info(&lv, &cd_S17044C121);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C121(Test_S17044C121, "S17044C121", ABISELECT(8,4));

#else // __cplusplus

extern Class_Descriptor cd_S17044C122;
extern VTBL_ENTRY _ZTI10S17044C122[];
static Base_Class bases_S17044C121[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C122,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C121 = {  "S17044C121", // class name
  bases_S17044C121, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C123_nt  {
  __tsi64 s17044c123f0;
  void  mf17044c123(); // _ZN13S17044C123_nt11mf17044c123Ev
};
//SIG(-1 S17044C123_nt) C1{ m FL}


void  S17044C123_nt ::mf17044c123(){}

//skip512 S17044C123_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C126  {
  char s17044c126f0;
  char s17044c126f1[15];
  void  mf17044c126(); // _ZN10S17044C12611mf17044c126Ev
};
//SIG(-1 S17044C126) C1{ m Fc[16]}


void  S17044C126 ::mf17044c126(){}

static void Test_S17044C126()
{
  {
    init_simple_test("S17044C126");
    S17044C126 lv;
    check2(sizeof(lv), 16, "sizeof(S17044C126)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C126)");
    check_field_offset(lv, s17044c126f0, 0, "S17044C126.s17044c126f0");
    check_field_offset(lv, s17044c126f1, 1, "S17044C126.s17044c126f1");
  }
}
static Arrange_To_Call_Me vS17044C126(Test_S17044C126, "S17044C126", 16);

#else // __cplusplus

Class_Descriptor cd_S17044C126 = {  "S17044C126", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C125  {
  ::S17044C126 s17044c125f0;
  ::S17044C126 s17044c125f1;
  ::S17044C126 s17044c125f2;
  ::S17044C126 s17044c125f3;
  void  mf17044c125(); // _ZN10S17044C12511mf17044c125Ev
};
//SIG(-1 S17044C125) C1{ m FC2{ m Fc[16]} FC2 FC2 FC2}


void  S17044C125 ::mf17044c125(){}

static void Test_S17044C125()
{
  {
    init_simple_test("S17044C125");
    S17044C125 lv;
    check2(sizeof(lv), 64, "sizeof(S17044C125)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C125)");
    check_field_offset(lv, s17044c125f0, 0, "S17044C125.s17044c125f0");
    check_field_offset(lv, s17044c125f1, 16, "S17044C125.s17044c125f1");
    check_field_offset(lv, s17044c125f2, 32, "S17044C125.s17044c125f2");
    check_field_offset(lv, s17044c125f3, 48, "S17044C125.s17044c125f3");
  }
}
static Arrange_To_Call_Me vS17044C125(Test_S17044C125, "S17044C125", 64);

#else // __cplusplus

Class_Descriptor cd_S17044C125 = {  "S17044C125", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  64, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C124  : S17044C125 {
};
//SIG(-1 S17044C124) C1{ BC2{ m FC3{ m Fc[16]} FC3 FC3 FC3}}



static void Test_S17044C124()
{
  extern Class_Descriptor cd_S17044C124;
  void *lvp;
  {
    char buf[64];
    init_test(&cd_S17044C124, buf);
    S17044C124 &lv = *(new (buf) S17044C124());
    lvp = (void*)&lv;
    check2(sizeof(lv), 64, "sizeof(S17044C124)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C124)");
    check_base_class_offset(lv, (S17044C125*), 0, "S17044C124");
    test_class_info(&lv, &cd_S17044C124);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C124(Test_S17044C124, "S17044C124", 64);

#else // __cplusplus

extern Class_Descriptor cd_S17044C125;
static Base_Class bases_S17044C124[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C125,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C124 = {  "S17044C124", // class name
  bases_S17044C124, 1,
  0, // no vftv
  0, //no vtt
  64, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C128  {
  int s17044c128f0;
  void *s17044c128f1;
  int s17044c128f2[17];
  void  mf17044c128(); // _ZN10S17044C12811mf17044c128Ev
};
//SIG(-1 S17044C128) C1{ m Fi Fp Fi[17]}


void  S17044C128 ::mf17044c128(){}

static void Test_S17044C128()
{
  {
    init_simple_test("S17044C128");
    S17044C128 lv;
    check2(sizeof(lv), ABISELECT(88,76), "sizeof(S17044C128)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C128)");
    check_field_offset(lv, s17044c128f0, 0, "S17044C128.s17044c128f0");
    check_field_offset(lv, s17044c128f1, ABISELECT(8,4), "S17044C128.s17044c128f1");
    check_field_offset(lv, s17044c128f2, ABISELECT(16,8), "S17044C128.s17044c128f2");
  }
}
static Arrange_To_Call_Me vS17044C128(Test_S17044C128, "S17044C128", ABISELECT(88,76));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C127  {
  ::S17044C128 s17044c127f0;
  void  mf17044c127(); // _ZN10S17044C12711mf17044c127Ev
};
//SIG(-1 S17044C127) C1{ m FC2{ m Fi Fp Fi[17]}}


void  S17044C127 ::mf17044c127(){}

static void Test_S17044C127()
{
  {
    init_simple_test("S17044C127");
    S17044C127 lv;
    check2(sizeof(lv), ABISELECT(88,76), "sizeof(S17044C127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C127)");
    check_field_offset(lv, s17044c127f0, 0, "S17044C127.s17044c127f0");
  }
}
static Arrange_To_Call_Me vS17044C127(Test_S17044C127, "S17044C127", ABISELECT(88,76));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C131  : S17044C7_nt {
  ::S17044C115 s17044c131f0;
};
//SIG(-1 S17044C131) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C131()
{
  extern Class_Descriptor cd_S17044C131;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C131, buf);
    S17044C131 &lv = *(new (buf) S17044C131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C131)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C131)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C131");
    check_field_offset(lv, s17044c131f0, 0, "S17044C131.s17044c131f0");
    test_class_info(&lv, &cd_S17044C131);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C131(Test_S17044C131, "S17044C131", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C131[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C131 = {  "S17044C131", // class name
  bases_S17044C131, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C130  : S17044C131 {
  void *s17044c130f0;
  void *s17044c130f1;
  void *s17044c130f2;
};
//SIG(-1 S17044C130) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S17044C130()
{
  extern Class_Descriptor cd_S17044C130;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S17044C130, buf);
    S17044C130 &lv = *(new (buf) S17044C130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17044C130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C130)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C131*), 0, "S17044C130");
    check_base_class_offset(lv, (S17044C131*), 0, "S17044C130");
    check_field_offset(lv, s17044c130f0, ABISELECT(8,4), "S17044C130.s17044c130f0");
    check_field_offset(lv, s17044c130f1, ABISELECT(16,8), "S17044C130.s17044c130f1");
    check_field_offset(lv, s17044c130f2, ABISELECT(24,12), "S17044C130.s17044c130f2");
    test_class_info(&lv, &cd_S17044C130);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C130(Test_S17044C130, "S17044C130", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C131;
static Base_Class bases_S17044C130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C131,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C130 = {  "S17044C130", // class name
  bases_S17044C130, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C139  {
};
//SIG(-1 S17044C139) C1{}



static void Test_S17044C139()
{
  {
    init_simple_test("S17044C139");
    S17044C139 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C139)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C139)");
  }
}
static Arrange_To_Call_Me vS17044C139(Test_S17044C139, "S17044C139", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C139 = {  "S17044C139", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C138  : S17044C139 {
};
//SIG(-1 S17044C138) C1{ BC2{}}



static void Test_S17044C138()
{
  extern Class_Descriptor cd_S17044C138;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C138, buf);
    S17044C138 &lv = *(new (buf) S17044C138());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C138)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C138)");
    check_base_class_offset(lv, (S17044C139*), 0, "S17044C138");
    test_class_info(&lv, &cd_S17044C138);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C138(Test_S17044C138, "S17044C138", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C139;
static Base_Class bases_S17044C138[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C139,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C138 = {  "S17044C138", // class name
  bases_S17044C138, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C137  : S17044C7_nt {
  ::S17044C138 s17044c137f0;
};
//SIG(-1 S17044C137) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C137()
{
  extern Class_Descriptor cd_S17044C137;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C137, buf);
    S17044C137 &lv = *(new (buf) S17044C137());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C137)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C137)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C137");
    check_field_offset(lv, s17044c137f0, 0, "S17044C137.s17044c137f0");
    test_class_info(&lv, &cd_S17044C137);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C137(Test_S17044C137, "S17044C137", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C137[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C137 = {  "S17044C137", // class name
  bases_S17044C137, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C136  : S17044C137 {
  ::S17044C138 s17044c136f0;
};
//SIG(-1 S17044C136) C1{ BC2{ BC3{} FC4{ BC5{}}} FC4}



static void Test_S17044C136()
{
  extern Class_Descriptor cd_S17044C136;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S17044C136, buf);
    S17044C136 &lv = *(new (buf) S17044C136());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S17044C136)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C136)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C137*), 0, "S17044C136");
    check_base_class_offset(lv, (S17044C137*), 0, "S17044C136");
    check_field_offset(lv, s17044c136f0, 1, "S17044C136.s17044c136f0");
    test_class_info(&lv, &cd_S17044C136);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C136(Test_S17044C136, "S17044C136", 2);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C137;
static Base_Class bases_S17044C136[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C137,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C136 = {  "S17044C136", // class name
  bases_S17044C136, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C143  {
};
//SIG(-1 S17044C143) C1{}



static void Test_S17044C143()
{
  {
    init_simple_test("S17044C143");
    S17044C143 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C143)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C143)");
  }
}
static Arrange_To_Call_Me vS17044C143(Test_S17044C143, "S17044C143", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C143 = {  "S17044C143", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C142  : S17044C143 {
};
//SIG(-1 S17044C142) C1{ BC2{}}



static void Test_S17044C142()
{
  extern Class_Descriptor cd_S17044C142;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C142, buf);
    S17044C142 &lv = *(new (buf) S17044C142());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C142)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C142)");
    check_base_class_offset(lv, (S17044C143*), 0, "S17044C142");
    test_class_info(&lv, &cd_S17044C142);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C142(Test_S17044C142, "S17044C142", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C143;
static Base_Class bases_S17044C142[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C143,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C142 = {  "S17044C142", // class name
  bases_S17044C142, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C135  : S17044C136 {
  ::S17044C142 s17044c135f0;
};
//SIG(-1 S17044C135) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC5} FC7{ BC8{}}}



static void Test_S17044C135()
{
  extern Class_Descriptor cd_S17044C135;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S17044C135, buf);
    S17044C135 &lv = *(new (buf) S17044C135());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S17044C135)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C135)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C137*)(S17044C136*), 0, "S17044C135");
    check_base_class_offset(lv, (S17044C137*)(S17044C136*), 0, "S17044C135");
    check_base_class_offset(lv, (S17044C136*), 0, "S17044C135");
    check_field_offset(lv, s17044c135f0, 2, "S17044C135.s17044c135f0");
    test_class_info(&lv, &cd_S17044C135);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C135(Test_S17044C135, "S17044C135", 3);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C137;
extern Class_Descriptor cd_S17044C136;
static Base_Class bases_S17044C135[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C137,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C136,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C135 = {  "S17044C135", // class name
  bases_S17044C135, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C134  : S17044C135 {
  void *s17044c134f0;
  void *s17044c134f1;
  int s17044c134f2;
};
//SIG(-1 S17044C134) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC6} FC8{ BC9{}}} Fp[2] Fi}



static void Test_S17044C134()
{
  extern Class_Descriptor cd_S17044C134;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S17044C134, buf);
    S17044C134 &lv = *(new (buf) S17044C134());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17044C134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C134)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C137*)(S17044C136*)(S17044C135*), 0, "S17044C134");
    check_base_class_offset(lv, (S17044C137*)(S17044C136*)(S17044C135*), 0, "S17044C134");
    check_base_class_offset(lv, (S17044C136*)(S17044C135*), 0, "S17044C134");
    check_base_class_offset(lv, (S17044C135*), 0, "S17044C134");
    check_field_offset(lv, s17044c134f0, ABISELECT(8,4), "S17044C134.s17044c134f0");
    check_field_offset(lv, s17044c134f1, ABISELECT(16,8), "S17044C134.s17044c134f1");
    check_field_offset(lv, s17044c134f2, ABISELECT(24,12), "S17044C134.s17044c134f2");
    test_class_info(&lv, &cd_S17044C134);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C134(Test_S17044C134, "S17044C134", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C137;
extern Class_Descriptor cd_S17044C136;
extern Class_Descriptor cd_S17044C135;
static Base_Class bases_S17044C134[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C137,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C136,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C135,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C134 = {  "S17044C134", // class name
  bases_S17044C134, 4,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C129  {
  ::S17044C130 s17044c129f0;
  ::S17044C134 s17044c129f1;
  int s17044c129f2;
  int s17044c129f3;
  void  mf17044c129(); // _ZN10S17044C12911mf17044c129Ev
};
//SIG(-1 S17044C129) C1{ m FC2{ BC3{ BC4{} FC5{ BC6{}}} Fp[3]} FC7{ BC8{ BC9{ BC10{ BC4 FC11{ BC12{}}} FC11} FC13{ BC14{}}} Fp[2] Fi} Fi[2]}


void  S17044C129 ::mf17044c129(){}

static void Test_S17044C129()
{
  {
    init_simple_test("S17044C129");
    S17044C129 lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S17044C129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C129)");
    check_field_offset(lv, s17044c129f0, 0, "S17044C129.s17044c129f0");
    check_field_offset(lv, s17044c129f1, ABISELECT(32,16), "S17044C129.s17044c129f1");
    check_field_offset(lv, s17044c129f2, ABISELECT(64,32), "S17044C129.s17044c129f2");
    check_field_offset(lv, s17044c129f3, ABISELECT(68,36), "S17044C129.s17044c129f3");
  }
}
static Arrange_To_Call_Me vS17044C129(Test_S17044C129, "S17044C129", ABISELECT(72,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C112  : S17044C4 , S17044C48 {
  int s17044c112f0;
  int s17044c112f1;
  ::S17044C52_nt s17044c112f2;
  ::S17044C113 s17044c112f3;
  ::S17044C73 s17044c112f4;
  ::S17044C113 s17044c112f5;
  int s17044c112f6;
  int s17044c112f7;
  char s17044c112f8;
  char s17044c112f9;
  char s17044c112f10;
  int s17044c112f11;
  int s17044c112f12;
  int s17044c112f13;
  int s17044c112f14;
  int s17044c112f15;
  ::S17044C73 s17044c112f16;
  ::S17044C73 s17044c112f17;
  ::S17044C73 s17044c112f18;
  ::S17044C73 s17044c112f19;
  ::S17044C121 s17044c112f20;
  ::S17044C121 s17044c112f21;
  ::S17044C121 s17044c112f22;
  ::S17044C121 s17044c112f23;
  ::S17044C123_nt s17044c112f24;
  char s17044c112f25;
  ::S17044C124 s17044c112f26;
  char s17044c112f27;
  int s17044c112f28;
  int s17044c112f29;
  char s17044c112f30;
  char s17044c112f31;
  char s17044c112f32;
  char s17044c112f33;
  ::S17044C127 s17044c112f34;
  ::S17044C127 s17044c112f35;
  ::S17044C127 s17044c112f36;
  ::S17044C127 s17044c112f37;
  ::S17044C129 s17044c112f38;
  ::S17044C130 s17044c112f39;
  int s17044c112f40;
  ::S17044C73 s17044c112f41;
  char s17044c112f42;
  char s17044c112f43;
  ::S17044C123_nt s17044c112f44;
  char s17044c112f45;
  char s17044c112f46;
  char s17044c112f47;
  virtual  ~S17044C112(); // _ZN10S17044C112D1Ev
  virtual void  v139(); // _ZN10S17044C1124v139Ev
  virtual void  v140(); // _ZN10S17044C1124v140Ev
  virtual void  v141(); // _ZN10S17044C1124v141Ev
  virtual void  v142(); // _ZN10S17044C1124v142Ev
  virtual void  v143(); // _ZN10S17044C1124v143Ev
  virtual void  v144(); // _ZN10S17044C1124v144Ev
  S17044C112(); // tgen
};
//SIG(-1 S17044C112) C1{ BC2{ vd v7 v8 v9 v10 v11} BC3{ vd v12 v13 v14 Fp} vd v1 v2 v3 v4 v5 v6 Fi[2] FC4{ m Fi[2]} FC5{ BC6{ BC7{} FC8{ BC9{}}} Fp[3]} FC10{ BC11{ BC12{ BC7} FC13{ BC14{}}} FU15{ Fc[16] Fp} Fi Fi} FC5 Fi Fi Fc Fc Fc Fi Fi Fi Fi Fi FC10 FC10 FC10 FC10 FC16{ BC17{ m Fp}} FC16 FC16 FC16 FC18{ m FL} Fc FC19{ BC20{ m FC21{ m Fc Fc[15]} FC21 FC21 FC21}} Fc Fi Fi Fc Fc Fc Fc FC22{ m FC23{ m Fi Fp Fi[17]}} FC22 FC22 FC22 FC24{ m FC25{ BC26{ BC7 FC8} Fp Fp Fp} FC27{ BC28{ BC29{ BC30{ BC7 FC31{ BC32{}}} FC31} FC33{ BC34{}}} Fp Fp Fi} Fi Fi} FC25 Fi FC10 Fc Fc FC18 Fc Fc Fc}


 S17044C112 ::~S17044C112(){ note_dtor("S17044C112", this);}
void  S17044C112 ::v139(){vfunc_called(this, "_ZN10S17044C1124v139Ev");}
void  S17044C112 ::v140(){vfunc_called(this, "_ZN10S17044C1124v140Ev");}
void  S17044C112 ::v141(){vfunc_called(this, "_ZN10S17044C1124v141Ev");}
void  S17044C112 ::v142(){vfunc_called(this, "_ZN10S17044C1124v142Ev");}
void  S17044C112 ::v143(){vfunc_called(this, "_ZN10S17044C1124v143Ev");}
void  S17044C112 ::v144(){vfunc_called(this, "_ZN10S17044C1124v144Ev");}
S17044C112 ::S17044C112(){ note_ctor("S17044C112", this);} // tgen

static void Test_S17044C112()
{
  extern Class_Descriptor cd_S17044C112;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(118,187)];
    init_test(&cd_S17044C112, buf);
    S17044C112 *dp, &lv = *(dp=new (buf) S17044C112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(936,744), "sizeof(S17044C112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C112)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C112");
    check_base_class_offset(lv, (S17044C48*), ABISELECT(8,4), "S17044C112");
    check_field_offset(lv, s17044c112f0, ABISELECT(24,12), "S17044C112.s17044c112f0");
    check_field_offset(lv, s17044c112f1, ABISELECT(28,16), "S17044C112.s17044c112f1");
    check_field_offset(lv, s17044c112f2, ABISELECT(32,20), "S17044C112.s17044c112f2");
    check_field_offset(lv, s17044c112f3, ABISELECT(40,28), "S17044C112.s17044c112f3");
    check_field_offset(lv, s17044c112f4, ABISELECT(72,44), "S17044C112.s17044c112f4");
    check_field_offset(lv, s17044c112f5, ABISELECT(104,72), "S17044C112.s17044c112f5");
    check_field_offset(lv, s17044c112f6, ABISELECT(136,88), "S17044C112.s17044c112f6");
    check_field_offset(lv, s17044c112f7, ABISELECT(140,92), "S17044C112.s17044c112f7");
    check_field_offset(lv, s17044c112f8, ABISELECT(144,96), "S17044C112.s17044c112f8");
    check_field_offset(lv, s17044c112f9, ABISELECT(145,97), "S17044C112.s17044c112f9");
    check_field_offset(lv, s17044c112f10, ABISELECT(146,98), "S17044C112.s17044c112f10");
    check_field_offset(lv, s17044c112f11, ABISELECT(148,100), "S17044C112.s17044c112f11");
    check_field_offset(lv, s17044c112f12, ABISELECT(152,104), "S17044C112.s17044c112f12");
    check_field_offset(lv, s17044c112f13, ABISELECT(156,108), "S17044C112.s17044c112f13");
    check_field_offset(lv, s17044c112f14, ABISELECT(160,112), "S17044C112.s17044c112f14");
    check_field_offset(lv, s17044c112f15, ABISELECT(164,116), "S17044C112.s17044c112f15");
    check_field_offset(lv, s17044c112f16, ABISELECT(168,120), "S17044C112.s17044c112f16");
    check_field_offset(lv, s17044c112f17, ABISELECT(200,148), "S17044C112.s17044c112f17");
    check_field_offset(lv, s17044c112f18, ABISELECT(232,176), "S17044C112.s17044c112f18");
    check_field_offset(lv, s17044c112f19, ABISELECT(264,204), "S17044C112.s17044c112f19");
    check_field_offset(lv, s17044c112f20, ABISELECT(296,232), "S17044C112.s17044c112f20");
    check_field_offset(lv, s17044c112f21, ABISELECT(304,236), "S17044C112.s17044c112f21");
    check_field_offset(lv, s17044c112f22, ABISELECT(312,240), "S17044C112.s17044c112f22");
    check_field_offset(lv, s17044c112f23, ABISELECT(320,244), "S17044C112.s17044c112f23");
    check_field_offset(lv, s17044c112f24, ABISELECT(328,248), "S17044C112.s17044c112f24");
    check_field_offset(lv, s17044c112f25, ABISELECT(336,256), "S17044C112.s17044c112f25");
    check_field_offset(lv, s17044c112f26, ABISELECT(337,257), "S17044C112.s17044c112f26");
    check_field_offset(lv, s17044c112f27, ABISELECT(401,321), "S17044C112.s17044c112f27");
    check_field_offset(lv, s17044c112f28, ABISELECT(404,324), "S17044C112.s17044c112f28");
    check_field_offset(lv, s17044c112f29, ABISELECT(408,328), "S17044C112.s17044c112f29");
    check_field_offset(lv, s17044c112f30, ABISELECT(412,332), "S17044C112.s17044c112f30");
    check_field_offset(lv, s17044c112f31, ABISELECT(413,333), "S17044C112.s17044c112f31");
    check_field_offset(lv, s17044c112f32, ABISELECT(414,334), "S17044C112.s17044c112f32");
    check_field_offset(lv, s17044c112f33, ABISELECT(415,335), "S17044C112.s17044c112f33");
    check_field_offset(lv, s17044c112f34, ABISELECT(416,336), "S17044C112.s17044c112f34");
    check_field_offset(lv, s17044c112f35, ABISELECT(504,412), "S17044C112.s17044c112f35");
    check_field_offset(lv, s17044c112f36, ABISELECT(592,488), "S17044C112.s17044c112f36");
    check_field_offset(lv, s17044c112f37, ABISELECT(680,564), "S17044C112.s17044c112f37");
    check_field_offset(lv, s17044c112f38, ABISELECT(768,640), "S17044C112.s17044c112f38");
    check_field_offset(lv, s17044c112f39, ABISELECT(840,680), "S17044C112.s17044c112f39");
    check_field_offset(lv, s17044c112f40, ABISELECT(872,696), "S17044C112.s17044c112f40");
    check_field_offset(lv, s17044c112f41, ABISELECT(880,700), "S17044C112.s17044c112f41");
    check_field_offset(lv, s17044c112f42, ABISELECT(912,728), "S17044C112.s17044c112f42");
    check_field_offset(lv, s17044c112f43, ABISELECT(913,729), "S17044C112.s17044c112f43");
    check_field_offset(lv, s17044c112f44, ABISELECT(920,732), "S17044C112.s17044c112f44");
    check_field_offset(lv, s17044c112f45, ABISELECT(928,740), "S17044C112.s17044c112f45");
    check_field_offset(lv, s17044c112f46, ABISELECT(929,741), "S17044C112.s17044c112f46");
    check_field_offset(lv, s17044c112f47, ABISELECT(930,742), "S17044C112.s17044c112f47");
    test_class_info(&lv, &cd_S17044C112);
    dp->~S17044C112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C112(Test_S17044C112, "S17044C112", ABISELECT(936,744));

#else // __cplusplus

extern void _ZN10S17044C112C1Ev();
extern void _ZN10S17044C112D1Ev();
Name_Map name_map_S17044C112[] = {
  NSPAIR(_ZN10S17044C112C1Ev),
  NSPAIR(_ZN10S17044C112D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C48;
extern VTBL_ENTRY _ZTI9S17044C48[];
extern  VTBL_ENTRY _ZTV9S17044C48[];
static Base_Class bases_S17044C112[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17044C48,    ABISELECT(8,4), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C112[];
extern void _ZN10S17044C112D1Ev();
extern void _ZN10S17044C112D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1124v139Ev();
extern void _ZN10S17044C1124v140Ev();
extern void _ZN10S17044C1124v141Ev();
extern void _ZN10S17044C1124v142Ev();
extern void _ZN10S17044C1124v143Ev();
extern void _ZN10S17044C1124v144Ev();
extern void ABISELECT(_ZThn8_N10S17044C112D1Ev,_ZThn4_N10S17044C112D1Ev)();
extern void ABISELECT(_ZThn8_N10S17044C112D0Ev,_ZThn4_N10S17044C112D0Ev)();
extern void _ZN9S17044C483v33Ev();
extern void _ZN9S17044C483v34Ev();
extern void _ZN9S17044C483v35Ev();
static  VTBL_ENTRY vtc_S17044C112[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C112[0]),
  (VTBL_ENTRY)&_ZN10S17044C112D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C112D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1124v139Ev,
  (VTBL_ENTRY)&_ZN10S17044C1124v140Ev,
  (VTBL_ENTRY)&_ZN10S17044C1124v141Ev,
  (VTBL_ENTRY)&_ZN10S17044C1124v142Ev,
  (VTBL_ENTRY)&_ZN10S17044C1124v143Ev,
  (VTBL_ENTRY)&_ZN10S17044C1124v144Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI10S17044C112[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S17044C112D1Ev,_ZThn4_N10S17044C112D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S17044C112D0Ev,_ZThn4_N10S17044C112D0Ev),
  (VTBL_ENTRY)&_ZN9S17044C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v35Ev,
};
extern VTBL_ENTRY _ZTI10S17044C112[];
extern  VTBL_ENTRY _ZTV10S17044C112[];
Class_Descriptor cd_S17044C112 = {  "S17044C112", // class name
  bases_S17044C112, 2,
  &(vtc_S17044C112[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(936,744), // object size
  NSPAIRA(_ZTI10S17044C112),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17044C112),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C148  : S17044C4 {
  int s17044c148f0;
  int s17044c148f1;
  ::S17044C52_nt s17044c148f2;
  ::S17044C5 s17044c148f3;
  int s17044c148f4;
  ::S17044C5 s17044c148f5;
  int s17044c148f6;
  char s17044c148f7;
  virtual void  v145(); // _ZN10S17044C1484v145Ev
  virtual void  v146(); // _ZN10S17044C1484v146Ev
  virtual void  v147(); // _ZN10S17044C1484v147Ev
  virtual void  v148(); // _ZN10S17044C1484v148Ev
  ~S17044C148(); // tgen
  S17044C148(); // tgen
};
//SIG(-1 S17044C148) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[2] FC3{ m Fi[2]} FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} Fi FC4 Fi Fc}


void  S17044C148 ::v145(){vfunc_called(this, "_ZN10S17044C1484v145Ev");}
void  S17044C148 ::v146(){vfunc_called(this, "_ZN10S17044C1484v146Ev");}
void  S17044C148 ::v147(){vfunc_called(this, "_ZN10S17044C1484v147Ev");}
void  S17044C148 ::v148(){vfunc_called(this, "_ZN10S17044C1484v148Ev");}
S17044C148 ::~S17044C148(){ note_dtor("S17044C148", this);} // tgen
S17044C148 ::S17044C148(){ note_ctor("S17044C148", this);} // tgen

static void Test_S17044C148()
{
  extern Class_Descriptor cd_S17044C148;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S17044C148, buf);
    S17044C148 *dp, &lv = *(dp=new (buf) S17044C148());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S17044C148)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C148)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C148");
    check_field_offset(lv, s17044c148f0, ABISELECT(8,4), "S17044C148.s17044c148f0");
    check_field_offset(lv, s17044c148f1, ABISELECT(12,8), "S17044C148.s17044c148f1");
    check_field_offset(lv, s17044c148f2, ABISELECT(16,12), "S17044C148.s17044c148f2");
    check_field_offset(lv, s17044c148f3, ABISELECT(24,20), "S17044C148.s17044c148f3");
    check_field_offset(lv, s17044c148f4, ABISELECT(56,36), "S17044C148.s17044c148f4");
    check_field_offset(lv, s17044c148f5, ABISELECT(64,40), "S17044C148.s17044c148f5");
    check_field_offset(lv, s17044c148f6, ABISELECT(96,56), "S17044C148.s17044c148f6");
    check_field_offset(lv, s17044c148f7, ABISELECT(100,60), "S17044C148.s17044c148f7");
    test_class_info(&lv, &cd_S17044C148);
    dp->~S17044C148();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C148(Test_S17044C148, "S17044C148", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN10S17044C148C1Ev();
extern void _ZN10S17044C148D1Ev();
Name_Map name_map_S17044C148[] = {
  NSPAIR(_ZN10S17044C148C1Ev),
  NSPAIR(_ZN10S17044C148D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C148[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C148[];
extern void _ZN10S17044C148D1Ev();
extern void _ZN10S17044C148D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1484v145Ev();
extern void _ZN10S17044C1484v146Ev();
extern void _ZN10S17044C1484v147Ev();
extern void _ZN10S17044C1484v148Ev();
static  VTBL_ENTRY vtc_S17044C148[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C148[0]),
  (VTBL_ENTRY)&_ZN10S17044C148D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C148D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1484v145Ev,
  (VTBL_ENTRY)&_ZN10S17044C1484v146Ev,
  (VTBL_ENTRY)&_ZN10S17044C1484v147Ev,
  (VTBL_ENTRY)&_ZN10S17044C1484v148Ev,
};
extern VTBL_ENTRY _ZTI10S17044C148[];
extern  VTBL_ENTRY _ZTV10S17044C148[];
Class_Descriptor cd_S17044C148 = {  "S17044C148", // class name
  bases_S17044C148, 1,
  &(vtc_S17044C148[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S17044C148),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C148),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C151  : S17044C7_nt {
  ::S17044C142 s17044c151f0;
};
//SIG(-1 S17044C151) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C151()
{
  extern Class_Descriptor cd_S17044C151;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C151, buf);
    S17044C151 &lv = *(new (buf) S17044C151());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C151)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C151)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C151");
    check_field_offset(lv, s17044c151f0, 0, "S17044C151.s17044c151f0");
    test_class_info(&lv, &cd_S17044C151);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C151(Test_S17044C151, "S17044C151", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C151[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C151 = {  "S17044C151", // class name
  bases_S17044C151, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C150  : S17044C151 {
  void *s17044c150f0;
  void *s17044c150f1;
  void *s17044c150f2;
};
//SIG(-1 S17044C150) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S17044C150()
{
  extern Class_Descriptor cd_S17044C150;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S17044C150, buf);
    S17044C150 &lv = *(new (buf) S17044C150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17044C150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C150)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C151*), 0, "S17044C150");
    check_base_class_offset(lv, (S17044C151*), 0, "S17044C150");
    check_field_offset(lv, s17044c150f0, ABISELECT(8,4), "S17044C150.s17044c150f0");
    check_field_offset(lv, s17044c150f1, ABISELECT(16,8), "S17044C150.s17044c150f1");
    check_field_offset(lv, s17044c150f2, ABISELECT(24,12), "S17044C150.s17044c150f2");
    test_class_info(&lv, &cd_S17044C150);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C150(Test_S17044C150, "S17044C150", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C151;
static Base_Class bases_S17044C150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C151,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C150 = {  "S17044C150", // class name
  bases_S17044C150, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C161  {
};
//SIG(-1 S17044C161) C1{}



static void Test_S17044C161()
{
  {
    init_simple_test("S17044C161");
    S17044C161 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C161)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C161)");
  }
}
static Arrange_To_Call_Me vS17044C161(Test_S17044C161, "S17044C161", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C161 = {  "S17044C161", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C160  : S17044C161 {
};
//SIG(-1 S17044C160) C1{ BC2{}}



static void Test_S17044C160()
{
  extern Class_Descriptor cd_S17044C160;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C160, buf);
    S17044C160 &lv = *(new (buf) S17044C160());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C160)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C160)");
    check_base_class_offset(lv, (S17044C161*), 0, "S17044C160");
    test_class_info(&lv, &cd_S17044C160);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C160(Test_S17044C160, "S17044C160", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C161;
static Base_Class bases_S17044C160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C161,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C160 = {  "S17044C160", // class name
  bases_S17044C160, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C159  : S17044C7_nt {
  ::S17044C160 s17044c159f0;
};
//SIG(-1 S17044C159) C1{ BC2{} FC3{ BC4{}}}



static void Test_S17044C159()
{
  extern Class_Descriptor cd_S17044C159;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C159, buf);
    S17044C159 &lv = *(new (buf) S17044C159());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C159)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C159)");
    check_base_class_offset(lv, (S17044C7_nt*), 0, "S17044C159");
    check_field_offset(lv, s17044c159f0, 0, "S17044C159.s17044c159f0");
    test_class_info(&lv, &cd_S17044C159);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C159(Test_S17044C159, "S17044C159", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
static Base_Class bases_S17044C159[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C159 = {  "S17044C159", // class name
  bases_S17044C159, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C158  : S17044C159 {
  void *s17044c158f0;
  void *s17044c158f1;
  void *s17044c158f2;
};
//SIG(-1 S17044C158) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S17044C158()
{
  extern Class_Descriptor cd_S17044C158;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S17044C158, buf);
    S17044C158 &lv = *(new (buf) S17044C158());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17044C158)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C158)");
    check_base_class_offset(lv, (S17044C7_nt*)(S17044C159*), 0, "S17044C158");
    check_base_class_offset(lv, (S17044C159*), 0, "S17044C158");
    check_field_offset(lv, s17044c158f0, ABISELECT(8,4), "S17044C158.s17044c158f0");
    check_field_offset(lv, s17044c158f1, ABISELECT(16,8), "S17044C158.s17044c158f1");
    check_field_offset(lv, s17044c158f2, ABISELECT(24,12), "S17044C158.s17044c158f2");
    test_class_info(&lv, &cd_S17044C158);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C158(Test_S17044C158, "S17044C158", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S17044C7_nt;
extern Class_Descriptor cd_S17044C159;
static Base_Class bases_S17044C158[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C159,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C158 = {  "S17044C158", // class name
  bases_S17044C158, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C149  : S17044C4 {
  int s17044c149f0;
  int s17044c149f1;
  ::S17044C52_nt s17044c149f2;
  ::S17044C5 s17044c149f3;
  int s17044c149f4;
  int s17044c149f5;
  int s17044c149f6;
  char s17044c149f7;
  int s17044c149f8;
  int s17044c149f9;
  ::S17044C150 s17044c149f10;
  ::S17044C150 s17044c149f11;
  ::S17044C158 s17044c149f12;
  ::S17044C5 s17044c149f13;
  ::S17044C5 s17044c149f14;
  ::S17044C5 s17044c149f15;
  ::S17044C5 s17044c149f16;
  virtual void  v149(); // _ZN10S17044C1494v149Ev
  virtual void  v150(); // _ZN10S17044C1494v150Ev
  virtual void  v151(); // _ZN10S17044C1494v151Ev
  virtual void  v152(); // _ZN10S17044C1494v152Ev
  ~S17044C149(); // tgen
  S17044C149(); // tgen
};
//SIG(-1 S17044C149) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[2] FC3{ m Fi[2]} FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} Fi[3] Fc Fi[2] FC9{ BC10{ BC6 FC11{ BC12{}}} Fp[3]} FC9 FC13{ BC14{ BC6 FC15{ BC16{}}} Fp[3]} FC4 FC4 FC4 FC4}


void  S17044C149 ::v149(){vfunc_called(this, "_ZN10S17044C1494v149Ev");}
void  S17044C149 ::v150(){vfunc_called(this, "_ZN10S17044C1494v150Ev");}
void  S17044C149 ::v151(){vfunc_called(this, "_ZN10S17044C1494v151Ev");}
void  S17044C149 ::v152(){vfunc_called(this, "_ZN10S17044C1494v152Ev");}
S17044C149 ::~S17044C149(){ note_dtor("S17044C149", this);} // tgen
S17044C149 ::S17044C149(){ note_ctor("S17044C149", this);} // tgen

static void Test_S17044C149()
{
  extern Class_Descriptor cd_S17044C149;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,44)];
    init_test(&cd_S17044C149, buf);
    S17044C149 *dp, &lv = *(dp=new (buf) S17044C149());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,172), "sizeof(S17044C149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C149)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C149");
    check_field_offset(lv, s17044c149f0, ABISELECT(8,4), "S17044C149.s17044c149f0");
    check_field_offset(lv, s17044c149f1, ABISELECT(12,8), "S17044C149.s17044c149f1");
    check_field_offset(lv, s17044c149f2, ABISELECT(16,12), "S17044C149.s17044c149f2");
    check_field_offset(lv, s17044c149f3, ABISELECT(24,20), "S17044C149.s17044c149f3");
    check_field_offset(lv, s17044c149f4, ABISELECT(56,36), "S17044C149.s17044c149f4");
    check_field_offset(lv, s17044c149f5, ABISELECT(60,40), "S17044C149.s17044c149f5");
    check_field_offset(lv, s17044c149f6, ABISELECT(64,44), "S17044C149.s17044c149f6");
    check_field_offset(lv, s17044c149f7, ABISELECT(68,48), "S17044C149.s17044c149f7");
    check_field_offset(lv, s17044c149f8, ABISELECT(72,52), "S17044C149.s17044c149f8");
    check_field_offset(lv, s17044c149f9, ABISELECT(76,56), "S17044C149.s17044c149f9");
    check_field_offset(lv, s17044c149f10, ABISELECT(80,60), "S17044C149.s17044c149f10");
    check_field_offset(lv, s17044c149f11, ABISELECT(112,76), "S17044C149.s17044c149f11");
    check_field_offset(lv, s17044c149f12, ABISELECT(144,92), "S17044C149.s17044c149f12");
    check_field_offset(lv, s17044c149f13, ABISELECT(176,108), "S17044C149.s17044c149f13");
    check_field_offset(lv, s17044c149f14, ABISELECT(208,124), "S17044C149.s17044c149f14");
    check_field_offset(lv, s17044c149f15, ABISELECT(240,140), "S17044C149.s17044c149f15");
    check_field_offset(lv, s17044c149f16, ABISELECT(272,156), "S17044C149.s17044c149f16");
    test_class_info(&lv, &cd_S17044C149);
    dp->~S17044C149();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C149(Test_S17044C149, "S17044C149", ABISELECT(304,172));

#else // __cplusplus

extern void _ZN10S17044C149C1Ev();
extern void _ZN10S17044C149D1Ev();
Name_Map name_map_S17044C149[] = {
  NSPAIR(_ZN10S17044C149C1Ev),
  NSPAIR(_ZN10S17044C149D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C149[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C149[];
extern void _ZN10S17044C149D1Ev();
extern void _ZN10S17044C149D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1494v149Ev();
extern void _ZN10S17044C1494v150Ev();
extern void _ZN10S17044C1494v151Ev();
extern void _ZN10S17044C1494v152Ev();
static  VTBL_ENTRY vtc_S17044C149[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C149[0]),
  (VTBL_ENTRY)&_ZN10S17044C149D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C149D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1494v149Ev,
  (VTBL_ENTRY)&_ZN10S17044C1494v150Ev,
  (VTBL_ENTRY)&_ZN10S17044C1494v151Ev,
  (VTBL_ENTRY)&_ZN10S17044C1494v152Ev,
};
extern VTBL_ENTRY _ZTI10S17044C149[];
extern  VTBL_ENTRY _ZTV10S17044C149[];
Class_Descriptor cd_S17044C149 = {  "S17044C149", // class name
  bases_S17044C149, 1,
  &(vtc_S17044C149[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,172), // object size
  NSPAIRA(_ZTI10S17044C149),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C149),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C162  : S17044C4 {
  int s17044c162f0;
  int s17044c162f1;
  ::S17044C52_nt s17044c162f2;
  char s17044c162f3;
  virtual void  v153(); // _ZN10S17044C1624v153Ev
  virtual void  v154(); // _ZN10S17044C1624v154Ev
  virtual void  v155(); // _ZN10S17044C1624v155Ev
  virtual void  v156(); // _ZN10S17044C1624v156Ev
  ~S17044C162(); // tgen
  S17044C162(); // tgen
};
//SIG(-1 S17044C162) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[2] FC3{ m Fi[2]} Fc}


void  S17044C162 ::v153(){vfunc_called(this, "_ZN10S17044C1624v153Ev");}
void  S17044C162 ::v154(){vfunc_called(this, "_ZN10S17044C1624v154Ev");}
void  S17044C162 ::v155(){vfunc_called(this, "_ZN10S17044C1624v155Ev");}
void  S17044C162 ::v156(){vfunc_called(this, "_ZN10S17044C1624v156Ev");}
S17044C162 ::~S17044C162(){ note_dtor("S17044C162", this);} // tgen
S17044C162 ::S17044C162(){ note_ctor("S17044C162", this);} // tgen

static void Test_S17044C162()
{
  extern Class_Descriptor cd_S17044C162;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S17044C162, buf);
    S17044C162 *dp, &lv = *(dp=new (buf) S17044C162());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S17044C162)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C162)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C162");
    check_field_offset(lv, s17044c162f0, ABISELECT(8,4), "S17044C162.s17044c162f0");
    check_field_offset(lv, s17044c162f1, ABISELECT(12,8), "S17044C162.s17044c162f1");
    check_field_offset(lv, s17044c162f2, ABISELECT(16,12), "S17044C162.s17044c162f2");
    check_field_offset(lv, s17044c162f3, ABISELECT(24,20), "S17044C162.s17044c162f3");
    test_class_info(&lv, &cd_S17044C162);
    dp->~S17044C162();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C162(Test_S17044C162, "S17044C162", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN10S17044C162C1Ev();
extern void _ZN10S17044C162D1Ev();
Name_Map name_map_S17044C162[] = {
  NSPAIR(_ZN10S17044C162C1Ev),
  NSPAIR(_ZN10S17044C162D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C162[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C162[];
extern void _ZN10S17044C162D1Ev();
extern void _ZN10S17044C162D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1624v153Ev();
extern void _ZN10S17044C1624v154Ev();
extern void _ZN10S17044C1624v155Ev();
extern void _ZN10S17044C1624v156Ev();
static  VTBL_ENTRY vtc_S17044C162[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C162[0]),
  (VTBL_ENTRY)&_ZN10S17044C162D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C162D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1624v153Ev,
  (VTBL_ENTRY)&_ZN10S17044C1624v154Ev,
  (VTBL_ENTRY)&_ZN10S17044C1624v155Ev,
  (VTBL_ENTRY)&_ZN10S17044C1624v156Ev,
};
extern VTBL_ENTRY _ZTI10S17044C162[];
extern  VTBL_ENTRY _ZTV10S17044C162[];
Class_Descriptor cd_S17044C162 = {  "S17044C162", // class name
  bases_S17044C162, 1,
  &(vtc_S17044C162[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI10S17044C162),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C162),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C163  : S17044C4 {
  int s17044c163f0;
  int s17044c163f1;
  ::S17044C52_nt s17044c163f2;
  virtual void  v157(); // _ZN10S17044C1634v157Ev
  virtual void  v158(); // _ZN10S17044C1634v158Ev
  virtual void  v159(); // _ZN10S17044C1634v159Ev
  virtual void  v160(); // _ZN10S17044C1634v160Ev
  ~S17044C163(); // tgen
  S17044C163(); // tgen
};
//SIG(-1 S17044C163) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[2] FC3{ m Fi[2]}}


void  S17044C163 ::v157(){vfunc_called(this, "_ZN10S17044C1634v157Ev");}
void  S17044C163 ::v158(){vfunc_called(this, "_ZN10S17044C1634v158Ev");}
void  S17044C163 ::v159(){vfunc_called(this, "_ZN10S17044C1634v159Ev");}
void  S17044C163 ::v160(){vfunc_called(this, "_ZN10S17044C1634v160Ev");}
S17044C163 ::~S17044C163(){ note_dtor("S17044C163", this);} // tgen
S17044C163 ::S17044C163(){ note_ctor("S17044C163", this);} // tgen

static void Test_S17044C163()
{
  extern Class_Descriptor cd_S17044C163;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_S17044C163, buf);
    S17044C163 *dp, &lv = *(dp=new (buf) S17044C163());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S17044C163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C163)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C163");
    check_field_offset(lv, s17044c163f0, ABISELECT(8,4), "S17044C163.s17044c163f0");
    check_field_offset(lv, s17044c163f1, ABISELECT(12,8), "S17044C163.s17044c163f1");
    check_field_offset(lv, s17044c163f2, ABISELECT(16,12), "S17044C163.s17044c163f2");
    test_class_info(&lv, &cd_S17044C163);
    dp->~S17044C163();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C163(Test_S17044C163, "S17044C163", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN10S17044C163C1Ev();
extern void _ZN10S17044C163D1Ev();
Name_Map name_map_S17044C163[] = {
  NSPAIR(_ZN10S17044C163C1Ev),
  NSPAIR(_ZN10S17044C163D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C163[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C163[];
extern void _ZN10S17044C163D1Ev();
extern void _ZN10S17044C163D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1634v157Ev();
extern void _ZN10S17044C1634v158Ev();
extern void _ZN10S17044C1634v159Ev();
extern void _ZN10S17044C1634v160Ev();
static  VTBL_ENTRY vtc_S17044C163[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C163[0]),
  (VTBL_ENTRY)&_ZN10S17044C163D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C163D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1634v157Ev,
  (VTBL_ENTRY)&_ZN10S17044C1634v158Ev,
  (VTBL_ENTRY)&_ZN10S17044C1634v159Ev,
  (VTBL_ENTRY)&_ZN10S17044C1634v160Ev,
};
extern VTBL_ENTRY _ZTI10S17044C163[];
extern  VTBL_ENTRY _ZTV10S17044C163[];
Class_Descriptor cd_S17044C163 = {  "S17044C163", // class name
  bases_S17044C163, 1,
  &(vtc_S17044C163[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI10S17044C163),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C163),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C165  : S17044C4 {
  int s17044c165f0;
  int s17044c165f1;
  int s17044c165f2;
  int s17044c165f3;
  char s17044c165f4;
  char s17044c165f5;
  int s17044c165f6;
  virtual void  v165(); // _ZN10S17044C1654v165Ev
  virtual void  v166(); // _ZN10S17044C1654v166Ev
  virtual void  v167(); // _ZN10S17044C1654v167Ev
  virtual void  v168(); // _ZN10S17044C1654v168Ev
  ~S17044C165(); // tgen
  S17044C165(); // tgen
};
//SIG(-1 S17044C165) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[4] Fc[2] Fi}


void  S17044C165 ::v165(){vfunc_called(this, "_ZN10S17044C1654v165Ev");}
void  S17044C165 ::v166(){vfunc_called(this, "_ZN10S17044C1654v166Ev");}
void  S17044C165 ::v167(){vfunc_called(this, "_ZN10S17044C1654v167Ev");}
void  S17044C165 ::v168(){vfunc_called(this, "_ZN10S17044C1654v168Ev");}
S17044C165 ::~S17044C165(){ note_dtor("S17044C165", this);} // tgen
S17044C165 ::S17044C165(){ note_ctor("S17044C165", this);} // tgen

static void Test_S17044C165()
{
  extern Class_Descriptor cd_S17044C165;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,8)];
    init_test(&cd_S17044C165, buf);
    S17044C165 *dp, &lv = *(dp=new (buf) S17044C165());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(S17044C165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C165)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C165");
    check_field_offset(lv, s17044c165f0, ABISELECT(8,4), "S17044C165.s17044c165f0");
    check_field_offset(lv, s17044c165f1, ABISELECT(12,8), "S17044C165.s17044c165f1");
    check_field_offset(lv, s17044c165f2, ABISELECT(16,12), "S17044C165.s17044c165f2");
    check_field_offset(lv, s17044c165f3, ABISELECT(20,16), "S17044C165.s17044c165f3");
    check_field_offset(lv, s17044c165f4, ABISELECT(24,20), "S17044C165.s17044c165f4");
    check_field_offset(lv, s17044c165f5, ABISELECT(25,21), "S17044C165.s17044c165f5");
    check_field_offset(lv, s17044c165f6, ABISELECT(28,24), "S17044C165.s17044c165f6");
    test_class_info(&lv, &cd_S17044C165);
    dp->~S17044C165();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C165(Test_S17044C165, "S17044C165", ABISELECT(32,28));

#else // __cplusplus

extern void _ZN10S17044C165C1Ev();
extern void _ZN10S17044C165D1Ev();
Name_Map name_map_S17044C165[] = {
  NSPAIR(_ZN10S17044C165C1Ev),
  NSPAIR(_ZN10S17044C165D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C165[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C165[];
extern void _ZN10S17044C165D1Ev();
extern void _ZN10S17044C165D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1654v165Ev();
extern void _ZN10S17044C1654v166Ev();
extern void _ZN10S17044C1654v167Ev();
extern void _ZN10S17044C1654v168Ev();
static  VTBL_ENTRY vtc_S17044C165[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C165[0]),
  (VTBL_ENTRY)&_ZN10S17044C165D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C165D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1654v165Ev,
  (VTBL_ENTRY)&_ZN10S17044C1654v166Ev,
  (VTBL_ENTRY)&_ZN10S17044C1654v167Ev,
  (VTBL_ENTRY)&_ZN10S17044C1654v168Ev,
};
extern VTBL_ENTRY _ZTI10S17044C165[];
extern  VTBL_ENTRY _ZTV10S17044C165[];
Class_Descriptor cd_S17044C165 = {  "S17044C165", // class name
  bases_S17044C165, 1,
  &(vtc_S17044C165[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,28), // object size
  NSPAIRA(_ZTI10S17044C165),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C165),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C166  : S17044C4 {
  int s17044c166f0;
  int s17044c166f1;
  char s17044c166f2;
  char s17044c166f3;
  int s17044c166f4;
  virtual void  v169(); // _ZN10S17044C1664v169Ev
  virtual void  v170(); // _ZN10S17044C1664v170Ev
  virtual void  v171(); // _ZN10S17044C1664v171Ev
  virtual void  v172(); // _ZN10S17044C1664v172Ev
  ~S17044C166(); // tgen
  S17044C166(); // tgen
};
//SIG(-1 S17044C166) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[2] Fc[2] Fi}


void  S17044C166 ::v169(){vfunc_called(this, "_ZN10S17044C1664v169Ev");}
void  S17044C166 ::v170(){vfunc_called(this, "_ZN10S17044C1664v170Ev");}
void  S17044C166 ::v171(){vfunc_called(this, "_ZN10S17044C1664v171Ev");}
void  S17044C166 ::v172(){vfunc_called(this, "_ZN10S17044C1664v172Ev");}
S17044C166 ::~S17044C166(){ note_dtor("S17044C166", this);} // tgen
S17044C166 ::S17044C166(){ note_ctor("S17044C166", this);} // tgen

static void Test_S17044C166()
{
  extern Class_Descriptor cd_S17044C166;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_S17044C166, buf);
    S17044C166 *dp, &lv = *(dp=new (buf) S17044C166());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S17044C166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C166)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C166");
    check_field_offset(lv, s17044c166f0, ABISELECT(8,4), "S17044C166.s17044c166f0");
    check_field_offset(lv, s17044c166f1, ABISELECT(12,8), "S17044C166.s17044c166f1");
    check_field_offset(lv, s17044c166f2, ABISELECT(16,12), "S17044C166.s17044c166f2");
    check_field_offset(lv, s17044c166f3, ABISELECT(17,13), "S17044C166.s17044c166f3");
    check_field_offset(lv, s17044c166f4, ABISELECT(20,16), "S17044C166.s17044c166f4");
    test_class_info(&lv, &cd_S17044C166);
    dp->~S17044C166();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C166(Test_S17044C166, "S17044C166", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN10S17044C166C1Ev();
extern void _ZN10S17044C166D1Ev();
Name_Map name_map_S17044C166[] = {
  NSPAIR(_ZN10S17044C166C1Ev),
  NSPAIR(_ZN10S17044C166D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C166[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C166[];
extern void _ZN10S17044C166D1Ev();
extern void _ZN10S17044C166D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1664v169Ev();
extern void _ZN10S17044C1664v170Ev();
extern void _ZN10S17044C1664v171Ev();
extern void _ZN10S17044C1664v172Ev();
static  VTBL_ENTRY vtc_S17044C166[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C166[0]),
  (VTBL_ENTRY)&_ZN10S17044C166D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C166D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1664v169Ev,
  (VTBL_ENTRY)&_ZN10S17044C1664v170Ev,
  (VTBL_ENTRY)&_ZN10S17044C1664v171Ev,
  (VTBL_ENTRY)&_ZN10S17044C1664v172Ev,
};
extern VTBL_ENTRY _ZTI10S17044C166[];
extern  VTBL_ENTRY _ZTV10S17044C166[];
Class_Descriptor cd_S17044C166 = {  "S17044C166", // class name
  bases_S17044C166, 1,
  &(vtc_S17044C166[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI10S17044C166),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C166),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C172  {
};
//SIG(-1 S17044C172) C1{}



static void Test_S17044C172()
{
  {
    init_simple_test("S17044C172");
    S17044C172 lv;
    check2(sizeof(lv), 1, "sizeof(S17044C172)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C172)");
  }
}
static Arrange_To_Call_Me vS17044C172(Test_S17044C172, "S17044C172", 1);

#else // __cplusplus

Class_Descriptor cd_S17044C172 = {  "S17044C172", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C171  : S17044C172 {
};
//SIG(-1 S17044C171) C1{ BC2{}}



static void Test_S17044C171()
{
  extern Class_Descriptor cd_S17044C171;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C171, buf);
    S17044C171 &lv = *(new (buf) S17044C171());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C171)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C171)");
    check_base_class_offset(lv, (S17044C172*), 0, "S17044C171");
    test_class_info(&lv, &cd_S17044C171);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C171(Test_S17044C171, "S17044C171", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C172;
static Base_Class bases_S17044C171[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C172,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C171 = {  "S17044C171", // class name
  bases_S17044C171, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C170  : S17044C171 {
};
//SIG(-1 S17044C170) C1{ BC2{ BC3{}}}



static void Test_S17044C170()
{
  extern Class_Descriptor cd_S17044C170;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S17044C170, buf);
    S17044C170 &lv = *(new (buf) S17044C170());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S17044C170)");
    check2(__alignof__(lv), 1, "__alignof__(S17044C170)");
    check_base_class_offset(lv, (S17044C172*)(S17044C171*), 0, "S17044C170");
    check_base_class_offset(lv, (S17044C171*), 0, "S17044C170");
    test_class_info(&lv, &cd_S17044C170);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C170(Test_S17044C170, "S17044C170", 1);

#else // __cplusplus

extern Class_Descriptor cd_S17044C172;
extern Class_Descriptor cd_S17044C171;
static Base_Class bases_S17044C170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C172,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C171,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C170 = {  "S17044C170", // class name
  bases_S17044C170, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C169  : S17044C170 {
  void *s17044c169f0;
};
//SIG(-1 S17044C169) C1{ BC2{ BC3{ BC4{}}} Fp}



static void Test_S17044C169()
{
  extern Class_Descriptor cd_S17044C169;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S17044C169, buf);
    S17044C169 &lv = *(new (buf) S17044C169());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17044C169)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C169)");
    check_base_class_offset(lv, (S17044C172*)(S17044C171*)(S17044C170*), 0, "S17044C169");
    check_base_class_offset(lv, (S17044C171*)(S17044C170*), 0, "S17044C169");
    check_base_class_offset(lv, (S17044C170*), 0, "S17044C169");
    check_field_offset(lv, s17044c169f0, 0, "S17044C169.s17044c169f0");
    test_class_info(&lv, &cd_S17044C169);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C169(Test_S17044C169, "S17044C169", ABISELECT(8,4));

#else // __cplusplus

extern Class_Descriptor cd_S17044C172;
extern Class_Descriptor cd_S17044C171;
extern Class_Descriptor cd_S17044C170;
static Base_Class bases_S17044C169[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C172,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C171,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C169 = {  "S17044C169", // class name
  bases_S17044C169, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C168  : S17044C169 {
};
//SIG(-1 S17044C168) C1{ BC2{ BC3{ BC4{ BC5{}}} Fp}}



static void Test_S17044C168()
{
  extern Class_Descriptor cd_S17044C168;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S17044C168, buf);
    S17044C168 &lv = *(new (buf) S17044C168());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17044C168)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C168)");
    check_base_class_offset(lv, (S17044C172*)(S17044C171*)(S17044C170*)(S17044C169*), 0, "S17044C168");
    check_base_class_offset(lv, (S17044C171*)(S17044C170*)(S17044C169*), 0, "S17044C168");
    check_base_class_offset(lv, (S17044C170*)(S17044C169*), 0, "S17044C168");
    check_base_class_offset(lv, (S17044C169*), 0, "S17044C168");
    test_class_info(&lv, &cd_S17044C168);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C168(Test_S17044C168, "S17044C168", ABISELECT(8,4));

#else // __cplusplus

extern Class_Descriptor cd_S17044C172;
extern Class_Descriptor cd_S17044C171;
extern Class_Descriptor cd_S17044C170;
extern Class_Descriptor cd_S17044C169;
static Base_Class bases_S17044C168[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C172,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C171,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S17044C170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S17044C169,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S17044C168 = {  "S17044C168", // class name
  bases_S17044C168, 4,
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C167  : S17044C4 {
  int s17044c167f0;
  char s17044c167f1;
  char s17044c167f2;
  int s17044c167f3;
  ::S17044C113 s17044c167f4;
  ::S17044C168 s17044c167f5;
  virtual void  v173(); // _ZN10S17044C1674v173Ev
  virtual void  v174(); // _ZN10S17044C1674v174Ev
  virtual void  v175(); // _ZN10S17044C1674v175Ev
  virtual void  v176(); // _ZN10S17044C1674v176Ev
  ~S17044C167(); // tgen
  S17044C167(); // tgen
};
//SIG(-1 S17044C167) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi Fc[2] Fi FC3{ BC4{ BC5{} FC6{ BC7{}}} Fp[3]} FC8{ BC9{ BC10{ BC11{ BC12{}}} Fp}}}


void  S17044C167 ::v173(){vfunc_called(this, "_ZN10S17044C1674v173Ev");}
void  S17044C167 ::v174(){vfunc_called(this, "_ZN10S17044C1674v174Ev");}
void  S17044C167 ::v175(){vfunc_called(this, "_ZN10S17044C1674v175Ev");}
void  S17044C167 ::v176(){vfunc_called(this, "_ZN10S17044C1674v176Ev");}
S17044C167 ::~S17044C167(){ note_dtor("S17044C167", this);} // tgen
S17044C167 ::S17044C167(){ note_ctor("S17044C167", this);} // tgen

static void Test_S17044C167()
{
  extern Class_Descriptor cd_S17044C167;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S17044C167, buf);
    S17044C167 *dp, &lv = *(dp=new (buf) S17044C167());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S17044C167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C167)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C167");
    check_field_offset(lv, s17044c167f0, ABISELECT(8,4), "S17044C167.s17044c167f0");
    check_field_offset(lv, s17044c167f1, ABISELECT(12,8), "S17044C167.s17044c167f1");
    check_field_offset(lv, s17044c167f2, ABISELECT(13,9), "S17044C167.s17044c167f2");
    check_field_offset(lv, s17044c167f3, ABISELECT(16,12), "S17044C167.s17044c167f3");
    check_field_offset(lv, s17044c167f4, ABISELECT(24,16), "S17044C167.s17044c167f4");
    check_field_offset(lv, s17044c167f5, ABISELECT(56,32), "S17044C167.s17044c167f5");
    test_class_info(&lv, &cd_S17044C167);
    dp->~S17044C167();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C167(Test_S17044C167, "S17044C167", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN10S17044C167C1Ev();
extern void _ZN10S17044C167D1Ev();
Name_Map name_map_S17044C167[] = {
  NSPAIR(_ZN10S17044C167C1Ev),
  NSPAIR(_ZN10S17044C167D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C167[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C167[];
extern void _ZN10S17044C167D1Ev();
extern void _ZN10S17044C167D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1674v173Ev();
extern void _ZN10S17044C1674v174Ev();
extern void _ZN10S17044C1674v175Ev();
extern void _ZN10S17044C1674v176Ev();
static  VTBL_ENTRY vtc_S17044C167[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C167[0]),
  (VTBL_ENTRY)&_ZN10S17044C167D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C167D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1674v173Ev,
  (VTBL_ENTRY)&_ZN10S17044C1674v174Ev,
  (VTBL_ENTRY)&_ZN10S17044C1674v175Ev,
  (VTBL_ENTRY)&_ZN10S17044C1674v176Ev,
};
extern VTBL_ENTRY _ZTI10S17044C167[];
extern  VTBL_ENTRY _ZTV10S17044C167[];
Class_Descriptor cd_S17044C167 = {  "S17044C167", // class name
  bases_S17044C167, 1,
  &(vtc_S17044C167[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI10S17044C167),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C167),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C173  : S17044C4 {
  char s17044c173f0;
  int s17044c173f1;
  int s17044c173f2;
  ::S17044C52_nt s17044c173f3;
  ::S17044C5 s17044c173f4;
  ::S17044C5 s17044c173f5;
  ::S17044C5 s17044c173f6;
  ::S17044C5 s17044c173f7;
  ::S17044C5 s17044c173f8;
  int s17044c173f9;
  int s17044c173f10;
  int s17044c173f11;
  int s17044c173f12;
  char s17044c173f13[256];
  char s17044c173f14[256];
  int s17044c173f15;
  char s17044c173f16;
  char s17044c173f17;
  int s17044c173f18;
  ::S17044C158 s17044c173f19;
  virtual  ~S17044C173(); // _ZN10S17044C173D1Ev
  virtual void  v177(); // _ZN10S17044C1734v177Ev
  virtual void  v178(); // _ZN10S17044C1734v178Ev
  virtual void  v179(); // _ZN10S17044C1734v179Ev
  virtual void  v180(); // _ZN10S17044C1734v180Ev
  S17044C173(); // tgen
};
//SIG(-1 S17044C173) C1{ BC2{ vd v5 v6 v7 v8 v9} vd v1 v2 v3 v4 Fc Fi[2] FC3{ m Fi[2]} FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC4 FC4 FC4 Fi[4] Fc[512] Fi Fc[2] Fi FC9{ BC10{ BC6 FC11{ BC12{}}} Fp[3]}}


 S17044C173 ::~S17044C173(){ note_dtor("S17044C173", this);}
void  S17044C173 ::v177(){vfunc_called(this, "_ZN10S17044C1734v177Ev");}
void  S17044C173 ::v178(){vfunc_called(this, "_ZN10S17044C1734v178Ev");}
void  S17044C173 ::v179(){vfunc_called(this, "_ZN10S17044C1734v179Ev");}
void  S17044C173 ::v180(){vfunc_called(this, "_ZN10S17044C1734v180Ev");}
S17044C173 ::S17044C173(){ note_ctor("S17044C173", this);} // tgen

static void Test_S17044C173()
{
  extern Class_Descriptor cd_S17044C173;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(97,166)];
    init_test(&cd_S17044C173, buf);
    S17044C173 *dp, &lv = *(dp=new (buf) S17044C173());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(768,660), "sizeof(S17044C173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C173)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C173");
    check_field_offset(lv, s17044c173f0, ABISELECT(8,4), "S17044C173.s17044c173f0");
    check_field_offset(lv, s17044c173f1, ABISELECT(12,8), "S17044C173.s17044c173f1");
    check_field_offset(lv, s17044c173f2, ABISELECT(16,12), "S17044C173.s17044c173f2");
    check_field_offset(lv, s17044c173f3, ABISELECT(20,16), "S17044C173.s17044c173f3");
    check_field_offset(lv, s17044c173f4, ABISELECT(32,24), "S17044C173.s17044c173f4");
    check_field_offset(lv, s17044c173f5, ABISELECT(64,40), "S17044C173.s17044c173f5");
    check_field_offset(lv, s17044c173f6, ABISELECT(96,56), "S17044C173.s17044c173f6");
    check_field_offset(lv, s17044c173f7, ABISELECT(128,72), "S17044C173.s17044c173f7");
    check_field_offset(lv, s17044c173f8, ABISELECT(160,88), "S17044C173.s17044c173f8");
    check_field_offset(lv, s17044c173f9, ABISELECT(192,104), "S17044C173.s17044c173f9");
    check_field_offset(lv, s17044c173f10, ABISELECT(196,108), "S17044C173.s17044c173f10");
    check_field_offset(lv, s17044c173f11, ABISELECT(200,112), "S17044C173.s17044c173f11");
    check_field_offset(lv, s17044c173f12, ABISELECT(204,116), "S17044C173.s17044c173f12");
    check_field_offset(lv, s17044c173f13, ABISELECT(208,120), "S17044C173.s17044c173f13");
    check_field_offset(lv, s17044c173f14, ABISELECT(464,376), "S17044C173.s17044c173f14");
    check_field_offset(lv, s17044c173f15, ABISELECT(720,632), "S17044C173.s17044c173f15");
    check_field_offset(lv, s17044c173f16, ABISELECT(724,636), "S17044C173.s17044c173f16");
    check_field_offset(lv, s17044c173f17, ABISELECT(725,637), "S17044C173.s17044c173f17");
    check_field_offset(lv, s17044c173f18, ABISELECT(728,640), "S17044C173.s17044c173f18");
    check_field_offset(lv, s17044c173f19, ABISELECT(736,644), "S17044C173.s17044c173f19");
    test_class_info(&lv, &cd_S17044C173);
    dp->~S17044C173();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C173(Test_S17044C173, "S17044C173", ABISELECT(768,660));

#else // __cplusplus

extern void _ZN10S17044C173C1Ev();
extern void _ZN10S17044C173D1Ev();
Name_Map name_map_S17044C173[] = {
  NSPAIR(_ZN10S17044C173C1Ev),
  NSPAIR(_ZN10S17044C173D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C173[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C173[];
extern void _ZN10S17044C173D1Ev();
extern void _ZN10S17044C173D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1734v177Ev();
extern void _ZN10S17044C1734v178Ev();
extern void _ZN10S17044C1734v179Ev();
extern void _ZN10S17044C1734v180Ev();
static  VTBL_ENTRY vtc_S17044C173[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C173[0]),
  (VTBL_ENTRY)&_ZN10S17044C173D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C173D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1734v177Ev,
  (VTBL_ENTRY)&_ZN10S17044C1734v178Ev,
  (VTBL_ENTRY)&_ZN10S17044C1734v179Ev,
  (VTBL_ENTRY)&_ZN10S17044C1734v180Ev,
};
extern VTBL_ENTRY _ZTI10S17044C173[];
extern  VTBL_ENTRY _ZTV10S17044C173[];
Class_Descriptor cd_S17044C173 = {  "S17044C173", // class name
  bases_S17044C173, 1,
  &(vtc_S17044C173[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(768,660), // object size
  NSPAIRA(_ZTI10S17044C173),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C173),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C174  : S17044C4 {
  int s17044c174f0;
  int s17044c174f1;
  ::S17044C52_nt s17044c174f2;
  ::S17044C113 s17044c174f3;
  int s17044c174f4;
  char s17044c174f5;
  char s17044c174f6;
  int s17044c174f7;
  virtual void  v181(); // _ZN10S17044C1744v181Ev
  virtual void  v182(); // _ZN10S17044C1744v182Ev
  virtual void  v183(); // _ZN10S17044C1744v183Ev
  virtual void  v184(); // _ZN10S17044C1744v184Ev
  ~S17044C174(); // tgen
  S17044C174(); // tgen
};
//SIG(-1 S17044C174) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[2] FC3{ m Fi[2]} FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} Fi Fc[2] Fi}


void  S17044C174 ::v181(){vfunc_called(this, "_ZN10S17044C1744v181Ev");}
void  S17044C174 ::v182(){vfunc_called(this, "_ZN10S17044C1744v182Ev");}
void  S17044C174 ::v183(){vfunc_called(this, "_ZN10S17044C1744v183Ev");}
void  S17044C174 ::v184(){vfunc_called(this, "_ZN10S17044C1744v184Ev");}
S17044C174 ::~S17044C174(){ note_dtor("S17044C174", this);} // tgen
S17044C174 ::S17044C174(){ note_ctor("S17044C174", this);} // tgen

static void Test_S17044C174()
{
  extern Class_Descriptor cd_S17044C174;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,13)];
    init_test(&cd_S17044C174, buf);
    S17044C174 *dp, &lv = *(dp=new (buf) S17044C174());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S17044C174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C174)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C174");
    check_field_offset(lv, s17044c174f0, ABISELECT(8,4), "S17044C174.s17044c174f0");
    check_field_offset(lv, s17044c174f1, ABISELECT(12,8), "S17044C174.s17044c174f1");
    check_field_offset(lv, s17044c174f2, ABISELECT(16,12), "S17044C174.s17044c174f2");
    check_field_offset(lv, s17044c174f3, ABISELECT(24,20), "S17044C174.s17044c174f3");
    check_field_offset(lv, s17044c174f4, ABISELECT(56,36), "S17044C174.s17044c174f4");
    check_field_offset(lv, s17044c174f5, ABISELECT(60,40), "S17044C174.s17044c174f5");
    check_field_offset(lv, s17044c174f6, ABISELECT(61,41), "S17044C174.s17044c174f6");
    check_field_offset(lv, s17044c174f7, ABISELECT(64,44), "S17044C174.s17044c174f7");
    test_class_info(&lv, &cd_S17044C174);
    dp->~S17044C174();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C174(Test_S17044C174, "S17044C174", ABISELECT(72,48));

#else // __cplusplus

extern void _ZN10S17044C174C1Ev();
extern void _ZN10S17044C174D1Ev();
Name_Map name_map_S17044C174[] = {
  NSPAIR(_ZN10S17044C174C1Ev),
  NSPAIR(_ZN10S17044C174D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C174[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C174[];
extern void _ZN10S17044C174D1Ev();
extern void _ZN10S17044C174D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1744v181Ev();
extern void _ZN10S17044C1744v182Ev();
extern void _ZN10S17044C1744v183Ev();
extern void _ZN10S17044C1744v184Ev();
static  VTBL_ENTRY vtc_S17044C174[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C174[0]),
  (VTBL_ENTRY)&_ZN10S17044C174D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C174D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1744v181Ev,
  (VTBL_ENTRY)&_ZN10S17044C1744v182Ev,
  (VTBL_ENTRY)&_ZN10S17044C1744v183Ev,
  (VTBL_ENTRY)&_ZN10S17044C1744v184Ev,
};
extern VTBL_ENTRY _ZTI10S17044C174[];
extern  VTBL_ENTRY _ZTV10S17044C174[];
Class_Descriptor cd_S17044C174 = {  "S17044C174", // class name
  bases_S17044C174, 1,
  &(vtc_S17044C174[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,48), // object size
  NSPAIRA(_ZTI10S17044C174),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C174),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C175  : S17044C3 {
  int s17044c175f0;
  virtual  ~S17044C175(); // _ZN10S17044C175D1Ev
  virtual void  v185(); // _ZN10S17044C1754v185Ev
  virtual void  v186(); // _ZN10S17044C1754v186Ev
  virtual void  v187(); // _ZN10S17044C1754v187Ev
  virtual void  v188(); // _ZN10S17044C1754v188Ev
  virtual void  v189(); // _ZN10S17044C1754v189Ev
  virtual void  v190(); // _ZN10S17044C1754v190Ev
  virtual void  v191(); // _ZN10S17044C1754v191Ev
  virtual void  v192(); // _ZN10S17044C1754v192Ev
  S17044C175(); // tgen
};
//SIG(-1 S17044C175) C1{ BC2{ BC3{ vd v9 v10 v11 v12 v13} vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fc FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 Fi[6] Fc Fp FC9{ m Fp FC10{ BC11{ BC12{ BC13{ BC14{ BC15{ BC6 FC7} FC16{ BC17{}}} FC16} FC18{ BC19{}}} Fp Fi}} FC20{ m FC21{ BC22{ BC23{ BC24{ BC6 FC18} FC25{ BC26{}}} FC25} Fp Fi} FC21}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi}


 S17044C175 ::~S17044C175(){ note_dtor("S17044C175", this);}
void  S17044C175 ::v185(){vfunc_called(this, "_ZN10S17044C1754v185Ev");}
void  S17044C175 ::v186(){vfunc_called(this, "_ZN10S17044C1754v186Ev");}
void  S17044C175 ::v187(){vfunc_called(this, "_ZN10S17044C1754v187Ev");}
void  S17044C175 ::v188(){vfunc_called(this, "_ZN10S17044C1754v188Ev");}
void  S17044C175 ::v189(){vfunc_called(this, "_ZN10S17044C1754v189Ev");}
void  S17044C175 ::v190(){vfunc_called(this, "_ZN10S17044C1754v190Ev");}
void  S17044C175 ::v191(){vfunc_called(this, "_ZN10S17044C1754v191Ev");}
void  S17044C175 ::v192(){vfunc_called(this, "_ZN10S17044C1754v192Ev");}
S17044C175 ::S17044C175(){ note_ctor("S17044C175", this);} // tgen

static void Test_S17044C175()
{
  extern Class_Descriptor cd_S17044C175;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,31)];
    init_test(&cd_S17044C175, buf);
    S17044C175 *dp, &lv = *(dp=new (buf) S17044C175());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,120), "sizeof(S17044C175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C175)");
    check_base_class_offset(lv, (S17044C4*)(S17044C3*), 0, "S17044C175");
    check_base_class_offset(lv, (S17044C3*), 0, "S17044C175");
    check_field_offset(lv, s17044c175f0, ABISELECT(204,116), "S17044C175.s17044c175f0");
    test_class_info(&lv, &cd_S17044C175);
    dp->~S17044C175();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C175(Test_S17044C175, "S17044C175", ABISELECT(208,120));

#else // __cplusplus

extern void _ZN10S17044C175C1Ev();
extern void _ZN10S17044C175D1Ev();
Name_Map name_map_S17044C175[] = {
  NSPAIR(_ZN10S17044C175C1Ev),
  NSPAIR(_ZN10S17044C175D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C3;
extern VTBL_ENTRY _ZTI8S17044C3[];
extern  VTBL_ENTRY _ZTV8S17044C3[];
static Base_Class bases_S17044C175[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C175[];
extern void _ZN10S17044C175D1Ev();
extern void _ZN10S17044C175D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN8S17044C33v13Ev();
extern void _ZN8S17044C33v14Ev();
extern void _ZN8S17044C33v15Ev();
extern void _ZN8S17044C33v16Ev();
extern void _ZN8S17044C33v17Ev();
extern void _ZN8S17044C33v18Ev();
extern void _ZN8S17044C33v19Ev();
extern void _ZN8S17044C33v20Ev();
extern void _ZN8S17044C33v21Ev();
extern void _ZN8S17044C33v22Ev();
extern void _ZN8S17044C33v23Ev();
extern void _ZN8S17044C33v24Ev();
extern void _ZN8S17044C33v25Ev();
extern void _ZN8S17044C33v26Ev();
extern void _ZN8S17044C33v27Ev();
extern void _ZN8S17044C33v28Ev();
extern void _ZN10S17044C1754v185Ev();
extern void _ZN10S17044C1754v186Ev();
extern void _ZN10S17044C1754v187Ev();
extern void _ZN10S17044C1754v188Ev();
extern void _ZN10S17044C1754v189Ev();
extern void _ZN10S17044C1754v190Ev();
extern void _ZN10S17044C1754v191Ev();
extern void _ZN10S17044C1754v192Ev();
static  VTBL_ENTRY vtc_S17044C175[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C175[0]),
  (VTBL_ENTRY)&_ZN10S17044C175D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C175D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v13Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v14Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v15Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v16Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v17Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v18Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v19Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v20Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v21Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v22Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v23Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v24Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v25Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v26Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v27Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v28Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v185Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v186Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v187Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v188Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v189Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v190Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v191Ev,
  (VTBL_ENTRY)&_ZN10S17044C1754v192Ev,
};
extern VTBL_ENTRY _ZTI10S17044C175[];
extern  VTBL_ENTRY _ZTV10S17044C175[];
Class_Descriptor cd_S17044C175 = {  "S17044C175", // class name
  bases_S17044C175, 2,
  &(vtc_S17044C175[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,120), // object size
  NSPAIRA(_ZTI10S17044C175),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C175),33, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C176  : S17044C3 {
  int s17044c176f0;
  virtual  ~S17044C176(); // _ZN10S17044C176D1Ev
  virtual void  v193(); // _ZN10S17044C1764v193Ev
  virtual void  v194(); // _ZN10S17044C1764v194Ev
  virtual void  v195(); // _ZN10S17044C1764v195Ev
  virtual void  v196(); // _ZN10S17044C1764v196Ev
  virtual void  v197(); // _ZN10S17044C1764v197Ev
  virtual void  v198(); // _ZN10S17044C1764v198Ev
  S17044C176(); // tgen
};
//SIG(-1 S17044C176) C1{ BC2{ BC3{ vd v7 v8 v9 v10 v11} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fc FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 Fi[6] Fc Fp FC9{ m Fp FC10{ BC11{ BC12{ BC13{ BC14{ BC15{ BC6 FC7} FC16{ BC17{}}} FC16} FC18{ BC19{}}} Fp Fi}} FC20{ m FC21{ BC22{ BC23{ BC24{ BC6 FC18} FC25{ BC26{}}} FC25} Fp Fi} FC21}} Fi} vd v1 v2 v3 v4 v5 v6 Fi}


 S17044C176 ::~S17044C176(){ note_dtor("S17044C176", this);}
void  S17044C176 ::v193(){vfunc_called(this, "_ZN10S17044C1764v193Ev");}
void  S17044C176 ::v194(){vfunc_called(this, "_ZN10S17044C1764v194Ev");}
void  S17044C176 ::v195(){vfunc_called(this, "_ZN10S17044C1764v195Ev");}
void  S17044C176 ::v196(){vfunc_called(this, "_ZN10S17044C1764v196Ev");}
void  S17044C176 ::v197(){vfunc_called(this, "_ZN10S17044C1764v197Ev");}
void  S17044C176 ::v198(){vfunc_called(this, "_ZN10S17044C1764v198Ev");}
S17044C176 ::S17044C176(){ note_ctor("S17044C176", this);} // tgen

static void Test_S17044C176()
{
  extern Class_Descriptor cd_S17044C176;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,31)];
    init_test(&cd_S17044C176, buf);
    S17044C176 *dp, &lv = *(dp=new (buf) S17044C176());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,120), "sizeof(S17044C176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C176)");
    check_base_class_offset(lv, (S17044C4*)(S17044C3*), 0, "S17044C176");
    check_base_class_offset(lv, (S17044C3*), 0, "S17044C176");
    check_field_offset(lv, s17044c176f0, ABISELECT(204,116), "S17044C176.s17044c176f0");
    test_class_info(&lv, &cd_S17044C176);
    dp->~S17044C176();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C176(Test_S17044C176, "S17044C176", ABISELECT(208,120));

#else // __cplusplus

extern void _ZN10S17044C176C1Ev();
extern void _ZN10S17044C176D1Ev();
Name_Map name_map_S17044C176[] = {
  NSPAIR(_ZN10S17044C176C1Ev),
  NSPAIR(_ZN10S17044C176D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C3;
extern VTBL_ENTRY _ZTI8S17044C3[];
extern  VTBL_ENTRY _ZTV8S17044C3[];
static Base_Class bases_S17044C176[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C176[];
extern void _ZN10S17044C176D1Ev();
extern void _ZN10S17044C176D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN8S17044C33v13Ev();
extern void _ZN8S17044C33v14Ev();
extern void _ZN8S17044C33v15Ev();
extern void _ZN8S17044C33v16Ev();
extern void _ZN8S17044C33v17Ev();
extern void _ZN8S17044C33v18Ev();
extern void _ZN8S17044C33v19Ev();
extern void _ZN8S17044C33v20Ev();
extern void _ZN8S17044C33v21Ev();
extern void _ZN8S17044C33v22Ev();
extern void _ZN8S17044C33v23Ev();
extern void _ZN8S17044C33v24Ev();
extern void _ZN8S17044C33v25Ev();
extern void _ZN8S17044C33v26Ev();
extern void _ZN8S17044C33v27Ev();
extern void _ZN8S17044C33v28Ev();
extern void _ZN10S17044C1764v193Ev();
extern void _ZN10S17044C1764v194Ev();
extern void _ZN10S17044C1764v195Ev();
extern void _ZN10S17044C1764v196Ev();
extern void _ZN10S17044C1764v197Ev();
extern void _ZN10S17044C1764v198Ev();
static  VTBL_ENTRY vtc_S17044C176[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C176[0]),
  (VTBL_ENTRY)&_ZN10S17044C176D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C176D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v13Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v14Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v15Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v16Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v17Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v18Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v19Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v20Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v21Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v22Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v23Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v24Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v25Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v26Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v27Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v28Ev,
  (VTBL_ENTRY)&_ZN10S17044C1764v193Ev,
  (VTBL_ENTRY)&_ZN10S17044C1764v194Ev,
  (VTBL_ENTRY)&_ZN10S17044C1764v195Ev,
  (VTBL_ENTRY)&_ZN10S17044C1764v196Ev,
  (VTBL_ENTRY)&_ZN10S17044C1764v197Ev,
  (VTBL_ENTRY)&_ZN10S17044C1764v198Ev,
};
extern VTBL_ENTRY _ZTI10S17044C176[];
extern  VTBL_ENTRY _ZTV10S17044C176[];
Class_Descriptor cd_S17044C176 = {  "S17044C176", // class name
  bases_S17044C176, 2,
  &(vtc_S17044C176[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,120), // object size
  NSPAIRA(_ZTI10S17044C176),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C176),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C177  : S17044C3 {
  virtual void  v199(); // _ZN10S17044C1774v199Ev
  virtual void  v200(); // _ZN10S17044C1774v200Ev
  virtual void  v201(); // _ZN10S17044C1774v201Ev
  virtual void  v202(); // _ZN10S17044C1774v202Ev
  virtual void  v203(); // _ZN10S17044C1774v203Ev
  virtual void  v204(); // _ZN10S17044C1774v204Ev
  ~S17044C177(); // tgen
  S17044C177(); // tgen
};
//SIG(-1 S17044C177) C1{ BC2{ BC3{ vd v7 v8 v9 v10 v11} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fc FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 Fi[6] Fc Fp FC9{ m Fp FC10{ BC11{ BC12{ BC13{ BC14{ BC15{ BC6 FC7} FC16{ BC17{}}} FC16} FC18{ BC19{}}} Fp Fi}} FC20{ m FC21{ BC22{ BC23{ BC24{ BC6 FC18} FC25{ BC26{}}} FC25} Fp Fi} FC21}} Fi} v1 v2 v3 v4 v5 v6}


void  S17044C177 ::v199(){vfunc_called(this, "_ZN10S17044C1774v199Ev");}
void  S17044C177 ::v200(){vfunc_called(this, "_ZN10S17044C1774v200Ev");}
void  S17044C177 ::v201(){vfunc_called(this, "_ZN10S17044C1774v201Ev");}
void  S17044C177 ::v202(){vfunc_called(this, "_ZN10S17044C1774v202Ev");}
void  S17044C177 ::v203(){vfunc_called(this, "_ZN10S17044C1774v203Ev");}
void  S17044C177 ::v204(){vfunc_called(this, "_ZN10S17044C1774v204Ev");}
S17044C177 ::~S17044C177(){ note_dtor("S17044C177", this);} // tgen
S17044C177 ::S17044C177(){ note_ctor("S17044C177", this);} // tgen

static void Test_S17044C177()
{
  extern Class_Descriptor cd_S17044C177;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,30)];
    init_test(&cd_S17044C177, buf);
    S17044C177 *dp, &lv = *(dp=new (buf) S17044C177());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,116), "sizeof(S17044C177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C177)");
    check_base_class_offset(lv, (S17044C4*)(S17044C3*), 0, "S17044C177");
    check_base_class_offset(lv, (S17044C3*), 0, "S17044C177");
    test_class_info(&lv, &cd_S17044C177);
    dp->~S17044C177();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C177(Test_S17044C177, "S17044C177", ABISELECT(208,116));

#else // __cplusplus

extern void _ZN10S17044C177C1Ev();
extern void _ZN10S17044C177D1Ev();
Name_Map name_map_S17044C177[] = {
  NSPAIR(_ZN10S17044C177C1Ev),
  NSPAIR(_ZN10S17044C177D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
extern Class_Descriptor cd_S17044C3;
extern VTBL_ENTRY _ZTI8S17044C3[];
extern  VTBL_ENTRY _ZTV8S17044C3[];
static Base_Class bases_S17044C177[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17044C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C177[];
extern void _ZN10S17044C177D1Ev();
extern void _ZN10S17044C177D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN8S17044C33v13Ev();
extern void _ZN8S17044C33v14Ev();
extern void _ZN8S17044C33v15Ev();
extern void _ZN8S17044C33v16Ev();
extern void _ZN8S17044C33v17Ev();
extern void _ZN8S17044C33v18Ev();
extern void _ZN8S17044C33v19Ev();
extern void _ZN8S17044C33v20Ev();
extern void _ZN8S17044C33v21Ev();
extern void _ZN8S17044C33v22Ev();
extern void _ZN8S17044C33v23Ev();
extern void _ZN8S17044C33v24Ev();
extern void _ZN8S17044C33v25Ev();
extern void _ZN8S17044C33v26Ev();
extern void _ZN8S17044C33v27Ev();
extern void _ZN8S17044C33v28Ev();
extern void _ZN10S17044C1774v199Ev();
extern void _ZN10S17044C1774v200Ev();
extern void _ZN10S17044C1774v201Ev();
extern void _ZN10S17044C1774v202Ev();
extern void _ZN10S17044C1774v203Ev();
extern void _ZN10S17044C1774v204Ev();
static  VTBL_ENTRY vtc_S17044C177[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C177[0]),
  (VTBL_ENTRY)&_ZN10S17044C177D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C177D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v13Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v14Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v15Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v16Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v17Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v18Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v19Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v20Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v21Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v22Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v23Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v24Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v25Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v26Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v27Ev,
  (VTBL_ENTRY)&_ZN8S17044C33v28Ev,
  (VTBL_ENTRY)&_ZN10S17044C1774v199Ev,
  (VTBL_ENTRY)&_ZN10S17044C1774v200Ev,
  (VTBL_ENTRY)&_ZN10S17044C1774v201Ev,
  (VTBL_ENTRY)&_ZN10S17044C1774v202Ev,
  (VTBL_ENTRY)&_ZN10S17044C1774v203Ev,
  (VTBL_ENTRY)&_ZN10S17044C1774v204Ev,
};
extern VTBL_ENTRY _ZTI10S17044C177[];
extern  VTBL_ENTRY _ZTV10S17044C177[];
Class_Descriptor cd_S17044C177 = {  "S17044C177", // class name
  bases_S17044C177, 2,
  &(vtc_S17044C177[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,116), // object size
  NSPAIRA(_ZTI10S17044C177),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C177),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C178  : S17044C4 {
  void *s17044c178f0;
  int s17044c178f1;
  virtual void  v205(); // _ZN10S17044C1784v205Ev
  virtual void  v206(); // _ZN10S17044C1784v206Ev
  virtual void  v207(); // _ZN10S17044C1784v207Ev
  virtual void  v208(); // _ZN10S17044C1784v208Ev
  ~S17044C178(); // tgen
  S17044C178(); // tgen
};
//SIG(-1 S17044C178) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fp Fi}


void  S17044C178 ::v205(){vfunc_called(this, "_ZN10S17044C1784v205Ev");}
void  S17044C178 ::v206(){vfunc_called(this, "_ZN10S17044C1784v206Ev");}
void  S17044C178 ::v207(){vfunc_called(this, "_ZN10S17044C1784v207Ev");}
void  S17044C178 ::v208(){vfunc_called(this, "_ZN10S17044C1784v208Ev");}
S17044C178 ::~S17044C178(){ note_dtor("S17044C178", this);} // tgen
S17044C178 ::S17044C178(){ note_ctor("S17044C178", this);} // tgen

static void Test_S17044C178()
{
  extern Class_Descriptor cd_S17044C178;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S17044C178, buf);
    S17044C178 *dp, &lv = *(dp=new (buf) S17044C178());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S17044C178)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C178)");
    check_base_class_offset(lv, (S17044C4*), 0, "S17044C178");
    check_field_offset(lv, s17044c178f0, ABISELECT(8,4), "S17044C178.s17044c178f0");
    check_field_offset(lv, s17044c178f1, ABISELECT(16,8), "S17044C178.s17044c178f1");
    test_class_info(&lv, &cd_S17044C178);
    dp->~S17044C178();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C178(Test_S17044C178, "S17044C178", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN10S17044C178C1Ev();
extern void _ZN10S17044C178D1Ev();
Name_Map name_map_S17044C178[] = {
  NSPAIR(_ZN10S17044C178C1Ev),
  NSPAIR(_ZN10S17044C178D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C4;
extern VTBL_ENTRY _ZTI8S17044C4[];
extern  VTBL_ENTRY _ZTV8S17044C4[];
static Base_Class bases_S17044C178[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C178[];
extern void _ZN10S17044C178D1Ev();
extern void _ZN10S17044C178D0Ev();
extern void _ZN8S17044C42v8Ev();
extern void _ZN8S17044C42v9Ev();
extern void _ZN8S17044C43v10Ev();
extern void _ZN8S17044C43v11Ev();
extern void _ZN8S17044C43v12Ev();
extern void _ZN10S17044C1784v205Ev();
extern void _ZN10S17044C1784v206Ev();
extern void _ZN10S17044C1784v207Ev();
extern void _ZN10S17044C1784v208Ev();
static  VTBL_ENTRY vtc_S17044C178[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C178[0]),
  (VTBL_ENTRY)&_ZN10S17044C178D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C178D0Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17044C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17044C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17044C1784v205Ev,
  (VTBL_ENTRY)&_ZN10S17044C1784v206Ev,
  (VTBL_ENTRY)&_ZN10S17044C1784v207Ev,
  (VTBL_ENTRY)&_ZN10S17044C1784v208Ev,
};
extern VTBL_ENTRY _ZTI10S17044C178[];
extern  VTBL_ENTRY _ZTV10S17044C178[];
Class_Descriptor cd_S17044C178 = {  "S17044C178", // class name
  bases_S17044C178, 1,
  &(vtc_S17044C178[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI10S17044C178),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C178),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C179  : S17044C48 {
  void *s17044c179f0;
  char s17044c179f1;
  virtual  ~S17044C179(); // _ZN10S17044C179D1Ev
  virtual void  v209(); // _ZN10S17044C1794v209Ev
  virtual void  v210(); // _ZN10S17044C1794v210Ev
  virtual void  v211(); // _ZN10S17044C1794v211Ev
  S17044C179(); // tgen
};
//SIG(-1 S17044C179) C1{ BC2{ vd v4 v5 v6 Fp} vd v1 v2 v3 Fp Fc}


 S17044C179 ::~S17044C179(){ note_dtor("S17044C179", this);}
void  S17044C179 ::v209(){vfunc_called(this, "_ZN10S17044C1794v209Ev");}
void  S17044C179 ::v210(){vfunc_called(this, "_ZN10S17044C1794v210Ev");}
void  S17044C179 ::v211(){vfunc_called(this, "_ZN10S17044C1794v211Ev");}
S17044C179 ::S17044C179(){ note_ctor("S17044C179", this);} // tgen

static void Test_S17044C179()
{
  extern Class_Descriptor cd_S17044C179;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S17044C179, buf);
    S17044C179 *dp, &lv = *(dp=new (buf) S17044C179());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S17044C179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C179)");
    check_base_class_offset(lv, (S17044C48*), 0, "S17044C179");
    check_field_offset(lv, s17044c179f0, ABISELECT(16,8), "S17044C179.s17044c179f0");
    check_field_offset(lv, s17044c179f1, ABISELECT(24,12), "S17044C179.s17044c179f1");
    test_class_info(&lv, &cd_S17044C179);
    dp->~S17044C179();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17044C179(Test_S17044C179, "S17044C179", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN10S17044C179C1Ev();
extern void _ZN10S17044C179D1Ev();
Name_Map name_map_S17044C179[] = {
  NSPAIR(_ZN10S17044C179C1Ev),
  NSPAIR(_ZN10S17044C179D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17044C48;
extern VTBL_ENTRY _ZTI9S17044C48[];
extern  VTBL_ENTRY _ZTV9S17044C48[];
static Base_Class bases_S17044C179[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17044C179[];
extern void _ZN10S17044C179D1Ev();
extern void _ZN10S17044C179D0Ev();
extern void _ZN9S17044C483v33Ev();
extern void _ZN9S17044C483v34Ev();
extern void _ZN9S17044C483v35Ev();
extern void _ZN10S17044C1794v209Ev();
extern void _ZN10S17044C1794v210Ev();
extern void _ZN10S17044C1794v211Ev();
static  VTBL_ENTRY vtc_S17044C179[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17044C179[0]),
  (VTBL_ENTRY)&_ZN10S17044C179D1Ev,
  (VTBL_ENTRY)&_ZN10S17044C179D0Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17044C483v35Ev,
  (VTBL_ENTRY)&_ZN10S17044C1794v209Ev,
  (VTBL_ENTRY)&_ZN10S17044C1794v210Ev,
  (VTBL_ENTRY)&_ZN10S17044C1794v211Ev,
};
extern VTBL_ENTRY _ZTI10S17044C179[];
extern  VTBL_ENTRY _ZTV10S17044C179[];
Class_Descriptor cd_S17044C179 = {  "S17044C179", // class name
  bases_S17044C179, 1,
  &(vtc_S17044C179[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI10S17044C179),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17044C179),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17044C1  {
  int s17044c1f0[16];
  void *s17044c1f1;
  ::S17044C2 s17044c1f2;
  ::S17044C46_nt s17044c1f3;
  ::S17044C46_nt s17044c1f4;
  ::S17044C46_nt s17044c1f5;
  ::S17044C47 s17044c1f6;
  ::S17044C46_nt s17044c1f7;
  ::S17044C49 s17044c1f8;
  ::S17044C50 s17044c1f9;
  ::S17044C46_nt s17044c1f10;
  ::S17044C51 s17044c1f11;
  ::S17044C46_nt s17044c1f12;
  ::S17044C71 s17044c1f13;
  ::S17044C79 s17044c1f14;
  ::S17044C79 s17044c1f15;
  ::S17044C81 s17044c1f16;
  ::S17044C82 s17044c1f17;
  ::S17044C83 s17044c1f18;
  ::S17044C85 s17044c1f19;
  ::S17044C87 s17044c1f20;
  ::S17044C88 s17044c1f21;
  ::S17044C89 s17044c1f22;
  ::S17044C103 s17044c1f23;
  ::S17044C104 s17044c1f24;
  ::S17044C81 s17044c1f25;
  ::S17044C106 s17044c1f26;
  ::S17044C106 s17044c1f27;
  ::S17044C108 s17044c1f28;
  ::S17044C108 s17044c1f29;
  ::S17044C110 s17044c1f30;
  ::S17044C111 s17044c1f31;
  ::S17044C46_nt s17044c1f32;
  ::S17044C112 s17044c1f33;
  ::S17044C46_nt s17044c1f34;
  ::S17044C148 s17044c1f35;
  ::S17044C46_nt s17044c1f36;
  ::S17044C149 s17044c1f37;
  ::S17044C46_nt s17044c1f38;
  ::S17044C46_nt s17044c1f39;
  ::S17044C162 s17044c1f40;
  ::S17044C46_nt s17044c1f41;
  ::S17044C163 s17044c1f42;
  ::S17044C46_nt s17044c1f43;
  ::S17044C163 s17044c1f44;
  ::S17044C46_nt s17044c1f45;
  ::S17044C46_nt s17044c1f46;
  ::S17044C165 s17044c1f47;
  ::S17044C166 s17044c1f48;
  ::S17044C167 s17044c1f49;
  ::S17044C173 s17044c1f50;
  ::S17044C46_nt s17044c1f51;
  ::S17044C174 s17044c1f52;
  ::S17044C46_nt s17044c1f53;
  ::S17044C46_nt s17044c1f54;
  ::S17044C175 s17044c1f55;
  ::S17044C46_nt s17044c1f56;
  ::S17044C46_nt s17044c1f57;
  ::S17044C176 s17044c1f58;
  ::S17044C46_nt s17044c1f59;
  ::S17044C46_nt s17044c1f60;
  ::S17044C46_nt s17044c1f61;
  ::S17044C46_nt s17044c1f62;
  ::S17044C46_nt s17044c1f63;
  ::S17044C46_nt s17044c1f64;
  ::S17044C46_nt s17044c1f65;
  ::S17044C177 s17044c1f66;
  ::S17044C46_nt s17044c1f67;
  ::S17044C46_nt s17044c1f68;
  ::S17044C46_nt s17044c1f69;
  ::S17044C46_nt s17044c1f70;
  ::S17044C178 s17044c1f71;
  ::S17044C178 s17044c1f72;
  ::S17044C178 s17044c1f73;
  ::S17044C178 s17044c1f74;
  ::S17044C178 s17044c1f75;
  ::S17044C46_nt s17044c1f76;
  ::S17044C46_nt s17044c1f77;
  ::S17044C112 s17044c1f78;
  ::S17044C46_nt s17044c1f79;
  ::S17044C174 s17044c1f80;
  ::S17044C46_nt s17044c1f81;
  ::S17044C179 s17044c1f82;
  ::S17044C46_nt s17044c1f83;
  ::S17044C178 s17044c1f84;
  ::S17044C178 s17044c1f85;
  ::S17044C178 s17044c1f86;
  ::S17044C178 s17044c1f87;
  void  mf17044c1(); // _ZN8S17044C19mf17044c1Ev
};
//SIG(1 S17044C1) C1{ m Fi[16] Fp FC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fc FC5{ BC6{ BC7{} FC8{ BC9{}}} Fp[3]} FC5 Fi[6] Fc Fp FC10{ m Fp FC11{ BC12{ BC13{ BC14{ BC15{ BC16{ BC7 FC8} FC17{ BC18{}}} FC17} FC19{ BC20{}}} Fp Fi}} FC21{ m FC22{ BC23{ BC24{ BC25{ BC7 FC19} FC26{ BC27{}}} FC26} Fp Fi} FC22}} Fi} vd v1 v2 v3 v4 v5 v6 v7 Fc Fi Fc[2]} FC28{ m Fp} FC28 FC28 FC29{ BC30{ vd v33 v34 v35 Fp} vd v29 v30 v31 v32 Fp Fc Fi[2]} FC28 FC31{ BC29 vd v36} FC32{ BC3 vd v37 v38 v39 v40 v41 v42 v43 Fc Fi Fc} FC28 FC33{ BC4 vd v44 v45 v46 v47 Fi[2] FC34{ m Fi[2]} FC5 FC5 FC5 FC5 FC5 FC5 FC5 FC5 FC11 Fi[3] Fc[3] Fi Fc[512] Fi[3] Fc[2]} FC28 FC35{ BC36{ BC4 vd v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC5 FC5 FC37{ BC38{ BC39{ BC7} FC40{ BC41{}}} FU42{ Fc[16] Fp} Fi Fi} FC37 FC37 Fp Fc Fc Fc Fc Fc Fi} vd v48 v49 v50 v51 v52 v53 v54} FC43{ BC36 v70 v71 v72 v73 Fi} FC43 FC44{ BC36 v74 v75 v76 v77} FC45{ BC36 vd v78 v79 v80 v81 v82 Fp Fi} FC46{ BC36 v83 v84 v85 v86 v87 Fc FC47{ m Fc Fi Fc Fc[1024] Fi Fi Fp} FC47} FC48{ BC36 vd v88 v89 v90 v91 FC49{ m Fi Fc} FC47} FC50{ BC36 vd v92 v93 v94 v95 Fc} FC51{ BC36 vd v96 v97 v98 v99 FC49 FC47 FC37} FC52{ BC36 v100 v101 v102 v103 Fi Fi FC53{ m Fi Fi Fi Fc} FC53 FC54{ BC55{ BC56{ BC57{ BC58{ BC59{ BC7 FC8} FC40} FC60{ BC61{}}} FC60} Fp Fi}} Fi} FC62{ BC36 vd v104 v105 v106 v107 Fi Fi} FC63{ BC36 v108 v109 v110 v111 v112 Fc Fi Fc} FC44 FC64{ BC36 v113 v114} FC64 FC65{ BC36 v115 v116 v117 v118} FC65 FC66{ BC36 v119 v120} FC67{ BC36 v121 v122 v123 v124} FC28 FC68{ BC4 BC30 vd v125 v126 v127 v128 v129 v130 Fi Fi FC34 FC69{ BC70{ BC7 FC71{ BC72{}}} Fp Fp Fp} FC37 FC69 Fi Fi Fc Fc Fc Fi Fi Fi Fi Fi FC37 FC37 FC37 FC37 FC73{ BC74{ m Fp}} FC73 FC73 FC73 FC75{ m FL} Fc FC76{ BC77{ m FC78{ m Fc Fc[15]} FC78 FC78 FC78}} Fc Fi Fi Fc Fc Fc Fc FC79{ m FC80{ m Fi Fp Fi[17]}} FC79 FC79 FC79 FC81{ m FC82{ BC83{ BC7 FC71} Fp Fp Fp} FC84{ BC85{ BC86{ BC87{ BC7 FC88{ BC89{}}} FC88} FC90{ BC91{}}} Fp Fp Fi} Fi Fi} FC82 Fi FC37 Fc Fc FC75 Fc Fc Fc} FC28 FC92{ BC4 v131 v132 v133 v134 Fi Fi FC34 FC5 Fi FC5 Fi Fc} FC28 FC93{ BC4 v135 v136 v137 v138 Fi Fi FC34 FC5 Fi Fi Fi Fc Fi Fi FC94{ BC95{ BC7 FC90} Fp Fp Fp} FC94 FC96{ BC97{ BC7 FC98{ BC99{}}} Fp Fp Fp} FC5 FC5 FC5 FC5} FC28 FC28 FC100{ BC4 v139 v140 v141 v142 Fi Fi FC34 Fc} FC28 FC101{ BC4 v143 v144 v145 v146 Fi Fi FC34} FC28 FC101 FC28 FC28 FC102{ BC4 v147 v148 v149 v150 Fi Fi Fi Fi Fc Fc Fi} FC103{ BC4 v151 v152 v153 v154 Fi Fi Fc Fc Fi} FC104{ BC4 v155 v156 v157 v158 Fi Fc Fc Fi FC69 FC105{ BC106{ BC107{ BC108{ BC109{}}} Fp}}} FC110{ BC4 vd v159 v160 v161 v162 Fc Fi Fi FC34 FC5 FC5 FC5 FC5 FC5 Fi Fi Fi Fi Fc[256] Fc[256] Fi Fc Fc Fi FC96} FC28 FC111{ BC4 v163 v164 v165 v166 Fi Fi FC34 FC69 Fi Fc Fc Fi} FC28 FC28 FC112{ BC3 vd v167 v168 v169 v170 v171 v172 v173 v174 Fi} FC28 FC28 FC113{ BC3 vd v175 v176 v177 v178 v179 v180 Fi} FC28 FC28 FC28 FC28 FC28 FC28 FC28 FC114{ BC3 v181 v182 v183 v184 v185 v186} FC28 FC28 FC28 FC28 FC115{ BC4 v187 v188 v189 v190 Fp Fi} FC115 FC115 FC115 FC115 FC28 FC28 FC68 FC28 FC111 FC28 FC116{ BC30 vd v191 v192 v193 Fp Fc} FC28 FC115 FC115 FC115 FC115}


void  S17044C1 ::mf17044c1(){}

static void Test_S17044C1()
{
  {
    init_simple_test("S17044C1");
    S17044C1 lv;
    check2(sizeof(lv), ABISELECT(14016,11252), "sizeof(S17044C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17044C1)");
    check_field_offset(lv, s17044c1f0, 0, "S17044C1.s17044c1f0");
    check_field_offset(lv, s17044c1f1, 64, "S17044C1.s17044c1f1");
    check_field_offset(lv, s17044c1f2, ABISELECT(72,68), "S17044C1.s17044c1f2");
    check_field_offset(lv, s17044c1f3, ABISELECT(288,196), "S17044C1.s17044c1f3");
    check_field_offset(lv, s17044c1f4, ABISELECT(296,200), "S17044C1.s17044c1f4");
    check_field_offset(lv, s17044c1f5, ABISELECT(304,204), "S17044C1.s17044c1f5");
    check_field_offset(lv, s17044c1f6, ABISELECT(312,208), "S17044C1.s17044c1f6");
    check_field_offset(lv, s17044c1f7, ABISELECT(352,232), "S17044C1.s17044c1f7");
    check_field_offset(lv, s17044c1f8, ABISELECT(360,236), "S17044C1.s17044c1f8");
    check_field_offset(lv, s17044c1f9, ABISELECT(400,260), "S17044C1.s17044c1f9");
    check_field_offset(lv, s17044c1f10, ABISELECT(616,388), "S17044C1.s17044c1f10");
    check_field_offset(lv, s17044c1f11, ABISELECT(624,392), "S17044C1.s17044c1f11");
    check_field_offset(lv, s17044c1f12, ABISELECT(1480,1100), "S17044C1.s17044c1f12");
    check_field_offset(lv, s17044c1f13, ABISELECT(1488,1104), "S17044C1.s17044c1f13");
    check_field_offset(lv, s17044c1f14, ABISELECT(1680,1240), "S17044C1.s17044c1f14");
    check_field_offset(lv, s17044c1f15, ABISELECT(1872,1380), "S17044C1.s17044c1f15");
    check_field_offset(lv, s17044c1f16, ABISELECT(2064,1520), "S17044C1.s17044c1f16");
    check_field_offset(lv, s17044c1f17, ABISELECT(2256,1656), "S17044C1.s17044c1f17");
    check_field_offset(lv, s17044c1f18, ABISELECT(2464,1800), "S17044C1.s17044c1f18");
    check_field_offset(lv, s17044c1f19, ABISELECT(4768,4036), "S17044C1.s17044c1f19");
    check_field_offset(lv, s17044c1f20, ABISELECT(6024,5228), "S17044C1.s17044c1f20");
    check_field_offset(lv, s17044c1f21, ABISELECT(6216,5368), "S17044C1.s17044c1f21");
    check_field_offset(lv, s17044c1f22, ABISELECT(7504,6588), "S17044C1.s17044c1f22");
    check_field_offset(lv, s17044c1f23, ABISELECT(7768,6780), "S17044C1.s17044c1f23");
    check_field_offset(lv, s17044c1f24, ABISELECT(7968,6924), "S17044C1.s17044c1f24");
    check_field_offset(lv, s17044c1f25, ABISELECT(8168,7072), "S17044C1.s17044c1f25");
    check_field_offset(lv, s17044c1f26, ABISELECT(8360,7208), "S17044C1.s17044c1f26");
    check_field_offset(lv, s17044c1f27, ABISELECT(8552,7344), "S17044C1.s17044c1f27");
    check_field_offset(lv, s17044c1f28, ABISELECT(8744,7480), "S17044C1.s17044c1f28");
    check_field_offset(lv, s17044c1f29, ABISELECT(8936,7616), "S17044C1.s17044c1f29");
    check_field_offset(lv, s17044c1f30, ABISELECT(9128,7752), "S17044C1.s17044c1f30");
    check_field_offset(lv, s17044c1f31, ABISELECT(9320,7888), "S17044C1.s17044c1f31");
    check_field_offset(lv, s17044c1f32, ABISELECT(9512,8024), "S17044C1.s17044c1f32");
    check_field_offset(lv, s17044c1f33, ABISELECT(9520,8028), "S17044C1.s17044c1f33");
    check_field_offset(lv, s17044c1f34, ABISELECT(10456,8772), "S17044C1.s17044c1f34");
    check_field_offset(lv, s17044c1f35, ABISELECT(10464,8776), "S17044C1.s17044c1f35");
    check_field_offset(lv, s17044c1f36, ABISELECT(10568,8840), "S17044C1.s17044c1f36");
    check_field_offset(lv, s17044c1f37, ABISELECT(10576,8844), "S17044C1.s17044c1f37");
    check_field_offset(lv, s17044c1f38, ABISELECT(10880,9016), "S17044C1.s17044c1f38");
    check_field_offset(lv, s17044c1f39, ABISELECT(10888,9020), "S17044C1.s17044c1f39");
    check_field_offset(lv, s17044c1f40, ABISELECT(10896,9024), "S17044C1.s17044c1f40");
    check_field_offset(lv, s17044c1f41, ABISELECT(10928,9048), "S17044C1.s17044c1f41");
    check_field_offset(lv, s17044c1f42, ABISELECT(10936,9052), "S17044C1.s17044c1f42");
    check_field_offset(lv, s17044c1f43, ABISELECT(10960,9072), "S17044C1.s17044c1f43");
    check_field_offset(lv, s17044c1f44, ABISELECT(10968,9076), "S17044C1.s17044c1f44");
    check_field_offset(lv, s17044c1f45, ABISELECT(10992,9096), "S17044C1.s17044c1f45");
    check_field_offset(lv, s17044c1f46, ABISELECT(11000,9100), "S17044C1.s17044c1f46");
    check_field_offset(lv, s17044c1f47, ABISELECT(11008,9104), "S17044C1.s17044c1f47");
    check_field_offset(lv, s17044c1f48, ABISELECT(11040,9132), "S17044C1.s17044c1f48");
    check_field_offset(lv, s17044c1f49, ABISELECT(11064,9152), "S17044C1.s17044c1f49");
    check_field_offset(lv, s17044c1f50, ABISELECT(11128,9188), "S17044C1.s17044c1f50");
    check_field_offset(lv, s17044c1f51, ABISELECT(11896,9848), "S17044C1.s17044c1f51");
    check_field_offset(lv, s17044c1f52, ABISELECT(11904,9852), "S17044C1.s17044c1f52");
    check_field_offset(lv, s17044c1f53, ABISELECT(11976,9900), "S17044C1.s17044c1f53");
    check_field_offset(lv, s17044c1f54, ABISELECT(11984,9904), "S17044C1.s17044c1f54");
    check_field_offset(lv, s17044c1f55, ABISELECT(11992,9908), "S17044C1.s17044c1f55");
    check_field_offset(lv, s17044c1f56, ABISELECT(12200,10028), "S17044C1.s17044c1f56");
    check_field_offset(lv, s17044c1f57, ABISELECT(12208,10032), "S17044C1.s17044c1f57");
    check_field_offset(lv, s17044c1f58, ABISELECT(12216,10036), "S17044C1.s17044c1f58");
    check_field_offset(lv, s17044c1f59, ABISELECT(12424,10156), "S17044C1.s17044c1f59");
    check_field_offset(lv, s17044c1f60, ABISELECT(12432,10160), "S17044C1.s17044c1f60");
    check_field_offset(lv, s17044c1f61, ABISELECT(12440,10164), "S17044C1.s17044c1f61");
    check_field_offset(lv, s17044c1f62, ABISELECT(12448,10168), "S17044C1.s17044c1f62");
    check_field_offset(lv, s17044c1f63, ABISELECT(12456,10172), "S17044C1.s17044c1f63");
    check_field_offset(lv, s17044c1f64, ABISELECT(12464,10176), "S17044C1.s17044c1f64");
    check_field_offset(lv, s17044c1f65, ABISELECT(12472,10180), "S17044C1.s17044c1f65");
    check_field_offset(lv, s17044c1f66, ABISELECT(12480,10184), "S17044C1.s17044c1f66");
    check_field_offset(lv, s17044c1f67, ABISELECT(12688,10300), "S17044C1.s17044c1f67");
    check_field_offset(lv, s17044c1f68, ABISELECT(12696,10304), "S17044C1.s17044c1f68");
    check_field_offset(lv, s17044c1f69, ABISELECT(12704,10308), "S17044C1.s17044c1f69");
    check_field_offset(lv, s17044c1f70, ABISELECT(12712,10312), "S17044C1.s17044c1f70");
    check_field_offset(lv, s17044c1f71, ABISELECT(12720,10316), "S17044C1.s17044c1f71");
    check_field_offset(lv, s17044c1f72, ABISELECT(12744,10328), "S17044C1.s17044c1f72");
    check_field_offset(lv, s17044c1f73, ABISELECT(12768,10340), "S17044C1.s17044c1f73");
    check_field_offset(lv, s17044c1f74, ABISELECT(12792,10352), "S17044C1.s17044c1f74");
    check_field_offset(lv, s17044c1f75, ABISELECT(12816,10364), "S17044C1.s17044c1f75");
    check_field_offset(lv, s17044c1f76, ABISELECT(12840,10376), "S17044C1.s17044c1f76");
    check_field_offset(lv, s17044c1f77, ABISELECT(12848,10380), "S17044C1.s17044c1f77");
    check_field_offset(lv, s17044c1f78, ABISELECT(12856,10384), "S17044C1.s17044c1f78");
    check_field_offset(lv, s17044c1f79, ABISELECT(13792,11128), "S17044C1.s17044c1f79");
    check_field_offset(lv, s17044c1f80, ABISELECT(13800,11132), "S17044C1.s17044c1f80");
    check_field_offset(lv, s17044c1f81, ABISELECT(13872,11180), "S17044C1.s17044c1f81");
    check_field_offset(lv, s17044c1f82, ABISELECT(13880,11184), "S17044C1.s17044c1f82");
    check_field_offset(lv, s17044c1f83, ABISELECT(13912,11200), "S17044C1.s17044c1f83");
    check_field_offset(lv, s17044c1f84, ABISELECT(13920,11204), "S17044C1.s17044c1f84");
    check_field_offset(lv, s17044c1f85, ABISELECT(13944,11216), "S17044C1.s17044c1f85");
    check_field_offset(lv, s17044c1f86, ABISELECT(13968,11228), "S17044C1.s17044c1f86");
    check_field_offset(lv, s17044c1f87, ABISELECT(13992,11240), "S17044C1.s17044c1f87");
  }
}
static Arrange_To_Call_Me vS17044C1(Test_S17044C1, "S17044C1", ABISELECT(14016,11252));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C48  {
  void *s17045c48f0;
  virtual  ~S17045C48(); // _ZN9S17045C48D1Ev
  virtual void  v33(); // _ZN9S17045C483v33Ev
  virtual void  v34(); // _ZN9S17045C483v34Ev
  virtual void  v35(); // _ZN9S17045C483v35Ev
  S17045C48(); // tgen
};
//SIG(-1 S17045C48) C1{ vd v1 v2 v3 Fp}


 S17045C48 ::~S17045C48(){ note_dtor("S17045C48", this);}
void  S17045C48 ::v33(){vfunc_called(this, "_ZN9S17045C483v33Ev");}
void  S17045C48 ::v34(){vfunc_called(this, "_ZN9S17045C483v34Ev");}
void  S17045C48 ::v35(){vfunc_called(this, "_ZN9S17045C483v35Ev");}
S17045C48 ::S17045C48(){ note_ctor("S17045C48", this);} // tgen

static void Test_S17045C48()
{
  extern Class_Descriptor cd_S17045C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S17045C48, buf);
    S17045C48 *dp, &lv = *(dp=new (buf) S17045C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S17045C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C48)");
    check_field_offset(lv, s17045c48f0, ABISELECT(8,4), "S17045C48.s17045c48f0");
    test_class_info(&lv, &cd_S17045C48);
    dp->~S17045C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C48(Test_S17045C48, "S17045C48", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN9S17045C48C1Ev();
extern void _ZN9S17045C48D1Ev();
Name_Map name_map_S17045C48[] = {
  NSPAIR(_ZN9S17045C48C1Ev),
  NSPAIR(_ZN9S17045C48D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S17045C48[];
extern void _ZN9S17045C48D1Ev();
extern void _ZN9S17045C48D0Ev();
extern void _ZN9S17045C483v33Ev();
extern void _ZN9S17045C483v34Ev();
extern void _ZN9S17045C483v35Ev();
static  VTBL_ENTRY vtc_S17045C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17045C48[0]),
  (VTBL_ENTRY)&_ZN9S17045C48D1Ev,
  (VTBL_ENTRY)&_ZN9S17045C48D0Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v35Ev,
};
extern VTBL_ENTRY _ZTI9S17045C48[];
extern  VTBL_ENTRY _ZTV9S17045C48[];
Class_Descriptor cd_S17045C48 = {  "S17045C48", // class name
  0,0,//no base classes
  &(vtc_S17045C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S17045C48),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S17045C48),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C47  : S17045C48 {
  void *s17045c47f0;
  char s17045c47f1;
  int s17045c47f2[2];
  virtual  ~S17045C47(); // _ZN9S17045C47D1Ev
  virtual void  v29(); // _ZN9S17045C473v29Ev
  virtual void  v30(); // _ZN9S17045C473v30Ev
  virtual void  v31(); // _ZN9S17045C473v31Ev
  virtual void  v32(); // _ZN9S17045C473v32Ev
  S17045C47(); // tgen
};
//SIG(-1 S17045C47) C1{ BC2{ vd v5 v6 v7 Fp} vd v1 v2 v3 v4 Fp Fc Fi[2]}


 S17045C47 ::~S17045C47(){ note_dtor("S17045C47", this);}
void  S17045C47 ::v29(){vfunc_called(this, "_ZN9S17045C473v29Ev");}
void  S17045C47 ::v30(){vfunc_called(this, "_ZN9S17045C473v30Ev");}
void  S17045C47 ::v31(){vfunc_called(this, "_ZN9S17045C473v31Ev");}
void  S17045C47 ::v32(){vfunc_called(this, "_ZN9S17045C473v32Ev");}
S17045C47 ::S17045C47(){ note_ctor("S17045C47", this);} // tgen

static void Test_S17045C47()
{
  extern Class_Descriptor cd_S17045C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S17045C47, buf);
    S17045C47 *dp, &lv = *(dp=new (buf) S17045C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S17045C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C47)");
    check_base_class_offset(lv, (S17045C48*), 0, "S17045C47");
    check_field_offset(lv, s17045c47f0, ABISELECT(16,8), "S17045C47.s17045c47f0");
    check_field_offset(lv, s17045c47f1, ABISELECT(24,12), "S17045C47.s17045c47f1");
    check_field_offset(lv, s17045c47f2, ABISELECT(28,16), "S17045C47.s17045c47f2");
    test_class_info(&lv, &cd_S17045C47);
    dp->~S17045C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C47(Test_S17045C47, "S17045C47", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN9S17045C47C1Ev();
extern void _ZN9S17045C47D1Ev();
Name_Map name_map_S17045C47[] = {
  NSPAIR(_ZN9S17045C47C1Ev),
  NSPAIR(_ZN9S17045C47D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17045C48;
extern VTBL_ENTRY _ZTI9S17045C48[];
extern  VTBL_ENTRY _ZTV9S17045C48[];
static Base_Class bases_S17045C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17045C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17045C47[];
extern void _ZN9S17045C47D1Ev();
extern void _ZN9S17045C47D0Ev();
extern void _ZN9S17045C483v33Ev();
extern void _ZN9S17045C483v34Ev();
extern void _ZN9S17045C483v35Ev();
extern void _ZN9S17045C473v29Ev();
extern void _ZN9S17045C473v30Ev();
extern void _ZN9S17045C473v31Ev();
extern void _ZN9S17045C473v32Ev();
static  VTBL_ENTRY vtc_S17045C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17045C47[0]),
  (VTBL_ENTRY)&_ZN9S17045C47D1Ev,
  (VTBL_ENTRY)&_ZN9S17045C47D0Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v35Ev,
  (VTBL_ENTRY)&_ZN9S17045C473v29Ev,
  (VTBL_ENTRY)&_ZN9S17045C473v30Ev,
  (VTBL_ENTRY)&_ZN9S17045C473v31Ev,
  (VTBL_ENTRY)&_ZN9S17045C473v32Ev,
};
extern VTBL_ENTRY _ZTI9S17045C47[];
extern  VTBL_ENTRY _ZTV9S17045C47[];
Class_Descriptor cd_S17045C47 = {  "S17045C47", // class name
  bases_S17045C47, 1,
  &(vtc_S17045C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI9S17045C47),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17045C47),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C4  {
  virtual  ~S17045C4(); // _ZN8S17045C4D1Ev
  virtual void  v8(); // _ZN8S17045C42v8Ev
  virtual void  v9(); // _ZN8S17045C42v9Ev
  virtual void  v10(); // _ZN8S17045C43v10Ev
  virtual void  v11(); // _ZN8S17045C43v11Ev
  virtual void  v12(); // _ZN8S17045C43v12Ev
  S17045C4(); // tgen
};
//SIG(-1 S17045C4) C1{ vd v1 v2 v3 v4 v5}


 S17045C4 ::~S17045C4(){ note_dtor("S17045C4", this);}
void  S17045C4 ::v8(){vfunc_called(this, "_ZN8S17045C42v8Ev");}
void  S17045C4 ::v9(){vfunc_called(this, "_ZN8S17045C42v9Ev");}
void  S17045C4 ::v10(){vfunc_called(this, "_ZN8S17045C43v10Ev");}
void  S17045C4 ::v11(){vfunc_called(this, "_ZN8S17045C43v11Ev");}
void  S17045C4 ::v12(){vfunc_called(this, "_ZN8S17045C43v12Ev");}
S17045C4 ::S17045C4(){ note_ctor("S17045C4", this);} // tgen

static void Test_S17045C4()
{
  extern Class_Descriptor cd_S17045C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S17045C4, buf);
    S17045C4 *dp, &lv = *(dp=new (buf) S17045C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S17045C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C4)");
    test_class_info(&lv, &cd_S17045C4);
    dp->~S17045C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C4(Test_S17045C4, "S17045C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S17045C4C1Ev();
extern void _ZN8S17045C4D1Ev();
Name_Map name_map_S17045C4[] = {
  NSPAIR(_ZN8S17045C4C1Ev),
  NSPAIR(_ZN8S17045C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S17045C4[];
extern void _ZN8S17045C4D1Ev();
extern void _ZN8S17045C4D0Ev();
extern void _ZN8S17045C42v8Ev();
extern void _ZN8S17045C42v9Ev();
extern void _ZN8S17045C43v10Ev();
extern void _ZN8S17045C43v11Ev();
extern void _ZN8S17045C43v12Ev();
static  VTBL_ENTRY vtc_S17045C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S17045C4[0]),
  (VTBL_ENTRY)&_ZN8S17045C4D1Ev,
  (VTBL_ENTRY)&_ZN8S17045C4D0Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S17045C4[];
extern  VTBL_ENTRY _ZTV8S17045C4[];
Class_Descriptor cd_S17045C4 = {  "S17045C4", // class name
  0,0,//no base classes
  &(vtc_S17045C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S17045C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S17045C4),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C72  : S17045C4 {
  ::S17044C5 s17045c72f0;
  ::S17044C5 s17045c72f1;
  ::S17044C73 s17045c72f2;
  ::S17044C73 s17045c72f3;
  ::S17044C73 s17045c72f4;
  void *s17045c72f5;
  char s17045c72f6;
  char s17045c72f7;
  char s17045c72f8;
  char s17045c72f9;
  char s17045c72f10;
  int s17045c72f11;
  virtual  ~S17045C72(); // _ZN9S17045C72D1Ev
  virtual void  v55(); // _ZN9S17045C723v55Ev
  virtual void  v56(); // _ZN9S17045C723v56Ev
  virtual void  v57(); // _ZN9S17045C723v57Ev
  virtual void  v58(); // _ZN9S17045C723v58Ev
  virtual void  v59(); // _ZN9S17045C723v59Ev
  virtual void  v60(); // _ZN9S17045C723v60Ev
  virtual void  v61(); // _ZN9S17045C723v61Ev
  virtual void  v62(); // _ZN9S17045C723v62Ev
  virtual void  v63(); // _ZN9S17045C723v63Ev
  virtual void  v64(); // _ZN9S17045C723v64Ev
  virtual void  v65(); // _ZN9S17045C723v65Ev
  virtual void  v66(); // _ZN9S17045C723v66Ev
  virtual void  v67(); // _ZN9S17045C723v67Ev
  virtual void  v68(); // _ZN9S17045C723v68Ev
  virtual void  v69(); // _ZN9S17045C723v69Ev
  S17045C72(); // tgen
};
//SIG(-1 S17045C72) C1{ BC2{ vd v16 v17 v18 v19 v20} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC3{ BC4{ BC5{} FC6{ BC7{}}} Fp[3]} FC3 FC8{ BC9{ BC10{ BC5} FC11{ BC12{}}} FU13{ Fc[16] Fp} Fi Fi} FC8 FC8 Fp Fc Fc Fc Fc Fc Fi}


 S17045C72 ::~S17045C72(){ note_dtor("S17045C72", this);}
void  S17045C72 ::v55(){vfunc_called(this, "_ZN9S17045C723v55Ev");}
void  S17045C72 ::v56(){vfunc_called(this, "_ZN9S17045C723v56Ev");}
void  S17045C72 ::v57(){vfunc_called(this, "_ZN9S17045C723v57Ev");}
void  S17045C72 ::v58(){vfunc_called(this, "_ZN9S17045C723v58Ev");}
void  S17045C72 ::v59(){vfunc_called(this, "_ZN9S17045C723v59Ev");}
void  S17045C72 ::v60(){vfunc_called(this, "_ZN9S17045C723v60Ev");}
void  S17045C72 ::v61(){vfunc_called(this, "_ZN9S17045C723v61Ev");}
void  S17045C72 ::v62(){vfunc_called(this, "_ZN9S17045C723v62Ev");}
void  S17045C72 ::v63(){vfunc_called(this, "_ZN9S17045C723v63Ev");}
void  S17045C72 ::v64(){vfunc_called(this, "_ZN9S17045C723v64Ev");}
void  S17045C72 ::v65(){vfunc_called(this, "_ZN9S17045C723v65Ev");}
void  S17045C72 ::v66(){vfunc_called(this, "_ZN9S17045C723v66Ev");}
void  S17045C72 ::v67(){vfunc_called(this, "_ZN9S17045C723v67Ev");}
void  S17045C72 ::v68(){vfunc_called(this, "_ZN9S17045C723v68Ev");}
void  S17045C72 ::v69(){vfunc_called(this, "_ZN9S17045C723v69Ev");}
S17045C72 ::S17045C72(){ note_ctor("S17045C72", this);} // tgen

static void Test_S17045C72()
{
  extern Class_Descriptor cd_S17045C72;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17045C72, buf);
    S17045C72 *dp, &lv = *(dp=new (buf) S17045C72());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17045C72)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C72)");
    check_base_class_offset(lv, (S17045C4*), 0, "S17045C72");
    check_field_offset(lv, s17045c72f0, ABISELECT(8,4), "S17045C72.s17045c72f0");
    check_field_offset(lv, s17045c72f1, ABISELECT(40,20), "S17045C72.s17045c72f1");
    check_field_offset(lv, s17045c72f2, ABISELECT(72,36), "S17045C72.s17045c72f2");
    check_field_offset(lv, s17045c72f3, ABISELECT(104,64), "S17045C72.s17045c72f3");
    check_field_offset(lv, s17045c72f4, ABISELECT(136,92), "S17045C72.s17045c72f4");
    check_field_offset(lv, s17045c72f5, ABISELECT(168,120), "S17045C72.s17045c72f5");
    check_field_offset(lv, s17045c72f6, ABISELECT(176,124), "S17045C72.s17045c72f6");
    check_field_offset(lv, s17045c72f7, ABISELECT(177,125), "S17045C72.s17045c72f7");
    check_field_offset(lv, s17045c72f8, ABISELECT(178,126), "S17045C72.s17045c72f8");
    check_field_offset(lv, s17045c72f9, ABISELECT(179,127), "S17045C72.s17045c72f9");
    check_field_offset(lv, s17045c72f10, ABISELECT(180,128), "S17045C72.s17045c72f10");
    check_field_offset(lv, s17045c72f11, ABISELECT(184,132), "S17045C72.s17045c72f11");
    test_class_info(&lv, &cd_S17045C72);
    dp->~S17045C72();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C72(Test_S17045C72, "S17045C72", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN9S17045C72C1Ev();
extern void _ZN9S17045C72D1Ev();
Name_Map name_map_S17045C72[] = {
  NSPAIR(_ZN9S17045C72C1Ev),
  NSPAIR(_ZN9S17045C72D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17045C4;
extern VTBL_ENTRY _ZTI8S17045C4[];
extern  VTBL_ENTRY _ZTV8S17045C4[];
static Base_Class bases_S17045C72[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17045C72[];
extern void _ZN9S17045C72D1Ev();
extern void _ZN9S17045C72D0Ev();
extern void _ZN8S17045C42v8Ev();
extern void _ZN8S17045C42v9Ev();
extern void _ZN8S17045C43v10Ev();
extern void _ZN8S17045C43v11Ev();
extern void _ZN8S17045C43v12Ev();
extern void _ZN9S17045C723v55Ev();
extern void _ZN9S17045C723v56Ev();
extern void _ZN9S17045C723v57Ev();
extern void _ZN9S17045C723v58Ev();
extern void _ZN9S17045C723v59Ev();
extern void _ZN9S17045C723v60Ev();
extern void _ZN9S17045C723v61Ev();
extern void _ZN9S17045C723v62Ev();
extern void _ZN9S17045C723v63Ev();
extern void _ZN9S17045C723v64Ev();
extern void _ZN9S17045C723v65Ev();
extern void _ZN9S17045C723v66Ev();
extern void _ZN9S17045C723v67Ev();
extern void _ZN9S17045C723v68Ev();
extern void _ZN9S17045C723v69Ev();
static  VTBL_ENTRY vtc_S17045C72[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17045C72[0]),
  (VTBL_ENTRY)&_ZN9S17045C72D1Ev,
  (VTBL_ENTRY)&_ZN9S17045C72D0Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v69Ev,
};
extern VTBL_ENTRY _ZTI9S17045C72[];
extern  VTBL_ENTRY _ZTV9S17045C72[];
Class_Descriptor cd_S17045C72 = {  "S17045C72", // class name
  bases_S17045C72, 1,
  &(vtc_S17045C72[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI9S17045C72),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17045C72),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C80  : S17045C72 {
  int s17045c80f0;
  virtual void  v74(); // _ZN9S17045C803v74Ev
  virtual void  v75(); // _ZN9S17045C803v75Ev
  virtual void  v76(); // _ZN9S17045C803v76Ev
  virtual void  v77(); // _ZN9S17045C803v77Ev
  ~S17045C80(); // tgen
  S17045C80(); // tgen
};
//SIG(-1 S17045C80) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4 Fi}


void  S17045C80 ::v74(){vfunc_called(this, "_ZN9S17045C803v74Ev");}
void  S17045C80 ::v75(){vfunc_called(this, "_ZN9S17045C803v75Ev");}
void  S17045C80 ::v76(){vfunc_called(this, "_ZN9S17045C803v76Ev");}
void  S17045C80 ::v77(){vfunc_called(this, "_ZN9S17045C803v77Ev");}
S17045C80 ::~S17045C80(){ note_dtor("S17045C80", this);} // tgen
S17045C80 ::S17045C80(){ note_ctor("S17045C80", this);} // tgen

static void Test_S17045C80()
{
  extern Class_Descriptor cd_S17045C80;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,36)];
    init_test(&cd_S17045C80, buf);
    S17045C80 *dp, &lv = *(dp=new (buf) S17045C80());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,140), "sizeof(S17045C80)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C80)");
    check_base_class_offset(lv, (S17045C4*)(S17045C72*), 0, "S17045C80");
    check_base_class_offset(lv, (S17045C72*), 0, "S17045C80");
    check_field_offset(lv, s17045c80f0, ABISELECT(188,136), "S17045C80.s17045c80f0");
    test_class_info(&lv, &cd_S17045C80);
    dp->~S17045C80();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C80(Test_S17045C80, "S17045C80", ABISELECT(192,140));

#else // __cplusplus

extern void _ZN9S17045C80C1Ev();
extern void _ZN9S17045C80D1Ev();
Name_Map name_map_S17045C80[] = {
  NSPAIR(_ZN9S17045C80C1Ev),
  NSPAIR(_ZN9S17045C80D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17045C4;
extern VTBL_ENTRY _ZTI8S17045C4[];
extern  VTBL_ENTRY _ZTV8S17045C4[];
extern Class_Descriptor cd_S17045C72;
extern VTBL_ENTRY _ZTI9S17045C72[];
extern  VTBL_ENTRY _ZTV9S17045C72[];
static Base_Class bases_S17045C80[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17045C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S17045C80[];
extern void _ZN9S17045C80D1Ev();
extern void _ZN9S17045C80D0Ev();
extern void _ZN8S17045C42v8Ev();
extern void _ZN8S17045C42v9Ev();
extern void _ZN8S17045C43v10Ev();
extern void _ZN8S17045C43v11Ev();
extern void _ZN8S17045C43v12Ev();
extern void _ZN9S17045C723v55Ev();
extern void _ZN9S17045C723v56Ev();
extern void _ZN9S17045C723v57Ev();
extern void _ZN9S17045C723v58Ev();
extern void _ZN9S17045C723v59Ev();
extern void _ZN9S17045C723v60Ev();
extern void _ZN9S17045C723v61Ev();
extern void _ZN9S17045C723v62Ev();
extern void _ZN9S17045C723v63Ev();
extern void _ZN9S17045C723v64Ev();
extern void _ZN9S17045C723v65Ev();
extern void _ZN9S17045C723v66Ev();
extern void _ZN9S17045C723v67Ev();
extern void _ZN9S17045C723v68Ev();
extern void _ZN9S17045C723v69Ev();
extern void _ZN9S17045C803v74Ev();
extern void _ZN9S17045C803v75Ev();
extern void _ZN9S17045C803v76Ev();
extern void _ZN9S17045C803v77Ev();
static  VTBL_ENTRY vtc_S17045C80[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S17045C80[0]),
  (VTBL_ENTRY)&_ZN9S17045C80D1Ev,
  (VTBL_ENTRY)&_ZN9S17045C80D0Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v69Ev,
  (VTBL_ENTRY)&_ZN9S17045C803v74Ev,
  (VTBL_ENTRY)&_ZN9S17045C803v75Ev,
  (VTBL_ENTRY)&_ZN9S17045C803v76Ev,
  (VTBL_ENTRY)&_ZN9S17045C803v77Ev,
};
extern VTBL_ENTRY _ZTI9S17045C80[];
extern  VTBL_ENTRY _ZTV9S17045C80[];
Class_Descriptor cd_S17045C80 = {  "S17045C80", // class name
  bases_S17045C80, 2,
  &(vtc_S17045C80[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,140), // object size
  NSPAIRA(_ZTI9S17045C80),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S17045C80),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C109  : S17045C72 {
  virtual void  v129(); // _ZN10S17045C1094v129Ev
  virtual void  v130(); // _ZN10S17045C1094v130Ev
  virtual void  v131(); // _ZN10S17045C1094v131Ev
  virtual void  v132(); // _ZN10S17045C1094v132Ev
  ~S17045C109(); // tgen
  S17045C109(); // tgen
};
//SIG(-1 S17045C109) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2 v3 v4}


void  S17045C109 ::v129(){vfunc_called(this, "_ZN10S17045C1094v129Ev");}
void  S17045C109 ::v130(){vfunc_called(this, "_ZN10S17045C1094v130Ev");}
void  S17045C109 ::v131(){vfunc_called(this, "_ZN10S17045C1094v131Ev");}
void  S17045C109 ::v132(){vfunc_called(this, "_ZN10S17045C1094v132Ev");}
S17045C109 ::~S17045C109(){ note_dtor("S17045C109", this);} // tgen
S17045C109 ::S17045C109(){ note_ctor("S17045C109", this);} // tgen

static void Test_S17045C109()
{
  extern Class_Descriptor cd_S17045C109;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17045C109, buf);
    S17045C109 *dp, &lv = *(dp=new (buf) S17045C109());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17045C109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C109)");
    check_base_class_offset(lv, (S17045C4*)(S17045C72*), 0, "S17045C109");
    check_base_class_offset(lv, (S17045C72*), 0, "S17045C109");
    test_class_info(&lv, &cd_S17045C109);
    dp->~S17045C109();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C109(Test_S17045C109, "S17045C109", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN10S17045C109C1Ev();
extern void _ZN10S17045C109D1Ev();
Name_Map name_map_S17045C109[] = {
  NSPAIR(_ZN10S17045C109C1Ev),
  NSPAIR(_ZN10S17045C109D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17045C4;
extern VTBL_ENTRY _ZTI8S17045C4[];
extern  VTBL_ENTRY _ZTV8S17045C4[];
extern Class_Descriptor cd_S17045C72;
extern VTBL_ENTRY _ZTI9S17045C72[];
extern  VTBL_ENTRY _ZTV9S17045C72[];
static Base_Class bases_S17045C109[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17045C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17045C109[];
extern void _ZN10S17045C109D1Ev();
extern void _ZN10S17045C109D0Ev();
extern void _ZN8S17045C42v8Ev();
extern void _ZN8S17045C42v9Ev();
extern void _ZN8S17045C43v10Ev();
extern void _ZN8S17045C43v11Ev();
extern void _ZN8S17045C43v12Ev();
extern void _ZN9S17045C723v55Ev();
extern void _ZN9S17045C723v56Ev();
extern void _ZN9S17045C723v57Ev();
extern void _ZN9S17045C723v58Ev();
extern void _ZN9S17045C723v59Ev();
extern void _ZN9S17045C723v60Ev();
extern void _ZN9S17045C723v61Ev();
extern void _ZN9S17045C723v62Ev();
extern void _ZN9S17045C723v63Ev();
extern void _ZN9S17045C723v64Ev();
extern void _ZN9S17045C723v65Ev();
extern void _ZN9S17045C723v66Ev();
extern void _ZN9S17045C723v67Ev();
extern void _ZN9S17045C723v68Ev();
extern void _ZN9S17045C723v69Ev();
extern void _ZN10S17045C1094v129Ev();
extern void _ZN10S17045C1094v130Ev();
extern void _ZN10S17045C1094v131Ev();
extern void _ZN10S17045C1094v132Ev();
static  VTBL_ENTRY vtc_S17045C109[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17045C109[0]),
  (VTBL_ENTRY)&_ZN10S17045C109D1Ev,
  (VTBL_ENTRY)&_ZN10S17045C109D0Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17045C1094v129Ev,
  (VTBL_ENTRY)&_ZN10S17045C1094v130Ev,
  (VTBL_ENTRY)&_ZN10S17045C1094v131Ev,
  (VTBL_ENTRY)&_ZN10S17045C1094v132Ev,
};
extern VTBL_ENTRY _ZTI10S17045C109[];
extern  VTBL_ENTRY _ZTV10S17045C109[];
Class_Descriptor cd_S17045C109 = {  "S17045C109", // class name
  bases_S17045C109, 2,
  &(vtc_S17045C109[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI10S17045C109),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17045C109),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C110  : S17045C72 {
  virtual void  v133(); // _ZN10S17045C1104v133Ev
  virtual void  v134(); // _ZN10S17045C1104v134Ev
  ~S17045C110(); // tgen
  S17045C110(); // tgen
};
//SIG(-1 S17045C110) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 FC4{ BC5{ BC6{} FC7{ BC8{}}} Fp[3]} FC4 FC9{ BC10{ BC11{ BC6} FC12{ BC13{}}} FU14{ Fc[16] Fp} Fi Fi} FC9 FC9 Fp Fc Fc Fc Fc Fc Fi} v1 v2}


void  S17045C110 ::v133(){vfunc_called(this, "_ZN10S17045C1104v133Ev");}
void  S17045C110 ::v134(){vfunc_called(this, "_ZN10S17045C1104v134Ev");}
S17045C110 ::~S17045C110(){ note_dtor("S17045C110", this);} // tgen
S17045C110 ::S17045C110(){ note_ctor("S17045C110", this);} // tgen

static void Test_S17045C110()
{
  extern Class_Descriptor cd_S17045C110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S17045C110, buf);
    S17045C110 *dp, &lv = *(dp=new (buf) S17045C110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S17045C110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C110)");
    check_base_class_offset(lv, (S17045C4*)(S17045C72*), 0, "S17045C110");
    check_base_class_offset(lv, (S17045C72*), 0, "S17045C110");
    test_class_info(&lv, &cd_S17045C110);
    dp->~S17045C110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C110(Test_S17045C110, "S17045C110", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN10S17045C110C1Ev();
extern void _ZN10S17045C110D1Ev();
Name_Map name_map_S17045C110[] = {
  NSPAIR(_ZN10S17045C110C1Ev),
  NSPAIR(_ZN10S17045C110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17045C4;
extern VTBL_ENTRY _ZTI8S17045C4[];
extern  VTBL_ENTRY _ZTV8S17045C4[];
extern Class_Descriptor cd_S17045C72;
extern VTBL_ENTRY _ZTI9S17045C72[];
extern  VTBL_ENTRY _ZTV9S17045C72[];
static Base_Class bases_S17045C110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S17045C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17045C110[];
extern void _ZN10S17045C110D1Ev();
extern void _ZN10S17045C110D0Ev();
extern void _ZN8S17045C42v8Ev();
extern void _ZN8S17045C42v9Ev();
extern void _ZN8S17045C43v10Ev();
extern void _ZN8S17045C43v11Ev();
extern void _ZN8S17045C43v12Ev();
extern void _ZN9S17045C723v55Ev();
extern void _ZN9S17045C723v56Ev();
extern void _ZN9S17045C723v57Ev();
extern void _ZN9S17045C723v58Ev();
extern void _ZN9S17045C723v59Ev();
extern void _ZN9S17045C723v60Ev();
extern void _ZN9S17045C723v61Ev();
extern void _ZN9S17045C723v62Ev();
extern void _ZN9S17045C723v63Ev();
extern void _ZN9S17045C723v64Ev();
extern void _ZN9S17045C723v65Ev();
extern void _ZN9S17045C723v66Ev();
extern void _ZN9S17045C723v67Ev();
extern void _ZN9S17045C723v68Ev();
extern void _ZN9S17045C723v69Ev();
extern void _ZN10S17045C1104v133Ev();
extern void _ZN10S17045C1104v134Ev();
static  VTBL_ENTRY vtc_S17045C110[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17045C110[0]),
  (VTBL_ENTRY)&_ZN10S17045C110D1Ev,
  (VTBL_ENTRY)&_ZN10S17045C110D0Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v12Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v55Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v56Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v57Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v58Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v59Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v60Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v61Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v62Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v63Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v64Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v65Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v66Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v67Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v68Ev,
  (VTBL_ENTRY)&_ZN9S17045C723v69Ev,
  (VTBL_ENTRY)&_ZN10S17045C1104v133Ev,
  (VTBL_ENTRY)&_ZN10S17045C1104v134Ev,
};
extern VTBL_ENTRY _ZTI10S17045C110[];
extern  VTBL_ENTRY _ZTV10S17045C110[];
Class_Descriptor cd_S17045C110 = {  "S17045C110", // class name
  bases_S17045C110, 2,
  &(vtc_S17045C110[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI10S17045C110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17045C110),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C128  {
  int s17045c128f0;
  void *s17045c128f1;
  int s17045c128f2[34];
  void  mf17045c128(); // _ZN10S17045C12811mf17045c128Ev
};
//SIG(-1 S17045C128) C1{ m Fi Fp Fi[34]}


void  S17045C128 ::mf17045c128(){}

static void Test_S17045C128()
{
  {
    init_simple_test("S17045C128");
    S17045C128 lv;
    check2(sizeof(lv), ABISELECT(152,144), "sizeof(S17045C128)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C128)");
    check_field_offset(lv, s17045c128f0, 0, "S17045C128.s17045c128f0");
    check_field_offset(lv, s17045c128f1, ABISELECT(8,4), "S17045C128.s17045c128f1");
    check_field_offset(lv, s17045c128f2, ABISELECT(16,8), "S17045C128.s17045c128f2");
  }
}
static Arrange_To_Call_Me vS17045C128(Test_S17045C128, "S17045C128", ABISELECT(152,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C127  {
  ::S17045C128 s17045c127f0;
  void  mf17045c127(); // _ZN10S17045C12711mf17045c127Ev
};
//SIG(-1 S17045C127) C1{ m FC2{ m Fi Fp Fi[34]}}


void  S17045C127 ::mf17045c127(){}

static void Test_S17045C127()
{
  {
    init_simple_test("S17045C127");
    S17045C127 lv;
    check2(sizeof(lv), ABISELECT(152,144), "sizeof(S17045C127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C127)");
    check_field_offset(lv, s17045c127f0, 0, "S17045C127.s17045c127f0");
  }
}
static Arrange_To_Call_Me vS17045C127(Test_S17045C127, "S17045C127", ABISELECT(152,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C112  : S17045C4 , S17045C48 {
  int s17045c112f0;
  int s17045c112f1;
  ::S17044C52_nt s17045c112f2;
  ::S17044C158 s17045c112f3;
  ::S17044C73 s17045c112f4;
  ::S17044C150 s17045c112f5;
  int s17045c112f6;
  int s17045c112f7;
  char s17045c112f8;
  char s17045c112f9;
  char s17045c112f10;
  int s17045c112f11;
  int s17045c112f12;
  int s17045c112f13;
  int s17045c112f14;
  int s17045c112f15;
  ::S17044C73 s17045c112f16;
  ::S17044C73 s17045c112f17;
  ::S17044C73 s17045c112f18;
  ::S17044C73 s17045c112f19;
  ::S17044C121 s17045c112f20;
  ::S17044C121 s17045c112f21;
  ::S17044C121 s17045c112f22;
  ::S17044C121 s17045c112f23;
  ::S17044C123_nt s17045c112f24;
  char s17045c112f25;
  ::S17044C124 s17045c112f26;
  char s17045c112f27;
  int s17045c112f28;
  int s17045c112f29;
  char s17045c112f30;
  char s17045c112f31;
  char s17045c112f32;
  char s17045c112f33;
  ::S17045C127 s17045c112f34;
  ::S17045C127 s17045c112f35;
  ::S17045C127 s17045c112f36;
  ::S17045C127 s17045c112f37;
  ::S17044C129 s17045c112f38;
  ::S17044C130 s17045c112f39;
  int s17045c112f40;
  ::S17044C73 s17045c112f41;
  char s17045c112f42;
  char s17045c112f43;
  ::S17044C123_nt s17045c112f44;
  char s17045c112f45;
  char s17045c112f46;
  char s17045c112f47;
  virtual  ~S17045C112(); // _ZN10S17045C112D1Ev
  virtual void  v139(); // _ZN10S17045C1124v139Ev
  virtual void  v140(); // _ZN10S17045C1124v140Ev
  virtual void  v141(); // _ZN10S17045C1124v141Ev
  virtual void  v142(); // _ZN10S17045C1124v142Ev
  virtual void  v143(); // _ZN10S17045C1124v143Ev
  virtual void  v144(); // _ZN10S17045C1124v144Ev
  S17045C112(); // tgen
};
//SIG(-1 S17045C112) C1{ BC2{ vd v7 v8 v9 v10 v11} BC3{ vd v12 v13 v14 Fp} vd v1 v2 v3 v4 v5 v6 Fi[2] FC4{ m Fi[2]} FC5{ BC6{ BC7{} FC8{ BC9{}}} Fp[3]} FC10{ BC11{ BC12{ BC7} FC13{ BC14{}}} FU15{ Fc[16] Fp} Fi Fi} FC16{ BC17{ BC7 FC18{ BC19{}}} Fp Fp Fp} Fi Fi Fc Fc Fc Fi Fi Fi Fi Fi FC10 FC10 FC10 FC10 FC20{ BC21{ m Fp}} FC20 FC20 FC20 FC22{ m FL} Fc FC23{ BC24{ m FC25{ m Fc Fc[15]} FC25 FC25 FC25}} Fc Fi Fi Fc Fc Fc Fc FC26{ m FC27{ m Fi Fp Fi[34]}} FC26 FC26 FC26 FC28{ m FC29{ BC30{ BC7 FC31{ BC32{}}} Fp Fp Fp} FC33{ BC34{ BC35{ BC36{ BC7 FC37{ BC38{}}} FC37} FC18} Fp Fp Fi} Fi Fi} FC29 Fi FC10 Fc Fc FC22 Fc Fc Fc}


 S17045C112 ::~S17045C112(){ note_dtor("S17045C112", this);}
void  S17045C112 ::v139(){vfunc_called(this, "_ZN10S17045C1124v139Ev");}
void  S17045C112 ::v140(){vfunc_called(this, "_ZN10S17045C1124v140Ev");}
void  S17045C112 ::v141(){vfunc_called(this, "_ZN10S17045C1124v141Ev");}
void  S17045C112 ::v142(){vfunc_called(this, "_ZN10S17045C1124v142Ev");}
void  S17045C112 ::v143(){vfunc_called(this, "_ZN10S17045C1124v143Ev");}
void  S17045C112 ::v144(){vfunc_called(this, "_ZN10S17045C1124v144Ev");}
S17045C112 ::S17045C112(){ note_ctor("S17045C112", this);} // tgen

static void Test_S17045C112()
{
  extern Class_Descriptor cd_S17045C112;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(150,255)];
    init_test(&cd_S17045C112, buf);
    S17045C112 *dp, &lv = *(dp=new (buf) S17045C112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1192,1016), "sizeof(S17045C112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C112)");
    check_base_class_offset(lv, (S17045C4*), 0, "S17045C112");
    check_base_class_offset(lv, (S17045C48*), ABISELECT(8,4), "S17045C112");
    check_field_offset(lv, s17045c112f0, ABISELECT(24,12), "S17045C112.s17045c112f0");
    check_field_offset(lv, s17045c112f1, ABISELECT(28,16), "S17045C112.s17045c112f1");
    check_field_offset(lv, s17045c112f2, ABISELECT(32,20), "S17045C112.s17045c112f2");
    check_field_offset(lv, s17045c112f3, ABISELECT(40,28), "S17045C112.s17045c112f3");
    check_field_offset(lv, s17045c112f4, ABISELECT(72,44), "S17045C112.s17045c112f4");
    check_field_offset(lv, s17045c112f5, ABISELECT(104,72), "S17045C112.s17045c112f5");
    check_field_offset(lv, s17045c112f6, ABISELECT(136,88), "S17045C112.s17045c112f6");
    check_field_offset(lv, s17045c112f7, ABISELECT(140,92), "S17045C112.s17045c112f7");
    check_field_offset(lv, s17045c112f8, ABISELECT(144,96), "S17045C112.s17045c112f8");
    check_field_offset(lv, s17045c112f9, ABISELECT(145,97), "S17045C112.s17045c112f9");
    check_field_offset(lv, s17045c112f10, ABISELECT(146,98), "S17045C112.s17045c112f10");
    check_field_offset(lv, s17045c112f11, ABISELECT(148,100), "S17045C112.s17045c112f11");
    check_field_offset(lv, s17045c112f12, ABISELECT(152,104), "S17045C112.s17045c112f12");
    check_field_offset(lv, s17045c112f13, ABISELECT(156,108), "S17045C112.s17045c112f13");
    check_field_offset(lv, s17045c112f14, ABISELECT(160,112), "S17045C112.s17045c112f14");
    check_field_offset(lv, s17045c112f15, ABISELECT(164,116), "S17045C112.s17045c112f15");
    check_field_offset(lv, s17045c112f16, ABISELECT(168,120), "S17045C112.s17045c112f16");
    check_field_offset(lv, s17045c112f17, ABISELECT(200,148), "S17045C112.s17045c112f17");
    check_field_offset(lv, s17045c112f18, ABISELECT(232,176), "S17045C112.s17045c112f18");
    check_field_offset(lv, s17045c112f19, ABISELECT(264,204), "S17045C112.s17045c112f19");
    check_field_offset(lv, s17045c112f20, ABISELECT(296,232), "S17045C112.s17045c112f20");
    check_field_offset(lv, s17045c112f21, ABISELECT(304,236), "S17045C112.s17045c112f21");
    check_field_offset(lv, s17045c112f22, ABISELECT(312,240), "S17045C112.s17045c112f22");
    check_field_offset(lv, s17045c112f23, ABISELECT(320,244), "S17045C112.s17045c112f23");
    check_field_offset(lv, s17045c112f24, ABISELECT(328,248), "S17045C112.s17045c112f24");
    check_field_offset(lv, s17045c112f25, ABISELECT(336,256), "S17045C112.s17045c112f25");
    check_field_offset(lv, s17045c112f26, ABISELECT(337,257), "S17045C112.s17045c112f26");
    check_field_offset(lv, s17045c112f27, ABISELECT(401,321), "S17045C112.s17045c112f27");
    check_field_offset(lv, s17045c112f28, ABISELECT(404,324), "S17045C112.s17045c112f28");
    check_field_offset(lv, s17045c112f29, ABISELECT(408,328), "S17045C112.s17045c112f29");
    check_field_offset(lv, s17045c112f30, ABISELECT(412,332), "S17045C112.s17045c112f30");
    check_field_offset(lv, s17045c112f31, ABISELECT(413,333), "S17045C112.s17045c112f31");
    check_field_offset(lv, s17045c112f32, ABISELECT(414,334), "S17045C112.s17045c112f32");
    check_field_offset(lv, s17045c112f33, ABISELECT(415,335), "S17045C112.s17045c112f33");
    check_field_offset(lv, s17045c112f34, ABISELECT(416,336), "S17045C112.s17045c112f34");
    check_field_offset(lv, s17045c112f35, ABISELECT(568,480), "S17045C112.s17045c112f35");
    check_field_offset(lv, s17045c112f36, ABISELECT(720,624), "S17045C112.s17045c112f36");
    check_field_offset(lv, s17045c112f37, ABISELECT(872,768), "S17045C112.s17045c112f37");
    check_field_offset(lv, s17045c112f38, ABISELECT(1024,912), "S17045C112.s17045c112f38");
    check_field_offset(lv, s17045c112f39, ABISELECT(1096,952), "S17045C112.s17045c112f39");
    check_field_offset(lv, s17045c112f40, ABISELECT(1128,968), "S17045C112.s17045c112f40");
    check_field_offset(lv, s17045c112f41, ABISELECT(1136,972), "S17045C112.s17045c112f41");
    check_field_offset(lv, s17045c112f42, ABISELECT(1168,1000), "S17045C112.s17045c112f42");
    check_field_offset(lv, s17045c112f43, ABISELECT(1169,1001), "S17045C112.s17045c112f43");
    check_field_offset(lv, s17045c112f44, ABISELECT(1176,1004), "S17045C112.s17045c112f44");
    check_field_offset(lv, s17045c112f45, ABISELECT(1184,1012), "S17045C112.s17045c112f45");
    check_field_offset(lv, s17045c112f46, ABISELECT(1185,1013), "S17045C112.s17045c112f46");
    check_field_offset(lv, s17045c112f47, ABISELECT(1186,1014), "S17045C112.s17045c112f47");
    test_class_info(&lv, &cd_S17045C112);
    dp->~S17045C112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C112(Test_S17045C112, "S17045C112", ABISELECT(1192,1016));

#else // __cplusplus

extern void _ZN10S17045C112C1Ev();
extern void _ZN10S17045C112D1Ev();
Name_Map name_map_S17045C112[] = {
  NSPAIR(_ZN10S17045C112C1Ev),
  NSPAIR(_ZN10S17045C112D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17045C4;
extern VTBL_ENTRY _ZTI8S17045C4[];
extern  VTBL_ENTRY _ZTV8S17045C4[];
extern Class_Descriptor cd_S17045C48;
extern VTBL_ENTRY _ZTI9S17045C48[];
extern  VTBL_ENTRY _ZTV9S17045C48[];
static Base_Class bases_S17045C112[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S17045C48,    ABISELECT(8,4), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17045C112[];
extern void _ZN10S17045C112D1Ev();
extern void _ZN10S17045C112D0Ev();
extern void _ZN8S17045C42v8Ev();
extern void _ZN8S17045C42v9Ev();
extern void _ZN8S17045C43v10Ev();
extern void _ZN8S17045C43v11Ev();
extern void _ZN8S17045C43v12Ev();
extern void _ZN10S17045C1124v139Ev();
extern void _ZN10S17045C1124v140Ev();
extern void _ZN10S17045C1124v141Ev();
extern void _ZN10S17045C1124v142Ev();
extern void _ZN10S17045C1124v143Ev();
extern void _ZN10S17045C1124v144Ev();
extern void ABISELECT(_ZThn8_N10S17045C112D1Ev,_ZThn4_N10S17045C112D1Ev)();
extern void ABISELECT(_ZThn8_N10S17045C112D0Ev,_ZThn4_N10S17045C112D0Ev)();
extern void _ZN9S17045C483v33Ev();
extern void _ZN9S17045C483v34Ev();
extern void _ZN9S17045C483v35Ev();
static  VTBL_ENTRY vtc_S17045C112[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17045C112[0]),
  (VTBL_ENTRY)&_ZN10S17045C112D1Ev,
  (VTBL_ENTRY)&_ZN10S17045C112D0Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17045C1124v139Ev,
  (VTBL_ENTRY)&_ZN10S17045C1124v140Ev,
  (VTBL_ENTRY)&_ZN10S17045C1124v141Ev,
  (VTBL_ENTRY)&_ZN10S17045C1124v142Ev,
  (VTBL_ENTRY)&_ZN10S17045C1124v143Ev,
  (VTBL_ENTRY)&_ZN10S17045C1124v144Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI10S17045C112[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S17045C112D1Ev,_ZThn4_N10S17045C112D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S17045C112D0Ev,_ZThn4_N10S17045C112D0Ev),
  (VTBL_ENTRY)&_ZN9S17045C483v33Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v34Ev,
  (VTBL_ENTRY)&_ZN9S17045C483v35Ev,
};
extern VTBL_ENTRY _ZTI10S17045C112[];
extern  VTBL_ENTRY _ZTV10S17045C112[];
Class_Descriptor cd_S17045C112 = {  "S17045C112", // class name
  bases_S17045C112, 2,
  &(vtc_S17045C112[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1192,1016), // object size
  NSPAIRA(_ZTI10S17045C112),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S17045C112),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C164  : S17045C4 {
  int s17045c164f0;
  int s17045c164f1;
  ::S17044C52_nt s17045c164f2;
  virtual void  v161(); // _ZN10S17045C1644v161Ev
  virtual void  v162(); // _ZN10S17045C1644v162Ev
  virtual void  v163(); // _ZN10S17045C1644v163Ev
  virtual void  v164(); // _ZN10S17045C1644v164Ev
  ~S17045C164(); // tgen
  S17045C164(); // tgen
};
//SIG(-1 S17045C164) C1{ BC2{ vd v5 v6 v7 v8 v9} v1 v2 v3 v4 Fi[2] FC3{ m Fi[2]}}


void  S17045C164 ::v161(){vfunc_called(this, "_ZN10S17045C1644v161Ev");}
void  S17045C164 ::v162(){vfunc_called(this, "_ZN10S17045C1644v162Ev");}
void  S17045C164 ::v163(){vfunc_called(this, "_ZN10S17045C1644v163Ev");}
void  S17045C164 ::v164(){vfunc_called(this, "_ZN10S17045C1644v164Ev");}
S17045C164 ::~S17045C164(){ note_dtor("S17045C164", this);} // tgen
S17045C164 ::S17045C164(){ note_ctor("S17045C164", this);} // tgen

static void Test_S17045C164()
{
  extern Class_Descriptor cd_S17045C164;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_S17045C164, buf);
    S17045C164 *dp, &lv = *(dp=new (buf) S17045C164());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S17045C164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C164)");
    check_base_class_offset(lv, (S17045C4*), 0, "S17045C164");
    check_field_offset(lv, s17045c164f0, ABISELECT(8,4), "S17045C164.s17045c164f0");
    check_field_offset(lv, s17045c164f1, ABISELECT(12,8), "S17045C164.s17045c164f1");
    check_field_offset(lv, s17045c164f2, ABISELECT(16,12), "S17045C164.s17045c164f2");
    test_class_info(&lv, &cd_S17045C164);
    dp->~S17045C164();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS17045C164(Test_S17045C164, "S17045C164", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN10S17045C164C1Ev();
extern void _ZN10S17045C164D1Ev();
Name_Map name_map_S17045C164[] = {
  NSPAIR(_ZN10S17045C164C1Ev),
  NSPAIR(_ZN10S17045C164D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S17045C4;
extern VTBL_ENTRY _ZTI8S17045C4[];
extern  VTBL_ENTRY _ZTV8S17045C4[];
static Base_Class bases_S17045C164[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S17045C164[];
extern void _ZN10S17045C164D1Ev();
extern void _ZN10S17045C164D0Ev();
extern void _ZN8S17045C42v8Ev();
extern void _ZN8S17045C42v9Ev();
extern void _ZN8S17045C43v10Ev();
extern void _ZN8S17045C43v11Ev();
extern void _ZN8S17045C43v12Ev();
extern void _ZN10S17045C1644v161Ev();
extern void _ZN10S17045C1644v162Ev();
extern void _ZN10S17045C1644v163Ev();
extern void _ZN10S17045C1644v164Ev();
static  VTBL_ENTRY vtc_S17045C164[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S17045C164[0]),
  (VTBL_ENTRY)&_ZN10S17045C164D1Ev,
  (VTBL_ENTRY)&_ZN10S17045C164D0Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v8Ev,
  (VTBL_ENTRY)&_ZN8S17045C42v9Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S17045C43v12Ev,
  (VTBL_ENTRY)&_ZN10S17045C1644v161Ev,
  (VTBL_ENTRY)&_ZN10S17045C1644v162Ev,
  (VTBL_ENTRY)&_ZN10S17045C1644v163Ev,
  (VTBL_ENTRY)&_ZN10S17045C1644v164Ev,
};
extern VTBL_ENTRY _ZTI10S17045C164[];
extern  VTBL_ENTRY _ZTV10S17045C164[];
Class_Descriptor cd_S17045C164 = {  "S17045C164", // class name
  bases_S17045C164, 1,
  &(vtc_S17045C164[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI10S17045C164),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S17045C164),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S17045C1  {
  int s17045c1f0[16];
  void *s17045c1f1;
  ::S17044C2 s17045c1f2;
  ::S17044C122 s17045c1f3;
  ::S17044C122 s17045c1f4;
  ::S17044C122 s17045c1f5;
  ::S17045C47 s17045c1f6;
  ::S17044C122 s17045c1f7;
  ::S17044C49 s17045c1f8;
  ::S17044C50 s17045c1f9;
  ::S17044C122 s17045c1f10;
  ::S17044C51 s17045c1f11;
  ::S17044C122 s17045c1f12;
  ::S17044C71 s17045c1f13;
  ::S17044C79 s17045c1f14;
  ::S17045C80 s17045c1f15;
  ::S17044C111 s17045c1f16;
  ::S17044C82 s17045c1f17;
  ::S17044C83 s17045c1f18;
  ::S17044C85 s17045c1f19;
  ::S17044C87 s17045c1f20;
  ::S17044C88 s17045c1f21;
  ::S17044C89 s17045c1f22;
  ::S17044C103 s17045c1f23;
  ::S17044C104 s17045c1f24;
  ::S17044C108 s17045c1f25;
  ::S17044C110 s17045c1f26;
  ::S17044C106 s17045c1f27;
  ::S17044C81 s17045c1f28;
  ::S17045C109 s17045c1f29;
  ::S17045C110 s17045c1f30;
  ::S17045C109 s17045c1f31;
  ::S17044C122 s17045c1f32;
  ::S17045C112 s17045c1f33;
  ::S17044C122 s17045c1f34;
  ::S17044C148 s17045c1f35;
  ::S17044C122 s17045c1f36;
  ::S17044C149 s17045c1f37;
  ::S17044C122 s17045c1f38;
  ::S17044C122 s17045c1f39;
  ::S17044C162 s17045c1f40;
  ::S17044C122 s17045c1f41;
  ::S17044C163 s17045c1f42;
  ::S17044C122 s17045c1f43;
  ::S17045C164 s17045c1f44;
  ::S17044C122 s17045c1f45;
  ::S17044C122 s17045c1f46;
  ::S17044C165 s17045c1f47;
  ::S17044C166 s17045c1f48;
  ::S17044C167 s17045c1f49;
  ::S17044C173 s17045c1f50;
  ::S17044C122 s17045c1f51;
  ::S17044C174 s17045c1f52;
  ::S17044C122 s17045c1f53;
  ::S17044C122 s17045c1f54;
  ::S17044C175 s17045c1f55;
  ::S17044C122 s17045c1f56;
  ::S17044C122 s17045c1f57;
  ::S17044C176 s17045c1f58;
  ::S17044C122 s17045c1f59;
  ::S17044C122 s17045c1f60;
  ::S17044C122 s17045c1f61;
  ::S17044C122 s17045c1f62;
  ::S17044C122 s17045c1f63;
  ::S17044C122 s17045c1f64;
  ::S17044C122 s17045c1f65;
  ::S17044C177 s17045c1f66;
  ::S17044C122 s17045c1f67;
  ::S17044C122 s17045c1f68;
  ::S17044C122 s17045c1f69;
  ::S17044C122 s17045c1f70;
  ::S17044C178 s17045c1f71;
  ::S17044C178 s17045c1f72;
  ::S17044C178 s17045c1f73;
  ::S17044C178 s17045c1f74;
  ::S17044C178 s17045c1f75;
  ::S17044C122 s17045c1f76;
  ::S17044C122 s17045c1f77;
  ::S17045C112 s17045c1f78;
  ::S17044C122 s17045c1f79;
  ::S17044C174 s17045c1f80;
  ::S17044C122 s17045c1f81;
  ::S17044C179 s17045c1f82;
  ::S17044C122 s17045c1f83;
  ::S17044C178 s17045c1f84;
  ::S17044C178 s17045c1f85;
  ::S17044C178 s17045c1f86;
  ::S17044C178 s17045c1f87;
  void  mf17045c1(); // _ZN8S17045C19mf17045c1Ev
};
//SIG(1 S17045C1) C1{ m Fi[16] Fp FC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fc FC5{ BC6{ BC7{} FC8{ BC9{}}} Fp[3]} FC5 Fi[6] Fc Fp FC10{ m Fp FC11{ BC12{ BC13{ BC14{ BC15{ BC16{ BC7 FC8} FC17{ BC18{}}} FC17} FC19{ BC20{}}} Fp Fi}} FC21{ m FC22{ BC23{ BC24{ BC25{ BC7 FC19} FC26{ BC27{}}} FC26} Fp Fi} FC22}} Fi} vd v1 v2 v3 v4 v5 v6 v7 Fc Fi Fc[2]} FC28{ m Fp} FC28 FC28 FC29{ BC30{ vd v33 v34 v35 Fp} vd v29 v30 v31 v32 Fp Fc Fi[2]} FC28 FC31{ BC32{ BC33{ vd v37 v38 v39 Fp} vd v40 v41 v42 v43 Fp Fc Fi[2]} vd v36} FC34{ BC3 vd v44 v45 v46 v47 v48 v49 v50 Fc Fi Fc} FC28 FC35{ BC4 vd v51 v52 v53 v54 Fi[2] FC36{ m Fi[2]} FC5 FC5 FC5 FC5 FC5 FC5 FC5 FC5 FC11 Fi[3] Fc[3] Fi Fc[512] Fi[3] Fc[2]} FC28 FC37{ BC38{ BC4 vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5 FC5 FC39{ BC40{ BC41{ BC7} FC42{ BC43{}}} FU44{ Fc[16] Fp} Fi Fi} FC39 FC39 Fp Fc Fc Fc Fc Fc Fi} vd v55 v56 v57 v58 v59 v60 v61} FC45{ BC38 v77 v78 v79 v80 Fi} FC46{ BC47{ BC48{ vd v85 v86 v87 v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 FC5 FC5 FC39 FC39 FC39 Fp Fc Fc Fc Fc Fc Fi} v81 v82 v83 v84 Fi} FC49{ BC38 v105 v106 v107 v108} FC50{ BC38 vd v109 v110 v111 v112 v113 Fp Fi} FC51{ BC38 v114 v115 v116 v117 v118 Fc FC52{ m Fc Fi Fc Fc[1024] Fi Fi Fp} FC52} FC53{ BC38 vd v119 v120 v121 v122 FC54{ m Fi Fc} FC52} FC55{ BC38 vd v123 v124 v125 v126 Fc} FC56{ BC38 vd v127 v128 v129 v130 FC54 FC52 FC39} FC57{ BC38 v131 v132 v133 v134 Fi Fi FC58{ m Fi Fi Fi Fc} FC58 FC59{ BC60{ BC61{ BC62{ BC63{ BC64{ BC7 FC8} FC42} FC65{ BC66{}}} FC65} Fp Fi}} Fi} FC67{ BC38 vd v135 v136 v137 v138 Fi Fi} FC68{ BC38 v139 v140 v141 v142 v143 Fc Fi Fc} FC69{ BC38 v144 v145 v146 v147} FC70{ BC38 v148 v149} FC71{ BC38 v150 v151} FC72{ BC38 v152 v153 v154 v155} FC73{ BC47 v156 v157 v158 v159} FC74{ BC47 v160 v161} FC73 FC28 FC75{ BC48 BC30 vd v162 v163 v164 v165 v166 v167 Fi Fi FC36 FC76{ BC77{ BC7 FC78{ BC79{}}} Fp Fp Fp} FC39 FC80{ BC81{ BC7 FC82{ BC83{}}} Fp Fp Fp} Fi Fi Fc Fc Fc Fi Fi Fi Fi Fi FC39 FC39 FC39 FC39 FC84{ BC28} FC84 FC84 FC84 FC85{ m FL} Fc FC86{ BC87{ m FC88{ m Fc Fc[15]} FC88 FC88 FC88}} Fc Fi Fi Fc Fc Fc Fc FC89{ m FC90{ m Fi Fp Fi[34]}} FC89 FC89 FC89 FC91{ m FC92{ BC93{ BC7 FC94{ BC95{}}} Fp Fp Fp} FC96{ BC97{ BC98{ BC99{ BC7 FC100{ BC101{}}} FC100} FC82} Fp Fp Fi} Fi Fi} FC92 Fi FC39 Fc Fc FC85 Fc Fc Fc} FC28 FC102{ BC4 v168 v169 v170 v171 Fi Fi FC36 FC5 Fi FC5 Fi Fc} FC28 FC103{ BC4 v172 v173 v174 v175 Fi Fi FC36 FC5 Fi Fi Fi Fc Fi Fi FC80 FC80 FC76 FC5 FC5 FC5 FC5} FC28 FC28 FC104{ BC4 v176 v177 v178 v179 Fi Fi FC36 Fc} FC28 FC105{ BC4 v180 v181 v182 v183 Fi Fi FC36} FC28 FC106{ BC48 v184 v185 v186 v187 Fi Fi FC36} FC28 FC28 FC107{ BC4 v188 v189 v190 v191 Fi Fi Fi Fi Fc Fc Fi} FC108{ BC4 v192 v193 v194 v195 Fi Fi Fc Fc Fi} FC109{ BC4 v196 v197 v198 v199 Fi Fc Fc Fi FC110{ BC111{ BC7 FC94} Fp Fp Fp} FC112{ BC113{ BC114{ BC115{ BC116{}}} Fp}}} FC117{ BC4 vd v200 v201 v202 v203 Fc Fi Fi FC36 FC5 FC5 FC5 FC5 FC5 Fi Fi Fi Fi Fc[256] Fc[256] Fi Fc Fc Fi FC76} FC28 FC118{ BC4 v204 v205 v206 v207 Fi Fi FC36 FC110 Fi Fc Fc Fi} FC28 FC28 FC119{ BC3 vd v208 v209 v210 v211 v212 v213 v214 v215 Fi} FC28 FC28 FC120{ BC3 vd v216 v217 v218 v219 v220 v221 Fi} FC28 FC28 FC28 FC28 FC28 FC28 FC28 FC121{ BC3 v222 v223 v224 v225 v226 v227} FC28 FC28 FC28 FC28 FC122{ BC4 v228 v229 v230 v231 Fp Fi} FC122 FC122 FC122 FC122 FC28 FC28 FC75 FC28 FC118 FC28 FC123{ BC33 vd v232 v233 v234 Fp Fc} FC28 FC122 FC122 FC122 FC122}


void  S17045C1 ::mf17045c1(){}

static void Test_S17045C1()
{
  {
    init_simple_test("S17045C1");
    S17045C1 lv;
    check2(sizeof(lv), ABISELECT(14528,11796), "sizeof(S17045C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S17045C1)");
    check_field_offset(lv, s17045c1f0, 0, "S17045C1.s17045c1f0");
    check_field_offset(lv, s17045c1f1, 64, "S17045C1.s17045c1f1");
    check_field_offset(lv, s17045c1f2, ABISELECT(72,68), "S17045C1.s17045c1f2");
    check_field_offset(lv, s17045c1f3, ABISELECT(288,196), "S17045C1.s17045c1f3");
    check_field_offset(lv, s17045c1f4, ABISELECT(296,200), "S17045C1.s17045c1f4");
    check_field_offset(lv, s17045c1f5, ABISELECT(304,204), "S17045C1.s17045c1f5");
    check_field_offset(lv, s17045c1f6, ABISELECT(312,208), "S17045C1.s17045c1f6");
    check_field_offset(lv, s17045c1f7, ABISELECT(352,232), "S17045C1.s17045c1f7");
    check_field_offset(lv, s17045c1f8, ABISELECT(360,236), "S17045C1.s17045c1f8");
    check_field_offset(lv, s17045c1f9, ABISELECT(400,260), "S17045C1.s17045c1f9");
    check_field_offset(lv, s17045c1f10, ABISELECT(616,388), "S17045C1.s17045c1f10");
    check_field_offset(lv, s17045c1f11, ABISELECT(624,392), "S17045C1.s17045c1f11");
    check_field_offset(lv, s17045c1f12, ABISELECT(1480,1100), "S17045C1.s17045c1f12");
    check_field_offset(lv, s17045c1f13, ABISELECT(1488,1104), "S17045C1.s17045c1f13");
    check_field_offset(lv, s17045c1f14, ABISELECT(1680,1240), "S17045C1.s17045c1f14");
    check_field_offset(lv, s17045c1f15, ABISELECT(1872,1380), "S17045C1.s17045c1f15");
    check_field_offset(lv, s17045c1f16, ABISELECT(2064,1520), "S17045C1.s17045c1f16");
    check_field_offset(lv, s17045c1f17, ABISELECT(2256,1656), "S17045C1.s17045c1f17");
    check_field_offset(lv, s17045c1f18, ABISELECT(2464,1800), "S17045C1.s17045c1f18");
    check_field_offset(lv, s17045c1f19, ABISELECT(4768,4036), "S17045C1.s17045c1f19");
    check_field_offset(lv, s17045c1f20, ABISELECT(6024,5228), "S17045C1.s17045c1f20");
    check_field_offset(lv, s17045c1f21, ABISELECT(6216,5368), "S17045C1.s17045c1f21");
    check_field_offset(lv, s17045c1f22, ABISELECT(7504,6588), "S17045C1.s17045c1f22");
    check_field_offset(lv, s17045c1f23, ABISELECT(7768,6780), "S17045C1.s17045c1f23");
    check_field_offset(lv, s17045c1f24, ABISELECT(7968,6924), "S17045C1.s17045c1f24");
    check_field_offset(lv, s17045c1f25, ABISELECT(8168,7072), "S17045C1.s17045c1f25");
    check_field_offset(lv, s17045c1f26, ABISELECT(8360,7208), "S17045C1.s17045c1f26");
    check_field_offset(lv, s17045c1f27, ABISELECT(8552,7344), "S17045C1.s17045c1f27");
    check_field_offset(lv, s17045c1f28, ABISELECT(8744,7480), "S17045C1.s17045c1f28");
    check_field_offset(lv, s17045c1f29, ABISELECT(8936,7616), "S17045C1.s17045c1f29");
    check_field_offset(lv, s17045c1f30, ABISELECT(9128,7752), "S17045C1.s17045c1f30");
    check_field_offset(lv, s17045c1f31, ABISELECT(9320,7888), "S17045C1.s17045c1f31");
    check_field_offset(lv, s17045c1f32, ABISELECT(9512,8024), "S17045C1.s17045c1f32");
    check_field_offset(lv, s17045c1f33, ABISELECT(9520,8028), "S17045C1.s17045c1f33");
    check_field_offset(lv, s17045c1f34, ABISELECT(10712,9044), "S17045C1.s17045c1f34");
    check_field_offset(lv, s17045c1f35, ABISELECT(10720,9048), "S17045C1.s17045c1f35");
    check_field_offset(lv, s17045c1f36, ABISELECT(10824,9112), "S17045C1.s17045c1f36");
    check_field_offset(lv, s17045c1f37, ABISELECT(10832,9116), "S17045C1.s17045c1f37");
    check_field_offset(lv, s17045c1f38, ABISELECT(11136,9288), "S17045C1.s17045c1f38");
    check_field_offset(lv, s17045c1f39, ABISELECT(11144,9292), "S17045C1.s17045c1f39");
    check_field_offset(lv, s17045c1f40, ABISELECT(11152,9296), "S17045C1.s17045c1f40");
    check_field_offset(lv, s17045c1f41, ABISELECT(11184,9320), "S17045C1.s17045c1f41");
    check_field_offset(lv, s17045c1f42, ABISELECT(11192,9324), "S17045C1.s17045c1f42");
    check_field_offset(lv, s17045c1f43, ABISELECT(11216,9344), "S17045C1.s17045c1f43");
    check_field_offset(lv, s17045c1f44, ABISELECT(11224,9348), "S17045C1.s17045c1f44");
    check_field_offset(lv, s17045c1f45, ABISELECT(11248,9368), "S17045C1.s17045c1f45");
    check_field_offset(lv, s17045c1f46, ABISELECT(11256,9372), "S17045C1.s17045c1f46");
    check_field_offset(lv, s17045c1f47, ABISELECT(11264,9376), "S17045C1.s17045c1f47");
    check_field_offset(lv, s17045c1f48, ABISELECT(11296,9404), "S17045C1.s17045c1f48");
    check_field_offset(lv, s17045c1f49, ABISELECT(11320,9424), "S17045C1.s17045c1f49");
    check_field_offset(lv, s17045c1f50, ABISELECT(11384,9460), "S17045C1.s17045c1f50");
    check_field_offset(lv, s17045c1f51, ABISELECT(12152,10120), "S17045C1.s17045c1f51");
    check_field_offset(lv, s17045c1f52, ABISELECT(12160,10124), "S17045C1.s17045c1f52");
    check_field_offset(lv, s17045c1f53, ABISELECT(12232,10172), "S17045C1.s17045c1f53");
    check_field_offset(lv, s17045c1f54, ABISELECT(12240,10176), "S17045C1.s17045c1f54");
    check_field_offset(lv, s17045c1f55, ABISELECT(12248,10180), "S17045C1.s17045c1f55");
    check_field_offset(lv, s17045c1f56, ABISELECT(12456,10300), "S17045C1.s17045c1f56");
    check_field_offset(lv, s17045c1f57, ABISELECT(12464,10304), "S17045C1.s17045c1f57");
    check_field_offset(lv, s17045c1f58, ABISELECT(12472,10308), "S17045C1.s17045c1f58");
    check_field_offset(lv, s17045c1f59, ABISELECT(12680,10428), "S17045C1.s17045c1f59");
    check_field_offset(lv, s17045c1f60, ABISELECT(12688,10432), "S17045C1.s17045c1f60");
    check_field_offset(lv, s17045c1f61, ABISELECT(12696,10436), "S17045C1.s17045c1f61");
    check_field_offset(lv, s17045c1f62, ABISELECT(12704,10440), "S17045C1.s17045c1f62");
    check_field_offset(lv, s17045c1f63, ABISELECT(12712,10444), "S17045C1.s17045c1f63");
    check_field_offset(lv, s17045c1f64, ABISELECT(12720,10448), "S17045C1.s17045c1f64");
    check_field_offset(lv, s17045c1f65, ABISELECT(12728,10452), "S17045C1.s17045c1f65");
    check_field_offset(lv, s17045c1f66, ABISELECT(12736,10456), "S17045C1.s17045c1f66");
    check_field_offset(lv, s17045c1f67, ABISELECT(12944,10572), "S17045C1.s17045c1f67");
    check_field_offset(lv, s17045c1f68, ABISELECT(12952,10576), "S17045C1.s17045c1f68");
    check_field_offset(lv, s17045c1f69, ABISELECT(12960,10580), "S17045C1.s17045c1f69");
    check_field_offset(lv, s17045c1f70, ABISELECT(12968,10584), "S17045C1.s17045c1f70");
    check_field_offset(lv, s17045c1f71, ABISELECT(12976,10588), "S17045C1.s17045c1f71");
    check_field_offset(lv, s17045c1f72, ABISELECT(13000,10600), "S17045C1.s17045c1f72");
    check_field_offset(lv, s17045c1f73, ABISELECT(13024,10612), "S17045C1.s17045c1f73");
    check_field_offset(lv, s17045c1f74, ABISELECT(13048,10624), "S17045C1.s17045c1f74");
    check_field_offset(lv, s17045c1f75, ABISELECT(13072,10636), "S17045C1.s17045c1f75");
    check_field_offset(lv, s17045c1f76, ABISELECT(13096,10648), "S17045C1.s17045c1f76");
    check_field_offset(lv, s17045c1f77, ABISELECT(13104,10652), "S17045C1.s17045c1f77");
    check_field_offset(lv, s17045c1f78, ABISELECT(13112,10656), "S17045C1.s17045c1f78");
    check_field_offset(lv, s17045c1f79, ABISELECT(14304,11672), "S17045C1.s17045c1f79");
    check_field_offset(lv, s17045c1f80, ABISELECT(14312,11676), "S17045C1.s17045c1f80");
    check_field_offset(lv, s17045c1f81, ABISELECT(14384,11724), "S17045C1.s17045c1f81");
    check_field_offset(lv, s17045c1f82, ABISELECT(14392,11728), "S17045C1.s17045c1f82");
    check_field_offset(lv, s17045c1f83, ABISELECT(14424,11744), "S17045C1.s17045c1f83");
    check_field_offset(lv, s17045c1f84, ABISELECT(14432,11748), "S17045C1.s17045c1f84");
    check_field_offset(lv, s17045c1f85, ABISELECT(14456,11760), "S17045C1.s17045c1f85");
    check_field_offset(lv, s17045c1f86, ABISELECT(14480,11772), "S17045C1.s17045c1f86");
    check_field_offset(lv, s17045c1f87, ABISELECT(14504,11784), "S17045C1.s17045c1f87");
  }
}
static Arrange_To_Call_Me vS17045C1(Test_S17045C1, "S17045C1", ABISELECT(14528,11796));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C2_nt  {
  virtual  ~S9123C2_nt(); // _ZN10S9123C2_ntD1Ev
  virtual void  v21(); // _ZN10S9123C2_nt3v21Ev
  virtual void  v22(); // _ZN10S9123C2_nt3v22Ev
  virtual void  v23(); // _ZN10S9123C2_nt3v23Ev
  virtual void  v24(); // _ZN10S9123C2_nt3v24Ev
  virtual void  v25(); // _ZN10S9123C2_nt3v25Ev
  virtual void  v26(); // _ZN10S9123C2_nt3v26Ev
  virtual void  v27(); // _ZN10S9123C2_nt3v27Ev
  virtual void  v28(); // _ZN10S9123C2_nt3v28Ev
  virtual void  v29(); // _ZN10S9123C2_nt3v29Ev
  virtual void  v30(); // _ZN10S9123C2_nt3v30Ev
  S9123C2_nt(); // tgen
};
//SIG(-1 S9123C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S9123C2_nt ::~S9123C2_nt(){ note_dtor("S9123C2_nt", this);}
void  S9123C2_nt ::v21(){vfunc_called(this, "_ZN10S9123C2_nt3v21Ev");}
void  S9123C2_nt ::v22(){vfunc_called(this, "_ZN10S9123C2_nt3v22Ev");}
void  S9123C2_nt ::v23(){vfunc_called(this, "_ZN10S9123C2_nt3v23Ev");}
void  S9123C2_nt ::v24(){vfunc_called(this, "_ZN10S9123C2_nt3v24Ev");}
void  S9123C2_nt ::v25(){vfunc_called(this, "_ZN10S9123C2_nt3v25Ev");}
void  S9123C2_nt ::v26(){vfunc_called(this, "_ZN10S9123C2_nt3v26Ev");}
void  S9123C2_nt ::v27(){vfunc_called(this, "_ZN10S9123C2_nt3v27Ev");}
void  S9123C2_nt ::v28(){vfunc_called(this, "_ZN10S9123C2_nt3v28Ev");}
void  S9123C2_nt ::v29(){vfunc_called(this, "_ZN10S9123C2_nt3v29Ev");}
void  S9123C2_nt ::v30(){vfunc_called(this, "_ZN10S9123C2_nt3v30Ev");}
S9123C2_nt ::S9123C2_nt(){ note_ctor("S9123C2_nt", this);} // tgen

//skip512 S9123C2_nt

#else // __cplusplus

extern void _ZN10S9123C2_ntC1Ev();
extern void _ZN10S9123C2_ntD1Ev();
Name_Map name_map_S9123C2_nt[] = {
  NSPAIR(_ZN10S9123C2_ntC1Ev),
  NSPAIR(_ZN10S9123C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9123C2_nt[];
extern void _ZN10S9123C2_ntD1Ev();
extern void _ZN10S9123C2_ntD0Ev();
extern void _ZN10S9123C2_nt3v21Ev();
extern void _ZN10S9123C2_nt3v22Ev();
extern void _ZN10S9123C2_nt3v23Ev();
extern void _ZN10S9123C2_nt3v24Ev();
extern void _ZN10S9123C2_nt3v25Ev();
extern void _ZN10S9123C2_nt3v26Ev();
extern void _ZN10S9123C2_nt3v27Ev();
extern void _ZN10S9123C2_nt3v28Ev();
extern void _ZN10S9123C2_nt3v29Ev();
extern void _ZN10S9123C2_nt3v30Ev();
static  VTBL_ENTRY vtc_S9123C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9123C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S9123C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v30Ev,
};
extern VTBL_ENTRY _ZTI10S9123C2_nt[];
VTBL_ENTRY *P__ZTI10S9123C2_nt = _ZTI10S9123C2_nt; 
extern  VTBL_ENTRY _ZTV10S9123C2_nt[];
Class_Descriptor cd_S9123C2_nt = {  "S9123C2_nt", // class name
  0,0,//no base classes
  &(vtc_S9123C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S9123C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9123C2_nt),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C3_nt  {
  virtual  ~S9123C3_nt(); // _ZN10S9123C3_ntD1Ev
  virtual void  v31(); // _ZN10S9123C3_nt3v31Ev
  virtual void  v32(); // _ZN10S9123C3_nt3v32Ev
  virtual void  v33(); // _ZN10S9123C3_nt3v33Ev
  virtual void  v34(); // _ZN10S9123C3_nt3v34Ev
  virtual void  v35(); // _ZN10S9123C3_nt3v35Ev
  virtual void  v36(); // _ZN10S9123C3_nt3v36Ev
  virtual void  v37(); // _ZN10S9123C3_nt3v37Ev
  virtual void  v38(); // _ZN10S9123C3_nt3v38Ev
  virtual void  v39(); // _ZN10S9123C3_nt3v39Ev
  S9123C3_nt(); // tgen
};
//SIG(-1 S9123C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S9123C3_nt ::~S9123C3_nt(){ note_dtor("S9123C3_nt", this);}
void  S9123C3_nt ::v31(){vfunc_called(this, "_ZN10S9123C3_nt3v31Ev");}
void  S9123C3_nt ::v32(){vfunc_called(this, "_ZN10S9123C3_nt3v32Ev");}
void  S9123C3_nt ::v33(){vfunc_called(this, "_ZN10S9123C3_nt3v33Ev");}
void  S9123C3_nt ::v34(){vfunc_called(this, "_ZN10S9123C3_nt3v34Ev");}
void  S9123C3_nt ::v35(){vfunc_called(this, "_ZN10S9123C3_nt3v35Ev");}
void  S9123C3_nt ::v36(){vfunc_called(this, "_ZN10S9123C3_nt3v36Ev");}
void  S9123C3_nt ::v37(){vfunc_called(this, "_ZN10S9123C3_nt3v37Ev");}
void  S9123C3_nt ::v38(){vfunc_called(this, "_ZN10S9123C3_nt3v38Ev");}
void  S9123C3_nt ::v39(){vfunc_called(this, "_ZN10S9123C3_nt3v39Ev");}
S9123C3_nt ::S9123C3_nt(){ note_ctor("S9123C3_nt", this);} // tgen

//skip512 S9123C3_nt

#else // __cplusplus

extern void _ZN10S9123C3_ntC1Ev();
extern void _ZN10S9123C3_ntD1Ev();
Name_Map name_map_S9123C3_nt[] = {
  NSPAIR(_ZN10S9123C3_ntC1Ev),
  NSPAIR(_ZN10S9123C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9123C3_nt[];
extern void _ZN10S9123C3_ntD1Ev();
extern void _ZN10S9123C3_ntD0Ev();
extern void _ZN10S9123C3_nt3v31Ev();
extern void _ZN10S9123C3_nt3v32Ev();
extern void _ZN10S9123C3_nt3v33Ev();
extern void _ZN10S9123C3_nt3v34Ev();
extern void _ZN10S9123C3_nt3v35Ev();
extern void _ZN10S9123C3_nt3v36Ev();
extern void _ZN10S9123C3_nt3v37Ev();
extern void _ZN10S9123C3_nt3v38Ev();
extern void _ZN10S9123C3_nt3v39Ev();
static  VTBL_ENTRY vtc_S9123C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9123C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S9123C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v39Ev,
};
extern VTBL_ENTRY _ZTI10S9123C3_nt[];
VTBL_ENTRY *P__ZTI10S9123C3_nt = _ZTI10S9123C3_nt; 
extern  VTBL_ENTRY _ZTV10S9123C3_nt[];
Class_Descriptor cd_S9123C3_nt = {  "S9123C3_nt", // class name
  0,0,//no base classes
  &(vtc_S9123C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S9123C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9123C3_nt),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C4_nt  {
  virtual  ~S9123C4_nt(); // _ZN10S9123C4_ntD1Ev
  virtual void  v40(); // _ZN10S9123C4_nt3v40Ev
  S9123C4_nt(); // tgen
};
//SIG(-1 S9123C4_nt) C1{ vd v1}


 S9123C4_nt ::~S9123C4_nt(){ note_dtor("S9123C4_nt", this);}
void  S9123C4_nt ::v40(){vfunc_called(this, "_ZN10S9123C4_nt3v40Ev");}
S9123C4_nt ::S9123C4_nt(){ note_ctor("S9123C4_nt", this);} // tgen

//skip512 S9123C4_nt

#else // __cplusplus

extern void _ZN10S9123C4_ntC1Ev();
extern void _ZN10S9123C4_ntD1Ev();
Name_Map name_map_S9123C4_nt[] = {
  NSPAIR(_ZN10S9123C4_ntC1Ev),
  NSPAIR(_ZN10S9123C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9123C4_nt[];
extern void _ZN10S9123C4_ntD1Ev();
extern void _ZN10S9123C4_ntD0Ev();
extern void _ZN10S9123C4_nt3v40Ev();
static  VTBL_ENTRY vtc_S9123C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9123C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S9123C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9123C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9123C4_nt3v40Ev,
};
extern VTBL_ENTRY _ZTI10S9123C4_nt[];
VTBL_ENTRY *P__ZTI10S9123C4_nt = _ZTI10S9123C4_nt; 
extern  VTBL_ENTRY _ZTV10S9123C4_nt[];
Class_Descriptor cd_S9123C4_nt = {  "S9123C4_nt", // class name
  0,0,//no base classes
  &(vtc_S9123C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S9123C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9123C4_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C6_nt  {
  __tsi64 s9123c6f0[4];
};
//SIG(-1 S9123C6_nt) C1{ FL[4]}



//skip512 S9123C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C5_nt  {
  ::S9123C6_nt s9123c5f0;
  void  mf9123c5(); // _ZN10S9123C5_nt8mf9123c5Ev
};
//SIG(-1 S9123C5_nt) C1{ m FC2{ FL[4]}}


void  S9123C5_nt ::mf9123c5(){}

//skip512 S9123C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C9_nt  {
  void  mf9123c9(); // _ZN10S9123C9_nt8mf9123c9Ev
};
//SIG(-1 S9123C9_nt) C1{ m}


void  S9123C9_nt ::mf9123c9(){}

//skip512 S9123C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C8_nt  {
  void *s9123c8f0;
  int s9123c8f1;
  ::S9123C9_nt s9123c8f2;
  ::S9123C9_nt s9123c8f3;
  void  mf9123c8(); // _ZN10S9123C8_nt8mf9123c8Ev
};
//SIG(-1 S9123C8_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S9123C8_nt ::mf9123c8(){}

//skip512 S9123C8_nt

#else // __cplusplus

Class_Descriptor cd_S9123C8_nt = {  "S9123C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C7_nt  : S9123C8_nt {
};
//SIG(-1 S9123C7_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S9123C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S9123C8_nt;
static Base_Class bases_S9123C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C11_nt  {
  void *s9123c11f0;
  int s9123c11f1;
  void  mf9123c11(); // _ZN11S9123C11_nt9mf9123c11Ev
  virtual  ~S9123C11_nt(); // _ZN11S9123C11_ntD1Ev
  S9123C11_nt(); // tgen
};
//SIG(-1 S9123C11_nt) C1{ vd m Fp Fi}


void  S9123C11_nt ::mf9123c11(){}
 S9123C11_nt ::~S9123C11_nt(){ note_dtor("S9123C11_nt", this);}
S9123C11_nt ::S9123C11_nt(){ note_ctor("S9123C11_nt", this);} // tgen

//skip512 S9123C11_nt

#else // __cplusplus

extern void _ZN11S9123C11_ntC1Ev();
extern void _ZN11S9123C11_ntD1Ev();
Name_Map name_map_S9123C11_nt[] = {
  NSPAIR(_ZN11S9123C11_ntC1Ev),
  NSPAIR(_ZN11S9123C11_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9123C11_nt[];
extern void _ZN11S9123C11_ntD1Ev();
extern void _ZN11S9123C11_ntD0Ev();
static  VTBL_ENTRY vtc_S9123C11_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9123C11_nt[0]),
  (VTBL_ENTRY)&_ZN11S9123C11_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9123C11_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S9123C11_nt[];
VTBL_ENTRY *P__ZTI11S9123C11_nt = _ZTI11S9123C11_nt; 
extern  VTBL_ENTRY _ZTV11S9123C11_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C14_nt  {
  int s9123c14f0;
  char s9123c14f1[3];
  virtual  ~S9123C14_nt(); // _ZN11S9123C14_ntD1Ev
  virtual void  v42(); // _ZN11S9123C14_nt3v42Ev
  S9123C14_nt(); // tgen
};
//SIG(-1 S9123C14_nt) C1{ vd v1 Fi Fc[3]}


 S9123C14_nt ::~S9123C14_nt(){ note_dtor("S9123C14_nt", this);}
void  S9123C14_nt ::v42(){vfunc_called(this, "_ZN11S9123C14_nt3v42Ev");}
S9123C14_nt ::S9123C14_nt(){ note_ctor("S9123C14_nt", this);} // tgen

//skip512 S9123C14_nt

#else // __cplusplus

extern void _ZN11S9123C14_ntC1Ev();
extern void _ZN11S9123C14_ntD1Ev();
Name_Map name_map_S9123C14_nt[] = {
  NSPAIR(_ZN11S9123C14_ntC1Ev),
  NSPAIR(_ZN11S9123C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9123C14_nt[];
extern void _ZN11S9123C14_ntD1Ev();
extern void _ZN11S9123C14_ntD0Ev();
extern void _ZN11S9123C14_nt3v42Ev();
static  VTBL_ENTRY vtc_S9123C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9123C14_nt[0]),
  (VTBL_ENTRY)&_ZN11S9123C14_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9123C14_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9123C14_nt3v42Ev,
};
extern VTBL_ENTRY _ZTI11S9123C14_nt[];
VTBL_ENTRY *P__ZTI11S9123C14_nt = _ZTI11S9123C14_nt; 
extern  VTBL_ENTRY _ZTV11S9123C14_nt[];
Class_Descriptor cd_S9123C14_nt = {  "S9123C14_nt", // class name
  0,0,//no base classes
  &(vtc_S9123C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI11S9123C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S9123C14_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C17_nt  {
  int s9123c17f0[4];
};
//SIG(-1 S9123C17_nt) C1{ Fi[4]}



//skip512 S9123C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C16_nt  {
  void *s9123c16f0;
  ::S9123C17_nt s9123c16f1;
  void  mf9123c16(); // _ZN11S9123C16_nt9mf9123c16Ev
};
//SIG(-1 S9123C16_nt) C1{ m Fp FC2{ Fi[4]}}


void  S9123C16_nt ::mf9123c16(){}

//skip512 S9123C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C21  {
  void  mf9123c21(); // _ZN8S9123C219mf9123c21Ev
};
//SIG(-1 S9123C21) C1{ m}


void  S9123C21 ::mf9123c21(){}

static void Test_S9123C21()
{
  {
    init_simple_test("S9123C21");
    S9123C21 lv;
    check2(sizeof(lv), 1, "sizeof(S9123C21)");
    check2(__alignof__(lv), 1, "__alignof__(S9123C21)");
  }
}
static Arrange_To_Call_Me vS9123C21(Test_S9123C21, "S9123C21", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S9123C21[];
VTBL_ENTRY *P__ZTI8S9123C21 = _ZTI8S9123C21; 
Class_Descriptor cd_S9123C21 = {  "S9123C21", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S9123C21),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C20  {
  void *s9123c20f0;
  int s9123c20f1;
  ::S9123C21 s9123c20f2;
  ::S9123C21 s9123c20f3;
  void  mf9123c20(); // _ZN8S9123C209mf9123c20Ev
};
//SIG(-1 S9123C20) C1{ m Fp Fi FC2{ m} FC2}


void  S9123C20 ::mf9123c20(){}

static void Test_S9123C20()
{
  {
    init_simple_test("S9123C20");
    S9123C20 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9123C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C20)");
    check_field_offset(lv, s9123c20f0, 0, "S9123C20.s9123c20f0");
    check_field_offset(lv, s9123c20f1, ABISELECT(8,4), "S9123C20.s9123c20f1");
    check_field_offset(lv, s9123c20f2, ABISELECT(12,8), "S9123C20.s9123c20f2");
    check_field_offset(lv, s9123c20f3, ABISELECT(13,9), "S9123C20.s9123c20f3");
  }
}
static Arrange_To_Call_Me vS9123C20(Test_S9123C20, "S9123C20", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C19_nt  {
  ::S9123C20 s9123c19f0;
  void  mf9123c19(); // _ZN11S9123C19_nt9mf9123c19Ev
};
//SIG(-1 S9123C19_nt) C1{ m FC2{ m Fp Fi FC3{ m} FC3}}


void  S9123C19_nt ::mf9123c19(){}

//skip512 S9123C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C18  {
  int s9123c18f0;
  ::S9123C5_nt s9123c18f1;
  ::S9123C19_nt s9123c18f2;
  ::S9123C7_nt s9123c18f3;
  void  mf9123c18(); // _ZN8S9123C189mf9123c18Ev
  virtual  ~S9123C18(); // _ZN8S9123C18D1Ev
  S9123C18(); // tgen
};
//SIG(-1 S9123C18) C1{ vd m Fi FC2{ m FC3{ FL[4]}} FC4{ m FC5{ m Fp Fi FC6{ m} FC6}} FC7{ BC8{ m Fp Fi FC9{ m} FC9}}}


void  S9123C18 ::mf9123c18(){}
 S9123C18 ::~S9123C18(){ note_dtor("S9123C18", this);}
S9123C18 ::S9123C18(){ note_ctor("S9123C18", this);} // tgen

static void Test_S9123C18()
{
  extern Class_Descriptor cd_S9123C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,17)];
    init_test(&cd_S9123C18, buf);
    S9123C18 *dp, &lv = *(dp=new (buf) S9123C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,64), "sizeof(S9123C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C18)");
    check_field_offset(lv, s9123c18f0, ABISELECT(8,4), "S9123C18.s9123c18f0");
    check_field_offset(lv, s9123c18f1, ABISELECT(16,8), "S9123C18.s9123c18f1");
    check_field_offset(lv, s9123c18f2, ABISELECT(48,40), "S9123C18.s9123c18f2");
    check_field_offset(lv, s9123c18f3, ABISELECT(64,52), "S9123C18.s9123c18f3");
    test_class_info(&lv, &cd_S9123C18);
    dp->~S9123C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C18(Test_S9123C18, "S9123C18", ABISELECT(80,64));

#else // __cplusplus

extern void _ZN8S9123C18C1Ev();
extern void _ZN8S9123C18D1Ev();
Name_Map name_map_S9123C18[] = {
  NSPAIR(_ZN8S9123C18C1Ev),
  NSPAIR(_ZN8S9123C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9123C18[];
extern void _ZN8S9123C18D1Ev();
extern void _ZN8S9123C18D0Ev();
static  VTBL_ENTRY vtc_S9123C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9123C18[0]),
  (VTBL_ENTRY)&_ZN8S9123C18D1Ev,
  (VTBL_ENTRY)&_ZN8S9123C18D0Ev,
};
extern VTBL_ENTRY _ZTI8S9123C18[];
extern  VTBL_ENTRY _ZTV8S9123C18[];
Class_Descriptor cd_S9123C18 = {  "S9123C18", // class name
  0,0,//no base classes
  &(vtc_S9123C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,64), // object size
  NSPAIRA(_ZTI8S9123C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9123C18),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C29  {
  void  mf9123c29(); // _ZN8S9123C299mf9123c29Ev
};
//SIG(-1 S9123C29) C1{ m}


void  S9123C29 ::mf9123c29(){}

static void Test_S9123C29()
{
  {
    init_simple_test("S9123C29");
    S9123C29 lv;
    check2(sizeof(lv), 1, "sizeof(S9123C29)");
    check2(__alignof__(lv), 1, "__alignof__(S9123C29)");
  }
}
static Arrange_To_Call_Me vS9123C29(Test_S9123C29, "S9123C29", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S9123C29[];
VTBL_ENTRY *P__ZTI8S9123C29 = _ZTI8S9123C29; 
Class_Descriptor cd_S9123C29 = {  "S9123C29", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S9123C29),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C28  {
  void *s9123c28f0;
  int s9123c28f1;
  ::S9123C29 s9123c28f2;
  ::S9123C29 s9123c28f3;
  void  mf9123c28(); // _ZN8S9123C289mf9123c28Ev
};
//SIG(-1 S9123C28) C1{ m Fp Fi FC2{ m} FC2}


void  S9123C28 ::mf9123c28(){}

static void Test_S9123C28()
{
  {
    init_simple_test("S9123C28");
    S9123C28 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9123C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C28)");
    check_field_offset(lv, s9123c28f0, 0, "S9123C28.s9123c28f0");
    check_field_offset(lv, s9123c28f1, ABISELECT(8,4), "S9123C28.s9123c28f1");
    check_field_offset(lv, s9123c28f2, ABISELECT(12,8), "S9123C28.s9123c28f2");
    check_field_offset(lv, s9123c28f3, ABISELECT(13,9), "S9123C28.s9123c28f3");
  }
}
static Arrange_To_Call_Me vS9123C28(Test_S9123C28, "S9123C28", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S9123C28 = {  "S9123C28", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C27  : S9123C28 {
};
//SIG(-1 S9123C27) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S9123C27()
{
  extern Class_Descriptor cd_S9123C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S9123C27, buf);
    S9123C27 &lv = *(new (buf) S9123C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9123C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C27)");
    check_base_class_offset(lv, (S9123C28*), 0, "S9123C27");
    test_class_info(&lv, &cd_S9123C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C27(Test_S9123C27, "S9123C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S9123C28;
static Base_Class bases_S9123C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S9123C27 = {  "S9123C27", // class name
  bases_S9123C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C13  : S9123C14_nt {
  ::S9123C5_nt s9123c13f0;
  ::S9123C16_nt s9123c13f1;
  ::S9123C18 s9123c13f2;
  int s9123c13f3;
  ::S9123C5_nt s9123c13f4;
  ::S9123C27 s9123c13f5;
  virtual  ~S9123C13(); // _ZN8S9123C13D1Ev
  virtual void  v41(); // _ZN8S9123C133v41Ev
  S9123C13(); // tgen
};
//SIG(-1 S9123C13) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 FC3{ m FC4{ FL[4]}} FC5{ m Fp FC6{ Fi[4]}} FC7{ vd m Fi FC3 FC8{ m FC9{ m Fp Fi FC10{ m} FC10}} FC11{ BC12{ m Fp Fi FC13{ m} FC13}}} Fi FC3 FC14{ BC15{ m Fp Fi FC16{ m} FC16}}}


 S9123C13 ::~S9123C13(){ note_dtor("S9123C13", this);}
void  S9123C13 ::v41(){vfunc_called(this, "_ZN8S9123C133v41Ev");}
S9123C13 ::S9123C13(){ note_ctor("S9123C13", this);} // tgen

static void Test_S9123C13()
{
  extern Class_Descriptor cd_S9123C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,45)];
    init_test(&cd_S9123C13, buf);
    S9123C13 *dp, &lv = *(dp=new (buf) S9123C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,176), "sizeof(S9123C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C13)");
    check_base_class_offset(lv, (S9123C14_nt*), 0, "S9123C13");
    check_field_offset(lv, s9123c13f0, ABISELECT(16,12), "S9123C13.s9123c13f0");
    check_field_offset(lv, s9123c13f1, ABISELECT(48,44), "S9123C13.s9123c13f1");
    check_field_offset(lv, s9123c13f2, ABISELECT(72,64), "S9123C13.s9123c13f2");
    check_field_offset(lv, s9123c13f3, ABISELECT(152,128), "S9123C13.s9123c13f3");
    check_field_offset(lv, s9123c13f4, ABISELECT(160,132), "S9123C13.s9123c13f4");
    check_field_offset(lv, s9123c13f5, ABISELECT(192,164), "S9123C13.s9123c13f5");
    test_class_info(&lv, &cd_S9123C13);
    dp->~S9123C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C13(Test_S9123C13, "S9123C13", ABISELECT(208,176));

#else // __cplusplus

extern void _ZN8S9123C13C1Ev();
extern void _ZN8S9123C13D1Ev();
Name_Map name_map_S9123C13[] = {
  NSPAIR(_ZN8S9123C13C1Ev),
  NSPAIR(_ZN8S9123C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9123C14_nt;
extern VTBL_ENTRY _ZTI11S9123C14_nt[];
extern  VTBL_ENTRY _ZTV11S9123C14_nt[];
static Base_Class bases_S9123C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9123C13[];
extern void _ZN8S9123C13D1Ev();
extern void _ZN8S9123C13D0Ev();
extern void _ZN11S9123C14_nt3v42Ev();
extern void _ZN8S9123C133v41Ev();
static  VTBL_ENTRY vtc_S9123C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9123C13[0]),
  (VTBL_ENTRY)&_ZN8S9123C13D1Ev,
  (VTBL_ENTRY)&_ZN8S9123C13D0Ev,
  (VTBL_ENTRY)&_ZN11S9123C14_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S9123C133v41Ev,
};
extern VTBL_ENTRY _ZTI8S9123C13[];
extern  VTBL_ENTRY _ZTV8S9123C13[];
Class_Descriptor cd_S9123C13 = {  "S9123C13", // class name
  bases_S9123C13, 1,
  &(vtc_S9123C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,176), // object size
  NSPAIRA(_ZTI8S9123C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9123C13),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C32  {
  virtual  ~S9123C32(); // _ZN8S9123C32D1Ev
  virtual void  v48(); // _ZN8S9123C323v48Ev
  virtual void  v49(); // _ZN8S9123C323v49Ev
  virtual void  v50(); // _ZN8S9123C323v50Ev
  virtual void  v51(); // _ZN8S9123C323v51Ev
  virtual void  v52(); // _ZN8S9123C323v52Ev
  S9123C32(); // tgen
};
//SIG(-1 S9123C32) C1{ vd v1 v2 v3 v4 v5}


 S9123C32 ::~S9123C32(){ note_dtor("S9123C32", this);}
void  S9123C32 ::v48(){vfunc_called(this, "_ZN8S9123C323v48Ev");}
void  S9123C32 ::v49(){vfunc_called(this, "_ZN8S9123C323v49Ev");}
void  S9123C32 ::v50(){vfunc_called(this, "_ZN8S9123C323v50Ev");}
void  S9123C32 ::v51(){vfunc_called(this, "_ZN8S9123C323v51Ev");}
void  S9123C32 ::v52(){vfunc_called(this, "_ZN8S9123C323v52Ev");}
S9123C32 ::S9123C32(){ note_ctor("S9123C32", this);} // tgen

static void Test_S9123C32()
{
  extern Class_Descriptor cd_S9123C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9123C32, buf);
    S9123C32 *dp, &lv = *(dp=new (buf) S9123C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9123C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C32)");
    test_class_info(&lv, &cd_S9123C32);
    dp->~S9123C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C32(Test_S9123C32, "S9123C32", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9123C32C1Ev();
extern void _ZN8S9123C32D1Ev();
Name_Map name_map_S9123C32[] = {
  NSPAIR(_ZN8S9123C32C1Ev),
  NSPAIR(_ZN8S9123C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9123C32[];
extern void _ZN8S9123C32D1Ev();
extern void _ZN8S9123C32D0Ev();
extern void _ZN8S9123C323v48Ev();
extern void _ZN8S9123C323v49Ev();
extern void _ZN8S9123C323v50Ev();
extern void _ZN8S9123C323v51Ev();
extern void _ZN8S9123C323v52Ev();
static  VTBL_ENTRY vtc_S9123C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9123C32[0]),
  (VTBL_ENTRY)&_ZN8S9123C32D1Ev,
  (VTBL_ENTRY)&_ZN8S9123C32D0Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v48Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v49Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v50Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v51Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v52Ev,
};
extern VTBL_ENTRY _ZTI8S9123C32[];
extern  VTBL_ENTRY _ZTV8S9123C32[];
Class_Descriptor cd_S9123C32 = {  "S9123C32", // class name
  0,0,//no base classes
  &(vtc_S9123C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9123C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9123C32),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C31  : S9123C32 {
  virtual  ~S9123C31(); // _ZN8S9123C31D1Ev
  virtual void  v43(); // _ZN8S9123C313v43Ev
  virtual void  v44(); // _ZN8S9123C313v44Ev
  virtual void  v45(); // _ZN8S9123C313v45Ev
  virtual void  v46(); // _ZN8S9123C313v46Ev
  virtual void  v47(); // _ZN8S9123C313v47Ev
  S9123C31(); // tgen
};
//SIG(-1 S9123C31) C1{ BC2{ vd v6 v7 v8 v9 v10} vd v1 v2 v3 v4 v5}


 S9123C31 ::~S9123C31(){ note_dtor("S9123C31", this);}
void  S9123C31 ::v43(){vfunc_called(this, "_ZN8S9123C313v43Ev");}
void  S9123C31 ::v44(){vfunc_called(this, "_ZN8S9123C313v44Ev");}
void  S9123C31 ::v45(){vfunc_called(this, "_ZN8S9123C313v45Ev");}
void  S9123C31 ::v46(){vfunc_called(this, "_ZN8S9123C313v46Ev");}
void  S9123C31 ::v47(){vfunc_called(this, "_ZN8S9123C313v47Ev");}
S9123C31 ::S9123C31(){ note_ctor("S9123C31", this);} // tgen

static void Test_S9123C31()
{
  extern Class_Descriptor cd_S9123C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9123C31, buf);
    S9123C31 *dp, &lv = *(dp=new (buf) S9123C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9123C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C31)");
    check_base_class_offset(lv, (S9123C32*), 0, "S9123C31");
    test_class_info(&lv, &cd_S9123C31);
    dp->~S9123C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C31(Test_S9123C31, "S9123C31", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9123C31C1Ev();
extern void _ZN8S9123C31D1Ev();
Name_Map name_map_S9123C31[] = {
  NSPAIR(_ZN8S9123C31C1Ev),
  NSPAIR(_ZN8S9123C31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9123C32;
extern VTBL_ENTRY _ZTI8S9123C32[];
extern  VTBL_ENTRY _ZTV8S9123C32[];
static Base_Class bases_S9123C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9123C31[];
extern void _ZN8S9123C31D1Ev();
extern void _ZN8S9123C31D0Ev();
extern void _ZN8S9123C323v48Ev();
extern void _ZN8S9123C323v49Ev();
extern void _ZN8S9123C323v50Ev();
extern void _ZN8S9123C323v51Ev();
extern void _ZN8S9123C323v52Ev();
extern void _ZN8S9123C313v43Ev();
extern void _ZN8S9123C313v44Ev();
extern void _ZN8S9123C313v45Ev();
extern void _ZN8S9123C313v46Ev();
extern void _ZN8S9123C313v47Ev();
static  VTBL_ENTRY vtc_S9123C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9123C31[0]),
  (VTBL_ENTRY)&_ZN8S9123C31D1Ev,
  (VTBL_ENTRY)&_ZN8S9123C31D0Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v48Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v49Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v50Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v51Ev,
  (VTBL_ENTRY)&_ZN8S9123C323v52Ev,
  (VTBL_ENTRY)&_ZN8S9123C313v43Ev,
  (VTBL_ENTRY)&_ZN8S9123C313v44Ev,
  (VTBL_ENTRY)&_ZN8S9123C313v45Ev,
  (VTBL_ENTRY)&_ZN8S9123C313v46Ev,
  (VTBL_ENTRY)&_ZN8S9123C313v47Ev,
};
extern VTBL_ENTRY _ZTI8S9123C31[];
extern  VTBL_ENTRY _ZTV8S9123C31[];
Class_Descriptor cd_S9123C31 = {  "S9123C31", // class name
  bases_S9123C31, 1,
  &(vtc_S9123C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9123C31),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9123C31),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C35_nt  {
  int s9123c35f0;
  void  mf9123c35(); // _ZN11S9123C35_nt9mf9123c35Ev
  virtual  ~S9123C35_nt(); // _ZN11S9123C35_ntD1Ev
  S9123C35_nt(); // tgen
};
//SIG(-1 S9123C35_nt) C1{ vd m Fi}


void  S9123C35_nt ::mf9123c35(){}
 S9123C35_nt ::~S9123C35_nt(){ note_dtor("S9123C35_nt", this);}
S9123C35_nt ::S9123C35_nt(){ note_ctor("S9123C35_nt", this);} // tgen

//skip512 S9123C35_nt

#else // __cplusplus

extern void _ZN11S9123C35_ntC1Ev();
extern void _ZN11S9123C35_ntD1Ev();
Name_Map name_map_S9123C35_nt[] = {
  NSPAIR(_ZN11S9123C35_ntC1Ev),
  NSPAIR(_ZN11S9123C35_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9123C35_nt[];
extern void _ZN11S9123C35_ntD1Ev();
extern void _ZN11S9123C35_ntD0Ev();
static  VTBL_ENTRY vtc_S9123C35_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9123C35_nt[0]),
  (VTBL_ENTRY)&_ZN11S9123C35_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9123C35_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S9123C35_nt[];
VTBL_ENTRY *P__ZTI11S9123C35_nt = _ZTI11S9123C35_nt; 
extern  VTBL_ENTRY _ZTV11S9123C35_nt[];
Class_Descriptor cd_S9123C35_nt = {  "S9123C35_nt", // class name
  0,0,//no base classes
  &(vtc_S9123C35_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI11S9123C35_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S9123C35_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C36_nt  {
  __tsi64 s9123c36f0;
};
//SIG(-1 S9123C36_nt) C1{ FL}



//skip512 S9123C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C37_nt  {
  char s9123c37f0[12];
};
//SIG(-1 S9123C37_nt) C1{ Fc[12]}



//skip512 S9123C37_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C34  : S9123C35_nt {
  int s9123c34f0[2];
  void *s9123c34f1;
  int s9123c34f2;
  ::S9123C36_nt s9123c34f3;
  char s9123c34f4;
  ::S9123C37_nt s9123c34f5;
  void *s9123c34f6[2];
  char s9123c34f7;
  void *s9123c34f8;
  ::S9123C37_nt s9123c34f9;
  char s9123c34f10;
  ::S9123C37_nt s9123c34f11;
  char s9123c34f12;
  int s9123c34f13;
  void *s9123c34f14[2];
  int s9123c34f15;
  char s9123c34f16;
  int s9123c34f17;
  void *s9123c34f18[3];
  int s9123c34f19;
  virtual  ~S9123C34(); // _ZN8S9123C34D1Ev
  S9123C34(); // tgen
};
//SIG(-1 S9123C34) C1{ BC2{ vd m Fi} vd Fi[2] Fp Fi FC3{ FL} Fc FC4{ Fc[12]} Fp[2] Fc Fp FC4 Fc FC4 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi}


 S9123C34 ::~S9123C34(){ note_dtor("S9123C34", this);}
S9123C34 ::S9123C34(){ note_ctor("S9123C34", this);} // tgen

static void Test_S9123C34()
{
  extern Class_Descriptor cd_S9123C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S9123C34, buf);
    S9123C34 *dp, &lv = *(dp=new (buf) S9123C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S9123C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C34)");
    check_base_class_offset(lv, (S9123C35_nt*), 0, "S9123C34");
    check_field_offset(lv, s9123c34f0, ABISELECT(12,8), "S9123C34.s9123c34f0");
    check_field_offset(lv, s9123c34f1, ABISELECT(24,16), "S9123C34.s9123c34f1");
    check_field_offset(lv, s9123c34f2, ABISELECT(32,20), "S9123C34.s9123c34f2");
    check_field_offset(lv, s9123c34f3, ABISELECT(40,24), "S9123C34.s9123c34f3");
    check_field_offset(lv, s9123c34f4, ABISELECT(48,32), "S9123C34.s9123c34f4");
    check_field_offset(lv, s9123c34f5, ABISELECT(49,33), "S9123C34.s9123c34f5");
    check_field_offset(lv, s9123c34f6, ABISELECT(64,48), "S9123C34.s9123c34f6");
    check_field_offset(lv, s9123c34f7, ABISELECT(80,56), "S9123C34.s9123c34f7");
    check_field_offset(lv, s9123c34f8, ABISELECT(88,60), "S9123C34.s9123c34f8");
    check_field_offset(lv, s9123c34f9, ABISELECT(96,64), "S9123C34.s9123c34f9");
    check_field_offset(lv, s9123c34f10, ABISELECT(108,76), "S9123C34.s9123c34f10");
    check_field_offset(lv, s9123c34f11, ABISELECT(109,77), "S9123C34.s9123c34f11");
    check_field_offset(lv, s9123c34f12, ABISELECT(121,89), "S9123C34.s9123c34f12");
    check_field_offset(lv, s9123c34f13, ABISELECT(124,92), "S9123C34.s9123c34f13");
    check_field_offset(lv, s9123c34f14, ABISELECT(128,96), "S9123C34.s9123c34f14");
    check_field_offset(lv, s9123c34f15, ABISELECT(144,104), "S9123C34.s9123c34f15");
    check_field_offset(lv, s9123c34f16, ABISELECT(148,108), "S9123C34.s9123c34f16");
    check_field_offset(lv, s9123c34f17, ABISELECT(152,112), "S9123C34.s9123c34f17");
    check_field_offset(lv, s9123c34f18, ABISELECT(160,116), "S9123C34.s9123c34f18");
    check_field_offset(lv, s9123c34f19, ABISELECT(184,128), "S9123C34.s9123c34f19");
    test_class_info(&lv, &cd_S9123C34);
    dp->~S9123C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C34(Test_S9123C34, "S9123C34", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN8S9123C34C1Ev();
extern void _ZN8S9123C34D1Ev();
Name_Map name_map_S9123C34[] = {
  NSPAIR(_ZN8S9123C34C1Ev),
  NSPAIR(_ZN8S9123C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9123C35_nt;
extern VTBL_ENTRY _ZTI11S9123C35_nt[];
extern  VTBL_ENTRY _ZTV11S9123C35_nt[];
static Base_Class bases_S9123C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C35_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9123C34[];
extern void _ZN8S9123C34D1Ev();
extern void _ZN8S9123C34D0Ev();
static  VTBL_ENTRY vtc_S9123C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9123C34[0]),
  (VTBL_ENTRY)&_ZN8S9123C34D1Ev,
  (VTBL_ENTRY)&_ZN8S9123C34D0Ev,
};
extern VTBL_ENTRY _ZTI8S9123C34[];
extern  VTBL_ENTRY _ZTV8S9123C34[];
Class_Descriptor cd_S9123C34 = {  "S9123C34", // class name
  bases_S9123C34, 1,
  &(vtc_S9123C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI8S9123C34),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9123C34),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C33  {
  ::S9123C5_nt s9123c33f0;
  int s9123c33f1;
  ::S9123C34 s9123c33f2;
  void *s9123c33f3;
  void  mf9123c33(); // _ZN8S9123C339mf9123c33Ev
  virtual  ~S9123C33(); // _ZN8S9123C33D1Ev
  S9123C33(); // tgen
};
//SIG(-1 S9123C33) C1{ vd m FC2{ m FC3{ FL[4]}} Fi FC4{ BC5{ vd m Fi} vd Fi[2] Fp Fi FC6{ FL} Fc FC7{ Fc[12]} Fp[2] Fc Fp FC7 Fc FC7 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi} Fp}


void  S9123C33 ::mf9123c33(){}
 S9123C33 ::~S9123C33(){ note_dtor("S9123C33", this);}
S9123C33 ::S9123C33(){ note_ctor("S9123C33", this);} // tgen

static void Test_S9123C33()
{
  extern Class_Descriptor cd_S9123C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,45)];
    init_test(&cd_S9123C33, buf);
    S9123C33 *dp, &lv = *(dp=new (buf) S9123C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,176), "sizeof(S9123C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C33)");
    check_field_offset(lv, s9123c33f0, ABISELECT(8,4), "S9123C33.s9123c33f0");
    check_field_offset(lv, s9123c33f1, ABISELECT(40,36), "S9123C33.s9123c33f1");
    check_field_offset(lv, s9123c33f2, ABISELECT(48,40), "S9123C33.s9123c33f2");
    check_field_offset(lv, s9123c33f3, ABISELECT(240,172), "S9123C33.s9123c33f3");
    test_class_info(&lv, &cd_S9123C33);
    dp->~S9123C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C33(Test_S9123C33, "S9123C33", ABISELECT(248,176));

#else // __cplusplus

extern void _ZN8S9123C33C1Ev();
extern void _ZN8S9123C33D1Ev();
Name_Map name_map_S9123C33[] = {
  NSPAIR(_ZN8S9123C33C1Ev),
  NSPAIR(_ZN8S9123C33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9123C33[];
extern void _ZN8S9123C33D1Ev();
extern void _ZN8S9123C33D0Ev();
static  VTBL_ENTRY vtc_S9123C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9123C33[0]),
  (VTBL_ENTRY)&_ZN8S9123C33D1Ev,
  (VTBL_ENTRY)&_ZN8S9123C33D0Ev,
};
extern VTBL_ENTRY _ZTI8S9123C33[];
extern  VTBL_ENTRY _ZTV8S9123C33[];
Class_Descriptor cd_S9123C33 = {  "S9123C33", // class name
  0,0,//no base classes
  &(vtc_S9123C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,176), // object size
  NSPAIRA(_ZTI8S9123C33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9123C33),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9123C1  : S9123C2_nt , S9123C3_nt , S9123C4_nt {
  void *s9123c1f0;
  ::S9123C5_nt s9123c1f1;
  ::S9123C7_nt s9123c1f2;
  int s9123c1f3;
  ::S9123C11_nt s9123c1f4;
  ::S9123C11_nt s9123c1f5;
  ::S9123C13 s9123c1f6;
  ::S9123C31 s9123c1f7;
  void *s9123c1f8;
  ::S9123C33 s9123c1f9;
  virtual  ~S9123C1(); // _ZN7S9123C1D1Ev
  virtual void  v1(); // _ZN7S9123C12v1Ev
  virtual void  v2(); // _ZN7S9123C12v2Ev
  virtual void  v3(); // _ZN7S9123C12v3Ev
  virtual void  v4(); // _ZN7S9123C12v4Ev
  virtual void  v5(); // _ZN7S9123C12v5Ev
  virtual void  v6(); // _ZN7S9123C12v6Ev
  virtual void  v7(); // _ZN7S9123C12v7Ev
  virtual void  v8(); // _ZN7S9123C12v8Ev
  virtual void  v9(); // _ZN7S9123C12v9Ev
  virtual void  v10(); // _ZN7S9123C13v10Ev
  virtual void  v11(); // _ZN7S9123C13v11Ev
  virtual void  v12(); // _ZN7S9123C13v12Ev
  virtual void  v13(); // _ZN7S9123C13v13Ev
  virtual void  v14(); // _ZN7S9123C13v14Ev
  virtual void  v15(); // _ZN7S9123C13v15Ev
  virtual void  v16(); // _ZN7S9123C13v16Ev
  virtual void  v17(); // _ZN7S9123C13v17Ev
  virtual void  v18(); // _ZN7S9123C13v18Ev
  virtual void  v19(); // _ZN7S9123C13v19Ev
  virtual void  v20(); // _ZN7S9123C13v20Ev
  S9123C1(); // tgen
};
//SIG(1 S9123C1) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30} BC3{ vd v31 v32 v33 v34 v35 v36 v37 v38 v39} BC4{ vd v40} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp FC5{ m FC6{ FL[4]}} FC7{ BC8{ m Fp Fi FC9{ m} FC9}} Fi FC10{ vd m Fp Fi} FC10 FC11{ BC12{ vd v42 Fi Fc[3]} vd v41 FC5 FC13{ m Fp FC14{ Fi[4]}} FC15{ vd m Fi FC5 FC16{ m FC17{ m Fp Fi FC18{ m} FC18}} FC7} Fi FC5 FC19{ BC20{ m Fp Fi FC21{ m} FC21}}} FC22{ BC23{ vd v48 v49 v50 v51 v52} vd v43 v44 v45 v46 v47} Fp FC24{ vd m FC5 Fi FC25{ BC26{ vd m Fi} vd Fi[2] Fp Fi FC27{ FL} Fc FC28{ Fc[12]} Fp[2] Fc Fp FC28 Fc FC28 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi} Fp}}


 S9123C1 ::~S9123C1(){ note_dtor("S9123C1", this);}
void  S9123C1 ::v1(){vfunc_called(this, "_ZN7S9123C12v1Ev");}
void  S9123C1 ::v2(){vfunc_called(this, "_ZN7S9123C12v2Ev");}
void  S9123C1 ::v3(){vfunc_called(this, "_ZN7S9123C12v3Ev");}
void  S9123C1 ::v4(){vfunc_called(this, "_ZN7S9123C12v4Ev");}
void  S9123C1 ::v5(){vfunc_called(this, "_ZN7S9123C12v5Ev");}
void  S9123C1 ::v6(){vfunc_called(this, "_ZN7S9123C12v6Ev");}
void  S9123C1 ::v7(){vfunc_called(this, "_ZN7S9123C12v7Ev");}
void  S9123C1 ::v8(){vfunc_called(this, "_ZN7S9123C12v8Ev");}
void  S9123C1 ::v9(){vfunc_called(this, "_ZN7S9123C12v9Ev");}
void  S9123C1 ::v10(){vfunc_called(this, "_ZN7S9123C13v10Ev");}
void  S9123C1 ::v11(){vfunc_called(this, "_ZN7S9123C13v11Ev");}
void  S9123C1 ::v12(){vfunc_called(this, "_ZN7S9123C13v12Ev");}
void  S9123C1 ::v13(){vfunc_called(this, "_ZN7S9123C13v13Ev");}
void  S9123C1 ::v14(){vfunc_called(this, "_ZN7S9123C13v14Ev");}
void  S9123C1 ::v15(){vfunc_called(this, "_ZN7S9123C13v15Ev");}
void  S9123C1 ::v16(){vfunc_called(this, "_ZN7S9123C13v16Ev");}
void  S9123C1 ::v17(){vfunc_called(this, "_ZN7S9123C13v17Ev");}
void  S9123C1 ::v18(){vfunc_called(this, "_ZN7S9123C13v18Ev");}
void  S9123C1 ::v19(){vfunc_called(this, "_ZN7S9123C13v19Ev");}
void  S9123C1 ::v20(){vfunc_called(this, "_ZN7S9123C13v20Ev");}
S9123C1 ::S9123C1(){ note_ctor("S9123C1", this);} // tgen

static void Test_S9123C1()
{
  extern Class_Descriptor cd_S9123C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(77,113)];
    init_test(&cd_S9123C1, buf);
    S9123C1 *dp, &lv = *(dp=new (buf) S9123C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,448), "sizeof(S9123C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9123C1)");
    check_base_class_offset(lv, (S9123C2_nt*), 0, "S9123C1");
    check_base_class_offset(lv, (S9123C3_nt*), ABISELECT(8,4), "S9123C1");
    check_base_class_offset(lv, (S9123C4_nt*), ABISELECT(16,8), "S9123C1");
    check_field_offset(lv, s9123c1f0, ABISELECT(24,12), "S9123C1.s9123c1f0");
    check_field_offset(lv, s9123c1f1, ABISELECT(32,16), "S9123C1.s9123c1f1");
    check_field_offset(lv, s9123c1f2, ABISELECT(64,48), "S9123C1.s9123c1f2");
    check_field_offset(lv, s9123c1f3, ABISELECT(80,60), "S9123C1.s9123c1f3");
    check_field_offset(lv, s9123c1f4, ABISELECT(88,64), "S9123C1.s9123c1f4");
    check_field_offset(lv, s9123c1f5, ABISELECT(112,76), "S9123C1.s9123c1f5");
    check_field_offset(lv, s9123c1f6, ABISELECT(136,88), "S9123C1.s9123c1f6");
    check_field_offset(lv, s9123c1f7, ABISELECT(344,264), "S9123C1.s9123c1f7");
    check_field_offset(lv, s9123c1f8, ABISELECT(352,268), "S9123C1.s9123c1f8");
    check_field_offset(lv, s9123c1f9, ABISELECT(360,272), "S9123C1.s9123c1f9");
    test_class_info(&lv, &cd_S9123C1);
    dp->~S9123C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9123C1(Test_S9123C1, "S9123C1", ABISELECT(608,448));

#else // __cplusplus

extern void _ZN7S9123C1C1Ev();
extern void _ZN7S9123C1D1Ev();
Name_Map name_map_S9123C1[] = {
  NSPAIR(_ZN7S9123C1C1Ev),
  NSPAIR(_ZN7S9123C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9123C2_nt;
extern VTBL_ENTRY _ZTI10S9123C2_nt[];
extern  VTBL_ENTRY _ZTV10S9123C2_nt[];
extern Class_Descriptor cd_S9123C3_nt;
extern VTBL_ENTRY _ZTI10S9123C3_nt[];
extern  VTBL_ENTRY _ZTV10S9123C3_nt[];
extern Class_Descriptor cd_S9123C4_nt;
extern VTBL_ENTRY _ZTI10S9123C4_nt[];
extern  VTBL_ENTRY _ZTV10S9123C4_nt[];
static Base_Class bases_S9123C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9123C3_nt,    ABISELECT(8,4), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9123C4_nt,    ABISELECT(16,8), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9123C1[];
extern void _ZN7S9123C1D1Ev();
extern void _ZN7S9123C1D0Ev();
extern void _ZN10S9123C2_nt3v21Ev();
extern void _ZN10S9123C2_nt3v22Ev();
extern void _ZN10S9123C2_nt3v23Ev();
extern void _ZN10S9123C2_nt3v24Ev();
extern void _ZN10S9123C2_nt3v25Ev();
extern void _ZN10S9123C2_nt3v26Ev();
extern void _ZN10S9123C2_nt3v27Ev();
extern void _ZN10S9123C2_nt3v28Ev();
extern void _ZN10S9123C2_nt3v29Ev();
extern void _ZN10S9123C2_nt3v30Ev();
extern void _ZN7S9123C12v1Ev();
extern void _ZN7S9123C12v2Ev();
extern void _ZN7S9123C12v3Ev();
extern void _ZN7S9123C12v4Ev();
extern void _ZN7S9123C12v5Ev();
extern void _ZN7S9123C12v6Ev();
extern void _ZN7S9123C12v7Ev();
extern void _ZN7S9123C12v8Ev();
extern void _ZN7S9123C12v9Ev();
extern void _ZN7S9123C13v10Ev();
extern void _ZN7S9123C13v11Ev();
extern void _ZN7S9123C13v12Ev();
extern void _ZN7S9123C13v13Ev();
extern void _ZN7S9123C13v14Ev();
extern void _ZN7S9123C13v15Ev();
extern void _ZN7S9123C13v16Ev();
extern void _ZN7S9123C13v17Ev();
extern void _ZN7S9123C13v18Ev();
extern void _ZN7S9123C13v19Ev();
extern void _ZN7S9123C13v20Ev();
extern void ABISELECT(_ZThn8_N7S9123C1D1Ev,_ZThn4_N7S9123C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9123C1D0Ev,_ZThn4_N7S9123C1D0Ev)();
extern void _ZN10S9123C3_nt3v31Ev();
extern void _ZN10S9123C3_nt3v32Ev();
extern void _ZN10S9123C3_nt3v33Ev();
extern void _ZN10S9123C3_nt3v34Ev();
extern void _ZN10S9123C3_nt3v35Ev();
extern void _ZN10S9123C3_nt3v36Ev();
extern void _ZN10S9123C3_nt3v37Ev();
extern void _ZN10S9123C3_nt3v38Ev();
extern void _ZN10S9123C3_nt3v39Ev();
extern void ABISELECT(_ZThn16_N7S9123C1D1Ev,_ZThn8_N7S9123C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S9123C1D0Ev,_ZThn8_N7S9123C1D0Ev)();
extern void _ZN10S9123C4_nt3v40Ev();
static  VTBL_ENTRY vtc_S9123C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9123C1[0]),
  (VTBL_ENTRY)&_ZN7S9123C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9123C1D0Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S9123C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9123C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9123C13v20Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9123C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9123C1D1Ev,_ZThn4_N7S9123C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9123C1D0Ev,_ZThn4_N7S9123C1D0Ev),
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S9123C3_nt3v39Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S9123C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S9123C1D1Ev,_ZThn8_N7S9123C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S9123C1D0Ev,_ZThn8_N7S9123C1D0Ev),
  (VTBL_ENTRY)&_ZN10S9123C4_nt3v40Ev,
};
extern VTBL_ENTRY _ZTI7S9123C1[];
extern  VTBL_ENTRY _ZTV7S9123C1[];
Class_Descriptor cd_S9123C1 = {  "S9123C1", // class name
  bases_S9123C1, 3,
  &(vtc_S9123C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,448), // object size
  NSPAIRA(_ZTI7S9123C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S9123C1),52, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C2  {
  virtual  ~S9122C2(); // _ZN7S9122C2D1Ev
  virtual void  v21(); // _ZN7S9122C23v21Ev
  virtual void  v22(); // _ZN7S9122C23v22Ev
  virtual void  v23(); // _ZN7S9122C23v23Ev
  virtual void  v24(); // _ZN7S9122C23v24Ev
  virtual void  v25(); // _ZN7S9122C23v25Ev
  virtual void  v26(); // _ZN7S9122C23v26Ev
  virtual void  v27(); // _ZN7S9122C23v27Ev
  virtual void  v28(); // _ZN7S9122C23v28Ev
  virtual void  v29(); // _ZN7S9122C23v29Ev
  virtual void  v30(); // _ZN7S9122C23v30Ev
  S9122C2(); // tgen
};
//SIG(-1 S9122C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S9122C2 ::~S9122C2(){ note_dtor("S9122C2", this);}
void  S9122C2 ::v21(){vfunc_called(this, "_ZN7S9122C23v21Ev");}
void  S9122C2 ::v22(){vfunc_called(this, "_ZN7S9122C23v22Ev");}
void  S9122C2 ::v23(){vfunc_called(this, "_ZN7S9122C23v23Ev");}
void  S9122C2 ::v24(){vfunc_called(this, "_ZN7S9122C23v24Ev");}
void  S9122C2 ::v25(){vfunc_called(this, "_ZN7S9122C23v25Ev");}
void  S9122C2 ::v26(){vfunc_called(this, "_ZN7S9122C23v26Ev");}
void  S9122C2 ::v27(){vfunc_called(this, "_ZN7S9122C23v27Ev");}
void  S9122C2 ::v28(){vfunc_called(this, "_ZN7S9122C23v28Ev");}
void  S9122C2 ::v29(){vfunc_called(this, "_ZN7S9122C23v29Ev");}
void  S9122C2 ::v30(){vfunc_called(this, "_ZN7S9122C23v30Ev");}
S9122C2 ::S9122C2(){ note_ctor("S9122C2", this);} // tgen

static void Test_S9122C2()
{
  extern Class_Descriptor cd_S9122C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9122C2, buf);
    S9122C2 *dp, &lv = *(dp=new (buf) S9122C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9122C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C2)");
    test_class_info(&lv, &cd_S9122C2);
    dp->~S9122C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C2(Test_S9122C2, "S9122C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9122C2C1Ev();
extern void _ZN7S9122C2D1Ev();
Name_Map name_map_S9122C2[] = {
  NSPAIR(_ZN7S9122C2C1Ev),
  NSPAIR(_ZN7S9122C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9122C2[];
extern void _ZN7S9122C2D1Ev();
extern void _ZN7S9122C2D0Ev();
extern void _ZN7S9122C23v21Ev();
extern void _ZN7S9122C23v22Ev();
extern void _ZN7S9122C23v23Ev();
extern void _ZN7S9122C23v24Ev();
extern void _ZN7S9122C23v25Ev();
extern void _ZN7S9122C23v26Ev();
extern void _ZN7S9122C23v27Ev();
extern void _ZN7S9122C23v28Ev();
extern void _ZN7S9122C23v29Ev();
extern void _ZN7S9122C23v30Ev();
static  VTBL_ENTRY vtc_S9122C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9122C2[0]),
  (VTBL_ENTRY)&_ZN7S9122C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9122C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v21Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v22Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v23Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v24Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v25Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v26Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v27Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v28Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v29Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v30Ev,
};
extern VTBL_ENTRY _ZTI7S9122C2[];
extern  VTBL_ENTRY _ZTV7S9122C2[];
Class_Descriptor cd_S9122C2 = {  "S9122C2", // class name
  0,0,//no base classes
  &(vtc_S9122C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9122C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9122C2),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C3  {
  virtual  ~S9122C3(); // _ZN7S9122C3D1Ev
  virtual void  v31(); // _ZN7S9122C33v31Ev
  virtual void  v32(); // _ZN7S9122C33v32Ev
  virtual void  v33(); // _ZN7S9122C33v33Ev
  virtual void  v34(); // _ZN7S9122C33v34Ev
  virtual void  v35(); // _ZN7S9122C33v35Ev
  virtual void  v36(); // _ZN7S9122C33v36Ev
  virtual void  v37(); // _ZN7S9122C33v37Ev
  virtual void  v38(); // _ZN7S9122C33v38Ev
  virtual void  v39(); // _ZN7S9122C33v39Ev
  S9122C3(); // tgen
};
//SIG(-1 S9122C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S9122C3 ::~S9122C3(){ note_dtor("S9122C3", this);}
void  S9122C3 ::v31(){vfunc_called(this, "_ZN7S9122C33v31Ev");}
void  S9122C3 ::v32(){vfunc_called(this, "_ZN7S9122C33v32Ev");}
void  S9122C3 ::v33(){vfunc_called(this, "_ZN7S9122C33v33Ev");}
void  S9122C3 ::v34(){vfunc_called(this, "_ZN7S9122C33v34Ev");}
void  S9122C3 ::v35(){vfunc_called(this, "_ZN7S9122C33v35Ev");}
void  S9122C3 ::v36(){vfunc_called(this, "_ZN7S9122C33v36Ev");}
void  S9122C3 ::v37(){vfunc_called(this, "_ZN7S9122C33v37Ev");}
void  S9122C3 ::v38(){vfunc_called(this, "_ZN7S9122C33v38Ev");}
void  S9122C3 ::v39(){vfunc_called(this, "_ZN7S9122C33v39Ev");}
S9122C3 ::S9122C3(){ note_ctor("S9122C3", this);} // tgen

static void Test_S9122C3()
{
  extern Class_Descriptor cd_S9122C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9122C3, buf);
    S9122C3 *dp, &lv = *(dp=new (buf) S9122C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9122C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C3)");
    test_class_info(&lv, &cd_S9122C3);
    dp->~S9122C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C3(Test_S9122C3, "S9122C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9122C3C1Ev();
extern void _ZN7S9122C3D1Ev();
Name_Map name_map_S9122C3[] = {
  NSPAIR(_ZN7S9122C3C1Ev),
  NSPAIR(_ZN7S9122C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9122C3[];
extern void _ZN7S9122C3D1Ev();
extern void _ZN7S9122C3D0Ev();
extern void _ZN7S9122C33v31Ev();
extern void _ZN7S9122C33v32Ev();
extern void _ZN7S9122C33v33Ev();
extern void _ZN7S9122C33v34Ev();
extern void _ZN7S9122C33v35Ev();
extern void _ZN7S9122C33v36Ev();
extern void _ZN7S9122C33v37Ev();
extern void _ZN7S9122C33v38Ev();
extern void _ZN7S9122C33v39Ev();
static  VTBL_ENTRY vtc_S9122C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9122C3[0]),
  (VTBL_ENTRY)&_ZN7S9122C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9122C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v39Ev,
};
extern VTBL_ENTRY _ZTI7S9122C3[];
extern  VTBL_ENTRY _ZTV7S9122C3[];
Class_Descriptor cd_S9122C3 = {  "S9122C3", // class name
  0,0,//no base classes
  &(vtc_S9122C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9122C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9122C3),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C4  {
  virtual  ~S9122C4(); // _ZN7S9122C4D1Ev
  virtual void  v40(); // _ZN7S9122C43v40Ev
  S9122C4(); // tgen
};
//SIG(-1 S9122C4) C1{ vd v1}


 S9122C4 ::~S9122C4(){ note_dtor("S9122C4", this);}
void  S9122C4 ::v40(){vfunc_called(this, "_ZN7S9122C43v40Ev");}
S9122C4 ::S9122C4(){ note_ctor("S9122C4", this);} // tgen

static void Test_S9122C4()
{
  extern Class_Descriptor cd_S9122C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9122C4, buf);
    S9122C4 *dp, &lv = *(dp=new (buf) S9122C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9122C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C4)");
    test_class_info(&lv, &cd_S9122C4);
    dp->~S9122C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C4(Test_S9122C4, "S9122C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9122C4C1Ev();
extern void _ZN7S9122C4D1Ev();
Name_Map name_map_S9122C4[] = {
  NSPAIR(_ZN7S9122C4C1Ev),
  NSPAIR(_ZN7S9122C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9122C4[];
extern void _ZN7S9122C4D1Ev();
extern void _ZN7S9122C4D0Ev();
extern void _ZN7S9122C43v40Ev();
static  VTBL_ENTRY vtc_S9122C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9122C4[0]),
  (VTBL_ENTRY)&_ZN7S9122C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9122C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9122C43v40Ev,
};
extern VTBL_ENTRY _ZTI7S9122C4[];
extern  VTBL_ENTRY _ZTV7S9122C4[];
Class_Descriptor cd_S9122C4 = {  "S9122C4", // class name
  0,0,//no base classes
  &(vtc_S9122C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9122C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9122C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C6_nt  {
  long s9122c6f0[4];
};
//SIG(-1 S9122C6_nt) C1{ Fl[4]}



//skip512 S9122C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C5_nt  {
  ::S9122C6_nt s9122c5f0;
  void  mf9122c5(); // _ZN10S9122C5_nt8mf9122c5Ev
};
//SIG(-1 S9122C5_nt) C1{ m FC2{ Fl[4]}}


void  S9122C5_nt ::mf9122c5(){}

//skip512 S9122C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C12  {
  void *s9122c12f0;
  int s9122c12f1;
  void  mf9122c12(); // _ZN8S9122C129mf9122c12Ev
  virtual  ~S9122C12(); // _ZN8S9122C12D1Ev
  S9122C12(); // tgen
};
//SIG(-1 S9122C12) C1{ vd m Fp Fi}


void  S9122C12 ::mf9122c12(){}
 S9122C12 ::~S9122C12(){ note_dtor("S9122C12", this);}
S9122C12 ::S9122C12(){ note_ctor("S9122C12", this);} // tgen

static void Test_S9122C12()
{
  extern Class_Descriptor cd_S9122C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S9122C12, buf);
    S9122C12 *dp, &lv = *(dp=new (buf) S9122C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S9122C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C12)");
    check_field_offset(lv, s9122c12f0, ABISELECT(8,4), "S9122C12.s9122c12f0");
    check_field_offset(lv, s9122c12f1, ABISELECT(16,8), "S9122C12.s9122c12f1");
    test_class_info(&lv, &cd_S9122C12);
    dp->~S9122C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C12(Test_S9122C12, "S9122C12", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S9122C12C1Ev();
extern void _ZN8S9122C12D1Ev();
Name_Map name_map_S9122C12[] = {
  NSPAIR(_ZN8S9122C12C1Ev),
  NSPAIR(_ZN8S9122C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9122C12[];
extern void _ZN8S9122C12D1Ev();
extern void _ZN8S9122C12D0Ev();
static  VTBL_ENTRY vtc_S9122C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9122C12[0]),
  (VTBL_ENTRY)&_ZN8S9122C12D1Ev,
  (VTBL_ENTRY)&_ZN8S9122C12D0Ev,
};
extern VTBL_ENTRY _ZTI8S9122C12[];
extern  VTBL_ENTRY _ZTV8S9122C12[];
Class_Descriptor cd_S9122C12 = {  "S9122C12", // class name
  0,0,//no base classes
  &(vtc_S9122C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S9122C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9122C12),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C14  {
  int s9122c14f0;
  char s9122c14f1[3];
  virtual  ~S9122C14(); // _ZN8S9122C14D1Ev
  virtual void  v42(); // _ZN8S9122C143v42Ev
  S9122C14(); // tgen
};
//SIG(-1 S9122C14) C1{ vd v1 Fi Fc[3]}


 S9122C14 ::~S9122C14(){ note_dtor("S9122C14", this);}
void  S9122C14 ::v42(){vfunc_called(this, "_ZN8S9122C143v42Ev");}
S9122C14 ::S9122C14(){ note_ctor("S9122C14", this);} // tgen

static void Test_S9122C14()
{
  extern Class_Descriptor cd_S9122C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S9122C14, buf);
    S9122C14 *dp, &lv = *(dp=new (buf) S9122C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9122C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C14)");
    check_field_offset(lv, s9122c14f0, ABISELECT(8,4), "S9122C14.s9122c14f0");
    check_field_offset(lv, s9122c14f1, ABISELECT(12,8), "S9122C14.s9122c14f1");
    test_class_info(&lv, &cd_S9122C14);
    dp->~S9122C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C14(Test_S9122C14, "S9122C14", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN8S9122C14C1Ev();
extern void _ZN8S9122C14D1Ev();
Name_Map name_map_S9122C14[] = {
  NSPAIR(_ZN8S9122C14C1Ev),
  NSPAIR(_ZN8S9122C14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9122C14[];
extern void _ZN8S9122C14D1Ev();
extern void _ZN8S9122C14D0Ev();
extern void _ZN8S9122C143v42Ev();
static  VTBL_ENTRY vtc_S9122C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9122C14[0]),
  (VTBL_ENTRY)&_ZN8S9122C14D1Ev,
  (VTBL_ENTRY)&_ZN8S9122C14D0Ev,
  (VTBL_ENTRY)&_ZN8S9122C143v42Ev,
};
extern VTBL_ENTRY _ZTI8S9122C14[];
extern  VTBL_ENTRY _ZTV8S9122C14[];
Class_Descriptor cd_S9122C14 = {  "S9122C14", // class name
  0,0,//no base classes
  &(vtc_S9122C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI8S9122C14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9122C14),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C18  {
  int s9122c18f0;
  ::S9122C5_nt s9122c18f1;
  ::S9123C19_nt s9122c18f2;
  ::S9123C7_nt s9122c18f3;
  void  mf9122c18(); // _ZN8S9122C189mf9122c18Ev
  virtual  ~S9122C18(); // _ZN8S9122C18D1Ev
  S9122C18(); // tgen
};
//SIG(-1 S9122C18) C1{ vd m Fi FC2{ m FC3{ Fl[4]}} FC4{ m FC5{ m Fp Fi FC6{ m} FC6}} FC7{ BC8{ m Fp Fi FC9{ m} FC9}}}


void  S9122C18 ::mf9122c18(){}
 S9122C18 ::~S9122C18(){ note_dtor("S9122C18", this);}
S9122C18 ::S9122C18(){ note_ctor("S9122C18", this);} // tgen

static void Test_S9122C18()
{
  extern Class_Descriptor cd_S9122C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S9122C18, buf);
    S9122C18 *dp, &lv = *(dp=new (buf) S9122C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S9122C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C18)");
    check_field_offset(lv, s9122c18f0, ABISELECT(8,4), "S9122C18.s9122c18f0");
    check_field_offset(lv, s9122c18f1, ABISELECT(16,8), "S9122C18.s9122c18f1");
    check_field_offset(lv, s9122c18f2, ABISELECT(48,24), "S9122C18.s9122c18f2");
    check_field_offset(lv, s9122c18f3, ABISELECT(64,36), "S9122C18.s9122c18f3");
    test_class_info(&lv, &cd_S9122C18);
    dp->~S9122C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C18(Test_S9122C18, "S9122C18", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN8S9122C18C1Ev();
extern void _ZN8S9122C18D1Ev();
Name_Map name_map_S9122C18[] = {
  NSPAIR(_ZN8S9122C18C1Ev),
  NSPAIR(_ZN8S9122C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9122C18[];
extern void _ZN8S9122C18D1Ev();
extern void _ZN8S9122C18D0Ev();
static  VTBL_ENTRY vtc_S9122C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9122C18[0]),
  (VTBL_ENTRY)&_ZN8S9122C18D1Ev,
  (VTBL_ENTRY)&_ZN8S9122C18D0Ev,
};
extern VTBL_ENTRY _ZTI8S9122C18[];
extern  VTBL_ENTRY _ZTV8S9122C18[];
Class_Descriptor cd_S9122C18 = {  "S9122C18", // class name
  0,0,//no base classes
  &(vtc_S9122C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI8S9122C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9122C18),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C27  : S9123C28 {
};
//SIG(-1 S9122C27) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S9122C27()
{
  extern Class_Descriptor cd_S9122C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S9122C27, buf);
    S9122C27 &lv = *(new (buf) S9122C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9122C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C27)");
    check_base_class_offset(lv, (S9123C28*), 0, "S9122C27");
    test_class_info(&lv, &cd_S9122C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C27(Test_S9122C27, "S9122C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S9123C28;
static Base_Class bases_S9122C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S9122C27 = {  "S9122C27", // class name
  bases_S9122C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C13  : S9122C14 {
  ::S9122C5_nt s9122c13f0;
  ::S9123C16_nt s9122c13f1;
  ::S9122C18 s9122c13f2;
  int s9122c13f3;
  ::S9122C5_nt s9122c13f4;
  ::S9122C27 s9122c13f5;
  virtual  ~S9122C13(); // _ZN8S9122C13D1Ev
  virtual void  v41(); // _ZN8S9122C133v41Ev
  S9122C13(); // tgen
};
//SIG(-1 S9122C13) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 FC3{ m FC4{ Fl[4]}} FC5{ m Fp FC6{ Fi[4]}} FC7{ vd m Fi FC3 FC8{ m FC9{ m Fp Fi FC10{ m} FC10}} FC11{ BC12{ m Fp Fi FC13{ m} FC13}}} Fi FC3 FC14{ BC15{ m Fp Fi FC16{ m} FC16}}}


 S9122C13 ::~S9122C13(){ note_dtor("S9122C13", this);}
void  S9122C13 ::v41(){vfunc_called(this, "_ZN8S9122C133v41Ev");}
S9122C13 ::S9122C13(){ note_ctor("S9122C13", this);} // tgen

static void Test_S9122C13()
{
  extern Class_Descriptor cd_S9122C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,33)];
    init_test(&cd_S9122C13, buf);
    S9122C13 *dp, &lv = *(dp=new (buf) S9122C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,128), "sizeof(S9122C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C13)");
    check_base_class_offset(lv, (S9122C14*), 0, "S9122C13");
    check_field_offset(lv, s9122c13f0, ABISELECT(16,12), "S9122C13.s9122c13f0");
    check_field_offset(lv, s9122c13f1, ABISELECT(48,28), "S9122C13.s9122c13f1");
    check_field_offset(lv, s9122c13f2, ABISELECT(72,48), "S9122C13.s9122c13f2");
    check_field_offset(lv, s9122c13f3, ABISELECT(152,96), "S9122C13.s9122c13f3");
    check_field_offset(lv, s9122c13f4, ABISELECT(160,100), "S9122C13.s9122c13f4");
    check_field_offset(lv, s9122c13f5, ABISELECT(192,116), "S9122C13.s9122c13f5");
    test_class_info(&lv, &cd_S9122C13);
    dp->~S9122C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C13(Test_S9122C13, "S9122C13", ABISELECT(208,128));

#else // __cplusplus

extern void _ZN8S9122C13C1Ev();
extern void _ZN8S9122C13D1Ev();
Name_Map name_map_S9122C13[] = {
  NSPAIR(_ZN8S9122C13C1Ev),
  NSPAIR(_ZN8S9122C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9122C14;
extern VTBL_ENTRY _ZTI8S9122C14[];
extern  VTBL_ENTRY _ZTV8S9122C14[];
static Base_Class bases_S9122C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9122C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9122C13[];
extern void _ZN8S9122C13D1Ev();
extern void _ZN8S9122C13D0Ev();
extern void _ZN8S9122C143v42Ev();
extern void _ZN8S9122C133v41Ev();
static  VTBL_ENTRY vtc_S9122C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9122C13[0]),
  (VTBL_ENTRY)&_ZN8S9122C13D1Ev,
  (VTBL_ENTRY)&_ZN8S9122C13D0Ev,
  (VTBL_ENTRY)&_ZN8S9122C143v42Ev,
  (VTBL_ENTRY)&_ZN8S9122C133v41Ev,
};
extern VTBL_ENTRY _ZTI8S9122C13[];
extern  VTBL_ENTRY _ZTV8S9122C13[];
Class_Descriptor cd_S9122C13 = {  "S9122C13", // class name
  bases_S9122C13, 1,
  &(vtc_S9122C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,128), // object size
  NSPAIRA(_ZTI8S9122C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9122C13),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C36_nt  {
  long s9122c36f0;
};
//SIG(-1 S9122C36_nt) C1{ Fl}



//skip512 S9122C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C34  : S9123C35_nt {
  int s9122c34f0[2];
  void *s9122c34f1;
  int s9122c34f2;
  ::S9122C36_nt s9122c34f3;
  char s9122c34f4;
  ::S9123C37_nt s9122c34f5;
  void *s9122c34f6[2];
  char s9122c34f7;
  void *s9122c34f8;
  ::S9123C37_nt s9122c34f9;
  char s9122c34f10;
  ::S9123C37_nt s9122c34f11;
  char s9122c34f12;
  int s9122c34f13;
  void *s9122c34f14[2];
  int s9122c34f15;
  char s9122c34f16;
  int s9122c34f17;
  void *s9122c34f18[3];
  int s9122c34f19;
  virtual  ~S9122C34(); // _ZN8S9122C34D1Ev
  S9122C34(); // tgen
};
//SIG(-1 S9122C34) C1{ BC2{ vd m Fi} vd Fi[2] Fp Fi FC3{ Fl} Fc FC4{ Fc[12]} Fp[2] Fc Fp FC4 Fc FC4 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi}


 S9122C34 ::~S9122C34(){ note_dtor("S9122C34", this);}
S9122C34 ::S9122C34(){ note_ctor("S9122C34", this);} // tgen

static void Test_S9122C34()
{
  extern Class_Descriptor cd_S9122C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,33)];
    init_test(&cd_S9122C34, buf);
    S9122C34 *dp, &lv = *(dp=new (buf) S9122C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,128), "sizeof(S9122C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C34)");
    check_base_class_offset(lv, (S9123C35_nt*), 0, "S9122C34");
    check_field_offset(lv, s9122c34f0, ABISELECT(12,8), "S9122C34.s9122c34f0");
    check_field_offset(lv, s9122c34f1, ABISELECT(24,16), "S9122C34.s9122c34f1");
    check_field_offset(lv, s9122c34f2, ABISELECT(32,20), "S9122C34.s9122c34f2");
    check_field_offset(lv, s9122c34f3, ABISELECT(40,24), "S9122C34.s9122c34f3");
    check_field_offset(lv, s9122c34f4, ABISELECT(48,28), "S9122C34.s9122c34f4");
    check_field_offset(lv, s9122c34f5, ABISELECT(49,29), "S9122C34.s9122c34f5");
    check_field_offset(lv, s9122c34f6, ABISELECT(64,44), "S9122C34.s9122c34f6");
    check_field_offset(lv, s9122c34f7, ABISELECT(80,52), "S9122C34.s9122c34f7");
    check_field_offset(lv, s9122c34f8, ABISELECT(88,56), "S9122C34.s9122c34f8");
    check_field_offset(lv, s9122c34f9, ABISELECT(96,60), "S9122C34.s9122c34f9");
    check_field_offset(lv, s9122c34f10, ABISELECT(108,72), "S9122C34.s9122c34f10");
    check_field_offset(lv, s9122c34f11, ABISELECT(109,73), "S9122C34.s9122c34f11");
    check_field_offset(lv, s9122c34f12, ABISELECT(121,85), "S9122C34.s9122c34f12");
    check_field_offset(lv, s9122c34f13, ABISELECT(124,88), "S9122C34.s9122c34f13");
    check_field_offset(lv, s9122c34f14, ABISELECT(128,92), "S9122C34.s9122c34f14");
    check_field_offset(lv, s9122c34f15, ABISELECT(144,100), "S9122C34.s9122c34f15");
    check_field_offset(lv, s9122c34f16, ABISELECT(148,104), "S9122C34.s9122c34f16");
    check_field_offset(lv, s9122c34f17, ABISELECT(152,108), "S9122C34.s9122c34f17");
    check_field_offset(lv, s9122c34f18, ABISELECT(160,112), "S9122C34.s9122c34f18");
    check_field_offset(lv, s9122c34f19, ABISELECT(184,124), "S9122C34.s9122c34f19");
    test_class_info(&lv, &cd_S9122C34);
    dp->~S9122C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C34(Test_S9122C34, "S9122C34", ABISELECT(192,128));

#else // __cplusplus

extern void _ZN8S9122C34C1Ev();
extern void _ZN8S9122C34D1Ev();
Name_Map name_map_S9122C34[] = {
  NSPAIR(_ZN8S9122C34C1Ev),
  NSPAIR(_ZN8S9122C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9123C35_nt;
extern VTBL_ENTRY _ZTI11S9123C35_nt[];
extern  VTBL_ENTRY _ZTV11S9123C35_nt[];
static Base_Class bases_S9122C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9123C35_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9122C34[];
extern void _ZN8S9122C34D1Ev();
extern void _ZN8S9122C34D0Ev();
static  VTBL_ENTRY vtc_S9122C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9122C34[0]),
  (VTBL_ENTRY)&_ZN8S9122C34D1Ev,
  (VTBL_ENTRY)&_ZN8S9122C34D0Ev,
};
extern VTBL_ENTRY _ZTI8S9122C34[];
extern  VTBL_ENTRY _ZTV8S9122C34[];
Class_Descriptor cd_S9122C34 = {  "S9122C34", // class name
  bases_S9122C34, 1,
  &(vtc_S9122C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,128), // object size
  NSPAIRA(_ZTI8S9122C34),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9122C34),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C33  {
  ::S9122C5_nt s9122c33f0;
  int s9122c33f1;
  ::S9122C34 s9122c33f2;
  void *s9122c33f3;
  void  mf9122c33(); // _ZN8S9122C339mf9122c33Ev
  virtual  ~S9122C33(); // _ZN8S9122C33D1Ev
  S9122C33(); // tgen
};
//SIG(-1 S9122C33) C1{ vd m FC2{ m FC3{ Fl[4]}} Fi FC4{ BC5{ vd m Fi} vd Fi[2] Fp Fi FC6{ Fl} Fc FC7{ Fc[12]} Fp[2] Fc Fp FC7 Fc FC7 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi} Fp}


void  S9122C33 ::mf9122c33(){}
 S9122C33 ::~S9122C33(){ note_dtor("S9122C33", this);}
S9122C33 ::S9122C33(){ note_ctor("S9122C33", this);} // tgen

static void Test_S9122C33()
{
  extern Class_Descriptor cd_S9122C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,40)];
    init_test(&cd_S9122C33, buf);
    S9122C33 *dp, &lv = *(dp=new (buf) S9122C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,156), "sizeof(S9122C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C33)");
    check_field_offset(lv, s9122c33f0, ABISELECT(8,4), "S9122C33.s9122c33f0");
    check_field_offset(lv, s9122c33f1, ABISELECT(40,20), "S9122C33.s9122c33f1");
    check_field_offset(lv, s9122c33f2, ABISELECT(48,24), "S9122C33.s9122c33f2");
    check_field_offset(lv, s9122c33f3, ABISELECT(240,152), "S9122C33.s9122c33f3");
    test_class_info(&lv, &cd_S9122C33);
    dp->~S9122C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C33(Test_S9122C33, "S9122C33", ABISELECT(248,156));

#else // __cplusplus

extern void _ZN8S9122C33C1Ev();
extern void _ZN8S9122C33D1Ev();
Name_Map name_map_S9122C33[] = {
  NSPAIR(_ZN8S9122C33C1Ev),
  NSPAIR(_ZN8S9122C33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9122C33[];
extern void _ZN8S9122C33D1Ev();
extern void _ZN8S9122C33D0Ev();
static  VTBL_ENTRY vtc_S9122C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9122C33[0]),
  (VTBL_ENTRY)&_ZN8S9122C33D1Ev,
  (VTBL_ENTRY)&_ZN8S9122C33D0Ev,
};
extern VTBL_ENTRY _ZTI8S9122C33[];
extern  VTBL_ENTRY _ZTV8S9122C33[];
Class_Descriptor cd_S9122C33 = {  "S9122C33", // class name
  0,0,//no base classes
  &(vtc_S9122C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,156), // object size
  NSPAIRA(_ZTI8S9122C33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9122C33),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9122C1  : S9122C2 , S9122C3 , S9122C4 {
  void *s9122c1f0;
  ::S9122C5_nt s9122c1f1;
  ::S9123C27 s9122c1f2;
  int s9122c1f3;
  ::S9123C11_nt s9122c1f4;
  ::S9122C12 s9122c1f5;
  ::S9122C13 s9122c1f6;
  ::S9123C31 s9122c1f7;
  void *s9122c1f8;
  ::S9122C33 s9122c1f9;
  virtual  ~S9122C1(); // _ZN7S9122C1D1Ev
  virtual void  v1(); // _ZN7S9122C12v1Ev
  virtual void  v2(); // _ZN7S9122C12v2Ev
  virtual void  v3(); // _ZN7S9122C12v3Ev
  virtual void  v4(); // _ZN7S9122C12v4Ev
  virtual void  v5(); // _ZN7S9122C12v5Ev
  virtual void  v6(); // _ZN7S9122C12v6Ev
  virtual void  v7(); // _ZN7S9122C12v7Ev
  virtual void  v8(); // _ZN7S9122C12v8Ev
  virtual void  v9(); // _ZN7S9122C12v9Ev
  virtual void  v10(); // _ZN7S9122C13v10Ev
  virtual void  v11(); // _ZN7S9122C13v11Ev
  virtual void  v12(); // _ZN7S9122C13v12Ev
  virtual void  v13(); // _ZN7S9122C13v13Ev
  virtual void  v14(); // _ZN7S9122C13v14Ev
  virtual void  v15(); // _ZN7S9122C13v15Ev
  virtual void  v16(); // _ZN7S9122C13v16Ev
  virtual void  v17(); // _ZN7S9122C13v17Ev
  virtual void  v18(); // _ZN7S9122C13v18Ev
  virtual void  v19(); // _ZN7S9122C13v19Ev
  virtual void  v20(); // _ZN7S9122C13v20Ev
  S9122C1(); // tgen
};
//SIG(1 S9122C1) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30} BC3{ vd v31 v32 v33 v34 v35 v36 v37 v38 v39} BC4{ vd v40} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp FC5{ m FC6{ Fl[4]}} FC7{ BC8{ m Fp Fi FC9{ m} FC9}} Fi FC10{ vd m Fp Fi} FC11{ vd m Fp Fi} FC12{ BC13{ vd v42 Fi Fc[3]} vd v41 FC5 FC14{ m Fp FC15{ Fi[4]}} FC16{ vd m Fi FC5 FC17{ m FC18{ m Fp Fi FC19{ m} FC19}} FC20{ BC21{ m Fp Fi FC22{ m} FC22}}} Fi FC5 FC23{ BC8}} FC24{ BC25{ vd v48 v49 v50 v51 v52} vd v43 v44 v45 v46 v47} Fp FC26{ vd m FC5 Fi FC27{ BC28{ vd m Fi} vd Fi[2] Fp Fi FC29{ Fl} Fc FC30{ Fc[12]} Fp[2] Fc Fp FC30 Fc FC30 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi} Fp}}


 S9122C1 ::~S9122C1(){ note_dtor("S9122C1", this);}
void  S9122C1 ::v1(){vfunc_called(this, "_ZN7S9122C12v1Ev");}
void  S9122C1 ::v2(){vfunc_called(this, "_ZN7S9122C12v2Ev");}
void  S9122C1 ::v3(){vfunc_called(this, "_ZN7S9122C12v3Ev");}
void  S9122C1 ::v4(){vfunc_called(this, "_ZN7S9122C12v4Ev");}
void  S9122C1 ::v5(){vfunc_called(this, "_ZN7S9122C12v5Ev");}
void  S9122C1 ::v6(){vfunc_called(this, "_ZN7S9122C12v6Ev");}
void  S9122C1 ::v7(){vfunc_called(this, "_ZN7S9122C12v7Ev");}
void  S9122C1 ::v8(){vfunc_called(this, "_ZN7S9122C12v8Ev");}
void  S9122C1 ::v9(){vfunc_called(this, "_ZN7S9122C12v9Ev");}
void  S9122C1 ::v10(){vfunc_called(this, "_ZN7S9122C13v10Ev");}
void  S9122C1 ::v11(){vfunc_called(this, "_ZN7S9122C13v11Ev");}
void  S9122C1 ::v12(){vfunc_called(this, "_ZN7S9122C13v12Ev");}
void  S9122C1 ::v13(){vfunc_called(this, "_ZN7S9122C13v13Ev");}
void  S9122C1 ::v14(){vfunc_called(this, "_ZN7S9122C13v14Ev");}
void  S9122C1 ::v15(){vfunc_called(this, "_ZN7S9122C13v15Ev");}
void  S9122C1 ::v16(){vfunc_called(this, "_ZN7S9122C13v16Ev");}
void  S9122C1 ::v17(){vfunc_called(this, "_ZN7S9122C13v17Ev");}
void  S9122C1 ::v18(){vfunc_called(this, "_ZN7S9122C13v18Ev");}
void  S9122C1 ::v19(){vfunc_called(this, "_ZN7S9122C13v19Ev");}
void  S9122C1 ::v20(){vfunc_called(this, "_ZN7S9122C13v20Ev");}
S9122C1 ::S9122C1(){ note_ctor("S9122C1", this);} // tgen

static void Test_S9122C1()
{
  extern Class_Descriptor cd_S9122C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(77,92)];
    init_test(&cd_S9122C1, buf);
    S9122C1 *dp, &lv = *(dp=new (buf) S9122C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,364), "sizeof(S9122C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9122C1)");
    check_base_class_offset(lv, (S9122C2*), 0, "S9122C1");
    check_base_class_offset(lv, (S9122C3*), ABISELECT(8,4), "S9122C1");
    check_base_class_offset(lv, (S9122C4*), ABISELECT(16,8), "S9122C1");
    check_field_offset(lv, s9122c1f0, ABISELECT(24,12), "S9122C1.s9122c1f0");
    check_field_offset(lv, s9122c1f1, ABISELECT(32,16), "S9122C1.s9122c1f1");
    check_field_offset(lv, s9122c1f2, ABISELECT(64,32), "S9122C1.s9122c1f2");
    check_field_offset(lv, s9122c1f3, ABISELECT(80,44), "S9122C1.s9122c1f3");
    check_field_offset(lv, s9122c1f4, ABISELECT(88,48), "S9122C1.s9122c1f4");
    check_field_offset(lv, s9122c1f5, ABISELECT(112,60), "S9122C1.s9122c1f5");
    check_field_offset(lv, s9122c1f6, ABISELECT(136,72), "S9122C1.s9122c1f6");
    check_field_offset(lv, s9122c1f7, ABISELECT(344,200), "S9122C1.s9122c1f7");
    check_field_offset(lv, s9122c1f8, ABISELECT(352,204), "S9122C1.s9122c1f8");
    check_field_offset(lv, s9122c1f9, ABISELECT(360,208), "S9122C1.s9122c1f9");
    test_class_info(&lv, &cd_S9122C1);
    dp->~S9122C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9122C1(Test_S9122C1, "S9122C1", ABISELECT(608,364));

#else // __cplusplus

extern void _ZN7S9122C1C1Ev();
extern void _ZN7S9122C1D1Ev();
Name_Map name_map_S9122C1[] = {
  NSPAIR(_ZN7S9122C1C1Ev),
  NSPAIR(_ZN7S9122C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9122C2;
extern VTBL_ENTRY _ZTI7S9122C2[];
extern  VTBL_ENTRY _ZTV7S9122C2[];
extern Class_Descriptor cd_S9122C3;
extern VTBL_ENTRY _ZTI7S9122C3[];
extern  VTBL_ENTRY _ZTV7S9122C3[];
extern Class_Descriptor cd_S9122C4;
extern VTBL_ENTRY _ZTI7S9122C4[];
extern  VTBL_ENTRY _ZTV7S9122C4[];
static Base_Class bases_S9122C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9122C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9122C3,    ABISELECT(8,4), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9122C4,    ABISELECT(16,8), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9122C1[];
extern void _ZN7S9122C1D1Ev();
extern void _ZN7S9122C1D0Ev();
extern void _ZN7S9122C23v21Ev();
extern void _ZN7S9122C23v22Ev();
extern void _ZN7S9122C23v23Ev();
extern void _ZN7S9122C23v24Ev();
extern void _ZN7S9122C23v25Ev();
extern void _ZN7S9122C23v26Ev();
extern void _ZN7S9122C23v27Ev();
extern void _ZN7S9122C23v28Ev();
extern void _ZN7S9122C23v29Ev();
extern void _ZN7S9122C23v30Ev();
extern void _ZN7S9122C12v1Ev();
extern void _ZN7S9122C12v2Ev();
extern void _ZN7S9122C12v3Ev();
extern void _ZN7S9122C12v4Ev();
extern void _ZN7S9122C12v5Ev();
extern void _ZN7S9122C12v6Ev();
extern void _ZN7S9122C12v7Ev();
extern void _ZN7S9122C12v8Ev();
extern void _ZN7S9122C12v9Ev();
extern void _ZN7S9122C13v10Ev();
extern void _ZN7S9122C13v11Ev();
extern void _ZN7S9122C13v12Ev();
extern void _ZN7S9122C13v13Ev();
extern void _ZN7S9122C13v14Ev();
extern void _ZN7S9122C13v15Ev();
extern void _ZN7S9122C13v16Ev();
extern void _ZN7S9122C13v17Ev();
extern void _ZN7S9122C13v18Ev();
extern void _ZN7S9122C13v19Ev();
extern void _ZN7S9122C13v20Ev();
extern void ABISELECT(_ZThn8_N7S9122C1D1Ev,_ZThn4_N7S9122C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9122C1D0Ev,_ZThn4_N7S9122C1D0Ev)();
extern void _ZN7S9122C33v31Ev();
extern void _ZN7S9122C33v32Ev();
extern void _ZN7S9122C33v33Ev();
extern void _ZN7S9122C33v34Ev();
extern void _ZN7S9122C33v35Ev();
extern void _ZN7S9122C33v36Ev();
extern void _ZN7S9122C33v37Ev();
extern void _ZN7S9122C33v38Ev();
extern void _ZN7S9122C33v39Ev();
extern void ABISELECT(_ZThn16_N7S9122C1D1Ev,_ZThn8_N7S9122C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S9122C1D0Ev,_ZThn8_N7S9122C1D0Ev)();
extern void _ZN7S9122C43v40Ev();
static  VTBL_ENTRY vtc_S9122C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9122C1[0]),
  (VTBL_ENTRY)&_ZN7S9122C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9122C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v21Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v22Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v23Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v24Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v25Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v26Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v27Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v28Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v29Ev,
  (VTBL_ENTRY)&_ZN7S9122C23v30Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9122C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9122C13v20Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9122C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9122C1D1Ev,_ZThn4_N7S9122C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9122C1D0Ev,_ZThn4_N7S9122C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9122C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9122C33v39Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S9122C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S9122C1D1Ev,_ZThn8_N7S9122C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S9122C1D0Ev,_ZThn8_N7S9122C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9122C43v40Ev,
};
extern VTBL_ENTRY _ZTI7S9122C1[];
extern  VTBL_ENTRY _ZTV7S9122C1[];
Class_Descriptor cd_S9122C1 = {  "S9122C1", // class name
  bases_S9122C1, 3,
  &(vtc_S9122C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,364), // object size
  NSPAIRA(_ZTI7S9122C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S9122C1),52, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C2  {
  virtual  ~S9124C2(); // _ZN7S9124C2D1Ev
  virtual void  v21(); // _ZN7S9124C23v21Ev
  virtual void  v22(); // _ZN7S9124C23v22Ev
  virtual void  v23(); // _ZN7S9124C23v23Ev
  virtual void  v24(); // _ZN7S9124C23v24Ev
  virtual void  v25(); // _ZN7S9124C23v25Ev
  virtual void  v26(); // _ZN7S9124C23v26Ev
  virtual void  v27(); // _ZN7S9124C23v27Ev
  virtual void  v28(); // _ZN7S9124C23v28Ev
  virtual void  v29(); // _ZN7S9124C23v29Ev
  virtual void  v30(); // _ZN7S9124C23v30Ev
  S9124C2(); // tgen
};
//SIG(-1 S9124C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S9124C2 ::~S9124C2(){ note_dtor("S9124C2", this);}
void  S9124C2 ::v21(){vfunc_called(this, "_ZN7S9124C23v21Ev");}
void  S9124C2 ::v22(){vfunc_called(this, "_ZN7S9124C23v22Ev");}
void  S9124C2 ::v23(){vfunc_called(this, "_ZN7S9124C23v23Ev");}
void  S9124C2 ::v24(){vfunc_called(this, "_ZN7S9124C23v24Ev");}
void  S9124C2 ::v25(){vfunc_called(this, "_ZN7S9124C23v25Ev");}
void  S9124C2 ::v26(){vfunc_called(this, "_ZN7S9124C23v26Ev");}
void  S9124C2 ::v27(){vfunc_called(this, "_ZN7S9124C23v27Ev");}
void  S9124C2 ::v28(){vfunc_called(this, "_ZN7S9124C23v28Ev");}
void  S9124C2 ::v29(){vfunc_called(this, "_ZN7S9124C23v29Ev");}
void  S9124C2 ::v30(){vfunc_called(this, "_ZN7S9124C23v30Ev");}
S9124C2 ::S9124C2(){ note_ctor("S9124C2", this);} // tgen

static void Test_S9124C2()
{
  extern Class_Descriptor cd_S9124C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9124C2, buf);
    S9124C2 *dp, &lv = *(dp=new (buf) S9124C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9124C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C2)");
    test_class_info(&lv, &cd_S9124C2);
    dp->~S9124C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C2(Test_S9124C2, "S9124C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9124C2C1Ev();
extern void _ZN7S9124C2D1Ev();
Name_Map name_map_S9124C2[] = {
  NSPAIR(_ZN7S9124C2C1Ev),
  NSPAIR(_ZN7S9124C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9124C2[];
extern void _ZN7S9124C2D1Ev();
extern void _ZN7S9124C2D0Ev();
extern void _ZN7S9124C23v21Ev();
extern void _ZN7S9124C23v22Ev();
extern void _ZN7S9124C23v23Ev();
extern void _ZN7S9124C23v24Ev();
extern void _ZN7S9124C23v25Ev();
extern void _ZN7S9124C23v26Ev();
extern void _ZN7S9124C23v27Ev();
extern void _ZN7S9124C23v28Ev();
extern void _ZN7S9124C23v29Ev();
extern void _ZN7S9124C23v30Ev();
static  VTBL_ENTRY vtc_S9124C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9124C2[0]),
  (VTBL_ENTRY)&_ZN7S9124C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9124C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v21Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v22Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v23Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v24Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v25Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v26Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v27Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v28Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v29Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v30Ev,
};
extern VTBL_ENTRY _ZTI7S9124C2[];
extern  VTBL_ENTRY _ZTV7S9124C2[];
Class_Descriptor cd_S9124C2 = {  "S9124C2", // class name
  0,0,//no base classes
  &(vtc_S9124C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9124C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9124C2),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C3  {
  virtual  ~S9124C3(); // _ZN7S9124C3D1Ev
  virtual void  v31(); // _ZN7S9124C33v31Ev
  virtual void  v32(); // _ZN7S9124C33v32Ev
  virtual void  v33(); // _ZN7S9124C33v33Ev
  virtual void  v34(); // _ZN7S9124C33v34Ev
  virtual void  v35(); // _ZN7S9124C33v35Ev
  virtual void  v36(); // _ZN7S9124C33v36Ev
  virtual void  v37(); // _ZN7S9124C33v37Ev
  virtual void  v38(); // _ZN7S9124C33v38Ev
  virtual void  v39(); // _ZN7S9124C33v39Ev
  S9124C3(); // tgen
};
//SIG(-1 S9124C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S9124C3 ::~S9124C3(){ note_dtor("S9124C3", this);}
void  S9124C3 ::v31(){vfunc_called(this, "_ZN7S9124C33v31Ev");}
void  S9124C3 ::v32(){vfunc_called(this, "_ZN7S9124C33v32Ev");}
void  S9124C3 ::v33(){vfunc_called(this, "_ZN7S9124C33v33Ev");}
void  S9124C3 ::v34(){vfunc_called(this, "_ZN7S9124C33v34Ev");}
void  S9124C3 ::v35(){vfunc_called(this, "_ZN7S9124C33v35Ev");}
void  S9124C3 ::v36(){vfunc_called(this, "_ZN7S9124C33v36Ev");}
void  S9124C3 ::v37(){vfunc_called(this, "_ZN7S9124C33v37Ev");}
void  S9124C3 ::v38(){vfunc_called(this, "_ZN7S9124C33v38Ev");}
void  S9124C3 ::v39(){vfunc_called(this, "_ZN7S9124C33v39Ev");}
S9124C3 ::S9124C3(){ note_ctor("S9124C3", this);} // tgen

static void Test_S9124C3()
{
  extern Class_Descriptor cd_S9124C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9124C3, buf);
    S9124C3 *dp, &lv = *(dp=new (buf) S9124C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9124C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C3)");
    test_class_info(&lv, &cd_S9124C3);
    dp->~S9124C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C3(Test_S9124C3, "S9124C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9124C3C1Ev();
extern void _ZN7S9124C3D1Ev();
Name_Map name_map_S9124C3[] = {
  NSPAIR(_ZN7S9124C3C1Ev),
  NSPAIR(_ZN7S9124C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9124C3[];
extern void _ZN7S9124C3D1Ev();
extern void _ZN7S9124C3D0Ev();
extern void _ZN7S9124C33v31Ev();
extern void _ZN7S9124C33v32Ev();
extern void _ZN7S9124C33v33Ev();
extern void _ZN7S9124C33v34Ev();
extern void _ZN7S9124C33v35Ev();
extern void _ZN7S9124C33v36Ev();
extern void _ZN7S9124C33v37Ev();
extern void _ZN7S9124C33v38Ev();
extern void _ZN7S9124C33v39Ev();
static  VTBL_ENTRY vtc_S9124C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9124C3[0]),
  (VTBL_ENTRY)&_ZN7S9124C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9124C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v39Ev,
};
extern VTBL_ENTRY _ZTI7S9124C3[];
extern  VTBL_ENTRY _ZTV7S9124C3[];
Class_Descriptor cd_S9124C3 = {  "S9124C3", // class name
  0,0,//no base classes
  &(vtc_S9124C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9124C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9124C3),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C4  {
  virtual  ~S9124C4(); // _ZN7S9124C4D1Ev
  virtual void  v40(); // _ZN7S9124C43v40Ev
  S9124C4(); // tgen
};
//SIG(-1 S9124C4) C1{ vd v1}


 S9124C4 ::~S9124C4(){ note_dtor("S9124C4", this);}
void  S9124C4 ::v40(){vfunc_called(this, "_ZN7S9124C43v40Ev");}
S9124C4 ::S9124C4(){ note_ctor("S9124C4", this);} // tgen

static void Test_S9124C4()
{
  extern Class_Descriptor cd_S9124C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9124C4, buf);
    S9124C4 *dp, &lv = *(dp=new (buf) S9124C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9124C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C4)");
    test_class_info(&lv, &cd_S9124C4);
    dp->~S9124C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C4(Test_S9124C4, "S9124C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9124C4C1Ev();
extern void _ZN7S9124C4D1Ev();
Name_Map name_map_S9124C4[] = {
  NSPAIR(_ZN7S9124C4C1Ev),
  NSPAIR(_ZN7S9124C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9124C4[];
extern void _ZN7S9124C4D1Ev();
extern void _ZN7S9124C4D0Ev();
extern void _ZN7S9124C43v40Ev();
static  VTBL_ENTRY vtc_S9124C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9124C4[0]),
  (VTBL_ENTRY)&_ZN7S9124C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9124C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9124C43v40Ev,
};
extern VTBL_ENTRY _ZTI7S9124C4[];
extern  VTBL_ENTRY _ZTV7S9124C4[];
Class_Descriptor cd_S9124C4 = {  "S9124C4", // class name
  0,0,//no base classes
  &(vtc_S9124C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9124C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9124C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C5_nt  {
  __tsi64 s9124c5f0[4];
  void  mf9124c5(); // _ZN10S9124C5_nt8mf9124c5Ev
};
//SIG(-1 S9124C5_nt) C1{ m FL[4]}


void  S9124C5_nt ::mf9124c5(){}

//skip512 S9124C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C13  {
  int s9124c13f0;
  char s9124c13f1[3];
  virtual  ~S9124C13(); // _ZN8S9124C13D1Ev
  virtual void  v42(); // _ZN8S9124C133v42Ev
  S9124C13(); // tgen
};
//SIG(-1 S9124C13) C1{ vd v1 Fi Fc[3]}


 S9124C13 ::~S9124C13(){ note_dtor("S9124C13", this);}
void  S9124C13 ::v42(){vfunc_called(this, "_ZN8S9124C133v42Ev");}
S9124C13 ::S9124C13(){ note_ctor("S9124C13", this);} // tgen

static void Test_S9124C13()
{
  extern Class_Descriptor cd_S9124C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S9124C13, buf);
    S9124C13 *dp, &lv = *(dp=new (buf) S9124C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9124C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C13)");
    check_field_offset(lv, s9124c13f0, ABISELECT(8,4), "S9124C13.s9124c13f0");
    check_field_offset(lv, s9124c13f1, ABISELECT(12,8), "S9124C13.s9124c13f1");
    test_class_info(&lv, &cd_S9124C13);
    dp->~S9124C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C13(Test_S9124C13, "S9124C13", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN8S9124C13C1Ev();
extern void _ZN8S9124C13D1Ev();
Name_Map name_map_S9124C13[] = {
  NSPAIR(_ZN8S9124C13C1Ev),
  NSPAIR(_ZN8S9124C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9124C13[];
extern void _ZN8S9124C13D1Ev();
extern void _ZN8S9124C13D0Ev();
extern void _ZN8S9124C133v42Ev();
static  VTBL_ENTRY vtc_S9124C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9124C13[0]),
  (VTBL_ENTRY)&_ZN8S9124C13D1Ev,
  (VTBL_ENTRY)&_ZN8S9124C13D0Ev,
  (VTBL_ENTRY)&_ZN8S9124C133v42Ev,
};
extern VTBL_ENTRY _ZTI8S9124C13[];
extern  VTBL_ENTRY _ZTV8S9124C13[];
Class_Descriptor cd_S9124C13 = {  "S9124C13", // class name
  0,0,//no base classes
  &(vtc_S9124C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI8S9124C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9124C13),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C17  {
  int s9124c17f0;
  ::S9124C5_nt s9124c17f1;
  ::S9123C19_nt s9124c17f2;
  ::S9123C7_nt s9124c17f3;
  void  mf9124c17(); // _ZN8S9124C179mf9124c17Ev
  virtual  ~S9124C17(); // _ZN8S9124C17D1Ev
  S9124C17(); // tgen
};
//SIG(-1 S9124C17) C1{ vd m Fi FC2{ m FL[4]} FC3{ m FC4{ m Fp Fi FC5{ m} FC5}} FC6{ BC7{ m Fp Fi FC8{ m} FC8}}}


void  S9124C17 ::mf9124c17(){}
 S9124C17 ::~S9124C17(){ note_dtor("S9124C17", this);}
S9124C17 ::S9124C17(){ note_ctor("S9124C17", this);} // tgen

static void Test_S9124C17()
{
  extern Class_Descriptor cd_S9124C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,17)];
    init_test(&cd_S9124C17, buf);
    S9124C17 *dp, &lv = *(dp=new (buf) S9124C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,64), "sizeof(S9124C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C17)");
    check_field_offset(lv, s9124c17f0, ABISELECT(8,4), "S9124C17.s9124c17f0");
    check_field_offset(lv, s9124c17f1, ABISELECT(16,8), "S9124C17.s9124c17f1");
    check_field_offset(lv, s9124c17f2, ABISELECT(48,40), "S9124C17.s9124c17f2");
    check_field_offset(lv, s9124c17f3, ABISELECT(64,52), "S9124C17.s9124c17f3");
    test_class_info(&lv, &cd_S9124C17);
    dp->~S9124C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C17(Test_S9124C17, "S9124C17", ABISELECT(80,64));

#else // __cplusplus

extern void _ZN8S9124C17C1Ev();
extern void _ZN8S9124C17D1Ev();
Name_Map name_map_S9124C17[] = {
  NSPAIR(_ZN8S9124C17C1Ev),
  NSPAIR(_ZN8S9124C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9124C17[];
extern void _ZN8S9124C17D1Ev();
extern void _ZN8S9124C17D0Ev();
static  VTBL_ENTRY vtc_S9124C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9124C17[0]),
  (VTBL_ENTRY)&_ZN8S9124C17D1Ev,
  (VTBL_ENTRY)&_ZN8S9124C17D0Ev,
};
extern VTBL_ENTRY _ZTI8S9124C17[];
extern  VTBL_ENTRY _ZTV8S9124C17[];
Class_Descriptor cd_S9124C17 = {  "S9124C17", // class name
  0,0,//no base classes
  &(vtc_S9124C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,64), // object size
  NSPAIRA(_ZTI8S9124C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9124C17),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C12  : S9124C13 {
  ::S9124C5_nt s9124c12f0;
  ::S9123C16_nt s9124c12f1;
  ::S9124C17 s9124c12f2;
  int s9124c12f3;
  ::S9124C5_nt s9124c12f4;
  ::S9122C27 s9124c12f5;
  virtual  ~S9124C12(); // _ZN8S9124C12D1Ev
  virtual void  v41(); // _ZN8S9124C123v41Ev
  S9124C12(); // tgen
};
//SIG(-1 S9124C12) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 FC3{ m FL[4]} FC4{ m Fp FC5{ Fi[4]}} FC6{ vd m Fi FC3 FC7{ m FC8{ m Fp Fi FC9{ m} FC9}} FC10{ BC11{ m Fp Fi FC12{ m} FC12}}} Fi FC3 FC13{ BC14{ m Fp Fi FC15{ m} FC15}}}


 S9124C12 ::~S9124C12(){ note_dtor("S9124C12", this);}
void  S9124C12 ::v41(){vfunc_called(this, "_ZN8S9124C123v41Ev");}
S9124C12 ::S9124C12(){ note_ctor("S9124C12", this);} // tgen

static void Test_S9124C12()
{
  extern Class_Descriptor cd_S9124C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,45)];
    init_test(&cd_S9124C12, buf);
    S9124C12 *dp, &lv = *(dp=new (buf) S9124C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,176), "sizeof(S9124C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C12)");
    check_base_class_offset(lv, (S9124C13*), 0, "S9124C12");
    check_field_offset(lv, s9124c12f0, ABISELECT(16,12), "S9124C12.s9124c12f0");
    check_field_offset(lv, s9124c12f1, ABISELECT(48,44), "S9124C12.s9124c12f1");
    check_field_offset(lv, s9124c12f2, ABISELECT(72,64), "S9124C12.s9124c12f2");
    check_field_offset(lv, s9124c12f3, ABISELECT(152,128), "S9124C12.s9124c12f3");
    check_field_offset(lv, s9124c12f4, ABISELECT(160,132), "S9124C12.s9124c12f4");
    check_field_offset(lv, s9124c12f5, ABISELECT(192,164), "S9124C12.s9124c12f5");
    test_class_info(&lv, &cd_S9124C12);
    dp->~S9124C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C12(Test_S9124C12, "S9124C12", ABISELECT(208,176));

#else // __cplusplus

extern void _ZN8S9124C12C1Ev();
extern void _ZN8S9124C12D1Ev();
Name_Map name_map_S9124C12[] = {
  NSPAIR(_ZN8S9124C12C1Ev),
  NSPAIR(_ZN8S9124C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9124C13;
extern VTBL_ENTRY _ZTI8S9124C13[];
extern  VTBL_ENTRY _ZTV8S9124C13[];
static Base_Class bases_S9124C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9124C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9124C12[];
extern void _ZN8S9124C12D1Ev();
extern void _ZN8S9124C12D0Ev();
extern void _ZN8S9124C133v42Ev();
extern void _ZN8S9124C123v41Ev();
static  VTBL_ENTRY vtc_S9124C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9124C12[0]),
  (VTBL_ENTRY)&_ZN8S9124C12D1Ev,
  (VTBL_ENTRY)&_ZN8S9124C12D0Ev,
  (VTBL_ENTRY)&_ZN8S9124C133v42Ev,
  (VTBL_ENTRY)&_ZN8S9124C123v41Ev,
};
extern VTBL_ENTRY _ZTI8S9124C12[];
extern  VTBL_ENTRY _ZTV8S9124C12[];
Class_Descriptor cd_S9124C12 = {  "S9124C12", // class name
  bases_S9124C12, 1,
  &(vtc_S9124C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,176), // object size
  NSPAIRA(_ZTI8S9124C12),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9124C12),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C32  {
  ::S9124C5_nt s9124c32f0;
  int s9124c32f1;
  ::S9123C34 s9124c32f2;
  void *s9124c32f3;
  void  mf9124c32(); // _ZN8S9124C329mf9124c32Ev
  virtual  ~S9124C32(); // _ZN8S9124C32D1Ev
  S9124C32(); // tgen
};
//SIG(-1 S9124C32) C1{ vd m FC2{ m FL[4]} Fi FC3{ BC4{ vd m Fi} vd Fi[2] Fp Fi FC5{ FL} Fc FC6{ Fc[12]} Fp[2] Fc Fp FC6 Fc FC6 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi} Fp}


void  S9124C32 ::mf9124c32(){}
 S9124C32 ::~S9124C32(){ note_dtor("S9124C32", this);}
S9124C32 ::S9124C32(){ note_ctor("S9124C32", this);} // tgen

static void Test_S9124C32()
{
  extern Class_Descriptor cd_S9124C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,45)];
    init_test(&cd_S9124C32, buf);
    S9124C32 *dp, &lv = *(dp=new (buf) S9124C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,176), "sizeof(S9124C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C32)");
    check_field_offset(lv, s9124c32f0, ABISELECT(8,4), "S9124C32.s9124c32f0");
    check_field_offset(lv, s9124c32f1, ABISELECT(40,36), "S9124C32.s9124c32f1");
    check_field_offset(lv, s9124c32f2, ABISELECT(48,40), "S9124C32.s9124c32f2");
    check_field_offset(lv, s9124c32f3, ABISELECT(240,172), "S9124C32.s9124c32f3");
    test_class_info(&lv, &cd_S9124C32);
    dp->~S9124C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C32(Test_S9124C32, "S9124C32", ABISELECT(248,176));

#else // __cplusplus

extern void _ZN8S9124C32C1Ev();
extern void _ZN8S9124C32D1Ev();
Name_Map name_map_S9124C32[] = {
  NSPAIR(_ZN8S9124C32C1Ev),
  NSPAIR(_ZN8S9124C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9124C32[];
extern void _ZN8S9124C32D1Ev();
extern void _ZN8S9124C32D0Ev();
static  VTBL_ENTRY vtc_S9124C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9124C32[0]),
  (VTBL_ENTRY)&_ZN8S9124C32D1Ev,
  (VTBL_ENTRY)&_ZN8S9124C32D0Ev,
};
extern VTBL_ENTRY _ZTI8S9124C32[];
extern  VTBL_ENTRY _ZTV8S9124C32[];
Class_Descriptor cd_S9124C32 = {  "S9124C32", // class name
  0,0,//no base classes
  &(vtc_S9124C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,176), // object size
  NSPAIRA(_ZTI8S9124C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9124C32),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9124C1  : S9124C2 , S9124C3 , S9124C4 {
  void *s9124c1f0;
  ::S9124C5_nt s9124c1f1;
  ::S9123C27 s9124c1f2;
  int s9124c1f3;
  ::S9123C11_nt s9124c1f4;
  ::S9122C12 s9124c1f5;
  ::S9124C12 s9124c1f6;
  ::S9123C31 s9124c1f7;
  void *s9124c1f8;
  ::S9124C32 s9124c1f9;
  virtual  ~S9124C1(); // _ZN7S9124C1D1Ev
  virtual void  v1(); // _ZN7S9124C12v1Ev
  virtual void  v2(); // _ZN7S9124C12v2Ev
  virtual void  v3(); // _ZN7S9124C12v3Ev
  virtual void  v4(); // _ZN7S9124C12v4Ev
  virtual void  v5(); // _ZN7S9124C12v5Ev
  virtual void  v6(); // _ZN7S9124C12v6Ev
  virtual void  v7(); // _ZN7S9124C12v7Ev
  virtual void  v8(); // _ZN7S9124C12v8Ev
  virtual void  v9(); // _ZN7S9124C12v9Ev
  virtual void  v10(); // _ZN7S9124C13v10Ev
  virtual void  v11(); // _ZN7S9124C13v11Ev
  virtual void  v12(); // _ZN7S9124C13v12Ev
  virtual void  v13(); // _ZN7S9124C13v13Ev
  virtual void  v14(); // _ZN7S9124C13v14Ev
  virtual void  v15(); // _ZN7S9124C13v15Ev
  virtual void  v16(); // _ZN7S9124C13v16Ev
  virtual void  v17(); // _ZN7S9124C13v17Ev
  virtual void  v18(); // _ZN7S9124C13v18Ev
  virtual void  v19(); // _ZN7S9124C13v19Ev
  virtual void  v20(); // _ZN7S9124C13v20Ev
  S9124C1(); // tgen
};
//SIG(1 S9124C1) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30} BC3{ vd v31 v32 v33 v34 v35 v36 v37 v38 v39} BC4{ vd v40} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp FC5{ m FL[4]} FC6{ BC7{ m Fp Fi FC8{ m} FC8}} Fi FC9{ vd m Fp Fi} FC10{ vd m Fp Fi} FC11{ BC12{ vd v42 Fi Fc[3]} vd v41 FC5 FC13{ m Fp FC14{ Fi[4]}} FC15{ vd m Fi FC5 FC16{ m FC17{ m Fp Fi FC18{ m} FC18}} FC19{ BC20{ m Fp Fi FC21{ m} FC21}}} Fi FC5 FC22{ BC7}} FC23{ BC24{ vd v48 v49 v50 v51 v52} vd v43 v44 v45 v46 v47} Fp FC25{ vd m FC5 Fi FC26{ BC27{ vd m Fi} vd Fi[2] Fp Fi FC28{ FL} Fc FC29{ Fc[12]} Fp[2] Fc Fp FC29 Fc FC29 Fc Fi Fp[2] Fi Fc Fi Fp[3] Fi} Fp}}


 S9124C1 ::~S9124C1(){ note_dtor("S9124C1", this);}
void  S9124C1 ::v1(){vfunc_called(this, "_ZN7S9124C12v1Ev");}
void  S9124C1 ::v2(){vfunc_called(this, "_ZN7S9124C12v2Ev");}
void  S9124C1 ::v3(){vfunc_called(this, "_ZN7S9124C12v3Ev");}
void  S9124C1 ::v4(){vfunc_called(this, "_ZN7S9124C12v4Ev");}
void  S9124C1 ::v5(){vfunc_called(this, "_ZN7S9124C12v5Ev");}
void  S9124C1 ::v6(){vfunc_called(this, "_ZN7S9124C12v6Ev");}
void  S9124C1 ::v7(){vfunc_called(this, "_ZN7S9124C12v7Ev");}
void  S9124C1 ::v8(){vfunc_called(this, "_ZN7S9124C12v8Ev");}
void  S9124C1 ::v9(){vfunc_called(this, "_ZN7S9124C12v9Ev");}
void  S9124C1 ::v10(){vfunc_called(this, "_ZN7S9124C13v10Ev");}
void  S9124C1 ::v11(){vfunc_called(this, "_ZN7S9124C13v11Ev");}
void  S9124C1 ::v12(){vfunc_called(this, "_ZN7S9124C13v12Ev");}
void  S9124C1 ::v13(){vfunc_called(this, "_ZN7S9124C13v13Ev");}
void  S9124C1 ::v14(){vfunc_called(this, "_ZN7S9124C13v14Ev");}
void  S9124C1 ::v15(){vfunc_called(this, "_ZN7S9124C13v15Ev");}
void  S9124C1 ::v16(){vfunc_called(this, "_ZN7S9124C13v16Ev");}
void  S9124C1 ::v17(){vfunc_called(this, "_ZN7S9124C13v17Ev");}
void  S9124C1 ::v18(){vfunc_called(this, "_ZN7S9124C13v18Ev");}
void  S9124C1 ::v19(){vfunc_called(this, "_ZN7S9124C13v19Ev");}
void  S9124C1 ::v20(){vfunc_called(this, "_ZN7S9124C13v20Ev");}
S9124C1 ::S9124C1(){ note_ctor("S9124C1", this);} // tgen

static void Test_S9124C1()
{
  extern Class_Descriptor cd_S9124C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(77,113)];
    init_test(&cd_S9124C1, buf);
    S9124C1 *dp, &lv = *(dp=new (buf) S9124C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,448), "sizeof(S9124C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9124C1)");
    check_base_class_offset(lv, (S9124C2*), 0, "S9124C1");
    check_base_class_offset(lv, (S9124C3*), ABISELECT(8,4), "S9124C1");
    check_base_class_offset(lv, (S9124C4*), ABISELECT(16,8), "S9124C1");
    check_field_offset(lv, s9124c1f0, ABISELECT(24,12), "S9124C1.s9124c1f0");
    check_field_offset(lv, s9124c1f1, ABISELECT(32,16), "S9124C1.s9124c1f1");
    check_field_offset(lv, s9124c1f2, ABISELECT(64,48), "S9124C1.s9124c1f2");
    check_field_offset(lv, s9124c1f3, ABISELECT(80,60), "S9124C1.s9124c1f3");
    check_field_offset(lv, s9124c1f4, ABISELECT(88,64), "S9124C1.s9124c1f4");
    check_field_offset(lv, s9124c1f5, ABISELECT(112,76), "S9124C1.s9124c1f5");
    check_field_offset(lv, s9124c1f6, ABISELECT(136,88), "S9124C1.s9124c1f6");
    check_field_offset(lv, s9124c1f7, ABISELECT(344,264), "S9124C1.s9124c1f7");
    check_field_offset(lv, s9124c1f8, ABISELECT(352,268), "S9124C1.s9124c1f8");
    check_field_offset(lv, s9124c1f9, ABISELECT(360,272), "S9124C1.s9124c1f9");
    test_class_info(&lv, &cd_S9124C1);
    dp->~S9124C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9124C1(Test_S9124C1, "S9124C1", ABISELECT(608,448));

#else // __cplusplus

extern void _ZN7S9124C1C1Ev();
extern void _ZN7S9124C1D1Ev();
Name_Map name_map_S9124C1[] = {
  NSPAIR(_ZN7S9124C1C1Ev),
  NSPAIR(_ZN7S9124C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9124C2;
extern VTBL_ENTRY _ZTI7S9124C2[];
extern  VTBL_ENTRY _ZTV7S9124C2[];
extern Class_Descriptor cd_S9124C3;
extern VTBL_ENTRY _ZTI7S9124C3[];
extern  VTBL_ENTRY _ZTV7S9124C3[];
extern Class_Descriptor cd_S9124C4;
extern VTBL_ENTRY _ZTI7S9124C4[];
extern  VTBL_ENTRY _ZTV7S9124C4[];
static Base_Class bases_S9124C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9124C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9124C3,    ABISELECT(8,4), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9124C4,    ABISELECT(16,8), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9124C1[];
extern void _ZN7S9124C1D1Ev();
extern void _ZN7S9124C1D0Ev();
extern void _ZN7S9124C23v21Ev();
extern void _ZN7S9124C23v22Ev();
extern void _ZN7S9124C23v23Ev();
extern void _ZN7S9124C23v24Ev();
extern void _ZN7S9124C23v25Ev();
extern void _ZN7S9124C23v26Ev();
extern void _ZN7S9124C23v27Ev();
extern void _ZN7S9124C23v28Ev();
extern void _ZN7S9124C23v29Ev();
extern void _ZN7S9124C23v30Ev();
extern void _ZN7S9124C12v1Ev();
extern void _ZN7S9124C12v2Ev();
extern void _ZN7S9124C12v3Ev();
extern void _ZN7S9124C12v4Ev();
extern void _ZN7S9124C12v5Ev();
extern void _ZN7S9124C12v6Ev();
extern void _ZN7S9124C12v7Ev();
extern void _ZN7S9124C12v8Ev();
extern void _ZN7S9124C12v9Ev();
extern void _ZN7S9124C13v10Ev();
extern void _ZN7S9124C13v11Ev();
extern void _ZN7S9124C13v12Ev();
extern void _ZN7S9124C13v13Ev();
extern void _ZN7S9124C13v14Ev();
extern void _ZN7S9124C13v15Ev();
extern void _ZN7S9124C13v16Ev();
extern void _ZN7S9124C13v17Ev();
extern void _ZN7S9124C13v18Ev();
extern void _ZN7S9124C13v19Ev();
extern void _ZN7S9124C13v20Ev();
extern void ABISELECT(_ZThn8_N7S9124C1D1Ev,_ZThn4_N7S9124C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9124C1D0Ev,_ZThn4_N7S9124C1D0Ev)();
extern void _ZN7S9124C33v31Ev();
extern void _ZN7S9124C33v32Ev();
extern void _ZN7S9124C33v33Ev();
extern void _ZN7S9124C33v34Ev();
extern void _ZN7S9124C33v35Ev();
extern void _ZN7S9124C33v36Ev();
extern void _ZN7S9124C33v37Ev();
extern void _ZN7S9124C33v38Ev();
extern void _ZN7S9124C33v39Ev();
extern void ABISELECT(_ZThn16_N7S9124C1D1Ev,_ZThn8_N7S9124C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S9124C1D0Ev,_ZThn8_N7S9124C1D0Ev)();
extern void _ZN7S9124C43v40Ev();
static  VTBL_ENTRY vtc_S9124C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9124C1[0]),
  (VTBL_ENTRY)&_ZN7S9124C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9124C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v21Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v22Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v23Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v24Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v25Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v26Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v27Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v28Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v29Ev,
  (VTBL_ENTRY)&_ZN7S9124C23v30Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9124C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9124C13v20Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9124C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9124C1D1Ev,_ZThn4_N7S9124C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9124C1D0Ev,_ZThn4_N7S9124C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9124C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9124C33v39Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S9124C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S9124C1D1Ev,_ZThn8_N7S9124C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S9124C1D0Ev,_ZThn8_N7S9124C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9124C43v40Ev,
};
extern VTBL_ENTRY _ZTI7S9124C1[];
extern  VTBL_ENTRY _ZTV7S9124C1[];
Class_Descriptor cd_S9124C1 = {  "S9124C1", // class name
  bases_S9124C1, 3,
  &(vtc_S9124C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,448), // object size
  NSPAIRA(_ZTI7S9124C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S9124C1),52, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10168C2  {
  virtual  ~S10168C2(); // _ZN8S10168C2D1Ev
  virtual void  v7(); // _ZN8S10168C22v7Ev
  virtual void  v8(); // _ZN8S10168C22v8Ev
  virtual void  v9(); // _ZN8S10168C22v9Ev
  virtual void  v10(); // _ZN8S10168C23v10Ev
  virtual void  v11(); // _ZN8S10168C23v11Ev
  S10168C2(); // tgen
};
//SIG(-1 S10168C2) C1{ vd v1 v2 v3 v4 v5}


 S10168C2 ::~S10168C2(){ note_dtor("S10168C2", this);}
void  S10168C2 ::v7(){vfunc_called(this, "_ZN8S10168C22v7Ev");}
void  S10168C2 ::v8(){vfunc_called(this, "_ZN8S10168C22v8Ev");}
void  S10168C2 ::v9(){vfunc_called(this, "_ZN8S10168C22v9Ev");}
void  S10168C2 ::v10(){vfunc_called(this, "_ZN8S10168C23v10Ev");}
void  S10168C2 ::v11(){vfunc_called(this, "_ZN8S10168C23v11Ev");}
S10168C2 ::S10168C2(){ note_ctor("S10168C2", this);} // tgen

static void Test_S10168C2()
{
  extern Class_Descriptor cd_S10168C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10168C2, buf);
    S10168C2 *dp, &lv = *(dp=new (buf) S10168C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10168C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10168C2)");
    test_class_info(&lv, &cd_S10168C2);
    dp->~S10168C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10168C2(Test_S10168C2, "S10168C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10168C2C1Ev();
extern void _ZN8S10168C2D1Ev();
Name_Map name_map_S10168C2[] = {
  NSPAIR(_ZN8S10168C2C1Ev),
  NSPAIR(_ZN8S10168C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10168C2[];
extern void _ZN8S10168C2D1Ev();
extern void _ZN8S10168C2D0Ev();
extern void _ZN8S10168C22v7Ev();
extern void _ZN8S10168C22v8Ev();
extern void _ZN8S10168C22v9Ev();
extern void _ZN8S10168C23v10Ev();
extern void _ZN8S10168C23v11Ev();
static  VTBL_ENTRY vtc_S10168C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10168C2[0]),
  (VTBL_ENTRY)&_ZN8S10168C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10168C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10168C22v7Ev,
  (VTBL_ENTRY)&_ZN8S10168C22v8Ev,
  (VTBL_ENTRY)&_ZN8S10168C22v9Ev,
  (VTBL_ENTRY)&_ZN8S10168C23v10Ev,
  (VTBL_ENTRY)&_ZN8S10168C23v11Ev,
};
extern VTBL_ENTRY _ZTI8S10168C2[];
extern  VTBL_ENTRY _ZTV8S10168C2[];
Class_Descriptor cd_S10168C2 = {  "S10168C2", // class name
  0,0,//no base classes
  &(vtc_S10168C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10168C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10168C2),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10168C3  {
  void *s10168c3f0;
  virtual  ~S10168C3(); // _ZN8S10168C3D1Ev
  virtual void  v12(); // _ZN8S10168C33v12Ev
  virtual void  v13(); // _ZN8S10168C33v13Ev
  virtual void  v14(); // _ZN8S10168C33v14Ev
  S10168C3(); // tgen
};
//SIG(-1 S10168C3) C1{ vd v1 v2 v3 Fp}


 S10168C3 ::~S10168C3(){ note_dtor("S10168C3", this);}
void  S10168C3 ::v12(){vfunc_called(this, "_ZN8S10168C33v12Ev");}
void  S10168C3 ::v13(){vfunc_called(this, "_ZN8S10168C33v13Ev");}
void  S10168C3 ::v14(){vfunc_called(this, "_ZN8S10168C33v14Ev");}
S10168C3 ::S10168C3(){ note_ctor("S10168C3", this);} // tgen

static void Test_S10168C3()
{
  extern Class_Descriptor cd_S10168C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10168C3, buf);
    S10168C3 *dp, &lv = *(dp=new (buf) S10168C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10168C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10168C3)");
    check_field_offset(lv, s10168c3f0, ABISELECT(8,4), "S10168C3.s10168c3f0");
    test_class_info(&lv, &cd_S10168C3);
    dp->~S10168C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10168C3(Test_S10168C3, "S10168C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10168C3C1Ev();
extern void _ZN8S10168C3D1Ev();
Name_Map name_map_S10168C3[] = {
  NSPAIR(_ZN8S10168C3C1Ev),
  NSPAIR(_ZN8S10168C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10168C3[];
extern void _ZN8S10168C3D1Ev();
extern void _ZN8S10168C3D0Ev();
extern void _ZN8S10168C33v12Ev();
extern void _ZN8S10168C33v13Ev();
extern void _ZN8S10168C33v14Ev();
static  VTBL_ENTRY vtc_S10168C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10168C3[0]),
  (VTBL_ENTRY)&_ZN8S10168C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10168C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10168C33v12Ev,
  (VTBL_ENTRY)&_ZN8S10168C33v13Ev,
  (VTBL_ENTRY)&_ZN8S10168C33v14Ev,
};
extern VTBL_ENTRY _ZTI8S10168C3[];
extern  VTBL_ENTRY _ZTV8S10168C3[];
Class_Descriptor cd_S10168C3 = {  "S10168C3", // class name
  0,0,//no base classes
  &(vtc_S10168C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10168C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10168C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10168C1  : S10168C2 , S10168C3 {
  int s10168c1f0[2];
  ::S17044C52_nt s10168c1f1;
  ::S17044C5 s10168c1f2;
  ::S17044C73 s10168c1f3;
  ::S17044C158 s10168c1f4;
  int s10168c1f5;
  int s10168c1f6;
  char s10168c1f7;
  char s10168c1f8;
  char s10168c1f9;
  int s10168c1f10;
  int s10168c1f11;
  int s10168c1f12;
  int s10168c1f13;
  int s10168c1f14;
  ::S17044C73 s10168c1f15;
  ::S17044C73 s10168c1f16;
  ::S17044C73 s10168c1f17;
  ::S17044C73 s10168c1f18;
  ::S17044C121 s10168c1f19;
  ::S17044C121 s10168c1f20;
  ::S17044C121 s10168c1f21;
  ::S17044C121 s10168c1f22;
  ::S17044C123_nt s10168c1f23;
  char s10168c1f24;
  ::S17044C124 s10168c1f25;
  char s10168c1f26;
  int s10168c1f27;
  int s10168c1f28;
  char s10168c1f29;
  char s10168c1f30;
  char s10168c1f31;
  char s10168c1f32;
  ::S17044C127 s10168c1f33;
  ::S17044C127 s10168c1f34;
  ::S17044C127 s10168c1f35;
  ::S17044C127 s10168c1f36;
  ::S17044C129 s10168c1f37;
  ::S17044C150 s10168c1f38;
  int s10168c1f39;
  ::S17044C73 s10168c1f40;
  char s10168c1f41;
  char s10168c1f42;
  ::S17044C123_nt s10168c1f43;
  char s10168c1f44;
  char s10168c1f45;
  char s10168c1f46;
  virtual  ~S10168C1(); // _ZN8S10168C1D1Ev
  virtual void  v1(); // _ZN8S10168C12v1Ev
  virtual void  v2(); // _ZN8S10168C12v2Ev
  virtual void  v3(); // _ZN8S10168C12v3Ev
  virtual void  v4(); // _ZN8S10168C12v4Ev
  virtual void  v5(); // _ZN8S10168C12v5Ev
  virtual void  v6(); // _ZN8S10168C12v6Ev
  S10168C1(); // tgen
};
//SIG(1 S10168C1) C1{ BC2{ vd v7 v8 v9 v10 v11} BC3{ vd v12 v13 v14 Fp} vd v1 v2 v3 v4 v5 v6 Fi[2] FC4{ m Fi[2]} FC5{ BC6{ BC7{} FC8{ BC9{}}} Fp[3]} FC10{ BC11{ BC12{ BC7} FC13{ BC14{}}} FU15{ Fc[16] Fp} Fi Fi} FC16{ BC17{ BC7 FC18{ BC19{}}} Fp Fp Fp} Fi Fi Fc Fc Fc Fi Fi Fi Fi Fi FC10 FC10 FC10 FC10 FC20{ BC21{ m Fp}} FC20 FC20 FC20 FC22{ m FL} Fc FC23{ BC24{ m FC25{ m Fc Fc[15]} FC25 FC25 FC25}} Fc Fi Fi Fc Fc Fc Fc FC26{ m FC27{ m Fi Fp Fi[17]}} FC26 FC26 FC26 FC28{ m FC29{ BC30{ BC7 FC31{ BC32{}}} Fp Fp Fp} FC33{ BC34{ BC35{ BC36{ BC7 FC37{ BC38{}}} FC37} FC39{ BC40{}}} Fp Fp Fi} Fi Fi} FC41{ BC42{ BC7 FC39} Fp Fp Fp} Fi FC10 Fc Fc FC22 Fc Fc Fc}


 S10168C1 ::~S10168C1(){ note_dtor("S10168C1", this);}
void  S10168C1 ::v1(){vfunc_called(this, "_ZN8S10168C12v1Ev");}
void  S10168C1 ::v2(){vfunc_called(this, "_ZN8S10168C12v2Ev");}
void  S10168C1 ::v3(){vfunc_called(this, "_ZN8S10168C12v3Ev");}
void  S10168C1 ::v4(){vfunc_called(this, "_ZN8S10168C12v4Ev");}
void  S10168C1 ::v5(){vfunc_called(this, "_ZN8S10168C12v5Ev");}
void  S10168C1 ::v6(){vfunc_called(this, "_ZN8S10168C12v6Ev");}
S10168C1 ::S10168C1(){ note_ctor("S10168C1", this);} // tgen

static void Test_S10168C1()
{
  extern Class_Descriptor cd_S10168C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(118,187)];
    init_test(&cd_S10168C1, buf);
    S10168C1 *dp, &lv = *(dp=new (buf) S10168C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(936,744), "sizeof(S10168C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10168C1)");
    check_base_class_offset(lv, (S10168C2*), 0, "S10168C1");
    check_base_class_offset(lv, (S10168C3*), ABISELECT(8,4), "S10168C1");
    check_field_offset(lv, s10168c1f0, ABISELECT(24,12), "S10168C1.s10168c1f0");
    check_field_offset(lv, s10168c1f1, ABISELECT(32,20), "S10168C1.s10168c1f1");
    check_field_offset(lv, s10168c1f2, ABISELECT(40,28), "S10168C1.s10168c1f2");
    check_field_offset(lv, s10168c1f3, ABISELECT(72,44), "S10168C1.s10168c1f3");
    check_field_offset(lv, s10168c1f4, ABISELECT(104,72), "S10168C1.s10168c1f4");
    check_field_offset(lv, s10168c1f5, ABISELECT(136,88), "S10168C1.s10168c1f5");
    check_field_offset(lv, s10168c1f6, ABISELECT(140,92), "S10168C1.s10168c1f6");
    check_field_offset(lv, s10168c1f7, ABISELECT(144,96), "S10168C1.s10168c1f7");
    check_field_offset(lv, s10168c1f8, ABISELECT(145,97), "S10168C1.s10168c1f8");
    check_field_offset(lv, s10168c1f9, ABISELECT(146,98), "S10168C1.s10168c1f9");
    check_field_offset(lv, s10168c1f10, ABISELECT(148,100), "S10168C1.s10168c1f10");
    check_field_offset(lv, s10168c1f11, ABISELECT(152,104), "S10168C1.s10168c1f11");
    check_field_offset(lv, s10168c1f12, ABISELECT(156,108), "S10168C1.s10168c1f12");
    check_field_offset(lv, s10168c1f13, ABISELECT(160,112), "S10168C1.s10168c1f13");
    check_field_offset(lv, s10168c1f14, ABISELECT(164,116), "S10168C1.s10168c1f14");
    check_field_offset(lv, s10168c1f15, ABISELECT(168,120), "S10168C1.s10168c1f15");
    check_field_offset(lv, s10168c1f16, ABISELECT(200,148), "S10168C1.s10168c1f16");
    check_field_offset(lv, s10168c1f17, ABISELECT(232,176), "S10168C1.s10168c1f17");
    check_field_offset(lv, s10168c1f18, ABISELECT(264,204), "S10168C1.s10168c1f18");
    check_field_offset(lv, s10168c1f19, ABISELECT(296,232), "S10168C1.s10168c1f19");
    check_field_offset(lv, s10168c1f20, ABISELECT(304,236), "S10168C1.s10168c1f20");
    check_field_offset(lv, s10168c1f21, ABISELECT(312,240), "S10168C1.s10168c1f21");
    check_field_offset(lv, s10168c1f22, ABISELECT(320,244), "S10168C1.s10168c1f22");
    check_field_offset(lv, s10168c1f23, ABISELECT(328,248), "S10168C1.s10168c1f23");
    check_field_offset(lv, s10168c1f24, ABISELECT(336,256), "S10168C1.s10168c1f24");
    check_field_offset(lv, s10168c1f25, ABISELECT(337,257), "S10168C1.s10168c1f25");
    check_field_offset(lv, s10168c1f26, ABISELECT(401,321), "S10168C1.s10168c1f26");
    check_field_offset(lv, s10168c1f27, ABISELECT(404,324), "S10168C1.s10168c1f27");
    check_field_offset(lv, s10168c1f28, ABISELECT(408,328), "S10168C1.s10168c1f28");
    check_field_offset(lv, s10168c1f29, ABISELECT(412,332), "S10168C1.s10168c1f29");
    check_field_offset(lv, s10168c1f30, ABISELECT(413,333), "S10168C1.s10168c1f30");
    check_field_offset(lv, s10168c1f31, ABISELECT(414,334), "S10168C1.s10168c1f31");
    check_field_offset(lv, s10168c1f32, ABISELECT(415,335), "S10168C1.s10168c1f32");
    check_field_offset(lv, s10168c1f33, ABISELECT(416,336), "S10168C1.s10168c1f33");
    check_field_offset(lv, s10168c1f34, ABISELECT(504,412), "S10168C1.s10168c1f34");
    check_field_offset(lv, s10168c1f35, ABISELECT(592,488), "S10168C1.s10168c1f35");
    check_field_offset(lv, s10168c1f36, ABISELECT(680,564), "S10168C1.s10168c1f36");
    check_field_offset(lv, s10168c1f37, ABISELECT(768,640), "S10168C1.s10168c1f37");
    check_field_offset(lv, s10168c1f38, ABISELECT(840,680), "S10168C1.s10168c1f38");
    check_field_offset(lv, s10168c1f39, ABISELECT(872,696), "S10168C1.s10168c1f39");
    check_field_offset(lv, s10168c1f40, ABISELECT(880,700), "S10168C1.s10168c1f40");
    check_field_offset(lv, s10168c1f41, ABISELECT(912,728), "S10168C1.s10168c1f41");
    check_field_offset(lv, s10168c1f42, ABISELECT(913,729), "S10168C1.s10168c1f42");
    check_field_offset(lv, s10168c1f43, ABISELECT(920,732), "S10168C1.s10168c1f43");
    check_field_offset(lv, s10168c1f44, ABISELECT(928,740), "S10168C1.s10168c1f44");
    check_field_offset(lv, s10168c1f45, ABISELECT(929,741), "S10168C1.s10168c1f45");
    check_field_offset(lv, s10168c1f46, ABISELECT(930,742), "S10168C1.s10168c1f46");
    test_class_info(&lv, &cd_S10168C1);
    dp->~S10168C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10168C1(Test_S10168C1, "S10168C1", ABISELECT(936,744));

#else // __cplusplus

extern void _ZN8S10168C1C1Ev();
extern void _ZN8S10168C1D1Ev();
Name_Map name_map_S10168C1[] = {
  NSPAIR(_ZN8S10168C1C1Ev),
  NSPAIR(_ZN8S10168C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10168C2;
extern VTBL_ENTRY _ZTI8S10168C2[];
extern  VTBL_ENTRY _ZTV8S10168C2[];
extern Class_Descriptor cd_S10168C3;
extern VTBL_ENTRY _ZTI8S10168C3[];
extern  VTBL_ENTRY _ZTV8S10168C3[];
static Base_Class bases_S10168C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10168C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10168C3,    ABISELECT(8,4), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10168C1[];
extern void _ZN8S10168C1D1Ev();
extern void _ZN8S10168C1D0Ev();
extern void _ZN8S10168C22v7Ev();
extern void _ZN8S10168C22v8Ev();
extern void _ZN8S10168C22v9Ev();
extern void _ZN8S10168C23v10Ev();
extern void _ZN8S10168C23v11Ev();
extern void _ZN8S10168C12v1Ev();
extern void _ZN8S10168C12v2Ev();
extern void _ZN8S10168C12v3Ev();
extern void _ZN8S10168C12v4Ev();
extern void _ZN8S10168C12v5Ev();
extern void _ZN8S10168C12v6Ev();
extern void ABISELECT(_ZThn8_N8S10168C1D1Ev,_ZThn4_N8S10168C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10168C1D0Ev,_ZThn4_N8S10168C1D0Ev)();
extern void _ZN8S10168C33v12Ev();
extern void _ZN8S10168C33v13Ev();
extern void _ZN8S10168C33v14Ev();
static  VTBL_ENTRY vtc_S10168C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10168C1[0]),
  (VTBL_ENTRY)&_ZN8S10168C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10168C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10168C22v7Ev,
  (VTBL_ENTRY)&_ZN8S10168C22v8Ev,
  (VTBL_ENTRY)&_ZN8S10168C22v9Ev,
  (VTBL_ENTRY)&_ZN8S10168C23v10Ev,
  (VTBL_ENTRY)&_ZN8S10168C23v11Ev,
  (VTBL_ENTRY)&_ZN8S10168C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10168C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10168C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10168C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10168C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10168C12v6Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10168C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10168C1D1Ev,_ZThn4_N8S10168C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10168C1D0Ev,_ZThn4_N8S10168C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10168C33v12Ev,
  (VTBL_ENTRY)&_ZN8S10168C33v13Ev,
  (VTBL_ENTRY)&_ZN8S10168C33v14Ev,
};
extern VTBL_ENTRY _ZTI8S10168C1[];
extern  VTBL_ENTRY _ZTV8S10168C1[];
Class_Descriptor cd_S10168C1 = {  "S10168C1", // class name
  bases_S10168C1, 2,
  &(vtc_S10168C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(936,744), // object size
  NSPAIRA(_ZTI8S10168C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10168C1),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10169C2  {
  virtual  ~S10169C2(); // _ZN8S10169C2D1Ev
  virtual void  v7(); // _ZN8S10169C22v7Ev
  virtual void  v8(); // _ZN8S10169C22v8Ev
  virtual void  v9(); // _ZN8S10169C22v9Ev
  virtual void  v10(); // _ZN8S10169C23v10Ev
  virtual void  v11(); // _ZN8S10169C23v11Ev
  S10169C2(); // tgen
};
//SIG(-1 S10169C2) C1{ vd v1 v2 v3 v4 v5}


 S10169C2 ::~S10169C2(){ note_dtor("S10169C2", this);}
void  S10169C2 ::v7(){vfunc_called(this, "_ZN8S10169C22v7Ev");}
void  S10169C2 ::v8(){vfunc_called(this, "_ZN8S10169C22v8Ev");}
void  S10169C2 ::v9(){vfunc_called(this, "_ZN8S10169C22v9Ev");}
void  S10169C2 ::v10(){vfunc_called(this, "_ZN8S10169C23v10Ev");}
void  S10169C2 ::v11(){vfunc_called(this, "_ZN8S10169C23v11Ev");}
S10169C2 ::S10169C2(){ note_ctor("S10169C2", this);} // tgen

static void Test_S10169C2()
{
  extern Class_Descriptor cd_S10169C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10169C2, buf);
    S10169C2 *dp, &lv = *(dp=new (buf) S10169C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10169C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10169C2)");
    test_class_info(&lv, &cd_S10169C2);
    dp->~S10169C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10169C2(Test_S10169C2, "S10169C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10169C2C1Ev();
extern void _ZN8S10169C2D1Ev();
Name_Map name_map_S10169C2[] = {
  NSPAIR(_ZN8S10169C2C1Ev),
  NSPAIR(_ZN8S10169C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10169C2[];
extern void _ZN8S10169C2D1Ev();
extern void _ZN8S10169C2D0Ev();
extern void _ZN8S10169C22v7Ev();
extern void _ZN8S10169C22v8Ev();
extern void _ZN8S10169C22v9Ev();
extern void _ZN8S10169C23v10Ev();
extern void _ZN8S10169C23v11Ev();
static  VTBL_ENTRY vtc_S10169C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10169C2[0]),
  (VTBL_ENTRY)&_ZN8S10169C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10169C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10169C22v7Ev,
  (VTBL_ENTRY)&_ZN8S10169C22v8Ev,
  (VTBL_ENTRY)&_ZN8S10169C22v9Ev,
  (VTBL_ENTRY)&_ZN8S10169C23v10Ev,
  (VTBL_ENTRY)&_ZN8S10169C23v11Ev,
};
extern VTBL_ENTRY _ZTI8S10169C2[];
extern  VTBL_ENTRY _ZTV8S10169C2[];
Class_Descriptor cd_S10169C2 = {  "S10169C2", // class name
  0,0,//no base classes
  &(vtc_S10169C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10169C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10169C2),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10169C3  {
  void *s10169c3f0;
  virtual  ~S10169C3(); // _ZN8S10169C3D1Ev
  virtual void  v12(); // _ZN8S10169C33v12Ev
  virtual void  v13(); // _ZN8S10169C33v13Ev
  virtual void  v14(); // _ZN8S10169C33v14Ev
  S10169C3(); // tgen
};
//SIG(-1 S10169C3) C1{ vd v1 v2 v3 Fp}


 S10169C3 ::~S10169C3(){ note_dtor("S10169C3", this);}
void  S10169C3 ::v12(){vfunc_called(this, "_ZN8S10169C33v12Ev");}
void  S10169C3 ::v13(){vfunc_called(this, "_ZN8S10169C33v13Ev");}
void  S10169C3 ::v14(){vfunc_called(this, "_ZN8S10169C33v14Ev");}
S10169C3 ::S10169C3(){ note_ctor("S10169C3", this);} // tgen

static void Test_S10169C3()
{
  extern Class_Descriptor cd_S10169C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10169C3, buf);
    S10169C3 *dp, &lv = *(dp=new (buf) S10169C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10169C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10169C3)");
    check_field_offset(lv, s10169c3f0, ABISELECT(8,4), "S10169C3.s10169c3f0");
    test_class_info(&lv, &cd_S10169C3);
    dp->~S10169C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10169C3(Test_S10169C3, "S10169C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10169C3C1Ev();
extern void _ZN8S10169C3D1Ev();
Name_Map name_map_S10169C3[] = {
  NSPAIR(_ZN8S10169C3C1Ev),
  NSPAIR(_ZN8S10169C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10169C3[];
extern void _ZN8S10169C3D1Ev();
extern void _ZN8S10169C3D0Ev();
extern void _ZN8S10169C33v12Ev();
extern void _ZN8S10169C33v13Ev();
extern void _ZN8S10169C33v14Ev();
static  VTBL_ENTRY vtc_S10169C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10169C3[0]),
  (VTBL_ENTRY)&_ZN8S10169C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10169C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10169C33v12Ev,
  (VTBL_ENTRY)&_ZN8S10169C33v13Ev,
  (VTBL_ENTRY)&_ZN8S10169C33v14Ev,
};
extern VTBL_ENTRY _ZTI8S10169C3[];
extern  VTBL_ENTRY _ZTV8S10169C3[];
Class_Descriptor cd_S10169C3 = {  "S10169C3", // class name
  0,0,//no base classes
  &(vtc_S10169C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10169C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10169C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10169C1  : S10169C2 , S10169C3 {
  int s10169c1f0[2];
  ::S17044C52_nt s10169c1f1;
  ::S17044C5 s10169c1f2;
  ::S17044C73 s10169c1f3;
  ::S17044C158 s10169c1f4;
  int s10169c1f5;
  int s10169c1f6;
  char s10169c1f7;
  char s10169c1f8;
  char s10169c1f9;
  int s10169c1f10;
  int s10169c1f11;
  int s10169c1f12;
  int s10169c1f13;
  int s10169c1f14;
  ::S17044C73 s10169c1f15;
  ::S17044C73 s10169c1f16;
  ::S17044C73 s10169c1f17;
  ::S17044C73 s10169c1f18;
  ::S17044C121 s10169c1f19;
  ::S17044C121 s10169c1f20;
  ::S17044C121 s10169c1f21;
  ::S17044C121 s10169c1f22;
  ::S17044C123_nt s10169c1f23;
  char s10169c1f24;
  ::S17044C124 s10169c1f25;
  char s10169c1f26;
  int s10169c1f27;
  int s10169c1f28;
  char s10169c1f29;
  char s10169c1f30;
  char s10169c1f31;
  char s10169c1f32;
  ::S17045C127 s10169c1f33;
  ::S17045C127 s10169c1f34;
  ::S17045C127 s10169c1f35;
  ::S17045C127 s10169c1f36;
  ::S17044C129 s10169c1f37;
  ::S17044C150 s10169c1f38;
  int s10169c1f39;
  ::S17044C73 s10169c1f40;
  char s10169c1f41;
  char s10169c1f42;
  ::S17044C123_nt s10169c1f43;
  char s10169c1f44;
  char s10169c1f45;
  char s10169c1f46;
  virtual  ~S10169C1(); // _ZN8S10169C1D1Ev
  virtual void  v1(); // _ZN8S10169C12v1Ev
  virtual void  v2(); // _ZN8S10169C12v2Ev
  virtual void  v3(); // _ZN8S10169C12v3Ev
  virtual void  v4(); // _ZN8S10169C12v4Ev
  virtual void  v5(); // _ZN8S10169C12v5Ev
  virtual void  v6(); // _ZN8S10169C12v6Ev
  S10169C1(); // tgen
};
//SIG(1 S10169C1) C1{ BC2{ vd v7 v8 v9 v10 v11} BC3{ vd v12 v13 v14 Fp} vd v1 v2 v3 v4 v5 v6 Fi[2] FC4{ m Fi[2]} FC5{ BC6{ BC7{} FC8{ BC9{}}} Fp[3]} FC10{ BC11{ BC12{ BC7} FC13{ BC14{}}} FU15{ Fc[16] Fp} Fi Fi} FC16{ BC17{ BC7 FC18{ BC19{}}} Fp Fp Fp} Fi Fi Fc Fc Fc Fi Fi Fi Fi Fi FC10 FC10 FC10 FC10 FC20{ BC21{ m Fp}} FC20 FC20 FC20 FC22{ m FL} Fc FC23{ BC24{ m FC25{ m Fc Fc[15]} FC25 FC25 FC25}} Fc Fi Fi Fc Fc Fc Fc FC26{ m FC27{ m Fi Fp Fi[34]}} FC26 FC26 FC26 FC28{ m FC29{ BC30{ BC7 FC31{ BC32{}}} Fp Fp Fp} FC33{ BC34{ BC35{ BC36{ BC7 FC37{ BC38{}}} FC37} FC39{ BC40{}}} Fp Fp Fi} Fi Fi} FC41{ BC42{ BC7 FC39} Fp Fp Fp} Fi FC10 Fc Fc FC22 Fc Fc Fc}


 S10169C1 ::~S10169C1(){ note_dtor("S10169C1", this);}
void  S10169C1 ::v1(){vfunc_called(this, "_ZN8S10169C12v1Ev");}
void  S10169C1 ::v2(){vfunc_called(this, "_ZN8S10169C12v2Ev");}
void  S10169C1 ::v3(){vfunc_called(this, "_ZN8S10169C12v3Ev");}
void  S10169C1 ::v4(){vfunc_called(this, "_ZN8S10169C12v4Ev");}
void  S10169C1 ::v5(){vfunc_called(this, "_ZN8S10169C12v5Ev");}
void  S10169C1 ::v6(){vfunc_called(this, "_ZN8S10169C12v6Ev");}
S10169C1 ::S10169C1(){ note_ctor("S10169C1", this);} // tgen

static void Test_S10169C1()
{
  extern Class_Descriptor cd_S10169C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(150,255)];
    init_test(&cd_S10169C1, buf);
    S10169C1 *dp, &lv = *(dp=new (buf) S10169C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1192,1016), "sizeof(S10169C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10169C1)");
    check_base_class_offset(lv, (S10169C2*), 0, "S10169C1");
    check_base_class_offset(lv, (S10169C3*), ABISELECT(8,4), "S10169C1");
    check_field_offset(lv, s10169c1f0, ABISELECT(24,12), "S10169C1.s10169c1f0");
    check_field_offset(lv, s10169c1f1, ABISELECT(32,20), "S10169C1.s10169c1f1");
    check_field_offset(lv, s10169c1f2, ABISELECT(40,28), "S10169C1.s10169c1f2");
    check_field_offset(lv, s10169c1f3, ABISELECT(72,44), "S10169C1.s10169c1f3");
    check_field_offset(lv, s10169c1f4, ABISELECT(104,72), "S10169C1.s10169c1f4");
    check_field_offset(lv, s10169c1f5, ABISELECT(136,88), "S10169C1.s10169c1f5");
    check_field_offset(lv, s10169c1f6, ABISELECT(140,92), "S10169C1.s10169c1f6");
    check_field_offset(lv, s10169c1f7, ABISELECT(144,96), "S10169C1.s10169c1f7");
    check_field_offset(lv, s10169c1f8, ABISELECT(145,97), "S10169C1.s10169c1f8");
    check_field_offset(lv, s10169c1f9, ABISELECT(146,98), "S10169C1.s10169c1f9");
    check_field_offset(lv, s10169c1f10, ABISELECT(148,100), "S10169C1.s10169c1f10");
    check_field_offset(lv, s10169c1f11, ABISELECT(152,104), "S10169C1.s10169c1f11");
    check_field_offset(lv, s10169c1f12, ABISELECT(156,108), "S10169C1.s10169c1f12");
    check_field_offset(lv, s10169c1f13, ABISELECT(160,112), "S10169C1.s10169c1f13");
    check_field_offset(lv, s10169c1f14, ABISELECT(164,116), "S10169C1.s10169c1f14");
    check_field_offset(lv, s10169c1f15, ABISELECT(168,120), "S10169C1.s10169c1f15");
    check_field_offset(lv, s10169c1f16, ABISELECT(200,148), "S10169C1.s10169c1f16");
    check_field_offset(lv, s10169c1f17, ABISELECT(232,176), "S10169C1.s10169c1f17");
    check_field_offset(lv, s10169c1f18, ABISELECT(264,204), "S10169C1.s10169c1f18");
    check_field_offset(lv, s10169c1f19, ABISELECT(296,232), "S10169C1.s10169c1f19");
    check_field_offset(lv, s10169c1f20, ABISELECT(304,236), "S10169C1.s10169c1f20");
    check_field_offset(lv, s10169c1f21, ABISELECT(312,240), "S10169C1.s10169c1f21");
    check_field_offset(lv, s10169c1f22, ABISELECT(320,244), "S10169C1.s10169c1f22");
    check_field_offset(lv, s10169c1f23, ABISELECT(328,248), "S10169C1.s10169c1f23");
    check_field_offset(lv, s10169c1f24, ABISELECT(336,256), "S10169C1.s10169c1f24");
    check_field_offset(lv, s10169c1f25, ABISELECT(337,257), "S10169C1.s10169c1f25");
    check_field_offset(lv, s10169c1f26, ABISELECT(401,321), "S10169C1.s10169c1f26");
    check_field_offset(lv, s10169c1f27, ABISELECT(404,324), "S10169C1.s10169c1f27");
    check_field_offset(lv, s10169c1f28, ABISELECT(408,328), "S10169C1.s10169c1f28");
    check_field_offset(lv, s10169c1f29, ABISELECT(412,332), "S10169C1.s10169c1f29");
    check_field_offset(lv, s10169c1f30, ABISELECT(413,333), "S10169C1.s10169c1f30");
    check_field_offset(lv, s10169c1f31, ABISELECT(414,334), "S10169C1.s10169c1f31");
    check_field_offset(lv, s10169c1f32, ABISELECT(415,335), "S10169C1.s10169c1f32");
    check_field_offset(lv, s10169c1f33, ABISELECT(416,336), "S10169C1.s10169c1f33");
    check_field_offset(lv, s10169c1f34, ABISELECT(568,480), "S10169C1.s10169c1f34");
    check_field_offset(lv, s10169c1f35, ABISELECT(720,624), "S10169C1.s10169c1f35");
    check_field_offset(lv, s10169c1f36, ABISELECT(872,768), "S10169C1.s10169c1f36");
    check_field_offset(lv, s10169c1f37, ABISELECT(1024,912), "S10169C1.s10169c1f37");
    check_field_offset(lv, s10169c1f38, ABISELECT(1096,952), "S10169C1.s10169c1f38");
    check_field_offset(lv, s10169c1f39, ABISELECT(1128,968), "S10169C1.s10169c1f39");
    check_field_offset(lv, s10169c1f40, ABISELECT(1136,972), "S10169C1.s10169c1f40");
    check_field_offset(lv, s10169c1f41, ABISELECT(1168,1000), "S10169C1.s10169c1f41");
    check_field_offset(lv, s10169c1f42, ABISELECT(1169,1001), "S10169C1.s10169c1f42");
    check_field_offset(lv, s10169c1f43, ABISELECT(1176,1004), "S10169C1.s10169c1f43");
    check_field_offset(lv, s10169c1f44, ABISELECT(1184,1012), "S10169C1.s10169c1f44");
    check_field_offset(lv, s10169c1f45, ABISELECT(1185,1013), "S10169C1.s10169c1f45");
    check_field_offset(lv, s10169c1f46, ABISELECT(1186,1014), "S10169C1.s10169c1f46");
    test_class_info(&lv, &cd_S10169C1);
    dp->~S10169C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10169C1(Test_S10169C1, "S10169C1", ABISELECT(1192,1016));

#else // __cplusplus

extern void _ZN8S10169C1C1Ev();
extern void _ZN8S10169C1D1Ev();
Name_Map name_map_S10169C1[] = {
  NSPAIR(_ZN8S10169C1C1Ev),
  NSPAIR(_ZN8S10169C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10169C2;
extern VTBL_ENTRY _ZTI8S10169C2[];
extern  VTBL_ENTRY _ZTV8S10169C2[];
extern Class_Descriptor cd_S10169C3;
extern VTBL_ENTRY _ZTI8S10169C3[];
extern  VTBL_ENTRY _ZTV8S10169C3[];
static Base_Class bases_S10169C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10169C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10169C3,    ABISELECT(8,4), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10169C1[];
extern void _ZN8S10169C1D1Ev();
extern void _ZN8S10169C1D0Ev();
extern void _ZN8S10169C22v7Ev();
extern void _ZN8S10169C22v8Ev();
extern void _ZN8S10169C22v9Ev();
extern void _ZN8S10169C23v10Ev();
extern void _ZN8S10169C23v11Ev();
extern void _ZN8S10169C12v1Ev();
extern void _ZN8S10169C12v2Ev();
extern void _ZN8S10169C12v3Ev();
extern void _ZN8S10169C12v4Ev();
extern void _ZN8S10169C12v5Ev();
extern void _ZN8S10169C12v6Ev();
extern void ABISELECT(_ZThn8_N8S10169C1D1Ev,_ZThn4_N8S10169C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10169C1D0Ev,_ZThn4_N8S10169C1D0Ev)();
extern void _ZN8S10169C33v12Ev();
extern void _ZN8S10169C33v13Ev();
extern void _ZN8S10169C33v14Ev();
static  VTBL_ENTRY vtc_S10169C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10169C1[0]),
  (VTBL_ENTRY)&_ZN8S10169C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10169C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10169C22v7Ev,
  (VTBL_ENTRY)&_ZN8S10169C22v8Ev,
  (VTBL_ENTRY)&_ZN8S10169C22v9Ev,
  (VTBL_ENTRY)&_ZN8S10169C23v10Ev,
  (VTBL_ENTRY)&_ZN8S10169C23v11Ev,
  (VTBL_ENTRY)&_ZN8S10169C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10169C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10169C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10169C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10169C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10169C12v6Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10169C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10169C1D1Ev,_ZThn4_N8S10169C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10169C1D0Ev,_ZThn4_N8S10169C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10169C33v12Ev,
  (VTBL_ENTRY)&_ZN8S10169C33v13Ev,
  (VTBL_ENTRY)&_ZN8S10169C33v14Ev,
};
extern VTBL_ENTRY _ZTI8S10169C1[];
extern  VTBL_ENTRY _ZTV8S10169C1[];
Class_Descriptor cd_S10169C1 = {  "S10169C1", // class name
  bases_S10169C1, 2,
  &(vtc_S10169C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1192,1016), // object size
  NSPAIRA(_ZTI8S10169C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10169C1),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C4_nt  {
  int s1551c4f0;
  __tsi64 s1551c4f1;
  void *s1551c4f2[4];
  int s1551c4f3[2];
  void *s1551c4f4;
  ::S17044C52_nt s1551c4f5;
  void *s1551c4f6[2];
  virtual  ~S1551C4_nt(); // _ZN10S1551C4_ntD1Ev
  virtual void  v7(); // _ZN10S1551C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1551C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1551C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1551C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1551C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1551C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1551C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1551C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1551C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1551C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1551C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1551C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1551C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1551C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1551C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1551C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1551C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1551C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1551C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1551C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1551C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1551C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1551C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1551C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1551C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1551C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1551C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1551C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1551C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1551C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1551C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1551C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1551C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1551C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1551C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1551C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1551C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1551C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1551C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1551C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1551C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1551C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1551C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1551C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1551C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1551C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1551C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1551C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1551C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1551C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1551C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1551C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1551C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1551C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1551C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1551C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1551C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1551C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1551C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1551C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1551C4_nt3v67Ev
  virtual void  v68(); // _ZN10S1551C4_nt3v68Ev
  virtual void  v69(); // _ZN10S1551C4_nt3v69Ev
  virtual void  v70(); // _ZN10S1551C4_nt3v70Ev
  S1551C4_nt(); // tgen
};
//SIG(-1 S1551C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1551C4_nt ::~S1551C4_nt(){ note_dtor("S1551C4_nt", this);}
void  S1551C4_nt ::v7(){vfunc_called(this, "_ZN10S1551C4_nt2v7Ev");}
void  S1551C4_nt ::v8(){vfunc_called(this, "_ZN10S1551C4_nt2v8Ev");}
void  S1551C4_nt ::v9(){vfunc_called(this, "_ZN10S1551C4_nt2v9Ev");}
void  S1551C4_nt ::v10(){vfunc_called(this, "_ZN10S1551C4_nt3v10Ev");}
void  S1551C4_nt ::v11(){vfunc_called(this, "_ZN10S1551C4_nt3v11Ev");}
void  S1551C4_nt ::v12(){vfunc_called(this, "_ZN10S1551C4_nt3v12Ev");}
void  S1551C4_nt ::v13(){vfunc_called(this, "_ZN10S1551C4_nt3v13Ev");}
void  S1551C4_nt ::v14(){vfunc_called(this, "_ZN10S1551C4_nt3v14Ev");}
void  S1551C4_nt ::v15(){vfunc_called(this, "_ZN10S1551C4_nt3v15Ev");}
void  S1551C4_nt ::v16(){vfunc_called(this, "_ZN10S1551C4_nt3v16Ev");}
void  S1551C4_nt ::v17(){vfunc_called(this, "_ZN10S1551C4_nt3v17Ev");}
void  S1551C4_nt ::v18(){vfunc_called(this, "_ZN10S1551C4_nt3v18Ev");}
void  S1551C4_nt ::v19(){vfunc_called(this, "_ZN10S1551C4_nt3v19Ev");}
void  S1551C4_nt ::v20(){vfunc_called(this, "_ZN10S1551C4_nt3v20Ev");}
void  S1551C4_nt ::v21(){vfunc_called(this, "_ZN10S1551C4_nt3v21Ev");}
void  S1551C4_nt ::v22(){vfunc_called(this, "_ZN10S1551C4_nt3v22Ev");}
void  S1551C4_nt ::v23(){vfunc_called(this, "_ZN10S1551C4_nt3v23Ev");}
void  S1551C4_nt ::v24(){vfunc_called(this, "_ZN10S1551C4_nt3v24Ev");}
void  S1551C4_nt ::v25(){vfunc_called(this, "_ZN10S1551C4_nt3v25Ev");}
void  S1551C4_nt ::v26(){vfunc_called(this, "_ZN10S1551C4_nt3v26Ev");}
void  S1551C4_nt ::v27(){vfunc_called(this, "_ZN10S1551C4_nt3v27Ev");}
void  S1551C4_nt ::v28(){vfunc_called(this, "_ZN10S1551C4_nt3v28Ev");}
void  S1551C4_nt ::v29(){vfunc_called(this, "_ZN10S1551C4_nt3v29Ev");}
void  S1551C4_nt ::v30(){vfunc_called(this, "_ZN10S1551C4_nt3v30Ev");}
void  S1551C4_nt ::v31(){vfunc_called(this, "_ZN10S1551C4_nt3v31Ev");}
void  S1551C4_nt ::v32(){vfunc_called(this, "_ZN10S1551C4_nt3v32Ev");}
void  S1551C4_nt ::v33(){vfunc_called(this, "_ZN10S1551C4_nt3v33Ev");}
void  S1551C4_nt ::v34(){vfunc_called(this, "_ZN10S1551C4_nt3v34Ev");}
void  S1551C4_nt ::v35(){vfunc_called(this, "_ZN10S1551C4_nt3v35Ev");}
void  S1551C4_nt ::v36(){vfunc_called(this, "_ZN10S1551C4_nt3v36Ev");}
void  S1551C4_nt ::v37(){vfunc_called(this, "_ZN10S1551C4_nt3v37Ev");}
void  S1551C4_nt ::v38(){vfunc_called(this, "_ZN10S1551C4_nt3v38Ev");}
void  S1551C4_nt ::v39(){vfunc_called(this, "_ZN10S1551C4_nt3v39Ev");}
void  S1551C4_nt ::v40(){vfunc_called(this, "_ZN10S1551C4_nt3v40Ev");}
void  S1551C4_nt ::v41(){vfunc_called(this, "_ZN10S1551C4_nt3v41Ev");}
void  S1551C4_nt ::v42(){vfunc_called(this, "_ZN10S1551C4_nt3v42Ev");}
void  S1551C4_nt ::v43(){vfunc_called(this, "_ZN10S1551C4_nt3v43Ev");}
void  S1551C4_nt ::v44(){vfunc_called(this, "_ZN10S1551C4_nt3v44Ev");}
void  S1551C4_nt ::v45(){vfunc_called(this, "_ZN10S1551C4_nt3v45Ev");}
void  S1551C4_nt ::v46(){vfunc_called(this, "_ZN10S1551C4_nt3v46Ev");}
void  S1551C4_nt ::v47(){vfunc_called(this, "_ZN10S1551C4_nt3v47Ev");}
void  S1551C4_nt ::v48(){vfunc_called(this, "_ZN10S1551C4_nt3v48Ev");}
void  S1551C4_nt ::v49(){vfunc_called(this, "_ZN10S1551C4_nt3v49Ev");}
void  S1551C4_nt ::v50(){vfunc_called(this, "_ZN10S1551C4_nt3v50Ev");}
void  S1551C4_nt ::v51(){vfunc_called(this, "_ZN10S1551C4_nt3v51Ev");}
void  S1551C4_nt ::v52(){vfunc_called(this, "_ZN10S1551C4_nt3v52Ev");}
void  S1551C4_nt ::v53(){vfunc_called(this, "_ZN10S1551C4_nt3v53Ev");}
void  S1551C4_nt ::v54(){vfunc_called(this, "_ZN10S1551C4_nt3v54Ev");}
void  S1551C4_nt ::v55(){vfunc_called(this, "_ZN10S1551C4_nt3v55Ev");}
void  S1551C4_nt ::v56(){vfunc_called(this, "_ZN10S1551C4_nt3v56Ev");}
void  S1551C4_nt ::v57(){vfunc_called(this, "_ZN10S1551C4_nt3v57Ev");}
void  S1551C4_nt ::v58(){vfunc_called(this, "_ZN10S1551C4_nt3v58Ev");}
void  S1551C4_nt ::v59(){vfunc_called(this, "_ZN10S1551C4_nt3v59Ev");}
void  S1551C4_nt ::v60(){vfunc_called(this, "_ZN10S1551C4_nt3v60Ev");}
void  S1551C4_nt ::v61(){vfunc_called(this, "_ZN10S1551C4_nt3v61Ev");}
void  S1551C4_nt ::v62(){vfunc_called(this, "_ZN10S1551C4_nt3v62Ev");}
void  S1551C4_nt ::v63(){vfunc_called(this, "_ZN10S1551C4_nt3v63Ev");}
void  S1551C4_nt ::v64(){vfunc_called(this, "_ZN10S1551C4_nt3v64Ev");}
void  S1551C4_nt ::v65(){vfunc_called(this, "_ZN10S1551C4_nt3v65Ev");}
void  S1551C4_nt ::v66(){vfunc_called(this, "_ZN10S1551C4_nt3v66Ev");}
void  S1551C4_nt ::v67(){vfunc_called(this, "_ZN10S1551C4_nt3v67Ev");}
void  S1551C4_nt ::v68(){vfunc_called(this, "_ZN10S1551C4_nt3v68Ev");}
void  S1551C4_nt ::v69(){vfunc_called(this, "_ZN10S1551C4_nt3v69Ev");}
void  S1551C4_nt ::v70(){vfunc_called(this, "_ZN10S1551C4_nt3v70Ev");}
S1551C4_nt ::S1551C4_nt(){ note_ctor("S1551C4_nt", this);} // tgen

//skip512 S1551C4_nt

#else // __cplusplus

extern void _ZN10S1551C4_ntC1Ev();
extern void _ZN10S1551C4_ntD1Ev();
Name_Map name_map_S1551C4_nt[] = {
  NSPAIR(_ZN10S1551C4_ntC1Ev),
  NSPAIR(_ZN10S1551C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1551C4_nt[];
extern void _ZN10S1551C4_ntD1Ev();
extern void _ZN10S1551C4_ntD0Ev();
extern void _ZN10S1551C4_nt2v7Ev();
extern void _ZN10S1551C4_nt2v8Ev();
extern void _ZN10S1551C4_nt2v9Ev();
extern void _ZN10S1551C4_nt3v10Ev();
extern void _ZN10S1551C4_nt3v11Ev();
extern void _ZN10S1551C4_nt3v12Ev();
extern void _ZN10S1551C4_nt3v13Ev();
extern void _ZN10S1551C4_nt3v14Ev();
extern void _ZN10S1551C4_nt3v15Ev();
extern void _ZN10S1551C4_nt3v16Ev();
extern void _ZN10S1551C4_nt3v17Ev();
extern void _ZN10S1551C4_nt3v18Ev();
extern void _ZN10S1551C4_nt3v19Ev();
extern void _ZN10S1551C4_nt3v20Ev();
extern void _ZN10S1551C4_nt3v21Ev();
extern void _ZN10S1551C4_nt3v22Ev();
extern void _ZN10S1551C4_nt3v23Ev();
extern void _ZN10S1551C4_nt3v24Ev();
extern void _ZN10S1551C4_nt3v25Ev();
extern void _ZN10S1551C4_nt3v26Ev();
extern void _ZN10S1551C4_nt3v27Ev();
extern void _ZN10S1551C4_nt3v28Ev();
extern void _ZN10S1551C4_nt3v29Ev();
extern void _ZN10S1551C4_nt3v30Ev();
extern void _ZN10S1551C4_nt3v31Ev();
extern void _ZN10S1551C4_nt3v32Ev();
extern void _ZN10S1551C4_nt3v33Ev();
extern void _ZN10S1551C4_nt3v34Ev();
extern void _ZN10S1551C4_nt3v35Ev();
extern void _ZN10S1551C4_nt3v36Ev();
extern void _ZN10S1551C4_nt3v37Ev();
extern void _ZN10S1551C4_nt3v38Ev();
extern void _ZN10S1551C4_nt3v39Ev();
extern void _ZN10S1551C4_nt3v40Ev();
extern void _ZN10S1551C4_nt3v41Ev();
extern void _ZN10S1551C4_nt3v42Ev();
extern void _ZN10S1551C4_nt3v43Ev();
extern void _ZN10S1551C4_nt3v44Ev();
extern void _ZN10S1551C4_nt3v45Ev();
extern void _ZN10S1551C4_nt3v46Ev();
extern void _ZN10S1551C4_nt3v47Ev();
extern void _ZN10S1551C4_nt3v48Ev();
extern void _ZN10S1551C4_nt3v49Ev();
extern void _ZN10S1551C4_nt3v50Ev();
extern void _ZN10S1551C4_nt3v51Ev();
extern void _ZN10S1551C4_nt3v52Ev();
extern void _ZN10S1551C4_nt3v53Ev();
extern void _ZN10S1551C4_nt3v54Ev();
extern void _ZN10S1551C4_nt3v55Ev();
extern void _ZN10S1551C4_nt3v56Ev();
extern void _ZN10S1551C4_nt3v57Ev();
extern void _ZN10S1551C4_nt3v58Ev();
extern void _ZN10S1551C4_nt3v59Ev();
extern void _ZN10S1551C4_nt3v60Ev();
extern void _ZN10S1551C4_nt3v61Ev();
extern void _ZN10S1551C4_nt3v62Ev();
extern void _ZN10S1551C4_nt3v63Ev();
extern void _ZN10S1551C4_nt3v64Ev();
extern void _ZN10S1551C4_nt3v65Ev();
extern void _ZN10S1551C4_nt3v66Ev();
extern void _ZN10S1551C4_nt3v67Ev();
extern void _ZN10S1551C4_nt3v68Ev();
extern void _ZN10S1551C4_nt3v69Ev();
extern void _ZN10S1551C4_nt3v70Ev();
static  VTBL_ENTRY vtc_S1551C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1551C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1551C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI10S1551C4_nt[];
VTBL_ENTRY *P__ZTI10S1551C4_nt = _ZTI10S1551C4_nt; 
extern  VTBL_ENTRY _ZTV10S1551C4_nt[];
Class_Descriptor cd_S1551C4_nt = {  "S1551C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1551C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1551C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1551C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C3_nt  : S1551C4_nt {
  unsigned int s1551c3f0:1;
  unsigned int s1551c3f1:1;
  unsigned int s1551c3f2:1;
  unsigned int s1551c3f3:1;
  unsigned int s1551c3f4:1;
  unsigned int s1551c3f5:1;
  unsigned int s1551c3f6:1;
  ::S9123C29 s1551c3f7;
  virtual  ~S1551C3_nt(); // _ZN10S1551C3_ntD1Ev
  virtual void  v71(); // _ZN10S1551C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1551C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1551C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1551C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1551C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1551C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1551C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1551C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1551C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1551C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1551C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1551C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1551C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1551C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1551C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1551C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1551C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1551C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1551C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1551C3_nt3v90Ev
  S1551C3_nt(); // tgen
};
//SIG(-1 S1551C3_nt) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1551C3_nt ::~S1551C3_nt(){ note_dtor("S1551C3_nt", this);}
void  S1551C3_nt ::v71(){vfunc_called(this, "_ZN10S1551C3_nt3v71Ev");}
void  S1551C3_nt ::v72(){vfunc_called(this, "_ZN10S1551C3_nt3v72Ev");}
void  S1551C3_nt ::v73(){vfunc_called(this, "_ZN10S1551C3_nt3v73Ev");}
void  S1551C3_nt ::v74(){vfunc_called(this, "_ZN10S1551C3_nt3v74Ev");}
void  S1551C3_nt ::v75(){vfunc_called(this, "_ZN10S1551C3_nt3v75Ev");}
void  S1551C3_nt ::v76(){vfunc_called(this, "_ZN10S1551C3_nt3v76Ev");}
void  S1551C3_nt ::v77(){vfunc_called(this, "_ZN10S1551C3_nt3v77Ev");}
void  S1551C3_nt ::v78(){vfunc_called(this, "_ZN10S1551C3_nt3v78Ev");}
void  S1551C3_nt ::v79(){vfunc_called(this, "_ZN10S1551C3_nt3v79Ev");}
void  S1551C3_nt ::v80(){vfunc_called(this, "_ZN10S1551C3_nt3v80Ev");}
void  S1551C3_nt ::v81(){vfunc_called(this, "_ZN10S1551C3_nt3v81Ev");}
void  S1551C3_nt ::v82(){vfunc_called(this, "_ZN10S1551C3_nt3v82Ev");}
void  S1551C3_nt ::v83(){vfunc_called(this, "_ZN10S1551C3_nt3v83Ev");}
void  S1551C3_nt ::v84(){vfunc_called(this, "_ZN10S1551C3_nt3v84Ev");}
void  S1551C3_nt ::v85(){vfunc_called(this, "_ZN10S1551C3_nt3v85Ev");}
void  S1551C3_nt ::v86(){vfunc_called(this, "_ZN10S1551C3_nt3v86Ev");}
void  S1551C3_nt ::v87(){vfunc_called(this, "_ZN10S1551C3_nt3v87Ev");}
void  S1551C3_nt ::v88(){vfunc_called(this, "_ZN10S1551C3_nt3v88Ev");}
void  S1551C3_nt ::v89(){vfunc_called(this, "_ZN10S1551C3_nt3v89Ev");}
void  S1551C3_nt ::v90(){vfunc_called(this, "_ZN10S1551C3_nt3v90Ev");}
S1551C3_nt ::S1551C3_nt(){ note_ctor("S1551C3_nt", this);} // tgen

//skip512 S1551C3_nt

#else // __cplusplus

extern void _ZN10S1551C3_ntC1Ev();
extern void _ZN10S1551C3_ntD1Ev();
Name_Map name_map_S1551C3_nt[] = {
  NSPAIR(_ZN10S1551C3_ntC1Ev),
  NSPAIR(_ZN10S1551C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1551C4_nt;
extern VTBL_ENTRY _ZTI10S1551C4_nt[];
extern  VTBL_ENTRY _ZTV10S1551C4_nt[];
static Base_Class bases_S1551C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1551C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1551C3_nt[];
extern void _ZN10S1551C3_ntD1Ev();
extern void _ZN10S1551C3_ntD0Ev();
extern void _ZN10S1551C4_nt2v7Ev();
extern void _ZN10S1551C4_nt2v8Ev();
extern void _ZN10S1551C4_nt2v9Ev();
extern void _ZN10S1551C4_nt3v10Ev();
extern void _ZN10S1551C4_nt3v11Ev();
extern void _ZN10S1551C4_nt3v12Ev();
extern void _ZN10S1551C4_nt3v13Ev();
extern void _ZN10S1551C4_nt3v14Ev();
extern void _ZN10S1551C4_nt3v15Ev();
extern void _ZN10S1551C4_nt3v16Ev();
extern void _ZN10S1551C4_nt3v17Ev();
extern void _ZN10S1551C4_nt3v18Ev();
extern void _ZN10S1551C4_nt3v19Ev();
extern void _ZN10S1551C4_nt3v20Ev();
extern void _ZN10S1551C4_nt3v21Ev();
extern void _ZN10S1551C4_nt3v22Ev();
extern void _ZN10S1551C4_nt3v23Ev();
extern void _ZN10S1551C4_nt3v24Ev();
extern void _ZN10S1551C4_nt3v25Ev();
extern void _ZN10S1551C4_nt3v26Ev();
extern void _ZN10S1551C4_nt3v27Ev();
extern void _ZN10S1551C4_nt3v28Ev();
extern void _ZN10S1551C4_nt3v29Ev();
extern void _ZN10S1551C4_nt3v30Ev();
extern void _ZN10S1551C4_nt3v31Ev();
extern void _ZN10S1551C4_nt3v32Ev();
extern void _ZN10S1551C4_nt3v33Ev();
extern void _ZN10S1551C4_nt3v34Ev();
extern void _ZN10S1551C4_nt3v35Ev();
extern void _ZN10S1551C4_nt3v36Ev();
extern void _ZN10S1551C4_nt3v37Ev();
extern void _ZN10S1551C4_nt3v38Ev();
extern void _ZN10S1551C4_nt3v39Ev();
extern void _ZN10S1551C4_nt3v40Ev();
extern void _ZN10S1551C4_nt3v41Ev();
extern void _ZN10S1551C4_nt3v42Ev();
extern void _ZN10S1551C4_nt3v43Ev();
extern void _ZN10S1551C4_nt3v44Ev();
extern void _ZN10S1551C4_nt3v45Ev();
extern void _ZN10S1551C4_nt3v46Ev();
extern void _ZN10S1551C4_nt3v47Ev();
extern void _ZN10S1551C4_nt3v48Ev();
extern void _ZN10S1551C4_nt3v49Ev();
extern void _ZN10S1551C4_nt3v50Ev();
extern void _ZN10S1551C4_nt3v51Ev();
extern void _ZN10S1551C4_nt3v52Ev();
extern void _ZN10S1551C4_nt3v53Ev();
extern void _ZN10S1551C4_nt3v54Ev();
extern void _ZN10S1551C4_nt3v55Ev();
extern void _ZN10S1551C4_nt3v56Ev();
extern void _ZN10S1551C4_nt3v57Ev();
extern void _ZN10S1551C4_nt3v58Ev();
extern void _ZN10S1551C4_nt3v59Ev();
extern void _ZN10S1551C4_nt3v60Ev();
extern void _ZN10S1551C4_nt3v61Ev();
extern void _ZN10S1551C4_nt3v62Ev();
extern void _ZN10S1551C4_nt3v63Ev();
extern void _ZN10S1551C4_nt3v64Ev();
extern void _ZN10S1551C4_nt3v65Ev();
extern void _ZN10S1551C4_nt3v66Ev();
extern void _ZN10S1551C4_nt3v67Ev();
extern void _ZN10S1551C4_nt3v68Ev();
extern void _ZN10S1551C4_nt3v69Ev();
extern void _ZN10S1551C4_nt3v70Ev();
extern void _ZN10S1551C3_nt3v71Ev();
extern void _ZN10S1551C3_nt3v72Ev();
extern void _ZN10S1551C3_nt3v73Ev();
extern void _ZN10S1551C3_nt3v74Ev();
extern void _ZN10S1551C3_nt3v75Ev();
extern void _ZN10S1551C3_nt3v76Ev();
extern void _ZN10S1551C3_nt3v77Ev();
extern void _ZN10S1551C3_nt3v78Ev();
extern void _ZN10S1551C3_nt3v79Ev();
extern void _ZN10S1551C3_nt3v80Ev();
extern void _ZN10S1551C3_nt3v81Ev();
extern void _ZN10S1551C3_nt3v82Ev();
extern void _ZN10S1551C3_nt3v83Ev();
extern void _ZN10S1551C3_nt3v84Ev();
extern void _ZN10S1551C3_nt3v85Ev();
extern void _ZN10S1551C3_nt3v86Ev();
extern void _ZN10S1551C3_nt3v87Ev();
extern void _ZN10S1551C3_nt3v88Ev();
extern void _ZN10S1551C3_nt3v89Ev();
extern void _ZN10S1551C3_nt3v90Ev();
static  VTBL_ENTRY vtc_S1551C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1551C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1551C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v90Ev,
};
extern VTBL_ENTRY _ZTI10S1551C3_nt[];
VTBL_ENTRY *P__ZTI10S1551C3_nt = _ZTI10S1551C3_nt; 
extern  VTBL_ENTRY _ZTV10S1551C3_nt[];
Class_Descriptor cd_S1551C3_nt = {  "S1551C3_nt", // class name
  bases_S1551C3_nt, 1,
  &(vtc_S1551C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S1551C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1551C3_nt),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C2_nt  : S1551C3_nt {
  virtual  ~S1551C2_nt(); // _ZN10S1551C2_ntD1Ev
  virtual void  v91(); // _ZN10S1551C2_nt3v91Ev
  virtual void  v92(); // _ZN10S1551C2_nt3v92Ev
  S1551C2_nt(); // tgen
};
//SIG(-1 S1551C2_nt) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2}


 S1551C2_nt ::~S1551C2_nt(){ note_dtor("S1551C2_nt", this);}
void  S1551C2_nt ::v91(){vfunc_called(this, "_ZN10S1551C2_nt3v91Ev");}
void  S1551C2_nt ::v92(){vfunc_called(this, "_ZN10S1551C2_nt3v92Ev");}
S1551C2_nt ::S1551C2_nt(){ note_ctor("S1551C2_nt", this);} // tgen

//skip512 S1551C2_nt

#else // __cplusplus

extern void _ZN10S1551C2_ntC1Ev();
extern void _ZN10S1551C2_ntD1Ev();
Name_Map name_map_S1551C2_nt[] = {
  NSPAIR(_ZN10S1551C2_ntC1Ev),
  NSPAIR(_ZN10S1551C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1551C4_nt;
extern VTBL_ENTRY _ZTI10S1551C4_nt[];
extern  VTBL_ENTRY _ZTV10S1551C4_nt[];
extern Class_Descriptor cd_S1551C3_nt;
extern VTBL_ENTRY _ZTI10S1551C3_nt[];
extern  VTBL_ENTRY _ZTV10S1551C3_nt[];
static Base_Class bases_S1551C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1551C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1551C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1551C2_nt[];
extern void _ZN10S1551C2_ntD1Ev();
extern void _ZN10S1551C2_ntD0Ev();
extern void _ZN10S1551C4_nt2v7Ev();
extern void _ZN10S1551C4_nt2v8Ev();
extern void _ZN10S1551C4_nt2v9Ev();
extern void _ZN10S1551C4_nt3v10Ev();
extern void _ZN10S1551C4_nt3v11Ev();
extern void _ZN10S1551C4_nt3v12Ev();
extern void _ZN10S1551C4_nt3v13Ev();
extern void _ZN10S1551C4_nt3v14Ev();
extern void _ZN10S1551C4_nt3v15Ev();
extern void _ZN10S1551C4_nt3v16Ev();
extern void _ZN10S1551C4_nt3v17Ev();
extern void _ZN10S1551C4_nt3v18Ev();
extern void _ZN10S1551C4_nt3v19Ev();
extern void _ZN10S1551C4_nt3v20Ev();
extern void _ZN10S1551C4_nt3v21Ev();
extern void _ZN10S1551C4_nt3v22Ev();
extern void _ZN10S1551C4_nt3v23Ev();
extern void _ZN10S1551C4_nt3v24Ev();
extern void _ZN10S1551C4_nt3v25Ev();
extern void _ZN10S1551C4_nt3v26Ev();
extern void _ZN10S1551C4_nt3v27Ev();
extern void _ZN10S1551C4_nt3v28Ev();
extern void _ZN10S1551C4_nt3v29Ev();
extern void _ZN10S1551C4_nt3v30Ev();
extern void _ZN10S1551C4_nt3v31Ev();
extern void _ZN10S1551C4_nt3v32Ev();
extern void _ZN10S1551C4_nt3v33Ev();
extern void _ZN10S1551C4_nt3v34Ev();
extern void _ZN10S1551C4_nt3v35Ev();
extern void _ZN10S1551C4_nt3v36Ev();
extern void _ZN10S1551C4_nt3v37Ev();
extern void _ZN10S1551C4_nt3v38Ev();
extern void _ZN10S1551C4_nt3v39Ev();
extern void _ZN10S1551C4_nt3v40Ev();
extern void _ZN10S1551C4_nt3v41Ev();
extern void _ZN10S1551C4_nt3v42Ev();
extern void _ZN10S1551C4_nt3v43Ev();
extern void _ZN10S1551C4_nt3v44Ev();
extern void _ZN10S1551C4_nt3v45Ev();
extern void _ZN10S1551C4_nt3v46Ev();
extern void _ZN10S1551C4_nt3v47Ev();
extern void _ZN10S1551C4_nt3v48Ev();
extern void _ZN10S1551C4_nt3v49Ev();
extern void _ZN10S1551C4_nt3v50Ev();
extern void _ZN10S1551C4_nt3v51Ev();
extern void _ZN10S1551C4_nt3v52Ev();
extern void _ZN10S1551C4_nt3v53Ev();
extern void _ZN10S1551C4_nt3v54Ev();
extern void _ZN10S1551C4_nt3v55Ev();
extern void _ZN10S1551C4_nt3v56Ev();
extern void _ZN10S1551C4_nt3v57Ev();
extern void _ZN10S1551C4_nt3v58Ev();
extern void _ZN10S1551C4_nt3v59Ev();
extern void _ZN10S1551C4_nt3v60Ev();
extern void _ZN10S1551C4_nt3v61Ev();
extern void _ZN10S1551C4_nt3v62Ev();
extern void _ZN10S1551C4_nt3v63Ev();
extern void _ZN10S1551C4_nt3v64Ev();
extern void _ZN10S1551C4_nt3v65Ev();
extern void _ZN10S1551C4_nt3v66Ev();
extern void _ZN10S1551C4_nt3v67Ev();
extern void _ZN10S1551C4_nt3v68Ev();
extern void _ZN10S1551C4_nt3v69Ev();
extern void _ZN10S1551C4_nt3v70Ev();
extern void _ZN10S1551C3_nt3v71Ev();
extern void _ZN10S1551C3_nt3v72Ev();
extern void _ZN10S1551C3_nt3v73Ev();
extern void _ZN10S1551C3_nt3v74Ev();
extern void _ZN10S1551C3_nt3v75Ev();
extern void _ZN10S1551C3_nt3v76Ev();
extern void _ZN10S1551C3_nt3v77Ev();
extern void _ZN10S1551C3_nt3v78Ev();
extern void _ZN10S1551C3_nt3v79Ev();
extern void _ZN10S1551C3_nt3v80Ev();
extern void _ZN10S1551C3_nt3v81Ev();
extern void _ZN10S1551C3_nt3v82Ev();
extern void _ZN10S1551C3_nt3v83Ev();
extern void _ZN10S1551C3_nt3v84Ev();
extern void _ZN10S1551C3_nt3v85Ev();
extern void _ZN10S1551C3_nt3v86Ev();
extern void _ZN10S1551C3_nt3v87Ev();
extern void _ZN10S1551C3_nt3v88Ev();
extern void _ZN10S1551C3_nt3v89Ev();
extern void _ZN10S1551C3_nt3v90Ev();
extern void _ZN10S1551C2_nt3v91Ev();
extern void _ZN10S1551C2_nt3v92Ev();
static  VTBL_ENTRY vtc_S1551C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1551C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1551C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1551C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1551C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1551C2_nt3v92Ev,
};
extern VTBL_ENTRY _ZTI10S1551C2_nt[];
VTBL_ENTRY *P__ZTI10S1551C2_nt = _ZTI10S1551C2_nt; 
extern  VTBL_ENTRY _ZTV10S1551C2_nt[];
Class_Descriptor cd_S1551C2_nt = {  "S1551C2_nt", // class name
  bases_S1551C2_nt, 2,
  &(vtc_S1551C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S1551C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1551C2_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C11_nt  {
  void *s1551c11f0;
  int s1551c11f1[2];
  void  mf1551c11(); // _ZN11S1551C11_nt9mf1551c11Ev
};
//SIG(-1 S1551C11_nt) C1{ m Fp Fi[2]}


void  S1551C11_nt ::mf1551c11(){}

//skip512 S1551C11_nt

#else // __cplusplus

Class_Descriptor cd_S1551C11_nt = {  "S1551C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C10_nt  : S1551C11_nt {
};
//SIG(-1 S1551C10_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1551C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S1551C11_nt;
static Base_Class bases_S1551C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1551C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1551C10_nt = {  "S1551C10_nt", // class name
  bases_S1551C10_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C9_nt  : S1551C10_nt {
};
//SIG(-1 S1551C9_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1551C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S1551C11_nt;
extern Class_Descriptor cd_S1551C10_nt;
static Base_Class bases_S1551C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1551C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1551C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C8_nt  {
  char s1551c8f0[4];
  ::S1551C9_nt s1551c8f1;
  int s1551c8f2[2];
  void  mf1551c8(); // _ZN10S1551C8_nt8mf1551c8Ev
};
//SIG(-1 S1551C8_nt) C1{ m Fc[4] FC2{ BC3{ BC4{ m Fp Fi[2]}}} Fi[2]}


void  S1551C8_nt ::mf1551c8(){}

//skip512 S1551C8_nt

#else // __cplusplus

Class_Descriptor cd_S1551C8_nt = {  "S1551C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C7_nt  : S1551C8_nt {
  void *s1551c7f0;
};
//SIG(-1 S1551C7_nt) C1{ BC2{ m Fc[4] FC3{ BC4{ BC5{ m Fp Fi[2]}}} Fi[2]} Fp}



//skip512 S1551C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1551C8_nt;
static Base_Class bases_S1551C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1551C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1551C1  : S1551C2_nt {
  ::S1551C7_nt s1551c1f0;
  unsigned int s1551c1f1:1;
  virtual  ~S1551C1(); // _ZN7S1551C1D1Ev
  virtual void  v1(); // _ZN7S1551C12v1Ev
  virtual void  v2(); // _ZN7S1551C12v2Ev
  virtual void  v3(); // _ZN7S1551C12v3Ev
  virtual void  v4(); // _ZN7S1551C12v4Ev
  virtual void  v5(); // _ZN7S1551C12v5Ev
  virtual void  v6(); // _ZN7S1551C12v6Ev
  S1551C1(); // tgen
};
//SIG(1 S1551C1) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v91 v92} vd v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp} Fi:1}


 S1551C1 ::~S1551C1(){ note_dtor("S1551C1", this);}
void  S1551C1 ::v1(){vfunc_called(this, "_ZN7S1551C12v1Ev");}
void  S1551C1 ::v2(){vfunc_called(this, "_ZN7S1551C12v2Ev");}
void  S1551C1 ::v3(){vfunc_called(this, "_ZN7S1551C12v3Ev");}
void  S1551C1 ::v4(){vfunc_called(this, "_ZN7S1551C12v4Ev");}
void  S1551C1 ::v5(){vfunc_called(this, "_ZN7S1551C12v5Ev");}
void  S1551C1 ::v6(){vfunc_called(this, "_ZN7S1551C12v6Ev");}
S1551C1 ::S1551C1(){ note_ctor("S1551C1", this);} // tgen

static void Test_S1551C1()
{
  extern Class_Descriptor cd_S1551C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,25)];
    init_test(&cd_S1551C1, buf);
    S1551C1 *dp, &lv = *(dp=new (buf) S1551C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,96), "sizeof(S1551C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1551C1)");
    check_base_class_offset(lv, (S1551C4_nt*)(S1551C3_nt*)(S1551C2_nt*), 0, "S1551C1");
    check_base_class_offset(lv, (S1551C3_nt*)(S1551C2_nt*), 0, "S1551C1");
    check_base_class_offset(lv, (S1551C2_nt*), 0, "S1551C1");
    check_field_offset(lv, s1551c1f0, ABISELECT(104,64), "S1551C1.s1551c1f0");
    set_bf_and_test(lv, s1551c1f1, ABISELECT(144,92), 0, 1, 1, "S1551C1");
    test_class_info(&lv, &cd_S1551C1);
    dp->~S1551C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1551C1(Test_S1551C1, "S1551C1", ABISELECT(152,96));

#else // __cplusplus

extern void _ZN7S1551C1C1Ev();
extern void _ZN7S1551C1D1Ev();
Name_Map name_map_S1551C1[] = {
  NSPAIR(_ZN7S1551C1C1Ev),
  NSPAIR(_ZN7S1551C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1551C4_nt;
extern VTBL_ENTRY _ZTI10S1551C4_nt[];
extern  VTBL_ENTRY _ZTV10S1551C4_nt[];
extern Class_Descriptor cd_S1551C3_nt;
extern VTBL_ENTRY _ZTI10S1551C3_nt[];
extern  VTBL_ENTRY _ZTV10S1551C3_nt[];
extern Class_Descriptor cd_S1551C2_nt;
extern VTBL_ENTRY _ZTI10S1551C2_nt[];
extern  VTBL_ENTRY _ZTV10S1551C2_nt[];
static Base_Class bases_S1551C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1551C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1551C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1551C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1551C1[];
extern void _ZN7S1551C1D1Ev();
extern void _ZN7S1551C1D0Ev();
extern void _ZN10S1551C4_nt2v7Ev();
extern void _ZN10S1551C4_nt2v8Ev();
extern void _ZN10S1551C4_nt2v9Ev();
extern void _ZN10S1551C4_nt3v10Ev();
extern void _ZN10S1551C4_nt3v11Ev();
extern void _ZN10S1551C4_nt3v12Ev();
extern void _ZN10S1551C4_nt3v13Ev();
extern void _ZN10S1551C4_nt3v14Ev();
extern void _ZN10S1551C4_nt3v15Ev();
extern void _ZN10S1551C4_nt3v16Ev();
extern void _ZN10S1551C4_nt3v17Ev();
extern void _ZN10S1551C4_nt3v18Ev();
extern void _ZN10S1551C4_nt3v19Ev();
extern void _ZN10S1551C4_nt3v20Ev();
extern void _ZN10S1551C4_nt3v21Ev();
extern void _ZN10S1551C4_nt3v22Ev();
extern void _ZN10S1551C4_nt3v23Ev();
extern void _ZN10S1551C4_nt3v24Ev();
extern void _ZN10S1551C4_nt3v25Ev();
extern void _ZN10S1551C4_nt3v26Ev();
extern void _ZN10S1551C4_nt3v27Ev();
extern void _ZN10S1551C4_nt3v28Ev();
extern void _ZN10S1551C4_nt3v29Ev();
extern void _ZN10S1551C4_nt3v30Ev();
extern void _ZN10S1551C4_nt3v31Ev();
extern void _ZN10S1551C4_nt3v32Ev();
extern void _ZN10S1551C4_nt3v33Ev();
extern void _ZN10S1551C4_nt3v34Ev();
extern void _ZN10S1551C4_nt3v35Ev();
extern void _ZN10S1551C4_nt3v36Ev();
extern void _ZN10S1551C4_nt3v37Ev();
extern void _ZN10S1551C4_nt3v38Ev();
extern void _ZN10S1551C4_nt3v39Ev();
extern void _ZN10S1551C4_nt3v40Ev();
extern void _ZN10S1551C4_nt3v41Ev();
extern void _ZN10S1551C4_nt3v42Ev();
extern void _ZN10S1551C4_nt3v43Ev();
extern void _ZN10S1551C4_nt3v44Ev();
extern void _ZN10S1551C4_nt3v45Ev();
extern void _ZN10S1551C4_nt3v46Ev();
extern void _ZN10S1551C4_nt3v47Ev();
extern void _ZN10S1551C4_nt3v48Ev();
extern void _ZN10S1551C4_nt3v49Ev();
extern void _ZN10S1551C4_nt3v50Ev();
extern void _ZN10S1551C4_nt3v51Ev();
extern void _ZN10S1551C4_nt3v52Ev();
extern void _ZN10S1551C4_nt3v53Ev();
extern void _ZN10S1551C4_nt3v54Ev();
extern void _ZN10S1551C4_nt3v55Ev();
extern void _ZN10S1551C4_nt3v56Ev();
extern void _ZN10S1551C4_nt3v57Ev();
extern void _ZN10S1551C4_nt3v58Ev();
extern void _ZN10S1551C4_nt3v59Ev();
extern void _ZN10S1551C4_nt3v60Ev();
extern void _ZN10S1551C4_nt3v61Ev();
extern void _ZN10S1551C4_nt3v62Ev();
extern void _ZN10S1551C4_nt3v63Ev();
extern void _ZN10S1551C4_nt3v64Ev();
extern void _ZN10S1551C4_nt3v65Ev();
extern void _ZN10S1551C4_nt3v66Ev();
extern void _ZN10S1551C4_nt3v67Ev();
extern void _ZN10S1551C4_nt3v68Ev();
extern void _ZN10S1551C4_nt3v69Ev();
extern void _ZN10S1551C4_nt3v70Ev();
extern void _ZN10S1551C3_nt3v71Ev();
extern void _ZN10S1551C3_nt3v72Ev();
extern void _ZN10S1551C3_nt3v73Ev();
extern void _ZN10S1551C3_nt3v74Ev();
extern void _ZN10S1551C3_nt3v75Ev();
extern void _ZN10S1551C3_nt3v76Ev();
extern void _ZN10S1551C3_nt3v77Ev();
extern void _ZN10S1551C3_nt3v78Ev();
extern void _ZN10S1551C3_nt3v79Ev();
extern void _ZN10S1551C3_nt3v80Ev();
extern void _ZN10S1551C3_nt3v81Ev();
extern void _ZN10S1551C3_nt3v82Ev();
extern void _ZN10S1551C3_nt3v83Ev();
extern void _ZN10S1551C3_nt3v84Ev();
extern void _ZN10S1551C3_nt3v85Ev();
extern void _ZN10S1551C3_nt3v86Ev();
extern void _ZN10S1551C3_nt3v87Ev();
extern void _ZN10S1551C3_nt3v88Ev();
extern void _ZN10S1551C3_nt3v89Ev();
extern void _ZN10S1551C3_nt3v90Ev();
extern void _ZN10S1551C2_nt3v91Ev();
extern void _ZN10S1551C2_nt3v92Ev();
extern void _ZN7S1551C12v1Ev();
extern void _ZN7S1551C12v2Ev();
extern void _ZN7S1551C12v3Ev();
extern void _ZN7S1551C12v4Ev();
extern void _ZN7S1551C12v5Ev();
extern void _ZN7S1551C12v6Ev();
static  VTBL_ENTRY vtc_S1551C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1551C1[0]),
  (VTBL_ENTRY)&_ZN7S1551C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1551C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1551C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1551C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1551C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1551C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN7S1551C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1551C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1551C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1551C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1551C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1551C12v6Ev,
};
extern VTBL_ENTRY _ZTI7S1551C1[];
extern  VTBL_ENTRY _ZTV7S1551C1[];
Class_Descriptor cd_S1551C1 = {  "S1551C1", // class name
  bases_S1551C1, 3,
  &(vtc_S1551C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,96), // object size
  NSPAIRA(_ZTI7S1551C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1551C1),96, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C5_nt  {
  virtual  ~S858C5_nt(); // _ZN9S858C5_ntD1Ev
  virtual void  v13(); // _ZN9S858C5_nt3v13Ev
  virtual void  v14(); // _ZN9S858C5_nt3v14Ev
  virtual void  v15(); // _ZN9S858C5_nt3v15Ev
  S858C5_nt(); // tgen
};
//SIG(-1 S858C5_nt) C1{ vd v1 v2 v3}


 S858C5_nt ::~S858C5_nt(){ note_dtor("S858C5_nt", this);}
void  S858C5_nt ::v13(){vfunc_called(this, "_ZN9S858C5_nt3v13Ev");}
void  S858C5_nt ::v14(){vfunc_called(this, "_ZN9S858C5_nt3v14Ev");}
void  S858C5_nt ::v15(){vfunc_called(this, "_ZN9S858C5_nt3v15Ev");}
S858C5_nt ::S858C5_nt(){ note_ctor("S858C5_nt", this);} // tgen

//skip512 S858C5_nt

#else // __cplusplus

extern void _ZN9S858C5_ntC1Ev();
extern void _ZN9S858C5_ntD1Ev();
Name_Map name_map_S858C5_nt[] = {
  NSPAIR(_ZN9S858C5_ntC1Ev),
  NSPAIR(_ZN9S858C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S858C5_nt[];
extern void _ZN9S858C5_ntD1Ev();
extern void _ZN9S858C5_ntD0Ev();
extern void _ZN9S858C5_nt3v13Ev();
extern void _ZN9S858C5_nt3v14Ev();
extern void _ZN9S858C5_nt3v15Ev();
static  VTBL_ENTRY vtc_S858C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S858C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S858C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S858C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v15Ev,
};
extern VTBL_ENTRY _ZTI9S858C5_nt[];
VTBL_ENTRY *P__ZTI9S858C5_nt = _ZTI9S858C5_nt; 
extern  VTBL_ENTRY _ZTV9S858C5_nt[];
Class_Descriptor cd_S858C5_nt = {  "S858C5_nt", // class name
  0,0,//no base classes
  &(vtc_S858C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S858C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S858C5_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C6  {
  virtual  ~S858C6(); // _ZN6S858C6D1Ev
  virtual void  v16(); // _ZN6S858C63v16Ev
  S858C6(); // tgen
};
//SIG(-1 S858C6) C1{ vd v1}


 S858C6 ::~S858C6(){ note_dtor("S858C6", this);}
void  S858C6 ::v16(){vfunc_called(this, "_ZN6S858C63v16Ev");}
S858C6 ::S858C6(){ note_ctor("S858C6", this);} // tgen

static void Test_S858C6()
{
  extern Class_Descriptor cd_S858C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S858C6, buf);
    S858C6 *dp, &lv = *(dp=new (buf) S858C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S858C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S858C6)");
    test_class_info(&lv, &cd_S858C6);
    dp->~S858C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS858C6(Test_S858C6, "S858C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S858C6C1Ev();
extern void _ZN6S858C6D1Ev();
Name_Map name_map_S858C6[] = {
  NSPAIR(_ZN6S858C6C1Ev),
  NSPAIR(_ZN6S858C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S858C6[];
extern void _ZN6S858C6D1Ev();
extern void _ZN6S858C6D0Ev();
extern void _ZN6S858C63v16Ev();
static  VTBL_ENTRY vtc_S858C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S858C6[0]),
  (VTBL_ENTRY)&_ZN6S858C6D1Ev,
  (VTBL_ENTRY)&_ZN6S858C6D0Ev,
  (VTBL_ENTRY)&_ZN6S858C63v16Ev,
};
extern VTBL_ENTRY _ZTI6S858C6[];
extern  VTBL_ENTRY _ZTV6S858C6[];
Class_Descriptor cd_S858C6 = {  "S858C6", // class name
  0,0,//no base classes
  &(vtc_S858C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S858C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S858C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C4_nt  : S858C5_nt , S858C6 {
  virtual  ~S858C4_nt(); // _ZN9S858C4_ntD1Ev
  virtual void  v17(); // _ZN9S858C4_nt3v17Ev
  virtual void  v18(); // _ZN9S858C4_nt3v18Ev
  virtual void  v19(); // _ZN9S858C4_nt3v19Ev
  virtual void  v20(); // _ZN9S858C4_nt3v20Ev
  virtual void  v21(); // _ZN9S858C4_nt3v21Ev
  virtual void  v22(); // _ZN9S858C4_nt3v22Ev
  virtual void  v23(); // _ZN9S858C4_nt3v23Ev
  virtual void  v24(); // _ZN9S858C4_nt3v24Ev
  virtual void  v25(); // _ZN9S858C4_nt3v25Ev
  virtual void  v26(); // _ZN9S858C4_nt3v26Ev
  virtual void  v27(); // _ZN9S858C4_nt3v27Ev
  virtual void  v28(); // _ZN9S858C4_nt3v28Ev
  virtual void  v29(); // _ZN9S858C4_nt3v29Ev
  virtual void  v30(); // _ZN9S858C4_nt3v30Ev
  virtual void  v31(); // _ZN9S858C4_nt3v31Ev
  virtual void  v32(); // _ZN9S858C4_nt3v32Ev
  virtual void  v33(); // _ZN9S858C4_nt3v33Ev
  virtual void  v34(); // _ZN9S858C4_nt3v34Ev
  virtual void  v35(); // _ZN9S858C4_nt3v35Ev
  virtual void  v36(); // _ZN9S858C4_nt3v36Ev
  virtual void  v37(); // _ZN9S858C4_nt3v37Ev
  virtual void  v38(); // _ZN9S858C4_nt3v38Ev
  S858C4_nt(); // tgen
};
//SIG(-1 S858C4_nt) C1{ BC2{ vd v23 v24 v25} BC3{ vd v26} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22}


 S858C4_nt ::~S858C4_nt(){ note_dtor("S858C4_nt", this);}
void  S858C4_nt ::v17(){vfunc_called(this, "_ZN9S858C4_nt3v17Ev");}
void  S858C4_nt ::v18(){vfunc_called(this, "_ZN9S858C4_nt3v18Ev");}
void  S858C4_nt ::v19(){vfunc_called(this, "_ZN9S858C4_nt3v19Ev");}
void  S858C4_nt ::v20(){vfunc_called(this, "_ZN9S858C4_nt3v20Ev");}
void  S858C4_nt ::v21(){vfunc_called(this, "_ZN9S858C4_nt3v21Ev");}
void  S858C4_nt ::v22(){vfunc_called(this, "_ZN9S858C4_nt3v22Ev");}
void  S858C4_nt ::v23(){vfunc_called(this, "_ZN9S858C4_nt3v23Ev");}
void  S858C4_nt ::v24(){vfunc_called(this, "_ZN9S858C4_nt3v24Ev");}
void  S858C4_nt ::v25(){vfunc_called(this, "_ZN9S858C4_nt3v25Ev");}
void  S858C4_nt ::v26(){vfunc_called(this, "_ZN9S858C4_nt3v26Ev");}
void  S858C4_nt ::v27(){vfunc_called(this, "_ZN9S858C4_nt3v27Ev");}
void  S858C4_nt ::v28(){vfunc_called(this, "_ZN9S858C4_nt3v28Ev");}
void  S858C4_nt ::v29(){vfunc_called(this, "_ZN9S858C4_nt3v29Ev");}
void  S858C4_nt ::v30(){vfunc_called(this, "_ZN9S858C4_nt3v30Ev");}
void  S858C4_nt ::v31(){vfunc_called(this, "_ZN9S858C4_nt3v31Ev");}
void  S858C4_nt ::v32(){vfunc_called(this, "_ZN9S858C4_nt3v32Ev");}
void  S858C4_nt ::v33(){vfunc_called(this, "_ZN9S858C4_nt3v33Ev");}
void  S858C4_nt ::v34(){vfunc_called(this, "_ZN9S858C4_nt3v34Ev");}
void  S858C4_nt ::v35(){vfunc_called(this, "_ZN9S858C4_nt3v35Ev");}
void  S858C4_nt ::v36(){vfunc_called(this, "_ZN9S858C4_nt3v36Ev");}
void  S858C4_nt ::v37(){vfunc_called(this, "_ZN9S858C4_nt3v37Ev");}
void  S858C4_nt ::v38(){vfunc_called(this, "_ZN9S858C4_nt3v38Ev");}
S858C4_nt ::S858C4_nt(){ note_ctor("S858C4_nt", this);} // tgen

//skip512 S858C4_nt

#else // __cplusplus

extern void _ZN9S858C4_ntC1Ev();
extern void _ZN9S858C4_ntD1Ev();
Name_Map name_map_S858C4_nt[] = {
  NSPAIR(_ZN9S858C4_ntC1Ev),
  NSPAIR(_ZN9S858C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S858C5_nt;
extern VTBL_ENTRY _ZTI9S858C5_nt[];
extern  VTBL_ENTRY _ZTV9S858C5_nt[];
extern Class_Descriptor cd_S858C6;
extern VTBL_ENTRY _ZTI6S858C6[];
extern  VTBL_ENTRY _ZTV6S858C6[];
static Base_Class bases_S858C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S858C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S858C6,    ABISELECT(8,4), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S858C4_nt[];
extern void _ZN9S858C4_ntD1Ev();
extern void _ZN9S858C4_ntD0Ev();
extern void _ZN9S858C5_nt3v13Ev();
extern void _ZN9S858C5_nt3v14Ev();
extern void _ZN9S858C5_nt3v15Ev();
extern void _ZN9S858C4_nt3v17Ev();
extern void _ZN9S858C4_nt3v18Ev();
extern void _ZN9S858C4_nt3v19Ev();
extern void _ZN9S858C4_nt3v20Ev();
extern void _ZN9S858C4_nt3v21Ev();
extern void _ZN9S858C4_nt3v22Ev();
extern void _ZN9S858C4_nt3v23Ev();
extern void _ZN9S858C4_nt3v24Ev();
extern void _ZN9S858C4_nt3v25Ev();
extern void _ZN9S858C4_nt3v26Ev();
extern void _ZN9S858C4_nt3v27Ev();
extern void _ZN9S858C4_nt3v28Ev();
extern void _ZN9S858C4_nt3v29Ev();
extern void _ZN9S858C4_nt3v30Ev();
extern void _ZN9S858C4_nt3v31Ev();
extern void _ZN9S858C4_nt3v32Ev();
extern void _ZN9S858C4_nt3v33Ev();
extern void _ZN9S858C4_nt3v34Ev();
extern void _ZN9S858C4_nt3v35Ev();
extern void _ZN9S858C4_nt3v36Ev();
extern void _ZN9S858C4_nt3v37Ev();
extern void _ZN9S858C4_nt3v38Ev();
extern void ABISELECT(_ZThn8_N9S858C4_ntD1Ev,_ZThn4_N9S858C4_ntD1Ev)();
extern void ABISELECT(_ZThn8_N9S858C4_ntD0Ev,_ZThn4_N9S858C4_ntD0Ev)();
extern void _ZN6S858C63v16Ev();
static  VTBL_ENTRY vtc_S858C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S858C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S858C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S858C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v38Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S858C4_nt[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S858C4_ntD1Ev,_ZThn4_N9S858C4_ntD1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S858C4_ntD0Ev,_ZThn4_N9S858C4_ntD0Ev),
  (VTBL_ENTRY)&_ZN6S858C63v16Ev,
};
extern VTBL_ENTRY _ZTI9S858C4_nt[];
VTBL_ENTRY *P__ZTI9S858C4_nt = _ZTI9S858C4_nt; 
extern  VTBL_ENTRY _ZTV9S858C4_nt[];
Class_Descriptor cd_S858C4_nt = {  "S858C4_nt", // class name
  bases_S858C4_nt, 2,
  &(vtc_S858C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S858C4_nt),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S858C4_nt),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C7_nt  {
  void *s858c7f0;
  int s858c7f1[2];
  ::S9123C29 s858c7f2;
  void  mf858c7(); // _ZN9S858C7_nt7mf858c7Ev
};
//SIG(-1 S858C7_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S858C7_nt ::mf858c7(){}

//skip512 S858C7_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S858C7_nt[];
VTBL_ENTRY *P__ZTI9S858C7_nt = _ZTI9S858C7_nt; 
Class_Descriptor cd_S858C7_nt = {  "S858C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI9S858C7_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C3  : S858C4_nt {
  ::S858C7_nt s858c3f0;
  ::S9124C5_nt s858c3f1;
  char s858c3f2;
  virtual  ~S858C3(); // _ZN6S858C3D1Ev
  virtual void  v39(); // _ZN6S858C33v39Ev
  virtual void  v40(); // _ZN6S858C33v40Ev
  virtual void  v41(); // _ZN6S858C33v41Ev
  S858C3(); // tgen
};
//SIG(-1 S858C3) C1{ BC2{ BC3{ vd v4 v5 v6} BC4{ vd v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29} vd v1 v2 v3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc}


 S858C3 ::~S858C3(){ note_dtor("S858C3", this);}
void  S858C3 ::v39(){vfunc_called(this, "_ZN6S858C33v39Ev");}
void  S858C3 ::v40(){vfunc_called(this, "_ZN6S858C33v40Ev");}
void  S858C3 ::v41(){vfunc_called(this, "_ZN6S858C33v41Ev");}
S858C3 ::S858C3(){ note_ctor("S858C3", this);} // tgen

static void Test_S858C3()
{
  extern Class_Descriptor cd_S858C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S858C3, buf);
    S858C3 *dp, &lv = *(dp=new (buf) S858C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S858C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S858C3)");
    check_base_class_offset(lv, (S858C5_nt*)(S858C4_nt*), 0, "S858C3");
    check_base_class_offset(lv, (S858C6*)(S858C4_nt*), ABISELECT(8,4), "S858C3");
    check_base_class_offset(lv, (S858C4_nt*), 0, "S858C3");
    check_field_offset(lv, s858c3f0, ABISELECT(16,8), "S858C3.s858c3f0");
    check_field_offset(lv, s858c3f1, ABISELECT(40,24), "S858C3.s858c3f1");
    check_field_offset(lv, s858c3f2, ABISELECT(72,56), "S858C3.s858c3f2");
    test_class_info(&lv, &cd_S858C3);
    dp->~S858C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS858C3(Test_S858C3, "S858C3", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN6S858C3C1Ev();
extern void _ZN6S858C3D1Ev();
Name_Map name_map_S858C3[] = {
  NSPAIR(_ZN6S858C3C1Ev),
  NSPAIR(_ZN6S858C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S858C5_nt;
extern VTBL_ENTRY _ZTI9S858C5_nt[];
extern  VTBL_ENTRY _ZTV9S858C5_nt[];
extern Class_Descriptor cd_S858C6;
extern VTBL_ENTRY _ZTI6S858C6[];
extern  VTBL_ENTRY _ZTV6S858C6[];
extern Class_Descriptor cd_S858C4_nt;
extern VTBL_ENTRY _ZTI9S858C4_nt[];
extern  VTBL_ENTRY _ZTV9S858C4_nt[];
static Base_Class bases_S858C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S858C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S858C6,    ABISELECT(8,4), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S858C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S858C3[];
extern void _ZN6S858C3D1Ev();
extern void _ZN6S858C3D0Ev();
extern void _ZN9S858C5_nt3v13Ev();
extern void _ZN9S858C5_nt3v14Ev();
extern void _ZN9S858C5_nt3v15Ev();
extern void _ZN9S858C4_nt3v17Ev();
extern void _ZN9S858C4_nt3v18Ev();
extern void _ZN9S858C4_nt3v19Ev();
extern void _ZN9S858C4_nt3v20Ev();
extern void _ZN9S858C4_nt3v21Ev();
extern void _ZN9S858C4_nt3v22Ev();
extern void _ZN9S858C4_nt3v23Ev();
extern void _ZN9S858C4_nt3v24Ev();
extern void _ZN9S858C4_nt3v25Ev();
extern void _ZN9S858C4_nt3v26Ev();
extern void _ZN9S858C4_nt3v27Ev();
extern void _ZN9S858C4_nt3v28Ev();
extern void _ZN9S858C4_nt3v29Ev();
extern void _ZN9S858C4_nt3v30Ev();
extern void _ZN9S858C4_nt3v31Ev();
extern void _ZN9S858C4_nt3v32Ev();
extern void _ZN9S858C4_nt3v33Ev();
extern void _ZN9S858C4_nt3v34Ev();
extern void _ZN9S858C4_nt3v35Ev();
extern void _ZN9S858C4_nt3v36Ev();
extern void _ZN9S858C4_nt3v37Ev();
extern void _ZN9S858C4_nt3v38Ev();
extern void _ZN6S858C33v39Ev();
extern void _ZN6S858C33v40Ev();
extern void _ZN6S858C33v41Ev();
extern void ABISELECT(_ZThn8_N6S858C3D1Ev,_ZThn4_N6S858C3D1Ev)();
extern void ABISELECT(_ZThn8_N6S858C3D0Ev,_ZThn4_N6S858C3D0Ev)();
extern void _ZN6S858C63v16Ev();
static  VTBL_ENTRY vtc_S858C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S858C3[0]),
  (VTBL_ENTRY)&_ZN6S858C3D1Ev,
  (VTBL_ENTRY)&_ZN6S858C3D0Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN6S858C33v39Ev,
  (VTBL_ENTRY)&_ZN6S858C33v40Ev,
  (VTBL_ENTRY)&_ZN6S858C33v41Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S858C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S858C3D1Ev,_ZThn4_N6S858C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S858C3D0Ev,_ZThn4_N6S858C3D0Ev),
  (VTBL_ENTRY)&_ZN6S858C63v16Ev,
};
extern VTBL_ENTRY _ZTI6S858C3[];
extern  VTBL_ENTRY _ZTV6S858C3[];
Class_Descriptor cd_S858C3 = {  "S858C3", // class name
  bases_S858C3, 3,
  &(vtc_S858C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI6S858C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S858C3),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C10  {
  virtual  ~S858C10(); // _ZN7S858C10D1Ev
  virtual void  v42(); // _ZN7S858C103v42Ev
  S858C10(); // tgen
};
//SIG(-1 S858C10) C1{ vd v1}


 S858C10 ::~S858C10(){ note_dtor("S858C10", this);}
void  S858C10 ::v42(){vfunc_called(this, "_ZN7S858C103v42Ev");}
S858C10 ::S858C10(){ note_ctor("S858C10", this);} // tgen

static void Test_S858C10()
{
  extern Class_Descriptor cd_S858C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S858C10, buf);
    S858C10 *dp, &lv = *(dp=new (buf) S858C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S858C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S858C10)");
    test_class_info(&lv, &cd_S858C10);
    dp->~S858C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS858C10(Test_S858C10, "S858C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S858C10C1Ev();
extern void _ZN7S858C10D1Ev();
Name_Map name_map_S858C10[] = {
  NSPAIR(_ZN7S858C10C1Ev),
  NSPAIR(_ZN7S858C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S858C10[];
extern void _ZN7S858C10D1Ev();
extern void _ZN7S858C10D0Ev();
extern void _ZN7S858C103v42Ev();
static  VTBL_ENTRY vtc_S858C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S858C10[0]),
  (VTBL_ENTRY)&_ZN7S858C10D1Ev,
  (VTBL_ENTRY)&_ZN7S858C10D0Ev,
  (VTBL_ENTRY)&_ZN7S858C103v42Ev,
};
extern VTBL_ENTRY _ZTI7S858C10[];
extern  VTBL_ENTRY _ZTV7S858C10[];
Class_Descriptor cd_S858C10 = {  "S858C10", // class name
  0,0,//no base classes
  &(vtc_S858C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S858C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S858C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C11_nt  {
  __tsi64 s858c11f0[4];
  void  mf858c11(); // _ZN10S858C11_nt8mf858c11Ev
};
//SIG(-1 S858C11_nt) C1{ m FL[4]}


void  S858C11_nt ::mf858c11(){}

//skip512 S858C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C12_nt  {
  void *s858c12f0;
  ::S858C11_nt s858c12f1;
  ::S9123C16_nt s858c12f2;
  int s858c12f3;
  char s858c12f4;
  void  mf858c12(); // _ZN10S858C12_nt8mf858c12Ev
};
//SIG(-1 S858C12_nt) C1{ m Fp FC2{ m FL[4]} FC3{ m Fp FC4{ Fi[4]}} Fi Fc}


void  S858C12_nt ::mf858c12(){}

//skip512 S858C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C15_nt  : S858C6 , S858C10 {
  void *s858c15f0[2];
  virtual  ~S858C15_nt(); // _ZN10S858C15_ntD1Ev
  virtual void  v84(); // _ZN10S858C15_nt3v84Ev
  virtual void  v85(); // _ZN10S858C15_nt3v85Ev
  S858C15_nt(); // tgen
};
//SIG(-1 S858C15_nt) C1{ BC2{ vd v3} BC3{ vd v4} vd v1 v2 Fp[2]}


 S858C15_nt ::~S858C15_nt(){ note_dtor("S858C15_nt", this);}
void  S858C15_nt ::v84(){vfunc_called(this, "_ZN10S858C15_nt3v84Ev");}
void  S858C15_nt ::v85(){vfunc_called(this, "_ZN10S858C15_nt3v85Ev");}
S858C15_nt ::S858C15_nt(){ note_ctor("S858C15_nt", this);} // tgen

//skip512 S858C15_nt

#else // __cplusplus

extern void _ZN10S858C15_ntC1Ev();
extern void _ZN10S858C15_ntD1Ev();
Name_Map name_map_S858C15_nt[] = {
  NSPAIR(_ZN10S858C15_ntC1Ev),
  NSPAIR(_ZN10S858C15_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S858C6;
extern VTBL_ENTRY _ZTI6S858C6[];
extern  VTBL_ENTRY _ZTV6S858C6[];
extern Class_Descriptor cd_S858C10;
extern VTBL_ENTRY _ZTI7S858C10[];
extern  VTBL_ENTRY _ZTV7S858C10[];
static Base_Class bases_S858C15_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S858C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S858C10,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S858C15_nt[];
extern void _ZN10S858C15_ntD1Ev();
extern void _ZN10S858C15_ntD0Ev();
extern void _ZN6S858C63v16Ev();
extern void _ZN10S858C15_nt3v84Ev();
extern void _ZN10S858C15_nt3v85Ev();
extern void ABISELECT(_ZThn8_N10S858C15_ntD1Ev,_ZThn4_N10S858C15_ntD1Ev)();
extern void ABISELECT(_ZThn8_N10S858C15_ntD0Ev,_ZThn4_N10S858C15_ntD0Ev)();
extern void _ZN7S858C103v42Ev();
static  VTBL_ENTRY vtc_S858C15_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S858C15_nt[0]),
  (VTBL_ENTRY)&_ZN10S858C15_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S858C15_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S858C63v16Ev,
  (VTBL_ENTRY)&_ZN10S858C15_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S858C15_nt3v85Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI10S858C15_nt[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S858C15_ntD1Ev,_ZThn4_N10S858C15_ntD1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S858C15_ntD0Ev,_ZThn4_N10S858C15_ntD0Ev),
  (VTBL_ENTRY)&_ZN7S858C103v42Ev,
};
extern VTBL_ENTRY _ZTI10S858C15_nt[];
VTBL_ENTRY *P__ZTI10S858C15_nt = _ZTI10S858C15_nt; 
extern  VTBL_ENTRY _ZTV10S858C15_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C2  : S858C3 , S858C10 {
  ::S858C11_nt s858c2f0;
  ::S858C12_nt s858c2f1;
  char s858c2f2[2];
  void *s858c2f3;
  ::S858C15_nt s858c2f4;
  void *s858c2f5;
  virtual  ~S858C2(); // _ZN6S858C2D1Ev
  virtual void  v43(); // _ZN6S858C23v43Ev
  virtual void  v44(); // _ZN6S858C23v44Ev
  virtual void  v45(); // _ZN6S858C23v45Ev
  virtual void  v46(); // _ZN6S858C23v46Ev
  virtual void  v47(); // _ZN6S858C23v47Ev
  virtual void  v48(); // _ZN6S858C23v48Ev
  virtual void  v49(); // _ZN6S858C23v49Ev
  virtual void  v50(); // _ZN6S858C23v50Ev
  virtual void  v51(); // _ZN6S858C23v51Ev
  virtual void  v52(); // _ZN6S858C23v52Ev
  virtual void  v53(); // _ZN6S858C23v53Ev
  virtual void  v54(); // _ZN6S858C23v54Ev
  virtual void  v55(); // _ZN6S858C23v55Ev
  virtual void  v56(); // _ZN6S858C23v56Ev
  virtual void  v57(); // _ZN6S858C23v57Ev
  virtual void  v58(); // _ZN6S858C23v58Ev
  virtual void  v59(); // _ZN6S858C23v59Ev
  virtual void  v60(); // _ZN6S858C23v60Ev
  virtual void  v61(); // _ZN6S858C23v61Ev
  virtual void  v62(); // _ZN6S858C23v62Ev
  virtual void  v63(); // _ZN6S858C23v63Ev
  virtual void  v64(); // _ZN6S858C23v64Ev
  virtual void  v65(); // _ZN6S858C23v65Ev
  virtual void  v66(); // _ZN6S858C23v66Ev
  virtual void  v67(); // _ZN6S858C23v67Ev
  virtual void  v68(); // _ZN6S858C23v68Ev
  virtual void  v69(); // _ZN6S858C23v69Ev
  virtual void  v70(); // _ZN6S858C23v70Ev
  virtual void  v71(); // _ZN6S858C23v71Ev
  virtual void  v72(); // _ZN6S858C23v72Ev
  virtual void  v73(); // _ZN6S858C23v73Ev
  virtual void  v74(); // _ZN6S858C23v74Ev
  virtual void  v75(); // _ZN6S858C23v75Ev
  virtual void  v76(); // _ZN6S858C23v76Ev
  virtual void  v77(); // _ZN6S858C23v77Ev
  virtual void  v78(); // _ZN6S858C23v78Ev
  virtual void  v79(); // _ZN6S858C23v79Ev
  virtual void  v80(); // _ZN6S858C23v80Ev
  virtual void  v81(); // _ZN6S858C23v81Ev
  virtual void  v82(); // _ZN6S858C23v82Ev
  virtual void  v83(); // _ZN6S858C23v83Ev
  S858C2(); // tgen
};
//SIG(-1 S858C2) C1{ BC2{ BC3{ BC4{ vd v42 v43 v44} BC5{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FL[4]} Fc} BC9{ vd v71} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC10{ m FL[4]} FC11{ m Fp FC10 FC12{ m Fp FC13{ Fi[4]}} Fi Fc} Fc[2] Fp FC14{ BC5 BC9 vd v72 v73 Fp[2]} Fp}


 S858C2 ::~S858C2(){ note_dtor("S858C2", this);}
void  S858C2 ::v43(){vfunc_called(this, "_ZN6S858C23v43Ev");}
void  S858C2 ::v44(){vfunc_called(this, "_ZN6S858C23v44Ev");}
void  S858C2 ::v45(){vfunc_called(this, "_ZN6S858C23v45Ev");}
void  S858C2 ::v46(){vfunc_called(this, "_ZN6S858C23v46Ev");}
void  S858C2 ::v47(){vfunc_called(this, "_ZN6S858C23v47Ev");}
void  S858C2 ::v48(){vfunc_called(this, "_ZN6S858C23v48Ev");}
void  S858C2 ::v49(){vfunc_called(this, "_ZN6S858C23v49Ev");}
void  S858C2 ::v50(){vfunc_called(this, "_ZN6S858C23v50Ev");}
void  S858C2 ::v51(){vfunc_called(this, "_ZN6S858C23v51Ev");}
void  S858C2 ::v52(){vfunc_called(this, "_ZN6S858C23v52Ev");}
void  S858C2 ::v53(){vfunc_called(this, "_ZN6S858C23v53Ev");}
void  S858C2 ::v54(){vfunc_called(this, "_ZN6S858C23v54Ev");}
void  S858C2 ::v55(){vfunc_called(this, "_ZN6S858C23v55Ev");}
void  S858C2 ::v56(){vfunc_called(this, "_ZN6S858C23v56Ev");}
void  S858C2 ::v57(){vfunc_called(this, "_ZN6S858C23v57Ev");}
void  S858C2 ::v58(){vfunc_called(this, "_ZN6S858C23v58Ev");}
void  S858C2 ::v59(){vfunc_called(this, "_ZN6S858C23v59Ev");}
void  S858C2 ::v60(){vfunc_called(this, "_ZN6S858C23v60Ev");}
void  S858C2 ::v61(){vfunc_called(this, "_ZN6S858C23v61Ev");}
void  S858C2 ::v62(){vfunc_called(this, "_ZN6S858C23v62Ev");}
void  S858C2 ::v63(){vfunc_called(this, "_ZN6S858C23v63Ev");}
void  S858C2 ::v64(){vfunc_called(this, "_ZN6S858C23v64Ev");}
void  S858C2 ::v65(){vfunc_called(this, "_ZN6S858C23v65Ev");}
void  S858C2 ::v66(){vfunc_called(this, "_ZN6S858C23v66Ev");}
void  S858C2 ::v67(){vfunc_called(this, "_ZN6S858C23v67Ev");}
void  S858C2 ::v68(){vfunc_called(this, "_ZN6S858C23v68Ev");}
void  S858C2 ::v69(){vfunc_called(this, "_ZN6S858C23v69Ev");}
void  S858C2 ::v70(){vfunc_called(this, "_ZN6S858C23v70Ev");}
void  S858C2 ::v71(){vfunc_called(this, "_ZN6S858C23v71Ev");}
void  S858C2 ::v72(){vfunc_called(this, "_ZN6S858C23v72Ev");}
void  S858C2 ::v73(){vfunc_called(this, "_ZN6S858C23v73Ev");}
void  S858C2 ::v74(){vfunc_called(this, "_ZN6S858C23v74Ev");}
void  S858C2 ::v75(){vfunc_called(this, "_ZN6S858C23v75Ev");}
void  S858C2 ::v76(){vfunc_called(this, "_ZN6S858C23v76Ev");}
void  S858C2 ::v77(){vfunc_called(this, "_ZN6S858C23v77Ev");}
void  S858C2 ::v78(){vfunc_called(this, "_ZN6S858C23v78Ev");}
void  S858C2 ::v79(){vfunc_called(this, "_ZN6S858C23v79Ev");}
void  S858C2 ::v80(){vfunc_called(this, "_ZN6S858C23v80Ev");}
void  S858C2 ::v81(){vfunc_called(this, "_ZN6S858C23v81Ev");}
void  S858C2 ::v82(){vfunc_called(this, "_ZN6S858C23v82Ev");}
void  S858C2 ::v83(){vfunc_called(this, "_ZN6S858C23v83Ev");}
S858C2 ::S858C2(){ note_ctor("S858C2", this);} // tgen

static void Test_S858C2()
{
  extern Class_Descriptor cd_S858C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S858C2, buf);
    S858C2 *dp, &lv = *(dp=new (buf) S858C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S858C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S858C2)");
    check_base_class_offset(lv, (S858C5_nt*)(S858C4_nt*)(S858C3*), 0, "S858C2");
    check_base_class_offset(lv, (S858C6*)(S858C4_nt*)(S858C3*), ABISELECT(8,4), "S858C2");
    check_base_class_offset(lv, (S858C4_nt*)(S858C3*), 0, "S858C2");
    check_base_class_offset(lv, (S858C3*), 0, "S858C2");
    check_base_class_offset(lv, (S858C10*), ABISELECT(80,60), "S858C2");
    check_field_offset(lv, s858c2f0, ABISELECT(88,64), "S858C2.s858c2f0");
    check_field_offset(lv, s858c2f1, ABISELECT(120,96), "S858C2.s858c2f1");
    check_field_offset(lv, s858c2f2, ABISELECT(192,160), "S858C2.s858c2f2");
    check_field_offset(lv, s858c2f3, ABISELECT(200,164), "S858C2.s858c2f3");
    check_field_offset(lv, s858c2f4, ABISELECT(208,168), "S858C2.s858c2f4");
    check_field_offset(lv, s858c2f5, ABISELECT(240,184), "S858C2.s858c2f5");
    test_class_info(&lv, &cd_S858C2);
    dp->~S858C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS858C2(Test_S858C2, "S858C2", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S858C2C1Ev();
extern void _ZN6S858C2D1Ev();
Name_Map name_map_S858C2[] = {
  NSPAIR(_ZN6S858C2C1Ev),
  NSPAIR(_ZN6S858C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S858C5_nt;
extern VTBL_ENTRY _ZTI9S858C5_nt[];
extern  VTBL_ENTRY _ZTV9S858C5_nt[];
extern Class_Descriptor cd_S858C6;
extern VTBL_ENTRY _ZTI6S858C6[];
extern  VTBL_ENTRY _ZTV6S858C6[];
extern Class_Descriptor cd_S858C4_nt;
extern VTBL_ENTRY _ZTI9S858C4_nt[];
extern  VTBL_ENTRY _ZTV9S858C4_nt[];
extern Class_Descriptor cd_S858C3;
extern VTBL_ENTRY _ZTI6S858C3[];
extern  VTBL_ENTRY _ZTV6S858C3[];
extern Class_Descriptor cd_S858C10;
extern VTBL_ENTRY _ZTI7S858C10[];
extern  VTBL_ENTRY _ZTV7S858C10[];
static Base_Class bases_S858C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S858C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S858C6,    ABISELECT(8,4), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S858C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S858C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S858C10,    ABISELECT(80,60), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S858C2[];
extern void _ZN6S858C2D1Ev();
extern void _ZN6S858C2D0Ev();
extern void _ZN9S858C5_nt3v13Ev();
extern void _ZN9S858C5_nt3v14Ev();
extern void _ZN9S858C5_nt3v15Ev();
extern void _ZN9S858C4_nt3v17Ev();
extern void _ZN9S858C4_nt3v18Ev();
extern void _ZN9S858C4_nt3v19Ev();
extern void _ZN9S858C4_nt3v20Ev();
extern void _ZN9S858C4_nt3v21Ev();
extern void _ZN9S858C4_nt3v22Ev();
extern void _ZN9S858C4_nt3v23Ev();
extern void _ZN9S858C4_nt3v24Ev();
extern void _ZN9S858C4_nt3v25Ev();
extern void _ZN9S858C4_nt3v26Ev();
extern void _ZN9S858C4_nt3v27Ev();
extern void _ZN9S858C4_nt3v28Ev();
extern void _ZN9S858C4_nt3v29Ev();
extern void _ZN9S858C4_nt3v30Ev();
extern void _ZN9S858C4_nt3v31Ev();
extern void _ZN9S858C4_nt3v32Ev();
extern void _ZN9S858C4_nt3v33Ev();
extern void _ZN9S858C4_nt3v34Ev();
extern void _ZN9S858C4_nt3v35Ev();
extern void _ZN9S858C4_nt3v36Ev();
extern void _ZN9S858C4_nt3v37Ev();
extern void _ZN9S858C4_nt3v38Ev();
extern void _ZN6S858C33v39Ev();
extern void _ZN6S858C33v40Ev();
extern void _ZN6S858C33v41Ev();
extern void _ZN6S858C23v43Ev();
extern void _ZN6S858C23v44Ev();
extern void _ZN6S858C23v45Ev();
extern void _ZN6S858C23v46Ev();
extern void _ZN6S858C23v47Ev();
extern void _ZN6S858C23v48Ev();
extern void _ZN6S858C23v49Ev();
extern void _ZN6S858C23v50Ev();
extern void _ZN6S858C23v51Ev();
extern void _ZN6S858C23v52Ev();
extern void _ZN6S858C23v53Ev();
extern void _ZN6S858C23v54Ev();
extern void _ZN6S858C23v55Ev();
extern void _ZN6S858C23v56Ev();
extern void _ZN6S858C23v57Ev();
extern void _ZN6S858C23v58Ev();
extern void _ZN6S858C23v59Ev();
extern void _ZN6S858C23v60Ev();
extern void _ZN6S858C23v61Ev();
extern void _ZN6S858C23v62Ev();
extern void _ZN6S858C23v63Ev();
extern void _ZN6S858C23v64Ev();
extern void _ZN6S858C23v65Ev();
extern void _ZN6S858C23v66Ev();
extern void _ZN6S858C23v67Ev();
extern void _ZN6S858C23v68Ev();
extern void _ZN6S858C23v69Ev();
extern void _ZN6S858C23v70Ev();
extern void _ZN6S858C23v71Ev();
extern void _ZN6S858C23v72Ev();
extern void _ZN6S858C23v73Ev();
extern void _ZN6S858C23v74Ev();
extern void _ZN6S858C23v75Ev();
extern void _ZN6S858C23v76Ev();
extern void _ZN6S858C23v77Ev();
extern void _ZN6S858C23v78Ev();
extern void _ZN6S858C23v79Ev();
extern void _ZN6S858C23v80Ev();
extern void _ZN6S858C23v81Ev();
extern void _ZN6S858C23v82Ev();
extern void _ZN6S858C23v83Ev();
extern void ABISELECT(_ZThn8_N6S858C2D1Ev,_ZThn4_N6S858C2D1Ev)();
extern void ABISELECT(_ZThn8_N6S858C2D0Ev,_ZThn4_N6S858C2D0Ev)();
extern void _ZN6S858C63v16Ev();
extern void ABISELECT(_ZThn80_N6S858C2D1Ev,_ZThn60_N6S858C2D1Ev)();
extern void ABISELECT(_ZThn80_N6S858C2D0Ev,_ZThn60_N6S858C2D0Ev)();
extern void _ZN7S858C103v42Ev();
static  VTBL_ENTRY vtc_S858C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S858C2[0]),
  (VTBL_ENTRY)&_ZN6S858C2D1Ev,
  (VTBL_ENTRY)&_ZN6S858C2D0Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN6S858C33v39Ev,
  (VTBL_ENTRY)&_ZN6S858C33v40Ev,
  (VTBL_ENTRY)&_ZN6S858C33v41Ev,
  (VTBL_ENTRY)&_ZN6S858C23v43Ev,
  (VTBL_ENTRY)&_ZN6S858C23v44Ev,
  (VTBL_ENTRY)&_ZN6S858C23v45Ev,
  (VTBL_ENTRY)&_ZN6S858C23v46Ev,
  (VTBL_ENTRY)&_ZN6S858C23v47Ev,
  (VTBL_ENTRY)&_ZN6S858C23v48Ev,
  (VTBL_ENTRY)&_ZN6S858C23v49Ev,
  (VTBL_ENTRY)&_ZN6S858C23v50Ev,
  (VTBL_ENTRY)&_ZN6S858C23v51Ev,
  (VTBL_ENTRY)&_ZN6S858C23v52Ev,
  (VTBL_ENTRY)&_ZN6S858C23v53Ev,
  (VTBL_ENTRY)&_ZN6S858C23v54Ev,
  (VTBL_ENTRY)&_ZN6S858C23v55Ev,
  (VTBL_ENTRY)&_ZN6S858C23v56Ev,
  (VTBL_ENTRY)&_ZN6S858C23v57Ev,
  (VTBL_ENTRY)&_ZN6S858C23v58Ev,
  (VTBL_ENTRY)&_ZN6S858C23v59Ev,
  (VTBL_ENTRY)&_ZN6S858C23v60Ev,
  (VTBL_ENTRY)&_ZN6S858C23v61Ev,
  (VTBL_ENTRY)&_ZN6S858C23v62Ev,
  (VTBL_ENTRY)&_ZN6S858C23v63Ev,
  (VTBL_ENTRY)&_ZN6S858C23v64Ev,
  (VTBL_ENTRY)&_ZN6S858C23v65Ev,
  (VTBL_ENTRY)&_ZN6S858C23v66Ev,
  (VTBL_ENTRY)&_ZN6S858C23v67Ev,
  (VTBL_ENTRY)&_ZN6S858C23v68Ev,
  (VTBL_ENTRY)&_ZN6S858C23v69Ev,
  (VTBL_ENTRY)&_ZN6S858C23v70Ev,
  (VTBL_ENTRY)&_ZN6S858C23v71Ev,
  (VTBL_ENTRY)&_ZN6S858C23v72Ev,
  (VTBL_ENTRY)&_ZN6S858C23v73Ev,
  (VTBL_ENTRY)&_ZN6S858C23v74Ev,
  (VTBL_ENTRY)&_ZN6S858C23v75Ev,
  (VTBL_ENTRY)&_ZN6S858C23v76Ev,
  (VTBL_ENTRY)&_ZN6S858C23v77Ev,
  (VTBL_ENTRY)&_ZN6S858C23v78Ev,
  (VTBL_ENTRY)&_ZN6S858C23v79Ev,
  (VTBL_ENTRY)&_ZN6S858C23v80Ev,
  (VTBL_ENTRY)&_ZN6S858C23v81Ev,
  (VTBL_ENTRY)&_ZN6S858C23v82Ev,
  (VTBL_ENTRY)&_ZN6S858C23v83Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S858C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S858C2D1Ev,_ZThn4_N6S858C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S858C2D0Ev,_ZThn4_N6S858C2D0Ev),
  (VTBL_ENTRY)&_ZN6S858C63v16Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S858C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S858C2D1Ev,_ZThn60_N6S858C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S858C2D0Ev,_ZThn60_N6S858C2D0Ev),
  (VTBL_ENTRY)&_ZN7S858C103v42Ev,
};
extern VTBL_ENTRY _ZTI6S858C2[];
extern  VTBL_ENTRY _ZTV6S858C2[];
Class_Descriptor cd_S858C2 = {  "S858C2", // class name
  bases_S858C2, 5,
  &(vtc_S858C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S858C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S858C2),83, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S858C1  : S858C2 {
  virtual  ~S858C1(); // _ZN6S858C1D1Ev
  virtual void  v1(); // _ZN6S858C12v1Ev
  virtual void  v2(); // _ZN6S858C12v2Ev
  virtual void  v3(); // _ZN6S858C12v3Ev
  virtual void  v4(); // _ZN6S858C12v4Ev
  virtual void  v5(); // _ZN6S858C12v5Ev
  virtual void  v6(); // _ZN6S858C12v6Ev
  virtual void  v7(); // _ZN6S858C12v7Ev
  virtual void  v8(); // _ZN6S858C12v8Ev
  virtual void  v9(); // _ZN6S858C12v9Ev
  virtual void  v10(); // _ZN6S858C13v10Ev
  virtual void  v11(); // _ZN6S858C13v11Ev
  virtual void  v12(); // _ZN6S858C13v12Ev
  S858C1(); // tgen
};
//SIG(1 S858C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v13 v14 v15} BC6{ vd v16} vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38} vd v39 v40 v41 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v42} vd v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 FC11{ m FL[4]} FC12{ m Fp FC11 FC13{ m Fp FC14{ Fi[4]}} Fi Fc} Fc[2] Fp FC15{ BC6 BC10 vd v84 v85 Fp[2]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12}


 S858C1 ::~S858C1(){ note_dtor("S858C1", this);}
void  S858C1 ::v1(){vfunc_called(this, "_ZN6S858C12v1Ev");}
void  S858C1 ::v2(){vfunc_called(this, "_ZN6S858C12v2Ev");}
void  S858C1 ::v3(){vfunc_called(this, "_ZN6S858C12v3Ev");}
void  S858C1 ::v4(){vfunc_called(this, "_ZN6S858C12v4Ev");}
void  S858C1 ::v5(){vfunc_called(this, "_ZN6S858C12v5Ev");}
void  S858C1 ::v6(){vfunc_called(this, "_ZN6S858C12v6Ev");}
void  S858C1 ::v7(){vfunc_called(this, "_ZN6S858C12v7Ev");}
void  S858C1 ::v8(){vfunc_called(this, "_ZN6S858C12v8Ev");}
void  S858C1 ::v9(){vfunc_called(this, "_ZN6S858C12v9Ev");}
void  S858C1 ::v10(){vfunc_called(this, "_ZN6S858C13v10Ev");}
void  S858C1 ::v11(){vfunc_called(this, "_ZN6S858C13v11Ev");}
void  S858C1 ::v12(){vfunc_called(this, "_ZN6S858C13v12Ev");}
S858C1 ::S858C1(){ note_ctor("S858C1", this);} // tgen

static void Test_S858C1()
{
  extern Class_Descriptor cd_S858C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S858C1, buf);
    S858C1 *dp, &lv = *(dp=new (buf) S858C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S858C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S858C1)");
    check_base_class_offset(lv, (S858C5_nt*)(S858C4_nt*)(S858C3*)(S858C2*), 0, "S858C1");
    check_base_class_offset(lv, (S858C6*)(S858C4_nt*)(S858C3*)(S858C2*), ABISELECT(8,4), "S858C1");
    check_base_class_offset(lv, (S858C4_nt*)(S858C3*)(S858C2*), 0, "S858C1");
    check_base_class_offset(lv, (S858C3*)(S858C2*), 0, "S858C1");
    check_base_class_offset(lv, (S858C10*)(S858C2*), ABISELECT(80,60), "S858C1");
    check_base_class_offset(lv, (S858C2*), 0, "S858C1");
    test_class_info(&lv, &cd_S858C1);
    dp->~S858C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS858C1(Test_S858C1, "S858C1", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S858C1C1Ev();
extern void _ZN6S858C1D1Ev();
Name_Map name_map_S858C1[] = {
  NSPAIR(_ZN6S858C1C1Ev),
  NSPAIR(_ZN6S858C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S858C5_nt;
extern VTBL_ENTRY _ZTI9S858C5_nt[];
extern  VTBL_ENTRY _ZTV9S858C5_nt[];
extern Class_Descriptor cd_S858C6;
extern VTBL_ENTRY _ZTI6S858C6[];
extern  VTBL_ENTRY _ZTV6S858C6[];
extern Class_Descriptor cd_S858C4_nt;
extern VTBL_ENTRY _ZTI9S858C4_nt[];
extern  VTBL_ENTRY _ZTV9S858C4_nt[];
extern Class_Descriptor cd_S858C3;
extern VTBL_ENTRY _ZTI6S858C3[];
extern  VTBL_ENTRY _ZTV6S858C3[];
extern Class_Descriptor cd_S858C10;
extern VTBL_ENTRY _ZTI7S858C10[];
extern  VTBL_ENTRY _ZTV7S858C10[];
extern Class_Descriptor cd_S858C2;
extern VTBL_ENTRY _ZTI6S858C2[];
extern  VTBL_ENTRY _ZTV6S858C2[];
static Base_Class bases_S858C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S858C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S858C6,    ABISELECT(8,4), //bcp->offset
    85, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S858C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S858C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S858C10,    ABISELECT(80,60), //bcp->offset
    90, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S858C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S858C1[];
extern void _ZN6S858C1D1Ev();
extern void _ZN6S858C1D0Ev();
extern void _ZN9S858C5_nt3v13Ev();
extern void _ZN9S858C5_nt3v14Ev();
extern void _ZN9S858C5_nt3v15Ev();
extern void _ZN9S858C4_nt3v17Ev();
extern void _ZN9S858C4_nt3v18Ev();
extern void _ZN9S858C4_nt3v19Ev();
extern void _ZN9S858C4_nt3v20Ev();
extern void _ZN9S858C4_nt3v21Ev();
extern void _ZN9S858C4_nt3v22Ev();
extern void _ZN9S858C4_nt3v23Ev();
extern void _ZN9S858C4_nt3v24Ev();
extern void _ZN9S858C4_nt3v25Ev();
extern void _ZN9S858C4_nt3v26Ev();
extern void _ZN9S858C4_nt3v27Ev();
extern void _ZN9S858C4_nt3v28Ev();
extern void _ZN9S858C4_nt3v29Ev();
extern void _ZN9S858C4_nt3v30Ev();
extern void _ZN9S858C4_nt3v31Ev();
extern void _ZN9S858C4_nt3v32Ev();
extern void _ZN9S858C4_nt3v33Ev();
extern void _ZN9S858C4_nt3v34Ev();
extern void _ZN9S858C4_nt3v35Ev();
extern void _ZN9S858C4_nt3v36Ev();
extern void _ZN9S858C4_nt3v37Ev();
extern void _ZN9S858C4_nt3v38Ev();
extern void _ZN6S858C33v39Ev();
extern void _ZN6S858C33v40Ev();
extern void _ZN6S858C33v41Ev();
extern void _ZN6S858C23v43Ev();
extern void _ZN6S858C23v44Ev();
extern void _ZN6S858C23v45Ev();
extern void _ZN6S858C23v46Ev();
extern void _ZN6S858C23v47Ev();
extern void _ZN6S858C23v48Ev();
extern void _ZN6S858C23v49Ev();
extern void _ZN6S858C23v50Ev();
extern void _ZN6S858C23v51Ev();
extern void _ZN6S858C23v52Ev();
extern void _ZN6S858C23v53Ev();
extern void _ZN6S858C23v54Ev();
extern void _ZN6S858C23v55Ev();
extern void _ZN6S858C23v56Ev();
extern void _ZN6S858C23v57Ev();
extern void _ZN6S858C23v58Ev();
extern void _ZN6S858C23v59Ev();
extern void _ZN6S858C23v60Ev();
extern void _ZN6S858C23v61Ev();
extern void _ZN6S858C23v62Ev();
extern void _ZN6S858C23v63Ev();
extern void _ZN6S858C23v64Ev();
extern void _ZN6S858C23v65Ev();
extern void _ZN6S858C23v66Ev();
extern void _ZN6S858C23v67Ev();
extern void _ZN6S858C23v68Ev();
extern void _ZN6S858C23v69Ev();
extern void _ZN6S858C23v70Ev();
extern void _ZN6S858C23v71Ev();
extern void _ZN6S858C23v72Ev();
extern void _ZN6S858C23v73Ev();
extern void _ZN6S858C23v74Ev();
extern void _ZN6S858C23v75Ev();
extern void _ZN6S858C23v76Ev();
extern void _ZN6S858C23v77Ev();
extern void _ZN6S858C23v78Ev();
extern void _ZN6S858C23v79Ev();
extern void _ZN6S858C23v80Ev();
extern void _ZN6S858C23v81Ev();
extern void _ZN6S858C23v82Ev();
extern void _ZN6S858C23v83Ev();
extern void _ZN6S858C12v1Ev();
extern void _ZN6S858C12v2Ev();
extern void _ZN6S858C12v3Ev();
extern void _ZN6S858C12v4Ev();
extern void _ZN6S858C12v5Ev();
extern void _ZN6S858C12v6Ev();
extern void _ZN6S858C12v7Ev();
extern void _ZN6S858C12v8Ev();
extern void _ZN6S858C12v9Ev();
extern void _ZN6S858C13v10Ev();
extern void _ZN6S858C13v11Ev();
extern void _ZN6S858C13v12Ev();
extern void ABISELECT(_ZThn8_N6S858C1D1Ev,_ZThn4_N6S858C1D1Ev)();
extern void ABISELECT(_ZThn8_N6S858C1D0Ev,_ZThn4_N6S858C1D0Ev)();
extern void _ZN6S858C63v16Ev();
extern void ABISELECT(_ZThn80_N6S858C1D1Ev,_ZThn60_N6S858C1D1Ev)();
extern void ABISELECT(_ZThn80_N6S858C1D0Ev,_ZThn60_N6S858C1D0Ev)();
extern void _ZN7S858C103v42Ev();
static  VTBL_ENTRY vtc_S858C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S858C1[0]),
  (VTBL_ENTRY)&_ZN6S858C1D1Ev,
  (VTBL_ENTRY)&_ZN6S858C1D0Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S858C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S858C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN6S858C33v39Ev,
  (VTBL_ENTRY)&_ZN6S858C33v40Ev,
  (VTBL_ENTRY)&_ZN6S858C33v41Ev,
  (VTBL_ENTRY)&_ZN6S858C23v43Ev,
  (VTBL_ENTRY)&_ZN6S858C23v44Ev,
  (VTBL_ENTRY)&_ZN6S858C23v45Ev,
  (VTBL_ENTRY)&_ZN6S858C23v46Ev,
  (VTBL_ENTRY)&_ZN6S858C23v47Ev,
  (VTBL_ENTRY)&_ZN6S858C23v48Ev,
  (VTBL_ENTRY)&_ZN6S858C23v49Ev,
  (VTBL_ENTRY)&_ZN6S858C23v50Ev,
  (VTBL_ENTRY)&_ZN6S858C23v51Ev,
  (VTBL_ENTRY)&_ZN6S858C23v52Ev,
  (VTBL_ENTRY)&_ZN6S858C23v53Ev,
  (VTBL_ENTRY)&_ZN6S858C23v54Ev,
  (VTBL_ENTRY)&_ZN6S858C23v55Ev,
  (VTBL_ENTRY)&_ZN6S858C23v56Ev,
  (VTBL_ENTRY)&_ZN6S858C23v57Ev,
  (VTBL_ENTRY)&_ZN6S858C23v58Ev,
  (VTBL_ENTRY)&_ZN6S858C23v59Ev,
  (VTBL_ENTRY)&_ZN6S858C23v60Ev,
  (VTBL_ENTRY)&_ZN6S858C23v61Ev,
  (VTBL_ENTRY)&_ZN6S858C23v62Ev,
  (VTBL_ENTRY)&_ZN6S858C23v63Ev,
  (VTBL_ENTRY)&_ZN6S858C23v64Ev,
  (VTBL_ENTRY)&_ZN6S858C23v65Ev,
  (VTBL_ENTRY)&_ZN6S858C23v66Ev,
  (VTBL_ENTRY)&_ZN6S858C23v67Ev,
  (VTBL_ENTRY)&_ZN6S858C23v68Ev,
  (VTBL_ENTRY)&_ZN6S858C23v69Ev,
  (VTBL_ENTRY)&_ZN6S858C23v70Ev,
  (VTBL_ENTRY)&_ZN6S858C23v71Ev,
  (VTBL_ENTRY)&_ZN6S858C23v72Ev,
  (VTBL_ENTRY)&_ZN6S858C23v73Ev,
  (VTBL_ENTRY)&_ZN6S858C23v74Ev,
  (VTBL_ENTRY)&_ZN6S858C23v75Ev,
  (VTBL_ENTRY)&_ZN6S858C23v76Ev,
  (VTBL_ENTRY)&_ZN6S858C23v77Ev,
  (VTBL_ENTRY)&_ZN6S858C23v78Ev,
  (VTBL_ENTRY)&_ZN6S858C23v79Ev,
  (VTBL_ENTRY)&_ZN6S858C23v80Ev,
  (VTBL_ENTRY)&_ZN6S858C23v81Ev,
  (VTBL_ENTRY)&_ZN6S858C23v82Ev,
  (VTBL_ENTRY)&_ZN6S858C23v83Ev,
  (VTBL_ENTRY)&_ZN6S858C12v1Ev,
  (VTBL_ENTRY)&_ZN6S858C12v2Ev,
  (VTBL_ENTRY)&_ZN6S858C12v3Ev,
  (VTBL_ENTRY)&_ZN6S858C12v4Ev,
  (VTBL_ENTRY)&_ZN6S858C12v5Ev,
  (VTBL_ENTRY)&_ZN6S858C12v6Ev,
  (VTBL_ENTRY)&_ZN6S858C12v7Ev,
  (VTBL_ENTRY)&_ZN6S858C12v8Ev,
  (VTBL_ENTRY)&_ZN6S858C12v9Ev,
  (VTBL_ENTRY)&_ZN6S858C13v10Ev,
  (VTBL_ENTRY)&_ZN6S858C13v11Ev,
  (VTBL_ENTRY)&_ZN6S858C13v12Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S858C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S858C1D1Ev,_ZThn4_N6S858C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S858C1D0Ev,_ZThn4_N6S858C1D0Ev),
  (VTBL_ENTRY)&_ZN6S858C63v16Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S858C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S858C1D1Ev,_ZThn60_N6S858C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S858C1D0Ev,_ZThn60_N6S858C1D0Ev),
  (VTBL_ENTRY)&_ZN7S858C103v42Ev,
};
extern VTBL_ENTRY _ZTI6S858C1[];
extern  VTBL_ENTRY _ZTV6S858C1[];
Class_Descriptor cd_S858C1 = {  "S858C1", // class name
  bases_S858C1, 6,
  &(vtc_S858C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S858C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S858C1),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9942C2  {
  virtual  ~S9942C2(); // _ZN7S9942C2D1Ev
  virtual void  v5(); // _ZN7S9942C22v5Ev
  virtual void  v6(); // _ZN7S9942C22v6Ev
  virtual void  v7(); // _ZN7S9942C22v7Ev
  virtual void  v8(); // _ZN7S9942C22v8Ev
  virtual void  v9(); // _ZN7S9942C22v9Ev
  S9942C2(); // tgen
};
//SIG(-1 S9942C2) C1{ vd v1 v2 v3 v4 v5}


 S9942C2 ::~S9942C2(){ note_dtor("S9942C2", this);}
void  S9942C2 ::v5(){vfunc_called(this, "_ZN7S9942C22v5Ev");}
void  S9942C2 ::v6(){vfunc_called(this, "_ZN7S9942C22v6Ev");}
void  S9942C2 ::v7(){vfunc_called(this, "_ZN7S9942C22v7Ev");}
void  S9942C2 ::v8(){vfunc_called(this, "_ZN7S9942C22v8Ev");}
void  S9942C2 ::v9(){vfunc_called(this, "_ZN7S9942C22v9Ev");}
S9942C2 ::S9942C2(){ note_ctor("S9942C2", this);} // tgen

static void Test_S9942C2()
{
  extern Class_Descriptor cd_S9942C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9942C2, buf);
    S9942C2 *dp, &lv = *(dp=new (buf) S9942C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9942C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9942C2)");
    test_class_info(&lv, &cd_S9942C2);
    dp->~S9942C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9942C2(Test_S9942C2, "S9942C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9942C2C1Ev();
extern void _ZN7S9942C2D1Ev();
Name_Map name_map_S9942C2[] = {
  NSPAIR(_ZN7S9942C2C1Ev),
  NSPAIR(_ZN7S9942C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9942C2[];
extern void _ZN7S9942C2D1Ev();
extern void _ZN7S9942C2D0Ev();
extern void _ZN7S9942C22v5Ev();
extern void _ZN7S9942C22v6Ev();
extern void _ZN7S9942C22v7Ev();
extern void _ZN7S9942C22v8Ev();
extern void _ZN7S9942C22v9Ev();
static  VTBL_ENTRY vtc_S9942C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9942C2[0]),
  (VTBL_ENTRY)&_ZN7S9942C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9942C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v9Ev,
};
extern VTBL_ENTRY _ZTI7S9942C2[];
extern  VTBL_ENTRY _ZTV7S9942C2[];
Class_Descriptor cd_S9942C2 = {  "S9942C2", // class name
  0,0,//no base classes
  &(vtc_S9942C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9942C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9942C2),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9942C3  {
  ::S17044C123_nt s9942c3f0;
  ::S17044C123_nt s9942c3f1;
  int s9942c3f2[4];
  char s9942c3f3[2];
  void  mf9942c3(); // _ZN7S9942C38mf9942c3Ev
};
//SIG(-1 S9942C3) C1{ m FC2{ m FL} FC2 Fi[4] Fc[2]}


void  S9942C3 ::mf9942c3(){}

static void Test_S9942C3()
{
  {
    init_simple_test("S9942C3");
    S9942C3 lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S9942C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9942C3)");
    check_field_offset(lv, s9942c3f0, 0, "S9942C3.s9942c3f0");
    check_field_offset(lv, s9942c3f1, 8, "S9942C3.s9942c3f1");
    check_field_offset(lv, s9942c3f2, 16, "S9942C3.s9942c3f2");
    check_field_offset(lv, s9942c3f3, 32, "S9942C3.s9942c3f3");
  }
}
static Arrange_To_Call_Me vS9942C3(Test_S9942C3, "S9942C3", ABISELECT(40,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9942C5  {
  ::S17044C73 s9942c5f0;
  ::S17044C73 s9942c5f1;
  ::S17044C73 s9942c5f2;
  ::S17044C158 s9942c5f3;
  int s9942c5f4;
  int s9942c5f5;
  int s9942c5f6;
  int s9942c5f7;
  char s9942c5f8;
  ::S17044C150 s9942c5f9;
  ::S17044C129 s9942c5f10;
  char s9942c5f11;
  void  mf9942c5(); // _ZN7S9942C58mf9942c5Ev
};
//SIG(-1 S9942C5) C1{ m FC2{ BC3{ BC4{ BC5{}} FC6{ BC7{}}} FU8{ Fc[16] Fp} Fi Fi} FC2 FC2 FC9{ BC10{ BC5 FC11{ BC12{}}} Fp Fp Fp} Fi Fi Fi Fi Fc FC13{ BC14{ BC5 FC15{ BC16{}}} Fp Fp Fp} FC17{ m FC18{ BC19{ BC5 FC20{ BC21{}}} Fp Fp Fp} FC22{ BC23{ BC24{ BC25{ BC5 FC26{ BC27{}}} FC26} FC15} Fp Fp Fi} Fi Fi} Fc}


void  S9942C5 ::mf9942c5(){}

static void Test_S9942C5()
{
  {
    init_simple_test("S9942C5");
    S9942C5 lv;
    check2(sizeof(lv), ABISELECT(264,180), "sizeof(S9942C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9942C5)");
    check_field_offset(lv, s9942c5f0, 0, "S9942C5.s9942c5f0");
    check_field_offset(lv, s9942c5f1, ABISELECT(32,28), "S9942C5.s9942c5f1");
    check_field_offset(lv, s9942c5f2, ABISELECT(64,56), "S9942C5.s9942c5f2");
    check_field_offset(lv, s9942c5f3, ABISELECT(96,84), "S9942C5.s9942c5f3");
    check_field_offset(lv, s9942c5f4, ABISELECT(128,100), "S9942C5.s9942c5f4");
    check_field_offset(lv, s9942c5f5, ABISELECT(132,104), "S9942C5.s9942c5f5");
    check_field_offset(lv, s9942c5f6, ABISELECT(136,108), "S9942C5.s9942c5f6");
    check_field_offset(lv, s9942c5f7, ABISELECT(140,112), "S9942C5.s9942c5f7");
    check_field_offset(lv, s9942c5f8, ABISELECT(144,116), "S9942C5.s9942c5f8");
    check_field_offset(lv, s9942c5f9, ABISELECT(152,120), "S9942C5.s9942c5f9");
    check_field_offset(lv, s9942c5f10, ABISELECT(184,136), "S9942C5.s9942c5f10");
    check_field_offset(lv, s9942c5f11, ABISELECT(256,176), "S9942C5.s9942c5f11");
  }
}
static Arrange_To_Call_Me vS9942C5(Test_S9942C5, "S9942C5", ABISELECT(264,180));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9942C36  {
  int s9942c36f0;
  int s9942c36f1;
  char s9942c36f2;
  int s9942c36f3;
  void  mf9942c36(); // _ZN8S9942C369mf9942c36Ev
};
//SIG(-1 S9942C36) C1{ m Fi[2] Fc Fi}


void  S9942C36 ::mf9942c36(){}

static void Test_S9942C36()
{
  {
    init_simple_test("S9942C36");
    S9942C36 lv;
    check2(sizeof(lv), 16, "sizeof(S9942C36)");
    check2(__alignof__(lv), 4, "__alignof__(S9942C36)");
    check_field_offset(lv, s9942c36f0, 0, "S9942C36.s9942c36f0");
    check_field_offset(lv, s9942c36f1, 4, "S9942C36.s9942c36f1");
    check_field_offset(lv, s9942c36f2, 8, "S9942C36.s9942c36f2");
    check_field_offset(lv, s9942c36f3, 12, "S9942C36.s9942c36f3");
  }
}
static Arrange_To_Call_Me vS9942C36(Test_S9942C36, "S9942C36", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9942C1  : S9942C2 {
  ::S9942C3 s9942c1f0;
  ::S9942C3 s9942c1f1;
  void *s9942c1f2;
  ::S9942C5 s9942c1f3;
  ::S9942C36 s9942c1f4;
  char s9942c1f5;
  int s9942c1f6;
  int s9942c1f7;
  int s9942c1f8;
  int s9942c1f9;
  int s9942c1f10;
  ::S17044C168 s9942c1f11;
  int s9942c1f12;
  int s9942c1f13;
  char s9942c1f14;
  int s9942c1f15;
  void *s9942c1f16;
  int s9942c1f17;
  ::S17044C130 s9942c1f18;
  ::S17044C121 s9942c1f19;
  int s9942c1f20;
  char s9942c1f21;
  char s9942c1f22;
  void *s9942c1f23;
  virtual  ~S9942C1(); // _ZN7S9942C1D1Ev
  virtual void  v1(); // _ZN7S9942C12v1Ev
  virtual void  v2(); // _ZN7S9942C12v2Ev
  virtual void  v3(); // _ZN7S9942C12v3Ev
  virtual void  v4(); // _ZN7S9942C12v4Ev
  S9942C1(); // tgen
};
//SIG(1 S9942C1) C1{ BC2{ vd v5 v6 v7 v8 v9} vd v1 v2 v3 v4 FC3{ m FC4{ m FL} FC4 Fi[4] Fc[2]} FC3 Fp FC5{ m FC6{ BC7{ BC8{ BC9{}} FC10{ BC11{}}} FU12{ Fc[16] Fp} Fi Fi} FC6 FC6 FC13{ BC14{ BC9 FC15{ BC16{}}} Fp Fp Fp} Fi Fi Fi Fi Fc FC17{ BC18{ BC9 FC19{ BC20{}}} Fp Fp Fp} FC21{ m FC22{ BC23{ BC9 FC24{ BC25{}}} Fp Fp Fp} FC26{ BC27{ BC28{ BC29{ BC9 FC30{ BC31{}}} FC30} FC19} Fp Fp Fi} Fi Fi} Fc} FC32{ m Fi Fi Fc Fi} Fc Fi Fi Fi Fi Fi FC33{ BC34{ BC35{ BC36{ BC37{}}} Fp}} Fi Fi Fc Fi Fp Fi FC22 FC38{ BC39{ m Fp}} Fi Fc Fc Fp}


 S9942C1 ::~S9942C1(){ note_dtor("S9942C1", this);}
void  S9942C1 ::v1(){vfunc_called(this, "_ZN7S9942C12v1Ev");}
void  S9942C1 ::v2(){vfunc_called(this, "_ZN7S9942C12v2Ev");}
void  S9942C1 ::v3(){vfunc_called(this, "_ZN7S9942C12v3Ev");}
void  S9942C1 ::v4(){vfunc_called(this, "_ZN7S9942C12v4Ev");}
S9942C1 ::S9942C1(){ note_ctor("S9942C1", this);} // tgen

static void Test_S9942C1()
{
  extern Class_Descriptor cd_S9942C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(63,91)];
    init_test(&cd_S9942C1, buf);
    S9942C1 *dp, &lv = *(dp=new (buf) S9942C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(496,360), "sizeof(S9942C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9942C1)");
    check_base_class_offset(lv, (S9942C2*), 0, "S9942C1");
    check_field_offset(lv, s9942c1f0, ABISELECT(8,4), "S9942C1.s9942c1f0");
    check_field_offset(lv, s9942c1f1, ABISELECT(48,40), "S9942C1.s9942c1f1");
    check_field_offset(lv, s9942c1f2, ABISELECT(88,76), "S9942C1.s9942c1f2");
    check_field_offset(lv, s9942c1f3, ABISELECT(96,80), "S9942C1.s9942c1f3");
    check_field_offset(lv, s9942c1f4, ABISELECT(360,260), "S9942C1.s9942c1f4");
    check_field_offset(lv, s9942c1f5, ABISELECT(376,276), "S9942C1.s9942c1f5");
    check_field_offset(lv, s9942c1f6, ABISELECT(380,280), "S9942C1.s9942c1f6");
    check_field_offset(lv, s9942c1f7, ABISELECT(384,284), "S9942C1.s9942c1f7");
    check_field_offset(lv, s9942c1f8, ABISELECT(388,288), "S9942C1.s9942c1f8");
    check_field_offset(lv, s9942c1f9, ABISELECT(392,292), "S9942C1.s9942c1f9");
    check_field_offset(lv, s9942c1f10, ABISELECT(396,296), "S9942C1.s9942c1f10");
    check_field_offset(lv, s9942c1f11, ABISELECT(400,300), "S9942C1.s9942c1f11");
    check_field_offset(lv, s9942c1f12, ABISELECT(408,304), "S9942C1.s9942c1f12");
    check_field_offset(lv, s9942c1f13, ABISELECT(412,308), "S9942C1.s9942c1f13");
    check_field_offset(lv, s9942c1f14, ABISELECT(416,312), "S9942C1.s9942c1f14");
    check_field_offset(lv, s9942c1f15, ABISELECT(420,316), "S9942C1.s9942c1f15");
    check_field_offset(lv, s9942c1f16, ABISELECT(424,320), "S9942C1.s9942c1f16");
    check_field_offset(lv, s9942c1f17, ABISELECT(432,324), "S9942C1.s9942c1f17");
    check_field_offset(lv, s9942c1f18, ABISELECT(440,328), "S9942C1.s9942c1f18");
    check_field_offset(lv, s9942c1f19, ABISELECT(472,344), "S9942C1.s9942c1f19");
    check_field_offset(lv, s9942c1f20, ABISELECT(480,348), "S9942C1.s9942c1f20");
    check_field_offset(lv, s9942c1f21, ABISELECT(484,352), "S9942C1.s9942c1f21");
    check_field_offset(lv, s9942c1f22, ABISELECT(485,353), "S9942C1.s9942c1f22");
    check_field_offset(lv, s9942c1f23, ABISELECT(488,356), "S9942C1.s9942c1f23");
    test_class_info(&lv, &cd_S9942C1);
    dp->~S9942C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9942C1(Test_S9942C1, "S9942C1", ABISELECT(496,360));

#else // __cplusplus

extern void _ZN7S9942C1C1Ev();
extern void _ZN7S9942C1D1Ev();
Name_Map name_map_S9942C1[] = {
  NSPAIR(_ZN7S9942C1C1Ev),
  NSPAIR(_ZN7S9942C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9942C2;
extern VTBL_ENTRY _ZTI7S9942C2[];
extern  VTBL_ENTRY _ZTV7S9942C2[];
static Base_Class bases_S9942C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9942C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9942C1[];
extern void _ZN7S9942C1D1Ev();
extern void _ZN7S9942C1D0Ev();
extern void _ZN7S9942C22v5Ev();
extern void _ZN7S9942C22v6Ev();
extern void _ZN7S9942C22v7Ev();
extern void _ZN7S9942C22v8Ev();
extern void _ZN7S9942C22v9Ev();
extern void _ZN7S9942C12v1Ev();
extern void _ZN7S9942C12v2Ev();
extern void _ZN7S9942C12v3Ev();
extern void _ZN7S9942C12v4Ev();
static  VTBL_ENTRY vtc_S9942C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9942C1[0]),
  (VTBL_ENTRY)&_ZN7S9942C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9942C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9942C22v9Ev,
  (VTBL_ENTRY)&_ZN7S9942C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9942C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9942C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9942C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S9942C1[];
extern  VTBL_ENTRY _ZTV7S9942C1[];
Class_Descriptor cd_S9942C1 = {  "S9942C1", // class name
  bases_S9942C1, 1,
  &(vtc_S9942C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(496,360), // object size
  NSPAIRA(_ZTI7S9942C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9942C1),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S855C5  {
  virtual  ~S855C5(); // _ZN6S855C5D1Ev
  virtual void  v12(); // _ZN6S855C53v12Ev
  virtual void  v13(); // _ZN6S855C53v13Ev
  virtual void  v14(); // _ZN6S855C53v14Ev
  S855C5(); // tgen
};
//SIG(-1 S855C5) C1{ vd v1 v2 v3}


 S855C5 ::~S855C5(){ note_dtor("S855C5", this);}
void  S855C5 ::v12(){vfunc_called(this, "_ZN6S855C53v12Ev");}
void  S855C5 ::v13(){vfunc_called(this, "_ZN6S855C53v13Ev");}
void  S855C5 ::v14(){vfunc_called(this, "_ZN6S855C53v14Ev");}
S855C5 ::S855C5(){ note_ctor("S855C5", this);} // tgen

static void Test_S855C5()
{
  extern Class_Descriptor cd_S855C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S855C5, buf);
    S855C5 *dp, &lv = *(dp=new (buf) S855C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S855C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S855C5)");
    test_class_info(&lv, &cd_S855C5);
    dp->~S855C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS855C5(Test_S855C5, "S855C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S855C5C1Ev();
extern void _ZN6S855C5D1Ev();
Name_Map name_map_S855C5[] = {
  NSPAIR(_ZN6S855C5C1Ev),
  NSPAIR(_ZN6S855C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S855C5[];
extern void _ZN6S855C5D1Ev();
extern void _ZN6S855C5D0Ev();
extern void _ZN6S855C53v12Ev();
extern void _ZN6S855C53v13Ev();
extern void _ZN6S855C53v14Ev();
static  VTBL_ENTRY vtc_S855C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S855C5[0]),
  (VTBL_ENTRY)&_ZN6S855C5D1Ev,
  (VTBL_ENTRY)&_ZN6S855C5D0Ev,
  (VTBL_ENTRY)&_ZN6S855C53v12Ev,
  (VTBL_ENTRY)&_ZN6S855C53v13Ev,
  (VTBL_ENTRY)&_ZN6S855C53v14Ev,
};
extern VTBL_ENTRY _ZTI6S855C5[];
extern  VTBL_ENTRY _ZTV6S855C5[];
Class_Descriptor cd_S855C5 = {  "S855C5", // class name
  0,0,//no base classes
  &(vtc_S855C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S855C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S855C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S855C6  {
  virtual  ~S855C6(); // _ZN6S855C6D1Ev
  virtual void  v15(); // _ZN6S855C63v15Ev
  S855C6(); // tgen
};
//SIG(-1 S855C6) C1{ vd v1}


 S855C6 ::~S855C6(){ note_dtor("S855C6", this);}
void  S855C6 ::v15(){vfunc_called(this, "_ZN6S855C63v15Ev");}
S855C6 ::S855C6(){ note_ctor("S855C6", this);} // tgen

static void Test_S855C6()
{
  extern Class_Descriptor cd_S855C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S855C6, buf);
    S855C6 *dp, &lv = *(dp=new (buf) S855C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S855C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S855C6)");
    test_class_info(&lv, &cd_S855C6);
    dp->~S855C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS855C6(Test_S855C6, "S855C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S855C6C1Ev();
extern void _ZN6S855C6D1Ev();
Name_Map name_map_S855C6[] = {
  NSPAIR(_ZN6S855C6C1Ev),
  NSPAIR(_ZN6S855C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S855C6[];
extern void _ZN6S855C6D1Ev();
extern void _ZN6S855C6D0Ev();
extern void _ZN6S855C63v15Ev();
static  VTBL_ENTRY vtc_S855C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S855C6[0]),
  (VTBL_ENTRY)&_ZN6S855C6D1Ev,
  (VTBL_ENTRY)&_ZN6S855C6D0Ev,
  (VTBL_ENTRY)&_ZN6S855C63v15Ev,
};
extern VTBL_ENTRY _ZTI6S855C6[];
extern  VTBL_ENTRY _ZTV6S855C6[];
Class_Descriptor cd_S855C6 = {  "S855C6", // class name
  0,0,//no base classes
  &(vtc_S855C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S855C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S855C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S855C4  : S855C5 , S855C6 {
  virtual  ~S855C4(); // _ZN6S855C4D1Ev
  virtual void  v16(); // _ZN6S855C43v16Ev
  virtual void  v17(); // _ZN6S855C43v17Ev
  virtual void  v18(); // _ZN6S855C43v18Ev
  virtual void  v19(); // _ZN6S855C43v19Ev
  virtual void  v20(); // _ZN6S855C43v20Ev
  virtual void  v21(); // _ZN6S855C43v21Ev
  virtual void  v22(); // _ZN6S855C43v22Ev
  virtual void  v23(); // _ZN6S855C43v23Ev
  virtual void  v24(); // _ZN6S855C43v24Ev
  virtual void  v25(); // _ZN6S855C43v25Ev
  virtual void  v26(); // _ZN6S855C43v26Ev
  virtual void  v27(); // _ZN6S855C43v27Ev
  virtual void  v28(); // _ZN6S855C43v28Ev
  virtual void  v29(); // _ZN6S855C43v29Ev
  virtual void  v30(); // _ZN6S855C43v30Ev
  virtual void  v31(); // _ZN6S855C43v31Ev
  virtual void  v32(); // _ZN6S855C43v32Ev
  virtual void  v33(); // _ZN6S855C43v33Ev
  virtual void  v34(); // _ZN6S855C43v34Ev
  virtual void  v35(); // _ZN6S855C43v35Ev
  virtual void  v36(); // _ZN6S855C43v36Ev
  virtual void  v37(); // _ZN6S855C43v37Ev
  S855C4(); // tgen
};
//SIG(-1 S855C4) C1{ BC2{ vd v23 v24 v25} BC3{ vd v26} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22}


 S855C4 ::~S855C4(){ note_dtor("S855C4", this);}
void  S855C4 ::v16(){vfunc_called(this, "_ZN6S855C43v16Ev");}
void  S855C4 ::v17(){vfunc_called(this, "_ZN6S855C43v17Ev");}
void  S855C4 ::v18(){vfunc_called(this, "_ZN6S855C43v18Ev");}
void  S855C4 ::v19(){vfunc_called(this, "_ZN6S855C43v19Ev");}
void  S855C4 ::v20(){vfunc_called(this, "_ZN6S855C43v20Ev");}
void  S855C4 ::v21(){vfunc_called(this, "_ZN6S855C43v21Ev");}
void  S855C4 ::v22(){vfunc_called(this, "_ZN6S855C43v22Ev");}
void  S855C4 ::v23(){vfunc_called(this, "_ZN6S855C43v23Ev");}
void  S855C4 ::v24(){vfunc_called(this, "_ZN6S855C43v24Ev");}
void  S855C4 ::v25(){vfunc_called(this, "_ZN6S855C43v25Ev");}
void  S855C4 ::v26(){vfunc_called(this, "_ZN6S855C43v26Ev");}
void  S855C4 ::v27(){vfunc_called(this, "_ZN6S855C43v27Ev");}
void  S855C4 ::v28(){vfunc_called(this, "_ZN6S855C43v28Ev");}
void  S855C4 ::v29(){vfunc_called(this, "_ZN6S855C43v29Ev");}
void  S855C4 ::v30(){vfunc_called(this, "_ZN6S855C43v30Ev");}
void  S855C4 ::v31(){vfunc_called(this, "_ZN6S855C43v31Ev");}
void  S855C4 ::v32(){vfunc_called(this, "_ZN6S855C43v32Ev");}
void  S855C4 ::v33(){vfunc_called(this, "_ZN6S855C43v33Ev");}
void  S855C4 ::v34(){vfunc_called(this, "_ZN6S855C43v34Ev");}
void  S855C4 ::v35(){vfunc_called(this, "_ZN6S855C43v35Ev");}
void  S855C4 ::v36(){vfunc_called(this, "_ZN6S855C43v36Ev");}
void  S855C4 ::v37(){vfunc_called(this, "_ZN6S855C43v37Ev");}
S855C4 ::S855C4(){ note_ctor("S855C4", this);} // tgen

static void Test_S855C4()
{
  extern Class_Descriptor cd_S855C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S855C4, buf);
    S855C4 *dp, &lv = *(dp=new (buf) S855C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S855C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S855C4)");
    check_base_class_offset(lv, (S855C5*), 0, "S855C4");
    check_base_class_offset(lv, (S855C6*), ABISELECT(8,4), "S855C4");
    test_class_info(&lv, &cd_S855C4);
    dp->~S855C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS855C4(Test_S855C4, "S855C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN6S855C4C1Ev();
extern void _ZN6S855C4D1Ev();
Name_Map name_map_S855C4[] = {
  NSPAIR(_ZN6S855C4C1Ev),
  NSPAIR(_ZN6S855C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S855C5;
extern VTBL_ENTRY _ZTI6S855C5[];
extern  VTBL_ENTRY _ZTV6S855C5[];
extern Class_Descriptor cd_S855C6;
extern VTBL_ENTRY _ZTI6S855C6[];
extern  VTBL_ENTRY _ZTV6S855C6[];
static Base_Class bases_S855C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S855C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S855C6,    ABISELECT(8,4), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S855C4[];
extern void _ZN6S855C4D1Ev();
extern void _ZN6S855C4D0Ev();
extern void _ZN6S855C53v12Ev();
extern void _ZN6S855C53v13Ev();
extern void _ZN6S855C53v14Ev();
extern void _ZN6S855C43v16Ev();
extern void _ZN6S855C43v17Ev();
extern void _ZN6S855C43v18Ev();
extern void _ZN6S855C43v19Ev();
extern void _ZN6S855C43v20Ev();
extern void _ZN6S855C43v21Ev();
extern void _ZN6S855C43v22Ev();
extern void _ZN6S855C43v23Ev();
extern void _ZN6S855C43v24Ev();
extern void _ZN6S855C43v25Ev();
extern void _ZN6S855C43v26Ev();
extern void _ZN6S855C43v27Ev();
extern void _ZN6S855C43v28Ev();
extern void _ZN6S855C43v29Ev();
extern void _ZN6S855C43v30Ev();
extern void _ZN6S855C43v31Ev();
extern void _ZN6S855C43v32Ev();
extern void _ZN6S855C43v33Ev();
extern void _ZN6S855C43v34Ev();
extern void _ZN6S855C43v35Ev();
extern void _ZN6S855C43v36Ev();
extern void _ZN6S855C43v37Ev();
extern void ABISELECT(_ZThn8_N6S855C4D1Ev,_ZThn4_N6S855C4D1Ev)();
extern void ABISELECT(_ZThn8_N6S855C4D0Ev,_ZThn4_N6S855C4D0Ev)();
extern void _ZN6S855C63v15Ev();
static  VTBL_ENTRY vtc_S855C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S855C4[0]),
  (VTBL_ENTRY)&_ZN6S855C4D1Ev,
  (VTBL_ENTRY)&_ZN6S855C4D0Ev,
  (VTBL_ENTRY)&_ZN6S855C53v12Ev,
  (VTBL_ENTRY)&_ZN6S855C53v13Ev,
  (VTBL_ENTRY)&_ZN6S855C53v14Ev,
  (VTBL_ENTRY)&_ZN6S855C43v16Ev,
  (VTBL_ENTRY)&_ZN6S855C43v17Ev,
  (VTBL_ENTRY)&_ZN6S855C43v18Ev,
  (VTBL_ENTRY)&_ZN6S855C43v19Ev,
  (VTBL_ENTRY)&_ZN6S855C43v20Ev,
  (VTBL_ENTRY)&_ZN6S855C43v21Ev,
  (VTBL_ENTRY)&_ZN6S855C43v22Ev,
  (VTBL_ENTRY)&_ZN6S855C43v23Ev,
  (VTBL_ENTRY)&_ZN6S855C43v24Ev,
  (VTBL_ENTRY)&_ZN6S855C43v25Ev,
  (VTBL_ENTRY)&_ZN6S855C43v26Ev,
  (VTBL_ENTRY)&_ZN6S855C43v27Ev,
  (VTBL_ENTRY)&_ZN6S855C43v28Ev,
  (VTBL_ENTRY)&_ZN6S855C43v29Ev,
  (VTBL_ENTRY)&_ZN6S855C43v30Ev,
  (VTBL_ENTRY)&_ZN6S855C43v31Ev,
  (VTBL_ENTRY)&_ZN6S855C43v32Ev,
  (VTBL_ENTRY)&_ZN6S855C43v33Ev,
  (VTBL_ENTRY)&_ZN6S855C43v34Ev,
  (VTBL_ENTRY)&_ZN6S855C43v35Ev,
  (VTBL_ENTRY)&_ZN6S855C43v36Ev,
  (VTBL_ENTRY)&_ZN6S855C43v37Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S855C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C4D1Ev,_ZThn4_N6S855C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C4D0Ev,_ZThn4_N6S855C4D0Ev),
  (VTBL_ENTRY)&_ZN6S855C63v15Ev,
};
extern VTBL_ENTRY _ZTI6S855C4[];
extern  VTBL_ENTRY _ZTV6S855C4[];
Class_Descriptor cd_S855C4 = {  "S855C4", // class name
  bases_S855C4, 2,
  &(vtc_S855C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI6S855C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S855C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S855C3  : S855C4 {
  ::S858C7_nt s855c3f0;
  ::S9124C5_nt s855c3f1;
  char s855c3f2;
  virtual  ~S855C3(); // _ZN6S855C3D1Ev
  virtual void  v38(); // _ZN6S855C33v38Ev
  virtual void  v39(); // _ZN6S855C33v39Ev
  virtual void  v40(); // _ZN6S855C33v40Ev
  S855C3(); // tgen
};
//SIG(-1 S855C3) C1{ BC2{ BC3{ vd v4 v5 v6} BC4{ vd v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29} vd v1 v2 v3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc}


 S855C3 ::~S855C3(){ note_dtor("S855C3", this);}
void  S855C3 ::v38(){vfunc_called(this, "_ZN6S855C33v38Ev");}
void  S855C3 ::v39(){vfunc_called(this, "_ZN6S855C33v39Ev");}
void  S855C3 ::v40(){vfunc_called(this, "_ZN6S855C33v40Ev");}
S855C3 ::S855C3(){ note_ctor("S855C3", this);} // tgen

static void Test_S855C3()
{
  extern Class_Descriptor cd_S855C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S855C3, buf);
    S855C3 *dp, &lv = *(dp=new (buf) S855C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S855C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S855C3)");
    check_base_class_offset(lv, (S855C5*)(S855C4*), 0, "S855C3");
    check_base_class_offset(lv, (S855C6*)(S855C4*), ABISELECT(8,4), "S855C3");
    check_base_class_offset(lv, (S855C4*), 0, "S855C3");
    check_field_offset(lv, s855c3f0, ABISELECT(16,8), "S855C3.s855c3f0");
    check_field_offset(lv, s855c3f1, ABISELECT(40,24), "S855C3.s855c3f1");
    check_field_offset(lv, s855c3f2, ABISELECT(72,56), "S855C3.s855c3f2");
    test_class_info(&lv, &cd_S855C3);
    dp->~S855C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS855C3(Test_S855C3, "S855C3", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN6S855C3C1Ev();
extern void _ZN6S855C3D1Ev();
Name_Map name_map_S855C3[] = {
  NSPAIR(_ZN6S855C3C1Ev),
  NSPAIR(_ZN6S855C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S855C5;
extern VTBL_ENTRY _ZTI6S855C5[];
extern  VTBL_ENTRY _ZTV6S855C5[];
extern Class_Descriptor cd_S855C6;
extern VTBL_ENTRY _ZTI6S855C6[];
extern  VTBL_ENTRY _ZTV6S855C6[];
extern Class_Descriptor cd_S855C4;
extern VTBL_ENTRY _ZTI6S855C4[];
extern  VTBL_ENTRY _ZTV6S855C4[];
static Base_Class bases_S855C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S855C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S855C6,    ABISELECT(8,4), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S855C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S855C3[];
extern void _ZN6S855C3D1Ev();
extern void _ZN6S855C3D0Ev();
extern void _ZN6S855C53v12Ev();
extern void _ZN6S855C53v13Ev();
extern void _ZN6S855C53v14Ev();
extern void _ZN6S855C43v16Ev();
extern void _ZN6S855C43v17Ev();
extern void _ZN6S855C43v18Ev();
extern void _ZN6S855C43v19Ev();
extern void _ZN6S855C43v20Ev();
extern void _ZN6S855C43v21Ev();
extern void _ZN6S855C43v22Ev();
extern void _ZN6S855C43v23Ev();
extern void _ZN6S855C43v24Ev();
extern void _ZN6S855C43v25Ev();
extern void _ZN6S855C43v26Ev();
extern void _ZN6S855C43v27Ev();
extern void _ZN6S855C43v28Ev();
extern void _ZN6S855C43v29Ev();
extern void _ZN6S855C43v30Ev();
extern void _ZN6S855C43v31Ev();
extern void _ZN6S855C43v32Ev();
extern void _ZN6S855C43v33Ev();
extern void _ZN6S855C43v34Ev();
extern void _ZN6S855C43v35Ev();
extern void _ZN6S855C43v36Ev();
extern void _ZN6S855C43v37Ev();
extern void _ZN6S855C33v38Ev();
extern void _ZN6S855C33v39Ev();
extern void _ZN6S855C33v40Ev();
extern void ABISELECT(_ZThn8_N6S855C3D1Ev,_ZThn4_N6S855C3D1Ev)();
extern void ABISELECT(_ZThn8_N6S855C3D0Ev,_ZThn4_N6S855C3D0Ev)();
extern void _ZN6S855C63v15Ev();
static  VTBL_ENTRY vtc_S855C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S855C3[0]),
  (VTBL_ENTRY)&_ZN6S855C3D1Ev,
  (VTBL_ENTRY)&_ZN6S855C3D0Ev,
  (VTBL_ENTRY)&_ZN6S855C53v12Ev,
  (VTBL_ENTRY)&_ZN6S855C53v13Ev,
  (VTBL_ENTRY)&_ZN6S855C53v14Ev,
  (VTBL_ENTRY)&_ZN6S855C43v16Ev,
  (VTBL_ENTRY)&_ZN6S855C43v17Ev,
  (VTBL_ENTRY)&_ZN6S855C43v18Ev,
  (VTBL_ENTRY)&_ZN6S855C43v19Ev,
  (VTBL_ENTRY)&_ZN6S855C43v20Ev,
  (VTBL_ENTRY)&_ZN6S855C43v21Ev,
  (VTBL_ENTRY)&_ZN6S855C43v22Ev,
  (VTBL_ENTRY)&_ZN6S855C43v23Ev,
  (VTBL_ENTRY)&_ZN6S855C43v24Ev,
  (VTBL_ENTRY)&_ZN6S855C43v25Ev,
  (VTBL_ENTRY)&_ZN6S855C43v26Ev,
  (VTBL_ENTRY)&_ZN6S855C43v27Ev,
  (VTBL_ENTRY)&_ZN6S855C43v28Ev,
  (VTBL_ENTRY)&_ZN6S855C43v29Ev,
  (VTBL_ENTRY)&_ZN6S855C43v30Ev,
  (VTBL_ENTRY)&_ZN6S855C43v31Ev,
  (VTBL_ENTRY)&_ZN6S855C43v32Ev,
  (VTBL_ENTRY)&_ZN6S855C43v33Ev,
  (VTBL_ENTRY)&_ZN6S855C43v34Ev,
  (VTBL_ENTRY)&_ZN6S855C43v35Ev,
  (VTBL_ENTRY)&_ZN6S855C43v36Ev,
  (VTBL_ENTRY)&_ZN6S855C43v37Ev,
  (VTBL_ENTRY)&_ZN6S855C33v38Ev,
  (VTBL_ENTRY)&_ZN6S855C33v39Ev,
  (VTBL_ENTRY)&_ZN6S855C33v40Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S855C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C3D1Ev,_ZThn4_N6S855C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C3D0Ev,_ZThn4_N6S855C3D0Ev),
  (VTBL_ENTRY)&_ZN6S855C63v15Ev,
};
extern VTBL_ENTRY _ZTI6S855C3[];
extern  VTBL_ENTRY _ZTV6S855C3[];
Class_Descriptor cd_S855C3 = {  "S855C3", // class name
  bases_S855C3, 3,
  &(vtc_S855C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI6S855C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S855C3),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S855C10  {
  virtual  ~S855C10(); // _ZN7S855C10D1Ev
  virtual void  v41(); // _ZN7S855C103v41Ev
  S855C10(); // tgen
};
//SIG(-1 S855C10) C1{ vd v1}


 S855C10 ::~S855C10(){ note_dtor("S855C10", this);}
void  S855C10 ::v41(){vfunc_called(this, "_ZN7S855C103v41Ev");}
S855C10 ::S855C10(){ note_ctor("S855C10", this);} // tgen

static void Test_S855C10()
{
  extern Class_Descriptor cd_S855C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S855C10, buf);
    S855C10 *dp, &lv = *(dp=new (buf) S855C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S855C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S855C10)");
    test_class_info(&lv, &cd_S855C10);
    dp->~S855C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS855C10(Test_S855C10, "S855C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S855C10C1Ev();
extern void _ZN7S855C10D1Ev();
Name_Map name_map_S855C10[] = {
  NSPAIR(_ZN7S855C10C1Ev),
  NSPAIR(_ZN7S855C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S855C10[];
extern void _ZN7S855C10D1Ev();
extern void _ZN7S855C10D0Ev();
extern void _ZN7S855C103v41Ev();
static  VTBL_ENTRY vtc_S855C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S855C10[0]),
  (VTBL_ENTRY)&_ZN7S855C10D1Ev,
  (VTBL_ENTRY)&_ZN7S855C10D0Ev,
  (VTBL_ENTRY)&_ZN7S855C103v41Ev,
};
extern VTBL_ENTRY _ZTI7S855C10[];
extern  VTBL_ENTRY _ZTV7S855C10[];
Class_Descriptor cd_S855C10 = {  "S855C10", // class name
  0,0,//no base classes
  &(vtc_S855C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S855C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S855C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S855C2  : S855C3 , S855C10 {
  ::S858C11_nt s855c2f0;
  ::S858C12_nt s855c2f1;
  char s855c2f2[3];
  void *s855c2f3;
  ::S858C15_nt s855c2f4;
  void *s855c2f5;
  virtual  ~S855C2(); // _ZN6S855C2D1Ev
  virtual void  v42(); // _ZN6S855C23v42Ev
  virtual void  v43(); // _ZN6S855C23v43Ev
  virtual void  v44(); // _ZN6S855C23v44Ev
  virtual void  v45(); // _ZN6S855C23v45Ev
  virtual void  v46(); // _ZN6S855C23v46Ev
  virtual void  v47(); // _ZN6S855C23v47Ev
  virtual void  v48(); // _ZN6S855C23v48Ev
  virtual void  v49(); // _ZN6S855C23v49Ev
  virtual void  v50(); // _ZN6S855C23v50Ev
  virtual void  v51(); // _ZN6S855C23v51Ev
  virtual void  v52(); // _ZN6S855C23v52Ev
  virtual void  v53(); // _ZN6S855C23v53Ev
  virtual void  v54(); // _ZN6S855C23v54Ev
  virtual void  v55(); // _ZN6S855C23v55Ev
  virtual void  v56(); // _ZN6S855C23v56Ev
  virtual void  v57(); // _ZN6S855C23v57Ev
  virtual void  v58(); // _ZN6S855C23v58Ev
  virtual void  v59(); // _ZN6S855C23v59Ev
  virtual void  v60(); // _ZN6S855C23v60Ev
  virtual void  v61(); // _ZN6S855C23v61Ev
  virtual void  v62(); // _ZN6S855C23v62Ev
  virtual void  v63(); // _ZN6S855C23v63Ev
  virtual void  v64(); // _ZN6S855C23v64Ev
  virtual void  v65(); // _ZN6S855C23v65Ev
  virtual void  v66(); // _ZN6S855C23v66Ev
  virtual void  v67(); // _ZN6S855C23v67Ev
  virtual void  v68(); // _ZN6S855C23v68Ev
  virtual void  v69(); // _ZN6S855C23v69Ev
  virtual void  v70(); // _ZN6S855C23v70Ev
  virtual void  v71(); // _ZN6S855C23v71Ev
  virtual void  v72(); // _ZN6S855C23v72Ev
  virtual void  v73(); // _ZN6S855C23v73Ev
  virtual void  v74(); // _ZN6S855C23v74Ev
  virtual void  v75(); // _ZN6S855C23v75Ev
  virtual void  v76(); // _ZN6S855C23v76Ev
  virtual void  v77(); // _ZN6S855C23v77Ev
  virtual void  v78(); // _ZN6S855C23v78Ev
  virtual void  v79(); // _ZN6S855C23v79Ev
  virtual void  v80(); // _ZN6S855C23v80Ev
  virtual void  v81(); // _ZN6S855C23v81Ev
  virtual void  v82(); // _ZN6S855C23v82Ev
  S855C2(); // tgen
};
//SIG(-1 S855C2) C1{ BC2{ BC3{ BC4{ vd v42 v43 v44} BC5{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FL[4]} Fc} BC9{ vd v71} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC10{ m FL[4]} FC11{ m Fp FC10 FC12{ m Fp FC13{ Fi[4]}} Fi Fc} Fc[3] Fp FC14{ BC15{ vd v74} BC16{ vd v75} vd v72 v73 Fp[2]} Fp}


 S855C2 ::~S855C2(){ note_dtor("S855C2", this);}
void  S855C2 ::v42(){vfunc_called(this, "_ZN6S855C23v42Ev");}
void  S855C2 ::v43(){vfunc_called(this, "_ZN6S855C23v43Ev");}
void  S855C2 ::v44(){vfunc_called(this, "_ZN6S855C23v44Ev");}
void  S855C2 ::v45(){vfunc_called(this, "_ZN6S855C23v45Ev");}
void  S855C2 ::v46(){vfunc_called(this, "_ZN6S855C23v46Ev");}
void  S855C2 ::v47(){vfunc_called(this, "_ZN6S855C23v47Ev");}
void  S855C2 ::v48(){vfunc_called(this, "_ZN6S855C23v48Ev");}
void  S855C2 ::v49(){vfunc_called(this, "_ZN6S855C23v49Ev");}
void  S855C2 ::v50(){vfunc_called(this, "_ZN6S855C23v50Ev");}
void  S855C2 ::v51(){vfunc_called(this, "_ZN6S855C23v51Ev");}
void  S855C2 ::v52(){vfunc_called(this, "_ZN6S855C23v52Ev");}
void  S855C2 ::v53(){vfunc_called(this, "_ZN6S855C23v53Ev");}
void  S855C2 ::v54(){vfunc_called(this, "_ZN6S855C23v54Ev");}
void  S855C2 ::v55(){vfunc_called(this, "_ZN6S855C23v55Ev");}
void  S855C2 ::v56(){vfunc_called(this, "_ZN6S855C23v56Ev");}
void  S855C2 ::v57(){vfunc_called(this, "_ZN6S855C23v57Ev");}
void  S855C2 ::v58(){vfunc_called(this, "_ZN6S855C23v58Ev");}
void  S855C2 ::v59(){vfunc_called(this, "_ZN6S855C23v59Ev");}
void  S855C2 ::v60(){vfunc_called(this, "_ZN6S855C23v60Ev");}
void  S855C2 ::v61(){vfunc_called(this, "_ZN6S855C23v61Ev");}
void  S855C2 ::v62(){vfunc_called(this, "_ZN6S855C23v62Ev");}
void  S855C2 ::v63(){vfunc_called(this, "_ZN6S855C23v63Ev");}
void  S855C2 ::v64(){vfunc_called(this, "_ZN6S855C23v64Ev");}
void  S855C2 ::v65(){vfunc_called(this, "_ZN6S855C23v65Ev");}
void  S855C2 ::v66(){vfunc_called(this, "_ZN6S855C23v66Ev");}
void  S855C2 ::v67(){vfunc_called(this, "_ZN6S855C23v67Ev");}
void  S855C2 ::v68(){vfunc_called(this, "_ZN6S855C23v68Ev");}
void  S855C2 ::v69(){vfunc_called(this, "_ZN6S855C23v69Ev");}
void  S855C2 ::v70(){vfunc_called(this, "_ZN6S855C23v70Ev");}
void  S855C2 ::v71(){vfunc_called(this, "_ZN6S855C23v71Ev");}
void  S855C2 ::v72(){vfunc_called(this, "_ZN6S855C23v72Ev");}
void  S855C2 ::v73(){vfunc_called(this, "_ZN6S855C23v73Ev");}
void  S855C2 ::v74(){vfunc_called(this, "_ZN6S855C23v74Ev");}
void  S855C2 ::v75(){vfunc_called(this, "_ZN6S855C23v75Ev");}
void  S855C2 ::v76(){vfunc_called(this, "_ZN6S855C23v76Ev");}
void  S855C2 ::v77(){vfunc_called(this, "_ZN6S855C23v77Ev");}
void  S855C2 ::v78(){vfunc_called(this, "_ZN6S855C23v78Ev");}
void  S855C2 ::v79(){vfunc_called(this, "_ZN6S855C23v79Ev");}
void  S855C2 ::v80(){vfunc_called(this, "_ZN6S855C23v80Ev");}
void  S855C2 ::v81(){vfunc_called(this, "_ZN6S855C23v81Ev");}
void  S855C2 ::v82(){vfunc_called(this, "_ZN6S855C23v82Ev");}
S855C2 ::S855C2(){ note_ctor("S855C2", this);} // tgen

static void Test_S855C2()
{
  extern Class_Descriptor cd_S855C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S855C2, buf);
    S855C2 *dp, &lv = *(dp=new (buf) S855C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S855C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S855C2)");
    check_base_class_offset(lv, (S855C5*)(S855C4*)(S855C3*), 0, "S855C2");
    check_base_class_offset(lv, (S855C6*)(S855C4*)(S855C3*), ABISELECT(8,4), "S855C2");
    check_base_class_offset(lv, (S855C4*)(S855C3*), 0, "S855C2");
    check_base_class_offset(lv, (S855C3*), 0, "S855C2");
    check_base_class_offset(lv, (S855C10*), ABISELECT(80,60), "S855C2");
    check_field_offset(lv, s855c2f0, ABISELECT(88,64), "S855C2.s855c2f0");
    check_field_offset(lv, s855c2f1, ABISELECT(120,96), "S855C2.s855c2f1");
    check_field_offset(lv, s855c2f2, ABISELECT(192,160), "S855C2.s855c2f2");
    check_field_offset(lv, s855c2f3, ABISELECT(200,164), "S855C2.s855c2f3");
    check_field_offset(lv, s855c2f4, ABISELECT(208,168), "S855C2.s855c2f4");
    check_field_offset(lv, s855c2f5, ABISELECT(240,184), "S855C2.s855c2f5");
    test_class_info(&lv, &cd_S855C2);
    dp->~S855C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS855C2(Test_S855C2, "S855C2", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S855C2C1Ev();
extern void _ZN6S855C2D1Ev();
Name_Map name_map_S855C2[] = {
  NSPAIR(_ZN6S855C2C1Ev),
  NSPAIR(_ZN6S855C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S855C5;
extern VTBL_ENTRY _ZTI6S855C5[];
extern  VTBL_ENTRY _ZTV6S855C5[];
extern Class_Descriptor cd_S855C6;
extern VTBL_ENTRY _ZTI6S855C6[];
extern  VTBL_ENTRY _ZTV6S855C6[];
extern Class_Descriptor cd_S855C4;
extern VTBL_ENTRY _ZTI6S855C4[];
extern  VTBL_ENTRY _ZTV6S855C4[];
extern Class_Descriptor cd_S855C3;
extern VTBL_ENTRY _ZTI6S855C3[];
extern  VTBL_ENTRY _ZTV6S855C3[];
extern Class_Descriptor cd_S855C10;
extern VTBL_ENTRY _ZTI7S855C10[];
extern  VTBL_ENTRY _ZTV7S855C10[];
static Base_Class bases_S855C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S855C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S855C6,    ABISELECT(8,4), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S855C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S855C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S855C10,    ABISELECT(80,60), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S855C2[];
extern void _ZN6S855C2D1Ev();
extern void _ZN6S855C2D0Ev();
extern void _ZN6S855C53v12Ev();
extern void _ZN6S855C53v13Ev();
extern void _ZN6S855C53v14Ev();
extern void _ZN6S855C43v16Ev();
extern void _ZN6S855C43v17Ev();
extern void _ZN6S855C43v18Ev();
extern void _ZN6S855C43v19Ev();
extern void _ZN6S855C43v20Ev();
extern void _ZN6S855C43v21Ev();
extern void _ZN6S855C43v22Ev();
extern void _ZN6S855C43v23Ev();
extern void _ZN6S855C43v24Ev();
extern void _ZN6S855C43v25Ev();
extern void _ZN6S855C43v26Ev();
extern void _ZN6S855C43v27Ev();
extern void _ZN6S855C43v28Ev();
extern void _ZN6S855C43v29Ev();
extern void _ZN6S855C43v30Ev();
extern void _ZN6S855C43v31Ev();
extern void _ZN6S855C43v32Ev();
extern void _ZN6S855C43v33Ev();
extern void _ZN6S855C43v34Ev();
extern void _ZN6S855C43v35Ev();
extern void _ZN6S855C43v36Ev();
extern void _ZN6S855C43v37Ev();
extern void _ZN6S855C33v38Ev();
extern void _ZN6S855C33v39Ev();
extern void _ZN6S855C33v40Ev();
extern void _ZN6S855C23v42Ev();
extern void _ZN6S855C23v43Ev();
extern void _ZN6S855C23v44Ev();
extern void _ZN6S855C23v45Ev();
extern void _ZN6S855C23v46Ev();
extern void _ZN6S855C23v47Ev();
extern void _ZN6S855C23v48Ev();
extern void _ZN6S855C23v49Ev();
extern void _ZN6S855C23v50Ev();
extern void _ZN6S855C23v51Ev();
extern void _ZN6S855C23v52Ev();
extern void _ZN6S855C23v53Ev();
extern void _ZN6S855C23v54Ev();
extern void _ZN6S855C23v55Ev();
extern void _ZN6S855C23v56Ev();
extern void _ZN6S855C23v57Ev();
extern void _ZN6S855C23v58Ev();
extern void _ZN6S855C23v59Ev();
extern void _ZN6S855C23v60Ev();
extern void _ZN6S855C23v61Ev();
extern void _ZN6S855C23v62Ev();
extern void _ZN6S855C23v63Ev();
extern void _ZN6S855C23v64Ev();
extern void _ZN6S855C23v65Ev();
extern void _ZN6S855C23v66Ev();
extern void _ZN6S855C23v67Ev();
extern void _ZN6S855C23v68Ev();
extern void _ZN6S855C23v69Ev();
extern void _ZN6S855C23v70Ev();
extern void _ZN6S855C23v71Ev();
extern void _ZN6S855C23v72Ev();
extern void _ZN6S855C23v73Ev();
extern void _ZN6S855C23v74Ev();
extern void _ZN6S855C23v75Ev();
extern void _ZN6S855C23v76Ev();
extern void _ZN6S855C23v77Ev();
extern void _ZN6S855C23v78Ev();
extern void _ZN6S855C23v79Ev();
extern void _ZN6S855C23v80Ev();
extern void _ZN6S855C23v81Ev();
extern void _ZN6S855C23v82Ev();
extern void ABISELECT(_ZThn8_N6S855C2D1Ev,_ZThn4_N6S855C2D1Ev)();
extern void ABISELECT(_ZThn8_N6S855C2D0Ev,_ZThn4_N6S855C2D0Ev)();
extern void _ZN6S855C63v15Ev();
extern void ABISELECT(_ZThn80_N6S855C2D1Ev,_ZThn60_N6S855C2D1Ev)();
extern void ABISELECT(_ZThn80_N6S855C2D0Ev,_ZThn60_N6S855C2D0Ev)();
extern void _ZN7S855C103v41Ev();
static  VTBL_ENTRY vtc_S855C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S855C2[0]),
  (VTBL_ENTRY)&_ZN6S855C2D1Ev,
  (VTBL_ENTRY)&_ZN6S855C2D0Ev,
  (VTBL_ENTRY)&_ZN6S855C53v12Ev,
  (VTBL_ENTRY)&_ZN6S855C53v13Ev,
  (VTBL_ENTRY)&_ZN6S855C53v14Ev,
  (VTBL_ENTRY)&_ZN6S855C43v16Ev,
  (VTBL_ENTRY)&_ZN6S855C43v17Ev,
  (VTBL_ENTRY)&_ZN6S855C43v18Ev,
  (VTBL_ENTRY)&_ZN6S855C43v19Ev,
  (VTBL_ENTRY)&_ZN6S855C43v20Ev,
  (VTBL_ENTRY)&_ZN6S855C43v21Ev,
  (VTBL_ENTRY)&_ZN6S855C43v22Ev,
  (VTBL_ENTRY)&_ZN6S855C43v23Ev,
  (VTBL_ENTRY)&_ZN6S855C43v24Ev,
  (VTBL_ENTRY)&_ZN6S855C43v25Ev,
  (VTBL_ENTRY)&_ZN6S855C43v26Ev,
  (VTBL_ENTRY)&_ZN6S855C43v27Ev,
  (VTBL_ENTRY)&_ZN6S855C43v28Ev,
  (VTBL_ENTRY)&_ZN6S855C43v29Ev,
  (VTBL_ENTRY)&_ZN6S855C43v30Ev,
  (VTBL_ENTRY)&_ZN6S855C43v31Ev,
  (VTBL_ENTRY)&_ZN6S855C43v32Ev,
  (VTBL_ENTRY)&_ZN6S855C43v33Ev,
  (VTBL_ENTRY)&_ZN6S855C43v34Ev,
  (VTBL_ENTRY)&_ZN6S855C43v35Ev,
  (VTBL_ENTRY)&_ZN6S855C43v36Ev,
  (VTBL_ENTRY)&_ZN6S855C43v37Ev,
  (VTBL_ENTRY)&_ZN6S855C33v38Ev,
  (VTBL_ENTRY)&_ZN6S855C33v39Ev,
  (VTBL_ENTRY)&_ZN6S855C33v40Ev,
  (VTBL_ENTRY)&_ZN6S855C23v42Ev,
  (VTBL_ENTRY)&_ZN6S855C23v43Ev,
  (VTBL_ENTRY)&_ZN6S855C23v44Ev,
  (VTBL_ENTRY)&_ZN6S855C23v45Ev,
  (VTBL_ENTRY)&_ZN6S855C23v46Ev,
  (VTBL_ENTRY)&_ZN6S855C23v47Ev,
  (VTBL_ENTRY)&_ZN6S855C23v48Ev,
  (VTBL_ENTRY)&_ZN6S855C23v49Ev,
  (VTBL_ENTRY)&_ZN6S855C23v50Ev,
  (VTBL_ENTRY)&_ZN6S855C23v51Ev,
  (VTBL_ENTRY)&_ZN6S855C23v52Ev,
  (VTBL_ENTRY)&_ZN6S855C23v53Ev,
  (VTBL_ENTRY)&_ZN6S855C23v54Ev,
  (VTBL_ENTRY)&_ZN6S855C23v55Ev,
  (VTBL_ENTRY)&_ZN6S855C23v56Ev,
  (VTBL_ENTRY)&_ZN6S855C23v57Ev,
  (VTBL_ENTRY)&_ZN6S855C23v58Ev,
  (VTBL_ENTRY)&_ZN6S855C23v59Ev,
  (VTBL_ENTRY)&_ZN6S855C23v60Ev,
  (VTBL_ENTRY)&_ZN6S855C23v61Ev,
  (VTBL_ENTRY)&_ZN6S855C23v62Ev,
  (VTBL_ENTRY)&_ZN6S855C23v63Ev,
  (VTBL_ENTRY)&_ZN6S855C23v64Ev,
  (VTBL_ENTRY)&_ZN6S855C23v65Ev,
  (VTBL_ENTRY)&_ZN6S855C23v66Ev,
  (VTBL_ENTRY)&_ZN6S855C23v67Ev,
  (VTBL_ENTRY)&_ZN6S855C23v68Ev,
  (VTBL_ENTRY)&_ZN6S855C23v69Ev,
  (VTBL_ENTRY)&_ZN6S855C23v70Ev,
  (VTBL_ENTRY)&_ZN6S855C23v71Ev,
  (VTBL_ENTRY)&_ZN6S855C23v72Ev,
  (VTBL_ENTRY)&_ZN6S855C23v73Ev,
  (VTBL_ENTRY)&_ZN6S855C23v74Ev,
  (VTBL_ENTRY)&_ZN6S855C23v75Ev,
  (VTBL_ENTRY)&_ZN6S855C23v76Ev,
  (VTBL_ENTRY)&_ZN6S855C23v77Ev,
  (VTBL_ENTRY)&_ZN6S855C23v78Ev,
  (VTBL_ENTRY)&_ZN6S855C23v79Ev,
  (VTBL_ENTRY)&_ZN6S855C23v80Ev,
  (VTBL_ENTRY)&_ZN6S855C23v81Ev,
  (VTBL_ENTRY)&_ZN6S855C23v82Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S855C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C2D1Ev,_ZThn4_N6S855C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C2D0Ev,_ZThn4_N6S855C2D0Ev),
  (VTBL_ENTRY)&_ZN6S855C63v15Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S855C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S855C2D1Ev,_ZThn60_N6S855C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S855C2D0Ev,_ZThn60_N6S855C2D0Ev),
  (VTBL_ENTRY)&_ZN7S855C103v41Ev,
};
extern VTBL_ENTRY _ZTI6S855C2[];
extern  VTBL_ENTRY _ZTV6S855C2[];
Class_Descriptor cd_S855C2 = {  "S855C2", // class name
  bases_S855C2, 5,
  &(vtc_S855C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S855C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S855C2),83, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S855C1  : S855C2 {
  virtual  ~S855C1(); // _ZN6S855C1D1Ev
  virtual void  v1(); // _ZN6S855C12v1Ev
  virtual void  v2(); // _ZN6S855C12v2Ev
  virtual void  v3(); // _ZN6S855C12v3Ev
  virtual void  v4(); // _ZN6S855C12v4Ev
  virtual void  v5(); // _ZN6S855C12v5Ev
  virtual void  v6(); // _ZN6S855C12v6Ev
  virtual void  v7(); // _ZN6S855C12v7Ev
  virtual void  v8(); // _ZN6S855C12v8Ev
  virtual void  v9(); // _ZN6S855C12v9Ev
  virtual void  v10(); // _ZN6S855C13v10Ev
  virtual void  v11(); // _ZN6S855C13v11Ev
  S855C1(); // tgen
};
//SIG(1 S855C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14} BC6{ vd v15} vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37} vd v38 v39 v40 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v41} vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 FC11{ m FL[4]} FC12{ m Fp FC11 FC13{ m Fp FC14{ Fi[4]}} Fi Fc} Fc[3] Fp FC15{ BC16{ vd v85} BC17{ vd v86} vd v83 v84 Fp[2]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11}


 S855C1 ::~S855C1(){ note_dtor("S855C1", this);}
void  S855C1 ::v1(){vfunc_called(this, "_ZN6S855C12v1Ev");}
void  S855C1 ::v2(){vfunc_called(this, "_ZN6S855C12v2Ev");}
void  S855C1 ::v3(){vfunc_called(this, "_ZN6S855C12v3Ev");}
void  S855C1 ::v4(){vfunc_called(this, "_ZN6S855C12v4Ev");}
void  S855C1 ::v5(){vfunc_called(this, "_ZN6S855C12v5Ev");}
void  S855C1 ::v6(){vfunc_called(this, "_ZN6S855C12v6Ev");}
void  S855C1 ::v7(){vfunc_called(this, "_ZN6S855C12v7Ev");}
void  S855C1 ::v8(){vfunc_called(this, "_ZN6S855C12v8Ev");}
void  S855C1 ::v9(){vfunc_called(this, "_ZN6S855C12v9Ev");}
void  S855C1 ::v10(){vfunc_called(this, "_ZN6S855C13v10Ev");}
void  S855C1 ::v11(){vfunc_called(this, "_ZN6S855C13v11Ev");}
S855C1 ::S855C1(){ note_ctor("S855C1", this);} // tgen

static void Test_S855C1()
{
  extern Class_Descriptor cd_S855C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S855C1, buf);
    S855C1 *dp, &lv = *(dp=new (buf) S855C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S855C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S855C1)");
    check_base_class_offset(lv, (S855C5*)(S855C4*)(S855C3*)(S855C2*), 0, "S855C1");
    check_base_class_offset(lv, (S855C6*)(S855C4*)(S855C3*)(S855C2*), ABISELECT(8,4), "S855C1");
    check_base_class_offset(lv, (S855C4*)(S855C3*)(S855C2*), 0, "S855C1");
    check_base_class_offset(lv, (S855C3*)(S855C2*), 0, "S855C1");
    check_base_class_offset(lv, (S855C10*)(S855C2*), ABISELECT(80,60), "S855C1");
    check_base_class_offset(lv, (S855C2*), 0, "S855C1");
    test_class_info(&lv, &cd_S855C1);
    dp->~S855C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS855C1(Test_S855C1, "S855C1", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S855C1C1Ev();
extern void _ZN6S855C1D1Ev();
Name_Map name_map_S855C1[] = {
  NSPAIR(_ZN6S855C1C1Ev),
  NSPAIR(_ZN6S855C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S855C5;
extern VTBL_ENTRY _ZTI6S855C5[];
extern  VTBL_ENTRY _ZTV6S855C5[];
extern Class_Descriptor cd_S855C6;
extern VTBL_ENTRY _ZTI6S855C6[];
extern  VTBL_ENTRY _ZTV6S855C6[];
extern Class_Descriptor cd_S855C4;
extern VTBL_ENTRY _ZTI6S855C4[];
extern  VTBL_ENTRY _ZTV6S855C4[];
extern Class_Descriptor cd_S855C3;
extern VTBL_ENTRY _ZTI6S855C3[];
extern  VTBL_ENTRY _ZTV6S855C3[];
extern Class_Descriptor cd_S855C10;
extern VTBL_ENTRY _ZTI7S855C10[];
extern  VTBL_ENTRY _ZTV7S855C10[];
extern Class_Descriptor cd_S855C2;
extern VTBL_ENTRY _ZTI6S855C2[];
extern  VTBL_ENTRY _ZTV6S855C2[];
static Base_Class bases_S855C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S855C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S855C6,    ABISELECT(8,4), //bcp->offset
    84, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S855C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S855C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S855C10,    ABISELECT(80,60), //bcp->offset
    89, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S855C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S855C1[];
extern void _ZN6S855C1D1Ev();
extern void _ZN6S855C1D0Ev();
extern void _ZN6S855C53v12Ev();
extern void _ZN6S855C53v13Ev();
extern void _ZN6S855C53v14Ev();
extern void _ZN6S855C43v16Ev();
extern void _ZN6S855C43v17Ev();
extern void _ZN6S855C43v18Ev();
extern void _ZN6S855C43v19Ev();
extern void _ZN6S855C43v20Ev();
extern void _ZN6S855C43v21Ev();
extern void _ZN6S855C43v22Ev();
extern void _ZN6S855C43v23Ev();
extern void _ZN6S855C43v24Ev();
extern void _ZN6S855C43v25Ev();
extern void _ZN6S855C43v26Ev();
extern void _ZN6S855C43v27Ev();
extern void _ZN6S855C43v28Ev();
extern void _ZN6S855C43v29Ev();
extern void _ZN6S855C43v30Ev();
extern void _ZN6S855C43v31Ev();
extern void _ZN6S855C43v32Ev();
extern void _ZN6S855C43v33Ev();
extern void _ZN6S855C43v34Ev();
extern void _ZN6S855C43v35Ev();
extern void _ZN6S855C43v36Ev();
extern void _ZN6S855C43v37Ev();
extern void _ZN6S855C33v38Ev();
extern void _ZN6S855C33v39Ev();
extern void _ZN6S855C33v40Ev();
extern void _ZN6S855C23v42Ev();
extern void _ZN6S855C23v43Ev();
extern void _ZN6S855C23v44Ev();
extern void _ZN6S855C23v45Ev();
extern void _ZN6S855C23v46Ev();
extern void _ZN6S855C23v47Ev();
extern void _ZN6S855C23v48Ev();
extern void _ZN6S855C23v49Ev();
extern void _ZN6S855C23v50Ev();
extern void _ZN6S855C23v51Ev();
extern void _ZN6S855C23v52Ev();
extern void _ZN6S855C23v53Ev();
extern void _ZN6S855C23v54Ev();
extern void _ZN6S855C23v55Ev();
extern void _ZN6S855C23v56Ev();
extern void _ZN6S855C23v57Ev();
extern void _ZN6S855C23v58Ev();
extern void _ZN6S855C23v59Ev();
extern void _ZN6S855C23v60Ev();
extern void _ZN6S855C23v61Ev();
extern void _ZN6S855C23v62Ev();
extern void _ZN6S855C23v63Ev();
extern void _ZN6S855C23v64Ev();
extern void _ZN6S855C23v65Ev();
extern void _ZN6S855C23v66Ev();
extern void _ZN6S855C23v67Ev();
extern void _ZN6S855C23v68Ev();
extern void _ZN6S855C23v69Ev();
extern void _ZN6S855C23v70Ev();
extern void _ZN6S855C23v71Ev();
extern void _ZN6S855C23v72Ev();
extern void _ZN6S855C23v73Ev();
extern void _ZN6S855C23v74Ev();
extern void _ZN6S855C23v75Ev();
extern void _ZN6S855C23v76Ev();
extern void _ZN6S855C23v77Ev();
extern void _ZN6S855C23v78Ev();
extern void _ZN6S855C23v79Ev();
extern void _ZN6S855C23v80Ev();
extern void _ZN6S855C23v81Ev();
extern void _ZN6S855C23v82Ev();
extern void _ZN6S855C12v1Ev();
extern void _ZN6S855C12v2Ev();
extern void _ZN6S855C12v3Ev();
extern void _ZN6S855C12v4Ev();
extern void _ZN6S855C12v5Ev();
extern void _ZN6S855C12v6Ev();
extern void _ZN6S855C12v7Ev();
extern void _ZN6S855C12v8Ev();
extern void _ZN6S855C12v9Ev();
extern void _ZN6S855C13v10Ev();
extern void _ZN6S855C13v11Ev();
extern void ABISELECT(_ZThn8_N6S855C1D1Ev,_ZThn4_N6S855C1D1Ev)();
extern void ABISELECT(_ZThn8_N6S855C1D0Ev,_ZThn4_N6S855C1D0Ev)();
extern void _ZN6S855C63v15Ev();
extern void ABISELECT(_ZThn80_N6S855C1D1Ev,_ZThn60_N6S855C1D1Ev)();
extern void ABISELECT(_ZThn80_N6S855C1D0Ev,_ZThn60_N6S855C1D0Ev)();
extern void _ZN7S855C103v41Ev();
static  VTBL_ENTRY vtc_S855C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S855C1[0]),
  (VTBL_ENTRY)&_ZN6S855C1D1Ev,
  (VTBL_ENTRY)&_ZN6S855C1D0Ev,
  (VTBL_ENTRY)&_ZN6S855C53v12Ev,
  (VTBL_ENTRY)&_ZN6S855C53v13Ev,
  (VTBL_ENTRY)&_ZN6S855C53v14Ev,
  (VTBL_ENTRY)&_ZN6S855C43v16Ev,
  (VTBL_ENTRY)&_ZN6S855C43v17Ev,
  (VTBL_ENTRY)&_ZN6S855C43v18Ev,
  (VTBL_ENTRY)&_ZN6S855C43v19Ev,
  (VTBL_ENTRY)&_ZN6S855C43v20Ev,
  (VTBL_ENTRY)&_ZN6S855C43v21Ev,
  (VTBL_ENTRY)&_ZN6S855C43v22Ev,
  (VTBL_ENTRY)&_ZN6S855C43v23Ev,
  (VTBL_ENTRY)&_ZN6S855C43v24Ev,
  (VTBL_ENTRY)&_ZN6S855C43v25Ev,
  (VTBL_ENTRY)&_ZN6S855C43v26Ev,
  (VTBL_ENTRY)&_ZN6S855C43v27Ev,
  (VTBL_ENTRY)&_ZN6S855C43v28Ev,
  (VTBL_ENTRY)&_ZN6S855C43v29Ev,
  (VTBL_ENTRY)&_ZN6S855C43v30Ev,
  (VTBL_ENTRY)&_ZN6S855C43v31Ev,
  (VTBL_ENTRY)&_ZN6S855C43v32Ev,
  (VTBL_ENTRY)&_ZN6S855C43v33Ev,
  (VTBL_ENTRY)&_ZN6S855C43v34Ev,
  (VTBL_ENTRY)&_ZN6S855C43v35Ev,
  (VTBL_ENTRY)&_ZN6S855C43v36Ev,
  (VTBL_ENTRY)&_ZN6S855C43v37Ev,
  (VTBL_ENTRY)&_ZN6S855C33v38Ev,
  (VTBL_ENTRY)&_ZN6S855C33v39Ev,
  (VTBL_ENTRY)&_ZN6S855C33v40Ev,
  (VTBL_ENTRY)&_ZN6S855C23v42Ev,
  (VTBL_ENTRY)&_ZN6S855C23v43Ev,
  (VTBL_ENTRY)&_ZN6S855C23v44Ev,
  (VTBL_ENTRY)&_ZN6S855C23v45Ev,
  (VTBL_ENTRY)&_ZN6S855C23v46Ev,
  (VTBL_ENTRY)&_ZN6S855C23v47Ev,
  (VTBL_ENTRY)&_ZN6S855C23v48Ev,
  (VTBL_ENTRY)&_ZN6S855C23v49Ev,
  (VTBL_ENTRY)&_ZN6S855C23v50Ev,
  (VTBL_ENTRY)&_ZN6S855C23v51Ev,
  (VTBL_ENTRY)&_ZN6S855C23v52Ev,
  (VTBL_ENTRY)&_ZN6S855C23v53Ev,
  (VTBL_ENTRY)&_ZN6S855C23v54Ev,
  (VTBL_ENTRY)&_ZN6S855C23v55Ev,
  (VTBL_ENTRY)&_ZN6S855C23v56Ev,
  (VTBL_ENTRY)&_ZN6S855C23v57Ev,
  (VTBL_ENTRY)&_ZN6S855C23v58Ev,
  (VTBL_ENTRY)&_ZN6S855C23v59Ev,
  (VTBL_ENTRY)&_ZN6S855C23v60Ev,
  (VTBL_ENTRY)&_ZN6S855C23v61Ev,
  (VTBL_ENTRY)&_ZN6S855C23v62Ev,
  (VTBL_ENTRY)&_ZN6S855C23v63Ev,
  (VTBL_ENTRY)&_ZN6S855C23v64Ev,
  (VTBL_ENTRY)&_ZN6S855C23v65Ev,
  (VTBL_ENTRY)&_ZN6S855C23v66Ev,
  (VTBL_ENTRY)&_ZN6S855C23v67Ev,
  (VTBL_ENTRY)&_ZN6S855C23v68Ev,
  (VTBL_ENTRY)&_ZN6S855C23v69Ev,
  (VTBL_ENTRY)&_ZN6S855C23v70Ev,
  (VTBL_ENTRY)&_ZN6S855C23v71Ev,
  (VTBL_ENTRY)&_ZN6S855C23v72Ev,
  (VTBL_ENTRY)&_ZN6S855C23v73Ev,
  (VTBL_ENTRY)&_ZN6S855C23v74Ev,
  (VTBL_ENTRY)&_ZN6S855C23v75Ev,
  (VTBL_ENTRY)&_ZN6S855C23v76Ev,
  (VTBL_ENTRY)&_ZN6S855C23v77Ev,
  (VTBL_ENTRY)&_ZN6S855C23v78Ev,
  (VTBL_ENTRY)&_ZN6S855C23v79Ev,
  (VTBL_ENTRY)&_ZN6S855C23v80Ev,
  (VTBL_ENTRY)&_ZN6S855C23v81Ev,
  (VTBL_ENTRY)&_ZN6S855C23v82Ev,
  (VTBL_ENTRY)&_ZN6S855C12v1Ev,
  (VTBL_ENTRY)&_ZN6S855C12v2Ev,
  (VTBL_ENTRY)&_ZN6S855C12v3Ev,
  (VTBL_ENTRY)&_ZN6S855C12v4Ev,
  (VTBL_ENTRY)&_ZN6S855C12v5Ev,
  (VTBL_ENTRY)&_ZN6S855C12v6Ev,
  (VTBL_ENTRY)&_ZN6S855C12v7Ev,
  (VTBL_ENTRY)&_ZN6S855C12v8Ev,
  (VTBL_ENTRY)&_ZN6S855C12v9Ev,
  (VTBL_ENTRY)&_ZN6S855C13v10Ev,
  (VTBL_ENTRY)&_ZN6S855C13v11Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S855C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C1D1Ev,_ZThn4_N6S855C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S855C1D0Ev,_ZThn4_N6S855C1D0Ev),
  (VTBL_ENTRY)&_ZN6S855C63v15Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S855C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S855C1D1Ev,_ZThn60_N6S855C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S855C1D0Ev,_ZThn60_N6S855C1D0Ev),
  (VTBL_ENTRY)&_ZN7S855C103v41Ev,
};
extern VTBL_ENTRY _ZTI6S855C1[];
extern  VTBL_ENTRY _ZTV6S855C1[];
Class_Descriptor cd_S855C1 = {  "S855C1", // class name
  bases_S855C1, 6,
  &(vtc_S855C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S855C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S855C1),94, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S854C5  {
  virtual  ~S854C5(); // _ZN6S854C5D1Ev
  virtual void  v12(); // _ZN6S854C53v12Ev
  virtual void  v13(); // _ZN6S854C53v13Ev
  virtual void  v14(); // _ZN6S854C53v14Ev
  S854C5(); // tgen
};
//SIG(-1 S854C5) C1{ vd v1 v2 v3}


 S854C5 ::~S854C5(){ note_dtor("S854C5", this);}
void  S854C5 ::v12(){vfunc_called(this, "_ZN6S854C53v12Ev");}
void  S854C5 ::v13(){vfunc_called(this, "_ZN6S854C53v13Ev");}
void  S854C5 ::v14(){vfunc_called(this, "_ZN6S854C53v14Ev");}
S854C5 ::S854C5(){ note_ctor("S854C5", this);} // tgen

static void Test_S854C5()
{
  extern Class_Descriptor cd_S854C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S854C5, buf);
    S854C5 *dp, &lv = *(dp=new (buf) S854C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S854C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S854C5)");
    test_class_info(&lv, &cd_S854C5);
    dp->~S854C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS854C5(Test_S854C5, "S854C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S854C5C1Ev();
extern void _ZN6S854C5D1Ev();
Name_Map name_map_S854C5[] = {
  NSPAIR(_ZN6S854C5C1Ev),
  NSPAIR(_ZN6S854C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S854C5[];
extern void _ZN6S854C5D1Ev();
extern void _ZN6S854C5D0Ev();
extern void _ZN6S854C53v12Ev();
extern void _ZN6S854C53v13Ev();
extern void _ZN6S854C53v14Ev();
static  VTBL_ENTRY vtc_S854C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S854C5[0]),
  (VTBL_ENTRY)&_ZN6S854C5D1Ev,
  (VTBL_ENTRY)&_ZN6S854C5D0Ev,
  (VTBL_ENTRY)&_ZN6S854C53v12Ev,
  (VTBL_ENTRY)&_ZN6S854C53v13Ev,
  (VTBL_ENTRY)&_ZN6S854C53v14Ev,
};
extern VTBL_ENTRY _ZTI6S854C5[];
extern  VTBL_ENTRY _ZTV6S854C5[];
Class_Descriptor cd_S854C5 = {  "S854C5", // class name
  0,0,//no base classes
  &(vtc_S854C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S854C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S854C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S854C6  {
  virtual  ~S854C6(); // _ZN6S854C6D1Ev
  virtual void  v15(); // _ZN6S854C63v15Ev
  S854C6(); // tgen
};
//SIG(-1 S854C6) C1{ vd v1}


 S854C6 ::~S854C6(){ note_dtor("S854C6", this);}
void  S854C6 ::v15(){vfunc_called(this, "_ZN6S854C63v15Ev");}
S854C6 ::S854C6(){ note_ctor("S854C6", this);} // tgen

static void Test_S854C6()
{
  extern Class_Descriptor cd_S854C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S854C6, buf);
    S854C6 *dp, &lv = *(dp=new (buf) S854C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S854C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S854C6)");
    test_class_info(&lv, &cd_S854C6);
    dp->~S854C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS854C6(Test_S854C6, "S854C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S854C6C1Ev();
extern void _ZN6S854C6D1Ev();
Name_Map name_map_S854C6[] = {
  NSPAIR(_ZN6S854C6C1Ev),
  NSPAIR(_ZN6S854C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S854C6[];
extern void _ZN6S854C6D1Ev();
extern void _ZN6S854C6D0Ev();
extern void _ZN6S854C63v15Ev();
static  VTBL_ENTRY vtc_S854C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S854C6[0]),
  (VTBL_ENTRY)&_ZN6S854C6D1Ev,
  (VTBL_ENTRY)&_ZN6S854C6D0Ev,
  (VTBL_ENTRY)&_ZN6S854C63v15Ev,
};
extern VTBL_ENTRY _ZTI6S854C6[];
extern  VTBL_ENTRY _ZTV6S854C6[];
Class_Descriptor cd_S854C6 = {  "S854C6", // class name
  0,0,//no base classes
  &(vtc_S854C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S854C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S854C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S854C4  : S854C5 , S854C6 {
  virtual  ~S854C4(); // _ZN6S854C4D1Ev
  virtual void  v16(); // _ZN6S854C43v16Ev
  virtual void  v17(); // _ZN6S854C43v17Ev
  virtual void  v18(); // _ZN6S854C43v18Ev
  virtual void  v19(); // _ZN6S854C43v19Ev
  virtual void  v20(); // _ZN6S854C43v20Ev
  virtual void  v21(); // _ZN6S854C43v21Ev
  virtual void  v22(); // _ZN6S854C43v22Ev
  virtual void  v23(); // _ZN6S854C43v23Ev
  virtual void  v24(); // _ZN6S854C43v24Ev
  virtual void  v25(); // _ZN6S854C43v25Ev
  virtual void  v26(); // _ZN6S854C43v26Ev
  virtual void  v27(); // _ZN6S854C43v27Ev
  virtual void  v28(); // _ZN6S854C43v28Ev
  virtual void  v29(); // _ZN6S854C43v29Ev
  virtual void  v30(); // _ZN6S854C43v30Ev
  virtual void  v31(); // _ZN6S854C43v31Ev
  virtual void  v32(); // _ZN6S854C43v32Ev
  virtual void  v33(); // _ZN6S854C43v33Ev
  virtual void  v34(); // _ZN6S854C43v34Ev
  virtual void  v35(); // _ZN6S854C43v35Ev
  virtual void  v36(); // _ZN6S854C43v36Ev
  virtual void  v37(); // _ZN6S854C43v37Ev
  S854C4(); // tgen
};
//SIG(-1 S854C4) C1{ BC2{ vd v23 v24 v25} BC3{ vd v26} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22}


 S854C4 ::~S854C4(){ note_dtor("S854C4", this);}
void  S854C4 ::v16(){vfunc_called(this, "_ZN6S854C43v16Ev");}
void  S854C4 ::v17(){vfunc_called(this, "_ZN6S854C43v17Ev");}
void  S854C4 ::v18(){vfunc_called(this, "_ZN6S854C43v18Ev");}
void  S854C4 ::v19(){vfunc_called(this, "_ZN6S854C43v19Ev");}
void  S854C4 ::v20(){vfunc_called(this, "_ZN6S854C43v20Ev");}
void  S854C4 ::v21(){vfunc_called(this, "_ZN6S854C43v21Ev");}
void  S854C4 ::v22(){vfunc_called(this, "_ZN6S854C43v22Ev");}
void  S854C4 ::v23(){vfunc_called(this, "_ZN6S854C43v23Ev");}
void  S854C4 ::v24(){vfunc_called(this, "_ZN6S854C43v24Ev");}
void  S854C4 ::v25(){vfunc_called(this, "_ZN6S854C43v25Ev");}
void  S854C4 ::v26(){vfunc_called(this, "_ZN6S854C43v26Ev");}
void  S854C4 ::v27(){vfunc_called(this, "_ZN6S854C43v27Ev");}
void  S854C4 ::v28(){vfunc_called(this, "_ZN6S854C43v28Ev");}
void  S854C4 ::v29(){vfunc_called(this, "_ZN6S854C43v29Ev");}
void  S854C4 ::v30(){vfunc_called(this, "_ZN6S854C43v30Ev");}
void  S854C4 ::v31(){vfunc_called(this, "_ZN6S854C43v31Ev");}
void  S854C4 ::v32(){vfunc_called(this, "_ZN6S854C43v32Ev");}
void  S854C4 ::v33(){vfunc_called(this, "_ZN6S854C43v33Ev");}
void  S854C4 ::v34(){vfunc_called(this, "_ZN6S854C43v34Ev");}
void  S854C4 ::v35(){vfunc_called(this, "_ZN6S854C43v35Ev");}
void  S854C4 ::v36(){vfunc_called(this, "_ZN6S854C43v36Ev");}
void  S854C4 ::v37(){vfunc_called(this, "_ZN6S854C43v37Ev");}
S854C4 ::S854C4(){ note_ctor("S854C4", this);} // tgen

static void Test_S854C4()
{
  extern Class_Descriptor cd_S854C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S854C4, buf);
    S854C4 *dp, &lv = *(dp=new (buf) S854C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S854C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S854C4)");
    check_base_class_offset(lv, (S854C5*), 0, "S854C4");
    check_base_class_offset(lv, (S854C6*), ABISELECT(8,4), "S854C4");
    test_class_info(&lv, &cd_S854C4);
    dp->~S854C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS854C4(Test_S854C4, "S854C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN6S854C4C1Ev();
extern void _ZN6S854C4D1Ev();
Name_Map name_map_S854C4[] = {
  NSPAIR(_ZN6S854C4C1Ev),
  NSPAIR(_ZN6S854C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S854C5;
extern VTBL_ENTRY _ZTI6S854C5[];
extern  VTBL_ENTRY _ZTV6S854C5[];
extern Class_Descriptor cd_S854C6;
extern VTBL_ENTRY _ZTI6S854C6[];
extern  VTBL_ENTRY _ZTV6S854C6[];
static Base_Class bases_S854C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S854C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S854C6,    ABISELECT(8,4), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S854C4[];
extern void _ZN6S854C4D1Ev();
extern void _ZN6S854C4D0Ev();
extern void _ZN6S854C53v12Ev();
extern void _ZN6S854C53v13Ev();
extern void _ZN6S854C53v14Ev();
extern void _ZN6S854C43v16Ev();
extern void _ZN6S854C43v17Ev();
extern void _ZN6S854C43v18Ev();
extern void _ZN6S854C43v19Ev();
extern void _ZN6S854C43v20Ev();
extern void _ZN6S854C43v21Ev();
extern void _ZN6S854C43v22Ev();
extern void _ZN6S854C43v23Ev();
extern void _ZN6S854C43v24Ev();
extern void _ZN6S854C43v25Ev();
extern void _ZN6S854C43v26Ev();
extern void _ZN6S854C43v27Ev();
extern void _ZN6S854C43v28Ev();
extern void _ZN6S854C43v29Ev();
extern void _ZN6S854C43v30Ev();
extern void _ZN6S854C43v31Ev();
extern void _ZN6S854C43v32Ev();
extern void _ZN6S854C43v33Ev();
extern void _ZN6S854C43v34Ev();
extern void _ZN6S854C43v35Ev();
extern void _ZN6S854C43v36Ev();
extern void _ZN6S854C43v37Ev();
extern void ABISELECT(_ZThn8_N6S854C4D1Ev,_ZThn4_N6S854C4D1Ev)();
extern void ABISELECT(_ZThn8_N6S854C4D0Ev,_ZThn4_N6S854C4D0Ev)();
extern void _ZN6S854C63v15Ev();
static  VTBL_ENTRY vtc_S854C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S854C4[0]),
  (VTBL_ENTRY)&_ZN6S854C4D1Ev,
  (VTBL_ENTRY)&_ZN6S854C4D0Ev,
  (VTBL_ENTRY)&_ZN6S854C53v12Ev,
  (VTBL_ENTRY)&_ZN6S854C53v13Ev,
  (VTBL_ENTRY)&_ZN6S854C53v14Ev,
  (VTBL_ENTRY)&_ZN6S854C43v16Ev,
  (VTBL_ENTRY)&_ZN6S854C43v17Ev,
  (VTBL_ENTRY)&_ZN6S854C43v18Ev,
  (VTBL_ENTRY)&_ZN6S854C43v19Ev,
  (VTBL_ENTRY)&_ZN6S854C43v20Ev,
  (VTBL_ENTRY)&_ZN6S854C43v21Ev,
  (VTBL_ENTRY)&_ZN6S854C43v22Ev,
  (VTBL_ENTRY)&_ZN6S854C43v23Ev,
  (VTBL_ENTRY)&_ZN6S854C43v24Ev,
  (VTBL_ENTRY)&_ZN6S854C43v25Ev,
  (VTBL_ENTRY)&_ZN6S854C43v26Ev,
  (VTBL_ENTRY)&_ZN6S854C43v27Ev,
  (VTBL_ENTRY)&_ZN6S854C43v28Ev,
  (VTBL_ENTRY)&_ZN6S854C43v29Ev,
  (VTBL_ENTRY)&_ZN6S854C43v30Ev,
  (VTBL_ENTRY)&_ZN6S854C43v31Ev,
  (VTBL_ENTRY)&_ZN6S854C43v32Ev,
  (VTBL_ENTRY)&_ZN6S854C43v33Ev,
  (VTBL_ENTRY)&_ZN6S854C43v34Ev,
  (VTBL_ENTRY)&_ZN6S854C43v35Ev,
  (VTBL_ENTRY)&_ZN6S854C43v36Ev,
  (VTBL_ENTRY)&_ZN6S854C43v37Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S854C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C4D1Ev,_ZThn4_N6S854C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C4D0Ev,_ZThn4_N6S854C4D0Ev),
  (VTBL_ENTRY)&_ZN6S854C63v15Ev,
};
extern VTBL_ENTRY _ZTI6S854C4[];
extern  VTBL_ENTRY _ZTV6S854C4[];
Class_Descriptor cd_S854C4 = {  "S854C4", // class name
  bases_S854C4, 2,
  &(vtc_S854C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI6S854C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S854C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S854C3  : S854C4 {
  ::S858C7_nt s854c3f0;
  ::S9124C5_nt s854c3f1;
  char s854c3f2;
  virtual  ~S854C3(); // _ZN6S854C3D1Ev
  virtual void  v38(); // _ZN6S854C33v38Ev
  virtual void  v39(); // _ZN6S854C33v39Ev
  virtual void  v40(); // _ZN6S854C33v40Ev
  S854C3(); // tgen
};
//SIG(-1 S854C3) C1{ BC2{ BC3{ vd v4 v5 v6} BC4{ vd v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29} vd v1 v2 v3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc}


 S854C3 ::~S854C3(){ note_dtor("S854C3", this);}
void  S854C3 ::v38(){vfunc_called(this, "_ZN6S854C33v38Ev");}
void  S854C3 ::v39(){vfunc_called(this, "_ZN6S854C33v39Ev");}
void  S854C3 ::v40(){vfunc_called(this, "_ZN6S854C33v40Ev");}
S854C3 ::S854C3(){ note_ctor("S854C3", this);} // tgen

static void Test_S854C3()
{
  extern Class_Descriptor cd_S854C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S854C3, buf);
    S854C3 *dp, &lv = *(dp=new (buf) S854C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S854C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S854C3)");
    check_base_class_offset(lv, (S854C5*)(S854C4*), 0, "S854C3");
    check_base_class_offset(lv, (S854C6*)(S854C4*), ABISELECT(8,4), "S854C3");
    check_base_class_offset(lv, (S854C4*), 0, "S854C3");
    check_field_offset(lv, s854c3f0, ABISELECT(16,8), "S854C3.s854c3f0");
    check_field_offset(lv, s854c3f1, ABISELECT(40,24), "S854C3.s854c3f1");
    check_field_offset(lv, s854c3f2, ABISELECT(72,56), "S854C3.s854c3f2");
    test_class_info(&lv, &cd_S854C3);
    dp->~S854C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS854C3(Test_S854C3, "S854C3", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN6S854C3C1Ev();
extern void _ZN6S854C3D1Ev();
Name_Map name_map_S854C3[] = {
  NSPAIR(_ZN6S854C3C1Ev),
  NSPAIR(_ZN6S854C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S854C5;
extern VTBL_ENTRY _ZTI6S854C5[];
extern  VTBL_ENTRY _ZTV6S854C5[];
extern Class_Descriptor cd_S854C6;
extern VTBL_ENTRY _ZTI6S854C6[];
extern  VTBL_ENTRY _ZTV6S854C6[];
extern Class_Descriptor cd_S854C4;
extern VTBL_ENTRY _ZTI6S854C4[];
extern  VTBL_ENTRY _ZTV6S854C4[];
static Base_Class bases_S854C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S854C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S854C6,    ABISELECT(8,4), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S854C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S854C3[];
extern void _ZN6S854C3D1Ev();
extern void _ZN6S854C3D0Ev();
extern void _ZN6S854C53v12Ev();
extern void _ZN6S854C53v13Ev();
extern void _ZN6S854C53v14Ev();
extern void _ZN6S854C43v16Ev();
extern void _ZN6S854C43v17Ev();
extern void _ZN6S854C43v18Ev();
extern void _ZN6S854C43v19Ev();
extern void _ZN6S854C43v20Ev();
extern void _ZN6S854C43v21Ev();
extern void _ZN6S854C43v22Ev();
extern void _ZN6S854C43v23Ev();
extern void _ZN6S854C43v24Ev();
extern void _ZN6S854C43v25Ev();
extern void _ZN6S854C43v26Ev();
extern void _ZN6S854C43v27Ev();
extern void _ZN6S854C43v28Ev();
extern void _ZN6S854C43v29Ev();
extern void _ZN6S854C43v30Ev();
extern void _ZN6S854C43v31Ev();
extern void _ZN6S854C43v32Ev();
extern void _ZN6S854C43v33Ev();
extern void _ZN6S854C43v34Ev();
extern void _ZN6S854C43v35Ev();
extern void _ZN6S854C43v36Ev();
extern void _ZN6S854C43v37Ev();
extern void _ZN6S854C33v38Ev();
extern void _ZN6S854C33v39Ev();
extern void _ZN6S854C33v40Ev();
extern void ABISELECT(_ZThn8_N6S854C3D1Ev,_ZThn4_N6S854C3D1Ev)();
extern void ABISELECT(_ZThn8_N6S854C3D0Ev,_ZThn4_N6S854C3D0Ev)();
extern void _ZN6S854C63v15Ev();
static  VTBL_ENTRY vtc_S854C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S854C3[0]),
  (VTBL_ENTRY)&_ZN6S854C3D1Ev,
  (VTBL_ENTRY)&_ZN6S854C3D0Ev,
  (VTBL_ENTRY)&_ZN6S854C53v12Ev,
  (VTBL_ENTRY)&_ZN6S854C53v13Ev,
  (VTBL_ENTRY)&_ZN6S854C53v14Ev,
  (VTBL_ENTRY)&_ZN6S854C43v16Ev,
  (VTBL_ENTRY)&_ZN6S854C43v17Ev,
  (VTBL_ENTRY)&_ZN6S854C43v18Ev,
  (VTBL_ENTRY)&_ZN6S854C43v19Ev,
  (VTBL_ENTRY)&_ZN6S854C43v20Ev,
  (VTBL_ENTRY)&_ZN6S854C43v21Ev,
  (VTBL_ENTRY)&_ZN6S854C43v22Ev,
  (VTBL_ENTRY)&_ZN6S854C43v23Ev,
  (VTBL_ENTRY)&_ZN6S854C43v24Ev,
  (VTBL_ENTRY)&_ZN6S854C43v25Ev,
  (VTBL_ENTRY)&_ZN6S854C43v26Ev,
  (VTBL_ENTRY)&_ZN6S854C43v27Ev,
  (VTBL_ENTRY)&_ZN6S854C43v28Ev,
  (VTBL_ENTRY)&_ZN6S854C43v29Ev,
  (VTBL_ENTRY)&_ZN6S854C43v30Ev,
  (VTBL_ENTRY)&_ZN6S854C43v31Ev,
  (VTBL_ENTRY)&_ZN6S854C43v32Ev,
  (VTBL_ENTRY)&_ZN6S854C43v33Ev,
  (VTBL_ENTRY)&_ZN6S854C43v34Ev,
  (VTBL_ENTRY)&_ZN6S854C43v35Ev,
  (VTBL_ENTRY)&_ZN6S854C43v36Ev,
  (VTBL_ENTRY)&_ZN6S854C43v37Ev,
  (VTBL_ENTRY)&_ZN6S854C33v38Ev,
  (VTBL_ENTRY)&_ZN6S854C33v39Ev,
  (VTBL_ENTRY)&_ZN6S854C33v40Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S854C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C3D1Ev,_ZThn4_N6S854C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C3D0Ev,_ZThn4_N6S854C3D0Ev),
  (VTBL_ENTRY)&_ZN6S854C63v15Ev,
};
extern VTBL_ENTRY _ZTI6S854C3[];
extern  VTBL_ENTRY _ZTV6S854C3[];
Class_Descriptor cd_S854C3 = {  "S854C3", // class name
  bases_S854C3, 3,
  &(vtc_S854C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI6S854C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S854C3),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S854C10  {
  virtual  ~S854C10(); // _ZN7S854C10D1Ev
  virtual void  v41(); // _ZN7S854C103v41Ev
  S854C10(); // tgen
};
//SIG(-1 S854C10) C1{ vd v1}


 S854C10 ::~S854C10(){ note_dtor("S854C10", this);}
void  S854C10 ::v41(){vfunc_called(this, "_ZN7S854C103v41Ev");}
S854C10 ::S854C10(){ note_ctor("S854C10", this);} // tgen

static void Test_S854C10()
{
  extern Class_Descriptor cd_S854C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S854C10, buf);
    S854C10 *dp, &lv = *(dp=new (buf) S854C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S854C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S854C10)");
    test_class_info(&lv, &cd_S854C10);
    dp->~S854C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS854C10(Test_S854C10, "S854C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S854C10C1Ev();
extern void _ZN7S854C10D1Ev();
Name_Map name_map_S854C10[] = {
  NSPAIR(_ZN7S854C10C1Ev),
  NSPAIR(_ZN7S854C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S854C10[];
extern void _ZN7S854C10D1Ev();
extern void _ZN7S854C10D0Ev();
extern void _ZN7S854C103v41Ev();
static  VTBL_ENTRY vtc_S854C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S854C10[0]),
  (VTBL_ENTRY)&_ZN7S854C10D1Ev,
  (VTBL_ENTRY)&_ZN7S854C10D0Ev,
  (VTBL_ENTRY)&_ZN7S854C103v41Ev,
};
extern VTBL_ENTRY _ZTI7S854C10[];
extern  VTBL_ENTRY _ZTV7S854C10[];
Class_Descriptor cd_S854C10 = {  "S854C10", // class name
  0,0,//no base classes
  &(vtc_S854C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S854C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S854C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S854C2  : S854C3 , S854C10 {
  ::S858C11_nt s854c2f0;
  ::S858C12_nt s854c2f1;
  char s854c2f2[2];
  void *s854c2f3;
  ::S858C15_nt s854c2f4;
  void *s854c2f5;
  virtual  ~S854C2(); // _ZN6S854C2D1Ev
  virtual void  v42(); // _ZN6S854C23v42Ev
  virtual void  v43(); // _ZN6S854C23v43Ev
  virtual void  v44(); // _ZN6S854C23v44Ev
  virtual void  v45(); // _ZN6S854C23v45Ev
  virtual void  v46(); // _ZN6S854C23v46Ev
  virtual void  v47(); // _ZN6S854C23v47Ev
  virtual void  v48(); // _ZN6S854C23v48Ev
  virtual void  v49(); // _ZN6S854C23v49Ev
  virtual void  v50(); // _ZN6S854C23v50Ev
  virtual void  v51(); // _ZN6S854C23v51Ev
  virtual void  v52(); // _ZN6S854C23v52Ev
  virtual void  v53(); // _ZN6S854C23v53Ev
  virtual void  v54(); // _ZN6S854C23v54Ev
  virtual void  v55(); // _ZN6S854C23v55Ev
  virtual void  v56(); // _ZN6S854C23v56Ev
  virtual void  v57(); // _ZN6S854C23v57Ev
  virtual void  v58(); // _ZN6S854C23v58Ev
  virtual void  v59(); // _ZN6S854C23v59Ev
  virtual void  v60(); // _ZN6S854C23v60Ev
  virtual void  v61(); // _ZN6S854C23v61Ev
  virtual void  v62(); // _ZN6S854C23v62Ev
  virtual void  v63(); // _ZN6S854C23v63Ev
  virtual void  v64(); // _ZN6S854C23v64Ev
  virtual void  v65(); // _ZN6S854C23v65Ev
  virtual void  v66(); // _ZN6S854C23v66Ev
  virtual void  v67(); // _ZN6S854C23v67Ev
  virtual void  v68(); // _ZN6S854C23v68Ev
  virtual void  v69(); // _ZN6S854C23v69Ev
  virtual void  v70(); // _ZN6S854C23v70Ev
  virtual void  v71(); // _ZN6S854C23v71Ev
  virtual void  v72(); // _ZN6S854C23v72Ev
  virtual void  v73(); // _ZN6S854C23v73Ev
  virtual void  v74(); // _ZN6S854C23v74Ev
  virtual void  v75(); // _ZN6S854C23v75Ev
  virtual void  v76(); // _ZN6S854C23v76Ev
  virtual void  v77(); // _ZN6S854C23v77Ev
  virtual void  v78(); // _ZN6S854C23v78Ev
  virtual void  v79(); // _ZN6S854C23v79Ev
  virtual void  v80(); // _ZN6S854C23v80Ev
  virtual void  v81(); // _ZN6S854C23v81Ev
  virtual void  v82(); // _ZN6S854C23v82Ev
  S854C2(); // tgen
};
//SIG(-1 S854C2) C1{ BC2{ BC3{ BC4{ vd v42 v43 v44} BC5{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FL[4]} Fc} BC9{ vd v71} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC10{ m FL[4]} FC11{ m Fp FC10 FC12{ m Fp FC13{ Fi[4]}} Fi Fc} Fc[2] Fp FC14{ BC15{ vd v74} BC16{ vd v75} vd v72 v73 Fp[2]} Fp}


 S854C2 ::~S854C2(){ note_dtor("S854C2", this);}
void  S854C2 ::v42(){vfunc_called(this, "_ZN6S854C23v42Ev");}
void  S854C2 ::v43(){vfunc_called(this, "_ZN6S854C23v43Ev");}
void  S854C2 ::v44(){vfunc_called(this, "_ZN6S854C23v44Ev");}
void  S854C2 ::v45(){vfunc_called(this, "_ZN6S854C23v45Ev");}
void  S854C2 ::v46(){vfunc_called(this, "_ZN6S854C23v46Ev");}
void  S854C2 ::v47(){vfunc_called(this, "_ZN6S854C23v47Ev");}
void  S854C2 ::v48(){vfunc_called(this, "_ZN6S854C23v48Ev");}
void  S854C2 ::v49(){vfunc_called(this, "_ZN6S854C23v49Ev");}
void  S854C2 ::v50(){vfunc_called(this, "_ZN6S854C23v50Ev");}
void  S854C2 ::v51(){vfunc_called(this, "_ZN6S854C23v51Ev");}
void  S854C2 ::v52(){vfunc_called(this, "_ZN6S854C23v52Ev");}
void  S854C2 ::v53(){vfunc_called(this, "_ZN6S854C23v53Ev");}
void  S854C2 ::v54(){vfunc_called(this, "_ZN6S854C23v54Ev");}
void  S854C2 ::v55(){vfunc_called(this, "_ZN6S854C23v55Ev");}
void  S854C2 ::v56(){vfunc_called(this, "_ZN6S854C23v56Ev");}
void  S854C2 ::v57(){vfunc_called(this, "_ZN6S854C23v57Ev");}
void  S854C2 ::v58(){vfunc_called(this, "_ZN6S854C23v58Ev");}
void  S854C2 ::v59(){vfunc_called(this, "_ZN6S854C23v59Ev");}
void  S854C2 ::v60(){vfunc_called(this, "_ZN6S854C23v60Ev");}
void  S854C2 ::v61(){vfunc_called(this, "_ZN6S854C23v61Ev");}
void  S854C2 ::v62(){vfunc_called(this, "_ZN6S854C23v62Ev");}
void  S854C2 ::v63(){vfunc_called(this, "_ZN6S854C23v63Ev");}
void  S854C2 ::v64(){vfunc_called(this, "_ZN6S854C23v64Ev");}
void  S854C2 ::v65(){vfunc_called(this, "_ZN6S854C23v65Ev");}
void  S854C2 ::v66(){vfunc_called(this, "_ZN6S854C23v66Ev");}
void  S854C2 ::v67(){vfunc_called(this, "_ZN6S854C23v67Ev");}
void  S854C2 ::v68(){vfunc_called(this, "_ZN6S854C23v68Ev");}
void  S854C2 ::v69(){vfunc_called(this, "_ZN6S854C23v69Ev");}
void  S854C2 ::v70(){vfunc_called(this, "_ZN6S854C23v70Ev");}
void  S854C2 ::v71(){vfunc_called(this, "_ZN6S854C23v71Ev");}
void  S854C2 ::v72(){vfunc_called(this, "_ZN6S854C23v72Ev");}
void  S854C2 ::v73(){vfunc_called(this, "_ZN6S854C23v73Ev");}
void  S854C2 ::v74(){vfunc_called(this, "_ZN6S854C23v74Ev");}
void  S854C2 ::v75(){vfunc_called(this, "_ZN6S854C23v75Ev");}
void  S854C2 ::v76(){vfunc_called(this, "_ZN6S854C23v76Ev");}
void  S854C2 ::v77(){vfunc_called(this, "_ZN6S854C23v77Ev");}
void  S854C2 ::v78(){vfunc_called(this, "_ZN6S854C23v78Ev");}
void  S854C2 ::v79(){vfunc_called(this, "_ZN6S854C23v79Ev");}
void  S854C2 ::v80(){vfunc_called(this, "_ZN6S854C23v80Ev");}
void  S854C2 ::v81(){vfunc_called(this, "_ZN6S854C23v81Ev");}
void  S854C2 ::v82(){vfunc_called(this, "_ZN6S854C23v82Ev");}
S854C2 ::S854C2(){ note_ctor("S854C2", this);} // tgen

static void Test_S854C2()
{
  extern Class_Descriptor cd_S854C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S854C2, buf);
    S854C2 *dp, &lv = *(dp=new (buf) S854C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S854C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S854C2)");
    check_base_class_offset(lv, (S854C5*)(S854C4*)(S854C3*), 0, "S854C2");
    check_base_class_offset(lv, (S854C6*)(S854C4*)(S854C3*), ABISELECT(8,4), "S854C2");
    check_base_class_offset(lv, (S854C4*)(S854C3*), 0, "S854C2");
    check_base_class_offset(lv, (S854C3*), 0, "S854C2");
    check_base_class_offset(lv, (S854C10*), ABISELECT(80,60), "S854C2");
    check_field_offset(lv, s854c2f0, ABISELECT(88,64), "S854C2.s854c2f0");
    check_field_offset(lv, s854c2f1, ABISELECT(120,96), "S854C2.s854c2f1");
    check_field_offset(lv, s854c2f2, ABISELECT(192,160), "S854C2.s854c2f2");
    check_field_offset(lv, s854c2f3, ABISELECT(200,164), "S854C2.s854c2f3");
    check_field_offset(lv, s854c2f4, ABISELECT(208,168), "S854C2.s854c2f4");
    check_field_offset(lv, s854c2f5, ABISELECT(240,184), "S854C2.s854c2f5");
    test_class_info(&lv, &cd_S854C2);
    dp->~S854C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS854C2(Test_S854C2, "S854C2", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S854C2C1Ev();
extern void _ZN6S854C2D1Ev();
Name_Map name_map_S854C2[] = {
  NSPAIR(_ZN6S854C2C1Ev),
  NSPAIR(_ZN6S854C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S854C5;
extern VTBL_ENTRY _ZTI6S854C5[];
extern  VTBL_ENTRY _ZTV6S854C5[];
extern Class_Descriptor cd_S854C6;
extern VTBL_ENTRY _ZTI6S854C6[];
extern  VTBL_ENTRY _ZTV6S854C6[];
extern Class_Descriptor cd_S854C4;
extern VTBL_ENTRY _ZTI6S854C4[];
extern  VTBL_ENTRY _ZTV6S854C4[];
extern Class_Descriptor cd_S854C3;
extern VTBL_ENTRY _ZTI6S854C3[];
extern  VTBL_ENTRY _ZTV6S854C3[];
extern Class_Descriptor cd_S854C10;
extern VTBL_ENTRY _ZTI7S854C10[];
extern  VTBL_ENTRY _ZTV7S854C10[];
static Base_Class bases_S854C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S854C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S854C6,    ABISELECT(8,4), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S854C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S854C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S854C10,    ABISELECT(80,60), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S854C2[];
extern void _ZN6S854C2D1Ev();
extern void _ZN6S854C2D0Ev();
extern void _ZN6S854C53v12Ev();
extern void _ZN6S854C53v13Ev();
extern void _ZN6S854C53v14Ev();
extern void _ZN6S854C43v16Ev();
extern void _ZN6S854C43v17Ev();
extern void _ZN6S854C43v18Ev();
extern void _ZN6S854C43v19Ev();
extern void _ZN6S854C43v20Ev();
extern void _ZN6S854C43v21Ev();
extern void _ZN6S854C43v22Ev();
extern void _ZN6S854C43v23Ev();
extern void _ZN6S854C43v24Ev();
extern void _ZN6S854C43v25Ev();
extern void _ZN6S854C43v26Ev();
extern void _ZN6S854C43v27Ev();
extern void _ZN6S854C43v28Ev();
extern void _ZN6S854C43v29Ev();
extern void _ZN6S854C43v30Ev();
extern void _ZN6S854C43v31Ev();
extern void _ZN6S854C43v32Ev();
extern void _ZN6S854C43v33Ev();
extern void _ZN6S854C43v34Ev();
extern void _ZN6S854C43v35Ev();
extern void _ZN6S854C43v36Ev();
extern void _ZN6S854C43v37Ev();
extern void _ZN6S854C33v38Ev();
extern void _ZN6S854C33v39Ev();
extern void _ZN6S854C33v40Ev();
extern void _ZN6S854C23v42Ev();
extern void _ZN6S854C23v43Ev();
extern void _ZN6S854C23v44Ev();
extern void _ZN6S854C23v45Ev();
extern void _ZN6S854C23v46Ev();
extern void _ZN6S854C23v47Ev();
extern void _ZN6S854C23v48Ev();
extern void _ZN6S854C23v49Ev();
extern void _ZN6S854C23v50Ev();
extern void _ZN6S854C23v51Ev();
extern void _ZN6S854C23v52Ev();
extern void _ZN6S854C23v53Ev();
extern void _ZN6S854C23v54Ev();
extern void _ZN6S854C23v55Ev();
extern void _ZN6S854C23v56Ev();
extern void _ZN6S854C23v57Ev();
extern void _ZN6S854C23v58Ev();
extern void _ZN6S854C23v59Ev();
extern void _ZN6S854C23v60Ev();
extern void _ZN6S854C23v61Ev();
extern void _ZN6S854C23v62Ev();
extern void _ZN6S854C23v63Ev();
extern void _ZN6S854C23v64Ev();
extern void _ZN6S854C23v65Ev();
extern void _ZN6S854C23v66Ev();
extern void _ZN6S854C23v67Ev();
extern void _ZN6S854C23v68Ev();
extern void _ZN6S854C23v69Ev();
extern void _ZN6S854C23v70Ev();
extern void _ZN6S854C23v71Ev();
extern void _ZN6S854C23v72Ev();
extern void _ZN6S854C23v73Ev();
extern void _ZN6S854C23v74Ev();
extern void _ZN6S854C23v75Ev();
extern void _ZN6S854C23v76Ev();
extern void _ZN6S854C23v77Ev();
extern void _ZN6S854C23v78Ev();
extern void _ZN6S854C23v79Ev();
extern void _ZN6S854C23v80Ev();
extern void _ZN6S854C23v81Ev();
extern void _ZN6S854C23v82Ev();
extern void ABISELECT(_ZThn8_N6S854C2D1Ev,_ZThn4_N6S854C2D1Ev)();
extern void ABISELECT(_ZThn8_N6S854C2D0Ev,_ZThn4_N6S854C2D0Ev)();
extern void _ZN6S854C63v15Ev();
extern void ABISELECT(_ZThn80_N6S854C2D1Ev,_ZThn60_N6S854C2D1Ev)();
extern void ABISELECT(_ZThn80_N6S854C2D0Ev,_ZThn60_N6S854C2D0Ev)();
extern void _ZN7S854C103v41Ev();
static  VTBL_ENTRY vtc_S854C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S854C2[0]),
  (VTBL_ENTRY)&_ZN6S854C2D1Ev,
  (VTBL_ENTRY)&_ZN6S854C2D0Ev,
  (VTBL_ENTRY)&_ZN6S854C53v12Ev,
  (VTBL_ENTRY)&_ZN6S854C53v13Ev,
  (VTBL_ENTRY)&_ZN6S854C53v14Ev,
  (VTBL_ENTRY)&_ZN6S854C43v16Ev,
  (VTBL_ENTRY)&_ZN6S854C43v17Ev,
  (VTBL_ENTRY)&_ZN6S854C43v18Ev,
  (VTBL_ENTRY)&_ZN6S854C43v19Ev,
  (VTBL_ENTRY)&_ZN6S854C43v20Ev,
  (VTBL_ENTRY)&_ZN6S854C43v21Ev,
  (VTBL_ENTRY)&_ZN6S854C43v22Ev,
  (VTBL_ENTRY)&_ZN6S854C43v23Ev,
  (VTBL_ENTRY)&_ZN6S854C43v24Ev,
  (VTBL_ENTRY)&_ZN6S854C43v25Ev,
  (VTBL_ENTRY)&_ZN6S854C43v26Ev,
  (VTBL_ENTRY)&_ZN6S854C43v27Ev,
  (VTBL_ENTRY)&_ZN6S854C43v28Ev,
  (VTBL_ENTRY)&_ZN6S854C43v29Ev,
  (VTBL_ENTRY)&_ZN6S854C43v30Ev,
  (VTBL_ENTRY)&_ZN6S854C43v31Ev,
  (VTBL_ENTRY)&_ZN6S854C43v32Ev,
  (VTBL_ENTRY)&_ZN6S854C43v33Ev,
  (VTBL_ENTRY)&_ZN6S854C43v34Ev,
  (VTBL_ENTRY)&_ZN6S854C43v35Ev,
  (VTBL_ENTRY)&_ZN6S854C43v36Ev,
  (VTBL_ENTRY)&_ZN6S854C43v37Ev,
  (VTBL_ENTRY)&_ZN6S854C33v38Ev,
  (VTBL_ENTRY)&_ZN6S854C33v39Ev,
  (VTBL_ENTRY)&_ZN6S854C33v40Ev,
  (VTBL_ENTRY)&_ZN6S854C23v42Ev,
  (VTBL_ENTRY)&_ZN6S854C23v43Ev,
  (VTBL_ENTRY)&_ZN6S854C23v44Ev,
  (VTBL_ENTRY)&_ZN6S854C23v45Ev,
  (VTBL_ENTRY)&_ZN6S854C23v46Ev,
  (VTBL_ENTRY)&_ZN6S854C23v47Ev,
  (VTBL_ENTRY)&_ZN6S854C23v48Ev,
  (VTBL_ENTRY)&_ZN6S854C23v49Ev,
  (VTBL_ENTRY)&_ZN6S854C23v50Ev,
  (VTBL_ENTRY)&_ZN6S854C23v51Ev,
  (VTBL_ENTRY)&_ZN6S854C23v52Ev,
  (VTBL_ENTRY)&_ZN6S854C23v53Ev,
  (VTBL_ENTRY)&_ZN6S854C23v54Ev,
  (VTBL_ENTRY)&_ZN6S854C23v55Ev,
  (VTBL_ENTRY)&_ZN6S854C23v56Ev,
  (VTBL_ENTRY)&_ZN6S854C23v57Ev,
  (VTBL_ENTRY)&_ZN6S854C23v58Ev,
  (VTBL_ENTRY)&_ZN6S854C23v59Ev,
  (VTBL_ENTRY)&_ZN6S854C23v60Ev,
  (VTBL_ENTRY)&_ZN6S854C23v61Ev,
  (VTBL_ENTRY)&_ZN6S854C23v62Ev,
  (VTBL_ENTRY)&_ZN6S854C23v63Ev,
  (VTBL_ENTRY)&_ZN6S854C23v64Ev,
  (VTBL_ENTRY)&_ZN6S854C23v65Ev,
  (VTBL_ENTRY)&_ZN6S854C23v66Ev,
  (VTBL_ENTRY)&_ZN6S854C23v67Ev,
  (VTBL_ENTRY)&_ZN6S854C23v68Ev,
  (VTBL_ENTRY)&_ZN6S854C23v69Ev,
  (VTBL_ENTRY)&_ZN6S854C23v70Ev,
  (VTBL_ENTRY)&_ZN6S854C23v71Ev,
  (VTBL_ENTRY)&_ZN6S854C23v72Ev,
  (VTBL_ENTRY)&_ZN6S854C23v73Ev,
  (VTBL_ENTRY)&_ZN6S854C23v74Ev,
  (VTBL_ENTRY)&_ZN6S854C23v75Ev,
  (VTBL_ENTRY)&_ZN6S854C23v76Ev,
  (VTBL_ENTRY)&_ZN6S854C23v77Ev,
  (VTBL_ENTRY)&_ZN6S854C23v78Ev,
  (VTBL_ENTRY)&_ZN6S854C23v79Ev,
  (VTBL_ENTRY)&_ZN6S854C23v80Ev,
  (VTBL_ENTRY)&_ZN6S854C23v81Ev,
  (VTBL_ENTRY)&_ZN6S854C23v82Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S854C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C2D1Ev,_ZThn4_N6S854C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C2D0Ev,_ZThn4_N6S854C2D0Ev),
  (VTBL_ENTRY)&_ZN6S854C63v15Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S854C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S854C2D1Ev,_ZThn60_N6S854C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S854C2D0Ev,_ZThn60_N6S854C2D0Ev),
  (VTBL_ENTRY)&_ZN7S854C103v41Ev,
};
extern VTBL_ENTRY _ZTI6S854C2[];
extern  VTBL_ENTRY _ZTV6S854C2[];
Class_Descriptor cd_S854C2 = {  "S854C2", // class name
  bases_S854C2, 5,
  &(vtc_S854C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S854C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S854C2),83, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S854C1  : S854C2 {
  virtual  ~S854C1(); // _ZN6S854C1D1Ev
  virtual void  v1(); // _ZN6S854C12v1Ev
  virtual void  v2(); // _ZN6S854C12v2Ev
  virtual void  v3(); // _ZN6S854C12v3Ev
  virtual void  v4(); // _ZN6S854C12v4Ev
  virtual void  v5(); // _ZN6S854C12v5Ev
  virtual void  v6(); // _ZN6S854C12v6Ev
  virtual void  v7(); // _ZN6S854C12v7Ev
  virtual void  v8(); // _ZN6S854C12v8Ev
  virtual void  v9(); // _ZN6S854C12v9Ev
  virtual void  v10(); // _ZN6S854C13v10Ev
  virtual void  v11(); // _ZN6S854C13v11Ev
  S854C1(); // tgen
};
//SIG(1 S854C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14} BC6{ vd v15} vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37} vd v38 v39 v40 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v41} vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 FC11{ m FL[4]} FC12{ m Fp FC11 FC13{ m Fp FC14{ Fi[4]}} Fi Fc} Fc[2] Fp FC15{ BC16{ vd v85} BC17{ vd v86} vd v83 v84 Fp[2]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11}


 S854C1 ::~S854C1(){ note_dtor("S854C1", this);}
void  S854C1 ::v1(){vfunc_called(this, "_ZN6S854C12v1Ev");}
void  S854C1 ::v2(){vfunc_called(this, "_ZN6S854C12v2Ev");}
void  S854C1 ::v3(){vfunc_called(this, "_ZN6S854C12v3Ev");}
void  S854C1 ::v4(){vfunc_called(this, "_ZN6S854C12v4Ev");}
void  S854C1 ::v5(){vfunc_called(this, "_ZN6S854C12v5Ev");}
void  S854C1 ::v6(){vfunc_called(this, "_ZN6S854C12v6Ev");}
void  S854C1 ::v7(){vfunc_called(this, "_ZN6S854C12v7Ev");}
void  S854C1 ::v8(){vfunc_called(this, "_ZN6S854C12v8Ev");}
void  S854C1 ::v9(){vfunc_called(this, "_ZN6S854C12v9Ev");}
void  S854C1 ::v10(){vfunc_called(this, "_ZN6S854C13v10Ev");}
void  S854C1 ::v11(){vfunc_called(this, "_ZN6S854C13v11Ev");}
S854C1 ::S854C1(){ note_ctor("S854C1", this);} // tgen

static void Test_S854C1()
{
  extern Class_Descriptor cd_S854C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S854C1, buf);
    S854C1 *dp, &lv = *(dp=new (buf) S854C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S854C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S854C1)");
    check_base_class_offset(lv, (S854C5*)(S854C4*)(S854C3*)(S854C2*), 0, "S854C1");
    check_base_class_offset(lv, (S854C6*)(S854C4*)(S854C3*)(S854C2*), ABISELECT(8,4), "S854C1");
    check_base_class_offset(lv, (S854C4*)(S854C3*)(S854C2*), 0, "S854C1");
    check_base_class_offset(lv, (S854C3*)(S854C2*), 0, "S854C1");
    check_base_class_offset(lv, (S854C10*)(S854C2*), ABISELECT(80,60), "S854C1");
    check_base_class_offset(lv, (S854C2*), 0, "S854C1");
    test_class_info(&lv, &cd_S854C1);
    dp->~S854C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS854C1(Test_S854C1, "S854C1", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S854C1C1Ev();
extern void _ZN6S854C1D1Ev();
Name_Map name_map_S854C1[] = {
  NSPAIR(_ZN6S854C1C1Ev),
  NSPAIR(_ZN6S854C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S854C5;
extern VTBL_ENTRY _ZTI6S854C5[];
extern  VTBL_ENTRY _ZTV6S854C5[];
extern Class_Descriptor cd_S854C6;
extern VTBL_ENTRY _ZTI6S854C6[];
extern  VTBL_ENTRY _ZTV6S854C6[];
extern Class_Descriptor cd_S854C4;
extern VTBL_ENTRY _ZTI6S854C4[];
extern  VTBL_ENTRY _ZTV6S854C4[];
extern Class_Descriptor cd_S854C3;
extern VTBL_ENTRY _ZTI6S854C3[];
extern  VTBL_ENTRY _ZTV6S854C3[];
extern Class_Descriptor cd_S854C10;
extern VTBL_ENTRY _ZTI7S854C10[];
extern  VTBL_ENTRY _ZTV7S854C10[];
extern Class_Descriptor cd_S854C2;
extern VTBL_ENTRY _ZTI6S854C2[];
extern  VTBL_ENTRY _ZTV6S854C2[];
static Base_Class bases_S854C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S854C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S854C6,    ABISELECT(8,4), //bcp->offset
    84, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S854C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S854C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S854C10,    ABISELECT(80,60), //bcp->offset
    89, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S854C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S854C1[];
extern void _ZN6S854C1D1Ev();
extern void _ZN6S854C1D0Ev();
extern void _ZN6S854C53v12Ev();
extern void _ZN6S854C53v13Ev();
extern void _ZN6S854C53v14Ev();
extern void _ZN6S854C43v16Ev();
extern void _ZN6S854C43v17Ev();
extern void _ZN6S854C43v18Ev();
extern void _ZN6S854C43v19Ev();
extern void _ZN6S854C43v20Ev();
extern void _ZN6S854C43v21Ev();
extern void _ZN6S854C43v22Ev();
extern void _ZN6S854C43v23Ev();
extern void _ZN6S854C43v24Ev();
extern void _ZN6S854C43v25Ev();
extern void _ZN6S854C43v26Ev();
extern void _ZN6S854C43v27Ev();
extern void _ZN6S854C43v28Ev();
extern void _ZN6S854C43v29Ev();
extern void _ZN6S854C43v30Ev();
extern void _ZN6S854C43v31Ev();
extern void _ZN6S854C43v32Ev();
extern void _ZN6S854C43v33Ev();
extern void _ZN6S854C43v34Ev();
extern void _ZN6S854C43v35Ev();
extern void _ZN6S854C43v36Ev();
extern void _ZN6S854C43v37Ev();
extern void _ZN6S854C33v38Ev();
extern void _ZN6S854C33v39Ev();
extern void _ZN6S854C33v40Ev();
extern void _ZN6S854C23v42Ev();
extern void _ZN6S854C23v43Ev();
extern void _ZN6S854C23v44Ev();
extern void _ZN6S854C23v45Ev();
extern void _ZN6S854C23v46Ev();
extern void _ZN6S854C23v47Ev();
extern void _ZN6S854C23v48Ev();
extern void _ZN6S854C23v49Ev();
extern void _ZN6S854C23v50Ev();
extern void _ZN6S854C23v51Ev();
extern void _ZN6S854C23v52Ev();
extern void _ZN6S854C23v53Ev();
extern void _ZN6S854C23v54Ev();
extern void _ZN6S854C23v55Ev();
extern void _ZN6S854C23v56Ev();
extern void _ZN6S854C23v57Ev();
extern void _ZN6S854C23v58Ev();
extern void _ZN6S854C23v59Ev();
extern void _ZN6S854C23v60Ev();
extern void _ZN6S854C23v61Ev();
extern void _ZN6S854C23v62Ev();
extern void _ZN6S854C23v63Ev();
extern void _ZN6S854C23v64Ev();
extern void _ZN6S854C23v65Ev();
extern void _ZN6S854C23v66Ev();
extern void _ZN6S854C23v67Ev();
extern void _ZN6S854C23v68Ev();
extern void _ZN6S854C23v69Ev();
extern void _ZN6S854C23v70Ev();
extern void _ZN6S854C23v71Ev();
extern void _ZN6S854C23v72Ev();
extern void _ZN6S854C23v73Ev();
extern void _ZN6S854C23v74Ev();
extern void _ZN6S854C23v75Ev();
extern void _ZN6S854C23v76Ev();
extern void _ZN6S854C23v77Ev();
extern void _ZN6S854C23v78Ev();
extern void _ZN6S854C23v79Ev();
extern void _ZN6S854C23v80Ev();
extern void _ZN6S854C23v81Ev();
extern void _ZN6S854C23v82Ev();
extern void _ZN6S854C12v1Ev();
extern void _ZN6S854C12v2Ev();
extern void _ZN6S854C12v3Ev();
extern void _ZN6S854C12v4Ev();
extern void _ZN6S854C12v5Ev();
extern void _ZN6S854C12v6Ev();
extern void _ZN6S854C12v7Ev();
extern void _ZN6S854C12v8Ev();
extern void _ZN6S854C12v9Ev();
extern void _ZN6S854C13v10Ev();
extern void _ZN6S854C13v11Ev();
extern void ABISELECT(_ZThn8_N6S854C1D1Ev,_ZThn4_N6S854C1D1Ev)();
extern void ABISELECT(_ZThn8_N6S854C1D0Ev,_ZThn4_N6S854C1D0Ev)();
extern void _ZN6S854C63v15Ev();
extern void ABISELECT(_ZThn80_N6S854C1D1Ev,_ZThn60_N6S854C1D1Ev)();
extern void ABISELECT(_ZThn80_N6S854C1D0Ev,_ZThn60_N6S854C1D0Ev)();
extern void _ZN7S854C103v41Ev();
static  VTBL_ENTRY vtc_S854C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S854C1[0]),
  (VTBL_ENTRY)&_ZN6S854C1D1Ev,
  (VTBL_ENTRY)&_ZN6S854C1D0Ev,
  (VTBL_ENTRY)&_ZN6S854C53v12Ev,
  (VTBL_ENTRY)&_ZN6S854C53v13Ev,
  (VTBL_ENTRY)&_ZN6S854C53v14Ev,
  (VTBL_ENTRY)&_ZN6S854C43v16Ev,
  (VTBL_ENTRY)&_ZN6S854C43v17Ev,
  (VTBL_ENTRY)&_ZN6S854C43v18Ev,
  (VTBL_ENTRY)&_ZN6S854C43v19Ev,
  (VTBL_ENTRY)&_ZN6S854C43v20Ev,
  (VTBL_ENTRY)&_ZN6S854C43v21Ev,
  (VTBL_ENTRY)&_ZN6S854C43v22Ev,
  (VTBL_ENTRY)&_ZN6S854C43v23Ev,
  (VTBL_ENTRY)&_ZN6S854C43v24Ev,
  (VTBL_ENTRY)&_ZN6S854C43v25Ev,
  (VTBL_ENTRY)&_ZN6S854C43v26Ev,
  (VTBL_ENTRY)&_ZN6S854C43v27Ev,
  (VTBL_ENTRY)&_ZN6S854C43v28Ev,
  (VTBL_ENTRY)&_ZN6S854C43v29Ev,
  (VTBL_ENTRY)&_ZN6S854C43v30Ev,
  (VTBL_ENTRY)&_ZN6S854C43v31Ev,
  (VTBL_ENTRY)&_ZN6S854C43v32Ev,
  (VTBL_ENTRY)&_ZN6S854C43v33Ev,
  (VTBL_ENTRY)&_ZN6S854C43v34Ev,
  (VTBL_ENTRY)&_ZN6S854C43v35Ev,
  (VTBL_ENTRY)&_ZN6S854C43v36Ev,
  (VTBL_ENTRY)&_ZN6S854C43v37Ev,
  (VTBL_ENTRY)&_ZN6S854C33v38Ev,
  (VTBL_ENTRY)&_ZN6S854C33v39Ev,
  (VTBL_ENTRY)&_ZN6S854C33v40Ev,
  (VTBL_ENTRY)&_ZN6S854C23v42Ev,
  (VTBL_ENTRY)&_ZN6S854C23v43Ev,
  (VTBL_ENTRY)&_ZN6S854C23v44Ev,
  (VTBL_ENTRY)&_ZN6S854C23v45Ev,
  (VTBL_ENTRY)&_ZN6S854C23v46Ev,
  (VTBL_ENTRY)&_ZN6S854C23v47Ev,
  (VTBL_ENTRY)&_ZN6S854C23v48Ev,
  (VTBL_ENTRY)&_ZN6S854C23v49Ev,
  (VTBL_ENTRY)&_ZN6S854C23v50Ev,
  (VTBL_ENTRY)&_ZN6S854C23v51Ev,
  (VTBL_ENTRY)&_ZN6S854C23v52Ev,
  (VTBL_ENTRY)&_ZN6S854C23v53Ev,
  (VTBL_ENTRY)&_ZN6S854C23v54Ev,
  (VTBL_ENTRY)&_ZN6S854C23v55Ev,
  (VTBL_ENTRY)&_ZN6S854C23v56Ev,
  (VTBL_ENTRY)&_ZN6S854C23v57Ev,
  (VTBL_ENTRY)&_ZN6S854C23v58Ev,
  (VTBL_ENTRY)&_ZN6S854C23v59Ev,
  (VTBL_ENTRY)&_ZN6S854C23v60Ev,
  (VTBL_ENTRY)&_ZN6S854C23v61Ev,
  (VTBL_ENTRY)&_ZN6S854C23v62Ev,
  (VTBL_ENTRY)&_ZN6S854C23v63Ev,
  (VTBL_ENTRY)&_ZN6S854C23v64Ev,
  (VTBL_ENTRY)&_ZN6S854C23v65Ev,
  (VTBL_ENTRY)&_ZN6S854C23v66Ev,
  (VTBL_ENTRY)&_ZN6S854C23v67Ev,
  (VTBL_ENTRY)&_ZN6S854C23v68Ev,
  (VTBL_ENTRY)&_ZN6S854C23v69Ev,
  (VTBL_ENTRY)&_ZN6S854C23v70Ev,
  (VTBL_ENTRY)&_ZN6S854C23v71Ev,
  (VTBL_ENTRY)&_ZN6S854C23v72Ev,
  (VTBL_ENTRY)&_ZN6S854C23v73Ev,
  (VTBL_ENTRY)&_ZN6S854C23v74Ev,
  (VTBL_ENTRY)&_ZN6S854C23v75Ev,
  (VTBL_ENTRY)&_ZN6S854C23v76Ev,
  (VTBL_ENTRY)&_ZN6S854C23v77Ev,
  (VTBL_ENTRY)&_ZN6S854C23v78Ev,
  (VTBL_ENTRY)&_ZN6S854C23v79Ev,
  (VTBL_ENTRY)&_ZN6S854C23v80Ev,
  (VTBL_ENTRY)&_ZN6S854C23v81Ev,
  (VTBL_ENTRY)&_ZN6S854C23v82Ev,
  (VTBL_ENTRY)&_ZN6S854C12v1Ev,
  (VTBL_ENTRY)&_ZN6S854C12v2Ev,
  (VTBL_ENTRY)&_ZN6S854C12v3Ev,
  (VTBL_ENTRY)&_ZN6S854C12v4Ev,
  (VTBL_ENTRY)&_ZN6S854C12v5Ev,
  (VTBL_ENTRY)&_ZN6S854C12v6Ev,
  (VTBL_ENTRY)&_ZN6S854C12v7Ev,
  (VTBL_ENTRY)&_ZN6S854C12v8Ev,
  (VTBL_ENTRY)&_ZN6S854C12v9Ev,
  (VTBL_ENTRY)&_ZN6S854C13v10Ev,
  (VTBL_ENTRY)&_ZN6S854C13v11Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S854C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C1D1Ev,_ZThn4_N6S854C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S854C1D0Ev,_ZThn4_N6S854C1D0Ev),
  (VTBL_ENTRY)&_ZN6S854C63v15Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S854C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S854C1D1Ev,_ZThn60_N6S854C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S854C1D0Ev,_ZThn60_N6S854C1D0Ev),
  (VTBL_ENTRY)&_ZN7S854C103v41Ev,
};
extern VTBL_ENTRY _ZTI6S854C1[];
extern  VTBL_ENTRY _ZTV6S854C1[];
Class_Descriptor cd_S854C1 = {  "S854C1", // class name
  bases_S854C1, 6,
  &(vtc_S854C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S854C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S854C1),94, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S849C5  {
  virtual  ~S849C5(); // _ZN6S849C5D1Ev
  virtual void  v11(); // _ZN6S849C53v11Ev
  virtual void  v12(); // _ZN6S849C53v12Ev
  virtual void  v13(); // _ZN6S849C53v13Ev
  S849C5(); // tgen
};
//SIG(-1 S849C5) C1{ vd v1 v2 v3}


 S849C5 ::~S849C5(){ note_dtor("S849C5", this);}
void  S849C5 ::v11(){vfunc_called(this, "_ZN6S849C53v11Ev");}
void  S849C5 ::v12(){vfunc_called(this, "_ZN6S849C53v12Ev");}
void  S849C5 ::v13(){vfunc_called(this, "_ZN6S849C53v13Ev");}
S849C5 ::S849C5(){ note_ctor("S849C5", this);} // tgen

static void Test_S849C5()
{
  extern Class_Descriptor cd_S849C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S849C5, buf);
    S849C5 *dp, &lv = *(dp=new (buf) S849C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S849C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S849C5)");
    test_class_info(&lv, &cd_S849C5);
    dp->~S849C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS849C5(Test_S849C5, "S849C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S849C5C1Ev();
extern void _ZN6S849C5D1Ev();
Name_Map name_map_S849C5[] = {
  NSPAIR(_ZN6S849C5C1Ev),
  NSPAIR(_ZN6S849C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S849C5[];
extern void _ZN6S849C5D1Ev();
extern void _ZN6S849C5D0Ev();
extern void _ZN6S849C53v11Ev();
extern void _ZN6S849C53v12Ev();
extern void _ZN6S849C53v13Ev();
static  VTBL_ENTRY vtc_S849C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S849C5[0]),
  (VTBL_ENTRY)&_ZN6S849C5D1Ev,
  (VTBL_ENTRY)&_ZN6S849C5D0Ev,
  (VTBL_ENTRY)&_ZN6S849C53v11Ev,
  (VTBL_ENTRY)&_ZN6S849C53v12Ev,
  (VTBL_ENTRY)&_ZN6S849C53v13Ev,
};
extern VTBL_ENTRY _ZTI6S849C5[];
extern  VTBL_ENTRY _ZTV6S849C5[];
Class_Descriptor cd_S849C5 = {  "S849C5", // class name
  0,0,//no base classes
  &(vtc_S849C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S849C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S849C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S849C6  {
  virtual  ~S849C6(); // _ZN6S849C6D1Ev
  virtual void  v14(); // _ZN6S849C63v14Ev
  S849C6(); // tgen
};
//SIG(-1 S849C6) C1{ vd v1}


 S849C6 ::~S849C6(){ note_dtor("S849C6", this);}
void  S849C6 ::v14(){vfunc_called(this, "_ZN6S849C63v14Ev");}
S849C6 ::S849C6(){ note_ctor("S849C6", this);} // tgen

static void Test_S849C6()
{
  extern Class_Descriptor cd_S849C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S849C6, buf);
    S849C6 *dp, &lv = *(dp=new (buf) S849C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S849C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S849C6)");
    test_class_info(&lv, &cd_S849C6);
    dp->~S849C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS849C6(Test_S849C6, "S849C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S849C6C1Ev();
extern void _ZN6S849C6D1Ev();
Name_Map name_map_S849C6[] = {
  NSPAIR(_ZN6S849C6C1Ev),
  NSPAIR(_ZN6S849C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S849C6[];
extern void _ZN6S849C6D1Ev();
extern void _ZN6S849C6D0Ev();
extern void _ZN6S849C63v14Ev();
static  VTBL_ENTRY vtc_S849C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S849C6[0]),
  (VTBL_ENTRY)&_ZN6S849C6D1Ev,
  (VTBL_ENTRY)&_ZN6S849C6D0Ev,
  (VTBL_ENTRY)&_ZN6S849C63v14Ev,
};
extern VTBL_ENTRY _ZTI6S849C6[];
extern  VTBL_ENTRY _ZTV6S849C6[];
Class_Descriptor cd_S849C6 = {  "S849C6", // class name
  0,0,//no base classes
  &(vtc_S849C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S849C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S849C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S849C4  : S849C5 , S849C6 {
  virtual  ~S849C4(); // _ZN6S849C4D1Ev
  virtual void  v15(); // _ZN6S849C43v15Ev
  virtual void  v16(); // _ZN6S849C43v16Ev
  virtual void  v17(); // _ZN6S849C43v17Ev
  virtual void  v18(); // _ZN6S849C43v18Ev
  virtual void  v19(); // _ZN6S849C43v19Ev
  virtual void  v20(); // _ZN6S849C43v20Ev
  virtual void  v21(); // _ZN6S849C43v21Ev
  virtual void  v22(); // _ZN6S849C43v22Ev
  virtual void  v23(); // _ZN6S849C43v23Ev
  virtual void  v24(); // _ZN6S849C43v24Ev
  virtual void  v25(); // _ZN6S849C43v25Ev
  virtual void  v26(); // _ZN6S849C43v26Ev
  virtual void  v27(); // _ZN6S849C43v27Ev
  virtual void  v28(); // _ZN6S849C43v28Ev
  virtual void  v29(); // _ZN6S849C43v29Ev
  virtual void  v30(); // _ZN6S849C43v30Ev
  virtual void  v31(); // _ZN6S849C43v31Ev
  virtual void  v32(); // _ZN6S849C43v32Ev
  virtual void  v33(); // _ZN6S849C43v33Ev
  virtual void  v34(); // _ZN6S849C43v34Ev
  virtual void  v35(); // _ZN6S849C43v35Ev
  virtual void  v36(); // _ZN6S849C43v36Ev
  S849C4(); // tgen
};
//SIG(-1 S849C4) C1{ BC2{ vd v23 v24 v25} BC3{ vd v26} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22}


 S849C4 ::~S849C4(){ note_dtor("S849C4", this);}
void  S849C4 ::v15(){vfunc_called(this, "_ZN6S849C43v15Ev");}
void  S849C4 ::v16(){vfunc_called(this, "_ZN6S849C43v16Ev");}
void  S849C4 ::v17(){vfunc_called(this, "_ZN6S849C43v17Ev");}
void  S849C4 ::v18(){vfunc_called(this, "_ZN6S849C43v18Ev");}
void  S849C4 ::v19(){vfunc_called(this, "_ZN6S849C43v19Ev");}
void  S849C4 ::v20(){vfunc_called(this, "_ZN6S849C43v20Ev");}
void  S849C4 ::v21(){vfunc_called(this, "_ZN6S849C43v21Ev");}
void  S849C4 ::v22(){vfunc_called(this, "_ZN6S849C43v22Ev");}
void  S849C4 ::v23(){vfunc_called(this, "_ZN6S849C43v23Ev");}
void  S849C4 ::v24(){vfunc_called(this, "_ZN6S849C43v24Ev");}
void  S849C4 ::v25(){vfunc_called(this, "_ZN6S849C43v25Ev");}
void  S849C4 ::v26(){vfunc_called(this, "_ZN6S849C43v26Ev");}
void  S849C4 ::v27(){vfunc_called(this, "_ZN6S849C43v27Ev");}
void  S849C4 ::v28(){vfunc_called(this, "_ZN6S849C43v28Ev");}
void  S849C4 ::v29(){vfunc_called(this, "_ZN6S849C43v29Ev");}
void  S849C4 ::v30(){vfunc_called(this, "_ZN6S849C43v30Ev");}
void  S849C4 ::v31(){vfunc_called(this, "_ZN6S849C43v31Ev");}
void  S849C4 ::v32(){vfunc_called(this, "_ZN6S849C43v32Ev");}
void  S849C4 ::v33(){vfunc_called(this, "_ZN6S849C43v33Ev");}
void  S849C4 ::v34(){vfunc_called(this, "_ZN6S849C43v34Ev");}
void  S849C4 ::v35(){vfunc_called(this, "_ZN6S849C43v35Ev");}
void  S849C4 ::v36(){vfunc_called(this, "_ZN6S849C43v36Ev");}
S849C4 ::S849C4(){ note_ctor("S849C4", this);} // tgen

static void Test_S849C4()
{
  extern Class_Descriptor cd_S849C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S849C4, buf);
    S849C4 *dp, &lv = *(dp=new (buf) S849C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S849C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S849C4)");
    check_base_class_offset(lv, (S849C5*), 0, "S849C4");
    check_base_class_offset(lv, (S849C6*), ABISELECT(8,4), "S849C4");
    test_class_info(&lv, &cd_S849C4);
    dp->~S849C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS849C4(Test_S849C4, "S849C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN6S849C4C1Ev();
extern void _ZN6S849C4D1Ev();
Name_Map name_map_S849C4[] = {
  NSPAIR(_ZN6S849C4C1Ev),
  NSPAIR(_ZN6S849C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S849C5;
extern VTBL_ENTRY _ZTI6S849C5[];
extern  VTBL_ENTRY _ZTV6S849C5[];
extern Class_Descriptor cd_S849C6;
extern VTBL_ENTRY _ZTI6S849C6[];
extern  VTBL_ENTRY _ZTV6S849C6[];
static Base_Class bases_S849C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S849C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S849C6,    ABISELECT(8,4), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S849C4[];
extern void _ZN6S849C4D1Ev();
extern void _ZN6S849C4D0Ev();
extern void _ZN6S849C53v11Ev();
extern void _ZN6S849C53v12Ev();
extern void _ZN6S849C53v13Ev();
extern void _ZN6S849C43v15Ev();
extern void _ZN6S849C43v16Ev();
extern void _ZN6S849C43v17Ev();
extern void _ZN6S849C43v18Ev();
extern void _ZN6S849C43v19Ev();
extern void _ZN6S849C43v20Ev();
extern void _ZN6S849C43v21Ev();
extern void _ZN6S849C43v22Ev();
extern void _ZN6S849C43v23Ev();
extern void _ZN6S849C43v24Ev();
extern void _ZN6S849C43v25Ev();
extern void _ZN6S849C43v26Ev();
extern void _ZN6S849C43v27Ev();
extern void _ZN6S849C43v28Ev();
extern void _ZN6S849C43v29Ev();
extern void _ZN6S849C43v30Ev();
extern void _ZN6S849C43v31Ev();
extern void _ZN6S849C43v32Ev();
extern void _ZN6S849C43v33Ev();
extern void _ZN6S849C43v34Ev();
extern void _ZN6S849C43v35Ev();
extern void _ZN6S849C43v36Ev();
extern void ABISELECT(_ZThn8_N6S849C4D1Ev,_ZThn4_N6S849C4D1Ev)();
extern void ABISELECT(_ZThn8_N6S849C4D0Ev,_ZThn4_N6S849C4D0Ev)();
extern void _ZN6S849C63v14Ev();
static  VTBL_ENTRY vtc_S849C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S849C4[0]),
  (VTBL_ENTRY)&_ZN6S849C4D1Ev,
  (VTBL_ENTRY)&_ZN6S849C4D0Ev,
  (VTBL_ENTRY)&_ZN6S849C53v11Ev,
  (VTBL_ENTRY)&_ZN6S849C53v12Ev,
  (VTBL_ENTRY)&_ZN6S849C53v13Ev,
  (VTBL_ENTRY)&_ZN6S849C43v15Ev,
  (VTBL_ENTRY)&_ZN6S849C43v16Ev,
  (VTBL_ENTRY)&_ZN6S849C43v17Ev,
  (VTBL_ENTRY)&_ZN6S849C43v18Ev,
  (VTBL_ENTRY)&_ZN6S849C43v19Ev,
  (VTBL_ENTRY)&_ZN6S849C43v20Ev,
  (VTBL_ENTRY)&_ZN6S849C43v21Ev,
  (VTBL_ENTRY)&_ZN6S849C43v22Ev,
  (VTBL_ENTRY)&_ZN6S849C43v23Ev,
  (VTBL_ENTRY)&_ZN6S849C43v24Ev,
  (VTBL_ENTRY)&_ZN6S849C43v25Ev,
  (VTBL_ENTRY)&_ZN6S849C43v26Ev,
  (VTBL_ENTRY)&_ZN6S849C43v27Ev,
  (VTBL_ENTRY)&_ZN6S849C43v28Ev,
  (VTBL_ENTRY)&_ZN6S849C43v29Ev,
  (VTBL_ENTRY)&_ZN6S849C43v30Ev,
  (VTBL_ENTRY)&_ZN6S849C43v31Ev,
  (VTBL_ENTRY)&_ZN6S849C43v32Ev,
  (VTBL_ENTRY)&_ZN6S849C43v33Ev,
  (VTBL_ENTRY)&_ZN6S849C43v34Ev,
  (VTBL_ENTRY)&_ZN6S849C43v35Ev,
  (VTBL_ENTRY)&_ZN6S849C43v36Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S849C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C4D1Ev,_ZThn4_N6S849C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C4D0Ev,_ZThn4_N6S849C4D0Ev),
  (VTBL_ENTRY)&_ZN6S849C63v14Ev,
};
extern VTBL_ENTRY _ZTI6S849C4[];
extern  VTBL_ENTRY _ZTV6S849C4[];
Class_Descriptor cd_S849C4 = {  "S849C4", // class name
  bases_S849C4, 2,
  &(vtc_S849C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI6S849C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S849C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S849C3  : S849C4 {
  ::S858C7_nt s849c3f0;
  ::S9124C5_nt s849c3f1;
  char s849c3f2;
  virtual  ~S849C3(); // _ZN6S849C3D1Ev
  virtual void  v37(); // _ZN6S849C33v37Ev
  virtual void  v38(); // _ZN6S849C33v38Ev
  virtual void  v39(); // _ZN6S849C33v39Ev
  S849C3(); // tgen
};
//SIG(-1 S849C3) C1{ BC2{ BC3{ vd v4 v5 v6} BC4{ vd v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29} vd v1 v2 v3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc}


 S849C3 ::~S849C3(){ note_dtor("S849C3", this);}
void  S849C3 ::v37(){vfunc_called(this, "_ZN6S849C33v37Ev");}
void  S849C3 ::v38(){vfunc_called(this, "_ZN6S849C33v38Ev");}
void  S849C3 ::v39(){vfunc_called(this, "_ZN6S849C33v39Ev");}
S849C3 ::S849C3(){ note_ctor("S849C3", this);} // tgen

static void Test_S849C3()
{
  extern Class_Descriptor cd_S849C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S849C3, buf);
    S849C3 *dp, &lv = *(dp=new (buf) S849C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S849C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S849C3)");
    check_base_class_offset(lv, (S849C5*)(S849C4*), 0, "S849C3");
    check_base_class_offset(lv, (S849C6*)(S849C4*), ABISELECT(8,4), "S849C3");
    check_base_class_offset(lv, (S849C4*), 0, "S849C3");
    check_field_offset(lv, s849c3f0, ABISELECT(16,8), "S849C3.s849c3f0");
    check_field_offset(lv, s849c3f1, ABISELECT(40,24), "S849C3.s849c3f1");
    check_field_offset(lv, s849c3f2, ABISELECT(72,56), "S849C3.s849c3f2");
    test_class_info(&lv, &cd_S849C3);
    dp->~S849C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS849C3(Test_S849C3, "S849C3", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN6S849C3C1Ev();
extern void _ZN6S849C3D1Ev();
Name_Map name_map_S849C3[] = {
  NSPAIR(_ZN6S849C3C1Ev),
  NSPAIR(_ZN6S849C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S849C5;
extern VTBL_ENTRY _ZTI6S849C5[];
extern  VTBL_ENTRY _ZTV6S849C5[];
extern Class_Descriptor cd_S849C6;
extern VTBL_ENTRY _ZTI6S849C6[];
extern  VTBL_ENTRY _ZTV6S849C6[];
extern Class_Descriptor cd_S849C4;
extern VTBL_ENTRY _ZTI6S849C4[];
extern  VTBL_ENTRY _ZTV6S849C4[];
static Base_Class bases_S849C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S849C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S849C6,    ABISELECT(8,4), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S849C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S849C3[];
extern void _ZN6S849C3D1Ev();
extern void _ZN6S849C3D0Ev();
extern void _ZN6S849C53v11Ev();
extern void _ZN6S849C53v12Ev();
extern void _ZN6S849C53v13Ev();
extern void _ZN6S849C43v15Ev();
extern void _ZN6S849C43v16Ev();
extern void _ZN6S849C43v17Ev();
extern void _ZN6S849C43v18Ev();
extern void _ZN6S849C43v19Ev();
extern void _ZN6S849C43v20Ev();
extern void _ZN6S849C43v21Ev();
extern void _ZN6S849C43v22Ev();
extern void _ZN6S849C43v23Ev();
extern void _ZN6S849C43v24Ev();
extern void _ZN6S849C43v25Ev();
extern void _ZN6S849C43v26Ev();
extern void _ZN6S849C43v27Ev();
extern void _ZN6S849C43v28Ev();
extern void _ZN6S849C43v29Ev();
extern void _ZN6S849C43v30Ev();
extern void _ZN6S849C43v31Ev();
extern void _ZN6S849C43v32Ev();
extern void _ZN6S849C43v33Ev();
extern void _ZN6S849C43v34Ev();
extern void _ZN6S849C43v35Ev();
extern void _ZN6S849C43v36Ev();
extern void _ZN6S849C33v37Ev();
extern void _ZN6S849C33v38Ev();
extern void _ZN6S849C33v39Ev();
extern void ABISELECT(_ZThn8_N6S849C3D1Ev,_ZThn4_N6S849C3D1Ev)();
extern void ABISELECT(_ZThn8_N6S849C3D0Ev,_ZThn4_N6S849C3D0Ev)();
extern void _ZN6S849C63v14Ev();
static  VTBL_ENTRY vtc_S849C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S849C3[0]),
  (VTBL_ENTRY)&_ZN6S849C3D1Ev,
  (VTBL_ENTRY)&_ZN6S849C3D0Ev,
  (VTBL_ENTRY)&_ZN6S849C53v11Ev,
  (VTBL_ENTRY)&_ZN6S849C53v12Ev,
  (VTBL_ENTRY)&_ZN6S849C53v13Ev,
  (VTBL_ENTRY)&_ZN6S849C43v15Ev,
  (VTBL_ENTRY)&_ZN6S849C43v16Ev,
  (VTBL_ENTRY)&_ZN6S849C43v17Ev,
  (VTBL_ENTRY)&_ZN6S849C43v18Ev,
  (VTBL_ENTRY)&_ZN6S849C43v19Ev,
  (VTBL_ENTRY)&_ZN6S849C43v20Ev,
  (VTBL_ENTRY)&_ZN6S849C43v21Ev,
  (VTBL_ENTRY)&_ZN6S849C43v22Ev,
  (VTBL_ENTRY)&_ZN6S849C43v23Ev,
  (VTBL_ENTRY)&_ZN6S849C43v24Ev,
  (VTBL_ENTRY)&_ZN6S849C43v25Ev,
  (VTBL_ENTRY)&_ZN6S849C43v26Ev,
  (VTBL_ENTRY)&_ZN6S849C43v27Ev,
  (VTBL_ENTRY)&_ZN6S849C43v28Ev,
  (VTBL_ENTRY)&_ZN6S849C43v29Ev,
  (VTBL_ENTRY)&_ZN6S849C43v30Ev,
  (VTBL_ENTRY)&_ZN6S849C43v31Ev,
  (VTBL_ENTRY)&_ZN6S849C43v32Ev,
  (VTBL_ENTRY)&_ZN6S849C43v33Ev,
  (VTBL_ENTRY)&_ZN6S849C43v34Ev,
  (VTBL_ENTRY)&_ZN6S849C43v35Ev,
  (VTBL_ENTRY)&_ZN6S849C43v36Ev,
  (VTBL_ENTRY)&_ZN6S849C33v37Ev,
  (VTBL_ENTRY)&_ZN6S849C33v38Ev,
  (VTBL_ENTRY)&_ZN6S849C33v39Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S849C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C3D1Ev,_ZThn4_N6S849C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C3D0Ev,_ZThn4_N6S849C3D0Ev),
  (VTBL_ENTRY)&_ZN6S849C63v14Ev,
};
extern VTBL_ENTRY _ZTI6S849C3[];
extern  VTBL_ENTRY _ZTV6S849C3[];
Class_Descriptor cd_S849C3 = {  "S849C3", // class name
  bases_S849C3, 3,
  &(vtc_S849C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI6S849C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S849C3),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S849C10  {
  virtual  ~S849C10(); // _ZN7S849C10D1Ev
  virtual void  v40(); // _ZN7S849C103v40Ev
  S849C10(); // tgen
};
//SIG(-1 S849C10) C1{ vd v1}


 S849C10 ::~S849C10(){ note_dtor("S849C10", this);}
void  S849C10 ::v40(){vfunc_called(this, "_ZN7S849C103v40Ev");}
S849C10 ::S849C10(){ note_ctor("S849C10", this);} // tgen

static void Test_S849C10()
{
  extern Class_Descriptor cd_S849C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S849C10, buf);
    S849C10 *dp, &lv = *(dp=new (buf) S849C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S849C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S849C10)");
    test_class_info(&lv, &cd_S849C10);
    dp->~S849C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS849C10(Test_S849C10, "S849C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S849C10C1Ev();
extern void _ZN7S849C10D1Ev();
Name_Map name_map_S849C10[] = {
  NSPAIR(_ZN7S849C10C1Ev),
  NSPAIR(_ZN7S849C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S849C10[];
extern void _ZN7S849C10D1Ev();
extern void _ZN7S849C10D0Ev();
extern void _ZN7S849C103v40Ev();
static  VTBL_ENTRY vtc_S849C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S849C10[0]),
  (VTBL_ENTRY)&_ZN7S849C10D1Ev,
  (VTBL_ENTRY)&_ZN7S849C10D0Ev,
  (VTBL_ENTRY)&_ZN7S849C103v40Ev,
};
extern VTBL_ENTRY _ZTI7S849C10[];
extern  VTBL_ENTRY _ZTV7S849C10[];
Class_Descriptor cd_S849C10 = {  "S849C10", // class name
  0,0,//no base classes
  &(vtc_S849C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S849C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S849C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S849C2  : S849C3 , S849C10 {
  ::S858C11_nt s849c2f0;
  ::S858C12_nt s849c2f1;
  char s849c2f2[2];
  void *s849c2f3;
  ::S858C15_nt s849c2f4;
  void *s849c2f5;
  virtual  ~S849C2(); // _ZN6S849C2D1Ev
  virtual void  v41(); // _ZN6S849C23v41Ev
  virtual void  v42(); // _ZN6S849C23v42Ev
  virtual void  v43(); // _ZN6S849C23v43Ev
  virtual void  v44(); // _ZN6S849C23v44Ev
  virtual void  v45(); // _ZN6S849C23v45Ev
  virtual void  v46(); // _ZN6S849C23v46Ev
  virtual void  v47(); // _ZN6S849C23v47Ev
  virtual void  v48(); // _ZN6S849C23v48Ev
  virtual void  v49(); // _ZN6S849C23v49Ev
  virtual void  v50(); // _ZN6S849C23v50Ev
  virtual void  v51(); // _ZN6S849C23v51Ev
  virtual void  v52(); // _ZN6S849C23v52Ev
  virtual void  v53(); // _ZN6S849C23v53Ev
  virtual void  v54(); // _ZN6S849C23v54Ev
  virtual void  v55(); // _ZN6S849C23v55Ev
  virtual void  v56(); // _ZN6S849C23v56Ev
  virtual void  v57(); // _ZN6S849C23v57Ev
  virtual void  v58(); // _ZN6S849C23v58Ev
  virtual void  v59(); // _ZN6S849C23v59Ev
  virtual void  v60(); // _ZN6S849C23v60Ev
  virtual void  v61(); // _ZN6S849C23v61Ev
  virtual void  v62(); // _ZN6S849C23v62Ev
  virtual void  v63(); // _ZN6S849C23v63Ev
  virtual void  v64(); // _ZN6S849C23v64Ev
  virtual void  v65(); // _ZN6S849C23v65Ev
  virtual void  v66(); // _ZN6S849C23v66Ev
  virtual void  v67(); // _ZN6S849C23v67Ev
  virtual void  v68(); // _ZN6S849C23v68Ev
  virtual void  v69(); // _ZN6S849C23v69Ev
  virtual void  v70(); // _ZN6S849C23v70Ev
  virtual void  v71(); // _ZN6S849C23v71Ev
  virtual void  v72(); // _ZN6S849C23v72Ev
  virtual void  v73(); // _ZN6S849C23v73Ev
  virtual void  v74(); // _ZN6S849C23v74Ev
  virtual void  v75(); // _ZN6S849C23v75Ev
  virtual void  v76(); // _ZN6S849C23v76Ev
  virtual void  v77(); // _ZN6S849C23v77Ev
  virtual void  v78(); // _ZN6S849C23v78Ev
  virtual void  v79(); // _ZN6S849C23v79Ev
  virtual void  v80(); // _ZN6S849C23v80Ev
  virtual void  v81(); // _ZN6S849C23v81Ev
  S849C2(); // tgen
};
//SIG(-1 S849C2) C1{ BC2{ BC3{ BC4{ vd v42 v43 v44} BC5{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FL[4]} Fc} BC9{ vd v71} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC10{ m FL[4]} FC11{ m Fp FC10 FC12{ m Fp FC13{ Fi[4]}} Fi Fc} Fc[2] Fp FC14{ BC15{ vd v74} BC16{ vd v75} vd v72 v73 Fp[2]} Fp}


 S849C2 ::~S849C2(){ note_dtor("S849C2", this);}
void  S849C2 ::v41(){vfunc_called(this, "_ZN6S849C23v41Ev");}
void  S849C2 ::v42(){vfunc_called(this, "_ZN6S849C23v42Ev");}
void  S849C2 ::v43(){vfunc_called(this, "_ZN6S849C23v43Ev");}
void  S849C2 ::v44(){vfunc_called(this, "_ZN6S849C23v44Ev");}
void  S849C2 ::v45(){vfunc_called(this, "_ZN6S849C23v45Ev");}
void  S849C2 ::v46(){vfunc_called(this, "_ZN6S849C23v46Ev");}
void  S849C2 ::v47(){vfunc_called(this, "_ZN6S849C23v47Ev");}
void  S849C2 ::v48(){vfunc_called(this, "_ZN6S849C23v48Ev");}
void  S849C2 ::v49(){vfunc_called(this, "_ZN6S849C23v49Ev");}
void  S849C2 ::v50(){vfunc_called(this, "_ZN6S849C23v50Ev");}
void  S849C2 ::v51(){vfunc_called(this, "_ZN6S849C23v51Ev");}
void  S849C2 ::v52(){vfunc_called(this, "_ZN6S849C23v52Ev");}
void  S849C2 ::v53(){vfunc_called(this, "_ZN6S849C23v53Ev");}
void  S849C2 ::v54(){vfunc_called(this, "_ZN6S849C23v54Ev");}
void  S849C2 ::v55(){vfunc_called(this, "_ZN6S849C23v55Ev");}
void  S849C2 ::v56(){vfunc_called(this, "_ZN6S849C23v56Ev");}
void  S849C2 ::v57(){vfunc_called(this, "_ZN6S849C23v57Ev");}
void  S849C2 ::v58(){vfunc_called(this, "_ZN6S849C23v58Ev");}
void  S849C2 ::v59(){vfunc_called(this, "_ZN6S849C23v59Ev");}
void  S849C2 ::v60(){vfunc_called(this, "_ZN6S849C23v60Ev");}
void  S849C2 ::v61(){vfunc_called(this, "_ZN6S849C23v61Ev");}
void  S849C2 ::v62(){vfunc_called(this, "_ZN6S849C23v62Ev");}
void  S849C2 ::v63(){vfunc_called(this, "_ZN6S849C23v63Ev");}
void  S849C2 ::v64(){vfunc_called(this, "_ZN6S849C23v64Ev");}
void  S849C2 ::v65(){vfunc_called(this, "_ZN6S849C23v65Ev");}
void  S849C2 ::v66(){vfunc_called(this, "_ZN6S849C23v66Ev");}
void  S849C2 ::v67(){vfunc_called(this, "_ZN6S849C23v67Ev");}
void  S849C2 ::v68(){vfunc_called(this, "_ZN6S849C23v68Ev");}
void  S849C2 ::v69(){vfunc_called(this, "_ZN6S849C23v69Ev");}
void  S849C2 ::v70(){vfunc_called(this, "_ZN6S849C23v70Ev");}
void  S849C2 ::v71(){vfunc_called(this, "_ZN6S849C23v71Ev");}
void  S849C2 ::v72(){vfunc_called(this, "_ZN6S849C23v72Ev");}
void  S849C2 ::v73(){vfunc_called(this, "_ZN6S849C23v73Ev");}
void  S849C2 ::v74(){vfunc_called(this, "_ZN6S849C23v74Ev");}
void  S849C2 ::v75(){vfunc_called(this, "_ZN6S849C23v75Ev");}
void  S849C2 ::v76(){vfunc_called(this, "_ZN6S849C23v76Ev");}
void  S849C2 ::v77(){vfunc_called(this, "_ZN6S849C23v77Ev");}
void  S849C2 ::v78(){vfunc_called(this, "_ZN6S849C23v78Ev");}
void  S849C2 ::v79(){vfunc_called(this, "_ZN6S849C23v79Ev");}
void  S849C2 ::v80(){vfunc_called(this, "_ZN6S849C23v80Ev");}
void  S849C2 ::v81(){vfunc_called(this, "_ZN6S849C23v81Ev");}
S849C2 ::S849C2(){ note_ctor("S849C2", this);} // tgen

static void Test_S849C2()
{
  extern Class_Descriptor cd_S849C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S849C2, buf);
    S849C2 *dp, &lv = *(dp=new (buf) S849C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S849C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S849C2)");
    check_base_class_offset(lv, (S849C5*)(S849C4*)(S849C3*), 0, "S849C2");
    check_base_class_offset(lv, (S849C6*)(S849C4*)(S849C3*), ABISELECT(8,4), "S849C2");
    check_base_class_offset(lv, (S849C4*)(S849C3*), 0, "S849C2");
    check_base_class_offset(lv, (S849C3*), 0, "S849C2");
    check_base_class_offset(lv, (S849C10*), ABISELECT(80,60), "S849C2");
    check_field_offset(lv, s849c2f0, ABISELECT(88,64), "S849C2.s849c2f0");
    check_field_offset(lv, s849c2f1, ABISELECT(120,96), "S849C2.s849c2f1");
    check_field_offset(lv, s849c2f2, ABISELECT(192,160), "S849C2.s849c2f2");
    check_field_offset(lv, s849c2f3, ABISELECT(200,164), "S849C2.s849c2f3");
    check_field_offset(lv, s849c2f4, ABISELECT(208,168), "S849C2.s849c2f4");
    check_field_offset(lv, s849c2f5, ABISELECT(240,184), "S849C2.s849c2f5");
    test_class_info(&lv, &cd_S849C2);
    dp->~S849C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS849C2(Test_S849C2, "S849C2", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S849C2C1Ev();
extern void _ZN6S849C2D1Ev();
Name_Map name_map_S849C2[] = {
  NSPAIR(_ZN6S849C2C1Ev),
  NSPAIR(_ZN6S849C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S849C5;
extern VTBL_ENTRY _ZTI6S849C5[];
extern  VTBL_ENTRY _ZTV6S849C5[];
extern Class_Descriptor cd_S849C6;
extern VTBL_ENTRY _ZTI6S849C6[];
extern  VTBL_ENTRY _ZTV6S849C6[];
extern Class_Descriptor cd_S849C4;
extern VTBL_ENTRY _ZTI6S849C4[];
extern  VTBL_ENTRY _ZTV6S849C4[];
extern Class_Descriptor cd_S849C3;
extern VTBL_ENTRY _ZTI6S849C3[];
extern  VTBL_ENTRY _ZTV6S849C3[];
extern Class_Descriptor cd_S849C10;
extern VTBL_ENTRY _ZTI7S849C10[];
extern  VTBL_ENTRY _ZTV7S849C10[];
static Base_Class bases_S849C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S849C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S849C6,    ABISELECT(8,4), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S849C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S849C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S849C10,    ABISELECT(80,60), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S849C2[];
extern void _ZN6S849C2D1Ev();
extern void _ZN6S849C2D0Ev();
extern void _ZN6S849C53v11Ev();
extern void _ZN6S849C53v12Ev();
extern void _ZN6S849C53v13Ev();
extern void _ZN6S849C43v15Ev();
extern void _ZN6S849C43v16Ev();
extern void _ZN6S849C43v17Ev();
extern void _ZN6S849C43v18Ev();
extern void _ZN6S849C43v19Ev();
extern void _ZN6S849C43v20Ev();
extern void _ZN6S849C43v21Ev();
extern void _ZN6S849C43v22Ev();
extern void _ZN6S849C43v23Ev();
extern void _ZN6S849C43v24Ev();
extern void _ZN6S849C43v25Ev();
extern void _ZN6S849C43v26Ev();
extern void _ZN6S849C43v27Ev();
extern void _ZN6S849C43v28Ev();
extern void _ZN6S849C43v29Ev();
extern void _ZN6S849C43v30Ev();
extern void _ZN6S849C43v31Ev();
extern void _ZN6S849C43v32Ev();
extern void _ZN6S849C43v33Ev();
extern void _ZN6S849C43v34Ev();
extern void _ZN6S849C43v35Ev();
extern void _ZN6S849C43v36Ev();
extern void _ZN6S849C33v37Ev();
extern void _ZN6S849C33v38Ev();
extern void _ZN6S849C33v39Ev();
extern void _ZN6S849C23v41Ev();
extern void _ZN6S849C23v42Ev();
extern void _ZN6S849C23v43Ev();
extern void _ZN6S849C23v44Ev();
extern void _ZN6S849C23v45Ev();
extern void _ZN6S849C23v46Ev();
extern void _ZN6S849C23v47Ev();
extern void _ZN6S849C23v48Ev();
extern void _ZN6S849C23v49Ev();
extern void _ZN6S849C23v50Ev();
extern void _ZN6S849C23v51Ev();
extern void _ZN6S849C23v52Ev();
extern void _ZN6S849C23v53Ev();
extern void _ZN6S849C23v54Ev();
extern void _ZN6S849C23v55Ev();
extern void _ZN6S849C23v56Ev();
extern void _ZN6S849C23v57Ev();
extern void _ZN6S849C23v58Ev();
extern void _ZN6S849C23v59Ev();
extern void _ZN6S849C23v60Ev();
extern void _ZN6S849C23v61Ev();
extern void _ZN6S849C23v62Ev();
extern void _ZN6S849C23v63Ev();
extern void _ZN6S849C23v64Ev();
extern void _ZN6S849C23v65Ev();
extern void _ZN6S849C23v66Ev();
extern void _ZN6S849C23v67Ev();
extern void _ZN6S849C23v68Ev();
extern void _ZN6S849C23v69Ev();
extern void _ZN6S849C23v70Ev();
extern void _ZN6S849C23v71Ev();
extern void _ZN6S849C23v72Ev();
extern void _ZN6S849C23v73Ev();
extern void _ZN6S849C23v74Ev();
extern void _ZN6S849C23v75Ev();
extern void _ZN6S849C23v76Ev();
extern void _ZN6S849C23v77Ev();
extern void _ZN6S849C23v78Ev();
extern void _ZN6S849C23v79Ev();
extern void _ZN6S849C23v80Ev();
extern void _ZN6S849C23v81Ev();
extern void ABISELECT(_ZThn8_N6S849C2D1Ev,_ZThn4_N6S849C2D1Ev)();
extern void ABISELECT(_ZThn8_N6S849C2D0Ev,_ZThn4_N6S849C2D0Ev)();
extern void _ZN6S849C63v14Ev();
extern void ABISELECT(_ZThn80_N6S849C2D1Ev,_ZThn60_N6S849C2D1Ev)();
extern void ABISELECT(_ZThn80_N6S849C2D0Ev,_ZThn60_N6S849C2D0Ev)();
extern void _ZN7S849C103v40Ev();
static  VTBL_ENTRY vtc_S849C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S849C2[0]),
  (VTBL_ENTRY)&_ZN6S849C2D1Ev,
  (VTBL_ENTRY)&_ZN6S849C2D0Ev,
  (VTBL_ENTRY)&_ZN6S849C53v11Ev,
  (VTBL_ENTRY)&_ZN6S849C53v12Ev,
  (VTBL_ENTRY)&_ZN6S849C53v13Ev,
  (VTBL_ENTRY)&_ZN6S849C43v15Ev,
  (VTBL_ENTRY)&_ZN6S849C43v16Ev,
  (VTBL_ENTRY)&_ZN6S849C43v17Ev,
  (VTBL_ENTRY)&_ZN6S849C43v18Ev,
  (VTBL_ENTRY)&_ZN6S849C43v19Ev,
  (VTBL_ENTRY)&_ZN6S849C43v20Ev,
  (VTBL_ENTRY)&_ZN6S849C43v21Ev,
  (VTBL_ENTRY)&_ZN6S849C43v22Ev,
  (VTBL_ENTRY)&_ZN6S849C43v23Ev,
  (VTBL_ENTRY)&_ZN6S849C43v24Ev,
  (VTBL_ENTRY)&_ZN6S849C43v25Ev,
  (VTBL_ENTRY)&_ZN6S849C43v26Ev,
  (VTBL_ENTRY)&_ZN6S849C43v27Ev,
  (VTBL_ENTRY)&_ZN6S849C43v28Ev,
  (VTBL_ENTRY)&_ZN6S849C43v29Ev,
  (VTBL_ENTRY)&_ZN6S849C43v30Ev,
  (VTBL_ENTRY)&_ZN6S849C43v31Ev,
  (VTBL_ENTRY)&_ZN6S849C43v32Ev,
  (VTBL_ENTRY)&_ZN6S849C43v33Ev,
  (VTBL_ENTRY)&_ZN6S849C43v34Ev,
  (VTBL_ENTRY)&_ZN6S849C43v35Ev,
  (VTBL_ENTRY)&_ZN6S849C43v36Ev,
  (VTBL_ENTRY)&_ZN6S849C33v37Ev,
  (VTBL_ENTRY)&_ZN6S849C33v38Ev,
  (VTBL_ENTRY)&_ZN6S849C33v39Ev,
  (VTBL_ENTRY)&_ZN6S849C23v41Ev,
  (VTBL_ENTRY)&_ZN6S849C23v42Ev,
  (VTBL_ENTRY)&_ZN6S849C23v43Ev,
  (VTBL_ENTRY)&_ZN6S849C23v44Ev,
  (VTBL_ENTRY)&_ZN6S849C23v45Ev,
  (VTBL_ENTRY)&_ZN6S849C23v46Ev,
  (VTBL_ENTRY)&_ZN6S849C23v47Ev,
  (VTBL_ENTRY)&_ZN6S849C23v48Ev,
  (VTBL_ENTRY)&_ZN6S849C23v49Ev,
  (VTBL_ENTRY)&_ZN6S849C23v50Ev,
  (VTBL_ENTRY)&_ZN6S849C23v51Ev,
  (VTBL_ENTRY)&_ZN6S849C23v52Ev,
  (VTBL_ENTRY)&_ZN6S849C23v53Ev,
  (VTBL_ENTRY)&_ZN6S849C23v54Ev,
  (VTBL_ENTRY)&_ZN6S849C23v55Ev,
  (VTBL_ENTRY)&_ZN6S849C23v56Ev,
  (VTBL_ENTRY)&_ZN6S849C23v57Ev,
  (VTBL_ENTRY)&_ZN6S849C23v58Ev,
  (VTBL_ENTRY)&_ZN6S849C23v59Ev,
  (VTBL_ENTRY)&_ZN6S849C23v60Ev,
  (VTBL_ENTRY)&_ZN6S849C23v61Ev,
  (VTBL_ENTRY)&_ZN6S849C23v62Ev,
  (VTBL_ENTRY)&_ZN6S849C23v63Ev,
  (VTBL_ENTRY)&_ZN6S849C23v64Ev,
  (VTBL_ENTRY)&_ZN6S849C23v65Ev,
  (VTBL_ENTRY)&_ZN6S849C23v66Ev,
  (VTBL_ENTRY)&_ZN6S849C23v67Ev,
  (VTBL_ENTRY)&_ZN6S849C23v68Ev,
  (VTBL_ENTRY)&_ZN6S849C23v69Ev,
  (VTBL_ENTRY)&_ZN6S849C23v70Ev,
  (VTBL_ENTRY)&_ZN6S849C23v71Ev,
  (VTBL_ENTRY)&_ZN6S849C23v72Ev,
  (VTBL_ENTRY)&_ZN6S849C23v73Ev,
  (VTBL_ENTRY)&_ZN6S849C23v74Ev,
  (VTBL_ENTRY)&_ZN6S849C23v75Ev,
  (VTBL_ENTRY)&_ZN6S849C23v76Ev,
  (VTBL_ENTRY)&_ZN6S849C23v77Ev,
  (VTBL_ENTRY)&_ZN6S849C23v78Ev,
  (VTBL_ENTRY)&_ZN6S849C23v79Ev,
  (VTBL_ENTRY)&_ZN6S849C23v80Ev,
  (VTBL_ENTRY)&_ZN6S849C23v81Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S849C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C2D1Ev,_ZThn4_N6S849C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C2D0Ev,_ZThn4_N6S849C2D0Ev),
  (VTBL_ENTRY)&_ZN6S849C63v14Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S849C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S849C2D1Ev,_ZThn60_N6S849C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S849C2D0Ev,_ZThn60_N6S849C2D0Ev),
  (VTBL_ENTRY)&_ZN7S849C103v40Ev,
};
extern VTBL_ENTRY _ZTI6S849C2[];
extern  VTBL_ENTRY _ZTV6S849C2[];
Class_Descriptor cd_S849C2 = {  "S849C2", // class name
  bases_S849C2, 5,
  &(vtc_S849C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S849C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S849C2),83, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S849C1  : S849C2 {
  virtual  ~S849C1(); // _ZN6S849C1D1Ev
  virtual void  v1(); // _ZN6S849C12v1Ev
  virtual void  v2(); // _ZN6S849C12v2Ev
  virtual void  v3(); // _ZN6S849C12v3Ev
  virtual void  v4(); // _ZN6S849C12v4Ev
  virtual void  v5(); // _ZN6S849C12v5Ev
  virtual void  v6(); // _ZN6S849C12v6Ev
  virtual void  v7(); // _ZN6S849C12v7Ev
  virtual void  v8(); // _ZN6S849C12v8Ev
  virtual void  v9(); // _ZN6S849C12v9Ev
  virtual void  v10(); // _ZN6S849C13v10Ev
  S849C1(); // tgen
};
//SIG(1 S849C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v11 v12 v13} BC6{ vd v14} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36} vd v37 v38 v39 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v40} vd v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 FC11{ m FL[4]} FC12{ m Fp FC11 FC13{ m Fp FC14{ Fi[4]}} Fi Fc} Fc[2] Fp FC15{ BC16{ vd v84} BC17{ vd v85} vd v82 v83 Fp[2]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S849C1 ::~S849C1(){ note_dtor("S849C1", this);}
void  S849C1 ::v1(){vfunc_called(this, "_ZN6S849C12v1Ev");}
void  S849C1 ::v2(){vfunc_called(this, "_ZN6S849C12v2Ev");}
void  S849C1 ::v3(){vfunc_called(this, "_ZN6S849C12v3Ev");}
void  S849C1 ::v4(){vfunc_called(this, "_ZN6S849C12v4Ev");}
void  S849C1 ::v5(){vfunc_called(this, "_ZN6S849C12v5Ev");}
void  S849C1 ::v6(){vfunc_called(this, "_ZN6S849C12v6Ev");}
void  S849C1 ::v7(){vfunc_called(this, "_ZN6S849C12v7Ev");}
void  S849C1 ::v8(){vfunc_called(this, "_ZN6S849C12v8Ev");}
void  S849C1 ::v9(){vfunc_called(this, "_ZN6S849C12v9Ev");}
void  S849C1 ::v10(){vfunc_called(this, "_ZN6S849C13v10Ev");}
S849C1 ::S849C1(){ note_ctor("S849C1", this);} // tgen

static void Test_S849C1()
{
  extern Class_Descriptor cd_S849C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S849C1, buf);
    S849C1 *dp, &lv = *(dp=new (buf) S849C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S849C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S849C1)");
    check_base_class_offset(lv, (S849C5*)(S849C4*)(S849C3*)(S849C2*), 0, "S849C1");
    check_base_class_offset(lv, (S849C6*)(S849C4*)(S849C3*)(S849C2*), ABISELECT(8,4), "S849C1");
    check_base_class_offset(lv, (S849C4*)(S849C3*)(S849C2*), 0, "S849C1");
    check_base_class_offset(lv, (S849C3*)(S849C2*), 0, "S849C1");
    check_base_class_offset(lv, (S849C10*)(S849C2*), ABISELECT(80,60), "S849C1");
    check_base_class_offset(lv, (S849C2*), 0, "S849C1");
    test_class_info(&lv, &cd_S849C1);
    dp->~S849C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS849C1(Test_S849C1, "S849C1", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S849C1C1Ev();
extern void _ZN6S849C1D1Ev();
Name_Map name_map_S849C1[] = {
  NSPAIR(_ZN6S849C1C1Ev),
  NSPAIR(_ZN6S849C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S849C5;
extern VTBL_ENTRY _ZTI6S849C5[];
extern  VTBL_ENTRY _ZTV6S849C5[];
extern Class_Descriptor cd_S849C6;
extern VTBL_ENTRY _ZTI6S849C6[];
extern  VTBL_ENTRY _ZTV6S849C6[];
extern Class_Descriptor cd_S849C4;
extern VTBL_ENTRY _ZTI6S849C4[];
extern  VTBL_ENTRY _ZTV6S849C4[];
extern Class_Descriptor cd_S849C3;
extern VTBL_ENTRY _ZTI6S849C3[];
extern  VTBL_ENTRY _ZTV6S849C3[];
extern Class_Descriptor cd_S849C10;
extern VTBL_ENTRY _ZTI7S849C10[];
extern  VTBL_ENTRY _ZTV7S849C10[];
extern Class_Descriptor cd_S849C2;
extern VTBL_ENTRY _ZTI6S849C2[];
extern  VTBL_ENTRY _ZTV6S849C2[];
static Base_Class bases_S849C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S849C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S849C6,    ABISELECT(8,4), //bcp->offset
    83, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S849C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S849C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S849C10,    ABISELECT(80,60), //bcp->offset
    88, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S849C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S849C1[];
extern void _ZN6S849C1D1Ev();
extern void _ZN6S849C1D0Ev();
extern void _ZN6S849C53v11Ev();
extern void _ZN6S849C53v12Ev();
extern void _ZN6S849C53v13Ev();
extern void _ZN6S849C43v15Ev();
extern void _ZN6S849C43v16Ev();
extern void _ZN6S849C43v17Ev();
extern void _ZN6S849C43v18Ev();
extern void _ZN6S849C43v19Ev();
extern void _ZN6S849C43v20Ev();
extern void _ZN6S849C43v21Ev();
extern void _ZN6S849C43v22Ev();
extern void _ZN6S849C43v23Ev();
extern void _ZN6S849C43v24Ev();
extern void _ZN6S849C43v25Ev();
extern void _ZN6S849C43v26Ev();
extern void _ZN6S849C43v27Ev();
extern void _ZN6S849C43v28Ev();
extern void _ZN6S849C43v29Ev();
extern void _ZN6S849C43v30Ev();
extern void _ZN6S849C43v31Ev();
extern void _ZN6S849C43v32Ev();
extern void _ZN6S849C43v33Ev();
extern void _ZN6S849C43v34Ev();
extern void _ZN6S849C43v35Ev();
extern void _ZN6S849C43v36Ev();
extern void _ZN6S849C33v37Ev();
extern void _ZN6S849C33v38Ev();
extern void _ZN6S849C33v39Ev();
extern void _ZN6S849C23v41Ev();
extern void _ZN6S849C23v42Ev();
extern void _ZN6S849C23v43Ev();
extern void _ZN6S849C23v44Ev();
extern void _ZN6S849C23v45Ev();
extern void _ZN6S849C23v46Ev();
extern void _ZN6S849C23v47Ev();
extern void _ZN6S849C23v48Ev();
extern void _ZN6S849C23v49Ev();
extern void _ZN6S849C23v50Ev();
extern void _ZN6S849C23v51Ev();
extern void _ZN6S849C23v52Ev();
extern void _ZN6S849C23v53Ev();
extern void _ZN6S849C23v54Ev();
extern void _ZN6S849C23v55Ev();
extern void _ZN6S849C23v56Ev();
extern void _ZN6S849C23v57Ev();
extern void _ZN6S849C23v58Ev();
extern void _ZN6S849C23v59Ev();
extern void _ZN6S849C23v60Ev();
extern void _ZN6S849C23v61Ev();
extern void _ZN6S849C23v62Ev();
extern void _ZN6S849C23v63Ev();
extern void _ZN6S849C23v64Ev();
extern void _ZN6S849C23v65Ev();
extern void _ZN6S849C23v66Ev();
extern void _ZN6S849C23v67Ev();
extern void _ZN6S849C23v68Ev();
extern void _ZN6S849C23v69Ev();
extern void _ZN6S849C23v70Ev();
extern void _ZN6S849C23v71Ev();
extern void _ZN6S849C23v72Ev();
extern void _ZN6S849C23v73Ev();
extern void _ZN6S849C23v74Ev();
extern void _ZN6S849C23v75Ev();
extern void _ZN6S849C23v76Ev();
extern void _ZN6S849C23v77Ev();
extern void _ZN6S849C23v78Ev();
extern void _ZN6S849C23v79Ev();
extern void _ZN6S849C23v80Ev();
extern void _ZN6S849C23v81Ev();
extern void _ZN6S849C12v1Ev();
extern void _ZN6S849C12v2Ev();
extern void _ZN6S849C12v3Ev();
extern void _ZN6S849C12v4Ev();
extern void _ZN6S849C12v5Ev();
extern void _ZN6S849C12v6Ev();
extern void _ZN6S849C12v7Ev();
extern void _ZN6S849C12v8Ev();
extern void _ZN6S849C12v9Ev();
extern void _ZN6S849C13v10Ev();
extern void ABISELECT(_ZThn8_N6S849C1D1Ev,_ZThn4_N6S849C1D1Ev)();
extern void ABISELECT(_ZThn8_N6S849C1D0Ev,_ZThn4_N6S849C1D0Ev)();
extern void _ZN6S849C63v14Ev();
extern void ABISELECT(_ZThn80_N6S849C1D1Ev,_ZThn60_N6S849C1D1Ev)();
extern void ABISELECT(_ZThn80_N6S849C1D0Ev,_ZThn60_N6S849C1D0Ev)();
extern void _ZN7S849C103v40Ev();
static  VTBL_ENTRY vtc_S849C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S849C1[0]),
  (VTBL_ENTRY)&_ZN6S849C1D1Ev,
  (VTBL_ENTRY)&_ZN6S849C1D0Ev,
  (VTBL_ENTRY)&_ZN6S849C53v11Ev,
  (VTBL_ENTRY)&_ZN6S849C53v12Ev,
  (VTBL_ENTRY)&_ZN6S849C53v13Ev,
  (VTBL_ENTRY)&_ZN6S849C43v15Ev,
  (VTBL_ENTRY)&_ZN6S849C43v16Ev,
  (VTBL_ENTRY)&_ZN6S849C43v17Ev,
  (VTBL_ENTRY)&_ZN6S849C43v18Ev,
  (VTBL_ENTRY)&_ZN6S849C43v19Ev,
  (VTBL_ENTRY)&_ZN6S849C43v20Ev,
  (VTBL_ENTRY)&_ZN6S849C43v21Ev,
  (VTBL_ENTRY)&_ZN6S849C43v22Ev,
  (VTBL_ENTRY)&_ZN6S849C43v23Ev,
  (VTBL_ENTRY)&_ZN6S849C43v24Ev,
  (VTBL_ENTRY)&_ZN6S849C43v25Ev,
  (VTBL_ENTRY)&_ZN6S849C43v26Ev,
  (VTBL_ENTRY)&_ZN6S849C43v27Ev,
  (VTBL_ENTRY)&_ZN6S849C43v28Ev,
  (VTBL_ENTRY)&_ZN6S849C43v29Ev,
  (VTBL_ENTRY)&_ZN6S849C43v30Ev,
  (VTBL_ENTRY)&_ZN6S849C43v31Ev,
  (VTBL_ENTRY)&_ZN6S849C43v32Ev,
  (VTBL_ENTRY)&_ZN6S849C43v33Ev,
  (VTBL_ENTRY)&_ZN6S849C43v34Ev,
  (VTBL_ENTRY)&_ZN6S849C43v35Ev,
  (VTBL_ENTRY)&_ZN6S849C43v36Ev,
  (VTBL_ENTRY)&_ZN6S849C33v37Ev,
  (VTBL_ENTRY)&_ZN6S849C33v38Ev,
  (VTBL_ENTRY)&_ZN6S849C33v39Ev,
  (VTBL_ENTRY)&_ZN6S849C23v41Ev,
  (VTBL_ENTRY)&_ZN6S849C23v42Ev,
  (VTBL_ENTRY)&_ZN6S849C23v43Ev,
  (VTBL_ENTRY)&_ZN6S849C23v44Ev,
  (VTBL_ENTRY)&_ZN6S849C23v45Ev,
  (VTBL_ENTRY)&_ZN6S849C23v46Ev,
  (VTBL_ENTRY)&_ZN6S849C23v47Ev,
  (VTBL_ENTRY)&_ZN6S849C23v48Ev,
  (VTBL_ENTRY)&_ZN6S849C23v49Ev,
  (VTBL_ENTRY)&_ZN6S849C23v50Ev,
  (VTBL_ENTRY)&_ZN6S849C23v51Ev,
  (VTBL_ENTRY)&_ZN6S849C23v52Ev,
  (VTBL_ENTRY)&_ZN6S849C23v53Ev,
  (VTBL_ENTRY)&_ZN6S849C23v54Ev,
  (VTBL_ENTRY)&_ZN6S849C23v55Ev,
  (VTBL_ENTRY)&_ZN6S849C23v56Ev,
  (VTBL_ENTRY)&_ZN6S849C23v57Ev,
  (VTBL_ENTRY)&_ZN6S849C23v58Ev,
  (VTBL_ENTRY)&_ZN6S849C23v59Ev,
  (VTBL_ENTRY)&_ZN6S849C23v60Ev,
  (VTBL_ENTRY)&_ZN6S849C23v61Ev,
  (VTBL_ENTRY)&_ZN6S849C23v62Ev,
  (VTBL_ENTRY)&_ZN6S849C23v63Ev,
  (VTBL_ENTRY)&_ZN6S849C23v64Ev,
  (VTBL_ENTRY)&_ZN6S849C23v65Ev,
  (VTBL_ENTRY)&_ZN6S849C23v66Ev,
  (VTBL_ENTRY)&_ZN6S849C23v67Ev,
  (VTBL_ENTRY)&_ZN6S849C23v68Ev,
  (VTBL_ENTRY)&_ZN6S849C23v69Ev,
  (VTBL_ENTRY)&_ZN6S849C23v70Ev,
  (VTBL_ENTRY)&_ZN6S849C23v71Ev,
  (VTBL_ENTRY)&_ZN6S849C23v72Ev,
  (VTBL_ENTRY)&_ZN6S849C23v73Ev,
  (VTBL_ENTRY)&_ZN6S849C23v74Ev,
  (VTBL_ENTRY)&_ZN6S849C23v75Ev,
  (VTBL_ENTRY)&_ZN6S849C23v76Ev,
  (VTBL_ENTRY)&_ZN6S849C23v77Ev,
  (VTBL_ENTRY)&_ZN6S849C23v78Ev,
  (VTBL_ENTRY)&_ZN6S849C23v79Ev,
  (VTBL_ENTRY)&_ZN6S849C23v80Ev,
  (VTBL_ENTRY)&_ZN6S849C23v81Ev,
  (VTBL_ENTRY)&_ZN6S849C12v1Ev,
  (VTBL_ENTRY)&_ZN6S849C12v2Ev,
  (VTBL_ENTRY)&_ZN6S849C12v3Ev,
  (VTBL_ENTRY)&_ZN6S849C12v4Ev,
  (VTBL_ENTRY)&_ZN6S849C12v5Ev,
  (VTBL_ENTRY)&_ZN6S849C12v6Ev,
  (VTBL_ENTRY)&_ZN6S849C12v7Ev,
  (VTBL_ENTRY)&_ZN6S849C12v8Ev,
  (VTBL_ENTRY)&_ZN6S849C12v9Ev,
  (VTBL_ENTRY)&_ZN6S849C13v10Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S849C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C1D1Ev,_ZThn4_N6S849C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S849C1D0Ev,_ZThn4_N6S849C1D0Ev),
  (VTBL_ENTRY)&_ZN6S849C63v14Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S849C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S849C1D1Ev,_ZThn60_N6S849C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S849C1D0Ev,_ZThn60_N6S849C1D0Ev),
  (VTBL_ENTRY)&_ZN7S849C103v40Ev,
};
extern VTBL_ENTRY _ZTI6S849C1[];
extern  VTBL_ENTRY _ZTV6S849C1[];
Class_Descriptor cd_S849C1 = {  "S849C1", // class name
  bases_S849C1, 6,
  &(vtc_S849C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S849C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S849C1),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S843C5  {
  virtual  ~S843C5(); // _ZN6S843C5D1Ev
  virtual void  v10(); // _ZN6S843C53v10Ev
  virtual void  v11(); // _ZN6S843C53v11Ev
  virtual void  v12(); // _ZN6S843C53v12Ev
  S843C5(); // tgen
};
//SIG(-1 S843C5) C1{ vd v1 v2 v3}


 S843C5 ::~S843C5(){ note_dtor("S843C5", this);}
void  S843C5 ::v10(){vfunc_called(this, "_ZN6S843C53v10Ev");}
void  S843C5 ::v11(){vfunc_called(this, "_ZN6S843C53v11Ev");}
void  S843C5 ::v12(){vfunc_called(this, "_ZN6S843C53v12Ev");}
S843C5 ::S843C5(){ note_ctor("S843C5", this);} // tgen

static void Test_S843C5()
{
  extern Class_Descriptor cd_S843C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S843C5, buf);
    S843C5 *dp, &lv = *(dp=new (buf) S843C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S843C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S843C5)");
    test_class_info(&lv, &cd_S843C5);
    dp->~S843C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS843C5(Test_S843C5, "S843C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S843C5C1Ev();
extern void _ZN6S843C5D1Ev();
Name_Map name_map_S843C5[] = {
  NSPAIR(_ZN6S843C5C1Ev),
  NSPAIR(_ZN6S843C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S843C5[];
extern void _ZN6S843C5D1Ev();
extern void _ZN6S843C5D0Ev();
extern void _ZN6S843C53v10Ev();
extern void _ZN6S843C53v11Ev();
extern void _ZN6S843C53v12Ev();
static  VTBL_ENTRY vtc_S843C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S843C5[0]),
  (VTBL_ENTRY)&_ZN6S843C5D1Ev,
  (VTBL_ENTRY)&_ZN6S843C5D0Ev,
  (VTBL_ENTRY)&_ZN6S843C53v10Ev,
  (VTBL_ENTRY)&_ZN6S843C53v11Ev,
  (VTBL_ENTRY)&_ZN6S843C53v12Ev,
};
extern VTBL_ENTRY _ZTI6S843C5[];
extern  VTBL_ENTRY _ZTV6S843C5[];
Class_Descriptor cd_S843C5 = {  "S843C5", // class name
  0,0,//no base classes
  &(vtc_S843C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S843C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S843C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S843C6  {
  virtual  ~S843C6(); // _ZN6S843C6D1Ev
  virtual void  v13(); // _ZN6S843C63v13Ev
  S843C6(); // tgen
};
//SIG(-1 S843C6) C1{ vd v1}


 S843C6 ::~S843C6(){ note_dtor("S843C6", this);}
void  S843C6 ::v13(){vfunc_called(this, "_ZN6S843C63v13Ev");}
S843C6 ::S843C6(){ note_ctor("S843C6", this);} // tgen

static void Test_S843C6()
{
  extern Class_Descriptor cd_S843C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S843C6, buf);
    S843C6 *dp, &lv = *(dp=new (buf) S843C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S843C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S843C6)");
    test_class_info(&lv, &cd_S843C6);
    dp->~S843C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS843C6(Test_S843C6, "S843C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S843C6C1Ev();
extern void _ZN6S843C6D1Ev();
Name_Map name_map_S843C6[] = {
  NSPAIR(_ZN6S843C6C1Ev),
  NSPAIR(_ZN6S843C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S843C6[];
extern void _ZN6S843C6D1Ev();
extern void _ZN6S843C6D0Ev();
extern void _ZN6S843C63v13Ev();
static  VTBL_ENTRY vtc_S843C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S843C6[0]),
  (VTBL_ENTRY)&_ZN6S843C6D1Ev,
  (VTBL_ENTRY)&_ZN6S843C6D0Ev,
  (VTBL_ENTRY)&_ZN6S843C63v13Ev,
};
extern VTBL_ENTRY _ZTI6S843C6[];
extern  VTBL_ENTRY _ZTV6S843C6[];
Class_Descriptor cd_S843C6 = {  "S843C6", // class name
  0,0,//no base classes
  &(vtc_S843C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S843C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S843C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S843C4  : S843C5 , S843C6 {
  virtual  ~S843C4(); // _ZN6S843C4D1Ev
  virtual void  v14(); // _ZN6S843C43v14Ev
  virtual void  v15(); // _ZN6S843C43v15Ev
  virtual void  v16(); // _ZN6S843C43v16Ev
  virtual void  v17(); // _ZN6S843C43v17Ev
  virtual void  v18(); // _ZN6S843C43v18Ev
  virtual void  v19(); // _ZN6S843C43v19Ev
  virtual void  v20(); // _ZN6S843C43v20Ev
  virtual void  v21(); // _ZN6S843C43v21Ev
  virtual void  v22(); // _ZN6S843C43v22Ev
  virtual void  v23(); // _ZN6S843C43v23Ev
  virtual void  v24(); // _ZN6S843C43v24Ev
  virtual void  v25(); // _ZN6S843C43v25Ev
  virtual void  v26(); // _ZN6S843C43v26Ev
  virtual void  v27(); // _ZN6S843C43v27Ev
  virtual void  v28(); // _ZN6S843C43v28Ev
  virtual void  v29(); // _ZN6S843C43v29Ev
  virtual void  v30(); // _ZN6S843C43v30Ev
  virtual void  v31(); // _ZN6S843C43v31Ev
  virtual void  v32(); // _ZN6S843C43v32Ev
  virtual void  v33(); // _ZN6S843C43v33Ev
  virtual void  v34(); // _ZN6S843C43v34Ev
  virtual void  v35(); // _ZN6S843C43v35Ev
  S843C4(); // tgen
};
//SIG(-1 S843C4) C1{ BC2{ vd v23 v24 v25} BC3{ vd v26} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22}


 S843C4 ::~S843C4(){ note_dtor("S843C4", this);}
void  S843C4 ::v14(){vfunc_called(this, "_ZN6S843C43v14Ev");}
void  S843C4 ::v15(){vfunc_called(this, "_ZN6S843C43v15Ev");}
void  S843C4 ::v16(){vfunc_called(this, "_ZN6S843C43v16Ev");}
void  S843C4 ::v17(){vfunc_called(this, "_ZN6S843C43v17Ev");}
void  S843C4 ::v18(){vfunc_called(this, "_ZN6S843C43v18Ev");}
void  S843C4 ::v19(){vfunc_called(this, "_ZN6S843C43v19Ev");}
void  S843C4 ::v20(){vfunc_called(this, "_ZN6S843C43v20Ev");}
void  S843C4 ::v21(){vfunc_called(this, "_ZN6S843C43v21Ev");}
void  S843C4 ::v22(){vfunc_called(this, "_ZN6S843C43v22Ev");}
void  S843C4 ::v23(){vfunc_called(this, "_ZN6S843C43v23Ev");}
void  S843C4 ::v24(){vfunc_called(this, "_ZN6S843C43v24Ev");}
void  S843C4 ::v25(){vfunc_called(this, "_ZN6S843C43v25Ev");}
void  S843C4 ::v26(){vfunc_called(this, "_ZN6S843C43v26Ev");}
void  S843C4 ::v27(){vfunc_called(this, "_ZN6S843C43v27Ev");}
void  S843C4 ::v28(){vfunc_called(this, "_ZN6S843C43v28Ev");}
void  S843C4 ::v29(){vfunc_called(this, "_ZN6S843C43v29Ev");}
void  S843C4 ::v30(){vfunc_called(this, "_ZN6S843C43v30Ev");}
void  S843C4 ::v31(){vfunc_called(this, "_ZN6S843C43v31Ev");}
void  S843C4 ::v32(){vfunc_called(this, "_ZN6S843C43v32Ev");}
void  S843C4 ::v33(){vfunc_called(this, "_ZN6S843C43v33Ev");}
void  S843C4 ::v34(){vfunc_called(this, "_ZN6S843C43v34Ev");}
void  S843C4 ::v35(){vfunc_called(this, "_ZN6S843C43v35Ev");}
S843C4 ::S843C4(){ note_ctor("S843C4", this);} // tgen

static void Test_S843C4()
{
  extern Class_Descriptor cd_S843C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S843C4, buf);
    S843C4 *dp, &lv = *(dp=new (buf) S843C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S843C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S843C4)");
    check_base_class_offset(lv, (S843C5*), 0, "S843C4");
    check_base_class_offset(lv, (S843C6*), ABISELECT(8,4), "S843C4");
    test_class_info(&lv, &cd_S843C4);
    dp->~S843C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS843C4(Test_S843C4, "S843C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN6S843C4C1Ev();
extern void _ZN6S843C4D1Ev();
Name_Map name_map_S843C4[] = {
  NSPAIR(_ZN6S843C4C1Ev),
  NSPAIR(_ZN6S843C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S843C5;
extern VTBL_ENTRY _ZTI6S843C5[];
extern  VTBL_ENTRY _ZTV6S843C5[];
extern Class_Descriptor cd_S843C6;
extern VTBL_ENTRY _ZTI6S843C6[];
extern  VTBL_ENTRY _ZTV6S843C6[];
static Base_Class bases_S843C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S843C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S843C6,    ABISELECT(8,4), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S843C4[];
extern void _ZN6S843C4D1Ev();
extern void _ZN6S843C4D0Ev();
extern void _ZN6S843C53v10Ev();
extern void _ZN6S843C53v11Ev();
extern void _ZN6S843C53v12Ev();
extern void _ZN6S843C43v14Ev();
extern void _ZN6S843C43v15Ev();
extern void _ZN6S843C43v16Ev();
extern void _ZN6S843C43v17Ev();
extern void _ZN6S843C43v18Ev();
extern void _ZN6S843C43v19Ev();
extern void _ZN6S843C43v20Ev();
extern void _ZN6S843C43v21Ev();
extern void _ZN6S843C43v22Ev();
extern void _ZN6S843C43v23Ev();
extern void _ZN6S843C43v24Ev();
extern void _ZN6S843C43v25Ev();
extern void _ZN6S843C43v26Ev();
extern void _ZN6S843C43v27Ev();
extern void _ZN6S843C43v28Ev();
extern void _ZN6S843C43v29Ev();
extern void _ZN6S843C43v30Ev();
extern void _ZN6S843C43v31Ev();
extern void _ZN6S843C43v32Ev();
extern void _ZN6S843C43v33Ev();
extern void _ZN6S843C43v34Ev();
extern void _ZN6S843C43v35Ev();
extern void ABISELECT(_ZThn8_N6S843C4D1Ev,_ZThn4_N6S843C4D1Ev)();
extern void ABISELECT(_ZThn8_N6S843C4D0Ev,_ZThn4_N6S843C4D0Ev)();
extern void _ZN6S843C63v13Ev();
static  VTBL_ENTRY vtc_S843C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S843C4[0]),
  (VTBL_ENTRY)&_ZN6S843C4D1Ev,
  (VTBL_ENTRY)&_ZN6S843C4D0Ev,
  (VTBL_ENTRY)&_ZN6S843C53v10Ev,
  (VTBL_ENTRY)&_ZN6S843C53v11Ev,
  (VTBL_ENTRY)&_ZN6S843C53v12Ev,
  (VTBL_ENTRY)&_ZN6S843C43v14Ev,
  (VTBL_ENTRY)&_ZN6S843C43v15Ev,
  (VTBL_ENTRY)&_ZN6S843C43v16Ev,
  (VTBL_ENTRY)&_ZN6S843C43v17Ev,
  (VTBL_ENTRY)&_ZN6S843C43v18Ev,
  (VTBL_ENTRY)&_ZN6S843C43v19Ev,
  (VTBL_ENTRY)&_ZN6S843C43v20Ev,
  (VTBL_ENTRY)&_ZN6S843C43v21Ev,
  (VTBL_ENTRY)&_ZN6S843C43v22Ev,
  (VTBL_ENTRY)&_ZN6S843C43v23Ev,
  (VTBL_ENTRY)&_ZN6S843C43v24Ev,
  (VTBL_ENTRY)&_ZN6S843C43v25Ev,
  (VTBL_ENTRY)&_ZN6S843C43v26Ev,
  (VTBL_ENTRY)&_ZN6S843C43v27Ev,
  (VTBL_ENTRY)&_ZN6S843C43v28Ev,
  (VTBL_ENTRY)&_ZN6S843C43v29Ev,
  (VTBL_ENTRY)&_ZN6S843C43v30Ev,
  (VTBL_ENTRY)&_ZN6S843C43v31Ev,
  (VTBL_ENTRY)&_ZN6S843C43v32Ev,
  (VTBL_ENTRY)&_ZN6S843C43v33Ev,
  (VTBL_ENTRY)&_ZN6S843C43v34Ev,
  (VTBL_ENTRY)&_ZN6S843C43v35Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S843C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C4D1Ev,_ZThn4_N6S843C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C4D0Ev,_ZThn4_N6S843C4D0Ev),
  (VTBL_ENTRY)&_ZN6S843C63v13Ev,
};
extern VTBL_ENTRY _ZTI6S843C4[];
extern  VTBL_ENTRY _ZTV6S843C4[];
Class_Descriptor cd_S843C4 = {  "S843C4", // class name
  bases_S843C4, 2,
  &(vtc_S843C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI6S843C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S843C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S843C3  : S843C4 {
  ::S858C7_nt s843c3f0;
  ::S9124C5_nt s843c3f1;
  char s843c3f2;
  virtual  ~S843C3(); // _ZN6S843C3D1Ev
  virtual void  v36(); // _ZN6S843C33v36Ev
  virtual void  v37(); // _ZN6S843C33v37Ev
  virtual void  v38(); // _ZN6S843C33v38Ev
  S843C3(); // tgen
};
//SIG(-1 S843C3) C1{ BC2{ BC3{ vd v4 v5 v6} BC4{ vd v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29} vd v1 v2 v3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc}


 S843C3 ::~S843C3(){ note_dtor("S843C3", this);}
void  S843C3 ::v36(){vfunc_called(this, "_ZN6S843C33v36Ev");}
void  S843C3 ::v37(){vfunc_called(this, "_ZN6S843C33v37Ev");}
void  S843C3 ::v38(){vfunc_called(this, "_ZN6S843C33v38Ev");}
S843C3 ::S843C3(){ note_ctor("S843C3", this);} // tgen

static void Test_S843C3()
{
  extern Class_Descriptor cd_S843C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S843C3, buf);
    S843C3 *dp, &lv = *(dp=new (buf) S843C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S843C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S843C3)");
    check_base_class_offset(lv, (S843C5*)(S843C4*), 0, "S843C3");
    check_base_class_offset(lv, (S843C6*)(S843C4*), ABISELECT(8,4), "S843C3");
    check_base_class_offset(lv, (S843C4*), 0, "S843C3");
    check_field_offset(lv, s843c3f0, ABISELECT(16,8), "S843C3.s843c3f0");
    check_field_offset(lv, s843c3f1, ABISELECT(40,24), "S843C3.s843c3f1");
    check_field_offset(lv, s843c3f2, ABISELECT(72,56), "S843C3.s843c3f2");
    test_class_info(&lv, &cd_S843C3);
    dp->~S843C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS843C3(Test_S843C3, "S843C3", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN6S843C3C1Ev();
extern void _ZN6S843C3D1Ev();
Name_Map name_map_S843C3[] = {
  NSPAIR(_ZN6S843C3C1Ev),
  NSPAIR(_ZN6S843C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S843C5;
extern VTBL_ENTRY _ZTI6S843C5[];
extern  VTBL_ENTRY _ZTV6S843C5[];
extern Class_Descriptor cd_S843C6;
extern VTBL_ENTRY _ZTI6S843C6[];
extern  VTBL_ENTRY _ZTV6S843C6[];
extern Class_Descriptor cd_S843C4;
extern VTBL_ENTRY _ZTI6S843C4[];
extern  VTBL_ENTRY _ZTV6S843C4[];
static Base_Class bases_S843C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S843C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S843C6,    ABISELECT(8,4), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S843C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S843C3[];
extern void _ZN6S843C3D1Ev();
extern void _ZN6S843C3D0Ev();
extern void _ZN6S843C53v10Ev();
extern void _ZN6S843C53v11Ev();
extern void _ZN6S843C53v12Ev();
extern void _ZN6S843C43v14Ev();
extern void _ZN6S843C43v15Ev();
extern void _ZN6S843C43v16Ev();
extern void _ZN6S843C43v17Ev();
extern void _ZN6S843C43v18Ev();
extern void _ZN6S843C43v19Ev();
extern void _ZN6S843C43v20Ev();
extern void _ZN6S843C43v21Ev();
extern void _ZN6S843C43v22Ev();
extern void _ZN6S843C43v23Ev();
extern void _ZN6S843C43v24Ev();
extern void _ZN6S843C43v25Ev();
extern void _ZN6S843C43v26Ev();
extern void _ZN6S843C43v27Ev();
extern void _ZN6S843C43v28Ev();
extern void _ZN6S843C43v29Ev();
extern void _ZN6S843C43v30Ev();
extern void _ZN6S843C43v31Ev();
extern void _ZN6S843C43v32Ev();
extern void _ZN6S843C43v33Ev();
extern void _ZN6S843C43v34Ev();
extern void _ZN6S843C43v35Ev();
extern void _ZN6S843C33v36Ev();
extern void _ZN6S843C33v37Ev();
extern void _ZN6S843C33v38Ev();
extern void ABISELECT(_ZThn8_N6S843C3D1Ev,_ZThn4_N6S843C3D1Ev)();
extern void ABISELECT(_ZThn8_N6S843C3D0Ev,_ZThn4_N6S843C3D0Ev)();
extern void _ZN6S843C63v13Ev();
static  VTBL_ENTRY vtc_S843C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S843C3[0]),
  (VTBL_ENTRY)&_ZN6S843C3D1Ev,
  (VTBL_ENTRY)&_ZN6S843C3D0Ev,
  (VTBL_ENTRY)&_ZN6S843C53v10Ev,
  (VTBL_ENTRY)&_ZN6S843C53v11Ev,
  (VTBL_ENTRY)&_ZN6S843C53v12Ev,
  (VTBL_ENTRY)&_ZN6S843C43v14Ev,
  (VTBL_ENTRY)&_ZN6S843C43v15Ev,
  (VTBL_ENTRY)&_ZN6S843C43v16Ev,
  (VTBL_ENTRY)&_ZN6S843C43v17Ev,
  (VTBL_ENTRY)&_ZN6S843C43v18Ev,
  (VTBL_ENTRY)&_ZN6S843C43v19Ev,
  (VTBL_ENTRY)&_ZN6S843C43v20Ev,
  (VTBL_ENTRY)&_ZN6S843C43v21Ev,
  (VTBL_ENTRY)&_ZN6S843C43v22Ev,
  (VTBL_ENTRY)&_ZN6S843C43v23Ev,
  (VTBL_ENTRY)&_ZN6S843C43v24Ev,
  (VTBL_ENTRY)&_ZN6S843C43v25Ev,
  (VTBL_ENTRY)&_ZN6S843C43v26Ev,
  (VTBL_ENTRY)&_ZN6S843C43v27Ev,
  (VTBL_ENTRY)&_ZN6S843C43v28Ev,
  (VTBL_ENTRY)&_ZN6S843C43v29Ev,
  (VTBL_ENTRY)&_ZN6S843C43v30Ev,
  (VTBL_ENTRY)&_ZN6S843C43v31Ev,
  (VTBL_ENTRY)&_ZN6S843C43v32Ev,
  (VTBL_ENTRY)&_ZN6S843C43v33Ev,
  (VTBL_ENTRY)&_ZN6S843C43v34Ev,
  (VTBL_ENTRY)&_ZN6S843C43v35Ev,
  (VTBL_ENTRY)&_ZN6S843C33v36Ev,
  (VTBL_ENTRY)&_ZN6S843C33v37Ev,
  (VTBL_ENTRY)&_ZN6S843C33v38Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S843C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C3D1Ev,_ZThn4_N6S843C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C3D0Ev,_ZThn4_N6S843C3D0Ev),
  (VTBL_ENTRY)&_ZN6S843C63v13Ev,
};
extern VTBL_ENTRY _ZTI6S843C3[];
extern  VTBL_ENTRY _ZTV6S843C3[];
Class_Descriptor cd_S843C3 = {  "S843C3", // class name
  bases_S843C3, 3,
  &(vtc_S843C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI6S843C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S843C3),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S843C10  {
  virtual  ~S843C10(); // _ZN7S843C10D1Ev
  virtual void  v39(); // _ZN7S843C103v39Ev
  S843C10(); // tgen
};
//SIG(-1 S843C10) C1{ vd v1}


 S843C10 ::~S843C10(){ note_dtor("S843C10", this);}
void  S843C10 ::v39(){vfunc_called(this, "_ZN7S843C103v39Ev");}
S843C10 ::S843C10(){ note_ctor("S843C10", this);} // tgen

static void Test_S843C10()
{
  extern Class_Descriptor cd_S843C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S843C10, buf);
    S843C10 *dp, &lv = *(dp=new (buf) S843C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S843C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S843C10)");
    test_class_info(&lv, &cd_S843C10);
    dp->~S843C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS843C10(Test_S843C10, "S843C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S843C10C1Ev();
extern void _ZN7S843C10D1Ev();
Name_Map name_map_S843C10[] = {
  NSPAIR(_ZN7S843C10C1Ev),
  NSPAIR(_ZN7S843C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S843C10[];
extern void _ZN7S843C10D1Ev();
extern void _ZN7S843C10D0Ev();
extern void _ZN7S843C103v39Ev();
static  VTBL_ENTRY vtc_S843C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S843C10[0]),
  (VTBL_ENTRY)&_ZN7S843C10D1Ev,
  (VTBL_ENTRY)&_ZN7S843C10D0Ev,
  (VTBL_ENTRY)&_ZN7S843C103v39Ev,
};
extern VTBL_ENTRY _ZTI7S843C10[];
extern  VTBL_ENTRY _ZTV7S843C10[];
Class_Descriptor cd_S843C10 = {  "S843C10", // class name
  0,0,//no base classes
  &(vtc_S843C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S843C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S843C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S843C2  : S843C3 , S843C10 {
  ::S858C11_nt s843c2f0;
  ::S858C12_nt s843c2f1;
  char s843c2f2[3];
  void *s843c2f3;
  ::S858C15_nt s843c2f4;
  void *s843c2f5;
  virtual  ~S843C2(); // _ZN6S843C2D1Ev
  virtual void  v40(); // _ZN6S843C23v40Ev
  virtual void  v41(); // _ZN6S843C23v41Ev
  virtual void  v42(); // _ZN6S843C23v42Ev
  virtual void  v43(); // _ZN6S843C23v43Ev
  virtual void  v44(); // _ZN6S843C23v44Ev
  virtual void  v45(); // _ZN6S843C23v45Ev
  virtual void  v46(); // _ZN6S843C23v46Ev
  virtual void  v47(); // _ZN6S843C23v47Ev
  virtual void  v48(); // _ZN6S843C23v48Ev
  virtual void  v49(); // _ZN6S843C23v49Ev
  virtual void  v50(); // _ZN6S843C23v50Ev
  virtual void  v51(); // _ZN6S843C23v51Ev
  virtual void  v52(); // _ZN6S843C23v52Ev
  virtual void  v53(); // _ZN6S843C23v53Ev
  virtual void  v54(); // _ZN6S843C23v54Ev
  virtual void  v55(); // _ZN6S843C23v55Ev
  virtual void  v56(); // _ZN6S843C23v56Ev
  virtual void  v57(); // _ZN6S843C23v57Ev
  virtual void  v58(); // _ZN6S843C23v58Ev
  virtual void  v59(); // _ZN6S843C23v59Ev
  virtual void  v60(); // _ZN6S843C23v60Ev
  virtual void  v61(); // _ZN6S843C23v61Ev
  virtual void  v62(); // _ZN6S843C23v62Ev
  virtual void  v63(); // _ZN6S843C23v63Ev
  virtual void  v64(); // _ZN6S843C23v64Ev
  virtual void  v65(); // _ZN6S843C23v65Ev
  virtual void  v66(); // _ZN6S843C23v66Ev
  virtual void  v67(); // _ZN6S843C23v67Ev
  virtual void  v68(); // _ZN6S843C23v68Ev
  virtual void  v69(); // _ZN6S843C23v69Ev
  virtual void  v70(); // _ZN6S843C23v70Ev
  virtual void  v71(); // _ZN6S843C23v71Ev
  virtual void  v72(); // _ZN6S843C23v72Ev
  virtual void  v73(); // _ZN6S843C23v73Ev
  virtual void  v74(); // _ZN6S843C23v74Ev
  virtual void  v75(); // _ZN6S843C23v75Ev
  virtual void  v76(); // _ZN6S843C23v76Ev
  virtual void  v77(); // _ZN6S843C23v77Ev
  virtual void  v78(); // _ZN6S843C23v78Ev
  virtual void  v79(); // _ZN6S843C23v79Ev
  virtual void  v80(); // _ZN6S843C23v80Ev
  S843C2(); // tgen
};
//SIG(-1 S843C2) C1{ BC2{ BC3{ BC4{ vd v42 v43 v44} BC5{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FL[4]} Fc} BC9{ vd v71} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC10{ m FL[4]} FC11{ m Fp FC10 FC12{ m Fp FC13{ Fi[4]}} Fi Fc} Fc[3] Fp FC14{ BC15{ vd v74} BC16{ vd v75} vd v72 v73 Fp[2]} Fp}


 S843C2 ::~S843C2(){ note_dtor("S843C2", this);}
void  S843C2 ::v40(){vfunc_called(this, "_ZN6S843C23v40Ev");}
void  S843C2 ::v41(){vfunc_called(this, "_ZN6S843C23v41Ev");}
void  S843C2 ::v42(){vfunc_called(this, "_ZN6S843C23v42Ev");}
void  S843C2 ::v43(){vfunc_called(this, "_ZN6S843C23v43Ev");}
void  S843C2 ::v44(){vfunc_called(this, "_ZN6S843C23v44Ev");}
void  S843C2 ::v45(){vfunc_called(this, "_ZN6S843C23v45Ev");}
void  S843C2 ::v46(){vfunc_called(this, "_ZN6S843C23v46Ev");}
void  S843C2 ::v47(){vfunc_called(this, "_ZN6S843C23v47Ev");}
void  S843C2 ::v48(){vfunc_called(this, "_ZN6S843C23v48Ev");}
void  S843C2 ::v49(){vfunc_called(this, "_ZN6S843C23v49Ev");}
void  S843C2 ::v50(){vfunc_called(this, "_ZN6S843C23v50Ev");}
void  S843C2 ::v51(){vfunc_called(this, "_ZN6S843C23v51Ev");}
void  S843C2 ::v52(){vfunc_called(this, "_ZN6S843C23v52Ev");}
void  S843C2 ::v53(){vfunc_called(this, "_ZN6S843C23v53Ev");}
void  S843C2 ::v54(){vfunc_called(this, "_ZN6S843C23v54Ev");}
void  S843C2 ::v55(){vfunc_called(this, "_ZN6S843C23v55Ev");}
void  S843C2 ::v56(){vfunc_called(this, "_ZN6S843C23v56Ev");}
void  S843C2 ::v57(){vfunc_called(this, "_ZN6S843C23v57Ev");}
void  S843C2 ::v58(){vfunc_called(this, "_ZN6S843C23v58Ev");}
void  S843C2 ::v59(){vfunc_called(this, "_ZN6S843C23v59Ev");}
void  S843C2 ::v60(){vfunc_called(this, "_ZN6S843C23v60Ev");}
void  S843C2 ::v61(){vfunc_called(this, "_ZN6S843C23v61Ev");}
void  S843C2 ::v62(){vfunc_called(this, "_ZN6S843C23v62Ev");}
void  S843C2 ::v63(){vfunc_called(this, "_ZN6S843C23v63Ev");}
void  S843C2 ::v64(){vfunc_called(this, "_ZN6S843C23v64Ev");}
void  S843C2 ::v65(){vfunc_called(this, "_ZN6S843C23v65Ev");}
void  S843C2 ::v66(){vfunc_called(this, "_ZN6S843C23v66Ev");}
void  S843C2 ::v67(){vfunc_called(this, "_ZN6S843C23v67Ev");}
void  S843C2 ::v68(){vfunc_called(this, "_ZN6S843C23v68Ev");}
void  S843C2 ::v69(){vfunc_called(this, "_ZN6S843C23v69Ev");}
void  S843C2 ::v70(){vfunc_called(this, "_ZN6S843C23v70Ev");}
void  S843C2 ::v71(){vfunc_called(this, "_ZN6S843C23v71Ev");}
void  S843C2 ::v72(){vfunc_called(this, "_ZN6S843C23v72Ev");}
void  S843C2 ::v73(){vfunc_called(this, "_ZN6S843C23v73Ev");}
void  S843C2 ::v74(){vfunc_called(this, "_ZN6S843C23v74Ev");}
void  S843C2 ::v75(){vfunc_called(this, "_ZN6S843C23v75Ev");}
void  S843C2 ::v76(){vfunc_called(this, "_ZN6S843C23v76Ev");}
void  S843C2 ::v77(){vfunc_called(this, "_ZN6S843C23v77Ev");}
void  S843C2 ::v78(){vfunc_called(this, "_ZN6S843C23v78Ev");}
void  S843C2 ::v79(){vfunc_called(this, "_ZN6S843C23v79Ev");}
void  S843C2 ::v80(){vfunc_called(this, "_ZN6S843C23v80Ev");}
S843C2 ::S843C2(){ note_ctor("S843C2", this);} // tgen

static void Test_S843C2()
{
  extern Class_Descriptor cd_S843C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S843C2, buf);
    S843C2 *dp, &lv = *(dp=new (buf) S843C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S843C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S843C2)");
    check_base_class_offset(lv, (S843C5*)(S843C4*)(S843C3*), 0, "S843C2");
    check_base_class_offset(lv, (S843C6*)(S843C4*)(S843C3*), ABISELECT(8,4), "S843C2");
    check_base_class_offset(lv, (S843C4*)(S843C3*), 0, "S843C2");
    check_base_class_offset(lv, (S843C3*), 0, "S843C2");
    check_base_class_offset(lv, (S843C10*), ABISELECT(80,60), "S843C2");
    check_field_offset(lv, s843c2f0, ABISELECT(88,64), "S843C2.s843c2f0");
    check_field_offset(lv, s843c2f1, ABISELECT(120,96), "S843C2.s843c2f1");
    check_field_offset(lv, s843c2f2, ABISELECT(192,160), "S843C2.s843c2f2");
    check_field_offset(lv, s843c2f3, ABISELECT(200,164), "S843C2.s843c2f3");
    check_field_offset(lv, s843c2f4, ABISELECT(208,168), "S843C2.s843c2f4");
    check_field_offset(lv, s843c2f5, ABISELECT(240,184), "S843C2.s843c2f5");
    test_class_info(&lv, &cd_S843C2);
    dp->~S843C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS843C2(Test_S843C2, "S843C2", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S843C2C1Ev();
extern void _ZN6S843C2D1Ev();
Name_Map name_map_S843C2[] = {
  NSPAIR(_ZN6S843C2C1Ev),
  NSPAIR(_ZN6S843C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S843C5;
extern VTBL_ENTRY _ZTI6S843C5[];
extern  VTBL_ENTRY _ZTV6S843C5[];
extern Class_Descriptor cd_S843C6;
extern VTBL_ENTRY _ZTI6S843C6[];
extern  VTBL_ENTRY _ZTV6S843C6[];
extern Class_Descriptor cd_S843C4;
extern VTBL_ENTRY _ZTI6S843C4[];
extern  VTBL_ENTRY _ZTV6S843C4[];
extern Class_Descriptor cd_S843C3;
extern VTBL_ENTRY _ZTI6S843C3[];
extern  VTBL_ENTRY _ZTV6S843C3[];
extern Class_Descriptor cd_S843C10;
extern VTBL_ENTRY _ZTI7S843C10[];
extern  VTBL_ENTRY _ZTV7S843C10[];
static Base_Class bases_S843C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S843C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S843C6,    ABISELECT(8,4), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S843C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S843C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S843C10,    ABISELECT(80,60), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S843C2[];
extern void _ZN6S843C2D1Ev();
extern void _ZN6S843C2D0Ev();
extern void _ZN6S843C53v10Ev();
extern void _ZN6S843C53v11Ev();
extern void _ZN6S843C53v12Ev();
extern void _ZN6S843C43v14Ev();
extern void _ZN6S843C43v15Ev();
extern void _ZN6S843C43v16Ev();
extern void _ZN6S843C43v17Ev();
extern void _ZN6S843C43v18Ev();
extern void _ZN6S843C43v19Ev();
extern void _ZN6S843C43v20Ev();
extern void _ZN6S843C43v21Ev();
extern void _ZN6S843C43v22Ev();
extern void _ZN6S843C43v23Ev();
extern void _ZN6S843C43v24Ev();
extern void _ZN6S843C43v25Ev();
extern void _ZN6S843C43v26Ev();
extern void _ZN6S843C43v27Ev();
extern void _ZN6S843C43v28Ev();
extern void _ZN6S843C43v29Ev();
extern void _ZN6S843C43v30Ev();
extern void _ZN6S843C43v31Ev();
extern void _ZN6S843C43v32Ev();
extern void _ZN6S843C43v33Ev();
extern void _ZN6S843C43v34Ev();
extern void _ZN6S843C43v35Ev();
extern void _ZN6S843C33v36Ev();
extern void _ZN6S843C33v37Ev();
extern void _ZN6S843C33v38Ev();
extern void _ZN6S843C23v40Ev();
extern void _ZN6S843C23v41Ev();
extern void _ZN6S843C23v42Ev();
extern void _ZN6S843C23v43Ev();
extern void _ZN6S843C23v44Ev();
extern void _ZN6S843C23v45Ev();
extern void _ZN6S843C23v46Ev();
extern void _ZN6S843C23v47Ev();
extern void _ZN6S843C23v48Ev();
extern void _ZN6S843C23v49Ev();
extern void _ZN6S843C23v50Ev();
extern void _ZN6S843C23v51Ev();
extern void _ZN6S843C23v52Ev();
extern void _ZN6S843C23v53Ev();
extern void _ZN6S843C23v54Ev();
extern void _ZN6S843C23v55Ev();
extern void _ZN6S843C23v56Ev();
extern void _ZN6S843C23v57Ev();
extern void _ZN6S843C23v58Ev();
extern void _ZN6S843C23v59Ev();
extern void _ZN6S843C23v60Ev();
extern void _ZN6S843C23v61Ev();
extern void _ZN6S843C23v62Ev();
extern void _ZN6S843C23v63Ev();
extern void _ZN6S843C23v64Ev();
extern void _ZN6S843C23v65Ev();
extern void _ZN6S843C23v66Ev();
extern void _ZN6S843C23v67Ev();
extern void _ZN6S843C23v68Ev();
extern void _ZN6S843C23v69Ev();
extern void _ZN6S843C23v70Ev();
extern void _ZN6S843C23v71Ev();
extern void _ZN6S843C23v72Ev();
extern void _ZN6S843C23v73Ev();
extern void _ZN6S843C23v74Ev();
extern void _ZN6S843C23v75Ev();
extern void _ZN6S843C23v76Ev();
extern void _ZN6S843C23v77Ev();
extern void _ZN6S843C23v78Ev();
extern void _ZN6S843C23v79Ev();
extern void _ZN6S843C23v80Ev();
extern void ABISELECT(_ZThn8_N6S843C2D1Ev,_ZThn4_N6S843C2D1Ev)();
extern void ABISELECT(_ZThn8_N6S843C2D0Ev,_ZThn4_N6S843C2D0Ev)();
extern void _ZN6S843C63v13Ev();
extern void ABISELECT(_ZThn80_N6S843C2D1Ev,_ZThn60_N6S843C2D1Ev)();
extern void ABISELECT(_ZThn80_N6S843C2D0Ev,_ZThn60_N6S843C2D0Ev)();
extern void _ZN7S843C103v39Ev();
static  VTBL_ENTRY vtc_S843C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S843C2[0]),
  (VTBL_ENTRY)&_ZN6S843C2D1Ev,
  (VTBL_ENTRY)&_ZN6S843C2D0Ev,
  (VTBL_ENTRY)&_ZN6S843C53v10Ev,
  (VTBL_ENTRY)&_ZN6S843C53v11Ev,
  (VTBL_ENTRY)&_ZN6S843C53v12Ev,
  (VTBL_ENTRY)&_ZN6S843C43v14Ev,
  (VTBL_ENTRY)&_ZN6S843C43v15Ev,
  (VTBL_ENTRY)&_ZN6S843C43v16Ev,
  (VTBL_ENTRY)&_ZN6S843C43v17Ev,
  (VTBL_ENTRY)&_ZN6S843C43v18Ev,
  (VTBL_ENTRY)&_ZN6S843C43v19Ev,
  (VTBL_ENTRY)&_ZN6S843C43v20Ev,
  (VTBL_ENTRY)&_ZN6S843C43v21Ev,
  (VTBL_ENTRY)&_ZN6S843C43v22Ev,
  (VTBL_ENTRY)&_ZN6S843C43v23Ev,
  (VTBL_ENTRY)&_ZN6S843C43v24Ev,
  (VTBL_ENTRY)&_ZN6S843C43v25Ev,
  (VTBL_ENTRY)&_ZN6S843C43v26Ev,
  (VTBL_ENTRY)&_ZN6S843C43v27Ev,
  (VTBL_ENTRY)&_ZN6S843C43v28Ev,
  (VTBL_ENTRY)&_ZN6S843C43v29Ev,
  (VTBL_ENTRY)&_ZN6S843C43v30Ev,
  (VTBL_ENTRY)&_ZN6S843C43v31Ev,
  (VTBL_ENTRY)&_ZN6S843C43v32Ev,
  (VTBL_ENTRY)&_ZN6S843C43v33Ev,
  (VTBL_ENTRY)&_ZN6S843C43v34Ev,
  (VTBL_ENTRY)&_ZN6S843C43v35Ev,
  (VTBL_ENTRY)&_ZN6S843C33v36Ev,
  (VTBL_ENTRY)&_ZN6S843C33v37Ev,
  (VTBL_ENTRY)&_ZN6S843C33v38Ev,
  (VTBL_ENTRY)&_ZN6S843C23v40Ev,
  (VTBL_ENTRY)&_ZN6S843C23v41Ev,
  (VTBL_ENTRY)&_ZN6S843C23v42Ev,
  (VTBL_ENTRY)&_ZN6S843C23v43Ev,
  (VTBL_ENTRY)&_ZN6S843C23v44Ev,
  (VTBL_ENTRY)&_ZN6S843C23v45Ev,
  (VTBL_ENTRY)&_ZN6S843C23v46Ev,
  (VTBL_ENTRY)&_ZN6S843C23v47Ev,
  (VTBL_ENTRY)&_ZN6S843C23v48Ev,
  (VTBL_ENTRY)&_ZN6S843C23v49Ev,
  (VTBL_ENTRY)&_ZN6S843C23v50Ev,
  (VTBL_ENTRY)&_ZN6S843C23v51Ev,
  (VTBL_ENTRY)&_ZN6S843C23v52Ev,
  (VTBL_ENTRY)&_ZN6S843C23v53Ev,
  (VTBL_ENTRY)&_ZN6S843C23v54Ev,
  (VTBL_ENTRY)&_ZN6S843C23v55Ev,
  (VTBL_ENTRY)&_ZN6S843C23v56Ev,
  (VTBL_ENTRY)&_ZN6S843C23v57Ev,
  (VTBL_ENTRY)&_ZN6S843C23v58Ev,
  (VTBL_ENTRY)&_ZN6S843C23v59Ev,
  (VTBL_ENTRY)&_ZN6S843C23v60Ev,
  (VTBL_ENTRY)&_ZN6S843C23v61Ev,
  (VTBL_ENTRY)&_ZN6S843C23v62Ev,
  (VTBL_ENTRY)&_ZN6S843C23v63Ev,
  (VTBL_ENTRY)&_ZN6S843C23v64Ev,
  (VTBL_ENTRY)&_ZN6S843C23v65Ev,
  (VTBL_ENTRY)&_ZN6S843C23v66Ev,
  (VTBL_ENTRY)&_ZN6S843C23v67Ev,
  (VTBL_ENTRY)&_ZN6S843C23v68Ev,
  (VTBL_ENTRY)&_ZN6S843C23v69Ev,
  (VTBL_ENTRY)&_ZN6S843C23v70Ev,
  (VTBL_ENTRY)&_ZN6S843C23v71Ev,
  (VTBL_ENTRY)&_ZN6S843C23v72Ev,
  (VTBL_ENTRY)&_ZN6S843C23v73Ev,
  (VTBL_ENTRY)&_ZN6S843C23v74Ev,
  (VTBL_ENTRY)&_ZN6S843C23v75Ev,
  (VTBL_ENTRY)&_ZN6S843C23v76Ev,
  (VTBL_ENTRY)&_ZN6S843C23v77Ev,
  (VTBL_ENTRY)&_ZN6S843C23v78Ev,
  (VTBL_ENTRY)&_ZN6S843C23v79Ev,
  (VTBL_ENTRY)&_ZN6S843C23v80Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S843C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C2D1Ev,_ZThn4_N6S843C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C2D0Ev,_ZThn4_N6S843C2D0Ev),
  (VTBL_ENTRY)&_ZN6S843C63v13Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S843C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S843C2D1Ev,_ZThn60_N6S843C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S843C2D0Ev,_ZThn60_N6S843C2D0Ev),
  (VTBL_ENTRY)&_ZN7S843C103v39Ev,
};
extern VTBL_ENTRY _ZTI6S843C2[];
extern  VTBL_ENTRY _ZTV6S843C2[];
Class_Descriptor cd_S843C2 = {  "S843C2", // class name
  bases_S843C2, 5,
  &(vtc_S843C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S843C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S843C2),83, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S843C1  : S843C2 {
  char s843c1f0;
  virtual  ~S843C1(); // _ZN6S843C1D1Ev
  virtual void  v1(); // _ZN6S843C12v1Ev
  virtual void  v2(); // _ZN6S843C12v2Ev
  virtual void  v3(); // _ZN6S843C12v3Ev
  virtual void  v4(); // _ZN6S843C12v4Ev
  virtual void  v5(); // _ZN6S843C12v5Ev
  virtual void  v6(); // _ZN6S843C12v6Ev
  virtual void  v7(); // _ZN6S843C12v7Ev
  virtual void  v8(); // _ZN6S843C12v8Ev
  virtual void  v9(); // _ZN6S843C12v9Ev
  S843C1(); // tgen
};
//SIG(1 S843C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v10 v11 v12} BC6{ vd v13} vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35} vd v36 v37 v38 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v39} vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 FC11{ m FL[4]} FC12{ m Fp FC11 FC13{ m Fp FC14{ Fi[4]}} Fi Fc} Fc[3] Fp FC15{ BC16{ vd v83} BC17{ vd v84} vd v81 v82 Fp[2]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fc}


 S843C1 ::~S843C1(){ note_dtor("S843C1", this);}
void  S843C1 ::v1(){vfunc_called(this, "_ZN6S843C12v1Ev");}
void  S843C1 ::v2(){vfunc_called(this, "_ZN6S843C12v2Ev");}
void  S843C1 ::v3(){vfunc_called(this, "_ZN6S843C12v3Ev");}
void  S843C1 ::v4(){vfunc_called(this, "_ZN6S843C12v4Ev");}
void  S843C1 ::v5(){vfunc_called(this, "_ZN6S843C12v5Ev");}
void  S843C1 ::v6(){vfunc_called(this, "_ZN6S843C12v6Ev");}
void  S843C1 ::v7(){vfunc_called(this, "_ZN6S843C12v7Ev");}
void  S843C1 ::v8(){vfunc_called(this, "_ZN6S843C12v8Ev");}
void  S843C1 ::v9(){vfunc_called(this, "_ZN6S843C12v9Ev");}
S843C1 ::S843C1(){ note_ctor("S843C1", this);} // tgen

static void Test_S843C1()
{
  extern Class_Descriptor cd_S843C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,49)];
    init_test(&cd_S843C1, buf);
    S843C1 *dp, &lv = *(dp=new (buf) S843C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,192), "sizeof(S843C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S843C1)");
    check_base_class_offset(lv, (S843C5*)(S843C4*)(S843C3*)(S843C2*), 0, "S843C1");
    check_base_class_offset(lv, (S843C6*)(S843C4*)(S843C3*)(S843C2*), ABISELECT(8,4), "S843C1");
    check_base_class_offset(lv, (S843C4*)(S843C3*)(S843C2*), 0, "S843C1");
    check_base_class_offset(lv, (S843C3*)(S843C2*), 0, "S843C1");
    check_base_class_offset(lv, (S843C10*)(S843C2*), ABISELECT(80,60), "S843C1");
    check_base_class_offset(lv, (S843C2*), 0, "S843C1");
    check_field_offset(lv, s843c1f0, ABISELECT(248,188), "S843C1.s843c1f0");
    test_class_info(&lv, &cd_S843C1);
    dp->~S843C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS843C1(Test_S843C1, "S843C1", ABISELECT(256,192));

#else // __cplusplus

extern void _ZN6S843C1C1Ev();
extern void _ZN6S843C1D1Ev();
Name_Map name_map_S843C1[] = {
  NSPAIR(_ZN6S843C1C1Ev),
  NSPAIR(_ZN6S843C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S843C5;
extern VTBL_ENTRY _ZTI6S843C5[];
extern  VTBL_ENTRY _ZTV6S843C5[];
extern Class_Descriptor cd_S843C6;
extern VTBL_ENTRY _ZTI6S843C6[];
extern  VTBL_ENTRY _ZTV6S843C6[];
extern Class_Descriptor cd_S843C4;
extern VTBL_ENTRY _ZTI6S843C4[];
extern  VTBL_ENTRY _ZTV6S843C4[];
extern Class_Descriptor cd_S843C3;
extern VTBL_ENTRY _ZTI6S843C3[];
extern  VTBL_ENTRY _ZTV6S843C3[];
extern Class_Descriptor cd_S843C10;
extern VTBL_ENTRY _ZTI7S843C10[];
extern  VTBL_ENTRY _ZTV7S843C10[];
extern Class_Descriptor cd_S843C2;
extern VTBL_ENTRY _ZTI6S843C2[];
extern  VTBL_ENTRY _ZTV6S843C2[];
static Base_Class bases_S843C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S843C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S843C6,    ABISELECT(8,4), //bcp->offset
    82, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S843C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S843C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S843C10,    ABISELECT(80,60), //bcp->offset
    87, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S843C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S843C1[];
extern void _ZN6S843C1D1Ev();
extern void _ZN6S843C1D0Ev();
extern void _ZN6S843C53v10Ev();
extern void _ZN6S843C53v11Ev();
extern void _ZN6S843C53v12Ev();
extern void _ZN6S843C43v14Ev();
extern void _ZN6S843C43v15Ev();
extern void _ZN6S843C43v16Ev();
extern void _ZN6S843C43v17Ev();
extern void _ZN6S843C43v18Ev();
extern void _ZN6S843C43v19Ev();
extern void _ZN6S843C43v20Ev();
extern void _ZN6S843C43v21Ev();
extern void _ZN6S843C43v22Ev();
extern void _ZN6S843C43v23Ev();
extern void _ZN6S843C43v24Ev();
extern void _ZN6S843C43v25Ev();
extern void _ZN6S843C43v26Ev();
extern void _ZN6S843C43v27Ev();
extern void _ZN6S843C43v28Ev();
extern void _ZN6S843C43v29Ev();
extern void _ZN6S843C43v30Ev();
extern void _ZN6S843C43v31Ev();
extern void _ZN6S843C43v32Ev();
extern void _ZN6S843C43v33Ev();
extern void _ZN6S843C43v34Ev();
extern void _ZN6S843C43v35Ev();
extern void _ZN6S843C33v36Ev();
extern void _ZN6S843C33v37Ev();
extern void _ZN6S843C33v38Ev();
extern void _ZN6S843C23v40Ev();
extern void _ZN6S843C23v41Ev();
extern void _ZN6S843C23v42Ev();
extern void _ZN6S843C23v43Ev();
extern void _ZN6S843C23v44Ev();
extern void _ZN6S843C23v45Ev();
extern void _ZN6S843C23v46Ev();
extern void _ZN6S843C23v47Ev();
extern void _ZN6S843C23v48Ev();
extern void _ZN6S843C23v49Ev();
extern void _ZN6S843C23v50Ev();
extern void _ZN6S843C23v51Ev();
extern void _ZN6S843C23v52Ev();
extern void _ZN6S843C23v53Ev();
extern void _ZN6S843C23v54Ev();
extern void _ZN6S843C23v55Ev();
extern void _ZN6S843C23v56Ev();
extern void _ZN6S843C23v57Ev();
extern void _ZN6S843C23v58Ev();
extern void _ZN6S843C23v59Ev();
extern void _ZN6S843C23v60Ev();
extern void _ZN6S843C23v61Ev();
extern void _ZN6S843C23v62Ev();
extern void _ZN6S843C23v63Ev();
extern void _ZN6S843C23v64Ev();
extern void _ZN6S843C23v65Ev();
extern void _ZN6S843C23v66Ev();
extern void _ZN6S843C23v67Ev();
extern void _ZN6S843C23v68Ev();
extern void _ZN6S843C23v69Ev();
extern void _ZN6S843C23v70Ev();
extern void _ZN6S843C23v71Ev();
extern void _ZN6S843C23v72Ev();
extern void _ZN6S843C23v73Ev();
extern void _ZN6S843C23v74Ev();
extern void _ZN6S843C23v75Ev();
extern void _ZN6S843C23v76Ev();
extern void _ZN6S843C23v77Ev();
extern void _ZN6S843C23v78Ev();
extern void _ZN6S843C23v79Ev();
extern void _ZN6S843C23v80Ev();
extern void _ZN6S843C12v1Ev();
extern void _ZN6S843C12v2Ev();
extern void _ZN6S843C12v3Ev();
extern void _ZN6S843C12v4Ev();
extern void _ZN6S843C12v5Ev();
extern void _ZN6S843C12v6Ev();
extern void _ZN6S843C12v7Ev();
extern void _ZN6S843C12v8Ev();
extern void _ZN6S843C12v9Ev();
extern void ABISELECT(_ZThn8_N6S843C1D1Ev,_ZThn4_N6S843C1D1Ev)();
extern void ABISELECT(_ZThn8_N6S843C1D0Ev,_ZThn4_N6S843C1D0Ev)();
extern void _ZN6S843C63v13Ev();
extern void ABISELECT(_ZThn80_N6S843C1D1Ev,_ZThn60_N6S843C1D1Ev)();
extern void ABISELECT(_ZThn80_N6S843C1D0Ev,_ZThn60_N6S843C1D0Ev)();
extern void _ZN7S843C103v39Ev();
static  VTBL_ENTRY vtc_S843C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S843C1[0]),
  (VTBL_ENTRY)&_ZN6S843C1D1Ev,
  (VTBL_ENTRY)&_ZN6S843C1D0Ev,
  (VTBL_ENTRY)&_ZN6S843C53v10Ev,
  (VTBL_ENTRY)&_ZN6S843C53v11Ev,
  (VTBL_ENTRY)&_ZN6S843C53v12Ev,
  (VTBL_ENTRY)&_ZN6S843C43v14Ev,
  (VTBL_ENTRY)&_ZN6S843C43v15Ev,
  (VTBL_ENTRY)&_ZN6S843C43v16Ev,
  (VTBL_ENTRY)&_ZN6S843C43v17Ev,
  (VTBL_ENTRY)&_ZN6S843C43v18Ev,
  (VTBL_ENTRY)&_ZN6S843C43v19Ev,
  (VTBL_ENTRY)&_ZN6S843C43v20Ev,
  (VTBL_ENTRY)&_ZN6S843C43v21Ev,
  (VTBL_ENTRY)&_ZN6S843C43v22Ev,
  (VTBL_ENTRY)&_ZN6S843C43v23Ev,
  (VTBL_ENTRY)&_ZN6S843C43v24Ev,
  (VTBL_ENTRY)&_ZN6S843C43v25Ev,
  (VTBL_ENTRY)&_ZN6S843C43v26Ev,
  (VTBL_ENTRY)&_ZN6S843C43v27Ev,
  (VTBL_ENTRY)&_ZN6S843C43v28Ev,
  (VTBL_ENTRY)&_ZN6S843C43v29Ev,
  (VTBL_ENTRY)&_ZN6S843C43v30Ev,
  (VTBL_ENTRY)&_ZN6S843C43v31Ev,
  (VTBL_ENTRY)&_ZN6S843C43v32Ev,
  (VTBL_ENTRY)&_ZN6S843C43v33Ev,
  (VTBL_ENTRY)&_ZN6S843C43v34Ev,
  (VTBL_ENTRY)&_ZN6S843C43v35Ev,
  (VTBL_ENTRY)&_ZN6S843C33v36Ev,
  (VTBL_ENTRY)&_ZN6S843C33v37Ev,
  (VTBL_ENTRY)&_ZN6S843C33v38Ev,
  (VTBL_ENTRY)&_ZN6S843C23v40Ev,
  (VTBL_ENTRY)&_ZN6S843C23v41Ev,
  (VTBL_ENTRY)&_ZN6S843C23v42Ev,
  (VTBL_ENTRY)&_ZN6S843C23v43Ev,
  (VTBL_ENTRY)&_ZN6S843C23v44Ev,
  (VTBL_ENTRY)&_ZN6S843C23v45Ev,
  (VTBL_ENTRY)&_ZN6S843C23v46Ev,
  (VTBL_ENTRY)&_ZN6S843C23v47Ev,
  (VTBL_ENTRY)&_ZN6S843C23v48Ev,
  (VTBL_ENTRY)&_ZN6S843C23v49Ev,
  (VTBL_ENTRY)&_ZN6S843C23v50Ev,
  (VTBL_ENTRY)&_ZN6S843C23v51Ev,
  (VTBL_ENTRY)&_ZN6S843C23v52Ev,
  (VTBL_ENTRY)&_ZN6S843C23v53Ev,
  (VTBL_ENTRY)&_ZN6S843C23v54Ev,
  (VTBL_ENTRY)&_ZN6S843C23v55Ev,
  (VTBL_ENTRY)&_ZN6S843C23v56Ev,
  (VTBL_ENTRY)&_ZN6S843C23v57Ev,
  (VTBL_ENTRY)&_ZN6S843C23v58Ev,
  (VTBL_ENTRY)&_ZN6S843C23v59Ev,
  (VTBL_ENTRY)&_ZN6S843C23v60Ev,
  (VTBL_ENTRY)&_ZN6S843C23v61Ev,
  (VTBL_ENTRY)&_ZN6S843C23v62Ev,
  (VTBL_ENTRY)&_ZN6S843C23v63Ev,
  (VTBL_ENTRY)&_ZN6S843C23v64Ev,
  (VTBL_ENTRY)&_ZN6S843C23v65Ev,
  (VTBL_ENTRY)&_ZN6S843C23v66Ev,
  (VTBL_ENTRY)&_ZN6S843C23v67Ev,
  (VTBL_ENTRY)&_ZN6S843C23v68Ev,
  (VTBL_ENTRY)&_ZN6S843C23v69Ev,
  (VTBL_ENTRY)&_ZN6S843C23v70Ev,
  (VTBL_ENTRY)&_ZN6S843C23v71Ev,
  (VTBL_ENTRY)&_ZN6S843C23v72Ev,
  (VTBL_ENTRY)&_ZN6S843C23v73Ev,
  (VTBL_ENTRY)&_ZN6S843C23v74Ev,
  (VTBL_ENTRY)&_ZN6S843C23v75Ev,
  (VTBL_ENTRY)&_ZN6S843C23v76Ev,
  (VTBL_ENTRY)&_ZN6S843C23v77Ev,
  (VTBL_ENTRY)&_ZN6S843C23v78Ev,
  (VTBL_ENTRY)&_ZN6S843C23v79Ev,
  (VTBL_ENTRY)&_ZN6S843C23v80Ev,
  (VTBL_ENTRY)&_ZN6S843C12v1Ev,
  (VTBL_ENTRY)&_ZN6S843C12v2Ev,
  (VTBL_ENTRY)&_ZN6S843C12v3Ev,
  (VTBL_ENTRY)&_ZN6S843C12v4Ev,
  (VTBL_ENTRY)&_ZN6S843C12v5Ev,
  (VTBL_ENTRY)&_ZN6S843C12v6Ev,
  (VTBL_ENTRY)&_ZN6S843C12v7Ev,
  (VTBL_ENTRY)&_ZN6S843C12v8Ev,
  (VTBL_ENTRY)&_ZN6S843C12v9Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S843C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C1D1Ev,_ZThn4_N6S843C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S843C1D0Ev,_ZThn4_N6S843C1D0Ev),
  (VTBL_ENTRY)&_ZN6S843C63v13Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S843C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S843C1D1Ev,_ZThn60_N6S843C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S843C1D0Ev,_ZThn60_N6S843C1D0Ev),
  (VTBL_ENTRY)&_ZN7S843C103v39Ev,
};
extern VTBL_ENTRY _ZTI6S843C1[];
extern  VTBL_ENTRY _ZTV6S843C1[];
Class_Descriptor cd_S843C1 = {  "S843C1", // class name
  bases_S843C1, 6,
  &(vtc_S843C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,192), // object size
  NSPAIRA(_ZTI6S843C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S843C1),92, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S844C5  {
  virtual  ~S844C5(); // _ZN6S844C5D1Ev
  virtual void  v10(); // _ZN6S844C53v10Ev
  virtual void  v11(); // _ZN6S844C53v11Ev
  virtual void  v12(); // _ZN6S844C53v12Ev
  S844C5(); // tgen
};
//SIG(-1 S844C5) C1{ vd v1 v2 v3}


 S844C5 ::~S844C5(){ note_dtor("S844C5", this);}
void  S844C5 ::v10(){vfunc_called(this, "_ZN6S844C53v10Ev");}
void  S844C5 ::v11(){vfunc_called(this, "_ZN6S844C53v11Ev");}
void  S844C5 ::v12(){vfunc_called(this, "_ZN6S844C53v12Ev");}
S844C5 ::S844C5(){ note_ctor("S844C5", this);} // tgen

static void Test_S844C5()
{
  extern Class_Descriptor cd_S844C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S844C5, buf);
    S844C5 *dp, &lv = *(dp=new (buf) S844C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S844C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S844C5)");
    test_class_info(&lv, &cd_S844C5);
    dp->~S844C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS844C5(Test_S844C5, "S844C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S844C5C1Ev();
extern void _ZN6S844C5D1Ev();
Name_Map name_map_S844C5[] = {
  NSPAIR(_ZN6S844C5C1Ev),
  NSPAIR(_ZN6S844C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S844C5[];
extern void _ZN6S844C5D1Ev();
extern void _ZN6S844C5D0Ev();
extern void _ZN6S844C53v10Ev();
extern void _ZN6S844C53v11Ev();
extern void _ZN6S844C53v12Ev();
static  VTBL_ENTRY vtc_S844C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S844C5[0]),
  (VTBL_ENTRY)&_ZN6S844C5D1Ev,
  (VTBL_ENTRY)&_ZN6S844C5D0Ev,
  (VTBL_ENTRY)&_ZN6S844C53v10Ev,
  (VTBL_ENTRY)&_ZN6S844C53v11Ev,
  (VTBL_ENTRY)&_ZN6S844C53v12Ev,
};
extern VTBL_ENTRY _ZTI6S844C5[];
extern  VTBL_ENTRY _ZTV6S844C5[];
Class_Descriptor cd_S844C5 = {  "S844C5", // class name
  0,0,//no base classes
  &(vtc_S844C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S844C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S844C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S844C6  {
  virtual  ~S844C6(); // _ZN6S844C6D1Ev
  virtual void  v13(); // _ZN6S844C63v13Ev
  S844C6(); // tgen
};
//SIG(-1 S844C6) C1{ vd v1}


 S844C6 ::~S844C6(){ note_dtor("S844C6", this);}
void  S844C6 ::v13(){vfunc_called(this, "_ZN6S844C63v13Ev");}
S844C6 ::S844C6(){ note_ctor("S844C6", this);} // tgen

static void Test_S844C6()
{
  extern Class_Descriptor cd_S844C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S844C6, buf);
    S844C6 *dp, &lv = *(dp=new (buf) S844C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S844C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S844C6)");
    test_class_info(&lv, &cd_S844C6);
    dp->~S844C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS844C6(Test_S844C6, "S844C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S844C6C1Ev();
extern void _ZN6S844C6D1Ev();
Name_Map name_map_S844C6[] = {
  NSPAIR(_ZN6S844C6C1Ev),
  NSPAIR(_ZN6S844C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S844C6[];
extern void _ZN6S844C6D1Ev();
extern void _ZN6S844C6D0Ev();
extern void _ZN6S844C63v13Ev();
static  VTBL_ENTRY vtc_S844C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S844C6[0]),
  (VTBL_ENTRY)&_ZN6S844C6D1Ev,
  (VTBL_ENTRY)&_ZN6S844C6D0Ev,
  (VTBL_ENTRY)&_ZN6S844C63v13Ev,
};
extern VTBL_ENTRY _ZTI6S844C6[];
extern  VTBL_ENTRY _ZTV6S844C6[];
Class_Descriptor cd_S844C6 = {  "S844C6", // class name
  0,0,//no base classes
  &(vtc_S844C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S844C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S844C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S844C4  : S844C5 , S844C6 {
  virtual  ~S844C4(); // _ZN6S844C4D1Ev
  virtual void  v14(); // _ZN6S844C43v14Ev
  virtual void  v15(); // _ZN6S844C43v15Ev
  virtual void  v16(); // _ZN6S844C43v16Ev
  virtual void  v17(); // _ZN6S844C43v17Ev
  virtual void  v18(); // _ZN6S844C43v18Ev
  virtual void  v19(); // _ZN6S844C43v19Ev
  virtual void  v20(); // _ZN6S844C43v20Ev
  virtual void  v21(); // _ZN6S844C43v21Ev
  virtual void  v22(); // _ZN6S844C43v22Ev
  virtual void  v23(); // _ZN6S844C43v23Ev
  virtual void  v24(); // _ZN6S844C43v24Ev
  virtual void  v25(); // _ZN6S844C43v25Ev
  virtual void  v26(); // _ZN6S844C43v26Ev
  virtual void  v27(); // _ZN6S844C43v27Ev
  virtual void  v28(); // _ZN6S844C43v28Ev
  virtual void  v29(); // _ZN6S844C43v29Ev
  virtual void  v30(); // _ZN6S844C43v30Ev
  virtual void  v31(); // _ZN6S844C43v31Ev
  virtual void  v32(); // _ZN6S844C43v32Ev
  virtual void  v33(); // _ZN6S844C43v33Ev
  virtual void  v34(); // _ZN6S844C43v34Ev
  virtual void  v35(); // _ZN6S844C43v35Ev
  S844C4(); // tgen
};
//SIG(-1 S844C4) C1{ BC2{ vd v23 v24 v25} BC3{ vd v26} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22}


 S844C4 ::~S844C4(){ note_dtor("S844C4", this);}
void  S844C4 ::v14(){vfunc_called(this, "_ZN6S844C43v14Ev");}
void  S844C4 ::v15(){vfunc_called(this, "_ZN6S844C43v15Ev");}
void  S844C4 ::v16(){vfunc_called(this, "_ZN6S844C43v16Ev");}
void  S844C4 ::v17(){vfunc_called(this, "_ZN6S844C43v17Ev");}
void  S844C4 ::v18(){vfunc_called(this, "_ZN6S844C43v18Ev");}
void  S844C4 ::v19(){vfunc_called(this, "_ZN6S844C43v19Ev");}
void  S844C4 ::v20(){vfunc_called(this, "_ZN6S844C43v20Ev");}
void  S844C4 ::v21(){vfunc_called(this, "_ZN6S844C43v21Ev");}
void  S844C4 ::v22(){vfunc_called(this, "_ZN6S844C43v22Ev");}
void  S844C4 ::v23(){vfunc_called(this, "_ZN6S844C43v23Ev");}
void  S844C4 ::v24(){vfunc_called(this, "_ZN6S844C43v24Ev");}
void  S844C4 ::v25(){vfunc_called(this, "_ZN6S844C43v25Ev");}
void  S844C4 ::v26(){vfunc_called(this, "_ZN6S844C43v26Ev");}
void  S844C4 ::v27(){vfunc_called(this, "_ZN6S844C43v27Ev");}
void  S844C4 ::v28(){vfunc_called(this, "_ZN6S844C43v28Ev");}
void  S844C4 ::v29(){vfunc_called(this, "_ZN6S844C43v29Ev");}
void  S844C4 ::v30(){vfunc_called(this, "_ZN6S844C43v30Ev");}
void  S844C4 ::v31(){vfunc_called(this, "_ZN6S844C43v31Ev");}
void  S844C4 ::v32(){vfunc_called(this, "_ZN6S844C43v32Ev");}
void  S844C4 ::v33(){vfunc_called(this, "_ZN6S844C43v33Ev");}
void  S844C4 ::v34(){vfunc_called(this, "_ZN6S844C43v34Ev");}
void  S844C4 ::v35(){vfunc_called(this, "_ZN6S844C43v35Ev");}
S844C4 ::S844C4(){ note_ctor("S844C4", this);} // tgen

static void Test_S844C4()
{
  extern Class_Descriptor cd_S844C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S844C4, buf);
    S844C4 *dp, &lv = *(dp=new (buf) S844C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S844C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S844C4)");
    check_base_class_offset(lv, (S844C5*), 0, "S844C4");
    check_base_class_offset(lv, (S844C6*), ABISELECT(8,4), "S844C4");
    test_class_info(&lv, &cd_S844C4);
    dp->~S844C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS844C4(Test_S844C4, "S844C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN6S844C4C1Ev();
extern void _ZN6S844C4D1Ev();
Name_Map name_map_S844C4[] = {
  NSPAIR(_ZN6S844C4C1Ev),
  NSPAIR(_ZN6S844C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S844C5;
extern VTBL_ENTRY _ZTI6S844C5[];
extern  VTBL_ENTRY _ZTV6S844C5[];
extern Class_Descriptor cd_S844C6;
extern VTBL_ENTRY _ZTI6S844C6[];
extern  VTBL_ENTRY _ZTV6S844C6[];
static Base_Class bases_S844C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S844C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S844C6,    ABISELECT(8,4), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S844C4[];
extern void _ZN6S844C4D1Ev();
extern void _ZN6S844C4D0Ev();
extern void _ZN6S844C53v10Ev();
extern void _ZN6S844C53v11Ev();
extern void _ZN6S844C53v12Ev();
extern void _ZN6S844C43v14Ev();
extern void _ZN6S844C43v15Ev();
extern void _ZN6S844C43v16Ev();
extern void _ZN6S844C43v17Ev();
extern void _ZN6S844C43v18Ev();
extern void _ZN6S844C43v19Ev();
extern void _ZN6S844C43v20Ev();
extern void _ZN6S844C43v21Ev();
extern void _ZN6S844C43v22Ev();
extern void _ZN6S844C43v23Ev();
extern void _ZN6S844C43v24Ev();
extern void _ZN6S844C43v25Ev();
extern void _ZN6S844C43v26Ev();
extern void _ZN6S844C43v27Ev();
extern void _ZN6S844C43v28Ev();
extern void _ZN6S844C43v29Ev();
extern void _ZN6S844C43v30Ev();
extern void _ZN6S844C43v31Ev();
extern void _ZN6S844C43v32Ev();
extern void _ZN6S844C43v33Ev();
extern void _ZN6S844C43v34Ev();
extern void _ZN6S844C43v35Ev();
extern void ABISELECT(_ZThn8_N6S844C4D1Ev,_ZThn4_N6S844C4D1Ev)();
extern void ABISELECT(_ZThn8_N6S844C4D0Ev,_ZThn4_N6S844C4D0Ev)();
extern void _ZN6S844C63v13Ev();
static  VTBL_ENTRY vtc_S844C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S844C4[0]),
  (VTBL_ENTRY)&_ZN6S844C4D1Ev,
  (VTBL_ENTRY)&_ZN6S844C4D0Ev,
  (VTBL_ENTRY)&_ZN6S844C53v10Ev,
  (VTBL_ENTRY)&_ZN6S844C53v11Ev,
  (VTBL_ENTRY)&_ZN6S844C53v12Ev,
  (VTBL_ENTRY)&_ZN6S844C43v14Ev,
  (VTBL_ENTRY)&_ZN6S844C43v15Ev,
  (VTBL_ENTRY)&_ZN6S844C43v16Ev,
  (VTBL_ENTRY)&_ZN6S844C43v17Ev,
  (VTBL_ENTRY)&_ZN6S844C43v18Ev,
  (VTBL_ENTRY)&_ZN6S844C43v19Ev,
  (VTBL_ENTRY)&_ZN6S844C43v20Ev,
  (VTBL_ENTRY)&_ZN6S844C43v21Ev,
  (VTBL_ENTRY)&_ZN6S844C43v22Ev,
  (VTBL_ENTRY)&_ZN6S844C43v23Ev,
  (VTBL_ENTRY)&_ZN6S844C43v24Ev,
  (VTBL_ENTRY)&_ZN6S844C43v25Ev,
  (VTBL_ENTRY)&_ZN6S844C43v26Ev,
  (VTBL_ENTRY)&_ZN6S844C43v27Ev,
  (VTBL_ENTRY)&_ZN6S844C43v28Ev,
  (VTBL_ENTRY)&_ZN6S844C43v29Ev,
  (VTBL_ENTRY)&_ZN6S844C43v30Ev,
  (VTBL_ENTRY)&_ZN6S844C43v31Ev,
  (VTBL_ENTRY)&_ZN6S844C43v32Ev,
  (VTBL_ENTRY)&_ZN6S844C43v33Ev,
  (VTBL_ENTRY)&_ZN6S844C43v34Ev,
  (VTBL_ENTRY)&_ZN6S844C43v35Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S844C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C4D1Ev,_ZThn4_N6S844C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C4D0Ev,_ZThn4_N6S844C4D0Ev),
  (VTBL_ENTRY)&_ZN6S844C63v13Ev,
};
extern VTBL_ENTRY _ZTI6S844C4[];
extern  VTBL_ENTRY _ZTV6S844C4[];
Class_Descriptor cd_S844C4 = {  "S844C4", // class name
  bases_S844C4, 2,
  &(vtc_S844C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI6S844C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S844C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S844C3  : S844C4 {
  ::S858C7_nt s844c3f0;
  ::S9124C5_nt s844c3f1;
  char s844c3f2;
  virtual  ~S844C3(); // _ZN6S844C3D1Ev
  virtual void  v36(); // _ZN6S844C33v36Ev
  virtual void  v37(); // _ZN6S844C33v37Ev
  virtual void  v38(); // _ZN6S844C33v38Ev
  S844C3(); // tgen
};
//SIG(-1 S844C3) C1{ BC2{ BC3{ vd v4 v5 v6} BC4{ vd v7} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29} vd v1 v2 v3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc}


 S844C3 ::~S844C3(){ note_dtor("S844C3", this);}
void  S844C3 ::v36(){vfunc_called(this, "_ZN6S844C33v36Ev");}
void  S844C3 ::v37(){vfunc_called(this, "_ZN6S844C33v37Ev");}
void  S844C3 ::v38(){vfunc_called(this, "_ZN6S844C33v38Ev");}
S844C3 ::S844C3(){ note_ctor("S844C3", this);} // tgen

static void Test_S844C3()
{
  extern Class_Descriptor cd_S844C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S844C3, buf);
    S844C3 *dp, &lv = *(dp=new (buf) S844C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S844C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S844C3)");
    check_base_class_offset(lv, (S844C5*)(S844C4*), 0, "S844C3");
    check_base_class_offset(lv, (S844C6*)(S844C4*), ABISELECT(8,4), "S844C3");
    check_base_class_offset(lv, (S844C4*), 0, "S844C3");
    check_field_offset(lv, s844c3f0, ABISELECT(16,8), "S844C3.s844c3f0");
    check_field_offset(lv, s844c3f1, ABISELECT(40,24), "S844C3.s844c3f1");
    check_field_offset(lv, s844c3f2, ABISELECT(72,56), "S844C3.s844c3f2");
    test_class_info(&lv, &cd_S844C3);
    dp->~S844C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS844C3(Test_S844C3, "S844C3", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN6S844C3C1Ev();
extern void _ZN6S844C3D1Ev();
Name_Map name_map_S844C3[] = {
  NSPAIR(_ZN6S844C3C1Ev),
  NSPAIR(_ZN6S844C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S844C5;
extern VTBL_ENTRY _ZTI6S844C5[];
extern  VTBL_ENTRY _ZTV6S844C5[];
extern Class_Descriptor cd_S844C6;
extern VTBL_ENTRY _ZTI6S844C6[];
extern  VTBL_ENTRY _ZTV6S844C6[];
extern Class_Descriptor cd_S844C4;
extern VTBL_ENTRY _ZTI6S844C4[];
extern  VTBL_ENTRY _ZTV6S844C4[];
static Base_Class bases_S844C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S844C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S844C6,    ABISELECT(8,4), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S844C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S844C3[];
extern void _ZN6S844C3D1Ev();
extern void _ZN6S844C3D0Ev();
extern void _ZN6S844C53v10Ev();
extern void _ZN6S844C53v11Ev();
extern void _ZN6S844C53v12Ev();
extern void _ZN6S844C43v14Ev();
extern void _ZN6S844C43v15Ev();
extern void _ZN6S844C43v16Ev();
extern void _ZN6S844C43v17Ev();
extern void _ZN6S844C43v18Ev();
extern void _ZN6S844C43v19Ev();
extern void _ZN6S844C43v20Ev();
extern void _ZN6S844C43v21Ev();
extern void _ZN6S844C43v22Ev();
extern void _ZN6S844C43v23Ev();
extern void _ZN6S844C43v24Ev();
extern void _ZN6S844C43v25Ev();
extern void _ZN6S844C43v26Ev();
extern void _ZN6S844C43v27Ev();
extern void _ZN6S844C43v28Ev();
extern void _ZN6S844C43v29Ev();
extern void _ZN6S844C43v30Ev();
extern void _ZN6S844C43v31Ev();
extern void _ZN6S844C43v32Ev();
extern void _ZN6S844C43v33Ev();
extern void _ZN6S844C43v34Ev();
extern void _ZN6S844C43v35Ev();
extern void _ZN6S844C33v36Ev();
extern void _ZN6S844C33v37Ev();
extern void _ZN6S844C33v38Ev();
extern void ABISELECT(_ZThn8_N6S844C3D1Ev,_ZThn4_N6S844C3D1Ev)();
extern void ABISELECT(_ZThn8_N6S844C3D0Ev,_ZThn4_N6S844C3D0Ev)();
extern void _ZN6S844C63v13Ev();
static  VTBL_ENTRY vtc_S844C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S844C3[0]),
  (VTBL_ENTRY)&_ZN6S844C3D1Ev,
  (VTBL_ENTRY)&_ZN6S844C3D0Ev,
  (VTBL_ENTRY)&_ZN6S844C53v10Ev,
  (VTBL_ENTRY)&_ZN6S844C53v11Ev,
  (VTBL_ENTRY)&_ZN6S844C53v12Ev,
  (VTBL_ENTRY)&_ZN6S844C43v14Ev,
  (VTBL_ENTRY)&_ZN6S844C43v15Ev,
  (VTBL_ENTRY)&_ZN6S844C43v16Ev,
  (VTBL_ENTRY)&_ZN6S844C43v17Ev,
  (VTBL_ENTRY)&_ZN6S844C43v18Ev,
  (VTBL_ENTRY)&_ZN6S844C43v19Ev,
  (VTBL_ENTRY)&_ZN6S844C43v20Ev,
  (VTBL_ENTRY)&_ZN6S844C43v21Ev,
  (VTBL_ENTRY)&_ZN6S844C43v22Ev,
  (VTBL_ENTRY)&_ZN6S844C43v23Ev,
  (VTBL_ENTRY)&_ZN6S844C43v24Ev,
  (VTBL_ENTRY)&_ZN6S844C43v25Ev,
  (VTBL_ENTRY)&_ZN6S844C43v26Ev,
  (VTBL_ENTRY)&_ZN6S844C43v27Ev,
  (VTBL_ENTRY)&_ZN6S844C43v28Ev,
  (VTBL_ENTRY)&_ZN6S844C43v29Ev,
  (VTBL_ENTRY)&_ZN6S844C43v30Ev,
  (VTBL_ENTRY)&_ZN6S844C43v31Ev,
  (VTBL_ENTRY)&_ZN6S844C43v32Ev,
  (VTBL_ENTRY)&_ZN6S844C43v33Ev,
  (VTBL_ENTRY)&_ZN6S844C43v34Ev,
  (VTBL_ENTRY)&_ZN6S844C43v35Ev,
  (VTBL_ENTRY)&_ZN6S844C33v36Ev,
  (VTBL_ENTRY)&_ZN6S844C33v37Ev,
  (VTBL_ENTRY)&_ZN6S844C33v38Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S844C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C3D1Ev,_ZThn4_N6S844C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C3D0Ev,_ZThn4_N6S844C3D0Ev),
  (VTBL_ENTRY)&_ZN6S844C63v13Ev,
};
extern VTBL_ENTRY _ZTI6S844C3[];
extern  VTBL_ENTRY _ZTV6S844C3[];
Class_Descriptor cd_S844C3 = {  "S844C3", // class name
  bases_S844C3, 3,
  &(vtc_S844C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI6S844C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S844C3),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S844C10  {
  virtual  ~S844C10(); // _ZN7S844C10D1Ev
  virtual void  v39(); // _ZN7S844C103v39Ev
  S844C10(); // tgen
};
//SIG(-1 S844C10) C1{ vd v1}


 S844C10 ::~S844C10(){ note_dtor("S844C10", this);}
void  S844C10 ::v39(){vfunc_called(this, "_ZN7S844C103v39Ev");}
S844C10 ::S844C10(){ note_ctor("S844C10", this);} // tgen

static void Test_S844C10()
{
  extern Class_Descriptor cd_S844C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S844C10, buf);
    S844C10 *dp, &lv = *(dp=new (buf) S844C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S844C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S844C10)");
    test_class_info(&lv, &cd_S844C10);
    dp->~S844C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS844C10(Test_S844C10, "S844C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S844C10C1Ev();
extern void _ZN7S844C10D1Ev();
Name_Map name_map_S844C10[] = {
  NSPAIR(_ZN7S844C10C1Ev),
  NSPAIR(_ZN7S844C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S844C10[];
extern void _ZN7S844C10D1Ev();
extern void _ZN7S844C10D0Ev();
extern void _ZN7S844C103v39Ev();
static  VTBL_ENTRY vtc_S844C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S844C10[0]),
  (VTBL_ENTRY)&_ZN7S844C10D1Ev,
  (VTBL_ENTRY)&_ZN7S844C10D0Ev,
  (VTBL_ENTRY)&_ZN7S844C103v39Ev,
};
extern VTBL_ENTRY _ZTI7S844C10[];
extern  VTBL_ENTRY _ZTV7S844C10[];
Class_Descriptor cd_S844C10 = {  "S844C10", // class name
  0,0,//no base classes
  &(vtc_S844C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S844C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S844C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S844C2  : S844C3 , S844C10 {
  ::S858C11_nt s844c2f0;
  ::S858C12_nt s844c2f1;
  char s844c2f2[3];
  void *s844c2f3;
  ::S858C15_nt s844c2f4;
  void *s844c2f5;
  virtual  ~S844C2(); // _ZN6S844C2D1Ev
  virtual void  v40(); // _ZN6S844C23v40Ev
  virtual void  v41(); // _ZN6S844C23v41Ev
  virtual void  v42(); // _ZN6S844C23v42Ev
  virtual void  v43(); // _ZN6S844C23v43Ev
  virtual void  v44(); // _ZN6S844C23v44Ev
  virtual void  v45(); // _ZN6S844C23v45Ev
  virtual void  v46(); // _ZN6S844C23v46Ev
  virtual void  v47(); // _ZN6S844C23v47Ev
  virtual void  v48(); // _ZN6S844C23v48Ev
  virtual void  v49(); // _ZN6S844C23v49Ev
  virtual void  v50(); // _ZN6S844C23v50Ev
  virtual void  v51(); // _ZN6S844C23v51Ev
  virtual void  v52(); // _ZN6S844C23v52Ev
  virtual void  v53(); // _ZN6S844C23v53Ev
  virtual void  v54(); // _ZN6S844C23v54Ev
  virtual void  v55(); // _ZN6S844C23v55Ev
  virtual void  v56(); // _ZN6S844C23v56Ev
  virtual void  v57(); // _ZN6S844C23v57Ev
  virtual void  v58(); // _ZN6S844C23v58Ev
  virtual void  v59(); // _ZN6S844C23v59Ev
  virtual void  v60(); // _ZN6S844C23v60Ev
  virtual void  v61(); // _ZN6S844C23v61Ev
  virtual void  v62(); // _ZN6S844C23v62Ev
  virtual void  v63(); // _ZN6S844C23v63Ev
  virtual void  v64(); // _ZN6S844C23v64Ev
  virtual void  v65(); // _ZN6S844C23v65Ev
  virtual void  v66(); // _ZN6S844C23v66Ev
  virtual void  v67(); // _ZN6S844C23v67Ev
  virtual void  v68(); // _ZN6S844C23v68Ev
  virtual void  v69(); // _ZN6S844C23v69Ev
  virtual void  v70(); // _ZN6S844C23v70Ev
  virtual void  v71(); // _ZN6S844C23v71Ev
  virtual void  v72(); // _ZN6S844C23v72Ev
  virtual void  v73(); // _ZN6S844C23v73Ev
  virtual void  v74(); // _ZN6S844C23v74Ev
  virtual void  v75(); // _ZN6S844C23v75Ev
  virtual void  v76(); // _ZN6S844C23v76Ev
  virtual void  v77(); // _ZN6S844C23v77Ev
  virtual void  v78(); // _ZN6S844C23v78Ev
  virtual void  v79(); // _ZN6S844C23v79Ev
  virtual void  v80(); // _ZN6S844C23v80Ev
  S844C2(); // tgen
};
//SIG(-1 S844C2) C1{ BC2{ BC3{ BC4{ vd v42 v43 v44} BC5{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FL[4]} Fc} BC9{ vd v71} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC10{ m FL[4]} FC11{ m Fp FC10 FC12{ m Fp FC13{ Fi[4]}} Fi Fc} Fc[3] Fp FC14{ BC15{ vd v74} BC16{ vd v75} vd v72 v73 Fp[2]} Fp}


 S844C2 ::~S844C2(){ note_dtor("S844C2", this);}
void  S844C2 ::v40(){vfunc_called(this, "_ZN6S844C23v40Ev");}
void  S844C2 ::v41(){vfunc_called(this, "_ZN6S844C23v41Ev");}
void  S844C2 ::v42(){vfunc_called(this, "_ZN6S844C23v42Ev");}
void  S844C2 ::v43(){vfunc_called(this, "_ZN6S844C23v43Ev");}
void  S844C2 ::v44(){vfunc_called(this, "_ZN6S844C23v44Ev");}
void  S844C2 ::v45(){vfunc_called(this, "_ZN6S844C23v45Ev");}
void  S844C2 ::v46(){vfunc_called(this, "_ZN6S844C23v46Ev");}
void  S844C2 ::v47(){vfunc_called(this, "_ZN6S844C23v47Ev");}
void  S844C2 ::v48(){vfunc_called(this, "_ZN6S844C23v48Ev");}
void  S844C2 ::v49(){vfunc_called(this, "_ZN6S844C23v49Ev");}
void  S844C2 ::v50(){vfunc_called(this, "_ZN6S844C23v50Ev");}
void  S844C2 ::v51(){vfunc_called(this, "_ZN6S844C23v51Ev");}
void  S844C2 ::v52(){vfunc_called(this, "_ZN6S844C23v52Ev");}
void  S844C2 ::v53(){vfunc_called(this, "_ZN6S844C23v53Ev");}
void  S844C2 ::v54(){vfunc_called(this, "_ZN6S844C23v54Ev");}
void  S844C2 ::v55(){vfunc_called(this, "_ZN6S844C23v55Ev");}
void  S844C2 ::v56(){vfunc_called(this, "_ZN6S844C23v56Ev");}
void  S844C2 ::v57(){vfunc_called(this, "_ZN6S844C23v57Ev");}
void  S844C2 ::v58(){vfunc_called(this, "_ZN6S844C23v58Ev");}
void  S844C2 ::v59(){vfunc_called(this, "_ZN6S844C23v59Ev");}
void  S844C2 ::v60(){vfunc_called(this, "_ZN6S844C23v60Ev");}
void  S844C2 ::v61(){vfunc_called(this, "_ZN6S844C23v61Ev");}
void  S844C2 ::v62(){vfunc_called(this, "_ZN6S844C23v62Ev");}
void  S844C2 ::v63(){vfunc_called(this, "_ZN6S844C23v63Ev");}
void  S844C2 ::v64(){vfunc_called(this, "_ZN6S844C23v64Ev");}
void  S844C2 ::v65(){vfunc_called(this, "_ZN6S844C23v65Ev");}
void  S844C2 ::v66(){vfunc_called(this, "_ZN6S844C23v66Ev");}
void  S844C2 ::v67(){vfunc_called(this, "_ZN6S844C23v67Ev");}
void  S844C2 ::v68(){vfunc_called(this, "_ZN6S844C23v68Ev");}
void  S844C2 ::v69(){vfunc_called(this, "_ZN6S844C23v69Ev");}
void  S844C2 ::v70(){vfunc_called(this, "_ZN6S844C23v70Ev");}
void  S844C2 ::v71(){vfunc_called(this, "_ZN6S844C23v71Ev");}
void  S844C2 ::v72(){vfunc_called(this, "_ZN6S844C23v72Ev");}
void  S844C2 ::v73(){vfunc_called(this, "_ZN6S844C23v73Ev");}
void  S844C2 ::v74(){vfunc_called(this, "_ZN6S844C23v74Ev");}
void  S844C2 ::v75(){vfunc_called(this, "_ZN6S844C23v75Ev");}
void  S844C2 ::v76(){vfunc_called(this, "_ZN6S844C23v76Ev");}
void  S844C2 ::v77(){vfunc_called(this, "_ZN6S844C23v77Ev");}
void  S844C2 ::v78(){vfunc_called(this, "_ZN6S844C23v78Ev");}
void  S844C2 ::v79(){vfunc_called(this, "_ZN6S844C23v79Ev");}
void  S844C2 ::v80(){vfunc_called(this, "_ZN6S844C23v80Ev");}
S844C2 ::S844C2(){ note_ctor("S844C2", this);} // tgen

static void Test_S844C2()
{
  extern Class_Descriptor cd_S844C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S844C2, buf);
    S844C2 *dp, &lv = *(dp=new (buf) S844C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S844C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S844C2)");
    check_base_class_offset(lv, (S844C5*)(S844C4*)(S844C3*), 0, "S844C2");
    check_base_class_offset(lv, (S844C6*)(S844C4*)(S844C3*), ABISELECT(8,4), "S844C2");
    check_base_class_offset(lv, (S844C4*)(S844C3*), 0, "S844C2");
    check_base_class_offset(lv, (S844C3*), 0, "S844C2");
    check_base_class_offset(lv, (S844C10*), ABISELECT(80,60), "S844C2");
    check_field_offset(lv, s844c2f0, ABISELECT(88,64), "S844C2.s844c2f0");
    check_field_offset(lv, s844c2f1, ABISELECT(120,96), "S844C2.s844c2f1");
    check_field_offset(lv, s844c2f2, ABISELECT(192,160), "S844C2.s844c2f2");
    check_field_offset(lv, s844c2f3, ABISELECT(200,164), "S844C2.s844c2f3");
    check_field_offset(lv, s844c2f4, ABISELECT(208,168), "S844C2.s844c2f4");
    check_field_offset(lv, s844c2f5, ABISELECT(240,184), "S844C2.s844c2f5");
    test_class_info(&lv, &cd_S844C2);
    dp->~S844C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS844C2(Test_S844C2, "S844C2", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S844C2C1Ev();
extern void _ZN6S844C2D1Ev();
Name_Map name_map_S844C2[] = {
  NSPAIR(_ZN6S844C2C1Ev),
  NSPAIR(_ZN6S844C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S844C5;
extern VTBL_ENTRY _ZTI6S844C5[];
extern  VTBL_ENTRY _ZTV6S844C5[];
extern Class_Descriptor cd_S844C6;
extern VTBL_ENTRY _ZTI6S844C6[];
extern  VTBL_ENTRY _ZTV6S844C6[];
extern Class_Descriptor cd_S844C4;
extern VTBL_ENTRY _ZTI6S844C4[];
extern  VTBL_ENTRY _ZTV6S844C4[];
extern Class_Descriptor cd_S844C3;
extern VTBL_ENTRY _ZTI6S844C3[];
extern  VTBL_ENTRY _ZTV6S844C3[];
extern Class_Descriptor cd_S844C10;
extern VTBL_ENTRY _ZTI7S844C10[];
extern  VTBL_ENTRY _ZTV7S844C10[];
static Base_Class bases_S844C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S844C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S844C6,    ABISELECT(8,4), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S844C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S844C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S844C10,    ABISELECT(80,60), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S844C2[];
extern void _ZN6S844C2D1Ev();
extern void _ZN6S844C2D0Ev();
extern void _ZN6S844C53v10Ev();
extern void _ZN6S844C53v11Ev();
extern void _ZN6S844C53v12Ev();
extern void _ZN6S844C43v14Ev();
extern void _ZN6S844C43v15Ev();
extern void _ZN6S844C43v16Ev();
extern void _ZN6S844C43v17Ev();
extern void _ZN6S844C43v18Ev();
extern void _ZN6S844C43v19Ev();
extern void _ZN6S844C43v20Ev();
extern void _ZN6S844C43v21Ev();
extern void _ZN6S844C43v22Ev();
extern void _ZN6S844C43v23Ev();
extern void _ZN6S844C43v24Ev();
extern void _ZN6S844C43v25Ev();
extern void _ZN6S844C43v26Ev();
extern void _ZN6S844C43v27Ev();
extern void _ZN6S844C43v28Ev();
extern void _ZN6S844C43v29Ev();
extern void _ZN6S844C43v30Ev();
extern void _ZN6S844C43v31Ev();
extern void _ZN6S844C43v32Ev();
extern void _ZN6S844C43v33Ev();
extern void _ZN6S844C43v34Ev();
extern void _ZN6S844C43v35Ev();
extern void _ZN6S844C33v36Ev();
extern void _ZN6S844C33v37Ev();
extern void _ZN6S844C33v38Ev();
extern void _ZN6S844C23v40Ev();
extern void _ZN6S844C23v41Ev();
extern void _ZN6S844C23v42Ev();
extern void _ZN6S844C23v43Ev();
extern void _ZN6S844C23v44Ev();
extern void _ZN6S844C23v45Ev();
extern void _ZN6S844C23v46Ev();
extern void _ZN6S844C23v47Ev();
extern void _ZN6S844C23v48Ev();
extern void _ZN6S844C23v49Ev();
extern void _ZN6S844C23v50Ev();
extern void _ZN6S844C23v51Ev();
extern void _ZN6S844C23v52Ev();
extern void _ZN6S844C23v53Ev();
extern void _ZN6S844C23v54Ev();
extern void _ZN6S844C23v55Ev();
extern void _ZN6S844C23v56Ev();
extern void _ZN6S844C23v57Ev();
extern void _ZN6S844C23v58Ev();
extern void _ZN6S844C23v59Ev();
extern void _ZN6S844C23v60Ev();
extern void _ZN6S844C23v61Ev();
extern void _ZN6S844C23v62Ev();
extern void _ZN6S844C23v63Ev();
extern void _ZN6S844C23v64Ev();
extern void _ZN6S844C23v65Ev();
extern void _ZN6S844C23v66Ev();
extern void _ZN6S844C23v67Ev();
extern void _ZN6S844C23v68Ev();
extern void _ZN6S844C23v69Ev();
extern void _ZN6S844C23v70Ev();
extern void _ZN6S844C23v71Ev();
extern void _ZN6S844C23v72Ev();
extern void _ZN6S844C23v73Ev();
extern void _ZN6S844C23v74Ev();
extern void _ZN6S844C23v75Ev();
extern void _ZN6S844C23v76Ev();
extern void _ZN6S844C23v77Ev();
extern void _ZN6S844C23v78Ev();
extern void _ZN6S844C23v79Ev();
extern void _ZN6S844C23v80Ev();
extern void ABISELECT(_ZThn8_N6S844C2D1Ev,_ZThn4_N6S844C2D1Ev)();
extern void ABISELECT(_ZThn8_N6S844C2D0Ev,_ZThn4_N6S844C2D0Ev)();
extern void _ZN6S844C63v13Ev();
extern void ABISELECT(_ZThn80_N6S844C2D1Ev,_ZThn60_N6S844C2D1Ev)();
extern void ABISELECT(_ZThn80_N6S844C2D0Ev,_ZThn60_N6S844C2D0Ev)();
extern void _ZN7S844C103v39Ev();
static  VTBL_ENTRY vtc_S844C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S844C2[0]),
  (VTBL_ENTRY)&_ZN6S844C2D1Ev,
  (VTBL_ENTRY)&_ZN6S844C2D0Ev,
  (VTBL_ENTRY)&_ZN6S844C53v10Ev,
  (VTBL_ENTRY)&_ZN6S844C53v11Ev,
  (VTBL_ENTRY)&_ZN6S844C53v12Ev,
  (VTBL_ENTRY)&_ZN6S844C43v14Ev,
  (VTBL_ENTRY)&_ZN6S844C43v15Ev,
  (VTBL_ENTRY)&_ZN6S844C43v16Ev,
  (VTBL_ENTRY)&_ZN6S844C43v17Ev,
  (VTBL_ENTRY)&_ZN6S844C43v18Ev,
  (VTBL_ENTRY)&_ZN6S844C43v19Ev,
  (VTBL_ENTRY)&_ZN6S844C43v20Ev,
  (VTBL_ENTRY)&_ZN6S844C43v21Ev,
  (VTBL_ENTRY)&_ZN6S844C43v22Ev,
  (VTBL_ENTRY)&_ZN6S844C43v23Ev,
  (VTBL_ENTRY)&_ZN6S844C43v24Ev,
  (VTBL_ENTRY)&_ZN6S844C43v25Ev,
  (VTBL_ENTRY)&_ZN6S844C43v26Ev,
  (VTBL_ENTRY)&_ZN6S844C43v27Ev,
  (VTBL_ENTRY)&_ZN6S844C43v28Ev,
  (VTBL_ENTRY)&_ZN6S844C43v29Ev,
  (VTBL_ENTRY)&_ZN6S844C43v30Ev,
  (VTBL_ENTRY)&_ZN6S844C43v31Ev,
  (VTBL_ENTRY)&_ZN6S844C43v32Ev,
  (VTBL_ENTRY)&_ZN6S844C43v33Ev,
  (VTBL_ENTRY)&_ZN6S844C43v34Ev,
  (VTBL_ENTRY)&_ZN6S844C43v35Ev,
  (VTBL_ENTRY)&_ZN6S844C33v36Ev,
  (VTBL_ENTRY)&_ZN6S844C33v37Ev,
  (VTBL_ENTRY)&_ZN6S844C33v38Ev,
  (VTBL_ENTRY)&_ZN6S844C23v40Ev,
  (VTBL_ENTRY)&_ZN6S844C23v41Ev,
  (VTBL_ENTRY)&_ZN6S844C23v42Ev,
  (VTBL_ENTRY)&_ZN6S844C23v43Ev,
  (VTBL_ENTRY)&_ZN6S844C23v44Ev,
  (VTBL_ENTRY)&_ZN6S844C23v45Ev,
  (VTBL_ENTRY)&_ZN6S844C23v46Ev,
  (VTBL_ENTRY)&_ZN6S844C23v47Ev,
  (VTBL_ENTRY)&_ZN6S844C23v48Ev,
  (VTBL_ENTRY)&_ZN6S844C23v49Ev,
  (VTBL_ENTRY)&_ZN6S844C23v50Ev,
  (VTBL_ENTRY)&_ZN6S844C23v51Ev,
  (VTBL_ENTRY)&_ZN6S844C23v52Ev,
  (VTBL_ENTRY)&_ZN6S844C23v53Ev,
  (VTBL_ENTRY)&_ZN6S844C23v54Ev,
  (VTBL_ENTRY)&_ZN6S844C23v55Ev,
  (VTBL_ENTRY)&_ZN6S844C23v56Ev,
  (VTBL_ENTRY)&_ZN6S844C23v57Ev,
  (VTBL_ENTRY)&_ZN6S844C23v58Ev,
  (VTBL_ENTRY)&_ZN6S844C23v59Ev,
  (VTBL_ENTRY)&_ZN6S844C23v60Ev,
  (VTBL_ENTRY)&_ZN6S844C23v61Ev,
  (VTBL_ENTRY)&_ZN6S844C23v62Ev,
  (VTBL_ENTRY)&_ZN6S844C23v63Ev,
  (VTBL_ENTRY)&_ZN6S844C23v64Ev,
  (VTBL_ENTRY)&_ZN6S844C23v65Ev,
  (VTBL_ENTRY)&_ZN6S844C23v66Ev,
  (VTBL_ENTRY)&_ZN6S844C23v67Ev,
  (VTBL_ENTRY)&_ZN6S844C23v68Ev,
  (VTBL_ENTRY)&_ZN6S844C23v69Ev,
  (VTBL_ENTRY)&_ZN6S844C23v70Ev,
  (VTBL_ENTRY)&_ZN6S844C23v71Ev,
  (VTBL_ENTRY)&_ZN6S844C23v72Ev,
  (VTBL_ENTRY)&_ZN6S844C23v73Ev,
  (VTBL_ENTRY)&_ZN6S844C23v74Ev,
  (VTBL_ENTRY)&_ZN6S844C23v75Ev,
  (VTBL_ENTRY)&_ZN6S844C23v76Ev,
  (VTBL_ENTRY)&_ZN6S844C23v77Ev,
  (VTBL_ENTRY)&_ZN6S844C23v78Ev,
  (VTBL_ENTRY)&_ZN6S844C23v79Ev,
  (VTBL_ENTRY)&_ZN6S844C23v80Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S844C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C2D1Ev,_ZThn4_N6S844C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C2D0Ev,_ZThn4_N6S844C2D0Ev),
  (VTBL_ENTRY)&_ZN6S844C63v13Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S844C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S844C2D1Ev,_ZThn60_N6S844C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S844C2D0Ev,_ZThn60_N6S844C2D0Ev),
  (VTBL_ENTRY)&_ZN7S844C103v39Ev,
};
extern VTBL_ENTRY _ZTI6S844C2[];
extern  VTBL_ENTRY _ZTV6S844C2[];
Class_Descriptor cd_S844C2 = {  "S844C2", // class name
  bases_S844C2, 5,
  &(vtc_S844C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S844C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S844C2),83, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S844C1  : S844C2 {
  virtual  ~S844C1(); // _ZN6S844C1D1Ev
  virtual void  v1(); // _ZN6S844C12v1Ev
  virtual void  v2(); // _ZN6S844C12v2Ev
  virtual void  v3(); // _ZN6S844C12v3Ev
  virtual void  v4(); // _ZN6S844C12v4Ev
  virtual void  v5(); // _ZN6S844C12v5Ev
  virtual void  v6(); // _ZN6S844C12v6Ev
  virtual void  v7(); // _ZN6S844C12v7Ev
  virtual void  v8(); // _ZN6S844C12v8Ev
  virtual void  v9(); // _ZN6S844C12v9Ev
  S844C1(); // tgen
};
//SIG(1 S844C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v10 v11 v12} BC6{ vd v13} vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35} vd v36 v37 v38 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v39} vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 FC11{ m FL[4]} FC12{ m Fp FC11 FC13{ m Fp FC14{ Fi[4]}} Fi Fc} Fc[3] Fp FC15{ BC16{ vd v83} BC17{ vd v84} vd v81 v82 Fp[2]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S844C1 ::~S844C1(){ note_dtor("S844C1", this);}
void  S844C1 ::v1(){vfunc_called(this, "_ZN6S844C12v1Ev");}
void  S844C1 ::v2(){vfunc_called(this, "_ZN6S844C12v2Ev");}
void  S844C1 ::v3(){vfunc_called(this, "_ZN6S844C12v3Ev");}
void  S844C1 ::v4(){vfunc_called(this, "_ZN6S844C12v4Ev");}
void  S844C1 ::v5(){vfunc_called(this, "_ZN6S844C12v5Ev");}
void  S844C1 ::v6(){vfunc_called(this, "_ZN6S844C12v6Ev");}
void  S844C1 ::v7(){vfunc_called(this, "_ZN6S844C12v7Ev");}
void  S844C1 ::v8(){vfunc_called(this, "_ZN6S844C12v8Ev");}
void  S844C1 ::v9(){vfunc_called(this, "_ZN6S844C12v9Ev");}
S844C1 ::S844C1(){ note_ctor("S844C1", this);} // tgen

static void Test_S844C1()
{
  extern Class_Descriptor cd_S844C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,48)];
    init_test(&cd_S844C1, buf);
    S844C1 *dp, &lv = *(dp=new (buf) S844C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,188), "sizeof(S844C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S844C1)");
    check_base_class_offset(lv, (S844C5*)(S844C4*)(S844C3*)(S844C2*), 0, "S844C1");
    check_base_class_offset(lv, (S844C6*)(S844C4*)(S844C3*)(S844C2*), ABISELECT(8,4), "S844C1");
    check_base_class_offset(lv, (S844C4*)(S844C3*)(S844C2*), 0, "S844C1");
    check_base_class_offset(lv, (S844C3*)(S844C2*), 0, "S844C1");
    check_base_class_offset(lv, (S844C10*)(S844C2*), ABISELECT(80,60), "S844C1");
    check_base_class_offset(lv, (S844C2*), 0, "S844C1");
    test_class_info(&lv, &cd_S844C1);
    dp->~S844C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS844C1(Test_S844C1, "S844C1", ABISELECT(248,188));

#else // __cplusplus

extern void _ZN6S844C1C1Ev();
extern void _ZN6S844C1D1Ev();
Name_Map name_map_S844C1[] = {
  NSPAIR(_ZN6S844C1C1Ev),
  NSPAIR(_ZN6S844C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S844C5;
extern VTBL_ENTRY _ZTI6S844C5[];
extern  VTBL_ENTRY _ZTV6S844C5[];
extern Class_Descriptor cd_S844C6;
extern VTBL_ENTRY _ZTI6S844C6[];
extern  VTBL_ENTRY _ZTV6S844C6[];
extern Class_Descriptor cd_S844C4;
extern VTBL_ENTRY _ZTI6S844C4[];
extern  VTBL_ENTRY _ZTV6S844C4[];
extern Class_Descriptor cd_S844C3;
extern VTBL_ENTRY _ZTI6S844C3[];
extern  VTBL_ENTRY _ZTV6S844C3[];
extern Class_Descriptor cd_S844C10;
extern VTBL_ENTRY _ZTI7S844C10[];
extern  VTBL_ENTRY _ZTV7S844C10[];
extern Class_Descriptor cd_S844C2;
extern VTBL_ENTRY _ZTI6S844C2[];
extern  VTBL_ENTRY _ZTV6S844C2[];
static Base_Class bases_S844C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S844C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S844C6,    ABISELECT(8,4), //bcp->offset
    82, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S844C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S844C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S844C10,    ABISELECT(80,60), //bcp->offset
    87, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S844C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S844C1[];
extern void _ZN6S844C1D1Ev();
extern void _ZN6S844C1D0Ev();
extern void _ZN6S844C53v10Ev();
extern void _ZN6S844C53v11Ev();
extern void _ZN6S844C53v12Ev();
extern void _ZN6S844C43v14Ev();
extern void _ZN6S844C43v15Ev();
extern void _ZN6S844C43v16Ev();
extern void _ZN6S844C43v17Ev();
extern void _ZN6S844C43v18Ev();
extern void _ZN6S844C43v19Ev();
extern void _ZN6S844C43v20Ev();
extern void _ZN6S844C43v21Ev();
extern void _ZN6S844C43v22Ev();
extern void _ZN6S844C43v23Ev();
extern void _ZN6S844C43v24Ev();
extern void _ZN6S844C43v25Ev();
extern void _ZN6S844C43v26Ev();
extern void _ZN6S844C43v27Ev();
extern void _ZN6S844C43v28Ev();
extern void _ZN6S844C43v29Ev();
extern void _ZN6S844C43v30Ev();
extern void _ZN6S844C43v31Ev();
extern void _ZN6S844C43v32Ev();
extern void _ZN6S844C43v33Ev();
extern void _ZN6S844C43v34Ev();
extern void _ZN6S844C43v35Ev();
extern void _ZN6S844C33v36Ev();
extern void _ZN6S844C33v37Ev();
extern void _ZN6S844C33v38Ev();
extern void _ZN6S844C23v40Ev();
extern void _ZN6S844C23v41Ev();
extern void _ZN6S844C23v42Ev();
extern void _ZN6S844C23v43Ev();
extern void _ZN6S844C23v44Ev();
extern void _ZN6S844C23v45Ev();
extern void _ZN6S844C23v46Ev();
extern void _ZN6S844C23v47Ev();
extern void _ZN6S844C23v48Ev();
extern void _ZN6S844C23v49Ev();
extern void _ZN6S844C23v50Ev();
extern void _ZN6S844C23v51Ev();
extern void _ZN6S844C23v52Ev();
extern void _ZN6S844C23v53Ev();
extern void _ZN6S844C23v54Ev();
extern void _ZN6S844C23v55Ev();
extern void _ZN6S844C23v56Ev();
extern void _ZN6S844C23v57Ev();
extern void _ZN6S844C23v58Ev();
extern void _ZN6S844C23v59Ev();
extern void _ZN6S844C23v60Ev();
extern void _ZN6S844C23v61Ev();
extern void _ZN6S844C23v62Ev();
extern void _ZN6S844C23v63Ev();
extern void _ZN6S844C23v64Ev();
extern void _ZN6S844C23v65Ev();
extern void _ZN6S844C23v66Ev();
extern void _ZN6S844C23v67Ev();
extern void _ZN6S844C23v68Ev();
extern void _ZN6S844C23v69Ev();
extern void _ZN6S844C23v70Ev();
extern void _ZN6S844C23v71Ev();
extern void _ZN6S844C23v72Ev();
extern void _ZN6S844C23v73Ev();
extern void _ZN6S844C23v74Ev();
extern void _ZN6S844C23v75Ev();
extern void _ZN6S844C23v76Ev();
extern void _ZN6S844C23v77Ev();
extern void _ZN6S844C23v78Ev();
extern void _ZN6S844C23v79Ev();
extern void _ZN6S844C23v80Ev();
extern void _ZN6S844C12v1Ev();
extern void _ZN6S844C12v2Ev();
extern void _ZN6S844C12v3Ev();
extern void _ZN6S844C12v4Ev();
extern void _ZN6S844C12v5Ev();
extern void _ZN6S844C12v6Ev();
extern void _ZN6S844C12v7Ev();
extern void _ZN6S844C12v8Ev();
extern void _ZN6S844C12v9Ev();
extern void ABISELECT(_ZThn8_N6S844C1D1Ev,_ZThn4_N6S844C1D1Ev)();
extern void ABISELECT(_ZThn8_N6S844C1D0Ev,_ZThn4_N6S844C1D0Ev)();
extern void _ZN6S844C63v13Ev();
extern void ABISELECT(_ZThn80_N6S844C1D1Ev,_ZThn60_N6S844C1D1Ev)();
extern void ABISELECT(_ZThn80_N6S844C1D0Ev,_ZThn60_N6S844C1D0Ev)();
extern void _ZN7S844C103v39Ev();
static  VTBL_ENTRY vtc_S844C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S844C1[0]),
  (VTBL_ENTRY)&_ZN6S844C1D1Ev,
  (VTBL_ENTRY)&_ZN6S844C1D0Ev,
  (VTBL_ENTRY)&_ZN6S844C53v10Ev,
  (VTBL_ENTRY)&_ZN6S844C53v11Ev,
  (VTBL_ENTRY)&_ZN6S844C53v12Ev,
  (VTBL_ENTRY)&_ZN6S844C43v14Ev,
  (VTBL_ENTRY)&_ZN6S844C43v15Ev,
  (VTBL_ENTRY)&_ZN6S844C43v16Ev,
  (VTBL_ENTRY)&_ZN6S844C43v17Ev,
  (VTBL_ENTRY)&_ZN6S844C43v18Ev,
  (VTBL_ENTRY)&_ZN6S844C43v19Ev,
  (VTBL_ENTRY)&_ZN6S844C43v20Ev,
  (VTBL_ENTRY)&_ZN6S844C43v21Ev,
  (VTBL_ENTRY)&_ZN6S844C43v22Ev,
  (VTBL_ENTRY)&_ZN6S844C43v23Ev,
  (VTBL_ENTRY)&_ZN6S844C43v24Ev,
  (VTBL_ENTRY)&_ZN6S844C43v25Ev,
  (VTBL_ENTRY)&_ZN6S844C43v26Ev,
  (VTBL_ENTRY)&_ZN6S844C43v27Ev,
  (VTBL_ENTRY)&_ZN6S844C43v28Ev,
  (VTBL_ENTRY)&_ZN6S844C43v29Ev,
  (VTBL_ENTRY)&_ZN6S844C43v30Ev,
  (VTBL_ENTRY)&_ZN6S844C43v31Ev,
  (VTBL_ENTRY)&_ZN6S844C43v32Ev,
  (VTBL_ENTRY)&_ZN6S844C43v33Ev,
  (VTBL_ENTRY)&_ZN6S844C43v34Ev,
  (VTBL_ENTRY)&_ZN6S844C43v35Ev,
  (VTBL_ENTRY)&_ZN6S844C33v36Ev,
  (VTBL_ENTRY)&_ZN6S844C33v37Ev,
  (VTBL_ENTRY)&_ZN6S844C33v38Ev,
  (VTBL_ENTRY)&_ZN6S844C23v40Ev,
  (VTBL_ENTRY)&_ZN6S844C23v41Ev,
  (VTBL_ENTRY)&_ZN6S844C23v42Ev,
  (VTBL_ENTRY)&_ZN6S844C23v43Ev,
  (VTBL_ENTRY)&_ZN6S844C23v44Ev,
  (VTBL_ENTRY)&_ZN6S844C23v45Ev,
  (VTBL_ENTRY)&_ZN6S844C23v46Ev,
  (VTBL_ENTRY)&_ZN6S844C23v47Ev,
  (VTBL_ENTRY)&_ZN6S844C23v48Ev,
  (VTBL_ENTRY)&_ZN6S844C23v49Ev,
  (VTBL_ENTRY)&_ZN6S844C23v50Ev,
  (VTBL_ENTRY)&_ZN6S844C23v51Ev,
  (VTBL_ENTRY)&_ZN6S844C23v52Ev,
  (VTBL_ENTRY)&_ZN6S844C23v53Ev,
  (VTBL_ENTRY)&_ZN6S844C23v54Ev,
  (VTBL_ENTRY)&_ZN6S844C23v55Ev,
  (VTBL_ENTRY)&_ZN6S844C23v56Ev,
  (VTBL_ENTRY)&_ZN6S844C23v57Ev,
  (VTBL_ENTRY)&_ZN6S844C23v58Ev,
  (VTBL_ENTRY)&_ZN6S844C23v59Ev,
  (VTBL_ENTRY)&_ZN6S844C23v60Ev,
  (VTBL_ENTRY)&_ZN6S844C23v61Ev,
  (VTBL_ENTRY)&_ZN6S844C23v62Ev,
  (VTBL_ENTRY)&_ZN6S844C23v63Ev,
  (VTBL_ENTRY)&_ZN6S844C23v64Ev,
  (VTBL_ENTRY)&_ZN6S844C23v65Ev,
  (VTBL_ENTRY)&_ZN6S844C23v66Ev,
  (VTBL_ENTRY)&_ZN6S844C23v67Ev,
  (VTBL_ENTRY)&_ZN6S844C23v68Ev,
  (VTBL_ENTRY)&_ZN6S844C23v69Ev,
  (VTBL_ENTRY)&_ZN6S844C23v70Ev,
  (VTBL_ENTRY)&_ZN6S844C23v71Ev,
  (VTBL_ENTRY)&_ZN6S844C23v72Ev,
  (VTBL_ENTRY)&_ZN6S844C23v73Ev,
  (VTBL_ENTRY)&_ZN6S844C23v74Ev,
  (VTBL_ENTRY)&_ZN6S844C23v75Ev,
  (VTBL_ENTRY)&_ZN6S844C23v76Ev,
  (VTBL_ENTRY)&_ZN6S844C23v77Ev,
  (VTBL_ENTRY)&_ZN6S844C23v78Ev,
  (VTBL_ENTRY)&_ZN6S844C23v79Ev,
  (VTBL_ENTRY)&_ZN6S844C23v80Ev,
  (VTBL_ENTRY)&_ZN6S844C12v1Ev,
  (VTBL_ENTRY)&_ZN6S844C12v2Ev,
  (VTBL_ENTRY)&_ZN6S844C12v3Ev,
  (VTBL_ENTRY)&_ZN6S844C12v4Ev,
  (VTBL_ENTRY)&_ZN6S844C12v5Ev,
  (VTBL_ENTRY)&_ZN6S844C12v6Ev,
  (VTBL_ENTRY)&_ZN6S844C12v7Ev,
  (VTBL_ENTRY)&_ZN6S844C12v8Ev,
  (VTBL_ENTRY)&_ZN6S844C12v9Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI6S844C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C1D1Ev,_ZThn4_N6S844C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N6S844C1D0Ev,_ZThn4_N6S844C1D0Ev),
  (VTBL_ENTRY)&_ZN6S844C63v13Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI6S844C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S844C1D1Ev,_ZThn60_N6S844C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N6S844C1D0Ev,_ZThn60_N6S844C1D0Ev),
  (VTBL_ENTRY)&_ZN7S844C103v39Ev,
};
extern VTBL_ENTRY _ZTI6S844C1[];
extern  VTBL_ENTRY _ZTV6S844C1[];
Class_Descriptor cd_S844C1 = {  "S844C1", // class name
  bases_S844C1, 6,
  &(vtc_S844C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,188), // object size
  NSPAIRA(_ZTI6S844C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S844C1),92, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4248C3_nt  {
  void *s4248c3f0;
  ::S9123C27 s4248c3f1;
  ::S9124C5_nt s4248c3f2;
  char s4248c3f3;
  virtual  ~S4248C3_nt(); // _ZN10S4248C3_ntD1Ev
  virtual void  v13(); // _ZN10S4248C3_nt3v13Ev
  virtual void  v14(); // _ZN10S4248C3_nt3v14Ev
  virtual void  v15(); // _ZN10S4248C3_nt3v15Ev
  virtual void  v16(); // _ZN10S4248C3_nt3v16Ev
  virtual void  v17(); // _ZN10S4248C3_nt3v17Ev
  virtual void  v18(); // _ZN10S4248C3_nt3v18Ev
  virtual void  v19(); // _ZN10S4248C3_nt3v19Ev
  virtual void  v20(); // _ZN10S4248C3_nt3v20Ev
  virtual void  v21(); // _ZN10S4248C3_nt3v21Ev
  virtual void  v22(); // _ZN10S4248C3_nt3v22Ev
  virtual void  v23(); // _ZN10S4248C3_nt3v23Ev
  virtual void  v24(); // _ZN10S4248C3_nt3v24Ev
  S4248C3_nt(); // tgen
};
//SIG(-1 S4248C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC5{ m FL[4]} Fc}


 S4248C3_nt ::~S4248C3_nt(){ note_dtor("S4248C3_nt", this);}
void  S4248C3_nt ::v13(){vfunc_called(this, "_ZN10S4248C3_nt3v13Ev");}
void  S4248C3_nt ::v14(){vfunc_called(this, "_ZN10S4248C3_nt3v14Ev");}
void  S4248C3_nt ::v15(){vfunc_called(this, "_ZN10S4248C3_nt3v15Ev");}
void  S4248C3_nt ::v16(){vfunc_called(this, "_ZN10S4248C3_nt3v16Ev");}
void  S4248C3_nt ::v17(){vfunc_called(this, "_ZN10S4248C3_nt3v17Ev");}
void  S4248C3_nt ::v18(){vfunc_called(this, "_ZN10S4248C3_nt3v18Ev");}
void  S4248C3_nt ::v19(){vfunc_called(this, "_ZN10S4248C3_nt3v19Ev");}
void  S4248C3_nt ::v20(){vfunc_called(this, "_ZN10S4248C3_nt3v20Ev");}
void  S4248C3_nt ::v21(){vfunc_called(this, "_ZN10S4248C3_nt3v21Ev");}
void  S4248C3_nt ::v22(){vfunc_called(this, "_ZN10S4248C3_nt3v22Ev");}
void  S4248C3_nt ::v23(){vfunc_called(this, "_ZN10S4248C3_nt3v23Ev");}
void  S4248C3_nt ::v24(){vfunc_called(this, "_ZN10S4248C3_nt3v24Ev");}
S4248C3_nt ::S4248C3_nt(){ note_ctor("S4248C3_nt", this);} // tgen

//skip512 S4248C3_nt

#else // __cplusplus

extern void _ZN10S4248C3_ntC1Ev();
extern void _ZN10S4248C3_ntD1Ev();
Name_Map name_map_S4248C3_nt[] = {
  NSPAIR(_ZN10S4248C3_ntC1Ev),
  NSPAIR(_ZN10S4248C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S4248C3_nt[];
extern void _ZN10S4248C3_ntD1Ev();
extern void _ZN10S4248C3_ntD0Ev();
extern void _ZN10S4248C3_nt3v13Ev();
extern void _ZN10S4248C3_nt3v14Ev();
extern void _ZN10S4248C3_nt3v15Ev();
extern void _ZN10S4248C3_nt3v16Ev();
extern void _ZN10S4248C3_nt3v17Ev();
extern void _ZN10S4248C3_nt3v18Ev();
extern void _ZN10S4248C3_nt3v19Ev();
extern void _ZN10S4248C3_nt3v20Ev();
extern void _ZN10S4248C3_nt3v21Ev();
extern void _ZN10S4248C3_nt3v22Ev();
extern void _ZN10S4248C3_nt3v23Ev();
extern void _ZN10S4248C3_nt3v24Ev();
static  VTBL_ENTRY vtc_S4248C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4248C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S4248C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v24Ev,
};
extern VTBL_ENTRY _ZTI10S4248C3_nt[];
VTBL_ENTRY *P__ZTI10S4248C3_nt = _ZTI10S4248C3_nt; 
extern  VTBL_ENTRY _ZTV10S4248C3_nt[];
Class_Descriptor cd_S4248C3_nt = {  "S4248C3_nt", // class name
  0,0,//no base classes
  &(vtc_S4248C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI10S4248C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S4248C3_nt),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4248C2_nt  : S4248C3_nt {
  ::S858C7_nt s4248c2f0;
  virtual  ~S4248C2_nt(); // _ZN10S4248C2_ntD1Ev
  virtual void  v25(); // _ZN10S4248C2_nt3v25Ev
  virtual void  v26(); // _ZN10S4248C2_nt3v26Ev
  virtual void  v27(); // _ZN10S4248C2_nt3v27Ev
  virtual void  v28(); // _ZN10S4248C2_nt3v28Ev
  virtual void  v29(); // _ZN10S4248C2_nt3v29Ev
  virtual void  v30(); // _ZN10S4248C2_nt3v30Ev
  virtual void  v31(); // _ZN10S4248C2_nt3v31Ev
  S4248C2_nt(); // tgen
};
//SIG(-1 S4248C2_nt) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ m FL[4]} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC7{ m Fp Fi[2] FC5}}


 S4248C2_nt ::~S4248C2_nt(){ note_dtor("S4248C2_nt", this);}
void  S4248C2_nt ::v25(){vfunc_called(this, "_ZN10S4248C2_nt3v25Ev");}
void  S4248C2_nt ::v26(){vfunc_called(this, "_ZN10S4248C2_nt3v26Ev");}
void  S4248C2_nt ::v27(){vfunc_called(this, "_ZN10S4248C2_nt3v27Ev");}
void  S4248C2_nt ::v28(){vfunc_called(this, "_ZN10S4248C2_nt3v28Ev");}
void  S4248C2_nt ::v29(){vfunc_called(this, "_ZN10S4248C2_nt3v29Ev");}
void  S4248C2_nt ::v30(){vfunc_called(this, "_ZN10S4248C2_nt3v30Ev");}
void  S4248C2_nt ::v31(){vfunc_called(this, "_ZN10S4248C2_nt3v31Ev");}
S4248C2_nt ::S4248C2_nt(){ note_ctor("S4248C2_nt", this);} // tgen

//skip512 S4248C2_nt

#else // __cplusplus

extern void _ZN10S4248C2_ntC1Ev();
extern void _ZN10S4248C2_ntD1Ev();
Name_Map name_map_S4248C2_nt[] = {
  NSPAIR(_ZN10S4248C2_ntC1Ev),
  NSPAIR(_ZN10S4248C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4248C3_nt;
extern VTBL_ENTRY _ZTI10S4248C3_nt[];
extern  VTBL_ENTRY _ZTV10S4248C3_nt[];
static Base_Class bases_S4248C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4248C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S4248C2_nt[];
extern void _ZN10S4248C2_ntD1Ev();
extern void _ZN10S4248C2_ntD0Ev();
extern void _ZN10S4248C3_nt3v13Ev();
extern void _ZN10S4248C3_nt3v14Ev();
extern void _ZN10S4248C3_nt3v15Ev();
extern void _ZN10S4248C3_nt3v16Ev();
extern void _ZN10S4248C3_nt3v17Ev();
extern void _ZN10S4248C3_nt3v18Ev();
extern void _ZN10S4248C3_nt3v19Ev();
extern void _ZN10S4248C3_nt3v20Ev();
extern void _ZN10S4248C3_nt3v21Ev();
extern void _ZN10S4248C3_nt3v22Ev();
extern void _ZN10S4248C3_nt3v23Ev();
extern void _ZN10S4248C3_nt3v24Ev();
extern void _ZN10S4248C2_nt3v25Ev();
extern void _ZN10S4248C2_nt3v26Ev();
extern void _ZN10S4248C2_nt3v27Ev();
extern void _ZN10S4248C2_nt3v28Ev();
extern void _ZN10S4248C2_nt3v29Ev();
extern void _ZN10S4248C2_nt3v30Ev();
extern void _ZN10S4248C2_nt3v31Ev();
static  VTBL_ENTRY vtc_S4248C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4248C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S4248C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v31Ev,
};
extern VTBL_ENTRY _ZTI10S4248C2_nt[];
VTBL_ENTRY *P__ZTI10S4248C2_nt = _ZTI10S4248C2_nt; 
extern  VTBL_ENTRY _ZTV10S4248C2_nt[];
Class_Descriptor cd_S4248C2_nt = {  "S4248C2_nt", // class name
  bases_S4248C2_nt, 1,
  &(vtc_S4248C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,72), // object size
  NSPAIRA(_ZTI10S4248C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S4248C2_nt),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4248C13  {
  virtual  ~S4248C13(); // _ZN8S4248C13D1Ev
  virtual void  v32(); // _ZN8S4248C133v32Ev
  virtual void  v33(); // _ZN8S4248C133v33Ev
  virtual void  v34(); // _ZN8S4248C133v34Ev
  S4248C13(); // tgen
};
//SIG(-1 S4248C13) C1{ vd v1 v2 v3}


 S4248C13 ::~S4248C13(){ note_dtor("S4248C13", this);}
void  S4248C13 ::v32(){vfunc_called(this, "_ZN8S4248C133v32Ev");}
void  S4248C13 ::v33(){vfunc_called(this, "_ZN8S4248C133v33Ev");}
void  S4248C13 ::v34(){vfunc_called(this, "_ZN8S4248C133v34Ev");}
S4248C13 ::S4248C13(){ note_ctor("S4248C13", this);} // tgen

static void Test_S4248C13()
{
  extern Class_Descriptor cd_S4248C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4248C13, buf);
    S4248C13 *dp, &lv = *(dp=new (buf) S4248C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4248C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4248C13)");
    test_class_info(&lv, &cd_S4248C13);
    dp->~S4248C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4248C13(Test_S4248C13, "S4248C13", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S4248C13C1Ev();
extern void _ZN8S4248C13D1Ev();
Name_Map name_map_S4248C13[] = {
  NSPAIR(_ZN8S4248C13C1Ev),
  NSPAIR(_ZN8S4248C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4248C13[];
extern void _ZN8S4248C13D1Ev();
extern void _ZN8S4248C13D0Ev();
extern void _ZN8S4248C133v32Ev();
extern void _ZN8S4248C133v33Ev();
extern void _ZN8S4248C133v34Ev();
static  VTBL_ENTRY vtc_S4248C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4248C13[0]),
  (VTBL_ENTRY)&_ZN8S4248C13D1Ev,
  (VTBL_ENTRY)&_ZN8S4248C13D0Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v32Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v33Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v34Ev,
};
extern VTBL_ENTRY _ZTI8S4248C13[];
extern  VTBL_ENTRY _ZTV8S4248C13[];
Class_Descriptor cd_S4248C13 = {  "S4248C13", // class name
  0,0,//no base classes
  &(vtc_S4248C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S4248C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4248C13),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4248C12_nt  : S4248C13 {
  virtual  ~S4248C12_nt(); // _ZN11S4248C12_ntD1Ev
  virtual void  v35(); // _ZN11S4248C12_nt3v35Ev
  virtual void  v36(); // _ZN11S4248C12_nt3v36Ev
  virtual void  v37(); // _ZN11S4248C12_nt3v37Ev
  virtual void  v38(); // _ZN11S4248C12_nt3v38Ev
  S4248C12_nt(); // tgen
};
//SIG(-1 S4248C12_nt) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S4248C12_nt ::~S4248C12_nt(){ note_dtor("S4248C12_nt", this);}
void  S4248C12_nt ::v35(){vfunc_called(this, "_ZN11S4248C12_nt3v35Ev");}
void  S4248C12_nt ::v36(){vfunc_called(this, "_ZN11S4248C12_nt3v36Ev");}
void  S4248C12_nt ::v37(){vfunc_called(this, "_ZN11S4248C12_nt3v37Ev");}
void  S4248C12_nt ::v38(){vfunc_called(this, "_ZN11S4248C12_nt3v38Ev");}
S4248C12_nt ::S4248C12_nt(){ note_ctor("S4248C12_nt", this);} // tgen

//skip512 S4248C12_nt

#else // __cplusplus

extern void _ZN11S4248C12_ntC1Ev();
extern void _ZN11S4248C12_ntD1Ev();
Name_Map name_map_S4248C12_nt[] = {
  NSPAIR(_ZN11S4248C12_ntC1Ev),
  NSPAIR(_ZN11S4248C12_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4248C13;
extern VTBL_ENTRY _ZTI8S4248C13[];
extern  VTBL_ENTRY _ZTV8S4248C13[];
static Base_Class bases_S4248C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4248C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S4248C12_nt[];
extern void _ZN11S4248C12_ntD1Ev();
extern void _ZN11S4248C12_ntD0Ev();
extern void _ZN8S4248C133v32Ev();
extern void _ZN8S4248C133v33Ev();
extern void _ZN8S4248C133v34Ev();
extern void _ZN11S4248C12_nt3v35Ev();
extern void _ZN11S4248C12_nt3v36Ev();
extern void _ZN11S4248C12_nt3v37Ev();
extern void _ZN11S4248C12_nt3v38Ev();
static  VTBL_ENTRY vtc_S4248C12_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S4248C12_nt[0]),
  (VTBL_ENTRY)&_ZN11S4248C12_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v32Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v33Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v34Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v37Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v38Ev,
};
extern VTBL_ENTRY _ZTI11S4248C12_nt[];
VTBL_ENTRY *P__ZTI11S4248C12_nt = _ZTI11S4248C12_nt; 
extern  VTBL_ENTRY _ZTV11S4248C12_nt[];
Class_Descriptor cd_S4248C12_nt = {  "S4248C12_nt", // class name
  bases_S4248C12_nt, 1,
  &(vtc_S4248C12_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S4248C12_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV11S4248C12_nt),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4248C14_nt  {
  void *s4248c14f0;
  int s4248c14f1[2];
  ::S9123C29 s4248c14f2;
  void  mf4248c14(); // _ZN11S4248C14_nt9mf4248c14Ev
};
//SIG(-1 S4248C14_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S4248C14_nt ::mf4248c14(){}

//skip512 S4248C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4248C11_nt  : S4248C12_nt {
  ::S4248C14_nt s4248c11f0;
  ::S858C11_nt s4248c11f1;
  char s4248c11f2;
  virtual  ~S4248C11_nt(); // _ZN11S4248C11_ntD1Ev
  virtual void  v39(); // _ZN11S4248C11_nt3v39Ev
  virtual void  v40(); // _ZN11S4248C11_nt3v40Ev
  virtual void  v41(); // _ZN11S4248C11_nt3v41Ev
  S4248C11_nt(); // tgen
};
//SIG(-1 S4248C11_nt) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc}


 S4248C11_nt ::~S4248C11_nt(){ note_dtor("S4248C11_nt", this);}
void  S4248C11_nt ::v39(){vfunc_called(this, "_ZN11S4248C11_nt3v39Ev");}
void  S4248C11_nt ::v40(){vfunc_called(this, "_ZN11S4248C11_nt3v40Ev");}
void  S4248C11_nt ::v41(){vfunc_called(this, "_ZN11S4248C11_nt3v41Ev");}
S4248C11_nt ::S4248C11_nt(){ note_ctor("S4248C11_nt", this);} // tgen

//skip512 S4248C11_nt

#else // __cplusplus

extern void _ZN11S4248C11_ntC1Ev();
extern void _ZN11S4248C11_ntD1Ev();
Name_Map name_map_S4248C11_nt[] = {
  NSPAIR(_ZN11S4248C11_ntC1Ev),
  NSPAIR(_ZN11S4248C11_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4248C13;
extern VTBL_ENTRY _ZTI8S4248C13[];
extern  VTBL_ENTRY _ZTV8S4248C13[];
extern Class_Descriptor cd_S4248C12_nt;
extern VTBL_ENTRY _ZTI11S4248C12_nt[];
extern  VTBL_ENTRY _ZTV11S4248C12_nt[];
static Base_Class bases_S4248C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4248C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4248C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S4248C11_nt[];
extern void _ZN11S4248C11_ntD1Ev();
extern void _ZN11S4248C11_ntD0Ev();
extern void _ZN8S4248C133v32Ev();
extern void _ZN8S4248C133v33Ev();
extern void _ZN8S4248C133v34Ev();
extern void _ZN11S4248C12_nt3v35Ev();
extern void _ZN11S4248C12_nt3v36Ev();
extern void _ZN11S4248C12_nt3v37Ev();
extern void _ZN11S4248C12_nt3v38Ev();
extern void _ZN11S4248C11_nt3v39Ev();
extern void _ZN11S4248C11_nt3v40Ev();
extern void _ZN11S4248C11_nt3v41Ev();
static  VTBL_ENTRY vtc_S4248C11_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S4248C11_nt[0]),
  (VTBL_ENTRY)&_ZN11S4248C11_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S4248C11_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v32Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v33Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v34Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v37Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v38Ev,
  (VTBL_ENTRY)&_ZN11S4248C11_nt3v39Ev,
  (VTBL_ENTRY)&_ZN11S4248C11_nt3v40Ev,
  (VTBL_ENTRY)&_ZN11S4248C11_nt3v41Ev,
};
extern VTBL_ENTRY _ZTI11S4248C11_nt[];
VTBL_ENTRY *P__ZTI11S4248C11_nt = _ZTI11S4248C11_nt; 
extern  VTBL_ENTRY _ZTV11S4248C11_nt[];
Class_Descriptor cd_S4248C11_nt = {  "S4248C11_nt", // class name
  bases_S4248C11_nt, 2,
  &(vtc_S4248C11_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI11S4248C11_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV11S4248C11_nt),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4248C1  : S4248C2_nt , S4248C11_nt {
  ::S17044C171 s4248c1f0;
  int s4248c1f1[2];
  ::S9123C7_nt s4248c1f2;
  int s4248c1f3;
  ::S9124C5_nt s4248c1f4;
  ::S858C12_nt s4248c1f5;
  virtual  ~S4248C1(); // _ZN7S4248C1D1Ev
  virtual void  v1(); // _ZN7S4248C12v1Ev
  virtual void  v2(); // _ZN7S4248C12v2Ev
  virtual void  v3(); // _ZN7S4248C12v3Ev
  virtual void  v4(); // _ZN7S4248C12v4Ev
  virtual void  v5(); // _ZN7S4248C12v5Ev
  virtual void  v6(); // _ZN7S4248C12v6Ev
  virtual void  v7(); // _ZN7S4248C12v7Ev
  virtual void  v8(); // _ZN7S4248C12v8Ev
  virtual void  v9(); // _ZN7S4248C12v9Ev
  virtual void  v10(); // _ZN7S4248C13v10Ev
  virtual void  v11(); // _ZN7S4248C13v11Ev
  virtual void  v12(); // _ZN7S4248C13v12Ev
  S4248C1(); // tgen
};
//SIG(1 S4248C1) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m FL[4]} Fc} vd v25 v26 v27 v28 v29 v30 v31 FC8{ m Fp Fi[2] FC6}} BC9{ BC10{ BC11{ vd v32 v33 v34} vd v35 v36 v37 v38} vd v39 v40 v41 FC12{ m Fp Fi[2] FC6} FC13{ m FL[4]} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 FC14{ BC15{}} Fi[2] FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fi FC7 FC19{ m Fp FC13 FC20{ m Fp FC21{ Fi[4]}} Fi Fc}}


 S4248C1 ::~S4248C1(){ note_dtor("S4248C1", this);}
void  S4248C1 ::v1(){vfunc_called(this, "_ZN7S4248C12v1Ev");}
void  S4248C1 ::v2(){vfunc_called(this, "_ZN7S4248C12v2Ev");}
void  S4248C1 ::v3(){vfunc_called(this, "_ZN7S4248C12v3Ev");}
void  S4248C1 ::v4(){vfunc_called(this, "_ZN7S4248C12v4Ev");}
void  S4248C1 ::v5(){vfunc_called(this, "_ZN7S4248C12v5Ev");}
void  S4248C1 ::v6(){vfunc_called(this, "_ZN7S4248C12v6Ev");}
void  S4248C1 ::v7(){vfunc_called(this, "_ZN7S4248C12v7Ev");}
void  S4248C1 ::v8(){vfunc_called(this, "_ZN7S4248C12v8Ev");}
void  S4248C1 ::v9(){vfunc_called(this, "_ZN7S4248C12v9Ev");}
void  S4248C1 ::v10(){vfunc_called(this, "_ZN7S4248C13v10Ev");}
void  S4248C1 ::v11(){vfunc_called(this, "_ZN7S4248C13v11Ev");}
void  S4248C1 ::v12(){vfunc_called(this, "_ZN7S4248C13v12Ev");}
S4248C1 ::S4248C1(){ note_ctor("S4248C1", this);} // tgen

static void Test_S4248C1()
{
  extern Class_Descriptor cd_S4248C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,63)];
    init_test(&cd_S4248C1, buf);
    S4248C1 *dp, &lv = *(dp=new (buf) S4248C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,248), "sizeof(S4248C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4248C1)");
    check_base_class_offset(lv, (S4248C3_nt*)(S4248C2_nt*), 0, "S4248C1");
    check_base_class_offset(lv, (S4248C2_nt*), 0, "S4248C1");
    check_base_class_offset(lv, (S4248C13*)(S4248C12_nt*)(S4248C11_nt*), ABISELECT(96,72), "S4248C1");
    check_base_class_offset(lv, (S4248C12_nt*)(S4248C11_nt*), ABISELECT(96,72), "S4248C1");
    check_base_class_offset(lv, (S4248C11_nt*), ABISELECT(96,72), "S4248C1");
    check_field_offset(lv, s4248c1f0, ABISELECT(161,125), "S4248C1.s4248c1f0");
    check_field_offset(lv, s4248c1f1, ABISELECT(164,128), "S4248C1.s4248c1f1");
    check_field_offset(lv, s4248c1f2, ABISELECT(176,136), "S4248C1.s4248c1f2");
    check_field_offset(lv, s4248c1f3, ABISELECT(192,148), "S4248C1.s4248c1f3");
    check_field_offset(lv, s4248c1f4, ABISELECT(200,152), "S4248C1.s4248c1f4");
    check_field_offset(lv, s4248c1f5, ABISELECT(232,184), "S4248C1.s4248c1f5");
    test_class_info(&lv, &cd_S4248C1);
    dp->~S4248C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4248C1(Test_S4248C1, "S4248C1", ABISELECT(304,248));

#else // __cplusplus

extern void _ZN7S4248C1C1Ev();
extern void _ZN7S4248C1D1Ev();
Name_Map name_map_S4248C1[] = {
  NSPAIR(_ZN7S4248C1C1Ev),
  NSPAIR(_ZN7S4248C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4248C3_nt;
extern VTBL_ENTRY _ZTI10S4248C3_nt[];
extern  VTBL_ENTRY _ZTV10S4248C3_nt[];
extern Class_Descriptor cd_S4248C2_nt;
extern VTBL_ENTRY _ZTI10S4248C2_nt[];
extern  VTBL_ENTRY _ZTV10S4248C2_nt[];
extern Class_Descriptor cd_S4248C13;
extern VTBL_ENTRY _ZTI8S4248C13[];
extern  VTBL_ENTRY _ZTV8S4248C13[];
extern Class_Descriptor cd_S4248C12_nt;
extern VTBL_ENTRY _ZTI11S4248C12_nt[];
extern  VTBL_ENTRY _ZTV11S4248C12_nt[];
extern Class_Descriptor cd_S4248C11_nt;
extern VTBL_ENTRY _ZTI11S4248C11_nt[];
extern  VTBL_ENTRY _ZTV11S4248C11_nt[];
static Base_Class bases_S4248C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4248C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4248C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4248C13,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S4248C12_nt,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4248C11_nt,    ABISELECT(96,72), //bcp->offset
    35, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4248C1[];
extern void _ZN7S4248C1D1Ev();
extern void _ZN7S4248C1D0Ev();
extern void _ZN10S4248C3_nt3v13Ev();
extern void _ZN10S4248C3_nt3v14Ev();
extern void _ZN10S4248C3_nt3v15Ev();
extern void _ZN10S4248C3_nt3v16Ev();
extern void _ZN10S4248C3_nt3v17Ev();
extern void _ZN10S4248C3_nt3v18Ev();
extern void _ZN10S4248C3_nt3v19Ev();
extern void _ZN10S4248C3_nt3v20Ev();
extern void _ZN10S4248C3_nt3v21Ev();
extern void _ZN10S4248C3_nt3v22Ev();
extern void _ZN10S4248C3_nt3v23Ev();
extern void _ZN10S4248C3_nt3v24Ev();
extern void _ZN10S4248C2_nt3v25Ev();
extern void _ZN10S4248C2_nt3v26Ev();
extern void _ZN10S4248C2_nt3v27Ev();
extern void _ZN10S4248C2_nt3v28Ev();
extern void _ZN10S4248C2_nt3v29Ev();
extern void _ZN10S4248C2_nt3v30Ev();
extern void _ZN10S4248C2_nt3v31Ev();
extern void _ZN7S4248C12v1Ev();
extern void _ZN7S4248C12v2Ev();
extern void _ZN7S4248C12v3Ev();
extern void _ZN7S4248C12v4Ev();
extern void _ZN7S4248C12v5Ev();
extern void _ZN7S4248C12v6Ev();
extern void _ZN7S4248C12v7Ev();
extern void _ZN7S4248C12v8Ev();
extern void _ZN7S4248C12v9Ev();
extern void _ZN7S4248C13v10Ev();
extern void _ZN7S4248C13v11Ev();
extern void _ZN7S4248C13v12Ev();
extern void ABISELECT(_ZThn96_N7S4248C1D1Ev,_ZThn72_N7S4248C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S4248C1D0Ev,_ZThn72_N7S4248C1D0Ev)();
extern void _ZN8S4248C133v32Ev();
extern void _ZN8S4248C133v33Ev();
extern void _ZN8S4248C133v34Ev();
extern void _ZN11S4248C12_nt3v35Ev();
extern void _ZN11S4248C12_nt3v36Ev();
extern void _ZN11S4248C12_nt3v37Ev();
extern void _ZN11S4248C12_nt3v38Ev();
extern void _ZN11S4248C11_nt3v39Ev();
extern void _ZN11S4248C11_nt3v40Ev();
extern void _ZN11S4248C11_nt3v41Ev();
static  VTBL_ENTRY vtc_S4248C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4248C1[0]),
  (VTBL_ENTRY)&_ZN7S4248C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4248C1D0Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4248C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4248C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4248C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4248C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4248C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4248C13v12Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI7S4248C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4248C1D1Ev,_ZThn72_N7S4248C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4248C1D0Ev,_ZThn72_N7S4248C1D0Ev),
  (VTBL_ENTRY)&_ZN8S4248C133v32Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v33Ev,
  (VTBL_ENTRY)&_ZN8S4248C133v34Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v37Ev,
  (VTBL_ENTRY)&_ZN11S4248C12_nt3v38Ev,
  (VTBL_ENTRY)&_ZN11S4248C11_nt3v39Ev,
  (VTBL_ENTRY)&_ZN11S4248C11_nt3v40Ev,
  (VTBL_ENTRY)&_ZN11S4248C11_nt3v41Ev,
};
extern VTBL_ENTRY _ZTI7S4248C1[];
extern  VTBL_ENTRY _ZTV7S4248C1[];
Class_Descriptor cd_S4248C1 = {  "S4248C1", // class name
  bases_S4248C1, 5,
  &(vtc_S4248C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,248), // object size
  NSPAIRA(_ZTI7S4248C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S4248C1),49, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C2_nt  {
  void *s6493c2f0;
  ::S9123C27 s6493c2f1;
  virtual  ~S6493C2_nt(); // _ZN10S6493C2_ntD1Ev
  virtual void  v14(); // _ZN10S6493C2_nt3v14Ev
  virtual void  v15(); // _ZN10S6493C2_nt3v15Ev
  virtual void  v16(); // _ZN10S6493C2_nt3v16Ev
  virtual void  v17(); // _ZN10S6493C2_nt3v17Ev
  virtual void  v18(); // _ZN10S6493C2_nt3v18Ev
  virtual void  v19(); // _ZN10S6493C2_nt3v19Ev
  virtual void  v20(); // _ZN10S6493C2_nt3v20Ev
  virtual void  v21(); // _ZN10S6493C2_nt3v21Ev
  virtual void  v22(); // _ZN10S6493C2_nt3v22Ev
  virtual void  v23(); // _ZN10S6493C2_nt3v23Ev
  virtual void  v24(); // _ZN10S6493C2_nt3v24Ev
  virtual void  v25(); // _ZN10S6493C2_nt3v25Ev
  virtual void  v26(); // _ZN10S6493C2_nt3v26Ev
  virtual void  v27(); // _ZN10S6493C2_nt3v27Ev
  virtual void  v28(); // _ZN10S6493C2_nt3v28Ev
  S6493C2_nt(); // tgen
};
//SIG(-1 S6493C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC4}}}


 S6493C2_nt ::~S6493C2_nt(){ note_dtor("S6493C2_nt", this);}
void  S6493C2_nt ::v14(){vfunc_called(this, "_ZN10S6493C2_nt3v14Ev");}
void  S6493C2_nt ::v15(){vfunc_called(this, "_ZN10S6493C2_nt3v15Ev");}
void  S6493C2_nt ::v16(){vfunc_called(this, "_ZN10S6493C2_nt3v16Ev");}
void  S6493C2_nt ::v17(){vfunc_called(this, "_ZN10S6493C2_nt3v17Ev");}
void  S6493C2_nt ::v18(){vfunc_called(this, "_ZN10S6493C2_nt3v18Ev");}
void  S6493C2_nt ::v19(){vfunc_called(this, "_ZN10S6493C2_nt3v19Ev");}
void  S6493C2_nt ::v20(){vfunc_called(this, "_ZN10S6493C2_nt3v20Ev");}
void  S6493C2_nt ::v21(){vfunc_called(this, "_ZN10S6493C2_nt3v21Ev");}
void  S6493C2_nt ::v22(){vfunc_called(this, "_ZN10S6493C2_nt3v22Ev");}
void  S6493C2_nt ::v23(){vfunc_called(this, "_ZN10S6493C2_nt3v23Ev");}
void  S6493C2_nt ::v24(){vfunc_called(this, "_ZN10S6493C2_nt3v24Ev");}
void  S6493C2_nt ::v25(){vfunc_called(this, "_ZN10S6493C2_nt3v25Ev");}
void  S6493C2_nt ::v26(){vfunc_called(this, "_ZN10S6493C2_nt3v26Ev");}
void  S6493C2_nt ::v27(){vfunc_called(this, "_ZN10S6493C2_nt3v27Ev");}
void  S6493C2_nt ::v28(){vfunc_called(this, "_ZN10S6493C2_nt3v28Ev");}
S6493C2_nt ::S6493C2_nt(){ note_ctor("S6493C2_nt", this);} // tgen

//skip512 S6493C2_nt

#else // __cplusplus

extern void _ZN10S6493C2_ntC1Ev();
extern void _ZN10S6493C2_ntD1Ev();
Name_Map name_map_S6493C2_nt[] = {
  NSPAIR(_ZN10S6493C2_ntC1Ev),
  NSPAIR(_ZN10S6493C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S6493C2_nt[];
extern void _ZN10S6493C2_ntD1Ev();
extern void _ZN10S6493C2_ntD0Ev();
extern void _ZN10S6493C2_nt3v14Ev();
extern void _ZN10S6493C2_nt3v15Ev();
extern void _ZN10S6493C2_nt3v16Ev();
extern void _ZN10S6493C2_nt3v17Ev();
extern void _ZN10S6493C2_nt3v18Ev();
extern void _ZN10S6493C2_nt3v19Ev();
extern void _ZN10S6493C2_nt3v20Ev();
extern void _ZN10S6493C2_nt3v21Ev();
extern void _ZN10S6493C2_nt3v22Ev();
extern void _ZN10S6493C2_nt3v23Ev();
extern void _ZN10S6493C2_nt3v24Ev();
extern void _ZN10S6493C2_nt3v25Ev();
extern void _ZN10S6493C2_nt3v26Ev();
extern void _ZN10S6493C2_nt3v27Ev();
extern void _ZN10S6493C2_nt3v28Ev();
static  VTBL_ENTRY vtc_S6493C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S6493C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S6493C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v28Ev,
};
extern VTBL_ENTRY _ZTI10S6493C2_nt[];
VTBL_ENTRY *P__ZTI10S6493C2_nt = _ZTI10S6493C2_nt; 
extern  VTBL_ENTRY _ZTV10S6493C2_nt[];
Class_Descriptor cd_S6493C2_nt = {  "S6493C2_nt", // class name
  0,0,//no base classes
  &(vtc_S6493C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI10S6493C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S6493C2_nt),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C9  {
  virtual  ~S6493C9(); // _ZN7S6493C9D1Ev
  virtual void  v29(); // _ZN7S6493C93v29Ev
  virtual void  v30(); // _ZN7S6493C93v30Ev
  virtual void  v31(); // _ZN7S6493C93v31Ev
  S6493C9(); // tgen
};
//SIG(-1 S6493C9) C1{ vd v1 v2 v3}


 S6493C9 ::~S6493C9(){ note_dtor("S6493C9", this);}
void  S6493C9 ::v29(){vfunc_called(this, "_ZN7S6493C93v29Ev");}
void  S6493C9 ::v30(){vfunc_called(this, "_ZN7S6493C93v30Ev");}
void  S6493C9 ::v31(){vfunc_called(this, "_ZN7S6493C93v31Ev");}
S6493C9 ::S6493C9(){ note_ctor("S6493C9", this);} // tgen

static void Test_S6493C9()
{
  extern Class_Descriptor cd_S6493C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S6493C9, buf);
    S6493C9 *dp, &lv = *(dp=new (buf) S6493C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S6493C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6493C9)");
    test_class_info(&lv, &cd_S6493C9);
    dp->~S6493C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6493C9(Test_S6493C9, "S6493C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S6493C9C1Ev();
extern void _ZN7S6493C9D1Ev();
Name_Map name_map_S6493C9[] = {
  NSPAIR(_ZN7S6493C9C1Ev),
  NSPAIR(_ZN7S6493C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S6493C9[];
extern void _ZN7S6493C9D1Ev();
extern void _ZN7S6493C9D0Ev();
extern void _ZN7S6493C93v29Ev();
extern void _ZN7S6493C93v30Ev();
extern void _ZN7S6493C93v31Ev();
static  VTBL_ENTRY vtc_S6493C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6493C9[0]),
  (VTBL_ENTRY)&_ZN7S6493C9D1Ev,
  (VTBL_ENTRY)&_ZN7S6493C9D0Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v29Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v30Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v31Ev,
};
extern VTBL_ENTRY _ZTI7S6493C9[];
extern  VTBL_ENTRY _ZTV7S6493C9[];
Class_Descriptor cd_S6493C9 = {  "S6493C9", // class name
  0,0,//no base classes
  &(vtc_S6493C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S6493C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S6493C9),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C8_nt  : S6493C9 {
  virtual  ~S6493C8_nt(); // _ZN10S6493C8_ntD1Ev
  virtual void  v32(); // _ZN10S6493C8_nt3v32Ev
  virtual void  v33(); // _ZN10S6493C8_nt3v33Ev
  virtual void  v34(); // _ZN10S6493C8_nt3v34Ev
  virtual void  v35(); // _ZN10S6493C8_nt3v35Ev
  virtual void  v36(); // _ZN10S6493C8_nt3v36Ev
  virtual void  v37(); // _ZN10S6493C8_nt3v37Ev
  S6493C8_nt(); // tgen
};
//SIG(-1 S6493C8_nt) C1{ BC2{ vd v7 v8 v9} vd v1 v2 v3 v4 v5 v6}


 S6493C8_nt ::~S6493C8_nt(){ note_dtor("S6493C8_nt", this);}
void  S6493C8_nt ::v32(){vfunc_called(this, "_ZN10S6493C8_nt3v32Ev");}
void  S6493C8_nt ::v33(){vfunc_called(this, "_ZN10S6493C8_nt3v33Ev");}
void  S6493C8_nt ::v34(){vfunc_called(this, "_ZN10S6493C8_nt3v34Ev");}
void  S6493C8_nt ::v35(){vfunc_called(this, "_ZN10S6493C8_nt3v35Ev");}
void  S6493C8_nt ::v36(){vfunc_called(this, "_ZN10S6493C8_nt3v36Ev");}
void  S6493C8_nt ::v37(){vfunc_called(this, "_ZN10S6493C8_nt3v37Ev");}
S6493C8_nt ::S6493C8_nt(){ note_ctor("S6493C8_nt", this);} // tgen

//skip512 S6493C8_nt

#else // __cplusplus

extern void _ZN10S6493C8_ntC1Ev();
extern void _ZN10S6493C8_ntD1Ev();
Name_Map name_map_S6493C8_nt[] = {
  NSPAIR(_ZN10S6493C8_ntC1Ev),
  NSPAIR(_ZN10S6493C8_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6493C9;
extern VTBL_ENTRY _ZTI7S6493C9[];
extern  VTBL_ENTRY _ZTV7S6493C9[];
static Base_Class bases_S6493C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6493C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S6493C8_nt[];
extern void _ZN10S6493C8_ntD1Ev();
extern void _ZN10S6493C8_ntD0Ev();
extern void _ZN7S6493C93v29Ev();
extern void _ZN7S6493C93v30Ev();
extern void _ZN7S6493C93v31Ev();
extern void _ZN10S6493C8_nt3v32Ev();
extern void _ZN10S6493C8_nt3v33Ev();
extern void _ZN10S6493C8_nt3v34Ev();
extern void _ZN10S6493C8_nt3v35Ev();
extern void _ZN10S6493C8_nt3v36Ev();
extern void _ZN10S6493C8_nt3v37Ev();
static  VTBL_ENTRY vtc_S6493C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S6493C8_nt[0]),
  (VTBL_ENTRY)&_ZN10S6493C8_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v29Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v30Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v31Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v37Ev,
};
extern VTBL_ENTRY _ZTI10S6493C8_nt[];
VTBL_ENTRY *P__ZTI10S6493C8_nt = _ZTI10S6493C8_nt; 
extern  VTBL_ENTRY _ZTV10S6493C8_nt[];
Class_Descriptor cd_S6493C8_nt = {  "S6493C8_nt", // class name
  bases_S6493C8_nt, 1,
  &(vtc_S6493C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S6493C8_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S6493C8_nt),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C7_nt  : S6493C8_nt {
  ::S4248C14_nt s6493c7f0;
  ::S9122C5_nt s6493c7f1;
  char s6493c7f2;
  virtual  ~S6493C7_nt(); // _ZN10S6493C7_ntD1Ev
  virtual void  v38(); // _ZN10S6493C7_nt3v38Ev
  virtual void  v39(); // _ZN10S6493C7_nt3v39Ev
  virtual void  v40(); // _ZN10S6493C7_nt3v40Ev
  S6493C7_nt(); // tgen
};
//SIG(-1 S6493C7_nt) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10 v11 v12} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc}


 S6493C7_nt ::~S6493C7_nt(){ note_dtor("S6493C7_nt", this);}
void  S6493C7_nt ::v38(){vfunc_called(this, "_ZN10S6493C7_nt3v38Ev");}
void  S6493C7_nt ::v39(){vfunc_called(this, "_ZN10S6493C7_nt3v39Ev");}
void  S6493C7_nt ::v40(){vfunc_called(this, "_ZN10S6493C7_nt3v40Ev");}
S6493C7_nt ::S6493C7_nt(){ note_ctor("S6493C7_nt", this);} // tgen

//skip512 S6493C7_nt

#else // __cplusplus

extern void _ZN10S6493C7_ntC1Ev();
extern void _ZN10S6493C7_ntD1Ev();
Name_Map name_map_S6493C7_nt[] = {
  NSPAIR(_ZN10S6493C7_ntC1Ev),
  NSPAIR(_ZN10S6493C7_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6493C9;
extern VTBL_ENTRY _ZTI7S6493C9[];
extern  VTBL_ENTRY _ZTV7S6493C9[];
extern Class_Descriptor cd_S6493C8_nt;
extern VTBL_ENTRY _ZTI10S6493C8_nt[];
extern  VTBL_ENTRY _ZTV10S6493C8_nt[];
static Base_Class bases_S6493C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6493C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S6493C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S6493C7_nt[];
extern void _ZN10S6493C7_ntD1Ev();
extern void _ZN10S6493C7_ntD0Ev();
extern void _ZN7S6493C93v29Ev();
extern void _ZN7S6493C93v30Ev();
extern void _ZN7S6493C93v31Ev();
extern void _ZN10S6493C8_nt3v32Ev();
extern void _ZN10S6493C8_nt3v33Ev();
extern void _ZN10S6493C8_nt3v34Ev();
extern void _ZN10S6493C8_nt3v35Ev();
extern void _ZN10S6493C8_nt3v36Ev();
extern void _ZN10S6493C8_nt3v37Ev();
extern void _ZN10S6493C7_nt3v38Ev();
extern void _ZN10S6493C7_nt3v39Ev();
extern void _ZN10S6493C7_nt3v40Ev();
static  VTBL_ENTRY vtc_S6493C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S6493C7_nt[0]),
  (VTBL_ENTRY)&_ZN10S6493C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S6493C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v29Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v30Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v31Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S6493C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S6493C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S6493C7_nt3v40Ev,
};
extern VTBL_ENTRY _ZTI10S6493C7_nt[];
VTBL_ENTRY *P__ZTI10S6493C7_nt = _ZTI10S6493C7_nt; 
extern  VTBL_ENTRY _ZTV10S6493C7_nt[];
Class_Descriptor cd_S6493C7_nt = {  "S6493C7_nt", // class name
  bases_S6493C7_nt, 2,
  &(vtc_S6493C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI10S6493C7_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S6493C7_nt),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C19_nt  {
  virtual  ~S6493C19_nt(); // _ZN11S6493C19_ntD1Ev
  virtual void  v43(); // _ZN11S6493C19_nt3v43Ev
  virtual void  v44(); // _ZN11S6493C19_nt3v44Ev
  S6493C19_nt(); // tgen
};
//SIG(-1 S6493C19_nt) C1{ vd v1 v2}


 S6493C19_nt ::~S6493C19_nt(){ note_dtor("S6493C19_nt", this);}
void  S6493C19_nt ::v43(){vfunc_called(this, "_ZN11S6493C19_nt3v43Ev");}
void  S6493C19_nt ::v44(){vfunc_called(this, "_ZN11S6493C19_nt3v44Ev");}
S6493C19_nt ::S6493C19_nt(){ note_ctor("S6493C19_nt", this);} // tgen

//skip512 S6493C19_nt

#else // __cplusplus

extern void _ZN11S6493C19_ntC1Ev();
extern void _ZN11S6493C19_ntD1Ev();
Name_Map name_map_S6493C19_nt[] = {
  NSPAIR(_ZN11S6493C19_ntC1Ev),
  NSPAIR(_ZN11S6493C19_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S6493C19_nt[];
extern void _ZN11S6493C19_ntD1Ev();
extern void _ZN11S6493C19_ntD0Ev();
extern void _ZN11S6493C19_nt3v43Ev();
extern void _ZN11S6493C19_nt3v44Ev();
static  VTBL_ENTRY vtc_S6493C19_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S6493C19_nt[0]),
  (VTBL_ENTRY)&_ZN11S6493C19_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S6493C19_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S6493C19_nt3v43Ev,
  (VTBL_ENTRY)&_ZN11S6493C19_nt3v44Ev,
};
extern VTBL_ENTRY _ZTI11S6493C19_nt[];
VTBL_ENTRY *P__ZTI11S6493C19_nt = _ZTI11S6493C19_nt; 
extern  VTBL_ENTRY _ZTV11S6493C19_nt[];
Class_Descriptor cd_S6493C19_nt = {  "S6493C19_nt", // class name
  0,0,//no base classes
  &(vtc_S6493C19_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S6493C19_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S6493C19_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C16_nt  : S858C7_nt , S6493C19_nt {
  virtual  ~S6493C16_nt(); // _ZN11S6493C16_ntD1Ev
  virtual void  v41(); // _ZN11S6493C16_nt3v41Ev
  virtual void  v42(); // _ZN11S6493C16_nt3v42Ev
  S6493C16_nt(); // tgen
};
//SIG(-1 S6493C16_nt) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S6493C16_nt ::~S6493C16_nt(){ note_dtor("S6493C16_nt", this);}
void  S6493C16_nt ::v41(){vfunc_called(this, "_ZN11S6493C16_nt3v41Ev");}
void  S6493C16_nt ::v42(){vfunc_called(this, "_ZN11S6493C16_nt3v42Ev");}
S6493C16_nt ::S6493C16_nt(){ note_ctor("S6493C16_nt", this);} // tgen

//skip512 S6493C16_nt

#else // __cplusplus

extern void _ZN11S6493C16_ntC1Ev();
extern void _ZN11S6493C16_ntD1Ev();
Name_Map name_map_S6493C16_nt[] = {
  NSPAIR(_ZN11S6493C16_ntC1Ev),
  NSPAIR(_ZN11S6493C16_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S858C7_nt;
extern VTBL_ENTRY _ZTI9S858C7_nt[];
extern Class_Descriptor cd_S6493C19_nt;
extern VTBL_ENTRY _ZTI11S6493C19_nt[];
extern  VTBL_ENTRY _ZTV11S6493C19_nt[];
static Base_Class bases_S6493C16_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S858C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6493C19_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S6493C16_nt[];
extern void _ZN11S6493C16_ntD1Ev();
extern void _ZN11S6493C16_ntD0Ev();
extern void _ZN11S6493C19_nt3v43Ev();
extern void _ZN11S6493C19_nt3v44Ev();
extern void _ZN11S6493C16_nt3v41Ev();
extern void _ZN11S6493C16_nt3v42Ev();
static  VTBL_ENTRY vtc_S6493C16_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S6493C16_nt[0]),
  (VTBL_ENTRY)&_ZN11S6493C16_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S6493C16_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S6493C19_nt3v43Ev,
  (VTBL_ENTRY)&_ZN11S6493C19_nt3v44Ev,
  (VTBL_ENTRY)&_ZN11S6493C16_nt3v41Ev,
  (VTBL_ENTRY)&_ZN11S6493C16_nt3v42Ev,
};
extern VTBL_ENTRY _ZTI11S6493C16_nt[];
VTBL_ENTRY *P__ZTI11S6493C16_nt = _ZTI11S6493C16_nt; 
extern  VTBL_ENTRY _ZTV11S6493C16_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C21_nt  {
  void *s6493c21f0;
  int s6493c21f1;
  ::S9123C29 s6493c21f2;
  void  mf6493c21(); // _ZN11S6493C21_nt9mf6493c21Ev
};
//SIG(-1 S6493C21_nt) C1{ m Fp Fi FC2{ m}}


void  S6493C21_nt ::mf6493c21(){}

//skip512 S6493C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C20_nt  {
  int s6493c20f0[2];
  short s6493c20f1[2];
  int s6493c20f2[3];
  ::S6493C21_nt s6493c20f3;
  virtual  ~S6493C20_nt(); // _ZN11S6493C20_ntD1Ev
  virtual void  v45(); // _ZN11S6493C20_nt3v45Ev
  S6493C20_nt(); // tgen
};
//SIG(-1 S6493C20_nt) C1{ vd v1 Fi[2] Fs[2] Fi[3] FC2{ m Fp Fi FC3{ m}}}


 S6493C20_nt ::~S6493C20_nt(){ note_dtor("S6493C20_nt", this);}
void  S6493C20_nt ::v45(){vfunc_called(this, "_ZN11S6493C20_nt3v45Ev");}
S6493C20_nt ::S6493C20_nt(){ note_ctor("S6493C20_nt", this);} // tgen

//skip512 S6493C20_nt

#else // __cplusplus

extern void _ZN11S6493C20_ntC1Ev();
extern void _ZN11S6493C20_ntD1Ev();
Name_Map name_map_S6493C20_nt[] = {
  NSPAIR(_ZN11S6493C20_ntC1Ev),
  NSPAIR(_ZN11S6493C20_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S6493C20_nt[];
extern void _ZN11S6493C20_ntD1Ev();
extern void _ZN11S6493C20_ntD0Ev();
extern void _ZN11S6493C20_nt3v45Ev();
static  VTBL_ENTRY vtc_S6493C20_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S6493C20_nt[0]),
  (VTBL_ENTRY)&_ZN11S6493C20_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S6493C20_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S6493C20_nt3v45Ev,
};
extern VTBL_ENTRY _ZTI11S6493C20_nt[];
VTBL_ENTRY *P__ZTI11S6493C20_nt = _ZTI11S6493C20_nt; 
extern  VTBL_ENTRY _ZTV11S6493C20_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C14  : S17044C172 {
  ::S6493C16_nt s6493c14f0;
  ::S6493C20_nt s6493c14f1;
};
//SIG(-1 S6493C14) C1{ BC2{} FC3{ BC4{ m Fp Fi[2] FC5{ m}} BC6{ vd v3 v4} vd v1 v2} FC7{ vd v5 Fi[2] Fs[2] Fi[3] FC8{ m Fp Fi FC5}}}



static void Test_S6493C14()
{
  extern Class_Descriptor cd_S6493C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S6493C14, buf);
    S6493C14 &lv = *(new (buf) S6493C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S6493C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6493C14)");
    check_base_class_offset(lv, (S17044C172*), 0, "S6493C14");
    check_field_offset(lv, s6493c14f0, 0, "S6493C14.s6493c14f0");
    check_field_offset(lv, s6493c14f1, ABISELECT(32,20), "S6493C14.s6493c14f1");
    test_class_info(&lv, &cd_S6493C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6493C14(Test_S6493C14, "S6493C14", ABISELECT(80,60));

#else // __cplusplus

extern Class_Descriptor cd_S17044C172;
static Base_Class bases_S6493C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S17044C172,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6493C14 = {  "S6493C14", // class name
  bases_S6493C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(80,60), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6493C1  : S6493C2_nt , S6493C7_nt {
  void *s6493c1f0;
  ::S6493C14 s6493c1f1;
  virtual  ~S6493C1(); // _ZN7S6493C1D1Ev
  virtual void  v1(); // _ZN7S6493C12v1Ev
  virtual void  v2(); // _ZN7S6493C12v2Ev
  virtual void  v3(); // _ZN7S6493C12v3Ev
  virtual void  v4(); // _ZN7S6493C12v4Ev
  virtual void  v5(); // _ZN7S6493C12v5Ev
  virtual void  v6(); // _ZN7S6493C12v6Ev
  virtual void  v7(); // _ZN7S6493C12v7Ev
  virtual void  v8(); // _ZN7S6493C12v8Ev
  virtual void  v9(); // _ZN7S6493C12v9Ev
  virtual void  v10(); // _ZN7S6493C13v10Ev
  virtual void  v11(); // _ZN7S6493C13v11Ev
  virtual void  v12(); // _ZN7S6493C13v12Ev
  virtual void  v13(); // _ZN7S6493C13v13Ev
  S6493C1(); // tgen
};
//SIG(1 S6493C1) C1{ BC2{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC5}}} BC6{ BC7{ BC8{ vd v29 v30 v31} vd v32 v33 v34 v35 v36 v37} vd v38 v39 v40 FC9{ m Fp Fi[2] FC5} FC10{ m FC11{ Fl[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC12{ BC13{} FC14{ BC15{ m Fp Fi[2] FC5} BC16{ vd v43 v44} vd v41 v42} FC17{ vd v45 Fi[2] Fs[2] Fi[3] FC18{ m Fp Fi FC5}}}}


 S6493C1 ::~S6493C1(){ note_dtor("S6493C1", this);}
void  S6493C1 ::v1(){vfunc_called(this, "_ZN7S6493C12v1Ev");}
void  S6493C1 ::v2(){vfunc_called(this, "_ZN7S6493C12v2Ev");}
void  S6493C1 ::v3(){vfunc_called(this, "_ZN7S6493C12v3Ev");}
void  S6493C1 ::v4(){vfunc_called(this, "_ZN7S6493C12v4Ev");}
void  S6493C1 ::v5(){vfunc_called(this, "_ZN7S6493C12v5Ev");}
void  S6493C1 ::v6(){vfunc_called(this, "_ZN7S6493C12v6Ev");}
void  S6493C1 ::v7(){vfunc_called(this, "_ZN7S6493C12v7Ev");}
void  S6493C1 ::v8(){vfunc_called(this, "_ZN7S6493C12v8Ev");}
void  S6493C1 ::v9(){vfunc_called(this, "_ZN7S6493C12v9Ev");}
void  S6493C1 ::v10(){vfunc_called(this, "_ZN7S6493C13v10Ev");}
void  S6493C1 ::v11(){vfunc_called(this, "_ZN7S6493C13v11Ev");}
void  S6493C1 ::v12(){vfunc_called(this, "_ZN7S6493C13v12Ev");}
void  S6493C1 ::v13(){vfunc_called(this, "_ZN7S6493C13v13Ev");}
S6493C1 ::S6493C1(){ note_ctor("S6493C1", this);} // tgen

static void Test_S6493C1()
{
  extern Class_Descriptor cd_S6493C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,32)];
    init_test(&cd_S6493C1, buf);
    S6493C1 *dp, &lv = *(dp=new (buf) S6493C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,124), "sizeof(S6493C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6493C1)");
    check_base_class_offset(lv, (S6493C2_nt*), 0, "S6493C1");
    check_base_class_offset(lv, (S6493C9*)(S6493C8_nt*)(S6493C7_nt*), ABISELECT(32,20), "S6493C1");
    check_base_class_offset(lv, (S6493C8_nt*)(S6493C7_nt*), ABISELECT(32,20), "S6493C1");
    check_base_class_offset(lv, (S6493C7_nt*), ABISELECT(32,20), "S6493C1");
    check_field_offset(lv, s6493c1f0, ABISELECT(104,60), "S6493C1.s6493c1f0");
    check_field_offset(lv, s6493c1f1, ABISELECT(112,64), "S6493C1.s6493c1f1");
    test_class_info(&lv, &cd_S6493C1);
    dp->~S6493C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6493C1(Test_S6493C1, "S6493C1", ABISELECT(192,124));

#else // __cplusplus

extern void _ZN7S6493C1C1Ev();
extern void _ZN7S6493C1D1Ev();
Name_Map name_map_S6493C1[] = {
  NSPAIR(_ZN7S6493C1C1Ev),
  NSPAIR(_ZN7S6493C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6493C2_nt;
extern VTBL_ENTRY _ZTI10S6493C2_nt[];
extern  VTBL_ENTRY _ZTV10S6493C2_nt[];
extern Class_Descriptor cd_S6493C9;
extern VTBL_ENTRY _ZTI7S6493C9[];
extern  VTBL_ENTRY _ZTV7S6493C9[];
extern Class_Descriptor cd_S6493C8_nt;
extern VTBL_ENTRY _ZTI10S6493C8_nt[];
extern  VTBL_ENTRY _ZTV10S6493C8_nt[];
extern Class_Descriptor cd_S6493C7_nt;
extern VTBL_ENTRY _ZTI10S6493C7_nt[];
extern  VTBL_ENTRY _ZTV10S6493C7_nt[];
static Base_Class bases_S6493C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6493C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S6493C9,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S6493C8_nt,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S6493C7_nt,    ABISELECT(32,20), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S6493C1[];
extern void _ZN7S6493C1D1Ev();
extern void _ZN7S6493C1D0Ev();
extern void _ZN10S6493C2_nt3v14Ev();
extern void _ZN10S6493C2_nt3v15Ev();
extern void _ZN10S6493C2_nt3v16Ev();
extern void _ZN10S6493C2_nt3v17Ev();
extern void _ZN10S6493C2_nt3v18Ev();
extern void _ZN10S6493C2_nt3v19Ev();
extern void _ZN10S6493C2_nt3v20Ev();
extern void _ZN10S6493C2_nt3v21Ev();
extern void _ZN10S6493C2_nt3v22Ev();
extern void _ZN10S6493C2_nt3v23Ev();
extern void _ZN10S6493C2_nt3v24Ev();
extern void _ZN10S6493C2_nt3v25Ev();
extern void _ZN10S6493C2_nt3v26Ev();
extern void _ZN10S6493C2_nt3v27Ev();
extern void _ZN10S6493C2_nt3v28Ev();
extern void _ZN7S6493C12v1Ev();
extern void _ZN7S6493C12v2Ev();
extern void _ZN7S6493C12v3Ev();
extern void _ZN7S6493C12v4Ev();
extern void _ZN7S6493C12v5Ev();
extern void _ZN7S6493C12v6Ev();
extern void _ZN7S6493C12v7Ev();
extern void _ZN7S6493C12v8Ev();
extern void _ZN7S6493C12v9Ev();
extern void _ZN7S6493C13v10Ev();
extern void _ZN7S6493C13v11Ev();
extern void _ZN7S6493C13v12Ev();
extern void _ZN7S6493C13v13Ev();
extern void ABISELECT(_ZThn32_N7S6493C1D1Ev,_ZThn20_N7S6493C1D1Ev)();
extern void ABISELECT(_ZThn32_N7S6493C1D0Ev,_ZThn20_N7S6493C1D0Ev)();
extern void _ZN7S6493C93v29Ev();
extern void _ZN7S6493C93v30Ev();
extern void _ZN7S6493C93v31Ev();
extern void _ZN10S6493C8_nt3v32Ev();
extern void _ZN10S6493C8_nt3v33Ev();
extern void _ZN10S6493C8_nt3v34Ev();
extern void _ZN10S6493C8_nt3v35Ev();
extern void _ZN10S6493C8_nt3v36Ev();
extern void _ZN10S6493C8_nt3v37Ev();
extern void _ZN10S6493C7_nt3v38Ev();
extern void _ZN10S6493C7_nt3v39Ev();
extern void _ZN10S6493C7_nt3v40Ev();
static  VTBL_ENTRY vtc_S6493C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6493C1[0]),
  (VTBL_ENTRY)&_ZN7S6493C1D1Ev,
  (VTBL_ENTRY)&_ZN7S6493C1D0Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S6493C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v1Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v2Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v3Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v4Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v5Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v6Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v7Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v8Ev,
  (VTBL_ENTRY)&_ZN7S6493C12v9Ev,
  (VTBL_ENTRY)&_ZN7S6493C13v10Ev,
  (VTBL_ENTRY)&_ZN7S6493C13v11Ev,
  (VTBL_ENTRY)&_ZN7S6493C13v12Ev,
  (VTBL_ENTRY)&_ZN7S6493C13v13Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7S6493C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S6493C1D1Ev,_ZThn20_N7S6493C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S6493C1D0Ev,_ZThn20_N7S6493C1D0Ev),
  (VTBL_ENTRY)&_ZN7S6493C93v29Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v30Ev,
  (VTBL_ENTRY)&_ZN7S6493C93v31Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S6493C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S6493C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S6493C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S6493C7_nt3v40Ev,
};
extern VTBL_ENTRY _ZTI7S6493C1[];
extern  VTBL_ENTRY _ZTV7S6493C1[];
Class_Descriptor cd_S6493C1 = {  "S6493C1", // class name
  bases_S6493C1, 4,
  &(vtc_S6493C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,124), // object size
  NSPAIRA(_ZTI7S6493C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S6493C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6494C2  {
  void *s6494c2f0;
  ::S9123C27 s6494c2f1;
  virtual  ~S6494C2(); // _ZN7S6494C2D1Ev
  virtual void  v14(); // _ZN7S6494C23v14Ev
  virtual void  v15(); // _ZN7S6494C23v15Ev
  virtual void  v16(); // _ZN7S6494C23v16Ev
  virtual void  v17(); // _ZN7S6494C23v17Ev
  virtual void  v18(); // _ZN7S6494C23v18Ev
  virtual void  v19(); // _ZN7S6494C23v19Ev
  virtual void  v20(); // _ZN7S6494C23v20Ev
  virtual void  v21(); // _ZN7S6494C23v21Ev
  virtual void  v22(); // _ZN7S6494C23v22Ev
  virtual void  v23(); // _ZN7S6494C23v23Ev
  virtual void  v24(); // _ZN7S6494C23v24Ev
  virtual void  v25(); // _ZN7S6494C23v25Ev
  virtual void  v26(); // _ZN7S6494C23v26Ev
  virtual void  v27(); // _ZN7S6494C23v27Ev
  virtual void  v28(); // _ZN7S6494C23v28Ev
  S6494C2(); // tgen
};
//SIG(-1 S6494C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC4}}}


 S6494C2 ::~S6494C2(){ note_dtor("S6494C2", this);}
void  S6494C2 ::v14(){vfunc_called(this, "_ZN7S6494C23v14Ev");}
void  S6494C2 ::v15(){vfunc_called(this, "_ZN7S6494C23v15Ev");}
void  S6494C2 ::v16(){vfunc_called(this, "_ZN7S6494C23v16Ev");}
void  S6494C2 ::v17(){vfunc_called(this, "_ZN7S6494C23v17Ev");}
void  S6494C2 ::v18(){vfunc_called(this, "_ZN7S6494C23v18Ev");}
void  S6494C2 ::v19(){vfunc_called(this, "_ZN7S6494C23v19Ev");}
void  S6494C2 ::v20(){vfunc_called(this, "_ZN7S6494C23v20Ev");}
void  S6494C2 ::v21(){vfunc_called(this, "_ZN7S6494C23v21Ev");}
void  S6494C2 ::v22(){vfunc_called(this, "_ZN7S6494C23v22Ev");}
void  S6494C2 ::v23(){vfunc_called(this, "_ZN7S6494C23v23Ev");}
void  S6494C2 ::v24(){vfunc_called(this, "_ZN7S6494C23v24Ev");}
void  S6494C2 ::v25(){vfunc_called(this, "_ZN7S6494C23v25Ev");}
void  S6494C2 ::v26(){vfunc_called(this, "_ZN7S6494C23v26Ev");}
void  S6494C2 ::v27(){vfunc_called(this, "_ZN7S6494C23v27Ev");}
void  S6494C2 ::v28(){vfunc_called(this, "_ZN7S6494C23v28Ev");}
S6494C2 ::S6494C2(){ note_ctor("S6494C2", this);} // tgen

static void Test_S6494C2()
{
  extern Class_Descriptor cd_S6494C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S6494C2, buf);
    S6494C2 *dp, &lv = *(dp=new (buf) S6494C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S6494C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6494C2)");
    check_field_offset(lv, s6494c2f0, ABISELECT(8,4), "S6494C2.s6494c2f0");
    check_field_offset(lv, s6494c2f1, ABISELECT(16,8), "S6494C2.s6494c2f1");
    test_class_info(&lv, &cd_S6494C2);
    dp->~S6494C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6494C2(Test_S6494C2, "S6494C2", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN7S6494C2C1Ev();
extern void _ZN7S6494C2D1Ev();
Name_Map name_map_S6494C2[] = {
  NSPAIR(_ZN7S6494C2C1Ev),
  NSPAIR(_ZN7S6494C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S6494C2[];
extern void _ZN7S6494C2D1Ev();
extern void _ZN7S6494C2D0Ev();
extern void _ZN7S6494C23v14Ev();
extern void _ZN7S6494C23v15Ev();
extern void _ZN7S6494C23v16Ev();
extern void _ZN7S6494C23v17Ev();
extern void _ZN7S6494C23v18Ev();
extern void _ZN7S6494C23v19Ev();
extern void _ZN7S6494C23v20Ev();
extern void _ZN7S6494C23v21Ev();
extern void _ZN7S6494C23v22Ev();
extern void _ZN7S6494C23v23Ev();
extern void _ZN7S6494C23v24Ev();
extern void _ZN7S6494C23v25Ev();
extern void _ZN7S6494C23v26Ev();
extern void _ZN7S6494C23v27Ev();
extern void _ZN7S6494C23v28Ev();
static  VTBL_ENTRY vtc_S6494C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6494C2[0]),
  (VTBL_ENTRY)&_ZN7S6494C2D1Ev,
  (VTBL_ENTRY)&_ZN7S6494C2D0Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v14Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v15Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v16Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v17Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v18Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v19Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v20Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v21Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v22Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v23Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v24Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v25Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v26Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v27Ev,
  (VTBL_ENTRY)&_ZN7S6494C23v28Ev,
};
extern VTBL_ENTRY _ZTI7S6494C2[];
extern  VTBL_ENTRY _ZTV7S6494C2[];
Class_Descriptor cd_S6494C2 = {  "S6494C2", // class name
  0,0,//no base classes
  &(vtc_S6494C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI7S6494C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S6494C2),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6494C9  {
  virtual  ~S6494C9(); // _ZN7S6494C9D1Ev
  virtual void  v29(); // _ZN7S6494C93v29Ev
  virtual void  v30(); // _ZN7S6494C93v30Ev
  virtual void  v31(); // _ZN7S6494C93v31Ev
  S6494C9(); // tgen
};
//SIG(-1 S6494C9) C1{ vd v1 v2 v3}


 S6494C9 ::~S6494C9(){ note_dtor("S6494C9", this);}
void  S6494C9 ::v29(){vfunc_called(this, "_ZN7S6494C93v29Ev");}
void  S6494C9 ::v30(){vfunc_called(this, "_ZN7S6494C93v30Ev");}
void  S6494C9 ::v31(){vfunc_called(this, "_ZN7S6494C93v31Ev");}
S6494C9 ::S6494C9(){ note_ctor("S6494C9", this);} // tgen

static void Test_S6494C9()
{
  extern Class_Descriptor cd_S6494C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S6494C9, buf);
    S6494C9 *dp, &lv = *(dp=new (buf) S6494C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S6494C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6494C9)");
    test_class_info(&lv, &cd_S6494C9);
    dp->~S6494C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6494C9(Test_S6494C9, "S6494C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S6494C9C1Ev();
extern void _ZN7S6494C9D1Ev();
Name_Map name_map_S6494C9[] = {
  NSPAIR(_ZN7S6494C9C1Ev),
  NSPAIR(_ZN7S6494C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S6494C9[];
extern void _ZN7S6494C9D1Ev();
extern void _ZN7S6494C9D0Ev();
extern void _ZN7S6494C93v29Ev();
extern void _ZN7S6494C93v30Ev();
extern void _ZN7S6494C93v31Ev();
static  VTBL_ENTRY vtc_S6494C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6494C9[0]),
  (VTBL_ENTRY)&_ZN7S6494C9D1Ev,
  (VTBL_ENTRY)&_ZN7S6494C9D0Ev,
  (VTBL_ENTRY)&_ZN7S6494C93v29Ev,
  (VTBL_ENTRY)&_ZN7S6494C93v30Ev,
  (VTBL_ENTRY)&_ZN7S6494C93v31Ev,
};
extern VTBL_ENTRY _ZTI7S6494C9[];
extern  VTBL_ENTRY _ZTV7S6494C9[];
Class_Descriptor cd_S6494C9 = {  "S6494C9", // class name
  0,0,//no base classes
  &(vtc_S6494C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S6494C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S6494C9),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6494C8  : S6494C9 {
  virtual  ~S6494C8(); // _ZN7S6494C8D1Ev
  virtual void  v32(); // _ZN7S6494C83v32Ev
  virtual void  v33(); // _ZN7S6494C83v33Ev
  virtual void  v34(); // _ZN7S6494C83v34Ev
  virtual void  v35(); // _ZN7S6494C83v35Ev
  virtual void  v36(); // _ZN7S6494C83v36Ev
  virtual void  v37(); // _ZN7S6494C83v37Ev
  S6494C8(); // tgen
};
//SIG(-1 S6494C8) C1{ BC2{ vd v7 v8 v9} vd v1 v2 v3 v4 v5 v6}


 S6494C8 ::~S6494C8(){ note_dtor("S6494C8", this);}
void  S6494C8 ::v32(){vfunc_called(this, "_ZN7S6494C83v32Ev");}
void  S6494C8 ::v33(){vfunc_called(this, "_ZN7S6494C83v33Ev");}
void  S6494C8 ::v34(){vfunc_called(this, "_ZN7S6494C83v34Ev");}
void  S6494C8 ::v35(){vfunc_called(this, "_ZN7S