// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S28C9_nt  {
  int s28c9f0[2];
  void  mf28c9(); // _ZN8S28C9_nt6mf28c9Ev
};
//SIG(-1 S28C9_nt) C1{ m Fi[2]}


void  S28C9_nt ::mf28c9(){}

//skip512 S28C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C8_nt  {
  int s28c8f0;
  __tsi64 s28c8f1;
  void *s28c8f2[4];
  int s28c8f3[2];
  void *s28c8f4;
  ::S28C9_nt s28c8f5;
  void *s28c8f6[2];
  virtual  ~S28C8_nt(); // _ZN8S28C8_ntD1Ev
  virtual void  v4(); // _ZN8S28C8_nt2v4Ev
  virtual void  v5(); // _ZN8S28C8_nt2v5Ev
  virtual void  v6(); // _ZN8S28C8_nt2v6Ev
  virtual void  v7(); // _ZN8S28C8_nt2v7Ev
  virtual void  v8(); // _ZN8S28C8_nt2v8Ev
  virtual void  v9(); // _ZN8S28C8_nt2v9Ev
  virtual void  v10(); // _ZN8S28C8_nt3v10Ev
  virtual void  v11(); // _ZN8S28C8_nt3v11Ev
  virtual void  v12(); // _ZN8S28C8_nt3v12Ev
  virtual void  v13(); // _ZN8S28C8_nt3v13Ev
  virtual void  v14(); // _ZN8S28C8_nt3v14Ev
  virtual void  v15(); // _ZN8S28C8_nt3v15Ev
  virtual void  v16(); // _ZN8S28C8_nt3v16Ev
  virtual void  v17(); // _ZN8S28C8_nt3v17Ev
  virtual void  v18(); // _ZN8S28C8_nt3v18Ev
  virtual void  v19(); // _ZN8S28C8_nt3v19Ev
  virtual void  v20(); // _ZN8S28C8_nt3v20Ev
  virtual void  v21(); // _ZN8S28C8_nt3v21Ev
  virtual void  v22(); // _ZN8S28C8_nt3v22Ev
  virtual void  v23(); // _ZN8S28C8_nt3v23Ev
  virtual void  v24(); // _ZN8S28C8_nt3v24Ev
  virtual void  v25(); // _ZN8S28C8_nt3v25Ev
  virtual void  v26(); // _ZN8S28C8_nt3v26Ev
  virtual void  v27(); // _ZN8S28C8_nt3v27Ev
  virtual void  v28(); // _ZN8S28C8_nt3v28Ev
  virtual void  v29(); // _ZN8S28C8_nt3v29Ev
  virtual void  v30(); // _ZN8S28C8_nt3v30Ev
  virtual void  v31(); // _ZN8S28C8_nt3v31Ev
  virtual void  v32(); // _ZN8S28C8_nt3v32Ev
  virtual void  v33(); // _ZN8S28C8_nt3v33Ev
  virtual void  v34(); // _ZN8S28C8_nt3v34Ev
  virtual void  v35(); // _ZN8S28C8_nt3v35Ev
  virtual void  v36(); // _ZN8S28C8_nt3v36Ev
  virtual void  v37(); // _ZN8S28C8_nt3v37Ev
  virtual void  v38(); // _ZN8S28C8_nt3v38Ev
  virtual void  v39(); // _ZN8S28C8_nt3v39Ev
  virtual void  v40(); // _ZN8S28C8_nt3v40Ev
  virtual void  v41(); // _ZN8S28C8_nt3v41Ev
  virtual void  v42(); // _ZN8S28C8_nt3v42Ev
  virtual void  v43(); // _ZN8S28C8_nt3v43Ev
  virtual void  v44(); // _ZN8S28C8_nt3v44Ev
  virtual void  v45(); // _ZN8S28C8_nt3v45Ev
  virtual void  v46(); // _ZN8S28C8_nt3v46Ev
  virtual void  v47(); // _ZN8S28C8_nt3v47Ev
  virtual void  v48(); // _ZN8S28C8_nt3v48Ev
  virtual void  v49(); // _ZN8S28C8_nt3v49Ev
  virtual void  v50(); // _ZN8S28C8_nt3v50Ev
  virtual void  v51(); // _ZN8S28C8_nt3v51Ev
  virtual void  v52(); // _ZN8S28C8_nt3v52Ev
  virtual void  v53(); // _ZN8S28C8_nt3v53Ev
  virtual void  v54(); // _ZN8S28C8_nt3v54Ev
  virtual void  v55(); // _ZN8S28C8_nt3v55Ev
  virtual void  v56(); // _ZN8S28C8_nt3v56Ev
  virtual void  v57(); // _ZN8S28C8_nt3v57Ev
  virtual void  v58(); // _ZN8S28C8_nt3v58Ev
  virtual void  v59(); // _ZN8S28C8_nt3v59Ev
  virtual void  v60(); // _ZN8S28C8_nt3v60Ev
  virtual void  v61(); // _ZN8S28C8_nt3v61Ev
  virtual void  v62(); // _ZN8S28C8_nt3v62Ev
  virtual void  v63(); // _ZN8S28C8_nt3v63Ev
  virtual void  v64(); // _ZN8S28C8_nt3v64Ev
  virtual void  v65(); // _ZN8S28C8_nt3v65Ev
  virtual void  v66(); // _ZN8S28C8_nt3v66Ev
  virtual void  v67(); // _ZN8S28C8_nt3v67Ev
  S28C8_nt(); // tgen
};
//SIG(-1 S28C8_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S28C8_nt ::~S28C8_nt(){ note_dtor("S28C8_nt", this);}
void  S28C8_nt ::v4(){vfunc_called(this, "_ZN8S28C8_nt2v4Ev");}
void  S28C8_nt ::v5(){vfunc_called(this, "_ZN8S28C8_nt2v5Ev");}
void  S28C8_nt ::v6(){vfunc_called(this, "_ZN8S28C8_nt2v6Ev");}
void  S28C8_nt ::v7(){vfunc_called(this, "_ZN8S28C8_nt2v7Ev");}
void  S28C8_nt ::v8(){vfunc_called(this, "_ZN8S28C8_nt2v8Ev");}
void  S28C8_nt ::v9(){vfunc_called(this, "_ZN8S28C8_nt2v9Ev");}
void  S28C8_nt ::v10(){vfunc_called(this, "_ZN8S28C8_nt3v10Ev");}
void  S28C8_nt ::v11(){vfunc_called(this, "_ZN8S28C8_nt3v11Ev");}
void  S28C8_nt ::v12(){vfunc_called(this, "_ZN8S28C8_nt3v12Ev");}
void  S28C8_nt ::v13(){vfunc_called(this, "_ZN8S28C8_nt3v13Ev");}
void  S28C8_nt ::v14(){vfunc_called(this, "_ZN8S28C8_nt3v14Ev");}
void  S28C8_nt ::v15(){vfunc_called(this, "_ZN8S28C8_nt3v15Ev");}
void  S28C8_nt ::v16(){vfunc_called(this, "_ZN8S28C8_nt3v16Ev");}
void  S28C8_nt ::v17(){vfunc_called(this, "_ZN8S28C8_nt3v17Ev");}
void  S28C8_nt ::v18(){vfunc_called(this, "_ZN8S28C8_nt3v18Ev");}
void  S28C8_nt ::v19(){vfunc_called(this, "_ZN8S28C8_nt3v19Ev");}
void  S28C8_nt ::v20(){vfunc_called(this, "_ZN8S28C8_nt3v20Ev");}
void  S28C8_nt ::v21(){vfunc_called(this, "_ZN8S28C8_nt3v21Ev");}
void  S28C8_nt ::v22(){vfunc_called(this, "_ZN8S28C8_nt3v22Ev");}
void  S28C8_nt ::v23(){vfunc_called(this, "_ZN8S28C8_nt3v23Ev");}
void  S28C8_nt ::v24(){vfunc_called(this, "_ZN8S28C8_nt3v24Ev");}
void  S28C8_nt ::v25(){vfunc_called(this, "_ZN8S28C8_nt3v25Ev");}
void  S28C8_nt ::v26(){vfunc_called(this, "_ZN8S28C8_nt3v26Ev");}
void  S28C8_nt ::v27(){vfunc_called(this, "_ZN8S28C8_nt3v27Ev");}
void  S28C8_nt ::v28(){vfunc_called(this, "_ZN8S28C8_nt3v28Ev");}
void  S28C8_nt ::v29(){vfunc_called(this, "_ZN8S28C8_nt3v29Ev");}
void  S28C8_nt ::v30(){vfunc_called(this, "_ZN8S28C8_nt3v30Ev");}
void  S28C8_nt ::v31(){vfunc_called(this, "_ZN8S28C8_nt3v31Ev");}
void  S28C8_nt ::v32(){vfunc_called(this, "_ZN8S28C8_nt3v32Ev");}
void  S28C8_nt ::v33(){vfunc_called(this, "_ZN8S28C8_nt3v33Ev");}
void  S28C8_nt ::v34(){vfunc_called(this, "_ZN8S28C8_nt3v34Ev");}
void  S28C8_nt ::v35(){vfunc_called(this, "_ZN8S28C8_nt3v35Ev");}
void  S28C8_nt ::v36(){vfunc_called(this, "_ZN8S28C8_nt3v36Ev");}
void  S28C8_nt ::v37(){vfunc_called(this, "_ZN8S28C8_nt3v37Ev");}
void  S28C8_nt ::v38(){vfunc_called(this, "_ZN8S28C8_nt3v38Ev");}
void  S28C8_nt ::v39(){vfunc_called(this, "_ZN8S28C8_nt3v39Ev");}
void  S28C8_nt ::v40(){vfunc_called(this, "_ZN8S28C8_nt3v40Ev");}
void  S28C8_nt ::v41(){vfunc_called(this, "_ZN8S28C8_nt3v41Ev");}
void  S28C8_nt ::v42(){vfunc_called(this, "_ZN8S28C8_nt3v42Ev");}
void  S28C8_nt ::v43(){vfunc_called(this, "_ZN8S28C8_nt3v43Ev");}
void  S28C8_nt ::v44(){vfunc_called(this, "_ZN8S28C8_nt3v44Ev");}
void  S28C8_nt ::v45(){vfunc_called(this, "_ZN8S28C8_nt3v45Ev");}
void  S28C8_nt ::v46(){vfunc_called(this, "_ZN8S28C8_nt3v46Ev");}
void  S28C8_nt ::v47(){vfunc_called(this, "_ZN8S28C8_nt3v47Ev");}
void  S28C8_nt ::v48(){vfunc_called(this, "_ZN8S28C8_nt3v48Ev");}
void  S28C8_nt ::v49(){vfunc_called(this, "_ZN8S28C8_nt3v49Ev");}
void  S28C8_nt ::v50(){vfunc_called(this, "_ZN8S28C8_nt3v50Ev");}
void  S28C8_nt ::v51(){vfunc_called(this, "_ZN8S28C8_nt3v51Ev");}
void  S28C8_nt ::v52(){vfunc_called(this, "_ZN8S28C8_nt3v52Ev");}
void  S28C8_nt ::v53(){vfunc_called(this, "_ZN8S28C8_nt3v53Ev");}
void  S28C8_nt ::v54(){vfunc_called(this, "_ZN8S28C8_nt3v54Ev");}
void  S28C8_nt ::v55(){vfunc_called(this, "_ZN8S28C8_nt3v55Ev");}
void  S28C8_nt ::v56(){vfunc_called(this, "_ZN8S28C8_nt3v56Ev");}
void  S28C8_nt ::v57(){vfunc_called(this, "_ZN8S28C8_nt3v57Ev");}
void  S28C8_nt ::v58(){vfunc_called(this, "_ZN8S28C8_nt3v58Ev");}
void  S28C8_nt ::v59(){vfunc_called(this, "_ZN8S28C8_nt3v59Ev");}
void  S28C8_nt ::v60(){vfunc_called(this, "_ZN8S28C8_nt3v60Ev");}
void  S28C8_nt ::v61(){vfunc_called(this, "_ZN8S28C8_nt3v61Ev");}
void  S28C8_nt ::v62(){vfunc_called(this, "_ZN8S28C8_nt3v62Ev");}
void  S28C8_nt ::v63(){vfunc_called(this, "_ZN8S28C8_nt3v63Ev");}
void  S28C8_nt ::v64(){vfunc_called(this, "_ZN8S28C8_nt3v64Ev");}
void  S28C8_nt ::v65(){vfunc_called(this, "_ZN8S28C8_nt3v65Ev");}
void  S28C8_nt ::v66(){vfunc_called(this, "_ZN8S28C8_nt3v66Ev");}
void  S28C8_nt ::v67(){vfunc_called(this, "_ZN8S28C8_nt3v67Ev");}
S28C8_nt ::S28C8_nt(){ note_ctor("S28C8_nt", this);} // tgen

//skip512 S28C8_nt

#else // __cplusplus

extern void _ZN8S28C8_ntC1Ev();
extern void _ZN8S28C8_ntD1Ev();
Name_Map name_map_S28C8_nt[] = {
  NSPAIR(_ZN8S28C8_ntC1Ev),
  NSPAIR(_ZN8S28C8_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern void _ZN8S28C8_ntD1Ev();
extern void _ZN8S28C8_ntD0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
static  VTBL_ENTRY vtc_S28C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S28C8_nt[0]),
  (VTBL_ENTRY)&_ZN8S28C8_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S28C8_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI8S28C8_nt[];
VTBL_ENTRY *P__ZTI8S28C8_nt = _ZTI8S28C8_nt; 
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
Class_Descriptor cd_S28C8_nt = {  "S28C8_nt", // class name
  0,0,//no base classes
  &(vtc_S28C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S28C8_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S28C8_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C12_nt  {
  void *s28c12f0;
  int s28c12f1[2];
  void  mf28c12(); // _ZN9S28C12_nt7mf28c12Ev
};
//SIG(-1 S28C12_nt) C1{ m Fp Fi[2]}


void  S28C12_nt ::mf28c12(){}

//skip512 S28C12_nt

#else // __cplusplus

Class_Descriptor cd_S28C12_nt = {  "S28C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C11_nt  : S28C12_nt {
};
//SIG(-1 S28C11_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S28C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C11_nt = {  "S28C11_nt", // class name
  bases_S28C11_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C10_nt  : S28C11_nt {
};
//SIG(-1 S28C10_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S28C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C11_nt;
static Base_Class bases_S28C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C13_nt  {
  int s28c13f0;
  void  mf28c13(); // _ZN9S28C13_nt7mf28c13Ev
};
//SIG(-1 S28C13_nt) C1{ m Fi}


void  S28C13_nt ::mf28c13(){}

//skip512 S28C13_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S28C13_nt[];
VTBL_ENTRY *P__ZTI9S28C13_nt = _ZTI9S28C13_nt; 
Class_Descriptor cd_S28C13_nt = {  "S28C13_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI9S28C13_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C17  : S28C12_nt {
};
//SIG(-1 S28C17) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C17()
{
  extern Class_Descriptor cd_S28C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C17, buf);
    S28C17 &lv = *(new (buf) S28C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C17)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C17");
    test_class_info(&lv, &cd_S28C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C17(Test_S28C17, "S28C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C17 = {  "S28C17", // class name
  bases_S28C17, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C16  : S28C17 {
};
//SIG(-1 S28C16) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C16()
{
  extern Class_Descriptor cd_S28C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C16, buf);
    S28C16 &lv = *(new (buf) S28C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C16)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C17*), 0, "S28C16");
    check_base_class_offset(lv, (S28C17*), 0, "S28C16");
    test_class_info(&lv, &cd_S28C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C16(Test_S28C16, "S28C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C17;
static Base_Class bases_S28C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C16 = {  "S28C16", // class name
  bases_S28C16, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C18_nt  {
  int s28c18f0[3];
  void  mf28c18(); // _ZN9S28C18_nt7mf28c18Ev
};
//SIG(-1 S28C18_nt) C1{ m Fi[3]}


void  S28C18_nt ::mf28c18(){}

//skip512 S28C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C23  : S28C12_nt {
};
//SIG(-1 S28C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C23()
{
  extern Class_Descriptor cd_S28C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C23, buf);
    S28C23 &lv = *(new (buf) S28C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C23)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C23");
    test_class_info(&lv, &cd_S28C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C23(Test_S28C23, "S28C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C23 = {  "S28C23", // class name
  bases_S28C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C22  : S28C23 {
};
//SIG(-1 S28C22) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C22()
{
  extern Class_Descriptor cd_S28C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C22, buf);
    S28C22 &lv = *(new (buf) S28C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C22)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C23*), 0, "S28C22");
    check_base_class_offset(lv, (S28C23*), 0, "S28C22");
    test_class_info(&lv, &cd_S28C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C22(Test_S28C22, "S28C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C23;
static Base_Class bases_S28C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C22 = {  "S28C22", // class name
  bases_S28C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C7_nt  : S28C8_nt {
  ::S28C10_nt s28c7f0;
  ::S28C10_nt s28c7f1;
  ::S28C13_nt s28c7f2;
  int s28c7f3;
  char s28c7f4[4];
  void *s28c7f5[2];
  ::S28C10_nt s28c7f6;
  unsigned int s28c7f7:1;
  unsigned int s28c7f8:1;
  unsigned int s28c7f9:1;
  unsigned int s28c7f10:1;
  unsigned int s28c7f11:1;
  unsigned int s28c7f12:1;
  unsigned int s28c7f13:1;
  unsigned int s28c7f14:1;
  unsigned int s28c7f15:1;
  unsigned int s28c7f16:1;
  unsigned int s28c7f17:1;
  unsigned int s28c7f18:1;
  unsigned int s28c7f19:1;
  unsigned int s28c7f20:1;
  unsigned int s28c7f21:1;
  unsigned int s28c7f22:1;
  unsigned int s28c7f23:1;
  unsigned int s28c7f24:1;
  unsigned int s28c7f25:1;
  unsigned int s28c7f26:1;
  unsigned int s28c7f27:1;
  unsigned int s28c7f28:1;
  unsigned int s28c7f29:1;
  unsigned int s28c7f30:1;
  unsigned int s28c7f31:1;
  unsigned int s28c7f32:1;
  unsigned int s28c7f33:1;
  unsigned int s28c7f34:1;
  unsigned int s28c7f35:1;
  unsigned int s28c7f36:1;
  unsigned int s28c7f37:1;
  unsigned int s28c7f38:1;
  unsigned int s28c7f39:1;
  unsigned int s28c7f40:1;
  unsigned int s28c7f41:1;
  unsigned int s28c7f42:1;
  unsigned int s28c7f43:1;
  unsigned int s28c7f44:1;
  unsigned int s28c7f45:1;
  unsigned int s28c7f46:1;
  unsigned int s28c7f47:1;
  unsigned int s28c7f48:1;
  unsigned int s28c7f49:1;
  unsigned int s28c7f50:1;
  unsigned int s28c7f51:1;
  unsigned int s28c7f52:1;
  unsigned int s28c7f53:1;
  unsigned int s28c7f54:1;
  unsigned int s28c7f55:1;
  unsigned int s28c7f56:1;
  unsigned int s28c7f57:1;
  unsigned int s28c7f58:1;
  unsigned int s28c7f59:1;
  unsigned int s28c7f60:1;
  unsigned int s28c7f61:1;
  unsigned int s28c7f62:1;
  unsigned int s28c7f63:1;
  unsigned int s28c7f64:1;
  unsigned int s28c7f65:1;
  unsigned int s28c7f66:1;
  unsigned int s28c7f67:1;
  unsigned int s28c7f68:1;
  unsigned int s28c7f69:1;
  unsigned int s28c7f70:1;
  unsigned int s28c7f71:1;
  unsigned int s28c7f72:1;
  unsigned int s28c7f73:1;
  unsigned int s28c7f74:1;
  unsigned int s28c7f75:1;
  unsigned int s28c7f76:1;
  unsigned int s28c7f77:1;
  unsigned int s28c7f78:1;
  unsigned int s28c7f79:1;
  unsigned int s28c7f80:1;
  unsigned int s28c7f81:1;
  unsigned int s28c7f82:1;
  unsigned int s28c7f83:1;
  int s28c7f84[5];
  void *s28c7f85[2];
  int s28c7f86[3];
  ::S28C9_nt s28c7f87;
  ::S28C9_nt s28c7f88;
  ::S28C9_nt s28c7f89;
  ::S28C16 s28c7f90;
  ::S28C16 s28c7f91;
  int s28c7f92;
  void *s28c7f93[2];
  ::S28C18_nt s28c7f94;
  ::S28C18_nt s28c7f95;
  ::S28C18_nt s28c7f96;
  ::S28C18_nt s28c7f97;
  void *s28c7f98;
  ::S28C9_nt s28c7f99;
  ::S28C16 s28c7f100;
  ::S28C18_nt s28c7f101;
  ::S28C18_nt s28c7f102;
  int s28c7f103;
  ::S28C18_nt s28c7f104;
  ::S28C18_nt s28c7f105;
  void *s28c7f106;
  int s28c7f107;
  char s28c7f108;
  ::S28C18_nt s28c7f109;
  ::S28C18_nt s28c7f110;
  void *s28c7f111;
  int s28c7f112;
  void *s28c7f113;
  ::S28C16 s28c7f114;
  ::S28C22 s28c7f115;
  ::S28C22 s28c7f116;
  virtual  ~S28C7_nt(); // _ZN8S28C7_ntD1Ev
  virtual void  v68(); // _ZN8S28C7_nt3v68Ev
  virtual void  v69(); // _ZN8S28C7_nt3v69Ev
  virtual void  v70(); // _ZN8S28C7_nt3v70Ev
  virtual void  v71(); // _ZN8S28C7_nt3v71Ev
  virtual void  v72(); // _ZN8S28C7_nt3v72Ev
  virtual void  v73(); // _ZN8S28C7_nt3v73Ev
  virtual void  v74(); // _ZN8S28C7_nt3v74Ev
  virtual void  v75(); // _ZN8S28C7_nt3v75Ev
  virtual void  v76(); // _ZN8S28C7_nt3v76Ev
  virtual void  v77(); // _ZN8S28C7_nt3v77Ev
  virtual void  v78(); // _ZN8S28C7_nt3v78Ev
  virtual void  v79(); // _ZN8S28C7_nt3v79Ev
  virtual void  v80(); // _ZN8S28C7_nt3v80Ev
  virtual void  v81(); // _ZN8S28C7_nt3v81Ev
  virtual void  v82(); // _ZN8S28C7_nt3v82Ev
  virtual void  v83(); // _ZN8S28C7_nt3v83Ev
  virtual void  v84(); // _ZN8S28C7_nt3v84Ev
  virtual void  v85(); // _ZN8S28C7_nt3v85Ev
  virtual void  v86(); // _ZN8S28C7_nt3v86Ev
  virtual void  v87(); // _ZN8S28C7_nt3v87Ev
  virtual void  v88(); // _ZN8S28C7_nt3v88Ev
  virtual void  v89(); // _ZN8S28C7_nt3v89Ev
  virtual void  v90(); // _ZN8S28C7_nt3v90Ev
  virtual void  v91(); // _ZN8S28C7_nt3v91Ev
  virtual void  v92(); // _ZN8S28C7_nt3v92Ev
  virtual void  v93(); // _ZN8S28C7_nt3v93Ev
  virtual void  v94(); // _ZN8S28C7_nt3v94Ev
  virtual void  v95(); // _ZN8S28C7_nt3v95Ev
  virtual void  v96(); // _ZN8S28C7_nt3v96Ev
  virtual void  v97(); // _ZN8S28C7_nt3v97Ev
  virtual void  v98(); // _ZN8S28C7_nt3v98Ev
  virtual void  v99(); // _ZN8S28C7_nt3v99Ev
  virtual void  v100(); // _ZN8S28C7_nt4v100Ev
  virtual void  v101(); // _ZN8S28C7_nt4v101Ev
  virtual void  v102(); // _ZN8S28C7_nt4v102Ev
  virtual void  v103(); // _ZN8S28C7_nt4v103Ev
  virtual void  v104(); // _ZN8S28C7_nt4v104Ev
  virtual void  v105(); // _ZN8S28C7_nt4v105Ev
  virtual void  v106(); // _ZN8S28C7_nt4v106Ev
  virtual void  v107(); // _ZN8S28C7_nt4v107Ev
  virtual void  v108(); // _ZN8S28C7_nt4v108Ev
  virtual void  v109(); // _ZN8S28C7_nt4v109Ev
  virtual void  v110(); // _ZN8S28C7_nt4v110Ev
  virtual void  v111(); // _ZN8S28C7_nt4v111Ev
  virtual void  v112(); // _ZN8S28C7_nt4v112Ev
  virtual void  v113(); // _ZN8S28C7_nt4v113Ev
  virtual void  v114(); // _ZN8S28C7_nt4v114Ev
  virtual void  v115(); // _ZN8S28C7_nt4v115Ev
  virtual void  v116(); // _ZN8S28C7_nt4v116Ev
  virtual void  v117(); // _ZN8S28C7_nt4v117Ev
  virtual void  v118(); // _ZN8S28C7_nt4v118Ev
  virtual void  v119(); // _ZN8S28C7_nt4v119Ev
  virtual void  v120(); // _ZN8S28C7_nt4v120Ev
  virtual void  v121(); // _ZN8S28C7_nt4v121Ev
  virtual void  v122(); // _ZN8S28C7_nt4v122Ev
  virtual void  v123(); // _ZN8S28C7_nt4v123Ev
  virtual void  v124(); // _ZN8S28C7_nt4v124Ev
  virtual void  v125(); // _ZN8S28C7_nt4v125Ev
  virtual void  v126(); // _ZN8S28C7_nt4v126Ev
  virtual void  v127(); // _ZN8S28C7_nt4v127Ev
  virtual void  v128(); // _ZN8S28C7_nt4v128Ev
  virtual void  v129(); // _ZN8S28C7_nt4v129Ev
  virtual void  v130(); // _ZN8S28C7_nt4v130Ev
  virtual void  v131(); // _ZN8S28C7_nt4v131Ev
  virtual void  v132(); // _ZN8S28C7_nt4v132Ev
  virtual void  v133(); // _ZN8S28C7_nt4v133Ev
  virtual void  v134(); // _ZN8S28C7_nt4v134Ev
  virtual void  v135(); // _ZN8S28C7_nt4v135Ev
  virtual void  v136(); // _ZN8S28C7_nt4v136Ev
  virtual void  v137(); // _ZN8S28C7_nt4v137Ev
  virtual void  v138(); // _ZN8S28C7_nt4v138Ev
  virtual void  v139(); // _ZN8S28C7_nt4v139Ev
  virtual void  v140(); // _ZN8S28C7_nt4v140Ev
  virtual void  v141(); // _ZN8S28C7_nt4v141Ev
  virtual void  v142(); // _ZN8S28C7_nt4v142Ev
  virtual void  v143(); // _ZN8S28C7_nt4v143Ev
  virtual void  v144(); // _ZN8S28C7_nt4v144Ev
  virtual void  v145(); // _ZN8S28C7_nt4v145Ev
  virtual void  v146(); // _ZN8S28C7_nt4v146Ev
  virtual void  v147(); // _ZN8S28C7_nt4v147Ev
  virtual void  v148(); // _ZN8S28C7_nt4v148Ev
  virtual void  v149(); // _ZN8S28C7_nt4v149Ev
  virtual void  v150(); // _ZN8S28C7_nt4v150Ev
  virtual void  v151(); // _ZN8S28C7_nt4v151Ev
  virtual void  v152(); // _ZN8S28C7_nt4v152Ev
  virtual void  v153(); // _ZN8S28C7_nt4v153Ev
  virtual void  v154(); // _ZN8S28C7_nt4v154Ev
  virtual void  v155(); // _ZN8S28C7_nt4v155Ev
  virtual void  v156(); // _ZN8S28C7_nt4v156Ev
  virtual void  v157(); // _ZN8S28C7_nt4v157Ev
  virtual void  v158(); // _ZN8S28C7_nt4v158Ev
  virtual void  v159(); // _ZN8S28C7_nt4v159Ev
  virtual void  v160(); // _ZN8S28C7_nt4v160Ev
  virtual void  v161(); // _ZN8S28C7_nt4v161Ev
  virtual void  v162(); // _ZN8S28C7_nt4v162Ev
  virtual void  v163(); // _ZN8S28C7_nt4v163Ev
  virtual void  v164(); // _ZN8S28C7_nt4v164Ev
  virtual void  v165(); // _ZN8S28C7_nt4v165Ev
  virtual void  v166(); // _ZN8S28C7_nt4v166Ev
  virtual void  v167(); // _ZN8S28C7_nt4v167Ev
  virtual void  v168(); // _ZN8S28C7_nt4v168Ev
  virtual void  v169(); // _ZN8S28C7_nt4v169Ev
  virtual void  v170(); // _ZN8S28C7_nt4v170Ev
  virtual void  v171(); // _ZN8S28C7_nt4v171Ev
  virtual void  v172(); // _ZN8S28C7_nt4v172Ev
  virtual void  v173(); // _ZN8S28C7_nt4v173Ev
  virtual void  v174(); // _ZN8S28C7_nt4v174Ev
  virtual void  v175(); // _ZN8S28C7_nt4v175Ev
  virtual void  v176(); // _ZN8S28C7_nt4v176Ev
  virtual void  v177(); // _ZN8S28C7_nt4v177Ev
  virtual void  v178(); // _ZN8S28C7_nt4v178Ev
  virtual void  v179(); // _ZN8S28C7_nt4v179Ev
  virtual void  v180(); // _ZN8S28C7_nt4v180Ev
  virtual void  v181(); // _ZN8S28C7_nt4v181Ev
  virtual void  v182(); // _ZN8S28C7_nt4v182Ev
  virtual void  v183(); // _ZN8S28C7_nt4v183Ev
  virtual void  v184(); // _ZN8S28C7_nt4v184Ev
  virtual void  v185(); // _ZN8S28C7_nt4v185Ev
  virtual void  v186(); // _ZN8S28C7_nt4v186Ev
  virtual void  v187(); // _ZN8S28C7_nt4v187Ev
  virtual void  v188(); // _ZN8S28C7_nt4v188Ev
  virtual void  v189(); // _ZN8S28C7_nt4v189Ev
  virtual void  v190(); // _ZN8S28C7_nt4v190Ev
  virtual void  v191(); // _ZN8S28C7_nt4v191Ev
  virtual void  v192(); // _ZN8S28C7_nt4v192Ev
  virtual void  v193(); // _ZN8S28C7_nt4v193Ev
  virtual void  v194(); // _ZN8S28C7_nt4v194Ev
  virtual void  v195(); // _ZN8S28C7_nt4v195Ev
  virtual void  v196(); // _ZN8S28C7_nt4v196Ev
  virtual void  v197(); // _ZN8S28C7_nt4v197Ev
  virtual void  v198(); // _ZN8S28C7_nt4v198Ev
  virtual void  v199(); // _ZN8S28C7_nt4v199Ev
  virtual void  v200(); // _ZN8S28C7_nt4v200Ev
  virtual void  v201(); // _ZN8S28C7_nt4v201Ev
  virtual void  v202(); // _ZN8S28C7_nt4v202Ev
  virtual void  v203(); // _ZN8S28C7_nt4v203Ev
  virtual void  v204(); // _ZN8S28C7_nt4v204Ev
  virtual void  v205(); // _ZN8S28C7_nt4v205Ev
  virtual void  v206(); // _ZN8S28C7_nt4v206Ev
  virtual void  v207(); // _ZN8S28C7_nt4v207Ev
  virtual void  v208(); // _ZN8S28C7_nt4v208Ev
  virtual void  v209(); // _ZN8S28C7_nt4v209Ev
  virtual void  v210(); // _ZN8S28C7_nt4v210Ev
  S28C7_nt(); // tgen
};
//SIG(-1 S28C7_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S28C7_nt ::~S28C7_nt(){ note_dtor("S28C7_nt", this);}
void  S28C7_nt ::v68(){vfunc_called(this, "_ZN8S28C7_nt3v68Ev");}
void  S28C7_nt ::v69(){vfunc_called(this, "_ZN8S28C7_nt3v69Ev");}
void  S28C7_nt ::v70(){vfunc_called(this, "_ZN8S28C7_nt3v70Ev");}
void  S28C7_nt ::v71(){vfunc_called(this, "_ZN8S28C7_nt3v71Ev");}
void  S28C7_nt ::v72(){vfunc_called(this, "_ZN8S28C7_nt3v72Ev");}
void  S28C7_nt ::v73(){vfunc_called(this, "_ZN8S28C7_nt3v73Ev");}
void  S28C7_nt ::v74(){vfunc_called(this, "_ZN8S28C7_nt3v74Ev");}
void  S28C7_nt ::v75(){vfunc_called(this, "_ZN8S28C7_nt3v75Ev");}
void  S28C7_nt ::v76(){vfunc_called(this, "_ZN8S28C7_nt3v76Ev");}
void  S28C7_nt ::v77(){vfunc_called(this, "_ZN8S28C7_nt3v77Ev");}
void  S28C7_nt ::v78(){vfunc_called(this, "_ZN8S28C7_nt3v78Ev");}
void  S28C7_nt ::v79(){vfunc_called(this, "_ZN8S28C7_nt3v79Ev");}
void  S28C7_nt ::v80(){vfunc_called(this, "_ZN8S28C7_nt3v80Ev");}
void  S28C7_nt ::v81(){vfunc_called(this, "_ZN8S28C7_nt3v81Ev");}
void  S28C7_nt ::v82(){vfunc_called(this, "_ZN8S28C7_nt3v82Ev");}
void  S28C7_nt ::v83(){vfunc_called(this, "_ZN8S28C7_nt3v83Ev");}
void  S28C7_nt ::v84(){vfunc_called(this, "_ZN8S28C7_nt3v84Ev");}
void  S28C7_nt ::v85(){vfunc_called(this, "_ZN8S28C7_nt3v85Ev");}
void  S28C7_nt ::v86(){vfunc_called(this, "_ZN8S28C7_nt3v86Ev");}
void  S28C7_nt ::v87(){vfunc_called(this, "_ZN8S28C7_nt3v87Ev");}
void  S28C7_nt ::v88(){vfunc_called(this, "_ZN8S28C7_nt3v88Ev");}
void  S28C7_nt ::v89(){vfunc_called(this, "_ZN8S28C7_nt3v89Ev");}
void  S28C7_nt ::v90(){vfunc_called(this, "_ZN8S28C7_nt3v90Ev");}
void  S28C7_nt ::v91(){vfunc_called(this, "_ZN8S28C7_nt3v91Ev");}
void  S28C7_nt ::v92(){vfunc_called(this, "_ZN8S28C7_nt3v92Ev");}
void  S28C7_nt ::v93(){vfunc_called(this, "_ZN8S28C7_nt3v93Ev");}
void  S28C7_nt ::v94(){vfunc_called(this, "_ZN8S28C7_nt3v94Ev");}
void  S28C7_nt ::v95(){vfunc_called(this, "_ZN8S28C7_nt3v95Ev");}
void  S28C7_nt ::v96(){vfunc_called(this, "_ZN8S28C7_nt3v96Ev");}
void  S28C7_nt ::v97(){vfunc_called(this, "_ZN8S28C7_nt3v97Ev");}
void  S28C7_nt ::v98(){vfunc_called(this, "_ZN8S28C7_nt3v98Ev");}
void  S28C7_nt ::v99(){vfunc_called(this, "_ZN8S28C7_nt3v99Ev");}
void  S28C7_nt ::v100(){vfunc_called(this, "_ZN8S28C7_nt4v100Ev");}
void  S28C7_nt ::v101(){vfunc_called(this, "_ZN8S28C7_nt4v101Ev");}
void  S28C7_nt ::v102(){vfunc_called(this, "_ZN8S28C7_nt4v102Ev");}
void  S28C7_nt ::v103(){vfunc_called(this, "_ZN8S28C7_nt4v103Ev");}
void  S28C7_nt ::v104(){vfunc_called(this, "_ZN8S28C7_nt4v104Ev");}
void  S28C7_nt ::v105(){vfunc_called(this, "_ZN8S28C7_nt4v105Ev");}
void  S28C7_nt ::v106(){vfunc_called(this, "_ZN8S28C7_nt4v106Ev");}
void  S28C7_nt ::v107(){vfunc_called(this, "_ZN8S28C7_nt4v107Ev");}
void  S28C7_nt ::v108(){vfunc_called(this, "_ZN8S28C7_nt4v108Ev");}
void  S28C7_nt ::v109(){vfunc_called(this, "_ZN8S28C7_nt4v109Ev");}
void  S28C7_nt ::v110(){vfunc_called(this, "_ZN8S28C7_nt4v110Ev");}
void  S28C7_nt ::v111(){vfunc_called(this, "_ZN8S28C7_nt4v111Ev");}
void  S28C7_nt ::v112(){vfunc_called(this, "_ZN8S28C7_nt4v112Ev");}
void  S28C7_nt ::v113(){vfunc_called(this, "_ZN8S28C7_nt4v113Ev");}
void  S28C7_nt ::v114(){vfunc_called(this, "_ZN8S28C7_nt4v114Ev");}
void  S28C7_nt ::v115(){vfunc_called(this, "_ZN8S28C7_nt4v115Ev");}
void  S28C7_nt ::v116(){vfunc_called(this, "_ZN8S28C7_nt4v116Ev");}
void  S28C7_nt ::v117(){vfunc_called(this, "_ZN8S28C7_nt4v117Ev");}
void  S28C7_nt ::v118(){vfunc_called(this, "_ZN8S28C7_nt4v118Ev");}
void  S28C7_nt ::v119(){vfunc_called(this, "_ZN8S28C7_nt4v119Ev");}
void  S28C7_nt ::v120(){vfunc_called(this, "_ZN8S28C7_nt4v120Ev");}
void  S28C7_nt ::v121(){vfunc_called(this, "_ZN8S28C7_nt4v121Ev");}
void  S28C7_nt ::v122(){vfunc_called(this, "_ZN8S28C7_nt4v122Ev");}
void  S28C7_nt ::v123(){vfunc_called(this, "_ZN8S28C7_nt4v123Ev");}
void  S28C7_nt ::v124(){vfunc_called(this, "_ZN8S28C7_nt4v124Ev");}
void  S28C7_nt ::v125(){vfunc_called(this, "_ZN8S28C7_nt4v125Ev");}
void  S28C7_nt ::v126(){vfunc_called(this, "_ZN8S28C7_nt4v126Ev");}
void  S28C7_nt ::v127(){vfunc_called(this, "_ZN8S28C7_nt4v127Ev");}
void  S28C7_nt ::v128(){vfunc_called(this, "_ZN8S28C7_nt4v128Ev");}
void  S28C7_nt ::v129(){vfunc_called(this, "_ZN8S28C7_nt4v129Ev");}
void  S28C7_nt ::v130(){vfunc_called(this, "_ZN8S28C7_nt4v130Ev");}
void  S28C7_nt ::v131(){vfunc_called(this, "_ZN8S28C7_nt4v131Ev");}
void  S28C7_nt ::v132(){vfunc_called(this, "_ZN8S28C7_nt4v132Ev");}
void  S28C7_nt ::v133(){vfunc_called(this, "_ZN8S28C7_nt4v133Ev");}
void  S28C7_nt ::v134(){vfunc_called(this, "_ZN8S28C7_nt4v134Ev");}
void  S28C7_nt ::v135(){vfunc_called(this, "_ZN8S28C7_nt4v135Ev");}
void  S28C7_nt ::v136(){vfunc_called(this, "_ZN8S28C7_nt4v136Ev");}
void  S28C7_nt ::v137(){vfunc_called(this, "_ZN8S28C7_nt4v137Ev");}
void  S28C7_nt ::v138(){vfunc_called(this, "_ZN8S28C7_nt4v138Ev");}
void  S28C7_nt ::v139(){vfunc_called(this, "_ZN8S28C7_nt4v139Ev");}
void  S28C7_nt ::v140(){vfunc_called(this, "_ZN8S28C7_nt4v140Ev");}
void  S28C7_nt ::v141(){vfunc_called(this, "_ZN8S28C7_nt4v141Ev");}
void  S28C7_nt ::v142(){vfunc_called(this, "_ZN8S28C7_nt4v142Ev");}
void  S28C7_nt ::v143(){vfunc_called(this, "_ZN8S28C7_nt4v143Ev");}
void  S28C7_nt ::v144(){vfunc_called(this, "_ZN8S28C7_nt4v144Ev");}
void  S28C7_nt ::v145(){vfunc_called(this, "_ZN8S28C7_nt4v145Ev");}
void  S28C7_nt ::v146(){vfunc_called(this, "_ZN8S28C7_nt4v146Ev");}
void  S28C7_nt ::v147(){vfunc_called(this, "_ZN8S28C7_nt4v147Ev");}
void  S28C7_nt ::v148(){vfunc_called(this, "_ZN8S28C7_nt4v148Ev");}
void  S28C7_nt ::v149(){vfunc_called(this, "_ZN8S28C7_nt4v149Ev");}
void  S28C7_nt ::v150(){vfunc_called(this, "_ZN8S28C7_nt4v150Ev");}
void  S28C7_nt ::v151(){vfunc_called(this, "_ZN8S28C7_nt4v151Ev");}
void  S28C7_nt ::v152(){vfunc_called(this, "_ZN8S28C7_nt4v152Ev");}
void  S28C7_nt ::v153(){vfunc_called(this, "_ZN8S28C7_nt4v153Ev");}
void  S28C7_nt ::v154(){vfunc_called(this, "_ZN8S28C7_nt4v154Ev");}
void  S28C7_nt ::v155(){vfunc_called(this, "_ZN8S28C7_nt4v155Ev");}
void  S28C7_nt ::v156(){vfunc_called(this, "_ZN8S28C7_nt4v156Ev");}
void  S28C7_nt ::v157(){vfunc_called(this, "_ZN8S28C7_nt4v157Ev");}
void  S28C7_nt ::v158(){vfunc_called(this, "_ZN8S28C7_nt4v158Ev");}
void  S28C7_nt ::v159(){vfunc_called(this, "_ZN8S28C7_nt4v159Ev");}
void  S28C7_nt ::v160(){vfunc_called(this, "_ZN8S28C7_nt4v160Ev");}
void  S28C7_nt ::v161(){vfunc_called(this, "_ZN8S28C7_nt4v161Ev");}
void  S28C7_nt ::v162(){vfunc_called(this, "_ZN8S28C7_nt4v162Ev");}
void  S28C7_nt ::v163(){vfunc_called(this, "_ZN8S28C7_nt4v163Ev");}
void  S28C7_nt ::v164(){vfunc_called(this, "_ZN8S28C7_nt4v164Ev");}
void  S28C7_nt ::v165(){vfunc_called(this, "_ZN8S28C7_nt4v165Ev");}
void  S28C7_nt ::v166(){vfunc_called(this, "_ZN8S28C7_nt4v166Ev");}
void  S28C7_nt ::v167(){vfunc_called(this, "_ZN8S28C7_nt4v167Ev");}
void  S28C7_nt ::v168(){vfunc_called(this, "_ZN8S28C7_nt4v168Ev");}
void  S28C7_nt ::v169(){vfunc_called(this, "_ZN8S28C7_nt4v169Ev");}
void  S28C7_nt ::v170(){vfunc_called(this, "_ZN8S28C7_nt4v170Ev");}
void  S28C7_nt ::v171(){vfunc_called(this, "_ZN8S28C7_nt4v171Ev");}
void  S28C7_nt ::v172(){vfunc_called(this, "_ZN8S28C7_nt4v172Ev");}
void  S28C7_nt ::v173(){vfunc_called(this, "_ZN8S28C7_nt4v173Ev");}
void  S28C7_nt ::v174(){vfunc_called(this, "_ZN8S28C7_nt4v174Ev");}
void  S28C7_nt ::v175(){vfunc_called(this, "_ZN8S28C7_nt4v175Ev");}
void  S28C7_nt ::v176(){vfunc_called(this, "_ZN8S28C7_nt4v176Ev");}
void  S28C7_nt ::v177(){vfunc_called(this, "_ZN8S28C7_nt4v177Ev");}
void  S28C7_nt ::v178(){vfunc_called(this, "_ZN8S28C7_nt4v178Ev");}
void  S28C7_nt ::v179(){vfunc_called(this, "_ZN8S28C7_nt4v179Ev");}
void  S28C7_nt ::v180(){vfunc_called(this, "_ZN8S28C7_nt4v180Ev");}
void  S28C7_nt ::v181(){vfunc_called(this, "_ZN8S28C7_nt4v181Ev");}
void  S28C7_nt ::v182(){vfunc_called(this, "_ZN8S28C7_nt4v182Ev");}
void  S28C7_nt ::v183(){vfunc_called(this, "_ZN8S28C7_nt4v183Ev");}
void  S28C7_nt ::v184(){vfunc_called(this, "_ZN8S28C7_nt4v184Ev");}
void  S28C7_nt ::v185(){vfunc_called(this, "_ZN8S28C7_nt4v185Ev");}
void  S28C7_nt ::v186(){vfunc_called(this, "_ZN8S28C7_nt4v186Ev");}
void  S28C7_nt ::v187(){vfunc_called(this, "_ZN8S28C7_nt4v187Ev");}
void  S28C7_nt ::v188(){vfunc_called(this, "_ZN8S28C7_nt4v188Ev");}
void  S28C7_nt ::v189(){vfunc_called(this, "_ZN8S28C7_nt4v189Ev");}
void  S28C7_nt ::v190(){vfunc_called(this, "_ZN8S28C7_nt4v190Ev");}
void  S28C7_nt ::v191(){vfunc_called(this, "_ZN8S28C7_nt4v191Ev");}
void  S28C7_nt ::v192(){vfunc_called(this, "_ZN8S28C7_nt4v192Ev");}
void  S28C7_nt ::v193(){vfunc_called(this, "_ZN8S28C7_nt4v193Ev");}
void  S28C7_nt ::v194(){vfunc_called(this, "_ZN8S28C7_nt4v194Ev");}
void  S28C7_nt ::v195(){vfunc_called(this, "_ZN8S28C7_nt4v195Ev");}
void  S28C7_nt ::v196(){vfunc_called(this, "_ZN8S28C7_nt4v196Ev");}
void  S28C7_nt ::v197(){vfunc_called(this, "_ZN8S28C7_nt4v197Ev");}
void  S28C7_nt ::v198(){vfunc_called(this, "_ZN8S28C7_nt4v198Ev");}
void  S28C7_nt ::v199(){vfunc_called(this, "_ZN8S28C7_nt4v199Ev");}
void  S28C7_nt ::v200(){vfunc_called(this, "_ZN8S28C7_nt4v200Ev");}
void  S28C7_nt ::v201(){vfunc_called(this, "_ZN8S28C7_nt4v201Ev");}
void  S28C7_nt ::v202(){vfunc_called(this, "_ZN8S28C7_nt4v202Ev");}
void  S28C7_nt ::v203(){vfunc_called(this, "_ZN8S28C7_nt4v203Ev");}
void  S28C7_nt ::v204(){vfunc_called(this, "_ZN8S28C7_nt4v204Ev");}
void  S28C7_nt ::v205(){vfunc_called(this, "_ZN8S28C7_nt4v205Ev");}
void  S28C7_nt ::v206(){vfunc_called(this, "_ZN8S28C7_nt4v206Ev");}
void  S28C7_nt ::v207(){vfunc_called(this, "_ZN8S28C7_nt4v207Ev");}
void  S28C7_nt ::v208(){vfunc_called(this, "_ZN8S28C7_nt4v208Ev");}
void  S28C7_nt ::v209(){vfunc_called(this, "_ZN8S28C7_nt4v209Ev");}
void  S28C7_nt ::v210(){vfunc_called(this, "_ZN8S28C7_nt4v210Ev");}
S28C7_nt ::S28C7_nt(){ note_ctor("S28C7_nt", this);} // tgen

//skip512 S28C7_nt

#else // __cplusplus

extern void _ZN8S28C7_ntC1Ev();
extern void _ZN8S28C7_ntD1Ev();
Name_Map name_map_S28C7_nt[] = {
  NSPAIR(_ZN8S28C7_ntC1Ev),
  NSPAIR(_ZN8S28C7_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S28C8_nt;
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
static Base_Class bases_S28C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S28C7_nt[];
extern void _ZN8S28C7_ntD1Ev();
extern void _ZN8S28C7_ntD0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
extern void _ZN8S28C7_nt3v68Ev();
extern void _ZN8S28C7_nt3v69Ev();
extern void _ZN8S28C7_nt3v70Ev();
extern void _ZN8S28C7_nt3v71Ev();
extern void _ZN8S28C7_nt3v72Ev();
extern void _ZN8S28C7_nt3v73Ev();
extern void _ZN8S28C7_nt3v74Ev();
extern void _ZN8S28C7_nt3v75Ev();
extern void _ZN8S28C7_nt3v76Ev();
extern void _ZN8S28C7_nt3v77Ev();
extern void _ZN8S28C7_nt3v78Ev();
extern void _ZN8S28C7_nt3v79Ev();
extern void _ZN8S28C7_nt3v80Ev();
extern void _ZN8S28C7_nt3v81Ev();
extern void _ZN8S28C7_nt3v82Ev();
extern void _ZN8S28C7_nt3v83Ev();
extern void _ZN8S28C7_nt3v84Ev();
extern void _ZN8S28C7_nt3v85Ev();
extern void _ZN8S28C7_nt3v86Ev();
extern void _ZN8S28C7_nt3v87Ev();
extern void _ZN8S28C7_nt3v88Ev();
extern void _ZN8S28C7_nt3v89Ev();
extern void _ZN8S28C7_nt3v90Ev();
extern void _ZN8S28C7_nt3v91Ev();
extern void _ZN8S28C7_nt3v92Ev();
extern void _ZN8S28C7_nt3v93Ev();
extern void _ZN8S28C7_nt3v94Ev();
extern void _ZN8S28C7_nt3v95Ev();
extern void _ZN8S28C7_nt3v96Ev();
extern void _ZN8S28C7_nt3v97Ev();
extern void _ZN8S28C7_nt3v98Ev();
extern void _ZN8S28C7_nt3v99Ev();
extern void _ZN8S28C7_nt4v100Ev();
extern void _ZN8S28C7_nt4v101Ev();
extern void _ZN8S28C7_nt4v102Ev();
extern void _ZN8S28C7_nt4v103Ev();
extern void _ZN8S28C7_nt4v104Ev();
extern void _ZN8S28C7_nt4v105Ev();
extern void _ZN8S28C7_nt4v106Ev();
extern void _ZN8S28C7_nt4v107Ev();
extern void _ZN8S28C7_nt4v108Ev();
extern void _ZN8S28C7_nt4v109Ev();
extern void _ZN8S28C7_nt4v110Ev();
extern void _ZN8S28C7_nt4v111Ev();
extern void _ZN8S28C7_nt4v112Ev();
extern void _ZN8S28C7_nt4v113Ev();
extern void _ZN8S28C7_nt4v114Ev();
extern void _ZN8S28C7_nt4v115Ev();
extern void _ZN8S28C7_nt4v116Ev();
extern void _ZN8S28C7_nt4v117Ev();
extern void _ZN8S28C7_nt4v118Ev();
extern void _ZN8S28C7_nt4v119Ev();
extern void _ZN8S28C7_nt4v120Ev();
extern void _ZN8S28C7_nt4v121Ev();
extern void _ZN8S28C7_nt4v122Ev();
extern void _ZN8S28C7_nt4v123Ev();
extern void _ZN8S28C7_nt4v124Ev();
extern void _ZN8S28C7_nt4v125Ev();
extern void _ZN8S28C7_nt4v126Ev();
extern void _ZN8S28C7_nt4v127Ev();
extern void _ZN8S28C7_nt4v128Ev();
extern void _ZN8S28C7_nt4v129Ev();
extern void _ZN8S28C7_nt4v130Ev();
extern void _ZN8S28C7_nt4v131Ev();
extern void _ZN8S28C7_nt4v132Ev();
extern void _ZN8S28C7_nt4v133Ev();
extern void _ZN8S28C7_nt4v134Ev();
extern void _ZN8S28C7_nt4v135Ev();
extern void _ZN8S28C7_nt4v136Ev();
extern void _ZN8S28C7_nt4v137Ev();
extern void _ZN8S28C7_nt4v138Ev();
extern void _ZN8S28C7_nt4v139Ev();
extern void _ZN8S28C7_nt4v140Ev();
extern void _ZN8S28C7_nt4v141Ev();
extern void _ZN8S28C7_nt4v142Ev();
extern void _ZN8S28C7_nt4v143Ev();
extern void _ZN8S28C7_nt4v144Ev();
extern void _ZN8S28C7_nt4v145Ev();
extern void _ZN8S28C7_nt4v146Ev();
extern void _ZN8S28C7_nt4v147Ev();
extern void _ZN8S28C7_nt4v148Ev();
extern void _ZN8S28C7_nt4v149Ev();
extern void _ZN8S28C7_nt4v150Ev();
extern void _ZN8S28C7_nt4v151Ev();
extern void _ZN8S28C7_nt4v152Ev();
extern void _ZN8S28C7_nt4v153Ev();
extern void _ZN8S28C7_nt4v154Ev();
extern void _ZN8S28C7_nt4v155Ev();
extern void _ZN8S28C7_nt4v156Ev();
extern void _ZN8S28C7_nt4v157Ev();
extern void _ZN8S28C7_nt4v158Ev();
extern void _ZN8S28C7_nt4v159Ev();
extern void _ZN8S28C7_nt4v160Ev();
extern void _ZN8S28C7_nt4v161Ev();
extern void _ZN8S28C7_nt4v162Ev();
extern void _ZN8S28C7_nt4v163Ev();
extern void _ZN8S28C7_nt4v164Ev();
extern void _ZN8S28C7_nt4v165Ev();
extern void _ZN8S28C7_nt4v166Ev();
extern void _ZN8S28C7_nt4v167Ev();
extern void _ZN8S28C7_nt4v168Ev();
extern void _ZN8S28C7_nt4v169Ev();
extern void _ZN8S28C7_nt4v170Ev();
extern void _ZN8S28C7_nt4v171Ev();
extern void _ZN8S28C7_nt4v172Ev();
extern void _ZN8S28C7_nt4v173Ev();
extern void _ZN8S28C7_nt4v174Ev();
extern void _ZN8S28C7_nt4v175Ev();
extern void _ZN8S28C7_nt4v176Ev();
extern void _ZN8S28C7_nt4v177Ev();
extern void _ZN8S28C7_nt4v178Ev();
extern void _ZN8S28C7_nt4v179Ev();
extern void _ZN8S28C7_nt4v180Ev();
extern void _ZN8S28C7_nt4v181Ev();
extern void _ZN8S28C7_nt4v182Ev();
extern void _ZN8S28C7_nt4v183Ev();
extern void _ZN8S28C7_nt4v184Ev();
extern void _ZN8S28C7_nt4v185Ev();
extern void _ZN8S28C7_nt4v186Ev();
extern void _ZN8S28C7_nt4v187Ev();
extern void _ZN8S28C7_nt4v188Ev();
extern void _ZN8S28C7_nt4v189Ev();
extern void _ZN8S28C7_nt4v190Ev();
extern void _ZN8S28C7_nt4v191Ev();
extern void _ZN8S28C7_nt4v192Ev();
extern void _ZN8S28C7_nt4v193Ev();
extern void _ZN8S28C7_nt4v194Ev();
extern void _ZN8S28C7_nt4v195Ev();
extern void _ZN8S28C7_nt4v196Ev();
extern void _ZN8S28C7_nt4v197Ev();
extern void _ZN8S28C7_nt4v198Ev();
extern void _ZN8S28C7_nt4v199Ev();
extern void _ZN8S28C7_nt4v200Ev();
extern void _ZN8S28C7_nt4v201Ev();
extern void _ZN8S28C7_nt4v202Ev();
extern void _ZN8S28C7_nt4v203Ev();
extern void _ZN8S28C7_nt4v204Ev();
extern void _ZN8S28C7_nt4v205Ev();
extern void _ZN8S28C7_nt4v206Ev();
extern void _ZN8S28C7_nt4v207Ev();
extern void _ZN8S28C7_nt4v208Ev();
extern void _ZN8S28C7_nt4v209Ev();
extern void _ZN8S28C7_nt4v210Ev();
static  VTBL_ENTRY vtc_S28C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S28C7_nt[0]),
  (VTBL_ENTRY)&_ZN8S28C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S28C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v210Ev,
};
extern VTBL_ENTRY _ZTI8S28C7_nt[];
VTBL_ENTRY *P__ZTI8S28C7_nt = _ZTI8S28C7_nt; 
extern  VTBL_ENTRY _ZTV8S28C7_nt[];
Class_Descriptor cd_S28C7_nt = {  "S28C7_nt", // class name
  bases_S28C7_nt, 1,
  &(vtc_S28C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI8S28C7_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S28C7_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C27  : S28C12_nt {
};
//SIG(-1 S28C27) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C27()
{
  extern Class_Descriptor cd_S28C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C27, buf);
    S28C27 &lv = *(new (buf) S28C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C27)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C27");
    test_class_info(&lv, &cd_S28C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C27(Test_S28C27, "S28C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C27 = {  "S28C27", // class name
  bases_S28C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C26  : S28C27 {
};
//SIG(-1 S28C26) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C26()
{
  extern Class_Descriptor cd_S28C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C26, buf);
    S28C26 &lv = *(new (buf) S28C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C26)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C27*), 0, "S28C26");
    check_base_class_offset(lv, (S28C27*), 0, "S28C26");
    test_class_info(&lv, &cd_S28C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C26(Test_S28C26, "S28C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C27;
static Base_Class bases_S28C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C26 = {  "S28C26", // class name
  bases_S28C26, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C6  : S28C7_nt {
  void *s28c6f0[2];
  int s28c6f1;
  void *s28c6f2;
  unsigned int s28c6f3:1;
  unsigned int s28c6f4:1;
  unsigned int s28c6f5:1;
  unsigned int s28c6f6:1;
  unsigned int s28c6f7:1;
  unsigned int s28c6f8:1;
  unsigned int s28c6f9:1;
  unsigned int s28c6f10:1;
  unsigned int s28c6f11:1;
  unsigned int s28c6f12:1;
  unsigned int s28c6f13:1;
  unsigned int s28c6f14:1;
  unsigned int s28c6f15:1;
  unsigned int s28c6f16:1;
  unsigned int s28c6f17:1;
  unsigned int s28c6f18:1;
  unsigned int s28c6f19:1;
  unsigned int s28c6f20:1;
  unsigned int s28c6f21:1;
  char s28c6f22;
  int s28c6f23[2];
  void *s28c6f24;
  ::S28C18_nt s28c6f25;
  ::S28C18_nt s28c6f26;
  void *s28c6f27[5];
  ::S28C18_nt s28c6f28;
  void *s28c6f29;
  ::S28C26 s28c6f30;
  void *s28c6f31[2];
  ::S28C18_nt s28c6f32;
  void *s28c6f33;
  int s28c6f34[2];
  void *s28c6f35;
  int s28c6f36;
  ::S28C18_nt s28c6f37;
  ::S28C18_nt s28c6f38;
  ::S28C18_nt s28c6f39;
  void *s28c6f40[2];
  int s28c6f41;
  ::S28C18_nt s28c6f42;
  int s28c6f43[4];
  void *s28c6f44[2];
  ::S28C26 s28c6f45;
  int s28c6f46;
  ::S28C18_nt s28c6f47;
  virtual  ~S28C6(); // _ZN5S28C6D1Ev
  virtual void  v211(); // _ZN5S28C64v211Ev
  virtual void  v212(); // _ZN5S28C64v212Ev
  virtual void  v213(); // _ZN5S28C64v213Ev
  virtual void  v214(); // _ZN5S28C64v214Ev
  virtual void  v215(); // _ZN5S28C64v215Ev
  virtual void  v216(); // _ZN5S28C64v216Ev
  virtual void  v217(); // _ZN5S28C64v217Ev
  virtual void  v218(); // _ZN5S28C64v218Ev
  virtual void  v219(); // _ZN5S28C64v219Ev
  virtual void  v220(); // _ZN5S28C64v220Ev
  virtual void  v221(); // _ZN5S28C64v221Ev
  virtual void  v222(); // _ZN5S28C64v222Ev
  virtual void  v223(); // _ZN5S28C64v223Ev
  virtual void  v224(); // _ZN5S28C64v224Ev
  virtual void  v225(); // _ZN5S28C64v225Ev
  virtual void  v226(); // _ZN5S28C64v226Ev
  virtual void  v227(); // _ZN5S28C64v227Ev
  virtual void  v228(); // _ZN5S28C64v228Ev
  virtual void  v229(); // _ZN5S28C64v229Ev
  virtual void  v230(); // _ZN5S28C64v230Ev
  virtual void  v231(); // _ZN5S28C64v231Ev
  virtual void  v232(); // _ZN5S28C64v232Ev
  virtual void  v233(); // _ZN5S28C64v233Ev
  virtual void  v234(); // _ZN5S28C64v234Ev
  virtual void  v235(); // _ZN5S28C64v235Ev
  virtual void  v236(); // _ZN5S28C64v236Ev
  virtual void  v237(); // _ZN5S28C64v237Ev
  virtual void  v238(); // _ZN5S28C64v238Ev
  virtual void  v239(); // _ZN5S28C64v239Ev
  virtual void  v240(); // _ZN5S28C64v240Ev
  virtual void  v241(); // _ZN5S28C64v241Ev
  virtual void  v242(); // _ZN5S28C64v242Ev
  virtual void  v243(); // _ZN5S28C64v243Ev
  virtual void  v244(); // _ZN5S28C64v244Ev
  virtual void  v245(); // _ZN5S28C64v245Ev
  virtual void  v246(); // _ZN5S28C64v246Ev
  virtual void  v247(); // _ZN5S28C64v247Ev
  virtual void  v248(); // _ZN5S28C64v248Ev
  virtual void  v249(); // _ZN5S28C64v249Ev
  virtual void  v250(); // _ZN5S28C64v250Ev
  virtual void  v251(); // _ZN5S28C64v251Ev
  virtual void  v252(); // _ZN5S28C64v252Ev
  virtual void  v253(); // _ZN5S28C64v253Ev
  virtual void  v254(); // _ZN5S28C64v254Ev
  virtual void  v255(); // _ZN5S28C64v255Ev
  virtual void  v256(); // _ZN5S28C64v256Ev
  virtual void  v257(); // _ZN5S28C64v257Ev
  virtual void  v258(); // _ZN5S28C64v258Ev
  virtual void  v259(); // _ZN5S28C64v259Ev
  virtual void  v260(); // _ZN5S28C64v260Ev
  S28C6(); // tgen
};
//SIG(-1 S28C6) C1{ BC2{ BC3{ vd v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC11 FC11 Fp[5] FC11 Fp FC14{ BC15{ BC7}} Fp[2] FC11 Fp Fi[2] Fp Fi FC11 FC11 FC11 Fp[2] Fi FC11 Fi[4] Fp[2] FC14 Fi FC11}


 S28C6 ::~S28C6(){ note_dtor("S28C6", this);}
void  S28C6 ::v211(){vfunc_called(this, "_ZN5S28C64v211Ev");}
void  S28C6 ::v212(){vfunc_called(this, "_ZN5S28C64v212Ev");}
void  S28C6 ::v213(){vfunc_called(this, "_ZN5S28C64v213Ev");}
void  S28C6 ::v214(){vfunc_called(this, "_ZN5S28C64v214Ev");}
void  S28C6 ::v215(){vfunc_called(this, "_ZN5S28C64v215Ev");}
void  S28C6 ::v216(){vfunc_called(this, "_ZN5S28C64v216Ev");}
void  S28C6 ::v217(){vfunc_called(this, "_ZN5S28C64v217Ev");}
void  S28C6 ::v218(){vfunc_called(this, "_ZN5S28C64v218Ev");}
void  S28C6 ::v219(){vfunc_called(this, "_ZN5S28C64v219Ev");}
void  S28C6 ::v220(){vfunc_called(this, "_ZN5S28C64v220Ev");}
void  S28C6 ::v221(){vfunc_called(this, "_ZN5S28C64v221Ev");}
void  S28C6 ::v222(){vfunc_called(this, "_ZN5S28C64v222Ev");}
void  S28C6 ::v223(){vfunc_called(this, "_ZN5S28C64v223Ev");}
void  S28C6 ::v224(){vfunc_called(this, "_ZN5S28C64v224Ev");}
void  S28C6 ::v225(){vfunc_called(this, "_ZN5S28C64v225Ev");}
void  S28C6 ::v226(){vfunc_called(this, "_ZN5S28C64v226Ev");}
void  S28C6 ::v227(){vfunc_called(this, "_ZN5S28C64v227Ev");}
void  S28C6 ::v228(){vfunc_called(this, "_ZN5S28C64v228Ev");}
void  S28C6 ::v229(){vfunc_called(this, "_ZN5S28C64v229Ev");}
void  S28C6 ::v230(){vfunc_called(this, "_ZN5S28C64v230Ev");}
void  S28C6 ::v231(){vfunc_called(this, "_ZN5S28C64v231Ev");}
void  S28C6 ::v232(){vfunc_called(this, "_ZN5S28C64v232Ev");}
void  S28C6 ::v233(){vfunc_called(this, "_ZN5S28C64v233Ev");}
void  S28C6 ::v234(){vfunc_called(this, "_ZN5S28C64v234Ev");}
void  S28C6 ::v235(){vfunc_called(this, "_ZN5S28C64v235Ev");}
void  S28C6 ::v236(){vfunc_called(this, "_ZN5S28C64v236Ev");}
void  S28C6 ::v237(){vfunc_called(this, "_ZN5S28C64v237Ev");}
void  S28C6 ::v238(){vfunc_called(this, "_ZN5S28C64v238Ev");}
void  S28C6 ::v239(){vfunc_called(this, "_ZN5S28C64v239Ev");}
void  S28C6 ::v240(){vfunc_called(this, "_ZN5S28C64v240Ev");}
void  S28C6 ::v241(){vfunc_called(this, "_ZN5S28C64v241Ev");}
void  S28C6 ::v242(){vfunc_called(this, "_ZN5S28C64v242Ev");}
void  S28C6 ::v243(){vfunc_called(this, "_ZN5S28C64v243Ev");}
void  S28C6 ::v244(){vfunc_called(this, "_ZN5S28C64v244Ev");}
void  S28C6 ::v245(){vfunc_called(this, "_ZN5S28C64v245Ev");}
void  S28C6 ::v246(){vfunc_called(this, "_ZN5S28C64v246Ev");}
void  S28C6 ::v247(){vfunc_called(this, "_ZN5S28C64v247Ev");}
void  S28C6 ::v248(){vfunc_called(this, "_ZN5S28C64v248Ev");}
void  S28C6 ::v249(){vfunc_called(this, "_ZN5S28C64v249Ev");}
void  S28C6 ::v250(){vfunc_called(this, "_ZN5S28C64v250Ev");}
void  S28C6 ::v251(){vfunc_called(this, "_ZN5S28C64v251Ev");}
void  S28C6 ::v252(){vfunc_called(this, "_ZN5S28C64v252Ev");}
void  S28C6 ::v253(){vfunc_called(this, "_ZN5S28C64v253Ev");}
void  S28C6 ::v254(){vfunc_called(this, "_ZN5S28C64v254Ev");}
void  S28C6 ::v255(){vfunc_called(this, "_ZN5S28C64v255Ev");}
void  S28C6 ::v256(){vfunc_called(this, "_ZN5S28C64v256Ev");}
void  S28C6 ::v257(){vfunc_called(this, "_ZN5S28C64v257Ev");}
void  S28C6 ::v258(){vfunc_called(this, "_ZN5S28C64v258Ev");}
void  S28C6 ::v259(){vfunc_called(this, "_ZN5S28C64v259Ev");}
void  S28C6 ::v260(){vfunc_called(this, "_ZN5S28C64v260Ev");}
S28C6 ::S28C6(){ note_ctor("S28C6", this);} // tgen

static void Test_S28C6()
{
  extern Class_Descriptor cd_S28C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(116,174)];
    init_test(&cd_S28C6, buf);
    S28C6 *dp, &lv = *(dp=new (buf) S28C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(920,692), "sizeof(S28C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C6)");
    check_base_class_offset(lv, (S28C8_nt*)(S28C7_nt*), 0, "S28C6");
    check_base_class_offset(lv, (S28C7_nt*), 0, "S28C6");
    check_field_offset(lv, s28c6f0, ABISELECT(568,436), "S28C6.s28c6f0");
    check_field_offset(lv, s28c6f1, ABISELECT(584,444), "S28C6.s28c6f1");
    check_field_offset(lv, s28c6f2, ABISELECT(592,448), "S28C6.s28c6f2");
    set_bf_and_test(lv, s28c6f3, ABISELECT(600,452), 0, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f4, ABISELECT(600,452), 1, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f5, ABISELECT(600,452), 2, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f6, ABISELECT(600,452), 3, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f7, ABISELECT(600,452), 4, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f8, ABISELECT(600,452), 5, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f9, ABISELECT(600,452), 6, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f10, ABISELECT(600,452), 7, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f11, ABISELECT(601,453), 0, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f12, ABISELECT(601,453), 1, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f13, ABISELECT(601,453), 2, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f14, ABISELECT(601,453), 3, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f15, ABISELECT(601,453), 4, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f16, ABISELECT(601,453), 5, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f17, ABISELECT(601,453), 6, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f18, ABISELECT(601,453), 7, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f19, ABISELECT(602,454), 0, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f20, ABISELECT(602,454), 1, 1, 1, "S28C6");
    set_bf_and_test(lv, s28c6f21, ABISELECT(602,454), 2, 1, 1, "S28C6");
    check_field_offset(lv, s28c6f22, ABISELECT(603,455), "S28C6.s28c6f22");
    check_field_offset(lv, s28c6f23, ABISELECT(604,456), "S28C6.s28c6f23");
    check_field_offset(lv, s28c6f24, ABISELECT(616,464), "S28C6.s28c6f24");
    check_field_offset(lv, s28c6f25, ABISELECT(624,468), "S28C6.s28c6f25");
    check_field_offset(lv, s28c6f26, ABISELECT(636,480), "S28C6.s28c6f26");
    check_field_offset(lv, s28c6f27, ABISELECT(648,492), "S28C6.s28c6f27");
    check_field_offset(lv, s28c6f28, ABISELECT(688,512), "S28C6.s28c6f28");
    check_field_offset(lv, s28c6f29, ABISELECT(704,524), "S28C6.s28c6f29");
    check_field_offset(lv, s28c6f30, ABISELECT(712,528), "S28C6.s28c6f30");
    check_field_offset(lv, s28c6f31, ABISELECT(728,540), "S28C6.s28c6f31");
    check_field_offset(lv, s28c6f32, ABISELECT(744,548), "S28C6.s28c6f32");
    check_field_offset(lv, s28c6f33, ABISELECT(760,560), "S28C6.s28c6f33");
    check_field_offset(lv, s28c6f34, ABISELECT(768,564), "S28C6.s28c6f34");
    check_field_offset(lv, s28c6f35, ABISELECT(776,572), "S28C6.s28c6f35");
    check_field_offset(lv, s28c6f36, ABISELECT(784,576), "S28C6.s28c6f36");
    check_field_offset(lv, s28c6f37, ABISELECT(788,580), "S28C6.s28c6f37");
    check_field_offset(lv, s28c6f38, ABISELECT(800,592), "S28C6.s28c6f38");
    check_field_offset(lv, s28c6f39, ABISELECT(812,604), "S28C6.s28c6f39");
    check_field_offset(lv, s28c6f40, ABISELECT(824,616), "S28C6.s28c6f40");
    check_field_offset(lv, s28c6f41, ABISELECT(840,624), "S28C6.s28c6f41");
    check_field_offset(lv, s28c6f42, ABISELECT(844,628), "S28C6.s28c6f42");
    check_field_offset(lv, s28c6f43, ABISELECT(856,640), "S28C6.s28c6f43");
    check_field_offset(lv, s28c6f44, ABISELECT(872,656), "S28C6.s28c6f44");
    check_field_offset(lv, s28c6f45, ABISELECT(888,664), "S28C6.s28c6f45");
    check_field_offset(lv, s28c6f46, ABISELECT(904,676), "S28C6.s28c6f46");
    check_field_offset(lv, s28c6f47, ABISELECT(908,680), "S28C6.s28c6f47");
    test_class_info(&lv, &cd_S28C6);
    dp->~S28C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C6(Test_S28C6, "S28C6", ABISELECT(920,692));

#else // __cplusplus

extern void _ZN5S28C6C1Ev();
extern void _ZN5S28C6D1Ev();
Name_Map name_map_S28C6[] = {
  NSPAIR(_ZN5S28C6C1Ev),
  NSPAIR(_ZN5S28C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S28C8_nt;
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
extern Class_Descriptor cd_S28C7_nt;
extern VTBL_ENTRY _ZTI8S28C7_nt[];
extern  VTBL_ENTRY _ZTV8S28C7_nt[];
static Base_Class bases_S28C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S28C6[];
extern void _ZN5S28C6D1Ev();
extern void _ZN5S28C6D0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
extern void _ZN8S28C7_nt3v68Ev();
extern void _ZN8S28C7_nt3v69Ev();
extern void _ZN8S28C7_nt3v70Ev();
extern void _ZN8S28C7_nt3v71Ev();
extern void _ZN8S28C7_nt3v72Ev();
extern void _ZN8S28C7_nt3v73Ev();
extern void _ZN8S28C7_nt3v74Ev();
extern void _ZN8S28C7_nt3v75Ev();
extern void _ZN8S28C7_nt3v76Ev();
extern void _ZN8S28C7_nt3v77Ev();
extern void _ZN8S28C7_nt3v78Ev();
extern void _ZN8S28C7_nt3v79Ev();
extern void _ZN8S28C7_nt3v80Ev();
extern void _ZN8S28C7_nt3v81Ev();
extern void _ZN8S28C7_nt3v82Ev();
extern void _ZN8S28C7_nt3v83Ev();
extern void _ZN8S28C7_nt3v84Ev();
extern void _ZN8S28C7_nt3v85Ev();
extern void _ZN8S28C7_nt3v86Ev();
extern void _ZN8S28C7_nt3v87Ev();
extern void _ZN8S28C7_nt3v88Ev();
extern void _ZN8S28C7_nt3v89Ev();
extern void _ZN8S28C7_nt3v90Ev();
extern void _ZN8S28C7_nt3v91Ev();
extern void _ZN8S28C7_nt3v92Ev();
extern void _ZN8S28C7_nt3v93Ev();
extern void _ZN8S28C7_nt3v94Ev();
extern void _ZN8S28C7_nt3v95Ev();
extern void _ZN8S28C7_nt3v96Ev();
extern void _ZN8S28C7_nt3v97Ev();
extern void _ZN8S28C7_nt3v98Ev();
extern void _ZN8S28C7_nt3v99Ev();
extern void _ZN8S28C7_nt4v100Ev();
extern void _ZN8S28C7_nt4v101Ev();
extern void _ZN8S28C7_nt4v102Ev();
extern void _ZN8S28C7_nt4v103Ev();
extern void _ZN8S28C7_nt4v104Ev();
extern void _ZN8S28C7_nt4v105Ev();
extern void _ZN8S28C7_nt4v106Ev();
extern void _ZN8S28C7_nt4v107Ev();
extern void _ZN8S28C7_nt4v108Ev();
extern void _ZN8S28C7_nt4v109Ev();
extern void _ZN8S28C7_nt4v110Ev();
extern void _ZN8S28C7_nt4v111Ev();
extern void _ZN8S28C7_nt4v112Ev();
extern void _ZN8S28C7_nt4v113Ev();
extern void _ZN8S28C7_nt4v114Ev();
extern void _ZN8S28C7_nt4v115Ev();
extern void _ZN8S28C7_nt4v116Ev();
extern void _ZN8S28C7_nt4v117Ev();
extern void _ZN8S28C7_nt4v118Ev();
extern void _ZN8S28C7_nt4v119Ev();
extern void _ZN8S28C7_nt4v120Ev();
extern void _ZN8S28C7_nt4v121Ev();
extern void _ZN8S28C7_nt4v122Ev();
extern void _ZN8S28C7_nt4v123Ev();
extern void _ZN8S28C7_nt4v124Ev();
extern void _ZN8S28C7_nt4v125Ev();
extern void _ZN8S28C7_nt4v126Ev();
extern void _ZN8S28C7_nt4v127Ev();
extern void _ZN8S28C7_nt4v128Ev();
extern void _ZN8S28C7_nt4v129Ev();
extern void _ZN8S28C7_nt4v130Ev();
extern void _ZN8S28C7_nt4v131Ev();
extern void _ZN8S28C7_nt4v132Ev();
extern void _ZN8S28C7_nt4v133Ev();
extern void _ZN8S28C7_nt4v134Ev();
extern void _ZN8S28C7_nt4v135Ev();
extern void _ZN8S28C7_nt4v136Ev();
extern void _ZN8S28C7_nt4v137Ev();
extern void _ZN8S28C7_nt4v138Ev();
extern void _ZN8S28C7_nt4v139Ev();
extern void _ZN8S28C7_nt4v140Ev();
extern void _ZN8S28C7_nt4v141Ev();
extern void _ZN8S28C7_nt4v142Ev();
extern void _ZN8S28C7_nt4v143Ev();
extern void _ZN8S28C7_nt4v144Ev();
extern void _ZN8S28C7_nt4v145Ev();
extern void _ZN8S28C7_nt4v146Ev();
extern void _ZN8S28C7_nt4v147Ev();
extern void _ZN8S28C7_nt4v148Ev();
extern void _ZN8S28C7_nt4v149Ev();
extern void _ZN8S28C7_nt4v150Ev();
extern void _ZN8S28C7_nt4v151Ev();
extern void _ZN8S28C7_nt4v152Ev();
extern void _ZN8S28C7_nt4v153Ev();
extern void _ZN8S28C7_nt4v154Ev();
extern void _ZN8S28C7_nt4v155Ev();
extern void _ZN8S28C7_nt4v156Ev();
extern void _ZN8S28C7_nt4v157Ev();
extern void _ZN8S28C7_nt4v158Ev();
extern void _ZN8S28C7_nt4v159Ev();
extern void _ZN8S28C7_nt4v160Ev();
extern void _ZN8S28C7_nt4v161Ev();
extern void _ZN8S28C7_nt4v162Ev();
extern void _ZN8S28C7_nt4v163Ev();
extern void _ZN8S28C7_nt4v164Ev();
extern void _ZN8S28C7_nt4v165Ev();
extern void _ZN8S28C7_nt4v166Ev();
extern void _ZN8S28C7_nt4v167Ev();
extern void _ZN8S28C7_nt4v168Ev();
extern void _ZN8S28C7_nt4v169Ev();
extern void _ZN8S28C7_nt4v170Ev();
extern void _ZN8S28C7_nt4v171Ev();
extern void _ZN8S28C7_nt4v172Ev();
extern void _ZN8S28C7_nt4v173Ev();
extern void _ZN8S28C7_nt4v174Ev();
extern void _ZN8S28C7_nt4v175Ev();
extern void _ZN8S28C7_nt4v176Ev();
extern void _ZN8S28C7_nt4v177Ev();
extern void _ZN8S28C7_nt4v178Ev();
extern void _ZN8S28C7_nt4v179Ev();
extern void _ZN8S28C7_nt4v180Ev();
extern void _ZN8S28C7_nt4v181Ev();
extern void _ZN8S28C7_nt4v182Ev();
extern void _ZN8S28C7_nt4v183Ev();
extern void _ZN8S28C7_nt4v184Ev();
extern void _ZN8S28C7_nt4v185Ev();
extern void _ZN8S28C7_nt4v186Ev();
extern void _ZN8S28C7_nt4v187Ev();
extern void _ZN8S28C7_nt4v188Ev();
extern void _ZN8S28C7_nt4v189Ev();
extern void _ZN8S28C7_nt4v190Ev();
extern void _ZN8S28C7_nt4v191Ev();
extern void _ZN8S28C7_nt4v192Ev();
extern void _ZN8S28C7_nt4v193Ev();
extern void _ZN8S28C7_nt4v194Ev();
extern void _ZN8S28C7_nt4v195Ev();
extern void _ZN8S28C7_nt4v196Ev();
extern void _ZN8S28C7_nt4v197Ev();
extern void _ZN8S28C7_nt4v198Ev();
extern void _ZN8S28C7_nt4v199Ev();
extern void _ZN8S28C7_nt4v200Ev();
extern void _ZN8S28C7_nt4v201Ev();
extern void _ZN8S28C7_nt4v202Ev();
extern void _ZN8S28C7_nt4v203Ev();
extern void _ZN8S28C7_nt4v204Ev();
extern void _ZN8S28C7_nt4v205Ev();
extern void _ZN8S28C7_nt4v206Ev();
extern void _ZN8S28C7_nt4v207Ev();
extern void _ZN8S28C7_nt4v208Ev();
extern void _ZN8S28C7_nt4v209Ev();
extern void _ZN8S28C7_nt4v210Ev();
extern void _ZN5S28C64v211Ev();
extern void _ZN5S28C64v212Ev();
extern void _ZN5S28C64v213Ev();
extern void _ZN5S28C64v214Ev();
extern void _ZN5S28C64v215Ev();
extern void _ZN5S28C64v216Ev();
extern void _ZN5S28C64v217Ev();
extern void _ZN5S28C64v218Ev();
extern void _ZN5S28C64v219Ev();
extern void _ZN5S28C64v220Ev();
extern void _ZN5S28C64v221Ev();
extern void _ZN5S28C64v222Ev();
extern void _ZN5S28C64v223Ev();
extern void _ZN5S28C64v224Ev();
extern void _ZN5S28C64v225Ev();
extern void _ZN5S28C64v226Ev();
extern void _ZN5S28C64v227Ev();
extern void _ZN5S28C64v228Ev();
extern void _ZN5S28C64v229Ev();
extern void _ZN5S28C64v230Ev();
extern void _ZN5S28C64v231Ev();
extern void _ZN5S28C64v232Ev();
extern void _ZN5S28C64v233Ev();
extern void _ZN5S28C64v234Ev();
extern void _ZN5S28C64v235Ev();
extern void _ZN5S28C64v236Ev();
extern void _ZN5S28C64v237Ev();
extern void _ZN5S28C64v238Ev();
extern void _ZN5S28C64v239Ev();
extern void _ZN5S28C64v240Ev();
extern void _ZN5S28C64v241Ev();
extern void _ZN5S28C64v242Ev();
extern void _ZN5S28C64v243Ev();
extern void _ZN5S28C64v244Ev();
extern void _ZN5S28C64v245Ev();
extern void _ZN5S28C64v246Ev();
extern void _ZN5S28C64v247Ev();
extern void _ZN5S28C64v248Ev();
extern void _ZN5S28C64v249Ev();
extern void _ZN5S28C64v250Ev();
extern void _ZN5S28C64v251Ev();
extern void _ZN5S28C64v252Ev();
extern void _ZN5S28C64v253Ev();
extern void _ZN5S28C64v254Ev();
extern void _ZN5S28C64v255Ev();
extern void _ZN5S28C64v256Ev();
extern void _ZN5S28C64v257Ev();
extern void _ZN5S28C64v258Ev();
extern void _ZN5S28C64v259Ev();
extern void _ZN5S28C64v260Ev();
static  VTBL_ENTRY vtc_S28C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S28C6[0]),
  (VTBL_ENTRY)&_ZN5S28C6D1Ev,
  (VTBL_ENTRY)&_ZN5S28C6D0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN5S28C64v211Ev,
  (VTBL_ENTRY)&_ZN5S28C64v212Ev,
  (VTBL_ENTRY)&_ZN5S28C64v213Ev,
  (VTBL_ENTRY)&_ZN5S28C64v214Ev,
  (VTBL_ENTRY)&_ZN5S28C64v215Ev,
  (VTBL_ENTRY)&_ZN5S28C64v216Ev,
  (VTBL_ENTRY)&_ZN5S28C64v217Ev,
  (VTBL_ENTRY)&_ZN5S28C64v218Ev,
  (VTBL_ENTRY)&_ZN5S28C64v219Ev,
  (VTBL_ENTRY)&_ZN5S28C64v220Ev,
  (VTBL_ENTRY)&_ZN5S28C64v221Ev,
  (VTBL_ENTRY)&_ZN5S28C64v222Ev,
  (VTBL_ENTRY)&_ZN5S28C64v223Ev,
  (VTBL_ENTRY)&_ZN5S28C64v224Ev,
  (VTBL_ENTRY)&_ZN5S28C64v225Ev,
  (VTBL_ENTRY)&_ZN5S28C64v226Ev,
  (VTBL_ENTRY)&_ZN5S28C64v227Ev,
  (VTBL_ENTRY)&_ZN5S28C64v228Ev,
  (VTBL_ENTRY)&_ZN5S28C64v229Ev,
  (VTBL_ENTRY)&_ZN5S28C64v230Ev,
  (VTBL_ENTRY)&_ZN5S28C64v231Ev,
  (VTBL_ENTRY)&_ZN5S28C64v232Ev,
  (VTBL_ENTRY)&_ZN5S28C64v233Ev,
  (VTBL_ENTRY)&_ZN5S28C64v234Ev,
  (VTBL_ENTRY)&_ZN5S28C64v235Ev,
  (VTBL_ENTRY)&_ZN5S28C64v236Ev,
  (VTBL_ENTRY)&_ZN5S28C64v237Ev,
  (VTBL_ENTRY)&_ZN5S28C64v238Ev,
  (VTBL_ENTRY)&_ZN5S28C64v239Ev,
  (VTBL_ENTRY)&_ZN5S28C64v240Ev,
  (VTBL_ENTRY)&_ZN5S28C64v241Ev,
  (VTBL_ENTRY)&_ZN5S28C64v242Ev,
  (VTBL_ENTRY)&_ZN5S28C64v243Ev,
  (VTBL_ENTRY)&_ZN5S28C64v244Ev,
  (VTBL_ENTRY)&_ZN5S28C64v245Ev,
  (VTBL_ENTRY)&_ZN5S28C64v246Ev,
  (VTBL_ENTRY)&_ZN5S28C64v247Ev,
  (VTBL_ENTRY)&_ZN5S28C64v248Ev,
  (VTBL_ENTRY)&_ZN5S28C64v249Ev,
  (VTBL_ENTRY)&_ZN5S28C64v250Ev,
  (VTBL_ENTRY)&_ZN5S28C64v251Ev,
  (VTBL_ENTRY)&_ZN5S28C64v252Ev,
  (VTBL_ENTRY)&_ZN5S28C64v253Ev,
  (VTBL_ENTRY)&_ZN5S28C64v254Ev,
  (VTBL_ENTRY)&_ZN5S28C64v255Ev,
  (VTBL_ENTRY)&_ZN5S28C64v256Ev,
  (VTBL_ENTRY)&_ZN5S28C64v257Ev,
  (VTBL_ENTRY)&_ZN5S28C64v258Ev,
  (VTBL_ENTRY)&_ZN5S28C64v259Ev,
  (VTBL_ENTRY)&_ZN5S28C64v260Ev,
};
extern VTBL_ENTRY _ZTI5S28C6[];
extern  VTBL_ENTRY _ZTV5S28C6[];
Class_Descriptor cd_S28C6 = {  "S28C6", // class name
  bases_S28C6, 2,
  &(vtc_S28C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(920,692), // object size
  NSPAIRA(_ZTI5S28C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S28C6),261, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C30  {
  int s28c30f0;
  char s28c30f1;
  ::S28C18_nt s28c30f2;
  ::S28C18_nt s28c30f3;
  void *s28c30f4;
  ::S28C18_nt s28c30f5;
  char s28c30f6;
};
//SIG(-1 S28C30) C1{ Fi Fc FC2{ m Fi[3]} FC2 Fp FC2 Fc}



static void Test_S28C30()
{
  {
    init_simple_test("S28C30");
    S28C30 lv;
    check2(sizeof(lv), ABISELECT(56,52), "sizeof(S28C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C30)");
    check_field_offset(lv, s28c30f0, 0, "S28C30.s28c30f0");
    check_field_offset(lv, s28c30f1, 4, "S28C30.s28c30f1");
    check_field_offset(lv, s28c30f2, 8, "S28C30.s28c30f2");
    check_field_offset(lv, s28c30f3, 20, "S28C30.s28c30f3");
    check_field_offset(lv, s28c30f4, 32, "S28C30.s28c30f4");
    check_field_offset(lv, s28c30f5, ABISELECT(40,36), "S28C30.s28c30f5");
    check_field_offset(lv, s28c30f6, ABISELECT(52,48), "S28C30.s28c30f6");
  }
}
static Arrange_To_Call_Me vS28C30(Test_S28C30, "S28C30", ABISELECT(56,52));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C33  : S28C12_nt {
};
//SIG(-1 S28C33) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C33()
{
  extern Class_Descriptor cd_S28C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C33, buf);
    S28C33 &lv = *(new (buf) S28C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C33)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C33");
    test_class_info(&lv, &cd_S28C33);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C33(Test_S28C33, "S28C33", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C33 = {  "S28C33", // class name
  bases_S28C33, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C32  : S28C33 {
};
//SIG(-1 S28C32) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C32()
{
  extern Class_Descriptor cd_S28C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C32, buf);
    S28C32 &lv = *(new (buf) S28C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C32)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C33*), 0, "S28C32");
    check_base_class_offset(lv, (S28C33*), 0, "S28C32");
    test_class_info(&lv, &cd_S28C32);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C32(Test_S28C32, "S28C32", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C33;
static Base_Class bases_S28C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C32 = {  "S28C32", // class name
  bases_S28C32, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C31_nt  : S28C32 {
};
//SIG(-1 S28C31_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S28C31_nt

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C33;
extern Class_Descriptor cd_S28C32;
static Base_Class bases_S28C31_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S28C32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C35  : S28C12_nt {
};
//SIG(-1 S28C35) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C35()
{
  extern Class_Descriptor cd_S28C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C35, buf);
    S28C35 &lv = *(new (buf) S28C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C35)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C35");
    test_class_info(&lv, &cd_S28C35);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C35(Test_S28C35, "S28C35", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C35 = {  "S28C35", // class name
  bases_S28C35, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C34  : S28C35 {
};
//SIG(-1 S28C34) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C34()
{
  extern Class_Descriptor cd_S28C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C34, buf);
    S28C34 &lv = *(new (buf) S28C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C34)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C35*), 0, "S28C34");
    check_base_class_offset(lv, (S28C35*), 0, "S28C34");
    test_class_info(&lv, &cd_S28C34);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C34(Test_S28C34, "S28C34", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C35;
static Base_Class bases_S28C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C34 = {  "S28C34", // class name
  bases_S28C34, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C39_nt  {
  void *s28c39f0[2];
  void  mf28c39(); // _ZN9S28C39_nt7mf28c39Ev
};
//SIG(-1 S28C39_nt) C1{ m Fp[2]}


void  S28C39_nt ::mf28c39(){}

//skip512 S28C39_nt

#else // __cplusplus

Class_Descriptor cd_S28C39_nt = {  "S28C39_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C38  : S28C39_nt {
};
//SIG(-1 S28C38) C1{ BC2{ m Fp[2]}}



static void Test_S28C38()
{
  extern Class_Descriptor cd_S28C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S28C38, buf);
    S28C38 &lv = *(new (buf) S28C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S28C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C38)");
    check_base_class_offset(lv, (S28C39_nt*), 0, "S28C38");
    test_class_info(&lv, &cd_S28C38);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C38(Test_S28C38, "S28C38", ABISELECT(16,8));

#else // __cplusplus

extern Class_Descriptor cd_S28C39_nt;
static Base_Class bases_S28C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C39_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C38 = {  "S28C38", // class name
  bases_S28C38, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C41  : S28C12_nt {
};
//SIG(-1 S28C41) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C41()
{
  extern Class_Descriptor cd_S28C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C41, buf);
    S28C41 &lv = *(new (buf) S28C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C41)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C41");
    test_class_info(&lv, &cd_S28C41);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C41(Test_S28C41, "S28C41", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C41 = {  "S28C41", // class name
  bases_S28C41, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C40  : S28C41 {
};
//SIG(-1 S28C40) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C40()
{
  extern Class_Descriptor cd_S28C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C40, buf);
    S28C40 &lv = *(new (buf) S28C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C40)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C41*), 0, "S28C40");
    check_base_class_offset(lv, (S28C41*), 0, "S28C40");
    test_class_info(&lv, &cd_S28C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C40(Test_S28C40, "S28C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C41;
static Base_Class bases_S28C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C40 = {  "S28C40", // class name
  bases_S28C40, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C45  : S28C12_nt {
};
//SIG(-1 S28C45) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C45()
{
  extern Class_Descriptor cd_S28C45;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C45, buf);
    S28C45 &lv = *(new (buf) S28C45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C45)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C45");
    test_class_info(&lv, &cd_S28C45);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C45(Test_S28C45, "S28C45", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C45 = {  "S28C45", // class name
  bases_S28C45, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C44  : S28C45 {
};
//SIG(-1 S28C44) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C44()
{
  extern Class_Descriptor cd_S28C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C44, buf);
    S28C44 &lv = *(new (buf) S28C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C44)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C45*), 0, "S28C44");
    check_base_class_offset(lv, (S28C45*), 0, "S28C44");
    test_class_info(&lv, &cd_S28C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C44(Test_S28C44, "S28C44", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C45;
static Base_Class bases_S28C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C45,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C44 = {  "S28C44", // class name
  bases_S28C44, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C49  : S28C12_nt {
};
//SIG(-1 S28C49) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C49()
{
  extern Class_Descriptor cd_S28C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C49, buf);
    S28C49 &lv = *(new (buf) S28C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C49)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C49");
    test_class_info(&lv, &cd_S28C49);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C49(Test_S28C49, "S28C49", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C49[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C49 = {  "S28C49", // class name
  bases_S28C49, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C48  : S28C49 {
};
//SIG(-1 S28C48) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C48()
{
  extern Class_Descriptor cd_S28C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C48, buf);
    S28C48 &lv = *(new (buf) S28C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C48)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C49*), 0, "S28C48");
    check_base_class_offset(lv, (S28C49*), 0, "S28C48");
    test_class_info(&lv, &cd_S28C48);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C48(Test_S28C48, "S28C48", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C49;
static Base_Class bases_S28C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C49,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C48 = {  "S28C48", // class name
  bases_S28C48, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C50  {
  void *s28c50f0;
  ::S28C9_nt s28c50f1;
  void  mf28c50(); // _ZN6S28C507mf28c50Ev
};
//SIG(-1 S28C50) C1{ m Fp FC2{ m Fi[2]}}


void  S28C50 ::mf28c50(){}

static void Test_S28C50()
{
  {
    init_simple_test("S28C50");
    S28C50 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C50)");
    check_field_offset(lv, s28c50f0, 0, "S28C50.s28c50f0");
    check_field_offset(lv, s28c50f1, ABISELECT(8,4), "S28C50.s28c50f1");
  }
}
static Arrange_To_Call_Me vS28C50(Test_S28C50, "S28C50", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C5  : S28C6 {
  void *s28c5f0[8];
  unsigned int s28c5f1:1;
  unsigned int s28c5f2:1;
  unsigned int s28c5f3:1;
  unsigned int s28c5f4:1;
  unsigned int s28c5f5:1;
  unsigned int s28c5f6:1;
  unsigned int s28c5f7:1;
  unsigned int s28c5f8:1;
  unsigned int s28c5f9:1;
  unsigned int s28c5f10:1;
  unsigned int s28c5f11:1;
  unsigned int s28c5f12:1;
  unsigned int s28c5f13:1;
  unsigned int s28c5f14:1;
  unsigned int s28c5f15:1;
  unsigned int s28c5f16:1;
  unsigned int s28c5f17:1;
  unsigned int s28c5f18:1;
  unsigned int s28c5f19:1;
  unsigned int s28c5f20:1;
  unsigned int s28c5f21:1;
  unsigned int s28c5f22:1;
  unsigned int s28c5f23:1;
  unsigned int s28c5f24:1;
  int s28c5f25[2];
  void *s28c5f26;
  char s28c5f27[6];
  void *s28c5f28[2];
  int s28c5f29[4];
  ::S28C18_nt s28c5f30;
  int s28c5f31;
  ::S28C18_nt s28c5f32;
  void *s28c5f33[5];
  ::S28C18_nt s28c5f34;
  int s28c5f35[12];
  ::S28C30 s28c5f36;
  ::S28C31_nt s28c5f37[2];
  int s28c5f38;
  ::S28C31_nt s28c5f39;
  ::S28C31_nt s28c5f40;
  ::S28C31_nt s28c5f41;
  ::S28C31_nt s28c5f42;
  int s28c5f43;
  ::S28C18_nt s28c5f44;
  void *s28c5f45[4];
  ::S28C18_nt s28c5f46;
  void *s28c5f47;
  ::S28C31_nt s28c5f48;
  void *s28c5f49;
  ::S28C34 s28c5f50;
  ::S28C34 s28c5f51;
  ::S28C34 s28c5f52;
  ::S28C34 s28c5f53;
  void *s28c5f54;
  ::S28C38 s28c5f55;
  void *s28c5f56;
  int s28c5f57;
  ::S28C40 s28c5f58;
  int s28c5f59;
  ::S28C31_nt s28c5f60[4];
  ::S28C40 s28c5f61;
  void *s28c5f62;
  ::S28C44 s28c5f63;
  int s28c5f64[3];
  ::S28C44 s28c5f65;
  ::S28C44 s28c5f66;
  ::S28C16 s28c5f67;
  ::S28C48 s28c5f68;
  int s28c5f69;
  ::S28C50 s28c5f70;
  virtual  ~S28C5(); // _ZN5S28C5D1Ev
  virtual void  v261(); // _ZN5S28C54v261Ev
  virtual void  v262(); // _ZN5S28C54v262Ev
  virtual void  v263(); // _ZN5S28C54v263Ev
  virtual void  v264(); // _ZN5S28C54v264Ev
  virtual void  v265(); // _ZN5S28C54v265Ev
  virtual void  v266(); // _ZN5S28C54v266Ev
  virtual void  v267(); // _ZN5S28C54v267Ev
  virtual void  v268(); // _ZN5S28C54v268Ev
  virtual void  v269(); // _ZN5S28C54v269Ev
  virtual void  v270(); // _ZN5S28C54v270Ev
  virtual void  v271(); // _ZN5S28C54v271Ev
  virtual void  v272(); // _ZN5S28C54v272Ev
  virtual void  v273(); // _ZN5S28C54v273Ev
  virtual void  v274(); // _ZN5S28C54v274Ev
  virtual void  v275(); // _ZN5S28C54v275Ev
  virtual void  v276(); // _ZN5S28C54v276Ev
  virtual void  v277(); // _ZN5S28C54v277Ev
  virtual void  v278(); // _ZN5S28C54v278Ev
  virtual void  v279(); // _ZN5S28C54v279Ev
  virtual void  v280(); // _ZN5S28C54v280Ev
  virtual void  v281(); // _ZN5S28C54v281Ev
  virtual void  v282(); // _ZN5S28C54v282Ev
  virtual void  v283(); // _ZN5S28C54v283Ev
  virtual void  v284(); // _ZN5S28C54v284Ev
  virtual void  v285(); // _ZN5S28C54v285Ev
  virtual void  v286(); // _ZN5S28C54v286Ev
  virtual void  v287(); // _ZN5S28C54v287Ev
  virtual void  v288(); // _ZN5S28C54v288Ev
  virtual void  v289(); // _ZN5S28C54v289Ev
  virtual void  v290(); // _ZN5S28C54v290Ev
  virtual void  v291(); // _ZN5S28C54v291Ev
  virtual void  v292(); // _ZN5S28C54v292Ev
  virtual void  v293(); // _ZN5S28C54v293Ev
  virtual void  v294(); // _ZN5S28C54v294Ev
  virtual void  v295(); // _ZN5S28C54v295Ev
  virtual void  v296(); // _ZN5S28C54v296Ev
  virtual void  v297(); // _ZN5S28C54v297Ev
  virtual void  v298(); // _ZN5S28C54v298Ev
  S28C5(); // tgen
};
//SIG(-1 S28C5) C1{ BC2{ BC3{ BC4{ vd v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC12 FC12 Fp[5] FC12 Fp FC15{ BC16{ BC8}} Fp[2] FC12 Fp Fi[2] Fp Fi FC12 FC12 FC12 Fp[2] Fi FC12 Fi[4] Fp[2] FC15 Fi FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC12 Fi FC12 Fp[5] FC12 Fi[12] FC17{ Fi Fc FC12 FC12 Fp FC12 Fc} FC18{ BC19{ BC20{ BC8}}}[2] Fi FC18 FC18 FC18 FC18 Fi FC12 Fp[4] FC12 Fp FC18 Fp FC21{ BC22{ BC8}} FC21 FC21 FC21 Fp FC23{ BC24{ m Fp[2]}} Fp Fi FC25{ BC26{ BC8}} Fi FC18[4] FC25 Fp FC27{ BC28{ BC8}} Fi[3] FC27 FC27 FC10 FC29{ BC30{ BC8}} Fi FC31{ m Fp FC5}}


 S28C5 ::~S28C5(){ note_dtor("S28C5", this);}
void  S28C5 ::v261(){vfunc_called(this, "_ZN5S28C54v261Ev");}
void  S28C5 ::v262(){vfunc_called(this, "_ZN5S28C54v262Ev");}
void  S28C5 ::v263(){vfunc_called(this, "_ZN5S28C54v263Ev");}
void  S28C5 ::v264(){vfunc_called(this, "_ZN5S28C54v264Ev");}
void  S28C5 ::v265(){vfunc_called(this, "_ZN5S28C54v265Ev");}
void  S28C5 ::v266(){vfunc_called(this, "_ZN5S28C54v266Ev");}
void  S28C5 ::v267(){vfunc_called(this, "_ZN5S28C54v267Ev");}
void  S28C5 ::v268(){vfunc_called(this, "_ZN5S28C54v268Ev");}
void  S28C5 ::v269(){vfunc_called(this, "_ZN5S28C54v269Ev");}
void  S28C5 ::v270(){vfunc_called(this, "_ZN5S28C54v270Ev");}
void  S28C5 ::v271(){vfunc_called(this, "_ZN5S28C54v271Ev");}
void  S28C5 ::v272(){vfunc_called(this, "_ZN5S28C54v272Ev");}
void  S28C5 ::v273(){vfunc_called(this, "_ZN5S28C54v273Ev");}
void  S28C5 ::v274(){vfunc_called(this, "_ZN5S28C54v274Ev");}
void  S28C5 ::v275(){vfunc_called(this, "_ZN5S28C54v275Ev");}
void  S28C5 ::v276(){vfunc_called(this, "_ZN5S28C54v276Ev");}
void  S28C5 ::v277(){vfunc_called(this, "_ZN5S28C54v277Ev");}
void  S28C5 ::v278(){vfunc_called(this, "_ZN5S28C54v278Ev");}
void  S28C5 ::v279(){vfunc_called(this, "_ZN5S28C54v279Ev");}
void  S28C5 ::v280(){vfunc_called(this, "_ZN5S28C54v280Ev");}
void  S28C5 ::v281(){vfunc_called(this, "_ZN5S28C54v281Ev");}
void  S28C5 ::v282(){vfunc_called(this, "_ZN5S28C54v282Ev");}
void  S28C5 ::v283(){vfunc_called(this, "_ZN5S28C54v283Ev");}
void  S28C5 ::v284(){vfunc_called(this, "_ZN5S28C54v284Ev");}
void  S28C5 ::v285(){vfunc_called(this, "_ZN5S28C54v285Ev");}
void  S28C5 ::v286(){vfunc_called(this, "_ZN5S28C54v286Ev");}
void  S28C5 ::v287(){vfunc_called(this, "_ZN5S28C54v287Ev");}
void  S28C5 ::v288(){vfunc_called(this, "_ZN5S28C54v288Ev");}
void  S28C5 ::v289(){vfunc_called(this, "_ZN5S28C54v289Ev");}
void  S28C5 ::v290(){vfunc_called(this, "_ZN5S28C54v290Ev");}
void  S28C5 ::v291(){vfunc_called(this, "_ZN5S28C54v291Ev");}
void  S28C5 ::v292(){vfunc_called(this, "_ZN5S28C54v292Ev");}
void  S28C5 ::v293(){vfunc_called(this, "_ZN5S28C54v293Ev");}
void  S28C5 ::v294(){vfunc_called(this, "_ZN5S28C54v294Ev");}
void  S28C5 ::v295(){vfunc_called(this, "_ZN5S28C54v295Ev");}
void  S28C5 ::v296(){vfunc_called(this, "_ZN5S28C54v296Ev");}
void  S28C5 ::v297(){vfunc_called(this, "_ZN5S28C54v297Ev");}
void  S28C5 ::v298(){vfunc_called(this, "_ZN5S28C54v298Ev");}
S28C5 ::S28C5(){ note_ctor("S28C5", this);} // tgen

static void Test_S28C5()
{
  extern Class_Descriptor cd_S28C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(223,328)];
    init_test(&cd_S28C5, buf);
    S28C5 *dp, &lv = *(dp=new (buf) S28C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1776,1308), "sizeof(S28C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C5)");
    check_base_class_offset(lv, (S28C8_nt*)(S28C7_nt*)(S28C6*), 0, "S28C5");
    check_base_class_offset(lv, (S28C7_nt*)(S28C6*), 0, "S28C5");
    check_base_class_offset(lv, (S28C6*), 0, "S28C5");
    check_field_offset(lv, s28c5f0, ABISELECT(920,692), "S28C5.s28c5f0");
    set_bf_and_test(lv, s28c5f1, ABISELECT(984,724), 0, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f2, ABISELECT(984,724), 1, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f3, ABISELECT(984,724), 2, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f4, ABISELECT(984,724), 3, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f5, ABISELECT(984,724), 4, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f6, ABISELECT(984,724), 5, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f7, ABISELECT(984,724), 6, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f8, ABISELECT(984,724), 7, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f9, ABISELECT(985,725), 0, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f10, ABISELECT(985,725), 1, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f11, ABISELECT(985,725), 2, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f12, ABISELECT(985,725), 3, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f13, ABISELECT(985,725), 4, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f14, ABISELECT(985,725), 5, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f15, ABISELECT(985,725), 6, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f16, ABISELECT(985,725), 7, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f17, ABISELECT(986,726), 0, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f18, ABISELECT(986,726), 1, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f19, ABISELECT(986,726), 2, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f20, ABISELECT(986,726), 3, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f21, ABISELECT(986,726), 4, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f22, ABISELECT(986,726), 5, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f23, ABISELECT(986,726), 6, 1, 1, "S28C5");
    set_bf_and_test(lv, s28c5f24, ABISELECT(986,726), 7, 1, 1, "S28C5");
    check_field_offset(lv, s28c5f25, ABISELECT(988,728), "S28C5.s28c5f25");
    check_field_offset(lv, s28c5f26, ABISELECT(1000,736), "S28C5.s28c5f26");
    check_field_offset(lv, s28c5f27, ABISELECT(1008,740), "S28C5.s28c5f27");
    check_field_offset(lv, s28c5f28, ABISELECT(1016,748), "S28C5.s28c5f28");
    check_field_offset(lv, s28c5f29, ABISELECT(1032,756), "S28C5.s28c5f29");
    check_field_offset(lv, s28c5f30, ABISELECT(1048,772), "S28C5.s28c5f30");
    check_field_offset(lv, s28c5f31, ABISELECT(1060,784), "S28C5.s28c5f31");
    check_field_offset(lv, s28c5f32, ABISELECT(1064,788), "S28C5.s28c5f32");
    check_field_offset(lv, s28c5f33, ABISELECT(1080,800), "S28C5.s28c5f33");
    check_field_offset(lv, s28c5f34, ABISELECT(1120,820), "S28C5.s28c5f34");
    check_field_offset(lv, s28c5f35, ABISELECT(1132,832), "S28C5.s28c5f35");
    check_field_offset(lv, s28c5f36, ABISELECT(1184,880), "S28C5.s28c5f36");
    check_field_offset(lv, s28c5f37, ABISELECT(1240,932), "S28C5.s28c5f37");
    check_field_offset(lv, s28c5f38, ABISELECT(1272,956), "S28C5.s28c5f38");
    check_field_offset(lv, s28c5f39, ABISELECT(1280,960), "S28C5.s28c5f39");
    check_field_offset(lv, s28c5f40, ABISELECT(1296,972), "S28C5.s28c5f40");
    check_field_offset(lv, s28c5f41, ABISELECT(1312,984), "S28C5.s28c5f41");
    check_field_offset(lv, s28c5f42, ABISELECT(1328,996), "S28C5.s28c5f42");
    check_field_offset(lv, s28c5f43, ABISELECT(1344,1008), "S28C5.s28c5f43");
    check_field_offset(lv, s28c5f44, ABISELECT(1348,1012), "S28C5.s28c5f44");
    check_field_offset(lv, s28c5f45, ABISELECT(1360,1024), "S28C5.s28c5f45");
    check_field_offset(lv, s28c5f46, ABISELECT(1392,1040), "S28C5.s28c5f46");
    check_field_offset(lv, s28c5f47, ABISELECT(1408,1052), "S28C5.s28c5f47");
    check_field_offset(lv, s28c5f48, ABISELECT(1416,1056), "S28C5.s28c5f48");
    check_field_offset(lv, s28c5f49, ABISELECT(1432,1068), "S28C5.s28c5f49");
    check_field_offset(lv, s28c5f50, ABISELECT(1440,1072), "S28C5.s28c5f50");
    check_field_offset(lv, s28c5f51, ABISELECT(1456,1084), "S28C5.s28c5f51");
    check_field_offset(lv, s28c5f52, ABISELECT(1472,1096), "S28C5.s28c5f52");
    check_field_offset(lv, s28c5f53, ABISELECT(1488,1108), "S28C5.s28c5f53");
    check_field_offset(lv, s28c5f54, ABISELECT(1504,1120), "S28C5.s28c5f54");
    check_field_offset(lv, s28c5f55, ABISELECT(1512,1124), "S28C5.s28c5f55");
    check_field_offset(lv, s28c5f56, ABISELECT(1528,1132), "S28C5.s28c5f56");
    check_field_offset(lv, s28c5f57, ABISELECT(1536,1136), "S28C5.s28c5f57");
    check_field_offset(lv, s28c5f58, ABISELECT(1544,1140), "S28C5.s28c5f58");
    check_field_offset(lv, s28c5f59, ABISELECT(1560,1152), "S28C5.s28c5f59");
    check_field_offset(lv, s28c5f60, ABISELECT(1568,1156), "S28C5.s28c5f60");
    check_field_offset(lv, s28c5f61, ABISELECT(1632,1204), "S28C5.s28c5f61");
    check_field_offset(lv, s28c5f62, ABISELECT(1648,1216), "S28C5.s28c5f62");
    check_field_offset(lv, s28c5f63, ABISELECT(1656,1220), "S28C5.s28c5f63");
    check_field_offset(lv, s28c5f64, ABISELECT(1672,1232), "S28C5.s28c5f64");
    check_field_offset(lv, s28c5f65, ABISELECT(1688,1244), "S28C5.s28c5f65");
    check_field_offset(lv, s28c5f66, ABISELECT(1704,1256), "S28C5.s28c5f66");
    check_field_offset(lv, s28c5f67, ABISELECT(1720,1268), "S28C5.s28c5f67");
    check_field_offset(lv, s28c5f68, ABISELECT(1736,1280), "S28C5.s28c5f68");
    check_field_offset(lv, s28c5f69, ABISELECT(1752,1292), "S28C5.s28c5f69");
    check_field_offset(lv, s28c5f70, ABISELECT(1760,1296), "S28C5.s28c5f70");
    test_class_info(&lv, &cd_S28C5);
    dp->~S28C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C5(Test_S28C5, "S28C5", ABISELECT(1776,1308));

#else // __cplusplus

extern void _ZN5S28C5C1Ev();
extern void _ZN5S28C5D1Ev();
Name_Map name_map_S28C5[] = {
  NSPAIR(_ZN5S28C5C1Ev),
  NSPAIR(_ZN5S28C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S28C8_nt;
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
extern Class_Descriptor cd_S28C7_nt;
extern VTBL_ENTRY _ZTI8S28C7_nt[];
extern  VTBL_ENTRY _ZTV8S28C7_nt[];
extern Class_Descriptor cd_S28C6;
extern VTBL_ENTRY _ZTI5S28C6[];
extern  VTBL_ENTRY _ZTV5S28C6[];
static Base_Class bases_S28C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S28C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S28C5[];
extern void _ZN5S28C5D1Ev();
extern void _ZN5S28C5D0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
extern void _ZN8S28C7_nt3v68Ev();
extern void _ZN8S28C7_nt3v69Ev();
extern void _ZN8S28C7_nt3v70Ev();
extern void _ZN8S28C7_nt3v71Ev();
extern void _ZN8S28C7_nt3v72Ev();
extern void _ZN8S28C7_nt3v73Ev();
extern void _ZN8S28C7_nt3v74Ev();
extern void _ZN8S28C7_nt3v75Ev();
extern void _ZN8S28C7_nt3v76Ev();
extern void _ZN8S28C7_nt3v77Ev();
extern void _ZN8S28C7_nt3v78Ev();
extern void _ZN8S28C7_nt3v79Ev();
extern void _ZN8S28C7_nt3v80Ev();
extern void _ZN8S28C7_nt3v81Ev();
extern void _ZN8S28C7_nt3v82Ev();
extern void _ZN8S28C7_nt3v83Ev();
extern void _ZN8S28C7_nt3v84Ev();
extern void _ZN8S28C7_nt3v85Ev();
extern void _ZN8S28C7_nt3v86Ev();
extern void _ZN8S28C7_nt3v87Ev();
extern void _ZN8S28C7_nt3v88Ev();
extern void _ZN8S28C7_nt3v89Ev();
extern void _ZN8S28C7_nt3v90Ev();
extern void _ZN8S28C7_nt3v91Ev();
extern void _ZN8S28C7_nt3v92Ev();
extern void _ZN8S28C7_nt3v93Ev();
extern void _ZN8S28C7_nt3v94Ev();
extern void _ZN8S28C7_nt3v95Ev();
extern void _ZN8S28C7_nt3v96Ev();
extern void _ZN8S28C7_nt3v97Ev();
extern void _ZN8S28C7_nt3v98Ev();
extern void _ZN8S28C7_nt3v99Ev();
extern void _ZN8S28C7_nt4v100Ev();
extern void _ZN8S28C7_nt4v101Ev();
extern void _ZN8S28C7_nt4v102Ev();
extern void _ZN8S28C7_nt4v103Ev();
extern void _ZN8S28C7_nt4v104Ev();
extern void _ZN8S28C7_nt4v105Ev();
extern void _ZN8S28C7_nt4v106Ev();
extern void _ZN8S28C7_nt4v107Ev();
extern void _ZN8S28C7_nt4v108Ev();
extern void _ZN8S28C7_nt4v109Ev();
extern void _ZN8S28C7_nt4v110Ev();
extern void _ZN8S28C7_nt4v111Ev();
extern void _ZN8S28C7_nt4v112Ev();
extern void _ZN8S28C7_nt4v113Ev();
extern void _ZN8S28C7_nt4v114Ev();
extern void _ZN8S28C7_nt4v115Ev();
extern void _ZN8S28C7_nt4v116Ev();
extern void _ZN8S28C7_nt4v117Ev();
extern void _ZN8S28C7_nt4v118Ev();
extern void _ZN8S28C7_nt4v119Ev();
extern void _ZN8S28C7_nt4v120Ev();
extern void _ZN8S28C7_nt4v121Ev();
extern void _ZN8S28C7_nt4v122Ev();
extern void _ZN8S28C7_nt4v123Ev();
extern void _ZN8S28C7_nt4v124Ev();
extern void _ZN8S28C7_nt4v125Ev();
extern void _ZN8S28C7_nt4v126Ev();
extern void _ZN8S28C7_nt4v127Ev();
extern void _ZN8S28C7_nt4v128Ev();
extern void _ZN8S28C7_nt4v129Ev();
extern void _ZN8S28C7_nt4v130Ev();
extern void _ZN8S28C7_nt4v131Ev();
extern void _ZN8S28C7_nt4v132Ev();
extern void _ZN8S28C7_nt4v133Ev();
extern void _ZN8S28C7_nt4v134Ev();
extern void _ZN8S28C7_nt4v135Ev();
extern void _ZN8S28C7_nt4v136Ev();
extern void _ZN8S28C7_nt4v137Ev();
extern void _ZN8S28C7_nt4v138Ev();
extern void _ZN8S28C7_nt4v139Ev();
extern void _ZN8S28C7_nt4v140Ev();
extern void _ZN8S28C7_nt4v141Ev();
extern void _ZN8S28C7_nt4v142Ev();
extern void _ZN8S28C7_nt4v143Ev();
extern void _ZN8S28C7_nt4v144Ev();
extern void _ZN8S28C7_nt4v145Ev();
extern void _ZN8S28C7_nt4v146Ev();
extern void _ZN8S28C7_nt4v147Ev();
extern void _ZN8S28C7_nt4v148Ev();
extern void _ZN8S28C7_nt4v149Ev();
extern void _ZN8S28C7_nt4v150Ev();
extern void _ZN8S28C7_nt4v151Ev();
extern void _ZN8S28C7_nt4v152Ev();
extern void _ZN8S28C7_nt4v153Ev();
extern void _ZN8S28C7_nt4v154Ev();
extern void _ZN8S28C7_nt4v155Ev();
extern void _ZN8S28C7_nt4v156Ev();
extern void _ZN8S28C7_nt4v157Ev();
extern void _ZN8S28C7_nt4v158Ev();
extern void _ZN8S28C7_nt4v159Ev();
extern void _ZN8S28C7_nt4v160Ev();
extern void _ZN8S28C7_nt4v161Ev();
extern void _ZN8S28C7_nt4v162Ev();
extern void _ZN8S28C7_nt4v163Ev();
extern void _ZN8S28C7_nt4v164Ev();
extern void _ZN8S28C7_nt4v165Ev();
extern void _ZN8S28C7_nt4v166Ev();
extern void _ZN8S28C7_nt4v167Ev();
extern void _ZN8S28C7_nt4v168Ev();
extern void _ZN8S28C7_nt4v169Ev();
extern void _ZN8S28C7_nt4v170Ev();
extern void _ZN8S28C7_nt4v171Ev();
extern void _ZN8S28C7_nt4v172Ev();
extern void _ZN8S28C7_nt4v173Ev();
extern void _ZN8S28C7_nt4v174Ev();
extern void _ZN8S28C7_nt4v175Ev();
extern void _ZN8S28C7_nt4v176Ev();
extern void _ZN8S28C7_nt4v177Ev();
extern void _ZN8S28C7_nt4v178Ev();
extern void _ZN8S28C7_nt4v179Ev();
extern void _ZN8S28C7_nt4v180Ev();
extern void _ZN8S28C7_nt4v181Ev();
extern void _ZN8S28C7_nt4v182Ev();
extern void _ZN8S28C7_nt4v183Ev();
extern void _ZN8S28C7_nt4v184Ev();
extern void _ZN8S28C7_nt4v185Ev();
extern void _ZN8S28C7_nt4v186Ev();
extern void _ZN8S28C7_nt4v187Ev();
extern void _ZN8S28C7_nt4v188Ev();
extern void _ZN8S28C7_nt4v189Ev();
extern void _ZN8S28C7_nt4v190Ev();
extern void _ZN8S28C7_nt4v191Ev();
extern void _ZN8S28C7_nt4v192Ev();
extern void _ZN8S28C7_nt4v193Ev();
extern void _ZN8S28C7_nt4v194Ev();
extern void _ZN8S28C7_nt4v195Ev();
extern void _ZN8S28C7_nt4v196Ev();
extern void _ZN8S28C7_nt4v197Ev();
extern void _ZN8S28C7_nt4v198Ev();
extern void _ZN8S28C7_nt4v199Ev();
extern void _ZN8S28C7_nt4v200Ev();
extern void _ZN8S28C7_nt4v201Ev();
extern void _ZN8S28C7_nt4v202Ev();
extern void _ZN8S28C7_nt4v203Ev();
extern void _ZN8S28C7_nt4v204Ev();
extern void _ZN8S28C7_nt4v205Ev();
extern void _ZN8S28C7_nt4v206Ev();
extern void _ZN8S28C7_nt4v207Ev();
extern void _ZN8S28C7_nt4v208Ev();
extern void _ZN8S28C7_nt4v209Ev();
extern void _ZN8S28C7_nt4v210Ev();
extern void _ZN5S28C64v211Ev();
extern void _ZN5S28C64v212Ev();
extern void _ZN5S28C64v213Ev();
extern void _ZN5S28C64v214Ev();
extern void _ZN5S28C64v215Ev();
extern void _ZN5S28C64v216Ev();
extern void _ZN5S28C64v217Ev();
extern void _ZN5S28C64v218Ev();
extern void _ZN5S28C64v219Ev();
extern void _ZN5S28C64v220Ev();
extern void _ZN5S28C64v221Ev();
extern void _ZN5S28C64v222Ev();
extern void _ZN5S28C64v223Ev();
extern void _ZN5S28C64v224Ev();
extern void _ZN5S28C64v225Ev();
extern void _ZN5S28C64v226Ev();
extern void _ZN5S28C64v227Ev();
extern void _ZN5S28C64v228Ev();
extern void _ZN5S28C64v229Ev();
extern void _ZN5S28C64v230Ev();
extern void _ZN5S28C64v231Ev();
extern void _ZN5S28C64v232Ev();
extern void _ZN5S28C64v233Ev();
extern void _ZN5S28C64v234Ev();
extern void _ZN5S28C64v235Ev();
extern void _ZN5S28C64v236Ev();
extern void _ZN5S28C64v237Ev();
extern void _ZN5S28C64v238Ev();
extern void _ZN5S28C64v239Ev();
extern void _ZN5S28C64v240Ev();
extern void _ZN5S28C64v241Ev();
extern void _ZN5S28C64v242Ev();
extern void _ZN5S28C64v243Ev();
extern void _ZN5S28C64v244Ev();
extern void _ZN5S28C64v245Ev();
extern void _ZN5S28C64v246Ev();
extern void _ZN5S28C64v247Ev();
extern void _ZN5S28C64v248Ev();
extern void _ZN5S28C64v249Ev();
extern void _ZN5S28C64v250Ev();
extern void _ZN5S28C64v251Ev();
extern void _ZN5S28C64v252Ev();
extern void _ZN5S28C64v253Ev();
extern void _ZN5S28C64v254Ev();
extern void _ZN5S28C64v255Ev();
extern void _ZN5S28C64v256Ev();
extern void _ZN5S28C64v257Ev();
extern void _ZN5S28C64v258Ev();
extern void _ZN5S28C64v259Ev();
extern void _ZN5S28C64v260Ev();
extern void _ZN5S28C54v261Ev();
extern void _ZN5S28C54v262Ev();
extern void _ZN5S28C54v263Ev();
extern void _ZN5S28C54v264Ev();
extern void _ZN5S28C54v265Ev();
extern void _ZN5S28C54v266Ev();
extern void _ZN5S28C54v267Ev();
extern void _ZN5S28C54v268Ev();
extern void _ZN5S28C54v269Ev();
extern void _ZN5S28C54v270Ev();
extern void _ZN5S28C54v271Ev();
extern void _ZN5S28C54v272Ev();
extern void _ZN5S28C54v273Ev();
extern void _ZN5S28C54v274Ev();
extern void _ZN5S28C54v275Ev();
extern void _ZN5S28C54v276Ev();
extern void _ZN5S28C54v277Ev();
extern void _ZN5S28C54v278Ev();
extern void _ZN5S28C54v279Ev();
extern void _ZN5S28C54v280Ev();
extern void _ZN5S28C54v281Ev();
extern void _ZN5S28C54v282Ev();
extern void _ZN5S28C54v283Ev();
extern void _ZN5S28C54v284Ev();
extern void _ZN5S28C54v285Ev();
extern void _ZN5S28C54v286Ev();
extern void _ZN5S28C54v287Ev();
extern void _ZN5S28C54v288Ev();
extern void _ZN5S28C54v289Ev();
extern void _ZN5S28C54v290Ev();
extern void _ZN5S28C54v291Ev();
extern void _ZN5S28C54v292Ev();
extern void _ZN5S28C54v293Ev();
extern void _ZN5S28C54v294Ev();
extern void _ZN5S28C54v295Ev();
extern void _ZN5S28C54v296Ev();
extern void _ZN5S28C54v297Ev();
extern void _ZN5S28C54v298Ev();
static  VTBL_ENTRY vtc_S28C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S28C5[0]),
  (VTBL_ENTRY)&_ZN5S28C5D1Ev,
  (VTBL_ENTRY)&_ZN5S28C5D0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN5S28C64v211Ev,
  (VTBL_ENTRY)&_ZN5S28C64v212Ev,
  (VTBL_ENTRY)&_ZN5S28C64v213Ev,
  (VTBL_ENTRY)&_ZN5S28C64v214Ev,
  (VTBL_ENTRY)&_ZN5S28C64v215Ev,
  (VTBL_ENTRY)&_ZN5S28C64v216Ev,
  (VTBL_ENTRY)&_ZN5S28C64v217Ev,
  (VTBL_ENTRY)&_ZN5S28C64v218Ev,
  (VTBL_ENTRY)&_ZN5S28C64v219Ev,
  (VTBL_ENTRY)&_ZN5S28C64v220Ev,
  (VTBL_ENTRY)&_ZN5S28C64v221Ev,
  (VTBL_ENTRY)&_ZN5S28C64v222Ev,
  (VTBL_ENTRY)&_ZN5S28C64v223Ev,
  (VTBL_ENTRY)&_ZN5S28C64v224Ev,
  (VTBL_ENTRY)&_ZN5S28C64v225Ev,
  (VTBL_ENTRY)&_ZN5S28C64v226Ev,
  (VTBL_ENTRY)&_ZN5S28C64v227Ev,
  (VTBL_ENTRY)&_ZN5S28C64v228Ev,
  (VTBL_ENTRY)&_ZN5S28C64v229Ev,
  (VTBL_ENTRY)&_ZN5S28C64v230Ev,
  (VTBL_ENTRY)&_ZN5S28C64v231Ev,
  (VTBL_ENTRY)&_ZN5S28C64v232Ev,
  (VTBL_ENTRY)&_ZN5S28C64v233Ev,
  (VTBL_ENTRY)&_ZN5S28C64v234Ev,
  (VTBL_ENTRY)&_ZN5S28C64v235Ev,
  (VTBL_ENTRY)&_ZN5S28C64v236Ev,
  (VTBL_ENTRY)&_ZN5S28C64v237Ev,
  (VTBL_ENTRY)&_ZN5S28C64v238Ev,
  (VTBL_ENTRY)&_ZN5S28C64v239Ev,
  (VTBL_ENTRY)&_ZN5S28C64v240Ev,
  (VTBL_ENTRY)&_ZN5S28C64v241Ev,
  (VTBL_ENTRY)&_ZN5S28C64v242Ev,
  (VTBL_ENTRY)&_ZN5S28C64v243Ev,
  (VTBL_ENTRY)&_ZN5S28C64v244Ev,
  (VTBL_ENTRY)&_ZN5S28C64v245Ev,
  (VTBL_ENTRY)&_ZN5S28C64v246Ev,
  (VTBL_ENTRY)&_ZN5S28C64v247Ev,
  (VTBL_ENTRY)&_ZN5S28C64v248Ev,
  (VTBL_ENTRY)&_ZN5S28C64v249Ev,
  (VTBL_ENTRY)&_ZN5S28C64v250Ev,
  (VTBL_ENTRY)&_ZN5S28C64v251Ev,
  (VTBL_ENTRY)&_ZN5S28C64v252Ev,
  (VTBL_ENTRY)&_ZN5S28C64v253Ev,
  (VTBL_ENTRY)&_ZN5S28C64v254Ev,
  (VTBL_ENTRY)&_ZN5S28C64v255Ev,
  (VTBL_ENTRY)&_ZN5S28C64v256Ev,
  (VTBL_ENTRY)&_ZN5S28C64v257Ev,
  (VTBL_ENTRY)&_ZN5S28C64v258Ev,
  (VTBL_ENTRY)&_ZN5S28C64v259Ev,
  (VTBL_ENTRY)&_ZN5S28C64v260Ev,
  (VTBL_ENTRY)&_ZN5S28C54v261Ev,
  (VTBL_ENTRY)&_ZN5S28C54v262Ev,
  (VTBL_ENTRY)&_ZN5S28C54v263Ev,
  (VTBL_ENTRY)&_ZN5S28C54v264Ev,
  (VTBL_ENTRY)&_ZN5S28C54v265Ev,
  (VTBL_ENTRY)&_ZN5S28C54v266Ev,
  (VTBL_ENTRY)&_ZN5S28C54v267Ev,
  (VTBL_ENTRY)&_ZN5S28C54v268Ev,
  (VTBL_ENTRY)&_ZN5S28C54v269Ev,
  (VTBL_ENTRY)&_ZN5S28C54v270Ev,
  (VTBL_ENTRY)&_ZN5S28C54v271Ev,
  (VTBL_ENTRY)&_ZN5S28C54v272Ev,
  (VTBL_ENTRY)&_ZN5S28C54v273Ev,
  (VTBL_ENTRY)&_ZN5S28C54v274Ev,
  (VTBL_ENTRY)&_ZN5S28C54v275Ev,
  (VTBL_ENTRY)&_ZN5S28C54v276Ev,
  (VTBL_ENTRY)&_ZN5S28C54v277Ev,
  (VTBL_ENTRY)&_ZN5S28C54v278Ev,
  (VTBL_ENTRY)&_ZN5S28C54v279Ev,
  (VTBL_ENTRY)&_ZN5S28C54v280Ev,
  (VTBL_ENTRY)&_ZN5S28C54v281Ev,
  (VTBL_ENTRY)&_ZN5S28C54v282Ev,
  (VTBL_ENTRY)&_ZN5S28C54v283Ev,
  (VTBL_ENTRY)&_ZN5S28C54v284Ev,
  (VTBL_ENTRY)&_ZN5S28C54v285Ev,
  (VTBL_ENTRY)&_ZN5S28C54v286Ev,
  (VTBL_ENTRY)&_ZN5S28C54v287Ev,
  (VTBL_ENTRY)&_ZN5S28C54v288Ev,
  (VTBL_ENTRY)&_ZN5S28C54v289Ev,
  (VTBL_ENTRY)&_ZN5S28C54v290Ev,
  (VTBL_ENTRY)&_ZN5S28C54v291Ev,
  (VTBL_ENTRY)&_ZN5S28C54v292Ev,
  (VTBL_ENTRY)&_ZN5S28C54v293Ev,
  (VTBL_ENTRY)&_ZN5S28C54v294Ev,
  (VTBL_ENTRY)&_ZN5S28C54v295Ev,
  (VTBL_ENTRY)&_ZN5S28C54v296Ev,
  (VTBL_ENTRY)&_ZN5S28C54v297Ev,
  (VTBL_ENTRY)&_ZN5S28C54v298Ev,
};
extern VTBL_ENTRY _ZTI5S28C5[];
extern  VTBL_ENTRY _ZTV5S28C5[];
Class_Descriptor cd_S28C5 = {  "S28C5", // class name
  bases_S28C5, 3,
  &(vtc_S28C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1776,1308), // object size
  NSPAIRA(_ZTI5S28C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S28C5),299, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C4  : S28C5 {
  virtual  ~S28C4(); // _ZN5S28C4D1Ev
  virtual void  v299(); // _ZN5S28C44v299Ev
  virtual void  v300(); // _ZN5S28C44v300Ev
  virtual void  v301(); // _ZN5S28C44v301Ev
  S28C4(); // tgen
};
//SIG(-1 S28C4) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 FC10{ m Fi} Fi Fc[4] Fp[2] FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC6 FC6 FC6 FC11{ BC12{ BC9}} FC11 Fi Fp[2] FC13{ m Fi[3]} FC13 FC13 FC13 Fp FC6 FC11 FC13 FC13 Fi FC13 FC13 Fp Fi Fc FC13 FC13 Fp Fi Fp FC11 FC14{ BC15{ BC9}} FC14} vd v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC13 FC13 Fp[5] FC13 Fp FC16{ BC17{ BC9}} Fp[2] FC13 Fp Fi[2] Fp Fi FC13 FC13 FC13 Fp[2] Fi FC13 Fi[4] Fp[2] FC16 Fi FC13} vd v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC13 Fi FC13 Fp[5] FC13 Fi[12] FC18{ Fi Fc FC13 FC13 Fp FC13 Fc} FC19{ BC20{ BC21{ BC9}}}[2] Fi FC19 FC19 FC19 FC19 Fi FC13 Fp[4] FC13 Fp FC19 Fp FC22{ BC23{ BC9}} FC22 FC22 FC22 Fp FC24{ BC25{ m Fp[2]}} Fp Fi FC26{ BC27{ BC9}} Fi FC19[4] FC26 Fp FC28{ BC29{ BC9}} Fi[3] FC28 FC28 FC11 FC30{ BC31{ BC9}} Fi FC32{ m Fp FC6}} vd v1 v2 v3}


 S28C4 ::~S28C4(){ note_dtor("S28C4", this);}
void  S28C4 ::v299(){vfunc_called(this, "_ZN5S28C44v299Ev");}
void  S28C4 ::v300(){vfunc_called(this, "_ZN5S28C44v300Ev");}
void  S28C4 ::v301(){vfunc_called(this, "_ZN5S28C44v301Ev");}
S28C4 ::S28C4(){ note_ctor("S28C4", this);} // tgen

static void Test_S28C4()
{
  extern Class_Descriptor cd_S28C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(223,328)];
    init_test(&cd_S28C4, buf);
    S28C4 *dp, &lv = *(dp=new (buf) S28C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1776,1308), "sizeof(S28C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C4)");
    check_base_class_offset(lv, (S28C8_nt*)(S28C7_nt*)(S28C6*)(S28C5*), 0, "S28C4");
    check_base_class_offset(lv, (S28C7_nt*)(S28C6*)(S28C5*), 0, "S28C4");
    check_base_class_offset(lv, (S28C6*)(S28C5*), 0, "S28C4");
    check_base_class_offset(lv, (S28C5*), 0, "S28C4");
    test_class_info(&lv, &cd_S28C4);
    dp->~S28C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C4(Test_S28C4, "S28C4", ABISELECT(1776,1308));

#else // __cplusplus

extern void _ZN5S28C4C1Ev();
extern void _ZN5S28C4D1Ev();
Name_Map name_map_S28C4[] = {
  NSPAIR(_ZN5S28C4C1Ev),
  NSPAIR(_ZN5S28C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S28C8_nt;
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
extern Class_Descriptor cd_S28C7_nt;
extern VTBL_ENTRY _ZTI8S28C7_nt[];
extern  VTBL_ENTRY _ZTV8S28C7_nt[];
extern Class_Descriptor cd_S28C6;
extern VTBL_ENTRY _ZTI5S28C6[];
extern  VTBL_ENTRY _ZTV5S28C6[];
extern Class_Descriptor cd_S28C5;
extern VTBL_ENTRY _ZTI5S28C5[];
extern  VTBL_ENTRY _ZTV5S28C5[];
static Base_Class bases_S28C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S28C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S28C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S28C4[];
extern void _ZN5S28C4D1Ev();
extern void _ZN5S28C4D0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
extern void _ZN8S28C7_nt3v68Ev();
extern void _ZN8S28C7_nt3v69Ev();
extern void _ZN8S28C7_nt3v70Ev();
extern void _ZN8S28C7_nt3v71Ev();
extern void _ZN8S28C7_nt3v72Ev();
extern void _ZN8S28C7_nt3v73Ev();
extern void _ZN8S28C7_nt3v74Ev();
extern void _ZN8S28C7_nt3v75Ev();
extern void _ZN8S28C7_nt3v76Ev();
extern void _ZN8S28C7_nt3v77Ev();
extern void _ZN8S28C7_nt3v78Ev();
extern void _ZN8S28C7_nt3v79Ev();
extern void _ZN8S28C7_nt3v80Ev();
extern void _ZN8S28C7_nt3v81Ev();
extern void _ZN8S28C7_nt3v82Ev();
extern void _ZN8S28C7_nt3v83Ev();
extern void _ZN8S28C7_nt3v84Ev();
extern void _ZN8S28C7_nt3v85Ev();
extern void _ZN8S28C7_nt3v86Ev();
extern void _ZN8S28C7_nt3v87Ev();
extern void _ZN8S28C7_nt3v88Ev();
extern void _ZN8S28C7_nt3v89Ev();
extern void _ZN8S28C7_nt3v90Ev();
extern void _ZN8S28C7_nt3v91Ev();
extern void _ZN8S28C7_nt3v92Ev();
extern void _ZN8S28C7_nt3v93Ev();
extern void _ZN8S28C7_nt3v94Ev();
extern void _ZN8S28C7_nt3v95Ev();
extern void _ZN8S28C7_nt3v96Ev();
extern void _ZN8S28C7_nt3v97Ev();
extern void _ZN8S28C7_nt3v98Ev();
extern void _ZN8S28C7_nt3v99Ev();
extern void _ZN8S28C7_nt4v100Ev();
extern void _ZN8S28C7_nt4v101Ev();
extern void _ZN8S28C7_nt4v102Ev();
extern void _ZN8S28C7_nt4v103Ev();
extern void _ZN8S28C7_nt4v104Ev();
extern void _ZN8S28C7_nt4v105Ev();
extern void _ZN8S28C7_nt4v106Ev();
extern void _ZN8S28C7_nt4v107Ev();
extern void _ZN8S28C7_nt4v108Ev();
extern void _ZN8S28C7_nt4v109Ev();
extern void _ZN8S28C7_nt4v110Ev();
extern void _ZN8S28C7_nt4v111Ev();
extern void _ZN8S28C7_nt4v112Ev();
extern void _ZN8S28C7_nt4v113Ev();
extern void _ZN8S28C7_nt4v114Ev();
extern void _ZN8S28C7_nt4v115Ev();
extern void _ZN8S28C7_nt4v116Ev();
extern void _ZN8S28C7_nt4v117Ev();
extern void _ZN8S28C7_nt4v118Ev();
extern void _ZN8S28C7_nt4v119Ev();
extern void _ZN8S28C7_nt4v120Ev();
extern void _ZN8S28C7_nt4v121Ev();
extern void _ZN8S28C7_nt4v122Ev();
extern void _ZN8S28C7_nt4v123Ev();
extern void _ZN8S28C7_nt4v124Ev();
extern void _ZN8S28C7_nt4v125Ev();
extern void _ZN8S28C7_nt4v126Ev();
extern void _ZN8S28C7_nt4v127Ev();
extern void _ZN8S28C7_nt4v128Ev();
extern void _ZN8S28C7_nt4v129Ev();
extern void _ZN8S28C7_nt4v130Ev();
extern void _ZN8S28C7_nt4v131Ev();
extern void _ZN8S28C7_nt4v132Ev();
extern void _ZN8S28C7_nt4v133Ev();
extern void _ZN8S28C7_nt4v134Ev();
extern void _ZN8S28C7_nt4v135Ev();
extern void _ZN8S28C7_nt4v136Ev();
extern void _ZN8S28C7_nt4v137Ev();
extern void _ZN8S28C7_nt4v138Ev();
extern void _ZN8S28C7_nt4v139Ev();
extern void _ZN8S28C7_nt4v140Ev();
extern void _ZN8S28C7_nt4v141Ev();
extern void _ZN8S28C7_nt4v142Ev();
extern void _ZN8S28C7_nt4v143Ev();
extern void _ZN8S28C7_nt4v144Ev();
extern void _ZN8S28C7_nt4v145Ev();
extern void _ZN8S28C7_nt4v146Ev();
extern void _ZN8S28C7_nt4v147Ev();
extern void _ZN8S28C7_nt4v148Ev();
extern void _ZN8S28C7_nt4v149Ev();
extern void _ZN8S28C7_nt4v150Ev();
extern void _ZN8S28C7_nt4v151Ev();
extern void _ZN8S28C7_nt4v152Ev();
extern void _ZN8S28C7_nt4v153Ev();
extern void _ZN8S28C7_nt4v154Ev();
extern void _ZN8S28C7_nt4v155Ev();
extern void _ZN8S28C7_nt4v156Ev();
extern void _ZN8S28C7_nt4v157Ev();
extern void _ZN8S28C7_nt4v158Ev();
extern void _ZN8S28C7_nt4v159Ev();
extern void _ZN8S28C7_nt4v160Ev();
extern void _ZN8S28C7_nt4v161Ev();
extern void _ZN8S28C7_nt4v162Ev();
extern void _ZN8S28C7_nt4v163Ev();
extern void _ZN8S28C7_nt4v164Ev();
extern void _ZN8S28C7_nt4v165Ev();
extern void _ZN8S28C7_nt4v166Ev();
extern void _ZN8S28C7_nt4v167Ev();
extern void _ZN8S28C7_nt4v168Ev();
extern void _ZN8S28C7_nt4v169Ev();
extern void _ZN8S28C7_nt4v170Ev();
extern void _ZN8S28C7_nt4v171Ev();
extern void _ZN8S28C7_nt4v172Ev();
extern void _ZN8S28C7_nt4v173Ev();
extern void _ZN8S28C7_nt4v174Ev();
extern void _ZN8S28C7_nt4v175Ev();
extern void _ZN8S28C7_nt4v176Ev();
extern void _ZN8S28C7_nt4v177Ev();
extern void _ZN8S28C7_nt4v178Ev();
extern void _ZN8S28C7_nt4v179Ev();
extern void _ZN8S28C7_nt4v180Ev();
extern void _ZN8S28C7_nt4v181Ev();
extern void _ZN8S28C7_nt4v182Ev();
extern void _ZN8S28C7_nt4v183Ev();
extern void _ZN8S28C7_nt4v184Ev();
extern void _ZN8S28C7_nt4v185Ev();
extern void _ZN8S28C7_nt4v186Ev();
extern void _ZN8S28C7_nt4v187Ev();
extern void _ZN8S28C7_nt4v188Ev();
extern void _ZN8S28C7_nt4v189Ev();
extern void _ZN8S28C7_nt4v190Ev();
extern void _ZN8S28C7_nt4v191Ev();
extern void _ZN8S28C7_nt4v192Ev();
extern void _ZN8S28C7_nt4v193Ev();
extern void _ZN8S28C7_nt4v194Ev();
extern void _ZN8S28C7_nt4v195Ev();
extern void _ZN8S28C7_nt4v196Ev();
extern void _ZN8S28C7_nt4v197Ev();
extern void _ZN8S28C7_nt4v198Ev();
extern void _ZN8S28C7_nt4v199Ev();
extern void _ZN8S28C7_nt4v200Ev();
extern void _ZN8S28C7_nt4v201Ev();
extern void _ZN8S28C7_nt4v202Ev();
extern void _ZN8S28C7_nt4v203Ev();
extern void _ZN8S28C7_nt4v204Ev();
extern void _ZN8S28C7_nt4v205Ev();
extern void _ZN8S28C7_nt4v206Ev();
extern void _ZN8S28C7_nt4v207Ev();
extern void _ZN8S28C7_nt4v208Ev();
extern void _ZN8S28C7_nt4v209Ev();
extern void _ZN8S28C7_nt4v210Ev();
extern void _ZN5S28C64v211Ev();
extern void _ZN5S28C64v212Ev();
extern void _ZN5S28C64v213Ev();
extern void _ZN5S28C64v214Ev();
extern void _ZN5S28C64v215Ev();
extern void _ZN5S28C64v216Ev();
extern void _ZN5S28C64v217Ev();
extern void _ZN5S28C64v218Ev();
extern void _ZN5S28C64v219Ev();
extern void _ZN5S28C64v220Ev();
extern void _ZN5S28C64v221Ev();
extern void _ZN5S28C64v222Ev();
extern void _ZN5S28C64v223Ev();
extern void _ZN5S28C64v224Ev();
extern void _ZN5S28C64v225Ev();
extern void _ZN5S28C64v226Ev();
extern void _ZN5S28C64v227Ev();
extern void _ZN5S28C64v228Ev();
extern void _ZN5S28C64v229Ev();
extern void _ZN5S28C64v230Ev();
extern void _ZN5S28C64v231Ev();
extern void _ZN5S28C64v232Ev();
extern void _ZN5S28C64v233Ev();
extern void _ZN5S28C64v234Ev();
extern void _ZN5S28C64v235Ev();
extern void _ZN5S28C64v236Ev();
extern void _ZN5S28C64v237Ev();
extern void _ZN5S28C64v238Ev();
extern void _ZN5S28C64v239Ev();
extern void _ZN5S28C64v240Ev();
extern void _ZN5S28C64v241Ev();
extern void _ZN5S28C64v242Ev();
extern void _ZN5S28C64v243Ev();
extern void _ZN5S28C64v244Ev();
extern void _ZN5S28C64v245Ev();
extern void _ZN5S28C64v246Ev();
extern void _ZN5S28C64v247Ev();
extern void _ZN5S28C64v248Ev();
extern void _ZN5S28C64v249Ev();
extern void _ZN5S28C64v250Ev();
extern void _ZN5S28C64v251Ev();
extern void _ZN5S28C64v252Ev();
extern void _ZN5S28C64v253Ev();
extern void _ZN5S28C64v254Ev();
extern void _ZN5S28C64v255Ev();
extern void _ZN5S28C64v256Ev();
extern void _ZN5S28C64v257Ev();
extern void _ZN5S28C64v258Ev();
extern void _ZN5S28C64v259Ev();
extern void _ZN5S28C64v260Ev();
extern void _ZN5S28C54v261Ev();
extern void _ZN5S28C54v262Ev();
extern void _ZN5S28C54v263Ev();
extern void _ZN5S28C54v264Ev();
extern void _ZN5S28C54v265Ev();
extern void _ZN5S28C54v266Ev();
extern void _ZN5S28C54v267Ev();
extern void _ZN5S28C54v268Ev();
extern void _ZN5S28C54v269Ev();
extern void _ZN5S28C54v270Ev();
extern void _ZN5S28C54v271Ev();
extern void _ZN5S28C54v272Ev();
extern void _ZN5S28C54v273Ev();
extern void _ZN5S28C54v274Ev();
extern void _ZN5S28C54v275Ev();
extern void _ZN5S28C54v276Ev();
extern void _ZN5S28C54v277Ev();
extern void _ZN5S28C54v278Ev();
extern void _ZN5S28C54v279Ev();
extern void _ZN5S28C54v280Ev();
extern void _ZN5S28C54v281Ev();
extern void _ZN5S28C54v282Ev();
extern void _ZN5S28C54v283Ev();
extern void _ZN5S28C54v284Ev();
extern void _ZN5S28C54v285Ev();
extern void _ZN5S28C54v286Ev();
extern void _ZN5S28C54v287Ev();
extern void _ZN5S28C54v288Ev();
extern void _ZN5S28C54v289Ev();
extern void _ZN5S28C54v290Ev();
extern void _ZN5S28C54v291Ev();
extern void _ZN5S28C54v292Ev();
extern void _ZN5S28C54v293Ev();
extern void _ZN5S28C54v294Ev();
extern void _ZN5S28C54v295Ev();
extern void _ZN5S28C54v296Ev();
extern void _ZN5S28C54v297Ev();
extern void _ZN5S28C54v298Ev();
extern void _ZN5S28C44v299Ev();
extern void _ZN5S28C44v300Ev();
extern void _ZN5S28C44v301Ev();
static  VTBL_ENTRY vtc_S28C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S28C4[0]),
  (VTBL_ENTRY)&_ZN5S28C4D1Ev,
  (VTBL_ENTRY)&_ZN5S28C4D0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN5S28C64v211Ev,
  (VTBL_ENTRY)&_ZN5S28C64v212Ev,
  (VTBL_ENTRY)&_ZN5S28C64v213Ev,
  (VTBL_ENTRY)&_ZN5S28C64v214Ev,
  (VTBL_ENTRY)&_ZN5S28C64v215Ev,
  (VTBL_ENTRY)&_ZN5S28C64v216Ev,
  (VTBL_ENTRY)&_ZN5S28C64v217Ev,
  (VTBL_ENTRY)&_ZN5S28C64v218Ev,
  (VTBL_ENTRY)&_ZN5S28C64v219Ev,
  (VTBL_ENTRY)&_ZN5S28C64v220Ev,
  (VTBL_ENTRY)&_ZN5S28C64v221Ev,
  (VTBL_ENTRY)&_ZN5S28C64v222Ev,
  (VTBL_ENTRY)&_ZN5S28C64v223Ev,
  (VTBL_ENTRY)&_ZN5S28C64v224Ev,
  (VTBL_ENTRY)&_ZN5S28C64v225Ev,
  (VTBL_ENTRY)&_ZN5S28C64v226Ev,
  (VTBL_ENTRY)&_ZN5S28C64v227Ev,
  (VTBL_ENTRY)&_ZN5S28C64v228Ev,
  (VTBL_ENTRY)&_ZN5S28C64v229Ev,
  (VTBL_ENTRY)&_ZN5S28C64v230Ev,
  (VTBL_ENTRY)&_ZN5S28C64v231Ev,
  (VTBL_ENTRY)&_ZN5S28C64v232Ev,
  (VTBL_ENTRY)&_ZN5S28C64v233Ev,
  (VTBL_ENTRY)&_ZN5S28C64v234Ev,
  (VTBL_ENTRY)&_ZN5S28C64v235Ev,
  (VTBL_ENTRY)&_ZN5S28C64v236Ev,
  (VTBL_ENTRY)&_ZN5S28C64v237Ev,
  (VTBL_ENTRY)&_ZN5S28C64v238Ev,
  (VTBL_ENTRY)&_ZN5S28C64v239Ev,
  (VTBL_ENTRY)&_ZN5S28C64v240Ev,
  (VTBL_ENTRY)&_ZN5S28C64v241Ev,
  (VTBL_ENTRY)&_ZN5S28C64v242Ev,
  (VTBL_ENTRY)&_ZN5S28C64v243Ev,
  (VTBL_ENTRY)&_ZN5S28C64v244Ev,
  (VTBL_ENTRY)&_ZN5S28C64v245Ev,
  (VTBL_ENTRY)&_ZN5S28C64v246Ev,
  (VTBL_ENTRY)&_ZN5S28C64v247Ev,
  (VTBL_ENTRY)&_ZN5S28C64v248Ev,
  (VTBL_ENTRY)&_ZN5S28C64v249Ev,
  (VTBL_ENTRY)&_ZN5S28C64v250Ev,
  (VTBL_ENTRY)&_ZN5S28C64v251Ev,
  (VTBL_ENTRY)&_ZN5S28C64v252Ev,
  (VTBL_ENTRY)&_ZN5S28C64v253Ev,
  (VTBL_ENTRY)&_ZN5S28C64v254Ev,
  (VTBL_ENTRY)&_ZN5S28C64v255Ev,
  (VTBL_ENTRY)&_ZN5S28C64v256Ev,
  (VTBL_ENTRY)&_ZN5S28C64v257Ev,
  (VTBL_ENTRY)&_ZN5S28C64v258Ev,
  (VTBL_ENTRY)&_ZN5S28C64v259Ev,
  (VTBL_ENTRY)&_ZN5S28C64v260Ev,
  (VTBL_ENTRY)&_ZN5S28C54v261Ev,
  (VTBL_ENTRY)&_ZN5S28C54v262Ev,
  (VTBL_ENTRY)&_ZN5S28C54v263Ev,
  (VTBL_ENTRY)&_ZN5S28C54v264Ev,
  (VTBL_ENTRY)&_ZN5S28C54v265Ev,
  (VTBL_ENTRY)&_ZN5S28C54v266Ev,
  (VTBL_ENTRY)&_ZN5S28C54v267Ev,
  (VTBL_ENTRY)&_ZN5S28C54v268Ev,
  (VTBL_ENTRY)&_ZN5S28C54v269Ev,
  (VTBL_ENTRY)&_ZN5S28C54v270Ev,
  (VTBL_ENTRY)&_ZN5S28C54v271Ev,
  (VTBL_ENTRY)&_ZN5S28C54v272Ev,
  (VTBL_ENTRY)&_ZN5S28C54v273Ev,
  (VTBL_ENTRY)&_ZN5S28C54v274Ev,
  (VTBL_ENTRY)&_ZN5S28C54v275Ev,
  (VTBL_ENTRY)&_ZN5S28C54v276Ev,
  (VTBL_ENTRY)&_ZN5S28C54v277Ev,
  (VTBL_ENTRY)&_ZN5S28C54v278Ev,
  (VTBL_ENTRY)&_ZN5S28C54v279Ev,
  (VTBL_ENTRY)&_ZN5S28C54v280Ev,
  (VTBL_ENTRY)&_ZN5S28C54v281Ev,
  (VTBL_ENTRY)&_ZN5S28C54v282Ev,
  (VTBL_ENTRY)&_ZN5S28C54v283Ev,
  (VTBL_ENTRY)&_ZN5S28C54v284Ev,
  (VTBL_ENTRY)&_ZN5S28C54v285Ev,
  (VTBL_ENTRY)&_ZN5S28C54v286Ev,
  (VTBL_ENTRY)&_ZN5S28C54v287Ev,
  (VTBL_ENTRY)&_ZN5S28C54v288Ev,
  (VTBL_ENTRY)&_ZN5S28C54v289Ev,
  (VTBL_ENTRY)&_ZN5S28C54v290Ev,
  (VTBL_ENTRY)&_ZN5S28C54v291Ev,
  (VTBL_ENTRY)&_ZN5S28C54v292Ev,
  (VTBL_ENTRY)&_ZN5S28C54v293Ev,
  (VTBL_ENTRY)&_ZN5S28C54v294Ev,
  (VTBL_ENTRY)&_ZN5S28C54v295Ev,
  (VTBL_ENTRY)&_ZN5S28C54v296Ev,
  (VTBL_ENTRY)&_ZN5S28C54v297Ev,
  (VTBL_ENTRY)&_ZN5S28C54v298Ev,
  (VTBL_ENTRY)&_ZN5S28C44v299Ev,
  (VTBL_ENTRY)&_ZN5S28C44v300Ev,
  (VTBL_ENTRY)&_ZN5S28C44v301Ev,
};
extern VTBL_ENTRY _ZTI5S28C4[];
extern  VTBL_ENTRY _ZTV5S28C4[];
Class_Descriptor cd_S28C4 = {  "S28C4", // class name
  bases_S28C4, 4,
  &(vtc_S28C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1776,1308), // object size
  NSPAIRA(_ZTI5S28C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S28C4),302, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C52_nt  {
  void  mf28c52(); // _ZN9S28C52_nt7mf28c52Ev
};
//SIG(-1 S28C52_nt) C1{ m}


void  S28C52_nt ::mf28c52(){}

//skip512 S28C52_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S28C52_nt[];
VTBL_ENTRY *P__ZTI9S28C52_nt = _ZTI9S28C52_nt; 
Class_Descriptor cd_S28C52_nt = {  "S28C52_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S28C52_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C51  {
  unsigned int s28c51f0:1;
  unsigned int s28c51f1:1;
  unsigned int s28c51f2:1;
  unsigned int s28c51f3:1;
  int s28c51f4[6];
  ::S28C52_nt s28c51f5;
  char s28c51f6;
  int s28c51f7[2];
  ::S28C18_nt s28c51f8;
  int s28c51f9[3];
  unsigned int s28c51f10:1;
  int s28c51f11[4];
  ::S28C18_nt s28c51f12;
  ::S28C18_nt s28c51f13;
  ::S28C18_nt s28c51f14;
  int s28c51f15;
  void  mf28c51(); // _ZN6S28C517mf28c51Ev
};
//SIG(-1 S28C51) C1{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC2{ m} Fc Fi[2] FC3{ m Fi[3]} Fi[3] Fi:1 Fi[4] FC3 FC3 FC3 Fi}


void  S28C51 ::mf28c51(){}

static void Test_S28C51()
{
  {
    init_simple_test("S28C51");
    static S28C51 lv;
    check2(sizeof(lv), 124, "sizeof(S28C51)");
    check2(__alignof__(lv), 4, "__alignof__(S28C51)");
    set_bf_and_test(lv, s28c51f0, 0, 0, 1, 1, "S28C51");
    set_bf_and_test(lv, s28c51f1, 0, 1, 1, 1, "S28C51");
    set_bf_and_test(lv, s28c51f2, 0, 2, 1, 1, "S28C51");
    set_bf_and_test(lv, s28c51f3, 0, 3, 1, 1, "S28C51");
    check_field_offset(lv, s28c51f4, 4, "S28C51.s28c51f4");
    check_field_offset(lv, s28c51f5, 28, "S28C51.s28c51f5");
    check_field_offset(lv, s28c51f6, 29, "S28C51.s28c51f6");
    check_field_offset(lv, s28c51f7, 32, "S28C51.s28c51f7");
    check_field_offset(lv, s28c51f8, 40, "S28C51.s28c51f8");
    check_field_offset(lv, s28c51f9, 52, "S28C51.s28c51f9");
    set_bf_and_test(lv, s28c51f10, 64, 0, 1, 1, "S28C51");
    check_field_offset(lv, s28c51f11, 68, "S28C51.s28c51f11");
    check_field_offset(lv, s28c51f12, 84, "S28C51.s28c51f12");
    check_field_offset(lv, s28c51f13, 96, "S28C51.s28c51f13");
    check_field_offset(lv, s28c51f14, 108, "S28C51.s28c51f14");
    check_field_offset(lv, s28c51f15, 120, "S28C51.s28c51f15");
  }
}
static Arrange_To_Call_Me vS28C51(Test_S28C51, "S28C51", 124);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C56  : S28C12_nt {
};
//SIG(-1 S28C56) C1{ BC2{ m Fp Fi[2]}}



static void Test_S28C56()
{
  extern Class_Descriptor cd_S28C56;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C56, buf);
    S28C56 &lv = *(new (buf) S28C56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C56)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S28C56");
    test_class_info(&lv, &cd_S28C56);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C56(Test_S28C56, "S28C56", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S28C56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C56 = {  "S28C56", // class name
  bases_S28C56, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C55  : S28C56 {
};
//SIG(-1 S28C55) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S28C55()
{
  extern Class_Descriptor cd_S28C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S28C55, buf);
    S28C55 &lv = *(new (buf) S28C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S28C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C55)");
    check_base_class_offset(lv, (S28C12_nt*)(S28C56*), 0, "S28C55");
    check_base_class_offset(lv, (S28C56*), 0, "S28C55");
    test_class_info(&lv, &cd_S28C55);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C55(Test_S28C55, "S28C55", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S28C56;
static Base_Class bases_S28C55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C56,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S28C55 = {  "S28C55", // class name
  bases_S28C55, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C3  : S28C4 {
  unsigned int s28c3f0:1;
  unsigned int s28c3f1:1;
  unsigned int s28c3f2:1;
  unsigned int s28c3f3:1;
  unsigned int s28c3f4:1;
  unsigned int s28c3f5:1;
  unsigned int s28c3f6:1;
  unsigned int s28c3f7:1;
  unsigned int s28c3f8:1;
  unsigned int s28c3f9:1;
  unsigned int s28c3f10:1;
  unsigned int s28c3f11:1;
  unsigned int s28c3f12:1;
  unsigned int s28c3f13:1;
  unsigned int s28c3f14:1;
  unsigned int s28c3f15:1;
  unsigned int s28c3f16:1;
  unsigned int s28c3f17:1;
  unsigned int s28c3f18:1;
  unsigned int s28c3f19:1;
  unsigned int s28c3f20:1;
  unsigned int s28c3f21:1;
  unsigned int s28c3f22:1;
  unsigned int s28c3f23:1;
  unsigned int s28c3f24:1;
  unsigned int s28c3f25:1;
  unsigned int s28c3f26:1;
  unsigned int s28c3f27:1;
  unsigned int s28c3f28:1;
  unsigned int s28c3f29:1;
  unsigned int s28c3f30:1;
  unsigned int s28c3f31:1;
  unsigned int s28c3f32:1;
  unsigned int s28c3f33:1;
  unsigned int s28c3f34:1;
  unsigned int s28c3f35:1;
  unsigned int s28c3f36:1;
  unsigned int s28c3f37:1;
  unsigned int s28c3f38:1;
  unsigned int s28c3f39:1;
  unsigned int s28c3f40:1;
  unsigned int s28c3f41:1;
  unsigned int s28c3f42:1;
  unsigned int s28c3f43:1;
  char s28c3f44;
  char s28c3f45[5];
  ::S28C18_nt s28c3f46;
  void *s28c3f47[2];
  int s28c3f48[2];
  ::S28C31_nt s28c3f49;
  void *s28c3f50[3];
  ::S28C51 s28c3f51;
  void *s28c3f52;
  ::S28C18_nt s28c3f53;
  ::S28C18_nt s28c3f54;
  ::S28C51 s28c3f55;
  int s28c3f56;
  void *s28c3f57[3];
  ::S28C18_nt s28c3f58;
  ::S28C18_nt s28c3f59;
  ::S28C18_nt s28c3f60;
  ::S28C18_nt s28c3f61;
  int s28c3f62;
  ::S28C18_nt s28c3f63;
  int s28c3f64[2];
  unsigned int s28c3f65:1;
  unsigned int s28c3f66:1;
  unsigned int s28c3f67:1;
  unsigned int s28c3f68:1;
  int s28c3f69[2];
  ::S28C18_nt s28c3f70;
  int s28c3f71;
  void *s28c3f72;
  int s28c3f73[5];
  ::S28C31_nt s28c3f74;
  int s28c3f75;
  void *s28c3f76[4];
  ::S28C31_nt s28c3f77;
  ::S28C48 s28c3f78;
  void *s28c3f79[2];
  ::S28C16 s28c3f80;
  int s28c3f81[5];
  void *s28c3f82;
  ::S28C55 s28c3f83;
  int s28c3f84;
  virtual  ~S28C3(); // _ZN5S28C3D1Ev
  virtual void  v302(); // _ZN5S28C34v302Ev
  virtual void  v303(); // _ZN5S28C34v303Ev
  virtual void  v304(); // _ZN5S28C34v304Ev
  virtual void  v305(); // _ZN5S28C34v305Ev
  virtual void  v306(); // _ZN5S28C34v306Ev
  virtual void  v307(); // _ZN5S28C34v307Ev
  virtual void  v308(); // _ZN5S28C34v308Ev
  virtual void  v309(); // _ZN5S28C34v309Ev
  virtual void  v310(); // _ZN5S28C34v310Ev
  virtual void  v311(); // _ZN5S28C34v311Ev
  virtual void  v312(); // _ZN5S28C34v312Ev
  virtual void  v313(); // _ZN5S28C34v313Ev
  virtual void  v314(); // _ZN5S28C34v314Ev
  virtual void  v315(); // _ZN5S28C34v315Ev
  virtual void  v316(); // _ZN5S28C34v316Ev
  virtual void  v317(); // _ZN5S28C34v317Ev
  virtual void  v318(); // _ZN5S28C34v318Ev
  virtual void  v319(); // _ZN5S28C34v319Ev
  virtual void  v320(); // _ZN5S28C34v320Ev
  S28C3(); // tgen
};
//SIG(-1 S28C3) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 FC11{ m Fi} Fi Fc[4] Fp[2] FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC7 FC7 FC7 FC12{ BC13{ BC10}} FC12 Fi Fp[2] FC14{ m Fi[3]} FC14 FC14 FC14 Fp FC7 FC12 FC14 FC14 Fi FC14 FC14 Fp Fi Fc FC14 FC14 Fp Fi Fp FC12 FC15{ BC16{ BC10}} FC15} vd v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC14 FC14 Fp[5] FC14 Fp FC17{ BC18{ BC10}} Fp[2] FC14 Fp Fi[2] Fp Fi FC14 FC14 FC14 Fp[2] Fi FC14 Fi[4] Fp[2] FC17 Fi FC14} vd v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC14 Fi FC14 Fp[5] FC14 Fi[12] FC19{ Fi Fc FC14 FC14 Fp FC14 Fc} FC20{ BC21{ BC22{ BC10}}}[2] Fi FC20 FC20 FC20 FC20 Fi FC14 Fp[4] FC14 Fp FC20 Fp FC23{ BC24{ BC10}} FC23 FC23 FC23 Fp FC25{ BC26{ m Fp[2]}} Fp Fi FC27{ BC28{ BC10}} Fi FC20[4] FC27 Fp FC29{ BC30{ BC10}} Fi[3] FC29 FC29 FC12 FC31{ BC32{ BC10}} Fi FC33{ m Fp FC7}} vd v315 v316 v317} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc[6] FC14 Fp[2] Fi[2] FC20 Fp[3] FC34{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC35{ m} Fc Fi[2] FC14 Fi[3] Fi:1 Fi[4] FC14 FC14 FC14 Fi} Fp FC14 FC14 FC34 Fi Fp[3] FC14 FC14 FC14 FC14 Fi FC14 Fi[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] FC14 Fi Fp Fi[5] FC20 Fi Fp[4] FC20 FC31 Fp[2] FC12 Fi[5] Fp FC36{ BC37{ BC10}} Fi}


 S28C3 ::~S28C3(){ note_dtor("S28C3", this);}
void  S28C3 ::v302(){vfunc_called(this, "_ZN5S28C34v302Ev");}
void  S28C3 ::v303(){vfunc_called(this, "_ZN5S28C34v303Ev");}
void  S28C3 ::v304(){vfunc_called(this, "_ZN5S28C34v304Ev");}
void  S28C3 ::v305(){vfunc_called(this, "_ZN5S28C34v305Ev");}
void  S28C3 ::v306(){vfunc_called(this, "_ZN5S28C34v306Ev");}
void  S28C3 ::v307(){vfunc_called(this, "_ZN5S28C34v307Ev");}
void  S28C3 ::v308(){vfunc_called(this, "_ZN5S28C34v308Ev");}
void  S28C3 ::v309(){vfunc_called(this, "_ZN5S28C34v309Ev");}
void  S28C3 ::v310(){vfunc_called(this, "_ZN5S28C34v310Ev");}
void  S28C3 ::v311(){vfunc_called(this, "_ZN5S28C34v311Ev");}
void  S28C3 ::v312(){vfunc_called(this, "_ZN5S28C34v312Ev");}
void  S28C3 ::v313(){vfunc_called(this, "_ZN5S28C34v313Ev");}
void  S28C3 ::v314(){vfunc_called(this, "_ZN5S28C34v314Ev");}
void  S28C3 ::v315(){vfunc_called(this, "_ZN5S28C34v315Ev");}
void  S28C3 ::v316(){vfunc_called(this, "_ZN5S28C34v316Ev");}
void  S28C3 ::v317(){vfunc_called(this, "_ZN5S28C34v317Ev");}
void  S28C3 ::v318(){vfunc_called(this, "_ZN5S28C34v318Ev");}
void  S28C3 ::v319(){vfunc_called(this, "_ZN5S28C34v319Ev");}
void  S28C3 ::v320(){vfunc_called(this, "_ZN5S28C34v320Ev");}
S28C3 ::S28C3(){ note_ctor("S28C3", this);} // tgen

static void Test_S28C3()
{
  extern Class_Descriptor cd_S28C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(312,477)];
    init_test(&cd_S28C3, buf);
    S28C3 *dp, &lv = *(dp=new (buf) S28C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2488,1904), "sizeof(S28C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C3)");
    check_base_class_offset(lv, (S28C8_nt*)(S28C7_nt*)(S28C6*)(S28C5*)(S28C4*), 0, "S28C3");
    check_base_class_offset(lv, (S28C7_nt*)(S28C6*)(S28C5*)(S28C4*), 0, "S28C3");
    check_base_class_offset(lv, (S28C6*)(S28C5*)(S28C4*), 0, "S28C3");
    check_base_class_offset(lv, (S28C5*)(S28C4*), 0, "S28C3");
    check_base_class_offset(lv, (S28C4*), 0, "S28C3");
    set_bf_and_test(lv, s28c3f0, ABISELECT(1776,1308), 0, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f1, ABISELECT(1776,1308), 1, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f2, ABISELECT(1776,1308), 2, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f3, ABISELECT(1776,1308), 3, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f4, ABISELECT(1776,1308), 4, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f5, ABISELECT(1776,1308), 5, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f6, ABISELECT(1776,1308), 6, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f7, ABISELECT(1776,1308), 7, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f8, ABISELECT(1777,1309), 0, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f9, ABISELECT(1777,1309), 1, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f10, ABISELECT(1777,1309), 2, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f11, ABISELECT(1777,1309), 3, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f12, ABISELECT(1777,1309), 4, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f13, ABISELECT(1777,1309), 5, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f14, ABISELECT(1777,1309), 6, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f15, ABISELECT(1777,1309), 7, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f16, ABISELECT(1778,1310), 0, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f17, ABISELECT(1778,1310), 1, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f18, ABISELECT(1778,1310), 2, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f19, ABISELECT(1778,1310), 3, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f20, ABISELECT(1778,1310), 4, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f21, ABISELECT(1778,1310), 5, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f22, ABISELECT(1778,1310), 6, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f23, ABISELECT(1778,1310), 7, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f24, ABISELECT(1779,1311), 0, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f25, ABISELECT(1779,1311), 1, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f26, ABISELECT(1779,1311), 2, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f27, ABISELECT(1779,1311), 3, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f28, ABISELECT(1779,1311), 4, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f29, ABISELECT(1779,1311), 5, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f30, ABISELECT(1779,1311), 6, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f31, ABISELECT(1779,1311), 7, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f32, ABISELECT(1780,1312), 0, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f33, ABISELECT(1780,1312), 1, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f34, ABISELECT(1780,1312), 2, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f35, ABISELECT(1780,1312), 3, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f36, ABISELECT(1780,1312), 4, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f37, ABISELECT(1780,1312), 5, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f38, ABISELECT(1780,1312), 6, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f39, ABISELECT(1780,1312), 7, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f40, ABISELECT(1781,1313), 0, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f41, ABISELECT(1781,1313), 1, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f42, ABISELECT(1781,1313), 2, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f43, ABISELECT(1781,1313), 3, 1, 1, "S28C3");
    check_field_offset(lv, s28c3f44, ABISELECT(1782,1314), "S28C3.s28c3f44");
    check_field_offset(lv, s28c3f45, ABISELECT(1783,1315), "S28C3.s28c3f45");
    check_field_offset(lv, s28c3f46, ABISELECT(1788,1320), "S28C3.s28c3f46");
    check_field_offset(lv, s28c3f47, ABISELECT(1800,1332), "S28C3.s28c3f47");
    check_field_offset(lv, s28c3f48, ABISELECT(1816,1340), "S28C3.s28c3f48");
    check_field_offset(lv, s28c3f49, ABISELECT(1824,1348), "S28C3.s28c3f49");
    check_field_offset(lv, s28c3f50, ABISELECT(1840,1360), "S28C3.s28c3f50");
    check_field_offset(lv, s28c3f51, ABISELECT(1864,1372), "S28C3.s28c3f51");
    check_field_offset(lv, s28c3f52, ABISELECT(1992,1496), "S28C3.s28c3f52");
    check_field_offset(lv, s28c3f53, ABISELECT(2000,1500), "S28C3.s28c3f53");
    check_field_offset(lv, s28c3f54, ABISELECT(2012,1512), "S28C3.s28c3f54");
    check_field_offset(lv, s28c3f55, ABISELECT(2024,1524), "S28C3.s28c3f55");
    check_field_offset(lv, s28c3f56, ABISELECT(2148,1648), "S28C3.s28c3f56");
    check_field_offset(lv, s28c3f57, ABISELECT(2152,1652), "S28C3.s28c3f57");
    check_field_offset(lv, s28c3f58, ABISELECT(2176,1664), "S28C3.s28c3f58");
    check_field_offset(lv, s28c3f59, ABISELECT(2188,1676), "S28C3.s28c3f59");
    check_field_offset(lv, s28c3f60, ABISELECT(2200,1688), "S28C3.s28c3f60");
    check_field_offset(lv, s28c3f61, ABISELECT(2212,1700), "S28C3.s28c3f61");
    check_field_offset(lv, s28c3f62, ABISELECT(2224,1712), "S28C3.s28c3f62");
    check_field_offset(lv, s28c3f63, ABISELECT(2228,1716), "S28C3.s28c3f63");
    check_field_offset(lv, s28c3f64, ABISELECT(2240,1728), "S28C3.s28c3f64");
    set_bf_and_test(lv, s28c3f65, ABISELECT(2248,1736), 0, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f66, ABISELECT(2248,1736), 1, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f67, ABISELECT(2248,1736), 2, 1, 1, "S28C3");
    set_bf_and_test(lv, s28c3f68, ABISELECT(2248,1736), 3, 1, 1, "S28C3");
    check_field_offset(lv, s28c3f69, ABISELECT(2252,1740), "S28C3.s28c3f69");
    check_field_offset(lv, s28c3f70, ABISELECT(2260,1748), "S28C3.s28c3f70");
    check_field_offset(lv, s28c3f71, ABISELECT(2272,1760), "S28C3.s28c3f71");
    check_field_offset(lv, s28c3f72, ABISELECT(2280,1764), "S28C3.s28c3f72");
    check_field_offset(lv, s28c3f73, ABISELECT(2288,1768), "S28C3.s28c3f73");
    check_field_offset(lv, s28c3f74, ABISELECT(2312,1788), "S28C3.s28c3f74");
    check_field_offset(lv, s28c3f75, ABISELECT(2328,1800), "S28C3.s28c3f75");
    check_field_offset(lv, s28c3f76, ABISELECT(2336,1804), "S28C3.s28c3f76");
    check_field_offset(lv, s28c3f77, ABISELECT(2368,1820), "S28C3.s28c3f77");
    check_field_offset(lv, s28c3f78, ABISELECT(2384,1832), "S28C3.s28c3f78");
    check_field_offset(lv, s28c3f79, ABISELECT(2400,1844), "S28C3.s28c3f79");
    check_field_offset(lv, s28c3f80, ABISELECT(2416,1852), "S28C3.s28c3f80");
    check_field_offset(lv, s28c3f81, ABISELECT(2432,1864), "S28C3.s28c3f81");
    check_field_offset(lv, s28c3f82, ABISELECT(2456,1884), "S28C3.s28c3f82");
    check_field_offset(lv, s28c3f83, ABISELECT(2464,1888), "S28C3.s28c3f83");
    check_field_offset(lv, s28c3f84, ABISELECT(2480,1900), "S28C3.s28c3f84");
    test_class_info(&lv, &cd_S28C3);
    dp->~S28C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C3(Test_S28C3, "S28C3", ABISELECT(2488,1904));

#else // __cplusplus

extern void _ZN5S28C3C1Ev();
extern void _ZN5S28C3D1Ev();
Name_Map name_map_S28C3[] = {
  NSPAIR(_ZN5S28C3C1Ev),
  NSPAIR(_ZN5S28C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S28C8_nt;
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
extern Class_Descriptor cd_S28C7_nt;
extern VTBL_ENTRY _ZTI8S28C7_nt[];
extern  VTBL_ENTRY _ZTV8S28C7_nt[];
extern Class_Descriptor cd_S28C6;
extern VTBL_ENTRY _ZTI5S28C6[];
extern  VTBL_ENTRY _ZTV5S28C6[];
extern Class_Descriptor cd_S28C5;
extern VTBL_ENTRY _ZTI5S28C5[];
extern  VTBL_ENTRY _ZTV5S28C5[];
extern Class_Descriptor cd_S28C4;
extern VTBL_ENTRY _ZTI5S28C4[];
extern  VTBL_ENTRY _ZTV5S28C4[];
static Base_Class bases_S28C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S28C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S28C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S28C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S28C3[];
extern void _ZN5S28C3D1Ev();
extern void _ZN5S28C3D0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
extern void _ZN8S28C7_nt3v68Ev();
extern void _ZN8S28C7_nt3v69Ev();
extern void _ZN8S28C7_nt3v70Ev();
extern void _ZN8S28C7_nt3v71Ev();
extern void _ZN8S28C7_nt3v72Ev();
extern void _ZN8S28C7_nt3v73Ev();
extern void _ZN8S28C7_nt3v74Ev();
extern void _ZN8S28C7_nt3v75Ev();
extern void _ZN8S28C7_nt3v76Ev();
extern void _ZN8S28C7_nt3v77Ev();
extern void _ZN8S28C7_nt3v78Ev();
extern void _ZN8S28C7_nt3v79Ev();
extern void _ZN8S28C7_nt3v80Ev();
extern void _ZN8S28C7_nt3v81Ev();
extern void _ZN8S28C7_nt3v82Ev();
extern void _ZN8S28C7_nt3v83Ev();
extern void _ZN8S28C7_nt3v84Ev();
extern void _ZN8S28C7_nt3v85Ev();
extern void _ZN8S28C7_nt3v86Ev();
extern void _ZN8S28C7_nt3v87Ev();
extern void _ZN8S28C7_nt3v88Ev();
extern void _ZN8S28C7_nt3v89Ev();
extern void _ZN8S28C7_nt3v90Ev();
extern void _ZN8S28C7_nt3v91Ev();
extern void _ZN8S28C7_nt3v92Ev();
extern void _ZN8S28C7_nt3v93Ev();
extern void _ZN8S28C7_nt3v94Ev();
extern void _ZN8S28C7_nt3v95Ev();
extern void _ZN8S28C7_nt3v96Ev();
extern void _ZN8S28C7_nt3v97Ev();
extern void _ZN8S28C7_nt3v98Ev();
extern void _ZN8S28C7_nt3v99Ev();
extern void _ZN8S28C7_nt4v100Ev();
extern void _ZN8S28C7_nt4v101Ev();
extern void _ZN8S28C7_nt4v102Ev();
extern void _ZN8S28C7_nt4v103Ev();
extern void _ZN8S28C7_nt4v104Ev();
extern void _ZN8S28C7_nt4v105Ev();
extern void _ZN8S28C7_nt4v106Ev();
extern void _ZN8S28C7_nt4v107Ev();
extern void _ZN8S28C7_nt4v108Ev();
extern void _ZN8S28C7_nt4v109Ev();
extern void _ZN8S28C7_nt4v110Ev();
extern void _ZN8S28C7_nt4v111Ev();
extern void _ZN8S28C7_nt4v112Ev();
extern void _ZN8S28C7_nt4v113Ev();
extern void _ZN8S28C7_nt4v114Ev();
extern void _ZN8S28C7_nt4v115Ev();
extern void _ZN8S28C7_nt4v116Ev();
extern void _ZN8S28C7_nt4v117Ev();
extern void _ZN8S28C7_nt4v118Ev();
extern void _ZN8S28C7_nt4v119Ev();
extern void _ZN8S28C7_nt4v120Ev();
extern void _ZN8S28C7_nt4v121Ev();
extern void _ZN8S28C7_nt4v122Ev();
extern void _ZN8S28C7_nt4v123Ev();
extern void _ZN8S28C7_nt4v124Ev();
extern void _ZN8S28C7_nt4v125Ev();
extern void _ZN8S28C7_nt4v126Ev();
extern void _ZN8S28C7_nt4v127Ev();
extern void _ZN8S28C7_nt4v128Ev();
extern void _ZN8S28C7_nt4v129Ev();
extern void _ZN8S28C7_nt4v130Ev();
extern void _ZN8S28C7_nt4v131Ev();
extern void _ZN8S28C7_nt4v132Ev();
extern void _ZN8S28C7_nt4v133Ev();
extern void _ZN8S28C7_nt4v134Ev();
extern void _ZN8S28C7_nt4v135Ev();
extern void _ZN8S28C7_nt4v136Ev();
extern void _ZN8S28C7_nt4v137Ev();
extern void _ZN8S28C7_nt4v138Ev();
extern void _ZN8S28C7_nt4v139Ev();
extern void _ZN8S28C7_nt4v140Ev();
extern void _ZN8S28C7_nt4v141Ev();
extern void _ZN8S28C7_nt4v142Ev();
extern void _ZN8S28C7_nt4v143Ev();
extern void _ZN8S28C7_nt4v144Ev();
extern void _ZN8S28C7_nt4v145Ev();
extern void _ZN8S28C7_nt4v146Ev();
extern void _ZN8S28C7_nt4v147Ev();
extern void _ZN8S28C7_nt4v148Ev();
extern void _ZN8S28C7_nt4v149Ev();
extern void _ZN8S28C7_nt4v150Ev();
extern void _ZN8S28C7_nt4v151Ev();
extern void _ZN8S28C7_nt4v152Ev();
extern void _ZN8S28C7_nt4v153Ev();
extern void _ZN8S28C7_nt4v154Ev();
extern void _ZN8S28C7_nt4v155Ev();
extern void _ZN8S28C7_nt4v156Ev();
extern void _ZN8S28C7_nt4v157Ev();
extern void _ZN8S28C7_nt4v158Ev();
extern void _ZN8S28C7_nt4v159Ev();
extern void _ZN8S28C7_nt4v160Ev();
extern void _ZN8S28C7_nt4v161Ev();
extern void _ZN8S28C7_nt4v162Ev();
extern void _ZN8S28C7_nt4v163Ev();
extern void _ZN8S28C7_nt4v164Ev();
extern void _ZN8S28C7_nt4v165Ev();
extern void _ZN8S28C7_nt4v166Ev();
extern void _ZN8S28C7_nt4v167Ev();
extern void _ZN8S28C7_nt4v168Ev();
extern void _ZN8S28C7_nt4v169Ev();
extern void _ZN8S28C7_nt4v170Ev();
extern void _ZN8S28C7_nt4v171Ev();
extern void _ZN8S28C7_nt4v172Ev();
extern void _ZN8S28C7_nt4v173Ev();
extern void _ZN8S28C7_nt4v174Ev();
extern void _ZN8S28C7_nt4v175Ev();
extern void _ZN8S28C7_nt4v176Ev();
extern void _ZN8S28C7_nt4v177Ev();
extern void _ZN8S28C7_nt4v178Ev();
extern void _ZN8S28C7_nt4v179Ev();
extern void _ZN8S28C7_nt4v180Ev();
extern void _ZN8S28C7_nt4v181Ev();
extern void _ZN8S28C7_nt4v182Ev();
extern void _ZN8S28C7_nt4v183Ev();
extern void _ZN8S28C7_nt4v184Ev();
extern void _ZN8S28C7_nt4v185Ev();
extern void _ZN8S28C7_nt4v186Ev();
extern void _ZN8S28C7_nt4v187Ev();
extern void _ZN8S28C7_nt4v188Ev();
extern void _ZN8S28C7_nt4v189Ev();
extern void _ZN8S28C7_nt4v190Ev();
extern void _ZN8S28C7_nt4v191Ev();
extern void _ZN8S28C7_nt4v192Ev();
extern void _ZN8S28C7_nt4v193Ev();
extern void _ZN8S28C7_nt4v194Ev();
extern void _ZN8S28C7_nt4v195Ev();
extern void _ZN8S28C7_nt4v196Ev();
extern void _ZN8S28C7_nt4v197Ev();
extern void _ZN8S28C7_nt4v198Ev();
extern void _ZN8S28C7_nt4v199Ev();
extern void _ZN8S28C7_nt4v200Ev();
extern void _ZN8S28C7_nt4v201Ev();
extern void _ZN8S28C7_nt4v202Ev();
extern void _ZN8S28C7_nt4v203Ev();
extern void _ZN8S28C7_nt4v204Ev();
extern void _ZN8S28C7_nt4v205Ev();
extern void _ZN8S28C7_nt4v206Ev();
extern void _ZN8S28C7_nt4v207Ev();
extern void _ZN8S28C7_nt4v208Ev();
extern void _ZN8S28C7_nt4v209Ev();
extern void _ZN8S28C7_nt4v210Ev();
extern void _ZN5S28C64v211Ev();
extern void _ZN5S28C64v212Ev();
extern void _ZN5S28C64v213Ev();
extern void _ZN5S28C64v214Ev();
extern void _ZN5S28C64v215Ev();
extern void _ZN5S28C64v216Ev();
extern void _ZN5S28C64v217Ev();
extern void _ZN5S28C64v218Ev();
extern void _ZN5S28C64v219Ev();
extern void _ZN5S28C64v220Ev();
extern void _ZN5S28C64v221Ev();
extern void _ZN5S28C64v222Ev();
extern void _ZN5S28C64v223Ev();
extern void _ZN5S28C64v224Ev();
extern void _ZN5S28C64v225Ev();
extern void _ZN5S28C64v226Ev();
extern void _ZN5S28C64v227Ev();
extern void _ZN5S28C64v228Ev();
extern void _ZN5S28C64v229Ev();
extern void _ZN5S28C64v230Ev();
extern void _ZN5S28C64v231Ev();
extern void _ZN5S28C64v232Ev();
extern void _ZN5S28C64v233Ev();
extern void _ZN5S28C64v234Ev();
extern void _ZN5S28C64v235Ev();
extern void _ZN5S28C64v236Ev();
extern void _ZN5S28C64v237Ev();
extern void _ZN5S28C64v238Ev();
extern void _ZN5S28C64v239Ev();
extern void _ZN5S28C64v240Ev();
extern void _ZN5S28C64v241Ev();
extern void _ZN5S28C64v242Ev();
extern void _ZN5S28C64v243Ev();
extern void _ZN5S28C64v244Ev();
extern void _ZN5S28C64v245Ev();
extern void _ZN5S28C64v246Ev();
extern void _ZN5S28C64v247Ev();
extern void _ZN5S28C64v248Ev();
extern void _ZN5S28C64v249Ev();
extern void _ZN5S28C64v250Ev();
extern void _ZN5S28C64v251Ev();
extern void _ZN5S28C64v252Ev();
extern void _ZN5S28C64v253Ev();
extern void _ZN5S28C64v254Ev();
extern void _ZN5S28C64v255Ev();
extern void _ZN5S28C64v256Ev();
extern void _ZN5S28C64v257Ev();
extern void _ZN5S28C64v258Ev();
extern void _ZN5S28C64v259Ev();
extern void _ZN5S28C64v260Ev();
extern void _ZN5S28C54v261Ev();
extern void _ZN5S28C54v262Ev();
extern void _ZN5S28C54v263Ev();
extern void _ZN5S28C54v264Ev();
extern void _ZN5S28C54v265Ev();
extern void _ZN5S28C54v266Ev();
extern void _ZN5S28C54v267Ev();
extern void _ZN5S28C54v268Ev();
extern void _ZN5S28C54v269Ev();
extern void _ZN5S28C54v270Ev();
extern void _ZN5S28C54v271Ev();
extern void _ZN5S28C54v272Ev();
extern void _ZN5S28C54v273Ev();
extern void _ZN5S28C54v274Ev();
extern void _ZN5S28C54v275Ev();
extern void _ZN5S28C54v276Ev();
extern void _ZN5S28C54v277Ev();
extern void _ZN5S28C54v278Ev();
extern void _ZN5S28C54v279Ev();
extern void _ZN5S28C54v280Ev();
extern void _ZN5S28C54v281Ev();
extern void _ZN5S28C54v282Ev();
extern void _ZN5S28C54v283Ev();
extern void _ZN5S28C54v284Ev();
extern void _ZN5S28C54v285Ev();
extern void _ZN5S28C54v286Ev();
extern void _ZN5S28C54v287Ev();
extern void _ZN5S28C54v288Ev();
extern void _ZN5S28C54v289Ev();
extern void _ZN5S28C54v290Ev();
extern void _ZN5S28C54v291Ev();
extern void _ZN5S28C54v292Ev();
extern void _ZN5S28C54v293Ev();
extern void _ZN5S28C54v294Ev();
extern void _ZN5S28C54v295Ev();
extern void _ZN5S28C54v296Ev();
extern void _ZN5S28C54v297Ev();
extern void _ZN5S28C54v298Ev();
extern void _ZN5S28C44v299Ev();
extern void _ZN5S28C44v300Ev();
extern void _ZN5S28C44v301Ev();
extern void _ZN5S28C34v302Ev();
extern void _ZN5S28C34v303Ev();
extern void _ZN5S28C34v304Ev();
extern void _ZN5S28C34v305Ev();
extern void _ZN5S28C34v306Ev();
extern void _ZN5S28C34v307Ev();
extern void _ZN5S28C34v308Ev();
extern void _ZN5S28C34v309Ev();
extern void _ZN5S28C34v310Ev();
extern void _ZN5S28C34v311Ev();
extern void _ZN5S28C34v312Ev();
extern void _ZN5S28C34v313Ev();
extern void _ZN5S28C34v314Ev();
extern void _ZN5S28C34v315Ev();
extern void _ZN5S28C34v316Ev();
extern void _ZN5S28C34v317Ev();
extern void _ZN5S28C34v318Ev();
extern void _ZN5S28C34v319Ev();
extern void _ZN5S28C34v320Ev();
static  VTBL_ENTRY vtc_S28C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S28C3[0]),
  (VTBL_ENTRY)&_ZN5S28C3D1Ev,
  (VTBL_ENTRY)&_ZN5S28C3D0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN5S28C64v211Ev,
  (VTBL_ENTRY)&_ZN5S28C64v212Ev,
  (VTBL_ENTRY)&_ZN5S28C64v213Ev,
  (VTBL_ENTRY)&_ZN5S28C64v214Ev,
  (VTBL_ENTRY)&_ZN5S28C64v215Ev,
  (VTBL_ENTRY)&_ZN5S28C64v216Ev,
  (VTBL_ENTRY)&_ZN5S28C64v217Ev,
  (VTBL_ENTRY)&_ZN5S28C64v218Ev,
  (VTBL_ENTRY)&_ZN5S28C64v219Ev,
  (VTBL_ENTRY)&_ZN5S28C64v220Ev,
  (VTBL_ENTRY)&_ZN5S28C64v221Ev,
  (VTBL_ENTRY)&_ZN5S28C64v222Ev,
  (VTBL_ENTRY)&_ZN5S28C64v223Ev,
  (VTBL_ENTRY)&_ZN5S28C64v224Ev,
  (VTBL_ENTRY)&_ZN5S28C64v225Ev,
  (VTBL_ENTRY)&_ZN5S28C64v226Ev,
  (VTBL_ENTRY)&_ZN5S28C64v227Ev,
  (VTBL_ENTRY)&_ZN5S28C64v228Ev,
  (VTBL_ENTRY)&_ZN5S28C64v229Ev,
  (VTBL_ENTRY)&_ZN5S28C64v230Ev,
  (VTBL_ENTRY)&_ZN5S28C64v231Ev,
  (VTBL_ENTRY)&_ZN5S28C64v232Ev,
  (VTBL_ENTRY)&_ZN5S28C64v233Ev,
  (VTBL_ENTRY)&_ZN5S28C64v234Ev,
  (VTBL_ENTRY)&_ZN5S28C64v235Ev,
  (VTBL_ENTRY)&_ZN5S28C64v236Ev,
  (VTBL_ENTRY)&_ZN5S28C64v237Ev,
  (VTBL_ENTRY)&_ZN5S28C64v238Ev,
  (VTBL_ENTRY)&_ZN5S28C64v239Ev,
  (VTBL_ENTRY)&_ZN5S28C64v240Ev,
  (VTBL_ENTRY)&_ZN5S28C64v241Ev,
  (VTBL_ENTRY)&_ZN5S28C64v242Ev,
  (VTBL_ENTRY)&_ZN5S28C64v243Ev,
  (VTBL_ENTRY)&_ZN5S28C64v244Ev,
  (VTBL_ENTRY)&_ZN5S28C64v245Ev,
  (VTBL_ENTRY)&_ZN5S28C64v246Ev,
  (VTBL_ENTRY)&_ZN5S28C64v247Ev,
  (VTBL_ENTRY)&_ZN5S28C64v248Ev,
  (VTBL_ENTRY)&_ZN5S28C64v249Ev,
  (VTBL_ENTRY)&_ZN5S28C64v250Ev,
  (VTBL_ENTRY)&_ZN5S28C64v251Ev,
  (VTBL_ENTRY)&_ZN5S28C64v252Ev,
  (VTBL_ENTRY)&_ZN5S28C64v253Ev,
  (VTBL_ENTRY)&_ZN5S28C64v254Ev,
  (VTBL_ENTRY)&_ZN5S28C64v255Ev,
  (VTBL_ENTRY)&_ZN5S28C64v256Ev,
  (VTBL_ENTRY)&_ZN5S28C64v257Ev,
  (VTBL_ENTRY)&_ZN5S28C64v258Ev,
  (VTBL_ENTRY)&_ZN5S28C64v259Ev,
  (VTBL_ENTRY)&_ZN5S28C64v260Ev,
  (VTBL_ENTRY)&_ZN5S28C54v261Ev,
  (VTBL_ENTRY)&_ZN5S28C54v262Ev,
  (VTBL_ENTRY)&_ZN5S28C54v263Ev,
  (VTBL_ENTRY)&_ZN5S28C54v264Ev,
  (VTBL_ENTRY)&_ZN5S28C54v265Ev,
  (VTBL_ENTRY)&_ZN5S28C54v266Ev,
  (VTBL_ENTRY)&_ZN5S28C54v267Ev,
  (VTBL_ENTRY)&_ZN5S28C54v268Ev,
  (VTBL_ENTRY)&_ZN5S28C54v269Ev,
  (VTBL_ENTRY)&_ZN5S28C54v270Ev,
  (VTBL_ENTRY)&_ZN5S28C54v271Ev,
  (VTBL_ENTRY)&_ZN5S28C54v272Ev,
  (VTBL_ENTRY)&_ZN5S28C54v273Ev,
  (VTBL_ENTRY)&_ZN5S28C54v274Ev,
  (VTBL_ENTRY)&_ZN5S28C54v275Ev,
  (VTBL_ENTRY)&_ZN5S28C54v276Ev,
  (VTBL_ENTRY)&_ZN5S28C54v277Ev,
  (VTBL_ENTRY)&_ZN5S28C54v278Ev,
  (VTBL_ENTRY)&_ZN5S28C54v279Ev,
  (VTBL_ENTRY)&_ZN5S28C54v280Ev,
  (VTBL_ENTRY)&_ZN5S28C54v281Ev,
  (VTBL_ENTRY)&_ZN5S28C54v282Ev,
  (VTBL_ENTRY)&_ZN5S28C54v283Ev,
  (VTBL_ENTRY)&_ZN5S28C54v284Ev,
  (VTBL_ENTRY)&_ZN5S28C54v285Ev,
  (VTBL_ENTRY)&_ZN5S28C54v286Ev,
  (VTBL_ENTRY)&_ZN5S28C54v287Ev,
  (VTBL_ENTRY)&_ZN5S28C54v288Ev,
  (VTBL_ENTRY)&_ZN5S28C54v289Ev,
  (VTBL_ENTRY)&_ZN5S28C54v290Ev,
  (VTBL_ENTRY)&_ZN5S28C54v291Ev,
  (VTBL_ENTRY)&_ZN5S28C54v292Ev,
  (VTBL_ENTRY)&_ZN5S28C54v293Ev,
  (VTBL_ENTRY)&_ZN5S28C54v294Ev,
  (VTBL_ENTRY)&_ZN5S28C54v295Ev,
  (VTBL_ENTRY)&_ZN5S28C54v296Ev,
  (VTBL_ENTRY)&_ZN5S28C54v297Ev,
  (VTBL_ENTRY)&_ZN5S28C54v298Ev,
  (VTBL_ENTRY)&_ZN5S28C44v299Ev,
  (VTBL_ENTRY)&_ZN5S28C44v300Ev,
  (VTBL_ENTRY)&_ZN5S28C44v301Ev,
  (VTBL_ENTRY)&_ZN5S28C34v302Ev,
  (VTBL_ENTRY)&_ZN5S28C34v303Ev,
  (VTBL_ENTRY)&_ZN5S28C34v304Ev,
  (VTBL_ENTRY)&_ZN5S28C34v305Ev,
  (VTBL_ENTRY)&_ZN5S28C34v306Ev,
  (VTBL_ENTRY)&_ZN5S28C34v307Ev,
  (VTBL_ENTRY)&_ZN5S28C34v308Ev,
  (VTBL_ENTRY)&_ZN5S28C34v309Ev,
  (VTBL_ENTRY)&_ZN5S28C34v310Ev,
  (VTBL_ENTRY)&_ZN5S28C34v311Ev,
  (VTBL_ENTRY)&_ZN5S28C34v312Ev,
  (VTBL_ENTRY)&_ZN5S28C34v313Ev,
  (VTBL_ENTRY)&_ZN5S28C34v314Ev,
  (VTBL_ENTRY)&_ZN5S28C34v315Ev,
  (VTBL_ENTRY)&_ZN5S28C34v316Ev,
  (VTBL_ENTRY)&_ZN5S28C34v317Ev,
  (VTBL_ENTRY)&_ZN5S28C34v318Ev,
  (VTBL_ENTRY)&_ZN5S28C34v319Ev,
  (VTBL_ENTRY)&_ZN5S28C34v320Ev,
};
extern VTBL_ENTRY _ZTI5S28C3[];
extern  VTBL_ENTRY _ZTV5S28C3[];
Class_Descriptor cd_S28C3 = {  "S28C3", // class name
  bases_S28C3, 5,
  &(vtc_S28C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2488,1904), // object size
  NSPAIRA(_ZTI5S28C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S28C3),321, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C2  : S28C3 {
  void *s28c2f0;
  ::S28C55 s28c2f1;
  void *s28c2f2;
  virtual  ~S28C2(); // _ZN5S28C2D1Ev
  virtual void  v321(); // _ZN5S28C24v321Ev
  virtual void  v322(); // _ZN5S28C24v322Ev
  S28C2(); // tgen
};
//SIG(-1 S28C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 FC12{ m Fi} Fi Fc[4] Fp[2] FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC8 FC8 FC8 FC13{ BC14{ BC11}} FC13 Fi Fp[2] FC15{ m Fi[3]} FC15 FC15 FC15 Fp FC8 FC13 FC15 FC15 Fi FC15 FC15 Fp Fi Fc FC15 FC15 Fp Fi Fp FC13 FC16{ BC17{ BC11}} FC16} vd v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC15 FC15 Fp[5] FC15 Fp FC18{ BC19{ BC11}} Fp[2] FC15 Fp Fi[2] Fp Fi FC15 FC15 FC15 Fp[2] Fi FC15 Fi[4] Fp[2] FC18 Fi FC15} vd v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC15 Fi FC15 Fp[5] FC15 Fi[12] FC20{ Fi Fc FC15 FC15 Fp FC15 Fc} FC21{ BC22{ BC23{ BC11}}}[2] Fi FC21 FC21 FC21 FC21 Fi FC15 Fp[4] FC15 Fp FC21 Fp FC24{ BC25{ BC11}} FC24 FC24 FC24 Fp FC26{ BC27{ m Fp[2]}} Fp Fi FC28{ BC29{ BC11}} Fi FC21[4] FC28 Fp FC30{ BC31{ BC11}} Fi[3] FC30 FC30 FC13 FC32{ BC33{ BC11}} Fi FC34{ m Fp FC8}} vd v298 v299 v300} vd v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc[6] FC15 Fp[2] Fi[2] FC21 Fp[3] FC35{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC36{ m} Fc Fi[2] FC15 Fi[3] Fi:1 Fi[4] FC15 FC15 FC15 Fi} Fp FC15 FC15 FC35 Fi Fp[3] FC15 FC15 FC15 FC15 Fi FC15 Fi[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] FC15 Fi Fp Fi[5] FC21 Fi Fp[4] FC21 FC32 Fp[2] FC13 Fi[5] Fp FC37{ BC38{ BC11}} Fi} vd v1 v2 Fp FC37 Fp}


 S28C2 ::~S28C2(){ note_dtor("S28C2", this);}
void  S28C2 ::v321(){vfunc_called(this, "_ZN5S28C24v321Ev");}
void  S28C2 ::v322(){vfunc_called(this, "_ZN5S28C24v322Ev");}
S28C2 ::S28C2(){ note_ctor("S28C2", this);} // tgen

static void Test_S28C2()
{
  extern Class_Descriptor cd_S28C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(316,482)];
    init_test(&cd_S28C2, buf);
    S28C2 *dp, &lv = *(dp=new (buf) S28C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2520,1924), "sizeof(S28C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C2)");
    check_base_class_offset(lv, (S28C8_nt*)(S28C7_nt*)(S28C6*)(S28C5*)(S28C4*)(S28C3*), 0, "S28C2");
    check_base_class_offset(lv, (S28C7_nt*)(S28C6*)(S28C5*)(S28C4*)(S28C3*), 0, "S28C2");
    check_base_class_offset(lv, (S28C6*)(S28C5*)(S28C4*)(S28C3*), 0, "S28C2");
    check_base_class_offset(lv, (S28C5*)(S28C4*)(S28C3*), 0, "S28C2");
    check_base_class_offset(lv, (S28C4*)(S28C3*), 0, "S28C2");
    check_base_class_offset(lv, (S28C3*), 0, "S28C2");
    check_field_offset(lv, s28c2f0, ABISELECT(2488,1904), "S28C2.s28c2f0");
    check_field_offset(lv, s28c2f1, ABISELECT(2496,1908), "S28C2.s28c2f1");
    check_field_offset(lv, s28c2f2, ABISELECT(2512,1920), "S28C2.s28c2f2");
    test_class_info(&lv, &cd_S28C2);
    dp->~S28C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C2(Test_S28C2, "S28C2", ABISELECT(2520,1924));

#else // __cplusplus

extern void _ZN5S28C2C1Ev();
extern void _ZN5S28C2D1Ev();
Name_Map name_map_S28C2[] = {
  NSPAIR(_ZN5S28C2C1Ev),
  NSPAIR(_ZN5S28C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S28C8_nt;
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
extern Class_Descriptor cd_S28C7_nt;
extern VTBL_ENTRY _ZTI8S28C7_nt[];
extern  VTBL_ENTRY _ZTV8S28C7_nt[];
extern Class_Descriptor cd_S28C6;
extern VTBL_ENTRY _ZTI5S28C6[];
extern  VTBL_ENTRY _ZTV5S28C6[];
extern Class_Descriptor cd_S28C5;
extern VTBL_ENTRY _ZTI5S28C5[];
extern  VTBL_ENTRY _ZTV5S28C5[];
extern Class_Descriptor cd_S28C4;
extern VTBL_ENTRY _ZTI5S28C4[];
extern  VTBL_ENTRY _ZTV5S28C4[];
extern Class_Descriptor cd_S28C3;
extern VTBL_ENTRY _ZTI5S28C3[];
extern  VTBL_ENTRY _ZTV5S28C3[];
static Base_Class bases_S28C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S28C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S28C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S28C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S28C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S28C2[];
extern void _ZN5S28C2D1Ev();
extern void _ZN5S28C2D0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
extern void _ZN8S28C7_nt3v68Ev();
extern void _ZN8S28C7_nt3v69Ev();
extern void _ZN8S28C7_nt3v70Ev();
extern void _ZN8S28C7_nt3v71Ev();
extern void _ZN8S28C7_nt3v72Ev();
extern void _ZN8S28C7_nt3v73Ev();
extern void _ZN8S28C7_nt3v74Ev();
extern void _ZN8S28C7_nt3v75Ev();
extern void _ZN8S28C7_nt3v76Ev();
extern void _ZN8S28C7_nt3v77Ev();
extern void _ZN8S28C7_nt3v78Ev();
extern void _ZN8S28C7_nt3v79Ev();
extern void _ZN8S28C7_nt3v80Ev();
extern void _ZN8S28C7_nt3v81Ev();
extern void _ZN8S28C7_nt3v82Ev();
extern void _ZN8S28C7_nt3v83Ev();
extern void _ZN8S28C7_nt3v84Ev();
extern void _ZN8S28C7_nt3v85Ev();
extern void _ZN8S28C7_nt3v86Ev();
extern void _ZN8S28C7_nt3v87Ev();
extern void _ZN8S28C7_nt3v88Ev();
extern void _ZN8S28C7_nt3v89Ev();
extern void _ZN8S28C7_nt3v90Ev();
extern void _ZN8S28C7_nt3v91Ev();
extern void _ZN8S28C7_nt3v92Ev();
extern void _ZN8S28C7_nt3v93Ev();
extern void _ZN8S28C7_nt3v94Ev();
extern void _ZN8S28C7_nt3v95Ev();
extern void _ZN8S28C7_nt3v96Ev();
extern void _ZN8S28C7_nt3v97Ev();
extern void _ZN8S28C7_nt3v98Ev();
extern void _ZN8S28C7_nt3v99Ev();
extern void _ZN8S28C7_nt4v100Ev();
extern void _ZN8S28C7_nt4v101Ev();
extern void _ZN8S28C7_nt4v102Ev();
extern void _ZN8S28C7_nt4v103Ev();
extern void _ZN8S28C7_nt4v104Ev();
extern void _ZN8S28C7_nt4v105Ev();
extern void _ZN8S28C7_nt4v106Ev();
extern void _ZN8S28C7_nt4v107Ev();
extern void _ZN8S28C7_nt4v108Ev();
extern void _ZN8S28C7_nt4v109Ev();
extern void _ZN8S28C7_nt4v110Ev();
extern void _ZN8S28C7_nt4v111Ev();
extern void _ZN8S28C7_nt4v112Ev();
extern void _ZN8S28C7_nt4v113Ev();
extern void _ZN8S28C7_nt4v114Ev();
extern void _ZN8S28C7_nt4v115Ev();
extern void _ZN8S28C7_nt4v116Ev();
extern void _ZN8S28C7_nt4v117Ev();
extern void _ZN8S28C7_nt4v118Ev();
extern void _ZN8S28C7_nt4v119Ev();
extern void _ZN8S28C7_nt4v120Ev();
extern void _ZN8S28C7_nt4v121Ev();
extern void _ZN8S28C7_nt4v122Ev();
extern void _ZN8S28C7_nt4v123Ev();
extern void _ZN8S28C7_nt4v124Ev();
extern void _ZN8S28C7_nt4v125Ev();
extern void _ZN8S28C7_nt4v126Ev();
extern void _ZN8S28C7_nt4v127Ev();
extern void _ZN8S28C7_nt4v128Ev();
extern void _ZN8S28C7_nt4v129Ev();
extern void _ZN8S28C7_nt4v130Ev();
extern void _ZN8S28C7_nt4v131Ev();
extern void _ZN8S28C7_nt4v132Ev();
extern void _ZN8S28C7_nt4v133Ev();
extern void _ZN8S28C7_nt4v134Ev();
extern void _ZN8S28C7_nt4v135Ev();
extern void _ZN8S28C7_nt4v136Ev();
extern void _ZN8S28C7_nt4v137Ev();
extern void _ZN8S28C7_nt4v138Ev();
extern void _ZN8S28C7_nt4v139Ev();
extern void _ZN8S28C7_nt4v140Ev();
extern void _ZN8S28C7_nt4v141Ev();
extern void _ZN8S28C7_nt4v142Ev();
extern void _ZN8S28C7_nt4v143Ev();
extern void _ZN8S28C7_nt4v144Ev();
extern void _ZN8S28C7_nt4v145Ev();
extern void _ZN8S28C7_nt4v146Ev();
extern void _ZN8S28C7_nt4v147Ev();
extern void _ZN8S28C7_nt4v148Ev();
extern void _ZN8S28C7_nt4v149Ev();
extern void _ZN8S28C7_nt4v150Ev();
extern void _ZN8S28C7_nt4v151Ev();
extern void _ZN8S28C7_nt4v152Ev();
extern void _ZN8S28C7_nt4v153Ev();
extern void _ZN8S28C7_nt4v154Ev();
extern void _ZN8S28C7_nt4v155Ev();
extern void _ZN8S28C7_nt4v156Ev();
extern void _ZN8S28C7_nt4v157Ev();
extern void _ZN8S28C7_nt4v158Ev();
extern void _ZN8S28C7_nt4v159Ev();
extern void _ZN8S28C7_nt4v160Ev();
extern void _ZN8S28C7_nt4v161Ev();
extern void _ZN8S28C7_nt4v162Ev();
extern void _ZN8S28C7_nt4v163Ev();
extern void _ZN8S28C7_nt4v164Ev();
extern void _ZN8S28C7_nt4v165Ev();
extern void _ZN8S28C7_nt4v166Ev();
extern void _ZN8S28C7_nt4v167Ev();
extern void _ZN8S28C7_nt4v168Ev();
extern void _ZN8S28C7_nt4v169Ev();
extern void _ZN8S28C7_nt4v170Ev();
extern void _ZN8S28C7_nt4v171Ev();
extern void _ZN8S28C7_nt4v172Ev();
extern void _ZN8S28C7_nt4v173Ev();
extern void _ZN8S28C7_nt4v174Ev();
extern void _ZN8S28C7_nt4v175Ev();
extern void _ZN8S28C7_nt4v176Ev();
extern void _ZN8S28C7_nt4v177Ev();
extern void _ZN8S28C7_nt4v178Ev();
extern void _ZN8S28C7_nt4v179Ev();
extern void _ZN8S28C7_nt4v180Ev();
extern void _ZN8S28C7_nt4v181Ev();
extern void _ZN8S28C7_nt4v182Ev();
extern void _ZN8S28C7_nt4v183Ev();
extern void _ZN8S28C7_nt4v184Ev();
extern void _ZN8S28C7_nt4v185Ev();
extern void _ZN8S28C7_nt4v186Ev();
extern void _ZN8S28C7_nt4v187Ev();
extern void _ZN8S28C7_nt4v188Ev();
extern void _ZN8S28C7_nt4v189Ev();
extern void _ZN8S28C7_nt4v190Ev();
extern void _ZN8S28C7_nt4v191Ev();
extern void _ZN8S28C7_nt4v192Ev();
extern void _ZN8S28C7_nt4v193Ev();
extern void _ZN8S28C7_nt4v194Ev();
extern void _ZN8S28C7_nt4v195Ev();
extern void _ZN8S28C7_nt4v196Ev();
extern void _ZN8S28C7_nt4v197Ev();
extern void _ZN8S28C7_nt4v198Ev();
extern void _ZN8S28C7_nt4v199Ev();
extern void _ZN8S28C7_nt4v200Ev();
extern void _ZN8S28C7_nt4v201Ev();
extern void _ZN8S28C7_nt4v202Ev();
extern void _ZN8S28C7_nt4v203Ev();
extern void _ZN8S28C7_nt4v204Ev();
extern void _ZN8S28C7_nt4v205Ev();
extern void _ZN8S28C7_nt4v206Ev();
extern void _ZN8S28C7_nt4v207Ev();
extern void _ZN8S28C7_nt4v208Ev();
extern void _ZN8S28C7_nt4v209Ev();
extern void _ZN8S28C7_nt4v210Ev();
extern void _ZN5S28C64v211Ev();
extern void _ZN5S28C64v212Ev();
extern void _ZN5S28C64v213Ev();
extern void _ZN5S28C64v214Ev();
extern void _ZN5S28C64v215Ev();
extern void _ZN5S28C64v216Ev();
extern void _ZN5S28C64v217Ev();
extern void _ZN5S28C64v218Ev();
extern void _ZN5S28C64v219Ev();
extern void _ZN5S28C64v220Ev();
extern void _ZN5S28C64v221Ev();
extern void _ZN5S28C64v222Ev();
extern void _ZN5S28C64v223Ev();
extern void _ZN5S28C64v224Ev();
extern void _ZN5S28C64v225Ev();
extern void _ZN5S28C64v226Ev();
extern void _ZN5S28C64v227Ev();
extern void _ZN5S28C64v228Ev();
extern void _ZN5S28C64v229Ev();
extern void _ZN5S28C64v230Ev();
extern void _ZN5S28C64v231Ev();
extern void _ZN5S28C64v232Ev();
extern void _ZN5S28C64v233Ev();
extern void _ZN5S28C64v234Ev();
extern void _ZN5S28C64v235Ev();
extern void _ZN5S28C64v236Ev();
extern void _ZN5S28C64v237Ev();
extern void _ZN5S28C64v238Ev();
extern void _ZN5S28C64v239Ev();
extern void _ZN5S28C64v240Ev();
extern void _ZN5S28C64v241Ev();
extern void _ZN5S28C64v242Ev();
extern void _ZN5S28C64v243Ev();
extern void _ZN5S28C64v244Ev();
extern void _ZN5S28C64v245Ev();
extern void _ZN5S28C64v246Ev();
extern void _ZN5S28C64v247Ev();
extern void _ZN5S28C64v248Ev();
extern void _ZN5S28C64v249Ev();
extern void _ZN5S28C64v250Ev();
extern void _ZN5S28C64v251Ev();
extern void _ZN5S28C64v252Ev();
extern void _ZN5S28C64v253Ev();
extern void _ZN5S28C64v254Ev();
extern void _ZN5S28C64v255Ev();
extern void _ZN5S28C64v256Ev();
extern void _ZN5S28C64v257Ev();
extern void _ZN5S28C64v258Ev();
extern void _ZN5S28C64v259Ev();
extern void _ZN5S28C64v260Ev();
extern void _ZN5S28C54v261Ev();
extern void _ZN5S28C54v262Ev();
extern void _ZN5S28C54v263Ev();
extern void _ZN5S28C54v264Ev();
extern void _ZN5S28C54v265Ev();
extern void _ZN5S28C54v266Ev();
extern void _ZN5S28C54v267Ev();
extern void _ZN5S28C54v268Ev();
extern void _ZN5S28C54v269Ev();
extern void _ZN5S28C54v270Ev();
extern void _ZN5S28C54v271Ev();
extern void _ZN5S28C54v272Ev();
extern void _ZN5S28C54v273Ev();
extern void _ZN5S28C54v274Ev();
extern void _ZN5S28C54v275Ev();
extern void _ZN5S28C54v276Ev();
extern void _ZN5S28C54v277Ev();
extern void _ZN5S28C54v278Ev();
extern void _ZN5S28C54v279Ev();
extern void _ZN5S28C54v280Ev();
extern void _ZN5S28C54v281Ev();
extern void _ZN5S28C54v282Ev();
extern void _ZN5S28C54v283Ev();
extern void _ZN5S28C54v284Ev();
extern void _ZN5S28C54v285Ev();
extern void _ZN5S28C54v286Ev();
extern void _ZN5S28C54v287Ev();
extern void _ZN5S28C54v288Ev();
extern void _ZN5S28C54v289Ev();
extern void _ZN5S28C54v290Ev();
extern void _ZN5S28C54v291Ev();
extern void _ZN5S28C54v292Ev();
extern void _ZN5S28C54v293Ev();
extern void _ZN5S28C54v294Ev();
extern void _ZN5S28C54v295Ev();
extern void _ZN5S28C54v296Ev();
extern void _ZN5S28C54v297Ev();
extern void _ZN5S28C54v298Ev();
extern void _ZN5S28C44v299Ev();
extern void _ZN5S28C44v300Ev();
extern void _ZN5S28C44v301Ev();
extern void _ZN5S28C34v302Ev();
extern void _ZN5S28C34v303Ev();
extern void _ZN5S28C34v304Ev();
extern void _ZN5S28C34v305Ev();
extern void _ZN5S28C34v306Ev();
extern void _ZN5S28C34v307Ev();
extern void _ZN5S28C34v308Ev();
extern void _ZN5S28C34v309Ev();
extern void _ZN5S28C34v310Ev();
extern void _ZN5S28C34v311Ev();
extern void _ZN5S28C34v312Ev();
extern void _ZN5S28C34v313Ev();
extern void _ZN5S28C34v314Ev();
extern void _ZN5S28C34v315Ev();
extern void _ZN5S28C34v316Ev();
extern void _ZN5S28C34v317Ev();
extern void _ZN5S28C34v318Ev();
extern void _ZN5S28C34v319Ev();
extern void _ZN5S28C34v320Ev();
extern void _ZN5S28C24v321Ev();
extern void _ZN5S28C24v322Ev();
static  VTBL_ENTRY vtc_S28C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S28C2[0]),
  (VTBL_ENTRY)&_ZN5S28C2D1Ev,
  (VTBL_ENTRY)&_ZN5S28C2D0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN5S28C64v211Ev,
  (VTBL_ENTRY)&_ZN5S28C64v212Ev,
  (VTBL_ENTRY)&_ZN5S28C64v213Ev,
  (VTBL_ENTRY)&_ZN5S28C64v214Ev,
  (VTBL_ENTRY)&_ZN5S28C64v215Ev,
  (VTBL_ENTRY)&_ZN5S28C64v216Ev,
  (VTBL_ENTRY)&_ZN5S28C64v217Ev,
  (VTBL_ENTRY)&_ZN5S28C64v218Ev,
  (VTBL_ENTRY)&_ZN5S28C64v219Ev,
  (VTBL_ENTRY)&_ZN5S28C64v220Ev,
  (VTBL_ENTRY)&_ZN5S28C64v221Ev,
  (VTBL_ENTRY)&_ZN5S28C64v222Ev,
  (VTBL_ENTRY)&_ZN5S28C64v223Ev,
  (VTBL_ENTRY)&_ZN5S28C64v224Ev,
  (VTBL_ENTRY)&_ZN5S28C64v225Ev,
  (VTBL_ENTRY)&_ZN5S28C64v226Ev,
  (VTBL_ENTRY)&_ZN5S28C64v227Ev,
  (VTBL_ENTRY)&_ZN5S28C64v228Ev,
  (VTBL_ENTRY)&_ZN5S28C64v229Ev,
  (VTBL_ENTRY)&_ZN5S28C64v230Ev,
  (VTBL_ENTRY)&_ZN5S28C64v231Ev,
  (VTBL_ENTRY)&_ZN5S28C64v232Ev,
  (VTBL_ENTRY)&_ZN5S28C64v233Ev,
  (VTBL_ENTRY)&_ZN5S28C64v234Ev,
  (VTBL_ENTRY)&_ZN5S28C64v235Ev,
  (VTBL_ENTRY)&_ZN5S28C64v236Ev,
  (VTBL_ENTRY)&_ZN5S28C64v237Ev,
  (VTBL_ENTRY)&_ZN5S28C64v238Ev,
  (VTBL_ENTRY)&_ZN5S28C64v239Ev,
  (VTBL_ENTRY)&_ZN5S28C64v240Ev,
  (VTBL_ENTRY)&_ZN5S28C64v241Ev,
  (VTBL_ENTRY)&_ZN5S28C64v242Ev,
  (VTBL_ENTRY)&_ZN5S28C64v243Ev,
  (VTBL_ENTRY)&_ZN5S28C64v244Ev,
  (VTBL_ENTRY)&_ZN5S28C64v245Ev,
  (VTBL_ENTRY)&_ZN5S28C64v246Ev,
  (VTBL_ENTRY)&_ZN5S28C64v247Ev,
  (VTBL_ENTRY)&_ZN5S28C64v248Ev,
  (VTBL_ENTRY)&_ZN5S28C64v249Ev,
  (VTBL_ENTRY)&_ZN5S28C64v250Ev,
  (VTBL_ENTRY)&_ZN5S28C64v251Ev,
  (VTBL_ENTRY)&_ZN5S28C64v252Ev,
  (VTBL_ENTRY)&_ZN5S28C64v253Ev,
  (VTBL_ENTRY)&_ZN5S28C64v254Ev,
  (VTBL_ENTRY)&_ZN5S28C64v255Ev,
  (VTBL_ENTRY)&_ZN5S28C64v256Ev,
  (VTBL_ENTRY)&_ZN5S28C64v257Ev,
  (VTBL_ENTRY)&_ZN5S28C64v258Ev,
  (VTBL_ENTRY)&_ZN5S28C64v259Ev,
  (VTBL_ENTRY)&_ZN5S28C64v260Ev,
  (VTBL_ENTRY)&_ZN5S28C54v261Ev,
  (VTBL_ENTRY)&_ZN5S28C54v262Ev,
  (VTBL_ENTRY)&_ZN5S28C54v263Ev,
  (VTBL_ENTRY)&_ZN5S28C54v264Ev,
  (VTBL_ENTRY)&_ZN5S28C54v265Ev,
  (VTBL_ENTRY)&_ZN5S28C54v266Ev,
  (VTBL_ENTRY)&_ZN5S28C54v267Ev,
  (VTBL_ENTRY)&_ZN5S28C54v268Ev,
  (VTBL_ENTRY)&_ZN5S28C54v269Ev,
  (VTBL_ENTRY)&_ZN5S28C54v270Ev,
  (VTBL_ENTRY)&_ZN5S28C54v271Ev,
  (VTBL_ENTRY)&_ZN5S28C54v272Ev,
  (VTBL_ENTRY)&_ZN5S28C54v273Ev,
  (VTBL_ENTRY)&_ZN5S28C54v274Ev,
  (VTBL_ENTRY)&_ZN5S28C54v275Ev,
  (VTBL_ENTRY)&_ZN5S28C54v276Ev,
  (VTBL_ENTRY)&_ZN5S28C54v277Ev,
  (VTBL_ENTRY)&_ZN5S28C54v278Ev,
  (VTBL_ENTRY)&_ZN5S28C54v279Ev,
  (VTBL_ENTRY)&_ZN5S28C54v280Ev,
  (VTBL_ENTRY)&_ZN5S28C54v281Ev,
  (VTBL_ENTRY)&_ZN5S28C54v282Ev,
  (VTBL_ENTRY)&_ZN5S28C54v283Ev,
  (VTBL_ENTRY)&_ZN5S28C54v284Ev,
  (VTBL_ENTRY)&_ZN5S28C54v285Ev,
  (VTBL_ENTRY)&_ZN5S28C54v286Ev,
  (VTBL_ENTRY)&_ZN5S28C54v287Ev,
  (VTBL_ENTRY)&_ZN5S28C54v288Ev,
  (VTBL_ENTRY)&_ZN5S28C54v289Ev,
  (VTBL_ENTRY)&_ZN5S28C54v290Ev,
  (VTBL_ENTRY)&_ZN5S28C54v291Ev,
  (VTBL_ENTRY)&_ZN5S28C54v292Ev,
  (VTBL_ENTRY)&_ZN5S28C54v293Ev,
  (VTBL_ENTRY)&_ZN5S28C54v294Ev,
  (VTBL_ENTRY)&_ZN5S28C54v295Ev,
  (VTBL_ENTRY)&_ZN5S28C54v296Ev,
  (VTBL_ENTRY)&_ZN5S28C54v297Ev,
  (VTBL_ENTRY)&_ZN5S28C54v298Ev,
  (VTBL_ENTRY)&_ZN5S28C44v299Ev,
  (VTBL_ENTRY)&_ZN5S28C44v300Ev,
  (VTBL_ENTRY)&_ZN5S28C44v301Ev,
  (VTBL_ENTRY)&_ZN5S28C34v302Ev,
  (VTBL_ENTRY)&_ZN5S28C34v303Ev,
  (VTBL_ENTRY)&_ZN5S28C34v304Ev,
  (VTBL_ENTRY)&_ZN5S28C34v305Ev,
  (VTBL_ENTRY)&_ZN5S28C34v306Ev,
  (VTBL_ENTRY)&_ZN5S28C34v307Ev,
  (VTBL_ENTRY)&_ZN5S28C34v308Ev,
  (VTBL_ENTRY)&_ZN5S28C34v309Ev,
  (VTBL_ENTRY)&_ZN5S28C34v310Ev,
  (VTBL_ENTRY)&_ZN5S28C34v311Ev,
  (VTBL_ENTRY)&_ZN5S28C34v312Ev,
  (VTBL_ENTRY)&_ZN5S28C34v313Ev,
  (VTBL_ENTRY)&_ZN5S28C34v314Ev,
  (VTBL_ENTRY)&_ZN5S28C34v315Ev,
  (VTBL_ENTRY)&_ZN5S28C34v316Ev,
  (VTBL_ENTRY)&_ZN5S28C34v317Ev,
  (VTBL_ENTRY)&_ZN5S28C34v318Ev,
  (VTBL_ENTRY)&_ZN5S28C34v319Ev,
  (VTBL_ENTRY)&_ZN5S28C34v320Ev,
  (VTBL_ENTRY)&_ZN5S28C24v321Ev,
  (VTBL_ENTRY)&_ZN5S28C24v322Ev,
};
extern VTBL_ENTRY _ZTI5S28C2[];
extern  VTBL_ENTRY _ZTV5S28C2[];
Class_Descriptor cd_S28C2 = {  "S28C2", // class name
  bases_S28C2, 6,
  &(vtc_S28C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2520,1924), // object size
  NSPAIRA(_ZTI5S28C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S28C2),323, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C59  {
  ::S28C9_nt s28c59f0;
  void *s28c59f1;
  int s28c59f2;
};
//SIG(-1 S28C59) C1{ FC2{ m Fi[2]} Fp Fi}



static void Test_S28C59()
{
  {
    init_simple_test("S28C59");
    S28C59 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S28C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C59)");
    check_field_offset(lv, s28c59f0, 0, "S28C59.s28c59f0");
    check_field_offset(lv, s28c59f1, 8, "S28C59.s28c59f1");
    check_field_offset(lv, s28c59f2, ABISELECT(16,12), "S28C59.s28c59f2");
  }
}
static Arrange_To_Call_Me vS28C59(Test_S28C59, "S28C59", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S28C1  : S28C2 {
  char s28c1f0;
  ::S28C18_nt s28c1f1;
  ::S28C18_nt s28c1f2;
  ::S28C59 s28c1f3;
  ::S28C59 s28c1f4;
  ::S28C59 s28c1f5;
  ::S28C18_nt s28c1f6;
  ::S28C18_nt s28c1f7;
  unsigned int s28c1f8:1;
  unsigned int s28c1f9:1;
  unsigned int s28c1f10:1;
  unsigned int s28c1f11:1;
  int s28c1f12[7];
  virtual  ~S28C1(); // _ZN5S28C1D1Ev
  virtual void  v1(); // _ZN5S28C12v1Ev
  virtual void  v2(); // _ZN5S28C12v2Ev
  virtual void  v3(); // _ZN5S28C12v3Ev
  S28C1(); // tgen
};
//SIG(1 S28C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ BC8{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC9{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC10 FC13{ m Fi} Fi Fc[4] Fp[2] FC10 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC9 FC9 FC9 FC14{ BC15{ BC12}} FC14 Fi Fp[2] FC16{ m Fi[3]} FC16 FC16 FC16 Fp FC9 FC14 FC16 FC16 Fi FC16 FC16 Fp Fi Fc FC16 FC16 Fp Fi Fp FC14 FC17{ BC18{ BC12}} FC17} vd v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC16 FC16 Fp[5] FC16 Fp FC19{ BC20{ BC12}} Fp[2] FC16 Fp Fi[2] Fp Fi FC16 FC16 FC16 Fp[2] Fi FC16 Fi[4] Fp[2] FC19 Fi FC16} vd v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC16 Fi FC16 Fp[5] FC16 Fi[12] FC21{ Fi Fc FC16 FC16 Fp FC16 Fc} FC22{ BC23{ BC24{ BC12}}}[2] Fi FC22 FC22 FC22 FC22 Fi FC16 Fp[4] FC16 Fp FC22 Fp FC25{ BC26{ BC12}} FC25 FC25 FC25 Fp FC27{ BC28{ m Fp[2]}} Fp Fi FC29{ BC30{ BC12}} Fi FC22[4] FC29 Fp FC31{ BC32{ BC12}} Fi[3] FC31 FC31 FC14 FC33{ BC34{ BC12}} Fi FC35{ m Fp FC9}} vd v299 v300 v301} vd v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc[6] FC16 Fp[2] Fi[2] FC22 Fp[3] FC36{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC37{ m} Fc Fi[2] FC16 Fi[3] Fi:1 Fi[4] FC16 FC16 FC16 Fi} Fp FC16 FC16 FC36 Fi Fp[3] FC16 FC16 FC16 FC16 Fi FC16 Fi[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] FC16 Fi Fp Fi[5] FC22 Fi Fp[4] FC22 FC33 Fp[2] FC14 Fi[5] Fp FC38{ BC39{ BC12}} Fi} vd v321 v322 Fp FC38 Fp} vd v1 v2 v3 Fc FC16 FC16 FC40{ FC9 Fp Fi} FC40 FC40 FC16 FC16 Fi:1 Fi:1 Fi:1 Fi:1 Fi[7]}


 S28C1 ::~S28C1(){ note_dtor("S28C1", this);}
void  S28C1 ::v1(){vfunc_called(this, "_ZN5S28C12v1Ev");}
void  S28C1 ::v2(){vfunc_called(this, "_ZN5S28C12v2Ev");}
void  S28C1 ::v3(){vfunc_called(this, "_ZN5S28C12v3Ev");}
S28C1 ::S28C1(){ note_ctor("S28C1", this);} // tgen

static void Test_S28C1()
{
  extern Class_Descriptor cd_S28C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(336,515)];
    init_test(&cd_S28C1, buf);
    S28C1 *dp, &lv = *(dp=new (buf) S28C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2680,2056), "sizeof(S28C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S28C1)");
    check_base_class_offset(lv, (S28C8_nt*)(S28C7_nt*)(S28C6*)(S28C5*)(S28C4*)(S28C3*)(S28C2*), 0, "S28C1");
    check_base_class_offset(lv, (S28C7_nt*)(S28C6*)(S28C5*)(S28C4*)(S28C3*)(S28C2*), 0, "S28C1");
    check_base_class_offset(lv, (S28C6*)(S28C5*)(S28C4*)(S28C3*)(S28C2*), 0, "S28C1");
    check_base_class_offset(lv, (S28C5*)(S28C4*)(S28C3*)(S28C2*), 0, "S28C1");
    check_base_class_offset(lv, (S28C4*)(S28C3*)(S28C2*), 0, "S28C1");
    check_base_class_offset(lv, (S28C3*)(S28C2*), 0, "S28C1");
    check_base_class_offset(lv, (S28C2*), 0, "S28C1");
    check_field_offset(lv, s28c1f0, ABISELECT(2520,1924), "S28C1.s28c1f0");
    check_field_offset(lv, s28c1f1, ABISELECT(2524,1928), "S28C1.s28c1f1");
    check_field_offset(lv, s28c1f2, ABISELECT(2536,1940), "S28C1.s28c1f2");
    check_field_offset(lv, s28c1f3, ABISELECT(2552,1952), "S28C1.s28c1f3");
    check_field_offset(lv, s28c1f4, ABISELECT(2576,1968), "S28C1.s28c1f4");
    check_field_offset(lv, s28c1f5, ABISELECT(2600,1984), "S28C1.s28c1f5");
    check_field_offset(lv, s28c1f6, ABISELECT(2624,2000), "S28C1.s28c1f6");
    check_field_offset(lv, s28c1f7, ABISELECT(2636,2012), "S28C1.s28c1f7");
    set_bf_and_test(lv, s28c1f8, ABISELECT(2648,2024), 0, 1, 1, "S28C1");
    set_bf_and_test(lv, s28c1f9, ABISELECT(2648,2024), 1, 1, 1, "S28C1");
    set_bf_and_test(lv, s28c1f10, ABISELECT(2648,2024), 2, 1, 1, "S28C1");
    set_bf_and_test(lv, s28c1f11, ABISELECT(2648,2024), 3, 1, 1, "S28C1");
    check_field_offset(lv, s28c1f12, ABISELECT(2652,2028), "S28C1.s28c1f12");
    test_class_info(&lv, &cd_S28C1);
    dp->~S28C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS28C1(Test_S28C1, "S28C1", ABISELECT(2680,2056));

#else // __cplusplus

extern void _ZN5S28C1C1Ev();
extern void _ZN5S28C1D1Ev();
Name_Map name_map_S28C1[] = {
  NSPAIR(_ZN5S28C1C1Ev),
  NSPAIR(_ZN5S28C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S28C8_nt;
extern VTBL_ENTRY _ZTI8S28C8_nt[];
extern  VTBL_ENTRY _ZTV8S28C8_nt[];
extern Class_Descriptor cd_S28C7_nt;
extern VTBL_ENTRY _ZTI8S28C7_nt[];
extern  VTBL_ENTRY _ZTV8S28C7_nt[];
extern Class_Descriptor cd_S28C6;
extern VTBL_ENTRY _ZTI5S28C6[];
extern  VTBL_ENTRY _ZTV5S28C6[];
extern Class_Descriptor cd_S28C5;
extern VTBL_ENTRY _ZTI5S28C5[];
extern  VTBL_ENTRY _ZTV5S28C5[];
extern Class_Descriptor cd_S28C4;
extern VTBL_ENTRY _ZTI5S28C4[];
extern  VTBL_ENTRY _ZTV5S28C4[];
extern Class_Descriptor cd_S28C3;
extern VTBL_ENTRY _ZTI5S28C3[];
extern  VTBL_ENTRY _ZTV5S28C3[];
extern Class_Descriptor cd_S28C2;
extern VTBL_ENTRY _ZTI5S28C2[];
extern  VTBL_ENTRY _ZTV5S28C2[];
static Base_Class bases_S28C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S28C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S28C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S28C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S28C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S28C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S28C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S28C1[];
extern void _ZN5S28C1D1Ev();
extern void _ZN5S28C1D0Ev();
extern void _ZN8S28C8_nt2v4Ev();
extern void _ZN8S28C8_nt2v5Ev();
extern void _ZN8S28C8_nt2v6Ev();
extern void _ZN8S28C8_nt2v7Ev();
extern void _ZN8S28C8_nt2v8Ev();
extern void _ZN8S28C8_nt2v9Ev();
extern void _ZN8S28C8_nt3v10Ev();
extern void _ZN8S28C8_nt3v11Ev();
extern void _ZN8S28C8_nt3v12Ev();
extern void _ZN8S28C8_nt3v13Ev();
extern void _ZN8S28C8_nt3v14Ev();
extern void _ZN8S28C8_nt3v15Ev();
extern void _ZN8S28C8_nt3v16Ev();
extern void _ZN8S28C8_nt3v17Ev();
extern void _ZN8S28C8_nt3v18Ev();
extern void _ZN8S28C8_nt3v19Ev();
extern void _ZN8S28C8_nt3v20Ev();
extern void _ZN8S28C8_nt3v21Ev();
extern void _ZN8S28C8_nt3v22Ev();
extern void _ZN8S28C8_nt3v23Ev();
extern void _ZN8S28C8_nt3v24Ev();
extern void _ZN8S28C8_nt3v25Ev();
extern void _ZN8S28C8_nt3v26Ev();
extern void _ZN8S28C8_nt3v27Ev();
extern void _ZN8S28C8_nt3v28Ev();
extern void _ZN8S28C8_nt3v29Ev();
extern void _ZN8S28C8_nt3v30Ev();
extern void _ZN8S28C8_nt3v31Ev();
extern void _ZN8S28C8_nt3v32Ev();
extern void _ZN8S28C8_nt3v33Ev();
extern void _ZN8S28C8_nt3v34Ev();
extern void _ZN8S28C8_nt3v35Ev();
extern void _ZN8S28C8_nt3v36Ev();
extern void _ZN8S28C8_nt3v37Ev();
extern void _ZN8S28C8_nt3v38Ev();
extern void _ZN8S28C8_nt3v39Ev();
extern void _ZN8S28C8_nt3v40Ev();
extern void _ZN8S28C8_nt3v41Ev();
extern void _ZN8S28C8_nt3v42Ev();
extern void _ZN8S28C8_nt3v43Ev();
extern void _ZN8S28C8_nt3v44Ev();
extern void _ZN8S28C8_nt3v45Ev();
extern void _ZN8S28C8_nt3v46Ev();
extern void _ZN8S28C8_nt3v47Ev();
extern void _ZN8S28C8_nt3v48Ev();
extern void _ZN8S28C8_nt3v49Ev();
extern void _ZN8S28C8_nt3v50Ev();
extern void _ZN8S28C8_nt3v51Ev();
extern void _ZN8S28C8_nt3v52Ev();
extern void _ZN8S28C8_nt3v53Ev();
extern void _ZN8S28C8_nt3v54Ev();
extern void _ZN8S28C8_nt3v55Ev();
extern void _ZN8S28C8_nt3v56Ev();
extern void _ZN8S28C8_nt3v57Ev();
extern void _ZN8S28C8_nt3v58Ev();
extern void _ZN8S28C8_nt3v59Ev();
extern void _ZN8S28C8_nt3v60Ev();
extern void _ZN8S28C8_nt3v61Ev();
extern void _ZN8S28C8_nt3v62Ev();
extern void _ZN8S28C8_nt3v63Ev();
extern void _ZN8S28C8_nt3v64Ev();
extern void _ZN8S28C8_nt3v65Ev();
extern void _ZN8S28C8_nt3v66Ev();
extern void _ZN8S28C8_nt3v67Ev();
extern void _ZN8S28C7_nt3v68Ev();
extern void _ZN8S28C7_nt3v69Ev();
extern void _ZN8S28C7_nt3v70Ev();
extern void _ZN8S28C7_nt3v71Ev();
extern void _ZN8S28C7_nt3v72Ev();
extern void _ZN8S28C7_nt3v73Ev();
extern void _ZN8S28C7_nt3v74Ev();
extern void _ZN8S28C7_nt3v75Ev();
extern void _ZN8S28C7_nt3v76Ev();
extern void _ZN8S28C7_nt3v77Ev();
extern void _ZN8S28C7_nt3v78Ev();
extern void _ZN8S28C7_nt3v79Ev();
extern void _ZN8S28C7_nt3v80Ev();
extern void _ZN8S28C7_nt3v81Ev();
extern void _ZN8S28C7_nt3v82Ev();
extern void _ZN8S28C7_nt3v83Ev();
extern void _ZN8S28C7_nt3v84Ev();
extern void _ZN8S28C7_nt3v85Ev();
extern void _ZN8S28C7_nt3v86Ev();
extern void _ZN8S28C7_nt3v87Ev();
extern void _ZN8S28C7_nt3v88Ev();
extern void _ZN8S28C7_nt3v89Ev();
extern void _ZN8S28C7_nt3v90Ev();
extern void _ZN8S28C7_nt3v91Ev();
extern void _ZN8S28C7_nt3v92Ev();
extern void _ZN8S28C7_nt3v93Ev();
extern void _ZN8S28C7_nt3v94Ev();
extern void _ZN8S28C7_nt3v95Ev();
extern void _ZN8S28C7_nt3v96Ev();
extern void _ZN8S28C7_nt3v97Ev();
extern void _ZN8S28C7_nt3v98Ev();
extern void _ZN8S28C7_nt3v99Ev();
extern void _ZN8S28C7_nt4v100Ev();
extern void _ZN8S28C7_nt4v101Ev();
extern void _ZN8S28C7_nt4v102Ev();
extern void _ZN8S28C7_nt4v103Ev();
extern void _ZN8S28C7_nt4v104Ev();
extern void _ZN8S28C7_nt4v105Ev();
extern void _ZN8S28C7_nt4v106Ev();
extern void _ZN8S28C7_nt4v107Ev();
extern void _ZN8S28C7_nt4v108Ev();
extern void _ZN8S28C7_nt4v109Ev();
extern void _ZN8S28C7_nt4v110Ev();
extern void _ZN8S28C7_nt4v111Ev();
extern void _ZN8S28C7_nt4v112Ev();
extern void _ZN8S28C7_nt4v113Ev();
extern void _ZN8S28C7_nt4v114Ev();
extern void _ZN8S28C7_nt4v115Ev();
extern void _ZN8S28C7_nt4v116Ev();
extern void _ZN8S28C7_nt4v117Ev();
extern void _ZN8S28C7_nt4v118Ev();
extern void _ZN8S28C7_nt4v119Ev();
extern void _ZN8S28C7_nt4v120Ev();
extern void _ZN8S28C7_nt4v121Ev();
extern void _ZN8S28C7_nt4v122Ev();
extern void _ZN8S28C7_nt4v123Ev();
extern void _ZN8S28C7_nt4v124Ev();
extern void _ZN8S28C7_nt4v125Ev();
extern void _ZN8S28C7_nt4v126Ev();
extern void _ZN8S28C7_nt4v127Ev();
extern void _ZN8S28C7_nt4v128Ev();
extern void _ZN8S28C7_nt4v129Ev();
extern void _ZN8S28C7_nt4v130Ev();
extern void _ZN8S28C7_nt4v131Ev();
extern void _ZN8S28C7_nt4v132Ev();
extern void _ZN8S28C7_nt4v133Ev();
extern void _ZN8S28C7_nt4v134Ev();
extern void _ZN8S28C7_nt4v135Ev();
extern void _ZN8S28C7_nt4v136Ev();
extern void _ZN8S28C7_nt4v137Ev();
extern void _ZN8S28C7_nt4v138Ev();
extern void _ZN8S28C7_nt4v139Ev();
extern void _ZN8S28C7_nt4v140Ev();
extern void _ZN8S28C7_nt4v141Ev();
extern void _ZN8S28C7_nt4v142Ev();
extern void _ZN8S28C7_nt4v143Ev();
extern void _ZN8S28C7_nt4v144Ev();
extern void _ZN8S28C7_nt4v145Ev();
extern void _ZN8S28C7_nt4v146Ev();
extern void _ZN8S28C7_nt4v147Ev();
extern void _ZN8S28C7_nt4v148Ev();
extern void _ZN8S28C7_nt4v149Ev();
extern void _ZN8S28C7_nt4v150Ev();
extern void _ZN8S28C7_nt4v151Ev();
extern void _ZN8S28C7_nt4v152Ev();
extern void _ZN8S28C7_nt4v153Ev();
extern void _ZN8S28C7_nt4v154Ev();
extern void _ZN8S28C7_nt4v155Ev();
extern void _ZN8S28C7_nt4v156Ev();
extern void _ZN8S28C7_nt4v157Ev();
extern void _ZN8S28C7_nt4v158Ev();
extern void _ZN8S28C7_nt4v159Ev();
extern void _ZN8S28C7_nt4v160Ev();
extern void _ZN8S28C7_nt4v161Ev();
extern void _ZN8S28C7_nt4v162Ev();
extern void _ZN8S28C7_nt4v163Ev();
extern void _ZN8S28C7_nt4v164Ev();
extern void _ZN8S28C7_nt4v165Ev();
extern void _ZN8S28C7_nt4v166Ev();
extern void _ZN8S28C7_nt4v167Ev();
extern void _ZN8S28C7_nt4v168Ev();
extern void _ZN8S28C7_nt4v169Ev();
extern void _ZN8S28C7_nt4v170Ev();
extern void _ZN8S28C7_nt4v171Ev();
extern void _ZN8S28C7_nt4v172Ev();
extern void _ZN8S28C7_nt4v173Ev();
extern void _ZN8S28C7_nt4v174Ev();
extern void _ZN8S28C7_nt4v175Ev();
extern void _ZN8S28C7_nt4v176Ev();
extern void _ZN8S28C7_nt4v177Ev();
extern void _ZN8S28C7_nt4v178Ev();
extern void _ZN8S28C7_nt4v179Ev();
extern void _ZN8S28C7_nt4v180Ev();
extern void _ZN8S28C7_nt4v181Ev();
extern void _ZN8S28C7_nt4v182Ev();
extern void _ZN8S28C7_nt4v183Ev();
extern void _ZN8S28C7_nt4v184Ev();
extern void _ZN8S28C7_nt4v185Ev();
extern void _ZN8S28C7_nt4v186Ev();
extern void _ZN8S28C7_nt4v187Ev();
extern void _ZN8S28C7_nt4v188Ev();
extern void _ZN8S28C7_nt4v189Ev();
extern void _ZN8S28C7_nt4v190Ev();
extern void _ZN8S28C7_nt4v191Ev();
extern void _ZN8S28C7_nt4v192Ev();
extern void _ZN8S28C7_nt4v193Ev();
extern void _ZN8S28C7_nt4v194Ev();
extern void _ZN8S28C7_nt4v195Ev();
extern void _ZN8S28C7_nt4v196Ev();
extern void _ZN8S28C7_nt4v197Ev();
extern void _ZN8S28C7_nt4v198Ev();
extern void _ZN8S28C7_nt4v199Ev();
extern void _ZN8S28C7_nt4v200Ev();
extern void _ZN8S28C7_nt4v201Ev();
extern void _ZN8S28C7_nt4v202Ev();
extern void _ZN8S28C7_nt4v203Ev();
extern void _ZN8S28C7_nt4v204Ev();
extern void _ZN8S28C7_nt4v205Ev();
extern void _ZN8S28C7_nt4v206Ev();
extern void _ZN8S28C7_nt4v207Ev();
extern void _ZN8S28C7_nt4v208Ev();
extern void _ZN8S28C7_nt4v209Ev();
extern void _ZN8S28C7_nt4v210Ev();
extern void _ZN5S28C64v211Ev();
extern void _ZN5S28C64v212Ev();
extern void _ZN5S28C64v213Ev();
extern void _ZN5S28C64v214Ev();
extern void _ZN5S28C64v215Ev();
extern void _ZN5S28C64v216Ev();
extern void _ZN5S28C64v217Ev();
extern void _ZN5S28C64v218Ev();
extern void _ZN5S28C64v219Ev();
extern void _ZN5S28C64v220Ev();
extern void _ZN5S28C64v221Ev();
extern void _ZN5S28C64v222Ev();
extern void _ZN5S28C64v223Ev();
extern void _ZN5S28C64v224Ev();
extern void _ZN5S28C64v225Ev();
extern void _ZN5S28C64v226Ev();
extern void _ZN5S28C64v227Ev();
extern void _ZN5S28C64v228Ev();
extern void _ZN5S28C64v229Ev();
extern void _ZN5S28C64v230Ev();
extern void _ZN5S28C64v231Ev();
extern void _ZN5S28C64v232Ev();
extern void _ZN5S28C64v233Ev();
extern void _ZN5S28C64v234Ev();
extern void _ZN5S28C64v235Ev();
extern void _ZN5S28C64v236Ev();
extern void _ZN5S28C64v237Ev();
extern void _ZN5S28C64v238Ev();
extern void _ZN5S28C64v239Ev();
extern void _ZN5S28C64v240Ev();
extern void _ZN5S28C64v241Ev();
extern void _ZN5S28C64v242Ev();
extern void _ZN5S28C64v243Ev();
extern void _ZN5S28C64v244Ev();
extern void _ZN5S28C64v245Ev();
extern void _ZN5S28C64v246Ev();
extern void _ZN5S28C64v247Ev();
extern void _ZN5S28C64v248Ev();
extern void _ZN5S28C64v249Ev();
extern void _ZN5S28C64v250Ev();
extern void _ZN5S28C64v251Ev();
extern void _ZN5S28C64v252Ev();
extern void _ZN5S28C64v253Ev();
extern void _ZN5S28C64v254Ev();
extern void _ZN5S28C64v255Ev();
extern void _ZN5S28C64v256Ev();
extern void _ZN5S28C64v257Ev();
extern void _ZN5S28C64v258Ev();
extern void _ZN5S28C64v259Ev();
extern void _ZN5S28C64v260Ev();
extern void _ZN5S28C54v261Ev();
extern void _ZN5S28C54v262Ev();
extern void _ZN5S28C54v263Ev();
extern void _ZN5S28C54v264Ev();
extern void _ZN5S28C54v265Ev();
extern void _ZN5S28C54v266Ev();
extern void _ZN5S28C54v267Ev();
extern void _ZN5S28C54v268Ev();
extern void _ZN5S28C54v269Ev();
extern void _ZN5S28C54v270Ev();
extern void _ZN5S28C54v271Ev();
extern void _ZN5S28C54v272Ev();
extern void _ZN5S28C54v273Ev();
extern void _ZN5S28C54v274Ev();
extern void _ZN5S28C54v275Ev();
extern void _ZN5S28C54v276Ev();
extern void _ZN5S28C54v277Ev();
extern void _ZN5S28C54v278Ev();
extern void _ZN5S28C54v279Ev();
extern void _ZN5S28C54v280Ev();
extern void _ZN5S28C54v281Ev();
extern void _ZN5S28C54v282Ev();
extern void _ZN5S28C54v283Ev();
extern void _ZN5S28C54v284Ev();
extern void _ZN5S28C54v285Ev();
extern void _ZN5S28C54v286Ev();
extern void _ZN5S28C54v287Ev();
extern void _ZN5S28C54v288Ev();
extern void _ZN5S28C54v289Ev();
extern void _ZN5S28C54v290Ev();
extern void _ZN5S28C54v291Ev();
extern void _ZN5S28C54v292Ev();
extern void _ZN5S28C54v293Ev();
extern void _ZN5S28C54v294Ev();
extern void _ZN5S28C54v295Ev();
extern void _ZN5S28C54v296Ev();
extern void _ZN5S28C54v297Ev();
extern void _ZN5S28C54v298Ev();
extern void _ZN5S28C44v299Ev();
extern void _ZN5S28C44v300Ev();
extern void _ZN5S28C44v301Ev();
extern void _ZN5S28C34v302Ev();
extern void _ZN5S28C34v303Ev();
extern void _ZN5S28C34v304Ev();
extern void _ZN5S28C34v305Ev();
extern void _ZN5S28C34v306Ev();
extern void _ZN5S28C34v307Ev();
extern void _ZN5S28C34v308Ev();
extern void _ZN5S28C34v309Ev();
extern void _ZN5S28C34v310Ev();
extern void _ZN5S28C34v311Ev();
extern void _ZN5S28C34v312Ev();
extern void _ZN5S28C34v313Ev();
extern void _ZN5S28C34v314Ev();
extern void _ZN5S28C34v315Ev();
extern void _ZN5S28C34v316Ev();
extern void _ZN5S28C34v317Ev();
extern void _ZN5S28C34v318Ev();
extern void _ZN5S28C34v319Ev();
extern void _ZN5S28C34v320Ev();
extern void _ZN5S28C24v321Ev();
extern void _ZN5S28C24v322Ev();
extern void _ZN5S28C12v1Ev();
extern void _ZN5S28C12v2Ev();
extern void _ZN5S28C12v3Ev();
static  VTBL_ENTRY vtc_S28C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S28C1[0]),
  (VTBL_ENTRY)&_ZN5S28C1D1Ev,
  (VTBL_ENTRY)&_ZN5S28C1D0Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S28C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S28C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN5S28C64v211Ev,
  (VTBL_ENTRY)&_ZN5S28C64v212Ev,
  (VTBL_ENTRY)&_ZN5S28C64v213Ev,
  (VTBL_ENTRY)&_ZN5S28C64v214Ev,
  (VTBL_ENTRY)&_ZN5S28C64v215Ev,
  (VTBL_ENTRY)&_ZN5S28C64v216Ev,
  (VTBL_ENTRY)&_ZN5S28C64v217Ev,
  (VTBL_ENTRY)&_ZN5S28C64v218Ev,
  (VTBL_ENTRY)&_ZN5S28C64v219Ev,
  (VTBL_ENTRY)&_ZN5S28C64v220Ev,
  (VTBL_ENTRY)&_ZN5S28C64v221Ev,
  (VTBL_ENTRY)&_ZN5S28C64v222Ev,
  (VTBL_ENTRY)&_ZN5S28C64v223Ev,
  (VTBL_ENTRY)&_ZN5S28C64v224Ev,
  (VTBL_ENTRY)&_ZN5S28C64v225Ev,
  (VTBL_ENTRY)&_ZN5S28C64v226Ev,
  (VTBL_ENTRY)&_ZN5S28C64v227Ev,
  (VTBL_ENTRY)&_ZN5S28C64v228Ev,
  (VTBL_ENTRY)&_ZN5S28C64v229Ev,
  (VTBL_ENTRY)&_ZN5S28C64v230Ev,
  (VTBL_ENTRY)&_ZN5S28C64v231Ev,
  (VTBL_ENTRY)&_ZN5S28C64v232Ev,
  (VTBL_ENTRY)&_ZN5S28C64v233Ev,
  (VTBL_ENTRY)&_ZN5S28C64v234Ev,
  (VTBL_ENTRY)&_ZN5S28C64v235Ev,
  (VTBL_ENTRY)&_ZN5S28C64v236Ev,
  (VTBL_ENTRY)&_ZN5S28C64v237Ev,
  (VTBL_ENTRY)&_ZN5S28C64v238Ev,
  (VTBL_ENTRY)&_ZN5S28C64v239Ev,
  (VTBL_ENTRY)&_ZN5S28C64v240Ev,
  (VTBL_ENTRY)&_ZN5S28C64v241Ev,
  (VTBL_ENTRY)&_ZN5S28C64v242Ev,
  (VTBL_ENTRY)&_ZN5S28C64v243Ev,
  (VTBL_ENTRY)&_ZN5S28C64v244Ev,
  (VTBL_ENTRY)&_ZN5S28C64v245Ev,
  (VTBL_ENTRY)&_ZN5S28C64v246Ev,
  (VTBL_ENTRY)&_ZN5S28C64v247Ev,
  (VTBL_ENTRY)&_ZN5S28C64v248Ev,
  (VTBL_ENTRY)&_ZN5S28C64v249Ev,
  (VTBL_ENTRY)&_ZN5S28C64v250Ev,
  (VTBL_ENTRY)&_ZN5S28C64v251Ev,
  (VTBL_ENTRY)&_ZN5S28C64v252Ev,
  (VTBL_ENTRY)&_ZN5S28C64v253Ev,
  (VTBL_ENTRY)&_ZN5S28C64v254Ev,
  (VTBL_ENTRY)&_ZN5S28C64v255Ev,
  (VTBL_ENTRY)&_ZN5S28C64v256Ev,
  (VTBL_ENTRY)&_ZN5S28C64v257Ev,
  (VTBL_ENTRY)&_ZN5S28C64v258Ev,
  (VTBL_ENTRY)&_ZN5S28C64v259Ev,
  (VTBL_ENTRY)&_ZN5S28C64v260Ev,
  (VTBL_ENTRY)&_ZN5S28C54v261Ev,
  (VTBL_ENTRY)&_ZN5S28C54v262Ev,
  (VTBL_ENTRY)&_ZN5S28C54v263Ev,
  (VTBL_ENTRY)&_ZN5S28C54v264Ev,
  (VTBL_ENTRY)&_ZN5S28C54v265Ev,
  (VTBL_ENTRY)&_ZN5S28C54v266Ev,
  (VTBL_ENTRY)&_ZN5S28C54v267Ev,
  (VTBL_ENTRY)&_ZN5S28C54v268Ev,
  (VTBL_ENTRY)&_ZN5S28C54v269Ev,
  (VTBL_ENTRY)&_ZN5S28C54v270Ev,
  (VTBL_ENTRY)&_ZN5S28C54v271Ev,
  (VTBL_ENTRY)&_ZN5S28C54v272Ev,
  (VTBL_ENTRY)&_ZN5S28C54v273Ev,
  (VTBL_ENTRY)&_ZN5S28C54v274Ev,
  (VTBL_ENTRY)&_ZN5S28C54v275Ev,
  (VTBL_ENTRY)&_ZN5S28C54v276Ev,
  (VTBL_ENTRY)&_ZN5S28C54v277Ev,
  (VTBL_ENTRY)&_ZN5S28C54v278Ev,
  (VTBL_ENTRY)&_ZN5S28C54v279Ev,
  (VTBL_ENTRY)&_ZN5S28C54v280Ev,
  (VTBL_ENTRY)&_ZN5S28C54v281Ev,
  (VTBL_ENTRY)&_ZN5S28C54v282Ev,
  (VTBL_ENTRY)&_ZN5S28C54v283Ev,
  (VTBL_ENTRY)&_ZN5S28C54v284Ev,
  (VTBL_ENTRY)&_ZN5S28C54v285Ev,
  (VTBL_ENTRY)&_ZN5S28C54v286Ev,
  (VTBL_ENTRY)&_ZN5S28C54v287Ev,
  (VTBL_ENTRY)&_ZN5S28C54v288Ev,
  (VTBL_ENTRY)&_ZN5S28C54v289Ev,
  (VTBL_ENTRY)&_ZN5S28C54v290Ev,
  (VTBL_ENTRY)&_ZN5S28C54v291Ev,
  (VTBL_ENTRY)&_ZN5S28C54v292Ev,
  (VTBL_ENTRY)&_ZN5S28C54v293Ev,
  (VTBL_ENTRY)&_ZN5S28C54v294Ev,
  (VTBL_ENTRY)&_ZN5S28C54v295Ev,
  (VTBL_ENTRY)&_ZN5S28C54v296Ev,
  (VTBL_ENTRY)&_ZN5S28C54v297Ev,
  (VTBL_ENTRY)&_ZN5S28C54v298Ev,
  (VTBL_ENTRY)&_ZN5S28C44v299Ev,
  (VTBL_ENTRY)&_ZN5S28C44v300Ev,
  (VTBL_ENTRY)&_ZN5S28C44v301Ev,
  (VTBL_ENTRY)&_ZN5S28C34v302Ev,
  (VTBL_ENTRY)&_ZN5S28C34v303Ev,
  (VTBL_ENTRY)&_ZN5S28C34v304Ev,
  (VTBL_ENTRY)&_ZN5S28C34v305Ev,
  (VTBL_ENTRY)&_ZN5S28C34v306Ev,
  (VTBL_ENTRY)&_ZN5S28C34v307Ev,
  (VTBL_ENTRY)&_ZN5S28C34v308Ev,
  (VTBL_ENTRY)&_ZN5S28C34v309Ev,
  (VTBL_ENTRY)&_ZN5S28C34v310Ev,
  (VTBL_ENTRY)&_ZN5S28C34v311Ev,
  (VTBL_ENTRY)&_ZN5S28C34v312Ev,
  (VTBL_ENTRY)&_ZN5S28C34v313Ev,
  (VTBL_ENTRY)&_ZN5S28C34v314Ev,
  (VTBL_ENTRY)&_ZN5S28C34v315Ev,
  (VTBL_ENTRY)&_ZN5S28C34v316Ev,
  (VTBL_ENTRY)&_ZN5S28C34v317Ev,
  (VTBL_ENTRY)&_ZN5S28C34v318Ev,
  (VTBL_ENTRY)&_ZN5S28C34v319Ev,
  (VTBL_ENTRY)&_ZN5S28C34v320Ev,
  (VTBL_ENTRY)&_ZN5S28C24v321Ev,
  (VTBL_ENTRY)&_ZN5S28C24v322Ev,
  (VTBL_ENTRY)&_ZN5S28C12v1Ev,
  (VTBL_ENTRY)&_ZN5S28C12v2Ev,
  (VTBL_ENTRY)&_ZN5S28C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S28C1[];
extern  VTBL_ENTRY _ZTV5S28C1[];
Class_Descriptor cd_S28C1 = {  "S28C1", // class name
  bases_S28C1, 7,
  &(vtc_S28C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2680,2056), // object size
  NSPAIRA(_ZTI5S28C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S28C1),326, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C7  {
  int s48c7f0;
  __tsi64 s48c7f1;
  void *s48c7f2[4];
  int s48c7f3[2];
  void *s48c7f4;
  ::S28C9_nt s48c7f5;
  void *s48c7f6[2];
  virtual  ~S48C7(); // _ZN5S48C7D1Ev
  virtual void  v11(); // _ZN5S48C73v11Ev
  virtual void  v12(); // _ZN5S48C73v12Ev
  virtual void  v13(); // _ZN5S48C73v13Ev
  virtual void  v14(); // _ZN5S48C73v14Ev
  virtual void  v15(); // _ZN5S48C73v15Ev
  virtual void  v16(); // _ZN5S48C73v16Ev
  virtual void  v17(); // _ZN5S48C73v17Ev
  virtual void  v18(); // _ZN5S48C73v18Ev
  virtual void  v19(); // _ZN5S48C73v19Ev
  virtual void  v20(); // _ZN5S48C73v20Ev
  virtual void  v21(); // _ZN5S48C73v21Ev
  virtual void  v22(); // _ZN5S48C73v22Ev
  virtual void  v23(); // _ZN5S48C73v23Ev
  virtual void  v24(); // _ZN5S48C73v24Ev
  virtual void  v25(); // _ZN5S48C73v25Ev
  virtual void  v26(); // _ZN5S48C73v26Ev
  virtual void  v27(); // _ZN5S48C73v27Ev
  virtual void  v28(); // _ZN5S48C73v28Ev
  virtual void  v29(); // _ZN5S48C73v29Ev
  virtual void  v30(); // _ZN5S48C73v30Ev
  virtual void  v31(); // _ZN5S48C73v31Ev
  virtual void  v32(); // _ZN5S48C73v32Ev
  virtual void  v33(); // _ZN5S48C73v33Ev
  virtual void  v34(); // _ZN5S48C73v34Ev
  virtual void  v35(); // _ZN5S48C73v35Ev
  virtual void  v36(); // _ZN5S48C73v36Ev
  virtual void  v37(); // _ZN5S48C73v37Ev
  virtual void  v38(); // _ZN5S48C73v38Ev
  virtual void  v39(); // _ZN5S48C73v39Ev
  virtual void  v40(); // _ZN5S48C73v40Ev
  virtual void  v41(); // _ZN5S48C73v41Ev
  virtual void  v42(); // _ZN5S48C73v42Ev
  virtual void  v43(); // _ZN5S48C73v43Ev
  virtual void  v44(); // _ZN5S48C73v44Ev
  virtual void  v45(); // _ZN5S48C73v45Ev
  virtual void  v46(); // _ZN5S48C73v46Ev
  virtual void  v47(); // _ZN5S48C73v47Ev
  virtual void  v48(); // _ZN5S48C73v48Ev
  virtual void  v49(); // _ZN5S48C73v49Ev
  virtual void  v50(); // _ZN5S48C73v50Ev
  virtual void  v51(); // _ZN5S48C73v51Ev
  virtual void  v52(); // _ZN5S48C73v52Ev
  virtual void  v53(); // _ZN5S48C73v53Ev
  virtual void  v54(); // _ZN5S48C73v54Ev
  virtual void  v55(); // _ZN5S48C73v55Ev
  virtual void  v56(); // _ZN5S48C73v56Ev
  virtual void  v57(); // _ZN5S48C73v57Ev
  virtual void  v58(); // _ZN5S48C73v58Ev
  virtual void  v59(); // _ZN5S48C73v59Ev
  virtual void  v60(); // _ZN5S48C73v60Ev
  virtual void  v61(); // _ZN5S48C73v61Ev
  virtual void  v62(); // _ZN5S48C73v62Ev
  virtual void  v63(); // _ZN5S48C73v63Ev
  virtual void  v64(); // _ZN5S48C73v64Ev
  virtual void  v65(); // _ZN5S48C73v65Ev
  virtual void  v66(); // _ZN5S48C73v66Ev
  virtual void  v67(); // _ZN5S48C73v67Ev
  virtual void  v68(); // _ZN5S48C73v68Ev
  virtual void  v69(); // _ZN5S48C73v69Ev
  virtual void  v70(); // _ZN5S48C73v70Ev
  virtual void  v71(); // _ZN5S48C73v71Ev
  virtual void  v72(); // _ZN5S48C73v72Ev
  virtual void  v73(); // _ZN5S48C73v73Ev
  virtual void  v74(); // _ZN5S48C73v74Ev
  S48C7(); // tgen
};
//SIG(-1 S48C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S48C7 ::~S48C7(){ note_dtor("S48C7", this);}
void  S48C7 ::v11(){vfunc_called(this, "_ZN5S48C73v11Ev");}
void  S48C7 ::v12(){vfunc_called(this, "_ZN5S48C73v12Ev");}
void  S48C7 ::v13(){vfunc_called(this, "_ZN5S48C73v13Ev");}
void  S48C7 ::v14(){vfunc_called(this, "_ZN5S48C73v14Ev");}
void  S48C7 ::v15(){vfunc_called(this, "_ZN5S48C73v15Ev");}
void  S48C7 ::v16(){vfunc_called(this, "_ZN5S48C73v16Ev");}
void  S48C7 ::v17(){vfunc_called(this, "_ZN5S48C73v17Ev");}
void  S48C7 ::v18(){vfunc_called(this, "_ZN5S48C73v18Ev");}
void  S48C7 ::v19(){vfunc_called(this, "_ZN5S48C73v19Ev");}
void  S48C7 ::v20(){vfunc_called(this, "_ZN5S48C73v20Ev");}
void  S48C7 ::v21(){vfunc_called(this, "_ZN5S48C73v21Ev");}
void  S48C7 ::v22(){vfunc_called(this, "_ZN5S48C73v22Ev");}
void  S48C7 ::v23(){vfunc_called(this, "_ZN5S48C73v23Ev");}
void  S48C7 ::v24(){vfunc_called(this, "_ZN5S48C73v24Ev");}
void  S48C7 ::v25(){vfunc_called(this, "_ZN5S48C73v25Ev");}
void  S48C7 ::v26(){vfunc_called(this, "_ZN5S48C73v26Ev");}
void  S48C7 ::v27(){vfunc_called(this, "_ZN5S48C73v27Ev");}
void  S48C7 ::v28(){vfunc_called(this, "_ZN5S48C73v28Ev");}
void  S48C7 ::v29(){vfunc_called(this, "_ZN5S48C73v29Ev");}
void  S48C7 ::v30(){vfunc_called(this, "_ZN5S48C73v30Ev");}
void  S48C7 ::v31(){vfunc_called(this, "_ZN5S48C73v31Ev");}
void  S48C7 ::v32(){vfunc_called(this, "_ZN5S48C73v32Ev");}
void  S48C7 ::v33(){vfunc_called(this, "_ZN5S48C73v33Ev");}
void  S48C7 ::v34(){vfunc_called(this, "_ZN5S48C73v34Ev");}
void  S48C7 ::v35(){vfunc_called(this, "_ZN5S48C73v35Ev");}
void  S48C7 ::v36(){vfunc_called(this, "_ZN5S48C73v36Ev");}
void  S48C7 ::v37(){vfunc_called(this, "_ZN5S48C73v37Ev");}
void  S48C7 ::v38(){vfunc_called(this, "_ZN5S48C73v38Ev");}
void  S48C7 ::v39(){vfunc_called(this, "_ZN5S48C73v39Ev");}
void  S48C7 ::v40(){vfunc_called(this, "_ZN5S48C73v40Ev");}
void  S48C7 ::v41(){vfunc_called(this, "_ZN5S48C73v41Ev");}
void  S48C7 ::v42(){vfunc_called(this, "_ZN5S48C73v42Ev");}
void  S48C7 ::v43(){vfunc_called(this, "_ZN5S48C73v43Ev");}
void  S48C7 ::v44(){vfunc_called(this, "_ZN5S48C73v44Ev");}
void  S48C7 ::v45(){vfunc_called(this, "_ZN5S48C73v45Ev");}
void  S48C7 ::v46(){vfunc_called(this, "_ZN5S48C73v46Ev");}
void  S48C7 ::v47(){vfunc_called(this, "_ZN5S48C73v47Ev");}
void  S48C7 ::v48(){vfunc_called(this, "_ZN5S48C73v48Ev");}
void  S48C7 ::v49(){vfunc_called(this, "_ZN5S48C73v49Ev");}
void  S48C7 ::v50(){vfunc_called(this, "_ZN5S48C73v50Ev");}
void  S48C7 ::v51(){vfunc_called(this, "_ZN5S48C73v51Ev");}
void  S48C7 ::v52(){vfunc_called(this, "_ZN5S48C73v52Ev");}
void  S48C7 ::v53(){vfunc_called(this, "_ZN5S48C73v53Ev");}
void  S48C7 ::v54(){vfunc_called(this, "_ZN5S48C73v54Ev");}
void  S48C7 ::v55(){vfunc_called(this, "_ZN5S48C73v55Ev");}
void  S48C7 ::v56(){vfunc_called(this, "_ZN5S48C73v56Ev");}
void  S48C7 ::v57(){vfunc_called(this, "_ZN5S48C73v57Ev");}
void  S48C7 ::v58(){vfunc_called(this, "_ZN5S48C73v58Ev");}
void  S48C7 ::v59(){vfunc_called(this, "_ZN5S48C73v59Ev");}
void  S48C7 ::v60(){vfunc_called(this, "_ZN5S48C73v60Ev");}
void  S48C7 ::v61(){vfunc_called(this, "_ZN5S48C73v61Ev");}
void  S48C7 ::v62(){vfunc_called(this, "_ZN5S48C73v62Ev");}
void  S48C7 ::v63(){vfunc_called(this, "_ZN5S48C73v63Ev");}
void  S48C7 ::v64(){vfunc_called(this, "_ZN5S48C73v64Ev");}
void  S48C7 ::v65(){vfunc_called(this, "_ZN5S48C73v65Ev");}
void  S48C7 ::v66(){vfunc_called(this, "_ZN5S48C73v66Ev");}
void  S48C7 ::v67(){vfunc_called(this, "_ZN5S48C73v67Ev");}
void  S48C7 ::v68(){vfunc_called(this, "_ZN5S48C73v68Ev");}
void  S48C7 ::v69(){vfunc_called(this, "_ZN5S48C73v69Ev");}
void  S48C7 ::v70(){vfunc_called(this, "_ZN5S48C73v70Ev");}
void  S48C7 ::v71(){vfunc_called(this, "_ZN5S48C73v71Ev");}
void  S48C7 ::v72(){vfunc_called(this, "_ZN5S48C73v72Ev");}
void  S48C7 ::v73(){vfunc_called(this, "_ZN5S48C73v73Ev");}
void  S48C7 ::v74(){vfunc_called(this, "_ZN5S48C73v74Ev");}
S48C7 ::S48C7(){ note_ctor("S48C7", this);} // tgen

static void Test_S48C7()
{
  extern Class_Descriptor cd_S48C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S48C7, buf);
    S48C7 *dp, &lv = *(dp=new (buf) S48C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S48C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C7)");
    check_field_offset(lv, s48c7f0, ABISELECT(8,4), "S48C7.s48c7f0");
    check_field_offset(lv, s48c7f1, ABISELECT(16,8), "S48C7.s48c7f1");
    check_field_offset(lv, s48c7f2, ABISELECT(24,16), "S48C7.s48c7f2");
    check_field_offset(lv, s48c7f3, ABISELECT(56,32), "S48C7.s48c7f3");
    check_field_offset(lv, s48c7f4, ABISELECT(64,40), "S48C7.s48c7f4");
    check_field_offset(lv, s48c7f5, ABISELECT(72,44), "S48C7.s48c7f5");
    check_field_offset(lv, s48c7f6, ABISELECT(80,52), "S48C7.s48c7f6");
    test_class_info(&lv, &cd_S48C7);
    dp->~S48C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C7(Test_S48C7, "S48C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S48C7C1Ev();
extern void _ZN5S48C7D1Ev();
Name_Map name_map_S48C7[] = {
  NSPAIR(_ZN5S48C7C1Ev),
  NSPAIR(_ZN5S48C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S48C7[];
extern void _ZN5S48C7D1Ev();
extern void _ZN5S48C7D0Ev();
extern void _ZN5S48C73v11Ev();
extern void _ZN5S48C73v12Ev();
extern void _ZN5S48C73v13Ev();
extern void _ZN5S48C73v14Ev();
extern void _ZN5S48C73v15Ev();
extern void _ZN5S48C73v16Ev();
extern void _ZN5S48C73v17Ev();
extern void _ZN5S48C73v18Ev();
extern void _ZN5S48C73v19Ev();
extern void _ZN5S48C73v20Ev();
extern void _ZN5S48C73v21Ev();
extern void _ZN5S48C73v22Ev();
extern void _ZN5S48C73v23Ev();
extern void _ZN5S48C73v24Ev();
extern void _ZN5S48C73v25Ev();
extern void _ZN5S48C73v26Ev();
extern void _ZN5S48C73v27Ev();
extern void _ZN5S48C73v28Ev();
extern void _ZN5S48C73v29Ev();
extern void _ZN5S48C73v30Ev();
extern void _ZN5S48C73v31Ev();
extern void _ZN5S48C73v32Ev();
extern void _ZN5S48C73v33Ev();
extern void _ZN5S48C73v34Ev();
extern void _ZN5S48C73v35Ev();
extern void _ZN5S48C73v36Ev();
extern void _ZN5S48C73v37Ev();
extern void _ZN5S48C73v38Ev();
extern void _ZN5S48C73v39Ev();
extern void _ZN5S48C73v40Ev();
extern void _ZN5S48C73v41Ev();
extern void _ZN5S48C73v42Ev();
extern void _ZN5S48C73v43Ev();
extern void _ZN5S48C73v44Ev();
extern void _ZN5S48C73v45Ev();
extern void _ZN5S48C73v46Ev();
extern void _ZN5S48C73v47Ev();
extern void _ZN5S48C73v48Ev();
extern void _ZN5S48C73v49Ev();
extern void _ZN5S48C73v50Ev();
extern void _ZN5S48C73v51Ev();
extern void _ZN5S48C73v52Ev();
extern void _ZN5S48C73v53Ev();
extern void _ZN5S48C73v54Ev();
extern void _ZN5S48C73v55Ev();
extern void _ZN5S48C73v56Ev();
extern void _ZN5S48C73v57Ev();
extern void _ZN5S48C73v58Ev();
extern void _ZN5S48C73v59Ev();
extern void _ZN5S48C73v60Ev();
extern void _ZN5S48C73v61Ev();
extern void _ZN5S48C73v62Ev();
extern void _ZN5S48C73v63Ev();
extern void _ZN5S48C73v64Ev();
extern void _ZN5S48C73v65Ev();
extern void _ZN5S48C73v66Ev();
extern void _ZN5S48C73v67Ev();
extern void _ZN5S48C73v68Ev();
extern void _ZN5S48C73v69Ev();
extern void _ZN5S48C73v70Ev();
extern void _ZN5S48C73v71Ev();
extern void _ZN5S48C73v72Ev();
extern void _ZN5S48C73v73Ev();
extern void _ZN5S48C73v74Ev();
static  VTBL_ENTRY vtc_S48C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S48C7[0]),
  (VTBL_ENTRY)&_ZN5S48C7D1Ev,
  (VTBL_ENTRY)&_ZN5S48C7D0Ev,
  (VTBL_ENTRY)&_ZN5S48C73v11Ev,
  (VTBL_ENTRY)&_ZN5S48C73v12Ev,
  (VTBL_ENTRY)&_ZN5S48C73v13Ev,
  (VTBL_ENTRY)&_ZN5S48C73v14Ev,
  (VTBL_ENTRY)&_ZN5S48C73v15Ev,
  (VTBL_ENTRY)&_ZN5S48C73v16Ev,
  (VTBL_ENTRY)&_ZN5S48C73v17Ev,
  (VTBL_ENTRY)&_ZN5S48C73v18Ev,
  (VTBL_ENTRY)&_ZN5S48C73v19Ev,
  (VTBL_ENTRY)&_ZN5S48C73v20Ev,
  (VTBL_ENTRY)&_ZN5S48C73v21Ev,
  (VTBL_ENTRY)&_ZN5S48C73v22Ev,
  (VTBL_ENTRY)&_ZN5S48C73v23Ev,
  (VTBL_ENTRY)&_ZN5S48C73v24Ev,
  (VTBL_ENTRY)&_ZN5S48C73v25Ev,
  (VTBL_ENTRY)&_ZN5S48C73v26Ev,
  (VTBL_ENTRY)&_ZN5S48C73v27Ev,
  (VTBL_ENTRY)&_ZN5S48C73v28Ev,
  (VTBL_ENTRY)&_ZN5S48C73v29Ev,
  (VTBL_ENTRY)&_ZN5S48C73v30Ev,
  (VTBL_ENTRY)&_ZN5S48C73v31Ev,
  (VTBL_ENTRY)&_ZN5S48C73v32Ev,
  (VTBL_ENTRY)&_ZN5S48C73v33Ev,
  (VTBL_ENTRY)&_ZN5S48C73v34Ev,
  (VTBL_ENTRY)&_ZN5S48C73v35Ev,
  (VTBL_ENTRY)&_ZN5S48C73v36Ev,
  (VTBL_ENTRY)&_ZN5S48C73v37Ev,
  (VTBL_ENTRY)&_ZN5S48C73v38Ev,
  (VTBL_ENTRY)&_ZN5S48C73v39Ev,
  (VTBL_ENTRY)&_ZN5S48C73v40Ev,
  (VTBL_ENTRY)&_ZN5S48C73v41Ev,
  (VTBL_ENTRY)&_ZN5S48C73v42Ev,
  (VTBL_ENTRY)&_ZN5S48C73v43Ev,
  (VTBL_ENTRY)&_ZN5S48C73v44Ev,
  (VTBL_ENTRY)&_ZN5S48C73v45Ev,
  (VTBL_ENTRY)&_ZN5S48C73v46Ev,
  (VTBL_ENTRY)&_ZN5S48C73v47Ev,
  (VTBL_ENTRY)&_ZN5S48C73v48Ev,
  (VTBL_ENTRY)&_ZN5S48C73v49Ev,
  (VTBL_ENTRY)&_ZN5S48C73v50Ev,
  (VTBL_ENTRY)&_ZN5S48C73v51Ev,
  (VTBL_ENTRY)&_ZN5S48C73v52Ev,
  (VTBL_ENTRY)&_ZN5S48C73v53Ev,
  (VTBL_ENTRY)&_ZN5S48C73v54Ev,
  (VTBL_ENTRY)&_ZN5S48C73v55Ev,
  (VTBL_ENTRY)&_ZN5S48C73v56Ev,
  (VTBL_ENTRY)&_ZN5S48C73v57Ev,
  (VTBL_ENTRY)&_ZN5S48C73v58Ev,
  (VTBL_ENTRY)&_ZN5S48C73v59Ev,
  (VTBL_ENTRY)&_ZN5S48C73v60Ev,
  (VTBL_ENTRY)&_ZN5S48C73v61Ev,
  (VTBL_ENTRY)&_ZN5S48C73v62Ev,
  (VTBL_ENTRY)&_ZN5S48C73v63Ev,
  (VTBL_ENTRY)&_ZN5S48C73v64Ev,
  (VTBL_ENTRY)&_ZN5S48C73v65Ev,
  (VTBL_ENTRY)&_ZN5S48C73v66Ev,
  (VTBL_ENTRY)&_ZN5S48C73v67Ev,
  (VTBL_ENTRY)&_ZN5S48C73v68Ev,
  (VTBL_ENTRY)&_ZN5S48C73v69Ev,
  (VTBL_ENTRY)&_ZN5S48C73v70Ev,
  (VTBL_ENTRY)&_ZN5S48C73v71Ev,
  (VTBL_ENTRY)&_ZN5S48C73v72Ev,
  (VTBL_ENTRY)&_ZN5S48C73v73Ev,
  (VTBL_ENTRY)&_ZN5S48C73v74Ev,
};
extern VTBL_ENTRY _ZTI5S48C7[];
extern  VTBL_ENTRY _ZTV5S48C7[];
Class_Descriptor cd_S48C7 = {  "S48C7", // class name
  0,0,//no base classes
  &(vtc_S48C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S48C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S48C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C18  {
  int s48c18f0[3];
  void  mf48c18(); // _ZN6S48C187mf48c18Ev
};
//SIG(-1 S48C18) C1{ m Fi[3]}


void  S48C18 ::mf48c18(){}

static void Test_S48C18()
{
  {
    init_simple_test("S48C18");
    S48C18 lv;
    check2(sizeof(lv), 12, "sizeof(S48C18)");
    check2(__alignof__(lv), 4, "__alignof__(S48C18)");
    check_field_offset(lv, s48c18f0, 0, "S48C18.s48c18f0");
  }
}
static Arrange_To_Call_Me vS48C18(Test_S48C18, "S48C18", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C6  : S48C7 {
  ::S28C55 s48c6f0;
  ::S28C55 s48c6f1;
  ::S28C13_nt s48c6f2;
  int s48c6f3;
  char s48c6f4[4];
  void *s48c6f5[2];
  ::S28C48 s48c6f6;
  unsigned int s48c6f7:1;
  unsigned int s48c6f8:1;
  unsigned int s48c6f9:1;
  unsigned int s48c6f10:1;
  unsigned int s48c6f11:1;
  unsigned int s48c6f12:1;
  unsigned int s48c6f13:1;
  unsigned int s48c6f14:1;
  unsigned int s48c6f15:1;
  unsigned int s48c6f16:1;
  unsigned int s48c6f17:1;
  unsigned int s48c6f18:1;
  unsigned int s48c6f19:1;
  unsigned int s48c6f20:1;
  unsigned int s48c6f21:1;
  unsigned int s48c6f22:1;
  unsigned int s48c6f23:1;
  unsigned int s48c6f24:1;
  unsigned int s48c6f25:1;
  unsigned int s48c6f26:1;
  unsigned int s48c6f27:1;
  unsigned int s48c6f28:1;
  unsigned int s48c6f29:1;
  unsigned int s48c6f30:1;
  unsigned int s48c6f31:1;
  unsigned int s48c6f32:1;
  unsigned int s48c6f33:1;
  unsigned int s48c6f34:1;
  unsigned int s48c6f35:1;
  unsigned int s48c6f36:1;
  unsigned int s48c6f37:1;
  unsigned int s48c6f38:1;
  unsigned int s48c6f39:1;
  unsigned int s48c6f40:1;
  unsigned int s48c6f41:1;
  unsigned int s48c6f42:1;
  unsigned int s48c6f43:1;
  unsigned int s48c6f44:1;
  unsigned int s48c6f45:1;
  unsigned int s48c6f46:1;
  unsigned int s48c6f47:1;
  unsigned int s48c6f48:1;
  unsigned int s48c6f49:1;
  unsigned int s48c6f50:1;
  unsigned int s48c6f51:1;
  unsigned int s48c6f52:1;
  unsigned int s48c6f53:1;
  unsigned int s48c6f54:1;
  unsigned int s48c6f55:1;
  unsigned int s48c6f56:1;
  unsigned int s48c6f57:1;
  unsigned int s48c6f58:1;
  unsigned int s48c6f59:1;
  unsigned int s48c6f60:1;
  unsigned int s48c6f61:1;
  unsigned int s48c6f62:1;
  unsigned int s48c6f63:1;
  unsigned int s48c6f64:1;
  unsigned int s48c6f65:1;
  unsigned int s48c6f66:1;
  unsigned int s48c6f67:1;
  unsigned int s48c6f68:1;
  unsigned int s48c6f69:1;
  unsigned int s48c6f70:1;
  unsigned int s48c6f71:1;
  unsigned int s48c6f72:1;
  unsigned int s48c6f73:1;
  unsigned int s48c6f74:1;
  unsigned int s48c6f75:1;
  unsigned int s48c6f76:1;
  unsigned int s48c6f77:1;
  unsigned int s48c6f78:1;
  unsigned int s48c6f79:1;
  unsigned int s48c6f80:1;
  unsigned int s48c6f81:1;
  unsigned int s48c6f82:1;
  unsigned int s48c6f83:1;
  int s48c6f84[5];
  void *s48c6f85[2];
  int s48c6f86[3];
  ::S28C9_nt s48c6f87;
  ::S28C9_nt s48c6f88;
  ::S28C9_nt s48c6f89;
  ::S28C44 s48c6f90;
  ::S28C44 s48c6f91;
  int s48c6f92;
  void *s48c6f93[2];
  ::S28C18_nt s48c6f94;
  ::S48C18 s48c6f95;
  ::S28C18_nt s48c6f96;
  ::S28C18_nt s48c6f97;
  void *s48c6f98;
  ::S28C9_nt s48c6f99;
  ::S28C44 s48c6f100;
  ::S28C18_nt s48c6f101;
  ::S48C18 s48c6f102;
  int s48c6f103;
  ::S28C18_nt s48c6f104;
  ::S28C18_nt s48c6f105;
  void *s48c6f106;
  int s48c6f107;
  char s48c6f108;
  ::S48C18 s48c6f109;
  ::S48C18 s48c6f110;
  void *s48c6f111;
  int s48c6f112;
  void *s48c6f113;
  ::S28C40 s48c6f114;
  ::S28C34 s48c6f115;
  ::S28C32 s48c6f116;
  virtual  ~S48C6(); // _ZN5S48C6D1Ev
  virtual void  v75(); // _ZN5S48C63v75Ev
  virtual void  v76(); // _ZN5S48C63v76Ev
  virtual void  v77(); // _ZN5S48C63v77Ev
  virtual void  v78(); // _ZN5S48C63v78Ev
  virtual void  v79(); // _ZN5S48C63v79Ev
  virtual void  v80(); // _ZN5S48C63v80Ev
  virtual void  v81(); // _ZN5S48C63v81Ev
  virtual void  v82(); // _ZN5S48C63v82Ev
  virtual void  v83(); // _ZN5S48C63v83Ev
  virtual void  v84(); // _ZN5S48C63v84Ev
  virtual void  v85(); // _ZN5S48C63v85Ev
  virtual void  v86(); // _ZN5S48C63v86Ev
  virtual void  v87(); // _ZN5S48C63v87Ev
  virtual void  v88(); // _ZN5S48C63v88Ev
  virtual void  v89(); // _ZN5S48C63v89Ev
  virtual void  v90(); // _ZN5S48C63v90Ev
  virtual void  v91(); // _ZN5S48C63v91Ev
  virtual void  v92(); // _ZN5S48C63v92Ev
  virtual void  v93(); // _ZN5S48C63v93Ev
  virtual void  v94(); // _ZN5S48C63v94Ev
  virtual void  v95(); // _ZN5S48C63v95Ev
  virtual void  v96(); // _ZN5S48C63v96Ev
  virtual void  v97(); // _ZN5S48C63v97Ev
  virtual void  v98(); // _ZN5S48C63v98Ev
  virtual void  v99(); // _ZN5S48C63v99Ev
  virtual void  v100(); // _ZN5S48C64v100Ev
  virtual void  v101(); // _ZN5S48C64v101Ev
  virtual void  v102(); // _ZN5S48C64v102Ev
  virtual void  v103(); // _ZN5S48C64v103Ev
  virtual void  v104(); // _ZN5S48C64v104Ev
  virtual void  v105(); // _ZN5S48C64v105Ev
  virtual void  v106(); // _ZN5S48C64v106Ev
  virtual void  v107(); // _ZN5S48C64v107Ev
  virtual void  v108(); // _ZN5S48C64v108Ev
  virtual void  v109(); // _ZN5S48C64v109Ev
  virtual void  v110(); // _ZN5S48C64v110Ev
  virtual void  v111(); // _ZN5S48C64v111Ev
  virtual void  v112(); // _ZN5S48C64v112Ev
  virtual void  v113(); // _ZN5S48C64v113Ev
  virtual void  v114(); // _ZN5S48C64v114Ev
  virtual void  v115(); // _ZN5S48C64v115Ev
  virtual void  v116(); // _ZN5S48C64v116Ev
  virtual void  v117(); // _ZN5S48C64v117Ev
  virtual void  v118(); // _ZN5S48C64v118Ev
  virtual void  v119(); // _ZN5S48C64v119Ev
  virtual void  v120(); // _ZN5S48C64v120Ev
  virtual void  v121(); // _ZN5S48C64v121Ev
  virtual void  v122(); // _ZN5S48C64v122Ev
  virtual void  v123(); // _ZN5S48C64v123Ev
  virtual void  v124(); // _ZN5S48C64v124Ev
  virtual void  v125(); // _ZN5S48C64v125Ev
  virtual void  v126(); // _ZN5S48C64v126Ev
  virtual void  v127(); // _ZN5S48C64v127Ev
  virtual void  v128(); // _ZN5S48C64v128Ev
  virtual void  v129(); // _ZN5S48C64v129Ev
  virtual void  v130(); // _ZN5S48C64v130Ev
  virtual void  v131(); // _ZN5S48C64v131Ev
  virtual void  v132(); // _ZN5S48C64v132Ev
  virtual void  v133(); // _ZN5S48C64v133Ev
  virtual void  v134(); // _ZN5S48C64v134Ev
  virtual void  v135(); // _ZN5S48C64v135Ev
  virtual void  v136(); // _ZN5S48C64v136Ev
  virtual void  v137(); // _ZN5S48C64v137Ev
  virtual void  v138(); // _ZN5S48C64v138Ev
  virtual void  v139(); // _ZN5S48C64v139Ev
  virtual void  v140(); // _ZN5S48C64v140Ev
  virtual void  v141(); // _ZN5S48C64v141Ev
  virtual void  v142(); // _ZN5S48C64v142Ev
  virtual void  v143(); // _ZN5S48C64v143Ev
  virtual void  v144(); // _ZN5S48C64v144Ev
  virtual void  v145(); // _ZN5S48C64v145Ev
  virtual void  v146(); // _ZN5S48C64v146Ev
  virtual void  v147(); // _ZN5S48C64v147Ev
  virtual void  v148(); // _ZN5S48C64v148Ev
  virtual void  v149(); // _ZN5S48C64v149Ev
  virtual void  v150(); // _ZN5S48C64v150Ev
  virtual void  v151(); // _ZN5S48C64v151Ev
  virtual void  v152(); // _ZN5S48C64v152Ev
  virtual void  v153(); // _ZN5S48C64v153Ev
  virtual void  v154(); // _ZN5S48C64v154Ev
  virtual void  v155(); // _ZN5S48C64v155Ev
  virtual void  v156(); // _ZN5S48C64v156Ev
  virtual void  v157(); // _ZN5S48C64v157Ev
  virtual void  v158(); // _ZN5S48C64v158Ev
  virtual void  v159(); // _ZN5S48C64v159Ev
  virtual void  v160(); // _ZN5S48C64v160Ev
  virtual void  v161(); // _ZN5S48C64v161Ev
  virtual void  v162(); // _ZN5S48C64v162Ev
  virtual void  v163(); // _ZN5S48C64v163Ev
  virtual void  v164(); // _ZN5S48C64v164Ev
  virtual void  v165(); // _ZN5S48C64v165Ev
  virtual void  v166(); // _ZN5S48C64v166Ev
  virtual void  v167(); // _ZN5S48C64v167Ev
  virtual void  v168(); // _ZN5S48C64v168Ev
  virtual void  v169(); // _ZN5S48C64v169Ev
  virtual void  v170(); // _ZN5S48C64v170Ev
  virtual void  v171(); // _ZN5S48C64v171Ev
  virtual void  v172(); // _ZN5S48C64v172Ev
  virtual void  v173(); // _ZN5S48C64v173Ev
  virtual void  v174(); // _ZN5S48C64v174Ev
  virtual void  v175(); // _ZN5S48C64v175Ev
  virtual void  v176(); // _ZN5S48C64v176Ev
  virtual void  v177(); // _ZN5S48C64v177Ev
  virtual void  v178(); // _ZN5S48C64v178Ev
  virtual void  v179(); // _ZN5S48C64v179Ev
  virtual void  v180(); // _ZN5S48C64v180Ev
  virtual void  v181(); // _ZN5S48C64v181Ev
  virtual void  v182(); // _ZN5S48C64v182Ev
  virtual void  v183(); // _ZN5S48C64v183Ev
  virtual void  v184(); // _ZN5S48C64v184Ev
  virtual void  v185(); // _ZN5S48C64v185Ev
  virtual void  v186(); // _ZN5S48C64v186Ev
  virtual void  v187(); // _ZN5S48C64v187Ev
  virtual void  v188(); // _ZN5S48C64v188Ev
  virtual void  v189(); // _ZN5S48C64v189Ev
  virtual void  v190(); // _ZN5S48C64v190Ev
  virtual void  v191(); // _ZN5S48C64v191Ev
  virtual void  v192(); // _ZN5S48C64v192Ev
  virtual void  v193(); // _ZN5S48C64v193Ev
  virtual void  v194(); // _ZN5S48C64v194Ev
  virtual void  v195(); // _ZN5S48C64v195Ev
  virtual void  v196(); // _ZN5S48C64v196Ev
  virtual void  v197(); // _ZN5S48C64v197Ev
  virtual void  v198(); // _ZN5S48C64v198Ev
  virtual void  v199(); // _ZN5S48C64v199Ev
  virtual void  v200(); // _ZN5S48C64v200Ev
  virtual void  v201(); // _ZN5S48C64v201Ev
  virtual void  v202(); // _ZN5S48C64v202Ev
  virtual void  v203(); // _ZN5S48C64v203Ev
  virtual void  v204(); // _ZN5S48C64v204Ev
  virtual void  v205(); // _ZN5S48C64v205Ev
  virtual void  v206(); // _ZN5S48C64v206Ev
  virtual void  v207(); // _ZN5S48C64v207Ev
  virtual void  v208(); // _ZN5S48C64v208Ev
  virtual void  v209(); // _ZN5S48C64v209Ev
  virtual void  v210(); // _ZN5S48C64v210Ev
  virtual void  v211(); // _ZN5S48C64v211Ev
  virtual void  v212(); // _ZN5S48C64v212Ev
  virtual void  v213(); // _ZN5S48C64v213Ev
  virtual void  v214(); // _ZN5S48C64v214Ev
  virtual void  v215(); // _ZN5S48C64v215Ev
  virtual void  v216(); // _ZN5S48C64v216Ev
  virtual void  v217(); // _ZN5S48C64v217Ev
  S48C6(); // tgen
};
//SIG(-1 S48C6) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC8{ BC9{ BC6}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC10{ BC11{ BC6}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC13{ m Fi[3]} FC12 FC12 Fp FC3 FC10 FC12 FC13 Fi FC12 FC12 Fp Fi Fc FC13 FC13 Fp Fi Fp FC14{ BC15{ BC6}} FC16{ BC17{ BC6}} FC18{ BC19{ BC6}}}


 S48C6 ::~S48C6(){ note_dtor("S48C6", this);}
void  S48C6 ::v75(){vfunc_called(this, "_ZN5S48C63v75Ev");}
void  S48C6 ::v76(){vfunc_called(this, "_ZN5S48C63v76Ev");}
void  S48C6 ::v77(){vfunc_called(this, "_ZN5S48C63v77Ev");}
void  S48C6 ::v78(){vfunc_called(this, "_ZN5S48C63v78Ev");}
void  S48C6 ::v79(){vfunc_called(this, "_ZN5S48C63v79Ev");}
void  S48C6 ::v80(){vfunc_called(this, "_ZN5S48C63v80Ev");}
void  S48C6 ::v81(){vfunc_called(this, "_ZN5S48C63v81Ev");}
void  S48C6 ::v82(){vfunc_called(this, "_ZN5S48C63v82Ev");}
void  S48C6 ::v83(){vfunc_called(this, "_ZN5S48C63v83Ev");}
void  S48C6 ::v84(){vfunc_called(this, "_ZN5S48C63v84Ev");}
void  S48C6 ::v85(){vfunc_called(this, "_ZN5S48C63v85Ev");}
void  S48C6 ::v86(){vfunc_called(this, "_ZN5S48C63v86Ev");}
void  S48C6 ::v87(){vfunc_called(this, "_ZN5S48C63v87Ev");}
void  S48C6 ::v88(){vfunc_called(this, "_ZN5S48C63v88Ev");}
void  S48C6 ::v89(){vfunc_called(this, "_ZN5S48C63v89Ev");}
void  S48C6 ::v90(){vfunc_called(this, "_ZN5S48C63v90Ev");}
void  S48C6 ::v91(){vfunc_called(this, "_ZN5S48C63v91Ev");}
void  S48C6 ::v92(){vfunc_called(this, "_ZN5S48C63v92Ev");}
void  S48C6 ::v93(){vfunc_called(this, "_ZN5S48C63v93Ev");}
void  S48C6 ::v94(){vfunc_called(this, "_ZN5S48C63v94Ev");}
void  S48C6 ::v95(){vfunc_called(this, "_ZN5S48C63v95Ev");}
void  S48C6 ::v96(){vfunc_called(this, "_ZN5S48C63v96Ev");}
void  S48C6 ::v97(){vfunc_called(this, "_ZN5S48C63v97Ev");}
void  S48C6 ::v98(){vfunc_called(this, "_ZN5S48C63v98Ev");}
void  S48C6 ::v99(){vfunc_called(this, "_ZN5S48C63v99Ev");}
void  S48C6 ::v100(){vfunc_called(this, "_ZN5S48C64v100Ev");}
void  S48C6 ::v101(){vfunc_called(this, "_ZN5S48C64v101Ev");}
void  S48C6 ::v102(){vfunc_called(this, "_ZN5S48C64v102Ev");}
void  S48C6 ::v103(){vfunc_called(this, "_ZN5S48C64v103Ev");}
void  S48C6 ::v104(){vfunc_called(this, "_ZN5S48C64v104Ev");}
void  S48C6 ::v105(){vfunc_called(this, "_ZN5S48C64v105Ev");}
void  S48C6 ::v106(){vfunc_called(this, "_ZN5S48C64v106Ev");}
void  S48C6 ::v107(){vfunc_called(this, "_ZN5S48C64v107Ev");}
void  S48C6 ::v108(){vfunc_called(this, "_ZN5S48C64v108Ev");}
void  S48C6 ::v109(){vfunc_called(this, "_ZN5S48C64v109Ev");}
void  S48C6 ::v110(){vfunc_called(this, "_ZN5S48C64v110Ev");}
void  S48C6 ::v111(){vfunc_called(this, "_ZN5S48C64v111Ev");}
void  S48C6 ::v112(){vfunc_called(this, "_ZN5S48C64v112Ev");}
void  S48C6 ::v113(){vfunc_called(this, "_ZN5S48C64v113Ev");}
void  S48C6 ::v114(){vfunc_called(this, "_ZN5S48C64v114Ev");}
void  S48C6 ::v115(){vfunc_called(this, "_ZN5S48C64v115Ev");}
void  S48C6 ::v116(){vfunc_called(this, "_ZN5S48C64v116Ev");}
void  S48C6 ::v117(){vfunc_called(this, "_ZN5S48C64v117Ev");}
void  S48C6 ::v118(){vfunc_called(this, "_ZN5S48C64v118Ev");}
void  S48C6 ::v119(){vfunc_called(this, "_ZN5S48C64v119Ev");}
void  S48C6 ::v120(){vfunc_called(this, "_ZN5S48C64v120Ev");}
void  S48C6 ::v121(){vfunc_called(this, "_ZN5S48C64v121Ev");}
void  S48C6 ::v122(){vfunc_called(this, "_ZN5S48C64v122Ev");}
void  S48C6 ::v123(){vfunc_called(this, "_ZN5S48C64v123Ev");}
void  S48C6 ::v124(){vfunc_called(this, "_ZN5S48C64v124Ev");}
void  S48C6 ::v125(){vfunc_called(this, "_ZN5S48C64v125Ev");}
void  S48C6 ::v126(){vfunc_called(this, "_ZN5S48C64v126Ev");}
void  S48C6 ::v127(){vfunc_called(this, "_ZN5S48C64v127Ev");}
void  S48C6 ::v128(){vfunc_called(this, "_ZN5S48C64v128Ev");}
void  S48C6 ::v129(){vfunc_called(this, "_ZN5S48C64v129Ev");}
void  S48C6 ::v130(){vfunc_called(this, "_ZN5S48C64v130Ev");}
void  S48C6 ::v131(){vfunc_called(this, "_ZN5S48C64v131Ev");}
void  S48C6 ::v132(){vfunc_called(this, "_ZN5S48C64v132Ev");}
void  S48C6 ::v133(){vfunc_called(this, "_ZN5S48C64v133Ev");}
void  S48C6 ::v134(){vfunc_called(this, "_ZN5S48C64v134Ev");}
void  S48C6 ::v135(){vfunc_called(this, "_ZN5S48C64v135Ev");}
void  S48C6 ::v136(){vfunc_called(this, "_ZN5S48C64v136Ev");}
void  S48C6 ::v137(){vfunc_called(this, "_ZN5S48C64v137Ev");}
void  S48C6 ::v138(){vfunc_called(this, "_ZN5S48C64v138Ev");}
void  S48C6 ::v139(){vfunc_called(this, "_ZN5S48C64v139Ev");}
void  S48C6 ::v140(){vfunc_called(this, "_ZN5S48C64v140Ev");}
void  S48C6 ::v141(){vfunc_called(this, "_ZN5S48C64v141Ev");}
void  S48C6 ::v142(){vfunc_called(this, "_ZN5S48C64v142Ev");}
void  S48C6 ::v143(){vfunc_called(this, "_ZN5S48C64v143Ev");}
void  S48C6 ::v144(){vfunc_called(this, "_ZN5S48C64v144Ev");}
void  S48C6 ::v145(){vfunc_called(this, "_ZN5S48C64v145Ev");}
void  S48C6 ::v146(){vfunc_called(this, "_ZN5S48C64v146Ev");}
void  S48C6 ::v147(){vfunc_called(this, "_ZN5S48C64v147Ev");}
void  S48C6 ::v148(){vfunc_called(this, "_ZN5S48C64v148Ev");}
void  S48C6 ::v149(){vfunc_called(this, "_ZN5S48C64v149Ev");}
void  S48C6 ::v150(){vfunc_called(this, "_ZN5S48C64v150Ev");}
void  S48C6 ::v151(){vfunc_called(this, "_ZN5S48C64v151Ev");}
void  S48C6 ::v152(){vfunc_called(this, "_ZN5S48C64v152Ev");}
void  S48C6 ::v153(){vfunc_called(this, "_ZN5S48C64v153Ev");}
void  S48C6 ::v154(){vfunc_called(this, "_ZN5S48C64v154Ev");}
void  S48C6 ::v155(){vfunc_called(this, "_ZN5S48C64v155Ev");}
void  S48C6 ::v156(){vfunc_called(this, "_ZN5S48C64v156Ev");}
void  S48C6 ::v157(){vfunc_called(this, "_ZN5S48C64v157Ev");}
void  S48C6 ::v158(){vfunc_called(this, "_ZN5S48C64v158Ev");}
void  S48C6 ::v159(){vfunc_called(this, "_ZN5S48C64v159Ev");}
void  S48C6 ::v160(){vfunc_called(this, "_ZN5S48C64v160Ev");}
void  S48C6 ::v161(){vfunc_called(this, "_ZN5S48C64v161Ev");}
void  S48C6 ::v162(){vfunc_called(this, "_ZN5S48C64v162Ev");}
void  S48C6 ::v163(){vfunc_called(this, "_ZN5S48C64v163Ev");}
void  S48C6 ::v164(){vfunc_called(this, "_ZN5S48C64v164Ev");}
void  S48C6 ::v165(){vfunc_called(this, "_ZN5S48C64v165Ev");}
void  S48C6 ::v166(){vfunc_called(this, "_ZN5S48C64v166Ev");}
void  S48C6 ::v167(){vfunc_called(this, "_ZN5S48C64v167Ev");}
void  S48C6 ::v168(){vfunc_called(this, "_ZN5S48C64v168Ev");}
void  S48C6 ::v169(){vfunc_called(this, "_ZN5S48C64v169Ev");}
void  S48C6 ::v170(){vfunc_called(this, "_ZN5S48C64v170Ev");}
void  S48C6 ::v171(){vfunc_called(this, "_ZN5S48C64v171Ev");}
void  S48C6 ::v172(){vfunc_called(this, "_ZN5S48C64v172Ev");}
void  S48C6 ::v173(){vfunc_called(this, "_ZN5S48C64v173Ev");}
void  S48C6 ::v174(){vfunc_called(this, "_ZN5S48C64v174Ev");}
void  S48C6 ::v175(){vfunc_called(this, "_ZN5S48C64v175Ev");}
void  S48C6 ::v176(){vfunc_called(this, "_ZN5S48C64v176Ev");}
void  S48C6 ::v177(){vfunc_called(this, "_ZN5S48C64v177Ev");}
void  S48C6 ::v178(){vfunc_called(this, "_ZN5S48C64v178Ev");}
void  S48C6 ::v179(){vfunc_called(this, "_ZN5S48C64v179Ev");}
void  S48C6 ::v180(){vfunc_called(this, "_ZN5S48C64v180Ev");}
void  S48C6 ::v181(){vfunc_called(this, "_ZN5S48C64v181Ev");}
void  S48C6 ::v182(){vfunc_called(this, "_ZN5S48C64v182Ev");}
void  S48C6 ::v183(){vfunc_called(this, "_ZN5S48C64v183Ev");}
void  S48C6 ::v184(){vfunc_called(this, "_ZN5S48C64v184Ev");}
void  S48C6 ::v185(){vfunc_called(this, "_ZN5S48C64v185Ev");}
void  S48C6 ::v186(){vfunc_called(this, "_ZN5S48C64v186Ev");}
void  S48C6 ::v187(){vfunc_called(this, "_ZN5S48C64v187Ev");}
void  S48C6 ::v188(){vfunc_called(this, "_ZN5S48C64v188Ev");}
void  S48C6 ::v189(){vfunc_called(this, "_ZN5S48C64v189Ev");}
void  S48C6 ::v190(){vfunc_called(this, "_ZN5S48C64v190Ev");}
void  S48C6 ::v191(){vfunc_called(this, "_ZN5S48C64v191Ev");}
void  S48C6 ::v192(){vfunc_called(this, "_ZN5S48C64v192Ev");}
void  S48C6 ::v193(){vfunc_called(this, "_ZN5S48C64v193Ev");}
void  S48C6 ::v194(){vfunc_called(this, "_ZN5S48C64v194Ev");}
void  S48C6 ::v195(){vfunc_called(this, "_ZN5S48C64v195Ev");}
void  S48C6 ::v196(){vfunc_called(this, "_ZN5S48C64v196Ev");}
void  S48C6 ::v197(){vfunc_called(this, "_ZN5S48C64v197Ev");}
void  S48C6 ::v198(){vfunc_called(this, "_ZN5S48C64v198Ev");}
void  S48C6 ::v199(){vfunc_called(this, "_ZN5S48C64v199Ev");}
void  S48C6 ::v200(){vfunc_called(this, "_ZN5S48C64v200Ev");}
void  S48C6 ::v201(){vfunc_called(this, "_ZN5S48C64v201Ev");}
void  S48C6 ::v202(){vfunc_called(this, "_ZN5S48C64v202Ev");}
void  S48C6 ::v203(){vfunc_called(this, "_ZN5S48C64v203Ev");}
void  S48C6 ::v204(){vfunc_called(this, "_ZN5S48C64v204Ev");}
void  S48C6 ::v205(){vfunc_called(this, "_ZN5S48C64v205Ev");}
void  S48C6 ::v206(){vfunc_called(this, "_ZN5S48C64v206Ev");}
void  S48C6 ::v207(){vfunc_called(this, "_ZN5S48C64v207Ev");}
void  S48C6 ::v208(){vfunc_called(this, "_ZN5S48C64v208Ev");}
void  S48C6 ::v209(){vfunc_called(this, "_ZN5S48C64v209Ev");}
void  S48C6 ::v210(){vfunc_called(this, "_ZN5S48C64v210Ev");}
void  S48C6 ::v211(){vfunc_called(this, "_ZN5S48C64v211Ev");}
void  S48C6 ::v212(){vfunc_called(this, "_ZN5S48C64v212Ev");}
void  S48C6 ::v213(){vfunc_called(this, "_ZN5S48C64v213Ev");}
void  S48C6 ::v214(){vfunc_called(this, "_ZN5S48C64v214Ev");}
void  S48C6 ::v215(){vfunc_called(this, "_ZN5S48C64v215Ev");}
void  S48C6 ::v216(){vfunc_called(this, "_ZN5S48C64v216Ev");}
void  S48C6 ::v217(){vfunc_called(this, "_ZN5S48C64v217Ev");}
S48C6 ::S48C6(){ note_ctor("S48C6", this);} // tgen

static void Test_S48C6()
{
  extern Class_Descriptor cd_S48C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(72,110)];
    init_test(&cd_S48C6, buf);
    S48C6 *dp, &lv = *(dp=new (buf) S48C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(568,436), "sizeof(S48C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C6)");
    check_base_class_offset(lv, (S48C7*), 0, "S48C6");
    check_field_offset(lv, s48c6f0, ABISELECT(96,60), "S48C6.s48c6f0");
    check_field_offset(lv, s48c6f1, ABISELECT(112,72), "S48C6.s48c6f1");
    check_field_offset(lv, s48c6f2, ABISELECT(128,84), "S48C6.s48c6f2");
    check_field_offset(lv, s48c6f3, ABISELECT(132,88), "S48C6.s48c6f3");
    check_field_offset(lv, s48c6f4, ABISELECT(136,92), "S48C6.s48c6f4");
    check_field_offset(lv, s48c6f5, ABISELECT(144,96), "S48C6.s48c6f5");
    check_field_offset(lv, s48c6f6, ABISELECT(160,104), "S48C6.s48c6f6");
    set_bf_and_test(lv, s48c6f7, ABISELECT(176,116), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f8, ABISELECT(176,116), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f9, ABISELECT(176,116), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f10, ABISELECT(176,116), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f11, ABISELECT(176,116), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f12, ABISELECT(176,116), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f13, ABISELECT(176,116), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f14, ABISELECT(176,116), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f15, ABISELECT(177,117), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f16, ABISELECT(177,117), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f17, ABISELECT(177,117), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f18, ABISELECT(177,117), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f19, ABISELECT(177,117), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f20, ABISELECT(177,117), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f21, ABISELECT(177,117), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f22, ABISELECT(177,117), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f23, ABISELECT(178,118), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f24, ABISELECT(178,118), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f25, ABISELECT(178,118), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f26, ABISELECT(178,118), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f27, ABISELECT(178,118), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f28, ABISELECT(178,118), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f29, ABISELECT(178,118), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f30, ABISELECT(178,118), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f31, ABISELECT(179,119), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f32, ABISELECT(179,119), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f33, ABISELECT(179,119), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f34, ABISELECT(179,119), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f35, ABISELECT(179,119), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f36, ABISELECT(179,119), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f37, ABISELECT(179,119), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f38, ABISELECT(179,119), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f39, ABISELECT(180,120), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f40, ABISELECT(180,120), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f41, ABISELECT(180,120), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f42, ABISELECT(180,120), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f43, ABISELECT(180,120), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f44, ABISELECT(180,120), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f45, ABISELECT(180,120), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f46, ABISELECT(180,120), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f47, ABISELECT(181,121), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f48, ABISELECT(181,121), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f49, ABISELECT(181,121), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f50, ABISELECT(181,121), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f51, ABISELECT(181,121), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f52, ABISELECT(181,121), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f53, ABISELECT(181,121), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f54, ABISELECT(181,121), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f55, ABISELECT(182,122), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f56, ABISELECT(182,122), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f57, ABISELECT(182,122), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f58, ABISELECT(182,122), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f59, ABISELECT(182,122), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f60, ABISELECT(182,122), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f61, ABISELECT(182,122), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f62, ABISELECT(182,122), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f63, ABISELECT(183,123), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f64, ABISELECT(183,123), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f65, ABISELECT(183,123), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f66, ABISELECT(183,123), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f67, ABISELECT(183,123), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f68, ABISELECT(183,123), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f69, ABISELECT(183,123), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f70, ABISELECT(183,123), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f71, ABISELECT(184,124), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f72, ABISELECT(184,124), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f73, ABISELECT(184,124), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f74, ABISELECT(184,124), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f75, ABISELECT(184,124), 4, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f76, ABISELECT(184,124), 5, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f77, ABISELECT(184,124), 6, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f78, ABISELECT(184,124), 7, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f79, ABISELECT(185,125), 0, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f80, ABISELECT(185,125), 1, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f81, ABISELECT(185,125), 2, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f82, ABISELECT(185,125), 3, 1, 1, "S48C6");
    set_bf_and_test(lv, s48c6f83, ABISELECT(185,125), 4, 1, 1, "S48C6");
    check_field_offset(lv, s48c6f84, ABISELECT(188,128), "S48C6.s48c6f84");
    check_field_offset(lv, s48c6f85, ABISELECT(208,148), "S48C6.s48c6f85");
    check_field_offset(lv, s48c6f86, ABISELECT(224,156), "S48C6.s48c6f86");
    check_field_offset(lv, s48c6f87, ABISELECT(236,168), "S48C6.s48c6f87");
    check_field_offset(lv, s48c6f88, ABISELECT(244,176), "S48C6.s48c6f88");
    check_field_offset(lv, s48c6f89, ABISELECT(252,184), "S48C6.s48c6f89");
    check_field_offset(lv, s48c6f90, ABISELECT(264,192), "S48C6.s48c6f90");
    check_field_offset(lv, s48c6f91, ABISELECT(280,204), "S48C6.s48c6f91");
    check_field_offset(lv, s48c6f92, ABISELECT(296,216), "S48C6.s48c6f92");
    check_field_offset(lv, s48c6f93, ABISELECT(304,220), "S48C6.s48c6f93");
    check_field_offset(lv, s48c6f94, ABISELECT(320,228), "S48C6.s48c6f94");
    check_field_offset(lv, s48c6f95, ABISELECT(332,240), "S48C6.s48c6f95");
    check_field_offset(lv, s48c6f96, ABISELECT(344,252), "S48C6.s48c6f96");
    check_field_offset(lv, s48c6f97, ABISELECT(356,264), "S48C6.s48c6f97");
    check_field_offset(lv, s48c6f98, ABISELECT(368,276), "S48C6.s48c6f98");
    check_field_offset(lv, s48c6f99, ABISELECT(376,280), "S48C6.s48c6f99");
    check_field_offset(lv, s48c6f100, ABISELECT(384,288), "S48C6.s48c6f100");
    check_field_offset(lv, s48c6f101, ABISELECT(400,300), "S48C6.s48c6f101");
    check_field_offset(lv, s48c6f102, ABISELECT(412,312), "S48C6.s48c6f102");
    check_field_offset(lv, s48c6f103, ABISELECT(424,324), "S48C6.s48c6f103");
    check_field_offset(lv, s48c6f104, ABISELECT(428,328), "S48C6.s48c6f104");
    check_field_offset(lv, s48c6f105, ABISELECT(440,340), "S48C6.s48c6f105");
    check_field_offset(lv, s48c6f106, ABISELECT(456,352), "S48C6.s48c6f106");
    check_field_offset(lv, s48c6f107, ABISELECT(464,356), "S48C6.s48c6f107");
    check_field_offset(lv, s48c6f108, ABISELECT(468,360), "S48C6.s48c6f108");
    check_field_offset(lv, s48c6f109, ABISELECT(472,364), "S48C6.s48c6f109");
    check_field_offset(lv, s48c6f110, ABISELECT(484,376), "S48C6.s48c6f110");
    check_field_offset(lv, s48c6f111, ABISELECT(496,388), "S48C6.s48c6f111");
    check_field_offset(lv, s48c6f112, ABISELECT(504,392), "S48C6.s48c6f112");
    check_field_offset(lv, s48c6f113, ABISELECT(512,396), "S48C6.s48c6f113");
    check_field_offset(lv, s48c6f114, ABISELECT(520,400), "S48C6.s48c6f114");
    check_field_offset(lv, s48c6f115, ABISELECT(536,412), "S48C6.s48c6f115");
    check_field_offset(lv, s48c6f116, ABISELECT(552,424), "S48C6.s48c6f116");
    test_class_info(&lv, &cd_S48C6);
    dp->~S48C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C6(Test_S48C6, "S48C6", ABISELECT(568,436));

#else // __cplusplus

extern void _ZN5S48C6C1Ev();
extern void _ZN5S48C6D1Ev();
Name_Map name_map_S48C6[] = {
  NSPAIR(_ZN5S48C6C1Ev),
  NSPAIR(_ZN5S48C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S48C7;
extern VTBL_ENTRY _ZTI5S48C7[];
extern  VTBL_ENTRY _ZTV5S48C7[];
static Base_Class bases_S48C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S48C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S48C6[];
extern void _ZN5S48C6D1Ev();
extern void _ZN5S48C6D0Ev();
extern void _ZN5S48C73v11Ev();
extern void _ZN5S48C73v12Ev();
extern void _ZN5S48C73v13Ev();
extern void _ZN5S48C73v14Ev();
extern void _ZN5S48C73v15Ev();
extern void _ZN5S48C73v16Ev();
extern void _ZN5S48C73v17Ev();
extern void _ZN5S48C73v18Ev();
extern void _ZN5S48C73v19Ev();
extern void _ZN5S48C73v20Ev();
extern void _ZN5S48C73v21Ev();
extern void _ZN5S48C73v22Ev();
extern void _ZN5S48C73v23Ev();
extern void _ZN5S48C73v24Ev();
extern void _ZN5S48C73v25Ev();
extern void _ZN5S48C73v26Ev();
extern void _ZN5S48C73v27Ev();
extern void _ZN5S48C73v28Ev();
extern void _ZN5S48C73v29Ev();
extern void _ZN5S48C73v30Ev();
extern void _ZN5S48C73v31Ev();
extern void _ZN5S48C73v32Ev();
extern void _ZN5S48C73v33Ev();
extern void _ZN5S48C73v34Ev();
extern void _ZN5S48C73v35Ev();
extern void _ZN5S48C73v36Ev();
extern void _ZN5S48C73v37Ev();
extern void _ZN5S48C73v38Ev();
extern void _ZN5S48C73v39Ev();
extern void _ZN5S48C73v40Ev();
extern void _ZN5S48C73v41Ev();
extern void _ZN5S48C73v42Ev();
extern void _ZN5S48C73v43Ev();
extern void _ZN5S48C73v44Ev();
extern void _ZN5S48C73v45Ev();
extern void _ZN5S48C73v46Ev();
extern void _ZN5S48C73v47Ev();
extern void _ZN5S48C73v48Ev();
extern void _ZN5S48C73v49Ev();
extern void _ZN5S48C73v50Ev();
extern void _ZN5S48C73v51Ev();
extern void _ZN5S48C73v52Ev();
extern void _ZN5S48C73v53Ev();
extern void _ZN5S48C73v54Ev();
extern void _ZN5S48C73v55Ev();
extern void _ZN5S48C73v56Ev();
extern void _ZN5S48C73v57Ev();
extern void _ZN5S48C73v58Ev();
extern void _ZN5S48C73v59Ev();
extern void _ZN5S48C73v60Ev();
extern void _ZN5S48C73v61Ev();
extern void _ZN5S48C73v62Ev();
extern void _ZN5S48C73v63Ev();
extern void _ZN5S48C73v64Ev();
extern void _ZN5S48C73v65Ev();
extern void _ZN5S48C73v66Ev();
extern void _ZN5S48C73v67Ev();
extern void _ZN5S48C73v68Ev();
extern void _ZN5S48C73v69Ev();
extern void _ZN5S48C73v70Ev();
extern void _ZN5S48C73v71Ev();
extern void _ZN5S48C73v72Ev();
extern void _ZN5S48C73v73Ev();
extern void _ZN5S48C73v74Ev();
extern void _ZN5S48C63v75Ev();
extern void _ZN5S48C63v76Ev();
extern void _ZN5S48C63v77Ev();
extern void _ZN5S48C63v78Ev();
extern void _ZN5S48C63v79Ev();
extern void _ZN5S48C63v80Ev();
extern void _ZN5S48C63v81Ev();
extern void _ZN5S48C63v82Ev();
extern void _ZN5S48C63v83Ev();
extern void _ZN5S48C63v84Ev();
extern void _ZN5S48C63v85Ev();
extern void _ZN5S48C63v86Ev();
extern void _ZN5S48C63v87Ev();
extern void _ZN5S48C63v88Ev();
extern void _ZN5S48C63v89Ev();
extern void _ZN5S48C63v90Ev();
extern void _ZN5S48C63v91Ev();
extern void _ZN5S48C63v92Ev();
extern void _ZN5S48C63v93Ev();
extern void _ZN5S48C63v94Ev();
extern void _ZN5S48C63v95Ev();
extern void _ZN5S48C63v96Ev();
extern void _ZN5S48C63v97Ev();
extern void _ZN5S48C63v98Ev();
extern void _ZN5S48C63v99Ev();
extern void _ZN5S48C64v100Ev();
extern void _ZN5S48C64v101Ev();
extern void _ZN5S48C64v102Ev();
extern void _ZN5S48C64v103Ev();
extern void _ZN5S48C64v104Ev();
extern void _ZN5S48C64v105Ev();
extern void _ZN5S48C64v106Ev();
extern void _ZN5S48C64v107Ev();
extern void _ZN5S48C64v108Ev();
extern void _ZN5S48C64v109Ev();
extern void _ZN5S48C64v110Ev();
extern void _ZN5S48C64v111Ev();
extern void _ZN5S48C64v112Ev();
extern void _ZN5S48C64v113Ev();
extern void _ZN5S48C64v114Ev();
extern void _ZN5S48C64v115Ev();
extern void _ZN5S48C64v116Ev();
extern void _ZN5S48C64v117Ev();
extern void _ZN5S48C64v118Ev();
extern void _ZN5S48C64v119Ev();
extern void _ZN5S48C64v120Ev();
extern void _ZN5S48C64v121Ev();
extern void _ZN5S48C64v122Ev();
extern void _ZN5S48C64v123Ev();
extern void _ZN5S48C64v124Ev();
extern void _ZN5S48C64v125Ev();
extern void _ZN5S48C64v126Ev();
extern void _ZN5S48C64v127Ev();
extern void _ZN5S48C64v128Ev();
extern void _ZN5S48C64v129Ev();
extern void _ZN5S48C64v130Ev();
extern void _ZN5S48C64v131Ev();
extern void _ZN5S48C64v132Ev();
extern void _ZN5S48C64v133Ev();
extern void _ZN5S48C64v134Ev();
extern void _ZN5S48C64v135Ev();
extern void _ZN5S48C64v136Ev();
extern void _ZN5S48C64v137Ev();
extern void _ZN5S48C64v138Ev();
extern void _ZN5S48C64v139Ev();
extern void _ZN5S48C64v140Ev();
extern void _ZN5S48C64v141Ev();
extern void _ZN5S48C64v142Ev();
extern void _ZN5S48C64v143Ev();
extern void _ZN5S48C64v144Ev();
extern void _ZN5S48C64v145Ev();
extern void _ZN5S48C64v146Ev();
extern void _ZN5S48C64v147Ev();
extern void _ZN5S48C64v148Ev();
extern void _ZN5S48C64v149Ev();
extern void _ZN5S48C64v150Ev();
extern void _ZN5S48C64v151Ev();
extern void _ZN5S48C64v152Ev();
extern void _ZN5S48C64v153Ev();
extern void _ZN5S48C64v154Ev();
extern void _ZN5S48C64v155Ev();
extern void _ZN5S48C64v156Ev();
extern void _ZN5S48C64v157Ev();
extern void _ZN5S48C64v158Ev();
extern void _ZN5S48C64v159Ev();
extern void _ZN5S48C64v160Ev();
extern void _ZN5S48C64v161Ev();
extern void _ZN5S48C64v162Ev();
extern void _ZN5S48C64v163Ev();
extern void _ZN5S48C64v164Ev();
extern void _ZN5S48C64v165Ev();
extern void _ZN5S48C64v166Ev();
extern void _ZN5S48C64v167Ev();
extern void _ZN5S48C64v168Ev();
extern void _ZN5S48C64v169Ev();
extern void _ZN5S48C64v170Ev();
extern void _ZN5S48C64v171Ev();
extern void _ZN5S48C64v172Ev();
extern void _ZN5S48C64v173Ev();
extern void _ZN5S48C64v174Ev();
extern void _ZN5S48C64v175Ev();
extern void _ZN5S48C64v176Ev();
extern void _ZN5S48C64v177Ev();
extern void _ZN5S48C64v178Ev();
extern void _ZN5S48C64v179Ev();
extern void _ZN5S48C64v180Ev();
extern void _ZN5S48C64v181Ev();
extern void _ZN5S48C64v182Ev();
extern void _ZN5S48C64v183Ev();
extern void _ZN5S48C64v184Ev();
extern void _ZN5S48C64v185Ev();
extern void _ZN5S48C64v186Ev();
extern void _ZN5S48C64v187Ev();
extern void _ZN5S48C64v188Ev();
extern void _ZN5S48C64v189Ev();
extern void _ZN5S48C64v190Ev();
extern void _ZN5S48C64v191Ev();
extern void _ZN5S48C64v192Ev();
extern void _ZN5S48C64v193Ev();
extern void _ZN5S48C64v194Ev();
extern void _ZN5S48C64v195Ev();
extern void _ZN5S48C64v196Ev();
extern void _ZN5S48C64v197Ev();
extern void _ZN5S48C64v198Ev();
extern void _ZN5S48C64v199Ev();
extern void _ZN5S48C64v200Ev();
extern void _ZN5S48C64v201Ev();
extern void _ZN5S48C64v202Ev();
extern void _ZN5S48C64v203Ev();
extern void _ZN5S48C64v204Ev();
extern void _ZN5S48C64v205Ev();
extern void _ZN5S48C64v206Ev();
extern void _ZN5S48C64v207Ev();
extern void _ZN5S48C64v208Ev();
extern void _ZN5S48C64v209Ev();
extern void _ZN5S48C64v210Ev();
extern void _ZN5S48C64v211Ev();
extern void _ZN5S48C64v212Ev();
extern void _ZN5S48C64v213Ev();
extern void _ZN5S48C64v214Ev();
extern void _ZN5S48C64v215Ev();
extern void _ZN5S48C64v216Ev();
extern void _ZN5S48C64v217Ev();
static  VTBL_ENTRY vtc_S48C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S48C6[0]),
  (VTBL_ENTRY)&_ZN5S48C6D1Ev,
  (VTBL_ENTRY)&_ZN5S48C6D0Ev,
  (VTBL_ENTRY)&_ZN5S48C73v11Ev,
  (VTBL_ENTRY)&_ZN5S48C73v12Ev,
  (VTBL_ENTRY)&_ZN5S48C73v13Ev,
  (VTBL_ENTRY)&_ZN5S48C73v14Ev,
  (VTBL_ENTRY)&_ZN5S48C73v15Ev,
  (VTBL_ENTRY)&_ZN5S48C73v16Ev,
  (VTBL_ENTRY)&_ZN5S48C73v17Ev,
  (VTBL_ENTRY)&_ZN5S48C73v18Ev,
  (VTBL_ENTRY)&_ZN5S48C73v19Ev,
  (VTBL_ENTRY)&_ZN5S48C73v20Ev,
  (VTBL_ENTRY)&_ZN5S48C73v21Ev,
  (VTBL_ENTRY)&_ZN5S48C73v22Ev,
  (VTBL_ENTRY)&_ZN5S48C73v23Ev,
  (VTBL_ENTRY)&_ZN5S48C73v24Ev,
  (VTBL_ENTRY)&_ZN5S48C73v25Ev,
  (VTBL_ENTRY)&_ZN5S48C73v26Ev,
  (VTBL_ENTRY)&_ZN5S48C73v27Ev,
  (VTBL_ENTRY)&_ZN5S48C73v28Ev,
  (VTBL_ENTRY)&_ZN5S48C73v29Ev,
  (VTBL_ENTRY)&_ZN5S48C73v30Ev,
  (VTBL_ENTRY)&_ZN5S48C73v31Ev,
  (VTBL_ENTRY)&_ZN5S48C73v32Ev,
  (VTBL_ENTRY)&_ZN5S48C73v33Ev,
  (VTBL_ENTRY)&_ZN5S48C73v34Ev,
  (VTBL_ENTRY)&_ZN5S48C73v35Ev,
  (VTBL_ENTRY)&_ZN5S48C73v36Ev,
  (VTBL_ENTRY)&_ZN5S48C73v37Ev,
  (VTBL_ENTRY)&_ZN5S48C73v38Ev,
  (VTBL_ENTRY)&_ZN5S48C73v39Ev,
  (VTBL_ENTRY)&_ZN5S48C73v40Ev,
  (VTBL_ENTRY)&_ZN5S48C73v41Ev,
  (VTBL_ENTRY)&_ZN5S48C73v42Ev,
  (VTBL_ENTRY)&_ZN5S48C73v43Ev,
  (VTBL_ENTRY)&_ZN5S48C73v44Ev,
  (VTBL_ENTRY)&_ZN5S48C73v45Ev,
  (VTBL_ENTRY)&_ZN5S48C73v46Ev,
  (VTBL_ENTRY)&_ZN5S48C73v47Ev,
  (VTBL_ENTRY)&_ZN5S48C73v48Ev,
  (VTBL_ENTRY)&_ZN5S48C73v49Ev,
  (VTBL_ENTRY)&_ZN5S48C73v50Ev,
  (VTBL_ENTRY)&_ZN5S48C73v51Ev,
  (VTBL_ENTRY)&_ZN5S48C73v52Ev,
  (VTBL_ENTRY)&_ZN5S48C73v53Ev,
  (VTBL_ENTRY)&_ZN5S48C73v54Ev,
  (VTBL_ENTRY)&_ZN5S48C73v55Ev,
  (VTBL_ENTRY)&_ZN5S48C73v56Ev,
  (VTBL_ENTRY)&_ZN5S48C73v57Ev,
  (VTBL_ENTRY)&_ZN5S48C73v58Ev,
  (VTBL_ENTRY)&_ZN5S48C73v59Ev,
  (VTBL_ENTRY)&_ZN5S48C73v60Ev,
  (VTBL_ENTRY)&_ZN5S48C73v61Ev,
  (VTBL_ENTRY)&_ZN5S48C73v62Ev,
  (VTBL_ENTRY)&_ZN5S48C73v63Ev,
  (VTBL_ENTRY)&_ZN5S48C73v64Ev,
  (VTBL_ENTRY)&_ZN5S48C73v65Ev,
  (VTBL_ENTRY)&_ZN5S48C73v66Ev,
  (VTBL_ENTRY)&_ZN5S48C73v67Ev,
  (VTBL_ENTRY)&_ZN5S48C73v68Ev,
  (VTBL_ENTRY)&_ZN5S48C73v69Ev,
  (VTBL_ENTRY)&_ZN5S48C73v70Ev,
  (VTBL_ENTRY)&_ZN5S48C73v71Ev,
  (VTBL_ENTRY)&_ZN5S48C73v72Ev,
  (VTBL_ENTRY)&_ZN5S48C73v73Ev,
  (VTBL_ENTRY)&_ZN5S48C73v74Ev,
  (VTBL_ENTRY)&_ZN5S48C63v75Ev,
  (VTBL_ENTRY)&_ZN5S48C63v76Ev,
  (VTBL_ENTRY)&_ZN5S48C63v77Ev,
  (VTBL_ENTRY)&_ZN5S48C63v78Ev,
  (VTBL_ENTRY)&_ZN5S48C63v79Ev,
  (VTBL_ENTRY)&_ZN5S48C63v80Ev,
  (VTBL_ENTRY)&_ZN5S48C63v81Ev,
  (VTBL_ENTRY)&_ZN5S48C63v82Ev,
  (VTBL_ENTRY)&_ZN5S48C63v83Ev,
  (VTBL_ENTRY)&_ZN5S48C63v84Ev,
  (VTBL_ENTRY)&_ZN5S48C63v85Ev,
  (VTBL_ENTRY)&_ZN5S48C63v86Ev,
  (VTBL_ENTRY)&_ZN5S48C63v87Ev,
  (VTBL_ENTRY)&_ZN5S48C63v88Ev,
  (VTBL_ENTRY)&_ZN5S48C63v89Ev,
  (VTBL_ENTRY)&_ZN5S48C63v90Ev,
  (VTBL_ENTRY)&_ZN5S48C63v91Ev,
  (VTBL_ENTRY)&_ZN5S48C63v92Ev,
  (VTBL_ENTRY)&_ZN5S48C63v93Ev,
  (VTBL_ENTRY)&_ZN5S48C63v94Ev,
  (VTBL_ENTRY)&_ZN5S48C63v95Ev,
  (VTBL_ENTRY)&_ZN5S48C63v96Ev,
  (VTBL_ENTRY)&_ZN5S48C63v97Ev,
  (VTBL_ENTRY)&_ZN5S48C63v98Ev,
  (VTBL_ENTRY)&_ZN5S48C63v99Ev,
  (VTBL_ENTRY)&_ZN5S48C64v100Ev,
  (VTBL_ENTRY)&_ZN5S48C64v101Ev,
  (VTBL_ENTRY)&_ZN5S48C64v102Ev,
  (VTBL_ENTRY)&_ZN5S48C64v103Ev,
  (VTBL_ENTRY)&_ZN5S48C64v104Ev,
  (VTBL_ENTRY)&_ZN5S48C64v105Ev,
  (VTBL_ENTRY)&_ZN5S48C64v106Ev,
  (VTBL_ENTRY)&_ZN5S48C64v107Ev,
  (VTBL_ENTRY)&_ZN5S48C64v108Ev,
  (VTBL_ENTRY)&_ZN5S48C64v109Ev,
  (VTBL_ENTRY)&_ZN5S48C64v110Ev,
  (VTBL_ENTRY)&_ZN5S48C64v111Ev,
  (VTBL_ENTRY)&_ZN5S48C64v112Ev,
  (VTBL_ENTRY)&_ZN5S48C64v113Ev,
  (VTBL_ENTRY)&_ZN5S48C64v114Ev,
  (VTBL_ENTRY)&_ZN5S48C64v115Ev,
  (VTBL_ENTRY)&_ZN5S48C64v116Ev,
  (VTBL_ENTRY)&_ZN5S48C64v117Ev,
  (VTBL_ENTRY)&_ZN5S48C64v118Ev,
  (VTBL_ENTRY)&_ZN5S48C64v119Ev,
  (VTBL_ENTRY)&_ZN5S48C64v120Ev,
  (VTBL_ENTRY)&_ZN5S48C64v121Ev,
  (VTBL_ENTRY)&_ZN5S48C64v122Ev,
  (VTBL_ENTRY)&_ZN5S48C64v123Ev,
  (VTBL_ENTRY)&_ZN5S48C64v124Ev,
  (VTBL_ENTRY)&_ZN5S48C64v125Ev,
  (VTBL_ENTRY)&_ZN5S48C64v126Ev,
  (VTBL_ENTRY)&_ZN5S48C64v127Ev,
  (VTBL_ENTRY)&_ZN5S48C64v128Ev,
  (VTBL_ENTRY)&_ZN5S48C64v129Ev,
  (VTBL_ENTRY)&_ZN5S48C64v130Ev,
  (VTBL_ENTRY)&_ZN5S48C64v131Ev,
  (VTBL_ENTRY)&_ZN5S48C64v132Ev,
  (VTBL_ENTRY)&_ZN5S48C64v133Ev,
  (VTBL_ENTRY)&_ZN5S48C64v134Ev,
  (VTBL_ENTRY)&_ZN5S48C64v135Ev,
  (VTBL_ENTRY)&_ZN5S48C64v136Ev,
  (VTBL_ENTRY)&_ZN5S48C64v137Ev,
  (VTBL_ENTRY)&_ZN5S48C64v138Ev,
  (VTBL_ENTRY)&_ZN5S48C64v139Ev,
  (VTBL_ENTRY)&_ZN5S48C64v140Ev,
  (VTBL_ENTRY)&_ZN5S48C64v141Ev,
  (VTBL_ENTRY)&_ZN5S48C64v142Ev,
  (VTBL_ENTRY)&_ZN5S48C64v143Ev,
  (VTBL_ENTRY)&_ZN5S48C64v144Ev,
  (VTBL_ENTRY)&_ZN5S48C64v145Ev,
  (VTBL_ENTRY)&_ZN5S48C64v146Ev,
  (VTBL_ENTRY)&_ZN5S48C64v147Ev,
  (VTBL_ENTRY)&_ZN5S48C64v148Ev,
  (VTBL_ENTRY)&_ZN5S48C64v149Ev,
  (VTBL_ENTRY)&_ZN5S48C64v150Ev,
  (VTBL_ENTRY)&_ZN5S48C64v151Ev,
  (VTBL_ENTRY)&_ZN5S48C64v152Ev,
  (VTBL_ENTRY)&_ZN5S48C64v153Ev,
  (VTBL_ENTRY)&_ZN5S48C64v154Ev,
  (VTBL_ENTRY)&_ZN5S48C64v155Ev,
  (VTBL_ENTRY)&_ZN5S48C64v156Ev,
  (VTBL_ENTRY)&_ZN5S48C64v157Ev,
  (VTBL_ENTRY)&_ZN5S48C64v158Ev,
  (VTBL_ENTRY)&_ZN5S48C64v159Ev,
  (VTBL_ENTRY)&_ZN5S48C64v160Ev,
  (VTBL_ENTRY)&_ZN5S48C64v161Ev,
  (VTBL_ENTRY)&_ZN5S48C64v162Ev,
  (VTBL_ENTRY)&_ZN5S48C64v163Ev,
  (VTBL_ENTRY)&_ZN5S48C64v164Ev,
  (VTBL_ENTRY)&_ZN5S48C64v165Ev,
  (VTBL_ENTRY)&_ZN5S48C64v166Ev,
  (VTBL_ENTRY)&_ZN5S48C64v167Ev,
  (VTBL_ENTRY)&_ZN5S48C64v168Ev,
  (VTBL_ENTRY)&_ZN5S48C64v169Ev,
  (VTBL_ENTRY)&_ZN5S48C64v170Ev,
  (VTBL_ENTRY)&_ZN5S48C64v171Ev,
  (VTBL_ENTRY)&_ZN5S48C64v172Ev,
  (VTBL_ENTRY)&_ZN5S48C64v173Ev,
  (VTBL_ENTRY)&_ZN5S48C64v174Ev,
  (VTBL_ENTRY)&_ZN5S48C64v175Ev,
  (VTBL_ENTRY)&_ZN5S48C64v176Ev,
  (VTBL_ENTRY)&_ZN5S48C64v177Ev,
  (VTBL_ENTRY)&_ZN5S48C64v178Ev,
  (VTBL_ENTRY)&_ZN5S48C64v179Ev,
  (VTBL_ENTRY)&_ZN5S48C64v180Ev,
  (VTBL_ENTRY)&_ZN5S48C64v181Ev,
  (VTBL_ENTRY)&_ZN5S48C64v182Ev,
  (VTBL_ENTRY)&_ZN5S48C64v183Ev,
  (VTBL_ENTRY)&_ZN5S48C64v184Ev,
  (VTBL_ENTRY)&_ZN5S48C64v185Ev,
  (VTBL_ENTRY)&_ZN5S48C64v186Ev,
  (VTBL_ENTRY)&_ZN5S48C64v187Ev,
  (VTBL_ENTRY)&_ZN5S48C64v188Ev,
  (VTBL_ENTRY)&_ZN5S48C64v189Ev,
  (VTBL_ENTRY)&_ZN5S48C64v190Ev,
  (VTBL_ENTRY)&_ZN5S48C64v191Ev,
  (VTBL_ENTRY)&_ZN5S48C64v192Ev,
  (VTBL_ENTRY)&_ZN5S48C64v193Ev,
  (VTBL_ENTRY)&_ZN5S48C64v194Ev,
  (VTBL_ENTRY)&_ZN5S48C64v195Ev,
  (VTBL_ENTRY)&_ZN5S48C64v196Ev,
  (VTBL_ENTRY)&_ZN5S48C64v197Ev,
  (VTBL_ENTRY)&_ZN5S48C64v198Ev,
  (VTBL_ENTRY)&_ZN5S48C64v199Ev,
  (VTBL_ENTRY)&_ZN5S48C64v200Ev,
  (VTBL_ENTRY)&_ZN5S48C64v201Ev,
  (VTBL_ENTRY)&_ZN5S48C64v202Ev,
  (VTBL_ENTRY)&_ZN5S48C64v203Ev,
  (VTBL_ENTRY)&_ZN5S48C64v204Ev,
  (VTBL_ENTRY)&_ZN5S48C64v205Ev,
  (VTBL_ENTRY)&_ZN5S48C64v206Ev,
  (VTBL_ENTRY)&_ZN5S48C64v207Ev,
  (VTBL_ENTRY)&_ZN5S48C64v208Ev,
  (VTBL_ENTRY)&_ZN5S48C64v209Ev,
  (VTBL_ENTRY)&_ZN5S48C64v210Ev,
  (VTBL_ENTRY)&_ZN5S48C64v211Ev,
  (VTBL_ENTRY)&_ZN5S48C64v212Ev,
  (VTBL_ENTRY)&_ZN5S48C64v213Ev,
  (VTBL_ENTRY)&_ZN5S48C64v214Ev,
  (VTBL_ENTRY)&_ZN5S48C64v215Ev,
  (VTBL_ENTRY)&_ZN5S48C64v216Ev,
  (VTBL_ENTRY)&_ZN5S48C64v217Ev,
};
extern VTBL_ENTRY _ZTI5S48C6[];
extern  VTBL_ENTRY _ZTV5S48C6[];
Class_Descriptor cd_S48C6 = {  "S48C6", // class name
  bases_S48C6, 1,
  &(vtc_S48C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI5S48C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S48C6),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C5  : S48C6 {
  void *s48c5f0[2];
  int s48c5f1;
  void *s48c5f2;
  unsigned int s48c5f3:1;
  unsigned int s48c5f4:1;
  unsigned int s48c5f5:1;
  unsigned int s48c5f6:1;
  unsigned int s48c5f7:1;
  unsigned int s48c5f8:1;
  unsigned int s48c5f9:1;
  unsigned int s48c5f10:1;
  unsigned int s48c5f11:1;
  unsigned int s48c5f12:1;
  unsigned int s48c5f13:1;
  unsigned int s48c5f14:1;
  unsigned int s48c5f15:1;
  unsigned int s48c5f16:1;
  unsigned int s48c5f17:1;
  unsigned int s48c5f18:1;
  unsigned int s48c5f19:1;
  unsigned int s48c5f20:1;
  unsigned int s48c5f21:1;
  char s48c5f22;
  int s48c5f23[2];
  void *s48c5f24;
  ::S28C18_nt s48c5f25;
  ::S28C18_nt s48c5f26;
  void *s48c5f27[5];
  ::S28C18_nt s48c5f28;
  void *s48c5f29;
  ::S28C26 s48c5f30;
  void *s48c5f31[2];
  ::S28C18_nt s48c5f32;
  void *s48c5f33;
  int s48c5f34[2];
  void *s48c5f35;
  int s48c5f36;
  ::S28C18_nt s48c5f37;
  ::S28C18_nt s48c5f38;
  ::S28C18_nt s48c5f39;
  void *s48c5f40[2];
  int s48c5f41;
  ::S28C18_nt s48c5f42;
  int s48c5f43[4];
  void *s48c5f44[2];
  ::S28C22 s48c5f45;
  int s48c5f46;
  ::S48C18 s48c5f47;
  virtual  ~S48C5(); // _ZN5S48C5D1Ev
  virtual void  v218(); // _ZN5S48C54v218Ev
  virtual void  v219(); // _ZN5S48C54v219Ev
  virtual void  v220(); // _ZN5S48C54v220Ev
  virtual void  v221(); // _ZN5S48C54v221Ev
  virtual void  v222(); // _ZN5S48C54v222Ev
  virtual void  v223(); // _ZN5S48C54v223Ev
  virtual void  v224(); // _ZN5S48C54v224Ev
  virtual void  v225(); // _ZN5S48C54v225Ev
  virtual void  v226(); // _ZN5S48C54v226Ev
  virtual void  v227(); // _ZN5S48C54v227Ev
  virtual void  v228(); // _ZN5S48C54v228Ev
  virtual void  v229(); // _ZN5S48C54v229Ev
  virtual void  v230(); // _ZN5S48C54v230Ev
  virtual void  v231(); // _ZN5S48C54v231Ev
  virtual void  v232(); // _ZN5S48C54v232Ev
  virtual void  v233(); // _ZN5S48C54v233Ev
  virtual void  v234(); // _ZN5S48C54v234Ev
  virtual void  v235(); // _ZN5S48C54v235Ev
  virtual void  v236(); // _ZN5S48C54v236Ev
  virtual void  v237(); // _ZN5S48C54v237Ev
  virtual void  v238(); // _ZN5S48C54v238Ev
  virtual void  v239(); // _ZN5S48C54v239Ev
  virtual void  v240(); // _ZN5S48C54v240Ev
  virtual void  v241(); // _ZN5S48C54v241Ev
  virtual void  v242(); // _ZN5S48C54v242Ev
  virtual void  v243(); // _ZN5S48C54v243Ev
  virtual void  v244(); // _ZN5S48C54v244Ev
  virtual void  v245(); // _ZN5S48C54v245Ev
  virtual void  v246(); // _ZN5S48C54v246Ev
  virtual void  v247(); // _ZN5S48C54v247Ev
  virtual void  v248(); // _ZN5S48C54v248Ev
  virtual void  v249(); // _ZN5S48C54v249Ev
  virtual void  v250(); // _ZN5S48C54v250Ev
  virtual void  v251(); // _ZN5S48C54v251Ev
  virtual void  v252(); // _ZN5S48C54v252Ev
  virtual void  v253(); // _ZN5S48C54v253Ev
  virtual void  v254(); // _ZN5S48C54v254Ev
  virtual void  v255(); // _ZN5S48C54v255Ev
  virtual void  v256(); // _ZN5S48C54v256Ev
  virtual void  v257(); // _ZN5S48C54v257Ev
  virtual void  v258(); // _ZN5S48C54v258Ev
  virtual void  v259(); // _ZN5S48C54v259Ev
  virtual void  v260(); // _ZN5S48C54v260Ev
  virtual void  v261(); // _ZN5S48C54v261Ev
  virtual void  v262(); // _ZN5S48C54v262Ev
  virtual void  v263(); // _ZN5S48C54v263Ev
  virtual void  v264(); // _ZN5S48C54v264Ev
  virtual void  v265(); // _ZN5S48C54v265Ev
  virtual void  v266(); // _ZN5S48C54v266Ev
  virtual void  v267(); // _ZN5S48C54v267Ev
  S48C5(); // tgen
};
//SIG(-1 S48C5) C1{ BC2{ BC3{ vd v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC9{ BC10{ BC7}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC11{ BC12{ BC7}} FC11 Fi Fp[2] FC13{ m Fi[3]} FC14{ m Fi[3]} FC13 FC13 Fp FC4 FC11 FC13 FC14 Fi FC13 FC13 Fp Fi Fc FC14 FC14 Fp Fi Fp FC15{ BC16{ BC7}} FC17{ BC18{ BC7}} FC19{ BC20{ BC7}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC13 FC13 Fp[5] FC13 Fp FC21{ BC22{ BC7}} Fp[2] FC13 Fp Fi[2] Fp Fi FC13 FC13 FC13 Fp[2] Fi FC13 Fi[4] Fp[2] FC23{ BC24{ BC7}} Fi FC14}


 S48C5 ::~S48C5(){ note_dtor("S48C5", this);}
void  S48C5 ::v218(){vfunc_called(this, "_ZN5S48C54v218Ev");}
void  S48C5 ::v219(){vfunc_called(this, "_ZN5S48C54v219Ev");}
void  S48C5 ::v220(){vfunc_called(this, "_ZN5S48C54v220Ev");}
void  S48C5 ::v221(){vfunc_called(this, "_ZN5S48C54v221Ev");}
void  S48C5 ::v222(){vfunc_called(this, "_ZN5S48C54v222Ev");}
void  S48C5 ::v223(){vfunc_called(this, "_ZN5S48C54v223Ev");}
void  S48C5 ::v224(){vfunc_called(this, "_ZN5S48C54v224Ev");}
void  S48C5 ::v225(){vfunc_called(this, "_ZN5S48C54v225Ev");}
void  S48C5 ::v226(){vfunc_called(this, "_ZN5S48C54v226Ev");}
void  S48C5 ::v227(){vfunc_called(this, "_ZN5S48C54v227Ev");}
void  S48C5 ::v228(){vfunc_called(this, "_ZN5S48C54v228Ev");}
void  S48C5 ::v229(){vfunc_called(this, "_ZN5S48C54v229Ev");}
void  S48C5 ::v230(){vfunc_called(this, "_ZN5S48C54v230Ev");}
void  S48C5 ::v231(){vfunc_called(this, "_ZN5S48C54v231Ev");}
void  S48C5 ::v232(){vfunc_called(this, "_ZN5S48C54v232Ev");}
void  S48C5 ::v233(){vfunc_called(this, "_ZN5S48C54v233Ev");}
void  S48C5 ::v234(){vfunc_called(this, "_ZN5S48C54v234Ev");}
void  S48C5 ::v235(){vfunc_called(this, "_ZN5S48C54v235Ev");}
void  S48C5 ::v236(){vfunc_called(this, "_ZN5S48C54v236Ev");}
void  S48C5 ::v237(){vfunc_called(this, "_ZN5S48C54v237Ev");}
void  S48C5 ::v238(){vfunc_called(this, "_ZN5S48C54v238Ev");}
void  S48C5 ::v239(){vfunc_called(this, "_ZN5S48C54v239Ev");}
void  S48C5 ::v240(){vfunc_called(this, "_ZN5S48C54v240Ev");}
void  S48C5 ::v241(){vfunc_called(this, "_ZN5S48C54v241Ev");}
void  S48C5 ::v242(){vfunc_called(this, "_ZN5S48C54v242Ev");}
void  S48C5 ::v243(){vfunc_called(this, "_ZN5S48C54v243Ev");}
void  S48C5 ::v244(){vfunc_called(this, "_ZN5S48C54v244Ev");}
void  S48C5 ::v245(){vfunc_called(this, "_ZN5S48C54v245Ev");}
void  S48C5 ::v246(){vfunc_called(this, "_ZN5S48C54v246Ev");}
void  S48C5 ::v247(){vfunc_called(this, "_ZN5S48C54v247Ev");}
void  S48C5 ::v248(){vfunc_called(this, "_ZN5S48C54v248Ev");}
void  S48C5 ::v249(){vfunc_called(this, "_ZN5S48C54v249Ev");}
void  S48C5 ::v250(){vfunc_called(this, "_ZN5S48C54v250Ev");}
void  S48C5 ::v251(){vfunc_called(this, "_ZN5S48C54v251Ev");}
void  S48C5 ::v252(){vfunc_called(this, "_ZN5S48C54v252Ev");}
void  S48C5 ::v253(){vfunc_called(this, "_ZN5S48C54v253Ev");}
void  S48C5 ::v254(){vfunc_called(this, "_ZN5S48C54v254Ev");}
void  S48C5 ::v255(){vfunc_called(this, "_ZN5S48C54v255Ev");}
void  S48C5 ::v256(){vfunc_called(this, "_ZN5S48C54v256Ev");}
void  S48C5 ::v257(){vfunc_called(this, "_ZN5S48C54v257Ev");}
void  S48C5 ::v258(){vfunc_called(this, "_ZN5S48C54v258Ev");}
void  S48C5 ::v259(){vfunc_called(this, "_ZN5S48C54v259Ev");}
void  S48C5 ::v260(){vfunc_called(this, "_ZN5S48C54v260Ev");}
void  S48C5 ::v261(){vfunc_called(this, "_ZN5S48C54v261Ev");}
void  S48C5 ::v262(){vfunc_called(this, "_ZN5S48C54v262Ev");}
void  S48C5 ::v263(){vfunc_called(this, "_ZN5S48C54v263Ev");}
void  S48C5 ::v264(){vfunc_called(this, "_ZN5S48C54v264Ev");}
void  S48C5 ::v265(){vfunc_called(this, "_ZN5S48C54v265Ev");}
void  S48C5 ::v266(){vfunc_called(this, "_ZN5S48C54v266Ev");}
void  S48C5 ::v267(){vfunc_called(this, "_ZN5S48C54v267Ev");}
S48C5 ::S48C5(){ note_ctor("S48C5", this);} // tgen

static void Test_S48C5()
{
  extern Class_Descriptor cd_S48C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(116,174)];
    init_test(&cd_S48C5, buf);
    S48C5 *dp, &lv = *(dp=new (buf) S48C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(920,692), "sizeof(S48C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C5)");
    check_base_class_offset(lv, (S48C7*)(S48C6*), 0, "S48C5");
    check_base_class_offset(lv, (S48C6*), 0, "S48C5");
    check_field_offset(lv, s48c5f0, ABISELECT(568,436), "S48C5.s48c5f0");
    check_field_offset(lv, s48c5f1, ABISELECT(584,444), "S48C5.s48c5f1");
    check_field_offset(lv, s48c5f2, ABISELECT(592,448), "S48C5.s48c5f2");
    set_bf_and_test(lv, s48c5f3, ABISELECT(600,452), 0, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f4, ABISELECT(600,452), 1, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f5, ABISELECT(600,452), 2, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f6, ABISELECT(600,452), 3, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f7, ABISELECT(600,452), 4, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f8, ABISELECT(600,452), 5, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f9, ABISELECT(600,452), 6, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f10, ABISELECT(600,452), 7, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f11, ABISELECT(601,453), 0, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f12, ABISELECT(601,453), 1, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f13, ABISELECT(601,453), 2, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f14, ABISELECT(601,453), 3, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f15, ABISELECT(601,453), 4, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f16, ABISELECT(601,453), 5, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f17, ABISELECT(601,453), 6, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f18, ABISELECT(601,453), 7, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f19, ABISELECT(602,454), 0, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f20, ABISELECT(602,454), 1, 1, 1, "S48C5");
    set_bf_and_test(lv, s48c5f21, ABISELECT(602,454), 2, 1, 1, "S48C5");
    check_field_offset(lv, s48c5f22, ABISELECT(603,455), "S48C5.s48c5f22");
    check_field_offset(lv, s48c5f23, ABISELECT(604,456), "S48C5.s48c5f23");
    check_field_offset(lv, s48c5f24, ABISELECT(616,464), "S48C5.s48c5f24");
    check_field_offset(lv, s48c5f25, ABISELECT(624,468), "S48C5.s48c5f25");
    check_field_offset(lv, s48c5f26, ABISELECT(636,480), "S48C5.s48c5f26");
    check_field_offset(lv, s48c5f27, ABISELECT(648,492), "S48C5.s48c5f27");
    check_field_offset(lv, s48c5f28, ABISELECT(688,512), "S48C5.s48c5f28");
    check_field_offset(lv, s48c5f29, ABISELECT(704,524), "S48C5.s48c5f29");
    check_field_offset(lv, s48c5f30, ABISELECT(712,528), "S48C5.s48c5f30");
    check_field_offset(lv, s48c5f31, ABISELECT(728,540), "S48C5.s48c5f31");
    check_field_offset(lv, s48c5f32, ABISELECT(744,548), "S48C5.s48c5f32");
    check_field_offset(lv, s48c5f33, ABISELECT(760,560), "S48C5.s48c5f33");
    check_field_offset(lv, s48c5f34, ABISELECT(768,564), "S48C5.s48c5f34");
    check_field_offset(lv, s48c5f35, ABISELECT(776,572), "S48C5.s48c5f35");
    check_field_offset(lv, s48c5f36, ABISELECT(784,576), "S48C5.s48c5f36");
    check_field_offset(lv, s48c5f37, ABISELECT(788,580), "S48C5.s48c5f37");
    check_field_offset(lv, s48c5f38, ABISELECT(800,592), "S48C5.s48c5f38");
    check_field_offset(lv, s48c5f39, ABISELECT(812,604), "S48C5.s48c5f39");
    check_field_offset(lv, s48c5f40, ABISELECT(824,616), "S48C5.s48c5f40");
    check_field_offset(lv, s48c5f41, ABISELECT(840,624), "S48C5.s48c5f41");
    check_field_offset(lv, s48c5f42, ABISELECT(844,628), "S48C5.s48c5f42");
    check_field_offset(lv, s48c5f43, ABISELECT(856,640), "S48C5.s48c5f43");
    check_field_offset(lv, s48c5f44, ABISELECT(872,656), "S48C5.s48c5f44");
    check_field_offset(lv, s48c5f45, ABISELECT(888,664), "S48C5.s48c5f45");
    check_field_offset(lv, s48c5f46, ABISELECT(904,676), "S48C5.s48c5f46");
    check_field_offset(lv, s48c5f47, ABISELECT(908,680), "S48C5.s48c5f47");
    test_class_info(&lv, &cd_S48C5);
    dp->~S48C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C5(Test_S48C5, "S48C5", ABISELECT(920,692));

#else // __cplusplus

extern void _ZN5S48C5C1Ev();
extern void _ZN5S48C5D1Ev();
Name_Map name_map_S48C5[] = {
  NSPAIR(_ZN5S48C5C1Ev),
  NSPAIR(_ZN5S48C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S48C7;
extern VTBL_ENTRY _ZTI5S48C7[];
extern  VTBL_ENTRY _ZTV5S48C7[];
extern Class_Descriptor cd_S48C6;
extern VTBL_ENTRY _ZTI5S48C6[];
extern  VTBL_ENTRY _ZTV5S48C6[];
static Base_Class bases_S48C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S48C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S48C5[];
extern void _ZN5S48C5D1Ev();
extern void _ZN5S48C5D0Ev();
extern void _ZN5S48C73v11Ev();
extern void _ZN5S48C73v12Ev();
extern void _ZN5S48C73v13Ev();
extern void _ZN5S48C73v14Ev();
extern void _ZN5S48C73v15Ev();
extern void _ZN5S48C73v16Ev();
extern void _ZN5S48C73v17Ev();
extern void _ZN5S48C73v18Ev();
extern void _ZN5S48C73v19Ev();
extern void _ZN5S48C73v20Ev();
extern void _ZN5S48C73v21Ev();
extern void _ZN5S48C73v22Ev();
extern void _ZN5S48C73v23Ev();
extern void _ZN5S48C73v24Ev();
extern void _ZN5S48C73v25Ev();
extern void _ZN5S48C73v26Ev();
extern void _ZN5S48C73v27Ev();
extern void _ZN5S48C73v28Ev();
extern void _ZN5S48C73v29Ev();
extern void _ZN5S48C73v30Ev();
extern void _ZN5S48C73v31Ev();
extern void _ZN5S48C73v32Ev();
extern void _ZN5S48C73v33Ev();
extern void _ZN5S48C73v34Ev();
extern void _ZN5S48C73v35Ev();
extern void _ZN5S48C73v36Ev();
extern void _ZN5S48C73v37Ev();
extern void _ZN5S48C73v38Ev();
extern void _ZN5S48C73v39Ev();
extern void _ZN5S48C73v40Ev();
extern void _ZN5S48C73v41Ev();
extern void _ZN5S48C73v42Ev();
extern void _ZN5S48C73v43Ev();
extern void _ZN5S48C73v44Ev();
extern void _ZN5S48C73v45Ev();
extern void _ZN5S48C73v46Ev();
extern void _ZN5S48C73v47Ev();
extern void _ZN5S48C73v48Ev();
extern void _ZN5S48C73v49Ev();
extern void _ZN5S48C73v50Ev();
extern void _ZN5S48C73v51Ev();
extern void _ZN5S48C73v52Ev();
extern void _ZN5S48C73v53Ev();
extern void _ZN5S48C73v54Ev();
extern void _ZN5S48C73v55Ev();
extern void _ZN5S48C73v56Ev();
extern void _ZN5S48C73v57Ev();
extern void _ZN5S48C73v58Ev();
extern void _ZN5S48C73v59Ev();
extern void _ZN5S48C73v60Ev();
extern void _ZN5S48C73v61Ev();
extern void _ZN5S48C73v62Ev();
extern void _ZN5S48C73v63Ev();
extern void _ZN5S48C73v64Ev();
extern void _ZN5S48C73v65Ev();
extern void _ZN5S48C73v66Ev();
extern void _ZN5S48C73v67Ev();
extern void _ZN5S48C73v68Ev();
extern void _ZN5S48C73v69Ev();
extern void _ZN5S48C73v70Ev();
extern void _ZN5S48C73v71Ev();
extern void _ZN5S48C73v72Ev();
extern void _ZN5S48C73v73Ev();
extern void _ZN5S48C73v74Ev();
extern void _ZN5S48C63v75Ev();
extern void _ZN5S48C63v76Ev();
extern void _ZN5S48C63v77Ev();
extern void _ZN5S48C63v78Ev();
extern void _ZN5S48C63v79Ev();
extern void _ZN5S48C63v80Ev();
extern void _ZN5S48C63v81Ev();
extern void _ZN5S48C63v82Ev();
extern void _ZN5S48C63v83Ev();
extern void _ZN5S48C63v84Ev();
extern void _ZN5S48C63v85Ev();
extern void _ZN5S48C63v86Ev();
extern void _ZN5S48C63v87Ev();
extern void _ZN5S48C63v88Ev();
extern void _ZN5S48C63v89Ev();
extern void _ZN5S48C63v90Ev();
extern void _ZN5S48C63v91Ev();
extern void _ZN5S48C63v92Ev();
extern void _ZN5S48C63v93Ev();
extern void _ZN5S48C63v94Ev();
extern void _ZN5S48C63v95Ev();
extern void _ZN5S48C63v96Ev();
extern void _ZN5S48C63v97Ev();
extern void _ZN5S48C63v98Ev();
extern void _ZN5S48C63v99Ev();
extern void _ZN5S48C64v100Ev();
extern void _ZN5S48C64v101Ev();
extern void _ZN5S48C64v102Ev();
extern void _ZN5S48C64v103Ev();
extern void _ZN5S48C64v104Ev();
extern void _ZN5S48C64v105Ev();
extern void _ZN5S48C64v106Ev();
extern void _ZN5S48C64v107Ev();
extern void _ZN5S48C64v108Ev();
extern void _ZN5S48C64v109Ev();
extern void _ZN5S48C64v110Ev();
extern void _ZN5S48C64v111Ev();
extern void _ZN5S48C64v112Ev();
extern void _ZN5S48C64v113Ev();
extern void _ZN5S48C64v114Ev();
extern void _ZN5S48C64v115Ev();
extern void _ZN5S48C64v116Ev();
extern void _ZN5S48C64v117Ev();
extern void _ZN5S48C64v118Ev();
extern void _ZN5S48C64v119Ev();
extern void _ZN5S48C64v120Ev();
extern void _ZN5S48C64v121Ev();
extern void _ZN5S48C64v122Ev();
extern void _ZN5S48C64v123Ev();
extern void _ZN5S48C64v124Ev();
extern void _ZN5S48C64v125Ev();
extern void _ZN5S48C64v126Ev();
extern void _ZN5S48C64v127Ev();
extern void _ZN5S48C64v128Ev();
extern void _ZN5S48C64v129Ev();
extern void _ZN5S48C64v130Ev();
extern void _ZN5S48C64v131Ev();
extern void _ZN5S48C64v132Ev();
extern void _ZN5S48C64v133Ev();
extern void _ZN5S48C64v134Ev();
extern void _ZN5S48C64v135Ev();
extern void _ZN5S48C64v136Ev();
extern void _ZN5S48C64v137Ev();
extern void _ZN5S48C64v138Ev();
extern void _ZN5S48C64v139Ev();
extern void _ZN5S48C64v140Ev();
extern void _ZN5S48C64v141Ev();
extern void _ZN5S48C64v142Ev();
extern void _ZN5S48C64v143Ev();
extern void _ZN5S48C64v144Ev();
extern void _ZN5S48C64v145Ev();
extern void _ZN5S48C64v146Ev();
extern void _ZN5S48C64v147Ev();
extern void _ZN5S48C64v148Ev();
extern void _ZN5S48C64v149Ev();
extern void _ZN5S48C64v150Ev();
extern void _ZN5S48C64v151Ev();
extern void _ZN5S48C64v152Ev();
extern void _ZN5S48C64v153Ev();
extern void _ZN5S48C64v154Ev();
extern void _ZN5S48C64v155Ev();
extern void _ZN5S48C64v156Ev();
extern void _ZN5S48C64v157Ev();
extern void _ZN5S48C64v158Ev();
extern void _ZN5S48C64v159Ev();
extern void _ZN5S48C64v160Ev();
extern void _ZN5S48C64v161Ev();
extern void _ZN5S48C64v162Ev();
extern void _ZN5S48C64v163Ev();
extern void _ZN5S48C64v164Ev();
extern void _ZN5S48C64v165Ev();
extern void _ZN5S48C64v166Ev();
extern void _ZN5S48C64v167Ev();
extern void _ZN5S48C64v168Ev();
extern void _ZN5S48C64v169Ev();
extern void _ZN5S48C64v170Ev();
extern void _ZN5S48C64v171Ev();
extern void _ZN5S48C64v172Ev();
extern void _ZN5S48C64v173Ev();
extern void _ZN5S48C64v174Ev();
extern void _ZN5S48C64v175Ev();
extern void _ZN5S48C64v176Ev();
extern void _ZN5S48C64v177Ev();
extern void _ZN5S48C64v178Ev();
extern void _ZN5S48C64v179Ev();
extern void _ZN5S48C64v180Ev();
extern void _ZN5S48C64v181Ev();
extern void _ZN5S48C64v182Ev();
extern void _ZN5S48C64v183Ev();
extern void _ZN5S48C64v184Ev();
extern void _ZN5S48C64v185Ev();
extern void _ZN5S48C64v186Ev();
extern void _ZN5S48C64v187Ev();
extern void _ZN5S48C64v188Ev();
extern void _ZN5S48C64v189Ev();
extern void _ZN5S48C64v190Ev();
extern void _ZN5S48C64v191Ev();
extern void _ZN5S48C64v192Ev();
extern void _ZN5S48C64v193Ev();
extern void _ZN5S48C64v194Ev();
extern void _ZN5S48C64v195Ev();
extern void _ZN5S48C64v196Ev();
extern void _ZN5S48C64v197Ev();
extern void _ZN5S48C64v198Ev();
extern void _ZN5S48C64v199Ev();
extern void _ZN5S48C64v200Ev();
extern void _ZN5S48C64v201Ev();
extern void _ZN5S48C64v202Ev();
extern void _ZN5S48C64v203Ev();
extern void _ZN5S48C64v204Ev();
extern void _ZN5S48C64v205Ev();
extern void _ZN5S48C64v206Ev();
extern void _ZN5S48C64v207Ev();
extern void _ZN5S48C64v208Ev();
extern void _ZN5S48C64v209Ev();
extern void _ZN5S48C64v210Ev();
extern void _ZN5S48C64v211Ev();
extern void _ZN5S48C64v212Ev();
extern void _ZN5S48C64v213Ev();
extern void _ZN5S48C64v214Ev();
extern void _ZN5S48C64v215Ev();
extern void _ZN5S48C64v216Ev();
extern void _ZN5S48C64v217Ev();
extern void _ZN5S48C54v218Ev();
extern void _ZN5S48C54v219Ev();
extern void _ZN5S48C54v220Ev();
extern void _ZN5S48C54v221Ev();
extern void _ZN5S48C54v222Ev();
extern void _ZN5S48C54v223Ev();
extern void _ZN5S48C54v224Ev();
extern void _ZN5S48C54v225Ev();
extern void _ZN5S48C54v226Ev();
extern void _ZN5S48C54v227Ev();
extern void _ZN5S48C54v228Ev();
extern void _ZN5S48C54v229Ev();
extern void _ZN5S48C54v230Ev();
extern void _ZN5S48C54v231Ev();
extern void _ZN5S48C54v232Ev();
extern void _ZN5S48C54v233Ev();
extern void _ZN5S48C54v234Ev();
extern void _ZN5S48C54v235Ev();
extern void _ZN5S48C54v236Ev();
extern void _ZN5S48C54v237Ev();
extern void _ZN5S48C54v238Ev();
extern void _ZN5S48C54v239Ev();
extern void _ZN5S48C54v240Ev();
extern void _ZN5S48C54v241Ev();
extern void _ZN5S48C54v242Ev();
extern void _ZN5S48C54v243Ev();
extern void _ZN5S48C54v244Ev();
extern void _ZN5S48C54v245Ev();
extern void _ZN5S48C54v246Ev();
extern void _ZN5S48C54v247Ev();
extern void _ZN5S48C54v248Ev();
extern void _ZN5S48C54v249Ev();
extern void _ZN5S48C54v250Ev();
extern void _ZN5S48C54v251Ev();
extern void _ZN5S48C54v252Ev();
extern void _ZN5S48C54v253Ev();
extern void _ZN5S48C54v254Ev();
extern void _ZN5S48C54v255Ev();
extern void _ZN5S48C54v256Ev();
extern void _ZN5S48C54v257Ev();
extern void _ZN5S48C54v258Ev();
extern void _ZN5S48C54v259Ev();
extern void _ZN5S48C54v260Ev();
extern void _ZN5S48C54v261Ev();
extern void _ZN5S48C54v262Ev();
extern void _ZN5S48C54v263Ev();
extern void _ZN5S48C54v264Ev();
extern void _ZN5S48C54v265Ev();
extern void _ZN5S48C54v266Ev();
extern void _ZN5S48C54v267Ev();
static  VTBL_ENTRY vtc_S48C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S48C5[0]),
  (VTBL_ENTRY)&_ZN5S48C5D1Ev,
  (VTBL_ENTRY)&_ZN5S48C5D0Ev,
  (VTBL_ENTRY)&_ZN5S48C73v11Ev,
  (VTBL_ENTRY)&_ZN5S48C73v12Ev,
  (VTBL_ENTRY)&_ZN5S48C73v13Ev,
  (VTBL_ENTRY)&_ZN5S48C73v14Ev,
  (VTBL_ENTRY)&_ZN5S48C73v15Ev,
  (VTBL_ENTRY)&_ZN5S48C73v16Ev,
  (VTBL_ENTRY)&_ZN5S48C73v17Ev,
  (VTBL_ENTRY)&_ZN5S48C73v18Ev,
  (VTBL_ENTRY)&_ZN5S48C73v19Ev,
  (VTBL_ENTRY)&_ZN5S48C73v20Ev,
  (VTBL_ENTRY)&_ZN5S48C73v21Ev,
  (VTBL_ENTRY)&_ZN5S48C73v22Ev,
  (VTBL_ENTRY)&_ZN5S48C73v23Ev,
  (VTBL_ENTRY)&_ZN5S48C73v24Ev,
  (VTBL_ENTRY)&_ZN5S48C73v25Ev,
  (VTBL_ENTRY)&_ZN5S48C73v26Ev,
  (VTBL_ENTRY)&_ZN5S48C73v27Ev,
  (VTBL_ENTRY)&_ZN5S48C73v28Ev,
  (VTBL_ENTRY)&_ZN5S48C73v29Ev,
  (VTBL_ENTRY)&_ZN5S48C73v30Ev,
  (VTBL_ENTRY)&_ZN5S48C73v31Ev,
  (VTBL_ENTRY)&_ZN5S48C73v32Ev,
  (VTBL_ENTRY)&_ZN5S48C73v33Ev,
  (VTBL_ENTRY)&_ZN5S48C73v34Ev,
  (VTBL_ENTRY)&_ZN5S48C73v35Ev,
  (VTBL_ENTRY)&_ZN5S48C73v36Ev,
  (VTBL_ENTRY)&_ZN5S48C73v37Ev,
  (VTBL_ENTRY)&_ZN5S48C73v38Ev,
  (VTBL_ENTRY)&_ZN5S48C73v39Ev,
  (VTBL_ENTRY)&_ZN5S48C73v40Ev,
  (VTBL_ENTRY)&_ZN5S48C73v41Ev,
  (VTBL_ENTRY)&_ZN5S48C73v42Ev,
  (VTBL_ENTRY)&_ZN5S48C73v43Ev,
  (VTBL_ENTRY)&_ZN5S48C73v44Ev,
  (VTBL_ENTRY)&_ZN5S48C73v45Ev,
  (VTBL_ENTRY)&_ZN5S48C73v46Ev,
  (VTBL_ENTRY)&_ZN5S48C73v47Ev,
  (VTBL_ENTRY)&_ZN5S48C73v48Ev,
  (VTBL_ENTRY)&_ZN5S48C73v49Ev,
  (VTBL_ENTRY)&_ZN5S48C73v50Ev,
  (VTBL_ENTRY)&_ZN5S48C73v51Ev,
  (VTBL_ENTRY)&_ZN5S48C73v52Ev,
  (VTBL_ENTRY)&_ZN5S48C73v53Ev,
  (VTBL_ENTRY)&_ZN5S48C73v54Ev,
  (VTBL_ENTRY)&_ZN5S48C73v55Ev,
  (VTBL_ENTRY)&_ZN5S48C73v56Ev,
  (VTBL_ENTRY)&_ZN5S48C73v57Ev,
  (VTBL_ENTRY)&_ZN5S48C73v58Ev,
  (VTBL_ENTRY)&_ZN5S48C73v59Ev,
  (VTBL_ENTRY)&_ZN5S48C73v60Ev,
  (VTBL_ENTRY)&_ZN5S48C73v61Ev,
  (VTBL_ENTRY)&_ZN5S48C73v62Ev,
  (VTBL_ENTRY)&_ZN5S48C73v63Ev,
  (VTBL_ENTRY)&_ZN5S48C73v64Ev,
  (VTBL_ENTRY)&_ZN5S48C73v65Ev,
  (VTBL_ENTRY)&_ZN5S48C73v66Ev,
  (VTBL_ENTRY)&_ZN5S48C73v67Ev,
  (VTBL_ENTRY)&_ZN5S48C73v68Ev,
  (VTBL_ENTRY)&_ZN5S48C73v69Ev,
  (VTBL_ENTRY)&_ZN5S48C73v70Ev,
  (VTBL_ENTRY)&_ZN5S48C73v71Ev,
  (VTBL_ENTRY)&_ZN5S48C73v72Ev,
  (VTBL_ENTRY)&_ZN5S48C73v73Ev,
  (VTBL_ENTRY)&_ZN5S48C73v74Ev,
  (VTBL_ENTRY)&_ZN5S48C63v75Ev,
  (VTBL_ENTRY)&_ZN5S48C63v76Ev,
  (VTBL_ENTRY)&_ZN5S48C63v77Ev,
  (VTBL_ENTRY)&_ZN5S48C63v78Ev,
  (VTBL_ENTRY)&_ZN5S48C63v79Ev,
  (VTBL_ENTRY)&_ZN5S48C63v80Ev,
  (VTBL_ENTRY)&_ZN5S48C63v81Ev,
  (VTBL_ENTRY)&_ZN5S48C63v82Ev,
  (VTBL_ENTRY)&_ZN5S48C63v83Ev,
  (VTBL_ENTRY)&_ZN5S48C63v84Ev,
  (VTBL_ENTRY)&_ZN5S48C63v85Ev,
  (VTBL_ENTRY)&_ZN5S48C63v86Ev,
  (VTBL_ENTRY)&_ZN5S48C63v87Ev,
  (VTBL_ENTRY)&_ZN5S48C63v88Ev,
  (VTBL_ENTRY)&_ZN5S48C63v89Ev,
  (VTBL_ENTRY)&_ZN5S48C63v90Ev,
  (VTBL_ENTRY)&_ZN5S48C63v91Ev,
  (VTBL_ENTRY)&_ZN5S48C63v92Ev,
  (VTBL_ENTRY)&_ZN5S48C63v93Ev,
  (VTBL_ENTRY)&_ZN5S48C63v94Ev,
  (VTBL_ENTRY)&_ZN5S48C63v95Ev,
  (VTBL_ENTRY)&_ZN5S48C63v96Ev,
  (VTBL_ENTRY)&_ZN5S48C63v97Ev,
  (VTBL_ENTRY)&_ZN5S48C63v98Ev,
  (VTBL_ENTRY)&_ZN5S48C63v99Ev,
  (VTBL_ENTRY)&_ZN5S48C64v100Ev,
  (VTBL_ENTRY)&_ZN5S48C64v101Ev,
  (VTBL_ENTRY)&_ZN5S48C64v102Ev,
  (VTBL_ENTRY)&_ZN5S48C64v103Ev,
  (VTBL_ENTRY)&_ZN5S48C64v104Ev,
  (VTBL_ENTRY)&_ZN5S48C64v105Ev,
  (VTBL_ENTRY)&_ZN5S48C64v106Ev,
  (VTBL_ENTRY)&_ZN5S48C64v107Ev,
  (VTBL_ENTRY)&_ZN5S48C64v108Ev,
  (VTBL_ENTRY)&_ZN5S48C64v109Ev,
  (VTBL_ENTRY)&_ZN5S48C64v110Ev,
  (VTBL_ENTRY)&_ZN5S48C64v111Ev,
  (VTBL_ENTRY)&_ZN5S48C64v112Ev,
  (VTBL_ENTRY)&_ZN5S48C64v113Ev,
  (VTBL_ENTRY)&_ZN5S48C64v114Ev,
  (VTBL_ENTRY)&_ZN5S48C64v115Ev,
  (VTBL_ENTRY)&_ZN5S48C64v116Ev,
  (VTBL_ENTRY)&_ZN5S48C64v117Ev,
  (VTBL_ENTRY)&_ZN5S48C64v118Ev,
  (VTBL_ENTRY)&_ZN5S48C64v119Ev,
  (VTBL_ENTRY)&_ZN5S48C64v120Ev,
  (VTBL_ENTRY)&_ZN5S48C64v121Ev,
  (VTBL_ENTRY)&_ZN5S48C64v122Ev,
  (VTBL_ENTRY)&_ZN5S48C64v123Ev,
  (VTBL_ENTRY)&_ZN5S48C64v124Ev,
  (VTBL_ENTRY)&_ZN5S48C64v125Ev,
  (VTBL_ENTRY)&_ZN5S48C64v126Ev,
  (VTBL_ENTRY)&_ZN5S48C64v127Ev,
  (VTBL_ENTRY)&_ZN5S48C64v128Ev,
  (VTBL_ENTRY)&_ZN5S48C64v129Ev,
  (VTBL_ENTRY)&_ZN5S48C64v130Ev,
  (VTBL_ENTRY)&_ZN5S48C64v131Ev,
  (VTBL_ENTRY)&_ZN5S48C64v132Ev,
  (VTBL_ENTRY)&_ZN5S48C64v133Ev,
  (VTBL_ENTRY)&_ZN5S48C64v134Ev,
  (VTBL_ENTRY)&_ZN5S48C64v135Ev,
  (VTBL_ENTRY)&_ZN5S48C64v136Ev,
  (VTBL_ENTRY)&_ZN5S48C64v137Ev,
  (VTBL_ENTRY)&_ZN5S48C64v138Ev,
  (VTBL_ENTRY)&_ZN5S48C64v139Ev,
  (VTBL_ENTRY)&_ZN5S48C64v140Ev,
  (VTBL_ENTRY)&_ZN5S48C64v141Ev,
  (VTBL_ENTRY)&_ZN5S48C64v142Ev,
  (VTBL_ENTRY)&_ZN5S48C64v143Ev,
  (VTBL_ENTRY)&_ZN5S48C64v144Ev,
  (VTBL_ENTRY)&_ZN5S48C64v145Ev,
  (VTBL_ENTRY)&_ZN5S48C64v146Ev,
  (VTBL_ENTRY)&_ZN5S48C64v147Ev,
  (VTBL_ENTRY)&_ZN5S48C64v148Ev,
  (VTBL_ENTRY)&_ZN5S48C64v149Ev,
  (VTBL_ENTRY)&_ZN5S48C64v150Ev,
  (VTBL_ENTRY)&_ZN5S48C64v151Ev,
  (VTBL_ENTRY)&_ZN5S48C64v152Ev,
  (VTBL_ENTRY)&_ZN5S48C64v153Ev,
  (VTBL_ENTRY)&_ZN5S48C64v154Ev,
  (VTBL_ENTRY)&_ZN5S48C64v155Ev,
  (VTBL_ENTRY)&_ZN5S48C64v156Ev,
  (VTBL_ENTRY)&_ZN5S48C64v157Ev,
  (VTBL_ENTRY)&_ZN5S48C64v158Ev,
  (VTBL_ENTRY)&_ZN5S48C64v159Ev,
  (VTBL_ENTRY)&_ZN5S48C64v160Ev,
  (VTBL_ENTRY)&_ZN5S48C64v161Ev,
  (VTBL_ENTRY)&_ZN5S48C64v162Ev,
  (VTBL_ENTRY)&_ZN5S48C64v163Ev,
  (VTBL_ENTRY)&_ZN5S48C64v164Ev,
  (VTBL_ENTRY)&_ZN5S48C64v165Ev,
  (VTBL_ENTRY)&_ZN5S48C64v166Ev,
  (VTBL_ENTRY)&_ZN5S48C64v167Ev,
  (VTBL_ENTRY)&_ZN5S48C64v168Ev,
  (VTBL_ENTRY)&_ZN5S48C64v169Ev,
  (VTBL_ENTRY)&_ZN5S48C64v170Ev,
  (VTBL_ENTRY)&_ZN5S48C64v171Ev,
  (VTBL_ENTRY)&_ZN5S48C64v172Ev,
  (VTBL_ENTRY)&_ZN5S48C64v173Ev,
  (VTBL_ENTRY)&_ZN5S48C64v174Ev,
  (VTBL_ENTRY)&_ZN5S48C64v175Ev,
  (VTBL_ENTRY)&_ZN5S48C64v176Ev,
  (VTBL_ENTRY)&_ZN5S48C64v177Ev,
  (VTBL_ENTRY)&_ZN5S48C64v178Ev,
  (VTBL_ENTRY)&_ZN5S48C64v179Ev,
  (VTBL_ENTRY)&_ZN5S48C64v180Ev,
  (VTBL_ENTRY)&_ZN5S48C64v181Ev,
  (VTBL_ENTRY)&_ZN5S48C64v182Ev,
  (VTBL_ENTRY)&_ZN5S48C64v183Ev,
  (VTBL_ENTRY)&_ZN5S48C64v184Ev,
  (VTBL_ENTRY)&_ZN5S48C64v185Ev,
  (VTBL_ENTRY)&_ZN5S48C64v186Ev,
  (VTBL_ENTRY)&_ZN5S48C64v187Ev,
  (VTBL_ENTRY)&_ZN5S48C64v188Ev,
  (VTBL_ENTRY)&_ZN5S48C64v189Ev,
  (VTBL_ENTRY)&_ZN5S48C64v190Ev,
  (VTBL_ENTRY)&_ZN5S48C64v191Ev,
  (VTBL_ENTRY)&_ZN5S48C64v192Ev,
  (VTBL_ENTRY)&_ZN5S48C64v193Ev,
  (VTBL_ENTRY)&_ZN5S48C64v194Ev,
  (VTBL_ENTRY)&_ZN5S48C64v195Ev,
  (VTBL_ENTRY)&_ZN5S48C64v196Ev,
  (VTBL_ENTRY)&_ZN5S48C64v197Ev,
  (VTBL_ENTRY)&_ZN5S48C64v198Ev,
  (VTBL_ENTRY)&_ZN5S48C64v199Ev,
  (VTBL_ENTRY)&_ZN5S48C64v200Ev,
  (VTBL_ENTRY)&_ZN5S48C64v201Ev,
  (VTBL_ENTRY)&_ZN5S48C64v202Ev,
  (VTBL_ENTRY)&_ZN5S48C64v203Ev,
  (VTBL_ENTRY)&_ZN5S48C64v204Ev,
  (VTBL_ENTRY)&_ZN5S48C64v205Ev,
  (VTBL_ENTRY)&_ZN5S48C64v206Ev,
  (VTBL_ENTRY)&_ZN5S48C64v207Ev,
  (VTBL_ENTRY)&_ZN5S48C64v208Ev,
  (VTBL_ENTRY)&_ZN5S48C64v209Ev,
  (VTBL_ENTRY)&_ZN5S48C64v210Ev,
  (VTBL_ENTRY)&_ZN5S48C64v211Ev,
  (VTBL_ENTRY)&_ZN5S48C64v212Ev,
  (VTBL_ENTRY)&_ZN5S48C64v213Ev,
  (VTBL_ENTRY)&_ZN5S48C64v214Ev,
  (VTBL_ENTRY)&_ZN5S48C64v215Ev,
  (VTBL_ENTRY)&_ZN5S48C64v216Ev,
  (VTBL_ENTRY)&_ZN5S48C64v217Ev,
  (VTBL_ENTRY)&_ZN5S48C54v218Ev,
  (VTBL_ENTRY)&_ZN5S48C54v219Ev,
  (VTBL_ENTRY)&_ZN5S48C54v220Ev,
  (VTBL_ENTRY)&_ZN5S48C54v221Ev,
  (VTBL_ENTRY)&_ZN5S48C54v222Ev,
  (VTBL_ENTRY)&_ZN5S48C54v223Ev,
  (VTBL_ENTRY)&_ZN5S48C54v224Ev,
  (VTBL_ENTRY)&_ZN5S48C54v225Ev,
  (VTBL_ENTRY)&_ZN5S48C54v226Ev,
  (VTBL_ENTRY)&_ZN5S48C54v227Ev,
  (VTBL_ENTRY)&_ZN5S48C54v228Ev,
  (VTBL_ENTRY)&_ZN5S48C54v229Ev,
  (VTBL_ENTRY)&_ZN5S48C54v230Ev,
  (VTBL_ENTRY)&_ZN5S48C54v231Ev,
  (VTBL_ENTRY)&_ZN5S48C54v232Ev,
  (VTBL_ENTRY)&_ZN5S48C54v233Ev,
  (VTBL_ENTRY)&_ZN5S48C54v234Ev,
  (VTBL_ENTRY)&_ZN5S48C54v235Ev,
  (VTBL_ENTRY)&_ZN5S48C54v236Ev,
  (VTBL_ENTRY)&_ZN5S48C54v237Ev,
  (VTBL_ENTRY)&_ZN5S48C54v238Ev,
  (VTBL_ENTRY)&_ZN5S48C54v239Ev,
  (VTBL_ENTRY)&_ZN5S48C54v240Ev,
  (VTBL_ENTRY)&_ZN5S48C54v241Ev,
  (VTBL_ENTRY)&_ZN5S48C54v242Ev,
  (VTBL_ENTRY)&_ZN5S48C54v243Ev,
  (VTBL_ENTRY)&_ZN5S48C54v244Ev,
  (VTBL_ENTRY)&_ZN5S48C54v245Ev,
  (VTBL_ENTRY)&_ZN5S48C54v246Ev,
  (VTBL_ENTRY)&_ZN5S48C54v247Ev,
  (VTBL_ENTRY)&_ZN5S48C54v248Ev,
  (VTBL_ENTRY)&_ZN5S48C54v249Ev,
  (VTBL_ENTRY)&_ZN5S48C54v250Ev,
  (VTBL_ENTRY)&_ZN5S48C54v251Ev,
  (VTBL_ENTRY)&_ZN5S48C54v252Ev,
  (VTBL_ENTRY)&_ZN5S48C54v253Ev,
  (VTBL_ENTRY)&_ZN5S48C54v254Ev,
  (VTBL_ENTRY)&_ZN5S48C54v255Ev,
  (VTBL_ENTRY)&_ZN5S48C54v256Ev,
  (VTBL_ENTRY)&_ZN5S48C54v257Ev,
  (VTBL_ENTRY)&_ZN5S48C54v258Ev,
  (VTBL_ENTRY)&_ZN5S48C54v259Ev,
  (VTBL_ENTRY)&_ZN5S48C54v260Ev,
  (VTBL_ENTRY)&_ZN5S48C54v261Ev,
  (VTBL_ENTRY)&_ZN5S48C54v262Ev,
  (VTBL_ENTRY)&_ZN5S48C54v263Ev,
  (VTBL_ENTRY)&_ZN5S48C54v264Ev,
  (VTBL_ENTRY)&_ZN5S48C54v265Ev,
  (VTBL_ENTRY)&_ZN5S48C54v266Ev,
  (VTBL_ENTRY)&_ZN5S48C54v267Ev,
};
extern VTBL_ENTRY _ZTI5S48C5[];
extern  VTBL_ENTRY _ZTV5S48C5[];
Class_Descriptor cd_S48C5 = {  "S48C5", // class name
  bases_S48C5, 2,
  &(vtc_S48C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(920,692), // object size
  NSPAIRA(_ZTI5S48C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S48C5),261, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C40  : S28C12_nt {
};
//SIG(-1 S48C40) C1{ BC2{ m Fp Fi[2]}}



static void Test_S48C40()
{
  extern Class_Descriptor cd_S48C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C40, buf);
    S48C40 &lv = *(new (buf) S48C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C40)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S48C40");
    test_class_info(&lv, &cd_S48C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C40(Test_S48C40, "S48C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S48C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C40 = {  "S48C40", // class name
  bases_S48C40, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C39  : S48C40 {
};
//SIG(-1 S48C39) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S48C39()
{
  extern Class_Descriptor cd_S48C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C39, buf);
    S48C39 &lv = *(new (buf) S48C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C39)");
    check_base_class_offset(lv, (S28C12_nt*)(S48C40*), 0, "S48C39");
    check_base_class_offset(lv, (S48C40*), 0, "S48C39");
    test_class_info(&lv, &cd_S48C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C39(Test_S48C39, "S48C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S48C40;
static Base_Class bases_S48C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C39 = {  "S48C39", // class name
  bases_S48C39, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C44  : S28C12_nt {
};
//SIG(-1 S48C44) C1{ BC2{ m Fp Fi[2]}}



static void Test_S48C44()
{
  extern Class_Descriptor cd_S48C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C44, buf);
    S48C44 &lv = *(new (buf) S48C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C44)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S48C44");
    test_class_info(&lv, &cd_S48C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C44(Test_S48C44, "S48C44", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S48C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C44 = {  "S48C44", // class name
  bases_S48C44, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C43  : S48C44 {
};
//SIG(-1 S48C43) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S48C43()
{
  extern Class_Descriptor cd_S48C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C43, buf);
    S48C43 &lv = *(new (buf) S48C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C43)");
    check_base_class_offset(lv, (S28C12_nt*)(S48C44*), 0, "S48C43");
    check_base_class_offset(lv, (S48C44*), 0, "S48C43");
    test_class_info(&lv, &cd_S48C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C43(Test_S48C43, "S48C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S48C44;
static Base_Class bases_S48C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C44,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C43 = {  "S48C43", // class name
  bases_S48C43, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C48  : S28C12_nt {
};
//SIG(-1 S48C48) C1{ BC2{ m Fp Fi[2]}}



static void Test_S48C48()
{
  extern Class_Descriptor cd_S48C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C48, buf);
    S48C48 &lv = *(new (buf) S48C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C48)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S48C48");
    test_class_info(&lv, &cd_S48C48);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C48(Test_S48C48, "S48C48", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S48C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C48 = {  "S48C48", // class name
  bases_S48C48, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C47  : S48C48 {
};
//SIG(-1 S48C47) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S48C47()
{
  extern Class_Descriptor cd_S48C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C47, buf);
    S48C47 &lv = *(new (buf) S48C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C47)");
    check_base_class_offset(lv, (S28C12_nt*)(S48C48*), 0, "S48C47");
    check_base_class_offset(lv, (S48C48*), 0, "S48C47");
    test_class_info(&lv, &cd_S48C47);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C47(Test_S48C47, "S48C47", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S48C48;
static Base_Class bases_S48C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C47 = {  "S48C47", // class name
  bases_S48C47, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C4  : S48C5 {
  void *s48c4f0[8];
  unsigned int s48c4f1:1;
  unsigned int s48c4f2:1;
  unsigned int s48c4f3:1;
  unsigned int s48c4f4:1;
  unsigned int s48c4f5:1;
  unsigned int s48c4f6:1;
  unsigned int s48c4f7:1;
  unsigned int s48c4f8:1;
  unsigned int s48c4f9:1;
  unsigned int s48c4f10:1;
  unsigned int s48c4f11:1;
  unsigned int s48c4f12:1;
  unsigned int s48c4f13:1;
  unsigned int s48c4f14:1;
  unsigned int s48c4f15:1;
  unsigned int s48c4f16:1;
  unsigned int s48c4f17:1;
  unsigned int s48c4f18:1;
  unsigned int s48c4f19:1;
  unsigned int s48c4f20:1;
  unsigned int s48c4f21:1;
  unsigned int s48c4f22:1;
  unsigned int s48c4f23:1;
  unsigned int s48c4f24:1;
  int s48c4f25[2];
  void *s48c4f26;
  char s48c4f27[6];
  void *s48c4f28[2];
  int s48c4f29[4];
  ::S48C18 s48c4f30;
  int s48c4f31;
  ::S48C18 s48c4f32;
  void *s48c4f33[5];
  ::S28C18_nt s48c4f34;
  int s48c4f35[12];
  ::S28C30 s48c4f36;
  ::S28C31_nt s48c4f37[2];
  int s48c4f38;
  ::S28C31_nt s48c4f39;
  ::S28C31_nt s48c4f40;
  ::S28C31_nt s48c4f41;
  ::S28C31_nt s48c4f42;
  int s48c4f43;
  ::S28C18_nt s48c4f44;
  void *s48c4f45[4];
  ::S28C18_nt s48c4f46;
  void *s48c4f47;
  ::S28C31_nt s48c4f48;
  void *s48c4f49;
  ::S28C16 s48c4f50;
  ::S28C10_nt s48c4f51;
  ::S28C10_nt s48c4f52;
  ::S28C10_nt s48c4f53;
  void *s48c4f54;
  ::S28C38 s48c4f55;
  void *s48c4f56;
  int s48c4f57;
  ::S48C39 s48c4f58;
  int s48c4f59;
  ::S28C31_nt s48c4f60[4];
  ::S48C39 s48c4f61;
  void *s48c4f62;
  ::S48C43 s48c4f63;
  int s48c4f64[3];
  ::S48C43 s48c4f65;
  ::S48C43 s48c4f66;
  ::S28C44 s48c4f67;
  ::S48C47 s48c4f68;
  int s48c4f69;
  ::S28C50 s48c4f70;
  virtual  ~S48C4(); // _ZN5S48C4D1Ev
  virtual void  v268(); // _ZN5S48C44v268Ev
  virtual void  v269(); // _ZN5S48C44v269Ev
  virtual void  v270(); // _ZN5S48C44v270Ev
  virtual void  v271(); // _ZN5S48C44v271Ev
  virtual void  v272(); // _ZN5S48C44v272Ev
  virtual void  v273(); // _ZN5S48C44v273Ev
  virtual void  v274(); // _ZN5S48C44v274Ev
  virtual void  v275(); // _ZN5S48C44v275Ev
  virtual void  v276(); // _ZN5S48C44v276Ev
  virtual void  v277(); // _ZN5S48C44v277Ev
  virtual void  v278(); // _ZN5S48C44v278Ev
  virtual void  v279(); // _ZN5S48C44v279Ev
  virtual void  v280(); // _ZN5S48C44v280Ev
  virtual void  v281(); // _ZN5S48C44v281Ev
  virtual void  v282(); // _ZN5S48C44v282Ev
  virtual void  v283(); // _ZN5S48C44v283Ev
  virtual void  v284(); // _ZN5S48C44v284Ev
  virtual void  v285(); // _ZN5S48C44v285Ev
  virtual void  v286(); // _ZN5S48C44v286Ev
  virtual void  v287(); // _ZN5S48C44v287Ev
  virtual void  v288(); // _ZN5S48C44v288Ev
  virtual void  v289(); // _ZN5S48C44v289Ev
  virtual void  v290(); // _ZN5S48C44v290Ev
  virtual void  v291(); // _ZN5S48C44v291Ev
  virtual void  v292(); // _ZN5S48C44v292Ev
  virtual void  v293(); // _ZN5S48C44v293Ev
  virtual void  v294(); // _ZN5S48C44v294Ev
  virtual void  v295(); // _ZN5S48C44v295Ev
  virtual void  v296(); // _ZN5S48C44v296Ev
  virtual void  v297(); // _ZN5S48C44v297Ev
  virtual void  v298(); // _ZN5S48C44v298Ev
  virtual void  v299(); // _ZN5S48C44v299Ev
  virtual void  v300(); // _ZN5S48C44v300Ev
  virtual void  v301(); // _ZN5S48C44v301Ev
  virtual void  v302(); // _ZN5S48C44v302Ev
  virtual void  v303(); // _ZN5S48C44v303Ev
  virtual void  v304(); // _ZN5S48C44v304Ev
  virtual void  v305(); // _ZN5S48C44v305Ev
  S48C4(); // tgen
};
//SIG(-1 S48C4) C1{ BC2{ BC3{ BC4{ vd v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC10{ BC11{ BC8}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC12{ BC13{ BC8}} FC12 Fi Fp[2] FC14{ m Fi[3]} FC15{ m Fi[3]} FC14 FC14 Fp FC5 FC12 FC14 FC15 Fi FC14 FC14 Fp Fi Fc FC15 FC15 Fp Fi Fp FC16{ BC17{ BC8}} FC18{ BC19{ BC8}} FC20{ BC21{ BC8}}} vd v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC14 FC14 Fp[5] FC14 Fp FC22{ BC23{ BC8}} Fp[2] FC14 Fp Fi[2] Fp Fi FC14 FC14 FC14 Fp[2] Fi FC14 Fi[4] Fp[2] FC24{ BC25{ BC8}} Fi FC15} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC15 Fi FC15 Fp[5] FC14 Fi[12] FC26{ Fi Fc FC14 FC14 Fp FC14 Fc} FC27{ BC20}[2] Fi FC27 FC27 FC27 FC27 Fi FC14 Fp[4] FC14 Fp FC27 Fp FC28{ BC29{ BC8}} FC30{ BC31{ BC8}} FC30 FC30 Fp FC32{ BC33{ m Fp[2]}} Fp Fi FC34{ BC35{ BC8}} Fi FC27[4] FC34 Fp FC36{ BC37{ BC8}} Fi[3] FC36 FC36 FC12 FC38{ BC39{ BC8}} Fi FC40{ m Fp FC5}}


 S48C4 ::~S48C4(){ note_dtor("S48C4", this);}
void  S48C4 ::v268(){vfunc_called(this, "_ZN5S48C44v268Ev");}
void  S48C4 ::v269(){vfunc_called(this, "_ZN5S48C44v269Ev");}
void  S48C4 ::v270(){vfunc_called(this, "_ZN5S48C44v270Ev");}
void  S48C4 ::v271(){vfunc_called(this, "_ZN5S48C44v271Ev");}
void  S48C4 ::v272(){vfunc_called(this, "_ZN5S48C44v272Ev");}
void  S48C4 ::v273(){vfunc_called(this, "_ZN5S48C44v273Ev");}
void  S48C4 ::v274(){vfunc_called(this, "_ZN5S48C44v274Ev");}
void  S48C4 ::v275(){vfunc_called(this, "_ZN5S48C44v275Ev");}
void  S48C4 ::v276(){vfunc_called(this, "_ZN5S48C44v276Ev");}
void  S48C4 ::v277(){vfunc_called(this, "_ZN5S48C44v277Ev");}
void  S48C4 ::v278(){vfunc_called(this, "_ZN5S48C44v278Ev");}
void  S48C4 ::v279(){vfunc_called(this, "_ZN5S48C44v279Ev");}
void  S48C4 ::v280(){vfunc_called(this, "_ZN5S48C44v280Ev");}
void  S48C4 ::v281(){vfunc_called(this, "_ZN5S48C44v281Ev");}
void  S48C4 ::v282(){vfunc_called(this, "_ZN5S48C44v282Ev");}
void  S48C4 ::v283(){vfunc_called(this, "_ZN5S48C44v283Ev");}
void  S48C4 ::v284(){vfunc_called(this, "_ZN5S48C44v284Ev");}
void  S48C4 ::v285(){vfunc_called(this, "_ZN5S48C44v285Ev");}
void  S48C4 ::v286(){vfunc_called(this, "_ZN5S48C44v286Ev");}
void  S48C4 ::v287(){vfunc_called(this, "_ZN5S48C44v287Ev");}
void  S48C4 ::v288(){vfunc_called(this, "_ZN5S48C44v288Ev");}
void  S48C4 ::v289(){vfunc_called(this, "_ZN5S48C44v289Ev");}
void  S48C4 ::v290(){vfunc_called(this, "_ZN5S48C44v290Ev");}
void  S48C4 ::v291(){vfunc_called(this, "_ZN5S48C44v291Ev");}
void  S48C4 ::v292(){vfunc_called(this, "_ZN5S48C44v292Ev");}
void  S48C4 ::v293(){vfunc_called(this, "_ZN5S48C44v293Ev");}
void  S48C4 ::v294(){vfunc_called(this, "_ZN5S48C44v294Ev");}
void  S48C4 ::v295(){vfunc_called(this, "_ZN5S48C44v295Ev");}
void  S48C4 ::v296(){vfunc_called(this, "_ZN5S48C44v296Ev");}
void  S48C4 ::v297(){vfunc_called(this, "_ZN5S48C44v297Ev");}
void  S48C4 ::v298(){vfunc_called(this, "_ZN5S48C44v298Ev");}
void  S48C4 ::v299(){vfunc_called(this, "_ZN5S48C44v299Ev");}
void  S48C4 ::v300(){vfunc_called(this, "_ZN5S48C44v300Ev");}
void  S48C4 ::v301(){vfunc_called(this, "_ZN5S48C44v301Ev");}
void  S48C4 ::v302(){vfunc_called(this, "_ZN5S48C44v302Ev");}
void  S48C4 ::v303(){vfunc_called(this, "_ZN5S48C44v303Ev");}
void  S48C4 ::v304(){vfunc_called(this, "_ZN5S48C44v304Ev");}
void  S48C4 ::v305(){vfunc_called(this, "_ZN5S48C44v305Ev");}
S48C4 ::S48C4(){ note_ctor("S48C4", this);} // tgen

static void Test_S48C4()
{
  extern Class_Descriptor cd_S48C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(223,328)];
    init_test(&cd_S48C4, buf);
    S48C4 *dp, &lv = *(dp=new (buf) S48C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1776,1308), "sizeof(S48C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C4)");
    check_base_class_offset(lv, (S48C7*)(S48C6*)(S48C5*), 0, "S48C4");
    check_base_class_offset(lv, (S48C6*)(S48C5*), 0, "S48C4");
    check_base_class_offset(lv, (S48C5*), 0, "S48C4");
    check_field_offset(lv, s48c4f0, ABISELECT(920,692), "S48C4.s48c4f0");
    set_bf_and_test(lv, s48c4f1, ABISELECT(984,724), 0, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f2, ABISELECT(984,724), 1, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f3, ABISELECT(984,724), 2, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f4, ABISELECT(984,724), 3, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f5, ABISELECT(984,724), 4, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f6, ABISELECT(984,724), 5, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f7, ABISELECT(984,724), 6, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f8, ABISELECT(984,724), 7, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f9, ABISELECT(985,725), 0, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f10, ABISELECT(985,725), 1, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f11, ABISELECT(985,725), 2, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f12, ABISELECT(985,725), 3, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f13, ABISELECT(985,725), 4, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f14, ABISELECT(985,725), 5, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f15, ABISELECT(985,725), 6, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f16, ABISELECT(985,725), 7, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f17, ABISELECT(986,726), 0, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f18, ABISELECT(986,726), 1, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f19, ABISELECT(986,726), 2, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f20, ABISELECT(986,726), 3, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f21, ABISELECT(986,726), 4, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f22, ABISELECT(986,726), 5, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f23, ABISELECT(986,726), 6, 1, 1, "S48C4");
    set_bf_and_test(lv, s48c4f24, ABISELECT(986,726), 7, 1, 1, "S48C4");
    check_field_offset(lv, s48c4f25, ABISELECT(988,728), "S48C4.s48c4f25");
    check_field_offset(lv, s48c4f26, ABISELECT(1000,736), "S48C4.s48c4f26");
    check_field_offset(lv, s48c4f27, ABISELECT(1008,740), "S48C4.s48c4f27");
    check_field_offset(lv, s48c4f28, ABISELECT(1016,748), "S48C4.s48c4f28");
    check_field_offset(lv, s48c4f29, ABISELECT(1032,756), "S48C4.s48c4f29");
    check_field_offset(lv, s48c4f30, ABISELECT(1048,772), "S48C4.s48c4f30");
    check_field_offset(lv, s48c4f31, ABISELECT(1060,784), "S48C4.s48c4f31");
    check_field_offset(lv, s48c4f32, ABISELECT(1064,788), "S48C4.s48c4f32");
    check_field_offset(lv, s48c4f33, ABISELECT(1080,800), "S48C4.s48c4f33");
    check_field_offset(lv, s48c4f34, ABISELECT(1120,820), "S48C4.s48c4f34");
    check_field_offset(lv, s48c4f35, ABISELECT(1132,832), "S48C4.s48c4f35");
    check_field_offset(lv, s48c4f36, ABISELECT(1184,880), "S48C4.s48c4f36");
    check_field_offset(lv, s48c4f37, ABISELECT(1240,932), "S48C4.s48c4f37");
    check_field_offset(lv, s48c4f38, ABISELECT(1272,956), "S48C4.s48c4f38");
    check_field_offset(lv, s48c4f39, ABISELECT(1280,960), "S48C4.s48c4f39");
    check_field_offset(lv, s48c4f40, ABISELECT(1296,972), "S48C4.s48c4f40");
    check_field_offset(lv, s48c4f41, ABISELECT(1312,984), "S48C4.s48c4f41");
    check_field_offset(lv, s48c4f42, ABISELECT(1328,996), "S48C4.s48c4f42");
    check_field_offset(lv, s48c4f43, ABISELECT(1344,1008), "S48C4.s48c4f43");
    check_field_offset(lv, s48c4f44, ABISELECT(1348,1012), "S48C4.s48c4f44");
    check_field_offset(lv, s48c4f45, ABISELECT(1360,1024), "S48C4.s48c4f45");
    check_field_offset(lv, s48c4f46, ABISELECT(1392,1040), "S48C4.s48c4f46");
    check_field_offset(lv, s48c4f47, ABISELECT(1408,1052), "S48C4.s48c4f47");
    check_field_offset(lv, s48c4f48, ABISELECT(1416,1056), "S48C4.s48c4f48");
    check_field_offset(lv, s48c4f49, ABISELECT(1432,1068), "S48C4.s48c4f49");
    check_field_offset(lv, s48c4f50, ABISELECT(1440,1072), "S48C4.s48c4f50");
    check_field_offset(lv, s48c4f51, ABISELECT(1456,1084), "S48C4.s48c4f51");
    check_field_offset(lv, s48c4f52, ABISELECT(1472,1096), "S48C4.s48c4f52");
    check_field_offset(lv, s48c4f53, ABISELECT(1488,1108), "S48C4.s48c4f53");
    check_field_offset(lv, s48c4f54, ABISELECT(1504,1120), "S48C4.s48c4f54");
    check_field_offset(lv, s48c4f55, ABISELECT(1512,1124), "S48C4.s48c4f55");
    check_field_offset(lv, s48c4f56, ABISELECT(1528,1132), "S48C4.s48c4f56");
    check_field_offset(lv, s48c4f57, ABISELECT(1536,1136), "S48C4.s48c4f57");
    check_field_offset(lv, s48c4f58, ABISELECT(1544,1140), "S48C4.s48c4f58");
    check_field_offset(lv, s48c4f59, ABISELECT(1560,1152), "S48C4.s48c4f59");
    check_field_offset(lv, s48c4f60, ABISELECT(1568,1156), "S48C4.s48c4f60");
    check_field_offset(lv, s48c4f61, ABISELECT(1632,1204), "S48C4.s48c4f61");
    check_field_offset(lv, s48c4f62, ABISELECT(1648,1216), "S48C4.s48c4f62");
    check_field_offset(lv, s48c4f63, ABISELECT(1656,1220), "S48C4.s48c4f63");
    check_field_offset(lv, s48c4f64, ABISELECT(1672,1232), "S48C4.s48c4f64");
    check_field_offset(lv, s48c4f65, ABISELECT(1688,1244), "S48C4.s48c4f65");
    check_field_offset(lv, s48c4f66, ABISELECT(1704,1256), "S48C4.s48c4f66");
    check_field_offset(lv, s48c4f67, ABISELECT(1720,1268), "S48C4.s48c4f67");
    check_field_offset(lv, s48c4f68, ABISELECT(1736,1280), "S48C4.s48c4f68");
    check_field_offset(lv, s48c4f69, ABISELECT(1752,1292), "S48C4.s48c4f69");
    check_field_offset(lv, s48c4f70, ABISELECT(1760,1296), "S48C4.s48c4f70");
    test_class_info(&lv, &cd_S48C4);
    dp->~S48C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C4(Test_S48C4, "S48C4", ABISELECT(1776,1308));

#else // __cplusplus

extern void _ZN5S48C4C1Ev();
extern void _ZN5S48C4D1Ev();
Name_Map name_map_S48C4[] = {
  NSPAIR(_ZN5S48C4C1Ev),
  NSPAIR(_ZN5S48C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S48C7;
extern VTBL_ENTRY _ZTI5S48C7[];
extern  VTBL_ENTRY _ZTV5S48C7[];
extern Class_Descriptor cd_S48C6;
extern VTBL_ENTRY _ZTI5S48C6[];
extern  VTBL_ENTRY _ZTV5S48C6[];
extern Class_Descriptor cd_S48C5;
extern VTBL_ENTRY _ZTI5S48C5[];
extern  VTBL_ENTRY _ZTV5S48C5[];
static Base_Class bases_S48C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S48C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S48C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S48C4[];
extern void _ZN5S48C4D1Ev();
extern void _ZN5S48C4D0Ev();
extern void _ZN5S48C73v11Ev();
extern void _ZN5S48C73v12Ev();
extern void _ZN5S48C73v13Ev();
extern void _ZN5S48C73v14Ev();
extern void _ZN5S48C73v15Ev();
extern void _ZN5S48C73v16Ev();
extern void _ZN5S48C73v17Ev();
extern void _ZN5S48C73v18Ev();
extern void _ZN5S48C73v19Ev();
extern void _ZN5S48C73v20Ev();
extern void _ZN5S48C73v21Ev();
extern void _ZN5S48C73v22Ev();
extern void _ZN5S48C73v23Ev();
extern void _ZN5S48C73v24Ev();
extern void _ZN5S48C73v25Ev();
extern void _ZN5S48C73v26Ev();
extern void _ZN5S48C73v27Ev();
extern void _ZN5S48C73v28Ev();
extern void _ZN5S48C73v29Ev();
extern void _ZN5S48C73v30Ev();
extern void _ZN5S48C73v31Ev();
extern void _ZN5S48C73v32Ev();
extern void _ZN5S48C73v33Ev();
extern void _ZN5S48C73v34Ev();
extern void _ZN5S48C73v35Ev();
extern void _ZN5S48C73v36Ev();
extern void _ZN5S48C73v37Ev();
extern void _ZN5S48C73v38Ev();
extern void _ZN5S48C73v39Ev();
extern void _ZN5S48C73v40Ev();
extern void _ZN5S48C73v41Ev();
extern void _ZN5S48C73v42Ev();
extern void _ZN5S48C73v43Ev();
extern void _ZN5S48C73v44Ev();
extern void _ZN5S48C73v45Ev();
extern void _ZN5S48C73v46Ev();
extern void _ZN5S48C73v47Ev();
extern void _ZN5S48C73v48Ev();
extern void _ZN5S48C73v49Ev();
extern void _ZN5S48C73v50Ev();
extern void _ZN5S48C73v51Ev();
extern void _ZN5S48C73v52Ev();
extern void _ZN5S48C73v53Ev();
extern void _ZN5S48C73v54Ev();
extern void _ZN5S48C73v55Ev();
extern void _ZN5S48C73v56Ev();
extern void _ZN5S48C73v57Ev();
extern void _ZN5S48C73v58Ev();
extern void _ZN5S48C73v59Ev();
extern void _ZN5S48C73v60Ev();
extern void _ZN5S48C73v61Ev();
extern void _ZN5S48C73v62Ev();
extern void _ZN5S48C73v63Ev();
extern void _ZN5S48C73v64Ev();
extern void _ZN5S48C73v65Ev();
extern void _ZN5S48C73v66Ev();
extern void _ZN5S48C73v67Ev();
extern void _ZN5S48C73v68Ev();
extern void _ZN5S48C73v69Ev();
extern void _ZN5S48C73v70Ev();
extern void _ZN5S48C73v71Ev();
extern void _ZN5S48C73v72Ev();
extern void _ZN5S48C73v73Ev();
extern void _ZN5S48C73v74Ev();
extern void _ZN5S48C63v75Ev();
extern void _ZN5S48C63v76Ev();
extern void _ZN5S48C63v77Ev();
extern void _ZN5S48C63v78Ev();
extern void _ZN5S48C63v79Ev();
extern void _ZN5S48C63v80Ev();
extern void _ZN5S48C63v81Ev();
extern void _ZN5S48C63v82Ev();
extern void _ZN5S48C63v83Ev();
extern void _ZN5S48C63v84Ev();
extern void _ZN5S48C63v85Ev();
extern void _ZN5S48C63v86Ev();
extern void _ZN5S48C63v87Ev();
extern void _ZN5S48C63v88Ev();
extern void _ZN5S48C63v89Ev();
extern void _ZN5S48C63v90Ev();
extern void _ZN5S48C63v91Ev();
extern void _ZN5S48C63v92Ev();
extern void _ZN5S48C63v93Ev();
extern void _ZN5S48C63v94Ev();
extern void _ZN5S48C63v95Ev();
extern void _ZN5S48C63v96Ev();
extern void _ZN5S48C63v97Ev();
extern void _ZN5S48C63v98Ev();
extern void _ZN5S48C63v99Ev();
extern void _ZN5S48C64v100Ev();
extern void _ZN5S48C64v101Ev();
extern void _ZN5S48C64v102Ev();
extern void _ZN5S48C64v103Ev();
extern void _ZN5S48C64v104Ev();
extern void _ZN5S48C64v105Ev();
extern void _ZN5S48C64v106Ev();
extern void _ZN5S48C64v107Ev();
extern void _ZN5S48C64v108Ev();
extern void _ZN5S48C64v109Ev();
extern void _ZN5S48C64v110Ev();
extern void _ZN5S48C64v111Ev();
extern void _ZN5S48C64v112Ev();
extern void _ZN5S48C64v113Ev();
extern void _ZN5S48C64v114Ev();
extern void _ZN5S48C64v115Ev();
extern void _ZN5S48C64v116Ev();
extern void _ZN5S48C64v117Ev();
extern void _ZN5S48C64v118Ev();
extern void _ZN5S48C64v119Ev();
extern void _ZN5S48C64v120Ev();
extern void _ZN5S48C64v121Ev();
extern void _ZN5S48C64v122Ev();
extern void _ZN5S48C64v123Ev();
extern void _ZN5S48C64v124Ev();
extern void _ZN5S48C64v125Ev();
extern void _ZN5S48C64v126Ev();
extern void _ZN5S48C64v127Ev();
extern void _ZN5S48C64v128Ev();
extern void _ZN5S48C64v129Ev();
extern void _ZN5S48C64v130Ev();
extern void _ZN5S48C64v131Ev();
extern void _ZN5S48C64v132Ev();
extern void _ZN5S48C64v133Ev();
extern void _ZN5S48C64v134Ev();
extern void _ZN5S48C64v135Ev();
extern void _ZN5S48C64v136Ev();
extern void _ZN5S48C64v137Ev();
extern void _ZN5S48C64v138Ev();
extern void _ZN5S48C64v139Ev();
extern void _ZN5S48C64v140Ev();
extern void _ZN5S48C64v141Ev();
extern void _ZN5S48C64v142Ev();
extern void _ZN5S48C64v143Ev();
extern void _ZN5S48C64v144Ev();
extern void _ZN5S48C64v145Ev();
extern void _ZN5S48C64v146Ev();
extern void _ZN5S48C64v147Ev();
extern void _ZN5S48C64v148Ev();
extern void _ZN5S48C64v149Ev();
extern void _ZN5S48C64v150Ev();
extern void _ZN5S48C64v151Ev();
extern void _ZN5S48C64v152Ev();
extern void _ZN5S48C64v153Ev();
extern void _ZN5S48C64v154Ev();
extern void _ZN5S48C64v155Ev();
extern void _ZN5S48C64v156Ev();
extern void _ZN5S48C64v157Ev();
extern void _ZN5S48C64v158Ev();
extern void _ZN5S48C64v159Ev();
extern void _ZN5S48C64v160Ev();
extern void _ZN5S48C64v161Ev();
extern void _ZN5S48C64v162Ev();
extern void _ZN5S48C64v163Ev();
extern void _ZN5S48C64v164Ev();
extern void _ZN5S48C64v165Ev();
extern void _ZN5S48C64v166Ev();
extern void _ZN5S48C64v167Ev();
extern void _ZN5S48C64v168Ev();
extern void _ZN5S48C64v169Ev();
extern void _ZN5S48C64v170Ev();
extern void _ZN5S48C64v171Ev();
extern void _ZN5S48C64v172Ev();
extern void _ZN5S48C64v173Ev();
extern void _ZN5S48C64v174Ev();
extern void _ZN5S48C64v175Ev();
extern void _ZN5S48C64v176Ev();
extern void _ZN5S48C64v177Ev();
extern void _ZN5S48C64v178Ev();
extern void _ZN5S48C64v179Ev();
extern void _ZN5S48C64v180Ev();
extern void _ZN5S48C64v181Ev();
extern void _ZN5S48C64v182Ev();
extern void _ZN5S48C64v183Ev();
extern void _ZN5S48C64v184Ev();
extern void _ZN5S48C64v185Ev();
extern void _ZN5S48C64v186Ev();
extern void _ZN5S48C64v187Ev();
extern void _ZN5S48C64v188Ev();
extern void _ZN5S48C64v189Ev();
extern void _ZN5S48C64v190Ev();
extern void _ZN5S48C64v191Ev();
extern void _ZN5S48C64v192Ev();
extern void _ZN5S48C64v193Ev();
extern void _ZN5S48C64v194Ev();
extern void _ZN5S48C64v195Ev();
extern void _ZN5S48C64v196Ev();
extern void _ZN5S48C64v197Ev();
extern void _ZN5S48C64v198Ev();
extern void _ZN5S48C64v199Ev();
extern void _ZN5S48C64v200Ev();
extern void _ZN5S48C64v201Ev();
extern void _ZN5S48C64v202Ev();
extern void _ZN5S48C64v203Ev();
extern void _ZN5S48C64v204Ev();
extern void _ZN5S48C64v205Ev();
extern void _ZN5S48C64v206Ev();
extern void _ZN5S48C64v207Ev();
extern void _ZN5S48C64v208Ev();
extern void _ZN5S48C64v209Ev();
extern void _ZN5S48C64v210Ev();
extern void _ZN5S48C64v211Ev();
extern void _ZN5S48C64v212Ev();
extern void _ZN5S48C64v213Ev();
extern void _ZN5S48C64v214Ev();
extern void _ZN5S48C64v215Ev();
extern void _ZN5S48C64v216Ev();
extern void _ZN5S48C64v217Ev();
extern void _ZN5S48C54v218Ev();
extern void _ZN5S48C54v219Ev();
extern void _ZN5S48C54v220Ev();
extern void _ZN5S48C54v221Ev();
extern void _ZN5S48C54v222Ev();
extern void _ZN5S48C54v223Ev();
extern void _ZN5S48C54v224Ev();
extern void _ZN5S48C54v225Ev();
extern void _ZN5S48C54v226Ev();
extern void _ZN5S48C54v227Ev();
extern void _ZN5S48C54v228Ev();
extern void _ZN5S48C54v229Ev();
extern void _ZN5S48C54v230Ev();
extern void _ZN5S48C54v231Ev();
extern void _ZN5S48C54v232Ev();
extern void _ZN5S48C54v233Ev();
extern void _ZN5S48C54v234Ev();
extern void _ZN5S48C54v235Ev();
extern void _ZN5S48C54v236Ev();
extern void _ZN5S48C54v237Ev();
extern void _ZN5S48C54v238Ev();
extern void _ZN5S48C54v239Ev();
extern void _ZN5S48C54v240Ev();
extern void _ZN5S48C54v241Ev();
extern void _ZN5S48C54v242Ev();
extern void _ZN5S48C54v243Ev();
extern void _ZN5S48C54v244Ev();
extern void _ZN5S48C54v245Ev();
extern void _ZN5S48C54v246Ev();
extern void _ZN5S48C54v247Ev();
extern void _ZN5S48C54v248Ev();
extern void _ZN5S48C54v249Ev();
extern void _ZN5S48C54v250Ev();
extern void _ZN5S48C54v251Ev();
extern void _ZN5S48C54v252Ev();
extern void _ZN5S48C54v253Ev();
extern void _ZN5S48C54v254Ev();
extern void _ZN5S48C54v255Ev();
extern void _ZN5S48C54v256Ev();
extern void _ZN5S48C54v257Ev();
extern void _ZN5S48C54v258Ev();
extern void _ZN5S48C54v259Ev();
extern void _ZN5S48C54v260Ev();
extern void _ZN5S48C54v261Ev();
extern void _ZN5S48C54v262Ev();
extern void _ZN5S48C54v263Ev();
extern void _ZN5S48C54v264Ev();
extern void _ZN5S48C54v265Ev();
extern void _ZN5S48C54v266Ev();
extern void _ZN5S48C54v267Ev();
extern void _ZN5S48C44v268Ev();
extern void _ZN5S48C44v269Ev();
extern void _ZN5S48C44v270Ev();
extern void _ZN5S48C44v271Ev();
extern void _ZN5S48C44v272Ev();
extern void _ZN5S48C44v273Ev();
extern void _ZN5S48C44v274Ev();
extern void _ZN5S48C44v275Ev();
extern void _ZN5S48C44v276Ev();
extern void _ZN5S48C44v277Ev();
extern void _ZN5S48C44v278Ev();
extern void _ZN5S48C44v279Ev();
extern void _ZN5S48C44v280Ev();
extern void _ZN5S48C44v281Ev();
extern void _ZN5S48C44v282Ev();
extern void _ZN5S48C44v283Ev();
extern void _ZN5S48C44v284Ev();
extern void _ZN5S48C44v285Ev();
extern void _ZN5S48C44v286Ev();
extern void _ZN5S48C44v287Ev();
extern void _ZN5S48C44v288Ev();
extern void _ZN5S48C44v289Ev();
extern void _ZN5S48C44v290Ev();
extern void _ZN5S48C44v291Ev();
extern void _ZN5S48C44v292Ev();
extern void _ZN5S48C44v293Ev();
extern void _ZN5S48C44v294Ev();
extern void _ZN5S48C44v295Ev();
extern void _ZN5S48C44v296Ev();
extern void _ZN5S48C44v297Ev();
extern void _ZN5S48C44v298Ev();
extern void _ZN5S48C44v299Ev();
extern void _ZN5S48C44v300Ev();
extern void _ZN5S48C44v301Ev();
extern void _ZN5S48C44v302Ev();
extern void _ZN5S48C44v303Ev();
extern void _ZN5S48C44v304Ev();
extern void _ZN5S48C44v305Ev();
static  VTBL_ENTRY vtc_S48C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S48C4[0]),
  (VTBL_ENTRY)&_ZN5S48C4D1Ev,
  (VTBL_ENTRY)&_ZN5S48C4D0Ev,
  (VTBL_ENTRY)&_ZN5S48C73v11Ev,
  (VTBL_ENTRY)&_ZN5S48C73v12Ev,
  (VTBL_ENTRY)&_ZN5S48C73v13Ev,
  (VTBL_ENTRY)&_ZN5S48C73v14Ev,
  (VTBL_ENTRY)&_ZN5S48C73v15Ev,
  (VTBL_ENTRY)&_ZN5S48C73v16Ev,
  (VTBL_ENTRY)&_ZN5S48C73v17Ev,
  (VTBL_ENTRY)&_ZN5S48C73v18Ev,
  (VTBL_ENTRY)&_ZN5S48C73v19Ev,
  (VTBL_ENTRY)&_ZN5S48C73v20Ev,
  (VTBL_ENTRY)&_ZN5S48C73v21Ev,
  (VTBL_ENTRY)&_ZN5S48C73v22Ev,
  (VTBL_ENTRY)&_ZN5S48C73v23Ev,
  (VTBL_ENTRY)&_ZN5S48C73v24Ev,
  (VTBL_ENTRY)&_ZN5S48C73v25Ev,
  (VTBL_ENTRY)&_ZN5S48C73v26Ev,
  (VTBL_ENTRY)&_ZN5S48C73v27Ev,
  (VTBL_ENTRY)&_ZN5S48C73v28Ev,
  (VTBL_ENTRY)&_ZN5S48C73v29Ev,
  (VTBL_ENTRY)&_ZN5S48C73v30Ev,
  (VTBL_ENTRY)&_ZN5S48C73v31Ev,
  (VTBL_ENTRY)&_ZN5S48C73v32Ev,
  (VTBL_ENTRY)&_ZN5S48C73v33Ev,
  (VTBL_ENTRY)&_ZN5S48C73v34Ev,
  (VTBL_ENTRY)&_ZN5S48C73v35Ev,
  (VTBL_ENTRY)&_ZN5S48C73v36Ev,
  (VTBL_ENTRY)&_ZN5S48C73v37Ev,
  (VTBL_ENTRY)&_ZN5S48C73v38Ev,
  (VTBL_ENTRY)&_ZN5S48C73v39Ev,
  (VTBL_ENTRY)&_ZN5S48C73v40Ev,
  (VTBL_ENTRY)&_ZN5S48C73v41Ev,
  (VTBL_ENTRY)&_ZN5S48C73v42Ev,
  (VTBL_ENTRY)&_ZN5S48C73v43Ev,
  (VTBL_ENTRY)&_ZN5S48C73v44Ev,
  (VTBL_ENTRY)&_ZN5S48C73v45Ev,
  (VTBL_ENTRY)&_ZN5S48C73v46Ev,
  (VTBL_ENTRY)&_ZN5S48C73v47Ev,
  (VTBL_ENTRY)&_ZN5S48C73v48Ev,
  (VTBL_ENTRY)&_ZN5S48C73v49Ev,
  (VTBL_ENTRY)&_ZN5S48C73v50Ev,
  (VTBL_ENTRY)&_ZN5S48C73v51Ev,
  (VTBL_ENTRY)&_ZN5S48C73v52Ev,
  (VTBL_ENTRY)&_ZN5S48C73v53Ev,
  (VTBL_ENTRY)&_ZN5S48C73v54Ev,
  (VTBL_ENTRY)&_ZN5S48C73v55Ev,
  (VTBL_ENTRY)&_ZN5S48C73v56Ev,
  (VTBL_ENTRY)&_ZN5S48C73v57Ev,
  (VTBL_ENTRY)&_ZN5S48C73v58Ev,
  (VTBL_ENTRY)&_ZN5S48C73v59Ev,
  (VTBL_ENTRY)&_ZN5S48C73v60Ev,
  (VTBL_ENTRY)&_ZN5S48C73v61Ev,
  (VTBL_ENTRY)&_ZN5S48C73v62Ev,
  (VTBL_ENTRY)&_ZN5S48C73v63Ev,
  (VTBL_ENTRY)&_ZN5S48C73v64Ev,
  (VTBL_ENTRY)&_ZN5S48C73v65Ev,
  (VTBL_ENTRY)&_ZN5S48C73v66Ev,
  (VTBL_ENTRY)&_ZN5S48C73v67Ev,
  (VTBL_ENTRY)&_ZN5S48C73v68Ev,
  (VTBL_ENTRY)&_ZN5S48C73v69Ev,
  (VTBL_ENTRY)&_ZN5S48C73v70Ev,
  (VTBL_ENTRY)&_ZN5S48C73v71Ev,
  (VTBL_ENTRY)&_ZN5S48C73v72Ev,
  (VTBL_ENTRY)&_ZN5S48C73v73Ev,
  (VTBL_ENTRY)&_ZN5S48C73v74Ev,
  (VTBL_ENTRY)&_ZN5S48C63v75Ev,
  (VTBL_ENTRY)&_ZN5S48C63v76Ev,
  (VTBL_ENTRY)&_ZN5S48C63v77Ev,
  (VTBL_ENTRY)&_ZN5S48C63v78Ev,
  (VTBL_ENTRY)&_ZN5S48C63v79Ev,
  (VTBL_ENTRY)&_ZN5S48C63v80Ev,
  (VTBL_ENTRY)&_ZN5S48C63v81Ev,
  (VTBL_ENTRY)&_ZN5S48C63v82Ev,
  (VTBL_ENTRY)&_ZN5S48C63v83Ev,
  (VTBL_ENTRY)&_ZN5S48C63v84Ev,
  (VTBL_ENTRY)&_ZN5S48C63v85Ev,
  (VTBL_ENTRY)&_ZN5S48C63v86Ev,
  (VTBL_ENTRY)&_ZN5S48C63v87Ev,
  (VTBL_ENTRY)&_ZN5S48C63v88Ev,
  (VTBL_ENTRY)&_ZN5S48C63v89Ev,
  (VTBL_ENTRY)&_ZN5S48C63v90Ev,
  (VTBL_ENTRY)&_ZN5S48C63v91Ev,
  (VTBL_ENTRY)&_ZN5S48C63v92Ev,
  (VTBL_ENTRY)&_ZN5S48C63v93Ev,
  (VTBL_ENTRY)&_ZN5S48C63v94Ev,
  (VTBL_ENTRY)&_ZN5S48C63v95Ev,
  (VTBL_ENTRY)&_ZN5S48C63v96Ev,
  (VTBL_ENTRY)&_ZN5S48C63v97Ev,
  (VTBL_ENTRY)&_ZN5S48C63v98Ev,
  (VTBL_ENTRY)&_ZN5S48C63v99Ev,
  (VTBL_ENTRY)&_ZN5S48C64v100Ev,
  (VTBL_ENTRY)&_ZN5S48C64v101Ev,
  (VTBL_ENTRY)&_ZN5S48C64v102Ev,
  (VTBL_ENTRY)&_ZN5S48C64v103Ev,
  (VTBL_ENTRY)&_ZN5S48C64v104Ev,
  (VTBL_ENTRY)&_ZN5S48C64v105Ev,
  (VTBL_ENTRY)&_ZN5S48C64v106Ev,
  (VTBL_ENTRY)&_ZN5S48C64v107Ev,
  (VTBL_ENTRY)&_ZN5S48C64v108Ev,
  (VTBL_ENTRY)&_ZN5S48C64v109Ev,
  (VTBL_ENTRY)&_ZN5S48C64v110Ev,
  (VTBL_ENTRY)&_ZN5S48C64v111Ev,
  (VTBL_ENTRY)&_ZN5S48C64v112Ev,
  (VTBL_ENTRY)&_ZN5S48C64v113Ev,
  (VTBL_ENTRY)&_ZN5S48C64v114Ev,
  (VTBL_ENTRY)&_ZN5S48C64v115Ev,
  (VTBL_ENTRY)&_ZN5S48C64v116Ev,
  (VTBL_ENTRY)&_ZN5S48C64v117Ev,
  (VTBL_ENTRY)&_ZN5S48C64v118Ev,
  (VTBL_ENTRY)&_ZN5S48C64v119Ev,
  (VTBL_ENTRY)&_ZN5S48C64v120Ev,
  (VTBL_ENTRY)&_ZN5S48C64v121Ev,
  (VTBL_ENTRY)&_ZN5S48C64v122Ev,
  (VTBL_ENTRY)&_ZN5S48C64v123Ev,
  (VTBL_ENTRY)&_ZN5S48C64v124Ev,
  (VTBL_ENTRY)&_ZN5S48C64v125Ev,
  (VTBL_ENTRY)&_ZN5S48C64v126Ev,
  (VTBL_ENTRY)&_ZN5S48C64v127Ev,
  (VTBL_ENTRY)&_ZN5S48C64v128Ev,
  (VTBL_ENTRY)&_ZN5S48C64v129Ev,
  (VTBL_ENTRY)&_ZN5S48C64v130Ev,
  (VTBL_ENTRY)&_ZN5S48C64v131Ev,
  (VTBL_ENTRY)&_ZN5S48C64v132Ev,
  (VTBL_ENTRY)&_ZN5S48C64v133Ev,
  (VTBL_ENTRY)&_ZN5S48C64v134Ev,
  (VTBL_ENTRY)&_ZN5S48C64v135Ev,
  (VTBL_ENTRY)&_ZN5S48C64v136Ev,
  (VTBL_ENTRY)&_ZN5S48C64v137Ev,
  (VTBL_ENTRY)&_ZN5S48C64v138Ev,
  (VTBL_ENTRY)&_ZN5S48C64v139Ev,
  (VTBL_ENTRY)&_ZN5S48C64v140Ev,
  (VTBL_ENTRY)&_ZN5S48C64v141Ev,
  (VTBL_ENTRY)&_ZN5S48C64v142Ev,
  (VTBL_ENTRY)&_ZN5S48C64v143Ev,
  (VTBL_ENTRY)&_ZN5S48C64v144Ev,
  (VTBL_ENTRY)&_ZN5S48C64v145Ev,
  (VTBL_ENTRY)&_ZN5S48C64v146Ev,
  (VTBL_ENTRY)&_ZN5S48C64v147Ev,
  (VTBL_ENTRY)&_ZN5S48C64v148Ev,
  (VTBL_ENTRY)&_ZN5S48C64v149Ev,
  (VTBL_ENTRY)&_ZN5S48C64v150Ev,
  (VTBL_ENTRY)&_ZN5S48C64v151Ev,
  (VTBL_ENTRY)&_ZN5S48C64v152Ev,
  (VTBL_ENTRY)&_ZN5S48C64v153Ev,
  (VTBL_ENTRY)&_ZN5S48C64v154Ev,
  (VTBL_ENTRY)&_ZN5S48C64v155Ev,
  (VTBL_ENTRY)&_ZN5S48C64v156Ev,
  (VTBL_ENTRY)&_ZN5S48C64v157Ev,
  (VTBL_ENTRY)&_ZN5S48C64v158Ev,
  (VTBL_ENTRY)&_ZN5S48C64v159Ev,
  (VTBL_ENTRY)&_ZN5S48C64v160Ev,
  (VTBL_ENTRY)&_ZN5S48C64v161Ev,
  (VTBL_ENTRY)&_ZN5S48C64v162Ev,
  (VTBL_ENTRY)&_ZN5S48C64v163Ev,
  (VTBL_ENTRY)&_ZN5S48C64v164Ev,
  (VTBL_ENTRY)&_ZN5S48C64v165Ev,
  (VTBL_ENTRY)&_ZN5S48C64v166Ev,
  (VTBL_ENTRY)&_ZN5S48C64v167Ev,
  (VTBL_ENTRY)&_ZN5S48C64v168Ev,
  (VTBL_ENTRY)&_ZN5S48C64v169Ev,
  (VTBL_ENTRY)&_ZN5S48C64v170Ev,
  (VTBL_ENTRY)&_ZN5S48C64v171Ev,
  (VTBL_ENTRY)&_ZN5S48C64v172Ev,
  (VTBL_ENTRY)&_ZN5S48C64v173Ev,
  (VTBL_ENTRY)&_ZN5S48C64v174Ev,
  (VTBL_ENTRY)&_ZN5S48C64v175Ev,
  (VTBL_ENTRY)&_ZN5S48C64v176Ev,
  (VTBL_ENTRY)&_ZN5S48C64v177Ev,
  (VTBL_ENTRY)&_ZN5S48C64v178Ev,
  (VTBL_ENTRY)&_ZN5S48C64v179Ev,
  (VTBL_ENTRY)&_ZN5S48C64v180Ev,
  (VTBL_ENTRY)&_ZN5S48C64v181Ev,
  (VTBL_ENTRY)&_ZN5S48C64v182Ev,
  (VTBL_ENTRY)&_ZN5S48C64v183Ev,
  (VTBL_ENTRY)&_ZN5S48C64v184Ev,
  (VTBL_ENTRY)&_ZN5S48C64v185Ev,
  (VTBL_ENTRY)&_ZN5S48C64v186Ev,
  (VTBL_ENTRY)&_ZN5S48C64v187Ev,
  (VTBL_ENTRY)&_ZN5S48C64v188Ev,
  (VTBL_ENTRY)&_ZN5S48C64v189Ev,
  (VTBL_ENTRY)&_ZN5S48C64v190Ev,
  (VTBL_ENTRY)&_ZN5S48C64v191Ev,
  (VTBL_ENTRY)&_ZN5S48C64v192Ev,
  (VTBL_ENTRY)&_ZN5S48C64v193Ev,
  (VTBL_ENTRY)&_ZN5S48C64v194Ev,
  (VTBL_ENTRY)&_ZN5S48C64v195Ev,
  (VTBL_ENTRY)&_ZN5S48C64v196Ev,
  (VTBL_ENTRY)&_ZN5S48C64v197Ev,
  (VTBL_ENTRY)&_ZN5S48C64v198Ev,
  (VTBL_ENTRY)&_ZN5S48C64v199Ev,
  (VTBL_ENTRY)&_ZN5S48C64v200Ev,
  (VTBL_ENTRY)&_ZN5S48C64v201Ev,
  (VTBL_ENTRY)&_ZN5S48C64v202Ev,
  (VTBL_ENTRY)&_ZN5S48C64v203Ev,
  (VTBL_ENTRY)&_ZN5S48C64v204Ev,
  (VTBL_ENTRY)&_ZN5S48C64v205Ev,
  (VTBL_ENTRY)&_ZN5S48C64v206Ev,
  (VTBL_ENTRY)&_ZN5S48C64v207Ev,
  (VTBL_ENTRY)&_ZN5S48C64v208Ev,
  (VTBL_ENTRY)&_ZN5S48C64v209Ev,
  (VTBL_ENTRY)&_ZN5S48C64v210Ev,
  (VTBL_ENTRY)&_ZN5S48C64v211Ev,
  (VTBL_ENTRY)&_ZN5S48C64v212Ev,
  (VTBL_ENTRY)&_ZN5S48C64v213Ev,
  (VTBL_ENTRY)&_ZN5S48C64v214Ev,
  (VTBL_ENTRY)&_ZN5S48C64v215Ev,
  (VTBL_ENTRY)&_ZN5S48C64v216Ev,
  (VTBL_ENTRY)&_ZN5S48C64v217Ev,
  (VTBL_ENTRY)&_ZN5S48C54v218Ev,
  (VTBL_ENTRY)&_ZN5S48C54v219Ev,
  (VTBL_ENTRY)&_ZN5S48C54v220Ev,
  (VTBL_ENTRY)&_ZN5S48C54v221Ev,
  (VTBL_ENTRY)&_ZN5S48C54v222Ev,
  (VTBL_ENTRY)&_ZN5S48C54v223Ev,
  (VTBL_ENTRY)&_ZN5S48C54v224Ev,
  (VTBL_ENTRY)&_ZN5S48C54v225Ev,
  (VTBL_ENTRY)&_ZN5S48C54v226Ev,
  (VTBL_ENTRY)&_ZN5S48C54v227Ev,
  (VTBL_ENTRY)&_ZN5S48C54v228Ev,
  (VTBL_ENTRY)&_ZN5S48C54v229Ev,
  (VTBL_ENTRY)&_ZN5S48C54v230Ev,
  (VTBL_ENTRY)&_ZN5S48C54v231Ev,
  (VTBL_ENTRY)&_ZN5S48C54v232Ev,
  (VTBL_ENTRY)&_ZN5S48C54v233Ev,
  (VTBL_ENTRY)&_ZN5S48C54v234Ev,
  (VTBL_ENTRY)&_ZN5S48C54v235Ev,
  (VTBL_ENTRY)&_ZN5S48C54v236Ev,
  (VTBL_ENTRY)&_ZN5S48C54v237Ev,
  (VTBL_ENTRY)&_ZN5S48C54v238Ev,
  (VTBL_ENTRY)&_ZN5S48C54v239Ev,
  (VTBL_ENTRY)&_ZN5S48C54v240Ev,
  (VTBL_ENTRY)&_ZN5S48C54v241Ev,
  (VTBL_ENTRY)&_ZN5S48C54v242Ev,
  (VTBL_ENTRY)&_ZN5S48C54v243Ev,
  (VTBL_ENTRY)&_ZN5S48C54v244Ev,
  (VTBL_ENTRY)&_ZN5S48C54v245Ev,
  (VTBL_ENTRY)&_ZN5S48C54v246Ev,
  (VTBL_ENTRY)&_ZN5S48C54v247Ev,
  (VTBL_ENTRY)&_ZN5S48C54v248Ev,
  (VTBL_ENTRY)&_ZN5S48C54v249Ev,
  (VTBL_ENTRY)&_ZN5S48C54v250Ev,
  (VTBL_ENTRY)&_ZN5S48C54v251Ev,
  (VTBL_ENTRY)&_ZN5S48C54v252Ev,
  (VTBL_ENTRY)&_ZN5S48C54v253Ev,
  (VTBL_ENTRY)&_ZN5S48C54v254Ev,
  (VTBL_ENTRY)&_ZN5S48C54v255Ev,
  (VTBL_ENTRY)&_ZN5S48C54v256Ev,
  (VTBL_ENTRY)&_ZN5S48C54v257Ev,
  (VTBL_ENTRY)&_ZN5S48C54v258Ev,
  (VTBL_ENTRY)&_ZN5S48C54v259Ev,
  (VTBL_ENTRY)&_ZN5S48C54v260Ev,
  (VTBL_ENTRY)&_ZN5S48C54v261Ev,
  (VTBL_ENTRY)&_ZN5S48C54v262Ev,
  (VTBL_ENTRY)&_ZN5S48C54v263Ev,
  (VTBL_ENTRY)&_ZN5S48C54v264Ev,
  (VTBL_ENTRY)&_ZN5S48C54v265Ev,
  (VTBL_ENTRY)&_ZN5S48C54v266Ev,
  (VTBL_ENTRY)&_ZN5S48C54v267Ev,
  (VTBL_ENTRY)&_ZN5S48C44v268Ev,
  (VTBL_ENTRY)&_ZN5S48C44v269Ev,
  (VTBL_ENTRY)&_ZN5S48C44v270Ev,
  (VTBL_ENTRY)&_ZN5S48C44v271Ev,
  (VTBL_ENTRY)&_ZN5S48C44v272Ev,
  (VTBL_ENTRY)&_ZN5S48C44v273Ev,
  (VTBL_ENTRY)&_ZN5S48C44v274Ev,
  (VTBL_ENTRY)&_ZN5S48C44v275Ev,
  (VTBL_ENTRY)&_ZN5S48C44v276Ev,
  (VTBL_ENTRY)&_ZN5S48C44v277Ev,
  (VTBL_ENTRY)&_ZN5S48C44v278Ev,
  (VTBL_ENTRY)&_ZN5S48C44v279Ev,
  (VTBL_ENTRY)&_ZN5S48C44v280Ev,
  (VTBL_ENTRY)&_ZN5S48C44v281Ev,
  (VTBL_ENTRY)&_ZN5S48C44v282Ev,
  (VTBL_ENTRY)&_ZN5S48C44v283Ev,
  (VTBL_ENTRY)&_ZN5S48C44v284Ev,
  (VTBL_ENTRY)&_ZN5S48C44v285Ev,
  (VTBL_ENTRY)&_ZN5S48C44v286Ev,
  (VTBL_ENTRY)&_ZN5S48C44v287Ev,
  (VTBL_ENTRY)&_ZN5S48C44v288Ev,
  (VTBL_ENTRY)&_ZN5S48C44v289Ev,
  (VTBL_ENTRY)&_ZN5S48C44v290Ev,
  (VTBL_ENTRY)&_ZN5S48C44v291Ev,
  (VTBL_ENTRY)&_ZN5S48C44v292Ev,
  (VTBL_ENTRY)&_ZN5S48C44v293Ev,
  (VTBL_ENTRY)&_ZN5S48C44v294Ev,
  (VTBL_ENTRY)&_ZN5S48C44v295Ev,
  (VTBL_ENTRY)&_ZN5S48C44v296Ev,
  (VTBL_ENTRY)&_ZN5S48C44v297Ev,
  (VTBL_ENTRY)&_ZN5S48C44v298Ev,
  (VTBL_ENTRY)&_ZN5S48C44v299Ev,
  (VTBL_ENTRY)&_ZN5S48C44v300Ev,
  (VTBL_ENTRY)&_ZN5S48C44v301Ev,
  (VTBL_ENTRY)&_ZN5S48C44v302Ev,
  (VTBL_ENTRY)&_ZN5S48C44v303Ev,
  (VTBL_ENTRY)&_ZN5S48C44v304Ev,
  (VTBL_ENTRY)&_ZN5S48C44v305Ev,
};
extern VTBL_ENTRY _ZTI5S48C4[];
extern  VTBL_ENTRY _ZTV5S48C4[];
Class_Descriptor cd_S48C4 = {  "S48C4", // class name
  bases_S48C4, 3,
  &(vtc_S48C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1776,1308), // object size
  NSPAIRA(_ZTI5S48C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S48C4),299, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C3  : S48C4 {
  virtual  ~S48C3(); // _ZN5S48C3D1Ev
  virtual void  v306(); // _ZN5S48C34v306Ev
  virtual void  v307(); // _ZN5S48C34v307Ev
  virtual void  v308(); // _ZN5S48C34v308Ev
  S48C3(); // tgen
};
//SIG(-1 S48C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 FC10{ m Fi} Fi Fc[4] Fp[2] FC11{ BC12{ BC9}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC6 FC6 FC6 FC13{ BC14{ BC9}} FC13 Fi Fp[2] FC15{ m Fi[3]} FC16{ m Fi[3]} FC15 FC15 Fp FC6 FC13 FC15 FC16 Fi FC15 FC15 Fp Fi Fc FC16 FC16 Fp Fi Fp FC17{ BC18{ BC9}} FC19{ BC20{ BC9}} FC21{ BC22{ BC9}}} vd v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC15 FC15 Fp[5] FC15 Fp FC23{ BC24{ BC9}} Fp[2] FC15 Fp Fi[2] Fp Fi FC15 FC15 FC15 Fp[2] Fi FC15 Fi[4] Fp[2] FC25{ BC26{ BC9}} Fi FC16} vd v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC16 Fi FC16 Fp[5] FC15 Fi[12] FC27{ Fi Fc FC15 FC15 Fp FC15 Fc} FC28{ BC21}[2] Fi FC28 FC28 FC28 FC28 Fi FC15 Fp[4] FC15 Fp FC28 Fp FC29{ BC30{ BC9}} FC31{ BC32{ BC9}} FC31 FC31 Fp FC33{ BC34{ m Fp[2]}} Fp Fi FC35{ BC36{ BC9}} Fi FC28[4] FC35 Fp FC37{ BC38{ BC9}} Fi[3] FC37 FC37 FC13 FC39{ BC40{ BC9}} Fi FC41{ m Fp FC6}} vd v1 v2 v3}


 S48C3 ::~S48C3(){ note_dtor("S48C3", this);}
void  S48C3 ::v306(){vfunc_called(this, "_ZN5S48C34v306Ev");}
void  S48C3 ::v307(){vfunc_called(this, "_ZN5S48C34v307Ev");}
void  S48C3 ::v308(){vfunc_called(this, "_ZN5S48C34v308Ev");}
S48C3 ::S48C3(){ note_ctor("S48C3", this);} // tgen

static void Test_S48C3()
{
  extern Class_Descriptor cd_S48C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(223,328)];
    init_test(&cd_S48C3, buf);
    S48C3 *dp, &lv = *(dp=new (buf) S48C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1776,1308), "sizeof(S48C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C3)");
    check_base_class_offset(lv, (S48C7*)(S48C6*)(S48C5*)(S48C4*), 0, "S48C3");
    check_base_class_offset(lv, (S48C6*)(S48C5*)(S48C4*), 0, "S48C3");
    check_base_class_offset(lv, (S48C5*)(S48C4*), 0, "S48C3");
    check_base_class_offset(lv, (S48C4*), 0, "S48C3");
    test_class_info(&lv, &cd_S48C3);
    dp->~S48C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C3(Test_S48C3, "S48C3", ABISELECT(1776,1308));

#else // __cplusplus

extern void _ZN5S48C3C1Ev();
extern void _ZN5S48C3D1Ev();
Name_Map name_map_S48C3[] = {
  NSPAIR(_ZN5S48C3C1Ev),
  NSPAIR(_ZN5S48C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S48C7;
extern VTBL_ENTRY _ZTI5S48C7[];
extern  VTBL_ENTRY _ZTV5S48C7[];
extern Class_Descriptor cd_S48C6;
extern VTBL_ENTRY _ZTI5S48C6[];
extern  VTBL_ENTRY _ZTV5S48C6[];
extern Class_Descriptor cd_S48C5;
extern VTBL_ENTRY _ZTI5S48C5[];
extern  VTBL_ENTRY _ZTV5S48C5[];
extern Class_Descriptor cd_S48C4;
extern VTBL_ENTRY _ZTI5S48C4[];
extern  VTBL_ENTRY _ZTV5S48C4[];
static Base_Class bases_S48C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S48C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S48C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S48C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S48C3[];
extern void _ZN5S48C3D1Ev();
extern void _ZN5S48C3D0Ev();
extern void _ZN5S48C73v11Ev();
extern void _ZN5S48C73v12Ev();
extern void _ZN5S48C73v13Ev();
extern void _ZN5S48C73v14Ev();
extern void _ZN5S48C73v15Ev();
extern void _ZN5S48C73v16Ev();
extern void _ZN5S48C73v17Ev();
extern void _ZN5S48C73v18Ev();
extern void _ZN5S48C73v19Ev();
extern void _ZN5S48C73v20Ev();
extern void _ZN5S48C73v21Ev();
extern void _ZN5S48C73v22Ev();
extern void _ZN5S48C73v23Ev();
extern void _ZN5S48C73v24Ev();
extern void _ZN5S48C73v25Ev();
extern void _ZN5S48C73v26Ev();
extern void _ZN5S48C73v27Ev();
extern void _ZN5S48C73v28Ev();
extern void _ZN5S48C73v29Ev();
extern void _ZN5S48C73v30Ev();
extern void _ZN5S48C73v31Ev();
extern void _ZN5S48C73v32Ev();
extern void _ZN5S48C73v33Ev();
extern void _ZN5S48C73v34Ev();
extern void _ZN5S48C73v35Ev();
extern void _ZN5S48C73v36Ev();
extern void _ZN5S48C73v37Ev();
extern void _ZN5S48C73v38Ev();
extern void _ZN5S48C73v39Ev();
extern void _ZN5S48C73v40Ev();
extern void _ZN5S48C73v41Ev();
extern void _ZN5S48C73v42Ev();
extern void _ZN5S48C73v43Ev();
extern void _ZN5S48C73v44Ev();
extern void _ZN5S48C73v45Ev();
extern void _ZN5S48C73v46Ev();
extern void _ZN5S48C73v47Ev();
extern void _ZN5S48C73v48Ev();
extern void _ZN5S48C73v49Ev();
extern void _ZN5S48C73v50Ev();
extern void _ZN5S48C73v51Ev();
extern void _ZN5S48C73v52Ev();
extern void _ZN5S48C73v53Ev();
extern void _ZN5S48C73v54Ev();
extern void _ZN5S48C73v55Ev();
extern void _ZN5S48C73v56Ev();
extern void _ZN5S48C73v57Ev();
extern void _ZN5S48C73v58Ev();
extern void _ZN5S48C73v59Ev();
extern void _ZN5S48C73v60Ev();
extern void _ZN5S48C73v61Ev();
extern void _ZN5S48C73v62Ev();
extern void _ZN5S48C73v63Ev();
extern void _ZN5S48C73v64Ev();
extern void _ZN5S48C73v65Ev();
extern void _ZN5S48C73v66Ev();
extern void _ZN5S48C73v67Ev();
extern void _ZN5S48C73v68Ev();
extern void _ZN5S48C73v69Ev();
extern void _ZN5S48C73v70Ev();
extern void _ZN5S48C73v71Ev();
extern void _ZN5S48C73v72Ev();
extern void _ZN5S48C73v73Ev();
extern void _ZN5S48C73v74Ev();
extern void _ZN5S48C63v75Ev();
extern void _ZN5S48C63v76Ev();
extern void _ZN5S48C63v77Ev();
extern void _ZN5S48C63v78Ev();
extern void _ZN5S48C63v79Ev();
extern void _ZN5S48C63v80Ev();
extern void _ZN5S48C63v81Ev();
extern void _ZN5S48C63v82Ev();
extern void _ZN5S48C63v83Ev();
extern void _ZN5S48C63v84Ev();
extern void _ZN5S48C63v85Ev();
extern void _ZN5S48C63v86Ev();
extern void _ZN5S48C63v87Ev();
extern void _ZN5S48C63v88Ev();
extern void _ZN5S48C63v89Ev();
extern void _ZN5S48C63v90Ev();
extern void _ZN5S48C63v91Ev();
extern void _ZN5S48C63v92Ev();
extern void _ZN5S48C63v93Ev();
extern void _ZN5S48C63v94Ev();
extern void _ZN5S48C63v95Ev();
extern void _ZN5S48C63v96Ev();
extern void _ZN5S48C63v97Ev();
extern void _ZN5S48C63v98Ev();
extern void _ZN5S48C63v99Ev();
extern void _ZN5S48C64v100Ev();
extern void _ZN5S48C64v101Ev();
extern void _ZN5S48C64v102Ev();
extern void _ZN5S48C64v103Ev();
extern void _ZN5S48C64v104Ev();
extern void _ZN5S48C64v105Ev();
extern void _ZN5S48C64v106Ev();
extern void _ZN5S48C64v107Ev();
extern void _ZN5S48C64v108Ev();
extern void _ZN5S48C64v109Ev();
extern void _ZN5S48C64v110Ev();
extern void _ZN5S48C64v111Ev();
extern void _ZN5S48C64v112Ev();
extern void _ZN5S48C64v113Ev();
extern void _ZN5S48C64v114Ev();
extern void _ZN5S48C64v115Ev();
extern void _ZN5S48C64v116Ev();
extern void _ZN5S48C64v117Ev();
extern void _ZN5S48C64v118Ev();
extern void _ZN5S48C64v119Ev();
extern void _ZN5S48C64v120Ev();
extern void _ZN5S48C64v121Ev();
extern void _ZN5S48C64v122Ev();
extern void _ZN5S48C64v123Ev();
extern void _ZN5S48C64v124Ev();
extern void _ZN5S48C64v125Ev();
extern void _ZN5S48C64v126Ev();
extern void _ZN5S48C64v127Ev();
extern void _ZN5S48C64v128Ev();
extern void _ZN5S48C64v129Ev();
extern void _ZN5S48C64v130Ev();
extern void _ZN5S48C64v131Ev();
extern void _ZN5S48C64v132Ev();
extern void _ZN5S48C64v133Ev();
extern void _ZN5S48C64v134Ev();
extern void _ZN5S48C64v135Ev();
extern void _ZN5S48C64v136Ev();
extern void _ZN5S48C64v137Ev();
extern void _ZN5S48C64v138Ev();
extern void _ZN5S48C64v139Ev();
extern void _ZN5S48C64v140Ev();
extern void _ZN5S48C64v141Ev();
extern void _ZN5S48C64v142Ev();
extern void _ZN5S48C64v143Ev();
extern void _ZN5S48C64v144Ev();
extern void _ZN5S48C64v145Ev();
extern void _ZN5S48C64v146Ev();
extern void _ZN5S48C64v147Ev();
extern void _ZN5S48C64v148Ev();
extern void _ZN5S48C64v149Ev();
extern void _ZN5S48C64v150Ev();
extern void _ZN5S48C64v151Ev();
extern void _ZN5S48C64v152Ev();
extern void _ZN5S48C64v153Ev();
extern void _ZN5S48C64v154Ev();
extern void _ZN5S48C64v155Ev();
extern void _ZN5S48C64v156Ev();
extern void _ZN5S48C64v157Ev();
extern void _ZN5S48C64v158Ev();
extern void _ZN5S48C64v159Ev();
extern void _ZN5S48C64v160Ev();
extern void _ZN5S48C64v161Ev();
extern void _ZN5S48C64v162Ev();
extern void _ZN5S48C64v163Ev();
extern void _ZN5S48C64v164Ev();
extern void _ZN5S48C64v165Ev();
extern void _ZN5S48C64v166Ev();
extern void _ZN5S48C64v167Ev();
extern void _ZN5S48C64v168Ev();
extern void _ZN5S48C64v169Ev();
extern void _ZN5S48C64v170Ev();
extern void _ZN5S48C64v171Ev();
extern void _ZN5S48C64v172Ev();
extern void _ZN5S48C64v173Ev();
extern void _ZN5S48C64v174Ev();
extern void _ZN5S48C64v175Ev();
extern void _ZN5S48C64v176Ev();
extern void _ZN5S48C64v177Ev();
extern void _ZN5S48C64v178Ev();
extern void _ZN5S48C64v179Ev();
extern void _ZN5S48C64v180Ev();
extern void _ZN5S48C64v181Ev();
extern void _ZN5S48C64v182Ev();
extern void _ZN5S48C64v183Ev();
extern void _ZN5S48C64v184Ev();
extern void _ZN5S48C64v185Ev();
extern void _ZN5S48C64v186Ev();
extern void _ZN5S48C64v187Ev();
extern void _ZN5S48C64v188Ev();
extern void _ZN5S48C64v189Ev();
extern void _ZN5S48C64v190Ev();
extern void _ZN5S48C64v191Ev();
extern void _ZN5S48C64v192Ev();
extern void _ZN5S48C64v193Ev();
extern void _ZN5S48C64v194Ev();
extern void _ZN5S48C64v195Ev();
extern void _ZN5S48C64v196Ev();
extern void _ZN5S48C64v197Ev();
extern void _ZN5S48C64v198Ev();
extern void _ZN5S48C64v199Ev();
extern void _ZN5S48C64v200Ev();
extern void _ZN5S48C64v201Ev();
extern void _ZN5S48C64v202Ev();
extern void _ZN5S48C64v203Ev();
extern void _ZN5S48C64v204Ev();
extern void _ZN5S48C64v205Ev();
extern void _ZN5S48C64v206Ev();
extern void _ZN5S48C64v207Ev();
extern void _ZN5S48C64v208Ev();
extern void _ZN5S48C64v209Ev();
extern void _ZN5S48C64v210Ev();
extern void _ZN5S48C64v211Ev();
extern void _ZN5S48C64v212Ev();
extern void _ZN5S48C64v213Ev();
extern void _ZN5S48C64v214Ev();
extern void _ZN5S48C64v215Ev();
extern void _ZN5S48C64v216Ev();
extern void _ZN5S48C64v217Ev();
extern void _ZN5S48C54v218Ev();
extern void _ZN5S48C54v219Ev();
extern void _ZN5S48C54v220Ev();
extern void _ZN5S48C54v221Ev();
extern void _ZN5S48C54v222Ev();
extern void _ZN5S48C54v223Ev();
extern void _ZN5S48C54v224Ev();
extern void _ZN5S48C54v225Ev();
extern void _ZN5S48C54v226Ev();
extern void _ZN5S48C54v227Ev();
extern void _ZN5S48C54v228Ev();
extern void _ZN5S48C54v229Ev();
extern void _ZN5S48C54v230Ev();
extern void _ZN5S48C54v231Ev();
extern void _ZN5S48C54v232Ev();
extern void _ZN5S48C54v233Ev();
extern void _ZN5S48C54v234Ev();
extern void _ZN5S48C54v235Ev();
extern void _ZN5S48C54v236Ev();
extern void _ZN5S48C54v237Ev();
extern void _ZN5S48C54v238Ev();
extern void _ZN5S48C54v239Ev();
extern void _ZN5S48C54v240Ev();
extern void _ZN5S48C54v241Ev();
extern void _ZN5S48C54v242Ev();
extern void _ZN5S48C54v243Ev();
extern void _ZN5S48C54v244Ev();
extern void _ZN5S48C54v245Ev();
extern void _ZN5S48C54v246Ev();
extern void _ZN5S48C54v247Ev();
extern void _ZN5S48C54v248Ev();
extern void _ZN5S48C54v249Ev();
extern void _ZN5S48C54v250Ev();
extern void _ZN5S48C54v251Ev();
extern void _ZN5S48C54v252Ev();
extern void _ZN5S48C54v253Ev();
extern void _ZN5S48C54v254Ev();
extern void _ZN5S48C54v255Ev();
extern void _ZN5S48C54v256Ev();
extern void _ZN5S48C54v257Ev();
extern void _ZN5S48C54v258Ev();
extern void _ZN5S48C54v259Ev();
extern void _ZN5S48C54v260Ev();
extern void _ZN5S48C54v261Ev();
extern void _ZN5S48C54v262Ev();
extern void _ZN5S48C54v263Ev();
extern void _ZN5S48C54v264Ev();
extern void _ZN5S48C54v265Ev();
extern void _ZN5S48C54v266Ev();
extern void _ZN5S48C54v267Ev();
extern void _ZN5S48C44v268Ev();
extern void _ZN5S48C44v269Ev();
extern void _ZN5S48C44v270Ev();
extern void _ZN5S48C44v271Ev();
extern void _ZN5S48C44v272Ev();
extern void _ZN5S48C44v273Ev();
extern void _ZN5S48C44v274Ev();
extern void _ZN5S48C44v275Ev();
extern void _ZN5S48C44v276Ev();
extern void _ZN5S48C44v277Ev();
extern void _ZN5S48C44v278Ev();
extern void _ZN5S48C44v279Ev();
extern void _ZN5S48C44v280Ev();
extern void _ZN5S48C44v281Ev();
extern void _ZN5S48C44v282Ev();
extern void _ZN5S48C44v283Ev();
extern void _ZN5S48C44v284Ev();
extern void _ZN5S48C44v285Ev();
extern void _ZN5S48C44v286Ev();
extern void _ZN5S48C44v287Ev();
extern void _ZN5S48C44v288Ev();
extern void _ZN5S48C44v289Ev();
extern void _ZN5S48C44v290Ev();
extern void _ZN5S48C44v291Ev();
extern void _ZN5S48C44v292Ev();
extern void _ZN5S48C44v293Ev();
extern void _ZN5S48C44v294Ev();
extern void _ZN5S48C44v295Ev();
extern void _ZN5S48C44v296Ev();
extern void _ZN5S48C44v297Ev();
extern void _ZN5S48C44v298Ev();
extern void _ZN5S48C44v299Ev();
extern void _ZN5S48C44v300Ev();
extern void _ZN5S48C44v301Ev();
extern void _ZN5S48C44v302Ev();
extern void _ZN5S48C44v303Ev();
extern void _ZN5S48C44v304Ev();
extern void _ZN5S48C44v305Ev();
extern void _ZN5S48C34v306Ev();
extern void _ZN5S48C34v307Ev();
extern void _ZN5S48C34v308Ev();
static  VTBL_ENTRY vtc_S48C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S48C3[0]),
  (VTBL_ENTRY)&_ZN5S48C3D1Ev,
  (VTBL_ENTRY)&_ZN5S48C3D0Ev,
  (VTBL_ENTRY)&_ZN5S48C73v11Ev,
  (VTBL_ENTRY)&_ZN5S48C73v12Ev,
  (VTBL_ENTRY)&_ZN5S48C73v13Ev,
  (VTBL_ENTRY)&_ZN5S48C73v14Ev,
  (VTBL_ENTRY)&_ZN5S48C73v15Ev,
  (VTBL_ENTRY)&_ZN5S48C73v16Ev,
  (VTBL_ENTRY)&_ZN5S48C73v17Ev,
  (VTBL_ENTRY)&_ZN5S48C73v18Ev,
  (VTBL_ENTRY)&_ZN5S48C73v19Ev,
  (VTBL_ENTRY)&_ZN5S48C73v20Ev,
  (VTBL_ENTRY)&_ZN5S48C73v21Ev,
  (VTBL_ENTRY)&_ZN5S48C73v22Ev,
  (VTBL_ENTRY)&_ZN5S48C73v23Ev,
  (VTBL_ENTRY)&_ZN5S48C73v24Ev,
  (VTBL_ENTRY)&_ZN5S48C73v25Ev,
  (VTBL_ENTRY)&_ZN5S48C73v26Ev,
  (VTBL_ENTRY)&_ZN5S48C73v27Ev,
  (VTBL_ENTRY)&_ZN5S48C73v28Ev,
  (VTBL_ENTRY)&_ZN5S48C73v29Ev,
  (VTBL_ENTRY)&_ZN5S48C73v30Ev,
  (VTBL_ENTRY)&_ZN5S48C73v31Ev,
  (VTBL_ENTRY)&_ZN5S48C73v32Ev,
  (VTBL_ENTRY)&_ZN5S48C73v33Ev,
  (VTBL_ENTRY)&_ZN5S48C73v34Ev,
  (VTBL_ENTRY)&_ZN5S48C73v35Ev,
  (VTBL_ENTRY)&_ZN5S48C73v36Ev,
  (VTBL_ENTRY)&_ZN5S48C73v37Ev,
  (VTBL_ENTRY)&_ZN5S48C73v38Ev,
  (VTBL_ENTRY)&_ZN5S48C73v39Ev,
  (VTBL_ENTRY)&_ZN5S48C73v40Ev,
  (VTBL_ENTRY)&_ZN5S48C73v41Ev,
  (VTBL_ENTRY)&_ZN5S48C73v42Ev,
  (VTBL_ENTRY)&_ZN5S48C73v43Ev,
  (VTBL_ENTRY)&_ZN5S48C73v44Ev,
  (VTBL_ENTRY)&_ZN5S48C73v45Ev,
  (VTBL_ENTRY)&_ZN5S48C73v46Ev,
  (VTBL_ENTRY)&_ZN5S48C73v47Ev,
  (VTBL_ENTRY)&_ZN5S48C73v48Ev,
  (VTBL_ENTRY)&_ZN5S48C73v49Ev,
  (VTBL_ENTRY)&_ZN5S48C73v50Ev,
  (VTBL_ENTRY)&_ZN5S48C73v51Ev,
  (VTBL_ENTRY)&_ZN5S48C73v52Ev,
  (VTBL_ENTRY)&_ZN5S48C73v53Ev,
  (VTBL_ENTRY)&_ZN5S48C73v54Ev,
  (VTBL_ENTRY)&_ZN5S48C73v55Ev,
  (VTBL_ENTRY)&_ZN5S48C73v56Ev,
  (VTBL_ENTRY)&_ZN5S48C73v57Ev,
  (VTBL_ENTRY)&_ZN5S48C73v58Ev,
  (VTBL_ENTRY)&_ZN5S48C73v59Ev,
  (VTBL_ENTRY)&_ZN5S48C73v60Ev,
  (VTBL_ENTRY)&_ZN5S48C73v61Ev,
  (VTBL_ENTRY)&_ZN5S48C73v62Ev,
  (VTBL_ENTRY)&_ZN5S48C73v63Ev,
  (VTBL_ENTRY)&_ZN5S48C73v64Ev,
  (VTBL_ENTRY)&_ZN5S48C73v65Ev,
  (VTBL_ENTRY)&_ZN5S48C73v66Ev,
  (VTBL_ENTRY)&_ZN5S48C73v67Ev,
  (VTBL_ENTRY)&_ZN5S48C73v68Ev,
  (VTBL_ENTRY)&_ZN5S48C73v69Ev,
  (VTBL_ENTRY)&_ZN5S48C73v70Ev,
  (VTBL_ENTRY)&_ZN5S48C73v71Ev,
  (VTBL_ENTRY)&_ZN5S48C73v72Ev,
  (VTBL_ENTRY)&_ZN5S48C73v73Ev,
  (VTBL_ENTRY)&_ZN5S48C73v74Ev,
  (VTBL_ENTRY)&_ZN5S48C63v75Ev,
  (VTBL_ENTRY)&_ZN5S48C63v76Ev,
  (VTBL_ENTRY)&_ZN5S48C63v77Ev,
  (VTBL_ENTRY)&_ZN5S48C63v78Ev,
  (VTBL_ENTRY)&_ZN5S48C63v79Ev,
  (VTBL_ENTRY)&_ZN5S48C63v80Ev,
  (VTBL_ENTRY)&_ZN5S48C63v81Ev,
  (VTBL_ENTRY)&_ZN5S48C63v82Ev,
  (VTBL_ENTRY)&_ZN5S48C63v83Ev,
  (VTBL_ENTRY)&_ZN5S48C63v84Ev,
  (VTBL_ENTRY)&_ZN5S48C63v85Ev,
  (VTBL_ENTRY)&_ZN5S48C63v86Ev,
  (VTBL_ENTRY)&_ZN5S48C63v87Ev,
  (VTBL_ENTRY)&_ZN5S48C63v88Ev,
  (VTBL_ENTRY)&_ZN5S48C63v89Ev,
  (VTBL_ENTRY)&_ZN5S48C63v90Ev,
  (VTBL_ENTRY)&_ZN5S48C63v91Ev,
  (VTBL_ENTRY)&_ZN5S48C63v92Ev,
  (VTBL_ENTRY)&_ZN5S48C63v93Ev,
  (VTBL_ENTRY)&_ZN5S48C63v94Ev,
  (VTBL_ENTRY)&_ZN5S48C63v95Ev,
  (VTBL_ENTRY)&_ZN5S48C63v96Ev,
  (VTBL_ENTRY)&_ZN5S48C63v97Ev,
  (VTBL_ENTRY)&_ZN5S48C63v98Ev,
  (VTBL_ENTRY)&_ZN5S48C63v99Ev,
  (VTBL_ENTRY)&_ZN5S48C64v100Ev,
  (VTBL_ENTRY)&_ZN5S48C64v101Ev,
  (VTBL_ENTRY)&_ZN5S48C64v102Ev,
  (VTBL_ENTRY)&_ZN5S48C64v103Ev,
  (VTBL_ENTRY)&_ZN5S48C64v104Ev,
  (VTBL_ENTRY)&_ZN5S48C64v105Ev,
  (VTBL_ENTRY)&_ZN5S48C64v106Ev,
  (VTBL_ENTRY)&_ZN5S48C64v107Ev,
  (VTBL_ENTRY)&_ZN5S48C64v108Ev,
  (VTBL_ENTRY)&_ZN5S48C64v109Ev,
  (VTBL_ENTRY)&_ZN5S48C64v110Ev,
  (VTBL_ENTRY)&_ZN5S48C64v111Ev,
  (VTBL_ENTRY)&_ZN5S48C64v112Ev,
  (VTBL_ENTRY)&_ZN5S48C64v113Ev,
  (VTBL_ENTRY)&_ZN5S48C64v114Ev,
  (VTBL_ENTRY)&_ZN5S48C64v115Ev,
  (VTBL_ENTRY)&_ZN5S48C64v116Ev,
  (VTBL_ENTRY)&_ZN5S48C64v117Ev,
  (VTBL_ENTRY)&_ZN5S48C64v118Ev,
  (VTBL_ENTRY)&_ZN5S48C64v119Ev,
  (VTBL_ENTRY)&_ZN5S48C64v120Ev,
  (VTBL_ENTRY)&_ZN5S48C64v121Ev,
  (VTBL_ENTRY)&_ZN5S48C64v122Ev,
  (VTBL_ENTRY)&_ZN5S48C64v123Ev,
  (VTBL_ENTRY)&_ZN5S48C64v124Ev,
  (VTBL_ENTRY)&_ZN5S48C64v125Ev,
  (VTBL_ENTRY)&_ZN5S48C64v126Ev,
  (VTBL_ENTRY)&_ZN5S48C64v127Ev,
  (VTBL_ENTRY)&_ZN5S48C64v128Ev,
  (VTBL_ENTRY)&_ZN5S48C64v129Ev,
  (VTBL_ENTRY)&_ZN5S48C64v130Ev,
  (VTBL_ENTRY)&_ZN5S48C64v131Ev,
  (VTBL_ENTRY)&_ZN5S48C64v132Ev,
  (VTBL_ENTRY)&_ZN5S48C64v133Ev,
  (VTBL_ENTRY)&_ZN5S48C64v134Ev,
  (VTBL_ENTRY)&_ZN5S48C64v135Ev,
  (VTBL_ENTRY)&_ZN5S48C64v136Ev,
  (VTBL_ENTRY)&_ZN5S48C64v137Ev,
  (VTBL_ENTRY)&_ZN5S48C64v138Ev,
  (VTBL_ENTRY)&_ZN5S48C64v139Ev,
  (VTBL_ENTRY)&_ZN5S48C64v140Ev,
  (VTBL_ENTRY)&_ZN5S48C64v141Ev,
  (VTBL_ENTRY)&_ZN5S48C64v142Ev,
  (VTBL_ENTRY)&_ZN5S48C64v143Ev,
  (VTBL_ENTRY)&_ZN5S48C64v144Ev,
  (VTBL_ENTRY)&_ZN5S48C64v145Ev,
  (VTBL_ENTRY)&_ZN5S48C64v146Ev,
  (VTBL_ENTRY)&_ZN5S48C64v147Ev,
  (VTBL_ENTRY)&_ZN5S48C64v148Ev,
  (VTBL_ENTRY)&_ZN5S48C64v149Ev,
  (VTBL_ENTRY)&_ZN5S48C64v150Ev,
  (VTBL_ENTRY)&_ZN5S48C64v151Ev,
  (VTBL_ENTRY)&_ZN5S48C64v152Ev,
  (VTBL_ENTRY)&_ZN5S48C64v153Ev,
  (VTBL_ENTRY)&_ZN5S48C64v154Ev,
  (VTBL_ENTRY)&_ZN5S48C64v155Ev,
  (VTBL_ENTRY)&_ZN5S48C64v156Ev,
  (VTBL_ENTRY)&_ZN5S48C64v157Ev,
  (VTBL_ENTRY)&_ZN5S48C64v158Ev,
  (VTBL_ENTRY)&_ZN5S48C64v159Ev,
  (VTBL_ENTRY)&_ZN5S48C64v160Ev,
  (VTBL_ENTRY)&_ZN5S48C64v161Ev,
  (VTBL_ENTRY)&_ZN5S48C64v162Ev,
  (VTBL_ENTRY)&_ZN5S48C64v163Ev,
  (VTBL_ENTRY)&_ZN5S48C64v164Ev,
  (VTBL_ENTRY)&_ZN5S48C64v165Ev,
  (VTBL_ENTRY)&_ZN5S48C64v166Ev,
  (VTBL_ENTRY)&_ZN5S48C64v167Ev,
  (VTBL_ENTRY)&_ZN5S48C64v168Ev,
  (VTBL_ENTRY)&_ZN5S48C64v169Ev,
  (VTBL_ENTRY)&_ZN5S48C64v170Ev,
  (VTBL_ENTRY)&_ZN5S48C64v171Ev,
  (VTBL_ENTRY)&_ZN5S48C64v172Ev,
  (VTBL_ENTRY)&_ZN5S48C64v173Ev,
  (VTBL_ENTRY)&_ZN5S48C64v174Ev,
  (VTBL_ENTRY)&_ZN5S48C64v175Ev,
  (VTBL_ENTRY)&_ZN5S48C64v176Ev,
  (VTBL_ENTRY)&_ZN5S48C64v177Ev,
  (VTBL_ENTRY)&_ZN5S48C64v178Ev,
  (VTBL_ENTRY)&_ZN5S48C64v179Ev,
  (VTBL_ENTRY)&_ZN5S48C64v180Ev,
  (VTBL_ENTRY)&_ZN5S48C64v181Ev,
  (VTBL_ENTRY)&_ZN5S48C64v182Ev,
  (VTBL_ENTRY)&_ZN5S48C64v183Ev,
  (VTBL_ENTRY)&_ZN5S48C64v184Ev,
  (VTBL_ENTRY)&_ZN5S48C64v185Ev,
  (VTBL_ENTRY)&_ZN5S48C64v186Ev,
  (VTBL_ENTRY)&_ZN5S48C64v187Ev,
  (VTBL_ENTRY)&_ZN5S48C64v188Ev,
  (VTBL_ENTRY)&_ZN5S48C64v189Ev,
  (VTBL_ENTRY)&_ZN5S48C64v190Ev,
  (VTBL_ENTRY)&_ZN5S48C64v191Ev,
  (VTBL_ENTRY)&_ZN5S48C64v192Ev,
  (VTBL_ENTRY)&_ZN5S48C64v193Ev,
  (VTBL_ENTRY)&_ZN5S48C64v194Ev,
  (VTBL_ENTRY)&_ZN5S48C64v195Ev,
  (VTBL_ENTRY)&_ZN5S48C64v196Ev,
  (VTBL_ENTRY)&_ZN5S48C64v197Ev,
  (VTBL_ENTRY)&_ZN5S48C64v198Ev,
  (VTBL_ENTRY)&_ZN5S48C64v199Ev,
  (VTBL_ENTRY)&_ZN5S48C64v200Ev,
  (VTBL_ENTRY)&_ZN5S48C64v201Ev,
  (VTBL_ENTRY)&_ZN5S48C64v202Ev,
  (VTBL_ENTRY)&_ZN5S48C64v203Ev,
  (VTBL_ENTRY)&_ZN5S48C64v204Ev,
  (VTBL_ENTRY)&_ZN5S48C64v205Ev,
  (VTBL_ENTRY)&_ZN5S48C64v206Ev,
  (VTBL_ENTRY)&_ZN5S48C64v207Ev,
  (VTBL_ENTRY)&_ZN5S48C64v208Ev,
  (VTBL_ENTRY)&_ZN5S48C64v209Ev,
  (VTBL_ENTRY)&_ZN5S48C64v210Ev,
  (VTBL_ENTRY)&_ZN5S48C64v211Ev,
  (VTBL_ENTRY)&_ZN5S48C64v212Ev,
  (VTBL_ENTRY)&_ZN5S48C64v213Ev,
  (VTBL_ENTRY)&_ZN5S48C64v214Ev,
  (VTBL_ENTRY)&_ZN5S48C64v215Ev,
  (VTBL_ENTRY)&_ZN5S48C64v216Ev,
  (VTBL_ENTRY)&_ZN5S48C64v217Ev,
  (VTBL_ENTRY)&_ZN5S48C54v218Ev,
  (VTBL_ENTRY)&_ZN5S48C54v219Ev,
  (VTBL_ENTRY)&_ZN5S48C54v220Ev,
  (VTBL_ENTRY)&_ZN5S48C54v221Ev,
  (VTBL_ENTRY)&_ZN5S48C54v222Ev,
  (VTBL_ENTRY)&_ZN5S48C54v223Ev,
  (VTBL_ENTRY)&_ZN5S48C54v224Ev,
  (VTBL_ENTRY)&_ZN5S48C54v225Ev,
  (VTBL_ENTRY)&_ZN5S48C54v226Ev,
  (VTBL_ENTRY)&_ZN5S48C54v227Ev,
  (VTBL_ENTRY)&_ZN5S48C54v228Ev,
  (VTBL_ENTRY)&_ZN5S48C54v229Ev,
  (VTBL_ENTRY)&_ZN5S48C54v230Ev,
  (VTBL_ENTRY)&_ZN5S48C54v231Ev,
  (VTBL_ENTRY)&_ZN5S48C54v232Ev,
  (VTBL_ENTRY)&_ZN5S48C54v233Ev,
  (VTBL_ENTRY)&_ZN5S48C54v234Ev,
  (VTBL_ENTRY)&_ZN5S48C54v235Ev,
  (VTBL_ENTRY)&_ZN5S48C54v236Ev,
  (VTBL_ENTRY)&_ZN5S48C54v237Ev,
  (VTBL_ENTRY)&_ZN5S48C54v238Ev,
  (VTBL_ENTRY)&_ZN5S48C54v239Ev,
  (VTBL_ENTRY)&_ZN5S48C54v240Ev,
  (VTBL_ENTRY)&_ZN5S48C54v241Ev,
  (VTBL_ENTRY)&_ZN5S48C54v242Ev,
  (VTBL_ENTRY)&_ZN5S48C54v243Ev,
  (VTBL_ENTRY)&_ZN5S48C54v244Ev,
  (VTBL_ENTRY)&_ZN5S48C54v245Ev,
  (VTBL_ENTRY)&_ZN5S48C54v246Ev,
  (VTBL_ENTRY)&_ZN5S48C54v247Ev,
  (VTBL_ENTRY)&_ZN5S48C54v248Ev,
  (VTBL_ENTRY)&_ZN5S48C54v249Ev,
  (VTBL_ENTRY)&_ZN5S48C54v250Ev,
  (VTBL_ENTRY)&_ZN5S48C54v251Ev,
  (VTBL_ENTRY)&_ZN5S48C54v252Ev,
  (VTBL_ENTRY)&_ZN5S48C54v253Ev,
  (VTBL_ENTRY)&_ZN5S48C54v254Ev,
  (VTBL_ENTRY)&_ZN5S48C54v255Ev,
  (VTBL_ENTRY)&_ZN5S48C54v256Ev,
  (VTBL_ENTRY)&_ZN5S48C54v257Ev,
  (VTBL_ENTRY)&_ZN5S48C54v258Ev,
  (VTBL_ENTRY)&_ZN5S48C54v259Ev,
  (VTBL_ENTRY)&_ZN5S48C54v260Ev,
  (VTBL_ENTRY)&_ZN5S48C54v261Ev,
  (VTBL_ENTRY)&_ZN5S48C54v262Ev,
  (VTBL_ENTRY)&_ZN5S48C54v263Ev,
  (VTBL_ENTRY)&_ZN5S48C54v264Ev,
  (VTBL_ENTRY)&_ZN5S48C54v265Ev,
  (VTBL_ENTRY)&_ZN5S48C54v266Ev,
  (VTBL_ENTRY)&_ZN5S48C54v267Ev,
  (VTBL_ENTRY)&_ZN5S48C44v268Ev,
  (VTBL_ENTRY)&_ZN5S48C44v269Ev,
  (VTBL_ENTRY)&_ZN5S48C44v270Ev,
  (VTBL_ENTRY)&_ZN5S48C44v271Ev,
  (VTBL_ENTRY)&_ZN5S48C44v272Ev,
  (VTBL_ENTRY)&_ZN5S48C44v273Ev,
  (VTBL_ENTRY)&_ZN5S48C44v274Ev,
  (VTBL_ENTRY)&_ZN5S48C44v275Ev,
  (VTBL_ENTRY)&_ZN5S48C44v276Ev,
  (VTBL_ENTRY)&_ZN5S48C44v277Ev,
  (VTBL_ENTRY)&_ZN5S48C44v278Ev,
  (VTBL_ENTRY)&_ZN5S48C44v279Ev,
  (VTBL_ENTRY)&_ZN5S48C44v280Ev,
  (VTBL_ENTRY)&_ZN5S48C44v281Ev,
  (VTBL_ENTRY)&_ZN5S48C44v282Ev,
  (VTBL_ENTRY)&_ZN5S48C44v283Ev,
  (VTBL_ENTRY)&_ZN5S48C44v284Ev,
  (VTBL_ENTRY)&_ZN5S48C44v285Ev,
  (VTBL_ENTRY)&_ZN5S48C44v286Ev,
  (VTBL_ENTRY)&_ZN5S48C44v287Ev,
  (VTBL_ENTRY)&_ZN5S48C44v288Ev,
  (VTBL_ENTRY)&_ZN5S48C44v289Ev,
  (VTBL_ENTRY)&_ZN5S48C44v290Ev,
  (VTBL_ENTRY)&_ZN5S48C44v291Ev,
  (VTBL_ENTRY)&_ZN5S48C44v292Ev,
  (VTBL_ENTRY)&_ZN5S48C44v293Ev,
  (VTBL_ENTRY)&_ZN5S48C44v294Ev,
  (VTBL_ENTRY)&_ZN5S48C44v295Ev,
  (VTBL_ENTRY)&_ZN5S48C44v296Ev,
  (VTBL_ENTRY)&_ZN5S48C44v297Ev,
  (VTBL_ENTRY)&_ZN5S48C44v298Ev,
  (VTBL_ENTRY)&_ZN5S48C44v299Ev,
  (VTBL_ENTRY)&_ZN5S48C44v300Ev,
  (VTBL_ENTRY)&_ZN5S48C44v301Ev,
  (VTBL_ENTRY)&_ZN5S48C44v302Ev,
  (VTBL_ENTRY)&_ZN5S48C44v303Ev,
  (VTBL_ENTRY)&_ZN5S48C44v304Ev,
  (VTBL_ENTRY)&_ZN5S48C44v305Ev,
  (VTBL_ENTRY)&_ZN5S48C34v306Ev,
  (VTBL_ENTRY)&_ZN5S48C34v307Ev,
  (VTBL_ENTRY)&_ZN5S48C34v308Ev,
};
extern VTBL_ENTRY _ZTI5S48C3[];
extern  VTBL_ENTRY _ZTV5S48C3[];
Class_Descriptor cd_S48C3 = {  "S48C3", // class name
  bases_S48C3, 4,
  &(vtc_S48C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1776,1308), // object size
  NSPAIRA(_ZTI5S48C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S48C3),302, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C55  : S28C12_nt {
};
//SIG(-1 S48C55) C1{ BC2{ m Fp Fi[2]}}



static void Test_S48C55()
{
  extern Class_Descriptor cd_S48C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C55, buf);
    S48C55 &lv = *(new (buf) S48C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C55)");
    check_base_class_offset(lv, (S28C12_nt*), 0, "S48C55");
    test_class_info(&lv, &cd_S48C55);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C55(Test_S48C55, "S48C55", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
static Base_Class bases_S48C55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C55 = {  "S48C55", // class name
  bases_S48C55, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C54  : S48C55 {
};
//SIG(-1 S48C54) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S48C54()
{
  extern Class_Descriptor cd_S48C54;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S48C54, buf);
    S48C54 &lv = *(new (buf) S48C54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S48C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C54)");
    check_base_class_offset(lv, (S28C12_nt*)(S48C55*), 0, "S48C54");
    check_base_class_offset(lv, (S48C55*), 0, "S48C54");
    test_class_info(&lv, &cd_S48C54);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C54(Test_S48C54, "S48C54", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S28C12_nt;
extern Class_Descriptor cd_S48C55;
static Base_Class bases_S48C54[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S28C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C55,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S48C54 = {  "S48C54", // class name
  bases_S48C54, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C2  : S48C3 {
  unsigned int s48c2f0:1;
  unsigned int s48c2f1:1;
  unsigned int s48c2f2:1;
  unsigned int s48c2f3:1;
  unsigned int s48c2f4:1;
  unsigned int s48c2f5:1;
  unsigned int s48c2f6:1;
  unsigned int s48c2f7:1;
  unsigned int s48c2f8:1;
  unsigned int s48c2f9:1;
  unsigned int s48c2f10:1;
  unsigned int s48c2f11:1;
  unsigned int s48c2f12:1;
  unsigned int s48c2f13:1;
  unsigned int s48c2f14:1;
  unsigned int s48c2f15:1;
  unsigned int s48c2f16:1;
  unsigned int s48c2f17:1;
  unsigned int s48c2f18:1;
  unsigned int s48c2f19:1;
  unsigned int s48c2f20:1;
  unsigned int s48c2f21:1;
  unsigned int s48c2f22:1;
  unsigned int s48c2f23:1;
  unsigned int s48c2f24:1;
  unsigned int s48c2f25:1;
  unsigned int s48c2f26:1;
  unsigned int s48c2f27:1;
  unsigned int s48c2f28:1;
  unsigned int s48c2f29:1;
  unsigned int s48c2f30:1;
  unsigned int s48c2f31:1;
  unsigned int s48c2f32:1;
  unsigned int s48c2f33:1;
  unsigned int s48c2f34:1;
  unsigned int s48c2f35:1;
  unsigned int s48c2f36:1;
  unsigned int s48c2f37:1;
  unsigned int s48c2f38:1;
  unsigned int s48c2f39:1;
  unsigned int s48c2f40:1;
  unsigned int s48c2f41:1;
  unsigned int s48c2f42:1;
  unsigned int s48c2f43:1;
  char s48c2f44;
  char s48c2f45[5];
  ::S28C18_nt s48c2f46;
  void *s48c2f47[2];
  int s48c2f48[2];
  ::S28C31_nt s48c2f49;
  void *s48c2f50[3];
  ::S28C51 s48c2f51;
  void *s48c2f52;
  ::S28C18_nt s48c2f53;
  ::S48C18 s48c2f54;
  ::S28C51 s48c2f55;
  int s48c2f56;
  void *s48c2f57[3];
  ::S28C18_nt s48c2f58;
  ::S48C18 s48c2f59;
  ::S28C18_nt s48c2f60;
  ::S48C18 s48c2f61;
  int s48c2f62;
  ::S28C18_nt s48c2f63;
  int s48c2f64[2];
  unsigned int s48c2f65:1;
  unsigned int s48c2f66:1;
  unsigned int s48c2f67:1;
  unsigned int s48c2f68:1;
  int s48c2f69[2];
  ::S48C18 s48c2f70;
  int s48c2f71;
  void *s48c2f72;
  int s48c2f73[5];
  ::S28C31_nt s48c2f74;
  int s48c2f75;
  void *s48c2f76[4];
  ::S28C31_nt s48c2f77;
  ::S48C47 s48c2f78;
  void *s48c2f79[2];
  ::S28C44 s48c2f80;
  int s48c2f81[5];
  void *s48c2f82;
  ::S48C54 s48c2f83;
  int s48c2f84;
  virtual  ~S48C2(); // _ZN5S48C2D1Ev
  virtual void  v309(); // _ZN5S48C24v309Ev
  virtual void  v310(); // _ZN5S48C24v310Ev
  virtual void  v311(); // _ZN5S48C24v311Ev
  virtual void  v312(); // _ZN5S48C24v312Ev
  virtual void  v313(); // _ZN5S48C24v313Ev
  virtual void  v314(); // _ZN5S48C24v314Ev
  virtual void  v315(); // _ZN5S48C24v315Ev
  virtual void  v316(); // _ZN5S48C24v316Ev
  virtual void  v317(); // _ZN5S48C24v317Ev
  virtual void  v318(); // _ZN5S48C24v318Ev
  virtual void  v319(); // _ZN5S48C24v319Ev
  virtual void  v320(); // _ZN5S48C24v320Ev
  virtual void  v321(); // _ZN5S48C24v321Ev
  virtual void  v322(); // _ZN5S48C24v322Ev
  virtual void  v323(); // _ZN5S48C24v323Ev
  virtual void  v324(); // _ZN5S48C24v324Ev
  virtual void  v325(); // _ZN5S48C24v325Ev
  virtual void  v326(); // _ZN5S48C24v326Ev
  virtual void  v327(); // _ZN5S48C24v327Ev
  S48C2(); // tgen
};
//SIG(-1 S48C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 FC11{ m Fi} Fi Fc[4] Fp[2] FC12{ BC13{ BC10}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC7 FC7 FC7 FC14{ BC15{ BC10}} FC14 Fi Fp[2] FC16{ m Fi[3]} FC17{ m Fi[3]} FC16 FC16 Fp FC7 FC14 FC16 FC17 Fi FC16 FC16 Fp Fi Fc FC17 FC17 Fp Fi Fp FC18{ BC19{ BC10}} FC20{ BC21{ BC10}} FC22{ BC23{ BC10}}} vd v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC16 FC16 Fp[5] FC16 Fp FC24{ BC25{ BC10}} Fp[2] FC16 Fp Fi[2] Fp Fi FC16 FC16 FC16 Fp[2] Fi FC16 Fi[4] Fp[2] FC26{ BC27{ BC10}} Fi FC17} vd v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC17 Fi FC17 Fp[5] FC16 Fi[12] FC28{ Fi Fc FC16 FC16 Fp FC16 Fc} FC29{ BC22}[2] Fi FC29 FC29 FC29 FC29 Fi FC16 Fp[4] FC16 Fp FC29 Fp FC30{ BC31{ BC10}} FC32{ BC33{ BC10}} FC32 FC32 Fp FC34{ BC35{ m Fp[2]}} Fp Fi FC36{ BC37{ BC10}} Fi FC29[4] FC36 Fp FC38{ BC39{ BC10}} Fi[3] FC38 FC38 FC14 FC40{ BC41{ BC10}} Fi FC42{ m Fp FC7}} vd v315 v316 v317} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc[6] FC16 Fp[2] Fi[2] FC29 Fp[3] FC43{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC44{ m} Fc Fi[2] FC16 Fi[3] Fi:1 Fi[4] FC16 FC16 FC16 Fi} Fp FC16 FC17 FC43 Fi Fp[3] FC16 FC17 FC16 FC17 Fi FC16 Fi[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] FC17 Fi Fp Fi[5] FC29 Fi Fp[4] FC29 FC40 Fp[2] FC14 Fi[5] Fp FC45{ BC46{ BC10}} Fi}


 S48C2 ::~S48C2(){ note_dtor("S48C2", this);}
void  S48C2 ::v309(){vfunc_called(this, "_ZN5S48C24v309Ev");}
void  S48C2 ::v310(){vfunc_called(this, "_ZN5S48C24v310Ev");}
void  S48C2 ::v311(){vfunc_called(this, "_ZN5S48C24v311Ev");}
void  S48C2 ::v312(){vfunc_called(this, "_ZN5S48C24v312Ev");}
void  S48C2 ::v313(){vfunc_called(this, "_ZN5S48C24v313Ev");}
void  S48C2 ::v314(){vfunc_called(this, "_ZN5S48C24v314Ev");}
void  S48C2 ::v315(){vfunc_called(this, "_ZN5S48C24v315Ev");}
void  S48C2 ::v316(){vfunc_called(this, "_ZN5S48C24v316Ev");}
void  S48C2 ::v317(){vfunc_called(this, "_ZN5S48C24v317Ev");}
void  S48C2 ::v318(){vfunc_called(this, "_ZN5S48C24v318Ev");}
void  S48C2 ::v319(){vfunc_called(this, "_ZN5S48C24v319Ev");}
void  S48C2 ::v320(){vfunc_called(this, "_ZN5S48C24v320Ev");}
void  S48C2 ::v321(){vfunc_called(this, "_ZN5S48C24v321Ev");}
void  S48C2 ::v322(){vfunc_called(this, "_ZN5S48C24v322Ev");}
void  S48C2 ::v323(){vfunc_called(this, "_ZN5S48C24v323Ev");}
void  S48C2 ::v324(){vfunc_called(this, "_ZN5S48C24v324Ev");}
void  S48C2 ::v325(){vfunc_called(this, "_ZN5S48C24v325Ev");}
void  S48C2 ::v326(){vfunc_called(this, "_ZN5S48C24v326Ev");}
void  S48C2 ::v327(){vfunc_called(this, "_ZN5S48C24v327Ev");}
S48C2 ::S48C2(){ note_ctor("S48C2", this);} // tgen

static void Test_S48C2()
{
  extern Class_Descriptor cd_S48C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(312,477)];
    init_test(&cd_S48C2, buf);
    S48C2 *dp, &lv = *(dp=new (buf) S48C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2488,1904), "sizeof(S48C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C2)");
    check_base_class_offset(lv, (S48C7*)(S48C6*)(S48C5*)(S48C4*)(S48C3*), 0, "S48C2");
    check_base_class_offset(lv, (S48C6*)(S48C5*)(S48C4*)(S48C3*), 0, "S48C2");
    check_base_class_offset(lv, (S48C5*)(S48C4*)(S48C3*), 0, "S48C2");
    check_base_class_offset(lv, (S48C4*)(S48C3*), 0, "S48C2");
    check_base_class_offset(lv, (S48C3*), 0, "S48C2");
    set_bf_and_test(lv, s48c2f0, ABISELECT(1776,1308), 0, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f1, ABISELECT(1776,1308), 1, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f2, ABISELECT(1776,1308), 2, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f3, ABISELECT(1776,1308), 3, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f4, ABISELECT(1776,1308), 4, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f5, ABISELECT(1776,1308), 5, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f6, ABISELECT(1776,1308), 6, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f7, ABISELECT(1776,1308), 7, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f8, ABISELECT(1777,1309), 0, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f9, ABISELECT(1777,1309), 1, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f10, ABISELECT(1777,1309), 2, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f11, ABISELECT(1777,1309), 3, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f12, ABISELECT(1777,1309), 4, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f13, ABISELECT(1777,1309), 5, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f14, ABISELECT(1777,1309), 6, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f15, ABISELECT(1777,1309), 7, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f16, ABISELECT(1778,1310), 0, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f17, ABISELECT(1778,1310), 1, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f18, ABISELECT(1778,1310), 2, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f19, ABISELECT(1778,1310), 3, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f20, ABISELECT(1778,1310), 4, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f21, ABISELECT(1778,1310), 5, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f22, ABISELECT(1778,1310), 6, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f23, ABISELECT(1778,1310), 7, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f24, ABISELECT(1779,1311), 0, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f25, ABISELECT(1779,1311), 1, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f26, ABISELECT(1779,1311), 2, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f27, ABISELECT(1779,1311), 3, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f28, ABISELECT(1779,1311), 4, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f29, ABISELECT(1779,1311), 5, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f30, ABISELECT(1779,1311), 6, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f31, ABISELECT(1779,1311), 7, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f32, ABISELECT(1780,1312), 0, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f33, ABISELECT(1780,1312), 1, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f34, ABISELECT(1780,1312), 2, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f35, ABISELECT(1780,1312), 3, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f36, ABISELECT(1780,1312), 4, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f37, ABISELECT(1780,1312), 5, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f38, ABISELECT(1780,1312), 6, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f39, ABISELECT(1780,1312), 7, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f40, ABISELECT(1781,1313), 0, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f41, ABISELECT(1781,1313), 1, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f42, ABISELECT(1781,1313), 2, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f43, ABISELECT(1781,1313), 3, 1, 1, "S48C2");
    check_field_offset(lv, s48c2f44, ABISELECT(1782,1314), "S48C2.s48c2f44");
    check_field_offset(lv, s48c2f45, ABISELECT(1783,1315), "S48C2.s48c2f45");
    check_field_offset(lv, s48c2f46, ABISELECT(1788,1320), "S48C2.s48c2f46");
    check_field_offset(lv, s48c2f47, ABISELECT(1800,1332), "S48C2.s48c2f47");
    check_field_offset(lv, s48c2f48, ABISELECT(1816,1340), "S48C2.s48c2f48");
    check_field_offset(lv, s48c2f49, ABISELECT(1824,1348), "S48C2.s48c2f49");
    check_field_offset(lv, s48c2f50, ABISELECT(1840,1360), "S48C2.s48c2f50");
    check_field_offset(lv, s48c2f51, ABISELECT(1864,1372), "S48C2.s48c2f51");
    check_field_offset(lv, s48c2f52, ABISELECT(1992,1496), "S48C2.s48c2f52");
    check_field_offset(lv, s48c2f53, ABISELECT(2000,1500), "S48C2.s48c2f53");
    check_field_offset(lv, s48c2f54, ABISELECT(2012,1512), "S48C2.s48c2f54");
    check_field_offset(lv, s48c2f55, ABISELECT(2024,1524), "S48C2.s48c2f55");
    check_field_offset(lv, s48c2f56, ABISELECT(2148,1648), "S48C2.s48c2f56");
    check_field_offset(lv, s48c2f57, ABISELECT(2152,1652), "S48C2.s48c2f57");
    check_field_offset(lv, s48c2f58, ABISELECT(2176,1664), "S48C2.s48c2f58");
    check_field_offset(lv, s48c2f59, ABISELECT(2188,1676), "S48C2.s48c2f59");
    check_field_offset(lv, s48c2f60, ABISELECT(2200,1688), "S48C2.s48c2f60");
    check_field_offset(lv, s48c2f61, ABISELECT(2212,1700), "S48C2.s48c2f61");
    check_field_offset(lv, s48c2f62, ABISELECT(2224,1712), "S48C2.s48c2f62");
    check_field_offset(lv, s48c2f63, ABISELECT(2228,1716), "S48C2.s48c2f63");
    check_field_offset(lv, s48c2f64, ABISELECT(2240,1728), "S48C2.s48c2f64");
    set_bf_and_test(lv, s48c2f65, ABISELECT(2248,1736), 0, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f66, ABISELECT(2248,1736), 1, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f67, ABISELECT(2248,1736), 2, 1, 1, "S48C2");
    set_bf_and_test(lv, s48c2f68, ABISELECT(2248,1736), 3, 1, 1, "S48C2");
    check_field_offset(lv, s48c2f69, ABISELECT(2252,1740), "S48C2.s48c2f69");
    check_field_offset(lv, s48c2f70, ABISELECT(2260,1748), "S48C2.s48c2f70");
    check_field_offset(lv, s48c2f71, ABISELECT(2272,1760), "S48C2.s48c2f71");
    check_field_offset(lv, s48c2f72, ABISELECT(2280,1764), "S48C2.s48c2f72");
    check_field_offset(lv, s48c2f73, ABISELECT(2288,1768), "S48C2.s48c2f73");
    check_field_offset(lv, s48c2f74, ABISELECT(2312,1788), "S48C2.s48c2f74");
    check_field_offset(lv, s48c2f75, ABISELECT(2328,1800), "S48C2.s48c2f75");
    check_field_offset(lv, s48c2f76, ABISELECT(2336,1804), "S48C2.s48c2f76");
    check_field_offset(lv, s48c2f77, ABISELECT(2368,1820), "S48C2.s48c2f77");
    check_field_offset(lv, s48c2f78, ABISELECT(2384,1832), "S48C2.s48c2f78");
    check_field_offset(lv, s48c2f79, ABISELECT(2400,1844), "S48C2.s48c2f79");
    check_field_offset(lv, s48c2f80, ABISELECT(2416,1852), "S48C2.s48c2f80");
    check_field_offset(lv, s48c2f81, ABISELECT(2432,1864), "S48C2.s48c2f81");
    check_field_offset(lv, s48c2f82, ABISELECT(2456,1884), "S48C2.s48c2f82");
    check_field_offset(lv, s48c2f83, ABISELECT(2464,1888), "S48C2.s48c2f83");
    check_field_offset(lv, s48c2f84, ABISELECT(2480,1900), "S48C2.s48c2f84");
    test_class_info(&lv, &cd_S48C2);
    dp->~S48C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C2(Test_S48C2, "S48C2", ABISELECT(2488,1904));

#else // __cplusplus

extern void _ZN5S48C2C1Ev();
extern void _ZN5S48C2D1Ev();
Name_Map name_map_S48C2[] = {
  NSPAIR(_ZN5S48C2C1Ev),
  NSPAIR(_ZN5S48C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S48C7;
extern VTBL_ENTRY _ZTI5S48C7[];
extern  VTBL_ENTRY _ZTV5S48C7[];
extern Class_Descriptor cd_S48C6;
extern VTBL_ENTRY _ZTI5S48C6[];
extern  VTBL_ENTRY _ZTV5S48C6[];
extern Class_Descriptor cd_S48C5;
extern VTBL_ENTRY _ZTI5S48C5[];
extern  VTBL_ENTRY _ZTV5S48C5[];
extern Class_Descriptor cd_S48C4;
extern VTBL_ENTRY _ZTI5S48C4[];
extern  VTBL_ENTRY _ZTV5S48C4[];
extern Class_Descriptor cd_S48C3;
extern VTBL_ENTRY _ZTI5S48C3[];
extern  VTBL_ENTRY _ZTV5S48C3[];
static Base_Class bases_S48C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S48C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S48C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S48C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S48C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S48C2[];
extern void _ZN5S48C2D1Ev();
extern void _ZN5S48C2D0Ev();
extern void _ZN5S48C73v11Ev();
extern void _ZN5S48C73v12Ev();
extern void _ZN5S48C73v13Ev();
extern void _ZN5S48C73v14Ev();
extern void _ZN5S48C73v15Ev();
extern void _ZN5S48C73v16Ev();
extern void _ZN5S48C73v17Ev();
extern void _ZN5S48C73v18Ev();
extern void _ZN5S48C73v19Ev();
extern void _ZN5S48C73v20Ev();
extern void _ZN5S48C73v21Ev();
extern void _ZN5S48C73v22Ev();
extern void _ZN5S48C73v23Ev();
extern void _ZN5S48C73v24Ev();
extern void _ZN5S48C73v25Ev();
extern void _ZN5S48C73v26Ev();
extern void _ZN5S48C73v27Ev();
extern void _ZN5S48C73v28Ev();
extern void _ZN5S48C73v29Ev();
extern void _ZN5S48C73v30Ev();
extern void _ZN5S48C73v31Ev();
extern void _ZN5S48C73v32Ev();
extern void _ZN5S48C73v33Ev();
extern void _ZN5S48C73v34Ev();
extern void _ZN5S48C73v35Ev();
extern void _ZN5S48C73v36Ev();
extern void _ZN5S48C73v37Ev();
extern void _ZN5S48C73v38Ev();
extern void _ZN5S48C73v39Ev();
extern void _ZN5S48C73v40Ev();
extern void _ZN5S48C73v41Ev();
extern void _ZN5S48C73v42Ev();
extern void _ZN5S48C73v43Ev();
extern void _ZN5S48C73v44Ev();
extern void _ZN5S48C73v45Ev();
extern void _ZN5S48C73v46Ev();
extern void _ZN5S48C73v47Ev();
extern void _ZN5S48C73v48Ev();
extern void _ZN5S48C73v49Ev();
extern void _ZN5S48C73v50Ev();
extern void _ZN5S48C73v51Ev();
extern void _ZN5S48C73v52Ev();
extern void _ZN5S48C73v53Ev();
extern void _ZN5S48C73v54Ev();
extern void _ZN5S48C73v55Ev();
extern void _ZN5S48C73v56Ev();
extern void _ZN5S48C73v57Ev();
extern void _ZN5S48C73v58Ev();
extern void _ZN5S48C73v59Ev();
extern void _ZN5S48C73v60Ev();
extern void _ZN5S48C73v61Ev();
extern void _ZN5S48C73v62Ev();
extern void _ZN5S48C73v63Ev();
extern void _ZN5S48C73v64Ev();
extern void _ZN5S48C73v65Ev();
extern void _ZN5S48C73v66Ev();
extern void _ZN5S48C73v67Ev();
extern void _ZN5S48C73v68Ev();
extern void _ZN5S48C73v69Ev();
extern void _ZN5S48C73v70Ev();
extern void _ZN5S48C73v71Ev();
extern void _ZN5S48C73v72Ev();
extern void _ZN5S48C73v73Ev();
extern void _ZN5S48C73v74Ev();
extern void _ZN5S48C63v75Ev();
extern void _ZN5S48C63v76Ev();
extern void _ZN5S48C63v77Ev();
extern void _ZN5S48C63v78Ev();
extern void _ZN5S48C63v79Ev();
extern void _ZN5S48C63v80Ev();
extern void _ZN5S48C63v81Ev();
extern void _ZN5S48C63v82Ev();
extern void _ZN5S48C63v83Ev();
extern void _ZN5S48C63v84Ev();
extern void _ZN5S48C63v85Ev();
extern void _ZN5S48C63v86Ev();
extern void _ZN5S48C63v87Ev();
extern void _ZN5S48C63v88Ev();
extern void _ZN5S48C63v89Ev();
extern void _ZN5S48C63v90Ev();
extern void _ZN5S48C63v91Ev();
extern void _ZN5S48C63v92Ev();
extern void _ZN5S48C63v93Ev();
extern void _ZN5S48C63v94Ev();
extern void _ZN5S48C63v95Ev();
extern void _ZN5S48C63v96Ev();
extern void _ZN5S48C63v97Ev();
extern void _ZN5S48C63v98Ev();
extern void _ZN5S48C63v99Ev();
extern void _ZN5S48C64v100Ev();
extern void _ZN5S48C64v101Ev();
extern void _ZN5S48C64v102Ev();
extern void _ZN5S48C64v103Ev();
extern void _ZN5S48C64v104Ev();
extern void _ZN5S48C64v105Ev();
extern void _ZN5S48C64v106Ev();
extern void _ZN5S48C64v107Ev();
extern void _ZN5S48C64v108Ev();
extern void _ZN5S48C64v109Ev();
extern void _ZN5S48C64v110Ev();
extern void _ZN5S48C64v111Ev();
extern void _ZN5S48C64v112Ev();
extern void _ZN5S48C64v113Ev();
extern void _ZN5S48C64v114Ev();
extern void _ZN5S48C64v115Ev();
extern void _ZN5S48C64v116Ev();
extern void _ZN5S48C64v117Ev();
extern void _ZN5S48C64v118Ev();
extern void _ZN5S48C64v119Ev();
extern void _ZN5S48C64v120Ev();
extern void _ZN5S48C64v121Ev();
extern void _ZN5S48C64v122Ev();
extern void _ZN5S48C64v123Ev();
extern void _ZN5S48C64v124Ev();
extern void _ZN5S48C64v125Ev();
extern void _ZN5S48C64v126Ev();
extern void _ZN5S48C64v127Ev();
extern void _ZN5S48C64v128Ev();
extern void _ZN5S48C64v129Ev();
extern void _ZN5S48C64v130Ev();
extern void _ZN5S48C64v131Ev();
extern void _ZN5S48C64v132Ev();
extern void _ZN5S48C64v133Ev();
extern void _ZN5S48C64v134Ev();
extern void _ZN5S48C64v135Ev();
extern void _ZN5S48C64v136Ev();
extern void _ZN5S48C64v137Ev();
extern void _ZN5S48C64v138Ev();
extern void _ZN5S48C64v139Ev();
extern void _ZN5S48C64v140Ev();
extern void _ZN5S48C64v141Ev();
extern void _ZN5S48C64v142Ev();
extern void _ZN5S48C64v143Ev();
extern void _ZN5S48C64v144Ev();
extern void _ZN5S48C64v145Ev();
extern void _ZN5S48C64v146Ev();
extern void _ZN5S48C64v147Ev();
extern void _ZN5S48C64v148Ev();
extern void _ZN5S48C64v149Ev();
extern void _ZN5S48C64v150Ev();
extern void _ZN5S48C64v151Ev();
extern void _ZN5S48C64v152Ev();
extern void _ZN5S48C64v153Ev();
extern void _ZN5S48C64v154Ev();
extern void _ZN5S48C64v155Ev();
extern void _ZN5S48C64v156Ev();
extern void _ZN5S48C64v157Ev();
extern void _ZN5S48C64v158Ev();
extern void _ZN5S48C64v159Ev();
extern void _ZN5S48C64v160Ev();
extern void _ZN5S48C64v161Ev();
extern void _ZN5S48C64v162Ev();
extern void _ZN5S48C64v163Ev();
extern void _ZN5S48C64v164Ev();
extern void _ZN5S48C64v165Ev();
extern void _ZN5S48C64v166Ev();
extern void _ZN5S48C64v167Ev();
extern void _ZN5S48C64v168Ev();
extern void _ZN5S48C64v169Ev();
extern void _ZN5S48C64v170Ev();
extern void _ZN5S48C64v171Ev();
extern void _ZN5S48C64v172Ev();
extern void _ZN5S48C64v173Ev();
extern void _ZN5S48C64v174Ev();
extern void _ZN5S48C64v175Ev();
extern void _ZN5S48C64v176Ev();
extern void _ZN5S48C64v177Ev();
extern void _ZN5S48C64v178Ev();
extern void _ZN5S48C64v179Ev();
extern void _ZN5S48C64v180Ev();
extern void _ZN5S48C64v181Ev();
extern void _ZN5S48C64v182Ev();
extern void _ZN5S48C64v183Ev();
extern void _ZN5S48C64v184Ev();
extern void _ZN5S48C64v185Ev();
extern void _ZN5S48C64v186Ev();
extern void _ZN5S48C64v187Ev();
extern void _ZN5S48C64v188Ev();
extern void _ZN5S48C64v189Ev();
extern void _ZN5S48C64v190Ev();
extern void _ZN5S48C64v191Ev();
extern void _ZN5S48C64v192Ev();
extern void _ZN5S48C64v193Ev();
extern void _ZN5S48C64v194Ev();
extern void _ZN5S48C64v195Ev();
extern void _ZN5S48C64v196Ev();
extern void _ZN5S48C64v197Ev();
extern void _ZN5S48C64v198Ev();
extern void _ZN5S48C64v199Ev();
extern void _ZN5S48C64v200Ev();
extern void _ZN5S48C64v201Ev();
extern void _ZN5S48C64v202Ev();
extern void _ZN5S48C64v203Ev();
extern void _ZN5S48C64v204Ev();
extern void _ZN5S48C64v205Ev();
extern void _ZN5S48C64v206Ev();
extern void _ZN5S48C64v207Ev();
extern void _ZN5S48C64v208Ev();
extern void _ZN5S48C64v209Ev();
extern void _ZN5S48C64v210Ev();
extern void _ZN5S48C64v211Ev();
extern void _ZN5S48C64v212Ev();
extern void _ZN5S48C64v213Ev();
extern void _ZN5S48C64v214Ev();
extern void _ZN5S48C64v215Ev();
extern void _ZN5S48C64v216Ev();
extern void _ZN5S48C64v217Ev();
extern void _ZN5S48C54v218Ev();
extern void _ZN5S48C54v219Ev();
extern void _ZN5S48C54v220Ev();
extern void _ZN5S48C54v221Ev();
extern void _ZN5S48C54v222Ev();
extern void _ZN5S48C54v223Ev();
extern void _ZN5S48C54v224Ev();
extern void _ZN5S48C54v225Ev();
extern void _ZN5S48C54v226Ev();
extern void _ZN5S48C54v227Ev();
extern void _ZN5S48C54v228Ev();
extern void _ZN5S48C54v229Ev();
extern void _ZN5S48C54v230Ev();
extern void _ZN5S48C54v231Ev();
extern void _ZN5S48C54v232Ev();
extern void _ZN5S48C54v233Ev();
extern void _ZN5S48C54v234Ev();
extern void _ZN5S48C54v235Ev();
extern void _ZN5S48C54v236Ev();
extern void _ZN5S48C54v237Ev();
extern void _ZN5S48C54v238Ev();
extern void _ZN5S48C54v239Ev();
extern void _ZN5S48C54v240Ev();
extern void _ZN5S48C54v241Ev();
extern void _ZN5S48C54v242Ev();
extern void _ZN5S48C54v243Ev();
extern void _ZN5S48C54v244Ev();
extern void _ZN5S48C54v245Ev();
extern void _ZN5S48C54v246Ev();
extern void _ZN5S48C54v247Ev();
extern void _ZN5S48C54v248Ev();
extern void _ZN5S48C54v249Ev();
extern void _ZN5S48C54v250Ev();
extern void _ZN5S48C54v251Ev();
extern void _ZN5S48C54v252Ev();
extern void _ZN5S48C54v253Ev();
extern void _ZN5S48C54v254Ev();
extern void _ZN5S48C54v255Ev();
extern void _ZN5S48C54v256Ev();
extern void _ZN5S48C54v257Ev();
extern void _ZN5S48C54v258Ev();
extern void _ZN5S48C54v259Ev();
extern void _ZN5S48C54v260Ev();
extern void _ZN5S48C54v261Ev();
extern void _ZN5S48C54v262Ev();
extern void _ZN5S48C54v263Ev();
extern void _ZN5S48C54v264Ev();
extern void _ZN5S48C54v265Ev();
extern void _ZN5S48C54v266Ev();
extern void _ZN5S48C54v267Ev();
extern void _ZN5S48C44v268Ev();
extern void _ZN5S48C44v269Ev();
extern void _ZN5S48C44v270Ev();
extern void _ZN5S48C44v271Ev();
extern void _ZN5S48C44v272Ev();
extern void _ZN5S48C44v273Ev();
extern void _ZN5S48C44v274Ev();
extern void _ZN5S48C44v275Ev();
extern void _ZN5S48C44v276Ev();
extern void _ZN5S48C44v277Ev();
extern void _ZN5S48C44v278Ev();
extern void _ZN5S48C44v279Ev();
extern void _ZN5S48C44v280Ev();
extern void _ZN5S48C44v281Ev();
extern void _ZN5S48C44v282Ev();
extern void _ZN5S48C44v283Ev();
extern void _ZN5S48C44v284Ev();
extern void _ZN5S48C44v285Ev();
extern void _ZN5S48C44v286Ev();
extern void _ZN5S48C44v287Ev();
extern void _ZN5S48C44v288Ev();
extern void _ZN5S48C44v289Ev();
extern void _ZN5S48C44v290Ev();
extern void _ZN5S48C44v291Ev();
extern void _ZN5S48C44v292Ev();
extern void _ZN5S48C44v293Ev();
extern void _ZN5S48C44v294Ev();
extern void _ZN5S48C44v295Ev();
extern void _ZN5S48C44v296Ev();
extern void _ZN5S48C44v297Ev();
extern void _ZN5S48C44v298Ev();
extern void _ZN5S48C44v299Ev();
extern void _ZN5S48C44v300Ev();
extern void _ZN5S48C44v301Ev();
extern void _ZN5S48C44v302Ev();
extern void _ZN5S48C44v303Ev();
extern void _ZN5S48C44v304Ev();
extern void _ZN5S48C44v305Ev();
extern void _ZN5S48C34v306Ev();
extern void _ZN5S48C34v307Ev();
extern void _ZN5S48C34v308Ev();
extern void _ZN5S48C24v309Ev();
extern void _ZN5S48C24v310Ev();
extern void _ZN5S48C24v311Ev();
extern void _ZN5S48C24v312Ev();
extern void _ZN5S48C24v313Ev();
extern void _ZN5S48C24v314Ev();
extern void _ZN5S48C24v315Ev();
extern void _ZN5S48C24v316Ev();
extern void _ZN5S48C24v317Ev();
extern void _ZN5S48C24v318Ev();
extern void _ZN5S48C24v319Ev();
extern void _ZN5S48C24v320Ev();
extern void _ZN5S48C24v321Ev();
extern void _ZN5S48C24v322Ev();
extern void _ZN5S48C24v323Ev();
extern void _ZN5S48C24v324Ev();
extern void _ZN5S48C24v325Ev();
extern void _ZN5S48C24v326Ev();
extern void _ZN5S48C24v327Ev();
static  VTBL_ENTRY vtc_S48C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S48C2[0]),
  (VTBL_ENTRY)&_ZN5S48C2D1Ev,
  (VTBL_ENTRY)&_ZN5S48C2D0Ev,
  (VTBL_ENTRY)&_ZN5S48C73v11Ev,
  (VTBL_ENTRY)&_ZN5S48C73v12Ev,
  (VTBL_ENTRY)&_ZN5S48C73v13Ev,
  (VTBL_ENTRY)&_ZN5S48C73v14Ev,
  (VTBL_ENTRY)&_ZN5S48C73v15Ev,
  (VTBL_ENTRY)&_ZN5S48C73v16Ev,
  (VTBL_ENTRY)&_ZN5S48C73v17Ev,
  (VTBL_ENTRY)&_ZN5S48C73v18Ev,
  (VTBL_ENTRY)&_ZN5S48C73v19Ev,
  (VTBL_ENTRY)&_ZN5S48C73v20Ev,
  (VTBL_ENTRY)&_ZN5S48C73v21Ev,
  (VTBL_ENTRY)&_ZN5S48C73v22Ev,
  (VTBL_ENTRY)&_ZN5S48C73v23Ev,
  (VTBL_ENTRY)&_ZN5S48C73v24Ev,
  (VTBL_ENTRY)&_ZN5S48C73v25Ev,
  (VTBL_ENTRY)&_ZN5S48C73v26Ev,
  (VTBL_ENTRY)&_ZN5S48C73v27Ev,
  (VTBL_ENTRY)&_ZN5S48C73v28Ev,
  (VTBL_ENTRY)&_ZN5S48C73v29Ev,
  (VTBL_ENTRY)&_ZN5S48C73v30Ev,
  (VTBL_ENTRY)&_ZN5S48C73v31Ev,
  (VTBL_ENTRY)&_ZN5S48C73v32Ev,
  (VTBL_ENTRY)&_ZN5S48C73v33Ev,
  (VTBL_ENTRY)&_ZN5S48C73v34Ev,
  (VTBL_ENTRY)&_ZN5S48C73v35Ev,
  (VTBL_ENTRY)&_ZN5S48C73v36Ev,
  (VTBL_ENTRY)&_ZN5S48C73v37Ev,
  (VTBL_ENTRY)&_ZN5S48C73v38Ev,
  (VTBL_ENTRY)&_ZN5S48C73v39Ev,
  (VTBL_ENTRY)&_ZN5S48C73v40Ev,
  (VTBL_ENTRY)&_ZN5S48C73v41Ev,
  (VTBL_ENTRY)&_ZN5S48C73v42Ev,
  (VTBL_ENTRY)&_ZN5S48C73v43Ev,
  (VTBL_ENTRY)&_ZN5S48C73v44Ev,
  (VTBL_ENTRY)&_ZN5S48C73v45Ev,
  (VTBL_ENTRY)&_ZN5S48C73v46Ev,
  (VTBL_ENTRY)&_ZN5S48C73v47Ev,
  (VTBL_ENTRY)&_ZN5S48C73v48Ev,
  (VTBL_ENTRY)&_ZN5S48C73v49Ev,
  (VTBL_ENTRY)&_ZN5S48C73v50Ev,
  (VTBL_ENTRY)&_ZN5S48C73v51Ev,
  (VTBL_ENTRY)&_ZN5S48C73v52Ev,
  (VTBL_ENTRY)&_ZN5S48C73v53Ev,
  (VTBL_ENTRY)&_ZN5S48C73v54Ev,
  (VTBL_ENTRY)&_ZN5S48C73v55Ev,
  (VTBL_ENTRY)&_ZN5S48C73v56Ev,
  (VTBL_ENTRY)&_ZN5S48C73v57Ev,
  (VTBL_ENTRY)&_ZN5S48C73v58Ev,
  (VTBL_ENTRY)&_ZN5S48C73v59Ev,
  (VTBL_ENTRY)&_ZN5S48C73v60Ev,
  (VTBL_ENTRY)&_ZN5S48C73v61Ev,
  (VTBL_ENTRY)&_ZN5S48C73v62Ev,
  (VTBL_ENTRY)&_ZN5S48C73v63Ev,
  (VTBL_ENTRY)&_ZN5S48C73v64Ev,
  (VTBL_ENTRY)&_ZN5S48C73v65Ev,
  (VTBL_ENTRY)&_ZN5S48C73v66Ev,
  (VTBL_ENTRY)&_ZN5S48C73v67Ev,
  (VTBL_ENTRY)&_ZN5S48C73v68Ev,
  (VTBL_ENTRY)&_ZN5S48C73v69Ev,
  (VTBL_ENTRY)&_ZN5S48C73v70Ev,
  (VTBL_ENTRY)&_ZN5S48C73v71Ev,
  (VTBL_ENTRY)&_ZN5S48C73v72Ev,
  (VTBL_ENTRY)&_ZN5S48C73v73Ev,
  (VTBL_ENTRY)&_ZN5S48C73v74Ev,
  (VTBL_ENTRY)&_ZN5S48C63v75Ev,
  (VTBL_ENTRY)&_ZN5S48C63v76Ev,
  (VTBL_ENTRY)&_ZN5S48C63v77Ev,
  (VTBL_ENTRY)&_ZN5S48C63v78Ev,
  (VTBL_ENTRY)&_ZN5S48C63v79Ev,
  (VTBL_ENTRY)&_ZN5S48C63v80Ev,
  (VTBL_ENTRY)&_ZN5S48C63v81Ev,
  (VTBL_ENTRY)&_ZN5S48C63v82Ev,
  (VTBL_ENTRY)&_ZN5S48C63v83Ev,
  (VTBL_ENTRY)&_ZN5S48C63v84Ev,
  (VTBL_ENTRY)&_ZN5S48C63v85Ev,
  (VTBL_ENTRY)&_ZN5S48C63v86Ev,
  (VTBL_ENTRY)&_ZN5S48C63v87Ev,
  (VTBL_ENTRY)&_ZN5S48C63v88Ev,
  (VTBL_ENTRY)&_ZN5S48C63v89Ev,
  (VTBL_ENTRY)&_ZN5S48C63v90Ev,
  (VTBL_ENTRY)&_ZN5S48C63v91Ev,
  (VTBL_ENTRY)&_ZN5S48C63v92Ev,
  (VTBL_ENTRY)&_ZN5S48C63v93Ev,
  (VTBL_ENTRY)&_ZN5S48C63v94Ev,
  (VTBL_ENTRY)&_ZN5S48C63v95Ev,
  (VTBL_ENTRY)&_ZN5S48C63v96Ev,
  (VTBL_ENTRY)&_ZN5S48C63v97Ev,
  (VTBL_ENTRY)&_ZN5S48C63v98Ev,
  (VTBL_ENTRY)&_ZN5S48C63v99Ev,
  (VTBL_ENTRY)&_ZN5S48C64v100Ev,
  (VTBL_ENTRY)&_ZN5S48C64v101Ev,
  (VTBL_ENTRY)&_ZN5S48C64v102Ev,
  (VTBL_ENTRY)&_ZN5S48C64v103Ev,
  (VTBL_ENTRY)&_ZN5S48C64v104Ev,
  (VTBL_ENTRY)&_ZN5S48C64v105Ev,
  (VTBL_ENTRY)&_ZN5S48C64v106Ev,
  (VTBL_ENTRY)&_ZN5S48C64v107Ev,
  (VTBL_ENTRY)&_ZN5S48C64v108Ev,
  (VTBL_ENTRY)&_ZN5S48C64v109Ev,
  (VTBL_ENTRY)&_ZN5S48C64v110Ev,
  (VTBL_ENTRY)&_ZN5S48C64v111Ev,
  (VTBL_ENTRY)&_ZN5S48C64v112Ev,
  (VTBL_ENTRY)&_ZN5S48C64v113Ev,
  (VTBL_ENTRY)&_ZN5S48C64v114Ev,
  (VTBL_ENTRY)&_ZN5S48C64v115Ev,
  (VTBL_ENTRY)&_ZN5S48C64v116Ev,
  (VTBL_ENTRY)&_ZN5S48C64v117Ev,
  (VTBL_ENTRY)&_ZN5S48C64v118Ev,
  (VTBL_ENTRY)&_ZN5S48C64v119Ev,
  (VTBL_ENTRY)&_ZN5S48C64v120Ev,
  (VTBL_ENTRY)&_ZN5S48C64v121Ev,
  (VTBL_ENTRY)&_ZN5S48C64v122Ev,
  (VTBL_ENTRY)&_ZN5S48C64v123Ev,
  (VTBL_ENTRY)&_ZN5S48C64v124Ev,
  (VTBL_ENTRY)&_ZN5S48C64v125Ev,
  (VTBL_ENTRY)&_ZN5S48C64v126Ev,
  (VTBL_ENTRY)&_ZN5S48C64v127Ev,
  (VTBL_ENTRY)&_ZN5S48C64v128Ev,
  (VTBL_ENTRY)&_ZN5S48C64v129Ev,
  (VTBL_ENTRY)&_ZN5S48C64v130Ev,
  (VTBL_ENTRY)&_ZN5S48C64v131Ev,
  (VTBL_ENTRY)&_ZN5S48C64v132Ev,
  (VTBL_ENTRY)&_ZN5S48C64v133Ev,
  (VTBL_ENTRY)&_ZN5S48C64v134Ev,
  (VTBL_ENTRY)&_ZN5S48C64v135Ev,
  (VTBL_ENTRY)&_ZN5S48C64v136Ev,
  (VTBL_ENTRY)&_ZN5S48C64v137Ev,
  (VTBL_ENTRY)&_ZN5S48C64v138Ev,
  (VTBL_ENTRY)&_ZN5S48C64v139Ev,
  (VTBL_ENTRY)&_ZN5S48C64v140Ev,
  (VTBL_ENTRY)&_ZN5S48C64v141Ev,
  (VTBL_ENTRY)&_ZN5S48C64v142Ev,
  (VTBL_ENTRY)&_ZN5S48C64v143Ev,
  (VTBL_ENTRY)&_ZN5S48C64v144Ev,
  (VTBL_ENTRY)&_ZN5S48C64v145Ev,
  (VTBL_ENTRY)&_ZN5S48C64v146Ev,
  (VTBL_ENTRY)&_ZN5S48C64v147Ev,
  (VTBL_ENTRY)&_ZN5S48C64v148Ev,
  (VTBL_ENTRY)&_ZN5S48C64v149Ev,
  (VTBL_ENTRY)&_ZN5S48C64v150Ev,
  (VTBL_ENTRY)&_ZN5S48C64v151Ev,
  (VTBL_ENTRY)&_ZN5S48C64v152Ev,
  (VTBL_ENTRY)&_ZN5S48C64v153Ev,
  (VTBL_ENTRY)&_ZN5S48C64v154Ev,
  (VTBL_ENTRY)&_ZN5S48C64v155Ev,
  (VTBL_ENTRY)&_ZN5S48C64v156Ev,
  (VTBL_ENTRY)&_ZN5S48C64v157Ev,
  (VTBL_ENTRY)&_ZN5S48C64v158Ev,
  (VTBL_ENTRY)&_ZN5S48C64v159Ev,
  (VTBL_ENTRY)&_ZN5S48C64v160Ev,
  (VTBL_ENTRY)&_ZN5S48C64v161Ev,
  (VTBL_ENTRY)&_ZN5S48C64v162Ev,
  (VTBL_ENTRY)&_ZN5S48C64v163Ev,
  (VTBL_ENTRY)&_ZN5S48C64v164Ev,
  (VTBL_ENTRY)&_ZN5S48C64v165Ev,
  (VTBL_ENTRY)&_ZN5S48C64v166Ev,
  (VTBL_ENTRY)&_ZN5S48C64v167Ev,
  (VTBL_ENTRY)&_ZN5S48C64v168Ev,
  (VTBL_ENTRY)&_ZN5S48C64v169Ev,
  (VTBL_ENTRY)&_ZN5S48C64v170Ev,
  (VTBL_ENTRY)&_ZN5S48C64v171Ev,
  (VTBL_ENTRY)&_ZN5S48C64v172Ev,
  (VTBL_ENTRY)&_ZN5S48C64v173Ev,
  (VTBL_ENTRY)&_ZN5S48C64v174Ev,
  (VTBL_ENTRY)&_ZN5S48C64v175Ev,
  (VTBL_ENTRY)&_ZN5S48C64v176Ev,
  (VTBL_ENTRY)&_ZN5S48C64v177Ev,
  (VTBL_ENTRY)&_ZN5S48C64v178Ev,
  (VTBL_ENTRY)&_ZN5S48C64v179Ev,
  (VTBL_ENTRY)&_ZN5S48C64v180Ev,
  (VTBL_ENTRY)&_ZN5S48C64v181Ev,
  (VTBL_ENTRY)&_ZN5S48C64v182Ev,
  (VTBL_ENTRY)&_ZN5S48C64v183Ev,
  (VTBL_ENTRY)&_ZN5S48C64v184Ev,
  (VTBL_ENTRY)&_ZN5S48C64v185Ev,
  (VTBL_ENTRY)&_ZN5S48C64v186Ev,
  (VTBL_ENTRY)&_ZN5S48C64v187Ev,
  (VTBL_ENTRY)&_ZN5S48C64v188Ev,
  (VTBL_ENTRY)&_ZN5S48C64v189Ev,
  (VTBL_ENTRY)&_ZN5S48C64v190Ev,
  (VTBL_ENTRY)&_ZN5S48C64v191Ev,
  (VTBL_ENTRY)&_ZN5S48C64v192Ev,
  (VTBL_ENTRY)&_ZN5S48C64v193Ev,
  (VTBL_ENTRY)&_ZN5S48C64v194Ev,
  (VTBL_ENTRY)&_ZN5S48C64v195Ev,
  (VTBL_ENTRY)&_ZN5S48C64v196Ev,
  (VTBL_ENTRY)&_ZN5S48C64v197Ev,
  (VTBL_ENTRY)&_ZN5S48C64v198Ev,
  (VTBL_ENTRY)&_ZN5S48C64v199Ev,
  (VTBL_ENTRY)&_ZN5S48C64v200Ev,
  (VTBL_ENTRY)&_ZN5S48C64v201Ev,
  (VTBL_ENTRY)&_ZN5S48C64v202Ev,
  (VTBL_ENTRY)&_ZN5S48C64v203Ev,
  (VTBL_ENTRY)&_ZN5S48C64v204Ev,
  (VTBL_ENTRY)&_ZN5S48C64v205Ev,
  (VTBL_ENTRY)&_ZN5S48C64v206Ev,
  (VTBL_ENTRY)&_ZN5S48C64v207Ev,
  (VTBL_ENTRY)&_ZN5S48C64v208Ev,
  (VTBL_ENTRY)&_ZN5S48C64v209Ev,
  (VTBL_ENTRY)&_ZN5S48C64v210Ev,
  (VTBL_ENTRY)&_ZN5S48C64v211Ev,
  (VTBL_ENTRY)&_ZN5S48C64v212Ev,
  (VTBL_ENTRY)&_ZN5S48C64v213Ev,
  (VTBL_ENTRY)&_ZN5S48C64v214Ev,
  (VTBL_ENTRY)&_ZN5S48C64v215Ev,
  (VTBL_ENTRY)&_ZN5S48C64v216Ev,
  (VTBL_ENTRY)&_ZN5S48C64v217Ev,
  (VTBL_ENTRY)&_ZN5S48C54v218Ev,
  (VTBL_ENTRY)&_ZN5S48C54v219Ev,
  (VTBL_ENTRY)&_ZN5S48C54v220Ev,
  (VTBL_ENTRY)&_ZN5S48C54v221Ev,
  (VTBL_ENTRY)&_ZN5S48C54v222Ev,
  (VTBL_ENTRY)&_ZN5S48C54v223Ev,
  (VTBL_ENTRY)&_ZN5S48C54v224Ev,
  (VTBL_ENTRY)&_ZN5S48C54v225Ev,
  (VTBL_ENTRY)&_ZN5S48C54v226Ev,
  (VTBL_ENTRY)&_ZN5S48C54v227Ev,
  (VTBL_ENTRY)&_ZN5S48C54v228Ev,
  (VTBL_ENTRY)&_ZN5S48C54v229Ev,
  (VTBL_ENTRY)&_ZN5S48C54v230Ev,
  (VTBL_ENTRY)&_ZN5S48C54v231Ev,
  (VTBL_ENTRY)&_ZN5S48C54v232Ev,
  (VTBL_ENTRY)&_ZN5S48C54v233Ev,
  (VTBL_ENTRY)&_ZN5S48C54v234Ev,
  (VTBL_ENTRY)&_ZN5S48C54v235Ev,
  (VTBL_ENTRY)&_ZN5S48C54v236Ev,
  (VTBL_ENTRY)&_ZN5S48C54v237Ev,
  (VTBL_ENTRY)&_ZN5S48C54v238Ev,
  (VTBL_ENTRY)&_ZN5S48C54v239Ev,
  (VTBL_ENTRY)&_ZN5S48C54v240Ev,
  (VTBL_ENTRY)&_ZN5S48C54v241Ev,
  (VTBL_ENTRY)&_ZN5S48C54v242Ev,
  (VTBL_ENTRY)&_ZN5S48C54v243Ev,
  (VTBL_ENTRY)&_ZN5S48C54v244Ev,
  (VTBL_ENTRY)&_ZN5S48C54v245Ev,
  (VTBL_ENTRY)&_ZN5S48C54v246Ev,
  (VTBL_ENTRY)&_ZN5S48C54v247Ev,
  (VTBL_ENTRY)&_ZN5S48C54v248Ev,
  (VTBL_ENTRY)&_ZN5S48C54v249Ev,
  (VTBL_ENTRY)&_ZN5S48C54v250Ev,
  (VTBL_ENTRY)&_ZN5S48C54v251Ev,
  (VTBL_ENTRY)&_ZN5S48C54v252Ev,
  (VTBL_ENTRY)&_ZN5S48C54v253Ev,
  (VTBL_ENTRY)&_ZN5S48C54v254Ev,
  (VTBL_ENTRY)&_ZN5S48C54v255Ev,
  (VTBL_ENTRY)&_ZN5S48C54v256Ev,
  (VTBL_ENTRY)&_ZN5S48C54v257Ev,
  (VTBL_ENTRY)&_ZN5S48C54v258Ev,
  (VTBL_ENTRY)&_ZN5S48C54v259Ev,
  (VTBL_ENTRY)&_ZN5S48C54v260Ev,
  (VTBL_ENTRY)&_ZN5S48C54v261Ev,
  (VTBL_ENTRY)&_ZN5S48C54v262Ev,
  (VTBL_ENTRY)&_ZN5S48C54v263Ev,
  (VTBL_ENTRY)&_ZN5S48C54v264Ev,
  (VTBL_ENTRY)&_ZN5S48C54v265Ev,
  (VTBL_ENTRY)&_ZN5S48C54v266Ev,
  (VTBL_ENTRY)&_ZN5S48C54v267Ev,
  (VTBL_ENTRY)&_ZN5S48C44v268Ev,
  (VTBL_ENTRY)&_ZN5S48C44v269Ev,
  (VTBL_ENTRY)&_ZN5S48C44v270Ev,
  (VTBL_ENTRY)&_ZN5S48C44v271Ev,
  (VTBL_ENTRY)&_ZN5S48C44v272Ev,
  (VTBL_ENTRY)&_ZN5S48C44v273Ev,
  (VTBL_ENTRY)&_ZN5S48C44v274Ev,
  (VTBL_ENTRY)&_ZN5S48C44v275Ev,
  (VTBL_ENTRY)&_ZN5S48C44v276Ev,
  (VTBL_ENTRY)&_ZN5S48C44v277Ev,
  (VTBL_ENTRY)&_ZN5S48C44v278Ev,
  (VTBL_ENTRY)&_ZN5S48C44v279Ev,
  (VTBL_ENTRY)&_ZN5S48C44v280Ev,
  (VTBL_ENTRY)&_ZN5S48C44v281Ev,
  (VTBL_ENTRY)&_ZN5S48C44v282Ev,
  (VTBL_ENTRY)&_ZN5S48C44v283Ev,
  (VTBL_ENTRY)&_ZN5S48C44v284Ev,
  (VTBL_ENTRY)&_ZN5S48C44v285Ev,
  (VTBL_ENTRY)&_ZN5S48C44v286Ev,
  (VTBL_ENTRY)&_ZN5S48C44v287Ev,
  (VTBL_ENTRY)&_ZN5S48C44v288Ev,
  (VTBL_ENTRY)&_ZN5S48C44v289Ev,
  (VTBL_ENTRY)&_ZN5S48C44v290Ev,
  (VTBL_ENTRY)&_ZN5S48C44v291Ev,
  (VTBL_ENTRY)&_ZN5S48C44v292Ev,
  (VTBL_ENTRY)&_ZN5S48C44v293Ev,
  (VTBL_ENTRY)&_ZN5S48C44v294Ev,
  (VTBL_ENTRY)&_ZN5S48C44v295Ev,
  (VTBL_ENTRY)&_ZN5S48C44v296Ev,
  (VTBL_ENTRY)&_ZN5S48C44v297Ev,
  (VTBL_ENTRY)&_ZN5S48C44v298Ev,
  (VTBL_ENTRY)&_ZN5S48C44v299Ev,
  (VTBL_ENTRY)&_ZN5S48C44v300Ev,
  (VTBL_ENTRY)&_ZN5S48C44v301Ev,
  (VTBL_ENTRY)&_ZN5S48C44v302Ev,
  (VTBL_ENTRY)&_ZN5S48C44v303Ev,
  (VTBL_ENTRY)&_ZN5S48C44v304Ev,
  (VTBL_ENTRY)&_ZN5S48C44v305Ev,
  (VTBL_ENTRY)&_ZN5S48C34v306Ev,
  (VTBL_ENTRY)&_ZN5S48C34v307Ev,
  (VTBL_ENTRY)&_ZN5S48C34v308Ev,
  (VTBL_ENTRY)&_ZN5S48C24v309Ev,
  (VTBL_ENTRY)&_ZN5S48C24v310Ev,
  (VTBL_ENTRY)&_ZN5S48C24v311Ev,
  (VTBL_ENTRY)&_ZN5S48C24v312Ev,
  (VTBL_ENTRY)&_ZN5S48C24v313Ev,
  (VTBL_ENTRY)&_ZN5S48C24v314Ev,
  (VTBL_ENTRY)&_ZN5S48C24v315Ev,
  (VTBL_ENTRY)&_ZN5S48C24v316Ev,
  (VTBL_ENTRY)&_ZN5S48C24v317Ev,
  (VTBL_ENTRY)&_ZN5S48C24v318Ev,
  (VTBL_ENTRY)&_ZN5S48C24v319Ev,
  (VTBL_ENTRY)&_ZN5S48C24v320Ev,
  (VTBL_ENTRY)&_ZN5S48C24v321Ev,
  (VTBL_ENTRY)&_ZN5S48C24v322Ev,
  (VTBL_ENTRY)&_ZN5S48C24v323Ev,
  (VTBL_ENTRY)&_ZN5S48C24v324Ev,
  (VTBL_ENTRY)&_ZN5S48C24v325Ev,
  (VTBL_ENTRY)&_ZN5S48C24v326Ev,
  (VTBL_ENTRY)&_ZN5S48C24v327Ev,
};
extern VTBL_ENTRY _ZTI5S48C2[];
extern  VTBL_ENTRY _ZTV5S48C2[];
Class_Descriptor cd_S48C2 = {  "S48C2", // class name
  bases_S48C2, 5,
  &(vtc_S48C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2488,1904), // object size
  NSPAIRA(_ZTI5S48C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S48C2),321, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S48C1  : S48C2 {
  unsigned int s48c1f0:1;
  unsigned int s48c1f1:1;
  ::S48C54 s48c1f2;
  ::S48C54 s48c1f3;
  virtual  ~S48C1(); // _ZN5S48C1D1Ev
  virtual void  v1(); // _ZN5S48C12v1Ev
  virtual void  v2(); // _ZN5S48C12v2Ev
  virtual void  v3(); // _ZN5S48C12v3Ev
  virtual void  v4(); // _ZN5S48C12v4Ev
  virtual void  v5(); // _ZN5S48C12v5Ev
  virtual void  v6(); // _ZN5S48C12v6Ev
  virtual void  v7(); // _ZN5S48C12v7Ev
  virtual void  v8(); // _ZN5S48C12v8Ev
  virtual void  v9(); // _ZN5S48C12v9Ev
  virtual void  v10(); // _ZN5S48C13v10Ev
  S48C1(); // tgen
};
//SIG(1 S48C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 FC12{ m Fi} Fi Fc[4] Fp[2] FC13{ BC14{ BC11}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC8 FC8 FC8 FC15{ BC16{ BC11}} FC15 Fi Fp[2] FC17{ m Fi[3]} FC18{ m Fi[3]} FC17 FC17 Fp FC8 FC15 FC17 FC18 Fi FC17 FC17 Fp Fi Fc FC18 FC18 Fp Fi Fp FC19{ BC20{ BC11}} FC21{ BC22{ BC11}} FC23{ BC24{ BC11}}} vd v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC17 FC17 Fp[5] FC17 Fp FC25{ BC26{ BC11}} Fp[2] FC17 Fp Fi[2] Fp Fi FC17 FC17 FC17 Fp[2] Fi FC17 Fi[4] Fp[2] FC27{ BC28{ BC11}} Fi FC18} vd v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 Fp[8] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fc[6] Fp[2] Fi[4] FC18 Fi FC18 Fp[5] FC17 Fi[12] FC29{ Fi Fc FC17 FC17 Fp FC17 Fc} FC30{ BC23}[2] Fi FC30 FC30 FC30 FC30 Fi FC17 Fp[4] FC17 Fp FC30 Fp FC31{ BC32{ BC11}} FC33{ BC34{ BC11}} FC33 FC33 Fp FC35{ BC36{ m Fp[2]}} Fp Fi FC37{ BC38{ BC11}} Fi FC30[4] FC37 Fp FC39{ BC40{ BC11}} Fi[3] FC39 FC39 FC15 FC41{ BC42{ BC11}} Fi FC43{ m Fp FC8}} vd v306 v307 v308} vd v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc[6] FC17 Fp[2] Fi[2] FC30 Fp[3] FC44{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC45{ m} Fc Fi[2] FC17 Fi[3] Fi:1 Fi[4] FC17 FC17 FC17 Fi} Fp FC17 FC18 FC44 Fi Fp[3] FC17 FC18 FC17 FC18 Fi FC17 Fi[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] FC18 Fi Fp Fi[5] FC30 Fi Fp[4] FC30 FC41 Fp[2] FC15 Fi[5] Fp FC46{ BC47{ BC11}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fi:1 Fi:1 FC46 FC46}


 S48C1 ::~S48C1(){ note_dtor("S48C1", this);}
void  S48C1 ::v1(){vfunc_called(this, "_ZN5S48C12v1Ev");}
void  S48C1 ::v2(){vfunc_called(this, "_ZN5S48C12v2Ev");}
void  S48C1 ::v3(){vfunc_called(this, "_ZN5S48C12v3Ev");}
void  S48C1 ::v4(){vfunc_called(this, "_ZN5S48C12v4Ev");}
void  S48C1 ::v5(){vfunc_called(this, "_ZN5S48C12v5Ev");}
void  S48C1 ::v6(){vfunc_called(this, "_ZN5S48C12v6Ev");}
void  S48C1 ::v7(){vfunc_called(this, "_ZN5S48C12v7Ev");}
void  S48C1 ::v8(){vfunc_called(this, "_ZN5S48C12v8Ev");}
void  S48C1 ::v9(){vfunc_called(this, "_ZN5S48C12v9Ev");}
void  S48C1 ::v10(){vfunc_called(this, "_ZN5S48C13v10Ev");}
S48C1 ::S48C1(){ note_ctor("S48C1", this);} // tgen

static void Test_S48C1()
{
  extern Class_Descriptor cd_S48C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(316,484)];
    init_test(&cd_S48C1, buf);
    S48C1 *dp, &lv = *(dp=new (buf) S48C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2520,1932), "sizeof(S48C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S48C1)");
    check_base_class_offset(lv, (S48C7*)(S48C6*)(S48C5*)(S48C4*)(S48C3*)(S48C2*), 0, "S48C1");
    check_base_class_offset(lv, (S48C6*)(S48C5*)(S48C4*)(S48C3*)(S48C2*), 0, "S48C1");
    check_base_class_offset(lv, (S48C5*)(S48C4*)(S48C3*)(S48C2*), 0, "S48C1");
    check_base_class_offset(lv, (S48C4*)(S48C3*)(S48C2*), 0, "S48C1");
    check_base_class_offset(lv, (S48C3*)(S48C2*), 0, "S48C1");
    check_base_class_offset(lv, (S48C2*), 0, "S48C1");
    set_bf_and_test(lv, s48c1f0, ABISELECT(2484,1904), 0, 1, 1, "S48C1");
    set_bf_and_test(lv, s48c1f1, ABISELECT(2484,1904), 1, 1, 1, "S48C1");
    check_field_offset(lv, s48c1f2, ABISELECT(2488,1908), "S48C1.s48c1f2");
    check_field_offset(lv, s48c1f3, ABISELECT(2504,1920), "S48C1.s48c1f3");
    test_class_info(&lv, &cd_S48C1);
    dp->~S48C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS48C1(Test_S48C1, "S48C1", ABISELECT(2520,1932));

#else // __cplusplus

extern void _ZN5S48C1C1Ev();
extern void _ZN5S48C1D1Ev();
Name_Map name_map_S48C1[] = {
  NSPAIR(_ZN5S48C1C1Ev),
  NSPAIR(_ZN5S48C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S48C7;
extern VTBL_ENTRY _ZTI5S48C7[];
extern  VTBL_ENTRY _ZTV5S48C7[];
extern Class_Descriptor cd_S48C6;
extern VTBL_ENTRY _ZTI5S48C6[];
extern  VTBL_ENTRY _ZTV5S48C6[];
extern Class_Descriptor cd_S48C5;
extern VTBL_ENTRY _ZTI5S48C5[];
extern  VTBL_ENTRY _ZTV5S48C5[];
extern Class_Descriptor cd_S48C4;
extern VTBL_ENTRY _ZTI5S48C4[];
extern  VTBL_ENTRY _ZTV5S48C4[];
extern Class_Descriptor cd_S48C3;
extern VTBL_ENTRY _ZTI5S48C3[];
extern  VTBL_ENTRY _ZTV5S48C3[];
extern Class_Descriptor cd_S48C2;
extern VTBL_ENTRY _ZTI5S48C2[];
extern  VTBL_ENTRY _ZTV5S48C2[];
static Base_Class bases_S48C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S48C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S48C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S48C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S48C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S48C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S48C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S48C1[];
extern void _ZN5S48C1D1Ev();
extern void _ZN5S48C1D0Ev();
extern void _ZN5S48C73v11Ev();
extern void _ZN5S48C73v12Ev();
extern void _ZN5S48C73v13Ev();
extern void _ZN5S48C73v14Ev();
extern void _ZN5S48C73v15Ev();
extern void _ZN5S48C73v16Ev();
extern void _ZN5S48C73v17Ev();
extern void _ZN5S48C73v18Ev();
extern void _ZN5S48C73v19Ev();
extern void _ZN5S48C73v20Ev();
extern void _ZN5S48C73v21Ev();
extern void _ZN5S48C73v22Ev();
extern void _ZN5S48C73v23Ev();
extern void _ZN5S48C73v24Ev();
extern void _ZN5S48C73v25Ev();
extern void _ZN5S48C73v26Ev();
extern void _ZN5S48C73v27Ev();
extern void _ZN5S48C73v28Ev();
extern void _ZN5S48C73v29Ev();
extern void _ZN5S48C73v30Ev();
extern void _ZN5S48C73v31Ev();
extern void _ZN5S48C73v32Ev();
extern void _ZN5S48C73v33Ev();
extern void _ZN5S48C73v34Ev();
extern void _ZN5S48C73v35Ev();
extern void _ZN5S48C73v36Ev();
extern void _ZN5S48C73v37Ev();
extern void _ZN5S48C73v38Ev();
extern void _ZN5S48C73v39Ev();
extern void _ZN5S48C73v40Ev();
extern void _ZN5S48C73v41Ev();
extern void _ZN5S48C73v42Ev();
extern void _ZN5S48C73v43Ev();
extern void _ZN5S48C73v44Ev();
extern void _ZN5S48C73v45Ev();
extern void _ZN5S48C73v46Ev();
extern void _ZN5S48C73v47Ev();
extern void _ZN5S48C73v48Ev();
extern void _ZN5S48C73v49Ev();
extern void _ZN5S48C73v50Ev();
extern void _ZN5S48C73v51Ev();
extern void _ZN5S48C73v52Ev();
extern void _ZN5S48C73v53Ev();
extern void _ZN5S48C73v54Ev();
extern void _ZN5S48C73v55Ev();
extern void _ZN5S48C73v56Ev();
extern void _ZN5S48C73v57Ev();
extern void _ZN5S48C73v58Ev();
extern void _ZN5S48C73v59Ev();
extern void _ZN5S48C73v60Ev();
extern void _ZN5S48C73v61Ev();
extern void _ZN5S48C73v62Ev();
extern void _ZN5S48C73v63Ev();
extern void _ZN5S48C73v64Ev();
extern void _ZN5S48C73v65Ev();
extern void _ZN5S48C73v66Ev();
extern void _ZN5S48C73v67Ev();
extern void _ZN5S48C73v68Ev();
extern void _ZN5S48C73v69Ev();
extern void _ZN5S48C73v70Ev();
extern void _ZN5S48C73v71Ev();
extern void _ZN5S48C73v72Ev();
extern void _ZN5S48C73v73Ev();
extern void _ZN5S48C73v74Ev();
extern void _ZN5S48C63v75Ev();
extern void _ZN5S48C63v76Ev();
extern void _ZN5S48C63v77Ev();
extern void _ZN5S48C63v78Ev();
extern void _ZN5S48C63v79Ev();
extern void _ZN5S48C63v80Ev();
extern void _ZN5S48C63v81Ev();
extern void _ZN5S48C63v82Ev();
extern void _ZN5S48C63v83Ev();
extern void _ZN5S48C63v84Ev();
extern void _ZN5S48C63v85Ev();
extern void _ZN5S48C63v86Ev();
extern void _ZN5S48C63v87Ev();
extern void _ZN5S48C63v88Ev();
extern void _ZN5S48C63v89Ev();
extern void _ZN5S48C63v90Ev();
extern void _ZN5S48C63v91Ev();
extern void _ZN5S48C63v92Ev();
extern void _ZN5S48C63v93Ev();
extern void _ZN5S48C63v94Ev();
extern void _ZN5S48C63v95Ev();
extern void _ZN5S48C63v96Ev();
extern void _ZN5S48C63v97Ev();
extern void _ZN5S48C63v98Ev();
extern void _ZN5S48C63v99Ev();
extern void _ZN5S48C64v100Ev();
extern void _ZN5S48C64v101Ev();
extern void _ZN5S48C64v102Ev();
extern void _ZN5S48C64v103Ev();
extern void _ZN5S48C64v104Ev();
extern void _ZN5S48C64v105Ev();
extern void _ZN5S48C64v106Ev();
extern void _ZN5S48C64v107Ev();
extern void _ZN5S48C64v108Ev();
extern void _ZN5S48C64v109Ev();
extern void _ZN5S48C64v110Ev();
extern void _ZN5S48C64v111Ev();
extern void _ZN5S48C64v112Ev();
extern void _ZN5S48C64v113Ev();
extern void _ZN5S48C64v114Ev();
extern void _ZN5S48C64v115Ev();
extern void _ZN5S48C64v116Ev();
extern void _ZN5S48C64v117Ev();
extern void _ZN5S48C64v118Ev();
extern void _ZN5S48C64v119Ev();
extern void _ZN5S48C64v120Ev();
extern void _ZN5S48C64v121Ev();
extern void _ZN5S48C64v122Ev();
extern void _ZN5S48C64v123Ev();
extern void _ZN5S48C64v124Ev();
extern void _ZN5S48C64v125Ev();
extern void _ZN5S48C64v126Ev();
extern void _ZN5S48C64v127Ev();
extern void _ZN5S48C64v128Ev();
extern void _ZN5S48C64v129Ev();
extern void _ZN5S48C64v130Ev();
extern void _ZN5S48C64v131Ev();
extern void _ZN5S48C64v132Ev();
extern void _ZN5S48C64v133Ev();
extern void _ZN5S48C64v134Ev();
extern void _ZN5S48C64v135Ev();
extern void _ZN5S48C64v136Ev();
extern void _ZN5S48C64v137Ev();
extern void _ZN5S48C64v138Ev();
extern void _ZN5S48C64v139Ev();
extern void _ZN5S48C64v140Ev();
extern void _ZN5S48C64v141Ev();
extern void _ZN5S48C64v142Ev();
extern void _ZN5S48C64v143Ev();
extern void _ZN5S48C64v144Ev();
extern void _ZN5S48C64v145Ev();
extern void _ZN5S48C64v146Ev();
extern void _ZN5S48C64v147Ev();
extern void _ZN5S48C64v148Ev();
extern void _ZN5S48C64v149Ev();
extern void _ZN5S48C64v150Ev();
extern void _ZN5S48C64v151Ev();
extern void _ZN5S48C64v152Ev();
extern void _ZN5S48C64v153Ev();
extern void _ZN5S48C64v154Ev();
extern void _ZN5S48C64v155Ev();
extern void _ZN5S48C64v156Ev();
extern void _ZN5S48C64v157Ev();
extern void _ZN5S48C64v158Ev();
extern void _ZN5S48C64v159Ev();
extern void _ZN5S48C64v160Ev();
extern void _ZN5S48C64v161Ev();
extern void _ZN5S48C64v162Ev();
extern void _ZN5S48C64v163Ev();
extern void _ZN5S48C64v164Ev();
extern void _ZN5S48C64v165Ev();
extern void _ZN5S48C64v166Ev();
extern void _ZN5S48C64v167Ev();
extern void _ZN5S48C64v168Ev();
extern void _ZN5S48C64v169Ev();
extern void _ZN5S48C64v170Ev();
extern void _ZN5S48C64v171Ev();
extern void _ZN5S48C64v172Ev();
extern void _ZN5S48C64v173Ev();
extern void _ZN5S48C64v174Ev();
extern void _ZN5S48C64v175Ev();
extern void _ZN5S48C64v176Ev();
extern void _ZN5S48C64v177Ev();
extern void _ZN5S48C64v178Ev();
extern void _ZN5S48C64v179Ev();
extern void _ZN5S48C64v180Ev();
extern void _ZN5S48C64v181Ev();
extern void _ZN5S48C64v182Ev();
extern void _ZN5S48C64v183Ev();
extern void _ZN5S48C64v184Ev();
extern void _ZN5S48C64v185Ev();
extern void _ZN5S48C64v186Ev();
extern void _ZN5S48C64v187Ev();
extern void _ZN5S48C64v188Ev();
extern void _ZN5S48C64v189Ev();
extern void _ZN5S48C64v190Ev();
extern void _ZN5S48C64v191Ev();
extern void _ZN5S48C64v192Ev();
extern void _ZN5S48C64v193Ev();
extern void _ZN5S48C64v194Ev();
extern void _ZN5S48C64v195Ev();
extern void _ZN5S48C64v196Ev();
extern void _ZN5S48C64v197Ev();
extern void _ZN5S48C64v198Ev();
extern void _ZN5S48C64v199Ev();
extern void _ZN5S48C64v200Ev();
extern void _ZN5S48C64v201Ev();
extern void _ZN5S48C64v202Ev();
extern void _ZN5S48C64v203Ev();
extern void _ZN5S48C64v204Ev();
extern void _ZN5S48C64v205Ev();
extern void _ZN5S48C64v206Ev();
extern void _ZN5S48C64v207Ev();
extern void _ZN5S48C64v208Ev();
extern void _ZN5S48C64v209Ev();
extern void _ZN5S48C64v210Ev();
extern void _ZN5S48C64v211Ev();
extern void _ZN5S48C64v212Ev();
extern void _ZN5S48C64v213Ev();
extern void _ZN5S48C64v214Ev();
extern void _ZN5S48C64v215Ev();
extern void _ZN5S48C64v216Ev();
extern void _ZN5S48C64v217Ev();
extern void _ZN5S48C54v218Ev();
extern void _ZN5S48C54v219Ev();
extern void _ZN5S48C54v220Ev();
extern void _ZN5S48C54v221Ev();
extern void _ZN5S48C54v222Ev();
extern void _ZN5S48C54v223Ev();
extern void _ZN5S48C54v224Ev();
extern void _ZN5S48C54v225Ev();
extern void _ZN5S48C54v226Ev();
extern void _ZN5S48C54v227Ev();
extern void _ZN5S48C54v228Ev();
extern void _ZN5S48C54v229Ev();
extern void _ZN5S48C54v230Ev();
extern void _ZN5S48C54v231Ev();
extern void _ZN5S48C54v232Ev();
extern void _ZN5S48C54v233Ev();
extern void _ZN5S48C54v234Ev();
extern void _ZN5S48C54v235Ev();
extern void _ZN5S48C54v236Ev();
extern void _ZN5S48C54v237Ev();
extern void _ZN5S48C54v238Ev();
extern void _ZN5S48C54v239Ev();
extern void _ZN5S48C54v240Ev();
extern void _ZN5S48C54v241Ev();
extern void _ZN5S48C54v242Ev();
extern void _ZN5S48C54v243Ev();
extern void _ZN5S48C54v244Ev();
extern void _ZN5S48C54v245Ev();
extern void _ZN5S48C54v246Ev();
extern void _ZN5S48C54v247Ev();
extern void _ZN5S48C54v248Ev();
extern void _ZN5S48C54v249Ev();
extern void _ZN5S48C54v250Ev();
extern void _ZN5S48C54v251Ev();
extern void _ZN5S48C54v252Ev();
extern void _ZN5S48C54v253Ev();
extern void _ZN5S48C54v254Ev();
extern void _ZN5S48C54v255Ev();
extern void _ZN5S48C54v256Ev();
extern void _ZN5S48C54v257Ev();
extern void _ZN5S48C54v258Ev();
extern void _ZN5S48C54v259Ev();
extern void _ZN5S48C54v260Ev();
extern void _ZN5S48C54v261Ev();
extern void _ZN5S48C54v262Ev();
extern void _ZN5S48C54v263Ev();
extern void _ZN5S48C54v264Ev();
extern void _ZN5S48C54v265Ev();
extern void _ZN5S48C54v266Ev();
extern void _ZN5S48C54v267Ev();
extern void _ZN5S48C44v268Ev();
extern void _ZN5S48C44v269Ev();
extern void _ZN5S48C44v270Ev();
extern void _ZN5S48C44v271Ev();
extern void _ZN5S48C44v272Ev();
extern void _ZN5S48C44v273Ev();
extern void _ZN5S48C44v274Ev();
extern void _ZN5S48C44v275Ev();
extern void _ZN5S48C44v276Ev();
extern void _ZN5S48C44v277Ev();
extern void _ZN5S48C44v278Ev();
extern void _ZN5S48C44v279Ev();
extern void _ZN5S48C44v280Ev();
extern void _ZN5S48C44v281Ev();
extern void _ZN5S48C44v282Ev();
extern void _ZN5S48C44v283Ev();
extern void _ZN5S48C44v284Ev();
extern void _ZN5S48C44v285Ev();
extern void _ZN5S48C44v286Ev();
extern void _ZN5S48C44v287Ev();
extern void _ZN5S48C44v288Ev();
extern void _ZN5S48C44v289Ev();
extern void _ZN5S48C44v290Ev();
extern void _ZN5S48C44v291Ev();
extern void _ZN5S48C44v292Ev();
extern void _ZN5S48C44v293Ev();
extern void _ZN5S48C44v294Ev();
extern void _ZN5S48C44v295Ev();
extern void _ZN5S48C44v296Ev();
extern void _ZN5S48C44v297Ev();
extern void _ZN5S48C44v298Ev();
extern void _ZN5S48C44v299Ev();
extern void _ZN5S48C44v300Ev();
extern void _ZN5S48C44v301Ev();
extern void _ZN5S48C44v302Ev();
extern void _ZN5S48C44v303Ev();
extern void _ZN5S48C44v304Ev();
extern void _ZN5S48C44v305Ev();
extern void _ZN5S48C34v306Ev();
extern void _ZN5S48C34v307Ev();
extern void _ZN5S48C34v308Ev();
extern void _ZN5S48C24v309Ev();
extern void _ZN5S48C24v310Ev();
extern void _ZN5S48C24v311Ev();
extern void _ZN5S48C24v312Ev();
extern void _ZN5S48C24v313Ev();
extern void _ZN5S48C24v314Ev();
extern void _ZN5S48C24v315Ev();
extern void _ZN5S48C24v316Ev();
extern void _ZN5S48C24v317Ev();
extern void _ZN5S48C24v318Ev();
extern void _ZN5S48C24v319Ev();
extern void _ZN5S48C24v320Ev();
extern void _ZN5S48C24v321Ev();
extern void _ZN5S48C24v322Ev();
extern void _ZN5S48C24v323Ev();
extern void _ZN5S48C24v324Ev();
extern void _ZN5S48C24v325Ev();
extern void _ZN5S48C24v326Ev();
extern void _ZN5S48C24v327Ev();
extern void _ZN5S48C12v1Ev();
extern void _ZN5S48C12v2Ev();
extern void _ZN5S48C12v3Ev();
extern void _ZN5S48C12v4Ev();
extern void _ZN5S48C12v5Ev();
extern void _ZN5S48C12v6Ev();
extern void _ZN5S48C12v7Ev();
extern void _ZN5S48C12v8Ev();
extern void _ZN5S48C12v9Ev();
extern void _ZN5S48C13v10Ev();
static  VTBL_ENTRY vtc_S48C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S48C1[0]),
  (VTBL_ENTRY)&_ZN5S48C1D1Ev,
  (VTBL_ENTRY)&_ZN5S48C1D0Ev,
  (VTBL_ENTRY)&_ZN5S48C73v11Ev,
  (VTBL_ENTRY)&_ZN5S48C73v12Ev,
  (VTBL_ENTRY)&_ZN5S48C73v13Ev,
  (VTBL_ENTRY)&_ZN5S48C73v14Ev,
  (VTBL_ENTRY)&_ZN5S48C73v15Ev,
  (VTBL_ENTRY)&_ZN5S48C73v16Ev,
  (VTBL_ENTRY)&_ZN5S48C73v17Ev,
  (VTBL_ENTRY)&_ZN5S48C73v18Ev,
  (VTBL_ENTRY)&_ZN5S48C73v19Ev,
  (VTBL_ENTRY)&_ZN5S48C73v20Ev,
  (VTBL_ENTRY)&_ZN5S48C73v21Ev,
  (VTBL_ENTRY)&_ZN5S48C73v22Ev,
  (VTBL_ENTRY)&_ZN5S48C73v23Ev,
  (VTBL_ENTRY)&_ZN5S48C73v24Ev,
  (VTBL_ENTRY)&_ZN5S48C73v25Ev,
  (VTBL_ENTRY)&_ZN5S48C73v26Ev,
  (VTBL_ENTRY)&_ZN5S48C73v27Ev,
  (VTBL_ENTRY)&_ZN5S48C73v28Ev,
  (VTBL_ENTRY)&_ZN5S48C73v29Ev,
  (VTBL_ENTRY)&_ZN5S48C73v30Ev,
  (VTBL_ENTRY)&_ZN5S48C73v31Ev,
  (VTBL_ENTRY)&_ZN5S48C73v32Ev,
  (VTBL_ENTRY)&_ZN5S48C73v33Ev,
  (VTBL_ENTRY)&_ZN5S48C73v34Ev,
  (VTBL_ENTRY)&_ZN5S48C73v35Ev,
  (VTBL_ENTRY)&_ZN5S48C73v36Ev,
  (VTBL_ENTRY)&_ZN5S48C73v37Ev,
  (VTBL_ENTRY)&_ZN5S48C73v38Ev,
  (VTBL_ENTRY)&_ZN5S48C73v39Ev,
  (VTBL_ENTRY)&_ZN5S48C73v40Ev,
  (VTBL_ENTRY)&_ZN5S48C73v41Ev,
  (VTBL_ENTRY)&_ZN5S48C73v42Ev,
  (VTBL_ENTRY)&_ZN5S48C73v43Ev,
  (VTBL_ENTRY)&_ZN5S48C73v44Ev,
  (VTBL_ENTRY)&_ZN5S48C73v45Ev,
  (VTBL_ENTRY)&_ZN5S48C73v46Ev,
  (VTBL_ENTRY)&_ZN5S48C73v47Ev,
  (VTBL_ENTRY)&_ZN5S48C73v48Ev,
  (VTBL_ENTRY)&_ZN5S48C73v49Ev,
  (VTBL_ENTRY)&_ZN5S48C73v50Ev,
  (VTBL_ENTRY)&_ZN5S48C73v51Ev,
  (VTBL_ENTRY)&_ZN5S48C73v52Ev,
  (VTBL_ENTRY)&_ZN5S48C73v53Ev,
  (VTBL_ENTRY)&_ZN5S48C73v54Ev,
  (VTBL_ENTRY)&_ZN5S48C73v55Ev,
  (VTBL_ENTRY)&_ZN5S48C73v56Ev,
  (VTBL_ENTRY)&_ZN5S48C73v57Ev,
  (VTBL_ENTRY)&_ZN5S48C73v58Ev,
  (VTBL_ENTRY)&_ZN5S48C73v59Ev,
  (VTBL_ENTRY)&_ZN5S48C73v60Ev,
  (VTBL_ENTRY)&_ZN5S48C73v61Ev,
  (VTBL_ENTRY)&_ZN5S48C73v62Ev,
  (VTBL_ENTRY)&_ZN5S48C73v63Ev,
  (VTBL_ENTRY)&_ZN5S48C73v64Ev,
  (VTBL_ENTRY)&_ZN5S48C73v65Ev,
  (VTBL_ENTRY)&_ZN5S48C73v66Ev,
  (VTBL_ENTRY)&_ZN5S48C73v67Ev,
  (VTBL_ENTRY)&_ZN5S48C73v68Ev,
  (VTBL_ENTRY)&_ZN5S48C73v69Ev,
  (VTBL_ENTRY)&_ZN5S48C73v70Ev,
  (VTBL_ENTRY)&_ZN5S48C73v71Ev,
  (VTBL_ENTRY)&_ZN5S48C73v72Ev,
  (VTBL_ENTRY)&_ZN5S48C73v73Ev,
  (VTBL_ENTRY)&_ZN5S48C73v74Ev,
  (VTBL_ENTRY)&_ZN5S48C63v75Ev,
  (VTBL_ENTRY)&_ZN5S48C63v76Ev,
  (VTBL_ENTRY)&_ZN5S48C63v77Ev,
  (VTBL_ENTRY)&_ZN5S48C63v78Ev,
  (VTBL_ENTRY)&_ZN5S48C63v79Ev,
  (VTBL_ENTRY)&_ZN5S48C63v80Ev,
  (VTBL_ENTRY)&_ZN5S48C63v81Ev,
  (VTBL_ENTRY)&_ZN5S48C63v82Ev,
  (VTBL_ENTRY)&_ZN5S48C63v83Ev,
  (VTBL_ENTRY)&_ZN5S48C63v84Ev,
  (VTBL_ENTRY)&_ZN5S48C63v85Ev,
  (VTBL_ENTRY)&_ZN5S48C63v86Ev,
  (VTBL_ENTRY)&_ZN5S48C63v87Ev,
  (VTBL_ENTRY)&_ZN5S48C63v88Ev,
  (VTBL_ENTRY)&_ZN5S48C63v89Ev,
  (VTBL_ENTRY)&_ZN5S48C63v90Ev,
  (VTBL_ENTRY)&_ZN5S48C63v91Ev,
  (VTBL_ENTRY)&_ZN5S48C63v92Ev,
  (VTBL_ENTRY)&_ZN5S48C63v93Ev,
  (VTBL_ENTRY)&_ZN5S48C63v94Ev,
  (VTBL_ENTRY)&_ZN5S48C63v95Ev,
  (VTBL_ENTRY)&_ZN5S48C63v96Ev,
  (VTBL_ENTRY)&_ZN5S48C63v97Ev,
  (VTBL_ENTRY)&_ZN5S48C63v98Ev,
  (VTBL_ENTRY)&_ZN5S48C63v99Ev,
  (VTBL_ENTRY)&_ZN5S48C64v100Ev,
  (VTBL_ENTRY)&_ZN5S48C64v101Ev,
  (VTBL_ENTRY)&_ZN5S48C64v102Ev,
  (VTBL_ENTRY)&_ZN5S48C64v103Ev,
  (VTBL_ENTRY)&_ZN5S48C64v104Ev,
  (VTBL_ENTRY)&_ZN5S48C64v105Ev,
  (VTBL_ENTRY)&_ZN5S48C64v106Ev,
  (VTBL_ENTRY)&_ZN5S48C64v107Ev,
  (VTBL_ENTRY)&_ZN5S48C64v108Ev,
  (VTBL_ENTRY)&_ZN5S48C64v109Ev,
  (VTBL_ENTRY)&_ZN5S48C64v110Ev,
  (VTBL_ENTRY)&_ZN5S48C64v111Ev,
  (VTBL_ENTRY)&_ZN5S48C64v112Ev,
  (VTBL_ENTRY)&_ZN5S48C64v113Ev,
  (VTBL_ENTRY)&_ZN5S48C64v114Ev,
  (VTBL_ENTRY)&_ZN5S48C64v115Ev,
  (VTBL_ENTRY)&_ZN5S48C64v116Ev,
  (VTBL_ENTRY)&_ZN5S48C64v117Ev,
  (VTBL_ENTRY)&_ZN5S48C64v118Ev,
  (VTBL_ENTRY)&_ZN5S48C64v119Ev,
  (VTBL_ENTRY)&_ZN5S48C64v120Ev,
  (VTBL_ENTRY)&_ZN5S48C64v121Ev,
  (VTBL_ENTRY)&_ZN5S48C64v122Ev,
  (VTBL_ENTRY)&_ZN5S48C64v123Ev,
  (VTBL_ENTRY)&_ZN5S48C64v124Ev,
  (VTBL_ENTRY)&_ZN5S48C64v125Ev,
  (VTBL_ENTRY)&_ZN5S48C64v126Ev,
  (VTBL_ENTRY)&_ZN5S48C64v127Ev,
  (VTBL_ENTRY)&_ZN5S48C64v128Ev,
  (VTBL_ENTRY)&_ZN5S48C64v129Ev,
  (VTBL_ENTRY)&_ZN5S48C64v130Ev,
  (VTBL_ENTRY)&_ZN5S48C64v131Ev,
  (VTBL_ENTRY)&_ZN5S48C64v132Ev,
  (VTBL_ENTRY)&_ZN5S48C64v133Ev,
  (VTBL_ENTRY)&_ZN5S48C64v134Ev,
  (VTBL_ENTRY)&_ZN5S48C64v135Ev,
  (VTBL_ENTRY)&_ZN5S48C64v136Ev,
  (VTBL_ENTRY)&_ZN5S48C64v137Ev,
  (VTBL_ENTRY)&_ZN5S48C64v138Ev,
  (VTBL_ENTRY)&_ZN5S48C64v139Ev,
  (VTBL_ENTRY)&_ZN5S48C64v140Ev,
  (VTBL_ENTRY)&_ZN5S48C64v141Ev,
  (VTBL_ENTRY)&_ZN5S48C64v142Ev,
  (VTBL_ENTRY)&_ZN5S48C64v143Ev,
  (VTBL_ENTRY)&_ZN5S48C64v144Ev,
  (VTBL_ENTRY)&_ZN5S48C64v145Ev,
  (VTBL_ENTRY)&_ZN5S48C64v146Ev,
  (VTBL_ENTRY)&_ZN5S48C64v147Ev,
  (VTBL_ENTRY)&_ZN5S48C64v148Ev,
  (VTBL_ENTRY)&_ZN5S48C64v149Ev,
  (VTBL_ENTRY)&_ZN5S48C64v150Ev,
  (VTBL_ENTRY)&_ZN5S48C64v151Ev,
  (VTBL_ENTRY)&_ZN5S48C64v152Ev,
  (VTBL_ENTRY)&_ZN5S48C64v153Ev,
  (VTBL_ENTRY)&_ZN5S48C64v154Ev,
  (VTBL_ENTRY)&_ZN5S48C64v155Ev,
  (VTBL_ENTRY)&_ZN5S48C64v156Ev,
  (VTBL_ENTRY)&_ZN5S48C64v157Ev,
  (VTBL_ENTRY)&_ZN5S48C64v158Ev,
  (VTBL_ENTRY)&_ZN5S48C64v159Ev,
  (VTBL_ENTRY)&_ZN5S48C64v160Ev,
  (VTBL_ENTRY)&_ZN5S48C64v161Ev,
  (VTBL_ENTRY)&_ZN5S48C64v162Ev,
  (VTBL_ENTRY)&_ZN5S48C64v163Ev,
  (VTBL_ENTRY)&_ZN5S48C64v164Ev,
  (VTBL_ENTRY)&_ZN5S48C64v165Ev,
  (VTBL_ENTRY)&_ZN5S48C64v166Ev,
  (VTBL_ENTRY)&_ZN5S48C64v167Ev,
  (VTBL_ENTRY)&_ZN5S48C64v168Ev,
  (VTBL_ENTRY)&_ZN5S48C64v169Ev,
  (VTBL_ENTRY)&_ZN5S48C64v170Ev,
  (VTBL_ENTRY)&_ZN5S48C64v171Ev,
  (VTBL_ENTRY)&_ZN5S48C64v172Ev,
  (VTBL_ENTRY)&_ZN5S48C64v173Ev,
  (VTBL_ENTRY)&_ZN5S48C64v174Ev,
  (VTBL_ENTRY)&_ZN5S48C64v175Ev,
  (VTBL_ENTRY)&_ZN5S48C64v176Ev,
  (VTBL_ENTRY)&_ZN5S48C64v177Ev,
  (VTBL_ENTRY)&_ZN5S48C64v178Ev,
  (VTBL_ENTRY)&_ZN5S48C64v179Ev,
  (VTBL_ENTRY)&_ZN5S48C64v180Ev,
  (VTBL_ENTRY)&_ZN5S48C64v181Ev,
  (VTBL_ENTRY)&_ZN5S48C64v182Ev,
  (VTBL_ENTRY)&_ZN5S48C64v183Ev,
  (VTBL_ENTRY)&_ZN5S48C64v184Ev,
  (VTBL_ENTRY)&_ZN5S48C64v185Ev,
  (VTBL_ENTRY)&_ZN5S48C64v186Ev,
  (VTBL_ENTRY)&_ZN5S48C64v187Ev,
  (VTBL_ENTRY)&_ZN5S48C64v188Ev,
  (VTBL_ENTRY)&_ZN5S48C64v189Ev,
  (VTBL_ENTRY)&_ZN5S48C64v190Ev,
  (VTBL_ENTRY)&_ZN5S48C64v191Ev,
  (VTBL_ENTRY)&_ZN5S48C64v192Ev,
  (VTBL_ENTRY)&_ZN5S48C64v193Ev,
  (VTBL_ENTRY)&_ZN5S48C64v194Ev,
  (VTBL_ENTRY)&_ZN5S48C64v195Ev,
  (VTBL_ENTRY)&_ZN5S48C64v196Ev,
  (VTBL_ENTRY)&_ZN5S48C64v197Ev,
  (VTBL_ENTRY)&_ZN5S48C64v198Ev,
  (VTBL_ENTRY)&_ZN5S48C64v199Ev,
  (VTBL_ENTRY)&_ZN5S48C64v200Ev,
  (VTBL_ENTRY)&_ZN5S48C64v201Ev,
  (VTBL_ENTRY)&_ZN5S48C64v202Ev,
  (VTBL_ENTRY)&_ZN5S48C64v203Ev,
  (VTBL_ENTRY)&_ZN5S48C64v204Ev,
  (VTBL_ENTRY)&_ZN5S48C64v205Ev,
  (VTBL_ENTRY)&_ZN5S48C64v206Ev,
  (VTBL_ENTRY)&_ZN5S48C64v207Ev,
  (VTBL_ENTRY)&_ZN5S48C64v208Ev,
  (VTBL_ENTRY)&_ZN5S48C64v209Ev,
  (VTBL_ENTRY)&_ZN5S48C64v210Ev,
  (VTBL_ENTRY)&_ZN5S48C64v211Ev,
  (VTBL_ENTRY)&_ZN5S48C64v212Ev,
  (VTBL_ENTRY)&_ZN5S48C64v213Ev,
  (VTBL_ENTRY)&_ZN5S48C64v214Ev,
  (VTBL_ENTRY)&_ZN5S48C64v215Ev,
  (VTBL_ENTRY)&_ZN5S48C64v216Ev,
  (VTBL_ENTRY)&_ZN5S48C64v217Ev,
  (VTBL_ENTRY)&_ZN5S48C54v218Ev,
  (VTBL_ENTRY)&_ZN5S48C54v219Ev,
  (VTBL_ENTRY)&_ZN5S48C54v220Ev,
  (VTBL_ENTRY)&_ZN5S48C54v221Ev,
  (VTBL_ENTRY)&_ZN5S48C54v222Ev,
  (VTBL_ENTRY)&_ZN5S48C54v223Ev,
  (VTBL_ENTRY)&_ZN5S48C54v224Ev,
  (VTBL_ENTRY)&_ZN5S48C54v225Ev,
  (VTBL_ENTRY)&_ZN5S48C54v226Ev,
  (VTBL_ENTRY)&_ZN5S48C54v227Ev,
  (VTBL_ENTRY)&_ZN5S48C54v228Ev,
  (VTBL_ENTRY)&_ZN5S48C54v229Ev,
  (VTBL_ENTRY)&_ZN5S48C54v230Ev,
  (VTBL_ENTRY)&_ZN5S48C54v231Ev,
  (VTBL_ENTRY)&_ZN5S48C54v232Ev,
  (VTBL_ENTRY)&_ZN5S48C54v233Ev,
  (VTBL_ENTRY)&_ZN5S48C54v234Ev,
  (VTBL_ENTRY)&_ZN5S48C54v235Ev,
  (VTBL_ENTRY)&_ZN5S48C54v236Ev,
  (VTBL_ENTRY)&_ZN5S48C54v237Ev,
  (VTBL_ENTRY)&_ZN5S48C54v238Ev,
  (VTBL_ENTRY)&_ZN5S48C54v239Ev,
  (VTBL_ENTRY)&_ZN5S48C54v240Ev,
  (VTBL_ENTRY)&_ZN5S48C54v241Ev,
  (VTBL_ENTRY)&_ZN5S48C54v242Ev,
  (VTBL_ENTRY)&_ZN5S48C54v243Ev,
  (VTBL_ENTRY)&_ZN5S48C54v244Ev,
  (VTBL_ENTRY)&_ZN5S48C54v245Ev,
  (VTBL_ENTRY)&_ZN5S48C54v246Ev,
  (VTBL_ENTRY)&_ZN5S48C54v247Ev,
  (VTBL_ENTRY)&_ZN5S48C54v248Ev,
  (VTBL_ENTRY)&_ZN5S48C54v249Ev,
  (VTBL_ENTRY)&_ZN5S48C54v250Ev,
  (VTBL_ENTRY)&_ZN5S48C54v251Ev,
  (VTBL_ENTRY)&_ZN5S48C54v252Ev,
  (VTBL_ENTRY)&_ZN5S48C54v253Ev,
  (VTBL_ENTRY)&_ZN5S48C54v254Ev,
  (VTBL_ENTRY)&_ZN5S48C54v255Ev,
  (VTBL_ENTRY)&_ZN5S48C54v256Ev,
  (VTBL_ENTRY)&_ZN5S48C54v257Ev,
  (VTBL_ENTRY)&_ZN5S48C54v258Ev,
  (VTBL_ENTRY)&_ZN5S48C54v259Ev,
  (VTBL_ENTRY)&_ZN5S48C54v260Ev,
  (VTBL_ENTRY)&_ZN5S48C54v261Ev,
  (VTBL_ENTRY)&_ZN5S48C54v262Ev,
  (VTBL_ENTRY)&_ZN5S48C54v263Ev,
  (VTBL_ENTRY)&_ZN5S48C54v264Ev,
  (VTBL_ENTRY)&_ZN5S48C54v265Ev,
  (VTBL_ENTRY)&_ZN5S48C54v266Ev,
  (VTBL_ENTRY)&_ZN5S48C54v267Ev,
  (VTBL_ENTRY)&_ZN5S48C44v268Ev,
  (VTBL_ENTRY)&_ZN5S48C44v269Ev,
  (VTBL_ENTRY)&_ZN5S48C44v270Ev,
  (VTBL_ENTRY)&_ZN5S48C44v271Ev,
  (VTBL_ENTRY)&_ZN5S48C44v272Ev,
  (VTBL_ENTRY)&_ZN5S48C44v273Ev,
  (VTBL_ENTRY)&_ZN5S48C44v274Ev,
  (VTBL_ENTRY)&_ZN5S48C44v275Ev,
  (VTBL_ENTRY)&_ZN5S48C44v276Ev,
  (VTBL_ENTRY)&_ZN5S48C44v277Ev,
  (VTBL_ENTRY)&_ZN5S48C44v278Ev,
  (VTBL_ENTRY)&_ZN5S48C44v279Ev,
  (VTBL_ENTRY)&_ZN5S48C44v280Ev,
  (VTBL_ENTRY)&_ZN5S48C44v281Ev,
  (VTBL_ENTRY)&_ZN5S48C44v282Ev,
  (VTBL_ENTRY)&_ZN5S48C44v283Ev,
  (VTBL_ENTRY)&_ZN5S48C44v284Ev,
  (VTBL_ENTRY)&_ZN5S48C44v285Ev,
  (VTBL_ENTRY)&_ZN5S48C44v286Ev,
  (VTBL_ENTRY)&_ZN5S48C44v287Ev,
  (VTBL_ENTRY)&_ZN5S48C44v288Ev,
  (VTBL_ENTRY)&_ZN5S48C44v289Ev,
  (VTBL_ENTRY)&_ZN5S48C44v290Ev,
  (VTBL_ENTRY)&_ZN5S48C44v291Ev,
  (VTBL_ENTRY)&_ZN5S48C44v292Ev,
  (VTBL_ENTRY)&_ZN5S48C44v293Ev,
  (VTBL_ENTRY)&_ZN5S48C44v294Ev,
  (VTBL_ENTRY)&_ZN5S48C44v295Ev,
  (VTBL_ENTRY)&_ZN5S48C44v296Ev,
  (VTBL_ENTRY)&_ZN5S48C44v297Ev,
  (VTBL_ENTRY)&_ZN5S48C44v298Ev,
  (VTBL_ENTRY)&_ZN5S48C44v299Ev,
  (VTBL_ENTRY)&_ZN5S48C44v300Ev,
  (VTBL_ENTRY)&_ZN5S48C44v301Ev,
  (VTBL_ENTRY)&_ZN5S48C44v302Ev,
  (VTBL_ENTRY)&_ZN5S48C44v303Ev,
  (VTBL_ENTRY)&_ZN5S48C44v304Ev,
  (VTBL_ENTRY)&_ZN5S48C44v305Ev,
  (VTBL_ENTRY)&_ZN5S48C34v306Ev,
  (VTBL_ENTRY)&_ZN5S48C34v307Ev,
  (VTBL_ENTRY)&_ZN5S48C34v308Ev,
  (VTBL_ENTRY)&_ZN5S48C24v309Ev,
  (VTBL_ENTRY)&_ZN5S48C24v310Ev,
  (VTBL_ENTRY)&_ZN5S48C24v311Ev,
  (VTBL_ENTRY)&_ZN5S48C24v312Ev,
  (VTBL_ENTRY)&_ZN5S48C24v313Ev,
  (VTBL_ENTRY)&_ZN5S48C24v314Ev,
  (VTBL_ENTRY)&_ZN5S48C24v315Ev,
  (VTBL_ENTRY)&_ZN5S48C24v316Ev,
  (VTBL_ENTRY)&_ZN5S48C24v317Ev,
  (VTBL_ENTRY)&_ZN5S48C24v318Ev,
  (VTBL_ENTRY)&_ZN5S48C24v319Ev,
  (VTBL_ENTRY)&_ZN5S48C24v320Ev,
  (VTBL_ENTRY)&_ZN5S48C24v321Ev,
  (VTBL_ENTRY)&_ZN5S48C24v322Ev,
  (VTBL_ENTRY)&_ZN5S48C24v323Ev,
  (VTBL_ENTRY)&_ZN5S48C24v324Ev,
  (VTBL_ENTRY)&_ZN5S48C24v325Ev,
  (VTBL_ENTRY)&_ZN5S48C24v326Ev,
  (VTBL_ENTRY)&_ZN5S48C24v327Ev,
  (VTBL_ENTRY)&_ZN5S48C12v1Ev,
  (VTBL_ENTRY)&_ZN5S48C12v2Ev,
  (VTBL_ENTRY)&_ZN5S48C12v3Ev,
  (VTBL_ENTRY)&_ZN5S48C12v4Ev,
  (VTBL_ENTRY)&_ZN5S48C12v5Ev,
  (VTBL_ENTRY)&_ZN5S48C12v6Ev,
  (VTBL_ENTRY)&_ZN5S48C12v7Ev,
  (VTBL_ENTRY)&_ZN5S48C12v8Ev,
  (VTBL_ENTRY)&_ZN5S48C12v9Ev,
  (VTBL_ENTRY)&_ZN5S48C13v10Ev,
};
extern VTBL_ENTRY _ZTI5S48C1[];
extern  VTBL_ENTRY _ZTV5S48C1[];
Class_Descriptor cd_S48C1 = {  "S48C1", // class name
  bases_S48C1, 6,
  &(vtc_S48C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2520,1932), // object size
  NSPAIRA(_ZTI5S48C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S48C1),331, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S512C5  {
  int s512c5f0;
  __tsi64 s512c5f1;
  void *s512c5f2[4];
  int s512c5f3[2];
  void *s512c5f4;
  ::S28C9_nt s512c5f5;
  void *s512c5f6[2];
  virtual  ~S512C5(); // _ZN6S512C5D1Ev
  virtual void  v25(); // _ZN6S512C53v25Ev
  virtual void  v26(); // _ZN6S512C53v26Ev
  virtual void  v27(); // _ZN6S512C53v27Ev
  virtual void  v28(); // _ZN6S512C53v28Ev
  virtual void  v29(); // _ZN6S512C53v29Ev
  virtual void  v30(); // _ZN6S512C53v30Ev
  virtual void  v31(); // _ZN6S512C53v31Ev
  virtual void  v32(); // _ZN6S512C53v32Ev
  virtual void  v33(); // _ZN6S512C53v33Ev
  virtual void  v34(); // _ZN6S512C53v34Ev
  virtual void  v35(); // _ZN6S512C53v35Ev
  virtual void  v36(); // _ZN6S512C53v36Ev
  virtual void  v37(); // _ZN6S512C53v37Ev
  virtual void  v38(); // _ZN6S512C53v38Ev
  virtual void  v39(); // _ZN6S512C53v39Ev
  virtual void  v40(); // _ZN6S512C53v40Ev
  virtual void  v41(); // _ZN6S512C53v41Ev
  virtual void  v42(); // _ZN6S512C53v42Ev
  virtual void  v43(); // _ZN6S512C53v43Ev
  virtual void  v44(); // _ZN6S512C53v44Ev
  virtual void  v45(); // _ZN6S512C53v45Ev
  virtual void  v46(); // _ZN6S512C53v46Ev
  virtual void  v47(); // _ZN6S512C53v47Ev
  virtual void  v48(); // _ZN6S512C53v48Ev
  virtual void  v49(); // _ZN6S512C53v49Ev
  virtual void  v50(); // _ZN6S512C53v50Ev
  virtual void  v51(); // _ZN6S512C53v51Ev
  virtual void  v52(); // _ZN6S512C53v52Ev
  virtual void  v53(); // _ZN6S512C53v53Ev
  virtual void  v54(); // _ZN6S512C53v54Ev
  virtual void  v55(); // _ZN6S512C53v55Ev
  virtual void  v56(); // _ZN6S512C53v56Ev
  virtual void  v57(); // _ZN6S512C53v57Ev
  virtual void  v58(); // _ZN6S512C53v58Ev
  virtual void  v59(); // _ZN6S512C53v59Ev
  virtual void  v60(); // _ZN6S512C53v60Ev
  virtual void  v61(); // _ZN6S512C53v61Ev
  virtual void  v62(); // _ZN6S512C53v62Ev
  virtual void  v63(); // _ZN6S512C53v63Ev
  virtual void  v64(); // _ZN6S512C53v64Ev
  virtual void  v65(); // _ZN6S512C53v65Ev
  virtual void  v66(); // _ZN6S512C53v66Ev
  virtual void  v67(); // _ZN6S512C53v67Ev
  virtual void  v68(); // _ZN6S512C53v68Ev
  virtual void  v69(); // _ZN6S512C53v69Ev
  virtual void  v70(); // _ZN6S512C53v70Ev
  virtual void  v71(); // _ZN6S512C53v71Ev
  virtual void  v72(); // _ZN6S512C53v72Ev
  virtual void  v73(); // _ZN6S512C53v73Ev
  virtual void  v74(); // _ZN6S512C53v74Ev
  virtual void  v75(); // _ZN6S512C53v75Ev
  virtual void  v76(); // _ZN6S512C53v76Ev
  virtual void  v77(); // _ZN6S512C53v77Ev
  virtual void  v78(); // _ZN6S512C53v78Ev
  virtual void  v79(); // _ZN6S512C53v79Ev
  virtual void  v80(); // _ZN6S512C53v80Ev
  virtual void  v81(); // _ZN6S512C53v81Ev
  virtual void  v82(); // _ZN6S512C53v82Ev
  virtual void  v83(); // _ZN6S512C53v83Ev
  virtual void  v84(); // _ZN6S512C53v84Ev
  virtual void  v85(); // _ZN6S512C53v85Ev
  virtual void  v86(); // _ZN6S512C53v86Ev
  virtual void  v87(); // _ZN6S512C53v87Ev
  virtual void  v88(); // _ZN6S512C53v88Ev
  S512C5(); // tgen
};
//SIG(-1 S512C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S512C5 ::~S512C5(){ note_dtor("S512C5", this);}
void  S512C5 ::v25(){vfunc_called(this, "_ZN6S512C53v25Ev");}
void  S512C5 ::v26(){vfunc_called(this, "_ZN6S512C53v26Ev");}
void  S512C5 ::v27(){vfunc_called(this, "_ZN6S512C53v27Ev");}
void  S512C5 ::v28(){vfunc_called(this, "_ZN6S512C53v28Ev");}
void  S512C5 ::v29(){vfunc_called(this, "_ZN6S512C53v29Ev");}
void  S512C5 ::v30(){vfunc_called(this, "_ZN6S512C53v30Ev");}
void  S512C5 ::v31(){vfunc_called(this, "_ZN6S512C53v31Ev");}
void  S512C5 ::v32(){vfunc_called(this, "_ZN6S512C53v32Ev");}
void  S512C5 ::v33(){vfunc_called(this, "_ZN6S512C53v33Ev");}
void  S512C5 ::v34(){vfunc_called(this, "_ZN6S512C53v34Ev");}
void  S512C5 ::v35(){vfunc_called(this, "_ZN6S512C53v35Ev");}
void  S512C5 ::v36(){vfunc_called(this, "_ZN6S512C53v36Ev");}
void  S512C5 ::v37(){vfunc_called(this, "_ZN6S512C53v37Ev");}
void  S512C5 ::v38(){vfunc_called(this, "_ZN6S512C53v38Ev");}
void  S512C5 ::v39(){vfunc_called(this, "_ZN6S512C53v39Ev");}
void  S512C5 ::v40(){vfunc_called(this, "_ZN6S512C53v40Ev");}
void  S512C5 ::v41(){vfunc_called(this, "_ZN6S512C53v41Ev");}
void  S512C5 ::v42(){vfunc_called(this, "_ZN6S512C53v42Ev");}
void  S512C5 ::v43(){vfunc_called(this, "_ZN6S512C53v43Ev");}
void  S512C5 ::v44(){vfunc_called(this, "_ZN6S512C53v44Ev");}
void  S512C5 ::v45(){vfunc_called(this, "_ZN6S512C53v45Ev");}
void  S512C5 ::v46(){vfunc_called(this, "_ZN6S512C53v46Ev");}
void  S512C5 ::v47(){vfunc_called(this, "_ZN6S512C53v47Ev");}
void  S512C5 ::v48(){vfunc_called(this, "_ZN6S512C53v48Ev");}
void  S512C5 ::v49(){vfunc_called(this, "_ZN6S512C53v49Ev");}
void  S512C5 ::v50(){vfunc_called(this, "_ZN6S512C53v50Ev");}
void  S512C5 ::v51(){vfunc_called(this, "_ZN6S512C53v51Ev");}
void  S512C5 ::v52(){vfunc_called(this, "_ZN6S512C53v52Ev");}
void  S512C5 ::v53(){vfunc_called(this, "_ZN6S512C53v53Ev");}
void  S512C5 ::v54(){vfunc_called(this, "_ZN6S512C53v54Ev");}
void  S512C5 ::v55(){vfunc_called(this, "_ZN6S512C53v55Ev");}
void  S512C5 ::v56(){vfunc_called(this, "_ZN6S512C53v56Ev");}
void  S512C5 ::v57(){vfunc_called(this, "_ZN6S512C53v57Ev");}
void  S512C5 ::v58(){vfunc_called(this, "_ZN6S512C53v58Ev");}
void  S512C5 ::v59(){vfunc_called(this, "_ZN6S512C53v59Ev");}
void  S512C5 ::v60(){vfunc_called(this, "_ZN6S512C53v60Ev");}
void  S512C5 ::v61(){vfunc_called(this, "_ZN6S512C53v61Ev");}
void  S512C5 ::v62(){vfunc_called(this, "_ZN6S512C53v62Ev");}
void  S512C5 ::v63(){vfunc_called(this, "_ZN6S512C53v63Ev");}
void  S512C5 ::v64(){vfunc_called(this, "_ZN6S512C53v64Ev");}
void  S512C5 ::v65(){vfunc_called(this, "_ZN6S512C53v65Ev");}
void  S512C5 ::v66(){vfunc_called(this, "_ZN6S512C53v66Ev");}
void  S512C5 ::v67(){vfunc_called(this, "_ZN6S512C53v67Ev");}
void  S512C5 ::v68(){vfunc_called(this, "_ZN6S512C53v68Ev");}
void  S512C5 ::v69(){vfunc_called(this, "_ZN6S512C53v69Ev");}
void  S512C5 ::v70(){vfunc_called(this, "_ZN6S512C53v70Ev");}
void  S512C5 ::v71(){vfunc_called(this, "_ZN6S512C53v71Ev");}
void  S512C5 ::v72(){vfunc_called(this, "_ZN6S512C53v72Ev");}
void  S512C5 ::v73(){vfunc_called(this, "_ZN6S512C53v73Ev");}
void  S512C5 ::v74(){vfunc_called(this, "_ZN6S512C53v74Ev");}
void  S512C5 ::v75(){vfunc_called(this, "_ZN6S512C53v75Ev");}
void  S512C5 ::v76(){vfunc_called(this, "_ZN6S512C53v76Ev");}
void  S512C5 ::v77(){vfunc_called(this, "_ZN6S512C53v77Ev");}
void  S512C5 ::v78(){vfunc_called(this, "_ZN6S512C53v78Ev");}
void  S512C5 ::v79(){vfunc_called(this, "_ZN6S512C53v79Ev");}
void  S512C5 ::v80(){vfunc_called(this, "_ZN6S512C53v80Ev");}
void  S512C5 ::v81(){vfunc_called(this, "_ZN6S512C53v81Ev");}
void  S512C5 ::v82(){vfunc_called(this, "_ZN6S512C53v82Ev");}
void  S512C5 ::v83(){vfunc_called(this, "_ZN6S512C53v83Ev");}
void  S512C5 ::v84(){vfunc_called(this, "_ZN6S512C53v84Ev");}
void  S512C5 ::v85(){vfunc_called(this, "_ZN6S512C53v85Ev");}
void  S512C5 ::v86(){vfunc_called(this, "_ZN6S512C53v86Ev");}
void  S512C5 ::v87(){vfunc_called(this, "_ZN6S512C53v87Ev");}
void  S512C5 ::v88(){vfunc_called(this, "_ZN6S512C53v88Ev");}
S512C5 ::S512C5(){ note_ctor("S512C5", this);} // tgen

static void Test_S512C5()
{
  extern Class_Descriptor cd_S512C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S512C5, buf);
    S512C5 *dp, &lv = *(dp=new (buf) S512C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S512C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S512C5)");
    check_field_offset(lv, s512c5f0, ABISELECT(8,4), "S512C5.s512c5f0");
    check_field_offset(lv, s512c5f1, ABISELECT(16,8), "S512C5.s512c5f1");
    check_field_offset(lv, s512c5f2, ABISELECT(24,16), "S512C5.s512c5f2");
    check_field_offset(lv, s512c5f3, ABISELECT(56,32), "S512C5.s512c5f3");
    check_field_offset(lv, s512c5f4, ABISELECT(64,40), "S512C5.s512c5f4");
    check_field_offset(lv, s512c5f5, ABISELECT(72,44), "S512C5.s512c5f5");
    check_field_offset(lv, s512c5f6, ABISELECT(80,52), "S512C5.s512c5f6");
    test_class_info(&lv, &cd_S512C5);
    dp->~S512C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS512C5(Test_S512C5, "S512C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S512C5C1Ev();
extern void _ZN6S512C5D1Ev();
Name_Map name_map_S512C5[] = {
  NSPAIR(_ZN6S512C5C1Ev),
  NSPAIR(_ZN6S512C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S512C5[];
extern void _ZN6S512C5D1Ev();
extern void _ZN6S512C5D0Ev();
extern void _ZN6S512C53v25Ev();
extern void _ZN6S512C53v26Ev();
extern void _ZN6S512C53v27Ev();
extern void _ZN6S512C53v28Ev();
extern void _ZN6S512C53v29Ev();
extern void _ZN6S512C53v30Ev();
extern void _ZN6S512C53v31Ev();
extern void _ZN6S512C53v32Ev();
extern void _ZN6S512C53v33Ev();
extern void _ZN6S512C53v34Ev();
extern void _ZN6S512C53v35Ev();
extern void _ZN6S512C53v36Ev();
extern void _ZN6S512C53v37Ev();
extern void _ZN6S512C53v38Ev();
extern void _ZN6S512C53v39Ev();
extern void _ZN6S512C53v40Ev();
extern void _ZN6S512C53v41Ev();
extern void _ZN6S512C53v42Ev();
extern void _ZN6S512C53v43Ev();
extern void _ZN6S512C53v44Ev();
extern void _ZN6S512C53v45Ev();
extern void _ZN6S512C53v46Ev();
extern void _ZN6S512C53v47Ev();
extern void _ZN6S512C53v48Ev();
extern void _ZN6S512C53v49Ev();
extern void _ZN6S512C53v50Ev();
extern void _ZN6S512C53v51Ev();
extern void _ZN6S512C53v52Ev();
extern void _ZN6S512C53v53Ev();
extern void _ZN6S512C53v54Ev();
extern void _ZN6S512C53v55Ev();
extern void _ZN6S512C53v56Ev();
extern void _ZN6S512C53v57Ev();
extern void _ZN6S512C53v58Ev();
extern void _ZN6S512C53v59Ev();
extern void _ZN6S512C53v60Ev();
extern void _ZN6S512C53v61Ev();
extern void _ZN6S512C53v62Ev();
extern void _ZN6S512C53v63Ev();
extern void _ZN6S512C53v64Ev();
extern void _ZN6S512C53v65Ev();
extern void _ZN6S512C53v66Ev();
extern void _ZN6S512C53v67Ev();
extern void _ZN6S512C53v68Ev();
extern void _ZN6S512C53v69Ev();
extern void _ZN6S512C53v70Ev();
extern void _ZN6S512C53v71Ev();
extern void _ZN6S512C53v72Ev();
extern void _ZN6S512C53v73Ev();
extern void _ZN6S512C53v74Ev();
extern void _ZN6S512C53v75Ev();
extern void _ZN6S512C53v76Ev();
extern void _ZN6S512C53v77Ev();
extern void _ZN6S512C53v78Ev();
extern void _ZN6S512C53v79Ev();
extern void _ZN6S512C53v80Ev();
extern void _ZN6S512C53v81Ev();
extern void _ZN6S512C53v82Ev();
extern void _ZN6S512C53v83Ev();
extern void _ZN6S512C53v84Ev();
extern void _ZN6S512C53v85Ev();
extern void _ZN6S512C53v86Ev();
extern void _ZN6S512C53v87Ev();
extern void _ZN6S512C53v88Ev();
static  VTBL_ENTRY vtc_S512C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S512C5[0]),
  (VTBL_ENTRY)&_ZN6S512C5D1Ev,
  (VTBL_ENTRY)&_ZN6S512C5D0Ev,
  (VTBL_ENTRY)&_ZN6S512C53v25Ev,
  (VTBL_ENTRY)&_ZN6S512C53v26Ev,
  (VTBL_ENTRY)&_ZN6S512C53v27Ev,
  (VTBL_ENTRY)&_ZN6S512C53v28Ev,
  (VTBL_ENTRY)&_ZN6S512C53v29Ev,
  (VTBL_ENTRY)&_ZN6S512C53v30Ev,
  (VTBL_ENTRY)&_ZN6S512C53v31Ev,
  (VTBL_ENTRY)&_ZN6S512C53v32Ev,
  (VTBL_ENTRY)&_ZN6S512C53v33Ev,
  (VTBL_ENTRY)&_ZN6S512C53v34Ev,
  (VTBL_ENTRY)&_ZN6S512C53v35Ev,
  (VTBL_ENTRY)&_ZN6S512C53v36Ev,
  (VTBL_ENTRY)&_ZN6S512C53v37Ev,
  (VTBL_ENTRY)&_ZN6S512C53v38Ev,
  (VTBL_ENTRY)&_ZN6S512C53v39Ev,
  (VTBL_ENTRY)&_ZN6S512C53v40Ev,
  (VTBL_ENTRY)&_ZN6S512C53v41Ev,
  (VTBL_ENTRY)&_ZN6S512C53v42Ev,
  (VTBL_ENTRY)&_ZN6S512C53v43Ev,
  (VTBL_ENTRY)&_ZN6S512C53v44Ev,
  (VTBL_ENTRY)&_ZN6S512C53v45Ev,
  (VTBL_ENTRY)&_ZN6S512C53v46Ev,
  (VTBL_ENTRY)&_ZN6S512C53v47Ev,
  (VTBL_ENTRY)&_ZN6S512C53v48Ev,
  (VTBL_ENTRY)&_ZN6S512C53v49Ev,
  (VTBL_ENTRY)&_ZN6S512C53v50Ev,
  (VTBL_ENTRY)&_ZN6S512C53v51Ev,
  (VTBL_ENTRY)&_ZN6S512C53v52Ev,
  (VTBL_ENTRY)&_ZN6S512C53v53Ev,
  (VTBL_ENTRY)&_ZN6S512C53v54Ev,
  (VTBL_ENTRY)&_ZN6S512C53v55Ev,
  (VTBL_ENTRY)&_ZN6S512C53v56Ev,
  (VTBL_ENTRY)&_ZN6S512C53v57Ev,
  (VTBL_ENTRY)&_ZN6S512C53v58Ev,
  (VTBL_ENTRY)&_ZN6S512C53v59Ev,
  (VTBL_ENTRY)&_ZN6S512C53v60Ev,
  (VTBL_ENTRY)&_ZN6S512C53v61Ev,
  (VTBL_ENTRY)&_ZN6S512C53v62Ev,
  (VTBL_ENTRY)&_ZN6S512C53v63Ev,
  (VTBL_ENTRY)&_ZN6S512C53v64Ev,
  (VTBL_ENTRY)&_ZN6S512C53v65Ev,
  (VTBL_ENTRY)&_ZN6S512C53v66Ev,
  (VTBL_ENTRY)&_ZN6S512C53v67Ev,
  (VTBL_ENTRY)&_ZN6S512C53v68Ev,
  (VTBL_ENTRY)&_ZN6S512C53v69Ev,
  (VTBL_ENTRY)&_ZN6S512C53v70Ev,
  (VTBL_ENTRY)&_ZN6S512C53v71Ev,
  (VTBL_ENTRY)&_ZN6S512C53v72Ev,
  (VTBL_ENTRY)&_ZN6S512C53v73Ev,
  (VTBL_ENTRY)&_ZN6S512C53v74Ev,
  (VTBL_ENTRY)&_ZN6S512C53v75Ev,
  (VTBL_ENTRY)&_ZN6S512C53v76Ev,
  (VTBL_ENTRY)&_ZN6S512C53v77Ev,
  (VTBL_ENTRY)&_ZN6S512C53v78Ev,
  (VTBL_ENTRY)&_ZN6S512C53v79Ev,
  (VTBL_ENTRY)&_ZN6S512C53v80Ev,
  (VTBL_ENTRY)&_ZN6S512C53v81Ev,
  (VTBL_ENTRY)&_ZN6S512C53v82Ev,
  (VTBL_ENTRY)&_ZN6S512C53v83Ev,
  (VTBL_ENTRY)&_ZN6S512C53v84Ev,
  (VTBL_ENTRY)&_ZN6S512C53v85Ev,
  (VTBL_ENTRY)&_ZN6S512C53v86Ev,
  (VTBL_ENTRY)&_ZN6S512C53v87Ev,
  (VTBL_ENTRY)&_ZN6S512C53v88Ev,
};
extern VTBL_ENTRY _ZTI6S512C5[];
extern  VTBL_ENTRY _ZTV6S512C5[];
Class_Descriptor cd_S512C5 = {  "S512C5", // class name
  0,0,//no base classes
  &(vtc_S512C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S512C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S512C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S512C4  : S512C5 {
  ::S48C54 s512c4f0;
  ::S48C54 s512c4f1;
  ::S28C13_nt s512c4f2;
  int s512c4f3;
  char s512c4f4[4];
  void *s512c4f5[2];
  ::S48C47 s512c4f6;
  unsigned int s512c4f7:1;
  unsigned int s512c4f8:1;
  unsigned int s512c4f9:1;
  unsigned int s512c4f10:1;
  unsigned int s512c4f11:1;
  unsigned int s512c4f12:1;
  unsigned int s512c4f13:1;
  unsigned int s512c4f14:1;
  unsigned int s512c4f15:1;
  unsigned int s512c4f16:1;
  unsigned int s512c4f17:1;
  unsigned int s512c4f18:1;
  unsigned int s512c4f19:1;
  unsigned int s512c4f20:1;
  unsigned int s512c4f21:1;
  unsigned int s512c4f22:1;
  unsigned int s512c4f23:1;
  unsigned int s512c4f24:1;
  unsigned int s512c4f25:1;
  unsigned int s512c4f26:1;
  unsigned int s512c4f27:1;
  unsigned int s512c4f28:1;
  unsigned int s512c4f29:1;
  unsigned int s512c4f30:1;
  unsigned int s512c4f31:1;
  unsigned int s512c4f32:1;
  unsigned int s512c4f33:1;
  unsigned int s512c4f34:1;
  unsigned int s512c4f35:1;
  unsigned int s512c4f36:1;
  unsigned int s512c4f37:1;
  unsigned int s512c4f38:1;
  unsigned int s512c4f39:1;
  unsigned int s512c4f40:1;
  unsigned int s512c4f41:1;
  unsigned int s512c4f42:1;
  unsigned int s512c4f43:1;
  unsigned int s512c4f44:1;
  unsigned int s512c4f45:1;
  unsigned int s512c4f46:1;
  unsigned int s512c4f47:1;
  unsigned int s512c4f48:1;
  unsigned int s512c4f49:1;
  unsigned int s512c4f50:1;
  unsigned int s512c4f51:1;
  unsigned int s512c4f52:1;
  unsigned int s512c4f53:1;
  unsigned int s512c4f54:1;
  unsigned int s512c4f55:1;
  unsigned int s512c4f56:1;
  unsigned int s512c4f57:1;
  unsigned int s512c4f58:1;
  unsigned int s512c4f59:1;
  unsigned int s512c4f60:1;
  unsigned int s512c4f61:1;
  unsigned int s512c4f62:1;
  unsigned int s512c4f63:1;
  unsigned int s512c4f64:1;
  unsigned int s512c4f65:1;
  unsigned int s512c4f66:1;
  unsigned int s512c4f67:1;
  unsigned int s512c4f68:1;
  unsigned int s512c4f69:1;
  unsigned int s512c4f70:1;
  unsigned int s512c4f71:1;
  unsigned int s512c4f72:1;
  unsigned int s512c4f73:1;
  unsigned int s512c4f74:1;
  unsigned int s512c4f75:1;
  unsigned int s512c4f76:1;
  unsigned int s512c4f77:1;
  unsigned int s512c4f78:1;
  unsigned int s512c4f79:1;
  unsigned int s512c4f80:1;
  unsigned int s512c4f81:1;
  unsigned int s512c4f82:1;
  unsigned int s512c4f83:1;
  int s512c4f84[5];
  void *s512c4f85[2];
  int s512c4f86[3];
  ::S28C9_nt s512c4f87;
  ::S28C9_nt s512c4f88;
  ::S28C9_nt s512c4f89;
  ::S48C43 s512c4f90;
  ::S48C43 s512c4f91;
  int s512c4f92;
  void *s512c4f93[2];
  ::S48C18 s512c4f94;
  ::S28C18_nt s512c4f95;
  ::S48C18 s512c4f96;
  ::S48C18 s512c4f97;
  void *s512c4f98;
  ::S28C9_nt s512c4f99;
  ::S48C43 s512c4f100;
  ::S48C18 s512c4f101;
  ::S28C18_nt s512c4f102;
  int s512c4f103;
  ::S48C18 s512c4f104;
  ::S48C18 s512c4f105;
  void *s512c4f106;
  int s512c4f107;
  char s512c4f108;
  ::S28C18_nt s512c4f109;
  ::S28C18_nt s512c4f110;
  void *s512c4f111;
  int s512c4f112;
  void *s512c4f113;
  ::S48C39 s512c4f114;
  ::S28C55 s512c4f115;
  ::S28C48 s512c4f116;
  virtual  ~S512C4(); // _ZN6S512C4D1Ev
  virtual void  v89(); // _ZN6S512C43v89Ev
  virtual void  v90(); // _ZN6S512C43v90Ev
  virtual void  v91(); // _ZN6S512C43v91Ev
  virtual void  v92(); // _ZN6S512C43v92Ev
  virtual void  v93(); // _ZN6S512C43v93Ev
  virtual void  v94(); // _ZN6S512C43v94Ev
  virtual void  v95(); // _ZN6S512C43v95Ev
  virtual void  v96(); // _ZN6S512C43v96Ev
  virtual void  v97(); // _ZN6S512C43v97Ev
  virtual void  v98(); // _ZN6S512C43v98Ev
  virtual void  v99(); // _ZN6S512C43v99Ev
  virtual void  v100(); // _ZN6S512C44v100Ev
  virtual void  v101(); // _ZN6S512C44v101Ev
  virtual void  v102(); // _ZN6S512C44v102Ev
  virtual void  v103(); // _ZN6S512C44v103Ev
  virtual void  v104(); // _ZN6S512C44v104Ev
  virtual void  v105(); // _ZN6S512C44v105Ev
  virtual void  v106(); // _ZN6S512C44v106Ev
  virtual void  v107(); // _ZN6S512C44v107Ev
  virtual void  v108(); // _ZN6S512C44v108Ev
  virtual void  v109(); // _ZN6S512C44v109Ev
  virtual void  v110(); // _ZN6S512C44v110Ev
  virtual void  v111(); // _ZN6S512C44v111Ev
  virtual void  v112(); // _ZN6S512C44v112Ev
  virtual void  v113(); // _ZN6S512C44v113Ev
  virtual void  v114(); // _ZN6S512C44v114Ev
  virtual void  v115(); // _ZN6S512C44v115Ev
  virtual void  v116(); // _ZN6S512C44v116Ev
  virtual void  v117(); // _ZN6S512C44v117Ev
  virtual void  v118(); // _ZN6S512C44v118Ev
  virtual void  v119(); // _ZN6S512C44v119Ev
  virtual void  v120(); // _ZN6S512C44v120Ev
  virtual void  v121(); // _ZN6S512C44v121Ev
  virtual void  v122(); // _ZN6S512C44v122Ev
  virtual void  v123(); // _ZN6S512C44v123Ev
  virtual void  v124(); // _ZN6S512C44v124Ev
  virtual void  v125(); // _ZN6S512C44v125Ev
  virtual void  v126(); // _ZN6S512C44v126Ev
  virtual void  v127(); // _ZN6S512C44v127Ev
  virtual void  v128(); // _ZN6S512C44v128Ev
  virtual void  v129(); // _ZN6S512C44v129Ev
  virtual void  v130(); // _ZN6S512C44v130Ev
  virtual void  v131(); // _ZN6S512C44v131Ev
  virtual void  v132(); // _ZN6S512C44v132Ev
  virtual void  v133(); // _ZN6S512C44v133Ev
  virtual void  v134(); // _ZN6S512C44v134Ev
  virtual void  v135(); // _ZN6S512C44v135Ev
  virtual void  v136(); // _ZN6S512C44v136Ev
  virtual void  v137(); // _ZN6S512C44v137Ev
  virtual void  v138(); // _ZN6S512C44v138Ev
  virtual void  v139(); // _ZN6S512C44v139Ev
  virtual void  v140(); // _ZN6S512C44v140Ev
  virtual void  v141(); // _ZN6S512C44v141Ev
  virtual void  v142(); // _ZN6S512C44v142Ev
  virtual void  v143(); // _ZN6S512C44v143Ev
  virtual void  v144(); // _ZN6S512C44v144Ev
  virtual void  v145(); // _ZN6S512C44v145Ev
  virtual void  v146(); // _ZN6S512C44v146Ev
  virtual void  v147(); // _ZN6S512C44v147Ev
  virtual void  v148(); // _ZN6S512C44v148Ev
  virtual void  v149(); // _ZN6S512C44v149Ev
  virtual void  v150(); // _ZN6S512C44v150Ev
  virtual void  v151(); // _ZN6S512C44v151Ev
  virtual void  v152(); // _ZN6S512C44v152Ev
  virtual void  v153(); // _ZN6S512C44v153Ev
  virtual void  v154(); // _ZN6S512C44v154Ev
  virtual void  v155(); // _ZN6S512C44v155Ev
  virtual void  v156(); // _ZN6S512C44v156Ev
  virtual void  v157(); // _ZN6S512C44v157Ev
  virtual void  v158(); // _ZN6S512C44v158Ev
  virtual void  v159(); // _ZN6S512C44v159Ev
  virtual void  v160(); // _ZN6S512C44v160Ev
  virtual void  v161(); // _ZN6S512C44v161Ev
  virtual void  v162(); // _ZN6S512C44v162Ev
  virtual void  v163(); // _ZN6S512C44v163Ev
  virtual void  v164(); // _ZN6S512C44v164Ev
  virtual void  v165(); // _ZN6S512C44v165Ev
  virtual void  v166(); // _ZN6S512C44v166Ev
  virtual void  v167(); // _ZN6S512C44v167Ev
  virtual void  v168(); // _ZN6S512C44v168Ev
  virtual void  v169(); // _ZN6S512C44v169Ev
  virtual void  v170(); // _ZN6S512C44v170Ev
  virtual void  v171(); // _ZN6S512C44v171Ev
  virtual void  v172(); // _ZN6S512C44v172Ev
  virtual void  v173(); // _ZN6S512C44v173Ev
  virtual void  v174(); // _ZN6S512C44v174Ev
  virtual void  v175(); // _ZN6S512C44v175Ev
  virtual void  v176(); // _ZN6S512C44v176Ev
  virtual void  v177(); // _ZN6S512C44v177Ev
  virtual void  v178(); // _ZN6S512C44v178Ev
  virtual void  v179(); // _ZN6S512C44v179Ev
  virtual void  v180(); // _ZN6S512C44v180Ev
  virtual void  v181(); // _ZN6S512C44v181Ev
  virtual void  v182(); // _ZN6S512C44v182Ev
  virtual void  v183(); // _ZN6S512C44v183Ev
  virtual void  v184(); // _ZN6S512C44v184Ev
  virtual void  v185(); // _ZN6S512C44v185Ev
  virtual void  v186(); // _ZN6S512C44v186Ev
  virtual void  v187(); // _ZN6S512C44v187Ev
  virtual void  v188(); // _ZN6S512C44v188Ev
  virtual void  v189(); // _ZN6S512C44v189Ev
  virtual void  v190(); // _ZN6S512C44v190Ev
  virtual void  v191(); // _ZN6S512C44v191Ev
  virtual void  v192(); // _ZN6S512C44v192Ev
  virtual void  v193(); // _ZN6S512C44v193Ev
  virtual void  v194(); // _ZN6S512C44v194Ev
  virtual void  v195(); // _ZN6S512C44v195Ev
  virtual void  v196(); // _ZN6S512C44v196Ev
  virtual void  v197(); // _ZN6S512C44v197Ev
  virtual void  v198(); // _ZN6S512C44v198Ev
  virtual void  v199(); // _ZN6S512C44v199Ev
  virtual void  v200(); // _ZN6S512C44v200Ev
  virtual void  v201(); // _ZN6S512C44v201Ev
  virtual void  v202(); // _ZN6S512C44v202Ev
  virtual void  v203(); // _ZN6S512C44v203Ev
  virtual void  v204(); // _ZN6S512C44v204Ev
  virtual void  v205(); // _ZN6S512C44v205Ev
  virtual void  v206(); // _ZN6S512C44v206Ev
  virtual void  v207(); // _ZN6S512C44v207Ev
  virtual void  v208(); // _ZN6S512C44v208Ev
  virtual void  v209(); // _ZN6S512C44v209Ev
  virtual void  v210(); // _ZN6S512C44v210Ev
  virtual void  v211(); // _ZN6S512C44v211Ev
  virtual void  v212(); // _ZN6S512C44v212Ev
  virtual void  v213(); // _ZN6S512C44v213Ev
  virtual void  v214(); // _ZN6S512C44v214Ev
  virtual void  v215(); // _ZN6S512C44v215Ev
  virtual void  v216(); // _ZN6S512C44v216Ev
  virtual void  v217(); // _ZN6S512C44v217Ev
  virtual void  v218(); // _ZN6S512C44v218Ev
  virtual void  v219(); // _ZN6S512C44v219Ev
  virtual void  v220(); // _ZN6S512C44v220Ev
  virtual void  v221(); // _ZN6S512C44v221Ev
  virtual void  v222(); // _ZN6S512C44v222Ev
  virtual void  v223(); // _ZN6S512C44v223Ev
  virtual void  v224(); // _ZN6S512C44v224Ev
  virtual void  v225(); // _ZN6S512C44v225Ev
  virtual void  v226(); // _ZN6S512C44v226Ev
  virtual void  v227(); // _ZN6S512C44v227Ev
  virtual void  v228(); // _ZN6S512C44v228Ev
  virtual void  v229(); // _ZN6S512C44v229Ev
  virtual void  v230(); // _ZN6S512C44v230Ev
  virtual void  v231(); // _ZN6S512C44v231Ev
  S512C4(); // tgen
};
//SIG(-1 S512C4) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC8{ BC9{ BC6}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC10{ BC11{ BC6}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC13{ m Fi[3]} FC12 FC12 Fp FC3 FC10 FC12 FC13 Fi FC12 FC12 Fp Fi Fc FC13 FC13 Fp Fi Fp FC14{ BC15{ BC6}} FC16{ BC17{ BC6}} FC18{ BC19{ BC6}}}


 S512C4 ::~S512C4(){ note_dtor("S512C4", this);}
void  S512C4 ::v89(){vfunc_called(this, "_ZN6S512C43v89Ev");}
void  S512C4 ::v90(){vfunc_called(this, "_ZN6S512C43v90Ev");}
void  S512C4 ::v91(){vfunc_called(this, "_ZN6S512C43v91Ev");}
void  S512C4 ::v92(){vfunc_called(this, "_ZN6S512C43v92Ev");}
void  S512C4 ::v93(){vfunc_called(this, "_ZN6S512C43v93Ev");}
void  S512C4 ::v94(){vfunc_called(this, "_ZN6S512C43v94Ev");}
void  S512C4 ::v95(){vfunc_called(this, "_ZN6S512C43v95Ev");}
void  S512C4 ::v96(){vfunc_called(this, "_ZN6S512C43v96Ev");}
void  S512C4 ::v97(){vfunc_called(this, "_ZN6S512C43v97Ev");}
void  S512C4 ::v98(){vfunc_called(this, "_ZN6S512C43v98Ev");}
void  S512C4 ::v99(){vfunc_called(this, "_ZN6S512C43v99Ev");}
void  S512C4 ::v100(){vfunc_called(this, "_ZN6S512C44v100Ev");}
void  S512C4 ::v101(){vfunc_called(this, "_ZN6S512C44v101Ev");}
void  S512C4 ::v102(){vfunc_called(this, "_ZN6S512C44v102Ev");}
void  S512C4 ::v103(){vfunc_called(this, "_ZN6S512C44v103Ev");}
void  S512C4 ::v104(){vfunc_called(this, "_ZN6S512C44v104Ev");}
void  S512C4 ::v105(){vfunc_called(this, "_ZN6S512C44v105Ev");}
void  S512C4 ::v106(){vfunc_called(this, "_ZN6S512C44v106Ev");}
void  S512C4 ::v107(){vfunc_called(this, "_ZN6S512C44v107Ev");}
void  S512C4 ::v108(){vfunc_called(this, "_ZN6S512C44v108Ev");}
void  S512C4 ::v109(){vfunc_called(this, "_ZN6S512C44v109Ev");}
void  S512C4 ::v110(){vfunc_called(this, "_ZN6S512C44v110Ev");}
void  S512C4 ::v111(){vfunc_called(this, "_ZN6S512C44v111Ev");}
void  S512C4 ::v112(){vfunc_called(this, "_ZN6S512C44v112Ev");}
void  S512C4 ::v113(){vfunc_called(this, "_ZN6S512C44v113Ev");}
void  S512C4 ::v114(){vfunc_called(this, "_ZN6S512C44v114Ev");}
void  S512C4 ::v115(){vfunc_called(this, "_ZN6S512C44v115Ev");}
void  S512C4 ::v116(){vfunc_called(this, "_ZN6S512C44v116Ev");}
void  S512C4 ::v117(){vfunc_called(this, "_ZN6S512C44v117Ev");}
void  S512C4 ::v118(){vfunc_called(this, "_ZN6S512C44v118Ev");}
void  S512C4 ::v119(){vfunc_called(this, "_ZN6S512C44v119Ev");}
void  S512C4 ::v120(){vfunc_called(this, "_ZN6S512C44v120Ev");}
void  S512C4 ::v121(){vfunc_called(this, "_ZN6S512C44v121Ev");}
void  S512C4 ::v122(){vfunc_called(this, "_ZN6S512C44v122Ev");}
void  S512C4 ::v123(){vfunc_called(this, "_ZN6S512C44v123Ev");}
void  S512C4 ::v124(){vfunc_called(this, "_ZN6S512C44v124Ev");}
void  S512C4 ::v125(){vfunc_called(this, "_ZN6S512C44v125Ev");}
void  S512C4 ::v126(){vfunc_called(this, "_ZN6S512C44v126Ev");}
void  S512C4 ::v127(){vfunc_called(this, "_ZN6S512C44v127Ev");}
void  S512C4 ::v128(){vfunc_called(this, "_ZN6S512C44v128Ev");}
void  S512C4 ::v129(){vfunc_called(this, "_ZN6S512C44v129Ev");}
void  S512C4 ::v130(){vfunc_called(this, "_ZN6S512C44v130Ev");}
void  S512C4 ::v131(){vfunc_called(this, "_ZN6S512C44v131Ev");}
void  S512C4 ::v132(){vfunc_called(this, "_ZN6S512C44v132Ev");}
void  S512C4 ::v133(){vfunc_called(this, "_ZN6S512C44v133Ev");}
void  S512C4 ::v134(){vfunc_called(this, "_ZN6S512C44v134Ev");}
void  S512C4 ::v135(){vfunc_called(this, "_ZN6S512C44v135Ev");}
void  S512C4 ::v136(){vfunc_called(this, "_ZN6S512C44v136Ev");}
void  S512C4 ::v137(){vfunc_called(this, "_ZN6S512C44v137Ev");}
void  S512C4 ::v138(){vfunc_called(this, "_ZN6S512C44v138Ev");}
void  S512C4 ::v139(){vfunc_called(this, "_ZN6S512C44v139Ev");}
void  S512C4 ::v140(){vfunc_called(this, "_ZN6S512C44v140Ev");}
void  S512C4 ::v141(){vfunc_called(this, "_ZN6S512C44v141Ev");}
void  S512C4 ::v142(){vfunc_called(this, "_ZN6S512C44v142Ev");}
void  S512C4 ::v143(){vfunc_called(this, "_ZN6S512C44v143Ev");}
void  S512C4 ::v144(){vfunc_called(this, "_ZN6S512C44v144Ev");}
void  S512C4 ::v145(){vfunc_called(this, "_ZN6S512C44v145Ev");}
void  S512C4 ::v146(){vfunc_called(this, "_ZN6S512C44v146Ev");}
void  S512C4 ::v147(){vfunc_called(this, "_ZN6S512C44v147Ev");}
void  S512C4 ::v148(){vfunc_called(this, "_ZN6S512C44v148Ev");}
void  S512C4 ::v149(){vfunc_called(this, "_ZN6S512C44v149Ev");}
void  S512C4 ::v150(){vfunc_called(this, "_ZN6S512C44v150Ev");}
void  S512C4 ::v151(){vfunc_called(this, "_ZN6S512C44v151Ev");}
void  S512C4 ::v152(){vfunc_called(this, "_ZN6S512C44v152Ev");}
void  S512C4 ::v153(){vfunc_called(this, "_ZN6S512C44v153Ev");}
void  S512C4 ::v154(){vfunc_called(this, "_ZN6S512C44v154Ev");}
void  S512C4 ::v155(){vfunc_called(this, "_ZN6S512C44v155Ev");}
void  S512C4 ::v156(){vfunc_called(this, "_ZN6S512C44v156Ev");}
void  S512C4 ::v157(){vfunc_called(this, "_ZN6S512C44v157Ev");}
void  S512C4 ::v158(){vfunc_called(this, "_ZN6S512C44v158Ev");}
void  S512C4 ::v159(){vfunc_called(this, "_ZN6S512C44v159Ev");}
void  S512C4 ::v160(){vfunc_called(this, "_ZN6S512C44v160Ev");}
void  S512C4 ::v161(){vfunc_called(this, "_ZN6S512C44v161Ev");}
void  S512C4 ::v162(){vfunc_called(this, "_ZN6S512C44v162Ev");}
void  S512C4 ::v163(){vfunc_called(this, "_ZN6S512C44v163Ev");}
void  S512C4 ::v164(){vfunc_called(this, "_ZN6S512C44v164Ev");}
void  S512C4 ::v165(){vfunc_called(this, "_ZN6S512C44v165Ev");}
void  S512C4 ::v166(){vfunc_called(this, "_ZN6S512C44v166Ev");}
void  S512C4 ::v167(){vfunc_called(this, "_ZN6S512C44v167Ev");}
void  S512C4 ::v168(){vfunc_called(this, "_ZN6S512C44v168Ev");}
void  S512C4 ::v169(){vfunc_called(this, "_ZN6S512C44v169Ev");}
void  S512C4 ::v170(){vfunc_called(this, "_ZN6S512C44v170Ev");}
void  S512C4 ::v171(){vfunc_called(this, "_ZN6S512C44v171Ev");}
void  S512C4 ::v172(){vfunc_called(this, "_ZN6S512C44v172Ev");}
void  S512C4 ::v173(){vfunc_called(this, "_ZN6S512C44v173Ev");}
void  S512C4 ::v174(){vfunc_called(this, "_ZN6S512C44v174Ev");}
void  S512C4 ::v175(){vfunc_called(this, "_ZN6S512C44v175Ev");}
void  S512C4 ::v176(){vfunc_called(this, "_ZN6S512C44v176Ev");}
void  S512C4 ::v177(){vfunc_called(this, "_ZN6S512C44v177Ev");}
void  S512C4 ::v178(){vfunc_called(this, "_ZN6S512C44v178Ev");}
void  S512C4 ::v179(){vfunc_called(this, "_ZN6S512C44v179Ev");}
void  S512C4 ::v180(){vfunc_called(this, "_ZN6S512C44v180Ev");}
void  S512C4 ::v181(){vfunc_called(this, "_ZN6S512C44v181Ev");}
void  S512C4 ::v182(){vfunc_called(this, "_ZN6S512C44v182Ev");}
void  S512C4 ::v183(){vfunc_called(this, "_ZN6S512C44v183Ev");}
void  S512C4 ::v184(){vfunc_called(this, "_ZN6S512C44v184Ev");}
void  S512C4 ::v185(){vfunc_called(this, "_ZN6S512C44v185Ev");}
void  S512C4 ::v186(){vfunc_called(this, "_ZN6S512C44v186Ev");}
void  S512C4 ::v187(){vfunc_called(this, "_ZN6S512C44v187Ev");}
void  S512C4 ::v188(){vfunc_called(this, "_ZN6S512C44v188Ev");}
void  S512C4 ::v189(){vfunc_called(this, "_ZN6S512C44v189Ev");}
void  S512C4 ::v190(){vfunc_called(this, "_ZN6S512C44v190Ev");}
void  S512C4 ::v191(){vfunc_called(this, "_ZN6S512C44v191Ev");}
void  S512C4 ::v192(){vfunc_called(this, "_ZN6S512C44v192Ev");}
void  S512C4 ::v193(){vfunc_called(this, "_ZN6S512C44v193Ev");}
void  S512C4 ::v194(){vfunc_called(this, "_ZN6S512C44v194Ev");}
void  S512C4 ::v195(){vfunc_called(this, "_ZN6S512C44v195Ev");}
void  S512C4 ::v196(){vfunc_called(this, "_ZN6S512C44v196Ev");}
void  S512C4 ::v197(){vfunc_called(this, "_ZN6S512C44v197Ev");}
void  S512C4 ::v198(){vfunc_called(this, "_ZN6S512C44v198Ev");}
void  S512C4 ::v199(){vfunc_called(this, "_ZN6S512C44v199Ev");}
void  S512C4 ::v200(){vfunc_called(this, "_ZN6S512C44v200Ev");}
void  S512C4 ::v201(){vfunc_called(this, "_ZN6S512C44v201Ev");}
void  S512C4 ::v202(){vfunc_called(this, "_ZN6S512C44v202Ev");}
void  S512C4 ::v203(){vfunc_called(this, "_ZN6S512C44v203Ev");}
void  S512C4 ::v204(){vfunc_called(this, "_ZN6S512C44v204Ev");}
void  S512C4 ::v205(){vfunc_called(this, "_ZN6S512C44v205Ev");}
void  S512C4 ::v206(){vfunc_called(this, "_ZN6S512C44v206Ev");}
void  S512C4 ::v207(){vfunc_called(this, "_ZN6S512C44v207Ev");}
void  S512C4 ::v208(){vfunc_called(this, "_ZN6S512C44v208Ev");}
void  S512C4 ::v209(){vfunc_called(this, "_ZN6S512C44v209Ev");}
void  S512C4 ::v210(){vfunc_called(this, "_ZN6S512C44v210Ev");}
void  S512C4 ::v211(){vfunc_called(this, "_ZN6S512C44v211Ev");}
void  S512C4 ::v212(){vfunc_called(this, "_ZN6S512C44v212Ev");}
void  S512C4 ::v213(){vfunc_called(this, "_ZN6S512C44v213Ev");}
void  S512C4 ::v214(){vfunc_called(this, "_ZN6S512C44v214Ev");}
void  S512C4 ::v215(){vfunc_called(this, "_ZN6S512C44v215Ev");}
void  S512C4 ::v216(){vfunc_called(this, "_ZN6S512C44v216Ev");}
void  S512C4 ::v217(){vfunc_called(this, "_ZN6S512C44v217Ev");}
void  S512C4 ::v218(){vfunc_called(this, "_ZN6S512C44v218Ev");}
void  S512C4 ::v219(){vfunc_called(this, "_ZN6S512C44v219Ev");}
void  S512C4 ::v220(){vfunc_called(this, "_ZN6S512C44v220Ev");}
void  S512C4 ::v221(){vfunc_called(this, "_ZN6S512C44v221Ev");}
void  S512C4 ::v222(){vfunc_called(this, "_ZN6S512C44v222Ev");}
void  S512C4 ::v223(){vfunc_called(this, "_ZN6S512C44v223Ev");}
void  S512C4 ::v224(){vfunc_called(this, "_ZN6S512C44v224Ev");}
void  S512C4 ::v225(){vfunc_called(this, "_ZN6S512C44v225Ev");}
void  S512C4 ::v226(){vfunc_called(this, "_ZN6S512C44v226Ev");}
void  S512C4 ::v227(){vfunc_called(this, "_ZN6S512C44v227Ev");}
void  S512C4 ::v228(){vfunc_called(this, "_ZN6S512C44v228Ev");}
void  S512C4 ::v229(){vfunc_called(this, "_ZN6S512C44v229Ev");}
void  S512C4 ::v230(){vfunc_called(this, "_ZN6S512C44v230Ev");}
void  S512C4 ::v231(){vfunc_called(this, "_ZN6S512C44v231Ev");}
S512C4 ::S512C4(){ note_ctor("S512C4", this);} // tgen

static void Test_S512C4()
{
  extern Class_Descriptor cd_S512C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(72,110)];
    init_test(&cd_S512C4, buf);
    S512C4 *dp, &lv = *(dp=new (buf) S512C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(568,436), "sizeof(S512C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S512C4)");
    check_base_class_offset(lv, (S512C5*), 0, "S512C4");
    check_field_offset(lv, s512c4f0, ABISELECT(96,60), "S512C4.s512c4f0");
    check_field_offset(lv, s512c4f1, ABISELECT(112,72), "S512C4.s512c4f1");
    check_field_offset(lv, s512c4f2, ABISELECT(128,84), "S512C4.s512c4f2");
    check_field_offset(lv, s512c4f3, ABISELECT(132,88), "S512C4.s512c4f3");
    check_field_offset(lv, s512c4f4, ABISELECT(136,92), "S512C4.s512c4f4");
    check_field_offset(lv, s512c4f5, ABISELECT(144,96), "S512C4.s512c4f5");
    check_field_offset(lv, s512c4f6, ABISELECT(160,104), "S512C4.s512c4f6");
    set_bf_and_test(lv, s512c4f7, ABISELECT(176,116), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f8, ABISELECT(176,116), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f9, ABISELECT(176,116), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f10, ABISELECT(176,116), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f11, ABISELECT(176,116), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f12, ABISELECT(176,116), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f13, ABISELECT(176,116), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f14, ABISELECT(176,116), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f15, ABISELECT(177,117), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f16, ABISELECT(177,117), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f17, ABISELECT(177,117), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f18, ABISELECT(177,117), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f19, ABISELECT(177,117), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f20, ABISELECT(177,117), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f21, ABISELECT(177,117), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f22, ABISELECT(177,117), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f23, ABISELECT(178,118), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f24, ABISELECT(178,118), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f25, ABISELECT(178,118), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f26, ABISELECT(178,118), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f27, ABISELECT(178,118), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f28, ABISELECT(178,118), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f29, ABISELECT(178,118), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f30, ABISELECT(178,118), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f31, ABISELECT(179,119), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f32, ABISELECT(179,119), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f33, ABISELECT(179,119), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f34, ABISELECT(179,119), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f35, ABISELECT(179,119), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f36, ABISELECT(179,119), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f37, ABISELECT(179,119), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f38, ABISELECT(179,119), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f39, ABISELECT(180,120), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f40, ABISELECT(180,120), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f41, ABISELECT(180,120), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f42, ABISELECT(180,120), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f43, ABISELECT(180,120), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f44, ABISELECT(180,120), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f45, ABISELECT(180,120), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f46, ABISELECT(180,120), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f47, ABISELECT(181,121), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f48, ABISELECT(181,121), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f49, ABISELECT(181,121), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f50, ABISELECT(181,121), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f51, ABISELECT(181,121), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f52, ABISELECT(181,121), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f53, ABISELECT(181,121), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f54, ABISELECT(181,121), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f55, ABISELECT(182,122), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f56, ABISELECT(182,122), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f57, ABISELECT(182,122), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f58, ABISELECT(182,122), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f59, ABISELECT(182,122), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f60, ABISELECT(182,122), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f61, ABISELECT(182,122), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f62, ABISELECT(182,122), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f63, ABISELECT(183,123), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f64, ABISELECT(183,123), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f65, ABISELECT(183,123), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f66, ABISELECT(183,123), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f67, ABISELECT(183,123), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f68, ABISELECT(183,123), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f69, ABISELECT(183,123), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f70, ABISELECT(183,123), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f71, ABISELECT(184,124), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f72, ABISELECT(184,124), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f73, ABISELECT(184,124), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f74, ABISELECT(184,124), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f75, ABISELECT(184,124), 4, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f76, ABISELECT(184,124), 5, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f77, ABISELECT(184,124), 6, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f78, ABISELECT(184,124), 7, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f79, ABISELECT(185,125), 0, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f80, ABISELECT(185,125), 1, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f81, ABISELECT(185,125), 2, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f82, ABISELECT(185,125), 3, 1, 1, "S512C4");
    set_bf_and_test(lv, s512c4f83, ABISELECT(185,125), 4, 1, 1, "S512C4");
    check_field_offset(lv, s512c4f84, ABISELECT(188,128), "S512C4.s512c4f84");
    check_field_offset(lv, s512c4f85, ABISELECT(208,148), "S512C4.s512c4f85");
    check_field_offset(lv, s512c4f86, ABISELECT(224,156), "S512C4.s512c4f86");
    check_field_offset(lv, s512c4f87, ABISELECT(236,168), "S512C4.s512c4f87");
    check_field_offset(lv, s512c4f88, ABISELECT(244,176), "S512C4.s512c4f88");
    check_field_offset(lv, s512c4f89, ABISELECT(252,184), "S512C4.s512c4f89");
    check_field_offset(lv, s512c4f90, ABISELECT(264,192), "S512C4.s512c4f90");
    check_field_offset(lv, s512c4f91, ABISELECT(280,204), "S512C4.s512c4f91");
    check_field_offset(lv, s512c4f92, ABISELECT(296,216), "S512C4.s512c4f92");
    check_field_offset(lv, s512c4f93, ABISELECT(304,220), "S512C4.s512c4f93");
    check_field_offset(lv, s512c4f94, ABISELECT(320,228), "S512C4.s512c4f94");
    check_field_offset(lv, s512c4f95, ABISELECT(332,240), "S512C4.s512c4f95");
    check_field_offset(lv, s512c4f96, ABISELECT(344,252), "S512C4.s512c4f96");
    check_field_offset(lv, s512c4f97, ABISELECT(356,264), "S512C4.s512c4f97");
    check_field_offset(lv, s512c4f98, ABISELECT(368,276), "S512C4.s512c4f98");
    check_field_offset(lv, s512c4f99, ABISELECT(376,280), "S512C4.s512c4f99");
    check_field_offset(lv, s512c4f100, ABISELECT(384,288), "S512C4.s512c4f100");
    check_field_offset(lv, s512c4f101, ABISELECT(400,300), "S512C4.s512c4f101");
    check_field_offset(lv, s512c4f102, ABISELECT(412,312), "S512C4.s512c4f102");
    check_field_offset(lv, s512c4f103, ABISELECT(424,324), "S512C4.s512c4f103");
    check_field_offset(lv, s512c4f104, ABISELECT(428,328), "S512C4.s512c4f104");
    check_field_offset(lv, s512c4f105, ABISELECT(440,340), "S512C4.s512c4f105");
    check_field_offset(lv, s512c4f106, ABISELECT(456,352), "S512C4.s512c4f106");
    check_field_offset(lv, s512c4f107, ABISELECT(464,356), "S512C4.s512c4f107");
    check_field_offset(lv, s512c4f108, ABISELECT(468,360), "S512C4.s512c4f108");
    check_field_offset(lv, s512c4f109, ABISELECT(472,364), "S512C4.s512c4f109");
    check_field_offset(lv, s512c4f110, ABISELECT(484,376), "S512C4.s512c4f110");
    check_field_offset(lv, s512c4f111, ABISELECT(496,388), "S512C4.s512c4f111");
    check_field_offset(lv, s512c4f112, ABISELECT(504,392), "S512C4.s512c4f112");
    check_field_offset(lv, s512c4f113, ABISELECT(512,396), "S512C4.s512c4f113");
    check_field_offset(lv, s512c4f114, ABISELECT(520,400), "S512C4.s512c4f114");
    check_field_offset(lv, s512c4f115, ABISELECT(536,412), "S512C4.s512c4f115");
    check_field_offset(lv, s512c4f116, ABISELECT(552,424), "S512C4.s512c4f116");
    test_class_info(&lv, &cd_S512C4);
    dp->~S512C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS512C4(Test_S512C4, "S512C4", ABISELECT(568,436));

#else // __cplusplus

extern void _ZN6S512C4C1Ev();
extern void _ZN6S512C4D1Ev();
Name_Map name_map_S512C4[] = {
  NSPAIR(_ZN6S512C4C1Ev),
  NSPAIR(_ZN6S512C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S512C5;
extern VTBL_ENTRY _ZTI6S512C5[];
extern  VTBL_ENTRY _ZTV6S512C5[];
static Base_Class bases_S512C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S512C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S512C4[];
extern void _ZN6S512C4D1Ev();
extern void _ZN6S512C4D0Ev();
extern void _ZN6S512C53v25Ev();
extern void _ZN6S512C53v26Ev();
extern void _ZN6S512C53v27Ev();
extern void _ZN6S512C53v28Ev();
extern void _ZN6S512C53v29Ev();
extern void _ZN6S512C53v30Ev();
extern void _ZN6S512C53v31Ev();
extern void _ZN6S512C53v32Ev();
extern void _ZN6S512C53v33Ev();
extern void _ZN6S512C53v34Ev();
extern void _ZN6S512C53v35Ev();
extern void _ZN6S512C53v36Ev();
extern void _ZN6S512C53v37Ev();
extern void _ZN6S512C53v38Ev();
extern void _ZN6S512C53v39Ev();
extern void _ZN6S512C53v40Ev();
extern void _ZN6S512C53v41Ev();
extern void _ZN6S512C53v42Ev();
extern void _ZN6S512C53v43Ev();
extern void _ZN6S512C53v44Ev();
extern void _ZN6S512C53v45Ev();
extern void _ZN6S512C53v46Ev();
extern void _ZN6S512C53v47Ev();
extern void _ZN6S512C53v48Ev();
extern void _ZN6S512C53v49Ev();
extern void _ZN6S512C53v50Ev();
extern void _ZN6S512C53v51Ev();
extern void _ZN6S512C53v52Ev();
extern void _ZN6S512C53v53Ev();
extern void _ZN6S512C53v54Ev();
extern void _ZN6S512C53v55Ev();
extern void _ZN6S512C53v56Ev();
extern void _ZN6S512C53v57Ev();
extern void _ZN6S512C53v58Ev();
extern void _ZN6S512C53v59Ev();
extern void _ZN6S512C53v60Ev();
extern void _ZN6S512C53v61Ev();
extern void _ZN6S512C53v62Ev();
extern void _ZN6S512C53v63Ev();
extern void _ZN6S512C53v64Ev();
extern void _ZN6S512C53v65Ev();
extern void _ZN6S512C53v66Ev();
extern void _ZN6S512C53v67Ev();
extern void _ZN6S512C53v68Ev();
extern void _ZN6S512C53v69Ev();
extern void _ZN6S512C53v70Ev();
extern void _ZN6S512C53v71Ev();
extern void _ZN6S512C53v72Ev();
extern void _ZN6S512C53v73Ev();
extern void _ZN6S512C53v74Ev();
extern void _ZN6S512C53v75Ev();
extern void _ZN6S512C53v76Ev();
extern void _ZN6S512C53v77Ev();
extern void _ZN6S512C53v78Ev();
extern void _ZN6S512C53v79Ev();
extern void _ZN6S512C53v80Ev();
extern void _ZN6S512C53v81Ev();
extern void _ZN6S512C53v82Ev();
extern void _ZN6S512C53v83Ev();
extern void _ZN6S512C53v84Ev();
extern void _ZN6S512C53v85Ev();
extern void _ZN6S512C53v86Ev();
extern void _ZN6S512C53v87Ev();
extern void _ZN6S512C53v88Ev();
extern void _ZN6S512C43v89Ev();
extern void _ZN6S512C43v90Ev();
extern void _ZN6S512C43v91Ev();
extern void _ZN6S512C43v92Ev();
extern void _ZN6S512C43v93Ev();
extern void _ZN6S512C43v94Ev();
extern void _ZN6S512C43v95Ev();
extern void _ZN6S512C43v96Ev();
extern void _ZN6S512C43v97Ev();
extern void _ZN6S512C43v98Ev();
extern void _ZN6S512C43v99Ev();
extern void _ZN6S512C44v100Ev();
extern void _ZN6S512C44v101Ev();
extern void _ZN6S512C44v102Ev();
extern void _ZN6S512C44v103Ev();
extern void _ZN6S512C44v104Ev();
extern void _ZN6S512C44v105Ev();
extern void _ZN6S512C44v106Ev();
extern void _ZN6S512C44v107Ev();
extern void _ZN6S512C44v108Ev();
extern void _ZN6S512C44v109Ev();
extern void _ZN6S512C44v110Ev();
extern void _ZN6S512C44v111Ev();
extern void _ZN6S512C44v112Ev();
extern void _ZN6S512C44v113Ev();
extern void _ZN6S512C44v114Ev();
extern void _ZN6S512C44v115Ev();
extern void _ZN6S512C44v116Ev();
extern void _ZN6S512C44v117Ev();
extern void _ZN6S512C44v118Ev();
extern void _ZN6S512C44v119Ev();
extern void _ZN6S512C44v120Ev();
extern void _ZN6S512C44v121Ev();
extern void _ZN6S512C44v122Ev();
extern void _ZN6S512C44v123Ev();
extern void _ZN6S512C44v124Ev();
extern void _ZN6S512C44v125Ev();
extern void _ZN6S512C44v126Ev();
extern void _ZN6S512C44v127Ev();
extern void _ZN6S512C44v128Ev();
extern void _ZN6S512C44v129Ev();
extern void _ZN6S512C44v130Ev();
extern void _ZN6S512C44v131Ev();
extern void _ZN6S512C44v132Ev();
extern void _ZN6S512C44v133Ev();
extern void _ZN6S512C44v134Ev();
extern void _ZN6S512C44v135Ev();
extern void _ZN6S512C44v136Ev();
extern void _ZN6S512C44v137Ev();
extern void _ZN6S512C44v138Ev();
extern void _ZN6S512C44v139Ev();
extern void _ZN6S512C44v140Ev();
extern void _ZN6S512C44v141Ev();
extern void _ZN6S512C44v142Ev();
extern void _ZN6S512C44v143Ev();
extern void _ZN6S512C44v144Ev();
extern void _ZN6S512C44v145Ev();
extern void _ZN6S512C44v146Ev();
extern void _ZN6S512C44v147Ev();
extern void _ZN6S512C44v148Ev();
extern void _ZN6S512C44v149Ev();
extern void _ZN6S512C44v150Ev();
extern void _ZN6S512C44v151Ev();
extern void _ZN6S512C44v152Ev();
extern void _ZN6S512C44v153Ev();
extern void _ZN6S512C44v154Ev();
extern void _ZN6S512C44v155Ev();
extern void _ZN6S512C44v156Ev();
extern void _ZN6S512C44v157Ev();
extern void _ZN6S512C44v158Ev();
extern void _ZN6S512C44v159Ev();
extern void _ZN6S512C44v160Ev();
extern void _ZN6S512C44v161Ev();
extern void _ZN6S512C44v162Ev();
extern void _ZN6S512C44v163Ev();
extern void _ZN6S512C44v164Ev();
extern void _ZN6S512C44v165Ev();
extern void _ZN6S512C44v166Ev();
extern void _ZN6S512C44v167Ev();
extern void _ZN6S512C44v168Ev();
extern void _ZN6S512C44v169Ev();
extern void _ZN6S512C44v170Ev();
extern void _ZN6S512C44v171Ev();
extern void _ZN6S512C44v172Ev();
extern void _ZN6S512C44v173Ev();
extern void _ZN6S512C44v174Ev();
extern void _ZN6S512C44v175Ev();
extern void _ZN6S512C44v176Ev();
extern void _ZN6S512C44v177Ev();
extern void _ZN6S512C44v178Ev();
extern void _ZN6S512C44v179Ev();
extern void _ZN6S512C44v180Ev();
extern void _ZN6S512C44v181Ev();
extern void _ZN6S512C44v182Ev();
extern void _ZN6S512C44v183Ev();
extern void _ZN6S512C44v184Ev();
extern void _ZN6S512C44v185Ev();
extern void _ZN6S512C44v186Ev();
extern void _ZN6S512C44v187Ev();
extern void _ZN6S512C44v188Ev();
extern void _ZN6S512C44v189Ev();
extern void _ZN6S512C44v190Ev();
extern void _ZN6S512C44v191Ev();
extern void _ZN6S512C44v192Ev();
extern void _ZN6S512C44v193Ev();
extern void _ZN6S512C44v194Ev();
extern void _ZN6S512C44v195Ev();
extern void _ZN6S512C44v196Ev();
extern void _ZN6S512C44v197Ev();
extern void _ZN6S512C44v198Ev();
extern void _ZN6S512C44v199Ev();
extern void _ZN6S512C44v200Ev();
extern void _ZN6S512C44v201Ev();
extern void _ZN6S512C44v202Ev();
extern void _ZN6S512C44v203Ev();
extern void _ZN6S512C44v204Ev();
extern void _ZN6S512C44v205Ev();
extern void _ZN6S512C44v206Ev();
extern void _ZN6S512C44v207Ev();
extern void _ZN6S512C44v208Ev();
extern void _ZN6S512C44v209Ev();
extern void _ZN6S512C44v210Ev();
extern void _ZN6S512C44v211Ev();
extern void _ZN6S512C44v212Ev();
extern void _ZN6S512C44v213Ev();
extern void _ZN6S512C44v214Ev();
extern void _ZN6S512C44v215Ev();
extern void _ZN6S512C44v216Ev();
extern void _ZN6S512C44v217Ev();
extern void _ZN6S512C44v218Ev();
extern void _ZN6S512C44v219Ev();
extern void _ZN6S512C44v220Ev();
extern void _ZN6S512C44v221Ev();
extern void _ZN6S512C44v222Ev();
extern void _ZN6S512C44v223Ev();
extern void _ZN6S512C44v224Ev();
extern void _ZN6S512C44v225Ev();
extern void _ZN6S512C44v226Ev();
extern void _ZN6S512C44v227Ev();
extern void _ZN6S512C44v228Ev();
extern void _ZN6S512C44v229Ev();
extern void _ZN6S512C44v230Ev();
extern void _ZN6S512C44v231Ev();
static  VTBL_ENTRY vtc_S512C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S512C4[0]),
  (VTBL_ENTRY)&_ZN6S512C4D1Ev,
  (VTBL_ENTRY)&_ZN6S512C4D0Ev,
  (VTBL_ENTRY)&_ZN6S512C53v25Ev,
  (VTBL_ENTRY)&_ZN6S512C53v26Ev,
  (VTBL_ENTRY)&_ZN6S512C53v27Ev,
  (VTBL_ENTRY)&_ZN6S512C53v28Ev,
  (VTBL_ENTRY)&_ZN6S512C53v29Ev,
  (VTBL_ENTRY)&_ZN6S512C53v30Ev,
  (VTBL_ENTRY)&_ZN6S512C53v31Ev,
  (VTBL_ENTRY)&_ZN6S512C53v32Ev,
  (VTBL_ENTRY)&_ZN6S512C53v33Ev,
  (VTBL_ENTRY)&_ZN6S512C53v34Ev,
  (VTBL_ENTRY)&_ZN6S512C53v35Ev,
  (VTBL_ENTRY)&_ZN6S512C53v36Ev,
  (VTBL_ENTRY)&_ZN6S512C53v37Ev,
  (VTBL_ENTRY)&_ZN6S512C53v38Ev,
  (VTBL_ENTRY)&_ZN6S512C53v39Ev,
  (VTBL_ENTRY)&_ZN6S512C53v40Ev,
  (VTBL_ENTRY)&_ZN6S512C53v41Ev,
  (VTBL_ENTRY)&_ZN6S512C53v42Ev,
  (VTBL_ENTRY)&_ZN6S512C53v43Ev,
  (VTBL_ENTRY)&_ZN6S512C53v44Ev,
  (VTBL_ENTRY)&_ZN6S512C53v45Ev,
  (VTBL_ENTRY)&_ZN6S512C53v46Ev,
  (VTBL_ENTRY)&_ZN6S512C53v47Ev,
  (VTBL_ENTRY)&_ZN6S512C53v48Ev,
  (VTBL_ENTRY)&_ZN6S512C53v49Ev,
  (VTBL_ENTRY)&_ZN6S512C53v50Ev,
  (VTBL_ENTRY)&_ZN6S512C53v51Ev,
  (VTBL_ENTRY)&_ZN6S512C53v52Ev,
  (VTBL_ENTRY)&_ZN6S512C53v53Ev,
  (VTBL_ENTRY)&_ZN6S512C53v54Ev,
  (VTBL_ENTRY)&_ZN6S512C53v55Ev,
  (VTBL_ENTRY)&_ZN6S512C53v56Ev,
  (VTBL_ENTRY)&_ZN6S512C53v57Ev,
  (VTBL_ENTRY)&_ZN6S512C53v58Ev,
  (VTBL_ENTRY)&_ZN6S512C53v59Ev,
  (VTBL_ENTRY)&_ZN6S512C53v60Ev,
  (VTBL_ENTRY)&_ZN6S512C53v61Ev,
  (VTBL_ENTRY)&_ZN6S512C53v62Ev,
  (VTBL_ENTRY)&_ZN6S512C53v63Ev,
  (VTBL_ENTRY)&_ZN6S512C53v64Ev,
  (VTBL_ENTRY)&_ZN6S512C53v65Ev,
  (VTBL_ENTRY)&_ZN6S512C53v66Ev,
  (VTBL_ENTRY)&_ZN6S512C53v67Ev,
  (VTBL_ENTRY)&_ZN6S512C53v68Ev,
  (VTBL_ENTRY)&_ZN6S512C53v69Ev,
  (VTBL_ENTRY)&_ZN6S512C53v70Ev,
  (VTBL_ENTRY)&_ZN6S512C53v71Ev,
  (VTBL_ENTRY)&_ZN6S512C53v72Ev,
  (VTBL_ENTRY)&_ZN6S512C53v73Ev,
  (VTBL_ENTRY)&_ZN6S512C53v74Ev,
  (VTBL_ENTRY)&_ZN6S512C53v75Ev,
  (VTBL_ENTRY)&_ZN6S512C53v76Ev,
  (VTBL_ENTRY)&_ZN6S512C53v77Ev,
  (VTBL_ENTRY)&_ZN6S512C53v78Ev,
  (VTBL_ENTRY)&_ZN6S512C53v79Ev,
  (VTBL_ENTRY)&_ZN6S512C53v80Ev,
  (VTBL_ENTRY)&_ZN6S512C53v81Ev,
  (VTBL_ENTRY)&_ZN6S512C53v82Ev,
  (VTBL_ENTRY)&_ZN6S512C53v83Ev,
  (VTBL_ENTRY)&_ZN6S512C53v84Ev,
  (VTBL_ENTRY)&_ZN6S512C53v85Ev,
  (VTBL_ENTRY)&_ZN6S512C53v86Ev,
  (VTBL_ENTRY)&_ZN6S512C53v87Ev,
  (VTBL_ENTRY)&_ZN6S512C53v88Ev,
  (VTBL_ENTRY)&_ZN6S512C43v89Ev,
  (VTBL_ENTRY)&_ZN6S512C43v90Ev,
  (VTBL_ENTRY)&_ZN6S512C43v91Ev,
  (VTBL_ENTRY)&_ZN6S512C43v92Ev,
  (VTBL_ENTRY)&_ZN6S512C43v93Ev,
  (VTBL_ENTRY)&_ZN6S512C43v94Ev,
  (VTBL_ENTRY)&_ZN6S512C43v95Ev,
  (VTBL_ENTRY)&_ZN6S512C43v96Ev,
  (VTBL_ENTRY)&_ZN6S512C43v97Ev,
  (VTBL_ENTRY)&_ZN6S512C43v98Ev,
  (VTBL_ENTRY)&_ZN6S512C43v99Ev,
  (VTBL_ENTRY)&_ZN6S512C44v100Ev,
  (VTBL_ENTRY)&_ZN6S512C44v101Ev,
  (VTBL_ENTRY)&_ZN6S512C44v102Ev,
  (VTBL_ENTRY)&_ZN6S512C44v103Ev,
  (VTBL_ENTRY)&_ZN6S512C44v104Ev,
  (VTBL_ENTRY)&_ZN6S512C44v105Ev,
  (VTBL_ENTRY)&_ZN6S512C44v106Ev,
  (VTBL_ENTRY)&_ZN6S512C44v107Ev,
  (VTBL_ENTRY)&_ZN6S512C44v108Ev,
  (VTBL_ENTRY)&_ZN6S512C44v109Ev,
  (VTBL_ENTRY)&_ZN6S512C44v110Ev,
  (VTBL_ENTRY)&_ZN6S512C44v111Ev,
  (VTBL_ENTRY)&_ZN6S512C44v112Ev,
  (VTBL_ENTRY)&_ZN6S512C44v113Ev,
  (VTBL_ENTRY)&_ZN6S512C44v114Ev,
  (VTBL_ENTRY)&_ZN6S512C44v115Ev,
  (VTBL_ENTRY)&_ZN6S512C44v116Ev,
  (VTBL_ENTRY)&_ZN6S512C44v117Ev,
  (VTBL_ENTRY)&_ZN6S512C44v118Ev,
  (VTBL_ENTRY)&_ZN6S512C44v119Ev,
  (VTBL_ENTRY)&_ZN6S512C44v120Ev,
  (VTBL_ENTRY)&_ZN6S512C44v121Ev,
  (VTBL_ENTRY)&_ZN6S512C44v122Ev,
  (VTBL_ENTRY)&_ZN6S512C44v123Ev,
  (VTBL_ENTRY)&_ZN6S512C44v124Ev,
  (VTBL_ENTRY)&_ZN6S512C44v125Ev,
  (VTBL_ENTRY)&_ZN6S512C44v126Ev,
  (VTBL_ENTRY)&_ZN6S512C44v127Ev,
  (VTBL_ENTRY)&_ZN6S512C44v128Ev,
  (VTBL_ENTRY)&_ZN6S512C44v129Ev,
  (VTBL_ENTRY)&_ZN6S512C44v130Ev,
  (VTBL_ENTRY)&_ZN6S512C44v131Ev,
  (VTBL_ENTRY)&_ZN6S512C44v132Ev,
  (VTBL_ENTRY)&_ZN6S512C44v133Ev,
  (VTBL_ENTRY)&_ZN6S512C44v134Ev,
  (VTBL_ENTRY)&_ZN6S512C44v135Ev,
  (VTBL_ENTRY)&_ZN6S512C44v136Ev,
  (VTBL_ENTRY)&_ZN6S512C44v137Ev,
  (VTBL_ENTRY)&_ZN6S512C44v138Ev,
  (VTBL_ENTRY)&_ZN6S512C44v139Ev,
  (VTBL_ENTRY)&_ZN6S512C44v140Ev,
  (VTBL_ENTRY)&_ZN6S512C44v141Ev,
  (VTBL_ENTRY)&_ZN6S512C44v142Ev,
  (VTBL_ENTRY)&_ZN6S512C44v143Ev,
  (VTBL_ENTRY)&_ZN6S512C44v144Ev,
  (VTBL_ENTRY)&_ZN6S512C44v145Ev,
  (VTBL_ENTRY)&_ZN6S512C44v146Ev,
  (VTBL_ENTRY)&_ZN6S512C44v147Ev,
  (VTBL_ENTRY)&_ZN6S512C44v148Ev,
  (VTBL_ENTRY)&_ZN6S512C44v149Ev,
  (VTBL_ENTRY)&_ZN6S512C44v150Ev,
  (VTBL_ENTRY)&_ZN6S512C44v151Ev,
  (VTBL_ENTRY)&_ZN6S512C44v152Ev,
  (VTBL_ENTRY)&_ZN6S512C44v153Ev,
  (VTBL_ENTRY)&_ZN6S512C44v154Ev,
  (VTBL_ENTRY)&_ZN6S512C44v155Ev,
  (VTBL_ENTRY)&_ZN6S512C44v156Ev,
  (VTBL_ENTRY)&_ZN6S512C44v157Ev,
  (VTBL_ENTRY)&_ZN6S512C44v158Ev,
  (VTBL_ENTRY)&_ZN6S512C44v159Ev,
  (VTBL_ENTRY)&_ZN6S512C44v160Ev,
  (VTBL_ENTRY)&_ZN6S512C44v161Ev,
  (VTBL_ENTRY)&_ZN6S512C44v162Ev,
  (VTBL_ENTRY)&_ZN6S512C44v163Ev,
  (VTBL_ENTRY)&_ZN6S512C44v164Ev,
  (VTBL_ENTRY)&_ZN6S512C44v165Ev,
  (VTBL_ENTRY)&_ZN6S512C44v166Ev,
  (VTBL_ENTRY)&_ZN6S512C44v167Ev,
  (VTBL_ENTRY)&_ZN6S512C44v168Ev,
  (VTBL_ENTRY)&_ZN6S512C44v169Ev,
  (VTBL_ENTRY)&_ZN6S512C44v170Ev,
  (VTBL_ENTRY)&_ZN6S512C44v171Ev,
  (VTBL_ENTRY)&_ZN6S512C44v172Ev,
  (VTBL_ENTRY)&_ZN6S512C44v173Ev,
  (VTBL_ENTRY)&_ZN6S512C44v174Ev,
  (VTBL_ENTRY)&_ZN6S512C44v175Ev,
  (VTBL_ENTRY)&_ZN6S512C44v176Ev,
  (VTBL_ENTRY)&_ZN6S512C44v177Ev,
  (VTBL_ENTRY)&_ZN6S512C44v178Ev,
  (VTBL_ENTRY)&_ZN6S512C44v179Ev,
  (VTBL_ENTRY)&_ZN6S512C44v180Ev,
  (VTBL_ENTRY)&_ZN6S512C44v181Ev,
  (VTBL_ENTRY)&_ZN6S512C44v182Ev,
  (VTBL_ENTRY)&_ZN6S512C44v183Ev,
  (VTBL_ENTRY)&_ZN6S512C44v184Ev,
  (VTBL_ENTRY)&_ZN6S512C44v185Ev,
  (VTBL_ENTRY)&_ZN6S512C44v186Ev,
  (VTBL_ENTRY)&_ZN6S512C44v187Ev,
  (VTBL_ENTRY)&_ZN6S512C44v188Ev,
  (VTBL_ENTRY)&_ZN6S512C44v189Ev,
  (VTBL_ENTRY)&_ZN6S512C44v190Ev,
  (VTBL_ENTRY)&_ZN6S512C44v191Ev,
  (VTBL_ENTRY)&_ZN6S512C44v192Ev,
  (VTBL_ENTRY)&_ZN6S512C44v193Ev,
  (VTBL_ENTRY)&_ZN6S512C44v194Ev,
  (VTBL_ENTRY)&_ZN6S512C44v195Ev,
  (VTBL_ENTRY)&_ZN6S512C44v196Ev,
  (VTBL_ENTRY)&_ZN6S512C44v197Ev,
  (VTBL_ENTRY)&_ZN6S512C44v198Ev,
  (VTBL_ENTRY)&_ZN6S512C44v199Ev,
  (VTBL_ENTRY)&_ZN6S512C44v200Ev,
  (VTBL_ENTRY)&_ZN6S512C44v201Ev,
  (VTBL_ENTRY)&_ZN6S512C44v202Ev,
  (VTBL_ENTRY)&_ZN6S512C44v203Ev,
  (VTBL_ENTRY)&_ZN6S512C44v204Ev,
  (VTBL_ENTRY)&_ZN6S512C44v205Ev,
  (VTBL_ENTRY)&_ZN6S512C44v206Ev,
  (VTBL_ENTRY)&_ZN6S512C44v207Ev,
  (VTBL_ENTRY)&_ZN6S512C44v208Ev,
  (VTBL_ENTRY)&_ZN6S512C44v209Ev,
  (VTBL_ENTRY)&_ZN6S512C44v210Ev,
  (VTBL_ENTRY)&_ZN6S512C44v211Ev,
  (VTBL_ENTRY)&_ZN6S512C44v212Ev,
  (VTBL_ENTRY)&_ZN6S512C44v213Ev,
  (VTBL_ENTRY)&_ZN6S512C44v214Ev,
  (VTBL_ENTRY)&_ZN6S512C44v215Ev,
  (VTBL_ENTRY)&_ZN6S512C44v216Ev,
  (VTBL_ENTRY)&_ZN6S512C44v217Ev,
  (VTBL_ENTRY)&_ZN6S512C44v218Ev,
  (VTBL_ENTRY)&_ZN6S512C44v219Ev,
  (VTBL_ENTRY)&_ZN6S512C44v220Ev,
  (VTBL_ENTRY)&_ZN6S512C44v221Ev,
  (VTBL_ENTRY)&_ZN6S512C44v222Ev,
  (VTBL_ENTRY)&_ZN6S512C44v223Ev,
  (VTBL_ENTRY)&_ZN6S512C44v224Ev,
  (VTBL_ENTRY)&_ZN6S512C44v225Ev,
  (VTBL_ENTRY)&_ZN6S512C44v226Ev,
  (VTBL_ENTRY)&_ZN6S512C44v227Ev,
  (VTBL_ENTRY)&_ZN6S512C44v228Ev,
  (VTBL_ENTRY)&_ZN6S512C44v229Ev,
  (VTBL_ENTRY)&_ZN6S512C44v230Ev,
  (VTBL_ENTRY)&_ZN6S512C44v231Ev,
};
extern VTBL_ENTRY _ZTI6S512C4[];
extern  VTBL_ENTRY _ZTV6S512C4[];
Class_Descriptor cd_S512C4 = {  "S512C4", // class name
  bases_S512C4, 1,
  &(vtc_S512C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI6S512C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S512C4),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S512C3  : S512C4 {
  void *s512c3f0[2];
  int s512c3f1;
  void *s512c3f2;
  unsigned int s512c3f3:1;
  unsigned int s512c3f4:1;
  unsigned int s512c3f5:1;
  unsigned int s512c3f6:1;
  unsigned int s512c3f7:1;
  unsigned int s512c3f8:1;
  unsigned int s512c3f9:1;
  unsigned int s512c3f10:1;
  unsigned int s512c3f11:1;
  unsigned int s512c3f12:1;
  unsigned int s512c3f13:1;
  unsigned int s512c3f14:1;
  unsigned int s512c3f15:1;
  unsigned int s512c3f16:1;
  unsigned int s512c3f17:1;
  unsigned int s512c3f18:1;
  unsigned int s512c3f19:1;
  unsigned int s512c3f20:1;
  unsigned int s512c3f21:1;
  char s512c3f22;
  int s512c3f23[2];
  void *s512c3f24;
  ::S48C18 s512c3f25;
  ::S48C18 s512c3f26;
  void *s512c3f27[5];
  ::S48C18 s512c3f28;
  void *s512c3f29;
  ::S28C44 s512c3f30;
  void *s512c3f31[2];
  ::S48C18 s512c3f32;
  void *s512c3f33;
  int s512c3f34[2];
  void *s512c3f35;
  int s512c3f36;
  ::S48C18 s512c3f37;
  ::S48C18 s512c3f38;
  ::S48C18 s512c3f39;
  void *s512c3f40[2];
  int s512c3f41;
  ::S48C18 s512c3f42;
  int s512c3f43[4];
  void *s512c3f44[2];
  ::S28C40 s512c3f45;
  int s512c3f46;
  ::S28C18_nt s512c3f47;
  virtual  ~S512C3(); // _ZN6S512C3D1Ev
  virtual void  v232(); // _ZN6S512C34v232Ev
  virtual void  v233(); // _ZN6S512C34v233Ev
  virtual void  v234(); // _ZN6S512C34v234Ev
  virtual void  v235(); // _ZN6S512C34v235Ev
  virtual void  v236(); // _ZN6S512C34v236Ev
  virtual void  v237(); // _ZN6S512C34v237Ev
  virtual void  v238(); // _ZN6S512C34v238Ev
  virtual void  v239(); // _ZN6S512C34v239Ev
  virtual void  v240(); // _ZN6S512C34v240Ev
  virtual void  v241(); // _ZN6S512C34v241Ev
  virtual void  v242(); // _ZN6S512C34v242Ev
  virtual void  v243(); // _ZN6S512C34v243Ev
  virtual void  v244(); // _ZN6S512C34v244Ev
  virtual void  v245(); // _ZN6S512C34v245Ev
  virtual void  v246(); // _ZN6S512C34v246Ev
  virtual void  v247(); // _ZN6S512C34v247Ev
  virtual void  v248(); // _ZN6S512C34v248Ev
  virtual void  v249(); // _ZN6S512C34v249Ev
  virtual void  v250(); // _ZN6S512C34v250Ev
  virtual void  v251(); // _ZN6S512C34v251Ev
  virtual void  v252(); // _ZN6S512C34v252Ev
  virtual void  v253(); // _ZN6S512C34v253Ev
  virtual void  v254(); // _ZN6S512C34v254Ev
  virtual void  v255(); // _ZN6S512C34v255Ev
  virtual void  v256(); // _ZN6S512C34v256Ev
  virtual void  v257(); // _ZN6S512C34v257Ev
  virtual void  v258(); // _ZN6S512C34v258Ev
  virtual void  v259(); // _ZN6S512C34v259Ev
  virtual void  v260(); // _ZN6S512C34v260Ev
  virtual void  v261(); // _ZN6S512C34v261Ev
  virtual void  v262(); // _ZN6S512C34v262Ev
  virtual void  v263(); // _ZN6S512C34v263Ev
  virtual void  v264(); // _ZN6S512C34v264Ev
  virtual void  v265(); // _ZN6S512C34v265Ev
  virtual void  v266(); // _ZN6S512C34v266Ev
  virtual void  v267(); // _ZN6S512C34v267Ev
  virtual void  v268(); // _ZN6S512C34v268Ev
  virtual void  v269(); // _ZN6S512C34v269Ev
  virtual void  v270(); // _ZN6S512C34v270Ev
  virtual void  v271(); // _ZN6S512C34v271Ev
  virtual void  v272(); // _ZN6S512C34v272Ev
  virtual void  v273(); // _ZN6S512C34v273Ev
  virtual void  v274(); // _ZN6S512C34v274Ev
  virtual void  v275(); // _ZN6S512C34v275Ev
  virtual void  v276(); // _ZN6S512C34v276Ev
  virtual void  v277(); // _ZN6S512C34v277Ev
  virtual void  v278(); // _ZN6S512C34v278Ev
  virtual void  v279(); // _ZN6S512C34v279Ev
  virtual void  v280(); // _ZN6S512C34v280Ev
  virtual void  v281(); // _ZN6S512C34v281Ev
  S512C3(); // tgen
};
//SIG(-1 S512C3) C1{ BC2{ BC3{ vd v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC9{ BC10{ BC7}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC11{ BC12{ BC7}} FC11 Fi Fp[2] FC13{ m Fi[3]} FC14{ m Fi[3]} FC13 FC13 Fp FC4 FC11 FC13 FC14 Fi FC13 FC13 Fp Fi Fc FC14 FC14 Fp Fi Fp FC15{ BC16{ BC7}} FC17{ BC18{ BC7}} FC19{ BC20{ BC7}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC13 FC13 Fp[5] FC13 Fp FC21{ BC22{ BC7}} Fp[2] FC13 Fp Fi[2] Fp Fi FC13 FC13 FC13 Fp[2] Fi FC13 Fi[4] Fp[2] FC23{ BC24{ BC7}} Fi FC14}


 S512C3 ::~S512C3(){ note_dtor("S512C3", this);}
void  S512C3 ::v232(){vfunc_called(this, "_ZN6S512C34v232Ev");}
void  S512C3 ::v233(){vfunc_called(this, "_ZN6S512C34v233Ev");}
void  S512C3 ::v234(){vfunc_called(this, "_ZN6S512C34v234Ev");}
void  S512C3 ::v235(){vfunc_called(this, "_ZN6S512C34v235Ev");}
void  S512C3 ::v236(){vfunc_called(this, "_ZN6S512C34v236Ev");}
void  S512C3 ::v237(){vfunc_called(this, "_ZN6S512C34v237Ev");}
void  S512C3 ::v238(){vfunc_called(this, "_ZN6S512C34v238Ev");}
void  S512C3 ::v239(){vfunc_called(this, "_ZN6S512C34v239Ev");}
void  S512C3 ::v240(){vfunc_called(this, "_ZN6S512C34v240Ev");}
void  S512C3 ::v241(){vfunc_called(this, "_ZN6S512C34v241Ev");}
void  S512C3 ::v242(){vfunc_called(this, "_ZN6S512C34v242Ev");}
void  S512C3 ::v243(){vfunc_called(this, "_ZN6S512C34v243Ev");}
void  S512C3 ::v244(){vfunc_called(this, "_ZN6S512C34v244Ev");}
void  S512C3 ::v245(){vfunc_called(this, "_ZN6S512C34v245Ev");}
void  S512C3 ::v246(){vfunc_called(this, "_ZN6S512C34v246Ev");}
void  S512C3 ::v247(){vfunc_called(this, "_ZN6S512C34v247Ev");}
void  S512C3 ::v248(){vfunc_called(this, "_ZN6S512C34v248Ev");}
void  S512C3 ::v249(){vfunc_called(this, "_ZN6S512C34v249Ev");}
void  S512C3 ::v250(){vfunc_called(this, "_ZN6S512C34v250Ev");}
void  S512C3 ::v251(){vfunc_called(this, "_ZN6S512C34v251Ev");}
void  S512C3 ::v252(){vfunc_called(this, "_ZN6S512C34v252Ev");}
void  S512C3 ::v253(){vfunc_called(this, "_ZN6S512C34v253Ev");}
void  S512C3 ::v254(){vfunc_called(this, "_ZN6S512C34v254Ev");}
void  S512C3 ::v255(){vfunc_called(this, "_ZN6S512C34v255Ev");}
void  S512C3 ::v256(){vfunc_called(this, "_ZN6S512C34v256Ev");}
void  S512C3 ::v257(){vfunc_called(this, "_ZN6S512C34v257Ev");}
void  S512C3 ::v258(){vfunc_called(this, "_ZN6S512C34v258Ev");}
void  S512C3 ::v259(){vfunc_called(this, "_ZN6S512C34v259Ev");}
void  S512C3 ::v260(){vfunc_called(this, "_ZN6S512C34v260Ev");}
void  S512C3 ::v261(){vfunc_called(this, "_ZN6S512C34v261Ev");}
void  S512C3 ::v262(){vfunc_called(this, "_ZN6S512C34v262Ev");}
void  S512C3 ::v263(){vfunc_called(this, "_ZN6S512C34v263Ev");}
void  S512C3 ::v264(){vfunc_called(this, "_ZN6S512C34v264Ev");}
void  S512C3 ::v265(){vfunc_called(this, "_ZN6S512C34v265Ev");}
void  S512C3 ::v266(){vfunc_called(this, "_ZN6S512C34v266Ev");}
void  S512C3 ::v267(){vfunc_called(this, "_ZN6S512C34v267Ev");}
void  S512C3 ::v268(){vfunc_called(this, "_ZN6S512C34v268Ev");}
void  S512C3 ::v269(){vfunc_called(this, "_ZN6S512C34v269Ev");}
void  S512C3 ::v270(){vfunc_called(this, "_ZN6S512C34v270Ev");}
void  S512C3 ::v271(){vfunc_called(this, "_ZN6S512C34v271Ev");}
void  S512C3 ::v272(){vfunc_called(this, "_ZN6S512C34v272Ev");}
void  S512C3 ::v273(){vfunc_called(this, "_ZN6S512C34v273Ev");}
void  S512C3 ::v274(){vfunc_called(this, "_ZN6S512C34v274Ev");}
void  S512C3 ::v275(){vfunc_called(this, "_ZN6S512C34v275Ev");}
void  S512C3 ::v276(){vfunc_called(this, "_ZN6S512C34v276Ev");}
void  S512C3 ::v277(){vfunc_called(this, "_ZN6S512C34v277Ev");}
void  S512C3 ::v278(){vfunc_called(this, "_ZN6S512C34v278Ev");}
void  S512C3 ::v279(){vfunc_called(this, "_ZN6S512C34v279Ev");}
void  S512C3 ::v280(){vfunc_called(this, "_ZN6S512C34v280Ev");}
void  S512C3 ::v281(){vfunc_called(this, "_ZN6S512C34v281Ev");}
S512C3 ::S512C3(){ note_ctor("S512C3", this);} // tgen

static void Test_S512C3()
{
  extern Class_Descriptor cd_S512C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(116,174)];
    init_test(&cd_S512C3, buf);
    S512C3 *dp, &lv = *(dp=new (buf) S512C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(920,692), "sizeof(S512C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S512C3)");
    check_base_class_offset(lv, (S512C5*)(S512C4*), 0, "S512C3");
    check_base_class_offset(lv, (S512C4*), 0, "S512C3");
    check_field_offset(lv, s512c3f0, ABISELECT(568,436), "S512C3.s512c3f0");
    check_field_offset(lv, s512c3f1, ABISELECT(584,444), "S512C3.s512c3f1");
    check_field_offset(lv, s512c3f2, ABISELECT(592,448), "S512C3.s512c3f2");
    set_bf_and_test(lv, s512c3f3, ABISELECT(600,452), 0, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f4, ABISELECT(600,452), 1, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f5, ABISELECT(600,452), 2, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f6, ABISELECT(600,452), 3, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f7, ABISELECT(600,452), 4, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f8, ABISELECT(600,452), 5, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f9, ABISELECT(600,452), 6, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f10, ABISELECT(600,452), 7, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f11, ABISELECT(601,453), 0, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f12, ABISELECT(601,453), 1, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f13, ABISELECT(601,453), 2, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f14, ABISELECT(601,453), 3, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f15, ABISELECT(601,453), 4, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f16, ABISELECT(601,453), 5, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f17, ABISELECT(601,453), 6, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f18, ABISELECT(601,453), 7, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f19, ABISELECT(602,454), 0, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f20, ABISELECT(602,454), 1, 1, 1, "S512C3");
    set_bf_and_test(lv, s512c3f21, ABISELECT(602,454), 2, 1, 1, "S512C3");
    check_field_offset(lv, s512c3f22, ABISELECT(603,455), "S512C3.s512c3f22");
    check_field_offset(lv, s512c3f23, ABISELECT(604,456), "S512C3.s512c3f23");
    check_field_offset(lv, s512c3f24, ABISELECT(616,464), "S512C3.s512c3f24");
    check_field_offset(lv, s512c3f25, ABISELECT(624,468), "S512C3.s512c3f25");
    check_field_offset(lv, s512c3f26, ABISELECT(636,480), "S512C3.s512c3f26");
    check_field_offset(lv, s512c3f27, ABISELECT(648,492), "S512C3.s512c3f27");
    check_field_offset(lv, s512c3f28, ABISELECT(688,512), "S512C3.s512c3f28");
    check_field_offset(lv, s512c3f29, ABISELECT(704,524), "S512C3.s512c3f29");
    check_field_offset(lv, s512c3f30, ABISELECT(712,528), "S512C3.s512c3f30");
    check_field_offset(lv, s512c3f31, ABISELECT(728,540), "S512C3.s512c3f31");
    check_field_offset(lv, s512c3f32, ABISELECT(744,548), "S512C3.s512c3f32");
    check_field_offset(lv, s512c3f33, ABISELECT(760,560), "S512C3.s512c3f33");
    check_field_offset(lv, s512c3f34, ABISELECT(768,564), "S512C3.s512c3f34");
    check_field_offset(lv, s512c3f35, ABISELECT(776,572), "S512C3.s512c3f35");
    check_field_offset(lv, s512c3f36, ABISELECT(784,576), "S512C3.s512c3f36");
    check_field_offset(lv, s512c3f37, ABISELECT(788,580), "S512C3.s512c3f37");
    check_field_offset(lv, s512c3f38, ABISELECT(800,592), "S512C3.s512c3f38");
    check_field_offset(lv, s512c3f39, ABISELECT(812,604), "S512C3.s512c3f39");
    check_field_offset(lv, s512c3f40, ABISELECT(824,616), "S512C3.s512c3f40");
    check_field_offset(lv, s512c3f41, ABISELECT(840,624), "S512C3.s512c3f41");
    check_field_offset(lv, s512c3f42, ABISELECT(844,628), "S512C3.s512c3f42");
    check_field_offset(lv, s512c3f43, ABISELECT(856,640), "S512C3.s512c3f43");
    check_field_offset(lv, s512c3f44, ABISELECT(872,656), "S512C3.s512c3f44");
    check_field_offset(lv, s512c3f45, ABISELECT(888,664), "S512C3.s512c3f45");
    check_field_offset(lv, s512c3f46, ABISELECT(904,676), "S512C3.s512c3f46");
    check_field_offset(lv, s512c3f47, ABISELECT(908,680), "S512C3.s512c3f47");
    test_class_info(&lv, &cd_S512C3);
    dp->~S512C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS512C3(Test_S512C3, "S512C3", ABISELECT(920,692));

#else // __cplusplus

extern void _ZN6S512C3C1Ev();
extern void _ZN6S512C3D1Ev();
Name_Map name_map_S512C3[] = {
  NSPAIR(_ZN6S512C3C1Ev),
  NSPAIR(_ZN6S512C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S512C5;
extern VTBL_ENTRY _ZTI6S512C5[];
extern  VTBL_ENTRY _ZTV6S512C5[];
extern Class_Descriptor cd_S512C4;
extern VTBL_ENTRY _ZTI6S512C4[];
extern  VTBL_ENTRY _ZTV6S512C4[];
static Base_Class bases_S512C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S512C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S512C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S512C3[];
extern void _ZN6S512C3D1Ev();
extern void _ZN6S512C3D0Ev();
extern void _ZN6S512C53v25Ev();
extern void _ZN6S512C53v26Ev();
extern void _ZN6S512C53v27Ev();
extern void _ZN6S512C53v28Ev();
extern void _ZN6S512C53v29Ev();
extern void _ZN6S512C53v30Ev();
extern void _ZN6S512C53v31Ev();
extern void _ZN6S512C53v32Ev();
extern void _ZN6S512C53v33Ev();
extern void _ZN6S512C53v34Ev();
extern void _ZN6S512C53v35Ev();
extern void _ZN6S512C53v36Ev();
extern void _ZN6S512C53v37Ev();
extern void _ZN6S512C53v38Ev();
extern void _ZN6S512C53v39Ev();
extern void _ZN6S512C53v40Ev();
extern void _ZN6S512C53v41Ev();
extern void _ZN6S512C53v42Ev();
extern void _ZN6S512C53v43Ev();
extern void _ZN6S512C53v44Ev();
extern void _ZN6S512C53v45Ev();
extern void _ZN6S512C53v46Ev();
extern void _ZN6S512C53v47Ev();
extern void _ZN6S512C53v48Ev();
extern void _ZN6S512C53v49Ev();
extern void _ZN6S512C53v50Ev();
extern void _ZN6S512C53v51Ev();
extern void _ZN6S512C53v52Ev();
extern void _ZN6S512C53v53Ev();
extern void _ZN6S512C53v54Ev();
extern void _ZN6S512C53v55Ev();
extern void _ZN6S512C53v56Ev();
extern void _ZN6S512C53v57Ev();
extern void _ZN6S512C53v58Ev();
extern void _ZN6S512C53v59Ev();
extern void _ZN6S512C53v60Ev();
extern void _ZN6S512C53v61Ev();
extern void _ZN6S512C53v62Ev();
extern void _ZN6S512C53v63Ev();
extern void _ZN6S512C53v64Ev();
extern void _ZN6S512C53v65Ev();
extern void _ZN6S512C53v66Ev();
extern void _ZN6S512C53v67Ev();
extern void _ZN6S512C53v68Ev();
extern void _ZN6S512C53v69Ev();
extern void _ZN6S512C53v70Ev();
extern void _ZN6S512C53v71Ev();
extern void _ZN6S512C53v72Ev();
extern void _ZN6S512C53v73Ev();
extern void _ZN6S512C53v74Ev();
extern void _ZN6S512C53v75Ev();
extern void _ZN6S512C53v76Ev();
extern void _ZN6S512C53v77Ev();
extern void _ZN6S512C53v78Ev();
extern void _ZN6S512C53v79Ev();
extern void _ZN6S512C53v80Ev();
extern void _ZN6S512C53v81Ev();
extern void _ZN6S512C53v82Ev();
extern void _ZN6S512C53v83Ev();
extern void _ZN6S512C53v84Ev();
extern void _ZN6S512C53v85Ev();
extern void _ZN6S512C53v86Ev();
extern void _ZN6S512C53v87Ev();
extern void _ZN6S512C53v88Ev();
extern void _ZN6S512C43v89Ev();
extern void _ZN6S512C43v90Ev();
extern void _ZN6S512C43v91Ev();
extern void _ZN6S512C43v92Ev();
extern void _ZN6S512C43v93Ev();
extern void _ZN6S512C43v94Ev();
extern void _ZN6S512C43v95Ev();
extern void _ZN6S512C43v96Ev();
extern void _ZN6S512C43v97Ev();
extern void _ZN6S512C43v98Ev();
extern void _ZN6S512C43v99Ev();
extern void _ZN6S512C44v100Ev();
extern void _ZN6S512C44v101Ev();
extern void _ZN6S512C44v102Ev();
extern void _ZN6S512C44v103Ev();
extern void _ZN6S512C44v104Ev();
extern void _ZN6S512C44v105Ev();
extern void _ZN6S512C44v106Ev();
extern void _ZN6S512C44v107Ev();
extern void _ZN6S512C44v108Ev();
extern void _ZN6S512C44v109Ev();
extern void _ZN6S512C44v110Ev();
extern void _ZN6S512C44v111Ev();
extern void _ZN6S512C44v112Ev();
extern void _ZN6S512C44v113Ev();
extern void _ZN6S512C44v114Ev();
extern void _ZN6S512C44v115Ev();
extern void _ZN6S512C44v116Ev();
extern void _ZN6S512C44v117Ev();
extern void _ZN6S512C44v118Ev();
extern void _ZN6S512C44v119Ev();
extern void _ZN6S512C44v120Ev();
extern void _ZN6S512C44v121Ev();
extern void _ZN6S512C44v122Ev();
extern void _ZN6S512C44v123Ev();
extern void _ZN6S512C44v124Ev();
extern void _ZN6S512C44v125Ev();
extern void _ZN6S512C44v126Ev();
extern void _ZN6S512C44v127Ev();
extern void _ZN6S512C44v128Ev();
extern void _ZN6S512C44v129Ev();
extern void _ZN6S512C44v130Ev();
extern void _ZN6S512C44v131Ev();
extern void _ZN6S512C44v132Ev();
extern void _ZN6S512C44v133Ev();
extern void _ZN6S512C44v134Ev();
extern void _ZN6S512C44v135Ev();
extern void _ZN6S512C44v136Ev();
extern void _ZN6S512C44v137Ev();
extern void _ZN6S512C44v138Ev();
extern void _ZN6S512C44v139Ev();
extern void _ZN6S512C44v140Ev();
extern void _ZN6S512C44v141Ev();
extern void _ZN6S512C44v142Ev();
extern void _ZN6S512C44v143Ev();
extern void _ZN6S512C44v144Ev();
extern void _ZN6S512C44v145Ev();
extern void _ZN6S512C44v146Ev();
extern void _ZN6S512C44v147Ev();
extern void _ZN6S512C44v148Ev();
extern void _ZN6S512C44v149Ev();
extern void _ZN6S512C44v150Ev();
extern void _ZN6S512C44v151Ev();
extern void _ZN6S512C44v152Ev();
extern void _ZN6S512C44v153Ev();
extern void _ZN6S512C44v154Ev();
extern void _ZN6S512C44v155Ev();
extern void _ZN6S512C44v156Ev();
extern void _ZN6S512C44v157Ev();
extern void _ZN6S512C44v158Ev();
extern void _ZN6S512C44v159Ev();
extern void _ZN6S512C44v160Ev();
extern void _ZN6S512C44v161Ev();
extern void _ZN6S512C44v162Ev();
extern void _ZN6S512C44v163Ev();
extern void _ZN6S512C44v164Ev();
extern void _ZN6S512C44v165Ev();
extern void _ZN6S512C44v166Ev();
extern void _ZN6S512C44v167Ev();
extern void _ZN6S512C44v168Ev();
extern void _ZN6S512C44v169Ev();
extern void _ZN6S512C44v170Ev();
extern void _ZN6S512C44v171Ev();
extern void _ZN6S512C44v172Ev();
extern void _ZN6S512C44v173Ev();
extern void _ZN6S512C44v174Ev();
extern void _ZN6S512C44v175Ev();
extern void _ZN6S512C44v176Ev();
extern void _ZN6S512C44v177Ev();
extern void _ZN6S512C44v178Ev();
extern void _ZN6S512C44v179Ev();
extern void _ZN6S512C44v180Ev();
extern void _ZN6S512C44v181Ev();
extern void _ZN6S512C44v182Ev();
extern void _ZN6S512C44v183Ev();
extern void _ZN6S512C44v184Ev();
extern void _ZN6S512C44v185Ev();
extern void _ZN6S512C44v186Ev();
extern void _ZN6S512C44v187Ev();
extern void _ZN6S512C44v188Ev();
extern void _ZN6S512C44v189Ev();
extern void _ZN6S512C44v190Ev();
extern void _ZN6S512C44v191Ev();
extern void _ZN6S512C44v192Ev();
extern void _ZN6S512C44v193Ev();
extern void _ZN6S512C44v194Ev();
extern void _ZN6S512C44v195Ev();
extern void _ZN6S512C44v196Ev();
extern void _ZN6S512C44v197Ev();
extern void _ZN6S512C44v198Ev();
extern void _ZN6S512C44v199Ev();
extern void _ZN6S512C44v200Ev();
extern void _ZN6S512C44v201Ev();
extern void _ZN6S512C44v202Ev();
extern void _ZN6S512C44v203Ev();
extern void _ZN6S512C44v204Ev();
extern void _ZN6S512C44v205Ev();
extern void _ZN6S512C44v206Ev();
extern void _ZN6S512C44v207Ev();
extern void _ZN6S512C44v208Ev();
extern void _ZN6S512C44v209Ev();
extern void _ZN6S512C44v210Ev();
extern void _ZN6S512C44v211Ev();
extern void _ZN6S512C44v212Ev();
extern void _ZN6S512C44v213Ev();
extern void _ZN6S512C44v214Ev();
extern void _ZN6S512C44v215Ev();
extern void _ZN6S512C44v216Ev();
extern void _ZN6S512C44v217Ev();
extern void _ZN6S512C44v218Ev();
extern void _ZN6S512C44v219Ev();
extern void _ZN6S512C44v220Ev();
extern void _ZN6S512C44v221Ev();
extern void _ZN6S512C44v222Ev();
extern void _ZN6S512C44v223Ev();
extern void _ZN6S512C44v224Ev();
extern void _ZN6S512C44v225Ev();
extern void _ZN6S512C44v226Ev();
extern void _ZN6S512C44v227Ev();
extern void _ZN6S512C44v228Ev();
extern void _ZN6S512C44v229Ev();
extern void _ZN6S512C44v230Ev();
extern void _ZN6S512C44v231Ev();
extern void _ZN6S512C34v232Ev();
extern void _ZN6S512C34v233Ev();
extern void _ZN6S512C34v234Ev();
extern void _ZN6S512C34v235Ev();
extern void _ZN6S512C34v236Ev();
extern void _ZN6S512C34v237Ev();
extern void _ZN6S512C34v238Ev();
extern void _ZN6S512C34v239Ev();
extern void _ZN6S512C34v240Ev();
extern void _ZN6S512C34v241Ev();
extern void _ZN6S512C34v242Ev();
extern void _ZN6S512C34v243Ev();
extern void _ZN6S512C34v244Ev();
extern void _ZN6S512C34v245Ev();
extern void _ZN6S512C34v246Ev();
extern void _ZN6S512C34v247Ev();
extern void _ZN6S512C34v248Ev();
extern void _ZN6S512C34v249Ev();
extern void _ZN6S512C34v250Ev();
extern void _ZN6S512C34v251Ev();
extern void _ZN6S512C34v252Ev();
extern void _ZN6S512C34v253Ev();
extern void _ZN6S512C34v254Ev();
extern void _ZN6S512C34v255Ev();
extern void _ZN6S512C34v256Ev();
extern void _ZN6S512C34v257Ev();
extern void _ZN6S512C34v258Ev();
extern void _ZN6S512C34v259Ev();
extern void _ZN6S512C34v260Ev();
extern void _ZN6S512C34v261Ev();
extern void _ZN6S512C34v262Ev();
extern void _ZN6S512C34v263Ev();
extern void _ZN6S512C34v264Ev();
extern void _ZN6S512C34v265Ev();
extern void _ZN6S512C34v266Ev();
extern void _ZN6S512C34v267Ev();
extern void _ZN6S512C34v268Ev();
extern void _ZN6S512C34v269Ev();
extern void _ZN6S512C34v270Ev();
extern void _ZN6S512C34v271Ev();
extern void _ZN6S512C34v272Ev();
extern void _ZN6S512C34v273Ev();
extern void _ZN6S512C34v274Ev();
extern void _ZN6S512C34v275Ev();
extern void _ZN6S512C34v276Ev();
extern void _ZN6S512C34v277Ev();
extern void _ZN6S512C34v278Ev();
extern void _ZN6S512C34v279Ev();
extern void _ZN6S512C34v280Ev();
extern void _ZN6S512C34v281Ev();
static  VTBL_ENTRY vtc_S512C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S512C3[0]),
  (VTBL_ENTRY)&_ZN6S512C3D1Ev,
  (VTBL_ENTRY)&_ZN6S512C3D0Ev,
  (VTBL_ENTRY)&_ZN6S512C53v25Ev,
  (VTBL_ENTRY)&_ZN6S512C53v26Ev,
  (VTBL_ENTRY)&_ZN6S512C53v27Ev,
  (VTBL_ENTRY)&_ZN6S512C53v28Ev,
  (VTBL_ENTRY)&_ZN6S512C53v29Ev,
  (VTBL_ENTRY)&_ZN6S512C53v30Ev,
  (VTBL_ENTRY)&_ZN6S512C53v31Ev,
  (VTBL_ENTRY)&_ZN6S512C53v32Ev,
  (VTBL_ENTRY)&_ZN6S512C53v33Ev,
  (VTBL_ENTRY)&_ZN6S512C53v34Ev,
  (VTBL_ENTRY)&_ZN6S512C53v35Ev,
  (VTBL_ENTRY)&_ZN6S512C53v36Ev,
  (VTBL_ENTRY)&_ZN6S512C53v37Ev,
  (VTBL_ENTRY)&_ZN6S512C53v38Ev,
  (VTBL_ENTRY)&_ZN6S512C53v39Ev,
  (VTBL_ENTRY)&_ZN6S512C53v40Ev,
  (VTBL_ENTRY)&_ZN6S512C53v41Ev,
  (VTBL_ENTRY)&_ZN6S512C53v42Ev,
  (VTBL_ENTRY)&_ZN6S512C53v43Ev,
  (VTBL_ENTRY)&_ZN6S512C53v44Ev,
  (VTBL_ENTRY)&_ZN6S512C53v45Ev,
  (VTBL_ENTRY)&_ZN6S512C53v46Ev,
  (VTBL_ENTRY)&_ZN6S512C53v47Ev,
  (VTBL_ENTRY)&_ZN6S512C53v48Ev,
  (VTBL_ENTRY)&_ZN6S512C53v49Ev,
  (VTBL_ENTRY)&_ZN6S512C53v50Ev,
  (VTBL_ENTRY)&_ZN6S512C53v51Ev,
  (VTBL_ENTRY)&_ZN6S512C53v52Ev,
  (VTBL_ENTRY)&_ZN6S512C53v53Ev,
  (VTBL_ENTRY)&_ZN6S512C53v54Ev,
  (VTBL_ENTRY)&_ZN6S512C53v55Ev,
  (VTBL_ENTRY)&_ZN6S512C53v56Ev,
  (VTBL_ENTRY)&_ZN6S512C53v57Ev,
  (VTBL_ENTRY)&_ZN6S512C53v58Ev,
  (VTBL_ENTRY)&_ZN6S512C53v59Ev,
  (VTBL_ENTRY)&_ZN6S512C53v60Ev,
  (VTBL_ENTRY)&_ZN6S512C53v61Ev,
  (VTBL_ENTRY)&_ZN6S512C53v62Ev,
  (VTBL_ENTRY)&_ZN6S512C53v63Ev,
  (VTBL_ENTRY)&_ZN6S512C53v64Ev,
  (VTBL_ENTRY)&_ZN6S512C53v65Ev,
  (VTBL_ENTRY)&_ZN6S512C53v66Ev,
  (VTBL_ENTRY)&_ZN6S512C53v67Ev,
  (VTBL_ENTRY)&_ZN6S512C53v68Ev,
  (VTBL_ENTRY)&_ZN6S512C53v69Ev,
  (VTBL_ENTRY)&_ZN6S512C53v70Ev,
  (VTBL_ENTRY)&_ZN6S512C53v71Ev,
  (VTBL_ENTRY)&_ZN6S512C53v72Ev,
  (VTBL_ENTRY)&_ZN6S512C53v73Ev,
  (VTBL_ENTRY)&_ZN6S512C53v74Ev,
  (VTBL_ENTRY)&_ZN6S512C53v75Ev,
  (VTBL_ENTRY)&_ZN6S512C53v76Ev,
  (VTBL_ENTRY)&_ZN6S512C53v77Ev,
  (VTBL_ENTRY)&_ZN6S512C53v78Ev,
  (VTBL_ENTRY)&_ZN6S512C53v79Ev,
  (VTBL_ENTRY)&_ZN6S512C53v80Ev,
  (VTBL_ENTRY)&_ZN6S512C53v81Ev,
  (VTBL_ENTRY)&_ZN6S512C53v82Ev,
  (VTBL_ENTRY)&_ZN6S512C53v83Ev,
  (VTBL_ENTRY)&_ZN6S512C53v84Ev,
  (VTBL_ENTRY)&_ZN6S512C53v85Ev,
  (VTBL_ENTRY)&_ZN6S512C53v86Ev,
  (VTBL_ENTRY)&_ZN6S512C53v87Ev,
  (VTBL_ENTRY)&_ZN6S512C53v88Ev,
  (VTBL_ENTRY)&_ZN6S512C43v89Ev,
  (VTBL_ENTRY)&_ZN6S512C43v90Ev,
  (VTBL_ENTRY)&_ZN6S512C43v91Ev,
  (VTBL_ENTRY)&_ZN6S512C43v92Ev,
  (VTBL_ENTRY)&_ZN6S512C43v93Ev,
  (VTBL_ENTRY)&_ZN6S512C43v94Ev,
  (VTBL_ENTRY)&_ZN6S512C43v95Ev,
  (VTBL_ENTRY)&_ZN6S512C43v96Ev,
  (VTBL_ENTRY)&_ZN6S512C43v97Ev,
  (VTBL_ENTRY)&_ZN6S512C43v98Ev,
  (VTBL_ENTRY)&_ZN6S512C43v99Ev,
  (VTBL_ENTRY)&_ZN6S512C44v100Ev,
  (VTBL_ENTRY)&_ZN6S512C44v101Ev,
  (VTBL_ENTRY)&_ZN6S512C44v102Ev,
  (VTBL_ENTRY)&_ZN6S512C44v103Ev,
  (VTBL_ENTRY)&_ZN6S512C44v104Ev,
  (VTBL_ENTRY)&_ZN6S512C44v105Ev,
  (VTBL_ENTRY)&_ZN6S512C44v106Ev,
  (VTBL_ENTRY)&_ZN6S512C44v107Ev,
  (VTBL_ENTRY)&_ZN6S512C44v108Ev,
  (VTBL_ENTRY)&_ZN6S512C44v109Ev,
  (VTBL_ENTRY)&_ZN6S512C44v110Ev,
  (VTBL_ENTRY)&_ZN6S512C44v111Ev,
  (VTBL_ENTRY)&_ZN6S512C44v112Ev,
  (VTBL_ENTRY)&_ZN6S512C44v113Ev,
  (VTBL_ENTRY)&_ZN6S512C44v114Ev,
  (VTBL_ENTRY)&_ZN6S512C44v115Ev,
  (VTBL_ENTRY)&_ZN6S512C44v116Ev,
  (VTBL_ENTRY)&_ZN6S512C44v117Ev,
  (VTBL_ENTRY)&_ZN6S512C44v118Ev,
  (VTBL_ENTRY)&_ZN6S512C44v119Ev,
  (VTBL_ENTRY)&_ZN6S512C44v120Ev,
  (VTBL_ENTRY)&_ZN6S512C44v121Ev,
  (VTBL_ENTRY)&_ZN6S512C44v122Ev,
  (VTBL_ENTRY)&_ZN6S512C44v123Ev,
  (VTBL_ENTRY)&_ZN6S512C44v124Ev,
  (VTBL_ENTRY)&_ZN6S512C44v125Ev,
  (VTBL_ENTRY)&_ZN6S512C44v126Ev,
  (VTBL_ENTRY)&_ZN6S512C44v127Ev,
  (VTBL_ENTRY)&_ZN6S512C44v128Ev,
  (VTBL_ENTRY)&_ZN6S512C44v129Ev,
  (VTBL_ENTRY)&_ZN6S512C44v130Ev,
  (VTBL_ENTRY)&_ZN6S512C44v131Ev,
  (VTBL_ENTRY)&_ZN6S512C44v132Ev,
  (VTBL_ENTRY)&_ZN6S512C44v133Ev,
  (VTBL_ENTRY)&_ZN6S512C44v134Ev,
  (VTBL_ENTRY)&_ZN6S512C44v135Ev,
  (VTBL_ENTRY)&_ZN6S512C44v136Ev,
  (VTBL_ENTRY)&_ZN6S512C44v137Ev,
  (VTBL_ENTRY)&_ZN6S512C44v138Ev,
  (VTBL_ENTRY)&_ZN6S512C44v139Ev,
  (VTBL_ENTRY)&_ZN6S512C44v140Ev,
  (VTBL_ENTRY)&_ZN6S512C44v141Ev,
  (VTBL_ENTRY)&_ZN6S512C44v142Ev,
  (VTBL_ENTRY)&_ZN6S512C44v143Ev,
  (VTBL_ENTRY)&_ZN6S512C44v144Ev,
  (VTBL_ENTRY)&_ZN6S512C44v145Ev,
  (VTBL_ENTRY)&_ZN6S512C44v146Ev,
  (VTBL_ENTRY)&_ZN6S512C44v147Ev,
  (VTBL_ENTRY)&_ZN6S512C44v148Ev,
  (VTBL_ENTRY)&_ZN6S512C44v149Ev,
  (VTBL_ENTRY)&_ZN6S512C44v150Ev,
  (VTBL_ENTRY)&_ZN6S512C44v151Ev,
  (VTBL_ENTRY)&_ZN6S512C44v152Ev,
  (VTBL_ENTRY)&_ZN6S512C44v153Ev,
  (VTBL_ENTRY)&_ZN6S512C44v154Ev,
  (VTBL_ENTRY)&_ZN6S512C44v155Ev,
  (VTBL_ENTRY)&_ZN6S512C44v156Ev,
  (VTBL_ENTRY)&_ZN6S512C44v157Ev,
  (VTBL_ENTRY)&_ZN6S512C44v158Ev,
  (VTBL_ENTRY)&_ZN6S512C44v159Ev,
  (VTBL_ENTRY)&_ZN6S512C44v160Ev,
  (VTBL_ENTRY)&_ZN6S512C44v161Ev,
  (VTBL_ENTRY)&_ZN6S512C44v162Ev,
  (VTBL_ENTRY)&_ZN6S512C44v163Ev,
  (VTBL_ENTRY)&_ZN6S512C44v164Ev,
  (VTBL_ENTRY)&_ZN6S512C44v165Ev,
  (VTBL_ENTRY)&_ZN6S512C44v166Ev,
  (VTBL_ENTRY)&_ZN6S512C44v167Ev,
  (VTBL_ENTRY)&_ZN6S512C44v168Ev,
  (VTBL_ENTRY)&_ZN6S512C44v169Ev,
  (VTBL_ENTRY)&_ZN6S512C44v170Ev,
  (VTBL_ENTRY)&_ZN6S512C44v171Ev,
  (VTBL_ENTRY)&_ZN6S512C44v172Ev,
  (VTBL_ENTRY)&_ZN6S512C44v173Ev,
  (VTBL_ENTRY)&_ZN6S512C44v174Ev,
  (VTBL_ENTRY)&_ZN6S512C44v175Ev,
  (VTBL_ENTRY)&_ZN6S512C44v176Ev,
  (VTBL_ENTRY)&_ZN6S512C44v177Ev,
  (VTBL_ENTRY)&_ZN6S512C44v178Ev,
  (VTBL_ENTRY)&_ZN6S512C44v179Ev,
  (VTBL_ENTRY)&_ZN6S512C44v180Ev,
  (VTBL_ENTRY)&_ZN6S512C44v181Ev,
  (VTBL_ENTRY)&_ZN6S512C44v182Ev,
  (VTBL_ENTRY)&_ZN6S512C44v183Ev,
  (VTBL_ENTRY)&_ZN6S512C44v184Ev,
  (VTBL_ENTRY)&_ZN6S512C44v185Ev,
  (VTBL_ENTRY)&_ZN6S512C44v186Ev,
  (VTBL_ENTRY)&_ZN6S512C44v187Ev,
  (VTBL_ENTRY)&_ZN6S512C44v188Ev,
  (VTBL_ENTRY)&_ZN6S512C44v189Ev,
  (VTBL_ENTRY)&_ZN6S512C44v190Ev,
  (VTBL_ENTRY)&_ZN6S512C44v191Ev,
  (VTBL_ENTRY)&_ZN6S512C44v192Ev,
  (VTBL_ENTRY)&_ZN6S512C44v193Ev,
  (VTBL_ENTRY)&_ZN6S512C44v194Ev,
  (VTBL_ENTRY)&_ZN6S512C44v195Ev,
  (VTBL_ENTRY)&_ZN6S512C44v196Ev,
  (VTBL_ENTRY)&_ZN6S512C44v197Ev,
  (VTBL_ENTRY)&_ZN6S512C44v198Ev,
  (VTBL_ENTRY)&_ZN6S512C44v199Ev,
  (VTBL_ENTRY)&_ZN6S512C44v200Ev,
  (VTBL_ENTRY)&_ZN6S512C44v201Ev,
  (VTBL_ENTRY)&_ZN6S512C44v202Ev,
  (VTBL_ENTRY)&_ZN6S512C44v203Ev,
  (VTBL_ENTRY)&_ZN6S512C44v204Ev,
  (VTBL_ENTRY)&_ZN6S512C44v205Ev,
  (VTBL_ENTRY)&_ZN6S512C44v206Ev,
  (VTBL_ENTRY)&_ZN6S512C44v207Ev,
  (VTBL_ENTRY)&_ZN6S512C44v208Ev,
  (VTBL_ENTRY)&_ZN6S512C44v209Ev,
  (VTBL_ENTRY)&_ZN6S512C44v210Ev,
  (VTBL_ENTRY)&_ZN6S512C44v211Ev,
  (VTBL_ENTRY)&_ZN6S512C44v212Ev,
  (VTBL_ENTRY)&_ZN6S512C44v213Ev,
  (VTBL_ENTRY)&_ZN6S512C44v214Ev,
  (VTBL_ENTRY)&_ZN6S512C44v215Ev,
  (VTBL_ENTRY)&_ZN6S512C44v216Ev,
  (VTBL_ENTRY)&_ZN6S512C44v217Ev,
  (VTBL_ENTRY)&_ZN6S512C44v218Ev,
  (VTBL_ENTRY)&_ZN6S512C44v219Ev,
  (VTBL_ENTRY)&_ZN6S512C44v220Ev,
  (VTBL_ENTRY)&_ZN6S512C44v221Ev,
  (VTBL_ENTRY)&_ZN6S512C44v222Ev,
  (VTBL_ENTRY)&_ZN6S512C44v223Ev,
  (VTBL_ENTRY)&_ZN6S512C44v224Ev,
  (VTBL_ENTRY)&_ZN6S512C44v225Ev,
  (VTBL_ENTRY)&_ZN6S512C44v226Ev,
  (VTBL_ENTRY)&_ZN6S512C44v227Ev,
  (VTBL_ENTRY)&_ZN6S512C44v228Ev,
  (VTBL_ENTRY)&_ZN6S512C44v229Ev,
  (VTBL_ENTRY)&_ZN6S512C44v230Ev,
  (VTBL_ENTRY)&_ZN6S512C44v231Ev,
  (VTBL_ENTRY)&_ZN6S512C34v232Ev,
  (VTBL_ENTRY)&_ZN6S512C34v233Ev,
  (VTBL_ENTRY)&_ZN6S512C34v234Ev,
  (VTBL_ENTRY)&_ZN6S512C34v235Ev,
  (VTBL_ENTRY)&_ZN6S512C34v236Ev,
  (VTBL_ENTRY)&_ZN6S512C34v237Ev,
  (VTBL_ENTRY)&_ZN6S512C34v238Ev,
  (VTBL_ENTRY)&_ZN6S512C34v239Ev,
  (VTBL_ENTRY)&_ZN6S512C34v240Ev,
  (VTBL_ENTRY)&_ZN6S512C34v241Ev,
  (VTBL_ENTRY)&_ZN6S512C34v242Ev,
  (VTBL_ENTRY)&_ZN6S512C34v243Ev,
  (VTBL_ENTRY)&_ZN6S512C34v244Ev,
  (VTBL_ENTRY)&_ZN6S512C34v245Ev,
  (VTBL_ENTRY)&_ZN6S512C34v246Ev,
  (VTBL_ENTRY)&_ZN6S512C34v247Ev,
  (VTBL_ENTRY)&_ZN6S512C34v248Ev,
  (VTBL_ENTRY)&_ZN6S512C34v249Ev,
  (VTBL_ENTRY)&_ZN6S512C34v250Ev,
  (VTBL_ENTRY)&_ZN6S512C34v251Ev,
  (VTBL_ENTRY)&_ZN6S512C34v252Ev,
  (VTBL_ENTRY)&_ZN6S512C34v253Ev,
  (VTBL_ENTRY)&_ZN6S512C34v254Ev,
  (VTBL_ENTRY)&_ZN6S512C34v255Ev,
  (VTBL_ENTRY)&_ZN6S512C34v256Ev,
  (VTBL_ENTRY)&_ZN6S512C34v257Ev,
  (VTBL_ENTRY)&_ZN6S512C34v258Ev,
  (VTBL_ENTRY)&_ZN6S512C34v259Ev,
  (VTBL_ENTRY)&_ZN6S512C34v260Ev,
  (VTBL_ENTRY)&_ZN6S512C34v261Ev,
  (VTBL_ENTRY)&_ZN6S512C34v262Ev,
  (VTBL_ENTRY)&_ZN6S512C34v263Ev,
  (VTBL_ENTRY)&_ZN6S512C34v264Ev,
  (VTBL_ENTRY)&_ZN6S512C34v265Ev,
  (VTBL_ENTRY)&_ZN6S512C34v266Ev,
  (VTBL_ENTRY)&_ZN6S512C34v267Ev,
  (VTBL_ENTRY)&_ZN6S512C34v268Ev,
  (VTBL_ENTRY)&_ZN6S512C34v269Ev,
  (VTBL_ENTRY)&_ZN6S512C34v270Ev,
  (VTBL_ENTRY)&_ZN6S512C34v271Ev,
  (VTBL_ENTRY)&_ZN6S512C34v272Ev,
  (VTBL_ENTRY)&_ZN6S512C34v273Ev,
  (VTBL_ENTRY)&_ZN6S512C34v274Ev,
  (VTBL_ENTRY)&_ZN6S512C34v275Ev,
  (VTBL_ENTRY)&_ZN6S512C34v276Ev,
  (VTBL_ENTRY)&_ZN6S512C34v277Ev,
  (VTBL_ENTRY)&_ZN6S512C34v278Ev,
  (VTBL_ENTRY)&_ZN6S512C34v279Ev,
  (VTBL_ENTRY)&_ZN6S512C34v280Ev,
  (VTBL_ENTRY)&_ZN6S512C34v281Ev,
};
extern VTBL_ENTRY _ZTI6S512C3[];
extern  VTBL_ENTRY _ZTV6S512C3[];
Class_Descriptor cd_S512C3 = {  "S512C3", // class name
  bases_S512C3, 2,
  &(vtc_S512C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(920,692), // object size
  NSPAIRA(_ZTI6S512C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S512C3),261, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S512C2  : S512C3 {
  unsigned int s512c2f0:1;
  unsigned int s512c2f1:1;
  unsigned int s512c2f2:1;
  int s512c2f3;
  void *s512c2f4[2];
  int s512c2f5;
  void *s512c2f6;
  virtual  ~S512C2(); // _ZN6S512C2D1Ev
  virtual void  v282(); // _ZN6S512C24v282Ev
  virtual void  v283(); // _ZN6S512C24v283Ev
  virtual void  v284(); // _ZN6S512C24v284Ev
  virtual void  v285(); // _ZN6S512C24v285Ev
  virtual void  v286(); // _ZN6S512C24v286Ev
  virtual void  v287(); // _ZN6S512C24v287Ev
  S512C2(); // tgen
};
//SIG(-1 S512C2) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC10{ BC11{ BC8}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC12{ BC13{ BC8}} FC12 Fi Fp[2] FC14{ m Fi[3]} FC15{ m Fi[3]} FC14 FC14 Fp FC5 FC12 FC14 FC15 Fi FC14 FC14 Fp Fi Fc FC15 FC15 Fp Fi Fp FC16{ BC17{ BC8}} FC18{ BC19{ BC8}} FC20{ BC21{ BC8}}} vd v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC14 FC14 Fp[5] FC14 Fp FC22{ BC23{ BC8}} Fp[2] FC14 Fp Fi[2] Fp Fi FC14 FC14 FC14 Fp[2] Fi FC14 Fi[4] Fp[2] FC24{ BC25{ BC8}} Fi FC15} vd v1 v2 v3 v4 v5 v6 Fi:1 Fi:1 Fi:1 Fi Fp[2] Fi Fp}


 S512C2 ::~S512C2(){ note_dtor("S512C2", this);}
void  S512C2 ::v282(){vfunc_called(this, "_ZN6S512C24v282Ev");}
void  S512C2 ::v283(){vfunc_called(this, "_ZN6S512C24v283Ev");}
void  S512C2 ::v284(){vfunc_called(this, "_ZN6S512C24v284Ev");}
void  S512C2 ::v285(){vfunc_called(this, "_ZN6S512C24v285Ev");}
void  S512C2 ::v286(){vfunc_called(this, "_ZN6S512C24v286Ev");}
void  S512C2 ::v287(){vfunc_called(this, "_ZN6S512C24v287Ev");}
S512C2 ::S512C2(){ note_ctor("S512C2", this);} // tgen

static void Test_S512C2()
{
  extern Class_Descriptor cd_S512C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(121,180)];
    init_test(&cd_S512C2, buf);
    S512C2 *dp, &lv = *(dp=new (buf) S512C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(960,716), "sizeof(S512C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S512C2)");
    check_base_class_offset(lv, (S512C5*)(S512C4*)(S512C3*), 0, "S512C2");
    check_base_class_offset(lv, (S512C4*)(S512C3*), 0, "S512C2");
    check_base_class_offset(lv, (S512C3*), 0, "S512C2");
    set_bf_and_test(lv, s512c2f0, ABISELECT(920,692), 0, 1, 1, "S512C2");
    set_bf_and_test(lv, s512c2f1, ABISELECT(920,692), 1, 1, 1, "S512C2");
    set_bf_and_test(lv, s512c2f2, ABISELECT(920,692), 2, 1, 1, "S512C2");
    check_field_offset(lv, s512c2f3, ABISELECT(924,696), "S512C2.s512c2f3");
    check_field_offset(lv, s512c2f4, ABISELECT(928,700), "S512C2.s512c2f4");
    check_field_offset(lv, s512c2f5, ABISELECT(944,708), "S512C2.s512c2f5");
    check_field_offset(lv, s512c2f6, ABISELECT(952,712), "S512C2.s512c2f6");
    test_class_info(&lv, &cd_S512C2);
    dp->~S512C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS512C2(Test_S512C2, "S512C2", ABISELECT(960,716));

#else // __cplusplus

extern void _ZN6S512C2C1Ev();
extern void _ZN6S512C2D1Ev();
Name_Map name_map_S512C2[] = {
  NSPAIR(_ZN6S512C2C1Ev),
  NSPAIR(_ZN6S512C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S512C5;
extern VTBL_ENTRY _ZTI6S512C5[];
extern  VTBL_ENTRY _ZTV6S512C5[];
extern Class_Descriptor cd_S512C4;
extern VTBL_ENTRY _ZTI6S512C4[];
extern  VTBL_ENTRY _ZTV6S512C4[];
extern Class_Descriptor cd_S512C3;
extern VTBL_ENTRY _ZTI6S512C3[];
extern  VTBL_ENTRY _ZTV6S512C3[];
static Base_Class bases_S512C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S512C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S512C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S512C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S512C2[];
extern void _ZN6S512C2D1Ev();
extern void _ZN6S512C2D0Ev();
extern void _ZN6S512C53v25Ev();
extern void _ZN6S512C53v26Ev();
extern void _ZN6S512C53v27Ev();
extern void _ZN6S512C53v28Ev();
extern void _ZN6S512C53v29Ev();
extern void _ZN6S512C53v30Ev();
extern void _ZN6S512C53v31Ev();
extern void _ZN6S512C53v32Ev();
extern void _ZN6S512C53v33Ev();
extern void _ZN6S512C53v34Ev();
extern void _ZN6S512C53v35Ev();
extern void _ZN6S512C53v36Ev();
extern void _ZN6S512C53v37Ev();
extern void _ZN6S512C53v38Ev();
extern void _ZN6S512C53v39Ev();
extern void _ZN6S512C53v40Ev();
extern void _ZN6S512C53v41Ev();
extern void _ZN6S512C53v42Ev();
extern void _ZN6S512C53v43Ev();
extern void _ZN6S512C53v44Ev();
extern void _ZN6S512C53v45Ev();
extern void _ZN6S512C53v46Ev();
extern void _ZN6S512C53v47Ev();
extern void _ZN6S512C53v48Ev();
extern void _ZN6S512C53v49Ev();
extern void _ZN6S512C53v50Ev();
extern void _ZN6S512C53v51Ev();
extern void _ZN6S512C53v52Ev();
extern void _ZN6S512C53v53Ev();
extern void _ZN6S512C53v54Ev();
extern void _ZN6S512C53v55Ev();
extern void _ZN6S512C53v56Ev();
extern void _ZN6S512C53v57Ev();
extern void _ZN6S512C53v58Ev();
extern void _ZN6S512C53v59Ev();
extern void _ZN6S512C53v60Ev();
extern void _ZN6S512C53v61Ev();
extern void _ZN6S512C53v62Ev();
extern void _ZN6S512C53v63Ev();
extern void _ZN6S512C53v64Ev();
extern void _ZN6S512C53v65Ev();
extern void _ZN6S512C53v66Ev();
extern void _ZN6S512C53v67Ev();
extern void _ZN6S512C53v68Ev();
extern void _ZN6S512C53v69Ev();
extern void _ZN6S512C53v70Ev();
extern void _ZN6S512C53v71Ev();
extern void _ZN6S512C53v72Ev();
extern void _ZN6S512C53v73Ev();
extern void _ZN6S512C53v74Ev();
extern void _ZN6S512C53v75Ev();
extern void _ZN6S512C53v76Ev();
extern void _ZN6S512C53v77Ev();
extern void _ZN6S512C53v78Ev();
extern void _ZN6S512C53v79Ev();
extern void _ZN6S512C53v80Ev();
extern void _ZN6S512C53v81Ev();
extern void _ZN6S512C53v82Ev();
extern void _ZN6S512C53v83Ev();
extern void _ZN6S512C53v84Ev();
extern void _ZN6S512C53v85Ev();
extern void _ZN6S512C53v86Ev();
extern void _ZN6S512C53v87Ev();
extern void _ZN6S512C53v88Ev();
extern void _ZN6S512C43v89Ev();
extern void _ZN6S512C43v90Ev();
extern void _ZN6S512C43v91Ev();
extern void _ZN6S512C43v92Ev();
extern void _ZN6S512C43v93Ev();
extern void _ZN6S512C43v94Ev();
extern void _ZN6S512C43v95Ev();
extern void _ZN6S512C43v96Ev();
extern void _ZN6S512C43v97Ev();
extern void _ZN6S512C43v98Ev();
extern void _ZN6S512C43v99Ev();
extern void _ZN6S512C44v100Ev();
extern void _ZN6S512C44v101Ev();
extern void _ZN6S512C44v102Ev();
extern void _ZN6S512C44v103Ev();
extern void _ZN6S512C44v104Ev();
extern void _ZN6S512C44v105Ev();
extern void _ZN6S512C44v106Ev();
extern void _ZN6S512C44v107Ev();
extern void _ZN6S512C44v108Ev();
extern void _ZN6S512C44v109Ev();
extern void _ZN6S512C44v110Ev();
extern void _ZN6S512C44v111Ev();
extern void _ZN6S512C44v112Ev();
extern void _ZN6S512C44v113Ev();
extern void _ZN6S512C44v114Ev();
extern void _ZN6S512C44v115Ev();
extern void _ZN6S512C44v116Ev();
extern void _ZN6S512C44v117Ev();
extern void _ZN6S512C44v118Ev();
extern void _ZN6S512C44v119Ev();
extern void _ZN6S512C44v120Ev();
extern void _ZN6S512C44v121Ev();
extern void _ZN6S512C44v122Ev();
extern void _ZN6S512C44v123Ev();
extern void _ZN6S512C44v124Ev();
extern void _ZN6S512C44v125Ev();
extern void _ZN6S512C44v126Ev();
extern void _ZN6S512C44v127Ev();
extern void _ZN6S512C44v128Ev();
extern void _ZN6S512C44v129Ev();
extern void _ZN6S512C44v130Ev();
extern void _ZN6S512C44v131Ev();
extern void _ZN6S512C44v132Ev();
extern void _ZN6S512C44v133Ev();
extern void _ZN6S512C44v134Ev();
extern void _ZN6S512C44v135Ev();
extern void _ZN6S512C44v136Ev();
extern void _ZN6S512C44v137Ev();
extern void _ZN6S512C44v138Ev();
extern void _ZN6S512C44v139Ev();
extern void _ZN6S512C44v140Ev();
extern void _ZN6S512C44v141Ev();
extern void _ZN6S512C44v142Ev();
extern void _ZN6S512C44v143Ev();
extern void _ZN6S512C44v144Ev();
extern void _ZN6S512C44v145Ev();
extern void _ZN6S512C44v146Ev();
extern void _ZN6S512C44v147Ev();
extern void _ZN6S512C44v148Ev();
extern void _ZN6S512C44v149Ev();
extern void _ZN6S512C44v150Ev();
extern void _ZN6S512C44v151Ev();
extern void _ZN6S512C44v152Ev();
extern void _ZN6S512C44v153Ev();
extern void _ZN6S512C44v154Ev();
extern void _ZN6S512C44v155Ev();
extern void _ZN6S512C44v156Ev();
extern void _ZN6S512C44v157Ev();
extern void _ZN6S512C44v158Ev();
extern void _ZN6S512C44v159Ev();
extern void _ZN6S512C44v160Ev();
extern void _ZN6S512C44v161Ev();
extern void _ZN6S512C44v162Ev();
extern void _ZN6S512C44v163Ev();
extern void _ZN6S512C44v164Ev();
extern void _ZN6S512C44v165Ev();
extern void _ZN6S512C44v166Ev();
extern void _ZN6S512C44v167Ev();
extern void _ZN6S512C44v168Ev();
extern void _ZN6S512C44v169Ev();
extern void _ZN6S512C44v170Ev();
extern void _ZN6S512C44v171Ev();
extern void _ZN6S512C44v172Ev();
extern void _ZN6S512C44v173Ev();
extern void _ZN6S512C44v174Ev();
extern void _ZN6S512C44v175Ev();
extern void _ZN6S512C44v176Ev();
extern void _ZN6S512C44v177Ev();
extern void _ZN6S512C44v178Ev();
extern void _ZN6S512C44v179Ev();
extern void _ZN6S512C44v180Ev();
extern void _ZN6S512C44v181Ev();
extern void _ZN6S512C44v182Ev();
extern void _ZN6S512C44v183Ev();
extern void _ZN6S512C44v184Ev();
extern void _ZN6S512C44v185Ev();
extern void _ZN6S512C44v186Ev();
extern void _ZN6S512C44v187Ev();
extern void _ZN6S512C44v188Ev();
extern void _ZN6S512C44v189Ev();
extern void _ZN6S512C44v190Ev();
extern void _ZN6S512C44v191Ev();
extern void _ZN6S512C44v192Ev();
extern void _ZN6S512C44v193Ev();
extern void _ZN6S512C44v194Ev();
extern void _ZN6S512C44v195Ev();
extern void _ZN6S512C44v196Ev();
extern void _ZN6S512C44v197Ev();
extern void _ZN6S512C44v198Ev();
extern void _ZN6S512C44v199Ev();
extern void _ZN6S512C44v200Ev();
extern void _ZN6S512C44v201Ev();
extern void _ZN6S512C44v202Ev();
extern void _ZN6S512C44v203Ev();
extern void _ZN6S512C44v204Ev();
extern void _ZN6S512C44v205Ev();
extern void _ZN6S512C44v206Ev();
extern void _ZN6S512C44v207Ev();
extern void _ZN6S512C44v208Ev();
extern void _ZN6S512C44v209Ev();
extern void _ZN6S512C44v210Ev();
extern void _ZN6S512C44v211Ev();
extern void _ZN6S512C44v212Ev();
extern void _ZN6S512C44v213Ev();
extern void _ZN6S512C44v214Ev();
extern void _ZN6S512C44v215Ev();
extern void _ZN6S512C44v216Ev();
extern void _ZN6S512C44v217Ev();
extern void _ZN6S512C44v218Ev();
extern void _ZN6S512C44v219Ev();
extern void _ZN6S512C44v220Ev();
extern void _ZN6S512C44v221Ev();
extern void _ZN6S512C44v222Ev();
extern void _ZN6S512C44v223Ev();
extern void _ZN6S512C44v224Ev();
extern void _ZN6S512C44v225Ev();
extern void _ZN6S512C44v226Ev();
extern void _ZN6S512C44v227Ev();
extern void _ZN6S512C44v228Ev();
extern void _ZN6S512C44v229Ev();
extern void _ZN6S512C44v230Ev();
extern void _ZN6S512C44v231Ev();
extern void _ZN6S512C34v232Ev();
extern void _ZN6S512C34v233Ev();
extern void _ZN6S512C34v234Ev();
extern void _ZN6S512C34v235Ev();
extern void _ZN6S512C34v236Ev();
extern void _ZN6S512C34v237Ev();
extern void _ZN6S512C34v238Ev();
extern void _ZN6S512C34v239Ev();
extern void _ZN6S512C34v240Ev();
extern void _ZN6S512C34v241Ev();
extern void _ZN6S512C34v242Ev();
extern void _ZN6S512C34v243Ev();
extern void _ZN6S512C34v244Ev();
extern void _ZN6S512C34v245Ev();
extern void _ZN6S512C34v246Ev();
extern void _ZN6S512C34v247Ev();
extern void _ZN6S512C34v248Ev();
extern void _ZN6S512C34v249Ev();
extern void _ZN6S512C34v250Ev();
extern void _ZN6S512C34v251Ev();
extern void _ZN6S512C34v252Ev();
extern void _ZN6S512C34v253Ev();
extern void _ZN6S512C34v254Ev();
extern void _ZN6S512C34v255Ev();
extern void _ZN6S512C34v256Ev();
extern void _ZN6S512C34v257Ev();
extern void _ZN6S512C34v258Ev();
extern void _ZN6S512C34v259Ev();
extern void _ZN6S512C34v260Ev();
extern void _ZN6S512C34v261Ev();
extern void _ZN6S512C34v262Ev();
extern void _ZN6S512C34v263Ev();
extern void _ZN6S512C34v264Ev();
extern void _ZN6S512C34v265Ev();
extern void _ZN6S512C34v266Ev();
extern void _ZN6S512C34v267Ev();
extern void _ZN6S512C34v268Ev();
extern void _ZN6S512C34v269Ev();
extern void _ZN6S512C34v270Ev();
extern void _ZN6S512C34v271Ev();
extern void _ZN6S512C34v272Ev();
extern void _ZN6S512C34v273Ev();
extern void _ZN6S512C34v274Ev();
extern void _ZN6S512C34v275Ev();
extern void _ZN6S512C34v276Ev();
extern void _ZN6S512C34v277Ev();
extern void _ZN6S512C34v278Ev();
extern void _ZN6S512C34v279Ev();
extern void _ZN6S512C34v280Ev();
extern void _ZN6S512C34v281Ev();
extern void _ZN6S512C24v282Ev();
extern void _ZN6S512C24v283Ev();
extern void _ZN6S512C24v284Ev();
extern void _ZN6S512C24v285Ev();
extern void _ZN6S512C24v286Ev();
extern void _ZN6S512C24v287Ev();
static  VTBL_ENTRY vtc_S512C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S512C2[0]),
  (VTBL_ENTRY)&_ZN6S512C2D1Ev,
  (VTBL_ENTRY)&_ZN6S512C2D0Ev,
  (VTBL_ENTRY)&_ZN6S512C53v25Ev,
  (VTBL_ENTRY)&_ZN6S512C53v26Ev,
  (VTBL_ENTRY)&_ZN6S512C53v27Ev,
  (VTBL_ENTRY)&_ZN6S512C53v28Ev,
  (VTBL_ENTRY)&_ZN6S512C53v29Ev,
  (VTBL_ENTRY)&_ZN6S512C53v30Ev,
  (VTBL_ENTRY)&_ZN6S512C53v31Ev,
  (VTBL_ENTRY)&_ZN6S512C53v32Ev,
  (VTBL_ENTRY)&_ZN6S512C53v33Ev,
  (VTBL_ENTRY)&_ZN6S512C53v34Ev,
  (VTBL_ENTRY)&_ZN6S512C53v35Ev,
  (VTBL_ENTRY)&_ZN6S512C53v36Ev,
  (VTBL_ENTRY)&_ZN6S512C53v37Ev,
  (VTBL_ENTRY)&_ZN6S512C53v38Ev,
  (VTBL_ENTRY)&_ZN6S512C53v39Ev,
  (VTBL_ENTRY)&_ZN6S512C53v40Ev,
  (VTBL_ENTRY)&_ZN6S512C53v41Ev,
  (VTBL_ENTRY)&_ZN6S512C53v42Ev,
  (VTBL_ENTRY)&_ZN6S512C53v43Ev,
  (VTBL_ENTRY)&_ZN6S512C53v44Ev,
  (VTBL_ENTRY)&_ZN6S512C53v45Ev,
  (VTBL_ENTRY)&_ZN6S512C53v46Ev,
  (VTBL_ENTRY)&_ZN6S512C53v47Ev,
  (VTBL_ENTRY)&_ZN6S512C53v48Ev,
  (VTBL_ENTRY)&_ZN6S512C53v49Ev,
  (VTBL_ENTRY)&_ZN6S512C53v50Ev,
  (VTBL_ENTRY)&_ZN6S512C53v51Ev,
  (VTBL_ENTRY)&_ZN6S512C53v52Ev,
  (VTBL_ENTRY)&_ZN6S512C53v53Ev,
  (VTBL_ENTRY)&_ZN6S512C53v54Ev,
  (VTBL_ENTRY)&_ZN6S512C53v55Ev,
  (VTBL_ENTRY)&_ZN6S512C53v56Ev,
  (VTBL_ENTRY)&_ZN6S512C53v57Ev,
  (VTBL_ENTRY)&_ZN6S512C53v58Ev,
  (VTBL_ENTRY)&_ZN6S512C53v59Ev,
  (VTBL_ENTRY)&_ZN6S512C53v60Ev,
  (VTBL_ENTRY)&_ZN6S512C53v61Ev,
  (VTBL_ENTRY)&_ZN6S512C53v62Ev,
  (VTBL_ENTRY)&_ZN6S512C53v63Ev,
  (VTBL_ENTRY)&_ZN6S512C53v64Ev,
  (VTBL_ENTRY)&_ZN6S512C53v65Ev,
  (VTBL_ENTRY)&_ZN6S512C53v66Ev,
  (VTBL_ENTRY)&_ZN6S512C53v67Ev,
  (VTBL_ENTRY)&_ZN6S512C53v68Ev,
  (VTBL_ENTRY)&_ZN6S512C53v69Ev,
  (VTBL_ENTRY)&_ZN6S512C53v70Ev,
  (VTBL_ENTRY)&_ZN6S512C53v71Ev,
  (VTBL_ENTRY)&_ZN6S512C53v72Ev,
  (VTBL_ENTRY)&_ZN6S512C53v73Ev,
  (VTBL_ENTRY)&_ZN6S512C53v74Ev,
  (VTBL_ENTRY)&_ZN6S512C53v75Ev,
  (VTBL_ENTRY)&_ZN6S512C53v76Ev,
  (VTBL_ENTRY)&_ZN6S512C53v77Ev,
  (VTBL_ENTRY)&_ZN6S512C53v78Ev,
  (VTBL_ENTRY)&_ZN6S512C53v79Ev,
  (VTBL_ENTRY)&_ZN6S512C53v80Ev,
  (VTBL_ENTRY)&_ZN6S512C53v81Ev,
  (VTBL_ENTRY)&_ZN6S512C53v82Ev,
  (VTBL_ENTRY)&_ZN6S512C53v83Ev,
  (VTBL_ENTRY)&_ZN6S512C53v84Ev,
  (VTBL_ENTRY)&_ZN6S512C53v85Ev,
  (VTBL_ENTRY)&_ZN6S512C53v86Ev,
  (VTBL_ENTRY)&_ZN6S512C53v87Ev,
  (VTBL_ENTRY)&_ZN6S512C53v88Ev,
  (VTBL_ENTRY)&_ZN6S512C43v89Ev,
  (VTBL_ENTRY)&_ZN6S512C43v90Ev,
  (VTBL_ENTRY)&_ZN6S512C43v91Ev,
  (VTBL_ENTRY)&_ZN6S512C43v92Ev,
  (VTBL_ENTRY)&_ZN6S512C43v93Ev,
  (VTBL_ENTRY)&_ZN6S512C43v94Ev,
  (VTBL_ENTRY)&_ZN6S512C43v95Ev,
  (VTBL_ENTRY)&_ZN6S512C43v96Ev,
  (VTBL_ENTRY)&_ZN6S512C43v97Ev,
  (VTBL_ENTRY)&_ZN6S512C43v98Ev,
  (VTBL_ENTRY)&_ZN6S512C43v99Ev,
  (VTBL_ENTRY)&_ZN6S512C44v100Ev,
  (VTBL_ENTRY)&_ZN6S512C44v101Ev,
  (VTBL_ENTRY)&_ZN6S512C44v102Ev,
  (VTBL_ENTRY)&_ZN6S512C44v103Ev,
  (VTBL_ENTRY)&_ZN6S512C44v104Ev,
  (VTBL_ENTRY)&_ZN6S512C44v105Ev,
  (VTBL_ENTRY)&_ZN6S512C44v106Ev,
  (VTBL_ENTRY)&_ZN6S512C44v107Ev,
  (VTBL_ENTRY)&_ZN6S512C44v108Ev,
  (VTBL_ENTRY)&_ZN6S512C44v109Ev,
  (VTBL_ENTRY)&_ZN6S512C44v110Ev,
  (VTBL_ENTRY)&_ZN6S512C44v111Ev,
  (VTBL_ENTRY)&_ZN6S512C44v112Ev,
  (VTBL_ENTRY)&_ZN6S512C44v113Ev,
  (VTBL_ENTRY)&_ZN6S512C44v114Ev,
  (VTBL_ENTRY)&_ZN6S512C44v115Ev,
  (VTBL_ENTRY)&_ZN6S512C44v116Ev,
  (VTBL_ENTRY)&_ZN6S512C44v117Ev,
  (VTBL_ENTRY)&_ZN6S512C44v118Ev,
  (VTBL_ENTRY)&_ZN6S512C44v119Ev,
  (VTBL_ENTRY)&_ZN6S512C44v120Ev,
  (VTBL_ENTRY)&_ZN6S512C44v121Ev,
  (VTBL_ENTRY)&_ZN6S512C44v122Ev,
  (VTBL_ENTRY)&_ZN6S512C44v123Ev,
  (VTBL_ENTRY)&_ZN6S512C44v124Ev,
  (VTBL_ENTRY)&_ZN6S512C44v125Ev,
  (VTBL_ENTRY)&_ZN6S512C44v126Ev,
  (VTBL_ENTRY)&_ZN6S512C44v127Ev,
  (VTBL_ENTRY)&_ZN6S512C44v128Ev,
  (VTBL_ENTRY)&_ZN6S512C44v129Ev,
  (VTBL_ENTRY)&_ZN6S512C44v130Ev,
  (VTBL_ENTRY)&_ZN6S512C44v131Ev,
  (VTBL_ENTRY)&_ZN6S512C44v132Ev,
  (VTBL_ENTRY)&_ZN6S512C44v133Ev,
  (VTBL_ENTRY)&_ZN6S512C44v134Ev,
  (VTBL_ENTRY)&_ZN6S512C44v135Ev,
  (VTBL_ENTRY)&_ZN6S512C44v136Ev,
  (VTBL_ENTRY)&_ZN6S512C44v137Ev,
  (VTBL_ENTRY)&_ZN6S512C44v138Ev,
  (VTBL_ENTRY)&_ZN6S512C44v139Ev,
  (VTBL_ENTRY)&_ZN6S512C44v140Ev,
  (VTBL_ENTRY)&_ZN6S512C44v141Ev,
  (VTBL_ENTRY)&_ZN6S512C44v142Ev,
  (VTBL_ENTRY)&_ZN6S512C44v143Ev,
  (VTBL_ENTRY)&_ZN6S512C44v144Ev,
  (VTBL_ENTRY)&_ZN6S512C44v145Ev,
  (VTBL_ENTRY)&_ZN6S512C44v146Ev,
  (VTBL_ENTRY)&_ZN6S512C44v147Ev,
  (VTBL_ENTRY)&_ZN6S512C44v148Ev,
  (VTBL_ENTRY)&_ZN6S512C44v149Ev,
  (VTBL_ENTRY)&_ZN6S512C44v150Ev,
  (VTBL_ENTRY)&_ZN6S512C44v151Ev,
  (VTBL_ENTRY)&_ZN6S512C44v152Ev,
  (VTBL_ENTRY)&_ZN6S512C44v153Ev,
  (VTBL_ENTRY)&_ZN6S512C44v154Ev,
  (VTBL_ENTRY)&_ZN6S512C44v155Ev,
  (VTBL_ENTRY)&_ZN6S512C44v156Ev,
  (VTBL_ENTRY)&_ZN6S512C44v157Ev,
  (VTBL_ENTRY)&_ZN6S512C44v158Ev,
  (VTBL_ENTRY)&_ZN6S512C44v159Ev,
  (VTBL_ENTRY)&_ZN6S512C44v160Ev,
  (VTBL_ENTRY)&_ZN6S512C44v161Ev,
  (VTBL_ENTRY)&_ZN6S512C44v162Ev,
  (VTBL_ENTRY)&_ZN6S512C44v163Ev,
  (VTBL_ENTRY)&_ZN6S512C44v164Ev,
  (VTBL_ENTRY)&_ZN6S512C44v165Ev,
  (VTBL_ENTRY)&_ZN6S512C44v166Ev,
  (VTBL_ENTRY)&_ZN6S512C44v167Ev,
  (VTBL_ENTRY)&_ZN6S512C44v168Ev,
  (VTBL_ENTRY)&_ZN6S512C44v169Ev,
  (VTBL_ENTRY)&_ZN6S512C44v170Ev,
  (VTBL_ENTRY)&_ZN6S512C44v171Ev,
  (VTBL_ENTRY)&_ZN6S512C44v172Ev,
  (VTBL_ENTRY)&_ZN6S512C44v173Ev,
  (VTBL_ENTRY)&_ZN6S512C44v174Ev,
  (VTBL_ENTRY)&_ZN6S512C44v175Ev,
  (VTBL_ENTRY)&_ZN6S512C44v176Ev,
  (VTBL_ENTRY)&_ZN6S512C44v177Ev,
  (VTBL_ENTRY)&_ZN6S512C44v178Ev,
  (VTBL_ENTRY)&_ZN6S512C44v179Ev,
  (VTBL_ENTRY)&_ZN6S512C44v180Ev,
  (VTBL_ENTRY)&_ZN6S512C44v181Ev,
  (VTBL_ENTRY)&_ZN6S512C44v182Ev,
  (VTBL_ENTRY)&_ZN6S512C44v183Ev,
  (VTBL_ENTRY)&_ZN6S512C44v184Ev,
  (VTBL_ENTRY)&_ZN6S512C44v185Ev,
  (VTBL_ENTRY)&_ZN6S512C44v186Ev,
  (VTBL_ENTRY)&_ZN6S512C44v187Ev,
  (VTBL_ENTRY)&_ZN6S512C44v188Ev,
  (VTBL_ENTRY)&_ZN6S512C44v189Ev,
  (VTBL_ENTRY)&_ZN6S512C44v190Ev,
  (VTBL_ENTRY)&_ZN6S512C44v191Ev,
  (VTBL_ENTRY)&_ZN6S512C44v192Ev,
  (VTBL_ENTRY)&_ZN6S512C44v193Ev,
  (VTBL_ENTRY)&_ZN6S512C44v194Ev,
  (VTBL_ENTRY)&_ZN6S512C44v195Ev,
  (VTBL_ENTRY)&_ZN6S512C44v196Ev,
  (VTBL_ENTRY)&_ZN6S512C44v197Ev,
  (VTBL_ENTRY)&_ZN6S512C44v198Ev,
  (VTBL_ENTRY)&_ZN6S512C44v199Ev,
  (VTBL_ENTRY)&_ZN6S512C44v200Ev,
  (VTBL_ENTRY)&_ZN6S512C44v201Ev,
  (VTBL_ENTRY)&_ZN6S512C44v202Ev,
  (VTBL_ENTRY)&_ZN6S512C44v203Ev,
  (VTBL_ENTRY)&_ZN6S512C44v204Ev,
  (VTBL_ENTRY)&_ZN6S512C44v205Ev,
  (VTBL_ENTRY)&_ZN6S512C44v206Ev,
  (VTBL_ENTRY)&_ZN6S512C44v207Ev,
  (VTBL_ENTRY)&_ZN6S512C44v208Ev,
  (VTBL_ENTRY)&_ZN6S512C44v209Ev,
  (VTBL_ENTRY)&_ZN6S512C44v210Ev,
  (VTBL_ENTRY)&_ZN6S512C44v211Ev,
  (VTBL_ENTRY)&_ZN6S512C44v212Ev,
  (VTBL_ENTRY)&_ZN6S512C44v213Ev,
  (VTBL_ENTRY)&_ZN6S512C44v214Ev,
  (VTBL_ENTRY)&_ZN6S512C44v215Ev,
  (VTBL_ENTRY)&_ZN6S512C44v216Ev,
  (VTBL_ENTRY)&_ZN6S512C44v217Ev,
  (VTBL_ENTRY)&_ZN6S512C44v218Ev,
  (VTBL_ENTRY)&_ZN6S512C44v219Ev,
  (VTBL_ENTRY)&_ZN6S512C44v220Ev,
  (VTBL_ENTRY)&_ZN6S512C44v221Ev,
  (VTBL_ENTRY)&_ZN6S512C44v222Ev,
  (VTBL_ENTRY)&_ZN6S512C44v223Ev,
  (VTBL_ENTRY)&_ZN6S512C44v224Ev,
  (VTBL_ENTRY)&_ZN6S512C44v225Ev,
  (VTBL_ENTRY)&_ZN6S512C44v226Ev,
  (VTBL_ENTRY)&_ZN6S512C44v227Ev,
  (VTBL_ENTRY)&_ZN6S512C44v228Ev,
  (VTBL_ENTRY)&_ZN6S512C44v229Ev,
  (VTBL_ENTRY)&_ZN6S512C44v230Ev,
  (VTBL_ENTRY)&_ZN6S512C44v231Ev,
  (VTBL_ENTRY)&_ZN6S512C34v232Ev,
  (VTBL_ENTRY)&_ZN6S512C34v233Ev,
  (VTBL_ENTRY)&_ZN6S512C34v234Ev,
  (VTBL_ENTRY)&_ZN6S512C34v235Ev,
  (VTBL_ENTRY)&_ZN6S512C34v236Ev,
  (VTBL_ENTRY)&_ZN6S512C34v237Ev,
  (VTBL_ENTRY)&_ZN6S512C34v238Ev,
  (VTBL_ENTRY)&_ZN6S512C34v239Ev,
  (VTBL_ENTRY)&_ZN6S512C34v240Ev,
  (VTBL_ENTRY)&_ZN6S512C34v241Ev,
  (VTBL_ENTRY)&_ZN6S512C34v242Ev,
  (VTBL_ENTRY)&_ZN6S512C34v243Ev,
  (VTBL_ENTRY)&_ZN6S512C34v244Ev,
  (VTBL_ENTRY)&_ZN6S512C34v245Ev,
  (VTBL_ENTRY)&_ZN6S512C34v246Ev,
  (VTBL_ENTRY)&_ZN6S512C34v247Ev,
  (VTBL_ENTRY)&_ZN6S512C34v248Ev,
  (VTBL_ENTRY)&_ZN6S512C34v249Ev,
  (VTBL_ENTRY)&_ZN6S512C34v250Ev,
  (VTBL_ENTRY)&_ZN6S512C34v251Ev,
  (VTBL_ENTRY)&_ZN6S512C34v252Ev,
  (VTBL_ENTRY)&_ZN6S512C34v253Ev,
  (VTBL_ENTRY)&_ZN6S512C34v254Ev,
  (VTBL_ENTRY)&_ZN6S512C34v255Ev,
  (VTBL_ENTRY)&_ZN6S512C34v256Ev,
  (VTBL_ENTRY)&_ZN6S512C34v257Ev,
  (VTBL_ENTRY)&_ZN6S512C34v258Ev,
  (VTBL_ENTRY)&_ZN6S512C34v259Ev,
  (VTBL_ENTRY)&_ZN6S512C34v260Ev,
  (VTBL_ENTRY)&_ZN6S512C34v261Ev,
  (VTBL_ENTRY)&_ZN6S512C34v262Ev,
  (VTBL_ENTRY)&_ZN6S512C34v263Ev,
  (VTBL_ENTRY)&_ZN6S512C34v264Ev,
  (VTBL_ENTRY)&_ZN6S512C34v265Ev,
  (VTBL_ENTRY)&_ZN6S512C34v266Ev,
  (VTBL_ENTRY)&_ZN6S512C34v267Ev,
  (VTBL_ENTRY)&_ZN6S512C34v268Ev,
  (VTBL_ENTRY)&_ZN6S512C34v269Ev,
  (VTBL_ENTRY)&_ZN6S512C34v270Ev,
  (VTBL_ENTRY)&_ZN6S512C34v271Ev,
  (VTBL_ENTRY)&_ZN6S512C34v272Ev,
  (VTBL_ENTRY)&_ZN6S512C34v273Ev,
  (VTBL_ENTRY)&_ZN6S512C34v274Ev,
  (VTBL_ENTRY)&_ZN6S512C34v275Ev,
  (VTBL_ENTRY)&_ZN6S512C34v276Ev,
  (VTBL_ENTRY)&_ZN6S512C34v277Ev,
  (VTBL_ENTRY)&_ZN6S512C34v278Ev,
  (VTBL_ENTRY)&_ZN6S512C34v279Ev,
  (VTBL_ENTRY)&_ZN6S512C34v280Ev,
  (VTBL_ENTRY)&_ZN6S512C34v281Ev,
  (VTBL_ENTRY)&_ZN6S512C24v282Ev,
  (VTBL_ENTRY)&_ZN6S512C24v283Ev,
  (VTBL_ENTRY)&_ZN6S512C24v284Ev,
  (VTBL_ENTRY)&_ZN6S512C24v285Ev,
  (VTBL_ENTRY)&_ZN6S512C24v286Ev,
  (VTBL_ENTRY)&_ZN6S512C24v287Ev,
};
extern VTBL_ENTRY _ZTI6S512C2[];
extern  VTBL_ENTRY _ZTV6S512C2[];
Class_Descriptor cd_S512C2 = {  "S512C2", // class name
  bases_S512C2, 3,
  &(vtc_S512C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(960,716), // object size
  NSPAIRA(_ZTI6S512C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S512C2),267, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S512C1  : S512C2 {
  int s512c1f0;
  void *s512c1f1[2];
  ::S48C18 s512c1f2;
  void *s512c1f3;
  int s512c1f4;
  ::S48C18 s512c1f5;
  ::S48C18 s512c1f6;
  int s512c1f7[2];
  unsigned int s512c1f8:1;
  unsigned int s512c1f9:1;
  unsigned int s512c1f10:1;
  unsigned int s512c1f11:1;
  unsigned int s512c1f12:1;
  unsigned int s512c1f13:1;
  unsigned int s512c1f14:1;
  unsigned int s512c1f15:1;
  unsigned int s512c1f16:1;
  unsigned int s512c1f17:1;
  unsigned int s512c1f18:1;
  unsigned int s512c1f19:1;
  unsigned int s512c1f20:1;
  unsigned int s512c1f21:1;
  unsigned int s512c1f22:1;
  unsigned int s512c1f23:1;
  unsigned int s512c1f24:1;
  unsigned int s512c1f25:1;
  unsigned int s512c1f26:1;
  unsigned int s512c1f27:1;
  unsigned int s512c1f28:1;
  unsigned int s512c1f29:1;
  unsigned int s512c1f30:1;
  unsigned int s512c1f31:1;
  unsigned int s512c1f32:1;
  unsigned int s512c1f33:1;
  unsigned int s512c1f34:1;
  unsigned int s512c1f35:1;
  unsigned int s512c1f36:1;
  unsigned int s512c1f37:1;
  unsigned int s512c1f38:1;
  unsigned int s512c1f39:1;
  unsigned int s512c1f40:1;
  unsigned int s512c1f41:1;
  unsigned int s512c1f42:1;
  unsigned int s512c1f43:1;
  unsigned int s512c1f44:1;
  unsigned int s512c1f45:1;
  unsigned int s512c1f46:1;
  unsigned int s512c1f47:1;
  unsigned int s512c1f48:1;
  unsigned int s512c1f49:1;
  unsigned int s512c1f50:1;
  unsigned int s512c1f51:1;
  int s512c1f52[2];
  void *s512c1f53;
  int s512c1f54;
  void *s512c1f55;
  int s512c1f56[4];
  ::S28C9_nt s512c1f57;
  int s512c1f58[2];
  void *s512c1f59[2];
  ::S48C18 s512c1f60;
  int s512c1f61[2];
  void *s512c1f62;
  int s512c1f63[3];
  void *s512c1f64;
  int s512c1f65[12];
  void *s512c1f66;
  int s512c1f67[3];
  ::S28C31_nt s512c1f68;
  ::S28C31_nt s512c1f69;
  void *s512c1f70[3];
  int s512c1f71;
  void *s512c1f72[4];
  ::S48C18 s512c1f73;
  int s512c1f74[3];
  void *s512c1f75;
  int s512c1f76;
  void *s512c1f77;
  int s512c1f78[3];
  unsigned int s512c1f79:1;
  unsigned int s512c1f80:1;
  int s512c1f81[3];
  ::S28C9_nt s512c1f82[16];
  ::S28C9_nt s512c1f83;
  void *s512c1f84;
  int s512c1f85[2];
  void *s512c1f86;
  ::S48C18 s512c1f87;
  ::S28C34 s512c1f88;
  void *s512c1f89;
  int s512c1f90[6];
  ::S48C18 s512c1f91;
  ::S48C18 s512c1f92;
  void *s512c1f93[2];
  ::S48C18 s512c1f94;
  void *s512c1f95;
  char s512c1f96;
  void *s512c1f97;
  int s512c1f98[2];
  void *s512c1f99[2];
  int s512c1f100[2];
  ::S28C50 s512c1f101;
  virtual  ~S512C1(); // _ZN6S512C1D1Ev
  virtual void  v1(); // _ZN6S512C12v1Ev
  virtual void  v2(); // _ZN6S512C12v2Ev
  virtual void  v3(); // _ZN6S512C12v3Ev
  virtual void  v4(); // _ZN6S512C12v4Ev
  virtual void  v5(); // _ZN6S512C12v5Ev
  virtual void  v6(); // _ZN6S512C12v6Ev
  virtual void  v7(); // _ZN6S512C12v7Ev
  virtual void  v8(); // _ZN6S512C12v8Ev
  virtual void  v9(); // _ZN6S512C12v9Ev
  virtual void  v10(); // _ZN6S512C13v10Ev
  virtual void  v11(); // _ZN6S512C13v11Ev
  virtual void  v12(); // _ZN6S512C13v12Ev
  virtual void  v13(); // _ZN6S512C13v13Ev
  virtual void  v14(); // _ZN6S512C13v14Ev
  virtual void  v15(); // _ZN6S512C13v15Ev
  virtual void  v16(); // _ZN6S512C13v16Ev
  virtual void  v17(); // _ZN6S512C13v17Ev
  virtual void  v18(); // _ZN6S512C13v18Ev
  virtual void  v19(); // _ZN6S512C13v19Ev
  virtual void  v20(); // _ZN6S512C13v20Ev
  virtual void  v21(); // _ZN6S512C13v21Ev
  virtual void  v22(); // _ZN6S512C13v22Ev
  virtual void  v23(); // _ZN6S512C13v23Ev
  virtual void  v24(); // _ZN6S512C13v24Ev
  S512C1(); // tgen
};
//SIG(1 S512C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 FC10{ m Fi} Fi Fc[4] Fp[2] FC11{ BC12{ BC9}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC6 FC6 FC6 FC13{ BC14{ BC9}} FC13 Fi Fp[2] FC15{ m Fi[3]} FC16{ m Fi[3]} FC15 FC15 Fp FC6 FC13 FC15 FC16 Fi FC15 FC15 Fp Fi Fc FC16 FC16 Fp Fi Fp FC17{ BC18{ BC9}} FC19{ BC20{ BC9}} FC21{ BC22{ BC9}}} vd v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 Fp[2] Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc Fi[2] Fp FC15 FC15 Fp[5] FC15 Fp FC23{ BC24{ BC9}} Fp[2] FC15 Fp Fi[2] Fp Fi FC15 FC15 FC15 Fp[2] Fi FC15 Fi[4] Fp[2] FC25{ BC26{ BC9}} Fi FC16} vd v282 v283 v284 v285 v286 v287 Fi:1 Fi:1 Fi:1 Fi Fp[2] Fi Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fi Fp[2] FC15 Fp Fi FC15 FC15 Fi[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fp Fi Fp Fi[4] FC6 Fi[2] Fp[2] FC15 Fi[2] Fp Fi[3] Fp Fi[12] Fp Fi[3] FC27{ BC28{ BC29{ BC9}}} FC27 Fp[3] Fi Fp[4] FC15 Fi[3] Fp Fi Fp Fi[3] Fi:1 Fi:1 Fi[3] FC6[16] FC6 Fp Fi[2] Fp FC15 FC30{ BC31{ BC9}} Fp Fi[6] FC15 FC15 Fp[2] FC15 Fp Fc Fp Fi[2] Fp[2] Fi[2] FC32{ m Fp FC6}}


 S512C1 ::~S512C1(){ note_dtor("S512C1", this);}
void  S512C1 ::v1(){vfunc_called(this, "_ZN6S512C12v1Ev");}
void  S512C1 ::v2(){vfunc_called(this, "_ZN6S512C12v2Ev");}
void  S512C1 ::v3(){vfunc_called(this, "_ZN6S512C12v3Ev");}
void  S512C1 ::v4(){vfunc_called(this, "_ZN6S512C12v4Ev");}
void  S512C1 ::v5(){vfunc_called(this, "_ZN6S512C12v5Ev");}
void  S512C1 ::v6(){vfunc_called(this, "_ZN6S512C12v6Ev");}
void  S512C1 ::v7(){vfunc_called(this, "_ZN6S512C12v7Ev");}
void  S512C1 ::v8(){vfunc_called(this, "_ZN6S512C12v8Ev");}
void  S512C1 ::v9(){vfunc_called(this, "_ZN6S512C12v9Ev");}
void  S512C1 ::v10(){vfunc_called(this, "_ZN6S512C13v10Ev");}
void  S512C1 ::v11(){vfunc_called(this, "_ZN6S512C13v11Ev");}
void  S512C1 ::v12(){vfunc_called(this, "_ZN6S512C13v12Ev");}
void  S512C1 ::v13(){vfunc_called(this, "_ZN6S512C13v13Ev");}
void  S512C1 ::v14(){vfunc_called(this, "_ZN6S512C13v14Ev");}
void  S512C1 ::v15(){vfunc_called(this, "_ZN6S512C13v15Ev");}
void  S512C1 ::v16(){vfunc_called(this, "_ZN6S512C13v16Ev");}
void  S512C1 ::v17(){vfunc_called(this, "_ZN6S512C13v17Ev");}
void  S512C1 ::v18(){vfunc_called(this, "_ZN6S512C13v18Ev");}
void  S512C1 ::v19(){vfunc_called(this, "_ZN6S512C13v19Ev");}
void  S512C1 ::v20(){vfunc_called(this, "_ZN6S512C13v20Ev");}
void  S512C1 ::v21(){vfunc_called(this, "_ZN6S512C13v21Ev");}
void  S512C1 ::v22(){vfunc_called(this, "_ZN6S512C13v22Ev");}
void  S512C1 ::v23(){vfunc_called(this, "_ZN6S512C13v23Ev");}
void  S512C1 ::v24(){vfunc_called(this, "_ZN6S512C13v24Ev");}
S512C1 ::S512C1(){ note_ctor("S512C1", this);} // tgen

static void Test_S512C1()
{
  extern Class_Descriptor cd_S512C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(225,343)];
    init_test(&cd_S512C1, buf);
    S512C1 *dp, &lv = *(dp=new (buf) S512C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1792,1368), "sizeof(S512C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S512C1)");
    check_base_class_offset(lv, (S512C5*)(S512C4*)(S512C3*)(S512C2*), 0, "S512C1");
    check_base_class_offset(lv, (S512C4*)(S512C3*)(S512C2*), 0, "S512C1");
    check_base_class_offset(lv, (S512C3*)(S512C2*), 0, "S512C1");
    check_base_class_offset(lv, (S512C2*), 0, "S512C1");
    check_field_offset(lv, s512c1f0, ABISELECT(960,716), "S512C1.s512c1f0");
    check_field_offset(lv, s512c1f1, ABISELECT(968,720), "S512C1.s512c1f1");
    check_field_offset(lv, s512c1f2, ABISELECT(984,728), "S512C1.s512c1f2");
    check_field_offset(lv, s512c1f3, ABISELECT(1000,740), "S512C1.s512c1f3");
    check_field_offset(lv, s512c1f4, ABISELECT(1008,744), "S512C1.s512c1f4");
    check_field_offset(lv, s512c1f5, ABISELECT(1012,748), "S512C1.s512c1f5");
    check_field_offset(lv, s512c1f6, ABISELECT(1024,760), "S512C1.s512c1f6");
    check_field_offset(lv, s512c1f7, ABISELECT(1036,772), "S512C1.s512c1f7");
    set_bf_and_test(lv, s512c1f8, ABISELECT(1044,780), 0, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f9, ABISELECT(1044,780), 1, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f10, ABISELECT(1044,780), 2, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f11, ABISELECT(1044,780), 3, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f12, ABISELECT(1044,780), 4, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f13, ABISELECT(1044,780), 5, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f14, ABISELECT(1044,780), 6, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f15, ABISELECT(1044,780), 7, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f16, ABISELECT(1045,781), 0, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f17, ABISELECT(1045,781), 1, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f18, ABISELECT(1045,781), 2, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f19, ABISELECT(1045,781), 3, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f20, ABISELECT(1045,781), 4, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f21, ABISELECT(1045,781), 5, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f22, ABISELECT(1045,781), 6, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f23, ABISELECT(1045,781), 7, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f24, ABISELECT(1046,782), 0, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f25, ABISELECT(1046,782), 1, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f26, ABISELECT(1046,782), 2, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f27, ABISELECT(1046,782), 3, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f28, ABISELECT(1046,782), 4, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f29, ABISELECT(1046,782), 5, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f30, ABISELECT(1046,782), 6, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f31, ABISELECT(1046,782), 7, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f32, ABISELECT(1047,783), 0, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f33, ABISELECT(1047,783), 1, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f34, ABISELECT(1047,783), 2, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f35, ABISELECT(1047,783), 3, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f36, ABISELECT(1047,783), 4, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f37, ABISELECT(1047,783), 5, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f38, ABISELECT(1047,783), 6, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f39, ABISELECT(1047,783), 7, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f40, ABISELECT(1048,784), 0, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f41, ABISELECT(1048,784), 1, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f42, ABISELECT(1048,784), 2, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f43, ABISELECT(1048,784), 3, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f44, ABISELECT(1048,784), 4, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f45, ABISELECT(1048,784), 5, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f46, ABISELECT(1048,784), 6, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f47, ABISELECT(1048,784), 7, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f48, ABISELECT(1049,785), 0, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f49, ABISELECT(1049,785), 1, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f50, ABISELECT(1049,785), 2, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f51, ABISELECT(1049,785), 3, 1, 1, "S512C1");
    check_field_offset(lv, s512c1f52, ABISELECT(1052,788), "S512C1.s512c1f52");
    check_field_offset(lv, s512c1f53, ABISELECT(1064,796), "S512C1.s512c1f53");
    check_field_offset(lv, s512c1f54, ABISELECT(1072,800), "S512C1.s512c1f54");
    check_field_offset(lv, s512c1f55, ABISELECT(1080,804), "S512C1.s512c1f55");
    check_field_offset(lv, s512c1f56, ABISELECT(1088,808), "S512C1.s512c1f56");
    check_field_offset(lv, s512c1f57, ABISELECT(1104,824), "S512C1.s512c1f57");
    check_field_offset(lv, s512c1f58, ABISELECT(1112,832), "S512C1.s512c1f58");
    check_field_offset(lv, s512c1f59, ABISELECT(1120,840), "S512C1.s512c1f59");
    check_field_offset(lv, s512c1f60, ABISELECT(1136,848), "S512C1.s512c1f60");
    check_field_offset(lv, s512c1f61, ABISELECT(1148,860), "S512C1.s512c1f61");
    check_field_offset(lv, s512c1f62, ABISELECT(1160,868), "S512C1.s512c1f62");
    check_field_offset(lv, s512c1f63, ABISELECT(1168,872), "S512C1.s512c1f63");
    check_field_offset(lv, s512c1f64, ABISELECT(1184,884), "S512C1.s512c1f64");
    check_field_offset(lv, s512c1f65, ABISELECT(1192,888), "S512C1.s512c1f65");
    check_field_offset(lv, s512c1f66, ABISELECT(1240,936), "S512C1.s512c1f66");
    check_field_offset(lv, s512c1f67, ABISELECT(1248,940), "S512C1.s512c1f67");
    check_field_offset(lv, s512c1f68, ABISELECT(1264,952), "S512C1.s512c1f68");
    check_field_offset(lv, s512c1f69, ABISELECT(1280,964), "S512C1.s512c1f69");
    check_field_offset(lv, s512c1f70, ABISELECT(1296,976), "S512C1.s512c1f70");
    check_field_offset(lv, s512c1f71, ABISELECT(1320,988), "S512C1.s512c1f71");
    check_field_offset(lv, s512c1f72, ABISELECT(1328,992), "S512C1.s512c1f72");
    check_field_offset(lv, s512c1f73, ABISELECT(1360,1008), "S512C1.s512c1f73");
    check_field_offset(lv, s512c1f74, ABISELECT(1372,1020), "S512C1.s512c1f74");
    check_field_offset(lv, s512c1f75, ABISELECT(1384,1032), "S512C1.s512c1f75");
    check_field_offset(lv, s512c1f76, ABISELECT(1392,1036), "S512C1.s512c1f76");
    check_field_offset(lv, s512c1f77, ABISELECT(1400,1040), "S512C1.s512c1f77");
    check_field_offset(lv, s512c1f78, ABISELECT(1408,1044), "S512C1.s512c1f78");
    set_bf_and_test(lv, s512c1f79, ABISELECT(1420,1056), 0, 1, 1, "S512C1");
    set_bf_and_test(lv, s512c1f80, ABISELECT(1420,1056), 1, 1, 1, "S512C1");
    check_field_offset(lv, s512c1f81, ABISELECT(1424,1060), "S512C1.s512c1f81");
    check_field_offset(lv, s512c1f82, ABISELECT(1436,1072), "S512C1.s512c1f82");
    check_field_offset(lv, s512c1f83, ABISELECT(1564,1200), "S512C1.s512c1f83");
    check_field_offset(lv, s512c1f84, ABISELECT(1576,1208), "S512C1.s512c1f84");
    check_field_offset(lv, s512c1f85, ABISELECT(1584,1212), "S512C1.s512c1f85");
    check_field_offset(lv, s512c1f86, ABISELECT(1592,1220), "S512C1.s512c1f86");
    check_field_offset(lv, s512c1f87, ABISELECT(1600,1224), "S512C1.s512c1f87");
    check_field_offset(lv, s512c1f88, ABISELECT(1616,1236), "S512C1.s512c1f88");
    check_field_offset(lv, s512c1f89, ABISELECT(1632,1248), "S512C1.s512c1f89");
    check_field_offset(lv, s512c1f90, ABISELECT(1640,1252), "S512C1.s512c1f90");
    check_field_offset(lv, s512c1f91, ABISELECT(1664,1276), "S512C1.s512c1f91");
    check_field_offset(lv, s512c1f92, ABISELECT(1676,1288), "S512C1.s512c1f92");
    check_field_offset(lv, s512c1f93, ABISELECT(1688,1300), "S512C1.s512c1f93");
    check_field_offset(lv, s512c1f94, ABISELECT(1704,1308), "S512C1.s512c1f94");
    check_field_offset(lv, s512c1f95, ABISELECT(1720,1320), "S512C1.s512c1f95");
    check_field_offset(lv, s512c1f96, ABISELECT(1728,1324), "S512C1.s512c1f96");
    check_field_offset(lv, s512c1f97, ABISELECT(1736,1328), "S512C1.s512c1f97");
    check_field_offset(lv, s512c1f98, ABISELECT(1744,1332), "S512C1.s512c1f98");
    check_field_offset(lv, s512c1f99, ABISELECT(1752,1340), "S512C1.s512c1f99");
    check_field_offset(lv, s512c1f100, ABISELECT(1768,1348), "S512C1.s512c1f100");
    check_field_offset(lv, s512c1f101, ABISELECT(1776,1356), "S512C1.s512c1f101");
    test_class_info(&lv, &cd_S512C1);
    dp->~S512C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS512C1(Test_S512C1, "S512C1", ABISELECT(1792,1368));

#else // __cplusplus

extern void _ZN6S512C1C1Ev();
extern void _ZN6S512C1D1Ev();
Name_Map name_map_S512C1[] = {
  NSPAIR(_ZN6S512C1C1Ev),
  NSPAIR(_ZN6S512C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S512C5;
extern VTBL_ENTRY _ZTI6S512C5[];
extern  VTBL_ENTRY _ZTV6S512C5[];
extern Class_Descriptor cd_S512C4;
extern VTBL_ENTRY _ZTI6S512C4[];
extern  VTBL_ENTRY _ZTV6S512C4[];
extern Class_Descriptor cd_S512C3;
extern VTBL_ENTRY _ZTI6S512C3[];
extern  VTBL_ENTRY _ZTV6S512C3[];
extern Class_Descriptor cd_S512C2;
extern VTBL_ENTRY _ZTI6S512C2[];
extern  VTBL_ENTRY _ZTV6S512C2[];
static Base_Class bases_S512C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S512C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S512C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S512C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S512C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S512C1[];
extern void _ZN6S512C1D1Ev();
extern void _ZN6S512C1D0Ev();
extern void _ZN6S512C53v25Ev();
extern void _ZN6S512C53v26Ev();
extern void _ZN6S512C53v27Ev();
extern void _ZN6S512C53v28Ev();
extern void _ZN6S512C53v29Ev();
extern void _ZN6S512C53v30Ev();
extern void _ZN6S512C53v31Ev();
extern void _ZN6S512C53v32Ev();
extern void _ZN6S512C53v33Ev();
extern void _ZN6S512C53v34Ev();
extern void _ZN6S512C53v35Ev();
extern void _ZN6S512C53v36Ev();
extern void _ZN6S512C53v37Ev();
extern void _ZN6S512C53v38Ev();
extern void _ZN6S512C53v39Ev();
extern void _ZN6S512C53v40Ev();
extern void _ZN6S512C53v41Ev();
extern void _ZN6S512C53v42Ev();
extern void _ZN6S512C53v43Ev();
extern void _ZN6S512C53v44Ev();
extern void _ZN6S512C53v45Ev();
extern void _ZN6S512C53v46Ev();
extern void _ZN6S512C53v47Ev();
extern void _ZN6S512C53v48Ev();
extern void _ZN6S512C53v49Ev();
extern void _ZN6S512C53v50Ev();
extern void _ZN6S512C53v51Ev();
extern void _ZN6S512C53v52Ev();
extern void _ZN6S512C53v53Ev();
extern void _ZN6S512C53v54Ev();
extern void _ZN6S512C53v55Ev();
extern void _ZN6S512C53v56Ev();
extern void _ZN6S512C53v57Ev();
extern void _ZN6S512C53v58Ev();
extern void _ZN6S512C53v59Ev();
extern void _ZN6S512C53v60Ev();
extern void _ZN6S512C53v61Ev();
extern void _ZN6S512C53v62Ev();
extern void _ZN6S512C53v63Ev();
extern void _ZN6S512C53v64Ev();
extern void _ZN6S512C53v65Ev();
extern void _ZN6S512C53v66Ev();
extern void _ZN6S512C53v67Ev();
extern void _ZN6S512C53v68Ev();
extern void _ZN6S512C53v69Ev();
extern void _ZN6S512C53v70Ev();
extern void _ZN6S512C53v71Ev();
extern void _ZN6S512C53v72Ev();
extern void _ZN6S512C53v73Ev();
extern void _ZN6S512C53v74Ev();
extern void _ZN6S512C53v75Ev();
extern void _ZN6S512C53v76Ev();
extern void _ZN6S512C53v77Ev();
extern void _ZN6S512C53v78Ev();
extern void _ZN6S512C53v79Ev();
extern void _ZN6S512C53v80Ev();
extern void _ZN6S512C53v81Ev();
extern void _ZN6S512C53v82Ev();
extern void _ZN6S512C53v83Ev();
extern void _ZN6S512C53v84Ev();
extern void _ZN6S512C53v85Ev();
extern void _ZN6S512C53v86Ev();
extern void _ZN6S512C53v87Ev();
extern void _ZN6S512C53v88Ev();
extern void _ZN6S512C43v89Ev();
extern void _ZN6S512C43v90Ev();
extern void _ZN6S512C43v91Ev();
extern void _ZN6S512C43v92Ev();
extern void _ZN6S512C43v93Ev();
extern void _ZN6S512C43v94Ev();
extern void _ZN6S512C43v95Ev();
extern void _ZN6S512C43v96Ev();
extern void _ZN6S512C43v97Ev();
extern void _ZN6S512C43v98Ev();
extern void _ZN6S512C43v99Ev();
extern void _ZN6S512C44v100Ev();
extern void _ZN6S512C44v101Ev();
extern void _ZN6S512C44v102Ev();
extern void _ZN6S512C44v103Ev();
extern void _ZN6S512C44v104Ev();
extern void _ZN6S512C44v105Ev();
extern void _ZN6S512C44v106Ev();
extern void _ZN6S512C44v107Ev();
extern void _ZN6S512C44v108Ev();
extern void _ZN6S512C44v109Ev();
extern void _ZN6S512C44v110Ev();
extern void _ZN6S512C44v111Ev();
extern void _ZN6S512C44v112Ev();
extern void _ZN6S512C44v113Ev();
extern void _ZN6S512C44v114Ev();
extern void _ZN6S512C44v115Ev();
extern void _ZN6S512C44v116Ev();
extern void _ZN6S512C44v117Ev();
extern void _ZN6S512C44v118Ev();
extern void _ZN6S512C44v119Ev();
extern void _ZN6S512C44v120Ev();
extern void _ZN6S512C44v121Ev();
extern void _ZN6S512C44v122Ev();
extern void _ZN6S512C44v123Ev();
extern void _ZN6S512C44v124Ev();
extern void _ZN6S512C44v125Ev();
extern void _ZN6S512C44v126Ev();
extern void _ZN6S512C44v127Ev();
extern void _ZN6S512C44v128Ev();
extern void _ZN6S512C44v129Ev();
extern void _ZN6S512C44v130Ev();
extern void _ZN6S512C44v131Ev();
extern void _ZN6S512C44v132Ev();
extern void _ZN6S512C44v133Ev();
extern void _ZN6S512C44v134Ev();
extern void _ZN6S512C44v135Ev();
extern void _ZN6S512C44v136Ev();
extern void _ZN6S512C44v137Ev();
extern void _ZN6S512C44v138Ev();
extern void _ZN6S512C44v139Ev();
extern void _ZN6S512C44v140Ev();
extern void _ZN6S512C44v141Ev();
extern void _ZN6S512C44v142Ev();
extern void _ZN6S512C44v143Ev();
extern void _ZN6S512C44v144Ev();
extern void _ZN6S512C44v145Ev();
extern void _ZN6S512C44v146Ev();
extern void _ZN6S512C44v147Ev();
extern void _ZN6S512C44v148Ev();
extern void _ZN6S512C44v149Ev();
extern void _ZN6S512C44v150Ev();
extern void _ZN6S512C44v151Ev();
extern void _ZN6S512C44v152Ev();
extern void _ZN6S512C44v153Ev();
extern void _ZN6S512C44v154Ev();
extern void _ZN6S512C44v155Ev();
extern void _ZN6S512C44v156Ev();
extern void _ZN6S512C44v157Ev();
extern void _ZN6S512C44v158Ev();
extern void _ZN6S512C44v159Ev();
extern void _ZN6S512C44v160Ev();
extern void _ZN6S512C44v161Ev();
extern void _ZN6S512C44v162Ev();
extern void _ZN6S512C44v163Ev();
extern void _ZN6S512C44v164Ev();
extern void _ZN6S512C44v165Ev();
extern void _ZN6S512C44v166Ev();
extern void _ZN6S512C44v167Ev();
extern void _ZN6S512C44v168Ev();
extern void _ZN6S512C44v169Ev();
extern void _ZN6S512C44v170Ev();
extern void _ZN6S512C44v171Ev();
extern void _ZN6S512C44v172Ev();
extern void _ZN6S512C44v173Ev();
extern void _ZN6S512C44v174Ev();
extern void _ZN6S512C44v175Ev();
extern void _ZN6S512C44v176Ev();
extern void _ZN6S512C44v177Ev();
extern void _ZN6S512C44v178Ev();
extern void _ZN6S512C44v179Ev();
extern void _ZN6S512C44v180Ev();
extern void _ZN6S512C44v181Ev();
extern void _ZN6S512C44v182Ev();
extern void _ZN6S512C44v183Ev();
extern void _ZN6S512C44v184Ev();
extern void _ZN6S512C44v185Ev();
extern void _ZN6S512C44v186Ev();
extern void _ZN6S512C44v187Ev();
extern void _ZN6S512C44v188Ev();
extern void _ZN6S512C44v189Ev();
extern void _ZN6S512C44v190Ev();
extern void _ZN6S512C44v191Ev();
extern void _ZN6S512C44v192Ev();
extern void _ZN6S512C44v193Ev();
extern void _ZN6S512C44v194Ev();
extern void _ZN6S512C44v195Ev();
extern void _ZN6S512C44v196Ev();
extern void _ZN6S512C44v197Ev();
extern void _ZN6S512C44v198Ev();
extern void _ZN6S512C44v199Ev();
extern void _ZN6S512C44v200Ev();
extern void _ZN6S512C44v201Ev();
extern void _ZN6S512C44v202Ev();
extern void _ZN6S512C44v203Ev();
extern void _ZN6S512C44v204Ev();
extern void _ZN6S512C44v205Ev();
extern void _ZN6S512C44v206Ev();
extern void _ZN6S512C44v207Ev();
extern void _ZN6S512C44v208Ev();
extern void _ZN6S512C44v209Ev();
extern void _ZN6S512C44v210Ev();
extern void _ZN6S512C44v211Ev();
extern void _ZN6S512C44v212Ev();
extern void _ZN6S512C44v213Ev();
extern void _ZN6S512C44v214Ev();
extern void _ZN6S512C44v215Ev();
extern void _ZN6S512C44v216Ev();
extern void _ZN6S512C44v217Ev();
extern void _ZN6S512C44v218Ev();
extern void _ZN6S512C44v219Ev();
extern void _ZN6S512C44v220Ev();
extern void _ZN6S512C44v221Ev();
extern void _ZN6S512C44v222Ev();
extern void _ZN6S512C44v223Ev();
extern void _ZN6S512C44v224Ev();
extern void _ZN6S512C44v225Ev();
extern void _ZN6S512C44v226Ev();
extern void _ZN6S512C44v227Ev();
extern void _ZN6S512C44v228Ev();
extern void _ZN6S512C44v229Ev();
extern void _ZN6S512C44v230Ev();
extern void _ZN6S512C44v231Ev();
extern void _ZN6S512C34v232Ev();
extern void _ZN6S512C34v233Ev();
extern void _ZN6S512C34v234Ev();
extern void _ZN6S512C34v235Ev();
extern void _ZN6S512C34v236Ev();
extern void _ZN6S512C34v237Ev();
extern void _ZN6S512C34v238Ev();
extern void _ZN6S512C34v239Ev();
extern void _ZN6S512C34v240Ev();
extern void _ZN6S512C34v241Ev();
extern void _ZN6S512C34v242Ev();
extern void _ZN6S512C34v243Ev();
extern void _ZN6S512C34v244Ev();
extern void _ZN6S512C34v245Ev();
extern void _ZN6S512C34v246Ev();
extern void _ZN6S512C34v247Ev();
extern void _ZN6S512C34v248Ev();
extern void _ZN6S512C34v249Ev();
extern void _ZN6S512C34v250Ev();
extern void _ZN6S512C34v251Ev();
extern void _ZN6S512C34v252Ev();
extern void _ZN6S512C34v253Ev();
extern void _ZN6S512C34v254Ev();
extern void _ZN6S512C34v255Ev();
extern void _ZN6S512C34v256Ev();
extern void _ZN6S512C34v257Ev();
extern void _ZN6S512C34v258Ev();
extern void _ZN6S512C34v259Ev();
extern void _ZN6S512C34v260Ev();
extern void _ZN6S512C34v261Ev();
extern void _ZN6S512C34v262Ev();
extern void _ZN6S512C34v263Ev();
extern void _ZN6S512C34v264Ev();
extern void _ZN6S512C34v265Ev();
extern void _ZN6S512C34v266Ev();
extern void _ZN6S512C34v267Ev();
extern void _ZN6S512C34v268Ev();
extern void _ZN6S512C34v269Ev();
extern void _ZN6S512C34v270Ev();
extern void _ZN6S512C34v271Ev();
extern void _ZN6S512C34v272Ev();
extern void _ZN6S512C34v273Ev();
extern void _ZN6S512C34v274Ev();
extern void _ZN6S512C34v275Ev();
extern void _ZN6S512C34v276Ev();
extern void _ZN6S512C34v277Ev();
extern void _ZN6S512C34v278Ev();
extern void _ZN6S512C34v279Ev();
extern void _ZN6S512C34v280Ev();
extern void _ZN6S512C34v281Ev();
extern void _ZN6S512C24v282Ev();
extern void _ZN6S512C24v283Ev();
extern void _ZN6S512C24v284Ev();
extern void _ZN6S512C24v285Ev();
extern void _ZN6S512C24v286Ev();
extern void _ZN6S512C24v287Ev();
extern void _ZN6S512C12v1Ev();
extern void _ZN6S512C12v2Ev();
extern void _ZN6S512C12v3Ev();
extern void _ZN6S512C12v4Ev();
extern void _ZN6S512C12v5Ev();
extern void _ZN6S512C12v6Ev();
extern void _ZN6S512C12v7Ev();
extern void _ZN6S512C12v8Ev();
extern void _ZN6S512C12v9Ev();
extern void _ZN6S512C13v10Ev();
extern void _ZN6S512C13v11Ev();
extern void _ZN6S512C13v12Ev();
extern void _ZN6S512C13v13Ev();
extern void _ZN6S512C13v14Ev();
extern void _ZN6S512C13v15Ev();
extern void _ZN6S512C13v16Ev();
extern void _ZN6S512C13v17Ev();
extern void _ZN6S512C13v18Ev();
extern void _ZN6S512C13v19Ev();
extern void _ZN6S512C13v20Ev();
extern void _ZN6S512C13v21Ev();
extern void _ZN6S512C13v22Ev();
extern void _ZN6S512C13v23Ev();
extern void _ZN6S512C13v24Ev();
static  VTBL_ENTRY vtc_S512C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S512C1[0]),
  (VTBL_ENTRY)&_ZN6S512C1D1Ev,
  (VTBL_ENTRY)&_ZN6S512C1D0Ev,
  (VTBL_ENTRY)&_ZN6S512C53v25Ev,
  (VTBL_ENTRY)&_ZN6S512C53v26Ev,
  (VTBL_ENTRY)&_ZN6S512C53v27Ev,
  (VTBL_ENTRY)&_ZN6S512C53v28Ev,
  (VTBL_ENTRY)&_ZN6S512C53v29Ev,
  (VTBL_ENTRY)&_ZN6S512C53v30Ev,
  (VTBL_ENTRY)&_ZN6S512C53v31Ev,
  (VTBL_ENTRY)&_ZN6S512C53v32Ev,
  (VTBL_ENTRY)&_ZN6S512C53v33Ev,
  (VTBL_ENTRY)&_ZN6S512C53v34Ev,
  (VTBL_ENTRY)&_ZN6S512C53v35Ev,
  (VTBL_ENTRY)&_ZN6S512C53v36Ev,
  (VTBL_ENTRY)&_ZN6S512C53v37Ev,
  (VTBL_ENTRY)&_ZN6S512C53v38Ev,
  (VTBL_ENTRY)&_ZN6S512C53v39Ev,
  (VTBL_ENTRY)&_ZN6S512C53v40Ev,
  (VTBL_ENTRY)&_ZN6S512C53v41Ev,
  (VTBL_ENTRY)&_ZN6S512C53v42Ev,
  (VTBL_ENTRY)&_ZN6S512C53v43Ev,
  (VTBL_ENTRY)&_ZN6S512C53v44Ev,
  (VTBL_ENTRY)&_ZN6S512C53v45Ev,
  (VTBL_ENTRY)&_ZN6S512C53v46Ev,
  (VTBL_ENTRY)&_ZN6S512C53v47Ev,
  (VTBL_ENTRY)&_ZN6S512C53v48Ev,
  (VTBL_ENTRY)&_ZN6S512C53v49Ev,
  (VTBL_ENTRY)&_ZN6S512C53v50Ev,
  (VTBL_ENTRY)&_ZN6S512C53v51Ev,
  (VTBL_ENTRY)&_ZN6S512C53v52Ev,
  (VTBL_ENTRY)&_ZN6S512C53v53Ev,
  (VTBL_ENTRY)&_ZN6S512C53v54Ev,
  (VTBL_ENTRY)&_ZN6S512C53v55Ev,
  (VTBL_ENTRY)&_ZN6S512C53v56Ev,
  (VTBL_ENTRY)&_ZN6S512C53v57Ev,
  (VTBL_ENTRY)&_ZN6S512C53v58Ev,
  (VTBL_ENTRY)&_ZN6S512C53v59Ev,
  (VTBL_ENTRY)&_ZN6S512C53v60Ev,
  (VTBL_ENTRY)&_ZN6S512C53v61Ev,
  (VTBL_ENTRY)&_ZN6S512C53v62Ev,
  (VTBL_ENTRY)&_ZN6S512C53v63Ev,
  (VTBL_ENTRY)&_ZN6S512C53v64Ev,
  (VTBL_ENTRY)&_ZN6S512C53v65Ev,
  (VTBL_ENTRY)&_ZN6S512C53v66Ev,
  (VTBL_ENTRY)&_ZN6S512C53v67Ev,
  (VTBL_ENTRY)&_ZN6S512C53v68Ev,
  (VTBL_ENTRY)&_ZN6S512C53v69Ev,
  (VTBL_ENTRY)&_ZN6S512C53v70Ev,
  (VTBL_ENTRY)&_ZN6S512C53v71Ev,
  (VTBL_ENTRY)&_ZN6S512C53v72Ev,
  (VTBL_ENTRY)&_ZN6S512C53v73Ev,
  (VTBL_ENTRY)&_ZN6S512C53v74Ev,
  (VTBL_ENTRY)&_ZN6S512C53v75Ev,
  (VTBL_ENTRY)&_ZN6S512C53v76Ev,
  (VTBL_ENTRY)&_ZN6S512C53v77Ev,
  (VTBL_ENTRY)&_ZN6S512C53v78Ev,
  (VTBL_ENTRY)&_ZN6S512C53v79Ev,
  (VTBL_ENTRY)&_ZN6S512C53v80Ev,
  (VTBL_ENTRY)&_ZN6S512C53v81Ev,
  (VTBL_ENTRY)&_ZN6S512C53v82Ev,
  (VTBL_ENTRY)&_ZN6S512C53v83Ev,
  (VTBL_ENTRY)&_ZN6S512C53v84Ev,
  (VTBL_ENTRY)&_ZN6S512C53v85Ev,
  (VTBL_ENTRY)&_ZN6S512C53v86Ev,
  (VTBL_ENTRY)&_ZN6S512C53v87Ev,
  (VTBL_ENTRY)&_ZN6S512C53v88Ev,
  (VTBL_ENTRY)&_ZN6S512C43v89Ev,
  (VTBL_ENTRY)&_ZN6S512C43v90Ev,
  (VTBL_ENTRY)&_ZN6S512C43v91Ev,
  (VTBL_ENTRY)&_ZN6S512C43v92Ev,
  (VTBL_ENTRY)&_ZN6S512C43v93Ev,
  (VTBL_ENTRY)&_ZN6S512C43v94Ev,
  (VTBL_ENTRY)&_ZN6S512C43v95Ev,
  (VTBL_ENTRY)&_ZN6S512C43v96Ev,
  (VTBL_ENTRY)&_ZN6S512C43v97Ev,
  (VTBL_ENTRY)&_ZN6S512C43v98Ev,
  (VTBL_ENTRY)&_ZN6S512C43v99Ev,
  (VTBL_ENTRY)&_ZN6S512C44v100Ev,
  (VTBL_ENTRY)&_ZN6S512C44v101Ev,
  (VTBL_ENTRY)&_ZN6S512C44v102Ev,
  (VTBL_ENTRY)&_ZN6S512C44v103Ev,
  (VTBL_ENTRY)&_ZN6S512C44v104Ev,
  (VTBL_ENTRY)&_ZN6S512C44v105Ev,
  (VTBL_ENTRY)&_ZN6S512C44v106Ev,
  (VTBL_ENTRY)&_ZN6S512C44v107Ev,
  (VTBL_ENTRY)&_ZN6S512C44v108Ev,
  (VTBL_ENTRY)&_ZN6S512C44v109Ev,
  (VTBL_ENTRY)&_ZN6S512C44v110Ev,
  (VTBL_ENTRY)&_ZN6S512C44v111Ev,
  (VTBL_ENTRY)&_ZN6S512C44v112Ev,
  (VTBL_ENTRY)&_ZN6S512C44v113Ev,
  (VTBL_ENTRY)&_ZN6S512C44v114Ev,
  (VTBL_ENTRY)&_ZN6S512C44v115Ev,
  (VTBL_ENTRY)&_ZN6S512C44v116Ev,
  (VTBL_ENTRY)&_ZN6S512C44v117Ev,
  (VTBL_ENTRY)&_ZN6S512C44v118Ev,
  (VTBL_ENTRY)&_ZN6S512C44v119Ev,
  (VTBL_ENTRY)&_ZN6S512C44v120Ev,
  (VTBL_ENTRY)&_ZN6S512C44v121Ev,
  (VTBL_ENTRY)&_ZN6S512C44v122Ev,
  (VTBL_ENTRY)&_ZN6S512C44v123Ev,
  (VTBL_ENTRY)&_ZN6S512C44v124Ev,
  (VTBL_ENTRY)&_ZN6S512C44v125Ev,
  (VTBL_ENTRY)&_ZN6S512C44v126Ev,
  (VTBL_ENTRY)&_ZN6S512C44v127Ev,
  (VTBL_ENTRY)&_ZN6S512C44v128Ev,
  (VTBL_ENTRY)&_ZN6S512C44v129Ev,
  (VTBL_ENTRY)&_ZN6S512C44v130Ev,
  (VTBL_ENTRY)&_ZN6S512C44v131Ev,
  (VTBL_ENTRY)&_ZN6S512C44v132Ev,
  (VTBL_ENTRY)&_ZN6S512C44v133Ev,
  (VTBL_ENTRY)&_ZN6S512C44v134Ev,
  (VTBL_ENTRY)&_ZN6S512C44v135Ev,
  (VTBL_ENTRY)&_ZN6S512C44v136Ev,
  (VTBL_ENTRY)&_ZN6S512C44v137Ev,
  (VTBL_ENTRY)&_ZN6S512C44v138Ev,
  (VTBL_ENTRY)&_ZN6S512C44v139Ev,
  (VTBL_ENTRY)&_ZN6S512C44v140Ev,
  (VTBL_ENTRY)&_ZN6S512C44v141Ev,
  (VTBL_ENTRY)&_ZN6S512C44v142Ev,
  (VTBL_ENTRY)&_ZN6S512C44v143Ev,
  (VTBL_ENTRY)&_ZN6S512C44v144Ev,
  (VTBL_ENTRY)&_ZN6S512C44v145Ev,
  (VTBL_ENTRY)&_ZN6S512C44v146Ev,
  (VTBL_ENTRY)&_ZN6S512C44v147Ev,
  (VTBL_ENTRY)&_ZN6S512C44v148Ev,
  (VTBL_ENTRY)&_ZN6S512C44v149Ev,
  (VTBL_ENTRY)&_ZN6S512C44v150Ev,
  (VTBL_ENTRY)&_ZN6S512C44v151Ev,
  (VTBL_ENTRY)&_ZN6S512C44v152Ev,
  (VTBL_ENTRY)&_ZN6S512C44v153Ev,
  (VTBL_ENTRY)&_ZN6S512C44v154Ev,
  (VTBL_ENTRY)&_ZN6S512C44v155Ev,
  (VTBL_ENTRY)&_ZN6S512C44v156Ev,
  (VTBL_ENTRY)&_ZN6S512C44v157Ev,
  (VTBL_ENTRY)&_ZN6S512C44v158Ev,
  (VTBL_ENTRY)&_ZN6S512C44v159Ev,
  (VTBL_ENTRY)&_ZN6S512C44v160Ev,
  (VTBL_ENTRY)&_ZN6S512C44v161Ev,
  (VTBL_ENTRY)&_ZN6S512C44v162Ev,
  (VTBL_ENTRY)&_ZN6S512C44v163Ev,
  (VTBL_ENTRY)&_ZN6S512C44v164Ev,
  (VTBL_ENTRY)&_ZN6S512C44v165Ev,
  (VTBL_ENTRY)&_ZN6S512C44v166Ev,
  (VTBL_ENTRY)&_ZN6S512C44v167Ev,
  (VTBL_ENTRY)&_ZN6S512C44v168Ev,
  (VTBL_ENTRY)&_ZN6S512C44v169Ev,
  (VTBL_ENTRY)&_ZN6S512C44v170Ev,
  (VTBL_ENTRY)&_ZN6S512C44v171Ev,
  (VTBL_ENTRY)&_ZN6S512C44v172Ev,
  (VTBL_ENTRY)&_ZN6S512C44v173Ev,
  (VTBL_ENTRY)&_ZN6S512C44v174Ev,
  (VTBL_ENTRY)&_ZN6S512C44v175Ev,
  (VTBL_ENTRY)&_ZN6S512C44v176Ev,
  (VTBL_ENTRY)&_ZN6S512C44v177Ev,
  (VTBL_ENTRY)&_ZN6S512C44v178Ev,
  (VTBL_ENTRY)&_ZN6S512C44v179Ev,
  (VTBL_ENTRY)&_ZN6S512C44v180Ev,
  (VTBL_ENTRY)&_ZN6S512C44v181Ev,
  (VTBL_ENTRY)&_ZN6S512C44v182Ev,
  (VTBL_ENTRY)&_ZN6S512C44v183Ev,
  (VTBL_ENTRY)&_ZN6S512C44v184Ev,
  (VTBL_ENTRY)&_ZN6S512C44v185Ev,
  (VTBL_ENTRY)&_ZN6S512C44v186Ev,
  (VTBL_ENTRY)&_ZN6S512C44v187Ev,
  (VTBL_ENTRY)&_ZN6S512C44v188Ev,
  (VTBL_ENTRY)&_ZN6S512C44v189Ev,
  (VTBL_ENTRY)&_ZN6S512C44v190Ev,
  (VTBL_ENTRY)&_ZN6S512C44v191Ev,
  (VTBL_ENTRY)&_ZN6S512C44v192Ev,
  (VTBL_ENTRY)&_ZN6S512C44v193Ev,
  (VTBL_ENTRY)&_ZN6S512C44v194Ev,
  (VTBL_ENTRY)&_ZN6S512C44v195Ev,
  (VTBL_ENTRY)&_ZN6S512C44v196Ev,
  (VTBL_ENTRY)&_ZN6S512C44v197Ev,
  (VTBL_ENTRY)&_ZN6S512C44v198Ev,
  (VTBL_ENTRY)&_ZN6S512C44v199Ev,
  (VTBL_ENTRY)&_ZN6S512C44v200Ev,
  (VTBL_ENTRY)&_ZN6S512C44v201Ev,
  (VTBL_ENTRY)&_ZN6S512C44v202Ev,
  (VTBL_ENTRY)&_ZN6S512C44v203Ev,
  (VTBL_ENTRY)&_ZN6S512C44v204Ev,
  (VTBL_ENTRY)&_ZN6S512C44v205Ev,
  (VTBL_ENTRY)&_ZN6S512C44v206Ev,
  (VTBL_ENTRY)&_ZN6S512C44v207Ev,
  (VTBL_ENTRY)&_ZN6S512C44v208Ev,
  (VTBL_ENTRY)&_ZN6S512C44v209Ev,
  (VTBL_ENTRY)&_ZN6S512C44v210Ev,
  (VTBL_ENTRY)&_ZN6S512C44v211Ev,
  (VTBL_ENTRY)&_ZN6S512C44v212Ev,
  (VTBL_ENTRY)&_ZN6S512C44v213Ev,
  (VTBL_ENTRY)&_ZN6S512C44v214Ev,
  (VTBL_ENTRY)&_ZN6S512C44v215Ev,
  (VTBL_ENTRY)&_ZN6S512C44v216Ev,
  (VTBL_ENTRY)&_ZN6S512C44v217Ev,
  (VTBL_ENTRY)&_ZN6S512C44v218Ev,
  (VTBL_ENTRY)&_ZN6S512C44v219Ev,
  (VTBL_ENTRY)&_ZN6S512C44v220Ev,
  (VTBL_ENTRY)&_ZN6S512C44v221Ev,
  (VTBL_ENTRY)&_ZN6S512C44v222Ev,
  (VTBL_ENTRY)&_ZN6S512C44v223Ev,
  (VTBL_ENTRY)&_ZN6S512C44v224Ev,
  (VTBL_ENTRY)&_ZN6S512C44v225Ev,
  (VTBL_ENTRY)&_ZN6S512C44v226Ev,
  (VTBL_ENTRY)&_ZN6S512C44v227Ev,
  (VTBL_ENTRY)&_ZN6S512C44v228Ev,
  (VTBL_ENTRY)&_ZN6S512C44v229Ev,
  (VTBL_ENTRY)&_ZN6S512C44v230Ev,
  (VTBL_ENTRY)&_ZN6S512C44v231Ev,
  (VTBL_ENTRY)&_ZN6S512C34v232Ev,
  (VTBL_ENTRY)&_ZN6S512C34v233Ev,
  (VTBL_ENTRY)&_ZN6S512C34v234Ev,
  (VTBL_ENTRY)&_ZN6S512C34v235Ev,
  (VTBL_ENTRY)&_ZN6S512C34v236Ev,
  (VTBL_ENTRY)&_ZN6S512C34v237Ev,
  (VTBL_ENTRY)&_ZN6S512C34v238Ev,
  (VTBL_ENTRY)&_ZN6S512C34v239Ev,
  (VTBL_ENTRY)&_ZN6S512C34v240Ev,
  (VTBL_ENTRY)&_ZN6S512C34v241Ev,
  (VTBL_ENTRY)&_ZN6S512C34v242Ev,
  (VTBL_ENTRY)&_ZN6S512C34v243Ev,
  (VTBL_ENTRY)&_ZN6S512C34v244Ev,
  (VTBL_ENTRY)&_ZN6S512C34v245Ev,
  (VTBL_ENTRY)&_ZN6S512C34v246Ev,
  (VTBL_ENTRY)&_ZN6S512C34v247Ev,
  (VTBL_ENTRY)&_ZN6S512C34v248Ev,
  (VTBL_ENTRY)&_ZN6S512C34v249Ev,
  (VTBL_ENTRY)&_ZN6S512C34v250Ev,
  (VTBL_ENTRY)&_ZN6S512C34v251Ev,
  (VTBL_ENTRY)&_ZN6S512C34v252Ev,
  (VTBL_ENTRY)&_ZN6S512C34v253Ev,
  (VTBL_ENTRY)&_ZN6S512C34v254Ev,
  (VTBL_ENTRY)&_ZN6S512C34v255Ev,
  (VTBL_ENTRY)&_ZN6S512C34v256Ev,
  (VTBL_ENTRY)&_ZN6S512C34v257Ev,
  (VTBL_ENTRY)&_ZN6S512C34v258Ev,
  (VTBL_ENTRY)&_ZN6S512C34v259Ev,
  (VTBL_ENTRY)&_ZN6S512C34v260Ev,
  (VTBL_ENTRY)&_ZN6S512C34v261Ev,
  (VTBL_ENTRY)&_ZN6S512C34v262Ev,
  (VTBL_ENTRY)&_ZN6S512C34v263Ev,
  (VTBL_ENTRY)&_ZN6S512C34v264Ev,
  (VTBL_ENTRY)&_ZN6S512C34v265Ev,
  (VTBL_ENTRY)&_ZN6S512C34v266Ev,
  (VTBL_ENTRY)&_ZN6S512C34v267Ev,
  (VTBL_ENTRY)&_ZN6S512C34v268Ev,
  (VTBL_ENTRY)&_ZN6S512C34v269Ev,
  (VTBL_ENTRY)&_ZN6S512C34v270Ev,
  (VTBL_ENTRY)&_ZN6S512C34v271Ev,
  (VTBL_ENTRY)&_ZN6S512C34v272Ev,
  (VTBL_ENTRY)&_ZN6S512C34v273Ev,
  (VTBL_ENTRY)&_ZN6S512C34v274Ev,
  (VTBL_ENTRY)&_ZN6S512C34v275Ev,
  (VTBL_ENTRY)&_ZN6S512C34v276Ev,
  (VTBL_ENTRY)&_ZN6S512C34v277Ev,
  (VTBL_ENTRY)&_ZN6S512C34v278Ev,
  (VTBL_ENTRY)&_ZN6S512C34v279Ev,
  (VTBL_ENTRY)&_ZN6S512C34v280Ev,
  (VTBL_ENTRY)&_ZN6S512C34v281Ev,
  (VTBL_ENTRY)&_ZN6S512C24v282Ev,
  (VTBL_ENTRY)&_ZN6S512C24v283Ev,
  (VTBL_ENTRY)&_ZN6S512C24v284Ev,
  (VTBL_ENTRY)&_ZN6S512C24v285Ev,
  (VTBL_ENTRY)&_ZN6S512C24v286Ev,
  (VTBL_ENTRY)&_ZN6S512C24v287Ev,
  (VTBL_ENTRY)&_ZN6S512C12v1Ev,
  (VTBL_ENTRY)&_ZN6S512C12v2Ev,
  (VTBL_ENTRY)&_ZN6S512C12v3Ev,
  (VTBL_ENTRY)&_ZN6S512C12v4Ev,
  (VTBL_ENTRY)&_ZN6S512C12v5Ev,
  (VTBL_ENTRY)&_ZN6S512C12v6Ev,
  (VTBL_ENTRY)&_ZN6S512C12v7Ev,
  (VTBL_ENTRY)&_ZN6S512C12v8Ev,
  (VTBL_ENTRY)&_ZN6S512C12v9Ev,
  (VTBL_ENTRY)&_ZN6S512C13v10Ev,
  (VTBL_ENTRY)&_ZN6S512C13v11Ev,
  (VTBL_ENTRY)&_ZN6S512C13v12Ev,
  (VTBL_ENTRY)&_ZN6S512C13v13Ev,
  (VTBL_ENTRY)&_ZN6S512C13v14Ev,
  (VTBL_ENTRY)&_ZN6S512C13v15Ev,
  (VTBL_ENTRY)&_ZN6S512C13v16Ev,
  (VTBL_ENTRY)&_ZN6S512C13v17Ev,
  (VTBL_ENTRY)&_ZN6S512C13v18Ev,
  (VTBL_ENTRY)&_ZN6S512C13v19Ev,
  (VTBL_ENTRY)&_ZN6S512C13v20Ev,
  (VTBL_ENTRY)&_ZN6S512C13v21Ev,
  (VTBL_ENTRY)&_ZN6S512C13v22Ev,
  (VTBL_ENTRY)&_ZN6S512C13v23Ev,
  (VTBL_ENTRY)&_ZN6S512C13v24Ev,
};
extern VTBL_ENTRY _ZTI6S512C1[];
extern  VTBL_ENTRY _ZTV6S512C1[];
Class_Descriptor cd_S512C1 = {  "S512C1", // class name
  bases_S512C1, 4,
  &(vtc_S512C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1792,1368), // object size
  NSPAIRA(_ZTI6S512C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S512C1),291, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C6_nt  {
  void *s731c6f0;
  int s731c6f1[2];
  ::S28C52_nt s731c6f2;
  void  mf731c6(); // _ZN9S731C6_nt7mf731c6Ev
};
//SIG(-1 S731C6_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S731C6_nt ::mf731c6(){}

//skip512 S731C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C5_nt  {
  ::S731C6_nt s731c5f0;
  void  mf731c5(); // _ZN9S731C5_nt7mf731c5Ev
  virtual  ~S731C5_nt(); // _ZN9S731C5_ntD1Ev
  S731C5_nt(); // tgen
};
//SIG(-1 S731C5_nt) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}}}


void  S731C5_nt ::mf731c5(){}
 S731C5_nt ::~S731C5_nt(){ note_dtor("S731C5_nt", this);}
S731C5_nt ::S731C5_nt(){ note_ctor("S731C5_nt", this);} // tgen

//skip512 S731C5_nt

#else // __cplusplus

extern void _ZN9S731C5_ntC1Ev();
extern void _ZN9S731C5_ntD1Ev();
Name_Map name_map_S731C5_nt[] = {
  NSPAIR(_ZN9S731C5_ntC1Ev),
  NSPAIR(_ZN9S731C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S731C5_nt[];
extern void _ZN9S731C5_ntD1Ev();
extern void _ZN9S731C5_ntD0Ev();
static  VTBL_ENTRY vtc_S731C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S731C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S731C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S731C5_ntD0Ev,
};
extern VTBL_ENTRY _ZTI9S731C5_nt[];
VTBL_ENTRY *P__ZTI9S731C5_nt = _ZTI9S731C5_nt; 
extern  VTBL_ENTRY _ZTV9S731C5_nt[];
Class_Descriptor cd_S731C5_nt = {  "S731C5_nt", // class name
  0,0,//no base classes
  &(vtc_S731C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI9S731C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S731C5_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C8_nt  {
  int s731c8f0[4];
  void *s731c8f1;
  char s731c8f2;
  int s731c8f3[2];
  void *s731c8f4[2];
  void  mf731c8(); // _ZN9S731C8_nt7mf731c8Ev
};
//SIG(-1 S731C8_nt) C1{ m Fi[4] Fp Fc Fi[2] Fp[2]}


void  S731C8_nt ::mf731c8(){}

//skip512 S731C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C4  : S731C5_nt {
  void *s731c4f0;
  ::S731C8_nt s731c4f1;
  virtual  ~S731C4(); // _ZN6S731C4D1Ev
  virtual void  v14(); // _ZN6S731C43v14Ev
  virtual void  v15(); // _ZN6S731C43v15Ev
  virtual void  v16(); // _ZN6S731C43v16Ev
  virtual void  v17(); // _ZN6S731C43v17Ev
  virtual void  v18(); // _ZN6S731C43v18Ev
  virtual void  v19(); // _ZN6S731C43v19Ev
  virtual void  v20(); // _ZN6S731C43v20Ev
  virtual void  v21(); // _ZN6S731C43v21Ev
  virtual void  v22(); // _ZN6S731C43v22Ev
  virtual void  v23(); // _ZN6S731C43v23Ev
  virtual void  v24(); // _ZN6S731C43v24Ev
  S731C4(); // tgen
};
//SIG(-1 S731C4) C1{ BC2{ vd m FC3{ m Fp Fi[2] FC4{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]}}


 S731C4 ::~S731C4(){ note_dtor("S731C4", this);}
void  S731C4 ::v14(){vfunc_called(this, "_ZN6S731C43v14Ev");}
void  S731C4 ::v15(){vfunc_called(this, "_ZN6S731C43v15Ev");}
void  S731C4 ::v16(){vfunc_called(this, "_ZN6S731C43v16Ev");}
void  S731C4 ::v17(){vfunc_called(this, "_ZN6S731C43v17Ev");}
void  S731C4 ::v18(){vfunc_called(this, "_ZN6S731C43v18Ev");}
void  S731C4 ::v19(){vfunc_called(this, "_ZN6S731C43v19Ev");}
void  S731C4 ::v20(){vfunc_called(this, "_ZN6S731C43v20Ev");}
void  S731C4 ::v21(){vfunc_called(this, "_ZN6S731C43v21Ev");}
void  S731C4 ::v22(){vfunc_called(this, "_ZN6S731C43v22Ev");}
void  S731C4 ::v23(){vfunc_called(this, "_ZN6S731C43v23Ev");}
void  S731C4 ::v24(){vfunc_called(this, "_ZN6S731C43v24Ev");}
S731C4 ::S731C4(){ note_ctor("S731C4", this);} // tgen

static void Test_S731C4()
{
  extern Class_Descriptor cd_S731C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,17)];
    init_test(&cd_S731C4, buf);
    S731C4 *dp, &lv = *(dp=new (buf) S731C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,64), "sizeof(S731C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C4)");
    check_base_class_offset(lv, (S731C5_nt*), 0, "S731C4");
    check_field_offset(lv, s731c4f0, ABISELECT(32,20), "S731C4.s731c4f0");
    check_field_offset(lv, s731c4f1, ABISELECT(40,24), "S731C4.s731c4f1");
    test_class_info(&lv, &cd_S731C4);
    dp->~S731C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS731C4(Test_S731C4, "S731C4", ABISELECT(96,64));

#else // __cplusplus

extern void _ZN6S731C4C1Ev();
extern void _ZN6S731C4D1Ev();
Name_Map name_map_S731C4[] = {
  NSPAIR(_ZN6S731C4C1Ev),
  NSPAIR(_ZN6S731C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S731C5_nt;
extern VTBL_ENTRY _ZTI9S731C5_nt[];
extern  VTBL_ENTRY _ZTV9S731C5_nt[];
static Base_Class bases_S731C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S731C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S731C4[];
extern void _ZN6S731C4D1Ev();
extern void _ZN6S731C4D0Ev();
extern void _ZN6S731C43v14Ev();
extern void _ZN6S731C43v15Ev();
extern void _ZN6S731C43v16Ev();
extern void _ZN6S731C43v17Ev();
extern void _ZN6S731C43v18Ev();
extern void _ZN6S731C43v19Ev();
extern void _ZN6S731C43v20Ev();
extern void _ZN6S731C43v21Ev();
extern void _ZN6S731C43v22Ev();
extern void _ZN6S731C43v23Ev();
extern void _ZN6S731C43v24Ev();
static  VTBL_ENTRY vtc_S731C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S731C4[0]),
  (VTBL_ENTRY)&_ZN6S731C4D1Ev,
  (VTBL_ENTRY)&_ZN6S731C4D0Ev,
  (VTBL_ENTRY)&_ZN6S731C43v14Ev,
  (VTBL_ENTRY)&_ZN6S731C43v15Ev,
  (VTBL_ENTRY)&_ZN6S731C43v16Ev,
  (VTBL_ENTRY)&_ZN6S731C43v17Ev,
  (VTBL_ENTRY)&_ZN6S731C43v18Ev,
  (VTBL_ENTRY)&_ZN6S731C43v19Ev,
  (VTBL_ENTRY)&_ZN6S731C43v20Ev,
  (VTBL_ENTRY)&_ZN6S731C43v21Ev,
  (VTBL_ENTRY)&_ZN6S731C43v22Ev,
  (VTBL_ENTRY)&_ZN6S731C43v23Ev,
  (VTBL_ENTRY)&_ZN6S731C43v24Ev,
};
extern VTBL_ENTRY _ZTI6S731C4[];
extern  VTBL_ENTRY _ZTV6S731C4[];
Class_Descriptor cd_S731C4 = {  "S731C4", // class name
  bases_S731C4, 1,
  &(vtc_S731C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,64), // object size
  NSPAIRA(_ZTI6S731C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S731C4),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C3  : S731C4 {
  int s731c3f0;
  virtual  ~S731C3(); // _ZN6S731C3D1Ev
  virtual void  v25(); // _ZN6S731C33v25Ev
  virtual void  v26(); // _ZN6S731C33v26Ev
  virtual void  v27(); // _ZN6S731C33v27Ev
  virtual void  v28(); // _ZN6S731C33v28Ev
  virtual void  v29(); // _ZN6S731C33v29Ev
  virtual void  v30(); // _ZN6S731C33v30Ev
  virtual void  v31(); // _ZN6S731C33v31Ev
  virtual void  v32(); // _ZN6S731C33v32Ev
  virtual void  v33(); // _ZN6S731C33v33Ev
  virtual void  v34(); // _ZN6S731C33v34Ev
  virtual void  v35(); // _ZN6S731C33v35Ev
  virtual void  v36(); // _ZN6S731C33v36Ev
  virtual void  v37(); // _ZN6S731C33v37Ev
  virtual void  v38(); // _ZN6S731C33v38Ev
  virtual void  v39(); // _ZN6S731C33v39Ev
  virtual void  v40(); // _ZN6S731C33v40Ev
  virtual void  v41(); // _ZN6S731C33v41Ev
  virtual void  v42(); // _ZN6S731C33v42Ev
  virtual void  v43(); // _ZN6S731C33v43Ev
  S731C3(); // tgen
};
//SIG(-1 S731C3) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC6{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fi}


 S731C3 ::~S731C3(){ note_dtor("S731C3", this);}
void  S731C3 ::v25(){vfunc_called(this, "_ZN6S731C33v25Ev");}
void  S731C3 ::v26(){vfunc_called(this, "_ZN6S731C33v26Ev");}
void  S731C3 ::v27(){vfunc_called(this, "_ZN6S731C33v27Ev");}
void  S731C3 ::v28(){vfunc_called(this, "_ZN6S731C33v28Ev");}
void  S731C3 ::v29(){vfunc_called(this, "_ZN6S731C33v29Ev");}
void  S731C3 ::v30(){vfunc_called(this, "_ZN6S731C33v30Ev");}
void  S731C3 ::v31(){vfunc_called(this, "_ZN6S731C33v31Ev");}
void  S731C3 ::v32(){vfunc_called(this, "_ZN6S731C33v32Ev");}
void  S731C3 ::v33(){vfunc_called(this, "_ZN6S731C33v33Ev");}
void  S731C3 ::v34(){vfunc_called(this, "_ZN6S731C33v34Ev");}
void  S731C3 ::v35(){vfunc_called(this, "_ZN6S731C33v35Ev");}
void  S731C3 ::v36(){vfunc_called(this, "_ZN6S731C33v36Ev");}
void  S731C3 ::v37(){vfunc_called(this, "_ZN6S731C33v37Ev");}
void  S731C3 ::v38(){vfunc_called(this, "_ZN6S731C33v38Ev");}
void  S731C3 ::v39(){vfunc_called(this, "_ZN6S731C33v39Ev");}
void  S731C3 ::v40(){vfunc_called(this, "_ZN6S731C33v40Ev");}
void  S731C3 ::v41(){vfunc_called(this, "_ZN6S731C33v41Ev");}
void  S731C3 ::v42(){vfunc_called(this, "_ZN6S731C33v42Ev");}
void  S731C3 ::v43(){vfunc_called(this, "_ZN6S731C33v43Ev");}
S731C3 ::S731C3(){ note_ctor("S731C3", this);} // tgen

static void Test_S731C3()
{
  extern Class_Descriptor cd_S731C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,18)];
    init_test(&cd_S731C3, buf);
    S731C3 *dp, &lv = *(dp=new (buf) S731C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,68), "sizeof(S731C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C3)");
    check_base_class_offset(lv, (S731C5_nt*)(S731C4*), 0, "S731C3");
    check_base_class_offset(lv, (S731C4*), 0, "S731C3");
    check_field_offset(lv, s731c3f0, ABISELECT(96,64), "S731C3.s731c3f0");
    test_class_info(&lv, &cd_S731C3);
    dp->~S731C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS731C3(Test_S731C3, "S731C3", ABISELECT(104,68));

#else // __cplusplus

extern void _ZN6S731C3C1Ev();
extern void _ZN6S731C3D1Ev();
Name_Map name_map_S731C3[] = {
  NSPAIR(_ZN6S731C3C1Ev),
  NSPAIR(_ZN6S731C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S731C5_nt;
extern VTBL_ENTRY _ZTI9S731C5_nt[];
extern  VTBL_ENTRY _ZTV9S731C5_nt[];
extern Class_Descriptor cd_S731C4;
extern VTBL_ENTRY _ZTI6S731C4[];
extern  VTBL_ENTRY _ZTV6S731C4[];
static Base_Class bases_S731C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S731C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S731C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S731C3[];
extern void _ZN6S731C3D1Ev();
extern void _ZN6S731C3D0Ev();
extern void _ZN6S731C43v14Ev();
extern void _ZN6S731C43v15Ev();
extern void _ZN6S731C43v16Ev();
extern void _ZN6S731C43v17Ev();
extern void _ZN6S731C43v18Ev();
extern void _ZN6S731C43v19Ev();
extern void _ZN6S731C43v20Ev();
extern void _ZN6S731C43v21Ev();
extern void _ZN6S731C43v22Ev();
extern void _ZN6S731C43v23Ev();
extern void _ZN6S731C43v24Ev();
extern void _ZN6S731C33v25Ev();
extern void _ZN6S731C33v26Ev();
extern void _ZN6S731C33v27Ev();
extern void _ZN6S731C33v28Ev();
extern void _ZN6S731C33v29Ev();
extern void _ZN6S731C33v30Ev();
extern void _ZN6S731C33v31Ev();
extern void _ZN6S731C33v32Ev();
extern void _ZN6S731C33v33Ev();
extern void _ZN6S731C33v34Ev();
extern void _ZN6S731C33v35Ev();
extern void _ZN6S731C33v36Ev();
extern void _ZN6S731C33v37Ev();
extern void _ZN6S731C33v38Ev();
extern void _ZN6S731C33v39Ev();
extern void _ZN6S731C33v40Ev();
extern void _ZN6S731C33v41Ev();
extern void _ZN6S731C33v42Ev();
extern void _ZN6S731C33v43Ev();
static  VTBL_ENTRY vtc_S731C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S731C3[0]),
  (VTBL_ENTRY)&_ZN6S731C3D1Ev,
  (VTBL_ENTRY)&_ZN6S731C3D0Ev,
  (VTBL_ENTRY)&_ZN6S731C43v14Ev,
  (VTBL_ENTRY)&_ZN6S731C43v15Ev,
  (VTBL_ENTRY)&_ZN6S731C43v16Ev,
  (VTBL_ENTRY)&_ZN6S731C43v17Ev,
  (VTBL_ENTRY)&_ZN6S731C43v18Ev,
  (VTBL_ENTRY)&_ZN6S731C43v19Ev,
  (VTBL_ENTRY)&_ZN6S731C43v20Ev,
  (VTBL_ENTRY)&_ZN6S731C43v21Ev,
  (VTBL_ENTRY)&_ZN6S731C43v22Ev,
  (VTBL_ENTRY)&_ZN6S731C43v23Ev,
  (VTBL_ENTRY)&_ZN6S731C43v24Ev,
  (VTBL_ENTRY)&_ZN6S731C33v25Ev,
  (VTBL_ENTRY)&_ZN6S731C33v26Ev,
  (VTBL_ENTRY)&_ZN6S731C33v27Ev,
  (VTBL_ENTRY)&_ZN6S731C33v28Ev,
  (VTBL_ENTRY)&_ZN6S731C33v29Ev,
  (VTBL_ENTRY)&_ZN6S731C33v30Ev,
  (VTBL_ENTRY)&_ZN6S731C33v31Ev,
  (VTBL_ENTRY)&_ZN6S731C33v32Ev,
  (VTBL_ENTRY)&_ZN6S731C33v33Ev,
  (VTBL_ENTRY)&_ZN6S731C33v34Ev,
  (VTBL_ENTRY)&_ZN6S731C33v35Ev,
  (VTBL_ENTRY)&_ZN6S731C33v36Ev,
  (VTBL_ENTRY)&_ZN6S731C33v37Ev,
  (VTBL_ENTRY)&_ZN6S731C33v38Ev,
  (VTBL_ENTRY)&_ZN6S731C33v39Ev,
  (VTBL_ENTRY)&_ZN6S731C33v40Ev,
  (VTBL_ENTRY)&_ZN6S731C33v41Ev,
  (VTBL_ENTRY)&_ZN6S731C33v42Ev,
  (VTBL_ENTRY)&_ZN6S731C33v43Ev,
};
extern VTBL_ENTRY _ZTI6S731C3[];
extern  VTBL_ENTRY _ZTV6S731C3[];
Class_Descriptor cd_S731C3 = {  "S731C3", // class name
  bases_S731C3, 2,
  &(vtc_S731C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,68), // object size
  NSPAIRA(_ZTI6S731C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S731C3),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C2  : S731C3 {
  ::S731C6_nt s731c2f0;
  virtual  ~S731C2(); // _ZN6S731C2D1Ev
  virtual void  v44(); // _ZN6S731C23v44Ev
  virtual void  v45(); // _ZN6S731C23v45Ev
  virtual void  v46(); // _ZN6S731C23v46Ev
  virtual void  v47(); // _ZN6S731C23v47Ev
  virtual void  v48(); // _ZN6S731C23v48Ev
  virtual void  v49(); // _ZN6S731C23v49Ev
  virtual void  v50(); // _ZN6S731C23v50Ev
  S731C2(); // tgen
};
//SIG(-1 S731C2) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi[2] FC6{ m}}} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 Fp FC7{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fi} vd v1 v2 v3 v4 v5 v6 v7 FC5}


 S731C2 ::~S731C2(){ note_dtor("S731C2", this);}
void  S731C2 ::v44(){vfunc_called(this, "_ZN6S731C23v44Ev");}
void  S731C2 ::v45(){vfunc_called(this, "_ZN6S731C23v45Ev");}
void  S731C2 ::v46(){vfunc_called(this, "_ZN6S731C23v46Ev");}
void  S731C2 ::v47(){vfunc_called(this, "_ZN6S731C23v47Ev");}
void  S731C2 ::v48(){vfunc_called(this, "_ZN6S731C23v48Ev");}
void  S731C2 ::v49(){vfunc_called(this, "_ZN6S731C23v49Ev");}
void  S731C2 ::v50(){vfunc_called(this, "_ZN6S731C23v50Ev");}
S731C2 ::S731C2(){ note_ctor("S731C2", this);} // tgen

static void Test_S731C2()
{
  extern Class_Descriptor cd_S731C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,22)];
    init_test(&cd_S731C2, buf);
    S731C2 *dp, &lv = *(dp=new (buf) S731C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,84), "sizeof(S731C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C2)");
    check_base_class_offset(lv, (S731C5_nt*)(S731C4*)(S731C3*), 0, "S731C2");
    check_base_class_offset(lv, (S731C4*)(S731C3*), 0, "S731C2");
    check_base_class_offset(lv, (S731C3*), 0, "S731C2");
    check_field_offset(lv, s731c2f0, ABISELECT(104,68), "S731C2.s731c2f0");
    test_class_info(&lv, &cd_S731C2);
    dp->~S731C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS731C2(Test_S731C2, "S731C2", ABISELECT(128,84));

#else // __cplusplus

extern void _ZN6S731C2C1Ev();
extern void _ZN6S731C2D1Ev();
Name_Map name_map_S731C2[] = {
  NSPAIR(_ZN6S731C2C1Ev),
  NSPAIR(_ZN6S731C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S731C5_nt;
extern VTBL_ENTRY _ZTI9S731C5_nt[];
extern  VTBL_ENTRY _ZTV9S731C5_nt[];
extern Class_Descriptor cd_S731C4;
extern VTBL_ENTRY _ZTI6S731C4[];
extern  VTBL_ENTRY _ZTV6S731C4[];
extern Class_Descriptor cd_S731C3;
extern VTBL_ENTRY _ZTI6S731C3[];
extern  VTBL_ENTRY _ZTV6S731C3[];
static Base_Class bases_S731C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S731C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S731C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S731C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S731C2[];
extern void _ZN6S731C2D1Ev();
extern void _ZN6S731C2D0Ev();
extern void _ZN6S731C43v14Ev();
extern void _ZN6S731C43v15Ev();
extern void _ZN6S731C43v16Ev();
extern void _ZN6S731C43v17Ev();
extern void _ZN6S731C43v18Ev();
extern void _ZN6S731C43v19Ev();
extern void _ZN6S731C43v20Ev();
extern void _ZN6S731C43v21Ev();
extern void _ZN6S731C43v22Ev();
extern void _ZN6S731C43v23Ev();
extern void _ZN6S731C43v24Ev();
extern void _ZN6S731C33v25Ev();
extern void _ZN6S731C33v26Ev();
extern void _ZN6S731C33v27Ev();
extern void _ZN6S731C33v28Ev();
extern void _ZN6S731C33v29Ev();
extern void _ZN6S731C33v30Ev();
extern void _ZN6S731C33v31Ev();
extern void _ZN6S731C33v32Ev();
extern void _ZN6S731C33v33Ev();
extern void _ZN6S731C33v34Ev();
extern void _ZN6S731C33v35Ev();
extern void _ZN6S731C33v36Ev();
extern void _ZN6S731C33v37Ev();
extern void _ZN6S731C33v38Ev();
extern void _ZN6S731C33v39Ev();
extern void _ZN6S731C33v40Ev();
extern void _ZN6S731C33v41Ev();
extern void _ZN6S731C33v42Ev();
extern void _ZN6S731C33v43Ev();
extern void _ZN6S731C23v44Ev();
extern void _ZN6S731C23v45Ev();
extern void _ZN6S731C23v46Ev();
extern void _ZN6S731C23v47Ev();
extern void _ZN6S731C23v48Ev();
extern void _ZN6S731C23v49Ev();
extern void _ZN6S731C23v50Ev();
static  VTBL_ENTRY vtc_S731C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S731C2[0]),
  (VTBL_ENTRY)&_ZN6S731C2D1Ev,
  (VTBL_ENTRY)&_ZN6S731C2D0Ev,
  (VTBL_ENTRY)&_ZN6S731C43v14Ev,
  (VTBL_ENTRY)&_ZN6S731C43v15Ev,
  (VTBL_ENTRY)&_ZN6S731C43v16Ev,
  (VTBL_ENTRY)&_ZN6S731C43v17Ev,
  (VTBL_ENTRY)&_ZN6S731C43v18Ev,
  (VTBL_ENTRY)&_ZN6S731C43v19Ev,
  (VTBL_ENTRY)&_ZN6S731C43v20Ev,
  (VTBL_ENTRY)&_ZN6S731C43v21Ev,
  (VTBL_ENTRY)&_ZN6S731C43v22Ev,
  (VTBL_ENTRY)&_ZN6S731C43v23Ev,
  (VTBL_ENTRY)&_ZN6S731C43v24Ev,
  (VTBL_ENTRY)&_ZN6S731C33v25Ev,
  (VTBL_ENTRY)&_ZN6S731C33v26Ev,
  (VTBL_ENTRY)&_ZN6S731C33v27Ev,
  (VTBL_ENTRY)&_ZN6S731C33v28Ev,
  (VTBL_ENTRY)&_ZN6S731C33v29Ev,
  (VTBL_ENTRY)&_ZN6S731C33v30Ev,
  (VTBL_ENTRY)&_ZN6S731C33v31Ev,
  (VTBL_ENTRY)&_ZN6S731C33v32Ev,
  (VTBL_ENTRY)&_ZN6S731C33v33Ev,
  (VTBL_ENTRY)&_ZN6S731C33v34Ev,
  (VTBL_ENTRY)&_ZN6S731C33v35Ev,
  (VTBL_ENTRY)&_ZN6S731C33v36Ev,
  (VTBL_ENTRY)&_ZN6S731C33v37Ev,
  (VTBL_ENTRY)&_ZN6S731C33v38Ev,
  (VTBL_ENTRY)&_ZN6S731C33v39Ev,
  (VTBL_ENTRY)&_ZN6S731C33v40Ev,
  (VTBL_ENTRY)&_ZN6S731C33v41Ev,
  (VTBL_ENTRY)&_ZN6S731C33v42Ev,
  (VTBL_ENTRY)&_ZN6S731C33v43Ev,
  (VTBL_ENTRY)&_ZN6S731C23v44Ev,
  (VTBL_ENTRY)&_ZN6S731C23v45Ev,
  (VTBL_ENTRY)&_ZN6S731C23v46Ev,
  (VTBL_ENTRY)&_ZN6S731C23v47Ev,
  (VTBL_ENTRY)&_ZN6S731C23v48Ev,
  (VTBL_ENTRY)&_ZN6S731C23v49Ev,
  (VTBL_ENTRY)&_ZN6S731C23v50Ev,
};
extern VTBL_ENTRY _ZTI6S731C2[];
extern  VTBL_ENTRY _ZTV6S731C2[];
Class_Descriptor cd_S731C2 = {  "S731C2", // class name
  bases_S731C2, 3,
  &(vtc_S731C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,84), // object size
  NSPAIRA(_ZTI6S731C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S731C2),41, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C11_nt  {
  virtual  ~S731C11_nt(); // _ZN10S731C11_ntD1Ev
  virtual void  v51(); // _ZN10S731C11_nt3v51Ev
  S731C11_nt(); // tgen
};
//SIG(-1 S731C11_nt) C1{ vd v1}


 S731C11_nt ::~S731C11_nt(){ note_dtor("S731C11_nt", this);}
void  S731C11_nt ::v51(){vfunc_called(this, "_ZN10S731C11_nt3v51Ev");}
S731C11_nt ::S731C11_nt(){ note_ctor("S731C11_nt", this);} // tgen

//skip512 S731C11_nt

#else // __cplusplus

extern void _ZN10S731C11_ntC1Ev();
extern void _ZN10S731C11_ntD1Ev();
Name_Map name_map_S731C11_nt[] = {
  NSPAIR(_ZN10S731C11_ntC1Ev),
  NSPAIR(_ZN10S731C11_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S731C11_nt[];
extern void _ZN10S731C11_ntD1Ev();
extern void _ZN10S731C11_ntD0Ev();
extern void _ZN10S731C11_nt3v51Ev();
static  VTBL_ENTRY vtc_S731C11_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S731C11_nt[0]),
  (VTBL_ENTRY)&_ZN10S731C11_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S731C11_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S731C11_nt3v51Ev,
};
extern VTBL_ENTRY _ZTI10S731C11_nt[];
VTBL_ENTRY *P__ZTI10S731C11_nt = _ZTI10S731C11_nt; 
extern  VTBL_ENTRY _ZTV10S731C11_nt[];
Class_Descriptor cd_S731C11_nt = {  "S731C11_nt", // class name
  0,0,//no base classes
  &(vtc_S731C11_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S731C11_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S731C11_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C12  {
  virtual  ~S731C12(); // _ZN7S731C12D1Ev
  virtual void  v52(); // _ZN7S731C123v52Ev
  S731C12(); // tgen
};
//SIG(-1 S731C12) C1{ vd v1}


 S731C12 ::~S731C12(){ note_dtor("S731C12", this);}
void  S731C12 ::v52(){vfunc_called(this, "_ZN7S731C123v52Ev");}
S731C12 ::S731C12(){ note_ctor("S731C12", this);} // tgen

static void Test_S731C12()
{
  extern Class_Descriptor cd_S731C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S731C12, buf);
    S731C12 *dp, &lv = *(dp=new (buf) S731C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S731C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C12)");
    test_class_info(&lv, &cd_S731C12);
    dp->~S731C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS731C12(Test_S731C12, "S731C12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S731C12C1Ev();
extern void _ZN7S731C12D1Ev();
Name_Map name_map_S731C12[] = {
  NSPAIR(_ZN7S731C12C1Ev),
  NSPAIR(_ZN7S731C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S731C12[];
extern void _ZN7S731C12D1Ev();
extern void _ZN7S731C12D0Ev();
extern void _ZN7S731C123v52Ev();
static  VTBL_ENTRY vtc_S731C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S731C12[0]),
  (VTBL_ENTRY)&_ZN7S731C12D1Ev,
  (VTBL_ENTRY)&_ZN7S731C12D0Ev,
  (VTBL_ENTRY)&_ZN7S731C123v52Ev,
};
extern VTBL_ENTRY _ZTI7S731C12[];
extern  VTBL_ENTRY _ZTV7S731C12[];
Class_Descriptor cd_S731C12 = {  "S731C12", // class name
  0,0,//no base classes
  &(vtc_S731C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S731C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S731C12),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C14_nt  {
  void *s731c14f0;
  void  mf731c14(); // _ZN10S731C14_nt8mf731c14Ev
  virtual  ~S731C14_nt(); // _ZN10S731C14_ntD1Ev
  S731C14_nt(); // tgen
};
//SIG(-1 S731C14_nt) C1{ vd m Fp}


void  S731C14_nt ::mf731c14(){}
 S731C14_nt ::~S731C14_nt(){ note_dtor("S731C14_nt", this);}
S731C14_nt ::S731C14_nt(){ note_ctor("S731C14_nt", this);} // tgen

//skip512 S731C14_nt

#else // __cplusplus

extern void _ZN10S731C14_ntC1Ev();
extern void _ZN10S731C14_ntD1Ev();
Name_Map name_map_S731C14_nt[] = {
  NSPAIR(_ZN10S731C14_ntC1Ev),
  NSPAIR(_ZN10S731C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S731C14_nt[];
extern void _ZN10S731C14_ntD1Ev();
extern void _ZN10S731C14_ntD0Ev();
static  VTBL_ENTRY vtc_S731C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S731C14_nt[0]),
  (VTBL_ENTRY)&_ZN10S731C14_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S731C14_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S731C14_nt[];
VTBL_ENTRY *P__ZTI10S731C14_nt = _ZTI10S731C14_nt; 
extern  VTBL_ENTRY _ZTV10S731C14_nt[];
Class_Descriptor cd_S731C14_nt = {  "S731C14_nt", // class name
  0,0,//no base classes
  &(vtc_S731C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S731C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S731C14_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C13  : S731C14_nt {
  void *s731c13f0;
  int s731c13f1;
  char s731c13f2[2];
  virtual  ~S731C13(); // _ZN7S731C13D1Ev
  S731C13(); // tgen
};
//SIG(-1 S731C13) C1{ BC2{ vd m Fp} vd Fp Fi Fc[2]}


 S731C13 ::~S731C13(){ note_dtor("S731C13", this);}
S731C13 ::S731C13(){ note_ctor("S731C13", this);} // tgen

static void Test_S731C13()
{
  extern Class_Descriptor cd_S731C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S731C13, buf);
    S731C13 *dp, &lv = *(dp=new (buf) S731C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S731C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C13)");
    check_base_class_offset(lv, (S731C14_nt*), 0, "S731C13");
    check_field_offset(lv, s731c13f0, ABISELECT(16,8), "S731C13.s731c13f0");
    check_field_offset(lv, s731c13f1, ABISELECT(24,12), "S731C13.s731c13f1");
    check_field_offset(lv, s731c13f2, ABISELECT(28,16), "S731C13.s731c13f2");
    test_class_info(&lv, &cd_S731C13);
    dp->~S731C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS731C13(Test_S731C13, "S731C13", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN7S731C13C1Ev();
extern void _ZN7S731C13D1Ev();
Name_Map name_map_S731C13[] = {
  NSPAIR(_ZN7S731C13C1Ev),
  NSPAIR(_ZN7S731C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S731C14_nt;
extern VTBL_ENTRY _ZTI10S731C14_nt[];
extern  VTBL_ENTRY _ZTV10S731C14_nt[];
static Base_Class bases_S731C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S731C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S731C13[];
extern void _ZN7S731C13D1Ev();
extern void _ZN7S731C13D0Ev();
static  VTBL_ENTRY vtc_S731C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S731C13[0]),
  (VTBL_ENTRY)&_ZN7S731C13D1Ev,
  (VTBL_ENTRY)&_ZN7S731C13D0Ev,
};
extern VTBL_ENTRY _ZTI7S731C13[];
extern  VTBL_ENTRY _ZTV7S731C13[];
Class_Descriptor cd_S731C13 = {  "S731C13", // class name
  bases_S731C13, 1,
  &(vtc_S731C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI7S731C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S731C13),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C17_nt  {
  void  mf731c17(); // _ZN10S731C17_nt8mf731c17Ev
};
//SIG(-1 S731C17_nt) C1{ m}


void  S731C17_nt ::mf731c17(){}

//skip512 S731C17_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S731C17_nt[];
VTBL_ENTRY *P__ZTI10S731C17_nt = _ZTI10S731C17_nt; 
Class_Descriptor cd_S731C17_nt = {  "S731C17_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S731C17_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C16_nt  {
  void *s731c16f0;
  int s731c16f1;
  ::S731C17_nt s731c16f2;
  void  mf731c16(); // _ZN10S731C16_nt8mf731c16Ev
};
//SIG(-1 S731C16_nt) C1{ m Fp Fi FC2{ m}}


void  S731C16_nt ::mf731c16(){}

//skip512 S731C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C15_nt  {
  ::S731C16_nt s731c15f0;
  int s731c15f1;
  void  mf731c15(); // _ZN10S731C15_nt8mf731c15Ev
};
//SIG(-1 S731C15_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S731C15_nt ::mf731c15(){}

//skip512 S731C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C19_nt  {
  virtual  ~S731C19_nt(); // _ZN10S731C19_ntD1Ev
  virtual void  v62(); // _ZN10S731C19_nt3v62Ev
  virtual void  v63(); // _ZN10S731C19_nt3v63Ev
  virtual void  v64(); // _ZN10S731C19_nt3v64Ev
  virtual void  v65(); // _ZN10S731C19_nt3v65Ev
  virtual void  v66(); // _ZN10S731C19_nt3v66Ev
  virtual void  v67(); // _ZN10S731C19_nt3v67Ev
  virtual void  v68(); // _ZN10S731C19_nt3v68Ev
  virtual void  v69(); // _ZN10S731C19_nt3v69Ev
  virtual void  v70(); // _ZN10S731C19_nt3v70Ev
  S731C19_nt(); // tgen
};
//SIG(-1 S731C19_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S731C19_nt ::~S731C19_nt(){ note_dtor("S731C19_nt", this);}
void  S731C19_nt ::v62(){vfunc_called(this, "_ZN10S731C19_nt3v62Ev");}
void  S731C19_nt ::v63(){vfunc_called(this, "_ZN10S731C19_nt3v63Ev");}
void  S731C19_nt ::v64(){vfunc_called(this, "_ZN10S731C19_nt3v64Ev");}
void  S731C19_nt ::v65(){vfunc_called(this, "_ZN10S731C19_nt3v65Ev");}
void  S731C19_nt ::v66(){vfunc_called(this, "_ZN10S731C19_nt3v66Ev");}
void  S731C19_nt ::v67(){vfunc_called(this, "_ZN10S731C19_nt3v67Ev");}
void  S731C19_nt ::v68(){vfunc_called(this, "_ZN10S731C19_nt3v68Ev");}
void  S731C19_nt ::v69(){vfunc_called(this, "_ZN10S731C19_nt3v69Ev");}
void  S731C19_nt ::v70(){vfunc_called(this, "_ZN10S731C19_nt3v70Ev");}
S731C19_nt ::S731C19_nt(){ note_ctor("S731C19_nt", this);} // tgen

//skip512 S731C19_nt

#else // __cplusplus

extern void _ZN10S731C19_ntC1Ev();
extern void _ZN10S731C19_ntD1Ev();
Name_Map name_map_S731C19_nt[] = {
  NSPAIR(_ZN10S731C19_ntC1Ev),
  NSPAIR(_ZN10S731C19_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S731C19_nt[];
extern void _ZN10S731C19_ntD1Ev();
extern void _ZN10S731C19_ntD0Ev();
extern void _ZN10S731C19_nt3v62Ev();
extern void _ZN10S731C19_nt3v63Ev();
extern void _ZN10S731C19_nt3v64Ev();
extern void _ZN10S731C19_nt3v65Ev();
extern void _ZN10S731C19_nt3v66Ev();
extern void _ZN10S731C19_nt3v67Ev();
extern void _ZN10S731C19_nt3v68Ev();
extern void _ZN10S731C19_nt3v69Ev();
extern void _ZN10S731C19_nt3v70Ev();
static  VTBL_ENTRY vtc_S731C19_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S731C19_nt[0]),
  (VTBL_ENTRY)&_ZN10S731C19_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S731C19_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI10S731C19_nt[];
VTBL_ENTRY *P__ZTI10S731C19_nt = _ZTI10S731C19_nt; 
extern  VTBL_ENTRY _ZTV10S731C19_nt[];
Class_Descriptor cd_S731C19_nt = {  "S731C19_nt", // class name
  0,0,//no base classes
  &(vtc_S731C19_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S731C19_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S731C19_nt),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C20  {
  void *s731c20f0;
  int s731c20f1[2];
  ::S731C17_nt s731c20f2;
  void  mf731c20(); // _ZN7S731C208mf731c20Ev
};
//SIG(-1 S731C20) C1{ m Fp Fi[2] FC2{ m}}


void  S731C20 ::mf731c20(){}

static void Test_S731C20()
{
  {
    init_simple_test("S731C20");
    S731C20 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S731C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C20)");
    check_field_offset(lv, s731c20f0, 0, "S731C20.s731c20f0");
    check_field_offset(lv, s731c20f1, ABISELECT(8,4), "S731C20.s731c20f1");
    check_field_offset(lv, s731c20f2, ABISELECT(16,12), "S731C20.s731c20f2");
  }
}
static Arrange_To_Call_Me vS731C20(Test_S731C20, "S731C20", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C18  : S731C19_nt {
  ::S731C20 s731c18f0;
  char s731c18f1;
  virtual  ~S731C18(); // _ZN7S731C18D1Ev
  virtual void  v53(); // _ZN7S731C183v53Ev
  virtual void  v54(); // _ZN7S731C183v54Ev
  virtual void  v55(); // _ZN7S731C183v55Ev
  virtual void  v56(); // _ZN7S731C183v56Ev
  virtual void  v57(); // _ZN7S731C183v57Ev
  virtual void  v58(); // _ZN7S731C183v58Ev
  virtual void  v59(); // _ZN7S731C183v59Ev
  virtual void  v60(); // _ZN7S731C183v60Ev
  virtual void  v61(); // _ZN7S731C183v61Ev
  S731C18(); // tgen
};
//SIG(-1 S731C18) C1{ BC2{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC3{ m Fp Fi[2] FC4{ m}} Fc}


 S731C18 ::~S731C18(){ note_dtor("S731C18", this);}
void  S731C18 ::v53(){vfunc_called(this, "_ZN7S731C183v53Ev");}
void  S731C18 ::v54(){vfunc_called(this, "_ZN7S731C183v54Ev");}
void  S731C18 ::v55(){vfunc_called(this, "_ZN7S731C183v55Ev");}
void  S731C18 ::v56(){vfunc_called(this, "_ZN7S731C183v56Ev");}
void  S731C18 ::v57(){vfunc_called(this, "_ZN7S731C183v57Ev");}
void  S731C18 ::v58(){vfunc_called(this, "_ZN7S731C183v58Ev");}
void  S731C18 ::v59(){vfunc_called(this, "_ZN7S731C183v59Ev");}
void  S731C18 ::v60(){vfunc_called(this, "_ZN7S731C183v60Ev");}
void  S731C18 ::v61(){vfunc_called(this, "_ZN7S731C183v61Ev");}
S731C18 ::S731C18(){ note_ctor("S731C18", this);} // tgen

static void Test_S731C18()
{
  extern Class_Descriptor cd_S731C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S731C18, buf);
    S731C18 *dp, &lv = *(dp=new (buf) S731C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S731C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C18)");
    check_base_class_offset(lv, (S731C19_nt*), 0, "S731C18");
    check_field_offset(lv, s731c18f0, ABISELECT(8,4), "S731C18.s731c18f0");
    check_field_offset(lv, s731c18f1, ABISELECT(32,20), "S731C18.s731c18f1");
    test_class_info(&lv, &cd_S731C18);
    dp->~S731C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS731C18(Test_S731C18, "S731C18", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN7S731C18C1Ev();
extern void _ZN7S731C18D1Ev();
Name_Map name_map_S731C18[] = {
  NSPAIR(_ZN7S731C18C1Ev),
  NSPAIR(_ZN7S731C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S731C19_nt;
extern VTBL_ENTRY _ZTI10S731C19_nt[];
extern  VTBL_ENTRY _ZTV10S731C19_nt[];
static Base_Class bases_S731C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S731C19_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S731C18[];
extern void _ZN7S731C18D1Ev();
extern void _ZN7S731C18D0Ev();
extern void _ZN10S731C19_nt3v62Ev();
extern void _ZN10S731C19_nt3v63Ev();
extern void _ZN10S731C19_nt3v64Ev();
extern void _ZN10S731C19_nt3v65Ev();
extern void _ZN10S731C19_nt3v66Ev();
extern void _ZN10S731C19_nt3v67Ev();
extern void _ZN10S731C19_nt3v68Ev();
extern void _ZN10S731C19_nt3v69Ev();
extern void _ZN10S731C19_nt3v70Ev();
extern void _ZN7S731C183v53Ev();
extern void _ZN7S731C183v54Ev();
extern void _ZN7S731C183v55Ev();
extern void _ZN7S731C183v56Ev();
extern void _ZN7S731C183v57Ev();
extern void _ZN7S731C183v58Ev();
extern void _ZN7S731C183v59Ev();
extern void _ZN7S731C183v60Ev();
extern void _ZN7S731C183v61Ev();
static  VTBL_ENTRY vtc_S731C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S731C18[0]),
  (VTBL_ENTRY)&_ZN7S731C18D1Ev,
  (VTBL_ENTRY)&_ZN7S731C18D0Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S731C19_nt3v70Ev,
  (VTBL_ENTRY)&_ZN7S731C183v53Ev,
  (VTBL_ENTRY)&_ZN7S731C183v54Ev,
  (VTBL_ENTRY)&_ZN7S731C183v55Ev,
  (VTBL_ENTRY)&_ZN7S731C183v56Ev,
  (VTBL_ENTRY)&_ZN7S731C183v57Ev,
  (VTBL_ENTRY)&_ZN7S731C183v58Ev,
  (VTBL_ENTRY)&_ZN7S731C183v59Ev,
  (VTBL_ENTRY)&_ZN7S731C183v60Ev,
  (VTBL_ENTRY)&_ZN7S731C183v61Ev,
};
extern VTBL_ENTRY _ZTI7S731C18[];
extern  VTBL_ENTRY _ZTV7S731C18[];
Class_Descriptor cd_S731C18 = {  "S731C18", // class name
  bases_S731C18, 1,
  &(vtc_S731C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI7S731C18),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S731C18),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S731C1  : S731C2 , S731C11_nt , S731C12 {
  ::S731C13 s731c1f0;
  ::S731C15_nt s731c1f1;
  ::S731C18 s731c1f2;
  char s731c1f3;
  ::S731C20 s731c1f4;
  ::S731C20 s731c1f5;
  virtual  ~S731C1(); // _ZN6S731C1D1Ev
  virtual void  v1(); // _ZN6S731C12v1Ev
  virtual void  v2(); // _ZN6S731C12v2Ev
  virtual void  v3(); // _ZN6S731C12v3Ev
  virtual void  v4(); // _ZN6S731C12v4Ev
  virtual void  v5(); // _ZN6S731C12v5Ev
  virtual void  v6(); // _ZN6S731C12v6Ev
  virtual void  v7(); // _ZN6S731C12v7Ev
  virtual void  v8(); // _ZN6S731C12v8Ev
  virtual void  v9(); // _ZN6S731C12v9Ev
  virtual void  v10(); // _ZN6S731C13v10Ev
  virtual void  v11(); // _ZN6S731C13v11Ev
  virtual void  v12(); // _ZN6S731C13v12Ev
  virtual void  v13(); // _ZN6S731C13v13Ev
  S731C1(); // tgen
};
//SIG(1 S731C1) C1{ BC2{ BC3{ BC4{ BC5{ vd m FC6{ m Fp Fi[2] FC7{ m}}} vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC8{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 Fi} vd v44 v45 v46 v47 v48 v49 v50 FC6} BC9{ vd v51} BC10{ vd v52} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 FC11{ BC12{ vd m Fp} vd Fp Fi Fc[2]} FC13{ m FC14{ m Fp Fi FC15{ m}} Fi} FC16{ BC17{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70} vd v53 v54 v55 v56 v57 v58 v59 v60 v61 FC18{ m Fp Fi[2] FC15} Fc} Fc FC18 FC18}


 S731C1 ::~S731C1(){ note_dtor("S731C1", this);}
void  S731C1 ::v1(){vfunc_called(this, "_ZN6S731C12v1Ev");}
void  S731C1 ::v2(){vfunc_called(this, "_ZN6S731C12v2Ev");}
void  S731C1 ::v3(){vfunc_called(this, "_ZN6S731C12v3Ev");}
void  S731C1 ::v4(){vfunc_called(this, "_ZN6S731C12v4Ev");}
void  S731C1 ::v5(){vfunc_called(this, "_ZN6S731C12v5Ev");}
void  S731C1 ::v6(){vfunc_called(this, "_ZN6S731C12v6Ev");}
void  S731C1 ::v7(){vfunc_called(this, "_ZN6S731C12v7Ev");}
void  S731C1 ::v8(){vfunc_called(this, "_ZN6S731C12v8Ev");}
void  S731C1 ::v9(){vfunc_called(this, "_ZN6S731C12v9Ev");}
void  S731C1 ::v10(){vfunc_called(this, "_ZN6S731C13v10Ev");}
void  S731C1 ::v11(){vfunc_called(this, "_ZN6S731C13v11Ev");}
void  S731C1 ::v12(){vfunc_called(this, "_ZN6S731C13v12Ev");}
void  S731C1 ::v13(){vfunc_called(this, "_ZN6S731C13v13Ev");}
S731C1 ::S731C1(){ note_ctor("S731C1", this);} // tgen

static void Test_S731C1()
{
  extern Class_Descriptor cd_S731C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,48)];
    init_test(&cd_S731C1, buf);
    S731C1 *dp, &lv = *(dp=new (buf) S731C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,188), "sizeof(S731C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S731C1)");
    check_base_class_offset(lv, (S731C5_nt*)(S731C4*)(S731C3*)(S731C2*), 0, "S731C1");
    check_base_class_offset(lv, (S731C4*)(S731C3*)(S731C2*), 0, "S731C1");
    check_base_class_offset(lv, (S731C3*)(S731C2*), 0, "S731C1");
    check_base_class_offset(lv, (S731C2*), 0, "S731C1");
    check_base_class_offset(lv, (S731C11_nt*), ABISELECT(128,84), "S731C1");
    check_base_class_offset(lv, (S731C12*), ABISELECT(136,88), "S731C1");
    check_field_offset(lv, s731c1f0, ABISELECT(144,92), "S731C1.s731c1f0");
    check_field_offset(lv, s731c1f1, ABISELECT(176,112), "S731C1.s731c1f1");
    check_field_offset(lv, s731c1f2, ABISELECT(200,128), "S731C1.s731c1f2");
    check_field_offset(lv, s731c1f3, ABISELECT(240,152), "S731C1.s731c1f3");
    check_field_offset(lv, s731c1f4, ABISELECT(248,156), "S731C1.s731c1f4");
    check_field_offset(lv, s731c1f5, ABISELECT(272,172), "S731C1.s731c1f5");
    test_class_info(&lv, &cd_S731C1);
    dp->~S731C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS731C1(Test_S731C1, "S731C1", ABISELECT(296,188));

#else // __cplusplus

extern void _ZN6S731C1C1Ev();
extern void _ZN6S731C1D1Ev();
Name_Map name_map_S731C1[] = {
  NSPAIR(_ZN6S731C1C1Ev),
  NSPAIR(_ZN6S731C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S731C5_nt;
extern VTBL_ENTRY _ZTI9S731C5_nt[];
extern  VTBL_ENTRY _ZTV9S731C5_nt[];
extern Class_Descriptor cd_S731C4;
extern VTBL_ENTRY _ZTI6S731C4[];
extern  VTBL_ENTRY _ZTV6S731C4[];
extern Class_Descriptor cd_S731C3;
extern VTBL_ENTRY _ZTI6S731C3[];
extern  VTBL_ENTRY _ZTV6S731C3[];
extern Class_Descriptor cd_S731C2;
extern VTBL_ENTRY _ZTI6S731C2[];
extern  VTBL_ENTRY _ZTV6S731C2[];
extern Class_Descriptor cd_S731C11_nt;
extern VTBL_ENTRY _ZTI10S731C11_nt[];
extern  VTBL_ENTRY _ZTV10S731C11_nt[];
extern Class_Descriptor cd_S731C12;
extern VTBL_ENTRY _ZTI7S731C12[];
extern  VTBL_ENTRY _ZTV7S731C12[];
static Base_Class bases_S731C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S731C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S731C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S731C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S731C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C11_nt,    ABISELECT(128,84), //bcp->offset
    54, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C12,    ABISELECT(136,88), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S731C1[];
extern void _ZN6S731C1D1Ev();
extern void _ZN6S731C1D0Ev();
extern void _ZN6S731C43v14Ev();
extern void _ZN6S731C43v15Ev();
extern void _ZN6S731C43v16Ev();
extern void _ZN6S731C43v17Ev();
extern void _ZN6S731C43v18Ev();
extern void _ZN6S731C43v19Ev();
extern void _ZN6S731C43v20Ev();
extern void _ZN6S731C43v21Ev();
extern void _ZN6S731C43v22Ev();
extern void _ZN6S731C43v23Ev();
extern void _ZN6S731C43v24Ev();
extern void _ZN6S731C33v25Ev();
extern void _ZN6S731C33v26Ev();
extern void _ZN6S731C33v27Ev();
extern void _ZN6S731C33v28Ev();
extern void _ZN6S731C33v29Ev();
extern void _ZN6S731C33v30Ev();
extern void _ZN6S731C33v31Ev();
extern void _ZN6S731C33v32Ev();
extern void _ZN6S731C33v33Ev();
extern void _ZN6S731C33v34Ev();
extern void _ZN6S731C33v35Ev();
extern void _ZN6S731C33v36Ev();
extern void _ZN6S731C33v37Ev();
extern void _ZN6S731C33v38Ev();
extern void _ZN6S731C33v39Ev();
extern void _ZN6S731C33v40Ev();
extern void _ZN6S731C33v41Ev();
extern void _ZN6S731C33v42Ev();
extern void _ZN6S731C33v43Ev();
extern void _ZN6S731C23v44Ev();
extern void _ZN6S731C23v45Ev();
extern void _ZN6S731C23v46Ev();
extern void _ZN6S731C23v47Ev();
extern void _ZN6S731C23v48Ev();
extern void _ZN6S731C23v49Ev();
extern void _ZN6S731C23v50Ev();
extern void _ZN6S731C12v1Ev();
extern void _ZN6S731C12v2Ev();
extern void _ZN6S731C12v3Ev();
extern void _ZN6S731C12v4Ev();
extern void _ZN6S731C12v5Ev();
extern void _ZN6S731C12v6Ev();
extern void _ZN6S731C12v7Ev();
extern void _ZN6S731C12v8Ev();
extern void _ZN6S731C12v9Ev();
extern void _ZN6S731C13v10Ev();
extern void _ZN6S731C13v11Ev();
extern void _ZN6S731C13v12Ev();
extern void _ZN6S731C13v13Ev();
extern void ABISELECT(_ZThn128_N6S731C1D1Ev,_ZThn84_N6S731C1D1Ev)();
extern void ABISELECT(_ZThn128_N6S731C1D0Ev,_ZThn84_N6S731C1D0Ev)();
extern void _ZN10S731C11_nt3v51Ev();
extern void ABISELECT(_ZThn136_N6S731C1D1Ev,_ZThn88_N6S731C1D1Ev)();
extern void ABISELECT(_ZThn136_N6S731C1D0Ev,_ZThn88_N6S731C1D0Ev)();
extern void _ZN7S731C123v52Ev();
static  VTBL_ENTRY vtc_S731C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S731C1[0]),
  (VTBL_ENTRY)&_ZN6S731C1D1Ev,
  (VTBL_ENTRY)&_ZN6S731C1D0Ev,
  (VTBL_ENTRY)&_ZN6S731C43v14Ev,
  (VTBL_ENTRY)&_ZN6S731C43v15Ev,
  (VTBL_ENTRY)&_ZN6S731C43v16Ev,
  (VTBL_ENTRY)&_ZN6S731C43v17Ev,
  (VTBL_ENTRY)&_ZN6S731C43v18Ev,
  (VTBL_ENTRY)&_ZN6S731C43v19Ev,
  (VTBL_ENTRY)&_ZN6S731C43v20Ev,
  (VTBL_ENTRY)&_ZN6S731C43v21Ev,
  (VTBL_ENTRY)&_ZN6S731C43v22Ev,
  (VTBL_ENTRY)&_ZN6S731C43v23Ev,
  (VTBL_ENTRY)&_ZN6S731C43v24Ev,
  (VTBL_ENTRY)&_ZN6S731C33v25Ev,
  (VTBL_ENTRY)&_ZN6S731C33v26Ev,
  (VTBL_ENTRY)&_ZN6S731C33v27Ev,
  (VTBL_ENTRY)&_ZN6S731C33v28Ev,
  (VTBL_ENTRY)&_ZN6S731C33v29Ev,
  (VTBL_ENTRY)&_ZN6S731C33v30Ev,
  (VTBL_ENTRY)&_ZN6S731C33v31Ev,
  (VTBL_ENTRY)&_ZN6S731C33v32Ev,
  (VTBL_ENTRY)&_ZN6S731C33v33Ev,
  (VTBL_ENTRY)&_ZN6S731C33v34Ev,
  (VTBL_ENTRY)&_ZN6S731C33v35Ev,
  (VTBL_ENTRY)&_ZN6S731C33v36Ev,
  (VTBL_ENTRY)&_ZN6S731C33v37Ev,
  (VTBL_ENTRY)&_ZN6S731C33v38Ev,
  (VTBL_ENTRY)&_ZN6S731C33v39Ev,
  (VTBL_ENTRY)&_ZN6S731C33v40Ev,
  (VTBL_ENTRY)&_ZN6S731C33v41Ev,
  (VTBL_ENTRY)&_ZN6S731C33v42Ev,
  (VTBL_ENTRY)&_ZN6S731C33v43Ev,
  (VTBL_ENTRY)&_ZN6S731C23v44Ev,
  (VTBL_ENTRY)&_ZN6S731C23v45Ev,
  (VTBL_ENTRY)&_ZN6S731C23v46Ev,
  (VTBL_ENTRY)&_ZN6S731C23v47Ev,
  (VTBL_ENTRY)&_ZN6S731C23v48Ev,
  (VTBL_ENTRY)&_ZN6S731C23v49Ev,
  (VTBL_ENTRY)&_ZN6S731C23v50Ev,
  (VTBL_ENTRY)&_ZN6S731C12v1Ev,
  (VTBL_ENTRY)&_ZN6S731C12v2Ev,
  (VTBL_ENTRY)&_ZN6S731C12v3Ev,
  (VTBL_ENTRY)&_ZN6S731C12v4Ev,
  (VTBL_ENTRY)&_ZN6S731C12v5Ev,
  (VTBL_ENTRY)&_ZN6S731C12v6Ev,
  (VTBL_ENTRY)&_ZN6S731C12v7Ev,
  (VTBL_ENTRY)&_ZN6S731C12v8Ev,
  (VTBL_ENTRY)&_ZN6S731C12v9Ev,
  (VTBL_ENTRY)&_ZN6S731C13v10Ev,
  (VTBL_ENTRY)&_ZN6S731C13v11Ev,
  (VTBL_ENTRY)&_ZN6S731C13v12Ev,
  (VTBL_ENTRY)&_ZN6S731C13v13Ev,
  ABISELECT(-128,-84),
  (VTBL_ENTRY)&(_ZTI6S731C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N6S731C1D1Ev,_ZThn84_N6S731C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N6S731C1D0Ev,_ZThn84_N6S731C1D0Ev),
  (VTBL_ENTRY)&_ZN10S731C11_nt3v51Ev,
  ABISELECT(-136,-88),
  (VTBL_ENTRY)&(_ZTI6S731C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N6S731C1D1Ev,_ZThn88_N6S731C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N6S731C1D0Ev,_ZThn88_N6S731C1D0Ev),
  (VTBL_ENTRY)&_ZN7S731C123v52Ev,
};
extern VTBL_ENTRY _ZTI6S731C1[];
extern  VTBL_ENTRY _ZTV6S731C1[];
Class_Descriptor cd_S731C1 = {  "S731C1", // class name
  bases_S731C1, 6,
  &(vtc_S731C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,188), // object size
  NSPAIRA(_ZTI6S731C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S731C1),64, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1508C4  {
  int s1508c4f0;
  __tsi64 s1508c4f1;
  void *s1508c4f2[4];
  int s1508c4f3[2];
  void *s1508c4f4;
  ::S28C9_nt s1508c4f5;
  void *s1508c4f6[2];
  virtual  ~S1508C4(); // _ZN7S1508C4D1Ev
  virtual void  v6(); // _ZN7S1508C42v6Ev
  virtual void  v7(); // _ZN7S1508C42v7Ev
  virtual void  v8(); // _ZN7S1508C42v8Ev
  virtual void  v9(); // _ZN7S1508C42v9Ev
  virtual void  v10(); // _ZN7S1508C43v10Ev
  virtual void  v11(); // _ZN7S1508C43v11Ev
  virtual void  v12(); // _ZN7S1508C43v12Ev
  virtual void  v13(); // _ZN7S1508C43v13Ev
  virtual void  v14(); // _ZN7S1508C43v14Ev
  virtual void  v15(); // _ZN7S1508C43v15Ev
  virtual void  v16(); // _ZN7S1508C43v16Ev
  virtual void  v17(); // _ZN7S1508C43v17Ev
  virtual void  v18(); // _ZN7S1508C43v18Ev
  virtual void  v19(); // _ZN7S1508C43v19Ev
  virtual void  v20(); // _ZN7S1508C43v20Ev
  virtual void  v21(); // _ZN7S1508C43v21Ev
  virtual void  v22(); // _ZN7S1508C43v22Ev
  virtual void  v23(); // _ZN7S1508C43v23Ev
  virtual void  v24(); // _ZN7S1508C43v24Ev
  virtual void  v25(); // _ZN7S1508C43v25Ev
  virtual void  v26(); // _ZN7S1508C43v26Ev
  virtual void  v27(); // _ZN7S1508C43v27Ev
  virtual void  v28(); // _ZN7S1508C43v28Ev
  virtual void  v29(); // _ZN7S1508C43v29Ev
  virtual void  v30(); // _ZN7S1508C43v30Ev
  virtual void  v31(); // _ZN7S1508C43v31Ev
  virtual void  v32(); // _ZN7S1508C43v32Ev
  virtual void  v33(); // _ZN7S1508C43v33Ev
  virtual void  v34(); // _ZN7S1508C43v34Ev
  virtual void  v35(); // _ZN7S1508C43v35Ev
  virtual void  v36(); // _ZN7S1508C43v36Ev
  virtual void  v37(); // _ZN7S1508C43v37Ev
  virtual void  v38(); // _ZN7S1508C43v38Ev
  virtual void  v39(); // _ZN7S1508C43v39Ev
  virtual void  v40(); // _ZN7S1508C43v40Ev
  virtual void  v41(); // _ZN7S1508C43v41Ev
  virtual void  v42(); // _ZN7S1508C43v42Ev
  virtual void  v43(); // _ZN7S1508C43v43Ev
  virtual void  v44(); // _ZN7S1508C43v44Ev
  virtual void  v45(); // _ZN7S1508C43v45Ev
  virtual void  v46(); // _ZN7S1508C43v46Ev
  virtual void  v47(); // _ZN7S1508C43v47Ev
  virtual void  v48(); // _ZN7S1508C43v48Ev
  virtual void  v49(); // _ZN7S1508C43v49Ev
  virtual void  v50(); // _ZN7S1508C43v50Ev
  virtual void  v51(); // _ZN7S1508C43v51Ev
  virtual void  v52(); // _ZN7S1508C43v52Ev
  virtual void  v53(); // _ZN7S1508C43v53Ev
  virtual void  v54(); // _ZN7S1508C43v54Ev
  virtual void  v55(); // _ZN7S1508C43v55Ev
  virtual void  v56(); // _ZN7S1508C43v56Ev
  virtual void  v57(); // _ZN7S1508C43v57Ev
  virtual void  v58(); // _ZN7S1508C43v58Ev
  virtual void  v59(); // _ZN7S1508C43v59Ev
  virtual void  v60(); // _ZN7S1508C43v60Ev
  virtual void  v61(); // _ZN7S1508C43v61Ev
  virtual void  v62(); // _ZN7S1508C43v62Ev
  virtual void  v63(); // _ZN7S1508C43v63Ev
  virtual void  v64(); // _ZN7S1508C43v64Ev
  virtual void  v65(); // _ZN7S1508C43v65Ev
  virtual void  v66(); // _ZN7S1508C43v66Ev
  virtual void  v67(); // _ZN7S1508C43v67Ev
  virtual void  v68(); // _ZN7S1508C43v68Ev
  virtual void  v69(); // _ZN7S1508C43v69Ev
  S1508C4(); // tgen
};
//SIG(-1 S1508C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1508C4 ::~S1508C4(){ note_dtor("S1508C4", this);}
void  S1508C4 ::v6(){vfunc_called(this, "_ZN7S1508C42v6Ev");}
void  S1508C4 ::v7(){vfunc_called(this, "_ZN7S1508C42v7Ev");}
void  S1508C4 ::v8(){vfunc_called(this, "_ZN7S1508C42v8Ev");}
void  S1508C4 ::v9(){vfunc_called(this, "_ZN7S1508C42v9Ev");}
void  S1508C4 ::v10(){vfunc_called(this, "_ZN7S1508C43v10Ev");}
void  S1508C4 ::v11(){vfunc_called(this, "_ZN7S1508C43v11Ev");}
void  S1508C4 ::v12(){vfunc_called(this, "_ZN7S1508C43v12Ev");}
void  S1508C4 ::v13(){vfunc_called(this, "_ZN7S1508C43v13Ev");}
void  S1508C4 ::v14(){vfunc_called(this, "_ZN7S1508C43v14Ev");}
void  S1508C4 ::v15(){vfunc_called(this, "_ZN7S1508C43v15Ev");}
void  S1508C4 ::v16(){vfunc_called(this, "_ZN7S1508C43v16Ev");}
void  S1508C4 ::v17(){vfunc_called(this, "_ZN7S1508C43v17Ev");}
void  S1508C4 ::v18(){vfunc_called(this, "_ZN7S1508C43v18Ev");}
void  S1508C4 ::v19(){vfunc_called(this, "_ZN7S1508C43v19Ev");}
void  S1508C4 ::v20(){vfunc_called(this, "_ZN7S1508C43v20Ev");}
void  S1508C4 ::v21(){vfunc_called(this, "_ZN7S1508C43v21Ev");}
void  S1508C4 ::v22(){vfunc_called(this, "_ZN7S1508C43v22Ev");}
void  S1508C4 ::v23(){vfunc_called(this, "_ZN7S1508C43v23Ev");}
void  S1508C4 ::v24(){vfunc_called(this, "_ZN7S1508C43v24Ev");}
void  S1508C4 ::v25(){vfunc_called(this, "_ZN7S1508C43v25Ev");}
void  S1508C4 ::v26(){vfunc_called(this, "_ZN7S1508C43v26Ev");}
void  S1508C4 ::v27(){vfunc_called(this, "_ZN7S1508C43v27Ev");}
void  S1508C4 ::v28(){vfunc_called(this, "_ZN7S1508C43v28Ev");}
void  S1508C4 ::v29(){vfunc_called(this, "_ZN7S1508C43v29Ev");}
void  S1508C4 ::v30(){vfunc_called(this, "_ZN7S1508C43v30Ev");}
void  S1508C4 ::v31(){vfunc_called(this, "_ZN7S1508C43v31Ev");}
void  S1508C4 ::v32(){vfunc_called(this, "_ZN7S1508C43v32Ev");}
void  S1508C4 ::v33(){vfunc_called(this, "_ZN7S1508C43v33Ev");}
void  S1508C4 ::v34(){vfunc_called(this, "_ZN7S1508C43v34Ev");}
void  S1508C4 ::v35(){vfunc_called(this, "_ZN7S1508C43v35Ev");}
void  S1508C4 ::v36(){vfunc_called(this, "_ZN7S1508C43v36Ev");}
void  S1508C4 ::v37(){vfunc_called(this, "_ZN7S1508C43v37Ev");}
void  S1508C4 ::v38(){vfunc_called(this, "_ZN7S1508C43v38Ev");}
void  S1508C4 ::v39(){vfunc_called(this, "_ZN7S1508C43v39Ev");}
void  S1508C4 ::v40(){vfunc_called(this, "_ZN7S1508C43v40Ev");}
void  S1508C4 ::v41(){vfunc_called(this, "_ZN7S1508C43v41Ev");}
void  S1508C4 ::v42(){vfunc_called(this, "_ZN7S1508C43v42Ev");}
void  S1508C4 ::v43(){vfunc_called(this, "_ZN7S1508C43v43Ev");}
void  S1508C4 ::v44(){vfunc_called(this, "_ZN7S1508C43v44Ev");}
void  S1508C4 ::v45(){vfunc_called(this, "_ZN7S1508C43v45Ev");}
void  S1508C4 ::v46(){vfunc_called(this, "_ZN7S1508C43v46Ev");}
void  S1508C4 ::v47(){vfunc_called(this, "_ZN7S1508C43v47Ev");}
void  S1508C4 ::v48(){vfunc_called(this, "_ZN7S1508C43v48Ev");}
void  S1508C4 ::v49(){vfunc_called(this, "_ZN7S1508C43v49Ev");}
void  S1508C4 ::v50(){vfunc_called(this, "_ZN7S1508C43v50Ev");}
void  S1508C4 ::v51(){vfunc_called(this, "_ZN7S1508C43v51Ev");}
void  S1508C4 ::v52(){vfunc_called(this, "_ZN7S1508C43v52Ev");}
void  S1508C4 ::v53(){vfunc_called(this, "_ZN7S1508C43v53Ev");}
void  S1508C4 ::v54(){vfunc_called(this, "_ZN7S1508C43v54Ev");}
void  S1508C4 ::v55(){vfunc_called(this, "_ZN7S1508C43v55Ev");}
void  S1508C4 ::v56(){vfunc_called(this, "_ZN7S1508C43v56Ev");}
void  S1508C4 ::v57(){vfunc_called(this, "_ZN7S1508C43v57Ev");}
void  S1508C4 ::v58(){vfunc_called(this, "_ZN7S1508C43v58Ev");}
void  S1508C4 ::v59(){vfunc_called(this, "_ZN7S1508C43v59Ev");}
void  S1508C4 ::v60(){vfunc_called(this, "_ZN7S1508C43v60Ev");}
void  S1508C4 ::v61(){vfunc_called(this, "_ZN7S1508C43v61Ev");}
void  S1508C4 ::v62(){vfunc_called(this, "_ZN7S1508C43v62Ev");}
void  S1508C4 ::v63(){vfunc_called(this, "_ZN7S1508C43v63Ev");}
void  S1508C4 ::v64(){vfunc_called(this, "_ZN7S1508C43v64Ev");}
void  S1508C4 ::v65(){vfunc_called(this, "_ZN7S1508C43v65Ev");}
void  S1508C4 ::v66(){vfunc_called(this, "_ZN7S1508C43v66Ev");}
void  S1508C4 ::v67(){vfunc_called(this, "_ZN7S1508C43v67Ev");}
void  S1508C4 ::v68(){vfunc_called(this, "_ZN7S1508C43v68Ev");}
void  S1508C4 ::v69(){vfunc_called(this, "_ZN7S1508C43v69Ev");}
S1508C4 ::S1508C4(){ note_ctor("S1508C4", this);} // tgen

static void Test_S1508C4()
{
  extern Class_Descriptor cd_S1508C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1508C4, buf);
    S1508C4 *dp, &lv = *(dp=new (buf) S1508C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1508C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1508C4)");
    check_field_offset(lv, s1508c4f0, ABISELECT(8,4), "S1508C4.s1508c4f0");
    check_field_offset(lv, s1508c4f1, ABISELECT(16,8), "S1508C4.s1508c4f1");
    check_field_offset(lv, s1508c4f2, ABISELECT(24,16), "S1508C4.s1508c4f2");
    check_field_offset(lv, s1508c4f3, ABISELECT(56,32), "S1508C4.s1508c4f3");
    check_field_offset(lv, s1508c4f4, ABISELECT(64,40), "S1508C4.s1508c4f4");
    check_field_offset(lv, s1508c4f5, ABISELECT(72,44), "S1508C4.s1508c4f5");
    check_field_offset(lv, s1508c4f6, ABISELECT(80,52), "S1508C4.s1508c4f6");
    test_class_info(&lv, &cd_S1508C4);
    dp->~S1508C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1508C4(Test_S1508C4, "S1508C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1508C4C1Ev();
extern void _ZN7S1508C4D1Ev();
Name_Map name_map_S1508C4[] = {
  NSPAIR(_ZN7S1508C4C1Ev),
  NSPAIR(_ZN7S1508C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1508C4[];
extern void _ZN7S1508C4D1Ev();
extern void _ZN7S1508C4D0Ev();
extern void _ZN7S1508C42v6Ev();
extern void _ZN7S1508C42v7Ev();
extern void _ZN7S1508C42v8Ev();
extern void _ZN7S1508C42v9Ev();
extern void _ZN7S1508C43v10Ev();
extern void _ZN7S1508C43v11Ev();
extern void _ZN7S1508C43v12Ev();
extern void _ZN7S1508C43v13Ev();
extern void _ZN7S1508C43v14Ev();
extern void _ZN7S1508C43v15Ev();
extern void _ZN7S1508C43v16Ev();
extern void _ZN7S1508C43v17Ev();
extern void _ZN7S1508C43v18Ev();
extern void _ZN7S1508C43v19Ev();
extern void _ZN7S1508C43v20Ev();
extern void _ZN7S1508C43v21Ev();
extern void _ZN7S1508C43v22Ev();
extern void _ZN7S1508C43v23Ev();
extern void _ZN7S1508C43v24Ev();
extern void _ZN7S1508C43v25Ev();
extern void _ZN7S1508C43v26Ev();
extern void _ZN7S1508C43v27Ev();
extern void _ZN7S1508C43v28Ev();
extern void _ZN7S1508C43v29Ev();
extern void _ZN7S1508C43v30Ev();
extern void _ZN7S1508C43v31Ev();
extern void _ZN7S1508C43v32Ev();
extern void _ZN7S1508C43v33Ev();
extern void _ZN7S1508C43v34Ev();
extern void _ZN7S1508C43v35Ev();
extern void _ZN7S1508C43v36Ev();
extern void _ZN7S1508C43v37Ev();
extern void _ZN7S1508C43v38Ev();
extern void _ZN7S1508C43v39Ev();
extern void _ZN7S1508C43v40Ev();
extern void _ZN7S1508C43v41Ev();
extern void _ZN7S1508C43v42Ev();
extern void _ZN7S1508C43v43Ev();
extern void _ZN7S1508C43v44Ev();
extern void _ZN7S1508C43v45Ev();
extern void _ZN7S1508C43v46Ev();
extern void _ZN7S1508C43v47Ev();
extern void _ZN7S1508C43v48Ev();
extern void _ZN7S1508C43v49Ev();
extern void _ZN7S1508C43v50Ev();
extern void _ZN7S1508C43v51Ev();
extern void _ZN7S1508C43v52Ev();
extern void _ZN7S1508C43v53Ev();
extern void _ZN7S1508C43v54Ev();
extern void _ZN7S1508C43v55Ev();
extern void _ZN7S1508C43v56Ev();
extern void _ZN7S1508C43v57Ev();
extern void _ZN7S1508C43v58Ev();
extern void _ZN7S1508C43v59Ev();
extern void _ZN7S1508C43v60Ev();
extern void _ZN7S1508C43v61Ev();
extern void _ZN7S1508C43v62Ev();
extern void _ZN7S1508C43v63Ev();
extern void _ZN7S1508C43v64Ev();
extern void _ZN7S1508C43v65Ev();
extern void _ZN7S1508C43v66Ev();
extern void _ZN7S1508C43v67Ev();
extern void _ZN7S1508C43v68Ev();
extern void _ZN7S1508C43v69Ev();
static  VTBL_ENTRY vtc_S1508C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1508C4[0]),
  (VTBL_ENTRY)&_ZN7S1508C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1508C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v69Ev,
};
extern VTBL_ENTRY _ZTI7S1508C4[];
extern  VTBL_ENTRY _ZTV7S1508C4[];
Class_Descriptor cd_S1508C4 = {  "S1508C4", // class name
  0,0,//no base classes
  &(vtc_S1508C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1508C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1508C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1508C3  : S1508C4 {
  void *s1508c3f0;
  ::S28C31_nt s1508c3f1;
  int s1508c3f2;
  void *s1508c3f3;
  unsigned int s1508c3f4:1;
  ::S28C31_nt s1508c3f5;
  virtual  ~S1508C3(); // _ZN7S1508C3D1Ev
  virtual void  v70(); // _ZN7S1508C33v70Ev
  virtual void  v71(); // _ZN7S1508C33v71Ev
  virtual void  v72(); // _ZN7S1508C33v72Ev
  virtual void  v73(); // _ZN7S1508C33v73Ev
  virtual void  v74(); // _ZN7S1508C33v74Ev
  virtual void  v75(); // _ZN7S1508C33v75Ev
  virtual void  v76(); // _ZN7S1508C33v76Ev
  virtual void  v77(); // _ZN7S1508C33v77Ev
  S1508C3(); // tgen
};
//SIG(-1 S1508C3) C1{ BC2{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi Fp Fi:1 FC4}


 S1508C3 ::~S1508C3(){ note_dtor("S1508C3", this);}
void  S1508C3 ::v70(){vfunc_called(this, "_ZN7S1508C33v70Ev");}
void  S1508C3 ::v71(){vfunc_called(this, "_ZN7S1508C33v71Ev");}
void  S1508C3 ::v72(){vfunc_called(this, "_ZN7S1508C33v72Ev");}
void  S1508C3 ::v73(){vfunc_called(this, "_ZN7S1508C33v73Ev");}
void  S1508C3 ::v74(){vfunc_called(this, "_ZN7S1508C33v74Ev");}
void  S1508C3 ::v75(){vfunc_called(this, "_ZN7S1508C33v75Ev");}
void  S1508C3 ::v76(){vfunc_called(this, "_ZN7S1508C33v76Ev");}
void  S1508C3 ::v77(){vfunc_called(this, "_ZN7S1508C33v77Ev");}
S1508C3 ::S1508C3(){ note_ctor("S1508C3", this);} // tgen

static void Test_S1508C3()
{
  extern Class_Descriptor cd_S1508C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,26)];
    init_test(&cd_S1508C3, buf);
    S1508C3 *dp, &lv = *(dp=new (buf) S1508C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,100), "sizeof(S1508C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1508C3)");
    check_base_class_offset(lv, (S1508C4*), 0, "S1508C3");
    check_field_offset(lv, s1508c3f0, ABISELECT(96,60), "S1508C3.s1508c3f0");
    check_field_offset(lv, s1508c3f1, ABISELECT(104,64), "S1508C3.s1508c3f1");
    check_field_offset(lv, s1508c3f2, ABISELECT(120,76), "S1508C3.s1508c3f2");
    check_field_offset(lv, s1508c3f3, ABISELECT(128,80), "S1508C3.s1508c3f3");
    set_bf_and_test(lv, s1508c3f4, ABISELECT(136,84), 0, 1, 1, "S1508C3");
    check_field_offset(lv, s1508c3f5, ABISELECT(144,88), "S1508C3.s1508c3f5");
    test_class_info(&lv, &cd_S1508C3);
    dp->~S1508C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1508C3(Test_S1508C3, "S1508C3", ABISELECT(160,100));

#else // __cplusplus

extern void _ZN7S1508C3C1Ev();
extern void _ZN7S1508C3D1Ev();
Name_Map name_map_S1508C3[] = {
  NSPAIR(_ZN7S1508C3C1Ev),
  NSPAIR(_ZN7S1508C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1508C4;
extern VTBL_ENTRY _ZTI7S1508C4[];
extern  VTBL_ENTRY _ZTV7S1508C4[];
static Base_Class bases_S1508C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1508C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1508C3[];
extern void _ZN7S1508C3D1Ev();
extern void _ZN7S1508C3D0Ev();
extern void _ZN7S1508C42v6Ev();
extern void _ZN7S1508C42v7Ev();
extern void _ZN7S1508C42v8Ev();
extern void _ZN7S1508C42v9Ev();
extern void _ZN7S1508C43v10Ev();
extern void _ZN7S1508C43v11Ev();
extern void _ZN7S1508C43v12Ev();
extern void _ZN7S1508C43v13Ev();
extern void _ZN7S1508C43v14Ev();
extern void _ZN7S1508C43v15Ev();
extern void _ZN7S1508C43v16Ev();
extern void _ZN7S1508C43v17Ev();
extern void _ZN7S1508C43v18Ev();
extern void _ZN7S1508C43v19Ev();
extern void _ZN7S1508C43v20Ev();
extern void _ZN7S1508C43v21Ev();
extern void _ZN7S1508C43v22Ev();
extern void _ZN7S1508C43v23Ev();
extern void _ZN7S1508C43v24Ev();
extern void _ZN7S1508C43v25Ev();
extern void _ZN7S1508C43v26Ev();
extern void _ZN7S1508C43v27Ev();
extern void _ZN7S1508C43v28Ev();
extern void _ZN7S1508C43v29Ev();
extern void _ZN7S1508C43v30Ev();
extern void _ZN7S1508C43v31Ev();
extern void _ZN7S1508C43v32Ev();
extern void _ZN7S1508C43v33Ev();
extern void _ZN7S1508C43v34Ev();
extern void _ZN7S1508C43v35Ev();
extern void _ZN7S1508C43v36Ev();
extern void _ZN7S1508C43v37Ev();
extern void _ZN7S1508C43v38Ev();
extern void _ZN7S1508C43v39Ev();
extern void _ZN7S1508C43v40Ev();
extern void _ZN7S1508C43v41Ev();
extern void _ZN7S1508C43v42Ev();
extern void _ZN7S1508C43v43Ev();
extern void _ZN7S1508C43v44Ev();
extern void _ZN7S1508C43v45Ev();
extern void _ZN7S1508C43v46Ev();
extern void _ZN7S1508C43v47Ev();
extern void _ZN7S1508C43v48Ev();
extern void _ZN7S1508C43v49Ev();
extern void _ZN7S1508C43v50Ev();
extern void _ZN7S1508C43v51Ev();
extern void _ZN7S1508C43v52Ev();
extern void _ZN7S1508C43v53Ev();
extern void _ZN7S1508C43v54Ev();
extern void _ZN7S1508C43v55Ev();
extern void _ZN7S1508C43v56Ev();
extern void _ZN7S1508C43v57Ev();
extern void _ZN7S1508C43v58Ev();
extern void _ZN7S1508C43v59Ev();
extern void _ZN7S1508C43v60Ev();
extern void _ZN7S1508C43v61Ev();
extern void _ZN7S1508C43v62Ev();
extern void _ZN7S1508C43v63Ev();
extern void _ZN7S1508C43v64Ev();
extern void _ZN7S1508C43v65Ev();
extern void _ZN7S1508C43v66Ev();
extern void _ZN7S1508C43v67Ev();
extern void _ZN7S1508C43v68Ev();
extern void _ZN7S1508C43v69Ev();
extern void _ZN7S1508C33v70Ev();
extern void _ZN7S1508C33v71Ev();
extern void _ZN7S1508C33v72Ev();
extern void _ZN7S1508C33v73Ev();
extern void _ZN7S1508C33v74Ev();
extern void _ZN7S1508C33v75Ev();
extern void _ZN7S1508C33v76Ev();
extern void _ZN7S1508C33v77Ev();
static  VTBL_ENTRY vtc_S1508C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1508C3[0]),
  (VTBL_ENTRY)&_ZN7S1508C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1508C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v77Ev,
};
extern VTBL_ENTRY _ZTI7S1508C3[];
extern  VTBL_ENTRY _ZTV7S1508C3[];
Class_Descriptor cd_S1508C3 = {  "S1508C3", // class name
  bases_S1508C3, 1,
  &(vtc_S1508C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,100), // object size
  NSPAIRA(_ZTI7S1508C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1508C3),76, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1508C2  : S1508C3 {
  void *s1508c2f0;
  ::S48C18 s1508c2f1;
  unsigned int s1508c2f2:1;
  unsigned int s1508c2f3:1;
  unsigned int s1508c2f4:1;
  unsigned int s1508c2f5:1;
  char s1508c2f6;
  virtual  ~S1508C2(); // _ZN7S1508C2D1Ev
  virtual void  v78(); // _ZN7S1508C23v78Ev
  virtual void  v79(); // _ZN7S1508C23v79Ev
  virtual void  v80(); // _ZN7S1508C23v80Ev
  virtual void  v81(); // _ZN7S1508C23v81Ev
  virtual void  v82(); // _ZN7S1508C23v82Ev
  virtual void  v83(); // _ZN7S1508C23v83Ev
  virtual void  v84(); // _ZN7S1508C23v84Ev
  S1508C2(); // tgen
};
//SIG(-1 S1508C2) C1{ BC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 Fp FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} Fi Fp Fi:1 FC5} vd v1 v2 v3 v4 v5 v6 v7 Fp FC9{ m Fi[3]} Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S1508C2 ::~S1508C2(){ note_dtor("S1508C2", this);}
void  S1508C2 ::v78(){vfunc_called(this, "_ZN7S1508C23v78Ev");}
void  S1508C2 ::v79(){vfunc_called(this, "_ZN7S1508C23v79Ev");}
void  S1508C2 ::v80(){vfunc_called(this, "_ZN7S1508C23v80Ev");}
void  S1508C2 ::v81(){vfunc_called(this, "_ZN7S1508C23v81Ev");}
void  S1508C2 ::v82(){vfunc_called(this, "_ZN7S1508C23v82Ev");}
void  S1508C2 ::v83(){vfunc_called(this, "_ZN7S1508C23v83Ev");}
void  S1508C2 ::v84(){vfunc_called(this, "_ZN7S1508C23v84Ev");}
S1508C2 ::S1508C2(){ note_ctor("S1508C2", this);} // tgen

static void Test_S1508C2()
{
  extern Class_Descriptor cd_S1508C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S1508C2, buf);
    S1508C2 *dp, &lv = *(dp=new (buf) S1508C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S1508C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1508C2)");
    check_base_class_offset(lv, (S1508C4*)(S1508C3*), 0, "S1508C2");
    check_base_class_offset(lv, (S1508C3*), 0, "S1508C2");
    check_field_offset(lv, s1508c2f0, ABISELECT(160,100), "S1508C2.s1508c2f0");
    check_field_offset(lv, s1508c2f1, ABISELECT(168,104), "S1508C2.s1508c2f1");
    set_bf_and_test(lv, s1508c2f2, ABISELECT(180,116), 0, 1, 1, "S1508C2");
    set_bf_and_test(lv, s1508c2f3, ABISELECT(180,116), 1, 1, 1, "S1508C2");
    set_bf_and_test(lv, s1508c2f4, ABISELECT(180,116), 2, 1, 1, "S1508C2");
    set_bf_and_test(lv, s1508c2f5, ABISELECT(180,116), 3, 1, 1, "S1508C2");
    check_field_offset(lv, s1508c2f6, ABISELECT(181,117), "S1508C2.s1508c2f6");
    test_class_info(&lv, &cd_S1508C2);
    dp->~S1508C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1508C2(Test_S1508C2, "S1508C2", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN7S1508C2C1Ev();
extern void _ZN7S1508C2D1Ev();
Name_Map name_map_S1508C2[] = {
  NSPAIR(_ZN7S1508C2C1Ev),
  NSPAIR(_ZN7S1508C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1508C4;
extern VTBL_ENTRY _ZTI7S1508C4[];
extern  VTBL_ENTRY _ZTV7S1508C4[];
extern Class_Descriptor cd_S1508C3;
extern VTBL_ENTRY _ZTI7S1508C3[];
extern  VTBL_ENTRY _ZTV7S1508C3[];
static Base_Class bases_S1508C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1508C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1508C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1508C2[];
extern void _ZN7S1508C2D1Ev();
extern void _ZN7S1508C2D0Ev();
extern void _ZN7S1508C42v6Ev();
extern void _ZN7S1508C42v7Ev();
extern void _ZN7S1508C42v8Ev();
extern void _ZN7S1508C42v9Ev();
extern void _ZN7S1508C43v10Ev();
extern void _ZN7S1508C43v11Ev();
extern void _ZN7S1508C43v12Ev();
extern void _ZN7S1508C43v13Ev();
extern void _ZN7S1508C43v14Ev();
extern void _ZN7S1508C43v15Ev();
extern void _ZN7S1508C43v16Ev();
extern void _ZN7S1508C43v17Ev();
extern void _ZN7S1508C43v18Ev();
extern void _ZN7S1508C43v19Ev();
extern void _ZN7S1508C43v20Ev();
extern void _ZN7S1508C43v21Ev();
extern void _ZN7S1508C43v22Ev();
extern void _ZN7S1508C43v23Ev();
extern void _ZN7S1508C43v24Ev();
extern void _ZN7S1508C43v25Ev();
extern void _ZN7S1508C43v26Ev();
extern void _ZN7S1508C43v27Ev();
extern void _ZN7S1508C43v28Ev();
extern void _ZN7S1508C43v29Ev();
extern void _ZN7S1508C43v30Ev();
extern void _ZN7S1508C43v31Ev();
extern void _ZN7S1508C43v32Ev();
extern void _ZN7S1508C43v33Ev();
extern void _ZN7S1508C43v34Ev();
extern void _ZN7S1508C43v35Ev();
extern void _ZN7S1508C43v36Ev();
extern void _ZN7S1508C43v37Ev();
extern void _ZN7S1508C43v38Ev();
extern void _ZN7S1508C43v39Ev();
extern void _ZN7S1508C43v40Ev();
extern void _ZN7S1508C43v41Ev();
extern void _ZN7S1508C43v42Ev();
extern void _ZN7S1508C43v43Ev();
extern void _ZN7S1508C43v44Ev();
extern void _ZN7S1508C43v45Ev();
extern void _ZN7S1508C43v46Ev();
extern void _ZN7S1508C43v47Ev();
extern void _ZN7S1508C43v48Ev();
extern void _ZN7S1508C43v49Ev();
extern void _ZN7S1508C43v50Ev();
extern void _ZN7S1508C43v51Ev();
extern void _ZN7S1508C43v52Ev();
extern void _ZN7S1508C43v53Ev();
extern void _ZN7S1508C43v54Ev();
extern void _ZN7S1508C43v55Ev();
extern void _ZN7S1508C43v56Ev();
extern void _ZN7S1508C43v57Ev();
extern void _ZN7S1508C43v58Ev();
extern void _ZN7S1508C43v59Ev();
extern void _ZN7S1508C43v60Ev();
extern void _ZN7S1508C43v61Ev();
extern void _ZN7S1508C43v62Ev();
extern void _ZN7S1508C43v63Ev();
extern void _ZN7S1508C43v64Ev();
extern void _ZN7S1508C43v65Ev();
extern void _ZN7S1508C43v66Ev();
extern void _ZN7S1508C43v67Ev();
extern void _ZN7S1508C43v68Ev();
extern void _ZN7S1508C43v69Ev();
extern void _ZN7S1508C33v70Ev();
extern void _ZN7S1508C33v71Ev();
extern void _ZN7S1508C33v72Ev();
extern void _ZN7S1508C33v73Ev();
extern void _ZN7S1508C33v74Ev();
extern void _ZN7S1508C33v75Ev();
extern void _ZN7S1508C33v76Ev();
extern void _ZN7S1508C33v77Ev();
extern void _ZN7S1508C23v78Ev();
extern void _ZN7S1508C23v79Ev();
extern void _ZN7S1508C23v80Ev();
extern void _ZN7S1508C23v81Ev();
extern void _ZN7S1508C23v82Ev();
extern void _ZN7S1508C23v83Ev();
extern void _ZN7S1508C23v84Ev();
static  VTBL_ENTRY vtc_S1508C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1508C2[0]),
  (VTBL_ENTRY)&_ZN7S1508C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1508C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v78Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v79Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v84Ev,
};
extern VTBL_ENTRY _ZTI7S1508C2[];
extern  VTBL_ENTRY _ZTV7S1508C2[];
Class_Descriptor cd_S1508C2 = {  "S1508C2", // class name
  bases_S1508C2, 2,
  &(vtc_S1508C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,120), // object size
  NSPAIRA(_ZTI7S1508C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1508C2),83, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1508C1  : S1508C2 {
  unsigned int s1508c1f0:1;
  unsigned int s1508c1f1:1;
  unsigned int s1508c1f2:1;
  ::S48C18 s1508c1f3;
  void *s1508c1f4[2];
  char s1508c1f5;
  virtual  ~S1508C1(); // _ZN7S1508C1D1Ev
  virtual void  v1(); // _ZN7S1508C12v1Ev
  virtual void  v2(); // _ZN7S1508C12v2Ev
  virtual void  v3(); // _ZN7S1508C12v3Ev
  virtual void  v4(); // _ZN7S1508C12v4Ev
  virtual void  v5(); // _ZN7S1508C12v5Ev
  S1508C1(); // tgen
};
//SIG(1 S1508C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi Fp Fi:1 FC6} vd v78 v79 v80 v81 v82 v83 v84 Fp FC10{ m Fi[3]} Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 Fi:1 Fi:1 Fi:1 FC10 Fp[2] Fc}


 S1508C1 ::~S1508C1(){ note_dtor("S1508C1", this);}
void  S1508C1 ::v1(){vfunc_called(this, "_ZN7S1508C12v1Ev");}
void  S1508C1 ::v2(){vfunc_called(this, "_ZN7S1508C12v2Ev");}
void  S1508C1 ::v3(){vfunc_called(this, "_ZN7S1508C12v3Ev");}
void  S1508C1 ::v4(){vfunc_called(this, "_ZN7S1508C12v4Ev");}
void  S1508C1 ::v5(){vfunc_called(this, "_ZN7S1508C12v5Ev");}
S1508C1 ::S1508C1(){ note_ctor("S1508C1", this);} // tgen

static void Test_S1508C1()
{
  extern Class_Descriptor cd_S1508C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,37)];
    init_test(&cd_S1508C1, buf);
    S1508C1 *dp, &lv = *(dp=new (buf) S1508C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,144), "sizeof(S1508C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1508C1)");
    check_base_class_offset(lv, (S1508C4*)(S1508C3*)(S1508C2*), 0, "S1508C1");
    check_base_class_offset(lv, (S1508C3*)(S1508C2*), 0, "S1508C1");
    check_base_class_offset(lv, (S1508C2*), 0, "S1508C1");
    set_bf_and_test(lv, s1508c1f0, ABISELECT(182,118), 0, 1, 1, "S1508C1");
    set_bf_and_test(lv, s1508c1f1, ABISELECT(182,118), 1, 1, 1, "S1508C1");
    set_bf_and_test(lv, s1508c1f2, ABISELECT(182,118), 2, 1, 1, "S1508C1");
    check_field_offset(lv, s1508c1f3, ABISELECT(184,120), "S1508C1.s1508c1f3");
    check_field_offset(lv, s1508c1f4, ABISELECT(200,132), "S1508C1.s1508c1f4");
    check_field_offset(lv, s1508c1f5, ABISELECT(216,140), "S1508C1.s1508c1f5");
    test_class_info(&lv, &cd_S1508C1);
    dp->~S1508C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1508C1(Test_S1508C1, "S1508C1", ABISELECT(224,144));

#else // __cplusplus

extern void _ZN7S1508C1C1Ev();
extern void _ZN7S1508C1D1Ev();
Name_Map name_map_S1508C1[] = {
  NSPAIR(_ZN7S1508C1C1Ev),
  NSPAIR(_ZN7S1508C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1508C4;
extern VTBL_ENTRY _ZTI7S1508C4[];
extern  VTBL_ENTRY _ZTV7S1508C4[];
extern Class_Descriptor cd_S1508C3;
extern VTBL_ENTRY _ZTI7S1508C3[];
extern  VTBL_ENTRY _ZTV7S1508C3[];
extern Class_Descriptor cd_S1508C2;
extern VTBL_ENTRY _ZTI7S1508C2[];
extern  VTBL_ENTRY _ZTV7S1508C2[];
static Base_Class bases_S1508C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1508C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1508C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1508C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1508C1[];
extern void _ZN7S1508C1D1Ev();
extern void _ZN7S1508C1D0Ev();
extern void _ZN7S1508C42v6Ev();
extern void _ZN7S1508C42v7Ev();
extern void _ZN7S1508C42v8Ev();
extern void _ZN7S1508C42v9Ev();
extern void _ZN7S1508C43v10Ev();
extern void _ZN7S1508C43v11Ev();
extern void _ZN7S1508C43v12Ev();
extern void _ZN7S1508C43v13Ev();
extern void _ZN7S1508C43v14Ev();
extern void _ZN7S1508C43v15Ev();
extern void _ZN7S1508C43v16Ev();
extern void _ZN7S1508C43v17Ev();
extern void _ZN7S1508C43v18Ev();
extern void _ZN7S1508C43v19Ev();
extern void _ZN7S1508C43v20Ev();
extern void _ZN7S1508C43v21Ev();
extern void _ZN7S1508C43v22Ev();
extern void _ZN7S1508C43v23Ev();
extern void _ZN7S1508C43v24Ev();
extern void _ZN7S1508C43v25Ev();
extern void _ZN7S1508C43v26Ev();
extern void _ZN7S1508C43v27Ev();
extern void _ZN7S1508C43v28Ev();
extern void _ZN7S1508C43v29Ev();
extern void _ZN7S1508C43v30Ev();
extern void _ZN7S1508C43v31Ev();
extern void _ZN7S1508C43v32Ev();
extern void _ZN7S1508C43v33Ev();
extern void _ZN7S1508C43v34Ev();
extern void _ZN7S1508C43v35Ev();
extern void _ZN7S1508C43v36Ev();
extern void _ZN7S1508C43v37Ev();
extern void _ZN7S1508C43v38Ev();
extern void _ZN7S1508C43v39Ev();
extern void _ZN7S1508C43v40Ev();
extern void _ZN7S1508C43v41Ev();
extern void _ZN7S1508C43v42Ev();
extern void _ZN7S1508C43v43Ev();
extern void _ZN7S1508C43v44Ev();
extern void _ZN7S1508C43v45Ev();
extern void _ZN7S1508C43v46Ev();
extern void _ZN7S1508C43v47Ev();
extern void _ZN7S1508C43v48Ev();
extern void _ZN7S1508C43v49Ev();
extern void _ZN7S1508C43v50Ev();
extern void _ZN7S1508C43v51Ev();
extern void _ZN7S1508C43v52Ev();
extern void _ZN7S1508C43v53Ev();
extern void _ZN7S1508C43v54Ev();
extern void _ZN7S1508C43v55Ev();
extern void _ZN7S1508C43v56Ev();
extern void _ZN7S1508C43v57Ev();
extern void _ZN7S1508C43v58Ev();
extern void _ZN7S1508C43v59Ev();
extern void _ZN7S1508C43v60Ev();
extern void _ZN7S1508C43v61Ev();
extern void _ZN7S1508C43v62Ev();
extern void _ZN7S1508C43v63Ev();
extern void _ZN7S1508C43v64Ev();
extern void _ZN7S1508C43v65Ev();
extern void _ZN7S1508C43v66Ev();
extern void _ZN7S1508C43v67Ev();
extern void _ZN7S1508C43v68Ev();
extern void _ZN7S1508C43v69Ev();
extern void _ZN7S1508C33v70Ev();
extern void _ZN7S1508C33v71Ev();
extern void _ZN7S1508C33v72Ev();
extern void _ZN7S1508C33v73Ev();
extern void _ZN7S1508C33v74Ev();
extern void _ZN7S1508C33v75Ev();
extern void _ZN7S1508C33v76Ev();
extern void _ZN7S1508C33v77Ev();
extern void _ZN7S1508C23v78Ev();
extern void _ZN7S1508C23v79Ev();
extern void _ZN7S1508C23v80Ev();
extern void _ZN7S1508C23v81Ev();
extern void _ZN7S1508C23v82Ev();
extern void _ZN7S1508C23v83Ev();
extern void _ZN7S1508C23v84Ev();
extern void _ZN7S1508C12v1Ev();
extern void _ZN7S1508C12v2Ev();
extern void _ZN7S1508C12v3Ev();
extern void _ZN7S1508C12v4Ev();
extern void _ZN7S1508C12v5Ev();
static  VTBL_ENTRY vtc_S1508C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1508C1[0]),
  (VTBL_ENTRY)&_ZN7S1508C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1508C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1508C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1508C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1508C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v78Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v79Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1508C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1508C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1508C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1508C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1508C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1508C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S1508C1[];
extern  VTBL_ENTRY _ZTV7S1508C1[];
Class_Descriptor cd_S1508C1 = {  "S1508C1", // class name
  bases_S1508C1, 3,
  &(vtc_S1508C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,144), // object size
  NSPAIRA(_ZTI7S1508C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1508C1),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C5_nt  {
  __tsi64 s3461c5f0;
  void  mf3461c5(); // _ZN10S3461C5_nt8mf3461c5Ev
};
//SIG(-1 S3461C5_nt) C1{ m FL}


void  S3461C5_nt ::mf3461c5(){}

//skip512 S3461C5_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S3461C5_nt[];
VTBL_ENTRY *P__ZTI10S3461C5_nt = _ZTI10S3461C5_nt; 
Class_Descriptor cd_S3461C5_nt = {  "S3461C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI10S3461C5_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C9  : virtual S3461C5_nt , S731C17_nt {
  virtual void  v1(); // _ZN7S3461C92v1Ev
  ~S3461C9(); // tgen
  S3461C9(); // tgen
};
//SIG(-1 S3461C9) C1{ VBC2{ m FL} BC3{ m} v1}


void  S3461C9 ::v1(){vfunc_called(this, "_ZN7S3461C92v1Ev");}
S3461C9 ::~S3461C9(){ note_dtor("S3461C9", this);} // tgen
S3461C9 ::S3461C9(){ note_ctor("S3461C9", this);} // tgen

static void Test_S3461C9()
{
  extern Class_Descriptor cd_S3461C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3461C9, buf);
    S3461C9 *dp, &lv = *(dp=new (buf) S3461C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3461C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C9)");
    check_base_class_offset(lv, (S3461C5_nt*), ABISELECT(8,4), "S3461C9");
    check_base_class_offset(lv, (S731C17_nt*), 0, "S3461C9");
    test_class_info(&lv, &cd_S3461C9);
    dp->~S3461C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C9(Test_S3461C9, "S3461C9", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN7S3461C9C1Ev();
extern void _ZN7S3461C9D1Ev();
Name_Map name_map_S3461C9[] = {
  NSPAIR(_ZN7S3461C9C1Ev),
  NSPAIR(_ZN7S3461C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
static Base_Class bases_S3461C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3461C9[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY vtc_S3461C9[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern VTBL_ENTRY _ZTV7S3461C9[];
static  VTT_ENTRY vtt_S3461C9[] = {
  {&(_ZTV7S3461C9[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
Class_Descriptor cd_S3461C9 = {  "S3461C9", // class name
  bases_S3461C9, 2,
  &(vtc_S3461C9[0]), // expected_vtbl_contents
  &(vtt_S3461C9[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI7S3461C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3461C9),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3461C9),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C8  : S3461C9 {
  ~S3461C8(); // tgen
  S3461C8(); // tgen
};
//SIG(-1 S3461C8) C1{ BC2{ VBC3{ m FL} BC4{ m} v1}}


S3461C8 ::~S3461C8(){ note_dtor("S3461C8", this);} // tgen
S3461C8 ::S3461C8(){ note_ctor("S3461C8", this);} // tgen

static void Test_S3461C8()
{
  extern Class_Descriptor cd_S3461C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3461C8, buf);
    S3461C8 *dp, &lv = *(dp=new (buf) S3461C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3461C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C8)");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(8,4), "S3461C8");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), 0, "S3461C8");
    check_base_class_offset(lv, (S3461C9*), 0, "S3461C8");
    test_class_info(&lv, &cd_S3461C8);
    dp->~S3461C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C8(Test_S3461C8, "S3461C8", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN7S3461C8C1Ev();
extern void _ZN7S3461C8D1Ev();
Name_Map name_map_S3461C8[] = {
  NSPAIR(_ZN7S3461C8C1Ev),
  NSPAIR(_ZN7S3461C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
static Base_Class bases_S3461C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3461C8[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY vtc_S3461C8[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern VTBL_ENTRY _ZTV7S3461C8[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__7S3461C8[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C8[] = {
  {&(_ZTV7S3461C8[3]),  3,4},
  {&(_tg__ZTV7S3461C9__7S3461C8[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
Class_Descriptor cd_S3461C8 = {  "S3461C8", // class name
  bases_S3461C8, 3,
  &(vtc_S3461C8[0]), // expected_vtbl_contents
  &(vtt_S3461C8[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI7S3461C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3461C8),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3461C8),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C6  : S3461C5_nt , virtual S731C17_nt , S3461C8 {
  virtual  ~S3461C6(); // _ZN7S3461C6D2Ev
  virtual void  v2(); // _ZN7S3461C62v2Ev
  S3461C6(); // tgen
};
//SIG(-1 S3461C6) C1{ BC2{ m FL} VBC3{ m} BC4{ BC5{ VBC2 BC3 v2}} vd v1}


 S3461C6 ::~S3461C6(){ note_dtor("S3461C6", this);}
void  S3461C6 ::v2(){vfunc_called(this, "_ZN7S3461C62v2Ev");}
S3461C6 ::S3461C6(){ note_ctor("S3461C6", this);} // tgen

static void Test_S3461C6()
{
  extern Class_Descriptor cd_S3461C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_S3461C6, buf);
    S3461C6 *dp, &lv = *(dp=new (buf) S3461C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S3461C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C6)");
    /*is_ambiguous_... S3461C6::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*), ABISELECT(8,4), "S3461C6");
    /*is_ambiguous_... S3461C6::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*), ABISELECT(16,12), "S3461C6");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*), ABISELECT(16,12), "S3461C6");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*), 0, "S3461C6");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*), 0, "S3461C6");
    check_base_class_offset(lv, (S3461C8*), 0, "S3461C6");
    test_class_info(&lv, &cd_S3461C6);
    dp->~S3461C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C6(Test_S3461C6, "S3461C6", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN7S3461C6C1Ev();
extern void _ZN7S3461C6D2Ev();
Name_Map name_map_S3461C6[] = {
  NSPAIR(_ZN7S3461C6C1Ev),
  NSPAIR(_ZN7S3461C6D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
static Base_Class bases_S3461C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3461C5_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3461C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3461C6[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY vtc_S3461C6[] = {
  ABISELECT(16,12),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S3461C6[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__7S3461C6[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C8__7S3461C6[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C6[] = {
  {&(_ZTV7S3461C6[4]),  4,8},
  {&(_tg__ZTV7S3461C8__7S3461C6[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C8__7S3461C6[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
Class_Descriptor cd_S3461C6 = {  "S3461C6", // class name
  bases_S3461C6, 6,
  &(vtc_S3461C6[0]), // expected_vtbl_contents
  &(vtt_S3461C6[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI7S3461C6),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S3461C6),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3461C6),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C12  : virtual S3461C5_nt , S3461C9 , S731C17_nt {
  ~S3461C12(); // tgen
  S3461C12(); // tgen
};
//SIG(-1 S3461C12) C1{ VBC2{ m FL} BC3{ VBC2 BC4{ m} v1} BC4}


S3461C12 ::~S3461C12(){ note_dtor("S3461C12", this);} // tgen
S3461C12 ::S3461C12(){ note_ctor("S3461C12", this);} // tgen

static void Test_S3461C12()
{
  extern Class_Descriptor cd_S3461C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3461C12, buf);
    S3461C12 *dp, &lv = *(dp=new (buf) S3461C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3461C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C12)");
    check_base_class_offset(lv, (S3461C5_nt*), ABISELECT(8,4), "S3461C12");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(8,4), "S3461C12");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), 0, "S3461C12");
    check_base_class_offset(lv, (S3461C9*), 0, "S3461C12");
    /*is_ambiguous_... S3461C12::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*), ABISELECT(8,4), "S3461C12");
    test_class_info(&lv, &cd_S3461C12);
    dp->~S3461C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C12(Test_S3461C12, "S3461C12", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN8S3461C12C1Ev();
extern void _ZN8S3461C12D1Ev();
Name_Map name_map_S3461C12[] = {
  NSPAIR(_ZN8S3461C12C1Ev),
  NSPAIR(_ZN8S3461C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
static Base_Class bases_S3461C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C12[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY vtc_S3461C12[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern VTBL_ENTRY _ZTV8S3461C12[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C12[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C12[] = {
  {&(_ZTV8S3461C12[3]),  3,4},
  {&(_tg__ZTV7S3461C9__8S3461C12[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
Class_Descriptor cd_S3461C12 = {  "S3461C12", // class name
  bases_S3461C12, 4,
  &(vtc_S3461C12[0]), // expected_vtbl_contents
  &(vtt_S3461C12[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI8S3461C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3461C12),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C11  : virtual S3461C5_nt , S3461C12 , virtual S3461C9 {
  virtual void  v3(); // _ZN8S3461C112v3Ev
  ~S3461C11(); // tgen
  S3461C11(); // tgen
};
//SIG(-1 S3461C11) C1{ VBC2{ m FL} BC3{ VBC2 BC4{ VBC2 BC5{ m} v2} BC5} VBC4 v1}


void  S3461C11 ::v3(){vfunc_called(this, "_ZN8S3461C112v3Ev");}
S3461C11 ::~S3461C11(){ note_dtor("S3461C11", this);} // tgen
S3461C11 ::S3461C11(){ note_ctor("S3461C11", this);} // tgen

static void Test_S3461C11()
{
  extern Class_Descriptor cd_S3461C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S3461C11, buf);
    S3461C11 *dp, &lv = *(dp=new (buf) S3461C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S3461C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C11)");
    check_base_class_offset(lv, (S3461C5_nt*), ABISELECT(16,8), "S3461C11");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*), ABISELECT(16,8), "S3461C11");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*), ABISELECT(16,8), "S3461C11");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(16,8), "S3461C11");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*), 0, "S3461C11");
    check_base_class_offset(lv, (S3461C9*)(S3461C12*), 0, "S3461C11");
    /*is_ambiguous_... S3461C12::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*), ABISELECT(8,4), "S3461C11");
    check_base_class_offset(lv, (S3461C12*), 0, "S3461C11");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(24,16), "S3461C11");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*), ABISELECT(24,16), "S3461C11");
    test_class_info(&lv, &cd_S3461C11);
    dp->~S3461C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C11(Test_S3461C11, "S3461C11", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S3461C11C1Ev();
extern void _ZN8S3461C11D1Ev();
Name_Map name_map_S3461C11[] = {
  NSPAIR(_ZN8S3461C11C1Ev),
  NSPAIR(_ZN8S3461C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
static Base_Class bases_S3461C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3461C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C11[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY vtc_S3461C11[] = {
  ABISELECT(24,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  0,
  -8,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern VTBL_ENTRY _ZTV8S3461C11[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C12__8S3461C11[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C12__8S3461C11[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C11[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C11[] = {
  {&(_ZTV8S3461C11[4]),  4,11},
  {&(_tg__ZTV8S3461C12__8S3461C11[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C12__8S3461C11[3]),  3,4},
  {&(_ZTV8S3461C11[10]),  10,11},
  {&(_tg__ZTV7S3461C9__A1__8S3461C11[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3461C11[];
extern  VTBL_ENTRY _ZTV8S3461C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C11[];
Class_Descriptor cd_S3461C11 = {  "S3461C11", // class name
  bases_S3461C11, 7,
  &(vtc_S3461C11[0]), // expected_vtbl_contents
  &(vtt_S3461C11[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S3461C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3461C11),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C11),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C13  : S3461C5_nt , virtual S3461C9 , S731C17_nt {
  virtual  ~S3461C13(); // _ZN8S3461C13D2Ev
  S3461C13(); // tgen
};
//SIG(-1 S3461C13) C1{ BC2{ m FL} VBC3{ VBC2 BC4{ m} v1} BC4 vd}


 S3461C13 ::~S3461C13(){ note_dtor("S3461C13", this);}
S3461C13 ::S3461C13(){ note_ctor("S3461C13", this);} // tgen

static void Test_S3461C13()
{
  extern Class_Descriptor cd_S3461C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_S3461C13, buf);
    S3461C13 *dp, &lv = *(dp=new (buf) S3461C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S3461C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C13)");
    /*is_ambiguous_... S3461C13::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*), ABISELECT(8,4), "S3461C13");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(16,12), "S3461C13");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), 0, "S3461C13");
    check_base_class_offset(lv, (S3461C9*), 0, "S3461C13");
    /*is_ambiguous_... S3461C13::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*), ABISELECT(16,12), "S3461C13");
    test_class_info(&lv, &cd_S3461C13);
    dp->~S3461C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C13(Test_S3461C13, "S3461C13", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN8S3461C13C1Ev();
extern void _ZN8S3461C13D2Ev();
Name_Map name_map_S3461C13[] = {
  NSPAIR(_ZN8S3461C13C1Ev),
  NSPAIR(_ZN8S3461C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
static Base_Class bases_S3461C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3461C5_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S731C17_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C13[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY vtc_S3461C13[] = {
  0,
  0,
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
extern VTBL_ENTRY _ZTV8S3461C13[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C13[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C13[] = {
  {&(_ZTV8S3461C13[5]),  5,8},
  {&(_ZTV8S3461C13[5]),  5,8},
  {&(_tg__ZTV7S3461C9__8S3461C13[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
Class_Descriptor cd_S3461C13 = {  "S3461C13", // class name
  bases_S3461C13, 5,
  &(vtc_S3461C13[0]), // expected_vtbl_contents
  &(vtt_S3461C13[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI8S3461C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3461C13),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C13),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C4  : S3461C5_nt , S3461C6 , S28C52_nt , virtual S3461C11 , virtual S3461C13 {
  virtual  ~S3461C4(); // _ZN7S3461C4D2Ev
  S3461C4(); // tgen
};
//SIG(-1 S3461C4) C1{ BC2{ m FL} BC3{ BC2 VBC4{ m} BC5{ BC6{ VBC2 BC4 v1}} vd v2} BC7{ m} VBC8{ VBC2 BC9{ VBC2 BC6 BC4} VBC6 v3} VBC10{ BC2 VBC6 BC4 vd} vd}


 S3461C4 ::~S3461C4(){ note_dtor("S3461C4", this);}
S3461C4 ::S3461C4(){ note_ctor("S3461C4", this);} // tgen

static void Test_S3461C4()
{
  extern Class_Descriptor cd_S3461C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,14)];
    init_test(&cd_S3461C4, buf);
    S3461C4 *dp, &lv = *(dp=new (buf) S3461C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,52), "sizeof(S3461C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C4)");
    /*is_ambiguous_... S3461C4::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*), ABISELECT(16,12), "S3461C4");
    /*is_ambiguous_... S3461C6::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*), ABISELECT(8,4), "S3461C4");
    /*is_ambiguous_... S3461C6::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*), ABISELECT(24,20), "S3461C4");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*), ABISELECT(24,20), "S3461C4");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C11*), ABISELECT(24,20), "S3461C4");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C11*), ABISELECT(24,20), "S3461C4");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(24,20), "S3461C4");
    /*is_ambiguous_... S3461C4::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(24,20), "S3461C4");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*), 0, "S3461C4");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*), 0, "S3461C4");
    check_base_class_offset(lv, (S3461C8*)(S3461C6*), 0, "S3461C4");
    check_base_class_offset(lv, (S3461C6*), 0, "S3461C4");
    check_base_class_offset(lv, (S28C52_nt*), 0, "S3461C4");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(32,28), "S3461C4");
    check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(32,28), "S3461C4");
    /*is_ambiguous_... S3461C12::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C11*), ABISELECT(40,32), "S3461C4");
    check_base_class_offset(lv, (S3461C12*)(S3461C11*), ABISELECT(32,28), "S3461C4");
    /*is_ambiguous_... S3461C4::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(48,36), "S3461C4");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C11*), ABISELECT(48,36), "S3461C4");
    check_base_class_offset(lv, (S3461C9*)(S3461C13*), ABISELECT(48,36), "S3461C4");
    check_base_class_offset(lv, (S3461C11*), ABISELECT(32,28), "S3461C4");
    /*is_ambiguous_... S3461C13::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C13*), ABISELECT(56,40), "S3461C4");
    /*is_ambiguous_... S3461C13::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C13*), ABISELECT(64,48), "S3461C4");
    check_base_class_offset(lv, (S3461C13*), ABISELECT(48,36), "S3461C4");
    test_class_info(&lv, &cd_S3461C4);
    dp->~S3461C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C4(Test_S3461C4, "S3461C4", ABISELECT(72,52));

#else // __cplusplus

extern void _ZN7S3461C4C1Ev();
extern void _ZN7S3461C4D2Ev();
Name_Map name_map_S3461C4[] = {
  NSPAIR(_ZN7S3461C4C1Ev),
  NSPAIR(_ZN7S3461C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S28C52_nt;
extern VTBL_ENTRY _ZTI9S28C52_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C11;
extern VTBL_ENTRY _ZTI8S3461C11[];
extern  VTBL_ENTRY _ZTV8S3461C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C11[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C13;
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
static Base_Class bases_S3461C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S3461C5_nt,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3461C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3461C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S28C52_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3461C11,    ABISELECT(32,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3461C5_nt,    ABISELECT(56,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3461C13,    ABISELECT(48,36), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3461C4[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C4D1Ev();
extern void _ZN7S3461C4D0Ev();
extern void _ZN7S3461C62v2Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev)();
extern void ABISELECT(_ZThn48_N7S3461C4D1Ev,_ZThn36_N7S3461C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev)();
extern void ABISELECT(_ZThn48_N7S3461C4D0Ev,_ZThn36_N7S3461C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3461C4[] = {
  ABISELECT(48,36),
  ABISELECT(48,36),
  ABISELECT(32,28),
  ABISELECT(24,20),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C4D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C4D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  0,
  0,
  ABISELECT(16,8),
  -8,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  ABISELECT(-48,-36),
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev),
};
extern VTBL_ENTRY _ZTV7S3461C4[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C6__7S3461C4[] = {
  ABISELECT(24,20),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C6__7S3461C4[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C6__7S3461C4[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C11__7S3461C4[] = {
  ABISELECT(16,8),
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C11__7S3461C4[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C11__A1__7S3461C4[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C11__7S3461C4[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A2__7S3461C4[] = {
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C13__7S3461C4[] = {
  0,
  0,
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
static  VTT_ENTRY vtt_S3461C4[] = {
  {&(_ZTV7S3461C4[7]),  7,28},
  {&(_tg__ZTV7S3461C6__7S3461C4[4]),  4,8},
  {&(_tg__ZTV7S3461C87S3461C6__7S3461C4[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C87S3461C6__7S3461C4[3]),  3,4},
  {&(_ZTV7S3461C4[17]),  17,28},
  {&(_ZTV7S3461C4[25]),  25,28},
  {&(_ZTV7S3461C4[25]),  25,28},
  {&(_tg__ZTV8S3461C11__7S3461C4[4]),  4,6},
  {&(_tg__ZTV8S3461C128S3461C11__7S3461C4[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C128S3461C11__A1__7S3461C4[3]),  3,4},
  {&(_tg__ZTV7S3461C9__A1__8S3461C11__7S3461C4[4]),  4,5},
  {&(_tg__ZTV7S3461C9__A2__7S3461C4[3]),  3,4},
  {&(_tg__ZTV8S3461C13__7S3461C4[5]),  5,8},
  {&(_tg__ZTV8S3461C13__7S3461C4[5]),  5,8},
};
extern VTBL_ENTRY _ZTI7S3461C4[];
extern  VTBL_ENTRY _ZTV7S3461C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C4[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S3461C4D0Ev,_ZThn36_N7S3461C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S3461C4D1Ev,_ZThn36_N7S3461C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3461C4 = {  "S3461C4", // class name
  bases_S3461C4, 19,
  &(vtc_S3461C4[0]), // expected_vtbl_contents
  &(vtt_S3461C4[0]), // expected_vtt_contents
  ABISELECT(72,52), // object size
  NSPAIRA(_ZTI7S3461C4),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S3461C4),28, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3461C4),14, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C14  : virtual S3461C8 {
  int s3461c14f0;
  ~S3461C14(); // tgen
  S3461C14(); // tgen
};
//SIG(-1 S3461C14) C1{ VBC2{ BC3{ VBC4{ m FL} BC5{ m} v1}} Fi}


S3461C14 ::~S3461C14(){ note_dtor("S3461C14", this);} // tgen
S3461C14 ::S3461C14(){ note_ctor("S3461C14", this);} // tgen

static void Test_S3461C14()
{
  extern Class_Descriptor cd_S3461C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S3461C14, buf);
    S3461C14 *dp, &lv = *(dp=new (buf) S3461C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S3461C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C14)");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*), ABISELECT(16,8), "S3461C14");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*), 0, "S3461C14");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*), 0, "S3461C14");
    check_base_class_offset(lv, (S3461C8*), 0, "S3461C14");
    check_field_offset(lv, s3461c14f0, ABISELECT(8,4), "S3461C14.s3461c14f0");
    test_class_info(&lv, &cd_S3461C14);
    dp->~S3461C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C14(Test_S3461C14, "S3461C14", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S3461C14C1Ev();
extern void _ZN8S3461C14D1Ev();
Name_Map name_map_S3461C14[] = {
  NSPAIR(_ZN8S3461C14C1Ev),
  NSPAIR(_ZN8S3461C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
static Base_Class bases_S3461C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3461C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C14[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY vtc_S3461C14[] = {
  0,
  0,
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern VTBL_ENTRY _ZTV8S3461C14[];
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__8S3461C14[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C8__8S3461C14[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C14[] = {
  {&(_ZTV8S3461C14[5]),  5,6},
  {&(_ZTV8S3461C14[5]),  5,6},
  {&(_tg__ZTV7S3461C8__8S3461C14[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C8__8S3461C14[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3461C14[];
extern  VTBL_ENTRY _ZTV8S3461C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C14[];
Class_Descriptor cd_S3461C14 = {  "S3461C14", // class name
  bases_S3461C14, 4,
  &(vtc_S3461C14[0]), // expected_vtbl_contents
  &(vtt_S3461C14[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S3461C14),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S3461C14),6, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C14),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C3  : virtual S3461C4 , S3461C6 , S3461C14 {
  long double s3461c3f0;
  virtual  ~S3461C3(); // _ZN7S3461C3D2Ev
  S3461C3(); // tgen
};
//SIG(-1 S3461C3) C1{ VBC2{ BC3{ m FL} BC4{ BC3 VBC5{ m} BC6{ BC7{ VBC3 BC5 v1}} vd v2} BC8{ m} VBC9{ VBC3 BC10{ VBC3 BC7 BC5} VBC7 v3} VBC11{ BC3 VBC7 BC5 vd} vd} BC4 BC12{ VBC6 Fi} vd FD}


 S3461C3 ::~S3461C3(){ note_dtor("S3461C3", this);}
S3461C3 ::S3461C3(){ note_ctor("S3461C3", this);} // tgen

static void Test_S3461C3()
{
  extern Class_Descriptor cd_S3461C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,22)];
    init_test(&cd_S3461C3, buf);
    S3461C3 *dp, &lv = *(dp=new (buf) S3461C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,84), "sizeof(S3461C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3461C3)");
    /*is_ambiguous_... S3461C4::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C4*), ABISELECT(64,44), "S3461C3");
    /*is_ambiguous_... S3461C6::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*)(S3461C4*), ABISELECT(56,36), "S3461C3");
    /*is_ambiguous_... S3461C6::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*)(S3461C4*), ABISELECT(72,52), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*), ABISELECT(72,52), "S3461C3");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(72,52), "S3461C3");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C11*), ABISELECT(72,52), "S3461C3");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C11*), ABISELECT(72,52), "S3461C3");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(72,52), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(72,52), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*), ABISELECT(72,52), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C8 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*), ABISELECT(72,52), "S3461C3");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(48,32), "S3461C3");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(48,32), "S3461C3");
    check_base_class_offset(lv, (S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(48,32), "S3461C3");
    check_base_class_offset(lv, (S3461C6*)(S3461C4*), ABISELECT(48,32), "S3461C3");
    check_base_class_offset(lv, (S28C52_nt*)(S3461C4*), ABISELECT(48,32), "S3461C3");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(80,60), "S3461C3");
    check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(80,60), "S3461C3");
    /*is_ambiguous_... S3461C12::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C11*), ABISELECT(88,64), "S3461C3");
    check_base_class_offset(lv, (S3461C12*)(S3461C11*), ABISELECT(80,60), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(96,68), "S3461C3");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C11*), ABISELECT(96,68), "S3461C3");
    check_base_class_offset(lv, (S3461C9*)(S3461C13*), ABISELECT(96,68), "S3461C3");
    check_base_class_offset(lv, (S3461C11*)(S3461C4*), ABISELECT(80,60), "S3461C3");
    /*is_ambiguous_... S3461C13::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C13*), ABISELECT(104,72), "S3461C3");
    /*is_ambiguous_... S3461C13::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C13*), ABISELECT(112,80), "S3461C3");
    check_base_class_offset(lv, (S3461C13*)(S3461C4*), ABISELECT(96,68), "S3461C3");
    check_base_class_offset(lv, (S3461C4*), ABISELECT(48,32), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*), ABISELECT(8,4), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*), 0, "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*), 0, "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C8*)(S3461C6*), 0, "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C6*), 0, "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C8 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*), ABISELECT(16,12), "S3461C3");
    /*is_ambiguous_... S3461C3::S3461C8 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C8*), ABISELECT(16,12), "S3461C3");
    check_base_class_offset(lv, (S3461C8*)(S3461C14*), ABISELECT(16,12), "S3461C3");
    check_base_class_offset(lv, (S3461C14*), ABISELECT(16,12), "S3461C3");
    check_field_offset(lv, s3461c3f0, ABISELECT(32,20), "S3461C3.s3461c3f0");
    test_class_info(&lv, &cd_S3461C3);
    dp->~S3461C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C3(Test_S3461C3, "S3461C3", ABISELECT(128,84));

#else // __cplusplus

extern void _ZN7S3461C3C1Ev();
extern void _ZN7S3461C3D2Ev();
Name_Map name_map_S3461C3[] = {
  NSPAIR(_ZN7S3461C3C1Ev),
  NSPAIR(_ZN7S3461C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S28C52_nt;
extern VTBL_ENTRY _ZTI9S28C52_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C11;
extern VTBL_ENTRY _ZTI8S3461C11[];
extern  VTBL_ENTRY _ZTV8S3461C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C11[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C13;
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
extern Class_Descriptor cd_S3461C4;
extern VTBL_ENTRY _ZTI7S3461C4[];
extern  VTBL_ENTRY _ZTV7S3461C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C4[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C14;
extern VTBL_ENTRY _ZTI8S3461C14[];
extern  VTBL_ENTRY _ZTV8S3461C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C14[];
static Base_Class bases_S3461C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S3461C5_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(72,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S3461C5_nt,    ABISELECT(72,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3461C6,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S28C52_nt,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(80,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(80,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(88,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(80,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(96,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(96,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3461C11,    ABISELECT(80,60), //bcp->offset
    33, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S3461C5_nt,    ABISELECT(104,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(112,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3461C13,    ABISELECT(96,68), //bcp->offset
    41, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S3461C4,    ABISELECT(48,32), //bcp->offset
    19, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S3461C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3461C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S3461C14,    ABISELECT(16,12), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3461C3[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C3D1Ev();
extern void _ZN7S3461C3D0Ev();
extern void _ZN7S3461C62v2Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n72_N7S3461C3D1Ev,_ZTv0_n36_N7S3461C3D1Ev)();
extern void ABISELECT(_ZThn48_N7S3461C3D1Ev,_ZThn32_N7S3461C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S3461C3D0Ev,_ZTv0_n36_N7S3461C3D0Ev)();
extern void ABISELECT(_ZThn48_N7S3461C3D0Ev,_ZThn32_N7S3461C3D0Ev)() __attribute__((weak));
extern void _ZN7S3461C62v2Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N7S3461C3D1Ev,_ZTv0_n24_N7S3461C3D1Ev)();
extern void ABISELECT(_ZThn96_N7S3461C3D1Ev,_ZThn68_N7S3461C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S3461C3D0Ev,_ZTv0_n24_N7S3461C3D0Ev)();
extern void ABISELECT(_ZThn96_N7S3461C3D0Ev,_ZThn68_N7S3461C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3461C3[] = {
  ABISELECT(16,12),
  ABISELECT(96,68),
  ABISELECT(96,68),
  ABISELECT(80,60),
  ABISELECT(48,32),
  ABISELECT(72,52),
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  0,
  0,
  ABISELECT(56,40),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  0,
  ABISELECT(-48,-32),
  0,
  ABISELECT(48,36),
  ABISELECT(48,36),
  ABISELECT(32,28),
  ABISELECT(24,20),
  ABISELECT(24,20),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3461C3D1Ev,_ZTv0_n36_N7S3461C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3461C3D0Ev,_ZTv0_n36_N7S3461C3D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  0,
  0,
  ABISELECT(16,8),
  -8,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  ABISELECT(-96,-68),
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-96,-68),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C3D1Ev,_ZTv0_n24_N7S3461C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C3D0Ev,_ZTv0_n24_N7S3461C3D0Ev),
};
extern VTBL_ENTRY _ZTV7S3461C3[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C6__A1__7S3461C3[] = {
  ABISELECT(72,52),
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C6__A1__7S3461C3[] = {
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C6__A3__7S3461C3[] = {
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C14__7S3461C3[] = {
  0,
  0,
  ABISELECT(56,40),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C4D1Ev();
extern void _ZN7S3461C4D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C4__7S3461C3[] = {
  ABISELECT(48,36),
  ABISELECT(48,36),
  ABISELECT(32,28),
  ABISELECT(24,20),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C4D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C4D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C67S3461C4__7S3461C3[] = {
  ABISELECT(24,20),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C67S3461C4__7S3461C3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C67S3461C4__7S3461C3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C11__7S3461C4__7S3461C3[] = {
  0,
  0,
  ABISELECT(16,8),
  -8,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev)();
extern void ABISELECT(_ZThn48_N7S3461C4D1Ev,_ZThn36_N7S3461C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev)();
extern void ABISELECT(_ZThn48_N7S3461C4D0Ev,_ZThn36_N7S3461C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3461C13__7S3461C4__7S3461C3[] = {
  ABISELECT(-48,-36),
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev),
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C11__7S3461C3[] = {
  ABISELECT(16,8),
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C11__7S3461C3[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C11__A1__7S3461C3[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C11__7S3461C3[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A2__7S3461C3[] = {
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C13__7S3461C3[] = {
  0,
  0,
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__A2__7S3461C3[] = {
  ABISELECT(56,40),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C8__A4__7S3461C3[] = {
  ABISELECT(56,40),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C3[] = {
  {&(_ZTV7S3461C3[9]),  9,50},
  {&(_tg__ZTV7S3461C6__A1__7S3461C3[4]),  4,8},
  {&(_tg__ZTV7S3461C87S3461C6__A1__7S3461C3[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C87S3461C6__A3__7S3461C3[3]),  3,4},
  {&(_tg__ZTV8S3461C14__7S3461C3[5]),  5,6},
  {&(_tg__ZTV8S3461C14__7S3461C3[5]),  5,6},
  {&(_ZTV7S3461C3[29]),  29,50},
  {&(_ZTV7S3461C3[39]),  39,50},
  {&(_ZTV7S3461C3[47]),  47,50},
  {&(_ZTV7S3461C3[47]),  47,50},
  {&(_ZTV7S3461C3[18]),  18,50},
  {&(_ZTV7S3461C3[18]),  18,50},
  {&(_tg__ZTV7S3461C4__7S3461C3[7]),  7,11},
  {&(_tg__ZTV7S3461C67S3461C4__7S3461C3[4]),  4,8},
  {&(_tg__ZTV7S3461C87S3461C67S3461C4__7S3461C3[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C87S3461C67S3461C4__7S3461C3[3]),  3,4},
  {&(_tg__ZTV8S3461C11__7S3461C4__7S3461C3[6]),  6,8},
  {&(_tg__ZTV8S3461C13__7S3461C4__7S3461C3[6]),  6,9},
  {&(_tg__ZTV8S3461C13__7S3461C4__7S3461C3[6]),  6,9},
  {&(_tg__ZTV8S3461C11__7S3461C3[4]),  4,6},
  {&(_tg__ZTV8S3461C128S3461C11__7S3461C3[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C128S3461C11__A1__7S3461C3[3]),  3,4},
  {&(_tg__ZTV7S3461C9__A1__8S3461C11__7S3461C3[4]),  4,5},
  {&(_tg__ZTV7S3461C9__A2__7S3461C3[3]),  3,4},
  {&(_tg__ZTV8S3461C13__7S3461C3[5]),  5,8},
  {&(_tg__ZTV8S3461C13__7S3461C3[5]),  5,8},
  {&(_tg__ZTV7S3461C8__A2__7S3461C3[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C8__A4__7S3461C3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S3461C3[];
extern  VTBL_ENTRY _ZTV7S3461C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C3[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S3461C4D0Ev,_ZThn36_N7S3461C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S3461C4D1Ev,_ZThn36_N7S3461C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S3461C3D0Ev,_ZTv0_n24_N7S3461C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N7S3461C3D0Ev,_ZThn68_N7S3461C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S3461C3D1Ev,_ZTv0_n24_N7S3461C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N7S3461C3D1Ev,_ZThn68_N7S3461C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S3461C3D0Ev,_ZTv0_n36_N7S3461C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S3461C3D0Ev,_ZThn32_N7S3461C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S3461C3D1Ev,_ZTv0_n36_N7S3461C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S3461C3D1Ev,_ZThn32_N7S3461C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3461C3 = {  "S3461C3", // class name
  bases_S3461C3, 29,
  &(vtc_S3461C3[0]), // expected_vtbl_contents
  &(vtt_S3461C3[0]), // expected_vtt_contents
  ABISELECT(128,84), // object size
  NSPAIRA(_ZTI7S3461C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S3461C3),50, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3461C3),28, //virtual table table var
  15, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C17  : S3461C13 {
  virtual void  v4(); // _ZN8S3461C172v4Ev
  ~S3461C17(); // tgen
  S3461C17(); // tgen
};
//SIG(-1 S3461C17) C1{ BC2{ BC3{ m FL} VBC4{ VBC3 BC5{ m} v2} BC5 vd} v1}


void  S3461C17 ::v4(){vfunc_called(this, "_ZN8S3461C172v4Ev");}
S3461C17 ::~S3461C17(){ note_dtor("S3461C17", this);} // tgen
S3461C17 ::S3461C17(){ note_ctor("S3461C17", this);} // tgen

static void Test_S3461C17()
{
  extern Class_Descriptor cd_S3461C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S3461C17, buf);
    S3461C17 *dp, &lv = *(dp=new (buf) S3461C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S3461C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C17)");
    /*is_ambiguous_... S3461C13::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C13*), ABISELECT(8,4), "S3461C17");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(24,16), "S3461C17");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), 0, "S3461C17");
    check_base_class_offset(lv, (S3461C9*)(S3461C13*), 0, "S3461C17");
    /*is_ambiguous_... S3461C13::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C13*), ABISELECT(16,12), "S3461C17");
    check_base_class_offset(lv, (S3461C13*), 0, "S3461C17");
    test_class_info(&lv, &cd_S3461C17);
    dp->~S3461C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C17(Test_S3461C17, "S3461C17", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN8S3461C17C1Ev();
extern void _ZN8S3461C17D1Ev();
Name_Map name_map_S3461C17[] = {
  NSPAIR(_ZN8S3461C17C1Ev),
  NSPAIR(_ZN8S3461C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C13;
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
static Base_Class bases_S3461C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3461C5_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3461C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C17[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C17D1Ev();
extern void _ZN8S3461C17D0Ev();
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY vtc_S3461C17[] = {
  0,
  0,
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C17[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D0Ev,
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern VTBL_ENTRY _ZTV8S3461C17[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C13__8S3461C17[] = {
  0,
  0,
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C17[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C17[] = {
  {&(_ZTV8S3461C17[5]),  5,9},
  {&(_tg__ZTV8S3461C13__8S3461C17[5]),  5,8},
  {&(_tg__ZTV8S3461C13__8S3461C17[5]),  5,8},
  {&(_ZTV8S3461C17[5]),  5,9},
  {&(_tg__ZTV7S3461C9__8S3461C17[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3461C17[];
extern  VTBL_ENTRY _ZTV8S3461C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C17[];
Class_Descriptor cd_S3461C17 = {  "S3461C17", // class name
  bases_S3461C17, 6,
  &(vtc_S3461C17[0]), // expected_vtbl_contents
  &(vtt_S3461C17[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI8S3461C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3461C17),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C17),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C16  : S3461C11 , S3461C9 , virtual S3461C17 , S3461C12 {
  ~S3461C16(); // tgen
  S3461C16(); // tgen
};
//SIG(-1 S3461C16) C1{ BC2{ VBC3{ m FL} BC4{ VBC3 BC5{ VBC3 BC6{ m} v1} BC6} VBC5 v2} BC5 VBC7{ BC8{ BC3 VBC5 BC6 vd} v3} BC4}


S3461C16 ::~S3461C16(){ note_dtor("S3461C16", this);} // tgen
S3461C16 ::S3461C16(){ note_ctor("S3461C16", this);} // tgen

static void Test_S3461C16()
{
  extern Class_Descriptor cd_S3461C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_S3461C16, buf);
    S3461C16 *dp, &lv = *(dp=new (buf) S3461C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(S3461C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C16)");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C11*), ABISELECT(40,20), "S3461C16");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C11*), ABISELECT(40,20), "S3461C16");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(40,20), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(40,20), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(40,20), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*), ABISELECT(40,20), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*), ABISELECT(40,20), "S3461C16");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C11*), 0, "S3461C16");
    check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C11*), 0, "S3461C16");
    /*is_ambiguous_... S3461C12::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C11*), ABISELECT(8,4), "S3461C16");
    check_base_class_offset(lv, (S3461C12*)(S3461C11*), 0, "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(48,28), "S3461C16");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C11*), ABISELECT(48,28), "S3461C16");
    check_base_class_offset(lv, (S3461C9*)(S3461C13*)(S3461C17*), ABISELECT(48,28), "S3461C16");
    check_base_class_offset(lv, (S3461C11*), 0, "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(16,8), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*), ABISELECT(16,8), "S3461C16");
    /*is_ambiguous_... S3461C13::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C13*)(S3461C17*), ABISELECT(56,32), "S3461C16");
    /*is_ambiguous_... S3461C13::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C13*)(S3461C17*), ABISELECT(64,40), "S3461C16");
    check_base_class_offset(lv, (S3461C13*)(S3461C17*), ABISELECT(48,28), "S3461C16");
    check_base_class_offset(lv, (S3461C17*), ABISELECT(48,28), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*), ABISELECT(24,12), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C12*), ABISELECT(24,12), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*), ABISELECT(32,16), "S3461C16");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C12*), ABISELECT(24,12), "S3461C16");
    test_class_info(&lv, &cd_S3461C16);
    dp->~S3461C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C16(Test_S3461C16, "S3461C16", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8S3461C16C1Ev();
extern void _ZN8S3461C16D1Ev();
Name_Map name_map_S3461C16[] = {
  NSPAIR(_ZN8S3461C16C1Ev),
  NSPAIR(_ZN8S3461C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C11;
extern VTBL_ENTRY _ZTI8S3461C11[];
extern  VTBL_ENTRY _ZTV8S3461C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C11[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C13;
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
extern Class_Descriptor cd_S3461C17;
extern VTBL_ENTRY _ZTI8S3461C17[];
extern  VTBL_ENTRY _ZTV8S3461C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C17[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
static Base_Class bases_S3461C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3461C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S3461C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(16,8), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3461C5_nt,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3461C13,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3461C17,    ABISELECT(48,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S731C17_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(24,12), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C16[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN8S3461C16D1Ev();
extern void _ZN8S3461C16D0Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev)();
extern void ABISELECT(_ZThn48_N8S3461C16D1Ev,_ZThn28_N8S3461C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev)();
extern void ABISELECT(_ZThn48_N8S3461C16D0Ev,_ZThn28_N8S3461C16D0Ev)() __attribute__((weak));
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY vtc_S3461C16[] = {
  ABISELECT(48,28),
  ABISELECT(48,28),
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  (VTBL_ENTRY)&_ZN8S3461C16D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C16D0Ev,
  ABISELECT(24,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(16,8),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  0,
  ABISELECT(-48,-28),
  0,
  0,
  -8,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev),
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern VTBL_ENTRY _ZTV8S3461C16[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C11__8S3461C16[] = {
  ABISELECT(48,28),
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C11__8S3461C16[] = {
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C11__8S3461C16[] = {
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C11__8S3461C16[] = {
  0,
  -8,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A__8S3461C16[] = {
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C12__A1__8S3461C16[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C12__A3__8S3461C16[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C16[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C17D1Ev();
extern void _ZN8S3461C17D0Ev();
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C17__8S3461C16[] = {
  0,
  0,
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C17[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D0Ev,
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C138S3461C17__8S3461C16[] = {
  0,
  0,
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
static  VTT_ENTRY vtt_S3461C16[] = {
  {&(_ZTV8S3461C16[5]),  5,28},
  {&(_tg__ZTV8S3461C11__8S3461C16[4]),  4,6},
  {&(_tg__ZTV8S3461C128S3461C11__8S3461C16[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C128S3461C11__8S3461C16[3]),  3,4},
  {&(_tg__ZTV7S3461C9__A1__8S3461C11__8S3461C16[4]),  4,5},
  {&(_tg__ZTV7S3461C9__A__8S3461C16[3]),  3,4},
  {&(_tg__ZTV8S3461C12__A1__8S3461C16[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C12__A3__8S3461C16[3]),  3,4},
  {&(_ZTV8S3461C16[24]),  24,28},
  {&(_ZTV8S3461C16[12]),  12,28},
  {&(_ZTV8S3461C16[24]),  24,28},
  {&(_ZTV8S3461C16[16]),  16,28},
  {&(_tg__ZTV7S3461C9__A1__8S3461C16[3]),  3,4},
  {&(_tg__ZTV8S3461C17__8S3461C16[5]),  5,9},
  {&(_tg__ZTV8S3461C138S3461C17__8S3461C16[5]),  5,8},
  {&(_tg__ZTV8S3461C138S3461C17__8S3461C16[5]),  5,8},
  {&(_tg__ZTV8S3461C17__8S3461C16[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S3461C16[];
extern  VTBL_ENTRY _ZTV8S3461C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C16[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S3461C16D0Ev,_ZThn28_N8S3461C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S3461C16D1Ev,_ZThn28_N8S3461C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3461C16 = {  "S3461C16", // class name
  bases_S3461C16, 18,
  &(vtc_S3461C16[0]), // expected_vtbl_contents
  &(vtt_S3461C16[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8S3461C16),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S3461C16),28, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C16),17, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C18  : virtual S3461C9 , S3461C6 {
  virtual  ~S3461C18(); // _ZN8S3461C18D2Ev
  virtual void  v5(); // _ZN8S3461C182v5Ev
  S3461C18(); // tgen
};
//SIG(-1 S3461C18) C1{ VBC2{ VBC3{ m FL} BC4{ m} v2} BC5{ BC3 VBC4 BC6{ BC2} vd v3} vd v1}


 S3461C18 ::~S3461C18(){ note_dtor("S3461C18", this);}
void  S3461C18 ::v5(){vfunc_called(this, "_ZN8S3461C182v5Ev");}
S3461C18 ::S3461C18(){ note_ctor("S3461C18", this);} // tgen

static void Test_S3461C18()
{
  extern Class_Descriptor cd_S3461C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S3461C18, buf);
    S3461C18 *dp, &lv = *(dp=new (buf) S3461C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S3461C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C18)");
    /*is_ambiguous_... S3461C18::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(24,16), "S3461C18");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*), ABISELECT(24,16), "S3461C18");
    /*is_ambiguous_... S3461C18::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(16,12), "S3461C18");
    /*is_ambiguous_... S3461C18::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*), ABISELECT(16,12), "S3461C18");
    /*is_ambiguous_... S3461C6::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*), ABISELECT(8,4), "S3461C18");
    /*is_ambiguous_... S3461C6::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*), ABISELECT(32,24), "S3461C18");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*), 0, "S3461C18");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*), 0, "S3461C18");
    check_base_class_offset(lv, (S3461C8*)(S3461C6*), 0, "S3461C18");
    check_base_class_offset(lv, (S3461C6*), 0, "S3461C18");
    test_class_info(&lv, &cd_S3461C18);
    dp->~S3461C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C18(Test_S3461C18, "S3461C18", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN8S3461C18C1Ev();
extern void _ZN8S3461C18D2Ev();
Name_Map name_map_S3461C18[] = {
  NSPAIR(_ZN8S3461C18C1Ev),
  NSPAIR(_ZN8S3461C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
static Base_Class bases_S3461C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(16,12), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3461C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3461C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C18[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C18D1Ev();
extern void _ZN8S3461C18D0Ev();
extern void _ZN7S3461C62v2Ev();
extern void _ZN8S3461C182v5Ev();
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY vtc_S3461C18[] = {
  ABISELECT(16,12),
  ABISELECT(32,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C18[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C18D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C18D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3461C182v5Ev,
  0,
  ABISELECT(8,4),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S3461C18[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern VTBL_ENTRY _ZTV8S3461C18[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C6__8S3461C18[] = {
  ABISELECT(32,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C6__8S3461C18[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C6__A1__8S3461C18[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C18[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C18[] = {
  {&(_ZTV8S3461C18[5]),  5,15},
  {&(_tg__ZTV7S3461C6__8S3461C18[4]),  4,8},
  {&(_tg__ZTV7S3461C87S3461C6__8S3461C18[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C87S3461C6__A1__8S3461C18[3]),  3,4},
  {&(_ZTV8S3461C18[14]),  14,15},
  {&(_tg__ZTV7S3461C9__8S3461C18[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3461C18[];
extern  VTBL_ENTRY _ZTV8S3461C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C18[];
Class_Descriptor cd_S3461C18 = {  "S3461C18", // class name
  bases_S3461C18, 9,
  &(vtc_S3461C18[0]), // expected_vtbl_contents
  &(vtt_S3461C18[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI8S3461C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S3461C18),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C18),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C15  : S3461C16 , S3461C14 , S3461C18 , S3461C6 {
  void *s3461c15f0;
  virtual  ~S3461C15(); // _ZN8S3461C15D2Ev
  S3461C15(); // tgen
};
//SIG(-1 S3461C15) C1{ BC2{ BC3{ VBC4{ m FL} BC5{ VBC4 BC6{ VBC4 BC7{ m} v1} BC7} VBC6 v2} BC6 VBC8{ BC9{ BC4 VBC6 BC7 vd} v3} BC5} BC10{ VBC11{ BC6} Fi} BC12{ VBC6 BC13{ BC4 VBC7 BC11 vd v4} vd v5} BC13 vd Fp}


 S3461C15 ::~S3461C15(){ note_dtor("S3461C15", this);}
S3461C15 ::S3461C15(){ note_ctor("S3461C15", this);} // tgen

static void Test_S3461C15()
{
  extern Class_Descriptor cd_S3461C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,21)];
    init_test(&cd_S3461C15, buf);
    S3461C15 *dp, &lv = *(dp=new (buf) S3461C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,80), "sizeof(S3461C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3461C15)");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C11*)(S3461C16*), ABISELECT(96,56), "S3461C15");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C11*)(S3461C16*), ABISELECT(96,56), "S3461C15");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C11*)(S3461C16*), ABISELECT(96,56), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(96,56), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C16*), ABISELECT(96,56), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C16*), ABISELECT(96,56), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C16*), ABISELECT(96,56), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C8 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*), ABISELECT(96,56), "S3461C15");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C18*), ABISELECT(96,56), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*), ABISELECT(96,56), "S3461C15");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C11*)(S3461C16*), 0, "S3461C15");
    check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C11*)(S3461C16*), 0, "S3461C15");
    /*is_ambiguous_... S3461C12::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C11*)(S3461C16*), ABISELECT(8,4), "S3461C15");
    check_base_class_offset(lv, (S3461C12*)(S3461C11*)(S3461C16*), 0, "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(104,64), "S3461C15");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C11*)(S3461C16*), ABISELECT(104,64), "S3461C15");
    check_base_class_offset(lv, (S3461C9*)(S3461C13*)(S3461C17*), ABISELECT(104,64), "S3461C15");
    /*is_ambiguous_... S3461C18::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C18*), ABISELECT(104,64), "S3461C15");
    check_base_class_offset(lv, (S3461C11*)(S3461C16*), 0, "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C16*), ABISELECT(16,8), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C16*), ABISELECT(16,8), "S3461C15");
    /*is_ambiguous_... S3461C13::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C13*)(S3461C17*), ABISELECT(112,68), "S3461C15");
    /*is_ambiguous_... S3461C13::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C13*)(S3461C17*), ABISELECT(120,76), "S3461C15");
    check_base_class_offset(lv, (S3461C13*)(S3461C17*), ABISELECT(104,64), "S3461C15");
    check_base_class_offset(lv, (S3461C17*)(S3461C16*), ABISELECT(104,64), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C16*), ABISELECT(24,12), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C16*), ABISELECT(24,12), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C16*), ABISELECT(32,16), "S3461C15");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C12*)(S3461C16*), ABISELECT(24,12), "S3461C15");
    check_base_class_offset(lv, (S3461C16*), 0, "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C8 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*), ABISELECT(40,20), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C8 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C8*), ABISELECT(40,20), "S3461C15");
    check_base_class_offset(lv, (S3461C8*)(S3461C14*), ABISELECT(40,20), "S3461C15");
    check_base_class_offset(lv, (S3461C14*), ABISELECT(40,20), "S3461C15");
    /*is_ambiguous_... S3461C6::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*)(S3461C18*), ABISELECT(64,32), "S3461C15");
    /*is_ambiguous_... S3461C6::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*)(S3461C18*), ABISELECT(121,77), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*), ABISELECT(121,77), "S3461C15");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C18*), ABISELECT(56,28), "S3461C15");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*)(S3461C18*), ABISELECT(56,28), "S3461C15");
    check_base_class_offset(lv, (S3461C8*)(S3461C6*)(S3461C18*), ABISELECT(56,28), "S3461C15");
    check_base_class_offset(lv, (S3461C6*)(S3461C18*), ABISELECT(56,28), "S3461C15");
    check_base_class_offset(lv, (S3461C18*), ABISELECT(56,28), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*), ABISELECT(80,44), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*), ABISELECT(72,40), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*), ABISELECT(72,40), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C8*)(S3461C6*), ABISELECT(72,40), "S3461C15");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C6*), ABISELECT(72,40), "S3461C15");
    check_field_offset(lv, s3461c15f0, ABISELECT(88,52), "S3461C15.s3461c15f0");
    test_class_info(&lv, &cd_S3461C15);
    dp->~S3461C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C15(Test_S3461C15, "S3461C15", ABISELECT(128,80));

#else // __cplusplus

extern void _ZN8S3461C15C1Ev();
extern void _ZN8S3461C15D2Ev();
Name_Map name_map_S3461C15[] = {
  NSPAIR(_ZN8S3461C15C1Ev),
  NSPAIR(_ZN8S3461C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C11;
extern VTBL_ENTRY _ZTI8S3461C11[];
extern  VTBL_ENTRY _ZTV8S3461C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C11[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C13;
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
extern Class_Descriptor cd_S3461C17;
extern VTBL_ENTRY _ZTI8S3461C17[];
extern  VTBL_ENTRY _ZTV8S3461C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C17[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S3461C16;
extern VTBL_ENTRY _ZTI8S3461C16[];
extern  VTBL_ENTRY _ZTV8S3461C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C16[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C14;
extern VTBL_ENTRY _ZTI8S3461C14[];
extern  VTBL_ENTRY _ZTV8S3461C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C14[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S3461C18;
extern VTBL_ENTRY _ZTI8S3461C18[];
extern  VTBL_ENTRY _ZTV8S3461C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C18[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
static Base_Class bases_S3461C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3461C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(104,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(104,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S3461C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3461C5_nt,    ABISELECT(112,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(120,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3461C13,    ABISELECT(104,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3461C17,    ABISELECT(104,64), //bcp->offset
    43, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(24,12), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3461C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S3461C14,    ABISELECT(40,20), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3461C5_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(121,77), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S3461C6,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3461C18,    ABISELECT(56,28), //bcp->offset
    25, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3461C5_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3461C6,    ABISELECT(72,40), //bcp->offset
    35, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3461C15[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN8S3461C15D1Ev();
extern void _ZN8S3461C15D0Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZThn56_N8S3461C15D1Ev,_ZThn28_N8S3461C15D1Ev)();
extern void ABISELECT(_ZThn56_N8S3461C15D0Ev,_ZThn28_N8S3461C15D0Ev)();
extern void _ZN7S3461C62v2Ev();
extern void _ZN8S3461C182v5Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZThn72_N8S3461C15D1Ev,_ZThn40_N8S3461C15D1Ev)();
extern void ABISELECT(_ZThn72_N8S3461C15D0Ev,_ZThn40_N8S3461C15D0Ev)();
extern void _ZN7S3461C62v2Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S3461C15D1Ev,_ZTv0_n24_N8S3461C15D1Ev)();
extern void ABISELECT(_ZThn104_N8S3461C15D1Ev,_ZThn64_N8S3461C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S3461C15D0Ev,_ZTv0_n24_N8S3461C15D0Ev)();
extern void ABISELECT(_ZThn104_N8S3461C15D0Ev,_ZThn64_N8S3461C15D0Ev)() __attribute__((weak));
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY vtc_S3461C15[] = {
  ABISELECT(121,77),
  ABISELECT(40,20),
  ABISELECT(104,64),
  ABISELECT(104,64),
  ABISELECT(96,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  (VTBL_ENTRY)&_ZN8S3461C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C15D0Ev,
  ABISELECT(80,48),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(72,44),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  0,
  0,
  ABISELECT(56,36),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(48,36),
  ABISELECT(65,49),
  ABISELECT(40,28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N8S3461C15D1Ev,_ZThn28_N8S3461C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N8S3461C15D0Ev,_ZThn28_N8S3461C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3461C182v5Ev,
  ABISELECT(49,37),
  ABISELECT(24,16),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S3461C15D1Ev,_ZThn40_N8S3461C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S3461C15D0Ev,_ZThn40_N8S3461C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  0,
  ABISELECT(-104,-64),
  0,
  0,
  -8,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C15D1Ev,_ZTv0_n24_N8S3461C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C15D0Ev,_ZTv0_n24_N8S3461C15D0Ev),
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern VTBL_ENTRY _ZTV8S3461C15[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN8S3461C16D1Ev();
extern void _ZN8S3461C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C16__8S3461C15[] = {
  ABISELECT(104,64),
  ABISELECT(104,64),
  ABISELECT(96,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  (VTBL_ENTRY)&_ZN8S3461C16D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C16D0Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C118S3461C16__8S3461C15[] = {
  ABISELECT(104,64),
  ABISELECT(96,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C118S3461C16__8S3461C15[] = {
  ABISELECT(96,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C118S3461C16__8S3461C15[] = {
  ABISELECT(96,56),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C118S3461C16__8S3461C15[] = {
  0,
  -8,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C16__A2__8S3461C15[] = {
  ABISELECT(80,48),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C16__A1__8S3461C15[] = {
  ABISELECT(72,44),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C16__A3__8S3461C15[] = {
  ABISELECT(72,44),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev)();
extern void ABISELECT(_ZThn104_N8S3461C16D1Ev,_ZThn64_N8S3461C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev)();
extern void ABISELECT(_ZThn104_N8S3461C16D0Ev,_ZThn64_N8S3461C16D0Ev)() __attribute__((weak));
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C17__8S3461C16__8S3461C15[] = {
  0,
  ABISELECT(-104,-64),
  0,
  0,
  -8,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev),
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A__8S3461C16__8S3461C15[] = {
  ABISELECT(80,48),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C12__A1__8S3461C16__8S3461C15[] = {
  ABISELECT(72,44),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C14__8S3461C15[] = {
  0,
  0,
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C18D1Ev();
extern void _ZN8S3461C18D0Ev();
extern void _ZN7S3461C62v2Ev();
extern void _ZN8S3461C182v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C18__8S3461C15[] = {
  ABISELECT(48,36),
  ABISELECT(65,49),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C18[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C18D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C18D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3461C182v5Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C68S3461C18__8S3461C15[] = {
  ABISELECT(65,49),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C68S3461C18__A1__8S3461C15[] = {
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C68S3461C18__A5__8S3461C15[] = {
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C18__8S3461C15[] = {
  0,
  -8,
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI8S3461C18[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C6__A1__8S3461C15[] = {
  ABISELECT(49,37),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C6__A2__8S3461C15[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C6__A6__8S3461C15[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C15[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C17D1Ev();
extern void _ZN8S3461C17D0Ev();
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C17__8S3461C15[] = {
  0,
  0,
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C17[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D0Ev,
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C138S3461C17__8S3461C15[] = {
  0,
  0,
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__8S3461C15[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C8__A4__8S3461C15[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C15[] = {
  {&(_ZTV8S3461C15[7]),  7,54},
  {&(_tg__ZTV8S3461C16__8S3461C15[5]),  5,9},
  {&(_tg__ZTV8S3461C118S3461C16__8S3461C15[4]),  4,6},
  {&(_tg__ZTV8S3461C128S3461C118S3461C16__8S3461C15[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C128S3461C118S3461C16__8S3461C15[3]),  3,4},
  {&(_tg__ZTV7S3461C9__A1__8S3461C118S3461C16__8S3461C15[4]),  4,5},
  {&(_tg__ZTV7S3461C98S3461C16__A2__8S3461C15[3]),  3,4},
  {&(_tg__ZTV8S3461C128S3461C16__A1__8S3461C15[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C128S3461C16__A3__8S3461C15[3]),  3,4},
  {&(_tg__ZTV8S3461C17__8S3461C16__8S3461C15[7]),  7,11},
  {&(_tg__ZTV7S3461C9__A__8S3461C16__8S3461C15[3]),  3,4},
  {&(_tg__ZTV8S3461C17__8S3461C16__8S3461C15[7]),  7,11},
  {&(_tg__ZTV8S3461C12__A1__8S3461C16__8S3461C15[3]),  3,4},
  {&(_tg__ZTV8S3461C14__8S3461C15[5]),  5,6},
  {&(_tg__ZTV8S3461C14__8S3461C15[5]),  5,6},
  {&(_tg__ZTV8S3461C18__8S3461C15[5]),  5,10},
  {&(_tg__ZTV7S3461C68S3461C18__8S3461C15[4]),  4,8},
  {&(_tg__ZTV7S3461C87S3461C68S3461C18__A1__8S3461C15[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C87S3461C68S3461C18__A5__8S3461C15[3]),  3,4},
  {&(_tg__ZTV7S3461C9__8S3461C18__8S3461C15[4]),  4,5},
  {&(_tg__ZTV7S3461C6__A1__8S3461C15[4]),  4,8},
  {&(_tg__ZTV7S3461C87S3461C6__A2__8S3461C15[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C87S3461C6__A6__8S3461C15[3]),  3,4},
  {&(_ZTV8S3461C15[50]),  50,54},
  {&(_ZTV8S3461C15[14]),  14,54},
  {&(_ZTV8S3461C15[50]),  50,54},
  {&(_ZTV8S3461C15[18]),  18,54},
  {&(_ZTV8S3461C15[24]),  24,54},
  {&(_ZTV8S3461C15[24]),  24,54},
  {&(_ZTV8S3461C15[30]),  30,54},
  {&(_ZTV8S3461C15[39]),  39,54},
  {&(_tg__ZTV7S3461C9__A1__8S3461C15[3]),  3,4},
  {&(_tg__ZTV8S3461C17__8S3461C15[5]),  5,9},
  {&(_tg__ZTV8S3461C138S3461C17__8S3461C15[5]),  5,8},
  {&(_tg__ZTV8S3461C138S3461C17__8S3461C15[5]),  5,8},
  {&(_tg__ZTV8S3461C17__8S3461C15[5]),  5,9},
  {&(_tg__ZTV7S3461C8__8S3461C15[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C8__A4__8S3461C15[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3461C15[];
extern  VTBL_ENTRY _ZTV8S3461C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C15[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S3461C16D0Ev,_ZThn64_N8S3461C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S3461C16D1Ev,_ZThn64_N8S3461C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3461C15D0Ev,_ZTv0_n24_N8S3461C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S3461C15D0Ev,_ZThn64_N8S3461C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3461C15D1Ev,_ZTv0_n24_N8S3461C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S3461C15D1Ev,_ZThn64_N8S3461C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3461C15 = {  "S3461C15", // class name
  bases_S3461C15, 35,
  &(vtc_S3461C15[0]), // expected_vtbl_contents
  &(vtt_S3461C15[0]), // expected_vtt_contents
  ABISELECT(128,80), // object size
  NSPAIRA(_ZTI8S3461C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S3461C15),54, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3461C15),38, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3461C2  : S3461C3 , virtual S3461C12 , S3461C14 , S3461C15 {
  short s3461c2f0:6;
  ~S3461C2(); // tgen
  S3461C2(); // tgen
};
//SIG(-1 S3461C2) C1{ BC2{ VBC3{ BC4{ m FL} BC5{ BC4 VBC6{ m} BC7{ BC8{ VBC4 BC6 v1}} vd v2} BC9{ m} VBC10{ VBC4 BC11{ VBC4 BC8 BC6} VBC8 v3} VBC12{ BC4 VBC8 BC6 vd} vd} BC5 BC13{ VBC7 Fi} vd FD} VBC11 BC13 BC14{ BC15{ BC10 BC8 VBC16{ BC12 v4} BC11} BC13 BC17{ VBC8 BC5 vd v5} BC5 vd Fp} Fs:6}


S3461C2 ::~S3461C2(){ note_dtor("S3461C2", this);} // tgen
S3461C2 ::S3461C2(){ note_ctor("S3461C2", this);} // tgen

static void Test_S3461C2()
{
  extern Class_Descriptor cd_S3461C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(19,45)];
    init_test(&cd_S3461C2, buf);
    S3461C2 *dp, &lv = *(dp=new (buf) S3461C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,176), "sizeof(S3461C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3461C2)");
    /*is_ambiguous_... S3461C4::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C4*), ABISELECT(184,112), "S3461C2");
    /*is_ambiguous_... S3461C6::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*)(S3461C4*), ABISELECT(176,104), "S3461C2");
    /*is_ambiguous_... S3461C6::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*)(S3461C4*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*)(S3461C3*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C6::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*)(S3461C18*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C6*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C11*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C11*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C3*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C8 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*), ABISELECT(192,120), "S3461C2");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C16*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C12*)(S3461C16*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C12*)(S3461C16*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C18*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C15*), ABISELECT(192,120), "S3461C2");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(168,100), "S3461C2");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(168,100), "S3461C2");
    check_base_class_offset(lv, (S3461C8*)(S3461C6*)(S3461C4*), ABISELECT(168,100), "S3461C2");
    check_base_class_offset(lv, (S3461C6*)(S3461C4*), ABISELECT(168,100), "S3461C2");
    check_base_class_offset(lv, (S28C52_nt*)(S3461C4*), ABISELECT(168,100), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(200,128), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C11*), ABISELECT(200,128), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C11*), ABISELECT(208,132), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S3461C12*)(S3461C11*), ABISELECT(200,128), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*), ABISELECT(216,136), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C11 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C11*), ABISELECT(216,136), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C13 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C13*), ABISELECT(216,136), "S3461C2");
    /*is_ambiguous_... S3461C11::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(216,136), "S3461C2");
    check_base_class_offset(lv, (S3461C9*)(S3461C13*)(S3461C17*), ABISELECT(216,136), "S3461C2");
    /*is_ambiguous_... S3461C18::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C18*)(S3461C15*), ABISELECT(216,136), "S3461C2");
    check_base_class_offset(lv, (S3461C11*)(S3461C4*), ABISELECT(200,128), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C13 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C13*), ABISELECT(224,140), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C13 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C13*), ABISELECT(232,148), "S3461C2");
    check_base_class_offset(lv, (S3461C13*)(S3461C4*), ABISELECT(216,136), "S3461C2");
    check_base_class_offset(lv, (S3461C4*)(S3461C3*), ABISELECT(168,100), "S3461C2");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*)(S3461C3*), ABISELECT(8,4), "S3461C2");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C3*), 0, "S3461C2");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*)(S3461C3*), 0, "S3461C2");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C8*)(S3461C6*)(S3461C3*), 0, "S3461C2");
    /*is_ambiguous_... S3461C3::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C6*)(S3461C3*), 0, "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C8 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*), ABISELECT(16,12), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C8 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C8*), ABISELECT(16,12), "S3461C2");
    check_base_class_offset(lv, (S3461C8*)(S3461C14*)(S3461C3*), ABISELECT(16,12), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C14 */ AMB_check_base_class_offset(lv, (S3461C8*)(S3461C14*), ABISELECT(16,12), "S3461C2");
    check_base_class_offset(lv, (S3461C8*)(S3461C14*)(S3461C15*), ABISELECT(16,12), "S3461C2");
    check_base_class_offset(lv, (S3461C14*)(S3461C3*), ABISELECT(16,12), "S3461C2");
    check_base_class_offset(lv, (S3461C3*), 0, "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*), ABISELECT(240,152), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C12*), ABISELECT(240,152), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*), ABISELECT(248,156), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C12*), ABISELECT(240,152), "S3461C2");
    /*is_ambiguous_... S3461C2::S3461C14 */ AMB_check_base_class_offset(lv, (S3461C14*), ABISELECT(48,32), "S3461C2");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(64,40), "S3461C2");
    check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(64,40), "S3461C2");
    /*is_ambiguous_... S3461C12::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(72,44), "S3461C2");
    check_base_class_offset(lv, (S3461C12*)(S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(64,40), "S3461C2");
    check_base_class_offset(lv, (S3461C11*)(S3461C16*)(S3461C15*), ABISELECT(64,40), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C16*)(S3461C15*), ABISELECT(80,48), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C9 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C16*)(S3461C15*), ABISELECT(80,48), "S3461C2");
    /*is_ambiguous_... S3461C13::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C13*)(S3461C17*), ABISELECT(264,164), "S3461C2");
    /*is_ambiguous_... S3461C13::S731C17_nt */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C13*)(S3461C17*), ABISELECT(272,172), "S3461C2");
    check_base_class_offset(lv, (S3461C13*)(S3461C17*), ABISELECT(256,160), "S3461C2");
    check_base_class_offset(lv, (S3461C17*)(S3461C16*)(S3461C15*), ABISELECT(256,160), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C12*)(S3461C16*)(S3461C15*), ABISELECT(88,52), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C12*)(S3461C16*)(S3461C15*), ABISELECT(88,52), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C12*)(S3461C16*)(S3461C15*), ABISELECT(96,56), "S3461C2");
    /*is_ambiguous_... S3461C16::S3461C12 */ AMB_check_base_class_offset(lv, (S3461C12*)(S3461C16*)(S3461C15*), ABISELECT(88,52), "S3461C2");
    check_base_class_offset(lv, (S3461C16*)(S3461C15*), ABISELECT(64,40), "S3461C2");
    check_base_class_offset(lv, (S3461C14*)(S3461C15*), ABISELECT(104,60), "S3461C2");
    /*is_ambiguous_... S3461C6::S3461C5_nt */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*)(S3461C18*)(S3461C15*), ABISELECT(128,72), "S3461C2");
    check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C18*)(S3461C15*), ABISELECT(120,68), "S3461C2");
    check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*)(S3461C18*)(S3461C15*), ABISELECT(120,68), "S3461C2");
    check_base_class_offset(lv, (S3461C8*)(S3461C6*)(S3461C18*)(S3461C15*), ABISELECT(120,68), "S3461C2");
    check_base_class_offset(lv, (S3461C6*)(S3461C18*)(S3461C15*), ABISELECT(120,68), "S3461C2");
    check_base_class_offset(lv, (S3461C18*)(S3461C15*), ABISELECT(120,68), "S3461C2");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C5_nt*)(S3461C6*)(S3461C15*), ABISELECT(144,84), "S3461C2");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S731C17_nt*)(S3461C9*)(S3461C8*)(S3461C6*)(S3461C15*), ABISELECT(136,80), "S3461C2");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C9*)(S3461C8*)(S3461C6*)(S3461C15*), ABISELECT(136,80), "S3461C2");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C8*)(S3461C6*)(S3461C15*), ABISELECT(136,80), "S3461C2");
    /*is_ambiguous_... S3461C15::S3461C6 */ AMB_check_base_class_offset(lv, (S3461C6*)(S3461C15*), ABISELECT(136,80), "S3461C2");
    check_base_class_offset(lv, (S3461C15*), ABISELECT(64,40), "S3461C2");
    set_bf_and_test(lv, s3461c2f0, ABISELECT(160,96), 0, 6, 1, "S3461C2");
    set_bf_and_test(lv, s3461c2f0, ABISELECT(160,96), 0, 6, hide_sll(1LL<<5), "S3461C2");
    test_class_info(&lv, &cd_S3461C2);
    dp->~S3461C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3461C2(Test_S3461C2, "S3461C2", ABISELECT(288,176));

#else // __cplusplus

extern void _ZN7S3461C2C1Ev();
extern void _ZN7S3461C2D1Ev();
Name_Map name_map_S3461C2[] = {
  NSPAIR(_ZN7S3461C2C1Ev),
  NSPAIR(_ZN7S3461C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S28C52_nt;
extern VTBL_ENTRY _ZTI9S28C52_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C11;
extern VTBL_ENTRY _ZTI8S3461C11[];
extern  VTBL_ENTRY _ZTV8S3461C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C11[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C13;
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
extern Class_Descriptor cd_S3461C4;
extern VTBL_ENTRY _ZTI7S3461C4[];
extern  VTBL_ENTRY _ZTV7S3461C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C4[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C14;
extern VTBL_ENTRY _ZTI8S3461C14[];
extern  VTBL_ENTRY _ZTV8S3461C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C14[];
extern Class_Descriptor cd_S3461C3;
extern VTBL_ENTRY _ZTI7S3461C3[];
extern  VTBL_ENTRY _ZTV7S3461C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C3[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S3461C14;
extern VTBL_ENTRY _ZTI8S3461C14[];
extern  VTBL_ENTRY _ZTV8S3461C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C14[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S3461C11;
extern VTBL_ENTRY _ZTI8S3461C11[];
extern  VTBL_ENTRY _ZTV8S3461C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C11[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C13;
extern VTBL_ENTRY _ZTI8S3461C13[];
extern  VTBL_ENTRY _ZTV8S3461C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C13[];
extern Class_Descriptor cd_S3461C17;
extern VTBL_ENTRY _ZTI8S3461C17[];
extern  VTBL_ENTRY _ZTV8S3461C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C17[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C12;
extern VTBL_ENTRY _ZTI8S3461C12[];
extern  VTBL_ENTRY _ZTV8S3461C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C12[];
extern Class_Descriptor cd_S3461C16;
extern VTBL_ENTRY _ZTI8S3461C16[];
extern  VTBL_ENTRY _ZTV8S3461C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C16[];
extern Class_Descriptor cd_S3461C14;
extern VTBL_ENTRY _ZTI8S3461C14[];
extern  VTBL_ENTRY _ZTV8S3461C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C14[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S3461C18;
extern VTBL_ENTRY _ZTI8S3461C18[];
extern  VTBL_ENTRY _ZTV8S3461C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C18[];
extern Class_Descriptor cd_S3461C5_nt;
extern VTBL_ENTRY _ZTI10S3461C5_nt[];
extern Class_Descriptor cd_S731C17_nt;
extern VTBL_ENTRY _ZTI10S731C17_nt[];
extern Class_Descriptor cd_S3461C9;
extern VTBL_ENTRY _ZTI7S3461C9[];
extern  VTBL_ENTRY _ZTV7S3461C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C9[];
extern Class_Descriptor cd_S3461C8;
extern VTBL_ENTRY _ZTI7S3461C8[];
extern  VTBL_ENTRY _ZTV7S3461C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C8[];
extern Class_Descriptor cd_S3461C6;
extern VTBL_ENTRY _ZTI7S3461C6[];
extern  VTBL_ENTRY _ZTV7S3461C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3461C6[];
extern Class_Descriptor cd_S3461C15;
extern VTBL_ENTRY _ZTI8S3461C15[];
extern  VTBL_ENTRY _ZTV8S3461C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3461C15[];
static Base_Class bases_S3461C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3461C5_nt,    ABISELECT(184,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S3461C5_nt,    ABISELECT(176,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(192,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S3461C5_nt,    ABISELECT(192,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    ABISELECT(168,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(168,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(168,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3461C6,    ABISELECT(168,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S28C52_nt,    ABISELECT(168,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(200,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(200,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(208,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(200,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(216,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(216,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3461C11,    ABISELECT(200,128), //bcp->offset
    84, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    69, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S3461C5_nt,    ABISELECT(224,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(232,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3461C13,    ABISELECT(216,136), //bcp->offset
    92, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    74, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S3461C4,    ABISELECT(168,100), //bcp->offset
    70, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S3461C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3461C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S3461C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3461C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    77, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    76, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S3461C14,    ABISELECT(16,12), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3461C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(240,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(240,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    79, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(248,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(240,152), //bcp->offset
    101, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    78, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3461C14,    ABISELECT(48,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S731C17_nt,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(72,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S3461C11,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(80,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(80,48), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    56, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S3461C5_nt,    ABISELECT(264,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(272,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S3461C13,    ABISELECT(256,160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S3461C17,    ABISELECT(256,160), //bcp->offset
    106, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    57, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    50, //immediately_derived
  0, 1},
  {&cd_S731C17_nt,    ABISELECT(88,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(88,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S3461C12,    ABISELECT(88,52), //bcp->offset
    42, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    58, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S3461C16,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S3461C14,    ABISELECT(104,60), //bcp->offset
    46, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    59, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S3461C5_nt,    ABISELECT(128,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S3461C6,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S3461C18,    ABISELECT(120,68), //bcp->offset
    52, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    60, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S3461C5_nt,    ABISELECT(144,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S731C17_nt,    ABISELECT(136,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S3461C9,    ABISELECT(136,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    61, //immediately_derived
  0, 0},
  {&cd_S3461C8,    ABISELECT(136,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S3461C6,    ABISELECT(136,80), //bcp->offset
    62, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    61, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S3461C15,    ABISELECT(64,40), //bcp->offset
    27, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3461C2[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C2D1Ev();
extern void _ZN7S3461C2D0Ev();
extern void _ZN7S3461C62v2Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void ABISELECT(_ZThn64_N7S3461C2D1Ev,_ZThn40_N7S3461C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S3461C2D0Ev,_ZThn40_N7S3461C2D0Ev)();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZThn120_N7S3461C2D1Ev,_ZThn68_N7S3461C2D1Ev)();
extern void ABISELECT(_ZThn120_N7S3461C2D0Ev,_ZThn68_N7S3461C2D0Ev)();
extern void _ZN7S3461C62v2Ev();
extern void _ZN8S3461C182v5Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZThn136_N7S3461C2D1Ev,_ZThn80_N7S3461C2D1Ev)();
extern void ABISELECT(_ZThn136_N7S3461C2D0Ev,_ZThn80_N7S3461C2D0Ev)();
extern void _ZN7S3461C62v2Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n72_N7S3461C2D1Ev,_ZTv0_n36_N7S3461C2D1Ev)();
extern void ABISELECT(_ZThn168_N7S3461C2D1Ev,_ZThn100_N7S3461C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S3461C2D0Ev,_ZTv0_n36_N7S3461C2D0Ev)();
extern void ABISELECT(_ZThn168_N7S3461C2D0Ev,_ZThn100_N7S3461C2D0Ev)() __attribute__((weak));
extern void _ZN7S3461C62v2Ev();
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N7S3461C2D1Ev,_ZTv0_n24_N7S3461C2D1Ev)();
extern void ABISELECT(_ZThn216_N7S3461C2D1Ev,_ZThn136_N7S3461C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S3461C2D0Ev,_ZTv0_n24_N7S3461C2D0Ev)();
extern void ABISELECT(_ZThn216_N7S3461C2D0Ev,_ZThn136_N7S3461C2D0Ev)() __attribute__((weak));
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N7S3461C2D1Ev,_ZTv0_n24_N7S3461C2D1Ev)();
extern void ABISELECT(_ZThn256_N7S3461C2D1Ev,_ZThn160_N7S3461C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S3461C2D0Ev,_ZTv0_n24_N7S3461C2D0Ev)();
extern void ABISELECT(_ZThn256_N7S3461C2D0Ev,_ZThn160_N7S3461C2D0Ev)() __attribute__((weak));
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY vtc_S3461C2[] = {
  ABISELECT(256,160),
  ABISELECT(240,152),
  ABISELECT(16,12),
  ABISELECT(216,136),
  ABISELECT(216,136),
  ABISELECT(200,128),
  ABISELECT(168,100),
  ABISELECT(192,120),
  ABISELECT(192,120),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  0,
  0,
  ABISELECT(176,108),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(144,88),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(128,80),
  ABISELECT(-48,-28),
  ABISELECT(192,120),
  ABISELECT(152,96),
  ABISELECT(128,80),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S3461C2D1Ev,_ZThn40_N7S3461C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S3461C2D0Ev,_ZThn40_N7S3461C2D0Ev),
  ABISELECT(112,72),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(104,68),
  ABISELECT(-88,-52),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  ABISELECT(88,60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  ABISELECT(96,68),
  ABISELECT(72,52),
  ABISELECT(72,52),
  ABISELECT(-120,-68),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S3461C2D1Ev,_ZThn68_N7S3461C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S3461C2D0Ev,_ZThn68_N7S3461C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3461C182v5Ev,
  ABISELECT(56,40),
  ABISELECT(56,40),
  ABISELECT(-136,-80),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N7S3461C2D1Ev,_ZThn80_N7S3461C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N7S3461C2D0Ev,_ZThn80_N7S3461C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  0,
  ABISELECT(-168,-100),
  0,
  ABISELECT(48,36),
  ABISELECT(48,36),
  ABISELECT(32,28),
  ABISELECT(24,20),
  ABISELECT(24,20),
  ABISELECT(-168,-100),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3461C2D1Ev,_ZTv0_n36_N7S3461C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3461C2D0Ev,_ZTv0_n36_N7S3461C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  0,
  0,
  ABISELECT(16,8),
  -8,
  ABISELECT(-200,-128),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  ABISELECT(-216,-136),
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-216,-136),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C2D1Ev,_ZTv0_n24_N7S3461C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C2D0Ev,_ZTv0_n24_N7S3461C2D0Ev),
  0,
  ABISELECT(-48,-32),
  ABISELECT(-240,-152),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  0,
  ABISELECT(-256,-160),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  ABISELECT(-64,-40),
  ABISELECT(-256,-160),
  (VTBL_ENTRY)&(_ZTI7S3461C2[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C2D1Ev,_ZTv0_n24_N7S3461C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C2D0Ev,_ZTv0_n24_N7S3461C2D0Ev),
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern VTBL_ENTRY _ZTV7S3461C2[];
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C3D1Ev();
extern void _ZN7S3461C3D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C3__7S3461C2[] = {
  ABISELECT(16,12),
  ABISELECT(216,136),
  ABISELECT(216,136),
  ABISELECT(200,128),
  ABISELECT(168,100),
  ABISELECT(192,120),
  ABISELECT(192,120),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C67S3461C3__A1__7S3461C2[] = {
  ABISELECT(192,120),
  ABISELECT(192,120),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C67S3461C3__A1__7S3461C2[] = {
  ABISELECT(192,120),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C67S3461C3__A3__7S3461C2[] = {
  ABISELECT(192,120),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C147S3461C3__7S3461C2[] = {
  0,
  0,
  ABISELECT(176,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n72_N7S3461C3D1Ev,_ZTv0_n36_N7S3461C3D1Ev)();
extern void ABISELECT(_ZThn168_N7S3461C3D1Ev,_ZThn100_N7S3461C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S3461C3D0Ev,_ZTv0_n36_N7S3461C3D0Ev)();
extern void ABISELECT(_ZThn168_N7S3461C3D0Ev,_ZThn100_N7S3461C3D0Ev)() __attribute__((weak));
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C4__7S3461C3__7S3461C2[] = {
  0,
  ABISELECT(-168,-100),
  0,
  ABISELECT(48,36),
  ABISELECT(48,36),
  ABISELECT(32,28),
  ABISELECT(24,20),
  ABISELECT(24,20),
  ABISELECT(-168,-100),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3461C3D1Ev,_ZTv0_n36_N7S3461C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3461C3D0Ev,_ZTv0_n36_N7S3461C3D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C11__7S3461C3__7S3461C2[] = {
  0,
  0,
  ABISELECT(16,8),
  -8,
  ABISELECT(-200,-128),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N7S3461C3D1Ev,_ZTv0_n24_N7S3461C3D1Ev)();
extern void ABISELECT(_ZThn216_N7S3461C3D1Ev,_ZThn136_N7S3461C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S3461C3D0Ev,_ZTv0_n24_N7S3461C3D0Ev)();
extern void ABISELECT(_ZThn216_N7S3461C3D0Ev,_ZThn136_N7S3461C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3461C13__7S3461C3__7S3461C2[] = {
  ABISELECT(-216,-136),
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-216,-136),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C3D1Ev,_ZTv0_n24_N7S3461C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C3D0Ev,_ZTv0_n24_N7S3461C3D0Ev),
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C14__7S3461C3__7S3461C2[] = {
  0,
  0,
  ABISELECT(176,108),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7S3461C3[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C14__A1__7S3461C2[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(144,88),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__8S3461C14__A1__7S3461C2[] = {
  0,
  ABISELECT(176,108),
  ABISELECT(32,20),
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN8S3461C15D1Ev();
extern void _ZN8S3461C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C15__7S3461C2[] = {
  ABISELECT(128,80),
  ABISELECT(-48,-28),
  ABISELECT(192,120),
  ABISELECT(152,96),
  ABISELECT(128,80),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  (VTBL_ENTRY)&_ZN8S3461C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C15D0Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
extern void _ZN8S3461C16D1Ev();
extern void _ZN8S3461C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C168S3461C15__7S3461C2[] = {
  ABISELECT(192,120),
  ABISELECT(152,96),
  ABISELECT(128,80),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
  (VTBL_ENTRY)&_ZN8S3461C16D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C16D0Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C118S3461C168S3461C15__A1__7S3461C2[] = {
  ABISELECT(152,96),
  ABISELECT(128,80),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C118S3461C168S3461C15__A2__7S3461C2[] = {
  ABISELECT(128,80),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C118S3461C168S3461C15__A6__7S3461C2[] = {
  ABISELECT(128,80),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C118S3461C168S3461C15__A1__7S3461C2[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-152,-96),
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C168S3461C15__A7__7S3461C2[] = {
  ABISELECT(112,72),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C168S3461C15__A3__7S3461C2[] = {
  ABISELECT(104,68),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C168S3461C15__A8__7S3461C2[] = {
  ABISELECT(104,68),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C168S3461C15__7S3461C2[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-152,-96),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A__8S3461C168S3461C15__7S3461C2[] = {
  ABISELECT(112,72),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev)();
extern void ABISELECT(_ZThn192_N8S3461C16D1Ev,_ZThn120_N8S3461C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev)();
extern void ABISELECT(_ZThn192_N8S3461C16D0Ev,_ZThn120_N8S3461C16D0Ev)() __attribute__((weak));
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C17__8S3461C168S3461C15__7S3461C2[] = {
  0,
  ABISELECT(-192,-120),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  ABISELECT(-64,-40),
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C16D1Ev,_ZTv0_n24_N8S3461C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C16D0Ev,_ZTv0_n24_N8S3461C16D0Ev),
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C12__A1__8S3461C168S3461C15__7S3461C2[] = {
  ABISELECT(104,68),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S3461C16[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C148S3461C15__A2__7S3461C2[] = {
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  ABISELECT(88,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__8S3461C148S3461C15__A2__7S3461C2[] = {
  0,
  ABISELECT(176,108),
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI8S3461C14[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C18D1Ev();
extern void _ZN8S3461C18D0Ev();
extern void _ZN7S3461C62v2Ev();
extern void _ZN8S3461C182v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C188S3461C15__7S3461C2[] = {
  ABISELECT(96,68),
  ABISELECT(72,52),
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C18[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C18D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C18D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3461C182v5Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C68S3461C188S3461C15__A2__7S3461C2[] = {
  ABISELECT(72,52),
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C68S3461C188S3461C15__A3__7S3461C2[] = {
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C68S3461C188S3461C15__A9__7S3461C2[] = {
  ABISELECT(72,52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C188S3461C15__7S3461C2[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-96,-68),
  (VTBL_ENTRY)&(_ZTI8S3461C18[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C68S3461C15__A3__7S3461C2[] = {
  ABISELECT(56,40),
  ABISELECT(56,40),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C68S3461C15__A4__7S3461C2[] = {
  ABISELECT(56,40),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C68S3461C15__A10__7S3461C2[] = {
  ABISELECT(56,40),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C15__7S3461C2[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-152,-96),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C16__A2__8S3461C15__7S3461C2[] = {
  ABISELECT(112,72),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S3461C15D1Ev,_ZTv0_n24_N8S3461C15D1Ev)();
extern void ABISELECT(_ZThn192_N8S3461C15D1Ev,_ZThn120_N8S3461C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S3461C15D0Ev,_ZTv0_n24_N8S3461C15D0Ev)();
extern void ABISELECT(_ZThn192_N8S3461C15D0Ev,_ZThn120_N8S3461C15D0Ev)() __attribute__((weak));
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C17__8S3461C15__7S3461C2[] = {
  0,
  ABISELECT(-192,-120),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  ABISELECT(-64,-40),
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C15D1Ev,_ZTv0_n24_N8S3461C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3461C15D0Ev,_ZTv0_n24_N8S3461C15D0Ev),
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C16__A1__8S3461C15__7S3461C2[] = {
  ABISELECT(104,68),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C14__8S3461C15__7S3461C2[] = {
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  ABISELECT(88,60),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__8S3461C15__7S3461C2[] = {
  0,
  ABISELECT(176,108),
  ABISELECT(48,28),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZThn56_N8S3461C15D1Ev,_ZThn28_N8S3461C15D1Ev)();
extern void ABISELECT(_ZThn56_N8S3461C15D0Ev,_ZThn28_N8S3461C15D0Ev)();
extern void _ZN7S3461C62v2Ev();
extern void _ZN8S3461C182v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C18__8S3461C15__7S3461C2[] = {
  ABISELECT(96,68),
  ABISELECT(72,52),
  ABISELECT(72,52),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N8S3461C15D1Ev,_ZThn28_N8S3461C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N8S3461C15D0Ev,_ZThn28_N8S3461C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3461C182v5Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZThn72_N8S3461C15D1Ev,_ZThn40_N8S3461C15D1Ev)();
extern void ABISELECT(_ZThn72_N8S3461C15D0Ev,_ZThn40_N8S3461C15D0Ev)();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C6__A1__8S3461C15__7S3461C2[] = {
  ABISELECT(56,40),
  ABISELECT(56,40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI8S3461C15[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S3461C15D1Ev,_ZThn40_N8S3461C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S3461C15D0Ev,_ZThn40_N8S3461C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C4D1Ev();
extern void _ZN7S3461C4D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C4__7S3461C2[] = {
  ABISELECT(48,36),
  ABISELECT(48,36),
  ABISELECT(32,28),
  ABISELECT(24,20),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C4D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C4D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN7S3461C6D1Ev();
extern void _ZN7S3461C6D0Ev();
extern void _ZN7S3461C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C67S3461C4__7S3461C2[] = {
  ABISELECT(24,20),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C6[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3461C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3461C62v2Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C87S3461C67S3461C4__7S3461C2[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C87S3461C67S3461C4__7S3461C2[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C11__7S3461C4__7S3461C2[] = {
  0,
  0,
  ABISELECT(16,8),
  -8,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev)();
extern void ABISELECT(_ZThn48_N7S3461C4D1Ev,_ZThn36_N7S3461C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev)();
extern void ABISELECT(_ZThn48_N7S3461C4D0Ev,_ZThn36_N7S3461C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3461C13__7S3461C4__7S3461C2[] = {
  ABISELECT(-48,-36),
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI7S3461C4[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C4D1Ev,_ZTv0_n24_N7S3461C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S3461C4D0Ev,_ZTv0_n24_N7S3461C4D0Ev),
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C112v3Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C11__7S3461C2[] = {
  ABISELECT(16,8),
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C112v3Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C128S3461C11__7S3461C2[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C128S3461C11__A1__7S3461C2[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A1__8S3461C11__7S3461C2[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S3461C11[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__A2__7S3461C2[] = {
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C13__7S3461C2[] = {
  0,
  0,
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C8__A2__7S3461C2[] = {
  ABISELECT(176,108),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C8[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C97S3461C8__A4__7S3461C2[] = {
  ABISELECT(176,108),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C12__A1__7S3461C2[] = {
  ABISELECT(-48,-32),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C12[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C98S3461C12__A5__7S3461C2[] = {
  ABISELECT(-48,-32),
  0,
  (VTBL_ENTRY)&(_ZTI7S3461C9[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C17D1Ev();
extern void _ZN8S3461C17D0Ev();
extern void _ZN8S3461C172v4Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C17__7S3461C2[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  ABISELECT(-64,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C17[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C17D0Ev,
  (VTBL_ENTRY)&_ZN8S3461C172v4Ev,
};
extern void _ZN7S3461C92v1Ev();
extern void _ZN8S3461C13D1Ev();
extern void _ZN8S3461C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3461C138S3461C17__A1__7S3461C2[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  ABISELECT(-64,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3461C13D0Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C138S3461C17__A1__7S3461C2[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI8S3461C13[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
extern void _ZN7S3461C92v1Ev();
static  VTBL_ENTRY _tg__ZTV7S3461C9__8S3461C17__7S3461C2[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI8S3461C17[0]),
  (VTBL_ENTRY)&_ZN7S3461C92v1Ev,
};
static  VTT_ENTRY vtt_S3461C2[] = {
  {&(_ZTV7S3461C2[11]),  11,117},
  {&(_tg__ZTV7S3461C3__7S3461C2[9]),  9,13},
  {&(_tg__ZTV7S3461C67S3461C3__A1__7S3461C2[4]),  4,8},
  {&(_tg__ZTV7S3461C87S3461C67S3461C3__A1__7S3461C2[3]),  3,4},
  {&(_tg__ZTV7S3461C97S3461C87S3461C67S3461C3__A3__7S3461C2[3]),  3,4},
  {&(_tg__ZTV8S3461C147S3461C3__7S3461C2[5]),  5,6},
  {&(_tg__ZTV8S3461C147S3461C3__7S3461C2[5]),  5,6},
  {&(_tg__ZTV7S3461C4__7S3461C3__7S3461C2[10]),  10,14},
  {&(_tg__ZTV8S3461C11__7S3461C3__7S3461C2[6]),  6,8},
  {&(_tg__ZTV8S3461C13__7S3461C3__7S3461C2[6]),  6,9},
  {&(_tg__ZTV8S3461C13__7S3461C3__7S3461C2[6]),  6,9},
  {&(_tg__ZTV8S3461C14__7S3461C3__7S3461C2[5]),  5,6},
  {&(_tg__ZTV8S3461C14__7S3461C3__7S3461C2[5]),  5,6},
  {&(_tg__ZTV8S3461C14__A1__7S3461C2[5]),  5,6},
  {&(_tg__ZTV7S3461C8__8S3461C14__A1__7S3461C2[4]),  4,5},
  {&(_tg__ZTV8S3461C15__7S3461C2[7]),  7,11},
  {&(_tg__ZTV8S3461C168S3461C15__7S3461C2[5]),  5,9},
  {&(_tg__ZTV8S3461C118S3461C168S3461C15__A1__7S3461C2[4]),  4,6},
  {&(_tg__ZTV8S3461C128S3461C118S3461C168S3461C15__A2__7S3461C2[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C128S3461C118S3461C168S3461C15__A6__7S3461C2[3]),  3,4},
  {&(_tg__ZTV7S3461C9__A1__8S3461C118S3461C168S3461C15__A1__7S3461C2[4]),  4,5},
  {&(_tg__ZTV7S3461C98S3461C168S3461C15__A7__7S3461C2[3]),  3,4},
  {&(_tg__ZTV8S3461C128S3461C168S3461C15__A3__7S3461C2[3]),  3,4},
  {&(_tg__ZTV7S3461C98S3461C128S3461C168S3461C15__A8__7S3461C2[3]),  3,4},
  {&(_tg__ZTV7S3461C9__A1__8S3461C168S3461C15__7S3461C2[4]),  4,5},
  {&(_tg__ZTV7S3461C9__A__8S3461C168S3461C15