// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S27C9_nt  {
  int s27c9f0[2];
  void  mf27c9(); // _ZN8S27C9_nt6mf27c9Ev
};
//SIG(-1 S27C9_nt) C1{ m Fi[2]}


void  S27C9_nt ::mf27c9(){}

//skip512 S27C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C8_nt  {
  int s27c8f0;
  __tsi64 s27c8f1;
  void *s27c8f2[4];
  int s27c8f3[2];
  void *s27c8f4;
  ::S27C9_nt s27c8f5;
  void *s27c8f6[2];
  virtual  ~S27C8_nt(); // _ZN8S27C8_ntD1Ev
  virtual void  v4(); // _ZN8S27C8_nt2v4Ev
  virtual void  v5(); // _ZN8S27C8_nt2v5Ev
  virtual void  v6(); // _ZN8S27C8_nt2v6Ev
  virtual void  v7(); // _ZN8S27C8_nt2v7Ev
  virtual void  v8(); // _ZN8S27C8_nt2v8Ev
  virtual void  v9(); // _ZN8S27C8_nt2v9Ev
  virtual void  v10(); // _ZN8S27C8_nt3v10Ev
  virtual void  v11(); // _ZN8S27C8_nt3v11Ev
  virtual void  v12(); // _ZN8S27C8_nt3v12Ev
  virtual void  v13(); // _ZN8S27C8_nt3v13Ev
  virtual void  v14(); // _ZN8S27C8_nt3v14Ev
  virtual void  v15(); // _ZN8S27C8_nt3v15Ev
  virtual void  v16(); // _ZN8S27C8_nt3v16Ev
  virtual void  v17(); // _ZN8S27C8_nt3v17Ev
  virtual void  v18(); // _ZN8S27C8_nt3v18Ev
  virtual void  v19(); // _ZN8S27C8_nt3v19Ev
  virtual void  v20(); // _ZN8S27C8_nt3v20Ev
  virtual void  v21(); // _ZN8S27C8_nt3v21Ev
  virtual void  v22(); // _ZN8S27C8_nt3v22Ev
  virtual void  v23(); // _ZN8S27C8_nt3v23Ev
  virtual void  v24(); // _ZN8S27C8_nt3v24Ev
  virtual void  v25(); // _ZN8S27C8_nt3v25Ev
  virtual void  v26(); // _ZN8S27C8_nt3v26Ev
  virtual void  v27(); // _ZN8S27C8_nt3v27Ev
  virtual void  v28(); // _ZN8S27C8_nt3v28Ev
  virtual void  v29(); // _ZN8S27C8_nt3v29Ev
  virtual void  v30(); // _ZN8S27C8_nt3v30Ev
  virtual void  v31(); // _ZN8S27C8_nt3v31Ev
  virtual void  v32(); // _ZN8S27C8_nt3v32Ev
  virtual void  v33(); // _ZN8S27C8_nt3v33Ev
  virtual void  v34(); // _ZN8S27C8_nt3v34Ev
  virtual void  v35(); // _ZN8S27C8_nt3v35Ev
  virtual void  v36(); // _ZN8S27C8_nt3v36Ev
  virtual void  v37(); // _ZN8S27C8_nt3v37Ev
  virtual void  v38(); // _ZN8S27C8_nt3v38Ev
  virtual void  v39(); // _ZN8S27C8_nt3v39Ev
  virtual void  v40(); // _ZN8S27C8_nt3v40Ev
  virtual void  v41(); // _ZN8S27C8_nt3v41Ev
  virtual void  v42(); // _ZN8S27C8_nt3v42Ev
  virtual void  v43(); // _ZN8S27C8_nt3v43Ev
  virtual void  v44(); // _ZN8S27C8_nt3v44Ev
  virtual void  v45(); // _ZN8S27C8_nt3v45Ev
  virtual void  v46(); // _ZN8S27C8_nt3v46Ev
  virtual void  v47(); // _ZN8S27C8_nt3v47Ev
  virtual void  v48(); // _ZN8S27C8_nt3v48Ev
  virtual void  v49(); // _ZN8S27C8_nt3v49Ev
  virtual void  v50(); // _ZN8S27C8_nt3v50Ev
  virtual void  v51(); // _ZN8S27C8_nt3v51Ev
  virtual void  v52(); // _ZN8S27C8_nt3v52Ev
  virtual void  v53(); // _ZN8S27C8_nt3v53Ev
  virtual void  v54(); // _ZN8S27C8_nt3v54Ev
  virtual void  v55(); // _ZN8S27C8_nt3v55Ev
  virtual void  v56(); // _ZN8S27C8_nt3v56Ev
  virtual void  v57(); // _ZN8S27C8_nt3v57Ev
  virtual void  v58(); // _ZN8S27C8_nt3v58Ev
  virtual void  v59(); // _ZN8S27C8_nt3v59Ev
  virtual void  v60(); // _ZN8S27C8_nt3v60Ev
  virtual void  v61(); // _ZN8S27C8_nt3v61Ev
  virtual void  v62(); // _ZN8S27C8_nt3v62Ev
  virtual void  v63(); // _ZN8S27C8_nt3v63Ev
  virtual void  v64(); // _ZN8S27C8_nt3v64Ev
  virtual void  v65(); // _ZN8S27C8_nt3v65Ev
  virtual void  v66(); // _ZN8S27C8_nt3v66Ev
  virtual void  v67(); // _ZN8S27C8_nt3v67Ev
  S27C8_nt(); // tgen
};
//SIG(-1 S27C8_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S27C8_nt ::~S27C8_nt(){ note_dtor("S27C8_nt", this);}
void  S27C8_nt ::v4(){vfunc_called(this, "_ZN8S27C8_nt2v4Ev");}
void  S27C8_nt ::v5(){vfunc_called(this, "_ZN8S27C8_nt2v5Ev");}
void  S27C8_nt ::v6(){vfunc_called(this, "_ZN8S27C8_nt2v6Ev");}
void  S27C8_nt ::v7(){vfunc_called(this, "_ZN8S27C8_nt2v7Ev");}
void  S27C8_nt ::v8(){vfunc_called(this, "_ZN8S27C8_nt2v8Ev");}
void  S27C8_nt ::v9(){vfunc_called(this, "_ZN8S27C8_nt2v9Ev");}
void  S27C8_nt ::v10(){vfunc_called(this, "_ZN8S27C8_nt3v10Ev");}
void  S27C8_nt ::v11(){vfunc_called(this, "_ZN8S27C8_nt3v11Ev");}
void  S27C8_nt ::v12(){vfunc_called(this, "_ZN8S27C8_nt3v12Ev");}
void  S27C8_nt ::v13(){vfunc_called(this, "_ZN8S27C8_nt3v13Ev");}
void  S27C8_nt ::v14(){vfunc_called(this, "_ZN8S27C8_nt3v14Ev");}
void  S27C8_nt ::v15(){vfunc_called(this, "_ZN8S27C8_nt3v15Ev");}
void  S27C8_nt ::v16(){vfunc_called(this, "_ZN8S27C8_nt3v16Ev");}
void  S27C8_nt ::v17(){vfunc_called(this, "_ZN8S27C8_nt3v17Ev");}
void  S27C8_nt ::v18(){vfunc_called(this, "_ZN8S27C8_nt3v18Ev");}
void  S27C8_nt ::v19(){vfunc_called(this, "_ZN8S27C8_nt3v19Ev");}
void  S27C8_nt ::v20(){vfunc_called(this, "_ZN8S27C8_nt3v20Ev");}
void  S27C8_nt ::v21(){vfunc_called(this, "_ZN8S27C8_nt3v21Ev");}
void  S27C8_nt ::v22(){vfunc_called(this, "_ZN8S27C8_nt3v22Ev");}
void  S27C8_nt ::v23(){vfunc_called(this, "_ZN8S27C8_nt3v23Ev");}
void  S27C8_nt ::v24(){vfunc_called(this, "_ZN8S27C8_nt3v24Ev");}
void  S27C8_nt ::v25(){vfunc_called(this, "_ZN8S27C8_nt3v25Ev");}
void  S27C8_nt ::v26(){vfunc_called(this, "_ZN8S27C8_nt3v26Ev");}
void  S27C8_nt ::v27(){vfunc_called(this, "_ZN8S27C8_nt3v27Ev");}
void  S27C8_nt ::v28(){vfunc_called(this, "_ZN8S27C8_nt3v28Ev");}
void  S27C8_nt ::v29(){vfunc_called(this, "_ZN8S27C8_nt3v29Ev");}
void  S27C8_nt ::v30(){vfunc_called(this, "_ZN8S27C8_nt3v30Ev");}
void  S27C8_nt ::v31(){vfunc_called(this, "_ZN8S27C8_nt3v31Ev");}
void  S27C8_nt ::v32(){vfunc_called(this, "_ZN8S27C8_nt3v32Ev");}
void  S27C8_nt ::v33(){vfunc_called(this, "_ZN8S27C8_nt3v33Ev");}
void  S27C8_nt ::v34(){vfunc_called(this, "_ZN8S27C8_nt3v34Ev");}
void  S27C8_nt ::v35(){vfunc_called(this, "_ZN8S27C8_nt3v35Ev");}
void  S27C8_nt ::v36(){vfunc_called(this, "_ZN8S27C8_nt3v36Ev");}
void  S27C8_nt ::v37(){vfunc_called(this, "_ZN8S27C8_nt3v37Ev");}
void  S27C8_nt ::v38(){vfunc_called(this, "_ZN8S27C8_nt3v38Ev");}
void  S27C8_nt ::v39(){vfunc_called(this, "_ZN8S27C8_nt3v39Ev");}
void  S27C8_nt ::v40(){vfunc_called(this, "_ZN8S27C8_nt3v40Ev");}
void  S27C8_nt ::v41(){vfunc_called(this, "_ZN8S27C8_nt3v41Ev");}
void  S27C8_nt ::v42(){vfunc_called(this, "_ZN8S27C8_nt3v42Ev");}
void  S27C8_nt ::v43(){vfunc_called(this, "_ZN8S27C8_nt3v43Ev");}
void  S27C8_nt ::v44(){vfunc_called(this, "_ZN8S27C8_nt3v44Ev");}
void  S27C8_nt ::v45(){vfunc_called(this, "_ZN8S27C8_nt3v45Ev");}
void  S27C8_nt ::v46(){vfunc_called(this, "_ZN8S27C8_nt3v46Ev");}
void  S27C8_nt ::v47(){vfunc_called(this, "_ZN8S27C8_nt3v47Ev");}
void  S27C8_nt ::v48(){vfunc_called(this, "_ZN8S27C8_nt3v48Ev");}
void  S27C8_nt ::v49(){vfunc_called(this, "_ZN8S27C8_nt3v49Ev");}
void  S27C8_nt ::v50(){vfunc_called(this, "_ZN8S27C8_nt3v50Ev");}
void  S27C8_nt ::v51(){vfunc_called(this, "_ZN8S27C8_nt3v51Ev");}
void  S27C8_nt ::v52(){vfunc_called(this, "_ZN8S27C8_nt3v52Ev");}
void  S27C8_nt ::v53(){vfunc_called(this, "_ZN8S27C8_nt3v53Ev");}
void  S27C8_nt ::v54(){vfunc_called(this, "_ZN8S27C8_nt3v54Ev");}
void  S27C8_nt ::v55(){vfunc_called(this, "_ZN8S27C8_nt3v55Ev");}
void  S27C8_nt ::v56(){vfunc_called(this, "_ZN8S27C8_nt3v56Ev");}
void  S27C8_nt ::v57(){vfunc_called(this, "_ZN8S27C8_nt3v57Ev");}
void  S27C8_nt ::v58(){vfunc_called(this, "_ZN8S27C8_nt3v58Ev");}
void  S27C8_nt ::v59(){vfunc_called(this, "_ZN8S27C8_nt3v59Ev");}
void  S27C8_nt ::v60(){vfunc_called(this, "_ZN8S27C8_nt3v60Ev");}
void  S27C8_nt ::v61(){vfunc_called(this, "_ZN8S27C8_nt3v61Ev");}
void  S27C8_nt ::v62(){vfunc_called(this, "_ZN8S27C8_nt3v62Ev");}
void  S27C8_nt ::v63(){vfunc_called(this, "_ZN8S27C8_nt3v63Ev");}
void  S27C8_nt ::v64(){vfunc_called(this, "_ZN8S27C8_nt3v64Ev");}
void  S27C8_nt ::v65(){vfunc_called(this, "_ZN8S27C8_nt3v65Ev");}
void  S27C8_nt ::v66(){vfunc_called(this, "_ZN8S27C8_nt3v66Ev");}
void  S27C8_nt ::v67(){vfunc_called(this, "_ZN8S27C8_nt3v67Ev");}
S27C8_nt ::S27C8_nt(){ note_ctor("S27C8_nt", this);} // tgen

//skip512 S27C8_nt

#else // __cplusplus

extern void _ZN8S27C8_ntC1Ev();
extern void _ZN8S27C8_ntD1Ev();
Name_Map name_map_S27C8_nt[] = {
  NSPAIR(_ZN8S27C8_ntC1Ev),
  NSPAIR(_ZN8S27C8_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern void _ZN8S27C8_ntD1Ev();
extern void _ZN8S27C8_ntD0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
static  VTBL_ENTRY vtc_S27C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S27C8_nt[0]),
  (VTBL_ENTRY)&_ZN8S27C8_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S27C8_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI8S27C8_nt[];
VTBL_ENTRY *P__ZTI8S27C8_nt = _ZTI8S27C8_nt; 
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
Class_Descriptor cd_S27C8_nt = {  "S27C8_nt", // class name
  0,0,//no base classes
  &(vtc_S27C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S27C8_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S27C8_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C12_nt  {
  void *s27c12f0;
  int s27c12f1[2];
  void  mf27c12(); // _ZN9S27C12_nt7mf27c12Ev
};
//SIG(-1 S27C12_nt) C1{ m Fp Fi[2]}


void  S27C12_nt ::mf27c12(){}

//skip512 S27C12_nt

#else // __cplusplus

Class_Descriptor cd_S27C12_nt = {  "S27C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C11_nt  : S27C12_nt {
};
//SIG(-1 S27C11_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S27C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C11_nt = {  "S27C11_nt", // class name
  bases_S27C11_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C10_nt  : S27C11_nt {
};
//SIG(-1 S27C10_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S27C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C11_nt;
static Base_Class bases_S27C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C13_nt  {
  int s27c13f0;
  void  mf27c13(); // _ZN9S27C13_nt7mf27c13Ev
};
//SIG(-1 S27C13_nt) C1{ m Fi}


void  S27C13_nt ::mf27c13(){}

//skip512 S27C13_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S27C13_nt[];
VTBL_ENTRY *P__ZTI9S27C13_nt = _ZTI9S27C13_nt; 
Class_Descriptor cd_S27C13_nt = {  "S27C13_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI9S27C13_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C17  : S27C12_nt {
};
//SIG(-1 S27C17) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C17()
{
  extern Class_Descriptor cd_S27C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C17, buf);
    S27C17 &lv = *(new (buf) S27C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C17)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C17");
    test_class_info(&lv, &cd_S27C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C17(Test_S27C17, "S27C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C17 = {  "S27C17", // class name
  bases_S27C17, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C16  : S27C17 {
};
//SIG(-1 S27C16) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C16()
{
  extern Class_Descriptor cd_S27C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C16, buf);
    S27C16 &lv = *(new (buf) S27C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C16)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C17*), 0, "S27C16");
    check_base_class_offset(lv, (S27C17*), 0, "S27C16");
    test_class_info(&lv, &cd_S27C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C16(Test_S27C16, "S27C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C17;
static Base_Class bases_S27C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C16 = {  "S27C16", // class name
  bases_S27C16, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C18_nt  {
  int s27c18f0[3];
  void  mf27c18(); // _ZN9S27C18_nt7mf27c18Ev
};
//SIG(-1 S27C18_nt) C1{ m Fi[3]}


void  S27C18_nt ::mf27c18(){}

//skip512 S27C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C23  : S27C12_nt {
};
//SIG(-1 S27C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C23()
{
  extern Class_Descriptor cd_S27C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C23, buf);
    S27C23 &lv = *(new (buf) S27C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C23)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C23");
    test_class_info(&lv, &cd_S27C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C23(Test_S27C23, "S27C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C23 = {  "S27C23", // class name
  bases_S27C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C22  : S27C23 {
};
//SIG(-1 S27C22) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C22()
{
  extern Class_Descriptor cd_S27C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C22, buf);
    S27C22 &lv = *(new (buf) S27C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C22)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C23*), 0, "S27C22");
    check_base_class_offset(lv, (S27C23*), 0, "S27C22");
    test_class_info(&lv, &cd_S27C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C22(Test_S27C22, "S27C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C23;
static Base_Class bases_S27C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C22 = {  "S27C22", // class name
  bases_S27C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C7_nt  : S27C8_nt {
  ::S27C10_nt s27c7f0;
  ::S27C10_nt s27c7f1;
  ::S27C13_nt s27c7f2;
  int s27c7f3;
  char s27c7f4[4];
  void *s27c7f5[2];
  ::S27C10_nt s27c7f6;
  unsigned int s27c7f7:1;
  unsigned int s27c7f8:1;
  unsigned int s27c7f9:1;
  unsigned int s27c7f10:1;
  unsigned int s27c7f11:1;
  unsigned int s27c7f12:1;
  unsigned int s27c7f13:1;
  unsigned int s27c7f14:1;
  unsigned int s27c7f15:1;
  unsigned int s27c7f16:1;
  unsigned int s27c7f17:1;
  unsigned int s27c7f18:1;
  unsigned int s27c7f19:1;
  unsigned int s27c7f20:1;
  unsigned int s27c7f21:1;
  unsigned int s27c7f22:1;
  unsigned int s27c7f23:1;
  unsigned int s27c7f24:1;
  unsigned int s27c7f25:1;
  unsigned int s27c7f26:1;
  unsigned int s27c7f27:1;
  unsigned int s27c7f28:1;
  unsigned int s27c7f29:1;
  unsigned int s27c7f30:1;
  unsigned int s27c7f31:1;
  unsigned int s27c7f32:1;
  unsigned int s27c7f33:1;
  unsigned int s27c7f34:1;
  unsigned int s27c7f35:1;
  unsigned int s27c7f36:1;
  unsigned int s27c7f37:1;
  unsigned int s27c7f38:1;
  unsigned int s27c7f39:1;
  unsigned int s27c7f40:1;
  unsigned int s27c7f41:1;
  unsigned int s27c7f42:1;
  unsigned int s27c7f43:1;
  unsigned int s27c7f44:1;
  unsigned int s27c7f45:1;
  unsigned int s27c7f46:1;
  unsigned int s27c7f47:1;
  unsigned int s27c7f48:1;
  unsigned int s27c7f49:1;
  unsigned int s27c7f50:1;
  unsigned int s27c7f51:1;
  unsigned int s27c7f52:1;
  unsigned int s27c7f53:1;
  unsigned int s27c7f54:1;
  unsigned int s27c7f55:1;
  unsigned int s27c7f56:1;
  unsigned int s27c7f57:1;
  unsigned int s27c7f58:1;
  unsigned int s27c7f59:1;
  unsigned int s27c7f60:1;
  unsigned int s27c7f61:1;
  unsigned int s27c7f62:1;
  unsigned int s27c7f63:1;
  unsigned int s27c7f64:1;
  unsigned int s27c7f65:1;
  unsigned int s27c7f66:1;
  unsigned int s27c7f67:1;
  unsigned int s27c7f68:1;
  unsigned int s27c7f69:1;
  unsigned int s27c7f70:1;
  unsigned int s27c7f71:1;
  unsigned int s27c7f72:1;
  unsigned int s27c7f73:1;
  unsigned int s27c7f74:1;
  unsigned int s27c7f75:1;
  unsigned int s27c7f76:1;
  unsigned int s27c7f77:1;
  unsigned int s27c7f78:1;
  unsigned int s27c7f79:1;
  unsigned int s27c7f80:1;
  unsigned int s27c7f81:1;
  unsigned int s27c7f82:1;
  unsigned int s27c7f83:1;
  int s27c7f84[5];
  void *s27c7f85[2];
  int s27c7f86[3];
  ::S27C9_nt s27c7f87;
  ::S27C9_nt s27c7f88;
  ::S27C9_nt s27c7f89;
  ::S27C16 s27c7f90;
  ::S27C16 s27c7f91;
  int s27c7f92;
  void *s27c7f93[2];
  ::S27C18_nt s27c7f94;
  ::S27C18_nt s27c7f95;
  ::S27C18_nt s27c7f96;
  ::S27C18_nt s27c7f97;
  void *s27c7f98;
  ::S27C9_nt s27c7f99;
  ::S27C16 s27c7f100;
  ::S27C18_nt s27c7f101;
  ::S27C18_nt s27c7f102;
  int s27c7f103;
  ::S27C18_nt s27c7f104;
  ::S27C18_nt s27c7f105;
  void *s27c7f106;
  int s27c7f107;
  char s27c7f108;
  ::S27C18_nt s27c7f109;
  ::S27C18_nt s27c7f110;
  void *s27c7f111;
  int s27c7f112;
  void *s27c7f113;
  ::S27C16 s27c7f114;
  ::S27C22 s27c7f115;
  ::S27C22 s27c7f116;
  virtual  ~S27C7_nt(); // _ZN8S27C7_ntD1Ev
  virtual void  v68(); // _ZN8S27C7_nt3v68Ev
  virtual void  v69(); // _ZN8S27C7_nt3v69Ev
  virtual void  v70(); // _ZN8S27C7_nt3v70Ev
  virtual void  v71(); // _ZN8S27C7_nt3v71Ev
  virtual void  v72(); // _ZN8S27C7_nt3v72Ev
  virtual void  v73(); // _ZN8S27C7_nt3v73Ev
  virtual void  v74(); // _ZN8S27C7_nt3v74Ev
  virtual void  v75(); // _ZN8S27C7_nt3v75Ev
  virtual void  v76(); // _ZN8S27C7_nt3v76Ev
  virtual void  v77(); // _ZN8S27C7_nt3v77Ev
  virtual void  v78(); // _ZN8S27C7_nt3v78Ev
  virtual void  v79(); // _ZN8S27C7_nt3v79Ev
  virtual void  v80(); // _ZN8S27C7_nt3v80Ev
  virtual void  v81(); // _ZN8S27C7_nt3v81Ev
  virtual void  v82(); // _ZN8S27C7_nt3v82Ev
  virtual void  v83(); // _ZN8S27C7_nt3v83Ev
  virtual void  v84(); // _ZN8S27C7_nt3v84Ev
  virtual void  v85(); // _ZN8S27C7_nt3v85Ev
  virtual void  v86(); // _ZN8S27C7_nt3v86Ev
  virtual void  v87(); // _ZN8S27C7_nt3v87Ev
  virtual void  v88(); // _ZN8S27C7_nt3v88Ev
  virtual void  v89(); // _ZN8S27C7_nt3v89Ev
  virtual void  v90(); // _ZN8S27C7_nt3v90Ev
  virtual void  v91(); // _ZN8S27C7_nt3v91Ev
  virtual void  v92(); // _ZN8S27C7_nt3v92Ev
  virtual void  v93(); // _ZN8S27C7_nt3v93Ev
  virtual void  v94(); // _ZN8S27C7_nt3v94Ev
  virtual void  v95(); // _ZN8S27C7_nt3v95Ev
  virtual void  v96(); // _ZN8S27C7_nt3v96Ev
  virtual void  v97(); // _ZN8S27C7_nt3v97Ev
  virtual void  v98(); // _ZN8S27C7_nt3v98Ev
  virtual void  v99(); // _ZN8S27C7_nt3v99Ev
  virtual void  v100(); // _ZN8S27C7_nt4v100Ev
  virtual void  v101(); // _ZN8S27C7_nt4v101Ev
  virtual void  v102(); // _ZN8S27C7_nt4v102Ev
  virtual void  v103(); // _ZN8S27C7_nt4v103Ev
  virtual void  v104(); // _ZN8S27C7_nt4v104Ev
  virtual void  v105(); // _ZN8S27C7_nt4v105Ev
  virtual void  v106(); // _ZN8S27C7_nt4v106Ev
  virtual void  v107(); // _ZN8S27C7_nt4v107Ev
  virtual void  v108(); // _ZN8S27C7_nt4v108Ev
  virtual void  v109(); // _ZN8S27C7_nt4v109Ev
  virtual void  v110(); // _ZN8S27C7_nt4v110Ev
  virtual void  v111(); // _ZN8S27C7_nt4v111Ev
  virtual void  v112(); // _ZN8S27C7_nt4v112Ev
  virtual void  v113(); // _ZN8S27C7_nt4v113Ev
  virtual void  v114(); // _ZN8S27C7_nt4v114Ev
  virtual void  v115(); // _ZN8S27C7_nt4v115Ev
  virtual void  v116(); // _ZN8S27C7_nt4v116Ev
  virtual void  v117(); // _ZN8S27C7_nt4v117Ev
  virtual void  v118(); // _ZN8S27C7_nt4v118Ev
  virtual void  v119(); // _ZN8S27C7_nt4v119Ev
  virtual void  v120(); // _ZN8S27C7_nt4v120Ev
  virtual void  v121(); // _ZN8S27C7_nt4v121Ev
  virtual void  v122(); // _ZN8S27C7_nt4v122Ev
  virtual void  v123(); // _ZN8S27C7_nt4v123Ev
  virtual void  v124(); // _ZN8S27C7_nt4v124Ev
  virtual void  v125(); // _ZN8S27C7_nt4v125Ev
  virtual void  v126(); // _ZN8S27C7_nt4v126Ev
  virtual void  v127(); // _ZN8S27C7_nt4v127Ev
  virtual void  v128(); // _ZN8S27C7_nt4v128Ev
  virtual void  v129(); // _ZN8S27C7_nt4v129Ev
  virtual void  v130(); // _ZN8S27C7_nt4v130Ev
  virtual void  v131(); // _ZN8S27C7_nt4v131Ev
  virtual void  v132(); // _ZN8S27C7_nt4v132Ev
  virtual void  v133(); // _ZN8S27C7_nt4v133Ev
  virtual void  v134(); // _ZN8S27C7_nt4v134Ev
  virtual void  v135(); // _ZN8S27C7_nt4v135Ev
  virtual void  v136(); // _ZN8S27C7_nt4v136Ev
  virtual void  v137(); // _ZN8S27C7_nt4v137Ev
  virtual void  v138(); // _ZN8S27C7_nt4v138Ev
  virtual void  v139(); // _ZN8S27C7_nt4v139Ev
  virtual void  v140(); // _ZN8S27C7_nt4v140Ev
  virtual void  v141(); // _ZN8S27C7_nt4v141Ev
  virtual void  v142(); // _ZN8S27C7_nt4v142Ev
  virtual void  v143(); // _ZN8S27C7_nt4v143Ev
  virtual void  v144(); // _ZN8S27C7_nt4v144Ev
  virtual void  v145(); // _ZN8S27C7_nt4v145Ev
  virtual void  v146(); // _ZN8S27C7_nt4v146Ev
  virtual void  v147(); // _ZN8S27C7_nt4v147Ev
  virtual void  v148(); // _ZN8S27C7_nt4v148Ev
  virtual void  v149(); // _ZN8S27C7_nt4v149Ev
  virtual void  v150(); // _ZN8S27C7_nt4v150Ev
  virtual void  v151(); // _ZN8S27C7_nt4v151Ev
  virtual void  v152(); // _ZN8S27C7_nt4v152Ev
  virtual void  v153(); // _ZN8S27C7_nt4v153Ev
  virtual void  v154(); // _ZN8S27C7_nt4v154Ev
  virtual void  v155(); // _ZN8S27C7_nt4v155Ev
  virtual void  v156(); // _ZN8S27C7_nt4v156Ev
  virtual void  v157(); // _ZN8S27C7_nt4v157Ev
  virtual void  v158(); // _ZN8S27C7_nt4v158Ev
  virtual void  v159(); // _ZN8S27C7_nt4v159Ev
  virtual void  v160(); // _ZN8S27C7_nt4v160Ev
  virtual void  v161(); // _ZN8S27C7_nt4v161Ev
  virtual void  v162(); // _ZN8S27C7_nt4v162Ev
  virtual void  v163(); // _ZN8S27C7_nt4v163Ev
  virtual void  v164(); // _ZN8S27C7_nt4v164Ev
  virtual void  v165(); // _ZN8S27C7_nt4v165Ev
  virtual void  v166(); // _ZN8S27C7_nt4v166Ev
  virtual void  v167(); // _ZN8S27C7_nt4v167Ev
  virtual void  v168(); // _ZN8S27C7_nt4v168Ev
  virtual void  v169(); // _ZN8S27C7_nt4v169Ev
  virtual void  v170(); // _ZN8S27C7_nt4v170Ev
  virtual void  v171(); // _ZN8S27C7_nt4v171Ev
  virtual void  v172(); // _ZN8S27C7_nt4v172Ev
  virtual void  v173(); // _ZN8S27C7_nt4v173Ev
  virtual void  v174(); // _ZN8S27C7_nt4v174Ev
  virtual void  v175(); // _ZN8S27C7_nt4v175Ev
  virtual void  v176(); // _ZN8S27C7_nt4v176Ev
  virtual void  v177(); // _ZN8S27C7_nt4v177Ev
  virtual void  v178(); // _ZN8S27C7_nt4v178Ev
  virtual void  v179(); // _ZN8S27C7_nt4v179Ev
  virtual void  v180(); // _ZN8S27C7_nt4v180Ev
  virtual void  v181(); // _ZN8S27C7_nt4v181Ev
  virtual void  v182(); // _ZN8S27C7_nt4v182Ev
  virtual void  v183(); // _ZN8S27C7_nt4v183Ev
  virtual void  v184(); // _ZN8S27C7_nt4v184Ev
  virtual void  v185(); // _ZN8S27C7_nt4v185Ev
  virtual void  v186(); // _ZN8S27C7_nt4v186Ev
  virtual void  v187(); // _ZN8S27C7_nt4v187Ev
  virtual void  v188(); // _ZN8S27C7_nt4v188Ev
  virtual void  v189(); // _ZN8S27C7_nt4v189Ev
  virtual void  v190(); // _ZN8S27C7_nt4v190Ev
  virtual void  v191(); // _ZN8S27C7_nt4v191Ev
  virtual void  v192(); // _ZN8S27C7_nt4v192Ev
  virtual void  v193(); // _ZN8S27C7_nt4v193Ev
  virtual void  v194(); // _ZN8S27C7_nt4v194Ev
  virtual void  v195(); // _ZN8S27C7_nt4v195Ev
  virtual void  v196(); // _ZN8S27C7_nt4v196Ev
  virtual void  v197(); // _ZN8S27C7_nt4v197Ev
  virtual void  v198(); // _ZN8S27C7_nt4v198Ev
  virtual void  v199(); // _ZN8S27C7_nt4v199Ev
  virtual void  v200(); // _ZN8S27C7_nt4v200Ev
  virtual void  v201(); // _ZN8S27C7_nt4v201Ev
  virtual void  v202(); // _ZN8S27C7_nt4v202Ev
  virtual void  v203(); // _ZN8S27C7_nt4v203Ev
  virtual void  v204(); // _ZN8S27C7_nt4v204Ev
  virtual void  v205(); // _ZN8S27C7_nt4v205Ev
  virtual void  v206(); // _ZN8S27C7_nt4v206Ev
  virtual void  v207(); // _ZN8S27C7_nt4v207Ev
  virtual void  v208(); // _ZN8S27C7_nt4v208Ev
  virtual void  v209(); // _ZN8S27C7_nt4v209Ev
  virtual void  v210(); // _ZN8S27C7_nt4v210Ev
  S27C7_nt(); // tgen
};
//SIG(-1 S27C7_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S27C7_nt ::~S27C7_nt(){ note_dtor("S27C7_nt", this);}
void  S27C7_nt ::v68(){vfunc_called(this, "_ZN8S27C7_nt3v68Ev");}
void  S27C7_nt ::v69(){vfunc_called(this, "_ZN8S27C7_nt3v69Ev");}
void  S27C7_nt ::v70(){vfunc_called(this, "_ZN8S27C7_nt3v70Ev");}
void  S27C7_nt ::v71(){vfunc_called(this, "_ZN8S27C7_nt3v71Ev");}
void  S27C7_nt ::v72(){vfunc_called(this, "_ZN8S27C7_nt3v72Ev");}
void  S27C7_nt ::v73(){vfunc_called(this, "_ZN8S27C7_nt3v73Ev");}
void  S27C7_nt ::v74(){vfunc_called(this, "_ZN8S27C7_nt3v74Ev");}
void  S27C7_nt ::v75(){vfunc_called(this, "_ZN8S27C7_nt3v75Ev");}
void  S27C7_nt ::v76(){vfunc_called(this, "_ZN8S27C7_nt3v76Ev");}
void  S27C7_nt ::v77(){vfunc_called(this, "_ZN8S27C7_nt3v77Ev");}
void  S27C7_nt ::v78(){vfunc_called(this, "_ZN8S27C7_nt3v78Ev");}
void  S27C7_nt ::v79(){vfunc_called(this, "_ZN8S27C7_nt3v79Ev");}
void  S27C7_nt ::v80(){vfunc_called(this, "_ZN8S27C7_nt3v80Ev");}
void  S27C7_nt ::v81(){vfunc_called(this, "_ZN8S27C7_nt3v81Ev");}
void  S27C7_nt ::v82(){vfunc_called(this, "_ZN8S27C7_nt3v82Ev");}
void  S27C7_nt ::v83(){vfunc_called(this, "_ZN8S27C7_nt3v83Ev");}
void  S27C7_nt ::v84(){vfunc_called(this, "_ZN8S27C7_nt3v84Ev");}
void  S27C7_nt ::v85(){vfunc_called(this, "_ZN8S27C7_nt3v85Ev");}
void  S27C7_nt ::v86(){vfunc_called(this, "_ZN8S27C7_nt3v86Ev");}
void  S27C7_nt ::v87(){vfunc_called(this, "_ZN8S27C7_nt3v87Ev");}
void  S27C7_nt ::v88(){vfunc_called(this, "_ZN8S27C7_nt3v88Ev");}
void  S27C7_nt ::v89(){vfunc_called(this, "_ZN8S27C7_nt3v89Ev");}
void  S27C7_nt ::v90(){vfunc_called(this, "_ZN8S27C7_nt3v90Ev");}
void  S27C7_nt ::v91(){vfunc_called(this, "_ZN8S27C7_nt3v91Ev");}
void  S27C7_nt ::v92(){vfunc_called(this, "_ZN8S27C7_nt3v92Ev");}
void  S27C7_nt ::v93(){vfunc_called(this, "_ZN8S27C7_nt3v93Ev");}
void  S27C7_nt ::v94(){vfunc_called(this, "_ZN8S27C7_nt3v94Ev");}
void  S27C7_nt ::v95(){vfunc_called(this, "_ZN8S27C7_nt3v95Ev");}
void  S27C7_nt ::v96(){vfunc_called(this, "_ZN8S27C7_nt3v96Ev");}
void  S27C7_nt ::v97(){vfunc_called(this, "_ZN8S27C7_nt3v97Ev");}
void  S27C7_nt ::v98(){vfunc_called(this, "_ZN8S27C7_nt3v98Ev");}
void  S27C7_nt ::v99(){vfunc_called(this, "_ZN8S27C7_nt3v99Ev");}
void  S27C7_nt ::v100(){vfunc_called(this, "_ZN8S27C7_nt4v100Ev");}
void  S27C7_nt ::v101(){vfunc_called(this, "_ZN8S27C7_nt4v101Ev");}
void  S27C7_nt ::v102(){vfunc_called(this, "_ZN8S27C7_nt4v102Ev");}
void  S27C7_nt ::v103(){vfunc_called(this, "_ZN8S27C7_nt4v103Ev");}
void  S27C7_nt ::v104(){vfunc_called(this, "_ZN8S27C7_nt4v104Ev");}
void  S27C7_nt ::v105(){vfunc_called(this, "_ZN8S27C7_nt4v105Ev");}
void  S27C7_nt ::v106(){vfunc_called(this, "_ZN8S27C7_nt4v106Ev");}
void  S27C7_nt ::v107(){vfunc_called(this, "_ZN8S27C7_nt4v107Ev");}
void  S27C7_nt ::v108(){vfunc_called(this, "_ZN8S27C7_nt4v108Ev");}
void  S27C7_nt ::v109(){vfunc_called(this, "_ZN8S27C7_nt4v109Ev");}
void  S27C7_nt ::v110(){vfunc_called(this, "_ZN8S27C7_nt4v110Ev");}
void  S27C7_nt ::v111(){vfunc_called(this, "_ZN8S27C7_nt4v111Ev");}
void  S27C7_nt ::v112(){vfunc_called(this, "_ZN8S27C7_nt4v112Ev");}
void  S27C7_nt ::v113(){vfunc_called(this, "_ZN8S27C7_nt4v113Ev");}
void  S27C7_nt ::v114(){vfunc_called(this, "_ZN8S27C7_nt4v114Ev");}
void  S27C7_nt ::v115(){vfunc_called(this, "_ZN8S27C7_nt4v115Ev");}
void  S27C7_nt ::v116(){vfunc_called(this, "_ZN8S27C7_nt4v116Ev");}
void  S27C7_nt ::v117(){vfunc_called(this, "_ZN8S27C7_nt4v117Ev");}
void  S27C7_nt ::v118(){vfunc_called(this, "_ZN8S27C7_nt4v118Ev");}
void  S27C7_nt ::v119(){vfunc_called(this, "_ZN8S27C7_nt4v119Ev");}
void  S27C7_nt ::v120(){vfunc_called(this, "_ZN8S27C7_nt4v120Ev");}
void  S27C7_nt ::v121(){vfunc_called(this, "_ZN8S27C7_nt4v121Ev");}
void  S27C7_nt ::v122(){vfunc_called(this, "_ZN8S27C7_nt4v122Ev");}
void  S27C7_nt ::v123(){vfunc_called(this, "_ZN8S27C7_nt4v123Ev");}
void  S27C7_nt ::v124(){vfunc_called(this, "_ZN8S27C7_nt4v124Ev");}
void  S27C7_nt ::v125(){vfunc_called(this, "_ZN8S27C7_nt4v125Ev");}
void  S27C7_nt ::v126(){vfunc_called(this, "_ZN8S27C7_nt4v126Ev");}
void  S27C7_nt ::v127(){vfunc_called(this, "_ZN8S27C7_nt4v127Ev");}
void  S27C7_nt ::v128(){vfunc_called(this, "_ZN8S27C7_nt4v128Ev");}
void  S27C7_nt ::v129(){vfunc_called(this, "_ZN8S27C7_nt4v129Ev");}
void  S27C7_nt ::v130(){vfunc_called(this, "_ZN8S27C7_nt4v130Ev");}
void  S27C7_nt ::v131(){vfunc_called(this, "_ZN8S27C7_nt4v131Ev");}
void  S27C7_nt ::v132(){vfunc_called(this, "_ZN8S27C7_nt4v132Ev");}
void  S27C7_nt ::v133(){vfunc_called(this, "_ZN8S27C7_nt4v133Ev");}
void  S27C7_nt ::v134(){vfunc_called(this, "_ZN8S27C7_nt4v134Ev");}
void  S27C7_nt ::v135(){vfunc_called(this, "_ZN8S27C7_nt4v135Ev");}
void  S27C7_nt ::v136(){vfunc_called(this, "_ZN8S27C7_nt4v136Ev");}
void  S27C7_nt ::v137(){vfunc_called(this, "_ZN8S27C7_nt4v137Ev");}
void  S27C7_nt ::v138(){vfunc_called(this, "_ZN8S27C7_nt4v138Ev");}
void  S27C7_nt ::v139(){vfunc_called(this, "_ZN8S27C7_nt4v139Ev");}
void  S27C7_nt ::v140(){vfunc_called(this, "_ZN8S27C7_nt4v140Ev");}
void  S27C7_nt ::v141(){vfunc_called(this, "_ZN8S27C7_nt4v141Ev");}
void  S27C7_nt ::v142(){vfunc_called(this, "_ZN8S27C7_nt4v142Ev");}
void  S27C7_nt ::v143(){vfunc_called(this, "_ZN8S27C7_nt4v143Ev");}
void  S27C7_nt ::v144(){vfunc_called(this, "_ZN8S27C7_nt4v144Ev");}
void  S27C7_nt ::v145(){vfunc_called(this, "_ZN8S27C7_nt4v145Ev");}
void  S27C7_nt ::v146(){vfunc_called(this, "_ZN8S27C7_nt4v146Ev");}
void  S27C7_nt ::v147(){vfunc_called(this, "_ZN8S27C7_nt4v147Ev");}
void  S27C7_nt ::v148(){vfunc_called(this, "_ZN8S27C7_nt4v148Ev");}
void  S27C7_nt ::v149(){vfunc_called(this, "_ZN8S27C7_nt4v149Ev");}
void  S27C7_nt ::v150(){vfunc_called(this, "_ZN8S27C7_nt4v150Ev");}
void  S27C7_nt ::v151(){vfunc_called(this, "_ZN8S27C7_nt4v151Ev");}
void  S27C7_nt ::v152(){vfunc_called(this, "_ZN8S27C7_nt4v152Ev");}
void  S27C7_nt ::v153(){vfunc_called(this, "_ZN8S27C7_nt4v153Ev");}
void  S27C7_nt ::v154(){vfunc_called(this, "_ZN8S27C7_nt4v154Ev");}
void  S27C7_nt ::v155(){vfunc_called(this, "_ZN8S27C7_nt4v155Ev");}
void  S27C7_nt ::v156(){vfunc_called(this, "_ZN8S27C7_nt4v156Ev");}
void  S27C7_nt ::v157(){vfunc_called(this, "_ZN8S27C7_nt4v157Ev");}
void  S27C7_nt ::v158(){vfunc_called(this, "_ZN8S27C7_nt4v158Ev");}
void  S27C7_nt ::v159(){vfunc_called(this, "_ZN8S27C7_nt4v159Ev");}
void  S27C7_nt ::v160(){vfunc_called(this, "_ZN8S27C7_nt4v160Ev");}
void  S27C7_nt ::v161(){vfunc_called(this, "_ZN8S27C7_nt4v161Ev");}
void  S27C7_nt ::v162(){vfunc_called(this, "_ZN8S27C7_nt4v162Ev");}
void  S27C7_nt ::v163(){vfunc_called(this, "_ZN8S27C7_nt4v163Ev");}
void  S27C7_nt ::v164(){vfunc_called(this, "_ZN8S27C7_nt4v164Ev");}
void  S27C7_nt ::v165(){vfunc_called(this, "_ZN8S27C7_nt4v165Ev");}
void  S27C7_nt ::v166(){vfunc_called(this, "_ZN8S27C7_nt4v166Ev");}
void  S27C7_nt ::v167(){vfunc_called(this, "_ZN8S27C7_nt4v167Ev");}
void  S27C7_nt ::v168(){vfunc_called(this, "_ZN8S27C7_nt4v168Ev");}
void  S27C7_nt ::v169(){vfunc_called(this, "_ZN8S27C7_nt4v169Ev");}
void  S27C7_nt ::v170(){vfunc_called(this, "_ZN8S27C7_nt4v170Ev");}
void  S27C7_nt ::v171(){vfunc_called(this, "_ZN8S27C7_nt4v171Ev");}
void  S27C7_nt ::v172(){vfunc_called(this, "_ZN8S27C7_nt4v172Ev");}
void  S27C7_nt ::v173(){vfunc_called(this, "_ZN8S27C7_nt4v173Ev");}
void  S27C7_nt ::v174(){vfunc_called(this, "_ZN8S27C7_nt4v174Ev");}
void  S27C7_nt ::v175(){vfunc_called(this, "_ZN8S27C7_nt4v175Ev");}
void  S27C7_nt ::v176(){vfunc_called(this, "_ZN8S27C7_nt4v176Ev");}
void  S27C7_nt ::v177(){vfunc_called(this, "_ZN8S27C7_nt4v177Ev");}
void  S27C7_nt ::v178(){vfunc_called(this, "_ZN8S27C7_nt4v178Ev");}
void  S27C7_nt ::v179(){vfunc_called(this, "_ZN8S27C7_nt4v179Ev");}
void  S27C7_nt ::v180(){vfunc_called(this, "_ZN8S27C7_nt4v180Ev");}
void  S27C7_nt ::v181(){vfunc_called(this, "_ZN8S27C7_nt4v181Ev");}
void  S27C7_nt ::v182(){vfunc_called(this, "_ZN8S27C7_nt4v182Ev");}
void  S27C7_nt ::v183(){vfunc_called(this, "_ZN8S27C7_nt4v183Ev");}
void  S27C7_nt ::v184(){vfunc_called(this, "_ZN8S27C7_nt4v184Ev");}
void  S27C7_nt ::v185(){vfunc_called(this, "_ZN8S27C7_nt4v185Ev");}
void  S27C7_nt ::v186(){vfunc_called(this, "_ZN8S27C7_nt4v186Ev");}
void  S27C7_nt ::v187(){vfunc_called(this, "_ZN8S27C7_nt4v187Ev");}
void  S27C7_nt ::v188(){vfunc_called(this, "_ZN8S27C7_nt4v188Ev");}
void  S27C7_nt ::v189(){vfunc_called(this, "_ZN8S27C7_nt4v189Ev");}
void  S27C7_nt ::v190(){vfunc_called(this, "_ZN8S27C7_nt4v190Ev");}
void  S27C7_nt ::v191(){vfunc_called(this, "_ZN8S27C7_nt4v191Ev");}
void  S27C7_nt ::v192(){vfunc_called(this, "_ZN8S27C7_nt4v192Ev");}
void  S27C7_nt ::v193(){vfunc_called(this, "_ZN8S27C7_nt4v193Ev");}
void  S27C7_nt ::v194(){vfunc_called(this, "_ZN8S27C7_nt4v194Ev");}
void  S27C7_nt ::v195(){vfunc_called(this, "_ZN8S27C7_nt4v195Ev");}
void  S27C7_nt ::v196(){vfunc_called(this, "_ZN8S27C7_nt4v196Ev");}
void  S27C7_nt ::v197(){vfunc_called(this, "_ZN8S27C7_nt4v197Ev");}
void  S27C7_nt ::v198(){vfunc_called(this, "_ZN8S27C7_nt4v198Ev");}
void  S27C7_nt ::v199(){vfunc_called(this, "_ZN8S27C7_nt4v199Ev");}
void  S27C7_nt ::v200(){vfunc_called(this, "_ZN8S27C7_nt4v200Ev");}
void  S27C7_nt ::v201(){vfunc_called(this, "_ZN8S27C7_nt4v201Ev");}
void  S27C7_nt ::v202(){vfunc_called(this, "_ZN8S27C7_nt4v202Ev");}
void  S27C7_nt ::v203(){vfunc_called(this, "_ZN8S27C7_nt4v203Ev");}
void  S27C7_nt ::v204(){vfunc_called(this, "_ZN8S27C7_nt4v204Ev");}
void  S27C7_nt ::v205(){vfunc_called(this, "_ZN8S27C7_nt4v205Ev");}
void  S27C7_nt ::v206(){vfunc_called(this, "_ZN8S27C7_nt4v206Ev");}
void  S27C7_nt ::v207(){vfunc_called(this, "_ZN8S27C7_nt4v207Ev");}
void  S27C7_nt ::v208(){vfunc_called(this, "_ZN8S27C7_nt4v208Ev");}
void  S27C7_nt ::v209(){vfunc_called(this, "_ZN8S27C7_nt4v209Ev");}
void  S27C7_nt ::v210(){vfunc_called(this, "_ZN8S27C7_nt4v210Ev");}
S27C7_nt ::S27C7_nt(){ note_ctor("S27C7_nt", this);} // tgen

//skip512 S27C7_nt

#else // __cplusplus

extern void _ZN8S27C7_ntC1Ev();
extern void _ZN8S27C7_ntD1Ev();
Name_Map name_map_S27C7_nt[] = {
  NSPAIR(_ZN8S27C7_ntC1Ev),
  NSPAIR(_ZN8S27C7_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S27C8_nt;
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
static Base_Class bases_S27C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S27C7_nt[];
extern void _ZN8S27C7_ntD1Ev();
extern void _ZN8S27C7_ntD0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
extern void _ZN8S27C7_nt3v68Ev();
extern void _ZN8S27C7_nt3v69Ev();
extern void _ZN8S27C7_nt3v70Ev();
extern void _ZN8S27C7_nt3v71Ev();
extern void _ZN8S27C7_nt3v72Ev();
extern void _ZN8S27C7_nt3v73Ev();
extern void _ZN8S27C7_nt3v74Ev();
extern void _ZN8S27C7_nt3v75Ev();
extern void _ZN8S27C7_nt3v76Ev();
extern void _ZN8S27C7_nt3v77Ev();
extern void _ZN8S27C7_nt3v78Ev();
extern void _ZN8S27C7_nt3v79Ev();
extern void _ZN8S27C7_nt3v80Ev();
extern void _ZN8S27C7_nt3v81Ev();
extern void _ZN8S27C7_nt3v82Ev();
extern void _ZN8S27C7_nt3v83Ev();
extern void _ZN8S27C7_nt3v84Ev();
extern void _ZN8S27C7_nt3v85Ev();
extern void _ZN8S27C7_nt3v86Ev();
extern void _ZN8S27C7_nt3v87Ev();
extern void _ZN8S27C7_nt3v88Ev();
extern void _ZN8S27C7_nt3v89Ev();
extern void _ZN8S27C7_nt3v90Ev();
extern void _ZN8S27C7_nt3v91Ev();
extern void _ZN8S27C7_nt3v92Ev();
extern void _ZN8S27C7_nt3v93Ev();
extern void _ZN8S27C7_nt3v94Ev();
extern void _ZN8S27C7_nt3v95Ev();
extern void _ZN8S27C7_nt3v96Ev();
extern void _ZN8S27C7_nt3v97Ev();
extern void _ZN8S27C7_nt3v98Ev();
extern void _ZN8S27C7_nt3v99Ev();
extern void _ZN8S27C7_nt4v100Ev();
extern void _ZN8S27C7_nt4v101Ev();
extern void _ZN8S27C7_nt4v102Ev();
extern void _ZN8S27C7_nt4v103Ev();
extern void _ZN8S27C7_nt4v104Ev();
extern void _ZN8S27C7_nt4v105Ev();
extern void _ZN8S27C7_nt4v106Ev();
extern void _ZN8S27C7_nt4v107Ev();
extern void _ZN8S27C7_nt4v108Ev();
extern void _ZN8S27C7_nt4v109Ev();
extern void _ZN8S27C7_nt4v110Ev();
extern void _ZN8S27C7_nt4v111Ev();
extern void _ZN8S27C7_nt4v112Ev();
extern void _ZN8S27C7_nt4v113Ev();
extern void _ZN8S27C7_nt4v114Ev();
extern void _ZN8S27C7_nt4v115Ev();
extern void _ZN8S27C7_nt4v116Ev();
extern void _ZN8S27C7_nt4v117Ev();
extern void _ZN8S27C7_nt4v118Ev();
extern void _ZN8S27C7_nt4v119Ev();
extern void _ZN8S27C7_nt4v120Ev();
extern void _ZN8S27C7_nt4v121Ev();
extern void _ZN8S27C7_nt4v122Ev();
extern void _ZN8S27C7_nt4v123Ev();
extern void _ZN8S27C7_nt4v124Ev();
extern void _ZN8S27C7_nt4v125Ev();
extern void _ZN8S27C7_nt4v126Ev();
extern void _ZN8S27C7_nt4v127Ev();
extern void _ZN8S27C7_nt4v128Ev();
extern void _ZN8S27C7_nt4v129Ev();
extern void _ZN8S27C7_nt4v130Ev();
extern void _ZN8S27C7_nt4v131Ev();
extern void _ZN8S27C7_nt4v132Ev();
extern void _ZN8S27C7_nt4v133Ev();
extern void _ZN8S27C7_nt4v134Ev();
extern void _ZN8S27C7_nt4v135Ev();
extern void _ZN8S27C7_nt4v136Ev();
extern void _ZN8S27C7_nt4v137Ev();
extern void _ZN8S27C7_nt4v138Ev();
extern void _ZN8S27C7_nt4v139Ev();
extern void _ZN8S27C7_nt4v140Ev();
extern void _ZN8S27C7_nt4v141Ev();
extern void _ZN8S27C7_nt4v142Ev();
extern void _ZN8S27C7_nt4v143Ev();
extern void _ZN8S27C7_nt4v144Ev();
extern void _ZN8S27C7_nt4v145Ev();
extern void _ZN8S27C7_nt4v146Ev();
extern void _ZN8S27C7_nt4v147Ev();
extern void _ZN8S27C7_nt4v148Ev();
extern void _ZN8S27C7_nt4v149Ev();
extern void _ZN8S27C7_nt4v150Ev();
extern void _ZN8S27C7_nt4v151Ev();
extern void _ZN8S27C7_nt4v152Ev();
extern void _ZN8S27C7_nt4v153Ev();
extern void _ZN8S27C7_nt4v154Ev();
extern void _ZN8S27C7_nt4v155Ev();
extern void _ZN8S27C7_nt4v156Ev();
extern void _ZN8S27C7_nt4v157Ev();
extern void _ZN8S27C7_nt4v158Ev();
extern void _ZN8S27C7_nt4v159Ev();
extern void _ZN8S27C7_nt4v160Ev();
extern void _ZN8S27C7_nt4v161Ev();
extern void _ZN8S27C7_nt4v162Ev();
extern void _ZN8S27C7_nt4v163Ev();
extern void _ZN8S27C7_nt4v164Ev();
extern void _ZN8S27C7_nt4v165Ev();
extern void _ZN8S27C7_nt4v166Ev();
extern void _ZN8S27C7_nt4v167Ev();
extern void _ZN8S27C7_nt4v168Ev();
extern void _ZN8S27C7_nt4v169Ev();
extern void _ZN8S27C7_nt4v170Ev();
extern void _ZN8S27C7_nt4v171Ev();
extern void _ZN8S27C7_nt4v172Ev();
extern void _ZN8S27C7_nt4v173Ev();
extern void _ZN8S27C7_nt4v174Ev();
extern void _ZN8S27C7_nt4v175Ev();
extern void _ZN8S27C7_nt4v176Ev();
extern void _ZN8S27C7_nt4v177Ev();
extern void _ZN8S27C7_nt4v178Ev();
extern void _ZN8S27C7_nt4v179Ev();
extern void _ZN8S27C7_nt4v180Ev();
extern void _ZN8S27C7_nt4v181Ev();
extern void _ZN8S27C7_nt4v182Ev();
extern void _ZN8S27C7_nt4v183Ev();
extern void _ZN8S27C7_nt4v184Ev();
extern void _ZN8S27C7_nt4v185Ev();
extern void _ZN8S27C7_nt4v186Ev();
extern void _ZN8S27C7_nt4v187Ev();
extern void _ZN8S27C7_nt4v188Ev();
extern void _ZN8S27C7_nt4v189Ev();
extern void _ZN8S27C7_nt4v190Ev();
extern void _ZN8S27C7_nt4v191Ev();
extern void _ZN8S27C7_nt4v192Ev();
extern void _ZN8S27C7_nt4v193Ev();
extern void _ZN8S27C7_nt4v194Ev();
extern void _ZN8S27C7_nt4v195Ev();
extern void _ZN8S27C7_nt4v196Ev();
extern void _ZN8S27C7_nt4v197Ev();
extern void _ZN8S27C7_nt4v198Ev();
extern void _ZN8S27C7_nt4v199Ev();
extern void _ZN8S27C7_nt4v200Ev();
extern void _ZN8S27C7_nt4v201Ev();
extern void _ZN8S27C7_nt4v202Ev();
extern void _ZN8S27C7_nt4v203Ev();
extern void _ZN8S27C7_nt4v204Ev();
extern void _ZN8S27C7_nt4v205Ev();
extern void _ZN8S27C7_nt4v206Ev();
extern void _ZN8S27C7_nt4v207Ev();
extern void _ZN8S27C7_nt4v208Ev();
extern void _ZN8S27C7_nt4v209Ev();
extern void _ZN8S27C7_nt4v210Ev();
static  VTBL_ENTRY vtc_S27C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S27C7_nt[0]),
  (VTBL_ENTRY)&_ZN8S27C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S27C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v210Ev,
};
extern VTBL_ENTRY _ZTI8S27C7_nt[];
VTBL_ENTRY *P__ZTI8S27C7_nt = _ZTI8S27C7_nt; 
extern  VTBL_ENTRY _ZTV8S27C7_nt[];
Class_Descriptor cd_S27C7_nt = {  "S27C7_nt", // class name
  bases_S27C7_nt, 1,
  &(vtc_S27C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI8S27C7_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S27C7_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C28  : S27C12_nt {
};
//SIG(-1 S27C28) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C28()
{
  extern Class_Descriptor cd_S27C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C28, buf);
    S27C28 &lv = *(new (buf) S27C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C28)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C28");
    test_class_info(&lv, &cd_S27C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C28(Test_S27C28, "S27C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C28 = {  "S27C28", // class name
  bases_S27C28, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C27  : S27C28 {
};
//SIG(-1 S27C27) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C27()
{
  extern Class_Descriptor cd_S27C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C27, buf);
    S27C27 &lv = *(new (buf) S27C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C27)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C28*), 0, "S27C27");
    check_base_class_offset(lv, (S27C28*), 0, "S27C27");
    test_class_info(&lv, &cd_S27C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C27(Test_S27C27, "S27C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C28;
static Base_Class bases_S27C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C27 = {  "S27C27", // class name
  bases_S27C27, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C26_nt  : S27C27 {
};
//SIG(-1 S27C26_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S27C26_nt

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C28;
extern Class_Descriptor cd_S27C27;
static Base_Class bases_S27C26_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S27C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C6_nt  : S27C7_nt {
  int s27c6f0[3];
  void *s27c6f1[2];
  int s27c6f2;
  void *s27c6f3[2];
  unsigned int s27c6f4:1;
  unsigned int s27c6f5:1;
  unsigned int s27c6f6:1;
  unsigned int s27c6f7:1;
  unsigned int s27c6f8:1;
  unsigned int s27c6f9:1;
  unsigned int s27c6f10:1;
  unsigned int s27c6f11:1;
  unsigned int s27c6f12:1;
  unsigned int s27c6f13:1;
  unsigned int s27c6f14:1;
  unsigned int s27c6f15:1;
  unsigned int s27c6f16:1;
  unsigned int s27c6f17:1;
  unsigned int s27c6f18:1;
  unsigned int s27c6f19:1;
  unsigned int s27c6f20:1;
  unsigned int s27c6f21:1;
  unsigned int s27c6f22:1;
  unsigned int s27c6f23:1;
  unsigned int s27c6f24:1;
  unsigned int s27c6f25:1;
  unsigned int s27c6f26:1;
  unsigned int s27c6f27:1;
  unsigned int s27c6f28:1;
  unsigned int s27c6f29:1;
  unsigned int s27c6f30:1;
  unsigned int s27c6f31:1;
  unsigned int s27c6f32:1;
  unsigned int s27c6f33:1;
  unsigned int s27c6f34:1;
  unsigned int s27c6f35:1;
  unsigned int s27c6f36:1;
  unsigned int s27c6f37:1;
  unsigned int s27c6f38:1;
  unsigned int s27c6f39:1;
  unsigned int s27c6f40:1;
  unsigned int s27c6f41:1;
  unsigned int s27c6f42:1;
  unsigned int s27c6f43:1;
  unsigned int s27c6f44:1;
  unsigned int s27c6f45:1;
  unsigned int s27c6f46:1;
  unsigned int s27c6f47:1;
  unsigned int s27c6f48:1;
  unsigned int s27c6f49:1;
  unsigned int s27c6f50:1;
  unsigned int s27c6f51:1;
  unsigned int s27c6f52:1;
  unsigned int s27c6f53:1;
  int s27c6f54[5];
  char s27c6f55[4];
  int s27c6f56[10];
  void *s27c6f57[2];
  int s27c6f58[4];
  ::S27C18_nt s27c6f59;
  int s27c6f60[19];
  ::S27C18_nt s27c6f61;
  int s27c6f62[2];
  void *s27c6f63;
  int s27c6f64[5];
  ::S27C18_nt s27c6f65;
  ::S27C18_nt s27c6f66;
  int s27c6f67;
  void *s27c6f68;
  int s27c6f69;
  ::S27C18_nt s27c6f70;
  int s27c6f71;
  void *s27c6f72;
  int s27c6f73[3];
  ::S27C26_nt s27c6f74;
  void *s27c6f75[3];
  ::S27C9_nt s27c6f76;
  ::S27C9_nt s27c6f77;
  void *s27c6f78;
  int s27c6f79;
  ::S27C18_nt s27c6f80;
  void *s27c6f81;
  ::S27C18_nt s27c6f82;
  void *s27c6f83[2];
  int s27c6f84[2];
  void *s27c6f85;
  int s27c6f86[2];
  void *s27c6f87;
  int s27c6f88[3];
  void *s27c6f89[3];
  ::S27C18_nt s27c6f90;
  ::S27C18_nt s27c6f91;
  int s27c6f92;
  void *s27c6f93[2];
  int s27c6f94;
  virtual  ~S27C6_nt(); // _ZN8S27C6_ntD1Ev
  virtual void  v211(); // _ZN8S27C6_nt4v211Ev
  virtual void  v212(); // _ZN8S27C6_nt4v212Ev
  virtual void  v213(); // _ZN8S27C6_nt4v213Ev
  virtual void  v214(); // _ZN8S27C6_nt4v214Ev
  virtual void  v215(); // _ZN8S27C6_nt4v215Ev
  virtual void  v216(); // _ZN8S27C6_nt4v216Ev
  virtual void  v217(); // _ZN8S27C6_nt4v217Ev
  virtual void  v218(); // _ZN8S27C6_nt4v218Ev
  virtual void  v219(); // _ZN8S27C6_nt4v219Ev
  virtual void  v220(); // _ZN8S27C6_nt4v220Ev
  virtual void  v221(); // _ZN8S27C6_nt4v221Ev
  virtual void  v222(); // _ZN8S27C6_nt4v222Ev
  virtual void  v223(); // _ZN8S27C6_nt4v223Ev
  virtual void  v224(); // _ZN8S27C6_nt4v224Ev
  virtual void  v225(); // _ZN8S27C6_nt4v225Ev
  virtual void  v226(); // _ZN8S27C6_nt4v226Ev
  virtual void  v227(); // _ZN8S27C6_nt4v227Ev
  virtual void  v228(); // _ZN8S27C6_nt4v228Ev
  virtual void  v229(); // _ZN8S27C6_nt4v229Ev
  virtual void  v230(); // _ZN8S27C6_nt4v230Ev
  virtual void  v231(); // _ZN8S27C6_nt4v231Ev
  virtual void  v232(); // _ZN8S27C6_nt4v232Ev
  virtual void  v233(); // _ZN8S27C6_nt4v233Ev
  virtual void  v234(); // _ZN8S27C6_nt4v234Ev
  virtual void  v235(); // _ZN8S27C6_nt4v235Ev
  virtual void  v236(); // _ZN8S27C6_nt4v236Ev
  virtual void  v237(); // _ZN8S27C6_nt4v237Ev
  virtual void  v238(); // _ZN8S27C6_nt4v238Ev
  virtual void  v239(); // _ZN8S27C6_nt4v239Ev
  virtual void  v240(); // _ZN8S27C6_nt4v240Ev
  virtual void  v241(); // _ZN8S27C6_nt4v241Ev
  virtual void  v242(); // _ZN8S27C6_nt4v242Ev
  virtual void  v243(); // _ZN8S27C6_nt4v243Ev
  virtual void  v244(); // _ZN8S27C6_nt4v244Ev
  virtual void  v245(); // _ZN8S27C6_nt4v245Ev
  virtual void  v246(); // _ZN8S27C6_nt4v246Ev
  virtual void  v247(); // _ZN8S27C6_nt4v247Ev
  virtual void  v248(); // _ZN8S27C6_nt4v248Ev
  virtual void  v249(); // _ZN8S27C6_nt4v249Ev
  virtual void  v250(); // _ZN8S27C6_nt4v250Ev
  virtual void  v251(); // _ZN8S27C6_nt4v251Ev
  virtual void  v252(); // _ZN8S27C6_nt4v252Ev
  virtual void  v253(); // _ZN8S27C6_nt4v253Ev
  virtual void  v254(); // _ZN8S27C6_nt4v254Ev
  virtual void  v255(); // _ZN8S27C6_nt4v255Ev
  virtual void  v256(); // _ZN8S27C6_nt4v256Ev
  virtual void  v257(); // _ZN8S27C6_nt4v257Ev
  virtual void  v258(); // _ZN8S27C6_nt4v258Ev
  virtual void  v259(); // _ZN8S27C6_nt4v259Ev
  virtual void  v260(); // _ZN8S27C6_nt4v260Ev
  virtual void  v261(); // _ZN8S27C6_nt4v261Ev
  virtual void  v262(); // _ZN8S27C6_nt4v262Ev
  virtual void  v263(); // _ZN8S27C6_nt4v263Ev
  virtual void  v264(); // _ZN8S27C6_nt4v264Ev
  virtual void  v265(); // _ZN8S27C6_nt4v265Ev
  virtual void  v266(); // _ZN8S27C6_nt4v266Ev
  virtual void  v267(); // _ZN8S27C6_nt4v267Ev
  virtual void  v268(); // _ZN8S27C6_nt4v268Ev
  virtual void  v269(); // _ZN8S27C6_nt4v269Ev
  virtual void  v270(); // _ZN8S27C6_nt4v270Ev
  virtual void  v271(); // _ZN8S27C6_nt4v271Ev
  virtual void  v272(); // _ZN8S27C6_nt4v272Ev
  virtual void  v273(); // _ZN8S27C6_nt4v273Ev
  virtual void  v274(); // _ZN8S27C6_nt4v274Ev
  virtual void  v275(); // _ZN8S27C6_nt4v275Ev
  virtual void  v276(); // _ZN8S27C6_nt4v276Ev
  virtual void  v277(); // _ZN8S27C6_nt4v277Ev
  virtual void  v278(); // _ZN8S27C6_nt4v278Ev
  virtual void  v279(); // _ZN8S27C6_nt4v279Ev
  virtual void  v280(); // _ZN8S27C6_nt4v280Ev
  virtual void  v281(); // _ZN8S27C6_nt4v281Ev
  virtual void  v282(); // _ZN8S27C6_nt4v282Ev
  virtual void  v283(); // _ZN8S27C6_nt4v283Ev
  virtual void  v284(); // _ZN8S27C6_nt4v284Ev
  virtual void  v285(); // _ZN8S27C6_nt4v285Ev
  virtual void  v286(); // _ZN8S27C6_nt4v286Ev
  virtual void  v287(); // _ZN8S27C6_nt4v287Ev
  virtual void  v288(); // _ZN8S27C6_nt4v288Ev
  virtual void  v289(); // _ZN8S27C6_nt4v289Ev
  virtual void  v290(); // _ZN8S27C6_nt4v290Ev
  virtual void  v291(); // _ZN8S27C6_nt4v291Ev
  virtual void  v292(); // _ZN8S27C6_nt4v292Ev
  virtual void  v293(); // _ZN8S27C6_nt4v293Ev
  virtual void  v294(); // _ZN8S27C6_nt4v294Ev
  virtual void  v295(); // _ZN8S27C6_nt4v295Ev
  virtual void  v296(); // _ZN8S27C6_nt4v296Ev
  virtual void  v297(); // _ZN8S27C6_nt4v297Ev
  virtual void  v298(); // _ZN8S27C6_nt4v298Ev
  virtual void  v299(); // _ZN8S27C6_nt4v299Ev
  virtual void  v300(); // _ZN8S27C6_nt4v300Ev
  virtual void  v301(); // _ZN8S27C6_nt4v301Ev
  virtual void  v302(); // _ZN8S27C6_nt4v302Ev
  virtual void  v303(); // _ZN8S27C6_nt4v303Ev
  virtual void  v304(); // _ZN8S27C6_nt4v304Ev
  virtual void  v305(); // _ZN8S27C6_nt4v305Ev
  virtual void  v306(); // _ZN8S27C6_nt4v306Ev
  virtual void  v307(); // _ZN8S27C6_nt4v307Ev
  virtual void  v308(); // _ZN8S27C6_nt4v308Ev
  S27C6_nt(); // tgen
};
//SIG(-1 S27C6_nt) C1{ BC2{ BC3{ vd v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC11 Fi[19] FC11 Fi[2] Fp Fi[5] FC11 FC11 Fi Fp Fi FC11 Fi Fp Fi[3] FC14{ BC15{ BC16{ BC7}}} Fp[3] FC4 FC4 Fp Fi FC11 Fp FC11 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC11 FC11 Fi Fp[2] Fi}


 S27C6_nt ::~S27C6_nt(){ note_dtor("S27C6_nt", this);}
void  S27C6_nt ::v211(){vfunc_called(this, "_ZN8S27C6_nt4v211Ev");}
void  S27C6_nt ::v212(){vfunc_called(this, "_ZN8S27C6_nt4v212Ev");}
void  S27C6_nt ::v213(){vfunc_called(this, "_ZN8S27C6_nt4v213Ev");}
void  S27C6_nt ::v214(){vfunc_called(this, "_ZN8S27C6_nt4v214Ev");}
void  S27C6_nt ::v215(){vfunc_called(this, "_ZN8S27C6_nt4v215Ev");}
void  S27C6_nt ::v216(){vfunc_called(this, "_ZN8S27C6_nt4v216Ev");}
void  S27C6_nt ::v217(){vfunc_called(this, "_ZN8S27C6_nt4v217Ev");}
void  S27C6_nt ::v218(){vfunc_called(this, "_ZN8S27C6_nt4v218Ev");}
void  S27C6_nt ::v219(){vfunc_called(this, "_ZN8S27C6_nt4v219Ev");}
void  S27C6_nt ::v220(){vfunc_called(this, "_ZN8S27C6_nt4v220Ev");}
void  S27C6_nt ::v221(){vfunc_called(this, "_ZN8S27C6_nt4v221Ev");}
void  S27C6_nt ::v222(){vfunc_called(this, "_ZN8S27C6_nt4v222Ev");}
void  S27C6_nt ::v223(){vfunc_called(this, "_ZN8S27C6_nt4v223Ev");}
void  S27C6_nt ::v224(){vfunc_called(this, "_ZN8S27C6_nt4v224Ev");}
void  S27C6_nt ::v225(){vfunc_called(this, "_ZN8S27C6_nt4v225Ev");}
void  S27C6_nt ::v226(){vfunc_called(this, "_ZN8S27C6_nt4v226Ev");}
void  S27C6_nt ::v227(){vfunc_called(this, "_ZN8S27C6_nt4v227Ev");}
void  S27C6_nt ::v228(){vfunc_called(this, "_ZN8S27C6_nt4v228Ev");}
void  S27C6_nt ::v229(){vfunc_called(this, "_ZN8S27C6_nt4v229Ev");}
void  S27C6_nt ::v230(){vfunc_called(this, "_ZN8S27C6_nt4v230Ev");}
void  S27C6_nt ::v231(){vfunc_called(this, "_ZN8S27C6_nt4v231Ev");}
void  S27C6_nt ::v232(){vfunc_called(this, "_ZN8S27C6_nt4v232Ev");}
void  S27C6_nt ::v233(){vfunc_called(this, "_ZN8S27C6_nt4v233Ev");}
void  S27C6_nt ::v234(){vfunc_called(this, "_ZN8S27C6_nt4v234Ev");}
void  S27C6_nt ::v235(){vfunc_called(this, "_ZN8S27C6_nt4v235Ev");}
void  S27C6_nt ::v236(){vfunc_called(this, "_ZN8S27C6_nt4v236Ev");}
void  S27C6_nt ::v237(){vfunc_called(this, "_ZN8S27C6_nt4v237Ev");}
void  S27C6_nt ::v238(){vfunc_called(this, "_ZN8S27C6_nt4v238Ev");}
void  S27C6_nt ::v239(){vfunc_called(this, "_ZN8S27C6_nt4v239Ev");}
void  S27C6_nt ::v240(){vfunc_called(this, "_ZN8S27C6_nt4v240Ev");}
void  S27C6_nt ::v241(){vfunc_called(this, "_ZN8S27C6_nt4v241Ev");}
void  S27C6_nt ::v242(){vfunc_called(this, "_ZN8S27C6_nt4v242Ev");}
void  S27C6_nt ::v243(){vfunc_called(this, "_ZN8S27C6_nt4v243Ev");}
void  S27C6_nt ::v244(){vfunc_called(this, "_ZN8S27C6_nt4v244Ev");}
void  S27C6_nt ::v245(){vfunc_called(this, "_ZN8S27C6_nt4v245Ev");}
void  S27C6_nt ::v246(){vfunc_called(this, "_ZN8S27C6_nt4v246Ev");}
void  S27C6_nt ::v247(){vfunc_called(this, "_ZN8S27C6_nt4v247Ev");}
void  S27C6_nt ::v248(){vfunc_called(this, "_ZN8S27C6_nt4v248Ev");}
void  S27C6_nt ::v249(){vfunc_called(this, "_ZN8S27C6_nt4v249Ev");}
void  S27C6_nt ::v250(){vfunc_called(this, "_ZN8S27C6_nt4v250Ev");}
void  S27C6_nt ::v251(){vfunc_called(this, "_ZN8S27C6_nt4v251Ev");}
void  S27C6_nt ::v252(){vfunc_called(this, "_ZN8S27C6_nt4v252Ev");}
void  S27C6_nt ::v253(){vfunc_called(this, "_ZN8S27C6_nt4v253Ev");}
void  S27C6_nt ::v254(){vfunc_called(this, "_ZN8S27C6_nt4v254Ev");}
void  S27C6_nt ::v255(){vfunc_called(this, "_ZN8S27C6_nt4v255Ev");}
void  S27C6_nt ::v256(){vfunc_called(this, "_ZN8S27C6_nt4v256Ev");}
void  S27C6_nt ::v257(){vfunc_called(this, "_ZN8S27C6_nt4v257Ev");}
void  S27C6_nt ::v258(){vfunc_called(this, "_ZN8S27C6_nt4v258Ev");}
void  S27C6_nt ::v259(){vfunc_called(this, "_ZN8S27C6_nt4v259Ev");}
void  S27C6_nt ::v260(){vfunc_called(this, "_ZN8S27C6_nt4v260Ev");}
void  S27C6_nt ::v261(){vfunc_called(this, "_ZN8S27C6_nt4v261Ev");}
void  S27C6_nt ::v262(){vfunc_called(this, "_ZN8S27C6_nt4v262Ev");}
void  S27C6_nt ::v263(){vfunc_called(this, "_ZN8S27C6_nt4v263Ev");}
void  S27C6_nt ::v264(){vfunc_called(this, "_ZN8S27C6_nt4v264Ev");}
void  S27C6_nt ::v265(){vfunc_called(this, "_ZN8S27C6_nt4v265Ev");}
void  S27C6_nt ::v266(){vfunc_called(this, "_ZN8S27C6_nt4v266Ev");}
void  S27C6_nt ::v267(){vfunc_called(this, "_ZN8S27C6_nt4v267Ev");}
void  S27C6_nt ::v268(){vfunc_called(this, "_ZN8S27C6_nt4v268Ev");}
void  S27C6_nt ::v269(){vfunc_called(this, "_ZN8S27C6_nt4v269Ev");}
void  S27C6_nt ::v270(){vfunc_called(this, "_ZN8S27C6_nt4v270Ev");}
void  S27C6_nt ::v271(){vfunc_called(this, "_ZN8S27C6_nt4v271Ev");}
void  S27C6_nt ::v272(){vfunc_called(this, "_ZN8S27C6_nt4v272Ev");}
void  S27C6_nt ::v273(){vfunc_called(this, "_ZN8S27C6_nt4v273Ev");}
void  S27C6_nt ::v274(){vfunc_called(this, "_ZN8S27C6_nt4v274Ev");}
void  S27C6_nt ::v275(){vfunc_called(this, "_ZN8S27C6_nt4v275Ev");}
void  S27C6_nt ::v276(){vfunc_called(this, "_ZN8S27C6_nt4v276Ev");}
void  S27C6_nt ::v277(){vfunc_called(this, "_ZN8S27C6_nt4v277Ev");}
void  S27C6_nt ::v278(){vfunc_called(this, "_ZN8S27C6_nt4v278Ev");}
void  S27C6_nt ::v279(){vfunc_called(this, "_ZN8S27C6_nt4v279Ev");}
void  S27C6_nt ::v280(){vfunc_called(this, "_ZN8S27C6_nt4v280Ev");}
void  S27C6_nt ::v281(){vfunc_called(this, "_ZN8S27C6_nt4v281Ev");}
void  S27C6_nt ::v282(){vfunc_called(this, "_ZN8S27C6_nt4v282Ev");}
void  S27C6_nt ::v283(){vfunc_called(this, "_ZN8S27C6_nt4v283Ev");}
void  S27C6_nt ::v284(){vfunc_called(this, "_ZN8S27C6_nt4v284Ev");}
void  S27C6_nt ::v285(){vfunc_called(this, "_ZN8S27C6_nt4v285Ev");}
void  S27C6_nt ::v286(){vfunc_called(this, "_ZN8S27C6_nt4v286Ev");}
void  S27C6_nt ::v287(){vfunc_called(this, "_ZN8S27C6_nt4v287Ev");}
void  S27C6_nt ::v288(){vfunc_called(this, "_ZN8S27C6_nt4v288Ev");}
void  S27C6_nt ::v289(){vfunc_called(this, "_ZN8S27C6_nt4v289Ev");}
void  S27C6_nt ::v290(){vfunc_called(this, "_ZN8S27C6_nt4v290Ev");}
void  S27C6_nt ::v291(){vfunc_called(this, "_ZN8S27C6_nt4v291Ev");}
void  S27C6_nt ::v292(){vfunc_called(this, "_ZN8S27C6_nt4v292Ev");}
void  S27C6_nt ::v293(){vfunc_called(this, "_ZN8S27C6_nt4v293Ev");}
void  S27C6_nt ::v294(){vfunc_called(this, "_ZN8S27C6_nt4v294Ev");}
void  S27C6_nt ::v295(){vfunc_called(this, "_ZN8S27C6_nt4v295Ev");}
void  S27C6_nt ::v296(){vfunc_called(this, "_ZN8S27C6_nt4v296Ev");}
void  S27C6_nt ::v297(){vfunc_called(this, "_ZN8S27C6_nt4v297Ev");}
void  S27C6_nt ::v298(){vfunc_called(this, "_ZN8S27C6_nt4v298Ev");}
void  S27C6_nt ::v299(){vfunc_called(this, "_ZN8S27C6_nt4v299Ev");}
void  S27C6_nt ::v300(){vfunc_called(this, "_ZN8S27C6_nt4v300Ev");}
void  S27C6_nt ::v301(){vfunc_called(this, "_ZN8S27C6_nt4v301Ev");}
void  S27C6_nt ::v302(){vfunc_called(this, "_ZN8S27C6_nt4v302Ev");}
void  S27C6_nt ::v303(){vfunc_called(this, "_ZN8S27C6_nt4v303Ev");}
void  S27C6_nt ::v304(){vfunc_called(this, "_ZN8S27C6_nt4v304Ev");}
void  S27C6_nt ::v305(){vfunc_called(this, "_ZN8S27C6_nt4v305Ev");}
void  S27C6_nt ::v306(){vfunc_called(this, "_ZN8S27C6_nt4v306Ev");}
void  S27C6_nt ::v307(){vfunc_called(this, "_ZN8S27C6_nt4v307Ev");}
void  S27C6_nt ::v308(){vfunc_called(this, "_ZN8S27C6_nt4v308Ev");}
S27C6_nt ::S27C6_nt(){ note_ctor("S27C6_nt", this);} // tgen

//skip512 S27C6_nt

#else // __cplusplus

extern void _ZN8S27C6_ntC1Ev();
extern void _ZN8S27C6_ntD1Ev();
Name_Map name_map_S27C6_nt[] = {
  NSPAIR(_ZN8S27C6_ntC1Ev),
  NSPAIR(_ZN8S27C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S27C8_nt;
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
extern Class_Descriptor cd_S27C7_nt;
extern VTBL_ENTRY _ZTI8S27C7_nt[];
extern  VTBL_ENTRY _ZTV8S27C7_nt[];
static Base_Class bases_S27C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S27C6_nt[];
extern void _ZN8S27C6_ntD1Ev();
extern void _ZN8S27C6_ntD0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
extern void _ZN8S27C7_nt3v68Ev();
extern void _ZN8S27C7_nt3v69Ev();
extern void _ZN8S27C7_nt3v70Ev();
extern void _ZN8S27C7_nt3v71Ev();
extern void _ZN8S27C7_nt3v72Ev();
extern void _ZN8S27C7_nt3v73Ev();
extern void _ZN8S27C7_nt3v74Ev();
extern void _ZN8S27C7_nt3v75Ev();
extern void _ZN8S27C7_nt3v76Ev();
extern void _ZN8S27C7_nt3v77Ev();
extern void _ZN8S27C7_nt3v78Ev();
extern void _ZN8S27C7_nt3v79Ev();
extern void _ZN8S27C7_nt3v80Ev();
extern void _ZN8S27C7_nt3v81Ev();
extern void _ZN8S27C7_nt3v82Ev();
extern void _ZN8S27C7_nt3v83Ev();
extern void _ZN8S27C7_nt3v84Ev();
extern void _ZN8S27C7_nt3v85Ev();
extern void _ZN8S27C7_nt3v86Ev();
extern void _ZN8S27C7_nt3v87Ev();
extern void _ZN8S27C7_nt3v88Ev();
extern void _ZN8S27C7_nt3v89Ev();
extern void _ZN8S27C7_nt3v90Ev();
extern void _ZN8S27C7_nt3v91Ev();
extern void _ZN8S27C7_nt3v92Ev();
extern void _ZN8S27C7_nt3v93Ev();
extern void _ZN8S27C7_nt3v94Ev();
extern void _ZN8S27C7_nt3v95Ev();
extern void _ZN8S27C7_nt3v96Ev();
extern void _ZN8S27C7_nt3v97Ev();
extern void _ZN8S27C7_nt3v98Ev();
extern void _ZN8S27C7_nt3v99Ev();
extern void _ZN8S27C7_nt4v100Ev();
extern void _ZN8S27C7_nt4v101Ev();
extern void _ZN8S27C7_nt4v102Ev();
extern void _ZN8S27C7_nt4v103Ev();
extern void _ZN8S27C7_nt4v104Ev();
extern void _ZN8S27C7_nt4v105Ev();
extern void _ZN8S27C7_nt4v106Ev();
extern void _ZN8S27C7_nt4v107Ev();
extern void _ZN8S27C7_nt4v108Ev();
extern void _ZN8S27C7_nt4v109Ev();
extern void _ZN8S27C7_nt4v110Ev();
extern void _ZN8S27C7_nt4v111Ev();
extern void _ZN8S27C7_nt4v112Ev();
extern void _ZN8S27C7_nt4v113Ev();
extern void _ZN8S27C7_nt4v114Ev();
extern void _ZN8S27C7_nt4v115Ev();
extern void _ZN8S27C7_nt4v116Ev();
extern void _ZN8S27C7_nt4v117Ev();
extern void _ZN8S27C7_nt4v118Ev();
extern void _ZN8S27C7_nt4v119Ev();
extern void _ZN8S27C7_nt4v120Ev();
extern void _ZN8S27C7_nt4v121Ev();
extern void _ZN8S27C7_nt4v122Ev();
extern void _ZN8S27C7_nt4v123Ev();
extern void _ZN8S27C7_nt4v124Ev();
extern void _ZN8S27C7_nt4v125Ev();
extern void _ZN8S27C7_nt4v126Ev();
extern void _ZN8S27C7_nt4v127Ev();
extern void _ZN8S27C7_nt4v128Ev();
extern void _ZN8S27C7_nt4v129Ev();
extern void _ZN8S27C7_nt4v130Ev();
extern void _ZN8S27C7_nt4v131Ev();
extern void _ZN8S27C7_nt4v132Ev();
extern void _ZN8S27C7_nt4v133Ev();
extern void _ZN8S27C7_nt4v134Ev();
extern void _ZN8S27C7_nt4v135Ev();
extern void _ZN8S27C7_nt4v136Ev();
extern void _ZN8S27C7_nt4v137Ev();
extern void _ZN8S27C7_nt4v138Ev();
extern void _ZN8S27C7_nt4v139Ev();
extern void _ZN8S27C7_nt4v140Ev();
extern void _ZN8S27C7_nt4v141Ev();
extern void _ZN8S27C7_nt4v142Ev();
extern void _ZN8S27C7_nt4v143Ev();
extern void _ZN8S27C7_nt4v144Ev();
extern void _ZN8S27C7_nt4v145Ev();
extern void _ZN8S27C7_nt4v146Ev();
extern void _ZN8S27C7_nt4v147Ev();
extern void _ZN8S27C7_nt4v148Ev();
extern void _ZN8S27C7_nt4v149Ev();
extern void _ZN8S27C7_nt4v150Ev();
extern void _ZN8S27C7_nt4v151Ev();
extern void _ZN8S27C7_nt4v152Ev();
extern void _ZN8S27C7_nt4v153Ev();
extern void _ZN8S27C7_nt4v154Ev();
extern void _ZN8S27C7_nt4v155Ev();
extern void _ZN8S27C7_nt4v156Ev();
extern void _ZN8S27C7_nt4v157Ev();
extern void _ZN8S27C7_nt4v158Ev();
extern void _ZN8S27C7_nt4v159Ev();
extern void _ZN8S27C7_nt4v160Ev();
extern void _ZN8S27C7_nt4v161Ev();
extern void _ZN8S27C7_nt4v162Ev();
extern void _ZN8S27C7_nt4v163Ev();
extern void _ZN8S27C7_nt4v164Ev();
extern void _ZN8S27C7_nt4v165Ev();
extern void _ZN8S27C7_nt4v166Ev();
extern void _ZN8S27C7_nt4v167Ev();
extern void _ZN8S27C7_nt4v168Ev();
extern void _ZN8S27C7_nt4v169Ev();
extern void _ZN8S27C7_nt4v170Ev();
extern void _ZN8S27C7_nt4v171Ev();
extern void _ZN8S27C7_nt4v172Ev();
extern void _ZN8S27C7_nt4v173Ev();
extern void _ZN8S27C7_nt4v174Ev();
extern void _ZN8S27C7_nt4v175Ev();
extern void _ZN8S27C7_nt4v176Ev();
extern void _ZN8S27C7_nt4v177Ev();
extern void _ZN8S27C7_nt4v178Ev();
extern void _ZN8S27C7_nt4v179Ev();
extern void _ZN8S27C7_nt4v180Ev();
extern void _ZN8S27C7_nt4v181Ev();
extern void _ZN8S27C7_nt4v182Ev();
extern void _ZN8S27C7_nt4v183Ev();
extern void _ZN8S27C7_nt4v184Ev();
extern void _ZN8S27C7_nt4v185Ev();
extern void _ZN8S27C7_nt4v186Ev();
extern void _ZN8S27C7_nt4v187Ev();
extern void _ZN8S27C7_nt4v188Ev();
extern void _ZN8S27C7_nt4v189Ev();
extern void _ZN8S27C7_nt4v190Ev();
extern void _ZN8S27C7_nt4v191Ev();
extern void _ZN8S27C7_nt4v192Ev();
extern void _ZN8S27C7_nt4v193Ev();
extern void _ZN8S27C7_nt4v194Ev();
extern void _ZN8S27C7_nt4v195Ev();
extern void _ZN8S27C7_nt4v196Ev();
extern void _ZN8S27C7_nt4v197Ev();
extern void _ZN8S27C7_nt4v198Ev();
extern void _ZN8S27C7_nt4v199Ev();
extern void _ZN8S27C7_nt4v200Ev();
extern void _ZN8S27C7_nt4v201Ev();
extern void _ZN8S27C7_nt4v202Ev();
extern void _ZN8S27C7_nt4v203Ev();
extern void _ZN8S27C7_nt4v204Ev();
extern void _ZN8S27C7_nt4v205Ev();
extern void _ZN8S27C7_nt4v206Ev();
extern void _ZN8S27C7_nt4v207Ev();
extern void _ZN8S27C7_nt4v208Ev();
extern void _ZN8S27C7_nt4v209Ev();
extern void _ZN8S27C7_nt4v210Ev();
extern void _ZN8S27C6_nt4v211Ev();
extern void _ZN8S27C6_nt4v212Ev();
extern void _ZN8S27C6_nt4v213Ev();
extern void _ZN8S27C6_nt4v214Ev();
extern void _ZN8S27C6_nt4v215Ev();
extern void _ZN8S27C6_nt4v216Ev();
extern void _ZN8S27C6_nt4v217Ev();
extern void _ZN8S27C6_nt4v218Ev();
extern void _ZN8S27C6_nt4v219Ev();
extern void _ZN8S27C6_nt4v220Ev();
extern void _ZN8S27C6_nt4v221Ev();
extern void _ZN8S27C6_nt4v222Ev();
extern void _ZN8S27C6_nt4v223Ev();
extern void _ZN8S27C6_nt4v224Ev();
extern void _ZN8S27C6_nt4v225Ev();
extern void _ZN8S27C6_nt4v226Ev();
extern void _ZN8S27C6_nt4v227Ev();
extern void _ZN8S27C6_nt4v228Ev();
extern void _ZN8S27C6_nt4v229Ev();
extern void _ZN8S27C6_nt4v230Ev();
extern void _ZN8S27C6_nt4v231Ev();
extern void _ZN8S27C6_nt4v232Ev();
extern void _ZN8S27C6_nt4v233Ev();
extern void _ZN8S27C6_nt4v234Ev();
extern void _ZN8S27C6_nt4v235Ev();
extern void _ZN8S27C6_nt4v236Ev();
extern void _ZN8S27C6_nt4v237Ev();
extern void _ZN8S27C6_nt4v238Ev();
extern void _ZN8S27C6_nt4v239Ev();
extern void _ZN8S27C6_nt4v240Ev();
extern void _ZN8S27C6_nt4v241Ev();
extern void _ZN8S27C6_nt4v242Ev();
extern void _ZN8S27C6_nt4v243Ev();
extern void _ZN8S27C6_nt4v244Ev();
extern void _ZN8S27C6_nt4v245Ev();
extern void _ZN8S27C6_nt4v246Ev();
extern void _ZN8S27C6_nt4v247Ev();
extern void _ZN8S27C6_nt4v248Ev();
extern void _ZN8S27C6_nt4v249Ev();
extern void _ZN8S27C6_nt4v250Ev();
extern void _ZN8S27C6_nt4v251Ev();
extern void _ZN8S27C6_nt4v252Ev();
extern void _ZN8S27C6_nt4v253Ev();
extern void _ZN8S27C6_nt4v254Ev();
extern void _ZN8S27C6_nt4v255Ev();
extern void _ZN8S27C6_nt4v256Ev();
extern void _ZN8S27C6_nt4v257Ev();
extern void _ZN8S27C6_nt4v258Ev();
extern void _ZN8S27C6_nt4v259Ev();
extern void _ZN8S27C6_nt4v260Ev();
extern void _ZN8S27C6_nt4v261Ev();
extern void _ZN8S27C6_nt4v262Ev();
extern void _ZN8S27C6_nt4v263Ev();
extern void _ZN8S27C6_nt4v264Ev();
extern void _ZN8S27C6_nt4v265Ev();
extern void _ZN8S27C6_nt4v266Ev();
extern void _ZN8S27C6_nt4v267Ev();
extern void _ZN8S27C6_nt4v268Ev();
extern void _ZN8S27C6_nt4v269Ev();
extern void _ZN8S27C6_nt4v270Ev();
extern void _ZN8S27C6_nt4v271Ev();
extern void _ZN8S27C6_nt4v272Ev();
extern void _ZN8S27C6_nt4v273Ev();
extern void _ZN8S27C6_nt4v274Ev();
extern void _ZN8S27C6_nt4v275Ev();
extern void _ZN8S27C6_nt4v276Ev();
extern void _ZN8S27C6_nt4v277Ev();
extern void _ZN8S27C6_nt4v278Ev();
extern void _ZN8S27C6_nt4v279Ev();
extern void _ZN8S27C6_nt4v280Ev();
extern void _ZN8S27C6_nt4v281Ev();
extern void _ZN8S27C6_nt4v282Ev();
extern void _ZN8S27C6_nt4v283Ev();
extern void _ZN8S27C6_nt4v284Ev();
extern void _ZN8S27C6_nt4v285Ev();
extern void _ZN8S27C6_nt4v286Ev();
extern void _ZN8S27C6_nt4v287Ev();
extern void _ZN8S27C6_nt4v288Ev();
extern void _ZN8S27C6_nt4v289Ev();
extern void _ZN8S27C6_nt4v290Ev();
extern void _ZN8S27C6_nt4v291Ev();
extern void _ZN8S27C6_nt4v292Ev();
extern void _ZN8S27C6_nt4v293Ev();
extern void _ZN8S27C6_nt4v294Ev();
extern void _ZN8S27C6_nt4v295Ev();
extern void _ZN8S27C6_nt4v296Ev();
extern void _ZN8S27C6_nt4v297Ev();
extern void _ZN8S27C6_nt4v298Ev();
extern void _ZN8S27C6_nt4v299Ev();
extern void _ZN8S27C6_nt4v300Ev();
extern void _ZN8S27C6_nt4v301Ev();
extern void _ZN8S27C6_nt4v302Ev();
extern void _ZN8S27C6_nt4v303Ev();
extern void _ZN8S27C6_nt4v304Ev();
extern void _ZN8S27C6_nt4v305Ev();
extern void _ZN8S27C6_nt4v306Ev();
extern void _ZN8S27C6_nt4v307Ev();
extern void _ZN8S27C6_nt4v308Ev();
static  VTBL_ENTRY vtc_S27C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S27C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S27C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S27C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v223Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v224Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v225Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v226Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v227Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v228Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v229Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v230Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v231Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v232Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v234Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v235Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v236Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v237Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v238Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v239Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v240Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v241Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v242Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v243Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v244Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v245Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v246Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v247Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v248Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v249Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v250Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v251Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v252Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v253Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v254Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v255Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v256Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v257Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v258Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v259Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v260Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v261Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v262Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v263Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v264Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v265Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v266Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v267Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v268Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v269Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v270Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v271Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v272Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v273Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v274Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v275Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v276Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v277Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v278Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v279Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v280Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v281Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v282Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v283Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v284Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v285Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v286Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v287Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v288Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v289Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v290Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v291Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v292Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v293Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v294Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v295Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v296Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v297Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v298Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v299Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v300Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v301Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v302Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v303Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v304Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v305Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v306Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v307Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v308Ev,
};
extern VTBL_ENTRY _ZTI8S27C6_nt[];
VTBL_ENTRY *P__ZTI8S27C6_nt = _ZTI8S27C6_nt; 
extern  VTBL_ENTRY _ZTV8S27C6_nt[];
Class_Descriptor cd_S27C6_nt = {  "S27C6_nt", // class name
  bases_S27C6_nt, 2,
  &(vtc_S27C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1200,936), // object size
  NSPAIRA(_ZTI8S27C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S27C6_nt),309, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C30  : S27C12_nt {
};
//SIG(-1 S27C30) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C30()
{
  extern Class_Descriptor cd_S27C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C30, buf);
    S27C30 &lv = *(new (buf) S27C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C30)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C30");
    test_class_info(&lv, &cd_S27C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C30(Test_S27C30, "S27C30", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C30 = {  "S27C30", // class name
  bases_S27C30, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C29  : S27C30 {
};
//SIG(-1 S27C29) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C29()
{
  extern Class_Descriptor cd_S27C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C29, buf);
    S27C29 &lv = *(new (buf) S27C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C29)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C30*), 0, "S27C29");
    check_base_class_offset(lv, (S27C30*), 0, "S27C29");
    test_class_info(&lv, &cd_S27C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C29(Test_S27C29, "S27C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C30;
static Base_Class bases_S27C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C29 = {  "S27C29", // class name
  bases_S27C29, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C5_nt  : S27C6_nt {
  void *s27c5f0;
  unsigned int s27c5f1:1;
  unsigned int s27c5f2:1;
  unsigned int s27c5f3:1;
  unsigned int s27c5f4:1;
  unsigned int s27c5f5:1;
  unsigned int s27c5f6:1;
  unsigned int s27c5f7:1;
  unsigned int s27c5f8:1;
  unsigned int s27c5f9:1;
  unsigned int s27c5f10:1;
  unsigned int s27c5f11:1;
  unsigned int s27c5f12:1;
  ::S27C29 s27c5f13;
  int s27c5f14;
  ::S27C18_nt s27c5f15;
  int s27c5f16[3];
  ::S27C18_nt s27c5f17;
  int s27c5f18[2];
  void *s27c5f19;
  int s27c5f20[2];
  char s27c5f21;
  int s27c5f22[8];
  virtual  ~S27C5_nt(); // _ZN8S27C5_ntD1Ev
  virtual void  v309(); // _ZN8S27C5_nt4v309Ev
  virtual void  v310(); // _ZN8S27C5_nt4v310Ev
  virtual void  v311(); // _ZN8S27C5_nt4v311Ev
  virtual void  v312(); // _ZN8S27C5_nt4v312Ev
  virtual void  v313(); // _ZN8S27C5_nt4v313Ev
  virtual void  v314(); // _ZN8S27C5_nt4v314Ev
  virtual void  v315(); // _ZN8S27C5_nt4v315Ev
  virtual void  v316(); // _ZN8S27C5_nt4v316Ev
  virtual void  v317(); // _ZN8S27C5_nt4v317Ev
  virtual void  v318(); // _ZN8S27C5_nt4v318Ev
  virtual void  v319(); // _ZN8S27C5_nt4v319Ev
  virtual void  v320(); // _ZN8S27C5_nt4v320Ev
  virtual void  v321(); // _ZN8S27C5_nt4v321Ev
  virtual void  v322(); // _ZN8S27C5_nt4v322Ev
  virtual void  v323(); // _ZN8S27C5_nt4v323Ev
  virtual void  v324(); // _ZN8S27C5_nt4v324Ev
  virtual void  v325(); // _ZN8S27C5_nt4v325Ev
  virtual void  v326(); // _ZN8S27C5_nt4v326Ev
  virtual void  v327(); // _ZN8S27C5_nt4v327Ev
  virtual void  v328(); // _ZN8S27C5_nt4v328Ev
  virtual void  v329(); // _ZN8S27C5_nt4v329Ev
  virtual void  v330(); // _ZN8S27C5_nt4v330Ev
  S27C5_nt(); // tgen
};
//SIG(-1 S27C5_nt) C1{ BC2{ BC3{ BC4{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC12 Fi[19] FC12 Fi[2] Fp Fi[5] FC12 FC12 Fi Fp Fi FC12 Fi Fp Fi[3] FC15{ BC16{ BC17{ BC8}}} Fp[3] FC5 FC5 Fp Fi FC12 Fp FC12 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC12 FC12 Fi Fp[2] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC18{ BC19{ BC8}} Fi FC12 Fi[3] FC12 Fi[2] Fp Fi[2] Fc Fi[8]}


 S27C5_nt ::~S27C5_nt(){ note_dtor("S27C5_nt", this);}
void  S27C5_nt ::v309(){vfunc_called(this, "_ZN8S27C5_nt4v309Ev");}
void  S27C5_nt ::v310(){vfunc_called(this, "_ZN8S27C5_nt4v310Ev");}
void  S27C5_nt ::v311(){vfunc_called(this, "_ZN8S27C5_nt4v311Ev");}
void  S27C5_nt ::v312(){vfunc_called(this, "_ZN8S27C5_nt4v312Ev");}
void  S27C5_nt ::v313(){vfunc_called(this, "_ZN8S27C5_nt4v313Ev");}
void  S27C5_nt ::v314(){vfunc_called(this, "_ZN8S27C5_nt4v314Ev");}
void  S27C5_nt ::v315(){vfunc_called(this, "_ZN8S27C5_nt4v315Ev");}
void  S27C5_nt ::v316(){vfunc_called(this, "_ZN8S27C5_nt4v316Ev");}
void  S27C5_nt ::v317(){vfunc_called(this, "_ZN8S27C5_nt4v317Ev");}
void  S27C5_nt ::v318(){vfunc_called(this, "_ZN8S27C5_nt4v318Ev");}
void  S27C5_nt ::v319(){vfunc_called(this, "_ZN8S27C5_nt4v319Ev");}
void  S27C5_nt ::v320(){vfunc_called(this, "_ZN8S27C5_nt4v320Ev");}
void  S27C5_nt ::v321(){vfunc_called(this, "_ZN8S27C5_nt4v321Ev");}
void  S27C5_nt ::v322(){vfunc_called(this, "_ZN8S27C5_nt4v322Ev");}
void  S27C5_nt ::v323(){vfunc_called(this, "_ZN8S27C5_nt4v323Ev");}
void  S27C5_nt ::v324(){vfunc_called(this, "_ZN8S27C5_nt4v324Ev");}
void  S27C5_nt ::v325(){vfunc_called(this, "_ZN8S27C5_nt4v325Ev");}
void  S27C5_nt ::v326(){vfunc_called(this, "_ZN8S27C5_nt4v326Ev");}
void  S27C5_nt ::v327(){vfunc_called(this, "_ZN8S27C5_nt4v327Ev");}
void  S27C5_nt ::v328(){vfunc_called(this, "_ZN8S27C5_nt4v328Ev");}
void  S27C5_nt ::v329(){vfunc_called(this, "_ZN8S27C5_nt4v329Ev");}
void  S27C5_nt ::v330(){vfunc_called(this, "_ZN8S27C5_nt4v330Ev");}
S27C5_nt ::S27C5_nt(){ note_ctor("S27C5_nt", this);} // tgen

//skip512 S27C5_nt

#else // __cplusplus

extern void _ZN8S27C5_ntC1Ev();
extern void _ZN8S27C5_ntD1Ev();
Name_Map name_map_S27C5_nt[] = {
  NSPAIR(_ZN8S27C5_ntC1Ev),
  NSPAIR(_ZN8S27C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S27C8_nt;
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
extern Class_Descriptor cd_S27C7_nt;
extern VTBL_ENTRY _ZTI8S27C7_nt[];
extern  VTBL_ENTRY _ZTV8S27C7_nt[];
extern Class_Descriptor cd_S27C6_nt;
extern VTBL_ENTRY _ZTI8S27C6_nt[];
extern  VTBL_ENTRY _ZTV8S27C6_nt[];
static Base_Class bases_S27C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S27C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S27C5_nt[];
extern void _ZN8S27C5_ntD1Ev();
extern void _ZN8S27C5_ntD0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
extern void _ZN8S27C7_nt3v68Ev();
extern void _ZN8S27C7_nt3v69Ev();
extern void _ZN8S27C7_nt3v70Ev();
extern void _ZN8S27C7_nt3v71Ev();
extern void _ZN8S27C7_nt3v72Ev();
extern void _ZN8S27C7_nt3v73Ev();
extern void _ZN8S27C7_nt3v74Ev();
extern void _ZN8S27C7_nt3v75Ev();
extern void _ZN8S27C7_nt3v76Ev();
extern void _ZN8S27C7_nt3v77Ev();
extern void _ZN8S27C7_nt3v78Ev();
extern void _ZN8S27C7_nt3v79Ev();
extern void _ZN8S27C7_nt3v80Ev();
extern void _ZN8S27C7_nt3v81Ev();
extern void _ZN8S27C7_nt3v82Ev();
extern void _ZN8S27C7_nt3v83Ev();
extern void _ZN8S27C7_nt3v84Ev();
extern void _ZN8S27C7_nt3v85Ev();
extern void _ZN8S27C7_nt3v86Ev();
extern void _ZN8S27C7_nt3v87Ev();
extern void _ZN8S27C7_nt3v88Ev();
extern void _ZN8S27C7_nt3v89Ev();
extern void _ZN8S27C7_nt3v90Ev();
extern void _ZN8S27C7_nt3v91Ev();
extern void _ZN8S27C7_nt3v92Ev();
extern void _ZN8S27C7_nt3v93Ev();
extern void _ZN8S27C7_nt3v94Ev();
extern void _ZN8S27C7_nt3v95Ev();
extern void _ZN8S27C7_nt3v96Ev();
extern void _ZN8S27C7_nt3v97Ev();
extern void _ZN8S27C7_nt3v98Ev();
extern void _ZN8S27C7_nt3v99Ev();
extern void _ZN8S27C7_nt4v100Ev();
extern void _ZN8S27C7_nt4v101Ev();
extern void _ZN8S27C7_nt4v102Ev();
extern void _ZN8S27C7_nt4v103Ev();
extern void _ZN8S27C7_nt4v104Ev();
extern void _ZN8S27C7_nt4v105Ev();
extern void _ZN8S27C7_nt4v106Ev();
extern void _ZN8S27C7_nt4v107Ev();
extern void _ZN8S27C7_nt4v108Ev();
extern void _ZN8S27C7_nt4v109Ev();
extern void _ZN8S27C7_nt4v110Ev();
extern void _ZN8S27C7_nt4v111Ev();
extern void _ZN8S27C7_nt4v112Ev();
extern void _ZN8S27C7_nt4v113Ev();
extern void _ZN8S27C7_nt4v114Ev();
extern void _ZN8S27C7_nt4v115Ev();
extern void _ZN8S27C7_nt4v116Ev();
extern void _ZN8S27C7_nt4v117Ev();
extern void _ZN8S27C7_nt4v118Ev();
extern void _ZN8S27C7_nt4v119Ev();
extern void _ZN8S27C7_nt4v120Ev();
extern void _ZN8S27C7_nt4v121Ev();
extern void _ZN8S27C7_nt4v122Ev();
extern void _ZN8S27C7_nt4v123Ev();
extern void _ZN8S27C7_nt4v124Ev();
extern void _ZN8S27C7_nt4v125Ev();
extern void _ZN8S27C7_nt4v126Ev();
extern void _ZN8S27C7_nt4v127Ev();
extern void _ZN8S27C7_nt4v128Ev();
extern void _ZN8S27C7_nt4v129Ev();
extern void _ZN8S27C7_nt4v130Ev();
extern void _ZN8S27C7_nt4v131Ev();
extern void _ZN8S27C7_nt4v132Ev();
extern void _ZN8S27C7_nt4v133Ev();
extern void _ZN8S27C7_nt4v134Ev();
extern void _ZN8S27C7_nt4v135Ev();
extern void _ZN8S27C7_nt4v136Ev();
extern void _ZN8S27C7_nt4v137Ev();
extern void _ZN8S27C7_nt4v138Ev();
extern void _ZN8S27C7_nt4v139Ev();
extern void _ZN8S27C7_nt4v140Ev();
extern void _ZN8S27C7_nt4v141Ev();
extern void _ZN8S27C7_nt4v142Ev();
extern void _ZN8S27C7_nt4v143Ev();
extern void _ZN8S27C7_nt4v144Ev();
extern void _ZN8S27C7_nt4v145Ev();
extern void _ZN8S27C7_nt4v146Ev();
extern void _ZN8S27C7_nt4v147Ev();
extern void _ZN8S27C7_nt4v148Ev();
extern void _ZN8S27C7_nt4v149Ev();
extern void _ZN8S27C7_nt4v150Ev();
extern void _ZN8S27C7_nt4v151Ev();
extern void _ZN8S27C7_nt4v152Ev();
extern void _ZN8S27C7_nt4v153Ev();
extern void _ZN8S27C7_nt4v154Ev();
extern void _ZN8S27C7_nt4v155Ev();
extern void _ZN8S27C7_nt4v156Ev();
extern void _ZN8S27C7_nt4v157Ev();
extern void _ZN8S27C7_nt4v158Ev();
extern void _ZN8S27C7_nt4v159Ev();
extern void _ZN8S27C7_nt4v160Ev();
extern void _ZN8S27C7_nt4v161Ev();
extern void _ZN8S27C7_nt4v162Ev();
extern void _ZN8S27C7_nt4v163Ev();
extern void _ZN8S27C7_nt4v164Ev();
extern void _ZN8S27C7_nt4v165Ev();
extern void _ZN8S27C7_nt4v166Ev();
extern void _ZN8S27C7_nt4v167Ev();
extern void _ZN8S27C7_nt4v168Ev();
extern void _ZN8S27C7_nt4v169Ev();
extern void _ZN8S27C7_nt4v170Ev();
extern void _ZN8S27C7_nt4v171Ev();
extern void _ZN8S27C7_nt4v172Ev();
extern void _ZN8S27C7_nt4v173Ev();
extern void _ZN8S27C7_nt4v174Ev();
extern void _ZN8S27C7_nt4v175Ev();
extern void _ZN8S27C7_nt4v176Ev();
extern void _ZN8S27C7_nt4v177Ev();
extern void _ZN8S27C7_nt4v178Ev();
extern void _ZN8S27C7_nt4v179Ev();
extern void _ZN8S27C7_nt4v180Ev();
extern void _ZN8S27C7_nt4v181Ev();
extern void _ZN8S27C7_nt4v182Ev();
extern void _ZN8S27C7_nt4v183Ev();
extern void _ZN8S27C7_nt4v184Ev();
extern void _ZN8S27C7_nt4v185Ev();
extern void _ZN8S27C7_nt4v186Ev();
extern void _ZN8S27C7_nt4v187Ev();
extern void _ZN8S27C7_nt4v188Ev();
extern void _ZN8S27C7_nt4v189Ev();
extern void _ZN8S27C7_nt4v190Ev();
extern void _ZN8S27C7_nt4v191Ev();
extern void _ZN8S27C7_nt4v192Ev();
extern void _ZN8S27C7_nt4v193Ev();
extern void _ZN8S27C7_nt4v194Ev();
extern void _ZN8S27C7_nt4v195Ev();
extern void _ZN8S27C7_nt4v196Ev();
extern void _ZN8S27C7_nt4v197Ev();
extern void _ZN8S27C7_nt4v198Ev();
extern void _ZN8S27C7_nt4v199Ev();
extern void _ZN8S27C7_nt4v200Ev();
extern void _ZN8S27C7_nt4v201Ev();
extern void _ZN8S27C7_nt4v202Ev();
extern void _ZN8S27C7_nt4v203Ev();
extern void _ZN8S27C7_nt4v204Ev();
extern void _ZN8S27C7_nt4v205Ev();
extern void _ZN8S27C7_nt4v206Ev();
extern void _ZN8S27C7_nt4v207Ev();
extern void _ZN8S27C7_nt4v208Ev();
extern void _ZN8S27C7_nt4v209Ev();
extern void _ZN8S27C7_nt4v210Ev();
extern void _ZN8S27C6_nt4v211Ev();
extern void _ZN8S27C6_nt4v212Ev();
extern void _ZN8S27C6_nt4v213Ev();
extern void _ZN8S27C6_nt4v214Ev();
extern void _ZN8S27C6_nt4v215Ev();
extern void _ZN8S27C6_nt4v216Ev();
extern void _ZN8S27C6_nt4v217Ev();
extern void _ZN8S27C6_nt4v218Ev();
extern void _ZN8S27C6_nt4v219Ev();
extern void _ZN8S27C6_nt4v220Ev();
extern void _ZN8S27C6_nt4v221Ev();
extern void _ZN8S27C6_nt4v222Ev();
extern void _ZN8S27C6_nt4v223Ev();
extern void _ZN8S27C6_nt4v224Ev();
extern void _ZN8S27C6_nt4v225Ev();
extern void _ZN8S27C6_nt4v226Ev();
extern void _ZN8S27C6_nt4v227Ev();
extern void _ZN8S27C6_nt4v228Ev();
extern void _ZN8S27C6_nt4v229Ev();
extern void _ZN8S27C6_nt4v230Ev();
extern void _ZN8S27C6_nt4v231Ev();
extern void _ZN8S27C6_nt4v232Ev();
extern void _ZN8S27C6_nt4v233Ev();
extern void _ZN8S27C6_nt4v234Ev();
extern void _ZN8S27C6_nt4v235Ev();
extern void _ZN8S27C6_nt4v236Ev();
extern void _ZN8S27C6_nt4v237Ev();
extern void _ZN8S27C6_nt4v238Ev();
extern void _ZN8S27C6_nt4v239Ev();
extern void _ZN8S27C6_nt4v240Ev();
extern void _ZN8S27C6_nt4v241Ev();
extern void _ZN8S27C6_nt4v242Ev();
extern void _ZN8S27C6_nt4v243Ev();
extern void _ZN8S27C6_nt4v244Ev();
extern void _ZN8S27C6_nt4v245Ev();
extern void _ZN8S27C6_nt4v246Ev();
extern void _ZN8S27C6_nt4v247Ev();
extern void _ZN8S27C6_nt4v248Ev();
extern void _ZN8S27C6_nt4v249Ev();
extern void _ZN8S27C6_nt4v250Ev();
extern void _ZN8S27C6_nt4v251Ev();
extern void _ZN8S27C6_nt4v252Ev();
extern void _ZN8S27C6_nt4v253Ev();
extern void _ZN8S27C6_nt4v254Ev();
extern void _ZN8S27C6_nt4v255Ev();
extern void _ZN8S27C6_nt4v256Ev();
extern void _ZN8S27C6_nt4v257Ev();
extern void _ZN8S27C6_nt4v258Ev();
extern void _ZN8S27C6_nt4v259Ev();
extern void _ZN8S27C6_nt4v260Ev();
extern void _ZN8S27C6_nt4v261Ev();
extern void _ZN8S27C6_nt4v262Ev();
extern void _ZN8S27C6_nt4v263Ev();
extern void _ZN8S27C6_nt4v264Ev();
extern void _ZN8S27C6_nt4v265Ev();
extern void _ZN8S27C6_nt4v266Ev();
extern void _ZN8S27C6_nt4v267Ev();
extern void _ZN8S27C6_nt4v268Ev();
extern void _ZN8S27C6_nt4v269Ev();
extern void _ZN8S27C6_nt4v270Ev();
extern void _ZN8S27C6_nt4v271Ev();
extern void _ZN8S27C6_nt4v272Ev();
extern void _ZN8S27C6_nt4v273Ev();
extern void _ZN8S27C6_nt4v274Ev();
extern void _ZN8S27C6_nt4v275Ev();
extern void _ZN8S27C6_nt4v276Ev();
extern void _ZN8S27C6_nt4v277Ev();
extern void _ZN8S27C6_nt4v278Ev();
extern void _ZN8S27C6_nt4v279Ev();
extern void _ZN8S27C6_nt4v280Ev();
extern void _ZN8S27C6_nt4v281Ev();
extern void _ZN8S27C6_nt4v282Ev();
extern void _ZN8S27C6_nt4v283Ev();
extern void _ZN8S27C6_nt4v284Ev();
extern void _ZN8S27C6_nt4v285Ev();
extern void _ZN8S27C6_nt4v286Ev();
extern void _ZN8S27C6_nt4v287Ev();
extern void _ZN8S27C6_nt4v288Ev();
extern void _ZN8S27C6_nt4v289Ev();
extern void _ZN8S27C6_nt4v290Ev();
extern void _ZN8S27C6_nt4v291Ev();
extern void _ZN8S27C6_nt4v292Ev();
extern void _ZN8S27C6_nt4v293Ev();
extern void _ZN8S27C6_nt4v294Ev();
extern void _ZN8S27C6_nt4v295Ev();
extern void _ZN8S27C6_nt4v296Ev();
extern void _ZN8S27C6_nt4v297Ev();
extern void _ZN8S27C6_nt4v298Ev();
extern void _ZN8S27C6_nt4v299Ev();
extern void _ZN8S27C6_nt4v300Ev();
extern void _ZN8S27C6_nt4v301Ev();
extern void _ZN8S27C6_nt4v302Ev();
extern void _ZN8S27C6_nt4v303Ev();
extern void _ZN8S27C6_nt4v304Ev();
extern void _ZN8S27C6_nt4v305Ev();
extern void _ZN8S27C6_nt4v306Ev();
extern void _ZN8S27C6_nt4v307Ev();
extern void _ZN8S27C6_nt4v308Ev();
extern void _ZN8S27C5_nt4v309Ev();
extern void _ZN8S27C5_nt4v310Ev();
extern void _ZN8S27C5_nt4v311Ev();
extern void _ZN8S27C5_nt4v312Ev();
extern void _ZN8S27C5_nt4v313Ev();
extern void _ZN8S27C5_nt4v314Ev();
extern void _ZN8S27C5_nt4v315Ev();
extern void _ZN8S27C5_nt4v316Ev();
extern void _ZN8S27C5_nt4v317Ev();
extern void _ZN8S27C5_nt4v318Ev();
extern void _ZN8S27C5_nt4v319Ev();
extern void _ZN8S27C5_nt4v320Ev();
extern void _ZN8S27C5_nt4v321Ev();
extern void _ZN8S27C5_nt4v322Ev();
extern void _ZN8S27C5_nt4v323Ev();
extern void _ZN8S27C5_nt4v324Ev();
extern void _ZN8S27C5_nt4v325Ev();
extern void _ZN8S27C5_nt4v326Ev();
extern void _ZN8S27C5_nt4v327Ev();
extern void _ZN8S27C5_nt4v328Ev();
extern void _ZN8S27C5_nt4v329Ev();
extern void _ZN8S27C5_nt4v330Ev();
static  VTBL_ENTRY vtc_S27C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S27C5_nt[0]),
  (VTBL_ENTRY)&_ZN8S27C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S27C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v223Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v224Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v225Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v226Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v227Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v228Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v229Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v230Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v231Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v232Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v234Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v235Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v236Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v237Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v238Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v239Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v240Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v241Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v242Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v243Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v244Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v245Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v246Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v247Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v248Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v249Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v250Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v251Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v252Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v253Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v254Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v255Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v256Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v257Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v258Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v259Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v260Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v261Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v262Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v263Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v264Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v265Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v266Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v267Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v268Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v269Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v270Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v271Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v272Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v273Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v274Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v275Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v276Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v277Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v278Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v279Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v280Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v281Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v282Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v283Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v284Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v285Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v286Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v287Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v288Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v289Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v290Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v291Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v292Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v293Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v294Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v295Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v296Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v297Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v298Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v299Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v300Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v301Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v302Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v303Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v304Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v305Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v306Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v307Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v308Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v309Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v310Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v311Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v312Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v313Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v314Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v315Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v316Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v317Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v318Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v319Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v320Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v321Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v322Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v323Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v324Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v325Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v326Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v327Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v328Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v329Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v330Ev,
};
extern VTBL_ENTRY _ZTI8S27C5_nt[];
VTBL_ENTRY *P__ZTI8S27C5_nt = _ZTI8S27C5_nt; 
extern  VTBL_ENTRY _ZTV8S27C5_nt[];
Class_Descriptor cd_S27C5_nt = {  "S27C5_nt", // class name
  bases_S27C5_nt, 3,
  &(vtc_S27C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1336,1052), // object size
  NSPAIRA(_ZTI8S27C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S27C5_nt),331, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C35_nt  {
  int s27c35f0[4];
  void  mf27c35(); // _ZN9S27C35_nt7mf27c35Ev
};
//SIG(-1 S27C35_nt) C1{ m Fi[4]}


void  S27C35_nt ::mf27c35(){}

//skip512 S27C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C34_nt  {
  ::S27C18_nt s27c34f0;
  ::S27C35_nt s27c34f1;
  ::S27C18_nt s27c34f2;
  ::S27C18_nt s27c34f3;
  char s27c34f4;
  void  mf27c34(); // _ZN9S27C34_nt7mf27c34Ev
};
//SIG(-1 S27C34_nt) C1{ m FC2{ m Fi[3]} FC3{ m Fi[4]} FC2 FC2 Fc}


void  S27C34_nt ::mf27c34(){}

//skip512 S27C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C33_nt  {
  ::S27C34_nt s27c33f0;
  char s27c33f1[4];
  unsigned int s27c33f2:1;
  int s27c33f3;
};
//SIG(-1 S27C33_nt) C1{ FC2{ m FC3{ m Fi[3]} FC4{ m Fi[4]} FC3 FC3 Fc} Fc[4] Fi:1 Fi}



//skip512 S27C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C4_nt  : S27C5_nt {
  void *s27c4f0;
  ::S27C29 s27c4f1;
  ::S27C18_nt s27c4f2;
  ::S27C18_nt s27c4f3;
  unsigned int s27c4f4:1;
  unsigned int s27c4f5:1;
  unsigned int s27c4f6:1;
  unsigned int s27c4f7:1;
  unsigned int s27c4f8:1;
  unsigned int s27c4f9:1;
  unsigned int s27c4f10:1;
  unsigned int s27c4f11:1;
  unsigned int s27c4f12:1;
  unsigned int s27c4f13:1;
  unsigned int s27c4f14:1;
  unsigned int s27c4f15:1;
  unsigned int s27c4f16:1;
  int s27c4f17[4];
  void *s27c4f18[2];
  int s27c4f19[8];
  void *s27c4f20[5];
  int s27c4f21[13];
  ::S27C18_nt s27c4f22;
  int s27c4f23[3];
  ::S27C33_nt s27c4f24;
  int s27c4f25[2];
  virtual  ~S27C4_nt(); // _ZN8S27C4_ntD1Ev
  virtual void  v331(); // _ZN8S27C4_nt4v331Ev
  virtual void  v332(); // _ZN8S27C4_nt4v332Ev
  virtual void  v333(); // _ZN8S27C4_nt4v333Ev
  virtual void  v334(); // _ZN8S27C4_nt4v334Ev
  virtual void  v335(); // _ZN8S27C4_nt4v335Ev
  virtual void  v336(); // _ZN8S27C4_nt4v336Ev
  virtual void  v337(); // _ZN8S27C4_nt4v337Ev
  virtual void  v338(); // _ZN8S27C4_nt4v338Ev
  virtual void  v339(); // _ZN8S27C4_nt4v339Ev
  virtual void  v340(); // _ZN8S27C4_nt4v340Ev
  virtual void  v341(); // _ZN8S27C4_nt4v341Ev
  virtual void  v342(); // _ZN8S27C4_nt4v342Ev
  virtual void  v343(); // _ZN8S27C4_nt4v343Ev
  virtual void  v344(); // _ZN8S27C4_nt4v344Ev
  virtual void  v345(); // _ZN8S27C4_nt4v345Ev
  virtual void  v346(); // _ZN8S27C4_nt4v346Ev
  virtual void  v347(); // _ZN8S27C4_nt4v347Ev
  virtual void  v348(); // _ZN8S27C4_nt4v348Ev
  virtual void  v349(); // _ZN8S27C4_nt4v349Ev
  virtual void  v350(); // _ZN8S27C4_nt4v350Ev
  virtual void  v351(); // _ZN8S27C4_nt4v351Ev
  virtual void  v352(); // _ZN8S27C4_nt4v352Ev
  virtual void  v353(); // _ZN8S27C4_nt4v353Ev
  virtual void  v354(); // _ZN8S27C4_nt4v354Ev
  S27C4_nt(); // tgen
};
//SIG(-1 S27C4_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 FC10{ m Fi} Fi Fc[4] Fp[2] FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC6 FC6 FC6 FC11{ BC12{ BC9}} FC11 Fi Fp[2] FC13{ m Fi[3]} FC13 FC13 FC13 Fp FC6 FC11 FC13 FC13 Fi FC13 FC13 Fp Fi Fc FC13 FC13 Fp Fi Fp FC11 FC14{ BC15{ BC9}} FC14} vd v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 v328 v329 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC13 Fi[19] FC13 Fi[2] Fp Fi[5] FC13 FC13 Fi Fp Fi FC13 Fi Fp Fi[3] FC16{ BC17{ BC18{ BC9}}} Fp[3] FC6 FC6 Fp Fi FC13 Fp FC13 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC13 FC13 Fi Fp[2] Fi} vd v330 v331 v332 v333 v334 v335 v336 v337 v338 v339 v340 v341 v342 v343 v344 v345 v346 v347 v348 v349 v350 v351 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC19{ BC20{ BC9}} Fi FC13 Fi[3] FC13 Fi[2] Fp Fi[2] Fc Fi[8]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC19 FC13 FC13 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[4] Fp[2] Fi[8] Fp[5] Fi[13] FC13 Fi[3] FC21{ FC22{ m FC13 FC23{ m Fi[4]} FC13 FC13 Fc} Fc[4] Fi:1 Fi} Fi[2]}


 S27C4_nt ::~S27C4_nt(){ note_dtor("S27C4_nt", this);}
void  S27C4_nt ::v331(){vfunc_called(this, "_ZN8S27C4_nt4v331Ev");}
void  S27C4_nt ::v332(){vfunc_called(this, "_ZN8S27C4_nt4v332Ev");}
void  S27C4_nt ::v333(){vfunc_called(this, "_ZN8S27C4_nt4v333Ev");}
void  S27C4_nt ::v334(){vfunc_called(this, "_ZN8S27C4_nt4v334Ev");}
void  S27C4_nt ::v335(){vfunc_called(this, "_ZN8S27C4_nt4v335Ev");}
void  S27C4_nt ::v336(){vfunc_called(this, "_ZN8S27C4_nt4v336Ev");}
void  S27C4_nt ::v337(){vfunc_called(this, "_ZN8S27C4_nt4v337Ev");}
void  S27C4_nt ::v338(){vfunc_called(this, "_ZN8S27C4_nt4v338Ev");}
void  S27C4_nt ::v339(){vfunc_called(this, "_ZN8S27C4_nt4v339Ev");}
void  S27C4_nt ::v340(){vfunc_called(this, "_ZN8S27C4_nt4v340Ev");}
void  S27C4_nt ::v341(){vfunc_called(this, "_ZN8S27C4_nt4v341Ev");}
void  S27C4_nt ::v342(){vfunc_called(this, "_ZN8S27C4_nt4v342Ev");}
void  S27C4_nt ::v343(){vfunc_called(this, "_ZN8S27C4_nt4v343Ev");}
void  S27C4_nt ::v344(){vfunc_called(this, "_ZN8S27C4_nt4v344Ev");}
void  S27C4_nt ::v345(){vfunc_called(this, "_ZN8S27C4_nt4v345Ev");}
void  S27C4_nt ::v346(){vfunc_called(this, "_ZN8S27C4_nt4v346Ev");}
void  S27C4_nt ::v347(){vfunc_called(this, "_ZN8S27C4_nt4v347Ev");}
void  S27C4_nt ::v348(){vfunc_called(this, "_ZN8S27C4_nt4v348Ev");}
void  S27C4_nt ::v349(){vfunc_called(this, "_ZN8S27C4_nt4v349Ev");}
void  S27C4_nt ::v350(){vfunc_called(this, "_ZN8S27C4_nt4v350Ev");}
void  S27C4_nt ::v351(){vfunc_called(this, "_ZN8S27C4_nt4v351Ev");}
void  S27C4_nt ::v352(){vfunc_called(this, "_ZN8S27C4_nt4v352Ev");}
void  S27C4_nt ::v353(){vfunc_called(this, "_ZN8S27C4_nt4v353Ev");}
void  S27C4_nt ::v354(){vfunc_called(this, "_ZN8S27C4_nt4v354Ev");}
S27C4_nt ::S27C4_nt(){ note_ctor("S27C4_nt", this);} // tgen

//skip512 S27C4_nt

#else // __cplusplus

extern void _ZN8S27C4_ntC1Ev();
extern void _ZN8S27C4_ntD1Ev();
Name_Map name_map_S27C4_nt[] = {
  NSPAIR(_ZN8S27C4_ntC1Ev),
  NSPAIR(_ZN8S27C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S27C8_nt;
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
extern Class_Descriptor cd_S27C7_nt;
extern VTBL_ENTRY _ZTI8S27C7_nt[];
extern  VTBL_ENTRY _ZTV8S27C7_nt[];
extern Class_Descriptor cd_S27C6_nt;
extern VTBL_ENTRY _ZTI8S27C6_nt[];
extern  VTBL_ENTRY _ZTV8S27C6_nt[];
extern Class_Descriptor cd_S27C5_nt;
extern VTBL_ENTRY _ZTI8S27C5_nt[];
extern  VTBL_ENTRY _ZTV8S27C5_nt[];
static Base_Class bases_S27C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S27C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S27C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S27C4_nt[];
extern void _ZN8S27C4_ntD1Ev();
extern void _ZN8S27C4_ntD0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
extern void _ZN8S27C7_nt3v68Ev();
extern void _ZN8S27C7_nt3v69Ev();
extern void _ZN8S27C7_nt3v70Ev();
extern void _ZN8S27C7_nt3v71Ev();
extern void _ZN8S27C7_nt3v72Ev();
extern void _ZN8S27C7_nt3v73Ev();
extern void _ZN8S27C7_nt3v74Ev();
extern void _ZN8S27C7_nt3v75Ev();
extern void _ZN8S27C7_nt3v76Ev();
extern void _ZN8S27C7_nt3v77Ev();
extern void _ZN8S27C7_nt3v78Ev();
extern void _ZN8S27C7_nt3v79Ev();
extern void _ZN8S27C7_nt3v80Ev();
extern void _ZN8S27C7_nt3v81Ev();
extern void _ZN8S27C7_nt3v82Ev();
extern void _ZN8S27C7_nt3v83Ev();
extern void _ZN8S27C7_nt3v84Ev();
extern void _ZN8S27C7_nt3v85Ev();
extern void _ZN8S27C7_nt3v86Ev();
extern void _ZN8S27C7_nt3v87Ev();
extern void _ZN8S27C7_nt3v88Ev();
extern void _ZN8S27C7_nt3v89Ev();
extern void _ZN8S27C7_nt3v90Ev();
extern void _ZN8S27C7_nt3v91Ev();
extern void _ZN8S27C7_nt3v92Ev();
extern void _ZN8S27C7_nt3v93Ev();
extern void _ZN8S27C7_nt3v94Ev();
extern void _ZN8S27C7_nt3v95Ev();
extern void _ZN8S27C7_nt3v96Ev();
extern void _ZN8S27C7_nt3v97Ev();
extern void _ZN8S27C7_nt3v98Ev();
extern void _ZN8S27C7_nt3v99Ev();
extern void _ZN8S27C7_nt4v100Ev();
extern void _ZN8S27C7_nt4v101Ev();
extern void _ZN8S27C7_nt4v102Ev();
extern void _ZN8S27C7_nt4v103Ev();
extern void _ZN8S27C7_nt4v104Ev();
extern void _ZN8S27C7_nt4v105Ev();
extern void _ZN8S27C7_nt4v106Ev();
extern void _ZN8S27C7_nt4v107Ev();
extern void _ZN8S27C7_nt4v108Ev();
extern void _ZN8S27C7_nt4v109Ev();
extern void _ZN8S27C7_nt4v110Ev();
extern void _ZN8S27C7_nt4v111Ev();
extern void _ZN8S27C7_nt4v112Ev();
extern void _ZN8S27C7_nt4v113Ev();
extern void _ZN8S27C7_nt4v114Ev();
extern void _ZN8S27C7_nt4v115Ev();
extern void _ZN8S27C7_nt4v116Ev();
extern void _ZN8S27C7_nt4v117Ev();
extern void _ZN8S27C7_nt4v118Ev();
extern void _ZN8S27C7_nt4v119Ev();
extern void _ZN8S27C7_nt4v120Ev();
extern void _ZN8S27C7_nt4v121Ev();
extern void _ZN8S27C7_nt4v122Ev();
extern void _ZN8S27C7_nt4v123Ev();
extern void _ZN8S27C7_nt4v124Ev();
extern void _ZN8S27C7_nt4v125Ev();
extern void _ZN8S27C7_nt4v126Ev();
extern void _ZN8S27C7_nt4v127Ev();
extern void _ZN8S27C7_nt4v128Ev();
extern void _ZN8S27C7_nt4v129Ev();
extern void _ZN8S27C7_nt4v130Ev();
extern void _ZN8S27C7_nt4v131Ev();
extern void _ZN8S27C7_nt4v132Ev();
extern void _ZN8S27C7_nt4v133Ev();
extern void _ZN8S27C7_nt4v134Ev();
extern void _ZN8S27C7_nt4v135Ev();
extern void _ZN8S27C7_nt4v136Ev();
extern void _ZN8S27C7_nt4v137Ev();
extern void _ZN8S27C7_nt4v138Ev();
extern void _ZN8S27C7_nt4v139Ev();
extern void _ZN8S27C7_nt4v140Ev();
extern void _ZN8S27C7_nt4v141Ev();
extern void _ZN8S27C7_nt4v142Ev();
extern void _ZN8S27C7_nt4v143Ev();
extern void _ZN8S27C7_nt4v144Ev();
extern void _ZN8S27C7_nt4v145Ev();
extern void _ZN8S27C7_nt4v146Ev();
extern void _ZN8S27C7_nt4v147Ev();
extern void _ZN8S27C7_nt4v148Ev();
extern void _ZN8S27C7_nt4v149Ev();
extern void _ZN8S27C7_nt4v150Ev();
extern void _ZN8S27C7_nt4v151Ev();
extern void _ZN8S27C7_nt4v152Ev();
extern void _ZN8S27C7_nt4v153Ev();
extern void _ZN8S27C7_nt4v154Ev();
extern void _ZN8S27C7_nt4v155Ev();
extern void _ZN8S27C7_nt4v156Ev();
extern void _ZN8S27C7_nt4v157Ev();
extern void _ZN8S27C7_nt4v158Ev();
extern void _ZN8S27C7_nt4v159Ev();
extern void _ZN8S27C7_nt4v160Ev();
extern void _ZN8S27C7_nt4v161Ev();
extern void _ZN8S27C7_nt4v162Ev();
extern void _ZN8S27C7_nt4v163Ev();
extern void _ZN8S27C7_nt4v164Ev();
extern void _ZN8S27C7_nt4v165Ev();
extern void _ZN8S27C7_nt4v166Ev();
extern void _ZN8S27C7_nt4v167Ev();
extern void _ZN8S27C7_nt4v168Ev();
extern void _ZN8S27C7_nt4v169Ev();
extern void _ZN8S27C7_nt4v170Ev();
extern void _ZN8S27C7_nt4v171Ev();
extern void _ZN8S27C7_nt4v172Ev();
extern void _ZN8S27C7_nt4v173Ev();
extern void _ZN8S27C7_nt4v174Ev();
extern void _ZN8S27C7_nt4v175Ev();
extern void _ZN8S27C7_nt4v176Ev();
extern void _ZN8S27C7_nt4v177Ev();
extern void _ZN8S27C7_nt4v178Ev();
extern void _ZN8S27C7_nt4v179Ev();
extern void _ZN8S27C7_nt4v180Ev();
extern void _ZN8S27C7_nt4v181Ev();
extern void _ZN8S27C7_nt4v182Ev();
extern void _ZN8S27C7_nt4v183Ev();
extern void _ZN8S27C7_nt4v184Ev();
extern void _ZN8S27C7_nt4v185Ev();
extern void _ZN8S27C7_nt4v186Ev();
extern void _ZN8S27C7_nt4v187Ev();
extern void _ZN8S27C7_nt4v188Ev();
extern void _ZN8S27C7_nt4v189Ev();
extern void _ZN8S27C7_nt4v190Ev();
extern void _ZN8S27C7_nt4v191Ev();
extern void _ZN8S27C7_nt4v192Ev();
extern void _ZN8S27C7_nt4v193Ev();
extern void _ZN8S27C7_nt4v194Ev();
extern void _ZN8S27C7_nt4v195Ev();
extern void _ZN8S27C7_nt4v196Ev();
extern void _ZN8S27C7_nt4v197Ev();
extern void _ZN8S27C7_nt4v198Ev();
extern void _ZN8S27C7_nt4v199Ev();
extern void _ZN8S27C7_nt4v200Ev();
extern void _ZN8S27C7_nt4v201Ev();
extern void _ZN8S27C7_nt4v202Ev();
extern void _ZN8S27C7_nt4v203Ev();
extern void _ZN8S27C7_nt4v204Ev();
extern void _ZN8S27C7_nt4v205Ev();
extern void _ZN8S27C7_nt4v206Ev();
extern void _ZN8S27C7_nt4v207Ev();
extern void _ZN8S27C7_nt4v208Ev();
extern void _ZN8S27C7_nt4v209Ev();
extern void _ZN8S27C7_nt4v210Ev();
extern void _ZN8S27C6_nt4v211Ev();
extern void _ZN8S27C6_nt4v212Ev();
extern void _ZN8S27C6_nt4v213Ev();
extern void _ZN8S27C6_nt4v214Ev();
extern void _ZN8S27C6_nt4v215Ev();
extern void _ZN8S27C6_nt4v216Ev();
extern void _ZN8S27C6_nt4v217Ev();
extern void _ZN8S27C6_nt4v218Ev();
extern void _ZN8S27C6_nt4v219Ev();
extern void _ZN8S27C6_nt4v220Ev();
extern void _ZN8S27C6_nt4v221Ev();
extern void _ZN8S27C6_nt4v222Ev();
extern void _ZN8S27C6_nt4v223Ev();
extern void _ZN8S27C6_nt4v224Ev();
extern void _ZN8S27C6_nt4v225Ev();
extern void _ZN8S27C6_nt4v226Ev();
extern void _ZN8S27C6_nt4v227Ev();
extern void _ZN8S27C6_nt4v228Ev();
extern void _ZN8S27C6_nt4v229Ev();
extern void _ZN8S27C6_nt4v230Ev();
extern void _ZN8S27C6_nt4v231Ev();
extern void _ZN8S27C6_nt4v232Ev();
extern void _ZN8S27C6_nt4v233Ev();
extern void _ZN8S27C6_nt4v234Ev();
extern void _ZN8S27C6_nt4v235Ev();
extern void _ZN8S27C6_nt4v236Ev();
extern void _ZN8S27C6_nt4v237Ev();
extern void _ZN8S27C6_nt4v238Ev();
extern void _ZN8S27C6_nt4v239Ev();
extern void _ZN8S27C6_nt4v240Ev();
extern void _ZN8S27C6_nt4v241Ev();
extern void _ZN8S27C6_nt4v242Ev();
extern void _ZN8S27C6_nt4v243Ev();
extern void _ZN8S27C6_nt4v244Ev();
extern void _ZN8S27C6_nt4v245Ev();
extern void _ZN8S27C6_nt4v246Ev();
extern void _ZN8S27C6_nt4v247Ev();
extern void _ZN8S27C6_nt4v248Ev();
extern void _ZN8S27C6_nt4v249Ev();
extern void _ZN8S27C6_nt4v250Ev();
extern void _ZN8S27C6_nt4v251Ev();
extern void _ZN8S27C6_nt4v252Ev();
extern void _ZN8S27C6_nt4v253Ev();
extern void _ZN8S27C6_nt4v254Ev();
extern void _ZN8S27C6_nt4v255Ev();
extern void _ZN8S27C6_nt4v256Ev();
extern void _ZN8S27C6_nt4v257Ev();
extern void _ZN8S27C6_nt4v258Ev();
extern void _ZN8S27C6_nt4v259Ev();
extern void _ZN8S27C6_nt4v260Ev();
extern void _ZN8S27C6_nt4v261Ev();
extern void _ZN8S27C6_nt4v262Ev();
extern void _ZN8S27C6_nt4v263Ev();
extern void _ZN8S27C6_nt4v264Ev();
extern void _ZN8S27C6_nt4v265Ev();
extern void _ZN8S27C6_nt4v266Ev();
extern void _ZN8S27C6_nt4v267Ev();
extern void _ZN8S27C6_nt4v268Ev();
extern void _ZN8S27C6_nt4v269Ev();
extern void _ZN8S27C6_nt4v270Ev();
extern void _ZN8S27C6_nt4v271Ev();
extern void _ZN8S27C6_nt4v272Ev();
extern void _ZN8S27C6_nt4v273Ev();
extern void _ZN8S27C6_nt4v274Ev();
extern void _ZN8S27C6_nt4v275Ev();
extern void _ZN8S27C6_nt4v276Ev();
extern void _ZN8S27C6_nt4v277Ev();
extern void _ZN8S27C6_nt4v278Ev();
extern void _ZN8S27C6_nt4v279Ev();
extern void _ZN8S27C6_nt4v280Ev();
extern void _ZN8S27C6_nt4v281Ev();
extern void _ZN8S27C6_nt4v282Ev();
extern void _ZN8S27C6_nt4v283Ev();
extern void _ZN8S27C6_nt4v284Ev();
extern void _ZN8S27C6_nt4v285Ev();
extern void _ZN8S27C6_nt4v286Ev();
extern void _ZN8S27C6_nt4v287Ev();
extern void _ZN8S27C6_nt4v288Ev();
extern void _ZN8S27C6_nt4v289Ev();
extern void _ZN8S27C6_nt4v290Ev();
extern void _ZN8S27C6_nt4v291Ev();
extern void _ZN8S27C6_nt4v292Ev();
extern void _ZN8S27C6_nt4v293Ev();
extern void _ZN8S27C6_nt4v294Ev();
extern void _ZN8S27C6_nt4v295Ev();
extern void _ZN8S27C6_nt4v296Ev();
extern void _ZN8S27C6_nt4v297Ev();
extern void _ZN8S27C6_nt4v298Ev();
extern void _ZN8S27C6_nt4v299Ev();
extern void _ZN8S27C6_nt4v300Ev();
extern void _ZN8S27C6_nt4v301Ev();
extern void _ZN8S27C6_nt4v302Ev();
extern void _ZN8S27C6_nt4v303Ev();
extern void _ZN8S27C6_nt4v304Ev();
extern void _ZN8S27C6_nt4v305Ev();
extern void _ZN8S27C6_nt4v306Ev();
extern void _ZN8S27C6_nt4v307Ev();
extern void _ZN8S27C6_nt4v308Ev();
extern void _ZN8S27C5_nt4v309Ev();
extern void _ZN8S27C5_nt4v310Ev();
extern void _ZN8S27C5_nt4v311Ev();
extern void _ZN8S27C5_nt4v312Ev();
extern void _ZN8S27C5_nt4v313Ev();
extern void _ZN8S27C5_nt4v314Ev();
extern void _ZN8S27C5_nt4v315Ev();
extern void _ZN8S27C5_nt4v316Ev();
extern void _ZN8S27C5_nt4v317Ev();
extern void _ZN8S27C5_nt4v318Ev();
extern void _ZN8S27C5_nt4v319Ev();
extern void _ZN8S27C5_nt4v320Ev();
extern void _ZN8S27C5_nt4v321Ev();
extern void _ZN8S27C5_nt4v322Ev();
extern void _ZN8S27C5_nt4v323Ev();
extern void _ZN8S27C5_nt4v324Ev();
extern void _ZN8S27C5_nt4v325Ev();
extern void _ZN8S27C5_nt4v326Ev();
extern void _ZN8S27C5_nt4v327Ev();
extern void _ZN8S27C5_nt4v328Ev();
extern void _ZN8S27C5_nt4v329Ev();
extern void _ZN8S27C5_nt4v330Ev();
extern void _ZN8S27C4_nt4v331Ev();
extern void _ZN8S27C4_nt4v332Ev();
extern void _ZN8S27C4_nt4v333Ev();
extern void _ZN8S27C4_nt4v334Ev();
extern void _ZN8S27C4_nt4v335Ev();
extern void _ZN8S27C4_nt4v336Ev();
extern void _ZN8S27C4_nt4v337Ev();
extern void _ZN8S27C4_nt4v338Ev();
extern void _ZN8S27C4_nt4v339Ev();
extern void _ZN8S27C4_nt4v340Ev();
extern void _ZN8S27C4_nt4v341Ev();
extern void _ZN8S27C4_nt4v342Ev();
extern void _ZN8S27C4_nt4v343Ev();
extern void _ZN8S27C4_nt4v344Ev();
extern void _ZN8S27C4_nt4v345Ev();
extern void _ZN8S27C4_nt4v346Ev();
extern void _ZN8S27C4_nt4v347Ev();
extern void _ZN8S27C4_nt4v348Ev();
extern void _ZN8S27C4_nt4v349Ev();
extern void _ZN8S27C4_nt4v350Ev();
extern void _ZN8S27C4_nt4v351Ev();
extern void _ZN8S27C4_nt4v352Ev();
extern void _ZN8S27C4_nt4v353Ev();
extern void _ZN8S27C4_nt4v354Ev();
static  VTBL_ENTRY vtc_S27C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S27C4_nt[0]),
  (VTBL_ENTRY)&_ZN8S27C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S27C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v223Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v224Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v225Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v226Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v227Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v228Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v229Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v230Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v231Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v232Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v234Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v235Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v236Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v237Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v238Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v239Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v240Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v241Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v242Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v243Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v244Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v245Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v246Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v247Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v248Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v249Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v250Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v251Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v252Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v253Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v254Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v255Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v256Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v257Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v258Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v259Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v260Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v261Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v262Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v263Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v264Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v265Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v266Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v267Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v268Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v269Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v270Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v271Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v272Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v273Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v274Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v275Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v276Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v277Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v278Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v279Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v280Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v281Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v282Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v283Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v284Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v285Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v286Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v287Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v288Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v289Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v290Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v291Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v292Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v293Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v294Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v295Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v296Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v297Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v298Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v299Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v300Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v301Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v302Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v303Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v304Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v305Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v306Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v307Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v308Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v309Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v310Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v311Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v312Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v313Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v314Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v315Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v316Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v317Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v318Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v319Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v320Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v321Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v322Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v323Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v324Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v325Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v326Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v327Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v328Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v329Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v330Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v331Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v332Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v333Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v334Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v335Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v336Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v337Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v338Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v339Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v340Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v341Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v342Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v343Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v344Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v345Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v346Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v347Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v348Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v349Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v350Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v351Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v352Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v353Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v354Ev,
};
extern VTBL_ENTRY _ZTI8S27C4_nt[];
VTBL_ENTRY *P__ZTI8S27C4_nt = _ZTI8S27C4_nt; 
extern  VTBL_ENTRY _ZTV8S27C4_nt[];
Class_Descriptor cd_S27C4_nt = {  "S27C4_nt", // class name
  bases_S27C4_nt, 4,
  &(vtc_S27C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1648,1324), // object size
  NSPAIRA(_ZTI8S27C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S27C4_nt),355, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C3_nt  : S27C4_nt {
  unsigned int s27c3f0:1;
  void *s27c3f1;
  ::S27C35_nt s27c3f2;
  virtual  ~S27C3_nt(); // _ZN8S27C3_ntD1Ev
  virtual void  v355(); // _ZN8S27C3_nt4v355Ev
  virtual void  v356(); // _ZN8S27C3_nt4v356Ev
  virtual void  v357(); // _ZN8S27C3_nt4v357Ev
  S27C3_nt(); // tgen
};
//SIG(-1 S27C3_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 FC11{ m Fi} Fi Fc[4] Fp[2] FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC7 FC7 FC7 FC12{ BC13{ BC10}} FC12 Fi Fp[2] FC14{ m Fi[3]} FC14 FC14 FC14 Fp FC7 FC12 FC14 FC14 Fi FC14 FC14 Fp Fi Fc FC14 FC14 Fp Fi Fp FC12 FC15{ BC16{ BC10}} FC15} vd v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC14 Fi[19] FC14 Fi[2] Fp Fi[5] FC14 FC14 Fi Fp Fi FC14 Fi Fp Fi[3] FC17{ BC18{ BC19{ BC10}}} Fp[3] FC7 FC7 Fp Fi FC14 Fp FC14 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC14 FC14 Fi Fp[2] Fi} vd v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 v328 v329 v330 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC20{ BC21{ BC10}} Fi FC14 Fi[3] FC14 Fi[2] Fp Fi[2] Fc Fi[8]} vd v331 v332 v333 v334 v335 v336 v337 v338 v339 v340 v341 v342 v343 v344 v345 v346 v347 v348 v349 v350 v351 v352 v353 v354 Fp FC20 FC14 FC14 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[4] Fp[2] Fi[8] Fp[5] Fi[13] FC14 Fi[3] FC22{ FC23{ m FC14 FC24{ m Fi[4]} FC14 FC14 Fc} Fc[4] Fi:1 Fi} Fi[2]} vd v1 v2 v3 Fi:1 Fp FC24}


 S27C3_nt ::~S27C3_nt(){ note_dtor("S27C3_nt", this);}
void  S27C3_nt ::v355(){vfunc_called(this, "_ZN8S27C3_nt4v355Ev");}
void  S27C3_nt ::v356(){vfunc_called(this, "_ZN8S27C3_nt4v356Ev");}
void  S27C3_nt ::v357(){vfunc_called(this, "_ZN8S27C3_nt4v357Ev");}
S27C3_nt ::S27C3_nt(){ note_ctor("S27C3_nt", this);} // tgen

//skip512 S27C3_nt

#else // __cplusplus

extern void _ZN8S27C3_ntC1Ev();
extern void _ZN8S27C3_ntD1Ev();
Name_Map name_map_S27C3_nt[] = {
  NSPAIR(_ZN8S27C3_ntC1Ev),
  NSPAIR(_ZN8S27C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S27C8_nt;
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
extern Class_Descriptor cd_S27C7_nt;
extern VTBL_ENTRY _ZTI8S27C7_nt[];
extern  VTBL_ENTRY _ZTV8S27C7_nt[];
extern Class_Descriptor cd_S27C6_nt;
extern VTBL_ENTRY _ZTI8S27C6_nt[];
extern  VTBL_ENTRY _ZTV8S27C6_nt[];
extern Class_Descriptor cd_S27C5_nt;
extern VTBL_ENTRY _ZTI8S27C5_nt[];
extern  VTBL_ENTRY _ZTV8S27C5_nt[];
extern Class_Descriptor cd_S27C4_nt;
extern VTBL_ENTRY _ZTI8S27C4_nt[];
extern  VTBL_ENTRY _ZTV8S27C4_nt[];
static Base_Class bases_S27C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S27C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S27C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S27C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S27C3_nt[];
extern void _ZN8S27C3_ntD1Ev();
extern void _ZN8S27C3_ntD0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
extern void _ZN8S27C7_nt3v68Ev();
extern void _ZN8S27C7_nt3v69Ev();
extern void _ZN8S27C7_nt3v70Ev();
extern void _ZN8S27C7_nt3v71Ev();
extern void _ZN8S27C7_nt3v72Ev();
extern void _ZN8S27C7_nt3v73Ev();
extern void _ZN8S27C7_nt3v74Ev();
extern void _ZN8S27C7_nt3v75Ev();
extern void _ZN8S27C7_nt3v76Ev();
extern void _ZN8S27C7_nt3v77Ev();
extern void _ZN8S27C7_nt3v78Ev();
extern void _ZN8S27C7_nt3v79Ev();
extern void _ZN8S27C7_nt3v80Ev();
extern void _ZN8S27C7_nt3v81Ev();
extern void _ZN8S27C7_nt3v82Ev();
extern void _ZN8S27C7_nt3v83Ev();
extern void _ZN8S27C7_nt3v84Ev();
extern void _ZN8S27C7_nt3v85Ev();
extern void _ZN8S27C7_nt3v86Ev();
extern void _ZN8S27C7_nt3v87Ev();
extern void _ZN8S27C7_nt3v88Ev();
extern void _ZN8S27C7_nt3v89Ev();
extern void _ZN8S27C7_nt3v90Ev();
extern void _ZN8S27C7_nt3v91Ev();
extern void _ZN8S27C7_nt3v92Ev();
extern void _ZN8S27C7_nt3v93Ev();
extern void _ZN8S27C7_nt3v94Ev();
extern void _ZN8S27C7_nt3v95Ev();
extern void _ZN8S27C7_nt3v96Ev();
extern void _ZN8S27C7_nt3v97Ev();
extern void _ZN8S27C7_nt3v98Ev();
extern void _ZN8S27C7_nt3v99Ev();
extern void _ZN8S27C7_nt4v100Ev();
extern void _ZN8S27C7_nt4v101Ev();
extern void _ZN8S27C7_nt4v102Ev();
extern void _ZN8S27C7_nt4v103Ev();
extern void _ZN8S27C7_nt4v104Ev();
extern void _ZN8S27C7_nt4v105Ev();
extern void _ZN8S27C7_nt4v106Ev();
extern void _ZN8S27C7_nt4v107Ev();
extern void _ZN8S27C7_nt4v108Ev();
extern void _ZN8S27C7_nt4v109Ev();
extern void _ZN8S27C7_nt4v110Ev();
extern void _ZN8S27C7_nt4v111Ev();
extern void _ZN8S27C7_nt4v112Ev();
extern void _ZN8S27C7_nt4v113Ev();
extern void _ZN8S27C7_nt4v114Ev();
extern void _ZN8S27C7_nt4v115Ev();
extern void _ZN8S27C7_nt4v116Ev();
extern void _ZN8S27C7_nt4v117Ev();
extern void _ZN8S27C7_nt4v118Ev();
extern void _ZN8S27C7_nt4v119Ev();
extern void _ZN8S27C7_nt4v120Ev();
extern void _ZN8S27C7_nt4v121Ev();
extern void _ZN8S27C7_nt4v122Ev();
extern void _ZN8S27C7_nt4v123Ev();
extern void _ZN8S27C7_nt4v124Ev();
extern void _ZN8S27C7_nt4v125Ev();
extern void _ZN8S27C7_nt4v126Ev();
extern void _ZN8S27C7_nt4v127Ev();
extern void _ZN8S27C7_nt4v128Ev();
extern void _ZN8S27C7_nt4v129Ev();
extern void _ZN8S27C7_nt4v130Ev();
extern void _ZN8S27C7_nt4v131Ev();
extern void _ZN8S27C7_nt4v132Ev();
extern void _ZN8S27C7_nt4v133Ev();
extern void _ZN8S27C7_nt4v134Ev();
extern void _ZN8S27C7_nt4v135Ev();
extern void _ZN8S27C7_nt4v136Ev();
extern void _ZN8S27C7_nt4v137Ev();
extern void _ZN8S27C7_nt4v138Ev();
extern void _ZN8S27C7_nt4v139Ev();
extern void _ZN8S27C7_nt4v140Ev();
extern void _ZN8S27C7_nt4v141Ev();
extern void _ZN8S27C7_nt4v142Ev();
extern void _ZN8S27C7_nt4v143Ev();
extern void _ZN8S27C7_nt4v144Ev();
extern void _ZN8S27C7_nt4v145Ev();
extern void _ZN8S27C7_nt4v146Ev();
extern void _ZN8S27C7_nt4v147Ev();
extern void _ZN8S27C7_nt4v148Ev();
extern void _ZN8S27C7_nt4v149Ev();
extern void _ZN8S27C7_nt4v150Ev();
extern void _ZN8S27C7_nt4v151Ev();
extern void _ZN8S27C7_nt4v152Ev();
extern void _ZN8S27C7_nt4v153Ev();
extern void _ZN8S27C7_nt4v154Ev();
extern void _ZN8S27C7_nt4v155Ev();
extern void _ZN8S27C7_nt4v156Ev();
extern void _ZN8S27C7_nt4v157Ev();
extern void _ZN8S27C7_nt4v158Ev();
extern void _ZN8S27C7_nt4v159Ev();
extern void _ZN8S27C7_nt4v160Ev();
extern void _ZN8S27C7_nt4v161Ev();
extern void _ZN8S27C7_nt4v162Ev();
extern void _ZN8S27C7_nt4v163Ev();
extern void _ZN8S27C7_nt4v164Ev();
extern void _ZN8S27C7_nt4v165Ev();
extern void _ZN8S27C7_nt4v166Ev();
extern void _ZN8S27C7_nt4v167Ev();
extern void _ZN8S27C7_nt4v168Ev();
extern void _ZN8S27C7_nt4v169Ev();
extern void _ZN8S27C7_nt4v170Ev();
extern void _ZN8S27C7_nt4v171Ev();
extern void _ZN8S27C7_nt4v172Ev();
extern void _ZN8S27C7_nt4v173Ev();
extern void _ZN8S27C7_nt4v174Ev();
extern void _ZN8S27C7_nt4v175Ev();
extern void _ZN8S27C7_nt4v176Ev();
extern void _ZN8S27C7_nt4v177Ev();
extern void _ZN8S27C7_nt4v178Ev();
extern void _ZN8S27C7_nt4v179Ev();
extern void _ZN8S27C7_nt4v180Ev();
extern void _ZN8S27C7_nt4v181Ev();
extern void _ZN8S27C7_nt4v182Ev();
extern void _ZN8S27C7_nt4v183Ev();
extern void _ZN8S27C7_nt4v184Ev();
extern void _ZN8S27C7_nt4v185Ev();
extern void _ZN8S27C7_nt4v186Ev();
extern void _ZN8S27C7_nt4v187Ev();
extern void _ZN8S27C7_nt4v188Ev();
extern void _ZN8S27C7_nt4v189Ev();
extern void _ZN8S27C7_nt4v190Ev();
extern void _ZN8S27C7_nt4v191Ev();
extern void _ZN8S27C7_nt4v192Ev();
extern void _ZN8S27C7_nt4v193Ev();
extern void _ZN8S27C7_nt4v194Ev();
extern void _ZN8S27C7_nt4v195Ev();
extern void _ZN8S27C7_nt4v196Ev();
extern void _ZN8S27C7_nt4v197Ev();
extern void _ZN8S27C7_nt4v198Ev();
extern void _ZN8S27C7_nt4v199Ev();
extern void _ZN8S27C7_nt4v200Ev();
extern void _ZN8S27C7_nt4v201Ev();
extern void _ZN8S27C7_nt4v202Ev();
extern void _ZN8S27C7_nt4v203Ev();
extern void _ZN8S27C7_nt4v204Ev();
extern void _ZN8S27C7_nt4v205Ev();
extern void _ZN8S27C7_nt4v206Ev();
extern void _ZN8S27C7_nt4v207Ev();
extern void _ZN8S27C7_nt4v208Ev();
extern void _ZN8S27C7_nt4v209Ev();
extern void _ZN8S27C7_nt4v210Ev();
extern void _ZN8S27C6_nt4v211Ev();
extern void _ZN8S27C6_nt4v212Ev();
extern void _ZN8S27C6_nt4v213Ev();
extern void _ZN8S27C6_nt4v214Ev();
extern void _ZN8S27C6_nt4v215Ev();
extern void _ZN8S27C6_nt4v216Ev();
extern void _ZN8S27C6_nt4v217Ev();
extern void _ZN8S27C6_nt4v218Ev();
extern void _ZN8S27C6_nt4v219Ev();
extern void _ZN8S27C6_nt4v220Ev();
extern void _ZN8S27C6_nt4v221Ev();
extern void _ZN8S27C6_nt4v222Ev();
extern void _ZN8S27C6_nt4v223Ev();
extern void _ZN8S27C6_nt4v224Ev();
extern void _ZN8S27C6_nt4v225Ev();
extern void _ZN8S27C6_nt4v226Ev();
extern void _ZN8S27C6_nt4v227Ev();
extern void _ZN8S27C6_nt4v228Ev();
extern void _ZN8S27C6_nt4v229Ev();
extern void _ZN8S27C6_nt4v230Ev();
extern void _ZN8S27C6_nt4v231Ev();
extern void _ZN8S27C6_nt4v232Ev();
extern void _ZN8S27C6_nt4v233Ev();
extern void _ZN8S27C6_nt4v234Ev();
extern void _ZN8S27C6_nt4v235Ev();
extern void _ZN8S27C6_nt4v236Ev();
extern void _ZN8S27C6_nt4v237Ev();
extern void _ZN8S27C6_nt4v238Ev();
extern void _ZN8S27C6_nt4v239Ev();
extern void _ZN8S27C6_nt4v240Ev();
extern void _ZN8S27C6_nt4v241Ev();
extern void _ZN8S27C6_nt4v242Ev();
extern void _ZN8S27C6_nt4v243Ev();
extern void _ZN8S27C6_nt4v244Ev();
extern void _ZN8S27C6_nt4v245Ev();
extern void _ZN8S27C6_nt4v246Ev();
extern void _ZN8S27C6_nt4v247Ev();
extern void _ZN8S27C6_nt4v248Ev();
extern void _ZN8S27C6_nt4v249Ev();
extern void _ZN8S27C6_nt4v250Ev();
extern void _ZN8S27C6_nt4v251Ev();
extern void _ZN8S27C6_nt4v252Ev();
extern void _ZN8S27C6_nt4v253Ev();
extern void _ZN8S27C6_nt4v254Ev();
extern void _ZN8S27C6_nt4v255Ev();
extern void _ZN8S27C6_nt4v256Ev();
extern void _ZN8S27C6_nt4v257Ev();
extern void _ZN8S27C6_nt4v258Ev();
extern void _ZN8S27C6_nt4v259Ev();
extern void _ZN8S27C6_nt4v260Ev();
extern void _ZN8S27C6_nt4v261Ev();
extern void _ZN8S27C6_nt4v262Ev();
extern void _ZN8S27C6_nt4v263Ev();
extern void _ZN8S27C6_nt4v264Ev();
extern void _ZN8S27C6_nt4v265Ev();
extern void _ZN8S27C6_nt4v266Ev();
extern void _ZN8S27C6_nt4v267Ev();
extern void _ZN8S27C6_nt4v268Ev();
extern void _ZN8S27C6_nt4v269Ev();
extern void _ZN8S27C6_nt4v270Ev();
extern void _ZN8S27C6_nt4v271Ev();
extern void _ZN8S27C6_nt4v272Ev();
extern void _ZN8S27C6_nt4v273Ev();
extern void _ZN8S27C6_nt4v274Ev();
extern void _ZN8S27C6_nt4v275Ev();
extern void _ZN8S27C6_nt4v276Ev();
extern void _ZN8S27C6_nt4v277Ev();
extern void _ZN8S27C6_nt4v278Ev();
extern void _ZN8S27C6_nt4v279Ev();
extern void _ZN8S27C6_nt4v280Ev();
extern void _ZN8S27C6_nt4v281Ev();
extern void _ZN8S27C6_nt4v282Ev();
extern void _ZN8S27C6_nt4v283Ev();
extern void _ZN8S27C6_nt4v284Ev();
extern void _ZN8S27C6_nt4v285Ev();
extern void _ZN8S27C6_nt4v286Ev();
extern void _ZN8S27C6_nt4v287Ev();
extern void _ZN8S27C6_nt4v288Ev();
extern void _ZN8S27C6_nt4v289Ev();
extern void _ZN8S27C6_nt4v290Ev();
extern void _ZN8S27C6_nt4v291Ev();
extern void _ZN8S27C6_nt4v292Ev();
extern void _ZN8S27C6_nt4v293Ev();
extern void _ZN8S27C6_nt4v294Ev();
extern void _ZN8S27C6_nt4v295Ev();
extern void _ZN8S27C6_nt4v296Ev();
extern void _ZN8S27C6_nt4v297Ev();
extern void _ZN8S27C6_nt4v298Ev();
extern void _ZN8S27C6_nt4v299Ev();
extern void _ZN8S27C6_nt4v300Ev();
extern void _ZN8S27C6_nt4v301Ev();
extern void _ZN8S27C6_nt4v302Ev();
extern void _ZN8S27C6_nt4v303Ev();
extern void _ZN8S27C6_nt4v304Ev();
extern void _ZN8S27C6_nt4v305Ev();
extern void _ZN8S27C6_nt4v306Ev();
extern void _ZN8S27C6_nt4v307Ev();
extern void _ZN8S27C6_nt4v308Ev();
extern void _ZN8S27C5_nt4v309Ev();
extern void _ZN8S27C5_nt4v310Ev();
extern void _ZN8S27C5_nt4v311Ev();
extern void _ZN8S27C5_nt4v312Ev();
extern void _ZN8S27C5_nt4v313Ev();
extern void _ZN8S27C5_nt4v314Ev();
extern void _ZN8S27C5_nt4v315Ev();
extern void _ZN8S27C5_nt4v316Ev();
extern void _ZN8S27C5_nt4v317Ev();
extern void _ZN8S27C5_nt4v318Ev();
extern void _ZN8S27C5_nt4v319Ev();
extern void _ZN8S27C5_nt4v320Ev();
extern void _ZN8S27C5_nt4v321Ev();
extern void _ZN8S27C5_nt4v322Ev();
extern void _ZN8S27C5_nt4v323Ev();
extern void _ZN8S27C5_nt4v324Ev();
extern void _ZN8S27C5_nt4v325Ev();
extern void _ZN8S27C5_nt4v326Ev();
extern void _ZN8S27C5_nt4v327Ev();
extern void _ZN8S27C5_nt4v328Ev();
extern void _ZN8S27C5_nt4v329Ev();
extern void _ZN8S27C5_nt4v330Ev();
extern void _ZN8S27C4_nt4v331Ev();
extern void _ZN8S27C4_nt4v332Ev();
extern void _ZN8S27C4_nt4v333Ev();
extern void _ZN8S27C4_nt4v334Ev();
extern void _ZN8S27C4_nt4v335Ev();
extern void _ZN8S27C4_nt4v336Ev();
extern void _ZN8S27C4_nt4v337Ev();
extern void _ZN8S27C4_nt4v338Ev();
extern void _ZN8S27C4_nt4v339Ev();
extern void _ZN8S27C4_nt4v340Ev();
extern void _ZN8S27C4_nt4v341Ev();
extern void _ZN8S27C4_nt4v342Ev();
extern void _ZN8S27C4_nt4v343Ev();
extern void _ZN8S27C4_nt4v344Ev();
extern void _ZN8S27C4_nt4v345Ev();
extern void _ZN8S27C4_nt4v346Ev();
extern void _ZN8S27C4_nt4v347Ev();
extern void _ZN8S27C4_nt4v348Ev();
extern void _ZN8S27C4_nt4v349Ev();
extern void _ZN8S27C4_nt4v350Ev();
extern void _ZN8S27C4_nt4v351Ev();
extern void _ZN8S27C4_nt4v352Ev();
extern void _ZN8S27C4_nt4v353Ev();
extern void _ZN8S27C4_nt4v354Ev();
extern void _ZN8S27C3_nt4v355Ev();
extern void _ZN8S27C3_nt4v356Ev();
extern void _ZN8S27C3_nt4v357Ev();
static  VTBL_ENTRY vtc_S27C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S27C3_nt[0]),
  (VTBL_ENTRY)&_ZN8S27C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S27C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v223Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v224Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v225Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v226Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v227Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v228Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v229Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v230Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v231Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v232Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v234Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v235Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v236Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v237Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v238Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v239Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v240Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v241Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v242Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v243Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v244Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v245Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v246Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v247Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v248Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v249Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v250Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v251Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v252Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v253Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v254Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v255Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v256Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v257Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v258Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v259Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v260Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v261Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v262Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v263Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v264Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v265Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v266Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v267Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v268Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v269Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v270Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v271Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v272Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v273Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v274Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v275Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v276Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v277Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v278Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v279Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v280Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v281Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v282Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v283Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v284Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v285Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v286Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v287Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v288Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v289Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v290Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v291Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v292Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v293Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v294Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v295Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v296Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v297Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v298Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v299Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v300Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v301Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v302Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v303Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v304Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v305Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v306Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v307Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v308Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v309Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v310Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v311Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v312Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v313Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v314Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v315Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v316Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v317Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v318Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v319Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v320Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v321Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v322Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v323Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v324Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v325Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v326Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v327Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v328Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v329Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v330Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v331Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v332Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v333Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v334Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v335Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v336Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v337Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v338Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v339Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v340Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v341Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v342Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v343Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v344Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v345Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v346Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v347Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v348Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v349Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v350Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v351Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v352Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v353Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v354Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v355Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v356Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v357Ev,
};
extern VTBL_ENTRY _ZTI8S27C3_nt[];
VTBL_ENTRY *P__ZTI8S27C3_nt = _ZTI8S27C3_nt; 
extern  VTBL_ENTRY _ZTV8S27C3_nt[];
Class_Descriptor cd_S27C3_nt = {  "S27C3_nt", // class name
  bases_S27C3_nt, 5,
  &(vtc_S27C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1680,1348), // object size
  NSPAIRA(_ZTI8S27C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S27C3_nt),358, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C38  : S27C12_nt {
};
//SIG(-1 S27C38) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C38()
{
  extern Class_Descriptor cd_S27C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C38, buf);
    S27C38 &lv = *(new (buf) S27C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C38)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C38");
    test_class_info(&lv, &cd_S27C38);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C38(Test_S27C38, "S27C38", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C38 = {  "S27C38", // class name
  bases_S27C38, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C37  : S27C38 {
};
//SIG(-1 S27C37) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C37()
{
  extern Class_Descriptor cd_S27C37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C37, buf);
    S27C37 &lv = *(new (buf) S27C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C37)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C38*), 0, "S27C37");
    check_base_class_offset(lv, (S27C38*), 0, "S27C37");
    test_class_info(&lv, &cd_S27C37);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C37(Test_S27C37, "S27C37", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C38;
static Base_Class bases_S27C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C37 = {  "S27C37", // class name
  bases_S27C37, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C41_nt  {
  void *s27c41f0;
  ::S27C26_nt s27c41f1;
  void  mf27c41(); // _ZN9S27C41_nt7mf27c41Ev
};
//SIG(-1 S27C41_nt) C1{ m Fp FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}}}


void  S27C41_nt ::mf27c41(){}

//skip512 S27C41_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C43  : S27C12_nt {
};
//SIG(-1 S27C43) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C43()
{
  extern Class_Descriptor cd_S27C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C43, buf);
    S27C43 &lv = *(new (buf) S27C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C43)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C43");
    test_class_info(&lv, &cd_S27C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C43(Test_S27C43, "S27C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C43 = {  "S27C43", // class name
  bases_S27C43, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C42  : S27C43 {
};
//SIG(-1 S27C42) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C42()
{
  extern Class_Descriptor cd_S27C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C42, buf);
    S27C42 &lv = *(new (buf) S27C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C42)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C43*), 0, "S27C42");
    check_base_class_offset(lv, (S27C43*), 0, "S27C42");
    test_class_info(&lv, &cd_S27C42);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C42(Test_S27C42, "S27C42", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C43;
static Base_Class bases_S27C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C42 = {  "S27C42", // class name
  bases_S27C42, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C47  : S27C12_nt {
};
//SIG(-1 S27C47) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C47()
{
  extern Class_Descriptor cd_S27C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C47, buf);
    S27C47 &lv = *(new (buf) S27C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C47)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C47");
    test_class_info(&lv, &cd_S27C47);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C47(Test_S27C47, "S27C47", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C47 = {  "S27C47", // class name
  bases_S27C47, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C46  : S27C47 {
};
//SIG(-1 S27C46) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C46()
{
  extern Class_Descriptor cd_S27C46;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C46, buf);
    S27C46 &lv = *(new (buf) S27C46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C46)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C47*), 0, "S27C46");
    check_base_class_offset(lv, (S27C47*), 0, "S27C46");
    test_class_info(&lv, &cd_S27C46);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C46(Test_S27C46, "S27C46", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C47;
static Base_Class bases_S27C46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C47,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C46 = {  "S27C46", // class name
  bases_S27C46, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C51  : S27C12_nt {
};
//SIG(-1 S27C51) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C51()
{
  extern Class_Descriptor cd_S27C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C51, buf);
    S27C51 &lv = *(new (buf) S27C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C51)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C51");
    test_class_info(&lv, &cd_S27C51);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C51(Test_S27C51, "S27C51", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C51 = {  "S27C51", // class name
  bases_S27C51, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C50  : S27C51 {
};
//SIG(-1 S27C50) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C50()
{
  extern Class_Descriptor cd_S27C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C50, buf);
    S27C50 &lv = *(new (buf) S27C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C50)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C51*), 0, "S27C50");
    check_base_class_offset(lv, (S27C51*), 0, "S27C50");
    test_class_info(&lv, &cd_S27C50);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C50(Test_S27C50, "S27C50", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C51;
static Base_Class bases_S27C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C51,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C50 = {  "S27C50", // class name
  bases_S27C50, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C55  : S27C12_nt {
};
//SIG(-1 S27C55) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C55()
{
  extern Class_Descriptor cd_S27C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C55, buf);
    S27C55 &lv = *(new (buf) S27C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C55)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C55");
    test_class_info(&lv, &cd_S27C55);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C55(Test_S27C55, "S27C55", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C55 = {  "S27C55", // class name
  bases_S27C55, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C54  : S27C55 {
};
//SIG(-1 S27C54) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C54()
{
  extern Class_Descriptor cd_S27C54;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C54, buf);
    S27C54 &lv = *(new (buf) S27C54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C54)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C55*), 0, "S27C54");
    check_base_class_offset(lv, (S27C55*), 0, "S27C54");
    test_class_info(&lv, &cd_S27C54);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C54(Test_S27C54, "S27C54", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C55;
static Base_Class bases_S27C54[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C55,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C54 = {  "S27C54", // class name
  bases_S27C54, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C59  : S27C12_nt {
};
//SIG(-1 S27C59) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C59()
{
  extern Class_Descriptor cd_S27C59;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C59, buf);
    S27C59 &lv = *(new (buf) S27C59());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C59)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C59");
    test_class_info(&lv, &cd_S27C59);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C59(Test_S27C59, "S27C59", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C59[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C59 = {  "S27C59", // class name
  bases_S27C59, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C58  : S27C59 {
};
//SIG(-1 S27C58) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C58()
{
  extern Class_Descriptor cd_S27C58;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C58, buf);
    S27C58 &lv = *(new (buf) S27C58());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C58)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C59*), 0, "S27C58");
    check_base_class_offset(lv, (S27C59*), 0, "S27C58");
    test_class_info(&lv, &cd_S27C58);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C58(Test_S27C58, "S27C58", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C59;
static Base_Class bases_S27C58[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C59,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C58 = {  "S27C58", // class name
  bases_S27C58, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C63  : S27C12_nt {
};
//SIG(-1 S27C63) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C63()
{
  extern Class_Descriptor cd_S27C63;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C63, buf);
    S27C63 &lv = *(new (buf) S27C63());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C63)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C63");
    test_class_info(&lv, &cd_S27C63);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C63(Test_S27C63, "S27C63", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C63[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C63 = {  "S27C63", // class name
  bases_S27C63, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C62  : S27C63 {
};
//SIG(-1 S27C62) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C62()
{
  extern Class_Descriptor cd_S27C62;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C62, buf);
    S27C62 &lv = *(new (buf) S27C62());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C62)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C63*), 0, "S27C62");
    check_base_class_offset(lv, (S27C63*), 0, "S27C62");
    test_class_info(&lv, &cd_S27C62);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C62(Test_S27C62, "S27C62", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C63;
static Base_Class bases_S27C62[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C63,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C62 = {  "S27C62", // class name
  bases_S27C62, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C67  : S27C12_nt {
};
//SIG(-1 S27C67) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C67()
{
  extern Class_Descriptor cd_S27C67;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C67, buf);
    S27C67 &lv = *(new (buf) S27C67());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C67)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C67)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C67");
    test_class_info(&lv, &cd_S27C67);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C67(Test_S27C67, "S27C67", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C67[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C67 = {  "S27C67", // class name
  bases_S27C67, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C66  : S27C67 {
};
//SIG(-1 S27C66) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C66()
{
  extern Class_Descriptor cd_S27C66;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C66, buf);
    S27C66 &lv = *(new (buf) S27C66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C66)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C67*), 0, "S27C66");
    check_base_class_offset(lv, (S27C67*), 0, "S27C66");
    test_class_info(&lv, &cd_S27C66);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C66(Test_S27C66, "S27C66", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C67;
static Base_Class bases_S27C66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C67,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C66 = {  "S27C66", // class name
  bases_S27C66, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C68_nt  {
  ::S27C66 s27c68f0;
  char s27c68f1;
  void  mf27c68(); // _ZN9S27C68_nt7mf27c68Ev
};
//SIG(-1 S27C68_nt) C1{ m FC2{ BC3{ BC4{ m Fp Fi[2]}}} Fc}


void  S27C68_nt ::mf27c68(){}

//skip512 S27C68_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C72  : S27C12_nt {
};
//SIG(-1 S27C72) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C72()
{
  extern Class_Descriptor cd_S27C72;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C72, buf);
    S27C72 &lv = *(new (buf) S27C72());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C72)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C72)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C72");
    test_class_info(&lv, &cd_S27C72);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C72(Test_S27C72, "S27C72", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C72[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C72 = {  "S27C72", // class name
  bases_S27C72, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C71  : S27C72 {
};
//SIG(-1 S27C71) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C71()
{
  extern Class_Descriptor cd_S27C71;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C71, buf);
    S27C71 &lv = *(new (buf) S27C71());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C71)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C71)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C72*), 0, "S27C71");
    check_base_class_offset(lv, (S27C72*), 0, "S27C71");
    test_class_info(&lv, &cd_S27C71);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C71(Test_S27C71, "S27C71", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C72;
static Base_Class bases_S27C71[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C72,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C71 = {  "S27C71", // class name
  bases_S27C71, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C75_nt  {
  int s27c75f0;
  ::S27C18_nt s27c75f1;
  ::S27C18_nt s27c75f2;
  void *s27c75f3;
  ::S27C9_nt s27c75f4;
};
//SIG(-1 S27C75_nt) C1{ Fi FC2{ m Fi[3]} FC2 Fp FC3{ m Fi[2]}}



//skip512 S27C75_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C77  : S27C12_nt {
};
//SIG(-1 S27C77) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C77()
{
  extern Class_Descriptor cd_S27C77;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C77, buf);
    S27C77 &lv = *(new (buf) S27C77());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C77)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C77)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C77");
    test_class_info(&lv, &cd_S27C77);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C77(Test_S27C77, "S27C77", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C77[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C77 = {  "S27C77", // class name
  bases_S27C77, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C76  : S27C77 {
};
//SIG(-1 S27C76) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C76()
{
  extern Class_Descriptor cd_S27C76;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C76, buf);
    S27C76 &lv = *(new (buf) S27C76());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C76)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C76)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C77*), 0, "S27C76");
    check_base_class_offset(lv, (S27C77*), 0, "S27C76");
    test_class_info(&lv, &cd_S27C76);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C76(Test_S27C76, "S27C76", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C77;
static Base_Class bases_S27C76[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C77,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C76 = {  "S27C76", // class name
  bases_S27C76, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C81  : S27C12_nt {
};
//SIG(-1 S27C81) C1{ BC2{ m Fp Fi[2]}}



static void Test_S27C81()
{
  extern Class_Descriptor cd_S27C81;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C81, buf);
    S27C81 &lv = *(new (buf) S27C81());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C81)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C81)");
    check_base_class_offset(lv, (S27C12_nt*), 0, "S27C81");
    test_class_info(&lv, &cd_S27C81);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C81(Test_S27C81, "S27C81", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
static Base_Class bases_S27C81[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C81 = {  "S27C81", // class name
  bases_S27C81, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C80  : S27C81 {
};
//SIG(-1 S27C80) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S27C80()
{
  extern Class_Descriptor cd_S27C80;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S27C80, buf);
    S27C80 &lv = *(new (buf) S27C80());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S27C80)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C80)");
    check_base_class_offset(lv, (S27C12_nt*)(S27C81*), 0, "S27C80");
    check_base_class_offset(lv, (S27C81*), 0, "S27C80");
    test_class_info(&lv, &cd_S27C80);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C80(Test_S27C80, "S27C80", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S27C12_nt;
extern Class_Descriptor cd_S27C81;
static Base_Class bases_S27C80[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C81,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S27C80 = {  "S27C80", // class name
  bases_S27C80, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C2_nt  : S27C3_nt {
  unsigned int s27c2f0:1;
  unsigned int s27c2f1:1;
  unsigned int s27c2f2:1;
  unsigned int s27c2f3:1;
  unsigned int s27c2f4:1;
  unsigned int s27c2f5:1;
  unsigned int s27c2f6:1;
  unsigned int s27c2f7:1;
  unsigned int s27c2f8:1;
  unsigned int s27c2f9:1;
  unsigned int s27c2f10:1;
  unsigned int s27c2f11:1;
  unsigned int s27c2f12:1;
  unsigned int s27c2f13:1;
  unsigned int s27c2f14:1;
  unsigned int s27c2f15:1;
  unsigned int s27c2f16:1;
  unsigned int s27c2f17:1;
  unsigned int s27c2f18:1;
  unsigned int s27c2f19:1;
  unsigned int s27c2f20:1;
  unsigned int s27c2f21:1;
  unsigned int s27c2f22:1;
  unsigned int s27c2f23:1;
  unsigned int s27c2f24:1;
  unsigned int s27c2f25:1;
  unsigned int s27c2f26:1;
  unsigned int s27c2f27:1;
  unsigned int s27c2f28:1;
  unsigned int s27c2f29:1;
  unsigned int s27c2f30:1;
  unsigned int s27c2f31:1;
  unsigned int s27c2f32:1;
  unsigned int s27c2f33:1;
  unsigned int s27c2f34:1;
  unsigned int s27c2f35:1;
  unsigned int s27c2f36:1;
  unsigned int s27c2f37:1;
  unsigned int s27c2f38:1;
  unsigned int s27c2f39:1;
  unsigned int s27c2f40:1;
  unsigned int s27c2f41:1;
  unsigned int s27c2f42:1;
  unsigned int s27c2f43:1;
  unsigned int s27c2f44:1;
  unsigned int s27c2f45:1;
  unsigned int s27c2f46:1;
  unsigned int s27c2f47:1;
  unsigned int s27c2f48:1;
  unsigned int s27c2f49:1;
  unsigned int s27c2f50:1;
  unsigned int s27c2f51:1;
  unsigned int s27c2f52:1;
  unsigned int s27c2f53:1;
  unsigned int s27c2f54:1;
  unsigned int s27c2f55:1;
  unsigned int s27c2f56:1;
  unsigned int s27c2f57:1;
  unsigned int s27c2f58:1;
  unsigned int s27c2f59:1;
  unsigned int s27c2f60:1;
  unsigned int s27c2f61:1;
  ::S27C37 s27c2f62;
  void *s27c2f63;
  char s27c2f64[3];
  void *s27c2f65;
  int s27c2f66;
  void *s27c2f67[2];
  int s27c2f68[2];
  void *s27c2f69;
  int s27c2f70[5];
  void *s27c2f71[3];
  int s27c2f72[2];
  ::S27C37 s27c2f73;
  int s27c2f74[3];
  unsigned int s27c2f75:1;
  int s27c2f76[5];
  void *s27c2f77[2];
  int s27c2f78;
  void *s27c2f79;
  int s27c2f80;
  void *s27c2f81;
  int s27c2f82[2];
  void *s27c2f83[3];
  int s27c2f84;
  ::S27C26_nt s27c2f85;
  ::S27C26_nt s27c2f86;
  ::S27C41_nt s27c2f87;
  int s27c2f88[5];
  void *s27c2f89[2];
  int s27c2f90;
  ::S27C18_nt s27c2f91;
  ::S27C42 s27c2f92;
  int s27c2f93;
  ::S27C42 s27c2f94;
  void *s27c2f95;
  int s27c2f96;
  ::S27C46 s27c2f97;
  ::S27C46 s27c2f98;
  ::S27C50 s27c2f99;
  ::S27C50 s27c2f100;
  ::S27C54 s27c2f101;
  int s27c2f102;
  void *s27c2f103[2];
  ::S27C54 s27c2f104;
  void *s27c2f105;
  int s27c2f106[6];
  void *s27c2f107[2];
  int s27c2f108[3];
  void *s27c2f109;
  ::S27C58 s27c2f110;
  void *s27c2f111;
  ::S27C9_nt s27c2f112;
  int s27c2f113;
  ::S27C9_nt s27c2f114;
  ::S27C58 s27c2f115;
  int s27c2f116[6];
  void *s27c2f117;
  int s27c2f118[2];
  ::S27C9_nt s27c2f119;
  ::S27C9_nt s27c2f120;
  ::S27C58 s27c2f121;
  ::S27C18_nt s27c2f122;
  void *s27c2f123[2];
  int s27c2f124;
  void *s27c2f125[2];
  int s27c2f126;
  void *s27c2f127[3];
  int s27c2f128;
  ::S27C9_nt s27c2f129;
  void *s27c2f130[2];
  ::S27C62 s27c2f131;
  ::S27C9_nt s27c2f132;
  int s27c2f133;
  ::S27C9_nt s27c2f134;
  void *s27c2f135[3];
  ::S27C18_nt s27c2f136;
  ::S27C18_nt s27c2f137;
  ::S27C9_nt s27c2f138;
  ::S27C18_nt s27c2f139;
  int s27c2f140;
  ::S27C35_nt s27c2f141;
  ::S27C35_nt s27c2f142;
  ::S27C35_nt s27c2f143;
  ::S27C35_nt s27c2f144;
  ::S27C35_nt s27c2f145;
  int s27c2f146[4];
  ::S27C18_nt s27c2f147;
  void *s27c2f148;
  ::S27C18_nt s27c2f149;
  ::S27C62 s27c2f150;
  ::S27C66 s27c2f151;
  ::S27C9_nt s27c2f152;
  ::S27C68_nt s27c2f153;
  ::S27C54 s27c2f154;
  int s27c2f155;
  void *s27c2f156[2];
  int s27c2f157[9];
  ::S27C71 s27c2f158;
  int s27c2f159;
  ::S27C18_nt s27c2f160;
  int s27c2f161[2];
  ::S27C18_nt s27c2f162;
  ::S27C71 s27c2f163;
  ::S27C75_nt s27c2f164;
  int s27c2f165[3];
  void *s27c2f166[2];
  ::S27C76 s27c2f167;
  ::S27C76 s27c2f168;
  void *s27c2f169;
  int s27c2f170[2];
  ::S27C80 s27c2f171;
  ::S27C80 s27c2f172;
  virtual  ~S27C2_nt(); // _ZN8S27C2_ntD1Ev
  virtual void  v358(); // _ZN8S27C2_nt4v358Ev
  virtual void  v359(); // _ZN8S27C2_nt4v359Ev
  virtual void  v360(); // _ZN8S27C2_nt4v360Ev
  virtual void  v361(); // _ZN8S27C2_nt4v361Ev
  virtual void  v362(); // _ZN8S27C2_nt4v362Ev
  virtual void  v363(); // _ZN8S27C2_nt4v363Ev
  virtual void  v364(); // _ZN8S27C2_nt4v364Ev
  virtual void  v365(); // _ZN8S27C2_nt4v365Ev
  virtual void  v366(); // _ZN8S27C2_nt4v366Ev
  virtual void  v367(); // _ZN8S27C2_nt4v367Ev
  virtual void  v368(); // _ZN8S27C2_nt4v368Ev
  virtual void  v369(); // _ZN8S27C2_nt4v369Ev
  virtual void  v370(); // _ZN8S27C2_nt4v370Ev
  virtual void  v371(); // _ZN8S27C2_nt4v371Ev
  virtual void  v372(); // _ZN8S27C2_nt4v372Ev
  virtual void  v373(); // _ZN8S27C2_nt4v373Ev
  virtual void  v374(); // _ZN8S27C2_nt4v374Ev
  virtual void  v375(); // _ZN8S27C2_nt4v375Ev
  virtual void  v376(); // _ZN8S27C2_nt4v376Ev
  virtual void  v377(); // _ZN8S27C2_nt4v377Ev
  virtual void  v378(); // _ZN8S27C2_nt4v378Ev
  virtual void  v379(); // _ZN8S27C2_nt4v379Ev
  virtual void  v380(); // _ZN8S27C2_nt4v380Ev
  virtual void  v381(); // _ZN8S27C2_nt4v381Ev
  virtual void  v382(); // _ZN8S27C2_nt4v382Ev
  virtual void  v383(); // _ZN8S27C2_nt4v383Ev
  virtual void  v384(); // _ZN8S27C2_nt4v384Ev
  virtual void  v385(); // _ZN8S27C2_nt4v385Ev
  virtual void  v386(); // _ZN8S27C2_nt4v386Ev
  S27C2_nt(); // tgen
};
//SIG(-1 S27C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 FC12{ m Fi} Fi Fc[4] Fp[2] FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC8 FC8 FC8 FC13{ BC14{ BC11}} FC13 Fi Fp[2] FC15{ m Fi[3]} FC15 FC15 FC15 Fp FC8 FC13 FC15 FC15 Fi FC15 FC15 Fp Fi Fc FC15 FC15 Fp Fi Fp FC13 FC16{ BC17{ BC11}} FC16} vd v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 v328 v329 v330 v331 v332 v333 v334 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC15 Fi[19] FC15 Fi[2] Fp Fi[5] FC15 FC15 Fi Fp Fi FC15 Fi Fp Fi[3] FC18{ BC19{ BC20{ BC11}}} Fp[3] FC8 FC8 Fp Fi FC15 Fp FC15 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC15 FC15 Fi Fp[2] Fi} vd v335 v336 v337 v338 v339 v340 v341 v342 v343 v344 v345 v346 v347 v348 v349 v350 v351 v352 v353 v354 v355 v356 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC21{ BC22{ BC11}} Fi FC15 Fi[3] FC15 Fi[2] Fp Fi[2] Fc Fi[8]} vd v357 v358 v359 v360 v361 v362 v363 v364 v365 v366 v367 v368 v369 v370 v371 v372 v373 v374 v375 v376 v377 v378 v379 v380 Fp FC21 FC15 FC15 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[4] Fp[2] Fi[8] Fp[5] Fi[13] FC15 Fi[3] FC23{ FC24{ m FC15 FC25{ m Fi[4]} FC15 FC15 Fc} Fc[4] Fi:1 Fi} Fi[2]} vd v381 v382 v383 Fi:1 Fp FC25} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC26{ BC27{ BC11}} Fp Fc[3] Fp Fi Fp[2] Fi[2] Fp Fi[5] Fp[3] Fi[2] FC26 Fi[3] Fi:1 Fi[5] Fp[2] Fi Fp Fi Fp Fi[2] Fp[3] Fi FC18 FC18 FC28{ m Fp FC18} Fi[5] Fp[2] Fi FC15 FC29{ BC30{ BC11}} Fi FC29 Fp Fi FC31{ BC32{ BC11}} FC31 FC33{ BC34{ BC11}} FC33 FC35{ BC36{ BC11}} Fi Fp[2] FC35 Fp Fi[6] Fp[2] Fi[3] Fp FC37{ BC38{ BC11}} Fp FC8 Fi FC8 FC37 Fi[6] Fp Fi[2] FC8 FC8 FC37 FC15 Fp[2] Fi Fp[2] Fi Fp[3] Fi FC8 Fp[2] FC39{ BC40{ BC11}} FC8 Fi FC8 Fp[3] FC15 FC15 FC8 FC15 Fi FC25 FC25 FC25 FC25 FC25 Fi[4] FC15 Fp FC15 FC39 FC41{ BC42{ BC11}} FC8 FC43{ m FC41 Fc} FC35 Fi Fp[2] Fi[9] FC44{ BC45{ BC11}} Fi FC15 Fi[2] FC15 FC44 FC46{ Fi FC15 FC15 Fp FC8} Fi[3] Fp[2] FC47{ BC48{ BC11}} FC47 Fp Fi[2] FC49{ BC50{ BC11}} FC49}


 S27C2_nt ::~S27C2_nt(){ note_dtor("S27C2_nt", this);}
void  S27C2_nt ::v358(){vfunc_called(this, "_ZN8S27C2_nt4v358Ev");}
void  S27C2_nt ::v359(){vfunc_called(this, "_ZN8S27C2_nt4v359Ev");}
void  S27C2_nt ::v360(){vfunc_called(this, "_ZN8S27C2_nt4v360Ev");}
void  S27C2_nt ::v361(){vfunc_called(this, "_ZN8S27C2_nt4v361Ev");}
void  S27C2_nt ::v362(){vfunc_called(this, "_ZN8S27C2_nt4v362Ev");}
void  S27C2_nt ::v363(){vfunc_called(this, "_ZN8S27C2_nt4v363Ev");}
void  S27C2_nt ::v364(){vfunc_called(this, "_ZN8S27C2_nt4v364Ev");}
void  S27C2_nt ::v365(){vfunc_called(this, "_ZN8S27C2_nt4v365Ev");}
void  S27C2_nt ::v366(){vfunc_called(this, "_ZN8S27C2_nt4v366Ev");}
void  S27C2_nt ::v367(){vfunc_called(this, "_ZN8S27C2_nt4v367Ev");}
void  S27C2_nt ::v368(){vfunc_called(this, "_ZN8S27C2_nt4v368Ev");}
void  S27C2_nt ::v369(){vfunc_called(this, "_ZN8S27C2_nt4v369Ev");}
void  S27C2_nt ::v370(){vfunc_called(this, "_ZN8S27C2_nt4v370Ev");}
void  S27C2_nt ::v371(){vfunc_called(this, "_ZN8S27C2_nt4v371Ev");}
void  S27C2_nt ::v372(){vfunc_called(this, "_ZN8S27C2_nt4v372Ev");}
void  S27C2_nt ::v373(){vfunc_called(this, "_ZN8S27C2_nt4v373Ev");}
void  S27C2_nt ::v374(){vfunc_called(this, "_ZN8S27C2_nt4v374Ev");}
void  S27C2_nt ::v375(){vfunc_called(this, "_ZN8S27C2_nt4v375Ev");}
void  S27C2_nt ::v376(){vfunc_called(this, "_ZN8S27C2_nt4v376Ev");}
void  S27C2_nt ::v377(){vfunc_called(this, "_ZN8S27C2_nt4v377Ev");}
void  S27C2_nt ::v378(){vfunc_called(this, "_ZN8S27C2_nt4v378Ev");}
void  S27C2_nt ::v379(){vfunc_called(this, "_ZN8S27C2_nt4v379Ev");}
void  S27C2_nt ::v380(){vfunc_called(this, "_ZN8S27C2_nt4v380Ev");}
void  S27C2_nt ::v381(){vfunc_called(this, "_ZN8S27C2_nt4v381Ev");}
void  S27C2_nt ::v382(){vfunc_called(this, "_ZN8S27C2_nt4v382Ev");}
void  S27C2_nt ::v383(){vfunc_called(this, "_ZN8S27C2_nt4v383Ev");}
void  S27C2_nt ::v384(){vfunc_called(this, "_ZN8S27C2_nt4v384Ev");}
void  S27C2_nt ::v385(){vfunc_called(this, "_ZN8S27C2_nt4v385Ev");}
void  S27C2_nt ::v386(){vfunc_called(this, "_ZN8S27C2_nt4v386Ev");}
S27C2_nt ::S27C2_nt(){ note_ctor("S27C2_nt", this);} // tgen

//skip512 S27C2_nt

#else // __cplusplus

extern void _ZN8S27C2_ntC1Ev();
extern void _ZN8S27C2_ntD1Ev();
Name_Map name_map_S27C2_nt[] = {
  NSPAIR(_ZN8S27C2_ntC1Ev),
  NSPAIR(_ZN8S27C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S27C8_nt;
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
extern Class_Descriptor cd_S27C7_nt;
extern VTBL_ENTRY _ZTI8S27C7_nt[];
extern  VTBL_ENTRY _ZTV8S27C7_nt[];
extern Class_Descriptor cd_S27C6_nt;
extern VTBL_ENTRY _ZTI8S27C6_nt[];
extern  VTBL_ENTRY _ZTV8S27C6_nt[];
extern Class_Descriptor cd_S27C5_nt;
extern VTBL_ENTRY _ZTI8S27C5_nt[];
extern  VTBL_ENTRY _ZTV8S27C5_nt[];
extern Class_Descriptor cd_S27C4_nt;
extern VTBL_ENTRY _ZTI8S27C4_nt[];
extern  VTBL_ENTRY _ZTV8S27C4_nt[];
extern Class_Descriptor cd_S27C3_nt;
extern VTBL_ENTRY _ZTI8S27C3_nt[];
extern  VTBL_ENTRY _ZTV8S27C3_nt[];
static Base_Class bases_S27C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S27C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S27C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S27C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S27C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S27C2_nt[];
extern void _ZN8S27C2_ntD1Ev();
extern void _ZN8S27C2_ntD0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
extern void _ZN8S27C7_nt3v68Ev();
extern void _ZN8S27C7_nt3v69Ev();
extern void _ZN8S27C7_nt3v70Ev();
extern void _ZN8S27C7_nt3v71Ev();
extern void _ZN8S27C7_nt3v72Ev();
extern void _ZN8S27C7_nt3v73Ev();
extern void _ZN8S27C7_nt3v74Ev();
extern void _ZN8S27C7_nt3v75Ev();
extern void _ZN8S27C7_nt3v76Ev();
extern void _ZN8S27C7_nt3v77Ev();
extern void _ZN8S27C7_nt3v78Ev();
extern void _ZN8S27C7_nt3v79Ev();
extern void _ZN8S27C7_nt3v80Ev();
extern void _ZN8S27C7_nt3v81Ev();
extern void _ZN8S27C7_nt3v82Ev();
extern void _ZN8S27C7_nt3v83Ev();
extern void _ZN8S27C7_nt3v84Ev();
extern void _ZN8S27C7_nt3v85Ev();
extern void _ZN8S27C7_nt3v86Ev();
extern void _ZN8S27C7_nt3v87Ev();
extern void _ZN8S27C7_nt3v88Ev();
extern void _ZN8S27C7_nt3v89Ev();
extern void _ZN8S27C7_nt3v90Ev();
extern void _ZN8S27C7_nt3v91Ev();
extern void _ZN8S27C7_nt3v92Ev();
extern void _ZN8S27C7_nt3v93Ev();
extern void _ZN8S27C7_nt3v94Ev();
extern void _ZN8S27C7_nt3v95Ev();
extern void _ZN8S27C7_nt3v96Ev();
extern void _ZN8S27C7_nt3v97Ev();
extern void _ZN8S27C7_nt3v98Ev();
extern void _ZN8S27C7_nt3v99Ev();
extern void _ZN8S27C7_nt4v100Ev();
extern void _ZN8S27C7_nt4v101Ev();
extern void _ZN8S27C7_nt4v102Ev();
extern void _ZN8S27C7_nt4v103Ev();
extern void _ZN8S27C7_nt4v104Ev();
extern void _ZN8S27C7_nt4v105Ev();
extern void _ZN8S27C7_nt4v106Ev();
extern void _ZN8S27C7_nt4v107Ev();
extern void _ZN8S27C7_nt4v108Ev();
extern void _ZN8S27C7_nt4v109Ev();
extern void _ZN8S27C7_nt4v110Ev();
extern void _ZN8S27C7_nt4v111Ev();
extern void _ZN8S27C7_nt4v112Ev();
extern void _ZN8S27C7_nt4v113Ev();
extern void _ZN8S27C7_nt4v114Ev();
extern void _ZN8S27C7_nt4v115Ev();
extern void _ZN8S27C7_nt4v116Ev();
extern void _ZN8S27C7_nt4v117Ev();
extern void _ZN8S27C7_nt4v118Ev();
extern void _ZN8S27C7_nt4v119Ev();
extern void _ZN8S27C7_nt4v120Ev();
extern void _ZN8S27C7_nt4v121Ev();
extern void _ZN8S27C7_nt4v122Ev();
extern void _ZN8S27C7_nt4v123Ev();
extern void _ZN8S27C7_nt4v124Ev();
extern void _ZN8S27C7_nt4v125Ev();
extern void _ZN8S27C7_nt4v126Ev();
extern void _ZN8S27C7_nt4v127Ev();
extern void _ZN8S27C7_nt4v128Ev();
extern void _ZN8S27C7_nt4v129Ev();
extern void _ZN8S27C7_nt4v130Ev();
extern void _ZN8S27C7_nt4v131Ev();
extern void _ZN8S27C7_nt4v132Ev();
extern void _ZN8S27C7_nt4v133Ev();
extern void _ZN8S27C7_nt4v134Ev();
extern void _ZN8S27C7_nt4v135Ev();
extern void _ZN8S27C7_nt4v136Ev();
extern void _ZN8S27C7_nt4v137Ev();
extern void _ZN8S27C7_nt4v138Ev();
extern void _ZN8S27C7_nt4v139Ev();
extern void _ZN8S27C7_nt4v140Ev();
extern void _ZN8S27C7_nt4v141Ev();
extern void _ZN8S27C7_nt4v142Ev();
extern void _ZN8S27C7_nt4v143Ev();
extern void _ZN8S27C7_nt4v144Ev();
extern void _ZN8S27C7_nt4v145Ev();
extern void _ZN8S27C7_nt4v146Ev();
extern void _ZN8S27C7_nt4v147Ev();
extern void _ZN8S27C7_nt4v148Ev();
extern void _ZN8S27C7_nt4v149Ev();
extern void _ZN8S27C7_nt4v150Ev();
extern void _ZN8S27C7_nt4v151Ev();
extern void _ZN8S27C7_nt4v152Ev();
extern void _ZN8S27C7_nt4v153Ev();
extern void _ZN8S27C7_nt4v154Ev();
extern void _ZN8S27C7_nt4v155Ev();
extern void _ZN8S27C7_nt4v156Ev();
extern void _ZN8S27C7_nt4v157Ev();
extern void _ZN8S27C7_nt4v158Ev();
extern void _ZN8S27C7_nt4v159Ev();
extern void _ZN8S27C7_nt4v160Ev();
extern void _ZN8S27C7_nt4v161Ev();
extern void _ZN8S27C7_nt4v162Ev();
extern void _ZN8S27C7_nt4v163Ev();
extern void _ZN8S27C7_nt4v164Ev();
extern void _ZN8S27C7_nt4v165Ev();
extern void _ZN8S27C7_nt4v166Ev();
extern void _ZN8S27C7_nt4v167Ev();
extern void _ZN8S27C7_nt4v168Ev();
extern void _ZN8S27C7_nt4v169Ev();
extern void _ZN8S27C7_nt4v170Ev();
extern void _ZN8S27C7_nt4v171Ev();
extern void _ZN8S27C7_nt4v172Ev();
extern void _ZN8S27C7_nt4v173Ev();
extern void _ZN8S27C7_nt4v174Ev();
extern void _ZN8S27C7_nt4v175Ev();
extern void _ZN8S27C7_nt4v176Ev();
extern void _ZN8S27C7_nt4v177Ev();
extern void _ZN8S27C7_nt4v178Ev();
extern void _ZN8S27C7_nt4v179Ev();
extern void _ZN8S27C7_nt4v180Ev();
extern void _ZN8S27C7_nt4v181Ev();
extern void _ZN8S27C7_nt4v182Ev();
extern void _ZN8S27C7_nt4v183Ev();
extern void _ZN8S27C7_nt4v184Ev();
extern void _ZN8S27C7_nt4v185Ev();
extern void _ZN8S27C7_nt4v186Ev();
extern void _ZN8S27C7_nt4v187Ev();
extern void _ZN8S27C7_nt4v188Ev();
extern void _ZN8S27C7_nt4v189Ev();
extern void _ZN8S27C7_nt4v190Ev();
extern void _ZN8S27C7_nt4v191Ev();
extern void _ZN8S27C7_nt4v192Ev();
extern void _ZN8S27C7_nt4v193Ev();
extern void _ZN8S27C7_nt4v194Ev();
extern void _ZN8S27C7_nt4v195Ev();
extern void _ZN8S27C7_nt4v196Ev();
extern void _ZN8S27C7_nt4v197Ev();
extern void _ZN8S27C7_nt4v198Ev();
extern void _ZN8S27C7_nt4v199Ev();
extern void _ZN8S27C7_nt4v200Ev();
extern void _ZN8S27C7_nt4v201Ev();
extern void _ZN8S27C7_nt4v202Ev();
extern void _ZN8S27C7_nt4v203Ev();
extern void _ZN8S27C7_nt4v204Ev();
extern void _ZN8S27C7_nt4v205Ev();
extern void _ZN8S27C7_nt4v206Ev();
extern void _ZN8S27C7_nt4v207Ev();
extern void _ZN8S27C7_nt4v208Ev();
extern void _ZN8S27C7_nt4v209Ev();
extern void _ZN8S27C7_nt4v210Ev();
extern void _ZN8S27C6_nt4v211Ev();
extern void _ZN8S27C6_nt4v212Ev();
extern void _ZN8S27C6_nt4v213Ev();
extern void _ZN8S27C6_nt4v214Ev();
extern void _ZN8S27C6_nt4v215Ev();
extern void _ZN8S27C6_nt4v216Ev();
extern void _ZN8S27C6_nt4v217Ev();
extern void _ZN8S27C6_nt4v218Ev();
extern void _ZN8S27C6_nt4v219Ev();
extern void _ZN8S27C6_nt4v220Ev();
extern void _ZN8S27C6_nt4v221Ev();
extern void _ZN8S27C6_nt4v222Ev();
extern void _ZN8S27C6_nt4v223Ev();
extern void _ZN8S27C6_nt4v224Ev();
extern void _ZN8S27C6_nt4v225Ev();
extern void _ZN8S27C6_nt4v226Ev();
extern void _ZN8S27C6_nt4v227Ev();
extern void _ZN8S27C6_nt4v228Ev();
extern void _ZN8S27C6_nt4v229Ev();
extern void _ZN8S27C6_nt4v230Ev();
extern void _ZN8S27C6_nt4v231Ev();
extern void _ZN8S27C6_nt4v232Ev();
extern void _ZN8S27C6_nt4v233Ev();
extern void _ZN8S27C6_nt4v234Ev();
extern void _ZN8S27C6_nt4v235Ev();
extern void _ZN8S27C6_nt4v236Ev();
extern void _ZN8S27C6_nt4v237Ev();
extern void _ZN8S27C6_nt4v238Ev();
extern void _ZN8S27C6_nt4v239Ev();
extern void _ZN8S27C6_nt4v240Ev();
extern void _ZN8S27C6_nt4v241Ev();
extern void _ZN8S27C6_nt4v242Ev();
extern void _ZN8S27C6_nt4v243Ev();
extern void _ZN8S27C6_nt4v244Ev();
extern void _ZN8S27C6_nt4v245Ev();
extern void _ZN8S27C6_nt4v246Ev();
extern void _ZN8S27C6_nt4v247Ev();
extern void _ZN8S27C6_nt4v248Ev();
extern void _ZN8S27C6_nt4v249Ev();
extern void _ZN8S27C6_nt4v250Ev();
extern void _ZN8S27C6_nt4v251Ev();
extern void _ZN8S27C6_nt4v252Ev();
extern void _ZN8S27C6_nt4v253Ev();
extern void _ZN8S27C6_nt4v254Ev();
extern void _ZN8S27C6_nt4v255Ev();
extern void _ZN8S27C6_nt4v256Ev();
extern void _ZN8S27C6_nt4v257Ev();
extern void _ZN8S27C6_nt4v258Ev();
extern void _ZN8S27C6_nt4v259Ev();
extern void _ZN8S27C6_nt4v260Ev();
extern void _ZN8S27C6_nt4v261Ev();
extern void _ZN8S27C6_nt4v262Ev();
extern void _ZN8S27C6_nt4v263Ev();
extern void _ZN8S27C6_nt4v264Ev();
extern void _ZN8S27C6_nt4v265Ev();
extern void _ZN8S27C6_nt4v266Ev();
extern void _ZN8S27C6_nt4v267Ev();
extern void _ZN8S27C6_nt4v268Ev();
extern void _ZN8S27C6_nt4v269Ev();
extern void _ZN8S27C6_nt4v270Ev();
extern void _ZN8S27C6_nt4v271Ev();
extern void _ZN8S27C6_nt4v272Ev();
extern void _ZN8S27C6_nt4v273Ev();
extern void _ZN8S27C6_nt4v274Ev();
extern void _ZN8S27C6_nt4v275Ev();
extern void _ZN8S27C6_nt4v276Ev();
extern void _ZN8S27C6_nt4v277Ev();
extern void _ZN8S27C6_nt4v278Ev();
extern void _ZN8S27C6_nt4v279Ev();
extern void _ZN8S27C6_nt4v280Ev();
extern void _ZN8S27C6_nt4v281Ev();
extern void _ZN8S27C6_nt4v282Ev();
extern void _ZN8S27C6_nt4v283Ev();
extern void _ZN8S27C6_nt4v284Ev();
extern void _ZN8S27C6_nt4v285Ev();
extern void _ZN8S27C6_nt4v286Ev();
extern void _ZN8S27C6_nt4v287Ev();
extern void _ZN8S27C6_nt4v288Ev();
extern void _ZN8S27C6_nt4v289Ev();
extern void _ZN8S27C6_nt4v290Ev();
extern void _ZN8S27C6_nt4v291Ev();
extern void _ZN8S27C6_nt4v292Ev();
extern void _ZN8S27C6_nt4v293Ev();
extern void _ZN8S27C6_nt4v294Ev();
extern void _ZN8S27C6_nt4v295Ev();
extern void _ZN8S27C6_nt4v296Ev();
extern void _ZN8S27C6_nt4v297Ev();
extern void _ZN8S27C6_nt4v298Ev();
extern void _ZN8S27C6_nt4v299Ev();
extern void _ZN8S27C6_nt4v300Ev();
extern void _ZN8S27C6_nt4v301Ev();
extern void _ZN8S27C6_nt4v302Ev();
extern void _ZN8S27C6_nt4v303Ev();
extern void _ZN8S27C6_nt4v304Ev();
extern void _ZN8S27C6_nt4v305Ev();
extern void _ZN8S27C6_nt4v306Ev();
extern void _ZN8S27C6_nt4v307Ev();
extern void _ZN8S27C6_nt4v308Ev();
extern void _ZN8S27C5_nt4v309Ev();
extern void _ZN8S27C5_nt4v310Ev();
extern void _ZN8S27C5_nt4v311Ev();
extern void _ZN8S27C5_nt4v312Ev();
extern void _ZN8S27C5_nt4v313Ev();
extern void _ZN8S27C5_nt4v314Ev();
extern void _ZN8S27C5_nt4v315Ev();
extern void _ZN8S27C5_nt4v316Ev();
extern void _ZN8S27C5_nt4v317Ev();
extern void _ZN8S27C5_nt4v318Ev();
extern void _ZN8S27C5_nt4v319Ev();
extern void _ZN8S27C5_nt4v320Ev();
extern void _ZN8S27C5_nt4v321Ev();
extern void _ZN8S27C5_nt4v322Ev();
extern void _ZN8S27C5_nt4v323Ev();
extern void _ZN8S27C5_nt4v324Ev();
extern void _ZN8S27C5_nt4v325Ev();
extern void _ZN8S27C5_nt4v326Ev();
extern void _ZN8S27C5_nt4v327Ev();
extern void _ZN8S27C5_nt4v328Ev();
extern void _ZN8S27C5_nt4v329Ev();
extern void _ZN8S27C5_nt4v330Ev();
extern void _ZN8S27C4_nt4v331Ev();
extern void _ZN8S27C4_nt4v332Ev();
extern void _ZN8S27C4_nt4v333Ev();
extern void _ZN8S27C4_nt4v334Ev();
extern void _ZN8S27C4_nt4v335Ev();
extern void _ZN8S27C4_nt4v336Ev();
extern void _ZN8S27C4_nt4v337Ev();
extern void _ZN8S27C4_nt4v338Ev();
extern void _ZN8S27C4_nt4v339Ev();
extern void _ZN8S27C4_nt4v340Ev();
extern void _ZN8S27C4_nt4v341Ev();
extern void _ZN8S27C4_nt4v342Ev();
extern void _ZN8S27C4_nt4v343Ev();
extern void _ZN8S27C4_nt4v344Ev();
extern void _ZN8S27C4_nt4v345Ev();
extern void _ZN8S27C4_nt4v346Ev();
extern void _ZN8S27C4_nt4v347Ev();
extern void _ZN8S27C4_nt4v348Ev();
extern void _ZN8S27C4_nt4v349Ev();
extern void _ZN8S27C4_nt4v350Ev();
extern void _ZN8S27C4_nt4v351Ev();
extern void _ZN8S27C4_nt4v352Ev();
extern void _ZN8S27C4_nt4v353Ev();
extern void _ZN8S27C4_nt4v354Ev();
extern void _ZN8S27C3_nt4v355Ev();
extern void _ZN8S27C3_nt4v356Ev();
extern void _ZN8S27C3_nt4v357Ev();
extern void _ZN8S27C2_nt4v358Ev();
extern void _ZN8S27C2_nt4v359Ev();
extern void _ZN8S27C2_nt4v360Ev();
extern void _ZN8S27C2_nt4v361Ev();
extern void _ZN8S27C2_nt4v362Ev();
extern void _ZN8S27C2_nt4v363Ev();
extern void _ZN8S27C2_nt4v364Ev();
extern void _ZN8S27C2_nt4v365Ev();
extern void _ZN8S27C2_nt4v366Ev();
extern void _ZN8S27C2_nt4v367Ev();
extern void _ZN8S27C2_nt4v368Ev();
extern void _ZN8S27C2_nt4v369Ev();
extern void _ZN8S27C2_nt4v370Ev();
extern void _ZN8S27C2_nt4v371Ev();
extern void _ZN8S27C2_nt4v372Ev();
extern void _ZN8S27C2_nt4v373Ev();
extern void _ZN8S27C2_nt4v374Ev();
extern void _ZN8S27C2_nt4v375Ev();
extern void _ZN8S27C2_nt4v376Ev();
extern void _ZN8S27C2_nt4v377Ev();
extern void _ZN8S27C2_nt4v378Ev();
extern void _ZN8S27C2_nt4v379Ev();
extern void _ZN8S27C2_nt4v380Ev();
extern void _ZN8S27C2_nt4v381Ev();
extern void _ZN8S27C2_nt4v382Ev();
extern void _ZN8S27C2_nt4v383Ev();
extern void _ZN8S27C2_nt4v384Ev();
extern void _ZN8S27C2_nt4v385Ev();
extern void _ZN8S27C2_nt4v386Ev();
static  VTBL_ENTRY vtc_S27C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S27C2_nt[0]),
  (VTBL_ENTRY)&_ZN8S27C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S27C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v223Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v224Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v225Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v226Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v227Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v228Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v229Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v230Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v231Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v232Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v234Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v235Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v236Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v237Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v238Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v239Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v240Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v241Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v242Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v243Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v244Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v245Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v246Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v247Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v248Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v249Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v250Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v251Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v252Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v253Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v254Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v255Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v256Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v257Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v258Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v259Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v260Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v261Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v262Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v263Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v264Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v265Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v266Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v267Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v268Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v269Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v270Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v271Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v272Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v273Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v274Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v275Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v276Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v277Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v278Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v279Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v280Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v281Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v282Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v283Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v284Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v285Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v286Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v287Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v288Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v289Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v290Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v291Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v292Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v293Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v294Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v295Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v296Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v297Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v298Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v299Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v300Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v301Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v302Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v303Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v304Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v305Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v306Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v307Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v308Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v309Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v310Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v311Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v312Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v313Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v314Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v315Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v316Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v317Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v318Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v319Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v320Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v321Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v322Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v323Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v324Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v325Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v326Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v327Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v328Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v329Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v330Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v331Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v332Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v333Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v334Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v335Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v336Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v337Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v338Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v339Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v340Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v341Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v342Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v343Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v344Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v345Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v346Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v347Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v348Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v349Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v350Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v351Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v352Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v353Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v354Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v355Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v356Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v357Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v358Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v359Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v360Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v361Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v362Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v363Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v364Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v365Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v366Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v367Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v368Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v369Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v370Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v371Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v372Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v373Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v374Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v375Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v376Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v377Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v378Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v379Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v380Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v381Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v382Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v383Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v384Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v385Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v386Ev,
};
extern VTBL_ENTRY _ZTI8S27C2_nt[];
VTBL_ENTRY *P__ZTI8S27C2_nt = _ZTI8S27C2_nt; 
extern  VTBL_ENTRY _ZTV8S27C2_nt[];
Class_Descriptor cd_S27C2_nt = {  "S27C2_nt", // class name
  bases_S27C2_nt, 6,
  &(vtc_S27C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3208,2480), // object size
  NSPAIRA(_ZTI8S27C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S27C2_nt),387, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S27C1  : S27C2_nt {
  void *s27c1f0[6];
  ::S27C9_nt s27c1f1;
  ::S27C18_nt s27c1f2;
  ::S27C18_nt s27c1f3;
  ::S27C9_nt s27c1f4;
  ::S27C9_nt s27c1f5[3];
  ::S27C9_nt s27c1f6;
  ::S27C9_nt s27c1f7[3];
  void *s27c1f8[3];
  int s27c1f9;
  ::S27C9_nt s27c1f10;
  ::S27C9_nt s27c1f11;
  int s27c1f12[2];
  void *s27c1f13[2];
  virtual  ~S27C1(); // _ZN5S27C1D1Ev
  virtual void  v1(); // _ZN5S27C12v1Ev
  virtual void  v2(); // _ZN5S27C12v2Ev
  virtual void  v3(); // _ZN5S27C12v3Ev
  S27C1(); // tgen
};
//SIG(1 S27C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ BC8{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC9{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC10 FC13{ m Fi} Fi Fc[4] Fp[2] FC10 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC9 FC9 FC9 FC14{ BC15{ BC12}} FC14 Fi Fp[2] FC16{ m Fi[3]} FC16 FC16 FC16 Fp FC9 FC14 FC16 FC16 Fi FC16 FC16 Fp Fi Fc FC16 FC16 Fp Fi Fp FC14 FC17{ BC18{ BC12}} FC17} vd v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 Fi[3] Fp[2] Fi Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fc[4] Fi[10] Fp[2] Fi[4] FC16 Fi[19] FC16 Fi[2] Fp Fi[5] FC16 FC16 Fi Fp Fi FC16 Fi Fp Fi[3] FC19{ BC20{ BC21{ BC12}}} Fp[3] FC9 FC9 Fp Fi FC16 Fp FC16 Fp[2] Fi[2] Fp Fi[2] Fp Fi[3] Fp[3] FC16 FC16 Fi Fp[2] Fi} vd v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 v328 v329 v330 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC22{ BC23{ BC12}} Fi FC16 Fi[3] FC16 Fi[2] Fp Fi[2] Fc Fi[8]} vd v331 v332 v333 v334 v335 v336 v337 v338 v339 v340 v341 v342 v343 v344 v345 v346 v347 v348 v349 v350 v351 v352 v353 v354 Fp FC22 FC16 FC16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[4] Fp[2] Fi[8] Fp[5] Fi[13] FC16 Fi[3] FC24{ FC25{ m FC16 FC26{ m Fi[4]} FC16 FC16 Fc} Fc[4] Fi:1 Fi} Fi[2]} vd v355 v356 v357 Fi:1 Fp FC26} vd v358 v359 v360 v361 v362 v363 v364 v365 v366 v367 v368 v369 v370 v371 v372 v373 v374 v375 v376 v377 v378 v379 v380 v381 v382 v383 v384 v385 v386 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC27{ BC28{ BC12}} Fp Fc[3] Fp Fi Fp[2] Fi[2] Fp Fi[5] Fp[3] Fi[2] FC27 Fi[3] Fi:1 Fi[5] Fp[2] Fi Fp Fi Fp Fi[2] Fp[3] Fi FC19 FC19 FC29{ m Fp FC19} Fi[5] Fp[2] Fi FC16 FC30{ BC31{ BC12}} Fi FC30 Fp Fi FC32{ BC33{ BC12}} FC32 FC34{ BC35{ BC12}} FC34 FC36{ BC37{ BC12}} Fi Fp[2] FC36 Fp Fi[6] Fp[2] Fi[3] Fp FC38{ BC39{ BC12}} Fp FC9 Fi FC9 FC38 Fi[6] Fp Fi[2] FC9 FC9 FC38 FC16 Fp[2] Fi Fp[2] Fi Fp[3] Fi FC9 Fp[2] FC40{ BC41{ BC12}} FC9 Fi FC9 Fp[3] FC16 FC16 FC9 FC16 Fi FC26 FC26 FC26 FC26 FC26 Fi[4] FC16 Fp FC16 FC40 FC42{ BC43{ BC12}} FC9 FC44{ m FC42 Fc} FC36 Fi Fp[2] Fi[9] FC45{ BC46{ BC12}} Fi FC16 Fi[2] FC16 FC45 FC47{ Fi FC16 FC16 Fp FC9} Fi[3] Fp[2] FC48{ BC49{ BC12}} FC48 Fp Fi[2] FC50{ BC51{ BC12}} FC50} vd v1 v2 v3 Fp[6] FC9 FC16 FC16 FC9 FC9[3] FC9 FC9[3] Fp[3] Fi FC9 FC9 Fi[2] Fp[2]}


 S27C1 ::~S27C1(){ note_dtor("S27C1", this);}
void  S27C1 ::v1(){vfunc_called(this, "_ZN5S27C12v1Ev");}
void  S27C1 ::v2(){vfunc_called(this, "_ZN5S27C12v2Ev");}
void  S27C1 ::v3(){vfunc_called(this, "_ZN5S27C12v3Ev");}
S27C1 ::S27C1(){ note_ctor("S27C1", this);} // tgen

static void Test_S27C1()
{
  extern Class_Descriptor cd_S27C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(429,663)];
    init_test(&cd_S27C1, buf);
    S27C1 *dp, &lv = *(dp=new (buf) S27C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3424,2648), "sizeof(S27C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S27C1)");
    check_base_class_offset(lv, (S27C8_nt*)(S27C7_nt*)(S27C6_nt*)(S27C5_nt*)(S27C4_nt*)(S27C3_nt*)(S27C2_nt*), 0, "S27C1");
    check_base_class_offset(lv, (S27C7_nt*)(S27C6_nt*)(S27C5_nt*)(S27C4_nt*)(S27C3_nt*)(S27C2_nt*), 0, "S27C1");
    check_base_class_offset(lv, (S27C6_nt*)(S27C5_nt*)(S27C4_nt*)(S27C3_nt*)(S27C2_nt*), 0, "S27C1");
    check_base_class_offset(lv, (S27C5_nt*)(S27C4_nt*)(S27C3_nt*)(S27C2_nt*), 0, "S27C1");
    check_base_class_offset(lv, (S27C4_nt*)(S27C3_nt*)(S27C2_nt*), 0, "S27C1");
    check_base_class_offset(lv, (S27C3_nt*)(S27C2_nt*), 0, "S27C1");
    check_base_class_offset(lv, (S27C2_nt*), 0, "S27C1");
    check_field_offset(lv, s27c1f0, ABISELECT(3208,2480), "S27C1.s27c1f0");
    check_field_offset(lv, s27c1f1, ABISELECT(3256,2504), "S27C1.s27c1f1");
    check_field_offset(lv, s27c1f2, ABISELECT(3264,2512), "S27C1.s27c1f2");
    check_field_offset(lv, s27c1f3, ABISELECT(3276,2524), "S27C1.s27c1f3");
    check_field_offset(lv, s27c1f4, ABISELECT(3288,2536), "S27C1.s27c1f4");
    check_field_offset(lv, s27c1f5, ABISELECT(3296,2544), "S27C1.s27c1f5");
    check_field_offset(lv, s27c1f6, ABISELECT(3320,2568), "S27C1.s27c1f6");
    check_field_offset(lv, s27c1f7, ABISELECT(3328,2576), "S27C1.s27c1f7");
    check_field_offset(lv, s27c1f8, ABISELECT(3352,2600), "S27C1.s27c1f8");
    check_field_offset(lv, s27c1f9, ABISELECT(3376,2612), "S27C1.s27c1f9");
    check_field_offset(lv, s27c1f10, ABISELECT(3380,2616), "S27C1.s27c1f10");
    check_field_offset(lv, s27c1f11, ABISELECT(3388,2624), "S27C1.s27c1f11");
    check_field_offset(lv, s27c1f12, ABISELECT(3396,2632), "S27C1.s27c1f12");
    check_field_offset(lv, s27c1f13, ABISELECT(3408,2640), "S27C1.s27c1f13");
    test_class_info(&lv, &cd_S27C1);
    dp->~S27C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS27C1(Test_S27C1, "S27C1", ABISELECT(3424,2648));

#else // __cplusplus

extern void _ZN5S27C1C1Ev();
extern void _ZN5S27C1D1Ev();
Name_Map name_map_S27C1[] = {
  NSPAIR(_ZN5S27C1C1Ev),
  NSPAIR(_ZN5S27C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S27C8_nt;
extern VTBL_ENTRY _ZTI8S27C8_nt[];
extern  VTBL_ENTRY _ZTV8S27C8_nt[];
extern Class_Descriptor cd_S27C7_nt;
extern VTBL_ENTRY _ZTI8S27C7_nt[];
extern  VTBL_ENTRY _ZTV8S27C7_nt[];
extern Class_Descriptor cd_S27C6_nt;
extern VTBL_ENTRY _ZTI8S27C6_nt[];
extern  VTBL_ENTRY _ZTV8S27C6_nt[];
extern Class_Descriptor cd_S27C5_nt;
extern VTBL_ENTRY _ZTI8S27C5_nt[];
extern  VTBL_ENTRY _ZTV8S27C5_nt[];
extern Class_Descriptor cd_S27C4_nt;
extern VTBL_ENTRY _ZTI8S27C4_nt[];
extern  VTBL_ENTRY _ZTV8S27C4_nt[];
extern Class_Descriptor cd_S27C3_nt;
extern VTBL_ENTRY _ZTI8S27C3_nt[];
extern  VTBL_ENTRY _ZTV8S27C3_nt[];
extern Class_Descriptor cd_S27C2_nt;
extern VTBL_ENTRY _ZTI8S27C2_nt[];
extern  VTBL_ENTRY _ZTV8S27C2_nt[];
static Base_Class bases_S27C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S27C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S27C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S27C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S27C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S27C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S27C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S27C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S27C1[];
extern void _ZN5S27C1D1Ev();
extern void _ZN5S27C1D0Ev();
extern void _ZN8S27C8_nt2v4Ev();
extern void _ZN8S27C8_nt2v5Ev();
extern void _ZN8S27C8_nt2v6Ev();
extern void _ZN8S27C8_nt2v7Ev();
extern void _ZN8S27C8_nt2v8Ev();
extern void _ZN8S27C8_nt2v9Ev();
extern void _ZN8S27C8_nt3v10Ev();
extern void _ZN8S27C8_nt3v11Ev();
extern void _ZN8S27C8_nt3v12Ev();
extern void _ZN8S27C8_nt3v13Ev();
extern void _ZN8S27C8_nt3v14Ev();
extern void _ZN8S27C8_nt3v15Ev();
extern void _ZN8S27C8_nt3v16Ev();
extern void _ZN8S27C8_nt3v17Ev();
extern void _ZN8S27C8_nt3v18Ev();
extern void _ZN8S27C8_nt3v19Ev();
extern void _ZN8S27C8_nt3v20Ev();
extern void _ZN8S27C8_nt3v21Ev();
extern void _ZN8S27C8_nt3v22Ev();
extern void _ZN8S27C8_nt3v23Ev();
extern void _ZN8S27C8_nt3v24Ev();
extern void _ZN8S27C8_nt3v25Ev();
extern void _ZN8S27C8_nt3v26Ev();
extern void _ZN8S27C8_nt3v27Ev();
extern void _ZN8S27C8_nt3v28Ev();
extern void _ZN8S27C8_nt3v29Ev();
extern void _ZN8S27C8_nt3v30Ev();
extern void _ZN8S27C8_nt3v31Ev();
extern void _ZN8S27C8_nt3v32Ev();
extern void _ZN8S27C8_nt3v33Ev();
extern void _ZN8S27C8_nt3v34Ev();
extern void _ZN8S27C8_nt3v35Ev();
extern void _ZN8S27C8_nt3v36Ev();
extern void _ZN8S27C8_nt3v37Ev();
extern void _ZN8S27C8_nt3v38Ev();
extern void _ZN8S27C8_nt3v39Ev();
extern void _ZN8S27C8_nt3v40Ev();
extern void _ZN8S27C8_nt3v41Ev();
extern void _ZN8S27C8_nt3v42Ev();
extern void _ZN8S27C8_nt3v43Ev();
extern void _ZN8S27C8_nt3v44Ev();
extern void _ZN8S27C8_nt3v45Ev();
extern void _ZN8S27C8_nt3v46Ev();
extern void _ZN8S27C8_nt3v47Ev();
extern void _ZN8S27C8_nt3v48Ev();
extern void _ZN8S27C8_nt3v49Ev();
extern void _ZN8S27C8_nt3v50Ev();
extern void _ZN8S27C8_nt3v51Ev();
extern void _ZN8S27C8_nt3v52Ev();
extern void _ZN8S27C8_nt3v53Ev();
extern void _ZN8S27C8_nt3v54Ev();
extern void _ZN8S27C8_nt3v55Ev();
extern void _ZN8S27C8_nt3v56Ev();
extern void _ZN8S27C8_nt3v57Ev();
extern void _ZN8S27C8_nt3v58Ev();
extern void _ZN8S27C8_nt3v59Ev();
extern void _ZN8S27C8_nt3v60Ev();
extern void _ZN8S27C8_nt3v61Ev();
extern void _ZN8S27C8_nt3v62Ev();
extern void _ZN8S27C8_nt3v63Ev();
extern void _ZN8S27C8_nt3v64Ev();
extern void _ZN8S27C8_nt3v65Ev();
extern void _ZN8S27C8_nt3v66Ev();
extern void _ZN8S27C8_nt3v67Ev();
extern void _ZN8S27C7_nt3v68Ev();
extern void _ZN8S27C7_nt3v69Ev();
extern void _ZN8S27C7_nt3v70Ev();
extern void _ZN8S27C7_nt3v71Ev();
extern void _ZN8S27C7_nt3v72Ev();
extern void _ZN8S27C7_nt3v73Ev();
extern void _ZN8S27C7_nt3v74Ev();
extern void _ZN8S27C7_nt3v75Ev();
extern void _ZN8S27C7_nt3v76Ev();
extern void _ZN8S27C7_nt3v77Ev();
extern void _ZN8S27C7_nt3v78Ev();
extern void _ZN8S27C7_nt3v79Ev();
extern void _ZN8S27C7_nt3v80Ev();
extern void _ZN8S27C7_nt3v81Ev();
extern void _ZN8S27C7_nt3v82Ev();
extern void _ZN8S27C7_nt3v83Ev();
extern void _ZN8S27C7_nt3v84Ev();
extern void _ZN8S27C7_nt3v85Ev();
extern void _ZN8S27C7_nt3v86Ev();
extern void _ZN8S27C7_nt3v87Ev();
extern void _ZN8S27C7_nt3v88Ev();
extern void _ZN8S27C7_nt3v89Ev();
extern void _ZN8S27C7_nt3v90Ev();
extern void _ZN8S27C7_nt3v91Ev();
extern void _ZN8S27C7_nt3v92Ev();
extern void _ZN8S27C7_nt3v93Ev();
extern void _ZN8S27C7_nt3v94Ev();
extern void _ZN8S27C7_nt3v95Ev();
extern void _ZN8S27C7_nt3v96Ev();
extern void _ZN8S27C7_nt3v97Ev();
extern void _ZN8S27C7_nt3v98Ev();
extern void _ZN8S27C7_nt3v99Ev();
extern void _ZN8S27C7_nt4v100Ev();
extern void _ZN8S27C7_nt4v101Ev();
extern void _ZN8S27C7_nt4v102Ev();
extern void _ZN8S27C7_nt4v103Ev();
extern void _ZN8S27C7_nt4v104Ev();
extern void _ZN8S27C7_nt4v105Ev();
extern void _ZN8S27C7_nt4v106Ev();
extern void _ZN8S27C7_nt4v107Ev();
extern void _ZN8S27C7_nt4v108Ev();
extern void _ZN8S27C7_nt4v109Ev();
extern void _ZN8S27C7_nt4v110Ev();
extern void _ZN8S27C7_nt4v111Ev();
extern void _ZN8S27C7_nt4v112Ev();
extern void _ZN8S27C7_nt4v113Ev();
extern void _ZN8S27C7_nt4v114Ev();
extern void _ZN8S27C7_nt4v115Ev();
extern void _ZN8S27C7_nt4v116Ev();
extern void _ZN8S27C7_nt4v117Ev();
extern void _ZN8S27C7_nt4v118Ev();
extern void _ZN8S27C7_nt4v119Ev();
extern void _ZN8S27C7_nt4v120Ev();
extern void _ZN8S27C7_nt4v121Ev();
extern void _ZN8S27C7_nt4v122Ev();
extern void _ZN8S27C7_nt4v123Ev();
extern void _ZN8S27C7_nt4v124Ev();
extern void _ZN8S27C7_nt4v125Ev();
extern void _ZN8S27C7_nt4v126Ev();
extern void _ZN8S27C7_nt4v127Ev();
extern void _ZN8S27C7_nt4v128Ev();
extern void _ZN8S27C7_nt4v129Ev();
extern void _ZN8S27C7_nt4v130Ev();
extern void _ZN8S27C7_nt4v131Ev();
extern void _ZN8S27C7_nt4v132Ev();
extern void _ZN8S27C7_nt4v133Ev();
extern void _ZN8S27C7_nt4v134Ev();
extern void _ZN8S27C7_nt4v135Ev();
extern void _ZN8S27C7_nt4v136Ev();
extern void _ZN8S27C7_nt4v137Ev();
extern void _ZN8S27C7_nt4v138Ev();
extern void _ZN8S27C7_nt4v139Ev();
extern void _ZN8S27C7_nt4v140Ev();
extern void _ZN8S27C7_nt4v141Ev();
extern void _ZN8S27C7_nt4v142Ev();
extern void _ZN8S27C7_nt4v143Ev();
extern void _ZN8S27C7_nt4v144Ev();
extern void _ZN8S27C7_nt4v145Ev();
extern void _ZN8S27C7_nt4v146Ev();
extern void _ZN8S27C7_nt4v147Ev();
extern void _ZN8S27C7_nt4v148Ev();
extern void _ZN8S27C7_nt4v149Ev();
extern void _ZN8S27C7_nt4v150Ev();
extern void _ZN8S27C7_nt4v151Ev();
extern void _ZN8S27C7_nt4v152Ev();
extern void _ZN8S27C7_nt4v153Ev();
extern void _ZN8S27C7_nt4v154Ev();
extern void _ZN8S27C7_nt4v155Ev();
extern void _ZN8S27C7_nt4v156Ev();
extern void _ZN8S27C7_nt4v157Ev();
extern void _ZN8S27C7_nt4v158Ev();
extern void _ZN8S27C7_nt4v159Ev();
extern void _ZN8S27C7_nt4v160Ev();
extern void _ZN8S27C7_nt4v161Ev();
extern void _ZN8S27C7_nt4v162Ev();
extern void _ZN8S27C7_nt4v163Ev();
extern void _ZN8S27C7_nt4v164Ev();
extern void _ZN8S27C7_nt4v165Ev();
extern void _ZN8S27C7_nt4v166Ev();
extern void _ZN8S27C7_nt4v167Ev();
extern void _ZN8S27C7_nt4v168Ev();
extern void _ZN8S27C7_nt4v169Ev();
extern void _ZN8S27C7_nt4v170Ev();
extern void _ZN8S27C7_nt4v171Ev();
extern void _ZN8S27C7_nt4v172Ev();
extern void _ZN8S27C7_nt4v173Ev();
extern void _ZN8S27C7_nt4v174Ev();
extern void _ZN8S27C7_nt4v175Ev();
extern void _ZN8S27C7_nt4v176Ev();
extern void _ZN8S27C7_nt4v177Ev();
extern void _ZN8S27C7_nt4v178Ev();
extern void _ZN8S27C7_nt4v179Ev();
extern void _ZN8S27C7_nt4v180Ev();
extern void _ZN8S27C7_nt4v181Ev();
extern void _ZN8S27C7_nt4v182Ev();
extern void _ZN8S27C7_nt4v183Ev();
extern void _ZN8S27C7_nt4v184Ev();
extern void _ZN8S27C7_nt4v185Ev();
extern void _ZN8S27C7_nt4v186Ev();
extern void _ZN8S27C7_nt4v187Ev();
extern void _ZN8S27C7_nt4v188Ev();
extern void _ZN8S27C7_nt4v189Ev();
extern void _ZN8S27C7_nt4v190Ev();
extern void _ZN8S27C7_nt4v191Ev();
extern void _ZN8S27C7_nt4v192Ev();
extern void _ZN8S27C7_nt4v193Ev();
extern void _ZN8S27C7_nt4v194Ev();
extern void _ZN8S27C7_nt4v195Ev();
extern void _ZN8S27C7_nt4v196Ev();
extern void _ZN8S27C7_nt4v197Ev();
extern void _ZN8S27C7_nt4v198Ev();
extern void _ZN8S27C7_nt4v199Ev();
extern void _ZN8S27C7_nt4v200Ev();
extern void _ZN8S27C7_nt4v201Ev();
extern void _ZN8S27C7_nt4v202Ev();
extern void _ZN8S27C7_nt4v203Ev();
extern void _ZN8S27C7_nt4v204Ev();
extern void _ZN8S27C7_nt4v205Ev();
extern void _ZN8S27C7_nt4v206Ev();
extern void _ZN8S27C7_nt4v207Ev();
extern void _ZN8S27C7_nt4v208Ev();
extern void _ZN8S27C7_nt4v209Ev();
extern void _ZN8S27C7_nt4v210Ev();
extern void _ZN8S27C6_nt4v211Ev();
extern void _ZN8S27C6_nt4v212Ev();
extern void _ZN8S27C6_nt4v213Ev();
extern void _ZN8S27C6_nt4v214Ev();
extern void _ZN8S27C6_nt4v215Ev();
extern void _ZN8S27C6_nt4v216Ev();
extern void _ZN8S27C6_nt4v217Ev();
extern void _ZN8S27C6_nt4v218Ev();
extern void _ZN8S27C6_nt4v219Ev();
extern void _ZN8S27C6_nt4v220Ev();
extern void _ZN8S27C6_nt4v221Ev();
extern void _ZN8S27C6_nt4v222Ev();
extern void _ZN8S27C6_nt4v223Ev();
extern void _ZN8S27C6_nt4v224Ev();
extern void _ZN8S27C6_nt4v225Ev();
extern void _ZN8S27C6_nt4v226Ev();
extern void _ZN8S27C6_nt4v227Ev();
extern void _ZN8S27C6_nt4v228Ev();
extern void _ZN8S27C6_nt4v229Ev();
extern void _ZN8S27C6_nt4v230Ev();
extern void _ZN8S27C6_nt4v231Ev();
extern void _ZN8S27C6_nt4v232Ev();
extern void _ZN8S27C6_nt4v233Ev();
extern void _ZN8S27C6_nt4v234Ev();
extern void _ZN8S27C6_nt4v235Ev();
extern void _ZN8S27C6_nt4v236Ev();
extern void _ZN8S27C6_nt4v237Ev();
extern void _ZN8S27C6_nt4v238Ev();
extern void _ZN8S27C6_nt4v239Ev();
extern void _ZN8S27C6_nt4v240Ev();
extern void _ZN8S27C6_nt4v241Ev();
extern void _ZN8S27C6_nt4v242Ev();
extern void _ZN8S27C6_nt4v243Ev();
extern void _ZN8S27C6_nt4v244Ev();
extern void _ZN8S27C6_nt4v245Ev();
extern void _ZN8S27C6_nt4v246Ev();
extern void _ZN8S27C6_nt4v247Ev();
extern void _ZN8S27C6_nt4v248Ev();
extern void _ZN8S27C6_nt4v249Ev();
extern void _ZN8S27C6_nt4v250Ev();
extern void _ZN8S27C6_nt4v251Ev();
extern void _ZN8S27C6_nt4v252Ev();
extern void _ZN8S27C6_nt4v253Ev();
extern void _ZN8S27C6_nt4v254Ev();
extern void _ZN8S27C6_nt4v255Ev();
extern void _ZN8S27C6_nt4v256Ev();
extern void _ZN8S27C6_nt4v257Ev();
extern void _ZN8S27C6_nt4v258Ev();
extern void _ZN8S27C6_nt4v259Ev();
extern void _ZN8S27C6_nt4v260Ev();
extern void _ZN8S27C6_nt4v261Ev();
extern void _ZN8S27C6_nt4v262Ev();
extern void _ZN8S27C6_nt4v263Ev();
extern void _ZN8S27C6_nt4v264Ev();
extern void _ZN8S27C6_nt4v265Ev();
extern void _ZN8S27C6_nt4v266Ev();
extern void _ZN8S27C6_nt4v267Ev();
extern void _ZN8S27C6_nt4v268Ev();
extern void _ZN8S27C6_nt4v269Ev();
extern void _ZN8S27C6_nt4v270Ev();
extern void _ZN8S27C6_nt4v271Ev();
extern void _ZN8S27C6_nt4v272Ev();
extern void _ZN8S27C6_nt4v273Ev();
extern void _ZN8S27C6_nt4v274Ev();
extern void _ZN8S27C6_nt4v275Ev();
extern void _ZN8S27C6_nt4v276Ev();
extern void _ZN8S27C6_nt4v277Ev();
extern void _ZN8S27C6_nt4v278Ev();
extern void _ZN8S27C6_nt4v279Ev();
extern void _ZN8S27C6_nt4v280Ev();
extern void _ZN8S27C6_nt4v281Ev();
extern void _ZN8S27C6_nt4v282Ev();
extern void _ZN8S27C6_nt4v283Ev();
extern void _ZN8S27C6_nt4v284Ev();
extern void _ZN8S27C6_nt4v285Ev();
extern void _ZN8S27C6_nt4v286Ev();
extern void _ZN8S27C6_nt4v287Ev();
extern void _ZN8S27C6_nt4v288Ev();
extern void _ZN8S27C6_nt4v289Ev();
extern void _ZN8S27C6_nt4v290Ev();
extern void _ZN8S27C6_nt4v291Ev();
extern void _ZN8S27C6_nt4v292Ev();
extern void _ZN8S27C6_nt4v293Ev();
extern void _ZN8S27C6_nt4v294Ev();
extern void _ZN8S27C6_nt4v295Ev();
extern void _ZN8S27C6_nt4v296Ev();
extern void _ZN8S27C6_nt4v297Ev();
extern void _ZN8S27C6_nt4v298Ev();
extern void _ZN8S27C6_nt4v299Ev();
extern void _ZN8S27C6_nt4v300Ev();
extern void _ZN8S27C6_nt4v301Ev();
extern void _ZN8S27C6_nt4v302Ev();
extern void _ZN8S27C6_nt4v303Ev();
extern void _ZN8S27C6_nt4v304Ev();
extern void _ZN8S27C6_nt4v305Ev();
extern void _ZN8S27C6_nt4v306Ev();
extern void _ZN8S27C6_nt4v307Ev();
extern void _ZN8S27C6_nt4v308Ev();
extern void _ZN8S27C5_nt4v309Ev();
extern void _ZN8S27C5_nt4v310Ev();
extern void _ZN8S27C5_nt4v311Ev();
extern void _ZN8S27C5_nt4v312Ev();
extern void _ZN8S27C5_nt4v313Ev();
extern void _ZN8S27C5_nt4v314Ev();
extern void _ZN8S27C5_nt4v315Ev();
extern void _ZN8S27C5_nt4v316Ev();
extern void _ZN8S27C5_nt4v317Ev();
extern void _ZN8S27C5_nt4v318Ev();
extern void _ZN8S27C5_nt4v319Ev();
extern void _ZN8S27C5_nt4v320Ev();
extern void _ZN8S27C5_nt4v321Ev();
extern void _ZN8S27C5_nt4v322Ev();
extern void _ZN8S27C5_nt4v323Ev();
extern void _ZN8S27C5_nt4v324Ev();
extern void _ZN8S27C5_nt4v325Ev();
extern void _ZN8S27C5_nt4v326Ev();
extern void _ZN8S27C5_nt4v327Ev();
extern void _ZN8S27C5_nt4v328Ev();
extern void _ZN8S27C5_nt4v329Ev();
extern void _ZN8S27C5_nt4v330Ev();
extern void _ZN8S27C4_nt4v331Ev();
extern void _ZN8S27C4_nt4v332Ev();
extern void _ZN8S27C4_nt4v333Ev();
extern void _ZN8S27C4_nt4v334Ev();
extern void _ZN8S27C4_nt4v335Ev();
extern void _ZN8S27C4_nt4v336Ev();
extern void _ZN8S27C4_nt4v337Ev();
extern void _ZN8S27C4_nt4v338Ev();
extern void _ZN8S27C4_nt4v339Ev();
extern void _ZN8S27C4_nt4v340Ev();
extern void _ZN8S27C4_nt4v341Ev();
extern void _ZN8S27C4_nt4v342Ev();
extern void _ZN8S27C4_nt4v343Ev();
extern void _ZN8S27C4_nt4v344Ev();
extern void _ZN8S27C4_nt4v345Ev();
extern void _ZN8S27C4_nt4v346Ev();
extern void _ZN8S27C4_nt4v347Ev();
extern void _ZN8S27C4_nt4v348Ev();
extern void _ZN8S27C4_nt4v349Ev();
extern void _ZN8S27C4_nt4v350Ev();
extern void _ZN8S27C4_nt4v351Ev();
extern void _ZN8S27C4_nt4v352Ev();
extern void _ZN8S27C4_nt4v353Ev();
extern void _ZN8S27C4_nt4v354Ev();
extern void _ZN8S27C3_nt4v355Ev();
extern void _ZN8S27C3_nt4v356Ev();
extern void _ZN8S27C3_nt4v357Ev();
extern void _ZN8S27C2_nt4v358Ev();
extern void _ZN8S27C2_nt4v359Ev();
extern void _ZN8S27C2_nt4v360Ev();
extern void _ZN8S27C2_nt4v361Ev();
extern void _ZN8S27C2_nt4v362Ev();
extern void _ZN8S27C2_nt4v363Ev();
extern void _ZN8S27C2_nt4v364Ev();
extern void _ZN8S27C2_nt4v365Ev();
extern void _ZN8S27C2_nt4v366Ev();
extern void _ZN8S27C2_nt4v367Ev();
extern void _ZN8S27C2_nt4v368Ev();
extern void _ZN8S27C2_nt4v369Ev();
extern void _ZN8S27C2_nt4v370Ev();
extern void _ZN8S27C2_nt4v371Ev();
extern void _ZN8S27C2_nt4v372Ev();
extern void _ZN8S27C2_nt4v373Ev();
extern void _ZN8S27C2_nt4v374Ev();
extern void _ZN8S27C2_nt4v375Ev();
extern void _ZN8S27C2_nt4v376Ev();
extern void _ZN8S27C2_nt4v377Ev();
extern void _ZN8S27C2_nt4v378Ev();
extern void _ZN8S27C2_nt4v379Ev();
extern void _ZN8S27C2_nt4v380Ev();
extern void _ZN8S27C2_nt4v381Ev();
extern void _ZN8S27C2_nt4v382Ev();
extern void _ZN8S27C2_nt4v383Ev();
extern void _ZN8S27C2_nt4v384Ev();
extern void _ZN8S27C2_nt4v385Ev();
extern void _ZN8S27C2_nt4v386Ev();
extern void _ZN5S27C12v1Ev();
extern void _ZN5S27C12v2Ev();
extern void _ZN5S27C12v3Ev();
static  VTBL_ENTRY vtc_S27C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S27C1[0]),
  (VTBL_ENTRY)&_ZN5S27C1D1Ev,
  (VTBL_ENTRY)&_ZN5S27C1D0Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S27C8_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S27C7_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v223Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v224Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v225Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v226Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v227Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v228Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v229Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v230Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v231Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v232Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v234Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v235Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v236Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v237Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v238Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v239Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v240Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v241Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v242Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v243Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v244Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v245Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v246Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v247Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v248Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v249Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v250Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v251Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v252Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v253Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v254Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v255Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v256Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v257Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v258Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v259Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v260Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v261Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v262Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v263Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v264Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v265Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v266Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v267Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v268Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v269Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v270Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v271Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v272Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v273Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v274Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v275Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v276Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v277Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v278Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v279Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v280Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v281Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v282Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v283Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v284Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v285Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v286Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v287Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v288Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v289Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v290Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v291Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v292Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v293Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v294Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v295Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v296Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v297Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v298Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v299Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v300Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v301Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v302Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v303Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v304Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v305Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v306Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v307Ev,
  (VTBL_ENTRY)&_ZN8S27C6_nt4v308Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v309Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v310Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v311Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v312Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v313Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v314Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v315Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v316Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v317Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v318Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v319Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v320Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v321Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v322Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v323Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v324Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v325Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v326Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v327Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v328Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v329Ev,
  (VTBL_ENTRY)&_ZN8S27C5_nt4v330Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v331Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v332Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v333Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v334Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v335Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v336Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v337Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v338Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v339Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v340Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v341Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v342Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v343Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v344Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v345Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v346Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v347Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v348Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v349Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v350Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v351Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v352Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v353Ev,
  (VTBL_ENTRY)&_ZN8S27C4_nt4v354Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v355Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v356Ev,
  (VTBL_ENTRY)&_ZN8S27C3_nt4v357Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v358Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v359Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v360Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v361Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v362Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v363Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v364Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v365Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v366Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v367Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v368Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v369Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v370Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v371Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v372Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v373Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v374Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v375Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v376Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v377Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v378Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v379Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v380Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v381Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v382Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v383Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v384Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v385Ev,
  (VTBL_ENTRY)&_ZN8S27C2_nt4v386Ev,
  (VTBL_ENTRY)&_ZN5S27C12v1Ev,
  (VTBL_ENTRY)&_ZN5S27C12v2Ev,
  (VTBL_ENTRY)&_ZN5S27C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S27C1[];
extern  VTBL_ENTRY _ZTV5S27C1[];
Class_Descriptor cd_S27C1 = {  "S27C1", // class name
  bases_S27C1, 7,
  &(vtc_S27C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3424,2648), // object size
  NSPAIRA(_ZTI5S27C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S27C1),390, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S246C6  {
  int s246c6f0;
  __tsi64 s246c6f1;
  void *s246c6f2[4];
  int s246c6f3[2];
  void *s246c6f4;
  ::S27C9_nt s246c6f5;
  void *s246c6f6[2];
  virtual  ~S246C6(); // _ZN6S246C6D1Ev
  virtual void  v5(); // _ZN6S246C62v5Ev
  virtual void  v6(); // _ZN6S246C62v6Ev
  virtual void  v7(); // _ZN6S246C62v7Ev
  virtual void  v8(); // _ZN6S246C62v8Ev
  virtual void  v9(); // _ZN6S246C62v9Ev
  virtual void  v10(); // _ZN6S246C63v10Ev
  virtual void  v11(); // _ZN6S246C63v11Ev
  virtual void  v12(); // _ZN6S246C63v12Ev
  virtual void  v13(); // _ZN6S246C63v13Ev
  virtual void  v14(); // _ZN6S246C63v14Ev
  virtual void  v15(); // _ZN6S246C63v15Ev
  virtual void  v16(); // _ZN6S246C63v16Ev
  virtual void  v17(); // _ZN6S246C63v17Ev
  virtual void  v18(); // _ZN6S246C63v18Ev
  virtual void  v19(); // _ZN6S246C63v19Ev
  virtual void  v20(); // _ZN6S246C63v20Ev
  virtual void  v21(); // _ZN6S246C63v21Ev
  virtual void  v22(); // _ZN6S246C63v22Ev
  virtual void  v23(); // _ZN6S246C63v23Ev
  virtual void  v24(); // _ZN6S246C63v24Ev
  virtual void  v25(); // _ZN6S246C63v25Ev
  virtual void  v26(); // _ZN6S246C63v26Ev
  virtual void  v27(); // _ZN6S246C63v27Ev
  virtual void  v28(); // _ZN6S246C63v28Ev
  virtual void  v29(); // _ZN6S246C63v29Ev
  virtual void  v30(); // _ZN6S246C63v30Ev
  virtual void  v31(); // _ZN6S246C63v31Ev
  virtual void  v32(); // _ZN6S246C63v32Ev
  virtual void  v33(); // _ZN6S246C63v33Ev
  virtual void  v34(); // _ZN6S246C63v34Ev
  virtual void  v35(); // _ZN6S246C63v35Ev
  virtual void  v36(); // _ZN6S246C63v36Ev
  virtual void  v37(); // _ZN6S246C63v37Ev
  virtual void  v38(); // _ZN6S246C63v38Ev
  virtual void  v39(); // _ZN6S246C63v39Ev
  virtual void  v40(); // _ZN6S246C63v40Ev
  virtual void  v41(); // _ZN6S246C63v41Ev
  virtual void  v42(); // _ZN6S246C63v42Ev
  virtual void  v43(); // _ZN6S246C63v43Ev
  virtual void  v44(); // _ZN6S246C63v44Ev
  virtual void  v45(); // _ZN6S246C63v45Ev
  virtual void  v46(); // _ZN6S246C63v46Ev
  virtual void  v47(); // _ZN6S246C63v47Ev
  virtual void  v48(); // _ZN6S246C63v48Ev
  virtual void  v49(); // _ZN6S246C63v49Ev
  virtual void  v50(); // _ZN6S246C63v50Ev
  virtual void  v51(); // _ZN6S246C63v51Ev
  virtual void  v52(); // _ZN6S246C63v52Ev
  virtual void  v53(); // _ZN6S246C63v53Ev
  virtual void  v54(); // _ZN6S246C63v54Ev
  virtual void  v55(); // _ZN6S246C63v55Ev
  virtual void  v56(); // _ZN6S246C63v56Ev
  virtual void  v57(); // _ZN6S246C63v57Ev
  virtual void  v58(); // _ZN6S246C63v58Ev
  virtual void  v59(); // _ZN6S246C63v59Ev
  virtual void  v60(); // _ZN6S246C63v60Ev
  virtual void  v61(); // _ZN6S246C63v61Ev
  virtual void  v62(); // _ZN6S246C63v62Ev
  virtual void  v63(); // _ZN6S246C63v63Ev
  virtual void  v64(); // _ZN6S246C63v64Ev
  virtual void  v65(); // _ZN6S246C63v65Ev
  virtual void  v66(); // _ZN6S246C63v66Ev
  virtual void  v67(); // _ZN6S246C63v67Ev
  virtual void  v68(); // _ZN6S246C63v68Ev
  S246C6(); // tgen
};
//SIG(-1 S246C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S246C6 ::~S246C6(){ note_dtor("S246C6", this);}
void  S246C6 ::v5(){vfunc_called(this, "_ZN6S246C62v5Ev");}
void  S246C6 ::v6(){vfunc_called(this, "_ZN6S246C62v6Ev");}
void  S246C6 ::v7(){vfunc_called(this, "_ZN6S246C62v7Ev");}
void  S246C6 ::v8(){vfunc_called(this, "_ZN6S246C62v8Ev");}
void  S246C6 ::v9(){vfunc_called(this, "_ZN6S246C62v9Ev");}
void  S246C6 ::v10(){vfunc_called(this, "_ZN6S246C63v10Ev");}
void  S246C6 ::v11(){vfunc_called(this, "_ZN6S246C63v11Ev");}
void  S246C6 ::v12(){vfunc_called(this, "_ZN6S246C63v12Ev");}
void  S246C6 ::v13(){vfunc_called(this, "_ZN6S246C63v13Ev");}
void  S246C6 ::v14(){vfunc_called(this, "_ZN6S246C63v14Ev");}
void  S246C6 ::v15(){vfunc_called(this, "_ZN6S246C63v15Ev");}
void  S246C6 ::v16(){vfunc_called(this, "_ZN6S246C63v16Ev");}
void  S246C6 ::v17(){vfunc_called(this, "_ZN6S246C63v17Ev");}
void  S246C6 ::v18(){vfunc_called(this, "_ZN6S246C63v18Ev");}
void  S246C6 ::v19(){vfunc_called(this, "_ZN6S246C63v19Ev");}
void  S246C6 ::v20(){vfunc_called(this, "_ZN6S246C63v20Ev");}
void  S246C6 ::v21(){vfunc_called(this, "_ZN6S246C63v21Ev");}
void  S246C6 ::v22(){vfunc_called(this, "_ZN6S246C63v22Ev");}
void  S246C6 ::v23(){vfunc_called(this, "_ZN6S246C63v23Ev");}
void  S246C6 ::v24(){vfunc_called(this, "_ZN6S246C63v24Ev");}
void  S246C6 ::v25(){vfunc_called(this, "_ZN6S246C63v25Ev");}
void  S246C6 ::v26(){vfunc_called(this, "_ZN6S246C63v26Ev");}
void  S246C6 ::v27(){vfunc_called(this, "_ZN6S246C63v27Ev");}
void  S246C6 ::v28(){vfunc_called(this, "_ZN6S246C63v28Ev");}
void  S246C6 ::v29(){vfunc_called(this, "_ZN6S246C63v29Ev");}
void  S246C6 ::v30(){vfunc_called(this, "_ZN6S246C63v30Ev");}
void  S246C6 ::v31(){vfunc_called(this, "_ZN6S246C63v31Ev");}
void  S246C6 ::v32(){vfunc_called(this, "_ZN6S246C63v32Ev");}
void  S246C6 ::v33(){vfunc_called(this, "_ZN6S246C63v33Ev");}
void  S246C6 ::v34(){vfunc_called(this, "_ZN6S246C63v34Ev");}
void  S246C6 ::v35(){vfunc_called(this, "_ZN6S246C63v35Ev");}
void  S246C6 ::v36(){vfunc_called(this, "_ZN6S246C63v36Ev");}
void  S246C6 ::v37(){vfunc_called(this, "_ZN6S246C63v37Ev");}
void  S246C6 ::v38(){vfunc_called(this, "_ZN6S246C63v38Ev");}
void  S246C6 ::v39(){vfunc_called(this, "_ZN6S246C63v39Ev");}
void  S246C6 ::v40(){vfunc_called(this, "_ZN6S246C63v40Ev");}
void  S246C6 ::v41(){vfunc_called(this, "_ZN6S246C63v41Ev");}
void  S246C6 ::v42(){vfunc_called(this, "_ZN6S246C63v42Ev");}
void  S246C6 ::v43(){vfunc_called(this, "_ZN6S246C63v43Ev");}
void  S246C6 ::v44(){vfunc_called(this, "_ZN6S246C63v44Ev");}
void  S246C6 ::v45(){vfunc_called(this, "_ZN6S246C63v45Ev");}
void  S246C6 ::v46(){vfunc_called(this, "_ZN6S246C63v46Ev");}
void  S246C6 ::v47(){vfunc_called(this, "_ZN6S246C63v47Ev");}
void  S246C6 ::v48(){vfunc_called(this, "_ZN6S246C63v48Ev");}
void  S246C6 ::v49(){vfunc_called(this, "_ZN6S246C63v49Ev");}
void  S246C6 ::v50(){vfunc_called(this, "_ZN6S246C63v50Ev");}
void  S246C6 ::v51(){vfunc_called(this, "_ZN6S246C63v51Ev");}
void  S246C6 ::v52(){vfunc_called(this, "_ZN6S246C63v52Ev");}
void  S246C6 ::v53(){vfunc_called(this, "_ZN6S246C63v53Ev");}
void  S246C6 ::v54(){vfunc_called(this, "_ZN6S246C63v54Ev");}
void  S246C6 ::v55(){vfunc_called(this, "_ZN6S246C63v55Ev");}
void  S246C6 ::v56(){vfunc_called(this, "_ZN6S246C63v56Ev");}
void  S246C6 ::v57(){vfunc_called(this, "_ZN6S246C63v57Ev");}
void  S246C6 ::v58(){vfunc_called(this, "_ZN6S246C63v58Ev");}
void  S246C6 ::v59(){vfunc_called(this, "_ZN6S246C63v59Ev");}
void  S246C6 ::v60(){vfunc_called(this, "_ZN6S246C63v60Ev");}
void  S246C6 ::v61(){vfunc_called(this, "_ZN6S246C63v61Ev");}
void  S246C6 ::v62(){vfunc_called(this, "_ZN6S246C63v62Ev");}
void  S246C6 ::v63(){vfunc_called(this, "_ZN6S246C63v63Ev");}
void  S246C6 ::v64(){vfunc_called(this, "_ZN6S246C63v64Ev");}
void  S246C6 ::v65(){vfunc_called(this, "_ZN6S246C63v65Ev");}
void  S246C6 ::v66(){vfunc_called(this, "_ZN6S246C63v66Ev");}
void  S246C6 ::v67(){vfunc_called(this, "_ZN6S246C63v67Ev");}
void  S246C6 ::v68(){vfunc_called(this, "_ZN6S246C63v68Ev");}
S246C6 ::S246C6(){ note_ctor("S246C6", this);} // tgen

static void Test_S246C6()
{
  extern Class_Descriptor cd_S246C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S246C6, buf);
    S246C6 *dp, &lv = *(dp=new (buf) S246C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S246C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S246C6)");
    check_field_offset(lv, s246c6f0, ABISELECT(8,4), "S246C6.s246c6f0");
    check_field_offset(lv, s246c6f1, ABISELECT(16,8), "S246C6.s246c6f1");
    check_field_offset(lv, s246c6f2, ABISELECT(24,16), "S246C6.s246c6f2");
    check_field_offset(lv, s246c6f3, ABISELECT(56,32), "S246C6.s246c6f3");
    check_field_offset(lv, s246c6f4, ABISELECT(64,40), "S246C6.s246c6f4");
    check_field_offset(lv, s246c6f5, ABISELECT(72,44), "S246C6.s246c6f5");
    check_field_offset(lv, s246c6f6, ABISELECT(80,52), "S246C6.s246c6f6");
    test_class_info(&lv, &cd_S246C6);
    dp->~S246C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS246C6(Test_S246C6, "S246C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S246C6C1Ev();
extern void _ZN6S246C6D1Ev();
Name_Map name_map_S246C6[] = {
  NSPAIR(_ZN6S246C6C1Ev),
  NSPAIR(_ZN6S246C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S246C6[];
extern void _ZN6S246C6D1Ev();
extern void _ZN6S246C6D0Ev();
extern void _ZN6S246C62v5Ev();
extern void _ZN6S246C62v6Ev();
extern void _ZN6S246C62v7Ev();
extern void _ZN6S246C62v8Ev();
extern void _ZN6S246C62v9Ev();
extern void _ZN6S246C63v10Ev();
extern void _ZN6S246C63v11Ev();
extern void _ZN6S246C63v12Ev();
extern void _ZN6S246C63v13Ev();
extern void _ZN6S246C63v14Ev();
extern void _ZN6S246C63v15Ev();
extern void _ZN6S246C63v16Ev();
extern void _ZN6S246C63v17Ev();
extern void _ZN6S246C63v18Ev();
extern void _ZN6S246C63v19Ev();
extern void _ZN6S246C63v20Ev();
extern void _ZN6S246C63v21Ev();
extern void _ZN6S246C63v22Ev();
extern void _ZN6S246C63v23Ev();
extern void _ZN6S246C63v24Ev();
extern void _ZN6S246C63v25Ev();
extern void _ZN6S246C63v26Ev();
extern void _ZN6S246C63v27Ev();
extern void _ZN6S246C63v28Ev();
extern void _ZN6S246C63v29Ev();
extern void _ZN6S246C63v30Ev();
extern void _ZN6S246C63v31Ev();
extern void _ZN6S246C63v32Ev();
extern void _ZN6S246C63v33Ev();
extern void _ZN6S246C63v34Ev();
extern void _ZN6S246C63v35Ev();
extern void _ZN6S246C63v36Ev();
extern void _ZN6S246C63v37Ev();
extern void _ZN6S246C63v38Ev();
extern void _ZN6S246C63v39Ev();
extern void _ZN6S246C63v40Ev();
extern void _ZN6S246C63v41Ev();
extern void _ZN6S246C63v42Ev();
extern void _ZN6S246C63v43Ev();
extern void _ZN6S246C63v44Ev();
extern void _ZN6S246C63v45Ev();
extern void _ZN6S246C63v46Ev();
extern void _ZN6S246C63v47Ev();
extern void _ZN6S246C63v48Ev();
extern void _ZN6S246C63v49Ev();
extern void _ZN6S246C63v50Ev();
extern void _ZN6S246C63v51Ev();
extern void _ZN6S246C63v52Ev();
extern void _ZN6S246C63v53Ev();
extern void _ZN6S246C63v54Ev();
extern void _ZN6S246C63v55Ev();
extern void _ZN6S246C63v56Ev();
extern void _ZN6S246C63v57Ev();
extern void _ZN6S246C63v58Ev();
extern void _ZN6S246C63v59Ev();
extern void _ZN6S246C63v60Ev();
extern void _ZN6S246C63v61Ev();
extern void _ZN6S246C63v62Ev();
extern void _ZN6S246C63v63Ev();
extern void _ZN6S246C63v64Ev();
extern void _ZN6S246C63v65Ev();
extern void _ZN6S246C63v66Ev();
extern void _ZN6S246C63v67Ev();
extern void _ZN6S246C63v68Ev();
static  VTBL_ENTRY vtc_S246C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S246C6[0]),
  (VTBL_ENTRY)&_ZN6S246C6D1Ev,
  (VTBL_ENTRY)&_ZN6S246C6D0Ev,
  (VTBL_ENTRY)&_ZN6S246C62v5Ev,
  (VTBL_ENTRY)&_ZN6S246C62v6Ev,
  (VTBL_ENTRY)&_ZN6S246C62v7Ev,
  (VTBL_ENTRY)&_ZN6S246C62v8Ev,
  (VTBL_ENTRY)&_ZN6S246C62v9Ev,
  (VTBL_ENTRY)&_ZN6S246C63v10Ev,
  (VTBL_ENTRY)&_ZN6S246C63v11Ev,
  (VTBL_ENTRY)&_ZN6S246C63v12Ev,
  (VTBL_ENTRY)&_ZN6S246C63v13Ev,
  (VTBL_ENTRY)&_ZN6S246C63v14Ev,
  (VTBL_ENTRY)&_ZN6S246C63v15Ev,
  (VTBL_ENTRY)&_ZN6S246C63v16Ev,
  (VTBL_ENTRY)&_ZN6S246C63v17Ev,
  (VTBL_ENTRY)&_ZN6S246C63v18Ev,
  (VTBL_ENTRY)&_ZN6S246C63v19Ev,
  (VTBL_ENTRY)&_ZN6S246C63v20Ev,
  (VTBL_ENTRY)&_ZN6S246C63v21Ev,
  (VTBL_ENTRY)&_ZN6S246C63v22Ev,
  (VTBL_ENTRY)&_ZN6S246C63v23Ev,
  (VTBL_ENTRY)&_ZN6S246C63v24Ev,
  (VTBL_ENTRY)&_ZN6S246C63v25Ev,
  (VTBL_ENTRY)&_ZN6S246C63v26Ev,
  (VTBL_ENTRY)&_ZN6S246C63v27Ev,
  (VTBL_ENTRY)&_ZN6S246C63v28Ev,
  (VTBL_ENTRY)&_ZN6S246C63v29Ev,
  (VTBL_ENTRY)&_ZN6S246C63v30Ev,
  (VTBL_ENTRY)&_ZN6S246C63v31Ev,
  (VTBL_ENTRY)&_ZN6S246C63v32Ev,
  (VTBL_ENTRY)&_ZN6S246C63v33Ev,
  (VTBL_ENTRY)&_ZN6S246C63v34Ev,
  (VTBL_ENTRY)&_ZN6S246C63v35Ev,
  (VTBL_ENTRY)&_ZN6S246C63v36Ev,
  (VTBL_ENTRY)&_ZN6S246C63v37Ev,
  (VTBL_ENTRY)&_ZN6S246C63v38Ev,
  (VTBL_ENTRY)&_ZN6S246C63v39Ev,
  (VTBL_ENTRY)&_ZN6S246C63v40Ev,
  (VTBL_ENTRY)&_ZN6S246C63v41Ev,
  (VTBL_ENTRY)&_ZN6S246C63v42Ev,
  (VTBL_ENTRY)&_ZN6S246C63v43Ev,
  (VTBL_ENTRY)&_ZN6S246C63v44Ev,
  (VTBL_ENTRY)&_ZN6S246C63v45Ev,
  (VTBL_ENTRY)&_ZN6S246C63v46Ev,
  (VTBL_ENTRY)&_ZN6S246C63v47Ev,
  (VTBL_ENTRY)&_ZN6S246C63v48Ev,
  (VTBL_ENTRY)&_ZN6S246C63v49Ev,
  (VTBL_ENTRY)&_ZN6S246C63v50Ev,
  (VTBL_ENTRY)&_ZN6S246C63v51Ev,
  (VTBL_ENTRY)&_ZN6S246C63v52Ev,
  (VTBL_ENTRY)&_ZN6S246C63v53Ev,
  (VTBL_ENTRY)&_ZN6S246C63v54Ev,
  (VTBL_ENTRY)&_ZN6S246C63v55Ev,
  (VTBL_ENTRY)&_ZN6S246C63v56Ev,
  (VTBL_ENTRY)&_ZN6S246C63v57Ev,
  (VTBL_ENTRY)&_ZN6S246C63v58Ev,
  (VTBL_ENTRY)&_ZN6S246C63v59Ev,
  (VTBL_ENTRY)&_ZN6S246C63v60Ev,
  (VTBL_ENTRY)&_ZN6S246C63v61Ev,
  (VTBL_ENTRY)&_ZN6S246C63v62Ev,
  (VTBL_ENTRY)&_ZN6S246C63v63Ev,
  (VTBL_ENTRY)&_ZN6S246C63v64Ev,
  (VTBL_ENTRY)&_ZN6S246C63v65Ev,
  (VTBL_ENTRY)&_ZN6S246C63v66Ev,
  (VTBL_ENTRY)&_ZN6S246C63v67Ev,
  (VTBL_ENTRY)&_ZN6S246C63v68Ev,
};
extern VTBL_ENTRY _ZTI6S246C6[];
extern  VTBL_ENTRY _ZTV6S246C6[];
Class_Descriptor cd_S246C6 = {  "S246C6", // class name
  0,0,//no base classes
  &(vtc_S246C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S246C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S246C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S246C12_nt  {
  void  mf246c12(); // _ZN10S246C12_nt8mf246c12Ev
};
//SIG(-1 S246C12_nt) C1{ m}


void  S246C12_nt ::mf246c12(){}

//skip512 S246C12_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S246C12_nt[];
VTBL_ENTRY *P__ZTI10S246C12_nt = _ZTI10S246C12_nt; 
Class_Descriptor cd_S246C12_nt = {  "S246C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S246C12_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S246C5_nt  : S246C6 {
  int s246c5f0[2];
  void *s246c5f1;
  int s246c5f2[2];
  ::S27C26_nt s246c5f3;
  ::S27C26_nt s246c5f4;
  ::S246C12_nt s246c5f5;
  ::S27C26_nt s246c5f6;
  unsigned int s246c5f7:1;
  unsigned int s246c5f8:1;
  unsigned int s246c5f9:1;
  unsigned int s246c5f10:1;
  unsigned int s246c5f11:1;
  int s246c5f12[2];
  virtual  ~S246C5_nt(); // _ZN9S246C5_ntD1Ev
  virtual void  v69(); // _ZN9S246C5_nt3v69Ev
  virtual void  v70(); // _ZN9S246C5_nt3v70Ev
  virtual void  v71(); // _ZN9S246C5_nt3v71Ev
  virtual void  v72(); // _ZN9S246C5_nt3v72Ev
  virtual void  v73(); // _ZN9S246C5_nt3v73Ev
  virtual void  v74(); // _ZN9S246C5_nt3v74Ev
  virtual void  v75(); // _ZN9S246C5_nt3v75Ev
  virtual void  v76(); // _ZN9S246C5_nt3v76Ev
  virtual void  v77(); // _ZN9S246C5_nt3v77Ev
  virtual void  v78(); // _ZN9S246C5_nt3v78Ev
  virtual void  v79(); // _ZN9S246C5_nt3v79Ev
  virtual void  v80(); // _ZN9S246C5_nt3v80Ev
  virtual void  v81(); // _ZN9S246C5_nt3v81Ev
  virtual void  v82(); // _ZN9S246C5_nt3v82Ev
  virtual void  v83(); // _ZN9S246C5_nt3v83Ev
  virtual void  v84(); // _ZN9S246C5_nt3v84Ev
  virtual void  v85(); // _ZN9S246C5_nt3v85Ev
  virtual void  v86(); // _ZN9S246C5_nt3v86Ev
  virtual void  v87(); // _ZN9S246C5_nt3v87Ev
  virtual void  v88(); // _ZN9S246C5_nt3v88Ev
  virtual void  v89(); // _ZN9S246C5_nt3v89Ev
  virtual void  v90(); // _ZN9S246C5_nt3v90Ev
  S246C5_nt(); // tgen
};
//SIG(-1 S246C5_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S246C5_nt ::~S246C5_nt(){ note_dtor("S246C5_nt", this);}
void  S246C5_nt ::v69(){vfunc_called(this, "_ZN9S246C5_nt3v69Ev");}
void  S246C5_nt ::v70(){vfunc_called(this, "_ZN9S246C5_nt3v70Ev");}
void  S246C5_nt ::v71(){vfunc_called(this, "_ZN9S246C5_nt3v71Ev");}
void  S246C5_nt ::v72(){vfunc_called(this, "_ZN9S246C5_nt3v72Ev");}
void  S246C5_nt ::v73(){vfunc_called(this, "_ZN9S246C5_nt3v73Ev");}
void  S246C5_nt ::v74(){vfunc_called(this, "_ZN9S246C5_nt3v74Ev");}
void  S246C5_nt ::v75(){vfunc_called(this, "_ZN9S246C5_nt3v75Ev");}
void  S246C5_nt ::v76(){vfunc_called(this, "_ZN9S246C5_nt3v76Ev");}
void  S246C5_nt ::v77(){vfunc_called(this, "_ZN9S246C5_nt3v77Ev");}
void  S246C5_nt ::v78(){vfunc_called(this, "_ZN9S246C5_nt3v78Ev");}
void  S246C5_nt ::v79(){vfunc_called(this, "_ZN9S246C5_nt3v79Ev");}
void  S246C5_nt ::v80(){vfunc_called(this, "_ZN9S246C5_nt3v80Ev");}
void  S246C5_nt ::v81(){vfunc_called(this, "_ZN9S246C5_nt3v81Ev");}
void  S246C5_nt ::v82(){vfunc_called(this, "_ZN9S246C5_nt3v82Ev");}
void  S246C5_nt ::v83(){vfunc_called(this, "_ZN9S246C5_nt3v83Ev");}
void  S246C5_nt ::v84(){vfunc_called(this, "_ZN9S246C5_nt3v84Ev");}
void  S246C5_nt ::v85(){vfunc_called(this, "_ZN9S246C5_nt3v85Ev");}
void  S246C5_nt ::v86(){vfunc_called(this, "_ZN9S246C5_nt3v86Ev");}
void  S246C5_nt ::v87(){vfunc_called(this, "_ZN9S246C5_nt3v87Ev");}
void  S246C5_nt ::v88(){vfunc_called(this, "_ZN9S246C5_nt3v88Ev");}
void  S246C5_nt ::v89(){vfunc_called(this, "_ZN9S246C5_nt3v89Ev");}
void  S246C5_nt ::v90(){vfunc_called(this, "_ZN9S246C5_nt3v90Ev");}
S246C5_nt ::S246C5_nt(){ note_ctor("S246C5_nt", this);} // tgen

//skip512 S246C5_nt

#else // __cplusplus

extern void _ZN9S246C5_ntC1Ev();
extern void _ZN9S246C5_ntD1Ev();
Name_Map name_map_S246C5_nt[] = {
  NSPAIR(_ZN9S246C5_ntC1Ev),
  NSPAIR(_ZN9S246C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C6;
extern VTBL_ENTRY _ZTI6S246C6[];
extern  VTBL_ENTRY _ZTV6S246C6[];
static Base_Class bases_S246C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S246C5_nt[];
extern void _ZN9S246C5_ntD1Ev();
extern void _ZN9S246C5_ntD0Ev();
extern void _ZN6S246C62v5Ev();
extern void _ZN6S246C62v6Ev();
extern void _ZN6S246C62v7Ev();
extern void _ZN6S246C62v8Ev();
extern void _ZN6S246C62v9Ev();
extern void _ZN6S246C63v10Ev();
extern void _ZN6S246C63v11Ev();
extern void _ZN6S246C63v12Ev();
extern void _ZN6S246C63v13Ev();
extern void _ZN6S246C63v14Ev();
extern void _ZN6S246C63v15Ev();
extern void _ZN6S246C63v16Ev();
extern void _ZN6S246C63v17Ev();
extern void _ZN6S246C63v18Ev();
extern void _ZN6S246C63v19Ev();
extern void _ZN6S246C63v20Ev();
extern void _ZN6S246C63v21Ev();
extern void _ZN6S246C63v22Ev();
extern void _ZN6S246C63v23Ev();
extern void _ZN6S246C63v24Ev();
extern void _ZN6S246C63v25Ev();
extern void _ZN6S246C63v26Ev();
extern void _ZN6S246C63v27Ev();
extern void _ZN6S246C63v28Ev();
extern void _ZN6S246C63v29Ev();
extern void _ZN6S246C63v30Ev();
extern void _ZN6S246C63v31Ev();
extern void _ZN6S246C63v32Ev();
extern void _ZN6S246C63v33Ev();
extern void _ZN6S246C63v34Ev();
extern void _ZN6S246C63v35Ev();
extern void _ZN6S246C63v36Ev();
extern void _ZN6S246C63v37Ev();
extern void _ZN6S246C63v38Ev();
extern void _ZN6S246C63v39Ev();
extern void _ZN6S246C63v40Ev();
extern void _ZN6S246C63v41Ev();
extern void _ZN6S246C63v42Ev();
extern void _ZN6S246C63v43Ev();
extern void _ZN6S246C63v44Ev();
extern void _ZN6S246C63v45Ev();
extern void _ZN6S246C63v46Ev();
extern void _ZN6S246C63v47Ev();
extern void _ZN6S246C63v48Ev();
extern void _ZN6S246C63v49Ev();
extern void _ZN6S246C63v50Ev();
extern void _ZN6S246C63v51Ev();
extern void _ZN6S246C63v52Ev();
extern void _ZN6S246C63v53Ev();
extern void _ZN6S246C63v54Ev();
extern void _ZN6S246C63v55Ev();
extern void _ZN6S246C63v56Ev();
extern void _ZN6S246C63v57Ev();
extern void _ZN6S246C63v58Ev();
extern void _ZN6S246C63v59Ev();
extern void _ZN6S246C63v60Ev();
extern void _ZN6S246C63v61Ev();
extern void _ZN6S246C63v62Ev();
extern void _ZN6S246C63v63Ev();
extern void _ZN6S246C63v64Ev();
extern void _ZN6S246C63v65Ev();
extern void _ZN6S246C63v66Ev();
extern void _ZN6S246C63v67Ev();
extern void _ZN6S246C63v68Ev();
extern void _ZN9S246C5_nt3v69Ev();
extern void _ZN9S246C5_nt3v70Ev();
extern void _ZN9S246C5_nt3v71Ev();
extern void _ZN9S246C5_nt3v72Ev();
extern void _ZN9S246C5_nt3v73Ev();
extern void _ZN9S246C5_nt3v74Ev();
extern void _ZN9S246C5_nt3v75Ev();
extern void _ZN9S246C5_nt3v76Ev();
extern void _ZN9S246C5_nt3v77Ev();
extern void _ZN9S246C5_nt3v78Ev();
extern void _ZN9S246C5_nt3v79Ev();
extern void _ZN9S246C5_nt3v80Ev();
extern void _ZN9S246C5_nt3v81Ev();
extern void _ZN9S246C5_nt3v82Ev();
extern void _ZN9S246C5_nt3v83Ev();
extern void _ZN9S246C5_nt3v84Ev();
extern void _ZN9S246C5_nt3v85Ev();
extern void _ZN9S246C5_nt3v86Ev();
extern void _ZN9S246C5_nt3v87Ev();
extern void _ZN9S246C5_nt3v88Ev();
extern void _ZN9S246C5_nt3v89Ev();
extern void _ZN9S246C5_nt3v90Ev();
static  VTBL_ENTRY vtc_S246C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S246C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S246C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S246C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S246C62v5Ev,
  (VTBL_ENTRY)&_ZN6S246C62v6Ev,
  (VTBL_ENTRY)&_ZN6S246C62v7Ev,
  (VTBL_ENTRY)&_ZN6S246C62v8Ev,
  (VTBL_ENTRY)&_ZN6S246C62v9Ev,
  (VTBL_ENTRY)&_ZN6S246C63v10Ev,
  (VTBL_ENTRY)&_ZN6S246C63v11Ev,
  (VTBL_ENTRY)&_ZN6S246C63v12Ev,
  (VTBL_ENTRY)&_ZN6S246C63v13Ev,
  (VTBL_ENTRY)&_ZN6S246C63v14Ev,
  (VTBL_ENTRY)&_ZN6S246C63v15Ev,
  (VTBL_ENTRY)&_ZN6S246C63v16Ev,
  (VTBL_ENTRY)&_ZN6S246C63v17Ev,
  (VTBL_ENTRY)&_ZN6S246C63v18Ev,
  (VTBL_ENTRY)&_ZN6S246C63v19Ev,
  (VTBL_ENTRY)&_ZN6S246C63v20Ev,
  (VTBL_ENTRY)&_ZN6S246C63v21Ev,
  (VTBL_ENTRY)&_ZN6S246C63v22Ev,
  (VTBL_ENTRY)&_ZN6S246C63v23Ev,
  (VTBL_ENTRY)&_ZN6S246C63v24Ev,
  (VTBL_ENTRY)&_ZN6S246C63v25Ev,
  (VTBL_ENTRY)&_ZN6S246C63v26Ev,
  (VTBL_ENTRY)&_ZN6S246C63v27Ev,
  (VTBL_ENTRY)&_ZN6S246C63v28Ev,
  (VTBL_ENTRY)&_ZN6S246C63v29Ev,
  (VTBL_ENTRY)&_ZN6S246C63v30Ev,
  (VTBL_ENTRY)&_ZN6S246C63v31Ev,
  (VTBL_ENTRY)&_ZN6S246C63v32Ev,
  (VTBL_ENTRY)&_ZN6S246C63v33Ev,
  (VTBL_ENTRY)&_ZN6S246C63v34Ev,
  (VTBL_ENTRY)&_ZN6S246C63v35Ev,
  (VTBL_ENTRY)&_ZN6S246C63v36Ev,
  (VTBL_ENTRY)&_ZN6S246C63v37Ev,
  (VTBL_ENTRY)&_ZN6S246C63v38Ev,
  (VTBL_ENTRY)&_ZN6S246C63v39Ev,
  (VTBL_ENTRY)&_ZN6S246C63v40Ev,
  (VTBL_ENTRY)&_ZN6S246C63v41Ev,
  (VTBL_ENTRY)&_ZN6S246C63v42Ev,
  (VTBL_ENTRY)&_ZN6S246C63v43Ev,
  (VTBL_ENTRY)&_ZN6S246C63v44Ev,
  (VTBL_ENTRY)&_ZN6S246C63v45Ev,
  (VTBL_ENTRY)&_ZN6S246C63v46Ev,
  (VTBL_ENTRY)&_ZN6S246C63v47Ev,
  (VTBL_ENTRY)&_ZN6S246C63v48Ev,
  (VTBL_ENTRY)&_ZN6S246C63v49Ev,
  (VTBL_ENTRY)&_ZN6S246C63v50Ev,
  (VTBL_ENTRY)&_ZN6S246C63v51Ev,
  (VTBL_ENTRY)&_ZN6S246C63v52Ev,
  (VTBL_ENTRY)&_ZN6S246C63v53Ev,
  (VTBL_ENTRY)&_ZN6S246C63v54Ev,
  (VTBL_ENTRY)&_ZN6S246C63v55Ev,
  (VTBL_ENTRY)&_ZN6S246C63v56Ev,
  (VTBL_ENTRY)&_ZN6S246C63v57Ev,
  (VTBL_ENTRY)&_ZN6S246C63v58Ev,
  (VTBL_ENTRY)&_ZN6S246C63v59Ev,
  (VTBL_ENTRY)&_ZN6S246C63v60Ev,
  (VTBL_ENTRY)&_ZN6S246C63v61Ev,
  (VTBL_ENTRY)&_ZN6S246C63v62Ev,
  (VTBL_ENTRY)&_ZN6S246C63v63Ev,
  (VTBL_ENTRY)&_ZN6S246C63v64Ev,
  (VTBL_ENTRY)&_ZN6S246C63v65Ev,
  (VTBL_ENTRY)&_ZN6S246C63v66Ev,
  (VTBL_ENTRY)&_ZN6S246C63v67Ev,
  (VTBL_ENTRY)&_ZN6S246C63v68Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v90Ev,
};
extern VTBL_ENTRY _ZTI9S246C5_nt[];
VTBL_ENTRY *P__ZTI9S246C5_nt = _ZTI9S246C5_nt; 
extern  VTBL_ENTRY _ZTV9S246C5_nt[];
Class_Descriptor cd_S246C5_nt = {  "S246C5_nt", // class name
  bases_S246C5_nt, 1,
  &(vtc_S246C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S246C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S246C5_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S246C4_nt  : S246C5_nt {
  unsigned int s246c4f0:1;
  unsigned int s246c4f1:1;
  unsigned int s246c4f2:1;
  ::S27C80 s246c4f3;
  ::S27C76 s246c4f4;
  ::S27C71 s246c4f5;
  ::S27C66 s246c4f6;
  int s246c4f7[3];
  virtual  ~S246C4_nt(); // _ZN9S246C4_ntD1Ev
  virtual void  v91(); // _ZN9S246C4_nt3v91Ev
  virtual void  v92(); // _ZN9S246C4_nt3v92Ev
  virtual void  v93(); // _ZN9S246C4_nt3v93Ev
  virtual void  v94(); // _ZN9S246C4_nt3v94Ev
  virtual void  v95(); // _ZN9S246C4_nt3v95Ev
  virtual void  v96(); // _ZN9S246C4_nt3v96Ev
  virtual void  v97(); // _ZN9S246C4_nt3v97Ev
  virtual void  v98(); // _ZN9S246C4_nt3v98Ev
  virtual void  v99(); // _ZN9S246C4_nt3v99Ev
  virtual void  v100(); // _ZN9S246C4_nt4v100Ev
  virtual void  v101(); // _ZN9S246C4_nt4v101Ev
  virtual void  v102(); // _ZN9S246C4_nt4v102Ev
  virtual void  v103(); // _ZN9S246C4_nt4v103Ev
  virtual void  v104(); // _ZN9S246C4_nt4v104Ev
  virtual void  v105(); // _ZN9S246C4_nt4v105Ev
  virtual void  v106(); // _ZN9S246C4_nt4v106Ev
  virtual void  v107(); // _ZN9S246C4_nt4v107Ev
  virtual void  v108(); // _ZN9S246C4_nt4v108Ev
  virtual void  v109(); // _ZN9S246C4_nt4v109Ev
  virtual void  v110(); // _ZN9S246C4_nt4v110Ev
  S246C4_nt(); // tgen
};
//SIG(-1 S246C4_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S246C4_nt ::~S246C4_nt(){ note_dtor("S246C4_nt", this);}
void  S246C4_nt ::v91(){vfunc_called(this, "_ZN9S246C4_nt3v91Ev");}
void  S246C4_nt ::v92(){vfunc_called(this, "_ZN9S246C4_nt3v92Ev");}
void  S246C4_nt ::v93(){vfunc_called(this, "_ZN9S246C4_nt3v93Ev");}
void  S246C4_nt ::v94(){vfunc_called(this, "_ZN9S246C4_nt3v94Ev");}
void  S246C4_nt ::v95(){vfunc_called(this, "_ZN9S246C4_nt3v95Ev");}
void  S246C4_nt ::v96(){vfunc_called(this, "_ZN9S246C4_nt3v96Ev");}
void  S246C4_nt ::v97(){vfunc_called(this, "_ZN9S246C4_nt3v97Ev");}
void  S246C4_nt ::v98(){vfunc_called(this, "_ZN9S246C4_nt3v98Ev");}
void  S246C4_nt ::v99(){vfunc_called(this, "_ZN9S246C4_nt3v99Ev");}
void  S246C4_nt ::v100(){vfunc_called(this, "_ZN9S246C4_nt4v100Ev");}
void  S246C4_nt ::v101(){vfunc_called(this, "_ZN9S246C4_nt4v101Ev");}
void  S246C4_nt ::v102(){vfunc_called(this, "_ZN9S246C4_nt4v102Ev");}
void  S246C4_nt ::v103(){vfunc_called(this, "_ZN9S246C4_nt4v103Ev");}
void  S246C4_nt ::v104(){vfunc_called(this, "_ZN9S246C4_nt4v104Ev");}
void  S246C4_nt ::v105(){vfunc_called(this, "_ZN9S246C4_nt4v105Ev");}
void  S246C4_nt ::v106(){vfunc_called(this, "_ZN9S246C4_nt4v106Ev");}
void  S246C4_nt ::v107(){vfunc_called(this, "_ZN9S246C4_nt4v107Ev");}
void  S246C4_nt ::v108(){vfunc_called(this, "_ZN9S246C4_nt4v108Ev");}
void  S246C4_nt ::v109(){vfunc_called(this, "_ZN9S246C4_nt4v109Ev");}
void  S246C4_nt ::v110(){vfunc_called(this, "_ZN9S246C4_nt4v110Ev");}
S246C4_nt ::S246C4_nt(){ note_ctor("S246C4_nt", this);} // tgen

//skip512 S246C4_nt

#else // __cplusplus

extern void _ZN9S246C4_ntC1Ev();
extern void _ZN9S246C4_ntD1Ev();
Name_Map name_map_S246C4_nt[] = {
  NSPAIR(_ZN9S246C4_ntC1Ev),
  NSPAIR(_ZN9S246C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C6;
extern VTBL_ENTRY _ZTI6S246C6[];
extern  VTBL_ENTRY _ZTV6S246C6[];
extern Class_Descriptor cd_S246C5_nt;
extern VTBL_ENTRY _ZTI9S246C5_nt[];
extern  VTBL_ENTRY _ZTV9S246C5_nt[];
static Base_Class bases_S246C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S246C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S246C4_nt[];
extern void _ZN9S246C4_ntD1Ev();
extern void _ZN9S246C4_ntD0Ev();
extern void _ZN6S246C62v5Ev();
extern void _ZN6S246C62v6Ev();
extern void _ZN6S246C62v7Ev();
extern void _ZN6S246C62v8Ev();
extern void _ZN6S246C62v9Ev();
extern void _ZN6S246C63v10Ev();
extern void _ZN6S246C63v11Ev();
extern void _ZN6S246C63v12Ev();
extern void _ZN6S246C63v13Ev();
extern void _ZN6S246C63v14Ev();
extern void _ZN6S246C63v15Ev();
extern void _ZN6S246C63v16Ev();
extern void _ZN6S246C63v17Ev();
extern void _ZN6S246C63v18Ev();
extern void _ZN6S246C63v19Ev();
extern void _ZN6S246C63v20Ev();
extern void _ZN6S246C63v21Ev();
extern void _ZN6S246C63v22Ev();
extern void _ZN6S246C63v23Ev();
extern void _ZN6S246C63v24Ev();
extern void _ZN6S246C63v25Ev();
extern void _ZN6S246C63v26Ev();
extern void _ZN6S246C63v27Ev();
extern void _ZN6S246C63v28Ev();
extern void _ZN6S246C63v29Ev();
extern void _ZN6S246C63v30Ev();
extern void _ZN6S246C63v31Ev();
extern void _ZN6S246C63v32Ev();
extern void _ZN6S246C63v33Ev();
extern void _ZN6S246C63v34Ev();
extern void _ZN6S246C63v35Ev();
extern void _ZN6S246C63v36Ev();
extern void _ZN6S246C63v37Ev();
extern void _ZN6S246C63v38Ev();
extern void _ZN6S246C63v39Ev();
extern void _ZN6S246C63v40Ev();
extern void _ZN6S246C63v41Ev();
extern void _ZN6S246C63v42Ev();
extern void _ZN6S246C63v43Ev();
extern void _ZN6S246C63v44Ev();
extern void _ZN6S246C63v45Ev();
extern void _ZN6S246C63v46Ev();
extern void _ZN6S246C63v47Ev();
extern void _ZN6S246C63v48Ev();
extern void _ZN6S246C63v49Ev();
extern void _ZN6S246C63v50Ev();
extern void _ZN6S246C63v51Ev();
extern void _ZN6S246C63v52Ev();
extern void _ZN6S246C63v53Ev();
extern void _ZN6S246C63v54Ev();
extern void _ZN6S246C63v55Ev();
extern void _ZN6S246C63v56Ev();
extern void _ZN6S246C63v57Ev();
extern void _ZN6S246C63v58Ev();
extern void _ZN6S246C63v59Ev();
extern void _ZN6S246C63v60Ev();
extern void _ZN6S246C63v61Ev();
extern void _ZN6S246C63v62Ev();
extern void _ZN6S246C63v63Ev();
extern void _ZN6S246C63v64Ev();
extern void _ZN6S246C63v65Ev();
extern void _ZN6S246C63v66Ev();
extern void _ZN6S246C63v67Ev();
extern void _ZN6S246C63v68Ev();
extern void _ZN9S246C5_nt3v69Ev();
extern void _ZN9S246C5_nt3v70Ev();
extern void _ZN9S246C5_nt3v71Ev();
extern void _ZN9S246C5_nt3v72Ev();
extern void _ZN9S246C5_nt3v73Ev();
extern void _ZN9S246C5_nt3v74Ev();
extern void _ZN9S246C5_nt3v75Ev();
extern void _ZN9S246C5_nt3v76Ev();
extern void _ZN9S246C5_nt3v77Ev();
extern void _ZN9S246C5_nt3v78Ev();
extern void _ZN9S246C5_nt3v79Ev();
extern void _ZN9S246C5_nt3v80Ev();
extern void _ZN9S246C5_nt3v81Ev();
extern void _ZN9S246C5_nt3v82Ev();
extern void _ZN9S246C5_nt3v83Ev();
extern void _ZN9S246C5_nt3v84Ev();
extern void _ZN9S246C5_nt3v85Ev();
extern void _ZN9S246C5_nt3v86Ev();
extern void _ZN9S246C5_nt3v87Ev();
extern void _ZN9S246C5_nt3v88Ev();
extern void _ZN9S246C5_nt3v89Ev();
extern void _ZN9S246C5_nt3v90Ev();
extern void _ZN9S246C4_nt3v91Ev();
extern void _ZN9S246C4_nt3v92Ev();
extern void _ZN9S246C4_nt3v93Ev();
extern void _ZN9S246C4_nt3v94Ev();
extern void _ZN9S246C4_nt3v95Ev();
extern void _ZN9S246C4_nt3v96Ev();
extern void _ZN9S246C4_nt3v97Ev();
extern void _ZN9S246C4_nt3v98Ev();
extern void _ZN9S246C4_nt3v99Ev();
extern void _ZN9S246C4_nt4v100Ev();
extern void _ZN9S246C4_nt4v101Ev();
extern void _ZN9S246C4_nt4v102Ev();
extern void _ZN9S246C4_nt4v103Ev();
extern void _ZN9S246C4_nt4v104Ev();
extern void _ZN9S246C4_nt4v105Ev();
extern void _ZN9S246C4_nt4v106Ev();
extern void _ZN9S246C4_nt4v107Ev();
extern void _ZN9S246C4_nt4v108Ev();
extern void _ZN9S246C4_nt4v109Ev();
extern void _ZN9S246C4_nt4v110Ev();
static  VTBL_ENTRY vtc_S246C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S246C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S246C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S246C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S246C62v5Ev,
  (VTBL_ENTRY)&_ZN6S246C62v6Ev,
  (VTBL_ENTRY)&_ZN6S246C62v7Ev,
  (VTBL_ENTRY)&_ZN6S246C62v8Ev,
  (VTBL_ENTRY)&_ZN6S246C62v9Ev,
  (VTBL_ENTRY)&_ZN6S246C63v10Ev,
  (VTBL_ENTRY)&_ZN6S246C63v11Ev,
  (VTBL_ENTRY)&_ZN6S246C63v12Ev,
  (VTBL_ENTRY)&_ZN6S246C63v13Ev,
  (VTBL_ENTRY)&_ZN6S246C63v14Ev,
  (VTBL_ENTRY)&_ZN6S246C63v15Ev,
  (VTBL_ENTRY)&_ZN6S246C63v16Ev,
  (VTBL_ENTRY)&_ZN6S246C63v17Ev,
  (VTBL_ENTRY)&_ZN6S246C63v18Ev,
  (VTBL_ENTRY)&_ZN6S246C63v19Ev,
  (VTBL_ENTRY)&_ZN6S246C63v20Ev,
  (VTBL_ENTRY)&_ZN6S246C63v21Ev,
  (VTBL_ENTRY)&_ZN6S246C63v22Ev,
  (VTBL_ENTRY)&_ZN6S246C63v23Ev,
  (VTBL_ENTRY)&_ZN6S246C63v24Ev,
  (VTBL_ENTRY)&_ZN6S246C63v25Ev,
  (VTBL_ENTRY)&_ZN6S246C63v26Ev,
  (VTBL_ENTRY)&_ZN6S246C63v27Ev,
  (VTBL_ENTRY)&_ZN6S246C63v28Ev,
  (VTBL_ENTRY)&_ZN6S246C63v29Ev,
  (VTBL_ENTRY)&_ZN6S246C63v30Ev,
  (VTBL_ENTRY)&_ZN6S246C63v31Ev,
  (VTBL_ENTRY)&_ZN6S246C63v32Ev,
  (VTBL_ENTRY)&_ZN6S246C63v33Ev,
  (VTBL_ENTRY)&_ZN6S246C63v34Ev,
  (VTBL_ENTRY)&_ZN6S246C63v35Ev,
  (VTBL_ENTRY)&_ZN6S246C63v36Ev,
  (VTBL_ENTRY)&_ZN6S246C63v37Ev,
  (VTBL_ENTRY)&_ZN6S246C63v38Ev,
  (VTBL_ENTRY)&_ZN6S246C63v39Ev,
  (VTBL_ENTRY)&_ZN6S246C63v40Ev,
  (VTBL_ENTRY)&_ZN6S246C63v41Ev,
  (VTBL_ENTRY)&_ZN6S246C63v42Ev,
  (VTBL_ENTRY)&_ZN6S246C63v43Ev,
  (VTBL_ENTRY)&_ZN6S246C63v44Ev,
  (VTBL_ENTRY)&_ZN6S246C63v45Ev,
  (VTBL_ENTRY)&_ZN6S246C63v46Ev,
  (VTBL_ENTRY)&_ZN6S246C63v47Ev,
  (VTBL_ENTRY)&_ZN6S246C63v48Ev,
  (VTBL_ENTRY)&_ZN6S246C63v49Ev,
  (VTBL_ENTRY)&_ZN6S246C63v50Ev,
  (VTBL_ENTRY)&_ZN6S246C63v51Ev,
  (VTBL_ENTRY)&_ZN6S246C63v52Ev,
  (VTBL_ENTRY)&_ZN6S246C63v53Ev,
  (VTBL_ENTRY)&_ZN6S246C63v54Ev,
  (VTBL_ENTRY)&_ZN6S246C63v55Ev,
  (VTBL_ENTRY)&_ZN6S246C63v56Ev,
  (VTBL_ENTRY)&_ZN6S246C63v57Ev,
  (VTBL_ENTRY)&_ZN6S246C63v58Ev,
  (VTBL_ENTRY)&_ZN6S246C63v59Ev,
  (VTBL_ENTRY)&_ZN6S246C63v60Ev,
  (VTBL_ENTRY)&_ZN6S246C63v61Ev,
  (VTBL_ENTRY)&_ZN6S246C63v62Ev,
  (VTBL_ENTRY)&_ZN6S246C63v63Ev,
  (VTBL_ENTRY)&_ZN6S246C63v64Ev,
  (VTBL_ENTRY)&_ZN6S246C63v65Ev,
  (VTBL_ENTRY)&_ZN6S246C63v66Ev,
  (VTBL_ENTRY)&_ZN6S246C63v67Ev,
  (VTBL_ENTRY)&_ZN6S246C63v68Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v110Ev,
};
extern VTBL_ENTRY _ZTI9S246C4_nt[];
VTBL_ENTRY *P__ZTI9S246C4_nt = _ZTI9S246C4_nt; 
extern  VTBL_ENTRY _ZTV9S246C4_nt[];
Class_Descriptor cd_S246C4_nt = {  "S246C4_nt", // class name
  bases_S246C4_nt, 2,
  &(vtc_S246C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S246C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S246C4_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S246C3_nt  : S246C4_nt {
  ::S27C9_nt s246c3f0;
  unsigned int s246c3f1:1;
  ::S27C62 s246c3f2;
  virtual  ~S246C3_nt(); // _ZN9S246C3_ntD1Ev
  virtual void  v111(); // _ZN9S246C3_nt4v111Ev
  virtual void  v112(); // _ZN9S246C3_nt4v112Ev
  virtual void  v113(); // _ZN9S246C3_nt4v113Ev
  virtual void  v114(); // _ZN9S246C3_nt4v114Ev
  S246C3_nt(); // tgen
};
//SIG(-1 S246C3_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S246C3_nt ::~S246C3_nt(){ note_dtor("S246C3_nt", this);}
void  S246C3_nt ::v111(){vfunc_called(this, "_ZN9S246C3_nt4v111Ev");}
void  S246C3_nt ::v112(){vfunc_called(this, "_ZN9S246C3_nt4v112Ev");}
void  S246C3_nt ::v113(){vfunc_called(this, "_ZN9S246C3_nt4v113Ev");}
void  S246C3_nt ::v114(){vfunc_called(this, "_ZN9S246C3_nt4v114Ev");}
S246C3_nt ::S246C3_nt(){ note_ctor("S246C3_nt", this);} // tgen

//skip512 S246C3_nt

#else // __cplusplus

extern void _ZN9S246C3_ntC1Ev();
extern void _ZN9S246C3_ntD1Ev();
Name_Map name_map_S246C3_nt[] = {
  NSPAIR(_ZN9S246C3_ntC1Ev),
  NSPAIR(_ZN9S246C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C6;
extern VTBL_ENTRY _ZTI6S246C6[];
extern  VTBL_ENTRY _ZTV6S246C6[];
extern Class_Descriptor cd_S246C5_nt;
extern VTBL_ENTRY _ZTI9S246C5_nt[];
extern  VTBL_ENTRY _ZTV9S246C5_nt[];
extern Class_Descriptor cd_S246C4_nt;
extern VTBL_ENTRY _ZTI9S246C4_nt[];
extern  VTBL_ENTRY _ZTV9S246C4_nt[];
static Base_Class bases_S246C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S246C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S246C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S246C3_nt[];
extern void _ZN9S246C3_ntD1Ev();
extern void _ZN9S246C3_ntD0Ev();
extern void _ZN6S246C62v5Ev();
extern void _ZN6S246C62v6Ev();
extern void _ZN6S246C62v7Ev();
extern void _ZN6S246C62v8Ev();
extern void _ZN6S246C62v9Ev();
extern void _ZN6S246C63v10Ev();
extern void _ZN6S246C63v11Ev();
extern void _ZN6S246C63v12Ev();
extern void _ZN6S246C63v13Ev();
extern void _ZN6S246C63v14Ev();
extern void _ZN6S246C63v15Ev();
extern void _ZN6S246C63v16Ev();
extern void _ZN6S246C63v17Ev();
extern void _ZN6S246C63v18Ev();
extern void _ZN6S246C63v19Ev();
extern void _ZN6S246C63v20Ev();
extern void _ZN6S246C63v21Ev();
extern void _ZN6S246C63v22Ev();
extern void _ZN6S246C63v23Ev();
extern void _ZN6S246C63v24Ev();
extern void _ZN6S246C63v25Ev();
extern void _ZN6S246C63v26Ev();
extern void _ZN6S246C63v27Ev();
extern void _ZN6S246C63v28Ev();
extern void _ZN6S246C63v29Ev();
extern void _ZN6S246C63v30Ev();
extern void _ZN6S246C63v31Ev();
extern void _ZN6S246C63v32Ev();
extern void _ZN6S246C63v33Ev();
extern void _ZN6S246C63v34Ev();
extern void _ZN6S246C63v35Ev();
extern void _ZN6S246C63v36Ev();
extern void _ZN6S246C63v37Ev();
extern void _ZN6S246C63v38Ev();
extern void _ZN6S246C63v39Ev();
extern void _ZN6S246C63v40Ev();
extern void _ZN6S246C63v41Ev();
extern void _ZN6S246C63v42Ev();
extern void _ZN6S246C63v43Ev();
extern void _ZN6S246C63v44Ev();
extern void _ZN6S246C63v45Ev();
extern void _ZN6S246C63v46Ev();
extern void _ZN6S246C63v47Ev();
extern void _ZN6S246C63v48Ev();
extern void _ZN6S246C63v49Ev();
extern void _ZN6S246C63v50Ev();
extern void _ZN6S246C63v51Ev();
extern void _ZN6S246C63v52Ev();
extern void _ZN6S246C63v53Ev();
extern void _ZN6S246C63v54Ev();
extern void _ZN6S246C63v55Ev();
extern void _ZN6S246C63v56Ev();
extern void _ZN6S246C63v57Ev();
extern void _ZN6S246C63v58Ev();
extern void _ZN6S246C63v59Ev();
extern void _ZN6S246C63v60Ev();
extern void _ZN6S246C63v61Ev();
extern void _ZN6S246C63v62Ev();
extern void _ZN6S246C63v63Ev();
extern void _ZN6S246C63v64Ev();
extern void _ZN6S246C63v65Ev();
extern void _ZN6S246C63v66Ev();
extern void _ZN6S246C63v67Ev();
extern void _ZN6S246C63v68Ev();
extern void _ZN9S246C5_nt3v69Ev();
extern void _ZN9S246C5_nt3v70Ev();
extern void _ZN9S246C5_nt3v71Ev();
extern void _ZN9S246C5_nt3v72Ev();
extern void _ZN9S246C5_nt3v73Ev();
extern void _ZN9S246C5_nt3v74Ev();
extern void _ZN9S246C5_nt3v75Ev();
extern void _ZN9S246C5_nt3v76Ev();
extern void _ZN9S246C5_nt3v77Ev();
extern void _ZN9S246C5_nt3v78Ev();
extern void _ZN9S246C5_nt3v79Ev();
extern void _ZN9S246C5_nt3v80Ev();
extern void _ZN9S246C5_nt3v81Ev();
extern void _ZN9S246C5_nt3v82Ev();
extern void _ZN9S246C5_nt3v83Ev();
extern void _ZN9S246C5_nt3v84Ev();
extern void _ZN9S246C5_nt3v85Ev();
extern void _ZN9S246C5_nt3v86Ev();
extern void _ZN9S246C5_nt3v87Ev();
extern void _ZN9S246C5_nt3v88Ev();
extern void _ZN9S246C5_nt3v89Ev();
extern void _ZN9S246C5_nt3v90Ev();
extern void _ZN9S246C4_nt3v91Ev();
extern void _ZN9S246C4_nt3v92Ev();
extern void _ZN9S246C4_nt3v93Ev();
extern void _ZN9S246C4_nt3v94Ev();
extern void _ZN9S246C4_nt3v95Ev();
extern void _ZN9S246C4_nt3v96Ev();
extern void _ZN9S246C4_nt3v97Ev();
extern void _ZN9S246C4_nt3v98Ev();
extern void _ZN9S246C4_nt3v99Ev();
extern void _ZN9S246C4_nt4v100Ev();
extern void _ZN9S246C4_nt4v101Ev();
extern void _ZN9S246C4_nt4v102Ev();
extern void _ZN9S246C4_nt4v103Ev();
extern void _ZN9S246C4_nt4v104Ev();
extern void _ZN9S246C4_nt4v105Ev();
extern void _ZN9S246C4_nt4v106Ev();
extern void _ZN9S246C4_nt4v107Ev();
extern void _ZN9S246C4_nt4v108Ev();
extern void _ZN9S246C4_nt4v109Ev();
extern void _ZN9S246C4_nt4v110Ev();
extern void _ZN9S246C3_nt4v111Ev();
extern void _ZN9S246C3_nt4v112Ev();
extern void _ZN9S246C3_nt4v113Ev();
extern void _ZN9S246C3_nt4v114Ev();
static  VTBL_ENTRY vtc_S246C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S246C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S246C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S246C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S246C62v5Ev,
  (VTBL_ENTRY)&_ZN6S246C62v6Ev,
  (VTBL_ENTRY)&_ZN6S246C62v7Ev,
  (VTBL_ENTRY)&_ZN6S246C62v8Ev,
  (VTBL_ENTRY)&_ZN6S246C62v9Ev,
  (VTBL_ENTRY)&_ZN6S246C63v10Ev,
  (VTBL_ENTRY)&_ZN6S246C63v11Ev,
  (VTBL_ENTRY)&_ZN6S246C63v12Ev,
  (VTBL_ENTRY)&_ZN6S246C63v13Ev,
  (VTBL_ENTRY)&_ZN6S246C63v14Ev,
  (VTBL_ENTRY)&_ZN6S246C63v15Ev,
  (VTBL_ENTRY)&_ZN6S246C63v16Ev,
  (VTBL_ENTRY)&_ZN6S246C63v17Ev,
  (VTBL_ENTRY)&_ZN6S246C63v18Ev,
  (VTBL_ENTRY)&_ZN6S246C63v19Ev,
  (VTBL_ENTRY)&_ZN6S246C63v20Ev,
  (VTBL_ENTRY)&_ZN6S246C63v21Ev,
  (VTBL_ENTRY)&_ZN6S246C63v22Ev,
  (VTBL_ENTRY)&_ZN6S246C63v23Ev,
  (VTBL_ENTRY)&_ZN6S246C63v24Ev,
  (VTBL_ENTRY)&_ZN6S246C63v25Ev,
  (VTBL_ENTRY)&_ZN6S246C63v26Ev,
  (VTBL_ENTRY)&_ZN6S246C63v27Ev,
  (VTBL_ENTRY)&_ZN6S246C63v28Ev,
  (VTBL_ENTRY)&_ZN6S246C63v29Ev,
  (VTBL_ENTRY)&_ZN6S246C63v30Ev,
  (VTBL_ENTRY)&_ZN6S246C63v31Ev,
  (VTBL_ENTRY)&_ZN6S246C63v32Ev,
  (VTBL_ENTRY)&_ZN6S246C63v33Ev,
  (VTBL_ENTRY)&_ZN6S246C63v34Ev,
  (VTBL_ENTRY)&_ZN6S246C63v35Ev,
  (VTBL_ENTRY)&_ZN6S246C63v36Ev,
  (VTBL_ENTRY)&_ZN6S246C63v37Ev,
  (VTBL_ENTRY)&_ZN6S246C63v38Ev,
  (VTBL_ENTRY)&_ZN6S246C63v39Ev,
  (VTBL_ENTRY)&_ZN6S246C63v40Ev,
  (VTBL_ENTRY)&_ZN6S246C63v41Ev,
  (VTBL_ENTRY)&_ZN6S246C63v42Ev,
  (VTBL_ENTRY)&_ZN6S246C63v43Ev,
  (VTBL_ENTRY)&_ZN6S246C63v44Ev,
  (VTBL_ENTRY)&_ZN6S246C63v45Ev,
  (VTBL_ENTRY)&_ZN6S246C63v46Ev,
  (VTBL_ENTRY)&_ZN6S246C63v47Ev,
  (VTBL_ENTRY)&_ZN6S246C63v48Ev,
  (VTBL_ENTRY)&_ZN6S246C63v49Ev,
  (VTBL_ENTRY)&_ZN6S246C63v50Ev,
  (VTBL_ENTRY)&_ZN6S246C63v51Ev,
  (VTBL_ENTRY)&_ZN6S246C63v52Ev,
  (VTBL_ENTRY)&_ZN6S246C63v53Ev,
  (VTBL_ENTRY)&_ZN6S246C63v54Ev,
  (VTBL_ENTRY)&_ZN6S246C63v55Ev,
  (VTBL_ENTRY)&_ZN6S246C63v56Ev,
  (VTBL_ENTRY)&_ZN6S246C63v57Ev,
  (VTBL_ENTRY)&_ZN6S246C63v58Ev,
  (VTBL_ENTRY)&_ZN6S246C63v59Ev,
  (VTBL_ENTRY)&_ZN6S246C63v60Ev,
  (VTBL_ENTRY)&_ZN6S246C63v61Ev,
  (VTBL_ENTRY)&_ZN6S246C63v62Ev,
  (VTBL_ENTRY)&_ZN6S246C63v63Ev,
  (VTBL_ENTRY)&_ZN6S246C63v64Ev,
  (VTBL_ENTRY)&_ZN6S246C63v65Ev,
  (VTBL_ENTRY)&_ZN6S246C63v66Ev,
  (VTBL_ENTRY)&_ZN6S246C63v67Ev,
  (VTBL_ENTRY)&_ZN6S246C63v68Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v114Ev,
};
extern VTBL_ENTRY _ZTI9S246C3_nt[];
VTBL_ENTRY *P__ZTI9S246C3_nt = _ZTI9S246C3_nt; 
extern  VTBL_ENTRY _ZTV9S246C3_nt[];
Class_Descriptor cd_S246C3_nt = {  "S246C3_nt", // class name
  bases_S246C3_nt, 3,
  &(vtc_S246C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S246C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S246C3_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S246C2_nt  : S246C3_nt {
  int s246c2f0;
  unsigned int s246c2f1:1;
  virtual  ~S246C2_nt(); // _ZN9S246C2_ntD1Ev
  virtual void  v115(); // _ZN9S246C2_nt4v115Ev
  virtual void  v116(); // _ZN9S246C2_nt4v116Ev
  virtual void  v117(); // _ZN9S246C2_nt4v117Ev
  virtual void  v118(); // _ZN9S246C2_nt4v118Ev
  virtual void  v119(); // _ZN9S246C2_nt4v119Ev
  virtual void  v120(); // _ZN9S246C2_nt4v120Ev
  virtual void  v121(); // _ZN9S246C2_nt4v121Ev
  virtual void  v122(); // _ZN9S246C2_nt4v122Ev
  S246C2_nt(); // tgen
};
//SIG(-1 S246C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S246C2_nt ::~S246C2_nt(){ note_dtor("S246C2_nt", this);}
void  S246C2_nt ::v115(){vfunc_called(this, "_ZN9S246C2_nt4v115Ev");}
void  S246C2_nt ::v116(){vfunc_called(this, "_ZN9S246C2_nt4v116Ev");}
void  S246C2_nt ::v117(){vfunc_called(this, "_ZN9S246C2_nt4v117Ev");}
void  S246C2_nt ::v118(){vfunc_called(this, "_ZN9S246C2_nt4v118Ev");}
void  S246C2_nt ::v119(){vfunc_called(this, "_ZN9S246C2_nt4v119Ev");}
void  S246C2_nt ::v120(){vfunc_called(this, "_ZN9S246C2_nt4v120Ev");}
void  S246C2_nt ::v121(){vfunc_called(this, "_ZN9S246C2_nt4v121Ev");}
void  S246C2_nt ::v122(){vfunc_called(this, "_ZN9S246C2_nt4v122Ev");}
S246C2_nt ::S246C2_nt(){ note_ctor("S246C2_nt", this);} // tgen

//skip512 S246C2_nt

#else // __cplusplus

extern void _ZN9S246C2_ntC1Ev();
extern void _ZN9S246C2_ntD1Ev();
Name_Map name_map_S246C2_nt[] = {
  NSPAIR(_ZN9S246C2_ntC1Ev),
  NSPAIR(_ZN9S246C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C6;
extern VTBL_ENTRY _ZTI6S246C6[];
extern  VTBL_ENTRY _ZTV6S246C6[];
extern Class_Descriptor cd_S246C5_nt;
extern VTBL_ENTRY _ZTI9S246C5_nt[];
extern  VTBL_ENTRY _ZTV9S246C5_nt[];
extern Class_Descriptor cd_S246C4_nt;
extern VTBL_ENTRY _ZTI9S246C4_nt[];
extern  VTBL_ENTRY _ZTV9S246C4_nt[];
extern Class_Descriptor cd_S246C3_nt;
extern VTBL_ENTRY _ZTI9S246C3_nt[];
extern  VTBL_ENTRY _ZTV9S246C3_nt[];
static Base_Class bases_S246C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S246C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S246C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S246C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S246C2_nt[];
extern void _ZN9S246C2_ntD1Ev();
extern void _ZN9S246C2_ntD0Ev();
extern void _ZN6S246C62v5Ev();
extern void _ZN6S246C62v6Ev();
extern void _ZN6S246C62v7Ev();
extern void _ZN6S246C62v8Ev();
extern void _ZN6S246C62v9Ev();
extern void _ZN6S246C63v10Ev();
extern void _ZN6S246C63v11Ev();
extern void _ZN6S246C63v12Ev();
extern void _ZN6S246C63v13Ev();
extern void _ZN6S246C63v14Ev();
extern void _ZN6S246C63v15Ev();
extern void _ZN6S246C63v16Ev();
extern void _ZN6S246C63v17Ev();
extern void _ZN6S246C63v18Ev();
extern void _ZN6S246C63v19Ev();
extern void _ZN6S246C63v20Ev();
extern void _ZN6S246C63v21Ev();
extern void _ZN6S246C63v22Ev();
extern void _ZN6S246C63v23Ev();
extern void _ZN6S246C63v24Ev();
extern void _ZN6S246C63v25Ev();
extern void _ZN6S246C63v26Ev();
extern void _ZN6S246C63v27Ev();
extern void _ZN6S246C63v28Ev();
extern void _ZN6S246C63v29Ev();
extern void _ZN6S246C63v30Ev();
extern void _ZN6S246C63v31Ev();
extern void _ZN6S246C63v32Ev();
extern void _ZN6S246C63v33Ev();
extern void _ZN6S246C63v34Ev();
extern void _ZN6S246C63v35Ev();
extern void _ZN6S246C63v36Ev();
extern void _ZN6S246C63v37Ev();
extern void _ZN6S246C63v38Ev();
extern void _ZN6S246C63v39Ev();
extern void _ZN6S246C63v40Ev();
extern void _ZN6S246C63v41Ev();
extern void _ZN6S246C63v42Ev();
extern void _ZN6S246C63v43Ev();
extern void _ZN6S246C63v44Ev();
extern void _ZN6S246C63v45Ev();
extern void _ZN6S246C63v46Ev();
extern void _ZN6S246C63v47Ev();
extern void _ZN6S246C63v48Ev();
extern void _ZN6S246C63v49Ev();
extern void _ZN6S246C63v50Ev();
extern void _ZN6S246C63v51Ev();
extern void _ZN6S246C63v52Ev();
extern void _ZN6S246C63v53Ev();
extern void _ZN6S246C63v54Ev();
extern void _ZN6S246C63v55Ev();
extern void _ZN6S246C63v56Ev();
extern void _ZN6S246C63v57Ev();
extern void _ZN6S246C63v58Ev();
extern void _ZN6S246C63v59Ev();
extern void _ZN6S246C63v60Ev();
extern void _ZN6S246C63v61Ev();
extern void _ZN6S246C63v62Ev();
extern void _ZN6S246C63v63Ev();
extern void _ZN6S246C63v64Ev();
extern void _ZN6S246C63v65Ev();
extern void _ZN6S246C63v66Ev();
extern void _ZN6S246C63v67Ev();
extern void _ZN6S246C63v68Ev();
extern void _ZN9S246C5_nt3v69Ev();
extern void _ZN9S246C5_nt3v70Ev();
extern void _ZN9S246C5_nt3v71Ev();
extern void _ZN9S246C5_nt3v72Ev();
extern void _ZN9S246C5_nt3v73Ev();
extern void _ZN9S246C5_nt3v74Ev();
extern void _ZN9S246C5_nt3v75Ev();
extern void _ZN9S246C5_nt3v76Ev();
extern void _ZN9S246C5_nt3v77Ev();
extern void _ZN9S246C5_nt3v78Ev();
extern void _ZN9S246C5_nt3v79Ev();
extern void _ZN9S246C5_nt3v80Ev();
extern void _ZN9S246C5_nt3v81Ev();
extern void _ZN9S246C5_nt3v82Ev();
extern void _ZN9S246C5_nt3v83Ev();
extern void _ZN9S246C5_nt3v84Ev();
extern void _ZN9S246C5_nt3v85Ev();
extern void _ZN9S246C5_nt3v86Ev();
extern void _ZN9S246C5_nt3v87Ev();
extern void _ZN9S246C5_nt3v88Ev();
extern void _ZN9S246C5_nt3v89Ev();
extern void _ZN9S246C5_nt3v90Ev();
extern void _ZN9S246C4_nt3v91Ev();
extern void _ZN9S246C4_nt3v92Ev();
extern void _ZN9S246C4_nt3v93Ev();
extern void _ZN9S246C4_nt3v94Ev();
extern void _ZN9S246C4_nt3v95Ev();
extern void _ZN9S246C4_nt3v96Ev();
extern void _ZN9S246C4_nt3v97Ev();
extern void _ZN9S246C4_nt3v98Ev();
extern void _ZN9S246C4_nt3v99Ev();
extern void _ZN9S246C4_nt4v100Ev();
extern void _ZN9S246C4_nt4v101Ev();
extern void _ZN9S246C4_nt4v102Ev();
extern void _ZN9S246C4_nt4v103Ev();
extern void _ZN9S246C4_nt4v104Ev();
extern void _ZN9S246C4_nt4v105Ev();
extern void _ZN9S246C4_nt4v106Ev();
extern void _ZN9S246C4_nt4v107Ev();
extern void _ZN9S246C4_nt4v108Ev();
extern void _ZN9S246C4_nt4v109Ev();
extern void _ZN9S246C4_nt4v110Ev();
extern void _ZN9S246C3_nt4v111Ev();
extern void _ZN9S246C3_nt4v112Ev();
extern void _ZN9S246C3_nt4v113Ev();
extern void _ZN9S246C3_nt4v114Ev();
extern void _ZN9S246C2_nt4v115Ev();
extern void _ZN9S246C2_nt4v116Ev();
extern void _ZN9S246C2_nt4v117Ev();
extern void _ZN9S246C2_nt4v118Ev();
extern void _ZN9S246C2_nt4v119Ev();
extern void _ZN9S246C2_nt4v120Ev();
extern void _ZN9S246C2_nt4v121Ev();
extern void _ZN9S246C2_nt4v122Ev();
static  VTBL_ENTRY vtc_S246C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S246C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S246C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S246C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S246C62v5Ev,
  (VTBL_ENTRY)&_ZN6S246C62v6Ev,
  (VTBL_ENTRY)&_ZN6S246C62v7Ev,
  (VTBL_ENTRY)&_ZN6S246C62v8Ev,
  (VTBL_ENTRY)&_ZN6S246C62v9Ev,
  (VTBL_ENTRY)&_ZN6S246C63v10Ev,
  (VTBL_ENTRY)&_ZN6S246C63v11Ev,
  (VTBL_ENTRY)&_ZN6S246C63v12Ev,
  (VTBL_ENTRY)&_ZN6S246C63v13Ev,
  (VTBL_ENTRY)&_ZN6S246C63v14Ev,
  (VTBL_ENTRY)&_ZN6S246C63v15Ev,
  (VTBL_ENTRY)&_ZN6S246C63v16Ev,
  (VTBL_ENTRY)&_ZN6S246C63v17Ev,
  (VTBL_ENTRY)&_ZN6S246C63v18Ev,
  (VTBL_ENTRY)&_ZN6S246C63v19Ev,
  (VTBL_ENTRY)&_ZN6S246C63v20Ev,
  (VTBL_ENTRY)&_ZN6S246C63v21Ev,
  (VTBL_ENTRY)&_ZN6S246C63v22Ev,
  (VTBL_ENTRY)&_ZN6S246C63v23Ev,
  (VTBL_ENTRY)&_ZN6S246C63v24Ev,
  (VTBL_ENTRY)&_ZN6S246C63v25Ev,
  (VTBL_ENTRY)&_ZN6S246C63v26Ev,
  (VTBL_ENTRY)&_ZN6S246C63v27Ev,
  (VTBL_ENTRY)&_ZN6S246C63v28Ev,
  (VTBL_ENTRY)&_ZN6S246C63v29Ev,
  (VTBL_ENTRY)&_ZN6S246C63v30Ev,
  (VTBL_ENTRY)&_ZN6S246C63v31Ev,
  (VTBL_ENTRY)&_ZN6S246C63v32Ev,
  (VTBL_ENTRY)&_ZN6S246C63v33Ev,
  (VTBL_ENTRY)&_ZN6S246C63v34Ev,
  (VTBL_ENTRY)&_ZN6S246C63v35Ev,
  (VTBL_ENTRY)&_ZN6S246C63v36Ev,
  (VTBL_ENTRY)&_ZN6S246C63v37Ev,
  (VTBL_ENTRY)&_ZN6S246C63v38Ev,
  (VTBL_ENTRY)&_ZN6S246C63v39Ev,
  (VTBL_ENTRY)&_ZN6S246C63v40Ev,
  (VTBL_ENTRY)&_ZN6S246C63v41Ev,
  (VTBL_ENTRY)&_ZN6S246C63v42Ev,
  (VTBL_ENTRY)&_ZN6S246C63v43Ev,
  (VTBL_ENTRY)&_ZN6S246C63v44Ev,
  (VTBL_ENTRY)&_ZN6S246C63v45Ev,
  (VTBL_ENTRY)&_ZN6S246C63v46Ev,
  (VTBL_ENTRY)&_ZN6S246C63v47Ev,
  (VTBL_ENTRY)&_ZN6S246C63v48Ev,
  (VTBL_ENTRY)&_ZN6S246C63v49Ev,
  (VTBL_ENTRY)&_ZN6S246C63v50Ev,
  (VTBL_ENTRY)&_ZN6S246C63v51Ev,
  (VTBL_ENTRY)&_ZN6S246C63v52Ev,
  (VTBL_ENTRY)&_ZN6S246C63v53Ev,
  (VTBL_ENTRY)&_ZN6S246C63v54Ev,
  (VTBL_ENTRY)&_ZN6S246C63v55Ev,
  (VTBL_ENTRY)&_ZN6S246C63v56Ev,
  (VTBL_ENTRY)&_ZN6S246C63v57Ev,
  (VTBL_ENTRY)&_ZN6S246C63v58Ev,
  (VTBL_ENTRY)&_ZN6S246C63v59Ev,
  (VTBL_ENTRY)&_ZN6S246C63v60Ev,
  (VTBL_ENTRY)&_ZN6S246C63v61Ev,
  (VTBL_ENTRY)&_ZN6S246C63v62Ev,
  (VTBL_ENTRY)&_ZN6S246C63v63Ev,
  (VTBL_ENTRY)&_ZN6S246C63v64Ev,
  (VTBL_ENTRY)&_ZN6S246C63v65Ev,
  (VTBL_ENTRY)&_ZN6S246C63v66Ev,
  (VTBL_ENTRY)&_ZN6S246C63v67Ev,
  (VTBL_ENTRY)&_ZN6S246C63v68Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v122Ev,
};
extern VTBL_ENTRY _ZTI9S246C2_nt[];
VTBL_ENTRY *P__ZTI9S246C2_nt = _ZTI9S246C2_nt; 
extern  VTBL_ENTRY _ZTV9S246C2_nt[];
Class_Descriptor cd_S246C2_nt = {  "S246C2_nt", // class name
  bases_S246C2_nt, 4,
  &(vtc_S246C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI9S246C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S246C2_nt),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S246C1  : S246C2_nt {
  unsigned int s246c1f0:1;
  unsigned int s246c1f1:1;
  virtual  ~S246C1(); // _ZN6S246C1D1Ev
  virtual void  v1(); // _ZN6S246C12v1Ev
  virtual void  v2(); // _ZN6S246C12v2Ev
  virtual void  v3(); // _ZN6S246C12v3Ev
  virtual void  v4(); // _ZN6S246C12v4Ev
  S246C1(); // tgen
};
//SIG(1 S246C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v111 v112 v113 v114 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v115 v116 v117 v118 v119 v120 v121 v122 Fi Fi:1} vd v1 v2 v3 v4 Fi:1 Fi:1}


 S246C1 ::~S246C1(){ note_dtor("S246C1", this);}
void  S246C1 ::v1(){vfunc_called(this, "_ZN6S246C12v1Ev");}
void  S246C1 ::v2(){vfunc_called(this, "_ZN6S246C12v2Ev");}
void  S246C1 ::v3(){vfunc_called(this, "_ZN6S246C12v3Ev");}
void  S246C1 ::v4(){vfunc_called(this, "_ZN6S246C12v4Ev");}
S246C1 ::S246C1(){ note_ctor("S246C1", this);} // tgen

static void Test_S246C1()
{
  extern Class_Descriptor cd_S246C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,58)];
    init_test(&cd_S246C1, buf);
    S246C1 *dp, &lv = *(dp=new (buf) S246C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,228), "sizeof(S246C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S246C1)");
    check_base_class_offset(lv, (S246C6*)(S246C5_nt*)(S246C4_nt*)(S246C3_nt*)(S246C2_nt*), 0, "S246C1");
    check_base_class_offset(lv, (S246C5_nt*)(S246C4_nt*)(S246C3_nt*)(S246C2_nt*), 0, "S246C1");
    check_base_class_offset(lv, (S246C4_nt*)(S246C3_nt*)(S246C2_nt*), 0, "S246C1");
    check_base_class_offset(lv, (S246C3_nt*)(S246C2_nt*), 0, "S246C1");
    check_base_class_offset(lv, (S246C2_nt*), 0, "S246C1");
    set_bf_and_test(lv, s246c1f0, ABISELECT(301,225), 0, 1, 1, "S246C1");
    set_bf_and_test(lv, s246c1f1, ABISELECT(301,225), 1, 1, 1, "S246C1");
    test_class_info(&lv, &cd_S246C1);
    dp->~S246C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS246C1(Test_S246C1, "S246C1", ABISELECT(304,228));

#else // __cplusplus

extern void _ZN6S246C1C1Ev();
extern void _ZN6S246C1D1Ev();
Name_Map name_map_S246C1[] = {
  NSPAIR(_ZN6S246C1C1Ev),
  NSPAIR(_ZN6S246C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C6;
extern VTBL_ENTRY _ZTI6S246C6[];
extern  VTBL_ENTRY _ZTV6S246C6[];
extern Class_Descriptor cd_S246C5_nt;
extern VTBL_ENTRY _ZTI9S246C5_nt[];
extern  VTBL_ENTRY _ZTV9S246C5_nt[];
extern Class_Descriptor cd_S246C4_nt;
extern VTBL_ENTRY _ZTI9S246C4_nt[];
extern  VTBL_ENTRY _ZTV9S246C4_nt[];
extern Class_Descriptor cd_S246C3_nt;
extern VTBL_ENTRY _ZTI9S246C3_nt[];
extern  VTBL_ENTRY _ZTV9S246C3_nt[];
extern Class_Descriptor cd_S246C2_nt;
extern VTBL_ENTRY _ZTI9S246C2_nt[];
extern  VTBL_ENTRY _ZTV9S246C2_nt[];
static Base_Class bases_S246C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S246C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S246C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S246C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S246C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S246C1[];
extern void _ZN6S246C1D1Ev();
extern void _ZN6S246C1D0Ev();
extern void _ZN6S246C62v5Ev();
extern void _ZN6S246C62v6Ev();
extern void _ZN6S246C62v7Ev();
extern void _ZN6S246C62v8Ev();
extern void _ZN6S246C62v9Ev();
extern void _ZN6S246C63v10Ev();
extern void _ZN6S246C63v11Ev();
extern void _ZN6S246C63v12Ev();
extern void _ZN6S246C63v13Ev();
extern void _ZN6S246C63v14Ev();
extern void _ZN6S246C63v15Ev();
extern void _ZN6S246C63v16Ev();
extern void _ZN6S246C63v17Ev();
extern void _ZN6S246C63v18Ev();
extern void _ZN6S246C63v19Ev();
extern void _ZN6S246C63v20Ev();
extern void _ZN6S246C63v21Ev();
extern void _ZN6S246C63v22Ev();
extern void _ZN6S246C63v23Ev();
extern void _ZN6S246C63v24Ev();
extern void _ZN6S246C63v25Ev();
extern void _ZN6S246C63v26Ev();
extern void _ZN6S246C63v27Ev();
extern void _ZN6S246C63v28Ev();
extern void _ZN6S246C63v29Ev();
extern void _ZN6S246C63v30Ev();
extern void _ZN6S246C63v31Ev();
extern void _ZN6S246C63v32Ev();
extern void _ZN6S246C63v33Ev();
extern void _ZN6S246C63v34Ev();
extern void _ZN6S246C63v35Ev();
extern void _ZN6S246C63v36Ev();
extern void _ZN6S246C63v37Ev();
extern void _ZN6S246C63v38Ev();
extern void _ZN6S246C63v39Ev();
extern void _ZN6S246C63v40Ev();
extern void _ZN6S246C63v41Ev();
extern void _ZN6S246C63v42Ev();
extern void _ZN6S246C63v43Ev();
extern void _ZN6S246C63v44Ev();
extern void _ZN6S246C63v45Ev();
extern void _ZN6S246C63v46Ev();
extern void _ZN6S246C63v47Ev();
extern void _ZN6S246C63v48Ev();
extern void _ZN6S246C63v49Ev();
extern void _ZN6S246C63v50Ev();
extern void _ZN6S246C63v51Ev();
extern void _ZN6S246C63v52Ev();
extern void _ZN6S246C63v53Ev();
extern void _ZN6S246C63v54Ev();
extern void _ZN6S246C63v55Ev();
extern void _ZN6S246C63v56Ev();
extern void _ZN6S246C63v57Ev();
extern void _ZN6S246C63v58Ev();
extern void _ZN6S246C63v59Ev();
extern void _ZN6S246C63v60Ev();
extern void _ZN6S246C63v61Ev();
extern void _ZN6S246C63v62Ev();
extern void _ZN6S246C63v63Ev();
extern void _ZN6S246C63v64Ev();
extern void _ZN6S246C63v65Ev();
extern void _ZN6S246C63v66Ev();
extern void _ZN6S246C63v67Ev();
extern void _ZN6S246C63v68Ev();
extern void _ZN9S246C5_nt3v69Ev();
extern void _ZN9S246C5_nt3v70Ev();
extern void _ZN9S246C5_nt3v71Ev();
extern void _ZN9S246C5_nt3v72Ev();
extern void _ZN9S246C5_nt3v73Ev();
extern void _ZN9S246C5_nt3v74Ev();
extern void _ZN9S246C5_nt3v75Ev();
extern void _ZN9S246C5_nt3v76Ev();
extern void _ZN9S246C5_nt3v77Ev();
extern void _ZN9S246C5_nt3v78Ev();
extern void _ZN9S246C5_nt3v79Ev();
extern void _ZN9S246C5_nt3v80Ev();
extern void _ZN9S246C5_nt3v81Ev();
extern void _ZN9S246C5_nt3v82Ev();
extern void _ZN9S246C5_nt3v83Ev();
extern void _ZN9S246C5_nt3v84Ev();
extern void _ZN9S246C5_nt3v85Ev();
extern void _ZN9S246C5_nt3v86Ev();
extern void _ZN9S246C5_nt3v87Ev();
extern void _ZN9S246C5_nt3v88Ev();
extern void _ZN9S246C5_nt3v89Ev();
extern void _ZN9S246C5_nt3v90Ev();
extern void _ZN9S246C4_nt3v91Ev();
extern void _ZN9S246C4_nt3v92Ev();
extern void _ZN9S246C4_nt3v93Ev();
extern void _ZN9S246C4_nt3v94Ev();
extern void _ZN9S246C4_nt3v95Ev();
extern void _ZN9S246C4_nt3v96Ev();
extern void _ZN9S246C4_nt3v97Ev();
extern void _ZN9S246C4_nt3v98Ev();
extern void _ZN9S246C4_nt3v99Ev();
extern void _ZN9S246C4_nt4v100Ev();
extern void _ZN9S246C4_nt4v101Ev();
extern void _ZN9S246C4_nt4v102Ev();
extern void _ZN9S246C4_nt4v103Ev();
extern void _ZN9S246C4_nt4v104Ev();
extern void _ZN9S246C4_nt4v105Ev();
extern void _ZN9S246C4_nt4v106Ev();
extern void _ZN9S246C4_nt4v107Ev();
extern void _ZN9S246C4_nt4v108Ev();
extern void _ZN9S246C4_nt4v109Ev();
extern void _ZN9S246C4_nt4v110Ev();
extern void _ZN9S246C3_nt4v111Ev();
extern void _ZN9S246C3_nt4v112Ev();
extern void _ZN9S246C3_nt4v113Ev();
extern void _ZN9S246C3_nt4v114Ev();
extern void _ZN9S246C2_nt4v115Ev();
extern void _ZN9S246C2_nt4v116Ev();
extern void _ZN9S246C2_nt4v117Ev();
extern void _ZN9S246C2_nt4v118Ev();
extern void _ZN9S246C2_nt4v119Ev();
extern void _ZN9S246C2_nt4v120Ev();
extern void _ZN9S246C2_nt4v121Ev();
extern void _ZN9S246C2_nt4v122Ev();
extern void _ZN6S246C12v1Ev();
extern void _ZN6S246C12v2Ev();
extern void _ZN6S246C12v3Ev();
extern void _ZN6S246C12v4Ev();
static  VTBL_ENTRY vtc_S246C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S246C1[0]),
  (VTBL_ENTRY)&_ZN6S246C1D1Ev,
  (VTBL_ENTRY)&_ZN6S246C1D0Ev,
  (VTBL_ENTRY)&_ZN6S246C62v5Ev,
  (VTBL_ENTRY)&_ZN6S246C62v6Ev,
  (VTBL_ENTRY)&_ZN6S246C62v7Ev,
  (VTBL_ENTRY)&_ZN6S246C62v8Ev,
  (VTBL_ENTRY)&_ZN6S246C62v9Ev,
  (VTBL_ENTRY)&_ZN6S246C63v10Ev,
  (VTBL_ENTRY)&_ZN6S246C63v11Ev,
  (VTBL_ENTRY)&_ZN6S246C63v12Ev,
  (VTBL_ENTRY)&_ZN6S246C63v13Ev,
  (VTBL_ENTRY)&_ZN6S246C63v14Ev,
  (VTBL_ENTRY)&_ZN6S246C63v15Ev,
  (VTBL_ENTRY)&_ZN6S246C63v16Ev,
  (VTBL_ENTRY)&_ZN6S246C63v17Ev,
  (VTBL_ENTRY)&_ZN6S246C63v18Ev,
  (VTBL_ENTRY)&_ZN6S246C63v19Ev,
  (VTBL_ENTRY)&_ZN6S246C63v20Ev,
  (VTBL_ENTRY)&_ZN6S246C63v21Ev,
  (VTBL_ENTRY)&_ZN6S246C63v22Ev,
  (VTBL_ENTRY)&_ZN6S246C63v23Ev,
  (VTBL_ENTRY)&_ZN6S246C63v24Ev,
  (VTBL_ENTRY)&_ZN6S246C63v25Ev,
  (VTBL_ENTRY)&_ZN6S246C63v26Ev,
  (VTBL_ENTRY)&_ZN6S246C63v27Ev,
  (VTBL_ENTRY)&_ZN6S246C63v28Ev,
  (VTBL_ENTRY)&_ZN6S246C63v29Ev,
  (VTBL_ENTRY)&_ZN6S246C63v30Ev,
  (VTBL_ENTRY)&_ZN6S246C63v31Ev,
  (VTBL_ENTRY)&_ZN6S246C63v32Ev,
  (VTBL_ENTRY)&_ZN6S246C63v33Ev,
  (VTBL_ENTRY)&_ZN6S246C63v34Ev,
  (VTBL_ENTRY)&_ZN6S246C63v35Ev,
  (VTBL_ENTRY)&_ZN6S246C63v36Ev,
  (VTBL_ENTRY)&_ZN6S246C63v37Ev,
  (VTBL_ENTRY)&_ZN6S246C63v38Ev,
  (VTBL_ENTRY)&_ZN6S246C63v39Ev,
  (VTBL_ENTRY)&_ZN6S246C63v40Ev,
  (VTBL_ENTRY)&_ZN6S246C63v41Ev,
  (VTBL_ENTRY)&_ZN6S246C63v42Ev,
  (VTBL_ENTRY)&_ZN6S246C63v43Ev,
  (VTBL_ENTRY)&_ZN6S246C63v44Ev,
  (VTBL_ENTRY)&_ZN6S246C63v45Ev,
  (VTBL_ENTRY)&_ZN6S246C63v46Ev,
  (VTBL_ENTRY)&_ZN6S246C63v47Ev,
  (VTBL_ENTRY)&_ZN6S246C63v48Ev,
  (VTBL_ENTRY)&_ZN6S246C63v49Ev,
  (VTBL_ENTRY)&_ZN6S246C63v50Ev,
  (VTBL_ENTRY)&_ZN6S246C63v51Ev,
  (VTBL_ENTRY)&_ZN6S246C63v52Ev,
  (VTBL_ENTRY)&_ZN6S246C63v53Ev,
  (VTBL_ENTRY)&_ZN6S246C63v54Ev,
  (VTBL_ENTRY)&_ZN6S246C63v55Ev,
  (VTBL_ENTRY)&_ZN6S246C63v56Ev,
  (VTBL_ENTRY)&_ZN6S246C63v57Ev,
  (VTBL_ENTRY)&_ZN6S246C63v58Ev,
  (VTBL_ENTRY)&_ZN6S246C63v59Ev,
  (VTBL_ENTRY)&_ZN6S246C63v60Ev,
  (VTBL_ENTRY)&_ZN6S246C63v61Ev,
  (VTBL_ENTRY)&_ZN6S246C63v62Ev,
  (VTBL_ENTRY)&_ZN6S246C63v63Ev,
  (VTBL_ENTRY)&_ZN6S246C63v64Ev,
  (VTBL_ENTRY)&_ZN6S246C63v65Ev,
  (VTBL_ENTRY)&_ZN6S246C63v66Ev,
  (VTBL_ENTRY)&_ZN6S246C63v67Ev,
  (VTBL_ENTRY)&_ZN6S246C63v68Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S246C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S246C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S246C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S246C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN6S246C12v1Ev,
  (VTBL_ENTRY)&_ZN6S246C12v2Ev,
  (VTBL_ENTRY)&_ZN6S246C12v3Ev,
  (VTBL_ENTRY)&_ZN6S246C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S246C1[];
extern  VTBL_ENTRY _ZTV6S246C1[];
Class_Descriptor cd_S246C1 = {  "S246C1", // class name
  bases_S246C1, 5,
  &(vtc_S246C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI6S246C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S246C1),126, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S585C5  {
  int s585c5f0;
  __tsi64 s585c5f1;
  void *s585c5f2[4];
  int s585c5f3[2];
  void *s585c5f4;
  ::S27C9_nt s585c5f5;
  void *s585c5f6[2];
  virtual  ~S585C5(); // _ZN6S585C5D1Ev
  virtual void  v4(); // _ZN6S585C52v4Ev
  virtual void  v5(); // _ZN6S585C52v5Ev
  virtual void  v6(); // _ZN6S585C52v6Ev
  virtual void  v7(); // _ZN6S585C52v7Ev
  virtual void  v8(); // _ZN6S585C52v8Ev
  virtual void  v9(); // _ZN6S585C52v9Ev
  virtual void  v10(); // _ZN6S585C53v10Ev
  virtual void  v11(); // _ZN6S585C53v11Ev
  virtual void  v12(); // _ZN6S585C53v12Ev
  virtual void  v13(); // _ZN6S585C53v13Ev
  virtual void  v14(); // _ZN6S585C53v14Ev
  virtual void  v15(); // _ZN6S585C53v15Ev
  virtual void  v16(); // _ZN6S585C53v16Ev
  virtual void  v17(); // _ZN6S585C53v17Ev
  virtual void  v18(); // _ZN6S585C53v18Ev
  virtual void  v19(); // _ZN6S585C53v19Ev
  virtual void  v20(); // _ZN6S585C53v20Ev
  virtual void  v21(); // _ZN6S585C53v21Ev
  virtual void  v22(); // _ZN6S585C53v22Ev
  virtual void  v23(); // _ZN6S585C53v23Ev
  virtual void  v24(); // _ZN6S585C53v24Ev
  virtual void  v25(); // _ZN6S585C53v25Ev
  virtual void  v26(); // _ZN6S585C53v26Ev
  virtual void  v27(); // _ZN6S585C53v27Ev
  virtual void  v28(); // _ZN6S585C53v28Ev
  virtual void  v29(); // _ZN6S585C53v29Ev
  virtual void  v30(); // _ZN6S585C53v30Ev
  virtual void  v31(); // _ZN6S585C53v31Ev
  virtual void  v32(); // _ZN6S585C53v32Ev
  virtual void  v33(); // _ZN6S585C53v33Ev
  virtual void  v34(); // _ZN6S585C53v34Ev
  virtual void  v35(); // _ZN6S585C53v35Ev
  virtual void  v36(); // _ZN6S585C53v36Ev
  virtual void  v37(); // _ZN6S585C53v37Ev
  virtual void  v38(); // _ZN6S585C53v38Ev
  virtual void  v39(); // _ZN6S585C53v39Ev
  virtual void  v40(); // _ZN6S585C53v40Ev
  virtual void  v41(); // _ZN6S585C53v41Ev
  virtual void  v42(); // _ZN6S585C53v42Ev
  virtual void  v43(); // _ZN6S585C53v43Ev
  virtual void  v44(); // _ZN6S585C53v44Ev
  virtual void  v45(); // _ZN6S585C53v45Ev
  virtual void  v46(); // _ZN6S585C53v46Ev
  virtual void  v47(); // _ZN6S585C53v47Ev
  virtual void  v48(); // _ZN6S585C53v48Ev
  virtual void  v49(); // _ZN6S585C53v49Ev
  virtual void  v50(); // _ZN6S585C53v50Ev
  virtual void  v51(); // _ZN6S585C53v51Ev
  virtual void  v52(); // _ZN6S585C53v52Ev
  virtual void  v53(); // _ZN6S585C53v53Ev
  virtual void  v54(); // _ZN6S585C53v54Ev
  virtual void  v55(); // _ZN6S585C53v55Ev
  virtual void  v56(); // _ZN6S585C53v56Ev
  virtual void  v57(); // _ZN6S585C53v57Ev
  virtual void  v58(); // _ZN6S585C53v58Ev
  virtual void  v59(); // _ZN6S585C53v59Ev
  virtual void  v60(); // _ZN6S585C53v60Ev
  virtual void  v61(); // _ZN6S585C53v61Ev
  virtual void  v62(); // _ZN6S585C53v62Ev
  virtual void  v63(); // _ZN6S585C53v63Ev
  virtual void  v64(); // _ZN6S585C53v64Ev
  virtual void  v65(); // _ZN6S585C53v65Ev
  virtual void  v66(); // _ZN6S585C53v66Ev
  virtual void  v67(); // _ZN6S585C53v67Ev
  S585C5(); // tgen
};
//SIG(-1 S585C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S585C5 ::~S585C5(){ note_dtor("S585C5", this);}
void  S585C5 ::v4(){vfunc_called(this, "_ZN6S585C52v4Ev");}
void  S585C5 ::v5(){vfunc_called(this, "_ZN6S585C52v5Ev");}
void  S585C5 ::v6(){vfunc_called(this, "_ZN6S585C52v6Ev");}
void  S585C5 ::v7(){vfunc_called(this, "_ZN6S585C52v7Ev");}
void  S585C5 ::v8(){vfunc_called(this, "_ZN6S585C52v8Ev");}
void  S585C5 ::v9(){vfunc_called(this, "_ZN6S585C52v9Ev");}
void  S585C5 ::v10(){vfunc_called(this, "_ZN6S585C53v10Ev");}
void  S585C5 ::v11(){vfunc_called(this, "_ZN6S585C53v11Ev");}
void  S585C5 ::v12(){vfunc_called(this, "_ZN6S585C53v12Ev");}
void  S585C5 ::v13(){vfunc_called(this, "_ZN6S585C53v13Ev");}
void  S585C5 ::v14(){vfunc_called(this, "_ZN6S585C53v14Ev");}
void  S585C5 ::v15(){vfunc_called(this, "_ZN6S585C53v15Ev");}
void  S585C5 ::v16(){vfunc_called(this, "_ZN6S585C53v16Ev");}
void  S585C5 ::v17(){vfunc_called(this, "_ZN6S585C53v17Ev");}
void  S585C5 ::v18(){vfunc_called(this, "_ZN6S585C53v18Ev");}
void  S585C5 ::v19(){vfunc_called(this, "_ZN6S585C53v19Ev");}
void  S585C5 ::v20(){vfunc_called(this, "_ZN6S585C53v20Ev");}
void  S585C5 ::v21(){vfunc_called(this, "_ZN6S585C53v21Ev");}
void  S585C5 ::v22(){vfunc_called(this, "_ZN6S585C53v22Ev");}
void  S585C5 ::v23(){vfunc_called(this, "_ZN6S585C53v23Ev");}
void  S585C5 ::v24(){vfunc_called(this, "_ZN6S585C53v24Ev");}
void  S585C5 ::v25(){vfunc_called(this, "_ZN6S585C53v25Ev");}
void  S585C5 ::v26(){vfunc_called(this, "_ZN6S585C53v26Ev");}
void  S585C5 ::v27(){vfunc_called(this, "_ZN6S585C53v27Ev");}
void  S585C5 ::v28(){vfunc_called(this, "_ZN6S585C53v28Ev");}
void  S585C5 ::v29(){vfunc_called(this, "_ZN6S585C53v29Ev");}
void  S585C5 ::v30(){vfunc_called(this, "_ZN6S585C53v30Ev");}
void  S585C5 ::v31(){vfunc_called(this, "_ZN6S585C53v31Ev");}
void  S585C5 ::v32(){vfunc_called(this, "_ZN6S585C53v32Ev");}
void  S585C5 ::v33(){vfunc_called(this, "_ZN6S585C53v33Ev");}
void  S585C5 ::v34(){vfunc_called(this, "_ZN6S585C53v34Ev");}
void  S585C5 ::v35(){vfunc_called(this, "_ZN6S585C53v35Ev");}
void  S585C5 ::v36(){vfunc_called(this, "_ZN6S585C53v36Ev");}
void  S585C5 ::v37(){vfunc_called(this, "_ZN6S585C53v37Ev");}
void  S585C5 ::v38(){vfunc_called(this, "_ZN6S585C53v38Ev");}
void  S585C5 ::v39(){vfunc_called(this, "_ZN6S585C53v39Ev");}
void  S585C5 ::v40(){vfunc_called(this, "_ZN6S585C53v40Ev");}
void  S585C5 ::v41(){vfunc_called(this, "_ZN6S585C53v41Ev");}
void  S585C5 ::v42(){vfunc_called(this, "_ZN6S585C53v42Ev");}
void  S585C5 ::v43(){vfunc_called(this, "_ZN6S585C53v43Ev");}
void  S585C5 ::v44(){vfunc_called(this, "_ZN6S585C53v44Ev");}
void  S585C5 ::v45(){vfunc_called(this, "_ZN6S585C53v45Ev");}
void  S585C5 ::v46(){vfunc_called(this, "_ZN6S585C53v46Ev");}
void  S585C5 ::v47(){vfunc_called(this, "_ZN6S585C53v47Ev");}
void  S585C5 ::v48(){vfunc_called(this, "_ZN6S585C53v48Ev");}
void  S585C5 ::v49(){vfunc_called(this, "_ZN6S585C53v49Ev");}
void  S585C5 ::v50(){vfunc_called(this, "_ZN6S585C53v50Ev");}
void  S585C5 ::v51(){vfunc_called(this, "_ZN6S585C53v51Ev");}
void  S585C5 ::v52(){vfunc_called(this, "_ZN6S585C53v52Ev");}
void  S585C5 ::v53(){vfunc_called(this, "_ZN6S585C53v53Ev");}
void  S585C5 ::v54(){vfunc_called(this, "_ZN6S585C53v54Ev");}
void  S585C5 ::v55(){vfunc_called(this, "_ZN6S585C53v55Ev");}
void  S585C5 ::v56(){vfunc_called(this, "_ZN6S585C53v56Ev");}
void  S585C5 ::v57(){vfunc_called(this, "_ZN6S585C53v57Ev");}
void  S585C5 ::v58(){vfunc_called(this, "_ZN6S585C53v58Ev");}
void  S585C5 ::v59(){vfunc_called(this, "_ZN6S585C53v59Ev");}
void  S585C5 ::v60(){vfunc_called(this, "_ZN6S585C53v60Ev");}
void  S585C5 ::v61(){vfunc_called(this, "_ZN6S585C53v61Ev");}
void  S585C5 ::v62(){vfunc_called(this, "_ZN6S585C53v62Ev");}
void  S585C5 ::v63(){vfunc_called(this, "_ZN6S585C53v63Ev");}
void  S585C5 ::v64(){vfunc_called(this, "_ZN6S585C53v64Ev");}
void  S585C5 ::v65(){vfunc_called(this, "_ZN6S585C53v65Ev");}
void  S585C5 ::v66(){vfunc_called(this, "_ZN6S585C53v66Ev");}
void  S585C5 ::v67(){vfunc_called(this, "_ZN6S585C53v67Ev");}
S585C5 ::S585C5(){ note_ctor("S585C5", this);} // tgen

static void Test_S585C5()
{
  extern Class_Descriptor cd_S585C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S585C5, buf);
    S585C5 *dp, &lv = *(dp=new (buf) S585C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S585C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S585C5)");
    check_field_offset(lv, s585c5f0, ABISELECT(8,4), "S585C5.s585c5f0");
    check_field_offset(lv, s585c5f1, ABISELECT(16,8), "S585C5.s585c5f1");
    check_field_offset(lv, s585c5f2, ABISELECT(24,16), "S585C5.s585c5f2");
    check_field_offset(lv, s585c5f3, ABISELECT(56,32), "S585C5.s585c5f3");
    check_field_offset(lv, s585c5f4, ABISELECT(64,40), "S585C5.s585c5f4");
    check_field_offset(lv, s585c5f5, ABISELECT(72,44), "S585C5.s585c5f5");
    check_field_offset(lv, s585c5f6, ABISELECT(80,52), "S585C5.s585c5f6");
    test_class_info(&lv, &cd_S585C5);
    dp->~S585C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS585C5(Test_S585C5, "S585C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S585C5C1Ev();
extern void _ZN6S585C5D1Ev();
Name_Map name_map_S585C5[] = {
  NSPAIR(_ZN6S585C5C1Ev),
  NSPAIR(_ZN6S585C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S585C5[];
extern void _ZN6S585C5D1Ev();
extern void _ZN6S585C5D0Ev();
extern void _ZN6S585C52v4Ev();
extern void _ZN6S585C52v5Ev();
extern void _ZN6S585C52v6Ev();
extern void _ZN6S585C52v7Ev();
extern void _ZN6S585C52v8Ev();
extern void _ZN6S585C52v9Ev();
extern void _ZN6S585C53v10Ev();
extern void _ZN6S585C53v11Ev();
extern void _ZN6S585C53v12Ev();
extern void _ZN6S585C53v13Ev();
extern void _ZN6S585C53v14Ev();
extern void _ZN6S585C53v15Ev();
extern void _ZN6S585C53v16Ev();
extern void _ZN6S585C53v17Ev();
extern void _ZN6S585C53v18Ev();
extern void _ZN6S585C53v19Ev();
extern void _ZN6S585C53v20Ev();
extern void _ZN6S585C53v21Ev();
extern void _ZN6S585C53v22Ev();
extern void _ZN6S585C53v23Ev();
extern void _ZN6S585C53v24Ev();
extern void _ZN6S585C53v25Ev();
extern void _ZN6S585C53v26Ev();
extern void _ZN6S585C53v27Ev();
extern void _ZN6S585C53v28Ev();
extern void _ZN6S585C53v29Ev();
extern void _ZN6S585C53v30Ev();
extern void _ZN6S585C53v31Ev();
extern void _ZN6S585C53v32Ev();
extern void _ZN6S585C53v33Ev();
extern void _ZN6S585C53v34Ev();
extern void _ZN6S585C53v35Ev();
extern void _ZN6S585C53v36Ev();
extern void _ZN6S585C53v37Ev();
extern void _ZN6S585C53v38Ev();
extern void _ZN6S585C53v39Ev();
extern void _ZN6S585C53v40Ev();
extern void _ZN6S585C53v41Ev();
extern void _ZN6S585C53v42Ev();
extern void _ZN6S585C53v43Ev();
extern void _ZN6S585C53v44Ev();
extern void _ZN6S585C53v45Ev();
extern void _ZN6S585C53v46Ev();
extern void _ZN6S585C53v47Ev();
extern void _ZN6S585C53v48Ev();
extern void _ZN6S585C53v49Ev();
extern void _ZN6S585C53v50Ev();
extern void _ZN6S585C53v51Ev();
extern void _ZN6S585C53v52Ev();
extern void _ZN6S585C53v53Ev();
extern void _ZN6S585C53v54Ev();
extern void _ZN6S585C53v55Ev();
extern void _ZN6S585C53v56Ev();
extern void _ZN6S585C53v57Ev();
extern void _ZN6S585C53v58Ev();
extern void _ZN6S585C53v59Ev();
extern void _ZN6S585C53v60Ev();
extern void _ZN6S585C53v61Ev();
extern void _ZN6S585C53v62Ev();
extern void _ZN6S585C53v63Ev();
extern void _ZN6S585C53v64Ev();
extern void _ZN6S585C53v65Ev();
extern void _ZN6S585C53v66Ev();
extern void _ZN6S585C53v67Ev();
static  VTBL_ENTRY vtc_S585C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S585C5[0]),
  (VTBL_ENTRY)&_ZN6S585C5D1Ev,
  (VTBL_ENTRY)&_ZN6S585C5D0Ev,
  (VTBL_ENTRY)&_ZN6S585C52v4Ev,
  (VTBL_ENTRY)&_ZN6S585C52v5Ev,
  (VTBL_ENTRY)&_ZN6S585C52v6Ev,
  (VTBL_ENTRY)&_ZN6S585C52v7Ev,
  (VTBL_ENTRY)&_ZN6S585C52v8Ev,
  (VTBL_ENTRY)&_ZN6S585C52v9Ev,
  (VTBL_ENTRY)&_ZN6S585C53v10Ev,
  (VTBL_ENTRY)&_ZN6S585C53v11Ev,
  (VTBL_ENTRY)&_ZN6S585C53v12Ev,
  (VTBL_ENTRY)&_ZN6S585C53v13Ev,
  (VTBL_ENTRY)&_ZN6S585C53v14Ev,
  (VTBL_ENTRY)&_ZN6S585C53v15Ev,
  (VTBL_ENTRY)&_ZN6S585C53v16Ev,
  (VTBL_ENTRY)&_ZN6S585C53v17Ev,
  (VTBL_ENTRY)&_ZN6S585C53v18Ev,
  (VTBL_ENTRY)&_ZN6S585C53v19Ev,
  (VTBL_ENTRY)&_ZN6S585C53v20Ev,
  (VTBL_ENTRY)&_ZN6S585C53v21Ev,
  (VTBL_ENTRY)&_ZN6S585C53v22Ev,
  (VTBL_ENTRY)&_ZN6S585C53v23Ev,
  (VTBL_ENTRY)&_ZN6S585C53v24Ev,
  (VTBL_ENTRY)&_ZN6S585C53v25Ev,
  (VTBL_ENTRY)&_ZN6S585C53v26Ev,
  (VTBL_ENTRY)&_ZN6S585C53v27Ev,
  (VTBL_ENTRY)&_ZN6S585C53v28Ev,
  (VTBL_ENTRY)&_ZN6S585C53v29Ev,
  (VTBL_ENTRY)&_ZN6S585C53v30Ev,
  (VTBL_ENTRY)&_ZN6S585C53v31Ev,
  (VTBL_ENTRY)&_ZN6S585C53v32Ev,
  (VTBL_ENTRY)&_ZN6S585C53v33Ev,
  (VTBL_ENTRY)&_ZN6S585C53v34Ev,
  (VTBL_ENTRY)&_ZN6S585C53v35Ev,
  (VTBL_ENTRY)&_ZN6S585C53v36Ev,
  (VTBL_ENTRY)&_ZN6S585C53v37Ev,
  (VTBL_ENTRY)&_ZN6S585C53v38Ev,
  (VTBL_ENTRY)&_ZN6S585C53v39Ev,
  (VTBL_ENTRY)&_ZN6S585C53v40Ev,
  (VTBL_ENTRY)&_ZN6S585C53v41Ev,
  (VTBL_ENTRY)&_ZN6S585C53v42Ev,
  (VTBL_ENTRY)&_ZN6S585C53v43Ev,
  (VTBL_ENTRY)&_ZN6S585C53v44Ev,
  (VTBL_ENTRY)&_ZN6S585C53v45Ev,
  (VTBL_ENTRY)&_ZN6S585C53v46Ev,
  (VTBL_ENTRY)&_ZN6S585C53v47Ev,
  (VTBL_ENTRY)&_ZN6S585C53v48Ev,
  (VTBL_ENTRY)&_ZN6S585C53v49Ev,
  (VTBL_ENTRY)&_ZN6S585C53v50Ev,
  (VTBL_ENTRY)&_ZN6S585C53v51Ev,
  (VTBL_ENTRY)&_ZN6S585C53v52Ev,
  (VTBL_ENTRY)&_ZN6S585C53v53Ev,
  (VTBL_ENTRY)&_ZN6S585C53v54Ev,
  (VTBL_ENTRY)&_ZN6S585C53v55Ev,
  (VTBL_ENTRY)&_ZN6S585C53v56Ev,
  (VTBL_ENTRY)&_ZN6S585C53v57Ev,
  (VTBL_ENTRY)&_ZN6S585C53v58Ev,
  (VTBL_ENTRY)&_ZN6S585C53v59Ev,
  (VTBL_ENTRY)&_ZN6S585C53v60Ev,
  (VTBL_ENTRY)&_ZN6S585C53v61Ev,
  (VTBL_ENTRY)&_ZN6S585C53v62Ev,
  (VTBL_ENTRY)&_ZN6S585C53v63Ev,
  (VTBL_ENTRY)&_ZN6S585C53v64Ev,
  (VTBL_ENTRY)&_ZN6S585C53v65Ev,
  (VTBL_ENTRY)&_ZN6S585C53v66Ev,
  (VTBL_ENTRY)&_ZN6S585C53v67Ev,
};
extern VTBL_ENTRY _ZTI6S585C5[];
extern  VTBL_ENTRY _ZTV6S585C5[];
Class_Descriptor cd_S585C5 = {  "S585C5", // class name
  0,0,//no base classes
  &(vtc_S585C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S585C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S585C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S585C4  : S585C5 {
  int s585c4f0[2];
  void *s585c4f1;
  int s585c4f2[2];
  ::S27C26_nt s585c4f3;
  ::S27C26_nt s585c4f4;
  ::S246C12_nt s585c4f5;
  ::S27C26_nt s585c4f6;
  unsigned int s585c4f7:1;
  unsigned int s585c4f8:1;
  unsigned int s585c4f9:1;
  unsigned int s585c4f10:1;
  unsigned int s585c4f11:1;
  int s585c4f12[2];
  virtual  ~S585C4(); // _ZN6S585C4D1Ev
  virtual void  v68(); // _ZN6S585C43v68Ev
  virtual void  v69(); // _ZN6S585C43v69Ev
  virtual void  v70(); // _ZN6S585C43v70Ev
  virtual void  v71(); // _ZN6S585C43v71Ev
  virtual void  v72(); // _ZN6S585C43v72Ev
  virtual void  v73(); // _ZN6S585C43v73Ev
  virtual void  v74(); // _ZN6S585C43v74Ev
  virtual void  v75(); // _ZN6S585C43v75Ev
  virtual void  v76(); // _ZN6S585C43v76Ev
  virtual void  v77(); // _ZN6S585C43v77Ev
  virtual void  v78(); // _ZN6S585C43v78Ev
  virtual void  v79(); // _ZN6S585C43v79Ev
  virtual void  v80(); // _ZN6S585C43v80Ev
  virtual void  v81(); // _ZN6S585C43v81Ev
  virtual void  v82(); // _ZN6S585C43v82Ev
  virtual void  v83(); // _ZN6S585C43v83Ev
  virtual void  v84(); // _ZN6S585C43v84Ev
  virtual void  v85(); // _ZN6S585C43v85Ev
  virtual void  v86(); // _ZN6S585C43v86Ev
  virtual void  v87(); // _ZN6S585C43v87Ev
  virtual void  v88(); // _ZN6S585C43v88Ev
  virtual void  v89(); // _ZN6S585C43v89Ev
  S585C4(); // tgen
};
//SIG(-1 S585C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S585C4 ::~S585C4(){ note_dtor("S585C4", this);}
void  S585C4 ::v68(){vfunc_called(this, "_ZN6S585C43v68Ev");}
void  S585C4 ::v69(){vfunc_called(this, "_ZN6S585C43v69Ev");}
void  S585C4 ::v70(){vfunc_called(this, "_ZN6S585C43v70Ev");}
void  S585C4 ::v71(){vfunc_called(this, "_ZN6S585C43v71Ev");}
void  S585C4 ::v72(){vfunc_called(this, "_ZN6S585C43v72Ev");}
void  S585C4 ::v73(){vfunc_called(this, "_ZN6S585C43v73Ev");}
void  S585C4 ::v74(){vfunc_called(this, "_ZN6S585C43v74Ev");}
void  S585C4 ::v75(){vfunc_called(this, "_ZN6S585C43v75Ev");}
void  S585C4 ::v76(){vfunc_called(this, "_ZN6S585C43v76Ev");}
void  S585C4 ::v77(){vfunc_called(this, "_ZN6S585C43v77Ev");}
void  S585C4 ::v78(){vfunc_called(this, "_ZN6S585C43v78Ev");}
void  S585C4 ::v79(){vfunc_called(this, "_ZN6S585C43v79Ev");}
void  S585C4 ::v80(){vfunc_called(this, "_ZN6S585C43v80Ev");}
void  S585C4 ::v81(){vfunc_called(this, "_ZN6S585C43v81Ev");}
void  S585C4 ::v82(){vfunc_called(this, "_ZN6S585C43v82Ev");}
void  S585C4 ::v83(){vfunc_called(this, "_ZN6S585C43v83Ev");}
void  S585C4 ::v84(){vfunc_called(this, "_ZN6S585C43v84Ev");}
void  S585C4 ::v85(){vfunc_called(this, "_ZN6S585C43v85Ev");}
void  S585C4 ::v86(){vfunc_called(this, "_ZN6S585C43v86Ev");}
void  S585C4 ::v87(){vfunc_called(this, "_ZN6S585C43v87Ev");}
void  S585C4 ::v88(){vfunc_called(this, "_ZN6S585C43v88Ev");}
void  S585C4 ::v89(){vfunc_called(this, "_ZN6S585C43v89Ev");}
S585C4 ::S585C4(){ note_ctor("S585C4", this);} // tgen

static void Test_S585C4()
{
  extern Class_Descriptor cd_S585C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S585C4, buf);
    S585C4 *dp, &lv = *(dp=new (buf) S585C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S585C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S585C4)");
    check_base_class_offset(lv, (S585C5*), 0, "S585C4");
    check_field_offset(lv, s585c4f0, ABISELECT(96,60), "S585C4.s585c4f0");
    check_field_offset(lv, s585c4f1, ABISELECT(104,68), "S585C4.s585c4f1");
    check_field_offset(lv, s585c4f2, ABISELECT(112,72), "S585C4.s585c4f2");
    check_field_offset(lv, s585c4f3, ABISELECT(120,80), "S585C4.s585c4f3");
    check_field_offset(lv, s585c4f4, ABISELECT(136,92), "S585C4.s585c4f4");
    check_field_offset(lv, s585c4f5, ABISELECT(152,104), "S585C4.s585c4f5");
    check_field_offset(lv, s585c4f6, ABISELECT(160,108), "S585C4.s585c4f6");
    set_bf_and_test(lv, s585c4f7, ABISELECT(176,120), 0, 1, 1, "S585C4");
    set_bf_and_test(lv, s585c4f8, ABISELECT(176,120), 1, 1, 1, "S585C4");
    set_bf_and_test(lv, s585c4f9, ABISELECT(176,120), 2, 1, 1, "S585C4");
    set_bf_and_test(lv, s585c4f10, ABISELECT(176,120), 3, 1, 1, "S585C4");
    set_bf_and_test(lv, s585c4f11, ABISELECT(176,120), 4, 1, 1, "S585C4");
    check_field_offset(lv, s585c4f12, ABISELECT(180,124), "S585C4.s585c4f12");
    test_class_info(&lv, &cd_S585C4);
    dp->~S585C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS585C4(Test_S585C4, "S585C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S585C4C1Ev();
extern void _ZN6S585C4D1Ev();
Name_Map name_map_S585C4[] = {
  NSPAIR(_ZN6S585C4C1Ev),
  NSPAIR(_ZN6S585C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S585C5;
extern VTBL_ENTRY _ZTI6S585C5[];
extern  VTBL_ENTRY _ZTV6S585C5[];
static Base_Class bases_S585C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S585C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S585C4[];
extern void _ZN6S585C4D1Ev();
extern void _ZN6S585C4D0Ev();
extern void _ZN6S585C52v4Ev();
extern void _ZN6S585C52v5Ev();
extern void _ZN6S585C52v6Ev();
extern void _ZN6S585C52v7Ev();
extern void _ZN6S585C52v8Ev();
extern void _ZN6S585C52v9Ev();
extern void _ZN6S585C53v10Ev();
extern void _ZN6S585C53v11Ev();
extern void _ZN6S585C53v12Ev();
extern void _ZN6S585C53v13Ev();
extern void _ZN6S585C53v14Ev();
extern void _ZN6S585C53v15Ev();
extern void _ZN6S585C53v16Ev();
extern void _ZN6S585C53v17Ev();
extern void _ZN6S585C53v18Ev();
extern void _ZN6S585C53v19Ev();
extern void _ZN6S585C53v20Ev();
extern void _ZN6S585C53v21Ev();
extern void _ZN6S585C53v22Ev();
extern void _ZN6S585C53v23Ev();
extern void _ZN6S585C53v24Ev();
extern void _ZN6S585C53v25Ev();
extern void _ZN6S585C53v26Ev();
extern void _ZN6S585C53v27Ev();
extern void _ZN6S585C53v28Ev();
extern void _ZN6S585C53v29Ev();
extern void _ZN6S585C53v30Ev();
extern void _ZN6S585C53v31Ev();
extern void _ZN6S585C53v32Ev();
extern void _ZN6S585C53v33Ev();
extern void _ZN6S585C53v34Ev();
extern void _ZN6S585C53v35Ev();
extern void _ZN6S585C53v36Ev();
extern void _ZN6S585C53v37Ev();
extern void _ZN6S585C53v38Ev();
extern void _ZN6S585C53v39Ev();
extern void _ZN6S585C53v40Ev();
extern void _ZN6S585C53v41Ev();
extern void _ZN6S585C53v42Ev();
extern void _ZN6S585C53v43Ev();
extern void _ZN6S585C53v44Ev();
extern void _ZN6S585C53v45Ev();
extern void _ZN6S585C53v46Ev();
extern void _ZN6S585C53v47Ev();
extern void _ZN6S585C53v48Ev();
extern void _ZN6S585C53v49Ev();
extern void _ZN6S585C53v50Ev();
extern void _ZN6S585C53v51Ev();
extern void _ZN6S585C53v52Ev();
extern void _ZN6S585C53v53Ev();
extern void _ZN6S585C53v54Ev();
extern void _ZN6S585C53v55Ev();
extern void _ZN6S585C53v56Ev();
extern void _ZN6S585C53v57Ev();
extern void _ZN6S585C53v58Ev();
extern void _ZN6S585C53v59Ev();
extern void _ZN6S585C53v60Ev();
extern void _ZN6S585C53v61Ev();
extern void _ZN6S585C53v62Ev();
extern void _ZN6S585C53v63Ev();
extern void _ZN6S585C53v64Ev();
extern void _ZN6S585C53v65Ev();
extern void _ZN6S585C53v66Ev();
extern void _ZN6S585C53v67Ev();
extern void _ZN6S585C43v68Ev();
extern void _ZN6S585C43v69Ev();
extern void _ZN6S585C43v70Ev();
extern void _ZN6S585C43v71Ev();
extern void _ZN6S585C43v72Ev();
extern void _ZN6S585C43v73Ev();
extern void _ZN6S585C43v74Ev();
extern void _ZN6S585C43v75Ev();
extern void _ZN6S585C43v76Ev();
extern void _ZN6S585C43v77Ev();
extern void _ZN6S585C43v78Ev();
extern void _ZN6S585C43v79Ev();
extern void _ZN6S585C43v80Ev();
extern void _ZN6S585C43v81Ev();
extern void _ZN6S585C43v82Ev();
extern void _ZN6S585C43v83Ev();
extern void _ZN6S585C43v84Ev();
extern void _ZN6S585C43v85Ev();
extern void _ZN6S585C43v86Ev();
extern void _ZN6S585C43v87Ev();
extern void _ZN6S585C43v88Ev();
extern void _ZN6S585C43v89Ev();
static  VTBL_ENTRY vtc_S585C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S585C4[0]),
  (VTBL_ENTRY)&_ZN6S585C4D1Ev,
  (VTBL_ENTRY)&_ZN6S585C4D0Ev,
  (VTBL_ENTRY)&_ZN6S585C52v4Ev,
  (VTBL_ENTRY)&_ZN6S585C52v5Ev,
  (VTBL_ENTRY)&_ZN6S585C52v6Ev,
  (VTBL_ENTRY)&_ZN6S585C52v7Ev,
  (VTBL_ENTRY)&_ZN6S585C52v8Ev,
  (VTBL_ENTRY)&_ZN6S585C52v9Ev,
  (VTBL_ENTRY)&_ZN6S585C53v10Ev,
  (VTBL_ENTRY)&_ZN6S585C53v11Ev,
  (VTBL_ENTRY)&_ZN6S585C53v12Ev,
  (VTBL_ENTRY)&_ZN6S585C53v13Ev,
  (VTBL_ENTRY)&_ZN6S585C53v14Ev,
  (VTBL_ENTRY)&_ZN6S585C53v15Ev,
  (VTBL_ENTRY)&_ZN6S585C53v16Ev,
  (VTBL_ENTRY)&_ZN6S585C53v17Ev,
  (VTBL_ENTRY)&_ZN6S585C53v18Ev,
  (VTBL_ENTRY)&_ZN6S585C53v19Ev,
  (VTBL_ENTRY)&_ZN6S585C53v20Ev,
  (VTBL_ENTRY)&_ZN6S585C53v21Ev,
  (VTBL_ENTRY)&_ZN6S585C53v22Ev,
  (VTBL_ENTRY)&_ZN6S585C53v23Ev,
  (VTBL_ENTRY)&_ZN6S585C53v24Ev,
  (VTBL_ENTRY)&_ZN6S585C53v25Ev,
  (VTBL_ENTRY)&_ZN6S585C53v26Ev,
  (VTBL_ENTRY)&_ZN6S585C53v27Ev,
  (VTBL_ENTRY)&_ZN6S585C53v28Ev,
  (VTBL_ENTRY)&_ZN6S585C53v29Ev,
  (VTBL_ENTRY)&_ZN6S585C53v30Ev,
  (VTBL_ENTRY)&_ZN6S585C53v31Ev,
  (VTBL_ENTRY)&_ZN6S585C53v32Ev,
  (VTBL_ENTRY)&_ZN6S585C53v33Ev,
  (VTBL_ENTRY)&_ZN6S585C53v34Ev,
  (VTBL_ENTRY)&_ZN6S585C53v35Ev,
  (VTBL_ENTRY)&_ZN6S585C53v36Ev,
  (VTBL_ENTRY)&_ZN6S585C53v37Ev,
  (VTBL_ENTRY)&_ZN6S585C53v38Ev,
  (VTBL_ENTRY)&_ZN6S585C53v39Ev,
  (VTBL_ENTRY)&_ZN6S585C53v40Ev,
  (VTBL_ENTRY)&_ZN6S585C53v41Ev,
  (VTBL_ENTRY)&_ZN6S585C53v42Ev,
  (VTBL_ENTRY)&_ZN6S585C53v43Ev,
  (VTBL_ENTRY)&_ZN6S585C53v44Ev,
  (VTBL_ENTRY)&_ZN6S585C53v45Ev,
  (VTBL_ENTRY)&_ZN6S585C53v46Ev,
  (VTBL_ENTRY)&_ZN6S585C53v47Ev,
  (VTBL_ENTRY)&_ZN6S585C53v48Ev,
  (VTBL_ENTRY)&_ZN6S585C53v49Ev,
  (VTBL_ENTRY)&_ZN6S585C53v50Ev,
  (VTBL_ENTRY)&_ZN6S585C53v51Ev,
  (VTBL_ENTRY)&_ZN6S585C53v52Ev,
  (VTBL_ENTRY)&_ZN6S585C53v53Ev,
  (VTBL_ENTRY)&_ZN6S585C53v54Ev,
  (VTBL_ENTRY)&_ZN6S585C53v55Ev,
  (VTBL_ENTRY)&_ZN6S585C53v56Ev,
  (VTBL_ENTRY)&_ZN6S585C53v57Ev,
  (VTBL_ENTRY)&_ZN6S585C53v58Ev,
  (VTBL_ENTRY)&_ZN6S585C53v59Ev,
  (VTBL_ENTRY)&_ZN6S585C53v60Ev,
  (VTBL_ENTRY)&_ZN6S585C53v61Ev,
  (VTBL_ENTRY)&_ZN6S585C53v62Ev,
  (VTBL_ENTRY)&_ZN6S585C53v63Ev,
  (VTBL_ENTRY)&_ZN6S585C53v64Ev,
  (VTBL_ENTRY)&_ZN6S585C53v65Ev,
  (VTBL_ENTRY)&_ZN6S585C53v66Ev,
  (VTBL_ENTRY)&_ZN6S585C53v67Ev,
  (VTBL_ENTRY)&_ZN6S585C43v68Ev,
  (VTBL_ENTRY)&_ZN6S585C43v69Ev,
  (VTBL_ENTRY)&_ZN6S585C43v70Ev,
  (VTBL_ENTRY)&_ZN6S585C43v71Ev,
  (VTBL_ENTRY)&_ZN6S585C43v72Ev,
  (VTBL_ENTRY)&_ZN6S585C43v73Ev,
  (VTBL_ENTRY)&_ZN6S585C43v74Ev,
  (VTBL_ENTRY)&_ZN6S585C43v75Ev,
  (VTBL_ENTRY)&_ZN6S585C43v76Ev,
  (VTBL_ENTRY)&_ZN6S585C43v77Ev,
  (VTBL_ENTRY)&_ZN6S585C43v78Ev,
  (VTBL_ENTRY)&_ZN6S585C43v79Ev,
  (VTBL_ENTRY)&_ZN6S585C43v80Ev,
  (VTBL_ENTRY)&_ZN6S585C43v81Ev,
  (VTBL_ENTRY)&_ZN6S585C43v82Ev,
  (VTBL_ENTRY)&_ZN6S585C43v83Ev,
  (VTBL_ENTRY)&_ZN6S585C43v84Ev,
  (VTBL_ENTRY)&_ZN6S585C43v85Ev,
  (VTBL_ENTRY)&_ZN6S585C43v86Ev,
  (VTBL_ENTRY)&_ZN6S585C43v87Ev,
  (VTBL_ENTRY)&_ZN6S585C43v88Ev,
  (VTBL_ENTRY)&_ZN6S585C43v89Ev,
};
extern VTBL_ENTRY _ZTI6S585C4[];
extern  VTBL_ENTRY _ZTV6S585C4[];
Class_Descriptor cd_S585C4 = {  "S585C4", // class name
  bases_S585C4, 1,
  &(vtc_S585C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S585C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S585C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S585C3  : S585C4 {
  unsigned int s585c3f0:1;
  unsigned int s585c3f1:1;
  unsigned int s585c3f2:1;
  ::S27C80 s585c3f3;
  ::S27C76 s585c3f4;
  ::S27C71 s585c3f5;
  ::S27C66 s585c3f6;
  int s585c3f7[3];
  virtual  ~S585C3(); // _ZN6S585C3D1Ev
  virtual void  v90(); // _ZN6S585C33v90Ev
  virtual void  v91(); // _ZN6S585C33v91Ev
  virtual void  v92(); // _ZN6S585C33v92Ev
  virtual void  v93(); // _ZN6S585C33v93Ev
  virtual void  v94(); // _ZN6S585C33v94Ev
  virtual void  v95(); // _ZN6S585C33v95Ev
  virtual void  v96(); // _ZN6S585C33v96Ev
  virtual void  v97(); // _ZN6S585C33v97Ev
  virtual void  v98(); // _ZN6S585C33v98Ev
  virtual void  v99(); // _ZN6S585C33v99Ev
  virtual void  v100(); // _ZN6S585C34v100Ev
  virtual void  v101(); // _ZN6S585C34v101Ev
  virtual void  v102(); // _ZN6S585C34v102Ev
  virtual void  v103(); // _ZN6S585C34v103Ev
  virtual void  v104(); // _ZN6S585C34v104Ev
  virtual void  v105(); // _ZN6S585C34v105Ev
  virtual void  v106(); // _ZN6S585C34v106Ev
  virtual void  v107(); // _ZN6S585C34v107Ev
  virtual void  v108(); // _ZN6S585C34v108Ev
  virtual void  v109(); // _ZN6S585C34v109Ev
  S585C3(); // tgen
};
//SIG(-1 S585C3) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S585C3 ::~S585C3(){ note_dtor("S585C3", this);}
void  S585C3 ::v90(){vfunc_called(this, "_ZN6S585C33v90Ev");}
void  S585C3 ::v91(){vfunc_called(this, "_ZN6S585C33v91Ev");}
void  S585C3 ::v92(){vfunc_called(this, "_ZN6S585C33v92Ev");}
void  S585C3 ::v93(){vfunc_called(this, "_ZN6S585C33v93Ev");}
void  S585C3 ::v94(){vfunc_called(this, "_ZN6S585C33v94Ev");}
void  S585C3 ::v95(){vfunc_called(this, "_ZN6S585C33v95Ev");}
void  S585C3 ::v96(){vfunc_called(this, "_ZN6S585C33v96Ev");}
void  S585C3 ::v97(){vfunc_called(this, "_ZN6S585C33v97Ev");}
void  S585C3 ::v98(){vfunc_called(this, "_ZN6S585C33v98Ev");}
void  S585C3 ::v99(){vfunc_called(this, "_ZN6S585C33v99Ev");}
void  S585C3 ::v100(){vfunc_called(this, "_ZN6S585C34v100Ev");}
void  S585C3 ::v101(){vfunc_called(this, "_ZN6S585C34v101Ev");}
void  S585C3 ::v102(){vfunc_called(this, "_ZN6S585C34v102Ev");}
void  S585C3 ::v103(){vfunc_called(this, "_ZN6S585C34v103Ev");}
void  S585C3 ::v104(){vfunc_called(this, "_ZN6S585C34v104Ev");}
void  S585C3 ::v105(){vfunc_called(this, "_ZN6S585C34v105Ev");}
void  S585C3 ::v106(){vfunc_called(this, "_ZN6S585C34v106Ev");}
void  S585C3 ::v107(){vfunc_called(this, "_ZN6S585C34v107Ev");}
void  S585C3 ::v108(){vfunc_called(this, "_ZN6S585C34v108Ev");}
void  S585C3 ::v109(){vfunc_called(this, "_ZN6S585C34v109Ev");}
S585C3 ::S585C3(){ note_ctor("S585C3", this);} // tgen

static void Test_S585C3()
{
  extern Class_Descriptor cd_S585C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S585C3, buf);
    S585C3 *dp, &lv = *(dp=new (buf) S585C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S585C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S585C3)");
    check_base_class_offset(lv, (S585C5*)(S585C4*), 0, "S585C3");
    check_base_class_offset(lv, (S585C4*), 0, "S585C3");
    set_bf_and_test(lv, s585c3f0, ABISELECT(188,132), 0, 1, 1, "S585C3");
    set_bf_and_test(lv, s585c3f1, ABISELECT(188,132), 1, 1, 1, "S585C3");
    set_bf_and_test(lv, s585c3f2, ABISELECT(188,132), 2, 1, 1, "S585C3");
    check_field_offset(lv, s585c3f3, ABISELECT(192,136), "S585C3.s585c3f3");
    check_field_offset(lv, s585c3f4, ABISELECT(208,148), "S585C3.s585c3f4");
    check_field_offset(lv, s585c3f5, ABISELECT(224,160), "S585C3.s585c3f5");
    check_field_offset(lv, s585c3f6, ABISELECT(240,172), "S585C3.s585c3f6");
    check_field_offset(lv, s585c3f7, ABISELECT(256,184), "S585C3.s585c3f7");
    test_class_info(&lv, &cd_S585C3);
    dp->~S585C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS585C3(Test_S585C3, "S585C3", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S585C3C1Ev();
extern void _ZN6S585C3D1Ev();
Name_Map name_map_S585C3[] = {
  NSPAIR(_ZN6S585C3C1Ev),
  NSPAIR(_ZN6S585C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S585C5;
extern VTBL_ENTRY _ZTI6S585C5[];
extern  VTBL_ENTRY _ZTV6S585C5[];
extern Class_Descriptor cd_S585C4;
extern VTBL_ENTRY _ZTI6S585C4[];
extern  VTBL_ENTRY _ZTV6S585C4[];
static Base_Class bases_S585C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S585C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S585C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S585C3[];
extern void _ZN6S585C3D1Ev();
extern void _ZN6S585C3D0Ev();
extern void _ZN6S585C52v4Ev();
extern void _ZN6S585C52v5Ev();
extern void _ZN6S585C52v6Ev();
extern void _ZN6S585C52v7Ev();
extern void _ZN6S585C52v8Ev();
extern void _ZN6S585C52v9Ev();
extern void _ZN6S585C53v10Ev();
extern void _ZN6S585C53v11Ev();
extern void _ZN6S585C53v12Ev();
extern void _ZN6S585C53v13Ev();
extern void _ZN6S585C53v14Ev();
extern void _ZN6S585C53v15Ev();
extern void _ZN6S585C53v16Ev();
extern void _ZN6S585C53v17Ev();
extern void _ZN6S585C53v18Ev();
extern void _ZN6S585C53v19Ev();
extern void _ZN6S585C53v20Ev();
extern void _ZN6S585C53v21Ev();
extern void _ZN6S585C53v22Ev();
extern void _ZN6S585C53v23Ev();
extern void _ZN6S585C53v24Ev();
extern void _ZN6S585C53v25Ev();
extern void _ZN6S585C53v26Ev();
extern void _ZN6S585C53v27Ev();
extern void _ZN6S585C53v28Ev();
extern void _ZN6S585C53v29Ev();
extern void _ZN6S585C53v30Ev();
extern void _ZN6S585C53v31Ev();
extern void _ZN6S585C53v32Ev();
extern void _ZN6S585C53v33Ev();
extern void _ZN6S585C53v34Ev();
extern void _ZN6S585C53v35Ev();
extern void _ZN6S585C53v36Ev();
extern void _ZN6S585C53v37Ev();
extern void _ZN6S585C53v38Ev();
extern void _ZN6S585C53v39Ev();
extern void _ZN6S585C53v40Ev();
extern void _ZN6S585C53v41Ev();
extern void _ZN6S585C53v42Ev();
extern void _ZN6S585C53v43Ev();
extern void _ZN6S585C53v44Ev();
extern void _ZN6S585C53v45Ev();
extern void _ZN6S585C53v46Ev();
extern void _ZN6S585C53v47Ev();
extern void _ZN6S585C53v48Ev();
extern void _ZN6S585C53v49Ev();
extern void _ZN6S585C53v50Ev();
extern void _ZN6S585C53v51Ev();
extern void _ZN6S585C53v52Ev();
extern void _ZN6S585C53v53Ev();
extern void _ZN6S585C53v54Ev();
extern void _ZN6S585C53v55Ev();
extern void _ZN6S585C53v56Ev();
extern void _ZN6S585C53v57Ev();
extern void _ZN6S585C53v58Ev();
extern void _ZN6S585C53v59Ev();
extern void _ZN6S585C53v60Ev();
extern void _ZN6S585C53v61Ev();
extern void _ZN6S585C53v62Ev();
extern void _ZN6S585C53v63Ev();
extern void _ZN6S585C53v64Ev();
extern void _ZN6S585C53v65Ev();
extern void _ZN6S585C53v66Ev();
extern void _ZN6S585C53v67Ev();
extern void _ZN6S585C43v68Ev();
extern void _ZN6S585C43v69Ev();
extern void _ZN6S585C43v70Ev();
extern void _ZN6S585C43v71Ev();
extern void _ZN6S585C43v72Ev();
extern void _ZN6S585C43v73Ev();
extern void _ZN6S585C43v74Ev();
extern void _ZN6S585C43v75Ev();
extern void _ZN6S585C43v76Ev();
extern void _ZN6S585C43v77Ev();
extern void _ZN6S585C43v78Ev();
extern void _ZN6S585C43v79Ev();
extern void _ZN6S585C43v80Ev();
extern void _ZN6S585C43v81Ev();
extern void _ZN6S585C43v82Ev();
extern void _ZN6S585C43v83Ev();
extern void _ZN6S585C43v84Ev();
extern void _ZN6S585C43v85Ev();
extern void _ZN6S585C43v86Ev();
extern void _ZN6S585C43v87Ev();
extern void _ZN6S585C43v88Ev();
extern void _ZN6S585C43v89Ev();
extern void _ZN6S585C33v90Ev();
extern void _ZN6S585C33v91Ev();
extern void _ZN6S585C33v92Ev();
extern void _ZN6S585C33v93Ev();
extern void _ZN6S585C33v94Ev();
extern void _ZN6S585C33v95Ev();
extern void _ZN6S585C33v96Ev();
extern void _ZN6S585C33v97Ev();
extern void _ZN6S585C33v98Ev();
extern void _ZN6S585C33v99Ev();
extern void _ZN6S585C34v100Ev();
extern void _ZN6S585C34v101Ev();
extern void _ZN6S585C34v102Ev();
extern void _ZN6S585C34v103Ev();
extern void _ZN6S585C34v104Ev();
extern void _ZN6S585C34v105Ev();
extern void _ZN6S585C34v106Ev();
extern void _ZN6S585C34v107Ev();
extern void _ZN6S585C34v108Ev();
extern void _ZN6S585C34v109Ev();
static  VTBL_ENTRY vtc_S585C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S585C3[0]),
  (VTBL_ENTRY)&_ZN6S585C3D1Ev,
  (VTBL_ENTRY)&_ZN6S585C3D0Ev,
  (VTBL_ENTRY)&_ZN6S585C52v4Ev,
  (VTBL_ENTRY)&_ZN6S585C52v5Ev,
  (VTBL_ENTRY)&_ZN6S585C52v6Ev,
  (VTBL_ENTRY)&_ZN6S585C52v7Ev,
  (VTBL_ENTRY)&_ZN6S585C52v8Ev,
  (VTBL_ENTRY)&_ZN6S585C52v9Ev,
  (VTBL_ENTRY)&_ZN6S585C53v10Ev,
  (VTBL_ENTRY)&_ZN6S585C53v11Ev,
  (VTBL_ENTRY)&_ZN6S585C53v12Ev,
  (VTBL_ENTRY)&_ZN6S585C53v13Ev,
  (VTBL_ENTRY)&_ZN6S585C53v14Ev,
  (VTBL_ENTRY)&_ZN6S585C53v15Ev,
  (VTBL_ENTRY)&_ZN6S585C53v16Ev,
  (VTBL_ENTRY)&_ZN6S585C53v17Ev,
  (VTBL_ENTRY)&_ZN6S585C53v18Ev,
  (VTBL_ENTRY)&_ZN6S585C53v19Ev,
  (VTBL_ENTRY)&_ZN6S585C53v20Ev,
  (VTBL_ENTRY)&_ZN6S585C53v21Ev,
  (VTBL_ENTRY)&_ZN6S585C53v22Ev,
  (VTBL_ENTRY)&_ZN6S585C53v23Ev,
  (VTBL_ENTRY)&_ZN6S585C53v24Ev,
  (VTBL_ENTRY)&_ZN6S585C53v25Ev,
  (VTBL_ENTRY)&_ZN6S585C53v26Ev,
  (VTBL_ENTRY)&_ZN6S585C53v27Ev,
  (VTBL_ENTRY)&_ZN6S585C53v28Ev,
  (VTBL_ENTRY)&_ZN6S585C53v29Ev,
  (VTBL_ENTRY)&_ZN6S585C53v30Ev,
  (VTBL_ENTRY)&_ZN6S585C53v31Ev,
  (VTBL_ENTRY)&_ZN6S585C53v32Ev,
  (VTBL_ENTRY)&_ZN6S585C53v33Ev,
  (VTBL_ENTRY)&_ZN6S585C53v34Ev,
  (VTBL_ENTRY)&_ZN6S585C53v35Ev,
  (VTBL_ENTRY)&_ZN6S585C53v36Ev,
  (VTBL_ENTRY)&_ZN6S585C53v37Ev,
  (VTBL_ENTRY)&_ZN6S585C53v38Ev,
  (VTBL_ENTRY)&_ZN6S585C53v39Ev,
  (VTBL_ENTRY)&_ZN6S585C53v40Ev,
  (VTBL_ENTRY)&_ZN6S585C53v41Ev,
  (VTBL_ENTRY)&_ZN6S585C53v42Ev,
  (VTBL_ENTRY)&_ZN6S585C53v43Ev,
  (VTBL_ENTRY)&_ZN6S585C53v44Ev,
  (VTBL_ENTRY)&_ZN6S585C53v45Ev,
  (VTBL_ENTRY)&_ZN6S585C53v46Ev,
  (VTBL_ENTRY)&_ZN6S585C53v47Ev,
  (VTBL_ENTRY)&_ZN6S585C53v48Ev,
  (VTBL_ENTRY)&_ZN6S585C53v49Ev,
  (VTBL_ENTRY)&_ZN6S585C53v50Ev,
  (VTBL_ENTRY)&_ZN6S585C53v51Ev,
  (VTBL_ENTRY)&_ZN6S585C53v52Ev,
  (VTBL_ENTRY)&_ZN6S585C53v53Ev,
  (VTBL_ENTRY)&_ZN6S585C53v54Ev,
  (VTBL_ENTRY)&_ZN6S585C53v55Ev,
  (VTBL_ENTRY)&_ZN6S585C53v56Ev,
  (VTBL_ENTRY)&_ZN6S585C53v57Ev,
  (VTBL_ENTRY)&_ZN6S585C53v58Ev,
  (VTBL_ENTRY)&_ZN6S585C53v59Ev,
  (VTBL_ENTRY)&_ZN6S585C53v60Ev,
  (VTBL_ENTRY)&_ZN6S585C53v61Ev,
  (VTBL_ENTRY)&_ZN6S585C53v62Ev,
  (VTBL_ENTRY)&_ZN6S585C53v63Ev,
  (VTBL_ENTRY)&_ZN6S585C53v64Ev,
  (VTBL_ENTRY)&_ZN6S585C53v65Ev,
  (VTBL_ENTRY)&_ZN6S585C53v66Ev,
  (VTBL_ENTRY)&_ZN6S585C53v67Ev,
  (VTBL_ENTRY)&_ZN6S585C43v68Ev,
  (VTBL_ENTRY)&_ZN6S585C43v69Ev,
  (VTBL_ENTRY)&_ZN6S585C43v70Ev,
  (VTBL_ENTRY)&_ZN6S585C43v71Ev,
  (VTBL_ENTRY)&_ZN6S585C43v72Ev,
  (VTBL_ENTRY)&_ZN6S585C43v73Ev,
  (VTBL_ENTRY)&_ZN6S585C43v74Ev,
  (VTBL_ENTRY)&_ZN6S585C43v75Ev,
  (VTBL_ENTRY)&_ZN6S585C43v76Ev,
  (VTBL_ENTRY)&_ZN6S585C43v77Ev,
  (VTBL_ENTRY)&_ZN6S585C43v78Ev,
  (VTBL_ENTRY)&_ZN6S585C43v79Ev,
  (VTBL_ENTRY)&_ZN6S585C43v80Ev,
  (VTBL_ENTRY)&_ZN6S585C43v81Ev,
  (VTBL_ENTRY)&_ZN6S585C43v82Ev,
  (VTBL_ENTRY)&_ZN6S585C43v83Ev,
  (VTBL_ENTRY)&_ZN6S585C43v84Ev,
  (VTBL_ENTRY)&_ZN6S585C43v85Ev,
  (VTBL_ENTRY)&_ZN6S585C43v86Ev,
  (VTBL_ENTRY)&_ZN6S585C43v87Ev,
  (VTBL_ENTRY)&_ZN6S585C43v88Ev,
  (VTBL_ENTRY)&_ZN6S585C43v89Ev,
  (VTBL_ENTRY)&_ZN6S585C33v90Ev,
  (VTBL_ENTRY)&_ZN6S585C33v91Ev,
  (VTBL_ENTRY)&_ZN6S585C33v92Ev,
  (VTBL_ENTRY)&_ZN6S585C33v93Ev,
  (VTBL_ENTRY)&_ZN6S585C33v94Ev,
  (VTBL_ENTRY)&_ZN6S585C33v95Ev,
  (VTBL_ENTRY)&_ZN6S585C33v96Ev,
  (VTBL_ENTRY)&_ZN6S585C33v97Ev,
  (VTBL_ENTRY)&_ZN6S585C33v98Ev,
  (VTBL_ENTRY)&_ZN6S585C33v99Ev,
  (VTBL_ENTRY)&_ZN6S585C34v100Ev,
  (VTBL_ENTRY)&_ZN6S585C34v101Ev,
  (VTBL_ENTRY)&_ZN6S585C34v102Ev,
  (VTBL_ENTRY)&_ZN6S585C34v103Ev,
  (VTBL_ENTRY)&_ZN6S585C34v104Ev,
  (VTBL_ENTRY)&_ZN6S585C34v105Ev,
  (VTBL_ENTRY)&_ZN6S585C34v106Ev,
  (VTBL_ENTRY)&_ZN6S585C34v107Ev,
  (VTBL_ENTRY)&_ZN6S585C34v108Ev,
  (VTBL_ENTRY)&_ZN6S585C34v109Ev,
};
extern VTBL_ENTRY _ZTI6S585C3[];
extern  VTBL_ENTRY _ZTV6S585C3[];
Class_Descriptor cd_S585C3 = {  "S585C3", // class name
  bases_S585C3, 2,
  &(vtc_S585C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S585C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S585C3),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S585C2  : S585C3 {
  ::S27C9_nt s585c2f0;
  unsigned int s585c2f1:1;
  ::S27C62 s585c2f2;
  virtual  ~S585C2(); // _ZN6S585C2D1Ev
  virtual void  v110(); // _ZN6S585C24v110Ev
  virtual void  v111(); // _ZN6S585C24v111Ev
  virtual void  v112(); // _ZN6S585C24v112Ev
  virtual void  v113(); // _ZN6S585C24v113Ev
  S585C2(); // tgen
};
//SIG(-1 S585C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S585C2 ::~S585C2(){ note_dtor("S585C2", this);}
void  S585C2 ::v110(){vfunc_called(this, "_ZN6S585C24v110Ev");}
void  S585C2 ::v111(){vfunc_called(this, "_ZN6S585C24v111Ev");}
void  S585C2 ::v112(){vfunc_called(this, "_ZN6S585C24v112Ev");}
void  S585C2 ::v113(){vfunc_called(this, "_ZN6S585C24v113Ev");}
S585C2 ::S585C2(){ note_ctor("S585C2", this);} // tgen

static void Test_S585C2()
{
  extern Class_Descriptor cd_S585C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S585C2, buf);
    S585C2 *dp, &lv = *(dp=new (buf) S585C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S585C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S585C2)");
    check_base_class_offset(lv, (S585C5*)(S585C4*)(S585C3*), 0, "S585C2");
    check_base_class_offset(lv, (S585C4*)(S585C3*), 0, "S585C2");
    check_base_class_offset(lv, (S585C3*), 0, "S585C2");
    check_field_offset(lv, s585c2f0, ABISELECT(268,196), "S585C2.s585c2f0");
    set_bf_and_test(lv, s585c2f1, ABISELECT(276,204), 0, 1, 1, "S585C2");
    check_field_offset(lv, s585c2f2, ABISELECT(280,208), "S585C2.s585c2f2");
    test_class_info(&lv, &cd_S585C2);
    dp->~S585C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS585C2(Test_S585C2, "S585C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S585C2C1Ev();
extern void _ZN6S585C2D1Ev();
Name_Map name_map_S585C2[] = {
  NSPAIR(_ZN6S585C2C1Ev),
  NSPAIR(_ZN6S585C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S585C5;
extern VTBL_ENTRY _ZTI6S585C5[];
extern  VTBL_ENTRY _ZTV6S585C5[];
extern Class_Descriptor cd_S585C4;
extern VTBL_ENTRY _ZTI6S585C4[];
extern  VTBL_ENTRY _ZTV6S585C4[];
extern Class_Descriptor cd_S585C3;
extern VTBL_ENTRY _ZTI6S585C3[];
extern  VTBL_ENTRY _ZTV6S585C3[];
static Base_Class bases_S585C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S585C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S585C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S585C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S585C2[];
extern void _ZN6S585C2D1Ev();
extern void _ZN6S585C2D0Ev();
extern void _ZN6S585C52v4Ev();
extern void _ZN6S585C52v5Ev();
extern void _ZN6S585C52v6Ev();
extern void _ZN6S585C52v7Ev();
extern void _ZN6S585C52v8Ev();
extern void _ZN6S585C52v9Ev();
extern void _ZN6S585C53v10Ev();
extern void _ZN6S585C53v11Ev();
extern void _ZN6S585C53v12Ev();
extern void _ZN6S585C53v13Ev();
extern void _ZN6S585C53v14Ev();
extern void _ZN6S585C53v15Ev();
extern void _ZN6S585C53v16Ev();
extern void _ZN6S585C53v17Ev();
extern void _ZN6S585C53v18Ev();
extern void _ZN6S585C53v19Ev();
extern void _ZN6S585C53v20Ev();
extern void _ZN6S585C53v21Ev();
extern void _ZN6S585C53v22Ev();
extern void _ZN6S585C53v23Ev();
extern void _ZN6S585C53v24Ev();
extern void _ZN6S585C53v25Ev();
extern void _ZN6S585C53v26Ev();
extern void _ZN6S585C53v27Ev();
extern void _ZN6S585C53v28Ev();
extern void _ZN6S585C53v29Ev();
extern void _ZN6S585C53v30Ev();
extern void _ZN6S585C53v31Ev();
extern void _ZN6S585C53v32Ev();
extern void _ZN6S585C53v33Ev();
extern void _ZN6S585C53v34Ev();
extern void _ZN6S585C53v35Ev();
extern void _ZN6S585C53v36Ev();
extern void _ZN6S585C53v37Ev();
extern void _ZN6S585C53v38Ev();
extern void _ZN6S585C53v39Ev();
extern void _ZN6S585C53v40Ev();
extern void _ZN6S585C53v41Ev();
extern void _ZN6S585C53v42Ev();
extern void _ZN6S585C53v43Ev();
extern void _ZN6S585C53v44Ev();
extern void _ZN6S585C53v45Ev();
extern void _ZN6S585C53v46Ev();
extern void _ZN6S585C53v47Ev();
extern void _ZN6S585C53v48Ev();
extern void _ZN6S585C53v49Ev();
extern void _ZN6S585C53v50Ev();
extern void _ZN6S585C53v51Ev();
extern void _ZN6S585C53v52Ev();
extern void _ZN6S585C53v53Ev();
extern void _ZN6S585C53v54Ev();
extern void _ZN6S585C53v55Ev();
extern void _ZN6S585C53v56Ev();
extern void _ZN6S585C53v57Ev();
extern void _ZN6S585C53v58Ev();
extern void _ZN6S585C53v59Ev();
extern void _ZN6S585C53v60Ev();
extern void _ZN6S585C53v61Ev();
extern void _ZN6S585C53v62Ev();
extern void _ZN6S585C53v63Ev();
extern void _ZN6S585C53v64Ev();
extern void _ZN6S585C53v65Ev();
extern void _ZN6S585C53v66Ev();
extern void _ZN6S585C53v67Ev();
extern void _ZN6S585C43v68Ev();
extern void _ZN6S585C43v69Ev();
extern void _ZN6S585C43v70Ev();
extern void _ZN6S585C43v71Ev();
extern void _ZN6S585C43v72Ev();
extern void _ZN6S585C43v73Ev();
extern void _ZN6S585C43v74Ev();
extern void _ZN6S585C43v75Ev();
extern void _ZN6S585C43v76Ev();
extern void _ZN6S585C43v77Ev();
extern void _ZN6S585C43v78Ev();
extern void _ZN6S585C43v79Ev();
extern void _ZN6S585C43v80Ev();
extern void _ZN6S585C43v81Ev();
extern void _ZN6S585C43v82Ev();
extern void _ZN6S585C43v83Ev();
extern void _ZN6S585C43v84Ev();
extern void _ZN6S585C43v85Ev();
extern void _ZN6S585C43v86Ev();
extern void _ZN6S585C43v87Ev();
extern void _ZN6S585C43v88Ev();
extern void _ZN6S585C43v89Ev();
extern void _ZN6S585C33v90Ev();
extern void _ZN6S585C33v91Ev();
extern void _ZN6S585C33v92Ev();
extern void _ZN6S585C33v93Ev();
extern void _ZN6S585C33v94Ev();
extern void _ZN6S585C33v95Ev();
extern void _ZN6S585C33v96Ev();
extern void _ZN6S585C33v97Ev();
extern void _ZN6S585C33v98Ev();
extern void _ZN6S585C33v99Ev();
extern void _ZN6S585C34v100Ev();
extern void _ZN6S585C34v101Ev();
extern void _ZN6S585C34v102Ev();
extern void _ZN6S585C34v103Ev();
extern void _ZN6S585C34v104Ev();
extern void _ZN6S585C34v105Ev();
extern void _ZN6S585C34v106Ev();
extern void _ZN6S585C34v107Ev();
extern void _ZN6S585C34v108Ev();
extern void _ZN6S585C34v109Ev();
extern void _ZN6S585C24v110Ev();
extern void _ZN6S585C24v111Ev();
extern void _ZN6S585C24v112Ev();
extern void _ZN6S585C24v113Ev();
static  VTBL_ENTRY vtc_S585C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S585C2[0]),
  (VTBL_ENTRY)&_ZN6S585C2D1Ev,
  (VTBL_ENTRY)&_ZN6S585C2D0Ev,
  (VTBL_ENTRY)&_ZN6S585C52v4Ev,
  (VTBL_ENTRY)&_ZN6S585C52v5Ev,
  (VTBL_ENTRY)&_ZN6S585C52v6Ev,
  (VTBL_ENTRY)&_ZN6S585C52v7Ev,
  (VTBL_ENTRY)&_ZN6S585C52v8Ev,
  (VTBL_ENTRY)&_ZN6S585C52v9Ev,
  (VTBL_ENTRY)&_ZN6S585C53v10Ev,
  (VTBL_ENTRY)&_ZN6S585C53v11Ev,
  (VTBL_ENTRY)&_ZN6S585C53v12Ev,
  (VTBL_ENTRY)&_ZN6S585C53v13Ev,
  (VTBL_ENTRY)&_ZN6S585C53v14Ev,
  (VTBL_ENTRY)&_ZN6S585C53v15Ev,
  (VTBL_ENTRY)&_ZN6S585C53v16Ev,
  (VTBL_ENTRY)&_ZN6S585C53v17Ev,
  (VTBL_ENTRY)&_ZN6S585C53v18Ev,
  (VTBL_ENTRY)&_ZN6S585C53v19Ev,
  (VTBL_ENTRY)&_ZN6S585C53v20Ev,
  (VTBL_ENTRY)&_ZN6S585C53v21Ev,
  (VTBL_ENTRY)&_ZN6S585C53v22Ev,
  (VTBL_ENTRY)&_ZN6S585C53v23Ev,
  (VTBL_ENTRY)&_ZN6S585C53v24Ev,
  (VTBL_ENTRY)&_ZN6S585C53v25Ev,
  (VTBL_ENTRY)&_ZN6S585C53v26Ev,
  (VTBL_ENTRY)&_ZN6S585C53v27Ev,
  (VTBL_ENTRY)&_ZN6S585C53v28Ev,
  (VTBL_ENTRY)&_ZN6S585C53v29Ev,
  (VTBL_ENTRY)&_ZN6S585C53v30Ev,
  (VTBL_ENTRY)&_ZN6S585C53v31Ev,
  (VTBL_ENTRY)&_ZN6S585C53v32Ev,
  (VTBL_ENTRY)&_ZN6S585C53v33Ev,
  (VTBL_ENTRY)&_ZN6S585C53v34Ev,
  (VTBL_ENTRY)&_ZN6S585C53v35Ev,
  (VTBL_ENTRY)&_ZN6S585C53v36Ev,
  (VTBL_ENTRY)&_ZN6S585C53v37Ev,
  (VTBL_ENTRY)&_ZN6S585C53v38Ev,
  (VTBL_ENTRY)&_ZN6S585C53v39Ev,
  (VTBL_ENTRY)&_ZN6S585C53v40Ev,
  (VTBL_ENTRY)&_ZN6S585C53v41Ev,
  (VTBL_ENTRY)&_ZN6S585C53v42Ev,
  (VTBL_ENTRY)&_ZN6S585C53v43Ev,
  (VTBL_ENTRY)&_ZN6S585C53v44Ev,
  (VTBL_ENTRY)&_ZN6S585C53v45Ev,
  (VTBL_ENTRY)&_ZN6S585C53v46Ev,
  (VTBL_ENTRY)&_ZN6S585C53v47Ev,
  (VTBL_ENTRY)&_ZN6S585C53v48Ev,
  (VTBL_ENTRY)&_ZN6S585C53v49Ev,
  (VTBL_ENTRY)&_ZN6S585C53v50Ev,
  (VTBL_ENTRY)&_ZN6S585C53v51Ev,
  (VTBL_ENTRY)&_ZN6S585C53v52Ev,
  (VTBL_ENTRY)&_ZN6S585C53v53Ev,
  (VTBL_ENTRY)&_ZN6S585C53v54Ev,
  (VTBL_ENTRY)&_ZN6S585C53v55Ev,
  (VTBL_ENTRY)&_ZN6S585C53v56Ev,
  (VTBL_ENTRY)&_ZN6S585C53v57Ev,
  (VTBL_ENTRY)&_ZN6S585C53v58Ev,
  (VTBL_ENTRY)&_ZN6S585C53v59Ev,
  (VTBL_ENTRY)&_ZN6S585C53v60Ev,
  (VTBL_ENTRY)&_ZN6S585C53v61Ev,
  (VTBL_ENTRY)&_ZN6S585C53v62Ev,
  (VTBL_ENTRY)&_ZN6S585C53v63Ev,
  (VTBL_ENTRY)&_ZN6S585C53v64Ev,
  (VTBL_ENTRY)&_ZN6S585C53v65Ev,
  (VTBL_ENTRY)&_ZN6S585C53v66Ev,
  (VTBL_ENTRY)&_ZN6S585C53v67Ev,
  (VTBL_ENTRY)&_ZN6S585C43v68Ev,
  (VTBL_ENTRY)&_ZN6S585C43v69Ev,
  (VTBL_ENTRY)&_ZN6S585C43v70Ev,
  (VTBL_ENTRY)&_ZN6S585C43v71Ev,
  (VTBL_ENTRY)&_ZN6S585C43v72Ev,
  (VTBL_ENTRY)&_ZN6S585C43v73Ev,
  (VTBL_ENTRY)&_ZN6S585C43v74Ev,
  (VTBL_ENTRY)&_ZN6S585C43v75Ev,
  (VTBL_ENTRY)&_ZN6S585C43v76Ev,
  (VTBL_ENTRY)&_ZN6S585C43v77Ev,
  (VTBL_ENTRY)&_ZN6S585C43v78Ev,
  (VTBL_ENTRY)&_ZN6S585C43v79Ev,
  (VTBL_ENTRY)&_ZN6S585C43v80Ev,
  (VTBL_ENTRY)&_ZN6S585C43v81Ev,
  (VTBL_ENTRY)&_ZN6S585C43v82Ev,
  (VTBL_ENTRY)&_ZN6S585C43v83Ev,
  (VTBL_ENTRY)&_ZN6S585C43v84Ev,
  (VTBL_ENTRY)&_ZN6S585C43v85Ev,
  (VTBL_ENTRY)&_ZN6S585C43v86Ev,
  (VTBL_ENTRY)&_ZN6S585C43v87Ev,
  (VTBL_ENTRY)&_ZN6S585C43v88Ev,
  (VTBL_ENTRY)&_ZN6S585C43v89Ev,
  (VTBL_ENTRY)&_ZN6S585C33v90Ev,
  (VTBL_ENTRY)&_ZN6S585C33v91Ev,
  (VTBL_ENTRY)&_ZN6S585C33v92Ev,
  (VTBL_ENTRY)&_ZN6S585C33v93Ev,
  (VTBL_ENTRY)&_ZN6S585C33v94Ev,
  (VTBL_ENTRY)&_ZN6S585C33v95Ev,
  (VTBL_ENTRY)&_ZN6S585C33v96Ev,
  (VTBL_ENTRY)&_ZN6S585C33v97Ev,
  (VTBL_ENTRY)&_ZN6S585C33v98Ev,
  (VTBL_ENTRY)&_ZN6S585C33v99Ev,
  (VTBL_ENTRY)&_ZN6S585C34v100Ev,
  (VTBL_ENTRY)&_ZN6S585C34v101Ev,
  (VTBL_ENTRY)&_ZN6S585C34v102Ev,
  (VTBL_ENTRY)&_ZN6S585C34v103Ev,
  (VTBL_ENTRY)&_ZN6S585C34v104Ev,
  (VTBL_ENTRY)&_ZN6S585C34v105Ev,
  (VTBL_ENTRY)&_ZN6S585C34v106Ev,
  (VTBL_ENTRY)&_ZN6S585C34v107Ev,
  (VTBL_ENTRY)&_ZN6S585C34v108Ev,
  (VTBL_ENTRY)&_ZN6S585C34v109Ev,
  (VTBL_ENTRY)&_ZN6S585C24v110Ev,
  (VTBL_ENTRY)&_ZN6S585C24v111Ev,
  (VTBL_ENTRY)&_ZN6S585C24v112Ev,
  (VTBL_ENTRY)&_ZN6S585C24v113Ev,
};
extern VTBL_ENTRY _ZTI6S585C2[];
extern  VTBL_ENTRY _ZTV6S585C2[];
Class_Descriptor cd_S585C2 = {  "S585C2", // class name
  bases_S585C2, 3,
  &(vtc_S585C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S585C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S585C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S585C1  : S585C2 {
  void *s585c1f0;
  int s585c1f1[3];
  unsigned int s585c1f2:1;
  void *s585c1f3;
  virtual  ~S585C1(); // _ZN6S585C1D1Ev
  virtual void  v1(); // _ZN6S585C12v1Ev
  virtual void  v2(); // _ZN6S585C12v2Ev
  virtual void  v3(); // _ZN6S585C12v3Ev
  S585C1(); // tgen
};
//SIG(1 S585C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v110 v111 v112 v113 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 Fp Fi[3] Fi:1 Fp}


 S585C1 ::~S585C1(){ note_dtor("S585C1", this);}
void  S585C1 ::v1(){vfunc_called(this, "_ZN6S585C12v1Ev");}
void  S585C1 ::v2(){vfunc_called(this, "_ZN6S585C12v2Ev");}
void  S585C1 ::v3(){vfunc_called(this, "_ZN6S585C12v3Ev");}
S585C1 ::S585C1(){ note_ctor("S585C1", this);} // tgen

static void Test_S585C1()
{
  extern Class_Descriptor cd_S585C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,62)];
    init_test(&cd_S585C1, buf);
    S585C1 *dp, &lv = *(dp=new (buf) S585C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,244), "sizeof(S585C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S585C1)");
    check_base_class_offset(lv, (S585C5*)(S585C4*)(S585C3*)(S585C2*), 0, "S585C1");
    check_base_class_offset(lv, (S585C4*)(S585C3*)(S585C2*), 0, "S585C1");
    check_base_class_offset(lv, (S585C3*)(S585C2*), 0, "S585C1");
    check_base_class_offset(lv, (S585C2*), 0, "S585C1");
    check_field_offset(lv, s585c1f0, ABISELECT(296,220), "S585C1.s585c1f0");
    check_field_offset(lv, s585c1f1, ABISELECT(304,224), "S585C1.s585c1f1");
    set_bf_and_test(lv, s585c1f2, ABISELECT(316,236), 0, 1, 1, "S585C1");
    check_field_offset(lv, s585c1f3, ABISELECT(320,240), "S585C1.s585c1f3");
    test_class_info(&lv, &cd_S585C1);
    dp->~S585C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS585C1(Test_S585C1, "S585C1", ABISELECT(328,244));

#else // __cplusplus

extern void _ZN6S585C1C1Ev();
extern void _ZN6S585C1D1Ev();
Name_Map name_map_S585C1[] = {
  NSPAIR(_ZN6S585C1C1Ev),
  NSPAIR(_ZN6S585C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S585C5;
extern VTBL_ENTRY _ZTI6S585C5[];
extern  VTBL_ENTRY _ZTV6S585C5[];
extern Class_Descriptor cd_S585C4;
extern VTBL_ENTRY _ZTI6S585C4[];
extern  VTBL_ENTRY _ZTV6S585C4[];
extern Class_Descriptor cd_S585C3;
extern VTBL_ENTRY _ZTI6S585C3[];
extern  VTBL_ENTRY _ZTV6S585C3[];
extern Class_Descriptor cd_S585C2;
extern VTBL_ENTRY _ZTI6S585C2[];
extern  VTBL_ENTRY _ZTV6S585C2[];
static Base_Class bases_S585C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S585C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S585C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S585C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S585C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S585C1[];
extern void _ZN6S585C1D1Ev();
extern void _ZN6S585C1D0Ev();
extern void _ZN6S585C52v4Ev();
extern void _ZN6S585C52v5Ev();
extern void _ZN6S585C52v6Ev();
extern void _ZN6S585C52v7Ev();
extern void _ZN6S585C52v8Ev();
extern void _ZN6S585C52v9Ev();
extern void _ZN6S585C53v10Ev();
extern void _ZN6S585C53v11Ev();
extern void _ZN6S585C53v12Ev();
extern void _ZN6S585C53v13Ev();
extern void _ZN6S585C53v14Ev();
extern void _ZN6S585C53v15Ev();
extern void _ZN6S585C53v16Ev();
extern void _ZN6S585C53v17Ev();
extern void _ZN6S585C53v18Ev();
extern void _ZN6S585C53v19Ev();
extern void _ZN6S585C53v20Ev();
extern void _ZN6S585C53v21Ev();
extern void _ZN6S585C53v22Ev();
extern void _ZN6S585C53v23Ev();
extern void _ZN6S585C53v24Ev();
extern void _ZN6S585C53v25Ev();
extern void _ZN6S585C53v26Ev();
extern void _ZN6S585C53v27Ev();
extern void _ZN6S585C53v28Ev();
extern void _ZN6S585C53v29Ev();
extern void _ZN6S585C53v30Ev();
extern void _ZN6S585C53v31Ev();
extern void _ZN6S585C53v32Ev();
extern void _ZN6S585C53v33Ev();
extern void _ZN6S585C53v34Ev();
extern void _ZN6S585C53v35Ev();
extern void _ZN6S585C53v36Ev();
extern void _ZN6S585C53v37Ev();
extern void _ZN6S585C53v38Ev();
extern void _ZN6S585C53v39Ev();
extern void _ZN6S585C53v40Ev();
extern void _ZN6S585C53v41Ev();
extern void _ZN6S585C53v42Ev();
extern void _ZN6S585C53v43Ev();
extern void _ZN6S585C53v44Ev();
extern void _ZN6S585C53v45Ev();
extern void _ZN6S585C53v46Ev();
extern void _ZN6S585C53v47Ev();
extern void _ZN6S585C53v48Ev();
extern void _ZN6S585C53v49Ev();
extern void _ZN6S585C53v50Ev();
extern void _ZN6S585C53v51Ev();
extern void _ZN6S585C53v52Ev();
extern void _ZN6S585C53v53Ev();
extern void _ZN6S585C53v54Ev();
extern void _ZN6S585C53v55Ev();
extern void _ZN6S585C53v56Ev();
extern void _ZN6S585C53v57Ev();
extern void _ZN6S585C53v58Ev();
extern void _ZN6S585C53v59Ev();
extern void _ZN6S585C53v60Ev();
extern void _ZN6S585C53v61Ev();
extern void _ZN6S585C53v62Ev();
extern void _ZN6S585C53v63Ev();
extern void _ZN6S585C53v64Ev();
extern void _ZN6S585C53v65Ev();
extern void _ZN6S585C53v66Ev();
extern void _ZN6S585C53v67Ev();
extern void _ZN6S585C43v68Ev();
extern void _ZN6S585C43v69Ev();
extern void _ZN6S585C43v70Ev();
extern void _ZN6S585C43v71Ev();
extern void _ZN6S585C43v72Ev();
extern void _ZN6S585C43v73Ev();
extern void _ZN6S585C43v74Ev();
extern void _ZN6S585C43v75Ev();
extern void _ZN6S585C43v76Ev();
extern void _ZN6S585C43v77Ev();
extern void _ZN6S585C43v78Ev();
extern void _ZN6S585C43v79Ev();
extern void _ZN6S585C43v80Ev();
extern void _ZN6S585C43v81Ev();
extern void _ZN6S585C43v82Ev();
extern void _ZN6S585C43v83Ev();
extern void _ZN6S585C43v84Ev();
extern void _ZN6S585C43v85Ev();
extern void _ZN6S585C43v86Ev();
extern void _ZN6S585C43v87Ev();
extern void _ZN6S585C43v88Ev();
extern void _ZN6S585C43v89Ev();
extern void _ZN6S585C33v90Ev();
extern void _ZN6S585C33v91Ev();
extern void _ZN6S585C33v92Ev();
extern void _ZN6S585C33v93Ev();
extern void _ZN6S585C33v94Ev();
extern void _ZN6S585C33v95Ev();
extern void _ZN6S585C33v96Ev();
extern void _ZN6S585C33v97Ev();
extern void _ZN6S585C33v98Ev();
extern void _ZN6S585C33v99Ev();
extern void _ZN6S585C34v100Ev();
extern void _ZN6S585C34v101Ev();
extern void _ZN6S585C34v102Ev();
extern void _ZN6S585C34v103Ev();
extern void _ZN6S585C34v104Ev();
extern void _ZN6S585C34v105Ev();
extern void _ZN6S585C34v106Ev();
extern void _ZN6S585C34v107Ev();
extern void _ZN6S585C34v108Ev();
extern void _ZN6S585C34v109Ev();
extern void _ZN6S585C24v110Ev();
extern void _ZN6S585C24v111Ev();
extern void _ZN6S585C24v112Ev();
extern void _ZN6S585C24v113Ev();
extern void _ZN6S585C12v1Ev();
extern void _ZN6S585C12v2Ev();
extern void _ZN6S585C12v3Ev();
static  VTBL_ENTRY vtc_S585C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S585C1[0]),
  (VTBL_ENTRY)&_ZN6S585C1D1Ev,
  (VTBL_ENTRY)&_ZN6S585C1D0Ev,
  (VTBL_ENTRY)&_ZN6S585C52v4Ev,
  (VTBL_ENTRY)&_ZN6S585C52v5Ev,
  (VTBL_ENTRY)&_ZN6S585C52v6Ev,
  (VTBL_ENTRY)&_ZN6S585C52v7Ev,
  (VTBL_ENTRY)&_ZN6S585C52v8Ev,
  (VTBL_ENTRY)&_ZN6S585C52v9Ev,
  (VTBL_ENTRY)&_ZN6S585C53v10Ev,
  (VTBL_ENTRY)&_ZN6S585C53v11Ev,
  (VTBL_ENTRY)&_ZN6S585C53v12Ev,
  (VTBL_ENTRY)&_ZN6S585C53v13Ev,
  (VTBL_ENTRY)&_ZN6S585C53v14Ev,
  (VTBL_ENTRY)&_ZN6S585C53v15Ev,
  (VTBL_ENTRY)&_ZN6S585C53v16Ev,
  (VTBL_ENTRY)&_ZN6S585C53v17Ev,
  (VTBL_ENTRY)&_ZN6S585C53v18Ev,
  (VTBL_ENTRY)&_ZN6S585C53v19Ev,
  (VTBL_ENTRY)&_ZN6S585C53v20Ev,
  (VTBL_ENTRY)&_ZN6S585C53v21Ev,
  (VTBL_ENTRY)&_ZN6S585C53v22Ev,
  (VTBL_ENTRY)&_ZN6S585C53v23Ev,
  (VTBL_ENTRY)&_ZN6S585C53v24Ev,
  (VTBL_ENTRY)&_ZN6S585C53v25Ev,
  (VTBL_ENTRY)&_ZN6S585C53v26Ev,
  (VTBL_ENTRY)&_ZN6S585C53v27Ev,
  (VTBL_ENTRY)&_ZN6S585C53v28Ev,
  (VTBL_ENTRY)&_ZN6S585C53v29Ev,
  (VTBL_ENTRY)&_ZN6S585C53v30Ev,
  (VTBL_ENTRY)&_ZN6S585C53v31Ev,
  (VTBL_ENTRY)&_ZN6S585C53v32Ev,
  (VTBL_ENTRY)&_ZN6S585C53v33Ev,
  (VTBL_ENTRY)&_ZN6S585C53v34Ev,
  (VTBL_ENTRY)&_ZN6S585C53v35Ev,
  (VTBL_ENTRY)&_ZN6S585C53v36Ev,
  (VTBL_ENTRY)&_ZN6S585C53v37Ev,
  (VTBL_ENTRY)&_ZN6S585C53v38Ev,
  (VTBL_ENTRY)&_ZN6S585C53v39Ev,
  (VTBL_ENTRY)&_ZN6S585C53v40Ev,
  (VTBL_ENTRY)&_ZN6S585C53v41Ev,
  (VTBL_ENTRY)&_ZN6S585C53v42Ev,
  (VTBL_ENTRY)&_ZN6S585C53v43Ev,
  (VTBL_ENTRY)&_ZN6S585C53v44Ev,
  (VTBL_ENTRY)&_ZN6S585C53v45Ev,
  (VTBL_ENTRY)&_ZN6S585C53v46Ev,
  (VTBL_ENTRY)&_ZN6S585C53v47Ev,
  (VTBL_ENTRY)&_ZN6S585C53v48Ev,
  (VTBL_ENTRY)&_ZN6S585C53v49Ev,
  (VTBL_ENTRY)&_ZN6S585C53v50Ev,
  (VTBL_ENTRY)&_ZN6S585C53v51Ev,
  (VTBL_ENTRY)&_ZN6S585C53v52Ev,
  (VTBL_ENTRY)&_ZN6S585C53v53Ev,
  (VTBL_ENTRY)&_ZN6S585C53v54Ev,
  (VTBL_ENTRY)&_ZN6S585C53v55Ev,
  (VTBL_ENTRY)&_ZN6S585C53v56Ev,
  (VTBL_ENTRY)&_ZN6S585C53v57Ev,
  (VTBL_ENTRY)&_ZN6S585C53v58Ev,
  (VTBL_ENTRY)&_ZN6S585C53v59Ev,
  (VTBL_ENTRY)&_ZN6S585C53v60Ev,
  (VTBL_ENTRY)&_ZN6S585C53v61Ev,
  (VTBL_ENTRY)&_ZN6S585C53v62Ev,
  (VTBL_ENTRY)&_ZN6S585C53v63Ev,
  (VTBL_ENTRY)&_ZN6S585C53v64Ev,
  (VTBL_ENTRY)&_ZN6S585C53v65Ev,
  (VTBL_ENTRY)&_ZN6S585C53v66Ev,
  (VTBL_ENTRY)&_ZN6S585C53v67Ev,
  (VTBL_ENTRY)&_ZN6S585C43v68Ev,
  (VTBL_ENTRY)&_ZN6S585C43v69Ev,
  (VTBL_ENTRY)&_ZN6S585C43v70Ev,
  (VTBL_ENTRY)&_ZN6S585C43v71Ev,
  (VTBL_ENTRY)&_ZN6S585C43v72Ev,
  (VTBL_ENTRY)&_ZN6S585C43v73Ev,
  (VTBL_ENTRY)&_ZN6S585C43v74Ev,
  (VTBL_ENTRY)&_ZN6S585C43v75Ev,
  (VTBL_ENTRY)&_ZN6S585C43v76Ev,
  (VTBL_ENTRY)&_ZN6S585C43v77Ev,
  (VTBL_ENTRY)&_ZN6S585C43v78Ev,
  (VTBL_ENTRY)&_ZN6S585C43v79Ev,
  (VTBL_ENTRY)&_ZN6S585C43v80Ev,
  (VTBL_ENTRY)&_ZN6S585C43v81Ev,
  (VTBL_ENTRY)&_ZN6S585C43v82Ev,
  (VTBL_ENTRY)&_ZN6S585C43v83Ev,
  (VTBL_ENTRY)&_ZN6S585C43v84Ev,
  (VTBL_ENTRY)&_ZN6S585C43v85Ev,
  (VTBL_ENTRY)&_ZN6S585C43v86Ev,
  (VTBL_ENTRY)&_ZN6S585C43v87Ev,
  (VTBL_ENTRY)&_ZN6S585C43v88Ev,
  (VTBL_ENTRY)&_ZN6S585C43v89Ev,
  (VTBL_ENTRY)&_ZN6S585C33v90Ev,
  (VTBL_ENTRY)&_ZN6S585C33v91Ev,
  (VTBL_ENTRY)&_ZN6S585C33v92Ev,
  (VTBL_ENTRY)&_ZN6S585C33v93Ev,
  (VTBL_ENTRY)&_ZN6S585C33v94Ev,
  (VTBL_ENTRY)&_ZN6S585C33v95Ev,
  (VTBL_ENTRY)&_ZN6S585C33v96Ev,
  (VTBL_ENTRY)&_ZN6S585C33v97Ev,
  (VTBL_ENTRY)&_ZN6S585C33v98Ev,
  (VTBL_ENTRY)&_ZN6S585C33v99Ev,
  (VTBL_ENTRY)&_ZN6S585C34v100Ev,
  (VTBL_ENTRY)&_ZN6S585C34v101Ev,
  (VTBL_ENTRY)&_ZN6S585C34v102Ev,
  (VTBL_ENTRY)&_ZN6S585C34v103Ev,
  (VTBL_ENTRY)&_ZN6S585C34v104Ev,
  (VTBL_ENTRY)&_ZN6S585C34v105Ev,
  (VTBL_ENTRY)&_ZN6S585C34v106Ev,
  (VTBL_ENTRY)&_ZN6S585C34v107Ev,
  (VTBL_ENTRY)&_ZN6S585C34v108Ev,
  (VTBL_ENTRY)&_ZN6S585C34v109Ev,
  (VTBL_ENTRY)&_ZN6S585C24v110Ev,
  (VTBL_ENTRY)&_ZN6S585C24v111Ev,
  (VTBL_ENTRY)&_ZN6S585C24v112Ev,
  (VTBL_ENTRY)&_ZN6S585C24v113Ev,
  (VTBL_ENTRY)&_ZN6S585C12v1Ev,
  (VTBL_ENTRY)&_ZN6S585C12v2Ev,
  (VTBL_ENTRY)&_ZN6S585C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S585C1[];
extern  VTBL_ENTRY _ZTV6S585C1[];
Class_Descriptor cd_S585C1 = {  "S585C1", // class name
  bases_S585C1, 4,
  &(vtc_S585C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,244), // object size
  NSPAIRA(_ZTI6S585C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S585C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S616C5  {
  int s616c5f0;
  __tsi64 s616c5f1;
  void *s616c5f2[4];
  int s616c5f3[2];
  void *s616c5f4;
  ::S27C9_nt s616c5f5;
  void *s616c5f6[2];
  virtual  ~S616C5(); // _ZN6S616C5D1Ev
  virtual void  v5(); // _ZN6S616C52v5Ev
  virtual void  v6(); // _ZN6S616C52v6Ev
  virtual void  v7(); // _ZN6S616C52v7Ev
  virtual void  v8(); // _ZN6S616C52v8Ev
  virtual void  v9(); // _ZN6S616C52v9Ev
  virtual void  v10(); // _ZN6S616C53v10Ev
  virtual void  v11(); // _ZN6S616C53v11Ev
  virtual void  v12(); // _ZN6S616C53v12Ev
  virtual void  v13(); // _ZN6S616C53v13Ev
  virtual void  v14(); // _ZN6S616C53v14Ev
  virtual void  v15(); // _ZN6S616C53v15Ev
  virtual void  v16(); // _ZN6S616C53v16Ev
  virtual void  v17(); // _ZN6S616C53v17Ev
  virtual void  v18(); // _ZN6S616C53v18Ev
  virtual void  v19(); // _ZN6S616C53v19Ev
  virtual void  v20(); // _ZN6S616C53v20Ev
  virtual void  v21(); // _ZN6S616C53v21Ev
  virtual void  v22(); // _ZN6S616C53v22Ev
  virtual void  v23(); // _ZN6S616C53v23Ev
  virtual void  v24(); // _ZN6S616C53v24Ev
  virtual void  v25(); // _ZN6S616C53v25Ev
  virtual void  v26(); // _ZN6S616C53v26Ev
  virtual void  v27(); // _ZN6S616C53v27Ev
  virtual void  v28(); // _ZN6S616C53v28Ev
  virtual void  v29(); // _ZN6S616C53v29Ev
  virtual void  v30(); // _ZN6S616C53v30Ev
  virtual void  v31(); // _ZN6S616C53v31Ev
  virtual void  v32(); // _ZN6S616C53v32Ev
  virtual void  v33(); // _ZN6S616C53v33Ev
  virtual void  v34(); // _ZN6S616C53v34Ev
  virtual void  v35(); // _ZN6S616C53v35Ev
  virtual void  v36(); // _ZN6S616C53v36Ev
  virtual void  v37(); // _ZN6S616C53v37Ev
  virtual void  v38(); // _ZN6S616C53v38Ev
  virtual void  v39(); // _ZN6S616C53v39Ev
  virtual void  v40(); // _ZN6S616C53v40Ev
  virtual void  v41(); // _ZN6S616C53v41Ev
  virtual void  v42(); // _ZN6S616C53v42Ev
  virtual void  v43(); // _ZN6S616C53v43Ev
  virtual void  v44(); // _ZN6S616C53v44Ev
  virtual void  v45(); // _ZN6S616C53v45Ev
  virtual void  v46(); // _ZN6S616C53v46Ev
  virtual void  v47(); // _ZN6S616C53v47Ev
  virtual void  v48(); // _ZN6S616C53v48Ev
  virtual void  v49(); // _ZN6S616C53v49Ev
  virtual void  v50(); // _ZN6S616C53v50Ev
  virtual void  v51(); // _ZN6S616C53v51Ev
  virtual void  v52(); // _ZN6S616C53v52Ev
  virtual void  v53(); // _ZN6S616C53v53Ev
  virtual void  v54(); // _ZN6S616C53v54Ev
  virtual void  v55(); // _ZN6S616C53v55Ev
  virtual void  v56(); // _ZN6S616C53v56Ev
  virtual void  v57(); // _ZN6S616C53v57Ev
  virtual void  v58(); // _ZN6S616C53v58Ev
  virtual void  v59(); // _ZN6S616C53v59Ev
  virtual void  v60(); // _ZN6S616C53v60Ev
  virtual void  v61(); // _ZN6S616C53v61Ev
  virtual void  v62(); // _ZN6S616C53v62Ev
  virtual void  v63(); // _ZN6S616C53v63Ev
  virtual void  v64(); // _ZN6S616C53v64Ev
  virtual void  v65(); // _ZN6S616C53v65Ev
  virtual void  v66(); // _ZN6S616C53v66Ev
  virtual void  v67(); // _ZN6S616C53v67Ev
  virtual void  v68(); // _ZN6S616C53v68Ev
  S616C5(); // tgen
};
//SIG(-1 S616C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S616C5 ::~S616C5(){ note_dtor("S616C5", this);}
void  S616C5 ::v5(){vfunc_called(this, "_ZN6S616C52v5Ev");}
void  S616C5 ::v6(){vfunc_called(this, "_ZN6S616C52v6Ev");}
void  S616C5 ::v7(){vfunc_called(this, "_ZN6S616C52v7Ev");}
void  S616C5 ::v8(){vfunc_called(this, "_ZN6S616C52v8Ev");}
void  S616C5 ::v9(){vfunc_called(this, "_ZN6S616C52v9Ev");}
void  S616C5 ::v10(){vfunc_called(this, "_ZN6S616C53v10Ev");}
void  S616C5 ::v11(){vfunc_called(this, "_ZN6S616C53v11Ev");}
void  S616C5 ::v12(){vfunc_called(this, "_ZN6S616C53v12Ev");}
void  S616C5 ::v13(){vfunc_called(this, "_ZN6S616C53v13Ev");}
void  S616C5 ::v14(){vfunc_called(this, "_ZN6S616C53v14Ev");}
void  S616C5 ::v15(){vfunc_called(this, "_ZN6S616C53v15Ev");}
void  S616C5 ::v16(){vfunc_called(this, "_ZN6S616C53v16Ev");}
void  S616C5 ::v17(){vfunc_called(this, "_ZN6S616C53v17Ev");}
void  S616C5 ::v18(){vfunc_called(this, "_ZN6S616C53v18Ev");}
void  S616C5 ::v19(){vfunc_called(this, "_ZN6S616C53v19Ev");}
void  S616C5 ::v20(){vfunc_called(this, "_ZN6S616C53v20Ev");}
void  S616C5 ::v21(){vfunc_called(this, "_ZN6S616C53v21Ev");}
void  S616C5 ::v22(){vfunc_called(this, "_ZN6S616C53v22Ev");}
void  S616C5 ::v23(){vfunc_called(this, "_ZN6S616C53v23Ev");}
void  S616C5 ::v24(){vfunc_called(this, "_ZN6S616C53v24Ev");}
void  S616C5 ::v25(){vfunc_called(this, "_ZN6S616C53v25Ev");}
void  S616C5 ::v26(){vfunc_called(this, "_ZN6S616C53v26Ev");}
void  S616C5 ::v27(){vfunc_called(this, "_ZN6S616C53v27Ev");}
void  S616C5 ::v28(){vfunc_called(this, "_ZN6S616C53v28Ev");}
void  S616C5 ::v29(){vfunc_called(this, "_ZN6S616C53v29Ev");}
void  S616C5 ::v30(){vfunc_called(this, "_ZN6S616C53v30Ev");}
void  S616C5 ::v31(){vfunc_called(this, "_ZN6S616C53v31Ev");}
void  S616C5 ::v32(){vfunc_called(this, "_ZN6S616C53v32Ev");}
void  S616C5 ::v33(){vfunc_called(this, "_ZN6S616C53v33Ev");}
void  S616C5 ::v34(){vfunc_called(this, "_ZN6S616C53v34Ev");}
void  S616C5 ::v35(){vfunc_called(this, "_ZN6S616C53v35Ev");}
void  S616C5 ::v36(){vfunc_called(this, "_ZN6S616C53v36Ev");}
void  S616C5 ::v37(){vfunc_called(this, "_ZN6S616C53v37Ev");}
void  S616C5 ::v38(){vfunc_called(this, "_ZN6S616C53v38Ev");}
void  S616C5 ::v39(){vfunc_called(this, "_ZN6S616C53v39Ev");}
void  S616C5 ::v40(){vfunc_called(this, "_ZN6S616C53v40Ev");}
void  S616C5 ::v41(){vfunc_called(this, "_ZN6S616C53v41Ev");}
void  S616C5 ::v42(){vfunc_called(this, "_ZN6S616C53v42Ev");}
void  S616C5 ::v43(){vfunc_called(this, "_ZN6S616C53v43Ev");}
void  S616C5 ::v44(){vfunc_called(this, "_ZN6S616C53v44Ev");}
void  S616C5 ::v45(){vfunc_called(this, "_ZN6S616C53v45Ev");}
void  S616C5 ::v46(){vfunc_called(this, "_ZN6S616C53v46Ev");}
void  S616C5 ::v47(){vfunc_called(this, "_ZN6S616C53v47Ev");}
void  S616C5 ::v48(){vfunc_called(this, "_ZN6S616C53v48Ev");}
void  S616C5 ::v49(){vfunc_called(this, "_ZN6S616C53v49Ev");}
void  S616C5 ::v50(){vfunc_called(this, "_ZN6S616C53v50Ev");}
void  S616C5 ::v51(){vfunc_called(this, "_ZN6S616C53v51Ev");}
void  S616C5 ::v52(){vfunc_called(this, "_ZN6S616C53v52Ev");}
void  S616C5 ::v53(){vfunc_called(this, "_ZN6S616C53v53Ev");}
void  S616C5 ::v54(){vfunc_called(this, "_ZN6S616C53v54Ev");}
void  S616C5 ::v55(){vfunc_called(this, "_ZN6S616C53v55Ev");}
void  S616C5 ::v56(){vfunc_called(this, "_ZN6S616C53v56Ev");}
void  S616C5 ::v57(){vfunc_called(this, "_ZN6S616C53v57Ev");}
void  S616C5 ::v58(){vfunc_called(this, "_ZN6S616C53v58Ev");}
void  S616C5 ::v59(){vfunc_called(this, "_ZN6S616C53v59Ev");}
void  S616C5 ::v60(){vfunc_called(this, "_ZN6S616C53v60Ev");}
void  S616C5 ::v61(){vfunc_called(this, "_ZN6S616C53v61Ev");}
void  S616C5 ::v62(){vfunc_called(this, "_ZN6S616C53v62Ev");}
void  S616C5 ::v63(){vfunc_called(this, "_ZN6S616C53v63Ev");}
void  S616C5 ::v64(){vfunc_called(this, "_ZN6S616C53v64Ev");}
void  S616C5 ::v65(){vfunc_called(this, "_ZN6S616C53v65Ev");}
void  S616C5 ::v66(){vfunc_called(this, "_ZN6S616C53v66Ev");}
void  S616C5 ::v67(){vfunc_called(this, "_ZN6S616C53v67Ev");}
void  S616C5 ::v68(){vfunc_called(this, "_ZN6S616C53v68Ev");}
S616C5 ::S616C5(){ note_ctor("S616C5", this);} // tgen

static void Test_S616C5()
{
  extern Class_Descriptor cd_S616C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S616C5, buf);
    S616C5 *dp, &lv = *(dp=new (buf) S616C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S616C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S616C5)");
    check_field_offset(lv, s616c5f0, ABISELECT(8,4), "S616C5.s616c5f0");
    check_field_offset(lv, s616c5f1, ABISELECT(16,8), "S616C5.s616c5f1");
    check_field_offset(lv, s616c5f2, ABISELECT(24,16), "S616C5.s616c5f2");
    check_field_offset(lv, s616c5f3, ABISELECT(56,32), "S616C5.s616c5f3");
    check_field_offset(lv, s616c5f4, ABISELECT(64,40), "S616C5.s616c5f4");
    check_field_offset(lv, s616c5f5, ABISELECT(72,44), "S616C5.s616c5f5");
    check_field_offset(lv, s616c5f6, ABISELECT(80,52), "S616C5.s616c5f6");
    test_class_info(&lv, &cd_S616C5);
    dp->~S616C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS616C5(Test_S616C5, "S616C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S616C5C1Ev();
extern void _ZN6S616C5D1Ev();
Name_Map name_map_S616C5[] = {
  NSPAIR(_ZN6S616C5C1Ev),
  NSPAIR(_ZN6S616C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S616C5[];
extern void _ZN6S616C5D1Ev();
extern void _ZN6S616C5D0Ev();
extern void _ZN6S616C52v5Ev();
extern void _ZN6S616C52v6Ev();
extern void _ZN6S616C52v7Ev();
extern void _ZN6S616C52v8Ev();
extern void _ZN6S616C52v9Ev();
extern void _ZN6S616C53v10Ev();
extern void _ZN6S616C53v11Ev();
extern void _ZN6S616C53v12Ev();
extern void _ZN6S616C53v13Ev();
extern void _ZN6S616C53v14Ev();
extern void _ZN6S616C53v15Ev();
extern void _ZN6S616C53v16Ev();
extern void _ZN6S616C53v17Ev();
extern void _ZN6S616C53v18Ev();
extern void _ZN6S616C53v19Ev();
extern void _ZN6S616C53v20Ev();
extern void _ZN6S616C53v21Ev();
extern void _ZN6S616C53v22Ev();
extern void _ZN6S616C53v23Ev();
extern void _ZN6S616C53v24Ev();
extern void _ZN6S616C53v25Ev();
extern void _ZN6S616C53v26Ev();
extern void _ZN6S616C53v27Ev();
extern void _ZN6S616C53v28Ev();
extern void _ZN6S616C53v29Ev();
extern void _ZN6S616C53v30Ev();
extern void _ZN6S616C53v31Ev();
extern void _ZN6S616C53v32Ev();
extern void _ZN6S616C53v33Ev();
extern void _ZN6S616C53v34Ev();
extern void _ZN6S616C53v35Ev();
extern void _ZN6S616C53v36Ev();
extern void _ZN6S616C53v37Ev();
extern void _ZN6S616C53v38Ev();
extern void _ZN6S616C53v39Ev();
extern void _ZN6S616C53v40Ev();
extern void _ZN6S616C53v41Ev();
extern void _ZN6S616C53v42Ev();
extern void _ZN6S616C53v43Ev();
extern void _ZN6S616C53v44Ev();
extern void _ZN6S616C53v45Ev();
extern void _ZN6S616C53v46Ev();
extern void _ZN6S616C53v47Ev();
extern void _ZN6S616C53v48Ev();
extern void _ZN6S616C53v49Ev();
extern void _ZN6S616C53v50Ev();
extern void _ZN6S616C53v51Ev();
extern void _ZN6S616C53v52Ev();
extern void _ZN6S616C53v53Ev();
extern void _ZN6S616C53v54Ev();
extern void _ZN6S616C53v55Ev();
extern void _ZN6S616C53v56Ev();
extern void _ZN6S616C53v57Ev();
extern void _ZN6S616C53v58Ev();
extern void _ZN6S616C53v59Ev();
extern void _ZN6S616C53v60Ev();
extern void _ZN6S616C53v61Ev();
extern void _ZN6S616C53v62Ev();
extern void _ZN6S616C53v63Ev();
extern void _ZN6S616C53v64Ev();
extern void _ZN6S616C53v65Ev();
extern void _ZN6S616C53v66Ev();
extern void _ZN6S616C53v67Ev();
extern void _ZN6S616C53v68Ev();
static  VTBL_ENTRY vtc_S616C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S616C5[0]),
  (VTBL_ENTRY)&_ZN6S616C5D1Ev,
  (VTBL_ENTRY)&_ZN6S616C5D0Ev,
  (VTBL_ENTRY)&_ZN6S616C52v5Ev,
  (VTBL_ENTRY)&_ZN6S616C52v6Ev,
  (VTBL_ENTRY)&_ZN6S616C52v7Ev,
  (VTBL_ENTRY)&_ZN6S616C52v8Ev,
  (VTBL_ENTRY)&_ZN6S616C52v9Ev,
  (VTBL_ENTRY)&_ZN6S616C53v10Ev,
  (VTBL_ENTRY)&_ZN6S616C53v11Ev,
  (VTBL_ENTRY)&_ZN6S616C53v12Ev,
  (VTBL_ENTRY)&_ZN6S616C53v13Ev,
  (VTBL_ENTRY)&_ZN6S616C53v14Ev,
  (VTBL_ENTRY)&_ZN6S616C53v15Ev,
  (VTBL_ENTRY)&_ZN6S616C53v16Ev,
  (VTBL_ENTRY)&_ZN6S616C53v17Ev,
  (VTBL_ENTRY)&_ZN6S616C53v18Ev,
  (VTBL_ENTRY)&_ZN6S616C53v19Ev,
  (VTBL_ENTRY)&_ZN6S616C53v20Ev,
  (VTBL_ENTRY)&_ZN6S616C53v21Ev,
  (VTBL_ENTRY)&_ZN6S616C53v22Ev,
  (VTBL_ENTRY)&_ZN6S616C53v23Ev,
  (VTBL_ENTRY)&_ZN6S616C53v24Ev,
  (VTBL_ENTRY)&_ZN6S616C53v25Ev,
  (VTBL_ENTRY)&_ZN6S616C53v26Ev,
  (VTBL_ENTRY)&_ZN6S616C53v27Ev,
  (VTBL_ENTRY)&_ZN6S616C53v28Ev,
  (VTBL_ENTRY)&_ZN6S616C53v29Ev,
  (VTBL_ENTRY)&_ZN6S616C53v30Ev,
  (VTBL_ENTRY)&_ZN6S616C53v31Ev,
  (VTBL_ENTRY)&_ZN6S616C53v32Ev,
  (VTBL_ENTRY)&_ZN6S616C53v33Ev,
  (VTBL_ENTRY)&_ZN6S616C53v34Ev,
  (VTBL_ENTRY)&_ZN6S616C53v35Ev,
  (VTBL_ENTRY)&_ZN6S616C53v36Ev,
  (VTBL_ENTRY)&_ZN6S616C53v37Ev,
  (VTBL_ENTRY)&_ZN6S616C53v38Ev,
  (VTBL_ENTRY)&_ZN6S616C53v39Ev,
  (VTBL_ENTRY)&_ZN6S616C53v40Ev,
  (VTBL_ENTRY)&_ZN6S616C53v41Ev,
  (VTBL_ENTRY)&_ZN6S616C53v42Ev,
  (VTBL_ENTRY)&_ZN6S616C53v43Ev,
  (VTBL_ENTRY)&_ZN6S616C53v44Ev,
  (VTBL_ENTRY)&_ZN6S616C53v45Ev,
  (VTBL_ENTRY)&_ZN6S616C53v46Ev,
  (VTBL_ENTRY)&_ZN6S616C53v47Ev,
  (VTBL_ENTRY)&_ZN6S616C53v48Ev,
  (VTBL_ENTRY)&_ZN6S616C53v49Ev,
  (VTBL_ENTRY)&_ZN6S616C53v50Ev,
  (VTBL_ENTRY)&_ZN6S616C53v51Ev,
  (VTBL_ENTRY)&_ZN6S616C53v52Ev,
  (VTBL_ENTRY)&_ZN6S616C53v53Ev,
  (VTBL_ENTRY)&_ZN6S616C53v54Ev,
  (VTBL_ENTRY)&_ZN6S616C53v55Ev,
  (VTBL_ENTRY)&_ZN6S616C53v56Ev,
  (VTBL_ENTRY)&_ZN6S616C53v57Ev,
  (VTBL_ENTRY)&_ZN6S616C53v58Ev,
  (VTBL_ENTRY)&_ZN6S616C53v59Ev,
  (VTBL_ENTRY)&_ZN6S616C53v60Ev,
  (VTBL_ENTRY)&_ZN6S616C53v61Ev,
  (VTBL_ENTRY)&_ZN6S616C53v62Ev,
  (VTBL_ENTRY)&_ZN6S616C53v63Ev,
  (VTBL_ENTRY)&_ZN6S616C53v64Ev,
  (VTBL_ENTRY)&_ZN6S616C53v65Ev,
  (VTBL_ENTRY)&_ZN6S616C53v66Ev,
  (VTBL_ENTRY)&_ZN6S616C53v67Ev,
  (VTBL_ENTRY)&_ZN6S616C53v68Ev,
};
extern VTBL_ENTRY _ZTI6S616C5[];
extern  VTBL_ENTRY _ZTV6S616C5[];
Class_Descriptor cd_S616C5 = {  "S616C5", // class name
  0,0,//no base classes
  &(vtc_S616C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S616C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S616C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S616C12_nt  {
  ::S27C35_nt s616c12f0;
  ::S27C18_nt s616c12f1;
  int s616c12f2;
  void  mf616c12(); // _ZN10S616C12_nt8mf616c12Ev
};
//SIG(-1 S616C12_nt) C1{ m FC2{ m Fi[4]} FC3{ m Fi[3]} Fi}


void  S616C12_nt ::mf616c12(){}

//skip512 S616C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S616C4_nt  : S616C5 {
  void *s616c4f0;
  ::S27C80 s616c4f1;
  ::S27C9_nt s616c4f2;
  ::S27C76 s616c4f3;
  ::S616C12_nt s616c4f4;
  int s616c4f5;
  unsigned int s616c4f6:1;
  unsigned int s616c4f7:1;
  unsigned int s616c4f8:1;
  unsigned int s616c4f9:1;
  int s616c4f10[11];
  virtual  ~S616C4_nt(); // _ZN9S616C4_ntD1Ev
  virtual void  v69(); // _ZN9S616C4_nt3v69Ev
  virtual void  v70(); // _ZN9S616C4_nt3v70Ev
  virtual void  v71(); // _ZN9S616C4_nt3v71Ev
  virtual void  v72(); // _ZN9S616C4_nt3v72Ev
  virtual void  v73(); // _ZN9S616C4_nt3v73Ev
  virtual void  v74(); // _ZN9S616C4_nt3v74Ev
  virtual void  v75(); // _ZN9S616C4_nt3v75Ev
  virtual void  v76(); // _ZN9S616C4_nt3v76Ev
  virtual void  v77(); // _ZN9S616C4_nt3v77Ev
  virtual void  v78(); // _ZN9S616C4_nt3v78Ev
  virtual void  v79(); // _ZN9S616C4_nt3v79Ev
  virtual void  v80(); // _ZN9S616C4_nt3v80Ev
  virtual void  v81(); // _ZN9S616C4_nt3v81Ev
  virtual void  v82(); // _ZN9S616C4_nt3v82Ev
  virtual void  v83(); // _ZN9S616C4_nt3v83Ev
  virtual void  v84(); // _ZN9S616C4_nt3v84Ev
  virtual void  v85(); // _ZN9S616C4_nt3v85Ev
  virtual void  v86(); // _ZN9S616C4_nt3v86Ev
  virtual void  v87(); // _ZN9S616C4_nt3v87Ev
  virtual void  v88(); // _ZN9S616C4_nt3v88Ev
  virtual void  v89(); // _ZN9S616C4_nt3v89Ev
  virtual void  v90(); // _ZN9S616C4_nt3v90Ev
  virtual void  v91(); // _ZN9S616C4_nt3v91Ev
  virtual void  v92(); // _ZN9S616C4_nt3v92Ev
  virtual void  v93(); // _ZN9S616C4_nt3v93Ev
  virtual void  v94(); // _ZN9S616C4_nt3v94Ev
  virtual void  v95(); // _ZN9S616C4_nt3v95Ev
  S616C4_nt(); // tgen
};
//SIG(-1 S616C4_nt) C1{ BC2{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC3 FC7{ BC8{ BC6}} FC9{ m FC10{ m Fi[4]} FC11{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]}


 S616C4_nt ::~S616C4_nt(){ note_dtor("S616C4_nt", this);}
void  S616C4_nt ::v69(){vfunc_called(this, "_ZN9S616C4_nt3v69Ev");}
void  S616C4_nt ::v70(){vfunc_called(this, "_ZN9S616C4_nt3v70Ev");}
void  S616C4_nt ::v71(){vfunc_called(this, "_ZN9S616C4_nt3v71Ev");}
void  S616C4_nt ::v72(){vfunc_called(this, "_ZN9S616C4_nt3v72Ev");}
void  S616C4_nt ::v73(){vfunc_called(this, "_ZN9S616C4_nt3v73Ev");}
void  S616C4_nt ::v74(){vfunc_called(this, "_ZN9S616C4_nt3v74Ev");}
void  S616C4_nt ::v75(){vfunc_called(this, "_ZN9S616C4_nt3v75Ev");}
void  S616C4_nt ::v76(){vfunc_called(this, "_ZN9S616C4_nt3v76Ev");}
void  S616C4_nt ::v77(){vfunc_called(this, "_ZN9S616C4_nt3v77Ev");}
void  S616C4_nt ::v78(){vfunc_called(this, "_ZN9S616C4_nt3v78Ev");}
void  S616C4_nt ::v79(){vfunc_called(this, "_ZN9S616C4_nt3v79Ev");}
void  S616C4_nt ::v80(){vfunc_called(this, "_ZN9S616C4_nt3v80Ev");}
void  S616C4_nt ::v81(){vfunc_called(this, "_ZN9S616C4_nt3v81Ev");}
void  S616C4_nt ::v82(){vfunc_called(this, "_ZN9S616C4_nt3v82Ev");}
void  S616C4_nt ::v83(){vfunc_called(this, "_ZN9S616C4_nt3v83Ev");}
void  S616C4_nt ::v84(){vfunc_called(this, "_ZN9S616C4_nt3v84Ev");}
void  S616C4_nt ::v85(){vfunc_called(this, "_ZN9S616C4_nt3v85Ev");}
void  S616C4_nt ::v86(){vfunc_called(this, "_ZN9S616C4_nt3v86Ev");}
void  S616C4_nt ::v87(){vfunc_called(this, "_ZN9S616C4_nt3v87Ev");}
void  S616C4_nt ::v88(){vfunc_called(this, "_ZN9S616C4_nt3v88Ev");}
void  S616C4_nt ::v89(){vfunc_called(this, "_ZN9S616C4_nt3v89Ev");}
void  S616C4_nt ::v90(){vfunc_called(this, "_ZN9S616C4_nt3v90Ev");}
void  S616C4_nt ::v91(){vfunc_called(this, "_ZN9S616C4_nt3v91Ev");}
void  S616C4_nt ::v92(){vfunc_called(this, "_ZN9S616C4_nt3v92Ev");}
void  S616C4_nt ::v93(){vfunc_called(this, "_ZN9S616C4_nt3v93Ev");}
void  S616C4_nt ::v94(){vfunc_called(this, "_ZN9S616C4_nt3v94Ev");}
void  S616C4_nt ::v95(){vfunc_called(this, "_ZN9S616C4_nt3v95Ev");}
S616C4_nt ::S616C4_nt(){ note_ctor("S616C4_nt", this);} // tgen

//skip512 S616C4_nt

#else // __cplusplus

extern void _ZN9S616C4_ntC1Ev();
extern void _ZN9S616C4_ntD1Ev();
Name_Map name_map_S616C4_nt[] = {
  NSPAIR(_ZN9S616C4_ntC1Ev),
  NSPAIR(_ZN9S616C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S616C5;
extern VTBL_ENTRY _ZTI6S616C5[];
extern  VTBL_ENTRY _ZTV6S616C5[];
static Base_Class bases_S616C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S616C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S616C4_nt[];
extern void _ZN9S616C4_ntD1Ev();
extern void _ZN9S616C4_ntD0Ev();
extern void _ZN6S616C52v5Ev();
extern void _ZN6S616C52v6Ev();
extern void _ZN6S616C52v7Ev();
extern void _ZN6S616C52v8Ev();
extern void _ZN6S616C52v9Ev();
extern void _ZN6S616C53v10Ev();
extern void _ZN6S616C53v11Ev();
extern void _ZN6S616C53v12Ev();
extern void _ZN6S616C53v13Ev();
extern void _ZN6S616C53v14Ev();
extern void _ZN6S616C53v15Ev();
extern void _ZN6S616C53v16Ev();
extern void _ZN6S616C53v17Ev();
extern void _ZN6S616C53v18Ev();
extern void _ZN6S616C53v19Ev();
extern void _ZN6S616C53v20Ev();
extern void _ZN6S616C53v21Ev();
extern void _ZN6S616C53v22Ev();
extern void _ZN6S616C53v23Ev();
extern void _ZN6S616C53v24Ev();
extern void _ZN6S616C53v25Ev();
extern void _ZN6S616C53v26Ev();
extern void _ZN6S616C53v27Ev();
extern void _ZN6S616C53v28Ev();
extern void _ZN6S616C53v29Ev();
extern void _ZN6S616C53v30Ev();
extern void _ZN6S616C53v31Ev();
extern void _ZN6S616C53v32Ev();
extern void _ZN6S616C53v33Ev();
extern void _ZN6S616C53v34Ev();
extern void _ZN6S616C53v35Ev();
extern void _ZN6S616C53v36Ev();
extern void _ZN6S616C53v37Ev();
extern void _ZN6S616C53v38Ev();
extern void _ZN6S616C53v39Ev();
extern void _ZN6S616C53v40Ev();
extern void _ZN6S616C53v41Ev();
extern void _ZN6S616C53v42Ev();
extern void _ZN6S616C53v43Ev();
extern void _ZN6S616C53v44Ev();
extern void _ZN6S616C53v45Ev();
extern void _ZN6S616C53v46Ev();
extern void _ZN6S616C53v47Ev();
extern void _ZN6S616C53v48Ev();
extern void _ZN6S616C53v49Ev();
extern void _ZN6S616C53v50Ev();
extern void _ZN6S616C53v51Ev();
extern void _ZN6S616C53v52Ev();
extern void _ZN6S616C53v53Ev();
extern void _ZN6S616C53v54Ev();
extern void _ZN6S616C53v55Ev();
extern void _ZN6S616C53v56Ev();
extern void _ZN6S616C53v57Ev();
extern void _ZN6S616C53v58Ev();
extern void _ZN6S616C53v59Ev();
extern void _ZN6S616C53v60Ev();
extern void _ZN6S616C53v61Ev();
extern void _ZN6S616C53v62Ev();
extern void _ZN6S616C53v63Ev();
extern void _ZN6S616C53v64Ev();
extern void _ZN6S616C53v65Ev();
extern void _ZN6S616C53v66Ev();
extern void _ZN6S616C53v67Ev();
extern void _ZN6S616C53v68Ev();
extern void _ZN9S616C4_nt3v69Ev();
extern void _ZN9S616C4_nt3v70Ev();
extern void _ZN9S616C4_nt3v71Ev();
extern void _ZN9S616C4_nt3v72Ev();
extern void _ZN9S616C4_nt3v73Ev();
extern void _ZN9S616C4_nt3v74Ev();
extern void _ZN9S616C4_nt3v75Ev();
extern void _ZN9S616C4_nt3v76Ev();
extern void _ZN9S616C4_nt3v77Ev();
extern void _ZN9S616C4_nt3v78Ev();
extern void _ZN9S616C4_nt3v79Ev();
extern void _ZN9S616C4_nt3v80Ev();
extern void _ZN9S616C4_nt3v81Ev();
extern void _ZN9S616C4_nt3v82Ev();
extern void _ZN9S616C4_nt3v83Ev();
extern void _ZN9S616C4_nt3v84Ev();
extern void _ZN9S616C4_nt3v85Ev();
extern void _ZN9S616C4_nt3v86Ev();
extern void _ZN9S616C4_nt3v87Ev();
extern void _ZN9S616C4_nt3v88Ev();
extern void _ZN9S616C4_nt3v89Ev();
extern void _ZN9S616C4_nt3v90Ev();
extern void _ZN9S616C4_nt3v91Ev();
extern void _ZN9S616C4_nt3v92Ev();
extern void _ZN9S616C4_nt3v93Ev();
extern void _ZN9S616C4_nt3v94Ev();
extern void _ZN9S616C4_nt3v95Ev();
static  VTBL_ENTRY vtc_S616C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S616C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S616C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S616C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S616C52v5Ev,
  (VTBL_ENTRY)&_ZN6S616C52v6Ev,
  (VTBL_ENTRY)&_ZN6S616C52v7Ev,
  (VTBL_ENTRY)&_ZN6S616C52v8Ev,
  (VTBL_ENTRY)&_ZN6S616C52v9Ev,
  (VTBL_ENTRY)&_ZN6S616C53v10Ev,
  (VTBL_ENTRY)&_ZN6S616C53v11Ev,
  (VTBL_ENTRY)&_ZN6S616C53v12Ev,
  (VTBL_ENTRY)&_ZN6S616C53v13Ev,
  (VTBL_ENTRY)&_ZN6S616C53v14Ev,
  (VTBL_ENTRY)&_ZN6S616C53v15Ev,
  (VTBL_ENTRY)&_ZN6S616C53v16Ev,
  (VTBL_ENTRY)&_ZN6S616C53v17Ev,
  (VTBL_ENTRY)&_ZN6S616C53v18Ev,
  (VTBL_ENTRY)&_ZN6S616C53v19Ev,
  (VTBL_ENTRY)&_ZN6S616C53v20Ev,
  (VTBL_ENTRY)&_ZN6S616C53v21Ev,
  (VTBL_ENTRY)&_ZN6S616C53v22Ev,
  (VTBL_ENTRY)&_ZN6S616C53v23Ev,
  (VTBL_ENTRY)&_ZN6S616C53v24Ev,
  (VTBL_ENTRY)&_ZN6S616C53v25Ev,
  (VTBL_ENTRY)&_ZN6S616C53v26Ev,
  (VTBL_ENTRY)&_ZN6S616C53v27Ev,
  (VTBL_ENTRY)&_ZN6S616C53v28Ev,
  (VTBL_ENTRY)&_ZN6S616C53v29Ev,
  (VTBL_ENTRY)&_ZN6S616C53v30Ev,
  (VTBL_ENTRY)&_ZN6S616C53v31Ev,
  (VTBL_ENTRY)&_ZN6S616C53v32Ev,
  (VTBL_ENTRY)&_ZN6S616C53v33Ev,
  (VTBL_ENTRY)&_ZN6S616C53v34Ev,
  (VTBL_ENTRY)&_ZN6S616C53v35Ev,
  (VTBL_ENTRY)&_ZN6S616C53v36Ev,
  (VTBL_ENTRY)&_ZN6S616C53v37Ev,
  (VTBL_ENTRY)&_ZN6S616C53v38Ev,
  (VTBL_ENTRY)&_ZN6S616C53v39Ev,
  (VTBL_ENTRY)&_ZN6S616C53v40Ev,
  (VTBL_ENTRY)&_ZN6S616C53v41Ev,
  (VTBL_ENTRY)&_ZN6S616C53v42Ev,
  (VTBL_ENTRY)&_ZN6S616C53v43Ev,
  (VTBL_ENTRY)&_ZN6S616C53v44Ev,
  (VTBL_ENTRY)&_ZN6S616C53v45Ev,
  (VTBL_ENTRY)&_ZN6S616C53v46Ev,
  (VTBL_ENTRY)&_ZN6S616C53v47Ev,
  (VTBL_ENTRY)&_ZN6S616C53v48Ev,
  (VTBL_ENTRY)&_ZN6S616C53v49Ev,
  (VTBL_ENTRY)&_ZN6S616C53v50Ev,
  (VTBL_ENTRY)&_ZN6S616C53v51Ev,
  (VTBL_ENTRY)&_ZN6S616C53v52Ev,
  (VTBL_ENTRY)&_ZN6S616C53v53Ev,
  (VTBL_ENTRY)&_ZN6S616C53v54Ev,
  (VTBL_ENTRY)&_ZN6S616C53v55Ev,
  (VTBL_ENTRY)&_ZN6S616C53v56Ev,
  (VTBL_ENTRY)&_ZN6S616C53v57Ev,
  (VTBL_ENTRY)&_ZN6S616C53v58Ev,
  (VTBL_ENTRY)&_ZN6S616C53v59Ev,
  (VTBL_ENTRY)&_ZN6S616C53v60Ev,
  (VTBL_ENTRY)&_ZN6S616C53v61Ev,
  (VTBL_ENTRY)&_ZN6S616C53v62Ev,
  (VTBL_ENTRY)&_ZN6S616C53v63Ev,
  (VTBL_ENTRY)&_ZN6S616C53v64Ev,
  (VTBL_ENTRY)&_ZN6S616C53v65Ev,
  (VTBL_ENTRY)&_ZN6S616C53v66Ev,
  (VTBL_ENTRY)&_ZN6S616C53v67Ev,
  (VTBL_ENTRY)&_ZN6S616C53v68Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v95Ev,
};
extern VTBL_ENTRY _ZTI9S616C4_nt[];
VTBL_ENTRY *P__ZTI9S616C4_nt = _ZTI9S616C4_nt; 
extern  VTBL_ENTRY _ZTV9S616C4_nt[];
Class_Descriptor cd_S616C4_nt = {  "S616C4_nt", // class name
  bases_S616C4_nt, 1,
  &(vtc_S616C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,180), // object size
  NSPAIRA(_ZTI9S616C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S616C4_nt),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S616C3_nt  : S616C4_nt {
  ::S27C71 s616c3f0;
  unsigned int s616c3f1:1;
  virtual  ~S616C3_nt(); // _ZN9S616C3_ntD1Ev
  virtual void  v96(); // _ZN9S616C3_nt3v96Ev
  virtual void  v97(); // _ZN9S616C3_nt3v97Ev
  virtual void  v98(); // _ZN9S616C3_nt3v98Ev
  virtual void  v99(); // _ZN9S616C3_nt3v99Ev
  virtual void  v100(); // _ZN9S616C3_nt4v100Ev
  virtual void  v101(); // _ZN9S616C3_nt4v101Ev
  virtual void  v102(); // _ZN9S616C3_nt4v102Ev
  virtual void  v103(); // _ZN9S616C3_nt4v103Ev
  virtual void  v104(); // _ZN9S616C3_nt4v104Ev
  virtual void  v105(); // _ZN9S616C3_nt4v105Ev
  virtual void  v106(); // _ZN9S616C3_nt4v106Ev
  virtual void  v107(); // _ZN9S616C3_nt4v107Ev
  virtual void  v108(); // _ZN9S616C3_nt4v108Ev
  virtual void  v109(); // _ZN9S616C3_nt4v109Ev
  virtual void  v110(); // _ZN9S616C3_nt4v110Ev
  virtual void  v111(); // _ZN9S616C3_nt4v111Ev
  virtual void  v112(); // _ZN9S616C3_nt4v112Ev
  virtual void  v113(); // _ZN9S616C3_nt4v113Ev
  S616C3_nt(); // tgen
};
//SIG(-1 S616C3_nt) C1{ BC2{ BC3{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fp FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC4 FC8{ BC9{ BC7}} FC10{ m FC11{ m Fi[4]} FC12{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 FC13{ BC14{ BC7}} Fi:1}


 S616C3_nt ::~S616C3_nt(){ note_dtor("S616C3_nt", this);}
void  S616C3_nt ::v96(){vfunc_called(this, "_ZN9S616C3_nt3v96Ev");}
void  S616C3_nt ::v97(){vfunc_called(this, "_ZN9S616C3_nt3v97Ev");}
void  S616C3_nt ::v98(){vfunc_called(this, "_ZN9S616C3_nt3v98Ev");}
void  S616C3_nt ::v99(){vfunc_called(this, "_ZN9S616C3_nt3v99Ev");}
void  S616C3_nt ::v100(){vfunc_called(this, "_ZN9S616C3_nt4v100Ev");}
void  S616C3_nt ::v101(){vfunc_called(this, "_ZN9S616C3_nt4v101Ev");}
void  S616C3_nt ::v102(){vfunc_called(this, "_ZN9S616C3_nt4v102Ev");}
void  S616C3_nt ::v103(){vfunc_called(this, "_ZN9S616C3_nt4v103Ev");}
void  S616C3_nt ::v104(){vfunc_called(this, "_ZN9S616C3_nt4v104Ev");}
void  S616C3_nt ::v105(){vfunc_called(this, "_ZN9S616C3_nt4v105Ev");}
void  S616C3_nt ::v106(){vfunc_called(this, "_ZN9S616C3_nt4v106Ev");}
void  S616C3_nt ::v107(){vfunc_called(this, "_ZN9S616C3_nt4v107Ev");}
void  S616C3_nt ::v108(){vfunc_called(this, "_ZN9S616C3_nt4v108Ev");}
void  S616C3_nt ::v109(){vfunc_called(this, "_ZN9S616C3_nt4v109Ev");}
void  S616C3_nt ::v110(){vfunc_called(this, "_ZN9S616C3_nt4v110Ev");}
void  S616C3_nt ::v111(){vfunc_called(this, "_ZN9S616C3_nt4v111Ev");}
void  S616C3_nt ::v112(){vfunc_called(this, "_ZN9S616C3_nt4v112Ev");}
void  S616C3_nt ::v113(){vfunc_called(this, "_ZN9S616C3_nt4v113Ev");}
S616C3_nt ::S616C3_nt(){ note_ctor("S616C3_nt", this);} // tgen

//skip512 S616C3_nt

#else // __cplusplus

extern void _ZN9S616C3_ntC1Ev();
extern void _ZN9S616C3_ntD1Ev();
Name_Map name_map_S616C3_nt[] = {
  NSPAIR(_ZN9S616C3_ntC1Ev),
  NSPAIR(_ZN9S616C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S616C5;
extern VTBL_ENTRY _ZTI6S616C5[];
extern  VTBL_ENTRY _ZTV6S616C5[];
extern Class_Descriptor cd_S616C4_nt;
extern VTBL_ENTRY _ZTI9S616C4_nt[];
extern  VTBL_ENTRY _ZTV9S616C4_nt[];
static Base_Class bases_S616C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S616C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S616C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S616C3_nt[];
extern void _ZN9S616C3_ntD1Ev();
extern void _ZN9S616C3_ntD0Ev();
extern void _ZN6S616C52v5Ev();
extern void _ZN6S616C52v6Ev();
extern void _ZN6S616C52v7Ev();
extern void _ZN6S616C52v8Ev();
extern void _ZN6S616C52v9Ev();
extern void _ZN6S616C53v10Ev();
extern void _ZN6S616C53v11Ev();
extern void _ZN6S616C53v12Ev();
extern void _ZN6S616C53v13Ev();
extern void _ZN6S616C53v14Ev();
extern void _ZN6S616C53v15Ev();
extern void _ZN6S616C53v16Ev();
extern void _ZN6S616C53v17Ev();
extern void _ZN6S616C53v18Ev();
extern void _ZN6S616C53v19Ev();
extern void _ZN6S616C53v20Ev();
extern void _ZN6S616C53v21Ev();
extern void _ZN6S616C53v22Ev();
extern void _ZN6S616C53v23Ev();
extern void _ZN6S616C53v24Ev();
extern void _ZN6S616C53v25Ev();
extern void _ZN6S616C53v26Ev();
extern void _ZN6S616C53v27Ev();
extern void _ZN6S616C53v28Ev();
extern void _ZN6S616C53v29Ev();
extern void _ZN6S616C53v30Ev();
extern void _ZN6S616C53v31Ev();
extern void _ZN6S616C53v32Ev();
extern void _ZN6S616C53v33Ev();
extern void _ZN6S616C53v34Ev();
extern void _ZN6S616C53v35Ev();
extern void _ZN6S616C53v36Ev();
extern void _ZN6S616C53v37Ev();
extern void _ZN6S616C53v38Ev();
extern void _ZN6S616C53v39Ev();
extern void _ZN6S616C53v40Ev();
extern void _ZN6S616C53v41Ev();
extern void _ZN6S616C53v42Ev();
extern void _ZN6S616C53v43Ev();
extern void _ZN6S616C53v44Ev();
extern void _ZN6S616C53v45Ev();
extern void _ZN6S616C53v46Ev();
extern void _ZN6S616C53v47Ev();
extern void _ZN6S616C53v48Ev();
extern void _ZN6S616C53v49Ev();
extern void _ZN6S616C53v50Ev();
extern void _ZN6S616C53v51Ev();
extern void _ZN6S616C53v52Ev();
extern void _ZN6S616C53v53Ev();
extern void _ZN6S616C53v54Ev();
extern void _ZN6S616C53v55Ev();
extern void _ZN6S616C53v56Ev();
extern void _ZN6S616C53v57Ev();
extern void _ZN6S616C53v58Ev();
extern void _ZN6S616C53v59Ev();
extern void _ZN6S616C53v60Ev();
extern void _ZN6S616C53v61Ev();
extern void _ZN6S616C53v62Ev();
extern void _ZN6S616C53v63Ev();
extern void _ZN6S616C53v64Ev();
extern void _ZN6S616C53v65Ev();
extern void _ZN6S616C53v66Ev();
extern void _ZN6S616C53v67Ev();
extern void _ZN6S616C53v68Ev();
extern void _ZN9S616C4_nt3v69Ev();
extern void _ZN9S616C4_nt3v70Ev();
extern void _ZN9S616C4_nt3v71Ev();
extern void _ZN9S616C4_nt3v72Ev();
extern void _ZN9S616C4_nt3v73Ev();
extern void _ZN9S616C4_nt3v74Ev();
extern void _ZN9S616C4_nt3v75Ev();
extern void _ZN9S616C4_nt3v76Ev();
extern void _ZN9S616C4_nt3v77Ev();
extern void _ZN9S616C4_nt3v78Ev();
extern void _ZN9S616C4_nt3v79Ev();
extern void _ZN9S616C4_nt3v80Ev();
extern void _ZN9S616C4_nt3v81Ev();
extern void _ZN9S616C4_nt3v82Ev();
extern void _ZN9S616C4_nt3v83Ev();
extern void _ZN9S616C4_nt3v84Ev();
extern void _ZN9S616C4_nt3v85Ev();
extern void _ZN9S616C4_nt3v86Ev();
extern void _ZN9S616C4_nt3v87Ev();
extern void _ZN9S616C4_nt3v88Ev();
extern void _ZN9S616C4_nt3v89Ev();
extern void _ZN9S616C4_nt3v90Ev();
extern void _ZN9S616C4_nt3v91Ev();
extern void _ZN9S616C4_nt3v92Ev();
extern void _ZN9S616C4_nt3v93Ev();
extern void _ZN9S616C4_nt3v94Ev();
extern void _ZN9S616C4_nt3v95Ev();
extern void _ZN9S616C3_nt3v96Ev();
extern void _ZN9S616C3_nt3v97Ev();
extern void _ZN9S616C3_nt3v98Ev();
extern void _ZN9S616C3_nt3v99Ev();
extern void _ZN9S616C3_nt4v100Ev();
extern void _ZN9S616C3_nt4v101Ev();
extern void _ZN9S616C3_nt4v102Ev();
extern void _ZN9S616C3_nt4v103Ev();
extern void _ZN9S616C3_nt4v104Ev();
extern void _ZN9S616C3_nt4v105Ev();
extern void _ZN9S616C3_nt4v106Ev();
extern void _ZN9S616C3_nt4v107Ev();
extern void _ZN9S616C3_nt4v108Ev();
extern void _ZN9S616C3_nt4v109Ev();
extern void _ZN9S616C3_nt4v110Ev();
extern void _ZN9S616C3_nt4v111Ev();
extern void _ZN9S616C3_nt4v112Ev();
extern void _ZN9S616C3_nt4v113Ev();
static  VTBL_ENTRY vtc_S616C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S616C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S616C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S616C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S616C52v5Ev,
  (VTBL_ENTRY)&_ZN6S616C52v6Ev,
  (VTBL_ENTRY)&_ZN6S616C52v7Ev,
  (VTBL_ENTRY)&_ZN6S616C52v8Ev,
  (VTBL_ENTRY)&_ZN6S616C52v9Ev,
  (VTBL_ENTRY)&_ZN6S616C53v10Ev,
  (VTBL_ENTRY)&_ZN6S616C53v11Ev,
  (VTBL_ENTRY)&_ZN6S616C53v12Ev,
  (VTBL_ENTRY)&_ZN6S616C53v13Ev,
  (VTBL_ENTRY)&_ZN6S616C53v14Ev,
  (VTBL_ENTRY)&_ZN6S616C53v15Ev,
  (VTBL_ENTRY)&_ZN6S616C53v16Ev,
  (VTBL_ENTRY)&_ZN6S616C53v17Ev,
  (VTBL_ENTRY)&_ZN6S616C53v18Ev,
  (VTBL_ENTRY)&_ZN6S616C53v19Ev,
  (VTBL_ENTRY)&_ZN6S616C53v20Ev,
  (VTBL_ENTRY)&_ZN6S616C53v21Ev,
  (VTBL_ENTRY)&_ZN6S616C53v22Ev,
  (VTBL_ENTRY)&_ZN6S616C53v23Ev,
  (VTBL_ENTRY)&_ZN6S616C53v24Ev,
  (VTBL_ENTRY)&_ZN6S616C53v25Ev,
  (VTBL_ENTRY)&_ZN6S616C53v26Ev,
  (VTBL_ENTRY)&_ZN6S616C53v27Ev,
  (VTBL_ENTRY)&_ZN6S616C53v28Ev,
  (VTBL_ENTRY)&_ZN6S616C53v29Ev,
  (VTBL_ENTRY)&_ZN6S616C53v30Ev,
  (VTBL_ENTRY)&_ZN6S616C53v31Ev,
  (VTBL_ENTRY)&_ZN6S616C53v32Ev,
  (VTBL_ENTRY)&_ZN6S616C53v33Ev,
  (VTBL_ENTRY)&_ZN6S616C53v34Ev,
  (VTBL_ENTRY)&_ZN6S616C53v35Ev,
  (VTBL_ENTRY)&_ZN6S616C53v36Ev,
  (VTBL_ENTRY)&_ZN6S616C53v37Ev,
  (VTBL_ENTRY)&_ZN6S616C53v38Ev,
  (VTBL_ENTRY)&_ZN6S616C53v39Ev,
  (VTBL_ENTRY)&_ZN6S616C53v40Ev,
  (VTBL_ENTRY)&_ZN6S616C53v41Ev,
  (VTBL_ENTRY)&_ZN6S616C53v42Ev,
  (VTBL_ENTRY)&_ZN6S616C53v43Ev,
  (VTBL_ENTRY)&_ZN6S616C53v44Ev,
  (VTBL_ENTRY)&_ZN6S616C53v45Ev,
  (VTBL_ENTRY)&_ZN6S616C53v46Ev,
  (VTBL_ENTRY)&_ZN6S616C53v47Ev,
  (VTBL_ENTRY)&_ZN6S616C53v48Ev,
  (VTBL_ENTRY)&_ZN6S616C53v49Ev,
  (VTBL_ENTRY)&_ZN6S616C53v50Ev,
  (VTBL_ENTRY)&_ZN6S616C53v51Ev,
  (VTBL_ENTRY)&_ZN6S616C53v52Ev,
  (VTBL_ENTRY)&_ZN6S616C53v53Ev,
  (VTBL_ENTRY)&_ZN6S616C53v54Ev,
  (VTBL_ENTRY)&_ZN6S616C53v55Ev,
  (VTBL_ENTRY)&_ZN6S616C53v56Ev,
  (VTBL_ENTRY)&_ZN6S616C53v57Ev,
  (VTBL_ENTRY)&_ZN6S616C53v58Ev,
  (VTBL_ENTRY)&_ZN6S616C53v59Ev,
  (VTBL_ENTRY)&_ZN6S616C53v60Ev,
  (VTBL_ENTRY)&_ZN6S616C53v61Ev,
  (VTBL_ENTRY)&_ZN6S616C53v62Ev,
  (VTBL_ENTRY)&_ZN6S616C53v63Ev,
  (VTBL_ENTRY)&_ZN6S616C53v64Ev,
  (VTBL_ENTRY)&_ZN6S616C53v65Ev,
  (VTBL_ENTRY)&_ZN6S616C53v66Ev,
  (VTBL_ENTRY)&_ZN6S616C53v67Ev,
  (VTBL_ENTRY)&_ZN6S616C53v68Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI9S616C3_nt[];
VTBL_ENTRY *P__ZTI9S616C3_nt = _ZTI9S616C3_nt; 
extern  VTBL_ENTRY _ZTV9S616C3_nt[];
Class_Descriptor cd_S616C3_nt = {  "S616C3_nt", // class name
  bases_S616C3_nt, 2,
  &(vtc_S616C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,196), // object size
  NSPAIRA(_ZTI9S616C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S616C3_nt),113, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S616C2_nt  : S616C3_nt {
  int s616c2f0[3];
  virtual  ~S616C2_nt(); // _ZN9S616C2_ntD1Ev
  virtual void  v114(); // _ZN9S616C2_nt4v114Ev
  virtual void  v115(); // _ZN9S616C2_nt4v115Ev
  virtual void  v116(); // _ZN9S616C2_nt4v116Ev
  virtual void  v117(); // _ZN9S616C2_nt4v117Ev
  virtual void  v118(); // _ZN9S616C2_nt4v118Ev
  virtual void  v119(); // _ZN9S616C2_nt4v119Ev
  virtual void  v120(); // _ZN9S616C2_nt4v120Ev
  S616C2_nt(); // tgen
};
//SIG(-1 S616C2_nt) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 Fp FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC5 FC9{ BC10{ BC8}} FC11{ m FC12{ m Fi[4]} FC13{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 FC14{ BC15{ BC8}} Fi:1} vd v1 v2 v3 v4 v5 v6 v7 Fi[3]}


 S616C2_nt ::~S616C2_nt(){ note_dtor("S616C2_nt", this);}
void  S616C2_nt ::v114(){vfunc_called(this, "_ZN9S616C2_nt4v114Ev");}
void  S616C2_nt ::v115(){vfunc_called(this, "_ZN9S616C2_nt4v115Ev");}
void  S616C2_nt ::v116(){vfunc_called(this, "_ZN9S616C2_nt4v116Ev");}
void  S616C2_nt ::v117(){vfunc_called(this, "_ZN9S616C2_nt4v117Ev");}
void  S616C2_nt ::v118(){vfunc_called(this, "_ZN9S616C2_nt4v118Ev");}
void  S616C2_nt ::v119(){vfunc_called(this, "_ZN9S616C2_nt4v119Ev");}
void  S616C2_nt ::v120(){vfunc_called(this, "_ZN9S616C2_nt4v120Ev");}
S616C2_nt ::S616C2_nt(){ note_ctor("S616C2_nt", this);} // tgen

//skip512 S616C2_nt

#else // __cplusplus

extern void _ZN9S616C2_ntC1Ev();
extern void _ZN9S616C2_ntD1Ev();
Name_Map name_map_S616C2_nt[] = {
  NSPAIR(_ZN9S616C2_ntC1Ev),
  NSPAIR(_ZN9S616C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S616C5;
extern VTBL_ENTRY _ZTI6S616C5[];
extern  VTBL_ENTRY _ZTV6S616C5[];
extern Class_Descriptor cd_S616C4_nt;
extern VTBL_ENTRY _ZTI9S616C4_nt[];
extern  VTBL_ENTRY _ZTV9S616C4_nt[];
extern Class_Descriptor cd_S616C3_nt;
extern VTBL_ENTRY _ZTI9S616C3_nt[];
extern  VTBL_ENTRY _ZTV9S616C3_nt[];
static Base_Class bases_S616C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S616C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S616C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S616C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S616C2_nt[];
extern void _ZN9S616C2_ntD1Ev();
extern void _ZN9S616C2_ntD0Ev();
extern void _ZN6S616C52v5Ev();
extern void _ZN6S616C52v6Ev();
extern void _ZN6S616C52v7Ev();
extern void _ZN6S616C52v8Ev();
extern void _ZN6S616C52v9Ev();
extern void _ZN6S616C53v10Ev();
extern void _ZN6S616C53v11Ev();
extern void _ZN6S616C53v12Ev();
extern void _ZN6S616C53v13Ev();
extern void _ZN6S616C53v14Ev();
extern void _ZN6S616C53v15Ev();
extern void _ZN6S616C53v16Ev();
extern void _ZN6S616C53v17Ev();
extern void _ZN6S616C53v18Ev();
extern void _ZN6S616C53v19Ev();
extern void _ZN6S616C53v20Ev();
extern void _ZN6S616C53v21Ev();
extern void _ZN6S616C53v22Ev();
extern void _ZN6S616C53v23Ev();
extern void _ZN6S616C53v24Ev();
extern void _ZN6S616C53v25Ev();
extern void _ZN6S616C53v26Ev();
extern void _ZN6S616C53v27Ev();
extern void _ZN6S616C53v28Ev();
extern void _ZN6S616C53v29Ev();
extern void _ZN6S616C53v30Ev();
extern void _ZN6S616C53v31Ev();
extern void _ZN6S616C53v32Ev();
extern void _ZN6S616C53v33Ev();
extern void _ZN6S616C53v34Ev();
extern void _ZN6S616C53v35Ev();
extern void _ZN6S616C53v36Ev();
extern void _ZN6S616C53v37Ev();
extern void _ZN6S616C53v38Ev();
extern void _ZN6S616C53v39Ev();
extern void _ZN6S616C53v40Ev();
extern void _ZN6S616C53v41Ev();
extern void _ZN6S616C53v42Ev();
extern void _ZN6S616C53v43Ev();
extern void _ZN6S616C53v44Ev();
extern void _ZN6S616C53v45Ev();
extern void _ZN6S616C53v46Ev();
extern void _ZN6S616C53v47Ev();
extern void _ZN6S616C53v48Ev();
extern void _ZN6S616C53v49Ev();
extern void _ZN6S616C53v50Ev();
extern void _ZN6S616C53v51Ev();
extern void _ZN6S616C53v52Ev();
extern void _ZN6S616C53v53Ev();
extern void _ZN6S616C53v54Ev();
extern void _ZN6S616C53v55Ev();
extern void _ZN6S616C53v56Ev();
extern void _ZN6S616C53v57Ev();
extern void _ZN6S616C53v58Ev();
extern void _ZN6S616C53v59Ev();
extern void _ZN6S616C53v60Ev();
extern void _ZN6S616C53v61Ev();
extern void _ZN6S616C53v62Ev();
extern void _ZN6S616C53v63Ev();
extern void _ZN6S616C53v64Ev();
extern void _ZN6S616C53v65Ev();
extern void _ZN6S616C53v66Ev();
extern void _ZN6S616C53v67Ev();
extern void _ZN6S616C53v68Ev();
extern void _ZN9S616C4_nt3v69Ev();
extern void _ZN9S616C4_nt3v70Ev();
extern void _ZN9S616C4_nt3v71Ev();
extern void _ZN9S616C4_nt3v72Ev();
extern void _ZN9S616C4_nt3v73Ev();
extern void _ZN9S616C4_nt3v74Ev();
extern void _ZN9S616C4_nt3v75Ev();
extern void _ZN9S616C4_nt3v76Ev();
extern void _ZN9S616C4_nt3v77Ev();
extern void _ZN9S616C4_nt3v78Ev();
extern void _ZN9S616C4_nt3v79Ev();
extern void _ZN9S616C4_nt3v80Ev();
extern void _ZN9S616C4_nt3v81Ev();
extern void _ZN9S616C4_nt3v82Ev();
extern void _ZN9S616C4_nt3v83Ev();
extern void _ZN9S616C4_nt3v84Ev();
extern void _ZN9S616C4_nt3v85Ev();
extern void _ZN9S616C4_nt3v86Ev();
extern void _ZN9S616C4_nt3v87Ev();
extern void _ZN9S616C4_nt3v88Ev();
extern void _ZN9S616C4_nt3v89Ev();
extern void _ZN9S616C4_nt3v90Ev();
extern void _ZN9S616C4_nt3v91Ev();
extern void _ZN9S616C4_nt3v92Ev();
extern void _ZN9S616C4_nt3v93Ev();
extern void _ZN9S616C4_nt3v94Ev();
extern void _ZN9S616C4_nt3v95Ev();
extern void _ZN9S616C3_nt3v96Ev();
extern void _ZN9S616C3_nt3v97Ev();
extern void _ZN9S616C3_nt3v98Ev();
extern void _ZN9S616C3_nt3v99Ev();
extern void _ZN9S616C3_nt4v100Ev();
extern void _ZN9S616C3_nt4v101Ev();
extern void _ZN9S616C3_nt4v102Ev();
extern void _ZN9S616C3_nt4v103Ev();
extern void _ZN9S616C3_nt4v104Ev();
extern void _ZN9S616C3_nt4v105Ev();
extern void _ZN9S616C3_nt4v106Ev();
extern void _ZN9S616C3_nt4v107Ev();
extern void _ZN9S616C3_nt4v108Ev();
extern void _ZN9S616C3_nt4v109Ev();
extern void _ZN9S616C3_nt4v110Ev();
extern void _ZN9S616C3_nt4v111Ev();
extern void _ZN9S616C3_nt4v112Ev();
extern void _ZN9S616C3_nt4v113Ev();
extern void _ZN9S616C2_nt4v114Ev();
extern void _ZN9S616C2_nt4v115Ev();
extern void _ZN9S616C2_nt4v116Ev();
extern void _ZN9S616C2_nt4v117Ev();
extern void _ZN9S616C2_nt4v118Ev();
extern void _ZN9S616C2_nt4v119Ev();
extern void _ZN9S616C2_nt4v120Ev();
static  VTBL_ENTRY vtc_S616C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S616C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S616C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S616C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S616C52v5Ev,
  (VTBL_ENTRY)&_ZN6S616C52v6Ev,
  (VTBL_ENTRY)&_ZN6S616C52v7Ev,
  (VTBL_ENTRY)&_ZN6S616C52v8Ev,
  (VTBL_ENTRY)&_ZN6S616C52v9Ev,
  (VTBL_ENTRY)&_ZN6S616C53v10Ev,
  (VTBL_ENTRY)&_ZN6S616C53v11Ev,
  (VTBL_ENTRY)&_ZN6S616C53v12Ev,
  (VTBL_ENTRY)&_ZN6S616C53v13Ev,
  (VTBL_ENTRY)&_ZN6S616C53v14Ev,
  (VTBL_ENTRY)&_ZN6S616C53v15Ev,
  (VTBL_ENTRY)&_ZN6S616C53v16Ev,
  (VTBL_ENTRY)&_ZN6S616C53v17Ev,
  (VTBL_ENTRY)&_ZN6S616C53v18Ev,
  (VTBL_ENTRY)&_ZN6S616C53v19Ev,
  (VTBL_ENTRY)&_ZN6S616C53v20Ev,
  (VTBL_ENTRY)&_ZN6S616C53v21Ev,
  (VTBL_ENTRY)&_ZN6S616C53v22Ev,
  (VTBL_ENTRY)&_ZN6S616C53v23Ev,
  (VTBL_ENTRY)&_ZN6S616C53v24Ev,
  (VTBL_ENTRY)&_ZN6S616C53v25Ev,
  (VTBL_ENTRY)&_ZN6S616C53v26Ev,
  (VTBL_ENTRY)&_ZN6S616C53v27Ev,
  (VTBL_ENTRY)&_ZN6S616C53v28Ev,
  (VTBL_ENTRY)&_ZN6S616C53v29Ev,
  (VTBL_ENTRY)&_ZN6S616C53v30Ev,
  (VTBL_ENTRY)&_ZN6S616C53v31Ev,
  (VTBL_ENTRY)&_ZN6S616C53v32Ev,
  (VTBL_ENTRY)&_ZN6S616C53v33Ev,
  (VTBL_ENTRY)&_ZN6S616C53v34Ev,
  (VTBL_ENTRY)&_ZN6S616C53v35Ev,
  (VTBL_ENTRY)&_ZN6S616C53v36Ev,
  (VTBL_ENTRY)&_ZN6S616C53v37Ev,
  (VTBL_ENTRY)&_ZN6S616C53v38Ev,
  (VTBL_ENTRY)&_ZN6S616C53v39Ev,
  (VTBL_ENTRY)&_ZN6S616C53v40Ev,
  (VTBL_ENTRY)&_ZN6S616C53v41Ev,
  (VTBL_ENTRY)&_ZN6S616C53v42Ev,
  (VTBL_ENTRY)&_ZN6S616C53v43Ev,
  (VTBL_ENTRY)&_ZN6S616C53v44Ev,
  (VTBL_ENTRY)&_ZN6S616C53v45Ev,
  (VTBL_ENTRY)&_ZN6S616C53v46Ev,
  (VTBL_ENTRY)&_ZN6S616C53v47Ev,
  (VTBL_ENTRY)&_ZN6S616C53v48Ev,
  (VTBL_ENTRY)&_ZN6S616C53v49Ev,
  (VTBL_ENTRY)&_ZN6S616C53v50Ev,
  (VTBL_ENTRY)&_ZN6S616C53v51Ev,
  (VTBL_ENTRY)&_ZN6S616C53v52Ev,
  (VTBL_ENTRY)&_ZN6S616C53v53Ev,
  (VTBL_ENTRY)&_ZN6S616C53v54Ev,
  (VTBL_ENTRY)&_ZN6S616C53v55Ev,
  (VTBL_ENTRY)&_ZN6S616C53v56Ev,
  (VTBL_ENTRY)&_ZN6S616C53v57Ev,
  (VTBL_ENTRY)&_ZN6S616C53v58Ev,
  (VTBL_ENTRY)&_ZN6S616C53v59Ev,
  (VTBL_ENTRY)&_ZN6S616C53v60Ev,
  (VTBL_ENTRY)&_ZN6S616C53v61Ev,
  (VTBL_ENTRY)&_ZN6S616C53v62Ev,
  (VTBL_ENTRY)&_ZN6S616C53v63Ev,
  (VTBL_ENTRY)&_ZN6S616C53v64Ev,
  (VTBL_ENTRY)&_ZN6S616C53v65Ev,
  (VTBL_ENTRY)&_ZN6S616C53v66Ev,
  (VTBL_ENTRY)&_ZN6S616C53v67Ev,
  (VTBL_ENTRY)&_ZN6S616C53v68Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v120Ev,
};
extern VTBL_ENTRY _ZTI9S616C2_nt[];
VTBL_ENTRY *P__ZTI9S616C2_nt = _ZTI9S616C2_nt; 
extern  VTBL_ENTRY _ZTV9S616C2_nt[];
Class_Descriptor cd_S616C2_nt = {  "S616C2_nt", // class name
  bases_S616C2_nt, 3,
  &(vtc_S616C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,208), // object size
  NSPAIRA(_ZTI9S616C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S616C2_nt),120, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S616C1  : S616C2_nt {
  virtual  ~S616C1(); // _ZN6S616C1D1Ev
  virtual void  v1(); // _ZN6S616C12v1Ev
  virtual void  v2(); // _ZN6S616C12v2Ev
  virtual void  v3(); // _ZN6S616C12v3Ev
  virtual void  v4(); // _ZN6S616C12v4Ev
  S616C1(); // tgen
};
//SIG(1 S616C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC6 FC10{ BC11{ BC9}} FC12{ m FC13{ m Fi[4]} FC14{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 FC15{ BC16{ BC9}} Fi:1} vd v114 v115 v116 v117 v118 v119 v120 Fi[3]} vd v1 v2 v3 v4}


 S616C1 ::~S616C1(){ note_dtor("S616C1", this);}
void  S616C1 ::v1(){vfunc_called(this, "_ZN6S616C12v1Ev");}
void  S616C1 ::v2(){vfunc_called(this, "_ZN6S616C12v2Ev");}
void  S616C1 ::v3(){vfunc_called(this, "_ZN6S616C12v3Ev");}
void  S616C1 ::v4(){vfunc_called(this, "_ZN6S616C12v4Ev");}
S616C1 ::S616C1(){ note_ctor("S616C1", this);} // tgen

static void Test_S616C1()
{
  extern Class_Descriptor cd_S616C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,53)];
    init_test(&cd_S616C1, buf);
    S616C1 *dp, &lv = *(dp=new (buf) S616C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,208), "sizeof(S616C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S616C1)");
    check_base_class_offset(lv, (S616C5*)(S616C4_nt*)(S616C3_nt*)(S616C2_nt*), 0, "S616C1");
    check_base_class_offset(lv, (S616C4_nt*)(S616C3_nt*)(S616C2_nt*), 0, "S616C1");
    check_base_class_offset(lv, (S616C3_nt*)(S616C2_nt*), 0, "S616C1");
    check_base_class_offset(lv, (S616C2_nt*), 0, "S616C1");
    test_class_info(&lv, &cd_S616C1);
    dp->~S616C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS616C1(Test_S616C1, "S616C1", ABISELECT(264,208));

#else // __cplusplus

extern void _ZN6S616C1C1Ev();
extern void _ZN6S616C1D1Ev();
Name_Map name_map_S616C1[] = {
  NSPAIR(_ZN6S616C1C1Ev),
  NSPAIR(_ZN6S616C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S616C5;
extern VTBL_ENTRY _ZTI6S616C5[];
extern  VTBL_ENTRY _ZTV6S616C5[];
extern Class_Descriptor cd_S616C4_nt;
extern VTBL_ENTRY _ZTI9S616C4_nt[];
extern  VTBL_ENTRY _ZTV9S616C4_nt[];
extern Class_Descriptor cd_S616C3_nt;
extern VTBL_ENTRY _ZTI9S616C3_nt[];
extern  VTBL_ENTRY _ZTV9S616C3_nt[];
extern Class_Descriptor cd_S616C2_nt;
extern VTBL_ENTRY _ZTI9S616C2_nt[];
extern  VTBL_ENTRY _ZTV9S616C2_nt[];
static Base_Class bases_S616C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S616C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S616C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S616C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S616C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S616C1[];
extern void _ZN6S616C1D1Ev();
extern void _ZN6S616C1D0Ev();
extern void _ZN6S616C52v5Ev();
extern void _ZN6S616C52v6Ev();
extern void _ZN6S616C52v7Ev();
extern void _ZN6S616C52v8Ev();
extern void _ZN6S616C52v9Ev();
extern void _ZN6S616C53v10Ev();
extern void _ZN6S616C53v11Ev();
extern void _ZN6S616C53v12Ev();
extern void _ZN6S616C53v13Ev();
extern void _ZN6S616C53v14Ev();
extern void _ZN6S616C53v15Ev();
extern void _ZN6S616C53v16Ev();
extern void _ZN6S616C53v17Ev();
extern void _ZN6S616C53v18Ev();
extern void _ZN6S616C53v19Ev();
extern void _ZN6S616C53v20Ev();
extern void _ZN6S616C53v21Ev();
extern void _ZN6S616C53v22Ev();
extern void _ZN6S616C53v23Ev();
extern void _ZN6S616C53v24Ev();
extern void _ZN6S616C53v25Ev();
extern void _ZN6S616C53v26Ev();
extern void _ZN6S616C53v27Ev();
extern void _ZN6S616C53v28Ev();
extern void _ZN6S616C53v29Ev();
extern void _ZN6S616C53v30Ev();
extern void _ZN6S616C53v31Ev();
extern void _ZN6S616C53v32Ev();
extern void _ZN6S616C53v33Ev();
extern void _ZN6S616C53v34Ev();
extern void _ZN6S616C53v35Ev();
extern void _ZN6S616C53v36Ev();
extern void _ZN6S616C53v37Ev();
extern void _ZN6S616C53v38Ev();
extern void _ZN6S616C53v39Ev();
extern void _ZN6S616C53v40Ev();
extern void _ZN6S616C53v41Ev();
extern void _ZN6S616C53v42Ev();
extern void _ZN6S616C53v43Ev();
extern void _ZN6S616C53v44Ev();
extern void _ZN6S616C53v45Ev();
extern void _ZN6S616C53v46Ev();
extern void _ZN6S616C53v47Ev();
extern void _ZN6S616C53v48Ev();
extern void _ZN6S616C53v49Ev();
extern void _ZN6S616C53v50Ev();
extern void _ZN6S616C53v51Ev();
extern void _ZN6S616C53v52Ev();
extern void _ZN6S616C53v53Ev();
extern void _ZN6S616C53v54Ev();
extern void _ZN6S616C53v55Ev();
extern void _ZN6S616C53v56Ev();
extern void _ZN6S616C53v57Ev();
extern void _ZN6S616C53v58Ev();
extern void _ZN6S616C53v59Ev();
extern void _ZN6S616C53v60Ev();
extern void _ZN6S616C53v61Ev();
extern void _ZN6S616C53v62Ev();
extern void _ZN6S616C53v63Ev();
extern void _ZN6S616C53v64Ev();
extern void _ZN6S616C53v65Ev();
extern void _ZN6S616C53v66Ev();
extern void _ZN6S616C53v67Ev();
extern void _ZN6S616C53v68Ev();
extern void _ZN9S616C4_nt3v69Ev();
extern void _ZN9S616C4_nt3v70Ev();
extern void _ZN9S616C4_nt3v71Ev();
extern void _ZN9S616C4_nt3v72Ev();
extern void _ZN9S616C4_nt3v73Ev();
extern void _ZN9S616C4_nt3v74Ev();
extern void _ZN9S616C4_nt3v75Ev();
extern void _ZN9S616C4_nt3v76Ev();
extern void _ZN9S616C4_nt3v77Ev();
extern void _ZN9S616C4_nt3v78Ev();
extern void _ZN9S616C4_nt3v79Ev();
extern void _ZN9S616C4_nt3v80Ev();
extern void _ZN9S616C4_nt3v81Ev();
extern void _ZN9S616C4_nt3v82Ev();
extern void _ZN9S616C4_nt3v83Ev();
extern void _ZN9S616C4_nt3v84Ev();
extern void _ZN9S616C4_nt3v85Ev();
extern void _ZN9S616C4_nt3v86Ev();
extern void _ZN9S616C4_nt3v87Ev();
extern void _ZN9S616C4_nt3v88Ev();
extern void _ZN9S616C4_nt3v89Ev();
extern void _ZN9S616C4_nt3v90Ev();
extern void _ZN9S616C4_nt3v91Ev();
extern void _ZN9S616C4_nt3v92Ev();
extern void _ZN9S616C4_nt3v93Ev();
extern void _ZN9S616C4_nt3v94Ev();
extern void _ZN9S616C4_nt3v95Ev();
extern void _ZN9S616C3_nt3v96Ev();
extern void _ZN9S616C3_nt3v97Ev();
extern void _ZN9S616C3_nt3v98Ev();
extern void _ZN9S616C3_nt3v99Ev();
extern void _ZN9S616C3_nt4v100Ev();
extern void _ZN9S616C3_nt4v101Ev();
extern void _ZN9S616C3_nt4v102Ev();
extern void _ZN9S616C3_nt4v103Ev();
extern void _ZN9S616C3_nt4v104Ev();
extern void _ZN9S616C3_nt4v105Ev();
extern void _ZN9S616C3_nt4v106Ev();
extern void _ZN9S616C3_nt4v107Ev();
extern void _ZN9S616C3_nt4v108Ev();
extern void _ZN9S616C3_nt4v109Ev();
extern void _ZN9S616C3_nt4v110Ev();
extern void _ZN9S616C3_nt4v111Ev();
extern void _ZN9S616C3_nt4v112Ev();
extern void _ZN9S616C3_nt4v113Ev();
extern void _ZN9S616C2_nt4v114Ev();
extern void _ZN9S616C2_nt4v115Ev();
extern void _ZN9S616C2_nt4v116Ev();
extern void _ZN9S616C2_nt4v117Ev();
extern void _ZN9S616C2_nt4v118Ev();
extern void _ZN9S616C2_nt4v119Ev();
extern void _ZN9S616C2_nt4v120Ev();
extern void _ZN6S616C12v1Ev();
extern void _ZN6S616C12v2Ev();
extern void _ZN6S616C12v3Ev();
extern void _ZN6S616C12v4Ev();
static  VTBL_ENTRY vtc_S616C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S616C1[0]),
  (VTBL_ENTRY)&_ZN6S616C1D1Ev,
  (VTBL_ENTRY)&_ZN6S616C1D0Ev,
  (VTBL_ENTRY)&_ZN6S616C52v5Ev,
  (VTBL_ENTRY)&_ZN6S616C52v6Ev,
  (VTBL_ENTRY)&_ZN6S616C52v7Ev,
  (VTBL_ENTRY)&_ZN6S616C52v8Ev,
  (VTBL_ENTRY)&_ZN6S616C52v9Ev,
  (VTBL_ENTRY)&_ZN6S616C53v10Ev,
  (VTBL_ENTRY)&_ZN6S616C53v11Ev,
  (VTBL_ENTRY)&_ZN6S616C53v12Ev,
  (VTBL_ENTRY)&_ZN6S616C53v13Ev,
  (VTBL_ENTRY)&_ZN6S616C53v14Ev,
  (VTBL_ENTRY)&_ZN6S616C53v15Ev,
  (VTBL_ENTRY)&_ZN6S616C53v16Ev,
  (VTBL_ENTRY)&_ZN6S616C53v17Ev,
  (VTBL_ENTRY)&_ZN6S616C53v18Ev,
  (VTBL_ENTRY)&_ZN6S616C53v19Ev,
  (VTBL_ENTRY)&_ZN6S616C53v20Ev,
  (VTBL_ENTRY)&_ZN6S616C53v21Ev,
  (VTBL_ENTRY)&_ZN6S616C53v22Ev,
  (VTBL_ENTRY)&_ZN6S616C53v23Ev,
  (VTBL_ENTRY)&_ZN6S616C53v24Ev,
  (VTBL_ENTRY)&_ZN6S616C53v25Ev,
  (VTBL_ENTRY)&_ZN6S616C53v26Ev,
  (VTBL_ENTRY)&_ZN6S616C53v27Ev,
  (VTBL_ENTRY)&_ZN6S616C53v28Ev,
  (VTBL_ENTRY)&_ZN6S616C53v29Ev,
  (VTBL_ENTRY)&_ZN6S616C53v30Ev,
  (VTBL_ENTRY)&_ZN6S616C53v31Ev,
  (VTBL_ENTRY)&_ZN6S616C53v32Ev,
  (VTBL_ENTRY)&_ZN6S616C53v33Ev,
  (VTBL_ENTRY)&_ZN6S616C53v34Ev,
  (VTBL_ENTRY)&_ZN6S616C53v35Ev,
  (VTBL_ENTRY)&_ZN6S616C53v36Ev,
  (VTBL_ENTRY)&_ZN6S616C53v37Ev,
  (VTBL_ENTRY)&_ZN6S616C53v38Ev,
  (VTBL_ENTRY)&_ZN6S616C53v39Ev,
  (VTBL_ENTRY)&_ZN6S616C53v40Ev,
  (VTBL_ENTRY)&_ZN6S616C53v41Ev,
  (VTBL_ENTRY)&_ZN6S616C53v42Ev,
  (VTBL_ENTRY)&_ZN6S616C53v43Ev,
  (VTBL_ENTRY)&_ZN6S616C53v44Ev,
  (VTBL_ENTRY)&_ZN6S616C53v45Ev,
  (VTBL_ENTRY)&_ZN6S616C53v46Ev,
  (VTBL_ENTRY)&_ZN6S616C53v47Ev,
  (VTBL_ENTRY)&_ZN6S616C53v48Ev,
  (VTBL_ENTRY)&_ZN6S616C53v49Ev,
  (VTBL_ENTRY)&_ZN6S616C53v50Ev,
  (VTBL_ENTRY)&_ZN6S616C53v51Ev,
  (VTBL_ENTRY)&_ZN6S616C53v52Ev,
  (VTBL_ENTRY)&_ZN6S616C53v53Ev,
  (VTBL_ENTRY)&_ZN6S616C53v54Ev,
  (VTBL_ENTRY)&_ZN6S616C53v55Ev,
  (VTBL_ENTRY)&_ZN6S616C53v56Ev,
  (VTBL_ENTRY)&_ZN6S616C53v57Ev,
  (VTBL_ENTRY)&_ZN6S616C53v58Ev,
  (VTBL_ENTRY)&_ZN6S616C53v59Ev,
  (VTBL_ENTRY)&_ZN6S616C53v60Ev,
  (VTBL_ENTRY)&_ZN6S616C53v61Ev,
  (VTBL_ENTRY)&_ZN6S616C53v62Ev,
  (VTBL_ENTRY)&_ZN6S616C53v63Ev,
  (VTBL_ENTRY)&_ZN6S616C53v64Ev,
  (VTBL_ENTRY)&_ZN6S616C53v65Ev,
  (VTBL_ENTRY)&_ZN6S616C53v66Ev,
  (VTBL_ENTRY)&_ZN6S616C53v67Ev,
  (VTBL_ENTRY)&_ZN6S616C53v68Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S616C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S616C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S616C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN6S616C12v1Ev,
  (VTBL_ENTRY)&_ZN6S616C12v2Ev,
  (VTBL_ENTRY)&_ZN6S616C12v3Ev,
  (VTBL_ENTRY)&_ZN6S616C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S616C1[];
extern  VTBL_ENTRY _ZTV6S616C1[];
Class_Descriptor cd_S616C1 = {  "S616C1", // class name
  bases_S616C1, 4,
  &(vtc_S616C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,208), // object size
  NSPAIRA(_ZTI6S616C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S616C1),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C7_nt  {
  void  mf19869c7(); // _ZN11S19869C7_nt9mf19869c7Ev
  virtual  ~S19869C7_nt(); // _ZN11S19869C7_ntD1Ev
  S19869C7_nt(); // tgen
};
//SIG(-1 S19869C7_nt) C1{ vd m}


void  S19869C7_nt ::mf19869c7(){}
 S19869C7_nt ::~S19869C7_nt(){ note_dtor("S19869C7_nt", this);}
S19869C7_nt ::S19869C7_nt(){ note_ctor("S19869C7_nt", this);} // tgen

//skip512 S19869C7_nt

#else // __cplusplus

extern void _ZN11S19869C7_ntC1Ev();
extern void _ZN11S19869C7_ntD1Ev();
Name_Map name_map_S19869C7_nt[] = {
  NSPAIR(_ZN11S19869C7_ntC1Ev),
  NSPAIR(_ZN11S19869C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern void _ZN11S19869C7_ntD1Ev();
extern void _ZN11S19869C7_ntD0Ev();
static  VTBL_ENTRY vtc_S19869C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S19869C7_nt[0]),
  (VTBL_ENTRY)&_ZN11S19869C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S19869C7_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
VTBL_ENTRY *P__ZTI11S19869C7_nt = _ZTI11S19869C7_nt; 
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
Class_Descriptor cd_S19869C7_nt = {  "S19869C7_nt", // class name
  0,0,//no base classes
  &(vtc_S19869C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S19869C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S19869C7_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C6  : S19869C7_nt {
  virtual  ~S19869C6(); // _ZN8S19869C6D1Ev
  S19869C6(); // tgen
};
//SIG(-1 S19869C6) C1{ BC2{ vd m} vd}


 S19869C6 ::~S19869C6(){ note_dtor("S19869C6", this);}
S19869C6 ::S19869C6(){ note_ctor("S19869C6", this);} // tgen

static void Test_S19869C6()
{
  extern Class_Descriptor cd_S19869C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S19869C6, buf);
    S19869C6 *dp, &lv = *(dp=new (buf) S19869C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S19869C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C6)");
    check_base_class_offset(lv, (S19869C7_nt*), 0, "S19869C6");
    test_class_info(&lv, &cd_S19869C6);
    dp->~S19869C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C6(Test_S19869C6, "S19869C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S19869C6C1Ev();
extern void _ZN8S19869C6D1Ev();
Name_Map name_map_S19869C6[] = {
  NSPAIR(_ZN8S19869C6C1Ev),
  NSPAIR(_ZN8S19869C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
static Base_Class bases_S19869C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19869C6[];
extern void _ZN8S19869C6D1Ev();
extern void _ZN8S19869C6D0Ev();
static  VTBL_ENTRY vtc_S19869C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C6[0]),
  (VTBL_ENTRY)&_ZN8S19869C6D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C6D0Ev,
};
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
Class_Descriptor cd_S19869C6 = {  "S19869C6", // class name
  bases_S19869C6, 1,
  &(vtc_S19869C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S19869C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19869C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C5  : S19869C6 {
  ::S19869C6 s19869c5f0;
  virtual  ~S19869C5(); // _ZN8S19869C5D1Ev
  S19869C5(); // tgen
};
//SIG(-1 S19869C5) C1{ BC2{ BC3{ vd m} vd} vd FC2}


 S19869C5 ::~S19869C5(){ note_dtor("S19869C5", this);}
S19869C5 ::S19869C5(){ note_ctor("S19869C5", this);} // tgen

static void Test_S19869C5()
{
  extern Class_Descriptor cd_S19869C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S19869C5, buf);
    S19869C5 *dp, &lv = *(dp=new (buf) S19869C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S19869C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C5)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), 0, "S19869C5");
    check_base_class_offset(lv, (S19869C6*), 0, "S19869C5");
    check_field_offset(lv, s19869c5f0, ABISELECT(8,4), "S19869C5.s19869c5f0");
    test_class_info(&lv, &cd_S19869C5);
    dp->~S19869C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C5(Test_S19869C5, "S19869C5", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S19869C5C1Ev();
extern void _ZN8S19869C5D1Ev();
Name_Map name_map_S19869C5[] = {
  NSPAIR(_ZN8S19869C5C1Ev),
  NSPAIR(_ZN8S19869C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
static Base_Class bases_S19869C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19869C5[];
extern void _ZN8S19869C5D1Ev();
extern void _ZN8S19869C5D0Ev();
static  VTBL_ENTRY vtc_S19869C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C5[0]),
  (VTBL_ENTRY)&_ZN8S19869C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C5D0Ev,
};
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
Class_Descriptor cd_S19869C5 = {  "S19869C5", // class name
  bases_S19869C5, 2,
  &(vtc_S19869C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S19869C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19869C5),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C8  : S246C12_nt {
};
//SIG(-1 S19869C8) C1{ BC2{ m}}



static void Test_S19869C8()
{
  extern Class_Descriptor cd_S19869C8;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S19869C8, buf);
    S19869C8 &lv = *(new (buf) S19869C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S19869C8)");
    check2(__alignof__(lv), 1, "__alignof__(S19869C8)");
    check_base_class_offset(lv, (S246C12_nt*), 0, "S19869C8");
    test_class_info(&lv, &cd_S19869C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C8(Test_S19869C8, "S19869C8", 1);

#else // __cplusplus

extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
static Base_Class bases_S19869C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19869C8[];
Class_Descriptor cd_S19869C8 = {  "S19869C8", // class name
  bases_S19869C8, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S19869C8),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C4  : virtual S246C12_nt , virtual S19869C5 , S19869C8 {
  ~S19869C4(); // tgen
  S19869C4(); // tgen
};
//SIG(-1 S19869C4) C1{ VBC2{ m} VBC3{ BC4{ BC5{ vd m} vd} vd FC4} BC6{ BC2}}


S19869C4 ::~S19869C4(){ note_dtor("S19869C4", this);} // tgen
S19869C4 ::S19869C4(){ note_ctor("S19869C4", this);} // tgen

static void Test_S19869C4()
{
  extern Class_Descriptor cd_S19869C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S19869C4, buf);
    S19869C4 *dp, &lv = *(dp=new (buf) S19869C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S19869C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C4)");
    /*is_ambiguous_... S19869C4::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*), ABISELECT(8,4), "S19869C4");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(8,4), "S19869C4");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(8,4), "S19869C4");
    check_base_class_offset(lv, (S19869C5*), ABISELECT(8,4), "S19869C4");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), 0, "S19869C4");
    check_base_class_offset(lv, (S19869C8*), 0, "S19869C4");
    test_class_info(&lv, &cd_S19869C4);
    dp->~S19869C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C4(Test_S19869C4, "S19869C4", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S19869C4C1Ev();
extern void _ZN8S19869C4D1Ev();
Name_Map name_map_S19869C4[] = {
  NSPAIR(_ZN8S19869C4C1Ev),
  NSPAIR(_ZN8S19869C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
static Base_Class bases_S19869C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19869C4[];
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZThn8_N8S19869C4D1Ev,_ZThn4_N8S19869C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
extern void ABISELECT(_ZThn8_N8S19869C4D0Ev,_ZThn4_N8S19869C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C4[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
extern VTBL_ENTRY _ZTV8S19869C4[];
static  VTT_ENTRY vtt_S19869C4[] = {
  {&(_ZTV8S19869C4[4]),  4,11},
  {&(_ZTV8S19869C4[9]),  9,11},
};
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C4D0Ev,_ZThn4_N8S19869C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C4D1Ev,_ZThn4_N8S19869C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C4 = {  "S19869C4", // class name
  bases_S19869C4, 6,
  &(vtc_S19869C4[0]), // expected_vtbl_contents
  &(vtt_S19869C4[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S19869C4),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S19869C4),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19869C4),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C12  : S19869C6 {
  virtual  ~S19869C12(); // _ZN9S19869C12D1Ev
  S19869C12(); // tgen
};
//SIG(-1 S19869C12) C1{ BC2{ BC3{ vd m} vd} vd}


 S19869C12 ::~S19869C12(){ note_dtor("S19869C12", this);}
S19869C12 ::S19869C12(){ note_ctor("S19869C12", this);} // tgen

static void Test_S19869C12()
{
  extern Class_Descriptor cd_S19869C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S19869C12, buf);
    S19869C12 *dp, &lv = *(dp=new (buf) S19869C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S19869C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C12)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), 0, "S19869C12");
    check_base_class_offset(lv, (S19869C6*), 0, "S19869C12");
    test_class_info(&lv, &cd_S19869C12);
    dp->~S19869C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C12(Test_S19869C12, "S19869C12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S19869C12C1Ev();
extern void _ZN9S19869C12D1Ev();
Name_Map name_map_S19869C12[] = {
  NSPAIR(_ZN9S19869C12C1Ev),
  NSPAIR(_ZN9S19869C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
static Base_Class bases_S19869C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C12[];
extern void _ZN9S19869C12D1Ev();
extern void _ZN9S19869C12D0Ev();
static  VTBL_ENTRY vtc_S19869C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C12[0]),
  (VTBL_ENTRY)&_ZN9S19869C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C12D0Ev,
};
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
Class_Descriptor cd_S19869C12 = {  "S19869C12", // class name
  bases_S19869C12, 2,
  &(vtc_S19869C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S19869C12),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19869C12),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C13  : S19869C5 , S19869C12 {
  long s19869c13f0;
  int s19869c13f1;
  ~S19869C13(); // tgen
  S19869C13(); // tgen
};
//SIG(-1 S19869C13) C1{ BC2{ BC3{ BC4{ vd m} vd} vd FC3} BC5{ BC3 vd} Fl Fi}


S19869C13 ::~S19869C13(){ note_dtor("S19869C13", this);} // tgen
S19869C13 ::S19869C13(){ note_ctor("S19869C13", this);} // tgen

static void Test_S19869C13()
{
  extern Class_Descriptor cd_S19869C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S19869C13, buf);
    S19869C13 *dp, &lv = *(dp=new (buf) S19869C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S19869C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C13)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), 0, "S19869C13");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*), 0, "S19869C13");
    check_base_class_offset(lv, (S19869C5*), 0, "S19869C13");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(16,8), "S19869C13");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(16,8), "S19869C13");
    check_base_class_offset(lv, (S19869C12*), ABISELECT(16,8), "S19869C13");
    check_field_offset(lv, s19869c13f0, ABISELECT(24,12), "S19869C13.s19869c13f0");
    check_field_offset(lv, s19869c13f1, ABISELECT(32,16), "S19869C13.s19869c13f1");
    test_class_info(&lv, &cd_S19869C13);
    dp->~S19869C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C13(Test_S19869C13, "S19869C13", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S19869C13C1Ev();
extern void _ZN9S19869C13D1Ev();
Name_Map name_map_S19869C13[] = {
  NSPAIR(_ZN9S19869C13C1Ev),
  NSPAIR(_ZN9S19869C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
static Base_Class bases_S19869C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C13[];
extern void _ZN9S19869C13D1Ev();
extern void _ZN9S19869C13D0Ev();
extern void ABISELECT(_ZThn16_N9S19869C13D1Ev,_ZThn8_N9S19869C13D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C13D0Ev,_ZThn8_N9S19869C13D0Ev)();
static  VTBL_ENTRY vtc_S19869C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C13[0]),
  (VTBL_ENTRY)&_ZN9S19869C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C13D0Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19869C13D1Ev,_ZThn8_N9S19869C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19869C13D0Ev,_ZThn8_N9S19869C13D0Ev),
};
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
Class_Descriptor cd_S19869C13 = {  "S19869C13", // class name
  bases_S19869C13, 6,
  &(vtc_S19869C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S19869C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19869C13),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C11  : S19869C12 , virtual S19869C7_nt , virtual S19869C6 , virtual S19869C13 {
  int s19869c11f0;
  ~S19869C11(); // tgen
  S19869C11(); // tgen
};
//SIG(-1 S19869C11) C1{ BC2{ BC3{ BC4{ vd m} vd} vd} VBC4 VBC3 VBC5{ BC6{ BC3 vd FC3} BC2 Fl Fi} Fi}


S19869C11 ::~S19869C11(){ note_dtor("S19869C11", this);} // tgen
S19869C11 ::S19869C11(){ note_ctor("S19869C11", this);} // tgen

static void Test_S19869C11()
{
  extern Class_Descriptor cd_S19869C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[10];
    init_test(&cd_S19869C11, buf);
    S19869C11 *dp, &lv = *(dp=new (buf) S19869C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,36), "sizeof(S19869C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C11)");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), 0, "S19869C11");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*), 0, "S19869C11");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C12*), 0, "S19869C11");
    /*is_ambiguous_... S19869C11::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*), ABISELECT(16,8), "S19869C11");
    /*is_ambiguous_... S19869C11::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(24,12), "S19869C11");
    /*is_ambiguous_... S19869C11::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*), ABISELECT(24,12), "S19869C11");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C11");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C11");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C11");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C11");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C11");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C11");
    check_base_class_offset(lv, (S19869C13*), ABISELECT(32,16), "S19869C11");
    check_field_offset(lv, s19869c11f0, ABISELECT(8,4), "S19869C11.s19869c11f0");
    test_class_info(&lv, &cd_S19869C11);
    dp->~S19869C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C11(Test_S19869C11, "S19869C11", ABISELECT(72,36));

#else // __cplusplus

extern void _ZN9S19869C11C1Ev();
extern void _ZN9S19869C11D1Ev();
Name_Map name_map_S19869C11[] = {
  NSPAIR(_ZN9S19869C11C1Ev),
  NSPAIR(_ZN9S19869C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
static Base_Class bases_S19869C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(24,12), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(48,24), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(32,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C11[];
extern void _ZN9S19869C11D1Ev();
extern void _ZN9S19869C11D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C11D1Ev,_ZThn12_N9S19869C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C11D0Ev,_ZThn12_N9S19869C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C11D1Ev,_ZThn16_N9S19869C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C11D0Ev,_ZThn16_N9S19869C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY vtc_S19869C11[] = {
  ABISELECT(32,16),
  ABISELECT(24,12),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&_ZN9S19869C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C11D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C11[];
static  VTT_ENTRY vtt_S19869C11[] = {
  {&(_ZTV9S19869C11[5]),  5,26},
  {&(_ZTV9S19869C11[10]),  10,26},
  {&(_ZTV9S19869C11[15]),  15,26},
  {&(_ZTV9S19869C11[20]),  20,26},
  {&(_ZTV9S19869C11[24]),  24,26},
};
extern VTBL_ENTRY _ZTI9S19869C11[];
extern  VTBL_ENTRY _ZTV9S19869C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C11[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C11D0Ev,_ZThn16_N9S19869C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C11D0Ev,_ZThn12_N9S19869C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C11D1Ev,_ZThn16_N9S19869C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C11D1Ev,_ZThn12_N9S19869C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C11 = {  "S19869C11", // class name
  bases_S19869C11, 13,
  &(vtc_S19869C11[0]), // expected_vtbl_contents
  &(vtt_S19869C11[0]), // expected_vtt_contents
  ABISELECT(72,36), // object size
  NSPAIRA(_ZTI9S19869C11),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19869C11),26, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C11),5, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C10  : virtual S246C12_nt , virtual S19869C7_nt , virtual S19869C11 {
  ~S19869C10(); // tgen
  S19869C10(); // tgen
};
//SIG(-1 S19869C10) C1{ VBC2{ m} VBC3{ vd m} VBC4{ BC5{ BC6{ BC3 vd} vd} VBC3 VBC6 VBC7{ BC8{ BC6 vd FC6} BC5 Fl Fi} Fi}}


S19869C10 ::~S19869C10(){ note_dtor("S19869C10", this);} // tgen
S19869C10 ::S19869C10(){ note_ctor("S19869C10", this);} // tgen

static void Test_S19869C10()
{
  extern Class_Descriptor cd_S19869C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[10];
    init_test(&cd_S19869C10, buf);
    S19869C10 *dp, &lv = *(dp=new (buf) S19869C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,36), "sizeof(S19869C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C10)");
    check_base_class_offset(lv, (S246C12_nt*), 0, "S19869C10");
    /*is_ambiguous_... S19869C10::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*), 0, "S19869C10");
    /*is_ambiguous_... S19869C11::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C11*), 0, "S19869C10");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(8,4), "S19869C10");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(8,4), "S19869C10");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C12*)(S19869C11*), ABISELECT(8,4), "S19869C10");
    /*is_ambiguous_... S19869C10::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(24,12), "S19869C10");
    /*is_ambiguous_... S19869C11::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C11*), ABISELECT(24,12), "S19869C10");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C10");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C10");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C10");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C10");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C10");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C10");
    check_base_class_offset(lv, (S19869C13*)(S19869C11*), ABISELECT(32,16), "S19869C10");
    check_base_class_offset(lv, (S19869C11*), ABISELECT(8,4), "S19869C10");
    test_class_info(&lv, &cd_S19869C10);
    dp->~S19869C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C10(Test_S19869C10, "S19869C10", ABISELECT(72,36));

#else // __cplusplus

extern void _ZN9S19869C10C1Ev();
extern void _ZN9S19869C10D1Ev();
Name_Map name_map_S19869C10[] = {
  NSPAIR(_ZN9S19869C10C1Ev),
  NSPAIR(_ZN9S19869C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
extern Class_Descriptor cd_S19869C11;
extern VTBL_ENTRY _ZTI9S19869C11[];
extern  VTBL_ENTRY _ZTV9S19869C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C11[];
static Base_Class bases_S19869C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(24,12), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(48,24), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(32,16), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C11,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C10[];
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void _ZN9S19869C10D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
extern void _ZN9S19869C10D0Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev)();
extern void ABISELECT(_ZThn8_N9S19869C10D1Ev,_ZThn4_N9S19869C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev)();
extern void ABISELECT(_ZThn8_N9S19869C10D0Ev,_ZThn4_N9S19869C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C10D1Ev,_ZThn12_N9S19869C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C10D0Ev,_ZThn12_N9S19869C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C10D1Ev,_ZThn16_N9S19869C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C10D0Ev,_ZThn16_N9S19869C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S19869C10D1Ev,_ZTvn8_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C10D0Ev,_ZTvn8_n12_N9S19869C10D0Ev)();
static  VTBL_ENTRY vtc_S19869C10[] = {
  ABISELECT(32,16),
  ABISELECT(24,12),
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
  ABISELECT(-8,-4),
  ABISELECT(24,12),
  ABISELECT(16,8),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C10D1Ev,_ZTvn8_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C10D0Ev,_ZTvn8_n12_N9S19869C10D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C10[];
extern void _ZN9S19869C11D1Ev();
extern void _ZN9S19869C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C11__9S19869C10[] = {
  ABISELECT(24,12),
  ABISELECT(16,8),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&_ZN9S19869C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C11D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt__A1__9S19869C11__9S19869C10[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C6__A1__9S19869C11__9S19869C10[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C11D1Ev,_ZThn12_N9S19869C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C11D0Ev,_ZThn12_N9S19869C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C13__9S19869C11__9S19869C10[] = {
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C13__A1__9S19869C11__9S19869C10[] = {
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev),
};
static  VTT_ENTRY vtt_S19869C10[] = {
  {&(_ZTV9S19869C10[8]),  8,32},
  {&(_ZTV9S19869C10[8]),  8,32},
  {&(_ZTV9S19869C10[16]),  16,32},
  {&(_ZTV9S19869C10[21]),  21,32},
  {&(_ZTV9S19869C10[26]),  26,32},
  {&(_ZTV9S19869C10[30]),  30,32},
  {&(_tg__ZTV9S19869C11__9S19869C10[5]),  5,7},
  {&(_tg__ZTV11S19869C7_nt__A1__9S19869C11__9S19869C10[3]),  3,5},
  {&(_tg__ZTV8S19869C6__A1__9S19869C11__9S19869C10[3]),  3,5},
  {&(_tg__ZTV9S19869C13__9S19869C11__9S19869C10[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C13__A1__9S19869C11__9S19869C10[2]),  2,4},
};
extern VTBL_ENTRY _ZTI9S19869C10[];
extern  VTBL_ENTRY _ZTV9S19869C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C10[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C11D0Ev,_ZThn12_N9S19869C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C11D1Ev,_ZThn12_N9S19869C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C10D0Ev,_ZThn4_N9S19869C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C10D1Ev,_ZThn4_N9S19869C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C10D0Ev,_ZThn16_N9S19869C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C10D0Ev,_ZThn12_N9S19869C10D0Ev),
  (VTBL_ENTRY)_ZN9S19869C10D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C10D1Ev,_ZThn16_N9S19869C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C10D1Ev,_ZThn12_N9S19869C10D1Ev),
  (VTBL_ENTRY)_ZN9S19869C10D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C10 = {  "S19869C10", // class name
  bases_S19869C10, 15,
  &(vtc_S19869C10[0]), // expected_vtbl_contents
  &(vtt_S19869C10[0]), // expected_vtt_contents
  ABISELECT(72,36), // object size
  NSPAIRA(_ZTI9S19869C10),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19869C10),32, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C10),11, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C15_nt  {
  __tsi64 s19869c15f0;
  void  mf19869c15(); // _ZN12S19869C15_nt10mf19869c15Ev
};
//SIG(-1 S19869C15_nt) C1{ m FL}


void  S19869C15_nt ::mf19869c15(){}

//skip512 S19869C15_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S19869C15_nt[];
VTBL_ENTRY *P__ZTI12S19869C15_nt = _ZTI12S19869C15_nt; 
Class_Descriptor cd_S19869C15_nt = {  "S19869C15_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI12S19869C15_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C14  : S19869C15_nt , virtual S19869C4 , S246C12_nt {
  virtual  ~S19869C14(); // _ZN9S19869C14D2Ev
  S19869C14(); // tgen
};
//SIG(-1 S19869C14) C1{ BC2{ m FL} VBC3{ VBC4{ m} VBC5{ BC6{ BC7{ vd m} vd} vd FC6} BC8{ BC4}} BC4 vd}


 S19869C14 ::~S19869C14(){ note_dtor("S19869C14", this);}
S19869C14 ::S19869C14(){ note_ctor("S19869C14", this);} // tgen

static void Test_S19869C14()
{
  extern Class_Descriptor cd_S19869C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S19869C14, buf);
    S19869C14 *dp, &lv = *(dp=new (buf) S19869C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S19869C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C14)");
    check_base_class_offset(lv, (S19869C15_nt*), ABISELECT(8,4), "S19869C14");
    /*is_ambiguous_... S19869C4::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), ABISELECT(17,13), "S19869C14");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(16,12), "S19869C14");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(16,12), "S19869C14");
    check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(16,12), "S19869C14");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), 0, "S19869C14");
    check_base_class_offset(lv, (S19869C8*)(S19869C4*), 0, "S19869C14");
    check_base_class_offset(lv, (S19869C4*), 0, "S19869C14");
    /*is_ambiguous_... S19869C14::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*), ABISELECT(16,12), "S19869C14");
    test_class_info(&lv, &cd_S19869C14);
    dp->~S19869C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C14(Test_S19869C14, "S19869C14", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN9S19869C14C1Ev();
extern void _ZN9S19869C14D2Ev();
Name_Map name_map_S19869C14[] = {
  NSPAIR(_ZN9S19869C14C1Ev),
  NSPAIR(_ZN9S19869C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
static Base_Class bases_S19869C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C15_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S246C12_nt,    ABISELECT(17,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(16,12), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19869C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S246C12_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C14[];
extern void _ZN9S19869C14D1Ev();
extern void _ZN9S19869C14D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C14D1Ev,_ZThn12_N9S19869C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C14D0Ev,_ZThn12_N9S19869C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C14[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(17,13),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&_ZN9S19869C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C14D0Ev,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C14[];
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C14[] = {
  ABISELECT(16,12),
  ABISELECT(17,13),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZThn16_N8S19869C4D1Ev,_ZThn12_N8S19869C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
extern void ABISELECT(_ZThn16_N8S19869C4D0Ev,_ZThn12_N8S19869C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C5__8S19869C4__9S19869C14[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
static  VTT_ENTRY vtt_S19869C14[] = {
  {&(_ZTV9S19869C14[6]),  6,13},
  {&(_ZTV9S19869C14[6]),  6,13},
  {&(_ZTV9S19869C14[11]),  11,13},
  {&(_tg__ZTV8S19869C4__9S19869C14[4]),  4,6},
  {&(_tg__ZTV8S19869C5__8S19869C4__9S19869C14[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C14[];
extern  VTBL_ENTRY _ZTV9S19869C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C14[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19869C4D0Ev,_ZThn12_N8S19869C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19869C4D1Ev,_ZThn12_N8S19869C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C14D0Ev,_ZThn12_N9S19869C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C14D1Ev,_ZThn12_N9S19869C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C14 = {  "S19869C14", // class name
  bases_S19869C14, 9,
  &(vtc_S19869C14[0]), // expected_vtbl_contents
  &(vtt_S19869C14[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI9S19869C14),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19869C14),13, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C14),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C16  : virtual S246C12_nt {
  virtual  ~S19869C16(); // _ZN9S19869C16D2Ev
  virtual void  v1(); // _ZN9S19869C162v1Ev
  S19869C16(); // tgen
};
//SIG(-1 S19869C16) C1{ VBC2{ m} vd v1}


 S19869C16 ::~S19869C16(){ note_dtor("S19869C16", this);}
void  S19869C16 ::v1(){vfunc_called(this, "_ZN9S19869C162v1Ev");}
S19869C16 ::S19869C16(){ note_ctor("S19869C16", this);} // tgen

static void Test_S19869C16()
{
  extern Class_Descriptor cd_S19869C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S19869C16, buf);
    S19869C16 *dp, &lv = *(dp=new (buf) S19869C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S19869C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C16)");
    check_base_class_offset(lv, (S246C12_nt*), 0, "S19869C16");
    test_class_info(&lv, &cd_S19869C16);
    dp->~S19869C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C16(Test_S19869C16, "S19869C16", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S19869C16C1Ev();
extern void _ZN9S19869C16D2Ev();
Name_Map name_map_S19869C16[] = {
  NSPAIR(_ZN9S19869C16C1Ev),
  NSPAIR(_ZN9S19869C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
static Base_Class bases_S19869C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C16[];
extern void _ZN9S19869C16D1Ev();
extern void _ZN9S19869C16D0Ev();
extern void _ZN9S19869C162v1Ev();
static  VTBL_ENTRY vtc_S19869C16[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C16[0]),
  (VTBL_ENTRY)&_ZN9S19869C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C16D0Ev,
  (VTBL_ENTRY)&_ZN9S19869C162v1Ev,
};
extern VTBL_ENTRY _ZTV9S19869C16[];
static  VTT_ENTRY vtt_S19869C16[] = {
  {&(_ZTV9S19869C16[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S19869C16[];
extern  VTBL_ENTRY _ZTV9S19869C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C16[];
Class_Descriptor cd_S19869C16 = {  "S19869C16", // class name
  bases_S19869C16, 1,
  &(vtc_S19869C16[0]), // expected_vtbl_contents
  &(vtt_S19869C16[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S19869C16),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19869C16),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C16),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C17  : virtual S19869C6 , virtual S19869C15_nt , S246C12_nt {
  ~S19869C17(); // tgen
  S19869C17(); // tgen
};
//SIG(-1 S19869C17) C1{ VBC2{ BC3{ vd m} vd} VBC4{ m FL} BC5{ m}}


S19869C17 ::~S19869C17(){ note_dtor("S19869C17", this);} // tgen
S19869C17 ::S19869C17(){ note_ctor("S19869C17", this);} // tgen

static void Test_S19869C17()
{
  extern Class_Descriptor cd_S19869C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S19869C17, buf);
    S19869C17 *dp, &lv = *(dp=new (buf) S19869C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S19869C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C17)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), 0, "S19869C17");
    check_base_class_offset(lv, (S19869C6*), 0, "S19869C17");
    check_base_class_offset(lv, (S19869C15_nt*), ABISELECT(8,4), "S19869C17");
    check_base_class_offset(lv, (S246C12_nt*), 0, "S19869C17");
    test_class_info(&lv, &cd_S19869C17);
    dp->~S19869C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C17(Test_S19869C17, "S19869C17", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN9S19869C17C1Ev();
extern void _ZN9S19869C17D1Ev();
Name_Map name_map_S19869C17[] = {
  NSPAIR(_ZN9S19869C17C1Ev),
  NSPAIR(_ZN9S19869C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
static Base_Class bases_S19869C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C15_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C17[];
extern void _ZN9S19869C17D1Ev();
extern void _ZN9S19869C17D0Ev();
static  VTBL_ENTRY vtc_S19869C17[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C17[0]),
  (VTBL_ENTRY)&_ZN9S19869C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C17D0Ev,
};
extern VTBL_ENTRY _ZTV9S19869C17[];
static  VTT_ENTRY vtt_S19869C17[] = {
  {&(_ZTV9S19869C17[5]),  5,7},
  {&(_ZTV9S19869C17[5]),  5,7},
};
extern VTBL_ENTRY _ZTI9S19869C17[];
extern  VTBL_ENTRY _ZTV9S19869C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C17[];
Class_Descriptor cd_S19869C17 = {  "S19869C17", // class name
  bases_S19869C17, 4,
  &(vtc_S19869C17[0]), // expected_vtbl_contents
  &(vtt_S19869C17[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI9S19869C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19869C17),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C17),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C9  : virtual S19869C10 , virtual S19869C5 , virtual S19869C14 , virtual S19869C16 , S19869C17 {
  virtual  ~S19869C9(); // _ZN8S19869C9D2Ev
  S19869C9(); // tgen
};
//SIG(-1 S19869C9) C1{ VBC2{ VBC3{ m} VBC4{ vd m} VBC5{ BC6{ BC7{ BC4 vd} vd} VBC4 VBC7 VBC8{ BC9{ BC7 vd FC7} BC6 Fl Fi} Fi}} VBC9 VBC10{ BC11{ m FL} VBC12{ VBC3 VBC9 BC13{ BC3}} BC3 vd} VBC14{ VBC3 vd v1} BC15{ VBC7 VBC11 BC3} vd}


 S19869C9 ::~S19869C9(){ note_dtor("S19869C9", this);}
S19869C9 ::S19869C9(){ note_ctor("S19869C9", this);} // tgen

static void Test_S19869C9()
{
  extern Class_Descriptor cd_S19869C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,19)];
    init_test(&cd_S19869C9, buf);
    S19869C9 *dp, &lv = *(dp=new (buf) S19869C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,72), "sizeof(S19869C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C9)");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C10*), ABISELECT(16,8), "S19869C9");
    /*is_ambiguous_... S19869C4::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), ABISELECT(16,8), "S19869C9");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C16*), ABISELECT(16,8), "S19869C9");
    /*is_ambiguous_... S19869C10::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C10*), ABISELECT(8,4), "S19869C9");
    /*is_ambiguous_... S19869C11::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C11*), ABISELECT(8,4), "S19869C9");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(16,8), "S19869C9");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(16,8), "S19869C9");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C12*)(S19869C11*), ABISELECT(16,8), "S19869C9");
    /*is_ambiguous_... S19869C9::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), 0, "S19869C9");
    /*is_ambiguous_... S19869C11::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C11*), 0, "S19869C9");
    check_base_class_offset(lv, (S19869C6*)(S19869C17*), 0, "S19869C9");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C9");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C9");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*), ABISELECT(32,16), "S19869C9");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C9");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C9");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*), ABISELECT(48,24), "S19869C9");
    check_base_class_offset(lv, (S19869C13*)(S19869C11*), ABISELECT(32,16), "S19869C9");
    check_base_class_offset(lv, (S19869C11*)(S19869C10*), ABISELECT(16,8), "S19869C9");
    check_base_class_offset(lv, (S19869C10*), ABISELECT(8,4), "S19869C9");
    /*is_ambiguous_... S19869C9::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(72,36), "S19869C9");
    /*is_ambiguous_... S19869C9::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(72,36), "S19869C9");
    /*is_ambiguous_... S19869C9::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*), ABISELECT(72,36), "S19869C9");
    check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(72,36), "S19869C9");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C14*), ABISELECT(96,48), "S19869C9");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), ABISELECT(88,44), "S19869C9");
    check_base_class_offset(lv, (S19869C8*)(S19869C4*), ABISELECT(88,44), "S19869C9");
    check_base_class_offset(lv, (S19869C4*)(S19869C14*), ABISELECT(88,44), "S19869C9");
    /*is_ambiguous_... S19869C14::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C14*), ABISELECT(104,56), "S19869C9");
    check_base_class_offset(lv, (S19869C14*), ABISELECT(88,44), "S19869C9");
    check_base_class_offset(lv, (S19869C16*), ABISELECT(112,60), "S19869C9");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C17*), ABISELECT(120,64), "S19869C9");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C17*), 0, "S19869C9");
    check_base_class_offset(lv, (S19869C17*), 0, "S19869C9");
    test_class_info(&lv, &cd_S19869C9);
    dp->~S19869C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C9(Test_S19869C9, "S19869C9", ABISELECT(128,72));

#else // __cplusplus

extern void _ZN8S19869C9C1Ev();
extern void _ZN8S19869C9D2Ev();
Name_Map name_map_S19869C9[] = {
  NSPAIR(_ZN8S19869C9C1Ev),
  NSPAIR(_ZN8S19869C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
extern Class_Descriptor cd_S19869C11;
extern VTBL_ENTRY _ZTI9S19869C11[];
extern  VTBL_ENTRY _ZTV9S19869C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C11[];
extern Class_Descriptor cd_S19869C10;
extern VTBL_ENTRY _ZTI9S19869C10[];
extern  VTBL_ENTRY _ZTV9S19869C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C10[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C14;
extern VTBL_ENTRY _ZTI9S19869C14[];
extern  VTBL_ENTRY _ZTV9S19869C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C14[];
extern Class_Descriptor cd_S19869C16;
extern VTBL_ENTRY _ZTI9S19869C16[];
extern  VTBL_ENTRY _ZTV9S19869C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C16[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C17;
extern VTBL_ENTRY _ZTI9S19869C17[];
extern  VTBL_ENTRY _ZTV9S19869C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C17[];
static Base_Class bases_S19869C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(48,24), //bcp->offset
    39, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(32,16), //bcp->offset
    34, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C11,    ABISELECT(16,8), //bcp->offset
    26, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S19869C10,    ABISELECT(8,4), //bcp->offset
    16, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(72,36), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C15_nt,    ABISELECT(96,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19869C8,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19869C4,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(104,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19869C14,    ABISELECT(88,44), //bcp->offset
    48, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C16,    ABISELECT(112,60), //bcp->offset
    56, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C15_nt,    ABISELECT(120,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19869C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19869C9[];
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void _ZN8S19869C9D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
extern void _ZN8S19869C9D0Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn8_N8S19869C9D1Ev,_ZThn4_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn8_N8S19869C9D0Ev,_ZThn4_N8S19869C9D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19869C9D1Ev,_ZTv0_n24_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn16_N8S19869C9D1Ev,_ZThn8_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19869C9D0Ev,_ZTv0_n24_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn16_N8S19869C9D0Ev,_ZThn8_N8S19869C9D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S19869C9D1Ev,_ZThn16_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn32_N8S19869C9D0Ev,_ZThn16_N8S19869C9D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N8S19869C9D1Ev,_ZTvn8_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S19869C9D0Ev,_ZTvn8_n12_N8S19869C9D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn72_N8S19869C9D1Ev,_ZThn36_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn72_N8S19869C9D0Ev,_ZThn36_N8S19869C9D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19869C9D1Ev,_ZTv0_n20_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn88_N8S19869C9D1Ev,_ZThn44_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19869C9D0Ev,_ZTv0_n20_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn88_N8S19869C9D0Ev,_ZThn44_N8S19869C9D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19869C9D1Ev,_ZTv0_n16_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn112_N8S19869C9D1Ev,_ZThn60_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19869C9D0Ev,_ZTv0_n16_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn112_N8S19869C9D0Ev,_ZThn60_N8S19869C9D0Ev)() __attribute__((weak));
extern void _ZN9S19869C162v1Ev();
static  VTBL_ENTRY vtc_S19869C9[] = {
  ABISELECT(112,60),
  ABISELECT(88,44),
  ABISELECT(88,44),
  ABISELECT(72,36),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(8,4),
  ABISELECT(16,8),
  ABISELECT(8,4),
  ABISELECT(120,64),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C9D1Ev,_ZTv0_n24_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C9D0Ev,_ZTv0_n24_N8S19869C9D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S19869C9D1Ev,_ZTvn8_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S19869C9D0Ev,_ZTvn8_n12_N8S19869C9D0Ev),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
  0,
  ABISELECT(-88,-44),
  ABISELECT(-16,-8),
  ABISELECT(-72,-36),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C9D1Ev,_ZTv0_n20_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C9D0Ev,_ZTv0_n20_N8S19869C9D0Ev),
  0,
  ABISELECT(-112,-60),
  ABISELECT(-96,-52),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C9D1Ev,_ZTv0_n16_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C9D0Ev,_ZTv0_n16_N8S19869C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19869C162v1Ev,
};
extern VTBL_ENTRY _ZTV8S19869C9[];
extern void ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev)();
extern void _ZN9S19869C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev)();
extern void _ZN9S19869C17D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C17__8S19869C9[] = {
  ABISELECT(120,64),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void _ZN9S19869C10D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
extern void _ZN9S19869C10D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C10__8S19869C9[] = {
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev)();
extern void ABISELECT(_ZThn8_N9S19869C10D1Ev,_ZThn4_N9S19869C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev)();
extern void ABISELECT(_ZThn8_N9S19869C10D0Ev,_ZThn4_N9S19869C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C11__9S19869C10__8S19869C9[] = {
  ABISELECT(-8,-4),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__A1__9S19869C10__8S19869C9[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C10D1Ev,_ZThn12_N9S19869C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C10D0Ev,_ZThn12_N9S19869C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C13__9S19869C10__8S19869C9[] = {
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S19869C10D1Ev,_ZTvn8_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C10D0Ev,_ZTvn8_n12_N9S19869C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C13__A1__9S19869C10__8S19869C9[] = {
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C10D1Ev,_ZTvn8_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C10D0Ev,_ZTvn8_n12_N9S19869C10D0Ev),
};
extern void _ZN9S19869C11D1Ev();
extern void _ZN9S19869C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C11__8S19869C9[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&_ZN9S19869C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C11D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt__A1__9S19869C11__8S19869C9[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__A1__9S19869C11__8S19869C9[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C13__9S19869C11__8S19869C9[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C13__A1__9S19869C11__8S19869C9[] = {
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev)();
extern void _ZN9S19869C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev)();
extern void _ZN9S19869C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C14__8S19869C9[] = {
  0,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__9S19869C14__8S19869C9[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev),
};
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19869C4__8S19869C9[] = {
  ABISELECT(-16,-8),
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__8S19869C4__8S19869C9[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
extern void _ZN9S19869C16D1Ev();
extern void _ZN9S19869C16D0Ev();
extern void _ZN9S19869C162v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C16__8S19869C9[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C16[0]),
  (VTBL_ENTRY)&_ZN9S19869C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C16D0Ev,
  (VTBL_ENTRY)&_ZN9S19869C162v1Ev,
};
static  VTT_ENTRY vtt_S19869C9[] = {
  {&(_ZTV8S19869C9[14]),  14,64},
  {&(_tg__ZTV9S19869C17__8S19869C9[5]),  5,7},
  {&(_tg__ZTV9S19869C17__8S19869C9[5]),  5,7},
  {&(_ZTV8S19869C9[24]),  24,64},
  {&(_ZTV8S19869C9[24]),  24,64},
  {&(_ZTV8S19869C9[32]),  32,64},
  {&(_ZTV8S19869C9[14]),  14,64},
  {&(_ZTV8S19869C9[37]),  37,64},
  {&(_ZTV8S19869C9[41]),  41,64},
  {&(_ZTV8S19869C9[46]),  46,64},
  {&(_ZTV8S19869C9[54]),  54,64},
  {&(_ZTV8S19869C9[54]),  54,64},
  {&(_ZTV8S19869C9[61]),  61,64},
  {&(_tg__ZTV9S19869C10__8S19869C9[8]),  8,10},
  {&(_tg__ZTV9S19869C10__8S19869C9[8]),  8,10},
  {&(_tg__ZTV9S19869C11__9S19869C10__8S19869C9[6]),  6,8},
  {&(_tg__ZTV8S19869C6__A1__9S19869C10__8S19869C9[3]),  3,5},
  {&(_tg__ZTV9S19869C13__9S19869C10__8S19869C9[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C13__A1__9S19869C10__8S19869C9[2]),  2,4},
  {&(_tg__ZTV9S19869C11__8S19869C9[5]),  5,7},
  {&(_tg__ZTV11S19869C7_nt__A1__9S19869C11__8S19869C9[3]),  3,5},
  {&(_tg__ZTV8S19869C6__A1__9S19869C11__8S19869C9[3]),  3,5},
  {&(_tg__ZTV9S19869C13__9S19869C11__8S19869C9[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C13__A1__9S19869C11__8S19869C9[2]),  2,4},
  {&(_tg__ZTV9S19869C14__8S19869C9[6]),  6,8},
  {&(_tg__ZTV9S19869C14__8S19869C9[6]),  6,8},
  {&(_tg__ZTV8S19869C5__9S19869C14__8S19869C9[3]),  3,5},
  {&(_tg__ZTV8S19869C4__8S19869C9[4]),  4,6},
  {&(_tg__ZTV8S19869C5__8S19869C4__8S19869C9[3]),  3,5},
  {&(_tg__ZTV9S19869C16__8S19869C9[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S19869C9[];
extern  VTBL_ENTRY _ZTV8S19869C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C9[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev), // 
  (VTBL_ENTRY)_ZN9S19869C14D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev), // 
  (VTBL_ENTRY)_ZN9S19869C14D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C10D0Ev,_ZThn4_N9S19869C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C10D1Ev,_ZThn4_N9S19869C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C10D0Ev,_ZThn12_N9S19869C10D0Ev),
  (VTBL_ENTRY)_ZN9S19869C10D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C10D1Ev,_ZThn12_N9S19869C10D1Ev),
  (VTBL_ENTRY)_ZN9S19869C10D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19869C9D0Ev,_ZTv0_n16_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S19869C9D0Ev,_ZThn60_N8S19869C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19869C9D1Ev,_ZTv0_n16_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S19869C9D1Ev,_ZThn60_N8S19869C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19869C9D0Ev,_ZTv0_n20_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S19869C9D0Ev,_ZThn44_N8S19869C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19869C9D1Ev,_ZTv0_n20_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S19869C9D1Ev,_ZThn44_N8S19869C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19869C9D0Ev,_ZTv0_n24_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19869C9D0Ev,_ZThn8_N8S19869C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19869C9D1Ev,_ZTv0_n24_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19869C9D1Ev,_ZThn8_N8S19869C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S19869C9D0Ev,_ZThn36_N8S19869C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S19869C9D0Ev,_ZThn16_N8S19869C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C9D0Ev,_ZThn4_N8S19869C9D0Ev),
  (VTBL_ENTRY)_ZN8S19869C9D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S19869C9D1Ev,_ZThn36_N8S19869C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S19869C9D1Ev,_ZThn16_N8S19869C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C9D1Ev,_ZThn4_N8S19869C9D1Ev),
  (VTBL_ENTRY)_ZN8S19869C9D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C9 = {  "S19869C9", // class name
  bases_S19869C9, 29,
  &(vtc_S19869C9[0]), // expected_vtbl_contents
  &(vtt_S19869C9[0]), // expected_vtt_contents
  ABISELECT(128,72), // object size
  NSPAIRA(_ZTI8S19869C9),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19869C9),64, //virtual function table var
  14, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19869C9),30, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C19  : S19869C6 , S19869C7_nt , S246C12_nt , virtual S19869C15_nt {
  virtual  ~S19869C19(); // _ZN9S19869C19D2Ev
  S19869C19(); // tgen
};
//SIG(-1 S19869C19) C1{ BC2{ BC3{ vd m} vd} BC3 BC4{ m} VBC5{ m FL} vd}


 S19869C19 ::~S19869C19(){ note_dtor("S19869C19", this);}
S19869C19 ::S19869C19(){ note_ctor("S19869C19", this);} // tgen

static void Test_S19869C19()
{
  extern Class_Descriptor cd_S19869C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S19869C19, buf);
    S19869C19 *dp, &lv = *(dp=new (buf) S19869C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S19869C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C19)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), 0, "S19869C19");
    check_base_class_offset(lv, (S19869C6*), 0, "S19869C19");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*), ABISELECT(8,4), "S19869C19");
    check_base_class_offset(lv, (S246C12_nt*), 0, "S19869C19");
    check_base_class_offset(lv, (S19869C15_nt*), ABISELECT(16,8), "S19869C19");
    test_class_info(&lv, &cd_S19869C19);
    dp->~S19869C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C19(Test_S19869C19, "S19869C19", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN9S19869C19C1Ev();
extern void _ZN9S19869C19D2Ev();
Name_Map name_map_S19869C19[] = {
  NSPAIR(_ZN9S19869C19C1Ev),
  NSPAIR(_ZN9S19869C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
static Base_Class bases_S19869C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C15_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C19[];
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
extern void ABISELECT(_ZThn8_N9S19869C19D1Ev,_ZThn4_N9S19869C19D1Ev)();
extern void ABISELECT(_ZThn8_N9S19869C19D0Ev,_ZThn4_N9S19869C19D0Ev)();
static  VTBL_ENTRY vtc_S19869C19[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19869C19D1Ev,_ZThn4_N9S19869C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19869C19D0Ev,_ZThn4_N9S19869C19D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C19[];
static  VTT_ENTRY vtt_S19869C19[] = {
  {&(_ZTV9S19869C19[3]),  3,9},
};
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
Class_Descriptor cd_S19869C19 = {  "S19869C19", // class name
  bases_S19869C19, 5,
  &(vtc_S19869C19[0]), // expected_vtbl_contents
  &(vtt_S19869C19[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI9S19869C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19869C19),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C19),1, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C20  {
  ::S19869C6 s19869c20f0;
  void  mf19869c20(); // _ZN9S19869C2010mf19869c20Ev
};
//SIG(-1 S19869C20) C1{ m FC2{ BC3{ vd m} vd}}


void  S19869C20 ::mf19869c20(){}

static void Test_S19869C20()
{
  {
    init_simple_test("S19869C20");
    S19869C20 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S19869C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C20)");
    check_field_offset(lv, s19869c20f0, 0, "S19869C20.s19869c20f0");
  }
}
static Arrange_To_Call_Me vS19869C20(Test_S19869C20, "S19869C20", ABISELECT(8,4));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S19869C20[];
VTBL_ENTRY *P__ZTI9S19869C20 = _ZTI9S19869C20; 
Class_Descriptor cd_S19869C20 = {  "S19869C20", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S19869C20),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C18  : virtual S19869C19 , virtual S19869C8 , virtual S19869C20 , virtual S19869C13 {
  virtual  ~S19869C18(); // _ZN9S19869C18D2Ev
  S19869C18(); // tgen
};
//SIG(-1 S19869C18) C1{ VBC2{ BC3{ BC4{ vd m} vd} BC4 BC5{ m} VBC6{ m FL} vd} VBC7{ BC5} VBC8{ m FC3} VBC9{ BC10{ BC3 vd FC3} BC11{ BC3 vd} Fl Fi} vd}


 S19869C18 ::~S19869C18(){ note_dtor("S19869C18", this);}
S19869C18 ::S19869C18(){ note_ctor("S19869C18", this);} // tgen

static void Test_S19869C18()
{
  extern Class_Descriptor cd_S19869C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,12)];
    init_test(&cd_S19869C18, buf);
    S19869C18 *dp, &lv = *(dp=new (buf) S19869C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,44), "sizeof(S19869C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C18)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(8,4), "S19869C18");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(8,4), "S19869C18");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(16,8), "S19869C18");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(8,4), "S19869C18");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(24,12), "S19869C18");
    check_base_class_offset(lv, (S19869C19*), ABISELECT(8,4), "S19869C18");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), 0, "S19869C18");
    check_base_class_offset(lv, (S19869C8*), 0, "S19869C18");
    check_base_class_offset(lv, (S19869C20*), ABISELECT(32,20), "S19869C18");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(40,24), "S19869C18");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(40,24), "S19869C18");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*), ABISELECT(40,24), "S19869C18");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(56,32), "S19869C18");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(56,32), "S19869C18");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*), ABISELECT(56,32), "S19869C18");
    check_base_class_offset(lv, (S19869C13*), ABISELECT(40,24), "S19869C18");
    test_class_info(&lv, &cd_S19869C18);
    dp->~S19869C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C18(Test_S19869C18, "S19869C18", ABISELECT(80,44));

#else // __cplusplus

extern void _ZN9S19869C18C1Ev();
extern void _ZN9S19869C18D2Ev();
Name_Map name_map_S19869C18[] = {
  NSPAIR(_ZN9S19869C18C1Ev),
  NSPAIR(_ZN9S19869C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
static Base_Class bases_S19869C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C15_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19869C19,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C20,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(56,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(40,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C18[];
extern void _ZN9S19869C18D1Ev();
extern void _ZN9S19869C18D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S19869C18D1Ev,_ZTv0_n16_N9S19869C18D1Ev)();
extern void ABISELECT(_ZThn8_N9S19869C18D1Ev,_ZThn4_N9S19869C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C18D0Ev,_ZTv0_n16_N9S19869C18D0Ev)();
extern void ABISELECT(_ZThn8_N9S19869C18D0Ev,_ZThn4_N9S19869C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S19869C18D1Ev,_ZTvn4_n16_N9S19869C18D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C18D0Ev,_ZTvn4_n16_N9S19869C18D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C18D1Ev,_ZTv0_n12_N9S19869C18D1Ev)();
extern void ABISELECT(_ZThn40_N9S19869C18D1Ev,_ZThn24_N9S19869C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C18D0Ev,_ZTv0_n12_N9S19869C18D0Ev)();
extern void ABISELECT(_ZThn40_N9S19869C18D0Ev,_ZThn24_N9S19869C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S19869C18D1Ev,_ZTvn8_n12_N9S19869C18D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C18D0Ev,_ZTvn8_n12_N9S19869C18D0Ev)();
static  VTBL_ENTRY vtc_S19869C18[] = {
  ABISELECT(40,24),
  ABISELECT(32,20),
  0,
  ABISELECT(24,12),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&_ZN9S19869C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C18D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(16,8),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C18D1Ev,_ZTv0_n16_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C18D0Ev,_ZTv0_n16_N9S19869C18D0Ev),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C18D1Ev,_ZTvn4_n16_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C18D0Ev,_ZTvn4_n16_N9S19869C18D0Ev),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C18D1Ev,_ZTv0_n12_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C18D0Ev,_ZTv0_n12_N9S19869C18D0Ev),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C18D1Ev,_ZTvn8_n12_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C18D0Ev,_ZTvn8_n12_N9S19869C18D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C18[];
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C18[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
static  VTT_ENTRY vtt_S19869C18[] = {
  {&(_ZTV9S19869C18[7]),  7,28},
  {&(_ZTV9S19869C18[13]),  13,28},
  {&(_ZTV9S19869C18[17]),  17,28},
  {&(_ZTV9S19869C18[22]),  22,28},
  {&(_ZTV9S19869C18[26]),  26,28},
  {&(_tg__ZTV9S19869C19__9S19869C18[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C18[];
extern  VTBL_ENTRY _ZTV9S19869C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C18[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C18D0Ev,_ZTv0_n12_N9S19869C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C18D0Ev,_ZThn24_N9S19869C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C18D1Ev,_ZTv0_n12_N9S19869C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C18D1Ev,_ZThn24_N9S19869C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C18D0Ev,_ZTv0_n16_N9S19869C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C18D0Ev,_ZThn4_N9S19869C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C18D1Ev,_ZTv0_n16_N9S19869C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C18D1Ev,_ZThn4_N9S19869C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C18 = {  "S19869C18", // class name
  bases_S19869C18, 16,
  &(vtc_S19869C18[0]), // expected_vtbl_contents
  &(vtt_S19869C18[0]), // expected_vtt_contents
  ABISELECT(80,44), // object size
  NSPAIRA(_ZTI9S19869C18),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19869C18),28, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C18),6, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C21  : S19869C5 , virtual S19869C4 {
  int s19869c21f0:3;
  ~S19869C21(); // tgen
  S19869C21(); // tgen
};
//SIG(-1 S19869C21) C1{ BC2{ BC3{ BC4{ vd m} vd} vd FC3} VBC5{ VBC6{ m} VBC2 BC7{ BC6}} Fi:3}


S19869C21 ::~S19869C21(){ note_dtor("S19869C21", this);} // tgen
S19869C21 ::S19869C21(){ note_ctor("S19869C21", this);} // tgen

static void Test_S19869C21()
{
  extern Class_Descriptor cd_S19869C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_S19869C21, buf);
    S19869C21 *dp, &lv = *(dp=new (buf) S19869C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S19869C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C21)");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), 0, "S19869C21");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*), 0, "S19869C21");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*), 0, "S19869C21");
    /*is_ambiguous_... S19869C4::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), 0, "S19869C21");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(32,16), "S19869C21");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(32,16), "S19869C21");
    check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(32,16), "S19869C21");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), ABISELECT(24,12), "S19869C21");
    check_base_class_offset(lv, (S19869C8*)(S19869C4*), ABISELECT(24,12), "S19869C21");
    check_base_class_offset(lv, (S19869C4*), ABISELECT(24,12), "S19869C21");
    set_bf_and_test(lv, s19869c21f0, ABISELECT(16,8), 0, 3, 1, "S19869C21");
    set_bf_and_test(lv, s19869c21f0, ABISELECT(16,8), 0, 3, hide_sll(1LL<<2), "S19869C21");
    test_class_info(&lv, &cd_S19869C21);
    dp->~S19869C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C21(Test_S19869C21, "S19869C21", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN9S19869C21C1Ev();
extern void _ZN9S19869C21D1Ev();
Name_Map name_map_S19869C21[] = {
  NSPAIR(_ZN9S19869C21C1Ev),
  NSPAIR(_ZN9S19869C21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
static Base_Class bases_S19869C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C8,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C4,    ABISELECT(24,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C21[];
extern void _ZN9S19869C21D1Ev();
extern void _ZN9S19869C21D0Ev();
extern void ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C21D1Ev,_ZThn12_N9S19869C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C21D0Ev,_ZThn12_N9S19869C21D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C21D1Ev,_ZThn16_N9S19869C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C21D0Ev,_ZThn16_N9S19869C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C21[] = {
  ABISELECT(32,16),
  0,
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&_ZN9S19869C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C21D0Ev,
  ABISELECT(-24,-12),
  ABISELECT(8,4),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C21[];
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C21[] = {
  ABISELECT(8,4),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZThn8_N8S19869C4D1Ev,_ZThn4_N8S19869C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
extern void ABISELECT(_ZThn8_N8S19869C4D0Ev,_ZThn4_N8S19869C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C5__8S19869C4__9S19869C21[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
static  VTT_ENTRY vtt_S19869C21[] = {
  {&(_ZTV9S19869C21[5]),  5,19},
  {&(_ZTV9S19869C21[12]),  12,19},
  {&(_ZTV9S19869C21[17]),  17,19},
  {&(_tg__ZTV8S19869C4__9S19869C21[4]),  4,6},
  {&(_tg__ZTV8S19869C5__8S19869C4__9S19869C21[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C21[];
extern  VTBL_ENTRY _ZTV9S19869C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C21[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C4D0Ev,_ZThn4_N8S19869C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C4D1Ev,_ZThn4_N8S19869C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C21D0Ev,_ZThn16_N9S19869C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C21D1Ev,_ZThn16_N9S19869C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C21D0Ev,_ZThn12_N9S19869C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C21D1Ev,_ZThn12_N9S19869C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C21 = {  "S19869C21", // class name
  bases_S19869C21, 10,
  &(vtc_S19869C21[0]), // expected_vtbl_contents
  &(vtt_S19869C21[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI9S19869C21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19869C21),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C21),5, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C25  : S19869C5 , virtual S19869C19 {
  int s19869c25f0;
  ~S19869C25(); // tgen
  S19869C25(); // tgen
};
//SIG(-1 S19869C25) C1{ BC2{ BC3{ BC4{ vd m} vd} vd FC3} VBC5{ BC3 BC4 BC6{ m} VBC7{ m FL} vd} Fi}


S19869C25 ::~S19869C25(){ note_dtor("S19869C25", this);} // tgen
S19869C25 ::S19869C25(){ note_ctor("S19869C25", this);} // tgen

static void Test_S19869C25()
{
  extern Class_Descriptor cd_S19869C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S19869C25, buf);
    S19869C25 *dp, &lv = *(dp=new (buf) S19869C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S19869C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C25)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), 0, "S19869C25");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*), 0, "S19869C25");
    check_base_class_offset(lv, (S19869C5*), 0, "S19869C25");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(24,12), "S19869C25");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(24,12), "S19869C25");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(32,16), "S19869C25");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(24,12), "S19869C25");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(40,20), "S19869C25");
    check_base_class_offset(lv, (S19869C19*), ABISELECT(24,12), "S19869C25");
    check_field_offset(lv, s19869c25f0, ABISELECT(16,8), "S19869C25.s19869c25f0");
    test_class_info(&lv, &cd_S19869C25);
    dp->~S19869C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C25(Test_S19869C25, "S19869C25", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN9S19869C25C1Ev();
extern void _ZN9S19869C25D1Ev();
Name_Map name_map_S19869C25[] = {
  NSPAIR(_ZN9S19869C25C1Ev),
  NSPAIR(_ZN9S19869C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
static Base_Class bases_S19869C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C15_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19869C19,    ABISELECT(24,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C25[];
extern void _ZN9S19869C25D1Ev();
extern void _ZN9S19869C25D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C25D1Ev,_ZThn12_N9S19869C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C25D0Ev,_ZThn12_N9S19869C25D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev)();
static  VTBL_ENTRY vtc_S19869C25[] = {
  ABISELECT(40,20),
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&_ZN9S19869C25D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C25D0Ev,
  ABISELECT(-24,-12),
  ABISELECT(16,8),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C25[];
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C25[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
static  VTT_ENTRY vtt_S19869C25[] = {
  {&(_ZTV9S19869C25[4]),  4,16},
  {&(_ZTV9S19869C25[10]),  10,16},
  {&(_ZTV9S19869C25[14]),  14,16},
  {&(_tg__ZTV9S19869C19__9S19869C25[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C25[];
extern  VTBL_ENTRY _ZTV9S19869C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C25[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C25D0Ev,_ZThn12_N9S19869C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C25D1Ev,_ZThn12_N9S19869C25D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C25 = {  "S19869C25", // class name
  bases_S19869C25, 9,
  &(vtc_S19869C25[0]), // expected_vtbl_contents
  &(vtt_S19869C25[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI9S19869C25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19869C25),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C25),4, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C26_nt  {
  void *s19869c26f0;
  void  mf19869c26(); // _ZN12S19869C26_nt10mf19869c26Ev
};
//SIG(-1 S19869C26_nt) C1{ m Fp}


void  S19869C26_nt ::mf19869c26(){}

//skip512 S19869C26_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S19869C26_nt[];
VTBL_ENTRY *P__ZTI12S19869C26_nt = _ZTI12S19869C26_nt; 
Class_Descriptor cd_S19869C26_nt = {  "S19869C26_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S19869C26_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C24  : S19869C25 , virtual S19869C26_nt , virtual S19869C6 , S19869C20 {
  ~S19869C24(); // tgen
  S19869C24(); // tgen
};
//SIG(-1 S19869C24) C1{ BC2{ BC3{ BC4{ BC5{ vd m} vd} vd FC4} VBC6{ BC4 BC5 BC7{ m} VBC8{ m FL} vd} Fi} VBC9{ m Fp} VBC4 BC10{ m FC4}}


S19869C24 ::~S19869C24(){ note_dtor("S19869C24", this);} // tgen
S19869C24 ::S19869C24(){ note_ctor("S19869C24", this);} // tgen

static void Test_S19869C24()
{
  extern Class_Descriptor cd_S19869C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S19869C24, buf);
    S19869C24 *dp, &lv = *(dp=new (buf) S19869C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S19869C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C24)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C25*), 0, "S19869C24");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C25*), 0, "S19869C24");
    check_base_class_offset(lv, (S19869C5*)(S19869C25*), 0, "S19869C24");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(32,16), "S19869C24");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(32,16), "S19869C24");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(40,20), "S19869C24");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(32,16), "S19869C24");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(48,24), "S19869C24");
    check_base_class_offset(lv, (S19869C19*)(S19869C25*), ABISELECT(32,16), "S19869C24");
    check_base_class_offset(lv, (S19869C25*), 0, "S19869C24");
    check_base_class_offset(lv, (S19869C26_nt*), ABISELECT(56,32), "S19869C24");
    /*is_ambiguous_... S19869C24::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(64,36), "S19869C24");
    /*is_ambiguous_... S19869C24::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*), ABISELECT(64,36), "S19869C24");
    check_base_class_offset(lv, (S19869C20*), ABISELECT(24,12), "S19869C24");
    test_class_info(&lv, &cd_S19869C24);
    dp->~S19869C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C24(Test_S19869C24, "S19869C24", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN9S19869C24C1Ev();
extern void _ZN9S19869C24D1Ev();
Name_Map name_map_S19869C24[] = {
  NSPAIR(_ZN9S19869C24C1Ev),
  NSPAIR(_ZN9S19869C24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C25;
extern VTBL_ENTRY _ZTI9S19869C25[];
extern  VTBL_ENTRY _ZTV9S19869C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C25[];
extern Class_Descriptor cd_S19869C26_nt;
extern VTBL_ENTRY _ZTI12S19869C26_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
static Base_Class bases_S19869C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(40,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C15_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19869C19,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S19869C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C26_nt,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(64,36), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C20,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C24[];
extern void _ZN9S19869C24D1Ev();
extern void _ZN9S19869C24D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C24D1Ev,_ZThn16_N9S19869C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C24D0Ev,_ZThn16_N9S19869C24D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev)();
extern void ABISELECT(_ZThn64_N9S19869C24D1Ev,_ZThn36_N9S19869C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev)();
extern void ABISELECT(_ZThn64_N9S19869C24D0Ev,_ZThn36_N9S19869C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C24[] = {
  ABISELECT(64,36),
  ABISELECT(56,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&_ZN9S19869C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C24D0Ev,
  ABISELECT(-32,-16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev),
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C24[];
extern void _ZN9S19869C25D1Ev();
extern void _ZN9S19869C25D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C25__9S19869C24[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&_ZN9S19869C25D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C25D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C25D1Ev,_ZThn16_N9S19869C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C25D0Ev,_ZThn16_N9S19869C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C25__9S19869C24[] = {
  ABISELECT(-32,-16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C25__9S19869C24[] = {
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev),
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C24[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
static  VTT_ENTRY vtt_S19869C24[] = {
  {&(_ZTV9S19869C24[6]),  6,23},
  {&(_tg__ZTV9S19869C25__9S19869C24[4]),  4,6},
  {&(_tg__ZTV9S19869C19__9S19869C25__9S19869C24[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C25__9S19869C24[2]),  2,4},
  {&(_ZTV9S19869C24[12]),  12,23},
  {&(_ZTV9S19869C24[16]),  16,23},
  {&(_ZTV9S19869C24[21]),  21,23},
  {&(_tg__ZTV9S19869C19__9S19869C24[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C24[];
extern  VTBL_ENTRY _ZTV9S19869C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C24[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C25D0Ev,_ZThn16_N9S19869C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C25D1Ev,_ZThn16_N9S19869C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19869C24D0Ev,_ZThn36_N9S19869C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19869C24D1Ev,_ZThn36_N9S19869C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C24D0Ev,_ZThn16_N9S19869C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C24D1Ev,_ZThn16_N9S19869C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C24 = {  "S19869C24", // class name
  bases_S19869C24, 14,
  &(vtc_S19869C24[0]), // expected_vtbl_contents
  &(vtt_S19869C24[0]), // expected_vtt_contents
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI9S19869C24),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19869C24),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C24),8, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C23  : virtual S19869C24 , S19869C13 {
  virtual  ~S19869C23(); // _ZN9S19869C23D2Ev
  S19869C23(); // tgen
};
//SIG(-1 S19869C23) C1{ VBC2{ BC3{ BC4{ BC5{ BC6{ vd m} vd} vd FC5} VBC7{ BC5 BC6 BC8{ m} VBC9{ m FL} vd} Fi} VBC10{ m Fp} VBC5 BC11{ m FC5}} BC12{ BC4 BC13{ BC5 vd} Fl Fi} vd}


 S19869C23 ::~S19869C23(){ note_dtor("S19869C23", this);}
S19869C23 ::S19869C23(){ note_ctor("S19869C23", this);} // tgen

static void Test_S19869C23()
{
  extern Class_Descriptor cd_S19869C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,16)];
    init_test(&cd_S19869C23, buf);
    S19869C23 *dp, &lv = *(dp=new (buf) S19869C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,60), "sizeof(S19869C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C23)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(40,20), "S19869C23");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(40,20), "S19869C23");
    check_base_class_offset(lv, (S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(40,20), "S19869C23");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(72,36), "S19869C23");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(72,36), "S19869C23");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(80,40), "S19869C23");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(72,36), "S19869C23");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(88,44), "S19869C23");
    check_base_class_offset(lv, (S19869C19*)(S19869C25*)(S19869C24*), ABISELECT(72,36), "S19869C23");
    check_base_class_offset(lv, (S19869C25*)(S19869C24*), ABISELECT(40,20), "S19869C23");
    check_base_class_offset(lv, (S19869C26_nt*)(S19869C24*), ABISELECT(96,52), "S19869C23");
    /*is_ambiguous_... S19869C23::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(104,56), "S19869C23");
    /*is_ambiguous_... S19869C24::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C24*), ABISELECT(104,56), "S19869C23");
    check_base_class_offset(lv, (S19869C20*)(S19869C24*), ABISELECT(64,32), "S19869C23");
    check_base_class_offset(lv, (S19869C24*), ABISELECT(40,20), "S19869C23");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*), 0, "S19869C23");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*), 0, "S19869C23");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*), 0, "S19869C23");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(16,8), "S19869C23");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(16,8), "S19869C23");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*), ABISELECT(16,8), "S19869C23");
    check_base_class_offset(lv, (S19869C13*), 0, "S19869C23");
    test_class_info(&lv, &cd_S19869C23);
    dp->~S19869C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C23(Test_S19869C23, "S19869C23", ABISELECT(112,60));

#else // __cplusplus

extern void _ZN9S19869C23C1Ev();
extern void _ZN9S19869C23D2Ev();
Name_Map name_map_S19869C23[] = {
  NSPAIR(_ZN9S19869C23C1Ev),
  NSPAIR(_ZN9S19869C23D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C25;
extern VTBL_ENTRY _ZTI9S19869C25[];
extern  VTBL_ENTRY _ZTV9S19869C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C25[];
extern Class_Descriptor cd_S19869C26_nt;
extern VTBL_ENTRY _ZTI12S19869C26_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
extern Class_Descriptor cd_S19869C24;
extern VTBL_ENTRY _ZTI9S19869C24[];
extern  VTBL_ENTRY _ZTV9S19869C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C24[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
static Base_Class bases_S19869C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(80,40), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C15_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19869C19,    ABISELECT(72,36), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S19869C25,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C26_nt,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(104,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(104,56), //bcp->offset
    32, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C20,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C24,    ABISELECT(40,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(16,8), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19869C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C23[];
extern void _ZN9S19869C23D1Ev();
extern void _ZN9S19869C23D0Ev();
extern void ABISELECT(_ZThn16_N9S19869C23D1Ev,_ZThn8_N9S19869C23D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C23D0Ev,_ZThn8_N9S19869C23D0Ev)();
extern void ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev)();
extern void ABISELECT(_ZThn40_N9S19869C23D1Ev,_ZThn20_N9S19869C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev)();
extern void ABISELECT(_ZThn40_N9S19869C23D0Ev,_ZThn20_N9S19869C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C23D1Ev,_ZTv0_n16_N9S19869C23D1Ev)();
extern void ABISELECT(_ZThn72_N9S19869C23D1Ev,_ZThn36_N9S19869C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C23D0Ev,_ZTv0_n16_N9S19869C23D0Ev)();
extern void ABISELECT(_ZThn72_N9S19869C23D0Ev,_ZThn36_N9S19869C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S19869C23D1Ev,_ZTvn4_n16_N9S19869C23D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C23D0Ev,_ZTvn4_n16_N9S19869C23D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev)();
extern void ABISELECT(_ZThn104_N9S19869C23D1Ev,_ZThn56_N9S19869C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev)();
extern void ABISELECT(_ZThn104_N9S19869C23D0Ev,_ZThn56_N9S19869C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C23[] = {
  ABISELECT(104,56),
  ABISELECT(96,52),
  ABISELECT(88,44),
  ABISELECT(72,36),
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&_ZN9S19869C23D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C23D0Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19869C23D1Ev,_ZThn8_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19869C23D0Ev,_ZThn8_N9S19869C23D0Ev),
  ABISELECT(-40,-20),
  ABISELECT(64,36),
  ABISELECT(56,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev),
  ABISELECT(-72,-36),
  ABISELECT(16,8),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C23D1Ev,_ZTv0_n16_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C23D0Ev,_ZTv0_n16_N9S19869C23D0Ev),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C23D1Ev,_ZTvn4_n16_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C23D0Ev,_ZTvn4_n16_N9S19869C23D0Ev),
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C23[];
extern void _ZN9S19869C24D1Ev();
extern void _ZN9S19869C24D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C24__9S19869C23[] = {
  ABISELECT(64,36),
  ABISELECT(56,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&_ZN9S19869C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C24D0Ev,
};
extern void _ZN9S19869C25D1Ev();
extern void _ZN9S19869C25D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C259S19869C24__9S19869C23[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&_ZN9S19869C25D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C25D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C25D1Ev,_ZThn16_N9S19869C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C25D0Ev,_ZThn16_N9S19869C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C259S19869C24__9S19869C23[] = {
  ABISELECT(-32,-16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C259S19869C24__9S19869C23[] = {
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C24D1Ev,_ZThn16_N9S19869C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C24D0Ev,_ZThn16_N9S19869C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C24__9S19869C23[] = {
  ABISELECT(-32,-16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C24__9S19869C23[] = {
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev)();
extern void ABISELECT(_ZThn64_N9S19869C24D1Ev,_ZThn36_N9S19869C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev)();
extern void ABISELECT(_ZThn64_N9S19869C24D0Ev,_ZThn36_N9S19869C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C6__A2__9S19869C24__9S19869C23[] = {
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev),
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C23[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
static  VTT_ENTRY vtt_S19869C23[] = {
  {&(_ZTV9S19869C23[7]),  7,37},
  {&(_ZTV9S19869C23[20]),  20,37},
  {&(_ZTV9S19869C23[26]),  26,37},
  {&(_ZTV9S19869C23[30]),  30,37},
  {&(_ZTV9S19869C23[35]),  35,37},
  {&(_tg__ZTV9S19869C24__9S19869C23[6]),  6,8},
  {&(_tg__ZTV9S19869C259S19869C24__9S19869C23[4]),  4,6},
  {&(_tg__ZTV9S19869C19__9S19869C259S19869C24__9S19869C23[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C259S19869C24__9S19869C23[2]),  2,4},
  {&(_tg__ZTV9S19869C19__9S19869C24__9S19869C23[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C24__9S19869C23[2]),  2,4},
  {&(_tg__ZTV8S19869C6__A2__9S19869C24__9S19869C23[3]),  3,5},
  {&(_tg__ZTV9S19869C19__9S19869C23[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C23[];
extern  VTBL_ENTRY _ZTV9S19869C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C23[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19869C24D0Ev,_ZThn36_N9S19869C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19869C24D1Ev,_ZThn36_N9S19869C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C24D0Ev,_ZThn16_N9S19869C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C24D1Ev,_ZThn16_N9S19869C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C25D0Ev,_ZThn16_N9S19869C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C25D1Ev,_ZThn16_N9S19869C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S19869C23D0Ev,_ZThn56_N9S19869C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S19869C23D1Ev,_ZThn56_N9S19869C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C23D0Ev,_ZTv0_n16_N9S19869C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C23D0Ev,_ZThn36_N9S19869C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C23D1Ev,_ZTv0_n16_N9S19869C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C23D1Ev,_ZThn36_N9S19869C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C23D0Ev,_ZThn20_N9S19869C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C23D1Ev,_ZThn20_N9S19869C23D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C23 = {  "S19869C23", // class name
  bases_S19869C23, 22,
  &(vtc_S19869C23[0]), // expected_vtbl_contents
  &(vtt_S19869C23[0]), // expected_vtt_contents
  ABISELECT(112,60), // object size
  NSPAIRA(_ZTI9S19869C23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19869C23),37, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C23),13, //virtual table table var
  18, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C28  : virtual S19869C8 , virtual S19869C12 , S19869C19 {
  virtual  ~S19869C28(); // _ZN9S19869C28D2Ev
  S19869C28(); // tgen
};
//SIG(-1 S19869C28) C1{ VBC2{ BC3{ m}} VBC4{ BC5{ BC6{ vd m} vd} vd} BC7{ BC5 BC6 BC3 VBC8{ m FL} vd} vd}


 S19869C28 ::~S19869C28(){ note_dtor("S19869C28", this);}
S19869C28 ::S19869C28(){ note_ctor("S19869C28", this);} // tgen

static void Test_S19869C28()
{
  extern Class_Descriptor cd_S19869C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S19869C28, buf);
    S19869C28 *dp, &lv = *(dp=new (buf) S19869C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S19869C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C28)");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), ABISELECT(16,8), "S19869C28");
    check_base_class_offset(lv, (S19869C8*), ABISELECT(16,8), "S19869C28");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(16,8), "S19869C28");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(16,8), "S19869C28");
    check_base_class_offset(lv, (S19869C12*), ABISELECT(16,8), "S19869C28");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), 0, "S19869C28");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*), 0, "S19869C28");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(8,4), "S19869C28");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), 0, "S19869C28");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(24,12), "S19869C28");
    check_base_class_offset(lv, (S19869C19*), 0, "S19869C28");
    test_class_info(&lv, &cd_S19869C28);
    dp->~S19869C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C28(Test_S19869C28, "S19869C28", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN9S19869C28C1Ev();
extern void _ZN9S19869C28D2Ev();
Name_Map name_map_S19869C28[] = {
  NSPAIR(_ZN9S19869C28C1Ev),
  NSPAIR(_ZN9S19869C28D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
static Base_Class bases_S19869C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C8,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19869C15_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19869C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C28[];
extern void _ZN9S19869C28D1Ev();
extern void _ZN9S19869C28D0Ev();
extern void ABISELECT(_ZThn8_N9S19869C28D1Ev,_ZThn4_N9S19869C28D1Ev)();
extern void ABISELECT(_ZThn8_N9S19869C28D0Ev,_ZThn4_N9S19869C28D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C28[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&_ZN9S19869C28D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C28D0Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19869C28D1Ev,_ZThn4_N9S19869C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19869C28D0Ev,_ZThn4_N9S19869C28D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C28[];
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C28[] = {
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
static  VTT_ENTRY vtt_S19869C28[] = {
  {&(_ZTV9S19869C28[5]),  5,16},
  {&(_tg__ZTV9S19869C19__9S19869C28[3]),  3,5},
  {&(_ZTV9S19869C28[14]),  14,16},
};
extern VTBL_ENTRY _ZTI9S19869C28[];
extern  VTBL_ENTRY _ZTV9S19869C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C28[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C28 = {  "S19869C28", // class name
  bases_S19869C28, 11,
  &(vtc_S19869C28[0]), // expected_vtbl_contents
  &(vtt_S19869C28[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI9S19869C28),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19869C28),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C28),3, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C27  : virtual S19869C28 , virtual S19869C19 , S19869C7_nt {
  long s19869c27f0;
  virtual void  v2(); // _ZN9S19869C272v2Ev
  ~S19869C27(); // tgen
  S19869C27(); // tgen
};
//SIG(-1 S19869C27) C1{ VBC2{ VBC3{ BC4{ m}} VBC5{ BC6{ BC7{ vd m} vd} vd} BC8{ BC6 BC7 BC4 VBC9{ m FL} vd} vd} VBC8 BC7 v1 Fl}


void  S19869C27 ::v2(){vfunc_called(this, "_ZN9S19869C272v2Ev");}
S19869C27 ::~S19869C27(){ note_dtor("S19869C27", this);} // tgen
S19869C27 ::S19869C27(){ note_ctor("S19869C27", this);} // tgen

static void Test_S19869C27()
{
  extern Class_Descriptor cd_S19869C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S19869C27, buf);
    S19869C27 *dp, &lv = *(dp=new (buf) S19869C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S19869C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C27)");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), 0, "S19869C27");
    check_base_class_offset(lv, (S19869C8*)(S19869C28*), 0, "S19869C27");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(32,16), "S19869C27");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(32,16), "S19869C27");
    check_base_class_offset(lv, (S19869C12*)(S19869C28*), ABISELECT(32,16), "S19869C27");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C27");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C27");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*)(S19869C28*), ABISELECT(24,12), "S19869C27");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C27");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*)(S19869C28*), ABISELECT(40,20), "S19869C27");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(40,20), "S19869C27");
    check_base_class_offset(lv, (S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C27");
    check_base_class_offset(lv, (S19869C28*), ABISELECT(16,8), "S19869C27");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(48,28), "S19869C27");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(48,28), "S19869C27");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(56,32), "S19869C27");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(48,28), "S19869C27");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C19*), ABISELECT(48,28), "S19869C27");
    /*is_ambiguous_... S19869C27::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*), 0, "S19869C27");
    check_field_offset(lv, s19869c27f0, ABISELECT(8,4), "S19869C27.s19869c27f0");
    test_class_info(&lv, &cd_S19869C27);
    dp->~S19869C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C27(Test_S19869C27, "S19869C27", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN9S19869C27C1Ev();
extern void _ZN9S19869C27D1Ev();
Name_Map name_map_S19869C27[] = {
  NSPAIR(_ZN9S19869C27C1Ev),
  NSPAIR(_ZN9S19869C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C28;
extern VTBL_ENTRY _ZTI9S19869C28[];
extern  VTBL_ENTRY _ZTV9S19869C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C28[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
static Base_Class bases_S19869C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(32,16), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(24,12), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19869C15_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19869C19,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C28,    ABISELECT(16,8), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(56,32), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19869C19,    ABISELECT(48,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C27[];
extern void _ZN9S19869C27D1Ev();
extern void _ZN9S19869C27D0Ev();
extern void _ZN9S19869C272v2Ev();
extern void ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C27D1Ev,_ZThn8_N9S19869C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C27D0Ev,_ZThn8_N9S19869C27D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N9S19869C27D1Ev,_ZTvn4_n24_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N9S19869C27D0Ev,_ZTvn4_n24_N9S19869C27D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C27D1Ev,_ZThn16_N9S19869C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C27D0Ev,_ZThn16_N9S19869C27D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C27D1Ev,_ZTv0_n16_N9S19869C27D1Ev)();
extern void ABISELECT(_ZThn48_N9S19869C27D1Ev,_ZThn28_N9S19869C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C27D0Ev,_ZTv0_n16_N9S19869C27D0Ev)();
extern void ABISELECT(_ZThn48_N9S19869C27D0Ev,_ZThn28_N9S19869C27D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S19869C27D1Ev,_ZTvn4_n16_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C27D0Ev,_ZTvn4_n16_N9S19869C27D0Ev)();
static  VTBL_ENTRY vtc_S19869C27[] = {
  ABISELECT(48,28),
  ABISELECT(40,20),
  ABISELECT(32,16),
  0,
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&_ZN9S19869C27D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C27D0Ev,
  (VTBL_ENTRY)&_ZN9S19869C272v2Ev,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(24,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C27D1Ev,_ZTvn4_n24_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C27D0Ev,_ZTvn4_n24_N9S19869C27D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev),
  ABISELECT(-48,-28),
  -8,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C27D1Ev,_ZTv0_n16_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C27D0Ev,_ZTv0_n16_N9S19869C27D0Ev),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C27D1Ev,_ZTvn4_n16_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C27D0Ev,_ZTvn4_n16_N9S19869C27D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C27[];
extern void _ZN9S19869C28D1Ev();
extern void _ZN9S19869C28D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C28__9S19869C27[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&_ZN9S19869C28D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C28D0Ev,
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C199S19869C28__9S19869C27[] = {
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C12__9S19869C28__9S19869C27[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev),
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__A1__9S19869C27[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
static  VTT_ENTRY vtt_S19869C27[] = {
  {&(_ZTV9S19869C27[7]),  7,37},
  {&(_ZTV9S19869C27[16]),  16,37},
  {&(_ZTV9S19869C27[25]),  25,37},
  {&(_ZTV9S19869C27[20]),  20,37},
  {&(_ZTV9S19869C27[31]),  31,37},
  {&(_ZTV9S19869C27[35]),  35,37},
  {&(_tg__ZTV9S19869C28__9S19869C27[5]),  5,7},
  {&(_tg__ZTV9S19869C199S19869C28__9S19869C27[3]),  3,5},
  {&(_tg__ZTV9S19869C12__9S19869C28__9S19869C27[3]),  3,5},
  {&(_tg__ZTV9S19869C19__A1__9S19869C27[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C27[];
extern  VTBL_ENTRY _ZTV9S19869C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C27[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C27D0Ev,_ZTv0_n16_N9S19869C27D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19869C27D0Ev,_ZThn28_N9S19869C27D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C27D1Ev,_ZTv0_n16_N9S19869C27D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19869C27D1Ev,_ZThn28_N9S19869C27D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C27D0Ev,_ZThn16_N9S19869C27D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C27D1Ev,_ZThn16_N9S19869C27D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C27D0Ev,_ZThn8_N9S19869C27D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C27D1Ev,_ZThn8_N9S19869C27D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C27 = {  "S19869C27", // class name
  bases_S19869C27, 18,
  &(vtc_S19869C27[0]), // expected_vtbl_contents
  &(vtt_S19869C27[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI9S19869C27),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19869C27),37, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C27),10, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C22  : virtual S19869C19 , virtual S19869C23 , virtual S19869C17 , S19869C14 , virtual S19869C27 {
  long s19869c22f0[6];
  virtual  ~S19869C22(); // _ZN9S19869C22D2Ev
  S19869C22(); // tgen
};
//SIG(-1 S19869C22) C1{ VBC2{ BC3{ BC4{ vd m} vd} BC4 BC5{ m} VBC6{ m FL} vd} VBC7{ VBC8{ BC9{ BC10{ BC3 vd FC3} VBC2 Fi} VBC11{ m Fp} VBC3 BC12{ m FC3}} BC13{ BC10 BC14{ BC3 vd} Fl Fi} vd} VBC15{ VBC3 VBC6 BC5} BC16{ BC6 VBC17{ VBC5 VBC10 BC18{ BC5}} BC5 vd} VBC19{ VBC20{ VBC18 VBC14 BC2 vd} VBC2 BC4 v1 Fl} vd Fl[6]}


 S19869C22 ::~S19869C22(){ note_dtor("S19869C22", this);}
S19869C22 ::S19869C22(){ note_ctor("S19869C22", this);} // tgen

static void Test_S19869C22()
{
  extern Class_Descriptor cd_S19869C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(31,33)];
    init_test(&cd_S19869C22, buf);
    S19869C22 *dp, &lv = *(dp=new (buf) S19869C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,128), "sizeof(S19869C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C22)");
    /*is_ambiguous_... S19869C22::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(72,40), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(72,40), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(80,44), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C19 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(72,40), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(88,48), "S19869C22");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C17*), ABISELECT(88,48), "S19869C22");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*)(S19869C28*), ABISELECT(88,48), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C19*), ABISELECT(72,40), "S19869C22");
    check_base_class_offset(lv, (S19869C19*)(S19869C25*)(S19869C24*), ABISELECT(72,40), "S19869C22");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C19*)(S19869C27*), ABISELECT(72,40), "S19869C22");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(136,76), "S19869C22");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(136,76), "S19869C22");
    check_base_class_offset(lv, (S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(136,76), "S19869C22");
    check_base_class_offset(lv, (S19869C25*)(S19869C24*), ABISELECT(136,76), "S19869C22");
    check_base_class_offset(lv, (S19869C26_nt*)(S19869C24*), ABISELECT(168,92), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(176,96), "S19869C22");
    /*is_ambiguous_... S19869C24::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C24*), ABISELECT(176,96), "S19869C22");
    check_base_class_offset(lv, (S19869C6*)(S19869C17*), ABISELECT(176,96), "S19869C22");
    check_base_class_offset(lv, (S19869C20*)(S19869C24*), ABISELECT(160,88), "S19869C22");
    check_base_class_offset(lv, (S19869C24*)(S19869C23*), ABISELECT(136,76), "S19869C22");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*)(S19869C23*), ABISELECT(96,56), "S19869C22");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*)(S19869C23*), ABISELECT(96,56), "S19869C22");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*)(S19869C23*), ABISELECT(96,56), "S19869C22");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(112,64), "S19869C22");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(112,64), "S19869C22");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(112,64), "S19869C22");
    check_base_class_offset(lv, (S19869C13*)(S19869C23*), ABISELECT(96,56), "S19869C22");
    check_base_class_offset(lv, (S19869C23*), ABISELECT(96,56), "S19869C22");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C17*), ABISELECT(176,96), "S19869C22");
    check_base_class_offset(lv, (S19869C17*), ABISELECT(176,96), "S19869C22");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C14*), ABISELECT(8,4), "S19869C22");
    /*is_ambiguous_... S19869C4::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), ABISELECT(184,100), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(184,100), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(184,100), "S19869C22");
    check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(184,100), "S19869C22");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), 0, "S19869C22");
    check_base_class_offset(lv, (S19869C8*)(S19869C4*), 0, "S19869C22");
    check_base_class_offset(lv, (S19869C4*)(S19869C14*), 0, "S19869C22");
    /*is_ambiguous_... S19869C14::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C14*), ABISELECT(16,12), "S19869C22");
    check_base_class_offset(lv, (S19869C14*), 0, "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C8 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), ABISELECT(232,124), "S19869C22");
    check_base_class_offset(lv, (S19869C8*)(S19869C28*), ABISELECT(232,124), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(232,124), "S19869C22");
    /*is_ambiguous_... S19869C22::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(232,124), "S19869C22");
    check_base_class_offset(lv, (S19869C12*)(S19869C28*), ABISELECT(232,124), "S19869C22");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(216,116), "S19869C22");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(216,116), "S19869C22");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*)(S19869C28*), ABISELECT(224,120), "S19869C22");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*)(S19869C28*), ABISELECT(216,116), "S19869C22");
    check_base_class_offset(lv, (S19869C19*)(S19869C28*), ABISELECT(216,116), "S19869C22");
    check_base_class_offset(lv, (S19869C28*)(S19869C27*), ABISELECT(216,116), "S19869C22");
    /*is_ambiguous_... S19869C27::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C27*), ABISELECT(200,108), "S19869C22");
    check_base_class_offset(lv, (S19869C27*), ABISELECT(200,108), "S19869C22");
    check_field_offset(lv, s19869c22f0, ABISELECT(24,16), "S19869C22.s19869c22f0");
    test_class_info(&lv, &cd_S19869C22);
    dp->~S19869C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C22(Test_S19869C22, "S19869C22", ABISELECT(240,128));

#else // __cplusplus

extern void _ZN9S19869C22C1Ev();
extern void _ZN9S19869C22D2Ev();
Name_Map name_map_S19869C22[] = {
  NSPAIR(_ZN9S19869C22C1Ev),
  NSPAIR(_ZN9S19869C22D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C25;
extern VTBL_ENTRY _ZTI9S19869C25[];
extern  VTBL_ENTRY _ZTV9S19869C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C25[];
extern Class_Descriptor cd_S19869C26_nt;
extern VTBL_ENTRY _ZTI12S19869C26_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
extern Class_Descriptor cd_S19869C24;
extern VTBL_ENTRY _ZTI9S19869C24[];
extern  VTBL_ENTRY _ZTV9S19869C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C24[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
extern Class_Descriptor cd_S19869C23;
extern VTBL_ENTRY _ZTI9S19869C23[];
extern  VTBL_ENTRY _ZTV9S19869C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C23[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C17;
extern VTBL_ENTRY _ZTI9S19869C17[];
extern  VTBL_ENTRY _ZTV9S19869C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C17[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C14;
extern VTBL_ENTRY _ZTI9S19869C14[];
extern  VTBL_ENTRY _ZTV9S19869C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C14[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C28;
extern VTBL_ENTRY _ZTI9S19869C28[];
extern  VTBL_ENTRY _ZTV9S19869C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C28[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C27;
extern VTBL_ENTRY _ZTI9S19869C27[];
extern  VTBL_ENTRY _ZTV9S19869C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C27[];
static Base_Class bases_S19869C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(80,44), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C15_nt,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19869C19,    ABISELECT(72,40), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C25,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C26_nt,    ABISELECT(168,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(176,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(176,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C20,    ABISELECT(160,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C24,    ABISELECT(136,76), //bcp->offset
    43, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(112,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(112,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(112,64), //bcp->offset
    39, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19869C23,    ABISELECT(96,56), //bcp->offset
    29, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S246C12_nt,    ABISELECT(176,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19869C17,    ABISELECT(176,96), //bcp->offset
    52, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C15_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(184,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(184,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(184,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(184,100), //bcp->offset
    59, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19869C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19869C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S246C12_nt,    ABISELECT(232,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S19869C8,    ABISELECT(232,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    45, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(232,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(232,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(232,124), //bcp->offset
    88, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    45, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(216,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(216,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(224,120), //bcp->offset
    84, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(216,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19869C19,    ABISELECT(216,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19869C28,    ABISELECT(216,116), //bcp->offset
    76, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    47, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(200,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S19869C27,    ABISELECT(200,108), //bcp->offset
    64, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C22[];
extern void _ZN9S19869C22D1Ev();
extern void _ZN9S19869C22D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S19869C22D1Ev,_ZTv0_n16_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn72_N9S19869C22D1Ev,_ZThn40_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C22D0Ev,_ZTv0_n16_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn72_N9S19869C22D0Ev,_ZThn40_N9S19869C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S19869C22D1Ev,_ZTvn4_n16_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C22D0Ev,_ZTvn4_n16_N9S19869C22D0Ev)();
extern void ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn96_N9S19869C22D1Ev,_ZThn56_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn96_N9S19869C22D0Ev,_ZThn56_N9S19869C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n64_N9S19869C22D1Ev,_ZTvn8_n32_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTvn16_n64_N9S19869C22D0Ev,_ZTvn8_n32_N9S19869C22D0Ev)();
extern void ABISELECT(_ZTv0_n56_N9S19869C22D1Ev,_ZTv0_n28_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn136_N9S19869C22D1Ev,_ZThn76_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19869C22D0Ev,_ZTv0_n28_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn136_N9S19869C22D0Ev,_ZThn76_N9S19869C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn176_N9S19869C22D1Ev,_ZThn96_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn176_N9S19869C22D0Ev,_ZThn96_N9S19869C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn184_N9S19869C22D1Ev,_ZThn100_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn184_N9S19869C22D0Ev,_ZThn100_N9S19869C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn200_N9S19869C22D1Ev,_ZThn108_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn200_N9S19869C22D0Ev,_ZThn108_N9S19869C22D0Ev)() __attribute__((weak));
extern void _ZN9S19869C272v2Ev();
extern void ABISELECT(_ZTv0_n48_N9S19869C22D1Ev,_ZTv0_n24_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn216_N9S19869C22D1Ev,_ZThn116_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C22D0Ev,_ZTv0_n24_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn216_N9S19869C22D0Ev,_ZThn116_N9S19869C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N9S19869C22D1Ev,_ZTvn4_n24_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N9S19869C22D0Ev,_ZTvn4_n24_N9S19869C22D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn232_N9S19869C22D1Ev,_ZThn124_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn232_N9S19869C22D0Ev,_ZThn124_N9S19869C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C22[] = {
  ABISELECT(232,124),
  ABISELECT(232,124),
  ABISELECT(216,116),
  ABISELECT(200,108),
  ABISELECT(176,96),
  ABISELECT(176,96),
  ABISELECT(168,92),
  ABISELECT(136,76),
  ABISELECT(96,56),
  ABISELECT(88,48),
  ABISELECT(72,40),
  0,
  0,
  ABISELECT(184,100),
  ABISELECT(184,100),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&_ZN9S19869C22D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C22D0Ev,
  ABISELECT(-72,-40),
  ABISELECT(16,8),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C22D1Ev,_ZTv0_n16_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C22D0Ev,_ZTv0_n16_N9S19869C22D0Ev),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C22D1Ev,_ZTvn4_n16_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C22D0Ev,_ZTvn4_n16_N9S19869C22D0Ev),
  ABISELECT(-96,-56),
  ABISELECT(80,40),
  ABISELECT(72,36),
  -8,
  ABISELECT(-24,-16),
  ABISELECT(40,20),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev),
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N9S19869C22D1Ev,_ZTvn8_n32_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N9S19869C22D0Ev,_ZTvn8_n32_N9S19869C22D0Ev),
  ABISELECT(-136,-76),
  ABISELECT(40,20),
  ABISELECT(32,16),
  ABISELECT(-48,-28),
  ABISELECT(-64,-36),
  ABISELECT(-136,-76),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C22D1Ev,_ZTv0_n28_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C22D0Ev,_ZTv0_n28_N9S19869C22D0Ev),
  ABISELECT(-88,-48),
  0,
  ABISELECT(-176,-96),
  ABISELECT(-176,-96),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev),
  ABISELECT(-184,-100),
  ABISELECT(-184,-100),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev),
  0,
  ABISELECT(-200,-108),
  ABISELECT(-128,-68),
  ABISELECT(-112,-60),
  ABISELECT(32,16),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-200,-108),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev),
  (VTBL_ENTRY)&_ZN9S19869C272v2Ev,
  ABISELECT(-216,-116),
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(-128,-68),
  ABISELECT(-216,-116),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C22D1Ev,_ZTv0_n24_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C22D0Ev,_ZTv0_n24_N9S19869C22D0Ev),
  ABISELECT(-224,-120),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C22D1Ev,_ZTvn4_n24_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C22D0Ev,_ZTvn4_n24_N9S19869C22D0Ev),
  ABISELECT(-232,-124),
  ABISELECT(-232,-124),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C22[];
extern void _ZN9S19869C14D1Ev();
extern void _ZN9S19869C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C14__9S19869C22[] = {
  0,
  0,
  ABISELECT(184,100),
  ABISELECT(184,100),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&_ZN9S19869C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev)();
extern void ABISELECT(_ZThn184_N9S19869C14D1Ev,_ZThn100_N9S19869C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev)();
extern void ABISELECT(_ZThn184_N9S19869C14D0Ev,_ZThn100_N9S19869C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C5__9S19869C14__9S19869C22[] = {
  ABISELECT(-184,-100),
  ABISELECT(-184,-100),
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev),
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C22[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
extern void _ZN9S19869C23D1Ev();
extern void _ZN9S19869C23D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C23__9S19869C22[] = {
  ABISELECT(80,40),
  ABISELECT(72,36),
  -8,
  ABISELECT(-24,-16),
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&_ZN9S19869C23D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C23D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev)();
extern void ABISELECT(_ZThn40_N9S19869C23D1Ev,_ZThn20_N9S19869C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev)();
extern void ABISELECT(_ZThn40_N9S19869C23D0Ev,_ZThn20_N9S19869C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C24__9S19869C23__9S19869C22[] = {
  ABISELECT(-40,-20),
  ABISELECT(40,20),
  ABISELECT(32,16),
  ABISELECT(-48,-28),
  ABISELECT(-64,-36),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C23D1Ev,_ZTv0_n16_N9S19869C23D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C23D0Ev,_ZTv0_n16_N9S19869C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C23__9S19869C22[] = {
  ABISELECT(24,16),
  ABISELECT(16,8),
  ABISELECT(24,16),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C23D1Ev,_ZTv0_n16_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C23D0Ev,_ZTv0_n16_N9S19869C23D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C23D1Ev,_ZTvn4_n16_N9S19869C23D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C23D0Ev,_ZTvn4_n16_N9S19869C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C23__9S19869C22[] = {
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C23D1Ev,_ZTvn4_n16_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C23D0Ev,_ZTvn4_n16_N9S19869C23D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev)();
extern void ABISELECT(_ZThn80_N9S19869C23D1Ev,_ZThn40_N9S19869C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev)();
extern void ABISELECT(_ZThn80_N9S19869C23D0Ev,_ZThn40_N9S19869C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C6__A2__9S19869C23__9S19869C22[] = {
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev),
};
extern void _ZN9S19869C24D1Ev();
extern void _ZN9S19869C24D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C24__9S19869C22[] = {
  ABISELECT(40,20),
  ABISELECT(32,16),
  ABISELECT(-48,-28),
  ABISELECT(-64,-36),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&_ZN9S19869C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C24D0Ev,
};
extern void _ZN9S19869C25D1Ev();
extern void _ZN9S19869C25D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C259S19869C24__9S19869C22[] = {
  ABISELECT(-48,-28),
  ABISELECT(-64,-36),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&_ZN9S19869C25D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C25D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C259S19869C24__9S19869C22[] = {
  ABISELECT(64,36),
  ABISELECT(16,8),
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C259S19869C24__9S19869C22[] = {
  ABISELECT(56,32),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C24__9S19869C22[] = {
  ABISELECT(64,36),
  ABISELECT(16,8),
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C24__9S19869C22[] = {
  ABISELECT(56,32),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev)();
extern void ABISELECT(_ZThn40_N9S19869C24D1Ev,_ZThn20_N9S19869C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev)();
extern void ABISELECT(_ZThn40_N9S19869C24D0Ev,_ZThn20_N9S19869C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C6__A2__9S19869C24__9S19869C22[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev)();
extern void _ZN9S19869C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev)();
extern void _ZN9S19869C17D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C17__9S19869C22[] = {
  ABISELECT(-88,-48),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev),
};
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C22[] = {
  ABISELECT(184,100),
  ABISELECT(184,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZThn184_N8S19869C4D1Ev,_ZThn100_N8S19869C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
extern void ABISELECT(_ZThn184_N8S19869C4D0Ev,_ZThn100_N8S19869C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C5__8S19869C4__9S19869C22[] = {
  ABISELECT(-184,-100),
  ABISELECT(-184,-100),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
extern void _ZN9S19869C27D1Ev();
extern void _ZN9S19869C27D0Ev();
extern void _ZN9S19869C272v2Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C27__9S19869C22[] = {
  ABISELECT(-128,-68),
  ABISELECT(-112,-60),
  ABISELECT(32,16),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&_ZN9S19869C27D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C27D0Ev,
  (VTBL_ENTRY)&_ZN9S19869C272v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C27D1Ev,_ZThn8_N9S19869C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C27D0Ev,_ZThn8_N9S19869C27D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C28__9S19869C27__9S19869C22[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(-128,-68),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C27D1Ev,_ZThn16_N9S19869C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C27D0Ev,_ZThn16_N9S19869C27D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C12__9S19869C27__9S19869C22[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTvn8_n48_N9S19869C27D1Ev,_ZTvn4_n24_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N9S19869C27D0Ev,_ZTvn4_n24_N9S19869C27D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C199S19869C28__A2__9S19869C27__9S19869C22[] = {
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C27D1Ev,_ZTvn4_n24_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C27D0Ev,_ZTvn4_n24_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C27D1Ev,_ZTv0_n16_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C27D0Ev,_ZTv0_n16_N9S19869C27D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__A1__9S19869C27__9S19869C22[] = {
  ABISELECT(128,68),
  ABISELECT(16,8),
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C27D1Ev,_ZTv0_n16_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C27D0Ev,_ZTv0_n16_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C27D1Ev,_ZTvn4_n16_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C27D0Ev,_ZTvn4_n16_N9S19869C27D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A4__9S19869C27__9S19869C22[] = {
  ABISELECT(120,64),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C27D1Ev,_ZTvn4_n16_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C27D0Ev,_ZTvn4_n16_N9S19869C27D0Ev),
};
extern void _ZN9S19869C28D1Ev();
extern void _ZN9S19869C28D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C28__9S19869C22[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(-128,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&_ZN9S19869C28D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C28D0Ev,
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C199S19869C28__A1__9S19869C22[] = {
  ABISELECT(-128,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C12__9S19869C28__9S19869C22[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev),
};
static  VTT_ENTRY vtt_S19869C22[] = {
  {&(_ZTV9S19869C22[17]),  17,93},
  {&(_tg__ZTV9S19869C14__9S19869C22[6]),  6,8},
  {&(_tg__ZTV9S19869C14__9S19869C22[6]),  6,8},
  {&(_tg__ZTV8S19869C5__9S19869C14__9S19869C22[3]),  3,5},
  {&(_ZTV9S19869C22[23]),  23,93},
  {&(_ZTV9S19869C22[27]),  27,93},
  {&(_ZTV9S19869C22[37]),  37,93},
  {&(_ZTV9S19869C22[50]),  50,93},
  {&(_ZTV9S19869C22[57]),  57,93},
  {&(_ZTV9S19869C22[41]),  41,93},
  {&(_ZTV9S19869C22[57]),  57,93},
  {&(_ZTV9S19869C22[17]),  17,93},
  {&(_ZTV9S19869C22[62]),  62,93},
  {&(_ZTV9S19869C22[73]),  73,93},
  {&(_ZTV9S19869C22[82]),  82,93},
  {&(_ZTV9S19869C22[91]),  91,93},
  {&(_ZTV9S19869C22[86]),  86,93},
  {&(_tg__ZTV9S19869C19__9S19869C22[3]),  3,5},
  {&(_tg__ZTV9S19869C23__9S19869C22[7]),  7,9},
  {&(_tg__ZTV9S19869C24__9S19869C23__9S19869C22[7]),  7,9},
  {&(_tg__ZTV9S19869C19__9S19869C23__9S19869C22[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C23__9S19869C22[2]),  2,4},
  {&(_tg__ZTV8S19869C6__A2__9S19869C23__9S19869C22[3]),  3,5},
  {&(_tg__ZTV9S19869C24__9S19869C22[6]),  6,8},
  {&(_tg__ZTV9S19869C259S19869C24__9S19869C22[4]),  4,6},
  {&(_tg__ZTV9S19869C19__9S19869C259S19869C24__9S19869C22[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C259S19869C24__9S19869C22[2]),  2,4},
  {&(_tg__ZTV9S19869C19__9S19869C24__9S19869C22[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C24__9S19869C22[2]),  2,4},
  {&(_tg__ZTV8S19869C6__A2__9S19869C24__9S19869C22[3]),  3,5},
  {&(_tg__ZTV9S19869C17__9S19869C22[5]),  5,7},
  {&(_tg__ZTV9S19869C17__9S19869C22[5]),  5,7},
  {&(_tg__ZTV8S19869C4__9S19869C22[4]),  4,6},
  {&(_tg__ZTV8S19869C5__8S19869C4__9S19869C22[3]),  3,5},
  {&(_tg__ZTV9S19869C27__9S19869C22[7]),  7,10},
  {&(_tg__ZTV9S19869C28__9S19869C27__9S19869C22[6]),  6,8},
  {&(_tg__ZTV9S19869C12__9S19869C27__9S19869C22[3]),  3,5},
  {&(_tg__ZTV11S19869C7_nt9S19869C199S19869C28__A2__9S19869C27__9S19869C22[2]),  2,4},
  {&(_tg__ZTV9S19869C19__A1__9S19869C27__9S19869C22[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A4__9S19869C27__9S19869C22[2]),  2,4},
  {&(_tg__ZTV9S19869C28__9S19869C22[5]),  5,7},
  {&(_tg__ZTV9S19869C199S19869C28__A1__9S19869C22[3]),  3,5},
  {&(_tg__ZTV9S19869C12__9S19869C28__9S19869C22[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C22[];
extern  VTBL_ENTRY _ZTV9S19869C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C22[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C27D0Ev,_ZThn16_N9S19869C27D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C27D1Ev,_ZThn16_N9S19869C27D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C27D0Ev,_ZThn8_N9S19869C27D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C27D1Ev,_ZThn8_N9S19869C27D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N8S19869C4D0Ev,_ZThn100_N8S19869C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N8S19869C4D1Ev,_ZThn100_N8S19869C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C24D0Ev,_ZThn20_N9S19869C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C24D1Ev,_ZThn20_N9S19869C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19869C23D0Ev,_ZThn40_N9S19869C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19869C23D1Ev,_ZThn40_N9S19869C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C23D0Ev,_ZThn20_N9S19869C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C23D1Ev,_ZThn20_N9S19869C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N9S19869C14D0Ev,_ZThn100_N9S19869C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N9S19869C14D1Ev,_ZThn100_N9S19869C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C22D0Ev,_ZTv0_n24_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S19869C22D0Ev,_ZThn116_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C22D1Ev,_ZTv0_n24_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S19869C22D1Ev,_ZThn116_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N9S19869C22D0Ev,_ZThn124_N9S19869C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn184_N9S19869C22D0Ev,_ZThn100_N9S19869C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19869C22D0Ev,_ZThn96_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N9S19869C22D1Ev,_ZThn124_N9S19869C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn184_N9S19869C22D1Ev,_ZThn100_N9S19869C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19869C22D1Ev,_ZThn96_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C22D0Ev,_ZTv0_n28_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N9S19869C22D0Ev,_ZThn76_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C22D1Ev,_ZTv0_n28_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N9S19869C22D1Ev,_ZThn76_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N9S19869C22D0Ev,_ZThn108_N9S19869C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19869C22D0Ev,_ZThn56_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N9S19869C22D1Ev,_ZThn108_N9S19869C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19869C22D1Ev,_ZThn56_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C22D0Ev,_ZTv0_n16_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C22D0Ev,_ZThn40_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C22D1Ev,_ZTv0_n16_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C22D1Ev,_ZThn40_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C22 = {  "S19869C22", // class name
  bases_S19869C22, 48,
  &(vtc_S19869C22[0]), // expected_vtbl_contents
  &(vtt_S19869C22[0]), // expected_vtt_contents
  ABISELECT(240,128), // object size
  NSPAIRA(_ZTI9S19869C22),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19869C22),93, //virtual function table var
  17, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C22),43, //virtual table table var
  35, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C3  : S19869C4 , virtual S19869C9 , S19869C18 , S19869C21 , virtual S19869C22 {
  __tsi64 s19869c3f0;
  ~S19869C3(); // tgen
  S19869C3(); // tgen
};
//SIG(-1 S19869C3) C1{ BC2{ VBC3{ m} VBC4{ BC5{ BC6{ vd m} vd} vd FC5} BC7{ BC3}} VBC8{ VBC9{ VBC3 VBC6 VBC10{ BC11{ BC5 vd} VBC6 VBC5 VBC12{ BC4 BC11 Fl Fi} Fi}} VBC4 VBC13{ BC14{ m FL} VBC2 BC3 vd} VBC15{ VBC3 vd v1} BC16{ VBC5 VBC14 BC3} vd} BC17{ VBC18{ BC5 BC6 BC3 VBC14 vd} VBC7 VBC19{ m FC5} VBC12 vd} BC20{ BC4 VBC2 Fi:3} VBC21{ VBC18 VBC22{ VBC23{ BC24{ BC4 VBC18 Fi} VBC25{ m Fp} VBC5 BC19} BC12 vd} VBC16 BC13 VBC26{ VBC27{ VBC7 VBC11 BC18 vd} VBC18 BC6 v2 Fl} vd Fl[6]} FL}


S19869C3 ::~S19869C3(){ note_dtor("S19869C3", this);} // tgen
S19869C3 ::S19869C3(){ note_ctor("S19869C3", this);} // tgen

static void Test_S19869C3()
{
  extern Class_Descriptor cd_S19869C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,55)];
    init_test(&cd_S19869C3, buf);
    S19869C3 *dp, &lv = *(dp=new (buf) S19869C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,216), "sizeof(S19869C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C3)");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), ABISELECT(48,28), "S19869C3");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C10*), ABISELECT(48,28), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), ABISELECT(48,28), "S19869C3");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C16*), ABISELECT(48,28), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(48,28), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(48,28), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(48,28), "S19869C3");
    /*is_ambiguous_... S19869C9::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C9*), ABISELECT(48,28), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(48,28), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), 0, "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S19869C8*)(S19869C4*), 0, "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S19869C4*), 0, "S19869C3");
    /*is_ambiguous_... S19869C10::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C10*), ABISELECT(72,40), "S19869C3");
    /*is_ambiguous_... S19869C11::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C11*), ABISELECT(72,40), "S19869C3");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(80,44), "S19869C3");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(80,44), "S19869C3");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C12*)(S19869C11*), ABISELECT(80,44), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(64,36), "S19869C3");
    /*is_ambiguous_... S19869C11::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C11*), ABISELECT(64,36), "S19869C3");
    check_base_class_offset(lv, (S19869C6*)(S19869C17*)(S19869C9*), ABISELECT(64,36), "S19869C3");
    /*is_ambiguous_... S19869C24::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C24*), ABISELECT(64,36), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C17 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C17*), ABISELECT(64,36), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(96,52), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(96,52), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C13*), ABISELECT(96,52), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(112,60), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(112,60), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C12*)(S19869C13*), ABISELECT(112,60), "S19869C3");
    check_base_class_offset(lv, (S19869C13*)(S19869C11*), ABISELECT(96,52), "S19869C3");
    check_base_class_offset(lv, (S19869C13*)(S19869C18*), ABISELECT(96,52), "S19869C3");
    check_base_class_offset(lv, (S19869C11*)(S19869C10*), ABISELECT(80,44), "S19869C3");
    check_base_class_offset(lv, (S19869C10*)(S19869C9*), ABISELECT(72,40), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C14 */ AMB_check_base_class_offset(lv, (S19869C15_nt*)(S19869C14*), ABISELECT(144,76), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), ABISELECT(136,72), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C4 */ AMB_check_base_class_offset(lv, (S19869C8*)(S19869C4*), ABISELECT(136,72), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C14 */ AMB_check_base_class_offset(lv, (S19869C4*)(S19869C14*), ABISELECT(136,72), "S19869C3");
    check_base_class_offset(lv, (S19869C4*)(S19869C21*), ABISELECT(136,72), "S19869C3");
    check_base_class_offset(lv, (S19869C4*)(S19869C14*)(S19869C22*), ABISELECT(136,72), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C14 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C14*), ABISELECT(152,84), "S19869C3");
    check_base_class_offset(lv, (S19869C14*)(S19869C9*), ABISELECT(136,72), "S19869C3");
    check_base_class_offset(lv, (S19869C16*)(S19869C9*), ABISELECT(160,88), "S19869C3");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C17*)(S19869C9*), ABISELECT(168,92), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(168,92), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C17 */ AMB_check_base_class_offset(lv, (S19869C15_nt*)(S19869C17*), ABISELECT(168,92), "S19869C3");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*)(S19869C28*), ABISELECT(168,92), "S19869C3");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C17*)(S19869C9*), ABISELECT(64,36), "S19869C3");
    check_base_class_offset(lv, (S19869C17*)(S19869C9*), ABISELECT(64,36), "S19869C3");
    check_base_class_offset(lv, (S19869C9*), ABISELECT(64,36), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(176,100), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(176,100), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(184,104), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C19 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(176,100), "S19869C3");
    check_base_class_offset(lv, (S19869C19*)(S19869C18*), ABISELECT(176,100), "S19869C3");
    /*is_ambiguous_... S19869C22::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C19*)(S19869C22*), ABISELECT(176,100), "S19869C3");
    check_base_class_offset(lv, (S19869C19*)(S19869C25*)(S19869C24*), ABISELECT(176,100), "S19869C3");
    /*is_ambiguous_... S19869C27::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C19*)(S19869C27*), ABISELECT(176,100), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C8 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), ABISELECT(192,108), "S19869C3");
    check_base_class_offset(lv, (S19869C8*)(S19869C18*), ABISELECT(192,108), "S19869C3");
    check_base_class_offset(lv, (S19869C8*)(S19869C28*), ABISELECT(192,108), "S19869C3");
    check_base_class_offset(lv, (S19869C20*)(S19869C18*), ABISELECT(192,108), "S19869C3");
    check_base_class_offset(lv, (S19869C18*), ABISELECT(8,4), "S19869C3");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C21*), ABISELECT(16,8), "S19869C3");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C21*), ABISELECT(16,8), "S19869C3");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C21*), ABISELECT(16,8), "S19869C3");
    check_base_class_offset(lv, (S19869C21*), ABISELECT(16,8), "S19869C3");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(312,172), "S19869C3");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(312,172), "S19869C3");
    check_base_class_offset(lv, (S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(312,172), "S19869C3");
    check_base_class_offset(lv, (S19869C25*)(S19869C24*), ABISELECT(312,172), "S19869C3");
    check_base_class_offset(lv, (S19869C26_nt*)(S19869C24*), ABISELECT(344,188), "S19869C3");
    check_base_class_offset(lv, (S19869C20*)(S19869C24*), ABISELECT(336,184), "S19869C3");
    check_base_class_offset(lv, (S19869C24*)(S19869C23*), ABISELECT(312,172), "S19869C3");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*)(S19869C23*), ABISELECT(272,152), "S19869C3");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*)(S19869C23*), ABISELECT(272,152), "S19869C3");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*)(S19869C23*), ABISELECT(272,152), "S19869C3");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(288,160), "S19869C3");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(288,160), "S19869C3");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(288,160), "S19869C3");
    check_base_class_offset(lv, (S19869C13*)(S19869C23*), ABISELECT(272,152), "S19869C3");
    check_base_class_offset(lv, (S19869C23*)(S19869C22*), ABISELECT(272,152), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C17 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C17*), ABISELECT(352,192), "S19869C3");
    check_base_class_offset(lv, (S19869C17*)(S19869C22*), ABISELECT(352,192), "S19869C3");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C14*)(S19869C22*), ABISELECT(208,116), "S19869C3");
    /*is_ambiguous_... S19869C14::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C14*)(S19869C22*), ABISELECT(216,124), "S19869C3");
    check_base_class_offset(lv, (S19869C14*)(S19869C22*), ABISELECT(200,112), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(392,212), "S19869C3");
    /*is_ambiguous_... S19869C3::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(392,212), "S19869C3");
    check_base_class_offset(lv, (S19869C12*)(S19869C28*), ABISELECT(392,212), "S19869C3");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(376,204), "S19869C3");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(376,204), "S19869C3");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*)(S19869C28*), ABISELECT(384,208), "S19869C3");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*)(S19869C28*), ABISELECT(376,204), "S19869C3");
    check_base_class_offset(lv, (S19869C19*)(S19869C28*), ABISELECT(376,204), "S19869C3");
    check_base_class_offset(lv, (S19869C28*)(S19869C27*), ABISELECT(376,204), "S19869C3");
    /*is_ambiguous_... S19869C27::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C27*), ABISELECT(360,196), "S19869C3");
    check_base_class_offset(lv, (S19869C27*)(S19869C22*), ABISELECT(360,196), "S19869C3");
    check_base_class_offset(lv, (S19869C22*), ABISELECT(200,112), "S19869C3");
    check_field_offset(lv, s19869c3f0, ABISELECT(40,20), "S19869C3.s19869c3f0");
    test_class_info(&lv, &cd_S19869C3);
    dp->~S19869C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C3(Test_S19869C3, "S19869C3", ABISELECT(400,216));

#else // __cplusplus

extern void _ZN8S19869C3C1Ev();
extern void _ZN8S19869C3D1Ev();
Name_Map name_map_S19869C3[] = {
  NSPAIR(_ZN8S19869C3C1Ev),
  NSPAIR(_ZN8S19869C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
extern Class_Descriptor cd_S19869C11;
extern VTBL_ENTRY _ZTI9S19869C11[];
extern  VTBL_ENTRY _ZTV9S19869C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C11[];
extern Class_Descriptor cd_S19869C10;
extern VTBL_ENTRY _ZTI9S19869C10[];
extern  VTBL_ENTRY _ZTV9S19869C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C10[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C14;
extern VTBL_ENTRY _ZTI9S19869C14[];
extern  VTBL_ENTRY _ZTV9S19869C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C14[];
extern Class_Descriptor cd_S19869C16;
extern VTBL_ENTRY _ZTI9S19869C16[];
extern  VTBL_ENTRY _ZTV9S19869C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C16[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C17;
extern VTBL_ENTRY _ZTI9S19869C17[];
extern  VTBL_ENTRY _ZTV9S19869C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C17[];
extern Class_Descriptor cd_S19869C9;
extern VTBL_ENTRY _ZTI8S19869C9[];
extern  VTBL_ENTRY _ZTV8S19869C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C9[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
extern Class_Descriptor cd_S19869C18;
extern VTBL_ENTRY _ZTI9S19869C18[];
extern  VTBL_ENTRY _ZTV9S19869C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C18[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C21;
extern VTBL_ENTRY _ZTI9S19869C21[];
extern  VTBL_ENTRY _ZTV9S19869C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C21[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C25;
extern VTBL_ENTRY _ZTI9S19869C25[];
extern  VTBL_ENTRY _ZTV9S19869C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C25[];
extern Class_Descriptor cd_S19869C26_nt;
extern VTBL_ENTRY _ZTI12S19869C26_nt[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
extern Class_Descriptor cd_S19869C24;
extern VTBL_ENTRY _ZTI9S19869C24[];
extern  VTBL_ENTRY _ZTV9S19869C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C24[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
extern Class_Descriptor cd_S19869C23;
extern VTBL_ENTRY _ZTI9S19869C23[];
extern  VTBL_ENTRY _ZTV9S19869C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C23[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C17;
extern VTBL_ENTRY _ZTI9S19869C17[];
extern  VTBL_ENTRY _ZTV9S19869C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C17[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C14;
extern VTBL_ENTRY _ZTI9S19869C14[];
extern  VTBL_ENTRY _ZTV9S19869C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C14[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C28;
extern VTBL_ENTRY _ZTI9S19869C28[];
extern  VTBL_ENTRY _ZTV9S19869C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C28[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C27;
extern VTBL_ENTRY _ZTI9S19869C27[];
extern  VTBL_ENTRY _ZTV9S19869C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C27[];
extern Class_Descriptor cd_S19869C22;
extern VTBL_ENTRY _ZTI9S19869C22[];
extern  VTBL_ENTRY _ZTV9S19869C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C22[];
static Base_Class bases_S19869C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(48,28), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    54, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(112,60), //bcp->offset
    87, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(96,52), //bcp->offset
    82, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S19869C11,    ABISELECT(80,44), //bcp->offset
    74, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S19869C10,    ABISELECT(72,40), //bcp->offset
    64, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19869C15_nt,    ABISELECT(144,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(136,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19869C8,    ABISELECT(136,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19869C4,    ABISELECT(136,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(152,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19869C14,    ABISELECT(136,72), //bcp->offset
    91, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19869C16,    ABISELECT(160,88), //bcp->offset
    99, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19869C15_nt,    ABISELECT(168,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19869C17,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19869C9,    ABISELECT(64,36), //bcp->offset
    48, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(176,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(176,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(184,104), //bcp->offset
    113, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(176,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19869C19,    ABISELECT(176,100), //bcp->offset
    107, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(192,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19869C8,    ABISELECT(192,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S19869C20,    ABISELECT(192,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S19869C18,    ABISELECT(8,4), //bcp->offset
    27, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    55, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    56, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    57, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    58, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19869C21,    ABISELECT(16,8), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    59, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(312,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(312,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(312,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S19869C25,    ABISELECT(312,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    90, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19869C26_nt,    ABISELECT(344,188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    52, //immediately_derived
  0, 1},
  {&cd_S19869C20,    ABISELECT(336,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19869C24,    ABISELECT(312,172), //bcp->offset
    150, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    89, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    60, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(272,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(272,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(272,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(288,160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(288,160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(288,160), //bcp->offset
    146, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(272,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19869C23,    ABISELECT(272,152), //bcp->offset
    136, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    84, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    77, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(352,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S19869C17,    ABISELECT(352,192), //bcp->offset
    159, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    96, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    77, //immediately_derived
  0, 1},
  {&cd_S19869C15_nt,    ABISELECT(208,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(216,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19869C14,    ABISELECT(200,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    77, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(392,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(392,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    68, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(392,212), //bcp->offset
    190, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    74, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(376,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(376,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    73, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(384,208), //bcp->offset
    186, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    73, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(376,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    73, //immediately_derived
  0, 0},
  {&cd_S19869C19,    ABISELECT(376,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    105, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    74, //immediately_derived
  0, 0},
  {&cd_S19869C28,    ABISELECT(376,204), //bcp->offset
    178, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    76, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(360,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    76, //immediately_derived
  0, 0},
  {&cd_S19869C27,    ABISELECT(360,196), //bcp->offset
    166, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    98, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    77, //immediately_derived
  0, 1},
  {&cd_S19869C22,    ABISELECT(200,112), //bcp->offset
    117, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    53, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19869C3[];
extern void _ZN8S19869C3D1Ev();
extern void _ZN8S19869C3D0Ev();
extern void ABISELECT(_ZThn8_N8S19869C3D1Ev,_ZThn4_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn8_N8S19869C3D0Ev,_ZThn4_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn16_N8S19869C3D1Ev,_ZThn8_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn16_N8S19869C3D0Ev,_ZThn8_N8S19869C3D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn48_N8S19869C3D1Ev,_ZThn28_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn48_N8S19869C3D0Ev,_ZThn28_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn64_N8S19869C3D1Ev,_ZThn36_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn64_N8S19869C3D0Ev,_ZThn36_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn72_N8S19869C3D1Ev,_ZThn40_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn72_N8S19869C3D0Ev,_ZThn40_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19869C3D1Ev,_ZTv0_n24_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn80_N8S19869C3D1Ev,_ZThn44_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19869C3D0Ev,_ZTv0_n24_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn80_N8S19869C3D0Ev,_ZThn44_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn96_N8S19869C3D1Ev,_ZThn52_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn96_N8S19869C3D0Ev,_ZThn52_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N8S19869C3D1Ev,_ZTvn8_n12_N8S19869C3D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S19869C3D0Ev,_ZTvn8_n12_N8S19869C3D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19869C3D1Ev,_ZTv0_n20_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn136_N8S19869C3D1Ev,_ZThn72_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19869C3D0Ev,_ZTv0_n20_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn136_N8S19869C3D0Ev,_ZThn72_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19869C3D1Ev,_ZTv0_n16_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn160_N8S19869C3D1Ev,_ZThn88_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19869C3D0Ev,_ZTv0_n16_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn160_N8S19869C3D0Ev,_ZThn88_N8S19869C3D0Ev)() __attribute__((weak));
extern void _ZN9S19869C162v1Ev();
extern void ABISELECT(_ZTv0_n32_N8S19869C3D1Ev,_ZTv0_n16_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn176_N8S19869C3D1Ev,_ZThn100_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19869C3D0Ev,_ZTv0_n16_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn176_N8S19869C3D0Ev,_ZThn100_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N8S19869C3D1Ev,_ZTvn4_n16_N8S19869C3D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N8S19869C3D0Ev,_ZTvn4_n16_N8S19869C3D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19869C3D1Ev,_ZTv0_n20_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn200_N8S19869C3D1Ev,_ZThn112_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19869C3D0Ev,_ZTv0_n20_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn200_N8S19869C3D0Ev,_ZThn112_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19869C3D1Ev,_ZTv0_n32_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn272_N8S19869C3D1Ev,_ZThn152_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19869C3D0Ev,_ZTv0_n32_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn272_N8S19869C3D0Ev,_ZThn152_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n64_N8S19869C3D1Ev,_ZTvn8_n32_N8S19869C3D1Ev)();
extern void ABISELECT(_ZTvn16_n64_N8S19869C3D0Ev,_ZTvn8_n32_N8S19869C3D0Ev)();
extern void ABISELECT(_ZTv0_n56_N8S19869C3D1Ev,_ZTv0_n28_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn312_N8S19869C3D1Ev,_ZThn172_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19869C3D0Ev,_ZTv0_n28_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn312_N8S19869C3D0Ev,_ZThn172_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn352_N8S19869C3D1Ev,_ZThn192_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn352_N8S19869C3D0Ev,_ZThn192_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19869C3D1Ev,_ZTv0_n32_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn360_N8S19869C3D1Ev,_ZThn196_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19869C3D0Ev,_ZTv0_n32_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn360_N8S19869C3D0Ev,_ZThn196_N8S19869C3D0Ev)() __attribute__((weak));
extern void _ZN9S19869C272v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S19869C3D1Ev,_ZTv0_n24_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn376_N8S19869C3D1Ev,_ZThn204_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19869C3D0Ev,_ZTv0_n24_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn376_N8S19869C3D0Ev,_ZThn204_N8S19869C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N8S19869C3D1Ev,_ZTvn4_n24_N8S19869C3D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S19869C3D0Ev,_ZTvn4_n24_N8S19869C3D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev)();
extern void ABISELECT(_ZThn392_N8S19869C3D1Ev,_ZThn212_N8S19869C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev)();
extern void ABISELECT(_ZThn392_N8S19869C3D0Ev,_ZThn212_N8S19869C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C3[] = {
  ABISELECT(392,212),
  ABISELECT(376,204),
  ABISELECT(360,196),
  ABISELECT(352,192),
  ABISELECT(344,188),
  ABISELECT(312,172),
  ABISELECT(272,152),
  ABISELECT(200,112),
  ABISELECT(192,108),
  ABISELECT(192,108),
  ABISELECT(176,100),
  ABISELECT(168,92),
  ABISELECT(160,88),
  ABISELECT(136,72),
  ABISELECT(136,72),
  ABISELECT(96,52),
  ABISELECT(64,36),
  ABISELECT(80,44),
  ABISELECT(72,40),
  ABISELECT(72,40),
  ABISELECT(64,36),
  ABISELECT(48,28),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&_ZN8S19869C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C3D0Ev,
  ABISELECT(88,48),
  ABISELECT(184,104),
  ABISELECT(184,104),
  ABISELECT(160,88),
  ABISELECT(168,96),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S19869C3D1Ev,_ZThn4_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S19869C3D0Ev,_ZThn4_N8S19869C3D0Ev),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(120,64),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S19869C3D1Ev,_ZThn8_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S19869C3D0Ev,_ZThn8_N8S19869C3D0Ev),
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev),
  ABISELECT(96,52),
  ABISELECT(72,36),
  ABISELECT(72,36),
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(8,4),
  ABISELECT(-16,-8),
  ABISELECT(8,4),
  ABISELECT(104,56),
  0,
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev),
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  ABISELECT(-24,-12),
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev),
  ABISELECT(-80,-44),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C3D1Ev,_ZTv0_n24_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C3D0Ev,_ZTv0_n24_N8S19869C3D0Ev),
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S19869C3D1Ev,_ZTvn8_n12_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S19869C3D0Ev,_ZTvn8_n12_N8S19869C3D0Ev),
  0,
  ABISELECT(-136,-72),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C3D1Ev,_ZTv0_n20_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C3D0Ev,_ZTv0_n20_N8S19869C3D0Ev),
  0,
  ABISELECT(-160,-88),
  ABISELECT(-112,-60),
  ABISELECT(-160,-88),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C3D1Ev,_ZTv0_n16_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C3D0Ev,_ZTv0_n16_N8S19869C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19869C162v1Ev,
  ABISELECT(-176,-100),
  -8,
  ABISELECT(-176,-100),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C3D1Ev,_ZTv0_n16_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C3D0Ev,_ZTv0_n16_N8S19869C3D0Ev),
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N8S19869C3D1Ev,_ZTvn4_n16_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N8S19869C3D0Ev,_ZTvn4_n16_N8S19869C3D0Ev),
  ABISELECT(192,100),
  ABISELECT(-8,-4),
  ABISELECT(176,92),
  ABISELECT(160,84),
  ABISELECT(152,80),
  ABISELECT(-136,-76),
  ABISELECT(144,76),
  ABISELECT(112,60),
  ABISELECT(72,40),
  ABISELECT(-32,-20),
  ABISELECT(-24,-12),
  ABISELECT(-64,-40),
  ABISELECT(-200,-112),
  ABISELECT(-152,-84),
  ABISELECT(-152,-84),
  ABISELECT(-200,-112),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C3D1Ev,_ZTv0_n20_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C3D0Ev,_ZTv0_n20_N8S19869C3D0Ev),
  ABISELECT(-272,-152),
  ABISELECT(-208,-116),
  ABISELECT(72,36),
  ABISELECT(-104,-60),
  ABISELECT(-96,-52),
  ABISELECT(40,20),
  ABISELECT(-272,-152),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19869C3D1Ev,_ZTv0_n32_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19869C3D0Ev,_ZTv0_n32_N8S19869C3D0Ev),
  ABISELECT(-288,-160),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S19869C3D1Ev,_ZTvn8_n32_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S19869C3D0Ev,_ZTvn8_n32_N8S19869C3D0Ev),
  ABISELECT(-312,-172),
  ABISELECT(-248,-136),
  ABISELECT(32,16),
  ABISELECT(-144,-80),
  ABISELECT(-136,-72),
  ABISELECT(-312,-172),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19869C3D1Ev,_ZTv0_n28_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19869C3D0Ev,_ZTv0_n28_N8S19869C3D0Ev),
  ABISELECT(-184,-100),
  ABISELECT(-288,-156),
  ABISELECT(-352,-192),
  ABISELECT(-352,-192),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev),
  0,
  ABISELECT(-360,-196),
  ABISELECT(-184,-96),
  ABISELECT(-192,-104),
  ABISELECT(32,16),
  ABISELECT(-168,-88),
  ABISELECT(16,8),
  ABISELECT(-360,-196),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19869C3D1Ev,_ZTv0_n32_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19869C3D0Ev,_ZTv0_n32_N8S19869C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19869C272v2Ev,
  ABISELECT(-376,-204),
  ABISELECT(16,8),
  ABISELECT(-184,-96),
  ABISELECT(-208,-112),
  ABISELECT(-376,-204),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C3D1Ev,_ZTv0_n24_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C3D0Ev,_ZTv0_n24_N8S19869C3D0Ev),
  ABISELECT(-384,-208),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S19869C3D1Ev,_ZTvn4_n24_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S19869C3D0Ev,_ZTvn4_n24_N8S19869C3D0Ev),
  ABISELECT(-392,-212),
  ABISELECT(-392,-212),
  (VTBL_ENTRY)&(_ZTI8S19869C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev),
};
extern VTBL_ENTRY _ZTV8S19869C3[];
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19869C4__A__8S19869C3[] = {
  ABISELECT(48,28),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZThn48_N8S19869C4D1Ev,_ZThn28_N8S19869C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
extern void ABISELECT(_ZThn48_N8S19869C4D0Ev,_ZThn28_N8S19869C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C5__8S19869C4__A__8S19869C3[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
extern void _ZN9S19869C18D1Ev();
extern void _ZN9S19869C18D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C18__8S19869C3[] = {
  ABISELECT(88,48),
  ABISELECT(184,104),
  ABISELECT(184,104),
  ABISELECT(160,88),
  ABISELECT(168,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&_ZN9S19869C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C18D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19869C18D1Ev,_ZTv0_n16_N9S19869C18D1Ev)();
extern void ABISELECT(_ZThn168_N9S19869C18D1Ev,_ZThn96_N9S19869C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C18D0Ev,_ZTv0_n16_N9S19869C18D0Ev)();
extern void ABISELECT(_ZThn168_N9S19869C18D0Ev,_ZThn96_N9S19869C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C18__8S19869C3[] = {
  ABISELECT(-168,-96),
  -8,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C18D1Ev,_ZTv0_n16_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C18D0Ev,_ZTv0_n16_N9S19869C18D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C18D1Ev,_ZTvn4_n16_N9S19869C18D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C18D0Ev,_ZTvn4_n16_N9S19869C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A1__9S19869C18__8S19869C3[] = {
  ABISELECT(-176,-100),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C18D1Ev,_ZTvn4_n16_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C18D0Ev,_ZTvn4_n16_N9S19869C18D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C18D1Ev,_ZTv0_n12_N9S19869C18D1Ev)();
extern void ABISELECT(_ZThn88_N9S19869C18D1Ev,_ZThn48_N9S19869C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C18D0Ev,_ZTv0_n12_N9S19869C18D0Ev)();
extern void ABISELECT(_ZThn88_N9S19869C18D0Ev,_ZThn48_N9S19869C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C13__9S19869C18__8S19869C3[] = {
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C18D1Ev,_ZTv0_n12_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C18D0Ev,_ZTv0_n12_N9S19869C18D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S19869C18D1Ev,_ZTvn8_n12_N9S19869C18D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C18D0Ev,_ZTvn8_n12_N9S19869C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C13__9S19869C18__8S19869C3[] = {
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI9S19869C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C18D1Ev,_ZTvn8_n12_N9S19869C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C18D0Ev,_ZTvn8_n12_N9S19869C18D0Ev),
};
extern void _ZN9S19869C21D1Ev();
extern void _ZN9S19869C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C21__8S19869C3[] = {
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(120,64),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&_ZN9S19869C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C21D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev)();
extern void ABISELECT(_ZThn120_N9S19869C21D1Ev,_ZThn64_N9S19869C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev)();
extern void ABISELECT(_ZThn120_N9S19869C21D0Ev,_ZThn64_N9S19869C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C21__8S19869C3[] = {
  ABISELECT(-120,-64),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-120,-64),
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C21D1Ev,_ZThn20_N9S19869C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C21D0Ev,_ZThn20_N9S19869C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C5__A1__9S19869C21__8S19869C3[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void _ZN8S19869C9D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
extern void _ZN8S19869C9D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C9__8S19869C3[] = {
  ABISELECT(96,52),
  ABISELECT(72,36),
  ABISELECT(72,36),
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(8,4),
  ABISELECT(-16,-8),
  ABISELECT(8,4),
  ABISELECT(104,56),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev)();
extern void _ZN9S19869C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev)();
extern void _ZN9S19869C17D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C178S19869C9__8S19869C3[] = {
  ABISELECT(104,56),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn8_N8S19869C9D1Ev,_ZThn4_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn8_N8S19869C9D0Ev,_ZThn4_N8S19869C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C10__8S19869C9__8S19869C3[] = {
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  ABISELECT(-24,-12),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S19869C9D1Ev,_ZTv0_n24_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn16_N8S19869C9D1Ev,_ZThn8_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19869C9D0Ev,_ZTv0_n24_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn16_N8S19869C9D0Ev,_ZThn8_N8S19869C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C11__8S19869C9__8S19869C3[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C9D1Ev,_ZTv0_n24_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19869C9D0Ev,_ZTv0_n24_N8S19869C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S19869C9D1Ev,_ZThn16_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn32_N8S19869C9D0Ev,_ZThn16_N8S19869C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C13__8S19869C9__8S19869C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N8S19869C9D1Ev,_ZTvn8_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S19869C9D0Ev,_ZTvn8_n12_N8S19869C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C13__A1__8S19869C9__8S19869C3[] = {
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S19869C9D1Ev,_ZTvn8_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S19869C9D0Ev,_ZTvn8_n12_N8S19869C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__A1__8S19869C9__8S19869C3[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S19869C9D1Ev,_ZTv0_n20_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn72_N8S19869C9D1Ev,_ZThn36_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19869C9D0Ev,_ZTv0_n20_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn72_N8S19869C9D0Ev,_ZThn36_N8S19869C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C14__8S19869C9__8S19869C3[] = {
  0,
  ABISELECT(-72,-36),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C9D1Ev,_ZTv0_n20_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19869C9D0Ev,_ZTv0_n20_N8S19869C9D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S19869C9D1Ev,_ZTv0_n16_N8S19869C9D1Ev)();
extern void ABISELECT(_ZThn96_N8S19869C9D1Ev,_ZThn52_N8S19869C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19869C9D0Ev,_ZTv0_n16_N8S19869C9D0Ev)();
extern void ABISELECT(_ZThn96_N8S19869C9D0Ev,_ZThn52_N8S19869C9D0Ev)() __attribute__((weak));
extern void _ZN9S19869C162v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C16__8S19869C9__8S19869C3[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-112,-60),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S19869C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C9D1Ev,_ZTv0_n16_N8S19869C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19869C9D0Ev,_ZTv0_n16_N8S19869C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19869C162v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void _ZN9S19869C10D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
extern void _ZN9S19869C10D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C10__8S19869C3[] = {
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  ABISELECT(-24,-12),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev)();
extern void ABISELECT(_ZThn8_N9S19869C10D1Ev,_ZThn4_N9S19869C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev)();
extern void ABISELECT(_ZThn8_N9S19869C10D0Ev,_ZThn4_N9S19869C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C11__9S19869C10__8S19869C3[] = {
  ABISELECT(-8,-4),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__A1__9S19869C10__8S19869C3[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C10D1Ev,_ZThn12_N9S19869C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C10D0Ev,_ZThn12_N9S19869C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C13__9S19869C10__8S19869C3[] = {
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S19869C10D1Ev,_ZTvn8_n12_N9S19869C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C10D0Ev,_ZTvn8_n12_N9S19869C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C13__A1__9S19869C10__8S19869C3[] = {
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C10D1Ev,_ZTvn8_n12_N9S19869C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C10D0Ev,_ZTvn8_n12_N9S19869C10D0Ev),
};
extern void _ZN9S19869C11D1Ev();
extern void _ZN9S19869C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C11__8S19869C3[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&_ZN9S19869C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C11D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt__A1__9S19869C11__8S19869C3[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__A1__9S19869C11__8S19869C3[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C13__9S19869C11__8S19869C3[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C13__A1__9S19869C11__8S19869C3[] = {
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D1Ev,_ZTvn8_n12_N9S19869C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S19869C11D0Ev,_ZTvn8_n12_N9S19869C11D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev)();
extern void _ZN9S19869C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev)();
extern void _ZN9S19869C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C14__8S19869C3[] = {
  0,
  0,
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__9S19869C14__8S19869C3[] = {
  ABISELECT(88,44),
  ABISELECT(88,44),
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev),
};
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19869C4__A1__8S19869C3[] = {
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__8S19869C4__A1__8S19869C3[] = {
  ABISELECT(88,44),
  ABISELECT(88,44),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
extern void _ZN9S19869C16D1Ev();
extern void _ZN9S19869C16D0Ev();
extern void _ZN9S19869C162v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C16__8S19869C3[] = {
  ABISELECT(-112,-60),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C16[0]),
  (VTBL_ENTRY)&_ZN9S19869C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C16D0Ev,
  (VTBL_ENTRY)&_ZN9S19869C162v1Ev,
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__8S19869C3[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19869C22D1Ev,_ZTv0_n20_N9S19869C22D1Ev)();
extern void _ZN9S19869C22D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C22D0Ev,_ZTv0_n20_N9S19869C22D0Ev)();
extern void _ZN9S19869C22D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C22__8S19869C3[] = {
  ABISELECT(192,100),
  ABISELECT(-8,-4),
  ABISELECT(176,92),
  ABISELECT(160,84),
  ABISELECT(152,80),
  ABISELECT(-136,-76),
  ABISELECT(144,76),
  ABISELECT(112,60),
  ABISELECT(72,40),
  ABISELECT(-32,-20),
  ABISELECT(-24,-12),
  ABISELECT(-64,-40),
  0,
  ABISELECT(-152,-84),
  ABISELECT(-152,-84),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C22D1Ev,_ZTv0_n20_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C22D0Ev,_ZTv0_n20_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev)();
extern void _ZN9S19869C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev)();
extern void _ZN9S19869C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C149S19869C22__A1__8S19869C3[] = {
  ABISELECT(-64,-40),
  0,
  ABISELECT(-152,-84),
  ABISELECT(-152,-84),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C149S19869C22__A1__8S19869C3[] = {
  ABISELECT(64,40),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(64,40),
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__9S19869C149S19869C22__A1__8S19869C3[] = {
  ABISELECT(152,84),
  ABISELECT(152,84),
  (VTBL_ENTRY)&(_ZTI9S19869C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D1Ev,_ZTv0_n12_N9S19869C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C14D0Ev,_ZTv0_n12_N9S19869C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C22D1Ev,_ZTv0_n16_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C22D0Ev,_ZTv0_n16_N9S19869C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C22__8S19869C3[] = {
  ABISELECT(24,12),
  -8,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C22D1Ev,_ZTv0_n16_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C22D0Ev,_ZTv0_n16_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C22D1Ev,_ZTvn4_n16_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C22D0Ev,_ZTvn4_n16_N9S19869C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A1__9S19869C22__8S19869C3[] = {
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C22D1Ev,_ZTvn4_n16_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C22D0Ev,_ZTvn4_n16_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn72_N9S19869C22D1Ev,_ZThn40_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn72_N9S19869C22D0Ev,_ZThn40_N9S19869C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C23__9S19869C22__8S19869C3[] = {
  ABISELECT(-72,-40),
  ABISELECT(-208,-116),
  ABISELECT(72,36),
  ABISELECT(-104,-60),
  ABISELECT(-96,-52),
  ABISELECT(40,20),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N9S19869C22D1Ev,_ZTv0_n28_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn112_N9S19869C22D1Ev,_ZThn60_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19869C22D0Ev,_ZTv0_n28_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn112_N9S19869C22D0Ev,_ZThn60_N9S19869C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C24__9S19869C22__8S19869C3[] = {
  ABISELECT(-112,-60),
  ABISELECT(-248,-136),
  ABISELECT(32,16),
  ABISELECT(-144,-80),
  ABISELECT(-136,-72),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C22D1Ev,_ZTv0_n28_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C22D0Ev,_ZTv0_n28_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__A2__9S19869C22__8S19869C3[] = {
  ABISELECT(136,76),
  ABISELECT(136,76),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTvn16_n64_N9S19869C22D1Ev,_ZTvn8_n32_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTvn16_n64_N9S19869C22D0Ev,_ZTvn8_n32_N9S19869C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C129S19869C139S19869C23__9S19869C22__8S19869C3[] = {
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N9S19869C22D1Ev,_ZTvn8_n32_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N9S19869C22D0Ev,_ZTvn8_n32_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn152_N9S19869C22D1Ev,_ZThn80_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn152_N9S19869C22D0Ev,_ZThn80_N9S19869C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C17__9S19869C22__8S19869C3[] = {
  ABISELECT(-184,-100),
  ABISELECT(-288,-156),
  ABISELECT(-152,-80),
  ABISELECT(-152,-80),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19869C22D1Ev,_ZTv0_n20_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19869C22D0Ev,_ZTv0_n20_N9S19869C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C22__8S19869C3[] = {
  ABISELECT(64,40),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(64,40),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C22D1Ev,_ZTv0_n20_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C22D0Ev,_ZTv0_n20_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__A2__9S19869C22__8S19869C3[] = {
  ABISELECT(152,84),
  ABISELECT(152,84),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn160_N9S19869C22D1Ev,_ZThn84_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn160_N9S19869C22D0Ev,_ZThn84_N9S19869C22D0Ev)() __attribute__((weak));
extern void _ZN9S19869C272v2Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C27__9S19869C22__8S19869C3[] = {
  0,
  ABISELECT(-160,-84),
  ABISELECT(-184,-96),
  ABISELECT(-192,-104),
  ABISELECT(32,16),
  ABISELECT(-168,-88),
  ABISELECT(16,8),
  ABISELECT(-160,-84),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev),
  (VTBL_ENTRY)&_ZN9S19869C272v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N9S19869C22D1Ev,_ZTv0_n24_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn176_N9S19869C22D1Ev,_ZThn92_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C22D0Ev,_ZTv0_n24_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn176_N9S19869C22D0Ev,_ZThn92_N9S19869C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C28__9S19869C22__8S19869C3[] = {
  ABISELECT(-176,-92),
  ABISELECT(16,8),
  ABISELECT(-184,-96),
  ABISELECT(-208,-112),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C22D1Ev,_ZTv0_n24_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C22D0Ev,_ZTv0_n24_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev)();
extern void ABISELECT(_ZThn192_N9S19869C22D1Ev,_ZThn100_N9S19869C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev)();
extern void ABISELECT(_ZThn192_N9S19869C22D0Ev,_ZThn100_N9S19869C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C12__A1__9S19869C22__8S19869C3[] = {
  ABISELECT(-192,-100),
  ABISELECT(-192,-100),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev),
};
extern void ABISELECT(_ZTvn8_n48_N9S19869C22D1Ev,_ZTvn4_n24_N9S19869C22D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N9S19869C22D0Ev,_ZTvn4_n24_N9S19869C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C199S19869C28__A9__9S19869C22__8S19869C3[] = {
  ABISELECT(-184,-96),
  (VTBL_ENTRY)&(_ZTI9S19869C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C22D1Ev,_ZTvn4_n24_N9S19869C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C22D0Ev,_ZTvn4_n24_N9S19869C22D0Ev),
};
extern void _ZN9S19869C23D1Ev();
extern void _ZN9S19869C23D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C23__8S19869C3[] = {
  ABISELECT(-208,-116),
  ABISELECT(72,36),
  ABISELECT(-104,-60),
  ABISELECT(-96,-52),
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&_ZN9S19869C23D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C23D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev)();
extern void ABISELECT(_ZThn40_N9S19869C23D1Ev,_ZThn20_N9S19869C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev)();
extern void ABISELECT(_ZThn40_N9S19869C23D0Ev,_ZThn20_N9S19869C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C24__9S19869C23__8S19869C3[] = {
  ABISELECT(-40,-20),
  ABISELECT(-248,-136),
  ABISELECT(32,16),
  ABISELECT(-144,-80),
  ABISELECT(-136,-72),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C23D1Ev,_ZTv0_n16_N9S19869C23D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C23D0Ev,_ZTv0_n16_N9S19869C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C23__8S19869C3[] = {
  ABISELECT(96,52),
  -8,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C23D1Ev,_ZTv0_n16_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C23D0Ev,_ZTv0_n16_N9S19869C23D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C23D1Ev,_ZTvn4_n16_N9S19869C23D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C23D0Ev,_ZTvn4_n16_N9S19869C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C23__8S19869C3[] = {
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C23D1Ev,_ZTvn4_n16_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C23D0Ev,_ZTvn4_n16_N9S19869C23D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__A2__9S19869C23__8S19869C3[] = {
  ABISELECT(208,116),
  ABISELECT(208,116),
  (VTBL_ENTRY)&(_ZTI9S19869C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C23D1Ev,_ZTv0_n12_N9S19869C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C23D0Ev,_ZTv0_n12_N9S19869C23D0Ev),
};
extern void _ZN9S19869C24D1Ev();
extern void _ZN9S19869C24D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C24__8S19869C3[] = {
  ABISELECT(-248,-136),
  ABISELECT(32,16),
  ABISELECT(-144,-80),
  ABISELECT(-136,-72),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&_ZN9S19869C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C24D0Ev,
};
extern void _ZN9S19869C25D1Ev();
extern void _ZN9S19869C25D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C259S19869C24__8S19869C3[] = {
  ABISELECT(-144,-80),
  ABISELECT(-136,-72),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&_ZN9S19869C25D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C25D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C259S19869C24__8S19869C3[] = {
  ABISELECT(136,72),
  -8,
  ABISELECT(136,72),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D1Ev,_ZTv0_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C25D0Ev,_ZTv0_n16_N9S19869C25D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C259S19869C24__8S19869C3[] = {
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI9S19869C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D1Ev,_ZTvn4_n16_N9S19869C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C25D0Ev,_ZTvn4_n16_N9S19869C25D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C24__8S19869C3[] = {
  ABISELECT(136,72),
  -8,
  ABISELECT(136,72),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D1Ev,_ZTv0_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C24D0Ev,_ZTv0_n16_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C24__8S19869C3[] = {
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D1Ev,_ZTvn4_n16_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C24D0Ev,_ZTvn4_n16_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__A2__9S19869C24__8S19869C3[] = {
  ABISELECT(248,136),
  ABISELECT(248,136),
  (VTBL_ENTRY)&(_ZTI9S19869C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D1Ev,_ZTv0_n12_N9S19869C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C24D0Ev,_ZTv0_n12_N9S19869C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev)();
extern void _ZN9S19869C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev)();
extern void _ZN9S19869C17D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C17__A1__8S19869C3[] = {
  ABISELECT(-184,-100),
  ABISELECT(-288,-156),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C6__9S19869C17__A1__8S19869C3[] = {
  ABISELECT(288,156),
  ABISELECT(288,156),
  (VTBL_ENTRY)&(_ZTI9S19869C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev),
};
extern void _ZN9S19869C27D1Ev();
extern void _ZN9S19869C27D0Ev();
extern void _ZN9S19869C272v2Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C27__8S19869C3[] = {
  ABISELECT(-184,-96),
  ABISELECT(-192,-104),
  ABISELECT(32,16),
  ABISELECT(-168,-88),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&_ZN9S19869C27D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C27D0Ev,
  (VTBL_ENTRY)&_ZN9S19869C272v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C27D1Ev,_ZThn8_N9S19869C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C27D0Ev,_ZThn8_N9S19869C27D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C28__9S19869C27__8S19869C3[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-184,-96),
  ABISELECT(-208,-112),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C27D1Ev,_ZThn16_N9S19869C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C27D0Ev,_ZThn16_N9S19869C27D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C12__9S19869C27__8S19869C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTvn8_n48_N9S19869C27D1Ev,_ZTvn4_n24_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N9S19869C27D0Ev,_ZTvn4_n24_N9S19869C27D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C199S19869C28__A2__9S19869C27__8S19869C3[] = {
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C27D1Ev,_ZTvn4_n24_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N9S19869C27D0Ev,_ZTvn4_n24_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19869C27D1Ev,_ZTv0_n16_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C27D0Ev,_ZTv0_n16_N9S19869C27D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19869C19__A1__9S19869C27__8S19869C3[] = {
  ABISELECT(184,96),
  -8,
  ABISELECT(184,96),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C27D1Ev,_ZTv0_n16_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C27D0Ev,_ZTv0_n16_N9S19869C27D0Ev),
};
extern void ABISELECT(_ZTvn8_n32_N9S19869C27D1Ev,_ZTvn4_n16_N9S19869C27D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C27D0Ev,_ZTvn4_n16_N9S19869C27D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S19869C7_nt9S19869C19__A4__9S19869C27__8S19869C3[] = {
  ABISELECT(176,92),
  (VTBL_ENTRY)&(_ZTI9S19869C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C27D1Ev,_ZTvn4_n16_N9S19869C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C27D0Ev,_ZTvn4_n16_N9S19869C27D0Ev),
};
extern void _ZN9S19869C28D1Ev();
extern void _ZN9S19869C28D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C28__8S19869C3[] = {
  ABISELECT(16,8),
  ABISELECT(-184,-96),
  ABISELECT(-208,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&_ZN9S19869C28D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C28D0Ev,
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C199S19869C28__A1__8S19869C3[] = {
  ABISELECT(-208,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev)();
extern void ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C12__9S19869C28__8S19869C3[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev),
};
static  VTT_ENTRY vtt_S19869C3[] = {
  {&(_ZTV8S19869C3[25]),  25,195},
  {&(_tg__ZTV8S19869C4__A__8S19869C3[4]),  4,6},
  {&(_tg__ZTV8S19869C5__8S19869C4__A__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C18__8S19869C3[7]),  7,9},
  {&(_tg__ZTV9S19869C19__9S19869C18__8S19869C3[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A1__9S19869C18__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C13__9S19869C18__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C13__9S19869C18__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C21__8S19869C3[5]),  5,7},
  {&(_tg__ZTV8S19869C4__9S19869C21__8S19869C3[5]),  5,7},
  {&(_tg__ZTV8S19869C5__A1__9S19869C21__8S19869C3[3]),  3,5},
  {&(_ZTV8S19869C3[46]),  46,195},
  {&(_ZTV8S19869C3[62]),  62,195},
  {&(_ZTV8S19869C3[72]),  72,195},
  {&(_ZTV8S19869C3[72]),  72,195},
  {&(_ZTV8S19869C3[80]),  80,195},
  {&(_ZTV8S19869C3[62]),  62,195},
  {&(_ZTV8S19869C3[85]),  85,195},
  {&(_ZTV8S19869C3[89]),  89,195},
  {&(_ZTV8S19869C3[97]),  97,195},
  {&(_ZTV8S19869C3[97]),  97,195},
  {&(_ZTV8S19869C3[104]),  104,195},
  {&(_ZTV8S19869C3[34]),  34,195},
  {&(_ZTV8S19869C3[111]),  111,195},
  {&(_ZTV8S19869C3[115]),  115,195},
  {&(_ZTV8S19869C3[41]),  41,195},
  {&(_ZTV8S19869C3[134]),  134,195},
  {&(_ZTV8S19869C3[144]),  144,195},
  {&(_ZTV8S19869C3[157]),  157,195},
  {&(_ZTV8S19869C3[148]),  148,195},
  {&(_ZTV8S19869C3[164]),  164,195},
  {&(_ZTV8S19869C3[175]),  175,195},
  {&(_ZTV8S19869C3[184]),  184,195},
  {&(_ZTV8S19869C3[193]),  193,195},
  {&(_ZTV8S19869C3[188]),  188,195},
  {&(_tg__ZTV8S19869C9__8S19869C3[14]),  14,16},
  {&(_tg__ZTV9S19869C178S19869C9__8S19869C3[5]),  5,7},
  {&(_tg__ZTV9S19869C178S19869C9__8S19869C3[5]),  5,7},
  {&(_tg__ZTV9S19869C10__8S19869C9__8S19869C3[8]),  8,10},
  {&(_tg__ZTV9S19869C10__8S19869C9__8S19869C3[8]),  8,10},
  {&(_tg__ZTV9S19869C11__8S19869C9__8S19869C3[6]),  6,8},
  {&(_tg__ZTV8S19869C9__8S19869C3[14]),  14,16},
  {&(_tg__ZTV9S19869C13__8S19869C9__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C13__A1__8S19869C9__8S19869C3[2]),  2,4},
  {&(_tg__ZTV8S19869C5__A1__8S19869C9__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C14__8S19869C9__8S19869C3[6]),  6,8},
  {&(_tg__ZTV9S19869C14__8S19869C9__8S19869C3[6]),  6,8},
  {&(_tg__ZTV9S19869C16__8S19869C9__8S19869C3[5]),  5,8},
  {&(_tg__ZTV9S19869C10__8S19869C3[8]),  8,10},
  {&(_tg__ZTV9S19869C10__8S19869C3[8]),  8,10},
  {&(_tg__ZTV9S19869C11__9S19869C10__8S19869C3[6]),  6,8},
  {&(_tg__ZTV8S19869C6__A1__9S19869C10__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C13__9S19869C10__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C13__A1__9S19869C10__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C11__8S19869C3[5]),  5,7},
  {&(_tg__ZTV11S19869C7_nt__A1__9S19869C11__8S19869C3[3]),  3,5},
  {&(_tg__ZTV8S19869C6__A1__9S19869C11__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C13__9S19869C11__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C13__A1__9S19869C11__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C14__8S19869C3[6]),  6,8},
  {&(_tg__ZTV9S19869C14__8S19869C3[6]),  6,8},
  {&(_tg__ZTV8S19869C5__9S19869C14__8S19869C3[3]),  3,5},
  {&(_tg__ZTV8S19869C4__A1__8S19869C3[4]),  4,6},
  {&(_tg__ZTV8S19869C5__8S19869C4__A1__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C16__8S19869C3[3]),  3,6},
  {&(_tg__ZTV9S19869C19__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C22__8S19869C3[17]),  17,19},
  {&(_tg__ZTV9S19869C149S19869C22__A1__8S19869C3[6]),  6,8},
  {&(_tg__ZTV8S19869C4__9S19869C149S19869C22__A1__8S19869C3[5]),  5,7},
  {&(_tg__ZTV8S19869C5__9S19869C149S19869C22__A1__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C19__9S19869C22__8S19869C3[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A1__9S19869C22__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C23__9S19869C22__8S19869C3[8]),  8,10},
  {&(_tg__ZTV9S19869C24__9S19869C22__8S19869C3[7]),  7,9},
  {&(_tg__ZTV8S19869C6__A2__9S19869C22__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C129S19869C139S19869C23__9S19869C22__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C17__9S19869C22__8S19869C3[5]),  5,7},
  {&(_tg__ZTV8S19869C4__9S19869C22__8S19869C3[5]),  5,7},
  {&(_tg__ZTV8S19869C5__A2__9S19869C22__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C27__9S19869C22__8S19869C3[9]),  9,12},
  {&(_tg__ZTV9S19869C28__9S19869C22__8S19869C3[6]),  6,8},
  {&(_tg__ZTV9S19869C12__A1__9S19869C22__8S19869C3[3]),  3,5},
  {&(_tg__ZTV11S19869C7_nt9S19869C199S19869C28__A9__9S19869C22__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C23__8S19869C3[7]),  7,9},
  {&(_tg__ZTV9S19869C24__9S19869C23__8S19869C3[7]),  7,9},
  {&(_tg__ZTV9S19869C19__9S19869C23__8S19869C3[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C23__8S19869C3[2]),  2,4},
  {&(_tg__ZTV8S19869C6__A2__9S19869C23__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C24__8S19869C3[6]),  6,8},
  {&(_tg__ZTV9S19869C259S19869C24__8S19869C3[4]),  4,6},
  {&(_tg__ZTV9S19869C19__9S19869C259S19869C24__8S19869C3[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C259S19869C24__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C19__9S19869C24__8S19869C3[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A2__9S19869C24__8S19869C3[2]),  2,4},
  {&(_tg__ZTV8S19869C6__A2__9S19869C24__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C17__A1__8S19869C3[5]),  5,7},
  {&(_tg__ZTV8S19869C6__9S19869C17__A1__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C27__8S19869C3[7]),  7,10},
  {&(_tg__ZTV9S19869C28__9S19869C27__8S19869C3[6]),  6,8},
  {&(_tg__ZTV9S19869C12__9S19869C27__8S19869C3[3]),  3,5},
  {&(_tg__ZTV11S19869C7_nt9S19869C199S19869C28__A2__9S19869C27__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C19__A1__9S19869C27__8S19869C3[4]),  4,6},
  {&(_tg__ZTV11S19869C7_nt9S19869C19__A4__9S19869C27__8S19869C3[2]),  2,4},
  {&(_tg__ZTV9S19869C28__8S19869C3[5]),  5,7},
  {&(_tg__ZTV9S19869C199S19869C28__A1__8S19869C3[3]),  3,5},
  {&(_tg__ZTV9S19869C12__9S19869C28__8S19869C3[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S19869C3[];
extern  VTBL_ENTRY _ZTV8S19869C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C3[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D0Ev,_ZThn8_N9S19869C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C28D1Ev,_ZThn8_N9S19869C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C27D0Ev,_ZTv0_n12_N9S19869C27D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C27D0Ev,_ZThn16_N9S19869C27D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C27D1Ev,_ZTv0_n12_N9S19869C27D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C27D1Ev,_ZThn16_N9S19869C27D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C27D0Ev,_ZTv0_n24_N9S19869C27D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C27D0Ev,_ZThn8_N9S19869C27D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C27D1Ev,_ZTv0_n24_N9S19869C27D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C27D1Ev,_ZThn8_N9S19869C27D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C23D0Ev,_ZTv0_n28_N9S19869C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C23D0Ev,_ZThn20_N9S19869C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C23D1Ev,_ZTv0_n28_N9S19869C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S19869C23D1Ev,_ZThn20_N9S19869C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C22D0Ev,_ZTv0_n24_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19869C22D0Ev,_ZThn92_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C22D1Ev,_ZTv0_n24_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19869C22D1Ev,_ZThn92_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C22D0Ev,_ZTv0_n12_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N9S19869C22D0Ev,_ZThn100_N9S19869C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn152_N9S19869C22D0Ev,_ZThn80_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C22D1Ev,_ZTv0_n12_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N9S19869C22D1Ev,_ZThn100_N9S19869C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn152_N9S19869C22D1Ev,_ZThn80_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C22D0Ev,_ZTv0_n28_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19869C22D0Ev,_ZThn60_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19869C22D1Ev,_ZTv0_n28_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19869C22D1Ev,_ZThn60_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19869C22D0Ev,_ZTv0_n32_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N9S19869C22D0Ev,_ZThn84_N9S19869C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C22D0Ev,_ZThn40_N9S19869C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19869C22D1Ev,_ZTv0_n32_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N9S19869C22D1Ev,_ZThn84_N9S19869C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C22D1Ev,_ZThn40_N9S19869C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C22D0Ev,_ZTv0_n20_N9S19869C22D0Ev), // 
  (VTBL_ENTRY)_ZN9S19869C22D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C22D1Ev,_ZTv0_n20_N9S19869C22D1Ev), // 
  (VTBL_ENTRY)_ZN9S19869C22D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C14D0Ev,_ZTv0_n20_N9S19869C14D0Ev), // 
  (VTBL_ENTRY)_ZN9S19869C14D0Ev,
  (VTBL_ENTRY)_ZN9S19869C14D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C14D1Ev,_ZTv0_n20_N9S19869C14D1Ev), // 
  (VTBL_ENTRY)_ZN9S19869C14D1Ev,
  (VTBL_ENTRY)_ZN9S19869C14D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D0Ev,_ZTv0_n12_N9S19869C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D0Ev,_ZThn8_N9S19869C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C11D1Ev,_ZTv0_n12_N9S19869C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19869C11D1Ev,_ZThn8_N9S19869C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C10D0Ev,_ZTv0_n24_N9S19869C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C10D0Ev,_ZThn4_N9S19869C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19869C10D1Ev,_ZTv0_n24_N9S19869C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C10D1Ev,_ZThn4_N9S19869C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C10D0Ev,_ZTv0_n12_N9S19869C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C10D0Ev,_ZThn12_N9S19869C10D0Ev),
  (VTBL_ENTRY)_ZN9S19869C10D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C10D1Ev,_ZTv0_n12_N9S19869C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C10D1Ev,_ZThn12_N9S19869C10D1Ev),
  (VTBL_ENTRY)_ZN9S19869C10D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19869C9D0Ev,_ZTv0_n16_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19869C9D0Ev,_ZThn52_N8S19869C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19869C9D1Ev,_ZTv0_n16_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19869C9D1Ev,_ZThn52_N8S19869C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19869C9D0Ev,_ZTv0_n20_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S19869C9D0Ev,_ZThn36_N8S19869C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19869C9D1Ev,_ZTv0_n20_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S19869C9D1Ev,_ZThn36_N8S19869C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19869C9D0Ev,_ZTv0_n24_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19869C9D0Ev,_ZThn8_N8S19869C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19869C9D1Ev,_ZTv0_n24_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19869C9D1Ev,_ZThn8_N8S19869C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D0Ev,
  (VTBL_ENTRY)_ZN9S19869C17D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D1Ev,
  (VTBL_ENTRY)_ZN9S19869C17D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C9D0Ev,_ZTv0_n12_N8S19869C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S19869C9D0Ev,_ZThn16_N8S19869C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C9D0Ev,_ZThn4_N8S19869C9D0Ev),
  (VTBL_ENTRY)_ZN8S19869C9D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C9D1Ev,_ZTv0_n12_N8S19869C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S19869C9D1Ev,_ZThn16_N8S19869C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S19869C9D1Ev,_ZThn4_N8S19869C9D1Ev),
  (VTBL_ENTRY)_ZN8S19869C9D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C21D0Ev,_ZThn20_N9S19869C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C21D1Ev,_ZThn20_N9S19869C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19869C21D0Ev,_ZThn64_N9S19869C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19869C21D1Ev,_ZThn64_N9S19869C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C18D0Ev,_ZTv0_n12_N9S19869C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N9S19869C18D0Ev,_ZThn48_N9S19869C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C18D1Ev,_ZTv0_n12_N9S19869C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N9S19869C18D1Ev,_ZThn48_N9S19869C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C18D0Ev,_ZTv0_n16_N9S19869C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N9S19869C18D0Ev,_ZThn96_N9S19869C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C18D1Ev,_ZTv0_n16_N9S19869C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N9S19869C18D1Ev,_ZThn96_N9S19869C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19869C4D0Ev,_ZThn28_N8S19869C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19869C4D1Ev,_ZThn28_N8S19869C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19869C3D0Ev,_ZTv0_n28_N8S19869C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S19869C3D0Ev,_ZThn172_N8S19869C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19869C3D1Ev,_ZTv0_n28_N8S19869C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S19869C3D1Ev,_ZThn172_N8S19869C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19869C3D0Ev,_ZTv0_n32_N8S19869C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S19869C3D0Ev,_ZThn196_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S19869C3D0Ev,_ZThn152_N8S19869C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19869C3D1Ev,_ZTv0_n32_N8S19869C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S19869C3D1Ev,_ZThn196_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S19869C3D1Ev,_ZThn152_N8S19869C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19869C3D0Ev,_ZTv0_n16_N8S19869C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S19869C3D0Ev,_ZThn100_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S19869C3D0Ev,_ZThn88_N8S19869C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19869C3D1Ev,_ZTv0_n16_N8S19869C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S19869C3D1Ev,_ZThn100_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S19869C3D1Ev,_ZThn88_N8S19869C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19869C3D0Ev,_ZTv0_n20_N8S19869C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S19869C3D0Ev,_ZThn112_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S19869C3D0Ev,_ZThn72_N8S19869C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19869C3D1Ev,_ZTv0_n20_N8S19869C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S19869C3D1Ev,_ZThn112_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S19869C3D1Ev,_ZThn72_N8S19869C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19869C3D0Ev,_ZTv0_n24_N8S19869C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn376_N8S19869C3D0Ev,_ZThn204_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19869C3D0Ev,_ZThn44_N8S19869C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19869C3D1Ev,_ZTv0_n24_N8S19869C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn376_N8S19869C3D1Ev,_ZThn204_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19869C3D1Ev,_ZThn44_N8S19869C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C3D0Ev,_ZTv0_n12_N8S19869C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S19869C3D0Ev,_ZThn212_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19869C3D0Ev,_ZThn192_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19869C3D0Ev,_ZThn52_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S19869C3D0Ev,_ZThn40_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S19869C3D0Ev,_ZThn36_N8S19869C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19869C3D0Ev,_ZThn28_N8S19869C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19869C3D1Ev,_ZTv0_n12_N8S19869C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S19869C3D1Ev,_ZThn212_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19869C3D1Ev,_ZThn192_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19869C3D1Ev,_ZThn52_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S19869C3D1Ev,_ZThn40_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S19869C3D1Ev,_ZThn36_N8S19869C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19869C3D1Ev,_ZThn28_N8S19869C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C3 = {  "S19869C3", // class name
  bases_S19869C3, 78,
  &(vtc_S19869C3[0]), // expected_vtbl_contents
  &(vtt_S19869C3[0]), // expected_vtt_contents
  ABISELECT(400,216), // object size
  NSPAIRA(_ZTI8S19869C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19869C3),195, //virtual function table var
  25, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19869C3),106, //virtual table table var
  59, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C29  : virtual S19869C15_nt , S19869C8 , virtual S19869C5 , S19869C21 , virtual S19869C12 {
  int s19869c29f0;
  virtual  ~S19869C29(); // _ZN9S19869C29D2Ev
  S19869C29(); // tgen
};
//SIG(-1 S19869C29) C1{ VBC2{ m FL} BC3{ BC4{ m}} VBC5{ BC6{ BC7{ vd m} vd} vd FC6} BC8{ BC5 VBC9{ VBC4 VBC5 BC3} Fi:3} VBC10{ BC6 vd} vd Fi}


 S19869C29 ::~S19869C29(){ note_dtor("S19869C29", this);}
S19869C29 ::S19869C29(){ note_ctor("S19869C29", this);} // tgen

static void Test_S19869C29()
{
  extern Class_Descriptor cd_S19869C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S19869C29, buf);
    S19869C29 *dp, &lv = *(dp=new (buf) S19869C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S19869C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C29)");
    check_base_class_offset(lv, (S19869C15_nt*), ABISELECT(24,16), "S19869C29");
    /*is_ambiguous_... S19869C29::S19869C8 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), 0, "S19869C29");
    /*is_ambiguous_... S19869C29::S19869C8 */ AMB_check_base_class_offset(lv, (S19869C8*), 0, "S19869C29");
    /*is_ambiguous_... S19869C29::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(32,24), "S19869C29");
    /*is_ambiguous_... S19869C29::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(32,24), "S19869C29");
    /*is_ambiguous_... S19869C29::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*), ABISELECT(32,24), "S19869C29");
    check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(32,24), "S19869C29");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C21*), 0, "S19869C29");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C21*), 0, "S19869C29");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C21*), 0, "S19869C29");
    /*is_ambiguous_... S19869C4::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), ABISELECT(56,36), "S19869C29");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), ABISELECT(48,32), "S19869C29");
    check_base_class_offset(lv, (S19869C8*)(S19869C4*), ABISELECT(48,32), "S19869C29");
    check_base_class_offset(lv, (S19869C4*)(S19869C21*), ABISELECT(48,32), "S19869C29");
    check_base_class_offset(lv, (S19869C21*), 0, "S19869C29");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(56,36), "S19869C29");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(56,36), "S19869C29");
    check_base_class_offset(lv, (S19869C12*), ABISELECT(56,36), "S19869C29");
    check_field_offset(lv, s19869c29f0, ABISELECT(20,12), "S19869C29.s19869c29f0");
    test_class_info(&lv, &cd_S19869C29);
    dp->~S19869C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C29(Test_S19869C29, "S19869C29", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN9S19869C29C1Ev();
extern void _ZN9S19869C29D2Ev();
Name_Map name_map_S19869C29[] = {
  NSPAIR(_ZN9S19869C29C1Ev),
  NSPAIR(_ZN9S19869C29D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
extern Class_Descriptor cd_S19869C21;
extern VTBL_ENTRY _ZTI9S19869C21[];
extern  VTBL_ENTRY _ZTV9S19869C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C21[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
static Base_Class bases_S19869C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C15_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(32,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C8,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C4,    ABISELECT(48,32), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19869C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(56,36), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C29[];
extern void _ZN9S19869C29D1Ev();
extern void _ZN9S19869C29D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19869C29D1Ev,_ZTv0_n12_N9S19869C29D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C29D1Ev,_ZThn24_N9S19869C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C29D0Ev,_ZTv0_n12_N9S19869C29D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C29D0Ev,_ZThn24_N9S19869C29D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C29D1Ev,_ZTv0_n20_N9S19869C29D1Ev)();
extern void ABISELECT(_ZThn48_N9S19869C29D1Ev,_ZThn32_N9S19869C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C29D0Ev,_ZTv0_n20_N9S19869C29D0Ev)();
extern void ABISELECT(_ZThn48_N9S19869C29D0Ev,_ZThn32_N9S19869C29D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C29D1Ev,_ZTv0_n12_N9S19869C29D1Ev)();
extern void ABISELECT(_ZThn56_N9S19869C29D1Ev,_ZThn36_N9S19869C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C29D0Ev,_ZTv0_n12_N9S19869C29D0Ev)();
extern void ABISELECT(_ZThn56_N9S19869C29D0Ev,_ZThn36_N9S19869C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C29[] = {
  ABISELECT(56,36),
  ABISELECT(24,16),
  ABISELECT(32,24),
  ABISELECT(56,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C29[0]),
  (VTBL_ENTRY)&_ZN9S19869C29D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C29D0Ev,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S19869C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C29D1Ev,_ZTv0_n12_N9S19869C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C29D0Ev,_ZTv0_n12_N9S19869C29D0Ev),
  ABISELECT(-48,-32),
  ABISELECT(-16,-8),
  ABISELECT(8,4),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S19869C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C29D1Ev,_ZTv0_n20_N9S19869C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C29D0Ev,_ZTv0_n20_N9S19869C29D0Ev),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S19869C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C29D1Ev,_ZTv0_n12_N9S19869C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C29D0Ev,_ZTv0_n12_N9S19869C29D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C29[];
extern void _ZN9S19869C21D1Ev();
extern void _ZN9S19869C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C21__9S19869C29[] = {
  ABISELECT(32,24),
  ABISELECT(56,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&_ZN9S19869C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C21D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev)();
extern void ABISELECT(_ZThn48_N9S19869C21D1Ev,_ZThn32_N9S19869C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev)();
extern void ABISELECT(_ZThn48_N9S19869C21D0Ev,_ZThn32_N9S19869C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C21__9S19869C29[] = {
  ABISELECT(-48,-32),
  ABISELECT(-16,-8),
  ABISELECT(8,4),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C21D1Ev,_ZThn24_N9S19869C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C21D0Ev,_ZThn24_N9S19869C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19869C5__A1__9S19869C21__9S19869C29[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S19869C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev),
};
extern void _ZN8S19869C4D1Ev();
extern void _ZN8S19869C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19869C4__9S19869C29[] = {
  ABISELECT(-16,-8),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&_ZN8S19869C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19869C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19869C5__8S19869C4__9S19869C29[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S19869C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D1Ev,_ZTv0_n12_N8S19869C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19869C4D0Ev,_ZTv0_n12_N8S19869C4D0Ev),
};
static  VTT_ENTRY vtt_S19869C29[] = {
  {&(_ZTV9S19869C29[7]),  7,26},
  {&(_tg__ZTV9S19869C21__9S19869C29[5]),  5,7},
  {&(_tg__ZTV8S19869C4__9S19869C21__9S19869C29[5]),  5,7},
  {&(_tg__ZTV8S19869C5__A1__9S19869C21__9S19869C29[3]),  3,5},
  {&(_ZTV9S19869C29[12]),  12,26},
  {&(_ZTV9S19869C29[19]),  19,26},
  {&(_ZTV9S19869C29[24]),  24,26},
  {&(_tg__ZTV8S19869C4__9S19869C29[4]),  4,6},
  {&(_tg__ZTV8S19869C5__8S19869C4__9S19869C29[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C29[];
extern  VTBL_ENTRY _ZTV9S19869C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C29[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C21D0Ev,_ZTv0_n12_N9S19869C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C21D0Ev,_ZThn24_N9S19869C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C21D1Ev,_ZTv0_n12_N9S19869C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C21D1Ev,_ZThn24_N9S19869C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C21D0Ev,_ZTv0_n20_N9S19869C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19869C21D0Ev,_ZThn32_N9S19869C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C21D1Ev,_ZTv0_n20_N9S19869C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19869C21D1Ev,_ZThn32_N9S19869C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C29D0Ev,_ZTv0_n20_N9S19869C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19869C29D0Ev,_ZThn32_N9S19869C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19869C29D1Ev,_ZTv0_n20_N9S19869C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19869C29D1Ev,_ZThn32_N9S19869C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C29D0Ev,_ZTv0_n12_N9S19869C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19869C29D0Ev,_ZThn36_N9S19869C29D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C29D0Ev,_ZThn24_N9S19869C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C29D1Ev,_ZTv0_n12_N9S19869C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19869C29D1Ev,_ZThn36_N9S19869C29D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C29D1Ev,_ZThn24_N9S19869C29D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C29 = {  "S19869C29", // class name
  bases_S19869C29, 17,
  &(vtc_S19869C29[0]), // expected_vtbl_contents
  &(vtt_S19869C29[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI9S19869C29),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19869C29),26, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C29),9, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C31  : S19869C12 , virtual S19869C20 , virtual S19869C6 , virtual S19869C7_nt {
  char s19869c31f0;
  virtual  ~S19869C31(); // _ZN9S19869C31D2Ev
  virtual void  v3(); // _ZN9S19869C312v3Ev
  S19869C31(); // tgen
};
//SIG(-1 S19869C31) C1{ BC2{ BC3{ BC4{ vd m} vd} vd} VBC5{ m FC3} VBC3 VBC4 vd v1 Fc}


 S19869C31 ::~S19869C31(){ note_dtor("S19869C31", this);}
void  S19869C31 ::v3(){vfunc_called(this, "_ZN9S19869C312v3Ev");}
S19869C31 ::S19869C31(){ note_ctor("S19869C31", this);} // tgen

static void Test_S19869C31()
{
  extern Class_Descriptor cd_S19869C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S19869C31, buf);
    S19869C31 *dp, &lv = *(dp=new (buf) S19869C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S19869C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C31)");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), 0, "S19869C31");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*), 0, "S19869C31");
    check_base_class_offset(lv, (S19869C12*), 0, "S19869C31");
    check_base_class_offset(lv, (S19869C20*), ABISELECT(16,8), "S19869C31");
    /*is_ambiguous_... S19869C31::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(24,12), "S19869C31");
    /*is_ambiguous_... S19869C31::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*), ABISELECT(24,12), "S19869C31");
    /*is_ambiguous_... S19869C31::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*), ABISELECT(32,16), "S19869C31");
    check_field_offset(lv, s19869c31f0, ABISELECT(8,4), "S19869C31.s19869c31f0");
    test_class_info(&lv, &cd_S19869C31);
    dp->~S19869C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C31(Test_S19869C31, "S19869C31", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S19869C31C1Ev();
extern void _ZN9S19869C31D2Ev();
Name_Map name_map_S19869C31[] = {
  NSPAIR(_ZN9S19869C31C1Ev),
  NSPAIR(_ZN9S19869C31D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
static Base_Class bases_S19869C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(24,12), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C31[];
extern void _ZN9S19869C31D1Ev();
extern void _ZN9S19869C31D0Ev();
extern void _ZN9S19869C312v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19869C31D1Ev,_ZTv0_n12_N9S19869C31D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C31D1Ev,_ZThn12_N9S19869C31D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C31D0Ev,_ZTv0_n12_N9S19869C31D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C31D0Ev,_ZThn12_N9S19869C31D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C31D1Ev,_ZTv0_n12_N9S19869C31D1Ev)();
extern void ABISELECT(_ZThn32_N9S19869C31D1Ev,_ZThn16_N9S19869C31D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C31D0Ev,_ZTv0_n12_N9S19869C31D0Ev)();
extern void ABISELECT(_ZThn32_N9S19869C31D0Ev,_ZThn16_N9S19869C31D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C31[] = {
  ABISELECT(32,16),
  ABISELECT(24,12),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C31[0]),
  (VTBL_ENTRY)&_ZN9S19869C31D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C31D0Ev,
  (VTBL_ENTRY)&_ZN9S19869C312v3Ev,
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C31D1Ev,_ZTv0_n12_N9S19869C31D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C31D0Ev,_ZTv0_n12_N9S19869C31D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19869C31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C31D1Ev,_ZTv0_n12_N9S19869C31D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C31D0Ev,_ZTv0_n12_N9S19869C31D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C31[];
static  VTT_ENTRY vtt_S19869C31[] = {
  {&(_ZTV9S19869C31[5]),  5,18},
  {&(_ZTV9S19869C31[11]),  11,18},
  {&(_ZTV9S19869C31[16]),  16,18},
};
extern VTBL_ENTRY _ZTI9S19869C31[];
extern  VTBL_ENTRY _ZTV9S19869C31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C31[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C31D0Ev,_ZTv0_n12_N9S19869C31D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C31D0Ev,_ZThn16_N9S19869C31D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C31D0Ev,_ZThn12_N9S19869C31D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C31D1Ev,_ZTv0_n12_N9S19869C31D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19869C31D1Ev,_ZThn16_N9S19869C31D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19869C31D1Ev,_ZThn12_N9S19869C31D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C31 = {  "S19869C31", // class name
  bases_S19869C31, 7,
  &(vtc_S19869C31[0]), // expected_vtbl_contents
  &(vtt_S19869C31[0]), // expected_vtt_contents
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S19869C31),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19869C31),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C31),3, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C33  : virtual S19869C15_nt , virtual S19869C19 , S19869C6 , S19869C17 , S19869C28 {
  __tsi64 s19869c33f0;
  int s19869c33f1;
  virtual  ~S19869C33(); // _ZN9S19869C33D2Ev
  S19869C33(); // tgen
};
//SIG(-1 S19869C33) C1{ VBC2{ m FL} VBC3{ BC4{ BC5{ vd m} vd} BC5 BC6{ m} VBC2 vd} BC4 BC7{ VBC4 VBC2 BC6} BC8{ VBC9{ BC6} VBC10{ BC4 vd} BC3 vd} vd FL Fi}


 S19869C33 ::~S19869C33(){ note_dtor("S19869C33", this);}
S19869C33 ::S19869C33(){ note_ctor("S19869C33", this);} // tgen

static void Test_S19869C33()
{
  extern Class_Descriptor cd_S19869C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S19869C33, buf);
    S19869C33 *dp, &lv = *(dp=new (buf) S19869C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S19869C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C33)");
    check_base_class_offset(lv, (S19869C15_nt*), ABISELECT(48,28), "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(48,28), "S19869C33");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C17*), ABISELECT(48,28), "S19869C33");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*)(S19869C28*), ABISELECT(48,28), "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(56,36), "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(56,36), "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(64,40), "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C19 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(56,36), "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C19*), ABISELECT(56,36), "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), 0, "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*), 0, "S19869C33");
    /*is_ambiguous_... S19869C33::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(8,4), "S19869C33");
    check_base_class_offset(lv, (S19869C6*)(S19869C17*), ABISELECT(8,4), "S19869C33");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C17*), ABISELECT(8,4), "S19869C33");
    check_base_class_offset(lv, (S19869C17*), ABISELECT(8,4), "S19869C33");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), 0, "S19869C33");
    check_base_class_offset(lv, (S19869C8*)(S19869C28*), 0, "S19869C33");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(72,44), "S19869C33");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(72,44), "S19869C33");
    check_base_class_offset(lv, (S19869C12*)(S19869C28*), ABISELECT(72,44), "S19869C33");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C33");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C33");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*)(S19869C28*), ABISELECT(24,12), "S19869C33");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C33");
    check_base_class_offset(lv, (S19869C19*)(S19869C28*), ABISELECT(16,8), "S19869C33");
    check_base_class_offset(lv, (S19869C28*), ABISELECT(16,8), "S19869C33");
    check_field_offset(lv, s19869c33f0, ABISELECT(32,16), "S19869C33.s19869c33f0");
    check_field_offset(lv, s19869c33f1, ABISELECT(40,24), "S19869C33.s19869c33f1");
    test_class_info(&lv, &cd_S19869C33);
    dp->~S19869C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C33(Test_S19869C33, "S19869C33", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN9S19869C33C1Ev();
extern void _ZN9S19869C33D2Ev();
Name_Map name_map_S19869C33[] = {
  NSPAIR(_ZN9S19869C33C1Ev),
  NSPAIR(_ZN9S19869C33D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C17;
extern VTBL_ENTRY _ZTI9S19869C17[];
extern  VTBL_ENTRY _ZTV9S19869C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C17[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C28;
extern VTBL_ENTRY _ZTI9S19869C28[];
extern  VTBL_ENTRY _ZTV9S19869C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C28[];
static Base_Class bases_S19869C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19869C15_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(64,40), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19869C19,    ABISELECT(56,36), //bcp->offset
    27, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19869C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19869C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S246C12_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C17,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(72,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(72,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(72,44), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(24,12), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S246C12_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19869C19,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19869C28,    ABISELECT(16,8), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19869C33[];
extern void _ZN9S19869C33D1Ev();
extern void _ZN9S19869C33D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19869C33D1Ev,_ZTv0_n12_N9S19869C33D1Ev)();
extern void ABISELECT(_ZThn8_N9S19869C33D1Ev,_ZThn4_N9S19869C33D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C33D0Ev,_ZTv0_n12_N9S19869C33D0Ev)();
extern void ABISELECT(_ZThn8_N9S19869C33D0Ev,_ZThn4_N9S19869C33D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZThn16_N9S19869C33D1Ev,_ZThn8_N9S19869C33D1Ev)();
extern void ABISELECT(_ZThn16_N9S19869C33D0Ev,_ZThn8_N9S19869C33D0Ev)();
extern void ABISELECT(_ZThn24_N9S19869C33D1Ev,_ZThn12_N9S19869C33D1Ev)();
extern void ABISELECT(_ZThn24_N9S19869C33D0Ev,_ZThn12_N9S19869C33D0Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19869C33D1Ev,_ZTv0_n16_N9S19869C33D1Ev)();
extern void ABISELECT(_ZThn56_N9S19869C33D1Ev,_ZThn36_N9S19869C33D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19869C33D0Ev,_ZTv0_n16_N9S19869C33D0Ev)();
extern void ABISELECT(_ZThn56_N9S19869C33D0Ev,_ZThn36_N9S19869C33D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S19869C33D1Ev,_ZTvn4_n16_N9S19869C33D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S19869C33D0Ev,_ZTvn4_n16_N9S19869C33D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19869C33D1Ev,_ZTv0_n12_N9S19869C33D1Ev)();
extern void ABISELECT(_ZThn72_N9S19869C33D1Ev,_ZThn44_N9S19869C33D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C33D0Ev,_ZTv0_n12_N9S19869C33D0Ev)();
extern void ABISELECT(_ZThn72_N9S19869C33D0Ev,_ZThn44_N9S19869C33D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19869C33[] = {
  ABISELECT(72,44),
  0,
  ABISELECT(8,4),
  ABISELECT(56,36),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C33[0]),
  (VTBL_ENTRY)&_ZN9S19869C33D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C33D0Ev,
  ABISELECT(40,24),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19869C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C33D1Ev,_ZTv0_n12_N9S19869C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C33D0Ev,_ZTv0_n12_N9S19869C33D0Ev),
  ABISELECT(56,36),
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19869C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19869C33D1Ev,_ZThn8_N9S19869C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19869C33D0Ev,_ZThn8_N9S19869C33D0Ev),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19869C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S19869C33D1Ev,_ZThn12_N9S19869C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S19869C33D0Ev,_ZThn12_N9S19869C33D0Ev),
  ABISELECT(-56,-36),
  -8,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S19869C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C33D1Ev,_ZTv0_n16_N9S19869C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19869C33D0Ev,_ZTv0_n16_N9S19869C33D0Ev),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S19869C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C33D1Ev,_ZTvn4_n16_N9S19869C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S19869C33D0Ev,_ZTvn4_n16_N9S19869C33D0Ev),
  ABISELECT(-72,-44),
  ABISELECT(-72,-44),
  (VTBL_ENTRY)&(_ZTI9S19869C33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C33D1Ev,_ZTv0_n12_N9S19869C33D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C33D0Ev,_ZTv0_n12_N9S19869C33D0Ev),
};
extern VTBL_ENTRY _ZTV9S19869C33[];
extern void ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev)();
extern void _ZN9S19869C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev)();
extern void _ZN9S19869C17D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C17__9S19869C33[] = {
  ABISELECT(40,24),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev),
};
extern void _ZN9S19869C28D1Ev();
extern void _ZN9S19869C28D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C28__9S19869C33[] = {
  ABISELECT(56,36),
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&_ZN9S19869C28D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C28D0Ev,
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C199S19869C28__A1__9S19869C33[] = {
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev)();
extern void ABISELECT(_ZThn56_N9S19869C28D1Ev,_ZThn36_N9S19869C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev)();
extern void ABISELECT(_ZThn56_N9S19869C28D0Ev,_ZThn36_N9S19869C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19869C12__9S19869C28__9S19869C33[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S19869C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev),
};
extern void _ZN9S19869C19D1Ev();
extern void _ZN9S19869C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19869C19__9S19869C33[] = {
  -8,
  0,
  (VTBL_ENTRY)&(_ZTI9S19869C19[0]),
  (VTBL_ENTRY)&_ZN9S19869C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19869C19D0Ev,
};
static  VTT_ENTRY vtt_S19869C33[] = {
  {&(_ZTV9S19869C33[7]),  7,42},
  {&(_tg__ZTV9S19869C17__9S19869C33[5]),  5,7},
  {&(_tg__ZTV9S19869C17__9S19869C33[5]),  5,7},
  {&(_tg__ZTV9S19869C28__9S19869C33[5]),  5,7},
  {&(_tg__ZTV9S19869C199S19869C28__A1__9S19869C33[3]),  3,5},
  {&(_tg__ZTV9S19869C12__9S19869C28__9S19869C33[3]),  3,5},
  {&(_ZTV9S19869C33[31]),  31,42},
  {&(_ZTV9S19869C33[35]),  35,42},
  {&(_ZTV9S19869C33[14]),  14,42},
  {&(_ZTV9S19869C33[14]),  14,42},
  {&(_ZTV9S19869C33[21]),  21,42},
  {&(_ZTV9S19869C33[40]),  40,42},
  {&(_tg__ZTV9S19869C19__9S19869C33[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19869C33[];
extern  VTBL_ENTRY _ZTV9S19869C33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C33[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D0Ev,_ZTv0_n12_N9S19869C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19869C28D0Ev,_ZThn36_N9S19869C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C28D1Ev,_ZTv0_n12_N9S19869C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19869C28D1Ev,_ZThn36_N9S19869C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D0Ev,_ZTv0_n12_N9S19869C17D0Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C17D1Ev,_ZTv0_n12_N9S19869C17D1Ev), // 
  (VTBL_ENTRY)_ZN9S19869C17D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C33D0Ev,_ZTv0_n16_N9S19869C33D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19869C33D0Ev,_ZThn36_N9S19869C33D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19869C33D1Ev,_ZTv0_n16_N9S19869C33D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19869C33D1Ev,_ZThn36_N9S19869C33D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C33D0Ev,_ZTv0_n12_N9S19869C33D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C33D0Ev,_ZThn44_N9S19869C33D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C33D0Ev,_ZThn4_N9S19869C33D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19869C33D1Ev,_ZTv0_n12_N9S19869C33D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N9S19869C33D1Ev,_ZThn44_N9S19869C33D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19869C33D1Ev,_ZThn4_N9S19869C33D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19869C33 = {  "S19869C33", // class name
  bases_S19869C33, 23,
  &(vtc_S19869C33[0]), // expected_vtbl_contents
  &(vtt_S19869C33[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI9S19869C33),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19869C33),42, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19869C33),13, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19869C32  : virtual S19869C10 , S19869C23 , S19869C33 , S19869C29 {
  virtual  ~S19869C32(); // _ZN9S19869C32D2Ev
  virtual void  v4(); // _ZN9S19869C322v4Ev
  S19869C32(); // tgen
};
//SIG(-1 S19869C32) C1{ VBC2{ VBC3{ m} VBC4{ vd m} VBC5{ BC6{ BC7{ BC4 vd} vd} VBC4 VBC7 VBC8{ BC9{ BC7 vd FC7} BC6 Fl Fi} Fi}} BC10{ VBC11{ BC12{ BC9 VBC13{ BC7 BC4 BC3 VBC14{ m FL} vd} Fi} VBC15{ m Fp} VBC7 BC16{ m FC7}} BC8 vd} BC17{ VBC14 VBC13 BC7 BC18{ VBC7 VBC14 BC3} BC19{ VBC20{ BC3} VBC6 BC13 vd} vd FL Fi} BC21{ VBC14 BC20 VBC9 BC22{ BC9 VBC23{ VBC3 VBC9 BC20} Fi:3} VBC6 vd Fi} vd v1}


 S19869C32 ::~S19869C32(){ note_dtor("S19869C32", this);}
void  S19869C32 ::v4(){vfunc_called(this, "_ZN9S19869C322v4Ev");}
S19869C32 ::S19869C32(){ note_ctor("S19869C32", this);} // tgen

static void Test_S19869C32()
{
  extern Class_Descriptor cd_S19869C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,38)];
    init_test(&cd_S19869C32, buf);
    S19869C32 *dp, &lv = *(dp=new (buf) S19869C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,148), "sizeof(S19869C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19869C32)");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C10*), 0, "S19869C32");
    /*is_ambiguous_... S19869C4::S246C12_nt */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C4*), 0, "S19869C32");
    /*is_ambiguous_... S19869C10::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C10*), ABISELECT(112,64), "S19869C32");
    /*is_ambiguous_... S19869C11::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C11*), ABISELECT(112,64), "S19869C32");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(120,68), "S19869C32");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C11*), ABISELECT(120,68), "S19869C32");
    /*is_ambiguous_... S19869C11::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C12*)(S19869C11*), ABISELECT(120,68), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*), ABISELECT(48,24), "S19869C32");
    /*is_ambiguous_... S19869C11::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C11*), ABISELECT(48,24), "S19869C32");
    /*is_ambiguous_... S19869C24::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C24*), ABISELECT(48,24), "S19869C32");
    check_base_class_offset(lv, (S19869C6*)(S19869C17*)(S19869C33*), ABISELECT(48,24), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(136,76), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*), ABISELECT(136,76), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C13*), ABISELECT(136,76), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(152,84), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*), ABISELECT(152,84), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C13 */ AMB_check_base_class_offset(lv, (S19869C12*)(S19869C13*), ABISELECT(152,84), "S19869C32");
    check_base_class_offset(lv, (S19869C13*)(S19869C11*), ABISELECT(136,76), "S19869C32");
    check_base_class_offset(lv, (S19869C11*)(S19869C10*), ABISELECT(120,68), "S19869C32");
    check_base_class_offset(lv, (S19869C10*), ABISELECT(112,64), "S19869C32");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(176,96), "S19869C32");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(176,96), "S19869C32");
    check_base_class_offset(lv, (S19869C5*)(S19869C25*)(S19869C24*), ABISELECT(176,96), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*), ABISELECT(208,112), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C19*), ABISELECT(208,112), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*), ABISELECT(216,116), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C19 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C19*), ABISELECT(208,112), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*), ABISELECT(224,120), "S19869C32");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C33*), ABISELECT(224,120), "S19869C32");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C17*)(S19869C33*), ABISELECT(224,120), "S19869C32");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C19*)(S19869C28*)(S19869C33*), ABISELECT(224,120), "S19869C32");
    check_base_class_offset(lv, (S19869C15_nt*)(S19869C29*), ABISELECT(224,120), "S19869C32");
    check_base_class_offset(lv, (S19869C19*)(S19869C25*)(S19869C24*), ABISELECT(208,112), "S19869C32");
    /*is_ambiguous_... S19869C33::S19869C19 */ AMB_check_base_class_offset(lv, (S19869C19*)(S19869C33*), ABISELECT(208,112), "S19869C32");
    check_base_class_offset(lv, (S19869C25*)(S19869C24*), ABISELECT(176,96), "S19869C32");
    check_base_class_offset(lv, (S19869C26_nt*)(S19869C24*), ABISELECT(232,128), "S19869C32");
    check_base_class_offset(lv, (S19869C20*)(S19869C24*), ABISELECT(200,108), "S19869C32");
    check_base_class_offset(lv, (S19869C24*)(S19869C23*), ABISELECT(176,96), "S19869C32");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C13*)(S19869C23*), 0, "S19869C32");
    check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C13*)(S19869C23*), 0, "S19869C32");
    check_base_class_offset(lv, (S19869C5*)(S19869C13*)(S19869C23*), 0, "S19869C32");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(16,8), "S19869C32");
    check_base_class_offset(lv, (S19869C6*)(S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(16,8), "S19869C32");
    check_base_class_offset(lv, (S19869C12*)(S19869C13*)(S19869C23*), ABISELECT(16,8), "S19869C32");
    check_base_class_offset(lv, (S19869C13*)(S19869C23*), 0, "S19869C32");
    check_base_class_offset(lv, (S19869C23*), 0, "S19869C32");
    /*is_ambiguous_... S19869C33::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C33*), ABISELECT(40,20), "S19869C32");
    /*is_ambiguous_... S19869C33::S19869C6 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C33*), ABISELECT(40,20), "S19869C32");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C17*)(S19869C33*), ABISELECT(48,24), "S19869C32");
    check_base_class_offset(lv, (S19869C17*)(S19869C33*), ABISELECT(48,24), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C8 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C8*), ABISELECT(240,132), "S19869C32");
    check_base_class_offset(lv, (S19869C8*)(S19869C28*)(S19869C33*), ABISELECT(240,132), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C12*), ABISELECT(240,132), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C12 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C12*), ABISELECT(240,132), "S19869C32");
    check_base_class_offset(lv, (S19869C12*)(S19869C28*)(S19869C33*), ABISELECT(240,132), "S19869C32");
    check_base_class_offset(lv, (S19869C12*)(S19869C29*), ABISELECT(240,132), "S19869C32");
    check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C19*)(S19869C28*)(S19869C33*), ABISELECT(56,28), "S19869C32");
    check_base_class_offset(lv, (S19869C6*)(S19869C19*)(S19869C28*)(S19869C33*), ABISELECT(56,28), "S19869C32");
    /*is_ambiguous_... S19869C19::S19869C7_nt */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C19*)(S19869C28*)(S19869C33*), ABISELECT(64,32), "S19869C32");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C19*)(S19869C28*)(S19869C33*), ABISELECT(56,28), "S19869C32");
    check_base_class_offset(lv, (S19869C19*)(S19869C28*)(S19869C33*), ABISELECT(56,28), "S19869C32");
    check_base_class_offset(lv, (S19869C28*)(S19869C33*), ABISELECT(56,28), "S19869C32");
    check_base_class_offset(lv, (S19869C33*), ABISELECT(40,20), "S19869C32");
    /*is_ambiguous_... S19869C29::S19869C8 */ AMB_check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C29*), ABISELECT(88,48), "S19869C32");
    /*is_ambiguous_... S19869C29::S19869C8 */ AMB_check_base_class_offset(lv, (S19869C8*)(S19869C29*), ABISELECT(88,48), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*), ABISELECT(248,136), "S19869C32");
    /*is_ambiguous_... S19869C32::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*), ABISELECT(248,136), "S19869C32");
    /*is_ambiguous_... S19869C29::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C29*), ABISELECT(248,136), "S19869C32");
    check_base_class_offset(lv, (S19869C5*)(S19869C4*), ABISELECT(248,136), "S19869C32");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C7_nt*)(S19869C6*)(S19869C5*)(S19869C21*)(S19869C29*), ABISELECT(88,48), "S19869C32");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C6*)(S19869C5*)(S19869C21*)(S19869C29*), ABISELECT(88,48), "S19869C32");
    /*is_ambiguous_... S19869C21::S19869C5 */ AMB_check_base_class_offset(lv, (S19869C5*)(S19869C21*)(S19869C29*), ABISELECT(88,48), "S19869C32");
    check_base_class_offset(lv, (S246C12_nt*)(S19869C8*)(S19869C4*), ABISELECT(264,144), "S19869C32");
    check_base_class_offset(lv, (S19869C8*)(S19869C4*), ABISELECT(264,144), "S19869C32");
    check_base_class_offset(lv, (S19869C4*)(S19869C21*)(S19869C29*), ABISELECT(264,144), "S19869C32");
    check_base_class_offset(lv, (S19869C21*)(S19869C29*), ABISELECT(88,48), "S19869C32");
    check_base_class_offset(lv, (S19869C29*), ABISELECT(88,48), "S19869C32");
    test_class_info(&lv, &cd_S19869C32);
    dp->~S19869C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19869C32(Test_S19869C32, "S19869C32", ABISELECT(272,148));

#else // __cplusplus

extern void _ZN9S19869C32C1Ev();
extern void _ZN9S19869C32D2Ev();
Name_Map name_map_S19869C32[] = {
  NSPAIR(_ZN9S19869C32C1Ev),
  NSPAIR(_ZN9S19869C32D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
extern Class_Descriptor cd_S19869C11;
extern VTBL_ENTRY _ZTI9S19869C11[];
extern  VTBL_ENTRY _ZTV9S19869C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C11[];
extern Class_Descriptor cd_S19869C10;
extern VTBL_ENTRY _ZTI9S19869C10[];
extern  VTBL_ENTRY _ZTV9S19869C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C10[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C15_nt;
extern VTBL_ENTRY _ZTI12S19869C15_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C25;
extern VTBL_ENTRY _ZTI9S19869C25[];
extern  VTBL_ENTRY _ZTV9S19869C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C25[];
extern Class_Descriptor cd_S19869C26_nt;
extern VTBL_ENTRY _ZTI12S19869C26_nt[];
extern Class_Descriptor cd_S19869C20;
extern VTBL_ENTRY _ZTI9S19869C20[];
extern Class_Descriptor cd_S19869C24;
extern VTBL_ENTRY _ZTI9S19869C24[];
extern  VTBL_ENTRY _ZTV9S19869C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C24[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C13;
extern VTBL_ENTRY _ZTI9S19869C13[];
extern  VTBL_ENTRY _ZTV9S19869C13[];
extern Class_Descriptor cd_S19869C23;
extern VTBL_ENTRY _ZTI9S19869C23[];
extern  VTBL_ENTRY _ZTV9S19869C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C23[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C17;
extern VTBL_ENTRY _ZTI9S19869C17[];
extern  VTBL_ENTRY _ZTV9S19869C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C17[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C12;
extern VTBL_ENTRY _ZTI9S19869C12[];
extern  VTBL_ENTRY _ZTV9S19869C12[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C19;
extern VTBL_ENTRY _ZTI9S19869C19[];
extern  VTBL_ENTRY _ZTV9S19869C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C19[];
extern Class_Descriptor cd_S19869C28;
extern VTBL_ENTRY _ZTI9S19869C28[];
extern  VTBL_ENTRY _ZTV9S19869C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C28[];
extern Class_Descriptor cd_S19869C33;
extern VTBL_ENTRY _ZTI9S19869C33[];
extern  VTBL_ENTRY _ZTV9S19869C33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C33[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S19869C7_nt;
extern VTBL_ENTRY _ZTI11S19869C7_nt[];
extern  VTBL_ENTRY _ZTV11S19869C7_nt[];
extern Class_Descriptor cd_S19869C6;
extern VTBL_ENTRY _ZTI8S19869C6[];
extern  VTBL_ENTRY _ZTV8S19869C6[];
extern Class_Descriptor cd_S19869C5;
extern VTBL_ENTRY _ZTI8S19869C5[];
extern  VTBL_ENTRY _ZTV8S19869C5[];
extern Class_Descriptor cd_S246C12_nt;
extern VTBL_ENTRY _ZTI10S246C12_nt[];
extern Class_Descriptor cd_S19869C8;
extern VTBL_ENTRY _ZTI8S19869C8[];
extern Class_Descriptor cd_S19869C4;
extern VTBL_ENTRY _ZTI8S19869C4[];
extern  VTBL_ENTRY _ZTV8S19869C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19869C4[];
extern Class_Descriptor cd_S19869C21;
extern VTBL_ENTRY _ZTI9S19869C21[];
extern  VTBL_ENTRY _ZTV9S19869C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C21[];
extern Class_Descriptor cd_S19869C29;
extern VTBL_ENTRY _ZTI9S19869C29[];
extern  VTBL_ENTRY _ZTV9S19869C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19869C29[];
static Base_Class bases_S19869C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S246C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(112,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C7_nt,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(152,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(152,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19869C12,    ABISELECT(152,84), //bcp->offset
    82, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19869C13,    ABISELECT(136,76), //bcp->offset
    77, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19869C11,    ABISELECT(120,68), //bcp->offset
    69, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S19869C10,    ABISELECT(112,64), //bcp->offset
    59, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19869C7_nt,    ABISELECT(176,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(176,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19869C5,    ABISELECT(176,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(208,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19869C6,    ABISELECT(208,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19869C7_nt,    ABISELECT(216,116), //bcp->offset
    101, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vt