// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S10180C2  {
  virtual  ~S10180C2(); // _ZN8S10180C2D1Ev
  virtual void  v7(); // _ZN8S10180C22v7Ev
  S10180C2(); // tgen
};
//SIG(-1 S10180C2) C1{ vd v1}


 S10180C2 ::~S10180C2(){ note_dtor("S10180C2", this);}
void  S10180C2 ::v7(){vfunc_called(this, "_ZN8S10180C22v7Ev");}
S10180C2 ::S10180C2(){ note_ctor("S10180C2", this);} // tgen

static void Test_S10180C2()
{
  extern Class_Descriptor cd_S10180C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10180C2, buf);
    S10180C2 *dp, &lv = *(dp=new (buf) S10180C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C2)");
    test_class_info(&lv, &cd_S10180C2);
    dp->~S10180C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C2(Test_S10180C2, "S10180C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10180C2C1Ev();
extern void _ZN8S10180C2D1Ev();
Name_Map name_map_S10180C2[] = {
  NSPAIR(_ZN8S10180C2C1Ev),
  NSPAIR(_ZN8S10180C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10180C2[];
extern void _ZN8S10180C2D1Ev();
extern void _ZN8S10180C2D0Ev();
extern void _ZN8S10180C22v7Ev();
static  VTBL_ENTRY vtc_S10180C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10180C2[0]),
  (VTBL_ENTRY)&_ZN8S10180C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10180C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
};
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
Class_Descriptor cd_S10180C2 = {  "S10180C2", // class name
  0,0,//no base classes
  &(vtc_S10180C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10180C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10180C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C3  {
  void *s10180c3f0;
  virtual  ~S10180C3(); // _ZN8S10180C3D1Ev
  virtual void  v8(); // _ZN8S10180C32v8Ev
  virtual void  v9(); // _ZN8S10180C32v9Ev
  virtual void  v10(); // _ZN8S10180C33v10Ev
  virtual void  v11(); // _ZN8S10180C33v11Ev
  virtual void  v12(); // _ZN8S10180C33v12Ev
  S10180C3(); // tgen
};
//SIG(-1 S10180C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10180C3 ::~S10180C3(){ note_dtor("S10180C3", this);}
void  S10180C3 ::v8(){vfunc_called(this, "_ZN8S10180C32v8Ev");}
void  S10180C3 ::v9(){vfunc_called(this, "_ZN8S10180C32v9Ev");}
void  S10180C3 ::v10(){vfunc_called(this, "_ZN8S10180C33v10Ev");}
void  S10180C3 ::v11(){vfunc_called(this, "_ZN8S10180C33v11Ev");}
void  S10180C3 ::v12(){vfunc_called(this, "_ZN8S10180C33v12Ev");}
S10180C3 ::S10180C3(){ note_ctor("S10180C3", this);} // tgen

static void Test_S10180C3()
{
  extern Class_Descriptor cd_S10180C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10180C3, buf);
    S10180C3 *dp, &lv = *(dp=new (buf) S10180C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10180C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C3)");
    check_field_offset(lv, s10180c3f0, ABISELECT(8,4), "S10180C3.s10180c3f0");
    test_class_info(&lv, &cd_S10180C3);
    dp->~S10180C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C3(Test_S10180C3, "S10180C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10180C3C1Ev();
extern void _ZN8S10180C3D1Ev();
Name_Map name_map_S10180C3[] = {
  NSPAIR(_ZN8S10180C3C1Ev),
  NSPAIR(_ZN8S10180C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10180C3[];
extern void _ZN8S10180C3D1Ev();
extern void _ZN8S10180C3D0Ev();
extern void _ZN8S10180C32v8Ev();
extern void _ZN8S10180C32v9Ev();
extern void _ZN8S10180C33v10Ev();
extern void _ZN8S10180C33v11Ev();
extern void _ZN8S10180C33v12Ev();
static  VTBL_ENTRY vtc_S10180C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10180C3[0]),
  (VTBL_ENTRY)&_ZN8S10180C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10180C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10180C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10180C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10180C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10180C33v11Ev,
  (VTBL_ENTRY)&_ZN8S10180C33v12Ev,
};
extern VTBL_ENTRY _ZTI8S10180C3[];
extern  VTBL_ENTRY _ZTV8S10180C3[];
Class_Descriptor cd_S10180C3 = {  "S10180C3", // class name
  0,0,//no base classes
  &(vtc_S10180C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10180C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10180C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C7  {
  void  mf10180c7(); // _ZN8S10180C79mf10180c7Ev
};
//SIG(-1 S10180C7) C1{ m}


void  S10180C7 ::mf10180c7(){}

static void Test_S10180C7()
{
  {
    init_simple_test("S10180C7");
    S10180C7 lv;
    check2(sizeof(lv), 1, "sizeof(S10180C7)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C7)");
  }
}
static Arrange_To_Call_Me vS10180C7(Test_S10180C7, "S10180C7", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C6  {
  void *s10180c6f0;
  int s10180c6f1;
  ::S10180C7 s10180c6f2;
  ::S10180C7 s10180c6f3;
  void  mf10180c6(); // _ZN8S10180C69mf10180c6Ev
};
//SIG(-1 S10180C6) C1{ m Fp Fi FC2{ m} FC2}


void  S10180C6 ::mf10180c6(){}

static void Test_S10180C6()
{
  {
    init_simple_test("S10180C6");
    S10180C6 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C6)");
    check_field_offset(lv, s10180c6f0, 0, "S10180C6.s10180c6f0");
    check_field_offset(lv, s10180c6f1, ABISELECT(8,4), "S10180C6.s10180c6f1");
    check_field_offset(lv, s10180c6f2, ABISELECT(12,8), "S10180C6.s10180c6f2");
    check_field_offset(lv, s10180c6f3, ABISELECT(13,9), "S10180C6.s10180c6f3");
  }
}
static Arrange_To_Call_Me vS10180C6(Test_S10180C6, "S10180C6", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S10180C6 = {  "S10180C6", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C5  : S10180C6 {
};
//SIG(-1 S10180C5) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S10180C5()
{
  extern Class_Descriptor cd_S10180C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S10180C5, buf);
    S10180C5 &lv = *(new (buf) S10180C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C5)");
    check_base_class_offset(lv, (S10180C6*), 0, "S10180C5");
    test_class_info(&lv, &cd_S10180C5);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C5(Test_S10180C5, "S10180C5", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S10180C6;
static Base_Class bases_S10180C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10180C5 = {  "S10180C5", // class name
  bases_S10180C5, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C4  {
  void *s10180c4f0;
  ::S10180C5 s10180c4f1;
  void  mf10180c4(); // _ZN8S10180C49mf10180c4Ev
};
//SIG(-1 S10180C4) C1{ m Fp FC2{ BC3{ m Fp Fi FC4{ m} FC4}}}


void  S10180C4 ::mf10180c4(){}

static void Test_S10180C4()
{
  {
    init_simple_test("S10180C4");
    S10180C4 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10180C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C4)");
    check_field_offset(lv, s10180c4f0, 0, "S10180C4.s10180c4f0");
    check_field_offset(lv, s10180c4f1, ABISELECT(8,4), "S10180C4.s10180c4f1");
  }
}
static Arrange_To_Call_Me vS10180C4(Test_S10180C4, "S10180C4", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C9  {
  int s10180c9f0;
  void *s10180c9f1;
  int s10180c9f2[4];
  void *s10180c9f3;
  void  mf10180c9(); // _ZN8S10180C99mf10180c9Ev
};
//SIG(-1 S10180C9) C1{ m Fi Fp Fi[4] Fp}


void  S10180C9 ::mf10180c9(){}

static void Test_S10180C9()
{
  {
    init_simple_test("S10180C9");
    S10180C9 lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S10180C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C9)");
    check_field_offset(lv, s10180c9f0, 0, "S10180C9.s10180c9f0");
    check_field_offset(lv, s10180c9f1, ABISELECT(8,4), "S10180C9.s10180c9f1");
    check_field_offset(lv, s10180c9f2, ABISELECT(16,8), "S10180C9.s10180c9f2");
    check_field_offset(lv, s10180c9f3, ABISELECT(32,24), "S10180C9.s10180c9f3");
  }
}
static Arrange_To_Call_Me vS10180C9(Test_S10180C9, "S10180C9", ABISELECT(40,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C14  {
  void  mf10180c14(); // _ZN9S10180C1410mf10180c14Ev
};
//SIG(-1 S10180C14) C1{ m}


void  S10180C14 ::mf10180c14(){}

static void Test_S10180C14()
{
  {
    init_simple_test("S10180C14");
    S10180C14 lv;
    check2(sizeof(lv), 1, "sizeof(S10180C14)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C14)");
  }
}
static Arrange_To_Call_Me vS10180C14(Test_S10180C14, "S10180C14", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S10180C14[];
VTBL_ENTRY *P__ZTI9S10180C14 = _ZTI9S10180C14; 
Class_Descriptor cd_S10180C14 = {  "S10180C14", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S10180C14),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C13  {
  void *s10180c13f0;
  int s10180c13f1;
  ::S10180C14 s10180c13f2;
  void  mf10180c13(); // _ZN9S10180C1310mf10180c13Ev
};
//SIG(-1 S10180C13) C1{ m Fp Fi FC2{ m}}


void  S10180C13 ::mf10180c13(){}

static void Test_S10180C13()
{
  {
    init_simple_test("S10180C13");
    S10180C13 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C13)");
    check_field_offset(lv, s10180c13f0, 0, "S10180C13.s10180c13f0");
    check_field_offset(lv, s10180c13f1, ABISELECT(8,4), "S10180C13.s10180c13f1");
    check_field_offset(lv, s10180c13f2, ABISELECT(12,8), "S10180C13.s10180c13f2");
  }
}
static Arrange_To_Call_Me vS10180C13(Test_S10180C13, "S10180C13", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C12  {
  ::S10180C13 s10180c12f0;
  int s10180c12f1;
  void  mf10180c12(); // _ZN9S10180C1210mf10180c12Ev
};
//SIG(-1 S10180C12) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S10180C12 ::mf10180c12(){}

static void Test_S10180C12()
{
  {
    init_simple_test("S10180C12");
    S10180C12 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10180C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C12)");
    check_field_offset(lv, s10180c12f0, 0, "S10180C12.s10180c12f0");
    check_field_offset(lv, s10180c12f1, ABISELECT(16,12), "S10180C12.s10180c12f1");
  }
}
static Arrange_To_Call_Me vS10180C12(Test_S10180C12, "S10180C12", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C15  {
  int s10180c15f0[4];
  void *s10180c15f1;
  char s10180c15f2;
  int s10180c15f3[2];
  void *s10180c15f4[2];
  void  mf10180c15(); // _ZN9S10180C1510mf10180c15Ev
};
//SIG(-1 S10180C15) C1{ m Fi[4] Fp Fc Fi[2] Fp[2]}


void  S10180C15 ::mf10180c15(){}

static void Test_S10180C15()
{
  {
    init_simple_test("S10180C15");
    S10180C15 lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(S10180C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C15)");
    check_field_offset(lv, s10180c15f0, 0, "S10180C15.s10180c15f0");
    check_field_offset(lv, s10180c15f1, 16, "S10180C15.s10180c15f1");
    check_field_offset(lv, s10180c15f2, ABISELECT(24,20), "S10180C15.s10180c15f2");
    check_field_offset(lv, s10180c15f3, ABISELECT(28,24), "S10180C15.s10180c15f3");
    check_field_offset(lv, s10180c15f4, ABISELECT(40,32), "S10180C15.s10180c15f4");
  }
}
static Arrange_To_Call_Me vS10180C15(Test_S10180C15, "S10180C15", ABISELECT(56,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C11  {
  void *s10180c11f0;
  ::S10180C12 s10180c11f1;
  ::S10180C15 s10180c11f2;
  virtual  ~S10180C11(); // _ZN9S10180C11D1Ev
  virtual void  v15(); // _ZN9S10180C113v15Ev
  virtual void  v16(); // _ZN9S10180C113v16Ev
  virtual void  v17(); // _ZN9S10180C113v17Ev
  virtual void  v18(); // _ZN9S10180C113v18Ev
  virtual void  v19(); // _ZN9S10180C113v19Ev
  virtual void  v20(); // _ZN9S10180C113v20Ev
  virtual void  v21(); // _ZN9S10180C113v21Ev
  virtual void  v22(); // _ZN9S10180C113v22Ev
  virtual void  v23(); // _ZN9S10180C113v23Ev
  virtual void  v24(); // _ZN9S10180C113v24Ev
  virtual void  v25(); // _ZN9S10180C113v25Ev
  virtual void  v26(); // _ZN9S10180C113v26Ev
  virtual void  v27(); // _ZN9S10180C113v27Ev
  virtual void  v28(); // _ZN9S10180C113v28Ev
  virtual void  v29(); // _ZN9S10180C113v29Ev
  virtual void  v30(); // _ZN9S10180C113v30Ev
  virtual void  v31(); // _ZN9S10180C113v31Ev
  virtual void  v32(); // _ZN9S10180C113v32Ev
  virtual void  v33(); // _ZN9S10180C113v33Ev
  virtual void  v34(); // _ZN9S10180C113v34Ev
  virtual void  v35(); // _ZN9S10180C113v35Ev
  virtual void  v36(); // _ZN9S10180C113v36Ev
  virtual void  v37(); // _ZN9S10180C113v37Ev
  virtual void  v38(); // _ZN9S10180C113v38Ev
  S10180C11(); // tgen
};
//SIG(-1 S10180C11) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]}}


 S10180C11 ::~S10180C11(){ note_dtor("S10180C11", this);}
void  S10180C11 ::v15(){vfunc_called(this, "_ZN9S10180C113v15Ev");}
void  S10180C11 ::v16(){vfunc_called(this, "_ZN9S10180C113v16Ev");}
void  S10180C11 ::v17(){vfunc_called(this, "_ZN9S10180C113v17Ev");}
void  S10180C11 ::v18(){vfunc_called(this, "_ZN9S10180C113v18Ev");}
void  S10180C11 ::v19(){vfunc_called(this, "_ZN9S10180C113v19Ev");}
void  S10180C11 ::v20(){vfunc_called(this, "_ZN9S10180C113v20Ev");}
void  S10180C11 ::v21(){vfunc_called(this, "_ZN9S10180C113v21Ev");}
void  S10180C11 ::v22(){vfunc_called(this, "_ZN9S10180C113v22Ev");}
void  S10180C11 ::v23(){vfunc_called(this, "_ZN9S10180C113v23Ev");}
void  S10180C11 ::v24(){vfunc_called(this, "_ZN9S10180C113v24Ev");}
void  S10180C11 ::v25(){vfunc_called(this, "_ZN9S10180C113v25Ev");}
void  S10180C11 ::v26(){vfunc_called(this, "_ZN9S10180C113v26Ev");}
void  S10180C11 ::v27(){vfunc_called(this, "_ZN9S10180C113v27Ev");}
void  S10180C11 ::v28(){vfunc_called(this, "_ZN9S10180C113v28Ev");}
void  S10180C11 ::v29(){vfunc_called(this, "_ZN9S10180C113v29Ev");}
void  S10180C11 ::v30(){vfunc_called(this, "_ZN9S10180C113v30Ev");}
void  S10180C11 ::v31(){vfunc_called(this, "_ZN9S10180C113v31Ev");}
void  S10180C11 ::v32(){vfunc_called(this, "_ZN9S10180C113v32Ev");}
void  S10180C11 ::v33(){vfunc_called(this, "_ZN9S10180C113v33Ev");}
void  S10180C11 ::v34(){vfunc_called(this, "_ZN9S10180C113v34Ev");}
void  S10180C11 ::v35(){vfunc_called(this, "_ZN9S10180C113v35Ev");}
void  S10180C11 ::v36(){vfunc_called(this, "_ZN9S10180C113v36Ev");}
void  S10180C11 ::v37(){vfunc_called(this, "_ZN9S10180C113v37Ev");}
void  S10180C11 ::v38(){vfunc_called(this, "_ZN9S10180C113v38Ev");}
S10180C11 ::S10180C11(){ note_ctor("S10180C11", this);} // tgen

static void Test_S10180C11()
{
  extern Class_Descriptor cd_S10180C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,17)];
    init_test(&cd_S10180C11, buf);
    S10180C11 *dp, &lv = *(dp=new (buf) S10180C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,64), "sizeof(S10180C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C11)");
    check_field_offset(lv, s10180c11f0, ABISELECT(8,4), "S10180C11.s10180c11f0");
    check_field_offset(lv, s10180c11f1, ABISELECT(16,8), "S10180C11.s10180c11f1");
    check_field_offset(lv, s10180c11f2, ABISELECT(40,24), "S10180C11.s10180c11f2");
    test_class_info(&lv, &cd_S10180C11);
    dp->~S10180C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C11(Test_S10180C11, "S10180C11", ABISELECT(96,64));

#else // __cplusplus

extern void _ZN9S10180C11C1Ev();
extern void _ZN9S10180C11D1Ev();
Name_Map name_map_S10180C11[] = {
  NSPAIR(_ZN9S10180C11C1Ev),
  NSPAIR(_ZN9S10180C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C11[];
extern void _ZN9S10180C11D1Ev();
extern void _ZN9S10180C11D0Ev();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
static  VTBL_ENTRY vtc_S10180C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C11[0]),
  (VTBL_ENTRY)&_ZN9S10180C11D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C11D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
};
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
Class_Descriptor cd_S10180C11 = {  "S10180C11", // class name
  0,0,//no base classes
  &(vtc_S10180C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,64), // object size
  NSPAIRA(_ZTI9S10180C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C11),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C10  : S10180C11 {
  ::S10180C12 s10180c10f0;
  void *s10180c10f1;
  virtual  ~S10180C10(); // _ZN9S10180C10D1Ev
  virtual void  v13(); // _ZN9S10180C103v13Ev
  virtual void  v14(); // _ZN9S10180C103v14Ev
  S10180C10(); // tgen
};
//SIG(-1 S10180C10) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} FC6{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 FC3 Fp}


 S10180C10 ::~S10180C10(){ note_dtor("S10180C10", this);}
void  S10180C10 ::v13(){vfunc_called(this, "_ZN9S10180C103v13Ev");}
void  S10180C10 ::v14(){vfunc_called(this, "_ZN9S10180C103v14Ev");}
S10180C10 ::S10180C10(){ note_ctor("S10180C10", this);} // tgen

static void Test_S10180C10()
{
  extern Class_Descriptor cd_S10180C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,22)];
    init_test(&cd_S10180C10, buf);
    S10180C10 *dp, &lv = *(dp=new (buf) S10180C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,84), "sizeof(S10180C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C10)");
    check_base_class_offset(lv, (S10180C11*), 0, "S10180C10");
    check_field_offset(lv, s10180c10f0, ABISELECT(96,64), "S10180C10.s10180c10f0");
    check_field_offset(lv, s10180c10f1, ABISELECT(120,80), "S10180C10.s10180c10f1");
    test_class_info(&lv, &cd_S10180C10);
    dp->~S10180C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C10(Test_S10180C10, "S10180C10", ABISELECT(128,84));

#else // __cplusplus

extern void _ZN9S10180C10C1Ev();
extern void _ZN9S10180C10D1Ev();
Name_Map name_map_S10180C10[] = {
  NSPAIR(_ZN9S10180C10C1Ev),
  NSPAIR(_ZN9S10180C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C10[];
extern void _ZN9S10180C10D1Ev();
extern void _ZN9S10180C10D0Ev();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void _ZN9S10180C103v13Ev();
extern void _ZN9S10180C103v14Ev();
static  VTBL_ENTRY vtc_S10180C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C10[0]),
  (VTBL_ENTRY)&_ZN9S10180C10D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C10D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  (VTBL_ENTRY)&_ZN9S10180C103v13Ev,
  (VTBL_ENTRY)&_ZN9S10180C103v14Ev,
};
extern VTBL_ENTRY _ZTI9S10180C10[];
extern  VTBL_ENTRY _ZTV9S10180C10[];
Class_Descriptor cd_S10180C10 = {  "S10180C10", // class name
  bases_S10180C10, 1,
  &(vtc_S10180C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,84), // object size
  NSPAIRA(_ZTI9S10180C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C10),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C20  {
  void  mf10180c20(); // _ZN9S10180C2010mf10180c20Ev
};
//SIG(-1 S10180C20) C1{ m}


void  S10180C20 ::mf10180c20(){}

static void Test_S10180C20()
{
  {
    init_simple_test("S10180C20");
    S10180C20 lv;
    check2(sizeof(lv), 1, "sizeof(S10180C20)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C20)");
  }
}
static Arrange_To_Call_Me vS10180C20(Test_S10180C20, "S10180C20", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S10180C20[];
VTBL_ENTRY *P__ZTI9S10180C20 = _ZTI9S10180C20; 
Class_Descriptor cd_S10180C20 = {  "S10180C20", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S10180C20),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C18  {
  void *s10180c18f0;
  int s10180c18f1;
  ::S10180C14 s10180c18f2;
  ::S10180C20 s10180c18f3;
  void  mf10180c18(); // _ZN9S10180C1810mf10180c18Ev
};
//SIG(-1 S10180C18) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S10180C18 ::mf10180c18(){}

static void Test_S10180C18()
{
  {
    init_simple_test("S10180C18");
    S10180C18 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C18)");
    check_field_offset(lv, s10180c18f0, 0, "S10180C18.s10180c18f0");
    check_field_offset(lv, s10180c18f1, ABISELECT(8,4), "S10180C18.s10180c18f1");
    check_field_offset(lv, s10180c18f2, ABISELECT(12,8), "S10180C18.s10180c18f2");
    check_field_offset(lv, s10180c18f3, ABISELECT(13,9), "S10180C18.s10180c18f3");
  }
}
static Arrange_To_Call_Me vS10180C18(Test_S10180C18, "S10180C18", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S10180C18 = {  "S10180C18", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C17  {
  ::S10180C18 s10180c17f0;
  ::S10180C18 s10180c17f1;
  char s10180c17f2;
  void  mf10180c17(); // _ZN9S10180C1710mf10180c17Ev
  virtual  ~S10180C17(); // _ZN9S10180C17D1Ev
  S10180C17(); // tgen
};
//SIG(-1 S10180C17) C1{ vd m FC2{ m Fp Fi FC3{ m} FC4{ m}} FC2 Fc}


void  S10180C17 ::mf10180c17(){}
 S10180C17 ::~S10180C17(){ note_dtor("S10180C17", this);}
S10180C17 ::S10180C17(){ note_ctor("S10180C17", this);} // tgen

static void Test_S10180C17()
{
  extern Class_Descriptor cd_S10180C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S10180C17, buf);
    S10180C17 *dp, &lv = *(dp=new (buf) S10180C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S10180C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C17)");
    check_field_offset(lv, s10180c17f0, ABISELECT(8,4), "S10180C17.s10180c17f0");
    check_field_offset(lv, s10180c17f1, ABISELECT(24,16), "S10180C17.s10180c17f1");
    check_field_offset(lv, s10180c17f2, ABISELECT(40,28), "S10180C17.s10180c17f2");
    test_class_info(&lv, &cd_S10180C17);
    dp->~S10180C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C17(Test_S10180C17, "S10180C17", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN9S10180C17C1Ev();
extern void _ZN9S10180C17D1Ev();
Name_Map name_map_S10180C17[] = {
  NSPAIR(_ZN9S10180C17C1Ev),
  NSPAIR(_ZN9S10180C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C17[];
extern void _ZN9S10180C17D1Ev();
extern void _ZN9S10180C17D0Ev();
static  VTBL_ENTRY vtc_S10180C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C17[0]),
  (VTBL_ENTRY)&_ZN9S10180C17D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C17D0Ev,
};
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
Class_Descriptor cd_S10180C17 = {  "S10180C17", // class name
  0,0,//no base classes
  &(vtc_S10180C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI9S10180C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C17),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C24  {
  virtual  ~S10180C24(); // _ZN9S10180C24D1Ev
  virtual void  v41(); // _ZN9S10180C243v41Ev
  S10180C24(); // tgen
};
//SIG(-1 S10180C24) C1{ vd v1}


 S10180C24 ::~S10180C24(){ note_dtor("S10180C24", this);}
void  S10180C24 ::v41(){vfunc_called(this, "_ZN9S10180C243v41Ev");}
S10180C24 ::S10180C24(){ note_ctor("S10180C24", this);} // tgen

static void Test_S10180C24()
{
  extern Class_Descriptor cd_S10180C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10180C24, buf);
    S10180C24 *dp, &lv = *(dp=new (buf) S10180C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C24)");
    test_class_info(&lv, &cd_S10180C24);
    dp->~S10180C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C24(Test_S10180C24, "S10180C24", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10180C24C1Ev();
extern void _ZN9S10180C24D1Ev();
Name_Map name_map_S10180C24[] = {
  NSPAIR(_ZN9S10180C24C1Ev),
  NSPAIR(_ZN9S10180C24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C24[];
extern void _ZN9S10180C24D1Ev();
extern void _ZN9S10180C24D0Ev();
extern void _ZN9S10180C243v41Ev();
static  VTBL_ENTRY vtc_S10180C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C24[0]),
  (VTBL_ENTRY)&_ZN9S10180C24D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C24D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10180C24[];
extern  VTBL_ENTRY _ZTV9S10180C24[];
Class_Descriptor cd_S10180C24 = {  "S10180C24", // class name
  0,0,//no base classes
  &(vtc_S10180C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10180C24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C24),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C26  {
  virtual  ~S10180C26(); // _ZN9S10180C26D1Ev
  virtual void  v64(); // _ZN9S10180C263v64Ev
  S10180C26(); // tgen
};
//SIG(-1 S10180C26) C1{ vd v1}


 S10180C26 ::~S10180C26(){ note_dtor("S10180C26", this);}
void  S10180C26 ::v64(){vfunc_called(this, "_ZN9S10180C263v64Ev");}
S10180C26 ::S10180C26(){ note_ctor("S10180C26", this);} // tgen

static void Test_S10180C26()
{
  extern Class_Descriptor cd_S10180C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10180C26, buf);
    S10180C26 *dp, &lv = *(dp=new (buf) S10180C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C26)");
    test_class_info(&lv, &cd_S10180C26);
    dp->~S10180C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C26(Test_S10180C26, "S10180C26", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10180C26C1Ev();
extern void _ZN9S10180C26D1Ev();
Name_Map name_map_S10180C26[] = {
  NSPAIR(_ZN9S10180C26C1Ev),
  NSPAIR(_ZN9S10180C26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C26[];
extern void _ZN9S10180C26D1Ev();
extern void _ZN9S10180C26D0Ev();
extern void _ZN9S10180C263v64Ev();
static  VTBL_ENTRY vtc_S10180C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C26[0]),
  (VTBL_ENTRY)&_ZN9S10180C26D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C26D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C263v64Ev,
};
extern VTBL_ENTRY _ZTI9S10180C26[];
extern  VTBL_ENTRY _ZTV9S10180C26[];
Class_Descriptor cd_S10180C26 = {  "S10180C26", // class name
  0,0,//no base classes
  &(vtc_S10180C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10180C26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C26),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C27  {
  virtual  ~S10180C27(); // _ZN9S10180C27D1Ev
  virtual void  v65(); // _ZN9S10180C273v65Ev
  virtual void  v66(); // _ZN9S10180C273v66Ev
  S10180C27(); // tgen
};
//SIG(-1 S10180C27) C1{ vd v1 v2}


 S10180C27 ::~S10180C27(){ note_dtor("S10180C27", this);}
void  S10180C27 ::v65(){vfunc_called(this, "_ZN9S10180C273v65Ev");}
void  S10180C27 ::v66(){vfunc_called(this, "_ZN9S10180C273v66Ev");}
S10180C27 ::S10180C27(){ note_ctor("S10180C27", this);} // tgen

static void Test_S10180C27()
{
  extern Class_Descriptor cd_S10180C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10180C27, buf);
    S10180C27 *dp, &lv = *(dp=new (buf) S10180C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C27)");
    test_class_info(&lv, &cd_S10180C27);
    dp->~S10180C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C27(Test_S10180C27, "S10180C27", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10180C27C1Ev();
extern void _ZN9S10180C27D1Ev();
Name_Map name_map_S10180C27[] = {
  NSPAIR(_ZN9S10180C27C1Ev),
  NSPAIR(_ZN9S10180C27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C27[];
extern void _ZN9S10180C27D1Ev();
extern void _ZN9S10180C27D0Ev();
extern void _ZN9S10180C273v65Ev();
extern void _ZN9S10180C273v66Ev();
static  VTBL_ENTRY vtc_S10180C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C27[0]),
  (VTBL_ENTRY)&_ZN9S10180C27D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C27D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C273v65Ev,
  (VTBL_ENTRY)&_ZN9S10180C273v66Ev,
};
extern VTBL_ENTRY _ZTI9S10180C27[];
extern  VTBL_ENTRY _ZTV9S10180C27[];
Class_Descriptor cd_S10180C27 = {  "S10180C27", // class name
  0,0,//no base classes
  &(vtc_S10180C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10180C27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C27),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C28  {
  int s10180c28f0[2];
  void  mf10180c28(); // _ZN9S10180C2810mf10180c28Ev
};
//SIG(-1 S10180C28) C1{ m Fi[2]}


void  S10180C28 ::mf10180c28(){}

static void Test_S10180C28()
{
  {
    init_simple_test("S10180C28");
    S10180C28 lv;
    check2(sizeof(lv), 8, "sizeof(S10180C28)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C28)");
    check_field_offset(lv, s10180c28f0, 0, "S10180C28.s10180c28f0");
  }
}
static Arrange_To_Call_Me vS10180C28(Test_S10180C28, "S10180C28", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C32  {
  void *s10180c32f0;
  int s10180c32f1[2];
  ::S10180C20 s10180c32f2;
  void  mf10180c32(); // _ZN9S10180C3210mf10180c32Ev
};
//SIG(-1 S10180C32) C1{ m Fp Fi[2] FC2{ m}}


void  S10180C32 ::mf10180c32(){}

static void Test_S10180C32()
{
  {
    init_simple_test("S10180C32");
    S10180C32 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10180C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C32)");
    check_field_offset(lv, s10180c32f0, 0, "S10180C32.s10180c32f0");
    check_field_offset(lv, s10180c32f1, ABISELECT(8,4), "S10180C32.s10180c32f1");
    check_field_offset(lv, s10180c32f2, ABISELECT(16,12), "S10180C32.s10180c32f2");
  }
}
static Arrange_To_Call_Me vS10180C32(Test_S10180C32, "S10180C32", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C31  {
  ::S10180C32 s10180c31f0;
  void *s10180c31f1[2];
  void  mf10180c31(); // _ZN9S10180C3110mf10180c31Ev
};
//SIG(-1 S10180C31) C1{ m FC2{ m Fp Fi[2] FC3{ m}} Fp[2]}


void  S10180C31 ::mf10180c31(){}

static void Test_S10180C31()
{
  {
    init_simple_test("S10180C31");
    S10180C31 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S10180C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C31)");
    check_field_offset(lv, s10180c31f0, 0, "S10180C31.s10180c31f0");
    check_field_offset(lv, s10180c31f1, ABISELECT(24,16), "S10180C31.s10180c31f1");
  }
}
static Arrange_To_Call_Me vS10180C31(Test_S10180C31, "S10180C31", ABISELECT(40,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C29  : S10180C17 {
  int s10180c29f0;
  void *s10180c29f1;
  ::S10180C12 s10180c29f2;
  __tsi64 s10180c29f3;
  ::S10180C28 s10180c29f4;
  int s10180c29f5;
  char s10180c29f6;
  int s10180c29f7;
  ::S10180C31 s10180c29f8;
  virtual  ~S10180C29(); // _ZN9S10180C29D1Ev
  S10180C29(); // tgen
};
//SIG(-1 S10180C29) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd Fi Fp FC6{ m FC7{ m Fp Fi FC4} Fi} FL FC8{ m Fi[2]} Fi Fc Fi FC9{ m FC10{ m Fp Fi[2] FC5} Fp[2]}}


 S10180C29 ::~S10180C29(){ note_dtor("S10180C29", this);}
S10180C29 ::S10180C29(){ note_ctor("S10180C29", this);} // tgen

static void Test_S10180C29()
{
  extern Class_Descriptor cd_S10180C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,28)];
    init_test(&cd_S10180C29, buf);
    S10180C29 *dp, &lv = *(dp=new (buf) S10180C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,108), "sizeof(S10180C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C29)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C29");
    check_field_offset(lv, s10180c29f0, ABISELECT(44,32), "S10180C29.s10180c29f0");
    check_field_offset(lv, s10180c29f1, ABISELECT(48,36), "S10180C29.s10180c29f1");
    check_field_offset(lv, s10180c29f2, ABISELECT(56,40), "S10180C29.s10180c29f2");
    check_field_offset(lv, s10180c29f3, ABISELECT(80,56), "S10180C29.s10180c29f3");
    check_field_offset(lv, s10180c29f4, ABISELECT(88,64), "S10180C29.s10180c29f4");
    check_field_offset(lv, s10180c29f5, ABISELECT(96,72), "S10180C29.s10180c29f5");
    check_field_offset(lv, s10180c29f6, ABISELECT(100,76), "S10180C29.s10180c29f6");
    check_field_offset(lv, s10180c29f7, ABISELECT(104,80), "S10180C29.s10180c29f7");
    check_field_offset(lv, s10180c29f8, ABISELECT(112,84), "S10180C29.s10180c29f8");
    test_class_info(&lv, &cd_S10180C29);
    dp->~S10180C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C29(Test_S10180C29, "S10180C29", ABISELECT(152,108));

#else // __cplusplus

extern void _ZN9S10180C29C1Ev();
extern void _ZN9S10180C29D1Ev();
Name_Map name_map_S10180C29[] = {
  NSPAIR(_ZN9S10180C29C1Ev),
  NSPAIR(_ZN9S10180C29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C29[];
extern void _ZN9S10180C29D1Ev();
extern void _ZN9S10180C29D0Ev();
static  VTBL_ENTRY vtc_S10180C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C29[0]),
  (VTBL_ENTRY)&_ZN9S10180C29D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C29D0Ev,
};
extern VTBL_ENTRY _ZTI9S10180C29[];
extern  VTBL_ENTRY _ZTV9S10180C29[];
Class_Descriptor cd_S10180C29 = {  "S10180C29", // class name
  bases_S10180C29, 1,
  &(vtc_S10180C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,108), // object size
  NSPAIRA(_ZTI9S10180C29),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C29),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C34  : S10180C11 {
  virtual  ~S10180C34(); // _ZN9S10180C34D1Ev
  virtual void  v67(); // _ZN9S10180C343v67Ev
  virtual void  v68(); // _ZN9S10180C343v68Ev
  virtual void  v69(); // _ZN9S10180C343v69Ev
  S10180C34(); // tgen
};
//SIG(-1 S10180C34) C1{ BC2{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} FC6{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3}


 S10180C34 ::~S10180C34(){ note_dtor("S10180C34", this);}
void  S10180C34 ::v67(){vfunc_called(this, "_ZN9S10180C343v67Ev");}
void  S10180C34 ::v68(){vfunc_called(this, "_ZN9S10180C343v68Ev");}
void  S10180C34 ::v69(){vfunc_called(this, "_ZN9S10180C343v69Ev");}
S10180C34 ::S10180C34(){ note_ctor("S10180C34", this);} // tgen

static void Test_S10180C34()
{
  extern Class_Descriptor cd_S10180C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,17)];
    init_test(&cd_S10180C34, buf);
    S10180C34 *dp, &lv = *(dp=new (buf) S10180C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,64), "sizeof(S10180C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C34)");
    check_base_class_offset(lv, (S10180C11*), 0, "S10180C34");
    test_class_info(&lv, &cd_S10180C34);
    dp->~S10180C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C34(Test_S10180C34, "S10180C34", ABISELECT(96,64));

#else // __cplusplus

extern void _ZN9S10180C34C1Ev();
extern void _ZN9S10180C34D1Ev();
Name_Map name_map_S10180C34[] = {
  NSPAIR(_ZN9S10180C34C1Ev),
  NSPAIR(_ZN9S10180C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C34[];
extern void _ZN9S10180C34D1Ev();
extern void _ZN9S10180C34D0Ev();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void _ZN9S10180C343v67Ev();
extern void _ZN9S10180C343v68Ev();
extern void _ZN9S10180C343v69Ev();
static  VTBL_ENTRY vtc_S10180C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C34[0]),
  (VTBL_ENTRY)&_ZN9S10180C34D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C34D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  (VTBL_ENTRY)&_ZN9S10180C343v67Ev,
  (VTBL_ENTRY)&_ZN9S10180C343v68Ev,
  (VTBL_ENTRY)&_ZN9S10180C343v69Ev,
};
extern VTBL_ENTRY _ZTI9S10180C34[];
extern  VTBL_ENTRY _ZTV9S10180C34[];
Class_Descriptor cd_S10180C34 = {  "S10180C34", // class name
  bases_S10180C34, 1,
  &(vtc_S10180C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,64), // object size
  NSPAIRA(_ZTI9S10180C34),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C34),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C38  {
  __tsi64 s10180c38f0[4];
};
//SIG(-1 S10180C38) C1{ FL[4]}



static void Test_S10180C38()
{
  {
    init_simple_test("S10180C38");
    S10180C38 lv;
    check2(sizeof(lv), 32, "sizeof(S10180C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C38)");
    check_field_offset(lv, s10180c38f0, 0, "S10180C38.s10180c38f0");
  }
}
static Arrange_To_Call_Me vS10180C38(Test_S10180C38, "S10180C38", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C37  {
  ::S10180C38 s10180c37f0;
  void  mf10180c37(); // _ZN9S10180C3710mf10180c37Ev
};
//SIG(-1 S10180C37) C1{ m FC2{ FL[4]}}


void  S10180C37 ::mf10180c37(){}

static void Test_S10180C37()
{
  {
    init_simple_test("S10180C37");
    S10180C37 lv;
    check2(sizeof(lv), 32, "sizeof(S10180C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C37)");
    check_field_offset(lv, s10180c37f0, 0, "S10180C37.s10180c37f0");
  }
}
static Arrange_To_Call_Me vS10180C37(Test_S10180C37, "S10180C37", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C36  {
  char s10180c36f0[2];
  void *s10180c36f1[3];
  int s10180c36f2[4];
  ::S10180C37 s10180c36f3;
  void  mf10180c36(); // _ZN9S10180C3610mf10180c36Ev
};
//SIG(-1 S10180C36) C1{ m Fc[2] Fp[3] Fi[4] FC2{ m FC3{ FL[4]}}}


void  S10180C36 ::mf10180c36(){}

static void Test_S10180C36()
{
  {
    init_simple_test("S10180C36");
    S10180C36 lv;
    check2(sizeof(lv), ABISELECT(80,64), "sizeof(S10180C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C36)");
    check_field_offset(lv, s10180c36f0, 0, "S10180C36.s10180c36f0");
    check_field_offset(lv, s10180c36f1, ABISELECT(8,4), "S10180C36.s10180c36f1");
    check_field_offset(lv, s10180c36f2, ABISELECT(32,16), "S10180C36.s10180c36f2");
    check_field_offset(lv, s10180c36f3, ABISELECT(48,32), "S10180C36.s10180c36f3");
  }
}
static Arrange_To_Call_Me vS10180C36(Test_S10180C36, "S10180C36", ABISELECT(80,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C35  {
  int s10180c35f0;
  void *s10180c35f1[3];
  ::S10180C36 s10180c35f2;
  void  mf10180c35(); // _ZN9S10180C3510mf10180c35Ev
  virtual  ~S10180C35(); // _ZN9S10180C35D1Ev
  S10180C35(); // tgen
};
//SIG(-1 S10180C35) C1{ vd m Fi Fp[3] FC2{ m Fc[2] Fp[3] Fi[4] FC3{ m FC4{ FL[4]}}}}


void  S10180C35 ::mf10180c35(){}
 S10180C35 ::~S10180C35(){ note_dtor("S10180C35", this);}
S10180C35 ::S10180C35(){ note_ctor("S10180C35", this);} // tgen

static void Test_S10180C35()
{
  extern Class_Descriptor cd_S10180C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,22)];
    init_test(&cd_S10180C35, buf);
    S10180C35 *dp, &lv = *(dp=new (buf) S10180C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,84), "sizeof(S10180C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C35)");
    check_field_offset(lv, s10180c35f0, ABISELECT(8,4), "S10180C35.s10180c35f0");
    check_field_offset(lv, s10180c35f1, ABISELECT(16,8), "S10180C35.s10180c35f1");
    check_field_offset(lv, s10180c35f2, ABISELECT(40,20), "S10180C35.s10180c35f2");
    test_class_info(&lv, &cd_S10180C35);
    dp->~S10180C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C35(Test_S10180C35, "S10180C35", ABISELECT(120,84));

#else // __cplusplus

extern void _ZN9S10180C35C1Ev();
extern void _ZN9S10180C35D1Ev();
Name_Map name_map_S10180C35[] = {
  NSPAIR(_ZN9S10180C35C1Ev),
  NSPAIR(_ZN9S10180C35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C35[];
extern void _ZN9S10180C35D1Ev();
extern void _ZN9S10180C35D0Ev();
static  VTBL_ENTRY vtc_S10180C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C35[0]),
  (VTBL_ENTRY)&_ZN9S10180C35D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C35D0Ev,
};
extern VTBL_ENTRY _ZTI9S10180C35[];
extern  VTBL_ENTRY _ZTV9S10180C35[];
Class_Descriptor cd_S10180C35 = {  "S10180C35", // class name
  0,0,//no base classes
  &(vtc_S10180C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,84), // object size
  NSPAIRA(_ZTI9S10180C35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C35),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C41  {
  __tsi64 s10180c41f0[3];
  int s10180c41f1[3];
  __tsi64 s10180c41f2;
  void  mf10180c41(); // _ZN9S10180C4110mf10180c41Ev
};
//SIG(-1 S10180C41) C1{ m FL[3] Fi[3] FL}


void  S10180C41 ::mf10180c41(){}

static void Test_S10180C41()
{
  {
    init_simple_test("S10180C41");
    S10180C41 lv;
    check2(sizeof(lv), ABISELECT(48,44), "sizeof(S10180C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C41)");
    check_field_offset(lv, s10180c41f0, 0, "S10180C41.s10180c41f0");
    check_field_offset(lv, s10180c41f1, 24, "S10180C41.s10180c41f1");
    check_field_offset(lv, s10180c41f2, ABISELECT(40,36), "S10180C41.s10180c41f2");
  }
}
static Arrange_To_Call_Me vS10180C41(Test_S10180C41, "S10180C41", ABISELECT(48,44));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C43  {
  int s10180c43f0[4];
  void  mf10180c43(); // _ZN9S10180C4310mf10180c43Ev
};
//SIG(-1 S10180C43) C1{ m Fi[4]}


void  S10180C43 ::mf10180c43(){}

static void Test_S10180C43()
{
  {
    init_simple_test("S10180C43");
    S10180C43 lv;
    check2(sizeof(lv), 16, "sizeof(S10180C43)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C43)");
    check_field_offset(lv, s10180c43f0, 0, "S10180C43.s10180c43f0");
  }
}
static Arrange_To_Call_Me vS10180C43(Test_S10180C43, "S10180C43", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C42  {
  int s10180c42f0;
  ::S10180C43 s10180c42f1;
  void  mf10180c42(); // _ZN9S10180C4210mf10180c42Ev
};
//SIG(-1 S10180C42) C1{ m Fi FC2{ m Fi[4]}}


void  S10180C42 ::mf10180c42(){}

static void Test_S10180C42()
{
  {
    init_simple_test("S10180C42");
    S10180C42 lv;
    check2(sizeof(lv), 20, "sizeof(S10180C42)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C42)");
    check_field_offset(lv, s10180c42f0, 0, "S10180C42.s10180c42f0");
    check_field_offset(lv, s10180c42f1, 4, "S10180C42.s10180c42f1");
  }
}
static Arrange_To_Call_Me vS10180C42(Test_S10180C42, "S10180C42", 20);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C39  {
  ::S10180C37 s10180c39f0;
  int s10180c39f1[2];
  ::S10180C41 s10180c39f2;
  __tsi64 s10180c39f3;
  ::S10180C42 s10180c39f4;
  ::S10180C31 s10180c39f5;
  char s10180c39f6[2];
  int s10180c39f7[2];
  void *s10180c39f8[2];
  __tsi64 s10180c39f9;
  int s10180c39f10[3];
  void  mf10180c39(); // _ZN9S10180C3910mf10180c39Ev
  virtual  ~S10180C39(); // _ZN9S10180C39D1Ev
  S10180C39(); // tgen
};
//SIG(-1 S10180C39) C1{ vd m FC2{ m FC3{ FL[4]}} Fi[2] FC4{ m FL[3] Fi[3] FL} FL FC5{ m Fi FC6{ m Fi[4]}} FC7{ m FC8{ m Fp Fi[2] FC9{ m}} Fp[2]} Fc[2] Fi[2] Fp[2] FL Fi[3]}


void  S10180C39 ::mf10180c39(){}
 S10180C39 ::~S10180C39(){ note_dtor("S10180C39", this);}
S10180C39 ::S10180C39(){ note_ctor("S10180C39", this);} // tgen

static void Test_S10180C39()
{
  extern Class_Descriptor cd_S10180C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,46)];
    init_test(&cd_S10180C39, buf);
    S10180C39 *dp, &lv = *(dp=new (buf) S10180C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,180), "sizeof(S10180C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C39)");
    check_field_offset(lv, s10180c39f0, ABISELECT(8,4), "S10180C39.s10180c39f0");
    check_field_offset(lv, s10180c39f1, ABISELECT(40,36), "S10180C39.s10180c39f1");
    check_field_offset(lv, s10180c39f2, ABISELECT(48,44), "S10180C39.s10180c39f2");
    check_field_offset(lv, s10180c39f3, ABISELECT(96,88), "S10180C39.s10180c39f3");
    check_field_offset(lv, s10180c39f4, ABISELECT(104,96), "S10180C39.s10180c39f4");
    check_field_offset(lv, s10180c39f5, ABISELECT(128,116), "S10180C39.s10180c39f5");
    check_field_offset(lv, s10180c39f6, ABISELECT(168,140), "S10180C39.s10180c39f6");
    check_field_offset(lv, s10180c39f7, ABISELECT(172,144), "S10180C39.s10180c39f7");
    check_field_offset(lv, s10180c39f8, ABISELECT(184,152), "S10180C39.s10180c39f8");
    check_field_offset(lv, s10180c39f9, ABISELECT(200,160), "S10180C39.s10180c39f9");
    check_field_offset(lv, s10180c39f10, ABISELECT(208,168), "S10180C39.s10180c39f10");
    test_class_info(&lv, &cd_S10180C39);
    dp->~S10180C39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C39(Test_S10180C39, "S10180C39", ABISELECT(224,180));

#else // __cplusplus

extern void _ZN9S10180C39C1Ev();
extern void _ZN9S10180C39D1Ev();
Name_Map name_map_S10180C39[] = {
  NSPAIR(_ZN9S10180C39C1Ev),
  NSPAIR(_ZN9S10180C39D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C39[];
extern void _ZN9S10180C39D1Ev();
extern void _ZN9S10180C39D0Ev();
static  VTBL_ENTRY vtc_S10180C39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C39[0]),
  (VTBL_ENTRY)&_ZN9S10180C39D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C39D0Ev,
};
extern VTBL_ENTRY _ZTI9S10180C39[];
extern  VTBL_ENTRY _ZTV9S10180C39[];
Class_Descriptor cd_S10180C39 = {  "S10180C39", // class name
  0,0,//no base classes
  &(vtc_S10180C39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,180), // object size
  NSPAIRA(_ZTI9S10180C39),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C39),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C45  {
  char s10180c45f0[2];
  void  mf10180c45(); // _ZN9S10180C4510mf10180c45Ev
};
//SIG(-1 S10180C45) C1{ m Fc[2]}


void  S10180C45 ::mf10180c45(){}

static void Test_S10180C45()
{
  {
    init_simple_test("S10180C45");
    S10180C45 lv;
    check2(sizeof(lv), 2, "sizeof(S10180C45)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C45)");
    check_field_offset(lv, s10180c45f0, 0, "S10180C45.s10180c45f0");
  }
}
static Arrange_To_Call_Me vS10180C45(Test_S10180C45, "S10180C45", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C46  {
  void *s10180c46f0[2];
};
//SIG(-1 S10180C46) C1{ Fp[2]}



static void Test_S10180C46()
{
  {
    init_simple_test("S10180C46");
    S10180C46 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10180C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C46)");
    check_field_offset(lv, s10180c46f0, 0, "S10180C46.s10180c46f0");
  }
}
static Arrange_To_Call_Me vS10180C46(Test_S10180C46, "S10180C46", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C49  {
  int s10180c49f0[8];
  short s10180c49f1;
  int s10180c49f2[3];
  char s10180c49f3;
};
//SIG(-1 S10180C49) C1{ Fi[8] Fs Fi[3] Fc}



static void Test_S10180C49()
{
  {
    init_simple_test("S10180C49");
    S10180C49 lv;
    check2(sizeof(lv), 52, "sizeof(S10180C49)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C49)");
    check_field_offset(lv, s10180c49f0, 0, "S10180C49.s10180c49f0");
    check_field_offset(lv, s10180c49f1, 32, "S10180C49.s10180c49f1");
    check_field_offset(lv, s10180c49f2, 36, "S10180C49.s10180c49f2");
    check_field_offset(lv, s10180c49f3, 48, "S10180C49.s10180c49f3");
  }
}
static Arrange_To_Call_Me vS10180C49(Test_S10180C49, "S10180C49", 52);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C48  {
  ::S10180C49 s10180c48f0;
  void *s10180c48f1[4];
  int s10180c48f2;
  void *s10180c48f3;
  int s10180c48f4;
  void *s10180c48f5;
  void  mf10180c48(); // _ZN9S10180C4810mf10180c48Ev
  virtual  ~S10180C48(); // _ZN9S10180C48D1Ev
  S10180C48(); // tgen
};
//SIG(-1 S10180C48) C1{ vd m FC2{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp}


void  S10180C48 ::mf10180c48(){}
 S10180C48 ::~S10180C48(){ note_dtor("S10180C48", this);}
S10180C48 ::S10180C48(){ note_ctor("S10180C48", this);} // tgen

static void Test_S10180C48()
{
  extern Class_Descriptor cd_S10180C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,23)];
    init_test(&cd_S10180C48, buf);
    S10180C48 *dp, &lv = *(dp=new (buf) S10180C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,88), "sizeof(S10180C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C48)");
    check_field_offset(lv, s10180c48f0, ABISELECT(8,4), "S10180C48.s10180c48f0");
    check_field_offset(lv, s10180c48f1, ABISELECT(64,56), "S10180C48.s10180c48f1");
    check_field_offset(lv, s10180c48f2, ABISELECT(96,72), "S10180C48.s10180c48f2");
    check_field_offset(lv, s10180c48f3, ABISELECT(104,76), "S10180C48.s10180c48f3");
    check_field_offset(lv, s10180c48f4, ABISELECT(112,80), "S10180C48.s10180c48f4");
    check_field_offset(lv, s10180c48f5, ABISELECT(120,84), "S10180C48.s10180c48f5");
    test_class_info(&lv, &cd_S10180C48);
    dp->~S10180C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C48(Test_S10180C48, "S10180C48", ABISELECT(128,88));

#else // __cplusplus

extern void _ZN9S10180C48C1Ev();
extern void _ZN9S10180C48D1Ev();
Name_Map name_map_S10180C48[] = {
  NSPAIR(_ZN9S10180C48C1Ev),
  NSPAIR(_ZN9S10180C48D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C48[];
extern void _ZN9S10180C48D1Ev();
extern void _ZN9S10180C48D0Ev();
static  VTBL_ENTRY vtc_S10180C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C48[0]),
  (VTBL_ENTRY)&_ZN9S10180C48D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C48D0Ev,
};
extern VTBL_ENTRY _ZTI9S10180C48[];
extern  VTBL_ENTRY _ZTV9S10180C48[];
Class_Descriptor cd_S10180C48 = {  "S10180C48", // class name
  0,0,//no base classes
  &(vtc_S10180C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,88), // object size
  NSPAIRA(_ZTI9S10180C48),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C48),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C51  {
  int s10180c51f0;
  void *s10180c51f1;
  char s10180c51f2;
  virtual  ~S10180C51(); // _ZN9S10180C51D1Ev
  virtual void  v77(); // _ZN9S10180C513v77Ev
  virtual void  v78(); // _ZN9S10180C513v78Ev
  virtual void  v79(); // _ZN9S10180C513v79Ev
  virtual void  v80(); // _ZN9S10180C513v80Ev
  virtual void  v81(); // _ZN9S10180C513v81Ev
  virtual void  v82(); // _ZN9S10180C513v82Ev
  S10180C51(); // tgen
};
//SIG(-1 S10180C51) C1{ vd v1 v2 v3 v4 v5 v6 Fi Fp Fc}


 S10180C51 ::~S10180C51(){ note_dtor("S10180C51", this);}
void  S10180C51 ::v77(){vfunc_called(this, "_ZN9S10180C513v77Ev");}
void  S10180C51 ::v78(){vfunc_called(this, "_ZN9S10180C513v78Ev");}
void  S10180C51 ::v79(){vfunc_called(this, "_ZN9S10180C513v79Ev");}
void  S10180C51 ::v80(){vfunc_called(this, "_ZN9S10180C513v80Ev");}
void  S10180C51 ::v81(){vfunc_called(this, "_ZN9S10180C513v81Ev");}
void  S10180C51 ::v82(){vfunc_called(this, "_ZN9S10180C513v82Ev");}
S10180C51 ::S10180C51(){ note_ctor("S10180C51", this);} // tgen

static void Test_S10180C51()
{
  extern Class_Descriptor cd_S10180C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S10180C51, buf);
    S10180C51 *dp, &lv = *(dp=new (buf) S10180C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S10180C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C51)");
    check_field_offset(lv, s10180c51f0, ABISELECT(8,4), "S10180C51.s10180c51f0");
    check_field_offset(lv, s10180c51f1, ABISELECT(16,8), "S10180C51.s10180c51f1");
    check_field_offset(lv, s10180c51f2, ABISELECT(24,12), "S10180C51.s10180c51f2");
    test_class_info(&lv, &cd_S10180C51);
    dp->~S10180C51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C51(Test_S10180C51, "S10180C51", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN9S10180C51C1Ev();
extern void _ZN9S10180C51D1Ev();
Name_Map name_map_S10180C51[] = {
  NSPAIR(_ZN9S10180C51C1Ev),
  NSPAIR(_ZN9S10180C51D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C51[];
extern void _ZN9S10180C51D1Ev();
extern void _ZN9S10180C51D0Ev();
extern void _ZN9S10180C513v77Ev();
extern void _ZN9S10180C513v78Ev();
extern void _ZN9S10180C513v79Ev();
extern void _ZN9S10180C513v80Ev();
extern void _ZN9S10180C513v81Ev();
extern void _ZN9S10180C513v82Ev();
static  VTBL_ENTRY vtc_S10180C51[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C51[0]),
  (VTBL_ENTRY)&_ZN9S10180C51D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C51D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v77Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v78Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v79Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v80Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v81Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v82Ev,
};
extern VTBL_ENTRY _ZTI9S10180C51[];
extern  VTBL_ENTRY _ZTV9S10180C51[];
Class_Descriptor cd_S10180C51 = {  "S10180C51", // class name
  0,0,//no base classes
  &(vtc_S10180C51[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI9S10180C51),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C51),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C50  : S10180C51 {
  void *s10180c50f0;
  virtual  ~S10180C50(); // _ZN9S10180C50D1Ev
  virtual void  v71(); // _ZN9S10180C503v71Ev
  virtual void  v72(); // _ZN9S10180C503v72Ev
  virtual void  v73(); // _ZN9S10180C503v73Ev
  virtual void  v74(); // _ZN9S10180C503v74Ev
  virtual void  v75(); // _ZN9S10180C503v75Ev
  virtual void  v76(); // _ZN9S10180C503v76Ev
  S10180C50(); // tgen
};
//SIG(-1 S10180C50) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 Fi Fp Fc} vd v1 v2 v3 v4 v5 v6 Fp}


 S10180C50 ::~S10180C50(){ note_dtor("S10180C50", this);}
void  S10180C50 ::v71(){vfunc_called(this, "_ZN9S10180C503v71Ev");}
void  S10180C50 ::v72(){vfunc_called(this, "_ZN9S10180C503v72Ev");}
void  S10180C50 ::v73(){vfunc_called(this, "_ZN9S10180C503v73Ev");}
void  S10180C50 ::v74(){vfunc_called(this, "_ZN9S10180C503v74Ev");}
void  S10180C50 ::v75(){vfunc_called(this, "_ZN9S10180C503v75Ev");}
void  S10180C50 ::v76(){vfunc_called(this, "_ZN9S10180C503v76Ev");}
S10180C50 ::S10180C50(){ note_ctor("S10180C50", this);} // tgen

static void Test_S10180C50()
{
  extern Class_Descriptor cd_S10180C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S10180C50, buf);
    S10180C50 *dp, &lv = *(dp=new (buf) S10180C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S10180C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C50)");
    check_base_class_offset(lv, (S10180C51*), 0, "S10180C50");
    check_field_offset(lv, s10180c50f0, ABISELECT(32,16), "S10180C50.s10180c50f0");
    test_class_info(&lv, &cd_S10180C50);
    dp->~S10180C50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C50(Test_S10180C50, "S10180C50", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S10180C50C1Ev();
extern void _ZN9S10180C50D1Ev();
Name_Map name_map_S10180C50[] = {
  NSPAIR(_ZN9S10180C50C1Ev),
  NSPAIR(_ZN9S10180C50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C51;
extern VTBL_ENTRY _ZTI9S10180C51[];
extern  VTBL_ENTRY _ZTV9S10180C51[];
static Base_Class bases_S10180C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C51,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C50[];
extern void _ZN9S10180C50D1Ev();
extern void _ZN9S10180C50D0Ev();
extern void _ZN9S10180C513v77Ev();
extern void _ZN9S10180C513v78Ev();
extern void _ZN9S10180C513v79Ev();
extern void _ZN9S10180C513v80Ev();
extern void _ZN9S10180C513v81Ev();
extern void _ZN9S10180C513v82Ev();
extern void _ZN9S10180C503v71Ev();
extern void _ZN9S10180C503v72Ev();
extern void _ZN9S10180C503v73Ev();
extern void _ZN9S10180C503v74Ev();
extern void _ZN9S10180C503v75Ev();
extern void _ZN9S10180C503v76Ev();
static  VTBL_ENTRY vtc_S10180C50[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C50[0]),
  (VTBL_ENTRY)&_ZN9S10180C50D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C50D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v77Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v78Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v79Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v80Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v81Ev,
  (VTBL_ENTRY)&_ZN9S10180C513v82Ev,
  (VTBL_ENTRY)&_ZN9S10180C503v71Ev,
  (VTBL_ENTRY)&_ZN9S10180C503v72Ev,
  (VTBL_ENTRY)&_ZN9S10180C503v73Ev,
  (VTBL_ENTRY)&_ZN9S10180C503v74Ev,
  (VTBL_ENTRY)&_ZN9S10180C503v75Ev,
  (VTBL_ENTRY)&_ZN9S10180C503v76Ev,
};
extern VTBL_ENTRY _ZTI9S10180C50[];
extern  VTBL_ENTRY _ZTV9S10180C50[];
Class_Descriptor cd_S10180C50 = {  "S10180C50", // class name
  bases_S10180C50, 1,
  &(vtc_S10180C50[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S10180C50),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C50),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C53  {
  int s10180c53f0;
  char s10180c53f1[3];
  virtual  ~S10180C53(); // _ZN9S10180C53D1Ev
  virtual void  v84(); // _ZN9S10180C533v84Ev
  S10180C53(); // tgen
};
//SIG(-1 S10180C53) C1{ vd v1 Fi Fc[3]}


 S10180C53 ::~S10180C53(){ note_dtor("S10180C53", this);}
void  S10180C53 ::v84(){vfunc_called(this, "_ZN9S10180C533v84Ev");}
S10180C53 ::S10180C53(){ note_ctor("S10180C53", this);} // tgen

static void Test_S10180C53()
{
  extern Class_Descriptor cd_S10180C53;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S10180C53, buf);
    S10180C53 *dp, &lv = *(dp=new (buf) S10180C53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C53)");
    check_field_offset(lv, s10180c53f0, ABISELECT(8,4), "S10180C53.s10180c53f0");
    check_field_offset(lv, s10180c53f1, ABISELECT(12,8), "S10180C53.s10180c53f1");
    test_class_info(&lv, &cd_S10180C53);
    dp->~S10180C53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C53(Test_S10180C53, "S10180C53", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN9S10180C53C1Ev();
extern void _ZN9S10180C53D1Ev();
Name_Map name_map_S10180C53[] = {
  NSPAIR(_ZN9S10180C53C1Ev),
  NSPAIR(_ZN9S10180C53D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C53[];
extern void _ZN9S10180C53D1Ev();
extern void _ZN9S10180C53D0Ev();
extern void _ZN9S10180C533v84Ev();
static  VTBL_ENTRY vtc_S10180C53[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C53[0]),
  (VTBL_ENTRY)&_ZN9S10180C53D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C53D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C533v84Ev,
};
extern VTBL_ENTRY _ZTI9S10180C53[];
extern  VTBL_ENTRY _ZTV9S10180C53[];
Class_Descriptor cd_S10180C53 = {  "S10180C53", // class name
  0,0,//no base classes
  &(vtc_S10180C53[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI9S10180C53),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C53),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C55  {
  int s10180c55f0[4];
};
//SIG(-1 S10180C55) C1{ Fi[4]}



static void Test_S10180C55()
{
  {
    init_simple_test("S10180C55");
    S10180C55 lv;
    check2(sizeof(lv), 16, "sizeof(S10180C55)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C55)");
    check_field_offset(lv, s10180c55f0, 0, "S10180C55.s10180c55f0");
  }
}
static Arrange_To_Call_Me vS10180C55(Test_S10180C55, "S10180C55", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C54  {
  void *s10180c54f0;
  ::S10180C55 s10180c54f1;
  void  mf10180c54(); // _ZN9S10180C5410mf10180c54Ev
};
//SIG(-1 S10180C54) C1{ m Fp FC2{ Fi[4]}}


void  S10180C54 ::mf10180c54(){}

static void Test_S10180C54()
{
  {
    init_simple_test("S10180C54");
    S10180C54 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S10180C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C54)");
    check_field_offset(lv, s10180c54f0, 0, "S10180C54.s10180c54f0");
    check_field_offset(lv, s10180c54f1, ABISELECT(8,4), "S10180C54.s10180c54f1");
  }
}
static Arrange_To_Call_Me vS10180C54(Test_S10180C54, "S10180C54", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C57  {
  ::S10180C37 s10180c57f0;
  ::S10180C54 s10180c57f1;
  void *s10180c57f2;
  int s10180c57f3[5];
  void  mf10180c57(); // _ZN9S10180C5710mf10180c57Ev
};
//SIG(-1 S10180C57) C1{ m FC2{ m FC3{ FL[4]}} FC4{ m Fp FC5{ Fi[4]}} Fp Fi[5]}


void  S10180C57 ::mf10180c57(){}

static void Test_S10180C57()
{
  {
    init_simple_test("S10180C57");
    S10180C57 lv;
    check2(sizeof(lv), ABISELECT(88,76), "sizeof(S10180C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C57)");
    check_field_offset(lv, s10180c57f0, 0, "S10180C57.s10180c57f0");
    check_field_offset(lv, s10180c57f1, 32, "S10180C57.s10180c57f1");
    check_field_offset(lv, s10180c57f2, ABISELECT(56,52), "S10180C57.s10180c57f2");
    check_field_offset(lv, s10180c57f3, ABISELECT(64,56), "S10180C57.s10180c57f3");
  }
}
static Arrange_To_Call_Me vS10180C57(Test_S10180C57, "S10180C57", ABISELECT(88,76));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C56  : S10180C53 {
  ::S10180C37 s10180c56f0;
  int s10180c56f1;
  void *s10180c56f2[2];
  ::S10180C57 s10180c56f3;
  short s10180c56f4[3585];
  char s10180c56f5[4096];
  int s10180c56f6;
  virtual  ~S10180C56(); // _ZN9S10180C56D1Ev
  virtual void  v85(); // _ZN9S10180C563v85Ev
  S10180C56(); // tgen
};
//SIG(-1 S10180C56) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 FC3{ m FC4{ FL[4]}} Fi Fp[2] FC5{ m FC3 FC6{ m Fp FC7{ Fi[4]}} Fp Fi[5]} Fs[3585] Fc[4096] Fi}


 S10180C56 ::~S10180C56(){ note_dtor("S10180C56", this);}
void  S10180C56 ::v85(){vfunc_called(this, "_ZN9S10180C563v85Ev");}
S10180C56 ::S10180C56(){ note_ctor("S10180C56", this);} // tgen

static void Test_S10180C56()
{
  extern Class_Descriptor cd_S10180C56;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1430,2852)];
    init_test(&cd_S10180C56, buf);
    S10180C56 *dp, &lv = *(dp=new (buf) S10180C56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(11432,11404), "sizeof(S10180C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C56)");
    check_base_class_offset(lv, (S10180C53*), 0, "S10180C56");
    check_field_offset(lv, s10180c56f0, ABISELECT(16,12), "S10180C56.s10180c56f0");
    check_field_offset(lv, s10180c56f1, ABISELECT(48,44), "S10180C56.s10180c56f1");
    check_field_offset(lv, s10180c56f2, ABISELECT(56,48), "S10180C56.s10180c56f2");
    check_field_offset(lv, s10180c56f3, ABISELECT(72,56), "S10180C56.s10180c56f3");
    check_field_offset(lv, s10180c56f4, ABISELECT(160,132), "S10180C56.s10180c56f4");
    check_field_offset(lv, s10180c56f5, ABISELECT(7330,7302), "S10180C56.s10180c56f5");
    check_field_offset(lv, s10180c56f6, ABISELECT(11428,11400), "S10180C56.s10180c56f6");
    test_class_info(&lv, &cd_S10180C56);
    dp->~S10180C56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C56(Test_S10180C56, "S10180C56", ABISELECT(11432,11404));

#else // __cplusplus

extern void _ZN9S10180C56C1Ev();
extern void _ZN9S10180C56D1Ev();
Name_Map name_map_S10180C56[] = {
  NSPAIR(_ZN9S10180C56C1Ev),
  NSPAIR(_ZN9S10180C56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C53;
extern VTBL_ENTRY _ZTI9S10180C53[];
extern  VTBL_ENTRY _ZTV9S10180C53[];
static Base_Class bases_S10180C56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C56[];
extern void _ZN9S10180C56D1Ev();
extern void _ZN9S10180C56D0Ev();
extern void _ZN9S10180C533v84Ev();
extern void _ZN9S10180C563v85Ev();
static  VTBL_ENTRY vtc_S10180C56[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C56[0]),
  (VTBL_ENTRY)&_ZN9S10180C56D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C56D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C533v84Ev,
  (VTBL_ENTRY)&_ZN9S10180C563v85Ev,
};
extern VTBL_ENTRY _ZTI9S10180C56[];
extern  VTBL_ENTRY _ZTV9S10180C56[];
Class_Descriptor cd_S10180C56 = {  "S10180C56", // class name
  bases_S10180C56, 1,
  &(vtc_S10180C56[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(11432,11404), // object size
  NSPAIRA(_ZTI9S10180C56),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C56),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C52  : S10180C53 {
  void *s10180c52f0[4];
  __tsi64 s10180c52f1;
  int s10180c52f2;
  ::S10180C37 s10180c52f3;
  ::S10180C54 s10180c52f4;
  short s10180c52f5[1024];
  int s10180c52f6[4];
  __tsi64 s10180c52f7[2];
  int s10180c52f8;
  ::S10180C56 s10180c52f9;
  virtual  ~S10180C52(); // _ZN9S10180C52D1Ev
  virtual void  v83(); // _ZN9S10180C523v83Ev
  S10180C52(); // tgen
};
//SIG(-1 S10180C52) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 Fp[4] FL Fi FC3{ m FC4{ FL[4]}} FC5{ m Fp FC6{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC7{ BC2 vd v3 FC3 Fi Fp[2] FC8{ m FC3 FC5 Fp Fi[5]} Fs[3585] Fc[4096] Fi}}


 S10180C52 ::~S10180C52(){ note_dtor("S10180C52", this);}
void  S10180C52 ::v83(){vfunc_called(this, "_ZN9S10180C523v83Ev");}
S10180C52 ::S10180C52(){ note_ctor("S10180C52", this);} // tgen

static void Test_S10180C52()
{
  extern Class_Descriptor cd_S10180C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1706,3396)];
    init_test(&cd_S10180C52, buf);
    S10180C52 *dp, &lv = *(dp=new (buf) S10180C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13640,13580), "sizeof(S10180C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C52)");
    check_base_class_offset(lv, (S10180C53*), 0, "S10180C52");
    check_field_offset(lv, s10180c52f0, ABISELECT(16,12), "S10180C52.s10180c52f0");
    check_field_offset(lv, s10180c52f1, ABISELECT(48,28), "S10180C52.s10180c52f1");
    check_field_offset(lv, s10180c52f2, ABISELECT(56,36), "S10180C52.s10180c52f2");
    check_field_offset(lv, s10180c52f3, ABISELECT(64,40), "S10180C52.s10180c52f3");
    check_field_offset(lv, s10180c52f4, ABISELECT(96,72), "S10180C52.s10180c52f4");
    check_field_offset(lv, s10180c52f5, ABISELECT(120,92), "S10180C52.s10180c52f5");
    check_field_offset(lv, s10180c52f6, ABISELECT(2168,2140), "S10180C52.s10180c52f6");
    check_field_offset(lv, s10180c52f7, ABISELECT(2184,2156), "S10180C52.s10180c52f7");
    check_field_offset(lv, s10180c52f8, ABISELECT(2200,2172), "S10180C52.s10180c52f8");
    check_field_offset(lv, s10180c52f9, ABISELECT(2208,2176), "S10180C52.s10180c52f9");
    test_class_info(&lv, &cd_S10180C52);
    dp->~S10180C52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C52(Test_S10180C52, "S10180C52", ABISELECT(13640,13580));

#else // __cplusplus

extern void _ZN9S10180C52C1Ev();
extern void _ZN9S10180C52D1Ev();
Name_Map name_map_S10180C52[] = {
  NSPAIR(_ZN9S10180C52C1Ev),
  NSPAIR(_ZN9S10180C52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C53;
extern VTBL_ENTRY _ZTI9S10180C53[];
extern  VTBL_ENTRY _ZTV9S10180C53[];
static Base_Class bases_S10180C52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C52[];
extern void _ZN9S10180C52D1Ev();
extern void _ZN9S10180C52D0Ev();
extern void _ZN9S10180C533v84Ev();
extern void _ZN9S10180C523v83Ev();
static  VTBL_ENTRY vtc_S10180C52[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C52[0]),
  (VTBL_ENTRY)&_ZN9S10180C52D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C52D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C533v84Ev,
  (VTBL_ENTRY)&_ZN9S10180C523v83Ev,
};
extern VTBL_ENTRY _ZTI9S10180C52[];
extern  VTBL_ENTRY _ZTV9S10180C52[];
Class_Descriptor cd_S10180C52 = {  "S10180C52", // class name
  bases_S10180C52, 1,
  &(vtc_S10180C52[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(13640,13580), // object size
  NSPAIRA(_ZTI9S10180C52),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C52),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C59  {
  int s10180c59f0[2];
  void  mf10180c59(); // _ZN9S10180C5910mf10180c59Ev
};
//SIG(-1 S10180C59) C1{ m Fi[2]}


void  S10180C59 ::mf10180c59(){}

static void Test_S10180C59()
{
  {
    init_simple_test("S10180C59");
    S10180C59 lv;
    check2(sizeof(lv), 8, "sizeof(S10180C59)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C59)");
    check_field_offset(lv, s10180c59f0, 0, "S10180C59.s10180c59f0");
  }
}
static Arrange_To_Call_Me vS10180C59(Test_S10180C59, "S10180C59", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C60  {
  ::S10180C37 s10180c60f0;
  ::S10180C54 s10180c60f1;
  void *s10180c60f2;
  int s10180c60f3[4];
  void  mf10180c60(); // _ZN9S10180C6010mf10180c60Ev
};
//SIG(-1 S10180C60) C1{ m FC2{ m FC3{ FL[4]}} FC4{ m Fp FC5{ Fi[4]}} Fp Fi[4]}


void  S10180C60 ::mf10180c60(){}

static void Test_S10180C60()
{
  {
    init_simple_test("S10180C60");
    S10180C60 lv;
    check2(sizeof(lv), ABISELECT(80,72), "sizeof(S10180C60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C60)");
    check_field_offset(lv, s10180c60f0, 0, "S10180C60.s10180c60f0");
    check_field_offset(lv, s10180c60f1, 32, "S10180C60.s10180c60f1");
    check_field_offset(lv, s10180c60f2, ABISELECT(56,52), "S10180C60.s10180c60f2");
    check_field_offset(lv, s10180c60f3, ABISELECT(64,56), "S10180C60.s10180c60f3");
  }
}
static Arrange_To_Call_Me vS10180C60(Test_S10180C60, "S10180C60", ABISELECT(80,72));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C61  {
  void *s10180c61f0;
  void  mf10180c61(); // _ZN9S10180C6110mf10180c61Ev
};
//SIG(-1 S10180C61) C1{ m Fp}


void  S10180C61 ::mf10180c61(){}

static void Test_S10180C61()
{
  {
    init_simple_test("S10180C61");
    S10180C61 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C61)");
    check_field_offset(lv, s10180c61f0, 0, "S10180C61.s10180c61f0");
  }
}
static Arrange_To_Call_Me vS10180C61(Test_S10180C61, "S10180C61", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C58  : S10180C53 {
  void *s10180c58f0[2];
  __tsi64 s10180c58f1;
  int s10180c58f2[4];
  ::S10180C59 s10180c58f3;
  ::S10180C37 s10180c58f4;
  ::S10180C60 s10180c58f5;
  ::S10180C61 s10180c58f6;
  virtual  ~S10180C58(); // _ZN9S10180C58D1Ev
  virtual void  v86(); // _ZN9S10180C583v86Ev
  S10180C58(); // tgen
};
//SIG(-1 S10180C58) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 Fp[2] FL Fi[4] FC3{ m Fi[2]} FC4{ m FC5{ FL[4]}} FC6{ m FC4 FC7{ m Fp FC8{ Fi[4]}} Fp Fi[4]} FC9{ m Fp}}


 S10180C58 ::~S10180C58(){ note_dtor("S10180C58", this);}
void  S10180C58 ::v86(){vfunc_called(this, "_ZN9S10180C583v86Ev");}
S10180C58 ::S10180C58(){ note_ctor("S10180C58", this);} // tgen

static void Test_S10180C58()
{
  extern Class_Descriptor cd_S10180C58;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,41)];
    init_test(&cd_S10180C58, buf);
    S10180C58 *dp, &lv = *(dp=new (buf) S10180C58());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,160), "sizeof(S10180C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C58)");
    check_base_class_offset(lv, (S10180C53*), 0, "S10180C58");
    check_field_offset(lv, s10180c58f0, ABISELECT(16,12), "S10180C58.s10180c58f0");
    check_field_offset(lv, s10180c58f1, ABISELECT(32,20), "S10180C58.s10180c58f1");
    check_field_offset(lv, s10180c58f2, ABISELECT(40,28), "S10180C58.s10180c58f2");
    check_field_offset(lv, s10180c58f3, ABISELECT(56,44), "S10180C58.s10180c58f3");
    check_field_offset(lv, s10180c58f4, ABISELECT(64,52), "S10180C58.s10180c58f4");
    check_field_offset(lv, s10180c58f5, ABISELECT(96,84), "S10180C58.s10180c58f5");
    check_field_offset(lv, s10180c58f6, ABISELECT(176,156), "S10180C58.s10180c58f6");
    test_class_info(&lv, &cd_S10180C58);
    dp->~S10180C58();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C58(Test_S10180C58, "S10180C58", ABISELECT(184,160));

#else // __cplusplus

extern void _ZN9S10180C58C1Ev();
extern void _ZN9S10180C58D1Ev();
Name_Map name_map_S10180C58[] = {
  NSPAIR(_ZN9S10180C58C1Ev),
  NSPAIR(_ZN9S10180C58D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C53;
extern VTBL_ENTRY _ZTI9S10180C53[];
extern  VTBL_ENTRY _ZTV9S10180C53[];
static Base_Class bases_S10180C58[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C58[];
extern void _ZN9S10180C58D1Ev();
extern void _ZN9S10180C58D0Ev();
extern void _ZN9S10180C533v84Ev();
extern void _ZN9S10180C583v86Ev();
static  VTBL_ENTRY vtc_S10180C58[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C58[0]),
  (VTBL_ENTRY)&_ZN9S10180C58D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C58D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C533v84Ev,
  (VTBL_ENTRY)&_ZN9S10180C583v86Ev,
};
extern VTBL_ENTRY _ZTI9S10180C58[];
extern  VTBL_ENTRY _ZTV9S10180C58[];
Class_Descriptor cd_S10180C58 = {  "S10180C58", // class name
  bases_S10180C58, 1,
  &(vtc_S10180C58[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,160), // object size
  NSPAIRA(_ZTI9S10180C58),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C58),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C47  {
  ::S10180C48 s10180c47f0;
  ::S10180C50 s10180c47f1;
  ::S10180C52 s10180c47f2;
  ::S10180C58 s10180c47f3;
  ::S10180C37 s10180c47f4;
  ::S10180C37 s10180c47f5;
  __tsi64 s10180c47f6;
  int s10180c47f7[5];
  void  mf10180c47(); // _ZN9S10180C4710mf10180c47Ev
  virtual  ~S10180C47(); // _ZN9S10180C47D1Ev
  S10180C47(); // tgen
};
//SIG(-1 S10180C47) C1{ vd m FC2{ vd m FC3{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC4{ BC5{ vd v7 v8 v9 v10 v11 v12 Fi Fp Fc} vd v1 v2 v3 v4 v5 v6 Fp} FC6{ BC7{ vd v14 Fi Fc[3]} vd v13 Fp[4] FL Fi FC8{ m FC9{ FL[4]}} FC10{ m Fp FC11{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC12{ BC7 vd v15 FC8 Fi Fp[2] FC13{ m FC8 FC10 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC14{ BC7 vd v16 Fp[2] FL Fi[4] FC15{ m Fi[2]} FC8 FC16{ m FC8 FC10 Fp Fi[4]} FC17{ m Fp}} FC8 FC8 FL Fi[5]}


void  S10180C47 ::mf10180c47(){}
 S10180C47 ::~S10180C47(){ note_dtor("S10180C47", this);}
S10180C47 ::S10180C47(){ note_ctor("S10180C47", this);} // tgen

static void Test_S10180C47()
{
  extern Class_Descriptor cd_S10180C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1763,3487)];
    init_test(&cd_S10180C47, buf);
    S10180C47 *dp, &lv = *(dp=new (buf) S10180C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14096,13944), "sizeof(S10180C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C47)");
    check_field_offset(lv, s10180c47f0, ABISELECT(8,4), "S10180C47.s10180c47f0");
    check_field_offset(lv, s10180c47f1, ABISELECT(136,92), "S10180C47.s10180c47f1");
    check_field_offset(lv, s10180c47f2, ABISELECT(176,112), "S10180C47.s10180c47f2");
    check_field_offset(lv, s10180c47f3, ABISELECT(13816,13692), "S10180C47.s10180c47f3");
    check_field_offset(lv, s10180c47f4, ABISELECT(14000,13852), "S10180C47.s10180c47f4");
    check_field_offset(lv, s10180c47f5, ABISELECT(14032,13884), "S10180C47.s10180c47f5");
    check_field_offset(lv, s10180c47f6, ABISELECT(14064,13916), "S10180C47.s10180c47f6");
    check_field_offset(lv, s10180c47f7, ABISELECT(14072,13924), "S10180C47.s10180c47f7");
    test_class_info(&lv, &cd_S10180C47);
    dp->~S10180C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C47(Test_S10180C47, "S10180C47", ABISELECT(14096,13944));

#else // __cplusplus

extern void _ZN9S10180C47C1Ev();
extern void _ZN9S10180C47D1Ev();
Name_Map name_map_S10180C47[] = {
  NSPAIR(_ZN9S10180C47C1Ev),
  NSPAIR(_ZN9S10180C47D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C47[];
extern void _ZN9S10180C47D1Ev();
extern void _ZN9S10180C47D0Ev();
static  VTBL_ENTRY vtc_S10180C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C47[0]),
  (VTBL_ENTRY)&_ZN9S10180C47D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C47D0Ev,
};
extern VTBL_ENTRY _ZTI9S10180C47[];
extern  VTBL_ENTRY _ZTV9S10180C47[];
Class_Descriptor cd_S10180C47 = {  "S10180C47", // class name
  0,0,//no base classes
  &(vtc_S10180C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(14096,13944), // object size
  NSPAIRA(_ZTI9S10180C47),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C47),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C63  {
  int s10180c63f0;
  void  mf10180c63(); // _ZN9S10180C6310mf10180c63Ev
};
//SIG(-1 S10180C63) C1{ m Fi}


void  S10180C63 ::mf10180c63(){}

static void Test_S10180C63()
{
  {
    init_simple_test("S10180C63");
    S10180C63 lv;
    check2(sizeof(lv), 4, "sizeof(S10180C63)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C63)");
    check_field_offset(lv, s10180c63f0, 0, "S10180C63.s10180c63f0");
  }
}
static Arrange_To_Call_Me vS10180C63(Test_S10180C63, "S10180C63", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S10180C63[];
VTBL_ENTRY *P__ZTI9S10180C63 = _ZTI9S10180C63; 
Class_Descriptor cd_S10180C63 = {  "S10180C63", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI9S10180C63),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C62  {
  ::S10180C41 s10180c62f0;
  ::S10180C63 s10180c62f1;
  int s10180c62f2;
  void  mf10180c62(); // _ZN9S10180C6210mf10180c62Ev
};
//SIG(-1 S10180C62) C1{ m FC2{ m FL[3] Fi[3] FL} FC3{ m Fi} Fi}


void  S10180C62 ::mf10180c62(){}

static void Test_S10180C62()
{
  {
    init_simple_test("S10180C62");
    S10180C62 lv;
    check2(sizeof(lv), ABISELECT(56,52), "sizeof(S10180C62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C62)");
    check_field_offset(lv, s10180c62f0, 0, "S10180C62.s10180c62f0");
    check_field_offset(lv, s10180c62f1, ABISELECT(48,44), "S10180C62.s10180c62f1");
    check_field_offset(lv, s10180c62f2, ABISELECT(52,48), "S10180C62.s10180c62f2");
  }
}
static Arrange_To_Call_Me vS10180C62(Test_S10180C62, "S10180C62", ABISELECT(56,52));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C44  : S10180C17 , S10180C24 {
  int s10180c44f0;
  ::S10180C45 s10180c44f1;
  ::S10180C46 s10180c44f2;
  void *s10180c44f3;
  ::S10180C47 s10180c44f4;
  __tsi64 s10180c44f5;
  ::S10180C62 s10180c44f6;
  char s10180c44f7[128];
  ::S10180C28 s10180c44f8;
  ::S10180C31 s10180c44f9;
  virtual  ~S10180C44(); // _ZN9S10180C44D1Ev
  virtual void  v70(); // _ZN9S10180C443v70Ev
  S10180C44(); // tgen
};
//SIG(-1 S10180C44) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v2} vd v1 Fi FC7{ m Fc[2]} FC8{ Fp[2]} Fp FC9{ vd m FC10{ vd m FC11{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC12{ BC13{ vd v9 v10 v11 v12 v13 v14 Fi Fp Fc} vd v3 v4 v5 v6 v7 v8 Fp} FC14{ BC15{ vd v16 Fi Fc[3]} vd v15 Fp[4] FL Fi FC16{ m FC17{ FL[4]}} FC18{ m Fp FC19{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC20{ BC15 vd v17 FC16 Fi Fp[2] FC21{ m FC16 FC18 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC22{ BC15 vd v18 Fp[2] FL Fi[4] FC23{ m Fi[2]} FC16 FC24{ m FC16 FC18 Fp Fi[4]} FC25{ m Fp}} FC16 FC16 FL Fi[5]} FL FC26{ m FC27{ m FL[3] Fi[3] FL} FC28{ m Fi} Fi} Fc[128] FC29{ m Fi[2]} FC30{ m FC31{ m Fp Fi[2] FC5} Fp[2]}}


 S10180C44 ::~S10180C44(){ note_dtor("S10180C44", this);}
void  S10180C44 ::v70(){vfunc_called(this, "_ZN9S10180C443v70Ev");}
S10180C44 ::S10180C44(){ note_ctor("S10180C44", this);} // tgen

static void Test_S10180C44()
{
  extern Class_Descriptor cd_S10180C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1804,3556)];
    init_test(&cd_S10180C44, buf);
    S10180C44 *dp, &lv = *(dp=new (buf) S10180C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14424,14220), "sizeof(S10180C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C44)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C44");
    check_base_class_offset(lv, (S10180C24*), ABISELECT(48,32), "S10180C44");
    check_field_offset(lv, s10180c44f0, ABISELECT(56,36), "S10180C44.s10180c44f0");
    check_field_offset(lv, s10180c44f1, ABISELECT(60,40), "S10180C44.s10180c44f1");
    check_field_offset(lv, s10180c44f2, ABISELECT(64,44), "S10180C44.s10180c44f2");
    check_field_offset(lv, s10180c44f3, ABISELECT(80,52), "S10180C44.s10180c44f3");
    check_field_offset(lv, s10180c44f4, ABISELECT(88,56), "S10180C44.s10180c44f4");
    check_field_offset(lv, s10180c44f5, ABISELECT(14184,14000), "S10180C44.s10180c44f5");
    check_field_offset(lv, s10180c44f6, ABISELECT(14192,14008), "S10180C44.s10180c44f6");
    check_field_offset(lv, s10180c44f7, ABISELECT(14248,14060), "S10180C44.s10180c44f7");
    check_field_offset(lv, s10180c44f8, ABISELECT(14376,14188), "S10180C44.s10180c44f8");
    check_field_offset(lv, s10180c44f9, ABISELECT(14384,14196), "S10180C44.s10180c44f9");
    test_class_info(&lv, &cd_S10180C44);
    dp->~S10180C44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C44(Test_S10180C44, "S10180C44", ABISELECT(14424,14220));

#else // __cplusplus

extern void _ZN9S10180C44C1Ev();
extern void _ZN9S10180C44D1Ev();
Name_Map name_map_S10180C44[] = {
  NSPAIR(_ZN9S10180C44C1Ev),
  NSPAIR(_ZN9S10180C44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C24;
extern VTBL_ENTRY _ZTI9S10180C24[];
extern  VTBL_ENTRY _ZTV9S10180C24[];
static Base_Class bases_S10180C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C24,    ABISELECT(48,32), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C44[];
extern void _ZN9S10180C44D1Ev();
extern void _ZN9S10180C44D0Ev();
extern void _ZN9S10180C443v70Ev();
extern void ABISELECT(_ZThn48_N9S10180C44D1Ev,_ZThn32_N9S10180C44D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C44D0Ev,_ZThn32_N9S10180C44D0Ev)();
extern void _ZN9S10180C243v41Ev();
static  VTBL_ENTRY vtc_S10180C44[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C44[0]),
  (VTBL_ENTRY)&_ZN9S10180C44D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C44D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C443v70Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C44[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C44D1Ev,_ZThn32_N9S10180C44D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C44D0Ev,_ZThn32_N9S10180C44D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10180C44[];
extern  VTBL_ENTRY _ZTV9S10180C44[];
Class_Descriptor cd_S10180C44 = {  "S10180C44", // class name
  bases_S10180C44, 2,
  &(vtc_S10180C44[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(14424,14220), // object size
  NSPAIRA(_ZTI9S10180C44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10180C44),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C64  {
  void *s10180c64f0;
  int s10180c64f1[2];
  void  mf10180c64(); // _ZN9S10180C6410mf10180c64Ev
};
//SIG(-1 S10180C64) C1{ m Fp Fi[2]}


void  S10180C64 ::mf10180c64(){}

static void Test_S10180C64()
{
  {
    init_simple_test("S10180C64");
    S10180C64 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C64)");
    check_field_offset(lv, s10180c64f0, 0, "S10180C64.s10180c64f0");
    check_field_offset(lv, s10180c64f1, ABISELECT(8,4), "S10180C64.s10180c64f1");
  }
}
static Arrange_To_Call_Me vS10180C64(Test_S10180C64, "S10180C64", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S10180C64 = {  "S10180C64", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C65  {
  char s10180c65f0[11];
  int s10180c65f1[2];
  void  mf10180c65(); // _ZN9S10180C6510mf10180c65Ev
};
//SIG(-1 S10180C65) C1{ m Fc[11] Fi[2]}


void  S10180C65 ::mf10180c65(){}

static void Test_S10180C65()
{
  {
    init_simple_test("S10180C65");
    S10180C65 lv;
    check2(sizeof(lv), 20, "sizeof(S10180C65)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C65)");
    check_field_offset(lv, s10180c65f0, 0, "S10180C65.s10180c65f0");
    check_field_offset(lv, s10180c65f1, 12, "S10180C65.s10180c65f1");
  }
}
static Arrange_To_Call_Me vS10180C65(Test_S10180C65, "S10180C65", 20);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C67  {
};
//SIG(-1 S10180C67) C1{}



static void Test_S10180C67()
{
  {
    init_simple_test("S10180C67");
    S10180C67 lv;
    check2(sizeof(lv), 1, "sizeof(S10180C67)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C67)");
  }
}
static Arrange_To_Call_Me vS10180C67(Test_S10180C67, "S10180C67", 1);

#else // __cplusplus

Class_Descriptor cd_S10180C67 = {  "S10180C67", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C66  : S10180C67 {
  __tsi64 s10180c66f0;
  int s10180c66f1;
};
//SIG(-1 S10180C66) C1{ BC2{} FL Fi}



static void Test_S10180C66()
{
  extern Class_Descriptor cd_S10180C66;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S10180C66, buf);
    S10180C66 &lv = *(new (buf) S10180C66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C66)");
    check_base_class_offset(lv, (S10180C67*), 0, "S10180C66");
    check_field_offset(lv, s10180c66f0, 0, "S10180C66.s10180c66f0");
    check_field_offset(lv, s10180c66f1, 8, "S10180C66.s10180c66f1");
    test_class_info(&lv, &cd_S10180C66);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C66(Test_S10180C66, "S10180C66", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S10180C67;
static Base_Class bases_S10180C66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C67,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10180C66 = {  "S10180C66", // class name
  bases_S10180C66, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C74  {
  __tsi64 s10180c74f0[2];
  void  mf10180c74(); // _ZN9S10180C7410mf10180c74Ev
};
//SIG(-1 S10180C74) C1{ m FL[2]}


void  S10180C74 ::mf10180c74(){}

static void Test_S10180C74()
{
  {
    init_simple_test("S10180C74");
    S10180C74 lv;
    check2(sizeof(lv), 16, "sizeof(S10180C74)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C74)");
    check_field_offset(lv, s10180c74f0, 0, "S10180C74.s10180c74f0");
  }
}
static Arrange_To_Call_Me vS10180C74(Test_S10180C74, "S10180C74", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C73  {
  ::S10180C74 s10180c73f0;
  void  mf10180c73(); // _ZN9S10180C7310mf10180c73Ev
};
//SIG(-1 S10180C73) C1{ m FC2{ m FL[2]}}


void  S10180C73 ::mf10180c73(){}

static void Test_S10180C73()
{
  {
    init_simple_test("S10180C73");
    S10180C73 lv;
    check2(sizeof(lv), 16, "sizeof(S10180C73)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C73)");
    check_field_offset(lv, s10180c73f0, 0, "S10180C73.s10180c73f0");
  }
}
static Arrange_To_Call_Me vS10180C73(Test_S10180C73, "S10180C73", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C70  {
  void *s10180c70f0;
  ::S10180C12 s10180c70f1;
  ::S10180C13 s10180c70f2;
  ::S10180C13 s10180c70f3;
  int s10180c70f4[3];
  ::S10180C73 s10180c70f5;
  char s10180c70f6;
  int s10180c70f7;
  int s10180c70f8:8;
  int s10180c70f9:24;
  ::S10180C12 s10180c70f10;
  ::S10180C12 s10180c70f11;
  char s10180c70f12;
  void  mf10180c70(); // _ZN9S10180C7010mf10180c70Ev
};
//SIG(-1 S10180C70) C1{ m Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC3 FC3 Fi[3] FC5{ m FC6{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC2 FC2 Fc}


void  S10180C70 ::mf10180c70(){}

static void Test_S10180C70()
{
  {
    init_simple_test("S10180C70");
    static S10180C70 lv;
    check2(sizeof(lv), ABISELECT(168,120), "sizeof(S10180C70)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C70)");
    check_field_offset(lv, s10180c70f0, 0, "S10180C70.s10180c70f0");
    check_field_offset(lv, s10180c70f1, ABISELECT(8,4), "S10180C70.s10180c70f1");
    check_field_offset(lv, s10180c70f2, ABISELECT(32,20), "S10180C70.s10180c70f2");
    check_field_offset(lv, s10180c70f3, ABISELECT(48,32), "S10180C70.s10180c70f3");
    check_field_offset(lv, s10180c70f4, ABISELECT(64,44), "S10180C70.s10180c70f4");
    check_field_offset(lv, s10180c70f5, ABISELECT(80,56), "S10180C70.s10180c70f5");
    check_field_offset(lv, s10180c70f6, ABISELECT(96,72), "S10180C70.s10180c70f6");
    check_field_offset(lv, s10180c70f7, ABISELECT(100,76), "S10180C70.s10180c70f7");
    set_bf_and_test(lv, s10180c70f8, ABISELECT(104,80), 0, 8, 1, "S10180C70");
    set_bf_and_test(lv, s10180c70f8, ABISELECT(104,80), 0, 8, hide_sll(1LL<<7), "S10180C70");
    set_bf_and_test(lv, s10180c70f9, ABISELECT(105,81), 0, 24, 1, "S10180C70");
    set_bf_and_test(lv, s10180c70f9, ABISELECT(105,81), 0, 24, hide_sll(1LL<<23), "S10180C70");
    check_field_offset(lv, s10180c70f10, ABISELECT(112,84), "S10180C70.s10180c70f10");
    check_field_offset(lv, s10180c70f11, ABISELECT(136,100), "S10180C70.s10180c70f11");
    check_field_offset(lv, s10180c70f12, ABISELECT(160,116), "S10180C70.s10180c70f12");
  }
}
static Arrange_To_Call_Me vS10180C70(Test_S10180C70, "S10180C70", ABISELECT(168,120));

#else // __cplusplus

Class_Descriptor cd_S10180C70 = {  "S10180C70", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(168,120), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C69  : S10180C17 {
  ::S10180C70 s10180c69f0;
  void *s10180c69f1;
  char s10180c69f2;
  int s10180c69f3;
  virtual  ~S10180C69(); // _ZN9S10180C69D1Ev
  virtual void  v89(); // _ZN9S10180C693v89Ev
  virtual void  v90(); // _ZN9S10180C693v90Ev
  virtual void  v91(); // _ZN9S10180C693v91Ev
  virtual void  v92(); // _ZN9S10180C693v92Ev
  S10180C69(); // tgen
};
//SIG(-1 S10180C69) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC8 FC8 Fi[3] FC9{ m FC10{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi}


 S10180C69 ::~S10180C69(){ note_dtor("S10180C69", this);}
void  S10180C69 ::v89(){vfunc_called(this, "_ZN9S10180C693v89Ev");}
void  S10180C69 ::v90(){vfunc_called(this, "_ZN9S10180C693v90Ev");}
void  S10180C69 ::v91(){vfunc_called(this, "_ZN9S10180C693v91Ev");}
void  S10180C69 ::v92(){vfunc_called(this, "_ZN9S10180C693v92Ev");}
S10180C69 ::S10180C69(){ note_ctor("S10180C69", this);} // tgen

static void Test_S10180C69()
{
  extern Class_Descriptor cd_S10180C69;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10180C69, buf);
    S10180C69 *dp, &lv = *(dp=new (buf) S10180C69());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10180C69)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C69)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C69");
    check_field_offset(lv, s10180c69f0, ABISELECT(48,32), "S10180C69.s10180c69f0");
    check_field_offset(lv, s10180c69f1, ABISELECT(216,152), "S10180C69.s10180c69f1");
    check_field_offset(lv, s10180c69f2, ABISELECT(224,156), "S10180C69.s10180c69f2");
    check_field_offset(lv, s10180c69f3, ABISELECT(228,160), "S10180C69.s10180c69f3");
    test_class_info(&lv, &cd_S10180C69);
    dp->~S10180C69();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C69(Test_S10180C69, "S10180C69", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10180C69C1Ev();
extern void _ZN9S10180C69D1Ev();
Name_Map name_map_S10180C69[] = {
  NSPAIR(_ZN9S10180C69C1Ev),
  NSPAIR(_ZN9S10180C69D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C69[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C69[];
extern void _ZN9S10180C69D1Ev();
extern void _ZN9S10180C69D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
static  VTBL_ENTRY vtc_S10180C69[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C69[0]),
  (VTBL_ENTRY)&_ZN9S10180C69D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C69D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
};
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
Class_Descriptor cd_S10180C69 = {  "S10180C69", // class name
  bases_S10180C69, 1,
  &(vtc_S10180C69[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10180C69),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C69),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C68  : S10180C69 {
  virtual void  v87(); // _ZN9S10180C683v87Ev
  virtual void  v88(); // _ZN9S10180C683v88Ev
  ~S10180C68(); // tgen
  S10180C68(); // tgen
};
//SIG(-1 S10180C68) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v3 v4 v5 v6 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1 v2}


void  S10180C68 ::v87(){vfunc_called(this, "_ZN9S10180C683v87Ev");}
void  S10180C68 ::v88(){vfunc_called(this, "_ZN9S10180C683v88Ev");}
S10180C68 ::~S10180C68(){ note_dtor("S10180C68", this);} // tgen
S10180C68 ::S10180C68(){ note_ctor("S10180C68", this);} // tgen

static void Test_S10180C68()
{
  extern Class_Descriptor cd_S10180C68;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10180C68, buf);
    S10180C68 *dp, &lv = *(dp=new (buf) S10180C68());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10180C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C68)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*), 0, "S10180C68");
    check_base_class_offset(lv, (S10180C69*), 0, "S10180C68");
    test_class_info(&lv, &cd_S10180C68);
    dp->~S10180C68();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C68(Test_S10180C68, "S10180C68", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10180C68C1Ev();
extern void _ZN9S10180C68D1Ev();
Name_Map name_map_S10180C68[] = {
  NSPAIR(_ZN9S10180C68C1Ev),
  NSPAIR(_ZN9S10180C68D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
static Base_Class bases_S10180C68[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C68[];
extern void _ZN9S10180C68D1Ev();
extern void _ZN9S10180C68D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN9S10180C683v87Ev();
extern void _ZN9S10180C683v88Ev();
static  VTBL_ENTRY vtc_S10180C68[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C68[0]),
  (VTBL_ENTRY)&_ZN9S10180C68D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C68D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN9S10180C683v87Ev,
  (VTBL_ENTRY)&_ZN9S10180C683v88Ev,
};
extern VTBL_ENTRY _ZTI9S10180C68[];
extern  VTBL_ENTRY _ZTV9S10180C68[];
Class_Descriptor cd_S10180C68 = {  "S10180C68", // class name
  bases_S10180C68, 2,
  &(vtc_S10180C68[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10180C68),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C68),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C75  : S10180C69 {
  virtual void  v93(); // _ZN9S10180C753v93Ev
  ~S10180C75(); // tgen
  S10180C75(); // tgen
};
//SIG(-1 S10180C75) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v2 v3 v4 v5 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1}


void  S10180C75 ::v93(){vfunc_called(this, "_ZN9S10180C753v93Ev");}
S10180C75 ::~S10180C75(){ note_dtor("S10180C75", this);} // tgen
S10180C75 ::S10180C75(){ note_ctor("S10180C75", this);} // tgen

static void Test_S10180C75()
{
  extern Class_Descriptor cd_S10180C75;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10180C75, buf);
    S10180C75 *dp, &lv = *(dp=new (buf) S10180C75());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10180C75)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C75)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*), 0, "S10180C75");
    check_base_class_offset(lv, (S10180C69*), 0, "S10180C75");
    test_class_info(&lv, &cd_S10180C75);
    dp->~S10180C75();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C75(Test_S10180C75, "S10180C75", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10180C75C1Ev();
extern void _ZN9S10180C75D1Ev();
Name_Map name_map_S10180C75[] = {
  NSPAIR(_ZN9S10180C75C1Ev),
  NSPAIR(_ZN9S10180C75D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
static Base_Class bases_S10180C75[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C75[];
extern void _ZN9S10180C75D1Ev();
extern void _ZN9S10180C75D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN9S10180C753v93Ev();
static  VTBL_ENTRY vtc_S10180C75[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C75[0]),
  (VTBL_ENTRY)&_ZN9S10180C75D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C75D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN9S10180C753v93Ev,
};
extern VTBL_ENTRY _ZTI9S10180C75[];
extern  VTBL_ENTRY _ZTV9S10180C75[];
Class_Descriptor cd_S10180C75 = {  "S10180C75", // class name
  bases_S10180C75, 2,
  &(vtc_S10180C75[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10180C75),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C75),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C25  : S10180C17 , S10180C2 , S10180C11 , S10180C26 , S10180C27 {
  int s10180c25f0;
  ::S10180C28 s10180c25f1;
  ::S10180C28 s10180c25f2;
  ::S10180C28 s10180c25f3;
  ::S10180C29 s10180c25f4;
  ::S10180C34 s10180c25f5;
  ::S10180C35 s10180c25f6;
  ::S10180C39 s10180c25f7;
  int s10180c25f8;
  void *s10180c25f9;
  ::S10180C44 s10180c25f10;
  int s10180c25f11[3];
  ::S10180C64 s10180c25f12;
  ::S10180C65 s10180c25f13;
  ::S10180C66 s10180c25f14;
  ::S10180C68 s10180c25f15;
  __tsi64 s10180c25f16;
  ::S10180C75 s10180c25f17;
  ::S10180C75 s10180c25f18;
  ::S10180C68 s10180c25f19;
  ::S10180C31 s10180c25f20;
  char s10180c25f21;
  virtual  ~S10180C25(); // _ZN9S10180C25D1Ev
  virtual void  v42(); // _ZN9S10180C253v42Ev
  virtual void  v43(); // _ZN9S10180C253v43Ev
  virtual void  v44(); // _ZN9S10180C253v44Ev
  virtual void  v45(); // _ZN9S10180C253v45Ev
  virtual void  v46(); // _ZN9S10180C253v46Ev
  virtual void  v47(); // _ZN9S10180C253v47Ev
  virtual void  v48(); // _ZN9S10180C253v48Ev
  virtual void  v49(); // _ZN9S10180C253v49Ev
  virtual void  v50(); // _ZN9S10180C253v50Ev
  virtual void  v51(); // _ZN9S10180C253v51Ev
  virtual void  v52(); // _ZN9S10180C253v52Ev
  virtual void  v53(); // _ZN9S10180C253v53Ev
  virtual void  v54(); // _ZN9S10180C253v54Ev
  virtual void  v55(); // _ZN9S10180C253v55Ev
  virtual void  v56(); // _ZN9S10180C253v56Ev
  virtual void  v57(); // _ZN9S10180C253v57Ev
  virtual void  v58(); // _ZN9S10180C253v58Ev
  virtual void  v59(); // _ZN9S10180C253v59Ev
  virtual void  v60(); // _ZN9S10180C253v60Ev
  virtual void  v61(); // _ZN9S10180C253v61Ev
  virtual void  v62(); // _ZN9S10180C253v62Ev
  virtual void  v63(); // _ZN9S10180C253v63Ev
  S10180C25(); // tgen
};
//SIG(-1 S10180C25) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v23} BC7{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 Fp FC8{ m FC9{ m Fp Fi FC4} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC11{ vd v48} BC12{ vd v49 v50} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi FC13{ m Fi[2]} FC13 FC13 FC14{ BC2 vd Fi Fp FC8 FL FC13 Fi Fc Fi FC15{ m FC16{ m Fp Fi[2] FC5} Fp[2]}} FC17{ BC7 vd v51 v52 v53} FC18{ vd m Fi Fp[3] FC19{ m Fc[2] Fp[3] Fi[4] FC20{ m FC21{ FL[4]}}}} FC22{ vd m FC20 Fi[2] FC23{ m FL[3] Fi[3] FL} FL FC24{ m Fi FC25{ m Fi[4]}} FC15 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC26{ BC2 BC27{ vd v55} vd v54 Fi FC28{ m Fc[2]} FC29{ Fp[2]} Fp FC30{ vd m FC31{ vd m FC32{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC33{ BC34{ vd v62 v63 v64 v65 v66 v67 Fi Fp Fc} vd v56 v57 v58 v59 v60 v61 Fp} FC35{ BC36{ vd v69 Fi Fc[3]} vd v68 Fp[4] FL Fi FC20 FC37{ m Fp FC38{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC39{ BC36 vd v70 FC20 Fi Fp[2] FC40{ m FC20 FC37 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC41{ BC36 vd v71 Fp[2] FL Fi[4] FC42{ m Fi[2]} FC20 FC43{ m FC20 FC37 Fp Fi[4]} FC44{ m Fp}} FC20 FC20 FL Fi[5]} FL FC45{ m FC23 FC46{ m Fi} Fi} Fc[128] FC13 FC15} Fi[3] FC47{ m Fp Fi[2]} FC48{ m Fc[11] Fi[2]} FC49{ BC50{} FL Fi} FC51{ BC52{ BC2 vd v74 v75 v76 v77 FC53{ m Fp FC8 FC9 FC9 Fi[3] FC54{ m FC55{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v72 v73} FL FC56{ BC52 v78} FC56 FC51 FC15 Fc}


 S10180C25 ::~S10180C25(){ note_dtor("S10180C25", this);}
void  S10180C25 ::v42(){vfunc_called(this, "_ZN9S10180C253v42Ev");}
void  S10180C25 ::v43(){vfunc_called(this, "_ZN9S10180C253v43Ev");}
void  S10180C25 ::v44(){vfunc_called(this, "_ZN9S10180C253v44Ev");}
void  S10180C25 ::v45(){vfunc_called(this, "_ZN9S10180C253v45Ev");}
void  S10180C25 ::v46(){vfunc_called(this, "_ZN9S10180C253v46Ev");}
void  S10180C25 ::v47(){vfunc_called(this, "_ZN9S10180C253v47Ev");}
void  S10180C25 ::v48(){vfunc_called(this, "_ZN9S10180C253v48Ev");}
void  S10180C25 ::v49(){vfunc_called(this, "_ZN9S10180C253v49Ev");}
void  S10180C25 ::v50(){vfunc_called(this, "_ZN9S10180C253v50Ev");}
void  S10180C25 ::v51(){vfunc_called(this, "_ZN9S10180C253v51Ev");}
void  S10180C25 ::v52(){vfunc_called(this, "_ZN9S10180C253v52Ev");}
void  S10180C25 ::v53(){vfunc_called(this, "_ZN9S10180C253v53Ev");}
void  S10180C25 ::v54(){vfunc_called(this, "_ZN9S10180C253v54Ev");}
void  S10180C25 ::v55(){vfunc_called(this, "_ZN9S10180C253v55Ev");}
void  S10180C25 ::v56(){vfunc_called(this, "_ZN9S10180C253v56Ev");}
void  S10180C25 ::v57(){vfunc_called(this, "_ZN9S10180C253v57Ev");}
void  S10180C25 ::v58(){vfunc_called(this, "_ZN9S10180C253v58Ev");}
void  S10180C25 ::v59(){vfunc_called(this, "_ZN9S10180C253v59Ev");}
void  S10180C25 ::v60(){vfunc_called(this, "_ZN9S10180C253v60Ev");}
void  S10180C25 ::v61(){vfunc_called(this, "_ZN9S10180C253v61Ev");}
void  S10180C25 ::v62(){vfunc_called(this, "_ZN9S10180C253v62Ev");}
void  S10180C25 ::v63(){vfunc_called(this, "_ZN9S10180C253v63Ev");}
S10180C25 ::S10180C25(){ note_ctor("S10180C25", this);} // tgen

static void Test_S10180C25()
{
  extern Class_Descriptor cd_S10180C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2037,3888)];
    init_test(&cd_S10180C25, buf);
    S10180C25 *dp, &lv = *(dp=new (buf) S10180C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16288,15548), "sizeof(S10180C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C25)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C25");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(48,32), "S10180C25");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(56,36), "S10180C25");
    check_base_class_offset(lv, (S10180C26*), ABISELECT(152,100), "S10180C25");
    check_base_class_offset(lv, (S10180C27*), ABISELECT(160,104), "S10180C25");
    check_field_offset(lv, s10180c25f0, ABISELECT(168,108), "S10180C25.s10180c25f0");
    check_field_offset(lv, s10180c25f1, ABISELECT(172,112), "S10180C25.s10180c25f1");
    check_field_offset(lv, s10180c25f2, ABISELECT(180,120), "S10180C25.s10180c25f2");
    check_field_offset(lv, s10180c25f3, ABISELECT(188,128), "S10180C25.s10180c25f3");
    check_field_offset(lv, s10180c25f4, ABISELECT(200,136), "S10180C25.s10180c25f4");
    check_field_offset(lv, s10180c25f5, ABISELECT(352,244), "S10180C25.s10180c25f5");
    check_field_offset(lv, s10180c25f6, ABISELECT(448,308), "S10180C25.s10180c25f6");
    check_field_offset(lv, s10180c25f7, ABISELECT(568,392), "S10180C25.s10180c25f7");
    check_field_offset(lv, s10180c25f8, ABISELECT(792,572), "S10180C25.s10180c25f8");
    check_field_offset(lv, s10180c25f9, ABISELECT(800,576), "S10180C25.s10180c25f9");
    check_field_offset(lv, s10180c25f10, ABISELECT(808,580), "S10180C25.s10180c25f10");
    check_field_offset(lv, s10180c25f11, ABISELECT(15232,14800), "S10180C25.s10180c25f11");
    check_field_offset(lv, s10180c25f12, ABISELECT(15248,14812), "S10180C25.s10180c25f12");
    check_field_offset(lv, s10180c25f13, ABISELECT(15264,14824), "S10180C25.s10180c25f13");
    check_field_offset(lv, s10180c25f14, ABISELECT(15288,14844), "S10180C25.s10180c25f14");
    check_field_offset(lv, s10180c25f15, ABISELECT(15304,14856), "S10180C25.s10180c25f15");
    check_field_offset(lv, s10180c25f16, ABISELECT(15536,15020), "S10180C25.s10180c25f16");
    check_field_offset(lv, s10180c25f17, ABISELECT(15544,15028), "S10180C25.s10180c25f17");
    check_field_offset(lv, s10180c25f18, ABISELECT(15776,15192), "S10180C25.s10180c25f18");
    check_field_offset(lv, s10180c25f19, ABISELECT(16008,15356), "S10180C25.s10180c25f19");
    check_field_offset(lv, s10180c25f20, ABISELECT(16240,15520), "S10180C25.s10180c25f20");
    check_field_offset(lv, s10180c25f21, ABISELECT(16280,15544), "S10180C25.s10180c25f21");
    test_class_info(&lv, &cd_S10180C25);
    dp->~S10180C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C25(Test_S10180C25, "S10180C25", ABISELECT(16288,15548));

#else // __cplusplus

extern void _ZN9S10180C25C1Ev();
extern void _ZN9S10180C25D1Ev();
Name_Map name_map_S10180C25[] = {
  NSPAIR(_ZN9S10180C25C1Ev),
  NSPAIR(_ZN9S10180C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C26;
extern VTBL_ENTRY _ZTI9S10180C26[];
extern  VTBL_ENTRY _ZTV9S10180C26[];
extern Class_Descriptor cd_S10180C27;
extern VTBL_ENTRY _ZTI9S10180C27[];
extern  VTBL_ENTRY _ZTV9S10180C27[];
static Base_Class bases_S10180C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(48,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(56,36), //bcp->offset
    31, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C26,    ABISELECT(152,100), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C27,    ABISELECT(160,104), //bcp->offset
    64, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C25[];
extern void _ZN9S10180C25D1Ev();
extern void _ZN9S10180C25D0Ev();
extern void _ZN9S10180C253v42Ev();
extern void _ZN9S10180C253v43Ev();
extern void _ZN9S10180C253v44Ev();
extern void _ZN9S10180C253v45Ev();
extern void _ZN9S10180C253v46Ev();
extern void _ZN9S10180C253v47Ev();
extern void _ZN9S10180C253v48Ev();
extern void _ZN9S10180C253v49Ev();
extern void _ZN9S10180C253v50Ev();
extern void _ZN9S10180C253v51Ev();
extern void _ZN9S10180C253v52Ev();
extern void _ZN9S10180C253v53Ev();
extern void _ZN9S10180C253v54Ev();
extern void _ZN9S10180C253v55Ev();
extern void _ZN9S10180C253v56Ev();
extern void _ZN9S10180C253v57Ev();
extern void _ZN9S10180C253v58Ev();
extern void _ZN9S10180C253v59Ev();
extern void _ZN9S10180C253v60Ev();
extern void _ZN9S10180C253v61Ev();
extern void _ZN9S10180C253v62Ev();
extern void _ZN9S10180C253v63Ev();
extern void ABISELECT(_ZThn48_N9S10180C25D1Ev,_ZThn32_N9S10180C25D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C25D0Ev,_ZThn32_N9S10180C25D0Ev)();
extern void _ZN8S10180C22v7Ev();
extern void ABISELECT(_ZThn56_N9S10180C25D1Ev,_ZThn36_N9S10180C25D1Ev)();
extern void ABISELECT(_ZThn56_N9S10180C25D0Ev,_ZThn36_N9S10180C25D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn152_N9S10180C25D1Ev,_ZThn100_N9S10180C25D1Ev)();
extern void ABISELECT(_ZThn152_N9S10180C25D0Ev,_ZThn100_N9S10180C25D0Ev)();
extern void _ZN9S10180C263v64Ev();
extern void ABISELECT(_ZThn160_N9S10180C25D1Ev,_ZThn104_N9S10180C25D1Ev)();
extern void ABISELECT(_ZThn160_N9S10180C25D0Ev,_ZThn104_N9S10180C25D0Ev)();
extern void _ZN9S10180C273v65Ev();
extern void _ZN9S10180C273v66Ev();
static  VTBL_ENTRY vtc_S10180C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C25[0]),
  (VTBL_ENTRY)&_ZN9S10180C25D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C25D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v42Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v43Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v44Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v45Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v46Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v47Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v48Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v49Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v50Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v51Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v52Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v53Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v54Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v55Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v56Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v57Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v58Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v59Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v60Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v61Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v62Ev,
  (VTBL_ENTRY)&_ZN9S10180C253v63Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C25D1Ev,_ZThn32_N9S10180C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C25D0Ev,_ZThn32_N9S10180C25D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S10180C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10180C25D1Ev,_ZThn36_N9S10180C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10180C25D0Ev,_ZThn36_N9S10180C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S10180C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10180C25D1Ev,_ZThn100_N9S10180C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10180C25D0Ev,_ZThn100_N9S10180C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C263v64Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S10180C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10180C25D1Ev,_ZThn104_N9S10180C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10180C25D0Ev,_ZThn104_N9S10180C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C273v65Ev,
  (VTBL_ENTRY)&_ZN9S10180C273v66Ev,
};
extern VTBL_ENTRY _ZTI9S10180C25[];
extern  VTBL_ENTRY _ZTV9S10180C25[];
Class_Descriptor cd_S10180C25 = {  "S10180C25", // class name
  bases_S10180C25, 5,
  &(vtc_S10180C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16288,15548), // object size
  NSPAIRA(_ZTI9S10180C25),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S10180C25),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C81  {
  virtual  ~S10180C81(); // _ZN9S10180C81D1Ev
  virtual void  v99(); // _ZN9S10180C813v99Ev
  virtual void  v100(); // _ZN9S10180C814v100Ev
  virtual void  v101(); // _ZN9S10180C814v101Ev
  virtual void  v102(); // _ZN9S10180C814v102Ev
  virtual void  v103(); // _ZN9S10180C814v103Ev
  virtual void  v104(); // _ZN9S10180C814v104Ev
  virtual void  v105(); // _ZN9S10180C814v105Ev
  virtual void  v106(); // _ZN9S10180C814v106Ev
  virtual void  v107(); // _ZN9S10180C814v107Ev
  virtual void  v108(); // _ZN9S10180C814v108Ev
  virtual void  v109(); // _ZN9S10180C814v109Ev
  virtual void  v110(); // _ZN9S10180C814v110Ev
  virtual void  v111(); // _ZN9S10180C814v111Ev
  virtual void  v112(); // _ZN9S10180C814v112Ev
  virtual void  v113(); // _ZN9S10180C814v113Ev
  S10180C81(); // tgen
};
//SIG(-1 S10180C81) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S10180C81 ::~S10180C81(){ note_dtor("S10180C81", this);}
void  S10180C81 ::v99(){vfunc_called(this, "_ZN9S10180C813v99Ev");}
void  S10180C81 ::v100(){vfunc_called(this, "_ZN9S10180C814v100Ev");}
void  S10180C81 ::v101(){vfunc_called(this, "_ZN9S10180C814v101Ev");}
void  S10180C81 ::v102(){vfunc_called(this, "_ZN9S10180C814v102Ev");}
void  S10180C81 ::v103(){vfunc_called(this, "_ZN9S10180C814v103Ev");}
void  S10180C81 ::v104(){vfunc_called(this, "_ZN9S10180C814v104Ev");}
void  S10180C81 ::v105(){vfunc_called(this, "_ZN9S10180C814v105Ev");}
void  S10180C81 ::v106(){vfunc_called(this, "_ZN9S10180C814v106Ev");}
void  S10180C81 ::v107(){vfunc_called(this, "_ZN9S10180C814v107Ev");}
void  S10180C81 ::v108(){vfunc_called(this, "_ZN9S10180C814v108Ev");}
void  S10180C81 ::v109(){vfunc_called(this, "_ZN9S10180C814v109Ev");}
void  S10180C81 ::v110(){vfunc_called(this, "_ZN9S10180C814v110Ev");}
void  S10180C81 ::v111(){vfunc_called(this, "_ZN9S10180C814v111Ev");}
void  S10180C81 ::v112(){vfunc_called(this, "_ZN9S10180C814v112Ev");}
void  S10180C81 ::v113(){vfunc_called(this, "_ZN9S10180C814v113Ev");}
S10180C81 ::S10180C81(){ note_ctor("S10180C81", this);} // tgen

static void Test_S10180C81()
{
  extern Class_Descriptor cd_S10180C81;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10180C81, buf);
    S10180C81 *dp, &lv = *(dp=new (buf) S10180C81());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C81)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C81)");
    test_class_info(&lv, &cd_S10180C81);
    dp->~S10180C81();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C81(Test_S10180C81, "S10180C81", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10180C81C1Ev();
extern void _ZN9S10180C81D1Ev();
Name_Map name_map_S10180C81[] = {
  NSPAIR(_ZN9S10180C81C1Ev),
  NSPAIR(_ZN9S10180C81D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C81[];
extern void _ZN9S10180C81D1Ev();
extern void _ZN9S10180C81D0Ev();
extern void _ZN9S10180C813v99Ev();
extern void _ZN9S10180C814v100Ev();
extern void _ZN9S10180C814v101Ev();
extern void _ZN9S10180C814v102Ev();
extern void _ZN9S10180C814v103Ev();
extern void _ZN9S10180C814v104Ev();
extern void _ZN9S10180C814v105Ev();
extern void _ZN9S10180C814v106Ev();
extern void _ZN9S10180C814v107Ev();
extern void _ZN9S10180C814v108Ev();
extern void _ZN9S10180C814v109Ev();
extern void _ZN9S10180C814v110Ev();
extern void _ZN9S10180C814v111Ev();
extern void _ZN9S10180C814v112Ev();
extern void _ZN9S10180C814v113Ev();
static  VTBL_ENTRY vtc_S10180C81[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C81[0]),
  (VTBL_ENTRY)&_ZN9S10180C81D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C81D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v113Ev,
};
extern VTBL_ENTRY _ZTI9S10180C81[];
extern  VTBL_ENTRY _ZTV9S10180C81[];
Class_Descriptor cd_S10180C81 = {  "S10180C81", // class name
  0,0,//no base classes
  &(vtc_S10180C81[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10180C81),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C81),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C82  {
  void *s10180c82f0;
  void  mf10180c82(); // _ZN9S10180C8210mf10180c82Ev
  virtual  ~S10180C82(); // _ZN9S10180C82D1Ev
  S10180C82(); // tgen
};
//SIG(-1 S10180C82) C1{ vd m Fp}


void  S10180C82 ::mf10180c82(){}
 S10180C82 ::~S10180C82(){ note_dtor("S10180C82", this);}
S10180C82 ::S10180C82(){ note_ctor("S10180C82", this);} // tgen

static void Test_S10180C82()
{
  extern Class_Descriptor cd_S10180C82;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10180C82, buf);
    S10180C82 *dp, &lv = *(dp=new (buf) S10180C82());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10180C82)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C82)");
    check_field_offset(lv, s10180c82f0, ABISELECT(8,4), "S10180C82.s10180c82f0");
    test_class_info(&lv, &cd_S10180C82);
    dp->~S10180C82();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C82(Test_S10180C82, "S10180C82", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN9S10180C82C1Ev();
extern void _ZN9S10180C82D1Ev();
Name_Map name_map_S10180C82[] = {
  NSPAIR(_ZN9S10180C82C1Ev),
  NSPAIR(_ZN9S10180C82D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C82[];
extern void _ZN9S10180C82D1Ev();
extern void _ZN9S10180C82D0Ev();
static  VTBL_ENTRY vtc_S10180C82[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C82[0]),
  (VTBL_ENTRY)&_ZN9S10180C82D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C82D0Ev,
};
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
Class_Descriptor cd_S10180C82 = {  "S10180C82", // class name
  0,0,//no base classes
  &(vtc_S10180C82[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S10180C82),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C82),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C80  : S10180C81 , S10180C82 {
  ~S10180C80(); // tgen
  S10180C80(); // tgen
};
//SIG(-1 S10180C80) C1{ BC2{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15} BC3{ vd m Fp}}


S10180C80 ::~S10180C80(){ note_dtor("S10180C80", this);} // tgen
S10180C80 ::S10180C80(){ note_ctor("S10180C80", this);} // tgen

static void Test_S10180C80()
{
  extern Class_Descriptor cd_S10180C80;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S10180C80, buf);
    S10180C80 *dp, &lv = *(dp=new (buf) S10180C80());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S10180C80)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C80)");
    check_base_class_offset(lv, (S10180C81*), 0, "S10180C80");
    check_base_class_offset(lv, (S10180C82*), ABISELECT(8,4), "S10180C80");
    test_class_info(&lv, &cd_S10180C80);
    dp->~S10180C80();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C80(Test_S10180C80, "S10180C80", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S10180C80C1Ev();
extern void _ZN9S10180C80D1Ev();
Name_Map name_map_S10180C80[] = {
  NSPAIR(_ZN9S10180C80C1Ev),
  NSPAIR(_ZN9S10180C80D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C81;
extern VTBL_ENTRY _ZTI9S10180C81[];
extern  VTBL_ENTRY _ZTV9S10180C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
static Base_Class bases_S10180C80[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C81,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C82,    ABISELECT(8,4), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C80[];
extern void _ZN9S10180C80D1Ev();
extern void _ZN9S10180C80D0Ev();
extern void _ZN9S10180C813v99Ev();
extern void _ZN9S10180C814v100Ev();
extern void _ZN9S10180C814v101Ev();
extern void _ZN9S10180C814v102Ev();
extern void _ZN9S10180C814v103Ev();
extern void _ZN9S10180C814v104Ev();
extern void _ZN9S10180C814v105Ev();
extern void _ZN9S10180C814v106Ev();
extern void _ZN9S10180C814v107Ev();
extern void _ZN9S10180C814v108Ev();
extern void _ZN9S10180C814v109Ev();
extern void _ZN9S10180C814v110Ev();
extern void _ZN9S10180C814v111Ev();
extern void _ZN9S10180C814v112Ev();
extern void _ZN9S10180C814v113Ev();
extern void ABISELECT(_ZThn8_N9S10180C80D1Ev,_ZThn4_N9S10180C80D1Ev)();
extern void ABISELECT(_ZThn8_N9S10180C80D0Ev,_ZThn4_N9S10180C80D0Ev)();
static  VTBL_ENTRY vtc_S10180C80[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C80[0]),
  (VTBL_ENTRY)&_ZN9S10180C80D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C80D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v113Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10180C80[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10180C80D1Ev,_ZThn4_N9S10180C80D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10180C80D0Ev,_ZThn4_N9S10180C80D0Ev),
};
extern VTBL_ENTRY _ZTI9S10180C80[];
extern  VTBL_ENTRY _ZTV9S10180C80[];
Class_Descriptor cd_S10180C80 = {  "S10180C80", // class name
  bases_S10180C80, 2,
  &(vtc_S10180C80[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S10180C80),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10180C80),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C83  {
  virtual  ~S10180C83(); // _ZN9S10180C83D1Ev
  virtual void  v114(); // _ZN9S10180C834v114Ev
  virtual void  v115(); // _ZN9S10180C834v115Ev
  S10180C83(); // tgen
};
//SIG(-1 S10180C83) C1{ vd v1 v2}


 S10180C83 ::~S10180C83(){ note_dtor("S10180C83", this);}
void  S10180C83 ::v114(){vfunc_called(this, "_ZN9S10180C834v114Ev");}
void  S10180C83 ::v115(){vfunc_called(this, "_ZN9S10180C834v115Ev");}
S10180C83 ::S10180C83(){ note_ctor("S10180C83", this);} // tgen

static void Test_S10180C83()
{
  extern Class_Descriptor cd_S10180C83;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10180C83, buf);
    S10180C83 *dp, &lv = *(dp=new (buf) S10180C83());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C83)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C83)");
    test_class_info(&lv, &cd_S10180C83);
    dp->~S10180C83();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C83(Test_S10180C83, "S10180C83", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10180C83C1Ev();
extern void _ZN9S10180C83D1Ev();
Name_Map name_map_S10180C83[] = {
  NSPAIR(_ZN9S10180C83C1Ev),
  NSPAIR(_ZN9S10180C83D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10180C83[];
extern void _ZN9S10180C83D1Ev();
extern void _ZN9S10180C83D0Ev();
extern void _ZN9S10180C834v114Ev();
extern void _ZN9S10180C834v115Ev();
static  VTBL_ENTRY vtc_S10180C83[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C83[0]),
  (VTBL_ENTRY)&_ZN9S10180C83D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C83D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C834v114Ev,
  (VTBL_ENTRY)&_ZN9S10180C834v115Ev,
};
extern VTBL_ENTRY _ZTI9S10180C83[];
extern  VTBL_ENTRY _ZTV9S10180C83[];
Class_Descriptor cd_S10180C83 = {  "S10180C83", // class name
  0,0,//no base classes
  &(vtc_S10180C83[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10180C83),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10180C83),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C86  : S10180C69 {
  virtual void  v150(); // _ZN9S10180C864v150Ev
  ~S10180C86(); // tgen
  S10180C86(); // tgen
};
//SIG(-1 S10180C86) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v2 v3 v4 v5 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1}


void  S10180C86 ::v150(){vfunc_called(this, "_ZN9S10180C864v150Ev");}
S10180C86 ::~S10180C86(){ note_dtor("S10180C86", this);} // tgen
S10180C86 ::S10180C86(){ note_ctor("S10180C86", this);} // tgen

static void Test_S10180C86()
{
  extern Class_Descriptor cd_S10180C86;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10180C86, buf);
    S10180C86 *dp, &lv = *(dp=new (buf) S10180C86());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10180C86)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C86)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*), 0, "S10180C86");
    check_base_class_offset(lv, (S10180C69*), 0, "S10180C86");
    test_class_info(&lv, &cd_S10180C86);
    dp->~S10180C86();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C86(Test_S10180C86, "S10180C86", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10180C86C1Ev();
extern void _ZN9S10180C86D1Ev();
Name_Map name_map_S10180C86[] = {
  NSPAIR(_ZN9S10180C86C1Ev),
  NSPAIR(_ZN9S10180C86D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
static Base_Class bases_S10180C86[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C86[];
extern void _ZN9S10180C86D1Ev();
extern void _ZN9S10180C86D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN9S10180C864v150Ev();
static  VTBL_ENTRY vtc_S10180C86[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C86[0]),
  (VTBL_ENTRY)&_ZN9S10180C86D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C86D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN9S10180C864v150Ev,
};
extern VTBL_ENTRY _ZTI9S10180C86[];
extern  VTBL_ENTRY _ZTV9S10180C86[];
Class_Descriptor cd_S10180C86 = {  "S10180C86", // class name
  bases_S10180C86, 2,
  &(vtc_S10180C86[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10180C86),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C86),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C87  : S10180C69 {
  virtual void  v151(); // _ZN9S10180C874v151Ev
  virtual void  v152(); // _ZN9S10180C874v152Ev
  ~S10180C87(); // tgen
  S10180C87(); // tgen
};
//SIG(-1 S10180C87) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v3 v4 v5 v6 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1 v2}


void  S10180C87 ::v151(){vfunc_called(this, "_ZN9S10180C874v151Ev");}
void  S10180C87 ::v152(){vfunc_called(this, "_ZN9S10180C874v152Ev");}
S10180C87 ::~S10180C87(){ note_dtor("S10180C87", this);} // tgen
S10180C87 ::S10180C87(){ note_ctor("S10180C87", this);} // tgen

static void Test_S10180C87()
{
  extern Class_Descriptor cd_S10180C87;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10180C87, buf);
    S10180C87 *dp, &lv = *(dp=new (buf) S10180C87());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10180C87)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C87)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*), 0, "S10180C87");
    check_base_class_offset(lv, (S10180C69*), 0, "S10180C87");
    test_class_info(&lv, &cd_S10180C87);
    dp->~S10180C87();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C87(Test_S10180C87, "S10180C87", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10180C87C1Ev();
extern void _ZN9S10180C87D1Ev();
Name_Map name_map_S10180C87[] = {
  NSPAIR(_ZN9S10180C87C1Ev),
  NSPAIR(_ZN9S10180C87D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
static Base_Class bases_S10180C87[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C87[];
extern void _ZN9S10180C87D1Ev();
extern void _ZN9S10180C87D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN9S10180C874v151Ev();
extern void _ZN9S10180C874v152Ev();
static  VTBL_ENTRY vtc_S10180C87[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C87[0]),
  (VTBL_ENTRY)&_ZN9S10180C87D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C87D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN9S10180C874v151Ev,
  (VTBL_ENTRY)&_ZN9S10180C874v152Ev,
};
extern VTBL_ENTRY _ZTI9S10180C87[];
extern  VTBL_ENTRY _ZTV9S10180C87[];
Class_Descriptor cd_S10180C87 = {  "S10180C87", // class name
  bases_S10180C87, 2,
  &(vtc_S10180C87[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10180C87),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C87),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C89  {
  void *s10180c89f0[3];
};
//SIG(-1 S10180C89) C1{ Fp[3]}



static void Test_S10180C89()
{
  {
    init_simple_test("S10180C89");
    S10180C89 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S10180C89)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C89)");
    check_field_offset(lv, s10180c89f0, 0, "S10180C89.s10180c89f0");
  }
}
static Arrange_To_Call_Me vS10180C89(Test_S10180C89, "S10180C89", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C88  : S10180C69 {
  ::S10180C89 s10180c88f0;
  ::S10180C55 s10180c88f1[3];
  virtual void  v153(); // _ZN9S10180C884v153Ev
  virtual void  v154(); // _ZN9S10180C884v154Ev
  virtual void  v155(); // _ZN9S10180C884v155Ev
  ~S10180C88(); // tgen
  S10180C88(); // tgen
};
//SIG(-1 S10180C88) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v4 v5 v6 v7 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1 v2 v3 FC12{ Fp[3]} FC13{ Fi[4]}[3]}


void  S10180C88 ::v153(){vfunc_called(this, "_ZN9S10180C884v153Ev");}
void  S10180C88 ::v154(){vfunc_called(this, "_ZN9S10180C884v154Ev");}
void  S10180C88 ::v155(){vfunc_called(this, "_ZN9S10180C884v155Ev");}
S10180C88 ::~S10180C88(){ note_dtor("S10180C88", this);} // tgen
S10180C88 ::S10180C88(){ note_ctor("S10180C88", this);} // tgen

static void Test_S10180C88()
{
  extern Class_Descriptor cd_S10180C88;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,57)];
    init_test(&cd_S10180C88, buf);
    S10180C88 *dp, &lv = *(dp=new (buf) S10180C88());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,224), "sizeof(S10180C88)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C88)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*), 0, "S10180C88");
    check_base_class_offset(lv, (S10180C69*), 0, "S10180C88");
    check_field_offset(lv, s10180c88f0, ABISELECT(232,164), "S10180C88.s10180c88f0");
    check_field_offset(lv, s10180c88f1, ABISELECT(256,176), "S10180C88.s10180c88f1");
    test_class_info(&lv, &cd_S10180C88);
    dp->~S10180C88();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C88(Test_S10180C88, "S10180C88", ABISELECT(304,224));

#else // __cplusplus

extern void _ZN9S10180C88C1Ev();
extern void _ZN9S10180C88D1Ev();
Name_Map name_map_S10180C88[] = {
  NSPAIR(_ZN9S10180C88C1Ev),
  NSPAIR(_ZN9S10180C88D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
static Base_Class bases_S10180C88[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C88[];
extern void _ZN9S10180C88D1Ev();
extern void _ZN9S10180C88D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN9S10180C884v153Ev();
extern void _ZN9S10180C884v154Ev();
extern void _ZN9S10180C884v155Ev();
static  VTBL_ENTRY vtc_S10180C88[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C88[0]),
  (VTBL_ENTRY)&_ZN9S10180C88D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C88D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN9S10180C884v153Ev,
  (VTBL_ENTRY)&_ZN9S10180C884v154Ev,
  (VTBL_ENTRY)&_ZN9S10180C884v155Ev,
};
extern VTBL_ENTRY _ZTI9S10180C88[];
extern  VTBL_ENTRY _ZTV9S10180C88[];
Class_Descriptor cd_S10180C88 = {  "S10180C88", // class name
  bases_S10180C88, 2,
  &(vtc_S10180C88[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,224), // object size
  NSPAIRA(_ZTI9S10180C88),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C88),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C92  {
  ::S10180C13 s10180c92f0;
  int s10180c92f1[2];
  ::S10180C13 s10180c92f2;
  void  mf10180c92(); // _ZN9S10180C9210mf10180c92Ev
};
//SIG(-1 S10180C92) C1{ m FC2{ m Fp Fi FC3{ m}} Fi[2] FC2}


void  S10180C92 ::mf10180c92(){}

static void Test_S10180C92()
{
  {
    init_simple_test("S10180C92");
    S10180C92 lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S10180C92)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C92)");
    check_field_offset(lv, s10180c92f0, 0, "S10180C92.s10180c92f0");
    check_field_offset(lv, s10180c92f1, ABISELECT(16,12), "S10180C92.s10180c92f1");
    check_field_offset(lv, s10180c92f2, ABISELECT(24,20), "S10180C92.s10180c92f2");
  }
}
static Arrange_To_Call_Me vS10180C92(Test_S10180C92, "S10180C92", ABISELECT(40,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C93  {
  __tsi64 s10180c93f0;
  void  mf10180c93(); // _ZN9S10180C9310mf10180c93Ev
};
//SIG(-1 S10180C93) C1{ m FL}


void  S10180C93 ::mf10180c93(){}

static void Test_S10180C93()
{
  {
    init_simple_test("S10180C93");
    S10180C93 lv;
    check2(sizeof(lv), 8, "sizeof(S10180C93)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C93)");
    check_field_offset(lv, s10180c93f0, 0, "S10180C93.s10180c93f0");
  }
}
static Arrange_To_Call_Me vS10180C93(Test_S10180C93, "S10180C93", 8);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S10180C93[];
VTBL_ENTRY *P__ZTI9S10180C93 = _ZTI9S10180C93; 
Class_Descriptor cd_S10180C93 = {  "S10180C93", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI9S10180C93),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C91  : S10180C17 , S10180C11 {
  ::S10180C92 s10180c91f0;
  int s10180c91f1[2];
  char s10180c91f2[2];
  int s10180c91f3;
  __tsi64 s10180c91f4[2];
  ::S10180C93 s10180c91f5;
  int s10180c91f6;
  virtual  ~S10180C91(); // _ZN9S10180C91D1Ev
  virtual void  v156(); // _ZN9S10180C914v156Ev
  virtual void  v157(); // _ZN9S10180C914v157Ev
  virtual void  v158(); // _ZN9S10180C914v158Ev
  virtual void  v159(); // _ZN9S10180C914v159Ev
  virtual void  v160(); // _ZN9S10180C914v160Ev
  virtual void  v161(); // _ZN9S10180C914v161Ev
  virtual void  v162(); // _ZN9S10180C914v162Ev
  virtual void  v163(); // _ZN9S10180C914v163Ev
  S10180C91(); // tgen
};
//SIG(-1 S10180C91) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 FC10{ m FC8 Fi[2] FC8} Fi[2] Fc[2] Fi FL[2] FC11{ m FL} Fi}


 S10180C91 ::~S10180C91(){ note_dtor("S10180C91", this);}
void  S10180C91 ::v156(){vfunc_called(this, "_ZN9S10180C914v156Ev");}
void  S10180C91 ::v157(){vfunc_called(this, "_ZN9S10180C914v157Ev");}
void  S10180C91 ::v158(){vfunc_called(this, "_ZN9S10180C914v158Ev");}
void  S10180C91 ::v159(){vfunc_called(this, "_ZN9S10180C914v159Ev");}
void  S10180C91 ::v160(){vfunc_called(this, "_ZN9S10180C914v160Ev");}
void  S10180C91 ::v161(){vfunc_called(this, "_ZN9S10180C914v161Ev");}
void  S10180C91 ::v162(){vfunc_called(this, "_ZN9S10180C914v162Ev");}
void  S10180C91 ::v163(){vfunc_called(this, "_ZN9S10180C914v163Ev");}
S10180C91 ::S10180C91(){ note_ctor("S10180C91", this);} // tgen

static void Test_S10180C91()
{
  extern Class_Descriptor cd_S10180C91;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,44)];
    init_test(&cd_S10180C91, buf);
    S10180C91 *dp, &lv = *(dp=new (buf) S10180C91());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,172), "sizeof(S10180C91)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C91)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C91");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C91");
    check_field_offset(lv, s10180c91f0, ABISELECT(144,96), "S10180C91.s10180c91f0");
    check_field_offset(lv, s10180c91f1, ABISELECT(184,128), "S10180C91.s10180c91f1");
    check_field_offset(lv, s10180c91f2, ABISELECT(192,136), "S10180C91.s10180c91f2");
    check_field_offset(lv, s10180c91f3, ABISELECT(196,140), "S10180C91.s10180c91f3");
    check_field_offset(lv, s10180c91f4, ABISELECT(200,144), "S10180C91.s10180c91f4");
    check_field_offset(lv, s10180c91f5, ABISELECT(216,160), "S10180C91.s10180c91f5");
    check_field_offset(lv, s10180c91f6, ABISELECT(224,168), "S10180C91.s10180c91f6");
    test_class_info(&lv, &cd_S10180C91);
    dp->~S10180C91();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C91(Test_S10180C91, "S10180C91", ABISELECT(232,172));

#else // __cplusplus

extern void _ZN9S10180C91C1Ev();
extern void _ZN9S10180C91D1Ev();
Name_Map name_map_S10180C91[] = {
  NSPAIR(_ZN9S10180C91C1Ev),
  NSPAIR(_ZN9S10180C91D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C91[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C91[];
extern void _ZN9S10180C91D1Ev();
extern void _ZN9S10180C91D0Ev();
extern void _ZN9S10180C914v156Ev();
extern void _ZN9S10180C914v157Ev();
extern void _ZN9S10180C914v158Ev();
extern void _ZN9S10180C914v159Ev();
extern void _ZN9S10180C914v160Ev();
extern void _ZN9S10180C914v161Ev();
extern void _ZN9S10180C914v162Ev();
extern void _ZN9S10180C914v163Ev();
extern void ABISELECT(_ZThn48_N9S10180C91D1Ev,_ZThn32_N9S10180C91D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C91D0Ev,_ZThn32_N9S10180C91D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
static  VTBL_ENTRY vtc_S10180C91[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C91[0]),
  (VTBL_ENTRY)&_ZN9S10180C91D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C91D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v156Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v157Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v158Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v159Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v160Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v161Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v162Ev,
  (VTBL_ENTRY)&_ZN9S10180C914v163Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C91[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C91D1Ev,_ZThn32_N9S10180C91D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C91D0Ev,_ZThn32_N9S10180C91D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
};
extern VTBL_ENTRY _ZTI9S10180C91[];
extern  VTBL_ENTRY _ZTV9S10180C91[];
Class_Descriptor cd_S10180C91 = {  "S10180C91", // class name
  bases_S10180C91, 2,
  &(vtc_S10180C91[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,172), // object size
  NSPAIRA(_ZTI9S10180C91),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10180C91),40, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C95  : S10180C17 , S10180C11 {
  virtual  ~S10180C95(); // _ZN9S10180C95D1Ev
  virtual void  v169(); // _ZN9S10180C954v169Ev
  virtual void  v170(); // _ZN9S10180C954v170Ev
  virtual void  v171(); // _ZN9S10180C954v171Ev
  virtual void  v172(); // _ZN9S10180C954v172Ev
  virtual void  v173(); // _ZN9S10180C954v173Ev
  virtual void  v174(); // _ZN9S10180C954v174Ev
  S10180C95(); // tgen
};
//SIG(-1 S10180C95) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4 v5 v6}


 S10180C95 ::~S10180C95(){ note_dtor("S10180C95", this);}
void  S10180C95 ::v169(){vfunc_called(this, "_ZN9S10180C954v169Ev");}
void  S10180C95 ::v170(){vfunc_called(this, "_ZN9S10180C954v170Ev");}
void  S10180C95 ::v171(){vfunc_called(this, "_ZN9S10180C954v171Ev");}
void  S10180C95 ::v172(){vfunc_called(this, "_ZN9S10180C954v172Ev");}
void  S10180C95 ::v173(){vfunc_called(this, "_ZN9S10180C954v173Ev");}
void  S10180C95 ::v174(){vfunc_called(this, "_ZN9S10180C954v174Ev");}
S10180C95 ::S10180C95(){ note_ctor("S10180C95", this);} // tgen

static void Test_S10180C95()
{
  extern Class_Descriptor cd_S10180C95;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,25)];
    init_test(&cd_S10180C95, buf);
    S10180C95 *dp, &lv = *(dp=new (buf) S10180C95());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S10180C95)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C95)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C95");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C95");
    test_class_info(&lv, &cd_S10180C95);
    dp->~S10180C95();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C95(Test_S10180C95, "S10180C95", ABISELECT(144,96));

#else // __cplusplus

extern void _ZN9S10180C95C1Ev();
extern void _ZN9S10180C95D1Ev();
Name_Map name_map_S10180C95[] = {
  NSPAIR(_ZN9S10180C95C1Ev),
  NSPAIR(_ZN9S10180C95D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C95[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C95[];
extern void _ZN9S10180C95D1Ev();
extern void _ZN9S10180C95D0Ev();
extern void _ZN9S10180C954v169Ev();
extern void _ZN9S10180C954v170Ev();
extern void _ZN9S10180C954v171Ev();
extern void _ZN9S10180C954v172Ev();
extern void _ZN9S10180C954v173Ev();
extern void _ZN9S10180C954v174Ev();
extern void ABISELECT(_ZThn48_N9S10180C95D1Ev,_ZThn32_N9S10180C95D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C95D0Ev,_ZThn32_N9S10180C95D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
static  VTBL_ENTRY vtc_S10180C95[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C95[0]),
  (VTBL_ENTRY)&_ZN9S10180C95D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C95D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v169Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v170Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v171Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v172Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v173Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v174Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C95[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C95D1Ev,_ZThn32_N9S10180C95D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C95D0Ev,_ZThn32_N9S10180C95D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
};
extern VTBL_ENTRY _ZTI9S10180C95[];
extern  VTBL_ENTRY _ZTV9S10180C95[];
Class_Descriptor cd_S10180C95 = {  "S10180C95", // class name
  bases_S10180C95, 2,
  &(vtc_S10180C95[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,96), // object size
  NSPAIRA(_ZTI9S10180C95),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10180C95),38, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C96  {
  int s10180c96f0;
  void *s10180c96f1;
  int s10180c96f2;
  ::S10180C73 s10180c96f3;
  void  mf10180c96(); // _ZN9S10180C9610mf10180c96Ev
};
//SIG(-1 S10180C96) C1{ m Fi Fp Fi FC2{ m FC3{ m FL[2]}}}


void  S10180C96 ::mf10180c96(){}

static void Test_S10180C96()
{
  {
    init_simple_test("S10180C96");
    S10180C96 lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S10180C96)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C96)");
    check_field_offset(lv, s10180c96f0, 0, "S10180C96.s10180c96f0");
    check_field_offset(lv, s10180c96f1, ABISELECT(8,4), "S10180C96.s10180c96f1");
    check_field_offset(lv, s10180c96f2, ABISELECT(16,8), "S10180C96.s10180c96f2");
    check_field_offset(lv, s10180c96f3, ABISELECT(24,12), "S10180C96.s10180c96f3");
  }
}
static Arrange_To_Call_Me vS10180C96(Test_S10180C96, "S10180C96", ABISELECT(40,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C94  : S10180C95 , S10180C2 {
  ::S10180C96 s10180c94f0;
  ::S10180C32 s10180c94f1;
  virtual  ~S10180C94(); // _ZN9S10180C94D1Ev
  virtual void  v164(); // _ZN9S10180C944v164Ev
  virtual void  v165(); // _ZN9S10180C944v165Ev
  virtual void  v166(); // _ZN9S10180C944v166Ev
  virtual void  v167(); // _ZN9S10180C944v167Ev
  virtual void  v168(); // _ZN9S10180C944v168Ev
  S10180C94(); // tgen
};
//SIG(-1 S10180C94) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} BC7{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v30 v31 v32 v33 v34 v35} BC11{ vd v36} vd v1 v2 v3 v4 v5 FC12{ m Fi Fp Fi FC13{ m FC14{ m FL[2]}}} FC15{ m Fp Fi[2] FC6}}


 S10180C94 ::~S10180C94(){ note_dtor("S10180C94", this);}
void  S10180C94 ::v164(){vfunc_called(this, "_ZN9S10180C944v164Ev");}
void  S10180C94 ::v165(){vfunc_called(this, "_ZN9S10180C944v165Ev");}
void  S10180C94 ::v166(){vfunc_called(this, "_ZN9S10180C944v166Ev");}
void  S10180C94 ::v167(){vfunc_called(this, "_ZN9S10180C944v167Ev");}
void  S10180C94 ::v168(){vfunc_called(this, "_ZN9S10180C944v168Ev");}
S10180C94 ::S10180C94(){ note_ctor("S10180C94", this);} // tgen

static void Test_S10180C94()
{
  extern Class_Descriptor cd_S10180C94;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,37)];
    init_test(&cd_S10180C94, buf);
    S10180C94 *dp, &lv = *(dp=new (buf) S10180C94());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,144), "sizeof(S10180C94)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C94)");
    check_base_class_offset(lv, (S10180C17*)(S10180C95*), 0, "S10180C94");
    check_base_class_offset(lv, (S10180C11*)(S10180C95*), ABISELECT(48,32), "S10180C94");
    check_base_class_offset(lv, (S10180C95*), 0, "S10180C94");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(144,96), "S10180C94");
    check_field_offset(lv, s10180c94f0, ABISELECT(152,100), "S10180C94.s10180c94f0");
    check_field_offset(lv, s10180c94f1, ABISELECT(192,128), "S10180C94.s10180c94f1");
    test_class_info(&lv, &cd_S10180C94);
    dp->~S10180C94();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C94(Test_S10180C94, "S10180C94", ABISELECT(216,144));

#else // __cplusplus

extern void _ZN9S10180C94C1Ev();
extern void _ZN9S10180C94D1Ev();
Name_Map name_map_S10180C94[] = {
  NSPAIR(_ZN9S10180C94C1Ev),
  NSPAIR(_ZN9S10180C94D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C95;
extern VTBL_ENTRY _ZTI9S10180C95[];
extern  VTBL_ENTRY _ZTV9S10180C95[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
static Base_Class bases_S10180C94[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10180C95,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C94[];
extern void _ZN9S10180C94D1Ev();
extern void _ZN9S10180C94D0Ev();
extern void _ZN9S10180C954v169Ev();
extern void _ZN9S10180C954v170Ev();
extern void _ZN9S10180C954v171Ev();
extern void _ZN9S10180C954v172Ev();
extern void _ZN9S10180C954v173Ev();
extern void _ZN9S10180C954v174Ev();
extern void _ZN9S10180C944v164Ev();
extern void _ZN9S10180C944v165Ev();
extern void _ZN9S10180C944v166Ev();
extern void _ZN9S10180C944v167Ev();
extern void _ZN9S10180C944v168Ev();
extern void ABISELECT(_ZThn48_N9S10180C94D1Ev,_ZThn32_N9S10180C94D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C94D0Ev,_ZThn32_N9S10180C94D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N9S10180C94D1Ev,_ZThn96_N9S10180C94D1Ev)();
extern void ABISELECT(_ZThn144_N9S10180C94D0Ev,_ZThn96_N9S10180C94D0Ev)();
extern void _ZN8S10180C22v7Ev();
static  VTBL_ENTRY vtc_S10180C94[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C94[0]),
  (VTBL_ENTRY)&_ZN9S10180C94D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C94D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v169Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v170Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v171Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v172Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v173Ev,
  (VTBL_ENTRY)&_ZN9S10180C954v174Ev,
  (VTBL_ENTRY)&_ZN9S10180C944v164Ev,
  (VTBL_ENTRY)&_ZN9S10180C944v165Ev,
  (VTBL_ENTRY)&_ZN9S10180C944v166Ev,
  (VTBL_ENTRY)&_ZN9S10180C944v167Ev,
  (VTBL_ENTRY)&_ZN9S10180C944v168Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C94[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C94D1Ev,_ZThn32_N9S10180C94D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C94D0Ev,_ZThn32_N9S10180C94D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S10180C94[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10180C94D1Ev,_ZThn96_N9S10180C94D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10180C94D0Ev,_ZThn96_N9S10180C94D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
};
extern VTBL_ENTRY _ZTI9S10180C94[];
extern  VTBL_ENTRY _ZTV9S10180C94[];
Class_Descriptor cd_S10180C94 = {  "S10180C94", // class name
  bases_S10180C94, 4,
  &(vtc_S10180C94[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,144), // object size
  NSPAIRA(_ZTI9S10180C94),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10180C94),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C99  : S10180C17 , S10180C11 {
  ::S10180C31 s10180c99f0;
  void *s10180c99f1[2];
  ::S10180C13 s10180c99f2;
  int s10180c99f3;
  virtual  ~S10180C99(); // _ZN9S10180C99D1Ev
  virtual void  v175(); // _ZN9S10180C994v175Ev
  virtual void  v176(); // _ZN9S10180C994v176Ev
  virtual void  v177(); // _ZN9S10180C994v177Ev
  virtual void  v178(); // _ZN9S10180C994v178Ev
  S10180C99(); // tgen
};
//SIG(-1 S10180C99) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4 FC10{ m FC11{ m Fp Fi[2] FC5} Fp[2]} Fp[2] FC8 Fi}


 S10180C99 ::~S10180C99(){ note_dtor("S10180C99", this);}
void  S10180C99 ::v175(){vfunc_called(this, "_ZN9S10180C994v175Ev");}
void  S10180C99 ::v176(){vfunc_called(this, "_ZN9S10180C994v176Ev");}
void  S10180C99 ::v177(){vfunc_called(this, "_ZN9S10180C994v177Ev");}
void  S10180C99 ::v178(){vfunc_called(this, "_ZN9S10180C994v178Ev");}
S10180C99 ::S10180C99(){ note_ctor("S10180C99", this);} // tgen

static void Test_S10180C99()
{
  extern Class_Descriptor cd_S10180C99;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,37)];
    init_test(&cd_S10180C99, buf);
    S10180C99 *dp, &lv = *(dp=new (buf) S10180C99());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,144), "sizeof(S10180C99)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C99)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C99");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C99");
    check_field_offset(lv, s10180c99f0, ABISELECT(144,96), "S10180C99.s10180c99f0");
    check_field_offset(lv, s10180c99f1, ABISELECT(184,120), "S10180C99.s10180c99f1");
    check_field_offset(lv, s10180c99f2, ABISELECT(200,128), "S10180C99.s10180c99f2");
    check_field_offset(lv, s10180c99f3, ABISELECT(216,140), "S10180C99.s10180c99f3");
    test_class_info(&lv, &cd_S10180C99);
    dp->~S10180C99();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C99(Test_S10180C99, "S10180C99", ABISELECT(224,144));

#else // __cplusplus

extern void _ZN9S10180C99C1Ev();
extern void _ZN9S10180C99D1Ev();
Name_Map name_map_S10180C99[] = {
  NSPAIR(_ZN9S10180C99C1Ev),
  NSPAIR(_ZN9S10180C99D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C99[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C99[];
extern void _ZN9S10180C99D1Ev();
extern void _ZN9S10180C99D0Ev();
extern void _ZN9S10180C994v175Ev();
extern void _ZN9S10180C994v176Ev();
extern void _ZN9S10180C994v177Ev();
extern void _ZN9S10180C994v178Ev();
extern void ABISELECT(_ZThn48_N9S10180C99D1Ev,_ZThn32_N9S10180C99D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C99D0Ev,_ZThn32_N9S10180C99D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
static  VTBL_ENTRY vtc_S10180C99[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C99[0]),
  (VTBL_ENTRY)&_ZN9S10180C99D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C99D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C994v175Ev,
  (VTBL_ENTRY)&_ZN9S10180C994v176Ev,
  (VTBL_ENTRY)&_ZN9S10180C994v177Ev,
  (VTBL_ENTRY)&_ZN9S10180C994v178Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C99[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C99D1Ev,_ZThn32_N9S10180C99D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C99D0Ev,_ZThn32_N9S10180C99D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
};
extern VTBL_ENTRY _ZTI9S10180C99[];
extern  VTBL_ENTRY _ZTV9S10180C99[];
Class_Descriptor cd_S10180C99 = {  "S10180C99", // class name
  bases_S10180C99, 2,
  &(vtc_S10180C99[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,144), // object size
  NSPAIRA(_ZTI9S10180C99),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10180C99),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C101  : S10180C17 {
  void *s10180c101f0;
  ::S10180C12 s10180c101f1;
  ::S10180C12 s10180c101f2;
  void *s10180c101f3;
  int s10180c101f4;
  ::S10180C73 s10180c101f5;
  virtual  ~S10180C101(); // _ZN10S10180C101D1Ev
  virtual void  v198(); // _ZN10S10180C1014v198Ev
  S10180C101(); // tgen
};
//SIG(-1 S10180C101) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 Fp FC6{ m FC7{ m Fp Fi FC4} Fi} FC6 Fp Fi FC8{ m FC9{ m FL[2]}}}


 S10180C101 ::~S10180C101(){ note_dtor("S10180C101", this);}
void  S10180C101 ::v198(){vfunc_called(this, "_ZN10S10180C1014v198Ev");}
S10180C101 ::S10180C101(){ note_ctor("S10180C101", this);} // tgen

static void Test_S10180C101()
{
  extern Class_Descriptor cd_S10180C101;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S10180C101, buf);
    S10180C101 *dp, &lv = *(dp=new (buf) S10180C101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S10180C101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C101)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C101");
    check_field_offset(lv, s10180c101f0, ABISELECT(48,32), "S10180C101.s10180c101f0");
    check_field_offset(lv, s10180c101f1, ABISELECT(56,36), "S10180C101.s10180c101f1");
    check_field_offset(lv, s10180c101f2, ABISELECT(80,52), "S10180C101.s10180c101f2");
    check_field_offset(lv, s10180c101f3, ABISELECT(104,68), "S10180C101.s10180c101f3");
    check_field_offset(lv, s10180c101f4, ABISELECT(112,72), "S10180C101.s10180c101f4");
    check_field_offset(lv, s10180c101f5, ABISELECT(120,76), "S10180C101.s10180c101f5");
    test_class_info(&lv, &cd_S10180C101);
    dp->~S10180C101();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C101(Test_S10180C101, "S10180C101", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN10S10180C101C1Ev();
extern void _ZN10S10180C101D1Ev();
Name_Map name_map_S10180C101[] = {
  NSPAIR(_ZN10S10180C101C1Ev),
  NSPAIR(_ZN10S10180C101D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C101[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C101[];
extern void _ZN10S10180C101D1Ev();
extern void _ZN10S10180C101D0Ev();
extern void _ZN10S10180C1014v198Ev();
static  VTBL_ENTRY vtc_S10180C101[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C101[0]),
  (VTBL_ENTRY)&_ZN10S10180C101D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C101D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1014v198Ev,
};
extern VTBL_ENTRY _ZTI10S10180C101[];
extern  VTBL_ENTRY _ZTV10S10180C101[];
Class_Descriptor cd_S10180C101 = {  "S10180C101", // class name
  bases_S10180C101, 1,
  &(vtc_S10180C101[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI10S10180C101),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C101),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C100  : S10180C17 , S10180C11 , S10180C2 , S10180C80 , S10180C83 , S10180C26 {
  ::S10180C31 s10180c100f0;
  void *s10180c100f1[2];
  int s10180c100f2[2];
  ::S10180C101 s10180c100f3;
  ::S10180C68 s10180c100f4;
  ::S10180C87 s10180c100f5;
  ::S10180C87 s10180c100f6;
  ::S10180C73 s10180c100f7;
  ::S10180C73 s10180c100f8;
  ::S10180C73 s10180c100f9;
  int s10180c100f10;
  virtual  ~S10180C100(); // _ZN10S10180C100D1Ev
  virtual void  v179(); // _ZN10S10180C1004v179Ev
  virtual void  v180(); // _ZN10S10180C1004v180Ev
  virtual void  v181(); // _ZN10S10180C1004v181Ev
  virtual void  v182(); // _ZN10S10180C1004v182Ev
  virtual void  v183(); // _ZN10S10180C1004v183Ev
  virtual void  v184(); // _ZN10S10180C1004v184Ev
  virtual void  v185(); // _ZN10S10180C1004v185Ev
  virtual void  v186(); // _ZN10S10180C1004v186Ev
  virtual void  v187(); // _ZN10S10180C1004v187Ev
  virtual void  v188(); // _ZN10S10180C1004v188Ev
  virtual void  v189(); // _ZN10S10180C1004v189Ev
  virtual void  v190(); // _ZN10S10180C1004v190Ev
  virtual void  v191(); // _ZN10S10180C1004v191Ev
  virtual void  v192(); // _ZN10S10180C1004v192Ev
  virtual void  v193(); // _ZN10S10180C1004v193Ev
  virtual void  v194(); // _ZN10S10180C1004v194Ev
  virtual void  v195(); // _ZN10S10180C1004v195Ev
  virtual void  v196(); // _ZN10S10180C1004v196Ev
  virtual void  v197(); // _ZN10S10180C1004v197Ev
  S10180C100(); // tgen
};
//SIG(-1 S10180C100) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v44} BC11{ BC12{ vd v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59} BC13{ vd m Fp}} BC14{ vd v60 v61} BC15{ vd v62} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC16{ m FC17{ m Fp Fi[2] FC5} Fp[2]} Fp[2] Fi[2] FC18{ BC2 vd v63 Fp FC7 FC7 Fp Fi FC19{ m FC20{ m FL[2]}}} FC21{ BC22{ BC2 vd v66 v67 v68 v69 FC23{ m Fp FC7 FC8 FC8 Fi[3] FC19 Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v64 v65} FC24{ BC22 v70 v71} FC24 FC19 FC19 FC19 Fi}


 S10180C100 ::~S10180C100(){ note_dtor("S10180C100", this);}
void  S10180C100 ::v179(){vfunc_called(this, "_ZN10S10180C1004v179Ev");}
void  S10180C100 ::v180(){vfunc_called(this, "_ZN10S10180C1004v180Ev");}
void  S10180C100 ::v181(){vfunc_called(this, "_ZN10S10180C1004v181Ev");}
void  S10180C100 ::v182(){vfunc_called(this, "_ZN10S10180C1004v182Ev");}
void  S10180C100 ::v183(){vfunc_called(this, "_ZN10S10180C1004v183Ev");}
void  S10180C100 ::v184(){vfunc_called(this, "_ZN10S10180C1004v184Ev");}
void  S10180C100 ::v185(){vfunc_called(this, "_ZN10S10180C1004v185Ev");}
void  S10180C100 ::v186(){vfunc_called(this, "_ZN10S10180C1004v186Ev");}
void  S10180C100 ::v187(){vfunc_called(this, "_ZN10S10180C1004v187Ev");}
void  S10180C100 ::v188(){vfunc_called(this, "_ZN10S10180C1004v188Ev");}
void  S10180C100 ::v189(){vfunc_called(this, "_ZN10S10180C1004v189Ev");}
void  S10180C100 ::v190(){vfunc_called(this, "_ZN10S10180C1004v190Ev");}
void  S10180C100 ::v191(){vfunc_called(this, "_ZN10S10180C1004v191Ev");}
void  S10180C100 ::v192(){vfunc_called(this, "_ZN10S10180C1004v192Ev");}
void  S10180C100 ::v193(){vfunc_called(this, "_ZN10S10180C1004v193Ev");}
void  S10180C100 ::v194(){vfunc_called(this, "_ZN10S10180C1004v194Ev");}
void  S10180C100 ::v195(){vfunc_called(this, "_ZN10S10180C1004v195Ev");}
void  S10180C100 ::v196(){vfunc_called(this, "_ZN10S10180C1004v196Ev");}
void  S10180C100 ::v197(){vfunc_called(this, "_ZN10S10180C1004v197Ev");}
S10180C100 ::S10180C100(){ note_ctor("S10180C100", this);} // tgen

static void Test_S10180C100()
{
  extern Class_Descriptor cd_S10180C100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(144,200)];
    init_test(&cd_S10180C100, buf);
    S10180C100 *dp, &lv = *(dp=new (buf) S10180C100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1144,796), "sizeof(S10180C100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C100)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C100");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C100");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(144,96), "S10180C100");
    check_base_class_offset(lv, (S10180C81*)(S10180C80*), ABISELECT(152,100), "S10180C100");
    check_base_class_offset(lv, (S10180C82*)(S10180C80*), ABISELECT(160,104), "S10180C100");
    check_base_class_offset(lv, (S10180C80*), ABISELECT(152,100), "S10180C100");
    check_base_class_offset(lv, (S10180C83*), ABISELECT(176,112), "S10180C100");
    check_base_class_offset(lv, (S10180C26*), ABISELECT(184,116), "S10180C100");
    check_field_offset(lv, s10180c100f0, ABISELECT(192,120), "S10180C100.s10180c100f0");
    check_field_offset(lv, s10180c100f1, ABISELECT(232,144), "S10180C100.s10180c100f1");
    check_field_offset(lv, s10180c100f2, ABISELECT(248,152), "S10180C100.s10180c100f2");
    check_field_offset(lv, s10180c100f3, ABISELECT(256,160), "S10180C100.s10180c100f3");
    check_field_offset(lv, s10180c100f4, ABISELECT(392,252), "S10180C100.s10180c100f4");
    check_field_offset(lv, s10180c100f5, ABISELECT(624,416), "S10180C100.s10180c100f5");
    check_field_offset(lv, s10180c100f6, ABISELECT(856,580), "S10180C100.s10180c100f6");
    check_field_offset(lv, s10180c100f7, ABISELECT(1088,744), "S10180C100.s10180c100f7");
    check_field_offset(lv, s10180c100f8, ABISELECT(1104,760), "S10180C100.s10180c100f8");
    check_field_offset(lv, s10180c100f9, ABISELECT(1120,776), "S10180C100.s10180c100f9");
    check_field_offset(lv, s10180c100f10, ABISELECT(1136,792), "S10180C100.s10180c100f10");
    test_class_info(&lv, &cd_S10180C100);
    dp->~S10180C100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C100(Test_S10180C100, "S10180C100", ABISELECT(1144,796));

#else // __cplusplus

extern void _ZN10S10180C100C1Ev();
extern void _ZN10S10180C100D1Ev();
Name_Map name_map_S10180C100[] = {
  NSPAIR(_ZN10S10180C100C1Ev),
  NSPAIR(_ZN10S10180C100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C81;
extern VTBL_ENTRY _ZTI9S10180C81[];
extern  VTBL_ENTRY _ZTV9S10180C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
extern Class_Descriptor cd_S10180C80;
extern VTBL_ENTRY _ZTI9S10180C80[];
extern  VTBL_ENTRY _ZTV9S10180C80[];
extern Class_Descriptor cd_S10180C83;
extern VTBL_ENTRY _ZTI9S10180C83[];
extern  VTBL_ENTRY _ZTV9S10180C83[];
extern Class_Descriptor cd_S10180C26;
extern VTBL_ENTRY _ZTI9S10180C26[];
extern  VTBL_ENTRY _ZTV9S10180C26[];
static Base_Class bases_S10180C100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    51, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C81,    ABISELECT(152,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C82,    ABISELECT(160,104), //bcp->offset
    75, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C80,    ABISELECT(152,100), //bcp->offset
    56, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C83,    ABISELECT(176,112), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C26,    ABISELECT(184,116), //bcp->offset
    85, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C100[];
extern void _ZN10S10180C100D1Ev();
extern void _ZN10S10180C100D0Ev();
extern void _ZN10S10180C1004v179Ev();
extern void _ZN10S10180C1004v180Ev();
extern void _ZN10S10180C1004v181Ev();
extern void _ZN10S10180C1004v182Ev();
extern void _ZN10S10180C1004v183Ev();
extern void _ZN10S10180C1004v184Ev();
extern void _ZN10S10180C1004v185Ev();
extern void _ZN10S10180C1004v186Ev();
extern void _ZN10S10180C1004v187Ev();
extern void _ZN10S10180C1004v188Ev();
extern void _ZN10S10180C1004v189Ev();
extern void _ZN10S10180C1004v190Ev();
extern void _ZN10S10180C1004v191Ev();
extern void _ZN10S10180C1004v192Ev();
extern void _ZN10S10180C1004v193Ev();
extern void _ZN10S10180C1004v194Ev();
extern void _ZN10S10180C1004v195Ev();
extern void _ZN10S10180C1004v196Ev();
extern void _ZN10S10180C1004v197Ev();
extern void ABISELECT(_ZThn48_N10S10180C100D1Ev,_ZThn32_N10S10180C100D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C100D0Ev,_ZThn32_N10S10180C100D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10180C100D1Ev,_ZThn96_N10S10180C100D1Ev)();
extern void ABISELECT(_ZThn144_N10S10180C100D0Ev,_ZThn96_N10S10180C100D0Ev)();
extern void _ZN8S10180C22v7Ev();
extern void ABISELECT(_ZThn152_N10S10180C100D1Ev,_ZThn100_N10S10180C100D1Ev)();
extern void ABISELECT(_ZThn152_N10S10180C100D0Ev,_ZThn100_N10S10180C100D0Ev)();
extern void _ZN9S10180C813v99Ev();
extern void _ZN9S10180C814v100Ev();
extern void _ZN9S10180C814v101Ev();
extern void _ZN9S10180C814v102Ev();
extern void _ZN9S10180C814v103Ev();
extern void _ZN9S10180C814v104Ev();
extern void _ZN9S10180C814v105Ev();
extern void _ZN9S10180C814v106Ev();
extern void _ZN9S10180C814v107Ev();
extern void _ZN9S10180C814v108Ev();
extern void _ZN9S10180C814v109Ev();
extern void _ZN9S10180C814v110Ev();
extern void _ZN9S10180C814v111Ev();
extern void _ZN9S10180C814v112Ev();
extern void _ZN9S10180C814v113Ev();
extern void ABISELECT(_ZThn160_N10S10180C100D1Ev,_ZThn104_N10S10180C100D1Ev)();
extern void ABISELECT(_ZThn160_N10S10180C100D0Ev,_ZThn104_N10S10180C100D0Ev)();
extern void ABISELECT(_ZThn176_N10S10180C100D1Ev,_ZThn112_N10S10180C100D1Ev)();
extern void ABISELECT(_ZThn176_N10S10180C100D0Ev,_ZThn112_N10S10180C100D0Ev)();
extern void _ZN9S10180C834v114Ev();
extern void _ZN9S10180C834v115Ev();
extern void ABISELECT(_ZThn184_N10S10180C100D1Ev,_ZThn116_N10S10180C100D1Ev)();
extern void ABISELECT(_ZThn184_N10S10180C100D0Ev,_ZThn116_N10S10180C100D0Ev)();
extern void _ZN9S10180C263v64Ev();
static  VTBL_ENTRY vtc_S10180C100[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C100[0]),
  (VTBL_ENTRY)&_ZN10S10180C100D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C100D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v179Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v180Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v181Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v182Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v183Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v184Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v185Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v186Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v187Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v188Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v189Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v190Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v191Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v192Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v193Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v194Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v195Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v196Ev,
  (VTBL_ENTRY)&_ZN10S10180C1004v197Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C100D1Ev,_ZThn32_N10S10180C100D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C100D0Ev,_ZThn32_N10S10180C100D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10180C100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C100D1Ev,_ZThn96_N10S10180C100D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C100D0Ev,_ZThn96_N10S10180C100D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI10S10180C100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N10S10180C100D1Ev,_ZThn100_N10S10180C100D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N10S10180C100D0Ev,_ZThn100_N10S10180C100D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v113Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI10S10180C100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N10S10180C100D1Ev,_ZThn104_N10S10180C100D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N10S10180C100D0Ev,_ZThn104_N10S10180C100D0Ev),
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI10S10180C100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N10S10180C100D1Ev,_ZThn112_N10S10180C100D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N10S10180C100D0Ev,_ZThn112_N10S10180C100D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C834v114Ev,
  (VTBL_ENTRY)&_ZN9S10180C834v115Ev,
  ABISELECT(-184,-116),
  (VTBL_ENTRY)&(_ZTI10S10180C100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N10S10180C100D1Ev,_ZThn116_N10S10180C100D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N10S10180C100D0Ev,_ZThn116_N10S10180C100D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C263v64Ev,
};
extern VTBL_ENTRY _ZTI10S10180C100[];
extern  VTBL_ENTRY _ZTV10S10180C100[];
Class_Descriptor cd_S10180C100 = {  "S10180C100", // class name
  bases_S10180C100, 8,
  &(vtc_S10180C100[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1144,796), // object size
  NSPAIRA(_ZTI10S10180C100),ABISELECT(120,64), //typeinfo_var
  NSPAIRA(_ZTV10S10180C100),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C105  : S10180C69 {
  void *s10180c105f0[3];
  virtual void  v230(); // _ZN10S10180C1054v230Ev
  virtual void  v231(); // _ZN10S10180C1054v231Ev
  virtual void  v232(); // _ZN10S10180C1054v232Ev
  ~S10180C105(); // tgen
  S10180C105(); // tgen
};
//SIG(-1 S10180C105) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v4 v5 v6 v7 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1 v2 v3 Fp[3]}


void  S10180C105 ::v230(){vfunc_called(this, "_ZN10S10180C1054v230Ev");}
void  S10180C105 ::v231(){vfunc_called(this, "_ZN10S10180C1054v231Ev");}
void  S10180C105 ::v232(){vfunc_called(this, "_ZN10S10180C1054v232Ev");}
S10180C105 ::~S10180C105(){ note_dtor("S10180C105", this);} // tgen
S10180C105 ::S10180C105(){ note_ctor("S10180C105", this);} // tgen

static void Test_S10180C105()
{
  extern Class_Descriptor cd_S10180C105;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,45)];
    init_test(&cd_S10180C105, buf);
    S10180C105 *dp, &lv = *(dp=new (buf) S10180C105());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,176), "sizeof(S10180C105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C105)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*), 0, "S10180C105");
    check_base_class_offset(lv, (S10180C69*), 0, "S10180C105");
    check_field_offset(lv, s10180c105f0, ABISELECT(232,164), "S10180C105.s10180c105f0");
    test_class_info(&lv, &cd_S10180C105);
    dp->~S10180C105();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C105(Test_S10180C105, "S10180C105", ABISELECT(256,176));

#else // __cplusplus

extern void _ZN10S10180C105C1Ev();
extern void _ZN10S10180C105D1Ev();
Name_Map name_map_S10180C105[] = {
  NSPAIR(_ZN10S10180C105C1Ev),
  NSPAIR(_ZN10S10180C105D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
static Base_Class bases_S10180C105[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C105[];
extern void _ZN10S10180C105D1Ev();
extern void _ZN10S10180C105D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN10S10180C1054v230Ev();
extern void _ZN10S10180C1054v231Ev();
extern void _ZN10S10180C1054v232Ev();
static  VTBL_ENTRY vtc_S10180C105[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C105[0]),
  (VTBL_ENTRY)&_ZN10S10180C105D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C105D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN10S10180C1054v230Ev,
  (VTBL_ENTRY)&_ZN10S10180C1054v231Ev,
  (VTBL_ENTRY)&_ZN10S10180C1054v232Ev,
};
extern VTBL_ENTRY _ZTI10S10180C105[];
extern  VTBL_ENTRY _ZTV10S10180C105[];
Class_Descriptor cd_S10180C105 = {  "S10180C105", // class name
  bases_S10180C105, 2,
  &(vtc_S10180C105[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,176), // object size
  NSPAIRA(_ZTI10S10180C105),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C105),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C106  : S10180C69 {
  virtual void  v233(); // _ZN10S10180C1064v233Ev
  ~S10180C106(); // tgen
  S10180C106(); // tgen
};
//SIG(-1 S10180C106) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v2 v3 v4 v5 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1}


void  S10180C106 ::v233(){vfunc_called(this, "_ZN10S10180C1064v233Ev");}
S10180C106 ::~S10180C106(){ note_dtor("S10180C106", this);} // tgen
S10180C106 ::S10180C106(){ note_ctor("S10180C106", this);} // tgen

static void Test_S10180C106()
{
  extern Class_Descriptor cd_S10180C106;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10180C106, buf);
    S10180C106 *dp, &lv = *(dp=new (buf) S10180C106());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10180C106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C106)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*), 0, "S10180C106");
    check_base_class_offset(lv, (S10180C69*), 0, "S10180C106");
    test_class_info(&lv, &cd_S10180C106);
    dp->~S10180C106();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C106(Test_S10180C106, "S10180C106", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN10S10180C106C1Ev();
extern void _ZN10S10180C106D1Ev();
Name_Map name_map_S10180C106[] = {
  NSPAIR(_ZN10S10180C106C1Ev),
  NSPAIR(_ZN10S10180C106D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
static Base_Class bases_S10180C106[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C106[];
extern void _ZN10S10180C106D1Ev();
extern void _ZN10S10180C106D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN10S10180C1064v233Ev();
static  VTBL_ENTRY vtc_S10180C106[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C106[0]),
  (VTBL_ENTRY)&_ZN10S10180C106D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C106D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN10S10180C1064v233Ev,
};
extern VTBL_ENTRY _ZTI10S10180C106[];
extern  VTBL_ENTRY _ZTV10S10180C106[];
Class_Descriptor cd_S10180C106 = {  "S10180C106", // class name
  bases_S10180C106, 2,
  &(vtc_S10180C106[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI10S10180C106),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C106),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C110  {
  void *s10180c110f0;
  ::S10180C73 s10180c110f1;
  ::S10180C73 s10180c110f2;
  int s10180c110f3[3];
  char s10180c110f4[2];
  int s10180c110f5;
  void *s10180c110f6;
  void  mf10180c110(); // _ZN10S10180C11011mf10180c110Ev
};
//SIG(-1 S10180C110) C1{ m Fp FC2{ m FC3{ m FL[2]}} FC2 Fi[3] Fc[2] Fi Fp}


void  S10180C110 ::mf10180c110(){}

static void Test_S10180C110()
{
  {
    init_simple_test("S10180C110");
    S10180C110 lv;
    check2(sizeof(lv), ABISELECT(72,60), "sizeof(S10180C110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C110)");
    check_field_offset(lv, s10180c110f0, 0, "S10180C110.s10180c110f0");
    check_field_offset(lv, s10180c110f1, ABISELECT(8,4), "S10180C110.s10180c110f1");
    check_field_offset(lv, s10180c110f2, ABISELECT(24,20), "S10180C110.s10180c110f2");
    check_field_offset(lv, s10180c110f3, ABISELECT(40,36), "S10180C110.s10180c110f3");
    check_field_offset(lv, s10180c110f4, ABISELECT(52,48), "S10180C110.s10180c110f4");
    check_field_offset(lv, s10180c110f5, ABISELECT(56,52), "S10180C110.s10180c110f5");
    check_field_offset(lv, s10180c110f6, ABISELECT(64,56), "S10180C110.s10180c110f6");
  }
}
static Arrange_To_Call_Me vS10180C110(Test_S10180C110, "S10180C110", ABISELECT(72,60));

#else // __cplusplus

Class_Descriptor cd_S10180C110 = {  "S10180C110", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(72,60), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C111  {
  void *s10180c111f0;
  void  mf10180c111(); // _ZN10S10180C11111mf10180c111Ev
};
//SIG(-1 S10180C111) C1{ m Fp}


void  S10180C111 ::mf10180c111(){}

static void Test_S10180C111()
{
  {
    init_simple_test("S10180C111");
    S10180C111 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C111)");
    check_field_offset(lv, s10180c111f0, 0, "S10180C111.s10180c111f0");
  }
}
static Arrange_To_Call_Me vS10180C111(Test_S10180C111, "S10180C111", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C109  : S10180C110 {
  ::S10180C61 s10180c109f0;
  ::S10180C111 s10180c109f1;
  ::S10180C61 s10180c109f2;
  ::S10180C13 s10180c109f3;
  ::S10180C13 s10180c109f4;
  ::S10180C61 s10180c109f5;
  ::S10180C111 s10180c109f6;
  ::S10180C61 s10180c109f7;
  ::S10180C13 s10180c109f8;
  ::S10180C13 s10180c109f9;
  ::S10180C13 s10180c109f10;
  char s10180c109f11;
  int s10180c109f12;
  void *s10180c109f13;
};
//SIG(-1 S10180C109) C1{ BC2{ m Fp FC3{ m FC4{ m FL[2]}} FC3 Fi[3] Fc[2] Fi Fp} FC5{ m Fp} FC6{ m Fp} FC5 FC7{ m Fp Fi FC8{ m}} FC7 FC5 FC6 FC5 FC7 FC7 FC7 Fc Fi Fp}



static void Test_S10180C109()
{
  extern Class_Descriptor cd_S10180C109;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,40)];
    init_test(&cd_S10180C109, buf);
    S10180C109 &lv = *(new (buf) S10180C109());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,156), "sizeof(S10180C109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C109)");
    check_base_class_offset(lv, (S10180C110*), 0, "S10180C109");
    check_field_offset(lv, s10180c109f0, ABISELECT(72,60), "S10180C109.s10180c109f0");
    check_field_offset(lv, s10180c109f1, ABISELECT(80,64), "S10180C109.s10180c109f1");
    check_field_offset(lv, s10180c109f2, ABISELECT(88,68), "S10180C109.s10180c109f2");
    check_field_offset(lv, s10180c109f3, ABISELECT(96,72), "S10180C109.s10180c109f3");
    check_field_offset(lv, s10180c109f4, ABISELECT(112,84), "S10180C109.s10180c109f4");
    check_field_offset(lv, s10180c109f5, ABISELECT(128,96), "S10180C109.s10180c109f5");
    check_field_offset(lv, s10180c109f6, ABISELECT(136,100), "S10180C109.s10180c109f6");
    check_field_offset(lv, s10180c109f7, ABISELECT(144,104), "S10180C109.s10180c109f7");
    check_field_offset(lv, s10180c109f8, ABISELECT(152,108), "S10180C109.s10180c109f8");
    check_field_offset(lv, s10180c109f9, ABISELECT(168,120), "S10180C109.s10180c109f9");
    check_field_offset(lv, s10180c109f10, ABISELECT(184,132), "S10180C109.s10180c109f10");
    check_field_offset(lv, s10180c109f11, ABISELECT(200,144), "S10180C109.s10180c109f11");
    check_field_offset(lv, s10180c109f12, ABISELECT(204,148), "S10180C109.s10180c109f12");
    check_field_offset(lv, s10180c109f13, ABISELECT(208,152), "S10180C109.s10180c109f13");
    test_class_info(&lv, &cd_S10180C109);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C109(Test_S10180C109, "S10180C109", ABISELECT(216,156));

#else // __cplusplus

extern Class_Descriptor cd_S10180C110;
static Base_Class bases_S10180C109[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10180C109 = {  "S10180C109", // class name
  bases_S10180C109, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(216,156), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C108  : S10180C109 {
  ::S10180C13 s10180c108f0;
};
//SIG(-1 S10180C108) C1{ BC2{ BC3{ m Fp FC4{ m FC5{ m FL[2]}} FC4 Fi[3] Fc[2] Fi Fp} FC6{ m Fp} FC7{ m Fp} FC6 FC8{ m Fp Fi FC9{ m}} FC8 FC6 FC7 FC6 FC8 FC8 FC8 Fc Fi Fp} FC8}



static void Test_S10180C108()
{
  extern Class_Descriptor cd_S10180C108;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,43)];
    init_test(&cd_S10180C108, buf);
    S10180C108 &lv = *(new (buf) S10180C108());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,168), "sizeof(S10180C108)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C108)");
    check_base_class_offset(lv, (S10180C110*)(S10180C109*), 0, "S10180C108");
    check_base_class_offset(lv, (S10180C109*), 0, "S10180C108");
    check_field_offset(lv, s10180c108f0, ABISELECT(216,156), "S10180C108.s10180c108f0");
    test_class_info(&lv, &cd_S10180C108);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C108(Test_S10180C108, "S10180C108", ABISELECT(232,168));

#else // __cplusplus

extern Class_Descriptor cd_S10180C110;
extern Class_Descriptor cd_S10180C109;
static Base_Class bases_S10180C108[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C109,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S10180C108 = {  "S10180C108", // class name
  bases_S10180C108, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(232,168), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C107  : S10180C17 {
  ::S10180C108 s10180c107f0;
  int s10180c107f1;
  virtual  ~S10180C107(); // _ZN10S10180C107D1Ev
  virtual void  v234(); // _ZN10S10180C1074v234Ev
  virtual void  v235(); // _ZN10S10180C1074v235Ev
  S10180C107(); // tgen
};
//SIG(-1 S10180C107) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 FC6{ BC7{ BC8{ m Fp FC9{ m FC10{ m FL[2]}} FC9 Fi[3] Fc[2] Fi Fp} FC11{ m Fp} FC12{ m Fp} FC11 FC13{ m Fp Fi FC4} FC13 FC11 FC12 FC11 FC13 FC13 FC13 Fc Fi Fp} FC13} Fi}


 S10180C107 ::~S10180C107(){ note_dtor("S10180C107", this);}
void  S10180C107 ::v234(){vfunc_called(this, "_ZN10S10180C1074v234Ev");}
void  S10180C107 ::v235(){vfunc_called(this, "_ZN10S10180C1074v235Ev");}
S10180C107 ::S10180C107(){ note_ctor("S10180C107", this);} // tgen

static void Test_S10180C107()
{
  extern Class_Descriptor cd_S10180C107;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,52)];
    init_test(&cd_S10180C107, buf);
    S10180C107 *dp, &lv = *(dp=new (buf) S10180C107());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,204), "sizeof(S10180C107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C107)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C107");
    check_field_offset(lv, s10180c107f0, ABISELECT(48,32), "S10180C107.s10180c107f0");
    check_field_offset(lv, s10180c107f1, ABISELECT(280,200), "S10180C107.s10180c107f1");
    test_class_info(&lv, &cd_S10180C107);
    dp->~S10180C107();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C107(Test_S10180C107, "S10180C107", ABISELECT(288,204));

#else // __cplusplus

extern void _ZN10S10180C107C1Ev();
extern void _ZN10S10180C107D1Ev();
Name_Map name_map_S10180C107[] = {
  NSPAIR(_ZN10S10180C107C1Ev),
  NSPAIR(_ZN10S10180C107D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C107[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C107[];
extern void _ZN10S10180C107D1Ev();
extern void _ZN10S10180C107D0Ev();
extern void _ZN10S10180C1074v234Ev();
extern void _ZN10S10180C1074v235Ev();
static  VTBL_ENTRY vtc_S10180C107[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C107[0]),
  (VTBL_ENTRY)&_ZN10S10180C107D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C107D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1074v234Ev,
  (VTBL_ENTRY)&_ZN10S10180C1074v235Ev,
};
extern VTBL_ENTRY _ZTI10S10180C107[];
extern  VTBL_ENTRY _ZTV10S10180C107[];
Class_Descriptor cd_S10180C107 = {  "S10180C107", // class name
  bases_S10180C107, 1,
  &(vtc_S10180C107[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,204), // object size
  NSPAIRA(_ZTI10S10180C107),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C107),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C112  : S10180C106 {
  virtual void  v236(); // _ZN10S10180C1124v236Ev
  ~S10180C112(); // tgen
  S10180C112(); // tgen
};
//SIG(-1 S10180C112) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC5 Fc} vd v2 v3 v4 v5 FC8{ m Fp FC9{ m FC10{ m Fp Fi FC6} Fi} FC10 FC10 Fi[3] FC11{ m FC12{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC9 FC9 Fc} Fp Fc Fi} v6} v1}


void  S10180C112 ::v236(){vfunc_called(this, "_ZN10S10180C1124v236Ev");}
S10180C112 ::~S10180C112(){ note_dtor("S10180C112", this);} // tgen
S10180C112 ::S10180C112(){ note_ctor("S10180C112", this);} // tgen

static void Test_S10180C112()
{
  extern Class_Descriptor cd_S10180C112;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10180C112, buf);
    S10180C112 *dp, &lv = *(dp=new (buf) S10180C112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10180C112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C112)");
    check_base_class_offset(lv, (S10180C17*)(S10180C69*)(S10180C106*), 0, "S10180C112");
    check_base_class_offset(lv, (S10180C69*)(S10180C106*), 0, "S10180C112");
    check_base_class_offset(lv, (S10180C106*), 0, "S10180C112");
    test_class_info(&lv, &cd_S10180C112);
    dp->~S10180C112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C112(Test_S10180C112, "S10180C112", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN10S10180C112C1Ev();
extern void _ZN10S10180C112D1Ev();
Name_Map name_map_S10180C112[] = {
  NSPAIR(_ZN10S10180C112C1Ev),
  NSPAIR(_ZN10S10180C112D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C69;
extern VTBL_ENTRY _ZTI9S10180C69[];
extern  VTBL_ENTRY _ZTV9S10180C69[];
extern Class_Descriptor cd_S10180C106;
extern VTBL_ENTRY _ZTI10S10180C106[];
extern  VTBL_ENTRY _ZTV10S10180C106[];
static Base_Class bases_S10180C112[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10180C106,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C112[];
extern void _ZN10S10180C112D1Ev();
extern void _ZN10S10180C112D0Ev();
extern void _ZN9S10180C693v89Ev();
extern void _ZN9S10180C693v90Ev();
extern void _ZN9S10180C693v91Ev();
extern void _ZN9S10180C693v92Ev();
extern void _ZN10S10180C1064v233Ev();
extern void _ZN10S10180C1124v236Ev();
static  VTBL_ENTRY vtc_S10180C112[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C112[0]),
  (VTBL_ENTRY)&_ZN10S10180C112D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C112D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10180C693v92Ev,
  (VTBL_ENTRY)&_ZN10S10180C1064v233Ev,
  (VTBL_ENTRY)&_ZN10S10180C1124v236Ev,
};
extern VTBL_ENTRY _ZTI10S10180C112[];
extern  VTBL_ENTRY _ZTV10S10180C112[];
Class_Descriptor cd_S10180C112 = {  "S10180C112", // class name
  bases_S10180C112, 3,
  &(vtc_S10180C112[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI10S10180C112),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C112),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C104  : S10180C17 , S10180C11 , S10180C2 {
  int s10180c104f0[2];
  ::S10180C86 s10180c104f1;
  ::S10180C31 s10180c104f2;
  ::S10180C105 s10180c104f3;
  ::S10180C106 s10180c104f4;
  ::S10180C87 s10180c104f5;
  ::S10180C68 s10180c104f6;
  ::S10180C107 s10180c104f7;
  ::S10180C75 s10180c104f8;
  ::S10180C112 s10180c104f9;
  ::S10180C75 s10180c104f10;
  void *s10180c104f11;
  ::S10180C111 s10180c104f12;
  void *s10180c104f13[2];
  int s10180c104f14;
  char s10180c104f15[3];
  int s10180c104f16;
  __tsi64 s10180c104f17[2];
  virtual  ~S10180C104(); // _ZN10S10180C104D1Ev
  virtual void  v207(); // _ZN10S10180C1044v207Ev
  virtual void  v208(); // _ZN10S10180C1044v208Ev
  virtual void  v209(); // _ZN10S10180C1044v209Ev
  virtual void  v210(); // _ZN10S10180C1044v210Ev
  virtual void  v211(); // _ZN10S10180C1044v211Ev
  virtual void  v212(); // _ZN10S10180C1044v212Ev
  virtual void  v213(); // _ZN10S10180C1044v213Ev
  virtual void  v214(); // _ZN10S10180C1044v214Ev
  virtual void  v215(); // _ZN10S10180C1044v215Ev
  virtual void  v216(); // _ZN10S10180C1044v216Ev
  virtual void  v217(); // _ZN10S10180C1044v217Ev
  virtual void  v218(); // _ZN10S10180C1044v218Ev
  virtual void  v219(); // _ZN10S10180C1044v219Ev
  virtual void  v220(); // _ZN10S10180C1044v220Ev
  virtual void  v221(); // _ZN10S10180C1044v221Ev
  virtual void  v222(); // _ZN10S10180C1044v222Ev
  virtual void  v223(); // _ZN10S10180C1044v223Ev
  virtual void  v224(); // _ZN10S10180C1044v224Ev
  virtual void  v225(); // _ZN10S10180C1044v225Ev
  virtual void  v226(); // _ZN10S10180C1044v226Ev
  virtual void  v227(); // _ZN10S10180C1044v227Ev
  virtual void  v228(); // _ZN10S10180C1044v228Ev
  virtual void  v229(); // _ZN10S10180C1044v229Ev
  S10180C104(); // tgen
};
//SIG(-1 S10180C104) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v48} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi[2] FC11{ BC12{ BC2 vd v50 v51 v52 v53 FC13{ m Fp FC7 FC8 FC8 Fi[3] FC14{ m FC15{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v49} FC16{ m FC17{ m Fp Fi[2] FC5} Fp[2]} FC18{ BC12 v54 v55 v56 Fp[3]} FC19{ BC12 v57} FC20{ BC12 v58 v59} FC21{ BC12 v60 v61} FC22{ BC2 vd v62 v63 FC23{ BC24{ BC25{ m Fp FC14 FC14 Fi[3] Fc[2] Fi Fp} FC26{ m Fp} FC27{ m Fp} FC26 FC8 FC8 FC26 FC27 FC26 FC8 FC8 FC8 Fc Fi Fp} FC8} Fi} FC28{ BC12 v64} FC29{ BC19 v65} FC28 Fp FC27 Fp[2] Fi Fc[3] Fi FL[2]}


 S10180C104 ::~S10180C104(){ note_dtor("S10180C104", this);}
void  S10180C104 ::v207(){vfunc_called(this, "_ZN10S10180C1044v207Ev");}
void  S10180C104 ::v208(){vfunc_called(this, "_ZN10S10180C1044v208Ev");}
void  S10180C104 ::v209(){vfunc_called(this, "_ZN10S10180C1044v209Ev");}
void  S10180C104 ::v210(){vfunc_called(this, "_ZN10S10180C1044v210Ev");}
void  S10180C104 ::v211(){vfunc_called(this, "_ZN10S10180C1044v211Ev");}
void  S10180C104 ::v212(){vfunc_called(this, "_ZN10S10180C1044v212Ev");}
void  S10180C104 ::v213(){vfunc_called(this, "_ZN10S10180C1044v213Ev");}
void  S10180C104 ::v214(){vfunc_called(this, "_ZN10S10180C1044v214Ev");}
void  S10180C104 ::v215(){vfunc_called(this, "_ZN10S10180C1044v215Ev");}
void  S10180C104 ::v216(){vfunc_called(this, "_ZN10S10180C1044v216Ev");}
void  S10180C104 ::v217(){vfunc_called(this, "_ZN10S10180C1044v217Ev");}
void  S10180C104 ::v218(){vfunc_called(this, "_ZN10S10180C1044v218Ev");}
void  S10180C104 ::v219(){vfunc_called(this, "_ZN10S10180C1044v219Ev");}
void  S10180C104 ::v220(){vfunc_called(this, "_ZN10S10180C1044v220Ev");}
void  S10180C104 ::v221(){vfunc_called(this, "_ZN10S10180C1044v221Ev");}
void  S10180C104 ::v222(){vfunc_called(this, "_ZN10S10180C1044v222Ev");}
void  S10180C104 ::v223(){vfunc_called(this, "_ZN10S10180C1044v223Ev");}
void  S10180C104 ::v224(){vfunc_called(this, "_ZN10S10180C1044v224Ev");}
void  S10180C104 ::v225(){vfunc_called(this, "_ZN10S10180C1044v225Ev");}
void  S10180C104 ::v226(){vfunc_called(this, "_ZN10S10180C1044v226Ev");}
void  S10180C104 ::v227(){vfunc_called(this, "_ZN10S10180C1044v227Ev");}
void  S10180C104 ::v228(){vfunc_called(this, "_ZN10S10180C1044v228Ev");}
void  S10180C104 ::v229(){vfunc_called(this, "_ZN10S10180C1044v229Ev");}
S10180C104 ::S10180C104(){ note_ctor("S10180C104", this);} // tgen

static void Test_S10180C104()
{
  extern Class_Descriptor cd_S10180C104;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(305,427)];
    init_test(&cd_S10180C104, buf);
    S10180C104 *dp, &lv = *(dp=new (buf) S10180C104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2432,1704), "sizeof(S10180C104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C104)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C104");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C104");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(144,96), "S10180C104");
    check_field_offset(lv, s10180c104f0, ABISELECT(152,100), "S10180C104.s10180c104f0");
    check_field_offset(lv, s10180c104f1, ABISELECT(160,108), "S10180C104.s10180c104f1");
    check_field_offset(lv, s10180c104f2, ABISELECT(392,272), "S10180C104.s10180c104f2");
    check_field_offset(lv, s10180c104f3, ABISELECT(432,296), "S10180C104.s10180c104f3");
    check_field_offset(lv, s10180c104f4, ABISELECT(688,472), "S10180C104.s10180c104f4");
    check_field_offset(lv, s10180c104f5, ABISELECT(920,636), "S10180C104.s10180c104f5");
    check_field_offset(lv, s10180c104f6, ABISELECT(1152,800), "S10180C104.s10180c104f6");
    check_field_offset(lv, s10180c104f7, ABISELECT(1384,964), "S10180C104.s10180c104f7");
    check_field_offset(lv, s10180c104f8, ABISELECT(1672,1168), "S10180C104.s10180c104f8");
    check_field_offset(lv, s10180c104f9, ABISELECT(1904,1332), "S10180C104.s10180c104f9");
    check_field_offset(lv, s10180c104f10, ABISELECT(2136,1496), "S10180C104.s10180c104f10");
    check_field_offset(lv, s10180c104f11, ABISELECT(2368,1660), "S10180C104.s10180c104f11");
    check_field_offset(lv, s10180c104f12, ABISELECT(2376,1664), "S10180C104.s10180c104f12");
    check_field_offset(lv, s10180c104f13, ABISELECT(2384,1668), "S10180C104.s10180c104f13");
    check_field_offset(lv, s10180c104f14, ABISELECT(2400,1676), "S10180C104.s10180c104f14");
    check_field_offset(lv, s10180c104f15, ABISELECT(2404,1680), "S10180C104.s10180c104f15");
    check_field_offset(lv, s10180c104f16, ABISELECT(2408,1684), "S10180C104.s10180c104f16");
    check_field_offset(lv, s10180c104f17, ABISELECT(2416,1688), "S10180C104.s10180c104f17");
    test_class_info(&lv, &cd_S10180C104);
    dp->~S10180C104();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C104(Test_S10180C104, "S10180C104", ABISELECT(2432,1704));

#else // __cplusplus

extern void _ZN10S10180C104C1Ev();
extern void _ZN10S10180C104D1Ev();
Name_Map name_map_S10180C104[] = {
  NSPAIR(_ZN10S10180C104C1Ev),
  NSPAIR(_ZN10S10180C104D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
static Base_Class bases_S10180C104[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C104[];
extern void _ZN10S10180C104D1Ev();
extern void _ZN10S10180C104D0Ev();
extern void _ZN10S10180C1044v207Ev();
extern void _ZN10S10180C1044v208Ev();
extern void _ZN10S10180C1044v209Ev();
extern void _ZN10S10180C1044v210Ev();
extern void _ZN10S10180C1044v211Ev();
extern void _ZN10S10180C1044v212Ev();
extern void _ZN10S10180C1044v213Ev();
extern void _ZN10S10180C1044v214Ev();
extern void _ZN10S10180C1044v215Ev();
extern void _ZN10S10180C1044v216Ev();
extern void _ZN10S10180C1044v217Ev();
extern void _ZN10S10180C1044v218Ev();
extern void _ZN10S10180C1044v219Ev();
extern void _ZN10S10180C1044v220Ev();
extern void _ZN10S10180C1044v221Ev();
extern void _ZN10S10180C1044v222Ev();
extern void _ZN10S10180C1044v223Ev();
extern void _ZN10S10180C1044v224Ev();
extern void _ZN10S10180C1044v225Ev();
extern void _ZN10S10180C1044v226Ev();
extern void _ZN10S10180C1044v227Ev();
extern void _ZN10S10180C1044v228Ev();
extern void _ZN10S10180C1044v229Ev();
extern void ABISELECT(_ZThn48_N10S10180C104D1Ev,_ZThn32_N10S10180C104D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C104D0Ev,_ZThn32_N10S10180C104D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10180C104D1Ev,_ZThn96_N10S10180C104D1Ev)();
extern void ABISELECT(_ZThn144_N10S10180C104D0Ev,_ZThn96_N10S10180C104D0Ev)();
extern void _ZN8S10180C22v7Ev();
static  VTBL_ENTRY vtc_S10180C104[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C104[0]),
  (VTBL_ENTRY)&_ZN10S10180C104D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C104D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v207Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v208Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v209Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v210Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v211Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v212Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v213Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v214Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v215Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v216Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v217Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v218Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v219Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v220Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v221Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v222Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v223Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v224Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v225Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v226Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v227Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v228Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v229Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C104[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C104D1Ev,_ZThn32_N10S10180C104D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C104D0Ev,_ZThn32_N10S10180C104D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10180C104[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C104D1Ev,_ZThn96_N10S10180C104D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C104D0Ev,_ZThn96_N10S10180C104D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
};
extern VTBL_ENTRY _ZTI10S10180C104[];
extern  VTBL_ENTRY _ZTV10S10180C104[];
Class_Descriptor cd_S10180C104 = {  "S10180C104", // class name
  bases_S10180C104, 3,
  &(vtc_S10180C104[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2432,1704), // object size
  NSPAIRA(_ZTI10S10180C104),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV10S10180C104),60, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C114  {
  void *s10180c114f0;
  void  mf10180c114(); // _ZN10S10180C11411mf10180c114Ev
};
//SIG(-1 S10180C114) C1{ m Fp}


void  S10180C114 ::mf10180c114(){}

static void Test_S10180C114()
{
  {
    init_simple_test("S10180C114");
    S10180C114 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C114)");
    check_field_offset(lv, s10180c114f0, 0, "S10180C114.s10180c114f0");
  }
}
static Arrange_To_Call_Me vS10180C114(Test_S10180C114, "S10180C114", ABISELECT(8,4));

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S10180C114[];
VTBL_ENTRY *P__ZTI10S10180C114 = _ZTI10S10180C114; 
Class_Descriptor cd_S10180C114 = {  "S10180C114", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S10180C114),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C118  {
  int s10180c118f0[2];
  void  mf10180c118(); // _ZN10S10180C11811mf10180c118Ev
};
//SIG(-1 S10180C118) C1{ m Fi[2]}


void  S10180C118 ::mf10180c118(){}

static void Test_S10180C118()
{
  {
    init_simple_test("S10180C118");
    S10180C118 lv;
    check2(sizeof(lv), 8, "sizeof(S10180C118)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C118)");
    check_field_offset(lv, s10180c118f0, 0, "S10180C118.s10180c118f0");
  }
}
static Arrange_To_Call_Me vS10180C118(Test_S10180C118, "S10180C118", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C117  {
  ::S10180C118 s10180c117f0;
  ::S10180C118 s10180c117f1;
  void  mf10180c117(); // _ZN10S10180C11711mf10180c117Ev
};
//SIG(-1 S10180C117) C1{ m FC2{ m Fi[2]} FC2}


void  S10180C117 ::mf10180c117(){}

static void Test_S10180C117()
{
  {
    init_simple_test("S10180C117");
    S10180C117 lv;
    check2(sizeof(lv), 16, "sizeof(S10180C117)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C117)");
    check_field_offset(lv, s10180c117f0, 0, "S10180C117.s10180c117f0");
    check_field_offset(lv, s10180c117f1, 8, "S10180C117.s10180c117f1");
  }
}
static Arrange_To_Call_Me vS10180C117(Test_S10180C117, "S10180C117", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C116  {
  void *s10180c116f0[2];
  int s10180c116f1[2];
  void *s10180c116f2;
  __tsi64 s10180c116f3;
  void *s10180c116f4[9];
  short s10180c116f5;
  void *s10180c116f6[2];
  ::S10180C117 s10180c116f7;
  ::S10180C118 s10180c116f8;
  char s10180c116f9;
  int s10180c116f10[3];
  char s10180c116f11;
  int s10180c116f12[6];
  char s10180c116f13;
  void  mf10180c116(); // _ZN10S10180C11611mf10180c116Ev
};
//SIG(-1 S10180C116) C1{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC2{ m FC3{ m Fi[2]} FC3} FC3 Fc Fi[3] Fc Fi[6] Fc}


void  S10180C116 ::mf10180c116(){}

static void Test_S10180C116()
{
  {
    init_simple_test("S10180C116");
    S10180C116 lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S10180C116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C116)");
    check_field_offset(lv, s10180c116f0, 0, "S10180C116.s10180c116f0");
    check_field_offset(lv, s10180c116f1, ABISELECT(16,8), "S10180C116.s10180c116f1");
    check_field_offset(lv, s10180c116f2, ABISELECT(24,16), "S10180C116.s10180c116f2");
    check_field_offset(lv, s10180c116f3, ABISELECT(32,20), "S10180C116.s10180c116f3");
    check_field_offset(lv, s10180c116f4, ABISELECT(40,28), "S10180C116.s10180c116f4");
    check_field_offset(lv, s10180c116f5, ABISELECT(112,64), "S10180C116.s10180c116f5");
    check_field_offset(lv, s10180c116f6, ABISELECT(120,68), "S10180C116.s10180c116f6");
    check_field_offset(lv, s10180c116f7, ABISELECT(136,76), "S10180C116.s10180c116f7");
    check_field_offset(lv, s10180c116f8, ABISELECT(152,92), "S10180C116.s10180c116f8");
    check_field_offset(lv, s10180c116f9, ABISELECT(160,100), "S10180C116.s10180c116f9");
    check_field_offset(lv, s10180c116f10, ABISELECT(164,104), "S10180C116.s10180c116f10");
    check_field_offset(lv, s10180c116f11, ABISELECT(176,116), "S10180C116.s10180c116f11");
    check_field_offset(lv, s10180c116f12, ABISELECT(180,120), "S10180C116.s10180c116f12");
    check_field_offset(lv, s10180c116f13, ABISELECT(204,144), "S10180C116.s10180c116f13");
  }
}
static Arrange_To_Call_Me vS10180C116(Test_S10180C116, "S10180C116", ABISELECT(208,148));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C115  {
  void *s10180c115f0;
  ::S10180C111 s10180c115f1;
  void *s10180c115f2[5];
  ::S10180C116 s10180c115f3;
  void  mf10180c115(); // _ZN10S10180C11511mf10180c115Ev
};
//SIG(-1 S10180C115) C1{ m Fp FC2{ m Fp} Fp[5] FC3{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC4{ m FC5{ m Fi[2]} FC5} FC5 Fc Fi[3] Fc Fi[6] Fc}}


void  S10180C115 ::mf10180c115(){}

static void Test_S10180C115()
{
  {
    init_simple_test("S10180C115");
    S10180C115 lv;
    check2(sizeof(lv), ABISELECT(264,176), "sizeof(S10180C115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C115)");
    check_field_offset(lv, s10180c115f0, 0, "S10180C115.s10180c115f0");
    check_field_offset(lv, s10180c115f1, ABISELECT(8,4), "S10180C115.s10180c115f1");
    check_field_offset(lv, s10180c115f2, ABISELECT(16,8), "S10180C115.s10180c115f2");
    check_field_offset(lv, s10180c115f3, ABISELECT(56,28), "S10180C115.s10180c115f3");
  }
}
static Arrange_To_Call_Me vS10180C115(Test_S10180C115, "S10180C115", ABISELECT(264,176));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C103  : S10180C104 {
  ::S10180C114 s10180c103f0;
  ::S10180C115 s10180c103f1;
  int s10180c103f2;
  virtual  ~S10180C103(); // _ZN10S10180C103D1Ev
  virtual void  v201(); // _ZN10S10180C1034v201Ev
  virtual void  v202(); // _ZN10S10180C1034v202Ev
  virtual void  v203(); // _ZN10S10180C1034v203Ev
  virtual void  v204(); // _ZN10S10180C1034v204Ev
  virtual void  v205(); // _ZN10S10180C1034v205Ev
  virtual void  v206(); // _ZN10S10180C1034v206Ev
  S10180C103(); // tgen
};
//SIG(-1 S10180C103) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} BC7{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC11{ vd v31} vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fi[2] FC12{ BC13{ BC3 vd v56 v57 v58 v59 FC14{ m Fp FC8 FC9 FC9 Fi[3] FC15{ m FC16{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v55} FC17{ m FC18{ m Fp Fi[2] FC6} Fp[2]} FC19{ BC13 v60 v61 v62 Fp[3]} FC20{ BC13 v63} FC21{ BC13 v64 v65} FC22{ BC13 v66 v67} FC23{ BC3 vd v68 v69 FC24{ BC25{ BC26{ m Fp FC15 FC15 Fi[3] Fc[2] Fi Fp} FC27{ m Fp} FC28{ m Fp} FC27 FC9 FC9 FC27 FC28 FC27 FC9 FC9 FC9 Fc Fi Fp} FC9} Fi} FC29{ BC13 v70} FC30{ BC20 v71} FC29 Fp FC28 Fp[2] Fi Fc[3] Fi FL[2]} vd v1 v2 v3 v4 v5 v6 FC31{ m Fp} FC32{ m Fp FC28 Fp[5] FC33{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC34{ m FC35{ m Fi[2]} FC35} FC35 Fc Fi[3] Fc Fi[6] Fc}} Fi}


 S10180C103 ::~S10180C103(){ note_dtor("S10180C103", this);}
void  S10180C103 ::v201(){vfunc_called(this, "_ZN10S10180C1034v201Ev");}
void  S10180C103 ::v202(){vfunc_called(this, "_ZN10S10180C1034v202Ev");}
void  S10180C103 ::v203(){vfunc_called(this, "_ZN10S10180C1034v203Ev");}
void  S10180C103 ::v204(){vfunc_called(this, "_ZN10S10180C1034v204Ev");}
void  S10180C103 ::v205(){vfunc_called(this, "_ZN10S10180C1034v205Ev");}
void  S10180C103 ::v206(){vfunc_called(this, "_ZN10S10180C1034v206Ev");}
S10180C103 ::S10180C103(){ note_ctor("S10180C103", this);} // tgen

static void Test_S10180C103()
{
  extern Class_Descriptor cd_S10180C103;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(340,473)];
    init_test(&cd_S10180C103, buf);
    S10180C103 *dp, &lv = *(dp=new (buf) S10180C103());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2712,1888), "sizeof(S10180C103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C103)");
    check_base_class_offset(lv, (S10180C17*)(S10180C104*), 0, "S10180C103");
    check_base_class_offset(lv, (S10180C11*)(S10180C104*), ABISELECT(48,32), "S10180C103");
    check_base_class_offset(lv, (S10180C2*)(S10180C104*), ABISELECT(144,96), "S10180C103");
    check_base_class_offset(lv, (S10180C104*), 0, "S10180C103");
    check_field_offset(lv, s10180c103f0, ABISELECT(2432,1704), "S10180C103.s10180c103f0");
    check_field_offset(lv, s10180c103f1, ABISELECT(2440,1708), "S10180C103.s10180c103f1");
    check_field_offset(lv, s10180c103f2, ABISELECT(2704,1884), "S10180C103.s10180c103f2");
    test_class_info(&lv, &cd_S10180C103);
    dp->~S10180C103();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C103(Test_S10180C103, "S10180C103", ABISELECT(2712,1888));

#else // __cplusplus

extern void _ZN10S10180C103C1Ev();
extern void _ZN10S10180C103D1Ev();
Name_Map name_map_S10180C103[] = {
  NSPAIR(_ZN10S10180C103C1Ev),
  NSPAIR(_ZN10S10180C103D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C104;
extern VTBL_ENTRY _ZTI10S10180C104[];
extern  VTBL_ENTRY _ZTV10S10180C104[];
static Base_Class bases_S10180C103[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    61, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S10180C104,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C103[];
extern void _ZN10S10180C103D1Ev();
extern void _ZN10S10180C103D0Ev();
extern void _ZN10S10180C1044v207Ev();
extern void _ZN10S10180C1044v208Ev();
extern void _ZN10S10180C1044v209Ev();
extern void _ZN10S10180C1044v210Ev();
extern void _ZN10S10180C1044v211Ev();
extern void _ZN10S10180C1044v212Ev();
extern void _ZN10S10180C1044v213Ev();
extern void _ZN10S10180C1044v214Ev();
extern void _ZN10S10180C1044v215Ev();
extern void _ZN10S10180C1044v216Ev();
extern void _ZN10S10180C1044v217Ev();
extern void _ZN10S10180C1044v218Ev();
extern void _ZN10S10180C1044v219Ev();
extern void _ZN10S10180C1044v220Ev();
extern void _ZN10S10180C1044v221Ev();
extern void _ZN10S10180C1044v222Ev();
extern void _ZN10S10180C1044v223Ev();
extern void _ZN10S10180C1044v224Ev();
extern void _ZN10S10180C1044v225Ev();
extern void _ZN10S10180C1044v226Ev();
extern void _ZN10S10180C1044v227Ev();
extern void _ZN10S10180C1044v228Ev();
extern void _ZN10S10180C1044v229Ev();
extern void _ZN10S10180C1034v201Ev();
extern void _ZN10S10180C1034v202Ev();
extern void _ZN10S10180C1034v203Ev();
extern void _ZN10S10180C1034v204Ev();
extern void _ZN10S10180C1034v205Ev();
extern void _ZN10S10180C1034v206Ev();
extern void ABISELECT(_ZThn48_N10S10180C103D1Ev,_ZThn32_N10S10180C103D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C103D0Ev,_ZThn32_N10S10180C103D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10180C103D1Ev,_ZThn96_N10S10180C103D1Ev)();
extern void ABISELECT(_ZThn144_N10S10180C103D0Ev,_ZThn96_N10S10180C103D0Ev)();
extern void _ZN8S10180C22v7Ev();
static  VTBL_ENTRY vtc_S10180C103[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C103[0]),
  (VTBL_ENTRY)&_ZN10S10180C103D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C103D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v207Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v208Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v209Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v210Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v211Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v212Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v213Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v214Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v215Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v216Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v217Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v218Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v219Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v220Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v221Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v222Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v223Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v224Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v225Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v226Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v227Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v228Ev,
  (VTBL_ENTRY)&_ZN10S10180C1044v229Ev,
  (VTBL_ENTRY)&_ZN10S10180C1034v201Ev,
  (VTBL_ENTRY)&_ZN10S10180C1034v202Ev,
  (VTBL_ENTRY)&_ZN10S10180C1034v203Ev,
  (VTBL_ENTRY)&_ZN10S10180C1034v204Ev,
  (VTBL_ENTRY)&_ZN10S10180C1034v205Ev,
  (VTBL_ENTRY)&_ZN10S10180C1034v206Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C103[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C103D1Ev,_ZThn32_N10S10180C103D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C103D0Ev,_ZThn32_N10S10180C103D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10180C103[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C103D1Ev,_ZThn96_N10S10180C103D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C103D0Ev,_ZThn96_N10S10180C103D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
};
extern VTBL_ENTRY _ZTI10S10180C103[];
extern  VTBL_ENTRY _ZTV10S10180C103[];
Class_Descriptor cd_S10180C103 = {  "S10180C103", // class name
  bases_S10180C103, 4,
  &(vtc_S10180C103[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2712,1888), // object size
  NSPAIRA(_ZTI10S10180C103),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C103),66, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C120  {
  char s10180c120f0[5];
  void  mf10180c120(); // _ZN10S10180C12011mf10180c120Ev
};
//SIG(-1 S10180C120) C1{ m Fc[5]}


void  S10180C120 ::mf10180c120(){}

static void Test_S10180C120()
{
  {
    init_simple_test("S10180C120");
    S10180C120 lv;
    check2(sizeof(lv), 5, "sizeof(S10180C120)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C120)");
    check_field_offset(lv, s10180c120f0, 0, "S10180C120.s10180c120f0");
  }
}
static Arrange_To_Call_Me vS10180C120(Test_S10180C120, "S10180C120", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C121  {
  ::S10180C73 s10180c121f0;
  ::S10180C73 s10180c121f1;
  ::S10180C73 s10180c121f2;
  ::S10180C61 s10180c121f3;
  int s10180c121f4;
  char s10180c121f5[2];
  int s10180c121f6;
  void  mf10180c121(); // _ZN10S10180C12111mf10180c121Ev
};
//SIG(-1 S10180C121) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC4{ m Fp} Fi Fc[2] Fi}


void  S10180C121 ::mf10180c121(){}

static void Test_S10180C121()
{
  {
    init_simple_test("S10180C121");
    S10180C121 lv;
    check2(sizeof(lv), ABISELECT(72,64), "sizeof(S10180C121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C121)");
    check_field_offset(lv, s10180c121f0, 0, "S10180C121.s10180c121f0");
    check_field_offset(lv, s10180c121f1, 16, "S10180C121.s10180c121f1");
    check_field_offset(lv, s10180c121f2, 32, "S10180C121.s10180c121f2");
    check_field_offset(lv, s10180c121f3, 48, "S10180C121.s10180c121f3");
    check_field_offset(lv, s10180c121f4, ABISELECT(56,52), "S10180C121.s10180c121f4");
    check_field_offset(lv, s10180c121f5, ABISELECT(60,56), "S10180C121.s10180c121f5");
    check_field_offset(lv, s10180c121f6, ABISELECT(64,60), "S10180C121.s10180c121f6");
  }
}
static Arrange_To_Call_Me vS10180C121(Test_S10180C121, "S10180C121", ABISELECT(72,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C123  {
  void *s10180c123f0[3];
  ::S10180C59 s10180c123f1;
  ::S10180C13 s10180c123f2;
  __tsi64 s10180c123f3[2];
  char s10180c123f4;
  void  mf10180c123(); // _ZN10S10180C12311mf10180c123Ev
};
//SIG(-1 S10180C123) C1{ m Fp[3] FC2{ m Fi[2]} FC3{ m Fp Fi FC4{ m}} FL[2] Fc}


void  S10180C123 ::mf10180c123(){}

static void Test_S10180C123()
{
  {
    init_simple_test("S10180C123");
    S10180C123 lv;
    check2(sizeof(lv), ABISELECT(72,52), "sizeof(S10180C123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C123)");
    check_field_offset(lv, s10180c123f0, 0, "S10180C123.s10180c123f0");
    check_field_offset(lv, s10180c123f1, ABISELECT(24,12), "S10180C123.s10180c123f1");
    check_field_offset(lv, s10180c123f2, ABISELECT(32,20), "S10180C123.s10180c123f2");
    check_field_offset(lv, s10180c123f3, ABISELECT(48,32), "S10180C123.s10180c123f3");
    check_field_offset(lv, s10180c123f4, ABISELECT(64,48), "S10180C123.s10180c123f4");
  }
}
static Arrange_To_Call_Me vS10180C123(Test_S10180C123, "S10180C123", ABISELECT(72,52));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C122  : S10180C17 {
  ::S10180C123 s10180c122f0;
  ::S10180C31 s10180c122f1;
  virtual  ~S10180C122(); // _ZN10S10180C122D1Ev
  S10180C122(); // tgen
};
//SIG(-1 S10180C122) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd FC6{ m Fp[3] FC7{ m Fi[2]} FC8{ m Fp Fi FC4} FL[2] Fc} FC9{ m FC10{ m Fp Fi[2] FC5} Fp[2]}}


 S10180C122 ::~S10180C122(){ note_dtor("S10180C122", this);}
S10180C122 ::S10180C122(){ note_ctor("S10180C122", this);} // tgen

static void Test_S10180C122()
{
  extern Class_Descriptor cd_S10180C122;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,28)];
    init_test(&cd_S10180C122, buf);
    S10180C122 *dp, &lv = *(dp=new (buf) S10180C122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,108), "sizeof(S10180C122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C122)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C122");
    check_field_offset(lv, s10180c122f0, ABISELECT(48,32), "S10180C122.s10180c122f0");
    check_field_offset(lv, s10180c122f1, ABISELECT(120,84), "S10180C122.s10180c122f1");
    test_class_info(&lv, &cd_S10180C122);
    dp->~S10180C122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C122(Test_S10180C122, "S10180C122", ABISELECT(160,108));

#else // __cplusplus

extern void _ZN10S10180C122C1Ev();
extern void _ZN10S10180C122D1Ev();
Name_Map name_map_S10180C122[] = {
  NSPAIR(_ZN10S10180C122C1Ev),
  NSPAIR(_ZN10S10180C122D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C122[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C122[];
extern void _ZN10S10180C122D1Ev();
extern void _ZN10S10180C122D0Ev();
static  VTBL_ENTRY vtc_S10180C122[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C122[0]),
  (VTBL_ENTRY)&_ZN10S10180C122D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C122D0Ev,
};
extern VTBL_ENTRY _ZTI10S10180C122[];
extern  VTBL_ENTRY _ZTV10S10180C122[];
Class_Descriptor cd_S10180C122 = {  "S10180C122", // class name
  bases_S10180C122, 1,
  &(vtc_S10180C122[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,108), // object size
  NSPAIRA(_ZTI10S10180C122),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C122),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C124  {
  ::S10180C5 s10180c124f0;
  int s10180c124f1;
  void  mf10180c124(); // _ZN10S10180C12411mf10180c124Ev
};
//SIG(-1 S10180C124) C1{ m FC2{ BC3{ m Fp Fi FC4{ m} FC4}} Fi}


void  S10180C124 ::mf10180c124(){}

static void Test_S10180C124()
{
  {
    init_simple_test("S10180C124");
    S10180C124 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10180C124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C124)");
    check_field_offset(lv, s10180c124f0, 0, "S10180C124.s10180c124f0");
    check_field_offset(lv, s10180c124f1, ABISELECT(16,12), "S10180C124.s10180c124f1");
  }
}
static Arrange_To_Call_Me vS10180C124(Test_S10180C124, "S10180C124", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C79  : S10180C17 , S10180C11 , S10180C2 , S10180C80 , S10180C83 , S10180C26 {
  void *s10180c79f0[5];
  int s10180c79f1;
  void *s10180c79f2;
  ::S10180C59 s10180c79f3;
  ::S10180C61 s10180c79f4;
  ::S10180C86 s10180c79f5;
  ::S10180C68 s10180c79f6;
  ::S10180C75 s10180c79f7;
  ::S10180C87 s10180c79f8;
  ::S10180C88 s10180c79f9;
  ::S10180C91 s10180c79f10;
  ::S10180C94 s10180c79f11;
  ::S10180C99 s10180c79f12;
  ::S10180C100 s10180c79f13;
  ::S10180C103 s10180c79f14;
  void *s10180c79f15;
  ::S10180C31 s10180c79f16;
  char s10180c79f17[2];
  int s10180c79f18;
  ::S10180C120 s10180c79f19;
  ::S10180C121 s10180c79f20;
  ::S10180C73 s10180c79f21;
  ::S10180C73 s10180c79f22;
  ::S10180C73 s10180c79f23;
  void *s10180c79f24;
  ::S10180C122 s10180c79f25;
  char s10180c79f26[2];
  __tsi64 s10180c79f27;
  char s10180c79f28[2];
  int s10180c79f29;
  ::S10180C111 s10180c79f30;
  ::S10180C124 s10180c79f31;
  char s10180c79f32;
  int s10180c79f33;
  virtual  ~S10180C79(); // _ZN9S10180C79D1Ev
  virtual void  v116(); // _ZN9S10180C794v116Ev
  virtual void  v117(); // _ZN9S10180C794v117Ev
  virtual void  v118(); // _ZN9S10180C794v118Ev
  virtual void  v119(); // _ZN9S10180C794v119Ev
  virtual void  v120(); // _ZN9S10180C794v120Ev
  virtual void  v121(); // _ZN9S10180C794v121Ev
  virtual void  v122(); // _ZN9S10180C794v122Ev
  virtual void  v123(); // _ZN9S10180C794v123Ev
  virtual void  v124(); // _ZN9S10180C794v124Ev
  virtual void  v125(); // _ZN9S10180C794v125Ev
  virtual void  v126(); // _ZN9S10180C794v126Ev
  virtual void  v127(); // _ZN9S10180C794v127Ev
  virtual void  v128(); // _ZN9S10180C794v128Ev
  virtual void  v129(); // _ZN9S10180C794v129Ev
  virtual void  v130(); // _ZN9S10180C794v130Ev
  virtual void  v131(); // _ZN9S10180C794v131Ev
  virtual void  v132(); // _ZN9S10180C794v132Ev
  virtual void  v133(); // _ZN9S10180C794v133Ev
  virtual void  v134(); // _ZN9S10180C794v134Ev
  virtual void  v135(); // _ZN9S10180C794v135Ev
  virtual void  v136(); // _ZN9S10180C794v136Ev
  virtual void  v137(); // _ZN9S10180C794v137Ev
  virtual void  v138(); // _ZN9S10180C794v138Ev
  virtual void  v139(); // _ZN9S10180C794v139Ev
  virtual void  v140(); // _ZN9S10180C794v140Ev
  virtual void  v141(); // _ZN9S10180C794v141Ev
  virtual void  v142(); // _ZN9S10180C794v142Ev
  virtual void  v143(); // _ZN9S10180C794v143Ev
  virtual void  v144(); // _ZN9S10180C794v144Ev
  virtual void  v145(); // _ZN9S10180C794v145Ev
  virtual void  v146(); // _ZN9S10180C794v146Ev
  virtual void  v147(); // _ZN9S10180C794v147Ev
  virtual void  v148(); // _ZN9S10180C794v148Ev
  virtual void  v149(); // _ZN9S10180C794v149Ev
  S10180C79(); // tgen
};
//SIG(-1 S10180C79) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v59} BC11{ BC12{ vd v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74} BC13{ vd m Fp}} BC14{ vd v75 v76} BC15{ vd v77} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp[5] Fi Fp FC16{ m Fi[2]} FC17{ m Fp} FC18{ BC19{ BC2 vd v79 v80 v81 v82 FC20{ m Fp FC7 FC8 FC8 Fi[3] FC21{ m FC22{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v78} FC23{ BC19 v83 v84} FC24{ BC19 v85} FC25{ BC19 v86 v87} FC26{ BC19 v88 v89 v90 FC27{ Fp[3]} FC28{ Fi[4]}[3]} FC29{ BC2 BC6 vd v91 v92 v93 v94 v95 v96 v97 v98 FC30{ m FC8 Fi[2] FC8} Fi[2] Fc[2] Fi FL[2] FC31{ m FL} Fi} FC32{ BC33{ BC2 BC6 vd v104 v105 v106 v107 v108 v109} BC10 vd v99 v100 v101 v102 v103 FC34{ m Fi Fp Fi FC21} FC35{ m Fp Fi[2] FC5}} FC36{ BC2 BC6 vd v110 v111 v112 v113 FC37{ m FC35 Fp[2]} Fp[2] FC8 Fi} FC38{ BC2 BC6 BC10 BC11 BC14 BC15 vd v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 FC37 Fp[2] Fi[2] FC39{ BC2 vd v133 Fp FC7 FC7 Fp Fi FC21} FC23 FC25 FC25 FC21 FC21 FC21 Fi} FC40{ BC41{ BC2 BC6 BC10 vd v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 Fi[2] FC18 FC37 FC42{ BC19 v163 v164 v165 Fp[3]} FC43{ BC19 v166} FC25 FC23 FC44{ BC2 vd v167 v168 FC45{ BC46{ BC47{ m Fp FC21 FC21 Fi[3] Fc[2] Fi Fp} FC17 FC48{ m Fp} FC17 FC8 FC8 FC17 FC48 FC17 FC8 FC8 FC8 Fc Fi Fp} FC8} Fi} FC24 FC49{ BC43 v169} FC24 Fp FC48 Fp[2] Fi Fc[3] Fi FL[2]} vd v134 v135 v136 v137 v138 v139 FC50{ m Fp} FC51{ m Fp FC48 Fp[5] FC52{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC53{ m FC54{ m Fi[2]} FC54} FC54 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC37 Fc[2] Fi FC55{ m Fc[5]} FC56{ m FC21 FC21 FC21 FC17 Fi Fc[2] Fi} FC21 FC21 FC21 Fp FC57{ BC2 vd FC58{ m Fp[3] FC16 FC8 FL[2] Fc} FC37} Fc[2] FL Fc[2] Fi FC48 FC59{ m FC60{ BC61{ m Fp Fi FC62{ m} FC62}} Fi} Fc Fi}


 S10180C79 ::~S10180C79(){ note_dtor("S10180C79", this);}
void  S10180C79 ::v116(){vfunc_called(this, "_ZN9S10180C794v116Ev");}
void  S10180C79 ::v117(){vfunc_called(this, "_ZN9S10180C794v117Ev");}
void  S10180C79 ::v118(){vfunc_called(this, "_ZN9S10180C794v118Ev");}
void  S10180C79 ::v119(){vfunc_called(this, "_ZN9S10180C794v119Ev");}
void  S10180C79 ::v120(){vfunc_called(this, "_ZN9S10180C794v120Ev");}
void  S10180C79 ::v121(){vfunc_called(this, "_ZN9S10180C794v121Ev");}
void  S10180C79 ::v122(){vfunc_called(this, "_ZN9S10180C794v122Ev");}
void  S10180C79 ::v123(){vfunc_called(this, "_ZN9S10180C794v123Ev");}
void  S10180C79 ::v124(){vfunc_called(this, "_ZN9S10180C794v124Ev");}
void  S10180C79 ::v125(){vfunc_called(this, "_ZN9S10180C794v125Ev");}
void  S10180C79 ::v126(){vfunc_called(this, "_ZN9S10180C794v126Ev");}
void  S10180C79 ::v127(){vfunc_called(this, "_ZN9S10180C794v127Ev");}
void  S10180C79 ::v128(){vfunc_called(this, "_ZN9S10180C794v128Ev");}
void  S10180C79 ::v129(){vfunc_called(this, "_ZN9S10180C794v129Ev");}
void  S10180C79 ::v130(){vfunc_called(this, "_ZN9S10180C794v130Ev");}
void  S10180C79 ::v131(){vfunc_called(this, "_ZN9S10180C794v131Ev");}
void  S10180C79 ::v132(){vfunc_called(this, "_ZN9S10180C794v132Ev");}
void  S10180C79 ::v133(){vfunc_called(this, "_ZN9S10180C794v133Ev");}
void  S10180C79 ::v134(){vfunc_called(this, "_ZN9S10180C794v134Ev");}
void  S10180C79 ::v135(){vfunc_called(this, "_ZN9S10180C794v135Ev");}
void  S10180C79 ::v136(){vfunc_called(this, "_ZN9S10180C794v136Ev");}
void  S10180C79 ::v137(){vfunc_called(this, "_ZN9S10180C794v137Ev");}
void  S10180C79 ::v138(){vfunc_called(this, "_ZN9S10180C794v138Ev");}
void  S10180C79 ::v139(){vfunc_called(this, "_ZN9S10180C794v139Ev");}
void  S10180C79 ::v140(){vfunc_called(this, "_ZN9S10180C794v140Ev");}
void  S10180C79 ::v141(){vfunc_called(this, "_ZN9S10180C794v141Ev");}
void  S10180C79 ::v142(){vfunc_called(this, "_ZN9S10180C794v142Ev");}
void  S10180C79 ::v143(){vfunc_called(this, "_ZN9S10180C794v143Ev");}
void  S10180C79 ::v144(){vfunc_called(this, "_ZN9S10180C794v144Ev");}
void  S10180C79 ::v145(){vfunc_called(this, "_ZN9S10180C794v145Ev");}
void  S10180C79 ::v146(){vfunc_called(this, "_ZN9S10180C794v146Ev");}
void  S10180C79 ::v147(){vfunc_called(this, "_ZN9S10180C794v147Ev");}
void  S10180C79 ::v148(){vfunc_called(this, "_ZN9S10180C794v148Ev");}
void  S10180C79 ::v149(){vfunc_called(this, "_ZN9S10180C794v149Ev");}
S10180C79 ::S10180C79(){ note_ctor("S10180C79", this);} // tgen

static void Test_S10180C79()
{
  extern Class_Descriptor cd_S10180C79;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(806,1126)];
    init_test(&cd_S10180C79, buf);
    S10180C79 *dp, &lv = *(dp=new (buf) S10180C79());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6440,4500), "sizeof(S10180C79)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C79)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C79");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C79");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(144,96), "S10180C79");
    check_base_class_offset(lv, (S10180C81*)(S10180C80*), ABISELECT(152,100), "S10180C79");
    check_base_class_offset(lv, (S10180C82*)(S10180C80*), ABISELECT(160,104), "S10180C79");
    check_base_class_offset(lv, (S10180C80*), ABISELECT(152,100), "S10180C79");
    check_base_class_offset(lv, (S10180C83*), ABISELECT(176,112), "S10180C79");
    check_base_class_offset(lv, (S10180C26*), ABISELECT(184,116), "S10180C79");
    check_field_offset(lv, s10180c79f0, ABISELECT(192,120), "S10180C79.s10180c79f0");
    check_field_offset(lv, s10180c79f1, ABISELECT(232,140), "S10180C79.s10180c79f1");
    check_field_offset(lv, s10180c79f2, ABISELECT(240,144), "S10180C79.s10180c79f2");
    check_field_offset(lv, s10180c79f3, ABISELECT(248,148), "S10180C79.s10180c79f3");
    check_field_offset(lv, s10180c79f4, ABISELECT(256,156), "S10180C79.s10180c79f4");
    check_field_offset(lv, s10180c79f5, ABISELECT(264,160), "S10180C79.s10180c79f5");
    check_field_offset(lv, s10180c79f6, ABISELECT(496,324), "S10180C79.s10180c79f6");
    check_field_offset(lv, s10180c79f7, ABISELECT(728,488), "S10180C79.s10180c79f7");
    check_field_offset(lv, s10180c79f8, ABISELECT(960,652), "S10180C79.s10180c79f8");
    check_field_offset(lv, s10180c79f9, ABISELECT(1192,816), "S10180C79.s10180c79f9");
    check_field_offset(lv, s10180c79f10, ABISELECT(1496,1040), "S10180C79.s10180c79f10");
    check_field_offset(lv, s10180c79f11, ABISELECT(1728,1212), "S10180C79.s10180c79f11");
    check_field_offset(lv, s10180c79f12, ABISELECT(1944,1356), "S10180C79.s10180c79f12");
    check_field_offset(lv, s10180c79f13, ABISELECT(2168,1500), "S10180C79.s10180c79f13");
    check_field_offset(lv, s10180c79f14, ABISELECT(3312,2296), "S10180C79.s10180c79f14");
    check_field_offset(lv, s10180c79f15, ABISELECT(6024,4184), "S10180C79.s10180c79f15");
    check_field_offset(lv, s10180c79f16, ABISELECT(6032,4188), "S10180C79.s10180c79f16");
    check_field_offset(lv, s10180c79f17, ABISELECT(6072,4212), "S10180C79.s10180c79f17");
    check_field_offset(lv, s10180c79f18, ABISELECT(6076,4216), "S10180C79.s10180c79f18");
    check_field_offset(lv, s10180c79f19, ABISELECT(6080,4220), "S10180C79.s10180c79f19");
    check_field_offset(lv, s10180c79f20, ABISELECT(6088,4228), "S10180C79.s10180c79f20");
    check_field_offset(lv, s10180c79f21, ABISELECT(6160,4292), "S10180C79.s10180c79f21");
    check_field_offset(lv, s10180c79f22, ABISELECT(6176,4308), "S10180C79.s10180c79f22");
    check_field_offset(lv, s10180c79f23, ABISELECT(6192,4324), "S10180C79.s10180c79f23");
    check_field_offset(lv, s10180c79f24, ABISELECT(6208,4340), "S10180C79.s10180c79f24");
    check_field_offset(lv, s10180c79f25, ABISELECT(6216,4344), "S10180C79.s10180c79f25");
    check_field_offset(lv, s10180c79f26, ABISELECT(6376,4452), "S10180C79.s10180c79f26");
    check_field_offset(lv, s10180c79f27, ABISELECT(6384,4456), "S10180C79.s10180c79f27");
    check_field_offset(lv, s10180c79f28, ABISELECT(6392,4464), "S10180C79.s10180c79f28");
    check_field_offset(lv, s10180c79f29, ABISELECT(6396,4468), "S10180C79.s10180c79f29");
    check_field_offset(lv, s10180c79f30, ABISELECT(6400,4472), "S10180C79.s10180c79f30");
    check_field_offset(lv, s10180c79f31, ABISELECT(6408,4476), "S10180C79.s10180c79f31");
    check_field_offset(lv, s10180c79f32, ABISELECT(6432,4492), "S10180C79.s10180c79f32");
    check_field_offset(lv, s10180c79f33, ABISELECT(6436,4496), "S10180C79.s10180c79f33");
    test_class_info(&lv, &cd_S10180C79);
    dp->~S10180C79();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C79(Test_S10180C79, "S10180C79", ABISELECT(6440,4500));

#else // __cplusplus

extern void _ZN9S10180C79C1Ev();
extern void _ZN9S10180C79D1Ev();
Name_Map name_map_S10180C79[] = {
  NSPAIR(_ZN9S10180C79C1Ev),
  NSPAIR(_ZN9S10180C79D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C81;
extern VTBL_ENTRY _ZTI9S10180C81[];
extern  VTBL_ENTRY _ZTV9S10180C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
extern Class_Descriptor cd_S10180C80;
extern VTBL_ENTRY _ZTI9S10180C80[];
extern  VTBL_ENTRY _ZTV9S10180C80[];
extern Class_Descriptor cd_S10180C83;
extern VTBL_ENTRY _ZTI9S10180C83[];
extern  VTBL_ENTRY _ZTV9S10180C83[];
extern Class_Descriptor cd_S10180C26;
extern VTBL_ENTRY _ZTI9S10180C26[];
extern  VTBL_ENTRY _ZTV9S10180C26[];
static Base_Class bases_S10180C79[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    66, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C81,    ABISELECT(152,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C82,    ABISELECT(160,104), //bcp->offset
    90, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C80,    ABISELECT(152,100), //bcp->offset
    71, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C83,    ABISELECT(176,112), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C26,    ABISELECT(184,116), //bcp->offset
    100, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C79[];
extern void _ZN9S10180C79D1Ev();
extern void _ZN9S10180C79D0Ev();
extern void _ZN9S10180C794v116Ev();
extern void _ZN9S10180C794v117Ev();
extern void _ZN9S10180C794v118Ev();
extern void _ZN9S10180C794v119Ev();
extern void _ZN9S10180C794v120Ev();
extern void _ZN9S10180C794v121Ev();
extern void _ZN9S10180C794v122Ev();
extern void _ZN9S10180C794v123Ev();
extern void _ZN9S10180C794v124Ev();
extern void _ZN9S10180C794v125Ev();
extern void _ZN9S10180C794v126Ev();
extern void _ZN9S10180C794v127Ev();
extern void _ZN9S10180C794v128Ev();
extern void _ZN9S10180C794v129Ev();
extern void _ZN9S10180C794v130Ev();
extern void _ZN9S10180C794v131Ev();
extern void _ZN9S10180C794v132Ev();
extern void _ZN9S10180C794v133Ev();
extern void _ZN9S10180C794v134Ev();
extern void _ZN9S10180C794v135Ev();
extern void _ZN9S10180C794v136Ev();
extern void _ZN9S10180C794v137Ev();
extern void _ZN9S10180C794v138Ev();
extern void _ZN9S10180C794v139Ev();
extern void _ZN9S10180C794v140Ev();
extern void _ZN9S10180C794v141Ev();
extern void _ZN9S10180C794v142Ev();
extern void _ZN9S10180C794v143Ev();
extern void _ZN9S10180C794v144Ev();
extern void _ZN9S10180C794v145Ev();
extern void _ZN9S10180C794v146Ev();
extern void _ZN9S10180C794v147Ev();
extern void _ZN9S10180C794v148Ev();
extern void _ZN9S10180C794v149Ev();
extern void ABISELECT(_ZThn48_N9S10180C79D1Ev,_ZThn32_N9S10180C79D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C79D0Ev,_ZThn32_N9S10180C79D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N9S10180C79D1Ev,_ZThn96_N9S10180C79D1Ev)();
extern void ABISELECT(_ZThn144_N9S10180C79D0Ev,_ZThn96_N9S10180C79D0Ev)();
extern void _ZN8S10180C22v7Ev();
extern void ABISELECT(_ZThn152_N9S10180C79D1Ev,_ZThn100_N9S10180C79D1Ev)();
extern void ABISELECT(_ZThn152_N9S10180C79D0Ev,_ZThn100_N9S10180C79D0Ev)();
extern void _ZN9S10180C813v99Ev();
extern void _ZN9S10180C814v100Ev();
extern void _ZN9S10180C814v101Ev();
extern void _ZN9S10180C814v102Ev();
extern void _ZN9S10180C814v103Ev();
extern void _ZN9S10180C814v104Ev();
extern void _ZN9S10180C814v105Ev();
extern void _ZN9S10180C814v106Ev();
extern void _ZN9S10180C814v107Ev();
extern void _ZN9S10180C814v108Ev();
extern void _ZN9S10180C814v109Ev();
extern void _ZN9S10180C814v110Ev();
extern void _ZN9S10180C814v111Ev();
extern void _ZN9S10180C814v112Ev();
extern void _ZN9S10180C814v113Ev();
extern void ABISELECT(_ZThn160_N9S10180C79D1Ev,_ZThn104_N9S10180C79D1Ev)();
extern void ABISELECT(_ZThn160_N9S10180C79D0Ev,_ZThn104_N9S10180C79D0Ev)();
extern void ABISELECT(_ZThn176_N9S10180C79D1Ev,_ZThn112_N9S10180C79D1Ev)();
extern void ABISELECT(_ZThn176_N9S10180C79D0Ev,_ZThn112_N9S10180C79D0Ev)();
extern void _ZN9S10180C834v114Ev();
extern void _ZN9S10180C834v115Ev();
extern void ABISELECT(_ZThn184_N9S10180C79D1Ev,_ZThn116_N9S10180C79D1Ev)();
extern void ABISELECT(_ZThn184_N9S10180C79D0Ev,_ZThn116_N9S10180C79D0Ev)();
extern void _ZN9S10180C263v64Ev();
static  VTBL_ENTRY vtc_S10180C79[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C79[0]),
  (VTBL_ENTRY)&_ZN9S10180C79D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C79D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v116Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v117Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v118Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v119Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v120Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v121Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v122Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v123Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v124Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v125Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v126Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v127Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v128Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v129Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v130Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v131Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v132Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v133Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v134Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v135Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v136Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v137Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v138Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v139Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v140Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v141Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v142Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v143Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v144Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v145Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v146Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v147Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v148Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v149Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C79D1Ev,_ZThn32_N9S10180C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C79D0Ev,_ZThn32_N9S10180C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S10180C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10180C79D1Ev,_ZThn96_N9S10180C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10180C79D0Ev,_ZThn96_N9S10180C79D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S10180C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10180C79D1Ev,_ZThn100_N9S10180C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10180C79D0Ev,_ZThn100_N9S10180C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v113Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S10180C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10180C79D1Ev,_ZThn104_N9S10180C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10180C79D0Ev,_ZThn104_N9S10180C79D0Ev),
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI9S10180C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10180C79D1Ev,_ZThn112_N9S10180C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10180C79D0Ev,_ZThn112_N9S10180C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C834v114Ev,
  (VTBL_ENTRY)&_ZN9S10180C834v115Ev,
  ABISELECT(-184,-116),
  (VTBL_ENTRY)&(_ZTI9S10180C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10180C79D1Ev,_ZThn116_N9S10180C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10180C79D0Ev,_ZThn116_N9S10180C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C263v64Ev,
};
extern VTBL_ENTRY _ZTI9S10180C79[];
extern  VTBL_ENTRY _ZTV9S10180C79[];
Class_Descriptor cd_S10180C79 = {  "S10180C79", // class name
  bases_S10180C79, 8,
  &(vtc_S10180C79[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6440,4500), // object size
  NSPAIRA(_ZTI9S10180C79),ABISELECT(120,64), //typeinfo_var
  NSPAIRA(_ZTV9S10180C79),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C78  : S10180C79 {
  char s10180c78f0;
  virtual  ~S10180C78(); // _ZN9S10180C78D1Ev
  virtual void  v97(); // _ZN9S10180C783v97Ev
  virtual void  v98(); // _ZN9S10180C783v98Ev
  S10180C78(); // tgen
};
//SIG(-1 S10180C78) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC11{ vd v27} BC12{ BC13{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42} BC14{ vd m Fp}} BC15{ vd v43 v44} BC16{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fp[5] Fi Fp FC17{ m Fi[2]} FC18{ m Fp} FC19{ BC20{ BC3 vd v81 v82 v83 v84 FC21{ m Fp FC8 FC9 FC9 Fi[3] FC22{ m FC23{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v80} FC24{ BC20 v85 v86} FC25{ BC20 v87} FC26{ BC20 v88 v89} FC27{ BC20 v90 v91 v92 FC28{ Fp[3]} FC29{ Fi[4]}[3]} FC30{ BC3 BC7 vd v93 v94 v95 v96 v97 v98 v99 v100 FC31{ m FC9 Fi[2] FC9} Fi[2] Fc[2] Fi FL[2] FC32{ m FL} Fi} FC33{ BC34{ BC3 BC7 vd v106 v107 v108 v109 v110 v111} BC11 vd v101 v102 v103 v104 v105 FC35{ m Fi Fp Fi FC22} FC36{ m Fp Fi[2] FC6}} FC37{ BC3 BC7 vd v112 v113 v114 v115 FC38{ m FC36 Fp[2]} Fp[2] FC9 Fi} FC39{ BC3 BC7 BC11 BC12 BC15 BC16 vd v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 FC38 Fp[2] Fi[2] FC40{ BC3 vd v135 Fp FC8 FC8 Fp Fi FC22} FC24 FC26 FC26 FC22 FC22 FC22 Fi} FC41{ BC42{ BC3 BC7 BC11 vd v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 Fi[2] FC19 FC38 FC43{ BC20 v165 v166 v167 Fp[3]} FC44{ BC20 v168} FC26 FC24 FC45{ BC3 vd v169 v170 FC46{ BC47{ BC48{ m Fp FC22 FC22 Fi[3] Fc[2] Fi Fp} FC18 FC49{ m Fp} FC18 FC9 FC9 FC18 FC49 FC18 FC9 FC9 FC9 Fc Fi Fp} FC9} Fi} FC25 FC50{ BC44 v171} FC25 Fp FC49 Fp[2] Fi Fc[3] Fi FL[2]} vd v136 v137 v138 v139 v140 v141 FC51{ m Fp} FC52{ m Fp FC49 Fp[5] FC53{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC54{ m FC55{ m Fi[2]} FC55} FC55 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC38 Fc[2] Fi FC56{ m Fc[5]} FC57{ m FC22 FC22 FC22 FC18 Fi Fc[2] Fi} FC22 FC22 FC22 Fp FC58{ BC3 vd FC59{ m Fp[3] FC17 FC9 FL[2] Fc} FC38} Fc[2] FL Fc[2] Fi FC49 FC60{ m FC61{ BC62{ m Fp Fi FC63{ m} FC63}} Fi} Fc Fi} vd v1 v2 Fc}


 S10180C78 ::~S10180C78(){ note_dtor("S10180C78", this);}
void  S10180C78 ::v97(){vfunc_called(this, "_ZN9S10180C783v97Ev");}
void  S10180C78 ::v98(){vfunc_called(this, "_ZN9S10180C783v98Ev");}
S10180C78 ::S10180C78(){ note_ctor("S10180C78", this);} // tgen

static void Test_S10180C78()
{
  extern Class_Descriptor cd_S10180C78;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(807,1127)];
    init_test(&cd_S10180C78, buf);
    S10180C78 *dp, &lv = *(dp=new (buf) S10180C78());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6448,4504), "sizeof(S10180C78)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C78)");
    check_base_class_offset(lv, (S10180C17*)(S10180C79*), 0, "S10180C78");
    check_base_class_offset(lv, (S10180C11*)(S10180C79*), ABISELECT(48,32), "S10180C78");
    check_base_class_offset(lv, (S10180C2*)(S10180C79*), ABISELECT(144,96), "S10180C78");
    check_base_class_offset(lv, (S10180C81*)(S10180C80*)(S10180C79*), ABISELECT(152,100), "S10180C78");
    check_base_class_offset(lv, (S10180C82*)(S10180C80*)(S10180C79*), ABISELECT(160,104), "S10180C78");
    check_base_class_offset(lv, (S10180C80*)(S10180C79*), ABISELECT(152,100), "S10180C78");
    check_base_class_offset(lv, (S10180C83*)(S10180C79*), ABISELECT(176,112), "S10180C78");
    check_base_class_offset(lv, (S10180C26*)(S10180C79*), ABISELECT(184,116), "S10180C78");
    check_base_class_offset(lv, (S10180C79*), 0, "S10180C78");
    check_field_offset(lv, s10180c78f0, ABISELECT(6440,4500), "S10180C78.s10180c78f0");
    test_class_info(&lv, &cd_S10180C78);
    dp->~S10180C78();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C78(Test_S10180C78, "S10180C78", ABISELECT(6448,4504));

#else // __cplusplus

extern void _ZN9S10180C78C1Ev();
extern void _ZN9S10180C78D1Ev();
Name_Map name_map_S10180C78[] = {
  NSPAIR(_ZN9S10180C78C1Ev),
  NSPAIR(_ZN9S10180C78D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C81;
extern VTBL_ENTRY _ZTI9S10180C81[];
extern  VTBL_ENTRY _ZTV9S10180C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
extern Class_Descriptor cd_S10180C80;
extern VTBL_ENTRY _ZTI9S10180C80[];
extern  VTBL_ENTRY _ZTV9S10180C80[];
extern Class_Descriptor cd_S10180C83;
extern VTBL_ENTRY _ZTI9S10180C83[];
extern  VTBL_ENTRY _ZTV9S10180C83[];
extern Class_Descriptor cd_S10180C26;
extern VTBL_ENTRY _ZTI9S10180C26[];
extern  VTBL_ENTRY _ZTV9S10180C26[];
extern Class_Descriptor cd_S10180C79;
extern VTBL_ENTRY _ZTI9S10180C79[];
extern  VTBL_ENTRY _ZTV9S10180C79[];
static Base_Class bases_S10180C78[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    68, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10180C81,    ABISELECT(152,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C82,    ABISELECT(160,104), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C80,    ABISELECT(152,100), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10180C83,    ABISELECT(176,112), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10180C26,    ABISELECT(184,116), //bcp->offset
    102, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10180C79,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C78[];
extern void _ZN9S10180C78D1Ev();
extern void _ZN9S10180C78D0Ev();
extern void _ZN9S10180C794v116Ev();
extern void _ZN9S10180C794v117Ev();
extern void _ZN9S10180C794v118Ev();
extern void _ZN9S10180C794v119Ev();
extern void _ZN9S10180C794v120Ev();
extern void _ZN9S10180C794v121Ev();
extern void _ZN9S10180C794v122Ev();
extern void _ZN9S10180C794v123Ev();
extern void _ZN9S10180C794v124Ev();
extern void _ZN9S10180C794v125Ev();
extern void _ZN9S10180C794v126Ev();
extern void _ZN9S10180C794v127Ev();
extern void _ZN9S10180C794v128Ev();
extern void _ZN9S10180C794v129Ev();
extern void _ZN9S10180C794v130Ev();
extern void _ZN9S10180C794v131Ev();
extern void _ZN9S10180C794v132Ev();
extern void _ZN9S10180C794v133Ev();
extern void _ZN9S10180C794v134Ev();
extern void _ZN9S10180C794v135Ev();
extern void _ZN9S10180C794v136Ev();
extern void _ZN9S10180C794v137Ev();
extern void _ZN9S10180C794v138Ev();
extern void _ZN9S10180C794v139Ev();
extern void _ZN9S10180C794v140Ev();
extern void _ZN9S10180C794v141Ev();
extern void _ZN9S10180C794v142Ev();
extern void _ZN9S10180C794v143Ev();
extern void _ZN9S10180C794v144Ev();
extern void _ZN9S10180C794v145Ev();
extern void _ZN9S10180C794v146Ev();
extern void _ZN9S10180C794v147Ev();
extern void _ZN9S10180C794v148Ev();
extern void _ZN9S10180C794v149Ev();
extern void _ZN9S10180C783v97Ev();
extern void _ZN9S10180C783v98Ev();
extern void ABISELECT(_ZThn48_N9S10180C78D1Ev,_ZThn32_N9S10180C78D1Ev)();
extern void ABISELECT(_ZThn48_N9S10180C78D0Ev,_ZThn32_N9S10180C78D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N9S10180C78D1Ev,_ZThn96_N9S10180C78D1Ev)();
extern void ABISELECT(_ZThn144_N9S10180C78D0Ev,_ZThn96_N9S10180C78D0Ev)();
extern void _ZN8S10180C22v7Ev();
extern void ABISELECT(_ZThn152_N9S10180C78D1Ev,_ZThn100_N9S10180C78D1Ev)();
extern void ABISELECT(_ZThn152_N9S10180C78D0Ev,_ZThn100_N9S10180C78D0Ev)();
extern void _ZN9S10180C813v99Ev();
extern void _ZN9S10180C814v100Ev();
extern void _ZN9S10180C814v101Ev();
extern void _ZN9S10180C814v102Ev();
extern void _ZN9S10180C814v103Ev();
extern void _ZN9S10180C814v104Ev();
extern void _ZN9S10180C814v105Ev();
extern void _ZN9S10180C814v106Ev();
extern void _ZN9S10180C814v107Ev();
extern void _ZN9S10180C814v108Ev();
extern void _ZN9S10180C814v109Ev();
extern void _ZN9S10180C814v110Ev();
extern void _ZN9S10180C814v111Ev();
extern void _ZN9S10180C814v112Ev();
extern void _ZN9S10180C814v113Ev();
extern void ABISELECT(_ZThn160_N9S10180C78D1Ev,_ZThn104_N9S10180C78D1Ev)();
extern void ABISELECT(_ZThn160_N9S10180C78D0Ev,_ZThn104_N9S10180C78D0Ev)();
extern void ABISELECT(_ZThn176_N9S10180C78D1Ev,_ZThn112_N9S10180C78D1Ev)();
extern void ABISELECT(_ZThn176_N9S10180C78D0Ev,_ZThn112_N9S10180C78D0Ev)();
extern void _ZN9S10180C834v114Ev();
extern void _ZN9S10180C834v115Ev();
extern void ABISELECT(_ZThn184_N9S10180C78D1Ev,_ZThn116_N9S10180C78D1Ev)();
extern void ABISELECT(_ZThn184_N9S10180C78D0Ev,_ZThn116_N9S10180C78D0Ev)();
extern void _ZN9S10180C263v64Ev();
static  VTBL_ENTRY vtc_S10180C78[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C78[0]),
  (VTBL_ENTRY)&_ZN9S10180C78D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C78D0Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v116Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v117Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v118Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v119Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v120Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v121Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v122Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v123Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v124Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v125Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v126Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v127Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v128Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v129Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v130Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v131Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v132Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v133Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v134Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v135Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v136Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v137Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v138Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v139Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v140Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v141Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v142Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v143Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v144Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v145Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v146Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v147Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v148Ev,
  (VTBL_ENTRY)&_ZN9S10180C794v149Ev,
  (VTBL_ENTRY)&_ZN9S10180C783v97Ev,
  (VTBL_ENTRY)&_ZN9S10180C783v98Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10180C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C78D1Ev,_ZThn32_N9S10180C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10180C78D0Ev,_ZThn32_N9S10180C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S10180C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10180C78D1Ev,_ZThn96_N9S10180C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10180C78D0Ev,_ZThn96_N9S10180C78D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S10180C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10180C78D1Ev,_ZThn100_N9S10180C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10180C78D0Ev,_ZThn100_N9S10180C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v113Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S10180C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10180C78D1Ev,_ZThn104_N9S10180C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10180C78D0Ev,_ZThn104_N9S10180C78D0Ev),
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI9S10180C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10180C78D1Ev,_ZThn112_N9S10180C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10180C78D0Ev,_ZThn112_N9S10180C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C834v114Ev,
  (VTBL_ENTRY)&_ZN9S10180C834v115Ev,
  ABISELECT(-184,-116),
  (VTBL_ENTRY)&(_ZTI9S10180C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10180C78D1Ev,_ZThn116_N9S10180C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10180C78D0Ev,_ZThn116_N9S10180C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C263v64Ev,
};
extern VTBL_ENTRY _ZTI9S10180C78[];
extern  VTBL_ENTRY _ZTV9S10180C78[];
Class_Descriptor cd_S10180C78 = {  "S10180C78", // class name
  bases_S10180C78, 9,
  &(vtc_S10180C78[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6448,4504), // object size
  NSPAIRA(_ZTI9S10180C78),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10180C78),107, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  9, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C16  : S10180C2 , S10180C17 , S10180C24 {
  void *s10180c16f0[5];
  ::S10180C25 s10180c16f1;
  ::S10180C78 s10180c16f2;
  ::S10180C87 s10180c16f3;
  ::S10180C87 s10180c16f4;
  void *s10180c16f5;
  char s10180c16f6;
  void *s10180c16f7;
  int s10180c16f8;
  virtual  ~S10180C16(); // _ZN9S10180C16D1Ev
  virtual void  v39(); // _ZN9S10180C163v39Ev
  virtual void  v40(); // _ZN9S10180C163v40Ev
  S10180C16(); // tgen
};
//SIG(-1 S10180C16) C1{ BC2{ vd v3} BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} BC7{ vd v4} vd v1 v2 Fp[5] FC8{ BC3 BC2 BC9{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 Fp FC10{ m FC11{ m Fp Fi FC5} Fi} FC12{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC13{ vd v51} BC14{ vd v52 v53} vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fi FC15{ m Fi[2]} FC15 FC15 FC16{ BC3 vd Fi Fp FC10 FL FC15 Fi Fc Fi FC17{ m FC18{ m Fp Fi[2] FC6} Fp[2]}} FC19{ BC9 vd v54 v55 v56} FC20{ vd m Fi Fp[3] FC21{ m Fc[2] Fp[3] Fi[4] FC22{ m FC23{ FL[4]}}}} FC24{ vd m FC22 Fi[2] FC25{ m FL[3] Fi[3] FL} FL FC26{ m Fi FC27{ m Fi[4]}} FC17 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC28{ BC3 BC7 vd v57 Fi FC29{ m Fc[2]} FC30{ Fp[2]} Fp FC31{ vd m FC32{ vd m FC33{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC34{ BC35{ vd v64 v65 v66 v67 v68 v69 Fi Fp Fc} vd v58 v59 v60 v61 v62 v63 Fp} FC36{ BC37{ vd v71 Fi Fc[3]} vd v70 Fp[4] FL Fi FC22 FC38{ m Fp FC39{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC40{ BC37 vd v72 FC22 Fi Fp[2] FC41{ m FC22 FC38 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC42{ BC37 vd v73 Fp[2] FL Fi[4] FC43{ m Fi[2]} FC22 FC44{ m FC22 FC38 Fp Fi[4]} FC45{ m Fp}} FC22 FC22 FL Fi[5]} FL FC46{ m FC25 FC47{ m Fi} Fi} Fc[128] FC15 FC17} Fi[3] FC48{ m Fp Fi[2]} FC49{ m Fc[11] Fi[2]} FC50{ BC51{} FL Fi} FC52{ BC53{ BC3 vd v76 v77 v78 v79 FC54{ m Fp FC10 FC11 FC11 Fi[3] FC55{ m FC56{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC10 FC10 Fc} Fp Fc Fi} v74 v75} FL FC57{ BC53 v80} FC57 FC52 FC17 Fc} FC58{ BC59{ BC3 BC9 BC2 BC60{ BC61{ vd v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97} BC62{ vd m Fp}} BC63{ vd v98 v99} BC13 vd v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[5] Fi Fp FC43 FC45 FC64{ BC53 v134} FC52 FC57 FC65{ BC53 v135 v136} FC66{ BC53 v137 v138 v139 FC67{ Fp[3]} FC39[3]} FC68{ BC3 BC9 vd v140 v141 v142 v143 v144 v145 v146 v147 FC69{ m FC11 Fi[2] FC11} Fi[2] Fc[2] Fi FL[2] FC70{ m FL} Fi} FC71{ BC72{ BC3 BC9 vd v153 v154 v155 v156 v157 v158} BC2 vd v148 v149 v150 v151 v152 FC73{ m Fi Fp Fi FC55} FC18} FC74{ BC3 BC9 vd v159 v160 v161 v162 FC17 Fp[2] FC11 Fi} FC75{ BC3 BC9 BC2 BC60 BC63 BC13 vd v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC17 Fp[2] Fi[2] FC76{ BC3 vd v182 Fp FC10 FC10 Fp Fi FC55} FC52 FC65 FC65 FC55 FC55 FC55 Fi} FC77{ BC78{ BC3 BC9 BC2 vd v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 Fi[2] FC64 FC17 FC79{ BC53 v212 v213 v214 Fp[3]} FC80{ BC53 v215} FC65 FC52 FC81{ BC3 vd v216 v217 FC82{ BC83{ BC84{ m Fp FC55 FC55 Fi[3] Fc[2] Fi Fp} FC45 FC85{ m Fp} FC45 FC11 FC11 FC45 FC85 FC45 FC11 FC11 FC11 Fc Fi Fp} FC11} Fi} FC57 FC86{ BC80 v218} FC57 Fp FC85 Fp[2] Fi Fc[3] Fi FL[2]} vd v183 v184 v185 v186 v187 v188 FC87{ m Fp} FC88{ m Fp FC85 Fp[5] FC89{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC90{ m FC91{ m Fi[2]} FC91} FC91 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC17 Fc[2] Fi FC92{ m Fc[5]} FC93{ m FC55 FC55 FC55 FC45 Fi Fc[2] Fi} FC55 FC55 FC55 Fp FC94{ BC3 vd FC95{ m Fp[3] FC43 FC11 FL[2] Fc} FC17} Fc[2] FL Fc[2] Fi FC85 FC96{ m FC97{ BC98{ m Fp Fi FC99{ m} FC99}} Fi} Fc Fi} vd v81 v82 Fc} FC65 FC65 Fp Fc Fp Fi}


 S10180C16 ::~S10180C16(){ note_dtor("S10180C16", this);}
void  S10180C16 ::v39(){vfunc_called(this, "_ZN9S10180C163v39Ev");}
void  S10180C16 ::v40(){vfunc_called(this, "_ZN9S10180C163v40Ev");}
S10180C16 ::S10180C16(){ note_ctor("S10180C16", this);} // tgen

static void Test_S10180C16()
{
  extern Class_Descriptor cd_S10180C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2918,5115)];
    init_test(&cd_S10180C16, buf);
    S10180C16 *dp, &lv = *(dp=new (buf) S10180C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(23336,20456), "sizeof(S10180C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C16)");
    check_base_class_offset(lv, (S10180C2*), 0, "S10180C16");
    check_base_class_offset(lv, (S10180C17*), ABISELECT(8,4), "S10180C16");
    check_base_class_offset(lv, (S10180C24*), ABISELECT(56,36), "S10180C16");
    check_field_offset(lv, s10180c16f0, ABISELECT(64,40), "S10180C16.s10180c16f0");
    check_field_offset(lv, s10180c16f1, ABISELECT(104,60), "S10180C16.s10180c16f1");
    check_field_offset(lv, s10180c16f2, ABISELECT(16392,15608), "S10180C16.s10180c16f2");
    check_field_offset(lv, s10180c16f3, ABISELECT(22840,20112), "S10180C16.s10180c16f3");
    check_field_offset(lv, s10180c16f4, ABISELECT(23072,20276), "S10180C16.s10180c16f4");
    check_field_offset(lv, s10180c16f5, ABISELECT(23304,20440), "S10180C16.s10180c16f5");
    check_field_offset(lv, s10180c16f6, ABISELECT(23312,20444), "S10180C16.s10180c16f6");
    check_field_offset(lv, s10180c16f7, ABISELECT(23320,20448), "S10180C16.s10180c16f7");
    check_field_offset(lv, s10180c16f8, ABISELECT(23328,20452), "S10180C16.s10180c16f8");
    test_class_info(&lv, &cd_S10180C16);
    dp->~S10180C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C16(Test_S10180C16, "S10180C16", ABISELECT(23336,20456));

#else // __cplusplus

extern void _ZN9S10180C16C1Ev();
extern void _ZN9S10180C16D1Ev();
Name_Map name_map_S10180C16[] = {
  NSPAIR(_ZN9S10180C16C1Ev),
  NSPAIR(_ZN9S10180C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C24;
extern VTBL_ENTRY _ZTI9S10180C24[];
extern  VTBL_ENTRY _ZTV9S10180C24[];
static Base_Class bases_S10180C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C17,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C24,    ABISELECT(56,36), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10180C16[];
extern void _ZN9S10180C16D1Ev();
extern void _ZN9S10180C16D0Ev();
extern void _ZN8S10180C22v7Ev();
extern void _ZN9S10180C163v39Ev();
extern void _ZN9S10180C163v40Ev();
extern void ABISELECT(_ZThn8_N9S10180C16D1Ev,_ZThn4_N9S10180C16D1Ev)();
extern void ABISELECT(_ZThn8_N9S10180C16D0Ev,_ZThn4_N9S10180C16D0Ev)();
extern void ABISELECT(_ZThn56_N9S10180C16D1Ev,_ZThn36_N9S10180C16D1Ev)();
extern void ABISELECT(_ZThn56_N9S10180C16D0Ev,_ZThn36_N9S10180C16D0Ev)();
extern void _ZN9S10180C243v41Ev();
static  VTBL_ENTRY vtc_S10180C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10180C16[0]),
  (VTBL_ENTRY)&_ZN9S10180C16D1Ev,
  (VTBL_ENTRY)&_ZN9S10180C16D0Ev,
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  (VTBL_ENTRY)&_ZN9S10180C163v39Ev,
  (VTBL_ENTRY)&_ZN9S10180C163v40Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10180C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10180C16D1Ev,_ZThn4_N9S10180C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10180C16D0Ev,_ZThn4_N9S10180C16D0Ev),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S10180C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10180C16D1Ev,_ZThn36_N9S10180C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10180C16D0Ev,_ZThn36_N9S10180C16D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10180C16[];
extern  VTBL_ENTRY _ZTV9S10180C16[];
Class_Descriptor cd_S10180C16 = {  "S10180C16", // class name
  bases_S10180C16, 3,
  &(vtc_S10180C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(23336,20456), // object size
  NSPAIRA(_ZTI9S10180C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S10180C16),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C133  {
  void  mf10180c133(); // _ZN10S10180C13311mf10180c133Ev
};
//SIG(-1 S10180C133) C1{ m}


void  S10180C133 ::mf10180c133(){}

static void Test_S10180C133()
{
  {
    init_simple_test("S10180C133");
    S10180C133 lv;
    check2(sizeof(lv), 1, "sizeof(S10180C133)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C133)");
  }
}
static Arrange_To_Call_Me vS10180C133(Test_S10180C133, "S10180C133", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S10180C133[];
VTBL_ENTRY *P__ZTI10S10180C133 = _ZTI10S10180C133; 
Class_Descriptor cd_S10180C133 = {  "S10180C133", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S10180C133),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C132  {
  void *s10180c132f0;
  int s10180c132f1[2];
  ::S10180C133 s10180c132f2;
  void  mf10180c132(); // _ZN10S10180C13211mf10180c132Ev
};
//SIG(-1 S10180C132) C1{ m Fp Fi[2] FC2{ m}}


void  S10180C132 ::mf10180c132(){}

static void Test_S10180C132()
{
  {
    init_simple_test("S10180C132");
    S10180C132 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10180C132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C132)");
    check_field_offset(lv, s10180c132f0, 0, "S10180C132.s10180c132f0");
    check_field_offset(lv, s10180c132f1, ABISELECT(8,4), "S10180C132.s10180c132f1");
    check_field_offset(lv, s10180c132f2, ABISELECT(16,12), "S10180C132.s10180c132f2");
  }
}
static Arrange_To_Call_Me vS10180C132(Test_S10180C132, "S10180C132", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C131  {
  ::S10180C132 s10180c131f0;
  ::S10180C43 s10180c131f1[3];
  void *s10180c131f2[2];
  int s10180c131f3;
  char s10180c131f4;
  virtual  ~S10180C131(); // _ZN10S10180C131D1Ev
  virtual void  v246(); // _ZN10S10180C1314v246Ev
  virtual void  v247(); // _ZN10S10180C1314v247Ev
  S10180C131(); // tgen
};
//SIG(-1 S10180C131) C1{ vd v1 v2 FC2{ m Fp Fi[2] FC3{ m}} FC4{ m Fi[4]}[3] Fp[2] Fi Fc}


 S10180C131 ::~S10180C131(){ note_dtor("S10180C131", this);}
void  S10180C131 ::v246(){vfunc_called(this, "_ZN10S10180C1314v246Ev");}
void  S10180C131 ::v247(){vfunc_called(this, "_ZN10S10180C1314v247Ev");}
S10180C131 ::S10180C131(){ note_ctor("S10180C131", this);} // tgen

static void Test_S10180C131()
{
  extern Class_Descriptor cd_S10180C131;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,22)];
    init_test(&cd_S10180C131, buf);
    S10180C131 *dp, &lv = *(dp=new (buf) S10180C131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,84), "sizeof(S10180C131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C131)");
    check_field_offset(lv, s10180c131f0, ABISELECT(8,4), "S10180C131.s10180c131f0");
    check_field_offset(lv, s10180c131f1, ABISELECT(32,20), "S10180C131.s10180c131f1");
    check_field_offset(lv, s10180c131f2, ABISELECT(80,68), "S10180C131.s10180c131f2");
    check_field_offset(lv, s10180c131f3, ABISELECT(96,76), "S10180C131.s10180c131f3");
    check_field_offset(lv, s10180c131f4, ABISELECT(100,80), "S10180C131.s10180c131f4");
    test_class_info(&lv, &cd_S10180C131);
    dp->~S10180C131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C131(Test_S10180C131, "S10180C131", ABISELECT(104,84));

#else // __cplusplus

extern void _ZN10S10180C131C1Ev();
extern void _ZN10S10180C131D1Ev();
Name_Map name_map_S10180C131[] = {
  NSPAIR(_ZN10S10180C131C1Ev),
  NSPAIR(_ZN10S10180C131D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S10180C131[];
extern void _ZN10S10180C131D1Ev();
extern void _ZN10S10180C131D0Ev();
extern void _ZN10S10180C1314v246Ev();
extern void _ZN10S10180C1314v247Ev();
static  VTBL_ENTRY vtc_S10180C131[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C131[0]),
  (VTBL_ENTRY)&_ZN10S10180C131D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C131D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1314v246Ev,
  (VTBL_ENTRY)&_ZN10S10180C1314v247Ev,
};
extern VTBL_ENTRY _ZTI10S10180C131[];
extern  VTBL_ENTRY _ZTV10S10180C131[];
Class_Descriptor cd_S10180C131 = {  "S10180C131", // class name
  0,0,//no base classes
  &(vtc_S10180C131[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,84), // object size
  NSPAIRA(_ZTI10S10180C131),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S10180C131),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C138  {
  void  mf10180c138(); // _ZN10S10180C13811mf10180c138Ev
};
//SIG(-1 S10180C138) C1{ m}


void  S10180C138 ::mf10180c138(){}

static void Test_S10180C138()
{
  {
    init_simple_test("S10180C138");
    S10180C138 lv;
    check2(sizeof(lv), 1, "sizeof(S10180C138)");
    check2(__alignof__(lv), 1, "__alignof__(S10180C138)");
  }
}
static Arrange_To_Call_Me vS10180C138(Test_S10180C138, "S10180C138", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S10180C138[];
VTBL_ENTRY *P__ZTI10S10180C138 = _ZTI10S10180C138; 
Class_Descriptor cd_S10180C138 = {  "S10180C138", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S10180C138),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C136  {
  void *s10180c136f0;
  int s10180c136f1;
  ::S10180C133 s10180c136f2;
  ::S10180C138 s10180c136f3;
  void  mf10180c136(); // _ZN10S10180C13611mf10180c136Ev
};
//SIG(-1 S10180C136) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S10180C136 ::mf10180c136(){}

static void Test_S10180C136()
{
  {
    init_simple_test("S10180C136");
    S10180C136 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10180C136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C136)");
    check_field_offset(lv, s10180c136f0, 0, "S10180C136.s10180c136f0");
    check_field_offset(lv, s10180c136f1, ABISELECT(8,4), "S10180C136.s10180c136f1");
    check_field_offset(lv, s10180c136f2, ABISELECT(12,8), "S10180C136.s10180c136f2");
    check_field_offset(lv, s10180c136f3, ABISELECT(13,9), "S10180C136.s10180c136f3");
  }
}
static Arrange_To_Call_Me vS10180C136(Test_S10180C136, "S10180C136", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S10180C136 = {  "S10180C136", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C140  {
  void *s10180c140f0[2];
  ::S10180C13 s10180c140f1;
  ::S10180C132 s10180c140f2;
  int s10180c140f3[2];
  void  mf10180c140(); // _ZN10S10180C14011mf10180c140Ev
};
//SIG(-1 S10180C140) C1{ m Fp[2] FC2{ m Fp Fi FC3{ m}} FC4{ m Fp Fi[2] FC5{ m}} Fi[2]}


void  S10180C140 ::mf10180c140(){}

static void Test_S10180C140()
{
  {
    init_simple_test("S10180C140");
    S10180C140 lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S10180C140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C140)");
    check_field_offset(lv, s10180c140f0, 0, "S10180C140.s10180c140f0");
    check_field_offset(lv, s10180c140f1, ABISELECT(16,8), "S10180C140.s10180c140f1");
    check_field_offset(lv, s10180c140f2, ABISELECT(32,20), "S10180C140.s10180c140f2");
    check_field_offset(lv, s10180c140f3, ABISELECT(56,36), "S10180C140.s10180c140f3");
  }
}
static Arrange_To_Call_Me vS10180C140(Test_S10180C140, "S10180C140", ABISELECT(64,44));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C139  : S10180C17 {
  ::S10180C140 s10180c139f0;
  virtual  ~S10180C139(); // _ZN10S10180C139D1Ev
  virtual void  v249(); // _ZN10S10180C1394v249Ev
  virtual void  v250(); // _ZN10S10180C1394v250Ev
  virtual void  v251(); // _ZN10S10180C1394v251Ev
  virtual void  v252(); // _ZN10S10180C1394v252Ev
  S10180C139(); // tgen
};
//SIG(-1 S10180C139) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 FC6{ m Fp[2] FC7{ m Fp Fi FC4} FC8{ m Fp Fi[2] FC9{ m}} Fi[2]}}


 S10180C139 ::~S10180C139(){ note_dtor("S10180C139", this);}
void  S10180C139 ::v249(){vfunc_called(this, "_ZN10S10180C1394v249Ev");}
void  S10180C139 ::v250(){vfunc_called(this, "_ZN10S10180C1394v250Ev");}
void  S10180C139 ::v251(){vfunc_called(this, "_ZN10S10180C1394v251Ev");}
void  S10180C139 ::v252(){vfunc_called(this, "_ZN10S10180C1394v252Ev");}
S10180C139 ::S10180C139(){ note_ctor("S10180C139", this);} // tgen

static void Test_S10180C139()
{
  extern Class_Descriptor cd_S10180C139;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S10180C139, buf);
    S10180C139 *dp, &lv = *(dp=new (buf) S10180C139());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S10180C139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C139)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C139");
    check_field_offset(lv, s10180c139f0, ABISELECT(48,32), "S10180C139.s10180c139f0");
    test_class_info(&lv, &cd_S10180C139);
    dp->~S10180C139();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C139(Test_S10180C139, "S10180C139", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN10S10180C139C1Ev();
extern void _ZN10S10180C139D1Ev();
Name_Map name_map_S10180C139[] = {
  NSPAIR(_ZN10S10180C139C1Ev),
  NSPAIR(_ZN10S10180C139D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C139[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C139[];
extern void _ZN10S10180C139D1Ev();
extern void _ZN10S10180C139D0Ev();
extern void _ZN10S10180C1394v249Ev();
extern void _ZN10S10180C1394v250Ev();
extern void _ZN10S10180C1394v251Ev();
extern void _ZN10S10180C1394v252Ev();
static  VTBL_ENTRY vtc_S10180C139[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C139[0]),
  (VTBL_ENTRY)&_ZN10S10180C139D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C139D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1394v249Ev,
  (VTBL_ENTRY)&_ZN10S10180C1394v250Ev,
  (VTBL_ENTRY)&_ZN10S10180C1394v251Ev,
  (VTBL_ENTRY)&_ZN10S10180C1394v252Ev,
};
extern VTBL_ENTRY _ZTI10S10180C139[];
extern  VTBL_ENTRY _ZTV10S10180C139[];
Class_Descriptor cd_S10180C139 = {  "S10180C139", // class name
  bases_S10180C139, 1,
  &(vtc_S10180C139[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI10S10180C139),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C139),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C135  : S10180C2 {
  void *s10180c135f0[2];
  ::S10180C136 s10180c135f1;
  ::S10180C139 s10180c135f2;
  virtual  ~S10180C135(); // _ZN10S10180C135D1Ev
  virtual void  v248(); // _ZN10S10180C1354v248Ev
  S10180C135(); // tgen
};
//SIG(-1 S10180C135) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m Fp Fi FC4{ m} FC5{ m}} FC6{ BC7{ vd m FC8{ m Fp Fi FC9{ m} FC10{ m}} FC8 Fc} vd v3 v4 v5 v6 FC11{ m Fp[2] FC12{ m Fp Fi FC9} FC13{ m Fp Fi[2] FC4} Fi[2]}}}


 S10180C135 ::~S10180C135(){ note_dtor("S10180C135", this);}
void  S10180C135 ::v248(){vfunc_called(this, "_ZN10S10180C1354v248Ev");}
S10180C135 ::S10180C135(){ note_ctor("S10180C135", this);} // tgen

static void Test_S10180C135()
{
  extern Class_Descriptor cd_S10180C135;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,26)];
    init_test(&cd_S10180C135, buf);
    S10180C135 *dp, &lv = *(dp=new (buf) S10180C135());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,100), "sizeof(S10180C135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C135)");
    check_base_class_offset(lv, (S10180C2*), 0, "S10180C135");
    check_field_offset(lv, s10180c135f0, ABISELECT(8,4), "S10180C135.s10180c135f0");
    check_field_offset(lv, s10180c135f1, ABISELECT(24,12), "S10180C135.s10180c135f1");
    check_field_offset(lv, s10180c135f2, ABISELECT(40,24), "S10180C135.s10180c135f2");
    test_class_info(&lv, &cd_S10180C135);
    dp->~S10180C135();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C135(Test_S10180C135, "S10180C135", ABISELECT(152,100));

#else // __cplusplus

extern void _ZN10S10180C135C1Ev();
extern void _ZN10S10180C135D1Ev();
Name_Map name_map_S10180C135[] = {
  NSPAIR(_ZN10S10180C135C1Ev),
  NSPAIR(_ZN10S10180C135D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
static Base_Class bases_S10180C135[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C135[];
extern void _ZN10S10180C135D1Ev();
extern void _ZN10S10180C135D0Ev();
extern void _ZN8S10180C22v7Ev();
extern void _ZN10S10180C1354v248Ev();
static  VTBL_ENTRY vtc_S10180C135[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C135[0]),
  (VTBL_ENTRY)&_ZN10S10180C135D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C135D0Ev,
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  (VTBL_ENTRY)&_ZN10S10180C1354v248Ev,
};
extern VTBL_ENTRY _ZTI10S10180C135[];
extern  VTBL_ENTRY _ZTV10S10180C135[];
Class_Descriptor cd_S10180C135 = {  "S10180C135", // class name
  bases_S10180C135, 1,
  &(vtc_S10180C135[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,100), // object size
  NSPAIRA(_ZTI10S10180C135),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C135),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C147  {
  ::S10180C93 s10180c147f0;
  void  mf10180c147(); // _ZN10S10180C14711mf10180c147Ev
};
//SIG(-1 S10180C147) C1{ m FC2{ m FL}}


void  S10180C147 ::mf10180c147(){}

static void Test_S10180C147()
{
  {
    init_simple_test("S10180C147");
    S10180C147 lv;
    check2(sizeof(lv), 8, "sizeof(S10180C147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C147)");
    check_field_offset(lv, s10180c147f0, 0, "S10180C147.s10180c147f0");
  }
}
static Arrange_To_Call_Me vS10180C147(Test_S10180C147, "S10180C147", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C146  {
  ::S10180C73 s10180c146f0;
  ::S10180C73 s10180c146f1;
  ::S10180C147 s10180c146f2;
  ::S10180C147 s10180c146f3;
  ::S10180C73 s10180c146f4;
  ::S10180C73 s10180c146f5;
  void  mf10180c146(); // _ZN10S10180C14611mf10180c146Ev
};
//SIG(-1 S10180C146) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC4{ m FC5{ m FL}} FC4 FC2 FC2}


void  S10180C146 ::mf10180c146(){}

static void Test_S10180C146()
{
  {
    init_simple_test("S10180C146");
    S10180C146 lv;
    check2(sizeof(lv), 80, "sizeof(S10180C146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C146)");
    check_field_offset(lv, s10180c146f0, 0, "S10180C146.s10180c146f0");
    check_field_offset(lv, s10180c146f1, 16, "S10180C146.s10180c146f1");
    check_field_offset(lv, s10180c146f2, 32, "S10180C146.s10180c146f2");
    check_field_offset(lv, s10180c146f3, 40, "S10180C146.s10180c146f3");
    check_field_offset(lv, s10180c146f4, 48, "S10180C146.s10180c146f4");
    check_field_offset(lv, s10180c146f5, 64, "S10180C146.s10180c146f5");
  }
}
static Arrange_To_Call_Me vS10180C146(Test_S10180C146, "S10180C146", 80);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C145  : S10180C17 {
  void *s10180c145f0[2];
  ::S10180C111 s10180c145f1;
  char s10180c145f2[2];
  void *s10180c145f3;
  ::S10180C146 s10180c145f4;
  ::S10180C12 s10180c145f5;
  void *s10180c145f6[4];
  ::S10180C31 s10180c145f7;
  virtual  ~S10180C145(); // _ZN10S10180C145D1Ev
  virtual void  v262(); // _ZN10S10180C1454v262Ev
  virtual void  v263(); // _ZN10S10180C1454v263Ev
  virtual void  v264(); // _ZN10S10180C1454v264Ev
  virtual void  v265(); // _ZN10S10180C1454v265Ev
  virtual void  v266(); // _ZN10S10180C1454v266Ev
  virtual void  v267(); // _ZN10S10180C1454v267Ev
  virtual void  v268(); // _ZN10S10180C1454v268Ev
  virtual void  v269(); // _ZN10S10180C1454v269Ev
  virtual void  v270(); // _ZN10S10180C1454v270Ev
  virtual void  v271(); // _ZN10S10180C1454v271Ev
  virtual void  v272(); // _ZN10S10180C1454v272Ev
  virtual void  v273(); // _ZN10S10180C1454v273Ev
  virtual void  v274(); // _ZN10S10180C1454v274Ev
  virtual void  v275(); // _ZN10S10180C1454v275Ev
  virtual void  v276(); // _ZN10S10180C1454v276Ev
  virtual void  v277(); // _ZN10S10180C1454v277Ev
  virtual void  v278(); // _ZN10S10180C1454v278Ev
  virtual void  v279(); // _ZN10S10180C1454v279Ev
  virtual void  v280(); // _ZN10S10180C1454v280Ev
  virtual void  v281(); // _ZN10S10180C1454v281Ev
  S10180C145(); // tgen
};
//SIG(-1 S10180C145) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp[2] FC6{ m Fp} Fc[2] Fp FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC10{ m FC11{ m FL}} FC10 FC8 FC8} FC12{ m FC13{ m Fp Fi FC4} Fi} Fp[4] FC14{ m FC15{ m Fp Fi[2] FC5} Fp[2]}}


 S10180C145 ::~S10180C145(){ note_dtor("S10180C145", this);}
void  S10180C145 ::v262(){vfunc_called(this, "_ZN10S10180C1454v262Ev");}
void  S10180C145 ::v263(){vfunc_called(this, "_ZN10S10180C1454v263Ev");}
void  S10180C145 ::v264(){vfunc_called(this, "_ZN10S10180C1454v264Ev");}
void  S10180C145 ::v265(){vfunc_called(this, "_ZN10S10180C1454v265Ev");}
void  S10180C145 ::v266(){vfunc_called(this, "_ZN10S10180C1454v266Ev");}
void  S10180C145 ::v267(){vfunc_called(this, "_ZN10S10180C1454v267Ev");}
void  S10180C145 ::v268(){vfunc_called(this, "_ZN10S10180C1454v268Ev");}
void  S10180C145 ::v269(){vfunc_called(this, "_ZN10S10180C1454v269Ev");}
void  S10180C145 ::v270(){vfunc_called(this, "_ZN10S10180C1454v270Ev");}
void  S10180C145 ::v271(){vfunc_called(this, "_ZN10S10180C1454v271Ev");}
void  S10180C145 ::v272(){vfunc_called(this, "_ZN10S10180C1454v272Ev");}
void  S10180C145 ::v273(){vfunc_called(this, "_ZN10S10180C1454v273Ev");}
void  S10180C145 ::v274(){vfunc_called(this, "_ZN10S10180C1454v274Ev");}
void  S10180C145 ::v275(){vfunc_called(this, "_ZN10S10180C1454v275Ev");}
void  S10180C145 ::v276(){vfunc_called(this, "_ZN10S10180C1454v276Ev");}
void  S10180C145 ::v277(){vfunc_called(this, "_ZN10S10180C1454v277Ev");}
void  S10180C145 ::v278(){vfunc_called(this, "_ZN10S10180C1454v278Ev");}
void  S10180C145 ::v279(){vfunc_called(this, "_ZN10S10180C1454v279Ev");}
void  S10180C145 ::v280(){vfunc_called(this, "_ZN10S10180C1454v280Ev");}
void  S10180C145 ::v281(){vfunc_called(this, "_ZN10S10180C1454v281Ev");}
S10180C145 ::S10180C145(){ note_ctor("S10180C145", this);} // tgen

static void Test_S10180C145()
{
  extern Class_Descriptor cd_S10180C145;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,48)];
    init_test(&cd_S10180C145, buf);
    S10180C145 *dp, &lv = *(dp=new (buf) S10180C145());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,188), "sizeof(S10180C145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C145)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C145");
    check_field_offset(lv, s10180c145f0, ABISELECT(48,32), "S10180C145.s10180c145f0");
    check_field_offset(lv, s10180c145f1, ABISELECT(64,40), "S10180C145.s10180c145f1");
    check_field_offset(lv, s10180c145f2, ABISELECT(72,44), "S10180C145.s10180c145f2");
    check_field_offset(lv, s10180c145f3, ABISELECT(80,48), "S10180C145.s10180c145f3");
    check_field_offset(lv, s10180c145f4, ABISELECT(88,52), "S10180C145.s10180c145f4");
    check_field_offset(lv, s10180c145f5, ABISELECT(168,132), "S10180C145.s10180c145f5");
    check_field_offset(lv, s10180c145f6, ABISELECT(192,148), "S10180C145.s10180c145f6");
    check_field_offset(lv, s10180c145f7, ABISELECT(224,164), "S10180C145.s10180c145f7");
    test_class_info(&lv, &cd_S10180C145);
    dp->~S10180C145();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C145(Test_S10180C145, "S10180C145", ABISELECT(264,188));

#else // __cplusplus

extern void _ZN10S10180C145C1Ev();
extern void _ZN10S10180C145D1Ev();
Name_Map name_map_S10180C145[] = {
  NSPAIR(_ZN10S10180C145C1Ev),
  NSPAIR(_ZN10S10180C145D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C145[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C145[];
extern void _ZN10S10180C145D1Ev();
extern void _ZN10S10180C145D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
static  VTBL_ENTRY vtc_S10180C145[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C145[0]),
  (VTBL_ENTRY)&_ZN10S10180C145D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C145D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
};
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
Class_Descriptor cd_S10180C145 = {  "S10180C145", // class name
  bases_S10180C145, 1,
  &(vtc_S10180C145[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,188), // object size
  NSPAIRA(_ZTI10S10180C145),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C145),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C150  {
  void *s10180c150f0[2];
  void  mf10180c150(); // _ZN10S10180C15011mf10180c150Ev
};
//SIG(-1 S10180C150) C1{ m Fp[2]}


void  S10180C150 ::mf10180c150(){}

static void Test_S10180C150()
{
  {
    init_simple_test("S10180C150");
    S10180C150 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10180C150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C150)");
    check_field_offset(lv, s10180c150f0, 0, "S10180C150.s10180c150f0");
  }
}
static Arrange_To_Call_Me vS10180C150(Test_S10180C150, "S10180C150", ABISELECT(16,8));

#else // __cplusplus

Class_Descriptor cd_S10180C150 = {  "S10180C150", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C149  {
  int s10180c149f0[2];
  ::S10180C13 s10180c149f1;
  ::S10180C13 s10180c149f2;
  ::S10180C13 s10180c149f3;
  ::S10180C13 s10180c149f4;
  ::S10180C150 s10180c149f5;
  __tsi64 s10180c149f6[2];
  void  mf10180c149(); // _ZN10S10180C14911mf10180c149Ev
  virtual  ~S10180C149(); // _ZN10S10180C149D1Ev
  S10180C149(); // tgen
};
//SIG(-1 S10180C149) C1{ vd m Fi[2] FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC2 FC4{ m Fp[2]} FL[2]}


void  S10180C149 ::mf10180c149(){}
 S10180C149 ::~S10180C149(){ note_dtor("S10180C149", this);}
S10180C149 ::S10180C149(){ note_ctor("S10180C149", this);} // tgen

static void Test_S10180C149()
{
  extern Class_Descriptor cd_S10180C149;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,22)];
    init_test(&cd_S10180C149, buf);
    S10180C149 *dp, &lv = *(dp=new (buf) S10180C149());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,84), "sizeof(S10180C149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C149)");
    check_field_offset(lv, s10180c149f0, ABISELECT(8,4), "S10180C149.s10180c149f0");
    check_field_offset(lv, s10180c149f1, ABISELECT(16,12), "S10180C149.s10180c149f1");
    check_field_offset(lv, s10180c149f2, ABISELECT(32,24), "S10180C149.s10180c149f2");
    check_field_offset(lv, s10180c149f3, ABISELECT(48,36), "S10180C149.s10180c149f3");
    check_field_offset(lv, s10180c149f4, ABISELECT(64,48), "S10180C149.s10180c149f4");
    check_field_offset(lv, s10180c149f5, ABISELECT(80,60), "S10180C149.s10180c149f5");
    check_field_offset(lv, s10180c149f6, ABISELECT(96,68), "S10180C149.s10180c149f6");
    test_class_info(&lv, &cd_S10180C149);
    dp->~S10180C149();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C149(Test_S10180C149, "S10180C149", ABISELECT(112,84));

#else // __cplusplus

extern void _ZN10S10180C149C1Ev();
extern void _ZN10S10180C149D1Ev();
Name_Map name_map_S10180C149[] = {
  NSPAIR(_ZN10S10180C149C1Ev),
  NSPAIR(_ZN10S10180C149D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S10180C149[];
extern void _ZN10S10180C149D1Ev();
extern void _ZN10S10180C149D0Ev();
static  VTBL_ENTRY vtc_S10180C149[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C149[0]),
  (VTBL_ENTRY)&_ZN10S10180C149D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C149D0Ev,
};
extern VTBL_ENTRY _ZTI10S10180C149[];
extern  VTBL_ENTRY _ZTV10S10180C149[];
Class_Descriptor cd_S10180C149 = {  "S10180C149", // class name
  0,0,//no base classes
  &(vtc_S10180C149[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,84), // object size
  NSPAIRA(_ZTI10S10180C149),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S10180C149),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C144  : S10180C145 {
  ::S10180C149 s10180c144f0;
  void *s10180c144f1;
  virtual  ~S10180C144(); // _ZN10S10180C144D1Ev
  virtual void  v282(); // _ZN10S10180C1444v282Ev
  virtual void  v283(); // _ZN10S10180C1444v283Ev
  virtual void  v284(); // _ZN10S10180C1444v284Ev
  virtual void  v285(); // _ZN10S10180C1444v285Ev
  virtual void  v286(); // _ZN10S10180C1444v286Ev
  virtual void  v287(); // _ZN10S10180C1444v287Ev
  virtual void  v288(); // _ZN10S10180C1444v288Ev
  virtual void  v289(); // _ZN10S10180C1444v289Ev
  virtual void  v290(); // _ZN10S10180C1444v290Ev
  virtual void  v291(); // _ZN10S10180C1444v291Ev
  virtual void  v292(); // _ZN10S10180C1444v292Ev
  virtual void  v293(); // _ZN10S10180C1444v293Ev
  virtual void  v294(); // _ZN10S10180C1444v294Ev
  virtual void  v295(); // _ZN10S10180C1444v295Ev
  virtual void  v296(); // _ZN10S10180C1444v296Ev
  virtual void  v297(); // _ZN10S10180C1444v297Ev
  virtual void  v298(); // _ZN10S10180C1444v298Ev
  virtual void  v299(); // _ZN10S10180C1444v299Ev
  virtual void  v300(); // _ZN10S10180C1444v300Ev
  S10180C144(); // tgen
};
//SIG(-1 S10180C144) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp[2] FC7{ m Fp} Fc[2] Fp FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC11{ m FC12{ m FL}} FC11 FC9 FC9} FC13{ m FC14{ m Fp Fi FC5} Fi} Fp[4] FC15{ m FC16{ m Fp Fi[2] FC6} Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC17{ vd m Fi[2] FC14 FC14 FC14 FC14 FC18{ m Fp[2]} FL[2]} Fp}


 S10180C144 ::~S10180C144(){ note_dtor("S10180C144", this);}
void  S10180C144 ::v282(){vfunc_called(this, "_ZN10S10180C1444v282Ev");}
void  S10180C144 ::v283(){vfunc_called(this, "_ZN10S10180C1444v283Ev");}
void  S10180C144 ::v284(){vfunc_called(this, "_ZN10S10180C1444v284Ev");}
void  S10180C144 ::v285(){vfunc_called(this, "_ZN10S10180C1444v285Ev");}
void  S10180C144 ::v286(){vfunc_called(this, "_ZN10S10180C1444v286Ev");}
void  S10180C144 ::v287(){vfunc_called(this, "_ZN10S10180C1444v287Ev");}
void  S10180C144 ::v288(){vfunc_called(this, "_ZN10S10180C1444v288Ev");}
void  S10180C144 ::v289(){vfunc_called(this, "_ZN10S10180C1444v289Ev");}
void  S10180C144 ::v290(){vfunc_called(this, "_ZN10S10180C1444v290Ev");}
void  S10180C144 ::v291(){vfunc_called(this, "_ZN10S10180C1444v291Ev");}
void  S10180C144 ::v292(){vfunc_called(this, "_ZN10S10180C1444v292Ev");}
void  S10180C144 ::v293(){vfunc_called(this, "_ZN10S10180C1444v293Ev");}
void  S10180C144 ::v294(){vfunc_called(this, "_ZN10S10180C1444v294Ev");}
void  S10180C144 ::v295(){vfunc_called(this, "_ZN10S10180C1444v295Ev");}
void  S10180C144 ::v296(){vfunc_called(this, "_ZN10S10180C1444v296Ev");}
void  S10180C144 ::v297(){vfunc_called(this, "_ZN10S10180C1444v297Ev");}
void  S10180C144 ::v298(){vfunc_called(this, "_ZN10S10180C1444v298Ev");}
void  S10180C144 ::v299(){vfunc_called(this, "_ZN10S10180C1444v299Ev");}
void  S10180C144 ::v300(){vfunc_called(this, "_ZN10S10180C1444v300Ev");}
S10180C144 ::S10180C144(){ note_ctor("S10180C144", this);} // tgen

static void Test_S10180C144()
{
  extern Class_Descriptor cd_S10180C144;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10180C144, buf);
    S10180C144 *dp, &lv = *(dp=new (buf) S10180C144());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10180C144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C144)");
    check_base_class_offset(lv, (S10180C17*)(S10180C145*), 0, "S10180C144");
    check_base_class_offset(lv, (S10180C145*), 0, "S10180C144");
    check_field_offset(lv, s10180c144f0, ABISELECT(264,188), "S10180C144.s10180c144f0");
    check_field_offset(lv, s10180c144f1, ABISELECT(376,272), "S10180C144.s10180c144f1");
    test_class_info(&lv, &cd_S10180C144);
    dp->~S10180C144();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C144(Test_S10180C144, "S10180C144", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10180C144C1Ev();
extern void _ZN10S10180C144D1Ev();
Name_Map name_map_S10180C144[] = {
  NSPAIR(_ZN10S10180C144C1Ev),
  NSPAIR(_ZN10S10180C144D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C145;
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
static Base_Class bases_S10180C144[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C144[];
extern void _ZN10S10180C144D1Ev();
extern void _ZN10S10180C144D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
extern void _ZN10S10180C1444v282Ev();
extern void _ZN10S10180C1444v283Ev();
extern void _ZN10S10180C1444v284Ev();
extern void _ZN10S10180C1444v285Ev();
extern void _ZN10S10180C1444v286Ev();
extern void _ZN10S10180C1444v287Ev();
extern void _ZN10S10180C1444v288Ev();
extern void _ZN10S10180C1444v289Ev();
extern void _ZN10S10180C1444v290Ev();
extern void _ZN10S10180C1444v291Ev();
extern void _ZN10S10180C1444v292Ev();
extern void _ZN10S10180C1444v293Ev();
extern void _ZN10S10180C1444v294Ev();
extern void _ZN10S10180C1444v295Ev();
extern void _ZN10S10180C1444v296Ev();
extern void _ZN10S10180C1444v297Ev();
extern void _ZN10S10180C1444v298Ev();
extern void _ZN10S10180C1444v299Ev();
extern void _ZN10S10180C1444v300Ev();
static  VTBL_ENTRY vtc_S10180C144[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C144[0]),
  (VTBL_ENTRY)&_ZN10S10180C144D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C144D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v300Ev,
};
extern VTBL_ENTRY _ZTI10S10180C144[];
extern  VTBL_ENTRY _ZTV10S10180C144[];
Class_Descriptor cd_S10180C144 = {  "S10180C144", // class name
  bases_S10180C144, 2,
  &(vtc_S10180C144[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10180C144),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C144),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C143  : S10180C144 {
  int s10180c143f0[3];
  virtual  ~S10180C143(); // _ZN10S10180C143D1Ev
  virtual void  v253(); // _ZN10S10180C1434v253Ev
  virtual void  v254(); // _ZN10S10180C1434v254Ev
  virtual void  v255(); // _ZN10S10180C1434v255Ev
  virtual void  v256(); // _ZN10S10180C1434v256Ev
  virtual void  v257(); // _ZN10S10180C1434v257Ev
  virtual void  v258(); // _ZN10S10180C1434v258Ev
  virtual void  v259(); // _ZN10S10180C1434v259Ev
  virtual void  v260(); // _ZN10S10180C1434v260Ev
  virtual void  v261(); // _ZN10S10180C1434v261Ev
  S10180C143(); // tgen
};
//SIG(-1 S10180C143) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC5 Fc} vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fp[2] FC8{ m Fp} Fc[2] Fp FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC12{ m FC13{ m FL}} FC12 FC10 FC10} FC14{ m FC15{ m Fp Fi FC6} Fi} Fp[4] FC16{ m FC17{ m Fp Fi[2] FC7} Fp[2]}} vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 FC18{ vd m Fi[2] FC15 FC15 FC15 FC15 FC19{ m Fp[2]} FL[2]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fi[3]}


 S10180C143 ::~S10180C143(){ note_dtor("S10180C143", this);}
void  S10180C143 ::v253(){vfunc_called(this, "_ZN10S10180C1434v253Ev");}
void  S10180C143 ::v254(){vfunc_called(this, "_ZN10S10180C1434v254Ev");}
void  S10180C143 ::v255(){vfunc_called(this, "_ZN10S10180C1434v255Ev");}
void  S10180C143 ::v256(){vfunc_called(this, "_ZN10S10180C1434v256Ev");}
void  S10180C143 ::v257(){vfunc_called(this, "_ZN10S10180C1434v257Ev");}
void  S10180C143 ::v258(){vfunc_called(this, "_ZN10S10180C1434v258Ev");}
void  S10180C143 ::v259(){vfunc_called(this, "_ZN10S10180C1434v259Ev");}
void  S10180C143 ::v260(){vfunc_called(this, "_ZN10S10180C1434v260Ev");}
void  S10180C143 ::v261(){vfunc_called(this, "_ZN10S10180C1434v261Ev");}
S10180C143 ::S10180C143(){ note_ctor("S10180C143", this);} // tgen

static void Test_S10180C143()
{
  extern Class_Descriptor cd_S10180C143;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,73)];
    init_test(&cd_S10180C143, buf);
    S10180C143 *dp, &lv = *(dp=new (buf) S10180C143());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,288), "sizeof(S10180C143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C143)");
    check_base_class_offset(lv, (S10180C17*)(S10180C145*)(S10180C144*), 0, "S10180C143");
    check_base_class_offset(lv, (S10180C145*)(S10180C144*), 0, "S10180C143");
    check_base_class_offset(lv, (S10180C144*), 0, "S10180C143");
    check_field_offset(lv, s10180c143f0, ABISELECT(384,276), "S10180C143.s10180c143f0");
    test_class_info(&lv, &cd_S10180C143);
    dp->~S10180C143();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C143(Test_S10180C143, "S10180C143", ABISELECT(400,288));

#else // __cplusplus

extern void _ZN10S10180C143C1Ev();
extern void _ZN10S10180C143D1Ev();
Name_Map name_map_S10180C143[] = {
  NSPAIR(_ZN10S10180C143C1Ev),
  NSPAIR(_ZN10S10180C143D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C145;
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
extern Class_Descriptor cd_S10180C144;
extern VTBL_ENTRY _ZTI10S10180C144[];
extern  VTBL_ENTRY _ZTV10S10180C144[];
static Base_Class bases_S10180C143[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10180C144,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C143[];
extern void _ZN10S10180C143D1Ev();
extern void _ZN10S10180C143D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
extern void _ZN10S10180C1444v282Ev();
extern void _ZN10S10180C1444v283Ev();
extern void _ZN10S10180C1444v284Ev();
extern void _ZN10S10180C1444v285Ev();
extern void _ZN10S10180C1444v286Ev();
extern void _ZN10S10180C1444v287Ev();
extern void _ZN10S10180C1444v288Ev();
extern void _ZN10S10180C1444v289Ev();
extern void _ZN10S10180C1444v290Ev();
extern void _ZN10S10180C1444v291Ev();
extern void _ZN10S10180C1444v292Ev();
extern void _ZN10S10180C1444v293Ev();
extern void _ZN10S10180C1444v294Ev();
extern void _ZN10S10180C1444v295Ev();
extern void _ZN10S10180C1444v296Ev();
extern void _ZN10S10180C1444v297Ev();
extern void _ZN10S10180C1444v298Ev();
extern void _ZN10S10180C1444v299Ev();
extern void _ZN10S10180C1444v300Ev();
extern void _ZN10S10180C1434v253Ev();
extern void _ZN10S10180C1434v254Ev();
extern void _ZN10S10180C1434v255Ev();
extern void _ZN10S10180C1434v256Ev();
extern void _ZN10S10180C1434v257Ev();
extern void _ZN10S10180C1434v258Ev();
extern void _ZN10S10180C1434v259Ev();
extern void _ZN10S10180C1434v260Ev();
extern void _ZN10S10180C1434v261Ev();
static  VTBL_ENTRY vtc_S10180C143[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C143[0]),
  (VTBL_ENTRY)&_ZN10S10180C143D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C143D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v300Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v253Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v254Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v255Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v256Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v257Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v258Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v259Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v260Ev,
  (VTBL_ENTRY)&_ZN10S10180C1434v261Ev,
};
extern VTBL_ENTRY _ZTI10S10180C143[];
extern  VTBL_ENTRY _ZTV10S10180C143[];
Class_Descriptor cd_S10180C143 = {  "S10180C143", // class name
  bases_S10180C143, 3,
  &(vtc_S10180C143[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,288), // object size
  NSPAIRA(_ZTI10S10180C143),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C143),52, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C151  : S10180C145 {
  ::S10180C149 s10180c151f0;
  void *s10180c151f1;
  virtual  ~S10180C151(); // _ZN10S10180C151D1Ev
  virtual void  v301(); // _ZN10S10180C1514v301Ev
  virtual void  v302(); // _ZN10S10180C1514v302Ev
  virtual void  v303(); // _ZN10S10180C1514v303Ev
  virtual void  v304(); // _ZN10S10180C1514v304Ev
  virtual void  v305(); // _ZN10S10180C1514v305Ev
  virtual void  v306(); // _ZN10S10180C1514v306Ev
  virtual void  v307(); // _ZN10S10180C1514v307Ev
  virtual void  v308(); // _ZN10S10180C1514v308Ev
  virtual void  v309(); // _ZN10S10180C1514v309Ev
  virtual void  v310(); // _ZN10S10180C1514v310Ev
  virtual void  v311(); // _ZN10S10180C1514v311Ev
  virtual void  v312(); // _ZN10S10180C1514v312Ev
  virtual void  v313(); // _ZN10S10180C1514v313Ev
  virtual void  v314(); // _ZN10S10180C1514v314Ev
  virtual void  v315(); // _ZN10S10180C1514v315Ev
  virtual void  v316(); // _ZN10S10180C1514v316Ev
  virtual void  v317(); // _ZN10S10180C1514v317Ev
  virtual void  v318(); // _ZN10S10180C1514v318Ev
  virtual void  v319(); // _ZN10S10180C1514v319Ev
  S10180C151(); // tgen
};
//SIG(-1 S10180C151) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp[2] FC7{ m Fp} Fc[2] Fp FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC11{ m FC12{ m FL}} FC11 FC9 FC9} FC13{ m FC14{ m Fp Fi FC5} Fi} Fp[4] FC15{ m FC16{ m Fp Fi[2] FC6} Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC17{ vd m Fi[2] FC14 FC14 FC14 FC14 FC18{ m Fp[2]} FL[2]} Fp}


 S10180C151 ::~S10180C151(){ note_dtor("S10180C151", this);}
void  S10180C151 ::v301(){vfunc_called(this, "_ZN10S10180C1514v301Ev");}
void  S10180C151 ::v302(){vfunc_called(this, "_ZN10S10180C1514v302Ev");}
void  S10180C151 ::v303(){vfunc_called(this, "_ZN10S10180C1514v303Ev");}
void  S10180C151 ::v304(){vfunc_called(this, "_ZN10S10180C1514v304Ev");}
void  S10180C151 ::v305(){vfunc_called(this, "_ZN10S10180C1514v305Ev");}
void  S10180C151 ::v306(){vfunc_called(this, "_ZN10S10180C1514v306Ev");}
void  S10180C151 ::v307(){vfunc_called(this, "_ZN10S10180C1514v307Ev");}
void  S10180C151 ::v308(){vfunc_called(this, "_ZN10S10180C1514v308Ev");}
void  S10180C151 ::v309(){vfunc_called(this, "_ZN10S10180C1514v309Ev");}
void  S10180C151 ::v310(){vfunc_called(this, "_ZN10S10180C1514v310Ev");}
void  S10180C151 ::v311(){vfunc_called(this, "_ZN10S10180C1514v311Ev");}
void  S10180C151 ::v312(){vfunc_called(this, "_ZN10S10180C1514v312Ev");}
void  S10180C151 ::v313(){vfunc_called(this, "_ZN10S10180C1514v313Ev");}
void  S10180C151 ::v314(){vfunc_called(this, "_ZN10S10180C1514v314Ev");}
void  S10180C151 ::v315(){vfunc_called(this, "_ZN10S10180C1514v315Ev");}
void  S10180C151 ::v316(){vfunc_called(this, "_ZN10S10180C1514v316Ev");}
void  S10180C151 ::v317(){vfunc_called(this, "_ZN10S10180C1514v317Ev");}
void  S10180C151 ::v318(){vfunc_called(this, "_ZN10S10180C1514v318Ev");}
void  S10180C151 ::v319(){vfunc_called(this, "_ZN10S10180C1514v319Ev");}
S10180C151 ::S10180C151(){ note_ctor("S10180C151", this);} // tgen

static void Test_S10180C151()
{
  extern Class_Descriptor cd_S10180C151;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10180C151, buf);
    S10180C151 *dp, &lv = *(dp=new (buf) S10180C151());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10180C151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C151)");
    check_base_class_offset(lv, (S10180C17*)(S10180C145*), 0, "S10180C151");
    check_base_class_offset(lv, (S10180C145*), 0, "S10180C151");
    check_field_offset(lv, s10180c151f0, ABISELECT(264,188), "S10180C151.s10180c151f0");
    check_field_offset(lv, s10180c151f1, ABISELECT(376,272), "S10180C151.s10180c151f1");
    test_class_info(&lv, &cd_S10180C151);
    dp->~S10180C151();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C151(Test_S10180C151, "S10180C151", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10180C151C1Ev();
extern void _ZN10S10180C151D1Ev();
Name_Map name_map_S10180C151[] = {
  NSPAIR(_ZN10S10180C151C1Ev),
  NSPAIR(_ZN10S10180C151D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C145;
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
static Base_Class bases_S10180C151[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C151[];
extern void _ZN10S10180C151D1Ev();
extern void _ZN10S10180C151D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
extern void _ZN10S10180C1514v301Ev();
extern void _ZN10S10180C1514v302Ev();
extern void _ZN10S10180C1514v303Ev();
extern void _ZN10S10180C1514v304Ev();
extern void _ZN10S10180C1514v305Ev();
extern void _ZN10S10180C1514v306Ev();
extern void _ZN10S10180C1514v307Ev();
extern void _ZN10S10180C1514v308Ev();
extern void _ZN10S10180C1514v309Ev();
extern void _ZN10S10180C1514v310Ev();
extern void _ZN10S10180C1514v311Ev();
extern void _ZN10S10180C1514v312Ev();
extern void _ZN10S10180C1514v313Ev();
extern void _ZN10S10180C1514v314Ev();
extern void _ZN10S10180C1514v315Ev();
extern void _ZN10S10180C1514v316Ev();
extern void _ZN10S10180C1514v317Ev();
extern void _ZN10S10180C1514v318Ev();
extern void _ZN10S10180C1514v319Ev();
static  VTBL_ENTRY vtc_S10180C151[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C151[0]),
  (VTBL_ENTRY)&_ZN10S10180C151D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C151D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v301Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v302Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v303Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v304Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v305Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v306Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v307Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v308Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v309Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v310Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v311Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v312Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v313Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v314Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v315Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v316Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v317Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v318Ev,
  (VTBL_ENTRY)&_ZN10S10180C1514v319Ev,
};
extern VTBL_ENTRY _ZTI10S10180C151[];
extern  VTBL_ENTRY _ZTV10S10180C151[];
Class_Descriptor cd_S10180C151 = {  "S10180C151", // class name
  bases_S10180C151, 2,
  &(vtc_S10180C151[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10180C151),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C151),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C152  : S10180C144 {
  virtual  ~S10180C152(); // _ZN10S10180C152D1Ev
  virtual void  v320(); // _ZN10S10180C1524v320Ev
  virtual void  v321(); // _ZN10S10180C1524v321Ev
  S10180C152(); // tgen
};
//SIG(-1 S10180C152) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC5 Fc} vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] FC8{ m Fp} Fc[2] Fp FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC12{ m FC13{ m FL}} FC12 FC10 FC10} FC14{ m FC15{ m Fp Fi FC6} Fi} Fp[4] FC16{ m FC17{ m Fp Fi[2] FC7} Fp[2]}} vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC18{ vd m Fi[2] FC15 FC15 FC15 FC15 FC19{ m Fp[2]} FL[2]} Fp} vd v1 v2}


 S10180C152 ::~S10180C152(){ note_dtor("S10180C152", this);}
void  S10180C152 ::v320(){vfunc_called(this, "_ZN10S10180C1524v320Ev");}
void  S10180C152 ::v321(){vfunc_called(this, "_ZN10S10180C1524v321Ev");}
S10180C152 ::S10180C152(){ note_ctor("S10180C152", this);} // tgen

static void Test_S10180C152()
{
  extern Class_Descriptor cd_S10180C152;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10180C152, buf);
    S10180C152 *dp, &lv = *(dp=new (buf) S10180C152());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10180C152)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C152)");
    check_base_class_offset(lv, (S10180C17*)(S10180C145*)(S10180C144*), 0, "S10180C152");
    check_base_class_offset(lv, (S10180C145*)(S10180C144*), 0, "S10180C152");
    check_base_class_offset(lv, (S10180C144*), 0, "S10180C152");
    test_class_info(&lv, &cd_S10180C152);
    dp->~S10180C152();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C152(Test_S10180C152, "S10180C152", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10180C152C1Ev();
extern void _ZN10S10180C152D1Ev();
Name_Map name_map_S10180C152[] = {
  NSPAIR(_ZN10S10180C152C1Ev),
  NSPAIR(_ZN10S10180C152D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C145;
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
extern Class_Descriptor cd_S10180C144;
extern VTBL_ENTRY _ZTI10S10180C144[];
extern  VTBL_ENTRY _ZTV10S10180C144[];
static Base_Class bases_S10180C152[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10180C144,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C152[];
extern void _ZN10S10180C152D1Ev();
extern void _ZN10S10180C152D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
extern void _ZN10S10180C1444v282Ev();
extern void _ZN10S10180C1444v283Ev();
extern void _ZN10S10180C1444v284Ev();
extern void _ZN10S10180C1444v285Ev();
extern void _ZN10S10180C1444v286Ev();
extern void _ZN10S10180C1444v287Ev();
extern void _ZN10S10180C1444v288Ev();
extern void _ZN10S10180C1444v289Ev();
extern void _ZN10S10180C1444v290Ev();
extern void _ZN10S10180C1444v291Ev();
extern void _ZN10S10180C1444v292Ev();
extern void _ZN10S10180C1444v293Ev();
extern void _ZN10S10180C1444v294Ev();
extern void _ZN10S10180C1444v295Ev();
extern void _ZN10S10180C1444v296Ev();
extern void _ZN10S10180C1444v297Ev();
extern void _ZN10S10180C1444v298Ev();
extern void _ZN10S10180C1444v299Ev();
extern void _ZN10S10180C1444v300Ev();
extern void _ZN10S10180C1524v320Ev();
extern void _ZN10S10180C1524v321Ev();
static  VTBL_ENTRY vtc_S10180C152[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C152[0]),
  (VTBL_ENTRY)&_ZN10S10180C152D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C152D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v300Ev,
  (VTBL_ENTRY)&_ZN10S10180C1524v320Ev,
  (VTBL_ENTRY)&_ZN10S10180C1524v321Ev,
};
extern VTBL_ENTRY _ZTI10S10180C152[];
extern  VTBL_ENTRY _ZTV10S10180C152[];
Class_Descriptor cd_S10180C152 = {  "S10180C152", // class name
  bases_S10180C152, 3,
  &(vtc_S10180C152[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10180C152),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C152),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C154  : S10180C145 {
  int s10180c154f0[2];
  __tsi64 s10180c154f1;
  int s10180c154f2;
  virtual  ~S10180C154(); // _ZN10S10180C154D1Ev
  virtual void  v324(); // _ZN10S10180C1544v324Ev
  virtual void  v325(); // _ZN10S10180C1544v325Ev
  virtual void  v326(); // _ZN10S10180C1544v326Ev
  virtual void  v327(); // _ZN10S10180C1544v327Ev
  virtual void  v328(); // _ZN10S10180C1544v328Ev
  virtual void  v329(); // _ZN10S10180C1544v329Ev
  virtual void  v330(); // _ZN10S10180C1544v330Ev
  virtual void  v331(); // _ZN10S10180C1544v331Ev
  virtual void  v332(); // _ZN10S10180C1544v332Ev
  virtual void  v333(); // _ZN10S10180C1544v333Ev
  virtual void  v334(); // _ZN10S10180C1544v334Ev
  virtual void  v335(); // _ZN10S10180C1544v335Ev
  S10180C154(); // tgen
};
//SIG(1 S10180C154) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp[2] FC7{ m Fp} Fc[2] Fp FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC11{ m FC12{ m FL}} FC11 FC9 FC9} FC13{ m FC14{ m Fp Fi FC5} Fi} Fp[4] FC15{ m FC16{ m Fp Fi[2] FC6} Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fi[2] FL Fi}


 S10180C154 ::~S10180C154(){ note_dtor("S10180C154", this);}
void  S10180C154 ::v324(){vfunc_called(this, "_ZN10S10180C1544v324Ev");}
void  S10180C154 ::v325(){vfunc_called(this, "_ZN10S10180C1544v325Ev");}
void  S10180C154 ::v326(){vfunc_called(this, "_ZN10S10180C1544v326Ev");}
void  S10180C154 ::v327(){vfunc_called(this, "_ZN10S10180C1544v327Ev");}
void  S10180C154 ::v328(){vfunc_called(this, "_ZN10S10180C1544v328Ev");}
void  S10180C154 ::v329(){vfunc_called(this, "_ZN10S10180C1544v329Ev");}
void  S10180C154 ::v330(){vfunc_called(this, "_ZN10S10180C1544v330Ev");}
void  S10180C154 ::v331(){vfunc_called(this, "_ZN10S10180C1544v331Ev");}
void  S10180C154 ::v332(){vfunc_called(this, "_ZN10S10180C1544v332Ev");}
void  S10180C154 ::v333(){vfunc_called(this, "_ZN10S10180C1544v333Ev");}
void  S10180C154 ::v334(){vfunc_called(this, "_ZN10S10180C1544v334Ev");}
void  S10180C154 ::v335(){vfunc_called(this, "_ZN10S10180C1544v335Ev");}
S10180C154 ::S10180C154(){ note_ctor("S10180C154", this);} // tgen

static void Test_S10180C154()
{
  extern Class_Descriptor cd_S10180C154;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,53)];
    init_test(&cd_S10180C154, buf);
    S10180C154 *dp, &lv = *(dp=new (buf) S10180C154());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,208), "sizeof(S10180C154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C154)");
    check_base_class_offset(lv, (S10180C17*)(S10180C145*), 0, "S10180C154");
    check_base_class_offset(lv, (S10180C145*), 0, "S10180C154");
    check_field_offset(lv, s10180c154f0, ABISELECT(264,188), "S10180C154.s10180c154f0");
    check_field_offset(lv, s10180c154f1, ABISELECT(272,196), "S10180C154.s10180c154f1");
    check_field_offset(lv, s10180c154f2, ABISELECT(280,204), "S10180C154.s10180c154f2");
    test_class_info(&lv, &cd_S10180C154);
    dp->~S10180C154();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C154(Test_S10180C154, "S10180C154", ABISELECT(288,208));

#else // __cplusplus

extern void _ZN10S10180C154C1Ev();
extern void _ZN10S10180C154D1Ev();
Name_Map name_map_S10180C154[] = {
  NSPAIR(_ZN10S10180C154C1Ev),
  NSPAIR(_ZN10S10180C154D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C145;
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
static Base_Class bases_S10180C154[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C154[];
extern void _ZN10S10180C154D1Ev();
extern void _ZN10S10180C154D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
extern void _ZN10S10180C1544v324Ev();
extern void _ZN10S10180C1544v325Ev();
extern void _ZN10S10180C1544v326Ev();
extern void _ZN10S10180C1544v327Ev();
extern void _ZN10S10180C1544v328Ev();
extern void _ZN10S10180C1544v329Ev();
extern void _ZN10S10180C1544v330Ev();
extern void _ZN10S10180C1544v331Ev();
extern void _ZN10S10180C1544v332Ev();
extern void _ZN10S10180C1544v333Ev();
extern void _ZN10S10180C1544v334Ev();
extern void _ZN10S10180C1544v335Ev();
static  VTBL_ENTRY vtc_S10180C154[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C154[0]),
  (VTBL_ENTRY)&_ZN10S10180C154D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C154D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v324Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v325Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v326Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v327Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v328Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v329Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v330Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v331Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v332Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v333Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v334Ev,
  (VTBL_ENTRY)&_ZN10S10180C1544v335Ev,
};
extern VTBL_ENTRY _ZTI10S10180C154[];
extern  VTBL_ENTRY _ZTV10S10180C154[];
Class_Descriptor cd_S10180C154 = {  "S10180C154", // class name
  bases_S10180C154, 2,
  &(vtc_S10180C154[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,208), // object size
  NSPAIRA(_ZTI10S10180C154),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C154),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C155  : S10180C144 {
  virtual  ~S10180C155(); // _ZN10S10180C155D1Ev
  virtual void  v336(); // _ZN10S10180C1554v336Ev
  virtual void  v337(); // _ZN10S10180C1554v337Ev
  virtual void  v338(); // _ZN10S10180C1554v338Ev
  S10180C155(); // tgen
};
//SIG(-1 S10180C155) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC5 Fc} vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp[2] FC8{ m Fp} Fc[2] Fp FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC12{ m FC13{ m FL}} FC12 FC10 FC10} FC14{ m FC15{ m Fp Fi FC6} Fi} Fp[4] FC16{ m FC17{ m Fp Fi[2] FC7} Fp[2]}} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 FC18{ vd m Fi[2] FC15 FC15 FC15 FC15 FC19{ m Fp[2]} FL[2]} Fp} vd v1 v2 v3}


 S10180C155 ::~S10180C155(){ note_dtor("S10180C155", this);}
void  S10180C155 ::v336(){vfunc_called(this, "_ZN10S10180C1554v336Ev");}
void  S10180C155 ::v337(){vfunc_called(this, "_ZN10S10180C1554v337Ev");}
void  S10180C155 ::v338(){vfunc_called(this, "_ZN10S10180C1554v338Ev");}
S10180C155 ::S10180C155(){ note_ctor("S10180C155", this);} // tgen

static void Test_S10180C155()
{
  extern Class_Descriptor cd_S10180C155;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10180C155, buf);
    S10180C155 *dp, &lv = *(dp=new (buf) S10180C155());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10180C155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C155)");
    check_base_class_offset(lv, (S10180C17*)(S10180C145*)(S10180C144*), 0, "S10180C155");
    check_base_class_offset(lv, (S10180C145*)(S10180C144*), 0, "S10180C155");
    check_base_class_offset(lv, (S10180C144*), 0, "S10180C155");
    test_class_info(&lv, &cd_S10180C155);
    dp->~S10180C155();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C155(Test_S10180C155, "S10180C155", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10180C155C1Ev();
extern void _ZN10S10180C155D1Ev();
Name_Map name_map_S10180C155[] = {
  NSPAIR(_ZN10S10180C155C1Ev),
  NSPAIR(_ZN10S10180C155D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C145;
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
extern Class_Descriptor cd_S10180C144;
extern VTBL_ENTRY _ZTI10S10180C144[];
extern  VTBL_ENTRY _ZTV10S10180C144[];
static Base_Class bases_S10180C155[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10180C144,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C155[];
extern void _ZN10S10180C155D1Ev();
extern void _ZN10S10180C155D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
extern void _ZN10S10180C1444v282Ev();
extern void _ZN10S10180C1444v283Ev();
extern void _ZN10S10180C1444v284Ev();
extern void _ZN10S10180C1444v285Ev();
extern void _ZN10S10180C1444v286Ev();
extern void _ZN10S10180C1444v287Ev();
extern void _ZN10S10180C1444v288Ev();
extern void _ZN10S10180C1444v289Ev();
extern void _ZN10S10180C1444v290Ev();
extern void _ZN10S10180C1444v291Ev();
extern void _ZN10S10180C1444v292Ev();
extern void _ZN10S10180C1444v293Ev();
extern void _ZN10S10180C1444v294Ev();
extern void _ZN10S10180C1444v295Ev();
extern void _ZN10S10180C1444v296Ev();
extern void _ZN10S10180C1444v297Ev();
extern void _ZN10S10180C1444v298Ev();
extern void _ZN10S10180C1444v299Ev();
extern void _ZN10S10180C1444v300Ev();
extern void _ZN10S10180C1554v336Ev();
extern void _ZN10S10180C1554v337Ev();
extern void _ZN10S10180C1554v338Ev();
static  VTBL_ENTRY vtc_S10180C155[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C155[0]),
  (VTBL_ENTRY)&_ZN10S10180C155D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C155D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v300Ev,
  (VTBL_ENTRY)&_ZN10S10180C1554v336Ev,
  (VTBL_ENTRY)&_ZN10S10180C1554v337Ev,
  (VTBL_ENTRY)&_ZN10S10180C1554v338Ev,
};
extern VTBL_ENTRY _ZTI10S10180C155[];
extern  VTBL_ENTRY _ZTV10S10180C155[];
Class_Descriptor cd_S10180C155 = {  "S10180C155", // class name
  bases_S10180C155, 3,
  &(vtc_S10180C155[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10180C155),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C155),46, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C157  : S10180C144 {
  virtual  ~S10180C157(); // _ZN10S10180C157D1Ev
  virtual void  v342(); // _ZN10S10180C1574v342Ev
  virtual void  v343(); // _ZN10S10180C1574v343Ev
  S10180C157(); // tgen
};
//SIG(-1 S10180C157) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC5 Fc} vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] FC8{ m Fp} Fc[2] Fp FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC12{ m FC13{ m FL}} FC12 FC10 FC10} FC14{ m FC15{ m Fp Fi FC6} Fi} Fp[4] FC16{ m FC17{ m Fp Fi[2] FC7} Fp[2]}} vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC18{ vd m Fi[2] FC15 FC15 FC15 FC15 FC19{ m Fp[2]} FL[2]} Fp} vd v1 v2}


 S10180C157 ::~S10180C157(){ note_dtor("S10180C157", this);}
void  S10180C157 ::v342(){vfunc_called(this, "_ZN10S10180C1574v342Ev");}
void  S10180C157 ::v343(){vfunc_called(this, "_ZN10S10180C1574v343Ev");}
S10180C157 ::S10180C157(){ note_ctor("S10180C157", this);} // tgen

static void Test_S10180C157()
{
  extern Class_Descriptor cd_S10180C157;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10180C157, buf);
    S10180C157 *dp, &lv = *(dp=new (buf) S10180C157());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10180C157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C157)");
    check_base_class_offset(lv, (S10180C17*)(S10180C145*)(S10180C144*), 0, "S10180C157");
    check_base_class_offset(lv, (S10180C145*)(S10180C144*), 0, "S10180C157");
    check_base_class_offset(lv, (S10180C144*), 0, "S10180C157");
    test_class_info(&lv, &cd_S10180C157);
    dp->~S10180C157();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C157(Test_S10180C157, "S10180C157", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10180C157C1Ev();
extern void _ZN10S10180C157D1Ev();
Name_Map name_map_S10180C157[] = {
  NSPAIR(_ZN10S10180C157C1Ev),
  NSPAIR(_ZN10S10180C157D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C145;
extern VTBL_ENTRY _ZTI10S10180C145[];
extern  VTBL_ENTRY _ZTV10S10180C145[];
extern Class_Descriptor cd_S10180C144;
extern VTBL_ENTRY _ZTI10S10180C144[];
extern  VTBL_ENTRY _ZTV10S10180C144[];
static Base_Class bases_S10180C157[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10180C144,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C157[];
extern void _ZN10S10180C157D1Ev();
extern void _ZN10S10180C157D0Ev();
extern void _ZN10S10180C1454v262Ev();
extern void _ZN10S10180C1454v263Ev();
extern void _ZN10S10180C1454v264Ev();
extern void _ZN10S10180C1454v265Ev();
extern void _ZN10S10180C1454v266Ev();
extern void _ZN10S10180C1454v267Ev();
extern void _ZN10S10180C1454v268Ev();
extern void _ZN10S10180C1454v269Ev();
extern void _ZN10S10180C1454v270Ev();
extern void _ZN10S10180C1454v271Ev();
extern void _ZN10S10180C1454v272Ev();
extern void _ZN10S10180C1454v273Ev();
extern void _ZN10S10180C1454v274Ev();
extern void _ZN10S10180C1454v275Ev();
extern void _ZN10S10180C1454v276Ev();
extern void _ZN10S10180C1454v277Ev();
extern void _ZN10S10180C1454v278Ev();
extern void _ZN10S10180C1454v279Ev();
extern void _ZN10S10180C1454v280Ev();
extern void _ZN10S10180C1454v281Ev();
extern void _ZN10S10180C1444v282Ev();
extern void _ZN10S10180C1444v283Ev();
extern void _ZN10S10180C1444v284Ev();
extern void _ZN10S10180C1444v285Ev();
extern void _ZN10S10180C1444v286Ev();
extern void _ZN10S10180C1444v287Ev();
extern void _ZN10S10180C1444v288Ev();
extern void _ZN10S10180C1444v289Ev();
extern void _ZN10S10180C1444v290Ev();
extern void _ZN10S10180C1444v291Ev();
extern void _ZN10S10180C1444v292Ev();
extern void _ZN10S10180C1444v293Ev();
extern void _ZN10S10180C1444v294Ev();
extern void _ZN10S10180C1444v295Ev();
extern void _ZN10S10180C1444v296Ev();
extern void _ZN10S10180C1444v297Ev();
extern void _ZN10S10180C1444v298Ev();
extern void _ZN10S10180C1444v299Ev();
extern void _ZN10S10180C1444v300Ev();
extern void _ZN10S10180C1574v342Ev();
extern void _ZN10S10180C1574v343Ev();
static  VTBL_ENTRY vtc_S10180C157[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C157[0]),
  (VTBL_ENTRY)&_ZN10S10180C157D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C157D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10180C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10180C1444v300Ev,
  (VTBL_ENTRY)&_ZN10S10180C1574v342Ev,
  (VTBL_ENTRY)&_ZN10S10180C1574v343Ev,
};
extern VTBL_ENTRY _ZTI10S10180C157[];
extern  VTBL_ENTRY _ZTV10S10180C157[];
Class_Descriptor cd_S10180C157 = {  "S10180C157", // class name
  bases_S10180C157, 3,
  &(vtc_S10180C157[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10180C157),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C157),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C158  : S10180C17 , S10180C2 , S10180C11 {
  void *s10180c158f0;
  ::S10180C135 s10180c158f1;
  ::S10180C101 s10180c158f2;
  ::S10180C68 s10180c158f3;
  ::S10180C75 s10180c158f4;
  void *s10180c158f5;
  __tsi64 s10180c158f6;
  ::S10180C13 s10180c158f7;
  virtual  ~S10180C158(); // _ZN10S10180C158D1Ev
  virtual void  v344(); // _ZN10S10180C1584v344Ev
  virtual void  v345(); // _ZN10S10180C1584v345Ev
  virtual void  v346(); // _ZN10S10180C1584v346Ev
  virtual void  v347(); // _ZN10S10180C1584v347Ev
  S10180C158(); // tgen
};
//SIG(-1 S10180C158) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v5} BC7{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fp FC8{ m FC9{ m Fp Fi FC4} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4 Fp FC11{ BC6 vd v30 Fp[2] FC12{ m Fp Fi FC13{ m} FC14{ m}} FC15{ BC2 vd v31 v32 v33 v34 FC16{ m Fp[2] FC9 FC17{ m Fp Fi[2] FC13} Fi[2]}}} FC18{ BC2 vd v35 Fp FC8 FC8 Fp Fi FC19{ m FC20{ m FL[2]}}} FC21{ BC22{ BC2 vd v38 v39 v40 v41 FC23{ m Fp FC8 FC9 FC9 Fi[3] FC19 Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v36 v37} FC24{ BC22 v42} Fp FL FC9}


 S10180C158 ::~S10180C158(){ note_dtor("S10180C158", this);}
void  S10180C158 ::v344(){vfunc_called(this, "_ZN10S10180C1584v344Ev");}
void  S10180C158 ::v345(){vfunc_called(this, "_ZN10S10180C1584v345Ev");}
void  S10180C158 ::v346(){vfunc_called(this, "_ZN10S10180C1584v346Ev");}
void  S10180C158 ::v347(){vfunc_called(this, "_ZN10S10180C1584v347Ev");}
S10180C158 ::S10180C158(){ note_ctor("S10180C158", this);} // tgen

static void Test_S10180C158()
{
  extern Class_Descriptor cd_S10180C158;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(119,163)];
    init_test(&cd_S10180C158, buf);
    S10180C158 *dp, &lv = *(dp=new (buf) S10180C158());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(944,648), "sizeof(S10180C158)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C158)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C158");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(48,32), "S10180C158");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(56,36), "S10180C158");
    check_field_offset(lv, s10180c158f0, ABISELECT(152,100), "S10180C158.s10180c158f0");
    check_field_offset(lv, s10180c158f1, ABISELECT(160,104), "S10180C158.s10180c158f1");
    check_field_offset(lv, s10180c158f2, ABISELECT(312,204), "S10180C158.s10180c158f2");
    check_field_offset(lv, s10180c158f3, ABISELECT(448,296), "S10180C158.s10180c158f3");
    check_field_offset(lv, s10180c158f4, ABISELECT(680,460), "S10180C158.s10180c158f4");
    check_field_offset(lv, s10180c158f5, ABISELECT(912,624), "S10180C158.s10180c158f5");
    check_field_offset(lv, s10180c158f6, ABISELECT(920,628), "S10180C158.s10180c158f6");
    check_field_offset(lv, s10180c158f7, ABISELECT(928,636), "S10180C158.s10180c158f7");
    test_class_info(&lv, &cd_S10180C158);
    dp->~S10180C158();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C158(Test_S10180C158, "S10180C158", ABISELECT(944,648));

#else // __cplusplus

extern void _ZN10S10180C158C1Ev();
extern void _ZN10S10180C158D1Ev();
Name_Map name_map_S10180C158[] = {
  NSPAIR(_ZN10S10180C158C1Ev),
  NSPAIR(_ZN10S10180C158D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C158[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C158[];
extern void _ZN10S10180C158D1Ev();
extern void _ZN10S10180C158D0Ev();
extern void _ZN10S10180C1584v344Ev();
extern void _ZN10S10180C1584v345Ev();
extern void _ZN10S10180C1584v346Ev();
extern void _ZN10S10180C1584v347Ev();
extern void ABISELECT(_ZThn48_N10S10180C158D1Ev,_ZThn32_N10S10180C158D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C158D0Ev,_ZThn32_N10S10180C158D0Ev)();
extern void _ZN8S10180C22v7Ev();
extern void ABISELECT(_ZThn56_N10S10180C158D1Ev,_ZThn36_N10S10180C158D1Ev)();
extern void ABISELECT(_ZThn56_N10S10180C158D0Ev,_ZThn36_N10S10180C158D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
static  VTBL_ENTRY vtc_S10180C158[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C158[0]),
  (VTBL_ENTRY)&_ZN10S10180C158D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C158D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1584v344Ev,
  (VTBL_ENTRY)&_ZN10S10180C1584v345Ev,
  (VTBL_ENTRY)&_ZN10S10180C1584v346Ev,
  (VTBL_ENTRY)&_ZN10S10180C1584v347Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C158[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C158D1Ev,_ZThn32_N10S10180C158D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C158D0Ev,_ZThn32_N10S10180C158D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI10S10180C158[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N10S10180C158D1Ev,_ZThn36_N10S10180C158D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N10S10180C158D0Ev,_ZThn36_N10S10180C158D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
};
extern VTBL_ENTRY _ZTI10S10180C158[];
extern  VTBL_ENTRY _ZTV10S10180C158[];
Class_Descriptor cd_S10180C158 = {  "S10180C158", // class name
  bases_S10180C158, 3,
  &(vtc_S10180C158[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(944,648), // object size
  NSPAIRA(_ZTI10S10180C158),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV10S10180C158),41, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C159  {
  __tsi64 s10180c159f0;
  char s10180c159f1;
  __tsi64 s10180c159f2[2];
  ::S10180C114 s10180c159f3;
  void  mf10180c159(); // _ZN10S10180C15911mf10180c159Ev
};
//SIG(-1 S10180C159) C1{ m FL Fc FL[2] FC2{ m Fp}}


void  S10180C159 ::mf10180c159(){}

static void Test_S10180C159()
{
  {
    init_simple_test("S10180C159");
    S10180C159 lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S10180C159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C159)");
    check_field_offset(lv, s10180c159f0, 0, "S10180C159.s10180c159f0");
    check_field_offset(lv, s10180c159f1, 8, "S10180C159.s10180c159f1");
    check_field_offset(lv, s10180c159f2, ABISELECT(16,12), "S10180C159.s10180c159f2");
    check_field_offset(lv, s10180c159f3, ABISELECT(32,28), "S10180C159.s10180c159f3");
  }
}
static Arrange_To_Call_Me vS10180C159(Test_S10180C159, "S10180C159", ABISELECT(40,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C160  : S10180C17 , S10180C11 , S10180C2 {
  int s10180c160f0;
  ::S10180C86 s10180c160f1;
  ::S10180C31 s10180c160f2;
  ::S10180C105 s10180c160f3;
  ::S10180C106 s10180c160f4;
  ::S10180C87 s10180c160f5;
  ::S10180C68 s10180c160f6;
  ::S10180C111 s10180c160f7;
  void *s10180c160f8[2];
  int s10180c160f9;
  virtual  ~S10180C160(); // _ZN10S10180C160D1Ev
  virtual void  v348(); // _ZN10S10180C1604v348Ev
  virtual void  v349(); // _ZN10S10180C1604v349Ev
  virtual void  v350(); // _ZN10S10180C1604v350Ev
  virtual void  v351(); // _ZN10S10180C1604v351Ev
  virtual void  v352(); // _ZN10S10180C1604v352Ev
  virtual void  v353(); // _ZN10S10180C1604v353Ev
  S10180C160(); // tgen
};
//SIG(-1 S10180C160) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v31} vd v1 v2 v3 v4 v5 v6 Fi FC11{ BC12{ BC2 vd v33 v34 v35 v36 FC13{ m Fp FC7 FC8 FC8 Fi[3] FC14{ m FC15{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v32} FC16{ m FC17{ m Fp Fi[2] FC5} Fp[2]} FC18{ BC12 v37 v38 v39 Fp[3]} FC19{ BC12 v40} FC20{ BC12 v41 v42} FC21{ BC12 v43 v44} FC22{ m Fp} Fp[2] Fi}


 S10180C160 ::~S10180C160(){ note_dtor("S10180C160", this);}
void  S10180C160 ::v348(){vfunc_called(this, "_ZN10S10180C1604v348Ev");}
void  S10180C160 ::v349(){vfunc_called(this, "_ZN10S10180C1604v349Ev");}
void  S10180C160 ::v350(){vfunc_called(this, "_ZN10S10180C1604v350Ev");}
void  S10180C160 ::v351(){vfunc_called(this, "_ZN10S10180C1604v351Ev");}
void  S10180C160 ::v352(){vfunc_called(this, "_ZN10S10180C1604v352Ev");}
void  S10180C160 ::v353(){vfunc_called(this, "_ZN10S10180C1604v353Ev");}
S10180C160 ::S10180C160(){ note_ctor("S10180C160", this);} // tgen

static void Test_S10180C160()
{
  extern Class_Descriptor cd_S10180C160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(178,245)];
    init_test(&cd_S10180C160, buf);
    S10180C160 *dp, &lv = *(dp=new (buf) S10180C160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1416,976), "sizeof(S10180C160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C160)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C160");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C160");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(144,96), "S10180C160");
    check_field_offset(lv, s10180c160f0, ABISELECT(152,100), "S10180C160.s10180c160f0");
    check_field_offset(lv, s10180c160f1, ABISELECT(160,104), "S10180C160.s10180c160f1");
    check_field_offset(lv, s10180c160f2, ABISELECT(392,268), "S10180C160.s10180c160f2");
    check_field_offset(lv, s10180c160f3, ABISELECT(432,292), "S10180C160.s10180c160f3");
    check_field_offset(lv, s10180c160f4, ABISELECT(688,468), "S10180C160.s10180c160f4");
    check_field_offset(lv, s10180c160f5, ABISELECT(920,632), "S10180C160.s10180c160f5");
    check_field_offset(lv, s10180c160f6, ABISELECT(1152,796), "S10180C160.s10180c160f6");
    check_field_offset(lv, s10180c160f7, ABISELECT(1384,960), "S10180C160.s10180c160f7");
    check_field_offset(lv, s10180c160f8, ABISELECT(1392,964), "S10180C160.s10180c160f8");
    check_field_offset(lv, s10180c160f9, ABISELECT(1408,972), "S10180C160.s10180c160f9");
    test_class_info(&lv, &cd_S10180C160);
    dp->~S10180C160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C160(Test_S10180C160, "S10180C160", ABISELECT(1416,976));

#else // __cplusplus

extern void _ZN10S10180C160C1Ev();
extern void _ZN10S10180C160D1Ev();
Name_Map name_map_S10180C160[] = {
  NSPAIR(_ZN10S10180C160C1Ev),
  NSPAIR(_ZN10S10180C160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
static Base_Class bases_S10180C160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C160[];
extern void _ZN10S10180C160D1Ev();
extern void _ZN10S10180C160D0Ev();
extern void _ZN10S10180C1604v348Ev();
extern void _ZN10S10180C1604v349Ev();
extern void _ZN10S10180C1604v350Ev();
extern void _ZN10S10180C1604v351Ev();
extern void _ZN10S10180C1604v352Ev();
extern void _ZN10S10180C1604v353Ev();
extern void ABISELECT(_ZThn48_N10S10180C160D1Ev,_ZThn32_N10S10180C160D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C160D0Ev,_ZThn32_N10S10180C160D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10180C160D1Ev,_ZThn96_N10S10180C160D1Ev)();
extern void ABISELECT(_ZThn144_N10S10180C160D0Ev,_ZThn96_N10S10180C160D0Ev)();
extern void _ZN8S10180C22v7Ev();
static  VTBL_ENTRY vtc_S10180C160[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C160[0]),
  (VTBL_ENTRY)&_ZN10S10180C160D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C160D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1604v348Ev,
  (VTBL_ENTRY)&_ZN10S10180C1604v349Ev,
  (VTBL_ENTRY)&_ZN10S10180C1604v350Ev,
  (VTBL_ENTRY)&_ZN10S10180C1604v351Ev,
  (VTBL_ENTRY)&_ZN10S10180C1604v352Ev,
  (VTBL_ENTRY)&_ZN10S10180C1604v353Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C160D1Ev,_ZThn32_N10S10180C160D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C160D0Ev,_ZThn32_N10S10180C160D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10180C160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C160D1Ev,_ZThn96_N10S10180C160D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C160D0Ev,_ZThn96_N10S10180C160D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
};
extern VTBL_ENTRY _ZTI10S10180C160[];
extern  VTBL_ENTRY _ZTV10S10180C160[];
Class_Descriptor cd_S10180C160 = {  "S10180C160", // class name
  bases_S10180C160, 3,
  &(vtc_S10180C160[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1416,976), // object size
  NSPAIRA(_ZTI10S10180C160),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV10S10180C160),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C161  {
  void *s10180c161f0;
  int s10180c161f1[2];
  ::S10180C138 s10180c161f2;
  void  mf10180c161(); // _ZN10S10180C16111mf10180c161Ev
};
//SIG(-1 S10180C161) C1{ m Fp Fi[2] FC2{ m}}


void  S10180C161 ::mf10180c161(){}

static void Test_S10180C161()
{
  {
    init_simple_test("S10180C161");
    S10180C161 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10180C161)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C161)");
    check_field_offset(lv, s10180c161f0, 0, "S10180C161.s10180c161f0");
    check_field_offset(lv, s10180c161f1, ABISELECT(8,4), "S10180C161.s10180c161f1");
    check_field_offset(lv, s10180c161f2, ABISELECT(16,12), "S10180C161.s10180c161f2");
  }
}
static Arrange_To_Call_Me vS10180C161(Test_S10180C161, "S10180C161", ABISELECT(24,16));

#else // __cplusplus

Class_Descriptor cd_S10180C161 = {  "S10180C161", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C165  {
  int s10180c165f0[2];
  __tsi64 s10180c165f1;
  char s10180c165f2;
};
//SIG(1 S10180C165) C1{ Fi[2] FL Fc}



static void Test_S10180C165()
{
  {
    init_simple_test("S10180C165");
    S10180C165 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S10180C165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C165)");
    check_field_offset(lv, s10180c165f0, 0, "S10180C165.s10180c165f0");
    check_field_offset(lv, s10180c165f1, 8, "S10180C165.s10180c165f1");
    check_field_offset(lv, s10180c165f2, 16, "S10180C165.s10180c165f2");
  }
}
static Arrange_To_Call_Me vS10180C165(Test_S10180C165, "S10180C165", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C164  {
  int s10180c164f0;
  ::S10180C165 s10180c164f1[9];
  int s10180c164f2;
};
//SIG(-1 S10180C164) C1{ Fi FC2{ Fi[2] FL Fc}[9] Fi}



static void Test_S10180C164()
{
  {
    init_simple_test("S10180C164");
    S10180C164 lv;
    check2(sizeof(lv), ABISELECT(232,188), "sizeof(S10180C164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C164)");
    check_field_offset(lv, s10180c164f0, 0, "S10180C164.s10180c164f0");
    check_field_offset(lv, s10180c164f1, ABISELECT(8,4), "S10180C164.s10180c164f1");
    check_field_offset(lv, s10180c164f2, ABISELECT(224,184), "S10180C164.s10180c164f2");
  }
}
static Arrange_To_Call_Me vS10180C164(Test_S10180C164, "S10180C164", ABISELECT(232,188));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C163  {
  ::S10180C31 s10180c163f0;
  ::S10180C164 s10180c163f1;
  ::S10180C13 s10180c163f2;
  void  mf10180c163(); // _ZN10S10180C16311mf10180c163Ev
};
//SIG(-1 S10180C163) C1{ m FC2{ m FC3{ m Fp Fi[2] FC4{ m}} Fp[2]} FC5{ Fi FC6{ Fi[2] FL Fc}[9] Fi} FC7{ m Fp Fi FC8{ m}}}


void  S10180C163 ::mf10180c163(){}

static void Test_S10180C163()
{
  {
    init_simple_test("S10180C163");
    S10180C163 lv;
    check2(sizeof(lv), ABISELECT(288,224), "sizeof(S10180C163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C163)");
    check_field_offset(lv, s10180c163f0, 0, "S10180C163.s10180c163f0");
    check_field_offset(lv, s10180c163f1, ABISELECT(40,24), "S10180C163.s10180c163f1");
    check_field_offset(lv, s10180c163f2, ABISELECT(272,212), "S10180C163.s10180c163f2");
  }
}
static Arrange_To_Call_Me vS10180C163(Test_S10180C163, "S10180C163", ABISELECT(288,224));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C130  : S10180C17 , S10180C11 , S10180C2 {
  ::S10180C31 s10180c130f0;
  void *s10180c130f1;
  ::S10180C68 s10180c130f2;
  ::S10180C94 s10180c130f3;
  ::S10180C61 s10180c130f4;
  ::S10180C131 s10180c130f5;
  ::S10180C135 s10180c130f6;
  ::S10180C101 s10180c130f7;
  ::S10180C143 s10180c130f8;
  ::S10180C151 s10180c130f9;
  ::S10180C152 s10180c130f10;
  ::S10180C152 s10180c130f11;
  ::S10180C154 s10180c130f12[9];
  ::S10180C155 s10180c130f13;
  ::S10180C155 s10180c130f14;
  ::S10180C157 s10180c130f15;
  ::S10180C158 s10180c130f16;
  void *s10180c130f17;
  int s10180c130f18;
  ::S10180C159 s10180c130f19;
  ::S10180C104 s10180c130f20;
  ::S10180C160 s10180c130f21;
  ::S10180C124 s10180c130f22;
  ::S10180C87 s10180c130f23;
  ::S10180C88 s10180c130f24;
  ::S10180C75 s10180c130f25;
  ::S10180C68 s10180c130f26;
  void *s10180c130f27;
  ::S10180C161 s10180c130f28;
  int s10180c130f29;
  ::S10180C163 s10180c130f30;
  void *s10180c130f31[2];
  int s10180c130f32;
  virtual  ~S10180C130(); // _ZN10S10180C130D1Ev
  virtual void  v238(); // _ZN10S10180C1304v238Ev
  virtual void  v239(); // _ZN10S10180C1304v239Ev
  virtual void  v240(); // _ZN10S10180C1304v240Ev
  virtual void  v241(); // _ZN10S10180C1304v241Ev
  virtual void  v242(); // _ZN10S10180C1304v242Ev
  virtual void  v243(); // _ZN10S10180C1304v243Ev
  virtual void  v244(); // _ZN10S10180C1304v244Ev
  virtual void  v245(); // _ZN10S10180C1304v245Ev
  S10180C130(); // tgen
};
//SIG(-1 S10180C130) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v33} vd v1 v2 v3 v4 v5 v6 v7 v8 FC11{ m FC12{ m Fp Fi[2] FC5} Fp[2]} Fp FC13{ BC14{ BC2 vd v36 v37 v38 v39 FC15{ m Fp FC7 FC8 FC8 Fi[3] FC16{ m FC17{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v34 v35} FC18{ BC19{ BC2 BC6 vd v45 v46 v47 v48 v49 v50} BC10 vd v40 v41 v42 v43 v44 FC20{ m Fi Fp Fi FC16} FC12} FC21{ m Fp} FC22{ vd v51 v52 FC23{ m Fp Fi[2] FC24{ m}} FC25{ m Fi[4]}[3] Fp[2] Fi Fc} FC26{ BC10 vd v53 Fp[2] FC27{ m Fp Fi FC24 FC28{ m}} FC29{ BC2 vd v54 v55 v56 v57 FC30{ m Fp[2] FC8 FC23 Fi[2]}}} FC31{ BC2 vd v58 Fp FC7 FC7 Fp Fi FC16} FC32{ BC33{ BC34{ BC2 vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fp[2] FC35{ m Fp} Fc[2] Fp FC36{ m FC16 FC16 FC37{ m FC38{ m FL}} FC37 FC16 FC16} FC7 Fp[4] FC11} vd v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 FC39{ vd m Fi[2] FC8 FC8 FC8 FC8 FC40{ m Fp[2]} FL[2]} Fp} vd v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi[3]} FC41{ BC34 vd v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 FC39 Fp} FC42{ BC33 vd v126 v127} FC42 FC43{ BC34 vd v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 Fi[2] FL Fi}[9] FC44{ BC33 vd v140 v141 v142} FC44 FC45{ BC33 vd v143 v144} FC46{ BC2 BC10 BC6 vd v145 v146 v147 v148 Fp FC26 FC31 FC13 FC47{ BC14 v149} Fp FL FC8} Fp Fi FC48{ m FL Fc FL[2] FC49{ m Fp}} FC50{ BC2 BC6 BC10 vd v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 Fi[2] FC51{ BC14 v173} FC11 FC52{ BC14 v174 v175 v176 Fp[3]} FC53{ BC14 v177} FC54{ BC14 v178 v179} FC13 FC55{ BC2 vd v180 v181 FC56{ BC57{ BC58{ m Fp FC16 FC16 Fi[3] Fc[2] Fi Fp} FC21 FC35 FC21 FC8 FC8 FC21 FC35 FC21 FC8 FC8 FC8 Fc Fi Fp} FC8} Fi} FC47 FC59{ BC53 v182} FC47 Fp FC35 Fp[2] Fi Fc[3] Fi FL[2]} FC60{ BC2 BC6 BC10 vd v183 v184 v185 v186 v187 v188 Fi FC51 FC11 FC52 FC53 FC54 FC13 FC35 Fp[2] Fi} FC61{ m FC62{ BC63{ m Fp Fi FC64{ m} FC64}} Fi} FC54 FC65{ BC14 v189 v190 v191 FC66{ Fp[3]} FC67{ Fi[4]}[3]} FC47 FC13 Fp FC68{ m Fp Fi[2] FC28} Fi FC69{ m FC11 FC70{ Fi FC71{ Fi[2] FL Fc}[9] Fi} FC8} Fp[2] Fi}


 S10180C130 ::~S10180C130(){ note_dtor("S10180C130", this);}
void  S10180C130 ::v238(){vfunc_called(this, "_ZN10S10180C1304v238Ev");}
void  S10180C130 ::v239(){vfunc_called(this, "_ZN10S10180C1304v239Ev");}
void  S10180C130 ::v240(){vfunc_called(this, "_ZN10S10180C1304v240Ev");}
void  S10180C130 ::v241(){vfunc_called(this, "_ZN10S10180C1304v241Ev");}
void  S10180C130 ::v242(){vfunc_called(this, "_ZN10S10180C1304v242Ev");}
void  S10180C130 ::v243(){vfunc_called(this, "_ZN10S10180C1304v243Ev");}
void  S10180C130 ::v244(){vfunc_called(this, "_ZN10S10180C1304v244Ev");}
void  S10180C130 ::v245(){vfunc_called(this, "_ZN10S10180C1304v245Ev");}
S10180C130 ::S10180C130(){ note_ctor("S10180C130", this);} // tgen

static void Test_S10180C130()
{
  extern Class_Descriptor cd_S10180C130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1572,2224)];
    init_test(&cd_S10180C130, buf);
    S10180C130 *dp, &lv = *(dp=new (buf) S10180C130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12568,8892), "sizeof(S10180C130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C130)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C130");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C130");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(144,96), "S10180C130");
    check_field_offset(lv, s10180c130f0, ABISELECT(152,100), "S10180C130.s10180c130f0");
    check_field_offset(lv, s10180c130f1, ABISELECT(192,124), "S10180C130.s10180c130f1");
    check_field_offset(lv, s10180c130f2, ABISELECT(200,128), "S10180C130.s10180c130f2");
    check_field_offset(lv, s10180c130f3, ABISELECT(432,292), "S10180C130.s10180c130f3");
    check_field_offset(lv, s10180c130f4, ABISELECT(648,436), "S10180C130.s10180c130f4");
    check_field_offset(lv, s10180c130f5, ABISELECT(656,440), "S10180C130.s10180c130f5");
    check_field_offset(lv, s10180c130f6, ABISELECT(760,524), "S10180C130.s10180c130f6");
    check_field_offset(lv, s10180c130f7, ABISELECT(912,624), "S10180C130.s10180c130f7");
    check_field_offset(lv, s10180c130f8, ABISELECT(1048,716), "S10180C130.s10180c130f8");
    check_field_offset(lv, s10180c130f9, ABISELECT(1448,1004), "S10180C130.s10180c130f9");
    check_field_offset(lv, s10180c130f10, ABISELECT(1832,1280), "S10180C130.s10180c130f10");
    check_field_offset(lv, s10180c130f11, ABISELECT(2216,1556), "S10180C130.s10180c130f11");
    check_field_offset(lv, s10180c130f12, ABISELECT(2600,1832), "S10180C130.s10180c130f12");
    check_field_offset(lv, s10180c130f13, ABISELECT(5192,3704), "S10180C130.s10180c130f13");
    check_field_offset(lv, s10180c130f14, ABISELECT(5576,3980), "S10180C130.s10180c130f14");
    check_field_offset(lv, s10180c130f15, ABISELECT(5960,4256), "S10180C130.s10180c130f15");
    check_field_offset(lv, s10180c130f16, ABISELECT(6344,4532), "S10180C130.s10180c130f16");
    check_field_offset(lv, s10180c130f17, ABISELECT(7288,5180), "S10180C130.s10180c130f17");
    check_field_offset(lv, s10180c130f18, ABISELECT(7296,5184), "S10180C130.s10180c130f18");
    check_field_offset(lv, s10180c130f19, ABISELECT(7304,5188), "S10180C130.s10180c130f19");
    check_field_offset(lv, s10180c130f20, ABISELECT(7344,5220), "S10180C130.s10180c130f20");
    check_field_offset(lv, s10180c130f21, ABISELECT(9776,6924), "S10180C130.s10180c130f21");
    check_field_offset(lv, s10180c130f22, ABISELECT(11192,7900), "S10180C130.s10180c130f22");
    check_field_offset(lv, s10180c130f23, ABISELECT(11216,7916), "S10180C130.s10180c130f23");
    check_field_offset(lv, s10180c130f24, ABISELECT(11448,8080), "S10180C130.s10180c130f24");
    check_field_offset(lv, s10180c130f25, ABISELECT(11752,8304), "S10180C130.s10180c130f25");
    check_field_offset(lv, s10180c130f26, ABISELECT(11984,8468), "S10180C130.s10180c130f26");
    check_field_offset(lv, s10180c130f27, ABISELECT(12216,8632), "S10180C130.s10180c130f27");
    check_field_offset(lv, s10180c130f28, ABISELECT(12224,8636), "S10180C130.s10180c130f28");
    check_field_offset(lv, s10180c130f29, ABISELECT(12248,8652), "S10180C130.s10180c130f29");
    check_field_offset(lv, s10180c130f30, ABISELECT(12256,8656), "S10180C130.s10180c130f30");
    check_field_offset(lv, s10180c130f31, ABISELECT(12544,8880), "S10180C130.s10180c130f31");
    check_field_offset(lv, s10180c130f32, ABISELECT(12560,8888), "S10180C130.s10180c130f32");
    test_class_info(&lv, &cd_S10180C130);
    dp->~S10180C130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C130(Test_S10180C130, "S10180C130", ABISELECT(12568,8892));

#else // __cplusplus

extern void _ZN10S10180C130C1Ev();
extern void _ZN10S10180C130D1Ev();
Name_Map name_map_S10180C130[] = {
  NSPAIR(_ZN10S10180C130C1Ev),
  NSPAIR(_ZN10S10180C130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
static Base_Class bases_S10180C130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C130[];
extern void _ZN10S10180C130D1Ev();
extern void _ZN10S10180C130D0Ev();
extern void _ZN10S10180C1304v238Ev();
extern void _ZN10S10180C1304v239Ev();
extern void _ZN10S10180C1304v240Ev();
extern void _ZN10S10180C1304v241Ev();
extern void _ZN10S10180C1304v242Ev();
extern void _ZN10S10180C1304v243Ev();
extern void _ZN10S10180C1304v244Ev();
extern void _ZN10S10180C1304v245Ev();
extern void ABISELECT(_ZThn48_N10S10180C130D1Ev,_ZThn32_N10S10180C130D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C130D0Ev,_ZThn32_N10S10180C130D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10180C130D1Ev,_ZThn96_N10S10180C130D1Ev)();
extern void ABISELECT(_ZThn144_N10S10180C130D0Ev,_ZThn96_N10S10180C130D0Ev)();
extern void _ZN8S10180C22v7Ev();
static  VTBL_ENTRY vtc_S10180C130[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C130[0]),
  (VTBL_ENTRY)&_ZN10S10180C130D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C130D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v238Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v239Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v240Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v241Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v242Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v243Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v244Ev,
  (VTBL_ENTRY)&_ZN10S10180C1304v245Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C130D1Ev,_ZThn32_N10S10180C130D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C130D0Ev,_ZThn32_N10S10180C130D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10180C130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C130D1Ev,_ZThn96_N10S10180C130D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C130D0Ev,_ZThn96_N10S10180C130D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
};
extern VTBL_ENTRY _ZTI10S10180C130[];
extern  VTBL_ENTRY _ZTV10S10180C130[];
Class_Descriptor cd_S10180C130 = {  "S10180C130", // class name
  bases_S10180C130, 3,
  &(vtc_S10180C130[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(12568,8892), // object size
  NSPAIRA(_ZTI10S10180C130),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV10S10180C130),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C168  : S10180C17 {
  void *s10180c168f0;
  ::S10180C61 s10180c168f1;
  void *s10180c168f2[4];
  int s10180c168f3;
  virtual  ~S10180C168(); // _ZN10S10180C168D1Ev
  virtual void  v367(); // _ZN10S10180C1684v367Ev
  virtual void  v368(); // _ZN10S10180C1684v368Ev
  virtual void  v369(); // _ZN10S10180C1684v369Ev
  virtual void  v370(); // _ZN10S10180C1684v370Ev
  virtual void  v371(); // _ZN10S10180C1684v371Ev
  S10180C168(); // tgen
};
//SIG(-1 S10180C168) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 v5 Fp FC6{ m Fp} Fp[4] Fi}


 S10180C168 ::~S10180C168(){ note_dtor("S10180C168", this);}
void  S10180C168 ::v367(){vfunc_called(this, "_ZN10S10180C1684v367Ev");}
void  S10180C168 ::v368(){vfunc_called(this, "_ZN10S10180C1684v368Ev");}
void  S10180C168 ::v369(){vfunc_called(this, "_ZN10S10180C1684v369Ev");}
void  S10180C168 ::v370(){vfunc_called(this, "_ZN10S10180C1684v370Ev");}
void  S10180C168 ::v371(){vfunc_called(this, "_ZN10S10180C1684v371Ev");}
S10180C168 ::S10180C168(){ note_ctor("S10180C168", this);} // tgen

static void Test_S10180C168()
{
  extern Class_Descriptor cd_S10180C168;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,16)];
    init_test(&cd_S10180C168, buf);
    S10180C168 *dp, &lv = *(dp=new (buf) S10180C168());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,60), "sizeof(S10180C168)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C168)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C168");
    check_field_offset(lv, s10180c168f0, ABISELECT(48,32), "S10180C168.s10180c168f0");
    check_field_offset(lv, s10180c168f1, ABISELECT(56,36), "S10180C168.s10180c168f1");
    check_field_offset(lv, s10180c168f2, ABISELECT(64,40), "S10180C168.s10180c168f2");
    check_field_offset(lv, s10180c168f3, ABISELECT(96,56), "S10180C168.s10180c168f3");
    test_class_info(&lv, &cd_S10180C168);
    dp->~S10180C168();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C168(Test_S10180C168, "S10180C168", ABISELECT(104,60));

#else // __cplusplus

extern void _ZN10S10180C168C1Ev();
extern void _ZN10S10180C168D1Ev();
Name_Map name_map_S10180C168[] = {
  NSPAIR(_ZN10S10180C168C1Ev),
  NSPAIR(_ZN10S10180C168D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C168[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C168[];
extern void _ZN10S10180C168D1Ev();
extern void _ZN10S10180C168D0Ev();
extern void _ZN10S10180C1684v367Ev();
extern void _ZN10S10180C1684v368Ev();
extern void _ZN10S10180C1684v369Ev();
extern void _ZN10S10180C1684v370Ev();
extern void _ZN10S10180C1684v371Ev();
static  VTBL_ENTRY vtc_S10180C168[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C168[0]),
  (VTBL_ENTRY)&_ZN10S10180C168D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C168D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v367Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v368Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v369Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v370Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v371Ev,
};
extern VTBL_ENTRY _ZTI10S10180C168[];
extern  VTBL_ENTRY _ZTV10S10180C168[];
Class_Descriptor cd_S10180C168 = {  "S10180C168", // class name
  bases_S10180C168, 1,
  &(vtc_S10180C168[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,60), // object size
  NSPAIRA(_ZTI10S10180C168),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C168),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C169  {
  int s10180c169f0[2];
  void  mf10180c169(); // _ZN10S10180C16911mf10180c169Ev
};
//SIG(-1 S10180C169) C1{ m Fi[2]}


void  S10180C169 ::mf10180c169(){}

static void Test_S10180C169()
{
  {
    init_simple_test("S10180C169");
    S10180C169 lv;
    check2(sizeof(lv), 8, "sizeof(S10180C169)");
    check2(__alignof__(lv), 4, "__alignof__(S10180C169)");
    check_field_offset(lv, s10180c169f0, 0, "S10180C169.s10180c169f0");
  }
}
static Arrange_To_Call_Me vS10180C169(Test_S10180C169, "S10180C169", 8);

#else // __cplusplus

Class_Descriptor cd_S10180C169 = {  "S10180C169", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C167  : S10180C168 {
  void *s10180c167f0[2];
  int s10180c167f1[4];
  ::S10180C61 s10180c167f2;
  ::S10180C169 s10180c167f3;
  ::S10180C169 s10180c167f4;
  char s10180c167f5[2];
  ::S10180C61 s10180c167f6;
  ::S10180C147 s10180c167f7;
  int s10180c167f8;
  virtual  ~S10180C167(); // _ZN10S10180C167D1Ev
  virtual void  v362(); // _ZN10S10180C1674v362Ev
  virtual void  v363(); // _ZN10S10180C1674v363Ev
  virtual void  v364(); // _ZN10S10180C1674v364Ev
  virtual void  v365(); // _ZN10S10180C1674v365Ev
  virtual void  v366(); // _ZN10S10180C1674v366Ev
  S10180C167(); // tgen
};
//SIG(-1 S10180C167) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v6 v7 v8 v9 v10 Fp FC7{ m Fp} Fp[4] Fi} vd v1 v2 v3 v4 v5 Fp[2] Fi[4] FC7 FC8{ m Fi[2]} FC8 Fc[2] FC7 FC9{ m FC10{ m FL}} Fi}


 S10180C167 ::~S10180C167(){ note_dtor("S10180C167", this);}
void  S10180C167 ::v362(){vfunc_called(this, "_ZN10S10180C1674v362Ev");}
void  S10180C167 ::v363(){vfunc_called(this, "_ZN10S10180C1674v363Ev");}
void  S10180C167 ::v364(){vfunc_called(this, "_ZN10S10180C1674v364Ev");}
void  S10180C167 ::v365(){vfunc_called(this, "_ZN10S10180C1674v365Ev");}
void  S10180C167 ::v366(){vfunc_called(this, "_ZN10S10180C1674v366Ev");}
S10180C167 ::S10180C167(){ note_ctor("S10180C167", this);} // tgen

static void Test_S10180C167()
{
  extern Class_Descriptor cd_S10180C167;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,32)];
    init_test(&cd_S10180C167, buf);
    S10180C167 *dp, &lv = *(dp=new (buf) S10180C167());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,124), "sizeof(S10180C167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C167)");
    check_base_class_offset(lv, (S10180C17*)(S10180C168*), 0, "S10180C167");
    check_base_class_offset(lv, (S10180C168*), 0, "S10180C167");
    check_field_offset(lv, s10180c167f0, ABISELECT(104,60), "S10180C167.s10180c167f0");
    check_field_offset(lv, s10180c167f1, ABISELECT(120,68), "S10180C167.s10180c167f1");
    check_field_offset(lv, s10180c167f2, ABISELECT(136,84), "S10180C167.s10180c167f2");
    check_field_offset(lv, s10180c167f3, ABISELECT(144,88), "S10180C167.s10180c167f3");
    check_field_offset(lv, s10180c167f4, ABISELECT(152,96), "S10180C167.s10180c167f4");
    check_field_offset(lv, s10180c167f5, ABISELECT(160,104), "S10180C167.s10180c167f5");
    check_field_offset(lv, s10180c167f6, ABISELECT(168,108), "S10180C167.s10180c167f6");
    check_field_offset(lv, s10180c167f7, ABISELECT(176,112), "S10180C167.s10180c167f7");
    check_field_offset(lv, s10180c167f8, ABISELECT(184,120), "S10180C167.s10180c167f8");
    test_class_info(&lv, &cd_S10180C167);
    dp->~S10180C167();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C167(Test_S10180C167, "S10180C167", ABISELECT(192,124));

#else // __cplusplus

extern void _ZN10S10180C167C1Ev();
extern void _ZN10S10180C167D1Ev();
Name_Map name_map_S10180C167[] = {
  NSPAIR(_ZN10S10180C167C1Ev),
  NSPAIR(_ZN10S10180C167D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C168;
extern VTBL_ENTRY _ZTI10S10180C168[];
extern  VTBL_ENTRY _ZTV10S10180C168[];
static Base_Class bases_S10180C167[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10180C168,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C167[];
extern void _ZN10S10180C167D1Ev();
extern void _ZN10S10180C167D0Ev();
extern void _ZN10S10180C1684v367Ev();
extern void _ZN10S10180C1684v368Ev();
extern void _ZN10S10180C1684v369Ev();
extern void _ZN10S10180C1684v370Ev();
extern void _ZN10S10180C1684v371Ev();
extern void _ZN10S10180C1674v362Ev();
extern void _ZN10S10180C1674v363Ev();
extern void _ZN10S10180C1674v364Ev();
extern void _ZN10S10180C1674v365Ev();
extern void _ZN10S10180C1674v366Ev();
static  VTBL_ENTRY vtc_S10180C167[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C167[0]),
  (VTBL_ENTRY)&_ZN10S10180C167D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C167D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v367Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v368Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v369Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v370Ev,
  (VTBL_ENTRY)&_ZN10S10180C1684v371Ev,
  (VTBL_ENTRY)&_ZN10S10180C1674v362Ev,
  (VTBL_ENTRY)&_ZN10S10180C1674v363Ev,
  (VTBL_ENTRY)&_ZN10S10180C1674v364Ev,
  (VTBL_ENTRY)&_ZN10S10180C1674v365Ev,
  (VTBL_ENTRY)&_ZN10S10180C1674v366Ev,
};
extern VTBL_ENTRY _ZTI10S10180C167[];
extern  VTBL_ENTRY _ZTV10S10180C167[];
Class_Descriptor cd_S10180C167 = {  "S10180C167", // class name
  bases_S10180C167, 2,
  &(vtc_S10180C167[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,124), // object size
  NSPAIRA(_ZTI10S10180C167),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C167),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C171  {
  ::S10180C161 s10180c171f0;
  int s10180c171f1;
  void  mf10180c171(); // _ZN10S10180C17111mf10180c171Ev
};
//SIG(-1 S10180C171) C1{ m FC2{ m Fp Fi[2] FC3{ m}} Fi}


void  S10180C171 ::mf10180c171(){}

static void Test_S10180C171()
{
  {
    init_simple_test("S10180C171");
    S10180C171 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S10180C171)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C171)");
    check_field_offset(lv, s10180c171f0, 0, "S10180C171.s10180c171f0");
    check_field_offset(lv, s10180c171f1, ABISELECT(24,16), "S10180C171.s10180c171f1");
  }
}
static Arrange_To_Call_Me vS10180C171(Test_S10180C171, "S10180C171", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C170  : S10180C17 , S10180C11 {
  void *s10180c170f0;
  ::S10180C171 s10180c170f1;
  int s10180c170f2;
  void *s10180c170f3;
  char s10180c170f4;
  virtual  ~S10180C170(); // _ZN10S10180C170D1Ev
  virtual void  v372(); // _ZN10S10180C1704v372Ev
  virtual void  v373(); // _ZN10S10180C1704v373Ev
  virtual void  v374(); // _ZN10S10180C1704v374Ev
  virtual void  v375(); // _ZN10S10180C1704v375Ev
  virtual void  v376(); // _ZN10S10180C1704v376Ev
  S10180C170(); // tgen
};
//SIG(-1 S10180C170) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4 v5 Fp FC10{ m FC11{ m Fp Fi[2] FC12{ m}} Fi} Fi Fp Fc}


 S10180C170 ::~S10180C170(){ note_dtor("S10180C170", this);}
void  S10180C170 ::v372(){vfunc_called(this, "_ZN10S10180C1704v372Ev");}
void  S10180C170 ::v373(){vfunc_called(this, "_ZN10S10180C1704v373Ev");}
void  S10180C170 ::v374(){vfunc_called(this, "_ZN10S10180C1704v374Ev");}
void  S10180C170 ::v375(){vfunc_called(this, "_ZN10S10180C1704v375Ev");}
void  S10180C170 ::v376(){vfunc_called(this, "_ZN10S10180C1704v376Ev");}
S10180C170 ::S10180C170(){ note_ctor("S10180C170", this);} // tgen

static void Test_S10180C170()
{
  extern Class_Descriptor cd_S10180C170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,34)];
    init_test(&cd_S10180C170, buf);
    S10180C170 *dp, &lv = *(dp=new (buf) S10180C170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,132), "sizeof(S10180C170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C170)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C170");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C170");
    check_field_offset(lv, s10180c170f0, ABISELECT(144,96), "S10180C170.s10180c170f0");
    check_field_offset(lv, s10180c170f1, ABISELECT(152,100), "S10180C170.s10180c170f1");
    check_field_offset(lv, s10180c170f2, ABISELECT(184,120), "S10180C170.s10180c170f2");
    check_field_offset(lv, s10180c170f3, ABISELECT(192,124), "S10180C170.s10180c170f3");
    check_field_offset(lv, s10180c170f4, ABISELECT(200,128), "S10180C170.s10180c170f4");
    test_class_info(&lv, &cd_S10180C170);
    dp->~S10180C170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C170(Test_S10180C170, "S10180C170", ABISELECT(208,132));

#else // __cplusplus

extern void _ZN10S10180C170C1Ev();
extern void _ZN10S10180C170D1Ev();
Name_Map name_map_S10180C170[] = {
  NSPAIR(_ZN10S10180C170C1Ev),
  NSPAIR(_ZN10S10180C170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C170[];
extern void _ZN10S10180C170D1Ev();
extern void _ZN10S10180C170D0Ev();
extern void _ZN10S10180C1704v372Ev();
extern void _ZN10S10180C1704v373Ev();
extern void _ZN10S10180C1704v374Ev();
extern void _ZN10S10180C1704v375Ev();
extern void _ZN10S10180C1704v376Ev();
extern void ABISELECT(_ZThn48_N10S10180C170D1Ev,_ZThn32_N10S10180C170D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C170D0Ev,_ZThn32_N10S10180C170D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
static  VTBL_ENTRY vtc_S10180C170[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C170[0]),
  (VTBL_ENTRY)&_ZN10S10180C170D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C170D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1704v372Ev,
  (VTBL_ENTRY)&_ZN10S10180C1704v373Ev,
  (VTBL_ENTRY)&_ZN10S10180C1704v374Ev,
  (VTBL_ENTRY)&_ZN10S10180C1704v375Ev,
  (VTBL_ENTRY)&_ZN10S10180C1704v376Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C170D1Ev,_ZThn32_N10S10180C170D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C170D0Ev,_ZThn32_N10S10180C170D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
};
extern VTBL_ENTRY _ZTI10S10180C170[];
extern  VTBL_ENTRY _ZTV10S10180C170[];
Class_Descriptor cd_S10180C170 = {  "S10180C170", // class name
  bases_S10180C170, 2,
  &(vtc_S10180C170[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,132), // object size
  NSPAIRA(_ZTI10S10180C170),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S10180C170),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C166  : S10180C17 , S10180C11 , S10180C2 , S10180C80 {
  void *s10180c166f0[2];
  ::S10180C61 s10180c166f1;
  int s10180c166f2[2];
  ::S10180C167 s10180c166f3;
  void *s10180c166f4;
  ::S10180C170 s10180c166f5;
  char s10180c166f6;
  ::S10180C31 s10180c166f7;
  char s10180c166f8[2];
  virtual  ~S10180C166(); // _ZN10S10180C166D1Ev
  virtual void  v354(); // _ZN10S10180C1664v354Ev
  virtual void  v355(); // _ZN10S10180C1664v355Ev
  virtual void  v356(); // _ZN10S10180C1664v356Ev
  virtual void  v357(); // _ZN10S10180C1664v357Ev
  virtual void  v358(); // _ZN10S10180C1664v358Ev
  virtual void  v359(); // _ZN10S10180C1664v359Ev
  virtual void  v360(); // _ZN10S10180C1664v360Ev
  virtual void  v361(); // _ZN10S10180C1664v361Ev
  S10180C166(); // tgen
};
//SIG(-1 S10180C166) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v33} BC11{ BC12{ vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48} BC13{ vd m Fp}} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2] FC14{ m Fp} Fi[2] FC15{ BC16{ BC2 vd v54 v55 v56 v57 v58 Fp FC14 Fp[4] Fi} vd v49 v50 v51 v52 v53 Fp[2] Fi[4] FC14 FC17{ m Fi[2]} FC17 Fc[2] FC14 FC18{ m FC19{ m FL}} Fi} Fp FC20{ BC2 BC6 vd v59 v60 v61 v62 v63 Fp FC21{ m FC22{ m Fp Fi[2] FC23{ m}} Fi} Fi Fp Fc} Fc FC24{ m FC25{ m Fp Fi[2] FC5} Fp[2]} Fc[2]}


 S10180C166 ::~S10180C166(){ note_dtor("S10180C166", this);}
void  S10180C166 ::v354(){vfunc_called(this, "_ZN10S10180C1664v354Ev");}
void  S10180C166 ::v355(){vfunc_called(this, "_ZN10S10180C1664v355Ev");}
void  S10180C166 ::v356(){vfunc_called(this, "_ZN10S10180C1664v356Ev");}
void  S10180C166 ::v357(){vfunc_called(this, "_ZN10S10180C1664v357Ev");}
void  S10180C166 ::v358(){vfunc_called(this, "_ZN10S10180C1664v358Ev");}
void  S10180C166 ::v359(){vfunc_called(this, "_ZN10S10180C1664v359Ev");}
void  S10180C166 ::v360(){vfunc_called(this, "_ZN10S10180C1664v360Ev");}
void  S10180C166 ::v361(){vfunc_called(this, "_ZN10S10180C1664v361Ev");}
S10180C166 ::S10180C166(){ note_ctor("S10180C166", this);} // tgen

static void Test_S10180C166()
{
  extern Class_Descriptor cd_S10180C166;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(85,107)];
    init_test(&cd_S10180C166, buf);
    S10180C166 *dp, &lv = *(dp=new (buf) S10180C166());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(672,424), "sizeof(S10180C166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C166)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C166");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C166");
    check_base_class_offset(lv, (S10180C2*), ABISELECT(144,96), "S10180C166");
    check_base_class_offset(lv, (S10180C81*)(S10180C80*), ABISELECT(152,100), "S10180C166");
    check_base_class_offset(lv, (S10180C82*)(S10180C80*), ABISELECT(160,104), "S10180C166");
    check_base_class_offset(lv, (S10180C80*), ABISELECT(152,100), "S10180C166");
    check_field_offset(lv, s10180c166f0, ABISELECT(176,112), "S10180C166.s10180c166f0");
    check_field_offset(lv, s10180c166f1, ABISELECT(192,120), "S10180C166.s10180c166f1");
    check_field_offset(lv, s10180c166f2, ABISELECT(200,124), "S10180C166.s10180c166f2");
    check_field_offset(lv, s10180c166f3, ABISELECT(208,132), "S10180C166.s10180c166f3");
    check_field_offset(lv, s10180c166f4, ABISELECT(400,256), "S10180C166.s10180c166f4");
    check_field_offset(lv, s10180c166f5, ABISELECT(408,260), "S10180C166.s10180c166f5");
    check_field_offset(lv, s10180c166f6, ABISELECT(616,392), "S10180C166.s10180c166f6");
    check_field_offset(lv, s10180c166f7, ABISELECT(624,396), "S10180C166.s10180c166f7");
    check_field_offset(lv, s10180c166f8, ABISELECT(664,420), "S10180C166.s10180c166f8");
    test_class_info(&lv, &cd_S10180C166);
    dp->~S10180C166();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C166(Test_S10180C166, "S10180C166", ABISELECT(672,424));

#else // __cplusplus

extern void _ZN10S10180C166C1Ev();
extern void _ZN10S10180C166D1Ev();
Name_Map name_map_S10180C166[] = {
  NSPAIR(_ZN10S10180C166C1Ev),
  NSPAIR(_ZN10S10180C166D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C81;
extern VTBL_ENTRY _ZTI9S10180C81[];
extern  VTBL_ENTRY _ZTV9S10180C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
extern Class_Descriptor cd_S10180C80;
extern VTBL_ENTRY _ZTI9S10180C80[];
extern  VTBL_ENTRY _ZTV9S10180C80[];
static Base_Class bases_S10180C166[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C2,    ABISELECT(144,96), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C81,    ABISELECT(152,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C82,    ABISELECT(160,104), //bcp->offset
    64, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C80,    ABISELECT(152,100), //bcp->offset
    45, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C166[];
extern void _ZN10S10180C166D1Ev();
extern void _ZN10S10180C166D0Ev();
extern void _ZN10S10180C1664v354Ev();
extern void _ZN10S10180C1664v355Ev();
extern void _ZN10S10180C1664v356Ev();
extern void _ZN10S10180C1664v357Ev();
extern void _ZN10S10180C1664v358Ev();
extern void _ZN10S10180C1664v359Ev();
extern void _ZN10S10180C1664v360Ev();
extern void _ZN10S10180C1664v361Ev();
extern void ABISELECT(_ZThn48_N10S10180C166D1Ev,_ZThn32_N10S10180C166D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C166D0Ev,_ZThn32_N10S10180C166D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10180C166D1Ev,_ZThn96_N10S10180C166D1Ev)();
extern void ABISELECT(_ZThn144_N10S10180C166D0Ev,_ZThn96_N10S10180C166D0Ev)();
extern void _ZN8S10180C22v7Ev();
extern void ABISELECT(_ZThn152_N10S10180C166D1Ev,_ZThn100_N10S10180C166D1Ev)();
extern void ABISELECT(_ZThn152_N10S10180C166D0Ev,_ZThn100_N10S10180C166D0Ev)();
extern void _ZN9S10180C813v99Ev();
extern void _ZN9S10180C814v100Ev();
extern void _ZN9S10180C814v101Ev();
extern void _ZN9S10180C814v102Ev();
extern void _ZN9S10180C814v103Ev();
extern void _ZN9S10180C814v104Ev();
extern void _ZN9S10180C814v105Ev();
extern void _ZN9S10180C814v106Ev();
extern void _ZN9S10180C814v107Ev();
extern void _ZN9S10180C814v108Ev();
extern void _ZN9S10180C814v109Ev();
extern void _ZN9S10180C814v110Ev();
extern void _ZN9S10180C814v111Ev();
extern void _ZN9S10180C814v112Ev();
extern void _ZN9S10180C814v113Ev();
extern void ABISELECT(_ZThn160_N10S10180C166D1Ev,_ZThn104_N10S10180C166D1Ev)();
extern void ABISELECT(_ZThn160_N10S10180C166D0Ev,_ZThn104_N10S10180C166D0Ev)();
static  VTBL_ENTRY vtc_S10180C166[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C166[0]),
  (VTBL_ENTRY)&_ZN10S10180C166D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C166D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v354Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v355Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v356Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v357Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v358Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v359Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v360Ev,
  (VTBL_ENTRY)&_ZN10S10180C1664v361Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C166[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C166D1Ev,_ZThn32_N10S10180C166D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C166D0Ev,_ZThn32_N10S10180C166D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10180C166[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C166D1Ev,_ZThn96_N10S10180C166D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10180C166D0Ev,_ZThn96_N10S10180C166D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI10S10180C166[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N10S10180C166D1Ev,_ZThn100_N10S10180C166D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N10S10180C166D0Ev,_ZThn100_N10S10180C166D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10180C814v113Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI10S10180C166[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N10S10180C166D1Ev,_ZThn104_N10S10180C166D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N10S10180C166D0Ev,_ZThn104_N10S10180C166D0Ev),
};
extern VTBL_ENTRY _ZTI10S10180C166[];
extern  VTBL_ENTRY _ZTV10S10180C166[];
Class_Descriptor cd_S10180C166 = {  "S10180C166", // class name
  bases_S10180C166, 6,
  &(vtc_S10180C166[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(672,424), // object size
  NSPAIRA(_ZTI10S10180C166),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV10S10180C166),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C174  : S10180C17 {
  void *s10180c174f0;
  virtual  ~S10180C174(); // _ZN10S10180C174D1Ev
  S10180C174(); // tgen
};
//SIG(-1 S10180C174) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd Fp}


 S10180C174 ::~S10180C174(){ note_dtor("S10180C174", this);}
S10180C174 ::S10180C174(){ note_ctor("S10180C174", this);} // tgen

static void Test_S10180C174()
{
  extern Class_Descriptor cd_S10180C174;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S10180C174, buf);
    S10180C174 *dp, &lv = *(dp=new (buf) S10180C174());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S10180C174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C174)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C174");
    check_field_offset(lv, s10180c174f0, ABISELECT(48,32), "S10180C174.s10180c174f0");
    test_class_info(&lv, &cd_S10180C174);
    dp->~S10180C174();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C174(Test_S10180C174, "S10180C174", ABISELECT(56,36));

#else // __cplusplus

extern void _ZN10S10180C174C1Ev();
extern void _ZN10S10180C174D1Ev();
Name_Map name_map_S10180C174[] = {
  NSPAIR(_ZN10S10180C174C1Ev),
  NSPAIR(_ZN10S10180C174D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C174[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C174[];
extern void _ZN10S10180C174D1Ev();
extern void _ZN10S10180C174D0Ev();
static  VTBL_ENTRY vtc_S10180C174[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C174[0]),
  (VTBL_ENTRY)&_ZN10S10180C174D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C174D0Ev,
};
extern VTBL_ENTRY _ZTI10S10180C174[];
extern  VTBL_ENTRY _ZTV10S10180C174[];
Class_Descriptor cd_S10180C174 = {  "S10180C174", // class name
  bases_S10180C174, 1,
  &(vtc_S10180C174[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,36), // object size
  NSPAIRA(_ZTI10S10180C174),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C174),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C175  : S10180C17 , S10180C11 {
  virtual  ~S10180C175(); // _ZN10S10180C175D1Ev
  virtual void  v377(); // _ZN10S10180C1754v377Ev
  virtual void  v378(); // _ZN10S10180C1754v378Ev
  virtual void  v379(); // _ZN10S10180C1754v379Ev
  virtual void  v380(); // _ZN10S10180C1754v380Ev
  S10180C175(); // tgen
};
//SIG(-1 S10180C175) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4}


 S10180C175 ::~S10180C175(){ note_dtor("S10180C175", this);}
void  S10180C175 ::v377(){vfunc_called(this, "_ZN10S10180C1754v377Ev");}
void  S10180C175 ::v378(){vfunc_called(this, "_ZN10S10180C1754v378Ev");}
void  S10180C175 ::v379(){vfunc_called(this, "_ZN10S10180C1754v379Ev");}
void  S10180C175 ::v380(){vfunc_called(this, "_ZN10S10180C1754v380Ev");}
S10180C175 ::S10180C175(){ note_ctor("S10180C175", this);} // tgen

static void Test_S10180C175()
{
  extern Class_Descriptor cd_S10180C175;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,25)];
    init_test(&cd_S10180C175, buf);
    S10180C175 *dp, &lv = *(dp=new (buf) S10180C175());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S10180C175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C175)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10180C175");
    check_base_class_offset(lv, (S10180C11*), ABISELECT(48,32), "S10180C175");
    test_class_info(&lv, &cd_S10180C175);
    dp->~S10180C175();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C175(Test_S10180C175, "S10180C175", ABISELECT(144,96));

#else // __cplusplus

extern void _ZN10S10180C175C1Ev();
extern void _ZN10S10180C175D1Ev();
Name_Map name_map_S10180C175[] = {
  NSPAIR(_ZN10S10180C175C1Ev),
  NSPAIR(_ZN10S10180C175D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10180C11;
extern VTBL_ENTRY _ZTI9S10180C11[];
extern  VTBL_ENTRY _ZTV9S10180C11[];
static Base_Class bases_S10180C175[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C11,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C175[];
extern void _ZN10S10180C175D1Ev();
extern void _ZN10S10180C175D0Ev();
extern void _ZN10S10180C1754v377Ev();
extern void _ZN10S10180C1754v378Ev();
extern void _ZN10S10180C1754v379Ev();
extern void _ZN10S10180C1754v380Ev();
extern void ABISELECT(_ZThn48_N10S10180C175D1Ev,_ZThn32_N10S10180C175D1Ev)();
extern void ABISELECT(_ZThn48_N10S10180C175D0Ev,_ZThn32_N10S10180C175D0Ev)();
extern void _ZN9S10180C113v15Ev();
extern void _ZN9S10180C113v16Ev();
extern void _ZN9S10180C113v17Ev();
extern void _ZN9S10180C113v18Ev();
extern void _ZN9S10180C113v19Ev();
extern void _ZN9S10180C113v20Ev();
extern void _ZN9S10180C113v21Ev();
extern void _ZN9S10180C113v22Ev();
extern void _ZN9S10180C113v23Ev();
extern void _ZN9S10180C113v24Ev();
extern void _ZN9S10180C113v25Ev();
extern void _ZN9S10180C113v26Ev();
extern void _ZN9S10180C113v27Ev();
extern void _ZN9S10180C113v28Ev();
extern void _ZN9S10180C113v29Ev();
extern void _ZN9S10180C113v30Ev();
extern void _ZN9S10180C113v31Ev();
extern void _ZN9S10180C113v32Ev();
extern void _ZN9S10180C113v33Ev();
extern void _ZN9S10180C113v34Ev();
extern void _ZN9S10180C113v35Ev();
extern void _ZN9S10180C113v36Ev();
extern void _ZN9S10180C113v37Ev();
extern void _ZN9S10180C113v38Ev();
static  VTBL_ENTRY vtc_S10180C175[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C175[0]),
  (VTBL_ENTRY)&_ZN10S10180C175D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C175D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1754v377Ev,
  (VTBL_ENTRY)&_ZN10S10180C1754v378Ev,
  (VTBL_ENTRY)&_ZN10S10180C1754v379Ev,
  (VTBL_ENTRY)&_ZN10S10180C1754v380Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10180C175[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C175D1Ev,_ZThn32_N10S10180C175D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10180C175D0Ev,_ZThn32_N10S10180C175D0Ev),
  (VTBL_ENTRY)&_ZN9S10180C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10180C113v38Ev,
};
extern VTBL_ENTRY _ZTI10S10180C175[];
extern  VTBL_ENTRY _ZTV10S10180C175[];
Class_Descriptor cd_S10180C175 = {  "S10180C175", // class name
  bases_S10180C175, 2,
  &(vtc_S10180C175[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,96), // object size
  NSPAIRA(_ZTI10S10180C175),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S10180C175),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C129  : S10180C2 , S10180C17 {
  void *s10180c129f0[6];
  ::S10180C130 s10180c129f1;
  ::S10180C79 s10180c129f2;
  ::S10180C166 s10180c129f3;
  ::S10180C174 s10180c129f4;
  ::S10180C175 s10180c129f5;
  ::S10180C87 s10180c129f6;
  void *s10180c129f7;
  int s10180c129f8;
  void *s10180c129f9;
  int s10180c129f10;
  virtual  ~S10180C129(); // _ZN10S10180C129D1Ev
  virtual void  v237(); // _ZN10S10180C1294v237Ev
  S10180C129(); // tgen
};
//SIG(-1 S10180C129) C1{ BC2{ vd v2} BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v1 Fp[6] FC7{ BC3 BC8{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp FC9{ m FC10{ m Fp Fi FC5} Fi} FC11{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC2 vd v3 v4 v5 v6 v7 v8 v9 v10 FC12{ m FC13{ m Fp Fi[2] FC6} Fp[2]} Fp FC14{ BC15{ BC3 vd v37 v38 v39 v40 FC16{ m Fp FC9 FC10 FC10 Fi[3] FC17{ m FC18{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC9 FC9 Fc} Fp Fc Fi} v35 v36} FC19{ BC20{ BC3 BC8 vd v46 v47 v48 v49 v50 v51} BC2 vd v41 v42 v43 v44 v45 FC21{ m Fi Fp Fi FC17} FC13} FC22{ m Fp} FC23{ vd v52 v53 FC24{ m Fp Fi[2] FC25{ m}} FC26{ m Fi[4]}[3] Fp[2] Fi Fc} FC27{ BC2 vd v54 Fp[2] FC28{ m Fp Fi FC25 FC29{ m}} FC30{ BC3 vd v55 v56 v57 v58 FC31{ m Fp[2] FC10 FC24 Fi[2]}}} FC32{ BC3 vd v59 Fp FC9 FC9 Fp Fi FC17} FC33{ BC34{ BC35{ BC3 vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fp[2] FC36{ m Fp} Fc[2] Fp FC37{ m FC17 FC17 FC38{ m FC39{ m FL}} FC38 FC17 FC17} FC9 Fp[4] FC12} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 FC40{ vd m Fi[2] FC10 FC10 FC10 FC10 FC41{ m Fp[2]} FL[2]} Fp} vd v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi[3]} FC42{ BC35 vd v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 FC40 Fp} FC43{ BC34 vd v127 v128} FC43 FC44{ BC35 vd v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi[2] FL Fi}[9] FC45{ BC34 vd v141 v142 v143} FC45 FC46{ BC34 vd v144 v145} FC47{ BC3 BC2 BC8 vd v146 v147 v148 v149 Fp FC27 FC32 FC14 FC48{ BC15 v150} Fp FL FC10} Fp Fi FC49{ m FL Fc FL[2] FC50{ m Fp}} FC51{ BC3 BC8 BC2 vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 Fi[2] FC52{ BC15 v174} FC12 FC53{ BC15 v175 v176 v177 Fp[3]} FC54{ BC15 v178} FC55{ BC15 v179 v180} FC14 FC56{ BC3 vd v181 v182 FC57{ BC58{ BC59{ m Fp FC17 FC17 Fi[3] Fc[2] Fi Fp} FC22 FC36 FC22 FC10 FC10 FC22 FC36 FC22 FC10 FC10 FC10 Fc Fi Fp} FC10} Fi} FC48 FC60{ BC54 v183} FC48 Fp FC36 Fp[2] Fi Fc[3] Fi FL[2]} FC61{ BC3 BC8 BC2 vd v184 v185 v186 v187 v188 v189 Fi FC52 FC12 FC53 FC54 FC55 FC14 FC36 Fp[2] Fi} FC62{ m FC63{ BC64{ m Fp Fi FC65{ m} FC65}} Fi} FC55 FC66{ BC15 v190 v191 v192 FC67{ Fp[3]} FC68{ Fi[4]}[3]} FC48 FC14 Fp FC69{ m Fp Fi[2] FC29} Fi FC70{ m FC12 FC71{ Fi FC72{ Fi[2] FL Fc}[9] Fi} FC10} Fp[2] Fi} FC73{ BC3 BC8 BC2 BC74{ BC75{ vd v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241} BC76{ vd m Fp}} BC77{ vd v242 v243} BC78{ vd v244} vd v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 Fp[5] Fi Fp FC79{ m Fi[2]} FC22 FC52 FC14 FC48 FC55 FC66 FC80{ BC3 BC8 vd v245 v246 v247 v248 v249 v250 v251 v252 FC81{ m FC10 Fi[2] FC10} Fi[2] Fc[2] Fi FL[2] FC39 Fi} FC19 FC82{ BC3 BC8 vd v253 v254 v255 v256 FC12 Fp[2] FC10 Fi} FC83{ BC3 BC8 BC2 BC74 BC77 BC78 vd v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 FC12 Fp[2] Fi[2] FC32 FC14 FC55 FC55 FC17 FC17 FC17 Fi} FC84{ BC51 vd v276 v277 v278 v279 v280 v281 FC50 FC85{ m Fp FC36 Fp[5] FC86{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC87{ m FC88{ m Fi[2]} FC88} FC88 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC12 Fc[2] Fi FC89{ m Fc[5]} FC90{ m FC17 FC17 FC17 FC22 Fi Fc[2] Fi} FC17 FC17 FC17 Fp FC91{ BC3 vd FC92{ m Fp[3] FC79 FC10 FL[2] Fc} FC12} Fc[2] FL Fc[2] Fi FC36 FC62 Fc Fi} FC93{ BC3 BC8 BC2 BC74 vd v282 v283 v284 v285 v286 v287 v288 v289 Fp[2] FC22 Fi[2] FC94{ BC95{ BC3 vd v295 v296 v297 v298 v299 Fp FC22 Fp[4] Fi} vd v290 v291 v292 v293 v294 Fp[2] Fi[4] FC22 FC96{ m Fi[2]} FC96 Fc[2] FC22 FC38 Fi} Fp FC97{ BC3 BC8 vd v300 v301 v302 v303 v304 Fp FC98{ m FC69 Fi} Fi Fp Fc} Fc FC12 Fc[2]} FC99{ BC3 vd Fp} FC100{ BC3 BC8 vd v305 v306 v307 v308} FC55 Fp Fi Fp Fi}


 S10180C129 ::~S10180C129(){ note_dtor("S10180C129", this);}
void  S10180C129 ::v237(){vfunc_called(this, "_ZN10S10180C1294v237Ev");}
S10180C129 ::S10180C129(){ note_ctor("S10180C129", this);} // tgen

static void Test_S10180C129()
{
  extern Class_Descriptor cd_S10180C129;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2532,3548)];
    init_test(&cd_S10180C129, buf);
    S10180C129 *dp, &lv = *(dp=new (buf) S10180C129());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(20248,14188), "sizeof(S10180C129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C129)");
    check_base_class_offset(lv, (S10180C2*), 0, "S10180C129");
    check_base_class_offset(lv, (S10180C17*), ABISELECT(8,4), "S10180C129");
    check_field_offset(lv, s10180c129f0, ABISELECT(56,36), "S10180C129.s10180c129f0");
    check_field_offset(lv, s10180c129f1, ABISELECT(104,60), "S10180C129.s10180c129f1");
    check_field_offset(lv, s10180c129f2, ABISELECT(12672,8952), "S10180C129.s10180c129f2");
    check_field_offset(lv, s10180c129f3, ABISELECT(19112,13452), "S10180C129.s10180c129f3");
    check_field_offset(lv, s10180c129f4, ABISELECT(19784,13876), "S10180C129.s10180c129f4");
    check_field_offset(lv, s10180c129f5, ABISELECT(19840,13912), "S10180C129.s10180c129f5");
    check_field_offset(lv, s10180c129f6, ABISELECT(19984,14008), "S10180C129.s10180c129f6");
    check_field_offset(lv, s10180c129f7, ABISELECT(20216,14172), "S10180C129.s10180c129f7");
    check_field_offset(lv, s10180c129f8, ABISELECT(20224,14176), "S10180C129.s10180c129f8");
    check_field_offset(lv, s10180c129f9, ABISELECT(20232,14180), "S10180C129.s10180c129f9");
    check_field_offset(lv, s10180c129f10, ABISELECT(20240,14184), "S10180C129.s10180c129f10");
    test_class_info(&lv, &cd_S10180C129);
    dp->~S10180C129();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C129(Test_S10180C129, "S10180C129", ABISELECT(20248,14188));

#else // __cplusplus

extern void _ZN10S10180C129C1Ev();
extern void _ZN10S10180C129D1Ev();
Name_Map name_map_S10180C129[] = {
  NSPAIR(_ZN10S10180C129C1Ev),
  NSPAIR(_ZN10S10180C129D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10180C129[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C17,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C129[];
extern void _ZN10S10180C129D1Ev();
extern void _ZN10S10180C129D0Ev();
extern void _ZN8S10180C22v7Ev();
extern void _ZN10S10180C1294v237Ev();
extern void ABISELECT(_ZThn8_N10S10180C129D1Ev,_ZThn4_N10S10180C129D1Ev)();
extern void ABISELECT(_ZThn8_N10S10180C129D0Ev,_ZThn4_N10S10180C129D0Ev)();
static  VTBL_ENTRY vtc_S10180C129[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C129[0]),
  (VTBL_ENTRY)&_ZN10S10180C129D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C129D0Ev,
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  (VTBL_ENTRY)&_ZN10S10180C1294v237Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI10S10180C129[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S10180C129D1Ev,_ZThn4_N10S10180C129D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S10180C129D0Ev,_ZThn4_N10S10180C129D0Ev),
};
extern VTBL_ENTRY _ZTI10S10180C129[];
extern  VTBL_ENTRY _ZTV10S10180C129[];
Class_Descriptor cd_S10180C129 = {  "S10180C129", // class name
  bases_S10180C129, 2,
  &(vtc_S10180C129[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(20248,14188), // object size
  NSPAIRA(_ZTI10S10180C129),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S10180C129),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C177  {
  virtual  ~S10180C177(); // _ZN10S10180C177D1Ev
  virtual void  v389(); // _ZN10S10180C1774v389Ev
  virtual void  v390(); // _ZN10S10180C1774v390Ev
  virtual void  v391(); // _ZN10S10180C1774v391Ev
  virtual void  v392(); // _ZN10S10180C1774v392Ev
  virtual void  v393(); // _ZN10S10180C1774v393Ev
  virtual void  v394(); // _ZN10S10180C1774v394Ev
  virtual void  v395(); // _ZN10S10180C1774v395Ev
  virtual void  v396(); // _ZN10S10180C1774v396Ev
  S10180C177(); // tgen
};
//SIG(-1 S10180C177) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S10180C177 ::~S10180C177(){ note_dtor("S10180C177", this);}
void  S10180C177 ::v389(){vfunc_called(this, "_ZN10S10180C1774v389Ev");}
void  S10180C177 ::v390(){vfunc_called(this, "_ZN10S10180C1774v390Ev");}
void  S10180C177 ::v391(){vfunc_called(this, "_ZN10S10180C1774v391Ev");}
void  S10180C177 ::v392(){vfunc_called(this, "_ZN10S10180C1774v392Ev");}
void  S10180C177 ::v393(){vfunc_called(this, "_ZN10S10180C1774v393Ev");}
void  S10180C177 ::v394(){vfunc_called(this, "_ZN10S10180C1774v394Ev");}
void  S10180C177 ::v395(){vfunc_called(this, "_ZN10S10180C1774v395Ev");}
void  S10180C177 ::v396(){vfunc_called(this, "_ZN10S10180C1774v396Ev");}
S10180C177 ::S10180C177(){ note_ctor("S10180C177", this);} // tgen

static void Test_S10180C177()
{
  extern Class_Descriptor cd_S10180C177;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10180C177, buf);
    S10180C177 *dp, &lv = *(dp=new (buf) S10180C177());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10180C177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C177)");
    test_class_info(&lv, &cd_S10180C177);
    dp->~S10180C177();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C177(Test_S10180C177, "S10180C177", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN10S10180C177C1Ev();
extern void _ZN10S10180C177D1Ev();
Name_Map name_map_S10180C177[] = {
  NSPAIR(_ZN10S10180C177C1Ev),
  NSPAIR(_ZN10S10180C177D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S10180C177[];
extern void _ZN10S10180C177D1Ev();
extern void _ZN10S10180C177D0Ev();
extern void _ZN10S10180C1774v389Ev();
extern void _ZN10S10180C1774v390Ev();
extern void _ZN10S10180C1774v391Ev();
extern void _ZN10S10180C1774v392Ev();
extern void _ZN10S10180C1774v393Ev();
extern void _ZN10S10180C1774v394Ev();
extern void _ZN10S10180C1774v395Ev();
extern void _ZN10S10180C1774v396Ev();
static  VTBL_ENTRY vtc_S10180C177[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C177[0]),
  (VTBL_ENTRY)&_ZN10S10180C177D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C177D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v389Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v390Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v391Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v392Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v393Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v394Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v395Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v396Ev,
};
extern VTBL_ENTRY _ZTI10S10180C177[];
extern  VTBL_ENTRY _ZTV10S10180C177[];
Class_Descriptor cd_S10180C177 = {  "S10180C177", // class name
  0,0,//no base classes
  &(vtc_S10180C177[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S10180C177),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S10180C177),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C176  : S10180C177 {
  void *s10180c176f0[2];
  virtual  ~S10180C176(); // _ZN10S10180C176D1Ev
  virtual void  v381(); // _ZN10S10180C1764v381Ev
  virtual void  v382(); // _ZN10S10180C1764v382Ev
  virtual void  v383(); // _ZN10S10180C1764v383Ev
  virtual void  v384(); // _ZN10S10180C1764v384Ev
  virtual void  v385(); // _ZN10S10180C1764v385Ev
  virtual void  v386(); // _ZN10S10180C1764v386Ev
  virtual void  v387(); // _ZN10S10180C1764v387Ev
  virtual void  v388(); // _ZN10S10180C1764v388Ev
  S10180C176(); // tgen
};
//SIG(-1 S10180C176) C1{ BC2{ vd v9 v10 v11 v12 v13 v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2]}


 S10180C176 ::~S10180C176(){ note_dtor("S10180C176", this);}
void  S10180C176 ::v381(){vfunc_called(this, "_ZN10S10180C1764v381Ev");}
void  S10180C176 ::v382(){vfunc_called(this, "_ZN10S10180C1764v382Ev");}
void  S10180C176 ::v383(){vfunc_called(this, "_ZN10S10180C1764v383Ev");}
void  S10180C176 ::v384(){vfunc_called(this, "_ZN10S10180C1764v384Ev");}
void  S10180C176 ::v385(){vfunc_called(this, "_ZN10S10180C1764v385Ev");}
void  S10180C176 ::v386(){vfunc_called(this, "_ZN10S10180C1764v386Ev");}
void  S10180C176 ::v387(){vfunc_called(this, "_ZN10S10180C1764v387Ev");}
void  S10180C176 ::v388(){vfunc_called(this, "_ZN10S10180C1764v388Ev");}
S10180C176 ::S10180C176(){ note_ctor("S10180C176", this);} // tgen

static void Test_S10180C176()
{
  extern Class_Descriptor cd_S10180C176;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S10180C176, buf);
    S10180C176 *dp, &lv = *(dp=new (buf) S10180C176());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S10180C176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C176)");
    check_base_class_offset(lv, (S10180C177*), 0, "S10180C176");
    check_field_offset(lv, s10180c176f0, ABISELECT(8,4), "S10180C176.s10180c176f0");
    test_class_info(&lv, &cd_S10180C176);
    dp->~S10180C176();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C176(Test_S10180C176, "S10180C176", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN10S10180C176C1Ev();
extern void _ZN10S10180C176D1Ev();
Name_Map name_map_S10180C176[] = {
  NSPAIR(_ZN10S10180C176C1Ev),
  NSPAIR(_ZN10S10180C176D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C177;
extern VTBL_ENTRY _ZTI10S10180C177[];
extern  VTBL_ENTRY _ZTV10S10180C177[];
static Base_Class bases_S10180C176[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C177,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10180C176[];
extern void _ZN10S10180C176D1Ev();
extern void _ZN10S10180C176D0Ev();
extern void _ZN10S10180C1774v389Ev();
extern void _ZN10S10180C1774v390Ev();
extern void _ZN10S10180C1774v391Ev();
extern void _ZN10S10180C1774v392Ev();
extern void _ZN10S10180C1774v393Ev();
extern void _ZN10S10180C1774v394Ev();
extern void _ZN10S10180C1774v395Ev();
extern void _ZN10S10180C1774v396Ev();
extern void _ZN10S10180C1764v381Ev();
extern void _ZN10S10180C1764v382Ev();
extern void _ZN10S10180C1764v383Ev();
extern void _ZN10S10180C1764v384Ev();
extern void _ZN10S10180C1764v385Ev();
extern void _ZN10S10180C1764v386Ev();
extern void _ZN10S10180C1764v387Ev();
extern void _ZN10S10180C1764v388Ev();
static  VTBL_ENTRY vtc_S10180C176[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C176[0]),
  (VTBL_ENTRY)&_ZN10S10180C176D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C176D0Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v389Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v390Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v391Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v392Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v393Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v394Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v395Ev,
  (VTBL_ENTRY)&_ZN10S10180C1774v396Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v381Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v382Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v383Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v384Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v385Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v386Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v387Ev,
  (VTBL_ENTRY)&_ZN10S10180C1764v388Ev,
};
extern VTBL_ENTRY _ZTI10S10180C176[];
extern  VTBL_ENTRY _ZTV10S10180C176[];
Class_Descriptor cd_S10180C176 = {  "S10180C176", // class name
  bases_S10180C176, 1,
  &(vtc_S10180C176[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI10S10180C176),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10180C176),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C178  {
  int s10180c178f0;
  void  mf10180c178(); // _ZN10S10180C17811mf10180c178Ev
  virtual  ~S10180C178(); // _ZN10S10180C178D1Ev
  S10180C178(); // tgen
};
//SIG(-1 S10180C178) C1{ vd m Fi}


void  S10180C178 ::mf10180c178(){}
 S10180C178 ::~S10180C178(){ note_dtor("S10180C178", this);}
S10180C178 ::S10180C178(){ note_ctor("S10180C178", this);} // tgen

static void Test_S10180C178()
{
  extern Class_Descriptor cd_S10180C178;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10180C178, buf);
    S10180C178 *dp, &lv = *(dp=new (buf) S10180C178());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10180C178)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C178)");
    check_field_offset(lv, s10180c178f0, ABISELECT(8,4), "S10180C178.s10180c178f0");
    test_class_info(&lv, &cd_S10180C178);
    dp->~S10180C178();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C178(Test_S10180C178, "S10180C178", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN10S10180C178C1Ev();
extern void _ZN10S10180C178D1Ev();
Name_Map name_map_S10180C178[] = {
  NSPAIR(_ZN10S10180C178C1Ev),
  NSPAIR(_ZN10S10180C178D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S10180C178[];
extern void _ZN10S10180C178D1Ev();
extern void _ZN10S10180C178D0Ev();
static  VTBL_ENTRY vtc_S10180C178[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10180C178[0]),
  (VTBL_ENTRY)&_ZN10S10180C178D1Ev,
  (VTBL_ENTRY)&_ZN10S10180C178D0Ev,
};
extern VTBL_ENTRY _ZTI10S10180C178[];
extern  VTBL_ENTRY _ZTV10S10180C178[];
Class_Descriptor cd_S10180C178 = {  "S10180C178", // class name
  0,0,//no base classes
  &(vtc_S10180C178[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S10180C178),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S10180C178),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C179  {
  void *s10180c179f0;
  int s10180c179f1;
  void  mf10180c179(); // _ZN10S10180C17911mf10180c179Ev
};
//SIG(-1 S10180C179) C1{ m Fp Fi}


void  S10180C179 ::mf10180c179(){}

static void Test_S10180C179()
{
  {
    init_simple_test("S10180C179");
    S10180C179 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10180C179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C179)");
    check_field_offset(lv, s10180c179f0, 0, "S10180C179.s10180c179f0");
    check_field_offset(lv, s10180c179f1, ABISELECT(8,4), "S10180C179.s10180c179f1");
  }
}
static Arrange_To_Call_Me vS10180C179(Test_S10180C179, "S10180C179", ABISELECT(16,8));

#else // __cplusplus

Class_Descriptor cd_S10180C179 = {  "S10180C179", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10180C1  : S10180C2 , S10180C3 {
  ::S10180C4 s10180c1f0;
  ::S10180C9 s10180c1f1;
  void *s10180c1f2[3];
  ::S10180C10 s10180c1f3;
  ::S10180C16 s10180c1f4;
  ::S10180C129 s10180c1f5;
  ::S10180C87 s10180c1f6;
  ::S10180C87 s10180c1f7;
  ::S10180C176 s10180c1f8;
  ::S10180C13 s10180c1f9;
  ::S10180C178 s10180c1f10;
  int s10180c1f11;
  ::S10180C31 s10180c1f12;
  int s10180c1f13;
  ::S10180C179 s10180c1f14;
  ::S10180C179 s10180c1f15;
  ::S10180C179 s10180c1f16;
  virtual  ~S10180C1(); // _ZN8S10180C1D1Ev
  virtual void  v1(); // _ZN8S10180C12v1Ev
  virtual void  v2(); // _ZN8S10180C12v2Ev
  virtual void  v3(); // _ZN8S10180C12v3Ev
  virtual void  v4(); // _ZN8S10180C12v4Ev
  virtual void  v5(); // _ZN8S10180C12v5Ev
  virtual void  v6(); // _ZN8S10180C12v6Ev
  S10180C1(); // tgen
};
//SIG(1 S10180C1) C1{ BC2{ vd v7} BC3{ vd v8 v9 v10 v11 v12 Fp} vd v1 v2 v3 v4 v5 v6 FC4{ m Fp FC5{ BC6{ m Fp Fi FC7{ m} FC7}}} FC8{ m Fi Fp Fi[4] Fp} Fp[3] FC9{ BC10{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} FC14{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v13 v14 FC11 Fp} FC15{ BC2 BC16{ vd m FC17{ m Fp Fi FC13 FC18{ m}} FC17 Fc} BC19{ vd v41} vd v39 v40 Fp[5] FC20{ BC16 BC2 BC10 BC21{ vd v64} BC22{ vd v65 v66} vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 Fi FC23{ m Fi[2]} FC23 FC23 FC24{ BC16 vd Fi Fp FC11 FL FC23 Fi Fc Fi FC25{ m FC26{ m Fp Fi[2] FC18} Fp[2]}} FC27{ BC10 vd v67 v68 v69} FC28{ vd m Fi Fp[3] FC29{ m Fc[2] Fp[3] Fi[4] FC30{ m FC31{ FL[4]}}}} FC32{ vd m FC30 Fi[2] FC33{ m FL[3] Fi[3] FL} FL FC34{ m Fi FC35{ m Fi[4]}} FC25 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC36{ BC16 BC19 vd v70 Fi FC37{ m Fc[2]} FC38{ Fp[2]} Fp FC39{ vd m FC40{ vd m FC41{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC42{ BC43{ vd v77 v78 v79 v80 v81 v82 Fi Fp Fc} vd v71 v72 v73 v74 v75 v76 Fp} FC44{ BC45{ vd v84 Fi Fc[3]} vd v83 Fp[4] FL Fi FC30 FC46{ m Fp FC47{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC48{ BC45 vd v85 FC30 Fi Fp[2] FC49{ m FC30 FC46 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC50{ BC45 vd v86 Fp[2] FL Fi[4] FC51{ m Fi[2]} FC30 FC52{ m FC30 FC46 Fp Fi[4]} FC53{ m Fp}} FC30 FC30 FL Fi[5]} FL FC54{ m FC33 FC55{ m Fi} Fi} Fc[128] FC23 FC25} Fi[3] FC56{ m Fp Fi[2]} FC57{ m Fc[11] Fi[2]} FC58{ BC59{} FL Fi} FC60{ BC61{ BC16 vd v89 v90 v91 v92 FC62{ m Fp FC11 FC12 FC12 Fi[3] FC63{ m FC64{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC11 FC11 Fc} Fp Fc Fi} v87 v88} FL FC65{ BC61 v93} FC65 FC60 FC25 Fc} FC66{ BC67{ BC16 BC10 BC2 BC68{ BC69{ vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110} BC70{ vd m Fp}} BC71{ vd v111 v112} BC21 vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 Fp[5] Fi Fp FC51 FC53 FC72{ BC61 v147} FC60 FC65 FC73{ BC61 v148 v149} FC74{ BC61 v150 v151 v152 FC75{ Fp[3]} FC47[3]} FC76{ BC16 BC10 vd v153 v154 v155 v156 v157 v158 v159 v160 FC77{ m FC12 Fi[2] FC12} Fi[2] Fc[2] Fi FL[2] FC78{ m FL} Fi} FC79{ BC80{ BC16 BC10 vd v166 v167 v168 v169 v170 v171} BC2 vd v161 v162 v163 v164 v165 FC81{ m Fi Fp Fi FC63} FC26} FC82{ BC16 BC10 vd v172 v173 v174 v175 FC25 Fp[2] FC12 Fi} FC83{ BC16 BC10 BC2 BC68 BC71 BC21 vd v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 FC25 Fp[2] Fi[2] FC84{ BC16 vd v195 Fp FC11 FC11 Fp Fi FC63} FC60 FC73 FC73 FC63 FC63 FC63 Fi} FC85{ BC86{ BC16 BC10 BC2 vd v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 Fi[2] FC72 FC25 FC87{ BC61 v225 v226 v227 Fp[3]} FC88{ BC61 v228} FC73 FC60 FC89{ BC16 vd v229 v230 FC90{ BC91{ BC92{ m Fp FC63 FC63 Fi[3] Fc[2] Fi Fp} FC53 FC93{ m Fp} FC53 FC12 FC12 FC53 FC93 FC53 FC12 FC12 FC12 Fc Fi Fp} FC12} Fi} FC65 FC94{ BC88 v231} FC65 Fp FC93 Fp[2] Fi Fc[3] Fi FL[2]} vd v196 v197 v198 v199 v200 v201 FC95{ m Fp} FC96{ m Fp FC93 Fp[5] FC97{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC98{ m FC99{ m Fi[2]} FC99} FC99 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC25 Fc[2] Fi FC100{ m Fc[5]} FC101{ m FC63 FC63 FC63 FC53 Fi Fc[2] Fi} FC63 FC63 FC63 Fp FC102{ BC16 vd FC103{ m Fp[3] FC51 FC12 FL[2] Fc} FC25} Fc[2] FL Fc[2] Fi FC93 FC104{ m FC5 Fi} Fc Fi} vd v94 v95 Fc} FC73 FC73 Fp Fc Fp Fi} FC105{ BC2 BC16 vd v232 Fp[6] FC106{ BC16 BC10 BC2 vd v233 v234 v235 v236 v237 v238 v239 v240 FC25 Fp FC60 FC79 FC53 FC107{ vd v241 v242 FC108{ m Fp Fi[2] FC109{ m}} FC35[3] Fp[2] Fi Fc} FC110{ BC2 vd v243 Fp[2] FC111{ m Fp Fi FC109 FC112{ m}} FC113{ BC16 vd v244 v245 v246 v247 FC114{ m Fp[2] FC12 FC108 Fi[2]}}} FC84 FC115{ BC116{ BC117{ BC16 vd v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 v275 v276 Fp[2] FC93 Fc[2] Fp FC118{ m FC63 FC63 FC119{ m FC78} FC119 FC63 FC63} FC11 Fp[4] FC25} vd v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 FC120{ vd m Fi[2] FC12 FC12 FC12 FC12 FC121{ m Fp[2]} FL[2]} Fp} vd v248 v249 v250 v251 v252 v253 v254 v255 v256 Fi[3]} FC122{ BC117 vd v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 FC120 Fp} FC123{ BC116 vd v315 v316} FC123 FC124{ BC117 vd v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 v328 Fi[2] FL Fi}[9] FC125{ BC116 vd v329 v330 v331} FC125 FC126{ BC116 vd v332 v333} FC127{ BC16 BC2 BC10 vd v334 v335 v336 v337 Fp FC110 FC84 FC60 FC65 Fp FL FC12} Fp Fi FC128{ m FL Fc FL[2] FC95} FC86 FC129{ BC16 BC10 BC2 vd v338 v339 v340 v341 v342 v343 Fi FC72 FC25 FC87 FC88 FC73 FC60 FC93 Fp[2] Fi} FC104 FC73 FC74 FC65 FC60 Fp FC130{ m Fp Fi[2] FC112} Fi FC131{ m FC25 FC132{ Fi FC133{ Fi[2] FL Fc}[9] Fi} FC12} Fp[2] Fi} FC67 FC134{ BC16 BC10 BC2 BC68 vd v344 v345 v346 v347 v348 v349 v350 v351 Fp[2] FC53 Fi[2] FC135{ BC136{ BC16 vd v357 v358 v359 v360 v361 Fp FC53 Fp[4] Fi} vd v352 v353 v354 v355 v356 Fp[2] Fi[4] FC53 FC137{ m Fi[2]} FC137 Fc[2] FC53 FC119 Fi} Fp FC138{ BC16 BC10 vd v362 v363 v364 v365 v366 Fp FC139{ m FC130 Fi} Fi Fp Fc} Fc FC25 Fc[2]} FC140{ BC16 vd Fp} FC141{ BC16 BC10 vd v367 v368 v369 v370} FC73 Fp Fi Fp Fi} FC73 FC73 FC142{ BC143{ vd v379 v380 v381 v382 v383 v384 v385 v386} vd v371 v372 v373 v374 v375 v376 v377 v378 Fp[2]} FC12 FC144{ vd m Fi} Fi FC25 Fi FC145{ m Fp Fi} FC145 FC145}


 S10180C1 ::~S10180C1(){ note_dtor("S10180C1", this);}
void  S10180C1 ::v1(){vfunc_called(this, "_ZN8S10180C12v1Ev");}
void  S10180C1 ::v2(){vfunc_called(this, "_ZN8S10180C12v2Ev");}
void  S10180C1 ::v3(){vfunc_called(this, "_ZN8S10180C12v3Ev");}
void  S10180C1 ::v4(){vfunc_called(this, "_ZN8S10180C12v4Ev");}
void  S10180C1 ::v5(){vfunc_called(this, "_ZN8S10180C12v5Ev");}
void  S10180C1 ::v6(){vfunc_called(this, "_ZN8S10180C12v6Ev");}
S10180C1 ::S10180C1(){ note_ctor("S10180C1", this);} // tgen

static void Test_S10180C1()
{
  extern Class_Descriptor cd_S10180C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5557,8804)];
    init_test(&cd_S10180C1, buf);
    S10180C1 *dp, &lv = *(dp=new (buf) S10180C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(44448,35212), "sizeof(S10180C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10180C1)");
    check_base_class_offset(lv, (S10180C2*), 0, "S10180C1");
    check_base_class_offset(lv, (S10180C3*), ABISELECT(8,4), "S10180C1");
    check_field_offset(lv, s10180c1f0, ABISELECT(24,12), "S10180C1.s10180c1f0");
    check_field_offset(lv, s10180c1f1, ABISELECT(48,28), "S10180C1.s10180c1f1");
    check_field_offset(lv, s10180c1f2, ABISELECT(88,56), "S10180C1.s10180c1f2");
    check_field_offset(lv, s10180c1f3, ABISELECT(112,68), "S10180C1.s10180c1f3");
    check_field_offset(lv, s10180c1f4, ABISELECT(240,152), "S10180C1.s10180c1f4");
    check_field_offset(lv, s10180c1f5, ABISELECT(23576,20608), "S10180C1.s10180c1f5");
    check_field_offset(lv, s10180c1f6, ABISELECT(43824,34796), "S10180C1.s10180c1f6");
    check_field_offset(lv, s10180c1f7, ABISELECT(44056,34960), "S10180C1.s10180c1f7");
    check_field_offset(lv, s10180c1f8, ABISELECT(44288,35124), "S10180C1.s10180c1f8");
    check_field_offset(lv, s10180c1f9, ABISELECT(44312,35136), "S10180C1.s10180c1f9");
    check_field_offset(lv, s10180c1f10, ABISELECT(44328,35148), "S10180C1.s10180c1f10");
    check_field_offset(lv, s10180c1f11, ABISELECT(44344,35156), "S10180C1.s10180c1f11");
    check_field_offset(lv, s10180c1f12, ABISELECT(44352,35160), "S10180C1.s10180c1f12");
    check_field_offset(lv, s10180c1f13, ABISELECT(44392,35184), "S10180C1.s10180c1f13");
    check_field_offset(lv, s10180c1f14, ABISELECT(44400,35188), "S10180C1.s10180c1f14");
    check_field_offset(lv, s10180c1f15, ABISELECT(44416,35196), "S10180C1.s10180c1f15");
    check_field_offset(lv, s10180c1f16, ABISELECT(44432,35204), "S10180C1.s10180c1f16");
    test_class_info(&lv, &cd_S10180C1);
    dp->~S10180C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10180C1(Test_S10180C1, "S10180C1", ABISELECT(44448,35212));

#else // __cplusplus

extern void _ZN8S10180C1C1Ev();
extern void _ZN8S10180C1D1Ev();
Name_Map name_map_S10180C1[] = {
  NSPAIR(_ZN8S10180C1C1Ev),
  NSPAIR(_ZN8S10180C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C2;
extern VTBL_ENTRY _ZTI8S10180C2[];
extern  VTBL_ENTRY _ZTV8S10180C2[];
extern Class_Descriptor cd_S10180C3;
extern VTBL_ENTRY _ZTI8S10180C3[];
extern  VTBL_ENTRY _ZTV8S10180C3[];
static Base_Class bases_S10180C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C3,    ABISELECT(8,4), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10180C1[];
extern void _ZN8S10180C1D1Ev();
extern void _ZN8S10180C1D0Ev();
extern void _ZN8S10180C22v7Ev();
extern void _ZN8S10180C12v1Ev();
extern void _ZN8S10180C12v2Ev();
extern void _ZN8S10180C12v3Ev();
extern void _ZN8S10180C12v4Ev();
extern void _ZN8S10180C12v5Ev();
extern void _ZN8S10180C12v6Ev();
extern void ABISELECT(_ZThn8_N8S10180C1D1Ev,_ZThn4_N8S10180C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10180C1D0Ev,_ZThn4_N8S10180C1D0Ev)();
extern void _ZN8S10180C32v8Ev();
extern void _ZN8S10180C32v9Ev();
extern void _ZN8S10180C33v10Ev();
extern void _ZN8S10180C33v11Ev();
extern void _ZN8S10180C33v12Ev();
static  VTBL_ENTRY vtc_S10180C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10180C1[0]),
  (VTBL_ENTRY)&_ZN8S10180C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10180C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10180C22v7Ev,
  (VTBL_ENTRY)&_ZN8S10180C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10180C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10180C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10180C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10180C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10180C12v6Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10180C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10180C1D1Ev,_ZThn4_N8S10180C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10180C1D0Ev,_ZThn4_N8S10180C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10180C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10180C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10180C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10180C33v11Ev,
  (VTBL_ENTRY)&_ZN8S10180C33v12Ev,
};
extern VTBL_ENTRY _ZTI8S10180C1[];
extern  VTBL_ENTRY _ZTV8S10180C1[];
Class_Descriptor cd_S10180C1 = {  "S10180C1", // class name
  bases_S10180C1, 2,
  &(vtc_S10180C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(44448,35212), // object size
  NSPAIRA(_ZTI8S10180C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10180C1),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C2  {
  virtual  ~S10179C2(); // _ZN8S10179C2D1Ev
  virtual void  v7(); // _ZN8S10179C22v7Ev
  S10179C2(); // tgen
};
//SIG(-1 S10179C2) C1{ vd v1}


 S10179C2 ::~S10179C2(){ note_dtor("S10179C2", this);}
void  S10179C2 ::v7(){vfunc_called(this, "_ZN8S10179C22v7Ev");}
S10179C2 ::S10179C2(){ note_ctor("S10179C2", this);} // tgen

static void Test_S10179C2()
{
  extern Class_Descriptor cd_S10179C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10179C2, buf);
    S10179C2 *dp, &lv = *(dp=new (buf) S10179C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C2)");
    test_class_info(&lv, &cd_S10179C2);
    dp->~S10179C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C2(Test_S10179C2, "S10179C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10179C2C1Ev();
extern void _ZN8S10179C2D1Ev();
Name_Map name_map_S10179C2[] = {
  NSPAIR(_ZN8S10179C2C1Ev),
  NSPAIR(_ZN8S10179C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10179C2[];
extern void _ZN8S10179C2D1Ev();
extern void _ZN8S10179C2D0Ev();
extern void _ZN8S10179C22v7Ev();
static  VTBL_ENTRY vtc_S10179C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10179C2[0]),
  (VTBL_ENTRY)&_ZN8S10179C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10179C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
};
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
Class_Descriptor cd_S10179C2 = {  "S10179C2", // class name
  0,0,//no base classes
  &(vtc_S10179C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10179C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10179C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C3  {
  void *s10179c3f0;
  virtual  ~S10179C3(); // _ZN8S10179C3D1Ev
  virtual void  v8(); // _ZN8S10179C32v8Ev
  virtual void  v9(); // _ZN8S10179C32v9Ev
  virtual void  v10(); // _ZN8S10179C33v10Ev
  virtual void  v11(); // _ZN8S10179C33v11Ev
  virtual void  v12(); // _ZN8S10179C33v12Ev
  S10179C3(); // tgen
};
//SIG(-1 S10179C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10179C3 ::~S10179C3(){ note_dtor("S10179C3", this);}
void  S10179C3 ::v8(){vfunc_called(this, "_ZN8S10179C32v8Ev");}
void  S10179C3 ::v9(){vfunc_called(this, "_ZN8S10179C32v9Ev");}
void  S10179C3 ::v10(){vfunc_called(this, "_ZN8S10179C33v10Ev");}
void  S10179C3 ::v11(){vfunc_called(this, "_ZN8S10179C33v11Ev");}
void  S10179C3 ::v12(){vfunc_called(this, "_ZN8S10179C33v12Ev");}
S10179C3 ::S10179C3(){ note_ctor("S10179C3", this);} // tgen

static void Test_S10179C3()
{
  extern Class_Descriptor cd_S10179C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10179C3, buf);
    S10179C3 *dp, &lv = *(dp=new (buf) S10179C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10179C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C3)");
    check_field_offset(lv, s10179c3f0, ABISELECT(8,4), "S10179C3.s10179c3f0");
    test_class_info(&lv, &cd_S10179C3);
    dp->~S10179C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C3(Test_S10179C3, "S10179C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10179C3C1Ev();
extern void _ZN8S10179C3D1Ev();
Name_Map name_map_S10179C3[] = {
  NSPAIR(_ZN8S10179C3C1Ev),
  NSPAIR(_ZN8S10179C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10179C3[];
extern void _ZN8S10179C3D1Ev();
extern void _ZN8S10179C3D0Ev();
extern void _ZN8S10179C32v8Ev();
extern void _ZN8S10179C32v9Ev();
extern void _ZN8S10179C33v10Ev();
extern void _ZN8S10179C33v11Ev();
extern void _ZN8S10179C33v12Ev();
static  VTBL_ENTRY vtc_S10179C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10179C3[0]),
  (VTBL_ENTRY)&_ZN8S10179C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10179C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10179C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10179C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10179C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10179C33v11Ev,
  (VTBL_ENTRY)&_ZN8S10179C33v12Ev,
};
extern VTBL_ENTRY _ZTI8S10179C3[];
extern  VTBL_ENTRY _ZTV8S10179C3[];
Class_Descriptor cd_S10179C3 = {  "S10179C3", // class name
  0,0,//no base classes
  &(vtc_S10179C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10179C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10179C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C24  {
  virtual  ~S10179C24(); // _ZN9S10179C24D1Ev
  virtual void  v41(); // _ZN9S10179C243v41Ev
  S10179C24(); // tgen
};
//SIG(-1 S10179C24) C1{ vd v1}


 S10179C24 ::~S10179C24(){ note_dtor("S10179C24", this);}
void  S10179C24 ::v41(){vfunc_called(this, "_ZN9S10179C243v41Ev");}
S10179C24 ::S10179C24(){ note_ctor("S10179C24", this);} // tgen

static void Test_S10179C24()
{
  extern Class_Descriptor cd_S10179C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10179C24, buf);
    S10179C24 *dp, &lv = *(dp=new (buf) S10179C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C24)");
    test_class_info(&lv, &cd_S10179C24);
    dp->~S10179C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C24(Test_S10179C24, "S10179C24", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10179C24C1Ev();
extern void _ZN9S10179C24D1Ev();
Name_Map name_map_S10179C24[] = {
  NSPAIR(_ZN9S10179C24C1Ev),
  NSPAIR(_ZN9S10179C24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C24[];
extern void _ZN9S10179C24D1Ev();
extern void _ZN9S10179C24D0Ev();
extern void _ZN9S10179C243v41Ev();
static  VTBL_ENTRY vtc_S10179C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C24[0]),
  (VTBL_ENTRY)&_ZN9S10179C24D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C24D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10179C24[];
extern  VTBL_ENTRY _ZTV9S10179C24[];
Class_Descriptor cd_S10179C24 = {  "S10179C24", // class name
  0,0,//no base classes
  &(vtc_S10179C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10179C24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C24),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C11  {
  void *s10179c11f0;
  ::S10180C12 s10179c11f1;
  ::S10180C15 s10179c11f2;
  virtual  ~S10179C11(); // _ZN9S10179C11D1Ev
  virtual void  v15(); // _ZN9S10179C113v15Ev
  virtual void  v16(); // _ZN9S10179C113v16Ev
  virtual void  v17(); // _ZN9S10179C113v17Ev
  virtual void  v18(); // _ZN9S10179C113v18Ev
  virtual void  v19(); // _ZN9S10179C113v19Ev
  virtual void  v20(); // _ZN9S10179C113v20Ev
  virtual void  v21(); // _ZN9S10179C113v21Ev
  virtual void  v22(); // _ZN9S10179C113v22Ev
  virtual void  v23(); // _ZN9S10179C113v23Ev
  virtual void  v24(); // _ZN9S10179C113v24Ev
  virtual void  v25(); // _ZN9S10179C113v25Ev
  virtual void  v26(); // _ZN9S10179C113v26Ev
  virtual void  v27(); // _ZN9S10179C113v27Ev
  virtual void  v28(); // _ZN9S10179C113v28Ev
  virtual void  v29(); // _ZN9S10179C113v29Ev
  virtual void  v30(); // _ZN9S10179C113v30Ev
  virtual void  v31(); // _ZN9S10179C113v31Ev
  virtual void  v32(); // _ZN9S10179C113v32Ev
  virtual void  v33(); // _ZN9S10179C113v33Ev
  virtual void  v34(); // _ZN9S10179C113v34Ev
  virtual void  v35(); // _ZN9S10179C113v35Ev
  virtual void  v36(); // _ZN9S10179C113v36Ev
  virtual void  v37(); // _ZN9S10179C113v37Ev
  virtual void  v38(); // _ZN9S10179C113v38Ev
  S10179C11(); // tgen
};
//SIG(-1 S10179C11) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]}}


 S10179C11 ::~S10179C11(){ note_dtor("S10179C11", this);}
void  S10179C11 ::v15(){vfunc_called(this, "_ZN9S10179C113v15Ev");}
void  S10179C11 ::v16(){vfunc_called(this, "_ZN9S10179C113v16Ev");}
void  S10179C11 ::v17(){vfunc_called(this, "_ZN9S10179C113v17Ev");}
void  S10179C11 ::v18(){vfunc_called(this, "_ZN9S10179C113v18Ev");}
void  S10179C11 ::v19(){vfunc_called(this, "_ZN9S10179C113v19Ev");}
void  S10179C11 ::v20(){vfunc_called(this, "_ZN9S10179C113v20Ev");}
void  S10179C11 ::v21(){vfunc_called(this, "_ZN9S10179C113v21Ev");}
void  S10179C11 ::v22(){vfunc_called(this, "_ZN9S10179C113v22Ev");}
void  S10179C11 ::v23(){vfunc_called(this, "_ZN9S10179C113v23Ev");}
void  S10179C11 ::v24(){vfunc_called(this, "_ZN9S10179C113v24Ev");}
void  S10179C11 ::v25(){vfunc_called(this, "_ZN9S10179C113v25Ev");}
void  S10179C11 ::v26(){vfunc_called(this, "_ZN9S10179C113v26Ev");}
void  S10179C11 ::v27(){vfunc_called(this, "_ZN9S10179C113v27Ev");}
void  S10179C11 ::v28(){vfunc_called(this, "_ZN9S10179C113v28Ev");}
void  S10179C11 ::v29(){vfunc_called(this, "_ZN9S10179C113v29Ev");}
void  S10179C11 ::v30(){vfunc_called(this, "_ZN9S10179C113v30Ev");}
void  S10179C11 ::v31(){vfunc_called(this, "_ZN9S10179C113v31Ev");}
void  S10179C11 ::v32(){vfunc_called(this, "_ZN9S10179C113v32Ev");}
void  S10179C11 ::v33(){vfunc_called(this, "_ZN9S10179C113v33Ev");}
void  S10179C11 ::v34(){vfunc_called(this, "_ZN9S10179C113v34Ev");}
void  S10179C11 ::v35(){vfunc_called(this, "_ZN9S10179C113v35Ev");}
void  S10179C11 ::v36(){vfunc_called(this, "_ZN9S10179C113v36Ev");}
void  S10179C11 ::v37(){vfunc_called(this, "_ZN9S10179C113v37Ev");}
void  S10179C11 ::v38(){vfunc_called(this, "_ZN9S10179C113v38Ev");}
S10179C11 ::S10179C11(){ note_ctor("S10179C11", this);} // tgen

static void Test_S10179C11()
{
  extern Class_Descriptor cd_S10179C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,17)];
    init_test(&cd_S10179C11, buf);
    S10179C11 *dp, &lv = *(dp=new (buf) S10179C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,64), "sizeof(S10179C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C11)");
    check_field_offset(lv, s10179c11f0, ABISELECT(8,4), "S10179C11.s10179c11f0");
    check_field_offset(lv, s10179c11f1, ABISELECT(16,8), "S10179C11.s10179c11f1");
    check_field_offset(lv, s10179c11f2, ABISELECT(40,24), "S10179C11.s10179c11f2");
    test_class_info(&lv, &cd_S10179C11);
    dp->~S10179C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C11(Test_S10179C11, "S10179C11", ABISELECT(96,64));

#else // __cplusplus

extern void _ZN9S10179C11C1Ev();
extern void _ZN9S10179C11D1Ev();
Name_Map name_map_S10179C11[] = {
  NSPAIR(_ZN9S10179C11C1Ev),
  NSPAIR(_ZN9S10179C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C11[];
extern void _ZN9S10179C11D1Ev();
extern void _ZN9S10179C11D0Ev();
extern void _ZN9S10179C113v15Ev();
extern void _ZN9S10179C113v16Ev();
extern void _ZN9S10179C113v17Ev();
extern void _ZN9S10179C113v18Ev();
extern void _ZN9S10179C113v19Ev();
extern void _ZN9S10179C113v20Ev();
extern void _ZN9S10179C113v21Ev();
extern void _ZN9S10179C113v22Ev();
extern void _ZN9S10179C113v23Ev();
extern void _ZN9S10179C113v24Ev();
extern void _ZN9S10179C113v25Ev();
extern void _ZN9S10179C113v26Ev();
extern void _ZN9S10179C113v27Ev();
extern void _ZN9S10179C113v28Ev();
extern void _ZN9S10179C113v29Ev();
extern void _ZN9S10179C113v30Ev();
extern void _ZN9S10179C113v31Ev();
extern void _ZN9S10179C113v32Ev();
extern void _ZN9S10179C113v33Ev();
extern void _ZN9S10179C113v34Ev();
extern void _ZN9S10179C113v35Ev();
extern void _ZN9S10179C113v36Ev();
extern void _ZN9S10179C113v37Ev();
extern void _ZN9S10179C113v38Ev();
static  VTBL_ENTRY vtc_S10179C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C11[0]),
  (VTBL_ENTRY)&_ZN9S10179C11D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C11D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v38Ev,
};
extern VTBL_ENTRY _ZTI9S10179C11[];
extern  VTBL_ENTRY _ZTV9S10179C11[];
Class_Descriptor cd_S10179C11 = {  "S10179C11", // class name
  0,0,//no base classes
  &(vtc_S10179C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,64), // object size
  NSPAIRA(_ZTI9S10179C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C11),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C26  {
  virtual  ~S10179C26(); // _ZN9S10179C26D1Ev
  virtual void  v64(); // _ZN9S10179C263v64Ev
  S10179C26(); // tgen
};
//SIG(-1 S10179C26) C1{ vd v1}


 S10179C26 ::~S10179C26(){ note_dtor("S10179C26", this);}
void  S10179C26 ::v64(){vfunc_called(this, "_ZN9S10179C263v64Ev");}
S10179C26 ::S10179C26(){ note_ctor("S10179C26", this);} // tgen

static void Test_S10179C26()
{
  extern Class_Descriptor cd_S10179C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10179C26, buf);
    S10179C26 *dp, &lv = *(dp=new (buf) S10179C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C26)");
    test_class_info(&lv, &cd_S10179C26);
    dp->~S10179C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C26(Test_S10179C26, "S10179C26", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10179C26C1Ev();
extern void _ZN9S10179C26D1Ev();
Name_Map name_map_S10179C26[] = {
  NSPAIR(_ZN9S10179C26C1Ev),
  NSPAIR(_ZN9S10179C26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C26[];
extern void _ZN9S10179C26D1Ev();
extern void _ZN9S10179C26D0Ev();
extern void _ZN9S10179C263v64Ev();
static  VTBL_ENTRY vtc_S10179C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C26[0]),
  (VTBL_ENTRY)&_ZN9S10179C26D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C26D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C263v64Ev,
};
extern VTBL_ENTRY _ZTI9S10179C26[];
extern  VTBL_ENTRY _ZTV9S10179C26[];
Class_Descriptor cd_S10179C26 = {  "S10179C26", // class name
  0,0,//no base classes
  &(vtc_S10179C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10179C26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C26),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C27  {
  virtual  ~S10179C27(); // _ZN9S10179C27D1Ev
  virtual void  v65(); // _ZN9S10179C273v65Ev
  virtual void  v66(); // _ZN9S10179C273v66Ev
  S10179C27(); // tgen
};
//SIG(-1 S10179C27) C1{ vd v1 v2}


 S10179C27 ::~S10179C27(){ note_dtor("S10179C27", this);}
void  S10179C27 ::v65(){vfunc_called(this, "_ZN9S10179C273v65Ev");}
void  S10179C27 ::v66(){vfunc_called(this, "_ZN9S10179C273v66Ev");}
S10179C27 ::S10179C27(){ note_ctor("S10179C27", this);} // tgen

static void Test_S10179C27()
{
  extern Class_Descriptor cd_S10179C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10179C27, buf);
    S10179C27 *dp, &lv = *(dp=new (buf) S10179C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C27)");
    test_class_info(&lv, &cd_S10179C27);
    dp->~S10179C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C27(Test_S10179C27, "S10179C27", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10179C27C1Ev();
extern void _ZN9S10179C27D1Ev();
Name_Map name_map_S10179C27[] = {
  NSPAIR(_ZN9S10179C27C1Ev),
  NSPAIR(_ZN9S10179C27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C27[];
extern void _ZN9S10179C27D1Ev();
extern void _ZN9S10179C27D0Ev();
extern void _ZN9S10179C273v65Ev();
extern void _ZN9S10179C273v66Ev();
static  VTBL_ENTRY vtc_S10179C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C27[0]),
  (VTBL_ENTRY)&_ZN9S10179C27D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C27D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C273v65Ev,
  (VTBL_ENTRY)&_ZN9S10179C273v66Ev,
};
extern VTBL_ENTRY _ZTI9S10179C27[];
extern  VTBL_ENTRY _ZTV9S10179C27[];
Class_Descriptor cd_S10179C27 = {  "S10179C27", // class name
  0,0,//no base classes
  &(vtc_S10179C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10179C27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C27),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C38  {
  long s10179c38f0[4];
};
//SIG(-1 S10179C38) C1{ Fl[4]}



static void Test_S10179C38()
{
  {
    init_simple_test("S10179C38");
    S10179C38 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S10179C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C38)");
    check_field_offset(lv, s10179c38f0, 0, "S10179C38.s10179c38f0");
  }
}
static Arrange_To_Call_Me vS10179C38(Test_S10179C38, "S10179C38", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C37  {
  ::S10179C38 s10179c37f0;
  void  mf10179c37(); // _ZN9S10179C3710mf10179c37Ev
};
//SIG(-1 S10179C37) C1{ m FC2{ Fl[4]}}


void  S10179C37 ::mf10179c37(){}

static void Test_S10179C37()
{
  {
    init_simple_test("S10179C37");
    S10179C37 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S10179C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C37)");
    check_field_offset(lv, s10179c37f0, 0, "S10179C37.s10179c37f0");
  }
}
static Arrange_To_Call_Me vS10179C37(Test_S10179C37, "S10179C37", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C36  {
  char s10179c36f0[2];
  void *s10179c36f1[3];
  int s10179c36f2[4];
  ::S10179C37 s10179c36f3;
  void  mf10179c36(); // _ZN9S10179C3610mf10179c36Ev
};
//SIG(-1 S10179C36) C1{ m Fc[2] Fp[3] Fi[4] FC2{ m FC3{ Fl[4]}}}


void  S10179C36 ::mf10179c36(){}

static void Test_S10179C36()
{
  {
    init_simple_test("S10179C36");
    S10179C36 lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S10179C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C36)");
    check_field_offset(lv, s10179c36f0, 0, "S10179C36.s10179c36f0");
    check_field_offset(lv, s10179c36f1, ABISELECT(8,4), "S10179C36.s10179c36f1");
    check_field_offset(lv, s10179c36f2, ABISELECT(32,16), "S10179C36.s10179c36f2");
    check_field_offset(lv, s10179c36f3, ABISELECT(48,32), "S10179C36.s10179c36f3");
  }
}
static Arrange_To_Call_Me vS10179C36(Test_S10179C36, "S10179C36", ABISELECT(80,48));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C35  {
  int s10179c35f0;
  void *s10179c35f1[3];
  ::S10179C36 s10179c35f2;
  void  mf10179c35(); // _ZN9S10179C3510mf10179c35Ev
  virtual  ~S10179C35(); // _ZN9S10179C35D1Ev
  S10179C35(); // tgen
};
//SIG(-1 S10179C35) C1{ vd m Fi Fp[3] FC2{ m Fc[2] Fp[3] Fi[4] FC3{ m FC4{ Fl[4]}}}}


void  S10179C35 ::mf10179c35(){}
 S10179C35 ::~S10179C35(){ note_dtor("S10179C35", this);}
S10179C35 ::S10179C35(){ note_ctor("S10179C35", this);} // tgen

static void Test_S10179C35()
{
  extern Class_Descriptor cd_S10179C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,18)];
    init_test(&cd_S10179C35, buf);
    S10179C35 *dp, &lv = *(dp=new (buf) S10179C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,68), "sizeof(S10179C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C35)");
    check_field_offset(lv, s10179c35f0, ABISELECT(8,4), "S10179C35.s10179c35f0");
    check_field_offset(lv, s10179c35f1, ABISELECT(16,8), "S10179C35.s10179c35f1");
    check_field_offset(lv, s10179c35f2, ABISELECT(40,20), "S10179C35.s10179c35f2");
    test_class_info(&lv, &cd_S10179C35);
    dp->~S10179C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C35(Test_S10179C35, "S10179C35", ABISELECT(120,68));

#else // __cplusplus

extern void _ZN9S10179C35C1Ev();
extern void _ZN9S10179C35D1Ev();
Name_Map name_map_S10179C35[] = {
  NSPAIR(_ZN9S10179C35C1Ev),
  NSPAIR(_ZN9S10179C35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C35[];
extern void _ZN9S10179C35D1Ev();
extern void _ZN9S10179C35D0Ev();
static  VTBL_ENTRY vtc_S10179C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C35[0]),
  (VTBL_ENTRY)&_ZN9S10179C35D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C35D0Ev,
};
extern VTBL_ENTRY _ZTI9S10179C35[];
extern  VTBL_ENTRY _ZTV9S10179C35[];
Class_Descriptor cd_S10179C35 = {  "S10179C35", // class name
  0,0,//no base classes
  &(vtc_S10179C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,68), // object size
  NSPAIRA(_ZTI9S10179C35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C35),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C39  {
  ::S10179C37 s10179c39f0;
  int s10179c39f1[2];
  ::S10180C41 s10179c39f2;
  __tsi64 s10179c39f3;
  ::S10180C42 s10179c39f4;
  ::S10180C31 s10179c39f5;
  char s10179c39f6[2];
  int s10179c39f7[2];
  void *s10179c39f8[2];
  __tsi64 s10179c39f9;
  int s10179c39f10[3];
  void  mf10179c39(); // _ZN9S10179C3910mf10179c39Ev
  virtual  ~S10179C39(); // _ZN9S10179C39D1Ev
  S10179C39(); // tgen
};
//SIG(-1 S10179C39) C1{ vd m FC2{ m FC3{ Fl[4]}} Fi[2] FC4{ m FL[3] Fi[3] FL} FL FC5{ m Fi FC6{ m Fi[4]}} FC7{ m FC8{ m Fp Fi[2] FC9{ m}} Fp[2]} Fc[2] Fi[2] Fp[2] FL Fi[3]}


void  S10179C39 ::mf10179c39(){}
 S10179C39 ::~S10179C39(){ note_dtor("S10179C39", this);}
S10179C39 ::S10179C39(){ note_ctor("S10179C39", this);} // tgen

static void Test_S10179C39()
{
  extern Class_Descriptor cd_S10179C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,42)];
    init_test(&cd_S10179C39, buf);
    S10179C39 *dp, &lv = *(dp=new (buf) S10179C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,164), "sizeof(S10179C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C39)");
    check_field_offset(lv, s10179c39f0, ABISELECT(8,4), "S10179C39.s10179c39f0");
    check_field_offset(lv, s10179c39f1, ABISELECT(40,20), "S10179C39.s10179c39f1");
    check_field_offset(lv, s10179c39f2, ABISELECT(48,28), "S10179C39.s10179c39f2");
    check_field_offset(lv, s10179c39f3, ABISELECT(96,72), "S10179C39.s10179c39f3");
    check_field_offset(lv, s10179c39f4, ABISELECT(104,80), "S10179C39.s10179c39f4");
    check_field_offset(lv, s10179c39f5, ABISELECT(128,100), "S10179C39.s10179c39f5");
    check_field_offset(lv, s10179c39f6, ABISELECT(168,124), "S10179C39.s10179c39f6");
    check_field_offset(lv, s10179c39f7, ABISELECT(172,128), "S10179C39.s10179c39f7");
    check_field_offset(lv, s10179c39f8, ABISELECT(184,136), "S10179C39.s10179c39f8");
    check_field_offset(lv, s10179c39f9, ABISELECT(200,144), "S10179C39.s10179c39f9");
    check_field_offset(lv, s10179c39f10, ABISELECT(208,152), "S10179C39.s10179c39f10");
    test_class_info(&lv, &cd_S10179C39);
    dp->~S10179C39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C39(Test_S10179C39, "S10179C39", ABISELECT(224,164));

#else // __cplusplus

extern void _ZN9S10179C39C1Ev();
extern void _ZN9S10179C39D1Ev();
Name_Map name_map_S10179C39[] = {
  NSPAIR(_ZN9S10179C39C1Ev),
  NSPAIR(_ZN9S10179C39D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C39[];
extern void _ZN9S10179C39D1Ev();
extern void _ZN9S10179C39D0Ev();
static  VTBL_ENTRY vtc_S10179C39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C39[0]),
  (VTBL_ENTRY)&_ZN9S10179C39D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C39D0Ev,
};
extern VTBL_ENTRY _ZTI9S10179C39[];
extern  VTBL_ENTRY _ZTV9S10179C39[];
Class_Descriptor cd_S10179C39 = {  "S10179C39", // class name
  0,0,//no base classes
  &(vtc_S10179C39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,164), // object size
  NSPAIRA(_ZTI9S10179C39),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C39),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C53  {
  int s10179c53f0;
  char s10179c53f1[3];
  virtual  ~S10179C53(); // _ZN9S10179C53D1Ev
  virtual void  v84(); // _ZN9S10179C533v84Ev
  S10179C53(); // tgen
};
//SIG(-1 S10179C53) C1{ vd v1 Fi Fc[3]}


 S10179C53 ::~S10179C53(){ note_dtor("S10179C53", this);}
void  S10179C53 ::v84(){vfunc_called(this, "_ZN9S10179C533v84Ev");}
S10179C53 ::S10179C53(){ note_ctor("S10179C53", this);} // tgen

static void Test_S10179C53()
{
  extern Class_Descriptor cd_S10179C53;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S10179C53, buf);
    S10179C53 *dp, &lv = *(dp=new (buf) S10179C53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10179C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C53)");
    check_field_offset(lv, s10179c53f0, ABISELECT(8,4), "S10179C53.s10179c53f0");
    check_field_offset(lv, s10179c53f1, ABISELECT(12,8), "S10179C53.s10179c53f1");
    test_class_info(&lv, &cd_S10179C53);
    dp->~S10179C53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C53(Test_S10179C53, "S10179C53", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN9S10179C53C1Ev();
extern void _ZN9S10179C53D1Ev();
Name_Map name_map_S10179C53[] = {
  NSPAIR(_ZN9S10179C53C1Ev),
  NSPAIR(_ZN9S10179C53D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C53[];
extern void _ZN9S10179C53D1Ev();
extern void _ZN9S10179C53D0Ev();
extern void _ZN9S10179C533v84Ev();
static  VTBL_ENTRY vtc_S10179C53[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C53[0]),
  (VTBL_ENTRY)&_ZN9S10179C53D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C53D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C533v84Ev,
};
extern VTBL_ENTRY _ZTI9S10179C53[];
extern  VTBL_ENTRY _ZTV9S10179C53[];
Class_Descriptor cd_S10179C53 = {  "S10179C53", // class name
  0,0,//no base classes
  &(vtc_S10179C53[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI9S10179C53),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C53),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C57  {
  ::S10179C37 s10179c57f0;
  ::S10180C54 s10179c57f1;
  void *s10179c57f2;
  int s10179c57f3[5];
  void  mf10179c57(); // _ZN9S10179C5710mf10179c57Ev
};
//SIG(-1 S10179C57) C1{ m FC2{ m FC3{ Fl[4]}} FC4{ m Fp FC5{ Fi[4]}} Fp Fi[5]}


void  S10179C57 ::mf10179c57(){}

static void Test_S10179C57()
{
  {
    init_simple_test("S10179C57");
    S10179C57 lv;
    check2(sizeof(lv), ABISELECT(88,60), "sizeof(S10179C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C57)");
    check_field_offset(lv, s10179c57f0, 0, "S10179C57.s10179c57f0");
    check_field_offset(lv, s10179c57f1, ABISELECT(32,16), "S10179C57.s10179c57f1");
    check_field_offset(lv, s10179c57f2, ABISELECT(56,36), "S10179C57.s10179c57f2");
    check_field_offset(lv, s10179c57f3, ABISELECT(64,40), "S10179C57.s10179c57f3");
  }
}
static Arrange_To_Call_Me vS10179C57(Test_S10179C57, "S10179C57", ABISELECT(88,60));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C56  : S10179C53 {
  ::S10179C37 s10179c56f0;
  int s10179c56f1;
  void *s10179c56f2[2];
  ::S10179C57 s10179c56f3;
  short s10179c56f4[3585];
  char s10179c56f5[4096];
  int s10179c56f6;
  virtual  ~S10179C56(); // _ZN9S10179C56D1Ev
  virtual void  v85(); // _ZN9S10179C563v85Ev
  S10179C56(); // tgen
};
//SIG(-1 S10179C56) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 FC3{ m FC4{ Fl[4]}} Fi Fp[2] FC5{ m FC3 FC6{ m Fp FC7{ Fi[4]}} Fp Fi[5]} Fs[3585] Fc[4096] Fi}


 S10179C56 ::~S10179C56(){ note_dtor("S10179C56", this);}
void  S10179C56 ::v85(){vfunc_called(this, "_ZN9S10179C563v85Ev");}
S10179C56 ::S10179C56(){ note_ctor("S10179C56", this);} // tgen

static void Test_S10179C56()
{
  extern Class_Descriptor cd_S10179C56;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1430,2844)];
    init_test(&cd_S10179C56, buf);
    S10179C56 *dp, &lv = *(dp=new (buf) S10179C56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(11432,11372), "sizeof(S10179C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C56)");
    check_base_class_offset(lv, (S10179C53*), 0, "S10179C56");
    check_field_offset(lv, s10179c56f0, ABISELECT(16,12), "S10179C56.s10179c56f0");
    check_field_offset(lv, s10179c56f1, ABISELECT(48,28), "S10179C56.s10179c56f1");
    check_field_offset(lv, s10179c56f2, ABISELECT(56,32), "S10179C56.s10179c56f2");
    check_field_offset(lv, s10179c56f3, ABISELECT(72,40), "S10179C56.s10179c56f3");
    check_field_offset(lv, s10179c56f4, ABISELECT(160,100), "S10179C56.s10179c56f4");
    check_field_offset(lv, s10179c56f5, ABISELECT(7330,7270), "S10179C56.s10179c56f5");
    check_field_offset(lv, s10179c56f6, ABISELECT(11428,11368), "S10179C56.s10179c56f6");
    test_class_info(&lv, &cd_S10179C56);
    dp->~S10179C56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C56(Test_S10179C56, "S10179C56", ABISELECT(11432,11372));

#else // __cplusplus

extern void _ZN9S10179C56C1Ev();
extern void _ZN9S10179C56D1Ev();
Name_Map name_map_S10179C56[] = {
  NSPAIR(_ZN9S10179C56C1Ev),
  NSPAIR(_ZN9S10179C56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10179C53;
extern VTBL_ENTRY _ZTI9S10179C53[];
extern  VTBL_ENTRY _ZTV9S10179C53[];
static Base_Class bases_S10179C56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10179C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C56[];
extern void _ZN9S10179C56D1Ev();
extern void _ZN9S10179C56D0Ev();
extern void _ZN9S10179C533v84Ev();
extern void _ZN9S10179C563v85Ev();
static  VTBL_ENTRY vtc_S10179C56[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C56[0]),
  (VTBL_ENTRY)&_ZN9S10179C56D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C56D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C533v84Ev,
  (VTBL_ENTRY)&_ZN9S10179C563v85Ev,
};
extern VTBL_ENTRY _ZTI9S10179C56[];
extern  VTBL_ENTRY _ZTV9S10179C56[];
Class_Descriptor cd_S10179C56 = {  "S10179C56", // class name
  bases_S10179C56, 1,
  &(vtc_S10179C56[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(11432,11372), // object size
  NSPAIRA(_ZTI9S10179C56),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10179C56),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C52  : S10179C53 {
  void *s10179c52f0[4];
  __tsi64 s10179c52f1;
  int s10179c52f2;
  ::S10179C37 s10179c52f3;
  ::S10180C54 s10179c52f4;
  short s10179c52f5[1024];
  int s10179c52f6[4];
  __tsi64 s10179c52f7[2];
  int s10179c52f8;
  ::S10179C56 s10179c52f9;
  virtual  ~S10179C52(); // _ZN9S10179C52D1Ev
  virtual void  v83(); // _ZN9S10179C523v83Ev
  S10179C52(); // tgen
};
//SIG(-1 S10179C52) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 Fp[4] FL Fi FC3{ m FC4{ Fl[4]}} FC5{ m Fp FC6{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC7{ BC2 vd v3 FC3 Fi Fp[2] FC8{ m FC3 FC5 Fp Fi[5]} Fs[3585] Fc[4096] Fi}}


 S10179C52 ::~S10179C52(){ note_dtor("S10179C52", this);}
void  S10179C52 ::v83(){vfunc_called(this, "_ZN9S10179C523v83Ev");}
S10179C52 ::S10179C52(){ note_ctor("S10179C52", this);} // tgen

static void Test_S10179C52()
{
  extern Class_Descriptor cd_S10179C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1706,3384)];
    init_test(&cd_S10179C52, buf);
    S10179C52 *dp, &lv = *(dp=new (buf) S10179C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13640,13532), "sizeof(S10179C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C52)");
    check_base_class_offset(lv, (S10179C53*), 0, "S10179C52");
    check_field_offset(lv, s10179c52f0, ABISELECT(16,12), "S10179C52.s10179c52f0");
    check_field_offset(lv, s10179c52f1, ABISELECT(48,28), "S10179C52.s10179c52f1");
    check_field_offset(lv, s10179c52f2, ABISELECT(56,36), "S10179C52.s10179c52f2");
    check_field_offset(lv, s10179c52f3, ABISELECT(64,40), "S10179C52.s10179c52f3");
    check_field_offset(lv, s10179c52f4, ABISELECT(96,56), "S10179C52.s10179c52f4");
    check_field_offset(lv, s10179c52f5, ABISELECT(120,76), "S10179C52.s10179c52f5");
    check_field_offset(lv, s10179c52f6, ABISELECT(2168,2124), "S10179C52.s10179c52f6");
    check_field_offset(lv, s10179c52f7, ABISELECT(2184,2140), "S10179C52.s10179c52f7");
    check_field_offset(lv, s10179c52f8, ABISELECT(2200,2156), "S10179C52.s10179c52f8");
    check_field_offset(lv, s10179c52f9, ABISELECT(2208,2160), "S10179C52.s10179c52f9");
    test_class_info(&lv, &cd_S10179C52);
    dp->~S10179C52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C52(Test_S10179C52, "S10179C52", ABISELECT(13640,13532));

#else // __cplusplus

extern void _ZN9S10179C52C1Ev();
extern void _ZN9S10179C52D1Ev();
Name_Map name_map_S10179C52[] = {
  NSPAIR(_ZN9S10179C52C1Ev),
  NSPAIR(_ZN9S10179C52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10179C53;
extern VTBL_ENTRY _ZTI9S10179C53[];
extern  VTBL_ENTRY _ZTV9S10179C53[];
static Base_Class bases_S10179C52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10179C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C52[];
extern void _ZN9S10179C52D1Ev();
extern void _ZN9S10179C52D0Ev();
extern void _ZN9S10179C533v84Ev();
extern void _ZN9S10179C523v83Ev();
static  VTBL_ENTRY vtc_S10179C52[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C52[0]),
  (VTBL_ENTRY)&_ZN9S10179C52D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C52D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C533v84Ev,
  (VTBL_ENTRY)&_ZN9S10179C523v83Ev,
};
extern VTBL_ENTRY _ZTI9S10179C52[];
extern  VTBL_ENTRY _ZTV9S10179C52[];
Class_Descriptor cd_S10179C52 = {  "S10179C52", // class name
  bases_S10179C52, 1,
  &(vtc_S10179C52[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(13640,13532), // object size
  NSPAIRA(_ZTI9S10179C52),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10179C52),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C60  {
  ::S10179C37 s10179c60f0;
  ::S10180C54 s10179c60f1;
  void *s10179c60f2;
  int s10179c60f3[4];
  void  mf10179c60(); // _ZN9S10179C6010mf10179c60Ev
};
//SIG(-1 S10179C60) C1{ m FC2{ m FC3{ Fl[4]}} FC4{ m Fp FC5{ Fi[4]}} Fp Fi[4]}


void  S10179C60 ::mf10179c60(){}

static void Test_S10179C60()
{
  {
    init_simple_test("S10179C60");
    S10179C60 lv;
    check2(sizeof(lv), ABISELECT(80,56), "sizeof(S10179C60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C60)");
    check_field_offset(lv, s10179c60f0, 0, "S10179C60.s10179c60f0");
    check_field_offset(lv, s10179c60f1, ABISELECT(32,16), "S10179C60.s10179c60f1");
    check_field_offset(lv, s10179c60f2, ABISELECT(56,36), "S10179C60.s10179c60f2");
    check_field_offset(lv, s10179c60f3, ABISELECT(64,40), "S10179C60.s10179c60f3");
  }
}
static Arrange_To_Call_Me vS10179C60(Test_S10179C60, "S10179C60", ABISELECT(80,56));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C58  : S10179C53 {
  void *s10179c58f0[2];
  __tsi64 s10179c58f1;
  int s10179c58f2[4];
  ::S10180C118 s10179c58f3;
  ::S10179C37 s10179c58f4;
  ::S10179C60 s10179c58f5;
  ::S10180C114 s10179c58f6;
  virtual  ~S10179C58(); // _ZN9S10179C58D1Ev
  virtual void  v86(); // _ZN9S10179C583v86Ev
  S10179C58(); // tgen
};
//SIG(-1 S10179C58) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 Fp[2] FL Fi[4] FC3{ m Fi[2]} FC4{ m FC5{ Fl[4]}} FC6{ m FC4 FC7{ m Fp FC8{ Fi[4]}} Fp Fi[4]} FC9{ m Fp}}


 S10179C58 ::~S10179C58(){ note_dtor("S10179C58", this);}
void  S10179C58 ::v86(){vfunc_called(this, "_ZN9S10179C583v86Ev");}
S10179C58 ::S10179C58(){ note_ctor("S10179C58", this);} // tgen

static void Test_S10179C58()
{
  extern Class_Descriptor cd_S10179C58;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,33)];
    init_test(&cd_S10179C58, buf);
    S10179C58 *dp, &lv = *(dp=new (buf) S10179C58());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,128), "sizeof(S10179C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C58)");
    check_base_class_offset(lv, (S10179C53*), 0, "S10179C58");
    check_field_offset(lv, s10179c58f0, ABISELECT(16,12), "S10179C58.s10179c58f0");
    check_field_offset(lv, s10179c58f1, ABISELECT(32,20), "S10179C58.s10179c58f1");
    check_field_offset(lv, s10179c58f2, ABISELECT(40,28), "S10179C58.s10179c58f2");
    check_field_offset(lv, s10179c58f3, ABISELECT(56,44), "S10179C58.s10179c58f3");
    check_field_offset(lv, s10179c58f4, ABISELECT(64,52), "S10179C58.s10179c58f4");
    check_field_offset(lv, s10179c58f5, ABISELECT(96,68), "S10179C58.s10179c58f5");
    check_field_offset(lv, s10179c58f6, ABISELECT(176,124), "S10179C58.s10179c58f6");
    test_class_info(&lv, &cd_S10179C58);
    dp->~S10179C58();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C58(Test_S10179C58, "S10179C58", ABISELECT(184,128));

#else // __cplusplus

extern void _ZN9S10179C58C1Ev();
extern void _ZN9S10179C58D1Ev();
Name_Map name_map_S10179C58[] = {
  NSPAIR(_ZN9S10179C58C1Ev),
  NSPAIR(_ZN9S10179C58D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10179C53;
extern VTBL_ENTRY _ZTI9S10179C53[];
extern  VTBL_ENTRY _ZTV9S10179C53[];
static Base_Class bases_S10179C58[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10179C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C58[];
extern void _ZN9S10179C58D1Ev();
extern void _ZN9S10179C58D0Ev();
extern void _ZN9S10179C533v84Ev();
extern void _ZN9S10179C583v86Ev();
static  VTBL_ENTRY vtc_S10179C58[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C58[0]),
  (VTBL_ENTRY)&_ZN9S10179C58D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C58D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C533v84Ev,
  (VTBL_ENTRY)&_ZN9S10179C583v86Ev,
};
extern VTBL_ENTRY _ZTI9S10179C58[];
extern  VTBL_ENTRY _ZTV9S10179C58[];
Class_Descriptor cd_S10179C58 = {  "S10179C58", // class name
  bases_S10179C58, 1,
  &(vtc_S10179C58[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,128), // object size
  NSPAIRA(_ZTI9S10179C58),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10179C58),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C47  {
  ::S10180C48 s10179c47f0;
  ::S10180C50 s10179c47f1;
  ::S10179C52 s10179c47f2;
  ::S10179C58 s10179c47f3;
  ::S10179C37 s10179c47f4;
  ::S10179C37 s10179c47f5;
  __tsi64 s10179c47f6;
  int s10179c47f7[5];
  void  mf10179c47(); // _ZN9S10179C4710mf10179c47Ev
  virtual  ~S10179C47(); // _ZN9S10179C47D1Ev
  S10179C47(); // tgen
};
//SIG(-1 S10179C47) C1{ vd m FC2{ vd m FC3{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC4{ BC5{ vd v7 v8 v9 v10 v11 v12 Fi Fp Fc} vd v1 v2 v3 v4 v5 v6 Fp} FC6{ BC7{ vd v14 Fi Fc[3]} vd v13 Fp[4] FL Fi FC8{ m FC9{ Fl[4]}} FC10{ m Fp FC11{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC12{ BC7 vd v15 FC8 Fi Fp[2] FC13{ m FC8 FC10 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC14{ BC7 vd v16 Fp[2] FL Fi[4] FC15{ m Fi[2]} FC8 FC16{ m FC8 FC10 Fp Fi[4]} FC17{ m Fp}} FC8 FC8 FL Fi[5]}


void  S10179C47 ::mf10179c47(){}
 S10179C47 ::~S10179C47(){ note_dtor("S10179C47", this);}
S10179C47 ::S10179C47(){ note_ctor("S10179C47", this);} // tgen

static void Test_S10179C47()
{
  extern Class_Descriptor cd_S10179C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1763,3459)];
    init_test(&cd_S10179C47, buf);
    S10179C47 *dp, &lv = *(dp=new (buf) S10179C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14096,13832), "sizeof(S10179C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C47)");
    check_field_offset(lv, s10179c47f0, ABISELECT(8,4), "S10179C47.s10179c47f0");
    check_field_offset(lv, s10179c47f1, ABISELECT(136,92), "S10179C47.s10179c47f1");
    check_field_offset(lv, s10179c47f2, ABISELECT(176,112), "S10179C47.s10179c47f2");
    check_field_offset(lv, s10179c47f3, ABISELECT(13816,13644), "S10179C47.s10179c47f3");
    check_field_offset(lv, s10179c47f4, ABISELECT(14000,13772), "S10179C47.s10179c47f4");
    check_field_offset(lv, s10179c47f5, ABISELECT(14032,13788), "S10179C47.s10179c47f5");
    check_field_offset(lv, s10179c47f6, ABISELECT(14064,13804), "S10179C47.s10179c47f6");
    check_field_offset(lv, s10179c47f7, ABISELECT(14072,13812), "S10179C47.s10179c47f7");
    test_class_info(&lv, &cd_S10179C47);
    dp->~S10179C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C47(Test_S10179C47, "S10179C47", ABISELECT(14096,13832));

#else // __cplusplus

extern void _ZN9S10179C47C1Ev();
extern void _ZN9S10179C47D1Ev();
Name_Map name_map_S10179C47[] = {
  NSPAIR(_ZN9S10179C47C1Ev),
  NSPAIR(_ZN9S10179C47D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C47[];
extern void _ZN9S10179C47D1Ev();
extern void _ZN9S10179C47D0Ev();
static  VTBL_ENTRY vtc_S10179C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C47[0]),
  (VTBL_ENTRY)&_ZN9S10179C47D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C47D0Ev,
};
extern VTBL_ENTRY _ZTI9S10179C47[];
extern  VTBL_ENTRY _ZTV9S10179C47[];
Class_Descriptor cd_S10179C47 = {  "S10179C47", // class name
  0,0,//no base classes
  &(vtc_S10179C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(14096,13832), // object size
  NSPAIRA(_ZTI9S10179C47),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C47),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C44  : S10180C17 , S10179C24 {
  int s10179c44f0;
  ::S10180C45 s10179c44f1;
  ::S10180C46 s10179c44f2;
  void *s10179c44f3;
  ::S10179C47 s10179c44f4;
  __tsi64 s10179c44f5;
  ::S10180C62 s10179c44f6;
  char s10179c44f7[128];
  ::S10180C169 s10179c44f8;
  ::S10180C31 s10179c44f9;
  virtual  ~S10179C44(); // _ZN9S10179C44D1Ev
  virtual void  v70(); // _ZN9S10179C443v70Ev
  S10179C44(); // tgen
};
//SIG(-1 S10179C44) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v2} vd v1 Fi FC7{ m Fc[2]} FC8{ Fp[2]} Fp FC9{ vd m FC10{ vd m FC11{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC12{ BC13{ vd v9 v10 v11 v12 v13 v14 Fi Fp Fc} vd v3 v4 v5 v6 v7 v8 Fp} FC14{ BC15{ vd v16 Fi Fc[3]} vd v15 Fp[4] FL Fi FC16{ m FC17{ Fl[4]}} FC18{ m Fp FC19{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC20{ BC15 vd v17 FC16 Fi Fp[2] FC21{ m FC16 FC18 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC22{ BC15 vd v18 Fp[2] FL Fi[4] FC23{ m Fi[2]} FC16 FC24{ m FC16 FC18 Fp Fi[4]} FC25{ m Fp}} FC16 FC16 FL Fi[5]} FL FC26{ m FC27{ m FL[3] Fi[3] FL} FC28{ m Fi} Fi} Fc[128] FC29{ m Fi[2]} FC30{ m FC31{ m Fp Fi[2] FC5} Fp[2]}}


 S10179C44 ::~S10179C44(){ note_dtor("S10179C44", this);}
void  S10179C44 ::v70(){vfunc_called(this, "_ZN9S10179C443v70Ev");}
S10179C44 ::S10179C44(){ note_ctor("S10179C44", this);} // tgen

static void Test_S10179C44()
{
  extern Class_Descriptor cd_S10179C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1804,3528)];
    init_test(&cd_S10179C44, buf);
    S10179C44 *dp, &lv = *(dp=new (buf) S10179C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14424,14108), "sizeof(S10179C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C44)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C44");
    check_base_class_offset(lv, (S10179C24*), ABISELECT(48,32), "S10179C44");
    check_field_offset(lv, s10179c44f0, ABISELECT(56,36), "S10179C44.s10179c44f0");
    check_field_offset(lv, s10179c44f1, ABISELECT(60,40), "S10179C44.s10179c44f1");
    check_field_offset(lv, s10179c44f2, ABISELECT(64,44), "S10179C44.s10179c44f2");
    check_field_offset(lv, s10179c44f3, ABISELECT(80,52), "S10179C44.s10179c44f3");
    check_field_offset(lv, s10179c44f4, ABISELECT(88,56), "S10179C44.s10179c44f4");
    check_field_offset(lv, s10179c44f5, ABISELECT(14184,13888), "S10179C44.s10179c44f5");
    check_field_offset(lv, s10179c44f6, ABISELECT(14192,13896), "S10179C44.s10179c44f6");
    check_field_offset(lv, s10179c44f7, ABISELECT(14248,13948), "S10179C44.s10179c44f7");
    check_field_offset(lv, s10179c44f8, ABISELECT(14376,14076), "S10179C44.s10179c44f8");
    check_field_offset(lv, s10179c44f9, ABISELECT(14384,14084), "S10179C44.s10179c44f9");
    test_class_info(&lv, &cd_S10179C44);
    dp->~S10179C44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C44(Test_S10179C44, "S10179C44", ABISELECT(14424,14108));

#else // __cplusplus

extern void _ZN9S10179C44C1Ev();
extern void _ZN9S10179C44D1Ev();
Name_Map name_map_S10179C44[] = {
  NSPAIR(_ZN9S10179C44C1Ev),
  NSPAIR(_ZN9S10179C44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C24;
extern VTBL_ENTRY _ZTI9S10179C24[];
extern  VTBL_ENTRY _ZTV9S10179C24[];
static Base_Class bases_S10179C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C24,    ABISELECT(48,32), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C44[];
extern void _ZN9S10179C44D1Ev();
extern void _ZN9S10179C44D0Ev();
extern void _ZN9S10179C443v70Ev();
extern void ABISELECT(_ZThn48_N9S10179C44D1Ev,_ZThn32_N9S10179C44D1Ev)();
extern void ABISELECT(_ZThn48_N9S10179C44D0Ev,_ZThn32_N9S10179C44D0Ev)();
extern void _ZN9S10179C243v41Ev();
static  VTBL_ENTRY vtc_S10179C44[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C44[0]),
  (VTBL_ENTRY)&_ZN9S10179C44D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C44D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C443v70Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10179C44[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C44D1Ev,_ZThn32_N9S10179C44D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C44D0Ev,_ZThn32_N9S10179C44D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10179C44[];
extern  VTBL_ENTRY _ZTV9S10179C44[];
Class_Descriptor cd_S10179C44 = {  "S10179C44", // class name
  bases_S10179C44, 2,
  &(vtc_S10179C44[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(14424,14108), // object size
  NSPAIRA(_ZTI9S10179C44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10179C44),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C25  : S10180C17 , S10179C2 , S10179C11 , S10179C26 , S10179C27 {
  int s10179c25f0;
  ::S10180C169 s10179c25f1;
  ::S10180C169 s10179c25f2;
  ::S10180C169 s10179c25f3;
  ::S10180C29 s10179c25f4;
  ::S10180C34 s10179c25f5;
  ::S10179C35 s10179c25f6;
  ::S10179C39 s10179c25f7;
  int s10179c25f8;
  void *s10179c25f9;
  ::S10179C44 s10179c25f10;
  int s10179c25f11[3];
  ::S10180C64 s10179c25f12;
  ::S10180C65 s10179c25f13;
  ::S10180C66 s10179c25f14;
  ::S10180C87 s10179c25f15;
  __tsi64 s10179c25f16;
  ::S10180C106 s10179c25f17;
  ::S10180C86 s10179c25f18;
  ::S10180C68 s10179c25f19;
  ::S10180C31 s10179c25f20;
  char s10179c25f21;
  virtual  ~S10179C25(); // _ZN9S10179C25D1Ev
  virtual void  v42(); // _ZN9S10179C253v42Ev
  virtual void  v43(); // _ZN9S10179C253v43Ev
  virtual void  v44(); // _ZN9S10179C253v44Ev
  virtual void  v45(); // _ZN9S10179C253v45Ev
  virtual void  v46(); // _ZN9S10179C253v46Ev
  virtual void  v47(); // _ZN9S10179C253v47Ev
  virtual void  v48(); // _ZN9S10179C253v48Ev
  virtual void  v49(); // _ZN9S10179C253v49Ev
  virtual void  v50(); // _ZN9S10179C253v50Ev
  virtual void  v51(); // _ZN9S10179C253v51Ev
  virtual void  v52(); // _ZN9S10179C253v52Ev
  virtual void  v53(); // _ZN9S10179C253v53Ev
  virtual void  v54(); // _ZN9S10179C253v54Ev
  virtual void  v55(); // _ZN9S10179C253v55Ev
  virtual void  v56(); // _ZN9S10179C253v56Ev
  virtual void  v57(); // _ZN9S10179C253v57Ev
  virtual void  v58(); // _ZN9S10179C253v58Ev
  virtual void  v59(); // _ZN9S10179C253v59Ev
  virtual void  v60(); // _ZN9S10179C253v60Ev
  virtual void  v61(); // _ZN9S10179C253v61Ev
  virtual void  v62(); // _ZN9S10179C253v62Ev
  virtual void  v63(); // _ZN9S10179C253v63Ev
  S10179C25(); // tgen
};
//SIG(-1 S10179C25) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v23} BC7{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 Fp FC8{ m FC9{ m Fp Fi FC4} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC11{ vd v48} BC12{ vd v49 v50} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi FC13{ m Fi[2]} FC13 FC13 FC14{ BC2 vd Fi Fp FC8 FL FC15{ m Fi[2]} Fi Fc Fi FC16{ m FC17{ m Fp Fi[2] FC5} Fp[2]}} FC18{ BC19{ vd v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 Fp FC8 FC10} vd v51 v52 v53} FC20{ vd m Fi Fp[3] FC21{ m Fc[2] Fp[3] Fi[4] FC22{ m FC23{ Fl[4]}}}} FC24{ vd m FC22 Fi[2] FC25{ m FL[3] Fi[3] FL} FL FC26{ m Fi FC27{ m Fi[4]}} FC16 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC28{ BC2 BC29{ vd v79} vd v78 Fi FC30{ m Fc[2]} FC31{ Fp[2]} Fp FC32{ vd m FC33{ vd m FC34{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC35{ BC36{ vd v86 v87 v88 v89 v90 v91 Fi Fp Fc} vd v80 v81 v82 v83 v84 v85 Fp} FC37{ BC38{ vd v93 Fi Fc[3]} vd v92 Fp[4] FL Fi FC22 FC39{ m Fp FC40{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC41{ BC38 vd v94 FC22 Fi Fp[2] FC42{ m FC22 FC39 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC43{ BC38 vd v95 Fp[2] FL Fi[4] FC44{ m Fi[2]} FC22 FC45{ m FC22 FC39 Fp Fi[4]} FC46{ m Fp}} FC22 FC22 FL Fi[5]} FL FC47{ m FC25 FC48{ m Fi} Fi} Fc[128] FC13 FC16} Fi[3] FC49{ m Fp Fi[2]} FC50{ m Fc[11] Fi[2]} FC51{ BC52{} FL Fi} FC53{ BC54{ BC2 vd v98 v99 v100 v101 FC55{ m Fp FC8 FC9 FC9 Fi[3] FC56{ m FC57{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v96 v97} FL FC58{ BC54 v102} FC59{ BC54 v103} FC60{ BC54 v104 v105} FC16 Fc}


 S10179C25 ::~S10179C25(){ note_dtor("S10179C25", this);}
void  S10179C25 ::v42(){vfunc_called(this, "_ZN9S10179C253v42Ev");}
void  S10179C25 ::v43(){vfunc_called(this, "_ZN9S10179C253v43Ev");}
void  S10179C25 ::v44(){vfunc_called(this, "_ZN9S10179C253v44Ev");}
void  S10179C25 ::v45(){vfunc_called(this, "_ZN9S10179C253v45Ev");}
void  S10179C25 ::v46(){vfunc_called(this, "_ZN9S10179C253v46Ev");}
void  S10179C25 ::v47(){vfunc_called(this, "_ZN9S10179C253v47Ev");}
void  S10179C25 ::v48(){vfunc_called(this, "_ZN9S10179C253v48Ev");}
void  S10179C25 ::v49(){vfunc_called(this, "_ZN9S10179C253v49Ev");}
void  S10179C25 ::v50(){vfunc_called(this, "_ZN9S10179C253v50Ev");}
void  S10179C25 ::v51(){vfunc_called(this, "_ZN9S10179C253v51Ev");}
void  S10179C25 ::v52(){vfunc_called(this, "_ZN9S10179C253v52Ev");}
void  S10179C25 ::v53(){vfunc_called(this, "_ZN9S10179C253v53Ev");}
void  S10179C25 ::v54(){vfunc_called(this, "_ZN9S10179C253v54Ev");}
void  S10179C25 ::v55(){vfunc_called(this, "_ZN9S10179C253v55Ev");}
void  S10179C25 ::v56(){vfunc_called(this, "_ZN9S10179C253v56Ev");}
void  S10179C25 ::v57(){vfunc_called(this, "_ZN9S10179C253v57Ev");}
void  S10179C25 ::v58(){vfunc_called(this, "_ZN9S10179C253v58Ev");}
void  S10179C25 ::v59(){vfunc_called(this, "_ZN9S10179C253v59Ev");}
void  S10179C25 ::v60(){vfunc_called(this, "_ZN9S10179C253v60Ev");}
void  S10179C25 ::v61(){vfunc_called(this, "_ZN9S10179C253v61Ev");}
void  S10179C25 ::v62(){vfunc_called(this, "_ZN9S10179C253v62Ev");}
void  S10179C25 ::v63(){vfunc_called(this, "_ZN9S10179C253v63Ev");}
S10179C25 ::S10179C25(){ note_ctor("S10179C25", this);} // tgen

static void Test_S10179C25()
{
  extern Class_Descriptor cd_S10179C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2037,3852)];
    init_test(&cd_S10179C25, buf);
    S10179C25 *dp, &lv = *(dp=new (buf) S10179C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16288,15404), "sizeof(S10179C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C25)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C25");
    check_base_class_offset(lv, (S10179C2*), ABISELECT(48,32), "S10179C25");
    check_base_class_offset(lv, (S10179C11*), ABISELECT(56,36), "S10179C25");
    check_base_class_offset(lv, (S10179C26*), ABISELECT(152,100), "S10179C25");
    check_base_class_offset(lv, (S10179C27*), ABISELECT(160,104), "S10179C25");
    check_field_offset(lv, s10179c25f0, ABISELECT(168,108), "S10179C25.s10179c25f0");
    check_field_offset(lv, s10179c25f1, ABISELECT(172,112), "S10179C25.s10179c25f1");
    check_field_offset(lv, s10179c25f2, ABISELECT(180,120), "S10179C25.s10179c25f2");
    check_field_offset(lv, s10179c25f3, ABISELECT(188,128), "S10179C25.s10179c25f3");
    check_field_offset(lv, s10179c25f4, ABISELECT(200,136), "S10179C25.s10179c25f4");
    check_field_offset(lv, s10179c25f5, ABISELECT(352,244), "S10179C25.s10179c25f5");
    check_field_offset(lv, s10179c25f6, ABISELECT(448,308), "S10179C25.s10179c25f6");
    check_field_offset(lv, s10179c25f7, ABISELECT(568,376), "S10179C25.s10179c25f7");
    check_field_offset(lv, s10179c25f8, ABISELECT(792,540), "S10179C25.s10179c25f8");
    check_field_offset(lv, s10179c25f9, ABISELECT(800,544), "S10179C25.s10179c25f9");
    check_field_offset(lv, s10179c25f10, ABISELECT(808,548), "S10179C25.s10179c25f10");
    check_field_offset(lv, s10179c25f11, ABISELECT(15232,14656), "S10179C25.s10179c25f11");
    check_field_offset(lv, s10179c25f12, ABISELECT(15248,14668), "S10179C25.s10179c25f12");
    check_field_offset(lv, s10179c25f13, ABISELECT(15264,14680), "S10179C25.s10179c25f13");
    check_field_offset(lv, s10179c25f14, ABISELECT(15288,14700), "S10179C25.s10179c25f14");
    check_field_offset(lv, s10179c25f15, ABISELECT(15304,14712), "S10179C25.s10179c25f15");
    check_field_offset(lv, s10179c25f16, ABISELECT(15536,14876), "S10179C25.s10179c25f16");
    check_field_offset(lv, s10179c25f17, ABISELECT(15544,14884), "S10179C25.s10179c25f17");
    check_field_offset(lv, s10179c25f18, ABISELECT(15776,15048), "S10179C25.s10179c25f18");
    check_field_offset(lv, s10179c25f19, ABISELECT(16008,15212), "S10179C25.s10179c25f19");
    check_field_offset(lv, s10179c25f20, ABISELECT(16240,15376), "S10179C25.s10179c25f20");
    check_field_offset(lv, s10179c25f21, ABISELECT(16280,15400), "S10179C25.s10179c25f21");
    test_class_info(&lv, &cd_S10179C25);
    dp->~S10179C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C25(Test_S10179C25, "S10179C25", ABISELECT(16288,15404));

#else // __cplusplus

extern void _ZN9S10179C25C1Ev();
extern void _ZN9S10179C25D1Ev();
Name_Map name_map_S10179C25[] = {
  NSPAIR(_ZN9S10179C25C1Ev),
  NSPAIR(_ZN9S10179C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
extern Class_Descriptor cd_S10179C11;
extern VTBL_ENTRY _ZTI9S10179C11[];
extern  VTBL_ENTRY _ZTV9S10179C11[];
extern Class_Descriptor cd_S10179C26;
extern VTBL_ENTRY _ZTI9S10179C26[];
extern  VTBL_ENTRY _ZTV9S10179C26[];
extern Class_Descriptor cd_S10179C27;
extern VTBL_ENTRY _ZTI9S10179C27[];
extern  VTBL_ENTRY _ZTV9S10179C27[];
static Base_Class bases_S10179C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C2,    ABISELECT(48,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C11,    ABISELECT(56,36), //bcp->offset
    31, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C26,    ABISELECT(152,100), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C27,    ABISELECT(160,104), //bcp->offset
    64, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C25[];
extern void _ZN9S10179C25D1Ev();
extern void _ZN9S10179C25D0Ev();
extern void _ZN9S10179C253v42Ev();
extern void _ZN9S10179C253v43Ev();
extern void _ZN9S10179C253v44Ev();
extern void _ZN9S10179C253v45Ev();
extern void _ZN9S10179C253v46Ev();
extern void _ZN9S10179C253v47Ev();
extern void _ZN9S10179C253v48Ev();
extern void _ZN9S10179C253v49Ev();
extern void _ZN9S10179C253v50Ev();
extern void _ZN9S10179C253v51Ev();
extern void _ZN9S10179C253v52Ev();
extern void _ZN9S10179C253v53Ev();
extern void _ZN9S10179C253v54Ev();
extern void _ZN9S10179C253v55Ev();
extern void _ZN9S10179C253v56Ev();
extern void _ZN9S10179C253v57Ev();
extern void _ZN9S10179C253v58Ev();
extern void _ZN9S10179C253v59Ev();
extern void _ZN9S10179C253v60Ev();
extern void _ZN9S10179C253v61Ev();
extern void _ZN9S10179C253v62Ev();
extern void _ZN9S10179C253v63Ev();
extern void ABISELECT(_ZThn48_N9S10179C25D1Ev,_ZThn32_N9S10179C25D1Ev)();
extern void ABISELECT(_ZThn48_N9S10179C25D0Ev,_ZThn32_N9S10179C25D0Ev)();
extern void _ZN8S10179C22v7Ev();
extern void ABISELECT(_ZThn56_N9S10179C25D1Ev,_ZThn36_N9S10179C25D1Ev)();
extern void ABISELECT(_ZThn56_N9S10179C25D0Ev,_ZThn36_N9S10179C25D0Ev)();
extern void _ZN9S10179C113v15Ev();
extern void _ZN9S10179C113v16Ev();
extern void _ZN9S10179C113v17Ev();
extern void _ZN9S10179C113v18Ev();
extern void _ZN9S10179C113v19Ev();
extern void _ZN9S10179C113v20Ev();
extern void _ZN9S10179C113v21Ev();
extern void _ZN9S10179C113v22Ev();
extern void _ZN9S10179C113v23Ev();
extern void _ZN9S10179C113v24Ev();
extern void _ZN9S10179C113v25Ev();
extern void _ZN9S10179C113v26Ev();
extern void _ZN9S10179C113v27Ev();
extern void _ZN9S10179C113v28Ev();
extern void _ZN9S10179C113v29Ev();
extern void _ZN9S10179C113v30Ev();
extern void _ZN9S10179C113v31Ev();
extern void _ZN9S10179C113v32Ev();
extern void _ZN9S10179C113v33Ev();
extern void _ZN9S10179C113v34Ev();
extern void _ZN9S10179C113v35Ev();
extern void _ZN9S10179C113v36Ev();
extern void _ZN9S10179C113v37Ev();
extern void _ZN9S10179C113v38Ev();
extern void ABISELECT(_ZThn152_N9S10179C25D1Ev,_ZThn100_N9S10179C25D1Ev)();
extern void ABISELECT(_ZThn152_N9S10179C25D0Ev,_ZThn100_N9S10179C25D0Ev)();
extern void _ZN9S10179C263v64Ev();
extern void ABISELECT(_ZThn160_N9S10179C25D1Ev,_ZThn104_N9S10179C25D1Ev)();
extern void ABISELECT(_ZThn160_N9S10179C25D0Ev,_ZThn104_N9S10179C25D0Ev)();
extern void _ZN9S10179C273v65Ev();
extern void _ZN9S10179C273v66Ev();
static  VTBL_ENTRY vtc_S10179C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C25[0]),
  (VTBL_ENTRY)&_ZN9S10179C25D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C25D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v42Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v43Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v44Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v45Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v46Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v47Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v48Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v49Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v50Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v51Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v52Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v53Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v54Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v55Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v56Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v57Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v58Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v59Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v60Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v61Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v62Ev,
  (VTBL_ENTRY)&_ZN9S10179C253v63Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10179C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C25D1Ev,_ZThn32_N9S10179C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C25D0Ev,_ZThn32_N9S10179C25D0Ev),
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S10179C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10179C25D1Ev,_ZThn36_N9S10179C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10179C25D0Ev,_ZThn36_N9S10179C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v38Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S10179C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10179C25D1Ev,_ZThn100_N9S10179C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10179C25D0Ev,_ZThn100_N9S10179C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C263v64Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S10179C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10179C25D1Ev,_ZThn104_N9S10179C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10179C25D0Ev,_ZThn104_N9S10179C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C273v65Ev,
  (VTBL_ENTRY)&_ZN9S10179C273v66Ev,
};
extern VTBL_ENTRY _ZTI9S10179C25[];
extern  VTBL_ENTRY _ZTV9S10179C25[];
Class_Descriptor cd_S10179C25 = {  "S10179C25", // class name
  bases_S10179C25, 5,
  &(vtc_S10179C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16288,15404), // object size
  NSPAIRA(_ZTI9S10179C25),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S10179C25),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C81  {
  virtual  ~S10179C81(); // _ZN9S10179C81D1Ev
  virtual void  v99(); // _ZN9S10179C813v99Ev
  virtual void  v100(); // _ZN9S10179C814v100Ev
  virtual void  v101(); // _ZN9S10179C814v101Ev
  virtual void  v102(); // _ZN9S10179C814v102Ev
  virtual void  v103(); // _ZN9S10179C814v103Ev
  virtual void  v104(); // _ZN9S10179C814v104Ev
  virtual void  v105(); // _ZN9S10179C814v105Ev
  virtual void  v106(); // _ZN9S10179C814v106Ev
  virtual void  v107(); // _ZN9S10179C814v107Ev
  virtual void  v108(); // _ZN9S10179C814v108Ev
  virtual void  v109(); // _ZN9S10179C814v109Ev
  virtual void  v110(); // _ZN9S10179C814v110Ev
  virtual void  v111(); // _ZN9S10179C814v111Ev
  virtual void  v112(); // _ZN9S10179C814v112Ev
  virtual void  v113(); // _ZN9S10179C814v113Ev
  S10179C81(); // tgen
};
//SIG(-1 S10179C81) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S10179C81 ::~S10179C81(){ note_dtor("S10179C81", this);}
void  S10179C81 ::v99(){vfunc_called(this, "_ZN9S10179C813v99Ev");}
void  S10179C81 ::v100(){vfunc_called(this, "_ZN9S10179C814v100Ev");}
void  S10179C81 ::v101(){vfunc_called(this, "_ZN9S10179C814v101Ev");}
void  S10179C81 ::v102(){vfunc_called(this, "_ZN9S10179C814v102Ev");}
void  S10179C81 ::v103(){vfunc_called(this, "_ZN9S10179C814v103Ev");}
void  S10179C81 ::v104(){vfunc_called(this, "_ZN9S10179C814v104Ev");}
void  S10179C81 ::v105(){vfunc_called(this, "_ZN9S10179C814v105Ev");}
void  S10179C81 ::v106(){vfunc_called(this, "_ZN9S10179C814v106Ev");}
void  S10179C81 ::v107(){vfunc_called(this, "_ZN9S10179C814v107Ev");}
void  S10179C81 ::v108(){vfunc_called(this, "_ZN9S10179C814v108Ev");}
void  S10179C81 ::v109(){vfunc_called(this, "_ZN9S10179C814v109Ev");}
void  S10179C81 ::v110(){vfunc_called(this, "_ZN9S10179C814v110Ev");}
void  S10179C81 ::v111(){vfunc_called(this, "_ZN9S10179C814v111Ev");}
void  S10179C81 ::v112(){vfunc_called(this, "_ZN9S10179C814v112Ev");}
void  S10179C81 ::v113(){vfunc_called(this, "_ZN9S10179C814v113Ev");}
S10179C81 ::S10179C81(){ note_ctor("S10179C81", this);} // tgen

static void Test_S10179C81()
{
  extern Class_Descriptor cd_S10179C81;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10179C81, buf);
    S10179C81 *dp, &lv = *(dp=new (buf) S10179C81());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C81)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C81)");
    test_class_info(&lv, &cd_S10179C81);
    dp->~S10179C81();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C81(Test_S10179C81, "S10179C81", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10179C81C1Ev();
extern void _ZN9S10179C81D1Ev();
Name_Map name_map_S10179C81[] = {
  NSPAIR(_ZN9S10179C81C1Ev),
  NSPAIR(_ZN9S10179C81D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C81[];
extern void _ZN9S10179C81D1Ev();
extern void _ZN9S10179C81D0Ev();
extern void _ZN9S10179C813v99Ev();
extern void _ZN9S10179C814v100Ev();
extern void _ZN9S10179C814v101Ev();
extern void _ZN9S10179C814v102Ev();
extern void _ZN9S10179C814v103Ev();
extern void _ZN9S10179C814v104Ev();
extern void _ZN9S10179C814v105Ev();
extern void _ZN9S10179C814v106Ev();
extern void _ZN9S10179C814v107Ev();
extern void _ZN9S10179C814v108Ev();
extern void _ZN9S10179C814v109Ev();
extern void _ZN9S10179C814v110Ev();
extern void _ZN9S10179C814v111Ev();
extern void _ZN9S10179C814v112Ev();
extern void _ZN9S10179C814v113Ev();
static  VTBL_ENTRY vtc_S10179C81[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C81[0]),
  (VTBL_ENTRY)&_ZN9S10179C81D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C81D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v113Ev,
};
extern VTBL_ENTRY _ZTI9S10179C81[];
extern  VTBL_ENTRY _ZTV9S10179C81[];
Class_Descriptor cd_S10179C81 = {  "S10179C81", // class name
  0,0,//no base classes
  &(vtc_S10179C81[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10179C81),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C81),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C80  : S10179C81 , S10180C82 {
  ~S10179C80(); // tgen
  S10179C80(); // tgen
};
//SIG(-1 S10179C80) C1{ BC2{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15} BC3{ vd m Fp}}


S10179C80 ::~S10179C80(){ note_dtor("S10179C80", this);} // tgen
S10179C80 ::S10179C80(){ note_ctor("S10179C80", this);} // tgen

static void Test_S10179C80()
{
  extern Class_Descriptor cd_S10179C80;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S10179C80, buf);
    S10179C80 *dp, &lv = *(dp=new (buf) S10179C80());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S10179C80)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C80)");
    check_base_class_offset(lv, (S10179C81*), 0, "S10179C80");
    check_base_class_offset(lv, (S10180C82*), ABISELECT(8,4), "S10179C80");
    test_class_info(&lv, &cd_S10179C80);
    dp->~S10179C80();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C80(Test_S10179C80, "S10179C80", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S10179C80C1Ev();
extern void _ZN9S10179C80D1Ev();
Name_Map name_map_S10179C80[] = {
  NSPAIR(_ZN9S10179C80C1Ev),
  NSPAIR(_ZN9S10179C80D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10179C81;
extern VTBL_ENTRY _ZTI9S10179C81[];
extern  VTBL_ENTRY _ZTV9S10179C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
static Base_Class bases_S10179C80[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10179C81,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C82,    ABISELECT(8,4), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C80[];
extern void _ZN9S10179C80D1Ev();
extern void _ZN9S10179C80D0Ev();
extern void _ZN9S10179C813v99Ev();
extern void _ZN9S10179C814v100Ev();
extern void _ZN9S10179C814v101Ev();
extern void _ZN9S10179C814v102Ev();
extern void _ZN9S10179C814v103Ev();
extern void _ZN9S10179C814v104Ev();
extern void _ZN9S10179C814v105Ev();
extern void _ZN9S10179C814v106Ev();
extern void _ZN9S10179C814v107Ev();
extern void _ZN9S10179C814v108Ev();
extern void _ZN9S10179C814v109Ev();
extern void _ZN9S10179C814v110Ev();
extern void _ZN9S10179C814v111Ev();
extern void _ZN9S10179C814v112Ev();
extern void _ZN9S10179C814v113Ev();
extern void ABISELECT(_ZThn8_N9S10179C80D1Ev,_ZThn4_N9S10179C80D1Ev)();
extern void ABISELECT(_ZThn8_N9S10179C80D0Ev,_ZThn4_N9S10179C80D0Ev)();
static  VTBL_ENTRY vtc_S10179C80[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C80[0]),
  (VTBL_ENTRY)&_ZN9S10179C80D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C80D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v113Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10179C80[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10179C80D1Ev,_ZThn4_N9S10179C80D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10179C80D0Ev,_ZThn4_N9S10179C80D0Ev),
};
extern VTBL_ENTRY _ZTI9S10179C80[];
extern  VTBL_ENTRY _ZTV9S10179C80[];
Class_Descriptor cd_S10179C80 = {  "S10179C80", // class name
  bases_S10179C80, 2,
  &(vtc_S10179C80[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S10179C80),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10179C80),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C83  {
  virtual  ~S10179C83(); // _ZN9S10179C83D1Ev
  virtual void  v114(); // _ZN9S10179C834v114Ev
  virtual void  v115(); // _ZN9S10179C834v115Ev
  S10179C83(); // tgen
};
//SIG(-1 S10179C83) C1{ vd v1 v2}


 S10179C83 ::~S10179C83(){ note_dtor("S10179C83", this);}
void  S10179C83 ::v114(){vfunc_called(this, "_ZN9S10179C834v114Ev");}
void  S10179C83 ::v115(){vfunc_called(this, "_ZN9S10179C834v115Ev");}
S10179C83 ::S10179C83(){ note_ctor("S10179C83", this);} // tgen

static void Test_S10179C83()
{
  extern Class_Descriptor cd_S10179C83;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10179C83, buf);
    S10179C83 *dp, &lv = *(dp=new (buf) S10179C83());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C83)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C83)");
    test_class_info(&lv, &cd_S10179C83);
    dp->~S10179C83();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C83(Test_S10179C83, "S10179C83", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10179C83C1Ev();
extern void _ZN9S10179C83D1Ev();
Name_Map name_map_S10179C83[] = {
  NSPAIR(_ZN9S10179C83C1Ev),
  NSPAIR(_ZN9S10179C83D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10179C83[];
extern void _ZN9S10179C83D1Ev();
extern void _ZN9S10179C83D0Ev();
extern void _ZN9S10179C834v114Ev();
extern void _ZN9S10179C834v115Ev();
static  VTBL_ENTRY vtc_S10179C83[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C83[0]),
  (VTBL_ENTRY)&_ZN9S10179C83D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C83D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C834v114Ev,
  (VTBL_ENTRY)&_ZN9S10179C834v115Ev,
};
extern VTBL_ENTRY _ZTI9S10179C83[];
extern  VTBL_ENTRY _ZTV9S10179C83[];
Class_Descriptor cd_S10179C83 = {  "S10179C83", // class name
  0,0,//no base classes
  &(vtc_S10179C83[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10179C83),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10179C83),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C69  : S10180C17 {
  ::S10180C70 s10179c69f0;
  void *s10179c69f1;
  char s10179c69f2;
  int s10179c69f3;
  virtual  ~S10179C69(); // _ZN9S10179C69D1Ev
  virtual void  v89(); // _ZN9S10179C693v89Ev
  virtual void  v90(); // _ZN9S10179C693v90Ev
  virtual void  v91(); // _ZN9S10179C693v91Ev
  virtual void  v92(); // _ZN9S10179C693v92Ev
  S10179C69(); // tgen
};
//SIG(-1 S10179C69) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC8 FC8 Fi[3] FC9{ m FC10{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi}


 S10179C69 ::~S10179C69(){ note_dtor("S10179C69", this);}
void  S10179C69 ::v89(){vfunc_called(this, "_ZN9S10179C693v89Ev");}
void  S10179C69 ::v90(){vfunc_called(this, "_ZN9S10179C693v90Ev");}
void  S10179C69 ::v91(){vfunc_called(this, "_ZN9S10179C693v91Ev");}
void  S10179C69 ::v92(){vfunc_called(this, "_ZN9S10179C693v92Ev");}
S10179C69 ::S10179C69(){ note_ctor("S10179C69", this);} // tgen

static void Test_S10179C69()
{
  extern Class_Descriptor cd_S10179C69;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10179C69, buf);
    S10179C69 *dp, &lv = *(dp=new (buf) S10179C69());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10179C69)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C69)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C69");
    check_field_offset(lv, s10179c69f0, ABISELECT(48,32), "S10179C69.s10179c69f0");
    check_field_offset(lv, s10179c69f1, ABISELECT(216,152), "S10179C69.s10179c69f1");
    check_field_offset(lv, s10179c69f2, ABISELECT(224,156), "S10179C69.s10179c69f2");
    check_field_offset(lv, s10179c69f3, ABISELECT(228,160), "S10179C69.s10179c69f3");
    test_class_info(&lv, &cd_S10179C69);
    dp->~S10179C69();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C69(Test_S10179C69, "S10179C69", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10179C69C1Ev();
extern void _ZN9S10179C69D1Ev();
Name_Map name_map_S10179C69[] = {
  NSPAIR(_ZN9S10179C69C1Ev),
  NSPAIR(_ZN9S10179C69D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10179C69[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C69[];
extern void _ZN9S10179C69D1Ev();
extern void _ZN9S10179C69D0Ev();
extern void _ZN9S10179C693v89Ev();
extern void _ZN9S10179C693v90Ev();
extern void _ZN9S10179C693v91Ev();
extern void _ZN9S10179C693v92Ev();
static  VTBL_ENTRY vtc_S10179C69[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C69[0]),
  (VTBL_ENTRY)&_ZN9S10179C69D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C69D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v92Ev,
};
extern VTBL_ENTRY _ZTI9S10179C69[];
extern  VTBL_ENTRY _ZTV9S10179C69[];
Class_Descriptor cd_S10179C69 = {  "S10179C69", // class name
  bases_S10179C69, 1,
  &(vtc_S10179C69[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10179C69),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10179C69),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C87  : S10179C69 {
  virtual void  v151(); // _ZN9S10179C874v151Ev
  virtual void  v152(); // _ZN9S10179C874v152Ev
  ~S10179C87(); // tgen
  S10179C87(); // tgen
};
//SIG(-1 S10179C87) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v3 v4 v5 v6 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1 v2}


void  S10179C87 ::v151(){vfunc_called(this, "_ZN9S10179C874v151Ev");}
void  S10179C87 ::v152(){vfunc_called(this, "_ZN9S10179C874v152Ev");}
S10179C87 ::~S10179C87(){ note_dtor("S10179C87", this);} // tgen
S10179C87 ::S10179C87(){ note_ctor("S10179C87", this);} // tgen

static void Test_S10179C87()
{
  extern Class_Descriptor cd_S10179C87;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10179C87, buf);
    S10179C87 *dp, &lv = *(dp=new (buf) S10179C87());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10179C87)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C87)");
    check_base_class_offset(lv, (S10180C17*)(S10179C69*), 0, "S10179C87");
    check_base_class_offset(lv, (S10179C69*), 0, "S10179C87");
    test_class_info(&lv, &cd_S10179C87);
    dp->~S10179C87();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C87(Test_S10179C87, "S10179C87", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10179C87C1Ev();
extern void _ZN9S10179C87D1Ev();
Name_Map name_map_S10179C87[] = {
  NSPAIR(_ZN9S10179C87C1Ev),
  NSPAIR(_ZN9S10179C87D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C69;
extern VTBL_ENTRY _ZTI9S10179C69[];
extern  VTBL_ENTRY _ZTV9S10179C69[];
static Base_Class bases_S10179C87[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10179C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C87[];
extern void _ZN9S10179C87D1Ev();
extern void _ZN9S10179C87D0Ev();
extern void _ZN9S10179C693v89Ev();
extern void _ZN9S10179C693v90Ev();
extern void _ZN9S10179C693v91Ev();
extern void _ZN9S10179C693v92Ev();
extern void _ZN9S10179C874v151Ev();
extern void _ZN9S10179C874v152Ev();
static  VTBL_ENTRY vtc_S10179C87[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C87[0]),
  (VTBL_ENTRY)&_ZN9S10179C87D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C87D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v92Ev,
  (VTBL_ENTRY)&_ZN9S10179C874v151Ev,
  (VTBL_ENTRY)&_ZN9S10179C874v152Ev,
};
extern VTBL_ENTRY _ZTI9S10179C87[];
extern  VTBL_ENTRY _ZTV9S10179C87[];
Class_Descriptor cd_S10179C87 = {  "S10179C87", // class name
  bases_S10179C87, 2,
  &(vtc_S10179C87[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10179C87),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10179C87),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C93  {
  long s10179c93f0;
  void  mf10179c93(); // _ZN9S10179C9310mf10179c93Ev
};
//SIG(-1 S10179C93) C1{ m Fl}


void  S10179C93 ::mf10179c93(){}

static void Test_S10179C93()
{
  {
    init_simple_test("S10179C93");
    S10179C93 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C93)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C93)");
    check_field_offset(lv, s10179c93f0, 0, "S10179C93.s10179c93f0");
  }
}
static Arrange_To_Call_Me vS10179C93(Test_S10179C93, "S10179C93", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C91  : S10180C17 , S10179C11 {
  ::S10180C92 s10179c91f0;
  int s10179c91f1[2];
  char s10179c91f2[2];
  int s10179c91f3;
  __tsi64 s10179c91f4[2];
  ::S10179C93 s10179c91f5;
  int s10179c91f6;
  virtual  ~S10179C91(); // _ZN9S10179C91D1Ev
  virtual void  v156(); // _ZN9S10179C914v156Ev
  virtual void  v157(); // _ZN9S10179C914v157Ev
  virtual void  v158(); // _ZN9S10179C914v158Ev
  virtual void  v159(); // _ZN9S10179C914v159Ev
  virtual void  v160(); // _ZN9S10179C914v160Ev
  virtual void  v161(); // _ZN9S10179C914v161Ev
  virtual void  v162(); // _ZN9S10179C914v162Ev
  virtual void  v163(); // _ZN9S10179C914v163Ev
  S10179C91(); // tgen
};
//SIG(-1 S10179C91) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 FC10{ m FC8 Fi[2] FC8} Fi[2] Fc[2] Fi FL[2] FC11{ m Fl} Fi}


 S10179C91 ::~S10179C91(){ note_dtor("S10179C91", this);}
void  S10179C91 ::v156(){vfunc_called(this, "_ZN9S10179C914v156Ev");}
void  S10179C91 ::v157(){vfunc_called(this, "_ZN9S10179C914v157Ev");}
void  S10179C91 ::v158(){vfunc_called(this, "_ZN9S10179C914v158Ev");}
void  S10179C91 ::v159(){vfunc_called(this, "_ZN9S10179C914v159Ev");}
void  S10179C91 ::v160(){vfunc_called(this, "_ZN9S10179C914v160Ev");}
void  S10179C91 ::v161(){vfunc_called(this, "_ZN9S10179C914v161Ev");}
void  S10179C91 ::v162(){vfunc_called(this, "_ZN9S10179C914v162Ev");}
void  S10179C91 ::v163(){vfunc_called(this, "_ZN9S10179C914v163Ev");}
S10179C91 ::S10179C91(){ note_ctor("S10179C91", this);} // tgen

static void Test_S10179C91()
{
  extern Class_Descriptor cd_S10179C91;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,43)];
    init_test(&cd_S10179C91, buf);
    S10179C91 *dp, &lv = *(dp=new (buf) S10179C91());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,168), "sizeof(S10179C91)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C91)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C91");
    check_base_class_offset(lv, (S10179C11*), ABISELECT(48,32), "S10179C91");
    check_field_offset(lv, s10179c91f0, ABISELECT(144,96), "S10179C91.s10179c91f0");
    check_field_offset(lv, s10179c91f1, ABISELECT(184,128), "S10179C91.s10179c91f1");
    check_field_offset(lv, s10179c91f2, ABISELECT(192,136), "S10179C91.s10179c91f2");
    check_field_offset(lv, s10179c91f3, ABISELECT(196,140), "S10179C91.s10179c91f3");
    check_field_offset(lv, s10179c91f4, ABISELECT(200,144), "S10179C91.s10179c91f4");
    check_field_offset(lv, s10179c91f5, ABISELECT(216,160), "S10179C91.s10179c91f5");
    check_field_offset(lv, s10179c91f6, ABISELECT(224,164), "S10179C91.s10179c91f6");
    test_class_info(&lv, &cd_S10179C91);
    dp->~S10179C91();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C91(Test_S10179C91, "S10179C91", ABISELECT(232,168));

#else // __cplusplus

extern void _ZN9S10179C91C1Ev();
extern void _ZN9S10179C91D1Ev();
Name_Map name_map_S10179C91[] = {
  NSPAIR(_ZN9S10179C91C1Ev),
  NSPAIR(_ZN9S10179C91D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C11;
extern VTBL_ENTRY _ZTI9S10179C11[];
extern  VTBL_ENTRY _ZTV9S10179C11[];
static Base_Class bases_S10179C91[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C11,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C91[];
extern void _ZN9S10179C91D1Ev();
extern void _ZN9S10179C91D0Ev();
extern void _ZN9S10179C914v156Ev();
extern void _ZN9S10179C914v157Ev();
extern void _ZN9S10179C914v158Ev();
extern void _ZN9S10179C914v159Ev();
extern void _ZN9S10179C914v160Ev();
extern void _ZN9S10179C914v161Ev();
extern void _ZN9S10179C914v162Ev();
extern void _ZN9S10179C914v163Ev();
extern void ABISELECT(_ZThn48_N9S10179C91D1Ev,_ZThn32_N9S10179C91D1Ev)();
extern void ABISELECT(_ZThn48_N9S10179C91D0Ev,_ZThn32_N9S10179C91D0Ev)();
extern void _ZN9S10179C113v15Ev();
extern void _ZN9S10179C113v16Ev();
extern void _ZN9S10179C113v17Ev();
extern void _ZN9S10179C113v18Ev();
extern void _ZN9S10179C113v19Ev();
extern void _ZN9S10179C113v20Ev();
extern void _ZN9S10179C113v21Ev();
extern void _ZN9S10179C113v22Ev();
extern void _ZN9S10179C113v23Ev();
extern void _ZN9S10179C113v24Ev();
extern void _ZN9S10179C113v25Ev();
extern void _ZN9S10179C113v26Ev();
extern void _ZN9S10179C113v27Ev();
extern void _ZN9S10179C113v28Ev();
extern void _ZN9S10179C113v29Ev();
extern void _ZN9S10179C113v30Ev();
extern void _ZN9S10179C113v31Ev();
extern void _ZN9S10179C113v32Ev();
extern void _ZN9S10179C113v33Ev();
extern void _ZN9S10179C113v34Ev();
extern void _ZN9S10179C113v35Ev();
extern void _ZN9S10179C113v36Ev();
extern void _ZN9S10179C113v37Ev();
extern void _ZN9S10179C113v38Ev();
static  VTBL_ENTRY vtc_S10179C91[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C91[0]),
  (VTBL_ENTRY)&_ZN9S10179C91D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C91D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v156Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v157Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v158Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v159Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v160Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v161Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v162Ev,
  (VTBL_ENTRY)&_ZN9S10179C914v163Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10179C91[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C91D1Ev,_ZThn32_N9S10179C91D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C91D0Ev,_ZThn32_N9S10179C91D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v38Ev,
};
extern VTBL_ENTRY _ZTI9S10179C91[];
extern  VTBL_ENTRY _ZTV9S10179C91[];
Class_Descriptor cd_S10179C91 = {  "S10179C91", // class name
  bases_S10179C91, 2,
  &(vtc_S10179C91[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,168), // object size
  NSPAIRA(_ZTI9S10179C91),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10179C91),40, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C79  : S10180C17 , S10179C11 , S10179C2 , S10179C80 , S10179C83 , S10179C26 {
  void *s10179c79f0[5];
  int s10179c79f1;
  void *s10179c79f2;
  ::S10180C59 s10179c79f3;
  ::S10180C111 s10179c79f4;
  ::S10180C75 s10179c79f5;
  ::S10180C87 s10179c79f6;
  ::S10180C86 s10179c79f7;
  ::S10179C87 s10179c79f8;
  ::S10180C88 s10179c79f9;
  ::S10179C91 s10179c79f10;
  ::S10180C94 s10179c79f11;
  ::S10180C99 s10179c79f12;
  ::S10180C100 s10179c79f13;
  ::S10180C103 s10179c79f14;
  void *s10179c79f15;
  ::S10180C31 s10179c79f16;
  char s10179c79f17[2];
  int s10179c79f18;
  ::S10180C120 s10179c79f19;
  ::S10180C121 s10179c79f20;
  ::S10180C73 s10179c79f21;
  ::S10180C73 s10179c79f22;
  ::S10180C73 s10179c79f23;
  void *s10179c79f24;
  ::S10180C122 s10179c79f25;
  char s10179c79f26[2];
  __tsi64 s10179c79f27;
  char s10179c79f28[2];
  int s10179c79f29;
  ::S10180C61 s10179c79f30;
  ::S10180C124 s10179c79f31;
  char s10179c79f32;
  int s10179c79f33;
  virtual  ~S10179C79(); // _ZN9S10179C79D1Ev
  virtual void  v116(); // _ZN9S10179C794v116Ev
  virtual void  v117(); // _ZN9S10179C794v117Ev
  virtual void  v118(); // _ZN9S10179C794v118Ev
  virtual void  v119(); // _ZN9S10179C794v119Ev
  virtual void  v120(); // _ZN9S10179C794v120Ev
  virtual void  v121(); // _ZN9S10179C794v121Ev
  virtual void  v122(); // _ZN9S10179C794v122Ev
  virtual void  v123(); // _ZN9S10179C794v123Ev
  virtual void  v124(); // _ZN9S10179C794v124Ev
  virtual void  v125(); // _ZN9S10179C794v125Ev
  virtual void  v126(); // _ZN9S10179C794v126Ev
  virtual void  v127(); // _ZN9S10179C794v127Ev
  virtual void  v128(); // _ZN9S10179C794v128Ev
  virtual void  v129(); // _ZN9S10179C794v129Ev
  virtual void  v130(); // _ZN9S10179C794v130Ev
  virtual void  v131(); // _ZN9S10179C794v131Ev
  virtual void  v132(); // _ZN9S10179C794v132Ev
  virtual void  v133(); // _ZN9S10179C794v133Ev
  virtual void  v134(); // _ZN9S10179C794v134Ev
  virtual void  v135(); // _ZN9S10179C794v135Ev
  virtual void  v136(); // _ZN9S10179C794v136Ev
  virtual void  v137(); // _ZN9S10179C794v137Ev
  virtual void  v138(); // _ZN9S10179C794v138Ev
  virtual void  v139(); // _ZN9S10179C794v139Ev
  virtual void  v140(); // _ZN9S10179C794v140Ev
  virtual void  v141(); // _ZN9S10179C794v141Ev
  virtual void  v142(); // _ZN9S10179C794v142Ev
  virtual void  v143(); // _ZN9S10179C794v143Ev
  virtual void  v144(); // _ZN9S10179C794v144Ev
  virtual void  v145(); // _ZN9S10179C794v145Ev
  virtual void  v146(); // _ZN9S10179C794v146Ev
  virtual void  v147(); // _ZN9S10179C794v147Ev
  virtual void  v148(); // _ZN9S10179C794v148Ev
  virtual void  v149(); // _ZN9S10179C794v149Ev
  S10179C79(); // tgen
};
//SIG(-1 S10179C79) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v59} BC11{ BC12{ vd v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74} BC13{ vd m Fp}} BC14{ vd v75 v76} BC15{ vd v77} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp[5] Fi Fp FC16{ m Fi[2]} FC17{ m Fp} FC18{ BC19{ BC2 vd v79 v80 v81 v82 FC20{ m Fp FC7 FC8 FC8 Fi[3] FC21{ m FC22{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v78} FC23{ BC19 v83 v84} FC24{ BC19 v85} FC25{ BC26{ BC2 vd v88 v89 v90 v91 FC20 Fp Fc Fi} v86 v87} FC27{ BC19 v92 v93 v94 FC28{ Fp[3]} FC29{ Fi[4]}[3]} FC30{ BC2 BC6 vd v95 v96 v97 v98 v99 v100 v101 v102 FC31{ m FC8 Fi[2] FC8} Fi[2] Fc[2] Fi FL[2] FC32{ m Fl} Fi} FC33{ BC34{ BC2 BC35{ vd v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp FC7 FC9} vd v132 v133 v134 v135 v136 v137} BC36{ vd v138} vd v103 v104 v105 v106 v107 FC37{ m Fi Fp Fi FC21} FC38{ m Fp Fi[2] FC5}} FC39{ BC2 BC35 vd v139 v140 v141 v142 FC40{ m FC38 Fp[2]} Fp[2] FC8 Fi} FC41{ BC2 BC35 BC36 BC42{ BC43{ vd v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176} BC13} BC44{ vd v177 v178} BC45{ vd v179} vd v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 FC40 Fp[2] Fi[2] FC46{ BC2 vd v180 Fp FC7 FC7 Fp Fi FC21} FC47{ BC19 v181 v182} FC23 FC23 FC21 FC21 FC21 Fi} FC48{ BC49{ BC2 BC35 BC36 vd v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 Fi[2] FC24 FC40 FC50{ BC19 v212 v213 v214 Fp[3]} FC51{ BC19 v215} FC23 FC47 FC52{ BC2 vd v216 v217 FC53{ BC54{ BC55{ m Fp FC21 FC21 Fi[3] Fc[2] Fi Fp} FC56{ m Fp} FC17 FC56 FC8 FC8 FC56 FC17 FC56 FC8 FC8 FC8 Fc Fi Fp} FC8} Fi} FC18 FC57{ BC51 v218} FC18 Fp FC17 Fp[2] Fi Fc[3] Fi FL[2]} vd v183 v184 v185 v186 v187 v188 FC58{ m Fp} FC59{ m Fp FC17 Fp[5] FC60{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC61{ m FC62{ m Fi[2]} FC62} FC62 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC40 Fc[2] Fi FC63{ m Fc[5]} FC64{ m FC21 FC21 FC21 FC56 Fi Fc[2] Fi} FC21 FC21 FC21 Fp FC65{ BC2 vd FC66{ m Fp[3] FC16 FC8 FL[2] Fc} FC40} Fc[2] FL Fc[2] Fi FC56 FC67{ m FC68{ BC69{ m Fp Fi FC70{ m} FC70}} Fi} Fc Fi}


 S10179C79 ::~S10179C79(){ note_dtor("S10179C79", this);}
void  S10179C79 ::v116(){vfunc_called(this, "_ZN9S10179C794v116Ev");}
void  S10179C79 ::v117(){vfunc_called(this, "_ZN9S10179C794v117Ev");}
void  S10179C79 ::v118(){vfunc_called(this, "_ZN9S10179C794v118Ev");}
void  S10179C79 ::v119(){vfunc_called(this, "_ZN9S10179C794v119Ev");}
void  S10179C79 ::v120(){vfunc_called(this, "_ZN9S10179C794v120Ev");}
void  S10179C79 ::v121(){vfunc_called(this, "_ZN9S10179C794v121Ev");}
void  S10179C79 ::v122(){vfunc_called(this, "_ZN9S10179C794v122Ev");}
void  S10179C79 ::v123(){vfunc_called(this, "_ZN9S10179C794v123Ev");}
void  S10179C79 ::v124(){vfunc_called(this, "_ZN9S10179C794v124Ev");}
void  S10179C79 ::v125(){vfunc_called(this, "_ZN9S10179C794v125Ev");}
void  S10179C79 ::v126(){vfunc_called(this, "_ZN9S10179C794v126Ev");}
void  S10179C79 ::v127(){vfunc_called(this, "_ZN9S10179C794v127Ev");}
void  S10179C79 ::v128(){vfunc_called(this, "_ZN9S10179C794v128Ev");}
void  S10179C79 ::v129(){vfunc_called(this, "_ZN9S10179C794v129Ev");}
void  S10179C79 ::v130(){vfunc_called(this, "_ZN9S10179C794v130Ev");}
void  S10179C79 ::v131(){vfunc_called(this, "_ZN9S10179C794v131Ev");}
void  S10179C79 ::v132(){vfunc_called(this, "_ZN9S10179C794v132Ev");}
void  S10179C79 ::v133(){vfunc_called(this, "_ZN9S10179C794v133Ev");}
void  S10179C79 ::v134(){vfunc_called(this, "_ZN9S10179C794v134Ev");}
void  S10179C79 ::v135(){vfunc_called(this, "_ZN9S10179C794v135Ev");}
void  S10179C79 ::v136(){vfunc_called(this, "_ZN9S10179C794v136Ev");}
void  S10179C79 ::v137(){vfunc_called(this, "_ZN9S10179C794v137Ev");}
void  S10179C79 ::v138(){vfunc_called(this, "_ZN9S10179C794v138Ev");}
void  S10179C79 ::v139(){vfunc_called(this, "_ZN9S10179C794v139Ev");}
void  S10179C79 ::v140(){vfunc_called(this, "_ZN9S10179C794v140Ev");}
void  S10179C79 ::v141(){vfunc_called(this, "_ZN9S10179C794v141Ev");}
void  S10179C79 ::v142(){vfunc_called(this, "_ZN9S10179C794v142Ev");}
void  S10179C79 ::v143(){vfunc_called(this, "_ZN9S10179C794v143Ev");}
void  S10179C79 ::v144(){vfunc_called(this, "_ZN9S10179C794v144Ev");}
void  S10179C79 ::v145(){vfunc_called(this, "_ZN9S10179C794v145Ev");}
void  S10179C79 ::v146(){vfunc_called(this, "_ZN9S10179C794v146Ev");}
void  S10179C79 ::v147(){vfunc_called(this, "_ZN9S10179C794v147Ev");}
void  S10179C79 ::v148(){vfunc_called(this, "_ZN9S10179C794v148Ev");}
void  S10179C79 ::v149(){vfunc_called(this, "_ZN9S10179C794v149Ev");}
S10179C79 ::S10179C79(){ note_ctor("S10179C79", this);} // tgen

static void Test_S10179C79()
{
  extern Class_Descriptor cd_S10179C79;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(806,1125)];
    init_test(&cd_S10179C79, buf);
    S10179C79 *dp, &lv = *(dp=new (buf) S10179C79());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6440,4496), "sizeof(S10179C79)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C79)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C79");
    check_base_class_offset(lv, (S10179C11*), ABISELECT(48,32), "S10179C79");
    check_base_class_offset(lv, (S10179C2*), ABISELECT(144,96), "S10179C79");
    check_base_class_offset(lv, (S10179C81*)(S10179C80*), ABISELECT(152,100), "S10179C79");
    check_base_class_offset(lv, (S10180C82*)(S10179C80*), ABISELECT(160,104), "S10179C79");
    check_base_class_offset(lv, (S10179C80*), ABISELECT(152,100), "S10179C79");
    check_base_class_offset(lv, (S10179C83*), ABISELECT(176,112), "S10179C79");
    check_base_class_offset(lv, (S10179C26*), ABISELECT(184,116), "S10179C79");
    check_field_offset(lv, s10179c79f0, ABISELECT(192,120), "S10179C79.s10179c79f0");
    check_field_offset(lv, s10179c79f1, ABISELECT(232,140), "S10179C79.s10179c79f1");
    check_field_offset(lv, s10179c79f2, ABISELECT(240,144), "S10179C79.s10179c79f2");
    check_field_offset(lv, s10179c79f3, ABISELECT(248,148), "S10179C79.s10179c79f3");
    check_field_offset(lv, s10179c79f4, ABISELECT(256,156), "S10179C79.s10179c79f4");
    check_field_offset(lv, s10179c79f5, ABISELECT(264,160), "S10179C79.s10179c79f5");
    check_field_offset(lv, s10179c79f6, ABISELECT(496,324), "S10179C79.s10179c79f6");
    check_field_offset(lv, s10179c79f7, ABISELECT(728,488), "S10179C79.s10179c79f7");
    check_field_offset(lv, s10179c79f8, ABISELECT(960,652), "S10179C79.s10179c79f8");
    check_field_offset(lv, s10179c79f9, ABISELECT(1192,816), "S10179C79.s10179c79f9");
    check_field_offset(lv, s10179c79f10, ABISELECT(1496,1040), "S10179C79.s10179c79f10");
    check_field_offset(lv, s10179c79f11, ABISELECT(1728,1208), "S10179C79.s10179c79f11");
    check_field_offset(lv, s10179c79f12, ABISELECT(1944,1352), "S10179C79.s10179c79f12");
    check_field_offset(lv, s10179c79f13, ABISELECT(2168,1496), "S10179C79.s10179c79f13");
    check_field_offset(lv, s10179c79f14, ABISELECT(3312,2292), "S10179C79.s10179c79f14");
    check_field_offset(lv, s10179c79f15, ABISELECT(6024,4180), "S10179C79.s10179c79f15");
    check_field_offset(lv, s10179c79f16, ABISELECT(6032,4184), "S10179C79.s10179c79f16");
    check_field_offset(lv, s10179c79f17, ABISELECT(6072,4208), "S10179C79.s10179c79f17");
    check_field_offset(lv, s10179c79f18, ABISELECT(6076,4212), "S10179C79.s10179c79f18");
    check_field_offset(lv, s10179c79f19, ABISELECT(6080,4216), "S10179C79.s10179c79f19");
    check_field_offset(lv, s10179c79f20, ABISELECT(6088,4224), "S10179C79.s10179c79f20");
    check_field_offset(lv, s10179c79f21, ABISELECT(6160,4288), "S10179C79.s10179c79f21");
    check_field_offset(lv, s10179c79f22, ABISELECT(6176,4304), "S10179C79.s10179c79f22");
    check_field_offset(lv, s10179c79f23, ABISELECT(6192,4320), "S10179C79.s10179c79f23");
    check_field_offset(lv, s10179c79f24, ABISELECT(6208,4336), "S10179C79.s10179c79f24");
    check_field_offset(lv, s10179c79f25, ABISELECT(6216,4340), "S10179C79.s10179c79f25");
    check_field_offset(lv, s10179c79f26, ABISELECT(6376,4448), "S10179C79.s10179c79f26");
    check_field_offset(lv, s10179c79f27, ABISELECT(6384,4452), "S10179C79.s10179c79f27");
    check_field_offset(lv, s10179c79f28, ABISELECT(6392,4460), "S10179C79.s10179c79f28");
    check_field_offset(lv, s10179c79f29, ABISELECT(6396,4464), "S10179C79.s10179c79f29");
    check_field_offset(lv, s10179c79f30, ABISELECT(6400,4468), "S10179C79.s10179c79f30");
    check_field_offset(lv, s10179c79f31, ABISELECT(6408,4472), "S10179C79.s10179c79f31");
    check_field_offset(lv, s10179c79f32, ABISELECT(6432,4488), "S10179C79.s10179c79f32");
    check_field_offset(lv, s10179c79f33, ABISELECT(6436,4492), "S10179C79.s10179c79f33");
    test_class_info(&lv, &cd_S10179C79);
    dp->~S10179C79();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C79(Test_S10179C79, "S10179C79", ABISELECT(6440,4496));

#else // __cplusplus

extern void _ZN9S10179C79C1Ev();
extern void _ZN9S10179C79D1Ev();
Name_Map name_map_S10179C79[] = {
  NSPAIR(_ZN9S10179C79C1Ev),
  NSPAIR(_ZN9S10179C79D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C11;
extern VTBL_ENTRY _ZTI9S10179C11[];
extern  VTBL_ENTRY _ZTV9S10179C11[];
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
extern Class_Descriptor cd_S10179C81;
extern VTBL_ENTRY _ZTI9S10179C81[];
extern  VTBL_ENTRY _ZTV9S10179C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
extern Class_Descriptor cd_S10179C80;
extern VTBL_ENTRY _ZTI9S10179C80[];
extern  VTBL_ENTRY _ZTV9S10179C80[];
extern Class_Descriptor cd_S10179C83;
extern VTBL_ENTRY _ZTI9S10179C83[];
extern  VTBL_ENTRY _ZTV9S10179C83[];
extern Class_Descriptor cd_S10179C26;
extern VTBL_ENTRY _ZTI9S10179C26[];
extern  VTBL_ENTRY _ZTV9S10179C26[];
static Base_Class bases_S10179C79[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C11,    ABISELECT(48,32), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C2,    ABISELECT(144,96), //bcp->offset
    66, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C81,    ABISELECT(152,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C82,    ABISELECT(160,104), //bcp->offset
    90, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10179C80,    ABISELECT(152,100), //bcp->offset
    71, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C83,    ABISELECT(176,112), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C26,    ABISELECT(184,116), //bcp->offset
    100, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C79[];
extern void _ZN9S10179C79D1Ev();
extern void _ZN9S10179C79D0Ev();
extern void _ZN9S10179C794v116Ev();
extern void _ZN9S10179C794v117Ev();
extern void _ZN9S10179C794v118Ev();
extern void _ZN9S10179C794v119Ev();
extern void _ZN9S10179C794v120Ev();
extern void _ZN9S10179C794v121Ev();
extern void _ZN9S10179C794v122Ev();
extern void _ZN9S10179C794v123Ev();
extern void _ZN9S10179C794v124Ev();
extern void _ZN9S10179C794v125Ev();
extern void _ZN9S10179C794v126Ev();
extern void _ZN9S10179C794v127Ev();
extern void _ZN9S10179C794v128Ev();
extern void _ZN9S10179C794v129Ev();
extern void _ZN9S10179C794v130Ev();
extern void _ZN9S10179C794v131Ev();
extern void _ZN9S10179C794v132Ev();
extern void _ZN9S10179C794v133Ev();
extern void _ZN9S10179C794v134Ev();
extern void _ZN9S10179C794v135Ev();
extern void _ZN9S10179C794v136Ev();
extern void _ZN9S10179C794v137Ev();
extern void _ZN9S10179C794v138Ev();
extern void _ZN9S10179C794v139Ev();
extern void _ZN9S10179C794v140Ev();
extern void _ZN9S10179C794v141Ev();
extern void _ZN9S10179C794v142Ev();
extern void _ZN9S10179C794v143Ev();
extern void _ZN9S10179C794v144Ev();
extern void _ZN9S10179C794v145Ev();
extern void _ZN9S10179C794v146Ev();
extern void _ZN9S10179C794v147Ev();
extern void _ZN9S10179C794v148Ev();
extern void _ZN9S10179C794v149Ev();
extern void ABISELECT(_ZThn48_N9S10179C79D1Ev,_ZThn32_N9S10179C79D1Ev)();
extern void ABISELECT(_ZThn48_N9S10179C79D0Ev,_ZThn32_N9S10179C79D0Ev)();
extern void _ZN9S10179C113v15Ev();
extern void _ZN9S10179C113v16Ev();
extern void _ZN9S10179C113v17Ev();
extern void _ZN9S10179C113v18Ev();
extern void _ZN9S10179C113v19Ev();
extern void _ZN9S10179C113v20Ev();
extern void _ZN9S10179C113v21Ev();
extern void _ZN9S10179C113v22Ev();
extern void _ZN9S10179C113v23Ev();
extern void _ZN9S10179C113v24Ev();
extern void _ZN9S10179C113v25Ev();
extern void _ZN9S10179C113v26Ev();
extern void _ZN9S10179C113v27Ev();
extern void _ZN9S10179C113v28Ev();
extern void _ZN9S10179C113v29Ev();
extern void _ZN9S10179C113v30Ev();
extern void _ZN9S10179C113v31Ev();
extern void _ZN9S10179C113v32Ev();
extern void _ZN9S10179C113v33Ev();
extern void _ZN9S10179C113v34Ev();
extern void _ZN9S10179C113v35Ev();
extern void _ZN9S10179C113v36Ev();
extern void _ZN9S10179C113v37Ev();
extern void _ZN9S10179C113v38Ev();
extern void ABISELECT(_ZThn144_N9S10179C79D1Ev,_ZThn96_N9S10179C79D1Ev)();
extern void ABISELECT(_ZThn144_N9S10179C79D0Ev,_ZThn96_N9S10179C79D0Ev)();
extern void _ZN8S10179C22v7Ev();
extern void ABISELECT(_ZThn152_N9S10179C79D1Ev,_ZThn100_N9S10179C79D1Ev)();
extern void ABISELECT(_ZThn152_N9S10179C79D0Ev,_ZThn100_N9S10179C79D0Ev)();
extern void _ZN9S10179C813v99Ev();
extern void _ZN9S10179C814v100Ev();
extern void _ZN9S10179C814v101Ev();
extern void _ZN9S10179C814v102Ev();
extern void _ZN9S10179C814v103Ev();
extern void _ZN9S10179C814v104Ev();
extern void _ZN9S10179C814v105Ev();
extern void _ZN9S10179C814v106Ev();
extern void _ZN9S10179C814v107Ev();
extern void _ZN9S10179C814v108Ev();
extern void _ZN9S10179C814v109Ev();
extern void _ZN9S10179C814v110Ev();
extern void _ZN9S10179C814v111Ev();
extern void _ZN9S10179C814v112Ev();
extern void _ZN9S10179C814v113Ev();
extern void ABISELECT(_ZThn160_N9S10179C79D1Ev,_ZThn104_N9S10179C79D1Ev)();
extern void ABISELECT(_ZThn160_N9S10179C79D0Ev,_ZThn104_N9S10179C79D0Ev)();
extern void ABISELECT(_ZThn176_N9S10179C79D1Ev,_ZThn112_N9S10179C79D1Ev)();
extern void ABISELECT(_ZThn176_N9S10179C79D0Ev,_ZThn112_N9S10179C79D0Ev)();
extern void _ZN9S10179C834v114Ev();
extern void _ZN9S10179C834v115Ev();
extern void ABISELECT(_ZThn184_N9S10179C79D1Ev,_ZThn116_N9S10179C79D1Ev)();
extern void ABISELECT(_ZThn184_N9S10179C79D0Ev,_ZThn116_N9S10179C79D0Ev)();
extern void _ZN9S10179C263v64Ev();
static  VTBL_ENTRY vtc_S10179C79[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C79[0]),
  (VTBL_ENTRY)&_ZN9S10179C79D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C79D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v116Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v117Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v118Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v119Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v120Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v121Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v122Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v123Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v124Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v125Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v126Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v127Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v128Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v129Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v130Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v131Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v132Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v133Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v134Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v135Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v136Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v137Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v138Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v139Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v140Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v141Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v142Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v143Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v144Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v145Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v146Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v147Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v148Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v149Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10179C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C79D1Ev,_ZThn32_N9S10179C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C79D0Ev,_ZThn32_N9S10179C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S10179C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10179C79D1Ev,_ZThn96_N9S10179C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10179C79D0Ev,_ZThn96_N9S10179C79D0Ev),
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S10179C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10179C79D1Ev,_ZThn100_N9S10179C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10179C79D0Ev,_ZThn100_N9S10179C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v113Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S10179C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10179C79D1Ev,_ZThn104_N9S10179C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10179C79D0Ev,_ZThn104_N9S10179C79D0Ev),
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI9S10179C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10179C79D1Ev,_ZThn112_N9S10179C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10179C79D0Ev,_ZThn112_N9S10179C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C834v114Ev,
  (VTBL_ENTRY)&_ZN9S10179C834v115Ev,
  ABISELECT(-184,-116),
  (VTBL_ENTRY)&(_ZTI9S10179C79[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10179C79D1Ev,_ZThn116_N9S10179C79D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10179C79D0Ev,_ZThn116_N9S10179C79D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C263v64Ev,
};
extern VTBL_ENTRY _ZTI9S10179C79[];
extern  VTBL_ENTRY _ZTV9S10179C79[];
Class_Descriptor cd_S10179C79 = {  "S10179C79", // class name
  bases_S10179C79, 8,
  &(vtc_S10179C79[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6440,4496), // object size
  NSPAIRA(_ZTI9S10179C79),ABISELECT(120,64), //typeinfo_var
  NSPAIRA(_ZTV9S10179C79),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C78  : S10179C79 {
  char s10179c78f0;
  virtual  ~S10179C78(); // _ZN9S10179C78D1Ev
  virtual void  v97(); // _ZN9S10179C783v97Ev
  virtual void  v98(); // _ZN9S10179C783v98Ev
  S10179C78(); // tgen
};
//SIG(-1 S10179C78) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC11{ vd v27} BC12{ BC13{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42} BC14{ vd m Fp}} BC15{ vd v43 v44} BC16{ vd v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fp[5] Fi Fp FC17{ m Fi[2]} FC18{ m Fp} FC19{ BC20{ BC3 vd v81 v82 v83 v84 FC21{ m Fp FC8 FC9 FC9 Fi[3] FC22{ m FC23{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v80} FC24{ BC20 v85 v86} FC25{ BC20 v87} FC26{ BC27{ BC3 vd v90 v91 v92 v93 FC21 Fp Fc Fi} v88 v89} FC28{ BC20 v94 v95 v96 FC29{ Fp[3]} FC30{ Fi[4]}[3]} FC31{ BC3 BC7 vd v97 v98 v99 v100 v101 v102 v103 v104 FC32{ m FC9 Fi[2] FC9} Fi[2] Fc[2] Fi FL[2] FC33{ m Fl} Fi} FC34{ BC35{ BC3 BC36{ vd v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp FC8 FC10} vd v134 v135 v136 v137 v138 v139} BC37{ vd v140} vd v105 v106 v107 v108 v109 FC38{ m Fi Fp Fi FC22} FC39{ m Fp Fi[2] FC6}} FC40{ BC3 BC36 vd v141 v142 v143 v144 FC41{ m FC39 Fp[2]} Fp[2] FC9 Fi} FC42{ BC3 BC36 BC37 BC43{ BC44{ vd v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178} BC14} BC45{ vd v179 v180} BC46{ vd v181} vd v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 FC41 Fp[2] Fi[2] FC47{ BC3 vd v182 Fp FC8 FC8 Fp Fi FC22} FC48{ BC20 v183 v184} FC24 FC24 FC22 FC22 FC22 Fi} FC49{ BC50{ BC3 BC36 BC37 vd v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 Fi[2] FC25 FC41 FC51{ BC20 v214 v215 v216 Fp[3]} FC52{ BC20 v217} FC24 FC48 FC53{ BC3 vd v218 v219 FC54{ BC55{ BC56{ m Fp FC22 FC22 Fi[3] Fc[2] Fi Fp} FC57{ m Fp} FC18 FC57 FC9 FC9 FC57 FC18 FC57 FC9 FC9 FC9 Fc Fi Fp} FC9} Fi} FC19 FC58{ BC52 v220} FC19 Fp FC18 Fp[2] Fi Fc[3] Fi FL[2]} vd v185 v186 v187 v188 v189 v190 FC59{ m Fp} FC60{ m Fp FC18 Fp[5] FC61{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC62{ m FC63{ m Fi[2]} FC63} FC63 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC41 Fc[2] Fi FC64{ m Fc[5]} FC65{ m FC22 FC22 FC22 FC57 Fi Fc[2] Fi} FC22 FC22 FC22 Fp FC66{ BC3 vd FC67{ m Fp[3] FC17 FC9 FL[2] Fc} FC41} Fc[2] FL Fc[2] Fi FC57 FC68{ m FC69{ BC70{ m Fp Fi FC71{ m} FC71}} Fi} Fc Fi} vd v1 v2 Fc}


 S10179C78 ::~S10179C78(){ note_dtor("S10179C78", this);}
void  S10179C78 ::v97(){vfunc_called(this, "_ZN9S10179C783v97Ev");}
void  S10179C78 ::v98(){vfunc_called(this, "_ZN9S10179C783v98Ev");}
S10179C78 ::S10179C78(){ note_ctor("S10179C78", this);} // tgen

static void Test_S10179C78()
{
  extern Class_Descriptor cd_S10179C78;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(807,1126)];
    init_test(&cd_S10179C78, buf);
    S10179C78 *dp, &lv = *(dp=new (buf) S10179C78());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6448,4500), "sizeof(S10179C78)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C78)");
    check_base_class_offset(lv, (S10180C17*)(S10179C79*), 0, "S10179C78");
    check_base_class_offset(lv, (S10179C11*)(S10179C79*), ABISELECT(48,32), "S10179C78");
    check_base_class_offset(lv, (S10179C2*)(S10179C79*), ABISELECT(144,96), "S10179C78");
    check_base_class_offset(lv, (S10179C81*)(S10179C80*)(S10179C79*), ABISELECT(152,100), "S10179C78");
    check_base_class_offset(lv, (S10180C82*)(S10179C80*)(S10179C79*), ABISELECT(160,104), "S10179C78");
    check_base_class_offset(lv, (S10179C80*)(S10179C79*), ABISELECT(152,100), "S10179C78");
    check_base_class_offset(lv, (S10179C83*)(S10179C79*), ABISELECT(176,112), "S10179C78");
    check_base_class_offset(lv, (S10179C26*)(S10179C79*), ABISELECT(184,116), "S10179C78");
    check_base_class_offset(lv, (S10179C79*), 0, "S10179C78");
    check_field_offset(lv, s10179c78f0, ABISELECT(6440,4496), "S10179C78.s10179c78f0");
    test_class_info(&lv, &cd_S10179C78);
    dp->~S10179C78();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C78(Test_S10179C78, "S10179C78", ABISELECT(6448,4500));

#else // __cplusplus

extern void _ZN9S10179C78C1Ev();
extern void _ZN9S10179C78D1Ev();
Name_Map name_map_S10179C78[] = {
  NSPAIR(_ZN9S10179C78C1Ev),
  NSPAIR(_ZN9S10179C78D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C11;
extern VTBL_ENTRY _ZTI9S10179C11[];
extern  VTBL_ENTRY _ZTV9S10179C11[];
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
extern Class_Descriptor cd_S10179C81;
extern VTBL_ENTRY _ZTI9S10179C81[];
extern  VTBL_ENTRY _ZTV9S10179C81[];
extern Class_Descriptor cd_S10180C82;
extern VTBL_ENTRY _ZTI9S10180C82[];
extern  VTBL_ENTRY _ZTV9S10180C82[];
extern Class_Descriptor cd_S10179C80;
extern VTBL_ENTRY _ZTI9S10179C80[];
extern  VTBL_ENTRY _ZTV9S10179C80[];
extern Class_Descriptor cd_S10179C83;
extern VTBL_ENTRY _ZTI9S10179C83[];
extern  VTBL_ENTRY _ZTV9S10179C83[];
extern Class_Descriptor cd_S10179C26;
extern VTBL_ENTRY _ZTI9S10179C26[];
extern  VTBL_ENTRY _ZTV9S10179C26[];
extern Class_Descriptor cd_S10179C79;
extern VTBL_ENTRY _ZTI9S10179C79[];
extern  VTBL_ENTRY _ZTV9S10179C79[];
static Base_Class bases_S10179C78[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10179C11,    ABISELECT(48,32), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10179C2,    ABISELECT(144,96), //bcp->offset
    68, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10179C81,    ABISELECT(152,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10180C82,    ABISELECT(160,104), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S10179C80,    ABISELECT(152,100), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10179C83,    ABISELECT(176,112), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10179C26,    ABISELECT(184,116), //bcp->offset
    102, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S10179C79,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C78[];
extern void _ZN9S10179C78D1Ev();
extern void _ZN9S10179C78D0Ev();
extern void _ZN9S10179C794v116Ev();
extern void _ZN9S10179C794v117Ev();
extern void _ZN9S10179C794v118Ev();
extern void _ZN9S10179C794v119Ev();
extern void _ZN9S10179C794v120Ev();
extern void _ZN9S10179C794v121Ev();
extern void _ZN9S10179C794v122Ev();
extern void _ZN9S10179C794v123Ev();
extern void _ZN9S10179C794v124Ev();
extern void _ZN9S10179C794v125Ev();
extern void _ZN9S10179C794v126Ev();
extern void _ZN9S10179C794v127Ev();
extern void _ZN9S10179C794v128Ev();
extern void _ZN9S10179C794v129Ev();
extern void _ZN9S10179C794v130Ev();
extern void _ZN9S10179C794v131Ev();
extern void _ZN9S10179C794v132Ev();
extern void _ZN9S10179C794v133Ev();
extern void _ZN9S10179C794v134Ev();
extern void _ZN9S10179C794v135Ev();
extern void _ZN9S10179C794v136Ev();
extern void _ZN9S10179C794v137Ev();
extern void _ZN9S10179C794v138Ev();
extern void _ZN9S10179C794v139Ev();
extern void _ZN9S10179C794v140Ev();
extern void _ZN9S10179C794v141Ev();
extern void _ZN9S10179C794v142Ev();
extern void _ZN9S10179C794v143Ev();
extern void _ZN9S10179C794v144Ev();
extern void _ZN9S10179C794v145Ev();
extern void _ZN9S10179C794v146Ev();
extern void _ZN9S10179C794v147Ev();
extern void _ZN9S10179C794v148Ev();
extern void _ZN9S10179C794v149Ev();
extern void _ZN9S10179C783v97Ev();
extern void _ZN9S10179C783v98Ev();
extern void ABISELECT(_ZThn48_N9S10179C78D1Ev,_ZThn32_N9S10179C78D1Ev)();
extern void ABISELECT(_ZThn48_N9S10179C78D0Ev,_ZThn32_N9S10179C78D0Ev)();
extern void _ZN9S10179C113v15Ev();
extern void _ZN9S10179C113v16Ev();
extern void _ZN9S10179C113v17Ev();
extern void _ZN9S10179C113v18Ev();
extern void _ZN9S10179C113v19Ev();
extern void _ZN9S10179C113v20Ev();
extern void _ZN9S10179C113v21Ev();
extern void _ZN9S10179C113v22Ev();
extern void _ZN9S10179C113v23Ev();
extern void _ZN9S10179C113v24Ev();
extern void _ZN9S10179C113v25Ev();
extern void _ZN9S10179C113v26Ev();
extern void _ZN9S10179C113v27Ev();
extern void _ZN9S10179C113v28Ev();
extern void _ZN9S10179C113v29Ev();
extern void _ZN9S10179C113v30Ev();
extern void _ZN9S10179C113v31Ev();
extern void _ZN9S10179C113v32Ev();
extern void _ZN9S10179C113v33Ev();
extern void _ZN9S10179C113v34Ev();
extern void _ZN9S10179C113v35Ev();
extern void _ZN9S10179C113v36Ev();
extern void _ZN9S10179C113v37Ev();
extern void _ZN9S10179C113v38Ev();
extern void ABISELECT(_ZThn144_N9S10179C78D1Ev,_ZThn96_N9S10179C78D1Ev)();
extern void ABISELECT(_ZThn144_N9S10179C78D0Ev,_ZThn96_N9S10179C78D0Ev)();
extern void _ZN8S10179C22v7Ev();
extern void ABISELECT(_ZThn152_N9S10179C78D1Ev,_ZThn100_N9S10179C78D1Ev)();
extern void ABISELECT(_ZThn152_N9S10179C78D0Ev,_ZThn100_N9S10179C78D0Ev)();
extern void _ZN9S10179C813v99Ev();
extern void _ZN9S10179C814v100Ev();
extern void _ZN9S10179C814v101Ev();
extern void _ZN9S10179C814v102Ev();
extern void _ZN9S10179C814v103Ev();
extern void _ZN9S10179C814v104Ev();
extern void _ZN9S10179C814v105Ev();
extern void _ZN9S10179C814v106Ev();
extern void _ZN9S10179C814v107Ev();
extern void _ZN9S10179C814v108Ev();
extern void _ZN9S10179C814v109Ev();
extern void _ZN9S10179C814v110Ev();
extern void _ZN9S10179C814v111Ev();
extern void _ZN9S10179C814v112Ev();
extern void _ZN9S10179C814v113Ev();
extern void ABISELECT(_ZThn160_N9S10179C78D1Ev,_ZThn104_N9S10179C78D1Ev)();
extern void ABISELECT(_ZThn160_N9S10179C78D0Ev,_ZThn104_N9S10179C78D0Ev)();
extern void ABISELECT(_ZThn176_N9S10179C78D1Ev,_ZThn112_N9S10179C78D1Ev)();
extern void ABISELECT(_ZThn176_N9S10179C78D0Ev,_ZThn112_N9S10179C78D0Ev)();
extern void _ZN9S10179C834v114Ev();
extern void _ZN9S10179C834v115Ev();
extern void ABISELECT(_ZThn184_N9S10179C78D1Ev,_ZThn116_N9S10179C78D1Ev)();
extern void ABISELECT(_ZThn184_N9S10179C78D0Ev,_ZThn116_N9S10179C78D0Ev)();
extern void _ZN9S10179C263v64Ev();
static  VTBL_ENTRY vtc_S10179C78[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C78[0]),
  (VTBL_ENTRY)&_ZN9S10179C78D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C78D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v116Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v117Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v118Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v119Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v120Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v121Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v122Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v123Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v124Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v125Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v126Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v127Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v128Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v129Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v130Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v131Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v132Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v133Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v134Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v135Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v136Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v137Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v138Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v139Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v140Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v141Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v142Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v143Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v144Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v145Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v146Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v147Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v148Ev,
  (VTBL_ENTRY)&_ZN9S10179C794v149Ev,
  (VTBL_ENTRY)&_ZN9S10179C783v97Ev,
  (VTBL_ENTRY)&_ZN9S10179C783v98Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10179C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C78D1Ev,_ZThn32_N9S10179C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10179C78D0Ev,_ZThn32_N9S10179C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S10179C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10179C78D1Ev,_ZThn96_N9S10179C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S10179C78D0Ev,_ZThn96_N9S10179C78D0Ev),
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S10179C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10179C78D1Ev,_ZThn100_N9S10179C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10179C78D0Ev,_ZThn100_N9S10179C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C813v99Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v100Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v101Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v102Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v103Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v104Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v105Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v106Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v107Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v108Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v109Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v110Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v111Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v112Ev,
  (VTBL_ENTRY)&_ZN9S10179C814v113Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S10179C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10179C78D1Ev,_ZThn104_N9S10179C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10179C78D0Ev,_ZThn104_N9S10179C78D0Ev),
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI9S10179C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10179C78D1Ev,_ZThn112_N9S10179C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N9S10179C78D0Ev,_ZThn112_N9S10179C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C834v114Ev,
  (VTBL_ENTRY)&_ZN9S10179C834v115Ev,
  ABISELECT(-184,-116),
  (VTBL_ENTRY)&(_ZTI9S10179C78[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10179C78D1Ev,_ZThn116_N9S10179C78D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N9S10179C78D0Ev,_ZThn116_N9S10179C78D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C263v64Ev,
};
extern VTBL_ENTRY _ZTI9S10179C78[];
extern  VTBL_ENTRY _ZTV9S10179C78[];
Class_Descriptor cd_S10179C78 = {  "S10179C78", // class name
  bases_S10179C78, 9,
  &(vtc_S10179C78[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6448,4500), // object size
  NSPAIRA(_ZTI9S10179C78),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10179C78),107, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  9, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C16  : S10179C2 , S10180C17 , S10179C24 {
  void *s10179c16f0[5];
  ::S10179C25 s10179c16f1;
  ::S10179C78 s10179c16f2;
  ::S10179C87 s10179c16f3;
  ::S10179C87 s10179c16f4;
  void *s10179c16f5;
  char s10179c16f6;
  void *s10179c16f7;
  int s10179c16f8;
  virtual  ~S10179C16(); // _ZN9S10179C16D1Ev
  virtual void  v39(); // _ZN9S10179C163v39Ev
  virtual void  v40(); // _ZN9S10179C163v40Ev
  S10179C16(); // tgen
};
//SIG(-1 S10179C16) C1{ BC2{ vd v3} BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} BC7{ vd v4} vd v1 v2 Fp[5] FC8{ BC3 BC2 BC9{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 Fp FC10{ m FC11{ m Fp Fi FC5} Fi} FC12{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC13{ vd v51} BC14{ vd v52 v53} vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fi FC15{ m Fi[2]} FC15 FC15 FC16{ BC3 vd Fi Fp FC10 FL FC17{ m Fi[2]} Fi Fc Fi FC18{ m FC19{ m Fp Fi[2] FC6} Fp[2]}} FC20{ BC21{ vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fp FC10 FC12} vd v54 v55 v56} FC22{ vd m Fi Fp[3] FC23{ m Fc[2] Fp[3] Fi[4] FC24{ m FC25{ Fl[4]}}}} FC26{ vd m FC24 Fi[2] FC27{ m FL[3] Fi[3] FL} FL FC28{ m Fi FC29{ m Fi[4]}} FC18 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC30{ BC3 BC7 vd v81 Fi FC31{ m Fc[2]} FC32{ Fp[2]} Fp FC33{ vd m FC34{ vd m FC35{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC36{ BC37{ vd v88 v89 v90 v91 v92 v93 Fi Fp Fc} vd v82 v83 v84 v85 v86 v87 Fp} FC38{ BC39{ vd v95 Fi Fc[3]} vd v94 Fp[4] FL Fi FC24 FC40{ m Fp FC41{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC42{ BC39 vd v96 FC24 Fi Fp[2] FC43{ m FC24 FC40 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC44{ BC39 vd v97 Fp[2] FL Fi[4] FC45{ m Fi[2]} FC24 FC46{ m FC24 FC40 Fp Fi[4]} FC47{ m Fp}} FC24 FC24 FL Fi[5]} FL FC48{ m FC27 FC49{ m Fi} Fi} Fc[128] FC15 FC18} Fi[3] FC50{ m Fp Fi[2]} FC51{ m Fc[11] Fi[2]} FC52{ BC53{} FL Fi} FC54{ BC55{ BC3 vd v100 v101 v102 v103 FC56{ m Fp FC10 FC11 FC11 Fi[3] FC57{ m FC58{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC10 FC10 Fc} Fp Fc Fi} v98 v99} FL FC59{ BC55 v104} FC60{ BC55 v105} FC61{ BC55 v106 v107} FC18 Fc} FC62{ BC63{ BC3 BC9 BC2 BC64{ BC65{ vd v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124} BC66{ vd m Fp}} BC67{ vd v125 v126} BC13 vd v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 Fp[5] Fi Fp FC68{ m Fi[2]} FC69{ m Fp} FC70{ BC55 v161} FC54 FC60 FC71{ BC72{ BC3 vd v164 v165 v166 v167 FC56 Fp Fc Fi} v162 v163} FC73{ BC55 v168 v169 v170 FC74{ Fp[3]} FC41[3]} FC75{ BC3 BC9 vd v171 v172 v173 v174 v175 v176 v177 v178 FC76{ m FC11 Fi[2] FC11} Fi[2] Fc[2] Fi FL[2] FC77{ m Fl} Fi} FC78{ BC79{ BC3 BC21 vd v184 v185 v186 v187 v188 v189} BC80{ vd v190} vd v179 v180 v181 v182 v183 FC81{ m Fi Fp Fi FC57} FC19} FC82{ BC3 BC21 vd v191 v192 v193 v194 FC18 Fp[2] FC11 Fi} FC83{ BC3 BC21 BC80 BC84{ BC85{ vd v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228} BC66} BC86{ vd v229 v230} BC87{ vd v231} vd v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 FC18 Fp[2] Fi[2] FC88{ BC3 vd v232 Fp FC10 FC10 Fp Fi FC57} FC61 FC54 FC54 FC57 FC57 FC57 Fi} FC89{ BC90{ BC3 BC21 BC80 vd v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 Fi[2] FC60 FC18 FC91{ BC55 v262 v263 v264 Fp[3]} FC59 FC54 FC61 FC92{ BC3 vd v265 v266 FC93{ BC94{ BC95{ m Fp FC57 FC57 Fi[3] Fc[2] Fi Fp} FC96{ m Fp} FC69 FC96 FC11 FC11 FC96 FC69 FC96 FC11 FC11 FC11 Fc Fi Fp} FC11} Fi} FC70 FC97{ BC59 v267} FC70 Fp FC69 Fp[2] Fi Fc[3] Fi FL[2]} vd v233 v234 v235 v236 v237 v238 FC47 FC98{ m Fp FC69 Fp[5] FC99{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC100{ m FC45 FC45} FC45 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC18 Fc[2] Fi FC101{ m Fc[5]} FC102{ m FC57 FC57 FC57 FC96 Fi Fc[2] Fi} FC57 FC57 FC57 Fp FC103{ BC3 vd FC104{ m Fp[3] FC68 FC11 FL[2] Fc} FC18} Fc[2] FL Fc[2] Fi FC96 FC105{ m FC106{ BC107{ m Fp Fi FC108{ m} FC108}} Fi} Fc Fi} vd v108 v109 Fc} FC71 FC71 Fp Fc Fp Fi}


 S10179C16 ::~S10179C16(){ note_dtor("S10179C16", this);}
void  S10179C16 ::v39(){vfunc_called(this, "_ZN9S10179C163v39Ev");}
void  S10179C16 ::v40(){vfunc_called(this, "_ZN9S10179C163v40Ev");}
S10179C16 ::S10179C16(){ note_ctor("S10179C16", this);} // tgen

static void Test_S10179C16()
{
  extern Class_Descriptor cd_S10179C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2918,5078)];
    init_test(&cd_S10179C16, buf);
    S10179C16 *dp, &lv = *(dp=new (buf) S10179C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(23336,20308), "sizeof(S10179C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C16)");
    check_base_class_offset(lv, (S10179C2*), 0, "S10179C16");
    check_base_class_offset(lv, (S10180C17*), ABISELECT(8,4), "S10179C16");
    check_base_class_offset(lv, (S10179C24*), ABISELECT(56,36), "S10179C16");
    check_field_offset(lv, s10179c16f0, ABISELECT(64,40), "S10179C16.s10179c16f0");
    check_field_offset(lv, s10179c16f1, ABISELECT(104,60), "S10179C16.s10179c16f1");
    check_field_offset(lv, s10179c16f2, ABISELECT(16392,15464), "S10179C16.s10179c16f2");
    check_field_offset(lv, s10179c16f3, ABISELECT(22840,19964), "S10179C16.s10179c16f3");
    check_field_offset(lv, s10179c16f4, ABISELECT(23072,20128), "S10179C16.s10179c16f4");
    check_field_offset(lv, s10179c16f5, ABISELECT(23304,20292), "S10179C16.s10179c16f5");
    check_field_offset(lv, s10179c16f6, ABISELECT(23312,20296), "S10179C16.s10179c16f6");
    check_field_offset(lv, s10179c16f7, ABISELECT(23320,20300), "S10179C16.s10179c16f7");
    check_field_offset(lv, s10179c16f8, ABISELECT(23328,20304), "S10179C16.s10179c16f8");
    test_class_info(&lv, &cd_S10179C16);
    dp->~S10179C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C16(Test_S10179C16, "S10179C16", ABISELECT(23336,20308));

#else // __cplusplus

extern void _ZN9S10179C16C1Ev();
extern void _ZN9S10179C16D1Ev();
Name_Map name_map_S10179C16[] = {
  NSPAIR(_ZN9S10179C16C1Ev),
  NSPAIR(_ZN9S10179C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C24;
extern VTBL_ENTRY _ZTI9S10179C24[];
extern  VTBL_ENTRY _ZTV9S10179C24[];
static Base_Class bases_S10179C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10179C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C17,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C24,    ABISELECT(56,36), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10179C16[];
extern void _ZN9S10179C16D1Ev();
extern void _ZN9S10179C16D0Ev();
extern void _ZN8S10179C22v7Ev();
extern void _ZN9S10179C163v39Ev();
extern void _ZN9S10179C163v40Ev();
extern void ABISELECT(_ZThn8_N9S10179C16D1Ev,_ZThn4_N9S10179C16D1Ev)();
extern void ABISELECT(_ZThn8_N9S10179C16D0Ev,_ZThn4_N9S10179C16D0Ev)();
extern void ABISELECT(_ZThn56_N9S10179C16D1Ev,_ZThn36_N9S10179C16D1Ev)();
extern void ABISELECT(_ZThn56_N9S10179C16D0Ev,_ZThn36_N9S10179C16D0Ev)();
extern void _ZN9S10179C243v41Ev();
static  VTBL_ENTRY vtc_S10179C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10179C16[0]),
  (VTBL_ENTRY)&_ZN9S10179C16D1Ev,
  (VTBL_ENTRY)&_ZN9S10179C16D0Ev,
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
  (VTBL_ENTRY)&_ZN9S10179C163v39Ev,
  (VTBL_ENTRY)&_ZN9S10179C163v40Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10179C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10179C16D1Ev,_ZThn4_N9S10179C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10179C16D0Ev,_ZThn4_N9S10179C16D0Ev),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S10179C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10179C16D1Ev,_ZThn36_N9S10179C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10179C16D0Ev,_ZThn36_N9S10179C16D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10179C16[];
extern  VTBL_ENTRY _ZTV9S10179C16[];
Class_Descriptor cd_S10179C16 = {  "S10179C16", // class name
  bases_S10179C16, 3,
  &(vtc_S10179C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(23336,20308), // object size
  NSPAIRA(_ZTI9S10179C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S10179C16),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C145  : S10180C17 {
  void *s10179c145f0[2];
  ::S10180C61 s10179c145f1;
  char s10179c145f2[2];
  void *s10179c145f3;
  ::S10180C146 s10179c145f4;
  ::S10180C12 s10179c145f5;
  void *s10179c145f6[4];
  ::S10180C31 s10179c145f7;
  virtual  ~S10179C145(); // _ZN10S10179C145D1Ev
  virtual void  v262(); // _ZN10S10179C1454v262Ev
  virtual void  v263(); // _ZN10S10179C1454v263Ev
  virtual void  v264(); // _ZN10S10179C1454v264Ev
  virtual void  v265(); // _ZN10S10179C1454v265Ev
  virtual void  v266(); // _ZN10S10179C1454v266Ev
  virtual void  v267(); // _ZN10S10179C1454v267Ev
  virtual void  v268(); // _ZN10S10179C1454v268Ev
  virtual void  v269(); // _ZN10S10179C1454v269Ev
  virtual void  v270(); // _ZN10S10179C1454v270Ev
  virtual void  v271(); // _ZN10S10179C1454v271Ev
  virtual void  v272(); // _ZN10S10179C1454v272Ev
  virtual void  v273(); // _ZN10S10179C1454v273Ev
  virtual void  v274(); // _ZN10S10179C1454v274Ev
  virtual void  v275(); // _ZN10S10179C1454v275Ev
  virtual void  v276(); // _ZN10S10179C1454v276Ev
  virtual void  v277(); // _ZN10S10179C1454v277Ev
  virtual void  v278(); // _ZN10S10179C1454v278Ev
  virtual void  v279(); // _ZN10S10179C1454v279Ev
  virtual void  v280(); // _ZN10S10179C1454v280Ev
  virtual void  v281(); // _ZN10S10179C1454v281Ev
  S10179C145(); // tgen
};
//SIG(-1 S10179C145) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp[2] FC6{ m Fp} Fc[2] Fp FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC10{ m FC11{ m FL}} FC10 FC8 FC8} FC12{ m FC13{ m Fp Fi FC4} Fi} Fp[4] FC14{ m FC15{ m Fp Fi[2] FC5} Fp[2]}}


 S10179C145 ::~S10179C145(){ note_dtor("S10179C145", this);}
void  S10179C145 ::v262(){vfunc_called(this, "_ZN10S10179C1454v262Ev");}
void  S10179C145 ::v263(){vfunc_called(this, "_ZN10S10179C1454v263Ev");}
void  S10179C145 ::v264(){vfunc_called(this, "_ZN10S10179C1454v264Ev");}
void  S10179C145 ::v265(){vfunc_called(this, "_ZN10S10179C1454v265Ev");}
void  S10179C145 ::v266(){vfunc_called(this, "_ZN10S10179C1454v266Ev");}
void  S10179C145 ::v267(){vfunc_called(this, "_ZN10S10179C1454v267Ev");}
void  S10179C145 ::v268(){vfunc_called(this, "_ZN10S10179C1454v268Ev");}
void  S10179C145 ::v269(){vfunc_called(this, "_ZN10S10179C1454v269Ev");}
void  S10179C145 ::v270(){vfunc_called(this, "_ZN10S10179C1454v270Ev");}
void  S10179C145 ::v271(){vfunc_called(this, "_ZN10S10179C1454v271Ev");}
void  S10179C145 ::v272(){vfunc_called(this, "_ZN10S10179C1454v272Ev");}
void  S10179C145 ::v273(){vfunc_called(this, "_ZN10S10179C1454v273Ev");}
void  S10179C145 ::v274(){vfunc_called(this, "_ZN10S10179C1454v274Ev");}
void  S10179C145 ::v275(){vfunc_called(this, "_ZN10S10179C1454v275Ev");}
void  S10179C145 ::v276(){vfunc_called(this, "_ZN10S10179C1454v276Ev");}
void  S10179C145 ::v277(){vfunc_called(this, "_ZN10S10179C1454v277Ev");}
void  S10179C145 ::v278(){vfunc_called(this, "_ZN10S10179C1454v278Ev");}
void  S10179C145 ::v279(){vfunc_called(this, "_ZN10S10179C1454v279Ev");}
void  S10179C145 ::v280(){vfunc_called(this, "_ZN10S10179C1454v280Ev");}
void  S10179C145 ::v281(){vfunc_called(this, "_ZN10S10179C1454v281Ev");}
S10179C145 ::S10179C145(){ note_ctor("S10179C145", this);} // tgen

static void Test_S10179C145()
{
  extern Class_Descriptor cd_S10179C145;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,48)];
    init_test(&cd_S10179C145, buf);
    S10179C145 *dp, &lv = *(dp=new (buf) S10179C145());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,188), "sizeof(S10179C145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C145)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C145");
    check_field_offset(lv, s10179c145f0, ABISELECT(48,32), "S10179C145.s10179c145f0");
    check_field_offset(lv, s10179c145f1, ABISELECT(64,40), "S10179C145.s10179c145f1");
    check_field_offset(lv, s10179c145f2, ABISELECT(72,44), "S10179C145.s10179c145f2");
    check_field_offset(lv, s10179c145f3, ABISELECT(80,48), "S10179C145.s10179c145f3");
    check_field_offset(lv, s10179c145f4, ABISELECT(88,52), "S10179C145.s10179c145f4");
    check_field_offset(lv, s10179c145f5, ABISELECT(168,132), "S10179C145.s10179c145f5");
    check_field_offset(lv, s10179c145f6, ABISELECT(192,148), "S10179C145.s10179c145f6");
    check_field_offset(lv, s10179c145f7, ABISELECT(224,164), "S10179C145.s10179c145f7");
    test_class_info(&lv, &cd_S10179C145);
    dp->~S10179C145();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C145(Test_S10179C145, "S10179C145", ABISELECT(264,188));

#else // __cplusplus

extern void _ZN10S10179C145C1Ev();
extern void _ZN10S10179C145D1Ev();
Name_Map name_map_S10179C145[] = {
  NSPAIR(_ZN10S10179C145C1Ev),
  NSPAIR(_ZN10S10179C145D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10179C145[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C145[];
extern void _ZN10S10179C145D1Ev();
extern void _ZN10S10179C145D0Ev();
extern void _ZN10S10179C1454v262Ev();
extern void _ZN10S10179C1454v263Ev();
extern void _ZN10S10179C1454v264Ev();
extern void _ZN10S10179C1454v265Ev();
extern void _ZN10S10179C1454v266Ev();
extern void _ZN10S10179C1454v267Ev();
extern void _ZN10S10179C1454v268Ev();
extern void _ZN10S10179C1454v269Ev();
extern void _ZN10S10179C1454v270Ev();
extern void _ZN10S10179C1454v271Ev();
extern void _ZN10S10179C1454v272Ev();
extern void _ZN10S10179C1454v273Ev();
extern void _ZN10S10179C1454v274Ev();
extern void _ZN10S10179C1454v275Ev();
extern void _ZN10S10179C1454v276Ev();
extern void _ZN10S10179C1454v277Ev();
extern void _ZN10S10179C1454v278Ev();
extern void _ZN10S10179C1454v279Ev();
extern void _ZN10S10179C1454v280Ev();
extern void _ZN10S10179C1454v281Ev();
static  VTBL_ENTRY vtc_S10179C145[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C145[0]),
  (VTBL_ENTRY)&_ZN10S10179C145D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C145D0Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v281Ev,
};
extern VTBL_ENTRY _ZTI10S10179C145[];
extern  VTBL_ENTRY _ZTV10S10179C145[];
Class_Descriptor cd_S10179C145 = {  "S10179C145", // class name
  bases_S10179C145, 1,
  &(vtc_S10179C145[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,188), // object size
  NSPAIRA(_ZTI10S10179C145),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10179C145),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C151  : S10179C145 {
  ::S10180C149 s10179c151f0;
  void *s10179c151f1;
  virtual  ~S10179C151(); // _ZN10S10179C151D1Ev
  virtual void  v301(); // _ZN10S10179C1514v301Ev
  virtual void  v302(); // _ZN10S10179C1514v302Ev
  virtual void  v303(); // _ZN10S10179C1514v303Ev
  virtual void  v304(); // _ZN10S10179C1514v304Ev
  virtual void  v305(); // _ZN10S10179C1514v305Ev
  virtual void  v306(); // _ZN10S10179C1514v306Ev
  virtual void  v307(); // _ZN10S10179C1514v307Ev
  virtual void  v308(); // _ZN10S10179C1514v308Ev
  virtual void  v309(); // _ZN10S10179C1514v309Ev
  virtual void  v310(); // _ZN10S10179C1514v310Ev
  virtual void  v311(); // _ZN10S10179C1514v311Ev
  virtual void  v312(); // _ZN10S10179C1514v312Ev
  virtual void  v313(); // _ZN10S10179C1514v313Ev
  virtual void  v314(); // _ZN10S10179C1514v314Ev
  virtual void  v315(); // _ZN10S10179C1514v315Ev
  virtual void  v316(); // _ZN10S10179C1514v316Ev
  virtual void  v317(); // _ZN10S10179C1514v317Ev
  virtual void  v318(); // _ZN10S10179C1514v318Ev
  virtual void  v319(); // _ZN10S10179C1514v319Ev
  S10179C151(); // tgen
};
//SIG(-1 S10179C151) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp[2] FC7{ m Fp} Fc[2] Fp FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC11{ m FC12{ m FL}} FC11 FC9 FC9} FC13{ m FC14{ m Fp Fi FC5} Fi} Fp[4] FC15{ m FC16{ m Fp Fi[2] FC6} Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC17{ vd m Fi[2] FC14 FC14 FC14 FC14 FC18{ m Fp[2]} FL[2]} Fp}


 S10179C151 ::~S10179C151(){ note_dtor("S10179C151", this);}
void  S10179C151 ::v301(){vfunc_called(this, "_ZN10S10179C1514v301Ev");}
void  S10179C151 ::v302(){vfunc_called(this, "_ZN10S10179C1514v302Ev");}
void  S10179C151 ::v303(){vfunc_called(this, "_ZN10S10179C1514v303Ev");}
void  S10179C151 ::v304(){vfunc_called(this, "_ZN10S10179C1514v304Ev");}
void  S10179C151 ::v305(){vfunc_called(this, "_ZN10S10179C1514v305Ev");}
void  S10179C151 ::v306(){vfunc_called(this, "_ZN10S10179C1514v306Ev");}
void  S10179C151 ::v307(){vfunc_called(this, "_ZN10S10179C1514v307Ev");}
void  S10179C151 ::v308(){vfunc_called(this, "_ZN10S10179C1514v308Ev");}
void  S10179C151 ::v309(){vfunc_called(this, "_ZN10S10179C1514v309Ev");}
void  S10179C151 ::v310(){vfunc_called(this, "_ZN10S10179C1514v310Ev");}
void  S10179C151 ::v311(){vfunc_called(this, "_ZN10S10179C1514v311Ev");}
void  S10179C151 ::v312(){vfunc_called(this, "_ZN10S10179C1514v312Ev");}
void  S10179C151 ::v313(){vfunc_called(this, "_ZN10S10179C1514v313Ev");}
void  S10179C151 ::v314(){vfunc_called(this, "_ZN10S10179C1514v314Ev");}
void  S10179C151 ::v315(){vfunc_called(this, "_ZN10S10179C1514v315Ev");}
void  S10179C151 ::v316(){vfunc_called(this, "_ZN10S10179C1514v316Ev");}
void  S10179C151 ::v317(){vfunc_called(this, "_ZN10S10179C1514v317Ev");}
void  S10179C151 ::v318(){vfunc_called(this, "_ZN10S10179C1514v318Ev");}
void  S10179C151 ::v319(){vfunc_called(this, "_ZN10S10179C1514v319Ev");}
S10179C151 ::S10179C151(){ note_ctor("S10179C151", this);} // tgen

static void Test_S10179C151()
{
  extern Class_Descriptor cd_S10179C151;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10179C151, buf);
    S10179C151 *dp, &lv = *(dp=new (buf) S10179C151());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10179C151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C151)");
    check_base_class_offset(lv, (S10180C17*)(S10179C145*), 0, "S10179C151");
    check_base_class_offset(lv, (S10179C145*), 0, "S10179C151");
    check_field_offset(lv, s10179c151f0, ABISELECT(264,188), "S10179C151.s10179c151f0");
    check_field_offset(lv, s10179c151f1, ABISELECT(376,272), "S10179C151.s10179c151f1");
    test_class_info(&lv, &cd_S10179C151);
    dp->~S10179C151();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C151(Test_S10179C151, "S10179C151", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10179C151C1Ev();
extern void _ZN10S10179C151D1Ev();
Name_Map name_map_S10179C151[] = {
  NSPAIR(_ZN10S10179C151C1Ev),
  NSPAIR(_ZN10S10179C151D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C145;
extern VTBL_ENTRY _ZTI10S10179C145[];
extern  VTBL_ENTRY _ZTV10S10179C145[];
static Base_Class bases_S10179C151[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10179C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C151[];
extern void _ZN10S10179C151D1Ev();
extern void _ZN10S10179C151D0Ev();
extern void _ZN10S10179C1454v262Ev();
extern void _ZN10S10179C1454v263Ev();
extern void _ZN10S10179C1454v264Ev();
extern void _ZN10S10179C1454v265Ev();
extern void _ZN10S10179C1454v266Ev();
extern void _ZN10S10179C1454v267Ev();
extern void _ZN10S10179C1454v268Ev();
extern void _ZN10S10179C1454v269Ev();
extern void _ZN10S10179C1454v270Ev();
extern void _ZN10S10179C1454v271Ev();
extern void _ZN10S10179C1454v272Ev();
extern void _ZN10S10179C1454v273Ev();
extern void _ZN10S10179C1454v274Ev();
extern void _ZN10S10179C1454v275Ev();
extern void _ZN10S10179C1454v276Ev();
extern void _ZN10S10179C1454v277Ev();
extern void _ZN10S10179C1454v278Ev();
extern void _ZN10S10179C1454v279Ev();
extern void _ZN10S10179C1454v280Ev();
extern void _ZN10S10179C1454v281Ev();
extern void _ZN10S10179C1514v301Ev();
extern void _ZN10S10179C1514v302Ev();
extern void _ZN10S10179C1514v303Ev();
extern void _ZN10S10179C1514v304Ev();
extern void _ZN10S10179C1514v305Ev();
extern void _ZN10S10179C1514v306Ev();
extern void _ZN10S10179C1514v307Ev();
extern void _ZN10S10179C1514v308Ev();
extern void _ZN10S10179C1514v309Ev();
extern void _ZN10S10179C1514v310Ev();
extern void _ZN10S10179C1514v311Ev();
extern void _ZN10S10179C1514v312Ev();
extern void _ZN10S10179C1514v313Ev();
extern void _ZN10S10179C1514v314Ev();
extern void _ZN10S10179C1514v315Ev();
extern void _ZN10S10179C1514v316Ev();
extern void _ZN10S10179C1514v317Ev();
extern void _ZN10S10179C1514v318Ev();
extern void _ZN10S10179C1514v319Ev();
static  VTBL_ENTRY vtc_S10179C151[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C151[0]),
  (VTBL_ENTRY)&_ZN10S10179C151D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C151D0Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v301Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v302Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v303Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v304Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v305Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v306Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v307Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v308Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v309Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v310Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v311Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v312Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v313Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v314Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v315Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v316Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v317Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v318Ev,
  (VTBL_ENTRY)&_ZN10S10179C1514v319Ev,
};
extern VTBL_ENTRY _ZTI10S10179C151[];
extern  VTBL_ENTRY _ZTV10S10179C151[];
Class_Descriptor cd_S10179C151 = {  "S10179C151", // class name
  bases_S10179C151, 2,
  &(vtc_S10179C151[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10179C151),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10179C151),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C144  : S10179C145 {
  ::S10180C149 s10179c144f0;
  void *s10179c144f1;
  virtual  ~S10179C144(); // _ZN10S10179C144D1Ev
  virtual void  v282(); // _ZN10S10179C1444v282Ev
  virtual void  v283(); // _ZN10S10179C1444v283Ev
  virtual void  v284(); // _ZN10S10179C1444v284Ev
  virtual void  v285(); // _ZN10S10179C1444v285Ev
  virtual void  v286(); // _ZN10S10179C1444v286Ev
  virtual void  v287(); // _ZN10S10179C1444v287Ev
  virtual void  v288(); // _ZN10S10179C1444v288Ev
  virtual void  v289(); // _ZN10S10179C1444v289Ev
  virtual void  v290(); // _ZN10S10179C1444v290Ev
  virtual void  v291(); // _ZN10S10179C1444v291Ev
  virtual void  v292(); // _ZN10S10179C1444v292Ev
  virtual void  v293(); // _ZN10S10179C1444v293Ev
  virtual void  v294(); // _ZN10S10179C1444v294Ev
  virtual void  v295(); // _ZN10S10179C1444v295Ev
  virtual void  v296(); // _ZN10S10179C1444v296Ev
  virtual void  v297(); // _ZN10S10179C1444v297Ev
  virtual void  v298(); // _ZN10S10179C1444v298Ev
  virtual void  v299(); // _ZN10S10179C1444v299Ev
  virtual void  v300(); // _ZN10S10179C1444v300Ev
  S10179C144(); // tgen
};
//SIG(-1 S10179C144) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp[2] FC7{ m Fp} Fc[2] Fp FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC11{ m FC12{ m FL}} FC11 FC9 FC9} FC13{ m FC14{ m Fp Fi FC5} Fi} Fp[4] FC15{ m FC16{ m Fp Fi[2] FC6} Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC17{ vd m Fi[2] FC14 FC14 FC14 FC14 FC18{ m Fp[2]} FL[2]} Fp}


 S10179C144 ::~S10179C144(){ note_dtor("S10179C144", this);}
void  S10179C144 ::v282(){vfunc_called(this, "_ZN10S10179C1444v282Ev");}
void  S10179C144 ::v283(){vfunc_called(this, "_ZN10S10179C1444v283Ev");}
void  S10179C144 ::v284(){vfunc_called(this, "_ZN10S10179C1444v284Ev");}
void  S10179C144 ::v285(){vfunc_called(this, "_ZN10S10179C1444v285Ev");}
void  S10179C144 ::v286(){vfunc_called(this, "_ZN10S10179C1444v286Ev");}
void  S10179C144 ::v287(){vfunc_called(this, "_ZN10S10179C1444v287Ev");}
void  S10179C144 ::v288(){vfunc_called(this, "_ZN10S10179C1444v288Ev");}
void  S10179C144 ::v289(){vfunc_called(this, "_ZN10S10179C1444v289Ev");}
void  S10179C144 ::v290(){vfunc_called(this, "_ZN10S10179C1444v290Ev");}
void  S10179C144 ::v291(){vfunc_called(this, "_ZN10S10179C1444v291Ev");}
void  S10179C144 ::v292(){vfunc_called(this, "_ZN10S10179C1444v292Ev");}
void  S10179C144 ::v293(){vfunc_called(this, "_ZN10S10179C1444v293Ev");}
void  S10179C144 ::v294(){vfunc_called(this, "_ZN10S10179C1444v294Ev");}
void  S10179C144 ::v295(){vfunc_called(this, "_ZN10S10179C1444v295Ev");}
void  S10179C144 ::v296(){vfunc_called(this, "_ZN10S10179C1444v296Ev");}
void  S10179C144 ::v297(){vfunc_called(this, "_ZN10S10179C1444v297Ev");}
void  S10179C144 ::v298(){vfunc_called(this, "_ZN10S10179C1444v298Ev");}
void  S10179C144 ::v299(){vfunc_called(this, "_ZN10S10179C1444v299Ev");}
void  S10179C144 ::v300(){vfunc_called(this, "_ZN10S10179C1444v300Ev");}
S10179C144 ::S10179C144(){ note_ctor("S10179C144", this);} // tgen

static void Test_S10179C144()
{
  extern Class_Descriptor cd_S10179C144;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10179C144, buf);
    S10179C144 *dp, &lv = *(dp=new (buf) S10179C144());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10179C144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C144)");
    check_base_class_offset(lv, (S10180C17*)(S10179C145*), 0, "S10179C144");
    check_base_class_offset(lv, (S10179C145*), 0, "S10179C144");
    check_field_offset(lv, s10179c144f0, ABISELECT(264,188), "S10179C144.s10179c144f0");
    check_field_offset(lv, s10179c144f1, ABISELECT(376,272), "S10179C144.s10179c144f1");
    test_class_info(&lv, &cd_S10179C144);
    dp->~S10179C144();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C144(Test_S10179C144, "S10179C144", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10179C144C1Ev();
extern void _ZN10S10179C144D1Ev();
Name_Map name_map_S10179C144[] = {
  NSPAIR(_ZN10S10179C144C1Ev),
  NSPAIR(_ZN10S10179C144D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C145;
extern VTBL_ENTRY _ZTI10S10179C145[];
extern  VTBL_ENTRY _ZTV10S10179C145[];
static Base_Class bases_S10179C144[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10179C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C144[];
extern void _ZN10S10179C144D1Ev();
extern void _ZN10S10179C144D0Ev();
extern void _ZN10S10179C1454v262Ev();
extern void _ZN10S10179C1454v263Ev();
extern void _ZN10S10179C1454v264Ev();
extern void _ZN10S10179C1454v265Ev();
extern void _ZN10S10179C1454v266Ev();
extern void _ZN10S10179C1454v267Ev();
extern void _ZN10S10179C1454v268Ev();
extern void _ZN10S10179C1454v269Ev();
extern void _ZN10S10179C1454v270Ev();
extern void _ZN10S10179C1454v271Ev();
extern void _ZN10S10179C1454v272Ev();
extern void _ZN10S10179C1454v273Ev();
extern void _ZN10S10179C1454v274Ev();
extern void _ZN10S10179C1454v275Ev();
extern void _ZN10S10179C1454v276Ev();
extern void _ZN10S10179C1454v277Ev();
extern void _ZN10S10179C1454v278Ev();
extern void _ZN10S10179C1454v279Ev();
extern void _ZN10S10179C1454v280Ev();
extern void _ZN10S10179C1454v281Ev();
extern void _ZN10S10179C1444v282Ev();
extern void _ZN10S10179C1444v283Ev();
extern void _ZN10S10179C1444v284Ev();
extern void _ZN10S10179C1444v285Ev();
extern void _ZN10S10179C1444v286Ev();
extern void _ZN10S10179C1444v287Ev();
extern void _ZN10S10179C1444v288Ev();
extern void _ZN10S10179C1444v289Ev();
extern void _ZN10S10179C1444v290Ev();
extern void _ZN10S10179C1444v291Ev();
extern void _ZN10S10179C1444v292Ev();
extern void _ZN10S10179C1444v293Ev();
extern void _ZN10S10179C1444v294Ev();
extern void _ZN10S10179C1444v295Ev();
extern void _ZN10S10179C1444v296Ev();
extern void _ZN10S10179C1444v297Ev();
extern void _ZN10S10179C1444v298Ev();
extern void _ZN10S10179C1444v299Ev();
extern void _ZN10S10179C1444v300Ev();
static  VTBL_ENTRY vtc_S10179C144[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C144[0]),
  (VTBL_ENTRY)&_ZN10S10179C144D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C144D0Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v300Ev,
};
extern VTBL_ENTRY _ZTI10S10179C144[];
extern  VTBL_ENTRY _ZTV10S10179C144[];
Class_Descriptor cd_S10179C144 = {  "S10179C144", // class name
  bases_S10179C144, 2,
  &(vtc_S10179C144[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10179C144),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10179C144),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C156  : S10179C144 {
  virtual  ~S10179C156(); // _ZN10S10179C156D1Ev
  virtual void  v339(); // _ZN10S10179C1564v339Ev
  virtual void  v340(); // _ZN10S10179C1564v340Ev
  virtual void  v341(); // _ZN10S10179C1564v341Ev
  S10179C156(); // tgen
};
//SIG(-1 S10179C156) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC5 Fc} vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp[2] FC8{ m Fp} Fc[2] Fp FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC12{ m FC13{ m FL}} FC12 FC10 FC10} FC14{ m FC15{ m Fp Fi FC6} Fi} Fp[4] FC16{ m FC17{ m Fp Fi[2] FC7} Fp[2]}} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 FC18{ vd m Fi[2] FC15 FC15 FC15 FC15 FC19{ m Fp[2]} FL[2]} Fp} vd v1 v2 v3}


 S10179C156 ::~S10179C156(){ note_dtor("S10179C156", this);}
void  S10179C156 ::v339(){vfunc_called(this, "_ZN10S10179C1564v339Ev");}
void  S10179C156 ::v340(){vfunc_called(this, "_ZN10S10179C1564v340Ev");}
void  S10179C156 ::v341(){vfunc_called(this, "_ZN10S10179C1564v341Ev");}
S10179C156 ::S10179C156(){ note_ctor("S10179C156", this);} // tgen

static void Test_S10179C156()
{
  extern Class_Descriptor cd_S10179C156;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10179C156, buf);
    S10179C156 *dp, &lv = *(dp=new (buf) S10179C156());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10179C156)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C156)");
    check_base_class_offset(lv, (S10180C17*)(S10179C145*)(S10179C144*), 0, "S10179C156");
    check_base_class_offset(lv, (S10179C145*)(S10179C144*), 0, "S10179C156");
    check_base_class_offset(lv, (S10179C144*), 0, "S10179C156");
    test_class_info(&lv, &cd_S10179C156);
    dp->~S10179C156();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C156(Test_S10179C156, "S10179C156", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10179C156C1Ev();
extern void _ZN10S10179C156D1Ev();
Name_Map name_map_S10179C156[] = {
  NSPAIR(_ZN10S10179C156C1Ev),
  NSPAIR(_ZN10S10179C156D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C145;
extern VTBL_ENTRY _ZTI10S10179C145[];
extern  VTBL_ENTRY _ZTV10S10179C145[];
extern Class_Descriptor cd_S10179C144;
extern VTBL_ENTRY _ZTI10S10179C144[];
extern  VTBL_ENTRY _ZTV10S10179C144[];
static Base_Class bases_S10179C156[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10179C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10179C144,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C156[];
extern void _ZN10S10179C156D1Ev();
extern void _ZN10S10179C156D0Ev();
extern void _ZN10S10179C1454v262Ev();
extern void _ZN10S10179C1454v263Ev();
extern void _ZN10S10179C1454v264Ev();
extern void _ZN10S10179C1454v265Ev();
extern void _ZN10S10179C1454v266Ev();
extern void _ZN10S10179C1454v267Ev();
extern void _ZN10S10179C1454v268Ev();
extern void _ZN10S10179C1454v269Ev();
extern void _ZN10S10179C1454v270Ev();
extern void _ZN10S10179C1454v271Ev();
extern void _ZN10S10179C1454v272Ev();
extern void _ZN10S10179C1454v273Ev();
extern void _ZN10S10179C1454v274Ev();
extern void _ZN10S10179C1454v275Ev();
extern void _ZN10S10179C1454v276Ev();
extern void _ZN10S10179C1454v277Ev();
extern void _ZN10S10179C1454v278Ev();
extern void _ZN10S10179C1454v279Ev();
extern void _ZN10S10179C1454v280Ev();
extern void _ZN10S10179C1454v281Ev();
extern void _ZN10S10179C1444v282Ev();
extern void _ZN10S10179C1444v283Ev();
extern void _ZN10S10179C1444v284Ev();
extern void _ZN10S10179C1444v285Ev();
extern void _ZN10S10179C1444v286Ev();
extern void _ZN10S10179C1444v287Ev();
extern void _ZN10S10179C1444v288Ev();
extern void _ZN10S10179C1444v289Ev();
extern void _ZN10S10179C1444v290Ev();
extern void _ZN10S10179C1444v291Ev();
extern void _ZN10S10179C1444v292Ev();
extern void _ZN10S10179C1444v293Ev();
extern void _ZN10S10179C1444v294Ev();
extern void _ZN10S10179C1444v295Ev();
extern void _ZN10S10179C1444v296Ev();
extern void _ZN10S10179C1444v297Ev();
extern void _ZN10S10179C1444v298Ev();
extern void _ZN10S10179C1444v299Ev();
extern void _ZN10S10179C1444v300Ev();
extern void _ZN10S10179C1564v339Ev();
extern void _ZN10S10179C1564v340Ev();
extern void _ZN10S10179C1564v341Ev();
static  VTBL_ENTRY vtc_S10179C156[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C156[0]),
  (VTBL_ENTRY)&_ZN10S10179C156D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C156D0Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v300Ev,
  (VTBL_ENTRY)&_ZN10S10179C1564v339Ev,
  (VTBL_ENTRY)&_ZN10S10179C1564v340Ev,
  (VTBL_ENTRY)&_ZN10S10179C1564v341Ev,
};
extern VTBL_ENTRY _ZTI10S10179C156[];
extern  VTBL_ENTRY _ZTV10S10179C156[];
Class_Descriptor cd_S10179C156 = {  "S10179C156", // class name
  bases_S10179C156, 3,
  &(vtc_S10179C156[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10179C156),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10179C156),46, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C157  : S10179C144 {
  virtual  ~S10179C157(); // _ZN10S10179C157D1Ev
  virtual void  v342(); // _ZN10S10179C1574v342Ev
  virtual void  v343(); // _ZN10S10179C1574v343Ev
  S10179C157(); // tgen
};
//SIG(-1 S10179C157) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC5 Fc} vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] FC8{ m Fp} Fc[2] Fp FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC12{ m FC13{ m FL}} FC12 FC10 FC10} FC14{ m FC15{ m Fp Fi FC6} Fi} Fp[4] FC16{ m FC17{ m Fp Fi[2] FC7} Fp[2]}} vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 FC18{ vd m Fi[2] FC15 FC15 FC15 FC15 FC19{ m Fp[2]} FL[2]} Fp} vd v1 v2}


 S10179C157 ::~S10179C157(){ note_dtor("S10179C157", this);}
void  S10179C157 ::v342(){vfunc_called(this, "_ZN10S10179C1574v342Ev");}
void  S10179C157 ::v343(){vfunc_called(this, "_ZN10S10179C1574v343Ev");}
S10179C157 ::S10179C157(){ note_ctor("S10179C157", this);} // tgen

static void Test_S10179C157()
{
  extern Class_Descriptor cd_S10179C157;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,70)];
    init_test(&cd_S10179C157, buf);
    S10179C157 *dp, &lv = *(dp=new (buf) S10179C157());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,276), "sizeof(S10179C157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C157)");
    check_base_class_offset(lv, (S10180C17*)(S10179C145*)(S10179C144*), 0, "S10179C157");
    check_base_class_offset(lv, (S10179C145*)(S10179C144*), 0, "S10179C157");
    check_base_class_offset(lv, (S10179C144*), 0, "S10179C157");
    test_class_info(&lv, &cd_S10179C157);
    dp->~S10179C157();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C157(Test_S10179C157, "S10179C157", ABISELECT(384,276));

#else // __cplusplus

extern void _ZN10S10179C157C1Ev();
extern void _ZN10S10179C157D1Ev();
Name_Map name_map_S10179C157[] = {
  NSPAIR(_ZN10S10179C157C1Ev),
  NSPAIR(_ZN10S10179C157D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C145;
extern VTBL_ENTRY _ZTI10S10179C145[];
extern  VTBL_ENTRY _ZTV10S10179C145[];
extern Class_Descriptor cd_S10179C144;
extern VTBL_ENTRY _ZTI10S10179C144[];
extern  VTBL_ENTRY _ZTV10S10179C144[];
static Base_Class bases_S10179C157[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10179C145,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10179C144,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C157[];
extern void _ZN10S10179C157D1Ev();
extern void _ZN10S10179C157D0Ev();
extern void _ZN10S10179C1454v262Ev();
extern void _ZN10S10179C1454v263Ev();
extern void _ZN10S10179C1454v264Ev();
extern void _ZN10S10179C1454v265Ev();
extern void _ZN10S10179C1454v266Ev();
extern void _ZN10S10179C1454v267Ev();
extern void _ZN10S10179C1454v268Ev();
extern void _ZN10S10179C1454v269Ev();
extern void _ZN10S10179C1454v270Ev();
extern void _ZN10S10179C1454v271Ev();
extern void _ZN10S10179C1454v272Ev();
extern void _ZN10S10179C1454v273Ev();
extern void _ZN10S10179C1454v274Ev();
extern void _ZN10S10179C1454v275Ev();
extern void _ZN10S10179C1454v276Ev();
extern void _ZN10S10179C1454v277Ev();
extern void _ZN10S10179C1454v278Ev();
extern void _ZN10S10179C1454v279Ev();
extern void _ZN10S10179C1454v280Ev();
extern void _ZN10S10179C1454v281Ev();
extern void _ZN10S10179C1444v282Ev();
extern void _ZN10S10179C1444v283Ev();
extern void _ZN10S10179C1444v284Ev();
extern void _ZN10S10179C1444v285Ev();
extern void _ZN10S10179C1444v286Ev();
extern void _ZN10S10179C1444v287Ev();
extern void _ZN10S10179C1444v288Ev();
extern void _ZN10S10179C1444v289Ev();
extern void _ZN10S10179C1444v290Ev();
extern void _ZN10S10179C1444v291Ev();
extern void _ZN10S10179C1444v292Ev();
extern void _ZN10S10179C1444v293Ev();
extern void _ZN10S10179C1444v294Ev();
extern void _ZN10S10179C1444v295Ev();
extern void _ZN10S10179C1444v296Ev();
extern void _ZN10S10179C1444v297Ev();
extern void _ZN10S10179C1444v298Ev();
extern void _ZN10S10179C1444v299Ev();
extern void _ZN10S10179C1444v300Ev();
extern void _ZN10S10179C1574v342Ev();
extern void _ZN10S10179C1574v343Ev();
static  VTBL_ENTRY vtc_S10179C157[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C157[0]),
  (VTBL_ENTRY)&_ZN10S10179C157D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C157D0Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v262Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v263Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v264Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v265Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v266Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v267Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v268Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v269Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v270Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v271Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v272Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v273Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v274Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v275Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v276Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v277Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v278Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v279Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v280Ev,
  (VTBL_ENTRY)&_ZN10S10179C1454v281Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v282Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v283Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v284Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v285Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v286Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v287Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v288Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v289Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v290Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v291Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v292Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v293Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v294Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v295Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v296Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v297Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v298Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v299Ev,
  (VTBL_ENTRY)&_ZN10S10179C1444v300Ev,
  (VTBL_ENTRY)&_ZN10S10179C1574v342Ev,
  (VTBL_ENTRY)&_ZN10S10179C1574v343Ev,
};
extern VTBL_ENTRY _ZTI10S10179C157[];
extern  VTBL_ENTRY _ZTV10S10179C157[];
Class_Descriptor cd_S10179C157 = {  "S10179C157", // class name
  bases_S10179C157, 3,
  &(vtc_S10179C157[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,276), // object size
  NSPAIRA(_ZTI10S10179C157),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10179C157),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C114  {
  void *s10179c114f0;
  void  mf10179c114(); // _ZN10S10179C11411mf10179c114Ev
};
//SIG(-1 S10179C114) C1{ m Fp}


void  S10179C114 ::mf10179c114(){}

static void Test_S10179C114()
{
  {
    init_simple_test("S10179C114");
    S10179C114 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10179C114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C114)");
    check_field_offset(lv, s10179c114f0, 0, "S10179C114.s10179c114f0");
  }
}
static Arrange_To_Call_Me vS10179C114(Test_S10179C114, "S10179C114", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C159  {
  long s10179c159f0;
  char s10179c159f1;
  __tsi64 s10179c159f2[2];
  ::S10179C114 s10179c159f3;
  void  mf10179c159(); // _ZN10S10179C15911mf10179c159Ev
};
//SIG(-1 S10179C159) C1{ m Fl Fc FL[2] FC2{ m Fp}}


void  S10179C159 ::mf10179c159(){}

static void Test_S10179C159()
{
  {
    init_simple_test("S10179C159");
    S10179C159 lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S10179C159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C159)");
    check_field_offset(lv, s10179c159f0, 0, "S10179C159.s10179c159f0");
    check_field_offset(lv, s10179c159f1, ABISELECT(8,4), "S10179C159.s10179c159f1");
    check_field_offset(lv, s10179c159f2, ABISELECT(16,8), "S10179C159.s10179c159f2");
    check_field_offset(lv, s10179c159f3, ABISELECT(32,24), "S10179C159.s10179c159f3");
  }
}
static Arrange_To_Call_Me vS10179C159(Test_S10179C159, "S10179C159", ABISELECT(40,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C106  : S10179C69 {
  virtual void  v233(); // _ZN10S10179C1064v233Ev
  ~S10179C106(); // tgen
  S10179C106(); // tgen
};
//SIG(-1 S10179C106) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v2 v3 v4 v5 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1}


void  S10179C106 ::v233(){vfunc_called(this, "_ZN10S10179C1064v233Ev");}
S10179C106 ::~S10179C106(){ note_dtor("S10179C106", this);} // tgen
S10179C106 ::S10179C106(){ note_ctor("S10179C106", this);} // tgen

static void Test_S10179C106()
{
  extern Class_Descriptor cd_S10179C106;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10179C106, buf);
    S10179C106 *dp, &lv = *(dp=new (buf) S10179C106());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10179C106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C106)");
    check_base_class_offset(lv, (S10180C17*)(S10179C69*), 0, "S10179C106");
    check_base_class_offset(lv, (S10179C69*), 0, "S10179C106");
    test_class_info(&lv, &cd_S10179C106);
    dp->~S10179C106();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C106(Test_S10179C106, "S10179C106", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN10S10179C106C1Ev();
extern void _ZN10S10179C106D1Ev();
Name_Map name_map_S10179C106[] = {
  NSPAIR(_ZN10S10179C106C1Ev),
  NSPAIR(_ZN10S10179C106D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C69;
extern VTBL_ENTRY _ZTI9S10179C69[];
extern  VTBL_ENTRY _ZTV9S10179C69[];
static Base_Class bases_S10179C106[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10179C69,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C106[];
extern void _ZN10S10179C106D1Ev();
extern void _ZN10S10179C106D0Ev();
extern void _ZN9S10179C693v89Ev();
extern void _ZN9S10179C693v90Ev();
extern void _ZN9S10179C693v91Ev();
extern void _ZN9S10179C693v92Ev();
extern void _ZN10S10179C1064v233Ev();
static  VTBL_ENTRY vtc_S10179C106[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C106[0]),
  (VTBL_ENTRY)&_ZN10S10179C106D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C106D0Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v89Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v90Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v91Ev,
  (VTBL_ENTRY)&_ZN9S10179C693v92Ev,
  (VTBL_ENTRY)&_ZN10S10179C1064v233Ev,
};
extern VTBL_ENTRY _ZTI10S10179C106[];
extern  VTBL_ENTRY _ZTV10S10179C106[];
Class_Descriptor cd_S10179C106 = {  "S10179C106", // class name
  bases_S10179C106, 2,
  &(vtc_S10179C106[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI10S10179C106),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10179C106),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C104  : S10180C17 , S10179C11 , S10179C2 {
  int s10179c104f0[2];
  ::S10180C75 s10179c104f1;
  ::S10180C31 s10179c104f2;
  ::S10180C105 s10179c104f3;
  ::S10179C106 s10179c104f4;
  ::S10179C87 s10179c104f5;
  ::S10180C87 s10179c104f6;
  ::S10180C107 s10179c104f7;
  ::S10180C106 s10179c104f8;
  ::S10180C112 s10179c104f9;
  ::S10180C86 s10179c104f10;
  void *s10179c104f11;
  ::S10180C61 s10179c104f12;
  void *s10179c104f13[2];
  int s10179c104f14;
  char s10179c104f15[3];
  int s10179c104f16;
  __tsi64 s10179c104f17[2];
  virtual  ~S10179C104(); // _ZN10S10179C104D1Ev
  virtual void  v207(); // _ZN10S10179C1044v207Ev
  virtual void  v208(); // _ZN10S10179C1044v208Ev
  virtual void  v209(); // _ZN10S10179C1044v209Ev
  virtual void  v210(); // _ZN10S10179C1044v210Ev
  virtual void  v211(); // _ZN10S10179C1044v211Ev
  virtual void  v212(); // _ZN10S10179C1044v212Ev
  virtual void  v213(); // _ZN10S10179C1044v213Ev
  virtual void  v214(); // _ZN10S10179C1044v214Ev
  virtual void  v215(); // _ZN10S10179C1044v215Ev
  virtual void  v216(); // _ZN10S10179C1044v216Ev
  virtual void  v217(); // _ZN10S10179C1044v217Ev
  virtual void  v218(); // _ZN10S10179C1044v218Ev
  virtual void  v219(); // _ZN10S10179C1044v219Ev
  virtual void  v220(); // _ZN10S10179C1044v220Ev
  virtual void  v221(); // _ZN10S10179C1044v221Ev
  virtual void  v222(); // _ZN10S10179C1044v222Ev
  virtual void  v223(); // _ZN10S10179C1044v223Ev
  virtual void  v224(); // _ZN10S10179C1044v224Ev
  virtual void  v225(); // _ZN10S10179C1044v225Ev
  virtual void  v226(); // _ZN10S10179C1044v226Ev
  virtual void  v227(); // _ZN10S10179C1044v227Ev
  virtual void  v228(); // _ZN10S10179C1044v228Ev
  virtual void  v229(); // _ZN10S10179C1044v229Ev
  S10179C104(); // tgen
};
//SIG(-1 S10179C104) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v48} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi[2] FC11{ BC12{ BC2 vd v50 v51 v52 v53 FC13{ m Fp FC7 FC8 FC8 Fi[3] FC14{ m FC15{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v49} FC16{ m FC17{ m Fp Fi[2] FC5} Fp[2]} FC18{ BC12 v54 v55 v56 Fp[3]} FC19{ BC20{ BC2 vd v58 v59 v60 v61 FC13 Fp Fc Fi} v57} FC21{ BC20 v62 v63} FC22{ BC12 v64 v65} FC23{ BC2 vd v66 v67 FC24{ BC25{ BC26{ m Fp FC14 FC14 Fi[3] Fc[2] Fi Fp} FC27{ m Fp} FC28{ m Fp} FC27 FC8 FC8 FC27 FC28 FC27 FC8 FC8 FC8 Fc Fi Fp} FC8} Fi} FC29{ BC12 v68} FC30{ BC29 v69} FC31{ BC12 v70} Fp FC27 Fp[2] Fi Fc[3] Fi FL[2]}


 S10179C104 ::~S10179C104(){ note_dtor("S10179C104", this);}
void  S10179C104 ::v207(){vfunc_called(this, "_ZN10S10179C1044v207Ev");}
void  S10179C104 ::v208(){vfunc_called(this, "_ZN10S10179C1044v208Ev");}
void  S10179C104 ::v209(){vfunc_called(this, "_ZN10S10179C1044v209Ev");}
void  S10179C104 ::v210(){vfunc_called(this, "_ZN10S10179C1044v210Ev");}
void  S10179C104 ::v211(){vfunc_called(this, "_ZN10S10179C1044v211Ev");}
void  S10179C104 ::v212(){vfunc_called(this, "_ZN10S10179C1044v212Ev");}
void  S10179C104 ::v213(){vfunc_called(this, "_ZN10S10179C1044v213Ev");}
void  S10179C104 ::v214(){vfunc_called(this, "_ZN10S10179C1044v214Ev");}
void  S10179C104 ::v215(){vfunc_called(this, "_ZN10S10179C1044v215Ev");}
void  S10179C104 ::v216(){vfunc_called(this, "_ZN10S10179C1044v216Ev");}
void  S10179C104 ::v217(){vfunc_called(this, "_ZN10S10179C1044v217Ev");}
void  S10179C104 ::v218(){vfunc_called(this, "_ZN10S10179C1044v218Ev");}
void  S10179C104 ::v219(){vfunc_called(this, "_ZN10S10179C1044v219Ev");}
void  S10179C104 ::v220(){vfunc_called(this, "_ZN10S10179C1044v220Ev");}
void  S10179C104 ::v221(){vfunc_called(this, "_ZN10S10179C1044v221Ev");}
void  S10179C104 ::v222(){vfunc_called(this, "_ZN10S10179C1044v222Ev");}
void  S10179C104 ::v223(){vfunc_called(this, "_ZN10S10179C1044v223Ev");}
void  S10179C104 ::v224(){vfunc_called(this, "_ZN10S10179C1044v224Ev");}
void  S10179C104 ::v225(){vfunc_called(this, "_ZN10S10179C1044v225Ev");}
void  S10179C104 ::v226(){vfunc_called(this, "_ZN10S10179C1044v226Ev");}
void  S10179C104 ::v227(){vfunc_called(this, "_ZN10S10179C1044v227Ev");}
void  S10179C104 ::v228(){vfunc_called(this, "_ZN10S10179C1044v228Ev");}
void  S10179C104 ::v229(){vfunc_called(this, "_ZN10S10179C1044v229Ev");}
S10179C104 ::S10179C104(){ note_ctor("S10179C104", this);} // tgen

static void Test_S10179C104()
{
  extern Class_Descriptor cd_S10179C104;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(305,427)];
    init_test(&cd_S10179C104, buf);
    S10179C104 *dp, &lv = *(dp=new (buf) S10179C104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2432,1704), "sizeof(S10179C104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C104)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C104");
    check_base_class_offset(lv, (S10179C11*), ABISELECT(48,32), "S10179C104");
    check_base_class_offset(lv, (S10179C2*), ABISELECT(144,96), "S10179C104");
    check_field_offset(lv, s10179c104f0, ABISELECT(152,100), "S10179C104.s10179c104f0");
    check_field_offset(lv, s10179c104f1, ABISELECT(160,108), "S10179C104.s10179c104f1");
    check_field_offset(lv, s10179c104f2, ABISELECT(392,272), "S10179C104.s10179c104f2");
    check_field_offset(lv, s10179c104f3, ABISELECT(432,296), "S10179C104.s10179c104f3");
    check_field_offset(lv, s10179c104f4, ABISELECT(688,472), "S10179C104.s10179c104f4");
    check_field_offset(lv, s10179c104f5, ABISELECT(920,636), "S10179C104.s10179c104f5");
    check_field_offset(lv, s10179c104f6, ABISELECT(1152,800), "S10179C104.s10179c104f6");
    check_field_offset(lv, s10179c104f7, ABISELECT(1384,964), "S10179C104.s10179c104f7");
    check_field_offset(lv, s10179c104f8, ABISELECT(1672,1168), "S10179C104.s10179c104f8");
    check_field_offset(lv, s10179c104f9, ABISELECT(1904,1332), "S10179C104.s10179c104f9");
    check_field_offset(lv, s10179c104f10, ABISELECT(2136,1496), "S10179C104.s10179c104f10");
    check_field_offset(lv, s10179c104f11, ABISELECT(2368,1660), "S10179C104.s10179c104f11");
    check_field_offset(lv, s10179c104f12, ABISELECT(2376,1664), "S10179C104.s10179c104f12");
    check_field_offset(lv, s10179c104f13, ABISELECT(2384,1668), "S10179C104.s10179c104f13");
    check_field_offset(lv, s10179c104f14, ABISELECT(2400,1676), "S10179C104.s10179c104f14");
    check_field_offset(lv, s10179c104f15, ABISELECT(2404,1680), "S10179C104.s10179c104f15");
    check_field_offset(lv, s10179c104f16, ABISELECT(2408,1684), "S10179C104.s10179c104f16");
    check_field_offset(lv, s10179c104f17, ABISELECT(2416,1688), "S10179C104.s10179c104f17");
    test_class_info(&lv, &cd_S10179C104);
    dp->~S10179C104();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C104(Test_S10179C104, "S10179C104", ABISELECT(2432,1704));

#else // __cplusplus

extern void _ZN10S10179C104C1Ev();
extern void _ZN10S10179C104D1Ev();
Name_Map name_map_S10179C104[] = {
  NSPAIR(_ZN10S10179C104C1Ev),
  NSPAIR(_ZN10S10179C104D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C11;
extern VTBL_ENTRY _ZTI9S10179C11[];
extern  VTBL_ENTRY _ZTV9S10179C11[];
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
static Base_Class bases_S10179C104[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C11,    ABISELECT(48,32), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C2,    ABISELECT(144,96), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C104[];
extern void _ZN10S10179C104D1Ev();
extern void _ZN10S10179C104D0Ev();
extern void _ZN10S10179C1044v207Ev();
extern void _ZN10S10179C1044v208Ev();
extern void _ZN10S10179C1044v209Ev();
extern void _ZN10S10179C1044v210Ev();
extern void _ZN10S10179C1044v211Ev();
extern void _ZN10S10179C1044v212Ev();
extern void _ZN10S10179C1044v213Ev();
extern void _ZN10S10179C1044v214Ev();
extern void _ZN10S10179C1044v215Ev();
extern void _ZN10S10179C1044v216Ev();
extern void _ZN10S10179C1044v217Ev();
extern void _ZN10S10179C1044v218Ev();
extern void _ZN10S10179C1044v219Ev();
extern void _ZN10S10179C1044v220Ev();
extern void _ZN10S10179C1044v221Ev();
extern void _ZN10S10179C1044v222Ev();
extern void _ZN10S10179C1044v223Ev();
extern void _ZN10S10179C1044v224Ev();
extern void _ZN10S10179C1044v225Ev();
extern void _ZN10S10179C1044v226Ev();
extern void _ZN10S10179C1044v227Ev();
extern void _ZN10S10179C1044v228Ev();
extern void _ZN10S10179C1044v229Ev();
extern void ABISELECT(_ZThn48_N10S10179C104D1Ev,_ZThn32_N10S10179C104D1Ev)();
extern void ABISELECT(_ZThn48_N10S10179C104D0Ev,_ZThn32_N10S10179C104D0Ev)();
extern void _ZN9S10179C113v15Ev();
extern void _ZN9S10179C113v16Ev();
extern void _ZN9S10179C113v17Ev();
extern void _ZN9S10179C113v18Ev();
extern void _ZN9S10179C113v19Ev();
extern void _ZN9S10179C113v20Ev();
extern void _ZN9S10179C113v21Ev();
extern void _ZN9S10179C113v22Ev();
extern void _ZN9S10179C113v23Ev();
extern void _ZN9S10179C113v24Ev();
extern void _ZN9S10179C113v25Ev();
extern void _ZN9S10179C113v26Ev();
extern void _ZN9S10179C113v27Ev();
extern void _ZN9S10179C113v28Ev();
extern void _ZN9S10179C113v29Ev();
extern void _ZN9S10179C113v30Ev();
extern void _ZN9S10179C113v31Ev();
extern void _ZN9S10179C113v32Ev();
extern void _ZN9S10179C113v33Ev();
extern void _ZN9S10179C113v34Ev();
extern void _ZN9S10179C113v35Ev();
extern void _ZN9S10179C113v36Ev();
extern void _ZN9S10179C113v37Ev();
extern void _ZN9S10179C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10179C104D1Ev,_ZThn96_N10S10179C104D1Ev)();
extern void ABISELECT(_ZThn144_N10S10179C104D0Ev,_ZThn96_N10S10179C104D0Ev)();
extern void _ZN8S10179C22v7Ev();
static  VTBL_ENTRY vtc_S10179C104[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C104[0]),
  (VTBL_ENTRY)&_ZN10S10179C104D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C104D0Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v207Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v208Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v209Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v210Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v211Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v212Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v213Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v214Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v215Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v216Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v217Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v218Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v219Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v220Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v221Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v222Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v223Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v224Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v225Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v226Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v227Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v228Ev,
  (VTBL_ENTRY)&_ZN10S10179C1044v229Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10179C104[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10179C104D1Ev,_ZThn32_N10S10179C104D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10179C104D0Ev,_ZThn32_N10S10179C104D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10179C104[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10179C104D1Ev,_ZThn96_N10S10179C104D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10179C104D0Ev,_ZThn96_N10S10179C104D0Ev),
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
};
extern VTBL_ENTRY _ZTI10S10179C104[];
extern  VTBL_ENTRY _ZTV10S10179C104[];
Class_Descriptor cd_S10179C104 = {  "S10179C104", // class name
  bases_S10179C104, 3,
  &(vtc_S10179C104[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2432,1704), // object size
  NSPAIRA(_ZTI10S10179C104),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV10S10179C104),60, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C130  : S10180C17 , S10179C11 , S10179C2 {
  ::S10180C31 s10179c130f0;
  void *s10179c130f1;
  ::S10180C87 s10179c130f2;
  ::S10180C94 s10179c130f3;
  ::S10180C111 s10179c130f4;
  ::S10180C131 s10179c130f5;
  ::S10180C135 s10179c130f6;
  ::S10180C101 s10179c130f7;
  ::S10180C143 s10179c130f8;
  ::S10179C151 s10179c130f9;
  ::S10180C157 s10179c130f10;
  ::S10180C152 s10179c130f11;
  ::S10180C154 s10179c130f12[9];
  ::S10180C155 s10179c130f13;
  ::S10179C156 s10179c130f14;
  ::S10179C157 s10179c130f15;
  ::S10180C158 s10179c130f16;
  void *s10179c130f17;
  int s10179c130f18;
  ::S10179C159 s10179c130f19;
  ::S10179C104 s10179c130f20;
  ::S10180C160 s10179c130f21;
  ::S10180C124 s10179c130f22;
  ::S10179C87 s10179c130f23;
  ::S10180C88 s10179c130f24;
  ::S10180C106 s10179c130f25;
  ::S10180C87 s10179c130f26;
  void *s10179c130f27;
  ::S10180C161 s10179c130f28;
  int s10179c130f29;
  ::S10180C163 s10179c130f30;
  void *s10179c130f31[2];
  int s10179c130f32;
  virtual  ~S10179C130(); // _ZN10S10179C130D1Ev
  virtual void  v238(); // _ZN10S10179C1304v238Ev
  virtual void  v239(); // _ZN10S10179C1304v239Ev
  virtual void  v240(); // _ZN10S10179C1304v240Ev
  virtual void  v241(); // _ZN10S10179C1304v241Ev
  virtual void  v242(); // _ZN10S10179C1304v242Ev
  virtual void  v243(); // _ZN10S10179C1304v243Ev
  virtual void  v244(); // _ZN10S10179C1304v244Ev
  virtual void  v245(); // _ZN10S10179C1304v245Ev
  S10179C130(); // tgen
};
//SIG(-1 S10179C130) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC10{ vd v33} vd v1 v2 v3 v4 v5 v6 v7 v8 FC11{ m FC12{ m Fp Fi[2] FC5} Fp[2]} Fp FC13{ BC14{ BC2 vd v36 v37 v38 v39 FC15{ m Fp FC7 FC8 FC8 Fi[3] FC16{ m FC17{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi} v34 v35} FC18{ BC19{ BC2 BC20{ vd v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fp FC7 FC9} vd v69 v70 v71 v72 v73 v74} BC21{ vd v75} vd v40 v41 v42 v43 v44 FC22{ m Fi Fp Fi FC16} FC12} FC23{ m Fp} FC24{ vd v76 v77 FC25{ m Fp Fi[2] FC26{ m}} FC27{ m Fi[4]}[3] Fp[2] Fi Fc} FC28{ BC21 vd v78 Fp[2] FC29{ m Fp Fi FC26 FC30{ m}} FC31{ BC2 vd v79 v80 v81 v82 FC32{ m Fp[2] FC8 FC25 Fi[2]}}} FC33{ BC2 vd v83 Fp FC7 FC7 Fp Fi FC16} FC34{ BC35{ BC36{ BC2 vd v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 Fp[2] FC23 Fc[2] Fp FC37{ m FC16 FC16 FC38{ m FC39{ m FL}} FC38 FC16 FC16} FC7 Fp[4] FC11} vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 FC40{ vd m Fi[2] FC8 FC8 FC8 FC8 FC41{ m Fp[2]} FL[2]} Fp} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 Fi[3]} FC42{ BC43{ BC2 vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 Fp[2] FC44{ m Fp} Fc[2] Fp FC37 FC7 Fp[4] FC11} vd v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 FC40 Fp} FC45{ BC35 vd v171 v172} FC46{ BC35 vd v173 v174} FC47{ BC36 vd v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 Fi[2] FL Fi}[9] FC48{ BC35 vd v187 v188 v189} FC49{ BC50{ BC43 vd v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC40 Fp} vd v190 v191 v192} FC51{ BC50 vd v212 v213} FC52{ BC2 BC21 BC20 vd v214 v215 v216 v217 Fp FC28 FC33 FC53{ BC14 v218 v219} FC54{ BC14 v220} Fp FL FC8} Fp Fi FC55{ m Fl Fc FL[2] FC56{ m Fp}} FC57{ BC2 BC6 BC10 vd v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 Fi[2] FC54 FC11 FC58{ BC14 v244 v245 v246 Fp[3]} FC59{ BC60{ BC2 vd v248 v249 v250 v251 FC15 Fp Fc Fi} v247} FC61{ BC60 v252 v253} FC13 FC62{ BC2 vd v254 v255 FC63{ BC64{ BC65{ m Fp FC16 FC16 Fi[3] Fc[2] Fi Fp} FC44 FC23 FC44 FC8 FC8 FC44 FC23 FC44 FC8 FC8 FC8 Fc Fi Fp} FC8} Fi} FC66{ BC14 v256} FC67{ BC66 v257} FC68{ BC14 v258} Fp FC44 Fp[2] Fi Fc[3] Fi FL[2]} FC69{ BC2 BC20 BC21 vd v259 v260 v261 v262 v263 v264 Fi FC68 FC11 FC58 FC66 FC13 FC53 FC23 Fp[2] Fi} FC70{ m FC71{ BC72{ m Fp Fi FC73{ m} FC73}} Fi} FC61 FC74{ BC14 v265 v266 v267 FC75{ Fp[3]} FC76{ Fi[4]}[3]} FC66 FC13 Fp FC77{ m Fp Fi[2] FC30} Fi FC78{ m FC11 FC79{ Fi FC80{ Fi[2] FL Fc}[9] Fi} FC8} Fp[2] Fi}


 S10179C130 ::~S10179C130(){ note_dtor("S10179C130", this);}
void  S10179C130 ::v238(){vfunc_called(this, "_ZN10S10179C1304v238Ev");}
void  S10179C130 ::v239(){vfunc_called(this, "_ZN10S10179C1304v239Ev");}
void  S10179C130 ::v240(){vfunc_called(this, "_ZN10S10179C1304v240Ev");}
void  S10179C130 ::v241(){vfunc_called(this, "_ZN10S10179C1304v241Ev");}
void  S10179C130 ::v242(){vfunc_called(this, "_ZN10S10179C1304v242Ev");}
void  S10179C130 ::v243(){vfunc_called(this, "_ZN10S10179C1304v243Ev");}
void  S10179C130 ::v244(){vfunc_called(this, "_ZN10S10179C1304v244Ev");}
void  S10179C130 ::v245(){vfunc_called(this, "_ZN10S10179C1304v245Ev");}
S10179C130 ::S10179C130(){ note_ctor("S10179C130", this);} // tgen

static void Test_S10179C130()
{
  extern Class_Descriptor cd_S10179C130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1572,2223)];
    init_test(&cd_S10179C130, buf);
    S10179C130 *dp, &lv = *(dp=new (buf) S10179C130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12568,8888), "sizeof(S10179C130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C130)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10179C130");
    check_base_class_offset(lv, (S10179C11*), ABISELECT(48,32), "S10179C130");
    check_base_class_offset(lv, (S10179C2*), ABISELECT(144,96), "S10179C130");
    check_field_offset(lv, s10179c130f0, ABISELECT(152,100), "S10179C130.s10179c130f0");
    check_field_offset(lv, s10179c130f1, ABISELECT(192,124), "S10179C130.s10179c130f1");
    check_field_offset(lv, s10179c130f2, ABISELECT(200,128), "S10179C130.s10179c130f2");
    check_field_offset(lv, s10179c130f3, ABISELECT(432,292), "S10179C130.s10179c130f3");
    check_field_offset(lv, s10179c130f4, ABISELECT(648,436), "S10179C130.s10179c130f4");
    check_field_offset(lv, s10179c130f5, ABISELECT(656,440), "S10179C130.s10179c130f5");
    check_field_offset(lv, s10179c130f6, ABISELECT(760,524), "S10179C130.s10179c130f6");
    check_field_offset(lv, s10179c130f7, ABISELECT(912,624), "S10179C130.s10179c130f7");
    check_field_offset(lv, s10179c130f8, ABISELECT(1048,716), "S10179C130.s10179c130f8");
    check_field_offset(lv, s10179c130f9, ABISELECT(1448,1004), "S10179C130.s10179c130f9");
    check_field_offset(lv, s10179c130f10, ABISELECT(1832,1280), "S10179C130.s10179c130f10");
    check_field_offset(lv, s10179c130f11, ABISELECT(2216,1556), "S10179C130.s10179c130f11");
    check_field_offset(lv, s10179c130f12, ABISELECT(2600,1832), "S10179C130.s10179c130f12");
    check_field_offset(lv, s10179c130f13, ABISELECT(5192,3704), "S10179C130.s10179c130f13");
    check_field_offset(lv, s10179c130f14, ABISELECT(5576,3980), "S10179C130.s10179c130f14");
    check_field_offset(lv, s10179c130f15, ABISELECT(5960,4256), "S10179C130.s10179c130f15");
    check_field_offset(lv, s10179c130f16, ABISELECT(6344,4532), "S10179C130.s10179c130f16");
    check_field_offset(lv, s10179c130f17, ABISELECT(7288,5180), "S10179C130.s10179c130f17");
    check_field_offset(lv, s10179c130f18, ABISELECT(7296,5184), "S10179C130.s10179c130f18");
    check_field_offset(lv, s10179c130f19, ABISELECT(7304,5188), "S10179C130.s10179c130f19");
    check_field_offset(lv, s10179c130f20, ABISELECT(7344,5216), "S10179C130.s10179c130f20");
    check_field_offset(lv, s10179c130f21, ABISELECT(9776,6920), "S10179C130.s10179c130f21");
    check_field_offset(lv, s10179c130f22, ABISELECT(11192,7896), "S10179C130.s10179c130f22");
    check_field_offset(lv, s10179c130f23, ABISELECT(11216,7912), "S10179C130.s10179c130f23");
    check_field_offset(lv, s10179c130f24, ABISELECT(11448,8076), "S10179C130.s10179c130f24");
    check_field_offset(lv, s10179c130f25, ABISELECT(11752,8300), "S10179C130.s10179c130f25");
    check_field_offset(lv, s10179c130f26, ABISELECT(11984,8464), "S10179C130.s10179c130f26");
    check_field_offset(lv, s10179c130f27, ABISELECT(12216,8628), "S10179C130.s10179c130f27");
    check_field_offset(lv, s10179c130f28, ABISELECT(12224,8632), "S10179C130.s10179c130f28");
    check_field_offset(lv, s10179c130f29, ABISELECT(12248,8648), "S10179C130.s10179c130f29");
    check_field_offset(lv, s10179c130f30, ABISELECT(12256,8652), "S10179C130.s10179c130f30");
    check_field_offset(lv, s10179c130f31, ABISELECT(12544,8876), "S10179C130.s10179c130f31");
    check_field_offset(lv, s10179c130f32, ABISELECT(12560,8884), "S10179C130.s10179c130f32");
    test_class_info(&lv, &cd_S10179C130);
    dp->~S10179C130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C130(Test_S10179C130, "S10179C130", ABISELECT(12568,8888));

#else // __cplusplus

extern void _ZN10S10179C130C1Ev();
extern void _ZN10S10179C130D1Ev();
Name_Map name_map_S10179C130[] = {
  NSPAIR(_ZN10S10179C130C1Ev),
  NSPAIR(_ZN10S10179C130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10179C11;
extern VTBL_ENTRY _ZTI9S10179C11[];
extern  VTBL_ENTRY _ZTV9S10179C11[];
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
static Base_Class bases_S10179C130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C11,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C2,    ABISELECT(144,96), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C130[];
extern void _ZN10S10179C130D1Ev();
extern void _ZN10S10179C130D0Ev();
extern void _ZN10S10179C1304v238Ev();
extern void _ZN10S10179C1304v239Ev();
extern void _ZN10S10179C1304v240Ev();
extern void _ZN10S10179C1304v241Ev();
extern void _ZN10S10179C1304v242Ev();
extern void _ZN10S10179C1304v243Ev();
extern void _ZN10S10179C1304v244Ev();
extern void _ZN10S10179C1304v245Ev();
extern void ABISELECT(_ZThn48_N10S10179C130D1Ev,_ZThn32_N10S10179C130D1Ev)();
extern void ABISELECT(_ZThn48_N10S10179C130D0Ev,_ZThn32_N10S10179C130D0Ev)();
extern void _ZN9S10179C113v15Ev();
extern void _ZN9S10179C113v16Ev();
extern void _ZN9S10179C113v17Ev();
extern void _ZN9S10179C113v18Ev();
extern void _ZN9S10179C113v19Ev();
extern void _ZN9S10179C113v20Ev();
extern void _ZN9S10179C113v21Ev();
extern void _ZN9S10179C113v22Ev();
extern void _ZN9S10179C113v23Ev();
extern void _ZN9S10179C113v24Ev();
extern void _ZN9S10179C113v25Ev();
extern void _ZN9S10179C113v26Ev();
extern void _ZN9S10179C113v27Ev();
extern void _ZN9S10179C113v28Ev();
extern void _ZN9S10179C113v29Ev();
extern void _ZN9S10179C113v30Ev();
extern void _ZN9S10179C113v31Ev();
extern void _ZN9S10179C113v32Ev();
extern void _ZN9S10179C113v33Ev();
extern void _ZN9S10179C113v34Ev();
extern void _ZN9S10179C113v35Ev();
extern void _ZN9S10179C113v36Ev();
extern void _ZN9S10179C113v37Ev();
extern void _ZN9S10179C113v38Ev();
extern void ABISELECT(_ZThn144_N10S10179C130D1Ev,_ZThn96_N10S10179C130D1Ev)();
extern void ABISELECT(_ZThn144_N10S10179C130D0Ev,_ZThn96_N10S10179C130D0Ev)();
extern void _ZN8S10179C22v7Ev();
static  VTBL_ENTRY vtc_S10179C130[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C130[0]),
  (VTBL_ENTRY)&_ZN10S10179C130D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C130D0Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v238Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v239Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v240Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v241Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v242Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v243Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v244Ev,
  (VTBL_ENTRY)&_ZN10S10179C1304v245Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI10S10179C130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10179C130D1Ev,_ZThn32_N10S10179C130D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N10S10179C130D0Ev,_ZThn32_N10S10179C130D0Ev),
  (VTBL_ENTRY)&_ZN9S10179C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10179C113v38Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI10S10179C130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10179C130D1Ev,_ZThn96_N10S10179C130D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N10S10179C130D0Ev,_ZThn96_N10S10179C130D0Ev),
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
};
extern VTBL_ENTRY _ZTI10S10179C130[];
extern  VTBL_ENTRY _ZTV10S10179C130[];
Class_Descriptor cd_S10179C130 = {  "S10179C130", // class name
  bases_S10179C130, 3,
  &(vtc_S10179C130[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(12568,8888), // object size
  NSPAIRA(_ZTI10S10179C130),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV10S10179C130),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C129  : S10179C2 , S10180C17 {
  void *s10179c129f0[6];
  ::S10179C130 s10179c129f1;
  ::S10179C79 s10179c129f2;
  ::S10180C166 s10179c129f3;
  ::S10180C174 s10179c129f4;
  ::S10180C175 s10179c129f5;
  ::S10179C87 s10179c129f6;
  void *s10179c129f7;
  int s10179c129f8;
  void *s10179c129f9;
  int s10179c129f10;
  virtual  ~S10179C129(); // _ZN10S10179C129D1Ev
  virtual void  v237(); // _ZN10S10179C1294v237Ev
  S10179C129(); // tgen
};
//SIG(-1 S10179C129) C1{ BC2{ vd v2} BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v1 Fp[6] FC7{ BC3 BC8{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp FC9{ m FC10{ m Fp Fi FC5} Fi} FC11{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC2 vd v3 v4 v5 v6 v7 v8 v9 v10 FC12{ m FC13{ m Fp Fi[2] FC6} Fp[2]} Fp FC14{ BC15{ BC3 vd v37 v38 v39 v40 FC16{ m Fp FC9 FC10 FC10 Fi[3] FC17{ m FC18{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC9 FC9 Fc} Fp Fc Fi} v35 v36} FC19{ BC20{ BC3 BC21{ vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fp FC9 FC11} vd v70 v71 v72 v73 v74 v75} BC22{ vd v76} vd v41 v42 v43 v44 v45 FC23{ m Fi Fp Fi FC17} FC13} FC24{ m Fp} FC25{ vd v77 v78 FC26{ m Fp Fi[2] FC27{ m}} FC28{ m Fi[4]}[3] Fp[2] Fi Fc} FC29{ BC22 vd v79 Fp[2] FC30{ m Fp Fi FC27 FC31{ m}} FC32{ BC3 vd v80 v81 v82 v83 FC33{ m Fp[2] FC10 FC26 Fi[2]}}} FC34{ BC3 vd v84 Fp FC9 FC9 Fp Fi FC17} FC35{ BC36{ BC37{ BC3 vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 Fp[2] FC24 Fc[2] Fp FC38{ m FC17 FC17 FC39{ m FC40{ m FL}} FC39 FC17 FC17} FC9 Fp[4] FC12} vd v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 FC41{ vd m Fi[2] FC10 FC10 FC10 FC10 FC42{ m Fp[2]} FL[2]} Fp} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[3]} FC43{ BC44{ BC3 vd v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 Fp[2] FC45{ m Fp} Fc[2] Fp FC38 FC9 Fp[4] FC12} vd v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 FC41 Fp} FC46{ BC36 vd v172 v173} FC47{ BC36 vd v174 v175} FC48{ BC37 vd v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 Fi[2] FL Fi}[9] FC49{ BC36 vd v188 v189 v190} FC50{ BC51{ BC44 vd v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 FC41 Fp} vd v191 v192 v193} FC52{ BC51 vd v213 v214} FC53{ BC3 BC22 BC21 vd v215 v216 v217 v218 Fp FC29 FC34 FC54{ BC15 v219 v220} FC55{ BC15 v221} Fp FL FC10} Fp Fi FC56{ m Fl Fc FL[2] FC57{ m Fp}} FC58{ BC3 BC8 BC2 vd v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 Fi[2] FC55 FC12 FC59{ BC15 v245 v246 v247 Fp[3]} FC60{ BC61{ BC3 vd v249 v250 v251 v252 FC16 Fp Fc Fi} v248} FC62{ BC61 v253 v254} FC14 FC63{ BC3 vd v255 v256 FC64{ BC65{ BC66{ m Fp FC17 FC17 Fi[3] Fc[2] Fi Fp} FC45 FC24 FC45 FC10 FC10 FC45 FC24 FC45 FC10 FC10 FC10 Fc Fi Fp} FC10} Fi} FC67{ BC15 v257} FC68{ BC67 v258} FC69{ BC15 v259} Fp FC45 Fp[2] Fi Fc[3] Fi FL[2]} FC70{ BC3 BC21 BC22 vd v260 v261 v262 v263 v264 v265 Fi FC69 FC12 FC59 FC67 FC14 FC54 FC24 Fp[2] Fi} FC71{ m FC72{ BC73{ m Fp Fi FC74{ m} FC74}} Fi} FC62 FC75{ BC15 v266 v267 v268 FC76{ Fp[3]} FC77{ Fi[4]}[3]} FC67 FC14 Fp FC78{ m Fp Fi[2] FC31} Fi FC79{ m FC12 FC80{ Fi FC81{ Fi[2] FL Fc}[9] Fi} FC10} Fp[2] Fi} FC82{ BC3 BC8 BC2 BC83{ BC84{ vd v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317} BC85{ vd m Fp}} BC86{ vd v318 v319} BC87{ vd v320} vd v269 v270 v271 v272 v273 v274 v275 v276 v277 v278 v279 v280 v281 v282 v283 v284 v285 v286 v287 v288 v289 v290 v291 v292 v293 v294 v295 v296 v297 v298 v299 v300 v301 v302 Fp[5] Fi Fp FC88{ m Fi[2]} FC24 FC55 FC14 FC69 FC62 FC75 FC89{ BC3 BC8 vd v321 v322 v323 v324 v325 v326 v327 v328 FC90{ m FC10 Fi[2] FC10} Fi[2] Fc[2] Fi FL[2] FC91{ m Fl} Fi} FC19 FC92{ BC3 BC21 vd v329 v330 v331 v332 FC12 Fp[2] FC10 Fi} FC93{ BC3 BC21 BC22 BC94{ BC95{ vd v352 v353 v354 v355 v356 v357 v358 v359 v360 v361 v362 v363 v364 v365 v366} BC85} BC96{ vd v367 v368} BC97{ vd v369} vd v333 v334 v335 v336 v337 v338 v339 v340 v341 v342 v343 v344 v345 v346 v347 v348 v349 v350 v351 FC12 Fp[2] Fi[2] FC34 FC54 FC14 FC14 FC17 FC17 FC17 Fi} FC98{ BC99{ BC3 BC21 BC22 vd v376 v377 v378 v379 v380 v381 v382 v383 v384 v385 v386 v387 v388 v389 v390 v391 v392 v393 v394 v395 v396 v397 v398 Fi[2] FC69 FC12 FC59 FC67 FC14 FC54 FC63 FC55 FC68 FC55 Fp FC24 Fp[2] Fi Fc[3] Fi FL[2]} vd v370 v371 v372 v373 v374 v375 FC100{ m Fp} FC101{ m Fp FC24 Fp[5] FC102{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC103{ m FC104{ m Fi[2]} FC104} FC104 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC12 Fc[2] Fi FC105{ m Fc[5]} FC106{ m FC17 FC17 FC17 FC45 Fi Fc[2] Fi} FC17 FC17 FC17 Fp FC107{ BC3 vd FC108{ m Fp[3] FC88 FC10 FL[2] Fc} FC12} Fc[2] FL Fc[2] Fi FC45 FC71 Fc Fi} FC109{ BC3 BC21 BC22 BC94 vd v399 v400 v401 v402 v403 v404 v405 v406 Fp[2] FC45 Fi[2] FC110{ BC111{ BC3 vd v412 v413 v414 v415 v416 Fp FC45 Fp[4] Fi} vd v407 v408 v409 v410 v411 Fp[2] Fi[4] FC45 FC112{ m Fi[2]} FC112 Fc[2] FC45 FC39 Fi} Fp FC113{ BC3 BC21 vd v417 v418 v419 v420 v421 Fp FC114{ m FC78 Fi} Fi Fp Fc} Fc FC12 Fc[2]} FC115{ BC3 vd Fp} FC116{ BC3 BC21 vd v422 v423 v424 v425} FC62 Fp Fi Fp Fi}


 S10179C129 ::~S10179C129(){ note_dtor("S10179C129", this);}
void  S10179C129 ::v237(){vfunc_called(this, "_ZN10S10179C1294v237Ev");}
S10179C129 ::S10179C129(){ note_ctor("S10179C129", this);} // tgen

static void Test_S10179C129()
{
  extern Class_Descriptor cd_S10179C129;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2532,3546)];
    init_test(&cd_S10179C129, buf);
    S10179C129 *dp, &lv = *(dp=new (buf) S10179C129());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(20248,14180), "sizeof(S10179C129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C129)");
    check_base_class_offset(lv, (S10179C2*), 0, "S10179C129");
    check_base_class_offset(lv, (S10180C17*), ABISELECT(8,4), "S10179C129");
    check_field_offset(lv, s10179c129f0, ABISELECT(56,36), "S10179C129.s10179c129f0");
    check_field_offset(lv, s10179c129f1, ABISELECT(104,60), "S10179C129.s10179c129f1");
    check_field_offset(lv, s10179c129f2, ABISELECT(12672,8948), "S10179C129.s10179c129f2");
    check_field_offset(lv, s10179c129f3, ABISELECT(19112,13444), "S10179C129.s10179c129f3");
    check_field_offset(lv, s10179c129f4, ABISELECT(19784,13868), "S10179C129.s10179c129f4");
    check_field_offset(lv, s10179c129f5, ABISELECT(19840,13904), "S10179C129.s10179c129f5");
    check_field_offset(lv, s10179c129f6, ABISELECT(19984,14000), "S10179C129.s10179c129f6");
    check_field_offset(lv, s10179c129f7, ABISELECT(20216,14164), "S10179C129.s10179c129f7");
    check_field_offset(lv, s10179c129f8, ABISELECT(20224,14168), "S10179C129.s10179c129f8");
    check_field_offset(lv, s10179c129f9, ABISELECT(20232,14172), "S10179C129.s10179c129f9");
    check_field_offset(lv, s10179c129f10, ABISELECT(20240,14176), "S10179C129.s10179c129f10");
    test_class_info(&lv, &cd_S10179C129);
    dp->~S10179C129();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C129(Test_S10179C129, "S10179C129", ABISELECT(20248,14180));

#else // __cplusplus

extern void _ZN10S10179C129C1Ev();
extern void _ZN10S10179C129D1Ev();
Name_Map name_map_S10179C129[] = {
  NSPAIR(_ZN10S10179C129C1Ev),
  NSPAIR(_ZN10S10179C129D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10179C129[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10179C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C17,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10179C129[];
extern void _ZN10S10179C129D1Ev();
extern void _ZN10S10179C129D0Ev();
extern void _ZN8S10179C22v7Ev();
extern void _ZN10S10179C1294v237Ev();
extern void ABISELECT(_ZThn8_N10S10179C129D1Ev,_ZThn4_N10S10179C129D1Ev)();
extern void ABISELECT(_ZThn8_N10S10179C129D0Ev,_ZThn4_N10S10179C129D0Ev)();
static  VTBL_ENTRY vtc_S10179C129[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10179C129[0]),
  (VTBL_ENTRY)&_ZN10S10179C129D1Ev,
  (VTBL_ENTRY)&_ZN10S10179C129D0Ev,
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
  (VTBL_ENTRY)&_ZN10S10179C1294v237Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI10S10179C129[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S10179C129D1Ev,_ZThn4_N10S10179C129D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N10S10179C129D0Ev,_ZThn4_N10S10179C129D0Ev),
};
extern VTBL_ENTRY _ZTI10S10179C129[];
extern  VTBL_ENTRY _ZTV10S10179C129[];
Class_Descriptor cd_S10179C129 = {  "S10179C129", // class name
  bases_S10179C129, 2,
  &(vtc_S10179C129[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(20248,14180), // object size
  NSPAIRA(_ZTI10S10179C129),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV10S10179C129),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10179C1  : S10179C2 , S10179C3 {
  ::S10180C4 s10179c1f0;
  ::S10180C9 s10179c1f1;
  void *s10179c1f2[3];
  ::S10180C10 s10179c1f3;
  ::S10179C16 s10179c1f4;
  ::S10179C129 s10179c1f5;
  ::S10179C87 s10179c1f6;
  ::S10179C87 s10179c1f7;
  ::S10180C176 s10179c1f8;
  ::S10180C13 s10179c1f9;
  ::S10180C178 s10179c1f10;
  int s10179c1f11;
  ::S10180C31 s10179c1f12;
  int s10179c1f13;
  ::S10180C179 s10179c1f14;
  ::S10180C179 s10179c1f15;
  ::S10180C179 s10179c1f16;
  virtual  ~S10179C1(); // _ZN8S10179C1D1Ev
  virtual void  v1(); // _ZN8S10179C12v1Ev
  virtual void  v2(); // _ZN8S10179C12v2Ev
  virtual void  v3(); // _ZN8S10179C12v3Ev
  virtual void  v4(); // _ZN8S10179C12v4Ev
  virtual void  v5(); // _ZN8S10179C12v5Ev
  virtual void  v6(); // _ZN8S10179C12v6Ev
  S10179C1(); // tgen
};
//SIG(1 S10179C1) C1{ BC2{ vd v7} BC3{ vd v8 v9 v10 v11 v12 Fp} vd v1 v2 v3 v4 v5 v6 FC4{ m Fp FC5{ BC6{ m Fp Fi FC7{ m} FC7}}} FC8{ m Fi Fp Fi[4] Fp} Fp[3] FC9{ BC10{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} FC14{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v13 v14 FC11 Fp} FC15{ BC2 BC16{ vd m FC17{ m Fp Fi FC13 FC18{ m}} FC17 Fc} BC19{ vd v41} vd v39 v40 Fp[5] FC20{ BC16 BC2 BC21{ vd v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fp FC11 FC14} BC22{ vd v88} BC23{ vd v89 v90} vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 Fi FC24{ m Fi[2]} FC24 FC24 FC25{ BC16 vd Fi Fp FC11 FL FC26{ m Fi[2]} Fi Fc Fi FC27{ m FC28{ m Fp Fi[2] FC18} Fp[2]}} FC29{ BC10 vd v91 v92 v93} FC30{ vd m Fi Fp[3] FC31{ m Fc[2] Fp[3] Fi[4] FC32{ m FC33{ Fl[4]}}}} FC34{ vd m FC32 Fi[2] FC35{ m FL[3] Fi[3] FL} FL FC36{ m Fi FC37{ m Fi[4]}} FC27 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC38{ BC16 BC19 vd v94 Fi FC39{ m Fc[2]} FC40{ Fp[2]} Fp FC41{ vd m FC42{ vd m FC43{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC44{ BC45{ vd v101 v102 v103 v104 v105 v106 Fi Fp Fc} vd v95 v96 v97 v98 v99 v100 Fp} FC46{ BC47{ vd v108 Fi Fc[3]} vd v107 Fp[4] FL Fi FC32 FC48{ m Fp FC49{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC50{ BC47 vd v109 FC32 Fi Fp[2] FC51{ m FC32 FC48 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC52{ BC47 vd v110 Fp[2] FL Fi[4] FC53{ m Fi[2]} FC32 FC54{ m FC32 FC48 Fp Fi[4]} FC55{ m Fp}} FC32 FC32 FL Fi[5]} FL FC56{ m FC35 FC57{ m Fi} Fi} Fc[128] FC24 FC27} Fi[3] FC58{ m Fp Fi[2]} FC59{ m Fc[11] Fi[2]} FC60{ BC61{} FL Fi} FC62{ BC63{ BC16 vd v113 v114 v115 v116 FC64{ m Fp FC11 FC12 FC12 Fi[3] FC65{ m FC66{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC11 FC11 Fc} Fp Fc Fi} v111 v112} FL FC67{ BC63 v117} FC68{ BC63 v118} FC69{ BC63 v119 v120} FC27 Fc} FC70{ BC71{ BC16 BC21 BC2 BC72{ BC73{ vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137} BC74{ vd m Fp}} BC75{ vd v138 v139} BC22 vd v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 Fp[5] Fi Fp FC76{ m Fi[2]} FC77{ m Fp} FC78{ BC63 v174} FC62 FC68 FC79{ BC80{ BC16 vd v177 v178 v179 v180 FC64 Fp Fc Fi} v175 v176} FC81{ BC63 v181 v182 v183 FC82{ Fp[3]} FC49[3]} FC83{ BC16 BC21 vd v184 v185 v186 v187 v188 v189 v190 v191 FC84{ m FC12 Fi[2] FC12} Fi[2] Fc[2] Fi FL[2] FC85{ m Fl} Fi} FC86{ BC87{ BC16 BC10 vd v197 v198 v199 v200 v201 v202} BC88{ vd v203} vd v192 v193 v194 v195 v196 FC89{ m Fi Fp Fi FC65} FC28} FC90{ BC16 BC10 vd v204 v205 v206 v207 FC27 Fp[2] FC12 Fi} FC91{ BC16 BC10 BC88 BC92{ BC93{ vd v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241} BC74} BC94{ vd v242 v243} BC95{ vd v244} vd v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 FC27 Fp[2] Fi[2] FC96{ BC16 vd v245 Fp FC11 FC11 Fp Fi FC65} FC69 FC62 FC62 FC65 FC65 FC65 Fi} FC97{ BC98{ BC16 BC10 BC88 vd v252 v253 v254 v255 v256 v257 v258 v259 v260 v261 v262 v263 v264 v265 v266 v267 v268 v269 v270 v271 v272 v273 v274 Fi[2] FC68 FC27 FC99{ BC63 v275 v276 v277 Fp[3]} FC67 FC62 FC69 FC100{ BC16 vd v278 v279 FC101{ BC102{ BC103{ m Fp FC65 FC65 Fi[3] Fc[2] Fi Fp} FC104{ m Fp} FC77 FC104 FC12 FC12 FC104 FC77 FC104 FC12 FC12 FC12 Fc Fi Fp} FC12} Fi} FC78 FC105{ BC67 v280} FC78 Fp FC77 Fp[2] Fi Fc[3] Fi FL[2]} vd v246 v247 v248 v249 v250 v251 FC55 FC106{ m Fp FC77 Fp[5] FC107{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC108{ m FC53 FC53} FC53 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC27 Fc[2] Fi FC109{ m Fc[5]} FC110{ m FC65 FC65 FC65 FC104 Fi Fc[2] Fi} FC65 FC65 FC65 Fp FC111{ BC16 vd FC112{ m Fp[3] FC76 FC12 FL[2] Fc} FC27} Fc[2] FL Fc[2] Fi FC104 FC113{ m FC5 Fi} Fc Fi} vd v121 v122 Fc} FC79 FC79 Fp Fc Fp Fi} FC114{ BC2 BC16 vd v281 Fp[6] FC115{ BC16 BC21 BC2 vd v282 v283 v284 v285 v286 v287 v288 v289 FC27 Fp FC62 FC86 FC77 FC116{ vd v290 v291 FC117{ m Fp Fi[2] FC118{ m}} FC37[3] Fp[2] Fi Fc} FC119{ BC88 vd v292 Fp[2] FC120{ m Fp Fi FC118 FC121{ m}} FC122{ BC16 vd v293 v294 v295 v296 FC123{ m Fp[2] FC12 FC117 Fi[2]}}} FC96 FC124{ BC125{ BC126{ BC16 vd v306 v307 v308 v309 v310 v311 v312 v313 v314 v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 Fp[2] FC77 Fc[2] Fp FC127{ m FC65 FC65 FC128{ m FC129{ m FL}} FC128 FC65 FC65} FC11 Fp[4] FC27} vd v326 v327 v328 v329 v330 v331 v332 v333 v334 v335 v336 v337 v338 v339 v340 v341 v342 v343 v344 FC130{ vd m Fi[2] FC12 FC12 FC12 FC12 FC131{ m Fp[2]} FL[2]} Fp} vd v297 v298 v299 v300 v301 v302 v303 v304 v305 Fi[3]} FC132{ BC133{ BC16 vd v364 v365 v366 v367 v368 v369 v370 v371 v372 v373 v374 v375 v376 v377 v378 v379 v380 v381 v382 v383 Fp[2] FC104 Fc[2] Fp FC127 FC11 Fp[4] FC27} vd v345 v346 v347 v348 v349 v350 v351 v352 v353 v354 v355 v356 v357 v358 v359 v360 v361 v362 v363 FC130 Fp} FC134{ BC125 vd v384 v385} FC135{ BC125 vd v386 v387} FC136{ BC126 vd v388 v389 v390 v391 v392 v393 v394 v395 v396 v397 v398 v399 Fi[2] FL Fi}[9] FC137{ BC125 vd v400 v401 v402} FC138{ BC139{ BC133 vd v406 v407 v408 v409 v410 v411 v412 v413 v414 v415 v416 v417 v418 v419 v420 v421 v422 v423 v424 FC130 Fp} vd v403 v404 v405} FC140{ BC139 vd v425 v426} FC141{ BC16 BC88 BC10 vd v427 v428 v429 v430 Fp FC119 FC96 FC69 FC78 Fp FL FC12} Fp Fi FC142{ m Fl Fc FL[2] FC143{ m Fp}} FC144{ BC16 BC21 BC2 vd v431 v432 v433 v434 v435 v436 v437 v438 v439 v440 v441 v442 v443 v444 v445 v446 v447 v448 v449 v450 v451 v452 v453 Fi[2] FC78 FC27 FC99 FC145{ BC80 v454} FC79 FC62 FC100 FC67 FC105 FC68 Fp FC104 Fp[2] Fi Fc[3] Fi FL[2]} FC146{ BC16 BC10 BC88 vd v455 v456 v457 v458 v459 v460 Fi FC68 FC27 FC99 FC67 FC62 FC69 FC77 Fp[2] Fi} FC113 FC79 FC81 FC67 FC62 Fp FC147{ m Fp Fi[2] FC121} Fi FC148{ m FC27 FC149{ Fi FC150{ Fi[2] FL Fc}[9] Fi} FC12} Fp[2] Fi} FC71 FC151{ BC16 BC10 BC88 BC92 vd v461 v462 v463 v464 v465 v466 v467 v468 Fp[2] FC104 Fi[2] FC152{ BC153{ BC16 vd v474 v475 v476 v477 v478 Fp FC104 Fp[4] Fi} vd v469 v470 v471 v472 v473 Fp[2] Fi[4] FC104 FC24 FC24 Fc[2] FC104 FC128 Fi} Fp FC154{ BC16 BC10 vd v479 v480 v481 v482 v483 Fp FC155{ m FC147 Fi} Fi Fp Fc} Fc FC27 Fc[2]} FC156{ BC16 vd Fp} FC157{ BC16 BC10 vd v484 v485 v486 v487} FC79 Fp Fi Fp Fi} FC79 FC79 FC158{ BC159{ vd v496 v497 v498 v499 v500 v501 v502 v503} vd v488 v489 v490 v491 v492 v493 v494 v495 Fp[2]} FC12 FC160{ vd m Fi} Fi FC27 Fi FC161{ m Fp Fi} FC161 FC161}


 S10179C1 ::~S10179C1(){ note_dtor("S10179C1", this);}
void  S10179C1 ::v1(){vfunc_called(this, "_ZN8S10179C12v1Ev");}
void  S10179C1 ::v2(){vfunc_called(this, "_ZN8S10179C12v2Ev");}
void  S10179C1 ::v3(){vfunc_called(this, "_ZN8S10179C12v3Ev");}
void  S10179C1 ::v4(){vfunc_called(this, "_ZN8S10179C12v4Ev");}
void  S10179C1 ::v5(){vfunc_called(this, "_ZN8S10179C12v5Ev");}
void  S10179C1 ::v6(){vfunc_called(this, "_ZN8S10179C12v6Ev");}
S10179C1 ::S10179C1(){ note_ctor("S10179C1", this);} // tgen

static void Test_S10179C1()
{
  extern Class_Descriptor cd_S10179C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5557,8765)];
    init_test(&cd_S10179C1, buf);
    S10179C1 *dp, &lv = *(dp=new (buf) S10179C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(44448,35056), "sizeof(S10179C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10179C1)");
    check_base_class_offset(lv, (S10179C2*), 0, "S10179C1");
    check_base_class_offset(lv, (S10179C3*), ABISELECT(8,4), "S10179C1");
    check_field_offset(lv, s10179c1f0, ABISELECT(24,12), "S10179C1.s10179c1f0");
    check_field_offset(lv, s10179c1f1, ABISELECT(48,28), "S10179C1.s10179c1f1");
    check_field_offset(lv, s10179c1f2, ABISELECT(88,56), "S10179C1.s10179c1f2");
    check_field_offset(lv, s10179c1f3, ABISELECT(112,68), "S10179C1.s10179c1f3");
    check_field_offset(lv, s10179c1f4, ABISELECT(240,152), "S10179C1.s10179c1f4");
    check_field_offset(lv, s10179c1f5, ABISELECT(23576,20460), "S10179C1.s10179c1f5");
    check_field_offset(lv, s10179c1f6, ABISELECT(43824,34640), "S10179C1.s10179c1f6");
    check_field_offset(lv, s10179c1f7, ABISELECT(44056,34804), "S10179C1.s10179c1f7");
    check_field_offset(lv, s10179c1f8, ABISELECT(44288,34968), "S10179C1.s10179c1f8");
    check_field_offset(lv, s10179c1f9, ABISELECT(44312,34980), "S10179C1.s10179c1f9");
    check_field_offset(lv, s10179c1f10, ABISELECT(44328,34992), "S10179C1.s10179c1f10");
    check_field_offset(lv, s10179c1f11, ABISELECT(44344,35000), "S10179C1.s10179c1f11");
    check_field_offset(lv, s10179c1f12, ABISELECT(44352,35004), "S10179C1.s10179c1f12");
    check_field_offset(lv, s10179c1f13, ABISELECT(44392,35028), "S10179C1.s10179c1f13");
    check_field_offset(lv, s10179c1f14, ABISELECT(44400,35032), "S10179C1.s10179c1f14");
    check_field_offset(lv, s10179c1f15, ABISELECT(44416,35040), "S10179C1.s10179c1f15");
    check_field_offset(lv, s10179c1f16, ABISELECT(44432,35048), "S10179C1.s10179c1f16");
    test_class_info(&lv, &cd_S10179C1);
    dp->~S10179C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10179C1(Test_S10179C1, "S10179C1", ABISELECT(44448,35056));

#else // __cplusplus

extern void _ZN8S10179C1C1Ev();
extern void _ZN8S10179C1D1Ev();
Name_Map name_map_S10179C1[] = {
  NSPAIR(_ZN8S10179C1C1Ev),
  NSPAIR(_ZN8S10179C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10179C2;
extern VTBL_ENTRY _ZTI8S10179C2[];
extern  VTBL_ENTRY _ZTV8S10179C2[];
extern Class_Descriptor cd_S10179C3;
extern VTBL_ENTRY _ZTI8S10179C3[];
extern  VTBL_ENTRY _ZTV8S10179C3[];
static Base_Class bases_S10179C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10179C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10179C3,    ABISELECT(8,4), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10179C1[];
extern void _ZN8S10179C1D1Ev();
extern void _ZN8S10179C1D0Ev();
extern void _ZN8S10179C22v7Ev();
extern void _ZN8S10179C12v1Ev();
extern void _ZN8S10179C12v2Ev();
extern void _ZN8S10179C12v3Ev();
extern void _ZN8S10179C12v4Ev();
extern void _ZN8S10179C12v5Ev();
extern void _ZN8S10179C12v6Ev();
extern void ABISELECT(_ZThn8_N8S10179C1D1Ev,_ZThn4_N8S10179C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10179C1D0Ev,_ZThn4_N8S10179C1D0Ev)();
extern void _ZN8S10179C32v8Ev();
extern void _ZN8S10179C32v9Ev();
extern void _ZN8S10179C33v10Ev();
extern void _ZN8S10179C33v11Ev();
extern void _ZN8S10179C33v12Ev();
static  VTBL_ENTRY vtc_S10179C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10179C1[0]),
  (VTBL_ENTRY)&_ZN8S10179C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10179C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10179C22v7Ev,
  (VTBL_ENTRY)&_ZN8S10179C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10179C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10179C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10179C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10179C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10179C12v6Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10179C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10179C1D1Ev,_ZThn4_N8S10179C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10179C1D0Ev,_ZThn4_N8S10179C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10179C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10179C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10179C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10179C33v11Ev,
  (VTBL_ENTRY)&_ZN8S10179C33v12Ev,
};
extern VTBL_ENTRY _ZTI8S10179C1[];
extern  VTBL_ENTRY _ZTV8S10179C1[];
Class_Descriptor cd_S10179C1 = {  "S10179C1", // class name
  bases_S10179C1, 2,
  &(vtc_S10179C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(44448,35056), // object size
  NSPAIRA(_ZTI8S10179C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10179C1),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C2  {
  virtual  ~S10181C2(); // _ZN8S10181C2D1Ev
  virtual void  v7(); // _ZN8S10181C22v7Ev
  S10181C2(); // tgen
};
//SIG(-1 S10181C2) C1{ vd v1}


 S10181C2 ::~S10181C2(){ note_dtor("S10181C2", this);}
void  S10181C2 ::v7(){vfunc_called(this, "_ZN8S10181C22v7Ev");}
S10181C2 ::S10181C2(){ note_ctor("S10181C2", this);} // tgen

static void Test_S10181C2()
{
  extern Class_Descriptor cd_S10181C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10181C2, buf);
    S10181C2 *dp, &lv = *(dp=new (buf) S10181C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10181C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C2)");
    test_class_info(&lv, &cd_S10181C2);
    dp->~S10181C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C2(Test_S10181C2, "S10181C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10181C2C1Ev();
extern void _ZN8S10181C2D1Ev();
Name_Map name_map_S10181C2[] = {
  NSPAIR(_ZN8S10181C2C1Ev),
  NSPAIR(_ZN8S10181C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10181C2[];
extern void _ZN8S10181C2D1Ev();
extern void _ZN8S10181C2D0Ev();
extern void _ZN8S10181C22v7Ev();
static  VTBL_ENTRY vtc_S10181C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10181C2[0]),
  (VTBL_ENTRY)&_ZN8S10181C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10181C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10181C22v7Ev,
};
extern VTBL_ENTRY _ZTI8S10181C2[];
extern  VTBL_ENTRY _ZTV8S10181C2[];
Class_Descriptor cd_S10181C2 = {  "S10181C2", // class name
  0,0,//no base classes
  &(vtc_S10181C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10181C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10181C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C3  {
  void *s10181c3f0;
  virtual  ~S10181C3(); // _ZN8S10181C3D1Ev
  virtual void  v8(); // _ZN8S10181C32v8Ev
  virtual void  v9(); // _ZN8S10181C32v9Ev
  virtual void  v10(); // _ZN8S10181C33v10Ev
  virtual void  v11(); // _ZN8S10181C33v11Ev
  virtual void  v12(); // _ZN8S10181C33v12Ev
  S10181C3(); // tgen
};
//SIG(-1 S10181C3) C1{ vd v1 v2 v3 v4 v5 Fp}


 S10181C3 ::~S10181C3(){ note_dtor("S10181C3", this);}
void  S10181C3 ::v8(){vfunc_called(this, "_ZN8S10181C32v8Ev");}
void  S10181C3 ::v9(){vfunc_called(this, "_ZN8S10181C32v9Ev");}
void  S10181C3 ::v10(){vfunc_called(this, "_ZN8S10181C33v10Ev");}
void  S10181C3 ::v11(){vfunc_called(this, "_ZN8S10181C33v11Ev");}
void  S10181C3 ::v12(){vfunc_called(this, "_ZN8S10181C33v12Ev");}
S10181C3 ::S10181C3(){ note_ctor("S10181C3", this);} // tgen

static void Test_S10181C3()
{
  extern Class_Descriptor cd_S10181C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10181C3, buf);
    S10181C3 *dp, &lv = *(dp=new (buf) S10181C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10181C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C3)");
    check_field_offset(lv, s10181c3f0, ABISELECT(8,4), "S10181C3.s10181c3f0");
    test_class_info(&lv, &cd_S10181C3);
    dp->~S10181C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C3(Test_S10181C3, "S10181C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S10181C3C1Ev();
extern void _ZN8S10181C3D1Ev();
Name_Map name_map_S10181C3[] = {
  NSPAIR(_ZN8S10181C3C1Ev),
  NSPAIR(_ZN8S10181C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10181C3[];
extern void _ZN8S10181C3D1Ev();
extern void _ZN8S10181C3D0Ev();
extern void _ZN8S10181C32v8Ev();
extern void _ZN8S10181C32v9Ev();
extern void _ZN8S10181C33v10Ev();
extern void _ZN8S10181C33v11Ev();
extern void _ZN8S10181C33v12Ev();
static  VTBL_ENTRY vtc_S10181C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10181C3[0]),
  (VTBL_ENTRY)&_ZN8S10181C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10181C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10181C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10181C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10181C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10181C33v11Ev,
  (VTBL_ENTRY)&_ZN8S10181C33v12Ev,
};
extern VTBL_ENTRY _ZTI8S10181C3[];
extern  VTBL_ENTRY _ZTV8S10181C3[];
Class_Descriptor cd_S10181C3 = {  "S10181C3", // class name
  0,0,//no base classes
  &(vtc_S10181C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S10181C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10181C3),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C24  {
  virtual  ~S10181C24(); // _ZN9S10181C24D1Ev
  virtual void  v41(); // _ZN9S10181C243v41Ev
  S10181C24(); // tgen
};
//SIG(-1 S10181C24) C1{ vd v1}


 S10181C24 ::~S10181C24(){ note_dtor("S10181C24", this);}
void  S10181C24 ::v41(){vfunc_called(this, "_ZN9S10181C243v41Ev");}
S10181C24 ::S10181C24(){ note_ctor("S10181C24", this);} // tgen

static void Test_S10181C24()
{
  extern Class_Descriptor cd_S10181C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10181C24, buf);
    S10181C24 *dp, &lv = *(dp=new (buf) S10181C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10181C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C24)");
    test_class_info(&lv, &cd_S10181C24);
    dp->~S10181C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C24(Test_S10181C24, "S10181C24", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10181C24C1Ev();
extern void _ZN9S10181C24D1Ev();
Name_Map name_map_S10181C24[] = {
  NSPAIR(_ZN9S10181C24C1Ev),
  NSPAIR(_ZN9S10181C24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C24[];
extern void _ZN9S10181C24D1Ev();
extern void _ZN9S10181C24D0Ev();
extern void _ZN9S10181C243v41Ev();
static  VTBL_ENTRY vtc_S10181C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C24[0]),
  (VTBL_ENTRY)&_ZN9S10181C24D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C24D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10181C24[];
extern  VTBL_ENTRY _ZTV9S10181C24[];
Class_Descriptor cd_S10181C24 = {  "S10181C24", // class name
  0,0,//no base classes
  &(vtc_S10181C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10181C24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C24),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C11  {
  void *s10181c11f0;
  ::S10180C12 s10181c11f1;
  ::S10180C15 s10181c11f2;
  virtual  ~S10181C11(); // _ZN9S10181C11D1Ev
  virtual void  v15(); // _ZN9S10181C113v15Ev
  virtual void  v16(); // _ZN9S10181C113v16Ev
  virtual void  v17(); // _ZN9S10181C113v17Ev
  virtual void  v18(); // _ZN9S10181C113v18Ev
  virtual void  v19(); // _ZN9S10181C113v19Ev
  virtual void  v20(); // _ZN9S10181C113v20Ev
  virtual void  v21(); // _ZN9S10181C113v21Ev
  virtual void  v22(); // _ZN9S10181C113v22Ev
  virtual void  v23(); // _ZN9S10181C113v23Ev
  virtual void  v24(); // _ZN9S10181C113v24Ev
  virtual void  v25(); // _ZN9S10181C113v25Ev
  virtual void  v26(); // _ZN9S10181C113v26Ev
  virtual void  v27(); // _ZN9S10181C113v27Ev
  virtual void  v28(); // _ZN9S10181C113v28Ev
  virtual void  v29(); // _ZN9S10181C113v29Ev
  virtual void  v30(); // _ZN9S10181C113v30Ev
  virtual void  v31(); // _ZN9S10181C113v31Ev
  virtual void  v32(); // _ZN9S10181C113v32Ev
  virtual void  v33(); // _ZN9S10181C113v33Ev
  virtual void  v34(); // _ZN9S10181C113v34Ev
  virtual void  v35(); // _ZN9S10181C113v35Ev
  virtual void  v36(); // _ZN9S10181C113v36Ev
  virtual void  v37(); // _ZN9S10181C113v37Ev
  virtual void  v38(); // _ZN9S10181C113v38Ev
  S10181C11(); // tgen
};
//SIG(-1 S10181C11) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} FC5{ m Fi[4] Fp Fc Fi[2] Fp[2]}}


 S10181C11 ::~S10181C11(){ note_dtor("S10181C11", this);}
void  S10181C11 ::v15(){vfunc_called(this, "_ZN9S10181C113v15Ev");}
void  S10181C11 ::v16(){vfunc_called(this, "_ZN9S10181C113v16Ev");}
void  S10181C11 ::v17(){vfunc_called(this, "_ZN9S10181C113v17Ev");}
void  S10181C11 ::v18(){vfunc_called(this, "_ZN9S10181C113v18Ev");}
void  S10181C11 ::v19(){vfunc_called(this, "_ZN9S10181C113v19Ev");}
void  S10181C11 ::v20(){vfunc_called(this, "_ZN9S10181C113v20Ev");}
void  S10181C11 ::v21(){vfunc_called(this, "_ZN9S10181C113v21Ev");}
void  S10181C11 ::v22(){vfunc_called(this, "_ZN9S10181C113v22Ev");}
void  S10181C11 ::v23(){vfunc_called(this, "_ZN9S10181C113v23Ev");}
void  S10181C11 ::v24(){vfunc_called(this, "_ZN9S10181C113v24Ev");}
void  S10181C11 ::v25(){vfunc_called(this, "_ZN9S10181C113v25Ev");}
void  S10181C11 ::v26(){vfunc_called(this, "_ZN9S10181C113v26Ev");}
void  S10181C11 ::v27(){vfunc_called(this, "_ZN9S10181C113v27Ev");}
void  S10181C11 ::v28(){vfunc_called(this, "_ZN9S10181C113v28Ev");}
void  S10181C11 ::v29(){vfunc_called(this, "_ZN9S10181C113v29Ev");}
void  S10181C11 ::v30(){vfunc_called(this, "_ZN9S10181C113v30Ev");}
void  S10181C11 ::v31(){vfunc_called(this, "_ZN9S10181C113v31Ev");}
void  S10181C11 ::v32(){vfunc_called(this, "_ZN9S10181C113v32Ev");}
void  S10181C11 ::v33(){vfunc_called(this, "_ZN9S10181C113v33Ev");}
void  S10181C11 ::v34(){vfunc_called(this, "_ZN9S10181C113v34Ev");}
void  S10181C11 ::v35(){vfunc_called(this, "_ZN9S10181C113v35Ev");}
void  S10181C11 ::v36(){vfunc_called(this, "_ZN9S10181C113v36Ev");}
void  S10181C11 ::v37(){vfunc_called(this, "_ZN9S10181C113v37Ev");}
void  S10181C11 ::v38(){vfunc_called(this, "_ZN9S10181C113v38Ev");}
S10181C11 ::S10181C11(){ note_ctor("S10181C11", this);} // tgen

static void Test_S10181C11()
{
  extern Class_Descriptor cd_S10181C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,17)];
    init_test(&cd_S10181C11, buf);
    S10181C11 *dp, &lv = *(dp=new (buf) S10181C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,64), "sizeof(S10181C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C11)");
    check_field_offset(lv, s10181c11f0, ABISELECT(8,4), "S10181C11.s10181c11f0");
    check_field_offset(lv, s10181c11f1, ABISELECT(16,8), "S10181C11.s10181c11f1");
    check_field_offset(lv, s10181c11f2, ABISELECT(40,24), "S10181C11.s10181c11f2");
    test_class_info(&lv, &cd_S10181C11);
    dp->~S10181C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C11(Test_S10181C11, "S10181C11", ABISELECT(96,64));

#else // __cplusplus

extern void _ZN9S10181C11C1Ev();
extern void _ZN9S10181C11D1Ev();
Name_Map name_map_S10181C11[] = {
  NSPAIR(_ZN9S10181C11C1Ev),
  NSPAIR(_ZN9S10181C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C11[];
extern void _ZN9S10181C11D1Ev();
extern void _ZN9S10181C11D0Ev();
extern void _ZN9S10181C113v15Ev();
extern void _ZN9S10181C113v16Ev();
extern void _ZN9S10181C113v17Ev();
extern void _ZN9S10181C113v18Ev();
extern void _ZN9S10181C113v19Ev();
extern void _ZN9S10181C113v20Ev();
extern void _ZN9S10181C113v21Ev();
extern void _ZN9S10181C113v22Ev();
extern void _ZN9S10181C113v23Ev();
extern void _ZN9S10181C113v24Ev();
extern void _ZN9S10181C113v25Ev();
extern void _ZN9S10181C113v26Ev();
extern void _ZN9S10181C113v27Ev();
extern void _ZN9S10181C113v28Ev();
extern void _ZN9S10181C113v29Ev();
extern void _ZN9S10181C113v30Ev();
extern void _ZN9S10181C113v31Ev();
extern void _ZN9S10181C113v32Ev();
extern void _ZN9S10181C113v33Ev();
extern void _ZN9S10181C113v34Ev();
extern void _ZN9S10181C113v35Ev();
extern void _ZN9S10181C113v36Ev();
extern void _ZN9S10181C113v37Ev();
extern void _ZN9S10181C113v38Ev();
static  VTBL_ENTRY vtc_S10181C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C11[0]),
  (VTBL_ENTRY)&_ZN9S10181C11D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C11D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v38Ev,
};
extern VTBL_ENTRY _ZTI9S10181C11[];
extern  VTBL_ENTRY _ZTV9S10181C11[];
Class_Descriptor cd_S10181C11 = {  "S10181C11", // class name
  0,0,//no base classes
  &(vtc_S10181C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,64), // object size
  NSPAIRA(_ZTI9S10181C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C11),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C26  {
  virtual  ~S10181C26(); // _ZN9S10181C26D1Ev
  virtual void  v64(); // _ZN9S10181C263v64Ev
  S10181C26(); // tgen
};
//SIG(-1 S10181C26) C1{ vd v1}


 S10181C26 ::~S10181C26(){ note_dtor("S10181C26", this);}
void  S10181C26 ::v64(){vfunc_called(this, "_ZN9S10181C263v64Ev");}
S10181C26 ::S10181C26(){ note_ctor("S10181C26", this);} // tgen

static void Test_S10181C26()
{
  extern Class_Descriptor cd_S10181C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10181C26, buf);
    S10181C26 *dp, &lv = *(dp=new (buf) S10181C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10181C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C26)");
    test_class_info(&lv, &cd_S10181C26);
    dp->~S10181C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C26(Test_S10181C26, "S10181C26", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10181C26C1Ev();
extern void _ZN9S10181C26D1Ev();
Name_Map name_map_S10181C26[] = {
  NSPAIR(_ZN9S10181C26C1Ev),
  NSPAIR(_ZN9S10181C26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C26[];
extern void _ZN9S10181C26D1Ev();
extern void _ZN9S10181C26D0Ev();
extern void _ZN9S10181C263v64Ev();
static  VTBL_ENTRY vtc_S10181C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C26[0]),
  (VTBL_ENTRY)&_ZN9S10181C26D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C26D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C263v64Ev,
};
extern VTBL_ENTRY _ZTI9S10181C26[];
extern  VTBL_ENTRY _ZTV9S10181C26[];
Class_Descriptor cd_S10181C26 = {  "S10181C26", // class name
  0,0,//no base classes
  &(vtc_S10181C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10181C26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C26),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C27  {
  virtual  ~S10181C27(); // _ZN9S10181C27D1Ev
  virtual void  v65(); // _ZN9S10181C273v65Ev
  virtual void  v66(); // _ZN9S10181C273v66Ev
  S10181C27(); // tgen
};
//SIG(-1 S10181C27) C1{ vd v1 v2}


 S10181C27 ::~S10181C27(){ note_dtor("S10181C27", this);}
void  S10181C27 ::v65(){vfunc_called(this, "_ZN9S10181C273v65Ev");}
void  S10181C27 ::v66(){vfunc_called(this, "_ZN9S10181C273v66Ev");}
S10181C27 ::S10181C27(){ note_ctor("S10181C27", this);} // tgen

static void Test_S10181C27()
{
  extern Class_Descriptor cd_S10181C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10181C27, buf);
    S10181C27 *dp, &lv = *(dp=new (buf) S10181C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10181C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C27)");
    test_class_info(&lv, &cd_S10181C27);
    dp->~S10181C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C27(Test_S10181C27, "S10181C27", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10181C27C1Ev();
extern void _ZN9S10181C27D1Ev();
Name_Map name_map_S10181C27[] = {
  NSPAIR(_ZN9S10181C27C1Ev),
  NSPAIR(_ZN9S10181C27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C27[];
extern void _ZN9S10181C27D1Ev();
extern void _ZN9S10181C27D0Ev();
extern void _ZN9S10181C273v65Ev();
extern void _ZN9S10181C273v66Ev();
static  VTBL_ENTRY vtc_S10181C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C27[0]),
  (VTBL_ENTRY)&_ZN9S10181C27D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C27D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C273v65Ev,
  (VTBL_ENTRY)&_ZN9S10181C273v66Ev,
};
extern VTBL_ENTRY _ZTI9S10181C27[];
extern  VTBL_ENTRY _ZTV9S10181C27[];
Class_Descriptor cd_S10181C27 = {  "S10181C27", // class name
  0,0,//no base classes
  &(vtc_S10181C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10181C27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C27),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C37  {
  __tsi64 s10181c37f0[4];
  void  mf10181c37(); // _ZN9S10181C3710mf10181c37Ev
};
//SIG(-1 S10181C37) C1{ m FL[4]}


void  S10181C37 ::mf10181c37(){}

static void Test_S10181C37()
{
  {
    init_simple_test("S10181C37");
    S10181C37 lv;
    check2(sizeof(lv), 32, "sizeof(S10181C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C37)");
    check_field_offset(lv, s10181c37f0, 0, "S10181C37.s10181c37f0");
  }
}
static Arrange_To_Call_Me vS10181C37(Test_S10181C37, "S10181C37", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C36  {
  char s10181c36f0[2];
  void *s10181c36f1[3];
  int s10181c36f2[4];
  ::S10181C37 s10181c36f3;
  void  mf10181c36(); // _ZN9S10181C3610mf10181c36Ev
};
//SIG(-1 S10181C36) C1{ m Fc[2] Fp[3] Fi[4] FC2{ m FL[4]}}


void  S10181C36 ::mf10181c36(){}

static void Test_S10181C36()
{
  {
    init_simple_test("S10181C36");
    S10181C36 lv;
    check2(sizeof(lv), ABISELECT(80,64), "sizeof(S10181C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C36)");
    check_field_offset(lv, s10181c36f0, 0, "S10181C36.s10181c36f0");
    check_field_offset(lv, s10181c36f1, ABISELECT(8,4), "S10181C36.s10181c36f1");
    check_field_offset(lv, s10181c36f2, ABISELECT(32,16), "S10181C36.s10181c36f2");
    check_field_offset(lv, s10181c36f3, ABISELECT(48,32), "S10181C36.s10181c36f3");
  }
}
static Arrange_To_Call_Me vS10181C36(Test_S10181C36, "S10181C36", ABISELECT(80,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C35  {
  int s10181c35f0;
  void *s10181c35f1[3];
  ::S10181C36 s10181c35f2;
  void  mf10181c35(); // _ZN9S10181C3510mf10181c35Ev
  virtual  ~S10181C35(); // _ZN9S10181C35D1Ev
  S10181C35(); // tgen
};
//SIG(-1 S10181C35) C1{ vd m Fi Fp[3] FC2{ m Fc[2] Fp[3] Fi[4] FC3{ m FL[4]}}}


void  S10181C35 ::mf10181c35(){}
 S10181C35 ::~S10181C35(){ note_dtor("S10181C35", this);}
S10181C35 ::S10181C35(){ note_ctor("S10181C35", this);} // tgen

static void Test_S10181C35()
{
  extern Class_Descriptor cd_S10181C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,22)];
    init_test(&cd_S10181C35, buf);
    S10181C35 *dp, &lv = *(dp=new (buf) S10181C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,84), "sizeof(S10181C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C35)");
    check_field_offset(lv, s10181c35f0, ABISELECT(8,4), "S10181C35.s10181c35f0");
    check_field_offset(lv, s10181c35f1, ABISELECT(16,8), "S10181C35.s10181c35f1");
    check_field_offset(lv, s10181c35f2, ABISELECT(40,20), "S10181C35.s10181c35f2");
    test_class_info(&lv, &cd_S10181C35);
    dp->~S10181C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C35(Test_S10181C35, "S10181C35", ABISELECT(120,84));

#else // __cplusplus

extern void _ZN9S10181C35C1Ev();
extern void _ZN9S10181C35D1Ev();
Name_Map name_map_S10181C35[] = {
  NSPAIR(_ZN9S10181C35C1Ev),
  NSPAIR(_ZN9S10181C35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C35[];
extern void _ZN9S10181C35D1Ev();
extern void _ZN9S10181C35D0Ev();
static  VTBL_ENTRY vtc_S10181C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C35[0]),
  (VTBL_ENTRY)&_ZN9S10181C35D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C35D0Ev,
};
extern VTBL_ENTRY _ZTI9S10181C35[];
extern  VTBL_ENTRY _ZTV9S10181C35[];
Class_Descriptor cd_S10181C35 = {  "S10181C35", // class name
  0,0,//no base classes
  &(vtc_S10181C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,84), // object size
  NSPAIRA(_ZTI9S10181C35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C35),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C38  {
  ::S10181C37 s10181c38f0;
  int s10181c38f1[2];
  ::S10180C41 s10181c38f2;
  __tsi64 s10181c38f3;
  ::S10180C42 s10181c38f4;
  ::S10180C31 s10181c38f5;
  char s10181c38f6[2];
  int s10181c38f7[2];
  void *s10181c38f8[2];
  __tsi64 s10181c38f9;
  int s10181c38f10[3];
  void  mf10181c38(); // _ZN9S10181C3810mf10181c38Ev
  virtual  ~S10181C38(); // _ZN9S10181C38D1Ev
  S10181C38(); // tgen
};
//SIG(-1 S10181C38) C1{ vd m FC2{ m FL[4]} Fi[2] FC3{ m FL[3] Fi[3] FL} FL FC4{ m Fi FC5{ m Fi[4]}} FC6{ m FC7{ m Fp Fi[2] FC8{ m}} Fp[2]} Fc[2] Fi[2] Fp[2] FL Fi[3]}


void  S10181C38 ::mf10181c38(){}
 S10181C38 ::~S10181C38(){ note_dtor("S10181C38", this);}
S10181C38 ::S10181C38(){ note_ctor("S10181C38", this);} // tgen

static void Test_S10181C38()
{
  extern Class_Descriptor cd_S10181C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,46)];
    init_test(&cd_S10181C38, buf);
    S10181C38 *dp, &lv = *(dp=new (buf) S10181C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,180), "sizeof(S10181C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C38)");
    check_field_offset(lv, s10181c38f0, ABISELECT(8,4), "S10181C38.s10181c38f0");
    check_field_offset(lv, s10181c38f1, ABISELECT(40,36), "S10181C38.s10181c38f1");
    check_field_offset(lv, s10181c38f2, ABISELECT(48,44), "S10181C38.s10181c38f2");
    check_field_offset(lv, s10181c38f3, ABISELECT(96,88), "S10181C38.s10181c38f3");
    check_field_offset(lv, s10181c38f4, ABISELECT(104,96), "S10181C38.s10181c38f4");
    check_field_offset(lv, s10181c38f5, ABISELECT(128,116), "S10181C38.s10181c38f5");
    check_field_offset(lv, s10181c38f6, ABISELECT(168,140), "S10181C38.s10181c38f6");
    check_field_offset(lv, s10181c38f7, ABISELECT(172,144), "S10181C38.s10181c38f7");
    check_field_offset(lv, s10181c38f8, ABISELECT(184,152), "S10181C38.s10181c38f8");
    check_field_offset(lv, s10181c38f9, ABISELECT(200,160), "S10181C38.s10181c38f9");
    check_field_offset(lv, s10181c38f10, ABISELECT(208,168), "S10181C38.s10181c38f10");
    test_class_info(&lv, &cd_S10181C38);
    dp->~S10181C38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C38(Test_S10181C38, "S10181C38", ABISELECT(224,180));

#else // __cplusplus

extern void _ZN9S10181C38C1Ev();
extern void _ZN9S10181C38D1Ev();
Name_Map name_map_S10181C38[] = {
  NSPAIR(_ZN9S10181C38C1Ev),
  NSPAIR(_ZN9S10181C38D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C38[];
extern void _ZN9S10181C38D1Ev();
extern void _ZN9S10181C38D0Ev();
static  VTBL_ENTRY vtc_S10181C38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C38[0]),
  (VTBL_ENTRY)&_ZN9S10181C38D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C38D0Ev,
};
extern VTBL_ENTRY _ZTI9S10181C38[];
extern  VTBL_ENTRY _ZTV9S10181C38[];
Class_Descriptor cd_S10181C38 = {  "S10181C38", // class name
  0,0,//no base classes
  &(vtc_S10181C38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,180), // object size
  NSPAIRA(_ZTI9S10181C38),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C38),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C52  {
  int s10181c52f0;
  char s10181c52f1[3];
  virtual  ~S10181C52(); // _ZN9S10181C52D1Ev
  virtual void  v84(); // _ZN9S10181C523v84Ev
  S10181C52(); // tgen
};
//SIG(-1 S10181C52) C1{ vd v1 Fi Fc[3]}


 S10181C52 ::~S10181C52(){ note_dtor("S10181C52", this);}
void  S10181C52 ::v84(){vfunc_called(this, "_ZN9S10181C523v84Ev");}
S10181C52 ::S10181C52(){ note_ctor("S10181C52", this);} // tgen

static void Test_S10181C52()
{
  extern Class_Descriptor cd_S10181C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S10181C52, buf);
    S10181C52 *dp, &lv = *(dp=new (buf) S10181C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10181C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C52)");
    check_field_offset(lv, s10181c52f0, ABISELECT(8,4), "S10181C52.s10181c52f0");
    check_field_offset(lv, s10181c52f1, ABISELECT(12,8), "S10181C52.s10181c52f1");
    test_class_info(&lv, &cd_S10181C52);
    dp->~S10181C52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C52(Test_S10181C52, "S10181C52", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN9S10181C52C1Ev();
extern void _ZN9S10181C52D1Ev();
Name_Map name_map_S10181C52[] = {
  NSPAIR(_ZN9S10181C52C1Ev),
  NSPAIR(_ZN9S10181C52D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C52[];
extern void _ZN9S10181C52D1Ev();
extern void _ZN9S10181C52D0Ev();
extern void _ZN9S10181C523v84Ev();
static  VTBL_ENTRY vtc_S10181C52[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C52[0]),
  (VTBL_ENTRY)&_ZN9S10181C52D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C52D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C523v84Ev,
};
extern VTBL_ENTRY _ZTI9S10181C52[];
extern  VTBL_ENTRY _ZTV9S10181C52[];
Class_Descriptor cd_S10181C52 = {  "S10181C52", // class name
  0,0,//no base classes
  &(vtc_S10181C52[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI9S10181C52),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C52),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C56  {
  ::S10181C37 s10181c56f0;
  ::S10180C54 s10181c56f1;
  void *s10181c56f2;
  int s10181c56f3[5];
  void  mf10181c56(); // _ZN9S10181C5610mf10181c56Ev
};
//SIG(-1 S10181C56) C1{ m FC2{ m FL[4]} FC3{ m Fp FC4{ Fi[4]}} Fp Fi[5]}


void  S10181C56 ::mf10181c56(){}

static void Test_S10181C56()
{
  {
    init_simple_test("S10181C56");
    S10181C56 lv;
    check2(sizeof(lv), ABISELECT(88,76), "sizeof(S10181C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C56)");
    check_field_offset(lv, s10181c56f0, 0, "S10181C56.s10181c56f0");
    check_field_offset(lv, s10181c56f1, 32, "S10181C56.s10181c56f1");
    check_field_offset(lv, s10181c56f2, ABISELECT(56,52), "S10181C56.s10181c56f2");
    check_field_offset(lv, s10181c56f3, ABISELECT(64,56), "S10181C56.s10181c56f3");
  }
}
static Arrange_To_Call_Me vS10181C56(Test_S10181C56, "S10181C56", ABISELECT(88,76));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C55  : S10181C52 {
  ::S10181C37 s10181c55f0;
  int s10181c55f1;
  void *s10181c55f2[2];
  ::S10181C56 s10181c55f3;
  short s10181c55f4[3585];
  char s10181c55f5[4096];
  int s10181c55f6;
  virtual  ~S10181C55(); // _ZN9S10181C55D1Ev
  virtual void  v85(); // _ZN9S10181C553v85Ev
  S10181C55(); // tgen
};
//SIG(-1 S10181C55) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 FC3{ m FL[4]} Fi Fp[2] FC4{ m FC3 FC5{ m Fp FC6{ Fi[4]}} Fp Fi[5]} Fs[3585] Fc[4096] Fi}


 S10181C55 ::~S10181C55(){ note_dtor("S10181C55", this);}
void  S10181C55 ::v85(){vfunc_called(this, "_ZN9S10181C553v85Ev");}
S10181C55 ::S10181C55(){ note_ctor("S10181C55", this);} // tgen

static void Test_S10181C55()
{
  extern Class_Descriptor cd_S10181C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1430,2852)];
    init_test(&cd_S10181C55, buf);
    S10181C55 *dp, &lv = *(dp=new (buf) S10181C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(11432,11404), "sizeof(S10181C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C55)");
    check_base_class_offset(lv, (S10181C52*), 0, "S10181C55");
    check_field_offset(lv, s10181c55f0, ABISELECT(16,12), "S10181C55.s10181c55f0");
    check_field_offset(lv, s10181c55f1, ABISELECT(48,44), "S10181C55.s10181c55f1");
    check_field_offset(lv, s10181c55f2, ABISELECT(56,48), "S10181C55.s10181c55f2");
    check_field_offset(lv, s10181c55f3, ABISELECT(72,56), "S10181C55.s10181c55f3");
    check_field_offset(lv, s10181c55f4, ABISELECT(160,132), "S10181C55.s10181c55f4");
    check_field_offset(lv, s10181c55f5, ABISELECT(7330,7302), "S10181C55.s10181c55f5");
    check_field_offset(lv, s10181c55f6, ABISELECT(11428,11400), "S10181C55.s10181c55f6");
    test_class_info(&lv, &cd_S10181C55);
    dp->~S10181C55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C55(Test_S10181C55, "S10181C55", ABISELECT(11432,11404));

#else // __cplusplus

extern void _ZN9S10181C55C1Ev();
extern void _ZN9S10181C55D1Ev();
Name_Map name_map_S10181C55[] = {
  NSPAIR(_ZN9S10181C55C1Ev),
  NSPAIR(_ZN9S10181C55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10181C52;
extern VTBL_ENTRY _ZTI9S10181C52[];
extern  VTBL_ENTRY _ZTV9S10181C52[];
static Base_Class bases_S10181C55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10181C52,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10181C55[];
extern void _ZN9S10181C55D1Ev();
extern void _ZN9S10181C55D0Ev();
extern void _ZN9S10181C523v84Ev();
extern void _ZN9S10181C553v85Ev();
static  VTBL_ENTRY vtc_S10181C55[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C55[0]),
  (VTBL_ENTRY)&_ZN9S10181C55D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C55D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C523v84Ev,
  (VTBL_ENTRY)&_ZN9S10181C553v85Ev,
};
extern VTBL_ENTRY _ZTI9S10181C55[];
extern  VTBL_ENTRY _ZTV9S10181C55[];
Class_Descriptor cd_S10181C55 = {  "S10181C55", // class name
  bases_S10181C55, 1,
  &(vtc_S10181C55[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(11432,11404), // object size
  NSPAIRA(_ZTI9S10181C55),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10181C55),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C51  : S10181C52 {
  void *s10181c51f0[4];
  __tsi64 s10181c51f1;
  int s10181c51f2;
  ::S10181C37 s10181c51f3;
  ::S10180C54 s10181c51f4;
  short s10181c51f5[1024];
  int s10181c51f6[4];
  __tsi64 s10181c51f7[2];
  int s10181c51f8;
  ::S10181C55 s10181c51f9;
  virtual  ~S10181C51(); // _ZN9S10181C51D1Ev
  virtual void  v83(); // _ZN9S10181C513v83Ev
  S10181C51(); // tgen
};
//SIG(-1 S10181C51) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 Fp[4] FL Fi FC3{ m FL[4]} FC4{ m Fp FC5{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC6{ BC2 vd v3 FC3 Fi Fp[2] FC7{ m FC3 FC4 Fp Fi[5]} Fs[3585] Fc[4096] Fi}}


 S10181C51 ::~S10181C51(){ note_dtor("S10181C51", this);}
void  S10181C51 ::v83(){vfunc_called(this, "_ZN9S10181C513v83Ev");}
S10181C51 ::S10181C51(){ note_ctor("S10181C51", this);} // tgen

static void Test_S10181C51()
{
  extern Class_Descriptor cd_S10181C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1706,3396)];
    init_test(&cd_S10181C51, buf);
    S10181C51 *dp, &lv = *(dp=new (buf) S10181C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13640,13580), "sizeof(S10181C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C51)");
    check_base_class_offset(lv, (S10181C52*), 0, "S10181C51");
    check_field_offset(lv, s10181c51f0, ABISELECT(16,12), "S10181C51.s10181c51f0");
    check_field_offset(lv, s10181c51f1, ABISELECT(48,28), "S10181C51.s10181c51f1");
    check_field_offset(lv, s10181c51f2, ABISELECT(56,36), "S10181C51.s10181c51f2");
    check_field_offset(lv, s10181c51f3, ABISELECT(64,40), "S10181C51.s10181c51f3");
    check_field_offset(lv, s10181c51f4, ABISELECT(96,72), "S10181C51.s10181c51f4");
    check_field_offset(lv, s10181c51f5, ABISELECT(120,92), "S10181C51.s10181c51f5");
    check_field_offset(lv, s10181c51f6, ABISELECT(2168,2140), "S10181C51.s10181c51f6");
    check_field_offset(lv, s10181c51f7, ABISELECT(2184,2156), "S10181C51.s10181c51f7");
    check_field_offset(lv, s10181c51f8, ABISELECT(2200,2172), "S10181C51.s10181c51f8");
    check_field_offset(lv, s10181c51f9, ABISELECT(2208,2176), "S10181C51.s10181c51f9");
    test_class_info(&lv, &cd_S10181C51);
    dp->~S10181C51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C51(Test_S10181C51, "S10181C51", ABISELECT(13640,13580));

#else // __cplusplus

extern void _ZN9S10181C51C1Ev();
extern void _ZN9S10181C51D1Ev();
Name_Map name_map_S10181C51[] = {
  NSPAIR(_ZN9S10181C51C1Ev),
  NSPAIR(_ZN9S10181C51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10181C52;
extern VTBL_ENTRY _ZTI9S10181C52[];
extern  VTBL_ENTRY _ZTV9S10181C52[];
static Base_Class bases_S10181C51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10181C52,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10181C51[];
extern void _ZN9S10181C51D1Ev();
extern void _ZN9S10181C51D0Ev();
extern void _ZN9S10181C523v84Ev();
extern void _ZN9S10181C513v83Ev();
static  VTBL_ENTRY vtc_S10181C51[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C51[0]),
  (VTBL_ENTRY)&_ZN9S10181C51D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C51D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C523v84Ev,
  (VTBL_ENTRY)&_ZN9S10181C513v83Ev,
};
extern VTBL_ENTRY _ZTI9S10181C51[];
extern  VTBL_ENTRY _ZTV9S10181C51[];
Class_Descriptor cd_S10181C51 = {  "S10181C51", // class name
  bases_S10181C51, 1,
  &(vtc_S10181C51[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(13640,13580), // object size
  NSPAIRA(_ZTI9S10181C51),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10181C51),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C59  {
  ::S10181C37 s10181c59f0;
  ::S10180C54 s10181c59f1;
  void *s10181c59f2;
  int s10181c59f3[4];
  void  mf10181c59(); // _ZN9S10181C5910mf10181c59Ev
};
//SIG(-1 S10181C59) C1{ m FC2{ m FL[4]} FC3{ m Fp FC4{ Fi[4]}} Fp Fi[4]}


void  S10181C59 ::mf10181c59(){}

static void Test_S10181C59()
{
  {
    init_simple_test("S10181C59");
    S10181C59 lv;
    check2(sizeof(lv), ABISELECT(80,72), "sizeof(S10181C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C59)");
    check_field_offset(lv, s10181c59f0, 0, "S10181C59.s10181c59f0");
    check_field_offset(lv, s10181c59f1, 32, "S10181C59.s10181c59f1");
    check_field_offset(lv, s10181c59f2, ABISELECT(56,52), "S10181C59.s10181c59f2");
    check_field_offset(lv, s10181c59f3, ABISELECT(64,56), "S10181C59.s10181c59f3");
  }
}
static Arrange_To_Call_Me vS10181C59(Test_S10181C59, "S10181C59", ABISELECT(80,72));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C57  : S10181C52 {
  void *s10181c57f0[2];
  __tsi64 s10181c57f1;
  int s10181c57f2[4];
  ::S10180C118 s10181c57f3;
  ::S10181C37 s10181c57f4;
  ::S10181C59 s10181c57f5;
  ::S10180C114 s10181c57f6;
  virtual  ~S10181C57(); // _ZN9S10181C57D1Ev
  virtual void  v86(); // _ZN9S10181C573v86Ev
  S10181C57(); // tgen
};
//SIG(-1 S10181C57) C1{ BC2{ vd v2 Fi Fc[3]} vd v1 Fp[2] FL Fi[4] FC3{ m Fi[2]} FC4{ m FL[4]} FC5{ m FC4 FC6{ m Fp FC7{ Fi[4]}} Fp Fi[4]} FC8{ m Fp}}


 S10181C57 ::~S10181C57(){ note_dtor("S10181C57", this);}
void  S10181C57 ::v86(){vfunc_called(this, "_ZN9S10181C573v86Ev");}
S10181C57 ::S10181C57(){ note_ctor("S10181C57", this);} // tgen

static void Test_S10181C57()
{
  extern Class_Descriptor cd_S10181C57;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,41)];
    init_test(&cd_S10181C57, buf);
    S10181C57 *dp, &lv = *(dp=new (buf) S10181C57());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,160), "sizeof(S10181C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C57)");
    check_base_class_offset(lv, (S10181C52*), 0, "S10181C57");
    check_field_offset(lv, s10181c57f0, ABISELECT(16,12), "S10181C57.s10181c57f0");
    check_field_offset(lv, s10181c57f1, ABISELECT(32,20), "S10181C57.s10181c57f1");
    check_field_offset(lv, s10181c57f2, ABISELECT(40,28), "S10181C57.s10181c57f2");
    check_field_offset(lv, s10181c57f3, ABISELECT(56,44), "S10181C57.s10181c57f3");
    check_field_offset(lv, s10181c57f4, ABISELECT(64,52), "S10181C57.s10181c57f4");
    check_field_offset(lv, s10181c57f5, ABISELECT(96,84), "S10181C57.s10181c57f5");
    check_field_offset(lv, s10181c57f6, ABISELECT(176,156), "S10181C57.s10181c57f6");
    test_class_info(&lv, &cd_S10181C57);
    dp->~S10181C57();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C57(Test_S10181C57, "S10181C57", ABISELECT(184,160));

#else // __cplusplus

extern void _ZN9S10181C57C1Ev();
extern void _ZN9S10181C57D1Ev();
Name_Map name_map_S10181C57[] = {
  NSPAIR(_ZN9S10181C57C1Ev),
  NSPAIR(_ZN9S10181C57D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10181C52;
extern VTBL_ENTRY _ZTI9S10181C52[];
extern  VTBL_ENTRY _ZTV9S10181C52[];
static Base_Class bases_S10181C57[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10181C52,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10181C57[];
extern void _ZN9S10181C57D1Ev();
extern void _ZN9S10181C57D0Ev();
extern void _ZN9S10181C523v84Ev();
extern void _ZN9S10181C573v86Ev();
static  VTBL_ENTRY vtc_S10181C57[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C57[0]),
  (VTBL_ENTRY)&_ZN9S10181C57D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C57D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C523v84Ev,
  (VTBL_ENTRY)&_ZN9S10181C573v86Ev,
};
extern VTBL_ENTRY _ZTI9S10181C57[];
extern  VTBL_ENTRY _ZTV9S10181C57[];
Class_Descriptor cd_S10181C57 = {  "S10181C57", // class name
  bases_S10181C57, 1,
  &(vtc_S10181C57[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,160), // object size
  NSPAIRA(_ZTI9S10181C57),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10181C57),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C46  {
  ::S10180C48 s10181c46f0;
  ::S10180C50 s10181c46f1;
  ::S10181C51 s10181c46f2;
  ::S10181C57 s10181c46f3;
  ::S10181C37 s10181c46f4;
  ::S10181C37 s10181c46f5;
  __tsi64 s10181c46f6;
  int s10181c46f7[5];
  void  mf10181c46(); // _ZN9S10181C4610mf10181c46Ev
  virtual  ~S10181C46(); // _ZN9S10181C46D1Ev
  S10181C46(); // tgen
};
//SIG(-1 S10181C46) C1{ vd m FC2{ vd m FC3{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC4{ BC5{ vd v7 v8 v9 v10 v11 v12 Fi Fp Fc} vd v1 v2 v3 v4 v5 v6 Fp} FC6{ BC7{ vd v14 Fi Fc[3]} vd v13 Fp[4] FL Fi FC8{ m FL[4]} FC9{ m Fp FC10{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC11{ BC7 vd v15 FC8 Fi Fp[2] FC12{ m FC8 FC9 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC13{ BC7 vd v16 Fp[2] FL Fi[4] FC14{ m Fi[2]} FC8 FC15{ m FC8 FC9 Fp Fi[4]} FC16{ m Fp}} FC8 FC8 FL Fi[5]}


void  S10181C46 ::mf10181c46(){}
 S10181C46 ::~S10181C46(){ note_dtor("S10181C46", this);}
S10181C46 ::S10181C46(){ note_ctor("S10181C46", this);} // tgen

static void Test_S10181C46()
{
  extern Class_Descriptor cd_S10181C46;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1763,3487)];
    init_test(&cd_S10181C46, buf);
    S10181C46 *dp, &lv = *(dp=new (buf) S10181C46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14096,13944), "sizeof(S10181C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C46)");
    check_field_offset(lv, s10181c46f0, ABISELECT(8,4), "S10181C46.s10181c46f0");
    check_field_offset(lv, s10181c46f1, ABISELECT(136,92), "S10181C46.s10181c46f1");
    check_field_offset(lv, s10181c46f2, ABISELECT(176,112), "S10181C46.s10181c46f2");
    check_field_offset(lv, s10181c46f3, ABISELECT(13816,13692), "S10181C46.s10181c46f3");
    check_field_offset(lv, s10181c46f4, ABISELECT(14000,13852), "S10181C46.s10181c46f4");
    check_field_offset(lv, s10181c46f5, ABISELECT(14032,13884), "S10181C46.s10181c46f5");
    check_field_offset(lv, s10181c46f6, ABISELECT(14064,13916), "S10181C46.s10181c46f6");
    check_field_offset(lv, s10181c46f7, ABISELECT(14072,13924), "S10181C46.s10181c46f7");
    test_class_info(&lv, &cd_S10181C46);
    dp->~S10181C46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C46(Test_S10181C46, "S10181C46", ABISELECT(14096,13944));

#else // __cplusplus

extern void _ZN9S10181C46C1Ev();
extern void _ZN9S10181C46D1Ev();
Name_Map name_map_S10181C46[] = {
  NSPAIR(_ZN9S10181C46C1Ev),
  NSPAIR(_ZN9S10181C46D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10181C46[];
extern void _ZN9S10181C46D1Ev();
extern void _ZN9S10181C46D0Ev();
static  VTBL_ENTRY vtc_S10181C46[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C46[0]),
  (VTBL_ENTRY)&_ZN9S10181C46D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C46D0Ev,
};
extern VTBL_ENTRY _ZTI9S10181C46[];
extern  VTBL_ENTRY _ZTV9S10181C46[];
Class_Descriptor cd_S10181C46 = {  "S10181C46", // class name
  0,0,//no base classes
  &(vtc_S10181C46[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(14096,13944), // object size
  NSPAIRA(_ZTI9S10181C46),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10181C46),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C43  : S10180C17 , S10181C24 {
  int s10181c43f0;
  ::S10180C45 s10181c43f1;
  ::S10180C46 s10181c43f2;
  void *s10181c43f3;
  ::S10181C46 s10181c43f4;
  __tsi64 s10181c43f5;
  ::S10180C62 s10181c43f6;
  char s10181c43f7[128];
  ::S10180C169 s10181c43f8;
  ::S10180C31 s10181c43f9;
  virtual  ~S10181C43(); // _ZN9S10181C43D1Ev
  virtual void  v70(); // _ZN9S10181C433v70Ev
  S10181C43(); // tgen
};
//SIG(-1 S10181C43) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v2} vd v1 Fi FC7{ m Fc[2]} FC8{ Fp[2]} Fp FC9{ vd m FC10{ vd m FC11{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC12{ BC13{ vd v9 v10 v11 v12 v13 v14 Fi Fp Fc} vd v3 v4 v5 v6 v7 v8 Fp} FC14{ BC15{ vd v16 Fi Fc[3]} vd v15 Fp[4] FL Fi FC16{ m FL[4]} FC17{ m Fp FC18{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC19{ BC15 vd v17 FC16 Fi Fp[2] FC20{ m FC16 FC17 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC21{ BC15 vd v18 Fp[2] FL Fi[4] FC22{ m Fi[2]} FC16 FC23{ m FC16 FC17 Fp Fi[4]} FC24{ m Fp}} FC16 FC16 FL Fi[5]} FL FC25{ m FC26{ m FL[3] Fi[3] FL} FC27{ m Fi} Fi} Fc[128] FC28{ m Fi[2]} FC29{ m FC30{ m Fp Fi[2] FC5} Fp[2]}}


 S10181C43 ::~S10181C43(){ note_dtor("S10181C43", this);}
void  S10181C43 ::v70(){vfunc_called(this, "_ZN9S10181C433v70Ev");}
S10181C43 ::S10181C43(){ note_ctor("S10181C43", this);} // tgen

static void Test_S10181C43()
{
  extern Class_Descriptor cd_S10181C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1804,3556)];
    init_test(&cd_S10181C43, buf);
    S10181C43 *dp, &lv = *(dp=new (buf) S10181C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14424,14220), "sizeof(S10181C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C43)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10181C43");
    check_base_class_offset(lv, (S10181C24*), ABISELECT(48,32), "S10181C43");
    check_field_offset(lv, s10181c43f0, ABISELECT(56,36), "S10181C43.s10181c43f0");
    check_field_offset(lv, s10181c43f1, ABISELECT(60,40), "S10181C43.s10181c43f1");
    check_field_offset(lv, s10181c43f2, ABISELECT(64,44), "S10181C43.s10181c43f2");
    check_field_offset(lv, s10181c43f3, ABISELECT(80,52), "S10181C43.s10181c43f3");
    check_field_offset(lv, s10181c43f4, ABISELECT(88,56), "S10181C43.s10181c43f4");
    check_field_offset(lv, s10181c43f5, ABISELECT(14184,14000), "S10181C43.s10181c43f5");
    check_field_offset(lv, s10181c43f6, ABISELECT(14192,14008), "S10181C43.s10181c43f6");
    check_field_offset(lv, s10181c43f7, ABISELECT(14248,14060), "S10181C43.s10181c43f7");
    check_field_offset(lv, s10181c43f8, ABISELECT(14376,14188), "S10181C43.s10181c43f8");
    check_field_offset(lv, s10181c43f9, ABISELECT(14384,14196), "S10181C43.s10181c43f9");
    test_class_info(&lv, &cd_S10181C43);
    dp->~S10181C43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C43(Test_S10181C43, "S10181C43", ABISELECT(14424,14220));

#else // __cplusplus

extern void _ZN9S10181C43C1Ev();
extern void _ZN9S10181C43D1Ev();
Name_Map name_map_S10181C43[] = {
  NSPAIR(_ZN9S10181C43C1Ev),
  NSPAIR(_ZN9S10181C43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10181C24;
extern VTBL_ENTRY _ZTI9S10181C24[];
extern  VTBL_ENTRY _ZTV9S10181C24[];
static Base_Class bases_S10181C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10181C24,    ABISELECT(48,32), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10181C43[];
extern void _ZN9S10181C43D1Ev();
extern void _ZN9S10181C43D0Ev();
extern void _ZN9S10181C433v70Ev();
extern void ABISELECT(_ZThn48_N9S10181C43D1Ev,_ZThn32_N9S10181C43D1Ev)();
extern void ABISELECT(_ZThn48_N9S10181C43D0Ev,_ZThn32_N9S10181C43D0Ev)();
extern void _ZN9S10181C243v41Ev();
static  VTBL_ENTRY vtc_S10181C43[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C43[0]),
  (VTBL_ENTRY)&_ZN9S10181C43D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C43D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C433v70Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10181C43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10181C43D1Ev,_ZThn32_N9S10181C43D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10181C43D0Ev,_ZThn32_N9S10181C43D0Ev),
  (VTBL_ENTRY)&_ZN9S10181C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10181C43[];
extern  VTBL_ENTRY _ZTV9S10181C43[];
Class_Descriptor cd_S10181C43 = {  "S10181C43", // class name
  bases_S10181C43, 2,
  &(vtc_S10181C43[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(14424,14220), // object size
  NSPAIRA(_ZTI9S10181C43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10181C43),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C25  : S10180C17 , S10181C2 , S10181C11 , S10181C26 , S10181C27 {
  int s10181c25f0;
  ::S10180C169 s10181c25f1;
  ::S10180C169 s10181c25f2;
  ::S10180C169 s10181c25f3;
  ::S10180C29 s10181c25f4;
  ::S10180C34 s10181c25f5;
  ::S10181C35 s10181c25f6;
  ::S10181C38 s10181c25f7;
  int s10181c25f8;
  void *s10181c25f9;
  ::S10181C43 s10181c25f10;
  int s10181c25f11[3];
  ::S10180C64 s10181c25f12;
  ::S10180C65 s10181c25f13;
  ::S10180C66 s10181c25f14;
  ::S10180C87 s10181c25f15;
  __tsi64 s10181c25f16;
  ::S10180C106 s10181c25f17;
  ::S10180C86 s10181c25f18;
  ::S10180C68 s10181c25f19;
  ::S10180C31 s10181c25f20;
  char s10181c25f21;
  virtual  ~S10181C25(); // _ZN9S10181C25D1Ev
  virtual void  v42(); // _ZN9S10181C253v42Ev
  virtual void  v43(); // _ZN9S10181C253v43Ev
  virtual void  v44(); // _ZN9S10181C253v44Ev
  virtual void  v45(); // _ZN9S10181C253v45Ev
  virtual void  v46(); // _ZN9S10181C253v46Ev
  virtual void  v47(); // _ZN9S10181C253v47Ev
  virtual void  v48(); // _ZN9S10181C253v48Ev
  virtual void  v49(); // _ZN9S10181C253v49Ev
  virtual void  v50(); // _ZN9S10181C253v50Ev
  virtual void  v51(); // _ZN9S10181C253v51Ev
  virtual void  v52(); // _ZN9S10181C253v52Ev
  virtual void  v53(); // _ZN9S10181C253v53Ev
  virtual void  v54(); // _ZN9S10181C253v54Ev
  virtual void  v55(); // _ZN9S10181C253v55Ev
  virtual void  v56(); // _ZN9S10181C253v56Ev
  virtual void  v57(); // _ZN9S10181C253v57Ev
  virtual void  v58(); // _ZN9S10181C253v58Ev
  virtual void  v59(); // _ZN9S10181C253v59Ev
  virtual void  v60(); // _ZN9S10181C253v60Ev
  virtual void  v61(); // _ZN9S10181C253v61Ev
  virtual void  v62(); // _ZN9S10181C253v62Ev
  virtual void  v63(); // _ZN9S10181C253v63Ev
  S10181C25(); // tgen
};
//SIG(-1 S10181C25) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v23} BC7{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 Fp FC8{ m FC9{ m Fp Fi FC4} Fi} FC10{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC11{ vd v48} BC12{ vd v49 v50} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi FC13{ m Fi[2]} FC13 FC13 FC14{ BC2 vd Fi Fp FC8 FL FC15{ m Fi[2]} Fi Fc Fi FC16{ m FC17{ m Fp Fi[2] FC5} Fp[2]}} FC18{ BC19{ vd v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 Fp FC8 FC10} vd v51 v52 v53} FC20{ vd m Fi Fp[3] FC21{ m Fc[2] Fp[3] Fi[4] FC22{ m FL[4]}}} FC23{ vd m FC22 Fi[2] FC24{ m FL[3] Fi[3] FL} FL FC25{ m Fi FC26{ m Fi[4]}} FC16 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC27{ BC2 BC28{ vd v79} vd v78 Fi FC29{ m Fc[2]} FC30{ Fp[2]} Fp FC31{ vd m FC32{ vd m FC33{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC34{ BC35{ vd v86 v87 v88 v89 v90 v91 Fi Fp Fc} vd v80 v81 v82 v83 v84 v85 Fp} FC36{ BC37{ vd v93 Fi Fc[3]} vd v92 Fp[4] FL Fi FC22 FC38{ m Fp FC39{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC40{ BC37 vd v94 FC22 Fi Fp[2] FC41{ m FC22 FC38 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC42{ BC37 vd v95 Fp[2] FL Fi[4] FC43{ m Fi[2]} FC22 FC44{ m FC22 FC38 Fp Fi[4]} FC45{ m Fp}} FC22 FC22 FL Fi[5]} FL FC46{ m FC24 FC47{ m Fi} Fi} Fc[128] FC13 FC16} Fi[3] FC48{ m Fp Fi[2]} FC49{ m Fc[11] Fi[2]} FC50{ BC51{} FL Fi} FC52{ BC53{ BC2 vd v98 v99 v100 v101 FC54{ m Fp FC8 FC9 FC9 Fi[3] FC55{ m FC56{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v96 v97} FL FC57{ BC53 v102} FC58{ BC53 v103} FC59{ BC53 v104 v105} FC16 Fc}


 S10181C25 ::~S10181C25(){ note_dtor("S10181C25", this);}
void  S10181C25 ::v42(){vfunc_called(this, "_ZN9S10181C253v42Ev");}
void  S10181C25 ::v43(){vfunc_called(this, "_ZN9S10181C253v43Ev");}
void  S10181C25 ::v44(){vfunc_called(this, "_ZN9S10181C253v44Ev");}
void  S10181C25 ::v45(){vfunc_called(this, "_ZN9S10181C253v45Ev");}
void  S10181C25 ::v46(){vfunc_called(this, "_ZN9S10181C253v46Ev");}
void  S10181C25 ::v47(){vfunc_called(this, "_ZN9S10181C253v47Ev");}
void  S10181C25 ::v48(){vfunc_called(this, "_ZN9S10181C253v48Ev");}
void  S10181C25 ::v49(){vfunc_called(this, "_ZN9S10181C253v49Ev");}
void  S10181C25 ::v50(){vfunc_called(this, "_ZN9S10181C253v50Ev");}
void  S10181C25 ::v51(){vfunc_called(this, "_ZN9S10181C253v51Ev");}
void  S10181C25 ::v52(){vfunc_called(this, "_ZN9S10181C253v52Ev");}
void  S10181C25 ::v53(){vfunc_called(this, "_ZN9S10181C253v53Ev");}
void  S10181C25 ::v54(){vfunc_called(this, "_ZN9S10181C253v54Ev");}
void  S10181C25 ::v55(){vfunc_called(this, "_ZN9S10181C253v55Ev");}
void  S10181C25 ::v56(){vfunc_called(this, "_ZN9S10181C253v56Ev");}
void  S10181C25 ::v57(){vfunc_called(this, "_ZN9S10181C253v57Ev");}
void  S10181C25 ::v58(){vfunc_called(this, "_ZN9S10181C253v58Ev");}
void  S10181C25 ::v59(){vfunc_called(this, "_ZN9S10181C253v59Ev");}
void  S10181C25 ::v60(){vfunc_called(this, "_ZN9S10181C253v60Ev");}
void  S10181C25 ::v61(){vfunc_called(this, "_ZN9S10181C253v61Ev");}
void  S10181C25 ::v62(){vfunc_called(this, "_ZN9S10181C253v62Ev");}
void  S10181C25 ::v63(){vfunc_called(this, "_ZN9S10181C253v63Ev");}
S10181C25 ::S10181C25(){ note_ctor("S10181C25", this);} // tgen

static void Test_S10181C25()
{
  extern Class_Descriptor cd_S10181C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2037,3888)];
    init_test(&cd_S10181C25, buf);
    S10181C25 *dp, &lv = *(dp=new (buf) S10181C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16288,15548), "sizeof(S10181C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C25)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10181C25");
    check_base_class_offset(lv, (S10181C2*), ABISELECT(48,32), "S10181C25");
    check_base_class_offset(lv, (S10181C11*), ABISELECT(56,36), "S10181C25");
    check_base_class_offset(lv, (S10181C26*), ABISELECT(152,100), "S10181C25");
    check_base_class_offset(lv, (S10181C27*), ABISELECT(160,104), "S10181C25");
    check_field_offset(lv, s10181c25f0, ABISELECT(168,108), "S10181C25.s10181c25f0");
    check_field_offset(lv, s10181c25f1, ABISELECT(172,112), "S10181C25.s10181c25f1");
    check_field_offset(lv, s10181c25f2, ABISELECT(180,120), "S10181C25.s10181c25f2");
    check_field_offset(lv, s10181c25f3, ABISELECT(188,128), "S10181C25.s10181c25f3");
    check_field_offset(lv, s10181c25f4, ABISELECT(200,136), "S10181C25.s10181c25f4");
    check_field_offset(lv, s10181c25f5, ABISELECT(352,244), "S10181C25.s10181c25f5");
    check_field_offset(lv, s10181c25f6, ABISELECT(448,308), "S10181C25.s10181c25f6");
    check_field_offset(lv, s10181c25f7, ABISELECT(568,392), "S10181C25.s10181c25f7");
    check_field_offset(lv, s10181c25f8, ABISELECT(792,572), "S10181C25.s10181c25f8");
    check_field_offset(lv, s10181c25f9, ABISELECT(800,576), "S10181C25.s10181c25f9");
    check_field_offset(lv, s10181c25f10, ABISELECT(808,580), "S10181C25.s10181c25f10");
    check_field_offset(lv, s10181c25f11, ABISELECT(15232,14800), "S10181C25.s10181c25f11");
    check_field_offset(lv, s10181c25f12, ABISELECT(15248,14812), "S10181C25.s10181c25f12");
    check_field_offset(lv, s10181c25f13, ABISELECT(15264,14824), "S10181C25.s10181c25f13");
    check_field_offset(lv, s10181c25f14, ABISELECT(15288,14844), "S10181C25.s10181c25f14");
    check_field_offset(lv, s10181c25f15, ABISELECT(15304,14856), "S10181C25.s10181c25f15");
    check_field_offset(lv, s10181c25f16, ABISELECT(15536,15020), "S10181C25.s10181c25f16");
    check_field_offset(lv, s10181c25f17, ABISELECT(15544,15028), "S10181C25.s10181c25f17");
    check_field_offset(lv, s10181c25f18, ABISELECT(15776,15192), "S10181C25.s10181c25f18");
    check_field_offset(lv, s10181c25f19, ABISELECT(16008,15356), "S10181C25.s10181c25f19");
    check_field_offset(lv, s10181c25f20, ABISELECT(16240,15520), "S10181C25.s10181c25f20");
    check_field_offset(lv, s10181c25f21, ABISELECT(16280,15544), "S10181C25.s10181c25f21");
    test_class_info(&lv, &cd_S10181C25);
    dp->~S10181C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C25(Test_S10181C25, "S10181C25", ABISELECT(16288,15548));

#else // __cplusplus

extern void _ZN9S10181C25C1Ev();
extern void _ZN9S10181C25D1Ev();
Name_Map name_map_S10181C25[] = {
  NSPAIR(_ZN9S10181C25C1Ev),
  NSPAIR(_ZN9S10181C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10181C2;
extern VTBL_ENTRY _ZTI8S10181C2[];
extern  VTBL_ENTRY _ZTV8S10181C2[];
extern Class_Descriptor cd_S10181C11;
extern VTBL_ENTRY _ZTI9S10181C11[];
extern  VTBL_ENTRY _ZTV9S10181C11[];
extern Class_Descriptor cd_S10181C26;
extern VTBL_ENTRY _ZTI9S10181C26[];
extern  VTBL_ENTRY _ZTV9S10181C26[];
extern Class_Descriptor cd_S10181C27;
extern VTBL_ENTRY _ZTI9S10181C27[];
extern  VTBL_ENTRY _ZTV9S10181C27[];
static Base_Class bases_S10181C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10181C2,    ABISELECT(48,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10181C11,    ABISELECT(56,36), //bcp->offset
    31, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10181C26,    ABISELECT(152,100), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10181C27,    ABISELECT(160,104), //bcp->offset
    64, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10181C25[];
extern void _ZN9S10181C25D1Ev();
extern void _ZN9S10181C25D0Ev();
extern void _ZN9S10181C253v42Ev();
extern void _ZN9S10181C253v43Ev();
extern void _ZN9S10181C253v44Ev();
extern void _ZN9S10181C253v45Ev();
extern void _ZN9S10181C253v46Ev();
extern void _ZN9S10181C253v47Ev();
extern void _ZN9S10181C253v48Ev();
extern void _ZN9S10181C253v49Ev();
extern void _ZN9S10181C253v50Ev();
extern void _ZN9S10181C253v51Ev();
extern void _ZN9S10181C253v52Ev();
extern void _ZN9S10181C253v53Ev();
extern void _ZN9S10181C253v54Ev();
extern void _ZN9S10181C253v55Ev();
extern void _ZN9S10181C253v56Ev();
extern void _ZN9S10181C253v57Ev();
extern void _ZN9S10181C253v58Ev();
extern void _ZN9S10181C253v59Ev();
extern void _ZN9S10181C253v60Ev();
extern void _ZN9S10181C253v61Ev();
extern void _ZN9S10181C253v62Ev();
extern void _ZN9S10181C253v63Ev();
extern void ABISELECT(_ZThn48_N9S10181C25D1Ev,_ZThn32_N9S10181C25D1Ev)();
extern void ABISELECT(_ZThn48_N9S10181C25D0Ev,_ZThn32_N9S10181C25D0Ev)();
extern void _ZN8S10181C22v7Ev();
extern void ABISELECT(_ZThn56_N9S10181C25D1Ev,_ZThn36_N9S10181C25D1Ev)();
extern void ABISELECT(_ZThn56_N9S10181C25D0Ev,_ZThn36_N9S10181C25D0Ev)();
extern void _ZN9S10181C113v15Ev();
extern void _ZN9S10181C113v16Ev();
extern void _ZN9S10181C113v17Ev();
extern void _ZN9S10181C113v18Ev();
extern void _ZN9S10181C113v19Ev();
extern void _ZN9S10181C113v20Ev();
extern void _ZN9S10181C113v21Ev();
extern void _ZN9S10181C113v22Ev();
extern void _ZN9S10181C113v23Ev();
extern void _ZN9S10181C113v24Ev();
extern void _ZN9S10181C113v25Ev();
extern void _ZN9S10181C113v26Ev();
extern void _ZN9S10181C113v27Ev();
extern void _ZN9S10181C113v28Ev();
extern void _ZN9S10181C113v29Ev();
extern void _ZN9S10181C113v30Ev();
extern void _ZN9S10181C113v31Ev();
extern void _ZN9S10181C113v32Ev();
extern void _ZN9S10181C113v33Ev();
extern void _ZN9S10181C113v34Ev();
extern void _ZN9S10181C113v35Ev();
extern void _ZN9S10181C113v36Ev();
extern void _ZN9S10181C113v37Ev();
extern void _ZN9S10181C113v38Ev();
extern void ABISELECT(_ZThn152_N9S10181C25D1Ev,_ZThn100_N9S10181C25D1Ev)();
extern void ABISELECT(_ZThn152_N9S10181C25D0Ev,_ZThn100_N9S10181C25D0Ev)();
extern void _ZN9S10181C263v64Ev();
extern void ABISELECT(_ZThn160_N9S10181C25D1Ev,_ZThn104_N9S10181C25D1Ev)();
extern void ABISELECT(_ZThn160_N9S10181C25D0Ev,_ZThn104_N9S10181C25D0Ev)();
extern void _ZN9S10181C273v65Ev();
extern void _ZN9S10181C273v66Ev();
static  VTBL_ENTRY vtc_S10181C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C25[0]),
  (VTBL_ENTRY)&_ZN9S10181C25D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C25D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v42Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v43Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v44Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v45Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v46Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v47Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v48Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v49Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v50Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v51Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v52Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v53Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v54Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v55Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v56Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v57Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v58Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v59Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v60Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v61Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v62Ev,
  (VTBL_ENTRY)&_ZN9S10181C253v63Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S10181C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10181C25D1Ev,_ZThn32_N9S10181C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S10181C25D0Ev,_ZThn32_N9S10181C25D0Ev),
  (VTBL_ENTRY)&_ZN8S10181C22v7Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S10181C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10181C25D1Ev,_ZThn36_N9S10181C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10181C25D0Ev,_ZThn36_N9S10181C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10181C113v15Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v16Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v17Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v18Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v19Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v20Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v21Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v22Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v23Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v24Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v25Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v26Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v27Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v28Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v29Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v30Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v31Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v32Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v33Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v34Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v35Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v36Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v37Ev,
  (VTBL_ENTRY)&_ZN9S10181C113v38Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S10181C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10181C25D1Ev,_ZThn100_N9S10181C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N9S10181C25D0Ev,_ZThn100_N9S10181C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10181C263v64Ev,
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S10181C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10181C25D1Ev,_ZThn104_N9S10181C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S10181C25D0Ev,_ZThn104_N9S10181C25D0Ev),
  (VTBL_ENTRY)&_ZN9S10181C273v65Ev,
  (VTBL_ENTRY)&_ZN9S10181C273v66Ev,
};
extern VTBL_ENTRY _ZTI9S10181C25[];
extern  VTBL_ENTRY _ZTV9S10181C25[];
Class_Descriptor cd_S10181C25 = {  "S10181C25", // class name
  bases_S10181C25, 5,
  &(vtc_S10181C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16288,15548), // object size
  NSPAIRA(_ZTI9S10181C25),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S10181C25),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C68  : S10180C17 {
  ::S10180C70 s10181c68f0;
  void *s10181c68f1;
  char s10181c68f2;
  int s10181c68f3;
  virtual  ~S10181C68(); // _ZN9S10181C68D1Ev
  virtual void  v89(); // _ZN9S10181C683v89Ev
  virtual void  v90(); // _ZN9S10181C683v90Ev
  virtual void  v91(); // _ZN9S10181C683v91Ev
  virtual void  v92(); // _ZN9S10181C683v92Ev
  S10181C68(); // tgen
};
//SIG(-1 S10181C68) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 FC6{ m Fp FC7{ m FC8{ m Fp Fi FC4} Fi} FC8 FC8 Fi[3] FC9{ m FC10{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC7 FC7 Fc} Fp Fc Fi}


 S10181C68 ::~S10181C68(){ note_dtor("S10181C68", this);}
void  S10181C68 ::v89(){vfunc_called(this, "_ZN9S10181C683v89Ev");}
void  S10181C68 ::v90(){vfunc_called(this, "_ZN9S10181C683v90Ev");}
void  S10181C68 ::v91(){vfunc_called(this, "_ZN9S10181C683v91Ev");}
void  S10181C68 ::v92(){vfunc_called(this, "_ZN9S10181C683v92Ev");}
S10181C68 ::S10181C68(){ note_ctor("S10181C68", this);} // tgen

static void Test_S10181C68()
{
  extern Class_Descriptor cd_S10181C68;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10181C68, buf);
    S10181C68 *dp, &lv = *(dp=new (buf) S10181C68());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10181C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C68)");
    check_base_class_offset(lv, (S10180C17*), 0, "S10181C68");
    check_field_offset(lv, s10181c68f0, ABISELECT(48,32), "S10181C68.s10181c68f0");
    check_field_offset(lv, s10181c68f1, ABISELECT(216,152), "S10181C68.s10181c68f1");
    check_field_offset(lv, s10181c68f2, ABISELECT(224,156), "S10181C68.s10181c68f2");
    check_field_offset(lv, s10181c68f3, ABISELECT(228,160), "S10181C68.s10181c68f3");
    test_class_info(&lv, &cd_S10181C68);
    dp->~S10181C68();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C68(Test_S10181C68, "S10181C68", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN9S10181C68C1Ev();
extern void _ZN9S10181C68D1Ev();
Name_Map name_map_S10181C68[] = {
  NSPAIR(_ZN9S10181C68C1Ev),
  NSPAIR(_ZN9S10181C68D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
static Base_Class bases_S10181C68[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10181C68[];
extern void _ZN9S10181C68D1Ev();
extern void _ZN9S10181C68D0Ev();
extern void _ZN9S10181C683v89Ev();
extern void _ZN9S10181C683v90Ev();
extern void _ZN9S10181C683v91Ev();
extern void _ZN9S10181C683v92Ev();
static  VTBL_ENTRY vtc_S10181C68[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C68[0]),
  (VTBL_ENTRY)&_ZN9S10181C68D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C68D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v89Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v90Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v91Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v92Ev,
};
extern VTBL_ENTRY _ZTI9S10181C68[];
extern  VTBL_ENTRY _ZTV9S10181C68[];
Class_Descriptor cd_S10181C68 = {  "S10181C68", // class name
  bases_S10181C68, 1,
  &(vtc_S10181C68[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI9S10181C68),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10181C68),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C101  : S10181C68 {
  virtual void  v199(); // _ZN10S10181C1014v199Ev
  virtual void  v200(); // _ZN10S10181C1014v200Ev
  ~S10181C101(); // tgen
  S10181C101(); // tgen
};
//SIG(-1 S10181C101) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v3 v4 v5 v6 FC7{ m Fp FC8{ m FC9{ m Fp Fi FC5} Fi} FC9 FC9 Fi[3] FC10{ m FC11{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC8 FC8 Fc} Fp Fc Fi} v1 v2}


void  S10181C101 ::v199(){vfunc_called(this, "_ZN10S10181C1014v199Ev");}
void  S10181C101 ::v200(){vfunc_called(this, "_ZN10S10181C1014v200Ev");}
S10181C101 ::~S10181C101(){ note_dtor("S10181C101", this);} // tgen
S10181C101 ::S10181C101(){ note_ctor("S10181C101", this);} // tgen

static void Test_S10181C101()
{
  extern Class_Descriptor cd_S10181C101;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S10181C101, buf);
    S10181C101 *dp, &lv = *(dp=new (buf) S10181C101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S10181C101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C101)");
    check_base_class_offset(lv, (S10180C17*)(S10181C68*), 0, "S10181C101");
    check_base_class_offset(lv, (S10181C68*), 0, "S10181C101");
    test_class_info(&lv, &cd_S10181C101);
    dp->~S10181C101();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C101(Test_S10181C101, "S10181C101", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN10S10181C101C1Ev();
extern void _ZN10S10181C101D1Ev();
Name_Map name_map_S10181C101[] = {
  NSPAIR(_ZN10S10181C101C1Ev),
  NSPAIR(_ZN10S10181C101D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10181C68;
extern VTBL_ENTRY _ZTI9S10181C68[];
extern  VTBL_ENTRY _ZTV9S10181C68[];
static Base_Class bases_S10181C101[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10181C68,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S10181C101[];
extern void _ZN10S10181C101D1Ev();
extern void _ZN10S10181C101D0Ev();
extern void _ZN9S10181C683v89Ev();
extern void _ZN9S10181C683v90Ev();
extern void _ZN9S10181C683v91Ev();
extern void _ZN9S10181C683v92Ev();
extern void _ZN10S10181C1014v199Ev();
extern void _ZN10S10181C1014v200Ev();
static  VTBL_ENTRY vtc_S10181C101[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S10181C101[0]),
  (VTBL_ENTRY)&_ZN10S10181C101D1Ev,
  (VTBL_ENTRY)&_ZN10S10181C101D0Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v89Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v90Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v91Ev,
  (VTBL_ENTRY)&_ZN9S10181C683v92Ev,
  (VTBL_ENTRY)&_ZN10S10181C1014v199Ev,
  (VTBL_ENTRY)&_ZN10S10181C1014v200Ev,
};
extern VTBL_ENTRY _ZTI10S10181C101[];
extern  VTBL_ENTRY _ZTV10S10181C101[];
Class_Descriptor cd_S10181C101 = {  "S10181C101", // class name
  bases_S10181C101, 2,
  &(vtc_S10181C101[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI10S10181C101),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S10181C101),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C16  : S10181C2 , S10180C17 , S10181C24 {
  void *s10181c16f0[5];
  ::S10181C25 s10181c16f1;
  ::S10180C78 s10181c16f2;
  ::S10179C87 s10181c16f3;
  ::S10181C101 s10181c16f4;
  void *s10181c16f5;
  char s10181c16f6;
  void *s10181c16f7;
  int s10181c16f8;
  virtual  ~S10181C16(); // _ZN9S10181C16D1Ev
  virtual void  v39(); // _ZN9S10181C163v39Ev
  virtual void  v40(); // _ZN9S10181C163v40Ev
  S10181C16(); // tgen
};
//SIG(-1 S10181C16) C1{ BC2{ vd v3} BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} BC7{ vd v4} vd v1 v2 Fp[5] FC8{ BC3 BC2 BC9{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 Fp FC10{ m FC11{ m Fp Fi FC5} Fi} FC12{ m Fi[4] Fp Fc Fi[2] Fp[2]}} BC13{ vd v51} BC14{ vd v52 v53} vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fi FC15{ m Fi[2]} FC15 FC15 FC16{ BC3 vd Fi Fp FC10 FL FC17{ m Fi[2]} Fi Fc Fi FC18{ m FC19{ m Fp Fi[2] FC6} Fp[2]}} FC20{ BC21{ vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fp FC10 FC12} vd v54 v55 v56} FC22{ vd m Fi Fp[3] FC23{ m Fc[2] Fp[3] Fi[4] FC24{ m FL[4]}}} FC25{ vd m FC24 Fi[2] FC26{ m FL[3] Fi[3] FL} FL FC27{ m Fi FC28{ m Fi[4]}} FC18 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC29{ BC3 BC7 vd v81 Fi FC30{ m Fc[2]} FC31{ Fp[2]} Fp FC32{ vd m FC33{ vd m FC34{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC35{ BC36{ vd v88 v89 v90 v91 v92 v93 Fi Fp Fc} vd v82 v83 v84 v85 v86 v87 Fp} FC37{ BC38{ vd v95 Fi Fc[3]} vd v94 Fp[4] FL Fi FC24 FC39{ m Fp FC40{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC41{ BC38 vd v96 FC24 Fi Fp[2] FC42{ m FC24 FC39 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC43{ BC38 vd v97 Fp[2] FL Fi[4] FC44{ m Fi[2]} FC24 FC45{ m FC24 FC39 Fp Fi[4]} FC46{ m Fp}} FC24 FC24 FL Fi[5]} FL FC47{ m FC26 FC48{ m Fi} Fi} Fc[128] FC15 FC18} Fi[3] FC49{ m Fp Fi[2]} FC50{ m Fc[11] Fi[2]} FC51{ BC52{} FL Fi} FC53{ BC54{ BC3 vd v100 v101 v102 v103 FC55{ m Fp FC10 FC11 FC11 Fi[3] FC56{ m FC57{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC10 FC10 Fc} Fp Fc Fi} v98 v99} FL FC58{ BC54 v104} FC59{ BC54 v105} FC60{ BC54 v106 v107} FC18 Fc} FC61{ BC62{ BC3 BC21 BC63{ vd v110} BC64{ BC65{ vd v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125} BC66{ vd m Fp}} BC67{ vd v126 v127} BC68{ vd v128} vd v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 Fp[5] Fi Fp FC69{ m Fi[2]} FC70{ m Fp} FC59 FC60 FC71{ BC54 v163} FC53 FC72{ BC54 v164 v165 v166 FC73{ Fp[3]} FC40[3]} FC74{ BC3 BC21 vd v167 v168 v169 v170 v171 v172 v173 v174 FC75{ m FC11 Fi[2] FC11} Fi[2] Fc[2] Fi FL[2] FC76{ m FL} Fi} FC77{ BC78{ BC3 BC21 vd v180 v181 v182 v183 v184 v185} BC63 vd v175 v176 v177 v178 v179 FC79{ m Fi Fp Fi FC56} FC19} FC80{ BC3 BC21 vd v186 v187 v188 v189 FC18 Fp[2] FC11 Fi} FC81{ BC3 BC21 BC63 BC64 BC67 BC68 vd v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 FC18 Fp[2] Fi[2] FC82{ BC3 vd v209 Fp FC10 FC10 Fp Fi FC56} FC60 FC53 FC53 FC56 FC56 FC56 Fi} FC83{ BC84{ BC3 BC21 BC63 vd v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 Fi[2] FC59 FC18 FC85{ BC54 v239 v240 v241 Fp[3]} FC58 FC53 FC60 FC86{ BC3 vd v242 v243 FC87{ BC88{ BC89{ m Fp FC56 FC56 Fi[3] Fc[2] Fi Fp} FC70 FC90{ m Fp} FC70 FC11 FC11 FC70 FC90 FC70 FC11 FC11 FC11 Fc Fi Fp} FC11} Fi} FC71 FC91{ BC58 v244} FC71 Fp FC90 Fp[2] Fi Fc[3] Fi FL[2]} vd v210 v211 v212 v213 v214 v215 FC46 FC92{ m Fp FC90 Fp[5] FC93{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC94{ m FC44 FC44} FC44 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC18 Fc[2] Fi FC95{ m Fc[5]} FC96{ m FC56 FC56 FC56 FC70 Fi Fc[2] Fi} FC56 FC56 FC56 Fp FC97{ BC3 vd FC98{ m Fp[3] FC69 FC11 FL[2] Fc} FC18} Fc[2] FL Fc[2] Fi FC90 FC99{ m FC100{ BC101{ m Fp Fi FC102{ m} FC102}} Fi} Fc Fi} vd v108 v109 Fc} FC103{ BC104{ BC3 vd v247 v248 v249 v250 FC55 Fp Fc Fi} v245 v246} FC105{ BC106{ BC3 vd v253 v254 v255 v256 FC55 Fp Fc Fi} v251 v252} Fp Fc Fp Fi}


 S10181C16 ::~S10181C16(){ note_dtor("S10181C16", this);}
void  S10181C16 ::v39(){vfunc_called(this, "_ZN9S10181C163v39Ev");}
void  S10181C16 ::v40(){vfunc_called(this, "_ZN9S10181C163v40Ev");}
S10181C16 ::S10181C16(){ note_ctor("S10181C16", this);} // tgen

static void Test_S10181C16()
{
  extern Class_Descriptor cd_S10181C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2918,5115)];
    init_test(&cd_S10181C16, buf);
    S10181C16 *dp, &lv = *(dp=new (buf) S10181C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(23336,20456), "sizeof(S10181C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C16)");
    check_base_class_offset(lv, (S10181C2*), 0, "S10181C16");
    check_base_class_offset(lv, (S10180C17*), ABISELECT(8,4), "S10181C16");
    check_base_class_offset(lv, (S10181C24*), ABISELECT(56,36), "S10181C16");
    check_field_offset(lv, s10181c16f0, ABISELECT(64,40), "S10181C16.s10181c16f0");
    check_field_offset(lv, s10181c16f1, ABISELECT(104,60), "S10181C16.s10181c16f1");
    check_field_offset(lv, s10181c16f2, ABISELECT(16392,15608), "S10181C16.s10181c16f2");
    check_field_offset(lv, s10181c16f3, ABISELECT(22840,20112), "S10181C16.s10181c16f3");
    check_field_offset(lv, s10181c16f4, ABISELECT(23072,20276), "S10181C16.s10181c16f4");
    check_field_offset(lv, s10181c16f5, ABISELECT(23304,20440), "S10181C16.s10181c16f5");
    check_field_offset(lv, s10181c16f6, ABISELECT(23312,20444), "S10181C16.s10181c16f6");
    check_field_offset(lv, s10181c16f7, ABISELECT(23320,20448), "S10181C16.s10181c16f7");
    check_field_offset(lv, s10181c16f8, ABISELECT(23328,20452), "S10181C16.s10181c16f8");
    test_class_info(&lv, &cd_S10181C16);
    dp->~S10181C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C16(Test_S10181C16, "S10181C16", ABISELECT(23336,20456));

#else // __cplusplus

extern void _ZN9S10181C16C1Ev();
extern void _ZN9S10181C16D1Ev();
Name_Map name_map_S10181C16[] = {
  NSPAIR(_ZN9S10181C16C1Ev),
  NSPAIR(_ZN9S10181C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10181C2;
extern VTBL_ENTRY _ZTI8S10181C2[];
extern  VTBL_ENTRY _ZTV8S10181C2[];
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S10181C24;
extern VTBL_ENTRY _ZTI9S10181C24[];
extern  VTBL_ENTRY _ZTV9S10181C24[];
static Base_Class bases_S10181C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10181C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10180C17,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10181C24,    ABISELECT(56,36), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10181C16[];
extern void _ZN9S10181C16D1Ev();
extern void _ZN9S10181C16D0Ev();
extern void _ZN8S10181C22v7Ev();
extern void _ZN9S10181C163v39Ev();
extern void _ZN9S10181C163v40Ev();
extern void ABISELECT(_ZThn8_N9S10181C16D1Ev,_ZThn4_N9S10181C16D1Ev)();
extern void ABISELECT(_ZThn8_N9S10181C16D0Ev,_ZThn4_N9S10181C16D0Ev)();
extern void ABISELECT(_ZThn56_N9S10181C16D1Ev,_ZThn36_N9S10181C16D1Ev)();
extern void ABISELECT(_ZThn56_N9S10181C16D0Ev,_ZThn36_N9S10181C16D0Ev)();
extern void _ZN9S10181C243v41Ev();
static  VTBL_ENTRY vtc_S10181C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10181C16[0]),
  (VTBL_ENTRY)&_ZN9S10181C16D1Ev,
  (VTBL_ENTRY)&_ZN9S10181C16D0Ev,
  (VTBL_ENTRY)&_ZN8S10181C22v7Ev,
  (VTBL_ENTRY)&_ZN9S10181C163v39Ev,
  (VTBL_ENTRY)&_ZN9S10181C163v40Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10181C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10181C16D1Ev,_ZThn4_N9S10181C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10181C16D0Ev,_ZThn4_N9S10181C16D0Ev),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S10181C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10181C16D1Ev,_ZThn36_N9S10181C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N9S10181C16D0Ev,_ZThn36_N9S10181C16D0Ev),
  (VTBL_ENTRY)&_ZN9S10181C243v41Ev,
};
extern VTBL_ENTRY _ZTI9S10181C16[];
extern  VTBL_ENTRY _ZTV9S10181C16[];
Class_Descriptor cd_S10181C16 = {  "S10181C16", // class name
  bases_S10181C16, 3,
  &(vtc_S10181C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(23336,20456), // object size
  NSPAIRA(_ZTI9S10181C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S10181C16),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10181C1  : S10181C2 , S10181C3 {
  ::S10180C4 s10181c1f0;
  ::S10180C9 s10181c1f1;
  void *s10181c1f2[3];
  ::S10180C10 s10181c1f3;
  ::S10181C16 s10181c1f4;
  ::S10180C129 s10181c1f5;
  ::S10181C101 s10181c1f6;
  ::S10179C87 s10181c1f7;
  ::S10180C176 s10181c1f8;
  ::S10180C13 s10181c1f9;
  ::S10180C178 s10181c1f10;
  int s10181c1f11;
  ::S10180C31 s10181c1f12;
  int s10181c1f13;
  ::S10180C179 s10181c1f14;
  ::S10180C179 s10181c1f15;
  ::S10180C179 s10181c1f16;
  virtual  ~S10181C1(); // _ZN8S10181C1D1Ev
  virtual void  v1(); // _ZN8S10181C12v1Ev
  virtual void  v2(); // _ZN8S10181C12v2Ev
  virtual void  v3(); // _ZN8S10181C12v3Ev
  virtual void  v4(); // _ZN8S10181C12v4Ev
  virtual void  v5(); // _ZN8S10181C12v5Ev
  virtual void  v6(); // _ZN8S10181C12v6Ev
  S10181C1(); // tgen
};
//SIG(1 S10181C1) C1{ BC2{ vd v7} BC3{ vd v8 v9 v10 v11 v12 Fp} vd v1 v2 v3 v4 v5 v6 FC4{ m Fp FC5{ BC6{ m Fp Fi FC7{ m} FC7}}} FC8{ m Fi Fp Fi[4] Fp} Fp[3] FC9{ BC10{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} FC14{ m Fi[4] Fp Fc Fi[2] Fp[2]}} vd v13 v14 FC11 Fp} FC15{ BC2 BC16{ vd m FC17{ m Fp Fi FC13 FC18{ m}} FC17 Fc} BC19{ vd v41} vd v39 v40 Fp[5] FC20{ BC16 BC2 BC21{ vd v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fp FC11 FC14} BC22{ vd v88} BC23{ vd v89 v90} vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 Fi FC24{ m Fi[2]} FC24 FC24 FC25{ BC16 vd Fi Fp FC11 FL FC26{ m Fi[2]} Fi Fc Fi FC27{ m FC28{ m Fp Fi[2] FC18} Fp[2]}} FC29{ BC10 vd v91 v92 v93} FC30{ vd m Fi Fp[3] FC31{ m Fc[2] Fp[3] Fi[4] FC32{ m FL[4]}}} FC33{ vd m FC32 Fi[2] FC34{ m FL[3] Fi[3] FL} FL FC35{ m Fi FC36{ m Fi[4]}} FC27 Fc[2] Fi[2] Fp[2] FL Fi[3]} Fi Fp FC37{ BC16 BC19 vd v94 Fi FC38{ m Fc[2]} FC39{ Fp[2]} Fp FC40{ vd m FC41{ vd m FC42{ Fi[8] Fs Fi[3] Fc} Fp[4] Fi Fp Fi Fp} FC43{ BC44{ vd v101 v102 v103 v104 v105 v106 Fi Fp Fc} vd v95 v96 v97 v98 v99 v100 Fp} FC45{ BC46{ vd v108 Fi Fc[3]} vd v107 Fp[4] FL Fi FC32 FC47{ m Fp FC48{ Fi[4]}} Fs[1024] Fi[4] FL[2] Fi FC49{ BC46 vd v109 FC32 Fi Fp[2] FC50{ m FC32 FC47 Fp Fi[5]} Fs[3585] Fc[4096] Fi}} FC51{ BC46 vd v110 Fp[2] FL Fi[4] FC52{ m Fi[2]} FC32 FC53{ m FC32 FC47 Fp Fi[4]} FC54{ m Fp}} FC32 FC32 FL Fi[5]} FL FC55{ m FC34 FC56{ m Fi} Fi} Fc[128] FC24 FC27} Fi[3] FC57{ m Fp Fi[2]} FC58{ m Fc[11] Fi[2]} FC59{ BC60{} FL Fi} FC61{ BC62{ BC16 vd v113 v114 v115 v116 FC63{ m Fp FC11 FC12 FC12 Fi[3] FC64{ m FC65{ m FL[2]}} Fc Fi Fi:8 Fi:24 FC11 FC11 Fc} Fp Fc Fi} v111 v112} FL FC66{ BC62 v117} FC67{ BC62 v118} FC68{ BC62 v119 v120} FC27 Fc} FC69{ BC70{ BC16 BC10 BC71{ vd v123} BC72{ BC73{ vd v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138} BC74{ vd m Fp}} BC75{ vd v139 v140} BC76{ vd v141} vd v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 Fp[5] Fi Fp FC77{ m Fi[2]} FC78{ m Fp} FC67 FC68 FC79{ BC62 v176} FC61 FC80{ BC62 v177 v178 v179 FC81{ Fp[3]} FC48[3]} FC82{ BC16 BC10 vd v180 v181 v182 v183 v184 v185 v186 v187 FC83{ m FC12 Fi[2] FC12} Fi[2] Fc[2] Fi FL[2] FC84{ m FL} Fi} FC85{ BC86{ BC16 BC10 vd v193 v194 v195 v196 v197 v198} BC71 vd v188 v189 v190 v191 v192 FC87{ m Fi Fp Fi FC64} FC28} FC88{ BC16 BC10 vd v199 v200 v201 v202 FC27 Fp[2] FC12 Fi} FC89{ BC16 BC10 BC71 BC72 BC75 BC76 vd v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 FC27 Fp[2] Fi[2] FC90{ BC16 vd v222 Fp FC11 FC11 Fp Fi FC64} FC68 FC61 FC61 FC64 FC64 FC64 Fi} FC91{ BC92{ BC16 BC10 BC71 vd v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 v251 Fi[2] FC67 FC27 FC93{ BC62 v252 v253 v254 Fp[3]} FC66 FC61 FC68 FC94{ BC16 vd v255 v256 FC95{ BC96{ BC97{ m Fp FC64 FC64 Fi[3] Fc[2] Fi Fp} FC78 FC98{ m Fp} FC78 FC12 FC12 FC78 FC98 FC78 FC12 FC12 FC12 Fc Fi Fp} FC12} Fi} FC79 FC99{ BC66 v257} FC79 Fp FC98 Fp[2] Fi Fc[3] Fi FL[2]} vd v223 v224 v225 v226 v227 v228 FC54 FC100{ m Fp FC98 Fp[5] FC101{ m Fp[2] Fi[2] Fp FL Fp[9] Fs Fp[2] FC102{ m FC52 FC52} FC52 Fc Fi[3] Fc Fi[6] Fc}} Fi} Fp FC27 Fc[2] Fi FC103{ m Fc[5]} FC104{ m FC64 FC64 FC64 FC78 Fi Fc[2] Fi} FC64 FC64 FC64 Fp FC105{ BC16 vd FC106{ m Fp[3] FC77 FC12 FL[2] Fc} FC27} Fc[2] FL Fc[2] Fi FC98 FC107{ m FC5 Fi} Fc Fi} vd v121 v122 Fc} FC108{ BC109{ BC16 vd v260 v261 v262 v263 FC63 Fp Fc Fi} v258 v259} FC110{ BC111{ BC16 vd v266 v267 v268 v269 FC63 Fp Fc Fi} v264 v265} Fp Fc Fp Fi} FC112{ BC71 BC16 vd v270 Fp[6] FC113{ BC16 BC10 BC71 vd v271 v272 v273 v274 v275 v276 v277 v278 FC27 Fp FC68 FC85 FC78 FC114{ vd v279 v280 FC115{ m Fp Fi[2] FC116{ m}} FC36[3] Fp[2] Fi Fc} FC117{ BC71 vd v281 Fp[2] FC118{ m Fp Fi FC116 FC119{ m}} FC120{ BC16 vd v282 v283 v284 v285 FC121{ m Fp[2] FC12 FC115 Fi[2]}}} FC90 FC122{ BC123{ BC124{ BC16 vd v295 v296 v297 v298 v299 v300 v301 v302 v303 v304 v305 v306 v307 v308 v309 v310 v311 v312 v313 v314 Fp[2] FC98 Fc[2] Fp FC125{ m FC64 FC64 FC126{ m FC84} FC126 FC64 FC64} FC11 Fp[4] FC27} vd v315 v316 v317 v318 v319 v320 v321 v322 v323 v324 v325 v326 v327 v328 v329 v330 v331 v332 v333 FC127{ vd m Fi[2] FC12 FC12 FC12 FC12 FC128{ m Fp[2]} FL[2]} Fp} vd v286 v287 v288 v289 v290 v291 v292 v293 v294 Fi[3]} FC129{ BC124 vd v334 v335 v336 v337 v338 v339 v340 v341 v342 v343 v344 v345 v346 v347 v348 v349 v350 v351 v352 FC127 Fp} FC130{ BC123 vd v353 v354} FC130 FC131{ BC124 vd v355 v356 v357 v358 v359 v360 v361 v362 v363 v364 v365 v366 Fi[2] FL Fi}[9] FC132{ BC123 vd v367 v368 v369} FC132 FC133{ BC123 vd v370 v371} FC134{ BC16 BC71 BC10 vd v372 v373 v374 v375 Fp FC117 FC90 FC68 FC79 Fp FL FC12} Fp Fi FC135{ m FL Fc FL[2] FC54} FC92 FC136{ BC16 BC10 BC71 vd v376 v377 v378 v379 v380 v381 Fi FC67 FC27 FC93 FC66 FC61 FC68 FC98 Fp[2] Fi} FC107 FC61 FC80 FC79 FC68 Fp FC137{ m Fp Fi[2] FC119} Fi FC138{ m FC27 FC139{ Fi FC140{ Fi[2] FL Fc}[9] Fi} FC12} Fp[2] Fi} FC70 FC141{ BC16 BC10 BC71 BC72 vd v382 v383 v384 v385 v386 v387 v388 v389 Fp[2] FC78 Fi[2] FC142{ BC143{ BC16 vd v395 v396 v397 v398 v399 Fp FC78 Fp[4] Fi} vd v390 v391 v392 v393 v394 Fp[2] Fi[4] FC78 FC24 FC24 Fc[2] FC78 FC126 Fi} Fp FC144{ BC16 BC10 vd v400 v401 v402 v403 v404 Fp FC145{ m FC137 Fi} Fi Fp Fc} Fc FC27 Fc[2]} FC146{ BC16 vd Fp} FC147{ BC16 BC10 vd v405 v406 v407 v408} FC61 Fp Fi Fp Fi} FC110 FC108 FC148{ BC149{ vd v417 v418 v419 v420 v421 v422 v423 v424} vd v409 v410 v411 v412 v413 v414 v415 v416 Fp[2]} FC12 FC150{ vd m Fi} Fi FC27 Fi FC151{ m Fp Fi} FC151 FC151}


 S10181C1 ::~S10181C1(){ note_dtor("S10181C1", this);}
void  S10181C1 ::v1(){vfunc_called(this, "_ZN8S10181C12v1Ev");}
void  S10181C1 ::v2(){vfunc_called(this, "_ZN8S10181C12v2Ev");}
void  S10181C1 ::v3(){vfunc_called(this, "_ZN8S10181C12v3Ev");}
void  S10181C1 ::v4(){vfunc_called(this, "_ZN8S10181C12v4Ev");}
void  S10181C1 ::v5(){vfunc_called(this, "_ZN8S10181C12v5Ev");}
void  S10181C1 ::v6(){vfunc_called(this, "_ZN8S10181C12v6Ev");}
S10181C1 ::S10181C1(){ note_ctor("S10181C1", this);} // tgen

static void Test_S10181C1()
{
  extern Class_Descriptor cd_S10181C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5557,8804)];
    init_test(&cd_S10181C1, buf);
    S10181C1 *dp, &lv = *(dp=new (buf) S10181C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(44448,35212), "sizeof(S10181C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10181C1)");
    check_base_class_offset(lv, (S10181C2*), 0, "S10181C1");
    check_base_class_offset(lv, (S10181C3*), ABISELECT(8,4), "S10181C1");
    check_field_offset(lv, s10181c1f0, ABISELECT(24,12), "S10181C1.s10181c1f0");
    check_field_offset(lv, s10181c1f1, ABISELECT(48,28), "S10181C1.s10181c1f1");
    check_field_offset(lv, s10181c1f2, ABISELECT(88,56), "S10181C1.s10181c1f2");
    check_field_offset(lv, s10181c1f3, ABISELECT(112,68), "S10181C1.s10181c1f3");
    check_field_offset(lv, s10181c1f4, ABISELECT(240,152), "S10181C1.s10181c1f4");
    check_field_offset(lv, s10181c1f5, ABISELECT(23576,20608), "S10181C1.s10181c1f5");
    check_field_offset(lv, s10181c1f6, ABISELECT(43824,34796), "S10181C1.s10181c1f6");
    check_field_offset(lv, s10181c1f7, ABISELECT(44056,34960), "S10181C1.s10181c1f7");
    check_field_offset(lv, s10181c1f8, ABISELECT(44288,35124), "S10181C1.s10181c1f8");
    check_field_offset(lv, s10181c1f9, ABISELECT(44312,35136), "S10181C1.s10181c1f9");
    check_field_offset(lv, s10181c1f10, ABISELECT(44328,35148), "S10181C1.s10181c1f10");
    check_field_offset(lv, s10181c1f11, ABISELECT(44344,35156), "S10181C1.s10181c1f11");
    check_field_offset(lv, s10181c1f12, ABISELECT(44352,35160), "S10181C1.s10181c1f12");
    check_field_offset(lv, s10181c1f13, ABISELECT(44392,35184), "S10181C1.s10181c1f13");
    check_field_offset(lv, s10181c1f14, ABISELECT(44400,35188), "S10181C1.s10181c1f14");
    check_field_offset(lv, s10181c1f15, ABISELECT(44416,35196), "S10181C1.s10181c1f15");
    check_field_offset(lv, s10181c1f16, ABISELECT(44432,35204), "S10181C1.s10181c1f16");
    test_class_info(&lv, &cd_S10181C1);
    dp->~S10181C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10181C1(Test_S10181C1, "S10181C1", ABISELECT(44448,35212));

#else // __cplusplus

extern void _ZN8S10181C1C1Ev();
extern void _ZN8S10181C1D1Ev();
Name_Map name_map_S10181C1[] = {
  NSPAIR(_ZN8S10181C1C1Ev),
  NSPAIR(_ZN8S10181C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10181C2;
extern VTBL_ENTRY _ZTI8S10181C2[];
extern  VTBL_ENTRY _ZTV8S10181C2[];
extern Class_Descriptor cd_S10181C3;
extern VTBL_ENTRY _ZTI8S10181C3[];
extern  VTBL_ENTRY _ZTV8S10181C3[];
static Base_Class bases_S10181C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10181C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10181C3,    ABISELECT(8,4), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10181C1[];
extern void _ZN8S10181C1D1Ev();
extern void _ZN8S10181C1D0Ev();
extern void _ZN8S10181C22v7Ev();
extern void _ZN8S10181C12v1Ev();
extern void _ZN8S10181C12v2Ev();
extern void _ZN8S10181C12v3Ev();
extern void _ZN8S10181C12v4Ev();
extern void _ZN8S10181C12v5Ev();
extern void _ZN8S10181C12v6Ev();
extern void ABISELECT(_ZThn8_N8S10181C1D1Ev,_ZThn4_N8S10181C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10181C1D0Ev,_ZThn4_N8S10181C1D0Ev)();
extern void _ZN8S10181C32v8Ev();
extern void _ZN8S10181C32v9Ev();
extern void _ZN8S10181C33v10Ev();
extern void _ZN8S10181C33v11Ev();
extern void _ZN8S10181C33v12Ev();
static  VTBL_ENTRY vtc_S10181C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10181C1[0]),
  (VTBL_ENTRY)&_ZN8S10181C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10181C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10181C22v7Ev,
  (VTBL_ENTRY)&_ZN8S10181C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10181C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10181C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10181C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10181C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10181C12v6Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10181C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10181C1D1Ev,_ZThn4_N8S10181C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10181C1D0Ev,_ZThn4_N8S10181C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10181C32v8Ev,
  (VTBL_ENTRY)&_ZN8S10181C32v9Ev,
  (VTBL_ENTRY)&_ZN8S10181C33v10Ev,
  (VTBL_ENTRY)&_ZN8S10181C33v11Ev,
  (VTBL_ENTRY)&_ZN8S10181C33v12Ev,
};
extern VTBL_ENTRY _ZTI8S10181C1[];
extern  VTBL_ENTRY _ZTV8S10181C1[];
Class_Descriptor cd_S10181C1 = {  "S10181C1", // class name
  bases_S10181C1, 2,
  &(vtc_S10181C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(44448,35212), // object size
  NSPAIRA(_ZTI8S10181C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10181C1),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7057C2_nt  {
  int s7057c2f0;
  __tsi64 s7057c2f1;
  void *s7057c2f2[4];
  int s7057c2f3[2];
  void *s7057c2f4;
  ::S10180C169 s7057c2f5;
  void *s7057c2f6[2];
  virtual  ~S7057C2_nt(); // _ZN10S7057C2_ntD1Ev
  virtual void  v6(); // _ZN10S7057C2_nt2v6Ev
  virtual void  v7(); // _ZN10S7057C2_nt2v7Ev
  virtual void  v8(); // _ZN10S7057C2_nt2v8Ev
  virtual void  v9(); // _ZN10S7057C2_nt2v9Ev
  virtual void  v10(); // _ZN10S7057C2_nt3v10Ev
  virtual void  v11(); // _ZN10S7057C2_nt3v11Ev
  virtual void  v12(); // _ZN10S7057C2_nt3v12Ev
  virtual void  v13(); // _ZN10S7057C2_nt3v13Ev
  virtual void  v14(); // _ZN10S7057C2_nt3v14Ev
  virtual void  v15(); // _ZN10S7057C2_nt3v15Ev
  virtual void  v16(); // _ZN10S7057C2_nt3v16Ev
  virtual void  v17(); // _ZN10S7057C2_nt3v17Ev
  virtual void  v18(); // _ZN10S7057C2_nt3v18Ev
  virtual void  v19(); // _ZN10S7057C2_nt3v19Ev
  virtual void  v20(); // _ZN10S7057C2_nt3v20Ev
  virtual void  v21(); // _ZN10S7057C2_nt3v21Ev
  virtual void  v22(); // _ZN10S7057C2_nt3v22Ev
  virtual void  v23(); // _ZN10S7057C2_nt3v23Ev
  virtual void  v24(); // _ZN10S7057C2_nt3v24Ev
  virtual void  v25(); // _ZN10S7057C2_nt3v25Ev
  virtual void  v26(); // _ZN10S7057C2_nt3v26Ev
  virtual void  v27(); // _ZN10S7057C2_nt3v27Ev
  virtual void  v28(); // _ZN10S7057C2_nt3v28Ev
  virtual void  v29(); // _ZN10S7057C2_nt3v29Ev
  virtual void  v30(); // _ZN10S7057C2_nt3v30Ev
  virtual void  v31(); // _ZN10S7057C2_nt3v31Ev
  virtual void  v32(); // _ZN10S7057C2_nt3v32Ev
  virtual void  v33(); // _ZN10S7057C2_nt3v33Ev
  virtual void  v34(); // _ZN10S7057C2_nt3v34Ev
  virtual void  v35(); // _ZN10S7057C2_nt3v35Ev
  virtual void  v36(); // _ZN10S7057C2_nt3v36Ev
  virtual void  v37(); // _ZN10S7057C2_nt3v37Ev
  virtual void  v38(); // _ZN10S7057C2_nt3v38Ev
  virtual void  v39(); // _ZN10S7057C2_nt3v39Ev
  virtual void  v40(); // _ZN10S7057C2_nt3v40Ev
  virtual void  v41(); // _ZN10S7057C2_nt3v41Ev
  virtual void  v42(); // _ZN10S7057C2_nt3v42Ev
  virtual void  v43(); // _ZN10S7057C2_nt3v43Ev
  virtual void  v44(); // _ZN10S7057C2_nt3v44Ev
  virtual void  v45(); // _ZN10S7057C2_nt3v45Ev
  virtual void  v46(); // _ZN10S7057C2_nt3v46Ev
  virtual void  v47(); // _ZN10S7057C2_nt3v47Ev
  virtual void  v48(); // _ZN10S7057C2_nt3v48Ev
  virtual void  v49(); // _ZN10S7057C2_nt3v49Ev
  virtual void  v50(); // _ZN10S7057C2_nt3v50Ev
  virtual void  v51(); // _ZN10S7057C2_nt3v51Ev
  virtual void  v52(); // _ZN10S7057C2_nt3v52Ev
  virtual void  v53(); // _ZN10S7057C2_nt3v53Ev
  virtual void  v54(); // _ZN10S7057C2_nt3v54Ev
  virtual void  v55(); // _ZN10S7057C2_nt3v55Ev
  virtual void  v56(); // _ZN10S7057C2_nt3v56Ev
  virtual void  v57(); // _ZN10S7057C2_nt3v57Ev
  virtual void  v58(); // _ZN10S7057C2_nt3v58Ev
  virtual void  v59(); // _ZN10S7057C2_nt3v59Ev
  virtual void  v60(); // _ZN10S7057C2_nt3v60Ev
  virtual void  v61(); // _ZN10S7057C2_nt3v61Ev
  virtual void  v62(); // _ZN10S7057C2_nt3v62Ev
  virtual void  v63(); // _ZN10S7057C2_nt3v63Ev
  virtual void  v64(); // _ZN10S7057C2_nt3v64Ev
  virtual void  v65(); // _ZN10S7057C2_nt3v65Ev
  virtual void  v66(); // _ZN10S7057C2_nt3v66Ev
  virtual void  v67(); // _ZN10S7057C2_nt3v67Ev
  virtual void  v68(); // _ZN10S7057C2_nt3v68Ev
  virtual void  v69(); // _ZN10S7057C2_nt3v69Ev
  S7057C2_nt(); // tgen
};
//SIG(-1 S7057C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S7057C2_nt ::~S7057C2_nt(){ note_dtor("S7057C2_nt", this);}
void  S7057C2_nt ::v6(){vfunc_called(this, "_ZN10S7057C2_nt2v6Ev");}
void  S7057C2_nt ::v7(){vfunc_called(this, "_ZN10S7057C2_nt2v7Ev");}
void  S7057C2_nt ::v8(){vfunc_called(this, "_ZN10S7057C2_nt2v8Ev");}
void  S7057C2_nt ::v9(){vfunc_called(this, "_ZN10S7057C2_nt2v9Ev");}
void  S7057C2_nt ::v10(){vfunc_called(this, "_ZN10S7057C2_nt3v10Ev");}
void  S7057C2_nt ::v11(){vfunc_called(this, "_ZN10S7057C2_nt3v11Ev");}
void  S7057C2_nt ::v12(){vfunc_called(this, "_ZN10S7057C2_nt3v12Ev");}
void  S7057C2_nt ::v13(){vfunc_called(this, "_ZN10S7057C2_nt3v13Ev");}
void  S7057C2_nt ::v14(){vfunc_called(this, "_ZN10S7057C2_nt3v14Ev");}
void  S7057C2_nt ::v15(){vfunc_called(this, "_ZN10S7057C2_nt3v15Ev");}
void  S7057C2_nt ::v16(){vfunc_called(this, "_ZN10S7057C2_nt3v16Ev");}
void  S7057C2_nt ::v17(){vfunc_called(this, "_ZN10S7057C2_nt3v17Ev");}
void  S7057C2_nt ::v18(){vfunc_called(this, "_ZN10S7057C2_nt3v18Ev");}
void  S7057C2_nt ::v19(){vfunc_called(this, "_ZN10S7057C2_nt3v19Ev");}
void  S7057C2_nt ::v20(){vfunc_called(this, "_ZN10S7057C2_nt3v20Ev");}
void  S7057C2_nt ::v21(){vfunc_called(this, "_ZN10S7057C2_nt3v21Ev");}
void  S7057C2_nt ::v22(){vfunc_called(this, "_ZN10S7057C2_nt3v22Ev");}
void  S7057C2_nt ::v23(){vfunc_called(this, "_ZN10S7057C2_nt3v23Ev");}
void  S7057C2_nt ::v24(){vfunc_called(this, "_ZN10S7057C2_nt3v24Ev");}
void  S7057C2_nt ::v25(){vfunc_called(this, "_ZN10S7057C2_nt3v25Ev");}
void  S7057C2_nt ::v26(){vfunc_called(this, "_ZN10S7057C2_nt3v26Ev");}
void  S7057C2_nt ::v27(){vfunc_called(this, "_ZN10S7057C2_nt3v27Ev");}
void  S7057C2_nt ::v28(){vfunc_called(this, "_ZN10S7057C2_nt3v28Ev");}
void  S7057C2_nt ::v29(){vfunc_called(this, "_ZN10S7057C2_nt3v29Ev");}
void  S7057C2_nt ::v30(){vfunc_called(this, "_ZN10S7057C2_nt3v30Ev");}
void  S7057C2_nt ::v31(){vfunc_called(this, "_ZN10S7057C2_nt3v31Ev");}
void  S7057C2_nt ::v32(){vfunc_called(this, "_ZN10S7057C2_nt3v32Ev");}
void  S7057C2_nt ::v33(){vfunc_called(this, "_ZN10S7057C2_nt3v33Ev");}
void  S7057C2_nt ::v34(){vfunc_called(this, "_ZN10S7057C2_nt3v34Ev");}
void  S7057C2_nt ::v35(){vfunc_called(this, "_ZN10S7057C2_nt3v35Ev");}
void  S7057C2_nt ::v36(){vfunc_called(this, "_ZN10S7057C2_nt3v36Ev");}
void  S7057C2_nt ::v37(){vfunc_called(this, "_ZN10S7057C2_nt3v37Ev");}
void  S7057C2_nt ::v38(){vfunc_called(this, "_ZN10S7057C2_nt3v38Ev");}
void  S7057C2_nt ::v39(){vfunc_called(this, "_ZN10S7057C2_nt3v39Ev");}
void  S7057C2_nt ::v40(){vfunc_called(this, "_ZN10S7057C2_nt3v40Ev");}
void  S7057C2_nt ::v41(){vfunc_called(this, "_ZN10S7057C2_nt3v41Ev");}
void  S7057C2_nt ::v42(){vfunc_called(this, "_ZN10S7057C2_nt3v42Ev");}
void  S7057C2_nt ::v43(){vfunc_called(this, "_ZN10S7057C2_nt3v43Ev");}
void  S7057C2_nt ::v44(){vfunc_called(this, "_ZN10S7057C2_nt3v44Ev");}
void  S7057C2_nt ::v45(){vfunc_called(this, "_ZN10S7057C2_nt3v45Ev");}
void  S7057C2_nt ::v46(){vfunc_called(this, "_ZN10S7057C2_nt3v46Ev");}
void  S7057C2_nt ::v47(){vfunc_called(this, "_ZN10S7057C2_nt3v47Ev");}
void  S7057C2_nt ::v48(){vfunc_called(this, "_ZN10S7057C2_nt3v48Ev");}
void  S7057C2_nt ::v49(){vfunc_called(this, "_ZN10S7057C2_nt3v49Ev");}
void  S7057C2_nt ::v50(){vfunc_called(this, "_ZN10S7057C2_nt3v50Ev");}
void  S7057C2_nt ::v51(){vfunc_called(this, "_ZN10S7057C2_nt3v51Ev");}
void  S7057C2_nt ::v52(){vfunc_called(this, "_ZN10S7057C2_nt3v52Ev");}
void  S7057C2_nt ::v53(){vfunc_called(this, "_ZN10S7057C2_nt3v53Ev");}
void  S7057C2_nt ::v54(){vfunc_called(this, "_ZN10S7057C2_nt3v54Ev");}
void  S7057C2_nt ::v55(){vfunc_called(this, "_ZN10S7057C2_nt3v55Ev");}
void  S7057C2_nt ::v56(){vfunc_called(this, "_ZN10S7057C2_nt3v56Ev");}
void  S7057C2_nt ::v57(){vfunc_called(this, "_ZN10S7057C2_nt3v57Ev");}
void  S7057C2_nt ::v58(){vfunc_called(this, "_ZN10S7057C2_nt3v58Ev");}
void  S7057C2_nt ::v59(){vfunc_called(this, "_ZN10S7057C2_nt3v59Ev");}
void  S7057C2_nt ::v60(){vfunc_called(this, "_ZN10S7057C2_nt3v60Ev");}
void  S7057C2_nt ::v61(){vfunc_called(this, "_ZN10S7057C2_nt3v61Ev");}
void  S7057C2_nt ::v62(){vfunc_called(this, "_ZN10S7057C2_nt3v62Ev");}
void  S7057C2_nt ::v63(){vfunc_called(this, "_ZN10S7057C2_nt3v63Ev");}
void  S7057C2_nt ::v64(){vfunc_called(this, "_ZN10S7057C2_nt3v64Ev");}
void  S7057C2_nt ::v65(){vfunc_called(this, "_ZN10S7057C2_nt3v65Ev");}
void  S7057C2_nt ::v66(){vfunc_called(this, "_ZN10S7057C2_nt3v66Ev");}
void  S7057C2_nt ::v67(){vfunc_called(this, "_ZN10S7057C2_nt3v67Ev");}
void  S7057C2_nt ::v68(){vfunc_called(this, "_ZN10S7057C2_nt3v68Ev");}
void  S7057C2_nt ::v69(){vfunc_called(this, "_ZN10S7057C2_nt3v69Ev");}
S7057C2_nt ::S7057C2_nt(){ note_ctor("S7057C2_nt", this);} // tgen

//skip512 S7057C2_nt

#else // __cplusplus

extern void _ZN10S7057C2_ntC1Ev();
extern void _ZN10S7057C2_ntD1Ev();
Name_Map name_map_S7057C2_nt[] = {
  NSPAIR(_ZN10S7057C2_ntC1Ev),
  NSPAIR(_ZN10S7057C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S7057C2_nt[];
extern void _ZN10S7057C2_ntD1Ev();
extern void _ZN10S7057C2_ntD0Ev();
extern void _ZN10S7057C2_nt2v6Ev();
extern void _ZN10S7057C2_nt2v7Ev();
extern void _ZN10S7057C2_nt2v8Ev();
extern void _ZN10S7057C2_nt2v9Ev();
extern void _ZN10S7057C2_nt3v10Ev();
extern void _ZN10S7057C2_nt3v11Ev();
extern void _ZN10S7057C2_nt3v12Ev();
extern void _ZN10S7057C2_nt3v13Ev();
extern void _ZN10S7057C2_nt3v14Ev();
extern void _ZN10S7057C2_nt3v15Ev();
extern void _ZN10S7057C2_nt3v16Ev();
extern void _ZN10S7057C2_nt3v17Ev();
extern void _ZN10S7057C2_nt3v18Ev();
extern void _ZN10S7057C2_nt3v19Ev();
extern void _ZN10S7057C2_nt3v20Ev();
extern void _ZN10S7057C2_nt3v21Ev();
extern void _ZN10S7057C2_nt3v22Ev();
extern void _ZN10S7057C2_nt3v23Ev();
extern void _ZN10S7057C2_nt3v24Ev();
extern void _ZN10S7057C2_nt3v25Ev();
extern void _ZN10S7057C2_nt3v26Ev();
extern void _ZN10S7057C2_nt3v27Ev();
extern void _ZN10S7057C2_nt3v28Ev();
extern void _ZN10S7057C2_nt3v29Ev();
extern void _ZN10S7057C2_nt3v30Ev();
extern void _ZN10S7057C2_nt3v31Ev();
extern void _ZN10S7057C2_nt3v32Ev();
extern void _ZN10S7057C2_nt3v33Ev();
extern void _ZN10S7057C2_nt3v34Ev();
extern void _ZN10S7057C2_nt3v35Ev();
extern void _ZN10S7057C2_nt3v36Ev();
extern void _ZN10S7057C2_nt3v37Ev();
extern void _ZN10S7057C2_nt3v38Ev();
extern void _ZN10S7057C2_nt3v39Ev();
extern void _ZN10S7057C2_nt3v40Ev();
extern void _ZN10S7057C2_nt3v41Ev();
extern void _ZN10S7057C2_nt3v42Ev();
extern void _ZN10S7057C2_nt3v43Ev();
extern void _ZN10S7057C2_nt3v44Ev();
extern void _ZN10S7057C2_nt3v45Ev();
extern void _ZN10S7057C2_nt3v46Ev();
extern void _ZN10S7057C2_nt3v47Ev();
extern void _ZN10S7057C2_nt3v48Ev();
extern void _ZN10S7057C2_nt3v49Ev();
extern void _ZN10S7057C2_nt3v50Ev();
extern void _ZN10S7057C2_nt3v51Ev();
extern void _ZN10S7057C2_nt3v52Ev();
extern void _ZN10S7057C2_nt3v53Ev();
extern void _ZN10S7057C2_nt3v54Ev();
extern void _ZN10S7057C2_nt3v55Ev();
extern void _ZN10S7057C2_nt3v56Ev();
extern void _ZN10S7057C2_nt3v57Ev();
extern void _ZN10S7057C2_nt3v58Ev();
extern void _ZN10S7057C2_nt3v59Ev();
extern void _ZN10S7057C2_nt3v60Ev();
extern void _ZN10S7057C2_nt3v61Ev();
extern void _ZN10S7057C2_nt3v62Ev();
extern void _ZN10S7057C2_nt3v63Ev();
extern void _ZN10S7057C2_nt3v64Ev();
extern void _ZN10S7057C2_nt3v65Ev();
extern void _ZN10S7057C2_nt3v66Ev();
extern void _ZN10S7057C2_nt3v67Ev();
extern void _ZN10S7057C2_nt3v68Ev();
extern void _ZN10S7057C2_nt3v69Ev();
static  VTBL_ENTRY vtc_S7057C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7057C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S7057C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI10S7057C2_nt[];
VTBL_ENTRY *P__ZTI10S7057C2_nt = _ZTI10S7057C2_nt; 
extern  VTBL_ENTRY _ZTV10S7057C2_nt[];
Class_Descriptor cd_S7057C2_nt = {  "S7057C2_nt", // class name
  0,0,//no base classes
  &(vtc_S7057C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S7057C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S7057C2_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7057C5_nt  : S10180C64 {
};
//SIG(-1 S7057C5_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S7057C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S10180C64;
static Base_Class bases_S7057C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C64,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S7057C5_nt = {  "S7057C5_nt", // class name
  bases_S7057C5_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7057C4_nt  : S7057C5_nt {
};
//SIG(-1 S7057C4_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S7057C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S10180C64;
extern Class_Descriptor cd_S7057C5_nt;
static Base_Class bases_S7057C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C64,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7057C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7057C1  : S7057C2_nt {
  ::S7057C4_nt s7057c1f0;
  virtual  ~S7057C1(); // _ZN7S7057C1D1Ev
  virtual void  v1(); // _ZN7S7057C12v1Ev
  virtual void  v2(); // _ZN7S7057C12v2Ev
  virtual void  v3(); // _ZN7S7057C12v3Ev
  virtual void  v4(); // _ZN7S7057C12v4Ev
  virtual void  v5(); // _ZN7S7057C12v5Ev
  S7057C1(); // tgen
};
//SIG(1 S7057C1) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 FC4{ BC5{ BC6{ m Fp Fi[2]}}}}


 S7057C1 ::~S7057C1(){ note_dtor("S7057C1", this);}
void  S7057C1 ::v1(){vfunc_called(this, "_ZN7S7057C12v1Ev");}
void  S7057C1 ::v2(){vfunc_called(this, "_ZN7S7057C12v2Ev");}
void  S7057C1 ::v3(){vfunc_called(this, "_ZN7S7057C12v3Ev");}
void  S7057C1 ::v4(){vfunc_called(this, "_ZN7S7057C12v4Ev");}
void  S7057C1 ::v5(){vfunc_called(this, "_ZN7S7057C12v5Ev");}
S7057C1 ::S7057C1(){ note_ctor("S7057C1", this);} // tgen

static void Test_S7057C1()
{
  extern Class_Descriptor cd_S7057C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S7057C1, buf);
    S7057C1 *dp, &lv = *(dp=new (buf) S7057C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S7057C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7057C1)");
    check_base_class_offset(lv, (S7057C2_nt*), 0, "S7057C1");
    check_field_offset(lv, s7057c1f0, ABISELECT(96,60), "S7057C1.s7057c1f0");
    test_class_info(&lv, &cd_S7057C1);
    dp->~S7057C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7057C1(Test_S7057C1, "S7057C1", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN7S7057C1C1Ev();
extern void _ZN7S7057C1D1Ev();
Name_Map name_map_S7057C1[] = {
  NSPAIR(_ZN7S7057C1C1Ev),
  NSPAIR(_ZN7S7057C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7057C2_nt;
extern VTBL_ENTRY _ZTI10S7057C2_nt[];
extern  VTBL_ENTRY _ZTV10S7057C2_nt[];
static Base_Class bases_S7057C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7057C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7057C1[];
extern void _ZN7S7057C1D1Ev();
extern void _ZN7S7057C1D0Ev();
extern void _ZN10S7057C2_nt2v6Ev();
extern void _ZN10S7057C2_nt2v7Ev();
extern void _ZN10S7057C2_nt2v8Ev();
extern void _ZN10S7057C2_nt2v9Ev();
extern void _ZN10S7057C2_nt3v10Ev();
extern void _ZN10S7057C2_nt3v11Ev();
extern void _ZN10S7057C2_nt3v12Ev();
extern void _ZN10S7057C2_nt3v13Ev();
extern void _ZN10S7057C2_nt3v14Ev();
extern void _ZN10S7057C2_nt3v15Ev();
extern void _ZN10S7057C2_nt3v16Ev();
extern void _ZN10S7057C2_nt3v17Ev();
extern void _ZN10S7057C2_nt3v18Ev();
extern void _ZN10S7057C2_nt3v19Ev();
extern void _ZN10S7057C2_nt3v20Ev();
extern void _ZN10S7057C2_nt3v21Ev();
extern void _ZN10S7057C2_nt3v22Ev();
extern void _ZN10S7057C2_nt3v23Ev();
extern void _ZN10S7057C2_nt3v24Ev();
extern void _ZN10S7057C2_nt3v25Ev();
extern void _ZN10S7057C2_nt3v26Ev();
extern void _ZN10S7057C2_nt3v27Ev();
extern void _ZN10S7057C2_nt3v28Ev();
extern void _ZN10S7057C2_nt3v29Ev();
extern void _ZN10S7057C2_nt3v30Ev();
extern void _ZN10S7057C2_nt3v31Ev();
extern void _ZN10S7057C2_nt3v32Ev();
extern void _ZN10S7057C2_nt3v33Ev();
extern void _ZN10S7057C2_nt3v34Ev();
extern void _ZN10S7057C2_nt3v35Ev();
extern void _ZN10S7057C2_nt3v36Ev();
extern void _ZN10S7057C2_nt3v37Ev();
extern void _ZN10S7057C2_nt3v38Ev();
extern void _ZN10S7057C2_nt3v39Ev();
extern void _ZN10S7057C2_nt3v40Ev();
extern void _ZN10S7057C2_nt3v41Ev();
extern void _ZN10S7057C2_nt3v42Ev();
extern void _ZN10S7057C2_nt3v43Ev();
extern void _ZN10S7057C2_nt3v44Ev();
extern void _ZN10S7057C2_nt3v45Ev();
extern void _ZN10S7057C2_nt3v46Ev();
extern void _ZN10S7057C2_nt3v47Ev();
extern void _ZN10S7057C2_nt3v48Ev();
extern void _ZN10S7057C2_nt3v49Ev();
extern void _ZN10S7057C2_nt3v50Ev();
extern void _ZN10S7057C2_nt3v51Ev();
extern void _ZN10S7057C2_nt3v52Ev();
extern void _ZN10S7057C2_nt3v53Ev();
extern void _ZN10S7057C2_nt3v54Ev();
extern void _ZN10S7057C2_nt3v55Ev();
extern void _ZN10S7057C2_nt3v56Ev();
extern void _ZN10S7057C2_nt3v57Ev();
extern void _ZN10S7057C2_nt3v58Ev();
extern void _ZN10S7057C2_nt3v59Ev();
extern void _ZN10S7057C2_nt3v60Ev();
extern void _ZN10S7057C2_nt3v61Ev();
extern void _ZN10S7057C2_nt3v62Ev();
extern void _ZN10S7057C2_nt3v63Ev();
extern void _ZN10S7057C2_nt3v64Ev();
extern void _ZN10S7057C2_nt3v65Ev();
extern void _ZN10S7057C2_nt3v66Ev();
extern void _ZN10S7057C2_nt3v67Ev();
extern void _ZN10S7057C2_nt3v68Ev();
extern void _ZN10S7057C2_nt3v69Ev();
extern void _ZN7S7057C12v1Ev();
extern void _ZN7S7057C12v2Ev();
extern void _ZN7S7057C12v3Ev();
extern void _ZN7S7057C12v4Ev();
extern void _ZN7S7057C12v5Ev();
static  VTBL_ENTRY vtc_S7057C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7057C1[0]),
  (VTBL_ENTRY)&_ZN7S7057C1D1Ev,
  (VTBL_ENTRY)&_ZN7S7057C1D0Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S7057C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN7S7057C12v1Ev,
  (VTBL_ENTRY)&_ZN7S7057C12v2Ev,
  (VTBL_ENTRY)&_ZN7S7057C12v3Ev,
  (VTBL_ENTRY)&_ZN7S7057C12v4Ev,
  (VTBL_ENTRY)&_ZN7S7057C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S7057C1[];
extern  VTBL_ENTRY _ZTV7S7057C1[];
Class_Descriptor cd_S7057C1 = {  "S7057C1", // class name
  bases_S7057C1, 1,
  &(vtc_S7057C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI7S7057C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S7057C1),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7934C9  {
  virtual  ~S7934C9(); // _ZN7S7934C9D1Ev
  virtual void  v2(); // _ZN7S7934C92v2Ev
  S7934C9(); // tgen
};
//SIG(-1 S7934C9) C1{ vd v1}


 S7934C9 ::~S7934C9(){ note_dtor("S7934C9", this);}
void  S7934C9 ::v2(){vfunc_called(this, "_ZN7S7934C92v2Ev");}
S7934C9 ::S7934C9(){ note_ctor("S7934C9", this);} // tgen

static void Test_S7934C9()
{
  extern Class_Descriptor cd_S7934C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S7934C9, buf);
    S7934C9 *dp, &lv = *(dp=new (buf) S7934C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S7934C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7934C9)");
    test_class_info(&lv, &cd_S7934C9);
    dp->~S7934C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7934C9(Test_S7934C9, "S7934C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S7934C9C1Ev();
extern void _ZN7S7934C9D1Ev();
Name_Map name_map_S7934C9[] = {
  NSPAIR(_ZN7S7934C9C1Ev),
  NSPAIR(_ZN7S7934C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7934C9[];
extern void _ZN7S7934C9D1Ev();
extern void _ZN7S7934C9D0Ev();
extern void _ZN7S7934C92v2Ev();
static  VTBL_ENTRY vtc_S7934C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7934C9[0]),
  (VTBL_ENTRY)&_ZN7S7934C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7934C9D0Ev,
  (VTBL_ENTRY)&_ZN7S7934C92v2Ev,
};
extern VTBL_ENTRY _ZTI7S7934C9[];
extern  VTBL_ENTRY _ZTV7S7934C9[];
Class_Descriptor cd_S7934C9 = {  "S7934C9", // class name
  0,0,//no base classes
  &(vtc_S7934C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S7934C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7934C9),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7934C12_nt  : S10180C17 , S7934C9 {
  ::S10180C136 s7934c12f0;
  ::S10180C136 s7934c12f1;
  ::S10180C18 s7934c12f2;
  char s7934c12f3[2];
  virtual  ~S7934C12_nt(); // _ZN11S7934C12_ntD1Ev
  virtual void  v3(); // _ZN11S7934C12_nt2v3Ev
  S7934C12_nt(); // tgen
};
//SIG(-1 S7934C12_nt) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v2} vd v1 FC7{ m Fp Fi FC8{ m} FC9{ m}} FC7 FC3 Fc[2]}


 S7934C12_nt ::~S7934C12_nt(){ note_dtor("S7934C12_nt", this);}
void  S7934C12_nt ::v3(){vfunc_called(this, "_ZN11S7934C12_nt2v3Ev");}
S7934C12_nt ::S7934C12_nt(){ note_ctor("S7934C12_nt", this);} // tgen

//skip512 S7934C12_nt

#else // __cplusplus

extern void _ZN11S7934C12_ntC1Ev();
extern void _ZN11S7934C12_ntD1Ev();
Name_Map name_map_S7934C12_nt[] = {
  NSPAIR(_ZN11S7934C12_ntC1Ev),
  NSPAIR(_ZN11S7934C12_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S7934C9;
extern VTBL_ENTRY _ZTI7S7934C9[];
extern  VTBL_ENTRY _ZTV7S7934C9[];
static Base_Class bases_S7934C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7934C9,    ABISELECT(48,32), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S7934C12_nt[];
extern void _ZN11S7934C12_ntD1Ev();
extern void _ZN11S7934C12_ntD0Ev();
extern void _ZN11S7934C12_nt2v3Ev();
extern void ABISELECT(_ZThn48_N11S7934C12_ntD1Ev,_ZThn32_N11S7934C12_ntD1Ev)();
extern void ABISELECT(_ZThn48_N11S7934C12_ntD0Ev,_ZThn32_N11S7934C12_ntD0Ev)();
extern void _ZN7S7934C92v2Ev();
static  VTBL_ENTRY vtc_S7934C12_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S7934C12_nt[0]),
  (VTBL_ENTRY)&_ZN11S7934C12_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S7934C12_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S7934C12_nt2v3Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI11S7934C12_nt[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N11S7934C12_ntD1Ev,_ZThn32_N11S7934C12_ntD1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N11S7934C12_ntD0Ev,_ZThn32_N11S7934C12_ntD0Ev),
  (VTBL_ENTRY)&_ZN7S7934C92v2Ev,
};
extern VTBL_ENTRY _ZTI11S7934C12_nt[];
VTBL_ENTRY *P__ZTI11S7934C12_nt = _ZTI11S7934C12_nt; 
extern  VTBL_ENTRY _ZTV11S7934C12_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7934C22_nt  {
  void *s7934c22f0;
  int s7934c22f1;
  ::S10180C138 s7934c22f2;
  ::S10180C133 s7934c22f3;
  void  mf7934c22(); // _ZN11S7934C22_nt9mf7934c22Ev
};
//SIG(-1 S7934C22_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S7934C22_nt ::mf7934c22(){}

//skip512 S7934C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7934C25_nt  {
  void *s7934c25f0;
  int s7934c25f1;
  __tsi64 s7934c25f2;
  int s7934c25f3;
  __tsi64 s7934c25f4;
  int s7934c25f5;
};
//SIG(-1 S7934C25_nt) C1{ Fp Fi FL Fi FL Fi}



//skip512 S7934C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7934C1  : S10180C17 , S7934C9 {
  int s7934c1f0;
  void *s7934c1f1[5];
  int s7934c1f2[2];
  ::S10179C93 s7934c1f3;
  char s7934c1f4;
  ::S10180C150 s7934c1f5;
  ::S10180C150 s7934c1f6;
  ::S10180C150 s7934c1f7;
  char s7934c1f8;
  ::S7934C12_nt s7934c1f9;
  void *s7934c1f10[3];
  ::S10180C6 s7934c1f11;
  void *s7934c1f12[3];
  __tsi64 s7934c1f13[3];
  char s7934c1f14[9];
  ::S7934C22_nt s7934c1f15;
  char s7934c1f16;
  ::S7934C25_nt s7934c1f17;
  int s7934c1f18;
  char s7934c1f19;
  int s7934c1f20[2];
  virtual  ~S7934C1(); // _ZN7S7934C1D1Ev
  virtual void  v1(); // _ZN7S7934C12v1Ev
  S7934C1(); // tgen
};
//SIG(1 S7934C1) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} BC6{ vd v2} vd v1 Fi Fp[5] Fi[2] FC7{ m Fl} Fc FC8{ m Fp[2]} FC8 FC8 Fc FC9{ BC2 BC6 vd v3 FC10{ m Fp Fi FC11{ m} FC12{ m}} FC10 FC3 Fc[2]} Fp[3] FC13{ m Fp Fi FC14{ m} FC14} Fp[3] FL[3] Fc[9] FC15{ m Fp Fi FC12 FC11} Fc FC16{ Fp Fi FL Fi FL Fi} Fi Fc Fi[2]}


 S7934C1 ::~S7934C1(){ note_dtor("S7934C1", this);}
void  S7934C1 ::v1(){vfunc_called(this, "_ZN7S7934C12v1Ev");}
S7934C1 ::S7934C1(){ note_ctor("S7934C1", this);} // tgen

static void Test_S7934C1()
{
  extern Class_Descriptor cd_S7934C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(62,80)];
    init_test(&cd_S7934C1, buf);
    S7934C1 *dp, &lv = *(dp=new (buf) S7934C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(488,316), "sizeof(S7934C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7934C1)");
    check_base_class_offset(lv, (S10180C17*), 0, "S7934C1");
    check_base_class_offset(lv, (S7934C9*), ABISELECT(48,32), "S7934C1");
    check_field_offset(lv, s7934c1f0, ABISELECT(56,36), "S7934C1.s7934c1f0");
    check_field_offset(lv, s7934c1f1, ABISELECT(64,40), "S7934C1.s7934c1f1");
    check_field_offset(lv, s7934c1f2, ABISELECT(104,60), "S7934C1.s7934c1f2");
    check_field_offset(lv, s7934c1f3, ABISELECT(112,68), "S7934C1.s7934c1f3");
    check_field_offset(lv, s7934c1f4, ABISELECT(120,72), "S7934C1.s7934c1f4");
    check_field_offset(lv, s7934c1f5, ABISELECT(128,76), "S7934C1.s7934c1f5");
    check_field_offset(lv, s7934c1f6, ABISELECT(144,84), "S7934C1.s7934c1f6");
    check_field_offset(lv, s7934c1f7, ABISELECT(160,92), "S7934C1.s7934c1f7");
    check_field_offset(lv, s7934c1f8, ABISELECT(176,100), "S7934C1.s7934c1f8");
    check_field_offset(lv, s7934c1f9, ABISELECT(184,104), "S7934C1.s7934c1f9");
    check_field_offset(lv, s7934c1f10, ABISELECT(296,180), "S7934C1.s7934c1f10");
    check_field_offset(lv, s7934c1f11, ABISELECT(320,192), "S7934C1.s7934c1f11");
    check_field_offset(lv, s7934c1f12, ABISELECT(336,204), "S7934C1.s7934c1f12");
    check_field_offset(lv, s7934c1f13, ABISELECT(360,216), "S7934C1.s7934c1f13");
    check_field_offset(lv, s7934c1f14, ABISELECT(384,240), "S7934C1.s7934c1f14");
    check_field_offset(lv, s7934c1f15, ABISELECT(400,252), "S7934C1.s7934c1f15");
    check_field_offset(lv, s7934c1f16, ABISELECT(416,264), "S7934C1.s7934c1f16");
    check_field_offset(lv, s7934c1f17, ABISELECT(424,268), "S7934C1.s7934c1f17");
    check_field_offset(lv, s7934c1f18, ABISELECT(472,300), "S7934C1.s7934c1f18");
    check_field_offset(lv, s7934c1f19, ABISELECT(476,304), "S7934C1.s7934c1f19");
    check_field_offset(lv, s7934c1f20, ABISELECT(480,308), "S7934C1.s7934c1f20");
    test_class_info(&lv, &cd_S7934C1);
    dp->~S7934C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7934C1(Test_S7934C1, "S7934C1", ABISELECT(488,316));

#else // __cplusplus

extern void _ZN7S7934C1C1Ev();
extern void _ZN7S7934C1D1Ev();
Name_Map name_map_S7934C1[] = {
  NSPAIR(_ZN7S7934C1C1Ev),
  NSPAIR(_ZN7S7934C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10180C17;
extern VTBL_ENTRY _ZTI9S10180C17[];
extern  VTBL_ENTRY _ZTV9S10180C17[];
extern Class_Descriptor cd_S7934C9;
extern VTBL_ENTRY _ZTI7S7934C9[];
extern  VTBL_ENTRY _ZTV7S7934C9[];
static Base_Class bases_S7934C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10180C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7934C9,    ABISELECT(48,32), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7934C1[];
extern void _ZN7S7934C1D1Ev();
extern void _ZN7S7934C1D0Ev();
extern void _ZN7S7934C12v1Ev();
extern void ABISELECT(_ZThn48_N7S7934C1D1Ev,_ZThn32_N7S7934C1D1Ev)();
extern void ABISELECT(_ZThn48_N7S7934C1D0Ev,_ZThn32_N7S7934C1D0Ev)();
extern void _ZN7S7934C92v2Ev();
static  VTBL_ENTRY vtc_S7934C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7934C1[0]),
  (VTBL_ENTRY)&_ZN7S7934C1D1Ev,
  (VTBL_ENTRY)&_ZN7S7934C1D0Ev,
  (VTBL_ENTRY)&_ZN7S7934C12v1Ev,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7S7934C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S7934C1D1Ev,_ZThn32_N7S7934C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S7934C1D0Ev,_ZThn32_N7S7934C1D0Ev),
  (VTBL_ENTRY)&_ZN7S7934C92v2Ev,
};
extern VTBL_ENTRY _ZTI7S7934C1[];
extern  VTBL_ENTRY _ZTV7S7934C1[];
Class_Descriptor cd_S7934C1 = {  "S7934C1", // class name
  bases_S7934C1, 2,
  &(vtc_S7934C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(488,316), // object size
  NSPAIRA(_ZTI7S7934C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7934C1),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C5_nt  {
  virtual void  v2(); // _ZN11S18992C5_nt2v2Ev
  virtual void  v3(); // _ZN11S18992C5_nt2v3Ev
  virtual void  v4(); // _ZN11S18992C5_nt2v4Ev
  virtual void  v5(); // _ZN11S18992C5_nt2v5Ev
  ~S18992C5_nt(); // tgen
  S18992C5_nt(); // tgen
};
//SIG(-1 S18992C5_nt) C1{ v1 v2 v3 v4}


void  S18992C5_nt ::v2(){vfunc_called(this, "_ZN11S18992C5_nt2v2Ev");}
void  S18992C5_nt ::v3(){vfunc_called(this, "_ZN11S18992C5_nt2v3Ev");}
void  S18992C5_nt ::v4(){vfunc_called(this, "_ZN11S18992C5_nt2v4Ev");}
void  S18992C5_nt ::v5(){vfunc_called(this, "_ZN11S18992C5_nt2v5Ev");}
S18992C5_nt ::~S18992C5_nt(){ note_dtor("S18992C5_nt", this);} // tgen
S18992C5_nt ::S18992C5_nt(){ note_ctor("S18992C5_nt", this);} // tgen

//skip512 S18992C5_nt

#else // __cplusplus

extern void _ZN11S18992C5_ntC1Ev();
extern void _ZN11S18992C5_ntD1Ev();
Name_Map name_map_S18992C5_nt[] = {
  NSPAIR(_ZN11S18992C5_ntC1Ev),
  NSPAIR(_ZN11S18992C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
static  VTBL_ENTRY vtc_S18992C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S18992C5_nt[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
};
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
VTBL_ENTRY *P__ZTI11S18992C5_nt = _ZTI11S18992C5_nt; 
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
Class_Descriptor cd_S18992C5_nt = {  "S18992C5_nt", // class name
  0,0,//no base classes
  &(vtc_S18992C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S18992C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S18992C5_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C4  : S18992C5_nt {
  virtual void  v6(); // _ZN8S18992C42v6Ev
  virtual void  v7(); // _ZN8S18992C42v7Ev
  ~S18992C4(); // tgen
  S18992C4(); // tgen
};
//SIG(-1 S18992C4) C1{ BC2{ v3 v4 v5 v6} v1 v2}


void  S18992C4 ::v6(){vfunc_called(this, "_ZN8S18992C42v6Ev");}
void  S18992C4 ::v7(){vfunc_called(this, "_ZN8S18992C42v7Ev");}
S18992C4 ::~S18992C4(){ note_dtor("S18992C4", this);} // tgen
S18992C4 ::S18992C4(){ note_ctor("S18992C4", this);} // tgen

static void Test_S18992C4()
{
  extern Class_Descriptor cd_S18992C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S18992C4, buf);
    S18992C4 *dp, &lv = *(dp=new (buf) S18992C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S18992C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18992C4)");
    check_base_class_offset(lv, (S18992C5_nt*), 0, "S18992C4");
    test_class_info(&lv, &cd_S18992C4);
    dp->~S18992C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C4(Test_S18992C4, "S18992C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S18992C4C1Ev();
extern void _ZN8S18992C4D1Ev();
Name_Map name_map_S18992C4[] = {
  NSPAIR(_ZN8S18992C4C1Ev),
  NSPAIR(_ZN8S18992C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
static Base_Class bases_S18992C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S18992C4[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
static  VTBL_ENTRY vtc_S18992C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C4[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
};
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
Class_Descriptor cd_S18992C4 = {  "S18992C4", // class name
  bases_S18992C4, 1,
  &(vtc_S18992C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S18992C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S18992C4),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C7_nt  {
  virtual void  v8(); // _ZN11S18992C7_nt2v8Ev
  ~S18992C7_nt(); // tgen
  S18992C7_nt(); // tgen
};
//SIG(-1 S18992C7_nt) C1{ v1}


void  S18992C7_nt ::v8(){vfunc_called(this, "_ZN11S18992C7_nt2v8Ev");}
S18992C7_nt ::~S18992C7_nt(){ note_dtor("S18992C7_nt", this);} // tgen
S18992C7_nt ::S18992C7_nt(){ note_ctor("S18992C7_nt", this);} // tgen

//skip512 S18992C7_nt

#else // __cplusplus

extern void _ZN11S18992C7_ntC1Ev();
extern void _ZN11S18992C7_ntD1Ev();
Name_Map name_map_S18992C7_nt[] = {
  NSPAIR(_ZN11S18992C7_ntC1Ev),
  NSPAIR(_ZN11S18992C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
extern void _ZN11S18992C7_nt2v8Ev();
static  VTBL_ENTRY vtc_S18992C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S18992C7_nt[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
};
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
VTBL_ENTRY *P__ZTI11S18992C7_nt = _ZTI11S18992C7_nt; 
extern  VTBL_ENTRY _ZTV11S18992C7_nt[];
Class_Descriptor cd_S18992C7_nt = {  "S18992C7_nt", // class name
  0,0,//no base classes
  &(vtc_S18992C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S18992C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S18992C7_nt),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C6  : S18992C7_nt {
  void *s18992c6f0;
  virtual void  v9(); // _ZN8S18992C62v9Ev
  virtual void  v10(); // _ZN8S18992C63v10Ev
  virtual void  v11(); // _ZN8S18992C63v11Ev
  virtual void  v12(); // _ZN8S18992C63v12Ev
  virtual void  v13(); // _ZN8S18992C63v13Ev
  virtual void  v14(); // _ZN8S18992C63v14Ev
  virtual void  v15(); // _ZN8S18992C63v15Ev
  ~S18992C6(); // tgen
  S18992C6(); // tgen
};
//SIG(-1 S18992C6) C1{ BC2{ v8} v1 v2 v3 v4 v5 v6 v7 Fp}


void  S18992C6 ::v9(){vfunc_called(this, "_ZN8S18992C62v9Ev");}
void  S18992C6 ::v10(){vfunc_called(this, "_ZN8S18992C63v10Ev");}
void  S18992C6 ::v11(){vfunc_called(this, "_ZN8S18992C63v11Ev");}
void  S18992C6 ::v12(){vfunc_called(this, "_ZN8S18992C63v12Ev");}
void  S18992C6 ::v13(){vfunc_called(this, "_ZN8S18992C63v13Ev");}
void  S18992C6 ::v14(){vfunc_called(this, "_ZN8S18992C63v14Ev");}
void  S18992C6 ::v15(){vfunc_called(this, "_ZN8S18992C63v15Ev");}
S18992C6 ::~S18992C6(){ note_dtor("S18992C6", this);} // tgen
S18992C6 ::S18992C6(){ note_ctor("S18992C6", this);} // tgen

static void Test_S18992C6()
{
  extern Class_Descriptor cd_S18992C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S18992C6, buf);
    S18992C6 *dp, &lv = *(dp=new (buf) S18992C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S18992C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18992C6)");
    check_base_class_offset(lv, (S18992C7_nt*), 0, "S18992C6");
    check_field_offset(lv, s18992c6f0, ABISELECT(8,4), "S18992C6.s18992c6f0");
    test_class_info(&lv, &cd_S18992C6);
    dp->~S18992C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C6(Test_S18992C6, "S18992C6", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S18992C6C1Ev();
extern void _ZN8S18992C6D1Ev();
Name_Map name_map_S18992C6[] = {
  NSPAIR(_ZN8S18992C6C1Ev),
  NSPAIR(_ZN8S18992C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C7_nt;
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
extern  VTBL_ENTRY _ZTV11S18992C7_nt[];
static Base_Class bases_S18992C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S18992C6[];
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY vtc_S18992C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C6[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern VTBL_ENTRY _ZTI8S18992C6[];
extern  VTBL_ENTRY _ZTV8S18992C6[];
Class_Descriptor cd_S18992C6 = {  "S18992C6", // class name
  bases_S18992C6, 1,
  &(vtc_S18992C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S18992C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S18992C6),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C3  : S18992C4 , virtual S18992C6 {
  char s18992c3f0[10];
  virtual  ~S18992C3(); // _ZN8S18992C3D2Ev
  virtual void  v16(); // _ZN8S18992C33v16Ev
  virtual void  v17(); // _ZN8S18992C33v17Ev
  S18992C3(); // tgen
};
//SIG(-1 S18992C3) C1{ BC2{ BC3{ v3 v4 v5 v6} v7 v8} VBC4{ BC5{ v9} v10 v11 v12 v13 v14 v15 v16 Fp} vd v1 v2 Fc[10]}


 S18992C3 ::~S18992C3(){ note_dtor("S18992C3", this);}
void  S18992C3 ::v16(){vfunc_called(this, "_ZN8S18992C33v16Ev");}
void  S18992C3 ::v17(){vfunc_called(this, "_ZN8S18992C33v17Ev");}
S18992C3 ::S18992C3(){ note_ctor("S18992C3", this);} // tgen

static void Test_S18992C3()
{
  extern Class_Descriptor cd_S18992C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S18992C3, buf);
    S18992C3 *dp, &lv = *(dp=new (buf) S18992C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S18992C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18992C3)");
    check_base_class_offset(lv, (S18992C5_nt*)(S18992C4*), 0, "S18992C3");
    check_base_class_offset(lv, (S18992C4*), 0, "S18992C3");
    check_base_class_offset(lv, (S18992C7_nt*)(S18992C6*), ABISELECT(24,16), "S18992C3");
    check_base_class_offset(lv, (S18992C6*), ABISELECT(24,16), "S18992C3");
    check_field_offset(lv, s18992c3f0, ABISELECT(8,4), "S18992C3.s18992c3f0");
    test_class_info(&lv, &cd_S18992C3);
    dp->~S18992C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C3(Test_S18992C3, "S18992C3", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S18992C3C1Ev();
extern void _ZN8S18992C3D2Ev();
Name_Map name_map_S18992C3[] = {
  NSPAIR(_ZN8S18992C3C1Ev),
  NSPAIR(_ZN8S18992C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C4;
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
extern Class_Descriptor cd_S18992C7_nt;
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
extern  VTBL_ENTRY _ZTV11S18992C7_nt[];
extern Class_Descriptor cd_S18992C6;
extern VTBL_ENTRY _ZTI8S18992C6[];
extern  VTBL_ENTRY _ZTV8S18992C6[];
static Base_Class bases_S18992C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S18992C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S18992C7_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S18992C6,    ABISELECT(24,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S18992C3[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void _ZN8S18992C3D1Ev();
extern void _ZN8S18992C3D0Ev();
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY vtc_S18992C3[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern VTBL_ENTRY _ZTV8S18992C3[];
static  VTT_ENTRY vtt_S18992C3[] = {
  {&(_ZTV8S18992C3[3]),  3,31},
  {&(_ZTV8S18992C3[23]),  23,31},
};
extern VTBL_ENTRY _ZTI8S18992C3[];
extern  VTBL_ENTRY _ZTV8S18992C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C3[];
Class_Descriptor cd_S18992C3 = {  "S18992C3", // class name
  bases_S18992C3, 4,
  &(vtc_S18992C3[0]), // expected_vtbl_contents
  &(vtt_S18992C3[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S18992C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S18992C3),31, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S18992C3),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C11  {
  void *s18992c11f0[2];
  virtual void  v43(); // _ZN9S18992C113v43Ev
  virtual void  v44(); // _ZN9S18992C113v44Ev
  virtual void  v45(); // _ZN9S18992C113v45Ev
  virtual void  v46(); // _ZN9S18992C113v46Ev
  virtual void  v47(); // _ZN9S18992C113v47Ev
  ~S18992C11(); // tgen
  S18992C11(); // tgen
};
//SIG(-1 S18992C11) C1{ v1 v2 v3 v4 v5 Fp[2]}


void  S18992C11 ::v43(){vfunc_called(this, "_ZN9S18992C113v43Ev");}
void  S18992C11 ::v44(){vfunc_called(this, "_ZN9S18992C113v44Ev");}
void  S18992C11 ::v45(){vfunc_called(this, "_ZN9S18992C113v45Ev");}
void  S18992C11 ::v46(){vfunc_called(this, "_ZN9S18992C113v46Ev");}
void  S18992C11 ::v47(){vfunc_called(this, "_ZN9S18992C113v47Ev");}
S18992C11 ::~S18992C11(){ note_dtor("S18992C11", this);} // tgen
S18992C11 ::S18992C11(){ note_ctor("S18992C11", this);} // tgen

static void Test_S18992C11()
{
  extern Class_Descriptor cd_S18992C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S18992C11, buf);
    S18992C11 *dp, &lv = *(dp=new (buf) S18992C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S18992C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18992C11)");
    check_field_offset(lv, s18992c11f0, ABISELECT(8,4), "S18992C11.s18992c11f0");
    test_class_info(&lv, &cd_S18992C11);
    dp->~S18992C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C11(Test_S18992C11, "S18992C11", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S18992C11C1Ev();
extern void _ZN9S18992C11D1Ev();
Name_Map name_map_S18992C11[] = {
  NSPAIR(_ZN9S18992C11C1Ev),
  NSPAIR(_ZN9S18992C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S18992C11[];
extern void _ZN9S18992C113v43Ev();
extern void _ZN9S18992C113v44Ev();
extern void _ZN9S18992C113v45Ev();
extern void _ZN9S18992C113v46Ev();
extern void _ZN9S18992C113v47Ev();
static  VTBL_ENTRY vtc_S18992C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S18992C11[0]),
  (VTBL_ENTRY)&_ZN9S18992C113v43Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v44Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v45Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v46Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v47Ev,
};
extern VTBL_ENTRY _ZTI9S18992C11[];
extern  VTBL_ENTRY _ZTV9S18992C11[];
Class_Descriptor cd_S18992C11 = {  "S18992C11", // class name
  0,0,//no base classes
  &(vtc_S18992C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S18992C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S18992C11),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C10  : S18992C11 {
  int s18992c10f0;
  virtual  ~S18992C10(); // _ZN9S18992C10D1Ev
  virtual void  v42(); // _ZN9S18992C103v42Ev
  S18992C10(); // tgen
};
//SIG(-1 S18992C10) C1{ BC2{ v2 v3 v4 v5 v6 Fp[2]} vd v1 Fi}


 S18992C10 ::~S18992C10(){ note_dtor("S18992C10", this);}
void  S18992C10 ::v42(){vfunc_called(this, "_ZN9S18992C103v42Ev");}
S18992C10 ::S18992C10(){ note_ctor("S18992C10", this);} // tgen

static void Test_S18992C10()
{
  extern Class_Descriptor cd_S18992C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S18992C10, buf);
    S18992C10 *dp, &lv = *(dp=new (buf) S18992C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S18992C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18992C10)");
    check_base_class_offset(lv, (S18992C11*), 0, "S18992C10");
    check_field_offset(lv, s18992c10f0, ABISELECT(24,12), "S18992C10.s18992c10f0");
    test_class_info(&lv, &cd_S18992C10);
    dp->~S18992C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C10(Test_S18992C10, "S18992C10", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN9S18992C10C1Ev();
extern void _ZN9S18992C10D1Ev();
Name_Map name_map_S18992C10[] = {
  NSPAIR(_ZN9S18992C10C1Ev),
  NSPAIR(_ZN9S18992C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C11;
extern VTBL_ENTRY _ZTI9S18992C11[];
extern  VTBL_ENTRY _ZTV9S18992C11[];
static Base_Class bases_S18992C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S18992C10[];
extern void _ZN9S18992C113v43Ev();
extern void _ZN9S18992C113v44Ev();
extern void _ZN9S18992C113v45Ev();
extern void _ZN9S18992C113v46Ev();
extern void _ZN9S18992C113v47Ev();
extern void _ZN9S18992C10D1Ev();
extern void _ZN9S18992C10D0Ev();
extern void _ZN9S18992C103v42Ev();
static  VTBL_ENTRY vtc_S18992C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S18992C10[0]),
  (VTBL_ENTRY)&_ZN9S18992C113v43Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v44Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v45Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v46Ev,
  (VTBL_ENTRY)&_ZN9S18992C113v47Ev,
  (VTBL_ENTRY)&_ZN9S18992C10D1Ev,
  (VTBL_ENTRY)&_ZN9S18992C10D0Ev,
  (VTBL_ENTRY)&_ZN9S18992C103v42Ev,
};
extern VTBL_ENTRY _ZTI9S18992C10[];
extern  VTBL_ENTRY _ZTV9S18992C10[];
Class_Descriptor cd_S18992C10 = {  "S18992C10", // class name
  bases_S18992C10, 1,
  &(vtc_S18992C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI9S18992C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S18992C10),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C9  : virtual S18992C3 {
  int s18992c9f0;
  ::S18992C10 s18992c9f1[9];
  virtual  ~S18992C9(); // _ZN8S18992C9D2Ev
  virtual void  v18(); // _ZN8S18992C93v18Ev
  virtual void  v19(); // _ZN8S18992C93v19Ev
  virtual void  v20(); // _ZN8S18992C93v20Ev
  virtual void  v21(); // _ZN8S18992C93v21Ev
  S18992C9(); // tgen
};
//SIG(-1 S18992C9) C1{ VBC2{ BC3{ BC4{ v5 v6 v7 v8} v9 v10} VBC5{ BC6{ v11} v12 v13 v14 v15 v16 v17 v18 Fp} vd v19 v20 Fc[10]} vd v1 v2 v3 v4 Fi FC7{ BC8{ v22 v23 v24 v25 v26 Fp[2]} vd v21 Fi}[9]}


 S18992C9 ::~S18992C9(){ note_dtor("S18992C9", this);}
void  S18992C9 ::v18(){vfunc_called(this, "_ZN8S18992C93v18Ev");}
void  S18992C9 ::v19(){vfunc_called(this, "_ZN8S18992C93v19Ev");}
void  S18992C9 ::v20(){vfunc_called(this, "_ZN8S18992C93v20Ev");}
void  S18992C9 ::v21(){vfunc_called(this, "_ZN8S18992C93v21Ev");}
S18992C9 ::S18992C9(){ note_ctor("S18992C9", this);} // tgen

static void Test_S18992C9()
{
  extern Class_Descriptor cd_S18992C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,45)];
    init_test(&cd_S18992C9, buf);
    S18992C9 *dp, &lv = *(dp=new (buf) S18992C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,176), "sizeof(S18992C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18992C9)");
    check_base_class_offset(lv, (S18992C5_nt*)(S18992C4*)(S18992C3*), ABISELECT(304,152), "S18992C9");
    check_base_class_offset(lv, (S18992C4*)(S18992C3*), ABISELECT(304,152), "S18992C9");
    check_base_class_offset(lv, (S18992C7_nt*)(S18992C6*), ABISELECT(328,168), "S18992C9");
    check_base_class_offset(lv, (S18992C6*)(S18992C3*), ABISELECT(328,168), "S18992C9");
    check_base_class_offset(lv, (S18992C3*), ABISELECT(304,152), "S18992C9");
    check_field_offset(lv, s18992c9f0, ABISELECT(8,4), "S18992C9.s18992c9f0");
    check_field_offset(lv, s18992c9f1, ABISELECT(16,8), "S18992C9.s18992c9f1");
    test_class_info(&lv, &cd_S18992C9);
    dp->~S18992C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C9(Test_S18992C9, "S18992C9", ABISELECT(344,176));

#else // __cplusplus

extern void _ZN8S18992C9C1Ev();
extern void _ZN8S18992C9D2Ev();
Name_Map name_map_S18992C9[] = {
  NSPAIR(_ZN8S18992C9C1Ev),
  NSPAIR(_ZN8S18992C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C4;
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
extern Class_Descriptor cd_S18992C7_nt;
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
extern  VTBL_ENTRY _ZTV11S18992C7_nt[];
extern Class_Descriptor cd_S18992C6;
extern VTBL_ENTRY _ZTI8S18992C6[];
extern  VTBL_ENTRY _ZTV8S18992C6[];
extern Class_Descriptor cd_S18992C3;
extern VTBL_ENTRY _ZTI8S18992C3[];
extern  VTBL_ENTRY _ZTV8S18992C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C3[];
static Base_Class bases_S18992C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C5_nt,    ABISELECT(304,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S18992C4,    ABISELECT(304,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S18992C7_nt,    ABISELECT(328,168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S18992C6,    ABISELECT(328,168), //bcp->offset
    32, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S18992C3,    ABISELECT(304,152), //bcp->offset
    10, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S18992C9[];
extern void _ZN8S18992C9D1Ev();
extern void _ZN8S18992C9D0Ev();
extern void _ZN8S18992C93v18Ev();
extern void _ZN8S18992C93v19Ev();
extern void _ZN8S18992C93v20Ev();
extern void _ZN8S18992C93v21Ev();
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev)();
extern void ABISELECT(_ZThn304_N8S18992C9D1Ev,_ZThn152_N8S18992C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev)();
extern void ABISELECT(_ZThn304_N8S18992C9D0Ev,_ZThn152_N8S18992C9D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY vtc_S18992C9[] = {
  ABISELECT(328,168),
  ABISELECT(304,152),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN8S18992C9D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C9D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v18Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v19Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v20Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v21Ev,
  0,
  0,
  ABISELECT(-304,-152),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  ABISELECT(-304,-152),
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-328,-168),
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern VTBL_ENTRY _ZTV8S18992C9[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void _ZN8S18992C3D1Ev();
extern void _ZN8S18992C3D0Ev();
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C3__8S18992C9[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C6__8S18992C3__8S18992C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
static  VTT_ENTRY vtt_S18992C9[] = {
  {&(_ZTV8S18992C9[4]),  4,50},
  {&(_ZTV8S18992C9[22]),  22,50},
  {&(_ZTV8S18992C9[42]),  42,50},
  {&(_tg__ZTV8S18992C3__8S18992C9[3]),  3,13},
  {&(_tg__ZTV8S18992C6__8S18992C3__8S18992C9[10]),  10,18},
};
extern VTBL_ENTRY _ZTI8S18992C9[];
extern  VTBL_ENTRY _ZTV8S18992C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C9[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S18992C9D0Ev,_ZThn152_N8S18992C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S18992C9D1Ev,_ZThn152_N8S18992C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S18992C9 = {  "S18992C9", // class name
  bases_S18992C9, 5,
  &(vtc_S18992C9[0]), // expected_vtbl_contents
  &(vtt_S18992C9[0]), // expected_vtt_contents
  ABISELECT(344,176), // object size
  NSPAIRA(_ZTI8S18992C9),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S18992C9),50, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S18992C9),5, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C8  : virtual S18992C9 {
  __tsi64 s18992c8f0;
  long s18992c8f1;
  virtual void  v22(); // _ZN8S18992C83v22Ev
  virtual void  v23(); // _ZN8S18992C83v23Ev
  virtual void  v24(); // _ZN8S18992C83v24Ev
  ~S18992C8(); // tgen
  S18992C8(); // tgen
};
//SIG(-1 S18992C8) C1{ VBC2{ VBC3{ BC4{ BC5{ v4 v5 v6 v7} v8 v9} VBC6{ BC7{ v10} v11 v12 v13 v14 v15 v16 v17 Fp} vd v18 v19 Fc[10]} vd v20 v21 v22 v23 Fi FC8{ BC9{ v25 v26 v27 v28 v29 Fp[2]} vd v24 Fi}[9]} v1 v2 v3 FL Fl}


void  S18992C8 ::v22(){vfunc_called(this, "_ZN8S18992C83v22Ev");}
void  S18992C8 ::v23(){vfunc_called(this, "_ZN8S18992C83v23Ev");}
void  S18992C8 ::v24(){vfunc_called(this, "_ZN8S18992C83v24Ev");}
S18992C8 ::~S18992C8(){ note_dtor("S18992C8", this);} // tgen
S18992C8 ::S18992C8(){ note_ctor("S18992C8", this);} // tgen

static void Test_S18992C8()
{
  extern Class_Descriptor cd_S18992C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,49)];
    init_test(&cd_S18992C8, buf);
    S18992C8 *dp, &lv = *(dp=new (buf) S18992C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,192), "sizeof(S18992C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18992C8)");
    check_base_class_offset(lv, (S18992C5_nt*)(S18992C4*)(S18992C3*), ABISELECT(328,168), "S18992C8");
    check_base_class_offset(lv, (S18992C4*)(S18992C3*), ABISELECT(328,168), "S18992C8");
    check_base_class_offset(lv, (S18992C7_nt*)(S18992C6*), ABISELECT(352,184), "S18992C8");
    check_base_class_offset(lv, (S18992C6*)(S18992C3*), ABISELECT(352,184), "S18992C8");
    check_base_class_offset(lv, (S18992C3*)(S18992C9*), ABISELECT(328,168), "S18992C8");
    check_base_class_offset(lv, (S18992C9*), ABISELECT(24,16), "S18992C8");
    check_field_offset(lv, s18992c8f0, ABISELECT(8,4), "S18992C8.s18992c8f0");
    check_field_offset(lv, s18992c8f1, ABISELECT(16,12), "S18992C8.s18992c8f1");
    test_class_info(&lv, &cd_S18992C8);
    dp->~S18992C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C8(Test_S18992C8, "S18992C8", ABISELECT(368,192));

#else // __cplusplus

extern void _ZN8S18992C8C1Ev();
extern void _ZN8S18992C8D1Ev();
Name_Map name_map_S18992C8[] = {
  NSPAIR(_ZN8S18992C8C1Ev),
  NSPAIR(_ZN8S18992C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C4;
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
extern Class_Descriptor cd_S18992C7_nt;
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
extern  VTBL_ENTRY _ZTV11S18992C7_nt[];
extern Class_Descriptor cd_S18992C6;
extern VTBL_ENTRY _ZTI8S18992C6[];
extern  VTBL_ENTRY _ZTV8S18992C6[];
extern Class_Descriptor cd_S18992C3;
extern VTBL_ENTRY _ZTI8S18992C3[];
extern  VTBL_ENTRY _ZTV8S18992C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C3[];
extern Class_Descriptor cd_S18992C9;
extern VTBL_ENTRY _ZTI8S18992C9[];
extern  VTBL_ENTRY _ZTV8S18992C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C9[];
static Base_Class bases_S18992C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C5_nt,    ABISELECT(328,168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S18992C4,    ABISELECT(328,168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S18992C7_nt,    ABISELECT(352,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S18992C6,    ABISELECT(352,184), //bcp->offset
    47, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S18992C3,    ABISELECT(328,168), //bcp->offset
    25, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S18992C9,    ABISELECT(24,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S18992C8[];
extern void _ZN8S18992C83v22Ev();
extern void _ZN8S18992C83v23Ev();
extern void _ZN8S18992C83v24Ev();
extern void _ZN8S18992C8D1Ev();
extern void _ZN8S18992C8D0Ev();
extern void ABISELECT(_ZTv0_n40_N8S18992C8D1Ev,_ZTv0_n20_N8S18992C8D1Ev)();
extern void ABISELECT(_ZThn24_N8S18992C8D1Ev,_ZThn16_N8S18992C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S18992C8D0Ev,_ZTv0_n20_N8S18992C8D0Ev)();
extern void ABISELECT(_ZThn24_N8S18992C8D0Ev,_ZThn16_N8S18992C8D0Ev)() __attribute__((weak));
extern void _ZN8S18992C93v18Ev();
extern void _ZN8S18992C93v19Ev();
extern void _ZN8S18992C93v20Ev();
extern void _ZN8S18992C93v21Ev();
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n80_N8S18992C8D1Ev,_ZTv0_n40_N8S18992C8D1Ev)();
extern void ABISELECT(_ZThn328_N8S18992C8D1Ev,_ZThn168_N8S18992C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S18992C8D0Ev,_ZTv0_n40_N8S18992C8D0Ev)();
extern void ABISELECT(_ZThn328_N8S18992C8D0Ev,_ZThn168_N8S18992C8D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY vtc_S18992C8[] = {
  ABISELECT(352,184),
  ABISELECT(328,168),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&_ZN8S18992C83v22Ev,
  (VTBL_ENTRY)&_ZN8S18992C83v23Ev,
  (VTBL_ENTRY)&_ZN8S18992C83v24Ev,
  (VTBL_ENTRY)&_ZN8S18992C8D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C8D0Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(328,168),
  ABISELECT(304,152),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S18992C8D1Ev,_ZTv0_n20_N8S18992C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S18992C8D0Ev,_ZTv0_n20_N8S18992C8D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C93v18Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v19Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v20Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v21Ev,
  0,
  0,
  ABISELECT(-328,-168),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  ABISELECT(-328,-168),
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C8D1Ev,_ZTv0_n40_N8S18992C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C8D0Ev,_ZTv0_n40_N8S18992C8D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-352,-184),
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern VTBL_ENTRY _ZTV8S18992C8[];
extern void _ZN8S18992C9D1Ev();
extern void _ZN8S18992C9D0Ev();
extern void _ZN8S18992C93v18Ev();
extern void _ZN8S18992C93v19Ev();
extern void _ZN8S18992C93v20Ev();
extern void _ZN8S18992C93v21Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C9__8S18992C8[] = {
  ABISELECT(328,168),
  ABISELECT(304,152),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN8S18992C9D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C9D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v18Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v19Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v20Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v21Ev,
};
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev)();
extern void ABISELECT(_ZThn304_N8S18992C9D1Ev,_ZThn152_N8S18992C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev)();
extern void ABISELECT(_ZThn304_N8S18992C9D0Ev,_ZThn152_N8S18992C9D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C3__8S18992C9__8S18992C8[] = {
  0,
  0,
  ABISELECT(-304,-152),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  ABISELECT(-304,-152),
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C6__8S18992C9__8S18992C8[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-328,-168),
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void _ZN8S18992C3D1Ev();
extern void _ZN8S18992C3D0Ev();
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C3__8S18992C8[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C6__8S18992C3__8S18992C8[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
static  VTT_ENTRY vtt_S18992C8[] = {
  {&(_ZTV8S18992C8[5]),  5,65},
  {&(_ZTV8S18992C8[19]),  19,65},
  {&(_ZTV8S18992C8[37]),  37,65},
  {&(_ZTV8S18992C8[57]),  57,65},
  {&(_tg__ZTV8S18992C9__8S18992C8[4]),  4,10},
  {&(_tg__ZTV8S18992C3__8S18992C9__8S18992C8[12]),  12,22},
  {&(_tg__ZTV8S18992C6__8S18992C9__8S18992C8[10]),  10,18},
  {&(_tg__ZTV8S18992C3__8S18992C8[3]),  3,13},
  {&(_tg__ZTV8S18992C6__8S18992C3__8S18992C8[10]),  10,18},
};
extern VTBL_ENTRY _ZTI8S18992C8[];
extern  VTBL_ENTRY _ZTV8S18992C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C8[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S18992C9D0Ev,_ZThn152_N8S18992C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S18992C9D1Ev,_ZThn152_N8S18992C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C8D0Ev,_ZTv0_n40_N8S18992C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S18992C8D0Ev,_ZThn168_N8S18992C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C8D1Ev,_ZTv0_n40_N8S18992C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S18992C8D1Ev,_ZThn168_N8S18992C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S18992C8D0Ev,_ZTv0_n20_N8S18992C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S18992C8D0Ev,_ZThn16_N8S18992C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S18992C8D1Ev,_ZTv0_n20_N8S18992C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S18992C8D1Ev,_ZThn16_N8S18992C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S18992C8 = {  "S18992C8", // class name
  bases_S18992C8, 6,
  &(vtc_S18992C8[0]), // expected_vtbl_contents
  &(vtt_S18992C8[0]), // expected_vtt_contents
  ABISELECT(368,192), // object size
  NSPAIRA(_ZTI8S18992C8),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S18992C8),65, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S18992C8),9, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C12  {
  __tsi64 s18992c12f0:11;
  void *s18992c12f1[9];
  int s18992c12f2;
  void *s18992c12f3;
  long double s18992c12f4;
  virtual void  v38(); // _ZN9S18992C123v38Ev
  virtual void  v39(); // _ZN9S18992C123v39Ev
  virtual void  v40(); // _ZN9S18992C123v40Ev
  virtual void  v41(); // _ZN9S18992C123v41Ev
  ~S18992C12(); // tgen
  S18992C12(); // tgen
};
//SIG(-1 S18992C12) C1{ v1 v2 v3 v4 FL:11 Fp[9] Fi Fp FD}


void  S18992C12 ::v38(){vfunc_called(this, "_ZN9S18992C123v38Ev");}
void  S18992C12 ::v39(){vfunc_called(this, "_ZN9S18992C123v39Ev");}
void  S18992C12 ::v40(){vfunc_called(this, "_ZN9S18992C123v40Ev");}
void  S18992C12 ::v41(){vfunc_called(this, "_ZN9S18992C123v41Ev");}
S18992C12 ::~S18992C12(){ note_dtor("S18992C12", this);} // tgen
S18992C12 ::S18992C12(){ note_ctor("S18992C12", this);} // tgen

static void Test_S18992C12()
{
  extern Class_Descriptor cd_S18992C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,17)];
    init_test(&cd_S18992C12, buf);
    S18992C12 *dp, &lv = *(dp=new (buf) S18992C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,64), "sizeof(S18992C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S18992C12)");
    set_bf_and_test(lv, s18992c12f0, ABISELECT(8,4), 0, 11, 1, "S18992C12");
    set_bf_and_test(lv, s18992c12f0, ABISELECT(8,4), 0, 11, hide_sll(1LL<<10), "S18992C12");
    check_field_offset(lv, s18992c12f1, ABISELECT(16,8), "S18992C12.s18992c12f1");
    check_field_offset(lv, s18992c12f2, ABISELECT(88,44), "S18992C12.s18992c12f2");
    check_field_offset(lv, s18992c12f3, ABISELECT(96,48), "S18992C12.s18992c12f3");
    check_field_offset(lv, s18992c12f4, ABISELECT(112,52), "S18992C12.s18992c12f4");
    test_class_info(&lv, &cd_S18992C12);
    dp->~S18992C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C12(Test_S18992C12, "S18992C12", ABISELECT(128,64));

#else // __cplusplus

extern void _ZN9S18992C12C1Ev();
extern void _ZN9S18992C12D1Ev();
Name_Map name_map_S18992C12[] = {
  NSPAIR(_ZN9S18992C12C1Ev),
  NSPAIR(_ZN9S18992C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S18992C12[];
extern void _ZN9S18992C123v38Ev();
extern void _ZN9S18992C123v39Ev();
extern void _ZN9S18992C123v40Ev();
extern void _ZN9S18992C123v41Ev();
static  VTBL_ENTRY vtc_S18992C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S18992C12[0]),
  (VTBL_ENTRY)&_ZN9S18992C123v38Ev,
  (VTBL_ENTRY)&_ZN9S18992C123v39Ev,
  (VTBL_ENTRY)&_ZN9S18992C123v40Ev,
  (VTBL_ENTRY)&_ZN9S18992C123v41Ev,
};
extern VTBL_ENTRY _ZTI9S18992C12[];
extern  VTBL_ENTRY _ZTV9S18992C12[];
Class_Descriptor cd_S18992C12 = {  "S18992C12", // class name
  0,0,//no base classes
  &(vtc_S18992C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,64), // object size
  NSPAIRA(_ZTI9S18992C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S18992C12),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C2  : S18992C3 , S18992C8 {
  ::S18992C12 s18992c2f0;
  void *s18992c2f1;
  virtual  ~S18992C2(); // _ZN8S18992C2D2Ev
  virtual void  v25(); // _ZN8S18992C23v25Ev
  virtual void  v26(); // _ZN8S18992C23v26Ev
  virtual void  v27(); // _ZN8S18992C23v27Ev
  virtual void  v28(); // _ZN8S18992C23v28Ev
  virtual void  v29(); // _ZN8S18992C23v29Ev
  virtual void  v30(); // _ZN8S18992C23v30Ev
  S18992C2(); // tgen
};
//SIG(-1 S18992C2) C1{ BC2{ BC3{ BC4{ v7 v8 v9 v10} v11 v12} VBC5{ BC6{ v13} v14 v15 v16 v17 v18 v19 v20 Fp} vd v21 v22 Fc[10]} BC7{ VBC8{ VBC2 vd v23 v24 v25 v26 Fi FC9{ BC10{ v35 v36 v37 v38 v39 Fp[2]} vd v34 Fi}[9]} v27 v28 v29 FL Fl} vd v1 v2 v3 v4 v5 v6 FC11{ v30 v31 v32 v33 FL:11 Fp[9] Fi Fp FD} Fp}


 S18992C2 ::~S18992C2(){ note_dtor("S18992C2", this);}
void  S18992C2 ::v25(){vfunc_called(this, "_ZN8S18992C23v25Ev");}
void  S18992C2 ::v26(){vfunc_called(this, "_ZN8S18992C23v26Ev");}
void  S18992C2 ::v27(){vfunc_called(this, "_ZN8S18992C23v27Ev");}
void  S18992C2 ::v28(){vfunc_called(this, "_ZN8S18992C23v28Ev");}
void  S18992C2 ::v29(){vfunc_called(this, "_ZN8S18992C23v29Ev");}
void  S18992C2 ::v30(){vfunc_called(this, "_ZN8S18992C23v30Ev");}
S18992C2 ::S18992C2(){ note_ctor("S18992C2", this);} // tgen

static void Test_S18992C2()
{
  extern Class_Descriptor cd_S18992C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(34,70)];
    init_test(&cd_S18992C2, buf);
    S18992C2 *dp, &lv = *(dp=new (buf) S18992C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(528,276), "sizeof(S18992C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S18992C2)");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C5_nt*)(S18992C4*)(S18992C3*), 0, "S18992C2");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C4*)(S18992C3*), 0, "S18992C2");
    check_base_class_offset(lv, (S18992C7_nt*)(S18992C6*), ABISELECT(184,100), "S18992C2");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C6*)(S18992C3*), ABISELECT(184,100), "S18992C2");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C6*)(S18992C3*), ABISELECT(184,100), "S18992C2");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C3*), 0, "S18992C2");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C5_nt*)(S18992C4*)(S18992C3*), ABISELECT(504,260), "S18992C2");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C4*)(S18992C3*), ABISELECT(504,260), "S18992C2");
    check_base_class_offset(lv, (S18992C3*)(S18992C9*), ABISELECT(504,260), "S18992C2");
    check_base_class_offset(lv, (S18992C9*)(S18992C8*), ABISELECT(200,108), "S18992C2");
    check_base_class_offset(lv, (S18992C8*), ABISELECT(24,16), "S18992C2");
    check_field_offset(lv, s18992c2f0, ABISELECT(48,32), "S18992C2.s18992c2f0");
    check_field_offset(lv, s18992c2f1, ABISELECT(176,96), "S18992C2.s18992c2f1");
    test_class_info(&lv, &cd_S18992C2);
    dp->~S18992C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C2(Test_S18992C2, "S18992C2", ABISELECT(528,276));

#else // __cplusplus

extern void _ZN8S18992C2C1Ev();
extern void _ZN8S18992C2D2Ev();
Name_Map name_map_S18992C2[] = {
  NSPAIR(_ZN8S18992C2C1Ev),
  NSPAIR(_ZN8S18992C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C4;
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
extern Class_Descriptor cd_S18992C7_nt;
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
extern  VTBL_ENTRY _ZTV11S18992C7_nt[];
extern Class_Descriptor cd_S18992C6;
extern VTBL_ENTRY _ZTI8S18992C6[];
extern  VTBL_ENTRY _ZTV8S18992C6[];
extern Class_Descriptor cd_S18992C3;
extern VTBL_ENTRY _ZTI8S18992C3[];
extern  VTBL_ENTRY _ZTV8S18992C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C3[];
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C4;
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
extern Class_Descriptor cd_S18992C3;
extern VTBL_ENTRY _ZTI8S18992C3[];
extern  VTBL_ENTRY _ZTV8S18992C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C3[];
extern Class_Descriptor cd_S18992C9;
extern VTBL_ENTRY _ZTI8S18992C9[];
extern  VTBL_ENTRY _ZTV8S18992C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C9[];
extern Class_Descriptor cd_S18992C8;
extern VTBL_ENTRY _ZTI8S18992C8[];
extern  VTBL_ENTRY _ZTV8S18992C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C8[];
static Base_Class bases_S18992C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S18992C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S18992C7_nt,    ABISELECT(184,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S18992C6,    ABISELECT(184,100), //bcp->offset
    31, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S18992C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S18992C5_nt,    ABISELECT(504,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S18992C4,    ABISELECT(504,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S18992C3,    ABISELECT(504,260), //bcp->offset
    64, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S18992C9,    ABISELECT(200,108), //bcp->offset
    49, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S18992C8,    ABISELECT(24,16), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S18992C2[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void _ZN8S18992C2D1Ev();
extern void _ZN8S18992C2D0Ev();
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
extern void _ZN8S18992C23v25Ev();
extern void _ZN8S18992C23v26Ev();
extern void _ZN8S18992C23v27Ev();
extern void _ZN8S18992C23v28Ev();
extern void _ZN8S18992C23v29Ev();
extern void _ZN8S18992C23v30Ev();
extern void _ZN8S18992C83v22Ev();
extern void _ZN8S18992C83v23Ev();
extern void _ZN8S18992C83v24Ev();
extern void ABISELECT(_ZThn24_N8S18992C2D1Ev,_ZThn16_N8S18992C2D1Ev)();
extern void ABISELECT(_ZThn24_N8S18992C2D0Ev,_ZThn16_N8S18992C2D0Ev)();
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
extern void ABISELECT(_ZTv0_n40_N8S18992C2D1Ev,_ZTv0_n20_N8S18992C2D1Ev)();
extern void ABISELECT(_ZThn200_N8S18992C2D1Ev,_ZThn108_N8S18992C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S18992C2D0Ev,_ZTv0_n20_N8S18992C2D0Ev)();
extern void ABISELECT(_ZThn200_N8S18992C2D0Ev,_ZThn108_N8S18992C2D0Ev)() __attribute__((weak));
extern void _ZN8S18992C93v18Ev();
extern void _ZN8S18992C93v19Ev();
extern void _ZN8S18992C93v20Ev();
extern void _ZN8S18992C93v21Ev();
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n80_N8S18992C2D1Ev,_ZTv0_n40_N8S18992C2D1Ev)();
extern void ABISELECT(_ZThn504_N8S18992C2D1Ev,_ZThn260_N8S18992C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S18992C2D0Ev,_ZTv0_n40_N8S18992C2D0Ev)();
extern void ABISELECT(_ZThn504_N8S18992C2D0Ev,_ZThn260_N8S18992C2D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY vtc_S18992C2[] = {
  ABISELECT(504,260),
  ABISELECT(200,108),
  ABISELECT(184,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C2[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&_ZN8S18992C2D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C2D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
  (VTBL_ENTRY)&_ZN8S18992C23v25Ev,
  (VTBL_ENTRY)&_ZN8S18992C23v26Ev,
  (VTBL_ENTRY)&_ZN8S18992C23v27Ev,
  (VTBL_ENTRY)&_ZN8S18992C23v28Ev,
  (VTBL_ENTRY)&_ZN8S18992C23v29Ev,
  (VTBL_ENTRY)&_ZN8S18992C23v30Ev,
  ABISELECT(160,84),
  ABISELECT(480,244),
  ABISELECT(176,92),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S18992C2[0]),
  (VTBL_ENTRY)&_ZN8S18992C83v22Ev,
  (VTBL_ENTRY)&_ZN8S18992C83v23Ev,
  (VTBL_ENTRY)&_ZN8S18992C83v24Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S18992C2D1Ev,_ZThn16_N8S18992C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S18992C2D0Ev,_ZThn16_N8S18992C2D0Ev),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-184,-100),
  (VTBL_ENTRY)&(_ZTI8S18992C2[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-200,-108),
  ABISELECT(-16,-8),
  ABISELECT(304,152),
  ABISELECT(-200,-108),
  (VTBL_ENTRY)&(_ZTI8S18992C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S18992C2D1Ev,_ZTv0_n20_N8S18992C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S18992C2D0Ev,_ZTv0_n20_N8S18992C2D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C93v18Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v19Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v20Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v21Ev,
  0,
  0,
  ABISELECT(-504,-260),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-320,-160),
  ABISELECT(-504,-260),
  (VTBL_ENTRY)&(_ZTI8S18992C2[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C2D1Ev,_ZTv0_n40_N8S18992C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C2D0Ev,_ZTv0_n40_N8S18992C2D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern VTBL_ENTRY _ZTV8S18992C2[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void _ZN8S18992C3D1Ev();
extern void _ZN8S18992C3D0Ev();
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C3__A__8S18992C2[] = {
  ABISELECT(184,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C6__8S18992C3__A__8S18992C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-184,-100),
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern void _ZN8S18992C83v22Ev();
extern void _ZN8S18992C83v23Ev();
extern void _ZN8S18992C83v24Ev();
extern void _ZN8S18992C8D1Ev();
extern void _ZN8S18992C8D0Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C8__8S18992C2[] = {
  ABISELECT(160,84),
  ABISELECT(480,244),
  ABISELECT(176,92),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&_ZN8S18992C83v22Ev,
  (VTBL_ENTRY)&_ZN8S18992C83v23Ev,
  (VTBL_ENTRY)&_ZN8S18992C83v24Ev,
  (VTBL_ENTRY)&_ZN8S18992C8D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C8D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S18992C8D1Ev,_ZTv0_n20_N8S18992C8D1Ev)();
extern void ABISELECT(_ZThn176_N8S18992C8D1Ev,_ZThn92_N8S18992C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S18992C8D0Ev,_ZTv0_n20_N8S18992C8D0Ev)();
extern void ABISELECT(_ZThn176_N8S18992C8D0Ev,_ZThn92_N8S18992C8D0Ev)() __attribute__((weak));
extern void _ZN8S18992C93v18Ev();
extern void _ZN8S18992C93v19Ev();
extern void _ZN8S18992C93v20Ev();
extern void _ZN8S18992C93v21Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C9__8S18992C8__8S18992C2[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-176,-92),
  ABISELECT(-16,-8),
  ABISELECT(304,152),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S18992C8D1Ev,_ZTv0_n20_N8S18992C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S18992C8D0Ev,_ZTv0_n20_N8S18992C8D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C93v18Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v19Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v20Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v21Ev,
};
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n80_N8S18992C8D1Ev,_ZTv0_n40_N8S18992C8D1Ev)();
extern void ABISELECT(_ZThn480_N8S18992C8D1Ev,_ZThn244_N8S18992C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S18992C8D0Ev,_ZTv0_n40_N8S18992C8D0Ev)();
extern void ABISELECT(_ZThn480_N8S18992C8D0Ev,_ZThn244_N8S18992C8D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C3__8S18992C8__8S18992C2[] = {
  0,
  0,
  ABISELECT(-480,-244),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-320,-160),
  ABISELECT(-480,-244),
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C8D1Ev,_ZTv0_n40_N8S18992C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C8D0Ev,_ZTv0_n40_N8S18992C8D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C6__8S18992C8__8S18992C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-160,-84),
  (VTBL_ENTRY)&(_ZTI8S18992C8[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern void _ZN8S18992C9D1Ev();
extern void _ZN8S18992C9D0Ev();
extern void _ZN8S18992C93v18Ev();
extern void _ZN8S18992C93v19Ev();
extern void _ZN8S18992C93v20Ev();
extern void _ZN8S18992C93v21Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C9__8S18992C2[] = {
  ABISELECT(-16,-8),
  ABISELECT(304,152),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN8S18992C9D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C9D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v18Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v19Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v20Ev,
  (VTBL_ENTRY)&_ZN8S18992C93v21Ev,
};
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev)();
extern void ABISELECT(_ZThn304_N8S18992C9D1Ev,_ZThn152_N8S18992C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev)();
extern void ABISELECT(_ZThn304_N8S18992C9D0Ev,_ZThn152_N8S18992C9D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C3__8S18992C9__8S18992C2[] = {
  0,
  0,
  ABISELECT(-304,-152),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-320,-160),
  ABISELECT(-304,-152),
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev),
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C6__8S18992C9__8S18992C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S18992C9[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void _ZN8S18992C3D1Ev();
extern void _ZN8S18992C3D0Ev();
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C3__A1__8S18992C2[] = {
  ABISELECT(-320,-160),
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v6Ev,
  (VTBL_ENTRY)&_ZN8S18992C42v7Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C3D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v16Ev,
  (VTBL_ENTRY)&_ZN8S18992C33v17Ev,
};
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
static  VTBL_ENTRY _tg__ZTV8S18992C6__8S18992C3__A1__8S18992C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(320,160),
  (VTBL_ENTRY)&(_ZTI8S18992C3[0]),
  (VTBL_ENTRY)&_ZN11S18992C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S18992C62v9Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v10Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v11Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v12Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v13Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v14Ev,
  (VTBL_ENTRY)&_ZN8S18992C63v15Ev,
};
static  VTT_ENTRY vtt_S18992C2[] = {
  {&(_ZTV8S18992C2[5]),  5,86},
  {&(_tg__ZTV8S18992C3__A__8S18992C2[3]),  3,13},
  {&(_tg__ZTV8S18992C6__8S18992C3__A__8S18992C2[10]),  10,18},
  {&(_tg__ZTV8S18992C8__8S18992C2[5]),  5,10},
  {&(_tg__ZTV8S18992C9__8S18992C8__8S18992C2[9]),  9,15},
  {&(_tg__ZTV8S18992C3__8S18992C8__8S18992C2[12]),  12,22},
  {&(_tg__ZTV8S18992C6__8S18992C8__8S18992C2[10]),  10,18},
  {&(_ZTV8S18992C2[41]),  41,86},
  {&(_ZTV8S18992C2[26]),  26,86},
  {&(_ZTV8S18992C2[58]),  58,86},
  {&(_ZTV8S18992C2[76]),  76,86},
  {&(_tg__ZTV8S18992C9__8S18992C2[4]),  4,10},
  {&(_tg__ZTV8S18992C3__8S18992C9__8S18992C2[12]),  12,22},
  {&(_tg__ZTV8S18992C6__8S18992C9__8S18992C2[10]),  10,18},
  {&(_tg__ZTV8S18992C3__A1__8S18992C2[3]),  3,13},
  {&(_tg__ZTV8S18992C6__8S18992C3__A1__8S18992C2[10]),  10,18},
};
extern VTBL_ENTRY _ZTI8S18992C2[];
extern  VTBL_ENTRY _ZTV8S18992C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C2[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C9D0Ev,_ZTv0_n40_N8S18992C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S18992C9D0Ev,_ZThn152_N8S18992C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C9D1Ev,_ZTv0_n40_N8S18992C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S18992C9D1Ev,_ZThn152_N8S18992C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C8D0Ev,_ZTv0_n40_N8S18992C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S18992C8D0Ev,_ZThn244_N8S18992C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C8D1Ev,_ZTv0_n40_N8S18992C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S18992C8D1Ev,_ZThn244_N8S18992C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S18992C8D0Ev,_ZTv0_n20_N8S18992C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S18992C8D0Ev,_ZThn92_N8S18992C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S18992C8D1Ev,_ZTv0_n20_N8S18992C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S18992C8D1Ev,_ZThn92_N8S18992C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C2D0Ev,_ZTv0_n40_N8S18992C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N8S18992C2D0Ev,_ZThn260_N8S18992C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S18992C2D1Ev,_ZTv0_n40_N8S18992C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N8S18992C2D1Ev,_ZThn260_N8S18992C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S18992C2D0Ev,_ZTv0_n20_N8S18992C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S18992C2D0Ev,_ZThn108_N8S18992C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S18992C2D1Ev,_ZTv0_n20_N8S18992C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S18992C2D1Ev,_ZThn108_N8S18992C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S18992C2 = {  "S18992C2", // class name
  bases_S18992C2, 10,
  &(vtc_S18992C2[0]), // expected_vtbl_contents
  &(vtt_S18992C2[0]), // expected_vtt_contents
  ABISELECT(528,276), // object size
  NSPAIRA(_ZTI8S18992C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S18992C2),86, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S18992C2),16, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C13  : virtual S18992C5_nt {
  int s18992c13f0;
  long double s18992c13f1;
  virtual void  v31(); // _ZN9S18992C133v31Ev
  virtual void  v32(); // _ZN9S18992C133v32Ev
  virtual void  v33(); // _ZN9S18992C133v33Ev
  virtual void  v34(); // _ZN9S18992C133v34Ev
  virtual void  v35(); // _ZN9S18992C133v35Ev
  virtual void  v36(); // _ZN9S18992C133v36Ev
  virtual void  v37(); // _ZN9S18992C133v37Ev
  ~S18992C13(); // tgen
  S18992C13(); // tgen
};
//SIG(-1 S18992C13) C1{ VBC2{ v8 v9 v10 v11} v1 v2 v3 v4 v5 v6 v7 Fi FD}


void  S18992C13 ::v31(){vfunc_called(this, "_ZN9S18992C133v31Ev");}
void  S18992C13 ::v32(){vfunc_called(this, "_ZN9S18992C133v32Ev");}
void  S18992C13 ::v33(){vfunc_called(this, "_ZN9S18992C133v33Ev");}
void  S18992C13 ::v34(){vfunc_called(this, "_ZN9S18992C133v34Ev");}
void  S18992C13 ::v35(){vfunc_called(this, "_ZN9S18992C133v35Ev");}
void  S18992C13 ::v36(){vfunc_called(this, "_ZN9S18992C133v36Ev");}
void  S18992C13 ::v37(){vfunc_called(this, "_ZN9S18992C133v37Ev");}
S18992C13 ::~S18992C13(){ note_dtor("S18992C13", this);} // tgen
S18992C13 ::S18992C13(){ note_ctor("S18992C13", this);} // tgen

static void Test_S18992C13()
{
  extern Class_Descriptor cd_S18992C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3,6)];
    init_test(&cd_S18992C13, buf);
    S18992C13 *dp, &lv = *(dp=new (buf) S18992C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S18992C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S18992C13)");
    check_base_class_offset(lv, (S18992C5_nt*), 0, "S18992C13");
    check_field_offset(lv, s18992c13f0, ABISELECT(8,4), "S18992C13.s18992c13f0");
    check_field_offset(lv, s18992c13f1, ABISELECT(16,8), "S18992C13.s18992c13f1");
    test_class_info(&lv, &cd_S18992C13);
    dp->~S18992C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C13(Test_S18992C13, "S18992C13", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN9S18992C13C1Ev();
extern void _ZN9S18992C13D1Ev();
Name_Map name_map_S18992C13[] = {
  NSPAIR(_ZN9S18992C13C1Ev),
  NSPAIR(_ZN9S18992C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
static Base_Class bases_S18992C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S18992C13[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN9S18992C133v31Ev();
extern void _ZN9S18992C133v32Ev();
extern void _ZN9S18992C133v33Ev();
extern void _ZN9S18992C133v34Ev();
extern void _ZN9S18992C133v35Ev();
extern void _ZN9S18992C133v36Ev();
extern void _ZN9S18992C133v37Ev();
static  VTBL_ENTRY vtc_S18992C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S18992C13[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S18992C133v31Ev,
  (VTBL_ENTRY)&_ZN9S18992C133v32Ev,
  (VTBL_ENTRY)&_ZN9S18992C133v33Ev,
  (VTBL_ENTRY)&_ZN9S18992C133v34Ev,
  (VTBL_ENTRY)&_ZN9S18992C133v35Ev,
  (VTBL_ENTRY)&_ZN9S18992C133v36Ev,
  (VTBL_ENTRY)&_ZN9S18992C133v37Ev,
};
extern VTBL_ENTRY _ZTV9S18992C13[];
static  VTT_ENTRY vtt_S18992C13[] = {
  {&(_ZTV9S18992C13[7]),  7,18},
  {&(_ZTV9S18992C13[7]),  7,18},
};
extern VTBL_ENTRY _ZTI9S18992C13[];
extern  VTBL_ENTRY _ZTV9S18992C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S18992C13[];
Class_Descriptor cd_S18992C13 = {  "S18992C13", // class name
  bases_S18992C13, 1,
  &(vtc_S18992C13[0]), // expected_vtbl_contents
  &(vtt_S18992C13[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI9S18992C13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S18992C13),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S18992C13),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18992C1  : virtual S18992C2 , virtual S18992C13 {
  virtual  ~S18992C1(); // _ZN8S18992C1D2Ev
  virtual void  v1(); // _ZN8S18992C12v1Ev
  S18992C1(); // tgen
};
//SIG(1 S18992C1) C1{ VBC2{ BC3{ BC4{ BC5{ v2 v3 v4 v5} v6 v7} VBC6{ BC7{ v8} v9 v10 v11 v12 v13 v14 v15 Fp} vd v16 v17 Fc[10]} BC8{ VBC9{ VBC3 vd v18 v19 v20 v21 Fi FC10{ BC11{ v43 v44 v45 v46 v47 Fp[2]} vd v42 Fi}[9]} v22 v23 v24 FL Fl} vd v25 v26 v27 v28 v29 v30 FC12{ v38 v39 v40 v41 FL:11 Fp[9] Fi Fp FD} Fp} VBC13{ VBC5 v31 v32 v33 v34 v35 v36 v37 Fi FD} vd v1}


 S18992C1 ::~S18992C1(){ note_dtor("S18992C1", this);}
void  S18992C1 ::v1(){vfunc_called(this, "_ZN8S18992C12v1Ev");}
S18992C1 ::S18992C1(){ note_ctor("S18992C1", this);} // tgen

static void Test_S18992C1()
{
  extern Class_Descriptor cd_S18992C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(37,76)];
    init_test(&cd_S18992C1, buf);
    S18992C1 *dp, &lv = *(dp=new (buf) S18992C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(576,300), "sizeof(S18992C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S18992C1)");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C5_nt*)(S18992C4*)(S18992C3*)(S18992C2*), ABISELECT(16,4), "S18992C1");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C4*)(S18992C3*)(S18992C2*), ABISELECT(16,4), "S18992C1");
    check_base_class_offset(lv, (S18992C7_nt*)(S18992C6*), ABISELECT(200,104), "S18992C1");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C6*)(S18992C3*)(S18992C2*), ABISELECT(200,104), "S18992C1");
    /*is_ambiguous_... S18992C1::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C6*)(S18992C3*), ABISELECT(200,104), "S18992C1");
    /*is_ambiguous_... S18992C2::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C3*)(S18992C2*), ABISELECT(16,4), "S18992C1");
    /*is_ambiguous_... S18992C1::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C5_nt*)(S18992C4*)(S18992C3*), ABISELECT(520,264), "S18992C1");
    /*is_ambiguous_... S18992C1::S18992C3 */ AMB_check_base_class_offset(lv, (S18992C4*)(S18992C3*), ABISELECT(520,264), "S18992C1");
    check_base_class_offset(lv, (S18992C3*)(S18992C9*), ABISELECT(520,264), "S18992C1");
    check_base_class_offset(lv, (S18992C9*)(S18992C8*)(S18992C2*), ABISELECT(216,112), "S18992C1");
    check_base_class_offset(lv, (S18992C8*)(S18992C2*), ABISELECT(40,20), "S18992C1");
    check_base_class_offset(lv, (S18992C2*), ABISELECT(16,4), "S18992C1");
    check_base_class_offset(lv, (S18992C5_nt*)(S18992C13*), 0, "S18992C1");
    check_base_class_offset(lv, (S18992C13*), ABISELECT(544,280), "S18992C1");
    test_class_info(&lv, &cd_S18992C1);
    dp->~S18992C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS18992C1(Test_S18992C1, "S18992C1", ABISELECT(576,300));

#else // __cplusplus

extern void _ZN8S18992C1C1Ev();
extern void _ZN8S18992C1D2Ev();
Name_Map name_map_S18992C1[] = {
  NSPAIR(_ZN8S18992C1C1Ev),
  NSPAIR(_ZN8S18992C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C4;
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
extern Class_Descriptor cd_S18992C7_nt;
extern VTBL_ENTRY _ZTI11S18992C7_nt[];
extern  VTBL_ENTRY _ZTV11S18992C7_nt[];
extern Class_Descriptor cd_S18992C6;
extern VTBL_ENTRY _ZTI8S18992C6[];
extern  VTBL_ENTRY _ZTV8S18992C6[];
extern Class_Descriptor cd_S18992C3;
extern VTBL_ENTRY _ZTI8S18992C3[];
extern  VTBL_ENTRY _ZTV8S18992C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C3[];
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C4;
extern VTBL_ENTRY _ZTI8S18992C4[];
extern  VTBL_ENTRY _ZTV8S18992C4[];
extern Class_Descriptor cd_S18992C3;
extern VTBL_ENTRY _ZTI8S18992C3[];
extern  VTBL_ENTRY _ZTV8S18992C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C3[];
extern Class_Descriptor cd_S18992C9;
extern VTBL_ENTRY _ZTI8S18992C9[];
extern  VTBL_ENTRY _ZTV8S18992C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C9[];
extern Class_Descriptor cd_S18992C8;
extern VTBL_ENTRY _ZTI8S18992C8[];
extern  VTBL_ENTRY _ZTV8S18992C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C8[];
extern Class_Descriptor cd_S18992C2;
extern VTBL_ENTRY _ZTI8S18992C2[];
extern  VTBL_ENTRY _ZTV8S18992C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S18992C2[];
extern Class_Descriptor cd_S18992C5_nt;
extern VTBL_ENTRY _ZTI11S18992C5_nt[];
extern  VTBL_ENTRY _ZTV11S18992C5_nt[];
extern Class_Descriptor cd_S18992C13;
extern VTBL_ENTRY _ZTI9S18992C13[];
extern  VTBL_ENTRY _ZTV9S18992C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S18992C13[];
static Base_Class bases_S18992C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S18992C5_nt,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S18992C4,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S18992C7_nt,    ABISELECT(200,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S18992C6,    ABISELECT(200,104), //bcp->offset
    68, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S18992C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S18992C5_nt,    ABISELECT(520,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S18992C4,    ABISELECT(520,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S18992C3,    ABISELECT(520,264), //bcp->offset
    101, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S18992C9,    ABISELECT(216,112), //bcp->offset
    86, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S18992C8,    ABISELECT(40,20), //bcp->offset
    58, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S18992C2,    ABISELECT(16,4), //bcp->offset
    19, //bcp->virtual_function_table_offset
    23, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S18992C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S18992C13,    ABISELECT(544,280), //bcp->offset
    123, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S18992C1[];
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C1D1Ev();
extern void _ZN8S18992C1D0Ev();
extern void _ZN8S18992C12v1Ev();
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n96_N8S18992C1D1Ev,_ZTv0_n48_N8S18992C1D1Ev)();
extern void ABISELECT(_ZThn16_N8S18992C1D1Ev,_ZThn4_N8S18992C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S18992C1D0Ev,_ZTv0_n48_N8S18992C1D0Ev)();
extern void ABISELECT(_ZThn16_N8S18992C1D0Ev,_ZThn4_N8S18992C1D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
extern void _ZN8S18992C23v25Ev();
extern void _ZN8S18992C23v26Ev();
extern void _ZN8S18992C23v27Ev();
extern void _ZN8S18992C23v28Ev();
extern void _ZN8S18992C23v29Ev();
extern void _ZN8S18992C23v30Ev();
extern void _ZN8S18992C83v22Ev();
extern void _ZN8S18992C83v23Ev();
extern void _ZN8S18992C83v24Ev();
extern void ABISELECT(_ZTvn24_n96_N8S18992C1D1Ev,_ZTvn16_n48_N8S18992C1D1Ev)();
extern void ABISELECT(_ZTvn24_n96_N8S18992C1D0Ev,_ZTvn16_n48_N8S18992C1D0Ev)();
extern void _ZN11S18992C7_nt2v8Ev();
extern void _ZN8S18992C62v9Ev();
extern void _ZN8S18992C63v10Ev();
extern void _ZN8S18992C63v11Ev();
extern void _ZN8S18992C63v12Ev();
extern void _ZN8S18992C63v13Ev();
extern void _ZN8S18992C63v14Ev();
extern void _ZN8S18992C63v15Ev();
extern void ABISELECT(_ZTv0_n40_N8S18992C1D1Ev,_ZTv0_n20_N8S18992C1D1Ev)();
extern void ABISELECT(_ZThn216_N8S18992C1D1Ev,_ZThn112_N8S18992C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S18992C1D0Ev,_ZTv0_n20_N8S18992C1D0Ev)();
extern void ABISELECT(_ZThn216_N8S18992C1D0Ev,_ZThn112_N8S18992C1D0Ev)() __attribute__((weak));
extern void _ZN8S18992C93v18Ev();
extern void _ZN8S18992C93v19Ev();
extern void _ZN8S18992C93v20Ev();
extern void _ZN8S18992C93v21Ev();
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN8S18992C42v6Ev();
extern void _ZN8S18992C42v7Ev();
extern void ABISELECT(_ZTv0_n80_N8S18992C1D1Ev,_ZTv0_n40_N8S18992C1D1Ev)();
extern void ABISELECT(_ZThn520_N8S18992C1D1Ev,_ZThn264_N8S18992C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S18992C1D0Ev,_ZTv0_n40_N8S18992C1D0Ev)();
extern void ABISELECT(_ZThn520_N8S18992C1D0Ev,_ZThn264_N8S18992C1D0Ev)() __attribute__((weak));
extern void _ZN8S18992C33v16Ev();
extern void _ZN8S18992C33v17Ev();
extern void _ZN11S18992C5_nt2v2Ev();
extern void _ZN11S18992C5_nt2v3Ev();
extern void _ZN11S18992C5_nt2v4Ev();
extern void _ZN11S18992C5_nt2v5Ev();
extern void _ZN9S18992C133v31Ev();
extern void _ZN9S18992C133v32Ev();
extern void _ZN9S18992C133v33Ev();
extern void _ZN9S18992C133v34Ev();
extern void _ZN9S18992C133v35Ev();
extern void _ZN9S18992C133v36Ev();
extern void _ZN9S18992C133v37Ev();
static  VTBL_ENTRY vtc_S18992C1[] = {
  0,
  ABISELECT(544,280),
  ABISELECT(520,264),
  ABISELECT(216,112),
  ABISELECT(200,104),
  ABISELECT(16,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S18992C1[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S18992C1D1Ev,
  (VTBL_ENTRY)&_ZN8S18992C1D0Ev,
  (VTBL_ENTRY)&_ZN8S18992C12v1Ev,
  ABISELECT(24,16),
  ABISELECT(24,16),
  ABISELECT(24,16),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-16,-4),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(504,260),
  ABISELECT(200,108),
  ABISELECT(184,100),
  ABISELECT(-16,-4),
  (VTBL_ENTRY)&(_ZTI8S18992C1[0]),
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S18992C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN