/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/mimetype.h>
        #include <wx/mimetype.h>
        #include <wx/mimetype.h>
    wxArrayString* _wxMimeTypesManager_EnumAllFileTypes(wxMimeTypesManager* self)
    {
        wxArrayString* arr = new wxArrayString;
        self->EnumAllFileTypes(*arr);
        return arr;
    }


PyDoc_STRVAR(doc_wxMimeTypesManager_AddFallbacks, "AddFallbacks(fallbacks)\n"
"\n"
"This function may be used to provide hard-wired fallbacks for the MIME\n"
"types and extensions that might not be present in the system MIME\n"
"database.");

extern "C" {static PyObject *meth_wxMimeTypesManager_AddFallbacks(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMimeTypesManager_AddFallbacks(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxFileTypeInfo* fallbacks;
         ::wxMimeTypesManager *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fallbacks,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxMimeTypesManager, &sipCpp, sipType_wxFileTypeInfo, &fallbacks))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddFallbacks(fallbacks);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MimeTypesManager, sipName_AddFallbacks, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMimeTypesManager_GetFileTypeFromExtension, "GetFileTypeFromExtension(extension) -> FileType\n"
"\n"
"Gather information about the files with given extension and return the\n"
"corresponding wxFileType object or NULL if the extension is unknown.");

extern "C" {static PyObject *meth_wxMimeTypesManager_GetFileTypeFromExtension(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMimeTypesManager_GetFileTypeFromExtension(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* extension;
        int extensionState = 0;
         ::wxMimeTypesManager *sipCpp;

        static const char *sipKwdList[] = {
            sipName_extension,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMimeTypesManager, &sipCpp, sipType_wxString, &extension, &extensionState))
        {
             ::wxFileType*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFileTypeFromExtension(*extension);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(extension), sipType_wxString, extensionState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFileType,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MimeTypesManager, sipName_GetFileTypeFromExtension, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMimeTypesManager_GetFileTypeFromMimeType, "GetFileTypeFromMimeType(mimeType) -> FileType\n"
"\n"
"Gather information about the files with given MIME type and return the\n"
"corresponding wxFileType object or NULL if the MIME type is unknown.");

extern "C" {static PyObject *meth_wxMimeTypesManager_GetFileTypeFromMimeType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMimeTypesManager_GetFileTypeFromMimeType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* mimeType;
        int mimeTypeState = 0;
         ::wxMimeTypesManager *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mimeType,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMimeTypesManager, &sipCpp, sipType_wxString, &mimeType, &mimeTypeState))
        {
             ::wxFileType*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFileTypeFromMimeType(*mimeType);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mimeType), sipType_wxString, mimeTypeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFileType,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MimeTypesManager, sipName_GetFileTypeFromMimeType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMimeTypesManager_Associate, "Associate(ftInfo) -> FileType\n"
"\n"
"Create a new association using the fields of wxFileTypeInfo (at least\n"
"the MIME type and the extension should be set).");

extern "C" {static PyObject *meth_wxMimeTypesManager_Associate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMimeTypesManager_Associate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxFileTypeInfo* ftInfo;
         ::wxMimeTypesManager *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ftInfo,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxMimeTypesManager, &sipCpp, sipType_wxFileTypeInfo, &ftInfo))
        {
             ::wxFileType*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Associate(*ftInfo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFileType,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MimeTypesManager, sipName_Associate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMimeTypesManager_Unassociate, "Unassociate(ft) -> bool\n"
"\n"
"Undo Associate().");

extern "C" {static PyObject *meth_wxMimeTypesManager_Unassociate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMimeTypesManager_Unassociate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxFileType* ft;
         ::wxMimeTypesManager *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ft,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxMimeTypesManager, &sipCpp, sipType_wxFileType, &ft))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Unassociate(ft);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MimeTypesManager, sipName_Unassociate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMimeTypesManager_EnumAllFileTypes, "EnumAllFileTypes() -> ArrayString\n"
"\n"
"Returns a list of all known file types.");

extern "C" {static PyObject *meth_wxMimeTypesManager_EnumAllFileTypes(PyObject *, PyObject *);}
static PyObject *meth_wxMimeTypesManager_EnumAllFileTypes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMimeTypesManager *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMimeTypesManager, &sipCpp))
        {
             ::wxArrayString*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMimeTypesManager_EnumAllFileTypes(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MimeTypesManager, sipName_EnumAllFileTypes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMimeTypesManager_IsOfType, "IsOfType(mimeType, wildcard) -> bool\n"
"\n"
"This function returns true if either the given mimeType is exactly the\n"
"same as wildcard or if it has the same category and the subtype of\n"
"wildcard is '*'.");

extern "C" {static PyObject *meth_wxMimeTypesManager_IsOfType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMimeTypesManager_IsOfType(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* mimeType;
        int mimeTypeState = 0;
        const  ::wxString* wildcard;
        int wildcardState = 0;

        static const char *sipKwdList[] = {
            sipName_mimeType,
            sipName_wildcard,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1J1", sipType_wxString, &mimeType, &mimeTypeState, sipType_wxString, &wildcard, &wildcardState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxMimeTypesManager::IsOfType(*mimeType,*wildcard);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mimeType), sipType_wxString, mimeTypeState);
            sipReleaseType(const_cast< ::wxString *>(wildcard), sipType_wxString, wildcardState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MimeTypesManager, sipName_IsOfType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxMimeTypesManager(void *, int);}
static void release_wxMimeTypesManager(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxMimeTypesManager *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxMimeTypesManager(Py_ssize_t);}
static void *array_wxMimeTypesManager(Py_ssize_t sipNrElem)
{
    return new  ::wxMimeTypesManager[sipNrElem];
}


extern "C" {static void dealloc_wxMimeTypesManager(sipSimpleWrapper *);}
static void dealloc_wxMimeTypesManager(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxMimeTypesManager(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxMimeTypesManager(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxMimeTypesManager(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxMimeTypesManager *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxMimeTypesManager();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxMimeTypesManager[] = {
    {sipName_AddFallbacks, SIP_MLMETH_CAST(meth_wxMimeTypesManager_AddFallbacks), METH_VARARGS|METH_KEYWORDS, doc_wxMimeTypesManager_AddFallbacks},
    {sipName_Associate, SIP_MLMETH_CAST(meth_wxMimeTypesManager_Associate), METH_VARARGS|METH_KEYWORDS, doc_wxMimeTypesManager_Associate},
    {sipName_EnumAllFileTypes, meth_wxMimeTypesManager_EnumAllFileTypes, METH_VARARGS, doc_wxMimeTypesManager_EnumAllFileTypes},
    {sipName_GetFileTypeFromExtension, SIP_MLMETH_CAST(meth_wxMimeTypesManager_GetFileTypeFromExtension), METH_VARARGS|METH_KEYWORDS, doc_wxMimeTypesManager_GetFileTypeFromExtension},
    {sipName_GetFileTypeFromMimeType, SIP_MLMETH_CAST(meth_wxMimeTypesManager_GetFileTypeFromMimeType), METH_VARARGS|METH_KEYWORDS, doc_wxMimeTypesManager_GetFileTypeFromMimeType},
    {sipName_IsOfType, SIP_MLMETH_CAST(meth_wxMimeTypesManager_IsOfType), METH_VARARGS|METH_KEYWORDS, doc_wxMimeTypesManager_IsOfType},
    {sipName_Unassociate, SIP_MLMETH_CAST(meth_wxMimeTypesManager_Unassociate), METH_VARARGS|METH_KEYWORDS, doc_wxMimeTypesManager_Unassociate}
};

PyDoc_STRVAR(doc_wxMimeTypesManager, "MimeTypesManager()\n"
"\n"
"This class allows the application to retrieve information about all\n"
"known MIME types from a system-specific location and the filename\n"
"extensions to the MIME types and vice versa.");


sipClassTypeDef sipTypeDef__core_wxMimeTypesManager = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxMimeTypesManager,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_MimeTypesManager,
        {0, 0, 1},
        7, methods_wxMimeTypesManager,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxMimeTypesManager,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxMimeTypesManager,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxMimeTypesManager,
    SIP_NULLPTR,
    array_wxMimeTypesManager,
    SIP_NULLPTR,
    release_wxMimeTypesManager,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
