WT_JS(
  let featureCheck = false;
  let currentUpload = null;

  onmessage = function(msg) {
    if (msg.data["cmd"] === "send") {
      if (featureCheck === false) {
        uploadFinished(null);
        return;
      }
      if (currentUpload)
        cancelCurrentUpload();

      send(msg.data["upload"], msg.data["url"], msg.data["chunksize"]);
    } else if (msg.data["cmd"] === "cancel") {
      if (currentUpload && (msg.data["upload"].id === currentUpload.id) ) {
        cancelCurrentUpload();
      }
    } else if (msg.data["cmd"] === "check") {
      featureCheck = runFeatureCheck();
      postMessage({"workerfeatures" : (featureCheck ? "valid" : "invalid")});
    } else {
      console.log("WFileDropWidget_worker received cmd: " + msg.data["cmd"]);
    }
  };

  var cancelCurrentUpload = function() {
    currentUpload.skip = true;
    if (currentUpload.request)
      currentUpload.request.abort();
    currentUpload = null;
  };

  var send = function(upload, url, chunksize) {
    currentUpload = upload;
    currentUpload.filtered = true;
    var filter = createFilter(upload, chunksize);

    var sendChunk = function(chunk) {
      if (chunk === null || chunk.upload === null || chunk.upload.id === null ||
          chunk.data === null || chunk.last === null) {
        console.error("File upload: chunk is missing properties, check the documentation for the correct format.");
        uploadFinished(null);
        return;
      }
      if (chunk.upload.skip) {
        uploadFinished(null);
        return;
      }

      var xhr = new XMLHttpRequest();
      chunk.upload.request = xhr;

      callback = chunk.last ? uploadFinished : chunkFinished;
      xhr.addEventListener("load", callback);
      xhr.addEventListener("error", callback);
      xhr.addEventListener("abort", callback);
      xhr.addEventListener("timeout", callback);

      xhr.open("POST", url);

      var fd = new FormData();
      fd.append("file-id", chunk.upload.id);
      fd.append("data", chunk.data);
      fd.append("last", chunk.last);
      fd.append("filtered", chunk.upload.filtered);
      xhr.send(fd);
    };

    var chunkFinished = function(e) {
      if (e != null &&
          e.type === 'load' &&
          e.currentTarget.status === 200) {
        filter(sendChunk);
      } else {
        uploadFinished(null);
      }
    };

    filter(sendChunk);
  };

  var uploadFinished = function(e) {
    var success = (e != null &&
                  e.type === 'load' &&
                  e.currentTarget.status === 200);
    postMessage(success);

    currentUpload = null;
  };

  var runFeatureCheck = function(e) {
    var reader = ( (!!self.FileReader) && (!!self.FileReaderSync) );
    var formData = !!self.FormData;
    return reader && formData;
  };

)
