[comment {-*- tcl -*- doctools manpage}]
[manpage_begin "Network configuration" n ""]
[copyright "2004-2014, Ashok P. Nadkarni"]
[moddesc "Network related commands"]
[titledesc "Commands related to network configuration"]
[require twapi_network]
[description]

[para]
This module provides procedures to retrieve network information
for IPv4 and IPv6.

[section Overview]

This module provides commands to retrieve various network-related
data for the local system including DNS and DHCP information,
type and configuration of network interfaces, traffic statistics and
various other information.

[para]
The module also provides some client side name resolution
lookup functions including nonblocking name and address lookups.

[para]
Some commands only support IPv4 due to lack of underlying Windows support
for the underlying Windows API on Windows XP and Windows 2003.
This is noted where applicable.

[section Commands]
[list_begin definitions]

[call [cmd flush_arp_tables] [opt "[arg INTERFACENAME]..."]]
[emph "Note: This command only affects IPv4 tables"]
[nl]
Flushes the ARP tables associated with the specified network interfaces.
If no arguments are specified, all interfaces are flushed.


[call [cmd get_arp_table] [opt [cmd -sort]]]
[emph "Note: This command only retrieves IPv4 tables"]
[nl]
Returns the entries in the system's ARP table. Each entry is a sublist
consisting of four elements - the interface index, the hardware address,
the IP address and the type. The type is one of [const dynamic],
[const static], [const other]  or [const invalid]. Note the hardware
address may be empty, for example when the associated interface is
the loopback adapter.
If option [cmd -sort] is specified,
returns the entries sorted by interface index, then 
IP address.

[call [cmd get_ipaddr_version] [arg IPADDR]]
Returns the IP version ([const 4] or [const 6]) of the IP address specified
as [arg IPADDR]. Returns [const 0] if [arg IPADDR] is not a valid IPv4 or
IPv6 address.

[call [cmd get_network_adapter_info] [arg NETWORKINTERFACE] [opt [arg options]]]

Returns various information about the configuration of a network interface.
[arg NETWORKINTERFACE] must be the name of a
network interface as returned by
[uri #get_network_adapters [cmd get_network_adapters]].

[nl]
The information returned
depends on the options specified and is in the form of a dictionary
whose keys depend on the options specified:

[nl]
The following options may be
specified:
[list_begin opt]
[opt_def [cmd -adaptername]]Returns the name of the adapter
associated with the interface.
[opt_def [cmd -all]] Returns all option values.
[opt_def [cmd -anycastaddresses]]Returns list of anycast addresses
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address. Other keys in the
dictionary should be ignored.
[opt_def [cmd -description]]Returns a description of the interface.
[opt_def [cmd -dhcpenabled]]Returns 1 if DHCP is enabled on the
interface, else 0.
[opt_def [cmd -dnsservers]]Returns a list of DNS servers on that interface.
Each element in the list is a dictionary, with the key [cmd -address]
containing the address of the server. Other keys in the
dictionary should be ignored.
[opt_def [cmd -dnssuffix]] Returns the DNS suffix for the adapter.
[opt_def [cmd -friendlyname]] Returns the friendly name of the adapter
suitable for display to users.
[opt_def [cmd -ipv4ifindex]]Returns the IP V4 interface index.
[opt_def [cmd -ipv6ifindex]]Returns the IP V6 interface index.
[opt_def [cmd -mtu]]Returns the MTU size for the adapter.
[opt_def [cmd -multicastaddresses]]Returns list of multicast addresses
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address. Other keys in
the dictionary should be ignored.
[opt_def [cmd -operstatus]]Returns the operational status of the interface
as defined in [uri http://www.ietf.org/rfc/rfc2863.txt RFC2863]. Some
common values are [const 1] (up),
[const 2] (down),
[const 3] (testing mode),
[const 4] (unknown state),
[const 5] (dormant),
[const 6] (not present),
[const 7] (lower layer is down).
[opt_def [cmd -physicaladdress]]Returns the physical address of the
network interface.
[opt_def [cmd -prefixes]]Returns list of address prefixes
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address and the key
[cmd -prefixlength] containing the number of bits in the prefix.
Other keys in the dictionary should be ignored.
[opt_def [cmd -type]] Returns the network interface type. This is an
integer value as defined by [uri http://www.iana.org/assignments/ianaiftype-mib.  IANA]. Some common values are [const 6] (Ethernet), [const 9] (token
ring), [const 23] (PPP), [const 24] (loopback), [const 71] (802.11 
wireless), [const 131] (tunneling) and [const 144] (IEEE 1394 Firewire).
[opt_def [cmd -unicastaddresses]]Returns list of unicast addresses
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address. Other keys in
the dictionary should be ignored.
[opt_def [cmd -zoneindices]] Returns list of IPv6 scope IDs.
[list_end]

[call [cmd get_network_info] [opt [arg options]]]
[emph "Note: This command only returns information related to IPv4 configuration."]
[nl]

Returns various information about network configuration.
The information returned
depends on the options specified and is in the form of a flat list of
the form "[arg option1] [arg value1] ...". The following options may be
specified:

[list_begin opt]
[opt_def [cmd -all]] Returns all values.
[opt_def [cmd -arpproxyenabled]] Returns 1 if ARP proxying is enabled and 0
otherwise.[opt_def [cmd -dhcpscopeid]] Returns the DHCP scope id.
[opt_def [cmd -dnsenabled]] Returns 1 if DNS name resolution is enabled
on the system and 0 otherwise.
[opt_def [cmd -dnsservers]] Returns a list of DNS server addresses used for
name resolution.
[opt_def [cmd -domain]] Returns the system domain.
[opt_def [cmd -hostname]] Returns the host name of the system.
[opt_def [cmd -routingenabled]] Returns 1 if routing is enabled on the system
and 0 otherwise.
[list_end]

[call [cmd get_network_adapters]]
Returns a list of network interface names.

[call [cmd get_network_adapters_detail]]
Returns a [uri base.html#recordarrays "record array"] containing
detailed information about all the network interfaces on the system.
The record array contains the following fields:
[list_begin opt]
[opt_def [cmd -adaptername]]
The name of the adapter.
[opt_def [cmd -anycastaddresses]]List of anycast addresses
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address. Other keys in the
dictionary should be ignored.
[opt_def [cmd -description]]Description of the interface.
[opt_def [cmd -dnsservers]]Returns a list of DNS servers on that interface.
Each element in the list is a dictionary, with the key [cmd -address]
containing the address of the server. Other keys in the
dictionary should be ignored.
[opt_def [cmd -dnssuffix]] The DNS suffix for the adapter.
[opt_def [cmd -flags]] Undocumented.
[opt_def [cmd -friendlyname]] The friendly name of the adapter.
[opt_def [cmd -ipv4ifindex]]The IP V4 interface index.
[opt_def [cmd -ipv6ifindex]]The IP V6 interface index.
[opt_def [cmd -mtu]]The MTU size for the adapter.
[opt_def [cmd -multicastaddresses]]Multicast addresses
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address. Other keys in
the dictionary should be ignored.
[opt_def [cmd -operstatus]]Operational status of the interface
as defined in [uri http://www.ietf.org/rfc/rfc2863.txt RFC2863]. Some
common values are [const 1] (up), [const 2] (down), [const 3] (testing mode),
[const 4] (unknown state), [const 5] (dormant), [const 6] (not present),
[const 7] (lower layer is down).
[opt_def [cmd -physicaladdress]]Physical address of the
network interface.
[opt_def [cmd -prefixes]]List of address prefixes
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address and the key
[cmd -prefixlength] containing the number of bits in the prefix.
Other keys in the dictionary should be ignored.
[opt_def [cmd -type]]Network interface type. This is an
integer value as defined by [uri http://www.iana.org/assignments/ianaiftype-mib.  IANA]. Some common values are [const 6] (Ethernet), [const 9] (token
ring), [const 23] (PPP), [const 24] (loopback), [const 71] (802.11 
wireless), [const 131] (tunneling) and [const 144] (IEEE 1394 Firewire).
[opt_def [cmd -unicastaddresses]]List of unicast addresses
associated with the interface. Each element in the list is a dictionary,
with the key [cmd -address] containing the address. Other keys in
the dictionary should be ignored.
[opt_def [cmd -zoneindices]]
List of IPv6 scope IDs.
[list_end]

[call [cmd get_outgoing_interface] [arg DESTADDR]]
[emph "Note: This command is only supported for IPv4."]
[nl]

Returns the index of the network interface that will be used to send
a packet to the IP address specified by [arg DESTADDR]


[call [cmd get_route] [opt [arg options]]]
[emph "Note: This command is only supported for IPv4."]
[nl]
Returns the best route to a specified destination. The following options
may be specified:
[list_begin opt]
[opt_def [cmd -dest] [arg DESTADDR]]
Specifies the destination address for which the route is to be returned.
If unspecified, defaults to [const 0.0.0.0] which corresponds to the
default route.
[opt_def [cmd -source] [arg SRCADDR]]
Specifies the source address to be used. This can affect the route
selected. Defaults to [const 0.0.0.0] which indicates the source
address should not affect which route is selected.
[list_end]
The returned information is a keyed list with the following fields:
[list_begin opt]
[opt_def [cmd -addr]]
The destination address that together with the [cmd -mask] field
specifies the address range to which the route applies.
[opt_def [cmd -age]]
The age of the route in seconds. This is valid only if the Routing and
Remote Access service is running and the protocol is [const netmgmt].
[opt_def [cmd -ifindex]]
The interface index for this route.
[opt_def [cmd -mask]]
The network mask that together with [cmd -dest] specifies the address
range to which the route applies.
[opt_def [cmd -metric1]]
A routing protocol specific metric value.
[opt_def [cmd -metric2]]
A routing protocol specific metric value.
[opt_def [cmd -metric3]]
A routing protocol specific metric value.
[opt_def [cmd -metric4]]
A routing protocol specific metric value.
[opt_def [cmd -metric5]]
A routing protocol specific metric value.
[opt_def [cmd -nexthop]]
The IP address of next hop in the route to the destination.
[opt_def [cmd -nexthopas]]
The autonomous system number of the next hop.
[opt_def [cmd -policy]]
Multi-path route selector condition, typically in IP TOS format as
defined in RFC 1354.
[opt_def [cmd -protocol]]
Protocol that generated the route.
[opt_def [cmd -type]]
The type of the route. This is one of [const local], [const remote],
[const other] or [const invalid].
[list_end]

[call [cmd get_routing_table] [opt [cmd -sort]]]
[emph "Note: This command is only returns routing information for IPv4."]
[nl]
Returns the network routing table as a list of routes. Each element
of the route is in the format described in the
[uri \#get_route [cmd get_route]] command description.

[call [cmd get_system_ipaddrs] [opt "[cmd -ipversion] [arg IPVERSION]"] [opt "[cmd -types] [arg ADDRTYPELIST]"]]

Returns a list of IP addresses for the system. 
[nl]
If [cmd -ipversion] is
not specified, or [arg IPVERSION] is [const 0], [const any] or [const all], both
IPv4 and IPv6 addresses are returned. If [arg IPVERSION] is [const 4] or
[const inet], only IPv4 addresses are returned and if it is [const 6] or
[const inet6], only IPv6 addresses are returned.
[nl]
By default, only unicast addresses are returned. If the [cmd -types] option
is specified, [arg ADDRTYPELIST] should be a list of one or more of the 
following: [const all], [const unicast], [const multicast] or [const anycast].
In that case, only addresses matching one of those types 
(or all types in the case of [const all]) are returne.


[call [cmd get_tcp_connections] [opt [arg options]]]
Retrieves information about currently active TCP connections similar to
the Windows [cmd netstat] command. The return value is a 
[uri base.html#recordarrays "record array"]
whose fields are controlled
through the following options:

[list_begin opt]
[opt_def [cmd -all]]
Returns all fields for a connection.
This option is assumed if no other field option is specified.
[opt_def [cmd -bindtime]]
Returns the time at which the last bind operation was done
on the socket, or 0 if no bind has been done.
This may not be available in which case, an empty string is returned
for the value. [emph "Deprecated"]
[opt_def [cmd -localaddr]]
Returns the local address being used for the connection.
[opt_def [cmd -localport]]
Returns the local port number being used for the connection.
[opt_def [cmd -modulename]]
Returns the name of the process module that owns the socket.
This may not be available in which case, an empty string is returned
for the value.
This value is always the empty string for IPv6 to work around a Windows bug.
 [emph "Deprecated"]
[opt_def [cmd -modulepath]]
Returns the path to the process module that owns the socket. This may not 
be available in which case, an empty string is returned for the value.
This value is always the empty string for IPv6 to work around a Windows bug.
 [emph "Deprecated"]
[opt_def [cmd -pid]]
Returns the PID of the process communicating on the port. On some platforms,
this may not be available in which case, an empty string is returned
for the value.
[opt_def [cmd -remoteaddr]]
Returns the address of the remote end of the connection.
[opt_def [cmd -remoteport]]
Returns the port number of the remote end of the connection.
[opt_def [cmd -state]]
Returns the connection state. This is one of
[const closed], [const listen], [const syn_sent], [const syn_rcvd],
[const estab], [const fin_wait1], [const fin_wait2], [const close_wait],
[const closing], [const last_ack], [const time_wait] or
[const delete_tcb].
[list_end]

In addition, the connections for which information is returned may
be filtered through the following options. Only those connections that
match the specified criteria are returned.
[list_begin opt]
[opt_def [cmd -ipversion] [arg IPVERSION]]
If [arg IPVERSION] is [const 0] (default), [const any] or [const all], both
IPv4 and IPv6 connections are returned. If [arg IPVERSION] is [const 4] or
[const inet], only IPv4 connections are returned and if it is [const 6] or
[const inet6], only IPv6 connections are returned.
[opt_def [cmd -matchlocaladdr] [arg HOSTLIST]]
Only returns those connections whose local address is one of those
specified in [arg HOSTLIST].
Each element of HOSTLIST may be either an IP address or a host name.
[opt_def [cmd -matchlocalport] [arg PORTNUMBER]]
Only returns those connections whose local port is the specified number.
[opt_def [cmd -matchpid] [arg PID]]
Only returns those connections owned by the process with the specified
PID. On platforms where the PID is not available, specifying this option
will generate an error.
[opt_def [cmd -matchremoteaddr] [arg HOSTLIST]]
Only returns those connections whose remote address is one of those
specified in [arg HOSTLIST].
Each element of HOSTLIST may be either an IP address or a host name.
[opt_def [cmd -matchremoteport] [arg PORTNUMBER]]
Only returns those connections whose remote port is [arg PORTNUMBER].
[opt_def [cmd matchstate] [arg STATELIST]]
Only returns those connections whose state is one those specified in
[arg STATELIST] which should be a list of connection state values (see above).
[list_end]

[call [cmd get_udp_connections] [opt [arg options]]]
Retrieves information about currently active UDP sockets similar to
the Windows [cmd netstat] command. The return value is a 
[uri base.html#recordarrays "record array"]
whose fields are controlled
through the following options:

[list_begin opt]
[opt_def [cmd -all]]
Returns all fields for a connection.
This option is assumed if no other field option is specified.
[opt_def [cmd -bindtime]]
Returns the time at which the last bind operation was done
on the socket, or 0 if no bind has been done.
This may not be available in which case, an empty string is returned
for the value. [emph "Deprecated"]
[opt_def [cmd -localaddr]]
Returns the local address being used for the connection.
[opt_def [cmd -localport]]
Returns the local port number being used for the connection.
[opt_def [cmd -modulename]]
Returns the name of the process module that owns the socket.
This may not be available in which case, an empty string is returned
for the value.
This value is always the empty string for IPv6 to work around a Windows bug.
 [emph "Deprecated"]
[opt_def [cmd -modulepath]]
Returns the path to the process module that owns the socket. This may not 
be available in which case, an empty string is returned for the value.
This value is always the empty string for IPv6 to work around a Windows bug.
 [emph "Deprecated"]
[opt_def [cmd -pid]]
Returns the PID of the process communicating on the port. On some platforms,
this may not be available in which case, an empty string is returned
for the value.
[list_end]

In addition, the connections for which information is returned may
be filtered through the following options. Only those connections that
match the specified criteria are returned.
[list_begin opt]
[opt_def [cmd -ipversion] [arg IPVERSION]]
If [arg IPVERSION] is [const 0] (default), [const any] or [const all], both
IPv4 and IPv6 connections are returned. If [arg IPVERSION] is [const 4] or
[const inet], only IPv4 connections are returned and if it is [const 6] or
[const inet6], only IPv6 connections are returned.
[opt_def [cmd -matchlocaladdr] [arg HOSTLIST]]
Only returns those connections whose local address is one of those
specified in [arg HOSTLIST].
Each element of HOSTLIST may be either an IP address or a host name.
[opt_def [cmd -matchlocalport] [arg PORTNUMBER]]
Only returns those connections whose local port is the specified number.
[opt_def [cmd -matchpid] [arg PID]]
Only returns those connections owned by the process with the specified
PID. On platforms where the PID is not available, specifying this option
will generate an error.
[list_end]


[call [cmd hostname_to_address] [arg HOSTNAME] [opt "[cmd -async] [arg SCRIPT]"] [opt [cmd -flushcache]]]

This command is deprecated in favor of
[uri network.html#resolve_hostname [cmd resolve_hostname]]. It only returns
IPv4 addresses.

[call [cmd hwaddr_to_ipaddr] [arg HWADDR] [opt [arg VARNAME]]]
[emph "Note: This command is only supported for IPv4."]
[nl]
Returns the IP address corresponding to the given hardware address.

If [arg VARNAME] is specified, the command stores the result in
a variable of that name in the caller's context if a mapping can be found
and returns 1. Otherwise the command returns 0 without affecting the
variable.

If [arg VARNAME] is not specified, the command returns the IP
address if a mapping is found and generates a Tcl exception otherwise.

[call [cmd ipaddr_to_hwaddr] [arg IPADDR] [opt [arg VARNAME]]]
[emph "Note: This command is only supported for IPv4."]
[nl]
Returns the hardware address corresponding to the given IP address.

If [arg VARNAME] is specified, the command stores the result in
a variable of that name in the caller's context if a mapping can be found
and returns 1. Otherwise the command returns 0 without affecting the
variable.

If [arg VARNAME] is not specified, the command returns the hardware
address if a mapping is found and generates a Tcl exception otherwise.

[call [cmd port_to_service] [arg PORTNUMBER]]
Returns the service name (e.g. [const http]) corresponding to the
specified port number. If no corresponding service name exists, an empty
string is returned.

[call [cmd resolve_address] [arg IPADDRESS] [opt "[cmd -async] [arg SCRIPT]"]]

Attempts to map the specified Internet address [arg IPADDRESS] to its
fully qualified DNS name (FQDN). [arg IPADDRESS] may be an IPv4 or IPv6
address.
[nl]
If the [cmd -async] option is not specified, the command returns the FQDN if
available and the empty string otherwise. Note that this is a blocking call
and the Tcl event loop will not be run until the command returns.
[nl]
If the [cmd -async] option is specified, the command returns right away.
The address resolution is done in the background and when completed,
[arg SCRIPT] is called at the global scope. Three additional arguments
are appended to the script before it is executed - [arg IPADDRESS],
status [const success] or [const fail] and either the FQDN
(when the status is [const success]) or the Winsock error code
(when the status is [const fail]). The Winsock error code
may be translated to an error string using the
[uri base.html\#map_windows_error [cmd map_windows_error]] command.
If no names are found, the status is [const success] but the
third argument will be an empty string.
[nl]
Note the [cmd -async] option requires a threaded build of Tcl and will 
raise an exception on non-threaded builds.

[nl]
Note the address to hostname mapping is no longer cached internally by
TWAPI as in older releases. Applications can do the caching themselves
if desired.

[call [cmd resolve_hostname] [arg HOSTNAME] [opt "[cmd -async] [arg SCRIPT]"] [opt "[cmd -ipversion] [arg IPVERSION]"]]

Attempts to map the specified host name to its IP addresses. Note there may
be more than one address associated with a host name.
[nl]
If [cmd -ipversion] is
not specified, or [arg IPVERSION] is [const 0], [const any] or [const all], both
IPv4 and IPv6 addresses are returned. If [arg IPVERSION] is [const 4] or
[const inet], only IPv4 addresses are returned and if it is [const 6] or
[const inet6], only IPv6 addresses are returned.

[nl]
If the [cmd -async] option is not specified, the command returns the
list of IP addresses corresponding to the host if
available and an empty list otherwise. Note that this is a blocking call
and the Tcl event loop will not be run until the command returns.
[nl]
If the [cmd -async] option is specified, the command returns right away.
The name resolution is done in the background and when completed,
[arg SCRIPT] is called at the global scope. Three additional arguments
are appended to the script before it is executed - [arg HOSTNAME],
status [const success] or [const fail] and either the list of IP addresses
(when the status is [const success]) or the Winsock error code
(when the status is [const fail]). The Winsock error code
may be translated to an error string using the
[uri base.html\#map_windows_error [cmd map_windows_error]] command.
Note that on some platforms, if no addresses are found, 
callback may be invoked with a status of [const success] and an empty list
for the third argument, or it may be invoked with a status of fail
and an appropriate error code.
[nl]
Note the [cmd -async] option requires a threaded build of Tcl and will 
raise an exception on non-threaded builds.

[call [cmd service_to_port] [arg SERVICENAME]]
Returns the port number corresponding to the specified
service name (e.g. [const http]).
If the service name is not defined, an empty
string is returned. If [arg SERVICENAME] is a port number, it is returned.


[call [cmd terminate_tcp_connections] [opt [arg options]]]
[emph "Note: This command is only supported for IPv4 connections"]
[nl]
Terminates all connections that match all the options specified.
Any options that are not specified are assumed to match. The valid
matching options are:

[list_begin opt]
[opt_def [cmd -matchlocaladdr] [arg IPADDR]]
Only matches those connections whose local address is bound to [arg IPADDR].
[opt_def [cmd -matchlocalport] [arg PORTNUMBER]]
Only matches those connections whose local port is the specified number.
[opt_def [cmd -matchpid] [arg PID]]
Only matches those connections owned by the process with the specified
PID. On platforms where the PID is not available, specifying this option
will generate an error.
[opt_def [cmd -matchremoteaddr] [arg IPADDR]]
Only matches those connections whose remote address is bound to [arg IPADDR].
[opt_def [cmd -matchremoteport] [arg PORTNUMBER]]
Only matches those connections whose remote port is [arg PORTNUMBER].
[opt_def [cmd matchstate] [arg STATELIST]]
Only matches those connections whose state is one those specified in
[arg STATELIST] which should be a list of connection state values. See
[uri \#get_tcp_connections [cmd get_tcp_connections]] for a list of
valid values.
[list_end]

The system attempts to terminate the specified connections but no error
is raised if the connection cannot be terminated. Caller should retrieve
the list of connections to check if the termination was successful.


[list_end]

[keywords "network information" addresses "Internet addresses" "IP addresses" "network statistics" "ARP table" "Address resolution protocol" "TCP" "UDP" "IP" "ICMP" "DHCP information" "network interface configuration" "network adapters" "DNS server addresses" "WINS servers addresses" "network address" "physical address" "netstat" "connections" "terminate connections" "FQDN" "name resolution" "DNS lookup" "address resolution" routing "network routes"]

[manpage_end]
