IF(TULIP_USE_QT6)
  SET(QT Qt6)
  SET(QT_MIN 6.2)
  UNSET(Qt6OpenGLWidgets_DIR CACHE)
ELSE()
  SET(QT Qt5)
  SET(QT_MIN 5.6)
ENDIF(TULIP_USE_QT6)

STRING(TOLOWER ${QT} QTDIR)

# If CMake does not automatically find Qt5 or Qt6 , the root directory
# of the Qt installation must be provided in the CMAKE_PREFIX_PATH variable.

# Unset related CMake variables in order to change the Qt version (by modifying
# the root Qt directory through the CMAKE_PREFIX_PATH variable) without having
# to delete the current CMake cache

UNSET(${QT}Core_FOUND CACHE)
UNSET(${QT}Gui_FOUND CACHE)
UNSET(${QT}Widgets_FOUND CACHE)
UNSET(${QT}Xml_FOUND CACHE)
UNSET(${QT}XmlPatterns_FOUND CACHE)
UNSET(${QT}Network_FOUND CACHE)
UNSET(${QT}WebKit_FOUND CACHE)
UNSET(${QT}WebKitWidgets_FOUND CACHE)
UNSET(${QT}Multimedia_FOUND CACHE)
UNSET(${QT}MultimediaWidgets_FOUND CACHE)
UNSET(${QT}Positioning_FOUND CACHE)
UNSET(${QT}PrintSupport_FOUND CACHE)
UNSET(${QT}Qml_FOUND CACHE)
UNSET(${QT}Quick_FOUND CACHE)
UNSET(${QT}Sensors_FOUND CACHE)
UNSET(${QT}DBus_FOUND CACHE)
UNSET(${QT}WebEngineWidgets_FOUND CACHE)
UNSET(${QT}WebChannel_FOUND CACHE)

UNSET(${QT}Core_DIR CACHE)
UNSET(${QT}Gui_DIR CACHE)
UNSET(${QT}Widgets_DIR CACHE)
UNSET(${QT}Xml_DIR CACHE)
UNSET(${QT}XmlPatterns_DIR CACHE)
UNSET(${QT}Network_DIR CACHE)
UNSET(${QT}WebKit_DIR CACHE)
UNSET(${QT}WebKitWidgets_DIR CACHE)
UNSET(${QT}Multimedia_DIR CACHE)
UNSET(${QT}MultimediaWidgets_DIR CACHE)
UNSET(${QT}Positioning_DIR CACHE)
UNSET(${QT}PrintSupport_DIR CACHE)
UNSET(${QT}Qml_DIR CACHE)
UNSET(${QT}Quick_DIR CACHE)
UNSET(${QT}Sensors_DIR CACHE)
UNSET(${QT}DBus_DIR CACHE)
UNSET(${QT}WebEngineWidgets_DIR CACHE)
UNSET(${QT}WebChannel_DIR CACHE)

SET(QT_HAS_WEBKIT FALSE)
SET(QT_HAS_WEBENGINE FALSE)

# Macro used to workaround a small issue with QtWebkit components on MSYS2:
# when compiling in RelWithDebInfo mode, Qt debug libraries are selected instead
# of the release one (this should only happen when compiling in Debug mode)
MACRO(SETUP_QT_LIBRARIES QtModule LIBRARIES)
  IF(MINGW)
    GET_TARGET_PROPERTY(${QT}${QtModule}_INCLUDE_DIRS ${QT}::${QtModule} INTERFACE_INCLUDE_DIRECTORIES)
    IF(CMAKE_DEBUG_MODE)
      GET_TARGET_PROPERTY(${QT}${QtModule}_LIBRARIES ${QT}::${QtModule} LOCATION_DEBUG)
    ELSE(CMAKE_DEBUG_MODE)
      GET_TARGET_PROPERTY(${QT}${QtModule}_LIBRARIES ${QT}::${QtModule} LOCATION_RELEASE)
    ENDIF(CMAKE_DEBUG_MODE)
  ENDIF(MINGW)
  SET(${LIBRARIES} ${${LIBRARIES}} ${${QT}${QtModule}_LIBRARIES} ${${QT}${QtModule}_LIBRARIES})
ENDMACRO(SETUP_QT_LIBRARIES)

FIND_PACKAGE(${QT}Widgets ${QT_MIN} REQUIRED)
FIND_PACKAGE(${QT}Network ${QT_MIN} REQUIRED)
IF(${QT} STREQUAL Qt6)
  FIND_PACKAGE(Qt6Core5Compat ${QT_MIN} REQUIRED)
  FIND_PACKAGE(Qt6OpenGLWidgets ${QT_MIN} REQUIRED)
  SET(QT6_LIBRARIES ${Qt6Core5Compat_LIBRARIES} ${Qt6OpenGLWidgets_LIBRARIES})
ENDIF()

SET(QT_FULL_VERSION ${${QT}Widgets_VERSION_STRING})
# QtWidgets_VERSION_STRING has been deprecated in favor of Qt5Widgets_VERSION since
# a few releases of Qt5 and seems to have been removed in some Linux distributions
# (experienced on KDE Neon Developer edition with Qt 5.9)
IF("${QT_FULL_VERSION}" STREQUAL "")
  SET(QT_FULL_VERSION ${${QT}Widgets_VERSION})
ENDIF("${QT_FULL_VERSION}" STREQUAL "")
STRING(REGEX MATCH "[0-9]\\.[0-9]+" QT_VERSION "${QT_FULL_VERSION}")

IF(NOT "${QT_VERSION}" STREQUAL "${LAST_FOUND_QT_VERSION}")
  MESSAGE(STATUS "Found ${QT} (version ${QT_FULL_VERSION})")
ENDIF(NOT "${QT_VERSION}" STREQUAL "${LAST_FOUND_QT_VERSION}")

SET(LAST_FOUND_QT_VERSION "${QT_VERSION}" CACHE INTERNAL "")

IF(WIN32)
  GET_TARGET_PROPERTY(QtCore_location ${QT}::Core LOCATION)
  GET_FILENAME_COMPONENT(QT_BINARY_DIR ${QtCore_location} PATH)
  SET(QT_BINARY_DIR ${QT_BINARY_DIR}/../bin)
  # Standard Qt installation
  IF(EXISTS ${QT_BINARY_DIR}/../plugins)
    SET(QT_PLUGINS_DIR ${QT_BINARY_DIR}/../plugins)
  # MSYS2 special case
  ELSEIF(EXISTS ${QT_BINARY_DIR}/../share/${QTDIR}/plugins)
    SET(QT_PLUGINS_DIR ${QT_BINARY_DIR}/../share/${QTDIR}/plugins)
  ENDIF()
ELSEIF(APPLE)
  GET_TARGET_PROPERTY(QtCore_location ${QT}::Core LOCATION)
  GET_FILENAME_COMPONENT(QT_FRAMEWORKS_DIR ${QtCore_location} PATH)
  SET(QT_FRAMEWORKS_DIR ${QT_FRAMEWORKS_DIR}/..)
  SET(QT_BINARY_DIR ${QT_FRAMEWORKS_DIR}/../bin)
ELSE()
  SET(QT_BINARY_DIR "${_qt5Gui_install_prefix}/bin")
  IF(NOT EXISTS ${QT_BINARY_DIR})
    IF(EXISTS /usr/lib/x86_64-linux-gnu/${QTDIR}/bin)
      SET(QT_BINARY_DIR /usr/lib/x86_64-linux-gnu/${QTDIR}/bin)
    ENDIF()
  ENDIF()
  IF(EXISTS ${QT_BINARY_DIR}/qmake)
    SET(QT_QMAKE_EXECUTABLE ${QT_BINARY_DIR}/qmake)
  ELSEIF(EXISTS ${QT_BINARY_DIR}/qmake-${QTDIR})
    SET(QT_QMAKE_EXECUTABLE ${QT_BINARY_DIR}/qmake-${QTDIR})
  ENDIF()
  # Standard Qt5 installation
  IF(EXISTS ${QT_BINARY_DIR}/../plugins)
    SET(QT_PLUGINS_DIR ${QT_BINARY_DIR}/../plugins)
  ENDIF()
ENDIF()

SET(QT_LIBRARIES ${${QT}Widgets_LIBRARIES} ${${QT}Network_LIBRARIES} ${QT6_LIBRARIES})

GET_FILENAME_COMPONENT(QT_CMAKE_DIR "${${QT}Core_DIR}" DIRECTORY)

# On Apple platform, we need to link against Qt5DBus and Qt5PrintSupport
# when using the official Qt5 bundle provided by qt.io (dylibs dependencies side effect).
# However, those modules are not necessarily present when using Qt5 from
# Homebrew or MacPorts, so handle those special cases here.
IF(APPLE)
  SET(QT_DBUS_CMAKE_DIR "${QT_CMAKE_DIR}/${QT}DBus")
  SET(QT_PRINTSUPPORT_CMAKE_DIR "${QT_CMAKE_DIR}/${QT}PrintSupport")
  IF(EXISTS ${QT_DBUS_CMAKE_DIR} AND EXISTS ${QT_PRINTSUPPORT_CMAKE_DIR})
    FIND_PACKAGE(${QT}DBus ${QT_MIN})
    FIND_PACKAGE(${QT}PrintSupport ${QT_MIN})
    IF(${${QT}DBus_FOUND} AND ${${QT}PrintSupport_FOUND})
      SET(QT_LIBRARIES ${QT_LIBRARIES} ${${QT}PrintSupport_LIBRARIES} ${${QT}DBus_LIBRARIES})
    ENDIF()
  ENDIF()
ENDIF(APPLE)

# Check if the Qt installation is bundled with WebKit (deprecated since Qt 5.5)
# and setup its use if it is the case.
# Since WebKit is the default we may want to force WebEngine for testing purpose
IF(${QT} STREQUAL Qt5)
  SET(TULIP_GEOVIEW_USE_WEBENGINE OFF CACHE BOOL "Use QWebEngine ? [ON|OFF]")
  SET(QT_WEBKIT_WIDGETS_CMAKE_DIR "${QT_CMAKE_DIR}/Qt5WebKitWidgets")
  IF(NOT TULIP_GEOVIEW_USE_WEBENGINE AND EXISTS ${QT_WEBKIT_WIDGETS_CMAKE_DIR})
    FIND_PACKAGE(Qt5WebKit)
    FIND_PACKAGE(Qt5WebKitWidgets)
    IF(${Qt5WebKit_FOUND} AND ${Qt5WebKitWidgets_FOUND})
      SET(QT_HAS_WEBKIT TRUE)
      SET(QT_WEB_COMPONENT "QtWebKit")
      SETUP_QT_LIBRARIES(WebKit QT_WEB_LIBRARIES)
      SETUP_QT_LIBRARIES(WebKitWidgets QT_WEB_LIBRARIES)
    ENDIF(${Qt5WebKit_FOUND} AND ${Qt5WebKitWidgets_FOUND})
  ENDIF(NOT TULIP_GEOVIEW_USE_WEBENGINE AND EXISTS ${QT_WEBKIT_WIDGETS_CMAKE_DIR})
ENDIF(${QT} STREQUAL Qt5)

# If Qt is not bundled with WebKit then check if its installation
# provides WebEngine (new web module since Qt 5.4) and setup its use.
SET(QT_WEBENGINE_WIDGETS_CMAKE_DIR "${QT_CMAKE_DIR}/${QT}WebEngineWidgets")
IF(NOT QT_HAS_WEBKIT AND EXISTS ${QT_WEBENGINE_WIDGETS_CMAKE_DIR})
  FIND_PACKAGE(${QT}WebEngineWidgets ${QTMIN})
  FIND_PACKAGE(${QT}WebChannel ${QTMIN})
  IF(${${QT}WebEngineWidgets_FOUND} AND ${${QT}WebChannel_FOUND})
    SET(QT_HAS_WEBENGINE TRUE)
    SET(QT_WEB_COMPONENT "QtWebEngine")
    SET(QT_WEB_LIBRARIES ${${QT}WebEngineWidgets_LIBRARIES} ${${QT}WebChannel_LIBRARIES})
  ENDIF(${${QT}WebEngineWidgets_FOUND} AND ${${QT}WebChannel_FOUND})
ENDIF(NOT QT_HAS_WEBKIT AND EXISTS ${QT_WEBENGINE_WIDGETS_CMAKE_DIR})

IF(NOT "${QT_WEB_COMPONENT}" STREQUAL "${LAST_FOUND_QT_WEB_COMPONENT}")
  MESSAGE(STATUS "Found ${QT_WEB_COMPONENT}")
ENDIF(NOT "${QT_WEB_COMPONENT}" STREQUAL "${LAST_FOUND_QT_WEB_COMPONENT}")

SET(LAST_FOUND_QT_WEB_COMPONENT "${QT_WEB_COMPONENT}" CACHE INTERNAL "")

MACRO(QTX_SET_INCLUDES_AND_DEFINITIONS)
  INCLUDE_DIRECTORIES(${${QT}Widgets_INCLUDE_DIRS})
  INCLUDE_DIRECTORIES(${${QT}Network_INCLUDE_DIRS})
  ADD_COMPILE_DEFINITIONS(${${QT}Widgets_COMPILE_DEFINITIONS})
  ADD_COMPILE_DEFINITIONS(${${QT}Network_COMPILE_DEFINITIONS})
  IF(${QT} STREQUAL Qt6)
    INCLUDE_DIRECTORIES(${Qt6Core5Compat_INCLUDE_DIRS})
    ADD_COMPILE_DEFINITIONS(${Qt6Core5Compat_COMPILE_DEFINITIONS})
    INCLUDE_DIRECTORIES(${Qt6OpenGLWidgets_INCLUDE_DIRS})
    ADD_COMPILE_DEFINITIONS(${Qt6OpenGLWidgets_COMPILE_DEFINITIONS})
  ENDIF()
ENDMACRO()

MACRO(QTXWEB_SET_INCLUDES_AND_DEFINITIONS)
  IF(QT_HAS_WEBKIT)
    INCLUDE_DIRECTORIES(${Qt5WebKit_INCLUDE_DIRS})
    INCLUDE_DIRECTORIES(${Qt5WebKitWidgets_INCLUDE_DIRS})
    ADD_COMPILE_DEFINITIONS(${Qt5WebKit_COMPILE_DEFINITIONS})
    ADD_COMPILE_DEFINITIONS(${Qt5WebKitWidgets_COMPILE_DEFINITIONS})
    ADD_COMPILE_DEFINITIONS(QT_HAS_WEBKIT)
  ENDIF()
  IF(QT_HAS_WEBENGINE)
    INCLUDE_DIRECTORIES(${${QT}WebEngineWidgets_INCLUDE_DIRS})
    INCLUDE_DIRECTORIES(${${QT}WebChannel_INCLUDE_DIRS})
    ADD_COMPILE_DEFINITIONS(${${QT}WebEngineWidgets_COMPILE_DEFINITIONS})
    ADD_COMPILE_DEFINITIONS(${${QT}WebChannel_COMPILE_DEFINITIONS})
    ADD_COMPILE_DEFINITIONS(QT_HAS_WEBENGINE)
  ENDIF()
ENDMACRO(QTXWEB_SET_INCLUDES_AND_DEFINITIONS)

# Define aliases for Qt macros in order to build the project
IF(${QT} STREQUAL Qt5)
  MACRO(QTX_WRAP_CPP outfiles)
    QT5_WRAP_CPP(${outfiles} ${ARGN})
  ENDMACRO()
ELSE()
  MACRO(QTX_WRAP_CPP outfiles)
    QT_WRAP_CPP(${outfiles} ${ARGN})
  ENDMACRO()
ENDIF()

IF(${QT} STREQUAL Qt5)
  MACRO(QTX_WRAP_UI outfiles)
    QT5_WRAP_UI(${outfiles} ${ARGN})
  ENDMACRO()
ELSE()
  MACRO(QTX_WRAP_UI outfiles)
    QT_WRAP_UI(${outfiles} ${ARGN})
  ENDMACRO()
ENDIF()

IF(${QT} STREQUAL Qt5)
MACRO(QTX_ADD_RESOURCES outfiles)
  QT5_ADD_RESOURCES(${outfiles} ${ARGN})
ENDMACRO()
ELSE()
  MACRO(QTX_ADD_RESOURCES outfiles)
    QT_ADD_RESOURCES(${outfiles} ${ARGN})
  ENDMACRO()
ENDIF()

# With MinGW, remove the -fPIC compiler option as it is not needed and
# generates a lot of warnings
IF(MINGW)
  STRING(REPLACE "-fPIC" "" ${QT}Widgets_EXECUTABLE_COMPILE_FLAGS "${${QT}Widgets_EXECUTABLE_COMPILE_FLAGS}")
ENDIF(MINGW)
