/* automatically generated by rust-bindgen 0.71.1 */

pub const TREE_SITTER_LANGUAGE_VERSION: u32 = 15;
pub const TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION: u32 = 13;
pub type TSStateId = u16;
pub type TSSymbol = u16;
pub type TSFieldId = u16;
#[repr(C)]
#[derive(Debug)]
pub struct TSLanguage {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct TSParser {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct TSTree {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct TSQuery {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct TSQueryCursor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct TSLookaheadIterator {
    _unused: [u8; 0],
}
pub type DecodeFunction = ::core::option::Option<
    unsafe extern "C" fn(string: *const u8, length: u32, code_point: *mut i32) -> u32,
>;
pub const TSInputEncodingUTF8: TSInputEncoding = 0;
pub const TSInputEncodingUTF16LE: TSInputEncoding = 1;
pub const TSInputEncodingUTF16BE: TSInputEncoding = 2;
pub const TSInputEncodingCustom: TSInputEncoding = 3;
pub type TSInputEncoding = ::core::ffi::c_uint;
pub const TSSymbolTypeRegular: TSSymbolType = 0;
pub const TSSymbolTypeAnonymous: TSSymbolType = 1;
pub const TSSymbolTypeSupertype: TSSymbolType = 2;
pub const TSSymbolTypeAuxiliary: TSSymbolType = 3;
pub type TSSymbolType = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSPoint {
    pub row: u32,
    pub column: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSRange {
    pub start_point: TSPoint,
    pub end_point: TSPoint,
    pub start_byte: u32,
    pub end_byte: u32,
}
#[repr(C)]
#[derive(Debug)]
pub struct TSInput {
    pub payload: *mut ::core::ffi::c_void,
    pub read: ::core::option::Option<
        unsafe extern "C" fn(
            payload: *mut ::core::ffi::c_void,
            byte_index: u32,
            position: TSPoint,
            bytes_read: *mut u32,
        ) -> *const ::core::ffi::c_char,
    >,
    pub encoding: TSInputEncoding,
    pub decode: DecodeFunction,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSParseState {
    pub payload: *mut ::core::ffi::c_void,
    pub current_byte_offset: u32,
    pub has_error: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSParseOptions {
    pub payload: *mut ::core::ffi::c_void,
    pub progress_callback:
        ::core::option::Option<unsafe extern "C" fn(state: *mut TSParseState) -> bool>,
}
pub const TSLogTypeParse: TSLogType = 0;
pub const TSLogTypeLex: TSLogType = 1;
pub type TSLogType = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct TSLogger {
    pub payload: *mut ::core::ffi::c_void,
    pub log: ::core::option::Option<
        unsafe extern "C" fn(
            payload: *mut ::core::ffi::c_void,
            log_type: TSLogType,
            buffer: *const ::core::ffi::c_char,
        ),
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSInputEdit {
    pub start_byte: u32,
    pub old_end_byte: u32,
    pub new_end_byte: u32,
    pub start_point: TSPoint,
    pub old_end_point: TSPoint,
    pub new_end_point: TSPoint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSNode {
    pub context: [u32; 4usize],
    pub id: *const ::core::ffi::c_void,
    pub tree: *const TSTree,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSTreeCursor {
    pub tree: *const ::core::ffi::c_void,
    pub id: *const ::core::ffi::c_void,
    pub context: [u32; 3usize],
}
#[repr(C)]
#[derive(Debug)]
pub struct TSQueryCapture {
    pub node: TSNode,
    pub index: u32,
}
pub const TSQuantifierZero: TSQuantifier = 0;
pub const TSQuantifierZeroOrOne: TSQuantifier = 1;
pub const TSQuantifierZeroOrMore: TSQuantifier = 2;
pub const TSQuantifierOne: TSQuantifier = 3;
pub const TSQuantifierOneOrMore: TSQuantifier = 4;
pub type TSQuantifier = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct TSQueryMatch {
    pub id: u32,
    pub pattern_index: u16,
    pub capture_count: u16,
    pub captures: *const TSQueryCapture,
}
pub const TSQueryPredicateStepTypeDone: TSQueryPredicateStepType = 0;
pub const TSQueryPredicateStepTypeCapture: TSQueryPredicateStepType = 1;
pub const TSQueryPredicateStepTypeString: TSQueryPredicateStepType = 2;
pub type TSQueryPredicateStepType = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct TSQueryPredicateStep {
    pub type_: TSQueryPredicateStepType,
    pub value_id: u32,
}
pub const TSQueryErrorNone: TSQueryError = 0;
pub const TSQueryErrorSyntax: TSQueryError = 1;
pub const TSQueryErrorNodeType: TSQueryError = 2;
pub const TSQueryErrorField: TSQueryError = 3;
pub const TSQueryErrorCapture: TSQueryError = 4;
pub const TSQueryErrorStructure: TSQueryError = 5;
pub const TSQueryErrorLanguage: TSQueryError = 6;
pub type TSQueryError = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSQueryCursorState {
    pub payload: *mut ::core::ffi::c_void,
    pub current_byte_offset: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSQueryCursorOptions {
    pub payload: *mut ::core::ffi::c_void,
    pub progress_callback:
        ::core::option::Option<unsafe extern "C" fn(state: *mut TSQueryCursorState) -> bool>,
}
#[doc = " The metadata associated with a language.\n\n Currently, this metadata can be used to check the [Semantic Version](https://semver.org/)\n of the language. This version information should be used to signal if a given parser might\n be incompatible with existing queries when upgrading between major versions, or minor versions\n if it's in zerover."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSLanguageMetadata {
    pub major_version: u8,
    pub minor_version: u8,
    pub patch_version: u8,
}
extern "C" {
    #[doc = " Create a new parser."]
    pub fn ts_parser_new() -> *mut TSParser;
}
extern "C" {
    #[doc = " Delete the parser, freeing all of the memory that it used."]
    pub fn ts_parser_delete(self_: *mut TSParser);
}
extern "C" {
    #[doc = " Get the parser's current language."]
    pub fn ts_parser_language(self_: *const TSParser) -> *const TSLanguage;
}
extern "C" {
    #[doc = " Set the language that the parser should use for parsing.\n\n Returns a boolean indicating whether or not the language was successfully\n assigned. True means assignment succeeded. False means there was a version\n mismatch: the language was generated with an incompatible version of the\n Tree-sitter CLI. Check the language's ABI version using [`ts_language_abi_version`]\n and compare it to this library's [`TREE_SITTER_LANGUAGE_VERSION`] and\n [`TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION`] constants."]
    pub fn ts_parser_set_language(self_: *mut TSParser, language: *const TSLanguage) -> bool;
}
extern "C" {
    #[doc = " Set the ranges of text that the parser should include when parsing.\n\n By default, the parser will always include entire documents. This function\n allows you to parse only a *portion* of a document but still return a syntax\n tree whose ranges match up with the document as a whole. You can also pass\n multiple disjoint ranges.\n\n The second and third parameters specify the location and length of an array\n of ranges. The parser does *not* take ownership of these ranges; it copies\n the data, so it doesn't matter how these ranges are allocated.\n\n If `count` is zero, then the entire document will be parsed. Otherwise,\n the given ranges must be ordered from earliest to latest in the document,\n and they must not overlap. That is, the following must hold for all:\n\n `i < count - 1`: `ranges[i].end_byte <= ranges[i + 1].start_byte`\n\n If this requirement is not satisfied, the operation will fail, the ranges\n will not be assigned, and this function will return `false`. On success,\n this function returns `true`"]
    pub fn ts_parser_set_included_ranges(
        self_: *mut TSParser,
        ranges: *const TSRange,
        count: u32,
    ) -> bool;
}
extern "C" {
    #[doc = " Get the ranges of text that the parser will include when parsing.\n\n The returned pointer is owned by the parser. The caller should not free it\n or write to it. The length of the array will be written to the given\n `count` pointer."]
    pub fn ts_parser_included_ranges(self_: *const TSParser, count: *mut u32) -> *const TSRange;
}
extern "C" {
    #[doc = " Use the parser to parse some source code and create a syntax tree.\n\n If you are parsing this document for the first time, pass `NULL` for the\n `old_tree` parameter. Otherwise, if you have already parsed an earlier\n version of this document and the document has since been edited, pass the\n previous syntax tree so that the unchanged parts of it can be reused.\n This will save time and memory. For this to work correctly, you must have\n already edited the old syntax tree using the [`ts_tree_edit`] function in a\n way that exactly matches the source code changes.\n\n The [`TSInput`] parameter lets you specify how to read the text. It has the\n following three fields:\n 1. [`read`]: A function to retrieve a chunk of text at a given byte offset\n    and (row, column) position. The function should return a pointer to the\n    text and write its length to the [`bytes_read`] pointer. The parser does\n    not take ownership of this buffer; it just borrows it until it has\n    finished reading it. The function should write a zero value to the\n    [`bytes_read`] pointer to indicate the end of the document.\n 2. [`payload`]: An arbitrary pointer that will be passed to each invocation\n    of the [`read`] function.\n 3. [`encoding`]: An indication of how the text is encoded. Either\n    `TSInputEncodingUTF8` or `TSInputEncodingUTF16`.\n\n This function returns a syntax tree on success, and `NULL` on failure. There\n are four possible reasons for failure:\n 1. The parser does not have a language assigned. Check for this using the\n[`ts_parser_language`] function.\n 2. Parsing was cancelled due to a timeout that was set by an earlier call to\n    the [`ts_parser_set_timeout_micros`] function. You can resume parsing from\n    where the parser left out by calling [`ts_parser_parse`] again with the\n    same arguments. Or you can start parsing from scratch by first calling\n    [`ts_parser_reset`].\n 3. Parsing was cancelled using a cancellation flag that was set by an\n    earlier call to [`ts_parser_set_cancellation_flag`]. You can resume parsing\n    from where the parser left out by calling [`ts_parser_parse`] again with\n    the same arguments.\n 4. Parsing was cancelled due to the progress callback returning true. This callback\n    is passed in [`ts_parser_parse_with_options`] inside the [`TSParseOptions`] struct.\n\n [`read`]: TSInput::read\n [`payload`]: TSInput::payload\n [`encoding`]: TSInput::encoding\n [`bytes_read`]: TSInput::read"]
    pub fn ts_parser_parse(
        self_: *mut TSParser,
        old_tree: *const TSTree,
        input: TSInput,
    ) -> *mut TSTree;
}
extern "C" {
    #[doc = " Use the parser to parse some source code and create a syntax tree, with some options.\n\n See [`ts_parser_parse`] for more details.\n\n See [`TSParseOptions`] for more details on the options."]
    pub fn ts_parser_parse_with_options(
        self_: *mut TSParser,
        old_tree: *const TSTree,
        input: TSInput,
        parse_options: TSParseOptions,
    ) -> *mut TSTree;
}
extern "C" {
    #[doc = " Use the parser to parse some source code stored in one contiguous buffer.\n The first two parameters are the same as in the [`ts_parser_parse`] function\n above. The second two parameters indicate the location of the buffer and its\n length in bytes."]
    pub fn ts_parser_parse_string(
        self_: *mut TSParser,
        old_tree: *const TSTree,
        string: *const ::core::ffi::c_char,
        length: u32,
    ) -> *mut TSTree;
}
extern "C" {
    #[doc = " Use the parser to parse some source code stored in one contiguous buffer with\n a given encoding. The first four parameters work the same as in the\n [`ts_parser_parse_string`] method above. The final parameter indicates whether\n the text is encoded as UTF8 or UTF16."]
    pub fn ts_parser_parse_string_encoding(
        self_: *mut TSParser,
        old_tree: *const TSTree,
        string: *const ::core::ffi::c_char,
        length: u32,
        encoding: TSInputEncoding,
    ) -> *mut TSTree;
}
extern "C" {
    #[doc = " Instruct the parser to start the next parse from the beginning.\n\n If the parser previously failed because of a timeout or a cancellation, then\n by default, it will resume where it left off on the next call to\n [`ts_parser_parse`] or other parsing functions. If you don't want to resume,\n and instead intend to use this parser to parse some other document, you must\n call [`ts_parser_reset`] first."]
    pub fn ts_parser_reset(self_: *mut TSParser);
}
extern "C" {
    #[doc = " @deprecated use [`ts_parser_parse_with_options`] and pass in a callback instead, this will be removed in 0.26.\n\n Set the maximum duration in microseconds that parsing should be allowed to\n take before halting.\n\n If parsing takes longer than this, it will halt early, returning NULL.\n See [`ts_parser_parse`] for more information."]
    pub fn ts_parser_set_timeout_micros(self_: *mut TSParser, timeout_micros: u64);
}
extern "C" {
    #[doc = " @deprecated use [`ts_parser_parse_with_options`] and pass in a callback instead, this will be removed in 0.26.\n\n Get the duration in microseconds that parsing is allowed to take."]
    pub fn ts_parser_timeout_micros(self_: *const TSParser) -> u64;
}
extern "C" {
    #[doc = " @deprecated use [`ts_parser_parse_with_options`] and pass in a callback instead, this will be removed in 0.26.\n\n Set the parser's current cancellation flag pointer.\n\n If a non-null pointer is assigned, then the parser will periodically read\n from this pointer during parsing. If it reads a non-zero value, it will\n halt early, returning NULL. See [`ts_parser_parse`] for more information."]
    pub fn ts_parser_set_cancellation_flag(self_: *mut TSParser, flag: *const usize);
}
extern "C" {
    #[doc = " @deprecated use [`ts_parser_parse_with_options`] and pass in a callback instead, this will be removed in 0.26.\n\n Get the parser's current cancellation flag pointer."]
    pub fn ts_parser_cancellation_flag(self_: *const TSParser) -> *const usize;
}
extern "C" {
    #[doc = " Set the logger that a parser should use during parsing.\n\n The parser does not take ownership over the logger payload. If a logger was\n previously assigned, the caller is responsible for releasing any memory\n owned by the previous logger."]
    pub fn ts_parser_set_logger(self_: *mut TSParser, logger: TSLogger);
}
extern "C" {
    #[doc = " Get the parser's current logger."]
    pub fn ts_parser_logger(self_: *const TSParser) -> TSLogger;
}
extern "C" {
    #[doc = " Set the file descriptor to which the parser should write debugging graphs\n during parsing. The graphs are formatted in the DOT language. You may want\n to pipe these graphs directly to a `dot(1)` process in order to generate\n SVG output. You can turn off this logging by passing a negative number."]
    pub fn ts_parser_print_dot_graphs(self_: *mut TSParser, fd: ::core::ffi::c_int);
}
extern "C" {
    #[doc = " Create a shallow copy of the syntax tree. This is very fast.\n\n You need to copy a syntax tree in order to use it on more than one thread at\n a time, as syntax trees are not thread safe."]
    pub fn ts_tree_copy(self_: *const TSTree) -> *mut TSTree;
}
extern "C" {
    #[doc = " Delete the syntax tree, freeing all of the memory that it used."]
    pub fn ts_tree_delete(self_: *mut TSTree);
}
extern "C" {
    #[doc = " Get the root node of the syntax tree."]
    pub fn ts_tree_root_node(self_: *const TSTree) -> TSNode;
}
extern "C" {
    #[doc = " Get the root node of the syntax tree, but with its position\n shifted forward by the given offset."]
    pub fn ts_tree_root_node_with_offset(
        self_: *const TSTree,
        offset_bytes: u32,
        offset_extent: TSPoint,
    ) -> TSNode;
}
extern "C" {
    #[doc = " Get the language that was used to parse the syntax tree."]
    pub fn ts_tree_language(self_: *const TSTree) -> *const TSLanguage;
}
extern "C" {
    #[doc = " Get the array of included ranges that was used to parse the syntax tree.\n\n The returned pointer must be freed by the caller."]
    pub fn ts_tree_included_ranges(self_: *const TSTree, length: *mut u32) -> *mut TSRange;
}
extern "C" {
    #[doc = " Edit the syntax tree to keep it in sync with source code that has been\n edited.\n\n You must describe the edit both in terms of byte offsets and in terms of\n (row, column) coordinates."]
    pub fn ts_tree_edit(self_: *mut TSTree, edit: *const TSInputEdit);
}
extern "C" {
    #[doc = " Compare an old edited syntax tree to a new syntax tree representing the same\n document, returning an array of ranges whose syntactic structure has changed.\n\n For this to work correctly, the old syntax tree must have been edited such\n that its ranges match up to the new tree. Generally, you'll want to call\n this function right after calling one of the [`ts_parser_parse`] functions.\n You need to pass the old tree that was passed to parse, as well as the new\n tree that was returned from that function.\n\n The returned ranges indicate areas where the hierarchical structure of syntax\n nodes (from root to leaf) has changed between the old and new trees. Characters\n outside these ranges have identical ancestor nodes in both trees.\n\n Note that the returned ranges may be slightly larger than the exact changed areas,\n but Tree-sitter attempts to make them as small as possible.\n\n The returned array is allocated using `malloc` and the caller is responsible\n for freeing it using `free`. The length of the array will be written to the\n given `length` pointer."]
    pub fn ts_tree_get_changed_ranges(
        old_tree: *const TSTree,
        new_tree: *const TSTree,
        length: *mut u32,
    ) -> *mut TSRange;
}
extern "C" {
    #[doc = " Write a DOT graph describing the syntax tree to the given file."]
    pub fn ts_tree_print_dot_graph(self_: *const TSTree, file_descriptor: ::core::ffi::c_int);
}
extern "C" {
    #[doc = " Get the node's type as a null-terminated string."]
    pub fn ts_node_type(self_: TSNode) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Get the node's type as a numerical id."]
    pub fn ts_node_symbol(self_: TSNode) -> TSSymbol;
}
extern "C" {
    #[doc = " Get the node's language."]
    pub fn ts_node_language(self_: TSNode) -> *const TSLanguage;
}
extern "C" {
    #[doc = " Get the node's type as it appears in the grammar ignoring aliases as a\n null-terminated string."]
    pub fn ts_node_grammar_type(self_: TSNode) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Get the node's type as a numerical id as it appears in the grammar ignoring\n aliases. This should be used in [`ts_language_next_state`] instead of\n [`ts_node_symbol`]."]
    pub fn ts_node_grammar_symbol(self_: TSNode) -> TSSymbol;
}
extern "C" {
    #[doc = " Get the node's start byte."]
    pub fn ts_node_start_byte(self_: TSNode) -> u32;
}
extern "C" {
    #[doc = " Get the node's start position in terms of rows and columns."]
    pub fn ts_node_start_point(self_: TSNode) -> TSPoint;
}
extern "C" {
    #[doc = " Get the node's end byte."]
    pub fn ts_node_end_byte(self_: TSNode) -> u32;
}
extern "C" {
    #[doc = " Get the node's end position in terms of rows and columns."]
    pub fn ts_node_end_point(self_: TSNode) -> TSPoint;
}
extern "C" {
    #[doc = " Get an S-expression representing the node as a string.\n\n This string is allocated with `malloc` and the caller is responsible for\n freeing it using `free`."]
    pub fn ts_node_string(self_: TSNode) -> *mut ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Check if the node is null. Functions like [`ts_node_child`] and\n [`ts_node_next_sibling`] will return a null node to indicate that no such node\n was found."]
    pub fn ts_node_is_null(self_: TSNode) -> bool;
}
extern "C" {
    #[doc = " Check if the node is *named*. Named nodes correspond to named rules in the\n grammar, whereas *anonymous* nodes correspond to string literals in the\n grammar."]
    pub fn ts_node_is_named(self_: TSNode) -> bool;
}
extern "C" {
    #[doc = " Check if the node is *missing*. Missing nodes are inserted by the parser in\n order to recover from certain kinds of syntax errors."]
    pub fn ts_node_is_missing(self_: TSNode) -> bool;
}
extern "C" {
    #[doc = " Check if the node is *extra*. Extra nodes represent things like comments,\n which are not required the grammar, but can appear anywhere."]
    pub fn ts_node_is_extra(self_: TSNode) -> bool;
}
extern "C" {
    #[doc = " Check if a syntax node has been edited."]
    pub fn ts_node_has_changes(self_: TSNode) -> bool;
}
extern "C" {
    #[doc = " Check if the node is a syntax error or contains any syntax errors."]
    pub fn ts_node_has_error(self_: TSNode) -> bool;
}
extern "C" {
    #[doc = " Check if the node is a syntax error."]
    pub fn ts_node_is_error(self_: TSNode) -> bool;
}
extern "C" {
    #[doc = " Get this node's parse state."]
    pub fn ts_node_parse_state(self_: TSNode) -> TSStateId;
}
extern "C" {
    #[doc = " Get the parse state after this node."]
    pub fn ts_node_next_parse_state(self_: TSNode) -> TSStateId;
}
extern "C" {
    #[doc = " Get the node's immediate parent.\n Prefer [`ts_node_child_with_descendant`] for\n iterating over the node's ancestors."]
    pub fn ts_node_parent(self_: TSNode) -> TSNode;
}
extern "C" {
    #[doc = " Get the node that contains `descendant`.\n\n Note that this can return `descendant` itself."]
    pub fn ts_node_child_with_descendant(self_: TSNode, descendant: TSNode) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's child at the given index, where zero represents the first\n child."]
    pub fn ts_node_child(self_: TSNode, child_index: u32) -> TSNode;
}
extern "C" {
    #[doc = " Get the field name for node's child at the given index, where zero represents\n the first child. Returns NULL, if no field is found."]
    pub fn ts_node_field_name_for_child(
        self_: TSNode,
        child_index: u32,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Get the field name for node's named child at the given index, where zero\n represents the first named child. Returns NULL, if no field is found."]
    pub fn ts_node_field_name_for_named_child(
        self_: TSNode,
        named_child_index: u32,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Get the node's number of children."]
    pub fn ts_node_child_count(self_: TSNode) -> u32;
}
extern "C" {
    #[doc = " Get the node's *named* child at the given index.\n\n See also [`ts_node_is_named`]."]
    pub fn ts_node_named_child(self_: TSNode, child_index: u32) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's number of *named* children.\n\n See also [`ts_node_is_named`]."]
    pub fn ts_node_named_child_count(self_: TSNode) -> u32;
}
extern "C" {
    #[doc = " Get the node's child with the given field name."]
    pub fn ts_node_child_by_field_name(
        self_: TSNode,
        name: *const ::core::ffi::c_char,
        name_length: u32,
    ) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's child with the given numerical field id.\n\n You can convert a field name to an id using the\n [`ts_language_field_id_for_name`] function."]
    pub fn ts_node_child_by_field_id(self_: TSNode, field_id: TSFieldId) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's next / previous sibling."]
    pub fn ts_node_next_sibling(self_: TSNode) -> TSNode;
}
extern "C" {
    pub fn ts_node_prev_sibling(self_: TSNode) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's next / previous *named* sibling."]
    pub fn ts_node_next_named_sibling(self_: TSNode) -> TSNode;
}
extern "C" {
    pub fn ts_node_prev_named_sibling(self_: TSNode) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's first child that contains or starts after the given byte offset."]
    pub fn ts_node_first_child_for_byte(self_: TSNode, byte: u32) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's first named child that contains or starts after the given byte offset."]
    pub fn ts_node_first_named_child_for_byte(self_: TSNode, byte: u32) -> TSNode;
}
extern "C" {
    #[doc = " Get the node's number of descendants, including one for the node itself."]
    pub fn ts_node_descendant_count(self_: TSNode) -> u32;
}
extern "C" {
    #[doc = " Get the smallest node within this node that spans the given range of bytes\n or (row, column) positions."]
    pub fn ts_node_descendant_for_byte_range(self_: TSNode, start: u32, end: u32) -> TSNode;
}
extern "C" {
    pub fn ts_node_descendant_for_point_range(
        self_: TSNode,
        start: TSPoint,
        end: TSPoint,
    ) -> TSNode;
}
extern "C" {
    #[doc = " Get the smallest named node within this node that spans the given range of\n bytes or (row, column) positions."]
    pub fn ts_node_named_descendant_for_byte_range(self_: TSNode, start: u32, end: u32) -> TSNode;
}
extern "C" {
    pub fn ts_node_named_descendant_for_point_range(
        self_: TSNode,
        start: TSPoint,
        end: TSPoint,
    ) -> TSNode;
}
extern "C" {
    #[doc = " Edit the node to keep it in-sync with source code that has been edited.\n\n This function is only rarely needed. When you edit a syntax tree with the\n [`ts_tree_edit`] function, all of the nodes that you retrieve from the tree\n afterward will already reflect the edit. You only need to use [`ts_node_edit`]\n when you have a [`TSNode`] instance that you want to keep and continue to use\n after an edit."]
    pub fn ts_node_edit(self_: *mut TSNode, edit: *const TSInputEdit);
}
extern "C" {
    #[doc = " Check if two nodes are identical."]
    pub fn ts_node_eq(self_: TSNode, other: TSNode) -> bool;
}
extern "C" {
    #[doc = " Create a new tree cursor starting from the given node.\n\n A tree cursor allows you to walk a syntax tree more efficiently than is\n possible using the [`TSNode`] functions. It is a mutable object that is always\n on a certain syntax node, and can be moved imperatively to different nodes.\n\n Note that the given node is considered the root of the cursor,\n and the cursor cannot walk outside this node."]
    pub fn ts_tree_cursor_new(node: TSNode) -> TSTreeCursor;
}
extern "C" {
    #[doc = " Delete a tree cursor, freeing all of the memory that it used."]
    pub fn ts_tree_cursor_delete(self_: *mut TSTreeCursor);
}
extern "C" {
    #[doc = " Re-initialize a tree cursor to start at the original node that the cursor was\n constructed with."]
    pub fn ts_tree_cursor_reset(self_: *mut TSTreeCursor, node: TSNode);
}
extern "C" {
    #[doc = " Re-initialize a tree cursor to the same position as another cursor.\n\n Unlike [`ts_tree_cursor_reset`], this will not lose parent information and\n allows reusing already created cursors."]
    pub fn ts_tree_cursor_reset_to(dst: *mut TSTreeCursor, src: *const TSTreeCursor);
}
extern "C" {
    #[doc = " Get the tree cursor's current node."]
    pub fn ts_tree_cursor_current_node(self_: *const TSTreeCursor) -> TSNode;
}
extern "C" {
    #[doc = " Get the field name of the tree cursor's current node.\n\n This returns `NULL` if the current node doesn't have a field.\n See also [`ts_node_child_by_field_name`]."]
    pub fn ts_tree_cursor_current_field_name(
        self_: *const TSTreeCursor,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Get the field id of the tree cursor's current node.\n\n This returns zero if the current node doesn't have a field.\n See also [`ts_node_child_by_field_id`], [`ts_language_field_id_for_name`]."]
    pub fn ts_tree_cursor_current_field_id(self_: *const TSTreeCursor) -> TSFieldId;
}
extern "C" {
    #[doc = " Move the cursor to the parent of its current node.\n\n This returns `true` if the cursor successfully moved, and returns `false`\n if there was no parent node (the cursor was already on the root node).\n\n Note that the node the cursor was constructed with is considered the root\n of the cursor, and the cursor cannot walk outside this node."]
    pub fn ts_tree_cursor_goto_parent(self_: *mut TSTreeCursor) -> bool;
}
extern "C" {
    #[doc = " Move the cursor to the next sibling of its current node.\n\n This returns `true` if the cursor successfully moved, and returns `false`\n if there was no next sibling node.\n\n Note that the node the cursor was constructed with is considered the root\n of the cursor, and the cursor cannot walk outside this node."]
    pub fn ts_tree_cursor_goto_next_sibling(self_: *mut TSTreeCursor) -> bool;
}
extern "C" {
    #[doc = " Move the cursor to the previous sibling of its current node.\n\n This returns `true` if the cursor successfully moved, and returns `false` if\n there was no previous sibling node.\n\n Note, that this function may be slower than\n [`ts_tree_cursor_goto_next_sibling`] due to how node positions are stored. In\n the worst case, this will need to iterate through all the children up to the\n previous sibling node to recalculate its position. Also note that the node the cursor\n was constructed with is considered the root of the cursor, and the cursor cannot\n walk outside this node."]
    pub fn ts_tree_cursor_goto_previous_sibling(self_: *mut TSTreeCursor) -> bool;
}
extern "C" {
    #[doc = " Move the cursor to the first child of its current node.\n\n This returns `true` if the cursor successfully moved, and returns `false`\n if there were no children."]
    pub fn ts_tree_cursor_goto_first_child(self_: *mut TSTreeCursor) -> bool;
}
extern "C" {
    #[doc = " Move the cursor to the last child of its current node.\n\n This returns `true` if the cursor successfully moved, and returns `false` if\n there were no children.\n\n Note that this function may be slower than [`ts_tree_cursor_goto_first_child`]\n because it needs to iterate through all the children to compute the child's\n position."]
    pub fn ts_tree_cursor_goto_last_child(self_: *mut TSTreeCursor) -> bool;
}
extern "C" {
    #[doc = " Move the cursor to the node that is the nth descendant of\n the original node that the cursor was constructed with, where\n zero represents the original node itself."]
    pub fn ts_tree_cursor_goto_descendant(self_: *mut TSTreeCursor, goal_descendant_index: u32);
}
extern "C" {
    #[doc = " Get the index of the cursor's current node out of all of the\n descendants of the original node that the cursor was constructed with."]
    pub fn ts_tree_cursor_current_descendant_index(self_: *const TSTreeCursor) -> u32;
}
extern "C" {
    #[doc = " Get the depth of the cursor's current node relative to the original\n node that the cursor was constructed with."]
    pub fn ts_tree_cursor_current_depth(self_: *const TSTreeCursor) -> u32;
}
extern "C" {
    #[doc = " Move the cursor to the first child of its current node that contains or starts after\n the given byte offset or point.\n\n This returns the index of the child node if one was found, and returns -1\n if no such child was found."]
    pub fn ts_tree_cursor_goto_first_child_for_byte(
        self_: *mut TSTreeCursor,
        goal_byte: u32,
    ) -> i64;
}
extern "C" {
    pub fn ts_tree_cursor_goto_first_child_for_point(
        self_: *mut TSTreeCursor,
        goal_point: TSPoint,
    ) -> i64;
}
extern "C" {
    pub fn ts_tree_cursor_copy(cursor: *const TSTreeCursor) -> TSTreeCursor;
}
extern "C" {
    #[doc = " Create a new query from a string containing one or more S-expression\n patterns. The query is associated with a particular language, and can\n only be run on syntax nodes parsed with that language.\n\n If all of the given patterns are valid, this returns a [`TSQuery`].\n If a pattern is invalid, this returns `NULL`, and provides two pieces\n of information about the problem:\n 1. The byte offset of the error is written to the `error_offset` parameter.\n 2. The type of error is written to the `error_type` parameter."]
    pub fn ts_query_new(
        language: *const TSLanguage,
        source: *const ::core::ffi::c_char,
        source_len: u32,
        error_offset: *mut u32,
        error_type: *mut TSQueryError,
    ) -> *mut TSQuery;
}
extern "C" {
    #[doc = " Delete a query, freeing all of the memory that it used."]
    pub fn ts_query_delete(self_: *mut TSQuery);
}
extern "C" {
    #[doc = " Get the number of patterns, captures, or string literals in the query."]
    pub fn ts_query_pattern_count(self_: *const TSQuery) -> u32;
}
extern "C" {
    pub fn ts_query_capture_count(self_: *const TSQuery) -> u32;
}
extern "C" {
    pub fn ts_query_string_count(self_: *const TSQuery) -> u32;
}
extern "C" {
    #[doc = " Get the byte offset where the given pattern starts in the query's source.\n\n This can be useful when combining queries by concatenating their source\n code strings."]
    pub fn ts_query_start_byte_for_pattern(self_: *const TSQuery, pattern_index: u32) -> u32;
}
extern "C" {
    #[doc = " Get the byte offset where the given pattern ends in the query's source.\n\n This can be useful when combining queries by concatenating their source\n code strings."]
    pub fn ts_query_end_byte_for_pattern(self_: *const TSQuery, pattern_index: u32) -> u32;
}
extern "C" {
    #[doc = " Get all of the predicates for the given pattern in the query.\n\n The predicates are represented as a single array of steps. There are three\n types of steps in this array, which correspond to the three legal values for\n the `type` field:\n - `TSQueryPredicateStepTypeCapture` - Steps with this type represent names\n    of captures. Their `value_id` can be used with the\n   [`ts_query_capture_name_for_id`] function to obtain the name of the capture.\n - `TSQueryPredicateStepTypeString` - Steps with this type represent literal\n    strings. Their `value_id` can be used with the\n    [`ts_query_string_value_for_id`] function to obtain their string value.\n - `TSQueryPredicateStepTypeDone` - Steps with this type are *sentinels*\n    that represent the end of an individual predicate. If a pattern has two\n    predicates, then there will be two steps with this `type` in the array."]
    pub fn ts_query_predicates_for_pattern(
        self_: *const TSQuery,
        pattern_index: u32,
        step_count: *mut u32,
    ) -> *const TSQueryPredicateStep;
}
extern "C" {
    pub fn ts_query_is_pattern_rooted(self_: *const TSQuery, pattern_index: u32) -> bool;
}
extern "C" {
    pub fn ts_query_is_pattern_non_local(self_: *const TSQuery, pattern_index: u32) -> bool;
}
extern "C" {
    pub fn ts_query_is_pattern_guaranteed_at_step(self_: *const TSQuery, byte_offset: u32) -> bool;
}
extern "C" {
    #[doc = " Get the name and length of one of the query's captures, or one of the\n query's string literals. Each capture and string is associated with a\n numeric id based on the order that it appeared in the query's source."]
    pub fn ts_query_capture_name_for_id(
        self_: *const TSQuery,
        index: u32,
        length: *mut u32,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Get the quantifier of the query's captures. Each capture is * associated\n with a numeric id based on the order that it appeared in the query's source."]
    pub fn ts_query_capture_quantifier_for_id(
        self_: *const TSQuery,
        pattern_index: u32,
        capture_index: u32,
    ) -> TSQuantifier;
}
extern "C" {
    pub fn ts_query_string_value_for_id(
        self_: *const TSQuery,
        index: u32,
        length: *mut u32,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Disable a certain capture within a query.\n\n This prevents the capture from being returned in matches, and also avoids\n any resource usage associated with recording the capture. Currently, there\n is no way to undo this."]
    pub fn ts_query_disable_capture(
        self_: *mut TSQuery,
        name: *const ::core::ffi::c_char,
        length: u32,
    );
}
extern "C" {
    #[doc = " Disable a certain pattern within a query.\n\n This prevents the pattern from matching and removes most of the overhead\n associated with the pattern. Currently, there is no way to undo this."]
    pub fn ts_query_disable_pattern(self_: *mut TSQuery, pattern_index: u32);
}
extern "C" {
    #[doc = " Create a new cursor for executing a given query.\n\n The cursor stores the state that is needed to iteratively search\n for matches. To use the query cursor, first call [`ts_query_cursor_exec`]\n to start running a given query on a given syntax node. Then, there are\n two options for consuming the results of the query:\n 1. Repeatedly call [`ts_query_cursor_next_match`] to iterate over all of the\n    *matches* in the order that they were found. Each match contains the\n    index of the pattern that matched, and an array of captures. Because\n    multiple patterns can match the same set of nodes, one match may contain\n    captures that appear *before* some of the captures from a previous match.\n 2. Repeatedly call [`ts_query_cursor_next_capture`] to iterate over all of the\n    individual *captures* in the order that they appear. This is useful if\n    don't care about which pattern matched, and just want a single ordered\n    sequence of captures.\n\n If you don't care about consuming all of the results, you can stop calling\n [`ts_query_cursor_next_match`] or [`ts_query_cursor_next_capture`] at any point.\n  You can then start executing another query on another node by calling\n  [`ts_query_cursor_exec`] again."]
    pub fn ts_query_cursor_new() -> *mut TSQueryCursor;
}
extern "C" {
    #[doc = " Delete a query cursor, freeing all of the memory that it used."]
    pub fn ts_query_cursor_delete(self_: *mut TSQueryCursor);
}
extern "C" {
    #[doc = " Start running a given query on a given node."]
    pub fn ts_query_cursor_exec(self_: *mut TSQueryCursor, query: *const TSQuery, node: TSNode);
}
extern "C" {
    #[doc = " Start running a given query on a given node, with some options."]
    pub fn ts_query_cursor_exec_with_options(
        self_: *mut TSQueryCursor,
        query: *const TSQuery,
        node: TSNode,
        query_options: *const TSQueryCursorOptions,
    );
}
extern "C" {
    #[doc = " Manage the maximum number of in-progress matches allowed by this query\n cursor.\n\n Query cursors have an optional maximum capacity for storing lists of\n in-progress captures. If this capacity is exceeded, then the\n earliest-starting match will silently be dropped to make room for further\n matches. This maximum capacity is optional — by default, query cursors allow\n any number of pending matches, dynamically allocating new space for them as\n needed as the query is executed."]
    pub fn ts_query_cursor_did_exceed_match_limit(self_: *const TSQueryCursor) -> bool;
}
extern "C" {
    pub fn ts_query_cursor_match_limit(self_: *const TSQueryCursor) -> u32;
}
extern "C" {
    pub fn ts_query_cursor_set_match_limit(self_: *mut TSQueryCursor, limit: u32);
}
extern "C" {
    #[doc = " @deprecated use [`ts_query_cursor_exec_with_options`] and pass in a callback instead, this will be removed in 0.26.\n\n Set the maximum duration in microseconds that query execution should be allowed to\n take before halting.\n\n If query execution takes longer than this, it will halt early, returning NULL.\n See [`ts_query_cursor_next_match`] or [`ts_query_cursor_next_capture`] for more information."]
    pub fn ts_query_cursor_set_timeout_micros(self_: *mut TSQueryCursor, timeout_micros: u64);
}
extern "C" {
    #[doc = " @deprecated use [`ts_query_cursor_exec_with_options`] and pass in a callback instead, this will be removed in 0.26.\n\n Get the duration in microseconds that query execution is allowed to take.\n\n This is set via [`ts_query_cursor_set_timeout_micros`]."]
    pub fn ts_query_cursor_timeout_micros(self_: *const TSQueryCursor) -> u64;
}
extern "C" {
    #[doc = " Set the range of bytes in which the query will be executed.\n\n The query cursor will return matches that intersect with the given point range.\n This means that a match may be returned even if some of its captures fall\n outside the specified range, as long as at least part of the match\n overlaps with the range.\n\n For example, if a query pattern matches a node that spans a larger area\n than the specified range, but part of that node intersects with the range,\n the entire match will be returned.\n\n This will return `false` if the start byte is greater than the end byte, otherwise\n it will return `true`."]
    pub fn ts_query_cursor_set_byte_range(
        self_: *mut TSQueryCursor,
        start_byte: u32,
        end_byte: u32,
    ) -> bool;
}
extern "C" {
    #[doc = " Set the range of (row, column) positions in which the query will be executed.\n\n The query cursor will return matches that intersect with the given point range.\n This means that a match may be returned even if some of its captures fall\n outside the specified range, as long as at least part of the match\n overlaps with the range.\n\n For example, if a query pattern matches a node that spans a larger area\n than the specified range, but part of that node intersects with the range,\n the entire match will be returned.\n\n This will return `false` if the start point is greater than the end point, otherwise\n it will return `true`."]
    pub fn ts_query_cursor_set_point_range(
        self_: *mut TSQueryCursor,
        start_point: TSPoint,
        end_point: TSPoint,
    ) -> bool;
}
extern "C" {
    #[doc = " Advance to the next match of the currently running query.\n\n If there is a match, write it to `*match` and return `true`.\n Otherwise, return `false`."]
    pub fn ts_query_cursor_next_match(self_: *mut TSQueryCursor, match_: *mut TSQueryMatch)
        -> bool;
}
extern "C" {
    pub fn ts_query_cursor_remove_match(self_: *mut TSQueryCursor, match_id: u32);
}
extern "C" {
    #[doc = " Advance to the next capture of the currently running query.\n\n If there is a capture, write its match to `*match` and its index within\n the match's capture list to `*capture_index`. Otherwise, return `false`."]
    pub fn ts_query_cursor_next_capture(
        self_: *mut TSQueryCursor,
        match_: *mut TSQueryMatch,
        capture_index: *mut u32,
    ) -> bool;
}
extern "C" {
    #[doc = " Set the maximum start depth for a query cursor.\n\n This prevents cursors from exploring children nodes at a certain depth.\n Note if a pattern includes many children, then they will still be checked.\n\n The zero max start depth value can be used as a special behavior and\n it helps to destructure a subtree by staying on a node and using captures\n for interested parts. Note that the zero max start depth only limit a search\n depth for a pattern's root node but other nodes that are parts of the pattern\n may be searched at any depth what defined by the pattern structure.\n\n Set to `UINT32_MAX` to remove the maximum start depth."]
    pub fn ts_query_cursor_set_max_start_depth(self_: *mut TSQueryCursor, max_start_depth: u32);
}
extern "C" {
    #[doc = " Get another reference to the given language."]
    pub fn ts_language_copy(self_: *const TSLanguage) -> *const TSLanguage;
}
extern "C" {
    #[doc = " Free any dynamically-allocated resources for this language, if\n this is the last reference."]
    pub fn ts_language_delete(self_: *const TSLanguage);
}
extern "C" {
    #[doc = " Get the number of distinct node types in the language."]
    pub fn ts_language_symbol_count(self_: *const TSLanguage) -> u32;
}
extern "C" {
    #[doc = " Get the number of valid states in this language."]
    pub fn ts_language_state_count(self_: *const TSLanguage) -> u32;
}
extern "C" {
    #[doc = " Get the numerical id for the given node type string."]
    pub fn ts_language_symbol_for_name(
        self_: *const TSLanguage,
        string: *const ::core::ffi::c_char,
        length: u32,
        is_named: bool,
    ) -> TSSymbol;
}
extern "C" {
    #[doc = " Get the number of distinct field names in the language."]
    pub fn ts_language_field_count(self_: *const TSLanguage) -> u32;
}
extern "C" {
    #[doc = " Get the field name string for the given numerical id."]
    pub fn ts_language_field_name_for_id(
        self_: *const TSLanguage,
        id: TSFieldId,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Get the numerical id for the given field name string."]
    pub fn ts_language_field_id_for_name(
        self_: *const TSLanguage,
        name: *const ::core::ffi::c_char,
        name_length: u32,
    ) -> TSFieldId;
}
extern "C" {
    #[doc = " Get a list of all supertype symbols for the language."]
    pub fn ts_language_supertypes(self_: *const TSLanguage, length: *mut u32) -> *const TSSymbol;
}
extern "C" {
    #[doc = " Get a list of all subtype symbol ids for a given supertype symbol.\n\n See [`ts_language_supertypes`] for fetching all supertype symbols."]
    pub fn ts_language_subtypes(
        self_: *const TSLanguage,
        supertype: TSSymbol,
        length: *mut u32,
    ) -> *const TSSymbol;
}
extern "C" {
    #[doc = " Get a node type string for the given numerical id."]
    pub fn ts_language_symbol_name(
        self_: *const TSLanguage,
        symbol: TSSymbol,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Check whether the given node type id belongs to named nodes, anonymous nodes,\n or a hidden nodes.\n\n See also [`ts_node_is_named`]. Hidden nodes are never returned from the API."]
    pub fn ts_language_symbol_type(self_: *const TSLanguage, symbol: TSSymbol) -> TSSymbolType;
}
extern "C" {
    #[doc = " @deprecated use [`ts_language_abi_version`] instead, this will be removed in 0.26.\n\n Get the ABI version number for this language. This version number is used\n to ensure that languages were generated by a compatible version of\n Tree-sitter.\n\n See also [`ts_parser_set_language`]."]
    pub fn ts_language_version(self_: *const TSLanguage) -> u32;
}
extern "C" {
    #[doc = " Get the ABI version number for this language. This version number is used\n to ensure that languages were generated by a compatible version of\n Tree-sitter.\n\n See also [`ts_parser_set_language`]."]
    pub fn ts_language_abi_version(self_: *const TSLanguage) -> u32;
}
extern "C" {
    #[doc = " Get the metadata for this language. This information is generated by the\n CLI, and relies on the language author providing the correct metadata in\n the language's `tree-sitter.json` file.\n\n See also [`TSMetadata`]."]
    pub fn ts_language_metadata(self_: *const TSLanguage) -> *const TSLanguageMetadata;
}
extern "C" {
    #[doc = " Get the next parse state. Combine this with lookahead iterators to generate\n completion suggestions or valid symbols in error nodes. Use\n [`ts_node_grammar_symbol`] for valid symbols."]
    pub fn ts_language_next_state(
        self_: *const TSLanguage,
        state: TSStateId,
        symbol: TSSymbol,
    ) -> TSStateId;
}
extern "C" {
    #[doc = " Get the name of this language. This returns `NULL` in older parsers."]
    pub fn ts_language_name(self_: *const TSLanguage) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " Create a new lookahead iterator for the given language and parse state.\n\n This returns `NULL` if state is invalid for the language.\n\n Repeatedly using [`ts_lookahead_iterator_next`] and\n [`ts_lookahead_iterator_current_symbol`] will generate valid symbols in the\n given parse state. Newly created lookahead iterators will contain the `ERROR`\n symbol.\n\n Lookahead iterators can be useful to generate suggestions and improve syntax\n error diagnostics. To get symbols valid in an ERROR node, use the lookahead\n iterator on its first leaf node state. For `MISSING` nodes, a lookahead\n iterator created on the previous non-extra leaf node may be appropriate."]
    pub fn ts_lookahead_iterator_new(
        self_: *const TSLanguage,
        state: TSStateId,
    ) -> *mut TSLookaheadIterator;
}
extern "C" {
    #[doc = " Delete a lookahead iterator freeing all the memory used."]
    pub fn ts_lookahead_iterator_delete(self_: *mut TSLookaheadIterator);
}
extern "C" {
    #[doc = " Reset the lookahead iterator to another state.\n\n This returns `true` if the iterator was reset to the given state and `false`\n otherwise."]
    pub fn ts_lookahead_iterator_reset_state(
        self_: *mut TSLookaheadIterator,
        state: TSStateId,
    ) -> bool;
}
extern "C" {
    #[doc = " Reset the lookahead iterator.\n\n This returns `true` if the language was set successfully and `false`\n otherwise."]
    pub fn ts_lookahead_iterator_reset(
        self_: *mut TSLookaheadIterator,
        language: *const TSLanguage,
        state: TSStateId,
    ) -> bool;
}
extern "C" {
    #[doc = " Get the current language of the lookahead iterator."]
    pub fn ts_lookahead_iterator_language(self_: *const TSLookaheadIterator) -> *const TSLanguage;
}
extern "C" {
    #[doc = " Advance the lookahead iterator to the next symbol.\n\n This returns `true` if there is a new symbol and `false` otherwise."]
    pub fn ts_lookahead_iterator_next(self_: *mut TSLookaheadIterator) -> bool;
}
extern "C" {
    #[doc = " Get the current symbol of the lookahead iterator;"]
    pub fn ts_lookahead_iterator_current_symbol(self_: *const TSLookaheadIterator) -> TSSymbol;
}
extern "C" {
    #[doc = " Get the current symbol type of the lookahead iterator as a null terminated\n string."]
    pub fn ts_lookahead_iterator_current_symbol_name(
        self_: *const TSLookaheadIterator,
    ) -> *const ::core::ffi::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct wasm_engine_t {
    _unused: [u8; 0],
}
pub type TSWasmEngine = wasm_engine_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSWasmStore {
    _unused: [u8; 0],
}
pub const TSWasmErrorKindNone: TSWasmErrorKind = 0;
pub const TSWasmErrorKindParse: TSWasmErrorKind = 1;
pub const TSWasmErrorKindCompile: TSWasmErrorKind = 2;
pub const TSWasmErrorKindInstantiate: TSWasmErrorKind = 3;
pub const TSWasmErrorKindAllocate: TSWasmErrorKind = 4;
pub type TSWasmErrorKind = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSWasmError {
    pub kind: TSWasmErrorKind,
    pub message: *mut ::core::ffi::c_char,
}
extern "C" {
    #[doc = " Create a Wasm store."]
    pub fn ts_wasm_store_new(
        engine: *mut TSWasmEngine,
        error: *mut TSWasmError,
    ) -> *mut TSWasmStore;
}
extern "C" {
    #[doc = " Free the memory associated with the given Wasm store."]
    pub fn ts_wasm_store_delete(arg1: *mut TSWasmStore);
}
extern "C" {
    #[doc = " Create a language from a buffer of Wasm. The resulting language behaves\n like any other Tree-sitter language, except that in order to use it with\n a parser, that parser must have a Wasm store. Note that the language\n can be used with any Wasm store, it doesn't need to be the same store that\n was used to originally load it."]
    pub fn ts_wasm_store_load_language(
        arg1: *mut TSWasmStore,
        name: *const ::core::ffi::c_char,
        wasm: *const ::core::ffi::c_char,
        wasm_len: u32,
        error: *mut TSWasmError,
    ) -> *const TSLanguage;
}
extern "C" {
    #[doc = " Get the number of languages instantiated in the given wasm store."]
    pub fn ts_wasm_store_language_count(arg1: *const TSWasmStore) -> usize;
}
extern "C" {
    #[doc = " Check if the language came from a Wasm module. If so, then in order to use\n this language with a Parser, that parser must have a Wasm store assigned."]
    pub fn ts_language_is_wasm(arg1: *const TSLanguage) -> bool;
}
extern "C" {
    #[doc = " Assign the given Wasm store to the parser. A parser must have a Wasm store\n in order to use Wasm languages."]
    pub fn ts_parser_set_wasm_store(arg1: *mut TSParser, arg2: *mut TSWasmStore);
}
extern "C" {
    #[doc = " Remove the parser's current Wasm store and return it. This returns NULL if\n the parser doesn't have a Wasm store."]
    pub fn ts_parser_take_wasm_store(arg1: *mut TSParser) -> *mut TSWasmStore;
}
extern "C" {
    #[doc = " Set the allocation functions used by the library.\n\n By default, Tree-sitter uses the standard libc allocation functions,\n but aborts the process when an allocation fails. This function lets\n you supply alternative allocation functions at runtime.\n\n If you pass `NULL` for any parameter, Tree-sitter will switch back to\n its default implementation of that function.\n\n If you call this function after the library has already been used, then\n you must ensure that either:\n  1. All the existing objects have been freed.\n  2. The new allocator shares its state with the old one, so it is capable\n     of freeing memory that was allocated by the old allocator."]
    pub fn ts_set_allocator(
        new_malloc: ::core::option::Option<
            unsafe extern "C" fn(arg1: usize) -> *mut ::core::ffi::c_void,
        >,
        new_calloc: ::core::option::Option<
            unsafe extern "C" fn(arg1: usize, arg2: usize) -> *mut ::core::ffi::c_void,
        >,
        new_realloc: ::core::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::core::ffi::c_void,
                arg2: usize,
            ) -> *mut ::core::ffi::c_void,
        >,
        new_free: ::core::option::Option<unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void)>,
    );
}
