# Doxygen for TileDB C and C++ API inline documentation

This directory contains the structure used to generate TileDB C and C++ API documentation from inline code-comment documentation, using [Doxygen](https://www.doxygen.nl/), [Sphinx](https://www.sphinx-doc.org/en/master/) and [Breathe](https://breathe.readthedocs.io/en/latest/).

## Build system integration

Doxygen is integrated in the build system via a `doc` target defined in [cmake/Modules/Doxygen.cmake](../../cmake/Modules/Doxygen.cmake). The `doc` target executes `doxygen` against an input file list generated by CMake into `<build-dir>/doxyfile.in`. `doxyfile.in` is included by `source/Doxyfile.mk`, which is specified as the config file in the CMake target definition for `doc`. This process extracts doc strings into XML files for further processing.

## Description of contents

* `local-build.sh`: Local doc build script, see below.
* `source/`
    - `*.rst`: template files defining the layout of function and class stubs to be populated by the generator.
    - `gensidebar.py`: Python script to generate `_sidebar.rst.inc`, defining the cross-references to other project API documentation (some integration API docs are not hosted on ReadTheDocs).
    - `conf.py`: Sphinx configuration
        - Project settings for Sphinx and Breathe, as well as search settings for Doxygen output.
        - Note: also contains a call to `subprocess.check_call` which will conditionally (on ReadTheDocs only) bootstrap a TileDB build, then execute `make doc` to run Doxygen
    - `requirements.txt`: Python requirements for Sphinx and Breathe.

# Building API docs locally.

`local-build.sh` creates a Python virtual environment directory ('venv') in the current directory, installs build prerequisites, and runs the Sphinx build process.

    $ ./local-build.sh # (current dir)