---
title: Style Guide
---

When in doubt and not in conflict with this style guide, follow [C++ Core
Guidelines](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines)

## C++ Standards

Where possible we should use up to C++17. Some external packages, such as PDAL are
limited in what they can use. Where we control the environment we should strive
for C++17 usage.

### Table of Contents

* [Functions](Functions.md)
  * With emphasis: [Inputs on the right. Outputs on the left.](Functions.md#inputs-on-the-right-outputs-on-the-left)
* [Memory handling](Memory.md)
* [Storage serialization](Serialization.md)

## CMake

* [CMake guide](CMake.md)
