/*****************************************************************************

        DynArray.h
        By Laurent de Soras

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/

#if !defined(ffft_DynArray_HEADER_INCLUDED)
#  define ffft_DynArray_HEADER_INCLUDED

#  if defined(_MSC_VER)
#    pragma once
#    pragma warning(4 : 4250) // "Inherits via dominance."
#  endif

/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

namespace ffft
{

template<class T>
class DynArray
{

  /*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
  typedef T DataType;

  DynArray();
  explicit DynArray(long size);
  ~DynArray();

  inline long size() const;
  inline void resize(long size);

  inline const DataType &operator[](long pos) const;
  inline DataType &operator[](long pos);

  /*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:
  /*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
  DataType *_data_ptr;
  long _len;

  /*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
  DynArray(const DynArray &other);
  DynArray &operator=(const DynArray &other);
  bool operator==(const DynArray &other);
  bool operator!=(const DynArray &other);

}; // class DynArray

} // namespace ffft

#  include "DynArray.hpp"

#endif // ffft_DynArray_HEADER_INCLUDED

/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
