// Code generated by scripts/include.go using 'go generate'. DO NOT EDIT.
package processor

// Raw languageDatabase loaded
var languageDatabase = map[string]Language{
	"ABAP": {
		LineComment: []string{
			"*",
			"\\\"",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"abap",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ABNF": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"=/ ",
			"/ ",
			"% ",
			"( ",
		},
		Extensions: []string{
			"abnf",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"APL": {
		LineComment: []string{
			"⍝",
		},
		ComplexityChecks: []string{
			":For ",
			":If ",
			":Case ",
			":CaseList ",
			":While ",
			":Repeat ",
			":Else ",
			"∨",
			"∧",
			"≠",
			"~",
			"¨",
			"=",
			":",
		},
		Extensions: []string{
			"apl",
			"aplf",
			"apln",
			"aplc",
			"dyalog",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ASP": {
		LineComment: []string{
			"'",
			"REM",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"asa",
			"asp",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ASP.NET": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"asax",
			"ascx",
			"asmx",
			"aspx",
			"master",
			"sitemap",
			"webinfo",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
			{
				"<%--",
				"-->",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ATS": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"if ",
			"if(",
			" then ",
			" else ",
			"case+ ",
			"ifcase",
			"let ",
			"and ",
		},
		Extensions: []string{
			"dats",
			"sats",
			"ats",
			"hats",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
			{
				"(*",
				"*)",
			},
			{
				"////",
				"THISSHOULDNEVERAPPEARWEHOPE",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"AWK": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"else ",
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"awk",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"awk",
			"gawk",
			"mawk",
			"nawk",
		},
	},
	"ActionScript": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"as",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Ada": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ada",
			"adb",
			"ads",
			"pad",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Agda": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"agda",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Alchemist": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"+",
			"->",
			"!",
		},
		Extensions: []string{
			"crn",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Alex": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"x",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Algol 68": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"IF ",
			"ELIF ",
			"ELSE ",
			"FOR ",
			"WHILE ",
			"CASE ",
			"OUSE ",
			"AND ",
			"OR ",
			"EQ ",
			"NE ",
			"IS ",
			"ISNT ",
			"IS NOT ",
			"~= ",
		},
		Extensions: []string{
			"a68",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"#",
				"#",
			},
			{
				"CO",
				"CO",
			},
			{
				"COMMENT",
				"COMMENT",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Alloy": {
		LineComment: []string{
			"//",
			"--",
		},
		ComplexityChecks: []string{
			"implies ",
			"else ",
			"for ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"<= ",
			">= ",
		},
		Extensions: []string{
			"als",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Android Interface Definition Language": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"aidl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/**",
				"*/",
			},
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"AppleScript": {
		LineComment: []string{
			"#",
			"--",
		},
		ComplexityChecks: []string{
			"considering ",
			"ignoring ",
			"repeat ",
			"while ",
			"if ",
			"else ",
			"else if ",
			"try ",
			"on error ",
			"and ",
			"or ",
		},
		Extensions: []string{
			"applescript",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ArkTs": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"!== ",
			"== ",
			"=== ",
			"case ",
			"case(",
			"?.",
			"?? ",
			"??= ",
		},
		Extensions: []string{
			"ets",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Arturo": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"loop ",
			"map ",
			"select ",
			"if ",
			"if? ",
			"while ",
			"function ",
			"or? ",
			"and? ",
			"not? ",
			"<> ",
			"= ",
		},
		Extensions: []string{
			"art",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"AsciiDoc": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"adoc",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Assembly": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"s",
			"asm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Astro": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			".map",
		},
		Extensions: []string{
			"astro",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"AutoHotKey": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ahk",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Autoconf": {
		LineComment: []string{
			"#",
			"dnl",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"in",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Avro": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"avdl",
			"avpr",
			"avsc",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"BASH": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"bash",
			"bash_login",
			"bash_logout",
			"bash_profile",
			"bashrc",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			".bash_login",
			".bash_logout",
			".bash_profile",
			".bashrc",
		},
		SheBangs: []string{
			"bash",
		},
	},
	"Basic": {
		LineComment: []string{
			"'",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"elseif ",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"bas",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Batch": {
		LineComment: []string{
			"REM",
			"::",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"bat",
			"btm",
			"cmd",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Bazel": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"bzl",
			"build.bazel",
			"build",
			"workspace",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Bean": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"bean",
			"beancount",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Bicep": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"@minLength(",
			"@maxLength(",
			"@secure(",
			"[for ",
			"if(",
			"if (",
			" == ",
			" != ",
			" ? ",
			"using ",
			"range(",
			"type ",
			"func ",
		},
		Extensions: []string{
			"bicep",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Bitbake": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"bb",
			"bbappend",
			"bbclass",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Bitbucket Pipeline": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"bitbucket-pipelines.yml",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Blade template": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"@for ",
			"@for(",
			"@foreach ",
			"@foreach(",
			"@forelse ",
			"@forelse(",
			"@each ",
			"@each (",
			"@while ",
			"@while(",
			"@if ",
			"@if(",
			"@unless ",
			"@unless(",
			"@isset ",
			"@isset(",
			"@empty ",
			"@empty(",
			"@else ",
			"@elseif ",
			"@elseif(",
			"@while ",
			"@while(",
			"@switch ",
			"@switch (",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"blade.php",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{{--",
				"--}}",
			},
			{
				"<!--",
				"-->",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Blueprint": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"blp",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Boo": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"elif ",
			"unless ",
			" and ",
			"for ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"boo",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Bosque": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"if ",
			"if(",
			"switch ",
			"match ",
			"case ",
			"| ",
			"|| ",
			"& ",
			"&& ",
			"!= ",
			"!== ",
			"== ",
			"=== ",
		},
		Extensions: []string{
			"bsq",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Brainfuck": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"[",
			"]",
			"<",
			">",
			"+",
			"-",
			".",
			",",
		},
		Extensions: []string{
			"bf",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"BuildStream": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"bst",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"C": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"c",
			"ec",
			"pgc",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"C Header": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"case ",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"h",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"C Shell": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"csh",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			".cshrc",
		},
		SheBangs: []string{
			"csh",
			"tcsh",
		},
	},
	"C#": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"foreach ",
			"foreach(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cs",
			"csx",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "@\"",
				End:          "\"",
				IgnoreEscape: true,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"dotnet",
		},
	},
	"C++": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cc",
			"cpp",
			"cxx",
			"c++",
			"pcc",
			"ino",
			"ccm",
			"cppm",
			"cxxm",
			"c++m",
			"mxx",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"C++ Header": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"hh",
			"hpp",
			"hxx",
			"inl",
			"ipp",
			"ixx",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"C3": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"foreach ",
			"foreach(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"case ",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"defer ",
			"macro ",
		},
		Extensions: []string{
			"c3",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
			{
				"<*",
				"*>",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"CMake": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"foreach ",
			"foreach(",
			"if ",
			"if(",
			"elseif ",
			"elseif(",
			"while ",
			"while(",
			"else ",
			"else(",
			"OR ",
			"AND ",
			"EQUAL ",
			"STREQUAL ",
			"VERSION_EQUAL ",
			"PATH_EQUAL ",
		},
		Extensions: []string{
			"cmake",
			"cmakelists.txt",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"#[[",
				"]]",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"COBOL": {
		LineComment: []string{
			"*",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cob",
			"cbl",
			"ccp",
			"cobol",
			"cpy",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"CSS": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"css",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"CSV": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"csv",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cabal": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cabal",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cairo": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"loop ",
			"if ",
			"if(",
			"match ",
			"match(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cairo",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cangjie": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cj",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cap'n Proto": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"capnp",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cassius": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cassius",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Ceylon": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ceylon",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Chapel": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"switch ",
			"while ",
			"else ",
			"do ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"chpl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Circom": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"while(",
			"else ",
			"else(",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"circom",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Clipper": {
		LineComment: []string{
			"//",
			"&&",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"do while ",
			"while ",
			"else ",
			"elseif ",
			"else(",
			"switch ",
			"case ",
			"otherwise ",
			"begin sequence ",
			"end sequence ",
			"begin sequence(",
			"try ",
			"catch ",
			"finally ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"prg",
			"ch",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Clojure": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"(for ",
			"(when ",
			"(loop ",
			"(doseq ",
			"(cond ",
			"(if",
			"(if-not ",
			"(and ",
			"(or ",
			"(not ",
			"(= ",
			"(not= ",
			"(recur ",
		},
		Extensions: []string{
			"clj",
			"cljc",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ClojureScript": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cljs",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Closure Template": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			">= ",
			"<= ",
			"?: ",
			"? : ",
		},
		Extensions: []string{
			"soy",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/**",
				"*/",
			},
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"CloudFormation (JSON)": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"!GetAtt",
			"!Sub",
			"!Select",
			"!Equals",
			"!If",
			"DependsOn:",
			"!Select",
			"!Equals",
			"!If",
			"Fn::If",
			"Fn::And",
			"Fn::Equals",
			"Fn::Not",
			"Fn::Or",
			"Fn::Base64",
			"Fn::Cidr",
			"Fn::FindInMap",
			"Fn::GetAtt",
			"Fn::GetAZs",
			"Fn::ImportValue",
			"Fn::Join",
			"Fn::Select",
			"Fn::Split",
			"Fn::Sub",
			"Fn::Transform",
		},
		Extensions: []string{
			"json",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords: []string{
			"\"AWSTemplateFormatVersion\"",
			"AWS::",
			"!GetAtt",
			"!Sub",
			"\"DependsOn\"",
			"!Select",
			"!Equals",
			"!If",
			"Fn::If",
			"Fn::And",
			"Fn::Equals",
			"Fn::Not",
			"Fn::Or",
			"Fn::Base64",
			"Fn::Cidr",
			"Fn::FindInMap",
			"Fn::GetAtt",
			"Fn::GetAZs",
			"Fn::ImportValue",
			"Fn::Join",
			"Fn::Select",
			"Fn::Split",
			"Fn::Sub",
			"Fn::Transform",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"CloudFormation (YAML)": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"!GetAtt",
			"!Sub",
			"!Select",
			"!Equals",
			"!If",
			"DependsOn:",
			"!Select",
			"!Equals",
			"!If",
			"Fn::If",
			"Fn::And",
			"Fn::Equals",
			"Fn::Not",
			"Fn::Or",
			"Fn::Base64",
			"Fn::Cidr",
			"Fn::FindInMap",
			"Fn::GetAtt",
			"Fn::GetAZs",
			"Fn::ImportValue",
			"Fn::Join",
			"Fn::Select",
			"Fn::Split",
			"Fn::Sub",
			"Fn::Transform",
		},
		Extensions: []string{
			"yaml",
			"yml",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords: []string{
			"Resources:",
			"AWSTemplateFormatVersion:",
			"Description:",
			"AWS::",
			"Properties:",
			"Name:",
			"Type:",
			"!GetAtt",
			"!Sub",
			"Statement:",
			"Ref:",
			"DependsOn:",
			"!Select",
			"!Equals",
			"!If",
			"Fn::If",
			"Fn::And",
			"Fn::Equals",
			"Fn::Not",
			"Fn::Or",
			"Fn::Base64",
			"Fn::Cidr",
			"Fn::FindInMap",
			"Fn::GetAtt",
			"Fn::GetAZs",
			"Fn::ImportValue",
			"Fn::Join",
			"Fn::Select",
			"Fn::Split",
			"Fn::Sub",
			"Fn::Transform",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"CodeQL": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"and ",
			"or ",
			"implies ",
			"if ",
			"else ",
			"not ",
			"instanceof ",
			"in ",
			"exists(",
			"forall( ",
			"avg(",
			"concat(",
			"count(",
			"max(",
			"min(",
			"rank(",
			"strictconcat(",
			"strictcount(",
			"strictsum(",
			"sum(",
		},
		Extensions: []string{
			"ql",
			"qll",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"CoffeeScript": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"coffee",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"###",
				"###",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cogent": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cogent",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ColdFusion": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cfm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!---",
				"--->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ColdFusion CFScript": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cfc",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Coq": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"v",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords: []string{
			"Require",
			"Hypothesis",
			"Inductive",
			"Remark",
			"Lemma",
			"Proof",
			"Definition",
			"Theorem",
			"Class",
			"Instance",
			"Module",
			"Context",
			"Section",
			"Notation",
			"End",
			"Fixpoint",
			"From Coq",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"Creole": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"creole",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Crystal": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cr",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cuda": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cu",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cypher": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"MATCH",
			"OPTIONAL MATCH",
			"WHERE",
			"UNION",
			"CALL",
			"UNWIND",
			"STARTS WITH",
			"ENDS WITH",
			"CONTAINS",
			"shortestPath",
			"allShortestPaths",
			"-[*..]->",
		},
		Extensions: []string{
			"cypher",
			"cql",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Cython": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"and ",
			"or ",
			"not ",
			"in ",
		},
		Extensions: []string{
			"pyx",
			"pxi",
			"pxd",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"D": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"d",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
			{
				"/+",
				"+/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"rdmd",
		},
	},
	"D2": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"d2",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"DAML": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"if ",
			"then ",
			"else ",
			"|| ",
			"&& ",
			"/= ",
			"== ",
			"case ",
			"do {",
			"forall ",
		},
		Extensions: []string{
			"daml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"DM": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"else ",
			"||",
			"&&",
			"!=",
			"<>",
			"==",
			"in ",
		},
		Extensions: []string{
			"dm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"DOT": {
		LineComment: []string{
			"//",
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"dot",
			"gv",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Dart": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"dart",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Device Tree": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"dts",
			"dtsi",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Dhall": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"dhall",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Docker ignore": {
		LineComment: []string{
			"#",
			"//",
		},
		ComplexityChecks: []string{},
		Extensions:       []string{},
		ExtensionFile:    false,
		MultiLine:        [][]string{},
		Quotes:           []Quote{},
		NestedMultiLine:  false,
		Keywords:         []string{},
		FileNames: []string{
			".dockerignore",
		},
		SheBangs: []string{},
	},
	"Dockerfile": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"dockerfile",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			"dockerfile",
		},
		SheBangs: []string{},
	},
	"Document Type Definition": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"dtd",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Elixir": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"case ",
			"cond ",
			"if ",
			"for ",
			"with ",
			"try ",
			"catch ",
			"rescue ",
			"else ",
			"and ",
			"or ",
			"not ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"|> ",
		},
		Extensions: []string{
			"ex",
			"exs",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Elixir Template": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"case ",
			"cond ",
			"if ",
			"for ",
			"with ",
			"try ",
			"catch ",
			"rescue ",
			"else ",
			"and ",
			"or ",
			"not ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"|> ",
			"<% ",
		},
		Extensions: []string{
			"eex",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Elm": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"case ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"elm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Emacs Dev Env": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ede",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Emacs Lisp": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"el",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"EmiT": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"if ",
			"if(",
			"warp ",
			"time ",
			"kills ",
			"collapse ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"emit",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Erlang": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"erl",
			"hrl",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"escript",
		},
	},
	"Expect": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"exp",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Extensible Stylesheet Language Transformations": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"xslt",
			"xsl",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"F#": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"match ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"fs",
			"fsi",
			"fsx",
			"fsscript",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"F*": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"fst",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"FIDL": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"fidl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"FORTRAN Legacy": {
		LineComment: []string{
			"c",
			"C",
			"!",
			"*",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"f",
			"for",
			"ftn",
			"f77",
			"pfo",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"FSL": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"->",
			"<-",
		},
		Extensions: []string{
			"fsl",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"FXML": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"fxml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Factor": {
		LineComment: []string{
			"!",
		},
		ComplexityChecks: []string{
			"if",
			"when",
			"unless",
			"if*",
			"when*",
			"unless*",
			"?if",
			"?",
			"cond",
			"case",
			"cond>quot",
			"case>quot",
			"alist>quot",
			"while",
			"until",
			"loop",
			"0&&",
			"1&&",
			"2&&",
			"3&&",
			"n&&",
			"&&",
			"0||",
			"1||",
			"2||",
			"3||",
			"n||",
			"||",
			"and",
			"or",
			"xor",
			"eq",
			"=",
			"smart-if",
			"smart-if*",
			"smart-when",
			"smart-when*",
			"smart-unless",
			"smart-unless*",
		},
		Extensions: []string{
			"factor",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"![[",
				"]]",
			},
			{
				"![=[",
				"]=]",
			},
			{
				"![==[",
				"]==]",
			},
			{
				"![===[",
				"]===]",
			},
			{
				"![====[",
				"]====]",
			},
			{
				"![=====[",
				"]=====]",
			},
			{
				"![======[",
				"]======]",
			},
			{
				"/*",
				"*/",
			},
			{
				"((",
				"))",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "STRING:",
				End:          ";",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "[======[",
				End:          "]======]",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "[=====[",
				End:          "]====]",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "[====[",
				End:          "]====]",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "[===[",
				End:          "]===]",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "[==[",
				End:          "]==]",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "[=[",
				End:          "]=]",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "[[",
				End:          "]]",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Fennel": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"(for",
			"(each",
			"(if",
			"(when",
			"(while",
			"(switch",
			"(do",
			"(..",
			"(=",
			"(and",
			"(or",
		},
		Extensions: []string{
			"fnl",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        ",",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Fish": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"fish",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"fish",
		},
	},
	"Flow9": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"if ",
			"if(",
			"else ",
			"else{",
			"fori ",
			"fori(",
			"switch ",
			"switch(",
			"fold ",
			"fold(",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"|> ",
		},
		Extensions: []string{
			"flow",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Forth": {
		LineComment: []string{
			"\\\\",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"4th",
			"forth",
			"fr",
			"frt",
			"fth",
			"f83",
			"fb",
			"fpm",
			"e4",
			"rx",
			"ft",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"( ",
				")",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Fortran Modern": {
		LineComment: []string{
			"!",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"f03",
			"f08",
			"f90",
			"f95",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Fragment Shader File": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"fsh",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Freemarker Template": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"<#list ",
			"<#assign ",
			"<#if ",
			"<#elseif ",
			"<#else>",
			"<#else> ",
			"<#switch  ",
			"<#case ",
			"<#default>",
			"<#default> ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ftl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<#--",
				"-->",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Futhark": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"if ",
			"else ",
			"then ",
			"for ",
			"loop ",
			"while ",
			"|| ",
			"&& ",
			"!= ",
			">= ",
			"<= ",
		},
		Extensions: []string{
			"fut",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"GDScript": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"gd",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"GLSL": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vert",
			"tesc",
			"tese",
			"geom",
			"frag",
			"comp",
			"glsl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"GN": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"if(",
			"if (",
			"else if(",
			"else if (",
			"else(",
			"else (",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"gn",
			"gni",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Game Maker Language": {
		LineComment: []string{
			"//",
			"///",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"repeat ",
			"repeat(",
			"|| ",
			"or ",
			"&& ",
			"and ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"gml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Game Maker Project": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"yyp",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Gemfile": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions:       []string{},
		ExtensionFile:    false,
		MultiLine:        [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			"gemfile",
		},
		SheBangs: []string{},
	},
	"Gherkin Specification": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"given",
			"when",
			"then",
			"and",
		},
		Extensions: []string{
			"feature",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Gleam": {
		LineComment: []string{
			"//",
			"///",
			"////",
		},
		ComplexityChecks: []string{
			"fn ",
			"case ",
			"-> ",
			"if ",
		},
		Extensions: []string{
			"gleam",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Go": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"go ",
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"select ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"go",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Go Template": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"{{if ",
			"{{ if ",
			"{{else",
			"{{ else",
			"{{range ",
			"{{ range ",
			"{{with",
			"{{ with",
		},
		Extensions: []string{
			"tmpl",
			"gohtml",
			"gotxt",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{{/*",
				"*/}}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Go+": {
		LineComment: []string{
			"//",
			"#",
		},
		ComplexityChecks: []string{
			"go ",
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"select ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"?:",
		},
		Extensions: []string{
			"gop",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"gop",
		},
	},
	"Godot Scene": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"tscn",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Gradle": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"gradle",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"GraphQL": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"type ",
			"input ",
			"query ",
			"mutation ",
			"subscription ",
			"directive ",
			"scalar ",
			"enum ",
			"interface ",
			"union ",
			"fragment ",
		},
		Extensions: []string{
			"graphql",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"\"\"\"",
				"\"\"\"",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    true,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Gremlin": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			".where(",
			".union(",
			".repeat(",
			".emit(",
			".and(",
			".or(",
			".not(",
			".as(",
			".by(",
		},
		Extensions: []string{
			"gremlin",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Groovy": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"groovy",
			"grt",
			"gtpl",
			"gvy",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Gwion": {
		LineComment: []string{
			"#!",
		},
		ComplexityChecks: []string{
			"fun ",
			"while(",
			"while (",
			"repeat(",
			"repeat (",
			"if (",
			"if(",
		},
		Extensions: []string{
			"gw",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"HAML": {
		LineComment: []string{
			"-#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"haml",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"HCL": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for_each ",
			"for ",
			"count ",
			"coalesce(",
			"== ",
			"!= ",
			"> ",
			"< ",
			"&& ",
			"|| ",
		},
		Extensions: []string{
			"hcl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"HEEx": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"case ",
			"cond ",
			"if ",
			"for ",
			"with ",
			"try ",
			"catch ",
			"rescue ",
			"else ",
			"and ",
			"or ",
			"not ",
			"!= ",
			"== ",
			"|| ",
			"&& ",
			"|> ",
		},
		Extensions: []string{
			"heex",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<%!--",
				"--%>",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"HEX": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"hex",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"HTML": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"html",
			"htm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Hamlet": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"hamlet",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Handlebars": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"hbs",
			"handlebars",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
			{
				"{{!",
				"}}",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Happy": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"y",
			"ly",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Hare": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"else ",
			"match ",
			"switch ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ha",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Haskell": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"if ",
			"then ",
			"else ",
			"|| ",
			"&& ",
			"/= ",
			"== ",
			"case ",
			"do {",
			"forall ",
		},
		Extensions: []string{
			"hs",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Haxe": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"hx",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"IDL": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"idl",
			"webidl",
			"widl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"INI": {
		LineComment: []string{
			"#",
			";",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"ini",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Idris": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"idr",
			"lidr",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Intel HEX": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"ihex",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Isabelle": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"thy",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{*",
				"*}",
			},
			{
				"(*",
				"*)",
			},
			{
				"‹",
				"›",
			},
			{
				"\\\\<open>",
				"\\\\<close>",
			},
		},
		Quotes: []Quote{
			{
				Start:        "''",
				End:          "''",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JAI": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"jai",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JCL": {
		LineComment: []string{
			"//*",
		},
		ComplexityChecks: []string{
			" IF",
			" THEN",
			" ELSE",
			" PROC=",
			" PGM=",
			" DD ",
			" EXEC ",
			" JOB ",
			" COND=",
			" INCLUDE",
			" PEND",
		},
		Extensions: []string{
			"jcl",
			"jcls",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JSON": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"json",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JSON5": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"json5",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JSONC": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"jsonc",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JSONL": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"jsonl",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JSX": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"jsx",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Jade": {
		LineComment: []string{
			"//-",
		},
		ComplexityChecks: []string{
			"if ",
			"else if ",
			"unless ",
		},
		Extensions: []string{
			"jade",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Janet": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"(if ",
			"(for ",
			"(for ",
			"(cond ",
			"(switch ",
			"(when ",
			"(while ",
			"(loop ",
			"(case ",
		},
		Extensions: []string{
			"janet",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "``",
				End:          "``",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "@\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Java": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"java",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"JavaScript": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"?.",
			"?? ",
			"??= ",
		},
		Extensions: []string{
			"js",
			"cjs",
			"mjs",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"node",
		},
	},
	"JavaServer Pages": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"jsp",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Jenkins Buildfile": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"jenkinsfile",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Jinja": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"{% for ",
			"{%- for ",
			"{% if ",
			"{%- if ",
			"{% else ",
			"{%- else ",
			"{% elif ",
			"{% macro ",
			"{%- macro ",
			"{% call ",
			"{%- call ",
			"{% filter ",
			"{%- filter ",
			"{% set ",
			"{% include ",
			"{% from ",
			"{% extends ",
			"{% with ",
		},
		Extensions: []string{
			"jinja",
			"j2",
			"jinja2",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{#",
				"#}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Jsonnet": {
		LineComment: []string{
			"#",
			"//",
		},
		ComplexityChecks: []string{
			"for",
			"if",
			"else",
			"||",
			"&&",
			"!=",
			"==",
		},
		Extensions: []string{
			"jsonnet",
			"libsonnet",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "|||",
				End:          "|||",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "@\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "@'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"jsonnet",
		},
	},
	"Julia": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"while ",
			"else ",
			"elseif ",
			"elseif(",
			"try ",
			"catch ",
			"finally ",
			"|| ",
			"&& ",
		},
		Extensions: []string{
			"jl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"#=",
				"=#",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Julius": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"julius",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Jupyter": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"ipynb",
			"jpynb",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Just": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"justfile",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"K": {
		LineComment: []string{
			"/",
		},
		ComplexityChecks: []string{
			"'",
			"/",
			"\\",
			"':",
			"/:",
			"\\:",
			"|",
			"&",
			"!",
			"=",
		},
		Extensions: []string{
			"k",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Korn Shell": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ksh",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			".kshrc",
		},
		SheBangs: []string{
			"ksh",
		},
	},
	"Kotlin": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"kt",
			"kts",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Koto": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"while ",
			"until ",
			"continue ",
			"break ",
			"loop ",
			"if ",
			"switch ",
			"match ",
			"then",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"and ",
			"or ",
			"not ",
		},
		Extensions: []string{
			"koto",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"#-",
				"-#",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"LALRPOP": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"match ",
		},
		Extensions: []string{
			"lalrpop",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"#",
				End:          "#\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"##",
				End:          "r##\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"#",
				End:          "r#\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"LD Script": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"lds",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"LESS": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"less",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"LEX": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"l",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"LLVM IR": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"llvm.loop",
			"br ",
			"switch ",
			"indirectbr ",
			"invoke ",
			"callbr ",
			"resume ",
			"catchswitch ",
			"catchret ",
			"cleanupret ",
			"shl ",
			"lshr ",
			"ashr ",
			"and ",
			"or ",
			"xor ",
		},
		Extensions: []string{
			"ll",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"LOLCODE": {
		LineComment: []string{
			"BTW",
		},
		ComplexityChecks: []string{
			"AWSUM THX ",
			"O NOES ",
			"PLZ OPEN FILE ",
			"IM IN YR ",
			"O RLY?",
			"O RLY? ",
			"WTF?",
			"WTF? ",
		},
		Extensions: []string{
			"lol",
			"lols",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"OBTW",
				"TLDR",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"LaTeX": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"tex",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Lean": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"lean",
			"hlean",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/-",
				"-/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"License": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions:       []string{},
		ExtensionFile:    false,
		MultiLine:        [][]string{},
		Quotes:           []Quote{},
		NestedMultiLine:  false,
		Keywords:         []string{},
		FileNames: []string{
			"license",
			"licence",
			"copying",
			"copying3",
			"unlicense",
			"unlicence",
			"license-apache",
			"licence-apache",
			"license-mit",
			"licence-mit",
			"copyright",
		},
		SheBangs: []string{},
	},
	"Lisp": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"lisp",
			"lsp",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"#|",
				"|#",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"sbcl",
		},
	},
	"LiveScript": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"case ",
			"while ",
			"when ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"!== ",
			"xor ",
			"and ",
			"or ",
			"|> ",
			"<< ",
			"<<< ",
			"<<<< ",
			">> ",
			"== ",
		},
		Extensions: []string{
			"ls",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Lua": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"while ",
			"while(",
			"else ",
			"else(",
			"elseif ",
			"elseif(",
			"until ",
			"until(",
			"or ",
			"and ",
			"~= ",
			"== ",
		},
		Extensions: []string{
			"lua",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"--[[",
				"]]",
			},
			{
				"--[=[",
				"]=]",
			},
			{
				"--[==[",
				"]==]",
			},
			{
				"--[===[",
				"]===]",
			},
			{
				"--[====[",
				"]====]",
			},
			{
				"--[=====[",
				"]=====]",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "]]",
				End:          "[[",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"lua",
		},
	},
	"Luau": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"while ",
			"while(",
			"else ",
			"else(",
			"elseif ",
			"elseif(",
			"until ",
			"until(",
			"or ",
			"and ",
			"~= ",
			"== ",
		},
		Extensions: []string{
			"luau",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"--[[",
				"]]",
			},
			{
				"--[=[",
				"]=]",
			},
			{
				"--[==[",
				"]==]",
			},
			{
				"--[===[",
				"]===]",
			},
			{
				"--[====[",
				"]====]",
			},
			{
				"--[=====[",
				"]=====]",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "]]",
				End:          "[[",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"luau",
		},
	},
	"Lucius": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"lucius",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Luna": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"luna",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"MATLAB": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"if ",
			"elseif ",
			"case ",
			"otherwise ",
			"try",
			"for ",
			"while ",
		},
		Extensions: []string{
			"m",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"%{",
				"}%",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords: []string{
			"eye(",
			"zeros(",
			"ones(",
			"transpose(",
			"meshgrid(",
			"mod(",
			"classdef",
			"function",
			"disp(",
			"sin(",
			"tan(",
			"cos(",
			"plot",
			"sqrt(",
			"deblank(",
			"findstr(",
			"strrep(",
			"strcmp(",
			"display(",
			"strcat(",
			"iscellstr(",
			"strfind(",
			"%",
			"fprintf(",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"MDX": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"mdx",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"MQL Header": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mqh",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"MQL4": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mq4",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"MQL5": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mq5",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"MSBuild": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"Condition",
		},
		Extensions: []string{
			"csproj",
			"vbproj",
			"fsproj",
			"vcproj",
			"vcxproj",
			"vcxproj.filters",
			"ilproj",
			"myapp",
			"props",
			"rdlc",
			"resx",
			"settings",
			"sln",
			"targets",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"MUMPS": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mps",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Macromedia eXtensible Markup Language": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"mxml",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Madlang": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mad",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{#",
				"#}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Makefile": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"makefile",
			"mak",
			"mk",
			"bp",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			"makefile",
			"gnumakefile",
		},
		SheBangs: []string{},
	},
	"Mako": {
		LineComment: []string{
			"##",
		},
		ComplexityChecks: []string{
			"% for ",
			"% if ",
			"% else ",
			"% elif ",
			"<% include ",
			"<%def ",
			"<%page ",
			"<%def ",
			"<%block ",
			"<%namespace ",
			"<%inherit ",
		},
		Extensions: []string{
			"mako",
			"mao",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<%doc>",
				"</%doc>",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Markdown": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"md",
			"markdown",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Max": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"maxpat",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Meson": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"foreach ",
			"if ",
			"elif ",
			"unless ",
			"and ",
			"or ",
			"else ",
		},
		Extensions: []string{
			"meson.build",
			"meson_options.txt",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Metal": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"metal",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Modula3": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"m3",
			"mg",
			"ig",
			"i3",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Module-Definition": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"def",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Monkey C": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mc",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Moonbit": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"switch ",
			"while ",
			"else ",
			"loop ",
			"guard ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"match ",
		},
		Extensions: []string{
			"mbt",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Mustache": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mustache",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{{!",
				"}}",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Nial": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"case ",
			"for ",
			"if ",
			"repeat ",
			"while ",
			"or ",
			"and ",
			"= ",
			"equal ",
			"~= ",
			"unequal ",
		},
		Extensions: []string{
			"ndf",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Nim": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"nim",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Nix": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"nix",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Nushell": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"do { ",
			"each {",
			"if ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"nu",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"nu",
		},
	},
	"OCaml": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ml",
			"mli",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Objective C": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"m",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords: []string{
			"#include",
			"printf",
			"stdio.h",
			".h",
			"@import",
			"@interface",
			"@property",
			"@implementation",
			"NSArray",
			"#pragma",
			"static",
			"const",
			"atomic",
			"@end",
			"//",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"Objective C++": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"mm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Odin": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"when ",
			"switch ",
			"defer ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"odin",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Opalang": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"opa",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"OpenQASM": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"else ",
			"else(",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"qasm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"OpenTofu": {
		LineComment: []string{
			"#",
			"//",
		},
		ComplexityChecks: []string{
			"count",
			"for",
			"for_each",
			"if",
			": ",
			"? ",
			"|| ",
			"&& ",
			"!= ",
			"> ",
			">= ",
			"< ",
			"<= ",
			"== ",
		},
		Extensions: []string{
			"tofu",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Org": {
		LineComment: []string{
			"# ",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"org",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Oz": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"oz",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"PHP": {
		LineComment: []string{
			"#",
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"php",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"php",
			"php5",
		},
	},
	"PKGBUILD": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"pkgbuild",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"PL/SQL": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"and ",
			"and(",
			"else ",
			"else(",
			"elseif ",
			"elseif(",
			"if ",
			"if(",
			"loop ",
			"not ",
			"not(",
			"or ",
			"or(",
			"<> ",
			"<>(",
			"= ",
			"=(",
		},
		Extensions: []string{
			"fnc",
			"pkb",
			"pks",
			"prc",
			"trg",
			"vw",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"POML": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"poml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"PRQL": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"case ",
			"&& ",
			"|| ",
			"!= ",
			"== ",
			"~= ",
		},
		Extensions: []string{
			"prql",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "r\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "r'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    true,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"PSL Assertion": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"psl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Pascal": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"AND ",
			"OR ",
			"IF ",
			"ELSE ",
		},
		Extensions: []string{
			"pas",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{",
				"}",
			},
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Patch": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"patch",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Perl": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"foreach ",
			"foreach(",
			"if ",
			"if(",
			"elsif ",
			"elsif(",
			"while ",
			"while(",
			"until ",
			"until(",
			"unless ",
			"unless(",
			"given ",
			"given(",
			"when ",
			"when(",
			"catch ",
			"catch(",
			"eq ",
			"ne ",
			"else ",
			"and ",
			"or ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"pl",
			"plx",
			"pm",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"=pod",
				"=cut",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"perl",
			"perl5",
		},
	},
	"Phoenix LiveView": {
		LineComment: []string{
			"#",
			"<!--",
		},
		ComplexityChecks: []string{
			"case ",
			"cond ",
			"if ",
			"for ",
			"with ",
			"try ",
			"catch ",
			"rescue ",
			"else ",
			"and ",
			"or ",
			"not ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"|> ",
			"<% ",
			"<. ",
		},
		Extensions: []string{
			"heex",
			"leex",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Picat": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"do ",
			"foreach ",
			"foreach(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"pi",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Pkl": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"function ",
			"?? ",
			"?.",
			"ifNonNull(",
			"if ",
			" else ",
			".map",
			"for ",
			"when ",
			"...",
		},
		Extensions: []string{
			"pkl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"#",
				End:          "#\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"##",
				End:          "##\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Plain Text": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"text",
			"txt",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Polly": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"polly",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Pony": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"match ",
			"repeat",
			"while ",
			"else ",
			"elseif ",
			"| ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"pony",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"PostScript": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"if",
			"ifelse",
			"for",
			"repeat",
			"loop",
			"forall",
			"pathforall",
			"eq",
			"ne",
			"not",
			"and",
			"or",
		},
		Extensions: []string{
			"ps",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "(",
				End:          ")",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "<",
				End:          ">",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "<~",
				End:          "~>",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Powershell": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"while ",
			"while(",
			"until ",
			"until(",
			"for ",
			"for(",
			"foreach ",
			"foreach(",
			"if ",
			"elseif ",
			"else ",
			"switch",
			"switch(",
			"-gt",
			"-lt",
			"-eq",
			"-ne",
			"-ge",
			"-le",
			"-in",
			"-notin",
			"-contains",
			"-notcontains",
		},
		Extensions: []string{
			"ps1",
			"psm1",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<#",
				"#>",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Processing": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"pde",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Prolog": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"p",
			"pro",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Properties File": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"properties",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Protocol Buffers": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"proto",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Puppet": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"pp",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"=begin",
				"=end",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"PureScript": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"purs",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{-",
				"-}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Python": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"while ",
			"while(",
			"if ",
			"if(",
			"elif ",
			"elif(",
			"else ",
			"else:",
			"match ",
			"match(",
			"try ",
			"try:",
			"except ",
			"except:",
			"finally ",
			"finally:",
			"with ",
			"with (",
			"and ",
			"and(",
			"or ",
			"or(",
		},
		Extensions: []string{
			"py",
			"pyw",
			"pyi",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "r'",
				End:          "'",
				IgnoreEscape: true,
				DocString:    false,
			},
			{
				Start:        "r\"",
				End:          "\"",
				IgnoreEscape: true,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "r\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: true,
				DocString:    true,
			},
			{
				Start:        "r'''",
				End:          "'''",
				IgnoreEscape: true,
				DocString:    true,
			},
			{
				Start:        "f\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "f'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    true,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"python",
			"python2",
			"python3",
		},
	},
	"Q#": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"repeat ",
			"repeat{",
			"until (",
			"until(",
			"if ",
			"if(",
			"elif ",
			"elif{",
			"else ",
			"else{",
			"||| ",
			"&&& ",
			"<<<",
			">>>",
			"^^^",
			"~~~",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"qs",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"QCL": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"qcl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"QML": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"qml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"R": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"r",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"Rscript",
		},
	},
	"RAML": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"raml",
			"rml",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Racket": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"(if",
			"(cond",
			"[else",
			"(and",
			"(or",
			"(for",
			"#:when",
			"#:unless",
			"#:break",
			"#:final",
			"(do",
			"(when",
			"(unless",
			"(shared",
			"(case",
		},
		Extensions: []string{
			"rkt",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"|#",
				"#|",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"racket",
		},
	},
	"Rakefile": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions:    []string{},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"=begin",
				"=end",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			"rake",
			"rakefile",
		},
		SheBangs: []string{},
	},
	"Raku": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"== ",
			"≡ ",
			"!= ",
			"≠ ",
			"!== ",
			"≢ ",
			"< ",
			"⊂ ",
			"!< ",
			"⊄ ",
			"<= ",
			"≤ ",
			"⊆ ",
			"!<= ",
			"⊈ ",
			"> ",
			"⊃ ",
			"!> ",
			"⊅ ",
			">= ",
			"≥ ",
			"⊇ ",
			"!>= ",
			"⊉ ",
			"=~= ",
			"≅ ",
			"=== ",
			"eq ",
			"!eq ",
			"eqv ",
			"ne ",
			"gt ",
			"ge ",
			"lt ",
			"le ",
			"=:=",
			"CATCH ",
			"CONTROL ",
			"DOC ",
			"NEXT ",
			"and ",
			"default ",
			"do {",
			"else ",
			"elsif ",
			"emit ",
			"for ",
			"gather ",
			"given ",
			"if ",
			"last ",
			"loop (",
			"next ",
			"once ",
			"or ",
			"orwith ",
			"react {",
			"redo ",
			"repeat ",
			"start {",
			"supply ",
			"unless ",
			"until ",
			"when ",
			"whenever ",
			"while ",
			"with ",
			"without ",
		},
		Extensions: []string{
			"raku",
			"rakumod",
			"rakutest",
			"rakudoc",
			"t",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"=begin",
				"=end",
			},
			{
				"#`(",
				")",
			},
			{
				"#`[",
				"]",
			},
			{
				"#`{",
				"}",
			},
			{
				"#`｢",
				"｣",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "„",
				End:          "“",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "«",
				End:          "»",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "<<",
				End:          ">>",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "“",
				End:          "”",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "’",
				End:          "‘",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "｢",
				End:          "｣",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"raku",
		},
	},
	"Razor": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cshtml",
			"razor",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
			{
				"@*",
				"*@",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ReScript": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"=== ",
		},
		Extensions: []string{
			"res",
			"resi",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ReStructuredText": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"rst",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ReasonML": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"re",
			"rei",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Redscript": {
		LineComment: []string{
			"//",
			"///",
		},
		ComplexityChecks: []string{
			"for ",
			"@if(",
			"switch ",
			"while ",
			"else ",
			"func ",
			"-> ",
		},
		Extensions: []string{
			"reds",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Report Definition Language": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"rdl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Rich Text Format": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"rtf",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Robot Framework": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"robot",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Ruby": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"rb",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"=begin",
				"=end",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"ruby",
		},
	},
	"Ruby HTML": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"rhtml",
			"erb",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Rust": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"match ",
		},
		Extensions: []string{
			"rs",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SAS": {
		LineComment: []string{
			"*",
		},
		ComplexityChecks: []string{
			"do",
			"%do",
			"if",
			"%if",
			"else",
			"%else",
			"case",
			"or",
			"and",
			"^=",
			"¬=",
			"~=",
			"ne",
			"eq",
		},
		Extensions: []string{
			"sas",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SKILL": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"il",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SNOBOL": {
		LineComment: []string{
			"*",
		},
		ComplexityChecks: []string{
			":(",
			":s(",
			":f(",
			"eq ",
			"ne ",
		},
		Extensions: []string{
			"sno",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SPDX": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"spdx",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SPL": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"construct",
			"foreach",
			"map",
			"while",
			"if",
			"include",
			"catch",
			"and",
			"or",
			"not",
			"call",
			"<|",
			"<{",
			"dup",
			"swap",
		},
		Extensions: []string{
			"spl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"\"",
				"\";",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "^",
				End:          " ",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "^",
				End:          ">",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "^",
				End:          ":",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"spl",
		},
	},
	"SQL": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"sql",
			"dml",
			"ddl",
			"dql",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SRecode Template": {
		LineComment: []string{
			";;",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"srt",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SVG": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"svg",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Sass": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"sass",
			"scss",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Scala": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			">= ",
			"> ",
			"<= ",
			"< ",
		},
		Extensions: []string{
			"sc",
			"scala",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Scallop": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"rel ",
			"count(",
			"sum(",
			"prod(",
			"min(",
			"max(",
			"exists(",
			"forall(",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			">= ",
			"> ",
			"<= ",
			"< ",
		},
		Extensions: []string{
			"scl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Scheme": {
		LineComment: []string{
			";",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"scm",
			"ss",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"#|",
				"|#",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Scons": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"csig",
			"sconstruct",
			"sconscript",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Seed7": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"elsif ",
			"else",
			"else ",
			"case ",
			"while ",
			"until ",
			"catch ",
			"or ",
			"and ",
			"<> ",
			"= ",
		},
		Extensions: []string{
			"sd7",
			"s7i",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Shell": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"sh",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			".tcshrc",
		},
		SheBangs: []string{
			"sh",
		},
	},
	"Sieve": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"if",
			"if ",
			"elsif",
			"elsif ",
			"allof",
			"allof ",
			"anyof",
			"anyof ",
			"allof(",
			"anyof(",
		},
		Extensions: []string{
			"sieve",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Slang": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"slang",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Slint": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"if(",
			"states ",
			"states[",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"slint",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Smalltalk": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"bitAnd ",
			"bitOr ",
			"bitXor ",
			"bitInvert ",
			"bitShift ",
			"bitAt ",
			"highbit ",
			"allMask ",
			"anyMask ",
			"noMask ",
			"ifTrue ",
			"ifFalse ",
			"switch ",
			"whileTrue ",
			"whileFalse ",
			"to: ",
		},
		Extensions: []string{
			"cs.st",
			"pck.st",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"\"",
				"\"",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Smarty Template": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"include ",
		},
		Extensions: []string{
			"tpl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"{*",
				"*}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Snakemake": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"while ",
			"while(",
			"if ",
			"if(",
			"elif ",
			"elif(",
			"else ",
			"else:",
			"match ",
			"match(",
			"try ",
			"try:",
			"except ",
			"except(",
			"finally ",
			"finally:",
			"with ",
			"with (",
			"and ",
			"and(",
			"or ",
			"or(",
		},
		Extensions: []string{
			"smk",
			"rules",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "r\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: false,
				DocString:    true,
			},
			{
				Start:        "r'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    true,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			"snakefile",
		},
		SheBangs: []string{},
	},
	"Softbridge Basic": {
		LineComment: []string{
			"'",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"elseif ",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"sbl",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Solidity": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
			"assembly ",
			"assembly{",
			"unchecked ",
			"unchecked{",
		},
		Extensions: []string{
			"sol",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Specman e": {
		LineComment: []string{
			"--",
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"e",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"'>",
				"<'",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Spice Netlist": {
		LineComment: []string{
			"*",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ckt",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Stan": {
		LineComment: []string{
			"#",
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"stan",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Standard ML (SML)": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"sml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Stata": {
		LineComment: []string{
			"//",
			"*",
		},
		ComplexityChecks: []string{
			"foreach",
			"forvalues",
			"if",
			"else",
			"while",
			"switch",
			"|",
			"&",
			"!=",
			"==",
		},
		Extensions: []string{
			"do",
			"ado",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`\"",
				End:          "\"'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Stylus": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"unless ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"styl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Svelte": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"svelte",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Swift": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"catch ",
			"guard ",
			"?",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"swift",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Swig": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"i",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"SystemVerilog": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"| ",
			"& ",
			"!= ",
			"!== ",
			"== ",
			"foreach ",
			"foreach(",
			"case ",
			"case(",
			"casex ",
			"casex(",
			"casez ",
			"casez(",
			"casexz ",
			"casexz(",
			"fork ",
			" ? ",
			"inside",
			"with",
			"event ",
		},
		Extensions: []string{
			"sv",
			"svh",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords: []string{
			"endmodule",
			"posedge",
			"edge",
			"always",
			"wire",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"Systemd": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"automount",
			"device",
			"link",
			"mount",
			"path",
			"scope",
			"service",
			"slice",
			"socket",
			"swap",
			"target",
			"timer",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TCL": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"tcl",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"tcl",
		},
	},
	"TL": {
		LineComment: []string{
			"//",
			"///",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"tl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TOML": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"toml",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\"\\\"\\\"",
				End:          "\\\"\\\"\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'''",
				End:          "'''",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TTCN-3": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"from ",
			"if ",
			"if(",
			"select ",
			"case ",
			"while ",
			"do ",
			"goto ",
			"stop ",
			"break ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ttcn",
			"ttcn3",
			"ttcnpp",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Tact": {
		LineComment: []string{
			"//",
			"///",
		},
		ComplexityChecks: []string{
			"if ",
			"if(",
			"else ",
			"try ",
			"catch ",
			"catch(",
			"repeat ",
			"repeat(",
			"while ",
			"while(",
			"do ",
			"until ",
			"until(",
			"foreach ",
			"foreach(",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"tact",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TaskPaper": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"taskpaper",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TeX": {
		LineComment: []string{
			"%",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"tex",
			"sty",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Teal": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"loop:",
			"retsub",
			"callsub ",
			"&&",
			"==",
			"||",
			"<=",
			">=",
		},
		Extensions: []string{
			"teal",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Templ": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"if ",
			" else ",
			"switch ",
			"case ",
			"default:",
			"for ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"templ",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TemplateToolkit": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"[% BLOCK",
			"[% FILTER",
			"[% FOR",
			"[% FOREACH",
			"[% IF",
			"[% INCLUDE",
			"[% MACRO",
			"[% PROCESS",
			"[% SWITCH",
			"[% UNLESS",
			"[% WRAPPER",
		},
		Extensions: []string{
			"tt",
			"tt2",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"[%#",
				"%]",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Tera": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"{% include ",
			"{% macro ",
			"{% block ",
			"{% extends ",
			"{% for ",
			"{% set ",
			"{% if ",
			"{% elif ",
			"{% else ",
		},
		Extensions: []string{
			"tera",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
			{
				"{#",
				"#}",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Terraform": {
		LineComment: []string{
			"#",
			"//",
		},
		ComplexityChecks: []string{
			"count",
			"for",
			"for_each",
			"if",
			": ",
			"? ",
			"|| ",
			"&& ",
			"!= ",
			"> ",
			">= ",
			"< ",
			"<= ",
			"== ",
		},
		Extensions: []string{
			"tf",
			"tfvars",
			"tf.json",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Textile": {
		LineComment: []string{
			"###. ",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"textile",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"###.. ",
				"p. ",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Thrift": {
		LineComment: []string{
			"//",
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"thrift",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Treetop": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"treetop",
			"tt",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Twig Template": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"{% for ",
			"{% if ",
			"{% else ",
			"{% elseif ",
		},
		Extensions: []string{
			"twig",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TypeScript": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"!== ",
			"== ",
			"=== ",
			"case ",
			"case(",
			"?.",
			"?? ",
			"??= ",
		},
		Extensions: []string{
			"ts",
			"tsx",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TypeScript Typings": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"!== ",
			"== ",
			"=== ",
			"case ",
			"case(",
			"?.",
			"?? ",
			"??= ",
		},
		Extensions: []string{
			"d.ts",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"TypeSpec": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"tsp",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Typst": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"typ",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Unreal Script": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"uc",
			"uci",
			"upkg",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Up": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"switch ",
			"while ",
			"else ",
			"try ",
			"func ",
			"up ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"up",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Ur/Web": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"ur",
			"urs",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Ur/Web Project": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"urp",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"V": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"v",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords: []string{
			"break",
			"const ",
			"continue",
			"defer",
			"else ",
			"enum",
			"fn ",
			"goto",
			"import ",
			"in ",
			"interface",
			"match",
			"mut",
			"println",
			"pub",
			"return",
			"struct ",
			"type ",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"VHDL": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vhd",
			"vhdl",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords: []string{
			"abs",
			"access",
			"after",
			"alias",
			"all",
			"and",
			"architecture",
			"array",
			"assert",
			"attribute",
			"begin",
			"block",
			"body",
			"buffer",
			"bus",
			"case",
			"component",
			"configuration",
			"constant",
			"disconnect",
			"downto",
			"else",
			"elsif",
			"end",
			"entity",
			"exit",
			"file",
			"for",
			"function",
			"generate",
			"generic",
			"group",
			"guarded",
			"if",
			"impure",
			"in",
			"inertial",
			"inout",
			"is",
			"label",
			"library",
			"linkage",
			"literal",
			"loop",
			"map",
			"mod",
			"nand",
			"new",
			"next",
			"nor",
			"not",
			"null",
			"of",
			"on",
			"open",
			"or",
			"others",
			"out",
			"package",
			"port",
			"postponed",
			"procedure",
			"process",
			"pure",
			"range",
			"record",
			"register",
			"reject",
			"rem",
			"report",
			"return",
			"rol",
			"ror",
			"select",
			"severity",
			"shared",
			"signal",
			"sla",
			"sll",
			"sra",
			"srl",
			"subtype",
			"then",
			"to",
			"transport",
			"type",
			"unaffected",
			"units",
			"until",
			"use",
			"variable",
			"wait",
			"when",
			"while",
			"with",
			"xnor",
			"xor",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"Vala": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"foreach ",
			"foreach(",
			"if ",
			"if(",
			"switch ",
			"switch(",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vala",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "@\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"\"\"",
				End:          "\"\"\"",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Varnish Configuration": {
		LineComment: []string{
			"#",
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"vcl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Verilog": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vg",
			"vh",
			"v",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords: []string{
			"module",
			"endmodule",
			"timescale",
			"input",
			"output",
			"reg",
			"wire",
			"posedge",
			"negedge",
			"always",
			"begin",
			"switch",
			"case",
			"end",
			"endcase",
			"else",
			"localparam",
			"initial",
			"signed",
			"assign",
			"generate",
			"genvar",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"Verilog Args File": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"irunargs",
			"xrunargs",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Vertex Shader File": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vsh",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Vim Script": {
		LineComment: []string{
			"\"",
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vim",
			"vimrc",
			"gvimrc",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			"_vimrc",
			".vimrc",
			"_gvimrc",
			".gvimrc",
			"vimrc",
			"gvimrc",
		},
		SheBangs: []string{},
	},
	"Visual Basic": {
		LineComment: []string{
			"'",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"elseif ",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vb",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Visual Basic for Applications": {
		LineComment: []string{
			"'",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"elseif ",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"cls",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Vue": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"vue",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"W.I.S.E. Jobfile": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"fgmj",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Web Services Description Language": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"wsdl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"WebGPU Shading Language": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for (",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"while(",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"wgsl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Windows Resource-Definition Script": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"rc",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords: []string{
			"#include",
			"#define",
			"RC_INVOKED",
			"VERSIONINFO",
			"FILEVERSION",
			"PRODUCTVERSION",
			"FILEOS",
			"FILETYPE",
			"BLOCK",
			"VALUE",
			"StringFileInfo",
			"VarFileInfo",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"Wolfram": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"nb",
			"wl",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"(*",
				"*)",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Wren": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"wren",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"XAML": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"xaml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"XML": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"xml",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"XML Schema": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"xsd",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"XMake": {
		LineComment: []string{
			"--",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"while ",
			"while(",
			"else ",
			"else(",
			"elseif ",
			"elseif(",
			"until ",
			"until(",
			"or ",
			"and ",
			"~= ",
			"== ",
		},
		Extensions:    []string{},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"--[[",
				"]]",
			},
			{
				"--[=[",
				"]=]",
			},
			{
				"--[==[",
				"]==]",
			},
			{
				"--[===[",
				"]===]",
			},
			{
				"--[====[",
				"]====]",
			},
			{
				"--[=====[",
				"]=====]",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "]]",
				End:          "[[",
				IgnoreEscape: true,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			"xmake.lua",
			"xpack.lua",
		},
		SheBangs: []string{},
	},
	"Xcode Config": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"xcconfig",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Xtend": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"xtend",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"YAML": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"yaml",
			"yml",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Yarn": {
		LineComment: []string{},
		ComplexityChecks: []string{
			"<<if ",
			"<<elseif ",
			"<<else ",
			" eq ",
			" == ",
			" neq ",
			" ! ",
			" gt ",
			" > ",
			" lt ",
			" < ",
			" lte ",
			" <= ",
			" gte ",
			" >= ",
			" xor ",
			" ^ ",
			" and ",
			" && ",
			" || ",
			" or ",
		},
		Extensions: []string{
			"yarn",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Zig": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"catch ",
			"while ",
			"for ",
			"if ",
			"else ",
			"errdefer ",
			"try ",
			"switch ",
			"orelse ",
			"||",
			"&&",
			"!=",
			"==",
		},
		Extensions: []string{
			"zig",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\\\\",
				End:          "\n",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ZoKrates": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"zok",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"Zsh": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"|| ",
			"&& ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"zsh",
			"zshenv",
			"zlogin",
			"zlogout",
			"zprofile",
			"zshrc",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\\\"",
				End:          "\\\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames: []string{
			".zshenv",
			".zlogin",
			".zlogout",
			".zprofile",
			".zshrc",
		},
		SheBangs: []string{
			"zsh",
		},
	},
	"bait": {
		LineComment: []string{
			"//",
		},
		ComplexityChecks: []string{
			"for ",
			"if ",
			"else ",
			" or ",
			" and ",
			"!= ",
			"== ",
		},
		Extensions: []string{
			"bt",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"/*",
				"*/",
			},
		},
		Quotes: []Quote{
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "`",
				End:          "`",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: true,
		Keywords: []string{
			"and",
			"break",
			"const ",
			"continue",
			"else ",
			"fun ",
			"import ",
			"not ",
			"or ",
			"package ",
			"return",
			"struct ",
		},
		FileNames: []string{},
		SheBangs:  []string{},
	},
	"gitignore": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions:       []string{},
		ExtensionFile:    false,
		MultiLine:        [][]string{},
		Quotes:           []Quote{},
		NestedMultiLine:  false,
		Keywords:         []string{},
		FileNames: []string{
			".gitignore",
		},
		SheBangs: []string{},
	},
	"hoon": {
		LineComment: []string{
			"::",
		},
		ComplexityChecks: []string{
			"%+  turn",
			"(turn ",
			"%+  roll",
			"(roll ",
			"%+  reel",
			"(reel ",
			"|.  ",
			"|.(",
			"|-  ",
			"|-(",
			"|?  ",
			"|?(",
			"?|  ",
			"?|(",
			"|(",
			"?-  ",
			"?-(",
			"?:  ",
			"?:(",
			"?.  ",
			"?.(",
			"?^  ",
			"?^(",
			"?<  ",
			"?<(",
			"?>  ",
			"?>(",
			"?+  ",
			"?+(",
			"?&  ",
			"?&(",
			"&(",
			"?@  ",
			"?@(",
			"?~  ",
			"?~(",
			"?=  ",
			"?=(",
			".=  ",
			"=(",
			"!=(",
		},
		Extensions: []string{
			"hoon",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "'",
				End:          "'",
				IgnoreEscape: false,
				DocString:    false,
			},
			{
				Start:        "```",
				End:          "```",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"ignore": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions:       []string{},
		ExtensionFile:    false,
		MultiLine:        [][]string{},
		Quotes:           []Quote{},
		NestedMultiLine:  false,
		Keywords:         []string{},
		FileNames: []string{
			".ignore",
		},
		SheBangs: []string{},
	},
	"jq": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			".",
			"if ",
			"elif ",
			"else ",
			"!= ",
			"== ",
			">= ",
			"<= ",
			"< ",
			"> ",
			"and ",
			"or ",
			"not ",
			"// ",
			"try ",
			"break ",
		},
		Extensions: []string{
			"jq",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"m4": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{},
		Extensions: []string{
			"m4",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"nuspec": {
		LineComment:      []string{},
		ComplexityChecks: []string{},
		Extensions: []string{
			"nuspec",
		},
		ExtensionFile: false,
		MultiLine: [][]string{
			{
				"<!--",
				"-->",
			},
		},
		Quotes: []Quote{
			{
				Start:        "\"",
				End:          "\"",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
	"sed": {
		LineComment: []string{
			"#",
		},
		ComplexityChecks: []string{
			"for ",
			"for(",
			"if ",
			"if(",
			"switch ",
			"while ",
			"else ",
			"and ",
			"or ",
			"not ",
			"in ",
		},
		Extensions: []string{
			"sed",
		},
		ExtensionFile:   false,
		MultiLine:       [][]string{},
		Quotes:          []Quote{},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs: []string{
			"sed",
		},
	},
	"wenyan": {
		LineComment: []string{
			"批曰",
			"注曰",
			"疏曰",
		},
		ComplexityChecks: []string{
			"若",
			"若非",
			"等於",
			"不等於",
			"不大於",
			"不小於",
			"大於",
			"小於",
			"凡",
			"為是",
			"恆為是",
			"中之",
			"遍",
		},
		Extensions: []string{
			"wy",
		},
		ExtensionFile: false,
		MultiLine:     [][]string{},
		Quotes: []Quote{
			{
				Start:        "」」",
				End:          "「「",
				IgnoreEscape: false,
				DocString:    false,
			},
		},
		NestedMultiLine: false,
		Keywords:        []string{},
		FileNames:       []string{},
		SheBangs:        []string{},
	},
}
