// This file implements the IApplicationDocumentLists Interface for Python.
// Generated by makegw.py

#include "shell_pch.h"

#include "PyIApplicationDocumentLists.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIApplicationDocumentLists::PyIApplicationDocumentLists(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIApplicationDocumentLists::~PyIApplicationDocumentLists() {}

/* static */ IApplicationDocumentLists *PyIApplicationDocumentLists::GetI(PyObject *self)
{
    return (IApplicationDocumentLists *)PyIUnknown::GetI(self);
}

// @pymethod |PyIApplicationDocumentLists|SetAppID|Specifies the application whose jump list is to be accessed
// @comm This method is only needed if the application sets its own taskbar identifier
PyObject *PyIApplicationDocumentLists::SetAppID(PyObject *self, PyObject *args)
{
    IApplicationDocumentLists *pIADL = GetI(self);
    if (pIADL == NULL)
        return NULL;
    // @pyparm str|AppID||Taskbar identifier for the application
    PyObject *obappid;
    TmpWCHAR appid;
    if (!PyArg_ParseTuple(args, "O:SetAppID", &obappid))
        return NULL;
    if (!PyWinObject_AsWCHAR(obappid, &appid, FALSE))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIADL->SetAppID(appid);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIADL, IID_IApplicationDocumentLists);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod <o PyIEnumObjects>|PyIApplicationDocumentLists|GetList|Retrieves a list of items in a jump list
PyObject *PyIApplicationDocumentLists::GetList(PyObject *self, PyObject *args)
{
    IApplicationDocumentLists *pIADL = GetI(self);
    if (pIADL == NULL)
        return NULL;
    // @pyparm int|ListType||Type of document list to return, shellcon.ADLT_RECENT or ADLT_FREQUENT
    // @pyparm int|ItemsDesired|0|Number of items to return, use 0 for all available
    // @pyparm <o PyIID>|riid|IID_IEnumObjects|The interface to return, IID_IEnumObjects or IID_IObjectArray
    APPDOCLISTTYPE listtype;
    IID riid = IID_IEnumObjects;
    void *ppv;
    UINT cItemsDesired = 0;
    if (!PyArg_ParseTuple(args, "i|kO&:GetList", &listtype, &cItemsDesired, PyWinObject_AsIID, &riid))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIADL->GetList(listtype, cItemsDesired, riid, &ppv);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIADL, IID_IApplicationDocumentLists);
    return PyCom_PyObjectFromIUnknown((IUnknown *)ppv, riid, FALSE);
}

// @object PyIApplicationDocumentLists|Interface used to retrieve the jump lists for an application
static struct PyMethodDef PyIApplicationDocumentLists_methods[] = {
    {"SetAppID", PyIApplicationDocumentLists::SetAppID,
     1},  // @pymeth SetAppID|Specifies the application whose jump list is to be accessed
    {"GetList", PyIApplicationDocumentLists::GetList, 1},  // @pymeth GetList|Retrieves a list of items in a jump list
    {NULL}};

PyComTypeObject PyIApplicationDocumentLists::type("PyIApplicationDocumentLists", &PyIUnknown::type,
                                                  sizeof(PyIApplicationDocumentLists),
                                                  PyIApplicationDocumentLists_methods,
                                                  GET_PYCOM_CTOR(PyIApplicationDocumentLists));
