# Advanced User Guide

These tutorials cover more advanced topics. This guide assumes that you have read the [Basic User Guide](../basic_user_guide/basic_user_guide.md), and it builds from those basics to cover more complex topics that will let you get the most out of the framework. Within each section, the tutorials are designed to be read in order, but each section is self-contained enough that you can choose to read only the sections that are useful to you.


## Models with Implicit Components

- [Building Models with Solvers and Implicit Components](models_implicit_components/models_with_solvers_implicit.ipynb)
- [Using BalanceComp to Create Implicit Relationships in Groups](models_implicit_components/implicit_with_balancecomp.ipynb)

## Working with Analytic Derivatives

- [Defining Partial Derivatives on Explicit Components](analytic_derivatives/partial_derivs_explicit.ipynb)
- [Defining Partial Derivatives on Implicit Components](analytic_derivatives/partial_derivs_implicit.ipynb)
- [Computing Total Derivatives of Coupled Models](analytic_derivatives/derivs_of_coupled_systems.ipynb)

## Recoding and Reading Data

- [Advanced Recording Example](recording/advanced_case_recording.ipynb)

## Using OpenMDAO as a Part of a Larger Process
- [Cannonball Example with Euler Integration and an External Optimizer](example/euler_integration_example.ipynb)

## Details about Complex Step
- [Using Complex Step to Compute Derivatives](complex_step.ipynb)

## Using AnalysisError
- [Using AnalysisError to avoid a region in the solution space](analysis_errors/analysis_error.ipynb)

## Computing Partial Derivatives using JAX
- [Computing Partial Derivatives of Explicit Components Using JAX](jax_derivatives/partial_derivs_explicit.ipynb)

```python

```
