from enum import Enum
from types import ModuleType


class BackendFilter(Enum):
    INTERACTIVE: int
    NON_INTERACTIVE: int


class BackendRegistry:
    _BUILTIN_BACKEND_TO_GUI_FRAMEWORK: dict[str, str]
    _GUI_FRAMEWORK_TO_BACKEND: dict[str, str]

    _loaded_entry_points: bool
    _backend_to_gui_framework: dict[str, str]
    _name_to_module: dict[str, str]

    def _backend_module_name(self, backend: str) -> str: ...
    def _clear(self) -> None: ...
    def _ensure_entry_points_loaded(self) -> None: ...
    def _get_gui_framework_by_loading(self, backend: str) -> str: ...
    def _read_entry_points(self) -> list[tuple[str, str]]: ...
    def _validate_and_store_entry_points(self, entries: list[tuple[str, str]]) -> None: ...

    def backend_for_gui_framework(self, framework: str) -> str | None: ...
    def is_valid_backend(self, backend: str) -> bool: ...
    def list_all(self) -> list[str]: ...
    def list_builtin(self, filter_: BackendFilter | None) -> list[str]: ...
    def list_gui_frameworks(self) -> list[str]: ...
    def load_backend_module(self, backend: str) -> ModuleType: ...
    def resolve_backend(self, backend: str | None) -> tuple[str, str | None]: ...
    def resolve_gui_or_backend(self, gui_or_backend: str | None) -> tuple[str, str | None]: ...


backend_registry: BackendRegistry
