from typing import ClassVar, List

from typing import overload
import lief # type: ignore
import lief.ART # type: ignore
import lief.Android # type: ignore

class File(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def header(self) -> lief.ART.Header: ...

class Header(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def boot_image_begin(self) -> int: ...
    @property
    def boot_image_size(self) -> int: ...
    @property
    def boot_oat_begin(self) -> int: ...
    @property
    def boot_oat_size(self) -> int: ...
    @property
    def compile_pic(self) -> bool: ...
    @property
    def data_size(self) -> int: ...
    @property
    def image_begin(self) -> int: ...
    @property
    def image_roots(self) -> int: ...
    @property
    def image_size(self) -> int: ...
    @property
    def magic(self) -> List[int]: ...
    @property
    def nb_methods(self) -> int: ...
    @property
    def nb_sections(self) -> int: ...
    @property
    def oat_checksum(self) -> int: ...
    @property
    def oat_data_end(self) -> int: ...
    @property
    def oat_file_begin(self) -> int: ...
    @property
    def oat_file_end(self) -> int: ...
    @property
    def patch_delta(self) -> int: ...
    @property
    def pointer_size(self) -> int: ...
    @property
    def storage_mode(self) -> lief.ART.STORAGE_MODES: ...
    @property
    def version(self) -> int: ...

class STORAGE_MODES:
    __members__: ClassVar[dict] = ...  # read-only
    LZ4: ClassVar[STORAGE_MODES] = ...
    LZ4HC: ClassVar[STORAGE_MODES] = ...
    UNCOMPRESSED: ClassVar[STORAGE_MODES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

def android_version(art_version: int) -> lief.Android.ANDROID_VERSIONS: ...
@overload
def is_art(path: str) -> bool: ...
@overload
def is_art(raw: List[int]) -> bool: ...
@overload
def parse(filename: str) -> lief.ART.File: ...
@overload
def parse(raw: List[int], name: str = ...) -> lief.ART.File: ...
@overload
def parse(io: object, name: str = ...) -> lief.ART.File: ...
@overload
def version(file: str) -> int: ...
@overload
def version(raw: List[int]) -> int: ...
