#!/usr/bin/env python

import os
from nbclassic.notebookapp import NotebookApp

header = """\
.. _config:


Config file and command line options
====================================

The notebook server can be run with a variety of command line arguments.
A list of available options can be found below in the :ref:`options section 
<options>`.

Defaults for these options can also be set by creating a file named
``jupyter_notebook_config.py`` in your Jupyter folder. The Jupyter
folder is in your home directory, ``~/.jupyter``.

To create a ``jupyter_notebook_config.py`` file, with all the defaults
commented out, you can use the following command line::

  $ jupyter notebook --generate-config


.. _options:

Options
-------

This list of options can be generated by running the following and hitting 
enter::

  $ jupyter notebook --help

"""
try:
    destination = os.path.join(os.path.dirname(__file__), 'source/config.rst')
except:
    destination = os.path.join(os.getcwd(), 'config.rst')

with open(destination, 'w') as f:
    f.write(header)
    f.write(NotebookApp().document_config_options())
