import os
import traceback

import sphinx_py3doc_enhanced_theme

os.environ['PUREPYTHONHUNTER'] = 'yes'

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosectionlabel',
    'sphinx.ext.autosummary',
    'sphinx.ext.coverage',
    'sphinx.ext.doctest',
    'sphinx.ext.extlinks',
    'sphinx.ext.ifconfig',
    'sphinx.ext.napoleon',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
]
source_suffix = '.rst'
master_doc = 'index'
project = 'Hunter'
year = '2015-2023'
author = 'Ionel Cristian Mărieș'
copyright = f'{year}, {author}'
try:
    from pkg_resources import get_distribution

    version = release = get_distribution('hunter').version
except Exception:
    traceback.print_exc()
    version = release = '3.6.1'

pygments_style = 'trac'
templates_path = ['.']
extlinks = {
    'issue': ('https://github.com/ionelmc/python-hunter/issues/%s', '#'),
    'pr': ('https://github.com/ionelmc/python-hunter/pull/%s', 'PR #'),
}
html_theme = 'sphinx_py3doc_enhanced_theme'
html_theme_path = [sphinx_py3doc_enhanced_theme.get_html_theme_path()]
html_theme_options = {
    'githuburl': 'https://github.com/ionelmc/python-hunter/',
}

html_use_smartypants = True
html_last_updated_fmt = '%b %d, %Y'
html_split_index = False
html_sidebars = {
    '**': ['searchbox.html', 'globaltoc.html', 'sourcelink.html'],
}
html_short_title = f'{project}-{version}'

napoleon_use_ivar = True
napoleon_use_rtype = False
napoleon_use_param = False

autosummary_generate = True

autosectionlabel_prefix_document = True
