import re
from collections.abc import Generator, Mapping
from typing import Any, TextIO, TypeVar

_AT = TypeVar("_AT", int, str, re.Match[str], None)

class _MatchParser:
    def __init__(self, string: str) -> None: ...
    def match(self, r: re.Pattern[str]) -> re.Match[str] | int | None: ...
    def advance(self, by: _AT) -> _AT: ...
    def consume(self, r: re.Pattern[str]) -> re.Match[str]: ...
    def child(self) -> _MatchChildParser: ...

class _MatchChildParser(_MatchParser):
    def __init__(self, parent: _MatchParser) -> None: ...
    def commit(self) -> _MatchParser: ...

class ParseError(Exception):
    def __init__(self, parser: _MatchParser) -> None: ...

class Block:
    def __init__(self, **kwargs: Any) -> None: ...  # Abstract. Accepts arbitrary keyword arguments.
    @classmethod
    def parse(cls, parser: _MatchParser) -> Block: ...
    def write_into(self, stream: TextIO) -> None: ...

class HeaderBlock(Block): ...

class Magic(HeaderBlock):
    @classmethod
    def parse(cls, parser: _MatchParser) -> Magic: ...
    def write_into(self, stream: TextIO) -> None: ...

class StyleBlock(HeaderBlock): ...
class RegionBlock(HeaderBlock): ...
class CommentBlock(Block): ...

class CueBlock(Block):
    @classmethod
    def parse(cls, parser: _MatchParser) -> CueBlock: ...
    def write_into(self, stream: TextIO) -> None: ...
    @property
    def as_json(self) -> dict[str, Any]: ...
    def __eq__(self, other: object) -> bool: ...
    @classmethod
    def from_json(cls, json: Mapping[str, Any]) -> CueBlock: ...
    def hinges(self, other: Block) -> bool: ...

def parse_fragment(frag_content: bytes) -> Generator[Block]: ...
