// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file SynDDSMessage.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifndef _SYNDDSMESSAGE_H_
#define _SYNDDSMESSAGE_H_


#include <stdint.h>
#include <array>
#include <string>
#include <vector>
#include <map>
#include <bitset>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(SynDDSMessage_SOURCE)
#define SynDDSMessage_DllAPI __declspec( dllexport )
#else
#define SynDDSMessage_DllAPI __declspec( dllimport )
#endif // SynDDSMessage_SOURCE
#else
#define SynDDSMessage_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define SynDDSMessage_DllAPI
#endif // _WIN32

namespace eprosima {
namespace fastcdr {
class Cdr;
} // namespace fastcdr
} // namespace eprosima


/*!
 * @brief This class represents the structure SynDDSMessage defined by the user in the IDL file.
 * @ingroup SYNDDSMESSAGE
 */
class SynDDSMessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SynDDSMessage();

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SynDDSMessage();

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SynDDSMessage that will be copied.
     */
    eProsima_user_DllExport SynDDSMessage(
            const SynDDSMessage& x);

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SynDDSMessage that will be copied.
     */
    eProsima_user_DllExport SynDDSMessage(
            SynDDSMessage&& x);

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SynDDSMessage that will be copied.
     */
    eProsima_user_DllExport SynDDSMessage& operator =(
            const SynDDSMessage& x);

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SynDDSMessage that will be copied.
     */
    eProsima_user_DllExport SynDDSMessage& operator =(
            SynDDSMessage&& x);

    /*!
     * @brief This function sets a value in member rank
     * @param _rank New value for member rank
     */
    eProsima_user_DllExport void rank(
            uint32_t _rank);

    /*!
     * @brief This function returns the value of member rank
     * @return Value of member rank
     */
    eProsima_user_DllExport uint32_t rank() const;

    /*!
     * @brief This function returns a reference to member rank
     * @return Reference to member rank
     */
    eProsima_user_DllExport uint32_t& rank();

    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    eProsima_user_DllExport void data(
            const std::vector<uint8_t>& _data);

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    eProsima_user_DllExport void data(
            std::vector<uint8_t>&& _data);

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     */
    eProsima_user_DllExport const std::vector<uint8_t>& data() const;

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    eProsima_user_DllExport std::vector<uint8_t>& data();

    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    eProsima_user_DllExport static size_t getMaxCdrSerializedSize(
            size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    eProsima_user_DllExport static size_t getCdrSerializedSize(
            const SynDDSMessage& data,
            size_t current_alignment = 0);


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void serialize(
            eprosima::fastcdr::Cdr& cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void deserialize(
            eprosima::fastcdr::Cdr& cdr);



    /*!
     * @brief This function returns the maximum serialized size of the Key of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    eProsima_user_DllExport static size_t getKeyMaxCdrSerializedSize(
            size_t current_alignment = 0);

    /*!
     * @brief This function tells you if the Key has been defined for this type
     */
    eProsima_user_DllExport static bool isKeyDefined();

    /*!
     * @brief This function serializes the key members of an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void serializeKey(
            eprosima::fastcdr::Cdr& cdr) const;

private:

    uint32_t m_rank;
    std::vector<uint8_t> m_data;
};

#endif // _SYNDDSMESSAGE_H_