# Changes of Note

- A compiler that supports C++17 is now required to build PDAL or include PDAL headers in your code.
- The PDAL_STATIC_BUILD cmake option has been removed. We do not support building PDAL as a static library, though it may work.
- The behavior of `readers.ept` when specifying both `bounds` and `polygon` options has changed such that a point must pass both the filters independently in order to be accepted. (#3506)
- `readers.ept` will now ignore the spatial reference on a clip region if the point source has no spatial reference. This behavior is consistent with `filters.crop`. (#3580)
- `readers.las` and `writers.las` no longer support the laszip library. Both stages now use the lazperf library, which is embedded into the PDAL library. The `compression` option is still accepted in `readers.las`, but is ignored. The `compression` option on `writers.las` still accepts the `LASZIP` and `LAZPERF` , but those values are treated the same as `TRUE`.
- PDAL now builds on MinGW, though future support depends on community contributions.
- Source code supporting las and ept has been moved to a private namespace.

# New Stages

- `readers.copc` and `writers.copc` have been added to support reading and writing of [COPC](https://github.com/copcio/copcio.github.io) files.
- `readers.smrmsg` was added to read from post-processed MMS accuracy files to be used with SBET data.

# Enhancements

- The performance of `filters.litree` has been improved. (#3518)
- Support for time query/storage in `readers.tiledb` and `writers.tiledb` has been added. (#3495)
- Added various remote access support (AWS Fargate, AWS session token support, Azure SAS token support). (#3496)
- An error is now reported when reading a pipeline with multiple leaf nodes.
- Support for beam direction and origin in `readers.rxp` has been added. (#3565)
- Add a cmake macro `PDAL_CREATE_PLUGIN` that may simplify the creation of some PDAL plugin stages. (#3588)
- `writers.null` is now streamable. (#3591)
- Added support for multiple output files in `writers.ply` (#3617 - Thanks @longhuan2018)
- `filters.csf` now permits selective output of debugging/analysis files. (#3488)
- Comments in JSON input files (pipelines) are now supported. (#3670)
- Added support in `writers.las` for creating VLRs from metadata. (#3683)
- Added query support origin query in version 1.1 of EPT. (#3505)

# Bug Fixes

- Fix a bug in `FileUtils::unmapFile()` where attempting to unmap a file that wasn't mapped would crash on Windows. (#3606)
- Make sure UUID is initialized to NULL. (#3483)
- Catch bounds exceptions in Metadata handling. (#3485)
- Support writing metadata in `writers.gdal`. Add raster metadata to PDAL metadata when using `readers.gdal`. (#3479)
- Fix potential error in computing mean-square error computation for `filters.icp`. (#3471)
- Fix crash in `writers.pcd` when the stage is run twice. (#3548)
- Prevent pipeline from being read more than once when using PipelineExecutor. (#3587)
- Initialize `m_curCount` in `writers.ogr` to prevent a crash in some situations. (#3611)
- Fix an off-by-one error in `Extractor::get(std::string& s, size_t size)`. (#3650)
- Fix a bug in lazperf compression where a crash could occur when writing a 0-point file. (#3652)
- Fix an error introduced in PDAL 2.2 where `writers.gltf` would create invalid output. (#3694)
- Address a clarification in the LAS specification such that header min/max values should be set to 0 in a 0-point file. (#3653)
