// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtNek5000Options.C                              //
// ************************************************************************* //

#include <avtNek5000Options.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetNek5000ReadOptions
//
//  Purpose:
//      Creates the options for Nek5000 readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Oct 28 17:55:22 PST 2012
//
//  Modification:
//
//    Hank Childs, Mon Mar  4 18:35:27 PST 2013
//    Add option for duplicating data.
//
// ****************************************************************************

DBOptionsAttributes *
GetNek5000ReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Read all times and cycles", true);
    rv->SetBool("Duplicate data for particle advection (slower for all other techniques)", false);
    return rv;
/* EXAMPLE OF OPTIONS
    rv->SetBool("Binary format", true);
    rv->SetBool("Big Endian", false);
    rv->SetEnum("Dimension", 1);
    vector<string> dims;
    dims.push_back("0D");
    dims.push_back("1D");
    dims.push_back("2D");
    dims.push_back("3D");
    rv->SetEnumStrings("Dimension", dims);
    rv->SetInt("Number of variables", 5);
    rv->SetString("Name of auxiliary file", );
    rv->SetDouble("Displacement factor", 1.0);

    // When reading or writing the file, you can get the options out of this object like:
    rv->GetDouble("Displacement factor");
*/
}


// ****************************************************************************
//  Function: GetNek5000WriteOptions
//
//  Purpose:
//      Creates the options for Nek5000 writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Oct 28 17:55:22 PST 2012
//
// ****************************************************************************

DBOptionsAttributes *
GetNek5000WriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
