// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: paraDISPluginInfo.C
// ****************************************************************************

#include <paraDISPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(paraDIS,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(paraDIS,General)

// ****************************************************************************
//  Method: paraDISGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
paraDISGeneralPluginInfo::GetName() const
{
    return "paraDIS";
}

// ****************************************************************************
//  Method: paraDISGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
paraDISGeneralPluginInfo::GetVersion() const
{
    return "2.3.4";
}

// ****************************************************************************
//  Method: paraDISGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
paraDISGeneralPluginInfo::GetID() const
{
    return "paraDIS_2.3.4";
}
// ****************************************************************************
//  Method: paraDISGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
paraDISGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: paraDISGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
paraDISGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  paraDISGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a paraDIS database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
paraDISGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.prds");
    defaultPatterns.push_back("*.dat");
    defaultPatterns.push_back("*.data");
    defaultPatterns.push_back("*.meta");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  paraDISGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a paraDIS database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
paraDISGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  paraDISGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the paraDIS plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
paraDISGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
