// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <avtSymmetricTensorMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose:
//   Init utility for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtSymmetricTensorMetaData::Init()
{
    dim = 0;

    avtSymmetricTensorMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose:
//   Copy utility for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtSymmetricTensorMetaData::Copy(const avtSymmetricTensorMetaData &obj)
{
    dim = obj.dim;

    avtSymmetricTensorMetaData::SelectAll();
}

// Type map format string
const char *avtSymmetricTensorMetaData::TypeMapFormatString = AVTSYMMETRICTENSORMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtSymmetricTensorMetaData::TmfsStruct = {AVTSYMMETRICTENSORMETADATA_TMFS};


// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose:
//   Default constructor for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData() :
    avtVarMetaData(avtSymmetricTensorMetaData::TmfsStruct)
{
    avtSymmetricTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose:
//   Constructor for the derived classes of avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(private_tmfs_t tmfs) :
    avtVarMetaData(tmfs)
{
    avtSymmetricTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose:
//   Copy constructor for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(const avtSymmetricTensorMetaData &obj) :
    avtVarMetaData(obj,avtSymmetricTensorMetaData::TmfsStruct)
{
    avtSymmetricTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose:
//   Copy constructor for derived classes of the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(const avtSymmetricTensorMetaData &obj, private_tmfs_t tmfs) :
    avtVarMetaData(obj,tmfs)
{
    avtSymmetricTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::~avtSymmetricTensorMetaData
//
// Purpose:
//   Destructor for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtSymmetricTensorMetaData::~avtSymmetricTensorMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::operator =
//
// Purpose:
//   Assignment operator for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtSymmetricTensorMetaData&
avtSymmetricTensorMetaData::operator = (const avtSymmetricTensorMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtSymmetricTensorMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::operator ==
//
// Purpose:
//   Comparison operator == for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtSymmetricTensorMetaData::operator == (const avtSymmetricTensorMetaData &obj) const
{
    // Create the return value
    return ((dim == obj.dim) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::operator !=
//
// Purpose:
//   Comparison operator != for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtSymmetricTensorMetaData::operator != (const avtSymmetricTensorMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::TypeName
//
// Purpose:
//   Type name method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
avtSymmetricTensorMetaData::TypeName() const
{
    return "avtSymmetricTensorMetaData";
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtSymmetricTensorMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtSymmetricTensorMetaData *tmp = (const avtSymmetricTensorMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtSymmetricTensorMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtSymmetricTensorMetaData(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::NewInstance
//
// Purpose:
//   NewInstance method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtSymmetricTensorMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtSymmetricTensorMetaData(*this);
    else
        retval = new avtSymmetricTensorMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
avtSymmetricTensorMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_dim, (void *)&dim);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtSymmetricTensorMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_dim: return "dim";
    default:  return avtVarMetaData::GetFieldName(index);
    }
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
avtSymmetricTensorMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_dim: return FieldType_int;
    default:  return avtVarMetaData::GetFieldType(index);
    }
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtSymmetricTensorMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_dim: return "int";
    default:  return avtVarMetaData::GetFieldTypeName(index);
    }
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtSymmetricTensorMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtSymmetricTensorMetaData &obj = *((const avtSymmetricTensorMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_dim:
        {  // new scope
        retval = (dim == obj.dim);
        }
        break;
    default: retval = avtVarMetaData::FieldsEqual(index_, rhs);
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtSymmetricTensorMetaData constructor
//
//  Arguments:
//      n           The name of the tensor variable.
//      mn          The name of the mesh the tensor var is defined on.
//      c           The centering of the variable.
//      vd          The dimension of the variable.
//
//  Programmer: Hank Childs
//  Creation:   September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:52:39 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(std::string n, std::string mn,
                                     avtCentering c, int vd)
    : avtVarMetaData(avtSymmetricTensorMetaData::TmfsStruct, n, mn, c)
{
    avtSymmetricTensorMetaData::Init();
    dim = vd;
}

// ****************************************************************************
//  Method: avtSymmetricTensorMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:54:42 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtSymmetricTensorMetaData::Print(ostream &out, int indent) const
{
    avtVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "Variable Dimension = " << dim << endl;
}

