/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#ifndef PY_LOGGER_H_
#define PY_LOGGER_H_

#include <pybind11/pybind11.h>

#include "sh4lt/logger/logger.hpp"

namespace py = pybind11;

namespace sh4lt::logger {

class PyLogger : public Logger {
 public:
  PyLogger() = default;
  PyLogger(bool debug) : Logger(), debug_(debug){};
  void set_debug(bool debug) { debug_ = debug; }

 private:
  bool debug_{true};
  py::module logging_{py::module::import("logging")};

  void on_error(std::string&& str) final {
    if (!debug_) return;
    py::gil_scoped_acquire gil;
    logging_.attr("error")(str);
  }
  void on_critical(std::string&& str) final {
    if (!debug_) return;
    py::gil_scoped_acquire gil;
    logging_.attr("critical")(str);
  }
  void on_warning(std::string&& str) final {
    if (!debug_) return;
    py::gil_scoped_acquire gil;
    logging_.attr("warning")(str);
  }
  void on_message(std::string&& str) final {
    if (!debug_) return;
    py::gil_scoped_acquire gil;
    logging_.attr("info")(str);
  }
  void on_info(std::string&& str) final {
    if (!debug_) return;
    py::gil_scoped_acquire gil;
    logging_.attr("info")(str);
  }
  void on_debug(std::string&& str) final {
    if (!debug_) return;
    py::gil_scoped_acquire gil;
    logging_.attr("debug")(str);
  }
};

}  // namespace sh4lt::logger
#endif
