/// @ref gtx_scalar_relational
/// @file glm/gtx/scalar_relational.hpp
///
/// @see core (dependence)
///
/// @defgroup gtx_scalar_relational GLM_GTX_scalar_relational
/// @ingroup gtx
///
/// @brief Extend a position from a source to a position at a defined length.
///
/// <glm/gtx/scalar_relational.hpp> need to be included to use these functionalities.

#pragma once

// Dependency:
#include "../glm.hpp"

#ifndef GLM_ENABLE_EXPERIMENTAL
#	error "GLM: GLM_GTX_extend is an experimental extension and may change in the future. Use #define GLM_ENABLE_EXPERIMENTAL before including it, if you really want to use it."
#endif

#if GLM_MESSAGES == GLM_MESSAGES_ENABLED && !defined(GLM_EXT_INCLUDED)
#	pragma message("GLM: GLM_GTX_extend extension included")
#endif

namespace glm
{
	/// @addtogroup gtx_scalar_relational
	/// @{



	/// @}
}//namespace glm

#include "scalar_relational.inl"
