Intel Open Image Denoise Gallery
================================

This page contains a few sample screenshots of different renderings denoised
with Intel Open Image Denoise, using the color, albedo, and normal buffers as
inputs. The original (noisy) color buffers are also shown. Hover over an image
(or tap on it if you have a touchscreen) to move the slider between the
original and denoised versions.

If *you* have created any notable images using Intel Open Image Denoise and
would like to share them on this page, please [send us an
email](mailto:openimagedenoise@googlegroups.com).

Crytek Sponza
-------------

Rendered at 16 spp and denoised in HDR:

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/sponza_16spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/sponza_16spp_input.jpg"><span>Original</span></div>
</div>

*Scene courtesy of Frank Meinl, downloaded from [Morgan McGuire's Computer Graphics Archive](https://casual-effects.com/data).*

Amazon Lumberyard Bistro
------------------------

Rendered at 64 spp and denoised in HDR:

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/bistro_64spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/bistro_64spp_input.jpg"><span>Original</span></div>
</div>

Rendered at 16 spp and denoised in HDR:

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/bistro3_16spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/bistro3_16spp_input.jpg"><span>Original</span></div>
</div>

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/bistro2_16spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/bistro2_16spp_input.jpg"><span>Original</span></div>
</div>

*Scene created by Amazon Lumberyard, released publicly in the NVIDIA [Open Research Content Archive
(ORCA)](http://developer.nvidia.com/orca/amazon-lumberyard-bistro) collection, downloaded from
[Morgan McGuire's Computer Graphics Archive](https://casual-effects.com/data).*

Mazda
-----

Rendered at 64 spp and denoised in LDR:

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/mazda_64spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/mazda_64spp_input.jpg"><span>Original</span></div>
</div>

*Scene by Evermotion.*

Villa
-----

Rendered at 32 spp and denoised in HDR:

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/villa_32spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/villa_32spp_input.jpg"><span>Original</span></div>
</div>

Rendered at 16 spp and denoised in HDR:

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/villa2_16spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/villa2_16spp_input.jpg"><span>Original</span></div>
</div>

*Scene by Evermotion.*

Art Deco
--------

Rendered at 2048 spp and denoised in HDR:

<div class="img-compare" style="padding-bottom: 56.25%; /* 9/16 */" onmousemove="this.getElementsByTagName('div')[0].style.width=event.offsetX+'px'">
<img src="images/artdeco_2048spp_oidn.jpg"><span>Denoised</span>
<div><img src="images/artdeco_2048spp_input.jpg"><span>Original</span></div>
</div>

*Scene by Evermotion.*
