<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 17, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital
  * [X] Christophe Brejon
  * [X] Deke Kincaid - Digital Domain
  * [X] Allie Moon - Industrial Light & Magic
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Zach Lewis - Method
  * [X] Alex Forsythe - A.M.P.A.S.
  * [X] J Schulte - Industrial Light & Magic
  * [X] Matthias Scharfenberg - Industrial Light & Magic

Apologies:
  * 

# **OCIO Configs Working Group Meeting Notes**

* OCIO output transform implementation:
    - Doug: Working on PR to do something similar to ACES color space 
      transforms. Add builtin transforms to facilitate making ACES config, etc. 
      Involves mapping ACES output transform structure to OCIO structure.
        - **See slides**: https://docs.google.com/presentation/d/1sLyY8Q4JVkM6TqDHbqq9OWAW0zNcwvJQnh_jCtM4JHU/edit?usp=sharing
        - Plan is to map ACES 1.0 and 1.1 output transforms into OCIO v2 
          structure. Reduces code and makes it clear how the ACES transforms 
          are defined. Moving linearCV to outputCV section of CTL into its own 
          transform. Transforms which have similar calculations would share 
          components in OCIO.
        - Naming can be discussed. Table is just straw-man for group 
          discussion.
    - Alex: So primaries don't come into play until clamping happens?
    - Doug: Yes. Last slide has summary of all view transforms and display 
      color spaces. display color spaces are very simple - basically matrix and 
      gamma, or matrix and EOTF. Working on PR for this, but wanted to share 
      high level thought process.
    - Mark: What is the PR for?
    - Doug: To add builtin transforms outlined in the slides. Each view 
      transform would become a builtin transform. PR only on the OCIO repo 
      (not configs repo).
    - Mark: Does this mean we have multiple display referred spaces, and some 
      outputs attached to each one? Or are they associated with specific 
      displays?
    - Doug: In display/view section of config. For example, "Rec. 709" 
      display/view with "ACES 1.0 SDR-video" view transform, and "Rec. 709" 
      display color space. Each would have name, view transform, and display 
      color space. Down in 'view_transform' section of config would have the 
      view transforms with a transform referencing builtin transform 
      (see slides).
    - Mark: Shame that so many view transforms are required, due to gamut 
      limiting and simming. Not a nice common space for them all to go through, 
      like OCES for example. Can limits not be done on display end after 
      transform?
    - Doug: Could be done that way. Depends what we think of as a display color 
      space. Would take things from view transforms and move to display color 
      spaces (limits, etc.). Did it the current way because it's nicer to keep 
      display color spaces as simple matrix/gamma transform. The limiting and 
      white poiont simulating parts are more of the view rather than part of 
      Rec. 709/Rec. 2020, etc. Display color spaces kept as simple pure display 
      specs.
    - Mark: Under assumption that with separate view transforms, the graph 
      would be simpler. But with the complexity, why even need the view 
      transform? Rather than going direct from scene to display?
    - Doug: This is more flexible. Allows adding other combinations not in 
      aces-dev repo. Right now aces-dev doesn't have D60 sim on Rec. 2020 
      monitor. If someone needs that there's no way to do it. With this, 
      that could be done easily.
    - Mark: That would need to be explicitly added to the config right?
    - Doug: Need to decide what we need to do with ACES config. Could be 
      faithful mapping of things just in aces-dev repo. And a studio config 
      with the other parts in the current ACES configs. Would be a choice for 
      config author to make. The building blocks are there.
    - J: Know trying to map CTL to OCIO. There are lot of color spaces that use 
      limited output, but we would never use the limited output. Adds a lot of 
      extra outputs.
    - Doug: These are convenance things for people that want to work that way. 
      Common request that people don't want to put colors out that they can't 
      preview on their device. Goes against original ACES design intent, which 
      was to preserve all of the colors. In practice post production doesn't 
      want to take risk on out of gamut colors and clamp.
    - Kevin: Artistic intent to clamp in range sometimes, in DI.
    - J: Yes, we master to an explicit target with no room for 
      misinterpretation.
    - Michael: The idea too is that the config generator would be configurable. 
      Definitely the studio config, but we could also make the reference config
      configurable to include/exclude certain transforms, like limited outputs.
    - Doug: Could also make them inactive, and just turn them on, wouldn't need 
      to re-generate. Either way fine though.
    - Carol: Get the reasoning for adding ACES version to the naming, but also 
      don't know how much that's going to be relevant to people. For change 
      control mechanism?
    - Kevin: Runs risk of comparing versions and saying one is better than 
      other.
    - Mark: Need it to support revisions. Very internal pieces.
    - Carol: Would version config with transforms usually.
    - Doug: Name of builtin transform definitely have version in it, but only 
      seen by config author. Good point that for user facing parts, do we need 
      the version in there?
    - Matthias: If the SDR transform hasn't changed and we're on new version, 
      means that the SDR transform is still same for new version. Consistent 
      version number that matches latest version of ACES release. If all taken 
      from same ACES version, use current name, instead of old name.
    - Mark: Can alias them between versions and have same math if that helps 
      people. Gives flexibility for building version specific configs.
    - Kevin: Version number change makes sense when look changes.
    - Mark: Would be nice if you could make a config based on specific ACES 
      version, aliasing versions to keep them up to date.
    - Doug: One concern on ACES side about the transform ID. Thomas pulls name 
      from the ID, which has persistent name for things like ACES metadata 
      file. Wouldn't want to bump the ID version unless the code changed, but 
      not a user facing name. For ID strings, shouldn't bump version, but for 
      user facing things we need to figure out something thats not confusing.
    - Mark: Config authors are also users. Currently no mapping from ID strings 
      to builtin transforms.
    - Doug: Correct, no direct mapping. Tried to demonstrate that in slides. 
      Thomas is filtering some of the names. Kept it simpler for presentation, 
      but agree that builtin transform code should have full transform id string.
    - Mark: If someone really has to understand history - the way ACES config 
      code was structured at time. We have generator that sees both worlds. If 
      you remove half from users, will have no idea.
    - Doug: That's behind string proposals in slides. But need to decide as 
      group.
    - Michael: Could we store that in format metadata? accessible from API?
    - Doug: Yes, could create description tags in format metadata. More human 
      readable name and include data from CTL which has a lot of great 
      information.
    - Thomas: Being put in description right now.
    - J: A UI bomb for tools that use it.
    - Michael: Will it be 1:1 transform -> CTL?
    - Mark: Hard to keep that link because of the view/display split. Breaks 
      that relationship. Free then to put whatever comment you like.
    - Doug: For input and color space conversion side, more 1:1. For output 
      transform would need table.

* ACES transform spreadsheet:
    - Another item we previously discussed was creating a spreadsheet with all 
      ACES transforms, where we could discuss what should be included in the 
      reference config.
    - Mark: Can take names from Doug's slides as well?
    - Kevin: For lib itself, would these transforms introduce new ops? Or black 
      boxes?
    - Mark: Black boxes, implemented however we like. Either existing ops or on 
      the fly 1D or 3D LUT.
    - Doug: No 3D LUTs in builtin transforms. Goal is to move beyond 3D LUT 
      limitations. Big limitation in current config. Have ops now (fixed 
      function, etc.) added for this purpose, which is faithful to CTL itself.
    - Kevin: Tradeoff between the black box and being able to understand that 
      it is doing what the CTL is doing.
    - Doug: Will be very clear, mapping from ops to the CTL. That will be in 
      the PR, and I can show corresponding YAML to help. Should show this 
      comparison in meeting at some point.
    - Mark: Already quite a few implemented in OCIO source, under builtin 
      transform folder.
    - Kevin: It's a bit opaque.
    - Mark: Its a black box by design, not having to think about how to add all 
      the pieces to get an ACES config. Opting to have the pre-made collection 
      of transforms.
    - Doug: convenience for config authors. If someone looks at the internals, 
      could manually put all the pieces in the config yourself to be more 
      transparent. Could have a builtin transform and more exposed version 
      which lists individual ops. Would be long and verbose, but clearer for 
      those who want to understand each step.
    - For next week let's get a spreadsheet populated so we can discuss config 
      contents.
    - Mark: Can we link empty sapreadsheet in notes?
    - **Spreadsheet for next discussion**: https://docs.google.com/spreadsheets/d/1SXPt-USy3HlV2G2qAvh9zit6ZCINDOlfKT07yXJdWLg/edit?usp=sharing
