<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

August 17, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Joseph Goldstone - ARRI

Apologies:
  Mei Chu

# **OCIO TSC Meeting Notes**

* OSD Slides & talk:
    - OSD Slide deck is ready for updates. OCIO talk is first thing on 
      Wednesday. We will likely have Q&A time at end since the event is 
      55 minutes.

* Documentation TODOs:
    - Carol: Will submit PR before Wednesday to fix some homepage bugs.
    - Doug: Thomas dove into docs and gave good feedback on Slack. One focus 
      should be Python example code, which is missing. Will look at writing 
      some examples. Should look at how to integrate python and YAML into 
      documentation via discussed tabs, etc.
    - Michael: How should we identify doc sections is need of work?
    - Carol: Time to move outstanding issues from Google doc to GH issues.
    - Doug: Some issues are referenced in the Documentation GH project. We 
      should triage those on Friday.

* libutils discussion:
    - Michael: Continuation of discussion from two weeks ago about whether 
      libutils should be distributed alongside libOpenColorIO.
    - Mark B: Don't want optional features because OCIO gets embedded in DCCs. 
      Should be consistent everywhere. Previously was an issue with optional 
      Boost shared pointers, so DSO couldn't be swapped. Don't feel we should 
      be shipping anything other than the main lib. If other libs are needed, 
      needs to be a compelling reason for them to exists. Calling them utils 
      doesn't hit that bar for why they should ship. If they are examples, make 
      them available as code only.
    - Michael: We could separate out the libutils cmake, making it available 
      for users to build on their own. Still needs to be included in OCIO CI 
      though.
    - Mark B: Once we dist OCIO, a cmake stub lists all exported targets, and 
      those are what were expecting others to import. Could make them pruned 
      off from tree as a separate project, not built by default. Can still 
      build those and run as part of CI. Can have docs on how to get started 
      with example programs and how to install them, linking against deployed 
      OCIO.
    - Kevin: Would it still be a library? Could they still get used as such? Is 
      it something that should be a static lib that you can optionally link 
      against.
    - Patrick: That's how they are now, and are currently statically linked by 
      apps.
    - Mark B: Can compile them, just don't install them in the install 
      location. Lib folder should only contain core OCIO.
    - Patrick: In OIIO, there is a shared lib for utils. Could be like that.
    - Mark B: Not a good practice, and that is a shared library.
    - Patrick: Could it be an option to make it a dynamic lib released as 
      utils?
    - Mark B: Small amount of users will use these. Don't need the extra 
      library to do anything. Most people will encounter OCIO through a package 
      manager or as an end user, and just want to run OCIO. Won't need all the 
      extra bits. From our lib side, it's about shrinking the amount of stuff 
      that we're supporting. Good to keep it small. Most libs don't come with 
      utils.
    - Patrick: Valid point, but fear people will rewrite these pieces. They 
      will help ease transition to v2.
    - Mark B: If that stuff is good, should have a space in libOpenColorIO.so, 
      part of namespace with utils.
    - Michael: Like OIIO::ImageBufAlgo.
    - Patrick: Want to limit dependencies. libutils depends on OIIO and other 
      libs, which is why it was decided to make it external. Want to avoid 
      people rewriting these pieces.
    - Mark B: Think it's good to provide, but shared lib probably not right way 
      to do it. Provide code and allow implementors to decide how they want to 
      implement and what dependencies to use. We've made it easy to get started.
    - Patrick: If we don't distribute, package managers will not have these 
      pieces.
    - Mark B: Most people downloading lib wont need this.
    - Doug: There are different categories. Some things could be separate, but 
      apputils probably needs to move into the core library.
    - **TODO**: Patrick will investigate alternative options and report back 
      when there's time.

* PR #1104:
  - Patrick: Fix for cmake detection via CMake user registry, could use review 
    by someone else. Special case, but should be merged soon.

* Python optional parameters:
  - Patrick: Thomas discovered some Python interface that should have default 
    parameters, which were previously optional parameters are now mandatory 
    (issue #1105). C++ has no optional parameters per OCIO design, but this 
    rule is not necessarily appropriate for Python. How should we handle this 
    in Python? Also highlights being backwards compatible for C++ vs Python. 
    We should decide if we are backwards compatible and consistent with v1 
    Python API.
  - Mark: Perhaps both can change if the APi is bad.
  - Patrick: Think we need to be consistent where possible.
  - Mark T: Hit the same issue while testing at Foundry. Differences in 
    default parameters of API were problematic.
  - Michael: There have also been some issues where null pointers in the C++ 
    API don't interface well with None in Python and cause a crash. pybind11
    provides a solution for this which we've been fixing whenever a case is 
    found.
  - Doug: We also made improvements in C++ to not crash in these cases.
  - TSC agrees that optionals args in the Python API (contrary to the c++ API)
    is good and to move ahead with suggested fix.
