<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

December 9, 2019

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [ ] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [ ] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carl Rand (_TSC_) - Foundry
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [ ] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk

Apologies:
  Kevin Wheatley
  Larry Gritz

# **OCIO TSC Meeting Notes**

* TSC membership changes
    - Carl: Peter Crossley will be the new Foundry TSC representative 
      starting next week.
    
* OCIO-Configs AMPAS license update
    - Michael wrote ACES chairs and staff. Annie responded that they will 
      discuss and get back to us.
        - Patrick: What is the plan if we can’t resolve the licenses?
        - Michael: The code can stay on Imageworks GH for now.
    - Michael: When OCIO v2 is complete, a new ACES config will be needed to 
      make use of the new features.
        - Doug: The existing ACES config will still be valid and supported as 
          well.
        - Sean: The new config will need a Python re-write. Someone should 
          clearly contribute that work under AMPAS/ACES for a fresh start.
        - Will need note indicating which config should be used to avoid 
          confusion.
    - Doug: Need general example code for developers in repo showing how devs 
      would take advantage of new features, with configs for users and config 
      authors.
        - Patrick: Commandline apps provide good code examples. Will need to 
          be correctly upgraded to OCIO v2 to demonstrate new API.
        - Sean: Should also demonstrate how to implement color management in 
          applications. Need high-level guidelines on proper OCIO usage.

* Docs update
    - Sean: Working on cleaning up docs, with the goal of parity between Python 
      and C++, without having to rewrite docstrings and examples.
    - Michael: Larry did the same for OIIO last year, consolidating all docs to 
      one RTD setup. It would be worth seeing what he did.

* GPU CI update
    - Michael: Waiting on AZP setup from LFRE. JF Panisset has working 
      implementation in his OCIO fork and personal AZP acocunt. He is talking 
      offline with Micrsosoft TAC rep about when dynamic instances might be 
      supported.
    - Patrick: What JF did works well. Just CI pipeline configuration needed 
      for the most part.
    - **TODO**: Michael to follow up with LFRE on state us AZP/AWS setup.

* Mission Statement
    - Michael: Take a look when you have a chance. TAC is asking projects to 
      create these statements to help communicate project goals.
    - Doug is it a vision statement or mission statement? Mission statement is 
      more tactical.
    - Michael: Tactical sounds right. It should outline our goals and 
      commitment to advancing and maintaining a healthy project and continuing 
      to serve the industry.
    - Doug: Most of the things currently outlined are being met now.
    - Michael: Yes, that’s great. The mission statement will help keep that 
      focus long term.

* Holiday schedule
    - No meeting Dec 23 or 30; resume in January. We will meet on the 16th for 
      anyone who is available.
    - Michael: Also I wanted to mention that February marks the end of our first 
      TSC leadership term, if anybody has an interest in serving in a leadership 
      role.

* Python bindings update
    - Sean: What’s the status of the bindings?
    - Michael: I’ve bound all the transforms; working on the config currently.
    - Patrick/Doug: Anything you need help with in the library?
    - Michael: We will need to make the Transform destructor public, and decide 
      if it makes sense to unify array arguments to API. I already changed the 
      destructor, and we can address the array arguments later if needed.
        - Still need to write lots of unit tests, but can share the WIP code if 
          there's interest, for review or collaboration.
        - Patrick: You could push it in a partially completed state to avoid one 
          massive PR if needed.
        - WIP link: https://github.com/michdolan/OpenColorIO/tree/ocio_pybind/src/bindings/python
