<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

June 30, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital
  * [X] Troy Sobotka

# **OCIO Configs Working Group Meeting Notes**

* Initial color spaces:
    - ACES discovery code (Thomas): 
      [Graph](https://github.com/AcademySoftwareFoundation/OpenColorIO-Config-ACES/issues/3) 
    - Thomas: Generated by python code which discovers all CTL transforms. 
      With v2 we know what transforms are needed (graph edges), supported 
      by OCIO BuiltIn transforms. Graph can be basis for building config. 
      Once edges are implemented, the config is done.
    - Doug: Would like to see BuiltIn transforms for all of these edges.
    - Thomas: Can build config generator on top of that. Plan of least 
      resistance. Discovery work also good for finding errors on ACES side.
    - Kevin: This implementation could lead to a lot of transform 
      duplication. Would that be simplified?
    - Doug: In BuiltIn transforms, it's already factorized.
    - Kevin: Thinking in terms of expressivity. Programmatically building 
      this graph would fail to show underlying relationships between color 
      spaces.
    - Doug: If we are using BuiltIn transforms, we could break them down 
      into matrix and non-linear components, composed as ColorSpace 
      transform transforms. Already set up this way internally.
    - Mark: ILM internal config generator does something similar. Generates 
      color spaces composed of other color spaces, mapping of gamuts and 
      transfer functions. Useful to generate all gamuts first, and from 
      there generate all transfer functions that need each gamut.
    - Michael: Would ACES GH repo be a runtime dependency or cached?
    - Thomas: Runtime, like CI process.
    - Doug: Good to have no external file dependencies.
    - Thomas: For studio config could add extra LUTs, etc. Think everything 
      in reference config can be expressed without LUT. Should just work.
    - Doug: Even things that typically require LUTs, BuiltInTransform can 
      handle it.
    - Kevin: What about back port to OCIO V1? Bake color spaces from v2 
      config?
    - Thomas: Not planning to change anything for v1. This code won't work 
      with v1 currently.
    - Michael: Initial config solution is essentially a BuiltInTransform 
      matchmaking system.

* Display & views:
    - Doug: Should do proper views and displays in this config version, Rec. 
      709, Rec 2020, etc.
    - Thomas: Can group/organize config how we want.
    - Michael: Could use RRT view transform (display reference space), and have 
      display/view per ODT
    - Kevin: Would be good to do that, to express things properly.
    - Mark: There are some differences (parametric display transform) which 
      might make that not work.
    - Carol: The new RRT+ODT design is more parameterized.
    - Doug: In recent work, RRT+ODT is called output transform. More recent HDR 
      work generates these as one piece. Can be expressed with view transform.
      The display reference space would include part of ODT. We do this now 
      with the SynColor CTF ACES transforms.
    - Matthias: Would display reference be dependent on display device?
    - Doug: Possible to have display reference space that is generic. Can be 
      CIE XYZ. Just need to implement.
    - Michael: Would the discovery code automate display creation from CTL 
      directories, since they are grouped like that?
    - Thomas: Already how the code is structured.

* Looks:
    - Michael: Are there cases where we want to define looks as well, for the 
      blue light artifact fix for example.
    - Carol: Depends on the ACES gamut mapping working group :)
    
* Next steps:
    - Michael: As a first step, perhaps we should generate a simulated config 
      structure. Can act as a TODO list.
    - Thomas: Yes. Mock config to plan everything out. I can commit current 
      code to a special dev branch, where it can be contributed to by others. 
      Will set up README too, and then we can work on generating an initial 
      config.
    - **TODO**: Thomas will open PR with discovery code in 
      OpenColorIO-Config-ACES repo.
    - Mark: I Want to help once OpenColorMath is ready. It could help a lot 
      with generating the ACES configs.
    - Thomas: Mark's code could be leveraged to make the config studio grade. 
      All the added transforms to be finishing for the remaining part of the 
      config.
    - Kevin: There are currently multiple Sony S-Gamuts, depending on which 
      camera an image is coming from. How would this be implemented. Different 
      name for each?
    - Thomas: Need to determine how to name things. 
    - Doug: Could use naming from ACES.
    - Carol: How can we get more help? We should reach out to Slack, ocio-dev, 
      ocio-user for new input, since this work is Python, it is more accessible.
    - Thomas: Agree. Let's just wait till the project is rolling. Once there 
      is a plan. The code is Python, but the config is non-trivial to develop; 
      but simpler than C.
    - Sean: How much automation is intended for building the config?
    - Thomas: Full automation for reference config. 
    - Doug: Anyone want to help with adding missing ACES components in BuiltIn 
      transforms? Work is pretty straightforward. ODT part should be 
      facilitated by another in-progress PR. Could start with input transforms 
      first, and in a few weeks go to output transforms.
    - Thomas: Could there be mock transforms? To at least test the config? 
      Would a mock config break if transforms are missing? Can we have mock 
      transforms (as an outline, TODO list of sorts).
    - Doug: Great idea. Contributors can then fill in the blanks to help. Let's 
      get transform IDs and fill in BuiltIns for all of those.
    - **TODO**: Michael will create GH Issue about building out full ACES 
      BuiltIn transform skeleton to guide contributors.
    - Sean: The dependency chain between the config, OCIO, and ACES will be 
      tricky. Dependent on transforms existing in OCIO core first. How to do 
      releases? Tag? 
    - Thomas: Work in branches to reference precise state of ACES dev.
    - Sean: There will be cases where we want a color space in config, but 
      there's a delay with deploying a new OCIO version. May have to deliver 
      LUT temporarily.
    - Mark: Or write an expression via OpenColorMath.
    - Sean: Since there will be multiple config flavors, users will need to 
      reference specific config versions. Problem of sharing between studios 
      since it won't just be "the ACES config". Which ACES config?
    - Michael: In the last meeting we discussed having two flavors; an ACES 
      reference config, and the "studio in a box" config, which would be 
      created later, on top of the ACES reference config code.
    - Thomas: The config generator needs to be easy to use. That will be 
      important.
    - **TODO**: Determine branch, release and versioning strategy.
    - Sean: Missed Thomas' issue with the graph. Is the repo integrated with 
      Slack yet?
    - Doug: Slack connection would be good.
    - **TODO**: Michael will request Slack integration for the 
      OpenColorIO-Config-ACES repo (from LF releng).
