# OpenCL ICD Loader Code Generation

## Introduction

In order to ease maintenance and enable faster development of related OpenCL ICD loader features, the OpenCL ICD loader API dispatch functions are generated from the OpenCL XML machine readable grammar.

## Dependencies

The API dispatch functions are generated using Python [Mako Templates](https://www.makotemplates.org/).

In most cases, after installing Python for your platform, Mako may be installed using:

```sh
$ pip install Mako
```

## Making Changes

Most changes only require modifications to the Mako templates.
Small changes modifying syntax or layout are simple and straightforward.
Occasionally more complicated changes will be required, say when a new API is added that is unlike any previous API, but this should be rare.

The Python script should only need to be modified if additional information needs to be propagated from the XML file into the Mako template itself.

## Generating Files

Files for the OpenCL ICD loader, or the test layer, may be generated by executing the scripts `gen_loader.py`, or `gen_print_layer.py`, respectively.

The script requires the `cl.xml` machine readable grammar.
By default, the script searches for `cl.xml` in the current directory.
The latest version of `cl.xml` may be found in the Khronos OpenCL-Docs repo [here](https://github.com/KhronosGroup/OpenCL-Docs/blob/main/xml/cl.xml).

The output from the script is placed in the current directory by default, to allow easy comparisons between the generated files and the current files.
After the generated files are evaluated, they should be manually copied into the source tree.
These steps may be automated in the future.
