import re

DOXYFILE = 'Doxyfile-mcss'

STYLESHEETS = [
    'https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,400i,600,600i%7CSource+Code+Pro:400,400i,600&subset=latin-ext',
    '../css/m-dark+documentation.compiled.css'
]

MAIN_PROJECT_URL = 'https://magnum.graphics/'

LINKS_NAVBAR1 = [
    (None, 'getting-started', [
        (None, 'building'),
        (None, 'cmake'),
        (None, 'custom-buildsystems')
    ]),
    (None, 'pages', [
        (None, 'features'),
        (None, 'platforms'),
        (None, 'example-index'),
        (None, 'tips'),
        (None, 'utilities')
    ])
]
LINKS_NAVBAR2 = [
    (None, 'namespaces', []),
    (None, 'annotated', []),
    (None, 'files', []),
    ("<a href=\"../../../../magnum-bindings/build/doc/python/index.html\">Python API</a>", [])
]

FINE_PRINT = """<p>Magnum docs. Part of the <a href="https://magnum.graphics/">Magnum project</a>, copyright © <a href="http://mosra.cz/">Vladimír Vondruš</a> and <a href="credits-contributors.html">contributors</a>, 2010&ndash;2020.<br />Generated by <a href="https://doxygen.org/">Doxygen</a> {doxygen_version} and <a href="https://mcss.mosra.cz/">m.css</a>. Contact the team via <a href="https://github.com/mosra/magnum">GitHub</a>, <a href="https://gitter.im/mosra/magnum">Gitter</a>, <a href="mailto:info@magnum.graphics">e-mail</a> or <a href="https://twitter.com/czmosra">Twitter</a>.</p>"""

SEARCH_HELP = """<p class="m-noindent">Search for symbols, directories, files, pages, OpenGL, GLSL, Vulkan and OpenAL APIs. You can omit any prefix from the symbol or file path; adding a <code>:</code> or <code>/</code> suffix lists all members of given symbol or directory.</p> <p class="m-noindent">Use <span class="m-label m-dim">&darr;</span> / <span class="m-label m-dim">&uarr;</span> to navigate through the list, <span class="m-label m-dim">Enter</span> to go. <span class="m-label m-dim">Tab</span> autocompletes common prefix, you can copy a link to the result using <span class="m-label m-dim">⌘</span> <span class="m-label m-dim">L</span> while <span class="m-label m-dim">⌘</span> <span class="m-label m-dim">M</span> produces a Markdown link.</p>"""

FAVICON = 'favicon.ico'

VERSION_LABELS = True

_magnum_colors_src = re.compile(r"""<span class="mh">0x(?P<hex>[0-9a-f]{6})(?P<alpha>[0-9a-f]{2})?(?P<literal>_s?rgba?f?)</span>""")
_magnum_colors_dst = r"""<span class="mh">0x\g<hex>\g<alpha>\g<literal><span class="m-code-color" style="background-color: #\g<hex>;"></span></span>"""

M_CODE_FILTERS_POST = {
    'C++': lambda str: _magnum_colors_src.sub(_magnum_colors_dst, str)
}
