; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s | FileCheck -check-prefixes=RV32 %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s | FileCheck -check-prefixes=RV64 %s

define i64 @test_clear_mask_i64_i32(i64 %x) nounwind {
; RV32-LABEL: test_clear_mask_i64_i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    bltz a0, .LBB0_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB0_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_clear_mask_i64_i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    bltz a1, .LBB0_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB0_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i64 %x, 2147483648
  %r = icmp eq i64 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i64 [ %x, %entry], [ 42, %t]
  ret i64 %ret
}

define i64 @test_set_mask_i64_i32(i64 %x) nounwind {
; RV32-LABEL: test_set_mask_i64_i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    bgez a0, .LBB1_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB1_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_set_mask_i64_i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    bgez a1, .LBB1_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB1_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i64 %x, 2147483648
  %r = icmp ne i64 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i64 [ %x, %entry], [ 42, %t]
  ret i64 %ret
}

define i64 @test_clear_mask_i64_i16(i64 %x) nounwind {
; RV32-LABEL: test_clear_mask_i64_i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    slli a2, a0, 16
; RV32-NEXT:    bltz a2, .LBB2_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB2_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_clear_mask_i64_i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    slli a1, a0, 48
; RV64-NEXT:    bltz a1, .LBB2_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB2_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i64 %x, 32768
  %r = icmp eq i64 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i64 [ %x, %entry], [ 42, %t]
  ret i64 %ret
}

define i64 @test_set_mask_i64_i16(i64 %x) nounwind {
; RV32-LABEL: test_set_mask_i64_i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    slli a2, a0, 16
; RV32-NEXT:    bgez a2, .LBB3_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB3_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_set_mask_i64_i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    slli a1, a0, 48
; RV64-NEXT:    bgez a1, .LBB3_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB3_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i64 %x, 32768
  %r = icmp ne i64 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i64 [ %x, %entry], [ 42, %t]
  ret i64 %ret
}

define i64 @test_clear_mask_i64_i8(i64 %x) nounwind {
; RV32-LABEL: test_clear_mask_i64_i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    andi a2, a0, 128
; RV32-NEXT:    bnez a2, .LBB4_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB4_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_clear_mask_i64_i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    andi a1, a0, 128
; RV64-NEXT:    bnez a1, .LBB4_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB4_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i64 %x, 128
  %r = icmp eq i64 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i64 [ %x, %entry], [ 42, %t]
  ret i64 %ret
}

define i64 @test_set_mask_i64_i8(i64 %x) nounwind {
; RV32-LABEL: test_set_mask_i64_i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    andi a2, a0, 128
; RV32-NEXT:    beqz a2, .LBB5_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB5_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_set_mask_i64_i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    andi a1, a0, 128
; RV64-NEXT:    beqz a1, .LBB5_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB5_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i64 %x, 128
  %r = icmp ne i64 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i64 [ %x, %entry], [ 42, %t]
  ret i64 %ret
}

define i32 @test_clear_mask_i32_i16(i32 %x) nounwind {
; RV32-LABEL: test_clear_mask_i32_i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    slli a1, a0, 16
; RV32-NEXT:    bltz a1, .LBB6_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB6_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_clear_mask_i32_i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    slli a1, a0, 48
; RV64-NEXT:    bltz a1, .LBB6_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB6_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i32 %x, 32768
  %r = icmp eq i32 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i32 [ %x, %entry], [ 42, %t]
  ret i32 %ret
}

define i32 @test_set_mask_i32_i16(i32 %x) nounwind {
; RV32-LABEL: test_set_mask_i32_i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    slli a1, a0, 16
; RV32-NEXT:    bgez a1, .LBB7_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB7_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_set_mask_i32_i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    slli a1, a0, 48
; RV64-NEXT:    bgez a1, .LBB7_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB7_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i32 %x, 32768
  %r = icmp ne i32 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i32 [ %x, %entry], [ 42, %t]
  ret i32 %ret
}

define i32 @test_clear_mask_i32_i8(i32 %x) nounwind {
; RV32-LABEL: test_clear_mask_i32_i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    andi a1, a0, 128
; RV32-NEXT:    bnez a1, .LBB8_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB8_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_clear_mask_i32_i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    andi a1, a0, 128
; RV64-NEXT:    bnez a1, .LBB8_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB8_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i32 %x, 128
  %r = icmp eq i32 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i32 [ %x, %entry], [ 42, %t]
  ret i32 %ret
}

define i32 @test_set_mask_i32_i8(i32 %x) nounwind {
; RV32-LABEL: test_set_mask_i32_i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    andi a1, a0, 128
; RV32-NEXT:    beqz a1, .LBB9_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a0, 42
; RV32-NEXT:  .LBB9_2: # %f
; RV32-NEXT:    ret
;
; RV64-LABEL: test_set_mask_i32_i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    andi a1, a0, 128
; RV64-NEXT:    beqz a1, .LBB9_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:  .LBB9_2: # %f
; RV64-NEXT:    ret
entry:
  %a = and i32 %x, 128
  %r = icmp ne i32 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i32 [ %x, %entry], [ 42, %t]
  ret i32 %ret
}

define i16 @test_clear_mask_i16_i8(i16 %x) nounwind {
; RV32-LABEL: test_clear_mask_i16_i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    andi a1, a0, 128
; RV32-NEXT:    bnez a1, .LBB10_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a0, 42
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB10_2:
; RV32-NEXT:    slli a0, a0, 16
; RV32-NEXT:    srli a0, a0, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: test_clear_mask_i16_i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    andi a1, a0, 128
; RV64-NEXT:    bnez a1, .LBB10_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB10_2:
; RV64-NEXT:    slli a0, a0, 48
; RV64-NEXT:    srli a0, a0, 48
; RV64-NEXT:    ret
entry:
  %a = and i16 %x, 128
  %r = icmp eq i16 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i16 [ %x, %entry], [ 42, %t]
  ret i16 %ret
}

define i16 @test_set_mask_i16_i8(i16 %x) nounwind {
; RV32-LABEL: test_set_mask_i16_i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    andi a1, a0, 128
; RV32-NEXT:    beqz a1, .LBB11_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a0, 42
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB11_2:
; RV32-NEXT:    slli a0, a0, 16
; RV32-NEXT:    srli a0, a0, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: test_set_mask_i16_i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    andi a1, a0, 128
; RV64-NEXT:    beqz a1, .LBB11_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB11_2:
; RV64-NEXT:    slli a0, a0, 48
; RV64-NEXT:    srli a0, a0, 48
; RV64-NEXT:    ret
entry:
  %a = and i16 %x, 128
  %r = icmp ne i16 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i16 [ %x, %entry], [ 42, %t]
  ret i16 %ret
}

define i16 @test_set_mask_i16_i7(i16 %x) nounwind {
; RV32-LABEL: test_set_mask_i16_i7:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    andi a1, a0, 64
; RV32-NEXT:    beqz a1, .LBB12_2
; RV32-NEXT:  # %bb.1: # %t
; RV32-NEXT:    li a0, 42
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB12_2:
; RV32-NEXT:    slli a0, a0, 16
; RV32-NEXT:    srli a0, a0, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: test_set_mask_i16_i7:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    andi a1, a0, 64
; RV64-NEXT:    beqz a1, .LBB12_2
; RV64-NEXT:  # %bb.1: # %t
; RV64-NEXT:    li a0, 42
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB12_2:
; RV64-NEXT:    slli a0, a0, 48
; RV64-NEXT:    srli a0, a0, 48
; RV64-NEXT:    ret
entry:
  %a = and i16 %x, 64
  %r = icmp ne i16 %a, 0
  br i1 %r, label %t, label %f
t:
  br label %f
f:
  %ret = phi i16 [ %x, %entry], [ 42, %t]
  ret i16 %ret
}
