; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+m,+v -verify-machineinstrs < %s \
; RUN:    | FileCheck %s --check-prefixes=CHECK,NOZBA
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+zba -verify-machineinstrs < %s \
; RUN:    | FileCheck %s --check-prefixes=CHECK,ZBA
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s \
; RUN:    | FileCheck %s --check-prefixes=CHECK,NOMUL
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+prefer-vsetvli-over-read-vlenb  -verify-machineinstrs < %s \
; RUN:    | FileCheck %s --check-prefixes=CHECK-NOZBA-VSETVLI
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+zba,+prefer-vsetvli-over-read-vlenb  -verify-machineinstrs < %s \
; RUN:    | FileCheck %s --check-prefixes=CHECK-ZBA-VSETVLI
; RUN: llc -mtriple=riscv64 -mattr=+v,+prefer-vsetvli-over-read-vlenb  -verify-machineinstrs < %s \
; RUN:    | FileCheck %s --check-prefixes=CHECK-NOMUL-VSETVLI

define void @lmul1() nounwind {
; CHECK-LABEL: lmul1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul1:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul1:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul1:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v = alloca <vscale x 1 x i64>
  ret void
}

define void @lmul2() nounwind {
; NOZBA-LABEL: lmul2:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 1
; NOZBA-NEXT:    add sp, sp, a0
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul2:
; ZBA:       # %bb.0:
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 1
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    sh1add sp, a0, sp
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul2:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    add sp, sp, a0
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul2:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul2:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul2:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v = alloca <vscale x 2 x i64>
  ret void
}

define void @lmul4() nounwind {
; CHECK-LABEL: lmul4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -48
; CHECK-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 48
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -32
; CHECK-NEXT:    addi sp, s0, -48
; CHECK-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 48
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul4:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul4:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul4:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v = alloca <vscale x 4 x i64>
  ret void
}

define void @lmul8() nounwind {
; CHECK-LABEL: lmul8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -80
; CHECK-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 80
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    addi sp, s0, -80
; CHECK-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 80
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul8:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul8:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul8:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v = alloca <vscale x 8 x i64>
  ret void
}

define void @lmul1_and_2() nounwind {
; NOZBA-LABEL: lmul1_and_2:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 2
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 2
; NOZBA-NEXT:    add sp, sp, a0
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul1_and_2:
; ZBA:       # %bb.0:
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 2
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    sh2add sp, a0, sp
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul1_and_2:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    add sp, sp, a0
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul1_and_2:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul1_and_2:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul1_and_2:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 1 x i64>
  %v2 = alloca <vscale x 2 x i64>
  ret void
}

define void @lmul2_and_4() nounwind {
; CHECK-LABEL: lmul2_and_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -48
; CHECK-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 48
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -32
; CHECK-NEXT:    addi sp, s0, -48
; CHECK-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 48
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul2_and_4:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul2_and_4:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul2_and_4:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 2 x i64>
  %v2 = alloca <vscale x 4 x i64>
  ret void
}

define void @lmul1_and_4() nounwind {
; CHECK-LABEL: lmul1_and_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -48
; CHECK-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 48
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -32
; CHECK-NEXT:    addi sp, s0, -48
; CHECK-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 48
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul1_and_4:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul1_and_4:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul1_and_4:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 1 x i64>
  %v2 = alloca <vscale x 4 x i64>
  ret void
}

define void @lmul2_and_1() nounwind {
; NOZBA-LABEL: lmul2_and_1:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a1, a0, 1
; NOZBA-NEXT:    add a0, a1, a0
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a1, a0, 1
; NOZBA-NEXT:    add a0, a1, a0
; NOZBA-NEXT:    add sp, sp, a0
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul2_and_1:
; ZBA:       # %bb.0:
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    add sp, sp, a0
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul2_and_1:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a1, a0, 1
; NOMUL-NEXT:    add a0, a1, a0
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a1, a0, 1
; NOMUL-NEXT:    add a0, a1, a0
; NOMUL-NEXT:    add sp, sp, a0
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul2_and_1:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    slli a1, a0, 1
; CHECK-NOZBA-VSETVLI-NEXT:    add a0, a1, a0
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    slli a1, a0, 1
; CHECK-NOZBA-VSETVLI-NEXT:    add a0, a1, a0
; CHECK-NOZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul2_and_1:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sh1add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sh1add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul2_and_1:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a1, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a1, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 2 x i64>
  %v2 = alloca <vscale x 1 x i64>
  ret void
}

define void @lmul4_and_1() nounwind {
; NOZBA-LABEL: lmul4_and_1:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -48
; NOZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    addi s0, sp, 48
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    li a1, 6
; NOZBA-NEXT:    mul a0, a0, a1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    andi sp, sp, -32
; NOZBA-NEXT:    addi sp, s0, -48
; NOZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    addi sp, sp, 48
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul4_and_1:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -48
; ZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; ZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; ZBA-NEXT:    addi s0, sp, 48
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 1
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    andi sp, sp, -32
; ZBA-NEXT:    addi sp, s0, -48
; ZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; ZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; ZBA-NEXT:    addi sp, sp, 48
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul4_and_1:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -48
; NOMUL-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    addi s0, sp, 48
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    mv a1, a0
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    andi sp, sp, -32
; NOMUL-NEXT:    addi sp, s0, -48
; NOMUL-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    addi sp, sp, 48
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul4_and_1:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    li a1, 6
; CHECK-NOZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul4_and_1:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-ZBA-VSETVLI-NEXT:    sh1add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul4_and_1:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    mv a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 4 x i64>
  %v2 = alloca <vscale x 1 x i64>
  ret void
}

define void @lmul4_and_2() nounwind {
; NOZBA-LABEL: lmul4_and_2:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -48
; NOZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    addi s0, sp, 48
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    li a1, 6
; NOZBA-NEXT:    mul a0, a0, a1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    andi sp, sp, -32
; NOZBA-NEXT:    addi sp, s0, -48
; NOZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    addi sp, sp, 48
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul4_and_2:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -48
; ZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; ZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; ZBA-NEXT:    addi s0, sp, 48
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 1
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    andi sp, sp, -32
; ZBA-NEXT:    addi sp, s0, -48
; ZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; ZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; ZBA-NEXT:    addi sp, sp, 48
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul4_and_2:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -48
; NOMUL-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    addi s0, sp, 48
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    mv a1, a0
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    andi sp, sp, -32
; NOMUL-NEXT:    addi sp, s0, -48
; NOMUL-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    addi sp, sp, 48
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul4_and_2:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    li a1, 6
; CHECK-NOZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul4_and_2:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-ZBA-VSETVLI-NEXT:    sh1add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul4_and_2:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    mv a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 4 x i64>
  %v2 = alloca <vscale x 2 x i64>
  ret void
}

define void @lmul4_and_2_x2_0() nounwind {
; NOZBA-LABEL: lmul4_and_2_x2_0:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -48
; NOZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    addi s0, sp, 48
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    li a1, 14
; NOZBA-NEXT:    mul a0, a0, a1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    andi sp, sp, -32
; NOZBA-NEXT:    addi sp, s0, -48
; NOZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    addi sp, sp, 48
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul4_and_2_x2_0:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -48
; ZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; ZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; ZBA-NEXT:    addi s0, sp, 48
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    li a1, 14
; ZBA-NEXT:    mul a0, a0, a1
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    andi sp, sp, -32
; ZBA-NEXT:    addi sp, s0, -48
; ZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; ZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; ZBA-NEXT:    addi sp, sp, 48
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul4_and_2_x2_0:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -48
; NOMUL-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    addi s0, sp, 48
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    mv a1, a0
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    add a1, a1, a0
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    andi sp, sp, -32
; NOMUL-NEXT:    addi sp, s0, -48
; NOMUL-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    addi sp, sp, 48
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul4_and_2_x2_0:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    li a1, 14
; CHECK-NOZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul4_and_2_x2_0:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    li a1, 14
; CHECK-ZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul4_and_2_x2_0:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    mv a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a1, a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 4 x i64>
  %v2 = alloca <vscale x 2 x i64>
  %v3 = alloca <vscale x 4 x i64>
  %v4 = alloca <vscale x 2 x i64>
  ret void
}

define void @lmul4_and_2_x2_1() nounwind {
; NOZBA-LABEL: lmul4_and_2_x2_1:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -48
; NOZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    addi s0, sp, 48
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    li a1, 12
; NOZBA-NEXT:    mul a0, a0, a1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    andi sp, sp, -32
; NOZBA-NEXT:    addi sp, s0, -48
; NOZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    addi sp, sp, 48
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul4_and_2_x2_1:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -48
; ZBA-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; ZBA-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; ZBA-NEXT:    addi s0, sp, 48
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 2
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    andi sp, sp, -32
; ZBA-NEXT:    addi sp, s0, -48
; ZBA-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; ZBA-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; ZBA-NEXT:    addi sp, sp, 48
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul4_and_2_x2_1:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -48
; NOMUL-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    addi s0, sp, 48
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    mv a1, a0
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    andi sp, sp, -32
; NOMUL-NEXT:    addi sp, s0, -48
; NOMUL-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    addi sp, sp, 48
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul4_and_2_x2_1:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    li a1, 12
; CHECK-NOZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul4_and_2_x2_1:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 2
; CHECK-ZBA-VSETVLI-NEXT:    sh1add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul4_and_2_x2_1:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 2
; CHECK-NOMUL-VSETVLI-NEXT:    mv a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 4 x i64>
  %v3 = alloca <vscale x 4 x i64>
  %v2 = alloca <vscale x 2 x i64>
  %v4 = alloca <vscale x 2 x i64>
  ret void
}


define void @gpr_and_lmul1_and_2() nounwind {
; NOZBA-LABEL: gpr_and_lmul1_and_2:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -16
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 2
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    li a0, 3
; NOZBA-NEXT:    sd a0, 8(sp)
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 2
; NOZBA-NEXT:    add sp, sp, a0
; NOZBA-NEXT:    addi sp, sp, 16
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: gpr_and_lmul1_and_2:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -16
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 2
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    li a0, 3
; ZBA-NEXT:    sd a0, 8(sp)
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    sh2add sp, a0, sp
; ZBA-NEXT:    addi sp, sp, 16
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: gpr_and_lmul1_and_2:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -16
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    li a0, 3
; NOMUL-NEXT:    sd a0, 8(sp)
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    add sp, sp, a0
; NOMUL-NEXT:    addi sp, sp, 16
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: gpr_and_lmul1_and_2:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -16
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    li a0, 3
; CHECK-NOZBA-VSETVLI-NEXT:    sd a0, 8(sp)
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 16
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: gpr_and_lmul1_and_2:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -16
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    li a0, 3
; CHECK-ZBA-VSETVLI-NEXT:    sd a0, 8(sp)
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 16
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: gpr_and_lmul1_and_2:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -16
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    li a0, 3
; CHECK-NOMUL-VSETVLI-NEXT:    sd a0, 8(sp)
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 16
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %x1 = alloca i64
  %v1 = alloca <vscale x 1 x i64>
  %v2 = alloca <vscale x 2 x i64>
  store volatile i64 3, ptr %x1
  ret void
}

define void @gpr_and_lmul1_and_4() nounwind {
; CHECK-LABEL: gpr_and_lmul1_and_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -48
; CHECK-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 48
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -32
; CHECK-NEXT:    li a0, 3
; CHECK-NEXT:    sd a0, 8(sp)
; CHECK-NEXT:    addi sp, s0, -48
; CHECK-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 48
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: gpr_and_lmul1_and_4:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOZBA-VSETVLI-NEXT:    li a0, 3
; CHECK-NOZBA-VSETVLI-NEXT:    sd a0, 8(sp)
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: gpr_and_lmul1_and_4:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-ZBA-VSETVLI-NEXT:    li a0, 3
; CHECK-ZBA-VSETVLI-NEXT:    sd a0, 8(sp)
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: gpr_and_lmul1_and_4:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -48
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -32
; CHECK-NOMUL-VSETVLI-NEXT:    li a0, 3
; CHECK-NOMUL-VSETVLI-NEXT:    sd a0, 8(sp)
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -48
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 48
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %x1 = alloca i64
  %v1 = alloca <vscale x 1 x i64>
  %v2 = alloca <vscale x 4 x i64>
  store volatile i64 3, ptr %x1
  ret void
}

define void @lmul_1_2_4_8() nounwind {
; CHECK-LABEL: lmul_1_2_4_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -80
; CHECK-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 80
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    addi sp, s0, -80
; CHECK-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 80
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul_1_2_4_8:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    slli a0, a0, 4
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul_1_2_4_8:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 4
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul_1_2_4_8:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 4
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 1 x i64>
  %v2 = alloca <vscale x 2 x i64>
  %v4 = alloca <vscale x 4 x i64>
  %v8 = alloca <vscale x 8 x i64>
  ret void
}

define void @lmul_1_2_4_8_x2_0() nounwind {
; CHECK-LABEL: lmul_1_2_4_8_x2_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -80
; CHECK-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 80
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 5
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    addi sp, s0, -80
; CHECK-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 80
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul_1_2_4_8_x2_0:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    slli a0, a0, 5
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul_1_2_4_8_x2_0:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 5
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul_1_2_4_8_x2_0:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 5
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 1 x i64>
  %v2 = alloca <vscale x 1 x i64>
  %v3 = alloca <vscale x 2 x i64>
  %v4 = alloca <vscale x 2 x i64>
  %v5 = alloca <vscale x 4 x i64>
  %v6 = alloca <vscale x 4 x i64>
  %v7 = alloca <vscale x 8 x i64>
  %v8 = alloca <vscale x 8 x i64>
  ret void
}

define void @lmul_1_2_4_8_x2_1() nounwind {
; CHECK-LABEL: lmul_1_2_4_8_x2_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -80
; CHECK-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 80
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 5
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    addi sp, s0, -80
; CHECK-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 80
; CHECK-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul_1_2_4_8_x2_1:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    slli a0, a0, 5
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul_1_2_4_8_x2_1:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 5
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul_1_2_4_8_x2_1:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 5
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v8 = alloca <vscale x 8 x i64>
  %v7 = alloca <vscale x 8 x i64>
  %v6 = alloca <vscale x 4 x i64>
  %v5 = alloca <vscale x 4 x i64>
  %v4 = alloca <vscale x 2 x i64>
  %v3 = alloca <vscale x 2 x i64>
  %v2 = alloca <vscale x 1 x i64>
  %v1 = alloca <vscale x 1 x i64>
  ret void
}

define void @masks() nounwind {
; NOZBA-LABEL: masks:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 2
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    slli a0, a0, 2
; NOZBA-NEXT:    add sp, sp, a0
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: masks:
; ZBA:       # %bb.0:
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 2
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    sh2add sp, a0, sp
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: masks:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    add sp, sp, a0
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: masks:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: masks:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: masks:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    add sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 1 x i1>
  %v2 = alloca <vscale x 2 x i1>
  %v4 = alloca <vscale x 4 x i1>
  %v8 = alloca <vscale x 8 x i1>
  ret void
}

define void @lmul_8_x5() nounwind {
; NOZBA-LABEL: lmul_8_x5:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -80
; NOZBA-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    addi s0, sp, 80
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    li a1, 40
; NOZBA-NEXT:    mul a0, a0, a1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    andi sp, sp, -64
; NOZBA-NEXT:    addi sp, s0, -80
; NOZBA-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    addi sp, sp, 80
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul_8_x5:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -80
; ZBA-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; ZBA-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; ZBA-NEXT:    addi s0, sp, 80
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 3
; ZBA-NEXT:    sh2add a0, a0, a0
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    andi sp, sp, -64
; ZBA-NEXT:    addi sp, s0, -80
; ZBA-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; ZBA-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; ZBA-NEXT:    addi sp, sp, 80
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul_8_x5:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -80
; NOMUL-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    addi s0, sp, 80
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 3
; NOMUL-NEXT:    mv a1, a0
; NOMUL-NEXT:    slli a0, a0, 2
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    andi sp, sp, -64
; NOMUL-NEXT:    addi sp, s0, -80
; NOMUL-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    addi sp, sp, 80
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul_8_x5:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    li a1, 40
; CHECK-NOZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul_8_x5:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 3
; CHECK-ZBA-VSETVLI-NEXT:    sh2add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul_8_x5:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 3
; CHECK-NOMUL-VSETVLI-NEXT:    mv a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 2
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 8 x i64>
  %v2 = alloca <vscale x 8 x i64>
  %v3 = alloca <vscale x 8 x i64>
  %v4 = alloca <vscale x 8 x i64>
  %v5 = alloca <vscale x 8 x i64>
  ret void
}

define void @lmul_8_x9() nounwind {
; NOZBA-LABEL: lmul_8_x9:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -80
; NOZBA-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    addi s0, sp, 80
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    li a1, 72
; NOZBA-NEXT:    mul a0, a0, a1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    andi sp, sp, -64
; NOZBA-NEXT:    addi sp, s0, -80
; NOZBA-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    addi sp, sp, 80
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul_8_x9:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -80
; ZBA-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; ZBA-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; ZBA-NEXT:    addi s0, sp, 80
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 3
; ZBA-NEXT:    sh3add a0, a0, a0
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    andi sp, sp, -64
; ZBA-NEXT:    addi sp, s0, -80
; ZBA-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; ZBA-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; ZBA-NEXT:    addi sp, sp, 80
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul_8_x9:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -80
; NOMUL-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    addi s0, sp, 80
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 3
; NOMUL-NEXT:    mv a1, a0
; NOMUL-NEXT:    slli a0, a0, 3
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    andi sp, sp, -64
; NOMUL-NEXT:    addi sp, s0, -80
; NOMUL-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    addi sp, sp, 80
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul_8_x9:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    li a1, 72
; CHECK-NOZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul_8_x9:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 3
; CHECK-ZBA-VSETVLI-NEXT:    sh3add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul_8_x9:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -80
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 3
; CHECK-NOMUL-VSETVLI-NEXT:    mv a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 3
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -64
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -80
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 80
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 8 x i64>
  %v2 = alloca <vscale x 8 x i64>
  %v3 = alloca <vscale x 8 x i64>
  %v4 = alloca <vscale x 8 x i64>
  %v5 = alloca <vscale x 8 x i64>
  %v6 = alloca <vscale x 8 x i64>
  %v7 = alloca <vscale x 8 x i64>
  %v8 = alloca <vscale x 8 x i64>
  %v9 = alloca <vscale x 8 x i64>
  ret void
}

define void @lmul_16_align() nounwind {
; NOZBA-LABEL: lmul_16_align:
; NOZBA:       # %bb.0:
; NOZBA-NEXT:    addi sp, sp, -144
; NOZBA-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    sd s0, 128(sp) # 8-byte Folded Spill
; NOZBA-NEXT:    addi s0, sp, 144
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    li a1, 24
; NOZBA-NEXT:    mul a0, a0, a1
; NOZBA-NEXT:    sub sp, sp, a0
; NOZBA-NEXT:    andi sp, sp, -128
; NOZBA-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; NOZBA-NEXT:    vmv.v.i v8, 0
; NOZBA-NEXT:    csrr a0, vlenb
; NOZBA-NEXT:    add a0, sp, a0
; NOZBA-NEXT:    addi a0, a0, 128
; NOZBA-NEXT:    csrr a1, vlenb
; NOZBA-NEXT:    vs8r.v v8, (a0)
; NOZBA-NEXT:    slli a1, a1, 3
; NOZBA-NEXT:    add a0, a0, a1
; NOZBA-NEXT:    vs8r.v v8, (a0)
; NOZBA-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; NOZBA-NEXT:    vmv.v.i v8, 0
; NOZBA-NEXT:    addi a0, sp, 128
; NOZBA-NEXT:    vs1r.v v8, (a0)
; NOZBA-NEXT:    addi sp, s0, -144
; NOZBA-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    ld s0, 128(sp) # 8-byte Folded Reload
; NOZBA-NEXT:    addi sp, sp, 144
; NOZBA-NEXT:    ret
;
; ZBA-LABEL: lmul_16_align:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi sp, sp, -144
; ZBA-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; ZBA-NEXT:    sd s0, 128(sp) # 8-byte Folded Spill
; ZBA-NEXT:    addi s0, sp, 144
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    slli a0, a0, 3
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    sub sp, sp, a0
; ZBA-NEXT:    andi sp, sp, -128
; ZBA-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; ZBA-NEXT:    vmv.v.i v8, 0
; ZBA-NEXT:    csrr a0, vlenb
; ZBA-NEXT:    add a0, sp, a0
; ZBA-NEXT:    addi a0, a0, 128
; ZBA-NEXT:    csrr a1, vlenb
; ZBA-NEXT:    vs8r.v v8, (a0)
; ZBA-NEXT:    sh3add a0, a1, a0
; ZBA-NEXT:    vs8r.v v8, (a0)
; ZBA-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; ZBA-NEXT:    vmv.v.i v8, 0
; ZBA-NEXT:    addi a0, sp, 128
; ZBA-NEXT:    vs1r.v v8, (a0)
; ZBA-NEXT:    addi sp, s0, -144
; ZBA-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; ZBA-NEXT:    ld s0, 128(sp) # 8-byte Folded Reload
; ZBA-NEXT:    addi sp, sp, 144
; ZBA-NEXT:    ret
;
; NOMUL-LABEL: lmul_16_align:
; NOMUL:       # %bb.0:
; NOMUL-NEXT:    addi sp, sp, -144
; NOMUL-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    sd s0, 128(sp) # 8-byte Folded Spill
; NOMUL-NEXT:    addi s0, sp, 144
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    slli a0, a0, 3
; NOMUL-NEXT:    mv a1, a0
; NOMUL-NEXT:    slli a0, a0, 1
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    sub sp, sp, a0
; NOMUL-NEXT:    andi sp, sp, -128
; NOMUL-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; NOMUL-NEXT:    vmv.v.i v8, 0
; NOMUL-NEXT:    csrr a0, vlenb
; NOMUL-NEXT:    add a0, sp, a0
; NOMUL-NEXT:    addi a0, a0, 128
; NOMUL-NEXT:    csrr a1, vlenb
; NOMUL-NEXT:    vs8r.v v8, (a0)
; NOMUL-NEXT:    slli a1, a1, 3
; NOMUL-NEXT:    add a0, a0, a1
; NOMUL-NEXT:    vs8r.v v8, (a0)
; NOMUL-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; NOMUL-NEXT:    vmv.v.i v8, 0
; NOMUL-NEXT:    addi a0, sp, 128
; NOMUL-NEXT:    vs1r.v v8, (a0)
; NOMUL-NEXT:    addi sp, s0, -144
; NOMUL-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    ld s0, 128(sp) # 8-byte Folded Reload
; NOMUL-NEXT:    addi sp, sp, 144
; NOMUL-NEXT:    ret
;
; CHECK-NOZBA-VSETVLI-LABEL: lmul_16_align:
; CHECK-NOZBA-VSETVLI:       # %bb.0:
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, -144
; CHECK-NOZBA-VSETVLI-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    sd s0, 128(sp) # 8-byte Folded Spill
; CHECK-NOZBA-VSETVLI-NEXT:    addi s0, sp, 144
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    li a1, 24
; CHECK-NOZBA-VSETVLI-NEXT:    mul a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    andi sp, sp, -128
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    vmv.v.i v8, 0
; CHECK-NOZBA-VSETVLI-NEXT:    csrr a0, vlenb
; CHECK-NOZBA-VSETVLI-NEXT:    add a0, sp, a0
; CHECK-NOZBA-VSETVLI-NEXT:    addi a0, a0, 128
; CHECK-NOZBA-VSETVLI-NEXT:    csrr a1, vlenb
; CHECK-NOZBA-VSETVLI-NEXT:    vs8r.v v8, (a0)
; CHECK-NOZBA-VSETVLI-NEXT:    slli a1, a1, 3
; CHECK-NOZBA-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOZBA-VSETVLI-NEXT:    vs8r.v v8, (a0)
; CHECK-NOZBA-VSETVLI-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NOZBA-VSETVLI-NEXT:    vmv.v.i v8, 0
; CHECK-NOZBA-VSETVLI-NEXT:    addi a0, sp, 128
; CHECK-NOZBA-VSETVLI-NEXT:    vs1r.v v8, (a0)
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, s0, -144
; CHECK-NOZBA-VSETVLI-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    ld s0, 128(sp) # 8-byte Folded Reload
; CHECK-NOZBA-VSETVLI-NEXT:    addi sp, sp, 144
; CHECK-NOZBA-VSETVLI-NEXT:    ret
;
; CHECK-ZBA-VSETVLI-LABEL: lmul_16_align:
; CHECK-ZBA-VSETVLI:       # %bb.0:
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, -144
; CHECK-ZBA-VSETVLI-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    sd s0, 128(sp) # 8-byte Folded Spill
; CHECK-ZBA-VSETVLI-NEXT:    addi s0, sp, 144
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    slli a0, a0, 3
; CHECK-ZBA-VSETVLI-NEXT:    sh1add a0, a0, a0
; CHECK-ZBA-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    andi sp, sp, -128
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    vmv.v.i v8, 0
; CHECK-ZBA-VSETVLI-NEXT:    csrr a0, vlenb
; CHECK-ZBA-VSETVLI-NEXT:    add a0, sp, a0
; CHECK-ZBA-VSETVLI-NEXT:    addi a0, a0, 128
; CHECK-ZBA-VSETVLI-NEXT:    csrr a1, vlenb
; CHECK-ZBA-VSETVLI-NEXT:    vs8r.v v8, (a0)
; CHECK-ZBA-VSETVLI-NEXT:    sh3add a0, a1, a0
; CHECK-ZBA-VSETVLI-NEXT:    vs8r.v v8, (a0)
; CHECK-ZBA-VSETVLI-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZBA-VSETVLI-NEXT:    vmv.v.i v8, 0
; CHECK-ZBA-VSETVLI-NEXT:    addi a0, sp, 128
; CHECK-ZBA-VSETVLI-NEXT:    vs1r.v v8, (a0)
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, s0, -144
; CHECK-ZBA-VSETVLI-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    ld s0, 128(sp) # 8-byte Folded Reload
; CHECK-ZBA-VSETVLI-NEXT:    addi sp, sp, 144
; CHECK-ZBA-VSETVLI-NEXT:    ret
;
; CHECK-NOMUL-VSETVLI-LABEL: lmul_16_align:
; CHECK-NOMUL-VSETVLI:       # %bb.0:
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, -144
; CHECK-NOMUL-VSETVLI-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    sd s0, 128(sp) # 8-byte Folded Spill
; CHECK-NOMUL-VSETVLI-NEXT:    addi s0, sp, 144
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 3
; CHECK-NOMUL-VSETVLI-NEXT:    mv a1, a0
; CHECK-NOMUL-VSETVLI-NEXT:    slli a0, a0, 1
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    sub sp, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    andi sp, sp, -128
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    vmv.v.i v8, 0
; CHECK-NOMUL-VSETVLI-NEXT:    csrr a0, vlenb
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, sp, a0
; CHECK-NOMUL-VSETVLI-NEXT:    addi a0, a0, 128
; CHECK-NOMUL-VSETVLI-NEXT:    csrr a1, vlenb
; CHECK-NOMUL-VSETVLI-NEXT:    vs8r.v v8, (a0)
; CHECK-NOMUL-VSETVLI-NEXT:    slli a1, a1, 3
; CHECK-NOMUL-VSETVLI-NEXT:    add a0, a0, a1
; CHECK-NOMUL-VSETVLI-NEXT:    vs8r.v v8, (a0)
; CHECK-NOMUL-VSETVLI-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NOMUL-VSETVLI-NEXT:    vmv.v.i v8, 0
; CHECK-NOMUL-VSETVLI-NEXT:    addi a0, sp, 128
; CHECK-NOMUL-VSETVLI-NEXT:    vs1r.v v8, (a0)
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, s0, -144
; CHECK-NOMUL-VSETVLI-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    ld s0, 128(sp) # 8-byte Folded Reload
; CHECK-NOMUL-VSETVLI-NEXT:    addi sp, sp, 144
; CHECK-NOMUL-VSETVLI-NEXT:    ret
  %v1 = alloca <vscale x 16 x i64>
  %v2 = alloca <vscale x 1 x i64>
  store <vscale x 16 x i64> zeroinitializer, ptr %v1
  store <vscale x 1 x i64> zeroinitializer, ptr %v2
  ret void
}
