; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt  -passes="print<cost-model>" 2>&1 -disable-output -mtriple=aarch64--linux-gnu -mattr=+sve < %s | FileCheck %s

; Checks if widening instructions works for SVE

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define <vscale x 4 x i32> @widening_nxv4i16(<vscale x 4 x i16> %in1, <vscale x 4 x i16> %in2) {
; CHECK-LABEL: 'widening_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %in1.ext = zext <vscale x 4 x i16> %in2 to <vscale x 4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %in2.ext = zext <vscale x 4 x i16> %in2 to <vscale x 4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %in.add = add <vscale x 4 x i32> %in1.ext, %in2.ext
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <vscale x 4 x i32> %in.add
;
  %in1.ext = zext <vscale x 4 x i16> %in2 to <vscale x 4 x i32>
  %in2.ext = zext <vscale x 4 x i16> %in2 to <vscale x 4 x i32>
  %in.add = add <vscale x 4 x i32> %in1.ext, %in2.ext
  ret <vscale x 4 x i32> %in.add
}

define <vscale x 8 x i32> @widening_nxv8i16(<vscale x 8 x i16> %in1, <vscale x 8 x i16> %in2) {
; CHECK-LABEL: 'widening_nxv8i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %in1.ext = zext <vscale x 8 x i16> %in2 to <vscale x 8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %in2.ext = zext <vscale x 8 x i16> %in2 to <vscale x 8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %in.add = add <vscale x 8 x i32> %in1.ext, %in2.ext
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <vscale x 8 x i32> %in.add
;
  %in1.ext = zext <vscale x 8 x i16> %in2 to <vscale x 8 x i32>
  %in2.ext = zext <vscale x 8 x i16> %in2 to <vscale x 8 x i32>
  %in.add = add <vscale x 8 x i32> %in1.ext, %in2.ext
  ret <vscale x 8 x i32> %in.add
}

define <8 x i32> @widening_v8i16_svevl2(<8 x i16> %in1, <8 x i16> %in2) vscale_range(2,16) {
; CHECK-LABEL: 'widening_v8i16_svevl2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %in1.ext = zext <8 x i16> %in2 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %in2.ext = zext <8 x i16> %in2 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %in.add = add <8 x i32> %in1.ext, %in2.ext
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <8 x i32> %in.add
;
  %in1.ext = zext <8 x i16> %in2 to <8 x i32>
  %in2.ext = zext <8 x i16> %in2 to <8 x i32>
  %in.add = add <8 x i32> %in1.ext, %in2.ext
  ret <8 x i32> %in.add
}

