; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -O0 | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "i686-unknown-linux-gnu"

@glbl = extern_weak constant i8

declare i64 @llvm.expect.i64(i64, i64)
declare i64 @llvm.expect.with.probability.i64(i64, i64, double)

define void @test_expect() {
; CHECK-LABEL: test_expect:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl $glbl, %eax
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    jne .LBB0_2
; CHECK-NEXT:    jmp .LBB0_1
; CHECK-NEXT:  .LBB0_1: # %bb1
; CHECK-NEXT:  .LBB0_2: # %bb2
  %cmp2 = icmp eq ptr @glbl, null
  %ext = zext i1 %cmp2 to i64
  %tmp = call i64 @llvm.expect.i64(i64 %ext, i64 0)
  %tmp2 = icmp ne i64 %tmp, 0
  br i1 %tmp2, label %bb1, label %bb2

bb1:
  unreachable

bb2:
  unreachable
}

define void @test_expect_with_probability() {
; CHECK-LABEL: test_expect_with_probability:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl $glbl, %eax
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    jne .LBB1_2
; CHECK-NEXT:    jmp .LBB1_1
; CHECK-NEXT:  .LBB1_1: # %bb1
; CHECK-NEXT:  .LBB1_2: # %bb2
  %cmp2 = icmp eq ptr @glbl, null
  %ext = zext i1 %cmp2 to i64
  %tmp = call i64 @llvm.expect.with.probability.i64(i64 %ext, i64 0, double 0.5)
  %tmp2 = icmp ne i64 %tmp, 0
  br i1 %tmp2, label %bb1, label %bb2

bb1:
  unreachable

bb2:
  unreachable
}
