; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=amdgcn-- -S -amdgpu-rewrite-undef-for-phi %s | FileCheck -check-prefix=OPT %s
; RUN: opt -mtriple=amdgcn-- -S -passes=amdgpu-rewrite-undef-for-phi %s | FileCheck -check-prefix=OPT %s

define amdgpu_ps float @basic(float inreg %c, i32 %x) #0 {
; OPT-LABEL: @basic(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[CC:%.*]] = icmp slt i32 [[X:%.*]], 0
; OPT-NEXT:    br i1 [[CC]], label [[IF:%.*]], label [[END:%.*]]
; OPT:       if:
; OPT-NEXT:    br label [[END]]
; OPT:       end:
; OPT-NEXT:    ret float [[C:%.*]]
;
entry:
  %cc = icmp slt i32 %x, 0
  br i1 %cc, label %if, label %end

if:
  br label %end

end:
  %c2 = phi float [ undef, %if ], [ %c, %entry ]
  ret float %c2
}

define amdgpu_ps float @with_uniform_region_inside(float inreg %c, i32 inreg %d, i32 %x) #0 {
; OPT-LABEL: @with_uniform_region_inside(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[CC:%.*]] = icmp slt i32 [[X:%.*]], 0
; OPT-NEXT:    br i1 [[CC]], label [[IF:%.*]], label [[END:%.*]]
; OPT:       if:
; OPT-NEXT:    [[CC2:%.*]] = icmp slt i32 [[D:%.*]], 0
; OPT-NEXT:    br i1 [[CC2]], label [[BB2:%.*]], label [[BB3:%.*]]
; OPT:       bb2:
; OPT-NEXT:    br label [[END]]
; OPT:       bb3:
; OPT-NEXT:    [[CC3:%.*]] = icmp slt i32 [[D]], 2
; OPT-NEXT:    br i1 [[CC3]], label [[BB4:%.*]], label [[END]]
; OPT:       bb4:
; OPT-NEXT:    br label [[END]]
; OPT:       end:
; OPT-NEXT:    ret float [[C:%.*]]
;
entry:
  %cc = icmp slt i32 %x, 0
  br i1 %cc, label %if, label %end

if:
  %cc2 = icmp slt i32 %d, 0
  br i1 %cc2, label %bb2, label %bb3

bb2:
  br label %end

bb3:
  %cc3 = icmp slt i32 %d, 2
  br i1 %cc3, label %bb4, label %end

bb4:
  br label %end

end:
  %c2 = phi float [ undef, %bb2 ], [ %c, %bb3 ], [ undef, %bb4 ], [ %c, %entry ]
  ret float %c2
}

define amdgpu_ps float @exclude_backedge(float inreg %c, i32 %x) #0 {
; OPT-LABEL: @exclude_backedge(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[CC:%.*]] = icmp slt i32 [[X:%.*]], 0
; OPT-NEXT:    br i1 [[CC]], label [[END:%.*]], label [[LOOP:%.*]]
; OPT:       loop:
; OPT-NEXT:    [[IND:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[LOOP]] ]
; OPT-NEXT:    [[C2:%.*]] = phi float [ [[C:%.*]], [[ENTRY]] ], [ undef, [[LOOP]] ]
; OPT-NEXT:    [[INC]] = add i32 [[IND]], 1
; OPT-NEXT:    [[LOOP_CC:%.*]] = icmp slt i32 [[INC]], 5
; OPT-NEXT:    br i1 [[LOOP_CC]], label [[LOOP]], label [[LOOP_END:%.*]]
; OPT:       loop_end:
; OPT-NEXT:    br label [[END]]
; OPT:       end:
; OPT-NEXT:    [[R:%.*]] = phi float [ [[C2]], [[LOOP_END]] ], [ [[C]], [[ENTRY]] ]
; OPT-NEXT:    ret float [[R]]
;
entry:
  %cc = icmp slt i32 %x, 0
  br i1 %cc, label %end, label %loop

loop:
  %ind = phi i32 [ 0, %entry ], [ %inc, %loop ]
  %c2 = phi float [ %c, %entry ], [ undef, %loop ]
  %inc = add i32 %ind, 1
  %loop_cc = icmp slt i32 %inc, 5
  br i1 %loop_cc, label %loop, label %loop_end

loop_end:
  br label %end

end:
  %r = phi float [ %c2, %loop_end ], [ %c, %entry ]
  ret float %r
}

attributes #0 = { nounwind noinline }
