//===-- AArch64PerfectShuffle.h - AdvSIMD Perfect Shuffle Table -----------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This file, which was autogenerated by llvm-PerfectShuffle, contains data
// for the optimal way to build a perfect shuffle using AdvSIMD instructions.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_AARCH64_AARCH64PERFECTSHUFFLE_H
#define LLVM_LIB_TARGET_AARCH64_AARCH64PERFECTSHUFFLE_H

#include "llvm/ADT/ArrayRef.h"

namespace llvm {

// 31 entries have cost 0
// 756 entries have cost 1
// 3690 entries have cost 2
// 2084 entries have cost 3

// This table is 6561*4 = 26244 bytes in size.
static const unsigned PerfectShuffleTable[6561 + 1] = {
    135053414U,  // <0,0,0,0>: Cost 1 vdup0 LHS
    2080972802U, // <0,0,0,1>: Cost 2 ins <0,0,u,1>, lane 2
    1679065190U, // <0,0,0,2>: Cost 2 vuzpl <0,2,0,2>, LHS
    2085707777U, // <0,0,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    1476398390U, // <0,0,0,4>: Cost 2 vext1 <0,0,0,0>, RHS
    2080440323U, // <0,0,0,5>: Cost 2 ins <0,0,0,u>, lane 3
    2080440323U, // <0,0,0,6>: Cost 2 ins <0,0,0,u>, lane 3
    2080440323U, // <0,0,0,7>: Cost 2 ins <0,0,0,u>, lane 3
    135053414U,  // <0,0,0,u>: Cost 1 vdup0 LHS
    1812774912U, // <0,0,1,0>: Cost 2 vzipl LHS, <0,0,0,0>
    739033190U,  // <0,0,1,1>: Cost 1 vzipl LHS, LHS
    1812775076U, // <0,0,1,2>: Cost 2 vzipl LHS, <0,2,0,2>
    2080514051U, // <0,0,1,3>: Cost 2 ins <0,0,1,u>, lane 3
    1812816210U, // <0,0,1,4>: Cost 2 vzipl LHS, <0,4,1,5>
    2085797889U, // <0,0,1,5>: Cost 2 ins <0,u,1,5>, lane 1
    2080514051U, // <0,0,1,6>: Cost 2 ins <0,0,1,u>, lane 3
    2080514051U, // <0,0,1,7>: Cost 2 ins <0,0,1,u>, lane 3
    739033757U,  // <0,0,1,u>: Cost 1 vzipl LHS, LHS
    1946992640U, // <0,0,2,0>: Cost 2 vtrnl LHS, <0,0,0,0>
    1946992650U, // <0,0,2,1>: Cost 2 vtrnl LHS, <0,0,1,1>
    873250918U,  // <0,0,2,2>: Cost 1 vtrnl LHS, LHS
    1012113409U, // <0,0,2,3>: Cost 1 ins LHS, lane 1
    1946992844U, // <0,0,2,4>: Cost 2 vtrnl LHS, <0,2,4,6>
    2080587779U, // <0,0,2,5>: Cost 2 ins <0,0,2,u>, lane 3
    2085879809U, // <0,0,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    2080587779U, // <0,0,2,7>: Cost 2 ins <0,0,2,u>, lane 3
    873250972U,  // <0,0,2,u>: Cost 1 vtrnl LHS, LHS
    2080964610U, // <0,0,3,0>: Cost 2 ins <0,0,u,0>, lane 2
    2080972802U, // <0,0,3,1>: Cost 2 ins <0,0,u,1>, lane 2
    2128388096U, // <0,0,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    2013437973U, // <0,0,3,3>: Cost 2 vtrnr <0,0,2,3>, <0,0,2,3>
    3154739202U, // <0,0,3,4>: Cost 3 ins <0,0,u,4>, lane 2
    2752809474U, // <0,0,3,5>: Cost 3 vuzpl <0,2,0,2>, <3,4,5,6>
    3154755586U, // <0,0,3,6>: Cost 3 ins <0,0,u,6>, lane 2
    2818573312U, // <0,0,3,7>: Cost 3 vuzpr <0,0,0,0>, <1,3,5,7>
    2080972802U, // <0,0,3,u>: Cost 2 ins <0,0,u,1>, lane 2
    2080964610U, // <0,0,4,0>: Cost 2 ins <0,0,u,0>, lane 2
    1814708326U, // <0,0,4,1>: Cost 2 vzipl <0,4,1,5>, LHS
    1947828326U, // <0,0,4,2>: Cost 2 vtrnl <0,2,4,6>, LHS
    2086002689U, // <0,0,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    1947828428U, // <0,0,4,4>: Cost 2 vtrnl <0,2,4,6>, <0,2,4,6>
    2081030149U, // <0,0,4,5>: Cost 2 ins <0,0,u,u>, lane 5
    1679068470U, // <0,0,4,6>: Cost 2 vuzpl <0,2,0,2>, RHS
    3154477059U, // <0,0,4,7>: Cost 3 ins <0,0,4,u>, lane 3
    1679068488U, // <0,0,4,u>: Cost 2 vuzpl <0,2,0,2>, RHS
    2080964610U, // <0,0,5,0>: Cost 2 ins <0,0,u,0>, lane 2
    2128527360U, // <0,0,5,1>: Cost 2 ins <u,0,5,1>, lane 0
    2080980994U, // <0,0,5,2>: Cost 2 ins <0,0,u,2>, lane 2
    2086076417U, // <0,0,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    3202293760U, // <0,0,5,4>: Cost 3 ins <u,0,5,4>, lane 0
    1947213953U, // <0,0,5,5>: Cost 2 vtrnl <0,1,5,3>, <0,1,5,3>
    2718712274U, // <0,0,5,6>: Cost 3 vext3 <5,6,7,0>, <0,5,6,7>
    1744833846U, // <0,0,5,7>: Cost 2 vuzpr <0,0,0,0>, RHS
    2128527360U, // <0,0,5,u>: Cost 2 ins <u,0,5,1>, lane 0
    2080964610U, // <0,0,6,0>: Cost 2 ins <0,0,u,0>, lane 2
    2080972802U, // <0,0,6,1>: Cost 2 ins <0,0,u,1>, lane 2
    2128609280U, // <0,0,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    2086150145U, // <0,0,6,3>: Cost 2 ins <0,u,6,3>, lane 1
    3202367488U, // <0,0,6,4>: Cost 3 ins <u,0,6,4>, lane 0
    2617250536U, // <0,0,6,5>: Cost 3 vext2 <0,0,0,0>, <6,5,6,7>
    1947287690U, // <0,0,6,6>: Cost 2 vtrnl <0,1,6,3>, <0,1,6,3>
    2081030149U, // <0,0,6,7>: Cost 2 ins <0,0,u,u>, lane 5
    2080972802U, // <0,0,6,u>: Cost 2 ins <0,0,u,1>, lane 2
    2080964610U, // <0,0,7,0>: Cost 2 ins <0,0,u,0>, lane 2
    2080972802U, // <0,0,7,1>: Cost 2 ins <0,0,u,1>, lane 2
    2080980994U, // <0,0,7,2>: Cost 2 ins <0,0,u,2>, lane 2
    2086223873U, // <0,0,7,3>: Cost 2 ins <0,u,7,3>, lane 1
    3154739202U, // <0,0,7,4>: Cost 3 ins <0,0,u,4>, lane 2
    2617251265U, // <0,0,7,5>: Cost 3 vext2 <0,0,0,0>, <7,5,6,7>
    3154755586U, // <0,0,7,6>: Cost 3 ins <0,0,u,6>, lane 2
    1947361427U, // <0,0,7,7>: Cost 2 vtrnl <0,1,7,3>, <0,1,7,3>
    2080972802U, // <0,0,7,u>: Cost 2 ins <0,0,u,1>, lane 2
    135053414U,  // <0,0,u,0>: Cost 1 vdup0 LHS
    743678054U,  // <0,0,u,1>: Cost 1 vzipl LHS, LHS
    873693286U,  // <0,0,u,2>: Cost 1 vtrnl LHS, LHS
    1012113409U, // <0,0,u,3>: Cost 1 ins LHS, lane 1
    1947435212U, // <0,0,u,4>: Cost 2 vtrnl LHS, <0,2,4,6>
    2085797889U, // <0,0,u,5>: Cost 2 ins <0,u,1,5>, lane 1
    1679071386U, // <0,0,u,6>: Cost 2 vuzpl <0,2,0,2>, RHS
    2080514051U, // <0,0,u,7>: Cost 2 ins <0,0,1,u>, lane 3
    873693340U,  // <0,0,u,u>: Cost 1 vtrnl LHS, LHS
    2085683201U, // <0,1,0,0>: Cost 2 ins <0,u,0,0>, lane 1
    1007951877U, // <0,1,0,1>: Cost 1 ins LHS, lane 5
    1680490598U, // <0,1,0,2>: Cost 2 vuzpl <0,4,1,5>, LHS
    1007910914U, // <0,1,0,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <0,1,0,4>: Cost 2 ins <0,1,u,4>, lane 2
    2081669122U, // <0,1,0,5>: Cost 2 ins <0,1,u,5>, lane 2
    2081677314U, // <0,1,0,6>: Cost 2 ins <0,1,u,6>, lane 2
    2081685506U, // <0,1,0,7>: Cost 2 ins <0,1,u,7>, lane 2
    1007951877U, // <0,1,0,u>: Cost 1 ins LHS, lane 5
    1812775670U, // <0,1,1,0>: Cost 2 vzipl LHS, <1,0,3,2>
    1812775732U, // <0,1,1,1>: Cost 2 vzipl LHS, <1,1,1,1>
    1812775830U, // <0,1,1,2>: Cost 2 vzipl LHS, <1,2,3,0>
    1007910914U, // <0,1,1,3>: Cost 1 ins LHS, lane 2
    1476480310U, // <0,1,1,4>: Cost 2 vext1 <0,0,1,1>, RHS
    1812817040U, // <0,1,1,5>: Cost 2 vzipl LHS, <1,5,3,7>
    2081677314U, // <0,1,1,6>: Cost 2 ins <0,1,u,6>, lane 2
    2081685506U, // <0,1,1,7>: Cost 2 ins <0,1,u,7>, lane 2
    1007910914U, // <0,1,1,u>: Cost 1 ins LHS, lane 2
    1007509507U, // <0,1,2,0>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,2,1>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,2,2>: Cost 1 ins LHS, lane 3
    835584U,     // <0,1,2,3>: Cost 0 copy LHS
    1007509507U, // <0,1,2,4>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,2,5>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,2,6>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,2,7>: Cost 1 ins LHS, lane 3
    835584U,     // <0,1,2,u>: Cost 0 copy LHS
    2133680132U, // <0,1,3,0>: Cost 2 ins <u,u,3,0>, lane 4
    2081636354U, // <0,1,3,1>: Cost 2 ins <0,1,u,1>, lane 2
    2133696516U, // <0,1,3,2>: Cost 2 ins <u,u,3,2>, lane 4
    1007910914U, // <0,1,3,3>: Cost 1 ins LHS, lane 2
    2133712900U, // <0,1,3,4>: Cost 2 ins <u,u,3,4>, lane 4
    2081669122U, // <0,1,3,5>: Cost 2 ins <0,1,u,5>, lane 2
    2081677314U, // <0,1,3,6>: Cost 2 ins <0,1,u,6>, lane 2
    2133737476U, // <0,1,3,7>: Cost 2 ins <u,u,3,7>, lane 4
    1007910914U, // <0,1,3,u>: Cost 1 ins LHS, lane 2
    2081628162U, // <0,1,4,0>: Cost 2 ins <0,1,u,0>, lane 2
    2081636354U, // <0,1,4,1>: Cost 2 ins <0,1,u,1>, lane 2
    2081644546U, // <0,1,4,2>: Cost 2 ins <0,1,u,2>, lane 2
    1007910914U, // <0,1,4,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <0,1,4,4>: Cost 2 ins <0,1,u,4>, lane 2
    1007951877U, // <0,1,4,5>: Cost 1 ins LHS, lane 5
    1680493878U, // <0,1,4,6>: Cost 2 vuzpl <0,4,1,5>, RHS
    2081685506U, // <0,1,4,7>: Cost 2 ins <0,1,u,7>, lane 2
    1007910914U, // <0,1,4,u>: Cost 1 ins LHS, lane 2
    2081628162U, // <0,1,5,0>: Cost 2 ins <0,1,u,0>, lane 2
    2133835780U, // <0,1,5,1>: Cost 2 ins <u,u,5,1>, lane 4
    2081644546U, // <0,1,5,2>: Cost 2 ins <0,1,u,2>, lane 2
    1007910914U, // <0,1,5,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <0,1,5,4>: Cost 2 ins <0,1,u,4>, lane 2
    2133868548U, // <0,1,5,5>: Cost 2 ins <u,u,5,5>, lane 4
    2133876740U, // <0,1,5,6>: Cost 2 ins <u,u,5,6>, lane 4
    2133884932U, // <0,1,5,7>: Cost 2 ins <u,u,5,7>, lane 4
    1007910914U, // <0,1,5,u>: Cost 1 ins LHS, lane 2
    2081628162U, // <0,1,6,0>: Cost 2 ins <0,1,u,0>, lane 2
    2081636354U, // <0,1,6,1>: Cost 2 ins <0,1,u,1>, lane 2
    2133917700U, // <0,1,6,2>: Cost 2 ins <u,u,6,2>, lane 4
    1007910914U, // <0,1,6,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <0,1,6,4>: Cost 2 ins <0,1,u,4>, lane 2
    2081669122U, // <0,1,6,5>: Cost 2 ins <0,1,u,5>, lane 2
    2133950468U, // <0,1,6,6>: Cost 2 ins <u,u,6,6>, lane 4
    1060216836U, // <0,1,6,7>: Cost 1 ins RHS, lane 4
    1007910914U, // <0,1,6,u>: Cost 1 ins LHS, lane 2
    2133975044U, // <0,1,7,0>: Cost 2 ins <u,u,7,0>, lane 4
    2081636354U, // <0,1,7,1>: Cost 2 ins <0,1,u,1>, lane 2
    2081644546U, // <0,1,7,2>: Cost 2 ins <0,1,u,2>, lane 2
    1007910914U, // <0,1,7,3>: Cost 1 ins LHS, lane 2
    2134007812U, // <0,1,7,4>: Cost 2 ins <u,u,7,4>, lane 4
    2081669122U, // <0,1,7,5>: Cost 2 ins <0,1,u,5>, lane 2
    2134024196U, // <0,1,7,6>: Cost 2 ins <u,u,7,6>, lane 4
    2134032388U, // <0,1,7,7>: Cost 2 ins <u,u,7,7>, lane 4
    1007910914U, // <0,1,7,u>: Cost 1 ins LHS, lane 2
    1007509507U, // <0,1,u,0>: Cost 1 ins LHS, lane 3
    1007951877U, // <0,1,u,1>: Cost 1 ins LHS, lane 5
    1007509507U, // <0,1,u,2>: Cost 1 ins LHS, lane 3
    835584U,     // <0,1,u,3>: Cost 0 copy LHS
    1007509507U, // <0,1,u,4>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,u,5>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,u,6>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,1,u,7>: Cost 1 ins LHS, lane 3
    835584U,     // <0,1,u,u>: Cost 0 copy LHS
    1678557184U, // <0,2,0,0>: Cost 2 vuzpl LHS, <0,0,0,0>
    1678598154U, // <0,2,0,1>: Cost 2 vuzpl LHS, <0,0,1,1>
    604815462U,  // <0,2,0,2>: Cost 1 vuzpl LHS, LHS
    2081767427U, // <0,2,0,3>: Cost 2 ins <0,2,0,u>, lane 3
    1678598348U, // <0,2,0,4>: Cost 2 vuzpl LHS, <0,2,4,6>
    2081767427U, // <0,2,0,5>: Cost 2 ins <0,2,0,u>, lane 3
    2082340866U, // <0,2,0,6>: Cost 2 ins <0,2,u,6>, lane 2
    2081767427U, // <0,2,0,7>: Cost 2 ins <0,2,0,u>, lane 3
    604815516U,  // <0,2,0,u>: Cost 1 vuzpl LHS, LHS
    2752340940U, // <0,2,1,0>: Cost 3 vuzpl LHS, <1,3,0,0>
    1678558004U, // <0,2,1,1>: Cost 2 vuzpl LHS, <1,1,1,1>
    1812776552U, // <0,2,1,2>: Cost 2 vzipl LHS, <2,2,2,2>
    1678557942U, // <0,2,1,3>: Cost 2 vuzpl LHS, <1,0,3,2>
    2752340982U, // <0,2,1,4>: Cost 3 vuzpl LHS, <1,3,4,6>
    1678599168U, // <0,2,1,5>: Cost 2 vuzpl LHS, <1,3,5,7>
    1812817850U, // <0,2,1,6>: Cost 2 vzipl LHS, <2,6,3,7>
    2860466282U, // <0,2,1,7>: Cost 3 vuzpr <7,0,1,2>, <0,1,2,7>
    1678598947U, // <0,2,1,u>: Cost 2 vuzpl LHS, <1,0,u,2>
    1678558886U, // <0,2,2,0>: Cost 2 vuzpl LHS, <2,3,0,1>
    2085838849U, // <0,2,2,1>: Cost 2 ins <0,u,2,1>, lane 1
    1678558824U, // <0,2,2,2>: Cost 2 vuzpl LHS, <2,2,2,2>
    1012113409U, // <0,2,2,3>: Cost 1 ins LHS, lane 1
    1678558926U, // <0,2,2,4>: Cost 2 vuzpl LHS, <2,3,4,5>
    2085871617U, // <0,2,2,5>: Cost 2 ins <0,u,2,5>, lane 1
    2085879809U, // <0,2,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    2085888001U, // <0,2,2,7>: Cost 2 ins <0,u,2,7>, lane 1
    1012113409U, // <0,2,2,u>: Cost 1 ins LHS, lane 1
    2129698816U, // <0,2,3,0>: Cost 2 ins <u,2,3,0>, lane 0
    1678559382U, // <0,2,3,1>: Cost 2 vuzpl LHS, <3,0,1,2>
    2082308098U, // <0,2,3,2>: Cost 2 ins <0,2,u,2>, lane 2
    1678559644U, // <0,2,3,3>: Cost 2 vuzpl LHS, <3,3,3,3>
    2129731584U, // <0,2,3,4>: Cost 2 ins <u,2,3,4>, lane 0
    1678559746U, // <0,2,3,5>: Cost 2 vuzpl LHS, <3,4,5,6>
    2082340866U, // <0,2,3,6>: Cost 2 ins <0,2,u,6>, lane 2
    2824782848U, // <0,2,3,7>: Cost 3 vuzpr <1,0,3,2>, <1,3,5,7>
    1678559445U, // <0,2,3,u>: Cost 2 vuzpl LHS, <3,0,u,2>
    2082062339U, // <0,2,4,0>: Cost 2 ins <0,2,4,u>, lane 3
    2082062339U, // <0,2,4,1>: Cost 2 ins <0,2,4,u>, lane 3
    2082308098U, // <0,2,4,2>: Cost 2 ins <0,2,u,2>, lane 2
    2082062339U, // <0,2,4,3>: Cost 2 ins <0,2,4,u>, lane 3
    2082062339U, // <0,2,4,4>: Cost 2 ins <0,2,4,u>, lane 3
    1544850742U, // <0,2,4,5>: Cost 2 vext2 <0,2,0,2>, RHS
    604818742U,  // <0,2,4,6>: Cost 1 vuzpl LHS, RHS
    2082062339U, // <0,2,4,7>: Cost 2 ins <0,2,4,u>, lane 3
    604818760U,  // <0,2,4,u>: Cost 1 vuzpl LHS, RHS
    3105260438U, // <0,2,5,0>: Cost 3 vtrnr <3,0,4,5>, <1,2,3,0>
    1678561408U, // <0,2,5,1>: Cost 2 vuzpl LHS, <5,7,1,3>
    2082308098U, // <0,2,5,2>: Cost 2 ins <0,2,u,2>, lane 2
    2086076417U, // <0,2,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    2756947554U, // <0,2,5,4>: Cost 3 vuzpl LHS, <5,0,4,1>
    1678561284U, // <0,2,5,5>: Cost 2 vuzpl LHS, <5,5,5,5>
    2082340866U, // <0,2,5,6>: Cost 2 ins <0,2,u,6>, lane 2
    1751043382U, // <0,2,5,7>: Cost 2 vuzpr <1,0,3,2>, RHS
    1751043383U, // <0,2,5,u>: Cost 2 vuzpr <1,0,3,2>, RHS
    1678562126U, // <0,2,6,0>: Cost 2 vuzpl LHS, <6,7,0,1>
    2756948257U, // <0,2,6,1>: Cost 3 vuzpl LHS, <6,0,1,2>
    2082308098U, // <0,2,6,2>: Cost 2 ins <0,2,u,2>, lane 2
    2086150145U, // <0,2,6,3>: Cost 2 ins <0,u,6,3>, lane 1
    1678562166U, // <0,2,6,4>: Cost 2 vuzpl LHS, <6,7,4,5>
    2756948621U, // <0,2,6,5>: Cost 3 vuzpl LHS, <6,4,5,6>
    2082340866U, // <0,2,6,6>: Cost 2 ins <0,2,u,6>, lane 2
    2082357253U, // <0,2,6,7>: Cost 2 ins <0,2,u,u>, lane 5
    2082308098U, // <0,2,6,u>: Cost 2 ins <0,2,u,2>, lane 2
    3099378582U, // <0,2,7,0>: Cost 3 vtrnr <2,0,5,7>, <1,2,3,0>
    1678562298U, // <0,2,7,1>: Cost 2 vuzpl LHS, <7,0,1,2>
    2082308098U, // <0,2,7,2>: Cost 2 ins <0,2,u,2>, lane 2
    2130018304U, // <0,2,7,3>: Cost 2 ins <u,2,7,3>, lane 0
    2645136742U, // <0,2,7,4>: Cost 3 vext2 <4,6,0,2>, <7,4,5,6>
    1678562662U, // <0,2,7,5>: Cost 2 vuzpl LHS, <7,4,5,6>
    2082340866U, // <0,2,7,6>: Cost 2 ins <0,2,u,6>, lane 2
    1678562924U, // <0,2,7,7>: Cost 2 vuzpl LHS, <7,7,7,7>
    2082308098U, // <0,2,7,u>: Cost 2 ins <0,2,u,2>, lane 2
    1947436710U, // <0,2,u,0>: Cost 2 vtrnl LHS, <2,3,0,1>
    1678603987U, // <0,2,u,1>: Cost 2 vuzpl LHS, <u,0,1,2>
    604821294U,  // <0,2,u,2>: Cost 1 vuzpl LHS, LHS
    1012113409U, // <0,2,u,3>: Cost 1 ins LHS, lane 1
    1947436750U, // <0,2,u,4>: Cost 2 vtrnl LHS, <2,3,4,5>
    1678604351U, // <0,2,u,5>: Cost 2 vuzpl LHS, <u,4,5,6>
    604821658U,  // <0,2,u,6>: Cost 1 vuzpl LHS, RHS
    1751043625U, // <0,2,u,7>: Cost 2 vuzpr <1,0,3,2>, RHS
    604821348U,  // <0,2,u,u>: Cost 1 vuzpl LHS, LHS
    2085683201U, // <0,3,0,0>: Cost 2 ins <0,u,0,0>, lane 1
    2130149376U, // <0,3,0,1>: Cost 2 ins <u,3,0,1>, lane 0
    2085699585U, // <0,3,0,2>: Cost 2 ins <0,u,0,2>, lane 1
    1745002517U, // <0,3,0,3>: Cost 2 vuzpr <0,0,2,3>, <0,0,2,3>
    2556333366U, // <0,3,0,4>: Cost 3 vext1 <1,0,3,0>, RHS
    3021244930U, // <0,3,0,5>: Cost 3 vtrnl <0,2,0,2>, <3,4,5,6>
    3159474177U, // <0,3,0,6>: Cost 3 ins <0,u,0,6>, lane 1
    2952791184U, // <0,3,0,7>: Cost 3 vzipr <0,0,0,0>, <1,5,3,7>
    2130149376U, // <0,3,0,u>: Cost 2 ins <u,3,0,1>, lane 0
    1812777110U, // <0,3,1,0>: Cost 2 vzipl LHS, <3,0,1,2>
    2085765121U, // <0,3,1,1>: Cost 2 ins <0,u,1,1>, lane 1
    2886519105U, // <0,3,1,2>: Cost 3 vzipl LHS, <3,2,2,2>
    1812777372U, // <0,3,1,3>: Cost 2 vzipl LHS, <3,3,3,3>
    1812777474U, // <0,3,1,4>: Cost 2 vzipl LHS, <3,4,5,6>
    2085797889U, // <0,3,1,5>: Cost 2 ins <0,u,1,5>, lane 1
    3159547905U, // <0,3,1,6>: Cost 3 ins <0,u,1,6>, lane 1
    2966733968U, // <0,3,1,7>: Cost 3 vzipr <2,3,0,1>, <1,5,3,7>
    1812777758U, // <0,3,1,u>: Cost 2 vzipl LHS, <3,u,1,2>
    1482604646U, // <0,3,2,0>: Cost 2 vext1 <1,0,3,2>, LHS
    1946994838U, // <0,3,2,1>: Cost 2 vtrnl LHS, <3,0,1,2>
    2085847041U, // <0,3,2,2>: Cost 2 ins <0,u,2,2>, lane 1
    1012113409U, // <0,3,2,3>: Cost 1 ins LHS, lane 1
    1482607926U, // <0,3,2,4>: Cost 2 vext1 <1,0,3,2>, RHS
    1946995202U, // <0,3,2,5>: Cost 2 vtrnl LHS, <3,4,5,6>
    2085879809U, // <0,3,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    2085888001U, // <0,3,2,7>: Cost 2 ins <0,u,2,7>, lane 1
    1012113409U, // <0,3,2,u>: Cost 1 ins LHS, lane 1
    2887747734U, // <0,3,3,0>: Cost 3 vzipl <0,3,1,0>, <3,0,1,2>
    2753022102U, // <0,3,3,1>: Cost 3 vuzpl <0,2,3,1>, <3,0,1,2>
    2965422838U, // <0,3,3,2>: Cost 3 vzipr <2,1,0,3>, <1,0,3,2>
    2130386944U, // <0,3,3,3>: Cost 2 ins <u,3,3,3>, lane 0
    2887780866U, // <0,3,3,4>: Cost 3 vzipl <0,3,1,4>, <3,4,5,6>
    2753055234U, // <0,3,3,5>: Cost 3 vuzpl <0,2,3,5>, <3,4,5,6>
    2752375389U, // <0,3,3,6>: Cost 3 vuzpl <0,1,3,3>, <3,5,6,7>
    3204161536U, // <0,3,3,7>: Cost 3 ins <u,3,3,7>, lane 0
    2130386944U, // <0,3,3,u>: Cost 2 ins <u,3,3,3>, lane 0
    2888452246U, // <0,3,4,0>: Cost 3 vzipl <0,4,1,5>, <3,0,1,2>
    3021572246U, // <0,3,4,1>: Cost 3 vtrnl <0,2,4,6>, <3,0,1,2>
    3021572257U, // <0,3,4,2>: Cost 3 vtrnl <0,2,4,6>, <3,0,2,4>
    2086002689U, // <0,3,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    2888452610U, // <0,3,4,4>: Cost 3 vzipl <0,4,1,5>, <3,4,5,6>
    2130477056U, // <0,3,4,5>: Cost 2 ins <u,3,4,5>, lane 0
    2086027265U, // <0,3,4,6>: Cost 2 ins <0,u,4,6>, lane 1
    2818747621U, // <0,3,4,7>: Cost 3 vuzpr <0,0,2,3>, <4,4,6,7>
    2130477056U, // <0,3,4,u>: Cost 2 ins <u,3,4,5>, lane 0
    3204251648U, // <0,3,5,0>: Cost 3 ins <u,3,5,0>, lane 0
    3204259840U, // <0,3,5,1>: Cost 3 ins <u,3,5,1>, lane 0
    2961457910U, // <0,3,5,2>: Cost 3 vzipr <1,4,0,5>, <1,0,3,2>
    2086076417U, // <0,3,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    2232846516U, // <0,3,5,4>: Cost 3 vrev <3,0,4,5>
    3204292608U, // <0,3,5,5>: Cost 3 ins <u,3,5,5>, lane 0
    2653769826U, // <0,3,5,6>: Cost 3 vext2 <6,1,0,3>, <5,6,7,0>
    2130567168U, // <0,3,5,7>: Cost 2 ins <u,3,5,7>, lane 0
    2130567168U, // <0,3,5,u>: Cost 2 ins <u,3,5,7>, lane 0
    2854506594U, // <0,3,6,0>: Cost 3 vuzpr <6,0,1,3>, <5,6,7,0>
    2653770090U, // <0,3,6,1>: Cost 3 vext2 <6,1,0,3>, <6,1,0,3>
    3204341760U, // <0,3,6,2>: Cost 3 ins <u,3,6,2>, lane 0
    2086150145U, // <0,3,6,3>: Cost 2 ins <0,u,6,3>, lane 1
    3204358144U, // <0,3,6,4>: Cost 3 ins <u,3,6,4>, lane 0
    3204366336U, // <0,3,6,5>: Cost 3 ins <u,3,6,5>, lane 0
    3204374528U, // <0,3,6,6>: Cost 3 ins <u,3,6,6>, lane 0
    2130640896U, // <0,3,6,7>: Cost 2 ins <u,3,6,7>, lane 0
    2086150145U, // <0,3,6,u>: Cost 2 ins <0,u,6,3>, lane 1
    2968109974U, // <0,3,7,0>: Cost 3 vzipr <2,5,0,7>, <1,2,3,0>
    2659742787U, // <0,3,7,1>: Cost 3 vext2 <7,1,0,3>, <7,1,0,3>
    2660406420U, // <0,3,7,2>: Cost 3 vext2 <7,2,0,3>, <7,2,0,3>
    2086223873U, // <0,3,7,3>: Cost 2 ins <0,u,7,3>, lane 1
    3204431872U, // <0,3,7,4>: Cost 3 ins <u,3,7,4>, lane 0
    3204440064U, // <0,3,7,5>: Cost 3 ins <u,3,7,5>, lane 0
    2752378305U, // <0,3,7,6>: Cost 3 vuzpl <0,1,3,3>, <7,5,6,7>
    3204456448U, // <0,3,7,7>: Cost 3 ins <u,3,7,7>, lane 0
    2086223873U, // <0,3,7,u>: Cost 2 ins <0,u,7,3>, lane 1
    1817421974U, // <0,3,u,0>: Cost 2 vzipl LHS, <3,0,1,2>
    1947437206U, // <0,3,u,1>: Cost 2 vtrnl LHS, <3,0,1,2>
    2085699585U, // <0,3,u,2>: Cost 2 ins <0,u,0,2>, lane 1
    1012113409U, // <0,3,u,3>: Cost 1 ins LHS, lane 1
    1817422338U, // <0,3,u,4>: Cost 2 vzipl LHS, <3,4,5,6>
    1947437570U, // <0,3,u,5>: Cost 2 vtrnl LHS, <3,4,5,6>
    2085879809U, // <0,3,u,6>: Cost 2 ins <0,u,2,6>, lane 1
    2130567168U, // <0,3,u,7>: Cost 2 ins <u,3,5,7>, lane 0
    1012113409U, // <0,3,u,u>: Cost 1 ins LHS, lane 1
    2085683201U, // <0,4,0,0>: Cost 2 ins <0,u,0,0>, lane 1
    2083684357U, // <0,4,0,1>: Cost 2 ins <0,4,u,u>, lane 5
    1679392870U, // <0,4,0,2>: Cost 2 vuzpl <0,2,4,6>, LHS
    2085707777U, // <0,4,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    1679392972U, // <0,4,0,4>: Cost 2 vuzpl <0,2,4,6>, <0,2,4,6>
    2083659778U, // <0,4,0,5>: Cost 2 ins <0,4,u,5>, lane 2
    1947503926U, // <0,4,0,6>: Cost 2 vtrnl <0,2,0,2>, RHS
    3156836355U, // <0,4,0,7>: Cost 3 ins <0,4,0,u>, lane 3
    1947503944U, // <0,4,0,u>: Cost 2 vtrnl <0,2,0,2>, RHS
    2083168259U, // <0,4,1,0>: Cost 2 ins <0,4,1,u>, lane 3
    2085765121U, // <0,4,1,1>: Cost 2 ins <0,u,1,1>, lane 1
    2083168259U, // <0,4,1,2>: Cost 2 ins <0,4,1,u>, lane 3
    2083168259U, // <0,4,1,3>: Cost 2 ins <0,4,1,u>, lane 3
    2083168259U, // <0,4,1,4>: Cost 2 ins <0,4,1,u>, lane 3
    739036470U,  // <0,4,1,5>: Cost 1 vzipl LHS, RHS
    1948929334U, // <0,4,1,6>: Cost 2 vtrnl <0,4,1,5>, RHS
    2083168259U, // <0,4,1,7>: Cost 2 ins <0,4,1,u>, lane 3
    739036713U,  // <0,4,1,u>: Cost 1 vzipl LHS, RHS
    2083241987U, // <0,4,2,0>: Cost 2 ins <0,4,2,u>, lane 3
    2083241987U, // <0,4,2,1>: Cost 2 ins <0,4,2,u>, lane 3
    2085847041U, // <0,4,2,2>: Cost 2 ins <0,u,2,2>, lane 1
    1012113409U, // <0,4,2,3>: Cost 1 ins LHS, lane 1
    2083241987U, // <0,4,2,4>: Cost 2 ins <0,4,2,u>, lane 3
    1813286198U, // <0,4,2,5>: Cost 2 vzipl <0,2,0,2>, RHS
    873254198U,  // <0,4,2,6>: Cost 1 vtrnl LHS, RHS
    2083241987U, // <0,4,2,7>: Cost 2 ins <0,4,2,u>, lane 3
    873254216U,  // <0,4,2,u>: Cost 1 vtrnl LHS, RHS
    3020811514U, // <0,4,3,0>: Cost 3 vtrnl <0,1,3,3>, <4,5,0,1>
    2753136790U, // <0,4,3,1>: Cost 3 vuzpl <0,2,4,6>, <3,0,1,2>
    2753136801U, // <0,4,3,2>: Cost 3 vuzpl <0,2,4,6>, <3,0,2,4>
    2085928961U, // <0,4,3,3>: Cost 2 ins <0,u,3,3>, lane 1
    3204800512U, // <0,4,3,4>: Cost 3 ins <u,4,3,4>, lane 0
    2083659778U, // <0,4,3,5>: Cost 2 ins <0,4,u,5>, lane 2
    2083667970U, // <0,4,3,6>: Cost 2 ins <0,4,u,6>, lane 2
    3087183077U, // <0,4,3,7>: Cost 3 vtrnr <0,0,2,3>, <4,4,6,7>
    2083659778U, // <0,4,3,u>: Cost 2 ins <0,4,u,5>, lane 2
    2753137995U, // <0,4,4,0>: Cost 3 vuzpl <0,2,4,6>, <4,6,0,1>
    2888453090U, // <0,4,4,1>: Cost 3 vzipl <0,4,1,5>, <4,1,5,0>
    2888535100U, // <0,4,4,2>: Cost 3 vzipl <0,4,2,6>, <4,2,6,0>
    2086002689U, // <0,4,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    2131132416U, // <0,4,4,4>: Cost 2 ins <u,4,4,4>, lane 0
    1814711606U, // <0,4,4,5>: Cost 2 vzipl <0,4,1,5>, RHS
    1679396150U, // <0,4,4,6>: Cost 2 vuzpl <0,2,4,6>, RHS
    3157131267U, // <0,4,4,7>: Cost 3 ins <0,4,4,u>, lane 3
    1679396168U, // <0,4,4,u>: Cost 2 vuzpl <0,2,4,6>, RHS
    2568388710U, // <0,4,5,0>: Cost 3 vext1 <3,0,4,5>, LHS
    2568389526U, // <0,4,5,1>: Cost 3 vext1 <3,0,4,5>, <1,2,3,0>
    3204931584U, // <0,4,5,2>: Cost 3 ins <u,4,5,2>, lane 0
    2086076417U, // <0,4,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    2568391990U, // <0,4,5,4>: Cost 3 vext1 <3,0,4,5>, RHS
    2131214336U, // <0,4,5,5>: Cost 2 ins <u,4,5,5>, lane 0
    1618136374U, // <0,4,5,6>: Cost 2 vext3 <1,2,3,0>, RHS
    2830699830U, // <0,4,5,7>: Cost 3 vuzpr <2,0,2,4>, RHS
    1618136392U, // <0,4,5,u>: Cost 2 vext3 <1,2,3,0>, RHS
    2712227146U, // <0,4,6,0>: Cost 3 vext3 <4,6,0,0>, <4,6,0,0>
    2753138977U, // <0,4,6,1>: Cost 3 vuzpl <0,2,4,6>, <6,0,1,2>
    2753138988U, // <0,4,6,2>: Cost 3 vuzpl <0,2,4,6>, <6,0,2,4>
    2086150145U, // <0,4,6,3>: Cost 2 ins <0,u,6,3>, lane 1
    2712522094U, // <0,4,6,4>: Cost 3 vext3 <4,6,4,0>, <4,6,4,0>
    2083659778U, // <0,4,6,5>: Cost 2 ins <0,4,u,5>, lane 2
    2131296256U, // <0,4,6,6>: Cost 2 ins <u,4,6,6>, lane 0
    2083684357U, // <0,4,6,7>: Cost 2 ins <0,4,u,u>, lane 5
    2083659778U, // <0,4,6,u>: Cost 2 ins <0,4,u,5>, lane 2
    3021106426U, // <0,4,7,0>: Cost 3 vtrnl <0,1,7,3>, <4,5,0,1>
    2860487502U, // <0,4,7,1>: Cost 3 vuzpr <7,0,1,4>, <6,7,0,1>
    3157377026U, // <0,4,7,2>: Cost 3 ins <0,4,u,2>, lane 2
    2086223873U, // <0,4,7,3>: Cost 2 ins <0,u,7,3>, lane 1
    3205095424U, // <0,4,7,4>: Cost 3 ins <u,4,7,4>, lane 0
    2083659778U, // <0,4,7,5>: Cost 2 ins <0,4,u,5>, lane 2
    2131369984U, // <0,4,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    2752452204U, // <0,4,7,7>: Cost 3 vuzpl <0,1,4,3>, <7,7,7,7>
    2083659778U, // <0,4,7,u>: Cost 2 ins <0,4,u,5>, lane 2
    2083168259U, // <0,4,u,0>: Cost 2 ins <0,4,1,u>, lane 3
    2083684357U, // <0,4,u,1>: Cost 2 ins <0,4,u,u>, lane 5
    1679398702U, // <0,4,u,2>: Cost 2 vuzpl <0,2,4,6>, LHS
    1012113409U, // <0,4,u,3>: Cost 1 ins LHS, lane 1
    1679392972U, // <0,4,u,4>: Cost 2 vuzpl <0,2,4,6>, <0,2,4,6>
    743681334U,  // <0,4,u,5>: Cost 1 vzipl LHS, RHS
    873696566U,  // <0,4,u,6>: Cost 1 vtrnl LHS, RHS
    2083168259U, // <0,4,u,7>: Cost 2 ins <0,4,1,u>, lane 3
    873696584U,  // <0,4,u,u>: Cost 1 vtrnl LHS, RHS
    2085683201U, // <0,5,0,0>: Cost 2 ins <0,u,0,0>, lane 1
    2131476480U, // <0,5,0,1>: Cost 2 ins <u,5,0,1>, lane 0
    2085699585U, // <0,5,0,2>: Cost 2 ins <0,u,0,2>, lane 1
    2085707777U, // <0,5,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    3159457793U, // <0,5,0,4>: Cost 3 ins <0,u,0,4>, lane 1
    1678778497U, // <0,5,0,5>: Cost 2 vuzpl <0,1,5,3>, <0,1,5,3>
    3159474177U, // <0,5,0,6>: Cost 3 ins <0,u,0,6>, lane 1
    2013269302U, // <0,5,0,7>: Cost 2 vtrnr <0,0,0,0>, RHS
    2085699585U, // <0,5,0,u>: Cost 2 ins <0,u,0,2>, lane 1
    1500659814U, // <0,5,1,0>: Cost 2 vext1 <4,0,5,1>, LHS
    2085765121U, // <0,5,1,1>: Cost 2 ins <0,u,1,1>, lane 1
    3159515137U, // <0,5,1,2>: Cost 3 ins <0,u,1,2>, lane 1
    2085781505U, // <0,5,1,3>: Cost 2 ins <0,u,1,3>, lane 1
    1812778950U, // <0,5,1,4>: Cost 2 vzipl LHS, <5,4,7,6>
    2085797889U, // <0,5,1,5>: Cost 2 ins <0,u,1,5>, lane 1
    1812779106U, // <0,5,1,6>: Cost 2 vzipl LHS, <5,6,7,0>
    2013351222U, // <0,5,1,7>: Cost 2 vtrnr <0,0,1,1>, RHS
    2085765121U, // <0,5,1,u>: Cost 2 ins <0,u,1,1>, lane 1
    2085830657U, // <0,5,2,0>: Cost 2 ins <0,u,2,0>, lane 1
    1946996864U, // <0,5,2,1>: Cost 2 vtrnl LHS, <5,7,1,3>
    2085847041U, // <0,5,2,2>: Cost 2 ins <0,u,2,2>, lane 1
    1012113409U, // <0,5,2,3>: Cost 1 ins LHS, lane 1
    2085863425U, // <0,5,2,4>: Cost 2 ins <0,u,2,4>, lane 1
    1946996740U, // <0,5,2,5>: Cost 2 vtrnl LHS, <5,5,5,5>
    2085879809U, // <0,5,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    2019478838U, // <0,5,2,7>: Cost 2 vtrnr <1,0,3,2>, RHS
    1012113409U, // <0,5,2,u>: Cost 1 ins LHS, lane 1
    2637858966U, // <0,5,3,0>: Cost 3 vext2 <3,4,0,5>, <3,0,1,2>
    3205439488U, // <0,5,3,1>: Cost 3 ins <u,5,3,1>, lane 0
    3087183153U, // <0,5,3,2>: Cost 3 vtrnr <0,0,2,3>, <4,5,6,2>
    2085928961U, // <0,5,3,3>: Cost 2 ins <0,u,3,3>, lane 1
    2637859284U, // <0,5,3,4>: Cost 3 vext2 <3,4,0,5>, <3,4,0,5>
    3205472256U, // <0,5,3,5>: Cost 3 ins <u,5,3,5>, lane 0
    3205480448U, // <0,5,3,6>: Cost 3 ins <u,5,3,6>, lane 0
    2131746816U, // <0,5,3,7>: Cost 2 ins <u,5,3,7>, lane 0
    2131746816U, // <0,5,3,u>: Cost 2 ins <u,5,3,7>, lane 0
    2888453704U, // <0,5,4,0>: Cost 3 vzipl <0,4,1,5>, <5,0,1,2>
    3159728129U, // <0,5,4,1>: Cost 3 ins <0,u,4,1>, lane 1
    3159736321U, // <0,5,4,2>: Cost 3 ins <0,u,4,2>, lane 1
    2086002689U, // <0,5,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    2888454068U, // <0,5,4,4>: Cost 3 vzipl <0,4,1,5>, <5,4,5,6>
    2131804160U, // <0,5,4,5>: Cost 2 ins <u,5,4,5>, lane 0
    2086027265U, // <0,5,4,6>: Cost 2 ins <0,u,4,6>, lane 1
    2131820544U, // <0,5,4,7>: Cost 2 ins <u,5,4,7>, lane 0
    2086027265U, // <0,5,4,u>: Cost 2 ins <0,u,4,6>, lane 1
    3205578752U, // <0,5,5,0>: Cost 3 ins <u,5,5,0>, lane 0
    2997291922U, // <0,5,5,1>: Cost 3 vzipr <7,4,0,5>, <4,0,5,1>
    2752523939U, // <0,5,5,2>: Cost 3 vuzpl <0,1,5,3>, <5,1,2,3>
    2086076417U, // <0,5,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    3205611520U, // <0,5,5,4>: Cost 3 ins <u,5,5,4>, lane 0
    2131877888U, // <0,5,5,5>: Cost 2 ins <u,5,5,5>, lane 0
    2657767522U, // <0,5,5,6>: Cost 3 vext2 <6,7,0,5>, <5,6,7,0>
    2131894272U, // <0,5,5,7>: Cost 2 ins <u,5,5,7>, lane 0
    2086076417U, // <0,5,5,u>: Cost 2 ins <0,u,5,3>, lane 1
    2131910656U, // <0,5,6,0>: Cost 2 ins <u,5,6,0>, lane 0
    2131918848U, // <0,5,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2131927040U, // <0,5,6,2>: Cost 2 ins <u,5,6,2>, lane 0
    2131935232U, // <0,5,6,3>: Cost 2 ins <u,5,6,3>, lane 0
    2131943424U, // <0,5,6,4>: Cost 2 ins <u,5,6,4>, lane 0
    2131951616U, // <0,5,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    2131959808U, // <0,5,6,6>: Cost 2 ins <u,5,6,6>, lane 0
    1058226176U, // <0,5,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <0,5,6,u>: Cost 1 ins RHS, lane 0
    2562506854U, // <0,5,7,0>: Cost 3 vext1 <2,0,5,7>, LHS
    2562507670U, // <0,5,7,1>: Cost 3 vext1 <2,0,5,7>, <1,2,3,0>
    2562508262U, // <0,5,7,2>: Cost 3 vext1 <2,0,5,7>, <2,0,5,7>
    2086223873U, // <0,5,7,3>: Cost 2 ins <0,u,7,3>, lane 1
    2562510134U, // <0,5,7,4>: Cost 3 vext1 <2,0,5,7>, RHS
    2718716072U, // <0,5,7,5>: Cost 3 vext3 <5,6,7,0>, <5,7,5,7>
    2718716074U, // <0,5,7,6>: Cost 3 vext3 <5,6,7,0>, <5,7,6,0>
    2132041728U, // <0,5,7,7>: Cost 2 ins <u,5,7,7>, lane 0
    2132041728U, // <0,5,7,u>: Cost 2 ins <u,5,7,7>, lane 0
    1500717158U, // <0,5,u,0>: Cost 2 vext1 <4,0,5,u>, LHS
    2085765121U, // <0,5,u,1>: Cost 2 ins <0,u,1,1>, lane 1
    2085699585U, // <0,5,u,2>: Cost 2 ins <0,u,0,2>, lane 1
    1012113409U, // <0,5,u,3>: Cost 1 ins LHS, lane 1
    1817423814U, // <0,5,u,4>: Cost 2 vzipl LHS, <5,4,7,6>
    2085797889U, // <0,5,u,5>: Cost 2 ins <0,u,1,5>, lane 1
    2085879809U, // <0,5,u,6>: Cost 2 ins <0,u,2,6>, lane 1
    1058226176U, // <0,5,u,7>: Cost 1 ins RHS, lane 0
    1012113409U, // <0,5,u,u>: Cost 1 ins LHS, lane 1
    2085683201U, // <0,6,0,0>: Cost 2 ins <0,u,0,0>, lane 1
    2085691393U, // <0,6,0,1>: Cost 2 ins <0,u,0,1>, lane 1
    2132148224U, // <0,6,0,2>: Cost 2 ins <u,6,0,2>, lane 0
    2085707777U, // <0,6,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    2619949386U, // <0,6,0,4>: Cost 3 vext2 <0,4,0,6>, <0,4,0,6>
    2586415202U, // <0,6,0,5>: Cost 3 vext1 <6,0,6,0>, <5,6,7,0>
    1678852234U, // <0,6,0,6>: Cost 2 vuzpl <0,1,6,3>, <0,1,6,3>
    1879051574U, // <0,6,0,7>: Cost 2 vzipr <0,0,0,0>, RHS
    2132148224U, // <0,6,0,u>: Cost 2 ins <u,6,0,2>, lane 0
    2993278336U, // <0,6,1,0>: Cost 3 vzipr <6,7,0,1>, <4,6,6,0>
    2085765121U, // <0,6,1,1>: Cost 2 ins <0,u,1,1>, lane 1
    1812779514U, // <0,6,1,2>: Cost 2 vzipl LHS, <6,2,7,3>
    2085781505U, // <0,6,1,3>: Cost 2 ins <0,u,1,3>, lane 1
    3159531521U, // <0,6,1,4>: Cost 3 ins <0,u,1,4>, lane 1
    2085797889U, // <0,6,1,5>: Cost 2 ins <0,u,1,5>, lane 1
    1812779832U, // <0,6,1,6>: Cost 2 vzipl LHS, <6,6,6,6>
    1892994358U, // <0,6,1,7>: Cost 2 vzipr <2,3,0,1>, RHS
    1892994359U, // <0,6,1,u>: Cost 2 vzipr <2,3,0,1>, RHS
    1946997582U, // <0,6,2,0>: Cost 2 vtrnl LHS, <6,7,0,1>
    2085838849U, // <0,6,2,1>: Cost 2 ins <0,u,2,1>, lane 1
    2085847041U, // <0,6,2,2>: Cost 2 ins <0,u,2,2>, lane 1
    1012113409U, // <0,6,2,3>: Cost 1 ins LHS, lane 1
    1946997622U, // <0,6,2,4>: Cost 2 vtrnl LHS, <6,7,4,5>
    2085871617U, // <0,6,2,5>: Cost 2 ins <0,u,2,5>, lane 1
    2085879809U, // <0,6,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    1880395062U, // <0,6,2,7>: Cost 2 vzipr <0,2,0,2>, RHS
    1012113409U, // <0,6,2,u>: Cost 1 ins LHS, lane 1
    3122942050U, // <0,6,3,0>: Cost 3 vtrnr <6,0,1,3>, <5,6,7,0>
    2250527010U, // <0,6,3,1>: Cost 3 vrev <6,0,1,3>
    3206111232U, // <0,6,3,2>: Cost 3 ins <u,6,3,2>, lane 0
    2085928961U, // <0,6,3,3>: Cost 2 ins <0,u,3,3>, lane 1
    3206127616U, // <0,6,3,4>: Cost 3 ins <u,6,3,4>, lane 0
    3206135808U, // <0,6,3,5>: Cost 3 ins <u,6,3,5>, lane 0
    3206144000U, // <0,6,3,6>: Cost 3 ins <u,6,3,6>, lane 0
    2132410368U, // <0,6,3,7>: Cost 2 ins <u,6,3,7>, lane 0
    2132410368U, // <0,6,3,u>: Cost 2 ins <u,6,3,7>, lane 0
    2888536380U, // <0,6,4,0>: Cost 3 vzipl <0,4,2,6>, <6,0,4,2>
    3021574433U, // <0,6,4,1>: Cost 3 vtrnl <0,2,4,6>, <6,0,1,2>
    3021574444U, // <0,6,4,2>: Cost 3 vtrnl <0,2,4,6>, <6,0,2,4>
    2086002689U, // <0,6,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    2562559286U, // <0,6,4,4>: Cost 3 vext1 <2,0,6,4>, RHS
    2086019073U, // <0,6,4,5>: Cost 2 ins <0,u,4,5>, lane 1
    2132475904U, // <0,6,4,6>: Cost 2 ins <u,6,4,6>, lane 0
    2954153270U, // <0,6,4,7>: Cost 3 vzipr <0,2,0,4>, RHS
    2132475904U, // <0,6,4,u>: Cost 2 ins <u,6,4,6>, lane 0
    2718716594U, // <0,6,5,0>: Cost 3 vext3 <5,6,7,0>, <6,5,0,7>
    3206250496U, // <0,6,5,1>: Cost 3 ins <u,6,5,1>, lane 0
    3206258688U, // <0,6,5,2>: Cost 3 ins <u,6,5,2>, lane 0
    2086076417U, // <0,6,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    3206275072U, // <0,6,5,4>: Cost 3 ins <u,6,5,4>, lane 0
    3206283264U, // <0,6,5,5>: Cost 3 ins <u,6,5,5>, lane 0
    3206291456U, // <0,6,5,6>: Cost 3 ins <u,6,5,6>, lane 0
    2961460534U, // <0,6,5,7>: Cost 3 vzipr <1,4,0,5>, RHS
    2086076417U, // <0,6,5,u>: Cost 2 ins <0,u,5,3>, lane 1
    2724172540U, // <0,6,6,0>: Cost 3 vext3 <6,6,0,0>, <6,6,0,0>
    2889838972U, // <0,6,6,1>: Cost 3 vzipl <0,6,2,3>, <6,1,2,3>
    2997300124U, // <0,6,6,2>: Cost 3 vzipr <7,4,0,6>, <4,0,6,2>
    2086150145U, // <0,6,6,3>: Cost 2 ins <0,u,6,3>, lane 1
    3206348800U, // <0,6,6,4>: Cost 3 ins <u,6,6,4>, lane 0
    2889839336U, // <0,6,6,5>: Cost 3 vzipl <0,6,2,3>, <6,5,6,7>
    2132623360U, // <0,6,6,6>: Cost 2 ins <u,6,6,6>, lane 0
    2132631552U, // <0,6,6,7>: Cost 2 ins <u,6,6,7>, lane 0
    2086150145U, // <0,6,6,u>: Cost 2 ins <0,u,6,3>, lane 1
    2132647936U, // <0,6,7,0>: Cost 2 ins <u,6,7,0>, lane 0
    2724909910U, // <0,6,7,1>: Cost 3 vext3 <6,7,1,0>, <6,7,1,0>
    3206406144U, // <0,6,7,2>: Cost 3 ins <u,6,7,2>, lane 0
    2086223873U, // <0,6,7,3>: Cost 2 ins <0,u,7,3>, lane 1
    2132680704U, // <0,6,7,4>: Cost 2 ins <u,6,7,4>, lane 0
    2718716800U, // <0,6,7,5>: Cost 3 vext3 <5,6,7,0>, <6,7,5,6>
    3206438912U, // <0,6,7,6>: Cost 3 ins <u,6,7,6>, lane 0
    2132705280U, // <0,6,7,7>: Cost 2 ins <u,6,7,7>, lane 0
    2132647936U, // <0,6,7,u>: Cost 2 ins <u,6,7,0>, lane 0
    2132647936U, // <0,6,u,0>: Cost 2 ins <u,6,7,0>, lane 0
    2085765121U, // <0,6,u,1>: Cost 2 ins <0,u,1,1>, lane 1
    2132148224U, // <0,6,u,2>: Cost 2 ins <u,6,0,2>, lane 0
    1012113409U, // <0,6,u,3>: Cost 1 ins LHS, lane 1
    2132680704U, // <0,6,u,4>: Cost 2 ins <u,6,7,4>, lane 0
    2085797889U, // <0,6,u,5>: Cost 2 ins <0,u,1,5>, lane 1
    2085879809U, // <0,6,u,6>: Cost 2 ins <0,u,2,6>, lane 1
    1880444214U, // <0,6,u,7>: Cost 2 vzipr <0,2,0,u>, RHS
    1012113409U, // <0,6,u,u>: Cost 1 ins LHS, lane 1
    2085683201U, // <0,7,0,0>: Cost 2 ins <0,u,0,0>, lane 1
    2132803584U, // <0,7,0,1>: Cost 2 ins <u,7,0,1>, lane 0
    2085699585U, // <0,7,0,2>: Cost 2 ins <0,u,0,2>, lane 1
    2085707777U, // <0,7,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    2580516150U, // <0,7,0,4>: Cost 3 vext1 <5,0,7,0>, RHS
    2580516476U, // <0,7,0,5>: Cost 3 vext1 <5,0,7,0>, <5,0,7,0>
    2586489173U, // <0,7,0,6>: Cost 3 vext1 <6,0,7,0>, <6,0,7,0>
    1678925971U, // <0,7,0,7>: Cost 2 vuzpl <0,1,7,3>, <0,1,7,3>
    2132803584U, // <0,7,0,u>: Cost 2 ins <u,7,0,1>, lane 0
    1812780026U, // <0,7,1,0>: Cost 2 vzipl LHS, <7,0,1,2>
    2085765121U, // <0,7,1,1>: Cost 2 ins <0,u,1,1>, lane 1
    2632565654U, // <0,7,1,2>: Cost 3 vext2 <2,5,0,7>, <1,2,3,0>
    2132893696U, // <0,7,1,3>: Cost 2 ins <u,7,1,3>, lane 0
    1812780390U, // <0,7,1,4>: Cost 2 vzipl LHS, <7,4,5,6>
    2085797889U, // <0,7,1,5>: Cost 2 ins <0,u,1,5>, lane 1
    2586497366U, // <0,7,1,6>: Cost 3 vext1 <6,0,7,1>, <6,0,7,1>
    1812780652U, // <0,7,1,7>: Cost 2 vzipl LHS, <7,7,7,7>
    2085765121U, // <0,7,1,u>: Cost 2 ins <0,u,1,1>, lane 1
    2085830657U, // <0,7,2,0>: Cost 2 ins <0,u,2,0>, lane 1
    1182749690U, // <0,7,2,1>: Cost 2 vrev <7,0,1,2>
    2085847041U, // <0,7,2,2>: Cost 2 ins <0,u,2,2>, lane 1
    1012113409U, // <0,7,2,3>: Cost 1 ins LHS, lane 1
    2085863425U, // <0,7,2,4>: Cost 2 ins <0,u,2,4>, lane 1
    1946998118U, // <0,7,2,5>: Cost 2 vtrnl LHS, <7,4,5,6>
    2085879809U, // <0,7,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    1946998380U, // <0,7,2,7>: Cost 2 vtrnl LHS, <7,7,7,7>
    1012113409U, // <0,7,2,u>: Cost 1 ins LHS, lane 1
    2989314146U, // <0,7,3,0>: Cost 3 vzipr <6,1,0,3>, <5,6,7,0>
    3206766592U, // <0,7,3,1>: Cost 3 ins <u,7,3,1>, lane 0
    3020813397U, // <0,7,3,2>: Cost 3 vtrnl <0,1,3,3>, <7,1,2,3>
    2085928961U, // <0,7,3,3>: Cost 2 ins <0,u,3,3>, lane 1
    3206791168U, // <0,7,3,4>: Cost 3 ins <u,7,3,4>, lane 0
    3206799360U, // <0,7,3,5>: Cost 3 ins <u,7,3,5>, lane 0
    2639202936U, // <0,7,3,6>: Cost 3 vext2 <3,6,0,7>, <3,6,0,7>
    3206815744U, // <0,7,3,7>: Cost 3 ins <u,7,3,7>, lane 0
    2085928961U, // <0,7,3,u>: Cost 2 ins <0,u,3,3>, lane 1
    3206832128U, // <0,7,4,0>: Cost 3 ins <u,7,4,0>, lane 0
    2256507900U, // <0,7,4,1>: Cost 3 vrev <7,0,1,4>
    2256581637U, // <0,7,4,2>: Cost 3 vrev <7,0,2,4>
    2086002689U, // <0,7,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    3206864896U, // <0,7,4,4>: Cost 3 ins <u,7,4,4>, lane 0
    2133131264U, // <0,7,4,5>: Cost 2 ins <u,7,4,5>, lane 0
    2086027265U, // <0,7,4,6>: Cost 2 ins <0,u,4,6>, lane 1
    3020887660U, // <0,7,4,7>: Cost 3 vtrnl <0,1,4,3>, <7,7,7,7>
    2133131264U, // <0,7,4,u>: Cost 2 ins <u,7,4,5>, lane 0
    2993311842U, // <0,7,5,0>: Cost 3 vzipr <6,7,0,5>, <5,6,7,0>
    3206914048U, // <0,7,5,1>: Cost 3 ins <u,7,5,1>, lane 0
    3020960853U, // <0,7,5,2>: Cost 3 vtrnl <0,1,5,3>, <7,1,2,3>
    2086076417U, // <0,7,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    2256737304U, // <0,7,5,4>: Cost 3 vrev <7,0,4,5>
    3206946816U, // <0,7,5,5>: Cost 3 ins <u,7,5,5>, lane 0
    2718717377U, // <0,7,5,6>: Cost 3 vext3 <5,6,7,0>, <7,5,6,7>
    2133221376U, // <0,7,5,7>: Cost 2 ins <u,7,5,7>, lane 0
    2133221376U, // <0,7,5,u>: Cost 2 ins <u,7,5,7>, lane 0
    2854834274U, // <0,7,6,0>: Cost 3 vuzpr <6,0,5,7>, <5,6,7,0>
    2256524286U, // <0,7,6,1>: Cost 3 vrev <7,0,1,6>
    3206995968U, // <0,7,6,2>: Cost 3 ins <u,7,6,2>, lane 0
    2086150145U, // <0,7,6,3>: Cost 2 ins <0,u,6,3>, lane 1
    3207012352U, // <0,7,6,4>: Cost 3 ins <u,7,6,4>, lane 0
    2656457394U, // <0,7,6,5>: Cost 3 vext2 <6,5,0,7>, <6,5,0,7>
    3207028736U, // <0,7,6,6>: Cost 3 ins <u,7,6,6>, lane 0
    2133295104U, // <0,7,6,7>: Cost 2 ins <u,7,6,7>, lane 0
    2086150145U, // <0,7,6,u>: Cost 2 ins <0,u,6,3>, lane 1
    2992001122U, // <0,7,7,0>: Cost 3 vzipr <6,5,0,7>, <5,6,7,0>
    3207061504U, // <0,7,7,1>: Cost 3 ins <u,7,7,1>, lane 0
    2752672853U, // <0,7,7,2>: Cost 3 vuzpl <0,1,7,3>, <7,1,2,3>
    2086223873U, // <0,7,7,3>: Cost 2 ins <0,u,7,3>, lane 1
    3207086080U, // <0,7,7,4>: Cost 3 ins <u,7,7,4>, lane 0
    3207094272U, // <0,7,7,5>: Cost 3 ins <u,7,7,5>, lane 0
    2663093724U, // <0,7,7,6>: Cost 3 vext2 <7,6,0,7>, <7,6,0,7>
    2133368832U, // <0,7,7,7>: Cost 2 ins <u,7,7,7>, lane 0
    2086223873U, // <0,7,7,u>: Cost 2 ins <0,u,7,3>, lane 1
    1817424890U, // <0,7,u,0>: Cost 2 vzipl LHS, <7,0,1,2>
    1182798848U, // <0,7,u,1>: Cost 2 vrev <7,0,1,u>
    2085699585U, // <0,7,u,2>: Cost 2 ins <0,u,0,2>, lane 1
    1012113409U, // <0,7,u,3>: Cost 1 ins LHS, lane 1
    1817425254U, // <0,7,u,4>: Cost 2 vzipl LHS, <7,4,5,6>
    2085797889U, // <0,7,u,5>: Cost 2 ins <0,u,1,5>, lane 1
    2085879809U, // <0,7,u,6>: Cost 2 ins <0,u,2,6>, lane 1
    2133221376U, // <0,7,u,7>: Cost 2 ins <u,7,5,7>, lane 0
    1012113409U, // <0,7,u,u>: Cost 1 ins LHS, lane 1
    135053414U,  // <0,u,0,0>: Cost 1 vdup0 LHS
    1007951877U, // <0,u,0,1>: Cost 1 ins LHS, lane 5
    605257830U,  // <0,u,0,2>: Cost 1 vuzpl LHS, LHS
    1007910914U, // <0,u,0,3>: Cost 1 ins LHS, lane 2
    1678999756U, // <0,u,0,4>: Cost 2 vuzpl LHS, <0,2,4,6>
    2081767427U, // <0,u,0,5>: Cost 2 ins <0,2,0,u>, lane 3
    1947506842U, // <0,u,0,6>: Cost 2 vtrnl <0,2,0,2>, RHS
    2081767427U, // <0,u,0,7>: Cost 2 ins <0,2,0,u>, lane 3
    605257884U,  // <0,u,0,u>: Cost 1 vuzpl LHS, LHS
    1812821715U, // <0,u,1,0>: Cost 2 vzipl LHS, <u,0,1,2>
    739039022U,  // <0,u,1,1>: Cost 1 vzipl LHS, LHS
    1813264264U, // <0,u,1,2>: Cost 2 vzipl LHS, <u,2,3,3>
    1007910914U, // <0,u,1,3>: Cost 1 ins LHS, lane 2
    1812822079U, // <0,u,1,4>: Cost 2 vzipl LHS, <u,4,5,6>
    739039386U,  // <0,u,1,5>: Cost 1 vzipl LHS, RHS
    1813264592U, // <0,u,1,6>: Cost 2 vzipl LHS, <u,6,3,7>
    1892994376U, // <0,u,1,7>: Cost 2 vzipr <2,3,0,1>, RHS
    739039589U,  // <0,u,1,u>: Cost 1 vzipl LHS, LHS
    1007509507U, // <0,u,2,0>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,u,2,1>: Cost 1 ins LHS, lane 3
    873256750U,  // <0,u,2,2>: Cost 1 vtrnl LHS, LHS
    835584U,     // <0,u,2,3>: Cost 0 copy LHS
    1007509507U, // <0,u,2,4>: Cost 1 ins LHS, lane 3
    1007509507U, // <0,u,2,5>: Cost 1 ins LHS, lane 3
    873257114U,  // <0,u,2,6>: Cost 1 vtrnl LHS, RHS
    1007509507U, // <0,u,2,7>: Cost 1 ins LHS, lane 3
    835584U,     // <0,u,2,u>: Cost 0 copy LHS
    2133680132U, // <0,u,3,0>: Cost 2 ins <u,u,3,0>, lane 4
    1679001750U, // <0,u,3,1>: Cost 2 vuzpl LHS, <3,0,1,2>
    2128388096U, // <0,u,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    1007910914U, // <0,u,3,3>: Cost 1 ins LHS, lane 2
    2133712900U, // <0,u,3,4>: Cost 2 ins <u,u,3,4>, lane 4
    1679002114U, // <0,u,3,5>: Cost 2 vuzpl LHS, <3,4,5,6>
    2082340866U, // <0,u,3,6>: Cost 2 ins <0,2,u,6>, lane 2
    2133737476U, // <0,u,3,7>: Cost 2 ins <u,u,3,7>, lane 4
    1007910914U, // <0,u,3,u>: Cost 1 ins LHS, lane 2
    2082062339U, // <0,u,4,0>: Cost 2 ins <0,2,4,u>, lane 3
    1814714158U, // <0,u,4,1>: Cost 2 vzipl <0,4,1,5>, LHS
    1947834158U, // <0,u,4,2>: Cost 2 vtrnl <0,2,4,6>, LHS
    1007910914U, // <0,u,4,3>: Cost 1 ins LHS, lane 2
    1947828428U, // <0,u,4,4>: Cost 2 vtrnl <0,2,4,6>, <0,2,4,6>
    1007951877U, // <0,u,4,5>: Cost 1 ins LHS, lane 5
    605261110U,  // <0,u,4,6>: Cost 1 vuzpl LHS, RHS
    2082062339U, // <0,u,4,7>: Cost 2 ins <0,2,4,u>, lane 3
    605261128U,  // <0,u,4,u>: Cost 1 vuzpl LHS, RHS
    2080964610U, // <0,u,5,0>: Cost 2 ins <0,0,u,0>, lane 2
    2128527360U, // <0,u,5,1>: Cost 2 ins <u,0,5,1>, lane 0
    2080980994U, // <0,u,5,2>: Cost 2 ins <0,0,u,2>, lane 2
    1007910914U, // <0,u,5,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <0,u,5,4>: Cost 2 ins <0,1,u,4>, lane 2
    2133868548U, // <0,u,5,5>: Cost 2 ins <u,u,5,5>, lane 4
    1618139290U, // <0,u,5,6>: Cost 2 vext3 <1,2,3,0>, RHS
    1751092534U, // <0,u,5,7>: Cost 2 vuzpr <1,0,3,u>, RHS
    1007910914U, // <0,u,5,u>: Cost 1 ins LHS, lane 2
    1679004494U, // <0,u,6,0>: Cost 2 vuzpl LHS, <6,7,0,1>
    2080972802U, // <0,u,6,1>: Cost 2 ins <0,0,u,1>, lane 2
    2128609280U, // <0,u,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    1007910914U, // <0,u,6,3>: Cost 1 ins LHS, lane 2
    1679004534U, // <0,u,6,4>: Cost 2 vuzpl LHS, <6,7,4,5>
    2083659778U, // <0,u,6,5>: Cost 2 ins <0,4,u,5>, lane 2
    2133950468U, // <0,u,6,6>: Cost 2 ins <u,u,6,6>, lane 4
    1060216836U, // <0,u,6,7>: Cost 1 ins RHS, lane 4
    1007910914U, // <0,u,6,u>: Cost 1 ins LHS, lane 2
    2133975044U, // <0,u,7,0>: Cost 2 ins <u,u,7,0>, lane 4
    2080972802U, // <0,u,7,1>: Cost 2 ins <0,0,u,1>, lane 2
    2080980994U, // <0,u,7,2>: Cost 2 ins <0,0,u,2>, lane 2
    1007910914U, // <0,u,7,3>: Cost 1 ins LHS, lane 2
    2134007812U, // <0,u,7,4>: Cost 2 ins <u,u,7,4>, lane 4
    2083659778U, // <0,u,7,5>: Cost 2 ins <0,4,u,5>, lane 2
    2134024196U, // <0,u,7,6>: Cost 2 ins <u,u,7,6>, lane 4
    2134032388U, // <0,u,7,7>: Cost 2 ins <u,u,7,7>, lane 4
    1007910914U, // <0,u,7,u>: Cost 1 ins LHS, lane 2
    135053414U,  // <0,u,u,0>: Cost 1 vdup0 LHS
    743683886U,  // <0,u,u,1>: Cost 1 vzipl LHS, LHS
    605263662U,  // <0,u,u,2>: Cost 1 vuzpl LHS, LHS
    835584U,     // <0,u,u,3>: Cost 0 copy LHS
    1007509507U, // <0,u,u,4>: Cost 1 ins LHS, lane 3
    743684250U,  // <0,u,u,5>: Cost 1 vzipl LHS, RHS
    605264026U,  // <0,u,u,6>: Cost 1 vuzpl LHS, RHS
    1007509507U, // <0,u,u,7>: Cost 1 ins LHS, lane 3
    835584U,     // <0,u,u,u>: Cost 0 copy LHS
    2128150528U, // <1,0,0,0>: Cost 2 ins <u,0,0,0>, lane 0
    1818148966U, // <1,0,0,1>: Cost 2 vzipl <1,0,3,2>, LHS
    2086952962U, // <1,0,0,2>: Cost 2 ins <1,0,u,2>, lane 2
    2619310332U, // <1,0,0,3>: Cost 3 vext2 <0,3,1,0>, <0,3,1,0>
    2891891026U, // <1,0,0,4>: Cost 3 vzipl <1,0,3,2>, <0,4,1,5>
    3165437953U, // <1,0,0,5>: Cost 3 ins <1,u,0,5>, lane 1
    3160154115U, // <1,0,0,6>: Cost 3 ins <1,0,0,u>, lane 3
    3160154115U, // <1,0,0,7>: Cost 3 ins <1,0,0,u>, lane 3
    1818149533U, // <1,0,0,u>: Cost 2 vzipl <1,0,3,2>, LHS
    1141522514U, // <1,0,1,0>: Cost 2 vrev <0,1,0,1>
    1818656870U, // <1,0,1,1>: Cost 2 vzipl <1,1,1,1>, LHS
    1616003174U, // <1,0,1,2>: Cost 2 vext3 <0,u,1,1>, LHS
    2091753473U, // <1,0,1,3>: Cost 2 ins <1,u,1,3>, lane 1
    1477070134U, // <1,0,1,4>: Cost 2 vext1 <0,1,0,1>, RHS
    2760770560U, // <1,0,1,5>: Cost 3 vuzpl <1,5,0,2>, <1,3,5,7>
    2724839566U, // <1,0,1,6>: Cost 3 vext3 <6,7,0,1>, <0,1,6,7>
    3165528065U, // <1,0,1,7>: Cost 3 ins <1,u,1,7>, lane 1
    1616003228U, // <1,0,1,u>: Cost 2 vext3 <0,u,1,1>, LHS
    2685690019U, // <1,0,2,0>: Cost 3 vext3 <0,2,0,1>, <0,2,0,1>
    1819459686U, // <1,0,2,1>: Cost 2 vzipl <1,2,3,0>, LHS
    2128314368U, // <1,0,2,2>: Cost 2 ins <u,0,2,2>, lane 0
    2087002117U, // <1,0,2,3>: Cost 2 ins <1,0,u,u>, lane 5
    2689745100U, // <1,0,2,4>: Cost 3 vext3 <0,u,1,1>, <0,2,4,6>
    2970798548U, // <1,0,2,5>: Cost 3 vzipr <3,0,1,2>, <3,4,0,5>
    3165593601U, // <1,0,2,6>: Cost 3 ins <1,u,2,6>, lane 1
    2592625730U, // <1,0,2,7>: Cost 3 vext1 <7,1,0,2>, <7,1,0,2>
    1819460253U, // <1,0,2,u>: Cost 2 vzipl <1,2,3,0>, LHS
    2014101504U, // <1,0,3,0>: Cost 2 vtrnr LHS, <0,0,0,0>
    2014101514U, // <1,0,3,1>: Cost 2 vtrnr LHS, <0,0,1,1>
    67944550U,   // <1,0,3,2>: Cost 1 vrev LHS
    2091900929U, // <1,0,3,3>: Cost 2 ins <1,u,3,3>, lane 1
    2091909121U, // <1,0,3,4>: Cost 2 ins <1,u,3,4>, lane 1
    2086633475U, // <1,0,3,5>: Cost 2 ins <1,0,3,u>, lane 3
    2086633475U, // <1,0,3,6>: Cost 2 ins <1,0,3,u>, lane 3
    2091933697U, // <1,0,3,7>: Cost 2 ins <1,u,3,7>, lane 1
    68386972U,   // <1,0,3,u>: Cost 1 vrev LHS
    2667752338U, // <1,0,4,0>: Cost 3 vext2 <u,4,1,0>, <4,0,5,1>
    2689745234U, // <1,0,4,1>: Cost 3 vext3 <0,u,1,1>, <0,4,1,5>
    2086952962U, // <1,0,4,2>: Cost 2 ins <1,0,u,2>, lane 2
    2819383641U, // <1,0,4,3>: Cost 3 vuzpr <0,1,2,0>, <0,4,2,3>
    2894569810U, // <1,0,4,4>: Cost 3 vzipl <1,4,3,5>, <0,4,1,5>
    2087002117U, // <1,0,4,5>: Cost 2 ins <1,0,u,u>, lane 5
    2758102326U, // <1,0,4,6>: Cost 3 vuzpl <1,1,0,0>, RHS
    2819386597U, // <1,0,4,7>: Cost 3 vuzpr <0,1,2,0>, <4,4,6,7>
    2086952962U, // <1,0,4,u>: Cost 2 ins <1,0,u,2>, lane 2
    2955558912U, // <1,0,5,0>: Cost 3 vzipr <0,4,1,5>, <0,0,0,0>
    1821507686U, // <1,0,5,1>: Cost 2 vzipl <1,5,3,7>, LHS
    1954545766U, // <1,0,5,2>: Cost 2 vtrnl <1,3,5,7>, LHS
    3165790209U, // <1,0,5,3>: Cost 3 ins <1,u,5,3>, lane 1
    1141850234U, // <1,0,5,4>: Cost 2 vrev <0,1,4,5>
    3165806593U, // <1,0,5,5>: Cost 3 ins <1,u,5,5>, lane 1
    3202310144U, // <1,0,5,6>: Cost 3 ins <u,0,5,6>, lane 0
    2092081153U, // <1,0,5,7>: Cost 2 ins <1,u,5,7>, lane 1
    1954545820U, // <1,0,5,u>: Cost 2 vtrnl <1,3,5,7>, LHS
    3202334720U, // <1,0,6,0>: Cost 3 ins <u,0,6,0>, lane 0
    2895765606U, // <1,0,6,1>: Cost 3 vzipl <1,6,1,7>, LHS
    2128609280U, // <1,0,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    2819383803U, // <1,0,6,3>: Cost 3 vuzpr <0,1,2,0>, <0,6,2,3>
    2896060754U, // <1,0,6,4>: Cost 3 vzipl <1,6,5,7>, <0,4,1,5>
    2215673988U, // <1,0,6,5>: Cost 3 vrev <0,1,5,6>
    3165888513U, // <1,0,6,6>: Cost 3 ins <1,u,6,6>, lane 1
    2087002117U, // <1,0,6,7>: Cost 2 ins <1,0,u,u>, lane 5
    2128609280U, // <1,0,6,u>: Cost 2 ins <u,0,6,2>, lane 0
    2659128312U, // <1,0,7,0>: Cost 3 vext2 <7,0,1,0>, <7,0,1,0>
    2974156454U, // <1,0,7,1>: Cost 3 vzipr <3,5,1,7>, <2,3,0,1>
    2086952962U, // <1,0,7,2>: Cost 2 ins <1,0,u,2>, lane 2
    2861265024U, // <1,0,7,3>: Cost 3 vuzpr <7,1,3,0>, <5,7,1,3>
    3202441216U, // <1,0,7,4>: Cost 3 ins <u,0,7,4>, lane 0
    3165954049U, // <1,0,7,5>: Cost 3 ins <1,u,7,5>, lane 1
    1142014094U, // <1,0,7,6>: Cost 2 vrev <0,1,6,7>
    3165970433U, // <1,0,7,7>: Cost 3 ins <1,u,7,7>, lane 1
    2086952962U, // <1,0,7,u>: Cost 2 ins <1,0,u,2>, lane 2
    2014142464U, // <1,0,u,0>: Cost 2 vtrnr LHS, <0,0,0,0>
    2014142474U, // <1,0,u,1>: Cost 2 vtrnr LHS, <0,0,1,1>
    67985515U,   // <1,0,u,2>: Cost 1 vrev LHS
    2091753473U, // <1,0,u,3>: Cost 2 ins <1,u,1,3>, lane 1
    2091909121U, // <1,0,u,4>: Cost 2 ins <1,u,3,4>, lane 1
    2086633475U, // <1,0,u,5>: Cost 2 ins <1,0,3,u>, lane 3
    2086633475U, // <1,0,u,6>: Cost 2 ins <1,0,3,u>, lane 3
    2091933697U, // <1,0,u,7>: Cost 2 ins <1,u,3,7>, lane 1
    68427937U,   // <1,0,u,u>: Cost 1 vrev LHS
    1818149622U, // <1,1,0,0>: Cost 2 vzipl <1,0,3,2>, <1,0,3,2>
    1548894310U, // <1,1,0,1>: Cost 2 vext2 <0,u,1,1>, LHS
    1684439142U, // <1,1,0,2>: Cost 2 vuzpl <1,1,1,1>, LHS
    2087624706U, // <1,1,0,3>: Cost 2 ins <1,1,u,3>, lane 2
    2622636370U, // <1,1,0,4>: Cost 3 vext2 <0,u,1,1>, <0,4,1,5>
    2891891856U, // <1,1,0,5>: Cost 3 vzipl <1,0,3,2>, <1,5,3,7>
    3161391106U, // <1,1,0,6>: Cost 3 ins <1,1,u,6>, lane 2
    3161399298U, // <1,1,0,7>: Cost 3 ins <1,1,u,7>, lane 2
    1548894866U, // <1,1,0,u>: Cost 2 vext2 <0,u,1,1>, <0,u,1,1>
    1483112550U, // <1,1,1,0>: Cost 2 vext1 <1,1,1,1>, LHS
    202162278U,  // <1,1,1,1>: Cost 1 vdup1 LHS
    2087149571U, // <1,1,1,2>: Cost 2 ins <1,1,1,u>, lane 3
    1751548006U, // <1,1,1,3>: Cost 2 vuzpr <1,1,1,1>, LHS
    1483115830U, // <1,1,1,4>: Cost 2 vext1 <1,1,1,1>, RHS
    2087149571U, // <1,1,1,5>: Cost 2 ins <1,1,1,u>, lane 3
    2087149571U, // <1,1,1,6>: Cost 2 ins <1,1,1,u>, lane 3
    2087149571U, // <1,1,1,7>: Cost 2 ins <1,1,1,u>, lane 3
    202162278U,  // <1,1,1,u>: Cost 1 vdup1 LHS
    2128961536U, // <1,1,2,0>: Cost 2 ins <u,1,2,0>, lane 0
    2128969728U, // <1,1,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    1819460502U, // <1,1,2,2>: Cost 2 vzipl <1,2,3,0>, <1,2,3,0>
    1055244288U, // <1,1,2,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <1,1,2,4>: Cost 2 ins <u,1,2,4>, lane 0
    2129002496U, // <1,1,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2129010688U, // <1,1,2,6>: Cost 2 ins <u,1,2,6>, lane 0
    2129018880U, // <1,1,2,7>: Cost 2 ins <u,1,2,7>, lane 0
    1055244288U, // <1,1,2,u>: Cost 1 ins LHS, lane 0
    2091876353U, // <1,1,3,0>: Cost 2 ins <1,u,3,0>, lane 1
    2014102324U, // <1,1,3,1>: Cost 2 vtrnr LHS, <1,1,1,1>
    2091892737U, // <1,1,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    940359782U,  // <1,1,3,3>: Cost 1 vtrnr LHS, LHS
    2091909121U, // <1,1,3,4>: Cost 2 ins <1,u,3,4>, lane 1
    2087297027U, // <1,1,3,5>: Cost 2 ins <1,1,3,u>, lane 3
    2087297027U, // <1,1,3,6>: Cost 2 ins <1,1,3,u>, lane 3
    2091933697U, // <1,1,3,7>: Cost 2 ins <1,u,3,7>, lane 1
    940359787U,  // <1,1,3,u>: Cost 1 vtrnr LHS, LHS
    2556878950U, // <1,1,4,0>: Cost 3 vext1 <1,1,1,4>, LHS
    2087608322U, // <1,1,4,1>: Cost 2 ins <1,1,u,1>, lane 2
    2894496662U, // <1,1,4,2>: Cost 3 vzipl <1,4,2,5>, <1,2,3,0>
    2087624706U, // <1,1,4,3>: Cost 2 ins <1,1,u,3>, lane 2
    2014109799U, // <1,1,4,4>: Cost 2 vtrnr <0,1,2,4>, <0,1,2,4>
    1548897590U, // <1,1,4,5>: Cost 2 vext2 <0,u,1,1>, RHS
    1684442422U, // <1,1,4,6>: Cost 2 vuzpl <1,1,1,1>, RHS
    3161399298U, // <1,1,4,7>: Cost 3 ins <1,1,u,7>, lane 2
    1548897833U, // <1,1,4,u>: Cost 2 vext2 <0,u,1,1>, RHS
    3028288624U, // <1,1,5,0>: Cost 3 vtrnl <1,3,5,7>, <1,5,0,2>
    2087608322U, // <1,1,5,1>: Cost 2 ins <1,1,u,1>, lane 2
    2955561110U, // <1,1,5,2>: Cost 3 vzipr <0,4,1,5>, <3,0,1,2>
    2087624706U, // <1,1,5,3>: Cost 2 ins <1,1,u,3>, lane 2
    2955558925U, // <1,1,5,4>: Cost 3 vzipr <0,4,1,5>, <0,0,1,4>
    1881817426U, // <1,1,5,5>: Cost 2 vzipr <0,4,1,5>, <0,4,1,5>
    2670415970U, // <1,1,5,6>: Cost 3 vext2 <u,u,1,1>, <5,6,7,0>
    1751551286U, // <1,1,5,7>: Cost 2 vuzpr <1,1,1,1>, RHS
    1751551287U, // <1,1,5,u>: Cost 2 vuzpr <1,1,1,1>, RHS
    3165839361U, // <1,1,6,0>: Cost 3 ins <1,u,6,0>, lane 1
    2087608322U, // <1,1,6,1>: Cost 2 ins <1,1,u,1>, lane 2
    2973485206U, // <1,1,6,2>: Cost 3 vzipr <3,4,1,6>, <3,0,1,2>
    2087624706U, // <1,1,6,3>: Cost 2 ins <1,1,u,3>, lane 2
    2221572948U, // <1,1,6,4>: Cost 3 vrev <1,1,4,6>
    2955567442U, // <1,1,6,5>: Cost 3 vzipr <0,4,1,6>, <0,4,1,5>
    2014126185U, // <1,1,6,6>: Cost 2 vtrnr <0,1,2,6>, <0,1,2,6>
    2087665669U, // <1,1,6,7>: Cost 2 ins <1,1,u,u>, lane 5
    2087624706U, // <1,1,6,u>: Cost 2 ins <1,1,u,3>, lane 2
    2670416890U, // <1,1,7,0>: Cost 3 vext2 <u,u,1,1>, <7,0,1,2>
    2087608322U, // <1,1,7,1>: Cost 2 ins <1,1,u,1>, lane 2
    3203088384U, // <1,1,7,2>: Cost 3 ins <u,1,7,2>, lane 0
    2129354752U, // <1,1,7,3>: Cost 2 ins <u,1,7,3>, lane 0
    2670417254U, // <1,1,7,4>: Cost 3 vext2 <u,u,1,1>, <7,4,5,6>
    2221654878U, // <1,1,7,5>: Cost 3 vrev <1,1,5,7>
    3161391106U, // <1,1,7,6>: Cost 3 ins <1,1,u,6>, lane 2
    2014134378U, // <1,1,7,7>: Cost 2 vtrnr <0,1,2,7>, <0,1,2,7>
    2129354752U, // <1,1,7,u>: Cost 2 ins <u,1,7,3>, lane 0
    1818149622U, // <1,1,u,0>: Cost 2 vzipl <1,0,3,2>, <1,0,3,2>
    202162278U,  // <1,1,u,1>: Cost 1 vdup1 LHS
    1684444974U, // <1,1,u,2>: Cost 2 vuzpl <1,1,1,1>, LHS
    940400742U,  // <1,1,u,3>: Cost 1 vtrnr LHS, LHS
    1483115830U, // <1,1,u,4>: Cost 2 vext1 <1,1,1,1>, RHS
    1548900506U, // <1,1,u,5>: Cost 2 vext2 <0,u,1,1>, RHS
    1684445338U, // <1,1,u,6>: Cost 2 vuzpl <1,1,1,1>, RHS
    1751551529U, // <1,1,u,7>: Cost 2 vuzpr <1,1,1,1>, RHS
    940400747U,  // <1,1,u,u>: Cost 1 vtrnr LHS, LHS
    2088263682U, // <1,2,0,0>: Cost 2 ins <1,2,u,0>, lane 2
    1561509990U, // <1,2,0,1>: Cost 2 vext2 <3,0,1,2>, LHS
    2129494016U, // <1,2,0,2>: Cost 2 ins <u,2,0,2>, lane 0
    2954854502U, // <1,2,0,3>: Cost 3 vzipr <0,3,1,0>, LHS
    2088296450U, // <1,2,0,4>: Cost 2 ins <1,2,u,4>, lane 2
    3165437953U, // <1,2,0,5>: Cost 3 ins <1,u,0,5>, lane 1
    2891892666U, // <1,2,0,6>: Cost 3 vzipl <1,0,3,2>, <2,6,3,7>
    2659140170U, // <1,2,0,7>: Cost 3 vext2 <7,0,1,2>, <0,7,2,1>
    1561510557U, // <1,2,0,u>: Cost 2 vext2 <3,0,1,2>, LHS
    2088263682U, // <1,2,1,0>: Cost 2 ins <1,2,u,0>, lane 2
    2091737089U, // <1,2,1,1>: Cost 2 ins <1,u,1,1>, lane 1
    1745657957U, // <1,2,1,2>: Cost 2 vuzpr <0,1,2,2>, <0,1,2,2>
    1884438630U, // <1,2,1,3>: Cost 2 vzipr <0,u,1,1>, LHS
    2088296450U, // <1,2,1,4>: Cost 2 ins <1,2,u,4>, lane 2
    2635252880U, // <1,2,1,5>: Cost 3 vext2 <3,0,1,2>, <1,5,3,7>
    2958180700U, // <1,2,1,6>: Cost 3 vzipr <0,u,1,1>, <0,4,2,6>
    3165528065U, // <1,2,1,7>: Cost 3 ins <1,u,1,7>, lane 1
    1884438635U, // <1,2,1,u>: Cost 2 vzipr <0,u,1,1>, LHS
    2088263682U, // <1,2,2,0>: Cost 2 ins <1,2,u,0>, lane 2
    2893235754U, // <1,2,2,1>: Cost 3 vzipl <1,2,3,4>, <2,1,4,3>
    2129641472U, // <1,2,2,2>: Cost 2 ins <u,2,2,2>, lane 0
    1897054310U, // <1,2,2,3>: Cost 2 vzipr <3,0,1,2>, LHS
    2088296450U, // <1,2,2,4>: Cost 2 ins <1,2,u,4>, lane 2
    3165585409U, // <1,2,2,5>: Cost 3 ins <1,u,2,5>, lane 1
    2893203386U, // <1,2,2,6>: Cost 3 vzipl <1,2,3,0>, <2,6,3,7>
    2994684010U, // <1,2,2,7>: Cost 3 vzipr <7,0,1,2>, <0,1,2,7>
    1897054315U, // <1,2,2,u>: Cost 2 vzipr <3,0,1,2>, LHS
    403488870U,  // <1,2,3,0>: Cost 1 vext1 LHS, LHS
    1477231350U, // <1,2,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
    1477232232U, // <1,2,3,2>: Cost 2 vext1 LHS, <2,2,2,2>
    1477233052U, // <1,2,3,3>: Cost 2 vext1 LHS, <3,3,3,3>
    403492150U,  // <1,2,3,4>: Cost 1 vext1 LHS, RHS
    1525010128U, // <1,2,3,5>: Cost 2 vext1 LHS, <5,1,7,3>
    2014101708U, // <1,2,3,6>: Cost 2 vtrnr LHS, <0,2,4,6>
    1525011450U, // <1,2,3,7>: Cost 2 vext1 LHS, <7,0,1,2>
    403494702U,  // <1,2,3,u>: Cost 1 vext1 LHS, LHS
    2088263682U, // <1,2,4,0>: Cost 2 ins <1,2,u,0>, lane 2
    3162013698U, // <1,2,4,1>: Cost 3 ins <1,2,u,1>, lane 2
    3162021890U, // <1,2,4,2>: Cost 3 ins <1,2,u,2>, lane 2
    2954887270U, // <1,2,4,3>: Cost 3 vzipr <0,3,1,4>, LHS
    2088296450U, // <1,2,4,4>: Cost 2 ins <1,2,u,4>, lane 2
    1561513270U, // <1,2,4,5>: Cost 2 vext2 <3,0,1,2>, RHS
    2129821696U, // <1,2,4,6>: Cost 2 ins <u,2,4,6>, lane 0
    2659143112U, // <1,2,4,7>: Cost 3 vext2 <7,0,1,2>, <4,7,5,0>
    1561513513U, // <1,2,4,u>: Cost 2 vext2 <3,0,1,2>, RHS
    2088263682U, // <1,2,5,0>: Cost 2 ins <1,2,u,0>, lane 2
    2550989824U, // <1,2,5,1>: Cost 3 vext1 <0,1,2,5>, <1,3,5,7>
    2955558932U, // <1,2,5,2>: Cost 3 vzipr <0,4,1,5>, <0,0,2,2>
    1881817190U, // <1,2,5,3>: Cost 2 vzipr <0,4,1,5>, LHS
    2088296450U, // <1,2,5,4>: Cost 2 ins <1,2,u,4>, lane 2
    2659143684U, // <1,2,5,5>: Cost 3 vext2 <7,0,1,2>, <5,5,5,5>
    2955559260U, // <1,2,5,6>: Cost 3 vzipr <0,4,1,5>, <0,4,2,6>
    2092081153U, // <1,2,5,7>: Cost 2 ins <1,u,5,7>, lane 1
    1881817195U, // <1,2,5,u>: Cost 2 vzipr <0,4,1,5>, LHS
    2088263682U, // <1,2,6,0>: Cost 2 ins <1,2,u,0>, lane 2
    3162013698U, // <1,2,6,1>: Cost 3 ins <1,2,u,1>, lane 2
    2659144186U, // <1,2,6,2>: Cost 3 vext2 <7,0,1,2>, <6,2,7,3>
    2954240102U, // <1,2,6,3>: Cost 3 vzipr <0,2,1,6>, LHS
    2088296450U, // <1,2,6,4>: Cost 2 ins <1,2,u,4>, lane 2
    3162046466U, // <1,2,6,5>: Cost 3 ins <1,2,u,5>, lane 2
    2895914938U, // <1,2,6,6>: Cost 3 vzipl <1,6,3,7>, <2,6,3,7>
    2088329221U, // <1,2,6,7>: Cost 2 ins <1,2,u,u>, lane 5
    2088263682U, // <1,2,6,u>: Cost 2 ins <1,2,u,0>, lane 2
    1585402874U, // <1,2,7,0>: Cost 2 vext2 <7,0,1,2>, <7,0,1,2>
    3203743744U, // <1,2,7,1>: Cost 3 ins <u,2,7,1>, lane 0
    3203751936U, // <1,2,7,2>: Cost 3 ins <u,2,7,2>, lane 0
    2130018304U, // <1,2,7,3>: Cost 2 ins <u,2,7,3>, lane 0
    2088296450U, // <1,2,7,4>: Cost 2 ins <1,2,u,4>, lane 2
    3203776512U, // <1,2,7,5>: Cost 3 ins <u,2,7,5>, lane 0
    3203784704U, // <1,2,7,6>: Cost 3 ins <u,2,7,6>, lane 0
    2659145255U, // <1,2,7,7>: Cost 3 vext2 <7,0,1,2>, <7,7,0,1>
    1590711938U, // <1,2,7,u>: Cost 2 vext2 <7,u,1,2>, <7,u,1,2>
    403529835U,  // <1,2,u,0>: Cost 1 vext1 LHS, LHS
    1477272310U, // <1,2,u,1>: Cost 2 vext1 LHS, <1,0,3,2>
    1477273192U, // <1,2,u,2>: Cost 2 vext1 LHS, <2,2,2,2>
    1477273750U, // <1,2,u,3>: Cost 2 vext1 LHS, <3,0,1,2>
    403533110U,  // <1,2,u,4>: Cost 1 vext1 LHS, RHS
    1561516186U, // <1,2,u,5>: Cost 2 vext2 <3,0,1,2>, RHS
    2014142668U, // <1,2,u,6>: Cost 2 vtrnr LHS, <0,2,4,6>
    1525052410U, // <1,2,u,7>: Cost 2 vext1 LHS, <7,0,1,2>
    403535662U,  // <1,2,u,u>: Cost 1 vext1 LHS, LHS
    1745666048U, // <1,3,0,0>: Cost 2 vuzpr LHS, <0,0,0,0>
    1746108426U, // <1,3,0,1>: Cost 2 vuzpr LHS, <0,0,1,1>
    1745666806U, // <1,3,0,2>: Cost 2 vuzpr LHS, <1,0,3,2>
    2088951810U, // <1,3,0,3>: Cost 2 ins <1,3,u,3>, lane 2
    2819850253U, // <1,3,0,4>: Cost 3 vuzpr LHS, <0,0,1,4>
    2758984055U, // <1,3,0,5>: Cost 3 vuzpl <1,2,3,0>, <0,4,5,6>
    2867183658U, // <1,3,0,6>: Cost 3 vuzpr LHS, <0,0,4,6>
    2088984578U, // <1,3,0,7>: Cost 2 ins <1,3,u,7>, lane 2
    1745668252U, // <1,3,0,u>: Cost 2 vuzpr LHS, <3,0,1,u>
    2088476675U, // <1,3,1,0>: Cost 2 ins <1,3,1,u>, lane 3
    1745666868U, // <1,3,1,1>: Cost 2 vuzpr LHS, <1,1,1,1>
    2088476675U, // <1,3,1,2>: Cost 2 ins <1,3,1,u>, lane 3
    671924326U,  // <1,3,1,3>: Cost 1 vuzpr LHS, LHS
    2088476675U, // <1,3,1,4>: Cost 2 ins <1,3,1,u>, lane 3
    2088476675U, // <1,3,1,5>: Cost 2 ins <1,3,1,u>, lane 3
    2088476675U, // <1,3,1,6>: Cost 2 ins <1,3,1,u>, lane 3
    2088984578U, // <1,3,1,7>: Cost 2 ins <1,3,u,7>, lane 2
    671924331U,  // <1,3,1,u>: Cost 1 vuzpr LHS, LHS
    1745666966U, // <1,3,2,0>: Cost 2 vuzpr LHS, <1,2,3,0>
    2819408044U, // <1,3,2,1>: Cost 3 vuzpr LHS, <0,2,1,1>
    1745666212U, // <1,3,2,2>: Cost 2 vuzpr LHS, <0,2,0,2>
    1746110066U, // <1,3,2,3>: Cost 2 vuzpr LHS, <2,2,3,3>
    1745666970U, // <1,3,2,4>: Cost 2 vuzpr LHS, <1,2,3,4>
    2819408066U, // <1,3,2,5>: Cost 3 vuzpr LHS, <0,2,3,5>
    1745666252U, // <1,3,2,6>: Cost 2 vuzpr LHS, <0,2,4,6>
    2088984578U, // <1,3,2,7>: Cost 2 ins <1,3,u,7>, lane 2
    1745666218U, // <1,3,2,u>: Cost 2 vuzpr LHS, <0,2,0,u>
    1483276390U, // <1,3,3,0>: Cost 2 vext1 <1,1,3,3>, LHS
    1745667750U, // <1,3,3,1>: Cost 2 vuzpr LHS, <2,3,0,1>
    2091892737U, // <1,3,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    1745667032U, // <1,3,3,3>: Cost 2 vuzpr LHS, <1,3,1,3>
    1483279670U, // <1,3,3,4>: Cost 2 vext1 <1,1,3,3>, RHS
    1745667790U, // <1,3,3,5>: Cost 2 vuzpr LHS, <2,3,4,5>
    2819408868U, // <1,3,3,6>: Cost 3 vuzpr LHS, <1,3,2,6>
    2014102528U, // <1,3,3,7>: Cost 2 vtrnr LHS, <1,3,5,7>
    1745667037U, // <1,3,3,u>: Cost 2 vuzpr LHS, <1,3,1,u>
    2568970342U, // <1,3,4,0>: Cost 3 vext1 <3,1,3,4>, LHS
    2759019375U, // <1,3,4,1>: Cost 3 vuzpl <1,2,3,4>, <4,0,1,2>
    2759019466U, // <1,3,4,2>: Cost 3 vuzpl <1,2,3,4>, <4,1,2,3>
    2088951810U, // <1,3,4,3>: Cost 2 ins <1,3,u,3>, lane 2
    1793445072U, // <1,3,4,4>: Cost 2 vuzpr LHS, <4,4,4,4>
    1746108754U, // <1,3,4,5>: Cost 2 vuzpr LHS, <0,4,1,5>
    1745668610U, // <1,3,4,6>: Cost 2 vuzpr LHS, <3,4,5,6>
    2088984578U, // <1,3,4,7>: Cost 2 ins <1,3,u,7>, lane 2
    1745668612U, // <1,3,4,u>: Cost 2 vuzpr LHS, <3,4,5,u>
    2088771587U, // <1,3,5,0>: Cost 2 ins <1,3,5,u>, lane 3
    2088771587U, // <1,3,5,1>: Cost 2 ins <1,3,5,u>, lane 3
    2088771587U, // <1,3,5,2>: Cost 2 ins <1,3,5,u>, lane 3
    2088951810U, // <1,3,5,3>: Cost 2 ins <1,3,u,3>, lane 2
    2088771587U, // <1,3,5,4>: Cost 2 ins <1,3,5,u>, lane 3
    1793445892U, // <1,3,5,5>: Cost 2 vuzpr LHS, <5,5,5,5>
    2088771587U, // <1,3,5,6>: Cost 2 ins <1,3,5,u>, lane 3
    671927606U,  // <1,3,5,7>: Cost 1 vuzpr LHS, RHS
    671927607U,  // <1,3,5,u>: Cost 1 vuzpr LHS, RHS
    1793445986U, // <1,3,6,0>: Cost 2 vuzpr LHS, <5,6,7,0>
    2867185561U, // <1,3,6,1>: Cost 3 vuzpr LHS, <2,6,0,1>
    1793445196U, // <1,3,6,2>: Cost 2 vuzpr LHS, <4,6,0,2>
    2088951810U, // <1,3,6,3>: Cost 2 ins <1,3,u,3>, lane 2
    1793445990U, // <1,3,6,4>: Cost 2 vuzpr LHS, <5,6,7,4>
    2849642738U, // <1,3,6,5>: Cost 3 vuzpr <5,1,7,3>, <u,6,7,5>
    1793445236U, // <1,3,6,6>: Cost 2 vuzpr LHS, <4,6,4,6>
    1746110394U, // <1,3,6,7>: Cost 2 vuzpr LHS, <2,6,3,7>
    1746110395U, // <1,3,6,u>: Cost 2 vuzpr LHS, <2,6,3,u>
    2706926275U, // <1,3,7,0>: Cost 3 vext3 <3,7,0,1>, <3,7,0,1>
    1793446734U, // <1,3,7,1>: Cost 2 vuzpr LHS, <6,7,0,1>
    2867187830U, // <1,3,7,2>: Cost 3 vuzpr LHS, <5,7,0,2>
    1793446016U, // <1,3,7,3>: Cost 2 vuzpr LHS, <5,7,1,3>
    2849637679U, // <1,3,7,4>: Cost 3 vuzpr <5,1,7,3>, <1,7,3,4>
    1793446774U, // <1,3,7,5>: Cost 2 vuzpr LHS, <6,7,4,5>
    2867185674U, // <1,3,7,6>: Cost 3 vuzpr LHS, <2,7,3,6>
    1793446056U, // <1,3,7,7>: Cost 2 vuzpr LHS, <5,7,5,7>
    1793446021U, // <1,3,7,u>: Cost 2 vuzpr LHS, <5,7,1,u>
    1746109820U, // <1,3,u,0>: Cost 2 vuzpr LHS, <1,u,3,0>
    2014144166U, // <1,3,u,1>: Cost 2 vtrnr LHS, <2,3,0,1>
    1745668894U, // <1,3,u,2>: Cost 2 vuzpr LHS, <3,u,1,2>
    671924893U,  // <1,3,u,3>: Cost 1 vuzpr LHS, LHS
    1746109824U, // <1,3,u,4>: Cost 2 vuzpr LHS, <1,u,3,4>
    2014144206U, // <1,3,u,5>: Cost 2 vtrnr LHS, <2,3,4,5>
    1745668934U, // <1,3,u,6>: Cost 2 vuzpr LHS, <3,u,5,6>
    671927849U,  // <1,3,u,7>: Cost 1 vuzpr LHS, RHS
    671924898U,  // <1,3,u,u>: Cost 1 vuzpr LHS, LHS
    3165396993U, // <1,4,0,0>: Cost 3 ins <1,u,0,0>, lane 1
    2619342950U, // <1,4,0,1>: Cost 3 vext2 <0,3,1,4>, LHS
    2758434918U, // <1,4,0,2>: Cost 3 vuzpl <1,1,4,5>, LHS
    2619343104U, // <1,4,0,3>: Cost 3 vext2 <0,3,1,4>, <0,3,1,4>
    3165429761U, // <1,4,0,4>: Cost 3 ins <1,u,0,4>, lane 1
    1818152246U, // <1,4,0,5>: Cost 2 vzipl <1,0,3,2>, RHS
    3026537782U, // <1,4,0,6>: Cost 3 vtrnl <1,1,0,0>, RHS
    3162808323U, // <1,4,0,7>: Cost 3 ins <1,4,0,u>, lane 3
    1818152489U, // <1,4,0,u>: Cost 2 vzipl <1,0,3,2>, RHS
    3204620288U, // <1,4,1,0>: Cost 3 ins <u,4,1,0>, lane 0
    2091737089U, // <1,4,1,1>: Cost 2 ins <1,u,1,1>, lane 1
    3204636672U, // <1,4,1,2>: Cost 3 ins <u,4,1,2>, lane 0
    2091753473U, // <1,4,1,3>: Cost 2 ins <1,u,1,3>, lane 1
    1745674343U, // <1,4,1,4>: Cost 2 vuzpr <0,1,2,4>, <0,1,2,4>
    1818660150U, // <1,4,1,5>: Cost 2 vzipl <1,1,1,1>, RHS
    1952877878U, // <1,4,1,6>: Cost 2 vtrnl <1,1,1,1>, RHS
    3165528065U, // <1,4,1,7>: Cost 3 ins <1,u,1,7>, lane 1
    1818660393U, // <1,4,1,u>: Cost 2 vzipl <1,1,1,1>, RHS
    2893237103U, // <1,4,2,0>: Cost 3 vzipl <1,2,3,4>, <4,0,1,2>
    2893237194U, // <1,4,2,1>: Cost 3 vzipl <1,2,3,4>, <4,1,2,3>
    3165560833U, // <1,4,2,2>: Cost 3 ins <1,u,2,2>, lane 1
    2130976768U, // <1,4,2,3>: Cost 2 ins <u,4,2,3>, lane 0
    2893237467U, // <1,4,2,4>: Cost 3 vzipl <1,2,3,4>, <4,4,5,6>
    1819462966U, // <1,4,2,5>: Cost 2 vzipl <1,2,3,0>, RHS
    2131001344U, // <1,4,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    3165601793U, // <1,4,2,7>: Cost 3 ins <1,u,2,7>, lane 1
    1819463209U, // <1,4,2,u>: Cost 2 vzipl <1,2,3,0>, RHS
    2091876353U, // <1,4,3,0>: Cost 2 ins <1,u,3,0>, lane 1
    3027454831U, // <1,4,3,1>: Cost 3 vtrnl <1,2,3,4>, <4,0,1,2>
    2091892737U, // <1,4,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    2091900929U, // <1,4,3,3>: Cost 2 ins <1,u,3,3>, lane 1
    2061880528U, // <1,4,3,4>: Cost 2 vtrnr LHS, <4,4,4,4>
    2014101842U, // <1,4,3,5>: Cost 2 vtrnr LHS, <0,4,1,5>
    2014101852U, // <1,4,3,6>: Cost 2 vtrnr LHS, <0,4,2,6>
    2091933697U, // <1,4,3,7>: Cost 2 ins <1,u,3,7>, lane 1
    2014101845U, // <1,4,3,u>: Cost 2 vtrnr LHS, <0,4,1,u>
    2557100134U, // <1,4,4,0>: Cost 3 vext1 <1,1,4,4>, LHS
    2557100882U, // <1,4,4,1>: Cost 3 vext1 <1,1,4,4>, <1,1,4,4>
    3165708289U, // <1,4,4,2>: Cost 3 ins <1,u,4,2>, lane 1
    2819416409U, // <1,4,4,3>: Cost 3 vuzpr <0,1,2,4>, <0,4,2,3>
    2131132416U, // <1,4,4,4>: Cost 2 ins <u,4,4,4>, lane 0
    2619346230U, // <1,4,4,5>: Cost 3 vext2 <0,3,1,4>, RHS
    2758438198U, // <1,4,4,6>: Cost 3 vuzpl <1,1,4,5>, RHS
    2819419365U, // <1,4,4,7>: Cost 3 vuzpr <0,1,2,4>, <4,4,6,7>
    2131132416U, // <1,4,4,u>: Cost 2 ins <u,4,4,4>, lane 0
    1477394554U, // <1,4,5,0>: Cost 2 vext1 <0,1,4,5>, <0,1,4,5>
    2955558949U, // <1,4,5,1>: Cost 3 vzipr <0,4,1,5>, <0,0,4,1>
    3204931584U, // <1,4,5,2>: Cost 3 ins <u,4,5,2>, lane 0
    3165790209U, // <1,4,5,3>: Cost 3 ins <1,u,5,3>, lane 1
    1477397814U, // <1,4,5,4>: Cost 2 vext1 <0,1,4,5>, RHS
    1821510966U, // <1,4,5,5>: Cost 2 vzipl <1,5,3,7>, RHS
    1616006454U, // <1,4,5,6>: Cost 2 vext3 <0,u,1,1>, RHS
    2092081153U, // <1,4,5,7>: Cost 2 ins <1,u,5,7>, lane 1
    1616006472U, // <1,4,5,u>: Cost 2 vext3 <0,u,1,1>, RHS
    2557116518U, // <1,4,6,0>: Cost 3 vext1 <1,1,4,6>, LHS
    2557117268U, // <1,4,6,1>: Cost 3 vext1 <1,1,4,6>, <1,1,4,6>
    3165855745U, // <1,4,6,2>: Cost 3 ins <1,u,6,2>, lane 1
    2569062662U, // <1,4,6,3>: Cost 3 vext1 <3,1,4,6>, <3,1,4,6>
    2557119798U, // <1,4,6,4>: Cost 3 vext1 <1,1,4,6>, RHS
    2895768886U, // <1,4,6,5>: Cost 3 vzipl <1,6,1,7>, RHS
    2131296256U, // <1,4,6,6>: Cost 2 ins <u,4,6,6>, lane 0
    2131304448U, // <1,4,6,7>: Cost 2 ins <u,4,6,7>, lane 0
    2131296256U, // <1,4,6,u>: Cost 2 ins <u,4,6,6>, lane 0
    2659161084U, // <1,4,7,0>: Cost 3 vext2 <7,0,1,4>, <7,0,1,4>
    3165921281U, // <1,4,7,1>: Cost 3 ins <1,u,7,1>, lane 1
    3205079040U, // <1,4,7,2>: Cost 3 ins <u,4,7,2>, lane 0
    2861297792U, // <1,4,7,3>: Cost 3 vuzpr <7,1,3,4>, <5,7,1,3>
    2669778278U, // <1,4,7,4>: Cost 3 vext2 <u,7,1,4>, <7,4,5,6>
    3205103616U, // <1,4,7,5>: Cost 3 ins <u,4,7,5>, lane 0
    2131369984U, // <1,4,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    3165970433U, // <1,4,7,7>: Cost 3 ins <1,u,7,7>, lane 1
    2131369984U, // <1,4,7,u>: Cost 2 ins <u,4,7,6>, lane 0
    2091876353U, // <1,4,u,0>: Cost 2 ins <1,u,3,0>, lane 1
    2091737089U, // <1,4,u,1>: Cost 2 ins <1,u,1,1>, lane 1
    2091892737U, // <1,4,u,2>: Cost 2 ins <1,u,3,2>, lane 1
    2091753473U, // <1,4,u,3>: Cost 2 ins <1,u,1,3>, lane 1
    2061921488U, // <1,4,u,4>: Cost 2 vtrnr LHS, <4,4,4,4>
    2014142802U, // <1,4,u,5>: Cost 2 vtrnr LHS, <0,4,1,5>
    2014142812U, // <1,4,u,6>: Cost 2 vtrnr LHS, <0,4,2,6>
    2091933697U, // <1,4,u,7>: Cost 2 ins <1,u,3,7>, lane 1
    2014142805U, // <1,4,u,u>: Cost 2 vtrnr LHS, <0,4,1,u>
    2620014592U, // <1,5,0,0>: Cost 3 vext2 <0,4,1,5>, <0,0,0,0>
    1546272870U, // <1,5,0,1>: Cost 2 vext2 <0,4,1,5>, LHS
    1686110310U, // <1,5,0,2>: Cost 2 vuzpl <1,3,5,7>, LHS
    3163471875U, // <1,5,0,3>: Cost 3 ins <1,5,0,u>, lane 3
    1546273106U, // <1,5,0,4>: Cost 2 vext2 <0,4,1,5>, <0,4,1,5>
    3165437953U, // <1,5,0,5>: Cost 3 ins <1,u,0,5>, lane 1
    3164045314U, // <1,5,0,6>: Cost 3 ins <1,5,u,6>, lane 2
    2090311682U, // <1,5,0,7>: Cost 2 ins <1,5,u,7>, lane 2
    1546273437U, // <1,5,0,u>: Cost 2 vext2 <0,4,1,5>, LHS
    2620015350U, // <1,5,1,0>: Cost 3 vext2 <0,4,1,5>, <1,0,3,2>
    2091737089U, // <1,5,1,1>: Cost 2 ins <1,u,1,1>, lane 1
    2620015510U, // <1,5,1,2>: Cost 3 vext2 <0,4,1,5>, <1,2,3,0>
    2091753473U, // <1,5,1,3>: Cost 2 ins <1,u,1,3>, lane 1
    2620015677U, // <1,5,1,4>: Cost 3 vext2 <0,4,1,5>, <1,4,3,5>
    1686111232U, // <1,5,1,5>: Cost 2 vuzpl <1,3,5,7>, <1,3,5,7>
    2958181456U, // <1,5,1,6>: Cost 3 vzipr <0,u,1,1>, <1,4,5,6>
    2019986742U, // <1,5,1,7>: Cost 2 vtrnr <1,1,1,1>, RHS
    2019986743U, // <1,5,1,u>: Cost 2 vtrnr <1,1,1,1>, RHS
    2759853734U, // <1,5,2,0>: Cost 3 vuzpl <1,3,5,7>, <2,3,0,1>
    2620016163U, // <1,5,2,1>: Cost 3 vext2 <0,4,1,5>, <2,1,3,5>
    2620016232U, // <1,5,2,2>: Cost 3 vext2 <0,4,1,5>, <2,2,2,2>
    2090319877U, // <1,5,2,3>: Cost 2 ins <1,5,u,u>, lane 5
    2759853774U, // <1,5,2,4>: Cost 3 vuzpl <1,3,5,7>, <2,3,4,5>
    2994687194U, // <1,5,2,5>: Cost 3 vzipr <7,0,1,2>, <4,4,5,5>
    2620016570U, // <1,5,2,6>: Cost 3 vext2 <0,4,1,5>, <2,6,3,7>
    2090311682U, // <1,5,2,7>: Cost 2 ins <1,5,u,7>, lane 2
    2090319877U, // <1,5,2,u>: Cost 2 ins <1,5,u,u>, lane 5
    2091876353U, // <1,5,3,0>: Cost 2 ins <1,u,3,0>, lane 1
    2089951235U, // <1,5,3,1>: Cost 2 ins <1,5,3,u>, lane 3
    2091892737U, // <1,5,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    2091900929U, // <1,5,3,3>: Cost 2 ins <1,u,3,3>, lane 1
    2091909121U, // <1,5,3,4>: Cost 2 ins <1,u,3,4>, lane 1
    2061881348U, // <1,5,3,5>: Cost 2 vtrnr LHS, <5,5,5,5>
    2089951235U, // <1,5,3,6>: Cost 2 ins <1,5,3,u>, lane 3
    940363062U,  // <1,5,3,7>: Cost 1 vtrnr LHS, RHS
    940363063U,  // <1,5,3,u>: Cost 1 vtrnr LHS, RHS
    2620017554U, // <1,5,4,0>: Cost 3 vext2 <0,4,1,5>, <4,0,5,1>
    2620017634U, // <1,5,4,1>: Cost 3 vext2 <0,4,1,5>, <4,1,5,0>
    3164012546U, // <1,5,4,2>: Cost 3 ins <1,5,u,2>, lane 2
    3163766787U, // <1,5,4,3>: Cost 3 ins <1,5,4,u>, lane 3
    2575092710U, // <1,5,4,4>: Cost 3 vext1 <4,1,5,4>, <4,1,5,4>
    1546276150U, // <1,5,4,5>: Cost 2 vext2 <0,4,1,5>, RHS
    1686113590U, // <1,5,4,6>: Cost 2 vuzpl <1,3,5,7>, RHS
    2090311682U, // <1,5,4,7>: Cost 2 ins <1,5,u,7>, lane 2
    1546276393U, // <1,5,4,u>: Cost 2 vext2 <0,4,1,5>, RHS
    2955561954U, // <1,5,5,0>: Cost 3 vzipr <0,4,1,5>, <4,1,5,0>
    2955561874U, // <1,5,5,1>: Cost 3 vzipr <0,4,1,5>, <4,0,5,1>
    3165782017U, // <1,5,5,2>: Cost 3 ins <1,u,5,2>, lane 1
    2955559851U, // <1,5,5,3>: Cost 3 vzipr <0,4,1,5>, <1,2,5,3>
    2955561958U, // <1,5,5,4>: Cost 3 vzipr <0,4,1,5>, <4,1,5,4>
    2131877888U, // <1,5,5,5>: Cost 2 ins <u,5,5,5>, lane 0
    2955561474U, // <1,5,5,6>: Cost 3 vzipr <0,4,1,5>, <3,4,5,6>
    2092081153U, // <1,5,5,7>: Cost 2 ins <1,u,5,7>, lane 1
    2092081153U, // <1,5,5,u>: Cost 2 ins <1,u,5,7>, lane 1
    2131910656U, // <1,5,6,0>: Cost 2 ins <u,5,6,0>, lane 0
    2131918848U, // <1,5,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2131927040U, // <1,5,6,2>: Cost 2 ins <u,5,6,2>, lane 0
    2131935232U, // <1,5,6,3>: Cost 2 ins <u,5,6,3>, lane 0
    2131943424U, // <1,5,6,4>: Cost 2 ins <u,5,6,4>, lane 0
    2131951616U, // <1,5,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    2131959808U, // <1,5,6,6>: Cost 2 ins <u,5,6,6>, lane 0
    1058226176U, // <1,5,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <1,5,6,u>: Cost 1 ins RHS, lane 0
    2557198438U, // <1,5,7,0>: Cost 3 vext1 <1,1,5,7>, LHS
    2557199198U, // <1,5,7,1>: Cost 3 vext1 <1,1,5,7>, <1,1,5,7>
    2569143974U, // <1,5,7,2>: Cost 3 vext1 <3,1,5,7>, <2,3,0,1>
    2759857248U, // <1,5,7,3>: Cost 3 vuzpl <1,3,5,7>, <7,1,3,5>
    2557201718U, // <1,5,7,4>: Cost 3 vext1 <1,1,5,7>, RHS
    2759857510U, // <1,5,7,5>: Cost 3 vuzpl <1,3,5,7>, <7,4,5,6>
    2593035086U, // <1,5,7,6>: Cost 3 vext1 <7,1,5,7>, <6,7,0,1>
    2132041728U, // <1,5,7,7>: Cost 2 ins <u,5,7,7>, lane 0
    2132041728U, // <1,5,7,u>: Cost 2 ins <u,5,7,7>, lane 0
    2091876353U, // <1,5,u,0>: Cost 2 ins <1,u,3,0>, lane 1
    1546278702U, // <1,5,u,1>: Cost 2 vext2 <0,4,1,5>, LHS
    1686116142U, // <1,5,u,2>: Cost 2 vuzpl <1,3,5,7>, LHS
    2091753473U, // <1,5,u,3>: Cost 2 ins <1,u,1,3>, lane 1
    1594054682U, // <1,5,u,4>: Cost 2 vext2 <u,4,1,5>, <u,4,1,5>
    1546279066U, // <1,5,u,5>: Cost 2 vext2 <0,4,1,5>, RHS
    1686116506U, // <1,5,u,6>: Cost 2 vuzpl <1,3,5,7>, RHS
    940404022U,  // <1,5,u,7>: Cost 1 vtrnr LHS, RHS
    940404023U,  // <1,5,u,u>: Cost 1 vtrnr LHS, RHS
    3205873664U, // <1,6,0,0>: Cost 3 ins <u,6,0,0>, lane 0
    2618695782U, // <1,6,0,1>: Cost 3 vext2 <0,2,1,6>, LHS
    2132148224U, // <1,6,0,2>: Cost 2 ins <u,6,0,2>, lane 0
    3087819259U, // <1,6,0,3>: Cost 3 vtrnr <0,1,2,0>, <0,6,2,3>
    2620023123U, // <1,6,0,4>: Cost 3 vext2 <0,4,1,6>, <0,4,1,6>
    3165437953U, // <1,6,0,5>: Cost 3 ins <1,u,0,5>, lane 1
    3164708866U, // <1,6,0,6>: Cost 3 ins <1,6,u,6>, lane 2
    2954857782U, // <1,6,0,7>: Cost 3 vzipr <0,3,1,0>, RHS
    2132148224U, // <1,6,0,u>: Cost 2 ins <u,6,0,2>, lane 0
    3205947392U, // <1,6,1,0>: Cost 3 ins <u,6,1,0>, lane 0
    2091737089U, // <1,6,1,1>: Cost 2 ins <1,u,1,1>, lane 1
    3005959068U, // <1,6,1,2>: Cost 3 vzipr <u,u,1,1>, <4,0,6,2>
    2091753473U, // <1,6,1,3>: Cost 2 ins <1,u,1,3>, lane 1
    2625995820U, // <1,6,1,4>: Cost 3 vext2 <1,4,1,6>, <1,4,1,6>
    3205988352U, // <1,6,1,5>: Cost 3 ins <u,6,1,5>, lane 0
    1745690729U, // <1,6,1,6>: Cost 2 vuzpr <0,1,2,6>, <0,1,2,6>
    1884441910U, // <1,6,1,7>: Cost 2 vzipr <0,u,1,1>, RHS
    1884441911U, // <1,6,1,u>: Cost 2 vzipr <0,u,1,1>, RHS
    2721526201U, // <1,6,2,0>: Cost 3 vext3 <6,2,0,1>, <6,2,0,1>
    2994687442U, // <1,6,2,1>: Cost 3 vzipr <7,0,1,2>, <4,7,6,1>
    2994686876U, // <1,6,2,2>: Cost 3 vzipr <7,0,1,2>, <4,0,6,2>
    2132303872U, // <1,6,2,3>: Cost 2 ins <u,6,2,3>, lane 0
    3206053888U, // <1,6,2,4>: Cost 3 ins <u,6,2,4>, lane 0
    3165585409U, // <1,6,2,5>: Cost 3 ins <1,u,2,5>, lane 1
    2618697658U, // <1,6,2,6>: Cost 3 vext2 <0,2,1,6>, <2,6,3,7>
    1897057590U, // <1,6,2,7>: Cost 2 vzipr <3,0,1,2>, RHS
    1897057591U, // <1,6,2,u>: Cost 2 vzipr <3,0,1,2>, RHS
    2061881442U, // <1,6,3,0>: Cost 2 vtrnr LHS, <5,6,7,0>
    2987396400U, // <1,6,3,1>: Cost 3 vzipr <5,7,1,3>, <4,5,6,1>
    2061880652U, // <1,6,3,2>: Cost 2 vtrnr LHS, <4,6,0,2>
    2091900929U, // <1,6,3,3>: Cost 2 ins <1,u,3,3>, lane 1
    2061881446U, // <1,6,3,4>: Cost 2 vtrnr LHS, <5,6,7,4>
    3118078194U, // <1,6,3,5>: Cost 3 vtrnr <5,1,7,3>, <u,6,7,5>
    2061880692U, // <1,6,3,6>: Cost 2 vtrnr LHS, <4,6,4,6>
    2014103482U, // <1,6,3,7>: Cost 2 vtrnr LHS, <2,6,3,7>
    2014103483U, // <1,6,3,u>: Cost 2 vtrnr LHS, <2,6,3,u>
    3206168576U, // <1,6,4,0>: Cost 3 ins <u,6,4,0>, lane 0
    2761256201U, // <1,6,4,1>: Cost 3 vuzpl <1,5,6,7>, <4,5,1,7>
    3164676098U, // <1,6,4,2>: Cost 3 ins <1,6,u,2>, lane 2
    3087852027U, // <1,6,4,3>: Cost 3 vtrnr <0,1,2,4>, <0,6,2,3>
    3206201344U, // <1,6,4,4>: Cost 3 ins <u,6,4,4>, lane 0
    2618699062U, // <1,6,4,5>: Cost 3 vext2 <0,2,1,6>, RHS
    2132475904U, // <1,6,4,6>: Cost 2 ins <u,6,4,6>, lane 0
    2954890550U, // <1,6,4,7>: Cost 3 vzipr <0,3,1,4>, RHS
    2132475904U, // <1,6,4,u>: Cost 2 ins <u,6,4,6>, lane 0
    3164659714U, // <1,6,5,0>: Cost 3 ins <1,6,u,0>, lane 2
    3206250496U, // <1,6,5,1>: Cost 3 ins <u,6,5,1>, lane 0
    3003337628U, // <1,6,5,2>: Cost 3 vzipr <u,4,1,5>, <4,0,6,2>
    3165790209U, // <1,6,5,3>: Cost 3 ins <1,u,5,3>, lane 1
    3206275072U, // <1,6,5,4>: Cost 3 ins <u,6,5,4>, lane 0
    3206283264U, // <1,6,5,5>: Cost 3 ins <u,6,5,5>, lane 0
    3003337956U, // <1,6,5,6>: Cost 3 vzipr <u,4,1,5>, <4,4,6,6>
    1881820470U, // <1,6,5,7>: Cost 2 vzipr <0,4,1,5>, RHS
    1881820471U, // <1,6,5,u>: Cost 2 vzipr <0,4,1,5>, RHS
    2724180733U, // <1,6,6,0>: Cost 3 vext3 <6,6,0,1>, <6,6,0,1>
    2557264742U, // <1,6,6,1>: Cost 3 vext1 <1,1,6,6>, <1,1,6,6>
    3165855745U, // <1,6,6,2>: Cost 3 ins <1,u,6,2>, lane 1
    2819432955U, // <1,6,6,3>: Cost 3 vuzpr <0,1,2,6>, <0,6,2,3>
    3206348800U, // <1,6,6,4>: Cost 3 ins <u,6,6,4>, lane 0
    3206356992U, // <1,6,6,5>: Cost 3 ins <u,6,6,5>, lane 0
    2132623360U, // <1,6,6,6>: Cost 2 ins <u,6,6,6>, lane 0
    2132631552U, // <1,6,6,7>: Cost 2 ins <u,6,6,7>, lane 0
    2132623360U, // <1,6,6,u>: Cost 2 ins <u,6,6,6>, lane 0
    1651102542U, // <1,6,7,0>: Cost 2 vext3 <6,7,0,1>, <6,7,0,1>
    2724918103U, // <1,6,7,1>: Cost 3 vext3 <6,7,1,1>, <6,7,1,1>
    3206406144U, // <1,6,7,2>: Cost 3 ins <u,6,7,2>, lane 0
    3206414336U, // <1,6,7,3>: Cost 3 ins <u,6,7,3>, lane 0
    2132680704U, // <1,6,7,4>: Cost 2 ins <u,6,7,4>, lane 0
    2725213051U, // <1,6,7,5>: Cost 3 vext3 <6,7,5,1>, <6,7,5,1>
    2725507979U, // <1,6,7,6>: Cost 3 vext3 <6,u,0,1>, <6,7,6,u>
    2132705280U, // <1,6,7,7>: Cost 2 ins <u,6,7,7>, lane 0
    1651692438U, // <1,6,7,u>: Cost 2 vext3 <6,7,u,1>, <6,7,u,1>
    1651766175U, // <1,6,u,0>: Cost 2 vext3 <6,u,0,1>, <6,u,0,1>
    2091737089U, // <1,6,u,1>: Cost 2 ins <1,u,1,1>, lane 1
    2061921612U, // <1,6,u,2>: Cost 2 vtrnr LHS, <4,6,0,2>
    2091753473U, // <1,6,u,3>: Cost 2 ins <1,u,1,3>, lane 1
    2061922406U, // <1,6,u,4>: Cost 2 vtrnr LHS, <5,6,7,4>
    2618701978U, // <1,6,u,5>: Cost 3 vext2 <0,2,1,6>, RHS
    2061921652U, // <1,6,u,6>: Cost 2 vtrnr LHS, <4,6,4,6>
    2014144442U, // <1,6,u,7>: Cost 2 vtrnr LHS, <2,6,3,7>
    2014144443U, // <1,6,u,u>: Cost 2 vtrnr LHS, <2,6,3,u>
    2726171632U, // <1,7,0,0>: Cost 3 vext3 <7,0,0,1>, <7,0,0,1>
    2132803584U, // <1,7,0,1>: Cost 2 ins <u,7,0,1>, lane 0
    3206553600U, // <1,7,0,2>: Cost 3 ins <u,7,0,2>, lane 0
    2257286235U, // <1,7,0,3>: Cost 3 vrev <7,1,3,0>
    2726466580U, // <1,7,0,4>: Cost 3 vext3 <7,0,4,1>, <7,0,4,1>
    3206578176U, // <1,7,0,5>: Cost 3 ins <u,7,0,5>, lane 0
    2621358582U, // <1,7,0,6>: Cost 3 vext2 <0,6,1,7>, <0,6,1,7>
    3165380610U, // <1,7,0,7>: Cost 3 ins <1,7,u,7>, lane 2
    2132803584U, // <1,7,0,u>: Cost 2 ins <u,7,0,1>, lane 0
    2581184614U, // <1,7,1,0>: Cost 3 vext1 <5,1,7,1>, LHS
    2091737089U, // <1,7,1,1>: Cost 2 ins <1,u,1,1>, lane 1
    3206627328U, // <1,7,1,2>: Cost 3 ins <u,7,1,2>, lane 0
    2132893696U, // <1,7,1,3>: Cost 2 ins <u,7,1,3>, lane 0
    2581187894U, // <1,7,1,4>: Cost 3 vext1 <5,1,7,1>, RHS
    2626667646U, // <1,7,1,5>: Cost 3 vext2 <1,5,1,7>, <1,5,1,7>
    2627331279U, // <1,7,1,6>: Cost 3 vext2 <1,6,1,7>, <1,6,1,7>
    1745698922U, // <1,7,1,7>: Cost 2 vuzpr <0,1,2,7>, <0,1,2,7>
    2132893696U, // <1,7,1,u>: Cost 2 ins <u,7,1,3>, lane 0
    2587164774U, // <1,7,2,0>: Cost 3 vext1 <6,1,7,2>, LHS
    2994687370U, // <1,7,2,1>: Cost 3 vzipr <7,0,1,2>, <4,6,7,1>
    3206701056U, // <1,7,2,2>: Cost 3 ins <u,7,2,2>, lane 0
    2132967424U, // <1,7,2,3>: Cost 2 ins <u,7,2,3>, lane 0
    2587168054U, // <1,7,2,4>: Cost 3 vext1 <6,1,7,2>, RHS
    3206725632U, // <1,7,2,5>: Cost 3 ins <u,7,2,5>, lane 0
    2587169192U, // <1,7,2,6>: Cost 3 vext1 <6,1,7,2>, <6,1,7,2>
    2994688024U, // <1,7,2,7>: Cost 3 vzipr <7,0,1,2>, <5,5,7,7>
    2132967424U, // <1,7,2,u>: Cost 2 ins <u,7,2,3>, lane 0
    1507459174U, // <1,7,3,0>: Cost 2 vext1 <5,1,7,3>, LHS
    2061882190U, // <1,7,3,1>: Cost 2 vtrnr LHS, <6,7,0,1>
    2091892737U, // <1,7,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    2061881472U, // <1,7,3,3>: Cost 2 vtrnr LHS, <5,7,1,3>
    1507462454U, // <1,7,3,4>: Cost 2 vext1 <5,1,7,3>, RHS
    1507462864U, // <1,7,3,5>: Cost 2 vext1 <5,1,7,3>, <5,1,7,3>
    2581205498U, // <1,7,3,6>: Cost 3 vext1 <5,1,7,3>, <6,2,7,3>
    2061881512U, // <1,7,3,7>: Cost 2 vtrnr LHS, <5,7,5,7>
    1507465006U, // <1,7,3,u>: Cost 2 vext1 <5,1,7,3>, LHS
    2728826164U, // <1,7,4,0>: Cost 3 vext3 <7,4,0,1>, <7,4,0,1>
    3165331458U, // <1,7,4,1>: Cost 3 ins <1,7,u,1>, lane 2
    2644585539U, // <1,7,4,2>: Cost 3 vext2 <4,5,1,7>, <4,2,6,7>
    2257319007U, // <1,7,4,3>: Cost 3 vrev <7,1,3,4>
    3206864896U, // <1,7,4,4>: Cost 3 ins <u,7,4,4>, lane 0
    2133131264U, // <1,7,4,5>: Cost 2 ins <u,7,4,5>, lane 0
    3206881280U, // <1,7,4,6>: Cost 3 ins <u,7,4,6>, lane 0
    3165380610U, // <1,7,4,7>: Cost 3 ins <1,7,u,7>, lane 2
    2133131264U, // <1,7,4,u>: Cost 2 ins <u,7,4,5>, lane 0
    2569273446U, // <1,7,5,0>: Cost 3 vext1 <3,1,7,5>, LHS
    3028292602U, // <1,7,5,1>: Cost 3 vtrnl <1,3,5,7>, <7,0,1,2>
    3165782017U, // <1,7,5,2>: Cost 3 ins <1,u,5,2>, lane 1
    3028292704U, // <1,7,5,3>: Cost 3 vtrnl <1,3,5,7>, <7,1,3,5>
    2569276726U, // <1,7,5,4>: Cost 3 vext1 <3,1,7,5>, RHS
    3028292966U, // <1,7,5,5>: Cost 3 vtrnl <1,3,5,7>, <7,4,5,6>
    2651222067U, // <1,7,5,6>: Cost 3 vext2 <5,6,1,7>, <5,6,1,7>
    2133221376U, // <1,7,5,7>: Cost 2 ins <u,7,5,7>, lane 0
    2133221376U, // <1,7,5,u>: Cost 2 ins <u,7,5,7>, lane 0
    2730153430U, // <1,7,6,0>: Cost 3 vext3 <7,6,0,1>, <7,6,0,1>
    2724845022U, // <1,7,6,1>: Cost 3 vext3 <6,7,0,1>, <7,6,1,0>
    3206995968U, // <1,7,6,2>: Cost 3 ins <u,7,6,2>, lane 0
    3165347842U, // <1,7,6,3>: Cost 3 ins <1,7,u,3>, lane 2
    2257409130U, // <1,7,6,4>: Cost 3 vrev <7,1,4,6>
    3207020544U, // <1,7,6,5>: Cost 3 ins <u,7,6,5>, lane 0
    3207028736U, // <1,7,6,6>: Cost 3 ins <u,7,6,6>, lane 0
    2133295104U, // <1,7,6,7>: Cost 2 ins <u,7,6,7>, lane 0
    2133295104U, // <1,7,6,u>: Cost 2 ins <u,7,6,7>, lane 0
    2730817063U, // <1,7,7,0>: Cost 3 vext3 <7,7,0,1>, <7,7,0,1>
    2861470542U, // <1,7,7,1>: Cost 3 vuzpr <7,1,5,7>, <6,7,0,1>
    3165929473U, // <1,7,7,2>: Cost 3 ins <1,u,7,2>, lane 1
    2998046416U, // <1,7,7,3>: Cost 3 vzipr <7,5,1,7>, <5,1,7,3>
    3207086080U, // <1,7,7,4>: Cost 3 ins <u,7,7,4>, lane 0
    2257491060U, // <1,7,7,5>: Cost 3 vrev <7,1,5,7>
    3207102464U, // <1,7,7,6>: Cost 3 ins <u,7,7,6>, lane 0
    2133368832U, // <1,7,7,7>: Cost 2 ins <u,7,7,7>, lane 0
    2133368832U, // <1,7,7,u>: Cost 2 ins <u,7,7,7>, lane 0
    1507500134U, // <1,7,u,0>: Cost 2 vext1 <5,1,7,u>, LHS
    2061923150U, // <1,7,u,1>: Cost 2 vtrnr LHS, <6,7,0,1>
    2091892737U, // <1,7,u,2>: Cost 2 ins <1,u,3,2>, lane 1
    2061922432U, // <1,7,u,3>: Cost 2 vtrnr LHS, <5,7,1,3>
    1507503414U, // <1,7,u,4>: Cost 2 vext1 <5,1,7,u>, RHS
    1507503829U, // <1,7,u,5>: Cost 2 vext1 <5,1,7,u>, <5,1,7,u>
    2581246458U, // <1,7,u,6>: Cost 3 vext1 <5,1,7,u>, <6,2,7,3>
    2061922472U, // <1,7,u,7>: Cost 2 vtrnr LHS, <5,7,5,7>
    1507505966U, // <1,7,u,u>: Cost 2 vext1 <5,1,7,u>, LHS
    1745707008U, // <1,u,0,0>: Cost 2 vuzpr LHS, <0,0,0,0>
    1745707018U, // <1,u,0,1>: Cost 2 vuzpr LHS, <0,0,1,1>
    1745707028U, // <1,u,0,2>: Cost 2 vuzpr LHS, <0,0,2,2>
    2087624706U, // <1,u,0,3>: Cost 2 ins <1,1,u,3>, lane 2
    1546297685U, // <1,u,0,4>: Cost 2 vext2 <0,4,1,u>, <0,4,1,u>
    1818155162U, // <1,u,0,5>: Cost 2 vzipl <1,0,3,2>, RHS
    2891897040U, // <1,u,0,6>: Cost 3 vzipl <1,0,3,2>, <u,6,3,7>
    2088984578U, // <1,u,0,7>: Cost 2 ins <1,3,u,7>, lane 2
    1745707025U, // <1,u,0,u>: Cost 2 vuzpr LHS, <0,0,1,u>
    1483112550U, // <1,u,1,0>: Cost 2 vext1 <1,1,1,1>, LHS
    202162278U,  // <1,u,1,1>: Cost 1 vdup1 LHS
    1616009006U, // <1,u,1,2>: Cost 2 vext3 <0,u,1,1>, LHS
    671965286U,  // <1,u,1,3>: Cost 1 vuzpr LHS, LHS
    1483115830U, // <1,u,1,4>: Cost 2 vext1 <1,1,1,1>, RHS
    1818663066U, // <1,u,1,5>: Cost 2 vzipl <1,1,1,1>, RHS
    1952880794U, // <1,u,1,6>: Cost 2 vtrnl <1,1,1,1>, RHS
    1884441928U, // <1,u,1,7>: Cost 2 vzipr <0,u,1,1>, RHS
    671965291U,  // <1,u,1,u>: Cost 1 vuzpr LHS, LHS
    1745707926U, // <1,u,2,0>: Cost 2 vuzpr LHS, <1,2,3,0>
    1819465518U, // <1,u,2,1>: Cost 2 vzipl <1,2,3,0>, LHS
    1745707172U, // <1,u,2,2>: Cost 2 vuzpr LHS, <0,2,0,2>
    1055244288U, // <1,u,2,3>: Cost 1 ins LHS, lane 0
    1745707930U, // <1,u,2,4>: Cost 2 vuzpr LHS, <1,2,3,4>
    1819465882U, // <1,u,2,5>: Cost 2 vzipl <1,2,3,0>, RHS
    1745707212U, // <1,u,2,6>: Cost 2 vuzpr LHS, <0,2,4,6>
    1897057608U, // <1,u,2,7>: Cost 2 vzipr <3,0,1,2>, RHS
    1055244288U, // <1,u,2,u>: Cost 1 ins LHS, lane 0
    403931292U,  // <1,u,3,0>: Cost 1 vext1 LHS, LHS
    2014102162U, // <1,u,3,1>: Cost 2 vtrnr LHS, <0,u,1,1>
    115726126U,  // <1,u,3,2>: Cost 1 vrev LHS
    940360349U,  // <1,u,3,3>: Cost 1 vtrnr LHS, LHS
    403934518U,  // <1,u,3,4>: Cost 1 vext1 LHS, RHS
    2014102166U, // <1,u,3,5>: Cost 2 vtrnr LHS, <0,u,1,5>
    2014102176U, // <1,u,3,6>: Cost 2 vtrnr LHS, <0,u,2,6>
    940363305U,  // <1,u,3,7>: Cost 1 vtrnr LHS, RHS
    940360354U,  // <1,u,3,u>: Cost 1 vtrnr LHS, LHS
    2088263682U, // <1,u,4,0>: Cost 2 ins <1,2,u,0>, lane 2
    2087608322U, // <1,u,4,1>: Cost 2 ins <1,1,u,1>, lane 2
    2086952962U, // <1,u,4,2>: Cost 2 ins <1,0,u,2>, lane 2
    2087624706U, // <1,u,4,3>: Cost 2 ins <1,1,u,3>, lane 2
    1793486032U, // <1,u,4,4>: Cost 2 vuzpr LHS, <4,4,4,4>
    1745707346U, // <1,u,4,5>: Cost 2 vuzpr LHS, <0,4,1,5>
    1745707356U, // <1,u,4,6>: Cost 2 vuzpr LHS, <0,4,2,6>
    2088984578U, // <1,u,4,7>: Cost 2 ins <1,3,u,7>, lane 2
    1745707349U, // <1,u,4,u>: Cost 2 vuzpr LHS, <0,4,1,u>
    2088263682U, // <1,u,5,0>: Cost 2 ins <1,2,u,0>, lane 2
    1821513518U, // <1,u,5,1>: Cost 2 vzipl <1,5,3,7>, LHS
    1954551598U, // <1,u,5,2>: Cost 2 vtrnl <1,3,5,7>, LHS
    1881817244U, // <1,u,5,3>: Cost 2 vzipr <0,4,1,5>, LHS
    2088296450U, // <1,u,5,4>: Cost 2 ins <1,2,u,4>, lane 2
    1821513882U, // <1,u,5,5>: Cost 2 vzipl <1,5,3,7>, RHS
    1616009370U, // <1,u,5,6>: Cost 2 vext3 <0,u,1,1>, RHS
    671968566U,  // <1,u,5,7>: Cost 1 vuzpr LHS, RHS
    671968567U,  // <1,u,5,u>: Cost 1 vuzpr LHS, RHS
    1793486946U, // <1,u,6,0>: Cost 2 vuzpr LHS, <5,6,7,0>
    2087608322U, // <1,u,6,1>: Cost 2 ins <1,1,u,1>, lane 2
    1793486156U, // <1,u,6,2>: Cost 2 vuzpr LHS, <4,6,0,2>
    2087624706U, // <1,u,6,3>: Cost 2 ins <1,1,u,3>, lane 2
    1793486950U, // <1,u,6,4>: Cost 2 vuzpr LHS, <5,6,7,4>
    2131951616U, // <1,u,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    1793486196U, // <1,u,6,6>: Cost 2 vuzpr LHS, <4,6,4,6>
    1058226176U, // <1,u,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <1,u,6,u>: Cost 1 ins RHS, lane 0
    1585452032U, // <1,u,7,0>: Cost 2 vext2 <7,0,1,u>, <7,0,1,u>
    1793487694U, // <1,u,7,1>: Cost 2 vuzpr LHS, <6,7,0,1>
    2086952962U, // <1,u,7,2>: Cost 2 ins <1,0,u,2>, lane 2
    1793486976U, // <1,u,7,3>: Cost 2 vuzpr LHS, <5,7,1,3>
    2088296450U, // <1,u,7,4>: Cost 2 ins <1,2,u,4>, lane 2
    1793487734U, // <1,u,7,5>: Cost 2 vuzpr LHS, <6,7,4,5>
    2131369984U, // <1,u,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    1793487016U, // <1,u,7,7>: Cost 2 vuzpr LHS, <5,7,5,7>
    1590761096U, // <1,u,7,u>: Cost 2 vext2 <7,u,1,u>, <7,u,1,u>
    403972257U,  // <1,u,u,0>: Cost 1 vext1 LHS, LHS
    202162278U,  // <1,u,u,1>: Cost 1 vdup1 LHS
    115767091U,  // <1,u,u,2>: Cost 1 vrev LHS
    671965853U,  // <1,u,u,3>: Cost 1 vuzpr LHS, LHS
    403975478U,  // <1,u,u,4>: Cost 1 vext1 LHS, RHS
    1745707670U, // <1,u,u,5>: Cost 2 vuzpr LHS, <0,u,1,5>
    1745707680U, // <1,u,u,6>: Cost 2 vuzpr LHS, <0,u,2,6>
    671968809U,  // <1,u,u,7>: Cost 1 vuzpr LHS, RHS
    671965858U,  // <1,u,u,u>: Cost 1 vuzpr LHS, LHS
    2128150528U, // <2,0,0,0>: Cost 2 ins <u,0,0,0>, lane 0
    2097635329U, // <2,0,0,1>: Cost 2 ins <2,u,0,1>, lane 1
    1691664486U, // <2,0,0,2>: Cost 2 vuzpl <2,3,0,1>, LHS
    2826094014U, // <2,0,0,3>: Cost 3 vuzpr <1,2,3,0>, <2,0,1,3>
    2551467318U, // <2,0,0,4>: Cost 3 vext1 <0,2,0,0>, RHS
    2826094772U, // <2,0,0,5>: Cost 3 vuzpr <1,2,3,0>, <3,0,4,5>
    3171418113U, // <2,0,0,6>: Cost 3 ins <2,u,0,6>, lane 1
    3094529510U, // <2,0,0,7>: Cost 3 vtrnr <1,2,3,0>, <2,0,5,7>
    1691664540U, // <2,0,0,u>: Cost 2 vuzpl <2,3,0,1>, LHS
    2215927971U, // <2,0,1,0>: Cost 3 vrev <0,2,0,1>
    2128232448U, // <2,0,1,1>: Cost 2 ins <u,0,1,1>, lane 0
    1611956326U, // <2,0,1,2>: Cost 2 vext3 <0,2,0,2>, LHS
    1752350822U, // <2,0,1,3>: Cost 2 vuzpr <1,2,3,0>, LHS
    2551475510U, // <2,0,1,4>: Cost 3 vext1 <0,2,0,1>, RHS
    2765407232U, // <2,0,1,5>: Cost 3 vuzpl <2,3,0,1>, <1,3,5,7>
    2587308473U, // <2,0,1,6>: Cost 3 vext1 <6,2,0,1>, <6,2,0,1>
    3166707714U, // <2,0,1,7>: Cost 3 ins <2,0,u,7>, lane 2
    1611956380U, // <2,0,1,u>: Cost 2 vext3 <0,2,0,2>, LHS
    1142194340U, // <2,0,2,0>: Cost 2 vrev <0,2,0,2>
    1825374310U, // <2,0,2,1>: Cost 2 vzipl <2,2,2,2>, LHS
    1959592038U, // <2,0,2,2>: Cost 2 vtrnl <2,2,2,2>, LHS
    2128322560U, // <2,0,2,3>: Cost 2 ins <u,0,2,3>, lane 0
    1477741878U, // <2,0,2,4>: Cost 2 vext1 <0,2,0,2>, RHS
    2599259856U, // <2,0,2,5>: Cost 3 vext1 <u,2,0,2>, <5,1,7,3>
    3088351274U, // <2,0,2,6>: Cost 3 vtrnr <0,2,0,2>, <0,0,4,6>
    2599261178U, // <2,0,2,7>: Cost 3 vext1 <u,2,0,2>, <7,0,1,2>
    1477744430U, // <2,0,2,u>: Cost 2 vext1 <0,2,0,2>, LHS
    1879883776U, // <2,0,3,0>: Cost 2 vzipr LHS, <0,0,0,0>
    1879885478U, // <2,0,3,1>: Cost 2 vzipr LHS, <2,3,0,1>
    1879883940U, // <2,0,3,2>: Cost 2 vzipr LHS, <0,2,0,2>
    2097872897U, // <2,0,3,3>: Cost 2 ins <2,u,3,3>, lane 1
    2958270630U, // <2,0,3,4>: Cost 3 vzipr LHS, <0,2,0,4>
    2826094286U, // <2,0,3,5>: Cost 3 vuzpr <1,2,3,0>, <2,3,4,5>
    2958270794U, // <2,0,3,6>: Cost 3 vzipr LHS, <0,4,0,6>
    2097905665U, // <2,0,3,7>: Cost 2 ins <2,u,3,7>, lane 1
    1879883946U, // <2,0,3,u>: Cost 2 vzipr LHS, <0,2,0,u>
    2215952550U, // <2,0,4,0>: Cost 3 vrev <0,2,0,4>
    2685698386U, // <2,0,4,1>: Cost 3 vext3 <0,2,0,2>, <0,4,1,5>
    1960427622U, // <2,0,4,2>: Cost 2 vtrnl <2,3,4,5>, LHS
    3171688449U, // <2,0,4,3>: Cost 3 ins <2,u,4,3>, lane 1
    2551500086U, // <2,0,4,4>: Cost 3 vext1 <0,2,0,4>, RHS
    2097963009U, // <2,0,4,5>: Cost 2 ins <2,u,4,5>, lane 1
    1691667766U, // <2,0,4,6>: Cost 2 vuzpl <2,3,0,1>, RHS
    3171721217U, // <2,0,4,7>: Cost 3 ins <2,u,4,7>, lane 1
    1691667784U, // <2,0,4,u>: Cost 2 vuzpl <2,3,0,1>, RHS
    3033596068U, // <2,0,5,0>: Cost 3 vtrnl <2,2,5,7>, <0,2,0,2>
    2128527360U, // <2,0,5,1>: Cost 2 ins <u,0,5,1>, lane 0
    2955632804U, // <2,0,5,2>: Cost 3 vzipr <0,4,2,5>, <0,2,0,2>
    2216181954U, // <2,0,5,3>: Cost 3 vrev <0,2,3,5>
    2216255691U, // <2,0,5,4>: Cost 3 vrev <0,2,4,5>
    2867900420U, // <2,0,5,5>: Cost 3 vuzpr <u,2,3,0>, <5,5,5,5>
    3202310144U, // <2,0,5,6>: Cost 3 ins <u,0,5,6>, lane 0
    1752354102U, // <2,0,5,7>: Cost 2 vuzpr <1,2,3,0>, RHS
    1752354103U, // <2,0,5,u>: Cost 2 vuzpr <1,2,3,0>, RHS
    3088678912U, // <2,0,6,0>: Cost 3 vtrnr <0,2,4,6>, <0,0,0,0>
    1828143206U, // <2,0,6,1>: Cost 2 vzipl <2,6,3,7>, LHS
    2128609280U, // <2,0,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    3171835905U, // <2,0,6,3>: Cost 3 ins <2,u,6,3>, lane 1
    1142522060U, // <2,0,6,4>: Cost 2 vrev <0,2,4,6>
    3171852289U, // <2,0,6,5>: Cost 3 ins <2,u,6,5>, lane 1
    2867899764U, // <2,0,6,6>: Cost 3 vuzpr <u,2,3,0>, <4,6,4,6>
    2128650240U, // <2,0,6,7>: Cost 2 ins <u,0,6,7>, lane 0
    1142817008U, // <2,0,6,u>: Cost 2 vrev <0,2,u,6>
    2659202049U, // <2,0,7,0>: Cost 3 vext2 <7,0,2,0>, <7,0,2,0>
    2867901262U, // <2,0,7,1>: Cost 3 vuzpr <u,2,3,0>, <6,7,0,1>
    2956976292U, // <2,0,7,2>: Cost 3 vzipr <0,6,2,7>, <0,2,0,2>
    2867900544U, // <2,0,7,3>: Cost 3 vuzpr <u,2,3,0>, <5,7,1,3>
    3171917825U, // <2,0,7,4>: Cost 3 ins <2,u,7,4>, lane 1
    2867901302U, // <2,0,7,5>: Cost 3 vuzpr <u,2,3,0>, <6,7,4,5>
    3166699522U, // <2,0,7,6>: Cost 3 ins <2,0,u,6>, lane 2
    2867900584U, // <2,0,7,7>: Cost 3 vuzpr <u,2,3,0>, <5,7,5,7>
    2867900549U, // <2,0,7,u>: Cost 3 vuzpr <u,2,3,0>, <5,7,1,u>
    1879924736U, // <2,0,u,0>: Cost 2 vzipr LHS, <0,0,0,0>
    1879926438U, // <2,0,u,1>: Cost 2 vzipr LHS, <2,3,0,1>
    1879924900U, // <2,0,u,2>: Cost 2 vzipr LHS, <0,2,0,2>
    1752351389U, // <2,0,u,3>: Cost 2 vuzpr <1,2,3,0>, LHS
    1477791030U, // <2,0,u,4>: Cost 2 vext1 <0,2,0,u>, RHS
    2097963009U, // <2,0,u,5>: Cost 2 ins <2,u,4,5>, lane 1
    1691670682U, // <2,0,u,6>: Cost 2 vuzpl <2,3,0,1>, RHS
    1752354345U, // <2,0,u,7>: Cost 2 vuzpr <1,2,3,0>, RHS
    1879924906U, // <2,0,u,u>: Cost 2 vzipr LHS, <0,2,0,u>
    2763497636U, // <2,1,0,0>: Cost 3 vuzpl <2,0,1,2>, <0,2,0,2>
    2097635329U, // <2,1,0,1>: Cost 2 ins <2,u,0,1>, lane 1
    2820130966U, // <2,1,0,2>: Cost 3 vuzpr <0,2,3,1>, <3,0,1,2>
    1616823030U, // <2,1,0,3>: Cost 2 vext3 <1,0,3,2>, <1,0,3,2>
    2767487180U, // <2,1,0,4>: Cost 3 vuzpl <2,6,1,3>, <0,2,4,6>
    3033842688U, // <2,1,0,5>: Cost 3 vtrnl <2,3,0,1>, <1,3,5,7>
    3171418113U, // <2,1,0,6>: Cost 3 ins <2,u,0,6>, lane 1
    3171426305U, // <2,1,0,7>: Cost 3 ins <2,u,0,7>, lane 1
    1617191715U, // <2,1,0,u>: Cost 2 vext3 <1,0,u,2>, <1,0,u,2>
    2551546028U, // <2,1,1,0>: Cost 3 vext1 <0,2,1,1>, <0,2,1,1>
    2128896000U, // <2,1,1,1>: Cost 2 ins <u,1,1,1>, lane 0
    2954938518U, // <2,1,1,2>: Cost 3 vzipr <0,3,2,1>, <3,0,1,2>
    2128912384U, // <2,1,1,3>: Cost 2 ins <u,1,1,3>, lane 0
    2551549238U, // <2,1,1,4>: Cost 3 vext1 <0,2,1,1>, RHS
    3202670592U, // <2,1,1,5>: Cost 3 ins <u,1,1,5>, lane 0
    3202678784U, // <2,1,1,6>: Cost 3 ins <u,1,1,6>, lane 0
    2953612553U, // <2,1,1,7>: Cost 3 vzipr <0,1,2,1>, <4,5,1,7>
    2128896000U, // <2,1,1,u>: Cost 2 ins <u,1,1,1>, lane 0
    2128961536U, // <2,1,2,0>: Cost 2 ins <u,1,2,0>, lane 0
    2128969728U, // <2,1,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    2128977920U, // <2,1,2,2>: Cost 2 ins <u,1,2,2>, lane 0
    1055244288U, // <2,1,2,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <2,1,2,4>: Cost 2 ins <u,1,2,4>, lane 0
    2129002496U, // <2,1,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2129010688U, // <2,1,2,6>: Cost 2 ins <u,1,2,6>, lane 0
    2129018880U, // <2,1,2,7>: Cost 2 ins <u,1,2,7>, lane 0
    1055244288U, // <2,1,2,u>: Cost 1 ins LHS, lane 0
    2953625609U, // <2,1,3,0>: Cost 3 vzipr LHS, <0,0,1,0>
    1879883786U, // <2,1,3,1>: Cost 2 vzipr LHS, <0,0,1,1>
    1879885974U, // <2,1,3,2>: Cost 2 vzipr LHS, <3,0,1,2>
    1879884760U, // <2,1,3,3>: Cost 2 vzipr LHS, <1,3,1,3>
    2953625856U, // <2,1,3,4>: Cost 3 vzipr LHS, <0,3,1,4>
    1879884114U, // <2,1,3,5>: Cost 2 vzipr LHS, <0,4,1,5>
    2958270641U, // <2,1,3,6>: Cost 3 vzipr LHS, <0,2,1,6>
    2097905665U, // <2,1,3,7>: Cost 2 ins <2,u,3,7>, lane 1
    1879883793U, // <2,1,3,u>: Cost 2 vzipr LHS, <0,0,1,u>
    3171663873U, // <2,1,4,0>: Cost 3 ins <2,u,4,0>, lane 1
    3094561588U, // <2,1,4,1>: Cost 3 vtrnr <1,2,3,4>, <1,1,1,1>
    2900378522U, // <2,1,4,2>: Cost 3 vzipl <2,4,1,3>, <1,2,3,4>
    1148404634U, // <2,1,4,3>: Cost 2 vrev <1,2,3,4>
    3171696641U, // <2,1,4,4>: Cost 3 ins <2,u,4,4>, lane 1
    2097963009U, // <2,1,4,5>: Cost 2 ins <2,u,4,5>, lane 1
    2763500854U, // <2,1,4,6>: Cost 3 vuzpl <2,0,1,2>, RHS
    3171721217U, // <2,1,4,7>: Cost 3 ins <2,u,4,7>, lane 1
    2020819051U, // <2,1,4,u>: Cost 2 vtrnr <1,2,3,4>, LHS
    2551578800U, // <2,1,5,0>: Cost 3 vext1 <0,2,1,5>, <0,2,1,5>
    2551579648U, // <2,1,5,1>: Cost 3 vext1 <0,2,1,5>, <1,3,5,7>
    2901001110U, // <2,1,5,2>: Cost 3 vzipl <2,5,0,7>, <1,2,3,0>
    2129207296U, // <2,1,5,3>: Cost 2 ins <u,1,5,3>, lane 0
    2551582006U, // <2,1,5,4>: Cost 3 vext1 <0,2,1,5>, RHS
    3202965504U, // <2,1,5,5>: Cost 3 ins <u,1,5,5>, lane 0
    3171786753U, // <2,1,5,6>: Cost 3 ins <2,u,5,6>, lane 1
    2819910966U, // <2,1,5,7>: Cost 3 vuzpr <0,2,0,1>, RHS
    2129207296U, // <2,1,5,u>: Cost 2 ins <u,1,5,3>, lane 0
    2551586993U, // <2,1,6,0>: Cost 3 vext1 <0,2,1,6>, <0,2,1,6>
    3088679732U, // <2,1,6,1>: Cost 3 vtrnr <0,2,4,6>, <1,1,1,1>
    2551588794U, // <2,1,6,2>: Cost 3 vext1 <0,2,1,6>, <2,6,3,7>
    2014937190U, // <2,1,6,3>: Cost 2 vtrnr <0,2,4,6>, LHS
    2551590198U, // <2,1,6,4>: Cost 3 vext1 <0,2,1,6>, RHS
    2955641170U, // <2,1,6,5>: Cost 3 vzipr <0,4,2,6>, <0,4,1,5>
    2901886177U, // <2,1,6,6>: Cost 3 vzipl <2,6,3,7>, <1,6,3,7>
    2129313792U, // <2,1,6,7>: Cost 2 ins <u,1,6,7>, lane 0
    2014937195U, // <2,1,6,u>: Cost 2 vtrnr <0,2,4,6>, LHS
    3171885057U, // <2,1,7,0>: Cost 3 ins <2,u,7,0>, lane 1
    3203080192U, // <2,1,7,1>: Cost 3 ins <u,1,7,1>, lane 0
    3001439874U, // <2,1,7,2>: Cost 3 vzipr <u,1,2,7>, <7,u,1,2>
    2129354752U, // <2,1,7,3>: Cost 2 ins <u,1,7,3>, lane 0
    3171917825U, // <2,1,7,4>: Cost 3 ins <2,u,7,4>, lane 1
    3203112960U, // <2,1,7,5>: Cost 3 ins <u,1,7,5>, lane 0
    2222392248U, // <2,1,7,6>: Cost 3 vrev <1,2,6,7>
    3171942401U, // <2,1,7,7>: Cost 3 ins <2,u,7,7>, lane 1
    2129354752U, // <2,1,7,u>: Cost 2 ins <u,1,7,3>, lane 0
    2128961536U, // <2,1,u,0>: Cost 2 ins <u,1,2,0>, lane 0
    1879924746U, // <2,1,u,1>: Cost 2 vzipr LHS, <0,0,1,1>
    1879926934U, // <2,1,u,2>: Cost 2 vzipr LHS, <3,0,1,2>
    1055244288U, // <2,1,u,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <2,1,u,4>: Cost 2 ins <u,1,2,4>, lane 0
    1879925074U, // <2,1,u,5>: Cost 2 vzipr LHS, <0,4,1,5>
    2129010688U, // <2,1,u,6>: Cost 2 ins <u,1,2,6>, lane 0
    2097905665U, // <2,1,u,7>: Cost 2 ins <2,u,3,7>, lane 1
    1055244288U, // <2,1,u,u>: Cost 1 ins LHS, lane 0
    2020787094U, // <2,2,0,0>: Cost 2 vtrnr <1,2,3,0>, <1,2,3,0>
    1548976230U, // <2,2,0,1>: Cost 2 vext2 <0,u,2,2>, LHS
    1691156582U, // <2,2,0,2>: Cost 2 vuzpl <2,2,2,2>, LHS
    2094260226U, // <2,2,0,3>: Cost 2 ins <2,2,u,3>, lane 2
    2819917256U, // <2,2,0,4>: Cost 3 vuzpr <0,2,0,2>, <2,0,2,4>
    3168018434U, // <2,2,0,5>: Cost 3 ins <2,2,u,5>, lane 2
    2819915818U, // <2,2,0,6>: Cost 3 vuzpr <0,2,0,2>, <0,0,4,6>
    3171426305U, // <2,2,0,7>: Cost 3 ins <2,u,0,7>, lane 1
    1548976796U, // <2,2,0,u>: Cost 2 vext2 <0,u,2,2>, <0,u,2,2>
    2622718710U, // <2,2,1,0>: Cost 3 vext2 <0,u,2,2>, <1,0,3,2>
    1879867492U, // <2,2,1,1>: Cost 2 vzipr <0,1,2,1>, <0,1,2,1>
    2094252034U, // <2,2,1,2>: Cost 2 ins <2,2,u,2>, lane 2
    1746174054U, // <2,2,1,3>: Cost 2 vuzpr <0,2,0,2>, LHS
    3167526915U, // <2,2,1,4>: Cost 3 ins <2,2,1,u>, lane 3
    2622719120U, // <2,2,1,5>: Cost 3 vext2 <0,u,2,2>, <1,5,3,7>
    3203342336U, // <2,2,1,6>: Cost 3 ins <u,2,1,6>, lane 0
    3168034818U, // <2,2,1,7>: Cost 3 ins <2,2,u,7>, lane 2
    1746174059U, // <2,2,1,u>: Cost 2 vuzpr <0,2,0,2>, LHS
    1489829990U, // <2,2,2,0>: Cost 2 vext1 <2,2,2,2>, LHS
    2093858819U, // <2,2,2,1>: Cost 2 ins <2,2,2,u>, lane 3
    269271142U,  // <2,2,2,2>: Cost 1 vdup2 LHS
    1884520550U, // <2,2,2,3>: Cost 2 vzipr <0,u,2,2>, LHS
    1489833270U, // <2,2,2,4>: Cost 2 vext1 <2,2,2,2>, RHS
    2093858819U, // <2,2,2,5>: Cost 2 ins <2,2,2,u>, lane 3
    2093858819U, // <2,2,2,6>: Cost 2 ins <2,2,2,u>, lane 3
    2093858819U, // <2,2,2,7>: Cost 2 ins <2,2,2,u>, lane 3
    269271142U,  // <2,2,2,u>: Cost 1 vdup2 LHS
    2129698816U, // <2,2,3,0>: Cost 2 ins <u,2,3,0>, lane 0
    2093932547U, // <2,2,3,1>: Cost 2 ins <2,2,3,u>, lane 3
    1879885416U, // <2,2,3,2>: Cost 2 vzipr LHS, <2,2,2,2>
    806142054U,  // <2,2,3,3>: Cost 1 vzipr LHS, LHS
    2129731584U, // <2,2,3,4>: Cost 2 ins <u,2,3,4>, lane 0
    2093932547U, // <2,2,3,5>: Cost 2 ins <2,2,3,u>, lane 3
    1884528988U, // <2,2,3,6>: Cost 2 vzipr LHS, <0,4,2,6>
    2097905665U, // <2,2,3,7>: Cost 2 ins <2,u,3,7>, lane 1
    806142059U,  // <2,2,3,u>: Cost 1 vzipr LHS, LHS
    2551644344U, // <2,2,4,0>: Cost 3 vext1 <0,2,2,4>, <0,2,2,4>
    3171672065U, // <2,2,4,1>: Cost 3 ins <2,u,4,1>, lane 1
    2094252034U, // <2,2,4,2>: Cost 2 ins <2,2,u,2>, lane 2
    2094260226U, // <2,2,4,3>: Cost 2 ins <2,2,u,3>, lane 2
    2020819866U, // <2,2,4,4>: Cost 2 vtrnr <1,2,3,4>, <1,2,3,4>
    1548979510U, // <2,2,4,5>: Cost 2 vext2 <0,u,2,2>, RHS
    1691159862U, // <2,2,4,6>: Cost 2 vuzpl <2,2,2,2>, RHS
    3171721217U, // <2,2,4,7>: Cost 3 ins <2,u,4,7>, lane 1
    1548979753U, // <2,2,4,u>: Cost 2 vext2 <0,u,2,2>, RHS
    3167821827U, // <2,2,5,0>: Cost 3 ins <2,2,5,u>, lane 3
    2670497488U, // <2,2,5,1>: Cost 3 vext2 <u,u,2,2>, <5,1,7,3>
    2094252034U, // <2,2,5,2>: Cost 2 ins <2,2,u,2>, lane 2
    2094260226U, // <2,2,5,3>: Cost 2 ins <2,2,u,3>, lane 2
    2228201085U, // <2,2,5,4>: Cost 3 vrev <2,2,4,5>
    1879900264U, // <2,2,5,5>: Cost 2 vzipr <0,1,2,5>, <0,1,2,5>
    2670497890U, // <2,2,5,6>: Cost 3 vext2 <u,u,2,2>, <5,6,7,0>
    1746177334U, // <2,2,5,7>: Cost 2 vuzpr <0,2,0,2>, RHS
    1746177335U, // <2,2,5,u>: Cost 2 vuzpr <0,2,0,2>, RHS
    3088679830U, // <2,2,6,0>: Cost 3 vtrnr <0,2,4,6>, <1,2,3,0>
    3171819521U, // <2,2,6,1>: Cost 3 ins <2,u,6,1>, lane 1
    2094252034U, // <2,2,6,2>: Cost 2 ins <2,2,u,2>, lane 2
    1881899110U, // <2,2,6,3>: Cost 2 vzipr <0,4,2,6>, LHS
    3088679078U, // <2,2,6,4>: Cost 3 vtrnr <0,2,4,6>, <0,2,0,4>
    3171852289U, // <2,2,6,5>: Cost 3 ins <2,u,6,5>, lane 1
    2014937292U, // <2,2,6,6>: Cost 2 vtrnr <0,2,4,6>, <0,2,4,6>
    2094301189U, // <2,2,6,7>: Cost 2 ins <2,2,u,u>, lane 5
    1881899115U, // <2,2,6,u>: Cost 2 vzipr <0,4,2,6>, LHS
    2726250474U, // <2,2,7,0>: Cost 3 vext3 <7,0,1,2>, <2,7,0,1>
    2867696462U, // <2,2,7,1>: Cost 3 vuzpr <u,2,0,2>, <6,7,0,1>
    2094252034U, // <2,2,7,2>: Cost 2 ins <2,2,u,2>, lane 2
    2130018304U, // <2,2,7,3>: Cost 2 ins <u,2,7,3>, lane 0
    2670499174U, // <2,2,7,4>: Cost 3 vext2 <u,u,2,2>, <7,4,5,6>
    2228291208U, // <2,2,7,5>: Cost 3 vrev <2,2,5,7>
    3203784704U, // <2,2,7,6>: Cost 3 ins <u,2,7,6>, lane 0
    1879916650U, // <2,2,7,7>: Cost 2 vzipr <0,1,2,7>, <0,1,2,7>
    2130018304U, // <2,2,7,u>: Cost 2 ins <u,2,7,3>, lane 0
    2020787094U, // <2,2,u,0>: Cost 2 vtrnr <1,2,3,0>, <1,2,3,0>
    1548982062U, // <2,2,u,1>: Cost 2 vext2 <0,u,2,2>, LHS
    269271142U,  // <2,2,u,2>: Cost 1 vdup2 LHS
    806183014U,  // <2,2,u,3>: Cost 1 vzipr LHS, LHS
    1489833270U, // <2,2,u,4>: Cost 2 vext1 <2,2,2,2>, RHS
    1548982426U, // <2,2,u,5>: Cost 2 vext2 <0,u,2,2>, RHS
    1879925084U, // <2,2,u,6>: Cost 2 vzipr LHS, <0,4,2,6>
    1746177577U, // <2,2,u,7>: Cost 2 vuzpr <0,2,0,2>, RHS
    806183019U,  // <2,2,u,u>: Cost 1 vzipr LHS, LHS
    1544339456U, // <2,3,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
    470597734U,  // <2,3,0,1>: Cost 1 vext2 LHS, LHS
    1548984484U, // <2,3,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
    2094374915U, // <2,3,0,3>: Cost 2 ins <2,3,0,u>, lane 3
    1548984658U, // <2,3,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
    2094940162U, // <2,3,0,5>: Cost 2 ins <2,3,u,5>, lane 2
    2094374915U, // <2,3,0,6>: Cost 2 ins <2,3,0,u>, lane 3
    2094374915U, // <2,3,0,7>: Cost 2 ins <2,3,0,u>, lane 3
    470598301U,  // <2,3,0,u>: Cost 1 vext2 LHS, LHS
    1544340214U, // <2,3,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
    1544340276U, // <2,3,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
    1544340374U, // <2,3,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
    1548985304U, // <2,3,1,3>: Cost 2 vext2 LHS, <1,3,1,3>
    2551696694U, // <2,3,1,4>: Cost 3 vext1 <0,2,3,1>, RHS
    1548985488U, // <2,3,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
    2622727375U, // <2,3,1,6>: Cost 3 vext2 LHS, <1,6,1,7>
    2094956546U, // <2,3,1,7>: Cost 2 ins <2,3,u,7>, lane 2
    1548985709U, // <2,3,1,u>: Cost 2 vext2 LHS, <1,u,1,3>
    2094522371U, // <2,3,2,0>: Cost 2 ins <2,3,2,u>, lane 3
    2094907394U, // <2,3,2,1>: Cost 2 ins <2,3,u,1>, lane 2
    1544341096U, // <2,3,2,2>: Cost 2 vext2 LHS, <2,2,2,2>
    1059889156U, // <2,3,2,3>: Cost 1 ins LHS, lane 4
    2094522371U, // <2,3,2,4>: Cost 2 ins <2,3,2,u>, lane 3
    2094940162U, // <2,3,2,5>: Cost 2 ins <2,3,u,5>, lane 2
    1548986298U, // <2,3,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
    2094956546U, // <2,3,2,7>: Cost 2 ins <2,3,u,7>, lane 2
    1059889156U, // <2,3,2,u>: Cost 1 ins LHS, lane 4
    1879884694U, // <2,3,3,0>: Cost 2 vzipr LHS, <1,2,3,0>
    2094907394U, // <2,3,3,1>: Cost 2 ins <2,3,u,1>, lane 2
    1879884534U, // <2,3,3,2>: Cost 2 vzipr LHS, <1,0,3,2>
    1544341916U, // <2,3,3,3>: Cost 2 vext2 LHS, <3,3,3,3>
    1879884698U, // <2,3,3,4>: Cost 2 vzipr LHS, <1,2,3,4>
    2094940162U, // <2,3,3,5>: Cost 2 ins <2,3,u,5>, lane 2
    2953627415U, // <2,3,3,6>: Cost 3 vzipr LHS, <2,4,3,6>
    1884529808U, // <2,3,3,7>: Cost 2 vzipr LHS, <1,5,3,7>
    1879884702U, // <2,3,3,u>: Cost 2 vzipr LHS, <1,2,3,u>
    1483948134U, // <2,3,4,0>: Cost 2 vext1 <1,2,3,4>, LHS
    1483948954U, // <2,3,4,1>: Cost 2 vext1 <1,2,3,4>, <1,2,3,4>
    2094669827U, // <2,3,4,2>: Cost 2 ins <2,3,4,u>, lane 3
    2094669827U, // <2,3,4,3>: Cost 2 ins <2,3,4,u>, lane 3
    1483951414U, // <2,3,4,4>: Cost 2 vext1 <1,2,3,4>, RHS
    470601014U,  // <2,3,4,5>: Cost 1 vext2 LHS, RHS
    1691241782U, // <2,3,4,6>: Cost 2 vuzpl <2,2,3,3>, RHS
    2094669827U, // <2,3,4,7>: Cost 2 ins <2,3,4,u>, lane 3
    470601257U,  // <2,3,4,u>: Cost 1 vext2 LHS, RHS
    2551726274U, // <2,3,5,0>: Cost 3 vext1 <0,2,3,5>, <0,2,3,5>
    1592118992U, // <2,3,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
    2665860843U, // <2,3,5,2>: Cost 3 vext2 LHS, <5,2,1,3>
    2094923778U, // <2,3,5,3>: Cost 2 ins <2,3,u,3>, lane 2
    1592119238U, // <2,3,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
    1592119300U, // <2,3,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
    1592119394U, // <2,3,5,6>: Cost 2 vext2 LHS, <5,6,7,0>
    1758350646U, // <2,3,5,7>: Cost 2 vuzpr <2,2,3,3>, RHS
    1758350647U, // <2,3,5,u>: Cost 2 vuzpr <2,2,3,3>, RHS
    2094817283U, // <2,3,6,0>: Cost 2 ins <2,3,6,u>, lane 3
    2094907394U, // <2,3,6,1>: Cost 2 ins <2,3,u,1>, lane 2
    1592119802U, // <2,3,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
    2094923778U, // <2,3,6,3>: Cost 2 ins <2,3,u,3>, lane 2
    2094817283U, // <2,3,6,4>: Cost 2 ins <2,3,6,u>, lane 3
    2094940162U, // <2,3,6,5>: Cost 2 ins <2,3,u,5>, lane 2
    1592120120U, // <2,3,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
    1060216836U, // <2,3,6,7>: Cost 1 ins RHS, lane 4
    1060216836U, // <2,3,6,u>: Cost 1 ins RHS, lane 4
    1592120314U, // <2,3,7,0>: Cost 2 vext2 LHS, <7,0,1,2>
    2094907394U, // <2,3,7,1>: Cost 2 ins <2,3,u,1>, lane 2
    2974892790U, // <2,3,7,2>: Cost 3 vzipr <3,6,2,7>, <1,0,3,2>
    2133999620U, // <2,3,7,3>: Cost 2 ins <u,u,7,3>, lane 4
    1592120678U, // <2,3,7,4>: Cost 2 vext2 LHS, <7,4,5,6>
    2094940162U, // <2,3,7,5>: Cost 2 ins <2,3,u,5>, lane 2
    2134024196U, // <2,3,7,6>: Cost 2 ins <u,u,7,6>, lane 4
    1592120940U, // <2,3,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
    1592120962U, // <2,3,7,u>: Cost 2 vext2 LHS, <7,u,1,2>
    1879925654U, // <2,3,u,0>: Cost 2 vzipr LHS, <1,2,3,0>
    470603566U,  // <2,3,u,1>: Cost 1 vext2 LHS, LHS
    1879925494U, // <2,3,u,2>: Cost 2 vzipr LHS, <1,0,3,2>
    1059889156U, // <2,3,u,3>: Cost 1 ins LHS, lane 4
    1879925658U, // <2,3,u,4>: Cost 2 vzipr LHS, <1,2,3,4>
    470603930U,  // <2,3,u,5>: Cost 1 vext2 LHS, RHS
    1548990672U, // <2,3,u,6>: Cost 2 vext2 LHS, <u,6,3,7>
    1060216836U, // <2,3,u,7>: Cost 1 ins RHS, lane 4
    470604133U,  // <2,3,u,u>: Cost 1 vext2 LHS, LHS
    2826125312U, // <2,4,0,0>: Cost 3 vuzpr <1,2,3,4>, <0,0,0,0>
    2097635329U, // <2,4,0,1>: Cost 2 ins <2,u,0,1>, lane 1
    1691992166U, // <2,4,0,2>: Cost 2 vuzpl <2,3,4,5>, LHS
    3171393537U, // <2,4,0,3>: Cost 3 ins <2,u,0,3>, lane 1
    2765734092U, // <2,4,0,4>: Cost 3 vuzpl <2,3,4,5>, <0,2,4,6>
    3094528338U, // <2,4,0,5>: Cost 3 vtrnr <1,2,3,0>, <0,4,1,5>
    1960103222U, // <2,4,0,6>: Cost 2 vtrnl <2,3,0,1>, RHS
    3171426305U, // <2,4,0,7>: Cost 3 ins <2,u,0,7>, lane 1
    1960103240U, // <2,4,0,u>: Cost 2 vtrnl <2,3,0,1>, RHS
    3204620288U, // <2,4,1,0>: Cost 3 ins <u,4,1,0>, lane 0
    2826126132U, // <2,4,1,1>: Cost 3 vuzpr <1,2,3,4>, <1,1,1,1>
    2625389466U, // <2,4,1,2>: Cost 3 vext2 <1,3,2,4>, <1,2,3,4>
    1752383590U, // <2,4,1,3>: Cost 2 vuzpr <1,2,3,4>, LHS
    3204653056U, // <2,4,1,4>: Cost 3 ins <u,4,1,4>, lane 0
    2130919424U, // <2,4,1,5>: Cost 2 ins <u,4,1,5>, lane 0
    3031936310U, // <2,4,1,6>: Cost 3 vtrnl <2,0,1,2>, RHS
    3169361922U, // <2,4,1,7>: Cost 3 ins <2,4,u,7>, lane 2
    1752383595U, // <2,4,1,u>: Cost 2 vuzpr <1,2,3,4>, LHS
    2826126230U, // <2,4,2,0>: Cost 3 vuzpr <1,2,3,4>, <1,2,3,0>
    3171524609U, // <2,4,2,1>: Cost 3 ins <2,u,2,1>, lane 1
    2097790977U, // <2,4,2,2>: Cost 2 ins <2,u,2,2>, lane 1
    2130976768U, // <2,4,2,3>: Cost 2 ins <u,4,2,3>, lane 0
    1752384410U, // <2,4,2,4>: Cost 2 vuzpr <1,2,3,4>, <1,2,3,4>
    1825377590U, // <2,4,2,5>: Cost 2 vzipl <2,2,2,2>, RHS
    1959595318U, // <2,4,2,6>: Cost 2 vtrnl <2,2,2,2>, RHS
    3171573761U, // <2,4,2,7>: Cost 3 ins <2,u,2,7>, lane 1
    1825377833U, // <2,4,2,u>: Cost 2 vzipl <2,2,2,2>, RHS
    2826127049U, // <2,4,3,0>: Cost 3 vuzpr <1,2,3,4>, <2,3,4,0>
    2958270501U, // <2,4,3,1>: Cost 3 vzipr LHS, <0,0,4,1>
    2958270502U, // <2,4,3,2>: Cost 3 vzipr LHS, <0,0,4,2>
    2097872897U, // <2,4,3,3>: Cost 2 ins <2,u,3,3>, lane 1
    1927662800U, // <2,4,3,4>: Cost 2 vzipr LHS, <4,4,4,4>
    1879885518U, // <2,4,3,5>: Cost 2 vzipr LHS, <2,3,4,5>
    1879883980U, // <2,4,3,6>: Cost 2 vzipr LHS, <0,2,4,6>
    2097905665U, // <2,4,3,7>: Cost 2 ins <2,u,3,7>, lane 1
    1879883982U, // <2,4,3,u>: Cost 2 vzipr LHS, <0,2,4,u>
    2563735654U, // <2,4,4,0>: Cost 3 vext1 <2,2,4,4>, LHS
    2826127824U, // <2,4,4,1>: Cost 3 vuzpr <1,2,3,4>, <3,4,0,1>
    2826127834U, // <2,4,4,2>: Cost 3 vuzpr <1,2,3,4>, <3,4,1,2>
    2826127106U, // <2,4,4,3>: Cost 3 vuzpr <1,2,3,4>, <2,4,1,3>
    2131132416U, // <2,4,4,4>: Cost 2 ins <u,4,4,4>, lane 0
    2097963009U, // <2,4,4,5>: Cost 2 ins <2,u,4,5>, lane 1
    1691995446U, // <2,4,4,6>: Cost 2 vuzpl <2,3,4,5>, RHS
    3094562602U, // <2,4,4,7>: Cost 3 vtrnr <1,2,3,4>, <2,4,5,7>
    1691995464U, // <2,4,4,u>: Cost 2 vuzpl <2,3,4,5>, RHS
    2551800011U, // <2,4,5,0>: Cost 3 vext1 <0,2,4,5>, <0,2,4,5>
    2569716470U, // <2,4,5,1>: Cost 3 vext1 <3,2,4,5>, <1,0,3,2>
    2563745405U, // <2,4,5,2>: Cost 3 vext1 <2,2,4,5>, <2,2,4,5>
    2765737726U, // <2,4,5,3>: Cost 3 vuzpl <2,3,4,5>, <5,2,3,4>
    2551803190U, // <2,4,5,4>: Cost 3 vext1 <0,2,4,5>, RHS
    2131214336U, // <2,4,5,5>: Cost 2 ins <u,4,5,5>, lane 0
    1611959606U, // <2,4,5,6>: Cost 2 vext3 <0,2,0,2>, RHS
    1752386870U, // <2,4,5,7>: Cost 2 vuzpr <1,2,3,4>, RHS
    1611959624U, // <2,4,5,u>: Cost 2 vext3 <0,2,0,2>, RHS
    1478066380U, // <2,4,6,0>: Cost 2 vext1 <0,2,4,6>, <0,2,4,6>
    2551808758U, // <2,4,6,1>: Cost 3 vext1 <0,2,4,6>, <1,0,3,2>
    2551809516U, // <2,4,6,2>: Cost 3 vext1 <0,2,4,6>, <2,0,6,4>
    2551810198U, // <2,4,6,3>: Cost 3 vext1 <0,2,4,6>, <3,0,1,2>
    1478069558U, // <2,4,6,4>: Cost 2 vext1 <0,2,4,6>, RHS
    1828146486U, // <2,4,6,5>: Cost 2 vzipl <2,6,3,7>, RHS
    2131296256U, // <2,4,6,6>: Cost 2 ins <u,4,6,6>, lane 0
    2131304448U, // <2,4,6,7>: Cost 2 ins <u,4,6,7>, lane 0
    1478072110U, // <2,4,6,u>: Cost 2 vext1 <0,2,4,6>, LHS
    2659234821U, // <2,4,7,0>: Cost 3 vext2 <7,0,2,4>, <7,0,2,4>
    2867934030U, // <2,4,7,1>: Cost 3 vuzpr <u,2,3,4>, <6,7,0,1>
    3169320962U, // <2,4,7,2>: Cost 3 ins <2,4,u,2>, lane 2
    2867933312U, // <2,4,7,3>: Cost 3 vuzpr <u,2,3,4>, <5,7,1,3>
    3205095424U, // <2,4,7,4>: Cost 3 ins <u,4,7,4>, lane 0
    2726251976U, // <2,4,7,5>: Cost 3 vext3 <7,0,1,2>, <4,7,5,0>
    2131369984U, // <2,4,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    2867933352U, // <2,4,7,7>: Cost 3 vuzpr <u,2,3,4>, <5,7,5,7>
    2131369984U, // <2,4,7,u>: Cost 2 ins <u,4,7,6>, lane 0
    1478082766U, // <2,4,u,0>: Cost 2 vext1 <0,2,4,u>, <0,2,4,u>
    2097635329U, // <2,4,u,1>: Cost 2 ins <2,u,0,1>, lane 1
    1691997998U, // <2,4,u,2>: Cost 2 vuzpl <2,3,4,5>, LHS
    1752384157U, // <2,4,u,3>: Cost 2 vuzpr <1,2,3,4>, LHS
    1478085942U, // <2,4,u,4>: Cost 2 vext1 <0,2,4,u>, RHS
    1879926478U, // <2,4,u,5>: Cost 2 vzipr LHS, <2,3,4,5>
    1879924940U, // <2,4,u,6>: Cost 2 vzipr LHS, <0,2,4,6>
    1752387113U, // <2,4,u,7>: Cost 2 vuzpr <1,2,3,4>, RHS
    1879924942U, // <2,4,u,u>: Cost 2 vzipr LHS, <0,2,4,u>
    2765160612U, // <2,5,0,0>: Cost 3 vuzpl <2,2,5,7>, <0,2,0,2>
    2097635329U, // <2,5,0,1>: Cost 2 ins <2,u,0,1>, lane 1
    2620088484U, // <2,5,0,2>: Cost 3 vext2 <0,4,2,5>, <0,2,0,2>
    2619425034U, // <2,5,0,3>: Cost 3 vext2 <0,3,2,5>, <0,3,2,5>
    2620088667U, // <2,5,0,4>: Cost 3 vext2 <0,4,2,5>, <0,4,2,5>
    3136335876U, // <2,5,0,5>: Cost 3 vtrnr <u,2,3,0>, <5,5,5,5>
    3171418113U, // <2,5,0,6>: Cost 3 ins <2,u,0,6>, lane 1
    2020789558U, // <2,5,0,7>: Cost 2 vtrnr <1,2,3,0>, RHS
    2020789559U, // <2,5,0,u>: Cost 2 vtrnr <1,2,3,0>, RHS
    2599616614U, // <2,5,1,0>: Cost 3 vext1 <u,2,5,1>, LHS
    3205292032U, // <2,5,1,1>: Cost 3 ins <u,5,1,1>, lane 0
    2626061206U, // <2,5,1,2>: Cost 3 vext2 <1,4,2,5>, <1,2,3,0>
    2618098688U, // <2,5,1,3>: Cost 3 vext2 <0,1,2,5>, <1,3,5,7>
    2626061364U, // <2,5,1,4>: Cost 3 vext2 <1,4,2,5>, <1,4,2,5>
    2599620736U, // <2,5,1,5>: Cost 3 vext1 <u,2,5,1>, <5,7,1,3>
    3205332992U, // <2,5,1,6>: Cost 3 ins <u,5,1,6>, lane 0
    2131599360U, // <2,5,1,7>: Cost 2 ins <u,5,1,7>, lane 0
    2131599360U, // <2,5,1,u>: Cost 2 ins <u,5,1,7>, lane 0
    3171516417U, // <2,5,2,0>: Cost 3 ins <2,u,2,0>, lane 1
    3006040978U, // <2,5,2,1>: Cost 3 vzipr <u,u,2,2>, <4,0,5,1>
    2097790977U, // <2,5,2,2>: Cost 2 ins <2,u,2,2>, lane 1
    2131640320U, // <2,5,2,3>: Cost 2 ins <u,5,2,3>, lane 0
    2632034061U, // <2,5,2,4>: Cost 3 vext2 <2,4,2,5>, <2,4,2,5>
    2820014256U, // <2,5,2,5>: Cost 3 vuzpr <0,2,1,5>, <0,2,1,5>
    2958264834U, // <2,5,2,6>: Cost 3 vzipr <0,u,2,2>, <3,4,5,6>
    2014612790U, // <2,5,2,7>: Cost 2 vtrnr <0,2,0,2>, RHS
    2014612791U, // <2,5,2,u>: Cost 2 vtrnr <0,2,0,2>, RHS
    2958273506U, // <2,5,3,0>: Cost 3 vzipr LHS, <4,1,5,0>
    1927662482U, // <2,5,3,1>: Cost 2 vzipr LHS, <4,0,5,1>
    2899955454U, // <2,5,3,2>: Cost 3 vzipl <2,3,4,5>, <5,2,3,4>
    2097872897U, // <2,5,3,3>: Cost 2 ins <2,u,3,3>, lane 1
    2619427330U, // <2,5,3,4>: Cost 3 vext2 <0,3,2,5>, <3,4,5,6>
    1927662810U, // <2,5,3,5>: Cost 2 vzipr LHS, <4,4,5,5>
    1879886338U, // <2,5,3,6>: Cost 2 vzipr LHS, <3,4,5,6>
    1879884800U, // <2,5,3,7>: Cost 2 vzipr LHS, <1,3,5,7>
    1879884801U, // <2,5,3,u>: Cost 2 vzipr LHS, <1,3,5,u>
    2569781350U, // <2,5,4,0>: Cost 3 vext1 <3,2,5,4>, LHS
    3171672065U, // <2,5,4,1>: Cost 3 ins <2,u,4,1>, lane 1
    2569782990U, // <2,5,4,2>: Cost 3 vext1 <3,2,5,4>, <2,3,4,5>
    3034173182U, // <2,5,4,3>: Cost 3 vtrnl <2,3,4,5>, <5,2,3,4>
    2569784630U, // <2,5,4,4>: Cost 3 vext1 <3,2,5,4>, RHS
    2097963009U, // <2,5,4,5>: Cost 2 ins <2,u,4,5>, lane 1
    2820164098U, // <2,5,4,6>: Cost 3 vuzpr <0,2,3,5>, <3,4,5,6>
    2020822326U, // <2,5,4,7>: Cost 2 vtrnr <1,2,3,4>, RHS
    2020822327U, // <2,5,4,u>: Cost 2 vtrnr <1,2,3,4>, RHS
    2599649382U, // <2,5,5,0>: Cost 3 vext1 <u,2,5,5>, LHS
    3003411346U, // <2,5,5,1>: Cost 3 vzipr <u,4,2,5>, <4,0,5,1>
    2563819142U, // <2,5,5,2>: Cost 3 vext1 <2,2,5,5>, <2,2,5,5>
    2953642113U, // <2,5,5,3>: Cost 3 vzipr <0,1,2,5>, <0,1,5,3>
    2599652662U, // <2,5,5,4>: Cost 3 vext1 <u,2,5,5>, RHS
    2131877888U, // <2,5,5,5>: Cost 2 ins <u,5,5,5>, lane 0
    2954971650U, // <2,5,5,6>: Cost 3 vzipr <0,3,2,5>, <3,4,5,6>
    2131894272U, // <2,5,5,7>: Cost 2 ins <u,5,5,7>, lane 0
    2131877888U, // <2,5,5,u>: Cost 2 ins <u,5,5,5>, lane 0
    2131910656U, // <2,5,6,0>: Cost 2 ins <u,5,6,0>, lane 0
    2131918848U, // <2,5,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2131927040U, // <2,5,6,2>: Cost 2 ins <u,5,6,2>, lane 0
    2131935232U, // <2,5,6,3>: Cost 2 ins <u,5,6,3>, lane 0
    2131943424U, // <2,5,6,4>: Cost 2 ins <u,5,6,4>, lane 0
    2131951616U, // <2,5,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    2131959808U, // <2,5,6,6>: Cost 2 ins <u,5,6,6>, lane 0
    1058226176U, // <2,5,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <2,5,6,u>: Cost 1 ins RHS, lane 0
    2563833958U, // <2,5,7,0>: Cost 3 vext1 <2,2,5,7>, LHS
    2712244352U, // <2,5,7,1>: Cost 3 vext3 <4,6,0,2>, <5,7,1,3>
    2563835528U, // <2,5,7,2>: Cost 3 vext1 <2,2,5,7>, <2,2,5,7>
    2953658497U, // <2,5,7,3>: Cost 3 vzipr <0,1,2,7>, <0,1,5,3>
    2563837238U, // <2,5,7,4>: Cost 3 vext1 <2,2,5,7>, RHS
    2712244392U, // <2,5,7,5>: Cost 3 vext3 <4,6,0,2>, <5,7,5,7>
    2712244396U, // <2,5,7,6>: Cost 3 vext3 <4,6,0,2>, <5,7,6,2>
    2132041728U, // <2,5,7,7>: Cost 2 ins <u,5,7,7>, lane 0
    2132041728U, // <2,5,7,u>: Cost 2 ins <u,5,7,7>, lane 0
    2131910656U, // <2,5,u,0>: Cost 2 ins <u,5,6,0>, lane 0
    1927703442U, // <2,5,u,1>: Cost 2 vzipr LHS, <4,0,5,1>
    2097790977U, // <2,5,u,2>: Cost 2 ins <2,u,2,2>, lane 1
    2097872897U, // <2,5,u,3>: Cost 2 ins <2,u,3,3>, lane 1
    2131943424U, // <2,5,u,4>: Cost 2 ins <u,5,6,4>, lane 0
    1927703770U, // <2,5,u,5>: Cost 2 vzipr LHS, <4,4,5,5>
    1879927298U, // <2,5,u,6>: Cost 2 vzipr LHS, <3,4,5,6>
    1058226176U, // <2,5,u,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <2,5,u,u>: Cost 1 ins RHS, lane 0
    2820243456U, // <2,6,0,0>: Cost 3 vuzpr <0,2,4,6>, <0,0,0,0>
    1546354790U, // <2,6,0,1>: Cost 2 vext2 <0,4,2,6>, LHS
    2132148224U, // <2,6,0,2>: Cost 2 ins <u,6,0,2>, lane 0
    3171393537U, // <2,6,0,3>: Cost 3 ins <2,u,0,3>, lane 1
    1546355036U, // <2,6,0,4>: Cost 2 vext2 <0,4,2,6>, <0,4,2,6>
    3170672642U, // <2,6,0,5>: Cost 3 ins <2,6,u,5>, lane 2
    3136335220U, // <2,6,0,6>: Cost 3 vtrnr <u,2,3,0>, <4,6,4,6>
    2096947202U, // <2,6,0,7>: Cost 2 ins <2,6,u,7>, lane 2
    1546355357U, // <2,6,0,u>: Cost 2 vext2 <0,4,2,6>, LHS
    2620097270U, // <2,6,1,0>: Cost 3 vext2 <0,4,2,6>, <1,0,3,2>
    2820244276U, // <2,6,1,1>: Cost 3 vuzpr <0,2,4,6>, <1,1,1,1>
    2620097430U, // <2,6,1,2>: Cost 3 vext2 <0,4,2,6>, <1,2,3,0>
    1746501734U, // <2,6,1,3>: Cost 2 vuzpr <0,2,4,6>, LHS
    2620097598U, // <2,6,1,4>: Cost 3 vext2 <0,4,2,6>, <1,4,3,6>
    2620097680U, // <2,6,1,5>: Cost 3 vext2 <0,4,2,6>, <1,5,3,7>
    3205996544U, // <2,6,1,6>: Cost 3 ins <u,6,1,6>, lane 0
    2096947202U, // <2,6,1,7>: Cost 2 ins <2,6,u,7>, lane 2
    1746501739U, // <2,6,1,u>: Cost 2 vuzpr <0,2,4,6>, LHS
    2820244374U, // <2,6,2,0>: Cost 3 vuzpr <0,2,4,6>, <1,2,3,0>
    3171524609U, // <2,6,2,1>: Cost 3 ins <2,u,2,1>, lane 1
    2097790977U, // <2,6,2,2>: Cost 2 ins <2,u,2,2>, lane 1
    2096955397U, // <2,6,2,3>: Cost 2 ins <2,6,u,u>, lane 5
    2820243622U, // <2,6,2,4>: Cost 3 vuzpr <0,2,4,6>, <0,2,0,4>
    3171557377U, // <2,6,2,5>: Cost 3 ins <2,u,2,5>, lane 1
    1746501836U, // <2,6,2,6>: Cost 2 vuzpr <0,2,4,6>, <0,2,4,6>
    1884523830U, // <2,6,2,7>: Cost 2 vzipr <0,u,2,2>, RHS
    1884523831U, // <2,6,2,u>: Cost 2 vzipr <0,u,2,2>, RHS
    2096586755U, // <2,6,3,0>: Cost 2 ins <2,6,3,u>, lane 3
    2096586755U, // <2,6,3,1>: Cost 2 ins <2,6,3,u>, lane 3
    1927662492U, // <2,6,3,2>: Cost 2 vzipr LHS, <4,0,6,2>
    2097872897U, // <2,6,3,3>: Cost 2 ins <2,u,3,3>, lane 1
    2096586755U, // <2,6,3,4>: Cost 2 ins <2,6,3,u>, lane 3
    2096586755U, // <2,6,3,5>: Cost 2 ins <2,6,3,u>, lane 3
    1927662820U, // <2,6,3,6>: Cost 2 vzipr LHS, <4,4,6,6>
    806145334U,  // <2,6,3,7>: Cost 1 vzipr LHS, RHS
    806145335U,  // <2,6,3,u>: Cost 1 vzipr LHS, RHS
    2820245292U, // <2,6,4,0>: Cost 3 vuzpr <0,2,4,6>, <2,4,6,0>
    3171672065U, // <2,6,4,1>: Cost 3 ins <2,u,4,1>, lane 1
    2820243782U, // <2,6,4,2>: Cost 3 vuzpr <0,2,4,6>, <0,4,0,2>
    3171688449U, // <2,6,4,3>: Cost 3 ins <2,u,4,3>, lane 1
    2820243784U, // <2,6,4,4>: Cost 3 vuzpr <0,2,4,6>, <0,4,0,4>
    1546358070U, // <2,6,4,5>: Cost 2 vext2 <0,4,2,6>, RHS
    2132475904U, // <2,6,4,6>: Cost 2 ins <u,6,4,6>, lane 0
    2096947202U, // <2,6,4,7>: Cost 2 ins <2,6,u,7>, lane 2
    1546358313U, // <2,6,4,u>: Cost 2 vext2 <0,4,2,6>, RHS
    3170476035U, // <2,6,5,0>: Cost 3 ins <2,6,5,u>, lane 3
    2667876048U, // <2,6,5,1>: Cost 3 vext2 <u,4,2,6>, <5,1,7,3>
    3206258688U, // <2,6,5,2>: Cost 3 ins <u,6,5,2>, lane 0
    3170656258U, // <2,6,5,3>: Cost 3 ins <2,6,u,3>, lane 2
    2252091873U, // <2,6,5,4>: Cost 3 vrev <6,2,4,5>
    2868023300U, // <2,6,5,5>: Cost 3 vuzpr <u,2,4,6>, <5,5,5,5>
    2667876450U, // <2,6,5,6>: Cost 3 vext2 <u,4,2,6>, <5,6,7,0>
    1746505014U, // <2,6,5,7>: Cost 2 vuzpr <0,2,4,6>, RHS
    1746505015U, // <2,6,5,u>: Cost 2 vuzpr <0,2,4,6>, RHS
    2955643964U, // <2,6,6,0>: Cost 3 vzipr <0,4,2,6>, <4,2,6,0>
    2820246859U, // <2,6,6,1>: Cost 3 vuzpr <0,2,4,6>, <4,6,0,1>
    2820246860U, // <2,6,6,2>: Cost 3 vuzpr <0,2,4,6>, <4,6,0,2>
    2820245412U, // <2,6,6,3>: Cost 3 vuzpr <0,2,4,6>, <2,6,1,3>
    2955643968U, // <2,6,6,4>: Cost 3 vzipr <0,4,2,6>, <4,2,6,4>
    2820246899U, // <2,6,6,5>: Cost 3 vuzpr <0,2,4,6>, <4,6,4,5>
    2132623360U, // <2,6,6,6>: Cost 2 ins <u,6,6,6>, lane 0
    1881902390U, // <2,6,6,7>: Cost 2 vzipr <0,4,2,6>, RHS
    1881902391U, // <2,6,6,u>: Cost 2 vzipr <0,4,2,6>, RHS
    2132647936U, // <2,6,7,0>: Cost 2 ins <u,6,7,0>, lane 0
    2724926296U, // <2,6,7,1>: Cost 3 vext3 <6,7,1,2>, <6,7,1,2>
    3124596044U, // <2,6,7,2>: Cost 3 vtrnr <6,2,5,7>, <4,6,0,2>
    2868023424U, // <2,6,7,3>: Cost 3 vuzpr <u,2,4,6>, <5,7,1,3>
    2132680704U, // <2,6,7,4>: Cost 2 ins <u,6,7,4>, lane 0
    2252181996U, // <2,6,7,5>: Cost 3 vrev <6,2,5,7>
    2725294981U, // <2,6,7,6>: Cost 3 vext3 <6,7,6,2>, <6,7,6,2>
    2132705280U, // <2,6,7,7>: Cost 2 ins <u,6,7,7>, lane 0
    2132647936U, // <2,6,7,u>: Cost 2 ins <u,6,7,0>, lane 0
    2096586755U, // <2,6,u,0>: Cost 2 ins <2,6,3,u>, lane 3
    1546360622U, // <2,6,u,1>: Cost 2 vext2 <0,4,2,6>, LHS
    1927703452U, // <2,6,u,2>: Cost 2 vzipr LHS, <4,0,6,2>
    1746502301U, // <2,6,u,3>: Cost 2 vuzpr <0,2,4,6>, LHS
    1594136612U, // <2,6,u,4>: Cost 2 vext2 <u,4,2,6>, <u,4,2,6>
    1546360986U, // <2,6,u,5>: Cost 2 vext2 <0,4,2,6>, RHS
    1927703780U, // <2,6,u,6>: Cost 2 vzipr LHS, <4,4,6,6>
    806186294U,  // <2,6,u,7>: Cost 1 vzipr LHS, RHS
    806186295U,  // <2,6,u,u>: Cost 1 vzipr LHS, RHS
    2581839974U, // <2,7,0,0>: Cost 3 vext1 <5,2,7,0>, LHS
    1652511738U, // <2,7,0,1>: Cost 2 vext3 <7,0,1,2>, <7,0,1,2>
    2621431972U, // <2,7,0,2>: Cost 3 vext2 <0,6,2,7>, <0,2,0,2>
    2257949868U, // <2,7,0,3>: Cost 3 vrev <7,2,3,0>
    2581843254U, // <2,7,0,4>: Cost 3 vext1 <5,2,7,0>, RHS
    2581843742U, // <2,7,0,5>: Cost 3 vext1 <5,2,7,0>, <5,2,7,0>
    2621432319U, // <2,7,0,6>: Cost 3 vext2 <0,6,2,7>, <0,6,2,7>
    3136336040U, // <2,7,0,7>: Cost 3 vtrnr <u,2,3,0>, <5,7,5,7>
    1653027897U, // <2,7,0,u>: Cost 2 vext3 <7,0,u,2>, <7,0,u,2>
    2639348470U, // <2,7,1,0>: Cost 3 vext2 <3,6,2,7>, <1,0,3,2>
    3206619136U, // <2,7,1,1>: Cost 3 ins <u,7,1,1>, lane 0
    3206627328U, // <2,7,1,2>: Cost 3 ins <u,7,1,2>, lane 0
    2132893696U, // <2,7,1,3>: Cost 2 ins <u,7,1,3>, lane 0
    2599767350U, // <2,7,1,4>: Cost 3 vext1 <u,2,7,1>, RHS
    3206651904U, // <2,7,1,5>: Cost 3 ins <u,7,1,5>, lane 0
    3171344386U, // <2,7,1,6>: Cost 3 ins <2,7,u,6>, lane 2
    2599769082U, // <2,7,1,7>: Cost 3 vext1 <u,2,7,1>, <7,0,1,2>
    2132893696U, // <2,7,1,u>: Cost 2 ins <u,7,1,3>, lane 0
    2581856358U, // <2,7,2,0>: Cost 3 vext1 <5,2,7,2>, LHS
    3136131918U, // <2,7,2,1>: Cost 3 vtrnr <u,2,0,2>, <6,7,0,1>
    2097790977U, // <2,7,2,2>: Cost 2 ins <2,u,2,2>, lane 1
    2132967424U, // <2,7,2,3>: Cost 2 ins <u,7,2,3>, lane 0
    2581859638U, // <2,7,2,4>: Cost 3 vext1 <5,2,7,2>, RHS
    2632714080U, // <2,7,2,5>: Cost 3 vext2 <2,5,2,7>, <2,5,2,7>
    2633377713U, // <2,7,2,6>: Cost 3 vext2 <2,6,2,7>, <2,6,2,7>
    1770548291U, // <2,7,2,7>: Cost 2 vuzpr <4,2,6,7>, <4,2,6,7>
    2097790977U, // <2,7,2,u>: Cost 2 ins <2,u,2,2>, lane 1
    1514094694U, // <2,7,3,0>: Cost 2 vext1 <6,2,7,3>, LHS
    2569921680U, // <2,7,3,1>: Cost 3 vext1 <3,2,7,3>, <1,5,3,7>
    2587838056U, // <2,7,3,2>: Cost 3 vext1 <6,2,7,3>, <2,2,2,2>
    1927663312U, // <2,7,3,3>: Cost 2 vzipr LHS, <5,1,7,3>
    1514097974U, // <2,7,3,4>: Cost 2 vext1 <6,2,7,3>, RHS
    2581868321U, // <2,7,3,5>: Cost 3 vext1 <5,2,7,3>, <5,2,7,3>
    1514099194U, // <2,7,3,6>: Cost 2 vext1 <6,2,7,3>, <6,2,7,3>
    1927663640U, // <2,7,3,7>: Cost 2 vzipr LHS, <5,5,7,7>
    1514100526U, // <2,7,3,u>: Cost 2 vext1 <6,2,7,3>, LHS
    2581872742U, // <2,7,4,0>: Cost 3 vext1 <5,2,7,4>, LHS
    2581873562U, // <2,7,4,1>: Cost 3 vext1 <5,2,7,4>, <1,2,3,4>
    3171680257U, // <2,7,4,2>: Cost 3 ins <2,u,4,2>, lane 1
    2257982640U, // <2,7,4,3>: Cost 3 vrev <7,2,3,4>
    2581876022U, // <2,7,4,4>: Cost 3 vext1 <5,2,7,4>, RHS
    2133131264U, // <2,7,4,5>: Cost 2 ins <u,7,4,5>, lane 0
    2712245609U, // <2,7,4,6>: Cost 3 vext3 <4,6,0,2>, <7,4,6,0>
    3136368808U, // <2,7,4,7>: Cost 3 vtrnr <u,2,3,4>, <5,7,5,7>
    2133131264U, // <2,7,4,u>: Cost 2 ins <u,7,4,5>, lane 0
    2729497990U, // <2,7,5,0>: Cost 3 vext3 <7,5,0,2>, <7,5,0,2>
    3206914048U, // <2,7,5,1>: Cost 3 ins <u,7,5,1>, lane 0
    2844290353U, // <2,7,5,2>: Cost 3 vuzpr <4,2,6,7>, <4,5,6,2>
    2991469050U, // <2,7,5,3>: Cost 3 vzipr <6,4,2,5>, <6,2,7,3>
    2599800118U, // <2,7,5,4>: Cost 3 vext1 <u,2,7,5>, RHS
    3206946816U, // <2,7,5,5>: Cost 3 ins <u,7,5,5>, lane 0
    3206955008U, // <2,7,5,6>: Cost 3 ins <u,7,5,6>, lane 0
    2133221376U, // <2,7,5,7>: Cost 2 ins <u,7,5,7>, lane 0
    2133221376U, // <2,7,5,u>: Cost 2 ins <u,7,5,7>, lane 0
    2581889126U, // <2,7,6,0>: Cost 3 vext1 <5,2,7,6>, LHS
    3136459598U, // <2,7,6,1>: Cost 3 vtrnr <u,2,4,6>, <6,7,0,1>
    2901890250U, // <2,7,6,2>: Cost 3 vzipl <2,6,3,7>, <7,2,6,3>
    3136458880U, // <2,7,6,3>: Cost 3 vtrnr <u,2,4,6>, <5,7,1,3>
    2581892406U, // <2,7,6,4>: Cost 3 vext1 <5,2,7,6>, RHS
    2581892900U, // <2,7,6,5>: Cost 3 vext1 <5,2,7,6>, <5,2,7,6>
    2587865597U, // <2,7,6,6>: Cost 3 vext1 <6,2,7,6>, <6,2,7,6>
    2133295104U, // <2,7,6,7>: Cost 2 ins <u,7,6,7>, lane 0
    2133295104U, // <2,7,6,u>: Cost 2 ins <u,7,6,7>, lane 0
    2726254119U, // <2,7,7,0>: Cost 3 vext3 <7,0,1,2>, <7,7,0,1>
    3207061504U, // <2,7,7,1>: Cost 3 ins <u,7,7,1>, lane 0
    2563983002U, // <2,7,7,2>: Cost 3 vext1 <2,2,7,7>, <2,2,7,7>
    2998784506U, // <2,7,7,3>: Cost 3 vzipr <7,6,2,7>, <6,2,7,3>
    2599816502U, // <2,7,7,4>: Cost 3 vext1 <u,2,7,7>, RHS
    3207094272U, // <2,7,7,5>: Cost 3 ins <u,7,7,5>, lane 0
    2663241198U, // <2,7,7,6>: Cost 3 vext2 <7,6,2,7>, <7,6,2,7>
    2133368832U, // <2,7,7,7>: Cost 2 ins <u,7,7,7>, lane 0
    2133368832U, // <2,7,7,u>: Cost 2 ins <u,7,7,7>, lane 0
    1514135654U, // <2,7,u,0>: Cost 2 vext1 <6,2,7,u>, LHS
    1657820802U, // <2,7,u,1>: Cost 2 vext3 <7,u,1,2>, <7,u,1,2>
    2097790977U, // <2,7,u,2>: Cost 2 ins <2,u,2,2>, lane 1
    1927704272U, // <2,7,u,3>: Cost 2 vzipr LHS, <5,1,7,3>
    1514138934U, // <2,7,u,4>: Cost 2 vext1 <6,2,7,u>, RHS
    2133131264U, // <2,7,u,5>: Cost 2 ins <u,7,4,5>, lane 0
    1514140159U, // <2,7,u,6>: Cost 2 vext1 <6,2,7,u>, <6,2,7,u>
    1927704600U, // <2,7,u,7>: Cost 2 vzipr LHS, <5,5,7,7>
    1514141486U, // <2,7,u,u>: Cost 2 vext1 <6,2,7,u>, LHS
    1544380416U, // <2,u,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
    470638699U,  // <2,u,0,1>: Cost 1 vext2 LHS, LHS
    1544380580U, // <2,u,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
    2020786845U, // <2,u,0,3>: Cost 2 vtrnr <1,2,3,0>, LHS
    1544380754U, // <2,u,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
    2094940162U, // <2,u,0,5>: Cost 2 ins <2,3,u,5>, lane 2
    1960106138U, // <2,u,0,6>: Cost 2 vtrnl <2,3,0,1>, RHS
    2020789801U, // <2,u,0,7>: Cost 2 vtrnr <1,2,3,0>, RHS
    470639261U,  // <2,u,0,u>: Cost 1 vext2 LHS, LHS
    1544381174U, // <2,u,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
    1544381236U, // <2,u,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
    1544381334U, // <2,u,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
    1544381400U, // <2,u,1,3>: Cost 2 vext2 LHS, <1,3,1,3>
    2618123325U, // <2,u,1,4>: Cost 3 vext2 LHS, <1,4,3,5>
    1544381584U, // <2,u,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
    2618123489U, // <2,u,1,6>: Cost 3 vext2 LHS, <1,6,3,7>
    2096947202U, // <2,u,1,7>: Cost 2 ins <2,6,u,7>, lane 2
    1544381823U, // <2,u,1,u>: Cost 2 vext2 LHS, <1,u,3,3>
    1478328556U, // <2,u,2,0>: Cost 2 vext1 <0,2,u,2>, <0,2,u,2>
    1825380142U, // <2,u,2,1>: Cost 2 vzipl <2,2,2,2>, LHS
    269271142U,  // <2,u,2,2>: Cost 1 vdup2 LHS
    1055244288U, // <2,u,2,3>: Cost 1 ins LHS, lane 0
    1478331702U, // <2,u,2,4>: Cost 2 vext1 <0,2,u,2>, RHS
    1825380506U, // <2,u,2,5>: Cost 2 vzipl <2,2,2,2>, RHS
    1544382394U, // <2,u,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
    2014613033U, // <2,u,2,7>: Cost 2 vtrnr <0,2,0,2>, RHS
    1055244288U, // <2,u,2,u>: Cost 1 ins LHS, lane 0
    1544382614U, // <2,u,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
    1879885550U, // <2,u,3,1>: Cost 2 vzipr LHS, <2,3,u,1>
    1879884012U, // <2,u,3,2>: Cost 2 vzipr LHS, <0,2,u,2>
    806142108U,  // <2,u,3,3>: Cost 1 vzipr LHS, LHS
    1544382978U, // <2,u,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
    1879885554U, // <2,u,3,5>: Cost 2 vzipr LHS, <2,3,u,5>
    1879884016U, // <2,u,3,6>: Cost 2 vzipr LHS, <0,2,u,6>
    806145352U,  // <2,u,3,7>: Cost 1 vzipr LHS, RHS
    806142113U,  // <2,u,3,u>: Cost 1 vzipr LHS, LHS
    1484316774U, // <2,u,4,0>: Cost 2 vext1 <1,2,u,4>, LHS
    1484317639U, // <2,u,4,1>: Cost 2 vext1 <1,2,u,4>, <1,2,u,4>
    1960433454U, // <2,u,4,2>: Cost 2 vtrnl <2,3,4,5>, LHS
    2020819613U, // <2,u,4,3>: Cost 2 vtrnr <1,2,3,4>, LHS
    1484320054U, // <2,u,4,4>: Cost 2 vext1 <1,2,u,4>, RHS
    470641974U,  // <2,u,4,5>: Cost 1 vext2 LHS, RHS
    1691610422U, // <2,u,4,6>: Cost 2 vuzpl <2,2,u,3>, RHS
    2020822569U, // <2,u,4,7>: Cost 2 vtrnr <1,2,3,4>, RHS
    470642217U,  // <2,u,4,u>: Cost 1 vext2 LHS, RHS
    2552094959U, // <2,u,5,0>: Cost 3 vext1 <0,2,u,5>, <0,2,u,5>
    1592159952U, // <2,u,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
    2094252034U, // <2,u,5,2>: Cost 2 ins <2,2,u,2>, lane 2
    2094260226U, // <2,u,5,3>: Cost 2 ins <2,2,u,3>, lane 2
    1592160198U, // <2,u,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
    1592160260U, // <2,u,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
    1611962522U, // <2,u,5,6>: Cost 2 vext3 <0,2,0,2>, RHS
    1746226486U, // <2,u,5,7>: Cost 2 vuzpr <0,2,0,u>, RHS
    1611962540U, // <2,u,5,u>: Cost 2 vext3 <0,2,0,2>, RHS
    1478361328U, // <2,u,6,0>: Cost 2 vext1 <0,2,u,6>, <0,2,u,6>
    1828149038U, // <2,u,6,1>: Cost 2 vzipl <2,6,3,7>, LHS
    1592160762U, // <2,u,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
    2014937757U, // <2,u,6,3>: Cost 2 vtrnr <0,2,4,6>, LHS
    1478364470U, // <2,u,6,4>: Cost 2 vext1 <0,2,u,6>, RHS
    1828149402U, // <2,u,6,5>: Cost 2 vzipl <2,6,3,7>, RHS
    1592161080U, // <2,u,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
    1060216836U, // <2,u,6,7>: Cost 1 ins RHS, lane 4
    1060216836U, // <2,u,6,u>: Cost 1 ins RHS, lane 4
    1592161274U, // <2,u,7,0>: Cost 2 vext2 LHS, <7,0,1,2>
    2094907394U, // <2,u,7,1>: Cost 2 ins <2,3,u,1>, lane 2
    2094252034U, // <2,u,7,2>: Cost 2 ins <2,2,u,2>, lane 2
    2129354752U, // <2,u,7,3>: Cost 2 ins <u,1,7,3>, lane 0
    1592161638U, // <2,u,7,4>: Cost 2 vext2 LHS, <7,4,5,6>
    2094940162U, // <2,u,7,5>: Cost 2 ins <2,3,u,5>, lane 2
    2134024196U, // <2,u,7,6>: Cost 2 ins <u,u,7,6>, lane 4
    1592161900U, // <2,u,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
    1592161922U, // <2,u,7,u>: Cost 2 vext2 LHS, <7,u,1,2>
    1879925699U, // <2,u,u,0>: Cost 2 vzipr LHS, <1,2,u,0>
    470644526U,  // <2,u,u,1>: Cost 1 vext2 LHS, LHS
    269271142U,  // <2,u,u,2>: Cost 1 vdup2 LHS
    806183068U,  // <2,u,u,3>: Cost 1 vzipr LHS, LHS
    1879925703U, // <2,u,u,4>: Cost 2 vzipr LHS, <1,2,u,4>
    470644890U,  // <2,u,u,5>: Cost 1 vext2 LHS, RHS
    1879924976U, // <2,u,u,6>: Cost 2 vzipr LHS, <0,2,u,6>
    806186312U,  // <2,u,u,7>: Cost 1 vzipr LHS, RHS
    470645093U,  // <2,u,u,u>: Cost 1 vext2 LHS, LHS
    1611448320U, // <3,0,0,0>: Cost 2 vext3 LHS, <0,0,0,0>
    1611890698U, // <3,0,0,1>: Cost 2 vext3 LHS, <0,0,1,1>
    1611890708U, // <3,0,0,2>: Cost 2 vext3 LHS, <0,0,2,2>
    2960312624U, // <3,0,0,3>: Cost 3 vzipr <1,2,3,0>, <3,2,0,3>
    2689835045U, // <3,0,0,4>: Cost 3 vext3 LHS, <0,0,4,1>
    3177381889U, // <3,0,0,5>: Cost 3 ins <3,u,0,5>, lane 1
    3177390081U, // <3,0,0,6>: Cost 3 ins <3,u,0,6>, lane 1
    3177398273U, // <3,0,0,7>: Cost 3 ins <3,u,0,7>, lane 1
    1616093258U, // <3,0,0,u>: Cost 2 vext3 LHS, <0,0,u,2>
    1490337894U, // <3,0,1,0>: Cost 2 vext1 <2,3,0,1>, LHS
    2128232448U, // <3,0,1,1>: Cost 2 ins <u,0,1,1>, lane 0
    537706598U,  // <3,0,1,2>: Cost 1 vext3 LHS, LHS
    2098429955U, // <3,0,1,3>: Cost 2 ins <3,0,1,u>, lane 3
    1490341174U, // <3,0,1,4>: Cost 2 vext1 <2,3,0,1>, RHS
    2098429955U, // <3,0,1,5>: Cost 2 ins <3,0,1,u>, lane 3
    2098429955U, // <3,0,1,6>: Cost 2 ins <3,0,1,u>, lane 3
    2098429955U, // <3,0,1,7>: Cost 2 ins <3,0,1,u>, lane 3
    537706652U,  // <3,0,1,u>: Cost 1 vext3 LHS, LHS
    1611890852U, // <3,0,2,0>: Cost 2 vext3 LHS, <0,2,0,2>
    2685632684U, // <3,0,2,1>: Cost 3 vext3 LHS, <0,2,1,1>
    2128314368U, // <3,0,2,2>: Cost 2 ins <u,0,2,2>, lane 0
    2098946053U, // <3,0,2,3>: Cost 2 ins <3,0,u,u>, lane 5
    1611890892U, // <3,0,2,4>: Cost 2 vext3 LHS, <0,2,4,6>
    2959000610U, // <3,0,2,5>: Cost 3 vzipr <1,0,3,2>, <1,4,0,5>
    2624767930U, // <3,0,2,6>: Cost 3 vext2 <1,2,3,0>, <2,6,3,7>
    3177545729U, // <3,0,2,7>: Cost 3 ins <3,u,2,7>, lane 1
    1611890924U, // <3,0,2,u>: Cost 2 vext3 LHS, <0,2,u,2>
    2820636924U, // <3,0,3,0>: Cost 3 vuzpr <0,3,1,0>, <0,3,1,0>
    1832091750U, // <3,0,3,1>: Cost 2 vzipl <3,3,3,3>, LHS
    1966309478U, // <3,0,3,2>: Cost 2 vtrnl <3,3,3,3>, LHS
    2103844865U, // <3,0,3,3>: Cost 2 ins <3,u,3,3>, lane 1
    2624768514U, // <3,0,3,4>: Cost 3 vext2 <1,2,3,0>, <3,4,5,6>
    2772716034U, // <3,0,3,5>: Cost 3 vuzpl <3,5,0,2>, <3,4,5,6>
    3177611265U, // <3,0,3,6>: Cost 3 ins <3,u,3,6>, lane 1
    3177619457U, // <3,0,3,7>: Cost 3 ins <3,u,3,7>, lane 1
    1832092317U, // <3,0,3,u>: Cost 2 vzipl <3,3,3,3>, LHS
    2689835334U, // <3,0,4,0>: Cost 3 vext3 LHS, <0,4,0,2>
    1611891026U, // <3,0,4,1>: Cost 2 vext3 LHS, <0,4,1,5>
    1611891036U, // <3,0,4,2>: Cost 2 vext3 LHS, <0,4,2,6>
    2906669312U, // <3,0,4,3>: Cost 3 vzipl <3,4,5,6>, <0,3,1,4>
    2689835373U, // <3,0,4,4>: Cost 3 vext3 LHS, <0,4,4,5>
    1551027510U, // <3,0,4,5>: Cost 2 vext2 <1,2,3,0>, RHS
    2769382710U, // <3,0,4,6>: Cost 3 vuzpl <3,0,0,0>, RHS
    3177693185U, // <3,0,4,7>: Cost 3 ins <3,u,4,7>, lane 1
    1616093586U, // <3,0,4,u>: Cost 2 vext3 LHS, <0,4,u,6>
    3101278208U, // <3,0,5,0>: Cost 3 vtrnr <2,3,4,5>, <0,0,0,0>
    2128527360U, // <3,0,5,1>: Cost 2 ins <u,0,5,1>, lane 0
    1967145062U, // <3,0,5,2>: Cost 2 vtrnl <3,4,5,6>, LHS
    3040886978U, // <3,0,5,3>: Cost 3 vtrnl <3,4,5,6>, <0,2,3,5>
    3040886988U, // <3,0,5,4>: Cost 3 vtrnl <3,4,5,6>, <0,2,4,6>
    2666573828U, // <3,0,5,5>: Cost 3 vext2 <u,2,3,0>, <5,5,5,5>
    2104016897U, // <3,0,5,6>: Cost 2 ins <3,u,5,6>, lane 1
    2820640054U, // <3,0,5,7>: Cost 3 vuzpr <0,3,1,0>, RHS
    1967145116U, // <3,0,5,u>: Cost 2 vtrnl <3,4,5,6>, LHS
    3202334720U, // <3,0,6,0>: Cost 3 ins <u,0,6,0>, lane 0
    2907635814U, // <3,0,6,1>: Cost 3 vzipl <3,6,0,7>, LHS
    2128609280U, // <3,0,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    3177807873U, // <3,0,6,3>: Cost 3 ins <3,u,6,3>, lane 1
    3202367488U, // <3,0,6,4>: Cost 3 ins <u,0,6,4>, lane 0
    3172663298U, // <3,0,6,5>: Cost 3 ins <3,0,u,5>, lane 2
    2666574648U, // <3,0,6,6>: Cost 3 vext2 <u,2,3,0>, <6,6,6,6>
    2098946053U, // <3,0,6,7>: Cost 2 ins <3,0,u,u>, lane 5
    2128609280U, // <3,0,6,u>: Cost 2 ins <u,0,6,2>, lane 0
    3095396352U, // <3,0,7,0>: Cost 3 vtrnr <1,3,5,7>, <0,0,0,0>
    3095396362U, // <3,0,7,1>: Cost 3 vtrnr <1,3,5,7>, <0,0,1,1>
    2098896898U, // <3,0,7,2>: Cost 2 ins <3,0,u,2>, lane 2
    3177881601U, // <3,0,7,3>: Cost 3 ins <3,u,7,3>, lane 1
    2666575206U, // <3,0,7,4>: Cost 3 vext2 <u,2,3,0>, <7,4,5,6>
    3177897985U, // <3,0,7,5>: Cost 3 ins <3,u,7,5>, lane 1
    3202457600U, // <3,0,7,6>: Cost 3 ins <u,0,7,6>, lane 0
    2666575468U, // <3,0,7,7>: Cost 3 vext2 <u,2,3,0>, <7,7,7,7>
    2098896898U, // <3,0,7,u>: Cost 2 ins <3,0,u,2>, lane 2
    1616093834U, // <3,0,u,0>: Cost 2 vext3 LHS, <0,u,0,2>
    1611891346U, // <3,0,u,1>: Cost 2 vext3 LHS, <0,u,1,1>
    537707165U,  // <3,0,u,2>: Cost 1 vext3 LHS, LHS
    2098429955U, // <3,0,u,3>: Cost 2 ins <3,0,1,u>, lane 3
    1616093874U, // <3,0,u,4>: Cost 2 vext3 LHS, <0,u,4,6>
    1551030426U, // <3,0,u,5>: Cost 2 vext2 <1,2,3,0>, RHS
    2098429955U, // <3,0,u,6>: Cost 2 ins <3,0,1,u>, lane 3
    2098429955U, // <3,0,u,7>: Cost 2 ins <3,0,1,u>, lane 3
    537707219U,  // <3,0,u,u>: Cost 1 vext3 LHS, LHS
    2552201468U, // <3,1,0,0>: Cost 3 vext1 <0,3,1,0>, <0,3,1,0>
    2128822272U, // <3,1,0,1>: Cost 2 ins <u,1,0,1>, lane 0
    1695727718U, // <3,1,0,2>: Cost 2 vuzpl <3,0,1,2>, LHS
    1611449078U, // <3,1,0,3>: Cost 2 vext3 LHS, <1,0,3,2>
    2552204598U, // <3,1,0,4>: Cost 3 vext1 <0,3,1,0>, RHS
    2960310610U, // <3,1,0,5>: Cost 3 vzipr <1,2,3,0>, <0,4,1,5>
    2832516572U, // <3,1,0,6>: Cost 3 vuzpr <2,3,0,1>, <2,0,4,6>
    3177398273U, // <3,1,0,7>: Cost 3 ins <3,u,0,7>, lane 1
    1611891491U, // <3,1,0,u>: Cost 2 vext3 LHS, <1,0,u,2>
    2689835819U, // <3,1,1,0>: Cost 3 vext3 LHS, <1,1,0,1>
    1611449140U, // <3,1,1,1>: Cost 2 vext3 LHS, <1,1,1,1>
    2103689217U, // <3,1,1,2>: Cost 2 ins <3,u,1,2>, lane 1
    1611891528U, // <3,1,1,3>: Cost 2 vext3 LHS, <1,1,3,3>
    2689835859U, // <3,1,1,4>: Cost 3 vext3 LHS, <1,1,4,5>
    2689835868U, // <3,1,1,5>: Cost 3 vext3 LHS, <1,1,5,5>
    3177463809U, // <3,1,1,6>: Cost 3 ins <3,u,1,6>, lane 1
    3100952848U, // <3,1,1,7>: Cost 3 vtrnr <2,3,0,1>, <3,1,5,7>
    1611891573U, // <3,1,1,u>: Cost 2 vext3 LHS, <1,1,u,3>
    2128961536U, // <3,1,2,0>: Cost 2 ins <u,1,2,0>, lane 0
    2128969728U, // <3,1,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    2128977920U, // <3,1,2,2>: Cost 2 ins <u,1,2,2>, lane 0
    1055244288U, // <3,1,2,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <3,1,2,4>: Cost 2 ins <u,1,2,4>, lane 0
    2129002496U, // <3,1,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2129010688U, // <3,1,2,6>: Cost 2 ins <u,1,2,6>, lane 0
    2129018880U, // <3,1,2,7>: Cost 2 ins <u,1,2,7>, lane 0
    1055244288U, // <3,1,2,u>: Cost 1 ins LHS, lane 0
    1484456038U, // <3,1,3,0>: Cost 2 vext1 <1,3,1,3>, LHS
    1611891672U, // <3,1,3,1>: Cost 2 vext3 LHS, <1,3,1,3>
    2685633502U, // <3,1,3,2>: Cost 3 vext3 LHS, <1,3,2,0>
    2021326950U, // <3,1,3,3>: Cost 2 vtrnr <1,3,1,3>, LHS
    1484459318U, // <3,1,3,4>: Cost 2 vext1 <1,3,1,3>, RHS
    1611891712U, // <3,1,3,5>: Cost 2 vext3 LHS, <1,3,5,7>
    2689836041U, // <3,1,3,6>: Cost 3 vext3 LHS, <1,3,6,7>
    2832516096U, // <3,1,3,7>: Cost 3 vuzpr <2,3,0,1>, <1,3,5,7>
    1611891735U, // <3,1,3,u>: Cost 2 vext3 LHS, <1,3,u,3>
    2552234240U, // <3,1,4,0>: Cost 3 vext1 <0,3,1,4>, <0,3,1,4>
    2960343050U, // <3,1,4,1>: Cost 3 vzipr <1,2,3,4>, <0,0,1,1>
    2960345238U, // <3,1,4,2>: Cost 3 vzipr <1,2,3,4>, <3,0,1,2>
    2129133568U, // <3,1,4,3>: Cost 2 ins <u,1,4,3>, lane 0
    2552237366U, // <3,1,4,4>: Cost 3 vext1 <0,3,1,4>, RHS
    2129149952U, // <3,1,4,5>: Cost 2 ins <u,1,4,5>, lane 0
    1695730998U, // <3,1,4,6>: Cost 2 vuzpl <3,0,1,2>, RHS
    3177693185U, // <3,1,4,7>: Cost 3 ins <3,u,4,7>, lane 1
    1695731016U, // <3,1,4,u>: Cost 2 vuzpl <3,0,1,2>, RHS
    2689836143U, // <3,1,5,0>: Cost 3 vext3 LHS, <1,5,0,1>
    2564187280U, // <3,1,5,1>: Cost 3 vext1 <2,3,1,5>, <1,5,3,7>
    2564187827U, // <3,1,5,2>: Cost 3 vext1 <2,3,1,5>, <2,3,1,5>
    1611891856U, // <3,1,5,3>: Cost 2 vext3 LHS, <1,5,3,7>
    2689836183U, // <3,1,5,4>: Cost 3 vext3 LHS, <1,5,4,5>
    2961678674U, // <3,1,5,5>: Cost 3 vzipr <1,4,3,5>, <0,4,1,5>
    2104016897U, // <3,1,5,6>: Cost 2 ins <3,u,5,6>, lane 1
    1758776630U, // <3,1,5,7>: Cost 2 vuzpr <2,3,0,1>, RHS
    1611891901U, // <3,1,5,u>: Cost 2 vext3 LHS, <1,5,u,7>
    2907783926U, // <3,1,6,0>: Cost 3 vzipl <3,6,2,7>, <1,0,3,2>
    2689836239U, // <3,1,6,1>: Cost 3 vext3 LHS, <1,6,1,7>
    2222752740U, // <3,1,6,2>: Cost 3 vrev <1,3,2,6>
    2129281024U, // <3,1,6,3>: Cost 2 ins <u,1,6,3>, lane 0
    2222900214U, // <3,1,6,4>: Cost 3 vrev <1,3,4,6>
    2689836275U, // <3,1,6,5>: Cost 3 vext3 LHS, <1,6,5,7>
    2868350324U, // <3,1,6,6>: Cost 3 vuzpr <u,3,0,1>, <4,6,4,6>
    2129313792U, // <3,1,6,7>: Cost 2 ins <u,1,6,7>, lane 0
    2129281024U, // <3,1,6,u>: Cost 2 ins <u,1,6,3>, lane 0
    3177857025U, // <3,1,7,0>: Cost 3 ins <3,u,7,0>, lane 1
    3095397172U, // <3,1,7,1>: Cost 3 vtrnr <1,3,5,7>, <1,1,1,1>
    2962360470U, // <3,1,7,2>: Cost 3 vzipr <1,5,3,7>, <3,0,1,2>
    2021654630U, // <3,1,7,3>: Cost 2 vtrnr <1,3,5,7>, LHS
    3177889793U, // <3,1,7,4>: Cost 3 ins <3,u,7,4>, lane 1
    1149240320U, // <3,1,7,5>: Cost 2 vrev <1,3,5,7>
    2223055881U, // <3,1,7,6>: Cost 3 vrev <1,3,6,7>
    2868351144U, // <3,1,7,7>: Cost 3 vuzpr <u,3,0,1>, <5,7,5,7>
    2021654635U, // <3,1,7,u>: Cost 2 vtrnr <1,3,5,7>, LHS
    1484496998U, // <3,1,u,0>: Cost 2 vext1 <1,3,1,u>, LHS
    1611892077U, // <3,1,u,1>: Cost 2 vext3 LHS, <1,u,1,3>
    1695733550U, // <3,1,u,2>: Cost 2 vuzpl <3,0,1,2>, LHS
    1055244288U, // <3,1,u,3>: Cost 1 ins LHS, lane 0
    1484500278U, // <3,1,u,4>: Cost 2 vext1 <1,3,1,u>, RHS
    1611892117U, // <3,1,u,5>: Cost 2 vext3 LHS, <1,u,5,7>
    1695733914U, // <3,1,u,6>: Cost 2 vuzpl <3,0,1,2>, RHS
    1758776873U, // <3,1,u,7>: Cost 2 vuzpr <2,3,0,1>, RHS
    1055244288U, // <3,1,u,u>: Cost 1 ins LHS, lane 0
    2623455232U, // <3,2,0,0>: Cost 3 vext2 <1,0,3,2>, <0,0,0,0>
    1549713510U, // <3,2,0,1>: Cost 2 vext2 <1,0,3,2>, LHS
    2129494016U, // <3,2,0,2>: Cost 2 ins <u,2,0,2>, lane 0
    1886568550U, // <3,2,0,3>: Cost 2 vzipr <1,2,3,0>, LHS
    2623455570U, // <3,2,0,4>: Cost 3 vext2 <1,0,3,2>, <0,4,1,5>
    2960311348U, // <3,2,0,5>: Cost 3 vzipr <1,2,3,0>, <1,4,2,5>
    2689836524U, // <3,2,0,6>: Cost 3 vext3 LHS, <2,0,6,4>
    3177398273U, // <3,2,0,7>: Cost 3 ins <3,u,0,7>, lane 1
    1549714077U, // <3,2,0,u>: Cost 2 vext2 <1,0,3,2>, LHS
    1549714166U, // <3,2,1,0>: Cost 2 vext2 <1,0,3,2>, <1,0,3,2>
    2623456052U, // <3,2,1,1>: Cost 3 vext2 <1,0,3,2>, <1,1,1,1>
    2103689217U, // <3,2,1,2>: Cost 2 ins <3,u,1,2>, lane 1
    2685634079U, // <3,2,1,3>: Cost 3 vext3 LHS, <2,1,3,1>
    2552286518U, // <3,2,1,4>: Cost 3 vext1 <0,3,2,1>, RHS
    2623456400U, // <3,2,1,5>: Cost 3 vext2 <1,0,3,2>, <1,5,3,7>
    2689836604U, // <3,2,1,6>: Cost 3 vext3 LHS, <2,1,6,3>
    3177472001U, // <3,2,1,7>: Cost 3 ins <3,u,1,7>, lane 1
    1155385070U, // <3,2,1,u>: Cost 2 vrev <2,3,u,1>
    2689836629U, // <3,2,2,0>: Cost 3 vext3 LHS, <2,2,0,1>
    2689836640U, // <3,2,2,1>: Cost 3 vext3 LHS, <2,2,1,3>
    1611449960U, // <3,2,2,2>: Cost 2 vext3 LHS, <2,2,2,2>
    1611892338U, // <3,2,2,3>: Cost 2 vext3 LHS, <2,2,3,3>
    2689836669U, // <3,2,2,4>: Cost 3 vext3 LHS, <2,2,4,5>
    2689836680U, // <3,2,2,5>: Cost 3 vext3 LHS, <2,2,5,7>
    2689836685U, // <3,2,2,6>: Cost 3 vext3 LHS, <2,2,6,3>
    3177545729U, // <3,2,2,7>: Cost 3 ins <3,u,2,7>, lane 1
    1611892383U, // <3,2,2,u>: Cost 2 vext3 LHS, <2,2,u,3>
    1611450022U, // <3,2,3,0>: Cost 2 vext3 LHS, <2,3,0,1>
    2685191854U, // <3,2,3,1>: Cost 3 vext3 LHS, <2,3,1,0>
    1611450042U, // <3,2,3,2>: Cost 2 vext3 LHS, <2,3,2,3>
    1885929574U, // <3,2,3,3>: Cost 2 vzipr <1,1,3,3>, LHS
    1611450062U, // <3,2,3,4>: Cost 2 vext3 LHS, <2,3,4,5>
    2732967635U, // <3,2,3,5>: Cost 3 vext3 LHS, <2,3,5,1>
    1611450082U, // <3,2,3,6>: Cost 2 vext3 LHS, <2,3,6,7>
    2732967652U, // <3,2,3,7>: Cost 3 vext3 LHS, <2,3,7,0>
    1611450094U, // <3,2,3,u>: Cost 2 vext3 LHS, <2,3,u,1>
    2558279782U, // <3,2,4,0>: Cost 3 vext1 <1,3,2,4>, LHS
    2558280674U, // <3,2,4,1>: Cost 3 vext1 <1,3,2,4>, <1,3,2,4>
    2960343060U, // <3,2,4,2>: Cost 3 vzipr <1,2,3,4>, <0,0,2,2>
    1886601318U, // <3,2,4,3>: Cost 2 vzipr <1,2,3,4>, LHS
    2960344034U, // <3,2,4,4>: Cost 3 vzipr <1,2,3,4>, <1,3,2,4>
    1549716790U, // <3,2,4,5>: Cost 2 vext2 <1,0,3,2>, RHS
    2129821696U, // <3,2,4,6>: Cost 2 ins <u,2,4,6>, lane 0
    3177693185U, // <3,2,4,7>: Cost 3 ins <3,u,4,7>, lane 1
    1549717033U, // <3,2,4,u>: Cost 2 vext2 <1,0,3,2>, RHS
    2552316170U, // <3,2,5,0>: Cost 3 vext1 <0,3,2,5>, <0,3,2,5>
    2228643507U, // <3,2,5,1>: Cost 3 vrev <2,3,1,5>
    2689836896U, // <3,2,5,2>: Cost 3 vext3 LHS, <2,5,2,7>
    2685634408U, // <3,2,5,3>: Cost 3 vext3 LHS, <2,5,3,6>
    1155122894U, // <3,2,5,4>: Cost 2 vrev <2,3,4,5>
    2665263108U, // <3,2,5,5>: Cost 3 vext2 <u,0,3,2>, <5,5,5,5>
    2104016897U, // <3,2,5,6>: Cost 2 ins <3,u,5,6>, lane 1
    2826554678U, // <3,2,5,7>: Cost 3 vuzpr <1,3,0,2>, RHS
    1155417842U, // <3,2,5,u>: Cost 2 vrev <2,3,u,5>
    2689836953U, // <3,2,6,0>: Cost 3 vext3 LHS, <2,6,0,1>
    2689836964U, // <3,2,6,1>: Cost 3 vext3 LHS, <2,6,1,3>
    2689836976U, // <3,2,6,2>: Cost 3 vext3 LHS, <2,6,2,6>
    1611892666U, // <3,2,6,3>: Cost 2 vext3 LHS, <2,6,3,7>
    2689836993U, // <3,2,6,4>: Cost 3 vext3 LHS, <2,6,4,5>
    2689837004U, // <3,2,6,5>: Cost 3 vext3 LHS, <2,6,5,7>
    2689837013U, // <3,2,6,6>: Cost 3 vext3 LHS, <2,6,6,7>
    2129977344U, // <3,2,6,7>: Cost 2 ins <u,2,6,7>, lane 0
    1611892711U, // <3,2,6,u>: Cost 2 vext3 LHS, <2,6,u,7>
    3095397270U, // <3,2,7,0>: Cost 3 vtrnr <1,3,5,7>, <1,2,3,0>
    3203743744U, // <3,2,7,1>: Cost 3 ins <u,2,7,1>, lane 0
    3095396516U, // <3,2,7,2>: Cost 3 vtrnr <1,3,5,7>, <0,2,0,2>
    1888616550U, // <3,2,7,3>: Cost 2 vzipr <1,5,3,7>, LHS
    3095397274U, // <3,2,7,4>: Cost 3 vtrnr <1,3,5,7>, <1,2,3,4>
    3095396528U, // <3,2,7,5>: Cost 3 vtrnr <1,3,5,7>, <0,2,1,5>
    1155286754U, // <3,2,7,6>: Cost 2 vrev <2,3,6,7>
    2665264748U, // <3,2,7,7>: Cost 3 vext2 <u,0,3,2>, <7,7,7,7>
    1888616555U, // <3,2,7,u>: Cost 2 vzipr <1,5,3,7>, LHS
    1611892795U, // <3,2,u,0>: Cost 2 vext3 LHS, <2,u,0,1>
    1549719342U, // <3,2,u,1>: Cost 2 vext2 <1,0,3,2>, LHS
    2129494016U, // <3,2,u,2>: Cost 2 ins <u,2,0,2>, lane 0
    1611892824U, // <3,2,u,3>: Cost 2 vext3 LHS, <2,u,3,3>
    1611892835U, // <3,2,u,4>: Cost 2 vext3 LHS, <2,u,4,5>
    1549719706U, // <3,2,u,5>: Cost 2 vext2 <1,0,3,2>, RHS
    2129821696U, // <3,2,u,6>: Cost 2 ins <u,2,4,6>, lane 0
    2129977344U, // <3,2,u,7>: Cost 2 ins <u,2,6,7>, lane 0
    1611892867U, // <3,2,u,u>: Cost 2 vext3 LHS, <2,u,u,1>
    1886569366U, // <3,3,0,0>: Cost 2 vzipr <1,2,3,0>, <1,2,3,0>
    1611450518U, // <3,3,0,1>: Cost 2 vext3 LHS, <3,0,1,2>
    1697874022U, // <3,3,0,2>: Cost 2 vuzpl <3,3,3,3>, LHS
    2100895746U, // <3,3,0,3>: Cost 2 ins <3,3,u,3>, lane 2
    2685634736U, // <3,3,0,4>: Cost 3 vext3 LHS, <3,0,4,1>
    3041151490U, // <3,3,0,5>: Cost 3 vtrnl <3,5,0,2>, <3,4,5,6>
    3177390081U, // <3,3,0,6>: Cost 3 ins <3,u,0,6>, lane 1
    2960311440U, // <3,3,0,7>: Cost 3 vzipr <1,2,3,0>, <1,5,3,7>
    1611450581U, // <3,3,0,u>: Cost 2 vext3 LHS, <3,0,u,2>
    2685192415U, // <3,3,1,0>: Cost 3 vext3 LHS, <3,1,0,3>
    1550385992U, // <3,3,1,1>: Cost 2 vext2 <1,1,3,3>, <1,1,3,3>
    2103689217U, // <3,3,1,2>: Cost 2 ins <3,u,1,2>, lane 1
    1752891494U, // <3,3,1,3>: Cost 2 vuzpr <1,3,1,3>, LHS
    2826635515U, // <3,3,1,4>: Cost 3 vuzpr <1,3,1,3>, <3,1,3,4>
    2685634828U, // <3,3,1,5>: Cost 3 vext3 LHS, <3,1,5,3>
    3177463809U, // <3,3,1,6>: Cost 3 ins <3,u,1,6>, lane 1
    3100951552U, // <3,3,1,7>: Cost 3 vtrnr <2,3,0,1>, <1,3,5,7>
    1752891499U, // <3,3,1,u>: Cost 2 vuzpr <1,3,1,3>, LHS
    2959000470U, // <3,3,2,0>: Cost 3 vzipr <1,0,3,2>, <1,2,3,0>
    2959000471U, // <3,3,2,1>: Cost 3 vzipr <1,0,3,2>, <1,2,3,1>
    1885258486U, // <3,3,2,2>: Cost 2 vzipr <1,0,3,2>, <1,0,3,2>
    2130313216U, // <3,3,2,3>: Cost 2 ins <u,3,2,3>, lane 0
    2959000474U, // <3,3,2,4>: Cost 3 vzipr <1,0,3,2>, <1,2,3,4>
    2732968286U, // <3,3,2,5>: Cost 3 vext3 LHS, <3,2,5,4>
    2685634918U, // <3,3,2,6>: Cost 3 vext3 LHS, <3,2,6,3>
    2959000720U, // <3,3,2,7>: Cost 3 vzipr <1,0,3,2>, <1,5,3,7>
    1561004120U, // <3,3,2,u>: Cost 2 vext2 <2,u,3,3>, <2,u,3,3>
    1496547430U, // <3,3,3,0>: Cost 2 vext1 <3,3,3,3>, LHS
    2100568067U, // <3,3,3,1>: Cost 2 ins <3,3,3,u>, lane 3
    2100568067U, // <3,3,3,2>: Cost 2 ins <3,3,3,u>, lane 3
    336380006U,  // <3,3,3,3>: Cost 1 vdup3 LHS
    1496550710U, // <3,3,3,4>: Cost 2 vext1 <3,3,3,3>, RHS
    2100568067U, // <3,3,3,5>: Cost 2 ins <3,3,3,u>, lane 3
    2100568067U, // <3,3,3,6>: Cost 2 ins <3,3,3,u>, lane 3
    2100568067U, // <3,3,3,7>: Cost 2 ins <3,3,3,u>, lane 3
    336380006U,  // <3,3,3,u>: Cost 1 vdup3 LHS
    2960343958U, // <3,3,4,0>: Cost 3 vzipr <1,2,3,4>, <1,2,3,0>
    2558354411U, // <3,3,4,1>: Cost 3 vext1 <1,3,3,4>, <1,3,3,4>
    2960343798U, // <3,3,4,2>: Cost 3 vzipr <1,2,3,4>, <1,0,3,2>
    2100895746U, // <3,3,4,3>: Cost 2 ins <3,3,u,3>, lane 2
    1886602138U, // <3,3,4,4>: Cost 2 vzipr <1,2,3,4>, <1,2,3,4>
    1611893250U, // <3,3,4,5>: Cost 2 vext3 LHS, <3,4,5,6>
    1697877302U, // <3,3,4,6>: Cost 2 vuzpl <3,3,3,3>, RHS
    2960344208U, // <3,3,4,7>: Cost 3 vzipr <1,2,3,4>, <1,5,3,7>
    1611893277U, // <3,3,4,u>: Cost 2 vext3 LHS, <3,4,u,6>
    2558361702U, // <3,3,5,0>: Cost 3 vext1 <1,3,3,5>, LHS
    2558362604U, // <3,3,5,1>: Cost 3 vext1 <1,3,3,5>, <1,3,3,5>
    2558363342U, // <3,3,5,2>: Cost 3 vext1 <1,3,3,5>, <2,3,4,5>
    2100895746U, // <3,3,5,3>: Cost 2 ins <3,3,u,3>, lane 2
    2558364982U, // <3,3,5,4>: Cost 3 vext1 <1,3,3,5>, RHS
    2027538126U, // <3,3,5,5>: Cost 2 vtrnr <2,3,4,5>, <2,3,4,5>
    2104016897U, // <3,3,5,6>: Cost 2 ins <3,u,5,6>, lane 1
    1752894774U, // <3,3,5,7>: Cost 2 vuzpr <1,3,1,3>, RHS
    1752894775U, // <3,3,5,u>: Cost 2 vuzpr <1,3,1,3>, RHS
    2732968568U, // <3,3,6,0>: Cost 3 vext3 LHS, <3,6,0,7>
    3204333568U, // <3,3,6,1>: Cost 3 ins <u,3,6,1>, lane 0
    2732968586U, // <3,3,6,2>: Cost 3 vext3 LHS, <3,6,2,7>
    2100895746U, // <3,3,6,3>: Cost 2 ins <3,3,u,3>, lane 2
    2234845608U, // <3,3,6,4>: Cost 3 vrev <3,3,4,6>
    3204366336U, // <3,3,6,5>: Cost 3 ins <u,3,6,5>, lane 0
    1967893085U, // <3,3,6,6>: Cost 2 vtrnl <3,5,6,7>, <3,5,6,7>
    2130640896U, // <3,3,6,7>: Cost 2 ins <u,3,6,7>, lane 0
    2100895746U, // <3,3,6,u>: Cost 2 ins <3,3,u,3>, lane 2
    2558378086U, // <3,3,7,0>: Cost 3 vext1 <1,3,3,7>, LHS
    2558378990U, // <3,3,7,1>: Cost 3 vext1 <1,3,3,7>, <1,3,3,7>
    2962359030U, // <3,3,7,2>: Cost 3 vzipr <1,5,3,7>, <1,0,3,2>
    2100895746U, // <3,3,7,3>: Cost 2 ins <3,3,u,3>, lane 2
    2558381366U, // <3,3,7,4>: Cost 3 vext1 <1,3,3,7>, RHS
    3095398094U, // <3,3,7,5>: Cost 3 vtrnr <1,3,5,7>, <2,3,4,5>
    3174662146U, // <3,3,7,6>: Cost 3 ins <3,3,u,6>, lane 2
    2021655552U, // <3,3,7,7>: Cost 2 vtrnr <1,3,5,7>, <1,3,5,7>
    2021655552U, // <3,3,7,u>: Cost 2 vtrnr <1,3,5,7>, <1,3,5,7>
    1886569366U, // <3,3,u,0>: Cost 2 vzipr <1,2,3,0>, <1,2,3,0>
    1611893534U, // <3,3,u,1>: Cost 2 vext3 LHS, <3,u,1,2>
    1697879854U, // <3,3,u,2>: Cost 2 vuzpl <3,3,3,3>, LHS
    336380006U,  // <3,3,u,3>: Cost 1 vdup3 LHS
    1496550710U, // <3,3,u,4>: Cost 2 vext1 <3,3,3,3>, RHS
    1611893574U, // <3,3,u,5>: Cost 2 vext3 LHS, <3,u,5,6>
    1697880218U, // <3,3,u,6>: Cost 2 vuzpl <3,3,3,3>, RHS
    1752895017U, // <3,3,u,7>: Cost 2 vuzpr <1,3,1,3>, RHS
    336380006U,  // <3,3,u,u>: Cost 1 vdup3 LHS
    2624798720U, // <3,4,0,0>: Cost 3 vext2 <1,2,3,4>, <0,0,0,0>
    1551056998U, // <3,4,0,1>: Cost 2 vext2 <1,2,3,4>, LHS
    2624798884U, // <3,4,0,2>: Cost 3 vext2 <1,2,3,4>, <0,2,0,2>
    3177365505U, // <3,4,0,3>: Cost 3 ins <3,u,0,3>, lane 1
    2624799058U, // <3,4,0,4>: Cost 3 vext2 <1,2,3,4>, <0,4,1,5>
    1829948726U, // <3,4,0,5>: Cost 2 vzipl <3,0,1,2>, RHS
    1659227036U, // <3,4,0,6>: Cost 2 vext3 LHS, <4,0,6,2>
    3177398273U, // <3,4,0,7>: Cost 3 ins <3,u,0,7>, lane 1
    1551057565U, // <3,4,0,u>: Cost 2 vext2 <1,2,3,4>, LHS
    2624799478U, // <3,4,1,0>: Cost 3 vext2 <1,2,3,4>, <1,0,3,2>
    2624799540U, // <3,4,1,1>: Cost 3 vext2 <1,2,3,4>, <1,1,1,1>
    1551057818U, // <3,4,1,2>: Cost 2 vext2 <1,2,3,4>, <1,2,3,4>
    2820669542U, // <3,4,1,3>: Cost 3 vuzpr <0,3,1,4>, LHS
    2564377910U, // <3,4,1,4>: Cost 3 vext1 <2,3,4,1>, RHS
    2130919424U, // <3,4,1,5>: Cost 2 ins <u,4,1,5>, lane 0
    1964166454U, // <3,4,1,6>: Cost 2 vtrnl <3,0,1,2>, RHS
    3177472001U, // <3,4,1,7>: Cost 3 ins <3,u,1,7>, lane 1
    1555039616U, // <3,4,1,u>: Cost 2 vext2 <1,u,3,4>, <1,u,3,4>
    3204694016U, // <3,4,2,0>: Cost 3 ins <u,4,2,0>, lane 0
    2624800298U, // <3,4,2,1>: Cost 3 vext2 <1,2,3,4>, <2,1,4,3>
    2624800360U, // <3,4,2,2>: Cost 3 vext2 <1,2,3,4>, <2,2,2,2>
    2101600261U, // <3,4,2,3>: Cost 2 ins <3,4,u,u>, lane 5
    2826716058U, // <3,4,2,4>: Cost 3 vuzpr <1,3,2,4>, <1,2,3,4>
    2959001294U, // <3,4,2,5>: Cost 3 vzipr <1,0,3,2>, <2,3,4,5>
    2131001344U, // <3,4,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    3177545729U, // <3,4,2,7>: Cost 3 ins <3,u,2,7>, lane 1
    2101600261U, // <3,4,2,u>: Cost 2 ins <3,4,u,u>, lane 5
    2624800918U, // <3,4,3,0>: Cost 3 vext2 <1,2,3,4>, <3,0,1,2>
    2636081403U, // <3,4,3,1>: Cost 3 vext2 <3,1,3,4>, <3,1,3,4>
    2636745036U, // <3,4,3,2>: Cost 3 vext2 <3,2,3,4>, <3,2,3,4>
    2103844865U, // <3,4,3,3>: Cost 2 ins <3,u,3,3>, lane 1
    2820669696U, // <3,4,3,4>: Cost 3 vuzpr <0,3,1,4>, <0,3,1,4>
    1832095030U, // <3,4,3,5>: Cost 2 vzipl <3,3,3,3>, RHS
    1966312758U, // <3,4,3,6>: Cost 2 vtrnl <3,3,3,3>, RHS
    3177619457U, // <3,4,3,7>: Cost 3 ins <3,u,3,7>, lane 1
    1832095273U, // <3,4,3,u>: Cost 2 vzipl <3,3,3,3>, RHS
    2960344777U, // <3,4,4,0>: Cost 3 vzipr <1,2,3,4>, <2,3,4,0>
    2960344778U, // <3,4,4,1>: Cost 3 vzipr <1,2,3,4>, <2,3,4,1>
    2564400845U, // <3,4,4,2>: Cost 3 vext1 <2,3,4,4>, <2,3,4,4>
    2960344618U, // <3,4,4,3>: Cost 3 vzipr <1,2,3,4>, <2,1,4,3>
    1659227344U, // <3,4,4,4>: Cost 2 vext3 LHS, <4,4,4,4>
    1551060278U, // <3,4,4,5>: Cost 2 vext2 <1,2,3,4>, RHS
    1659227364U, // <3,4,4,6>: Cost 2 vext3 LHS, <4,4,6,6>
    3177693185U, // <3,4,4,7>: Cost 3 ins <3,u,4,7>, lane 1
    1551060521U, // <3,4,4,u>: Cost 2 vext2 <1,2,3,4>, RHS
    1490665574U, // <3,4,5,0>: Cost 2 vext1 <2,3,4,5>, LHS
    2101379075U, // <3,4,5,1>: Cost 2 ins <3,4,5,u>, lane 3
    1490667214U, // <3,4,5,2>: Cost 2 vext1 <2,3,4,5>, <2,3,4,5>
    2101379075U, // <3,4,5,3>: Cost 2 ins <3,4,5,u>, lane 3
    1490668854U, // <3,4,5,4>: Cost 2 vext1 <2,3,4,5>, RHS
    2131214336U, // <3,4,5,5>: Cost 2 ins <u,4,5,5>, lane 0
    537709878U,  // <3,4,5,6>: Cost 1 vext3 LHS, RHS
    2101379075U, // <3,4,5,7>: Cost 2 ins <3,4,5,u>, lane 3
    537709896U,  // <3,4,5,u>: Cost 1 vext3 LHS, RHS
    1659227468U, // <3,4,6,0>: Cost 2 vext3 LHS, <4,6,0,2>
    2689838422U, // <3,4,6,1>: Cost 3 vext3 LHS, <4,6,1,3>
    2564417231U, // <3,4,6,2>: Cost 3 vext1 <2,3,4,6>, <2,3,4,6>
    2558446082U, // <3,4,6,3>: Cost 3 vext1 <1,3,4,6>, <3,4,5,6>
    1659227508U, // <3,4,6,4>: Cost 2 vext3 LHS, <4,6,4,6>
    2689838462U, // <3,4,6,5>: Cost 3 vext3 LHS, <4,6,5,7>
    2131296256U, // <3,4,6,6>: Cost 2 ins <u,4,6,6>, lane 0
    2101600261U, // <3,4,6,7>: Cost 2 ins <3,4,u,u>, lane 5
    1659227540U, // <3,4,6,u>: Cost 2 vext3 LHS, <4,6,u,2>
    2666607610U, // <3,4,7,0>: Cost 3 vext2 <u,2,3,4>, <7,0,1,2>
    2659972191U, // <3,4,7,1>: Cost 3 vext2 <7,1,3,4>, <7,1,3,4>
    2660635824U, // <3,4,7,2>: Cost 3 vext2 <7,2,3,4>, <7,2,3,4>
    3177881601U, // <3,4,7,3>: Cost 3 ins <3,u,7,3>, lane 1
    2666607974U, // <3,4,7,4>: Cost 3 vext2 <u,2,3,4>, <7,4,5,6>
    3095396690U, // <3,4,7,5>: Cost 3 vtrnr <1,3,5,7>, <0,4,1,5>
    2131369984U, // <3,4,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    2666608236U, // <3,4,7,7>: Cost 3 vext2 <u,2,3,4>, <7,7,7,7>
    2131369984U, // <3,4,7,u>: Cost 2 ins <u,4,7,6>, lane 0
    1490690150U, // <3,4,u,0>: Cost 2 vext1 <2,3,4,u>, LHS
    1551062830U, // <3,4,u,1>: Cost 2 vext2 <1,2,3,4>, LHS
    1490691793U, // <3,4,u,2>: Cost 2 vext1 <2,3,4,u>, <2,3,4,u>
    2101600261U, // <3,4,u,3>: Cost 2 ins <3,4,u,u>, lane 5
    1490693430U, // <3,4,u,4>: Cost 2 vext1 <2,3,4,u>, RHS
    1551063194U, // <3,4,u,5>: Cost 2 vext2 <1,2,3,4>, RHS
    537710121U,  // <3,4,u,6>: Cost 1 vext3 LHS, RHS
    2101379075U, // <3,4,u,7>: Cost 2 ins <3,4,5,u>, lane 3
    537710139U,  // <3,4,u,u>: Cost 1 vext3 LHS, RHS
    2832842752U, // <3,5,0,0>: Cost 3 vuzpr <2,3,4,5>, <0,0,0,0>
    2131476480U, // <3,5,0,1>: Cost 2 ins <u,5,0,1>, lane 0
    1698709606U, // <3,5,0,2>: Cost 2 vuzpl <3,4,5,6>, LHS
    2772451522U, // <3,5,0,3>: Cost 3 vuzpl <3,4,5,6>, <0,2,3,5>
    2689838690U, // <3,5,0,4>: Cost 3 vext3 LHS, <5,0,4,1>
    2732969579U, // <3,5,0,5>: Cost 3 vext3 LHS, <5,0,5,1>
    2960310647U, // <3,5,0,6>: Cost 3 vzipr <1,2,3,0>, <0,4,5,6>
    2131525632U, // <3,5,0,7>: Cost 2 ins <u,5,0,7>, lane 0
    1698709660U, // <3,5,0,u>: Cost 2 vuzpl <3,4,5,6>, LHS
    2594308198U, // <3,5,1,0>: Cost 3 vext1 <7,3,5,1>, LHS
    2832843572U, // <3,5,1,1>: Cost 3 vuzpr <2,3,4,5>, <1,1,1,1>
    2103689217U, // <3,5,1,2>: Cost 2 ins <3,u,1,2>, lane 1
    1759101030U, // <3,5,1,3>: Cost 2 vuzpr <2,3,4,5>, LHS
    2626135101U, // <3,5,1,4>: Cost 3 vext2 <1,4,3,5>, <1,4,3,5>
    2772452352U, // <3,5,1,5>: Cost 3 vuzpl <3,4,5,6>, <1,3,5,7>
    3205332992U, // <3,5,1,6>: Cost 3 ins <u,5,1,6>, lane 0
    2027212086U, // <3,5,1,7>: Cost 2 vtrnr <2,3,0,1>, RHS
    2027212087U, // <3,5,1,u>: Cost 2 vtrnr <2,3,0,1>, RHS
    2832843670U, // <3,5,2,0>: Cost 3 vuzpr <2,3,4,5>, <1,2,3,0>
    2630116899U, // <3,5,2,1>: Cost 3 vext2 <2,1,3,5>, <2,1,3,5>
    2832842916U, // <3,5,2,2>: Cost 3 vuzpr <2,3,4,5>, <0,2,0,2>
    2131640320U, // <3,5,2,3>: Cost 2 ins <u,5,2,3>, lane 0
    2832842936U, // <3,5,2,4>: Cost 3 vuzpr <2,3,4,5>, <0,2,2,4>
    2715938575U, // <3,5,2,5>: Cost 3 vext3 <5,2,5,3>, <5,2,5,3>
    2959002114U, // <3,5,2,6>: Cost 3 vzipr <1,0,3,2>, <3,4,5,6>
    2131673088U, // <3,5,2,7>: Cost 2 ins <u,5,2,7>, lane 0
    2131640320U, // <3,5,2,u>: Cost 2 ins <u,5,2,3>, lane 0
    2772453922U, // <3,5,3,0>: Cost 3 vuzpl <3,4,5,6>, <3,5,0,2>
    2832844454U, // <3,5,3,1>: Cost 3 vuzpr <2,3,4,5>, <2,3,0,1>
    3177578497U, // <3,5,3,2>: Cost 3 ins <3,u,3,2>, lane 1
    2103844865U, // <3,5,3,3>: Cost 2 ins <3,u,3,3>, lane 1
    2618837506U, // <3,5,3,4>: Cost 3 vext2 <0,2,3,5>, <3,4,5,6>
    1759102670U, // <3,5,3,5>: Cost 2 vuzpr <2,3,4,5>, <2,3,4,5>
    2959673858U, // <3,5,3,6>: Cost 3 vzipr <1,1,3,3>, <3,4,5,6>
    2021330230U, // <3,5,3,7>: Cost 2 vtrnr <1,3,1,3>, RHS
    2021330231U, // <3,5,3,u>: Cost 2 vtrnr <1,3,1,3>, RHS
    2832845308U, // <3,5,4,0>: Cost 3 vuzpr <2,3,4,5>, <3,4,5,0>
    2732969871U, // <3,5,4,1>: Cost 3 vext3 LHS, <5,4,1,5>
    2832844536U, // <3,5,4,2>: Cost 3 vuzpr <2,3,4,5>, <2,4,0,2>
    3177660417U, // <3,5,4,3>: Cost 3 ins <3,u,4,3>, lane 1
    2832845312U, // <3,5,4,4>: Cost 3 vuzpr <2,3,4,5>, <3,4,5,4>
    2131804160U, // <3,5,4,5>: Cost 2 ins <u,5,4,5>, lane 0
    1698712886U, // <3,5,4,6>: Cost 2 vuzpl <3,4,5,6>, RHS
    1659228102U, // <3,5,4,7>: Cost 2 vext3 LHS, <5,4,7,6>
    1698712904U, // <3,5,4,u>: Cost 2 vuzpl <3,4,5,6>, RHS
    2570453094U, // <3,5,5,0>: Cost 3 vext1 <3,3,5,5>, LHS
    2832846074U, // <3,5,5,1>: Cost 3 vuzpr <2,3,4,5>, <4,5,0,1>
    2570454734U, // <3,5,5,2>: Cost 3 vext1 <3,3,5,5>, <2,3,4,5>
    2832845356U, // <3,5,5,3>: Cost 3 vuzpr <2,3,4,5>, <3,5,1,3>
    2570456374U, // <3,5,5,4>: Cost 3 vext1 <3,3,5,5>, RHS
    1659228164U, // <3,5,5,5>: Cost 2 vext3 LHS, <5,5,5,5>
    2104016897U, // <3,5,5,6>: Cost 2 ins <3,u,5,6>, lane 1
    1759104310U, // <3,5,5,7>: Cost 2 vuzpr <2,3,4,5>, RHS
    1759104311U, // <3,5,5,u>: Cost 2 vuzpr <2,3,4,5>, RHS
    2131910656U, // <3,5,6,0>: Cost 2 ins <u,5,6,0>, lane 0
    2131918848U, // <3,5,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2131927040U, // <3,5,6,2>: Cost 2 ins <u,5,6,2>, lane 0
    2131935232U, // <3,5,6,3>: Cost 2 ins <u,5,6,3>, lane 0
    2131943424U, // <3,5,6,4>: Cost 2 ins <u,5,6,4>, lane 0
    2131951616U, // <3,5,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    2131959808U, // <3,5,6,6>: Cost 2 ins <u,5,6,6>, lane 0
    1058226176U, // <3,5,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <3,5,6,u>: Cost 1 ins RHS, lane 0
    1484783718U, // <3,5,7,0>: Cost 2 vext1 <1,3,5,7>, LHS
    1484784640U, // <3,5,7,1>: Cost 2 vext1 <1,3,5,7>, <1,3,5,7>
    2558527080U, // <3,5,7,2>: Cost 3 vext1 <1,3,5,7>, <2,2,2,2>
    2558527638U, // <3,5,7,3>: Cost 3 vext1 <1,3,5,7>, <3,0,1,2>
    1484786998U, // <3,5,7,4>: Cost 2 vext1 <1,3,5,7>, RHS
    1659228328U, // <3,5,7,5>: Cost 2 vext3 LHS, <5,7,5,7>
    3095397528U, // <3,5,7,6>: Cost 3 vtrnr <1,3,5,7>, <1,5,4,6>
    2021657910U, // <3,5,7,7>: Cost 2 vtrnr <1,3,5,7>, RHS
    1484789550U, // <3,5,7,u>: Cost 2 vext1 <1,3,5,7>, LHS
    1484791910U, // <3,5,u,0>: Cost 2 vext1 <1,3,5,u>, LHS
    1484792833U, // <3,5,u,1>: Cost 2 vext1 <1,3,5,u>, <1,3,5,u>
    1698715438U, // <3,5,u,2>: Cost 2 vuzpl <3,4,5,6>, LHS
    1759101597U, // <3,5,u,3>: Cost 2 vuzpr <2,3,4,5>, LHS
    1484795190U, // <3,5,u,4>: Cost 2 vext1 <1,3,5,u>, RHS
    1659228409U, // <3,5,u,5>: Cost 2 vext3 LHS, <5,u,5,7>
    1698715802U, // <3,5,u,6>: Cost 2 vuzpl <3,4,5,6>, RHS
    1058226176U, // <3,5,u,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <3,5,u,u>: Cost 1 ins RHS, lane 0
    2732970264U, // <3,6,0,0>: Cost 3 vext3 LHS, <6,0,0,2>
    2689839393U, // <3,6,0,1>: Cost 3 vext3 LHS, <6,0,1,2>
    2132148224U, // <3,6,0,2>: Cost 2 ins <u,6,0,2>, lane 0
    3177365505U, // <3,6,0,3>: Cost 3 ins <3,u,0,3>, lane 1
    2689839420U, // <3,6,0,4>: Cost 3 vext3 LHS, <6,0,4,2>
    2732970314U, // <3,6,0,5>: Cost 3 vext3 LHS, <6,0,5,7>
    2732970316U, // <3,6,0,6>: Cost 3 vext3 LHS, <6,0,6,0>
    1886571830U, // <3,6,0,7>: Cost 2 vzipr <1,2,3,0>, RHS
    1886571831U, // <3,6,0,u>: Cost 2 vzipr <1,2,3,0>, RHS
    2720878954U, // <3,6,1,0>: Cost 3 vext3 <6,1,0,3>, <6,1,0,3>
    3205955584U, // <3,6,1,1>: Cost 3 ins <u,6,1,1>, lane 0
    2103689217U, // <3,6,1,2>: Cost 2 ins <3,u,1,2>, lane 1
    2826731622U, // <3,6,1,3>: Cost 3 vuzpr <1,3,2,6>, LHS
    2626143294U, // <3,6,1,4>: Cost 3 vext2 <1,4,3,6>, <1,4,3,6>
    3205988352U, // <3,6,1,5>: Cost 3 ins <u,6,1,5>, lane 0
    2721321376U, // <3,6,1,6>: Cost 3 vext3 <6,1,6,3>, <6,1,6,3>
    2954349878U, // <3,6,1,7>: Cost 3 vzipr <0,2,3,1>, RHS
    2103689217U, // <3,6,1,u>: Cost 2 ins <3,u,1,2>, lane 1
    2594390118U, // <3,6,2,0>: Cost 3 vext1 <7,3,6,2>, LHS
    2721616324U, // <3,6,2,1>: Cost 3 vext3 <6,2,1,3>, <6,2,1,3>
    2630788725U, // <3,6,2,2>: Cost 3 vext2 <2,2,3,6>, <2,2,3,6>
    2132303872U, // <3,6,2,3>: Cost 2 ins <u,6,2,3>, lane 0
    2632115991U, // <3,6,2,4>: Cost 3 vext2 <2,4,3,6>, <2,4,3,6>
    2632779624U, // <3,6,2,5>: Cost 3 vext2 <2,5,3,6>, <2,5,3,6>
    2826731724U, // <3,6,2,6>: Cost 3 vuzpr <1,3,2,6>, <0,2,4,6>
    1885261110U, // <3,6,2,7>: Cost 2 vzipr <1,0,3,2>, RHS
    1885261111U, // <3,6,2,u>: Cost 2 vzipr <1,0,3,2>, RHS
    3136876642U, // <3,6,3,0>: Cost 3 vtrnr <u,3,1,3>, <5,6,7,0>
    3206103040U, // <3,6,3,1>: Cost 3 ins <u,6,3,1>, lane 0
    3001478044U, // <3,6,3,2>: Cost 3 vzipr <u,1,3,3>, <4,0,6,2>
    2103844865U, // <3,6,3,3>: Cost 2 ins <3,u,3,3>, lane 1
    2632780290U, // <3,6,3,4>: Cost 3 vext2 <2,5,3,6>, <3,4,5,6>
    3206135808U, // <3,6,3,5>: Cost 3 ins <u,6,3,5>, lane 0
    1699457629U, // <3,6,3,6>: Cost 2 vuzpl <3,5,6,7>, <3,5,6,7>
    1885932854U, // <3,6,3,7>: Cost 2 vzipr <1,1,3,3>, RHS
    1885932855U, // <3,6,3,u>: Cost 2 vzipr <1,1,3,3>, RHS
    2732970588U, // <3,6,4,0>: Cost 3 vext3 LHS, <6,4,0,2>
    2722943590U, // <3,6,4,1>: Cost 3 vext3 <6,4,1,3>, <6,4,1,3>
    2732970604U, // <3,6,4,2>: Cost 3 vext3 LHS, <6,4,2,0>
    2906673714U, // <3,6,4,3>: Cost 3 vzipl <3,4,5,6>, <6,3,4,5>
    2732970628U, // <3,6,4,4>: Cost 3 vext3 LHS, <6,4,4,6>
    2689839757U, // <3,6,4,5>: Cost 3 vext3 LHS, <6,4,5,6>
    2132475904U, // <3,6,4,6>: Cost 2 ins <u,6,4,6>, lane 0
    1886604598U, // <3,6,4,7>: Cost 2 vzipr <1,2,3,4>, RHS
    1886604599U, // <3,6,4,u>: Cost 2 vzipr <1,2,3,4>, RHS
    2576498790U, // <3,6,5,0>: Cost 3 vext1 <4,3,6,5>, LHS
    3206250496U, // <3,6,5,1>: Cost 3 ins <u,6,5,1>, lane 0
    2732970692U, // <3,6,5,2>: Cost 3 vext3 LHS, <6,5,2,7>
    2576501250U, // <3,6,5,3>: Cost 3 vext1 <4,3,6,5>, <3,4,5,6>
    3040891442U, // <3,6,5,4>: Cost 3 vtrnl <3,4,5,6>, <6,3,4,5>
    3206283264U, // <3,6,5,5>: Cost 3 ins <u,6,5,5>, lane 0
    2104016897U, // <3,6,5,6>: Cost 2 ins <3,u,5,6>, lane 1
    2954382646U, // <3,6,5,7>: Cost 3 vzipr <0,2,3,5>, RHS
    2104016897U, // <3,6,5,u>: Cost 2 ins <3,u,5,6>, lane 1
    2732970748U, // <3,6,6,0>: Cost 3 vext3 LHS, <6,6,0,0>
    2724270856U, // <3,6,6,1>: Cost 3 vext3 <6,6,1,3>, <6,6,1,3>
    2732970768U, // <3,6,6,2>: Cost 3 vext3 LHS, <6,6,2,2>
    3177807873U, // <3,6,6,3>: Cost 3 ins <3,u,6,3>, lane 1
    2732970788U, // <3,6,6,4>: Cost 3 vext3 LHS, <6,6,4,4>
    2732970800U, // <3,6,6,5>: Cost 3 vext3 LHS, <6,6,5,7>
    1659228984U, // <3,6,6,6>: Cost 2 vext3 LHS, <6,6,6,6>
    1659228994U, // <3,6,6,7>: Cost 2 vext3 LHS, <6,6,7,7>
    1659229003U, // <3,6,6,u>: Cost 2 vext3 LHS, <6,6,u,7>
    1659229006U, // <3,6,7,0>: Cost 2 vext3 LHS, <6,7,0,1>
    2558600201U, // <3,6,7,1>: Cost 3 vext1 <1,3,6,7>, <1,3,6,7>
    1611453282U, // <3,6,7,2>: Cost 2 vext3 LHS, <6,7,2,3>
    2968996198U, // <3,6,7,3>: Cost 3 vzipr <2,6,3,7>, <3,2,6,3>
    1659229046U, // <3,6,7,4>: Cost 2 vext3 LHS, <6,7,4,5>
    2968995633U, // <3,6,7,5>: Cost 3 vzipr <2,6,3,7>, <2,4,6,5>
    1611453322U, // <3,6,7,6>: Cost 2 vext3 LHS, <6,7,6,7>
    1888619830U, // <3,6,7,7>: Cost 2 vzipr <1,5,3,7>, RHS
    1888619831U, // <3,6,7,u>: Cost 2 vzipr <1,5,3,7>, RHS
    1659229087U, // <3,6,u,0>: Cost 2 vext3 LHS, <6,u,0,1>
    2689840041U, // <3,6,u,1>: Cost 3 vext3 LHS, <6,u,1,2>
    2132148224U, // <3,6,u,2>: Cost 2 ins <u,6,0,2>, lane 0
    2132303872U, // <3,6,u,3>: Cost 2 ins <u,6,2,3>, lane 0
    1659229127U, // <3,6,u,4>: Cost 2 vext3 LHS, <6,u,4,5>
    2689840081U, // <3,6,u,5>: Cost 3 vext3 LHS, <6,u,5,6>
    2132475904U, // <3,6,u,6>: Cost 2 ins <u,6,4,6>, lane 0
    1885310262U, // <3,6,u,7>: Cost 2 vzipr <1,0,3,u>, RHS
    1885310263U, // <3,6,u,u>: Cost 2 vzipr <1,0,3,u>, RHS
    2826960896U, // <3,7,0,0>: Cost 3 vuzpr <1,3,5,7>, <0,0,0,0>
    1553072230U, // <3,7,0,1>: Cost 2 vext2 <1,5,3,7>, LHS
    2826960916U, // <3,7,0,2>: Cost 3 vuzpr <1,3,5,7>, <0,0,2,2>
    3002117840U, // <3,7,0,3>: Cost 3 vzipr <u,2,3,0>, <5,1,7,3>
    2626814290U, // <3,7,0,4>: Cost 3 vext2 <1,5,3,7>, <0,4,1,5>
    2582507375U, // <3,7,0,5>: Cost 3 vext1 <5,3,7,0>, <5,3,7,0>
    2588480072U, // <3,7,0,6>: Cost 3 vext1 <6,3,7,0>, <6,3,7,0>
    2732971055U, // <3,7,0,7>: Cost 3 vext3 LHS, <7,0,7,1>
    1553072797U, // <3,7,0,u>: Cost 2 vext2 <1,5,3,7>, LHS
    2626814710U, // <3,7,1,0>: Cost 3 vext2 <1,5,3,7>, <1,0,3,2>
    2826961716U, // <3,7,1,1>: Cost 3 vuzpr <1,3,5,7>, <1,1,1,1>
    2103689217U, // <3,7,1,2>: Cost 2 ins <3,u,1,2>, lane 1
    1753219174U, // <3,7,1,3>: Cost 2 vuzpr <1,3,5,7>, LHS
    2582514998U, // <3,7,1,4>: Cost 3 vext1 <5,3,7,1>, RHS
    1553073296U, // <3,7,1,5>: Cost 2 vext2 <1,5,3,7>, <1,5,3,7>
    2627478753U, // <3,7,1,6>: Cost 3 vext2 <1,6,3,7>, <1,6,3,7>
    2727367810U, // <3,7,1,7>: Cost 3 vext3 <7,1,7,3>, <7,1,7,3>
    1753219179U, // <3,7,1,u>: Cost 2 vuzpr <1,3,5,7>, LHS
    2826961814U, // <3,7,2,0>: Cost 3 vuzpr <1,3,5,7>, <1,2,3,0>
    3206692864U, // <3,7,2,1>: Cost 3 ins <u,7,2,1>, lane 0
    2826961060U, // <3,7,2,2>: Cost 3 vuzpr <1,3,5,7>, <0,2,0,2>
    2132967424U, // <3,7,2,3>: Cost 2 ins <u,7,2,3>, lane 0
    2826961818U, // <3,7,2,4>: Cost 3 vuzpr <1,3,5,7>, <1,2,3,4>
    2826961072U, // <3,7,2,5>: Cost 3 vuzpr <1,3,5,7>, <0,2,1,5>
    1559709626U, // <3,7,2,6>: Cost 2 vext2 <2,6,3,7>, <2,6,3,7>
    2728031443U, // <3,7,2,7>: Cost 3 vext3 <7,2,7,3>, <7,2,7,3>
    1561036892U, // <3,7,2,u>: Cost 2 vext2 <2,u,3,7>, <2,u,3,7>
    2626816150U, // <3,7,3,0>: Cost 3 vext2 <1,5,3,7>, <3,0,1,2>
    2826962598U, // <3,7,3,1>: Cost 3 vuzpr <1,3,5,7>, <2,3,0,1>
    2633451878U, // <3,7,3,2>: Cost 3 vext2 <2,6,3,7>, <3,2,6,3>
    2103844865U, // <3,7,3,3>: Cost 2 ins <3,u,3,3>, lane 1
    2626816514U, // <3,7,3,4>: Cost 3 vext2 <1,5,3,7>, <3,4,5,6>
    2826962638U, // <3,7,3,5>: Cost 3 vuzpr <1,3,5,7>, <2,3,4,5>
    2639424147U, // <3,7,3,6>: Cost 3 vext2 <3,6,3,7>, <3,6,3,7>
    1753220096U, // <3,7,3,7>: Cost 2 vuzpr <1,3,5,7>, <1,3,5,7>
    1753220096U, // <3,7,3,u>: Cost 2 vuzpr <1,3,5,7>, <1,3,5,7>
    2582536294U, // <3,7,4,0>: Cost 3 vext1 <5,3,7,4>, LHS
    2582537360U, // <3,7,4,1>: Cost 3 vext1 <5,3,7,4>, <1,5,3,7>
    2588510138U, // <3,7,4,2>: Cost 3 vext1 <6,3,7,4>, <2,6,3,7>
    3002150608U, // <3,7,4,3>: Cost 3 vzipr <u,2,3,4>, <5,1,7,3>
    2582539574U, // <3,7,4,4>: Cost 3 vext1 <5,3,7,4>, RHS
    1553075510U, // <3,7,4,5>: Cost 2 vext2 <1,5,3,7>, RHS
    2826961244U, // <3,7,4,6>: Cost 3 vuzpr <1,3,5,7>, <0,4,2,6>
    2732971383U, // <3,7,4,7>: Cost 3 vext3 LHS, <7,4,7,5>
    1553075753U, // <3,7,4,u>: Cost 2 vext2 <1,5,3,7>, RHS
    2826963551U, // <3,7,5,0>: Cost 3 vuzpr <1,3,5,7>, <3,5,7,0>
    2826963552U, // <3,7,5,1>: Cost 3 vuzpr <1,3,5,7>, <3,5,7,1>
    2826962032U, // <3,7,5,2>: Cost 3 vuzpr <1,3,5,7>, <1,5,0,2>
    2626817903U, // <3,7,5,3>: Cost 3 vext2 <1,5,3,7>, <5,3,7,0>
    2826963555U, // <3,7,5,4>: Cost 3 vuzpr <1,3,5,7>, <3,5,7,4>
    2826962044U, // <3,7,5,5>: Cost 3 vuzpr <1,3,5,7>, <1,5,1,5>
    2104016897U, // <3,7,5,6>: Cost 2 ins <3,u,5,6>, lane 1
    1753222454U, // <3,7,5,7>: Cost 2 vuzpr <1,3,5,7>, RHS
    1753222455U, // <3,7,5,u>: Cost 2 vuzpr <1,3,5,7>, RHS
    2732971478U, // <3,7,6,0>: Cost 3 vext3 LHS, <7,6,0,1>
    2732971486U, // <3,7,6,1>: Cost 3 vext3 LHS, <7,6,1,0>
    2633454074U, // <3,7,6,2>: Cost 3 vext2 <2,6,3,7>, <6,2,7,3>
    2633454152U, // <3,7,6,3>: Cost 3 vext2 <2,6,3,7>, <6,3,7,0>
    2732971518U, // <3,7,6,4>: Cost 3 vext3 LHS, <7,6,4,5>
    2732971526U, // <3,7,6,5>: Cost 3 vext3 LHS, <7,6,5,4>
    2732971537U, // <3,7,6,6>: Cost 3 vext3 LHS, <7,6,6,6>
    2133295104U, // <3,7,6,7>: Cost 2 ins <u,7,6,7>, lane 0
    2133295104U, // <3,7,6,u>: Cost 2 ins <u,7,6,7>, lane 0
    2962362223U, // <3,7,7,0>: Cost 3 vzipr <1,5,3,7>, <5,3,7,0>
    2826965109U, // <3,7,7,1>: Cost 3 vuzpr <1,3,5,7>, <5,7,0,1>
    2968998474U, // <3,7,7,2>: Cost 3 vzipr <2,6,3,7>, <6,3,7,2>
    2826963662U, // <3,7,7,3>: Cost 3 vuzpr <1,3,5,7>, <3,7,1,3>
    2962362227U, // <3,7,7,4>: Cost 3 vzipr <1,5,3,7>, <5,3,7,4>
    2826965149U, // <3,7,7,5>: Cost 3 vuzpr <1,3,5,7>, <5,7,4,5>
    2588537423U, // <3,7,7,6>: Cost 3 vext1 <6,3,7,7>, <6,3,7,7>
    1659229804U, // <3,7,7,7>: Cost 2 vext3 LHS, <7,7,7,7>
    1659229804U, // <3,7,7,u>: Cost 2 vext3 LHS, <7,7,7,7>
    2826962300U, // <3,7,u,0>: Cost 3 vuzpr <1,3,5,7>, <1,u,3,0>
    1553078062U, // <3,7,u,1>: Cost 2 vext2 <1,5,3,7>, LHS
    2103689217U, // <3,7,u,2>: Cost 2 ins <3,u,1,2>, lane 1
    1753219741U, // <3,7,u,3>: Cost 2 vuzpr <1,3,5,7>, LHS
    2826962304U, // <3,7,u,4>: Cost 3 vuzpr <1,3,5,7>, <1,u,3,4>
    1553078426U, // <3,7,u,5>: Cost 2 vext2 <1,5,3,7>, RHS
    1595545808U, // <3,7,u,6>: Cost 2 vext2 <u,6,3,7>, <u,6,3,7>
    1753222697U, // <3,7,u,7>: Cost 2 vuzpr <1,3,5,7>, RHS
    1753219746U, // <3,7,u,u>: Cost 2 vuzpr <1,3,5,7>, LHS
    1611448320U, // <3,u,0,0>: Cost 2 vext3 LHS, <0,0,0,0>
    1611896531U, // <3,u,0,1>: Cost 2 vext3 LHS, <u,0,1,2>
    1696243814U, // <3,u,0,2>: Cost 2 vuzpl <3,0,u,2>, LHS
    1616099045U, // <3,u,0,3>: Cost 2 vext3 LHS, <u,0,3,2>
    2685638381U, // <3,u,0,4>: Cost 3 vext3 LHS, <u,0,4,1>
    1829951642U, // <3,u,0,5>: Cost 2 vzipl <3,0,1,2>, RHS
    1663874816U, // <3,u,0,6>: Cost 2 vext3 LHS, <u,0,6,2>
    1886571848U, // <3,u,0,7>: Cost 2 vzipr <1,2,3,0>, RHS
    1611896594U, // <3,u,0,u>: Cost 2 vext3 LHS, <u,0,u,2>
    1549763324U, // <3,u,1,0>: Cost 2 vext2 <1,0,3,u>, <1,0,3,u>
    1550426957U, // <3,u,1,1>: Cost 2 vext2 <1,1,3,u>, <1,1,3,u>
    537712430U,  // <3,u,1,2>: Cost 1 vext3 LHS, LHS
    1616541495U, // <3,u,1,3>: Cost 2 vext3 LHS, <u,1,3,3>
    1490930998U, // <3,u,1,4>: Cost 2 vext1 <2,3,u,1>, RHS
    1553081489U, // <3,u,1,5>: Cost 2 vext2 <1,5,3,u>, <1,5,3,u>
    1964169370U, // <3,u,1,6>: Cost 2 vtrnl <3,0,1,2>, RHS
    2027212329U, // <3,u,1,7>: Cost 2 vtrnr <2,3,0,1>, RHS
    537712484U,  // <3,u,1,u>: Cost 1 vext3 LHS, LHS
    1659672428U, // <3,u,2,0>: Cost 2 vext3 LHS, <u,2,0,2>
    2128969728U, // <3,u,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    1557063287U, // <3,u,2,2>: Cost 2 vext2 <2,2,3,u>, <2,2,3,u>
    1055244288U, // <3,u,2,3>: Cost 1 ins LHS, lane 0
    1659672468U, // <3,u,2,4>: Cost 2 vext3 LHS, <u,2,4,6>
    2129002496U, // <3,u,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    1559717819U, // <3,u,2,6>: Cost 2 vext2 <2,6,3,u>, <2,6,3,u>
    1885261128U, // <3,u,2,7>: Cost 2 vzipr <1,0,3,2>, RHS
    1055244288U, // <3,u,2,u>: Cost 1 ins LHS, lane 0
    1611896764U, // <3,u,3,0>: Cost 2 vext3 LHS, <u,3,0,1>
    1616541639U, // <3,u,3,1>: Cost 2 vext3 LHS, <u,3,1,3>
    1966315310U, // <3,u,3,2>: Cost 2 vtrnl <3,3,3,3>, LHS
    336380006U,  // <3,u,3,3>: Cost 1 vdup3 LHS
    1611896804U, // <3,u,3,4>: Cost 2 vext3 LHS, <u,3,4,5>
    1616541679U, // <3,u,3,5>: Cost 2 vext3 LHS, <u,3,5,7>
    1966315674U, // <3,u,3,6>: Cost 2 vtrnl <3,3,3,3>, RHS
    1885932872U, // <3,u,3,7>: Cost 2 vzipr <1,1,3,3>, RHS
    336380006U,  // <3,u,3,u>: Cost 1 vdup3 LHS
    2960344003U, // <3,u,4,0>: Cost 3 vzipr <1,2,3,4>, <1,2,u,0>
    1832933166U, // <3,u,4,1>: Cost 2 vzipl <3,4,5,6>, LHS
    1659672612U, // <3,u,4,2>: Cost 2 vext3 LHS, <u,4,2,6>
    1886601372U, // <3,u,4,3>: Cost 2 vzipr <1,2,3,4>, LHS
    1886602138U, // <3,u,4,4>: Cost 2 vzipr <1,2,3,4>, <1,2,3,4>
    1611896895U, // <3,u,4,5>: Cost 2 vext3 LHS, <u,4,5,6>
    1696247094U, // <3,u,4,6>: Cost 2 vuzpl <3,0,u,2>, RHS
    1886604616U, // <3,u,4,7>: Cost 2 vzipr <1,2,3,4>, RHS
    1611896922U, // <3,u,4,u>: Cost 2 vext3 LHS, <u,4,u,6>
    1490960486U, // <3,u,5,0>: Cost 2 vext1 <2,3,u,5>, LHS
    2128527360U, // <3,u,5,1>: Cost 2 ins <u,0,5,1>, lane 0
    1490962162U, // <3,u,5,2>: Cost 2 vext1 <2,3,u,5>, <2,3,u,5>
    1616541823U, // <3,u,5,3>: Cost 2 vext3 LHS, <u,5,3,7>
    1490963766U, // <3,u,5,4>: Cost 2 vext1 <2,3,u,5>, RHS
    2027538126U, // <3,u,5,5>: Cost 2 vtrnr <2,3,4,5>, <2,3,4,5>
    537712794U,  // <3,u,5,6>: Cost 1 vext3 LHS, RHS
    1752935734U, // <3,u,5,7>: Cost 2 vuzpr <1,3,1,u>, RHS
    537712812U,  // <3,u,5,u>: Cost 1 vext3 LHS, RHS
    1663875248U, // <3,u,6,0>: Cost 2 vext3 LHS, <u,6,0,2>
    2131918848U, // <3,u,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2128609280U, // <3,u,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    1616099536U, // <3,u,6,3>: Cost 2 vext3 LHS, <u,6,3,7>
    1663875288U, // <3,u,6,4>: Cost 2 vext3 LHS, <u,6,4,6>
    2131951616U, // <3,u,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    2131296256U, // <3,u,6,6>: Cost 2 ins <u,4,6,6>, lane 0
    1058226176U, // <3,u,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <3,u,6,u>: Cost 1 ins RHS, lane 0
    1485004902U, // <3,u,7,0>: Cost 2 vext1 <1,3,u,7>, LHS
    1485005851U, // <3,u,7,1>: Cost 2 vext1 <1,3,u,7>, <1,3,u,7>
    2098896898U, // <3,u,7,2>: Cost 2 ins <3,0,u,2>, lane 2
    2021655197U, // <3,u,7,3>: Cost 2 vtrnr <1,3,5,7>, LHS
    1485008182U, // <3,u,7,4>: Cost 2 vext1 <1,3,u,7>, RHS
    1659230515U, // <3,u,7,5>: Cost 2 vext3 LHS, <u,7,5,7>
    2131369984U, // <3,u,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    2021658153U, // <3,u,7,7>: Cost 2 vtrnr <1,3,5,7>, RHS
    2021655202U, // <3,u,7,u>: Cost 2 vtrnr <1,3,5,7>, LHS
    1616099665U, // <3,u,u,0>: Cost 2 vext3 LHS, <u,u,0,1>
    1611897179U, // <3,u,u,1>: Cost 2 vext3 LHS, <u,u,1,2>
    537712997U,  // <3,u,u,2>: Cost 1 vext3 LHS, LHS
    1055244288U, // <3,u,u,3>: Cost 1 ins LHS, lane 0
    1616099705U, // <3,u,u,4>: Cost 2 vext3 LHS, <u,u,4,5>
    1611897219U, // <3,u,u,5>: Cost 2 vext3 LHS, <u,u,5,6>
    537713037U,  // <3,u,u,6>: Cost 1 vext3 LHS, RHS
    1058226176U, // <3,u,u,7>: Cost 1 ins RHS, lane 0
    537713051U,  // <3,u,u,u>: Cost 1 vext3 LHS, LHS
    2128150528U, // <4,0,0,0>: Cost 2 ins <u,0,0,0>, lane 0
    2104860674U, // <4,0,0,1>: Cost 2 ins <4,0,u,1>, lane 2
    1705607270U, // <4,0,0,2>: Cost 2 vuzpl <4,6,0,2>, LHS
    3178070019U, // <4,0,0,3>: Cost 3 ins <4,0,0,u>, lane 3
    2909946194U, // <4,0,0,4>: Cost 3 vzipl <4,0,5,1>, <0,4,1,5>
    3178070019U, // <4,0,0,5>: Cost 3 ins <4,0,0,u>, lane 3
    3183362049U, // <4,0,0,6>: Cost 3 ins <4,u,0,6>, lane 1
    2109628417U, // <4,0,0,7>: Cost 2 ins <4,u,0,7>, lane 1
    1705607324U, // <4,0,0,u>: Cost 2 vuzpl <4,6,0,2>, LHS
    2570715238U, // <4,0,1,0>: Cost 3 vext1 <3,4,0,1>, LHS
    2128232448U, // <4,0,1,1>: Cost 2 ins <u,0,1,1>, lane 0
    1618165862U, // <4,0,1,2>: Cost 2 vext3 <1,2,3,4>, LHS
    2833612902U, // <4,0,1,3>: Cost 3 vuzpr <2,4,6,0>, LHS
    2570718518U, // <4,0,1,4>: Cost 3 vext1 <3,4,0,1>, RHS
    2779350016U, // <4,0,1,5>: Cost 3 vuzpl <4,6,0,2>, <1,3,5,7>
    3202015232U, // <4,0,1,6>: Cost 3 ins <u,0,1,6>, lane 0
    2109702145U, // <4,0,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    1618165916U, // <4,0,1,u>: Cost 2 vext3 <1,2,3,4>, LHS
    2685714598U, // <4,0,2,0>: Cost 3 vext3 <0,2,0,4>, <0,2,0,4>
    2104860674U, // <4,0,2,1>: Cost 2 ins <4,0,u,1>, lane 2
    2128314368U, // <4,0,2,2>: Cost 2 ins <u,0,2,2>, lane 0
    2104918021U, // <4,0,2,3>: Cost 2 ins <4,0,u,u>, lane 5
    2685714636U, // <4,0,2,4>: Cost 3 vext3 <0,2,0,4>, <0,2,4,6>
    3044622465U, // <4,0,2,5>: Cost 3 vtrnl <4,1,2,3>, <0,1,5,3>
    2833613004U, // <4,0,2,6>: Cost 3 vuzpr <2,4,6,0>, <0,2,4,6>
    2109775873U, // <4,0,2,7>: Cost 2 ins <4,u,2,7>, lane 1
    2104860674U, // <4,0,2,u>: Cost 2 ins <4,0,u,1>, lane 2
    3202113536U, // <4,0,3,0>: Cost 3 ins <u,0,3,0>, lane 0
    2104860674U, // <4,0,3,1>: Cost 2 ins <4,0,u,1>, lane 2
    2128388096U, // <4,0,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    2779351452U, // <4,0,3,3>: Cost 3 vuzpl <4,6,0,2>, <3,3,3,3>
    3178627074U, // <4,0,3,4>: Cost 3 ins <4,0,u,4>, lane 2
    2839512782U, // <4,0,3,5>: Cost 3 vuzpr <3,4,5,0>, <2,3,4,5>
    3178643458U, // <4,0,3,6>: Cost 3 ins <4,0,u,6>, lane 2
    2109849601U, // <4,0,3,7>: Cost 2 ins <4,u,3,7>, lane 1
    2104860674U, // <4,0,3,u>: Cost 2 ins <4,0,u,1>, lane 2
    1705610572U, // <4,0,4,0>: Cost 2 vuzpl <4,6,0,2>, <4,6,0,2>
    2104860674U, // <4,0,4,1>: Cost 2 ins <4,0,u,1>, lane 2
    1974370406U, // <4,0,4,2>: Cost 2 vtrnl <4,6,4,6>, LHS
    3178364931U, // <4,0,4,3>: Cost 3 ins <4,0,4,u>, lane 3
    2109898753U, // <4,0,4,4>: Cost 2 ins <4,u,4,4>, lane 1
    2104918021U, // <4,0,4,5>: Cost 2 ins <4,0,u,u>, lane 5
    1705610550U, // <4,0,4,6>: Cost 2 vuzpl <4,6,0,2>, RHS
    2109923329U, // <4,0,4,7>: Cost 2 ins <4,u,4,7>, lane 1
    1705610568U, // <4,0,4,u>: Cost 2 vuzpl <4,6,0,2>, RHS
    1839644672U, // <4,0,5,0>: Cost 2 vzipl RHS, <0,0,0,0>
    765902950U,  // <4,0,5,1>: Cost 1 vzipl RHS, LHS
    1839644836U, // <4,0,5,2>: Cost 2 vzipl RHS, <0,2,0,2>
    2104696835U, // <4,0,5,3>: Cost 2 ins <4,0,5,u>, lane 3
    1839645010U, // <4,0,5,4>: Cost 2 vzipl RHS, <0,4,1,5>
    2109980673U, // <4,0,5,5>: Cost 2 ins <4,u,5,5>, lane 1
    2104696835U, // <4,0,5,6>: Cost 2 ins <4,0,5,u>, lane 3
    2104696835U, // <4,0,5,7>: Cost 2 ins <4,0,5,u>, lane 3
    765903517U,  // <4,0,5,u>: Cost 1 vzipl RHS, LHS
    1973862400U, // <4,0,6,0>: Cost 2 vtrnl RHS, <0,0,0,0>
    1973862410U, // <4,0,6,1>: Cost 2 vtrnl RHS, <0,0,1,1>
    900120678U,  // <4,0,6,2>: Cost 1 vtrnl RHS, LHS
    2104770563U, // <4,0,6,3>: Cost 2 ins <4,0,6,u>, lane 3
    1973862604U, // <4,0,6,4>: Cost 2 vtrnl RHS, <0,2,4,6>
    2104770563U, // <4,0,6,5>: Cost 2 ins <4,0,6,u>, lane 3
    2110062593U, // <4,0,6,6>: Cost 2 ins <4,u,6,6>, lane 1
    1036328961U, // <4,0,6,7>: Cost 1 ins RHS, lane 1
    900120732U,  // <4,0,6,u>: Cost 1 vtrnl RHS, LHS
    3202408448U, // <4,0,7,0>: Cost 3 ins <u,0,7,0>, lane 0
    2104860674U, // <4,0,7,1>: Cost 2 ins <4,0,u,1>, lane 2
    2104868866U, // <4,0,7,2>: Cost 2 ins <4,0,u,2>, lane 2
    3114049557U, // <4,0,7,3>: Cost 3 vtrnr <4,4,6,7>, <0,0,2,3>
    3178627074U, // <4,0,7,4>: Cost 3 ins <4,0,u,4>, lane 2
    2779354470U, // <4,0,7,5>: Cost 3 vuzpl <4,6,0,2>, <7,4,5,6>
    2779354473U, // <4,0,7,6>: Cost 3 vuzpl <4,6,0,2>, <7,4,6,0>
    2110144513U, // <4,0,7,7>: Cost 2 ins <4,u,7,7>, lane 1
    2104860674U, // <4,0,7,u>: Cost 2 ins <4,0,u,1>, lane 2
    1974009856U, // <4,0,u,0>: Cost 2 vtrnl RHS, <0,0,0,0>
    767893606U,  // <4,0,u,1>: Cost 1 vzipl RHS, LHS
    900268134U,  // <4,0,u,2>: Cost 1 vtrnl RHS, LHS
    2104918021U, // <4,0,u,3>: Cost 2 ins <4,0,u,u>, lane 5
    1974010060U, // <4,0,u,4>: Cost 2 vtrnl RHS, <0,2,4,6>
    2104918021U, // <4,0,u,5>: Cost 2 ins <4,0,u,u>, lane 5
    1705613466U, // <4,0,u,6>: Cost 2 vuzpl <4,6,0,2>, RHS
    1036328961U, // <4,0,u,7>: Cost 1 ins RHS, lane 1
    900268188U,  // <4,0,u,u>: Cost 1 vtrnl RHS, LHS
    2600640614U, // <4,1,0,0>: Cost 3 vext1 <u,4,1,0>, LHS
    2128822272U, // <4,1,0,1>: Cost 2 ins <u,1,0,1>, lane 0
    2109587457U, // <4,1,0,2>: Cost 2 ins <4,u,0,2>, lane 1
    2128838656U, // <4,1,0,3>: Cost 2 ins <u,1,0,3>, lane 0
    2622857554U, // <4,1,0,4>: Cost 3 vext2 <0,u,4,1>, <0,4,1,5>
    3047785472U, // <4,1,0,5>: Cost 3 vtrnl <4,6,0,2>, <1,3,5,7>
    3183362049U, // <4,1,0,6>: Cost 3 ins <4,u,0,6>, lane 1
    2109628417U, // <4,1,0,7>: Cost 2 ins <4,u,0,7>, lane 1
    2109587457U, // <4,1,0,u>: Cost 2 ins <4,u,0,2>, lane 1
    3202629632U, // <4,1,1,0>: Cost 3 ins <u,1,1,0>, lane 0
    2128896000U, // <4,1,1,1>: Cost 2 ins <u,1,1,1>, lane 0
    2631484314U, // <4,1,1,2>: Cost 3 vext2 <2,3,4,1>, <1,2,3,4>
    2128912384U, // <4,1,1,3>: Cost 2 ins <u,1,1,3>, lane 0
    3202662400U, // <4,1,1,4>: Cost 3 ins <u,1,1,4>, lane 0
    2958401874U, // <4,1,1,5>: Cost 3 vzipr <0,u,4,1>, <0,4,1,5>
    2778801323U, // <4,1,1,6>: Cost 3 vuzpl <4,5,1,7>, <1,5,6,7>
    2109702145U, // <4,1,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    2128896000U, // <4,1,1,u>: Cost 2 ins <u,1,1,1>, lane 0
    2128961536U, // <4,1,2,0>: Cost 2 ins <u,1,2,0>, lane 0
    2128969728U, // <4,1,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    2128977920U, // <4,1,2,2>: Cost 2 ins <u,1,2,2>, lane 0
    1055244288U, // <4,1,2,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <4,1,2,4>: Cost 2 ins <u,1,2,4>, lane 0
    2129002496U, // <4,1,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2129010688U, // <4,1,2,6>: Cost 2 ins <u,1,2,6>, lane 0
    2129018880U, // <4,1,2,7>: Cost 2 ins <u,1,2,7>, lane 0
    1055244288U, // <4,1,2,u>: Cost 1 ins LHS, lane 0
    2564833382U, // <4,1,3,0>: Cost 3 vext1 <2,4,1,3>, LHS
    2691908568U, // <4,1,3,1>: Cost 3 vext3 <1,2,3,4>, <1,3,1,3>
    2691908578U, // <4,1,3,2>: Cost 3 vext3 <1,2,3,4>, <1,3,2,4>
    2129059840U, // <4,1,3,3>: Cost 2 ins <u,1,3,3>, lane 0
    2564836662U, // <4,1,3,4>: Cost 3 vext1 <2,4,1,3>, RHS
    2691908608U, // <4,1,3,5>: Cost 3 vext3 <1,2,3,4>, <1,3,5,7>
    2588725862U, // <4,1,3,6>: Cost 3 vext1 <6,4,1,3>, <6,4,1,3>
    2109849601U, // <4,1,3,7>: Cost 2 ins <4,u,3,7>, lane 1
    2129059840U, // <4,1,3,u>: Cost 2 ins <u,1,3,3>, lane 0
    2600673382U, // <4,1,4,0>: Cost 3 vext1 <u,4,1,4>, LHS
    1705061641U, // <4,1,4,1>: Cost 2 vuzpl <4,5,1,7>, <4,5,1,7>
    2912641946U, // <4,1,4,2>: Cost 3 vzipl <4,4,5,6>, <1,2,3,4>
    2040135782U, // <4,1,4,3>: Cost 2 vtrnr <4,4,4,4>, LHS
    2109898753U, // <4,1,4,4>: Cost 2 ins <4,u,4,4>, lane 1
    2129149952U, // <4,1,4,5>: Cost 2 ins <u,1,4,5>, lane 0
    2109915137U, // <4,1,4,6>: Cost 2 ins <4,u,4,6>, lane 1
    2109923329U, // <4,1,4,7>: Cost 2 ins <4,u,4,7>, lane 1
    2109915137U, // <4,1,4,u>: Cost 2 ins <4,u,4,6>, lane 1
    1479164242U, // <4,1,5,0>: Cost 2 vext1 <0,4,1,5>, <0,4,1,5>
    1839645492U, // <4,1,5,1>: Cost 2 vzipl RHS, <1,1,1,1>
    1839645590U, // <4,1,5,2>: Cost 2 vzipl RHS, <1,2,3,0>
    2016034918U, // <4,1,5,3>: Cost 2 vtrnr <0,4,1,5>, LHS
    1479167286U, // <4,1,5,4>: Cost 2 vext1 <0,4,1,5>, RHS
    1839645840U, // <4,1,5,5>: Cost 2 vzipl RHS, <1,5,3,7>
    3089776763U, // <4,1,5,6>: Cost 3 vtrnr <0,4,1,5>, <0,1,4,6>
    2109997057U, // <4,1,5,7>: Cost 2 ins <4,u,5,7>, lane 1
    1479169838U, // <4,1,5,u>: Cost 2 vext1 <0,4,1,5>, LHS
    2110013441U, // <4,1,6,0>: Cost 2 ins <4,u,6,0>, lane 1
    1973863220U, // <4,1,6,1>: Cost 2 vtrnl RHS, <1,1,1,1>
    2110029825U, // <4,1,6,2>: Cost 2 ins <4,u,6,2>, lane 1
    2016116838U, // <4,1,6,3>: Cost 2 vtrnr <0,4,2,6>, LHS
    2110046209U, // <4,1,6,4>: Cost 2 ins <4,u,6,4>, lane 1
    1973863424U, // <4,1,6,5>: Cost 2 vtrnl RHS, <1,3,5,7>
    2110062593U, // <4,1,6,6>: Cost 2 ins <4,u,6,6>, lane 1
    1036328961U, // <4,1,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,1,6,u>: Cost 1 ins RHS, lane 1
    2659357716U, // <4,1,7,0>: Cost 3 vext2 <7,0,4,1>, <7,0,4,1>
    3203080192U, // <4,1,7,1>: Cost 3 ins <u,1,7,1>, lane 0
    3203088384U, // <4,1,7,2>: Cost 3 ins <u,1,7,2>, lane 0
    2129354752U, // <4,1,7,3>: Cost 2 ins <u,1,7,3>, lane 0
    2664666470U, // <4,1,7,4>: Cost 3 vext2 <7,u,4,1>, <7,4,5,6>
    3203112960U, // <4,1,7,5>: Cost 3 ins <u,1,7,5>, lane 0
    3114049641U, // <4,1,7,6>: Cost 3 vtrnr <4,4,6,7>, <0,1,2,6>
    2110144513U, // <4,1,7,7>: Cost 2 ins <4,u,7,7>, lane 1
    2129354752U, // <4,1,7,u>: Cost 2 ins <u,1,7,3>, lane 0
    1479188821U, // <4,1,u,0>: Cost 2 vext1 <0,4,1,u>, <0,4,1,u>
    1974010676U, // <4,1,u,1>: Cost 2 vtrnl RHS, <1,1,1,1>
    1841636246U, // <4,1,u,2>: Cost 2 vzipl RHS, <1,2,3,0>
    1055244288U, // <4,1,u,3>: Cost 1 ins LHS, lane 0
    1479191862U, // <4,1,u,4>: Cost 2 vext1 <0,4,1,u>, RHS
    1974010880U, // <4,1,u,5>: Cost 2 vtrnl RHS, <1,3,5,7>
    2109915137U, // <4,1,u,6>: Cost 2 ins <4,u,4,6>, lane 1
    1036328961U, // <4,1,u,7>: Cost 1 ins RHS, lane 1
    1055244288U, // <4,1,u,u>: Cost 1 ins LHS, lane 0
    3047786150U, // <4,2,0,0>: Cost 3 vtrnl <4,6,0,2>, <2,3,0,1>
    2109579265U, // <4,2,0,1>: Cost 2 ins <4,u,0,1>, lane 1
    2129494016U, // <4,2,0,2>: Cost 2 ins <u,2,0,2>, lane 0
    2967019622U, // <4,2,0,3>: Cost 3 vzipr <2,3,4,0>, LHS
    2635473244U, // <4,2,0,4>: Cost 3 vext2 <3,0,4,2>, <0,4,2,6>
    2909947747U, // <4,2,0,5>: Cost 3 vzipl <4,0,5,1>, <2,5,3,1>
    2696775148U, // <4,2,0,6>: Cost 3 vext3 <2,0,6,4>, <2,0,6,4>
    2109628417U, // <4,2,0,7>: Cost 2 ins <4,u,0,7>, lane 1
    2129494016U, // <4,2,0,u>: Cost 2 ins <u,2,0,2>, lane 0
    3203293184U, // <4,2,1,0>: Cost 3 ins <u,2,1,0>, lane 0
    3203301376U, // <4,2,1,1>: Cost 3 ins <u,2,1,1>, lane 0
    3203309568U, // <4,2,1,2>: Cost 3 ins <u,2,1,2>, lane 0
    2821242982U, // <4,2,1,3>: Cost 3 vuzpr <0,4,0,2>, LHS
    2691909162U, // <4,2,1,4>: Cost 3 vext3 <1,2,3,4>, <2,1,4,3>
    3203334144U, // <4,2,1,5>: Cost 3 ins <u,2,1,5>, lane 0
    3203342336U, // <4,2,1,6>: Cost 3 ins <u,2,1,6>, lane 0
    2109702145U, // <4,2,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    2109702145U, // <4,2,1,u>: Cost 2 ins <4,u,1,7>, lane 1
    2229208824U, // <4,2,2,0>: Cost 3 vrev <2,4,0,2>
    2911397400U, // <4,2,2,1>: Cost 3 vzipl <4,2,6,7>, <2,1,2,3>
    2129641472U, // <4,2,2,2>: Cost 2 ins <u,2,2,2>, lane 0
    2129649664U, // <4,2,2,3>: Cost 2 ins <u,2,2,3>, lane 0
    2697954940U, // <4,2,2,4>: Cost 3 vext3 <2,2,4,4>, <2,2,4,4>
    2911397764U, // <4,2,2,5>: Cost 3 vzipl <4,2,6,7>, <2,5,6,7>
    2821243084U, // <4,2,2,6>: Cost 3 vuzpr <0,4,0,2>, <0,2,4,6>
    2109775873U, // <4,2,2,7>: Cost 2 ins <4,u,2,7>, lane 1
    2129641472U, // <4,2,2,u>: Cost 2 ins <u,2,2,2>, lane 0
    2129698816U, // <4,2,3,0>: Cost 2 ins <u,2,3,0>, lane 0
    2229290754U, // <4,2,3,1>: Cost 3 vrev <2,4,1,3>
    3203457024U, // <4,2,3,2>: Cost 3 ins <u,2,3,2>, lane 0
    2129723392U, // <4,2,3,3>: Cost 2 ins <u,2,3,3>, lane 0
    2129731584U, // <4,2,3,4>: Cost 2 ins <u,2,3,4>, lane 0
    2833188558U, // <4,2,3,5>: Cost 3 vuzpr <2,4,0,2>, <2,3,4,5>
    3203489792U, // <4,2,3,6>: Cost 3 ins <u,2,3,6>, lane 0
    2109849601U, // <4,2,3,7>: Cost 2 ins <4,u,3,7>, lane 1
    2129698816U, // <4,2,3,u>: Cost 2 ins <u,2,3,0>, lane 0
    2564915302U, // <4,2,4,0>: Cost 3 vext1 <2,4,2,4>, LHS
    2564916122U, // <4,2,4,1>: Cost 3 vext1 <2,4,2,4>, <1,2,3,4>
    1702448074U, // <4,2,4,2>: Cost 2 vuzpl <4,1,2,3>, <4,1,2,3>
    1905918054U, // <4,2,4,3>: Cost 2 vzipr <4,4,4,4>, LHS
    2109898753U, // <4,2,4,4>: Cost 2 ins <4,u,4,4>, lane 1
    2109906945U, // <4,2,4,5>: Cost 2 ins <4,u,4,5>, lane 1
    2129821696U, // <4,2,4,6>: Cost 2 ins <u,2,4,6>, lane 0
    2109923329U, // <4,2,4,7>: Cost 2 ins <4,u,4,7>, lane 1
    2129821696U, // <4,2,4,u>: Cost 2 ins <u,2,4,6>, lane 0
    3089777558U, // <4,2,5,0>: Cost 3 vtrnr <0,4,1,5>, <1,2,3,0>
    2109947905U, // <4,2,5,1>: Cost 2 ins <4,u,5,1>, lane 1
    1839646312U, // <4,2,5,2>: Cost 2 vzipl RHS, <2,2,2,2>
    1893318758U, // <4,2,5,3>: Cost 2 vzipr <2,3,4,5>, LHS
    3089777562U, // <4,2,5,4>: Cost 3 vtrnr <0,4,1,5>, <1,2,3,4>
    2109980673U, // <4,2,5,5>: Cost 2 ins <4,u,5,5>, lane 1
    1839646650U, // <4,2,5,6>: Cost 2 vzipl RHS, <2,6,3,7>
    2109997057U, // <4,2,5,7>: Cost 2 ins <4,u,5,7>, lane 1
    1893318763U, // <4,2,5,u>: Cost 2 vzipr <2,3,4,5>, LHS
    1479246172U, // <4,2,6,0>: Cost 2 vext1 <0,4,2,6>, <0,4,2,6>
    2110021633U, // <4,2,6,1>: Cost 2 ins <4,u,6,1>, lane 1
    1973864040U, // <4,2,6,2>: Cost 2 vtrnl RHS, <2,2,2,2>
    1880719462U, // <4,2,6,3>: Cost 2 vzipr <0,2,4,6>, LHS
    1479249206U, // <4,2,6,4>: Cost 2 vext1 <0,4,2,6>, RHS
    2110054401U, // <4,2,6,5>: Cost 2 ins <4,u,6,5>, lane 1
    2110062593U, // <4,2,6,6>: Cost 2 ins <4,u,6,6>, lane 1
    1036328961U, // <4,2,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,2,6,u>: Cost 1 ins RHS, lane 1
    2659365909U, // <4,2,7,0>: Cost 3 vext2 <7,0,4,2>, <7,0,4,2>
    3203743744U, // <4,2,7,1>: Cost 3 ins <u,2,7,1>, lane 0
    3203751936U, // <4,2,7,2>: Cost 3 ins <u,2,7,2>, lane 0
    2130018304U, // <4,2,7,3>: Cost 2 ins <u,2,7,3>, lane 0
    3102032794U, // <4,2,7,4>: Cost 3 vtrnr <2,4,5,7>, <1,2,3,4>
    2229618474U, // <4,2,7,5>: Cost 3 vrev <2,4,5,7>
    3203784704U, // <4,2,7,6>: Cost 3 ins <u,2,7,6>, lane 0
    2110144513U, // <4,2,7,7>: Cost 2 ins <4,u,7,7>, lane 1
    2130018304U, // <4,2,7,u>: Cost 2 ins <u,2,7,3>, lane 0
    1479262558U, // <4,2,u,0>: Cost 2 vext1 <0,4,2,u>, <0,4,2,u>
    2109947905U, // <4,2,u,1>: Cost 2 ins <4,u,5,1>, lane 1
    1974011496U, // <4,2,u,2>: Cost 2 vtrnl RHS, <2,2,2,2>
    1880735846U, // <4,2,u,3>: Cost 2 vzipr <0,2,4,u>, LHS
    1479265590U, // <4,2,u,4>: Cost 2 vext1 <0,4,2,u>, RHS
    2109980673U, // <4,2,u,5>: Cost 2 ins <4,u,5,5>, lane 1
    1841637306U, // <4,2,u,6>: Cost 2 vzipl RHS, <2,6,3,7>
    1036328961U, // <4,2,u,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,2,u,u>: Cost 1 ins RHS, lane 1
    3203883008U, // <4,3,0,0>: Cost 3 ins <u,3,0,0>, lane 0
    2130149376U, // <4,3,0,1>: Cost 2 ins <u,3,0,1>, lane 0
    2109587457U, // <4,3,0,2>: Cost 2 ins <4,u,0,2>, lane 1
    3047786908U, // <4,3,0,3>: Cost 3 vtrnl <4,6,0,2>, <3,3,3,3>
    2967020442U, // <4,3,0,4>: Cost 3 vzipr <2,3,4,0>, <1,2,3,4>
    2235533820U, // <4,3,0,5>: Cost 3 vrev <3,4,5,0>
    3183362049U, // <4,3,0,6>: Cost 3 ins <4,u,0,6>, lane 1
    2109628417U, // <4,3,0,7>: Cost 2 ins <4,u,0,7>, lane 1
    2130149376U, // <4,3,0,u>: Cost 2 ins <u,3,0,1>, lane 0
    2235173328U, // <4,3,1,0>: Cost 3 vrev <3,4,0,1>
    3203964928U, // <4,3,1,1>: Cost 3 ins <u,3,1,1>, lane 0
    2630173594U, // <4,3,1,2>: Cost 3 vext2 <2,1,4,3>, <1,2,3,4>
    2130239488U, // <4,3,1,3>: Cost 2 ins <u,3,1,3>, lane 0
    2967028634U, // <4,3,1,4>: Cost 3 vzipr <2,3,4,1>, <1,2,3,4>
    3203997696U, // <4,3,1,5>: Cost 3 ins <u,3,1,5>, lane 0
    2821398633U, // <4,3,1,6>: Cost 3 vuzpr <0,4,2,3>, <0,1,2,6>
    2109702145U, // <4,3,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    2130239488U, // <4,3,1,u>: Cost 2 ins <u,3,1,3>, lane 0
    3204030464U, // <4,3,2,0>: Cost 3 ins <u,3,2,0>, lane 0
    2630174250U, // <4,3,2,1>: Cost 3 vext2 <2,1,4,3>, <2,1,4,3>
    3204046848U, // <4,3,2,2>: Cost 3 ins <u,3,2,2>, lane 0
    2130313216U, // <4,3,2,3>: Cost 2 ins <u,3,2,3>, lane 0
    2833269658U, // <4,3,2,4>: Cost 3 vuzpr <2,4,1,3>, <1,2,3,4>
    3101624014U, // <4,3,2,5>: Cost 3 vtrnr <2,4,0,2>, <2,3,4,5>
    3204079616U, // <4,3,2,6>: Cost 3 ins <u,3,2,6>, lane 0
    2109775873U, // <4,3,2,7>: Cost 2 ins <4,u,2,7>, lane 1
    2130313216U, // <4,3,2,u>: Cost 2 ins <u,3,2,3>, lane 0
    3204104192U, // <4,3,3,0>: Cost 3 ins <u,3,3,0>, lane 0
    2779564182U, // <4,3,3,1>: Cost 3 vuzpl <4,6,3,1>, <3,0,1,2>
    2636810580U, // <4,3,3,2>: Cost 3 vext2 <3,2,4,3>, <3,2,4,3>
    2130386944U, // <4,3,3,3>: Cost 2 ins <u,3,3,3>, lane 0
    2965717914U, // <4,3,3,4>: Cost 3 vzipr <2,1,4,3>, <1,2,3,4>
    2779597314U, // <4,3,3,5>: Cost 3 vuzpl <4,6,3,5>, <3,4,5,6>
    2778950237U, // <4,3,3,6>: Cost 3 vuzpl <4,5,3,7>, <3,5,6,7>
    2109849601U, // <4,3,3,7>: Cost 2 ins <4,u,3,7>, lane 1
    2130386944U, // <4,3,3,u>: Cost 2 ins <u,3,3,3>, lane 0
    2691910096U, // <4,3,4,0>: Cost 3 vext3 <1,2,3,4>, <3,4,0,1>
    2691910106U, // <4,3,4,1>: Cost 3 vext3 <1,2,3,4>, <3,4,1,2>
    3183624193U, // <4,3,4,2>: Cost 3 ins <4,u,4,2>, lane 1
    1747657049U, // <4,3,4,3>: Cost 2 vuzpr <0,4,2,3>, <0,4,2,3>
    2109898753U, // <4,3,4,4>: Cost 2 ins <4,u,4,4>, lane 1
    2130477056U, // <4,3,4,5>: Cost 2 ins <u,3,4,5>, lane 0
    2109915137U, // <4,3,4,6>: Cost 2 ins <4,u,4,6>, lane 1
    2109923329U, // <4,3,4,7>: Cost 2 ins <4,u,4,7>, lane 1
    2130477056U, // <4,3,4,u>: Cost 2 ins <u,3,4,5>, lane 0
    1839646870U, // <4,3,5,0>: Cost 2 vzipl RHS, <3,0,1,2>
    2109947905U, // <4,3,5,1>: Cost 2 ins <4,u,5,1>, lane 1
    2967061238U, // <4,3,5,2>: Cost 3 vzipr <2,3,4,5>, <1,0,3,2>
    1839647132U, // <4,3,5,3>: Cost 2 vzipl RHS, <3,3,3,3>
    1839647234U, // <4,3,5,4>: Cost 2 vzipl RHS, <3,4,5,6>
    2109980673U, // <4,3,5,5>: Cost 2 ins <4,u,5,5>, lane 1
    2913389176U, // <4,3,5,6>: Cost 3 vzipl RHS, <3,6,0,7>
    2130567168U, // <4,3,5,7>: Cost 2 ins <u,3,5,7>, lane 0
    1839647518U, // <4,3,5,u>: Cost 2 vzipl RHS, <3,u,1,2>
    2110013441U, // <4,3,6,0>: Cost 2 ins <4,u,6,0>, lane 1
    1973864598U, // <4,3,6,1>: Cost 2 vtrnl RHS, <3,0,1,2>
    2110029825U, // <4,3,6,2>: Cost 2 ins <4,u,6,2>, lane 1
    1973864860U, // <4,3,6,3>: Cost 2 vtrnl RHS, <3,3,3,3>
    2110046209U, // <4,3,6,4>: Cost 2 ins <4,u,6,4>, lane 1
    1161841154U, // <4,3,6,5>: Cost 2 vrev <3,4,5,6>
    2110062593U, // <4,3,6,6>: Cost 2 ins <4,u,6,6>, lane 1
    1036328961U, // <4,3,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,3,6,u>: Cost 1 ins RHS, lane 1
    3204399104U, // <4,3,7,0>: Cost 3 ins <u,3,7,0>, lane 0
    3204407296U, // <4,3,7,1>: Cost 3 ins <u,3,7,1>, lane 0
    2660701368U, // <4,3,7,2>: Cost 3 vext2 <7,2,4,3>, <7,2,4,3>
    3204423680U, // <4,3,7,3>: Cost 3 ins <u,3,7,3>, lane 0
    2968404890U, // <4,3,7,4>: Cost 3 vzipr <2,5,4,7>, <1,2,3,4>
    3204440064U, // <4,3,7,5>: Cost 3 ins <u,3,7,5>, lane 0
    2235664908U, // <4,3,7,6>: Cost 3 vrev <3,4,6,7>
    2110144513U, // <4,3,7,7>: Cost 2 ins <4,u,7,7>, lane 1
    2110144513U, // <4,3,7,u>: Cost 2 ins <4,u,7,7>, lane 1
    1841637526U, // <4,3,u,0>: Cost 2 vzipl RHS, <3,0,1,2>
    1974012054U, // <4,3,u,1>: Cost 2 vtrnl RHS, <3,0,1,2>
    2109587457U, // <4,3,u,2>: Cost 2 ins <4,u,0,2>, lane 1
    1974012316U, // <4,3,u,3>: Cost 2 vtrnl RHS, <3,3,3,3>
    1841637890U, // <4,3,u,4>: Cost 2 vzipl RHS, <3,4,5,6>
    1161857540U, // <4,3,u,5>: Cost 2 vrev <3,4,5,u>
    2109915137U, // <4,3,u,6>: Cost 2 ins <4,u,4,6>, lane 1
    1036328961U, // <4,3,u,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,3,u,u>: Cost 1 ins RHS, lane 1
    1974046028U, // <4,4,0,0>: Cost 2 vtrnl <4,6,0,2>, <4,6,0,2>
    2107572229U, // <4,4,0,1>: Cost 2 ins <4,4,u,u>, lane 5
    1705934950U, // <4,4,0,2>: Cost 2 vuzpl <4,6,4,6>, LHS
    3180724227U, // <4,4,0,3>: Cost 3 ins <4,4,0,u>, lane 3
    2107539458U, // <4,4,0,4>: Cost 2 ins <4,4,u,4>, lane 2
    2107547650U, // <4,4,0,5>: Cost 2 ins <4,4,u,5>, lane 2
    1974046006U, // <4,4,0,6>: Cost 2 vtrnl <4,6,0,2>, RHS
    2109628417U, // <4,4,0,7>: Cost 2 ins <4,u,0,7>, lane 1
    1974046024U, // <4,4,0,u>: Cost 2 vtrnl <4,6,0,2>, RHS
    3204620288U, // <4,4,1,0>: Cost 3 ins <u,4,1,0>, lane 0
    1836665802U, // <4,4,1,1>: Cost 2 vzipl <4,1,2,3>, <4,1,2,3>
    2691910602U, // <4,4,1,2>: Cost 3 vext3 <1,2,3,4>, <4,1,2,3>
    1771700326U, // <4,4,1,3>: Cost 2 vuzpr <4,4,4,4>, LHS
    2107539458U, // <4,4,1,4>: Cost 2 ins <4,4,u,4>, lane 2
    2130919424U, // <4,4,1,5>: Cost 2 ins <u,4,1,5>, lane 0
    2107555842U, // <4,4,1,6>: Cost 2 ins <4,4,u,6>, lane 2
    2109702145U, // <4,4,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    2130919424U, // <4,4,1,u>: Cost 2 ins <u,4,1,5>, lane 0
    2779678374U, // <4,4,2,0>: Cost 3 vuzpl <4,6,4,6>, <2,3,0,1>
    3044625673U, // <4,4,2,1>: Cost 3 vtrnl <4,1,2,3>, <4,5,1,7>
    1970883530U, // <4,4,2,2>: Cost 2 vtrnl <4,1,2,3>, <4,1,2,3>
    2107572229U, // <4,4,2,3>: Cost 2 ins <4,4,u,u>, lane 5
    2107539458U, // <4,4,2,4>: Cost 2 ins <4,4,u,4>, lane 2
    2107547650U, // <4,4,2,5>: Cost 2 ins <4,4,u,5>, lane 2
    2131001344U, // <4,4,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    2109775873U, // <4,4,2,7>: Cost 2 ins <4,u,2,7>, lane 1
    2107572229U, // <4,4,2,u>: Cost 2 ins <4,4,u,u>, lane 5
    3181248514U, // <4,4,3,0>: Cost 3 ins <4,4,u,0>, lane 2
    2779678870U, // <4,4,3,1>: Cost 3 vuzpl <4,6,4,6>, <3,0,1,2>
    3181264898U, // <4,4,3,2>: Cost 3 ins <4,4,u,2>, lane 2
    1880031352U, // <4,4,3,3>: Cost 2 vzipr <0,1,4,3>, <0,1,4,3>
    2107539458U, // <4,4,3,4>: Cost 2 ins <4,4,u,4>, lane 2
    2107547650U, // <4,4,3,5>: Cost 2 ins <4,4,u,5>, lane 2
    2107555842U, // <4,4,3,6>: Cost 2 ins <4,4,u,6>, lane 2
    2109849601U, // <4,4,3,7>: Cost 2 ins <4,u,3,7>, lane 1
    2107547650U, // <4,4,3,u>: Cost 2 ins <4,4,u,5>, lane 2
    1503264870U, // <4,4,4,0>: Cost 2 vext1 <4,4,4,4>, LHS
    2107277315U, // <4,4,4,1>: Cost 2 ins <4,4,4,u>, lane 3
    2107277315U, // <4,4,4,2>: Cost 2 ins <4,4,4,u>, lane 3
    2107277315U, // <4,4,4,3>: Cost 2 ins <4,4,4,u>, lane 3
    161926454U,  // <4,4,4,4>: Cost 1 vdup0 RHS
    2107547650U, // <4,4,4,5>: Cost 2 ins <4,4,u,5>, lane 2
    1705938230U, // <4,4,4,6>: Cost 2 vuzpl <4,6,4,6>, RHS
    2109923329U, // <4,4,4,7>: Cost 2 ins <4,u,4,7>, lane 1
    161926454U,  // <4,4,4,u>: Cost 1 vdup0 RHS
    1839647634U, // <4,4,5,0>: Cost 2 vzipl RHS, <4,0,5,1>
    2109947905U, // <4,4,5,1>: Cost 2 ins <4,u,5,1>, lane 1
    2107351043U, // <4,4,5,2>: Cost 2 ins <4,4,5,u>, lane 3
    2107351043U, // <4,4,5,3>: Cost 2 ins <4,4,5,u>, lane 3
    1839647952U, // <4,4,5,4>: Cost 2 vzipl RHS, <4,4,4,4>
    765906230U,  // <4,4,5,5>: Cost 1 vzipl RHS, RHS
    1618169142U, // <4,4,5,6>: Cost 2 vext3 <1,2,3,4>, RHS
    2107351043U, // <4,4,5,7>: Cost 2 ins <4,4,5,u>, lane 3
    765906473U,  // <4,4,5,u>: Cost 1 vzipl RHS, RHS
    1973865804U, // <4,4,6,0>: Cost 2 vtrnl RHS, <4,6,0,2>
    2107424771U, // <4,4,6,1>: Cost 2 ins <4,4,6,u>, lane 3
    2110029825U, // <4,4,6,2>: Cost 2 ins <4,u,6,2>, lane 1
    2107424771U, // <4,4,6,3>: Cost 2 ins <4,4,6,u>, lane 3
    1973865680U, // <4,4,6,4>: Cost 2 vtrnl RHS, <4,4,4,4>
    1973865362U, // <4,4,6,5>: Cost 2 vtrnl RHS, <4,0,5,1>
    900123958U,  // <4,4,6,6>: Cost 1 vtrnl RHS, RHS
    1036328961U, // <4,4,6,7>: Cost 1 ins RHS, lane 1
    900123976U,  // <4,4,6,u>: Cost 1 vtrnl RHS, RHS
    3181248514U, // <4,4,7,0>: Cost 3 ins <4,4,u,0>, lane 2
    2779681786U, // <4,4,7,1>: Cost 3 vuzpl <4,6,4,6>, <7,0,1,2>
    3181264898U, // <4,4,7,2>: Cost 3 ins <4,4,u,2>, lane 2
    2845442636U, // <4,4,7,3>: Cost 3 vuzpr <4,4,4,4>, <0,7,2,3>
    2107539458U, // <4,4,7,4>: Cost 2 ins <4,4,u,4>, lane 2
    2107547650U, // <4,4,7,5>: Cost 2 ins <4,4,u,5>, lane 2
    2131369984U, // <4,4,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    2040311013U, // <4,4,7,7>: Cost 2 vtrnr <4,4,6,7>, <4,4,6,7>
    2107547650U, // <4,4,7,u>: Cost 2 ins <4,4,u,5>, lane 2
    1974013260U, // <4,4,u,0>: Cost 2 vtrnl RHS, <4,6,0,2>
    2107572229U, // <4,4,u,1>: Cost 2 ins <4,4,u,u>, lane 5
    1705940782U, // <4,4,u,2>: Cost 2 vuzpl <4,6,4,6>, LHS
    2107572229U, // <4,4,u,3>: Cost 2 ins <4,4,u,u>, lane 5
    161926454U,  // <4,4,u,4>: Cost 1 vdup0 RHS
    767896886U,  // <4,4,u,5>: Cost 1 vzipl RHS, RHS
    900271414U,  // <4,4,u,6>: Cost 1 vtrnl RHS, RHS
    1036328961U, // <4,4,u,7>: Cost 1 ins RHS, lane 1
    900271432U,  // <4,4,u,u>: Cost 1 vtrnl RHS, RHS
    2108170242U, // <4,5,0,0>: Cost 2 ins <4,5,u,0>, lane 2
    1034493957U, // <4,5,0,1>: Cost 1 ins RHS, lane 5
    1707294822U, // <4,5,0,2>: Cost 2 vuzpl <4,u,5,1>, LHS
    2108194818U, // <4,5,0,3>: Cost 2 ins <4,5,u,3>, lane 2
    2108203010U, // <4,5,0,4>: Cost 2 ins <4,5,u,4>, lane 2
    2108211202U, // <4,5,0,5>: Cost 2 ins <4,5,u,5>, lane 2
    2108219394U, // <4,5,0,6>: Cost 2 ins <4,5,u,6>, lane 2
    1034485762U, // <4,5,0,7>: Cost 1 ins RHS, lane 2
    1034493957U, // <4,5,0,u>: Cost 1 ins RHS, lane 5
    2108170242U, // <4,5,1,0>: Cost 2 ins <4,5,u,0>, lane 2
    2133540868U, // <4,5,1,1>: Cost 2 ins <u,u,1,1>, lane 4
    2133549060U, // <4,5,1,2>: Cost 2 ins <u,u,1,2>, lane 4
    1747599462U, // <4,5,1,3>: Cost 2 vuzpr <0,4,1,5>, LHS
    2108203010U, // <4,5,1,4>: Cost 2 ins <4,5,u,4>, lane 2
    2133573636U, // <4,5,1,5>: Cost 2 ins <u,u,1,5>, lane 4
    2108219394U, // <4,5,1,6>: Cost 2 ins <4,5,u,6>, lane 2
    1034485762U, // <4,5,1,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <4,5,1,u>: Cost 1 ins RHS, lane 2
    2108170242U, // <4,5,2,0>: Cost 2 ins <4,5,u,0>, lane 2
    2108178434U, // <4,5,2,1>: Cost 2 ins <4,5,u,1>, lane 2
    2133622788U, // <4,5,2,2>: Cost 2 ins <u,u,2,2>, lane 4
    1059889156U, // <4,5,2,3>: Cost 1 ins LHS, lane 4
    2108203010U, // <4,5,2,4>: Cost 2 ins <4,5,u,4>, lane 2
    2108211202U, // <4,5,2,5>: Cost 2 ins <4,5,u,5>, lane 2
    2133655556U, // <4,5,2,6>: Cost 2 ins <u,u,2,6>, lane 4
    1034485762U, // <4,5,2,7>: Cost 1 ins RHS, lane 2
    1059889156U, // <4,5,2,u>: Cost 1 ins LHS, lane 4
    2133680132U, // <4,5,3,0>: Cost 2 ins <u,u,3,0>, lane 4
    2108178434U, // <4,5,3,1>: Cost 2 ins <4,5,u,1>, lane 2
    2133696516U, // <4,5,3,2>: Cost 2 ins <u,u,3,2>, lane 4
    2133704708U, // <4,5,3,3>: Cost 2 ins <u,u,3,3>, lane 4
    2133712900U, // <4,5,3,4>: Cost 2 ins <u,u,3,4>, lane 4
    2108211202U, // <4,5,3,5>: Cost 2 ins <4,5,u,5>, lane 2
    2108219394U, // <4,5,3,6>: Cost 2 ins <4,5,u,6>, lane 2
    1034485762U, // <4,5,3,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <4,5,3,u>: Cost 1 ins RHS, lane 2
    2108170242U, // <4,5,4,0>: Cost 2 ins <4,5,u,0>, lane 2
    2108178434U, // <4,5,4,1>: Cost 2 ins <4,5,u,1>, lane 2
    2108186626U, // <4,5,4,2>: Cost 2 ins <4,5,u,2>, lane 2
    2108194818U, // <4,5,4,3>: Cost 2 ins <4,5,u,3>, lane 2
    2109898753U, // <4,5,4,4>: Cost 2 ins <4,u,4,4>, lane 1
    1034493957U, // <4,5,4,5>: Cost 1 ins RHS, lane 5
    1707298102U, // <4,5,4,6>: Cost 2 vuzpl <4,u,5,1>, RHS
    1034485762U, // <4,5,4,7>: Cost 1 ins RHS, lane 2
    1034493957U, // <4,5,4,u>: Cost 1 ins RHS, lane 5
    1503346790U, // <4,5,5,0>: Cost 2 vext1 <4,4,5,5>, LHS
    1839656656U, // <4,5,5,1>: Cost 2 vzipl RHS, <5,1,7,3>
    2108186626U, // <4,5,5,2>: Cost 2 ins <4,5,u,2>, lane 2
    2108194818U, // <4,5,5,3>: Cost 2 ins <4,5,u,3>, lane 2
    1839648710U, // <4,5,5,4>: Cost 2 vzipl RHS, <5,4,7,6>
    1839648772U, // <4,5,5,5>: Cost 2 vzipl RHS, <5,5,5,5>
    1839648866U, // <4,5,5,6>: Cost 2 vzipl RHS, <5,6,7,0>
    1034485762U, // <4,5,5,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <4,5,5,u>: Cost 1 ins RHS, lane 2
    1034346499U, // <4,5,6,0>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,5,6,1>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,5,6,2>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,5,6,3>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,5,6,4>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,5,6,5>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,5,6,6>: Cost 1 ins RHS, lane 3
    27705344U,   // <4,5,6,7>: Cost 0 copy RHS
    27705344U,   // <4,5,6,u>: Cost 0 copy RHS
    2133975044U, // <4,5,7,0>: Cost 2 ins <u,u,7,0>, lane 4
    2108178434U, // <4,5,7,1>: Cost 2 ins <4,5,u,1>, lane 2
    2108186626U, // <4,5,7,2>: Cost 2 ins <4,5,u,2>, lane 2
    2133999620U, // <4,5,7,3>: Cost 2 ins <u,u,7,3>, lane 4
    2134007812U, // <4,5,7,4>: Cost 2 ins <u,u,7,4>, lane 4
    2108211202U, // <4,5,7,5>: Cost 2 ins <4,5,u,5>, lane 2
    2134024196U, // <4,5,7,6>: Cost 2 ins <u,u,7,6>, lane 4
    1034485762U, // <4,5,7,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <4,5,7,u>: Cost 1 ins RHS, lane 2
    1034346499U, // <4,5,u,0>: Cost 1 ins RHS, lane 3
    1034493957U, // <4,5,u,1>: Cost 1 ins RHS, lane 5
    1034346499U, // <4,5,u,2>: Cost 1 ins RHS, lane 3
    1059889156U, // <4,5,u,3>: Cost 1 ins LHS, lane 4
    1034346499U, // <4,5,u,4>: Cost 1 ins RHS, lane 3
    1034493957U, // <4,5,u,5>: Cost 1 ins RHS, lane 5
    1034346499U, // <4,5,u,6>: Cost 1 ins RHS, lane 3
    27705344U,   // <4,5,u,7>: Cost 0 copy RHS
    27705344U,   // <4,5,u,u>: Cost 0 copy RHS
    1705426944U, // <4,6,0,0>: Cost 2 vuzpl RHS, <0,0,0,0>
    1545175142U, // <4,6,0,1>: Cost 2 vext2 <0,2,4,6>, LHS
    631685222U,  // <4,6,0,2>: Cost 1 vuzpl RHS, LHS
    2108309507U, // <4,6,0,3>: Cost 2 ins <4,6,0,u>, lane 3
    1705427148U, // <4,6,0,4>: Cost 2 vuzpl RHS, <0,2,4,6>
    2108309507U, // <4,6,0,5>: Cost 2 ins <4,6,0,u>, lane 3
    2108882946U, // <4,6,0,6>: Cost 2 ins <4,6,u,6>, lane 2
    2108309507U, // <4,6,0,7>: Cost 2 ins <4,6,0,u>, lane 3
    631685276U,  // <4,6,0,u>: Cost 1 vuzpl RHS, LHS
    2618917622U, // <4,6,1,0>: Cost 3 vext2 <0,2,4,6>, <1,0,3,2>
    1705427764U, // <4,6,1,1>: Cost 2 vuzpl RHS, <1,1,1,1>
    2108850178U, // <4,6,1,2>: Cost 2 ins <4,6,u,2>, lane 2
    1747681382U, // <4,6,1,3>: Cost 2 vuzpr <0,4,2,6>, LHS
    2779169619U, // <4,6,1,4>: Cost 3 vuzpl RHS, <1,1,4,5>
    1705427968U, // <4,6,1,5>: Cost 2 vuzpl RHS, <1,3,5,7>
    2108882946U, // <4,6,1,6>: Cost 2 ins <4,6,u,6>, lane 2
    2109702145U, // <4,6,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    1747681387U, // <4,6,1,u>: Cost 2 vuzpr <0,4,2,6>, LHS
    1705428646U, // <4,6,2,0>: Cost 2 vuzpl RHS, <2,3,0,1>
    2779170237U, // <4,6,2,1>: Cost 3 vuzpl RHS, <2,0,1,2>
    1705428584U, // <4,6,2,2>: Cost 2 vuzpl RHS, <2,2,2,2>
    1705428594U, // <4,6,2,3>: Cost 2 vuzpl RHS, <2,2,3,3>
    1705428686U, // <4,6,2,4>: Cost 2 vuzpl RHS, <2,3,4,5>
    2839560386U, // <4,6,2,5>: Cost 3 vuzpr <3,4,5,6>, <0,2,3,5>
    2108882946U, // <4,6,2,6>: Cost 2 ins <4,6,u,6>, lane 2
    2109775873U, // <4,6,2,7>: Cost 2 ins <4,u,2,7>, lane 1
    1705428639U, // <4,6,2,u>: Cost 2 vuzpl RHS, <2,2,u,3>
    2618919062U, // <4,6,3,0>: Cost 3 vext2 <0,2,4,6>, <3,0,1,2>
    1705429142U, // <4,6,3,1>: Cost 2 vuzpl RHS, <3,0,1,2>
    2108850178U, // <4,6,3,2>: Cost 2 ins <4,6,u,2>, lane 2
    1705429404U, // <4,6,3,3>: Cost 2 vuzpl RHS, <3,3,3,3>
    2618919426U, // <4,6,3,4>: Cost 3 vext2 <0,2,4,6>, <3,4,5,6>
    1705429506U, // <4,6,3,5>: Cost 2 vuzpl RHS, <3,4,5,6>
    2108882946U, // <4,6,3,6>: Cost 2 ins <4,6,u,6>, lane 2
    2132410368U, // <4,6,3,7>: Cost 2 ins <u,6,3,7>, lane 0
    1705429205U, // <4,6,3,u>: Cost 2 vuzpl RHS, <3,0,u,2>
    1705430348U, // <4,6,4,0>: Cost 2 vuzpl RHS, <4,6,0,2>
    2108604419U, // <4,6,4,1>: Cost 2 ins <4,6,4,u>, lane 3
    2108850178U, // <4,6,4,2>: Cost 2 ins <4,6,u,2>, lane 2
    2108604419U, // <4,6,4,3>: Cost 2 ins <4,6,4,u>, lane 3
    1705430224U, // <4,6,4,4>: Cost 2 vuzpl RHS, <4,4,4,4>
    1545178422U, // <4,6,4,5>: Cost 2 vext2 <0,2,4,6>, RHS
    631688502U,  // <4,6,4,6>: Cost 1 vuzpl RHS, RHS
    2108604419U, // <4,6,4,7>: Cost 2 ins <4,6,4,u>, lane 3
    631688520U,  // <4,6,4,u>: Cost 1 vuzpl RHS, RHS
    2839563567U, // <4,6,5,0>: Cost 3 vuzpr <3,4,5,6>, <4,5,6,0>
    1705439360U, // <4,6,5,1>: Cost 2 vuzpl RHS, <5,7,1,3>
    1839657466U, // <4,6,5,2>: Cost 2 vzipl RHS, <6,2,7,3>
    2839563570U, // <4,6,5,3>: Cost 3 vuzpr <3,4,5,6>, <4,5,6,3>
    2839563571U, // <4,6,5,4>: Cost 3 vuzpr <3,4,5,6>, <4,5,6,4>
    1705431044U, // <4,6,5,5>: Cost 2 vuzpl RHS, <5,5,5,5>
    1839649592U, // <4,6,5,6>: Cost 2 vzipl RHS, <6,6,6,6>
    1747684662U, // <4,6,5,7>: Cost 2 vuzpr <0,4,2,6>, RHS
    1747684663U, // <4,6,5,u>: Cost 2 vuzpr <0,4,2,6>, RHS
    1705431886U, // <4,6,6,0>: Cost 2 vuzpl RHS, <6,7,0,1>
    2110021633U, // <4,6,6,1>: Cost 2 ins <4,u,6,1>, lane 1
    2110029825U, // <4,6,6,2>: Cost 2 ins <4,u,6,2>, lane 1
    2110038017U, // <4,6,6,3>: Cost 2 ins <4,u,6,3>, lane 1
    1705431926U, // <4,6,6,4>: Cost 2 vuzpl RHS, <6,7,4,5>
    2110054401U, // <4,6,6,5>: Cost 2 ins <4,u,6,5>, lane 1
    1705431864U, // <4,6,6,6>: Cost 2 vuzpl RHS, <6,6,6,6>
    1036328961U, // <4,6,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,6,6,u>: Cost 1 ins RHS, lane 1
    2132647936U, // <4,6,7,0>: Cost 2 ins <u,6,7,0>, lane 0
    1705432058U, // <4,6,7,1>: Cost 2 vuzpl RHS, <7,0,1,2>
    2108850178U, // <4,6,7,2>: Cost 2 ins <4,6,u,2>, lane 2
    2779173980U, // <4,6,7,3>: Cost 3 vuzpl RHS, <7,1,3,1>
    2132680704U, // <4,6,7,4>: Cost 2 ins <u,6,7,4>, lane 0
    1705432422U, // <4,6,7,5>: Cost 2 vuzpl RHS, <7,4,5,6>
    2108882946U, // <4,6,7,6>: Cost 2 ins <4,6,u,6>, lane 2
    1705432684U, // <4,6,7,7>: Cost 2 vuzpl RHS, <7,7,7,7>
    1705432121U, // <4,6,7,u>: Cost 2 vuzpl RHS, <7,0,u,2>
    1705433020U, // <4,6,u,0>: Cost 2 vuzpl RHS, <u,3,0,1>
    1545180974U, // <4,6,u,1>: Cost 2 vext2 <0,2,4,6>, LHS
    631691054U,  // <4,6,u,2>: Cost 1 vuzpl RHS, LHS
    1747681949U, // <4,6,u,3>: Cost 2 vuzpr <0,4,2,6>, LHS
    1705433060U, // <4,6,u,4>: Cost 2 vuzpl RHS, <u,3,4,5>
    1545181338U, // <4,6,u,5>: Cost 2 vext2 <0,2,4,6>, RHS
    631691418U,  // <4,6,u,6>: Cost 1 vuzpl RHS, RHS
    1036328961U, // <4,6,u,7>: Cost 1 ins RHS, lane 1
    631691108U,  // <4,6,u,u>: Cost 1 vuzpl RHS, LHS
    3206537216U, // <4,7,0,0>: Cost 3 ins <u,7,0,0>, lane 0
    2132803584U, // <4,7,0,1>: Cost 2 ins <u,7,0,1>, lane 0
    2109587457U, // <4,7,0,2>: Cost 2 ins <4,u,0,2>, lane 1
    2845614101U, // <4,7,0,3>: Cost 3 vuzpr <4,4,6,7>, <0,0,2,3>
    3206569984U, // <4,7,0,4>: Cost 3 ins <u,7,0,4>, lane 0
    3047789926U, // <4,7,0,5>: Cost 3 vtrnl <4,6,0,2>, <7,4,5,6>
    3047789929U, // <4,7,0,6>: Cost 3 vtrnl <4,6,0,2>, <7,4,6,0>
    2109628417U, // <4,7,0,7>: Cost 2 ins <4,u,0,7>, lane 1
    2132803584U, // <4,7,0,u>: Cost 2 ins <u,7,0,1>, lane 0
    2259064116U, // <4,7,1,0>: Cost 3 vrev <7,4,0,1>
    3206619136U, // <4,7,1,1>: Cost 3 ins <u,7,1,1>, lane 0
    2632860570U, // <4,7,1,2>: Cost 3 vext2 <2,5,4,7>, <1,2,3,4>
    2132893696U, // <4,7,1,3>: Cost 2 ins <u,7,1,3>, lane 0
    3206643712U, // <4,7,1,4>: Cost 3 ins <u,7,1,4>, lane 0
    3206651904U, // <4,7,1,5>: Cost 3 ins <u,7,1,5>, lane 0
    2988265414U, // <4,7,1,6>: Cost 3 vzipr <5,u,4,1>, <5,4,7,6>
    2109702145U, // <4,7,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    2132893696U, // <4,7,1,u>: Cost 2 ins <u,7,1,3>, lane 0
    3206684672U, // <4,7,2,0>: Cost 3 ins <u,7,2,0>, lane 0
    3206692864U, // <4,7,2,1>: Cost 3 ins <u,7,2,1>, lane 0
    3206701056U, // <4,7,2,2>: Cost 3 ins <u,7,2,2>, lane 0
    2132967424U, // <4,7,2,3>: Cost 2 ins <u,7,2,3>, lane 0
    2833597338U, // <4,7,2,4>: Cost 3 vuzpr <2,4,5,7>, <1,2,3,4>
    2632861554U, // <4,7,2,5>: Cost 3 vext2 <2,5,4,7>, <2,5,4,7>
    3206733824U, // <4,7,2,6>: Cost 3 ins <u,7,2,6>, lane 0
    2109775873U, // <4,7,2,7>: Cost 2 ins <4,u,2,7>, lane 1
    2132967424U, // <4,7,2,u>: Cost 2 ins <u,7,2,3>, lane 0
    3206758400U, // <4,7,3,0>: Cost 3 ins <u,7,3,0>, lane 0
    3206766592U, // <4,7,3,1>: Cost 3 ins <u,7,3,1>, lane 0
    3047388245U, // <4,7,3,2>: Cost 3 vtrnl <4,5,3,7>, <7,1,2,3>
    3206782976U, // <4,7,3,3>: Cost 3 ins <u,7,3,3>, lane 0
    2989609062U, // <4,7,3,4>: Cost 3 vzipr <6,1,4,3>, <5,6,7,4>
    3206799360U, // <4,7,3,5>: Cost 3 ins <u,7,3,5>, lane 0
    2639497884U, // <4,7,3,6>: Cost 3 vext2 <3,6,4,7>, <3,6,4,7>
    2109849601U, // <4,7,3,7>: Cost 2 ins <4,u,3,7>, lane 1
    2109849601U, // <4,7,3,u>: Cost 2 ins <4,u,3,7>, lane 1
    2583199846U, // <4,7,4,0>: Cost 3 vext1 <5,4,7,4>, LHS
    3048117242U, // <4,7,4,1>: Cost 3 vtrnl <4,6,4,6>, <7,0,1,2>
    3183624193U, // <4,7,4,2>: Cost 3 ins <4,u,4,2>, lane 1
    2979659923U, // <4,7,4,3>: Cost 3 vzipr <4,4,4,4>, <0,1,7,3>
    2109898753U, // <4,7,4,4>: Cost 2 ins <4,u,4,4>, lane 1
    2133131264U, // <4,7,4,5>: Cost 2 ins <u,7,4,5>, lane 0
    2109915137U, // <4,7,4,6>: Cost 2 ins <4,u,4,6>, lane 1
    1771875557U, // <4,7,4,7>: Cost 2 vuzpr <4,4,6,7>, <4,4,6,7>
    2133131264U, // <4,7,4,u>: Cost 2 ins <u,7,4,5>, lane 0
    1839649786U, // <4,7,5,0>: Cost 2 vzipl RHS, <7,0,1,2>
    2109947905U, // <4,7,5,1>: Cost 2 ins <4,u,5,1>, lane 1
    2913391781U, // <4,7,5,2>: Cost 3 vzipl RHS, <7,2,2,2>
    2913391843U, // <4,7,5,3>: Cost 3 vzipl RHS, <7,3,0,1>
    1839650150U, // <4,7,5,4>: Cost 2 vzipl RHS, <7,4,5,6>
    2109980673U, // <4,7,5,5>: Cost 2 ins <4,u,5,5>, lane 1
    2913392145U, // <4,7,5,6>: Cost 3 vzipl RHS, <7,6,6,6>
    1839650412U, // <4,7,5,7>: Cost 2 vzipl RHS, <7,7,7,7>
    1839650434U, // <4,7,5,u>: Cost 2 vzipl RHS, <7,u,1,2>
    1509474406U, // <4,7,6,0>: Cost 2 vext1 <5,4,7,6>, LHS
    1973867514U, // <4,7,6,1>: Cost 2 vtrnl RHS, <7,0,1,2>
    2110029825U, // <4,7,6,2>: Cost 2 ins <4,u,6,2>, lane 1
    2110038017U, // <4,7,6,3>: Cost 2 ins <4,u,6,3>, lane 1
    1509477686U, // <4,7,6,4>: Cost 2 vext1 <5,4,7,6>, RHS
    1973867878U, // <4,7,6,5>: Cost 2 vtrnl RHS, <7,4,5,6>
    2110062593U, // <4,7,6,6>: Cost 2 ins <4,u,6,6>, lane 1
    1036328961U, // <4,7,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,7,6,u>: Cost 1 ins RHS, lane 1
    2914587642U, // <4,7,7,0>: Cost 3 vzipl <4,7,5,0>, <7,0,1,2>
    2779862010U, // <4,7,7,1>: Cost 3 vuzpl <4,6,7,1>, <7,0,1,2>
    2779247701U, // <4,7,7,2>: Cost 3 vuzpl <4,5,7,7>, <7,1,2,3>
    3207077888U, // <4,7,7,3>: Cost 3 ins <u,7,7,3>, lane 0
    2914620774U, // <4,7,7,4>: Cost 3 vzipl <4,7,5,4>, <7,4,5,6>
    2779895142U, // <4,7,7,5>: Cost 3 vuzpl <4,6,7,5>, <7,4,5,6>
    2992295878U, // <4,7,7,6>: Cost 3 vzipr <6,5,4,7>, <5,4,7,6>
    2133368832U, // <4,7,7,7>: Cost 2 ins <u,7,7,7>, lane 0
    2133368832U, // <4,7,7,u>: Cost 2 ins <u,7,7,7>, lane 0
    1841640442U, // <4,7,u,0>: Cost 2 vzipl RHS, <7,0,1,2>
    1974014970U, // <4,7,u,1>: Cost 2 vtrnl RHS, <7,0,1,2>
    2109587457U, // <4,7,u,2>: Cost 2 ins <4,u,0,2>, lane 1
    2132893696U, // <4,7,u,3>: Cost 2 ins <u,7,1,3>, lane 0
    1841640806U, // <4,7,u,4>: Cost 2 vzipl RHS, <7,4,5,6>
    1974015334U, // <4,7,u,5>: Cost 2 vtrnl RHS, <7,4,5,6>
    2109915137U, // <4,7,u,6>: Cost 2 ins <4,u,4,6>, lane 1
    1036328961U, // <4,7,u,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <4,7,u,u>: Cost 1 ins RHS, lane 1
    1705574400U, // <4,u,0,0>: Cost 2 vuzpl RHS, <0,0,0,0>
    1034493957U, // <4,u,0,1>: Cost 1 ins RHS, lane 5
    631832678U,  // <4,u,0,2>: Cost 1 vuzpl RHS, LHS
    2108309507U, // <4,u,0,3>: Cost 2 ins <4,6,0,u>, lane 3
    1705574604U, // <4,u,0,4>: Cost 2 vuzpl RHS, <0,2,4,6>
    2107547650U, // <4,u,0,5>: Cost 2 ins <4,4,u,5>, lane 2
    1974048922U, // <4,u,0,6>: Cost 2 vtrnl <4,6,0,2>, RHS
    1034485762U, // <4,u,0,7>: Cost 1 ins RHS, lane 2
    631832732U,  // <4,u,0,u>: Cost 1 vuzpl RHS, LHS
    2108170242U, // <4,u,1,0>: Cost 2 ins <4,5,u,0>, lane 2
    1705575220U, // <4,u,1,1>: Cost 2 vuzpl RHS, <1,1,1,1>
    1618171694U, // <4,u,1,2>: Cost 2 vext3 <1,2,3,4>, LHS
    1747624038U, // <4,u,1,3>: Cost 2 vuzpr <0,4,1,u>, LHS
    2107539458U, // <4,u,1,4>: Cost 2 ins <4,4,u,4>, lane 2
    1705575424U, // <4,u,1,5>: Cost 2 vuzpl RHS, <1,3,5,7>
    2107555842U, // <4,u,1,6>: Cost 2 ins <4,4,u,6>, lane 2
    1034485762U, // <4,u,1,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <4,u,1,u>: Cost 1 ins RHS, lane 2
    1705576102U, // <4,u,2,0>: Cost 2 vuzpl RHS, <2,3,0,1>
    2104860674U, // <4,u,2,1>: Cost 2 ins <4,0,u,1>, lane 2
    1705576040U, // <4,u,2,2>: Cost 2 vuzpl RHS, <2,2,2,2>
    1055244288U, // <4,u,2,3>: Cost 1 ins LHS, lane 0
    1705576142U, // <4,u,2,4>: Cost 2 vuzpl RHS, <2,3,4,5>
    2107547650U, // <4,u,2,5>: Cost 2 ins <4,4,u,5>, lane 2
    2131001344U, // <4,u,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    1034485762U, // <4,u,2,7>: Cost 1 ins RHS, lane 2
    1055244288U, // <4,u,2,u>: Cost 1 ins LHS, lane 0
    2129698816U, // <4,u,3,0>: Cost 2 ins <u,2,3,0>, lane 0
    1705576598U, // <4,u,3,1>: Cost 2 vuzpl RHS, <3,0,1,2>
    2128388096U, // <4,u,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    1705576860U, // <4,u,3,3>: Cost 2 vuzpl RHS, <3,3,3,3>
    2129731584U, // <4,u,3,4>: Cost 2 ins <u,2,3,4>, lane 0
    1705576962U, // <4,u,3,5>: Cost 2 vuzpl RHS, <3,4,5,6>
    2107555842U, // <4,u,3,6>: Cost 2 ins <4,4,u,6>, lane 2
    1034485762U, // <4,u,3,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <4,u,3,u>: Cost 1 ins RHS, lane 2
    1705577804U, // <4,u,4,0>: Cost 2 vuzpl RHS, <4,6,0,2>
    2104860674U, // <4,u,4,1>: Cost 2 ins <4,0,u,1>, lane 2
    1974376238U, // <4,u,4,2>: Cost 2 vtrnl <4,6,4,6>, LHS
    2108604419U, // <4,u,4,3>: Cost 2 ins <4,6,4,u>, lane 3
    161926454U,  // <4,u,4,4>: Cost 1 vdup0 RHS
    1034493957U, // <4,u,4,5>: Cost 1 ins RHS, lane 5
    631835958U,  // <4,u,4,6>: Cost 1 vuzpl RHS, RHS
    1034485762U, // <4,u,4,7>: Cost 1 ins RHS, lane 2
    631835976U,  // <4,u,4,u>: Cost 1 vuzpl RHS, RHS
    1839650515U, // <4,u,5,0>: Cost 2 vzipl RHS, <u,0,1,2>
    765908782U,  // <4,u,5,1>: Cost 1 vzipl RHS, LHS
    1839650693U, // <4,u,5,2>: Cost 2 vzipl RHS, <u,2,3,0>
    2016035485U, // <4,u,5,3>: Cost 2 vtrnr <0,4,1,5>, LHS
    1839650879U, // <4,u,5,4>: Cost 2 vzipl RHS, <u,4,5,6>
    765909146U,  // <4,u,5,5>: Cost 1 vzipl RHS, RHS
    1618172058U, // <4,u,5,6>: Cost 2 vext3 <1,2,3,4>, RHS
    1034485762U, // <4,u,5,7>: Cost 1 ins RHS, lane 2
    765909349U,  // <4,u,5,u>: Cost 1 vzipl RHS, LHS
    1034346499U, // <4,u,6,0>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,u,6,1>: Cost 1 ins RHS, lane 3
    900126510U,  // <4,u,6,2>: Cost 1 vtrnl RHS, LHS
    1034346499U, // <4,u,6,3>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,u,6,4>: Cost 1 ins RHS, lane 3
    1034346499U, // <4,u,6,5>: Cost 1 ins RHS, lane 3
    900126874U,  // <4,u,6,6>: Cost 1 vtrnl RHS, RHS
    27705344U,   // <4,u,6,7>: Cost 0 copy RHS
    27705344U,   // <4,u,6,u>: Cost 0 copy RHS
    2133975044U, // <4,u,7,0>: Cost 2 ins <u,u,7,0>, lane 4
    1705579514U, // <4,u,7,1>: Cost 2 vuzpl RHS, <7,0,1,2>
    2104868866U, // <4,u,7,2>: Cost 2 ins <4,0,u,2>, lane 2
    2129354752U, // <4,u,7,3>: Cost 2 ins <u,1,7,3>, lane 0
    2134007812U, // <4,u,7,4>: Cost 2 ins <u,u,7,4>, lane 4
    1705579878U, // <4,u,7,5>: Cost 2 vuzpl RHS, <7,4,5,6>
    2131369984U, // <4,u,7,6>: Cost 2 ins <u,4,7,6>, lane 0
    1034485762U, // <4,u,7,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <4,u,7,u>: Cost 1 ins RHS, lane 2
    1034346499U, // <4,u,u,0>: Cost 1 ins RHS, lane 3
    767899438U,  // <4,u,u,1>: Cost 1 vzipl RHS, LHS
    631838510U,  // <4,u,u,2>: Cost 1 vuzpl RHS, LHS
    1055244288U, // <4,u,u,3>: Cost 1 ins LHS, lane 0
    161926454U,  // <4,u,u,4>: Cost 1 vdup0 RHS
    767899802U,  // <4,u,u,5>: Cost 1 vzipl RHS, RHS
    631838874U,  // <4,u,u,6>: Cost 1 vuzpl RHS, RHS
    27705344U,   // <4,u,u,7>: Cost 0 copy RHS
    27705344U,   // <4,u,u,u>: Cost 0 copy RHS
    2128150528U, // <5,0,0,0>: Cost 2 ins <u,0,0,0>, lane 0
    2687123466U, // <5,0,0,1>: Cost 3 vext3 <0,4,1,5>, <0,0,1,1>
    2687123476U, // <5,0,0,2>: Cost 3 vext3 <0,4,1,5>, <0,0,2,2>
    2846220309U, // <5,0,0,3>: Cost 3 vuzpr <4,5,6,0>, <0,0,2,3>
    2642166098U, // <5,0,0,4>: Cost 3 vext2 <4,1,5,0>, <0,4,1,5>
    2583318482U, // <5,0,0,5>: Cost 3 vext1 <5,5,0,0>, <5,5,0,0>
    3189334017U, // <5,0,0,6>: Cost 3 ins <5,u,0,6>, lane 1
    2846223265U, // <5,0,0,7>: Cost 3 vuzpr <4,5,6,0>, <4,0,6,7>
    2128150528U, // <5,0,0,u>: Cost 2 ins <u,0,0,0>, lane 0
    1503608934U, // <5,0,1,0>: Cost 2 vext1 <4,5,0,1>, LHS
    1843003494U, // <5,0,1,1>: Cost 2 vzipl <5,1,7,3>, LHS
    1613381734U, // <5,0,1,2>: Cost 2 vext3 <0,4,1,5>, LHS
    2115641345U, // <5,0,1,3>: Cost 2 ins <5,u,1,3>, lane 1
    1611612282U, // <5,0,1,4>: Cost 2 vext3 <0,1,4,5>, <0,1,4,5>
    2583326675U, // <5,0,1,5>: Cost 3 vext1 <5,5,0,1>, <5,5,0,1>
    3202015232U, // <5,0,1,6>: Cost 3 ins <u,0,1,6>, lane 0
    3189415937U, // <5,0,1,7>: Cost 3 ins <5,u,1,7>, lane 1
    1613381788U, // <5,0,1,u>: Cost 2 vext3 <0,4,1,5>, LHS
    2686017700U, // <5,0,2,0>: Cost 3 vext3 <0,2,4,5>, <0,2,0,2>
    2685796528U, // <5,0,2,1>: Cost 3 vext3 <0,2,1,5>, <0,2,1,5>
    2128314368U, // <5,0,2,2>: Cost 2 ins <u,0,2,2>, lane 0
    2128322560U, // <5,0,2,3>: Cost 2 ins <u,0,2,3>, lane 0
    2686017739U, // <5,0,2,4>: Cost 3 vext3 <0,2,4,5>, <0,2,4,5>
    2686091476U, // <5,0,2,5>: Cost 3 vext3 <0,2,5,5>, <0,2,5,5>
    3189481473U, // <5,0,2,6>: Cost 3 ins <5,u,2,6>, lane 1
    2595280262U, // <5,0,2,7>: Cost 3 vext1 <7,5,0,2>, <7,5,0,2>
    2128314368U, // <5,0,2,u>: Cost 2 ins <u,0,2,2>, lane 0
    3202113536U, // <5,0,3,0>: Cost 3 ins <u,0,3,0>, lane 0
    2918047846U, // <5,0,3,1>: Cost 3 vzipl <5,3,7,0>, LHS
    2128388096U, // <5,0,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    3189530625U, // <5,0,3,3>: Cost 3 ins <5,u,3,3>, lane 1
    2638187004U, // <5,0,3,4>: Cost 3 vext2 <3,4,5,0>, <3,4,5,0>
    2785315330U, // <5,0,3,5>: Cost 3 vuzpl <5,6,0,1>, <3,4,5,6>
    3202162688U, // <5,0,3,6>: Cost 3 ins <u,0,3,6>, lane 0
    2840323072U, // <5,0,3,7>: Cost 3 vuzpr <3,5,7,0>, <1,3,5,7>
    2128388096U, // <5,0,3,u>: Cost 2 ins <u,0,3,2>, lane 0
    2559459430U, // <5,0,4,0>: Cost 3 vext1 <1,5,0,4>, LHS
    1613381970U, // <5,0,4,1>: Cost 2 vext3 <0,4,1,5>, <0,4,1,5>
    2687123804U, // <5,0,4,2>: Cost 3 vext3 <0,4,1,5>, <0,4,2,6>
    3184336899U, // <5,0,4,3>: Cost 3 ins <5,0,4,u>, lane 3
    2687345005U, // <5,0,4,4>: Cost 3 vext3 <0,4,4,5>, <0,4,4,5>
    2638187830U, // <5,0,4,5>: Cost 3 vext2 <3,4,5,0>, RHS
    2846222850U, // <5,0,4,6>: Cost 3 vuzpr <4,5,6,0>, <3,4,5,6>
    2646150600U, // <5,0,4,7>: Cost 3 vext2 <4,7,5,0>, <4,7,5,0>
    1845019293U, // <5,0,4,u>: Cost 2 vzipl <5,4,7,6>, LHS
    1772481839U, // <5,0,5,0>: Cost 2 vuzpr <4,5,6,0>, <4,5,6,0>
    1845526630U, // <5,0,5,1>: Cost 2 vzipl <5,5,5,5>, LHS
    1979744358U, // <5,0,5,2>: Cost 2 vtrnl <5,5,5,5>, LHS
    3189678081U, // <5,0,5,3>: Cost 3 ins <5,u,5,3>, lane 1
    2919268690U, // <5,0,5,4>: Cost 3 vzipl <5,5,5,5>, <0,4,1,5>
    2115952641U, // <5,0,5,5>: Cost 2 ins <5,u,5,5>, lane 1
    3202310144U, // <5,0,5,6>: Cost 3 ins <u,0,5,6>, lane 0
    2115969025U, // <5,0,5,7>: Cost 2 ins <5,u,5,7>, lane 1
    1845527197U, // <5,0,5,u>: Cost 2 vzipl <5,5,5,5>, LHS
    2973777920U, // <5,0,6,0>: Cost 3 vzipr <3,4,5,6>, <0,0,0,0>
    1846296678U, // <5,0,6,1>: Cost 2 vzipl <5,6,7,0>, LHS
    2128609280U, // <5,0,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    3189751809U, // <5,0,6,3>: Cost 3 ins <5,u,6,3>, lane 1
    2920038738U, // <5,0,6,4>: Cost 3 vzipl <5,6,7,0>, <0,4,1,5>
    2920038866U, // <5,0,6,5>: Cost 3 vzipl <5,6,7,0>, <0,5,6,7>
    3189776385U, // <5,0,6,6>: Cost 3 ins <5,u,6,6>, lane 1
    2128650240U, // <5,0,6,7>: Cost 2 ins <u,0,6,7>, lane 0
    1846297245U, // <5,0,6,u>: Cost 2 vzipl <5,6,7,0>, LHS
    2040971264U, // <5,0,7,0>: Cost 2 vtrnr RHS, <0,0,0,0>
    2040971274U, // <5,0,7,1>: Cost 2 vtrnr RHS, <0,0,1,1>
    2040971284U, // <5,0,7,2>: Cost 2 vtrnr RHS, <0,0,2,2>
    2116083713U, // <5,0,7,3>: Cost 2 ins <5,u,7,3>, lane 1
    2116091905U, // <5,0,7,4>: Cost 2 ins <5,u,7,4>, lane 1
    3114715316U, // <5,0,7,5>: Cost 3 vtrnr RHS, <3,0,4,5>
    2116108289U, // <5,0,7,6>: Cost 2 ins <5,u,7,6>, lane 1
    2116116481U, // <5,0,7,7>: Cost 2 ins <5,u,7,7>, lane 1
    2040971281U, // <5,0,7,u>: Cost 2 vtrnr RHS, <0,0,1,u>
    2040979456U, // <5,0,u,0>: Cost 2 vtrnr RHS, <0,0,0,0>
    1616036502U, // <5,0,u,1>: Cost 2 vext3 <0,u,1,5>, <0,u,1,5>
    1613382301U, // <5,0,u,2>: Cost 2 vext3 <0,4,1,5>, LHS
    2115641345U, // <5,0,u,3>: Cost 2 ins <5,u,1,3>, lane 1
    2116091905U, // <5,0,u,4>: Cost 2 ins <5,u,7,4>, lane 1
    2115952641U, // <5,0,u,5>: Cost 2 ins <5,u,5,5>, lane 1
    2116108289U, // <5,0,u,6>: Cost 2 ins <5,u,7,6>, lane 1
    2115969025U, // <5,0,u,7>: Cost 2 ins <5,u,5,7>, lane 1
    1613382355U, // <5,0,u,u>: Cost 2 vext3 <0,4,1,5>, LHS
    2646818816U, // <5,1,0,0>: Cost 3 vext2 <4,u,5,1>, <0,0,0,0>
    1573077094U, // <5,1,0,1>: Cost 2 vext2 <4,u,5,1>, LHS
    1712324710U, // <5,1,0,2>: Cost 2 vuzpl <5,7,1,3>, LHS
    2111512578U, // <5,1,0,3>: Cost 2 ins <5,1,u,3>, lane 2
    2641510738U, // <5,1,0,4>: Cost 3 vext2 <4,0,5,1>, <0,4,1,5>
    2977710418U, // <5,1,0,5>: Cost 3 vzipr <4,1,5,0>, <0,4,1,5>
    3185278978U, // <5,1,0,6>: Cost 3 ins <5,1,u,6>, lane 2
    3184705539U, // <5,1,0,7>: Cost 3 ins <5,1,0,u>, lane 3
    1573077661U, // <5,1,0,u>: Cost 2 vext2 <4,u,5,1>, LHS
    2223891567U, // <5,1,1,0>: Cost 3 vrev <1,5,0,1>
    2128896000U, // <5,1,1,1>: Cost 2 ins <u,1,1,1>, lane 0
    2646819734U, // <5,1,1,2>: Cost 3 vext2 <4,u,5,1>, <1,2,3,0>
    2115641345U, // <5,1,1,3>: Cost 2 ins <5,u,1,3>, lane 1
    2691326803U, // <5,1,1,4>: Cost 3 vext3 <1,1,4,5>, <1,1,4,5>
    2691400540U, // <5,1,1,5>: Cost 3 vext3 <1,1,5,5>, <1,1,5,5>
    3189407745U, // <5,1,1,6>: Cost 3 ins <5,u,1,6>, lane 1
    2982367283U, // <5,1,1,7>: Cost 3 vzipr <4,u,5,1>, <5,6,1,7>
    2115641345U, // <5,1,1,u>: Cost 2 ins <5,u,1,3>, lane 1
    2128961536U, // <5,1,2,0>: Cost 2 ins <u,1,2,0>, lane 0
    2128969728U, // <5,1,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    2128977920U, // <5,1,2,2>: Cost 2 ins <u,1,2,2>, lane 0
    1055244288U, // <5,1,2,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <5,1,2,4>: Cost 2 ins <u,1,2,4>, lane 0
    2129002496U, // <5,1,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2129010688U, // <5,1,2,6>: Cost 2 ins <u,1,2,6>, lane 0
    2129018880U, // <5,1,2,7>: Cost 2 ins <u,1,2,7>, lane 0
    1055244288U, // <5,1,2,u>: Cost 1 ins LHS, lane 0
    2571468902U, // <5,1,3,0>: Cost 3 vext1 <3,5,1,3>, LHS
    2687124440U, // <5,1,3,1>: Cost 3 vext3 <0,4,1,5>, <1,3,1,3>
    2571470542U, // <5,1,3,2>: Cost 3 vext1 <3,5,1,3>, <2,3,4,5>
    2129059840U, // <5,1,3,3>: Cost 2 ins <u,1,3,3>, lane 0
    2687124469U, // <5,1,3,4>: Cost 3 vext3 <0,4,1,5>, <1,3,4,5>
    2685207552U, // <5,1,3,5>: Cost 3 vext3 <0,1,2,5>, <1,3,5,7>
    2595361654U, // <5,1,3,6>: Cost 3 vext1 <7,5,1,3>, <6,7,4,5>
    2840331264U, // <5,1,3,7>: Cost 3 vuzpr <3,5,7,1>, <1,3,5,7>
    2129059840U, // <5,1,3,u>: Cost 2 ins <u,1,3,3>, lane 0
    1567771538U, // <5,1,4,0>: Cost 2 vext2 <4,0,5,1>, <4,0,5,1>
    2693096491U, // <5,1,4,1>: Cost 3 vext3 <1,4,1,5>, <1,4,1,5>
    2693170228U, // <5,1,4,2>: Cost 3 vext3 <1,4,2,5>, <1,4,2,5>
    2111512578U, // <5,1,4,3>: Cost 2 ins <5,1,u,3>, lane 2
    2646822096U, // <5,1,4,4>: Cost 3 vext2 <4,u,5,1>, <4,4,4,4>
    1573080374U, // <5,1,4,5>: Cost 2 vext2 <4,u,5,1>, RHS
    1712327990U, // <5,1,4,6>: Cost 2 vuzpl <5,7,1,3>, RHS
    3185000451U, // <5,1,4,7>: Cost 3 ins <5,1,4,u>, lane 3
    1573080602U, // <5,1,4,u>: Cost 2 vext2 <4,u,5,1>, <4,u,5,1>
    2687124591U, // <5,1,5,0>: Cost 3 vext3 <0,4,1,5>, <1,5,0,1>
    1712328832U, // <5,1,5,1>: Cost 2 vuzpl <5,7,1,3>, <5,7,1,3>
    2982398102U, // <5,1,5,2>: Cost 3 vzipr <4,u,5,5>, <3,0,1,2>
    2046853222U, // <5,1,5,3>: Cost 2 vtrnr <5,5,5,5>, LHS
    2687124631U, // <5,1,5,4>: Cost 3 vext3 <0,4,1,5>, <1,5,4,5>
    2115952641U, // <5,1,5,5>: Cost 2 ins <5,u,5,5>, lane 1
    2646823010U, // <5,1,5,6>: Cost 3 vext2 <4,u,5,1>, <5,6,7,0>
    2115969025U, // <5,1,5,7>: Cost 2 ins <5,u,5,7>, lane 1
    2046853227U, // <5,1,5,u>: Cost 2 vtrnr <5,5,5,5>, LHS
    2920039158U, // <5,1,6,0>: Cost 3 vzipl <5,6,7,0>, <1,0,3,2>
    2961834642U, // <5,1,6,1>: Cost 3 vzipr <1,4,5,6>, <0,u,1,1>
    2973780118U, // <5,1,6,2>: Cost 3 vzipr <3,4,5,6>, <3,0,1,2>
    2111512578U, // <5,1,6,3>: Cost 2 ins <5,1,u,3>, lane 2
    2224227480U, // <5,1,6,4>: Cost 3 vrev <1,5,4,6>
    2973778258U, // <5,1,6,5>: Cost 3 vzipr <3,4,5,6>, <0,4,1,5>
    2646823736U, // <5,1,6,6>: Cost 3 vext2 <4,u,5,1>, <6,6,6,6>
    2111553541U, // <5,1,6,7>: Cost 2 ins <5,1,u,u>, lane 5
    2111512578U, // <5,1,6,u>: Cost 2 ins <5,1,u,3>, lane 2
    2116059137U, // <5,1,7,0>: Cost 2 ins <5,u,7,0>, lane 1
    2040972084U, // <5,1,7,1>: Cost 2 vtrnr RHS, <1,1,1,1>
    2111479811U, // <5,1,7,2>: Cost 2 ins <5,1,7,u>, lane 3
    967229542U,  // <5,1,7,3>: Cost 1 vtrnr RHS, LHS
    2116091905U, // <5,1,7,4>: Cost 2 ins <5,u,7,4>, lane 1
    2111479811U, // <5,1,7,5>: Cost 2 ins <5,1,7,u>, lane 3
    2116108289U, // <5,1,7,6>: Cost 2 ins <5,u,7,6>, lane 1
    2116116481U, // <5,1,7,7>: Cost 2 ins <5,u,7,7>, lane 1
    967229547U,  // <5,1,7,u>: Cost 1 vtrnr RHS, LHS
    2116059137U, // <5,1,u,0>: Cost 2 ins <5,u,7,0>, lane 1
    2040980276U, // <5,1,u,1>: Cost 2 vtrnr RHS, <1,1,1,1>
    1712330542U, // <5,1,u,2>: Cost 2 vuzpl <5,7,1,3>, LHS
    967237734U,  // <5,1,u,3>: Cost 1 vtrnr RHS, LHS
    2116091905U, // <5,1,u,4>: Cost 2 ins <5,u,7,4>, lane 1
    1573083290U, // <5,1,u,5>: Cost 2 vext2 <4,u,5,1>, RHS
    1712330906U, // <5,1,u,6>: Cost 2 vuzpl <5,7,1,3>, RHS
    2115969025U, // <5,1,u,7>: Cost 2 ins <5,u,5,7>, lane 1
    967237739U,  // <5,1,u,u>: Cost 1 vtrnr RHS, LHS
    2786132132U, // <5,2,0,0>: Cost 3 vuzpl <5,7,2,2>, <0,2,0,2>
    2628911206U, // <5,2,0,1>: Cost 3 vext2 <1,u,5,2>, LHS
    2129494016U, // <5,2,0,2>: Cost 2 ins <u,2,0,2>, lane 0
    2973728870U, // <5,2,0,3>: Cost 3 vzipr <3,4,5,0>, LHS
    2786164940U, // <5,2,0,4>: Cost 3 vuzpl <5,7,2,6>, <0,2,4,6>
    2782158977U, // <5,2,0,5>: Cost 3 vuzpl <5,1,2,3>, <0,1,5,3>
    3185942530U, // <5,2,0,6>: Cost 3 ins <5,2,u,6>, lane 2
    3114658883U, // <5,2,0,7>: Cost 3 vtrnr <4,5,6,0>, <4,2,6,7>
    2129494016U, // <5,2,0,u>: Cost 2 ins <u,2,0,2>, lane 0
    3054503590U, // <5,2,1,0>: Cost 3 vtrnl <5,7,1,3>, <2,3,0,1>
    3203301376U, // <5,2,1,1>: Cost 3 ins <u,2,1,1>, lane 0
    2982363156U, // <5,2,1,2>: Cost 3 vzipr <4,u,5,1>, <0,0,2,2>
    1908621414U, // <5,2,1,3>: Cost 2 vzipr <4,u,5,1>, LHS
    3054503630U, // <5,2,1,4>: Cost 3 vtrnl <5,7,1,3>, <2,3,4,5>
    2601390208U, // <5,2,1,5>: Cost 3 vext1 <u,5,2,1>, <5,7,1,3>
    2982363484U, // <5,2,1,6>: Cost 3 vzipr <4,u,5,1>, <0,4,2,6>
    3189415937U, // <5,2,1,7>: Cost 3 ins <5,u,1,7>, lane 1
    1908621419U, // <5,2,1,u>: Cost 2 vzipr <4,u,5,1>, LHS
    3203366912U, // <5,2,2,0>: Cost 3 ins <u,2,2,0>, lane 0
    3203375104U, // <5,2,2,1>: Cost 3 ins <u,2,2,1>, lane 0
    2129641472U, // <5,2,2,2>: Cost 2 ins <u,2,2,2>, lane 0
    2129649664U, // <5,2,2,3>: Cost 2 ins <u,2,2,3>, lane 0
    2697963133U, // <5,2,2,4>: Cost 3 vext3 <2,2,4,5>, <2,2,4,5>
    2698036870U, // <5,2,2,5>: Cost 3 vext3 <2,2,5,5>, <2,2,5,5>
    3189481473U, // <5,2,2,6>: Cost 3 ins <5,u,2,6>, lane 1
    2846239811U, // <5,2,2,7>: Cost 3 vuzpr <4,5,6,2>, <4,2,6,7>
    2129641472U, // <5,2,2,u>: Cost 2 ins <u,2,2,2>, lane 0
    2129698816U, // <5,2,3,0>: Cost 2 ins <u,2,3,0>, lane 0
    2698405555U, // <5,2,3,1>: Cost 3 vext3 <2,3,1,5>, <2,3,1,5>
    2577516238U, // <5,2,3,2>: Cost 3 vext1 <4,5,2,3>, <2,3,4,5>
    2129723392U, // <5,2,3,3>: Cost 2 ins <u,2,3,3>, lane 0
    1624884942U, // <5,2,3,4>: Cost 2 vext3 <2,3,4,5>, <2,3,4,5>
    2717943511U, // <5,2,3,5>: Cost 3 vext3 <5,5,5,5>, <2,3,5,5>
    3203489792U, // <5,2,3,6>: Cost 3 ins <u,2,3,6>, lane 0
    2827879424U, // <5,2,3,7>: Cost 3 vuzpr <1,5,0,2>, <1,3,5,7>
    1625179890U, // <5,2,3,u>: Cost 2 vext3 <2,3,u,5>, <2,3,u,5>
    3203514368U, // <5,2,4,0>: Cost 3 ins <u,2,4,0>, lane 0
    3189587969U, // <5,2,4,1>: Cost 3 ins <5,u,4,1>, lane 1
    2699142925U, // <5,2,4,2>: Cost 3 vext3 <2,4,2,5>, <2,4,2,5>
    2698626838U, // <5,2,4,3>: Cost 3 vext3 <2,3,4,5>, <2,4,3,5>
    3203547136U, // <5,2,4,4>: Cost 3 ins <u,2,4,4>, lane 0
    2628914486U, // <5,2,4,5>: Cost 3 vext2 <1,u,5,2>, RHS
    2129821696U, // <5,2,4,6>: Cost 2 ins <u,2,4,6>, lane 0
    2846239973U, // <5,2,4,7>: Cost 3 vuzpr <4,5,6,2>, <4,4,6,7>
    2129821696U, // <5,2,4,u>: Cost 2 ins <u,2,4,6>, lane 0
    3053487782U, // <5,2,5,0>: Cost 3 vtrnl <5,5,5,5>, <2,3,0,1>
    3203596288U, // <5,2,5,1>: Cost 3 ins <u,2,5,1>, lane 0
    1772498225U, // <5,2,5,2>: Cost 2 vuzpr <4,5,6,2>, <4,5,6,2>
    1908654182U, // <5,2,5,3>: Cost 2 vzipr <4,u,5,5>, LHS
    3053487822U, // <5,2,5,4>: Cost 3 vtrnl <5,5,5,5>, <2,3,4,5>
    2115952641U, // <5,2,5,5>: Cost 2 ins <5,u,5,5>, lane 1
    2982396252U, // <5,2,5,6>: Cost 3 vzipr <4,u,5,5>, <0,4,2,6>
    2115969025U, // <5,2,5,7>: Cost 2 ins <5,u,5,7>, lane 1
    1908654187U, // <5,2,5,u>: Cost 2 vzipr <4,u,5,5>, LHS
    3203661824U, // <5,2,6,0>: Cost 3 ins <u,2,6,0>, lane 0
    3189735425U, // <5,2,6,1>: Cost 3 ins <5,u,6,1>, lane 1
    2973777940U, // <5,2,6,2>: Cost 3 vzipr <3,4,5,6>, <0,0,2,2>
    1900036198U, // <5,2,6,3>: Cost 2 vzipr <3,4,5,6>, LHS
    2700617665U, // <5,2,6,4>: Cost 3 vext3 <2,6,4,5>, <2,6,4,5>
    2973778186U, // <5,2,6,5>: Cost 3 vzipr <3,4,5,6>, <0,3,2,5>
    2973778268U, // <5,2,6,6>: Cost 3 vzipr <3,4,5,6>, <0,4,2,6>
    2129977344U, // <5,2,6,7>: Cost 2 ins <u,2,6,7>, lane 0
    1900036203U, // <5,2,6,u>: Cost 2 vzipr <3,4,5,6>, LHS
    2040972182U, // <5,2,7,0>: Cost 2 vtrnr RHS, <1,2,3,0>
    3114713251U, // <5,2,7,1>: Cost 3 vtrnr RHS, <0,2,0,1>
    2040971428U, // <5,2,7,2>: Cost 2 vtrnr RHS, <0,2,0,2>
    1887436902U, // <5,2,7,3>: Cost 2 vzipr <1,3,5,7>, LHS
    2040972186U, // <5,2,7,4>: Cost 2 vtrnr RHS, <1,2,3,4>
    2961178728U, // <5,2,7,5>: Cost 3 vzipr <1,3,5,7>, <0,1,2,5>
    2040971468U, // <5,2,7,6>: Cost 2 vtrnr RHS, <0,2,4,6>
    2116116481U, // <5,2,7,7>: Cost 2 ins <5,u,7,7>, lane 1
    1887436907U, // <5,2,7,u>: Cost 2 vzipr <1,3,5,7>, LHS
    2040980374U, // <5,2,u,0>: Cost 2 vtrnr RHS, <1,2,3,0>
    2628917038U, // <5,2,u,1>: Cost 3 vext2 <1,u,5,2>, LHS
    2040979620U, // <5,2,u,2>: Cost 2 vtrnr RHS, <0,2,0,2>
    1887445094U, // <5,2,u,3>: Cost 2 vzipr <1,3,5,u>, LHS
    1628203107U, // <5,2,u,4>: Cost 2 vext3 <2,u,4,5>, <2,u,4,5>
    2115952641U, // <5,2,u,5>: Cost 2 ins <5,u,5,5>, lane 1
    2040979660U, // <5,2,u,6>: Cost 2 vtrnr RHS, <0,2,4,6>
    2115969025U, // <5,2,u,7>: Cost 2 ins <5,u,5,7>, lane 1
    1887445099U, // <5,2,u,u>: Cost 2 vzipr <1,3,5,u>, LHS
    3203883008U, // <5,3,0,0>: Cost 3 ins <u,3,0,0>, lane 0
    2130149376U, // <5,3,0,1>: Cost 2 ins <u,3,0,1>, lane 0
    2782904422U, // <5,3,0,2>: Cost 3 vuzpl <5,2,3,4>, LHS
    3186581506U, // <5,3,0,3>: Cost 3 ins <5,3,u,3>, lane 2
    2687125680U, // <5,3,0,4>: Cost 3 vext3 <0,4,1,5>, <3,0,4,1>
    3053750786U, // <5,3,0,5>: Cost 3 vtrnl <5,6,0,1>, <3,4,5,6>
    2618302971U, // <5,3,0,6>: Cost 3 vext2 <0,1,5,3>, <0,6,2,3>
    2236344927U, // <5,3,0,7>: Cost 3 vrev <3,5,7,0>
    2130149376U, // <5,3,0,u>: Cost 2 ins <u,3,0,1>, lane 0
    2982364054U, // <5,3,1,0>: Cost 3 vzipr <4,u,5,1>, <1,2,3,0>
    3054504086U, // <5,3,1,1>: Cost 3 vtrnl <5,7,1,3>, <3,0,1,2>
    2624938923U, // <5,3,1,2>: Cost 3 vext2 <1,2,5,3>, <1,2,5,3>
    2130239488U, // <5,3,1,3>: Cost 2 ins <u,3,1,3>, lane 0
    2982364058U, // <5,3,1,4>: Cost 3 vzipr <4,u,5,1>, <1,2,3,4>
    2636219536U, // <5,3,1,5>: Cost 3 vext2 <3,1,5,3>, <1,5,3,7>
    3189407745U, // <5,3,1,6>: Cost 3 ins <5,u,1,6>, lane 1
    2964448400U, // <5,3,1,7>: Cost 3 vzipr <1,u,5,1>, <1,5,3,7>
    2130239488U, // <5,3,1,u>: Cost 2 ins <u,3,1,3>, lane 0
    2235845154U, // <5,3,2,0>: Cost 3 vrev <3,5,0,2>
    3204038656U, // <5,3,2,1>: Cost 3 ins <u,3,2,1>, lane 0
    3204046848U, // <5,3,2,2>: Cost 3 ins <u,3,2,2>, lane 0
    2130313216U, // <5,3,2,3>: Cost 2 ins <u,3,2,3>, lane 0
    2703935830U, // <5,3,2,4>: Cost 3 vext3 <3,2,4,5>, <3,2,4,5>
    2698627422U, // <5,3,2,5>: Cost 3 vext3 <2,3,4,5>, <3,2,5,4>
    3204079616U, // <5,3,2,6>: Cost 3 ins <u,3,2,6>, lane 0
    3096314880U, // <5,3,2,7>: Cost 3 vtrnr <1,5,0,2>, <1,3,5,7>
    2130313216U, // <5,3,2,u>: Cost 2 ins <u,3,2,3>, lane 0
    3204104192U, // <5,3,3,0>: Cost 3 ins <u,3,3,0>, lane 0
    2636220684U, // <5,3,3,1>: Cost 3 vext2 <3,1,5,3>, <3,1,5,3>
    3204120576U, // <5,3,3,2>: Cost 3 ins <u,3,3,2>, lane 0
    2130386944U, // <5,3,3,3>: Cost 2 ins <u,3,3,3>, lane 0
    2704599463U, // <5,3,3,4>: Cost 3 vext3 <3,3,4,5>, <3,3,4,5>
    2704673200U, // <5,3,3,5>: Cost 3 vext3 <3,3,5,5>, <3,3,5,5>
    3189555201U, // <5,3,3,6>: Cost 3 ins <5,u,3,6>, lane 1
    2971763856U, // <5,3,3,7>: Cost 3 vzipr <3,1,5,3>, <1,5,3,7>
    2130386944U, // <5,3,3,u>: Cost 2 ins <u,3,3,3>, lane 0
    2704968148U, // <5,3,4,0>: Cost 3 vext3 <3,4,0,5>, <3,4,0,5>
    2642193381U, // <5,3,4,1>: Cost 3 vext2 <4,1,5,3>, <4,1,5,3>
    2642857014U, // <5,3,4,2>: Cost 3 vext2 <4,2,5,3>, <4,2,5,3>
    2705189359U, // <5,3,4,3>: Cost 3 vext3 <3,4,3,5>, <3,4,3,5>
    2705263096U, // <5,3,4,4>: Cost 3 vext3 <3,4,4,5>, <3,4,4,5>
    2130477056U, // <5,3,4,5>: Cost 2 ins <u,3,4,5>, lane 0
    2846247426U, // <5,3,4,6>: Cost 3 vuzpr <4,5,6,3>, <3,4,5,6>
    2236377699U, // <5,3,4,7>: Cost 3 vrev <3,5,7,4>
    2130477056U, // <5,3,4,u>: Cost 2 ins <u,3,4,5>, lane 0
    2571632742U, // <5,3,5,0>: Cost 3 vext1 <3,5,3,5>, LHS
    3053488278U, // <5,3,5,1>: Cost 3 vtrnl <5,5,5,5>, <3,0,1,2>
    2571634382U, // <5,3,5,2>: Cost 3 vext1 <3,5,3,5>, <2,3,4,5>
    1748320682U, // <5,3,5,3>: Cost 2 vuzpr <0,5,2,3>, <0,5,2,3>
    2571636022U, // <5,3,5,4>: Cost 3 vext1 <3,5,3,5>, RHS
    2115952641U, // <5,3,5,5>: Cost 2 ins <5,u,5,5>, lane 1
    3204300800U, // <5,3,5,6>: Cost 3 ins <u,3,5,6>, lane 0
    2130567168U, // <5,3,5,7>: Cost 2 ins <u,3,5,7>, lane 0
    2130567168U, // <5,3,5,u>: Cost 2 ins <u,3,5,7>, lane 0
    2565668966U, // <5,3,6,0>: Cost 3 vext1 <2,5,3,6>, LHS
    3204333568U, // <5,3,6,1>: Cost 3 ins <u,3,6,1>, lane 0
    2565670760U, // <5,3,6,2>: Cost 3 vext1 <2,5,3,6>, <2,5,3,6>
    2565671426U, // <5,3,6,3>: Cost 3 vext1 <2,5,3,6>, <3,4,5,6>
    2565672246U, // <5,3,6,4>: Cost 3 vext1 <2,5,3,6>, RHS
    2973778114U, // <5,3,6,5>: Cost 3 vzipr <3,4,5,6>, <0,2,3,5>
    2973779816U, // <5,3,6,6>: Cost 3 vzipr <3,4,5,6>, <2,5,3,6>
    2130640896U, // <5,3,6,7>: Cost 2 ins <u,3,6,7>, lane 0
    2130640896U, // <5,3,6,u>: Cost 2 ins <u,3,6,7>, lane 0
    1485963366U, // <5,3,7,0>: Cost 2 vext1 <1,5,3,7>, LHS
    1485964432U, // <5,3,7,1>: Cost 2 vext1 <1,5,3,7>, <1,5,3,7>
    2961179382U, // <5,3,7,2>: Cost 3 vzipr <1,3,5,7>, <1,0,3,2>
    2040972248U, // <5,3,7,3>: Cost 2 vtrnr RHS, <1,3,1,3>
    1485966646U, // <5,3,7,4>: Cost 2 vext1 <1,5,3,7>, RHS
    2040973006U, // <5,3,7,5>: Cost 2 vtrnr RHS, <2,3,4,5>
    2116108289U, // <5,3,7,6>: Cost 2 ins <5,u,7,6>, lane 1
    2040972288U, // <5,3,7,7>: Cost 2 vtrnr RHS, <1,3,5,7>
    1485969198U, // <5,3,7,u>: Cost 2 vext1 <1,5,3,7>, LHS
    1485971558U, // <5,3,u,0>: Cost 2 vext1 <1,5,3,u>, LHS
    1485972625U, // <5,3,u,1>: Cost 2 vext1 <1,5,3,u>, <1,5,3,u>
    2961187574U, // <5,3,u,2>: Cost 3 vzipr <1,3,5,u>, <1,0,3,2>
    2040980440U, // <5,3,u,3>: Cost 2 vtrnr RHS, <1,3,1,3>
    1485974838U, // <5,3,u,4>: Cost 2 vext1 <1,5,3,u>, RHS
    2040981198U, // <5,3,u,5>: Cost 2 vtrnr RHS, <2,3,4,5>
    2116108289U, // <5,3,u,6>: Cost 2 ins <5,u,7,6>, lane 1
    2040980480U, // <5,3,u,7>: Cost 2 vtrnr RHS, <1,3,5,7>
    1485977390U, // <5,3,u,u>: Cost 2 vext1 <1,5,3,u>, LHS
    3189284865U, // <5,4,0,0>: Cost 3 ins <5,u,0,0>, lane 1
    2113544197U, // <5,4,0,1>: Cost 2 ins <5,4,u,u>, lane 5
    2781626470U, // <5,4,0,2>: Cost 3 vuzpl <5,0,4,1>, LHS
    2242022676U, // <5,4,0,3>: Cost 3 vrev <4,5,3,0>
    2642198866U, // <5,4,0,4>: Cost 3 vext2 <4,1,5,4>, <0,4,1,5>
    2687126418U, // <5,4,0,5>: Cost 3 vext3 <0,4,1,5>, <4,0,5,1>
    2113527810U, // <5,4,0,6>: Cost 2 ins <5,4,u,6>, lane 2
    3114659045U, // <5,4,0,7>: Cost 3 vtrnr <4,5,6,0>, <4,4,6,7>
    2113544197U, // <5,4,0,u>: Cost 2 ins <5,4,u,u>, lane 5
    1168067834U, // <5,4,1,0>: Cost 2 vrev <4,5,0,1>
    3189366785U, // <5,4,1,1>: Cost 3 ins <5,u,1,1>, lane 1
    3204636672U, // <5,4,1,2>: Cost 3 ins <u,4,1,2>, lane 0
    2115641345U, // <5,4,1,3>: Cost 2 ins <5,u,1,3>, lane 1
    2982366416U, // <5,4,1,4>: Cost 3 vzipr <4,u,5,1>, <4,4,4,4>
    1843006774U, // <5,4,1,5>: Cost 2 vzipl <5,1,7,3>, RHS
    1980763446U, // <5,4,1,6>: Cost 2 vtrnl <5,7,1,3>, RHS
    3189415937U, // <5,4,1,7>: Cost 3 ins <5,u,1,7>, lane 1
    1843007017U, // <5,4,1,u>: Cost 2 vzipl <5,1,7,3>, RHS
    3204694016U, // <5,4,2,0>: Cost 3 ins <u,4,2,0>, lane 0
    2241891588U, // <5,4,2,1>: Cost 3 vrev <4,5,1,2>
    3189448705U, // <5,4,2,2>: Cost 3 ins <5,u,2,2>, lane 1
    2113544197U, // <5,4,2,3>: Cost 2 ins <5,4,u,u>, lane 5
    3204726784U, // <5,4,2,4>: Cost 3 ins <u,4,2,4>, lane 0
    2973746894U, // <5,4,2,5>: Cost 3 vzipr <3,4,5,2>, <2,3,4,5>
    2131001344U, // <5,4,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    3114675429U, // <5,4,2,7>: Cost 3 vtrnr <4,5,6,2>, <4,4,6,7>
    2113544197U, // <5,4,2,u>: Cost 2 ins <5,4,u,u>, lane 5
    3204767744U, // <5,4,3,0>: Cost 3 ins <u,4,3,0>, lane 0
    2241899781U, // <5,4,3,1>: Cost 3 vrev <4,5,1,3>
    1168231694U, // <5,4,3,2>: Cost 2 vrev <4,5,2,3>
    3189530625U, // <5,4,3,3>: Cost 3 ins <5,u,3,3>, lane 1
    2638219776U, // <5,4,3,4>: Cost 3 vext2 <3,4,5,4>, <3,4,5,4>
    2978399950U, // <5,4,3,5>: Cost 3 vzipr <4,2,5,3>, <2,3,4,5>
    2113527810U, // <5,4,3,6>: Cost 2 ins <5,4,u,6>, lane 2
    2840355840U, // <5,4,3,7>: Cost 3 vuzpr <3,5,7,4>, <1,3,5,7>
    2113527810U, // <5,4,3,u>: Cost 2 ins <5,4,u,6>, lane 2
    2918763410U, // <5,4,4,0>: Cost 3 vzipl <5,4,7,6>, <4,0,5,1>
    2642201574U, // <5,4,4,1>: Cost 3 vext2 <4,1,5,4>, <4,1,5,4>
    3186991107U, // <5,4,4,2>: Cost 3 ins <5,4,4,u>, lane 3
    3186991107U, // <5,4,4,3>: Cost 3 ins <5,4,4,u>, lane 3
    2131132416U, // <5,4,4,4>: Cost 2 ins <u,4,4,4>, lane 0
    1845022006U, // <5,4,4,5>: Cost 2 vzipl <5,4,7,6>, RHS
    2113527810U, // <5,4,4,6>: Cost 2 ins <5,4,u,6>, lane 2
    2646183372U, // <5,4,4,7>: Cost 3 vext2 <4,7,5,4>, <4,7,5,4>
    1845022249U, // <5,4,4,u>: Cost 2 vzipl <5,4,7,6>, RHS
    1503936614U, // <5,4,5,0>: Cost 2 vext1 <4,5,4,5>, LHS
    2559763607U, // <5,4,5,1>: Cost 3 vext1 <1,5,4,5>, <1,5,4,5>
    2698628366U, // <5,4,5,2>: Cost 3 vext3 <2,3,4,5>, <4,5,2,3>
    3189678081U, // <5,4,5,3>: Cost 3 ins <5,u,5,3>, lane 1
    1168395554U, // <5,4,5,4>: Cost 2 vrev <4,5,4,5>
    1845529910U, // <5,4,5,5>: Cost 2 vzipl <5,5,5,5>, RHS
    1613385014U, // <5,4,5,6>: Cost 2 vext3 <0,4,1,5>, RHS
    2115969025U, // <5,4,5,7>: Cost 2 ins <5,u,5,7>, lane 1
    1613385032U, // <5,4,5,u>: Cost 2 vext3 <0,4,1,5>, RHS
    2559770726U, // <5,4,6,0>: Cost 3 vext1 <1,5,4,6>, LHS
    2559771800U, // <5,4,6,1>: Cost 3 vext1 <1,5,4,6>, <1,5,4,6>
    3189743617U, // <5,4,6,2>: Cost 3 ins <5,u,6,2>, lane 1
    2571717194U, // <5,4,6,3>: Cost 3 vext1 <3,5,4,6>, <3,5,4,6>
    2559774006U, // <5,4,6,4>: Cost 3 vext1 <1,5,4,6>, RHS
    1846299958U, // <5,4,6,5>: Cost 2 vzipl <5,6,7,0>, RHS
    2131296256U, // <5,4,6,6>: Cost 2 ins <u,4,6,6>, lane 0
    2113544197U, // <5,4,6,7>: Cost 2 ins <5,4,u,u>, lane 5
    1846300201U, // <5,4,6,u>: Cost 2 vzipl <5,6,7,0>, RHS
    2116059137U, // <5,4,7,0>: Cost 2 ins <5,u,7,0>, lane 1
    2113470467U, // <5,4,7,1>: Cost 2 ins <5,4,7,u>, lane 3
    2113470467U, // <5,4,7,2>: Cost 2 ins <5,4,7,u>, lane 3
    2116083713U, // <5,4,7,3>: Cost 2 ins <5,u,7,3>, lane 1
    2040974544U, // <5,4,7,4>: Cost 2 vtrnr RHS, <4,4,4,4>
    2040971602U, // <5,4,7,5>: Cost 2 vtrnr RHS, <0,4,1,5>
    94817590U,   // <5,4,7,6>: Cost 1 vrev RHS
    2116116481U, // <5,4,7,7>: Cost 2 ins <5,u,7,7>, lane 1
    94965064U,   // <5,4,7,u>: Cost 1 vrev RHS
    2116059137U, // <5,4,u,0>: Cost 2 ins <5,u,7,0>, lane 1
    2113544197U, // <5,4,u,1>: Cost 2 ins <5,4,u,u>, lane 5
    2113470467U, // <5,4,u,2>: Cost 2 ins <5,4,7,u>, lane 3
    2115641345U, // <5,4,u,3>: Cost 2 ins <5,u,1,3>, lane 1
    2040982736U, // <5,4,u,4>: Cost 2 vtrnr RHS, <4,4,4,4>
    2040979794U, // <5,4,u,5>: Cost 2 vtrnr RHS, <0,4,1,5>
    94825783U,   // <5,4,u,6>: Cost 1 vrev RHS
    2115969025U, // <5,4,u,7>: Cost 2 ins <5,u,5,7>, lane 1
    94973257U,   // <5,4,u,u>: Cost 1 vrev RHS
    2040917295U, // <5,5,0,0>: Cost 2 vtrnr <4,5,6,0>, <4,5,6,0>
    1573109862U, // <5,5,0,1>: Cost 2 vext2 <4,u,5,5>, LHS
    1711308902U, // <5,5,0,2>: Cost 2 vuzpl <5,5,5,5>, LHS
    3187908610U, // <5,5,0,3>: Cost 3 ins <5,5,u,3>, lane 2
    2687127138U, // <5,5,0,4>: Cost 3 vext3 <0,4,1,5>, <5,0,4,1>
    2114183170U, // <5,5,0,5>: Cost 2 ins <5,5,u,5>, lane 2
    3187933186U, // <5,5,0,6>: Cost 3 ins <5,5,u,6>, lane 2
    2114199554U, // <5,5,0,7>: Cost 2 ins <5,5,u,7>, lane 2
    1573110429U, // <5,5,0,u>: Cost 2 vext2 <4,u,5,5>, LHS
    2646852342U, // <5,5,1,0>: Cost 3 vext2 <4,u,5,5>, <1,0,3,2>
    1908624922U, // <5,5,1,1>: Cost 2 vzipr <4,u,5,1>, <4,u,5,1>
    2646852502U, // <5,5,1,2>: Cost 3 vext2 <4,u,5,5>, <1,2,3,0>
    1778417766U, // <5,5,1,3>: Cost 2 vuzpr <5,5,5,5>, LHS
    2715217591U, // <5,5,1,4>: Cost 3 vext3 <5,1,4,5>, <5,1,4,5>
    2114183170U, // <5,5,1,5>: Cost 2 ins <5,5,u,5>, lane 2
    2982365698U, // <5,5,1,6>: Cost 3 vzipr <4,u,5,1>, <3,4,5,6>
    2114199554U, // <5,5,1,7>: Cost 2 ins <5,5,u,7>, lane 2
    1778417771U, // <5,5,1,u>: Cost 2 vuzpr <5,5,5,5>, LHS
    2785052326U, // <5,5,2,0>: Cost 3 vuzpl <5,5,5,5>, <2,3,0,1>
    3205365760U, // <5,5,2,1>: Cost 3 ins <u,5,2,1>, lane 0
    2040933681U, // <5,5,2,2>: Cost 2 vtrnr <4,5,6,2>, <4,5,6,2>
    2114207749U, // <5,5,2,3>: Cost 2 ins <5,5,u,u>, lane 5
    2785052366U, // <5,5,2,4>: Cost 3 vuzpl <5,5,5,5>, <2,3,4,5>
    2114183170U, // <5,5,2,5>: Cost 2 ins <5,5,u,5>, lane 2
    2646853562U, // <5,5,2,6>: Cost 3 vext2 <4,u,5,5>, <2,6,3,7>
    2114199554U, // <5,5,2,7>: Cost 2 ins <5,5,u,7>, lane 2
    2114207749U, // <5,5,2,u>: Cost 2 ins <5,5,u,u>, lane 5
    2646853782U, // <5,5,3,0>: Cost 3 vext2 <4,u,5,5>, <3,0,1,2>
    2785052822U, // <5,5,3,1>: Cost 3 vuzpl <5,5,5,5>, <3,0,1,2>
    3187900418U, // <5,5,3,2>: Cost 3 ins <5,5,u,2>, lane 2
    1880105089U, // <5,5,3,3>: Cost 2 vzipr <0,1,5,3>, <0,1,5,3>
    2646854146U, // <5,5,3,4>: Cost 3 vext2 <4,u,5,5>, <3,4,5,6>
    2114183170U, // <5,5,3,5>: Cost 2 ins <5,5,u,5>, lane 2
    3205480448U, // <5,5,3,6>: Cost 3 ins <u,5,3,6>, lane 0
    2131746816U, // <5,5,3,7>: Cost 2 ins <u,5,3,7>, lane 0
    2131746816U, // <5,5,3,u>: Cost 2 ins <u,5,3,7>, lane 0
    2646854546U, // <5,5,4,0>: Cost 3 vext2 <4,u,5,5>, <4,0,5,1>
    2716987279U, // <5,5,4,1>: Cost 3 vext3 <5,4,1,5>, <5,4,1,5>
    3187900418U, // <5,5,4,2>: Cost 3 ins <5,5,u,2>, lane 2
    3187908610U, // <5,5,4,3>: Cost 3 ins <5,5,u,3>, lane 2
    1845022662U, // <5,5,4,4>: Cost 2 vzipl <5,4,7,6>, <5,4,7,6>
    1573113142U, // <5,5,4,5>: Cost 2 vext2 <4,u,5,5>, RHS
    1711312182U, // <5,5,4,6>: Cost 2 vuzpl <5,5,5,5>, RHS
    2114199554U, // <5,5,4,7>: Cost 2 ins <5,5,u,7>, lane 2
    1573113374U, // <5,5,4,u>: Cost 2 vext2 <4,u,5,5>, <4,u,5,5>
    1509982310U, // <5,5,5,0>: Cost 2 vext1 <5,5,5,5>, LHS
    2113986563U, // <5,5,5,1>: Cost 2 ins <5,5,5,u>, lane 3
    2113986563U, // <5,5,5,2>: Cost 2 ins <5,5,5,u>, lane 3
    2113986563U, // <5,5,5,3>: Cost 2 ins <5,5,5,u>, lane 3
    1509985590U, // <5,5,5,4>: Cost 2 vext1 <5,5,5,5>, RHS
    229035318U,  // <5,5,5,5>: Cost 1 vdup1 RHS
    2113986563U, // <5,5,5,6>: Cost 2 ins <5,5,5,u>, lane 3
    1778421046U, // <5,5,5,7>: Cost 2 vuzpr <5,5,5,5>, RHS
    229035318U,  // <5,5,5,u>: Cost 1 vdup1 RHS
    2131910656U, // <5,5,6,0>: Cost 2 ins <u,5,6,0>, lane 0
    2131918848U, // <5,5,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2131927040U, // <5,5,6,2>: Cost 2 ins <u,5,6,2>, lane 0
    2131935232U, // <5,5,6,3>: Cost 2 ins <u,5,6,3>, lane 0
    2131943424U, // <5,5,6,4>: Cost 2 ins <u,5,6,4>, lane 0
    2131951616U, // <5,5,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    1900038658U, // <5,5,6,6>: Cost 2 vzipr <3,4,5,6>, <3,4,5,6>
    1058226176U, // <5,5,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <5,5,6,u>: Cost 1 ins RHS, lane 0
    2116059137U, // <5,5,7,0>: Cost 2 ins <5,u,7,0>, lane 1
    2114134019U, // <5,5,7,1>: Cost 2 ins <5,5,7,u>, lane 3
    2114134019U, // <5,5,7,2>: Cost 2 ins <5,5,7,u>, lane 3
    2116083713U, // <5,5,7,3>: Cost 2 ins <5,u,7,3>, lane 1
    2116091905U, // <5,5,7,4>: Cost 2 ins <5,u,7,4>, lane 1
    2040975364U, // <5,5,7,5>: Cost 2 vtrnr RHS, <5,5,5,5>
    2116108289U, // <5,5,7,6>: Cost 2 ins <5,u,7,6>, lane 1
    967232822U,  // <5,5,7,7>: Cost 1 vtrnr RHS, RHS
    967232823U,  // <5,5,7,u>: Cost 1 vtrnr RHS, RHS
    1509982310U, // <5,5,u,0>: Cost 2 vext1 <5,5,5,5>, LHS
    1573115694U, // <5,5,u,1>: Cost 2 vext2 <4,u,5,5>, LHS
    1711314734U, // <5,5,u,2>: Cost 2 vuzpl <5,5,5,5>, LHS
    1778418333U, // <5,5,u,3>: Cost 2 vuzpr <5,5,5,5>, LHS
    1845022662U, // <5,5,u,4>: Cost 2 vzipl <5,4,7,6>, <5,4,7,6>
    229035318U,  // <5,5,u,5>: Cost 1 vdup1 RHS
    1711315098U, // <5,5,u,6>: Cost 2 vuzpl <5,5,5,5>, RHS
    967241014U,  // <5,5,u,7>: Cost 1 vtrnr RHS, RHS
    967241015U,  // <5,5,u,u>: Cost 1 vtrnr RHS, RHS
    2114805762U, // <5,6,0,0>: Cost 2 ins <5,6,u,0>, lane 2
    1564491878U, // <5,6,0,1>: Cost 2 vext2 <3,4,5,6>, LHS
    2132148224U, // <5,6,0,2>: Cost 2 ins <u,6,0,2>, lane 0
    2638233856U, // <5,6,0,3>: Cost 3 vext2 <3,4,5,6>, <0,3,1,4>
    2114838530U, // <5,6,0,4>: Cost 2 ins <5,6,u,4>, lane 2
    3188588546U, // <5,6,0,5>: Cost 3 ins <5,6,u,5>, lane 2
    3188596738U, // <5,6,0,6>: Cost 3 ins <5,6,u,6>, lane 2
    2973732150U, // <5,6,0,7>: Cost 3 vzipr <3,4,5,0>, RHS
    1564492445U, // <5,6,0,u>: Cost 2 vext2 <3,4,5,6>, LHS
    2114805762U, // <5,6,1,0>: Cost 2 ins <5,6,u,0>, lane 2
    2638234420U, // <5,6,1,1>: Cost 3 vext2 <3,4,5,6>, <1,1,1,1>
    2638234518U, // <5,6,1,2>: Cost 3 vext2 <3,4,5,6>, <1,2,3,0>
    2115641345U, // <5,6,1,3>: Cost 2 ins <5,u,1,3>, lane 1
    2114838530U, // <5,6,1,4>: Cost 2 ins <5,6,u,4>, lane 2
    2638234768U, // <5,6,1,5>: Cost 3 vext2 <3,4,5,6>, <1,5,3,7>
    2982366436U, // <5,6,1,6>: Cost 3 vzipr <4,u,5,1>, <4,4,6,6>
    1908624694U, // <5,6,1,7>: Cost 2 vzipr <4,u,5,1>, RHS
    1908624695U, // <5,6,1,u>: Cost 2 vzipr <4,u,5,1>, RHS
    2114805762U, // <5,6,2,0>: Cost 2 ins <5,6,u,0>, lane 2
    3188555778U, // <5,6,2,1>: Cost 3 ins <5,6,u,1>, lane 2
    2638235240U, // <5,6,2,2>: Cost 3 vext2 <3,4,5,6>, <2,2,2,2>
    2114871301U, // <5,6,2,3>: Cost 2 ins <5,6,u,u>, lane 5
    2114838530U, // <5,6,2,4>: Cost 2 ins <5,6,u,4>, lane 2
    2638235496U, // <5,6,2,5>: Cost 3 vext2 <3,4,5,6>, <2,5,3,6>
    2638235578U, // <5,6,2,6>: Cost 3 vext2 <3,4,5,6>, <2,6,3,7>
    2964458806U, // <5,6,2,7>: Cost 3 vzipr <1,u,5,2>, RHS
    2114805762U, // <5,6,2,u>: Cost 2 ins <5,6,u,0>, lane 2
    2114805762U, // <5,6,3,0>: Cost 2 ins <5,6,u,0>, lane 2
    3206103040U, // <5,6,3,1>: Cost 3 ins <u,6,3,1>, lane 0
    3206111232U, // <5,6,3,2>: Cost 3 ins <u,6,3,2>, lane 0
    2638236060U, // <5,6,3,3>: Cost 3 vext2 <3,4,5,6>, <3,3,3,3>
    1564494338U, // <5,6,3,4>: Cost 2 vext2 <3,4,5,6>, <3,4,5,6>
    2783119874U, // <5,6,3,5>: Cost 3 vuzpl <5,2,6,3>, <3,4,5,6>
    3206144000U, // <5,6,3,6>: Cost 3 ins <u,6,3,6>, lane 0
    2132410368U, // <5,6,3,7>: Cost 2 ins <u,6,3,7>, lane 0
    1567148870U, // <5,6,3,u>: Cost 2 vext2 <3,u,5,6>, <3,u,5,6>
    2114805762U, // <5,6,4,0>: Cost 2 ins <5,6,u,0>, lane 2
    3189587969U, // <5,6,4,1>: Cost 3 ins <5,u,4,1>, lane 1
    2918765050U, // <5,6,4,2>: Cost 3 vzipl <5,4,7,6>, <6,2,7,3>
    2638236818U, // <5,6,4,3>: Cost 3 vext2 <3,4,5,6>, <4,3,6,5>
    2114838530U, // <5,6,4,4>: Cost 2 ins <5,6,u,4>, lane 2
    1564495158U, // <5,6,4,5>: Cost 2 vext2 <3,4,5,6>, RHS
    2132475904U, // <5,6,4,6>: Cost 2 ins <u,6,4,6>, lane 0
    2972437814U, // <5,6,4,7>: Cost 3 vzipr <3,2,5,4>, RHS
    1564495401U, // <5,6,4,u>: Cost 2 vext2 <3,4,5,6>, RHS
    2114805762U, // <5,6,5,0>: Cost 2 ins <5,6,u,0>, lane 2
    2662125264U, // <5,6,5,1>: Cost 3 vext2 <7,4,5,6>, <5,1,7,3>
    2982398876U, // <5,6,5,2>: Cost 3 vzipr <4,u,5,5>, <4,0,6,2>
    3189678081U, // <5,6,5,3>: Cost 3 ins <5,u,5,3>, lane 1
    2114838530U, // <5,6,5,4>: Cost 2 ins <5,6,u,4>, lane 2
    2115952641U, // <5,6,5,5>: Cost 2 ins <5,u,5,5>, lane 1
    1772530997U, // <5,6,5,6>: Cost 2 vuzpr <4,5,6,6>, <4,5,6,6>
    1908657462U, // <5,6,5,7>: Cost 2 vzipr <4,u,5,5>, RHS
    1908657463U, // <5,6,5,u>: Cost 2 vzipr <4,u,5,5>, RHS
    2114805762U, // <5,6,6,0>: Cost 2 ins <5,6,u,0>, lane 2
    3189735425U, // <5,6,6,1>: Cost 3 ins <5,u,6,1>, lane 1
    2920043002U, // <5,6,6,2>: Cost 3 vzipl <5,6,7,0>, <6,2,7,3>
    2973781298U, // <5,6,6,3>: Cost 3 vzipr <3,4,5,6>, <4,5,6,3>
    2114838530U, // <5,6,6,4>: Cost 2 ins <5,6,u,4>, lane 2
    2973781138U, // <5,6,6,5>: Cost 3 vzipr <3,4,5,6>, <4,3,6,5>
    2132623360U, // <5,6,6,6>: Cost 2 ins <u,6,6,6>, lane 0
    1900039478U, // <5,6,6,7>: Cost 2 vzipr <3,4,5,6>, RHS
    1900039479U, // <5,6,6,u>: Cost 2 vzipr <3,4,5,6>, RHS
    430358630U,  // <5,6,7,0>: Cost 1 vext1 RHS, LHS
    1504101110U, // <5,6,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
    1504101992U, // <5,6,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
    1504102550U, // <5,6,7,3>: Cost 2 vext1 RHS, <3,0,1,2>
    430361910U,  // <5,6,7,4>: Cost 1 vext1 RHS, RHS
    1504104390U, // <5,6,7,5>: Cost 2 vext1 RHS, <5,4,7,6>
    1504105272U, // <5,6,7,6>: Cost 2 vext1 RHS, <6,6,6,6>
    1887440182U, // <5,6,7,7>: Cost 2 vzipr <1,3,5,7>, RHS
    430364462U,  // <5,6,7,u>: Cost 1 vext1 RHS, LHS
    430366822U,  // <5,6,u,0>: Cost 1 vext1 RHS, LHS
    1564497710U, // <5,6,u,1>: Cost 2 vext2 <3,4,5,6>, LHS
    1504110184U, // <5,6,u,2>: Cost 2 vext1 RHS, <2,2,2,2>
    1504110742U, // <5,6,u,3>: Cost 2 vext1 RHS, <3,0,1,2>
    430370103U,  // <5,6,u,4>: Cost 1 vext1 RHS, RHS
    1564498074U, // <5,6,u,5>: Cost 2 vext2 <3,4,5,6>, RHS
    1504113146U, // <5,6,u,6>: Cost 2 vext1 RHS, <6,2,7,3>
    1887448374U, // <5,6,u,7>: Cost 2 vzipr <1,3,5,u>, RHS
    430372654U,  // <5,6,u,u>: Cost 1 vext1 RHS, LHS
    1772535808U, // <5,7,0,0>: Cost 2 vuzpr RHS, <0,0,0,0>
    1551892582U, // <5,7,0,1>: Cost 2 vext2 <1,3,5,7>, LHS
    1772535828U, // <5,7,0,2>: Cost 2 vuzpr RHS, <0,0,2,2>
    2115493890U, // <5,7,0,3>: Cost 2 ins <5,7,u,3>, lane 2
    2625634642U, // <5,7,0,4>: Cost 3 vext2 <1,3,5,7>, <0,4,1,5>
    2846279860U, // <5,7,0,5>: Cost 3 vuzpr RHS, <3,0,4,5>
    2846277674U, // <5,7,0,6>: Cost 3 vuzpr RHS, <0,0,4,6>
    2115526658U, // <5,7,0,7>: Cost 2 ins <5,7,u,7>, lane 2
    1551893149U, // <5,7,0,u>: Cost 2 vext2 <1,3,5,7>, LHS
    2115018755U, // <5,7,1,0>: Cost 2 ins <5,7,1,u>, lane 3
    1772536628U, // <5,7,1,1>: Cost 2 vuzpr RHS, <1,1,1,1>
    2115018755U, // <5,7,1,2>: Cost 2 ins <5,7,1,u>, lane 3
    698794086U,  // <5,7,1,3>: Cost 1 vuzpr RHS, LHS
    2115018755U, // <5,7,1,4>: Cost 2 ins <5,7,1,u>, lane 3
    2115018755U, // <5,7,1,5>: Cost 2 ins <5,7,1,u>, lane 3
    2115018755U, // <5,7,1,6>: Cost 2 ins <5,7,1,u>, lane 3
    2115526658U, // <5,7,1,7>: Cost 2 ins <5,7,u,7>, lane 2
    698794091U,  // <5,7,1,u>: Cost 1 vuzpr RHS, LHS
    1772536726U, // <5,7,2,0>: Cost 2 vuzpr RHS, <1,2,3,0>
    2846277795U, // <5,7,2,1>: Cost 3 vuzpr RHS, <0,2,0,1>
    1772535972U, // <5,7,2,2>: Cost 2 vuzpr RHS, <0,2,0,2>
    1772537458U, // <5,7,2,3>: Cost 2 vuzpr RHS, <2,2,3,3>
    1772536730U, // <5,7,2,4>: Cost 2 vuzpr RHS, <1,2,3,4>
    2625636201U, // <5,7,2,5>: Cost 3 vext2 <1,3,5,7>, <2,5,3,7>
    1772536012U, // <5,7,2,6>: Cost 2 vuzpr RHS, <0,2,4,6>
    2115526658U, // <5,7,2,7>: Cost 2 ins <5,7,u,7>, lane 2
    1772535978U, // <5,7,2,u>: Cost 2 vuzpr RHS, <0,2,0,u>
    2625636502U, // <5,7,3,0>: Cost 3 vext2 <1,3,5,7>, <3,0,1,2>
    1772537510U, // <5,7,3,1>: Cost 2 vuzpr RHS, <2,3,0,1>
    2846278606U, // <5,7,3,2>: Cost 3 vuzpr RHS, <1,3,0,2>
    1772536792U, // <5,7,3,3>: Cost 2 vuzpr RHS, <1,3,1,3>
    2625636866U, // <5,7,3,4>: Cost 3 vext2 <1,3,5,7>, <3,4,5,6>
    1772537550U, // <5,7,3,5>: Cost 2 vuzpr RHS, <2,3,4,5>
    2846278628U, // <5,7,3,6>: Cost 3 vuzpr RHS, <1,3,2,6>
    1772536832U, // <5,7,3,7>: Cost 2 vuzpr RHS, <1,3,5,7>
    1772536797U, // <5,7,3,u>: Cost 2 vuzpr RHS, <1,3,1,u>
    2571919462U, // <5,7,4,0>: Cost 3 vext1 <3,5,7,4>, LHS
    2571920384U, // <5,7,4,1>: Cost 3 vext1 <3,5,7,4>, <1,3,5,7>
    2846277958U, // <5,7,4,2>: Cost 3 vuzpr RHS, <0,4,0,2>
    2115493890U, // <5,7,4,3>: Cost 2 ins <5,7,u,3>, lane 2
    1772539088U, // <5,7,4,4>: Cost 2 vuzpr RHS, <4,4,4,4>
    1551895862U, // <5,7,4,5>: Cost 2 vext2 <1,3,5,7>, RHS
    1772536156U, // <5,7,4,6>: Cost 2 vuzpr RHS, <0,4,2,6>
    2115526658U, // <5,7,4,7>: Cost 2 ins <5,7,u,7>, lane 2
    1551896105U, // <5,7,4,u>: Cost 2 vext2 <1,3,5,7>, RHS
    2115313667U, // <5,7,5,0>: Cost 2 ins <5,7,5,u>, lane 3
    2115313667U, // <5,7,5,1>: Cost 2 ins <5,7,5,u>, lane 3
    2115313667U, // <5,7,5,2>: Cost 2 ins <5,7,5,u>, lane 3
    2115493890U, // <5,7,5,3>: Cost 2 ins <5,7,u,3>, lane 2
    2115313667U, // <5,7,5,4>: Cost 2 ins <5,7,5,u>, lane 3
    1772539908U, // <5,7,5,5>: Cost 2 vuzpr RHS, <5,5,5,5>
    2115313667U, // <5,7,5,6>: Cost 2 ins <5,7,5,u>, lane 3
    698797366U,  // <5,7,5,7>: Cost 1 vuzpr RHS, RHS
    698797367U,  // <5,7,5,u>: Cost 1 vuzpr RHS, RHS
    1772540002U, // <5,7,6,0>: Cost 2 vuzpr RHS, <5,6,7,0>
    2846279577U, // <5,7,6,1>: Cost 3 vuzpr RHS, <2,6,0,1>
    1772539212U, // <5,7,6,2>: Cost 2 vuzpr RHS, <4,6,0,2>
    2115493890U, // <5,7,6,3>: Cost 2 ins <5,7,u,3>, lane 2
    1772540006U, // <5,7,6,4>: Cost 2 vuzpr RHS, <5,6,7,4>
    2846279617U, // <5,7,6,5>: Cost 3 vuzpr RHS, <2,6,4,5>
    1772539252U, // <5,7,6,6>: Cost 2 vuzpr RHS, <4,6,4,6>
    1772537786U, // <5,7,6,7>: Cost 2 vuzpr RHS, <2,6,3,7>
    1772537787U, // <5,7,6,u>: Cost 2 vuzpr RHS, <2,6,3,u>
    1510146150U, // <5,7,7,0>: Cost 2 vext1 <5,5,7,7>, LHS
    1772540750U, // <5,7,7,1>: Cost 2 vuzpr RHS, <6,7,0,1>
    2846281846U, // <5,7,7,2>: Cost 3 vuzpr RHS, <5,7,0,2>
    1772540032U, // <5,7,7,3>: Cost 2 vuzpr RHS, <5,7,1,3>
    1510149430U, // <5,7,7,4>: Cost 2 vext1 <5,5,7,7>, RHS
    1772540790U, // <5,7,7,5>: Cost 2 vuzpr RHS, <6,7,4,5>
    2116108289U, // <5,7,7,6>: Cost 2 ins <5,u,7,6>, lane 1
    1772540072U, // <5,7,7,7>: Cost 2 vuzpr RHS, <5,7,5,7>
    1772540037U, // <5,7,7,u>: Cost 2 vuzpr RHS, <5,7,1,u>
    1772537212U, // <5,7,u,0>: Cost 2 vuzpr RHS, <1,u,3,0>
    1551898414U, // <5,7,u,1>: Cost 2 vext2 <1,3,5,7>, LHS
    1772536458U, // <5,7,u,2>: Cost 2 vuzpr RHS, <0,u,0,2>
    698794653U,  // <5,7,u,3>: Cost 1 vuzpr RHS, LHS
    1772537216U, // <5,7,u,4>: Cost 2 vuzpr RHS, <1,u,3,4>
    1551898778U, // <5,7,u,5>: Cost 2 vext2 <1,3,5,7>, RHS
    1772536480U, // <5,7,u,6>: Cost 2 vuzpr RHS, <0,u,2,6>
    698797609U,  // <5,7,u,7>: Cost 1 vuzpr RHS, RHS
    698794658U,  // <5,7,u,u>: Cost 1 vuzpr RHS, LHS
    1772544000U, // <5,u,0,0>: Cost 2 vuzpr RHS, <0,0,0,0>
    1551900774U, // <5,u,0,1>: Cost 2 vext2 <1,3,5,u>, LHS
    1772544020U, // <5,u,0,2>: Cost 2 vuzpr RHS, <0,0,2,2>
    2111512578U, // <5,u,0,3>: Cost 2 ins <5,1,u,3>, lane 2
    2114838530U, // <5,u,0,4>: Cost 2 ins <5,6,u,4>, lane 2
    2114183170U, // <5,u,0,5>: Cost 2 ins <5,5,u,5>, lane 2
    2113527810U, // <5,u,0,6>: Cost 2 ins <5,4,u,6>, lane 2
    2114199554U, // <5,u,0,7>: Cost 2 ins <5,5,u,7>, lane 2
    1551901341U, // <5,u,0,u>: Cost 2 vext2 <1,3,5,u>, LHS
    2114805762U, // <5,u,1,0>: Cost 2 ins <5,6,u,0>, lane 2
    1772544820U, // <5,u,1,1>: Cost 2 vuzpr RHS, <1,1,1,1>
    1613387566U, // <5,u,1,2>: Cost 2 vext3 <0,4,1,5>, LHS
    698802278U,  // <5,u,1,3>: Cost 1 vuzpr RHS, LHS
    2114838530U, // <5,u,1,4>: Cost 2 ins <5,6,u,4>, lane 2
    1843009690U, // <5,u,1,5>: Cost 2 vzipl <5,1,7,3>, RHS
    1980766362U, // <5,u,1,6>: Cost 2 vtrnl <5,7,1,3>, RHS
    1908624712U, // <5,u,1,7>: Cost 2 vzipr <4,u,5,1>, RHS
    698802283U,  // <5,u,1,u>: Cost 1 vuzpr RHS, LHS
    1772544918U, // <5,u,2,0>: Cost 2 vuzpr RHS, <1,2,3,0>
    2128969728U, // <5,u,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    1772544164U, // <5,u,2,2>: Cost 2 vuzpr RHS, <0,2,0,2>
    1055244288U, // <5,u,2,3>: Cost 1 ins LHS, lane 0
    1772544922U, // <5,u,2,4>: Cost 2 vuzpr RHS, <1,2,3,4>
    2129002496U, // <5,u,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    1772544204U, // <5,u,2,6>: Cost 2 vuzpr RHS, <0,2,4,6>
    2114199554U, // <5,u,2,7>: Cost 2 ins <5,5,u,7>, lane 2
    1055244288U, // <5,u,2,u>: Cost 1 ins LHS, lane 0
    2129698816U, // <5,u,3,0>: Cost 2 ins <u,2,3,0>, lane 0
    1772545702U, // <5,u,3,1>: Cost 2 vuzpr RHS, <2,3,0,1>
    2128388096U, // <5,u,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    1772544984U, // <5,u,3,3>: Cost 2 vuzpr RHS, <1,3,1,3>
    1564510724U, // <5,u,3,4>: Cost 2 vext2 <3,4,5,u>, <3,4,5,u>
    1772545742U, // <5,u,3,5>: Cost 2 vuzpr RHS, <2,3,4,5>
    2113527810U, // <5,u,3,6>: Cost 2 ins <5,4,u,6>, lane 2
    1772545024U, // <5,u,3,7>: Cost 2 vuzpr RHS, <1,3,5,7>
    1567165256U, // <5,u,3,u>: Cost 2 vext2 <3,u,5,u>, <3,u,5,u>
    2114805762U, // <5,u,4,0>: Cost 2 ins <5,6,u,0>, lane 2
    1845024558U, // <5,u,4,1>: Cost 2 vzipl <5,4,7,6>, LHS
    2642897979U, // <5,u,4,2>: Cost 3 vext2 <4,2,5,u>, <4,2,5,u>
    2111512578U, // <5,u,4,3>: Cost 2 ins <5,1,u,3>, lane 2
    1772547280U, // <5,u,4,4>: Cost 2 vuzpr RHS, <4,4,4,4>
    1551904054U, // <5,u,4,5>: Cost 2 vext2 <1,3,5,u>, RHS
    1772544348U, // <5,u,4,6>: Cost 2 vuzpr RHS, <0,4,2,6>
    2114199554U, // <5,u,4,7>: Cost 2 ins <5,5,u,7>, lane 2
    1551904297U, // <5,u,4,u>: Cost 2 vext2 <1,3,5,u>, RHS
    1509982310U, // <5,u,5,0>: Cost 2 vext1 <5,5,5,5>, LHS
    1845532462U, // <5,u,5,1>: Cost 2 vzipl <5,5,5,5>, LHS
    1979750190U, // <5,u,5,2>: Cost 2 vtrnl <5,5,5,5>, LHS
    1908654236U, // <5,u,5,3>: Cost 2 vzipr <4,u,5,5>, LHS
    1509985590U, // <5,u,5,4>: Cost 2 vext1 <5,5,5,5>, RHS
    229035318U,  // <5,u,5,5>: Cost 1 vdup1 RHS
    1613387930U, // <5,u,5,6>: Cost 2 vext3 <0,4,1,5>, RHS
    698805558U,  // <5,u,5,7>: Cost 1 vuzpr RHS, RHS
    698805559U,  // <5,u,5,u>: Cost 1 vuzpr RHS, RHS
    1772548194U, // <5,u,6,0>: Cost 2 vuzpr RHS, <5,6,7,0>
    1846302510U, // <5,u,6,1>: Cost 2 vzipl <5,6,7,0>, LHS
    1772547404U, // <5,u,6,2>: Cost 2 vuzpr RHS, <4,6,0,2>
    1900036252U, // <5,u,6,3>: Cost 2 vzipr <3,4,5,6>, LHS
    1772548198U, // <5,u,6,4>: Cost 2 vuzpr RHS, <5,6,7,4>
    1846302874U, // <5,u,6,5>: Cost 2 vzipl <5,6,7,0>, RHS
    1772547444U, // <5,u,6,6>: Cost 2 vuzpr RHS, <4,6,4,6>
    1058226176U, // <5,u,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <5,u,6,u>: Cost 1 ins RHS, lane 0
    430506086U,  // <5,u,7,0>: Cost 1 vext1 RHS, LHS
    1486333117U, // <5,u,7,1>: Cost 2 vext1 <1,5,u,7>, <1,5,u,7>
    2040971914U, // <5,u,7,2>: Cost 2 vtrnr RHS, <0,u,0,2>
    967230109U,  // <5,u,7,3>: Cost 1 vtrnr RHS, LHS
    430509384U,  // <5,u,7,4>: Cost 1 vext1 RHS, RHS
    2040971926U, // <5,u,7,5>: Cost 2 vtrnr RHS, <0,u,1,5>
    118708378U,  // <5,u,7,6>: Cost 1 vrev RHS
    967233065U,  // <5,u,7,7>: Cost 1 vtrnr RHS, RHS
    967230114U,  // <5,u,7,u>: Cost 1 vtrnr RHS, LHS
    430514278U,  // <5,u,u,0>: Cost 1 vext1 RHS, LHS
    1551906606U, // <5,u,u,1>: Cost 2 vext2 <1,3,5,u>, LHS
    1613388133U, // <5,u,u,2>: Cost 2 vext3 <0,4,1,5>, LHS
    698802845U,  // <5,u,u,3>: Cost 1 vuzpr RHS, LHS
    430517577U,  // <5,u,u,4>: Cost 1 vext1 RHS, RHS
    229035318U,  // <5,u,u,5>: Cost 1 vdup1 RHS
    118716571U,  // <5,u,u,6>: Cost 1 vrev RHS
    698805801U,  // <5,u,u,7>: Cost 1 vuzpr RHS, RHS
    698802850U,  // <5,u,u,u>: Cost 1 vuzpr RHS, LHS
    2128150528U, // <6,0,0,0>: Cost 2 ins <u,0,0,0>, lane 0
    2121523201U, // <6,0,0,1>: Cost 2 ins <6,u,0,1>, lane 1
    1718206566U, // <6,0,0,2>: Cost 2 vuzpl <6,7,0,1>, LHS
    2852933922U, // <6,0,0,3>: Cost 3 vuzpr <5,6,7,0>, <6,0,1,3>
    2642903388U, // <6,0,0,4>: Cost 3 vext2 <4,2,6,0>, <0,4,2,6>
    2852934680U, // <6,0,0,5>: Cost 3 vuzpr <5,6,7,0>, <7,0,4,5>
    2852934690U, // <6,0,0,6>: Cost 3 vuzpr <5,6,7,0>, <7,0,5,6>
    2852933962U, // <6,0,0,7>: Cost 3 vuzpr <5,6,7,0>, <6,0,5,7>
    1718206620U, // <6,0,0,u>: Cost 2 vuzpl <6,7,0,1>, LHS
    2566070374U, // <6,0,1,0>: Cost 3 vext1 <2,6,0,1>, LHS
    2128232448U, // <6,0,1,1>: Cost 2 ins <u,0,1,1>, lane 0
    1612284006U, // <6,0,1,2>: Cost 2 vext3 <0,2,4,6>, LHS
    1779187814U, // <6,0,1,3>: Cost 2 vuzpr <5,6,7,0>, LHS
    2566073654U, // <6,0,1,4>: Cost 3 vext1 <2,6,0,1>, RHS
    2583990308U, // <6,0,1,5>: Cost 3 vext1 <5,6,0,1>, <5,6,0,1>
    2589963005U, // <6,0,1,6>: Cost 3 vext1 <6,6,0,1>, <6,6,0,1>
    2791949566U, // <6,0,1,7>: Cost 3 vuzpl <6,7,0,1>, <1,6,7,0>
    1612284060U, // <6,0,1,u>: Cost 2 vext3 <0,2,4,6>, LHS
    1504280678U, // <6,0,2,0>: Cost 2 vext1 <4,6,0,2>, LHS
    1849639014U, // <6,0,2,1>: Cost 2 vzipl <6,2,7,3>, LHS
    2128314368U, // <6,0,2,2>: Cost 2 ins <u,0,2,2>, lane 0
    2128322560U, // <6,0,2,3>: Cost 2 ins <u,0,2,3>, lane 0
    1612284108U, // <6,0,2,4>: Cost 2 vext3 <0,2,4,6>, <0,2,4,6>
    2578026192U, // <6,0,2,5>: Cost 3 vext1 <4,6,0,2>, <5,1,7,3>
    2578026792U, // <6,0,2,6>: Cost 3 vext1 <4,6,0,2>, <6,0,2,0>
    2578027514U, // <6,0,2,7>: Cost 3 vext1 <4,6,0,2>, <7,0,1,2>
    1612579056U, // <6,0,2,u>: Cost 2 vext3 <0,2,u,6>, <0,2,u,6>
    3202113536U, // <6,0,3,0>: Cost 3 ins <u,0,3,0>, lane 0
    2705342720U, // <6,0,3,1>: Cost 3 vext3 <3,4,5,6>, <0,3,1,4>
    2128388096U, // <6,0,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    2852930520U, // <6,0,3,3>: Cost 3 vuzpr <5,6,7,0>, <1,3,1,3>
    2644896258U, // <6,0,3,4>: Cost 3 vext2 <4,5,6,0>, <3,4,5,6>
    2852931278U, // <6,0,3,5>: Cost 3 vuzpr <5,6,7,0>, <2,3,4,5>
    3190587394U, // <6,0,3,6>: Cost 3 ins <6,0,u,6>, lane 2
    2852930560U, // <6,0,3,7>: Cost 3 vuzpr <5,6,7,0>, <1,3,5,7>
    2128388096U, // <6,0,3,u>: Cost 2 ins <u,0,3,2>, lane 0
    2687058250U, // <6,0,4,0>: Cost 3 vext3 <0,4,0,6>, <0,4,0,6>
    2686026066U, // <6,0,4,1>: Cost 3 vext3 <0,2,4,6>, <0,4,1,5>
    1613463900U, // <6,0,4,2>: Cost 2 vext3 <0,4,2,6>, <0,4,2,6>
    3195576321U, // <6,0,4,3>: Cost 3 ins <6,u,4,3>, lane 1
    2687353198U, // <6,0,4,4>: Cost 3 vext3 <0,4,4,6>, <0,4,4,6>
    2121850881U, // <6,0,4,5>: Cost 2 ins <6,u,4,5>, lane 1
    1718209846U, // <6,0,4,6>: Cost 2 vuzpl <6,7,0,1>, RHS
    3195609089U, // <6,0,4,7>: Cost 3 ins <6,u,4,7>, lane 1
    1613906322U, // <6,0,4,u>: Cost 2 vext3 <0,4,u,6>, <0,4,u,6>
    3202260992U, // <6,0,5,0>: Cost 3 ins <u,0,5,0>, lane 0
    2128527360U, // <6,0,5,1>: Cost 2 ins <u,0,5,1>, lane 0
    3056156774U, // <6,0,5,2>: Cost 3 vtrnl <6,0,5,7>, LHS
    3190562818U, // <6,0,5,3>: Cost 3 ins <6,0,u,3>, lane 2
    3058802892U, // <6,0,5,4>: Cost 3 vtrnl <6,4,5,6>, <0,2,4,6>
    2852933636U, // <6,0,5,5>: Cost 3 vuzpr <5,6,7,0>, <5,5,5,5>
    2852932908U, // <6,0,5,6>: Cost 3 vuzpr <5,6,7,0>, <4,5,5,6>
    1779191094U, // <6,0,5,7>: Cost 2 vuzpr <5,6,7,0>, RHS
    1779191095U, // <6,0,5,u>: Cost 2 vuzpr <5,6,7,0>, RHS
    1779191906U, // <6,0,6,0>: Cost 2 vuzpr <5,6,7,0>, <5,6,7,0>
    1852244070U, // <6,0,6,1>: Cost 2 vzipl <6,6,6,6>, LHS
    1986461798U, // <6,0,6,2>: Cost 2 vtrnl <6,6,6,6>, LHS
    3195723777U, // <6,0,6,3>: Cost 3 ins <6,u,6,3>, lane 1
    2852933734U, // <6,0,6,4>: Cost 3 vuzpr <5,6,7,0>, <5,6,7,4>
    3195740161U, // <6,0,6,5>: Cost 3 ins <6,u,6,5>, lane 1
    2122006529U, // <6,0,6,6>: Cost 2 ins <6,u,6,6>, lane 1
    2128650240U, // <6,0,6,7>: Cost 2 ins <u,0,6,7>, lane 0
    1852244637U, // <6,0,6,u>: Cost 2 vzipl <6,6,6,6>, LHS
    1906753536U, // <6,0,7,0>: Cost 2 vzipr RHS, <0,0,0,0>
    1906755238U, // <6,0,7,1>: Cost 2 vzipr RHS, <2,3,0,1>
    1906753700U, // <6,0,7,2>: Cost 2 vzipr RHS, <0,2,0,2>
    2122055681U, // <6,0,7,3>: Cost 2 ins <6,u,7,3>, lane 1
    2572094774U, // <6,0,7,4>: Cost 3 vext1 <3,6,0,7>, RHS
    2980496418U, // <6,0,7,5>: Cost 3 vzipr RHS, <1,4,0,5>
    2980495690U, // <6,0,7,6>: Cost 3 vzipr RHS, <0,4,0,6>
    2122088449U, // <6,0,7,7>: Cost 2 ins <6,u,7,7>, lane 1
    1906753706U, // <6,0,7,u>: Cost 2 vzipr RHS, <0,2,0,u>
    1906761728U, // <6,0,u,0>: Cost 2 vzipr RHS, <0,0,0,0>
    1906763430U, // <6,0,u,1>: Cost 2 vzipr RHS, <2,3,0,1>
    1612284573U, // <6,0,u,2>: Cost 2 vext3 <0,2,4,6>, LHS
    1779188381U, // <6,0,u,3>: Cost 2 vuzpr <5,6,7,0>, LHS
    1616265906U, // <6,0,u,4>: Cost 2 vext3 <0,u,4,6>, <0,u,4,6>
    2121850881U, // <6,0,u,5>: Cost 2 ins <6,u,4,5>, lane 1
    1718212762U, // <6,0,u,6>: Cost 2 vuzpl <6,7,0,1>, RHS
    1779191337U, // <6,0,u,7>: Cost 2 vuzpr <5,6,7,0>, RHS
    1612284627U, // <6,0,u,u>: Cost 2 vext3 <0,2,4,6>, LHS
    2595995750U, // <6,1,0,0>: Cost 3 vext1 <7,6,1,0>, LHS
    2121523201U, // <6,1,0,1>: Cost 2 ins <6,u,0,1>, lane 1
    2846673046U, // <6,1,0,2>: Cost 3 vuzpr <4,6,3,1>, <3,0,1,2>
    2047623270U, // <6,1,0,3>: Cost 2 vtrnr <5,6,7,0>, LHS
    2787385548U, // <6,1,0,4>: Cost 3 vuzpl <6,0,1,2>, <0,2,4,6>
    3060384768U, // <6,1,0,5>: Cost 3 vtrnl <6,7,0,1>, <1,3,5,7>
    2596000590U, // <6,1,0,6>: Cost 3 vext1 <7,6,1,0>, <6,7,0,1>
    3060385022U, // <6,1,0,7>: Cost 3 vtrnl <6,7,0,1>, <1,6,7,0>
    2047623275U, // <6,1,0,u>: Cost 2 vtrnr <5,6,7,0>, LHS
    2578088038U, // <6,1,1,0>: Cost 3 vext1 <4,6,1,1>, LHS
    2128896000U, // <6,1,1,1>: Cost 2 ins <u,1,1,1>, lane 0
    2981778426U, // <6,1,1,2>: Cost 3 vzipr <4,7,6,1>, <7,0,1,2>
    2128912384U, // <6,1,1,3>: Cost 2 ins <u,1,1,3>, lane 0
    2691334996U, // <6,1,1,4>: Cost 3 vext3 <1,1,4,6>, <1,1,4,6>
    3202670592U, // <6,1,1,5>: Cost 3 ins <u,1,1,5>, lane 0
    2691482470U, // <6,1,1,6>: Cost 3 vext3 <1,1,6,6>, <1,1,6,6>
    2980449545U, // <6,1,1,7>: Cost 3 vzipr <4,5,6,1>, <4,5,1,7>
    2128896000U, // <6,1,1,u>: Cost 2 ins <u,1,1,1>, lane 0
    2128961536U, // <6,1,2,0>: Cost 2 ins <u,1,2,0>, lane 0
    2128969728U, // <6,1,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    2128977920U, // <6,1,2,2>: Cost 2 ins <u,1,2,2>, lane 0
    1055244288U, // <6,1,2,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <6,1,2,4>: Cost 2 ins <u,1,2,4>, lane 0
    2129002496U, // <6,1,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2129010688U, // <6,1,2,6>: Cost 2 ins <u,1,2,6>, lane 0
    2129018880U, // <6,1,2,7>: Cost 2 ins <u,1,2,7>, lane 0
    1055244288U, // <6,1,2,u>: Cost 1 ins LHS, lane 0
    2566160486U, // <6,1,3,0>: Cost 3 vext1 <2,6,1,3>, LHS
    2686026712U, // <6,1,3,1>: Cost 3 vext3 <0,2,4,6>, <1,3,1,3>
    2686026724U, // <6,1,3,2>: Cost 3 vext3 <0,2,4,6>, <1,3,2,6>
    2129059840U, // <6,1,3,3>: Cost 2 ins <u,1,3,3>, lane 0
    2692662262U, // <6,1,3,4>: Cost 3 vext3 <1,3,4,6>, <1,3,4,6>
    2686026752U, // <6,1,3,5>: Cost 3 vext3 <0,2,4,6>, <1,3,5,7>
    2590053128U, // <6,1,3,6>: Cost 3 vext1 <6,6,1,3>, <6,6,1,3>
    2953923849U, // <6,1,3,7>: Cost 3 vzipr <0,1,6,3>, <4,5,1,7>
    2129059840U, // <6,1,3,u>: Cost 2 ins <u,1,3,3>, lane 0
    2788724044U, // <6,1,4,0>: Cost 3 vuzpl <6,2,1,3>, <4,6,0,2>
    2693104684U, // <6,1,4,1>: Cost 3 vext3 <1,4,1,6>, <1,4,1,6>
    3195568129U, // <6,1,4,2>: Cost 3 ins <6,u,4,2>, lane 1
    2047656038U, // <6,1,4,3>: Cost 2 vtrnr <5,6,7,4>, LHS
    2791378292U, // <6,1,4,4>: Cost 3 vuzpl <6,6,1,3>, <4,6,4,6>
    2121850881U, // <6,1,4,5>: Cost 2 ins <6,u,4,5>, lane 1
    2834506076U, // <6,1,4,6>: Cost 3 vuzpr <2,6,0,1>, <0,4,2,6>
    2646232530U, // <6,1,4,7>: Cost 3 vext2 <4,7,6,1>, <4,7,6,1>
    2047656043U, // <6,1,4,u>: Cost 2 vtrnr <5,6,7,4>, LHS
    2578120806U, // <6,1,5,0>: Cost 3 vext1 <4,6,1,5>, LHS
    2578121728U, // <6,1,5,1>: Cost 3 vext1 <4,6,1,5>, <1,3,5,7>
    3202940928U, // <6,1,5,2>: Cost 3 ins <u,1,5,2>, lane 0
    2129207296U, // <6,1,5,3>: Cost 2 ins <u,1,5,3>, lane 0
    2693989528U, // <6,1,5,4>: Cost 3 vext3 <1,5,4,6>, <1,5,4,6>
    3202965504U, // <6,1,5,5>: Cost 3 ins <u,1,5,5>, lane 0
    2652868706U, // <6,1,5,6>: Cost 3 vext2 <5,u,6,1>, <5,6,7,0>
    2834509110U, // <6,1,5,7>: Cost 3 vuzpr <2,6,0,1>, RHS
    2129207296U, // <6,1,5,u>: Cost 2 ins <u,1,5,3>, lane 0
    2925986550U, // <6,1,6,0>: Cost 3 vzipl <6,6,6,6>, <1,0,3,2>
    2834507673U, // <6,1,6,1>: Cost 3 vuzpr <2,6,0,1>, <2,6,0,1>
    2982480022U, // <6,1,6,2>: Cost 3 vzipr <4,u,6,6>, <3,0,1,2>
    2041479270U, // <6,1,6,3>: Cost 2 vtrnr <4,6,4,6>, LHS
    2602020150U, // <6,1,6,4>: Cost 3 vext1 <u,6,1,6>, RHS
    2982478162U, // <6,1,6,5>: Cost 3 vzipr <4,u,6,6>, <0,4,1,5>
    2122006529U, // <6,1,6,6>: Cost 2 ins <6,u,6,6>, lane 1
    2129313792U, // <6,1,6,7>: Cost 2 ins <u,1,6,7>, lane 0
    2041479275U, // <6,1,6,u>: Cost 2 vtrnr <4,6,4,6>, LHS
    2560221286U, // <6,1,7,0>: Cost 3 vext1 <1,6,1,7>, LHS
    1906753546U, // <6,1,7,1>: Cost 2 vzipr RHS, <0,0,1,1>
    1906755734U, // <6,1,7,2>: Cost 2 vzipr RHS, <3,0,1,2>
    2029469798U, // <6,1,7,3>: Cost 2 vtrnr <2,6,3,7>, LHS
    2560224566U, // <6,1,7,4>: Cost 3 vext1 <1,6,1,7>, RHS
    1906753874U, // <6,1,7,5>: Cost 2 vzipr RHS, <0,4,1,5>
    2980495537U, // <6,1,7,6>: Cost 3 vzipr RHS, <0,2,1,6>
    2122088449U, // <6,1,7,7>: Cost 2 ins <6,u,7,7>, lane 1
    2029469803U, // <6,1,7,u>: Cost 2 vtrnr <2,6,3,7>, LHS
    2128961536U, // <6,1,u,0>: Cost 2 ins <u,1,2,0>, lane 0
    1906761738U, // <6,1,u,1>: Cost 2 vzipr RHS, <0,0,1,1>
    1906763926U, // <6,1,u,2>: Cost 2 vzipr RHS, <3,0,1,2>
    1055244288U, // <6,1,u,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <6,1,u,4>: Cost 2 ins <u,1,2,4>, lane 0
    1906762066U, // <6,1,u,5>: Cost 2 vzipr RHS, <0,4,1,5>
    2129010688U, // <6,1,u,6>: Cost 2 ins <u,1,2,6>, lane 0
    2122088449U, // <6,1,u,7>: Cost 2 ins <6,u,7,7>, lane 1
    1055244288U, // <6,1,u,u>: Cost 1 ins LHS, lane 0
    2846457856U, // <6,2,0,0>: Cost 3 vuzpr <4,6,0,2>, <0,0,0,0>
    1573159014U, // <6,2,0,1>: Cost 2 vext2 <4,u,6,2>, LHS
    2129494016U, // <6,2,0,2>: Cost 2 ins <u,2,0,2>, lane 0
    2118148098U, // <6,2,0,3>: Cost 2 ins <6,2,u,3>, lane 2
    2641592668U, // <6,2,0,4>: Cost 3 vext2 <4,0,6,2>, <0,4,2,6>
    3195297793U, // <6,2,0,5>: Cost 3 ins <6,u,0,5>, lane 1
    2686027244U, // <6,2,0,6>: Cost 3 vext3 <0,2,4,6>, <2,0,6,4>
    3195314177U, // <6,2,0,7>: Cost 3 ins <6,u,0,7>, lane 1
    1573159581U, // <6,2,0,u>: Cost 2 vext2 <4,u,6,2>, LHS
    2230527897U, // <6,2,1,0>: Cost 3 vrev <2,6,0,1>
    2846458676U, // <6,2,1,1>: Cost 3 vuzpr <4,6,0,2>, <1,1,1,1>
    2646901654U, // <6,2,1,2>: Cost 3 vext2 <4,u,6,2>, <1,2,3,0>
    1772716134U, // <6,2,1,3>: Cost 2 vuzpr <4,6,0,2>, LHS
    3191414787U, // <6,2,1,4>: Cost 3 ins <6,2,1,u>, lane 3
    2646901904U, // <6,2,1,5>: Cost 3 vext2 <4,u,6,2>, <1,5,3,7>
    3114885324U, // <6,2,1,6>: Cost 3 vtrnr <4,6,0,1>, <0,2,4,6>
    3191922690U, // <6,2,1,7>: Cost 3 ins <6,2,u,7>, lane 2
    1772716139U, // <6,2,1,u>: Cost 2 vuzpr <4,6,0,2>, LHS
    2846458774U, // <6,2,2,0>: Cost 3 vuzpr <4,6,0,2>, <1,2,3,0>
    3195412481U, // <6,2,2,1>: Cost 3 ins <6,u,2,1>, lane 1
    2129641472U, // <6,2,2,2>: Cost 2 ins <u,2,2,2>, lane 0
    1908703334U, // <6,2,2,3>: Cost 2 vzipr <4,u,6,2>, LHS
    2697971326U, // <6,2,2,4>: Cost 3 vext3 <2,2,4,6>, <2,2,4,6>
    3195445249U, // <6,2,2,5>: Cost 3 ins <6,u,2,5>, lane 1
    2698118800U, // <6,2,2,6>: Cost 3 vext3 <2,2,6,6>, <2,2,6,6>
    2846462444U, // <6,2,2,7>: Cost 3 vuzpr <4,6,0,2>, <6,2,5,7>
    1908703339U, // <6,2,2,u>: Cost 2 vzipr <4,u,6,2>, LHS
    2129698816U, // <6,2,3,0>: Cost 2 ins <u,2,3,0>, lane 0
    2230618020U, // <6,2,3,1>: Cost 3 vrev <2,6,1,3>
    2698487485U, // <6,2,3,2>: Cost 3 vext3 <2,3,2,6>, <2,3,2,6>
    2129723392U, // <6,2,3,3>: Cost 2 ins <u,2,3,3>, lane 0
    2129731584U, // <6,2,3,4>: Cost 2 ins <u,2,3,4>, lane 0
    2846459598U, // <6,2,3,5>: Cost 3 vuzpr <4,6,0,2>, <2,3,4,5>
    2966528348U, // <6,2,3,6>: Cost 3 vzipr <2,2,6,3>, <0,4,2,6>
    2846458880U, // <6,2,3,7>: Cost 3 vuzpr <4,6,0,2>, <1,3,5,7>
    2129698816U, // <6,2,3,u>: Cost 2 ins <u,2,3,0>, lane 0
    1567853468U, // <6,2,4,0>: Cost 2 vext2 <4,0,6,2>, <4,0,6,2>
    3191873538U, // <6,2,4,1>: Cost 3 ins <6,2,u,1>, lane 2
    2699151118U, // <6,2,4,2>: Cost 3 vext3 <2,4,2,6>, <2,4,2,6>
    2118148098U, // <6,2,4,3>: Cost 2 ins <6,2,u,3>, lane 2
    2699298592U, // <6,2,4,4>: Cost 3 vext3 <2,4,4,6>, <2,4,4,6>
    1573162294U, // <6,2,4,5>: Cost 2 vext2 <4,u,6,2>, RHS
    2129821696U, // <6,2,4,6>: Cost 2 ins <u,2,4,6>, lane 0
    3195609089U, // <6,2,4,7>: Cost 3 ins <6,u,4,7>, lane 1
    1573162532U, // <6,2,4,u>: Cost 2 vext2 <4,u,6,2>, <4,u,6,2>
    3191709699U, // <6,2,5,0>: Cost 3 ins <6,2,5,u>, lane 3
    2646904528U, // <6,2,5,1>: Cost 3 vext2 <4,u,6,2>, <5,1,7,3>
    3203604480U, // <6,2,5,2>: Cost 3 ins <u,2,5,2>, lane 0
    2118148098U, // <6,2,5,3>: Cost 2 ins <6,2,u,3>, lane 2
    2230855617U, // <6,2,5,4>: Cost 3 vrev <2,6,4,5>
    2846461956U, // <6,2,5,5>: Cost 3 vuzpr <4,6,0,2>, <5,5,5,5>
    3115213004U, // <6,2,5,6>: Cost 3 vtrnr <4,6,4,5>, <0,2,4,6>
    1772719414U, // <6,2,5,7>: Cost 2 vuzpr <4,6,0,2>, RHS
    1772719415U, // <6,2,5,u>: Cost 2 vuzpr <4,6,0,2>, RHS
    2687207321U, // <6,2,6,0>: Cost 3 vext3 <0,4,2,6>, <2,6,0,1>
    3195707393U, // <6,2,6,1>: Cost 3 ins <6,u,6,1>, lane 1
    1772719436U, // <6,2,6,2>: Cost 2 vuzpr <4,6,0,2>, <4,6,0,2>
    1908736102U, // <6,2,6,3>: Cost 2 vzipr <4,u,6,6>, LHS
    2687207361U, // <6,2,6,4>: Cost 3 vext3 <0,4,2,6>, <2,6,4,5>
    3195740161U, // <6,2,6,5>: Cost 3 ins <6,u,6,5>, lane 1
    2122006529U, // <6,2,6,6>: Cost 2 ins <6,u,6,6>, lane 1
    2118189061U, // <6,2,6,7>: Cost 2 ins <6,2,u,u>, lane 5
    1908736107U, // <6,2,6,u>: Cost 2 vzipr <4,u,6,6>, LHS
    2118115331U, // <6,2,7,0>: Cost 2 ins <6,2,7,u>, lane 3
    2118115331U, // <6,2,7,1>: Cost 2 ins <6,2,7,u>, lane 3
    1906753556U, // <6,2,7,2>: Cost 2 vzipr RHS, <0,0,2,2>
    833011814U,  // <6,2,7,3>: Cost 1 vzipr RHS, LHS
    2118115331U, // <6,2,7,4>: Cost 2 ins <6,2,7,u>, lane 3
    2118115331U, // <6,2,7,5>: Cost 2 ins <6,2,7,u>, lane 3
    1906753884U, // <6,2,7,6>: Cost 2 vzipr RHS, <0,4,2,6>
    2122088449U, // <6,2,7,7>: Cost 2 ins <6,u,7,7>, lane 1
    833011819U,  // <6,2,7,u>: Cost 1 vzipr RHS, LHS
    2129698816U, // <6,2,u,0>: Cost 2 ins <u,2,3,0>, lane 0
    1573164846U, // <6,2,u,1>: Cost 2 vext2 <4,u,6,2>, LHS
    1906761748U, // <6,2,u,2>: Cost 2 vzipr RHS, <0,0,2,2>
    833020006U,  // <6,2,u,3>: Cost 1 vzipr RHS, LHS
    2129731584U, // <6,2,u,4>: Cost 2 ins <u,2,3,4>, lane 0
    1573165210U, // <6,2,u,5>: Cost 2 vext2 <4,u,6,2>, RHS
    1906762076U, // <6,2,u,6>: Cost 2 vzipr RHS, <0,4,2,6>
    1772719657U, // <6,2,u,7>: Cost 2 vuzpr <4,6,0,2>, RHS
    833020011U,  // <6,2,u,u>: Cost 1 vzipr RHS, LHS
    3203883008U, // <6,3,0,0>: Cost 3 ins <u,3,0,0>, lane 0
    2130149376U, // <6,3,0,1>: Cost 2 ins <u,3,0,1>, lane 0
    2686027937U, // <6,3,0,2>: Cost 3 vext3 <0,2,4,6>, <3,0,2,4>
    3121365976U, // <6,3,0,3>: Cost 3 vtrnr <5,6,7,0>, <1,3,1,3>
    2687207601U, // <6,3,0,4>: Cost 3 vext3 <0,4,2,6>, <3,0,4,2>
    3121366734U, // <6,3,0,5>: Cost 3 vtrnr <5,6,7,0>, <2,3,4,5>
    3195305985U, // <6,3,0,6>: Cost 3 ins <6,u,0,6>, lane 1
    3121366016U, // <6,3,0,7>: Cost 3 vtrnr <5,6,7,0>, <1,3,5,7>
    2130149376U, // <6,3,0,u>: Cost 2 ins <u,3,0,1>, lane 0
    2578235494U, // <6,3,1,0>: Cost 3 vext1 <4,6,3,1>, LHS
    3203964928U, // <6,3,1,1>: Cost 3 ins <u,3,1,1>, lane 0
    3203973120U, // <6,3,1,2>: Cost 3 ins <u,3,1,2>, lane 0
    2130239488U, // <6,3,1,3>: Cost 2 ins <u,3,1,3>, lane 0
    2703280390U, // <6,3,1,4>: Cost 3 vext3 <3,1,4,6>, <3,1,4,6>
    3203997696U, // <6,3,1,5>: Cost 3 ins <u,3,1,5>, lane 0
    2822725737U, // <6,3,1,6>: Cost 3 vuzpr <0,6,2,3>, <0,1,2,6>
    2970494906U, // <6,3,1,7>: Cost 3 vzipr <2,u,6,1>, <2,6,3,7>
    2130239488U, // <6,3,1,u>: Cost 2 ins <u,3,1,3>, lane 0
    2982445974U, // <6,3,2,0>: Cost 3 vzipr <4,u,6,2>, <1,2,3,0>
    2630321724U, // <6,3,2,1>: Cost 3 vext2 <2,1,6,3>, <2,1,6,3>
    2630985357U, // <6,3,2,2>: Cost 3 vext2 <2,2,6,3>, <2,2,6,3>
    2130313216U, // <6,3,2,3>: Cost 2 ins <u,3,2,3>, lane 0
    2982445978U, // <6,3,2,4>: Cost 3 vzipr <4,u,6,2>, <1,2,3,4>
    3114895054U, // <6,3,2,5>: Cost 3 vtrnr <4,6,0,2>, <2,3,4,5>
    2834596044U, // <6,3,2,6>: Cost 3 vuzpr <2,6,1,3>, <0,2,4,6>
    3114894336U, // <6,3,2,7>: Cost 3 vtrnr <4,6,0,2>, <1,3,5,7>
    2130313216U, // <6,3,2,u>: Cost 2 ins <u,3,2,3>, lane 0
    2578251878U, // <6,3,3,0>: Cost 3 vext1 <4,6,3,3>, LHS
    2792163478U, // <6,3,3,1>: Cost 3 vuzpl <6,7,3,0>, <3,0,1,2>
    2636958054U, // <6,3,3,2>: Cost 3 vext2 <3,2,6,3>, <3,2,6,3>
    2130386944U, // <6,3,3,3>: Cost 2 ins <u,3,3,3>, lane 0
    2704607656U, // <6,3,3,4>: Cost 3 vext3 <3,3,4,6>, <3,3,4,6>
    2792196610U, // <6,3,3,5>: Cost 3 vuzpl <6,7,3,4>, <3,4,5,6>
    2590200602U, // <6,3,3,6>: Cost 3 vext1 <6,6,3,3>, <6,6,3,3>
    2972501946U, // <6,3,3,7>: Cost 3 vzipr <3,2,6,3>, <2,6,3,7>
    2130386944U, // <6,3,3,u>: Cost 2 ins <u,3,3,3>, lane 0
    2584232038U, // <6,3,4,0>: Cost 3 vext1 <5,6,3,4>, LHS
    2705050078U, // <6,3,4,1>: Cost 3 vext3 <3,4,1,6>, <3,4,1,6>
    2642930751U, // <6,3,4,2>: Cost 3 vext2 <4,2,6,3>, <4,2,6,3>
    2705197552U, // <6,3,4,3>: Cost 3 vext3 <3,4,3,6>, <3,4,3,6>
    2584235318U, // <6,3,4,4>: Cost 3 vext1 <5,6,3,4>, RHS
    1631603202U, // <6,3,4,5>: Cost 2 vext3 <3,4,5,6>, <3,4,5,6>
    2846540124U, // <6,3,4,6>: Cost 3 vuzpr <4,6,1,3>, <0,4,2,6>
    3121398784U, // <6,3,4,7>: Cost 3 vtrnr <5,6,7,4>, <1,3,5,7>
    1631824413U, // <6,3,4,u>: Cost 2 vext3 <3,4,u,6>, <3,4,u,6>
    2578268262U, // <6,3,5,0>: Cost 3 vext1 <4,6,3,5>, LHS
    3204259840U, // <6,3,5,1>: Cost 3 ins <u,3,5,1>, lane 0
    2648903448U, // <6,3,5,2>: Cost 3 vext2 <5,2,6,3>, <5,2,6,3>
    2578270722U, // <6,3,5,3>: Cost 3 vext1 <4,6,3,5>, <3,4,5,6>
    2705934922U, // <6,3,5,4>: Cost 3 vext3 <3,5,4,6>, <3,5,4,6>
    3204292608U, // <6,3,5,5>: Cost 3 ins <u,3,5,5>, lane 0
    3204300800U, // <6,3,5,6>: Cost 3 ins <u,3,5,6>, lane 0
    2130567168U, // <6,3,5,7>: Cost 2 ins <u,3,5,7>, lane 0
    2130567168U, // <6,3,5,u>: Cost 2 ins <u,3,5,7>, lane 0
    2982478742U, // <6,3,6,0>: Cost 3 vzipr <4,u,6,6>, <1,2,3,0>
    3115222694U, // <6,3,6,1>: Cost 3 vtrnr <4,6,4,6>, <2,3,0,1>
    2982478582U, // <6,3,6,2>: Cost 3 vzipr <4,u,6,6>, <1,0,3,2>
    1748984315U, // <6,3,6,3>: Cost 2 vuzpr <0,6,2,3>, <0,6,2,3>
    2982478746U, // <6,3,6,4>: Cost 3 vzipr <4,u,6,6>, <1,2,3,4>
    3115222734U, // <6,3,6,5>: Cost 3 vtrnr <4,6,4,6>, <2,3,4,5>
    2122006529U, // <6,3,6,6>: Cost 2 ins <6,u,6,6>, lane 1
    2130640896U, // <6,3,6,7>: Cost 2 ins <u,3,6,7>, lane 0
    1748984315U, // <6,3,6,u>: Cost 2 vuzpr <0,6,2,3>, <0,6,2,3>
    1492598886U, // <6,3,7,0>: Cost 2 vext1 <2,6,3,7>, LHS
    2560369889U, // <6,3,7,1>: Cost 3 vext1 <1,6,3,7>, <1,6,3,7>
    1492600762U, // <6,3,7,2>: Cost 2 vext1 <2,6,3,7>, <2,6,3,7>
    1906754376U, // <6,3,7,3>: Cost 2 vzipr RHS, <1,1,3,3>
    1492602166U, // <6,3,7,4>: Cost 2 vext1 <2,6,3,7>, RHS
    3103213262U, // <6,3,7,5>: Cost 3 vtrnr <2,6,3,7>, <2,3,4,5>
    2566345210U, // <6,3,7,6>: Cost 3 vext1 <2,6,3,7>, <6,2,7,3>
    1906754704U, // <6,3,7,7>: Cost 2 vzipr RHS, <1,5,3,7>
    1492604718U, // <6,3,7,u>: Cost 2 vext1 <2,6,3,7>, LHS
    1492607078U, // <6,3,u,0>: Cost 2 vext1 <2,6,3,u>, LHS
    2130149376U, // <6,3,u,1>: Cost 2 ins <u,3,0,1>, lane 0
    1492608955U, // <6,3,u,2>: Cost 2 vext1 <2,6,3,u>, <2,6,3,u>
    1906762568U, // <6,3,u,3>: Cost 2 vzipr RHS, <1,1,3,3>
    1492610358U, // <6,3,u,4>: Cost 2 vext1 <2,6,3,u>, RHS
    1634257734U, // <6,3,u,5>: Cost 2 vext3 <3,u,5,6>, <3,u,5,6>
    2122006529U, // <6,3,u,6>: Cost 2 ins <6,u,6,6>, lane 1
    1906762896U, // <6,3,u,7>: Cost 2 vzipr RHS, <1,5,3,7>
    1492612910U, // <6,3,u,u>: Cost 2 vext1 <2,6,3,u>, LHS
    2242465098U, // <6,4,0,0>: Cost 3 vrev <4,6,0,0>
    2121523201U, // <6,4,0,1>: Cost 2 ins <6,u,0,1>, lane 1
    1718534246U, // <6,4,0,2>: Cost 2 vuzpl <6,7,4,5>, LHS
    3195281409U, // <6,4,0,3>: Cost 3 ins <6,u,0,3>, lane 1
    2642936156U, // <6,4,0,4>: Cost 3 vext2 <4,2,6,4>, <0,4,2,6>
    2712570770U, // <6,4,0,5>: Cost 3 vext3 <4,6,4,6>, <4,0,5,1>
    1986645302U, // <6,4,0,6>: Cost 2 vtrnl <6,7,0,1>, RHS
    3195314177U, // <6,4,0,7>: Cost 3 ins <6,u,0,7>, lane 1
    1986645320U, // <6,4,0,u>: Cost 2 vtrnl <6,7,0,1>, RHS
    2242473291U, // <6,4,1,0>: Cost 3 vrev <4,6,0,1>
    2242547028U, // <6,4,1,1>: Cost 3 vrev <4,6,1,1>
    3204636672U, // <6,4,1,2>: Cost 3 ins <u,4,1,2>, lane 0
    1779220582U, // <6,4,1,3>: Cost 2 vuzpr <5,6,7,4>, LHS
    3059813748U, // <6,4,1,4>: Cost 3 vtrnl <6,6,1,3>, <4,6,4,6>
    2130919424U, // <6,4,1,5>: Cost 2 ins <u,4,1,5>, lane 0
    3102941532U, // <6,4,1,6>: Cost 3 vtrnr <2,6,0,1>, <0,4,2,6>
    2242989450U, // <6,4,1,7>: Cost 3 vrev <4,6,7,1>
    1779220587U, // <6,4,1,u>: Cost 2 vuzpr <5,6,7,4>, LHS
    1168739660U, // <6,4,2,0>: Cost 2 vrev <4,6,0,2>
    3195412481U, // <6,4,2,1>: Cost 3 ins <6,u,2,1>, lane 1
    2242628958U, // <6,4,2,2>: Cost 3 vrev <4,6,2,2>
    2130976768U, // <6,4,2,3>: Cost 2 ins <u,4,2,3>, lane 0
    2632320816U, // <6,4,2,4>: Cost 3 vext2 <2,4,6,4>, <2,4,6,4>
    1849642294U, // <6,4,2,5>: Cost 2 vzipl <6,2,7,3>, RHS
    2131001344U, // <6,4,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    3195461633U, // <6,4,2,7>: Cost 3 ins <6,u,2,7>, lane 1
    1169329556U, // <6,4,2,u>: Cost 2 vrev <4,6,u,2>
    3195478017U, // <6,4,3,0>: Cost 3 ins <6,u,3,0>, lane 1
    2242563414U, // <6,4,3,1>: Cost 3 vrev <4,6,1,3>
    2242637151U, // <6,4,3,2>: Cost 3 vrev <4,6,2,3>
    2242710888U, // <6,4,3,3>: Cost 3 vrev <4,6,3,3>
    2644929026U, // <6,4,3,4>: Cost 3 vext2 <4,5,6,4>, <3,4,5,6>
    2846623438U, // <6,4,3,5>: Cost 3 vuzpr <4,6,2,4>, <2,3,4,5>
    2965864652U, // <6,4,3,6>: Cost 3 vzipr <2,1,6,3>, <0,2,4,6>
    2852963328U, // <6,4,3,7>: Cost 3 vuzpr <5,6,7,4>, <1,3,5,7>
    2243079573U, // <6,4,3,u>: Cost 3 vrev <4,6,u,3>
    2242497870U, // <6,4,4,0>: Cost 3 vrev <4,6,0,4>
    2852967732U, // <6,4,4,1>: Cost 3 vuzpr <5,6,7,4>, <7,4,0,1>
    2642938944U, // <6,4,4,2>: Cost 3 vext2 <4,2,6,4>, <4,2,6,4>
    2852967014U, // <6,4,4,3>: Cost 3 vuzpr <5,6,7,4>, <6,4,1,3>
    2131132416U, // <6,4,4,4>: Cost 2 ins <u,4,4,4>, lane 0
    2121850881U, // <6,4,4,5>: Cost 2 ins <6,u,4,5>, lane 1
    1718537526U, // <6,4,4,6>: Cost 2 vuzpl <6,7,4,5>, RHS
    2852967054U, // <6,4,4,7>: Cost 3 vuzpr <5,6,7,4>, <6,4,5,7>
    1718537544U, // <6,4,4,u>: Cost 2 vuzpl <6,7,4,5>, RHS
    2566398054U, // <6,4,5,0>: Cost 3 vext1 <2,6,4,5>, LHS
    2242579800U, // <6,4,5,1>: Cost 3 vrev <4,6,1,5>
    2566399937U, // <6,4,5,2>: Cost 3 vext1 <2,6,4,5>, <2,6,4,5>
    2242727274U, // <6,4,5,3>: Cost 3 vrev <4,6,3,5>
    2566401334U, // <6,4,5,4>: Cost 3 vext1 <2,6,4,5>, RHS
    2131214336U, // <6,4,5,5>: Cost 2 ins <u,4,5,5>, lane 0
    1612287286U, // <6,4,5,6>: Cost 2 vext3 <0,2,4,6>, RHS
    1779223862U, // <6,4,5,7>: Cost 2 vuzpr <5,6,7,4>, RHS
    1612287304U, // <6,4,5,u>: Cost 2 vext3 <0,2,4,6>, RHS
    1504608358U, // <6,4,6,0>: Cost 2 vext1 <4,6,4,6>, LHS
    2578350838U, // <6,4,6,1>: Cost 3 vext1 <4,6,4,6>, <1,0,3,2>
    2578351720U, // <6,4,6,2>: Cost 3 vext1 <4,6,4,6>, <2,2,2,2>
    2578352278U, // <6,4,6,3>: Cost 3 vext1 <4,6,4,6>, <3,0,1,2>
    1169067380U, // <6,4,6,4>: Cost 2 vrev <4,6,4,6>
    1852247350U, // <6,4,6,5>: Cost 2 vzipl <6,6,6,6>, RHS
    1986465078U, // <6,4,6,6>: Cost 2 vtrnl <6,6,6,6>, RHS
    2131304448U, // <6,4,6,7>: Cost 2 ins <u,4,6,7>, lane 0
    1504614190U, // <6,4,6,u>: Cost 2 vext1 <4,6,4,6>, LHS
    2572386406U, // <6,4,7,0>: Cost 3 vext1 <3,6,4,7>, LHS
    2572387226U, // <6,4,7,1>: Cost 3 vext1 <3,6,4,7>, <1,2,3,4>
    2980495398U, // <6,4,7,2>: Cost 3 vzipr RHS, <0,0,4,2>
    2122055681U, // <6,4,7,3>: Cost 2 ins <6,u,7,3>, lane 1
    1906756816U, // <6,4,7,4>: Cost 2 vzipr RHS, <4,4,4,4>
    1906755278U, // <6,4,7,5>: Cost 2 vzipr RHS, <2,3,4,5>
    1906753740U, // <6,4,7,6>: Cost 2 vzipr RHS, <0,2,4,6>
    2122088449U, // <6,4,7,7>: Cost 2 ins <6,u,7,7>, lane 1
    1906753742U, // <6,4,7,u>: Cost 2 vzipr RHS, <0,2,4,u>
    1168788818U, // <6,4,u,0>: Cost 2 vrev <4,6,0,u>
    2121523201U, // <6,4,u,1>: Cost 2 ins <6,u,0,1>, lane 1
    1718540078U, // <6,4,u,2>: Cost 2 vuzpl <6,7,4,5>, LHS
    1779221149U, // <6,4,u,3>: Cost 2 vuzpr <5,6,7,4>, LHS
    1906765008U, // <6,4,u,4>: Cost 2 vzipr RHS, <4,4,4,4>
    1906763470U, // <6,4,u,5>: Cost 2 vzipr RHS, <2,3,4,5>
    1612287529U, // <6,4,u,6>: Cost 2 vext3 <0,2,4,6>, RHS
    1779224105U, // <6,4,u,7>: Cost 2 vuzpr <5,6,7,4>, RHS
    1612287547U, // <6,4,u,u>: Cost 2 vext3 <0,2,4,6>, RHS
    3195256833U, // <6,5,0,0>: Cost 3 ins <6,u,0,0>, lane 1
    2121523201U, // <6,5,0,1>: Cost 2 ins <6,u,0,1>, lane 1
    2787721318U, // <6,5,0,2>: Cost 3 vuzpl <6,0,5,7>, LHS
    3195281409U, // <6,5,0,3>: Cost 3 ins <6,u,0,3>, lane 1
    2790367436U, // <6,5,0,4>: Cost 3 vuzpl <6,4,5,6>, <0,2,4,6>
    3121369092U, // <6,5,0,5>: Cost 3 vtrnr <5,6,7,0>, <5,5,5,5>
    2980440578U, // <6,5,0,6>: Cost 3 vzipr <4,5,6,0>, <3,4,5,6>
    1175212130U, // <6,5,0,7>: Cost 2 vrev <5,6,7,0>
    2047626551U, // <6,5,0,u>: Cost 2 vtrnr <5,6,7,0>, RHS
    2578382950U, // <6,5,1,0>: Cost 3 vext1 <4,6,5,1>, LHS
    3205292032U, // <6,5,1,1>: Cost 3 ins <u,5,1,1>, lane 0
    3195346945U, // <6,5,1,2>: Cost 3 ins <6,u,1,2>, lane 1
    2834833510U, // <6,5,1,3>: Cost 3 vuzpr <2,6,4,5>, LHS
    2578386296U, // <6,5,1,4>: Cost 3 vext1 <4,6,5,1>, <4,6,5,1>
    2578387072U, // <6,5,1,5>: Cost 3 vext1 <4,6,5,1>, <5,7,1,3>
    2922205282U, // <6,5,1,6>: Cost 3 vzipl <6,1,0,3>, <5,6,7,0>
    2131599360U, // <6,5,1,7>: Cost 2 ins <u,5,1,7>, lane 0
    2131599360U, // <6,5,1,u>: Cost 2 ins <u,5,1,7>, lane 0
    2578391142U, // <6,5,2,0>: Cost 3 vext1 <4,6,5,2>, LHS
    2982448018U, // <6,5,2,1>: Cost 3 vzipr <4,u,6,2>, <4,0,5,1>
    3195420673U, // <6,5,2,2>: Cost 3 ins <6,u,2,2>, lane 1
    2131640320U, // <6,5,2,3>: Cost 2 ins <u,5,2,3>, lane 0
    2578394489U, // <6,5,2,4>: Cost 3 vext1 <4,6,5,2>, <4,6,5,2>
    3114897412U, // <6,5,2,5>: Cost 3 vtrnr <4,6,0,2>, <5,5,5,5>
    2634983354U, // <6,5,2,6>: Cost 3 vext2 <2,u,6,5>, <2,6,3,7>
    2041154870U, // <6,5,2,7>: Cost 2 vtrnr <4,6,0,2>, RHS
    2041154871U, // <6,5,2,u>: Cost 2 vtrnr <4,6,0,2>, RHS
    3195478017U, // <6,5,3,0>: Cost 3 ins <6,u,3,0>, lane 1
    3205439488U, // <6,5,3,1>: Cost 3 ins <u,5,3,1>, lane 0
    3091164465U, // <6,5,3,2>: Cost 3 vtrnr <0,6,2,3>, <4,5,6,2>
    3195502593U, // <6,5,3,3>: Cost 3 ins <6,u,3,3>, lane 1
    2643610114U, // <6,5,3,4>: Cost 3 vext2 <4,3,6,5>, <3,4,5,6>
    3205472256U, // <6,5,3,5>: Cost 3 ins <u,5,3,5>, lane 0
    2980465154U, // <6,5,3,6>: Cost 3 vzipr <4,5,6,3>, <3,4,5,6>
    2131746816U, // <6,5,3,7>: Cost 2 ins <u,5,3,7>, lane 0
    2131746816U, // <6,5,3,u>: Cost 2 ins <u,5,3,7>, lane 0
    2789051724U, // <6,5,4,0>: Cost 3 vuzpl <6,2,5,7>, <4,6,0,2>
    3060715648U, // <6,5,4,1>: Cost 3 vtrnl <6,7,4,5>, <5,7,1,3>
    3195568129U, // <6,5,4,2>: Cost 3 ins <6,u,4,2>, lane 1
    2643610770U, // <6,5,4,3>: Cost 3 vext2 <4,3,6,5>, <4,3,6,5>
    2791705972U, // <6,5,4,4>: Cost 3 vuzpl <6,6,5,7>, <4,6,4,6>
    2121850881U, // <6,5,4,5>: Cost 2 ins <6,u,4,5>, lane 1
    2834833756U, // <6,5,4,6>: Cost 3 vuzpr <2,6,4,5>, <0,4,2,6>
    1643696070U, // <6,5,4,7>: Cost 2 vext3 <5,4,7,6>, <5,4,7,6>
    1643769807U, // <6,5,4,u>: Cost 2 vext3 <5,4,u,6>, <5,4,u,6>
    2578415718U, // <6,5,5,0>: Cost 3 vext1 <4,6,5,5>, LHS
    3006363382U, // <6,5,5,1>: Cost 3 vzipr <u,u,6,5>, <u,0,5,1>
    3205595136U, // <6,5,5,2>: Cost 3 ins <u,5,5,2>, lane 0
    2980479105U, // <6,5,5,3>: Cost 3 vzipr <4,5,6,5>, <0,1,5,3>
    2578419068U, // <6,5,5,4>: Cost 3 vext1 <4,6,5,5>, <4,6,5,5>
    2131877888U, // <6,5,5,5>: Cost 2 ins <u,5,5,5>, lane 0
    2979154434U, // <6,5,5,6>: Cost 3 vzipr <4,3,6,5>, <3,4,5,6>
    2131894272U, // <6,5,5,7>: Cost 2 ins <u,5,5,7>, lane 0
    2131877888U, // <6,5,5,u>: Cost 2 ins <u,5,5,5>, lane 0
    2131910656U, // <6,5,6,0>: Cost 2 ins <u,5,6,0>, lane 0
    2131918848U, // <6,5,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2131927040U, // <6,5,6,2>: Cost 2 ins <u,5,6,2>, lane 0
    2131935232U, // <6,5,6,3>: Cost 2 ins <u,5,6,3>, lane 0
    2131943424U, // <6,5,6,4>: Cost 2 ins <u,5,6,4>, lane 0
    2131951616U, // <6,5,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    2131959808U, // <6,5,6,6>: Cost 2 ins <u,5,6,6>, lane 0
    1058226176U, // <6,5,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <6,5,6,u>: Cost 1 ins RHS, lane 0
    2560516198U, // <6,5,7,0>: Cost 3 vext1 <1,6,5,7>, LHS
    1906756498U, // <6,5,7,1>: Cost 2 vzipr RHS, <4,0,5,1>
    2566490060U, // <6,5,7,2>: Cost 3 vext1 <2,6,5,7>, <2,6,5,7>
    2122055681U, // <6,5,7,3>: Cost 2 ins <6,u,7,3>, lane 1
    2560519478U, // <6,5,7,4>: Cost 3 vext1 <1,6,5,7>, RHS
    1906756826U, // <6,5,7,5>: Cost 2 vzipr RHS, <4,4,5,5>
    1906756098U, // <6,5,7,6>: Cost 2 vzipr RHS, <3,4,5,6>
    2029473078U, // <6,5,7,7>: Cost 2 vtrnr <2,6,3,7>, RHS
    2029473079U, // <6,5,7,u>: Cost 2 vtrnr <2,6,3,7>, RHS
    2131910656U, // <6,5,u,0>: Cost 2 ins <u,5,6,0>, lane 0
    1906764690U, // <6,5,u,1>: Cost 2 vzipr RHS, <4,0,5,1>
    2131927040U, // <6,5,u,2>: Cost 2 ins <u,5,6,2>, lane 0
    2122055681U, // <6,5,u,3>: Cost 2 ins <6,u,7,3>, lane 1
    2131943424U, // <6,5,u,4>: Cost 2 ins <u,5,6,4>, lane 0
    1906765018U, // <6,5,u,5>: Cost 2 vzipr RHS, <4,4,5,5>
    1906764290U, // <6,5,u,6>: Cost 2 vzipr RHS, <3,4,5,6>
    1058226176U, // <6,5,u,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <6,5,u,u>: Cost 1 ins RHS, lane 0
    2047627362U, // <6,6,0,0>: Cost 2 vtrnr <5,6,7,0>, <5,6,7,0>
    1573191782U, // <6,6,0,1>: Cost 2 vext2 <4,u,6,6>, LHS
    1718026342U, // <6,6,0,2>: Cost 2 vuzpl <6,6,6,6>, LHS
    3195281409U, // <6,6,0,3>: Cost 3 ins <6,u,0,3>, lane 1
    2687209788U, // <6,6,0,4>: Cost 3 vext3 <0,4,2,6>, <6,0,4,2>
    3195297793U, // <6,6,0,5>: Cost 3 ins <6,u,0,5>, lane 1
    2120826882U, // <6,6,0,6>: Cost 2 ins <6,6,u,6>, lane 2
    2120835074U, // <6,6,0,7>: Cost 2 ins <6,6,u,7>, lane 2
    1573192349U, // <6,6,0,u>: Cost 2 vext2 <4,u,6,6>, LHS
    2646934262U, // <6,6,1,0>: Cost 3 vext2 <4,u,6,6>, <1,0,3,2>
    1906707760U, // <6,6,1,1>: Cost 2 vzipr <4,5,6,1>, <4,5,6,1>
    2646934422U, // <6,6,1,2>: Cost 3 vext2 <4,u,6,6>, <1,2,3,0>
    1773043814U, // <6,6,1,3>: Cost 2 vuzpr <4,6,4,6>, LHS
    3194068995U, // <6,6,1,4>: Cost 3 ins <6,6,1,u>, lane 3
    2646934672U, // <6,6,1,5>: Cost 3 vext2 <4,u,6,6>, <1,5,3,7>
    2120826882U, // <6,6,1,6>: Cost 2 ins <6,6,u,6>, lane 2
    2120835074U, // <6,6,1,7>: Cost 2 ins <6,6,u,7>, lane 2
    1773043819U, // <6,6,1,u>: Cost 2 vuzpr <4,6,4,6>, LHS
    3114896750U, // <6,6,2,0>: Cost 3 vtrnr <4,6,0,2>, <4,6,4,0>
    3195412481U, // <6,6,2,1>: Cost 3 ins <6,u,2,1>, lane 1
    2041154892U, // <6,6,2,2>: Cost 2 vtrnr <4,6,0,2>, <4,6,0,2>
    2120843269U, // <6,6,2,3>: Cost 2 ins <6,6,u,u>, lane 5
    3114897510U, // <6,6,2,4>: Cost 3 vtrnr <4,6,0,2>, <5,6,7,4>
    3195445249U, // <6,6,2,5>: Cost 3 ins <6,u,2,5>, lane 1
    2120826882U, // <6,6,2,6>: Cost 2 ins <6,6,u,6>, lane 2
    1908706614U, // <6,6,2,7>: Cost 2 vzipr <4,u,6,2>, RHS
    1908706615U, // <6,6,2,u>: Cost 2 vzipr <4,u,6,2>, RHS
    2646935702U, // <6,6,3,0>: Cost 3 vext2 <4,u,6,6>, <3,0,1,2>
    2846787238U, // <6,6,3,1>: Cost 3 vuzpr <4,6,4,6>, <2,3,0,1>
    3206111232U, // <6,6,3,2>: Cost 3 ins <u,6,3,2>, lane 0
    1880178826U, // <6,6,3,3>: Cost 2 vzipr <0,1,6,3>, <0,1,6,3>
    2705347122U, // <6,6,3,4>: Cost 3 vext3 <3,4,5,6>, <6,3,4,5>
    2846787278U, // <6,6,3,5>: Cost 3 vuzpr <4,6,4,6>, <2,3,4,5>
    2120826882U, // <6,6,3,6>: Cost 2 ins <6,6,u,6>, lane 2
    2132410368U, // <6,6,3,7>: Cost 2 ins <u,6,3,7>, lane 0
    2132410368U, // <6,6,3,u>: Cost 2 ins <u,6,3,7>, lane 0
    2846790288U, // <6,6,4,0>: Cost 3 vuzpr <4,6,4,6>, <6,4,6,0>
    3194527746U, // <6,6,4,1>: Cost 3 ins <6,6,u,1>, lane 2
    2846788778U, // <6,6,4,2>: Cost 3 vuzpr <4,6,4,6>, <4,4,0,2>
    3195576321U, // <6,6,4,3>: Cost 3 ins <6,u,4,3>, lane 1
    2047660134U, // <6,6,4,4>: Cost 2 vtrnr <5,6,7,4>, <5,6,7,4>
    1573195062U, // <6,6,4,5>: Cost 2 vext2 <4,u,6,6>, RHS
    1718029622U, // <6,6,4,6>: Cost 2 vuzpl <6,6,6,6>, RHS
    2120835074U, // <6,6,4,7>: Cost 2 ins <6,6,u,7>, lane 2
    1573195304U, // <6,6,4,u>: Cost 2 vext2 <4,u,6,6>, <4,u,6,6>
    3194363907U, // <6,6,5,0>: Cost 3 ins <6,6,5,u>, lane 3
    2646937296U, // <6,6,5,1>: Cost 3 vext2 <4,u,6,6>, <5,1,7,3>
    3206258688U, // <6,6,5,2>: Cost 3 ins <u,6,5,2>, lane 0
    3194544130U, // <6,6,5,3>: Cost 3 ins <6,6,u,3>, lane 2
    2646937542U, // <6,6,5,4>: Cost 3 vext2 <4,u,6,6>, <5,4,7,6>
    1906740532U, // <6,6,5,5>: Cost 2 vzipr <4,5,6,5>, <4,5,6,5>
    2120826882U, // <6,6,5,6>: Cost 2 ins <6,6,u,6>, lane 2
    1773047094U, // <6,6,5,7>: Cost 2 vuzpr <4,6,4,6>, RHS
    1773047095U, // <6,6,5,u>: Cost 2 vuzpr <4,6,4,6>, RHS
    1516699750U, // <6,6,6,0>: Cost 2 vext1 <6,6,6,6>, LHS
    2120695811U, // <6,6,6,1>: Cost 2 ins <6,6,6,u>, lane 3
    2120695811U, // <6,6,6,2>: Cost 2 ins <6,6,6,u>, lane 3
    2120695811U, // <6,6,6,3>: Cost 2 ins <6,6,6,u>, lane 3
    1516703030U, // <6,6,6,4>: Cost 2 vext1 <6,6,6,6>, RHS
    2120695811U, // <6,6,6,5>: Cost 2 ins <6,6,6,u>, lane 3
    296144182U,  // <6,6,6,6>: Cost 1 vdup2 RHS
    1908739382U, // <6,6,6,7>: Cost 2 vzipr <4,u,6,6>, RHS
    296144182U,  // <6,6,6,u>: Cost 1 vdup2 RHS
    2132647936U, // <6,6,7,0>: Cost 2 ins <u,6,7,0>, lane 0
    2120769539U, // <6,6,7,1>: Cost 2 ins <6,6,7,u>, lane 3
    1908747164U, // <6,6,7,2>: Cost 2 vzipr RHS, <4,0,6,2>
    2122055681U, // <6,6,7,3>: Cost 2 ins <6,u,7,3>, lane 1
    2132680704U, // <6,6,7,4>: Cost 2 ins <u,6,7,4>, lane 0
    2120769539U, // <6,6,7,5>: Cost 2 ins <6,6,7,u>, lane 3
    1906758456U, // <6,6,7,6>: Cost 2 vzipr RHS, <6,6,6,6>
    833015094U,  // <6,6,7,7>: Cost 1 vzipr RHS, RHS
    833015095U,  // <6,6,7,u>: Cost 1 vzipr RHS, RHS
    2047627362U, // <6,6,u,0>: Cost 2 vtrnr <5,6,7,0>, <5,6,7,0>
    1573197614U, // <6,6,u,1>: Cost 2 vext2 <4,u,6,6>, LHS
    1906764700U, // <6,6,u,2>: Cost 2 vzipr RHS, <4,0,6,2>
    1773044381U, // <6,6,u,3>: Cost 2 vuzpr <4,6,4,6>, LHS
    2047660134U, // <6,6,u,4>: Cost 2 vtrnr <5,6,7,4>, <5,6,7,4>
    1573197978U, // <6,6,u,5>: Cost 2 vext2 <4,u,6,6>, RHS
    296144182U,  // <6,6,u,6>: Cost 1 vdup2 RHS
    833023286U,  // <6,6,u,7>: Cost 1 vzipr RHS, RHS
    833023287U,  // <6,6,u,u>: Cost 1 vzipr RHS, RHS
    1571209216U, // <6,7,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
    497467494U,  // <6,7,0,1>: Cost 1 vext2 RHS, LHS
    1571209380U, // <6,7,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
    2120916995U, // <6,7,0,3>: Cost 2 ins <6,7,0,u>, lane 3
    1571209554U, // <6,7,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
    1510756450U, // <6,7,0,5>: Cost 2 vext1 <5,6,7,0>, <5,6,7,0>
    2120916995U, // <6,7,0,6>: Cost 2 ins <6,7,0,u>, lane 3
    2120916995U, // <6,7,0,7>: Cost 2 ins <6,7,0,u>, lane 3
    497468061U,  // <6,7,0,u>: Cost 1 vext2 RHS, LHS
    1571209974U, // <6,7,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
    1571210036U, // <6,7,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
    1571210134U, // <6,7,1,2>: Cost 2 vext2 RHS, <1,2,3,0>
    1761034342U, // <6,7,1,3>: Cost 2 vuzpr <2,6,3,7>, LHS
    2644952098U, // <6,7,1,4>: Cost 3 vext2 RHS, <1,4,0,5>
    1571210384U, // <6,7,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
    2644952271U, // <6,7,1,6>: Cost 3 vext2 RHS, <1,6,1,7>
    2121498626U, // <6,7,1,7>: Cost 2 ins <6,7,u,7>, lane 2
    1761034347U, // <6,7,1,u>: Cost 2 vuzpr <2,6,3,7>, LHS
    2121064451U, // <6,7,2,0>: Cost 2 ins <6,7,2,u>, lane 3
    2121449474U, // <6,7,2,1>: Cost 2 ins <6,7,u,1>, lane 2
    1571210856U, // <6,7,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
    1059889156U, // <6,7,2,3>: Cost 1 ins LHS, lane 4
    2121064451U, // <6,7,2,4>: Cost 2 ins <6,7,2,u>, lane 3
    2121482242U, // <6,7,2,5>: Cost 2 ins <6,7,u,5>, lane 2
    1571211194U, // <6,7,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
    2121498626U, // <6,7,2,7>: Cost 2 ins <6,7,u,7>, lane 2
    1059889156U, // <6,7,2,u>: Cost 1 ins LHS, lane 4
    1571211414U, // <6,7,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
    2121449474U, // <6,7,3,1>: Cost 2 ins <6,7,u,1>, lane 2
    2133696516U, // <6,7,3,2>: Cost 2 ins <u,u,3,2>, lane 4
    1571211676U, // <6,7,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
    1571211778U, // <6,7,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
    2121482242U, // <6,7,3,5>: Cost 2 ins <6,7,u,5>, lane 2
    2834777789U, // <6,7,3,6>: Cost 3 vuzpr <2,6,3,7>, <2,3,2,6>
    2133737476U, // <6,7,3,7>: Cost 2 ins <u,u,3,7>, lane 4
    1571212062U, // <6,7,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
    1573202834U, // <6,7,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
    2121449474U, // <6,7,4,1>: Cost 2 ins <6,7,u,1>, lane 2
    2121211907U, // <6,7,4,2>: Cost 2 ins <6,7,4,u>, lane 3
    2121211907U, // <6,7,4,3>: Cost 2 ins <6,7,4,u>, lane 3
    1571212496U, // <6,7,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
    497470774U,  // <6,7,4,5>: Cost 1 vext2 RHS, RHS
    1573203276U, // <6,7,4,6>: Cost 2 vext2 RHS, <4,6,0,2>
    2121211907U, // <6,7,4,7>: Cost 2 ins <6,7,4,u>, lane 3
    497471017U,  // <6,7,4,u>: Cost 1 vext2 RHS, RHS
    2644954696U, // <6,7,5,0>: Cost 3 vext2 RHS, <5,0,1,2>
    1573203664U, // <6,7,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
    2644954878U, // <6,7,5,2>: Cost 3 vext2 RHS, <5,2,3,4>
    2121465858U, // <6,7,5,3>: Cost 2 ins <6,7,u,3>, lane 2
    1571213254U, // <6,7,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
    1571213316U, // <6,7,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
    1571213410U, // <6,7,5,6>: Cost 2 vext2 RHS, <5,6,7,0>
    1761037622U, // <6,7,5,7>: Cost 2 vuzpr <2,6,3,7>, RHS
    1761037623U, // <6,7,5,u>: Cost 2 vuzpr <2,6,3,7>, RHS
    2121359363U, // <6,7,6,0>: Cost 2 ins <6,7,6,u>, lane 3
    2121449474U, // <6,7,6,1>: Cost 2 ins <6,7,u,1>, lane 2
    1573204474U, // <6,7,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
    2121465858U, // <6,7,6,3>: Cost 2 ins <6,7,u,3>, lane 2
    2121359363U, // <6,7,6,4>: Cost 2 ins <6,7,6,u>, lane 3
    2121482242U, // <6,7,6,5>: Cost 2 ins <6,7,u,5>, lane 2
    1571214136U, // <6,7,6,6>: Cost 2 vext2 RHS, <6,6,6,6>
    1060216836U, // <6,7,6,7>: Cost 1 ins RHS, lane 4
    1060216836U, // <6,7,6,u>: Cost 1 ins RHS, lane 4
    1906757730U, // <6,7,7,0>: Cost 2 vzipr RHS, <5,6,7,0>
    2121449474U, // <6,7,7,1>: Cost 2 ins <6,7,u,1>, lane 2
    2644956362U, // <6,7,7,2>: Cost 3 vext2 RHS, <7,2,6,3>
    1906758138U, // <6,7,7,3>: Cost 2 vzipr RHS, <6,2,7,3>
    1906757734U, // <6,7,7,4>: Cost 2 vzipr RHS, <5,6,7,4>
    2121482242U, // <6,7,7,5>: Cost 2 ins <6,7,u,5>, lane 2
    1906757574U, // <6,7,7,6>: Cost 2 vzipr RHS, <5,4,7,6>
    1571214956U, // <6,7,7,7>: Cost 2 vext2 RHS, <7,7,7,7>
    1906757738U, // <6,7,7,u>: Cost 2 vzipr RHS, <5,6,7,u>
    1571215059U, // <6,7,u,0>: Cost 2 vext2 RHS, <u,0,1,2>
    497473326U,  // <6,7,u,1>: Cost 1 vext2 RHS, LHS
    1571215237U, // <6,7,u,2>: Cost 2 vext2 RHS, <u,2,3,0>
    1059889156U, // <6,7,u,3>: Cost 1 ins LHS, lane 4
    1571215423U, // <6,7,u,4>: Cost 2 vext2 RHS, <u,4,5,6>
    497473690U,  // <6,7,u,5>: Cost 1 vext2 RHS, RHS
    1571215568U, // <6,7,u,6>: Cost 2 vext2 RHS, <u,6,3,7>
    1060216836U, // <6,7,u,7>: Cost 1 ins RHS, lane 4
    497473893U,  // <6,7,u,u>: Cost 1 vext2 RHS, LHS
    1571217408U, // <6,u,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
    497475686U,  // <6,u,0,1>: Cost 1 vext2 RHS, LHS
    1571217572U, // <6,u,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
    2047623837U, // <6,u,0,3>: Cost 2 vtrnr <5,6,7,0>, LHS
    1571217746U, // <6,u,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
    1510830187U, // <6,u,0,5>: Cost 2 vext1 <5,6,u,0>, <5,6,u,0>
    1986648218U, // <6,u,0,6>: Cost 2 vtrnl <6,7,0,1>, RHS
    2047626793U, // <6,u,0,7>: Cost 2 vtrnr <5,6,7,0>, RHS
    497476253U,  // <6,u,0,u>: Cost 1 vext2 RHS, LHS
    1571218166U, // <6,u,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
    1571218228U, // <6,u,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
    1612289838U, // <6,u,1,2>: Cost 2 vext3 <0,2,4,6>, LHS
    1761042534U, // <6,u,1,3>: Cost 2 vuzpr <2,6,3,u>, LHS
    2566663478U, // <6,u,1,4>: Cost 3 vext1 <2,6,u,1>, RHS
    1571218576U, // <6,u,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
    2120826882U, // <6,u,1,6>: Cost 2 ins <6,6,u,6>, lane 2
    2120835074U, // <6,u,1,7>: Cost 2 ins <6,6,u,7>, lane 2
    1612289892U, // <6,u,1,u>: Cost 2 vext3 <0,2,4,6>, LHS
    1504870502U, // <6,u,2,0>: Cost 2 vext1 <4,6,u,2>, LHS
    1849644846U, // <6,u,2,1>: Cost 2 vzipl <6,2,7,3>, LHS
    1571219048U, // <6,u,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
    1055244288U, // <6,u,2,3>: Cost 1 ins LHS, lane 0
    1504873876U, // <6,u,2,4>: Cost 2 vext1 <4,6,u,2>, <4,6,u,2>
    1849645210U, // <6,u,2,5>: Cost 2 vzipl <6,2,7,3>, RHS
    1571219386U, // <6,u,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
    2041155113U, // <6,u,2,7>: Cost 2 vtrnr <4,6,0,2>, RHS
    1055244288U, // <6,u,2,u>: Cost 1 ins LHS, lane 0
    1571219606U, // <6,u,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
    2121449474U, // <6,u,3,1>: Cost 2 ins <6,7,u,1>, lane 2
    2128388096U, // <6,u,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    1571219868U, // <6,u,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
    1571219970U, // <6,u,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
    2121482242U, // <6,u,3,5>: Cost 2 ins <6,7,u,5>, lane 2
    2120826882U, // <6,u,3,6>: Cost 2 ins <6,6,u,6>, lane 2
    2131746816U, // <6,u,3,7>: Cost 2 ins <u,5,3,7>, lane 0
    1571220254U, // <6,u,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
    1571220370U, // <6,u,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
    2121449474U, // <6,u,4,1>: Cost 2 ins <6,7,u,1>, lane 2
    1986975534U, // <6,u,4,2>: Cost 2 vtrnl <6,7,4,5>, LHS
    2047656605U, // <6,u,4,3>: Cost 2 vtrnr <5,6,7,4>, LHS
    1571220688U, // <6,u,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
    497478967U,  // <6,u,4,5>: Cost 1 vext2 RHS, RHS
    1571220812U, // <6,u,4,6>: Cost 2 vext2 RHS, <4,6,0,2>
    2047659561U, // <6,u,4,7>: Cost 2 vtrnr <5,6,7,4>, RHS
    497479209U,  // <6,u,4,u>: Cost 1 vext2 RHS, RHS
    2566692966U, // <6,u,5,0>: Cost 3 vext1 <2,6,u,5>, LHS
    1571221200U, // <6,u,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
    2566694885U, // <6,u,5,2>: Cost 3 vext1 <2,6,u,5>, <2,6,u,5>
    2118148098U, // <6,u,5,3>: Cost 2 ins <6,2,u,3>, lane 2
    1571221446U, // <6,u,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
    1571221508U, // <6,u,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
    1612290202U, // <6,u,5,6>: Cost 2 vext3 <0,2,4,6>, RHS
    1761045814U, // <6,u,5,7>: Cost 2 vuzpr <2,6,3,u>, RHS
    1612290220U, // <6,u,5,u>: Cost 2 vext3 <0,2,4,6>, RHS
    1504903270U, // <6,u,6,0>: Cost 2 vext1 <4,6,u,6>, LHS
    1852249902U, // <6,u,6,1>: Cost 2 vzipl <6,6,6,6>, LHS
    1571222010U, // <6,u,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
    2041479837U, // <6,u,6,3>: Cost 2 vtrnr <4,6,4,6>, LHS
    1504906648U, // <6,u,6,4>: Cost 2 vext1 <4,6,u,6>, <4,6,u,6>
    1852250266U, // <6,u,6,5>: Cost 2 vzipl <6,6,6,6>, RHS
    296144182U,  // <6,u,6,6>: Cost 1 vdup2 RHS
    1058226176U, // <6,u,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <6,u,6,u>: Cost 1 ins RHS, lane 0
    1492967526U, // <6,u,7,0>: Cost 2 vext1 <2,6,u,7>, LHS
    1906753609U, // <6,u,7,1>: Cost 2 vzipr RHS, <0,0,u,1>
    1492969447U, // <6,u,7,2>: Cost 2 vext1 <2,6,u,7>, <2,6,u,7>
    833011868U,  // <6,u,7,3>: Cost 1 vzipr RHS, LHS
    1492970806U, // <6,u,7,4>: Cost 2 vext1 <2,6,u,7>, RHS
    1906753937U, // <6,u,7,5>: Cost 2 vzipr RHS, <0,4,u,5>
    1906753776U, // <6,u,7,6>: Cost 2 vzipr RHS, <0,2,u,6>
    833015112U,  // <6,u,7,7>: Cost 1 vzipr RHS, RHS
    833011873U,  // <6,u,7,u>: Cost 1 vzipr RHS, LHS
    1492975718U, // <6,u,u,0>: Cost 2 vext1 <2,6,u,u>, LHS
    497481518U,  // <6,u,u,1>: Cost 1 vext2 RHS, LHS
    1612290405U, // <6,u,u,2>: Cost 2 vext3 <0,2,4,6>, LHS
    833020060U,  // <6,u,u,3>: Cost 1 vzipr RHS, LHS
    1492978998U, // <6,u,u,4>: Cost 2 vext1 <2,6,u,u>, RHS
    497481882U,  // <6,u,u,5>: Cost 1 vext2 RHS, RHS
    296144182U,  // <6,u,u,6>: Cost 1 vdup2 RHS
    833023304U,  // <6,u,u,7>: Cost 1 vzipr RHS, RHS
    497482085U,  // <6,u,u,u>: Cost 1 vext2 RHS, LHS
    1638318080U, // <7,0,0,0>: Cost 2 vext3 RHS, <0,0,0,0>
    1638318090U, // <7,0,0,1>: Cost 2 vext3 RHS, <0,0,1,1>
    1638318100U, // <7,0,0,2>: Cost 2 vext3 RHS, <0,0,2,2>
    2987152532U, // <7,0,0,3>: Cost 3 vzipr <5,6,7,0>, <7,2,0,3>
    2712059941U, // <7,0,0,4>: Cost 3 vext3 RHS, <0,0,4,1>
    2987152210U, // <7,0,0,5>: Cost 3 vzipr <5,6,7,0>, <6,7,0,5>
    2590618445U, // <7,0,0,6>: Cost 3 vext1 <6,7,0,0>, <6,7,0,0>
    2987152050U, // <7,0,0,7>: Cost 3 vzipr <5,6,7,0>, <6,5,0,7>
    1638318153U, // <7,0,0,u>: Cost 2 vext3 RHS, <0,0,u,1>
    1516879974U, // <7,0,1,0>: Cost 2 vext1 <6,7,0,1>, LHS
    2128232448U, // <7,0,1,1>: Cost 2 ins <u,0,1,1>, lane 0
    564576358U,  // <7,0,1,2>: Cost 1 vext3 RHS, LHS
    2122317827U, // <7,0,1,3>: Cost 2 ins <7,0,1,u>, lane 3
    1516883254U, // <7,0,1,4>: Cost 2 vext1 <6,7,0,1>, RHS
    2122317827U, // <7,0,1,5>: Cost 2 ins <7,0,1,u>, lane 3
    1516884814U, // <7,0,1,6>: Cost 2 vext1 <6,7,0,1>, <6,7,0,1>
    2122317827U, // <7,0,1,7>: Cost 2 ins <7,0,1,u>, lane 3
    564576412U,  // <7,0,1,u>: Cost 1 vext3 RHS, LHS
    1638318244U, // <7,0,2,0>: Cost 2 vext3 RHS, <0,2,0,2>
    2692743344U, // <7,0,2,1>: Cost 3 vext3 <1,3,5,7>, <0,2,1,5>
    2128314368U, // <7,0,2,2>: Cost 2 ins <u,0,2,2>, lane 0
    2122833925U, // <7,0,2,3>: Cost 2 ins <7,0,u,u>, lane 5
    1638318284U, // <7,0,2,4>: Cost 2 vext3 RHS, <0,2,4,6>
    2712060118U, // <7,0,2,5>: Cost 3 vext3 RHS, <0,2,5,7>
    2712060126U, // <7,0,2,6>: Cost 3 vext3 RHS, <0,2,6,6>
    3201433601U, // <7,0,2,7>: Cost 3 ins <7,u,2,7>, lane 1
    1638318316U, // <7,0,2,u>: Cost 2 vext3 RHS, <0,2,u,2>
    2983854080U, // <7,0,3,0>: Cost 3 vzipr <5,1,7,3>, <0,0,0,0>
    2712060156U, // <7,0,3,1>: Cost 3 vext3 RHS, <0,3,1,0>
    2128388096U, // <7,0,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    2651605404U, // <7,0,3,3>: Cost 3 vext2 <5,6,7,0>, <3,3,3,3>
    2651605506U, // <7,0,3,4>: Cost 3 vext2 <5,6,7,0>, <3,4,5,6>
    2638998111U, // <7,0,3,5>: Cost 3 vext2 <3,5,7,0>, <3,5,7,0>
    3196559362U, // <7,0,3,6>: Cost 3 ins <7,0,u,6>, lane 2
    3201507329U, // <7,0,3,7>: Cost 3 ins <7,u,3,7>, lane 1
    2128388096U, // <7,0,3,u>: Cost 2 ins <u,0,3,2>, lane 0
    2712060230U, // <7,0,4,0>: Cost 3 vext3 RHS, <0,4,0,2>
    1638318418U, // <7,0,4,1>: Cost 2 vext3 RHS, <0,4,1,5>
    1638318428U, // <7,0,4,2>: Cost 2 vext3 RHS, <0,4,2,6>
    3201548289U, // <7,0,4,3>: Cost 3 ins <7,u,4,3>, lane 1
    2712060269U, // <7,0,4,4>: Cost 3 vext3 RHS, <0,4,4,5>
    1577864502U, // <7,0,4,5>: Cost 2 vext2 <5,6,7,0>, RHS
    2651606348U, // <7,0,4,6>: Cost 3 vext2 <5,6,7,0>, <4,6,0,2>
    3201581057U, // <7,0,4,7>: Cost 3 ins <7,u,4,7>, lane 1
    1638318481U, // <7,0,4,u>: Cost 2 vext3 RHS, <0,4,u,5>
    2647625340U, // <7,0,5,0>: Cost 3 vext2 <5,0,7,0>, <5,0,7,0>
    2128527360U, // <7,0,5,1>: Cost 2 ins <u,0,5,1>, lane 0
    1991032934U, // <7,0,5,2>: Cost 2 vtrnl <7,4,5,6>, LHS
    2649616239U, // <7,0,5,3>: Cost 3 vext2 <5,3,7,0>, <5,3,7,0>
    2651606982U, // <7,0,5,4>: Cost 3 vext2 <5,6,7,0>, <5,4,7,6>
    2651607044U, // <7,0,5,5>: Cost 3 vext2 <5,6,7,0>, <5,5,5,5>
    1577865314U, // <7,0,5,6>: Cost 2 vext2 <5,6,7,0>, <5,6,7,0>
    2847477046U, // <7,0,5,7>: Cost 3 vuzpr <4,7,5,0>, RHS
    1579192580U, // <7,0,5,u>: Cost 2 vext2 <5,u,7,0>, <5,u,7,0>
    2985869312U, // <7,0,6,0>: Cost 3 vzipr <5,4,7,6>, <0,0,0,0>
    2712060406U, // <7,0,6,1>: Cost 3 vext3 RHS, <0,6,1,7>
    2128609280U, // <7,0,6,2>: Cost 2 ins <u,0,6,2>, lane 0
    2655588936U, // <7,0,6,3>: Cost 3 vext2 <6,3,7,0>, <6,3,7,0>
    3202367488U, // <7,0,6,4>: Cost 3 ins <u,0,6,4>, lane 0
    2651607730U, // <7,0,6,5>: Cost 3 vext2 <5,6,7,0>, <6,5,0,7>
    2651607864U, // <7,0,6,6>: Cost 3 vext2 <5,6,7,0>, <6,6,6,6>
    2122833925U, // <7,0,6,7>: Cost 2 ins <7,0,u,u>, lane 5
    2128609280U, // <7,0,6,u>: Cost 2 ins <u,0,6,2>, lane 0
    2847477192U, // <7,0,7,0>: Cost 3 vuzpr <4,7,5,0>, <4,7,5,0>
    1858961510U, // <7,0,7,1>: Cost 2 vzipl <7,7,7,7>, LHS
    1993179238U, // <7,0,7,2>: Cost 2 vtrnl <7,7,7,7>, LHS
    3201769473U, // <7,0,7,3>: Cost 3 ins <7,u,7,3>, lane 1
    2651608422U, // <7,0,7,4>: Cost 3 vext2 <5,6,7,0>, <7,4,5,6>
    2651608513U, // <7,0,7,5>: Cost 3 vext2 <5,6,7,0>, <7,5,6,7>
    2663552532U, // <7,0,7,6>: Cost 3 vext2 <7,6,7,0>, <7,6,7,0>
    2128060417U, // <7,0,7,7>: Cost 2 ins <7,u,7,7>, lane 1
    1858962077U, // <7,0,7,u>: Cost 2 vzipl <7,7,7,7>, LHS
    1638318730U, // <7,0,u,0>: Cost 2 vext3 RHS, <0,u,0,2>
    1638318738U, // <7,0,u,1>: Cost 2 vext3 RHS, <0,u,1,1>
    564576925U,  // <7,0,u,2>: Cost 1 vext3 RHS, LHS
    2122317827U, // <7,0,u,3>: Cost 2 ins <7,0,1,u>, lane 3
    1638318770U, // <7,0,u,4>: Cost 2 vext3 RHS, <0,u,4,6>
    1577867418U, // <7,0,u,5>: Cost 2 vext2 <5,6,7,0>, RHS
    1516942165U, // <7,0,u,6>: Cost 2 vext1 <6,7,0,u>, <6,7,0,u>
    2122317827U, // <7,0,u,7>: Cost 2 ins <7,0,1,u>, lane 3
    564576979U,  // <7,0,u,u>: Cost 1 vext3 RHS, LHS
    2712060634U, // <7,1,0,0>: Cost 3 vext3 RHS, <1,0,0,1>
    2128822272U, // <7,1,0,1>: Cost 2 ins <u,1,0,1>, lane 0
    1719615590U, // <7,1,0,2>: Cost 2 vuzpl <7,0,1,2>, LHS
    1638318838U, // <7,1,0,3>: Cost 2 vext3 RHS, <1,0,3,2>
    2859062268U, // <7,1,0,4>: Cost 3 vuzpr <6,7,0,1>, <7,0,1,4>
    2712060679U, // <7,1,0,5>: Cost 3 vext3 RHS, <1,0,5,1>
    2859061568U, // <7,1,0,6>: Cost 3 vuzpr <6,7,0,1>, <6,0,4,6>
    3201286145U, // <7,1,0,7>: Cost 3 ins <7,u,0,7>, lane 1
    1638318883U, // <7,1,0,u>: Cost 2 vext3 RHS, <1,0,u,2>
    2712060714U, // <7,1,1,0>: Cost 3 vext3 RHS, <1,1,0,0>
    1638318900U, // <7,1,1,1>: Cost 2 vext3 RHS, <1,1,1,1>
    2127577089U, // <7,1,1,2>: Cost 2 ins <7,u,1,2>, lane 1
    1638318920U, // <7,1,1,3>: Cost 2 vext3 RHS, <1,1,3,3>
    2712060755U, // <7,1,1,4>: Cost 3 vext3 RHS, <1,1,4,5>
    2691416926U, // <7,1,1,5>: Cost 3 vext3 <1,1,5,7>, <1,1,5,7>
    2590700375U, // <7,1,1,6>: Cost 3 vext1 <6,7,1,1>, <6,7,1,1>
    2859057294U, // <7,1,1,7>: Cost 3 vuzpr <6,7,0,1>, <0,1,6,7>
    1638318965U, // <7,1,1,u>: Cost 2 vext3 RHS, <1,1,u,3>
    2128961536U, // <7,1,2,0>: Cost 2 ins <u,1,2,0>, lane 0
    2128969728U, // <7,1,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    2128977920U, // <7,1,2,2>: Cost 2 ins <u,1,2,2>, lane 0
    1055244288U, // <7,1,2,3>: Cost 1 ins LHS, lane 0
    2128994304U, // <7,1,2,4>: Cost 2 ins <u,1,2,4>, lane 0
    2129002496U, // <7,1,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2129010688U, // <7,1,2,6>: Cost 2 ins <u,1,2,6>, lane 0
    2129018880U, // <7,1,2,7>: Cost 2 ins <u,1,2,7>, lane 0
    1055244288U, // <7,1,2,u>: Cost 1 ins LHS, lane 0
    1510998118U, // <7,1,3,0>: Cost 2 vext1 <5,7,1,3>, LHS
    1638319064U, // <7,1,3,1>: Cost 2 vext3 RHS, <1,3,1,3>
    2712060894U, // <7,1,3,2>: Cost 3 vext3 RHS, <1,3,2,0>
    2047869030U, // <7,1,3,3>: Cost 2 vtrnr <5,7,1,3>, LHS
    1511001398U, // <7,1,3,4>: Cost 2 vext1 <5,7,1,3>, RHS
    1619002368U, // <7,1,3,5>: Cost 2 vext3 <1,3,5,7>, <1,3,5,7>
    2692817929U, // <7,1,3,6>: Cost 3 vext3 <1,3,6,7>, <1,3,6,7>
    2983859604U, // <7,1,3,7>: Cost 3 vzipr <5,1,7,3>, <7,5,1,7>
    1619223579U, // <7,1,3,u>: Cost 2 vext3 <1,3,u,7>, <1,3,u,7>
    2712060962U, // <7,1,4,0>: Cost 3 vext3 RHS, <1,4,0,5>
    2712060971U, // <7,1,4,1>: Cost 3 vext3 RHS, <1,4,1,5>
    2712060980U, // <7,1,4,2>: Cost 3 vext3 RHS, <1,4,2,5>
    2129133568U, // <7,1,4,3>: Cost 2 ins <u,1,4,3>, lane 0
    2859060432U, // <7,1,4,4>: Cost 3 vuzpr <6,7,0,1>, <4,4,4,4>
    2129149952U, // <7,1,4,5>: Cost 2 ins <u,1,4,5>, lane 0
    1719618870U, // <7,1,4,6>: Cost 2 vuzpl <7,0,1,2>, RHS
    2793360778U, // <7,1,4,7>: Cost 3 vuzpl <7,0,1,2>, <4,6,7,1>
    1719618888U, // <7,1,4,u>: Cost 2 vuzpl <7,0,1,2>, RHS
    2572812390U, // <7,1,5,0>: Cost 3 vext1 <3,7,1,5>, LHS
    2693776510U, // <7,1,5,1>: Cost 3 vext3 <1,5,1,7>, <1,5,1,7>
    3202940928U, // <7,1,5,2>: Cost 3 ins <u,1,5,2>, lane 0
    1620182160U, // <7,1,5,3>: Cost 2 vext3 <1,5,3,7>, <1,5,3,7>
    2572815670U, // <7,1,5,4>: Cost 3 vext1 <3,7,1,5>, RHS
    2985861458U, // <7,1,5,5>: Cost 3 vzipr <5,4,7,5>, <0,4,1,5>
    2127904769U, // <7,1,5,6>: Cost 2 ins <7,u,5,6>, lane 1
    1785318710U, // <7,1,5,7>: Cost 2 vuzpr <6,7,0,1>, RHS
    1620550845U, // <7,1,5,u>: Cost 2 vext3 <1,5,u,7>, <1,5,u,7>
    2653606230U, // <7,1,6,0>: Cost 3 vext2 <6,0,7,1>, <6,0,7,1>
    2694440143U, // <7,1,6,1>: Cost 3 vext3 <1,6,1,7>, <1,6,1,7>
    2712061144U, // <7,1,6,2>: Cost 3 vext3 RHS, <1,6,2,7>
    2129281024U, // <7,1,6,3>: Cost 2 ins <u,1,6,3>, lane 0
    2859061350U, // <7,1,6,4>: Cost 3 vuzpr <6,7,0,1>, <5,6,7,4>
    2694735091U, // <7,1,6,5>: Cost 3 vext3 <1,6,5,7>, <1,6,5,7>
    2859060596U, // <7,1,6,6>: Cost 3 vuzpr <6,7,0,1>, <4,6,4,6>
    2129313792U, // <7,1,6,7>: Cost 2 ins <u,1,6,7>, lane 0
    2129281024U, // <7,1,6,u>: Cost 2 ins <u,1,6,3>, lane 0
    2645644282U, // <7,1,7,0>: Cost 3 vext2 <4,6,7,1>, <7,0,1,2>
    1785320270U, // <7,1,7,1>: Cost 2 vuzpr <6,7,0,1>, <6,7,0,1>
    2986543254U, // <7,1,7,2>: Cost 3 vzipr <5,5,7,7>, <3,0,1,2>
    2048196710U, // <7,1,7,3>: Cost 2 vtrnr <5,7,5,7>, LHS
    2793362538U, // <7,1,7,4>: Cost 3 vuzpl <7,0,1,2>, <7,1,4,6>
    2986541394U, // <7,1,7,5>: Cost 3 vzipr <5,5,7,7>, <0,4,1,5>
    3201794049U, // <7,1,7,6>: Cost 3 ins <7,u,7,6>, lane 1
    2128060417U, // <7,1,7,7>: Cost 2 ins <7,u,7,7>, lane 1
    2048196715U, // <7,1,7,u>: Cost 2 vtrnr <5,7,5,7>, LHS
    1511039078U, // <7,1,u,0>: Cost 2 vext1 <5,7,1,u>, LHS
    1638319469U, // <7,1,u,1>: Cost 2 vext3 RHS, <1,u,1,3>
    1719621422U, // <7,1,u,2>: Cost 2 vuzpl <7,0,1,2>, LHS
    1055244288U, // <7,1,u,3>: Cost 1 ins LHS, lane 0
    1511042358U, // <7,1,u,4>: Cost 2 vext1 <5,7,1,u>, RHS
    1622320533U, // <7,1,u,5>: Cost 2 vext3 <1,u,5,7>, <1,u,5,7>
    1719621786U, // <7,1,u,6>: Cost 2 vuzpl <7,0,1,2>, RHS
    1785318953U, // <7,1,u,7>: Cost 2 vuzpr <6,7,0,1>, RHS
    1055244288U, // <7,1,u,u>: Cost 1 ins LHS, lane 0
    2712061364U, // <7,2,0,0>: Cost 3 vext3 RHS, <2,0,0,2>
    2712061373U, // <7,2,0,1>: Cost 3 vext3 RHS, <2,0,1,2>
    2129494016U, // <7,2,0,2>: Cost 2 ins <u,2,0,2>, lane 0
    1913405542U, // <7,2,0,3>: Cost 2 vzipr <5,6,7,0>, LHS
    2712061400U, // <7,2,0,4>: Cost 3 vext3 RHS, <2,0,4,2>
    2696725990U, // <7,2,0,5>: Cost 3 vext3 <2,0,5,7>, <2,0,5,7>
    2712061417U, // <7,2,0,6>: Cost 3 vext3 RHS, <2,0,6,1>
    2927577066U, // <7,2,0,7>: Cost 3 vzipl <7,0,1,2>, <2,7,0,1>
    1913405547U, // <7,2,0,u>: Cost 2 vzipr <5,6,7,0>, LHS
    2712061446U, // <7,2,1,0>: Cost 3 vext3 RHS, <2,1,0,3>
    3203301376U, // <7,2,1,1>: Cost 3 ins <u,2,1,1>, lane 0
    2127577089U, // <7,2,1,2>: Cost 2 ins <7,u,1,2>, lane 1
    2974548070U, // <7,2,1,3>: Cost 3 vzipr <3,5,7,1>, LHS
    2712061482U, // <7,2,1,4>: Cost 3 vext3 RHS, <2,1,4,3>
    3203334144U, // <7,2,1,5>: Cost 3 ins <u,2,1,5>, lane 0
    2712061500U, // <7,2,1,6>: Cost 3 vext3 RHS, <2,1,6,3>
    2602718850U, // <7,2,1,7>: Cost 3 vext1 <u,7,2,1>, <7,u,1,2>
    2127577089U, // <7,2,1,u>: Cost 2 ins <7,u,1,2>, lane 1
    2712061524U, // <7,2,2,0>: Cost 3 vext3 RHS, <2,2,0,0>
    2712061536U, // <7,2,2,1>: Cost 3 vext3 RHS, <2,2,1,3>
    1638319720U, // <7,2,2,2>: Cost 2 vext3 RHS, <2,2,2,2>
    1638319730U, // <7,2,2,3>: Cost 2 vext3 RHS, <2,2,3,3>
    2712061564U, // <7,2,2,4>: Cost 3 vext3 RHS, <2,2,4,4>
    2698053256U, // <7,2,2,5>: Cost 3 vext3 <2,2,5,7>, <2,2,5,7>
    2712061581U, // <7,2,2,6>: Cost 3 vext3 RHS, <2,2,6,3>
    3201433601U, // <7,2,2,7>: Cost 3 ins <7,u,2,7>, lane 1
    1638319775U, // <7,2,2,u>: Cost 2 vext3 RHS, <2,2,u,3>
    1638319782U, // <7,2,3,0>: Cost 2 vext3 RHS, <2,3,0,1>
    2693924531U, // <7,2,3,1>: Cost 3 vext3 <1,5,3,7>, <2,3,1,5>
    1638319802U, // <7,2,3,2>: Cost 2 vext3 RHS, <2,3,2,3>
    1910112358U, // <7,2,3,3>: Cost 2 vzipr <5,1,7,3>, LHS
    1638319822U, // <7,2,3,4>: Cost 2 vext3 RHS, <2,3,4,5>
    2698716889U, // <7,2,3,5>: Cost 3 vext3 <2,3,5,7>, <2,3,5,7>
    1625048802U, // <7,2,3,6>: Cost 2 vext3 <2,3,6,7>, <2,3,6,7>
    2990495214U, // <7,2,3,7>: Cost 3 vzipr <6,2,7,3>, <7,6,2,7>
    1638319854U, // <7,2,3,u>: Cost 2 vext3 RHS, <2,3,u,1>
    2712061688U, // <7,2,4,0>: Cost 3 vext3 RHS, <2,4,0,2>
    2712061698U, // <7,2,4,1>: Cost 3 vext3 RHS, <2,4,1,3>
    2712061708U, // <7,2,4,2>: Cost 3 vext3 RHS, <2,4,2,4>
    1913438310U, // <7,2,4,3>: Cost 2 vzipr <5,6,7,4>, LHS
    2712061728U, // <7,2,4,4>: Cost 3 vext3 RHS, <2,4,4,6>
    2699380522U, // <7,2,4,5>: Cost 3 vext3 <2,4,5,7>, <2,4,5,7>
    2129821696U, // <7,2,4,6>: Cost 2 ins <u,2,4,6>, lane 0
    3201581057U, // <7,2,4,7>: Cost 3 ins <7,u,4,7>, lane 1
    1913438315U, // <7,2,4,u>: Cost 2 vzipr <5,6,7,4>, LHS
    2699675470U, // <7,2,5,0>: Cost 3 vext3 <2,5,0,7>, <2,5,0,7>
    3203596288U, // <7,2,5,1>: Cost 3 ins <u,2,5,1>, lane 0
    2699822944U, // <7,2,5,2>: Cost 3 vext3 <2,5,2,7>, <2,5,2,7>
    2692745065U, // <7,2,5,3>: Cost 3 vext3 <1,3,5,7>, <2,5,3,7>
    2699970418U, // <7,2,5,4>: Cost 3 vext3 <2,5,4,7>, <2,5,4,7>
    3203629056U, // <7,2,5,5>: Cost 3 ins <u,2,5,5>, lane 0
    2127904769U, // <7,2,5,6>: Cost 2 ins <7,u,5,6>, lane 1
    2853096758U, // <7,2,5,7>: Cost 3 vuzpr <5,7,0,2>, RHS
    2127904769U, // <7,2,5,u>: Cost 2 ins <7,u,5,6>, lane 1
    2572894310U, // <7,2,6,0>: Cost 3 vext1 <3,7,2,6>, LHS
    2712061860U, // <7,2,6,1>: Cost 3 vext3 RHS, <2,6,1,3>
    2700486577U, // <7,2,6,2>: Cost 3 vext3 <2,6,2,7>, <2,6,2,7>
    1626818490U, // <7,2,6,3>: Cost 2 vext3 <2,6,3,7>, <2,6,3,7>
    2572897590U, // <7,2,6,4>: Cost 3 vext1 <3,7,2,6>, RHS
    2700707788U, // <7,2,6,5>: Cost 3 vext3 <2,6,5,7>, <2,6,5,7>
    2700781525U, // <7,2,6,6>: Cost 3 vext3 <2,6,6,7>, <2,6,6,7>
    2129977344U, // <7,2,6,7>: Cost 2 ins <u,2,6,7>, lane 0
    1627187175U, // <7,2,6,u>: Cost 2 vext3 <2,6,u,7>, <2,6,u,7>
    3121939350U, // <7,2,7,0>: Cost 3 vtrnr <5,7,5,7>, <1,2,3,0>
    3203743744U, // <7,2,7,1>: Cost 3 ins <u,2,7,1>, lane 0
    1720366165U, // <7,2,7,2>: Cost 2 vuzpl <7,1,2,3>, <7,1,2,3>
    1912799334U, // <7,2,7,3>: Cost 2 vzipr <5,5,7,7>, LHS
    3121939354U, // <7,2,7,4>: Cost 3 vtrnr <5,7,5,7>, <1,2,3,4>
    3203776512U, // <7,2,7,5>: Cost 3 ins <u,2,7,5>, lane 0
    2986541404U, // <7,2,7,6>: Cost 3 vzipr <5,5,7,7>, <0,4,2,6>
    2128060417U, // <7,2,7,7>: Cost 2 ins <7,u,7,7>, lane 1
    1912799339U, // <7,2,7,u>: Cost 2 vzipr <5,5,7,7>, LHS
    1638320187U, // <7,2,u,0>: Cost 2 vext3 RHS, <2,u,0,1>
    2693924936U, // <7,2,u,1>: Cost 3 vext3 <1,5,3,7>, <2,u,1,5>
    2129494016U, // <7,2,u,2>: Cost 2 ins <u,2,0,2>, lane 0
    1628145756U, // <7,2,u,3>: Cost 2 vext3 <2,u,3,7>, <2,u,3,7>
    1638320227U, // <7,2,u,4>: Cost 2 vext3 RHS, <2,u,4,5>
    2702035054U, // <7,2,u,5>: Cost 3 vext3 <2,u,5,7>, <2,u,5,7>
    2129821696U, // <7,2,u,6>: Cost 2 ins <u,2,4,6>, lane 0
    2129977344U, // <7,2,u,7>: Cost 2 ins <u,2,6,7>, lane 0
    1628514441U, // <7,2,u,u>: Cost 2 vext3 <2,u,u,7>, <2,u,u,7>
    2712062091U, // <7,3,0,0>: Cost 3 vext3 RHS, <3,0,0,0>
    1638320278U, // <7,3,0,1>: Cost 2 vext3 RHS, <3,0,1,2>
    2712062109U, // <7,3,0,2>: Cost 3 vext3 RHS, <3,0,2,0>
    2712062119U, // <7,3,0,3>: Cost 3 vext3 RHS, <3,0,3,1>
    2712062128U, // <7,3,0,4>: Cost 3 vext3 RHS, <3,0,4,1>
    2712062138U, // <7,3,0,5>: Cost 3 vext3 RHS, <3,0,5,2>
    2590839656U, // <7,3,0,6>: Cost 3 vext1 <6,7,3,0>, <6,7,3,0>
    2985157776U, // <7,3,0,7>: Cost 3 vzipr <5,3,7,0>, <1,5,3,7>
    1638320341U, // <7,3,0,u>: Cost 2 vext3 RHS, <3,0,u,2>
    2237164227U, // <7,3,1,0>: Cost 3 vrev <3,7,0,1>
    2712062182U, // <7,3,1,1>: Cost 3 vext3 RHS, <3,1,1,1>
    2127577089U, // <7,3,1,2>: Cost 2 ins <7,u,1,2>, lane 1
    1779433574U, // <7,3,1,3>: Cost 2 vuzpr <5,7,1,3>, LHS
    2712062214U, // <7,3,1,4>: Cost 3 vext3 RHS, <3,1,4,6>
    2693925132U, // <7,3,1,5>: Cost 3 vext3 <1,5,3,7>, <3,1,5,3>
    2853179064U, // <7,3,1,6>: Cost 3 vuzpr <5,7,1,3>, <5,1,4,6>
    2692745504U, // <7,3,1,7>: Cost 3 vext3 <1,3,5,7>, <3,1,7,5>
    1779433579U, // <7,3,1,u>: Cost 2 vuzpr <5,7,1,3>, LHS
    2712062254U, // <7,3,2,0>: Cost 3 vext3 RHS, <3,2,0,1>
    2712062262U, // <7,3,2,1>: Cost 3 vext3 RHS, <3,2,1,0>
    2712062273U, // <7,3,2,2>: Cost 3 vext3 RHS, <3,2,2,2>
    2130313216U, // <7,3,2,3>: Cost 2 ins <u,3,2,3>, lane 0
    2712062292U, // <7,3,2,4>: Cost 3 vext3 RHS, <3,2,4,3>
    2712062302U, // <7,3,2,5>: Cost 3 vext3 RHS, <3,2,5,4>
    2700560742U, // <7,3,2,6>: Cost 3 vext3 <2,6,3,7>, <3,2,6,3>
    2712062319U, // <7,3,2,7>: Cost 3 vext3 RHS, <3,2,7,3>
    2130313216U, // <7,3,2,u>: Cost 2 ins <u,3,2,3>, lane 0
    2712062334U, // <7,3,3,0>: Cost 3 vext3 RHS, <3,3,0,0>
    2636368158U, // <7,3,3,1>: Cost 3 vext2 <3,1,7,3>, <3,1,7,3>
    2637031791U, // <7,3,3,2>: Cost 3 vext2 <3,2,7,3>, <3,2,7,3>
    1638320540U, // <7,3,3,3>: Cost 2 vext3 RHS, <3,3,3,3>
    2712062374U, // <7,3,3,4>: Cost 3 vext3 RHS, <3,3,4,4>
    2704689586U, // <7,3,3,5>: Cost 3 vext3 <3,3,5,7>, <3,3,5,7>
    2990491658U, // <7,3,3,6>: Cost 3 vzipr <6,2,7,3>, <2,7,3,6>
    2972574864U, // <7,3,3,7>: Cost 3 vzipr <3,2,7,3>, <1,5,3,7>
    1638320540U, // <7,3,3,u>: Cost 2 vext3 RHS, <3,3,3,3>
    2712062416U, // <7,3,4,0>: Cost 3 vext3 RHS, <3,4,0,1>
    2712062426U, // <7,3,4,1>: Cost 3 vext3 RHS, <3,4,1,2>
    2987180790U, // <7,3,4,2>: Cost 3 vzipr <5,6,7,4>, <1,0,3,2>
    2712062447U, // <7,3,4,3>: Cost 3 vext3 RHS, <3,4,3,5>
    2712062455U, // <7,3,4,4>: Cost 3 vext3 RHS, <3,4,4,4>
    1638320642U, // <7,3,4,5>: Cost 2 vext3 RHS, <3,4,5,6>
    2648313164U, // <7,3,4,6>: Cost 3 vext2 <5,1,7,3>, <4,6,0,2>
    2985190544U, // <7,3,4,7>: Cost 3 vzipr <5,3,7,4>, <1,5,3,7>
    1638320669U, // <7,3,4,u>: Cost 2 vext3 RHS, <3,4,u,6>
    2712062498U, // <7,3,5,0>: Cost 3 vext3 RHS, <3,5,0,2>
    1574571728U, // <7,3,5,1>: Cost 2 vext2 <5,1,7,3>, <5,1,7,3>
    2648977185U, // <7,3,5,2>: Cost 3 vext2 <5,2,7,3>, <5,2,7,3>
    2705869378U, // <7,3,5,3>: Cost 3 vext3 <3,5,3,7>, <3,5,3,7>
    2237491947U, // <7,3,5,4>: Cost 3 vrev <3,7,4,5>
    2706016852U, // <7,3,5,5>: Cost 3 vext3 <3,5,5,7>, <3,5,5,7>
    2127904769U, // <7,3,5,6>: Cost 2 ins <7,u,5,6>, lane 1
    1779436854U, // <7,3,5,7>: Cost 2 vuzpr <5,7,1,3>, RHS
    1779436855U, // <7,3,5,u>: Cost 2 vuzpr <5,7,1,3>, RHS
    2706311800U, // <7,3,6,0>: Cost 3 vext3 <3,6,0,7>, <3,6,0,7>
    2853178744U, // <7,3,6,1>: Cost 3 vuzpr <5,7,1,3>, <4,6,5,1>
    1581208058U, // <7,3,6,2>: Cost 2 vext2 <6,2,7,3>, <6,2,7,3>
    2706533011U, // <7,3,6,3>: Cost 3 vext3 <3,6,3,7>, <3,6,3,7>
    2706606748U, // <7,3,6,4>: Cost 3 vext3 <3,6,4,7>, <3,6,4,7>
    3204366336U, // <7,3,6,5>: Cost 3 ins <u,3,6,5>, lane 0
    2712062637U, // <7,3,6,6>: Cost 3 vext3 RHS, <3,6,6,6>
    2130640896U, // <7,3,6,7>: Cost 2 ins <u,3,6,7>, lane 0
    1585189856U, // <7,3,6,u>: Cost 2 vext2 <6,u,7,3>, <6,u,7,3>
    2693925571U, // <7,3,7,0>: Cost 3 vext3 <1,5,3,7>, <3,7,0,1>
    2693925584U, // <7,3,7,1>: Cost 3 vext3 <1,5,3,7>, <3,7,1,5>
    2700561114U, // <7,3,7,2>: Cost 3 vext3 <2,6,3,7>, <3,7,2,6>
    1779437696U, // <7,3,7,3>: Cost 2 vuzpr <5,7,1,3>, <5,7,1,3>
    2693925611U, // <7,3,7,4>: Cost 3 vext3 <1,5,3,7>, <3,7,4,5>
    2237582070U, // <7,3,7,5>: Cost 3 vrev <3,7,5,7>
    2654950894U, // <7,3,7,6>: Cost 3 vext2 <6,2,7,3>, <7,6,2,7>
    2128060417U, // <7,3,7,7>: Cost 2 ins <7,u,7,7>, lane 1
    1779437696U, // <7,3,7,u>: Cost 2 vuzpr <5,7,1,3>, <5,7,1,3>
    2237221578U, // <7,3,u,0>: Cost 3 vrev <3,7,0,u>
    1638320926U, // <7,3,u,1>: Cost 2 vext3 RHS, <3,u,1,2>
    1593153452U, // <7,3,u,2>: Cost 2 vext2 <u,2,7,3>, <u,2,7,3>
    1779434141U, // <7,3,u,3>: Cost 2 vuzpr <5,7,1,3>, LHS
    2237516526U, // <7,3,u,4>: Cost 3 vrev <3,7,4,u>
    1638320966U, // <7,3,u,5>: Cost 2 vext3 RHS, <3,u,5,6>
    2127904769U, // <7,3,u,6>: Cost 2 ins <7,u,5,6>, lane 1
    1779437097U, // <7,3,u,7>: Cost 2 vuzpr <5,7,1,3>, RHS
    1638320989U, // <7,3,u,u>: Cost 2 vext3 RHS, <3,u,u,2>
    2714053478U, // <7,4,0,0>: Cost 3 vext3 RHS, <4,0,0,2>
    1577893990U, // <7,4,0,1>: Cost 2 vext2 <5,6,7,4>, LHS
    2651635876U, // <7,4,0,2>: Cost 3 vext2 <5,6,7,4>, <0,2,0,2>
    3201253377U, // <7,4,0,3>: Cost 3 ins <7,u,0,3>, lane 1
    2714053512U, // <7,4,0,4>: Cost 3 vext3 RHS, <4,0,4,0>
    1638468498U, // <7,4,0,5>: Cost 2 vext3 RHS, <4,0,5,1>
    1638468508U, // <7,4,0,6>: Cost 2 vext3 RHS, <4,0,6,2>
    2927578568U, // <7,4,0,7>: Cost 3 vzipl <7,0,1,2>, <4,7,5,0>
    1640311726U, // <7,4,0,u>: Cost 2 vext3 RHS, <4,0,u,2>
    2651636470U, // <7,4,1,0>: Cost 3 vext2 <5,6,7,4>, <1,0,3,2>
    2651636532U, // <7,4,1,1>: Cost 3 vext2 <5,6,7,4>, <1,1,1,1>
    2127577089U, // <7,4,1,2>: Cost 2 ins <7,u,1,2>, lane 1
    2639029248U, // <7,4,1,3>: Cost 3 vext2 <3,5,7,4>, <1,3,5,7>
    3127495888U, // <7,4,1,4>: Cost 3 vtrnr <6,7,0,1>, <4,4,4,4>
    2130919424U, // <7,4,1,5>: Cost 2 ins <u,4,1,5>, lane 0
    1988054326U, // <7,4,1,6>: Cost 2 vtrnl <7,0,1,2>, RHS
    3061796234U, // <7,4,1,7>: Cost 3 vtrnl <7,0,1,2>, <4,6,7,1>
    1988054344U, // <7,4,1,u>: Cost 2 vtrnl <7,0,1,2>, RHS
    3204694016U, // <7,4,2,0>: Cost 3 ins <u,4,2,0>, lane 0
    3199172610U, // <7,4,2,1>: Cost 3 ins <7,4,u,1>, lane 2
    2651637352U, // <7,4,2,2>: Cost 3 vext2 <5,6,7,4>, <2,2,2,2>
    2125488133U, // <7,4,2,3>: Cost 2 ins <7,4,u,u>, lane 5
    2853258138U, // <7,4,2,4>: Cost 3 vuzpr <5,7,2,4>, <1,2,3,4>
    2712063030U, // <7,4,2,5>: Cost 3 vext3 RHS, <4,2,5,3>
    2131001344U, // <7,4,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    3201433601U, // <7,4,2,7>: Cost 3 ins <7,u,2,7>, lane 1
    2125488133U, // <7,4,2,u>: Cost 2 ins <7,4,u,u>, lane 5
    2651637910U, // <7,4,3,0>: Cost 3 vext2 <5,6,7,4>, <3,0,1,2>
    3201458177U, // <7,4,3,1>: Cost 3 ins <7,u,3,1>, lane 1
    3204784128U, // <7,4,3,2>: Cost 3 ins <u,4,3,2>, lane 0
    2651638172U, // <7,4,3,3>: Cost 3 vext2 <5,6,7,4>, <3,3,3,3>
    2983857360U, // <7,4,3,4>: Cost 3 vzipr <5,1,7,3>, <4,4,4,4>
    2639030883U, // <7,4,3,5>: Cost 3 vext2 <3,5,7,4>, <3,5,7,4>
    2125471746U, // <7,4,3,6>: Cost 2 ins <7,4,u,6>, lane 2
    3201507329U, // <7,4,3,7>: Cost 3 ins <7,u,3,7>, lane 1
    2125471746U, // <7,4,3,u>: Cost 2 ins <7,4,u,6>, lane 2
    2714053800U, // <7,4,4,0>: Cost 3 vext3 RHS, <4,4,0,0>
    3201531905U, // <7,4,4,1>: Cost 3 ins <7,u,4,1>, lane 1
    3201540097U, // <7,4,4,2>: Cost 3 ins <7,u,4,2>, lane 1
    2987185336U, // <7,4,4,3>: Cost 3 vzipr <5,6,7,4>, <7,2,4,3>
    1638321360U, // <7,4,4,4>: Cost 2 vext3 RHS, <4,4,4,4>
    1638468826U, // <7,4,4,5>: Cost 2 vext3 RHS, <4,4,5,5>
    1638468836U, // <7,4,4,6>: Cost 2 vext3 RHS, <4,4,6,6>
    2987185664U, // <7,4,4,7>: Cost 3 vzipr <5,6,7,4>, <7,6,4,7>
    1640312054U, // <7,4,4,u>: Cost 2 vext3 RHS, <4,4,u,6>
    1517207654U, // <7,4,5,0>: Cost 2 vext1 <6,7,4,5>, LHS
    2125266947U, // <7,4,5,1>: Cost 2 ins <7,4,5,u>, lane 3
    2125266947U, // <7,4,5,2>: Cost 2 ins <7,4,5,u>, lane 3
    2125266947U, // <7,4,5,3>: Cost 2 ins <7,4,5,u>, lane 3
    1517210934U, // <7,4,5,4>: Cost 2 vext1 <6,7,4,5>, RHS
    2131214336U, // <7,4,5,5>: Cost 2 ins <u,4,5,5>, lane 0
    564579638U,  // <7,4,5,6>: Cost 1 vext3 RHS, RHS
    2125266947U, // <7,4,5,7>: Cost 2 ins <7,4,5,u>, lane 3
    564579656U,  // <7,4,5,u>: Cost 1 vext3 RHS, RHS
    1638468940U, // <7,4,6,0>: Cost 2 vext3 RHS, <4,6,0,2>
    2712063318U, // <7,4,6,1>: Cost 3 vext3 RHS, <4,6,1,3>
    2712210780U, // <7,4,6,2>: Cost 3 vext3 RHS, <4,6,2,0>
    2712210790U, // <7,4,6,3>: Cost 3 vext3 RHS, <4,6,3,1>
    1638468980U, // <7,4,6,4>: Cost 2 vext3 RHS, <4,6,4,6>
    2712063358U, // <7,4,6,5>: Cost 3 vext3 RHS, <4,6,5,7>
    2131296256U, // <7,4,6,6>: Cost 2 ins <u,4,6,6>, lane 0
    2125488133U, // <7,4,6,7>: Cost 2 ins <7,4,u,u>, lane 5
    1638469012U, // <7,4,6,u>: Cost 2 vext3 RHS, <4,6,u,2>
    2651640826U, // <7,4,7,0>: Cost 3 vext2 <5,6,7,4>, <7,0,1,2>
    2794279930U, // <7,4,7,1>: Cost 3 vuzpl <7,1,4,6>, <7,0,1,2>
    3201761281U, // <7,4,7,2>: Cost 3 ins <7,u,7,2>, lane 1
    3201769473U, // <7,4,7,3>: Cost 3 ins <7,u,7,3>, lane 1
    2847509964U, // <7,4,7,4>: Cost 3 vuzpr <4,7,5,4>, <4,7,5,4>
    1858964790U, // <7,4,7,5>: Cost 2 vzipl <7,7,7,7>, RHS
    1993182518U, // <7,4,7,6>: Cost 2 vtrnl <7,7,7,7>, RHS
    2128060417U, // <7,4,7,7>: Cost 2 ins <7,u,7,7>, lane 1
    1858965033U, // <7,4,7,u>: Cost 2 vzipl <7,7,7,7>, RHS
    1640312302U, // <7,4,u,0>: Cost 2 vext3 RHS, <4,u,0,2>
    1577899822U, // <7,4,u,1>: Cost 2 vext2 <5,6,7,4>, LHS
    2127577089U, // <7,4,u,2>: Cost 2 ins <7,u,1,2>, lane 1
    2125488133U, // <7,4,u,3>: Cost 2 ins <7,4,u,u>, lane 5
    1640312342U, // <7,4,u,4>: Cost 2 vext3 RHS, <4,u,4,6>
    1638469146U, // <7,4,u,5>: Cost 2 vext3 RHS, <4,u,5,1>
    564579881U,  // <7,4,u,6>: Cost 1 vext3 RHS, RHS
    2125266947U, // <7,4,u,7>: Cost 2 ins <7,4,5,u>, lane 3
    564579899U,  // <7,4,u,u>: Cost 1 vext3 RHS, RHS
    2579038310U, // <7,5,0,0>: Cost 3 vext1 <4,7,5,0>, LHS
    2131476480U, // <7,5,0,1>: Cost 2 ins <u,5,0,1>, lane 0
    1722597478U, // <7,5,0,2>: Cost 2 vuzpl <7,4,5,6>, LHS
    3201253377U, // <7,5,0,3>: Cost 3 ins <7,u,0,3>, lane 1
    2712063586U, // <7,5,0,4>: Cost 3 vext3 RHS, <5,0,4,1>
    2987150554U, // <7,5,0,5>: Cost 3 vzipr <5,6,7,0>, <4,4,5,5>
    2987149826U, // <7,5,0,6>: Cost 3 vzipr <5,6,7,0>, <3,4,5,6>
    2131525632U, // <7,5,0,7>: Cost 2 ins <u,5,0,7>, lane 0
    1722597532U, // <7,5,0,u>: Cost 2 vuzpl <7,4,5,6>, LHS
    2714054287U, // <7,5,1,0>: Cost 3 vext3 RHS, <5,1,0,1>
    2249183358U, // <7,5,1,1>: Cost 3 vrev <5,7,1,1>
    2127577089U, // <7,5,1,2>: Cost 2 ins <7,u,1,2>, lane 1
    1785643110U, // <7,5,1,3>: Cost 2 vuzpr <6,7,4,5>, LHS
    2714054327U, // <7,5,1,4>: Cost 3 vext3 RHS, <5,1,4,5>
    3127496708U, // <7,5,1,5>: Cost 3 vtrnr <6,7,0,1>, <5,5,5,5>
    2590995323U, // <7,5,1,6>: Cost 3 vext1 <6,7,5,1>, <6,7,5,1>
    1638469328U, // <7,5,1,7>: Cost 2 vext3 RHS, <5,1,7,3>
    1638469337U, // <7,5,1,u>: Cost 2 vext3 RHS, <5,1,u,3>
    2249117814U, // <7,5,2,0>: Cost 3 vrev <5,7,0,2>
    2714054379U, // <7,5,2,1>: Cost 3 vext3 RHS, <5,2,1,3>
    2249265288U, // <7,5,2,2>: Cost 3 vrev <5,7,2,2>
    2131640320U, // <7,5,2,3>: Cost 2 ins <u,5,2,3>, lane 0
    2859385754U, // <7,5,2,4>: Cost 3 vuzpr <6,7,4,5>, <1,2,3,4>
    2714054415U, // <7,5,2,5>: Cost 3 vext3 RHS, <5,2,5,3>
    2712063768U, // <7,5,2,6>: Cost 3 vext3 RHS, <5,2,6,3>
    2131673088U, // <7,5,2,7>: Cost 2 ins <u,5,2,7>, lane 0
    2131640320U, // <7,5,2,u>: Cost 2 ins <u,5,2,3>, lane 0
    3201449985U, // <7,5,3,0>: Cost 3 ins <7,u,3,0>, lane 1
    1175457920U, // <7,5,3,1>: Cost 2 vrev <5,7,1,3>
    2249273481U, // <7,5,3,2>: Cost 3 vrev <5,7,2,3>
    2249347218U, // <7,5,3,3>: Cost 3 vrev <5,7,3,3>
    3201482753U, // <7,5,3,4>: Cost 3 ins <7,u,3,4>, lane 1
    2983857370U, // <7,5,3,5>: Cost 3 vzipr <5,1,7,3>, <4,4,5,5>
    2983856642U, // <7,5,3,6>: Cost 3 vzipr <5,1,7,3>, <3,4,5,6>
    2047872310U, // <7,5,3,7>: Cost 2 vtrnr <5,7,1,3>, RHS
    2047872311U, // <7,5,3,u>: Cost 2 vtrnr <5,7,1,3>, RHS
    2579071078U, // <7,5,4,0>: Cost 3 vext1 <4,7,5,4>, LHS
    2987182994U, // <7,5,4,1>: Cost 3 vzipr <5,6,7,4>, <4,0,5,1>
    2249281674U, // <7,5,4,2>: Cost 3 vrev <5,7,2,4>
    3201548289U, // <7,5,4,3>: Cost 3 ins <7,u,4,3>, lane 1
    2579074508U, // <7,5,4,4>: Cost 3 vext1 <4,7,5,4>, <4,7,5,4>
    2131804160U, // <7,5,4,5>: Cost 2 ins <u,5,4,5>, lane 0
    1722600758U, // <7,5,4,6>: Cost 2 vuzpl <7,4,5,6>, RHS
    1638322118U, // <7,5,4,7>: Cost 2 vext3 RHS, <5,4,7,6>
    1638469583U, // <7,5,4,u>: Cost 2 vext3 RHS, <5,4,u,6>
    2714054611U, // <7,5,5,0>: Cost 3 vext3 RHS, <5,5,0,1>
    2714054620U, // <7,5,5,1>: Cost 3 vext3 RHS, <5,5,1,1>
    3201613825U, // <7,5,5,2>: Cost 3 ins <7,u,5,2>, lane 1
    2649657204U, // <7,5,5,3>: Cost 3 vext2 <5,3,7,5>, <5,3,7,5>
    2714054651U, // <7,5,5,4>: Cost 3 vext3 RHS, <5,5,4,5>
    1638322180U, // <7,5,5,5>: Cost 2 vext3 RHS, <5,5,5,5>
    2127904769U, // <7,5,5,6>: Cost 2 ins <7,u,5,6>, lane 1
    1638469656U, // <7,5,5,7>: Cost 2 vext3 RHS, <5,5,7,7>
    1638469665U, // <7,5,5,u>: Cost 2 vext3 RHS, <5,5,u,7>
    2131910656U, // <7,5,6,0>: Cost 2 ins <u,5,6,0>, lane 0
    2131918848U, // <7,5,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    2131927040U, // <7,5,6,2>: Cost 2 ins <u,5,6,2>, lane 0
    2131935232U, // <7,5,6,3>: Cost 2 ins <u,5,6,3>, lane 0
    2131943424U, // <7,5,6,4>: Cost 2 ins <u,5,6,4>, lane 0
    2131951616U, // <7,5,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    2131959808U, // <7,5,6,6>: Cost 2 ins <u,5,6,6>, lane 0
    1058226176U, // <7,5,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <7,5,6,u>: Cost 1 ins RHS, lane 0
    1511325798U, // <7,5,7,0>: Cost 2 vext1 <5,7,5,7>, LHS
    1638469760U, // <7,5,7,1>: Cost 2 vext3 RHS, <5,7,1,3>
    2712211590U, // <7,5,7,2>: Cost 3 vext3 RHS, <5,7,2,0>
    2573126390U, // <7,5,7,3>: Cost 3 vext1 <3,7,5,7>, <3,7,5,7>
    1511329078U, // <7,5,7,4>: Cost 2 vext1 <5,7,5,7>, RHS
    1638469800U, // <7,5,7,5>: Cost 2 vext3 RHS, <5,7,5,7>
    2712211626U, // <7,5,7,6>: Cost 3 vext3 RHS, <5,7,6,0>
    2048199990U, // <7,5,7,7>: Cost 2 vtrnr <5,7,5,7>, RHS
    1638469823U, // <7,5,7,u>: Cost 2 vext3 RHS, <5,7,u,3>
    1511333990U, // <7,5,u,0>: Cost 2 vext1 <5,7,5,u>, LHS
    1638469841U, // <7,5,u,1>: Cost 2 vext3 RHS, <5,u,1,3>
    1722603310U, // <7,5,u,2>: Cost 2 vuzpl <7,4,5,6>, LHS
    1785643677U, // <7,5,u,3>: Cost 2 vuzpr <6,7,4,5>, LHS
    1511337270U, // <7,5,u,4>: Cost 2 vext1 <5,7,5,u>, RHS
    1638469881U, // <7,5,u,5>: Cost 2 vext3 RHS, <5,u,5,7>
    1722603674U, // <7,5,u,6>: Cost 2 vuzpl <7,4,5,6>, RHS
    1058226176U, // <7,5,u,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <7,5,u,u>: Cost 1 ins RHS, lane 0
    2650324992U, // <7,6,0,0>: Cost 3 vext2 <5,4,7,6>, <0,0,0,0>
    1576583270U, // <7,6,0,1>: Cost 2 vext2 <5,4,7,6>, LHS
    2132148224U, // <7,6,0,2>: Cost 2 ins <u,6,0,2>, lane 0
    2255295336U, // <7,6,0,3>: Cost 3 vrev <6,7,3,0>
    2712064316U, // <7,6,0,4>: Cost 3 vext3 RHS, <6,0,4,2>
    2987151292U, // <7,6,0,5>: Cost 3 vzipr <5,6,7,0>, <5,4,6,5>
    2987150564U, // <7,6,0,6>: Cost 3 vzipr <5,6,7,0>, <4,4,6,6>
    1913408822U, // <7,6,0,7>: Cost 2 vzipr <5,6,7,0>, RHS
    1576583837U, // <7,6,0,u>: Cost 2 vext2 <5,4,7,6>, LHS
    1181340494U, // <7,6,1,0>: Cost 2 vrev <6,7,0,1>
    2650325812U, // <7,6,1,1>: Cost 3 vext2 <5,4,7,6>, <1,1,1,1>
    2127577089U, // <7,6,1,2>: Cost 2 ins <7,u,1,2>, lane 1
    2841329766U, // <7,6,1,3>: Cost 3 vuzpr <3,7,2,6>, LHS
    2579123666U, // <7,6,1,4>: Cost 3 vext1 <4,7,6,1>, <4,7,6,1>
    2650326160U, // <7,6,1,5>: Cost 3 vext2 <5,4,7,6>, <1,5,3,7>
    2714055072U, // <7,6,1,6>: Cost 3 vext3 RHS, <6,1,6,3>
    2974551350U, // <7,6,1,7>: Cost 3 vzipr <3,5,7,1>, RHS
    1181930390U, // <7,6,1,u>: Cost 2 vrev <6,7,u,1>
    2712211897U, // <7,6,2,0>: Cost 3 vext3 RHS, <6,2,0,1>
    2714055108U, // <7,6,2,1>: Cost 3 vext3 RHS, <6,2,1,3>
    2714055117U, // <7,6,2,2>: Cost 3 vext3 RHS, <6,2,2,3>
    2132303872U, // <7,6,2,3>: Cost 2 ins <u,6,2,3>, lane 0
    2714055137U, // <7,6,2,4>: Cost 3 vext3 RHS, <6,2,4,5>
    2714055148U, // <7,6,2,5>: Cost 3 vext3 RHS, <6,2,5,7>
    2714055152U, // <7,6,2,6>: Cost 3 vext3 RHS, <6,2,6,2>
    1638470138U, // <7,6,2,7>: Cost 2 vext3 RHS, <6,2,7,3>
    1638470147U, // <7,6,2,u>: Cost 2 vext3 RHS, <6,2,u,3>
    2650327190U, // <7,6,3,0>: Cost 3 vext2 <5,4,7,6>, <3,0,1,2>
    3121614200U, // <7,6,3,1>: Cost 3 vtrnr <5,7,1,3>, <4,6,5,1>
    1181504354U, // <7,6,3,2>: Cost 2 vrev <6,7,2,3>
    2650327452U, // <7,6,3,3>: Cost 3 vext2 <5,4,7,6>, <3,3,3,3>
    2712064562U, // <7,6,3,4>: Cost 3 vext3 RHS, <6,3,4,5>
    3206135808U, // <7,6,3,5>: Cost 3 ins <u,6,3,5>, lane 0
    2983857380U, // <7,6,3,6>: Cost 3 vzipr <5,1,7,3>, <4,4,6,6>
    1910115638U, // <7,6,3,7>: Cost 2 vzipr <5,1,7,3>, RHS
    1910115639U, // <7,6,3,u>: Cost 2 vzipr <5,1,7,3>, RHS
    2650327954U, // <7,6,4,0>: Cost 3 vext2 <5,4,7,6>, <4,0,5,1>
    2735952486U, // <7,6,4,1>: Cost 3 vext3 RHS, <6,4,1,3>
    2714055276U, // <7,6,4,2>: Cost 3 vext3 RHS, <6,4,2,0>
    2255328108U, // <7,6,4,3>: Cost 3 vrev <6,7,3,4>
    2650328272U, // <7,6,4,4>: Cost 3 vext2 <5,4,7,6>, <4,4,4,4>
    1576586550U, // <7,6,4,5>: Cost 2 vext2 <5,4,7,6>, RHS
    2132475904U, // <7,6,4,6>: Cost 2 ins <u,6,4,6>, lane 0
    1913441590U, // <7,6,4,7>: Cost 2 vzipr <5,6,7,4>, RHS
    1576586793U, // <7,6,4,u>: Cost 2 vext2 <5,4,7,6>, RHS
    2579152998U, // <7,6,5,0>: Cost 3 vext1 <4,7,6,5>, LHS
    2650328784U, // <7,6,5,1>: Cost 3 vext2 <5,4,7,6>, <5,1,7,3>
    2714055364U, // <7,6,5,2>: Cost 3 vext3 RHS, <6,5,2,7>
    3201622017U, // <7,6,5,3>: Cost 3 ins <7,u,5,3>, lane 1
    1576587206U, // <7,6,5,4>: Cost 2 vext2 <5,4,7,6>, <5,4,7,6>
    2650329092U, // <7,6,5,5>: Cost 3 vext2 <5,4,7,6>, <5,5,5,5>
    2127904769U, // <7,6,5,6>: Cost 2 ins <7,u,5,6>, lane 1
    2971929910U, // <7,6,5,7>: Cost 3 vzipr <3,1,7,5>, RHS
    1181963162U, // <7,6,5,u>: Cost 2 vrev <6,7,u,5>
    2714055421U, // <7,6,6,0>: Cost 3 vext3 RHS, <6,6,0,1>
    2714055432U, // <7,6,6,1>: Cost 3 vext3 RHS, <6,6,1,3>
    2712212245U, // <7,6,6,2>: Cost 3 vext3 RHS, <6,6,2,7>
    3201695745U, // <7,6,6,3>: Cost 3 ins <7,u,6,3>, lane 1
    2714055461U, // <7,6,6,4>: Cost 3 vext3 RHS, <6,6,4,5>
    2714055472U, // <7,6,6,5>: Cost 3 vext3 RHS, <6,6,5,7>
    1638323000U, // <7,6,6,6>: Cost 2 vext3 RHS, <6,6,6,6>
    1638470466U, // <7,6,6,7>: Cost 2 vext3 RHS, <6,6,7,7>
    1638470475U, // <7,6,6,u>: Cost 2 vext3 RHS, <6,6,u,7>
    1638323022U, // <7,6,7,0>: Cost 2 vext3 RHS, <6,7,0,1>
    2712064854U, // <7,6,7,1>: Cost 3 vext3 RHS, <6,7,1,0>
    1638323042U, // <7,6,7,2>: Cost 2 vext3 RHS, <6,7,2,3>
    2712064872U, // <7,6,7,3>: Cost 3 vext3 RHS, <6,7,3,0>
    1638323062U, // <7,6,7,4>: Cost 2 vext3 RHS, <6,7,4,5>
    2712064894U, // <7,6,7,5>: Cost 3 vext3 RHS, <6,7,5,4>
    1638323082U, // <7,6,7,6>: Cost 2 vext3 RHS, <6,7,6,7>
    1912802614U, // <7,6,7,7>: Cost 2 vzipr <5,5,7,7>, RHS
    1638323094U, // <7,6,7,u>: Cost 2 vext3 RHS, <6,7,u,1>
    1638470559U, // <7,6,u,0>: Cost 2 vext3 RHS, <6,u,0,1>
    1576589102U, // <7,6,u,1>: Cost 2 vext2 <5,4,7,6>, LHS
    2132148224U, // <7,6,u,2>: Cost 2 ins <u,6,0,2>, lane 0
    2132303872U, // <7,6,u,3>: Cost 2 ins <u,6,2,3>, lane 0
    1638470599U, // <7,6,u,4>: Cost 2 vext3 RHS, <6,u,4,5>
    1576589466U, // <7,6,u,5>: Cost 2 vext2 <5,4,7,6>, RHS
    2132475904U, // <7,6,u,6>: Cost 2 ins <u,6,4,6>, lane 0
    1638470624U, // <7,6,u,7>: Cost 2 vext3 RHS, <6,u,7,3>
    1638470631U, // <7,6,u,u>: Cost 2 vext3 RHS, <6,u,u,1>
    1913409634U, // <7,7,0,0>: Cost 2 vzipr <5,6,7,0>, <5,6,7,0>
    1638323194U, // <7,7,0,1>: Cost 2 vext3 RHS, <7,0,1,2>
    1724743782U, // <7,7,0,2>: Cost 2 vuzpl <7,7,7,7>, LHS
    2987151056U, // <7,7,0,3>: Cost 3 vzipr <5,6,7,0>, <5,1,7,3>
    2712065044U, // <7,7,0,4>: Cost 3 vext3 RHS, <7,0,4,1>
    2585161907U, // <7,7,0,5>: Cost 3 vext1 <5,7,7,0>, <5,7,7,0>
    2987151302U, // <7,7,0,6>: Cost 3 vzipr <5,6,7,0>, <5,4,7,6>
    2127470594U, // <7,7,0,7>: Cost 2 ins <7,7,u,7>, lane 2
    1638323257U, // <7,7,0,u>: Cost 2 vext3 RHS, <7,0,u,2>
    2712065091U, // <7,7,1,0>: Cost 3 vext3 RHS, <7,1,0,3>
    2053755726U, // <7,7,1,1>: Cost 2 vtrnr <6,7,0,1>, <6,7,0,1>
    2127577089U, // <7,7,1,2>: Cost 2 ins <7,u,1,2>, lane 1
    1779761254U, // <7,7,1,3>: Cost 2 vuzpr <5,7,5,7>, LHS
    2585169206U, // <7,7,1,4>: Cost 3 vext1 <5,7,7,1>, RHS
    2693928048U, // <7,7,1,5>: Cost 3 vext3 <1,5,3,7>, <7,1,5,3>
    2585170766U, // <7,7,1,6>: Cost 3 vext1 <5,7,7,1>, <6,7,0,1>
    2127470594U, // <7,7,1,7>: Cost 2 ins <7,7,u,7>, lane 2
    1779761259U, // <7,7,1,u>: Cost 2 vuzpr <5,7,5,7>, LHS
    2853503894U, // <7,7,2,0>: Cost 3 vuzpr <5,7,5,7>, <1,2,3,0>
    3206692864U, // <7,7,2,1>: Cost 3 ins <u,7,2,1>, lane 0
    1988801621U, // <7,7,2,2>: Cost 2 vtrnl <7,1,2,3>, <7,1,2,3>
    2132967424U, // <7,7,2,3>: Cost 2 ins <u,7,2,3>, lane 0
    2853503898U, // <7,7,2,4>: Cost 3 vuzpr <5,7,5,7>, <1,2,3,4>
    3206725632U, // <7,7,2,5>: Cost 3 ins <u,7,2,5>, lane 0
    2700563658U, // <7,7,2,6>: Cost 3 vext3 <2,6,3,7>, <7,2,6,3>
    2127470594U, // <7,7,2,7>: Cost 2 ins <7,7,u,7>, lane 2
    1988801621U, // <7,7,2,u>: Cost 2 vtrnl <7,1,2,3>, <7,1,2,3>
    2712065251U, // <7,7,3,0>: Cost 3 vext3 RHS, <7,3,0,1>
    3121615694U, // <7,7,3,1>: Cost 3 vtrnr <5,7,1,3>, <6,7,0,1>
    3201171458U, // <7,7,3,2>: Cost 3 ins <7,7,u,2>, lane 2
    1910116048U, // <7,7,3,3>: Cost 2 vzipr <5,1,7,3>, <5,1,7,3>
    2712065291U, // <7,7,3,4>: Cost 3 vext3 RHS, <7,3,4,5>
    2639055462U, // <7,7,3,5>: Cost 3 vext2 <3,5,7,7>, <3,5,7,7>
    2639719095U, // <7,7,3,6>: Cost 3 vext2 <3,6,7,7>, <3,6,7,7>
    2127470594U, // <7,7,3,7>: Cost 2 ins <7,7,u,7>, lane 2
    1910116048U, // <7,7,3,u>: Cost 2 vzipr <5,1,7,3>, <5,1,7,3>
    2712212792U, // <7,7,4,0>: Cost 3 vext3 RHS, <7,4,0,5>
    3062715386U, // <7,7,4,1>: Cost 3 vtrnl <7,1,4,6>, <7,0,1,2>
    3201540097U, // <7,7,4,2>: Cost 3 ins <7,u,4,2>, lane 1
    2987183824U, // <7,7,4,3>: Cost 3 vzipr <5,6,7,4>, <5,1,7,3>
    1913442406U, // <7,7,4,4>: Cost 2 vzipr <5,6,7,4>, <5,6,7,4>
    1638323558U, // <7,7,4,5>: Cost 2 vext3 RHS, <7,4,5,6>
    1724747062U, // <7,7,4,6>: Cost 2 vuzpl <7,7,7,7>, RHS
    2127470594U, // <7,7,4,7>: Cost 2 ins <7,7,u,7>, lane 2
    1638323585U, // <7,7,4,u>: Cost 2 vext3 RHS, <7,4,u,6>
    2853508547U, // <7,7,5,0>: Cost 3 vuzpr <5,7,5,7>, <7,5,7,0>
    2712212884U, // <7,7,5,1>: Cost 3 vext3 RHS, <7,5,1,7>
    3201613825U, // <7,7,5,2>: Cost 3 ins <7,u,5,2>, lane 1
    2649673590U, // <7,7,5,3>: Cost 3 vext2 <5,3,7,7>, <5,3,7,7>
    2712065455U, // <7,7,5,4>: Cost 3 vext3 RHS, <7,5,4,7>
    1577259032U, // <7,7,5,5>: Cost 2 vext2 <5,5,7,7>, <5,5,7,7>
    2127904769U, // <7,7,5,6>: Cost 2 ins <7,u,5,6>, lane 1
    1779764534U, // <7,7,5,7>: Cost 2 vuzpr <5,7,5,7>, RHS
    1779764535U, // <7,7,5,u>: Cost 2 vuzpr <5,7,5,7>, RHS
    2985873506U, // <7,7,6,0>: Cost 3 vzipr <5,4,7,6>, <5,6,7,0>
    2735953374U, // <7,7,6,1>: Cost 3 vext3 RHS, <7,6,1,0>
    2712212974U, // <7,7,6,2>: Cost 3 vext3 RHS, <7,6,2,7>
    2985873104U, // <7,7,6,3>: Cost 3 vzipr <5,4,7,6>, <5,1,7,3>
    2985873510U, // <7,7,6,4>: Cost 3 vzipr <5,4,7,6>, <5,6,7,4>
    2985873511U, // <7,7,6,5>: Cost 3 vzipr <5,4,7,6>, <5,6,7,5>
    1912131526U, // <7,7,6,6>: Cost 2 vzipr <5,4,7,6>, <5,4,7,6>
    2133295104U, // <7,7,6,7>: Cost 2 ins <u,7,6,7>, lane 0
    1585222628U, // <7,7,6,u>: Cost 2 vext2 <6,u,7,7>, <6,u,7,7>
    1523417190U, // <7,7,7,0>: Cost 2 vext1 <7,7,7,7>, LHS
    2127405059U, // <7,7,7,1>: Cost 2 ins <7,7,7,u>, lane 3
    2127405059U, // <7,7,7,2>: Cost 2 ins <7,7,7,u>, lane 3
    2127405059U, // <7,7,7,3>: Cost 2 ins <7,7,7,u>, lane 3
    1523420470U, // <7,7,7,4>: Cost 2 vext1 <7,7,7,7>, RHS
    2127405059U, // <7,7,7,5>: Cost 2 ins <7,7,7,u>, lane 3
    2127405059U, // <7,7,7,6>: Cost 2 ins <7,7,7,u>, lane 3
    363253046U,  // <7,7,7,7>: Cost 1 vdup3 RHS
    363253046U,  // <7,7,7,u>: Cost 1 vdup3 RHS
    1913409634U, // <7,7,u,0>: Cost 2 vzipr <5,6,7,0>, <5,6,7,0>
    1638471298U, // <7,7,u,1>: Cost 2 vext3 RHS, <7,u,1,2>
    1724749614U, // <7,7,u,2>: Cost 2 vuzpl <7,7,7,7>, LHS
    1779761821U, // <7,7,u,3>: Cost 2 vuzpr <5,7,5,7>, LHS
    1913442406U, // <7,7,u,4>: Cost 2 vzipr <5,6,7,4>, <5,6,7,4>
    1638471338U, // <7,7,u,5>: Cost 2 vext3 RHS, <7,u,5,6>
    1724749978U, // <7,7,u,6>: Cost 2 vuzpl <7,7,7,7>, RHS
    363253046U,  // <7,7,u,7>: Cost 1 vdup3 RHS
    363253046U,  // <7,7,u,u>: Cost 1 vdup3 RHS
    1638318080U, // <7,u,0,0>: Cost 2 vext3 RHS, <0,0,0,0>
    1638323923U, // <7,u,0,1>: Cost 2 vext3 RHS, <u,0,1,2>
    1720131686U, // <7,u,0,2>: Cost 2 vuzpl <7,0,u,2>, LHS
    1638323941U, // <7,u,0,3>: Cost 2 vext3 RHS, <u,0,3,2>
    2712065773U, // <7,u,0,4>: Cost 3 vext3 RHS, <u,0,4,1>
    1853839514U, // <7,u,0,5>: Cost 2 vzipl <7,0,1,2>, RHS
    1662359296U, // <7,u,0,6>: Cost 2 vext3 RHS, <u,0,6,2>
    1913408840U, // <7,u,0,7>: Cost 2 vzipr <5,6,7,0>, RHS
    1638323986U, // <7,u,0,u>: Cost 2 vext3 RHS, <u,0,u,2>
    1517469798U, // <7,u,1,0>: Cost 2 vext1 <6,7,u,1>, LHS
    2128232448U, // <7,u,1,1>: Cost 2 ins <u,0,1,1>, lane 0
    564582190U,  // <7,u,1,2>: Cost 1 vext3 RHS, LHS
    1638324023U, // <7,u,1,3>: Cost 2 vext3 RHS, <u,1,3,3>
    1517473078U, // <7,u,1,4>: Cost 2 vext1 <6,7,u,1>, RHS
    2122317827U, // <7,u,1,5>: Cost 2 ins <7,0,1,u>, lane 3
    1517474710U, // <7,u,1,6>: Cost 2 vext1 <6,7,u,1>, <6,7,u,1>
    1640462171U, // <7,u,1,7>: Cost 2 vext3 RHS, <u,1,7,3>
    564582244U,  // <7,u,1,u>: Cost 1 vext3 RHS, LHS
    1662211948U, // <7,u,2,0>: Cost 2 vext3 RHS, <u,2,0,2>
    2128969728U, // <7,u,2,1>: Cost 2 ins <u,1,2,1>, lane 0
    2128314368U, // <7,u,2,2>: Cost 2 ins <u,0,2,2>, lane 0
    1055244288U, // <7,u,2,3>: Cost 1 ins LHS, lane 0
    1662211988U, // <7,u,2,4>: Cost 2 vext3 RHS, <u,2,4,6>
    2129002496U, // <7,u,2,5>: Cost 2 ins <u,1,2,5>, lane 0
    2131001344U, // <7,u,2,6>: Cost 2 ins <u,4,2,6>, lane 0
    1640314796U, // <7,u,2,7>: Cost 2 vext3 RHS, <u,2,7,3>
    1055244288U, // <7,u,2,u>: Cost 1 ins LHS, lane 0
    1638324156U, // <7,u,3,0>: Cost 2 vext3 RHS, <u,3,0,1>
    1638324167U, // <7,u,3,1>: Cost 2 vext3 RHS, <u,3,1,3>
    2128388096U, // <7,u,3,2>: Cost 2 ins <u,0,3,2>, lane 0
    1910112412U, // <7,u,3,3>: Cost 2 vzipr <5,1,7,3>, LHS
    1638324196U, // <7,u,3,4>: Cost 2 vext3 RHS, <u,3,4,5>
    1638324207U, // <7,u,3,5>: Cost 2 vext3 RHS, <u,3,5,7>
    2125471746U, // <7,u,3,6>: Cost 2 ins <7,4,u,6>, lane 2
    1910115656U, // <7,u,3,7>: Cost 2 vzipr <5,1,7,3>, RHS
    1638324228U, // <7,u,3,u>: Cost 2 vext3 RHS, <u,3,u,1>
    2712066061U, // <7,u,4,0>: Cost 3 vext3 RHS, <u,4,0,1>
    1856821038U, // <7,u,4,1>: Cost 2 vzipl <7,4,5,6>, LHS
    1662212132U, // <7,u,4,2>: Cost 2 vext3 RHS, <u,4,2,6>
    1913438364U, // <7,u,4,3>: Cost 2 vzipr <5,6,7,4>, LHS
    1638321360U, // <7,u,4,4>: Cost 2 vext3 RHS, <4,4,4,4>
    1638324287U, // <7,u,4,5>: Cost 2 vext3 RHS, <u,4,5,6>
    1720134966U, // <7,u,4,6>: Cost 2 vuzpl <7,0,u,2>, RHS
    1640314961U, // <7,u,4,7>: Cost 2 vext3 RHS, <u,4,7,6>
    1638324314U, // <7,u,4,u>: Cost 2 vext3 RHS, <u,4,u,6>
    1517502566U, // <7,u,5,0>: Cost 2 vext1 <6,7,u,5>, LHS
    1574612693U, // <7,u,5,1>: Cost 2 vext2 <5,1,7,u>, <5,1,7,u>
    1991038766U, // <7,u,5,2>: Cost 2 vtrnl <7,4,5,6>, LHS
    1638324351U, // <7,u,5,3>: Cost 2 vext3 RHS, <u,5,3,7>
    1576603592U, // <7,u,5,4>: Cost 2 vext2 <5,4,7,u>, <5,4,7,u>
    1577267225U, // <7,u,5,5>: Cost 2 vext2 <5,5,7,u>, <5,5,7,u>
    564582554U,  // <7,u,5,6>: Cost 1 vext3 RHS, RHS
    1640462499U, // <7,u,5,7>: Cost 2 vext3 RHS, <u,5,7,7>
    564582572U,  // <7,u,5,u>: Cost 1 vext3 RHS, RHS
    1662359728U, // <7,u,6,0>: Cost 2 vext3 RHS, <u,6,0,2>
    2131918848U, // <7,u,6,1>: Cost 2 ins <u,5,6,1>, lane 0
    1581249023U, // <7,u,6,2>: Cost 2 vext2 <6,2,7,u>, <6,2,7,u>
    1638324432U, // <7,u,6,3>: Cost 2 vext3 RHS, <u,6,3,7>
    1662359768U, // <7,u,6,4>: Cost 2 vext3 RHS, <u,6,4,6>
    2131951616U, // <7,u,6,5>: Cost 2 ins <u,5,6,5>, lane 0
    1583903555U, // <7,u,6,6>: Cost 2 vext2 <6,6,7,u>, <6,6,7,u>
    1058226176U, // <7,u,6,7>: Cost 1 ins RHS, lane 0
    1058226176U, // <7,u,6,u>: Cost 1 ins RHS, lane 0
    1638471936U, // <7,u,7,0>: Cost 2 vext3 RHS, <u,7,0,1>
    1640462603U, // <7,u,7,1>: Cost 2 vext3 RHS, <u,7,1,3>
    1993185070U, // <7,u,7,2>: Cost 2 vtrnl <7,7,7,7>, LHS
    1912799388U, // <7,u,7,3>: Cost 2 vzipr <5,5,7,7>, LHS
    1638471976U, // <7,u,7,4>: Cost 2 vext3 RHS, <u,7,4,5>
    1640462643U, // <7,u,7,5>: Cost 2 vext3 RHS, <u,7,5,7>
    1993185434U, // <7,u,7,6>: Cost 2 vtrnl <7,7,7,7>, RHS
    363253046U,  // <7,u,7,7>: Cost 1 vdup3 RHS
    363253046U,  // <7,u,7,u>: Cost 1 vdup3 RHS
    1638324561U, // <7,u,u,0>: Cost 2 vext3 RHS, <u,u,0,1>
    1638324571U, // <7,u,u,1>: Cost 2 vext3 RHS, <u,u,1,2>
    564582757U,  // <7,u,u,2>: Cost 1 vext3 RHS, LHS
    1055244288U, // <7,u,u,3>: Cost 1 ins LHS, lane 0
    1638324601U, // <7,u,u,4>: Cost 2 vext3 RHS, <u,u,4,5>
    1638324611U, // <7,u,u,5>: Cost 2 vext3 RHS, <u,u,5,6>
    564582797U,  // <7,u,u,6>: Cost 1 vext3 RHS, RHS
    1058226176U, // <7,u,u,7>: Cost 1 ins RHS, lane 0
    564582811U,  // <7,u,u,u>: Cost 1 vext3 RHS, LHS
    135053414U,  // <u,0,0,0>: Cost 1 vdup0 LHS
    1611489290U, // <u,0,0,1>: Cost 2 vext3 LHS, <0,0,1,1>
    1611489300U, // <u,0,0,2>: Cost 2 vext3 LHS, <0,0,2,2>
    2085707777U, // <u,0,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    1481706806U, // <u,0,0,4>: Cost 2 vext1 <0,u,0,0>, RHS
    2080440323U, // <u,0,0,5>: Cost 2 ins <0,0,0,u>, lane 3
    2080440323U, // <u,0,0,6>: Cost 2 ins <0,0,0,u>, lane 3
    2080440323U, // <u,0,0,7>: Cost 2 ins <0,0,0,u>, lane 3
    135053414U,  // <u,0,0,u>: Cost 1 vdup0 LHS
    1493655654U, // <u,0,1,0>: Cost 2 vext1 <2,u,0,1>, LHS
    786808934U,  // <u,0,1,1>: Cost 1 vzipl LHS, LHS
    537747563U,  // <u,0,1,2>: Cost 1 vext3 LHS, LHS
    1756332134U, // <u,0,1,3>: Cost 2 vuzpr <1,u,3,0>, LHS
    1493658934U, // <u,0,1,4>: Cost 2 vext1 <2,u,0,1>, RHS
    2085797889U, // <u,0,1,5>: Cost 2 ins <0,u,1,5>, lane 1
    1517548447U, // <u,0,1,6>: Cost 2 vext1 <6,u,0,1>, <6,u,0,1>
    2080514051U, // <u,0,1,7>: Cost 2 ins <0,0,1,u>, lane 3
    537747612U,  // <u,0,1,u>: Cost 1 vext3 LHS, LHS
    1611489444U, // <u,0,2,0>: Cost 2 vext3 LHS, <0,2,0,2>
    1994768394U, // <u,0,2,1>: Cost 2 vtrnl LHS, <0,0,1,1>
    921026662U,  // <u,0,2,2>: Cost 1 vtrnl LHS, LHS
    1012113409U, // <u,0,2,3>: Cost 1 ins LHS, lane 1
    1611489484U, // <u,0,2,4>: Cost 2 vext3 LHS, <0,2,4,6>
    2080587779U, // <u,0,2,5>: Cost 2 ins <0,0,2,u>, lane 3
    2085879809U, // <u,0,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    2080587779U, // <u,0,2,7>: Cost 2 ins <0,0,2,u>, lane 3
    921026716U,  // <u,0,2,u>: Cost 1 vtrnl LHS, LHS
    1880326144U, // <u,0,3,0>: Cost 2 vzipr LHS, <0,0,0,0>
    1880327846U, // <u,0,3,1>: Cost 2 vzipr LHS, <2,3,0,1>
    72589981U,   // <u,0,3,2>: Cost 1 vrev LHS
    2091900929U, // <u,0,3,3>: Cost 2 ins <1,u,3,3>, lane 1
    2091909121U, // <u,0,3,4>: Cost 2 ins <1,u,3,4>, lane 1
    2086633475U, // <u,0,3,5>: Cost 2 ins <1,0,3,u>, lane 3
    2086633475U, // <u,0,3,6>: Cost 2 ins <1,0,3,u>, lane 3
    2091933697U, // <u,0,3,7>: Cost 2 ins <1,u,3,7>, lane 1
    73032403U,   // <u,0,3,u>: Cost 1 vrev LHS
    1705610572U, // <u,0,4,0>: Cost 2 vuzpl <4,6,0,2>, <4,6,0,2>
    1611489618U, // <u,0,4,1>: Cost 2 vext3 LHS, <0,4,1,5>
    1611489628U, // <u,0,4,2>: Cost 2 vext3 LHS, <0,4,2,6>
    2086002689U, // <u,0,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    1947828428U, // <u,0,4,4>: Cost 2 vtrnl <0,2,4,6>, <0,2,4,6>
    1551396150U, // <u,0,4,5>: Cost 2 vext2 <1,2,u,0>, RHS
    1726844214U, // <u,0,4,6>: Cost 2 vuzpl <u,2,0,2>, RHS
    2109923329U, // <u,0,4,7>: Cost 2 ins <4,u,4,7>, lane 1
    1611932050U, // <u,0,4,u>: Cost 2 vext3 LHS, <0,4,u,6>
    1863532544U, // <u,0,5,0>: Cost 2 vzipl RHS, <0,0,0,0>
    789790822U,  // <u,0,5,1>: Cost 1 vzipl RHS, LHS
    1996349542U, // <u,0,5,2>: Cost 2 vtrnl <u,3,5,7>, LHS
    2104696835U, // <u,0,5,3>: Cost 2 ins <4,0,5,u>, lane 3
    1863532882U, // <u,0,5,4>: Cost 2 vzipl RHS, <0,4,1,5>
    2109980673U, // <u,0,5,5>: Cost 2 ins <4,u,5,5>, lane 1
    1577939051U, // <u,0,5,6>: Cost 2 vext2 <5,6,u,0>, <5,6,u,0>
    1756335414U, // <u,0,5,7>: Cost 2 vuzpr <1,u,3,0>, RHS
    789791389U,  // <u,0,5,u>: Cost 1 vzipl RHS, LHS
    1997750272U, // <u,0,6,0>: Cost 2 vtrnl RHS, <0,0,0,0>
    1997750282U, // <u,0,6,1>: Cost 2 vtrnl RHS, <0,0,1,1>
    924008550U,  // <u,0,6,2>: Cost 1 vtrnl RHS, LHS
    2104770563U, // <u,0,6,3>: Cost 2 ins <4,0,6,u>, lane 3
    1146503858U, // <u,0,6,4>: Cost 2 vrev <0,u,4,6>
    2104770563U, // <u,0,6,5>: Cost 2 ins <4,0,6,u>, lane 3
    2110062593U, // <u,0,6,6>: Cost 2 ins <4,u,6,6>, lane 1
    1036328961U, // <u,0,6,7>: Cost 1 ins RHS, lane 1
    924008604U,  // <u,0,6,u>: Cost 1 vtrnl RHS, LHS
    1906900992U, // <u,0,7,0>: Cost 2 vzipr RHS, <0,0,0,0>
    1906902694U, // <u,0,7,1>: Cost 2 vzipr RHS, <2,3,0,1>
    1906901156U, // <u,0,7,2>: Cost 2 vzipr RHS, <0,2,0,2>
    2116083713U, // <u,0,7,3>: Cost 2 ins <5,u,7,3>, lane 1
    2116091905U, // <u,0,7,4>: Cost 2 ins <5,u,7,4>, lane 1
    2980643874U, // <u,0,7,5>: Cost 3 vzipr RHS, <1,4,0,5>
    2116108289U, // <u,0,7,6>: Cost 2 ins <5,u,7,6>, lane 1
    2116116481U, // <u,0,7,7>: Cost 2 ins <5,u,7,7>, lane 1
    1906901162U, // <u,0,7,u>: Cost 2 vzipr RHS, <0,2,0,u>
    135053414U,  // <u,0,u,0>: Cost 1 vdup0 LHS
    791453798U,  // <u,0,u,1>: Cost 1 vzipl LHS, LHS
    537748125U,  // <u,0,u,2>: Cost 1 vext3 LHS, LHS
    1012113409U, // <u,0,u,3>: Cost 1 ins LHS, lane 1
    1611932338U, // <u,0,u,4>: Cost 2 vext3 LHS, <0,u,4,6>
    1551399066U, // <u,0,u,5>: Cost 2 vext2 <1,2,u,0>, RHS
    1517605798U, // <u,0,u,6>: Cost 2 vext1 <6,u,0,u>, <6,u,0,u>
    1036328961U, // <u,0,u,7>: Cost 1 ins RHS, lane 1
    537748179U,  // <u,0,u,u>: Cost 1 vext3 LHS, LHS
    1818149622U, // <u,1,0,0>: Cost 2 vzipl <1,0,3,2>, <1,0,3,2>
    1007951877U, // <u,1,0,1>: Cost 1 ins LHS, lane 5
    1725587558U, // <u,1,0,2>: Cost 2 vuzpl <u,0,1,2>, LHS
    1007910914U, // <u,1,0,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <u,1,0,4>: Cost 2 ins <0,1,u,4>, lane 2
    2081669122U, // <u,1,0,5>: Cost 2 ins <0,1,u,5>, lane 2
    2081677314U, // <u,1,0,6>: Cost 2 ins <0,1,u,6>, lane 2
    2081685506U, // <u,1,0,7>: Cost 2 ins <0,1,u,7>, lane 2
    1007951877U, // <u,1,0,u>: Cost 1 ins LHS, lane 5
    1481786002U, // <u,1,1,0>: Cost 2 vext1 <0,u,1,1>, <0,u,1,1>
    202162278U,  // <u,1,1,1>: Cost 1 vdup1 LHS
    1860551574U, // <u,1,1,2>: Cost 2 vzipl LHS, <1,2,3,0>
    1007910914U, // <u,1,1,3>: Cost 1 ins LHS, lane 2
    1481788726U, // <u,1,1,4>: Cost 2 vext1 <0,u,1,1>, RHS
    1860551824U, // <u,1,1,5>: Cost 2 vzipl LHS, <1,5,3,7>
    2081677314U, // <u,1,1,6>: Cost 2 ins <0,1,u,6>, lane 2
    2081685506U, // <u,1,1,7>: Cost 2 ins <0,1,u,7>, lane 2
    1007910914U, // <u,1,1,u>: Cost 1 ins LHS, lane 2
    1007509507U, // <u,1,2,0>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,2,1>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,2,2>: Cost 1 ins LHS, lane 3
    835584U,     // <u,1,2,3>: Cost 0 copy LHS
    1007509507U, // <u,1,2,4>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,2,5>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,2,6>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,2,7>: Cost 1 ins LHS, lane 3
    835584U,     // <u,1,2,u>: Cost 0 copy LHS
    1487773798U, // <u,1,3,0>: Cost 2 vext1 <1,u,1,3>, LHS
    1611490264U, // <u,1,3,1>: Cost 2 vext3 LHS, <1,3,1,3>
    1880328342U, // <u,1,3,2>: Cost 2 vzipr LHS, <3,0,1,2>
    945004646U,  // <u,1,3,3>: Cost 1 vtrnr LHS, LHS
    1487777078U, // <u,1,3,4>: Cost 2 vext1 <1,u,1,3>, RHS
    1611490304U, // <u,1,3,5>: Cost 2 vext3 LHS, <1,3,5,7>
    2087297027U, // <u,1,3,6>: Cost 2 ins <1,1,3,u>, lane 3
    2133737476U, // <u,1,3,7>: Cost 2 ins <u,u,3,7>, lane 4
    945004651U,  // <u,1,3,u>: Cost 1 vtrnr LHS, LHS
    1567992749U, // <u,1,4,0>: Cost 2 vext2 <4,0,u,1>, <4,0,u,1>
    2081636354U, // <u,1,4,1>: Cost 2 ins <0,1,u,1>, lane 2
    2081644546U, // <u,1,4,2>: Cost 2 ins <0,1,u,2>, lane 2
    1007910914U, // <u,1,4,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <u,1,4,4>: Cost 2 ins <0,1,u,4>, lane 2
    1007951877U, // <u,1,4,5>: Cost 1 ins LHS, lane 5
    1725590838U, // <u,1,4,6>: Cost 2 vuzpl <u,0,1,2>, RHS
    2081685506U, // <u,1,4,7>: Cost 2 ins <0,1,u,7>, lane 2
    1007910914U, // <u,1,4,u>: Cost 1 ins LHS, lane 2
    1481818774U, // <u,1,5,0>: Cost 2 vext1 <0,u,1,5>, <0,u,1,5>
    1863533364U, // <u,1,5,1>: Cost 2 vzipl RHS, <1,1,1,1>
    1863533462U, // <u,1,5,2>: Cost 2 vzipl RHS, <1,2,3,0>
    1007910914U, // <u,1,5,3>: Cost 1 ins LHS, lane 2
    1481821494U, // <u,1,5,4>: Cost 2 vext1 <0,u,1,5>, RHS
    1863533712U, // <u,1,5,5>: Cost 2 vzipl RHS, <1,5,3,7>
    2133876740U, // <u,1,5,6>: Cost 2 ins <u,u,5,6>, lane 4
    1750224182U, // <u,1,5,7>: Cost 2 vuzpr <0,u,1,1>, RHS
    1007910914U, // <u,1,5,u>: Cost 1 ins LHS, lane 2
    2081628162U, // <u,1,6,0>: Cost 2 ins <0,1,u,0>, lane 2
    1997751092U, // <u,1,6,1>: Cost 2 vtrnl RHS, <1,1,1,1>
    2133917700U, // <u,1,6,2>: Cost 2 ins <u,u,6,2>, lane 4
    1007910914U, // <u,1,6,3>: Cost 1 ins LHS, lane 2
    2081660930U, // <u,1,6,4>: Cost 2 ins <0,1,u,4>, lane 2
    1997751296U, // <u,1,6,5>: Cost 2 vtrnl RHS, <1,3,5,7>
    2133950468U, // <u,1,6,6>: Cost 2 ins <u,u,6,6>, lane 4
    1060216836U, // <u,1,6,7>: Cost 1 ins RHS, lane 4
    1007910914U, // <u,1,6,u>: Cost 1 ins LHS, lane 2
    2133975044U, // <u,1,7,0>: Cost 2 ins <u,u,7,0>, lane 4
    1906901002U, // <u,1,7,1>: Cost 2 vzipr RHS, <0,0,1,1>
    1906903190U, // <u,1,7,2>: Cost 2 vzipr RHS, <3,0,1,2>
    969220198U,  // <u,1,7,3>: Cost 1 vtrnr RHS, LHS
    2134007812U, // <u,1,7,4>: Cost 2 ins <u,u,7,4>, lane 4
    1152558485U, // <u,1,7,5>: Cost 2 vrev <1,u,5,7>
    2134024196U, // <u,1,7,6>: Cost 2 ins <u,u,7,6>, lane 4
    2134032388U, // <u,1,7,7>: Cost 2 ins <u,u,7,7>, lane 4
    969220203U,  // <u,1,7,u>: Cost 1 vtrnr RHS, LHS
    1007509507U, // <u,1,u,0>: Cost 1 ins LHS, lane 3
    1007951877U, // <u,1,u,1>: Cost 1 ins LHS, lane 5
    1007509507U, // <u,1,u,2>: Cost 1 ins LHS, lane 3
    835584U,     // <u,1,u,3>: Cost 0 copy LHS
    1007509507U, // <u,1,u,4>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,u,5>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,u,6>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,1,u,7>: Cost 1 ins LHS, lane 3
    835584U,     // <u,1,u,u>: Cost 0 copy LHS
    1726332928U, // <u,2,0,0>: Cost 2 vuzpl LHS, <0,0,0,0>
    1545437286U, // <u,2,0,1>: Cost 2 vext2 <0,2,u,2>, LHS
    652591206U,  // <u,2,0,2>: Cost 1 vuzpl LHS, LHS
    1886937190U, // <u,2,0,3>: Cost 2 vzipr <1,2,u,0>, LHS
    1726333132U, // <u,2,0,4>: Cost 2 vuzpl LHS, <0,2,4,6>
    2081767427U, // <u,2,0,5>: Cost 2 ins <0,2,0,u>, lane 3
    2082340866U, // <u,2,0,6>: Cost 2 ins <0,2,u,6>, lane 2
    2081767427U, // <u,2,0,7>: Cost 2 ins <0,2,0,u>, lane 3
    652591260U,  // <u,2,0,u>: Cost 1 vuzpl LHS, LHS
    1550082851U, // <u,2,1,0>: Cost 2 vext2 <1,0,u,2>, <1,0,u,2>
    1726333748U, // <u,2,1,1>: Cost 2 vuzpl LHS, <1,1,1,1>
    1860552296U, // <u,2,1,2>: Cost 2 vzipl LHS, <2,2,2,2>
    1750155366U, // <u,2,1,3>: Cost 2 vuzpr <0,u,0,2>, LHS
    2088296450U, // <u,2,1,4>: Cost 2 ins <1,2,u,4>, lane 2
    1726333952U, // <u,2,1,5>: Cost 2 vuzpl LHS, <1,3,5,7>
    1860552634U, // <u,2,1,6>: Cost 2 vzipl LHS, <2,6,3,7>
    2109702145U, // <u,2,1,7>: Cost 2 ins <4,u,1,7>, lane 1
    1750155371U, // <u,2,1,u>: Cost 2 vuzpr <0,u,0,2>, LHS
    1481867932U, // <u,2,2,0>: Cost 2 vext1 <0,u,2,2>, <0,u,2,2>
    2085838849U, // <u,2,2,1>: Cost 2 ins <0,u,2,1>, lane 1
    269271142U,  // <u,2,2,2>: Cost 1 vdup2 LHS
    1012113409U, // <u,2,2,3>: Cost 1 ins LHS, lane 1
    1481870646U, // <u,2,2,4>: Cost 2 vext1 <0,u,2,2>, RHS
    2085871617U, // <u,2,2,5>: Cost 2 ins <0,u,2,5>, lane 1
    2085879809U, // <u,2,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    2085888001U, // <u,2,2,7>: Cost 2 ins <0,u,2,7>, lane 1
    1012113409U, // <u,2,2,u>: Cost 1 ins LHS, lane 1
    408134301U,  // <u,2,3,0>: Cost 1 vext1 LHS, LHS
    1481876214U, // <u,2,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
    1880326164U, // <u,2,3,2>: Cost 2 vzipr LHS, <0,0,2,2>
    806584422U,  // <u,2,3,3>: Cost 1 vzipr LHS, LHS
    408137014U,  // <u,2,3,4>: Cost 1 vext1 LHS, RHS
    1726335490U, // <u,2,3,5>: Cost 2 vuzpl LHS, <3,4,5,6>
    1880326492U, // <u,2,3,6>: Cost 2 vzipr LHS, <0,4,2,6>
    1529656314U, // <u,2,3,7>: Cost 2 vext1 LHS, <7,0,1,2>
    806584427U,  // <u,2,3,u>: Cost 1 vzipr LHS, LHS
    1726336332U, // <u,2,4,0>: Cost 2 vuzpl LHS, <4,6,0,2>
    2082062339U, // <u,2,4,1>: Cost 2 ins <0,2,4,u>, lane 3
    2082308098U, // <u,2,4,2>: Cost 2 ins <0,2,u,2>, lane 2
    1886969958U, // <u,2,4,3>: Cost 2 vzipr <1,2,u,4>, LHS
    1726336208U, // <u,2,4,4>: Cost 2 vuzpl LHS, <4,4,4,4>
    1545440566U, // <u,2,4,5>: Cost 2 vext2 <0,2,u,2>, RHS
    652594486U,  // <u,2,4,6>: Cost 1 vuzpl LHS, RHS
    2082062339U, // <u,2,4,7>: Cost 2 ins <0,2,4,u>, lane 3
    652594504U,  // <u,2,4,u>: Cost 1 vuzpl LHS, RHS
    2088263682U, // <u,2,5,0>: Cost 2 ins <1,2,u,0>, lane 2
    1726337152U, // <u,2,5,1>: Cost 2 vuzpl LHS, <5,7,1,3>
    1863534184U, // <u,2,5,2>: Cost 2 vzipl RHS, <2,2,2,2>
    1884987494U, // <u,2,5,3>: Cost 2 vzipr <0,u,u,5>, LHS
    1158441059U, // <u,2,5,4>: Cost 2 vrev <2,u,4,5>
    1726337028U, // <u,2,5,5>: Cost 2 vuzpl LHS, <5,5,5,5>
    1863534522U, // <u,2,5,6>: Cost 2 vzipl RHS, <2,6,3,7>
    1750158646U, // <u,2,5,7>: Cost 2 vuzpr <0,u,0,2>, RHS
    1750158647U, // <u,2,5,u>: Cost 2 vuzpr <0,u,0,2>, RHS
    1481900704U, // <u,2,6,0>: Cost 2 vext1 <0,u,2,6>, <0,u,2,6>
    2110021633U, // <u,2,6,1>: Cost 2 ins <4,u,6,1>, lane 1
    1997751912U, // <u,2,6,2>: Cost 2 vtrnl RHS, <2,2,2,2>
    1611491258U, // <u,2,6,3>: Cost 2 vext3 LHS, <2,6,3,7>
    1481903414U, // <u,2,6,4>: Cost 2 vext1 <0,u,2,6>, RHS
    2110054401U, // <u,2,6,5>: Cost 2 ins <4,u,6,5>, lane 1
    1726337848U, // <u,2,6,6>: Cost 2 vuzpl LHS, <6,6,6,6>
    1036328961U, // <u,2,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <u,2,6,u>: Cost 1 ins RHS, lane 1
    2042962838U, // <u,2,7,0>: Cost 2 vtrnr RHS, <1,2,3,0>
    1726338042U, // <u,2,7,1>: Cost 2 vuzpl LHS, <7,0,1,2>
    1906901012U, // <u,2,7,2>: Cost 2 vzipr RHS, <0,0,2,2>
    833159270U,  // <u,2,7,3>: Cost 1 vzipr RHS, LHS
    2042962842U, // <u,2,7,4>: Cost 2 vtrnr RHS, <1,2,3,4>
    1726338406U, // <u,2,7,5>: Cost 2 vuzpl LHS, <7,4,5,6>
    1906901340U, // <u,2,7,6>: Cost 2 vzipr RHS, <0,4,2,6>
    1726338668U, // <u,2,7,7>: Cost 2 vuzpl LHS, <7,7,7,7>
    833159275U,  // <u,2,7,u>: Cost 1 vzipr RHS, LHS
    408175266U,  // <u,2,u,0>: Cost 1 vext1 LHS, LHS
    1545443118U, // <u,2,u,1>: Cost 2 vext2 <0,2,u,2>, LHS
    652597038U,  // <u,2,u,2>: Cost 1 vuzpl LHS, LHS
    806625382U,  // <u,2,u,3>: Cost 1 vzipr LHS, LHS
    408177974U,  // <u,2,u,4>: Cost 1 vext1 LHS, RHS
    1545443482U, // <u,2,u,5>: Cost 2 vext2 <0,2,u,2>, RHS
    652597402U,  // <u,2,u,6>: Cost 1 vuzpl LHS, RHS
    1036328961U, // <u,2,u,7>: Cost 1 ins RHS, lane 1
    806625387U,  // <u,2,u,u>: Cost 1 vzipr LHS, LHS
    1544781824U, // <u,3,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
    471040156U,  // <u,3,0,1>: Cost 1 vext2 LHS, LHS
    1544781988U, // <u,3,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
    2088951810U, // <u,3,0,3>: Cost 2 ins <1,3,u,3>, lane 2
    1544782162U, // <u,3,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
    2094940162U, // <u,3,0,5>: Cost 2 ins <2,3,u,5>, lane 2
    2094374915U, // <u,3,0,6>: Cost 2 ins <2,3,0,u>, lane 3
    2088984578U, // <u,3,0,7>: Cost 2 ins <1,3,u,7>, lane 2
    471040669U,  // <u,3,0,u>: Cost 1 vext2 LHS, LHS
    1544782582U, // <u,3,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
    1544782644U, // <u,3,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
    1544782742U, // <u,3,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
    676569190U,  // <u,3,1,3>: Cost 1 vuzpr LHS, LHS
    1860553218U, // <u,3,1,4>: Cost 2 vzipl LHS, <3,4,5,6>
    1544782992U, // <u,3,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
    2088476675U, // <u,3,1,6>: Cost 2 ins <1,3,1,u>, lane 3
    2088984578U, // <u,3,1,7>: Cost 2 ins <1,3,u,7>, lane 2
    676569195U,  // <u,3,1,u>: Cost 1 vuzpr LHS, LHS
    1750311830U, // <u,3,2,0>: Cost 2 vuzpr LHS, <1,2,3,0>
    1164167966U, // <u,3,2,1>: Cost 2 vrev <3,u,1,2>
    1544783464U, // <u,3,2,2>: Cost 2 vext2 LHS, <2,2,2,2>
    1012113409U, // <u,3,2,3>: Cost 1 ins LHS, lane 1
    1750311834U, // <u,3,2,4>: Cost 2 vuzpr LHS, <1,2,3,4>
    1994770946U, // <u,3,2,5>: Cost 2 vtrnl LHS, <3,4,5,6>
    1544783802U, // <u,3,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
    2088984578U, // <u,3,2,7>: Cost 2 ins <1,3,u,7>, lane 2
    1012113409U, // <u,3,2,u>: Cost 1 ins LHS, lane 1
    1544784022U, // <u,3,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
    1750312614U, // <u,3,3,1>: Cost 2 vuzpr LHS, <2,3,0,1>
    1880326902U, // <u,3,3,2>: Cost 2 vzipr LHS, <1,0,3,2>
    336380006U,  // <u,3,3,3>: Cost 1 vdup3 LHS
    1544784386U, // <u,3,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
    1750312654U, // <u,3,3,5>: Cost 2 vuzpr LHS, <2,3,4,5>
    2100568067U, // <u,3,3,6>: Cost 2 ins <3,3,3,u>, lane 3
    1880327312U, // <u,3,3,7>: Cost 2 vzipr LHS, <1,5,3,7>
    336380006U,  // <u,3,3,u>: Cost 1 vdup3 LHS
    1487929446U, // <u,3,4,0>: Cost 2 vext1 <1,u,3,4>, LHS
    1487930752U, // <u,3,4,1>: Cost 2 vext1 <1,u,3,4>, <1,u,3,4>
    2094669827U, // <u,3,4,2>: Cost 2 ins <2,3,4,u>, lane 3
    2088951810U, // <u,3,4,3>: Cost 2 ins <1,3,u,3>, lane 2
    1487932726U, // <u,3,4,4>: Cost 2 vext1 <1,u,3,4>, RHS
    471043382U,  // <u,3,4,5>: Cost 1 vext2 LHS, RHS
    1750311260U, // <u,3,4,6>: Cost 2 vuzpr LHS, <0,4,2,6>
    2088984578U, // <u,3,4,7>: Cost 2 ins <1,3,u,7>, lane 2
    471043625U,  // <u,3,4,u>: Cost 1 vext2 LHS, RHS
    1863534742U, // <u,3,5,0>: Cost 2 vzipl RHS, <3,0,1,2>
    1574645465U, // <u,3,5,1>: Cost 2 vext2 <5,1,u,3>, <5,1,u,3>
    2088771587U, // <u,3,5,2>: Cost 2 ins <1,3,5,u>, lane 3
    1863535004U, // <u,3,5,3>: Cost 2 vzipl RHS, <3,3,3,3>
    1592561606U, // <u,3,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
    1592561668U, // <u,3,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
    1592561762U, // <u,3,5,6>: Cost 2 vext2 LHS, <5,6,7,0>
    676572470U,  // <u,3,5,7>: Cost 1 vuzpr LHS, RHS
    676572471U,  // <u,3,5,u>: Cost 1 vuzpr LHS, RHS
    1798090850U, // <u,3,6,0>: Cost 2 vuzpr LHS, <5,6,7,0>
    1997752470U, // <u,3,6,1>: Cost 2 vtrnl RHS, <3,0,1,2>
    1581281795U, // <u,3,6,2>: Cost 2 vext2 <6,2,u,3>, <6,2,u,3>
    1997752732U, // <u,3,6,3>: Cost 2 vtrnl RHS, <3,3,3,3>
    1798090854U, // <u,3,6,4>: Cost 2 vuzpr LHS, <5,6,7,4>
    1164495686U, // <u,3,6,5>: Cost 2 vrev <3,u,5,6>
    1592562488U, // <u,3,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
    1060216836U, // <u,3,6,7>: Cost 1 ins RHS, lane 4
    1060216836U, // <u,3,6,u>: Cost 1 ins RHS, lane 4
    1487954022U, // <u,3,7,0>: Cost 2 vext1 <1,u,3,7>, LHS
    1487955331U, // <u,3,7,1>: Cost 2 vext1 <1,u,3,7>, <1,u,3,7>
    1493928028U, // <u,3,7,2>: Cost 2 vext1 <2,u,3,7>, <2,u,3,7>
    1906901832U, // <u,3,7,3>: Cost 2 vzipr RHS, <1,1,3,3>
    1487957302U, // <u,3,7,4>: Cost 2 vext1 <1,u,3,7>, RHS
    2042963662U, // <u,3,7,5>: Cost 2 vtrnr RHS, <2,3,4,5>
    2134024196U, // <u,3,7,6>: Cost 2 ins <u,u,7,6>, lane 4
    1906902160U, // <u,3,7,7>: Cost 2 vzipr RHS, <1,5,3,7>
    1487959854U, // <u,3,7,u>: Cost 2 vext1 <1,u,3,7>, LHS
    1544787667U, // <u,3,u,0>: Cost 2 vext2 LHS, <u,0,1,2>
    471045934U,  // <u,3,u,1>: Cost 1 vext2 LHS, LHS
    1880367862U, // <u,3,u,2>: Cost 2 vzipr LHS, <1,0,3,2>
    676569757U,  // <u,3,u,3>: Cost 1 vuzpr LHS, LHS
    1544788031U, // <u,3,u,4>: Cost 2 vext2 LHS, <u,4,5,6>
    471046298U,  // <u,3,u,5>: Cost 1 vext2 LHS, RHS
    1750311584U, // <u,3,u,6>: Cost 2 vuzpr LHS, <0,u,2,6>
    676572713U,  // <u,3,u,7>: Cost 1 vuzpr LHS, RHS
    471046501U,  // <u,3,u,u>: Cost 1 vext2 LHS, LHS
    1974046028U, // <u,4,0,0>: Cost 2 vtrnl <4,6,0,2>, <4,6,0,2>
    1551425638U, // <u,4,0,1>: Cost 2 vext2 <1,2,u,4>, LHS
    1727168614U, // <u,4,0,2>: Cost 2 vuzpl <u,2,4,6>, LHS
    2085707777U, // <u,4,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    1679392972U, // <u,4,0,4>: Cost 2 vuzpl <0,2,4,6>, <0,2,4,6>
    1638329234U, // <u,4,0,5>: Cost 2 vext3 RHS, <4,0,5,1>
    1638329244U, // <u,4,0,6>: Cost 2 vext3 RHS, <4,0,6,2>
    2109628417U, // <u,4,0,7>: Cost 2 ins <4,u,0,7>, lane 1
    1551426205U, // <u,4,0,u>: Cost 2 vext2 <1,2,u,4>, LHS
    1860553618U, // <u,4,1,0>: Cost 2 vzipl LHS, <4,0,5,1>
    2085765121U, // <u,4,1,1>: Cost 2 ins <0,u,1,1>, lane 1
    1551426503U, // <u,4,1,2>: Cost 2 vext2 <1,2,u,4>, <1,2,u,4>
    1756364902U, // <u,4,1,3>: Cost 2 vuzpr <1,u,3,4>, LHS
    1860553936U, // <u,4,1,4>: Cost 2 vzipl LHS, <4,4,4,4>
    786812214U,  // <u,4,1,5>: Cost 1 vzipl LHS, RHS
    1994026294U, // <u,4,1,6>: Cost 2 vtrnl <u,0,1,2>, RHS
    2083168259U, // <u,4,1,7>: Cost 2 ins <0,4,1,u>, lane 3
    786812457U,  // <u,4,1,u>: Cost 1 vzipl LHS, RHS
    1170066926U, // <u,4,2,0>: Cost 2 vrev <4,u,0,2>
    2083241987U, // <u,4,2,1>: Cost 2 ins <0,4,2,u>, lane 3
    2085847041U, // <u,4,2,2>: Cost 2 ins <0,u,2,2>, lane 1
    1012113409U, // <u,4,2,3>: Cost 1 ins LHS, lane 1
    1994771664U, // <u,4,2,4>: Cost 2 vtrnl LHS, <4,4,4,4>
    1994771346U, // <u,4,2,5>: Cost 2 vtrnl LHS, <4,0,5,1>
    921029942U,  // <u,4,2,6>: Cost 1 vtrnl LHS, RHS
    2083241987U, // <u,4,2,7>: Cost 2 ins <0,4,2,u>, lane 3
    921029960U,  // <u,4,2,u>: Cost 1 vtrnl LHS, RHS
    2091876353U, // <u,4,3,0>: Cost 2 ins <1,u,3,0>, lane 1
    2954070192U, // <u,4,3,1>: Cost 3 vzipr LHS, <3,0,4,1>
    2091892737U, // <u,4,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    2091900929U, // <u,4,3,3>: Cost 2 ins <1,u,3,3>, lane 1
    1928105168U, // <u,4,3,4>: Cost 2 vzipr LHS, <4,4,4,4>
    1880327886U, // <u,4,3,5>: Cost 2 vzipr LHS, <2,3,4,5>
    1880326348U, // <u,4,3,6>: Cost 2 vzipr LHS, <0,2,4,6>
    2091933697U, // <u,4,3,7>: Cost 2 ins <1,u,3,7>, lane 1
    1880326350U, // <u,4,3,u>: Cost 2 vzipr LHS, <0,2,4,u>
    1505919078U, // <u,4,4,0>: Cost 2 vext1 <4,u,4,4>, LHS
    2107277315U, // <u,4,4,1>: Cost 2 ins <4,4,4,u>, lane 3
    2107277315U, // <u,4,4,2>: Cost 2 ins <4,4,4,u>, lane 3
    2086002689U, // <u,4,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    161926454U,  // <u,4,4,4>: Cost 1 vdup0 RHS
    1551428918U, // <u,4,4,5>: Cost 2 vext2 <1,2,u,4>, RHS
    1638329572U, // <u,4,4,6>: Cost 2 vext3 RHS, <4,4,6,6>
    2109923329U, // <u,4,4,7>: Cost 2 ins <4,u,4,7>, lane 1
    161926454U,  // <u,4,4,u>: Cost 1 vdup0 RHS
    1493983334U, // <u,4,5,0>: Cost 2 vext1 <2,u,4,5>, LHS
    2101379075U, // <u,4,5,1>: Cost 2 ins <3,4,5,u>, lane 3
    1493985379U, // <u,4,5,2>: Cost 2 vext1 <2,u,4,5>, <2,u,4,5>
    2101379075U, // <u,4,5,3>: Cost 2 ins <3,4,5,u>, lane 3
    1493986614U, // <u,4,5,4>: Cost 2 vext1 <2,u,4,5>, RHS
    789794102U,  // <u,4,5,5>: Cost 1 vzipl RHS, RHS
    537750838U,  // <u,4,5,6>: Cost 1 vext3 LHS, RHS
    1756368182U, // <u,4,5,7>: Cost 2 vuzpr <1,u,3,4>, RHS
    537750856U,  // <u,4,5,u>: Cost 1 vext3 LHS, RHS
    1482048178U, // <u,4,6,0>: Cost 2 vext1 <0,u,4,6>, <0,u,4,6>
    2107424771U, // <u,4,6,1>: Cost 2 ins <4,4,6,u>, lane 3
    2110029825U, // <u,4,6,2>: Cost 2 ins <4,u,6,2>, lane 1
    2107424771U, // <u,4,6,3>: Cost 2 ins <4,4,6,u>, lane 3
    1482050870U, // <u,4,6,4>: Cost 2 vext1 <0,u,4,6>, RHS
    1997753234U, // <u,4,6,5>: Cost 2 vtrnl RHS, <4,0,5,1>
    924011830U,  // <u,4,6,6>: Cost 1 vtrnl RHS, RHS
    1036328961U, // <u,4,6,7>: Cost 1 ins RHS, lane 1
    924011848U,  // <u,4,6,u>: Cost 1 vtrnl RHS, RHS
    2116059137U, // <u,4,7,0>: Cost 2 ins <5,u,7,0>, lane 1
    2113470467U, // <u,4,7,1>: Cost 2 ins <5,4,7,u>, lane 3
    2113470467U, // <u,4,7,2>: Cost 2 ins <5,4,7,u>, lane 3
    2116083713U, // <u,4,7,3>: Cost 2 ins <5,u,7,3>, lane 1
    1906904272U, // <u,4,7,4>: Cost 2 vzipr RHS, <4,4,4,4>
    1906902734U, // <u,4,7,5>: Cost 2 vzipr RHS, <2,3,4,5>
    96808489U,   // <u,4,7,6>: Cost 1 vrev RHS
    2116116481U, // <u,4,7,7>: Cost 2 ins <5,u,7,7>, lane 1
    96955963U,   // <u,4,7,u>: Cost 1 vrev RHS
    1482064564U, // <u,4,u,0>: Cost 2 vext1 <0,u,4,u>, <0,u,4,u>
    1551431470U, // <u,4,u,1>: Cost 2 vext2 <1,2,u,4>, LHS
    1494009958U, // <u,4,u,2>: Cost 2 vext1 <2,u,4,u>, <2,u,4,u>
    1012113409U, // <u,4,u,3>: Cost 1 ins LHS, lane 1
    161926454U,  // <u,4,u,4>: Cost 1 vdup0 RHS
    791457078U,  // <u,4,u,5>: Cost 1 vzipl LHS, RHS
    537751081U,  // <u,4,u,6>: Cost 1 vext3 LHS, RHS
    1036328961U, // <u,4,u,7>: Cost 1 ins RHS, lane 1
    537751099U,  // <u,4,u,u>: Cost 1 vext3 LHS, RHS
    2085683201U, // <u,5,0,0>: Cost 2 ins <0,u,0,0>, lane 1
    1034493957U, // <u,5,0,1>: Cost 1 ins RHS, lane 5
    1727914086U, // <u,5,0,2>: Cost 2 vuzpl <u,3,5,7>, LHS
    2085707777U, // <u,5,0,3>: Cost 2 ins <0,u,0,3>, lane 1
    1546273106U, // <u,5,0,4>: Cost 2 vext2 <0,4,1,5>, <0,4,1,5>
    1678778497U, // <u,5,0,5>: Cost 2 vuzpl <0,1,5,3>, <0,1,5,3>
    2108219394U, // <u,5,0,6>: Cost 2 ins <4,5,u,6>, lane 2
    1034485762U, // <u,5,0,7>: Cost 1 ins RHS, lane 2
    1034493957U, // <u,5,0,u>: Cost 1 ins RHS, lane 5
    1505968230U, // <u,5,1,0>: Cost 2 vext1 <4,u,5,1>, LHS
    1860554448U, // <u,5,1,1>: Cost 2 vzipl LHS, <5,1,7,3>
    2103689217U, // <u,5,1,2>: Cost 2 ins <3,u,1,2>, lane 1
    1750253670U, // <u,5,1,3>: Cost 2 vuzpr <0,u,1,5>, LHS
    1505971738U, // <u,5,1,4>: Cost 2 vext1 <4,u,5,1>, <4,u,5,1>
    1860554756U, // <u,5,1,5>: Cost 2 vzipl LHS, <5,5,5,5>
    1860554850U, // <u,5,1,6>: Cost 2 vzipl LHS, <5,6,7,0>
    1034485762U, // <u,5,1,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <u,5,1,u>: Cost 1 ins RHS, lane 2
    2085830657U, // <u,5,2,0>: Cost 2 ins <0,u,2,0>, lane 1
    1994772608U, // <u,5,2,1>: Cost 2 vtrnl LHS, <5,7,1,3>
    2085847041U, // <u,5,2,2>: Cost 2 ins <0,u,2,2>, lane 1
    1012113409U, // <u,5,2,3>: Cost 1 ins LHS, lane 1
    2085863425U, // <u,5,2,4>: Cost 2 ins <0,u,2,4>, lane 1
    1994772484U, // <u,5,2,5>: Cost 2 vtrnl LHS, <5,5,5,5>
    2085879809U, // <u,5,2,6>: Cost 2 ins <0,u,2,6>, lane 1
    1034485762U, // <u,5,2,7>: Cost 1 ins RHS, lane 2
    1012113409U, // <u,5,2,u>: Cost 1 ins LHS, lane 1
    2091876353U, // <u,5,3,0>: Cost 2 ins <1,u,3,0>, lane 1
    1176121553U, // <u,5,3,1>: Cost 2 vrev <5,u,1,3>
    2091892737U, // <u,5,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    2091900929U, // <u,5,3,3>: Cost 2 ins <1,u,3,3>, lane 1
    2091909121U, // <u,5,3,4>: Cost 2 ins <1,u,3,4>, lane 1
    1928105178U, // <u,5,3,5>: Cost 2 vzipr LHS, <4,4,5,5>
    1880328706U, // <u,5,3,6>: Cost 2 vzipr LHS, <3,4,5,6>
    945007926U,  // <u,5,3,7>: Cost 1 vtrnr LHS, RHS
    945007927U,  // <u,5,3,u>: Cost 1 vtrnr LHS, RHS
    2108170242U, // <u,5,4,0>: Cost 2 ins <4,5,u,0>, lane 2
    2108178434U, // <u,5,4,1>: Cost 2 ins <4,5,u,1>, lane 2
    2108186626U, // <u,5,4,2>: Cost 2 ins <4,5,u,2>, lane 2
    2086002689U, // <u,5,4,3>: Cost 2 ins <0,u,4,3>, lane 1
    1845022662U, // <u,5,4,4>: Cost 2 vzipl <5,4,7,6>, <5,4,7,6>
    1034493957U, // <u,5,4,5>: Cost 1 ins RHS, lane 5
    1727917366U, // <u,5,4,6>: Cost 2 vuzpl <u,3,5,7>, RHS
    1034485762U, // <u,5,4,7>: Cost 1 ins RHS, lane 2
    1034493957U, // <u,5,4,u>: Cost 1 ins RHS, lane 5
    1506000998U, // <u,5,5,0>: Cost 2 vext1 <4,u,5,5>, LHS
    1863536336U, // <u,5,5,1>: Cost 2 vzipl RHS, <5,1,7,3>
    2108186626U, // <u,5,5,2>: Cost 2 ins <4,5,u,2>, lane 2
    2086076417U, // <u,5,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    1506004510U, // <u,5,5,4>: Cost 2 vext1 <4,u,5,5>, <4,u,5,5>
    229035318U,  // <u,5,5,5>: Cost 1 vdup1 RHS
    1863536738U, // <u,5,5,6>: Cost 2 vzipl RHS, <5,6,7,0>
    1034485762U, // <u,5,5,7>: Cost 1 ins RHS, lane 2
    1034485762U, // <u,5,5,u>: Cost 1 ins RHS, lane 2
    1034346499U, // <u,5,6,0>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,5,6,1>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,5,6,2>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,5,6,3>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,5,6,4>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,5,6,5>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,5,6,6>: Cost 1 ins RHS, lane 3
    27705344U,   // <u,5,6,7>: Cost 0 copy RHS
    27705344U,   // <u,5,6,u>: Cost 0 copy RHS
    1488101478U, // <u,5,7,0>: Cost 2 vext1 <1,u,5,7>, LHS
    1488102805U, // <u,5,7,1>: Cost 2 vext1 <1,u,5,7>, <1,u,5,7>
    2114134019U, // <u,5,7,2>: Cost 2 ins <5,5,7,u>, lane 3
    2133999620U, // <u,5,7,3>: Cost 2 ins <u,u,7,3>, lane 4
    1488104758U, // <u,5,7,4>: Cost 2 vext1 <1,u,5,7>, RHS
    1638330536U, // <u,5,7,5>: Cost 2 vext3 RHS, <5,7,5,7>
    1906903554U, // <u,5,7,6>: Cost 2 vzipr RHS, <3,4,5,6>
    969223478U,  // <u,5,7,7>: Cost 1 vtrnr RHS, RHS
    969223479U,  // <u,5,7,u>: Cost 1 vtrnr RHS, RHS
    1034346499U, // <u,5,u,0>: Cost 1 ins RHS, lane 3
    1034493957U, // <u,5,u,1>: Cost 1 ins RHS, lane 5
    1034346499U, // <u,5,u,2>: Cost 1 ins RHS, lane 3
    1012113409U, // <u,5,u,3>: Cost 1 ins LHS, lane 1
    1034346499U, // <u,5,u,4>: Cost 1 ins RHS, lane 3
    1034493957U, // <u,5,u,5>: Cost 1 ins RHS, lane 5
    1034346499U, // <u,5,u,6>: Cost 1 ins RHS, lane 3
    27705344U,   // <u,5,u,7>: Cost 0 copy RHS
    27705344U,   // <u,5,u,u>: Cost 0 copy RHS
    1729314816U, // <u,6,0,0>: Cost 2 vuzpl RHS, <0,0,0,0>
    1545470054U, // <u,6,0,1>: Cost 2 vext2 <0,2,u,6>, LHS
    655573094U,  // <u,6,0,2>: Cost 1 vuzpl RHS, LHS
    2108309507U, // <u,6,0,3>: Cost 2 ins <4,6,0,u>, lane 3
    1546797458U, // <u,6,0,4>: Cost 2 vext2 <0,4,u,6>, <0,4,u,6>
    2108309507U, // <u,6,0,5>: Cost 2 ins <4,6,0,u>, lane 3
    2108882946U, // <u,6,0,6>: Cost 2 ins <4,6,u,6>, lane 2
    1886940470U, // <u,6,0,7>: Cost 2 vzipr <1,2,u,0>, RHS
    655573148U,  // <u,6,0,u>: Cost 1 vuzpl RHS, LHS
    1182004127U, // <u,6,1,0>: Cost 2 vrev <6,u,0,1>
    1729315636U, // <u,6,1,1>: Cost 2 vuzpl RHS, <1,1,1,1>
    1860555258U, // <u,6,1,2>: Cost 2 vzipl LHS, <6,2,7,3>
    1750335590U, // <u,6,1,3>: Cost 2 vuzpr <0,u,2,6>, LHS
    2114838530U, // <u,6,1,4>: Cost 2 ins <5,6,u,4>, lane 2
    1729315840U, // <u,6,1,5>: Cost 2 vuzpl RHS, <1,3,5,7>
    1860555576U, // <u,6,1,6>: Cost 2 vzipl LHS, <6,6,6,6>
    1884958006U, // <u,6,1,7>: Cost 2 vzipr <0,u,u,1>, RHS
    1750335595U, // <u,6,1,u>: Cost 2 vuzpr <0,u,2,6>, LHS
    1506050150U, // <u,6,2,0>: Cost 2 vext1 <4,u,6,2>, LHS
    2085838849U, // <u,6,2,1>: Cost 2 ins <0,u,2,1>, lane 1
    1729316456U, // <u,6,2,2>: Cost 2 vuzpl RHS, <2,2,2,2>
    1012113409U, // <u,6,2,3>: Cost 1 ins LHS, lane 1
    1506053668U, // <u,6,2,4>: Cost 2 vext1 <4,u,6,2>, <4,u,6,2>
    2085871617U, // <u,6,2,5>: Cost 2 ins <0,u,2,5>, lane 1
    1994773304U, // <u,6,2,6>: Cost 2 vtrnl LHS, <6,6,6,6>
    1880984886U, // <u,6,2,7>: Cost 2 vzipr <0,2,u,2>, RHS
    1012113409U, // <u,6,2,u>: Cost 1 ins LHS, lane 1
    2066526306U, // <u,6,3,0>: Cost 2 vtrnr LHS, <5,6,7,0>
    1729317014U, // <u,6,3,1>: Cost 2 vuzpl RHS, <3,0,1,2>
    1928104860U, // <u,6,3,2>: Cost 2 vzipr LHS, <4,0,6,2>
    1729317276U, // <u,6,3,3>: Cost 2 vuzpl RHS, <3,3,3,3>
    1564715549U, // <u,6,3,4>: Cost 2 vext2 <3,4,u,6>, <3,4,u,6>
    1729317378U, // <u,6,3,5>: Cost 2 vuzpl RHS, <3,4,5,6>
    1928105188U, // <u,6,3,6>: Cost 2 vzipr LHS, <4,4,6,6>
    806587702U,  // <u,6,3,7>: Cost 1 vzipr LHS, RHS
    806587703U,  // <u,6,3,u>: Cost 1 vzipr LHS, RHS
    1729318220U, // <u,6,4,0>: Cost 2 vuzpl RHS, <4,6,0,2>
    2108604419U, // <u,6,4,1>: Cost 2 ins <4,6,4,u>, lane 3
    2108850178U, // <u,6,4,2>: Cost 2 ins <4,6,u,2>, lane 2
    2108604419U, // <u,6,4,3>: Cost 2 ins <4,6,4,u>, lane 3
    1729318096U, // <u,6,4,4>: Cost 2 vuzpl RHS, <4,4,4,4>
    1545473334U, // <u,6,4,5>: Cost 2 vext2 <0,2,u,6>, RHS
    655576374U,  // <u,6,4,6>: Cost 1 vuzpl RHS, RHS
    1886973238U, // <u,6,4,7>: Cost 2 vzipr <1,2,u,4>, RHS
    655576392U,  // <u,6,4,u>: Cost 1 vuzpl RHS, RHS
    2114805762U, // <u,6,5,0>: Cost 2 ins <5,6,u,0>, lane 2
    1729319040U, // <u,6,5,1>: Cost 2 vuzpl RHS, <5,7,1,3>
    1863537146U, // <u,6,5,2>: Cost 2 vzipl RHS, <6,2,7,3>
    2086076417U, // <u,6,5,3>: Cost 2 ins <0,u,5,3>, lane 1
    1576660943U, // <u,6,5,4>: Cost 2 vext2 <5,4,u,6>, <5,4,u,6>
    1729318916U, // <u,6,5,5>: Cost 2 vuzpl RHS, <5,5,5,5>
    1863537464U, // <u,6,5,6>: Cost 2 vzipl RHS, <6,6,6,6>
    1750338870U, // <u,6,5,7>: Cost 2 vuzpr <0,u,2,6>, RHS
    1750338871U, // <u,6,5,u>: Cost 2 vuzpr <0,u,2,6>, RHS
    1506082918U, // <u,6,6,0>: Cost 2 vext1 <4,u,6,6>, LHS
    2110021633U, // <u,6,6,1>: Cost 2 ins <4,u,6,1>, lane 1
    2110029825U, // <u,6,6,2>: Cost 2 ins <4,u,6,2>, lane 1
    2086150145U, // <u,6,6,3>: Cost 2 ins <0,u,6,3>, lane 1
    1506086440U, // <u,6,6,4>: Cost 2 vext1 <4,u,6,6>, <4,u,6,6>
    2110054401U, // <u,6,6,5>: Cost 2 ins <4,u,6,5>, lane 1
    296144182U,  // <u,6,6,6>: Cost 1 vdup2 RHS
    1036328961U, // <u,6,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <u,6,6,u>: Cost 1 ins RHS, lane 1
    432349286U,  // <u,6,7,0>: Cost 1 vext1 RHS, LHS
    1506091766U, // <u,6,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
    1906903964U, // <u,6,7,2>: Cost 2 vzipr RHS, <4,0,6,2>
    1506093206U, // <u,6,7,3>: Cost 2 vext1 RHS, <3,0,1,2>
    432352809U,  // <u,6,7,4>: Cost 1 vext1 RHS, RHS
    1506094800U, // <u,6,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
    1906904292U, // <u,6,7,6>: Cost 2 vzipr RHS, <4,4,6,6>
    833162550U,  // <u,6,7,7>: Cost 1 vzipr RHS, RHS
    833162551U,  // <u,6,7,u>: Cost 1 vzipr RHS, RHS
    432357478U,  // <u,6,u,0>: Cost 1 vext1 RHS, LHS
    1545475886U, // <u,6,u,1>: Cost 2 vext2 <0,2,u,6>, LHS
    655578926U,  // <u,6,u,2>: Cost 1 vuzpl RHS, LHS
    1012113409U, // <u,6,u,3>: Cost 1 ins LHS, lane 1
    432361002U,  // <u,6,u,4>: Cost 1 vext1 RHS, RHS
    1545476250U, // <u,6,u,5>: Cost 2 vext2 <0,2,u,6>, RHS
    655579290U,  // <u,6,u,6>: Cost 1 vuzpl RHS, RHS
    806628662U,  // <u,6,u,7>: Cost 1 vzipr LHS, RHS
    806628663U,  // <u,6,u,u>: Cost 1 vzipr LHS, RHS
    1571356672U, // <u,7,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
    497614950U,  // <u,7,0,1>: Cost 1 vext2 RHS, LHS
    1571356836U, // <u,7,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
    2115493890U, // <u,7,0,3>: Cost 2 ins <5,7,u,3>, lane 2
    1571357010U, // <u,7,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
    1512083716U, // <u,7,0,5>: Cost 2 vext1 <5,u,7,0>, <5,u,7,0>
    2120916995U, // <u,7,0,6>: Cost 2 ins <6,7,0,u>, lane 3
    2115526658U, // <u,7,0,7>: Cost 2 ins <5,7,u,7>, lane 2
    497615517U,  // <u,7,0,u>: Cost 1 vext2 RHS, LHS
    1571357430U, // <u,7,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
    1571357492U, // <u,7,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
    1571357590U, // <u,7,1,2>: Cost 2 vext2 RHS, <1,2,3,0>
    700784742U,  // <u,7,1,3>: Cost 1 vuzpr RHS, LHS
    1860556134U, // <u,7,1,4>: Cost 2 vzipl LHS, <7,4,5,6>
    1553441981U, // <u,7,1,5>: Cost 2 vext2 <1,5,u,7>, <1,5,u,7>
    2115018755U, // <u,7,1,6>: Cost 2 ins <5,7,1,u>, lane 3
    1860556396U, // <u,7,1,7>: Cost 2 vzipl LHS, <7,7,7,7>
    700784747U,  // <u,7,1,u>: Cost 1 vuzpr RHS, LHS
    1774527382U, // <u,7,2,0>: Cost 2 vuzpr RHS, <1,2,3,0>
    1188058754U, // <u,7,2,1>: Cost 2 vrev <7,u,1,2>
    1571358312U, // <u,7,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
    1012113409U, // <u,7,2,3>: Cost 1 ins LHS, lane 1
    1774527386U, // <u,7,2,4>: Cost 2 vuzpr RHS, <1,2,3,4>
    1994773862U, // <u,7,2,5>: Cost 2 vtrnl LHS, <7,4,5,6>
    1560078311U, // <u,7,2,6>: Cost 2 vext2 <2,6,u,7>, <2,6,u,7>
    1994774124U, // <u,7,2,7>: Cost 2 vtrnl LHS, <7,7,7,7>
    1012113409U, // <u,7,2,u>: Cost 1 ins LHS, lane 1
    1571358870U, // <u,7,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
    1774528166U, // <u,7,3,1>: Cost 2 vuzpr RHS, <2,3,0,1>
    2091892737U, // <u,7,3,2>: Cost 2 ins <1,u,3,2>, lane 1
    1571359132U, // <u,7,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
    1571359234U, // <u,7,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
    1774528206U, // <u,7,3,5>: Cost 2 vuzpr RHS, <2,3,4,5>
    1518080992U, // <u,7,3,6>: Cost 2 vext1 <6,u,7,3>, <6,u,7,3>
    1774527488U, // <u,7,3,7>: Cost 2 vuzpr RHS, <1,3,5,7>
    1571359518U, // <u,7,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
    1571359634U, // <u,7,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
    2121449474U, // <u,7,4,1>: Cost 2 ins <6,7,u,1>, lane 2
    2121211907U, // <u,7,4,2>: Cost 2 ins <6,7,4,u>, lane 3
    2115493890U, // <u,7,4,3>: Cost 2 ins <5,7,u,3>, lane 2
    1571359952U, // <u,7,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
    497618248U,  // <u,7,4,5>: Cost 1 vext2 RHS, RHS
    1571360076U, // <u,7,4,6>: Cost 2 vext2 RHS, <4,6,0,2>
    2115526658U, // <u,7,4,7>: Cost 2 ins <5,7,u,7>, lane 2
    497618473U,  // <u,7,4,u>: Cost 1 vext2 RHS, RHS
    1863537658U, // <u,7,5,0>: Cost 2 vzipl RHS, <7,0,1,2>
    1571360464U, // <u,7,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
    2115313667U, // <u,7,5,2>: Cost 2 ins <5,7,5,u>, lane 3
    2115493890U, // <u,7,5,3>: Cost 2 ins <5,7,u,3>, lane 2
    1571360710U, // <u,7,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
    1571360772U, // <u,7,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
    1571360866U, // <u,7,5,6>: Cost 2 vext2 RHS, <5,6,7,0>
    700788022U,  // <u,7,5,7>: Cost 1 vuzpr RHS, RHS
    700788023U,  // <u,7,5,u>: Cost 1 vuzpr RHS, RHS
    1774530658U, // <u,7,6,0>: Cost 2 vuzpr RHS, <5,6,7,0>
    1997755386U, // <u,7,6,1>: Cost 2 vtrnl RHS, <7,0,1,2>
    1571361274U, // <u,7,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
    2115493890U, // <u,7,6,3>: Cost 2 ins <5,7,u,3>, lane 2
    1774530662U, // <u,7,6,4>: Cost 2 vuzpr RHS, <5,6,7,4>
    1188386474U, // <u,7,6,5>: Cost 2 vrev <7,u,5,6>
    1571361592U, // <u,7,6,6>: Cost 2 vext2 RHS, <6,6,6,6>
    1036328961U, // <u,7,6,7>: Cost 1 ins RHS, lane 1
    1036328961U, // <u,7,6,u>: Cost 1 ins RHS, lane 1
    1571361786U, // <u,7,7,0>: Cost 2 vext2 RHS, <7,0,1,2>
    1774531406U, // <u,7,7,1>: Cost 2 vuzpr RHS, <6,7,0,1>
    2127405059U, // <u,7,7,2>: Cost 2 ins <7,7,7,u>, lane 3
    1906904784U, // <u,7,7,3>: Cost 2 vzipr RHS, <5,1,7,3>
    1571362150U, // <u,7,7,4>: Cost 2 vext2 RHS, <7,4,5,6>
    1774531446U, // <u,7,7,5>: Cost 2 vuzpr RHS, <6,7,4,5>
    1906905030U, // <u,7,7,6>: Cost 2 vzipr RHS, <5,4,7,6>
    363253046U,  // <u,7,7,7>: Cost 1 vdup3 RHS
    363253046U,  // <u,7,7,u>: Cost 1 vdup3 RHS
    1571362515U, // <u,7,u,0>: Cost 2 vext2 RHS, <u,0,1,2>
    497620782U,  // <u,7,u,1>: Cost 1 vext2 RHS, LHS
    1571362693U, // <u,7,u,2>: Cost 2 vext2 RHS, <u,2,3,0>
    700785309U,  // <u,7,u,3>: Cost 1 vuzpr RHS, LHS
    1571362879U, // <u,7,u,4>: Cost 2 vext2 RHS, <u,4,5,6>
    497621146U,  // <u,7,u,5>: Cost 1 vext2 RHS, RHS
    1571363024U, // <u,7,u,6>: Cost 2 vext2 RHS, <u,6,3,7>
    700788265U,  // <u,7,u,7>: Cost 1 vuzpr RHS, RHS
    497621349U,  // <u,7,u,u>: Cost 1 vext2 RHS, LHS
    135053414U,  // <u,u,0,0>: Cost 1 vdup0 LHS
    471081121U,  // <u,u,0,1>: Cost 1 vext2 LHS, LHS
    653033574U,  // <u,u,0,2>: Cost 1 vuzpl LHS, LHS
    1007910914U, // <u,u,0,3>: Cost 1 ins LHS, lane 2
    1544823122U, // <u,u,0,4>: Cost 2 vext2 LHS, <0,4,1,5>
    1512157453U, // <u,u,0,5>: Cost 2 vext1 <5,u,u,0>, <5,u,u,0>
    1995282586U, // <u,u,0,6>: Cost 2 vtrnl <u,2,0,2>, RHS
    1034485762U, // <u,u,0,7>: Cost 1 ins RHS, lane 2
    471081629U,  // <u,u,0,u>: Cost 1 vext2 LHS, LHS
    1544823542U, // <u,u,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
    786814766U,  // <u,u,1,1>: Cost 1 vzipl LHS, LHS
    537753390U,  // <u,u,1,2>: Cost 1 vext3 LHS, LHS
    676610150U,  // <u,u,1,3>: Cost 1 vuzpr LHS, LHS
    1482304822U, // <u,u,1,4>: Cost 2 vext1 <0,u,u,1>, RHS
    786815130U,  // <u,u,1,5>: Cost 1 vzipl LHS, RHS
    1518138343U, // <u,u,1,6>: Cost 2 vext1 <6,u,u,1>, <6,u,u,1>
    1034485762U, // <u,u,1,7>: Cost 1 ins RHS, lane 2
    537753444U,  // <u,u,1,u>: Cost 1 vext3 LHS, LHS
    1007509507U, // <u,u,2,0>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,u,2,1>: Cost 1 ins LHS, lane 3
    921032494U,  // <u,u,2,2>: Cost 1 vtrnl LHS, LHS
    835584U,     // <u,u,2,3>: Cost 0 copy LHS
    1007509507U, // <u,u,2,4>: Cost 1 ins LHS, lane 3
    1007509507U, // <u,u,2,5>: Cost 1 ins LHS, lane 3
    921032858U,  // <u,u,2,6>: Cost 1 vtrnl LHS, RHS
    1007509507U, // <u,u,2,7>: Cost 1 ins LHS, lane 3
    835584U,     // <u,u,2,u>: Cost 0 copy LHS
    408576723U,  // <u,u,3,0>: Cost 1 vext1 LHS, LHS
    1880327918U, // <u,u,3,1>: Cost 2 vzipr LHS, <2,3,u,1>
    120371557U,  // <u,u,3,2>: Cost 1 vrev LHS
    806584476U,  // <u,u,3,3>: Cost 1 vzipr LHS, LHS
    408579382U,  // <u,u,3,4>: Cost 1 vext1 LHS, RHS
    1880327922U, // <u,u,3,5>: Cost 2 vzipr LHS, <2,3,u,5>
    1880326384U, // <u,u,3,6>: Cost 2 vzipr LHS, <0,2,u,6>
    806587720U,  // <u,u,3,7>: Cost 1 vzipr LHS, RHS
    806584481U,  // <u,u,3,u>: Cost 1 vzipr LHS, LHS
    1488298086U, // <u,u,4,0>: Cost 2 vext1 <1,u,u,4>, LHS
    1488299437U, // <u,u,4,1>: Cost 2 vext1 <1,u,u,4>, <1,u,u,4>
    1659271204U, // <u,u,4,2>: Cost 2 vext3 LHS, <u,4,2,6>
    1007910914U, // <u,u,4,3>: Cost 1 ins LHS, lane 2
    161926454U,  // <u,u,4,4>: Cost 1 vdup0 RHS
    471084342U,  // <u,u,4,5>: Cost 1 vext2 LHS, RHS
    653036854U,  // <u,u,4,6>: Cost 1 vuzpl LHS, RHS
    1034485762U, // <u,u,4,7>: Cost 1 ins RHS, lane 2
    471084585U,  // <u,u,4,u>: Cost 1 vext2 LHS, RHS
    1482334933U, // <u,u,5,0>: Cost 2 vext1 <0,u,u,5>, <0,u,u,5>
    789796654U,  // <u,u,5,1>: Cost 1 vzipl RHS, LHS
    1494280327U, // <u,u,5,2>: Cost 2 vext1 <2,u,u,5>, <2,u,u,5>
    1007910914U, // <u,u,5,3>: Cost 1 ins LHS, lane 2
    1482337590U, // <u,u,5,4>: Cost 2 vext1 <0,u,u,5>, RHS
    789797018U,  // <u,u,5,5>: Cost 1 vzipl RHS, RHS
    537753754U,  // <u,u,5,6>: Cost 1 vext3 LHS, RHS
    676613430U,  // <u,u,5,7>: Cost 1 vuzpr LHS, RHS
    537753772U,  // <u,u,5,u>: Cost 1 vext3 LHS, RHS
    1034346499U, // <u,u,6,0>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,u,6,1>: Cost 1 ins RHS, lane 3
    924014382U,  // <u,u,6,2>: Cost 1 vtrnl RHS, LHS
    1007910914U, // <u,u,6,3>: Cost 1 ins LHS, lane 2
    1034346499U, // <u,u,6,4>: Cost 1 ins RHS, lane 3
    1034346499U, // <u,u,6,5>: Cost 1 ins RHS, lane 3
    924014746U,  // <u,u,6,6>: Cost 1 vtrnl RHS, RHS
    27705344U,   // <u,u,6,7>: Cost 0 copy RHS
    27705344U,   // <u,u,6,u>: Cost 0 copy RHS
    432496742U,  // <u,u,7,0>: Cost 1 vext1 RHS, LHS
    1488324016U, // <u,u,7,1>: Cost 2 vext1 <1,u,u,7>, <1,u,u,7>
    1494296713U, // <u,u,7,2>: Cost 2 vext1 <2,u,u,7>, <2,u,u,7>
    833159324U,  // <u,u,7,3>: Cost 1 vzipr RHS, LHS
    432500283U,  // <u,u,7,4>: Cost 1 vext1 RHS, RHS
    1906901393U, // <u,u,7,5>: Cost 2 vzipr RHS, <0,4,u,5>
    120699277U,  // <u,u,7,6>: Cost 1 vrev RHS
    833162568U,  // <u,u,7,7>: Cost 1 vzipr RHS, RHS
    833159329U,  // <u,u,7,u>: Cost 1 vzipr RHS, LHS
    408617688U,  // <u,u,u,0>: Cost 1 vext1 LHS, LHS
    471086894U,  // <u,u,u,1>: Cost 1 vext2 LHS, LHS
    537753957U,  // <u,u,u,2>: Cost 1 vext3 LHS, LHS
    835584U,     // <u,u,u,3>: Cost 0 copy LHS
    408620342U,  // <u,u,u,4>: Cost 1 vext1 LHS, RHS
    471087258U,  // <u,u,u,5>: Cost 1 vext2 LHS, RHS
    537753997U,  // <u,u,u,6>: Cost 1 vext3 LHS, RHS
    27705344U,   // <u,u,u,7>: Cost 0 copy RHS
    835584U,     // <u,u,u,u>: Cost 0 copy LHS
    0};

inline unsigned getPerfectShuffleCost(llvm::ArrayRef<int> M) {
  assert(M.size() == 4 && "Expected a 4 entry perfect shuffle");

  // Special case zero-cost nop copies, from either LHS or RHS.
  if (llvm::all_of(llvm::enumerate(M), [](const auto &E) {
        return E.value() < 0 || E.value() == (int)E.index();
      }))
    return 0;
  if (llvm::all_of(llvm::enumerate(M), [](const auto &E) {
        return E.value() < 0 || E.value() == (int)E.index() + 4;
      }))
    return 0;

  // Get the four mask elementd from the 2 inputs. Perfect shuffles encode undef
  // elements with value 8.
  unsigned PFIndexes[4];
  for (unsigned i = 0; i != 4; ++i) {
    assert(M[i] < 8 && "Expected a maximum entry of 8 for shuffle mask");
    if (M[i] < 0)
      PFIndexes[i] = 8;
    else
      PFIndexes[i] = M[i];
  }

  // Compute the index in the perfect shuffle table.
  unsigned PFTableIndex = PFIndexes[0] * 9 * 9 * 9 + PFIndexes[1] * 9 * 9 +
                          PFIndexes[2] * 9 + PFIndexes[3];
  unsigned PFEntry = PerfectShuffleTable[PFTableIndex];
  // And extract the cost from the upper bits. The cost is encoded as Cost-1.
  return (PFEntry >> 30) + 1;
}

/// Return true for zip1 or zip2 masks of the form:
///  <0,  8, 1,  9, 2, 10, 3, 11> or
///  <4, 12, 5, 13, 6, 14, 7, 15>
inline bool isZIPMask(ArrayRef<int> M, unsigned NumElts,
                      unsigned &WhichResultOut) {
  if (NumElts % 2 != 0)
    return false;
  // Check the first non-undef element for which half to use.
  unsigned WhichResult = 2;
  for (unsigned i = 0; i != NumElts / 2; i++) {
    if (M[i * 2] >= 0) {
      WhichResult = ((unsigned)M[i * 2] == i ? 0 : 1);
      break;
    } else if (M[i * 2 + 1] >= 0) {
      WhichResult = ((unsigned)M[i * 2 + 1] == NumElts + i ? 0 : 1);
      break;
    }
  }
  if (WhichResult == 2)
    return false;

  // Check all elements match.
  unsigned Idx = WhichResult * NumElts / 2;
  for (unsigned i = 0; i != NumElts; i += 2) {
    if ((M[i] >= 0 && (unsigned)M[i] != Idx) ||
        (M[i + 1] >= 0 && (unsigned)M[i + 1] != Idx + NumElts))
      return false;
    Idx += 1;
  }
  WhichResultOut = WhichResult;
  return true;
}

/// Return true for uzp1 or uzp2 masks of the form:
///  <0, 2, 4, 6, 8, 10, 12, 14> or
///  <1, 3, 5, 7, 9, 11, 13, 15>
inline bool isUZPMask(ArrayRef<int> M, unsigned NumElts,
                      unsigned &WhichResultOut) {
  // Check the first non-undef element for which half to use.
  unsigned WhichResult = 2;
  for (unsigned i = 0; i != NumElts; i++) {
    if (M[i] >= 0) {
      WhichResult = ((unsigned)M[i] == i * 2 ? 0 : 1);
      break;
    }
  }
  if (WhichResult == 2)
    return false;

  // Check all elements match.
  for (unsigned i = 0; i != NumElts; ++i) {
    if (M[i] < 0)
      continue; // ignore UNDEF indices
    if ((unsigned)M[i] != 2 * i + WhichResult)
      return false;
  }
  WhichResultOut = WhichResult;
  return true;
}

/// Return true for trn1 or trn2 masks of the form:
///  <0, 8, 2, 10, 4, 12, 6, 14> or
///  <1, 9, 3, 11, 5, 13, 7, 15>
inline bool isTRNMask(ArrayRef<int> M, unsigned NumElts,
                      unsigned &WhichResult) {
  if (NumElts % 2 != 0)
    return false;
  WhichResult = (M[0] == 0 ? 0 : 1);
  for (unsigned i = 0; i < NumElts; i += 2) {
    if ((M[i] >= 0 && (unsigned)M[i] != i + WhichResult) ||
        (M[i + 1] >= 0 && (unsigned)M[i + 1] != i + NumElts + WhichResult))
      return false;
  }
  return true;
}

/// isREVMask - Check if a vector shuffle corresponds to a REV
/// instruction with the specified blocksize.  (The order of the elements
/// within each block of the vector is reversed.)
inline bool isREVMask(ArrayRef<int> M, unsigned EltSize, unsigned NumElts,
                      unsigned BlockSize) {
  assert((BlockSize == 16 || BlockSize == 32 || BlockSize == 64 ||
          BlockSize == 128) &&
         "Only possible block sizes for REV are: 16, 32, 64, 128");

  unsigned BlockElts = M[0] + 1;
  // If the first shuffle index is UNDEF, be optimistic.
  if (M[0] < 0)
    BlockElts = BlockSize / EltSize;

  if (BlockSize <= EltSize || BlockSize != BlockElts * EltSize)
    return false;

  for (unsigned i = 0; i < NumElts; ++i) {
    if (M[i] < 0)
      continue; // ignore UNDEF indices
    if ((unsigned)M[i] != (i - i % BlockElts) + (BlockElts - 1 - i % BlockElts))
      return false;
  }

  return true;
}

} // namespace llvm

#endif
