; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfhmin,+zvfhmin,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfhmin,+zvfhmin,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN

declare <vscale x 1 x half> @llvm.vp.nearbyint.nxv1f16(<vscale x 1 x half>, <vscale x 1 x i1>, i32)

define <vscale x 1 x half> @vp_nearbyint_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI0_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI0_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v9, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x half> @llvm.vp.nearbyint.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x half> %v
}

define <vscale x 1 x half> @vp_nearbyint_nxv1f16_unmasked(<vscale x 1 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv1f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI1_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI1_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv1f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v9
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x half> @llvm.vp.nearbyint.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 1 x half> %v
}

declare <vscale x 2 x half> @llvm.vp.nearbyint.nxv2f16(<vscale x 2 x half>, <vscale x 2 x i1>, i32)

define <vscale x 2 x half> @vp_nearbyint_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI2_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI2_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v9, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.vp.nearbyint.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x half> %v
}

define <vscale x 2 x half> @vp_nearbyint_nxv2f16_unmasked(<vscale x 2 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv2f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI3_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI3_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv2f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v9
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.vp.nearbyint.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 2 x half> %v
}

declare <vscale x 4 x half> @llvm.vp.nearbyint.nxv4f16(<vscale x 4 x half>, <vscale x 4 x i1>, i32)

define <vscale x 4 x half> @vp_nearbyint_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI4_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI4_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vmv1r.v v9, v0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v12, v10, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v9, v12, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vmv1r.v v0, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v12, v10, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v10, v12, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 4 x half> @llvm.vp.nearbyint.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x half> %v
}

define <vscale x 4 x half> @vp_nearbyint_nxv4f16_unmasked(<vscale x 4 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv4f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI5_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI5_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv4f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v10
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v10, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v10, v8, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 4 x half> @llvm.vp.nearbyint.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 4 x half> %v
}

declare <vscale x 8 x half> @llvm.vp.nearbyint.nxv8f16(<vscale x 8 x half>, <vscale x 8 x i1>, i32)

define <vscale x 8 x half> @vp_nearbyint_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI6_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI6_0)(a1)
; ZVFH-NEXT:    vmv1r.v v10, v0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vfabs.v v12, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; ZVFH-NEXT:    vmflt.vf v10, v12, fa5, v0.t
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vmv1r.v v10, v0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v16, v12, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v10, v16, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vmv1r.v v0, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v16, v12, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v12, v16, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x half> @llvm.vp.nearbyint.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x half> %v
}

define <vscale x 8 x half> @vp_nearbyint_nxv8f16_unmasked(<vscale x 8 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv8f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI7_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI7_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vfabs.v v10, v8
; ZVFH-NEXT:    vmflt.vf v0, v10, fa5
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv8f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v12
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v12, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v12, v8, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x half> @llvm.vp.nearbyint.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 8 x half> %v
}

declare <vscale x 16 x half> @llvm.vp.nearbyint.nxv16f16(<vscale x 16 x half>, <vscale x 16 x i1>, i32)

define <vscale x 16 x half> @vp_nearbyint_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI8_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI8_0)(a1)
; ZVFH-NEXT:    vmv1r.v v12, v0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFH-NEXT:    vfabs.v v16, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; ZVFH-NEXT:    vmflt.vf v12, v16, fa5, v0.t
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vmv1r.v v12, v0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v24, v16, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v12, v24, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vmv1r.v v0, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 16 x half> @llvm.vp.nearbyint.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x half> %v
}

define <vscale x 16 x half> @vp_nearbyint_nxv16f16_unmasked(<vscale x 16 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv16f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI9_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI9_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFH-NEXT:    vfabs.v v12, v8
; ZVFH-NEXT:    vmflt.vf v0, v12, fa5
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv16f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v16
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v16, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v16, v8, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 16 x half> @llvm.vp.nearbyint.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 16 x half> %v
}

declare <vscale x 32 x half> @llvm.vp.nearbyint.nxv32f16(<vscale x 32 x half>, <vscale x 32 x i1>, i32)

define <vscale x 32 x half> @vp_nearbyint_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI10_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI10_0)(a1)
; ZVFH-NEXT:    vmv1r.v v16, v0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; ZVFH-NEXT:    vfabs.v v24, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, mu
; ZVFH-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vmv1r.v v0, v16
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    addi sp, sp, -16
; ZVFHMIN-NEXT:    .cfi_def_cfa_offset 16
; ZVFHMIN-NEXT:    csrr a1, vlenb
; ZVFHMIN-NEXT:    slli a1, a1, 3
; ZVFHMIN-NEXT:    sub sp, sp, a1
; ZVFHMIN-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; ZVFHMIN-NEXT:    vmv1r.v v7, v0
; ZVFHMIN-NEXT:    csrr a2, vlenb
; ZVFHMIN-NEXT:    slli a1, a2, 1
; ZVFHMIN-NEXT:    sub a3, a0, a1
; ZVFHMIN-NEXT:    sltu a4, a0, a3
; ZVFHMIN-NEXT:    addi a4, a4, -1
; ZVFHMIN-NEXT:    and a3, a4, a3
; ZVFHMIN-NEXT:    srli a2, a2, 2
; ZVFHMIN-NEXT:    vsetvli a4, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v17, v0, a2
; ZVFHMIN-NEXT:    addi a2, sp, 16
; ZVFHMIN-NEXT:    vs8r.v v8, (a2) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v12
; ZVFHMIN-NEXT:    vmv1r.v v0, v17
; ZVFHMIN-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v24, v0.t
; ZVFHMIN-NEXT:    lui a2, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a2
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v17, v8, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a2
; ZVFHMIN-NEXT:    vmv1r.v v0, v17
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v24, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    fsflags a2
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v24, v8, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v24
; ZVFHMIN-NEXT:    bltu a0, a1, .LBB10_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    mv a0, a1
; ZVFHMIN-NEXT:  .LBB10_2:
; ZVFHMIN-NEXT:    addi a1, sp, 16
; ZVFHMIN-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v16, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v7, v16, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v16, v24, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v24, v16, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v24
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 3
; ZVFHMIN-NEXT:    add sp, sp, a0
; ZVFHMIN-NEXT:    addi sp, sp, 16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 32 x half> @llvm.vp.nearbyint.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x half> %v
}

define <vscale x 32 x half> @vp_nearbyint_nxv32f16_unmasked(<vscale x 32 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_nearbyint_nxv32f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI11_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI11_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; ZVFH-NEXT:    vfabs.v v16, v8
; ZVFH-NEXT:    vmflt.vf v0, v16, fa5
; ZVFH-NEXT:    frflags a0
; ZVFH-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; ZVFH-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; ZVFH-NEXT:    fsflags a0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_nearbyint_nxv32f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    addi sp, sp, -16
; ZVFHMIN-NEXT:    .cfi_def_cfa_offset 16
; ZVFHMIN-NEXT:    csrr a1, vlenb
; ZVFHMIN-NEXT:    slli a1, a1, 3
; ZVFHMIN-NEXT:    sub sp, sp, a1
; ZVFHMIN-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; ZVFHMIN-NEXT:    csrr a2, vlenb
; ZVFHMIN-NEXT:    slli a1, a2, 1
; ZVFHMIN-NEXT:    sub a3, a0, a1
; ZVFHMIN-NEXT:    sltu a4, a0, a3
; ZVFHMIN-NEXT:    addi a4, a4, -1
; ZVFHMIN-NEXT:    and a3, a4, a3
; ZVFHMIN-NEXT:    srli a2, a2, 2
; ZVFHMIN-NEXT:    vsetvli a4, zero, e8, m4, ta, ma
; ZVFHMIN-NEXT:    vmset.m v16
; ZVFHMIN-NEXT:    vsetvli a4, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v16, v16, a2
; ZVFHMIN-NEXT:    addi a2, sp, 16
; ZVFHMIN-NEXT:    vs8r.v v8, (a2) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v12
; ZVFHMIN-NEXT:    vmv1r.v v0, v16
; ZVFHMIN-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v24, v0.t
; ZVFHMIN-NEXT:    lui a2, 307200
; ZVFHMIN-NEXT:    fmv.w.x fa5, a2
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v16, v8, fa5, v0.t
; ZVFHMIN-NEXT:    frflags a2
; ZVFHMIN-NEXT:    vmv1r.v v0, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v24, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    fsflags a2
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v24, v8, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v24
; ZVFHMIN-NEXT:    bltu a0, a1, .LBB11_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    mv a0, a1
; ZVFHMIN-NEXT:  .LBB11_2:
; ZVFHMIN-NEXT:    addi a1, sp, 16
; ZVFHMIN-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v24
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v24, v16
; ZVFHMIN-NEXT:    vmflt.vf v0, v24, fa5
; ZVFHMIN-NEXT:    frflags a0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; ZVFHMIN-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    fsflags a0
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 3
; ZVFHMIN-NEXT:    add sp, sp, a0
; ZVFHMIN-NEXT:    addi sp, sp, 16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 32 x half> @llvm.vp.nearbyint.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 32 x half> %v
}

declare <vscale x 1 x float> @llvm.vp.nearbyint.nxv1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)

define <vscale x 1 x float> @vp_nearbyint_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x float> @llvm.vp.nearbyint.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x float> %v
}

define <vscale x 1 x float> @vp_nearbyint_nxv1f32_unmasked(<vscale x 1 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv1f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x float> @llvm.vp.nearbyint.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 1 x float> %v
}

declare <vscale x 2 x float> @llvm.vp.nearbyint.nxv2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)

define <vscale x 2 x float> @vp_nearbyint_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.vp.nearbyint.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x float> %v
}

define <vscale x 2 x float> @vp_nearbyint_nxv2f32_unmasked(<vscale x 2 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv2f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.vp.nearbyint.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 2 x float> %v
}

declare <vscale x 4 x float> @llvm.vp.nearbyint.nxv4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)

define <vscale x 4 x float> @vp_nearbyint_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v12, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vmflt.vf v10, v12, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x float> @llvm.vp.nearbyint.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x float> %v
}

define <vscale x 4 x float> @vp_nearbyint_nxv4f32_unmasked(<vscale x 4 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv4f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x float> @llvm.vp.nearbyint.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 4 x float> %v
}

declare <vscale x 8 x float> @llvm.vp.nearbyint.nxv8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)

define <vscale x 8 x float> @vp_nearbyint_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v12, v0
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vmflt.vf v12, v16, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x float> @llvm.vp.nearbyint.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vp_nearbyint_nxv8f32_unmasked(<vscale x 8 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv8f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vfabs.v v12, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x float> @llvm.vp.nearbyint.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 8 x float> %v
}

declare <vscale x 16 x float> @llvm.vp.nearbyint.nxv16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)

define <vscale x 16 x float> @vp_nearbyint_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v16, v0
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x float> @llvm.vp.nearbyint.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x float> %v
}

define <vscale x 16 x float> @vp_nearbyint_nxv16f32_unmasked(<vscale x 16 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv16f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v16, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x float> @llvm.vp.nearbyint.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 16 x float> %v
}

declare <vscale x 1 x double> @llvm.vp.nearbyint.nxv1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)

define <vscale x 1 x double> @vp_nearbyint_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI22_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI22_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.vp.nearbyint.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x double> %v
}

define <vscale x 1 x double> @vp_nearbyint_nxv1f64_unmasked(<vscale x 1 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv1f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI23_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI23_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.vp.nearbyint.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 1 x double> %v
}

declare <vscale x 2 x double> @llvm.vp.nearbyint.nxv2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)

define <vscale x 2 x double> @vp_nearbyint_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI24_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI24_0)(a1)
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vfabs.v v12, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; CHECK-NEXT:    vmflt.vf v10, v12, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x double> @llvm.vp.nearbyint.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x double> %v
}

define <vscale x 2 x double> @vp_nearbyint_nxv2f64_unmasked(<vscale x 2 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv2f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI25_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI25_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x double> @llvm.vp.nearbyint.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 2 x double> %v
}

declare <vscale x 4 x double> @llvm.vp.nearbyint.nxv4f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)

define <vscale x 4 x double> @vp_nearbyint_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI26_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI26_0)(a1)
; CHECK-NEXT:    vmv1r.v v12, v0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; CHECK-NEXT:    vmflt.vf v12, v16, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x double> @llvm.vp.nearbyint.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x double> %v
}

define <vscale x 4 x double> @vp_nearbyint_nxv4f64_unmasked(<vscale x 4 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv4f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI27_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI27_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vfabs.v v12, v8
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x double> @llvm.vp.nearbyint.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 4 x double> %v
}

declare <vscale x 7 x double> @llvm.vp.nearbyint.nxv7f64(<vscale x 7 x double>, <vscale x 7 x i1>, i32)

define <vscale x 7 x double> @vp_nearbyint_nxv7f64(<vscale x 7 x double> %va, <vscale x 7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv7f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI28_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI28_0)(a1)
; CHECK-NEXT:    vmv1r.v v16, v0
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 7 x double> @llvm.vp.nearbyint.nxv7f64(<vscale x 7 x double> %va, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x double> %v
}

define <vscale x 7 x double> @vp_nearbyint_nxv7f64_unmasked(<vscale x 7 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv7f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI29_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI29_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8
; CHECK-NEXT:    vmflt.vf v0, v16, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 7 x double> @llvm.vp.nearbyint.nxv7f64(<vscale x 7 x double> %va, <vscale x 7 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 7 x double> %v
}

declare <vscale x 8 x double> @llvm.vp.nearbyint.nxv8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

define <vscale x 8 x double> @vp_nearbyint_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI30_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI30_0)(a1)
; CHECK-NEXT:    vmv1r.v v16, v0
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x double> @llvm.vp.nearbyint.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vp_nearbyint_nxv8f64_unmasked(<vscale x 8 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv8f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI31_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI31_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8
; CHECK-NEXT:    vmflt.vf v0, v16, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x double> @llvm.vp.nearbyint.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 8 x double> %v
}

; Test splitting.
declare <vscale x 16 x double> @llvm.vp.nearbyint.nxv16f64(<vscale x 16 x double>, <vscale x 16 x i1>, i32)

define <vscale x 16 x double> @vp_nearbyint_nxv16f64(<vscale x 16 x double> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v7, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    srli a2, a1, 3
; CHECK-NEXT:    vsetvli a3, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vx v6, v0, a2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    lui a3, %hi(.LCPI32_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI32_0)(a3)
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v6, v24, fa5, v0.t
; CHECK-NEXT:    frflags a2
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    fsflags a2
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB32_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB32_2:
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v7, v24, fa5, v0.t
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x double> @llvm.vp.nearbyint.nxv16f64(<vscale x 16 x double> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x double> %v
}

define <vscale x 16 x double> @vp_nearbyint_nxv16f64_unmasked(<vscale x 16 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_nearbyint_nxv16f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    lui a3, %hi(.LCPI33_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI33_0)(a3)
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v16
; CHECK-NEXT:    vmflt.vf v0, v24, fa5
; CHECK-NEXT:    frflags a2
; CHECK-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    fsflags a2
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB33_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB33_2:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v8
; CHECK-NEXT:    vmflt.vf v0, v24, fa5
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x double> @llvm.vp.nearbyint.nxv16f64(<vscale x 16 x double> %va, <vscale x 16 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 16 x double> %v
}
