; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mattr=+simd128 | FileCheck %s

; Regression test for a crash caused by
; WebAssemblyTargetLowering::ReplaceNodeResults not being
; implemented. Since SIMD is enabled, sign_ext_inreg is custom lowered
; but the result is i16, an illegal value. This requires
; ReplaceNodeResults to resolve, but the default implementation is to
; abort.

target triple = "wasm32-unknown-emscripten"

define void @foo() {
; CHECK-LABEL: foo:
; CHECK:         .functype foo () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    i32.const 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32.load8_s 0
; CHECK-NEXT:    i32.store16 0
; CHECK-NEXT:    # fallthrough-return
entry:
  %0 = load ptr, ptr undef, align 4
  %1 = load i32, ptr %0, align 4
  %2 = load i32, ptr undef, align 4
  %conv67 = trunc i32 %2 to i8
  %conv68 = sext i8 %conv67 to i16
  store i16 %conv68, ptr null, align 2
  ret void
}
