; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x i64> @vwsub_vv_nxv1i64_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwsub_vv_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsub.vv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsubu_vv_nxv1i64_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsub_vx_nxv1i64_nxv1i32(<vscale x 1 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsub_vx_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsub.vx v9, v8, a0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vc = sext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsubu_vx_nxv1i64_nxv1i32(<vscale x 1 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsubu_vx_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsubu.vx v9, v8, a0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vc = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsub_wv_nxv1i64_nxv1i32(<vscale x 1 x i64> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwsub_wv_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsub.wv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %vd = sub <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwsubu_wv_nxv1i64_nxv1i32(<vscale x 1 x i64> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsubu.wv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %vd = sub <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwsub_wx_nxv1i64_nxv1i32(<vscale x 1 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsub_wx_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsub.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vb = sext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %vc = sub <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 1 x i64> @vwsubu_wx_nxv1i64_nxv1i32(<vscale x 1 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsubu_wx_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwsubu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vb = zext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %vc = sub <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 2 x i64> @vwsub_vv_nxv2i64_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwsub_vv_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsub.vv v10, v8, v9
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsubu_vv_nxv2i64_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsub_vx_nxv2i64_nxv2i32(<vscale x 2 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsub_vx_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsub.vx v10, v8, a0
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vc = sext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsubu_vx_nxv2i64_nxv2i32(<vscale x 2 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsubu_vx_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsubu.vx v10, v8, a0
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vc = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsub_wv_nxv2i64_nxv2i32(<vscale x 2 x i64> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwsub_wv_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsub.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %vd = sub <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwsubu_wv_nxv2i64_nxv2i32(<vscale x 2 x i64> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsubu.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %vd = sub <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwsub_wx_nxv2i64_nxv2i32(<vscale x 2 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsub_wx_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsub.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vb = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %vc = sub <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 2 x i64> @vwsubu_wx_nxv2i64_nxv2i32(<vscale x 2 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsubu_wx_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwsubu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vb = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %vc = sub <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 4 x i64> @vwsub_vv_nxv4i64_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwsub_vv_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsub.vv v12, v8, v10
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsubu_vv_nxv4i64_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsubu.vv v12, v8, v10
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsub_vx_nxv4i64_nxv4i32(<vscale x 4 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsub_vx_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsub.vx v12, v8, a0
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vc = sext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsubu_vx_nxv4i64_nxv4i32(<vscale x 4 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsubu_vx_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsubu.vx v12, v8, a0
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vc = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsub_wv_nxv4i64_nxv4i32(<vscale x 4 x i64> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwsub_wv_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsub.wv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %vd = sub <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwsubu_wv_nxv4i64_nxv4i32(<vscale x 4 x i64> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsubu.wv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %vd = sub <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwsub_wx_nxv4i64_nxv4i32(<vscale x 4 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsub_wx_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsub.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vb = sext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %vc = sub <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 4 x i64> @vwsubu_wx_nxv4i64_nxv4i32(<vscale x 4 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsubu_wx_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwsubu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vb = zext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %vc = sub <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 8 x i64> @vwsub_vv_nxv8i64_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwsub_vv_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsub.vv v16, v8, v12
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsubu_vv_nxv8i64_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsubu.vv v16, v8, v12
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsub_vx_nxv8i64_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsub_vx_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsub.vx v16, v8, a0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = sext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsubu_vx_nxv8i64_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: vwsubu_vx_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsubu.vx v16, v8, a0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsub_wv_nxv8i64_nxv8i32(<vscale x 8 x i64> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwsub_wv_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsub.wv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %vd = sub <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwsubu_wv_nxv8i64_nxv8i32(<vscale x 8 x i64> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsubu.wv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %vd = sub <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwsub_wx_nxv8i64_nxv8i32(<vscale x 8 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsub_wx_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsub.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vb = sext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %vc = sub <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}

define <vscale x 8 x i64> @vwsubu_wx_nxv8i64_nxv8i32(<vscale x 8 x i64> %va, i32 %b) {
; CHECK-LABEL: vwsubu_wx_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwsubu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vb = zext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %vc = sub <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}

define <vscale x 1 x i64> @vwsub_vv_nxv1i64_nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i16> %vb) {
; CHECK-LABEL: vwsub_vv_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i16> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i16> %vb to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsubu_vv_nxv1i64_nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i16> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i16> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i16> %vb to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsub_vx_nxv1i64_nxv1i16(<vscale x 1 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsub_vx_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %vc = sext <vscale x 1 x i16> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i16> %splat to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsubu_vx_nxv1i64_nxv1i16(<vscale x 1 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsubu_vx_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vwsubu.vx v9, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %vc = zext <vscale x 1 x i16> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i16> %splat to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsub_wv_nxv1i64_nxv1i16(<vscale x 1 x i64> %va, <vscale x 1 x i16> %vb) {
; CHECK-LABEL: vwsub_wv_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v9
; CHECK-NEXT:    vwsub.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i16> %vb to <vscale x 1 x i64>
  %vd = sub <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwsubu_wv_nxv1i64_nxv1i16(<vscale x 1 x i64> %va, <vscale x 1 x i16> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v9
; CHECK-NEXT:    vwsubu.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i16> %vb to <vscale x 1 x i64>
  %vd = sub <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwsub_wx_nxv1i64_nxv1i16(<vscale x 1 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsub_wx_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v9
; CHECK-NEXT:    vwsub.wv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %vb = sext <vscale x 1 x i16> %splat to <vscale x 1 x i64>
  %vc = sub <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 1 x i64> @vwsubu_wx_nxv1i64_nxv1i16(<vscale x 1 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsubu_wx_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v9
; CHECK-NEXT:    vwsubu.wv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %vb = zext <vscale x 1 x i16> %splat to <vscale x 1 x i64>
  %vc = sub <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 2 x i64> @vwsub_vv_nxv2i64_nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i16> %vb) {
; CHECK-LABEL: vwsub_vv_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i16> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i16> %vb to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsubu_vv_nxv2i64_nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i16> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i16> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i16> %vb to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsub_vx_nxv2i64_nxv2i16(<vscale x 2 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsub_vx_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %vc = sext <vscale x 2 x i16> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsubu_vx_nxv2i64_nxv2i16(<vscale x 2 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsubu_vx_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vwsubu.vx v10, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %vc = zext <vscale x 2 x i16> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsub_wv_nxv2i64_nxv2i16(<vscale x 2 x i64> %va, <vscale x 2 x i16> %vb) {
; CHECK-LABEL: vwsub_wv_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v11, v10
; CHECK-NEXT:    vwsub.wv v8, v8, v11
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i16> %vb to <vscale x 2 x i64>
  %vd = sub <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwsubu_wv_nxv2i64_nxv2i16(<vscale x 2 x i64> %va, <vscale x 2 x i16> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v11, v10
; CHECK-NEXT:    vwsubu.wv v8, v8, v11
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i16> %vb to <vscale x 2 x i64>
  %vd = sub <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwsub_wx_nxv2i64_nxv2i16(<vscale x 2 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsub_wx_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v11, v10
; CHECK-NEXT:    vwsub.wv v8, v8, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %vb = sext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %vc = sub <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 2 x i64> @vwsubu_wx_nxv2i64_nxv2i16(<vscale x 2 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsubu_wx_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v11, v10
; CHECK-NEXT:    vwsubu.wv v8, v8, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %vb = zext <vscale x 2 x i16> %splat to <vscale x 2 x i64>
  %vc = sub <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 4 x i64> @vwsub_vv_nxv4i64_nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb) {
; CHECK-LABEL: vwsub_vv_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vsext.vf2 v14, v9
; CHECK-NEXT:    vwsub.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i16> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i16> %vb to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsubu_vv_nxv4i64_nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vwsubu.vv v12, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i16> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i16> %vb to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsub_vx_nxv4i64_nxv4i16(<vscale x 4 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsub_vx_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vsext.vf2 v14, v9
; CHECK-NEXT:    vwsub.vv v8, v12, v14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %vc = sext <vscale x 4 x i16> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i16> %splat to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsubu_vx_nxv4i64_nxv4i16(<vscale x 4 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsubu_vx_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vwsubu.vx v12, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %vc = zext <vscale x 4 x i16> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i16> %splat to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsub_wv_nxv4i64_nxv4i16(<vscale x 4 x i64> %va, <vscale x 4 x i16> %vb) {
; CHECK-LABEL: vwsub_wv_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v14, v12
; CHECK-NEXT:    vwsub.wv v8, v8, v14
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i16> %vb to <vscale x 4 x i64>
  %vd = sub <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwsubu_wv_nxv4i64_nxv4i16(<vscale x 4 x i64> %va, <vscale x 4 x i16> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v14, v12
; CHECK-NEXT:    vwsubu.wv v8, v8, v14
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i16> %vb to <vscale x 4 x i64>
  %vd = sub <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwsub_wx_nxv4i64_nxv4i16(<vscale x 4 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsub_wx_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v14, v12
; CHECK-NEXT:    vwsub.wv v8, v8, v14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %vb = sext <vscale x 4 x i16> %splat to <vscale x 4 x i64>
  %vc = sub <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 4 x i64> @vwsubu_wx_nxv4i64_nxv4i16(<vscale x 4 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsubu_wx_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v14, v12
; CHECK-NEXT:    vwsubu.wv v8, v8, v14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %vb = zext <vscale x 4 x i16> %splat to <vscale x 4 x i64>
  %vc = sub <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 8 x i64> @vwsub_vv_nxv8i64_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: vwsub_vv_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v16, v8
; CHECK-NEXT:    vsext.vf2 v20, v10
; CHECK-NEXT:    vwsub.vv v8, v16, v20
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i16> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i16> %vb to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsubu_vv_nxv8i64_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vwsubu.vv v16, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v16
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i16> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i16> %vb to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsub_vx_nxv8i64_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsub_vx_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v16, v8
; CHECK-NEXT:    vsext.vf2 v20, v10
; CHECK-NEXT:    vwsub.vv v8, v16, v20
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = sext <vscale x 8 x i16> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i16> %splat to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsubu_vx_nxv8i64_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: vwsubu_vx_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vwsubu.vx v16, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = zext <vscale x 8 x i16> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i16> %splat to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsub_wv_nxv8i64_nxv8i16(<vscale x 8 x i64> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: vwsub_wv_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v20, v16
; CHECK-NEXT:    vwsub.wv v8, v8, v20
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i16> %vb to <vscale x 8 x i64>
  %vd = sub <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwsubu_wv_nxv8i64_nxv8i16(<vscale x 8 x i64> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v20, v16
; CHECK-NEXT:    vwsubu.wv v8, v8, v20
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i16> %vb to <vscale x 8 x i64>
  %vd = sub <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwsub_wx_nxv8i64_nxv8i16(<vscale x 8 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsub_wx_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v20, v16
; CHECK-NEXT:    vwsub.wv v8, v8, v20
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vb = sext <vscale x 8 x i16> %splat to <vscale x 8 x i64>
  %vc = sub <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}

define <vscale x 8 x i64> @vwsubu_wx_nxv8i64_nxv8i16(<vscale x 8 x i64> %va, i16 %b) {
; CHECK-LABEL: vwsubu_wx_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v20, v16
; CHECK-NEXT:    vwsubu.wv v8, v8, v20
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i16 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vb = zext <vscale x 8 x i16> %splat to <vscale x 8 x i64>
  %vc = sub <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}

define <vscale x 1 x i64> @vwsub_vv_nxv1i64_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb) {
; CHECK-LABEL: vwsub_vv_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vsext.vf4 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i8> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i8> %vb to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsubu_vv_nxv1i64_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i8> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i8> %vb to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsub_vx_nxv1i64_nxv1i8(<vscale x 1 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsub_vx_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vsext.vf4 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %vc = sext <vscale x 1 x i8> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i8> %splat to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsubu_vx_nxv1i64_nxv1i8(<vscale x 1 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsubu_vx_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vwsubu.vx v9, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %vc = zext <vscale x 1 x i8> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i8> %splat to <vscale x 1 x i64>
  %ve = sub <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwsub_wv_nxv1i64_nxv1i8(<vscale x 1 x i64> %va, <vscale x 1 x i8> %vb) {
; CHECK-LABEL: vwsub_wv_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v9
; CHECK-NEXT:    vwsub.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i8> %vb to <vscale x 1 x i64>
  %vd = sub <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwsubu_wv_nxv1i64_nxv1i8(<vscale x 1 x i64> %va, <vscale x 1 x i8> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf4 v10, v9
; CHECK-NEXT:    vwsubu.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i8> %vb to <vscale x 1 x i64>
  %vd = sub <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwsub_wx_nxv1i64_nxv1i8(<vscale x 1 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsub_wx_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v9
; CHECK-NEXT:    vwsub.wv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %vb = sext <vscale x 1 x i8> %splat to <vscale x 1 x i64>
  %vc = sub <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 1 x i64> @vwsubu_wx_nxv1i64_nxv1i8(<vscale x 1 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsubu_wx_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf4 v10, v9
; CHECK-NEXT:    vwsubu.wv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %vb = zext <vscale x 1 x i8> %splat to <vscale x 1 x i64>
  %vc = sub <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 2 x i64> @vwsub_vv_nxv2i64_nxv2i8(<vscale x 2 x i8> %va, <vscale x 2 x i8> %vb) {
; CHECK-LABEL: vwsub_vv_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vsext.vf4 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i8> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i8> %vb to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsubu_vv_nxv2i64_nxv2i8(<vscale x 2 x i8> %va, <vscale x 2 x i8> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i8> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i8> %vb to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsub_vx_nxv2i64_nxv2i8(<vscale x 2 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsub_vx_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vsext.vf4 v11, v9
; CHECK-NEXT:    vwsub.vv v8, v10, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %vc = sext <vscale x 2 x i8> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsubu_vx_nxv2i64_nxv2i8(<vscale x 2 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsubu_vx_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vwsubu.vx v10, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %vc = zext <vscale x 2 x i8> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %ve = sub <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwsub_wv_nxv2i64_nxv2i8(<vscale x 2 x i64> %va, <vscale x 2 x i8> %vb) {
; CHECK-LABEL: vwsub_wv_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v11, v10
; CHECK-NEXT:    vwsub.wv v8, v8, v11
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i8> %vb to <vscale x 2 x i64>
  %vd = sub <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwsubu_wv_nxv2i64_nxv2i8(<vscale x 2 x i64> %va, <vscale x 2 x i8> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf4 v11, v10
; CHECK-NEXT:    vwsubu.wv v8, v8, v11
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i8> %vb to <vscale x 2 x i64>
  %vd = sub <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwsub_wx_nxv2i64_nxv2i8(<vscale x 2 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsub_wx_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v11, v10
; CHECK-NEXT:    vwsub.wv v8, v8, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %vb = sext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %vc = sub <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 2 x i64> @vwsubu_wx_nxv2i64_nxv2i8(<vscale x 2 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsubu_wx_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf4 v11, v10
; CHECK-NEXT:    vwsubu.wv v8, v8, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %vb = zext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %vc = sub <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 4 x i64> @vwsub_vv_nxv4i64_nxv4i8(<vscale x 4 x i8> %va, <vscale x 4 x i8> %vb) {
; CHECK-LABEL: vwsub_vv_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v12, v8
; CHECK-NEXT:    vsext.vf4 v14, v9
; CHECK-NEXT:    vwsub.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i8> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i8> %vb to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsubu_vv_nxv4i64_nxv4i8(<vscale x 4 x i8> %va, <vscale x 4 x i8> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vwsubu.vv v12, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v12
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i8> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i8> %vb to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsub_vx_nxv4i64_nxv4i8(<vscale x 4 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsub_vx_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v12, v8
; CHECK-NEXT:    vsext.vf4 v14, v9
; CHECK-NEXT:    vwsub.vv v8, v12, v14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %vc = sext <vscale x 4 x i8> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i8> %splat to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsubu_vx_nxv4i64_nxv4i8(<vscale x 4 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsubu_vx_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vwsubu.vx v12, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %vc = zext <vscale x 4 x i8> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i8> %splat to <vscale x 4 x i64>
  %ve = sub <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwsub_wv_nxv4i64_nxv4i8(<vscale x 4 x i64> %va, <vscale x 4 x i8> %vb) {
; CHECK-LABEL: vwsub_wv_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v14, v12
; CHECK-NEXT:    vwsub.wv v8, v8, v14
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i8> %vb to <vscale x 4 x i64>
  %vd = sub <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwsubu_wv_nxv4i64_nxv4i8(<vscale x 4 x i64> %va, <vscale x 4 x i8> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf4 v14, v12
; CHECK-NEXT:    vwsubu.wv v8, v8, v14
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i8> %vb to <vscale x 4 x i64>
  %vd = sub <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwsub_wx_nxv4i64_nxv4i8(<vscale x 4 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsub_wx_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v14, v12
; CHECK-NEXT:    vwsub.wv v8, v8, v14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %vb = sext <vscale x 4 x i8> %splat to <vscale x 4 x i64>
  %vc = sub <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 4 x i64> @vwsubu_wx_nxv4i64_nxv4i8(<vscale x 4 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsubu_wx_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf4 v14, v12
; CHECK-NEXT:    vwsubu.wv v8, v8, v14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %vb = zext <vscale x 4 x i8> %splat to <vscale x 4 x i64>
  %vc = sub <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 8 x i64> @vwsub_vv_nxv8i64_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: vwsub_vv_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v16, v8
; CHECK-NEXT:    vsext.vf4 v20, v9
; CHECK-NEXT:    vwsub.vv v8, v16, v20
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i8> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i8> %vb to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsubu_vv_nxv8i64_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: vwsubu_vv_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vwsubu.vv v16, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v16
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i8> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i8> %vb to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsub_vx_nxv8i64_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsub_vx_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v16, v8
; CHECK-NEXT:    vsext.vf4 v20, v9
; CHECK-NEXT:    vwsub.vv v8, v16, v20
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = sext <vscale x 8 x i8> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i8> %splat to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsubu_vx_nxv8i64_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: vwsubu_vx_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vwsubu.vx v16, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = zext <vscale x 8 x i8> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i8> %splat to <vscale x 8 x i64>
  %ve = sub <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwsub_wv_nxv8i64_nxv8i8(<vscale x 8 x i64> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: vwsub_wv_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v20, v16
; CHECK-NEXT:    vwsub.wv v8, v8, v20
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i8> %vb to <vscale x 8 x i64>
  %vd = sub <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwsubu_wv_nxv8i64_nxv8i8(<vscale x 8 x i64> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: vwsubu_wv_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf4 v20, v16
; CHECK-NEXT:    vwsubu.wv v8, v8, v20
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i8> %vb to <vscale x 8 x i64>
  %vd = sub <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwsub_wx_nxv8i64_nxv8i8(<vscale x 8 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsub_wx_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v20, v16
; CHECK-NEXT:    vwsub.wv v8, v8, v20
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vb = sext <vscale x 8 x i8> %splat to <vscale x 8 x i64>
  %vc = sub <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}

define <vscale x 8 x i64> @vwsubu_wx_nxv8i64_nxv8i8(<vscale x 8 x i64> %va, i8 %b) {
; CHECK-LABEL: vwsubu_wx_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf4 v20, v16
; CHECK-NEXT:    vwsubu.wv v8, v8, v20
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i8 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vb = zext <vscale x 8 x i8> %splat to <vscale x 8 x i64>
  %vc = sub <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}
