; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=tonga -denormal-fp-math-f32=preserve-sign  -verify-machineinstrs < %s | FileCheck -check-prefixes=VI,VI-DENORM %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=tonga -denormal-fp-math=preserve-sign -denormal-fp-math-f32=preserve-sign  -verify-machineinstrs < %s | FileCheck -check-prefixes=VI,VI-FLUSH %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 -denormal-fp-math-f32=preserve-sign  -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-DENORM %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=preserve-sign  -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-FLUSH %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -denormal-fp-math-f32=preserve-sign  -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-DENORM %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=preserve-sign  -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-FLUSH %s

; Make sure (fmul (fadd x, x), c) -> (fmul x, (fmul 2.0, c)) doesn't
; make add an instruction if the fadd has more than one use.

declare half @llvm.fabs.f16(half) #1
declare float @llvm.fabs.f32(float) #1

define amdgpu_kernel void @multiple_fadd_use_test_f32(ptr addrspace(1) %out, float %x, float %y, float %z) #0 {
; VI-LABEL: multiple_fadd_use_test_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_add_f32_e64 v0, s3, -1.0
; VI-NEXT:    v_add_f32_e64 v1, s2, -1.0
; VI-NEXT:    v_cmp_gt_f32_e64 vcc, |v0|, |v1|
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; VI-NEXT:    v_add_f32_e64 v0, |v0|, |v0|
; VI-NEXT:    v_mul_f32_e32 v1, v0, v0
; VI-NEXT:    v_mad_f32 v2, -v1, v0, 1.0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: multiple_fadd_use_test_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e64 v0, s3, -1.0
; GFX10-NEXT:    v_add_f32_e64 v1, s2, -1.0
; GFX10-NEXT:    v_cmp_gt_f32_e64 vcc_lo, |v0|, |v1|
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX10-NEXT:    v_add_f32_e64 v0, |v0|, |v0|
; GFX10-NEXT:    v_mul_f32_e32 v1, v0, v0
; GFX10-NEXT:    v_fma_f32 v0, -v1, v0, 1.0
; GFX10-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: multiple_fadd_use_test_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_f32_e64 v0, s3, -1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s2, -1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_f32_e64 vcc_lo, |v0|, |v1|
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX11-NEXT:    v_add_f32_e64 v0, |v0|, |v0|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v1, v0, v0
; GFX11-NEXT:    v_fma_f32 v0, -v1, v0, 1.0
; GFX11-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %a11 = fadd float %y, -1.0
  %a12 = call float @llvm.fabs.f32(float %a11)
  %a13 = fadd float %x, -1.0
  %a14 = call float @llvm.fabs.f32(float %a13)
  %a15 = fcmp ogt float %a12, %a14
  %a16 = select i1 %a15, float %a12, float %a14
  %a17 = fmul float %a16, 2.0
  %a18 = fmul float %a17, %a17
  %a19 = fmul float %a18, %a17
  %a20 = fsub float 1.0, %a19
  store float %a20, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @multiple_use_fadd_fmac_f32(ptr addrspace(1) %out, float %x, [8 x i32], float %y) #0 {
; VI-LABEL: multiple_use_fadd_fmac_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x8
; VI-NEXT:    s_load_dword s3, s[6:7], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_add_u32 s2, s0, 4
; VI-NEXT:    v_add_f32_e64 v2, s4, s4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    s_addc_u32 s3, s1, 0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mac_f32_e64 v3, s4, 2.0
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: multiple_use_fadd_fmac_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-NEXT:    s_load_dword s3, s[6:7], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e64 v1, s2, s2
; GFX10-NEXT:    v_fma_f32 v2, s2, 2.0, s3
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_store_dword v0, v2, s[0:1] offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: multiple_use_fadd_fmac_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-NEXT:    s_load_b32 s5, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_f32_e64 v1, s4, s4
; GFX11-NEXT:    v_fma_f32 v2, s4, 2.0, s5
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1] dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_store_b32 v0, v2, s[0:1] offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %out.gep.1 = getelementptr float, ptr addrspace(1) %out, i32 1
  %mul2 = fmul fast float %x, 2.0
  %mad = fadd fast float %mul2, %y
  store volatile float %mul2, ptr addrspace(1) %out
  store volatile float %mad, ptr addrspace(1) %out.gep.1
  ret void
}

define amdgpu_kernel void @multiple_use_fadd_fmad_f32(ptr addrspace(1) %out, float %x, float %y) #0 {
; VI-LABEL: multiple_use_fadd_fmad_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_add_u32 s4, s0, 4
; VI-NEXT:    v_add_f32_e64 v2, |s2|, |s2|
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    s_addc_u32 s5, s1, 0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mad_f32 v3, |s2|, 2.0, v3
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_store_dword v[0:1], v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: multiple_use_fadd_fmad_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e64 v1, |s2|, |s2|
; GFX10-NEXT:    v_fma_f32 v2, |s2|, 2.0, s3
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_store_dword v0, v2, s[0:1] offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: multiple_use_fadd_fmad_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_f32_e64 v1, |s2|, |s2|
; GFX11-NEXT:    v_fma_f32 v2, |s2|, 2.0, s3
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1] dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_store_b32 v0, v2, s[0:1] offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %out.gep.1 = getelementptr float, ptr addrspace(1) %out, i32 1
  %x.abs = call float @llvm.fabs.f32(float %x)
  %mul2 = fmul fast float %x.abs, 2.0
  %mad = fadd fast float %mul2, %y
  store volatile float %mul2, ptr addrspace(1) %out
  store volatile float %mad, ptr addrspace(1) %out.gep.1
  ret void
}

define amdgpu_kernel void @multiple_use_fadd_multi_fmad_f32(ptr addrspace(1) %out, float %x, float %y, float %z) #0 {
; VI-LABEL: multiple_use_fadd_multi_fmad_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x0
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_u32 s6, s4, 4
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    v_mad_f32 v2, |s0|, 2.0, v0
; VI-NEXT:    v_mad_f32 v3, |s0|, 2.0, v1
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_addc_u32 s7, s5, 0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    flat_store_dword v[0:1], v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: multiple_use_fadd_multi_fmad_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x8
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_fma_f32 v1, |s0|, 2.0, s1
; GFX10-NEXT:    v_fma_f32 v2, |s0|, 2.0, s2
; GFX10-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_store_dword v0, v2, s[4:5] offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: multiple_use_fadd_multi_fmad_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_fma_f32 v1, |s4|, 2.0, s5
; GFX11-NEXT:    v_fma_f32 v2, |s4|, 2.0, s6
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1] dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_store_b32 v0, v2, s[0:1] offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %out.gep.1 = getelementptr float, ptr addrspace(1) %out, i32 1
  %x.abs = call float @llvm.fabs.f32(float %x)
  %mul2 = fmul fast float %x.abs, 2.0
  %mad0 = fadd fast float %mul2, %y
  %mad1 = fadd fast float %mul2, %z
  store volatile float %mad0, ptr addrspace(1) %out
  store volatile float %mad1, ptr addrspace(1) %out.gep.1
  ret void
}

define amdgpu_kernel void @fmul_x2_xn2_f32(ptr addrspace(1) %out, float %x, float %y) #0 {
; VI-LABEL: fmul_x2_xn2_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[6:7], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e64 v0, s2, -4.0
; VI-NEXT:    v_mul_f32_e32 v2, s2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: fmul_x2_xn2_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e64 v0, s2, -4.0
; GFX10-NEXT:    v_mul_f32_e32 v0, s2, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fmul_x2_xn2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e64 v0, s4, -4.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, s4, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1] dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %out.gep.1 = getelementptr float, ptr addrspace(1) %out, i32 1
  %mul2 = fmul fast float %x, 2.0
  %muln2 = fmul fast float %x, -2.0
  %mul = fmul fast float %mul2, %muln2
  store volatile float %mul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fmul_x2_xn3_f32(ptr addrspace(1) %out, float %x, float %y) #0 {
; VI-LABEL: fmul_x2_xn3_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[6:7], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, 0xc0c00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e32 v0, s2, v0
; VI-NEXT:    v_mul_f32_e32 v2, s2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: fmul_x2_xn3_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e64 v0, 0xc0c00000, s2
; GFX10-NEXT:    v_mul_f32_e32 v0, s2, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fmul_x2_xn3_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e64 v0, 0xc0c00000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, s4, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1] dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %out.gep.1 = getelementptr float, ptr addrspace(1) %out, i32 1
  %mul2 = fmul fast float %x, 2.0
  %muln2 = fmul fast float %x, -3.0
  %mul = fmul fast float %mul2, %muln2
  store volatile float %mul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @multiple_fadd_use_test_f16(ptr addrspace(1) %out, i16 zeroext %x.arg, i16 zeroext %y.arg, i16 zeroext %z.arg) #0 {
; VI-DENORM-LABEL: multiple_fadd_use_test_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dword s2, s[6:7], 0x8
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_lshr_b32 s3, s2, 16
; VI-DENORM-NEXT:    v_add_f16_e64 v0, s2, -1.0
; VI-DENORM-NEXT:    v_add_f16_e64 v1, s3, -1.0
; VI-DENORM-NEXT:    v_cmp_gt_f16_e64 vcc, |v1|, |v0|
; VI-DENORM-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-DENORM-NEXT:    v_add_f16_e64 v0, |v0|, |v0|
; VI-DENORM-NEXT:    v_mul_f16_e32 v1, v0, v0
; VI-DENORM-NEXT:    v_fma_f16 v2, -v1, v0, 1.0
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s0
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: multiple_fadd_use_test_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dword s2, s[6:7], 0x8
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_lshr_b32 s3, s2, 16
; VI-FLUSH-NEXT:    v_add_f16_e64 v0, s2, -1.0
; VI-FLUSH-NEXT:    v_add_f16_e64 v1, s3, -1.0
; VI-FLUSH-NEXT:    v_cmp_gt_f16_e64 vcc, |v1|, |v0|
; VI-FLUSH-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-FLUSH-NEXT:    v_add_f16_e64 v0, |v0|, |v0|
; VI-FLUSH-NEXT:    v_mul_f16_e32 v1, v0, v0
; VI-FLUSH-NEXT:    v_mad_f16 v2, -v1, v0, 1.0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: multiple_fadd_use_test_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dword s0, s[6:7], 0x8
; GFX10-DENORM-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_lshr_b32 s1, s0, 16
; GFX10-DENORM-NEXT:    v_add_f16_e64 v0, s0, -1.0
; GFX10-DENORM-NEXT:    v_add_f16_e64 v1, s1, -1.0
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-DENORM-NEXT:    v_cmp_gt_f16_e64 vcc_lo, |v1|, |v0|
; GFX10-DENORM-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-DENORM-NEXT:    v_add_f16_e64 v0, |v0|, |v0|
; GFX10-DENORM-NEXT:    v_mul_f16_e32 v1, v0, v0
; GFX10-DENORM-NEXT:    v_fma_f16 v0, -v1, v0, 1.0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    global_store_short v2, v0, s[0:1]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: multiple_fadd_use_test_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dword s0, s[6:7], 0x8
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_lshr_b32 s1, s0, 16
; GFX10-FLUSH-NEXT:    v_add_f16_e64 v0, s0, -1.0
; GFX10-FLUSH-NEXT:    v_add_f16_e64 v1, s1, -1.0
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-FLUSH-NEXT:    v_cmp_gt_f16_e64 vcc_lo, |v1|, |v0|
; GFX10-FLUSH-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-FLUSH-NEXT:    v_add_f16_e64 v0, |v0|, |v0|
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v0, v0
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v0, v1, v0
; GFX10-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v0, 1.0, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_store_short v1, v0, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: multiple_fadd_use_test_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b32 s0, s[2:3], 0x8
; GFX11-DENORM-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_lshr_b32 s1, s0, 16
; GFX11-DENORM-NEXT:    v_add_f16_e64 v0, s0, -1.0
; GFX11-DENORM-NEXT:    v_add_f16_e64 v1, s1, -1.0
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_cmp_gt_f16_e64 vcc_lo, |v1|, |v0|
; GFX11-DENORM-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-DENORM-NEXT:    v_add_f16_e64 v0, |v0|, |v0|
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_mul_f16_e32 v1, v0, v0
; GFX11-DENORM-NEXT:    v_fma_f16 v0, -v1, v0, 1.0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    global_store_b16 v2, v0, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: multiple_fadd_use_test_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b32 s0, s[2:3], 0x8
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_lshr_b32 s1, s0, 16
; GFX11-FLUSH-NEXT:    v_add_f16_e64 v0, s0, -1.0
; GFX11-FLUSH-NEXT:    v_add_f16_e64 v1, s1, -1.0
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_cmp_gt_f16_e64 vcc_lo, |v1|, |v0|
; GFX11-FLUSH-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FLUSH-NEXT:    v_add_f16_e64 v0, |v0|, |v0|
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v0, v0
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v0, v1, v0
; GFX11-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v0, 1.0, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
  %x = bitcast i16 %x.arg to half
  %y = bitcast i16 %y.arg to half
  %z = bitcast i16 %z.arg to half
  %a11 = fadd half %y, -1.0
  %a12 = call half @llvm.fabs.f16(half %a11)
  %a13 = fadd half %x, -1.0
  %a14 = call half @llvm.fabs.f16(half %a13)
  %a15 = fcmp ogt half %a12, %a14
  %a16 = select i1 %a15, half %a12, half %a14
  %a17 = fmul half %a16, 2.0
  %a18 = fmul half %a17, %a17
  %a19 = fmul half %a18, %a17
  %a20 = fsub half 1.0, %a19
  store half %a20, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @multiple_use_fadd_fmac_f16(ptr addrspace(1) %out, i16 zeroext %x.arg, i16 zeroext %y.arg) #0 {
; VI-DENORM-LABEL: multiple_use_fadd_fmac_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dword s4, s[6:7], 0x8
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_lshr_b32 s3, s4, 16
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s3
; VI-DENORM-NEXT:    v_fma_f16 v3, s4, 2.0, v0
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s0
; VI-DENORM-NEXT:    v_add_f16_e64 v2, s4, s4
; VI-DENORM-NEXT:    s_add_u32 s2, s0, 2
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    s_addc_u32 s3, s1, 0
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s2
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-NEXT:    flat_store_short v[0:1], v3
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: multiple_use_fadd_fmac_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dword s4, s[6:7], 0x8
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_lshr_b32 s3, s4, 16
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s0
; VI-FLUSH-NEXT:    v_add_f16_e64 v2, s4, s4
; VI-FLUSH-NEXT:    s_add_u32 s2, s0, 2
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_mov_b32_e32 v3, s3
; VI-FLUSH-NEXT:    s_addc_u32 s3, s1, 0
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s2
; VI-FLUSH-NEXT:    v_mac_f16_e64 v3, s4, 2.0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v3
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: multiple_use_fadd_fmac_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_clause 0x1
; GFX10-DENORM-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_lshr_b32 s3, s2, 16
; GFX10-DENORM-NEXT:    v_add_f16_e64 v1, s2, s2
; GFX10-DENORM-NEXT:    v_fma_f16 v2, s2, 2.0, s3
; GFX10-DENORM-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[0:1] offset:2
; GFX10-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: multiple_use_fadd_fmac_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_clause 0x1
; GFX10-FLUSH-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e64 v0, s2, s2
; GFX10-FLUSH-NEXT:    s_lshr_b32 s2, s2, 16
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v2, s2, v0
; GFX10-FLUSH-NEXT:    global_store_short v1, v0, s[0:1]
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    global_store_short v1, v2, s[0:1] offset:2
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: multiple_use_fadd_fmac_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_clause 0x1
; GFX11-DENORM-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_lshr_b32 s2, s4, 16
; GFX11-DENORM-NEXT:    v_add_f16_e64 v1, s4, s4
; GFX11-DENORM-NEXT:    v_fma_f16 v2, s4, 2.0, s2
; GFX11-DENORM-NEXT:    global_store_b16 v0, v1, s[0:1] dlc
; GFX11-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[0:1] offset:2 dlc
; GFX11-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: multiple_use_fadd_fmac_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_clause 0x1
; GFX11-FLUSH-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e64 v0, s4, s4
; GFX11-FLUSH-NEXT:    s_lshr_b32 s2, s4, 16
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v2, s2, v0
; GFX11-FLUSH-NEXT:    global_store_b16 v1, v0, s[0:1] dlc
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    global_store_b16 v1, v2, s[0:1] offset:2 dlc
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
  %x = bitcast i16 %x.arg to half
  %y = bitcast i16 %y.arg to half
  %out.gep.1 = getelementptr half, ptr addrspace(1) %out, i32 1
  %mul2 = fmul fast half %x, 2.0
  %mad = fadd fast half %mul2, %y
  store volatile half %mul2, ptr addrspace(1) %out
  store volatile half %mad, ptr addrspace(1) %out.gep.1
  ret void
}

define amdgpu_kernel void @multiple_use_fadd_fmad_f16(ptr addrspace(1) %out, i16 zeroext %x.arg, i16 zeroext %y.arg) #0 {
; VI-DENORM-LABEL: multiple_use_fadd_fmad_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dword s4, s[6:7], 0x8
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_lshr_b32 s3, s4, 16
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s3
; VI-DENORM-NEXT:    v_fma_f16 v3, |s4|, 2.0, v0
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s0
; VI-DENORM-NEXT:    v_add_f16_e64 v2, |s4|, |s4|
; VI-DENORM-NEXT:    s_add_u32 s2, s0, 2
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    s_addc_u32 s3, s1, 0
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s2
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-NEXT:    flat_store_short v[0:1], v3
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: multiple_use_fadd_fmad_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dword s4, s[6:7], 0x8
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_lshr_b32 s3, s4, 16
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s3
; VI-FLUSH-NEXT:    v_mad_f16 v3, |s4|, 2.0, v0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s0
; VI-FLUSH-NEXT:    v_add_f16_e64 v2, |s4|, |s4|
; VI-FLUSH-NEXT:    s_add_u32 s2, s0, 2
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    s_addc_u32 s3, s1, 0
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s2
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v3
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: multiple_use_fadd_fmad_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_clause 0x1
; GFX10-DENORM-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_lshr_b32 s3, s2, 16
; GFX10-DENORM-NEXT:    v_add_f16_e64 v1, |s2|, |s2|
; GFX10-DENORM-NEXT:    v_fma_f16 v2, |s2|, 2.0, s3
; GFX10-DENORM-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[0:1] offset:2
; GFX10-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: multiple_use_fadd_fmad_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_clause 0x1
; GFX10-FLUSH-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e64 v0, |s2|, |s2|
; GFX10-FLUSH-NEXT:    s_lshr_b32 s2, s2, 16
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v2, s2, v0
; GFX10-FLUSH-NEXT:    global_store_short v1, v0, s[0:1]
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    global_store_short v1, v2, s[0:1] offset:2
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: multiple_use_fadd_fmad_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_clause 0x1
; GFX11-DENORM-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_lshr_b32 s2, s4, 16
; GFX11-DENORM-NEXT:    v_add_f16_e64 v1, |s4|, |s4|
; GFX11-DENORM-NEXT:    v_fma_f16 v2, |s4|, 2.0, s2
; GFX11-DENORM-NEXT:    global_store_b16 v0, v1, s[0:1] dlc
; GFX11-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[0:1] offset:2 dlc
; GFX11-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: multiple_use_fadd_fmad_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_clause 0x1
; GFX11-FLUSH-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e64 v0, |s4|, |s4|
; GFX11-FLUSH-NEXT:    s_lshr_b32 s2, s4, 16
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v2, s2, v0
; GFX11-FLUSH-NEXT:    global_store_b16 v1, v0, s[0:1] dlc
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    global_store_b16 v1, v2, s[0:1] offset:2 dlc
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
  %x = bitcast i16 %x.arg to half
  %y = bitcast i16 %y.arg to half
  %out.gep.1 = getelementptr half, ptr addrspace(1) %out, i32 1
  %x.abs = call half @llvm.fabs.f16(half %x)
  %mul2 = fmul fast half %x.abs, 2.0
  %mad = fadd fast half %mul2, %y
  store volatile half %mul2, ptr addrspace(1) %out
  store volatile half %mad, ptr addrspace(1) %out.gep.1
  ret void
}

define amdgpu_kernel void @multiple_use_fadd_multi_fmad_f16(ptr addrspace(1) %out, i16 zeroext %x.arg, i16 zeroext %y.arg, i16 zeroext %z.arg) #0 {
; VI-DENORM-LABEL: multiple_use_fadd_multi_fmad_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x8
; VI-DENORM-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; VI-DENORM-NEXT:    s_load_dword s6, s[6:7], 0x8
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_lshr_b32 s0, s0, 16
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s0
; VI-DENORM-NEXT:    v_fma_f16 v2, |s6|, 2.0, v0
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s1
; VI-DENORM-NEXT:    v_fma_f16 v3, |s6|, 2.0, v0
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s2
; VI-DENORM-NEXT:    s_add_u32 s4, s2, 2
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-NEXT:    s_addc_u32 s5, s3, 0
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s4
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s5
; VI-DENORM-NEXT:    flat_store_short v[0:1], v3
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: multiple_use_fadd_multi_fmad_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x8
; VI-FLUSH-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; VI-FLUSH-NEXT:    s_load_dword s6, s[6:7], 0x8
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_lshr_b32 s0, s0, 16
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s0
; VI-FLUSH-NEXT:    v_mad_f16 v2, |s6|, 2.0, v0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s1
; VI-FLUSH-NEXT:    v_mad_f16 v3, |s6|, 2.0, v0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s2
; VI-FLUSH-NEXT:    s_add_u32 s4, s2, 2
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    s_addc_u32 s5, s3, 0
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s4
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s5
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v3
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: multiple_use_fadd_multi_fmad_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_clause 0x2
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x8
; GFX10-DENORM-NEXT:    s_load_dword s4, s[6:7], 0x8
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; GFX10-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_lshr_b32 s0, s0, 16
; GFX10-DENORM-NEXT:    v_fma_f16 v2, |s4|, 2.0, s1
; GFX10-DENORM-NEXT:    v_fma_f16 v1, |s4|, 2.0, s0
; GFX10-DENORM-NEXT:    global_store_short v0, v1, s[2:3]
; GFX10-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[2:3] offset:2
; GFX10-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: multiple_use_fadd_multi_fmad_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_clause 0x2
; GFX10-FLUSH-NEXT:    s_load_dword s4, s[6:7], 0x8
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x8
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; GFX10-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e64 v0, |s4|, |s4|
; GFX10-FLUSH-NEXT:    s_lshr_b32 s0, s0, 16
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v2, s0, v0
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v0, s1, v0
; GFX10-FLUSH-NEXT:    global_store_short v1, v2, s[2:3]
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    global_store_short v1, v0, s[2:3] offset:2
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: multiple_use_fadd_multi_fmad_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_clause 0x2
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x8
; GFX11-DENORM-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-DENORM-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX11-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_lshr_b32 s0, s0, 16
; GFX11-DENORM-NEXT:    v_fma_f16 v2, |s4|, 2.0, s1
; GFX11-DENORM-NEXT:    v_fma_f16 v1, |s4|, 2.0, s0
; GFX11-DENORM-NEXT:    global_store_b16 v0, v1, s[2:3] dlc
; GFX11-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[2:3] offset:2 dlc
; GFX11-DENORM-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: multiple_use_fadd_multi_fmad_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_clause 0x2
; GFX11-FLUSH-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x8
; GFX11-FLUSH-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX11-FLUSH-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e64 v0, |s4|, |s4|
; GFX11-FLUSH-NEXT:    s_lshr_b32 s0, s0, 16
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v2, s0, v0
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v0, s1, v0
; GFX11-FLUSH-NEXT:    global_store_b16 v1, v2, s[2:3] dlc
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    global_store_b16 v1, v0, s[2:3] offset:2 dlc
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
  %x = bitcast i16 %x.arg to half
  %y = bitcast i16 %y.arg to half
  %z = bitcast i16 %z.arg to half
  %out.gep.1 = getelementptr half, ptr addrspace(1) %out, i32 1
  %x.abs = call half @llvm.fabs.f16(half %x)
  %mul2 = fmul fast half %x.abs, 2.0
  %mad0 = fadd fast half %mul2, %y
  %mad1 = fadd fast half %mul2, %z
  store volatile half %mad0, ptr addrspace(1) %out
  store volatile half %mad1, ptr addrspace(1) %out.gep.1
  ret void
}

define amdgpu_kernel void @fmul_x2_xn2_f16(ptr addrspace(1) %out, i16 zeroext %x.arg, i16 zeroext %y.arg) #0 {
; VI-LABEL: fmul_x2_xn2_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[6:7], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e64 v0, s2, -4.0
; VI-NEXT:    v_mul_f16_e32 v2, s2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: fmul_x2_xn2_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e64 v0, s2, -4.0
; GFX10-NEXT:    v_mul_f16_e32 v0, s2, v0
; GFX10-NEXT:    global_store_short v1, v0, s[0:1]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fmul_x2_xn2_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, s4, -4.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v0, s4, v0
; GFX11-NEXT:    global_store_b16 v1, v0, s[0:1] dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %x = bitcast i16 %x.arg to half
  %y = bitcast i16 %y.arg to half
  %out.gep.1 = getelementptr half, ptr addrspace(1) %out, i32 1
  %mul2 = fmul fast half %x, 2.0
  %muln2 = fmul fast half %x, -2.0
  %mul = fmul fast half %mul2, %muln2
  store volatile half %mul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fmul_x2_xn3_f16(ptr addrspace(1) %out, i16 zeroext %x.arg, i16 zeroext %y.arg) #0 {
; VI-LABEL: fmul_x2_xn3_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[6:7], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, 0xc600
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v0, s2, v0
; VI-NEXT:    v_mul_f16_e32 v2, s2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX10-LABEL: fmul_x2_xn3_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s2, s[6:7], 0x8
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e64 v0, 0xc600, s2
; GFX10-NEXT:    v_mul_f16_e32 v0, s2, v0
; GFX10-NEXT:    global_store_short v1, v0, s[0:1]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fmul_x2_xn3_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e64 v0, 0xc600, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v0, s4, v0
; GFX11-NEXT:    global_store_b16 v1, v0, s[0:1] dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %x = bitcast i16 %x.arg to half
  %y = bitcast i16 %y.arg to half
  %out.gep.1 = getelementptr half, ptr addrspace(1) %out, i32 1
  %mul2 = fmul fast half %x, 2.0
  %muln2 = fmul fast half %x, -3.0
  %mul = fmul fast half %mul2, %muln2
  store volatile half %mul, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind "unsafe-fp-math"="true" }
attributes #1 = { nounwind readnone }
