; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; Test complex addresses with base or index truncated from 128 bit.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Shift amount with base truncated from 128 bit to 32 bit.
define void @f1(i128 %x, i32 %y, ptr %px, ptr %py) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    larl %r1, .LCPI0_0
; CHECK-NEXT:    vl %v0, 0(%r2), 3
; CHECK-NEXT:    vl %v1, 0(%r1), 3
; CHECK-NEXT:    vaq %v0, %v0, %v1
; CHECK-NEXT:    vlgvf %r1, %v0, 3
; CHECK-NEXT:    srl %r3, 0(%r1)
; CHECK-NEXT:    vst %v0, 0(%r4), 3
; CHECK-NEXT:    st %r3, 0(%r5)
; CHECK-NEXT:    br %r14
  %x1 = add i128 %x, 1
  store i128 %x1, ptr %px, align 8
  %amt = trunc i128 %x1 to i32
  %y1 = lshr i32 %y, %amt
  store i32 %y1, ptr %py, align 4
  ret void
}

; Memory address with index truncated from 128 bit to 64 bit.
define i8 @f2(ptr %base, ptr %p) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    larl %r1, .LCPI1_0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r1), 3
; CHECK-NEXT:    vaq %v0, %v0, %v1
; CHECK-NEXT:    vlgvg %r1, %v0, 1
; CHECK-NEXT:    vst %v0, 0(%r3), 3
; CHECK-NEXT:    lb %r2, 0(%r1,%r2)
; CHECK-NEXT:    br %r14
  %idx = load i128, ptr %p, align 8
  %inc = add nsw i128 %idx, 1
  store i128 %inc, ptr %p, align 8
  %idxprom = trunc i128 %inc to i64
  %arrayidx = getelementptr inbounds i8, ptr %base, i64 %idxprom
  %res = load i8, ptr %arrayidx, align 1
  ret i8 %res
}
