; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6,GFX6-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GCN,GFX11,GFX11-SDAG %s

; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6,GFX6-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GCN,GFX11,GFX11-GISEL %s

define { half, i32 } @test_frexp_f16_i32(half %a) {
; GFX6-SDAG-LABEL: test_frexp_f16_i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f16_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f16_e32 v2, v0
; GFX8-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX8-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f16_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f16_e32 v2, v0
; GFX9-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX9-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f16_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v1, v0
; GFX11-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f16_i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v1
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  ret { half, i32 } %result
}

define half @test_frexp_f16_i32_only_use_fract(half %a) {
; GFX6-SDAG-LABEL: test_frexp_f16_i32_only_use_fract:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f16_i32_only_use_fract:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f16_i32_only_use_fract:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f16_i32_only_use_fract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f16_i32_only_use_fract:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v1
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 0
  ret half %result.0
}

define i32 @test_frexp_f16_i32_only_use_exp(half %a) {
; GFX6-SDAG-LABEL: test_frexp_f16_i32_only_use_exp:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f16_i32_only_use_exp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f16_i32_only_use_exp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX9-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f16_i32_only_use_exp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f16_i32_only_use_exp:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v1
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x half>, <2 x i32> } @test_frexp_v2f16_v2i32(<2 x half> %a) {
; GFX6-SDAG-LABEL: test_frexp_v2f16_v2i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v0, v2
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v1, v3
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v2|, s4
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v3|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e64 v1, v3, v1, s[4:5]
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v2
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v3, v3
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e64 v3, 0, v3, s[4:5]
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_frexp_v2f16_v2i32:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-SDAG-NEXT:    v_frexp_mant_f16_e32 v1, v0
; GFX8-SDAG-NEXT:    v_frexp_mant_f16_sdwa v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; GFX8-SDAG-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX8-SDAG-NEXT:    v_frexp_exp_i16_f16_e32 v1, v2
; GFX8-SDAG-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX8-SDAG-NEXT:    v_bfe_i32 v2, v1, 0, 16
; GFX8-SDAG-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_frexp_v2f16_v2i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-SDAG-NEXT:    v_frexp_mant_f16_e32 v2, v1
; GFX9-SDAG-NEXT:    v_frexp_mant_f16_e32 v3, v0
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v3, v3, v2
; GFX9-SDAG-NEXT:    v_frexp_exp_i16_f16_e32 v1, v1
; GFX9-SDAG-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX9-SDAG-NEXT:    v_bfe_i32 v2, v1, 0, 16
; GFX9-SDAG-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f16_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_frexp_mant_f16_e32 v2, v0
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_frexp_mant_f16_e32 v3, v1
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v4, v1
; GFX11-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_pack_b32_f16 v0, v2, v3
; GFX11-NEXT:    v_bfe_i32 v2, v4, 0, 16
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_v2f16_v2i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v3
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v4, v1
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, v3
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v5, v1
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v3, 0, v5, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_frexp_v2f16_v2i32:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-GISEL-NEXT:    v_frexp_mant_f16_e32 v3, v0
; GFX8-GISEL-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX8-GISEL-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX8-GISEL-NEXT:    v_frexp_mant_f16_sdwa v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; GFX8-GISEL-NEXT:    v_frexp_exp_i16_f16_e32 v2, v2
; GFX8-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_frexp_v2f16_v2i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-GISEL-NEXT:    v_frexp_mant_f16_e32 v3, v0
; GFX9-GISEL-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX9-GISEL-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX9-GISEL-NEXT:    v_frexp_mant_f16_e32 v0, v2
; GFX9-GISEL-NEXT:    v_frexp_exp_i16_f16_e32 v2, v2
; GFX9-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX9-GISEL-NEXT:    v_pack_b32_f16 v0, v3, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  ret { <2 x half>, <2 x i32> } %result
}

define <2 x half> @test_frexp_v2f16_v2i32_only_use_fract(<2 x half> %a) {
; GFX6-SDAG-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f16_e32 v1, v0
; GFX8-NEXT:    v_frexp_mant_f16_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_frexp_mant_f16_sdwa v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-SDAG-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_frexp_mant_f16_e32 v1, v1
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v3, v1
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, v2
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_frexp_mant_f16_e32 v1, v0
; GFX9-GISEL-NEXT:    v_frexp_mant_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-GISEL-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.0 = extractvalue { <2 x half>, <2 x i32> } %result, 0
  ret <2 x half> %result.0
}

define <2 x i32> @test_frexp_v2f16_v2i32_only_use_exp(<2 x half> %a) {
; GFX6-SDAG-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_frexp_exp_i16_f16_sdwa v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-SDAG-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX8-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX8-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_frexp_exp_i16_f16_sdwa v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-SDAG-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX9-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX9-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v1, v1
; GFX11-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v3, vcc
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, v2
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_frexp_exp_i16_f16_e32 v1, v0
; GFX8-GISEL-NEXT:    v_bfe_i32 v2, v1, 0, 16
; GFX8-GISEL-NEXT:    v_frexp_exp_i16_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-GISEL-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_frexp_exp_i16_f16_e32 v1, v0
; GFX9-GISEL-NEXT:    v_bfe_i32 v2, v1, 0, 16
; GFX9-GISEL-NEXT:    v_frexp_exp_i16_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-GISEL-NEXT:    v_bfe_i32 v1, v0, 0, 16
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.1 = extractvalue { <2 x half>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { half, i16 } @test_frexp_f16_i16(half %a) {
; GFX6-SDAG-LABEL: test_frexp_f16_i16:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f16_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f16_e32 v2, v0
; GFX8-NEXT:    v_frexp_exp_i16_f16_e32 v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f16_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f16_e32 v2, v0
; GFX9-NEXT:    v_frexp_exp_i16_f16_e32 v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f16_i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f16_e32 v2, v0
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f16_i16:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v1
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v3, v0
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { half, i16 } @llvm.frexp.f16.i16(half %a)
  ret { half, i16 } %result
}

define half @test_frexp_f16_i16_only_use_fract(half %a) {
; GFX6-SDAG-LABEL: test_frexp_f16_i16_only_use_fract:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f16_i16_only_use_fract:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f16_i16_only_use_fract:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f16_i16_only_use_fract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f16_i16_only_use_fract:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v1
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { half, i16 } @llvm.frexp.f16.i16(half %a)
  %result.0 = extractvalue { half, i16 } %result, 0
  ret half %result.0
}

define i16 @test_frexp_f16_i16_only_use_exp(half %a) {
; GFX6-SDAG-LABEL: test_frexp_f16_i16_only_use_exp:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f16_i16_only_use_exp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f16_i16_only_use_exp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f16_i16_only_use_exp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_exp_i16_f16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f16_i16_only_use_exp:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v1, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v1
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { half, i16 } @llvm.frexp.f16.i16(half %a)
  %result.0 = extractvalue { half, i16 } %result, 1
  ret i16 %result.0
}

; define { <2 x half>, <2 x i16> } @test_frexp_v2f16_v2i16(<2 x half> %a) {
;   %result = call { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half> %a)
;   ret { <2 x half>, <2 x i16> } %result
; }

; define <2 x half> @test_frexp_v2f16_v2i16_only_use_fract(<2 x half> %a) {
;   %result = call { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half> %a)
;   %result.0 = extractvalue { <2 x half>, <2 x i16> } %result, 0
;   ret <2 x half> %result.0
; }

; define <2 x i16> @test_frexp_v2f16_v2i16_only_use_exp(<2 x half> %a) {
;   %result = call { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half> %a)
;   %result.1 = extractvalue { <2 x half>, <2 x i16> } %result, 1
;   ret <2 x i16> %result.1
; }

define { float, i32 } @test_frexp_f32_i32(float %a) {
; GFX6-SDAG-LABEL: test_frexp_f32_i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v0, v2
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f32_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f32_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX9-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f32_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f32_i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v3
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define float @test_frexp_f32_i32_only_use_fract(float %a) {
; GFX6-SDAG-LABEL: test_frexp_f32_i32_only_use_fract:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f32_i32_only_use_fract:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f32_i32_only_use_fract:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f32_i32_only_use_fract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f32_i32_only_use_fract:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v1, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 0
  ret float %result.0
}

define i32 @test_frexp_f32_i32_only_use_exp(float %a) {
; GFX6-SDAG-LABEL: test_frexp_f32_i32_only_use_exp:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f32_i32_only_use_exp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f32_i32_only_use_exp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f32_i32_only_use_exp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f32_i32_only_use_exp:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v1, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x float>, <2 x i32> } @test_frexp_v2f32_v2i32(<2 x float> %a) {
; GFX6-SDAG-LABEL: test_frexp_v2f32_v2i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v4, v0, v2, vcc
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v1|, s4
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cndmask_b32_e64 v5, v1, v2, s[4:5]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v2, 0, v0, vcc
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v0, v1
; GFX6-SDAG-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[4:5]
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v0, v4
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v1, v5
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_frexp_v2f32_v2i32:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX8-SDAG-NEXT:    v_frexp_mant_f32_e32 v5, v1
; GFX8-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX8-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_frexp_v2f32_v2i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX9-SDAG-NEXT:    v_frexp_mant_f32_e32 v5, v1
; GFX9-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX9-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f32_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v4, v0
; GFX11-NEXT:    v_frexp_mant_f32_e32 v5, v1
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_v2f32_v2i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v3, v0
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v4
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v5, v1
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, v4
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v3, 0, v3, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_frexp_v2f32_v2i32:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_frexp_mant_f32_e32 v5, v0
; GFX8-GISEL-NEXT:    v_frexp_mant_f32_e32 v4, v1
; GFX8-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX8-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v0, v5
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, v4
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_frexp_v2f32_v2i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_frexp_mant_f32_e32 v5, v0
; GFX9-GISEL-NEXT:    v_frexp_mant_f32_e32 v4, v1
; GFX9-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX9-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v3, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, v5
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  ret { <2 x float>, <2 x i32> } %result
}

define <2 x float> @test_frexp_v2f32_v2i32_only_use_fract(<2 x float> %a) {
; GFX6-SDAG-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-SDAG-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX8-NEXT:    v_frexp_mant_f32_e32 v1, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX9-NEXT:    v_frexp_mant_f32_e32 v1, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f32_e32 v0, v0
; GFX11-NEXT:    v_frexp_mant_f32_e32 v1, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v3
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-GISEL-NEXT:    v_frexp_mant_f32_e32 v2, v1
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, v3
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.0 = extractvalue { <2 x float>, <2 x i32> } %result, 0
  ret <2 x float> %result.0
}

define <2 x i32> @test_frexp_v2f32_v2i32_only_use_exp(<2 x float> %a) {
; GFX6-SDAG-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0x7f800000
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f32_e32 v2, v1
; GFX6-SDAG-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, s4
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX8-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX9-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; GFX11-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7f800000
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v3
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f32_e32 v2, v1
; GFX6-GISEL-NEXT:    v_cmp_lt_f32_e64 vcc, |v1|, v3
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.1 = extractvalue { <2 x float>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { double, i32 } @test_frexp_f64_i32(double %a) {
; GFX6-SDAG-LABEL: test_frexp_f64_i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX6-SDAG-NEXT:    s_mov_b32 s5, 0x7ff00000
; GFX6-SDAG-NEXT:    v_frexp_mant_f64_e32 v[3:4], v[0:1]
; GFX6-SDAG-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v3, v0, v3, vcc
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f64_e32 v0, v[0:1]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v2, 0, v0, vcc
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f64_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f64_e32 v[3:4], v[0:1]
; GFX8-NEXT:    v_frexp_exp_i32_f64_e32 v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v1, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f64_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f64_e32 v[3:4], v[0:1]
; GFX9-NEXT:    v_frexp_exp_i32_f64_e32 v2, v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f64_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f64_e32 v[3:4], v[0:1]
; GFX11-NEXT:    v_frexp_exp_i32_f64_e32 v2, v[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_dual_mov_b32 v0, v3 :: v_dual_mov_b32 v1, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f64_i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v5, 0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v6, 0x7ff00000
; GFX6-GISEL-NEXT:    v_frexp_mant_f64_e32 v[3:4], v[0:1]
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f64_e32 v2, v[0:1]
; GFX6-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, v[5:6]
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  ret { double, i32 } %result
}

define double @test_frexp_f64_i32_only_use_fract(double %a) {
; GFX6-SDAG-LABEL: test_frexp_f64_i32_only_use_fract:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX6-SDAG-NEXT:    s_mov_b32 s5, 0x7ff00000
; GFX6-SDAG-NEXT:    v_frexp_mant_f64_e32 v[2:3], v[0:1]
; GFX6-SDAG-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f64_i32_only_use_fract:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f64_e32 v[0:1], v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f64_i32_only_use_fract:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f64_e32 v[0:1], v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f64_i32_only_use_fract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f64_e32 v[0:1], v[0:1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f64_i32_only_use_fract:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7ff00000
; GFX6-GISEL-NEXT:    v_frexp_mant_f64_e32 v[4:5], v[0:1]
; GFX6-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, v[2:3]
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 0
  ret double %result.0
}

define i32 @test_frexp_f64_i32_only_use_exp(double %a) {
; GFX6-SDAG-LABEL: test_frexp_f64_i32_only_use_exp:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX6-SDAG-NEXT:    s_mov_b32 s5, 0x7ff00000
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f64_e32 v2, v[0:1]
; GFX6-SDAG-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_f64_i32_only_use_exp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i32_f64_e32 v0, v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_f64_i32_only_use_exp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_exp_i32_f64_e32 v0, v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_f64_i32_only_use_exp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_exp_i32_f64_e32 v0, v[0:1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_f64_i32_only_use_exp:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7ff00000
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f64_e32 v4, v[0:1]
; GFX6-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, v[2:3]
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v4, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x double>, <2 x i32> } @test_frexp_v2f64_v2i32(<2 x double> %a) {
; GFX6-SDAG-LABEL: test_frexp_v2f64_v2i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX6-SDAG-NEXT:    s_mov_b32 s5, 0x7ff00000
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f64_e32 v4, v[0:1]
; GFX6-SDAG-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; GFX6-SDAG-NEXT:    v_frexp_exp_i32_f64_e32 v5, v[2:3]
; GFX6-SDAG-NEXT:    v_frexp_mant_f64_e32 v[6:7], v[0:1]
; GFX6-SDAG-NEXT:    v_cmp_lt_f64_e64 s[4:5], |v[2:3]|, s[4:5]
; GFX6-SDAG-NEXT:    v_frexp_mant_f64_e32 v[8:9], v[2:3]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e64 v5, 0, v5, s[4:5]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc
; GFX6-SDAG-NEXT:    v_cndmask_b32_e64 v2, v2, v8, s[4:5]
; GFX6-SDAG-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[4:5]
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_v2f64_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f64_e32 v[8:9], v[0:1]
; GFX8-NEXT:    v_frexp_mant_f64_e32 v[6:7], v[2:3]
; GFX8-NEXT:    v_frexp_exp_i32_f64_e32 v4, v[0:1]
; GFX8-NEXT:    v_frexp_exp_i32_f64_e32 v5, v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v0, v8
; GFX8-NEXT:    v_mov_b32_e32 v1, v9
; GFX8-NEXT:    v_mov_b32_e32 v2, v6
; GFX8-NEXT:    v_mov_b32_e32 v3, v7
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_v2f64_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f64_e32 v[8:9], v[0:1]
; GFX9-NEXT:    v_frexp_mant_f64_e32 v[6:7], v[2:3]
; GFX9-NEXT:    v_frexp_exp_i32_f64_e32 v4, v[0:1]
; GFX9-NEXT:    v_frexp_exp_i32_f64_e32 v5, v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v1, v9
; GFX9-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-NEXT:    v_mov_b32_e32 v3, v7
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f64_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f64_e32 v[8:9], v[0:1]
; GFX11-NEXT:    v_frexp_mant_f64_e32 v[6:7], v[2:3]
; GFX11-NEXT:    v_frexp_exp_i32_f64_e32 v4, v[0:1]
; GFX11-NEXT:    v_frexp_exp_i32_f64_e32 v5, v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_dual_mov_b32 v0, v8 :: v_dual_mov_b32 v1, v9
; GFX11-NEXT:    v_dual_mov_b32 v2, v6 :: v_dual_mov_b32 v3, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_frexp_v2f64_v2i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    s_mov_b32 s4, 0
; GFX6-GISEL-NEXT:    s_mov_b32 s5, 0x7ff00000
; GFX6-GISEL-NEXT:    v_frexp_mant_f64_e32 v[5:6], v[0:1]
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f64_e32 v4, v[0:1]
; GFX6-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX6-GISEL-NEXT:    v_frexp_mant_f64_e32 v[6:7], v[2:3]
; GFX6-GISEL-NEXT:    v_frexp_exp_i32_f64_e32 v5, v[2:3]
; GFX6-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[2:3]|, s[4:5]
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v5, 0, v5, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX6-GISEL-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  ret { <2 x double>, <2 x i32> } %result
}

define <2 x double> @test_frexp_v2f64_v2i32_only_use_fract(<2 x double> %a) {
; GFX6-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    s_mov_b32 s5, 0x7ff00000
; GFX6-NEXT:    v_frexp_mant_f64_e32 v[4:5], v[0:1]
; GFX6-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX6-NEXT:    v_frexp_mant_f64_e32 v[4:5], v[2:3]
; GFX6-NEXT:    v_cmp_lt_f64_e64 vcc, |v[2:3]|, s[4:5]
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_mant_f64_e32 v[0:1], v[0:1]
; GFX8-NEXT:    v_frexp_mant_f64_e32 v[2:3], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_mant_f64_e32 v[0:1], v[0:1]
; GFX9-NEXT:    v_frexp_mant_f64_e32 v[2:3], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_mant_f64_e32 v[0:1], v[0:1]
; GFX11-NEXT:    v_frexp_mant_f64_e32 v[2:3], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.0 = extractvalue { <2 x double>, <2 x i32> } %result, 0
  ret <2 x double> %result.0
}

define <2 x i32> @test_frexp_v2f64_v2i32_only_use_exp(<2 x double> %a) {
; GFX6-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    s_mov_b32 s5, 0x7ff00000
; GFX6-NEXT:    v_frexp_exp_i32_f64_e32 v4, v[0:1]
; GFX6-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; GFX6-NEXT:    v_frexp_exp_i32_f64_e32 v1, v[2:3]
; GFX6-NEXT:    v_cndmask_b32_e32 v0, 0, v4, vcc
; GFX6-NEXT:    v_cmp_lt_f64_e64 vcc, |v[2:3]|, s[4:5]
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_frexp_exp_i32_f64_e32 v0, v[0:1]
; GFX8-NEXT:    v_frexp_exp_i32_f64_e32 v1, v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_frexp_exp_i32_f64_e32 v0, v[0:1]
; GFX9-NEXT:    v_frexp_exp_i32_f64_e32 v1, v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_frexp_exp_i32_f64_e32 v0, v[0:1]
; GFX11-NEXT:    v_frexp_exp_i32_f64_e32 v1, v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.1 = extractvalue { <2 x double>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

declare { float, i32 } @llvm.frexp.f32.i32(float) #0
declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>) #0

declare { half, i32 } @llvm.frexp.f16.i32(half) #0
declare { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half>) #0

declare { double, i32 } @llvm.frexp.f64.i32(double) #0
declare { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double>) #0

declare { half, i16 } @llvm.frexp.f16.i16(half) #0
declare { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half>) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
; GFX11-GISEL: {{.*}}
; GFX11-SDAG: {{.*}}
