; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+ssse3 | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.2 | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx | FileCheck %s --check-prefixes=CHECK,AVX
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,AVX
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,AVX512
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=CHECK,AVX256
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq | FileCheck %s --check-prefixes=CHECK,AVX512
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=CHECK,AVX256
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw | FileCheck %s --check-prefixes=CHECK,AVX512
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=CHECK,AVX256
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mcpu=slm | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mcpu=goldmont | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mtriple=x86_64-apple-macosx10.8.0 -mcpu=btver2 | FileCheck %s --check-prefixes=CHECK,AVX

define i32 @trunc_vXi32() "min-legal-vector-width"="256" {
; CHECK-LABEL: 'trunc_vXi32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i32
  %V2i64 = trunc <2 x i64> undef to <2 x i32>
  %V4i64 = trunc <4 x i64> undef to <4 x i32>
  %V8i64 = trunc <8 x i64> undef to <8 x i32>
  %V16i64 = trunc <16 x i64> undef to <16 x i32>
  ret i32 undef
}

define i32 @trunc_vXi16() "min-legal-vector-width"="256" {
; CHECK-LABEL: 'trunc_vXi16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i16
  %V2i64 = trunc <2 x i64> undef to <2 x i16>
  %V3i64 = trunc <3 x i64> undef to <3 x i16>
  %V4i64 = trunc <4 x i64> undef to <4 x i16>
  %V5i64 = trunc <5 x i64> undef to <5 x i16>
  %V6i64 = trunc <6 x i64> undef to <6 x i16>
  %V7i64 = trunc <7 x i64> undef to <7 x i16>
  %V8i64 = trunc <8 x i64> undef to <8 x i16>
  %V10i64 = trunc <10 x i64> undef to <10 x i16>
  %V12i64 = trunc <12 x i64> undef to <12 x i16>
  %V14i64 = trunc <14 x i64> undef to <14 x i16>
  %V16i64 = trunc <16 x i64> undef to <16 x i16>
  %V20i64 = trunc <20 x i64> undef to <20 x i16>
  %V24i64 = trunc <24 x i64> undef to <24 x i16>
  %V28i64 = trunc <28 x i64> undef to <28 x i16>
  %V32i64 = trunc <32 x i64> undef to <32 x i16>
  %V40i64 = trunc <40 x i64> undef to <40 x i16>
  %V48i64 = trunc <48 x i64> undef to <48 x i16>
  %V56i64 = trunc <56 x i64> undef to <56 x i16>
  %V64i64 = trunc <64 x i64> undef to <64 x i16>
  %V80i64 = trunc <80 x i64> undef to <80 x i16>
  %V96i64 = trunc <96 x i64> undef to <96 x i16>
  %V112i64 = trunc <112 x i64> undef to <112 x i16>
  %V128i64 = trunc <128 x i64> undef to <128 x i16>
  %V160i64 = trunc <160 x i64> undef to <160 x i16>
  %V192i64 = trunc <192 x i64> undef to <192 x i16>
  %V224i64 = trunc <224 x i64> undef to <224 x i16>
  %V256i64 = trunc <256 x i64> undef to <256 x i16>
  %V320i64 = trunc <320 x i64> undef to <320 x i16>
  %V384i64 = trunc <384 x i64> undef to <384 x i16>
  %V448i64 = trunc <448 x i64> undef to <448 x i16>
  %V512i64 = trunc <512 x i64> undef to <512 x i16>

  %i32 = trunc i32 undef to i16
  %V2i32 = trunc <2 x i32> undef to <2 x i16>
  %V3i32 = trunc <3 x i32> undef to <3 x i16>
  %V4i32 = trunc <4 x i32> undef to <4 x i16>
  %V5i32 = trunc <5 x i32> undef to <5 x i16>
  %V6i32 = trunc <6 x i32> undef to <6 x i16>
  %V7i32 = trunc <7 x i32> undef to <7 x i16>
  %V8i32 = trunc <8 x i32> undef to <8 x i16>
  %V10i32 = trunc <10 x i32> undef to <10 x i16>
  %V12i32 = trunc <12 x i32> undef to <12 x i16>
  %V14i32 = trunc <14 x i32> undef to <14 x i16>
  %V16i32 = trunc <16 x i32> undef to <16 x i16>
  %V20i32 = trunc <20 x i32> undef to <20 x i16>
  %V24i32 = trunc <24 x i32> undef to <24 x i16>
  %V28i32 = trunc <28 x i32> undef to <28 x i16>
  %V32i32 = trunc <32 x i32> undef to <32 x i16>
  %V40i32 = trunc <40 x i32> undef to <40 x i16>
  %V48i32 = trunc <48 x i32> undef to <48 x i16>
  %V56i32 = trunc <56 x i32> undef to <56 x i16>
  %V64i32 = trunc <64 x i32> undef to <64 x i16>
  %V80i32 = trunc <80 x i32> undef to <80 x i16>
  %V96i32 = trunc <96 x i32> undef to <96 x i16>
  %V112i32 = trunc <112 x i32> undef to <112 x i16>
  %V128i32 = trunc <128 x i32> undef to <128 x i16>
  %V160i32 = trunc <160 x i32> undef to <160 x i16>
  %V192i32 = trunc <192 x i32> undef to <192 x i16>
  %V224i32 = trunc <224 x i32> undef to <224 x i16>
  %V256i32 = trunc <256 x i32> undef to <256 x i16>
  %V320i32 = trunc <320 x i32> undef to <320 x i16>
  %V384i32 = trunc <384 x i32> undef to <384 x i16>
  %V448i32 = trunc <448 x i32> undef to <448 x i16>
  %V512i32 = trunc <512 x i32> undef to <512 x i16>

  ret i32 undef
}

define i32 @trunc_vXi8() "min-legal-vector-width"="256" {
; CHECK-LABEL: 'trunc_vXi8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i8
  %V2i64 = trunc <2 x i64> undef to <2 x i8>
  %V4i64 = trunc <4 x i64> undef to <4 x i8>
  %V6i64 = trunc <6 x i64> undef to <6 x i8>
  %V8i64 = trunc <8 x i64> undef to <8 x i8>
  %V10i64 = trunc <10 x i64> undef to <10 x i8>
  %V12i64 = trunc <12 x i64> undef to <12 x i8>
  %V14i64 = trunc <14 x i64> undef to <14 x i8>
  %V16i64 = trunc <16 x i64> undef to <16 x i8>
  %V20i64 = trunc <20 x i64> undef to <20 x i8>
  %V24i64 = trunc <24 x i64> undef to <24 x i8>
  %V28i64 = trunc <28 x i64> undef to <28 x i8>
  %V32i64 = trunc <32 x i64> undef to <32 x i8>
  %V40i64 = trunc <40 x i64> undef to <40 x i8>
  %V48i64 = trunc <48 x i64> undef to <48 x i8>
  %V56i64 = trunc <56 x i64> undef to <56 x i8>
  %V64i64 = trunc <64 x i64> undef to <64 x i8>
  %V80i64 = trunc <80 x i64> undef to <80 x i8>
  %V96i64 = trunc <96 x i64> undef to <96 x i8>
  %V112i64 = trunc <112 x i64> undef to <112 x i8>
  %V128i64 = trunc <128 x i64> undef to <128 x i8>
  %V160i64 = trunc <160 x i64> undef to <160 x i8>
  %V192i64 = trunc <192 x i64> undef to <192 x i8>
  %V224i64 = trunc <224 x i64> undef to <224 x i8>
  %V256i64 = trunc <256 x i64> undef to <256 x i8>
  %V320i64 = trunc <320 x i64> undef to <320 x i8>
  %V384i64 = trunc <384 x i64> undef to <384 x i8>
  %V448i64 = trunc <448 x i64> undef to <448 x i8>
  %V512i64 = trunc <512 x i64> undef to <512 x i8>
  %V640i64 = trunc <640 x i64> undef to <640 x i8>
  %V768i64 = trunc <768 x i64> undef to <768 x i8>
  %V896i64 = trunc <896 x i64> undef to <896 x i8>
  %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>

  %i32 = trunc i32 undef to i8
  %V2i32 = trunc <2 x i32> undef to <2 x i8>
  %V4i32 = trunc <4 x i32> undef to <4 x i8>
  %V6i32 = trunc <6 x i32> undef to <6 x i8>
  %V8i32 = trunc <8 x i32> undef to <8 x i8>
  %V10i32 = trunc <10 x i32> undef to <10 x i8>
  %V12i32 = trunc <12 x i32> undef to <12 x i8>
  %V14i32 = trunc <14 x i32> undef to <14 x i8>
  %V16i32 = trunc <16 x i32> undef to <16 x i8>
  %V20i32 = trunc <20 x i32> undef to <20 x i8>
  %V24i32 = trunc <24 x i32> undef to <24 x i8>
  %V28i32 = trunc <28 x i32> undef to <28 x i8>
  %V32i32 = trunc <32 x i32> undef to <32 x i8>
  %V40i32 = trunc <40 x i32> undef to <40 x i8>
  %V48i32 = trunc <48 x i32> undef to <48 x i8>
  %V56i32 = trunc <56 x i32> undef to <56 x i8>
  %V64i32 = trunc <64 x i32> undef to <64 x i8>
  %V80i32 = trunc <80 x i32> undef to <80 x i8>
  %V96i32 = trunc <96 x i32> undef to <96 x i8>
  %V112i32 = trunc <112 x i32> undef to <112 x i8>
  %V128i32 = trunc <128 x i32> undef to <128 x i8>
  %V160i32 = trunc <160 x i32> undef to <160 x i8>
  %V192i32 = trunc <192 x i32> undef to <192 x i8>
  %V224i32 = trunc <224 x i32> undef to <224 x i8>
  %V256i32 = trunc <256 x i32> undef to <256 x i8>
  %V320i32 = trunc <320 x i32> undef to <320 x i8>
  %V384i32 = trunc <384 x i32> undef to <384 x i8>
  %V448i32 = trunc <448 x i32> undef to <448 x i8>
  %V512i32 = trunc <512 x i32> undef to <512 x i8>
  %V640i32 = trunc <640 x i32> undef to <640 x i8>
  %V768i32 = trunc <768 x i32> undef to <768 x i8>
  %V896i32 = trunc <896 x i32> undef to <896 x i8>
  %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>

  %i16 = trunc i16 undef to i8
  %V2i16 = trunc <2 x i16> undef to <2 x i8>
  %V4i16 = trunc <4 x i16> undef to <4 x i8>
  %V6i16 = trunc <6 x i16> undef to <6 x i8>
  %V8i16 = trunc <8 x i16> undef to <8 x i8>
  %V10i16 = trunc <10 x i16> undef to <10 x i8>
  %V12i16 = trunc <12 x i16> undef to <12 x i8>
  %V14i16 = trunc <14 x i16> undef to <14 x i8>
  %V16i16 = trunc <16 x i16> undef to <16 x i8>
  %V20i16 = trunc <20 x i16> undef to <20 x i8>
  %V24i16 = trunc <24 x i16> undef to <24 x i8>
  %V28i16 = trunc <28 x i16> undef to <28 x i8>
  %V32i16 = trunc <32 x i16> undef to <32 x i8>
  %V40i16 = trunc <40 x i16> undef to <40 x i8>
  %V48i16 = trunc <48 x i16> undef to <48 x i8>
  %V56i16 = trunc <56 x i16> undef to <56 x i8>
  %V64i16 = trunc <64 x i16> undef to <64 x i8>
  %V80i16 = trunc <80 x i16> undef to <80 x i8>
  %V96i16 = trunc <96 x i16> undef to <96 x i8>
  %V112i16 = trunc <112 x i16> undef to <112 x i8>
  %V128i16 = trunc <128 x i16> undef to <128 x i8>
  %V160i16 = trunc <160 x i16> undef to <160 x i8>
  %V192i16 = trunc <192 x i16> undef to <192 x i8>
  %V224i16 = trunc <224 x i16> undef to <224 x i8>
  %V256i16 = trunc <256 x i16> undef to <256 x i8>
  %V320i16 = trunc <320 x i16> undef to <320 x i8>
  %V384i16 = trunc <384 x i16> undef to <384 x i8>
  %V448i16 = trunc <448 x i16> undef to <448 x i8>
  %V512i16 = trunc <512 x i16> undef to <512 x i8>
  %V640i16 = trunc <640 x i16> undef to <640 x i8>
  %V768i16 = trunc <768 x i16> undef to <768 x i8>
  %V896i16 = trunc <896 x i16> undef to <896 x i8>
  %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>

  ret i32 undef
}

define i32 @trunc_vXi1() "min-legal-vector-width"="256" {
; SSE-LABEL: 'trunc_vXi1'
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'trunc_vXi1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i1
  %V2i64 = trunc <2 x i64> undef to <2 x i1>
  %V3i64 = trunc <3 x i64> undef to <3 x i1>
  %V4i64 = trunc <4 x i64> undef to <4 x i1>
  %V5i64 = trunc <5 x i64> undef to <5 x i1>
  %V6i64 = trunc <6 x i64> undef to <6 x i1>
  %V7i64 = trunc <7 x i64> undef to <7 x i1>
  %V8i64 = trunc <8 x i64> undef to <8 x i1>
  %V10i64 = trunc <10 x i64> undef to <10 x i1>
  %V12i64 = trunc <12 x i64> undef to <12 x i1>
  %V14i64 = trunc <14 x i64> undef to <14 x i1>
  %V16i64 = trunc <16 x i64> undef to <16 x i1>
  %V20i64 = trunc <20 x i64> undef to <20 x i1>
  %V24i64 = trunc <24 x i64> undef to <24 x i1>
  %V28i64 = trunc <28 x i64> undef to <28 x i1>
  %V32i64 = trunc <32 x i64> undef to <32 x i1>
  %V40i64 = trunc <40 x i64> undef to <40 x i1>
  %V48i64 = trunc <48 x i64> undef to <48 x i1>
  %V56i64 = trunc <56 x i64> undef to <56 x i1>
  %V64i64 = trunc <64 x i64> undef to <64 x i1>
  %V80i64 = trunc <80 x i64> undef to <80 x i1>
  %V112i64 = trunc <112 x i64> undef to <112 x i1>
  %V128i64 = trunc <128 x i64> undef to <128 x i1>
  %V160i64 = trunc <160 x i64> undef to <160 x i1>
  %V192i64 = trunc <192 x i64> undef to <192 x i1>
  %V224i64 = trunc <224 x i64> undef to <224 x i1>
  %V256i64 = trunc <256 x i64> undef to <256 x i1>
  %V320i64 = trunc <320 x i64> undef to <320 x i1>
  %V384i64 = trunc <384 x i64> undef to <384 x i1>
  %V448i64 = trunc <448 x i64> undef to <448 x i1>
  %V512i64 = trunc <512 x i64> undef to <512 x i1>
  %V640i64 = trunc <640 x i64> undef to <640 x i1>
  %V768i64 = trunc <768 x i64> undef to <768 x i1>
  %V896i64 = trunc <896 x i64> undef to <896 x i1>
  %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>

  %i32 = trunc i32 undef to i1
  %V2i32 = trunc <2 x i32> undef to <2 x i1>
  %V3i32 = trunc <3 x i32> undef to <3 x i1>
  %V4i32 = trunc <4 x i32> undef to <4 x i1>
  %V5i32 = trunc <5 x i32> undef to <5 x i1>
  %V6i32 = trunc <6 x i32> undef to <6 x i1>
  %V7i32 = trunc <7 x i32> undef to <7 x i1>
  %V8i32 = trunc <8 x i32> undef to <8 x i1>
  %V10i32 = trunc <10 x i32> undef to <10 x i1>
  %V12i32 = trunc <12 x i32> undef to <12 x i1>
  %V14i32 = trunc <14 x i32> undef to <14 x i1>
  %V16i32 = trunc <16 x i32> undef to <16 x i1>
  %V20i32 = trunc <20 x i32> undef to <20 x i1>
  %V24i32 = trunc <24 x i32> undef to <24 x i1>
  %V28i32 = trunc <28 x i32> undef to <28 x i1>
  %V32i32 = trunc <32 x i32> undef to <32 x i1>
  %V40i32 = trunc <40 x i32> undef to <40 x i1>
  %V48i32 = trunc <48 x i32> undef to <48 x i1>
  %V56i32 = trunc <56 x i32> undef to <56 x i1>
  %V64i32 = trunc <64 x i32> undef to <64 x i1>
  %V80i32 = trunc <80 x i32> undef to <80 x i1>
  %V112i32 = trunc <112 x i32> undef to <112 x i1>
  %V128i32 = trunc <128 x i32> undef to <128 x i1>
  %V160i32 = trunc <160 x i32> undef to <160 x i1>
  %V192i32 = trunc <192 x i32> undef to <192 x i1>
  %V224i32 = trunc <224 x i32> undef to <224 x i1>
  %V256i32 = trunc <256 x i32> undef to <256 x i1>
  %V320i32 = trunc <320 x i32> undef to <320 x i1>
  %V384i32 = trunc <384 x i32> undef to <384 x i1>
  %V448i32 = trunc <448 x i32> undef to <448 x i1>
  %V512i32 = trunc <512 x i32> undef to <512 x i1>
  %V640i32 = trunc <640 x i32> undef to <640 x i1>
  %V768i32 = trunc <768 x i32> undef to <768 x i1>
  %V896i32 = trunc <896 x i32> undef to <896 x i1>
  %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>

  %i16 = trunc i16 undef to i1
  %V2i16 = trunc <2 x i16> undef to <2 x i1>
  %V3i16 = trunc <3 x i16> undef to <3 x i1>
  %V4i16 = trunc <4 x i16> undef to <4 x i1>
  %V5i16 = trunc <5 x i16> undef to <5 x i1>
  %V6i16 = trunc <6 x i16> undef to <6 x i1>
  %V7i16 = trunc <7 x i16> undef to <7 x i1>
  %V8i16 = trunc <8 x i16> undef to <8 x i1>
  %V10i16 = trunc <10 x i16> undef to <10 x i1>
  %V12i16 = trunc <12 x i16> undef to <12 x i1>
  %V14i16 = trunc <14 x i16> undef to <14 x i1>
  %V16i16 = trunc <16 x i16> undef to <16 x i1>
  %V20i16 = trunc <20 x i16> undef to <20 x i1>
  %V24i16 = trunc <24 x i16> undef to <24 x i1>
  %V28i16 = trunc <28 x i16> undef to <28 x i1>
  %V32i16 = trunc <32 x i16> undef to <32 x i1>
  %V40i16 = trunc <40 x i16> undef to <40 x i1>
  %V48i16 = trunc <48 x i16> undef to <48 x i1>
  %V56i16 = trunc <56 x i16> undef to <56 x i1>
  %V64i16 = trunc <64 x i16> undef to <64 x i1>
  %V80i16 = trunc <80 x i16> undef to <80 x i1>
  %V112i16 = trunc <112 x i16> undef to <112 x i1>
  %V128i16 = trunc <128 x i16> undef to <128 x i1>
  %V160i16 = trunc <160 x i16> undef to <160 x i1>
  %V192i16 = trunc <192 x i16> undef to <192 x i1>
  %V224i16 = trunc <224 x i16> undef to <224 x i1>
  %V256i16 = trunc <256 x i16> undef to <256 x i1>
  %V320i16 = trunc <320 x i16> undef to <320 x i1>
  %V384i16 = trunc <384 x i16> undef to <384 x i1>
  %V448i16 = trunc <448 x i16> undef to <448 x i1>
  %V512i16 = trunc <512 x i16> undef to <512 x i1>
  %V640i16 = trunc <640 x i16> undef to <640 x i1>
  %V768i16 = trunc <768 x i16> undef to <768 x i1>
  %V896i16 = trunc <896 x i16> undef to <896 x i1>
  %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>

  %i8 = trunc i8 undef to i1
  %V2i8 = trunc <2 x i8> undef to <2 x i1>
  %V3i8 = trunc <3 x i8> undef to <3 x i1>
  %V4i8 = trunc <4 x i8> undef to <4 x i1>
  %V5i8 = trunc <5 x i8> undef to <5 x i1>
  %V6i8 = trunc <6 x i8> undef to <6 x i1>
  %V7i8 = trunc <7 x i8> undef to <7 x i1>
  %V8i8 = trunc <8 x i8> undef to <8 x i1>
  %V10i8 = trunc <10 x i8> undef to <10 x i1>
  %V12i8 = trunc <12 x i8> undef to <12 x i1>
  %V14i8 = trunc <14 x i8> undef to <14 x i1>
  %V16i8 = trunc <16 x i8> undef to <16 x i1>
  %V20i8 = trunc <20 x i8> undef to <20 x i1>
  %V24i8 = trunc <24 x i8> undef to <24 x i1>
  %V28i8 = trunc <28 x i8> undef to <28 x i1>
  %V32i8 = trunc <32 x i8> undef to <32 x i1>
  %V40i8 = trunc <40 x i8> undef to <40 x i1>
  %V48i8 = trunc <48 x i8> undef to <48 x i1>
  %V56i8 = trunc <56 x i8> undef to <56 x i1>
  %V64i8 = trunc <64 x i8> undef to <64 x i1>
  %V80i8 = trunc <80 x i8> undef to <80 x i1>
  %V112i8 = trunc <112 x i8> undef to <112 x i1>
  %V128i8 = trunc <128 x i8> undef to <128 x i1>
  %V160i8 = trunc <160 x i8> undef to <160 x i1>
  %V192i8 = trunc <192 x i8> undef to <192 x i1>
  %V224i8 = trunc <224 x i8> undef to <224 x i1>
  %V256i8 = trunc <256 x i8> undef to <256 x i1>
  %V320i8 = trunc <320 x i8> undef to <320 x i1>
  %V384i8 = trunc <384 x i8> undef to <384 x i1>
  %V448i8 = trunc <448 x i8> undef to <448 x i1>
  %V512i8 = trunc <512 x i8> undef to <512 x i1>
  %V640i8 = trunc <640 x i8> undef to <640 x i1>
  %V768i8 = trunc <768 x i8> undef to <768 x i1>
  %V896i8 = trunc <896 x i8> undef to <896 x i1>
  %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>

  ret i32 undef
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX256: {{.*}}
; AVX512: {{.*}}
